
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_dns.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/dnsp.h"
static PyTypeObject dns_name_question_Type;
static PyTypeObject dns_rdata_data_Type;
static PyTypeObject dns_soa_record_Type;
static PyTypeObject dns_mx_record_Type;
static PyTypeObject dns_txt_record_Type;
static PyTypeObject dns_rp_record_Type;
static PyTypeObject dns_srv_record_Type;
static PyTypeObject dns_opt_record_Type;
static PyTypeObject dns_tkey_record_Type;
static PyTypeObject dns_tsig_record_Type;
static PyTypeObject dns_fake_tsig_rec_Type;
static PyTypeObject dns_rdata_Type;
static PyTypeObject dns_res_rec_Type;
static PyTypeObject dns_name_packet_Type;
static PyTypeObject dns_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *dnsp_string_list_Type;
static PyTypeObject *dnsp_hinfo_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_dns_name_question_get_name(PyObject *obj, void *closure)
{
	struct dns_name_question *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_dns_name_question_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_question *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_name_question_get_question_type(PyObject *obj, void *closure)
{
	struct dns_name_question *object = pytalloc_get_ptr(obj);
	PyObject *py_question_type;
	py_question_type = PyLong_FromLong((uint16_t)(object->question_type));
	return py_question_type;
}

static int py_dns_name_question_set_question_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_question *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->question_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->question_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->question_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_question_get_question_class(PyObject *obj, void *closure)
{
	struct dns_name_question *object = pytalloc_get_ptr(obj);
	PyObject *py_question_class;
	py_question_class = PyLong_FromLong((uint16_t)(object->question_class));
	return py_question_class;
}

static int py_dns_name_question_set_question_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_question *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->question_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->question_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->question_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dns_name_question_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_dns_name_question_get_name,
		.set = py_dns_name_question_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "question_type"),
		.get = py_dns_name_question_get_question_type,
		.set = py_dns_name_question_set_question_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_qtype")
	},
	{
		.name = discard_const_p(char, "question_class"),
		.get = py_dns_name_question_get_question_class,
		.set = py_dns_name_question_set_question_class,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_qclass")
	},
	{ .name = NULL }
};

static PyObject *py_dns_name_question_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_name_question, type);
}

static PyObject *py_dns_name_question_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_name_question *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_name_question);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_name_question_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_name_question *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_name_question);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_name_question);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_name_question_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_name_question *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_name_question, "dns_name_question", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_name_question_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_name_question_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_name_question_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_name_question_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_name_question_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.name_question",
	.tp_getset = py_dns_name_question_getsetters,
	.tp_methods = py_dns_name_question_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_name_question_new,
};


static PyObject *py_dns_rdata_data_get_length(PyObject *obj, void *closure)
{
	struct dns_rdata_data *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_dns_rdata_data_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_rdata_data *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_rdata_data_get_data(PyObject *obj, void *closure)
{
	struct dns_rdata_data *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->length);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->length); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_dns_rdata_data_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_rdata_data *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dns_rdata_data_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_dns_rdata_data_get_length,
		.set = py_dns_rdata_data_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_dns_rdata_data_get_data,
		.set = py_dns_rdata_data_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dns_rdata_data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_rdata_data, type);
}

static PyObject *py_dns_rdata_data_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_rdata_data *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_rdata_data);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_rdata_data_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_rdata_data *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_rdata_data);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_rdata_data);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_rdata_data_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_rdata_data *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_rdata_data, "dns_rdata_data", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_rdata_data_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_rdata_data_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_rdata_data_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_rdata_data_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_rdata_data_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.rdata_data",
	.tp_getset = py_dns_rdata_data_getsetters,
	.tp_methods = py_dns_rdata_data_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_rdata_data_new,
};


static PyObject *py_dns_soa_record_get_mname(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_mname;
	py_mname = PyString_FromStringOrNULL(object->mname);
	return py_mname;
}

static int py_dns_soa_record_set_mname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->mname");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mname = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_soa_record_get_rname(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_rname;
	py_rname = PyString_FromStringOrNULL(object->rname);
	return py_rname;
}

static int py_dns_soa_record_set_rname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rname");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->rname = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_soa_record_get_serial(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_serial;
	py_serial = PyLong_FromUnsignedLongLong((uint32_t)(object->serial));
	return py_serial;
}

static int py_dns_soa_record_set_serial(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->serial");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_soa_record_get_refresh(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_refresh;
	py_refresh = PyLong_FromUnsignedLongLong((uint32_t)(object->refresh));
	return py_refresh;
}

static int py_dns_soa_record_set_refresh(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->refresh");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->refresh));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->refresh = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_soa_record_get_retry(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_retry;
	py_retry = PyLong_FromUnsignedLongLong((uint32_t)(object->retry));
	return py_retry;
}

static int py_dns_soa_record_set_retry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->retry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->retry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->retry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_soa_record_get_expire(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_expire;
	py_expire = PyLong_FromUnsignedLongLong((uint32_t)(object->expire));
	return py_expire;
}

static int py_dns_soa_record_set_expire(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->expire");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->expire));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->expire = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_soa_record_get_minimum(PyObject *obj, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(obj);
	PyObject *py_minimum;
	py_minimum = PyLong_FromUnsignedLongLong((uint32_t)(object->minimum));
	return py_minimum;
}

static int py_dns_soa_record_set_minimum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_soa_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->minimum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->minimum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->minimum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dns_soa_record_getsetters[] = {
	{
		.name = discard_const_p(char, "mname"),
		.get = py_dns_soa_record_get_mname,
		.set = py_dns_soa_record_set_mname,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "rname"),
		.get = py_dns_soa_record_get_rname,
		.set = py_dns_soa_record_set_rname,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "serial"),
		.get = py_dns_soa_record_get_serial,
		.set = py_dns_soa_record_set_serial,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "refresh"),
		.get = py_dns_soa_record_get_refresh,
		.set = py_dns_soa_record_set_refresh,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "retry"),
		.get = py_dns_soa_record_get_retry,
		.set = py_dns_soa_record_set_retry,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "expire"),
		.get = py_dns_soa_record_get_expire,
		.set = py_dns_soa_record_set_expire,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "minimum"),
		.get = py_dns_soa_record_get_minimum,
		.set = py_dns_soa_record_set_minimum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dns_soa_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_soa_record, type);
}


static PyTypeObject dns_soa_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.soa_record",
	.tp_getset = py_dns_soa_record_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_soa_record_new,
};


static PyObject *py_dns_mx_record_get_preference(PyObject *obj, void *closure)
{
	struct dns_mx_record *object = pytalloc_get_ptr(obj);
	PyObject *py_preference;
	py_preference = PyLong_FromLong((uint16_t)(object->preference));
	return py_preference;
}

static int py_dns_mx_record_set_preference(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_mx_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->preference");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->preference));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->preference = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_mx_record_get_exchange(PyObject *obj, void *closure)
{
	struct dns_mx_record *object = pytalloc_get_ptr(obj);
	PyObject *py_exchange;
	py_exchange = PyString_FromStringOrNULL(object->exchange);
	return py_exchange;
}

static int py_dns_mx_record_set_exchange(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_mx_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->exchange");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->exchange = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dns_mx_record_getsetters[] = {
	{
		.name = discard_const_p(char, "preference"),
		.get = py_dns_mx_record_get_preference,
		.set = py_dns_mx_record_set_preference,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "exchange"),
		.get = py_dns_mx_record_get_exchange,
		.set = py_dns_mx_record_set_exchange,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{ .name = NULL }
};

static PyObject *py_dns_mx_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_mx_record, type);
}

static PyObject *py_dns_mx_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_mx_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_mx_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_mx_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_mx_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_mx_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_mx_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_mx_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_mx_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_mx_record, "dns_mx_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_mx_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_mx_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_mx_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_mx_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_mx_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.mx_record",
	.tp_getset = py_dns_mx_record_getsetters,
	.tp_methods = py_dns_mx_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_mx_record_new,
};


static PyObject *py_dns_txt_record_get_txt(PyObject *obj, void *closure)
{
	struct dns_txt_record *object = pytalloc_get_ptr(obj);
	PyObject *py_txt;
	py_txt = pytalloc_reference_ex(dnsp_string_list_Type, pytalloc_get_mem_ctx(obj), &object->txt);
	return py_txt;
}

static int py_dns_txt_record_set_txt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_txt_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->txt");
		return -1;
	}
	PY_CHECK_TYPE(dnsp_string_list_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->txt = *(struct dnsp_string_list *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dns_txt_record_getsetters[] = {
	{
		.name = discard_const_p(char, "txt"),
		.get = py_dns_txt_record_get_txt,
		.set = py_dns_txt_record_set_txt,
		.doc = discard_const_p(char, "PIDL-generated element of base type dnsp_string_list")
	},
	{ .name = NULL }
};

static PyObject *py_dns_txt_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_txt_record, type);
}

static PyObject *py_dns_txt_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_txt_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_txt_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_txt_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_txt_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_txt_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_txt_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_txt_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_txt_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_txt_record, "dns_txt_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_txt_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_txt_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_txt_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_txt_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_txt_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.txt_record",
	.tp_getset = py_dns_txt_record_getsetters,
	.tp_methods = py_dns_txt_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_txt_record_new,
};


static PyObject *py_dns_rp_record_get_mbox(PyObject *obj, void *closure)
{
	struct dns_rp_record *object = pytalloc_get_ptr(obj);
	PyObject *py_mbox;
	py_mbox = PyString_FromStringOrNULL(object->mbox);
	return py_mbox;
}

static int py_dns_rp_record_set_mbox(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_rp_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->mbox");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->mbox = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_rp_record_get_txt(PyObject *obj, void *closure)
{
	struct dns_rp_record *object = pytalloc_get_ptr(obj);
	PyObject *py_txt;
	py_txt = PyString_FromStringOrNULL(object->txt);
	return py_txt;
}

static int py_dns_rp_record_set_txt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_rp_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->txt");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->txt = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dns_rp_record_getsetters[] = {
	{
		.name = discard_const_p(char, "mbox"),
		.get = py_dns_rp_record_get_mbox,
		.set = py_dns_rp_record_set_mbox,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "txt"),
		.get = py_dns_rp_record_get_txt,
		.set = py_dns_rp_record_set_txt,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{ .name = NULL }
};

static PyObject *py_dns_rp_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_rp_record, type);
}

static PyObject *py_dns_rp_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_rp_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_rp_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_rp_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_rp_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_rp_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_rp_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_rp_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_rp_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_rp_record, "dns_rp_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_rp_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_rp_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_rp_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_rp_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_rp_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.rp_record",
	.tp_getset = py_dns_rp_record_getsetters,
	.tp_methods = py_dns_rp_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_rp_record_new,
};


static PyObject *py_dns_srv_record_get_priority(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(obj);
	PyObject *py_priority;
	py_priority = PyLong_FromLong((uint16_t)(object->priority));
	return py_priority;
}

static int py_dns_srv_record_set_priority(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->priority");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->priority));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->priority = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_srv_record_get_weight(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(obj);
	PyObject *py_weight;
	py_weight = PyLong_FromLong((uint16_t)(object->weight));
	return py_weight;
}

static int py_dns_srv_record_set_weight(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->weight");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->weight));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->weight = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_srv_record_get_port(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(obj);
	PyObject *py_port;
	py_port = PyLong_FromLong((uint16_t)(object->port));
	return py_port;
}

static int py_dns_srv_record_set_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->port");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->port));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->port = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_srv_record_get_target(PyObject *obj, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(obj);
	PyObject *py_target;
	py_target = PyString_FromStringOrNULL(object->target);
	return py_target;
}

static int py_dns_srv_record_set_target(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->target");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->target = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_dns_srv_record_getsetters[] = {
	{
		.name = discard_const_p(char, "priority"),
		.get = py_dns_srv_record_get_priority,
		.set = py_dns_srv_record_set_priority,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "weight"),
		.get = py_dns_srv_record_get_weight,
		.set = py_dns_srv_record_set_weight,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "port"),
		.get = py_dns_srv_record_get_port,
		.set = py_dns_srv_record_set_port,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "target"),
		.get = py_dns_srv_record_get_target,
		.set = py_dns_srv_record_set_target,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{ .name = NULL }
};

static PyObject *py_dns_srv_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_srv_record, type);
}

static PyObject *py_dns_srv_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_srv_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_srv_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_srv_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_srv_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_srv_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_srv_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_srv_record, "dns_srv_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_srv_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_srv_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_srv_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_srv_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_srv_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.srv_record",
	.tp_getset = py_dns_srv_record_getsetters,
	.tp_methods = py_dns_srv_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_srv_record_new,
};


static PyObject *py_dns_opt_record_get_option_code(PyObject *obj, void *closure)
{
	struct dns_opt_record *object = pytalloc_get_ptr(obj);
	PyObject *py_option_code;
	py_option_code = PyLong_FromLong((uint16_t)(object->option_code));
	return py_option_code;
}

static int py_dns_opt_record_set_option_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_opt_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->option_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->option_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->option_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_opt_record_get_option_length(PyObject *obj, void *closure)
{
	struct dns_opt_record *object = pytalloc_get_ptr(obj);
	PyObject *py_option_length;
	py_option_length = PyLong_FromLong((uint16_t)(object->option_length));
	return py_option_length;
}

static int py_dns_opt_record_set_option_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_opt_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->option_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->option_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->option_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_opt_record_get_option_data(PyObject *obj, void *closure)
{
	struct dns_opt_record *object = pytalloc_get_ptr(obj);
	PyObject *py_option_data;
	py_option_data = PyList_New(object->option_length);
	if (py_option_data == NULL) {
		return NULL;
	}
	{
		int option_data_cntr_0;
		for (option_data_cntr_0 = 0; option_data_cntr_0 < (object->option_length); option_data_cntr_0++) {
			PyObject *py_option_data_0;
			py_option_data_0 = PyLong_FromLong((uint16_t)((object->option_data)[option_data_cntr_0]));
			PyList_SetItem(py_option_data, option_data_cntr_0, py_option_data_0);
		}
	}
	return py_option_data;
}

static int py_dns_opt_record_set_option_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_opt_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->option_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int option_data_cntr_0;
		object->option_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->option_data, PyList_GET_SIZE(value));
		if (!object->option_data) { return -1; }
		talloc_set_name_const(object->option_data, "ARRAY: object->option_data");
		for (option_data_cntr_0 = 0; option_data_cntr_0 < PyList_GET_SIZE(value); option_data_cntr_0++) {
			if (PyList_GET_ITEM(value, option_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->option_data)[option_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->option_data)[option_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, option_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, option_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->option_data)[option_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dns_opt_record_getsetters[] = {
	{
		.name = discard_const_p(char, "option_code"),
		.get = py_dns_opt_record_get_option_code,
		.set = py_dns_opt_record_set_option_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "option_length"),
		.get = py_dns_opt_record_get_option_length,
		.set = py_dns_opt_record_set_option_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "option_data"),
		.get = py_dns_opt_record_get_option_data,
		.set = py_dns_opt_record_set_option_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dns_opt_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_opt_record, type);
}

static PyObject *py_dns_opt_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_opt_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_opt_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_opt_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_opt_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_opt_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_opt_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_opt_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_opt_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_opt_record, "dns_opt_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_opt_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_opt_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_opt_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_opt_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_opt_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.opt_record",
	.tp_getset = py_dns_opt_record_getsetters,
	.tp_methods = py_dns_opt_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_opt_record_new,
};


static PyObject *py_dns_tkey_record_get_algorithm(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_algorithm;
	py_algorithm = PyString_FromStringOrNULL(object->algorithm);
	return py_algorithm;
}

static int py_dns_tkey_record_set_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->algorithm");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->algorithm = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_inception(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_inception;
	py_inception = PyLong_FromUnsignedLongLong((uint32_t)(object->inception));
	return py_inception;
}

static int py_dns_tkey_record_set_inception(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->inception");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->inception));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->inception = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_expiration(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_expiration;
	py_expiration = PyLong_FromUnsignedLongLong((uint32_t)(object->expiration));
	return py_expiration;
}

static int py_dns_tkey_record_set_expiration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->expiration");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->expiration));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->expiration = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_mode(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_mode;
	py_mode = PyLong_FromLong((uint16_t)(object->mode));
	return py_mode;
}

static int py_dns_tkey_record_set_mode(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->mode");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->mode));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->mode = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_error(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_error;
	py_error = PyLong_FromLong((uint16_t)(object->error));
	return py_error;
}

static int py_dns_tkey_record_set_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->error");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->error));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->error = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_key_size(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_key_size;
	py_key_size = PyLong_FromLong((uint16_t)(object->key_size));
	return py_key_size;
}

static int py_dns_tkey_record_set_key_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->key_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->key_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->key_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_key_data(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_key_data;
	py_key_data = PyList_New(object->key_size);
	if (py_key_data == NULL) {
		return NULL;
	}
	{
		int key_data_cntr_0;
		for (key_data_cntr_0 = 0; key_data_cntr_0 < (object->key_size); key_data_cntr_0++) {
			PyObject *py_key_data_0;
			py_key_data_0 = PyLong_FromLong((uint16_t)((object->key_data)[key_data_cntr_0]));
			PyList_SetItem(py_key_data, key_data_cntr_0, py_key_data_0);
		}
	}
	return py_key_data;
}

static int py_dns_tkey_record_set_key_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->key_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int key_data_cntr_0;
		object->key_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->key_data, PyList_GET_SIZE(value));
		if (!object->key_data) { return -1; }
		talloc_set_name_const(object->key_data, "ARRAY: object->key_data");
		for (key_data_cntr_0 = 0; key_data_cntr_0 < PyList_GET_SIZE(value); key_data_cntr_0++) {
			if (PyList_GET_ITEM(value, key_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->key_data)[key_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->key_data)[key_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, key_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, key_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->key_data)[key_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_other_size(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_other_size;
	py_other_size = PyLong_FromLong((uint16_t)(object->other_size));
	return py_other_size;
}

static int py_dns_tkey_record_set_other_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->other_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->other_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tkey_record_get_other_data(PyObject *obj, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(obj);
	PyObject *py_other_data;
	py_other_data = PyList_New(object->other_size);
	if (py_other_data == NULL) {
		return NULL;
	}
	{
		int other_data_cntr_0;
		for (other_data_cntr_0 = 0; other_data_cntr_0 < (object->other_size); other_data_cntr_0++) {
			PyObject *py_other_data_0;
			py_other_data_0 = PyLong_FromLong((uint16_t)((object->other_data)[other_data_cntr_0]));
			PyList_SetItem(py_other_data, other_data_cntr_0, py_other_data_0);
		}
	}
	return py_other_data;
}

static int py_dns_tkey_record_set_other_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int other_data_cntr_0;
		object->other_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->other_data, PyList_GET_SIZE(value));
		if (!object->other_data) { return -1; }
		talloc_set_name_const(object->other_data, "ARRAY: object->other_data");
		for (other_data_cntr_0 = 0; other_data_cntr_0 < PyList_GET_SIZE(value); other_data_cntr_0++) {
			if (PyList_GET_ITEM(value, other_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->other_data)[other_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->other_data)[other_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, other_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, other_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->other_data)[other_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dns_tkey_record_getsetters[] = {
	{
		.name = discard_const_p(char, "algorithm"),
		.get = py_dns_tkey_record_get_algorithm,
		.set = py_dns_tkey_record_set_algorithm,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "inception"),
		.get = py_dns_tkey_record_get_inception,
		.set = py_dns_tkey_record_set_inception,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "expiration"),
		.get = py_dns_tkey_record_get_expiration,
		.set = py_dns_tkey_record_set_expiration,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "mode"),
		.get = py_dns_tkey_record_get_mode,
		.set = py_dns_tkey_record_set_mode,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_tkey_mode")
	},
	{
		.name = discard_const_p(char, "error"),
		.get = py_dns_tkey_record_get_error,
		.set = py_dns_tkey_record_set_error,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "key_size"),
		.get = py_dns_tkey_record_get_key_size,
		.set = py_dns_tkey_record_set_key_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "key_data"),
		.get = py_dns_tkey_record_get_key_data,
		.set = py_dns_tkey_record_set_key_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "other_size"),
		.get = py_dns_tkey_record_get_other_size,
		.set = py_dns_tkey_record_set_other_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "other_data"),
		.get = py_dns_tkey_record_get_other_data,
		.set = py_dns_tkey_record_set_other_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dns_tkey_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_tkey_record, type);
}

static PyObject *py_dns_tkey_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_tkey_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_tkey_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_tkey_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_tkey_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_tkey_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_tkey_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_tkey_record, "dns_tkey_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_tkey_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_tkey_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_tkey_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_tkey_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_tkey_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.tkey_record",
	.tp_getset = py_dns_tkey_record_getsetters,
	.tp_methods = py_dns_tkey_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_tkey_record_new,
};


static PyObject *py_dns_tsig_record_get_algorithm_name(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_algorithm_name;
	py_algorithm_name = PyString_FromStringOrNULL(object->algorithm_name);
	return py_algorithm_name;
}

static int py_dns_tsig_record_set_algorithm_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->algorithm_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->algorithm_name = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_time_prefix(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_time_prefix;
	py_time_prefix = PyLong_FromLong((uint16_t)(object->time_prefix));
	return py_time_prefix;
}

static int py_dns_tsig_record_set_time_prefix(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time_prefix");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time_prefix));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time_prefix = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_time(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_dns_tsig_record_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_fudge(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_fudge;
	py_fudge = PyLong_FromLong((uint16_t)(object->fudge));
	return py_fudge;
}

static int py_dns_tsig_record_set_fudge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->fudge");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fudge));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fudge = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_mac_size(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_mac_size;
	py_mac_size = PyLong_FromLong((uint16_t)(object->mac_size));
	return py_mac_size;
}

static int py_dns_tsig_record_set_mac_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->mac_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->mac_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->mac_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_mac(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_mac;
	py_mac = PyList_New(object->mac_size);
	if (py_mac == NULL) {
		return NULL;
	}
	{
		int mac_cntr_0;
		for (mac_cntr_0 = 0; mac_cntr_0 < (object->mac_size); mac_cntr_0++) {
			PyObject *py_mac_0;
			py_mac_0 = PyLong_FromLong((uint16_t)((object->mac)[mac_cntr_0]));
			PyList_SetItem(py_mac, mac_cntr_0, py_mac_0);
		}
	}
	return py_mac;
}

static int py_dns_tsig_record_set_mac(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->mac");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int mac_cntr_0;
		object->mac = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->mac, PyList_GET_SIZE(value));
		if (!object->mac) { return -1; }
		talloc_set_name_const(object->mac, "ARRAY: object->mac");
		for (mac_cntr_0 = 0; mac_cntr_0 < PyList_GET_SIZE(value); mac_cntr_0++) {
			if (PyList_GET_ITEM(value, mac_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->mac)[mac_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->mac)[mac_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, mac_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, mac_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->mac)[mac_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_original_id(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_original_id;
	py_original_id = PyLong_FromLong((uint16_t)(object->original_id));
	return py_original_id;
}

static int py_dns_tsig_record_set_original_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->original_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->original_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->original_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_error(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_error;
	py_error = PyLong_FromLong((uint16_t)(object->error));
	return py_error;
}

static int py_dns_tsig_record_set_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->error");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->error));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->error = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_other_size(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_other_size;
	py_other_size = PyLong_FromLong((uint16_t)(object->other_size));
	return py_other_size;
}

static int py_dns_tsig_record_set_other_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->other_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->other_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_tsig_record_get_other_data(PyObject *obj, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(obj);
	PyObject *py_other_data;
	py_other_data = PyList_New(object->other_size);
	if (py_other_data == NULL) {
		return NULL;
	}
	{
		int other_data_cntr_0;
		for (other_data_cntr_0 = 0; other_data_cntr_0 < (object->other_size); other_data_cntr_0++) {
			PyObject *py_other_data_0;
			py_other_data_0 = PyLong_FromLong((uint16_t)((object->other_data)[other_data_cntr_0]));
			PyList_SetItem(py_other_data, other_data_cntr_0, py_other_data_0);
		}
	}
	return py_other_data;
}

static int py_dns_tsig_record_set_other_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int other_data_cntr_0;
		object->other_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->other_data, PyList_GET_SIZE(value));
		if (!object->other_data) { return -1; }
		talloc_set_name_const(object->other_data, "ARRAY: object->other_data");
		for (other_data_cntr_0 = 0; other_data_cntr_0 < PyList_GET_SIZE(value); other_data_cntr_0++) {
			if (PyList_GET_ITEM(value, other_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->other_data)[other_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->other_data)[other_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, other_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, other_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->other_data)[other_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dns_tsig_record_getsetters[] = {
	{
		.name = discard_const_p(char, "algorithm_name"),
		.get = py_dns_tsig_record_get_algorithm_name,
		.set = py_dns_tsig_record_set_algorithm_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "time_prefix"),
		.get = py_dns_tsig_record_get_time_prefix,
		.set = py_dns_tsig_record_set_time_prefix,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_dns_tsig_record_get_time,
		.set = py_dns_tsig_record_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fudge"),
		.get = py_dns_tsig_record_get_fudge,
		.set = py_dns_tsig_record_set_fudge,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "mac_size"),
		.get = py_dns_tsig_record_get_mac_size,
		.set = py_dns_tsig_record_set_mac_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "mac"),
		.get = py_dns_tsig_record_get_mac,
		.set = py_dns_tsig_record_set_mac,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "original_id"),
		.get = py_dns_tsig_record_get_original_id,
		.set = py_dns_tsig_record_set_original_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "error"),
		.get = py_dns_tsig_record_get_error,
		.set = py_dns_tsig_record_set_error,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "other_size"),
		.get = py_dns_tsig_record_get_other_size,
		.set = py_dns_tsig_record_set_other_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "other_data"),
		.get = py_dns_tsig_record_get_other_data,
		.set = py_dns_tsig_record_set_other_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dns_tsig_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_tsig_record, type);
}

static PyObject *py_dns_tsig_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_tsig_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_tsig_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_tsig_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_tsig_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_tsig_record_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_tsig_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_tsig_record, "dns_tsig_record", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_tsig_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_tsig_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_tsig_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_tsig_record_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_tsig_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.tsig_record",
	.tp_getset = py_dns_tsig_record_getsetters,
	.tp_methods = py_dns_tsig_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_tsig_record_new,
};


static PyObject *py_dns_fake_tsig_rec_get_name(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_dns_fake_tsig_rec_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_rr_class(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rr_class;
	py_rr_class = PyLong_FromLong((uint16_t)(object->rr_class));
	return py_rr_class;
}

static int py_dns_fake_tsig_rec_set_rr_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rr_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rr_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rr_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_ttl(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyLong_FromUnsignedLongLong((uint32_t)(object->ttl));
	return py_ttl;
}

static int py_dns_fake_tsig_rec_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ttl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ttl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_algorithm_name(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_algorithm_name;
	py_algorithm_name = PyString_FromStringOrNULL(object->algorithm_name);
	return py_algorithm_name;
}

static int py_dns_fake_tsig_rec_set_algorithm_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->algorithm_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->algorithm_name = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_time_prefix(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_time_prefix;
	py_time_prefix = PyLong_FromLong((uint16_t)(object->time_prefix));
	return py_time_prefix;
}

static int py_dns_fake_tsig_rec_set_time_prefix(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time_prefix");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time_prefix));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time_prefix = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_time(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_time;
	py_time = PyLong_FromUnsignedLongLong((uint32_t)(object->time));
	return py_time;
}

static int py_dns_fake_tsig_rec_set_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_fudge(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_fudge;
	py_fudge = PyLong_FromLong((uint16_t)(object->fudge));
	return py_fudge;
}

static int py_dns_fake_tsig_rec_set_fudge(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->fudge");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fudge));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fudge = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_error(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_error;
	py_error = PyLong_FromLong((uint16_t)(object->error));
	return py_error;
}

static int py_dns_fake_tsig_rec_set_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->error");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->error));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->error = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_other_size(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_other_size;
	py_other_size = PyLong_FromLong((uint16_t)(object->other_size));
	return py_other_size;
}

static int py_dns_fake_tsig_rec_set_other_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->other_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->other_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_fake_tsig_rec_get_other_data(PyObject *obj, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_other_data;
	py_other_data = PyList_New(object->other_size);
	if (py_other_data == NULL) {
		return NULL;
	}
	{
		int other_data_cntr_0;
		for (other_data_cntr_0 = 0; other_data_cntr_0 < (object->other_size); other_data_cntr_0++) {
			PyObject *py_other_data_0;
			py_other_data_0 = PyLong_FromLong((uint16_t)((object->other_data)[other_data_cntr_0]));
			PyList_SetItem(py_other_data, other_data_cntr_0, py_other_data_0);
		}
	}
	return py_other_data;
}

static int py_dns_fake_tsig_rec_set_other_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->other_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int other_data_cntr_0;
		object->other_data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->other_data, PyList_GET_SIZE(value));
		if (!object->other_data) { return -1; }
		talloc_set_name_const(object->other_data, "ARRAY: object->other_data");
		for (other_data_cntr_0 = 0; other_data_cntr_0 < PyList_GET_SIZE(value); other_data_cntr_0++) {
			if (PyList_GET_ITEM(value, other_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->other_data)[other_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->other_data)[other_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, other_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, other_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->other_data)[other_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dns_fake_tsig_rec_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_dns_fake_tsig_rec_get_name,
		.set = py_dns_fake_tsig_rec_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "rr_class"),
		.get = py_dns_fake_tsig_rec_get_rr_class,
		.set = py_dns_fake_tsig_rec_set_rr_class,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_qclass")
	},
	{
		.name = discard_const_p(char, "ttl"),
		.get = py_dns_fake_tsig_rec_get_ttl,
		.set = py_dns_fake_tsig_rec_set_ttl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "algorithm_name"),
		.get = py_dns_fake_tsig_rec_get_algorithm_name,
		.set = py_dns_fake_tsig_rec_set_algorithm_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "time_prefix"),
		.get = py_dns_fake_tsig_rec_get_time_prefix,
		.set = py_dns_fake_tsig_rec_set_time_prefix,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "time"),
		.get = py_dns_fake_tsig_rec_get_time,
		.set = py_dns_fake_tsig_rec_set_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "fudge"),
		.get = py_dns_fake_tsig_rec_get_fudge,
		.set = py_dns_fake_tsig_rec_set_fudge,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "error"),
		.get = py_dns_fake_tsig_rec_get_error,
		.set = py_dns_fake_tsig_rec_set_error,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "other_size"),
		.get = py_dns_fake_tsig_rec_get_other_size,
		.set = py_dns_fake_tsig_rec_set_other_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "other_data"),
		.get = py_dns_fake_tsig_rec_get_other_data,
		.set = py_dns_fake_tsig_rec_set_other_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dns_fake_tsig_rec_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_fake_tsig_rec, type);
}

static PyObject *py_dns_fake_tsig_rec_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_fake_tsig_rec);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_fake_tsig_rec_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_fake_tsig_rec);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_fake_tsig_rec);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_fake_tsig_rec_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_fake_tsig_rec *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_fake_tsig_rec, "dns_fake_tsig_rec", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_fake_tsig_rec_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_fake_tsig_rec_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_fake_tsig_rec_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_fake_tsig_rec_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_fake_tsig_rec_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.fake_tsig_rec",
	.tp_getset = py_dns_fake_tsig_rec_getsetters,
	.tp_methods = py_dns_fake_tsig_rec_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_fake_tsig_rec_new,
};

static PyObject *py_import_dns_rdata(TALLOC_CTX *mem_ctx, int level, union dns_rdata *in)
{
	PyObject *ret;

	switch (level) {
		case DNS_QTYPE_A:
			ret = PyString_FromStringOrNULL(in->ipv4_record);
			return ret;

		case DNS_QTYPE_NS:
			ret = PyString_FromStringOrNULL(in->ns_record);
			return ret;

		case DNS_QTYPE_CNAME:
			ret = PyString_FromStringOrNULL(in->cname_record);
			return ret;

		case DNS_QTYPE_SOA:
			ret = pytalloc_reference_ex(&dns_soa_record_Type, mem_ctx, &in->soa_record);
			return ret;

		case DNS_QTYPE_PTR:
			ret = PyString_FromStringOrNULL(in->ptr_record);
			return ret;

		case DNS_QTYPE_HINFO:
			ret = pytalloc_reference_ex(dnsp_hinfo_Type, mem_ctx, &in->hinfo_record);
			return ret;

		case DNS_QTYPE_MX:
			ret = pytalloc_reference_ex(&dns_mx_record_Type, mem_ctx, &in->mx_record);
			return ret;

		case DNS_QTYPE_TXT:
			ret = pytalloc_reference_ex(&dns_txt_record_Type, mem_ctx, &in->txt_record);
			return ret;

		case DNS_QTYPE_RP:
			ret = pytalloc_reference_ex(&dns_rp_record_Type, mem_ctx, &in->rp_record);
			return ret;

		case DNS_QTYPE_AAAA:
			ret = PyString_FromStringOrNULL(in->ipv6_record);
			return ret;

		case DNS_QTYPE_SRV:
			ret = pytalloc_reference_ex(&dns_srv_record_Type, mem_ctx, &in->srv_record);
			return ret;

		case DNS_QTYPE_OPT:
			ret = pytalloc_reference_ex(&dns_opt_record_Type, mem_ctx, &in->opt_record);
			return ret;

		case DNS_QTYPE_TSIG:
			ret = pytalloc_reference_ex(&dns_tsig_record_Type, mem_ctx, &in->tsig_record);
			return ret;

		case DNS_QTYPE_TKEY:
			ret = pytalloc_reference_ex(&dns_tkey_record_Type, mem_ctx, &in->tkey_record);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dns_rdata *py_export_dns_rdata(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dns_rdata *ret = talloc_zero(mem_ctx, union dns_rdata);
	switch (level) {
		case DNS_QTYPE_A:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ipv4_record");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ipv4_record = talloc_str;
			}
			break;

		case DNS_QTYPE_NS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ns_record");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ns_record = talloc_str;
			}
			break;

		case DNS_QTYPE_CNAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->cname_record");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->cname_record = talloc_str;
			}
			break;

		case DNS_QTYPE_SOA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->soa_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_soa_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->soa_record = *(struct dns_soa_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_PTR:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ptr_record");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ptr_record = talloc_str;
			}
			break;

		case DNS_QTYPE_HINFO:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->hinfo_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(dnsp_hinfo_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->hinfo_record = *(struct dnsp_hinfo *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_MX:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->mx_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_mx_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->mx_record = *(struct dns_mx_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_TXT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->txt_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_txt_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->txt_record = *(struct dns_txt_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_RP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->rp_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_rp_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->rp_record = *(struct dns_rp_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_AAAA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->ipv6_record");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ipv6_record = talloc_str;
			}
			break;

		case DNS_QTYPE_SRV:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->srv_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_srv_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->srv_record = *(struct dns_srv_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_OPT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->opt_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_opt_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->opt_record = *(struct dns_opt_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_TSIG:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->tsig_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_tsig_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->tsig_record = *(struct dns_tsig_record *)pytalloc_get_ptr(in);
			break;

		case DNS_QTYPE_TKEY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct ret->tkey_record");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dns_tkey_record_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->tkey_record = *(struct dns_tkey_record *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_dns_rdata_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dns_rdata *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dns_rdata *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dns_rdata!");
		return NULL;
	}

	return py_import_dns_rdata(mem_ctx, level, in);
}

static PyObject *py_dns_rdata_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dns_rdata *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dns_rdata(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dns_rdata_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_rdata_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_rdata_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dns_rdata_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dns_rdata_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.rdata",
	.tp_getset = NULL,
	.tp_methods = py_dns_rdata_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_rdata_new,
};


static PyObject *py_dns_res_rec_get_name(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_dns_res_rec_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_rr_type(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rr_type;
	py_rr_type = PyLong_FromLong((uint16_t)(object->rr_type));
	return py_rr_type;
}

static int py_dns_res_rec_set_rr_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rr_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rr_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rr_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_rr_class(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rr_class;
	py_rr_class = PyLong_FromLong((uint16_t)(object->rr_class));
	return py_rr_class;
}

static int py_dns_res_rec_set_rr_class(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rr_class");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rr_class));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rr_class = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_ttl(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyLong_FromUnsignedLongLong((uint32_t)(object->ttl));
	return py_ttl;
}

static int py_dns_res_rec_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ttl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ttl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_length(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_dns_res_rec_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_rdata(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_rdata;
	py_rdata = pyrpc_import_union(&dns_rdata_Type, pytalloc_get_mem_ctx(obj), object->rr_type, &object->rdata, "union dns_rdata");
	if (py_rdata == NULL) {
		return NULL;
	}
	return py_rdata;
}

static int py_dns_res_rec_set_rdata(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->rdata");
		return -1;
	}
	{
		union dns_rdata *rdata_switch_0;
		rdata_switch_0 = (union dns_rdata *)pyrpc_export_union(&dns_rdata_Type, pytalloc_get_mem_ctx(py_obj), object->rr_type, value, "union dns_rdata");
		if (rdata_switch_0 == NULL) {
			return -1;
		}
		object->rdata = *rdata_switch_0;
	}
	return 0;
}

static PyObject *py_dns_res_rec_get_unexpected(PyObject *obj, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(obj);
	PyObject *py_unexpected;
	py_unexpected = PyBytes_FromStringAndSize((char *)(object->unexpected).data, (object->unexpected).length);
	return py_unexpected;
}

static int py_dns_res_rec_set_unexpected(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_res_rec *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->unexpected");
		return -1;
	}
	object->unexpected = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dns_res_rec_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_dns_res_rec_get_name,
		.set = py_dns_res_rec_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_string")
	},
	{
		.name = discard_const_p(char, "rr_type"),
		.get = py_dns_res_rec_get_rr_type,
		.set = py_dns_res_rec_set_rr_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_qtype")
	},
	{
		.name = discard_const_p(char, "rr_class"),
		.get = py_dns_res_rec_get_rr_class,
		.set = py_dns_res_rec_set_rr_class,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_qclass")
	},
	{
		.name = discard_const_p(char, "ttl"),
		.get = py_dns_res_rec_get_ttl,
		.set = py_dns_res_rec_set_ttl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "length"),
		.get = py_dns_res_rec_get_length,
		.set = py_dns_res_rec_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "rdata"),
		.get = py_dns_res_rec_get_rdata,
		.set = py_dns_res_rec_set_rdata,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_rdata")
	},
	{
		.name = discard_const_p(char, "unexpected"),
		.get = py_dns_res_rec_get_unexpected,
		.set = py_dns_res_rec_set_unexpected,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dns_res_rec_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_res_rec, type);
}


static PyTypeObject dns_res_rec_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.res_rec",
	.tp_getset = py_dns_res_rec_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_res_rec_new,
};


static PyObject *py_dns_name_packet_get_id(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyLong_FromLong((uint16_t)(object->id));
	return py_id;
}

static int py_dns_name_packet_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_operation(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_operation;
	py_operation = PyLong_FromLong((uint16_t)(object->operation));
	return py_operation;
}

static int py_dns_name_packet_set_operation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->operation");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->operation));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->operation = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_qdcount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_qdcount;
	py_qdcount = PyLong_FromLong((uint16_t)(object->qdcount));
	return py_qdcount;
}

static int py_dns_name_packet_set_qdcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->qdcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->qdcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->qdcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_ancount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ancount;
	py_ancount = PyLong_FromLong((uint16_t)(object->ancount));
	return py_ancount;
}

static int py_dns_name_packet_set_ancount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->ancount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ancount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ancount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_nscount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_nscount;
	py_nscount = PyLong_FromLong((uint16_t)(object->nscount));
	return py_nscount;
}

static int py_dns_name_packet_set_nscount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->nscount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nscount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nscount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_arcount(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_arcount;
	py_arcount = PyLong_FromLong((uint16_t)(object->arcount));
	return py_arcount;
}

static int py_dns_name_packet_set_arcount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->arcount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->arcount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->arcount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_questions(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_questions;
	py_questions = PyList_New(object->qdcount);
	if (py_questions == NULL) {
		return NULL;
	}
	{
		int questions_cntr_0;
		for (questions_cntr_0 = 0; questions_cntr_0 < (object->qdcount); questions_cntr_0++) {
			PyObject *py_questions_0;
			py_questions_0 = pytalloc_reference_ex(&dns_name_question_Type, object->questions, &(object->questions)[questions_cntr_0]);
			PyList_SetItem(py_questions, questions_cntr_0, py_questions_0);
		}
	}
	return py_questions;
}

static int py_dns_name_packet_set_questions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->questions");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int questions_cntr_0;
		object->questions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->questions, PyList_GET_SIZE(value));
		if (!object->questions) { return -1; }
		talloc_set_name_const(object->questions, "ARRAY: object->questions");
		for (questions_cntr_0 = 0; questions_cntr_0 < PyList_GET_SIZE(value); questions_cntr_0++) {
			if (PyList_GET_ITEM(value, questions_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->questions)[questions_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dns_name_question_Type, PyList_GET_ITEM(value, questions_cntr_0), return -1;);
			if (talloc_reference(object->questions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, questions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->questions)[questions_cntr_0] = *(struct dns_name_question *)pytalloc_get_ptr(PyList_GET_ITEM(value, questions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_answers(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_answers;
	py_answers = PyList_New(object->ancount);
	if (py_answers == NULL) {
		return NULL;
	}
	{
		int answers_cntr_0;
		for (answers_cntr_0 = 0; answers_cntr_0 < (object->ancount); answers_cntr_0++) {
			PyObject *py_answers_0;
			py_answers_0 = pytalloc_reference_ex(&dns_res_rec_Type, object->answers, &(object->answers)[answers_cntr_0]);
			PyList_SetItem(py_answers, answers_cntr_0, py_answers_0);
		}
	}
	return py_answers;
}

static int py_dns_name_packet_set_answers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->answers");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int answers_cntr_0;
		object->answers = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->answers, PyList_GET_SIZE(value));
		if (!object->answers) { return -1; }
		talloc_set_name_const(object->answers, "ARRAY: object->answers");
		for (answers_cntr_0 = 0; answers_cntr_0 < PyList_GET_SIZE(value); answers_cntr_0++) {
			if (PyList_GET_ITEM(value, answers_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->answers)[answers_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dns_res_rec_Type, PyList_GET_ITEM(value, answers_cntr_0), return -1;);
			if (talloc_reference(object->answers, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, answers_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->answers)[answers_cntr_0] = *(struct dns_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, answers_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_nsrecs(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_nsrecs;
	py_nsrecs = PyList_New(object->nscount);
	if (py_nsrecs == NULL) {
		return NULL;
	}
	{
		int nsrecs_cntr_0;
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < (object->nscount); nsrecs_cntr_0++) {
			PyObject *py_nsrecs_0;
			py_nsrecs_0 = pytalloc_reference_ex(&dns_res_rec_Type, object->nsrecs, &(object->nsrecs)[nsrecs_cntr_0]);
			PyList_SetItem(py_nsrecs, nsrecs_cntr_0, py_nsrecs_0);
		}
	}
	return py_nsrecs;
}

static int py_dns_name_packet_set_nsrecs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->nsrecs");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int nsrecs_cntr_0;
		object->nsrecs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->nsrecs, PyList_GET_SIZE(value));
		if (!object->nsrecs) { return -1; }
		talloc_set_name_const(object->nsrecs, "ARRAY: object->nsrecs");
		for (nsrecs_cntr_0 = 0; nsrecs_cntr_0 < PyList_GET_SIZE(value); nsrecs_cntr_0++) {
			if (PyList_GET_ITEM(value, nsrecs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->nsrecs)[nsrecs_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dns_res_rec_Type, PyList_GET_ITEM(value, nsrecs_cntr_0), return -1;);
			if (talloc_reference(object->nsrecs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, nsrecs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->nsrecs)[nsrecs_cntr_0] = *(struct dns_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, nsrecs_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dns_name_packet_get_additional(PyObject *obj, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_additional;
	py_additional = PyList_New(object->arcount);
	if (py_additional == NULL) {
		return NULL;
	}
	{
		int additional_cntr_0;
		for (additional_cntr_0 = 0; additional_cntr_0 < (object->arcount); additional_cntr_0++) {
			PyObject *py_additional_0;
			py_additional_0 = pytalloc_reference_ex(&dns_res_rec_Type, object->additional, &(object->additional)[additional_cntr_0]);
			PyList_SetItem(py_additional, additional_cntr_0, py_additional_0);
		}
	}
	return py_additional;
}

static int py_dns_name_packet_set_additional(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->additional");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int additional_cntr_0;
		object->additional = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->additional, PyList_GET_SIZE(value));
		if (!object->additional) { return -1; }
		talloc_set_name_const(object->additional, "ARRAY: object->additional");
		for (additional_cntr_0 = 0; additional_cntr_0 < PyList_GET_SIZE(value); additional_cntr_0++) {
			if (PyList_GET_ITEM(value, additional_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->additional)[additional_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dns_res_rec_Type, PyList_GET_ITEM(value, additional_cntr_0), return -1;);
			if (talloc_reference(object->additional, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, additional_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->additional)[additional_cntr_0] = *(struct dns_res_rec *)pytalloc_get_ptr(PyList_GET_ITEM(value, additional_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dns_name_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "id"),
		.get = py_dns_name_packet_get_id,
		.set = py_dns_name_packet_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "operation"),
		.get = py_dns_name_packet_get_operation,
		.set = py_dns_name_packet_set_operation,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_operation")
	},
	{
		.name = discard_const_p(char, "qdcount"),
		.get = py_dns_name_packet_get_qdcount,
		.set = py_dns_name_packet_set_qdcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ancount"),
		.get = py_dns_name_packet_get_ancount,
		.set = py_dns_name_packet_set_ancount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "nscount"),
		.get = py_dns_name_packet_get_nscount,
		.set = py_dns_name_packet_set_nscount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "arcount"),
		.get = py_dns_name_packet_get_arcount,
		.set = py_dns_name_packet_set_arcount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "questions"),
		.get = py_dns_name_packet_get_questions,
		.set = py_dns_name_packet_set_questions,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_name_question")
	},
	{
		.name = discard_const_p(char, "answers"),
		.get = py_dns_name_packet_get_answers,
		.set = py_dns_name_packet_set_answers,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_res_rec")
	},
	{
		.name = discard_const_p(char, "nsrecs"),
		.get = py_dns_name_packet_get_nsrecs,
		.set = py_dns_name_packet_set_nsrecs,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_res_rec")
	},
	{
		.name = discard_const_p(char, "additional"),
		.get = py_dns_name_packet_get_additional,
		.set = py_dns_name_packet_set_additional,
		.doc = discard_const_p(char, "PIDL-generated element of base type dns_res_rec")
	},
	{ .name = NULL }
};

static PyObject *py_dns_name_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dns_name_packet, type);
}

static PyObject *py_dns_name_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dns_name_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dns_name_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_name_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dns_name_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dns_name_packet_ndr_print(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	struct dns_name_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dns_name_packet, "dns_name_packet", object);
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dns_name_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dns_name_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dns_name_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", (PyCFunction)py_dns_name_packet_ndr_print, METH_NOARGS, "S.ndr_print(object) -> None\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dns_name_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.name_packet",
	.tp_getset = py_dns_name_packet_getsetters,
	.tp_methods = py_dns_name_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dns_name_packet_new,
};


const struct PyNdrRpcMethodDef py_ndr_dns_methods[] = {
	{0}
};

static PyObject *interface_dns_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dns);
}

#define PY_DOC_DNS "DNS records"
static PyTypeObject dns_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.dns",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "dns(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DNS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dns_new,
};

static PyObject *syntax_dns_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_dns.syntax_id);
}

#define PY_DOC_DNS_SYNTAX "DNS records"
static PyTypeObject dns_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dns.dns_abstract_syntax",
	.tp_doc = "dns_abstract_syntax()\n"PY_DOC_DNS_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_dns_new,
};

static PyMethodDef dns_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "dns",
	.m_doc = "dns DCE/RPC",
	.m_size = -1,
	.m_methods = dns_methods,
};
MODULE_INIT_FUNC(dns)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_dnsp = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_dnsp = PyImport_ImportModule("samba.dcerpc.dnsp");
	if (dep_samba_dcerpc_dnsp == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dnsp_string_list_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_dnsp, "string_list");
	if (dnsp_string_list_Type == NULL)
		goto out;

	dnsp_hinfo_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_dnsp, "hinfo");
	if (dnsp_hinfo_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	dns_name_question_Type.tp_base = BaseObject_Type;
	dns_name_question_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_rdata_data_Type.tp_base = BaseObject_Type;
	dns_rdata_data_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_soa_record_Type.tp_base = BaseObject_Type;
	dns_soa_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_mx_record_Type.tp_base = BaseObject_Type;
	dns_mx_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_txt_record_Type.tp_base = BaseObject_Type;
	dns_txt_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_rp_record_Type.tp_base = BaseObject_Type;
	dns_rp_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_srv_record_Type.tp_base = BaseObject_Type;
	dns_srv_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_opt_record_Type.tp_base = BaseObject_Type;
	dns_opt_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_tkey_record_Type.tp_base = BaseObject_Type;
	dns_tkey_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_tsig_record_Type.tp_base = BaseObject_Type;
	dns_tsig_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_fake_tsig_rec_Type.tp_base = BaseObject_Type;
	dns_fake_tsig_rec_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_rdata_Type.tp_base = BaseObject_Type;
	dns_rdata_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_res_rec_Type.tp_base = BaseObject_Type;
	dns_res_rec_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_name_packet_Type.tp_base = BaseObject_Type;
	dns_name_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	dns_InterfaceType.tp_base = ClientConnection_Type;

	dns_SyntaxType.tp_base = ndr_syntax_id_Type;
	dns_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&dns_name_question_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_rdata_data_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_soa_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_mx_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_txt_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_rp_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_srv_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_opt_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_tkey_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_tsig_record_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_fake_tsig_rec_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_rdata_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_res_rec_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_name_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&dns_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&dns_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&dns_InterfaceType, py_ndr_dns_methods))
		return NULL;

#ifdef PY_NAME_QUESTION_PATCH
	PY_NAME_QUESTION_PATCH(&dns_name_question_Type);
#endif
#ifdef PY_RDATA_DATA_PATCH
	PY_RDATA_DATA_PATCH(&dns_rdata_data_Type);
#endif
#ifdef PY_SOA_RECORD_PATCH
	PY_SOA_RECORD_PATCH(&dns_soa_record_Type);
#endif
#ifdef PY_MX_RECORD_PATCH
	PY_MX_RECORD_PATCH(&dns_mx_record_Type);
#endif
#ifdef PY_TXT_RECORD_PATCH
	PY_TXT_RECORD_PATCH(&dns_txt_record_Type);
#endif
#ifdef PY_RP_RECORD_PATCH
	PY_RP_RECORD_PATCH(&dns_rp_record_Type);
#endif
#ifdef PY_SRV_RECORD_PATCH
	PY_SRV_RECORD_PATCH(&dns_srv_record_Type);
#endif
#ifdef PY_OPT_RECORD_PATCH
	PY_OPT_RECORD_PATCH(&dns_opt_record_Type);
#endif
#ifdef PY_TKEY_RECORD_PATCH
	PY_TKEY_RECORD_PATCH(&dns_tkey_record_Type);
#endif
#ifdef PY_TSIG_RECORD_PATCH
	PY_TSIG_RECORD_PATCH(&dns_tsig_record_Type);
#endif
#ifdef PY_FAKE_TSIG_REC_PATCH
	PY_FAKE_TSIG_REC_PATCH(&dns_fake_tsig_rec_Type);
#endif
#ifdef PY_RDATA_PATCH
	PY_RDATA_PATCH(&dns_rdata_Type);
#endif
#ifdef PY_RES_REC_PATCH
	PY_RES_REC_PATCH(&dns_res_rec_Type);
#endif
#ifdef PY_NAME_PACKET_PATCH
	PY_NAME_PACKET_PATCH(&dns_name_packet_Type);
#endif
#ifdef PY_DNS_PATCH
	PY_DNS_PATCH(&dns_InterfaceType);
#endif
#ifdef PY_DNS_ABSTRACT_SYNTAX_PATCH
	PY_DNS_ABSTRACT_SYNTAX_PATCH(&dns_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&dns_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "DNS_SERVICE_PORT", PyLong_FromUnsignedLongLong(53));
	PyModule_AddObject(m, "DNS_MAX_LABELS", PyLong_FromUnsignedLongLong(127));
	PyModule_AddObject(m, "DNS_MAX_DOMAIN_LENGTH", PyLong_FromUnsignedLongLong(253));
	PyModule_AddObject(m, "DNS_MAX_LABEL_LENGTH", PyLong_FromUnsignedLongLong(63));
	PyModule_AddObject(m, "DNS_RCODE", PyLong_FromLong((uint16_t)(DNS_RCODE)));
	PyModule_AddObject(m, "DNS_FLAG_RECURSION_AVAIL", PyLong_FromLong((uint16_t)(DNS_FLAG_RECURSION_AVAIL)));
	PyModule_AddObject(m, "DNS_FLAG_RECURSION_DESIRED", PyLong_FromLong((uint16_t)(DNS_FLAG_RECURSION_DESIRED)));
	PyModule_AddObject(m, "DNS_FLAG_TRUNCATION", PyLong_FromLong((uint16_t)(DNS_FLAG_TRUNCATION)));
	PyModule_AddObject(m, "DNS_FLAG_AUTHORITATIVE", PyLong_FromLong((uint16_t)(DNS_FLAG_AUTHORITATIVE)));
	PyModule_AddObject(m, "DNS_OPCODE", PyLong_FromLong((uint16_t)(DNS_OPCODE)));
	PyModule_AddObject(m, "DNS_FLAG_REPLY", PyLong_FromLong((uint16_t)(DNS_FLAG_REPLY)));
	PyModule_AddObject(m, "DNS_OPCODE_QUERY", PyLong_FromLong((uint16_t)(DNS_OPCODE_QUERY)));
	PyModule_AddObject(m, "DNS_OPCODE_IQUERY", PyLong_FromLong((uint16_t)(DNS_OPCODE_IQUERY)));
	PyModule_AddObject(m, "DNS_OPCODE_STATUS", PyLong_FromLong((uint16_t)(DNS_OPCODE_STATUS)));
	PyModule_AddObject(m, "DNS_OPCODE_UPDATE", PyLong_FromLong((uint16_t)(DNS_OPCODE_UPDATE)));
	PyModule_AddObject(m, "DNS_OPCODE_RELEASE", PyLong_FromLong((uint16_t)(DNS_OPCODE_RELEASE)));
	PyModule_AddObject(m, "DNS_OPCODE_WACK", PyLong_FromLong((uint16_t)(DNS_OPCODE_WACK)));
	PyModule_AddObject(m, "DNS_OPCODE_REFRESH", PyLong_FromLong((uint16_t)(DNS_OPCODE_REFRESH)));
	PyModule_AddObject(m, "DNS_OPCODE_REFRESH2", PyLong_FromLong((uint16_t)(DNS_OPCODE_REFRESH2)));
	PyModule_AddObject(m, "DNS_OPCODE_MULTI_HOME_REG", PyLong_FromLong((uint16_t)(DNS_OPCODE_MULTI_HOME_REG)));
	PyModule_AddObject(m, "DNS_RCODE_OK", PyLong_FromLong((uint16_t)(DNS_RCODE_OK)));
	PyModule_AddObject(m, "DNS_RCODE_FORMERR", PyLong_FromLong((uint16_t)(DNS_RCODE_FORMERR)));
	PyModule_AddObject(m, "DNS_RCODE_SERVFAIL", PyLong_FromLong((uint16_t)(DNS_RCODE_SERVFAIL)));
	PyModule_AddObject(m, "DNS_RCODE_NXDOMAIN", PyLong_FromLong((uint16_t)(DNS_RCODE_NXDOMAIN)));
	PyModule_AddObject(m, "DNS_RCODE_NOTIMP", PyLong_FromLong((uint16_t)(DNS_RCODE_NOTIMP)));
	PyModule_AddObject(m, "DNS_RCODE_REFUSED", PyLong_FromLong((uint16_t)(DNS_RCODE_REFUSED)));
	PyModule_AddObject(m, "DNS_RCODE_YXDOMAIN", PyLong_FromLong((uint16_t)(DNS_RCODE_YXDOMAIN)));
	PyModule_AddObject(m, "DNS_RCODE_YXRRSET", PyLong_FromLong((uint16_t)(DNS_RCODE_YXRRSET)));
	PyModule_AddObject(m, "DNS_RCODE_NXRRSET", PyLong_FromLong((uint16_t)(DNS_RCODE_NXRRSET)));
	PyModule_AddObject(m, "DNS_RCODE_NOTAUTH", PyLong_FromLong((uint16_t)(DNS_RCODE_NOTAUTH)));
	PyModule_AddObject(m, "DNS_RCODE_NOTZONE", PyLong_FromLong((uint16_t)(DNS_RCODE_NOTZONE)));
	PyModule_AddObject(m, "DNS_RCODE_BADSIG", PyLong_FromLong((uint16_t)(DNS_RCODE_BADSIG)));
	PyModule_AddObject(m, "DNS_RCODE_BADKEY", PyLong_FromLong((uint16_t)(DNS_RCODE_BADKEY)));
	PyModule_AddObject(m, "DNS_RCODE_BADTIME", PyLong_FromLong((uint16_t)(DNS_RCODE_BADTIME)));
	PyModule_AddObject(m, "DNS_RCODE_BADMODE", PyLong_FromLong((uint16_t)(DNS_RCODE_BADMODE)));
	PyModule_AddObject(m, "DNS_RCODE_BADNAME", PyLong_FromLong((uint16_t)(DNS_RCODE_BADNAME)));
	PyModule_AddObject(m, "DNS_RCODE_BADALG", PyLong_FromLong((uint16_t)(DNS_RCODE_BADALG)));
	PyModule_AddObject(m, "DNS_QCLASS_IN", PyLong_FromLong((uint16_t)(DNS_QCLASS_IN)));
	PyModule_AddObject(m, "DNS_QCLASS_NONE", PyLong_FromLong((uint16_t)(DNS_QCLASS_NONE)));
	PyModule_AddObject(m, "DNS_QCLASS_ANY", PyLong_FromLong((uint16_t)(DNS_QCLASS_ANY)));
	PyModule_AddObject(m, "DNS_QTYPE_ZERO", PyLong_FromLong((uint16_t)(DNS_QTYPE_ZERO)));
	PyModule_AddObject(m, "DNS_QTYPE_A", PyLong_FromLong((uint16_t)(DNS_QTYPE_A)));
	PyModule_AddObject(m, "DNS_QTYPE_NS", PyLong_FromLong((uint16_t)(DNS_QTYPE_NS)));
	PyModule_AddObject(m, "DNS_QTYPE_MD", PyLong_FromLong((uint16_t)(DNS_QTYPE_MD)));
	PyModule_AddObject(m, "DNS_QTYPE_MF", PyLong_FromLong((uint16_t)(DNS_QTYPE_MF)));
	PyModule_AddObject(m, "DNS_QTYPE_CNAME", PyLong_FromLong((uint16_t)(DNS_QTYPE_CNAME)));
	PyModule_AddObject(m, "DNS_QTYPE_SOA", PyLong_FromLong((uint16_t)(DNS_QTYPE_SOA)));
	PyModule_AddObject(m, "DNS_QTYPE_MB", PyLong_FromLong((uint16_t)(DNS_QTYPE_MB)));
	PyModule_AddObject(m, "DNS_QTYPE_MG", PyLong_FromLong((uint16_t)(DNS_QTYPE_MG)));
	PyModule_AddObject(m, "DNS_QTYPE_MR", PyLong_FromLong((uint16_t)(DNS_QTYPE_MR)));
	PyModule_AddObject(m, "DNS_QTYPE_NULL", PyLong_FromLong((uint16_t)(DNS_QTYPE_NULL)));
	PyModule_AddObject(m, "DNS_QTYPE_WKS", PyLong_FromLong((uint16_t)(DNS_QTYPE_WKS)));
	PyModule_AddObject(m, "DNS_QTYPE_PTR", PyLong_FromLong((uint16_t)(DNS_QTYPE_PTR)));
	PyModule_AddObject(m, "DNS_QTYPE_HINFO", PyLong_FromLong((uint16_t)(DNS_QTYPE_HINFO)));
	PyModule_AddObject(m, "DNS_QTYPE_MINFO", PyLong_FromLong((uint16_t)(DNS_QTYPE_MINFO)));
	PyModule_AddObject(m, "DNS_QTYPE_MX", PyLong_FromLong((uint16_t)(DNS_QTYPE_MX)));
	PyModule_AddObject(m, "DNS_QTYPE_TXT", PyLong_FromLong((uint16_t)(DNS_QTYPE_TXT)));
	PyModule_AddObject(m, "DNS_QTYPE_RP", PyLong_FromLong((uint16_t)(DNS_QTYPE_RP)));
	PyModule_AddObject(m, "DNS_QTYPE_AFSDB", PyLong_FromLong((uint16_t)(DNS_QTYPE_AFSDB)));
	PyModule_AddObject(m, "DNS_QTYPE_X25", PyLong_FromLong((uint16_t)(DNS_QTYPE_X25)));
	PyModule_AddObject(m, "DNS_QTYPE_ISDN", PyLong_FromLong((uint16_t)(DNS_QTYPE_ISDN)));
	PyModule_AddObject(m, "DNS_QTYPE_RT", PyLong_FromLong((uint16_t)(DNS_QTYPE_RT)));
	PyModule_AddObject(m, "DNS_QTYPE_SIG", PyLong_FromLong((uint16_t)(DNS_QTYPE_SIG)));
	PyModule_AddObject(m, "DNS_QTYPE_KEY", PyLong_FromLong((uint16_t)(DNS_QTYPE_KEY)));
	PyModule_AddObject(m, "DNS_QTYPE_AAAA", PyLong_FromLong((uint16_t)(DNS_QTYPE_AAAA)));
	PyModule_AddObject(m, "DNS_QTYPE_LOC", PyLong_FromLong((uint16_t)(DNS_QTYPE_LOC)));
	PyModule_AddObject(m, "DNS_QTYPE_NXT", PyLong_FromLong((uint16_t)(DNS_QTYPE_NXT)));
	PyModule_AddObject(m, "DNS_QTYPE_NETBIOS", PyLong_FromLong((uint16_t)(DNS_QTYPE_NETBIOS)));
	PyModule_AddObject(m, "DNS_QTYPE_SRV", PyLong_FromLong((uint16_t)(DNS_QTYPE_SRV)));
	PyModule_AddObject(m, "DNS_QTYPE_ATMA", PyLong_FromLong((uint16_t)(DNS_QTYPE_ATMA)));
	PyModule_AddObject(m, "DNS_QTYPE_NAPTR", PyLong_FromLong((uint16_t)(DNS_QTYPE_NAPTR)));
	PyModule_AddObject(m, "DNS_QTYPE_CERT", PyLong_FromLong((uint16_t)(DNS_QTYPE_CERT)));
	PyModule_AddObject(m, "DNS_QTYPE_DNAME", PyLong_FromLong((uint16_t)(DNS_QTYPE_DNAME)));
	PyModule_AddObject(m, "DNS_QTYPE_OPT", PyLong_FromLong((uint16_t)(DNS_QTYPE_OPT)));
	PyModule_AddObject(m, "DNS_QTYPE_DS", PyLong_FromLong((uint16_t)(DNS_QTYPE_DS)));
	PyModule_AddObject(m, "DNS_QTYPE_SSHFP", PyLong_FromLong((uint16_t)(DNS_QTYPE_SSHFP)));
	PyModule_AddObject(m, "DNS_QTYPE_IPSECKEY", PyLong_FromLong((uint16_t)(DNS_QTYPE_IPSECKEY)));
	PyModule_AddObject(m, "DNS_QTYPE_RRSIG", PyLong_FromLong((uint16_t)(DNS_QTYPE_RRSIG)));
	PyModule_AddObject(m, "DNS_QTYPE_NSEC", PyLong_FromLong((uint16_t)(DNS_QTYPE_NSEC)));
	PyModule_AddObject(m, "DNS_QTYPE_DNSKEY", PyLong_FromLong((uint16_t)(DNS_QTYPE_DNSKEY)));
	PyModule_AddObject(m, "DNS_QTYPE_DHCID", PyLong_FromLong((uint16_t)(DNS_QTYPE_DHCID)));
	PyModule_AddObject(m, "DNS_QTYPE_NSEC3", PyLong_FromLong((uint16_t)(DNS_QTYPE_NSEC3)));
	PyModule_AddObject(m, "DNS_QTYPE_NSEC3PARAM", PyLong_FromLong((uint16_t)(DNS_QTYPE_NSEC3PARAM)));
	PyModule_AddObject(m, "DNS_QTYPE_TLSA", PyLong_FromLong((uint16_t)(DNS_QTYPE_TLSA)));
	PyModule_AddObject(m, "DNS_QTYPE_CDS", PyLong_FromLong((uint16_t)(DNS_QTYPE_CDS)));
	PyModule_AddObject(m, "DNS_QTYPE_CDNSKEY", PyLong_FromLong((uint16_t)(DNS_QTYPE_CDNSKEY)));
	PyModule_AddObject(m, "DNS_QTYPE_SVCB", PyLong_FromLong((uint16_t)(DNS_QTYPE_SVCB)));
	PyModule_AddObject(m, "DNS_QTYPE_HTTPS", PyLong_FromLong((uint16_t)(DNS_QTYPE_HTTPS)));
	PyModule_AddObject(m, "DNS_QTYPE_TKEY", PyLong_FromLong((uint16_t)(DNS_QTYPE_TKEY)));
	PyModule_AddObject(m, "DNS_QTYPE_TSIG", PyLong_FromLong((uint16_t)(DNS_QTYPE_TSIG)));
	PyModule_AddObject(m, "DNS_QTYPE_IXFR", PyLong_FromLong((uint16_t)(DNS_QTYPE_IXFR)));
	PyModule_AddObject(m, "DNS_QTYPE_AXFR", PyLong_FromLong((uint16_t)(DNS_QTYPE_AXFR)));
	PyModule_AddObject(m, "DNS_QTYPE_MAILB", PyLong_FromLong((uint16_t)(DNS_QTYPE_MAILB)));
	PyModule_AddObject(m, "DNS_QTYPE_MAILA", PyLong_FromLong((uint16_t)(DNS_QTYPE_MAILA)));
	PyModule_AddObject(m, "DNS_QTYPE_ALL", PyLong_FromLong((uint16_t)(DNS_QTYPE_ALL)));
	PyModule_AddObject(m, "DNS_QTYPE_URI", PyLong_FromLong((uint16_t)(DNS_QTYPE_URI)));
	PyModule_AddObject(m, "DNS_QTYPE_CAA", PyLong_FromLong((uint16_t)(DNS_QTYPE_CAA)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_NULL", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_NULL)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_SERVER", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_SERVER)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_DH", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_DH)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_GSSAPI", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_GSSAPI)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_CLIENT", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_CLIENT)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_DELETE", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_DELETE)));
	PyModule_AddObject(m, "DNS_TKEY_MODE_LAST", PyLong_FromLong((uint16_t)(DNS_TKEY_MODE_LAST)));
	Py_INCREF((PyObject *)(void *)&dns_name_question_Type);
	PyModule_AddObject(m, "name_question", (PyObject *)(void *)&dns_name_question_Type);
	Py_INCREF((PyObject *)(void *)&dns_rdata_data_Type);
	PyModule_AddObject(m, "rdata_data", (PyObject *)(void *)&dns_rdata_data_Type);
	Py_INCREF((PyObject *)(void *)&dns_soa_record_Type);
	PyModule_AddObject(m, "soa_record", (PyObject *)(void *)&dns_soa_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_mx_record_Type);
	PyModule_AddObject(m, "mx_record", (PyObject *)(void *)&dns_mx_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_txt_record_Type);
	PyModule_AddObject(m, "txt_record", (PyObject *)(void *)&dns_txt_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_rp_record_Type);
	PyModule_AddObject(m, "rp_record", (PyObject *)(void *)&dns_rp_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_srv_record_Type);
	PyModule_AddObject(m, "srv_record", (PyObject *)(void *)&dns_srv_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_opt_record_Type);
	PyModule_AddObject(m, "opt_record", (PyObject *)(void *)&dns_opt_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_tkey_record_Type);
	PyModule_AddObject(m, "tkey_record", (PyObject *)(void *)&dns_tkey_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_tsig_record_Type);
	PyModule_AddObject(m, "tsig_record", (PyObject *)(void *)&dns_tsig_record_Type);
	Py_INCREF((PyObject *)(void *)&dns_fake_tsig_rec_Type);
	PyModule_AddObject(m, "fake_tsig_rec", (PyObject *)(void *)&dns_fake_tsig_rec_Type);
	Py_INCREF((PyObject *)(void *)&dns_rdata_Type);
	PyModule_AddObject(m, "rdata", (PyObject *)(void *)&dns_rdata_Type);
	Py_INCREF((PyObject *)(void *)&dns_res_rec_Type);
	PyModule_AddObject(m, "res_rec", (PyObject *)(void *)&dns_res_rec_Type);
	Py_INCREF((PyObject *)(void *)&dns_name_packet_Type);
	PyModule_AddObject(m, "name_packet", (PyObject *)(void *)&dns_name_packet_Type);
	Py_INCREF((PyObject *)(void *)&dns_InterfaceType);
	PyModule_AddObject(m, "dns", (PyObject *)(void *)&dns_InterfaceType);
	Py_INCREF((PyObject *)(void *)&dns_SyntaxType);
	PyModule_AddObject(m, "dns_abstract_syntax", (PyObject *)(void *)&dns_SyntaxType);
	Py_INCREF((PyObject *)(void *)&dns_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&dns_SyntaxType);
#ifdef PY_MOD_DNS_PATCH
	PY_MOD_DNS_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_dnsp);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
