
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_atsvc.h"
#include "bin/default/librpc/gen_ndr/ndr_atsvc_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject atsvc_JobInfo_Type;
static PyTypeObject atsvc_JobEnumInfo_Type;
static PyTypeObject atsvc_enum_ctr_Type;
static PyTypeObject atsvc_InterfaceType;
static PyTypeObject atsvc_JobAdd_Type;
static PyTypeObject atsvc_JobDel_Type;
static PyTypeObject atsvc_JobEnum_Type;
static PyTypeObject atsvc_JobGetInfo_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_atsvc_JobInfo_get_job_time(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_job_time;
	py_job_time = PyLong_FromUnsignedLongLong((uint32_t)(object->job_time));
	return py_job_time;
}

static int py_atsvc_JobInfo_set_job_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->job_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->job_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->job_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_days_of_month(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_days_of_month;
	py_days_of_month = PyLong_FromUnsignedLongLong((uint32_t)(object->days_of_month));
	return py_days_of_month;
}

static int py_atsvc_JobInfo_set_days_of_month(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->days_of_month");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->days_of_month));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->days_of_month = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_days_of_week(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_days_of_week;
	py_days_of_week = PyLong_FromLong((uint16_t)(object->days_of_week));
	return py_days_of_week;
}

static int py_atsvc_JobInfo_set_days_of_week(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->days_of_week");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->days_of_week));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->days_of_week = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_flags(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_atsvc_JobInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobInfo_get_command(PyObject *obj, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	if (object->command == NULL) {
		Py_RETURN_NONE;
	}
	if (object->command == NULL) {
		py_command = Py_None;
		Py_INCREF(py_command);
	} else {
		if (object->command == NULL) {
			py_command = Py_None;
			Py_INCREF(py_command);
		} else {
			py_command = PyUnicode_Decode(object->command, strlen(object->command), "utf-8", "ignore");
		}
	}
	return py_command;
}

static int py_atsvc_JobInfo_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->command");
		return -1;
	}
	if (value == Py_None) {
		object->command = NULL;
	} else {
		object->command = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->command = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_atsvc_JobInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "job_time"),
		.get = py_atsvc_JobInfo_get_job_time,
		.set = py_atsvc_JobInfo_set_job_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "days_of_month"),
		.get = py_atsvc_JobInfo_get_days_of_month,
		.set = py_atsvc_JobInfo_set_days_of_month,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_DaysOfMonth")
	},
	{
		.name = discard_const_p(char, "days_of_week"),
		.get = py_atsvc_JobInfo_get_days_of_week,
		.set = py_atsvc_JobInfo_set_days_of_week,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_DaysOfWeek")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_atsvc_JobInfo_get_flags,
		.set = py_atsvc_JobInfo_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_Flags")
	},
	{
		.name = discard_const_p(char, "command"),
		.get = py_atsvc_JobInfo_get_command,
		.set = py_atsvc_JobInfo_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_JobInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct atsvc_JobInfo, type);
}


static PyTypeObject atsvc_JobInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.JobInfo",
	.tp_getset = py_atsvc_JobInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_JobInfo_new,
};


static PyObject *py_atsvc_JobEnumInfo_get_job_id(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_job_id;
	py_job_id = PyLong_FromUnsignedLongLong((uint32_t)(object->job_id));
	return py_job_id;
}

static int py_atsvc_JobEnumInfo_set_job_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->job_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->job_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_job_time(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_job_time;
	py_job_time = PyLong_FromUnsignedLongLong((uint32_t)(object->job_time));
	return py_job_time;
}

static int py_atsvc_JobEnumInfo_set_job_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->job_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->job_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->job_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_days_of_month(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_days_of_month;
	py_days_of_month = PyLong_FromUnsignedLongLong((uint32_t)(object->days_of_month));
	return py_days_of_month;
}

static int py_atsvc_JobEnumInfo_set_days_of_month(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->days_of_month");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->days_of_month));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->days_of_month = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_days_of_week(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_days_of_week;
	py_days_of_week = PyLong_FromLong((uint16_t)(object->days_of_week));
	return py_days_of_week;
}

static int py_atsvc_JobEnumInfo_set_days_of_week(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->days_of_week");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->days_of_week));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->days_of_week = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_flags(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_atsvc_JobEnumInfo_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnumInfo_get_command(PyObject *obj, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	if (object->command == NULL) {
		Py_RETURN_NONE;
	}
	if (object->command == NULL) {
		py_command = Py_None;
		Py_INCREF(py_command);
	} else {
		if (object->command == NULL) {
			py_command = Py_None;
			Py_INCREF(py_command);
		} else {
			py_command = PyUnicode_Decode(object->command, strlen(object->command), "utf-8", "ignore");
		}
	}
	return py_command;
}

static int py_atsvc_JobEnumInfo_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnumInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->command");
		return -1;
	}
	if (value == Py_None) {
		object->command = NULL;
	} else {
		object->command = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->command = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_atsvc_JobEnumInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "job_id"),
		.get = py_atsvc_JobEnumInfo_get_job_id,
		.set = py_atsvc_JobEnumInfo_set_job_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "job_time"),
		.get = py_atsvc_JobEnumInfo_get_job_time,
		.set = py_atsvc_JobEnumInfo_set_job_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "days_of_month"),
		.get = py_atsvc_JobEnumInfo_get_days_of_month,
		.set = py_atsvc_JobEnumInfo_set_days_of_month,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_DaysOfMonth")
	},
	{
		.name = discard_const_p(char, "days_of_week"),
		.get = py_atsvc_JobEnumInfo_get_days_of_week,
		.set = py_atsvc_JobEnumInfo_set_days_of_week,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_DaysOfWeek")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_atsvc_JobEnumInfo_get_flags,
		.set = py_atsvc_JobEnumInfo_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_Flags")
	},
	{
		.name = discard_const_p(char, "command"),
		.get = py_atsvc_JobEnumInfo_get_command,
		.set = py_atsvc_JobEnumInfo_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_JobEnumInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct atsvc_JobEnumInfo, type);
}


static PyTypeObject atsvc_JobEnumInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.JobEnumInfo",
	.tp_getset = py_atsvc_JobEnumInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_JobEnumInfo_new,
};


static PyObject *py_atsvc_enum_ctr_get_entries_read(PyObject *obj, void *closure)
{
	struct atsvc_enum_ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_entries_read;
	py_entries_read = PyLong_FromUnsignedLongLong((uint32_t)(object->entries_read));
	return py_entries_read;
}

static int py_atsvc_enum_ctr_set_entries_read(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_enum_ctr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->entries_read");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->entries_read));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->entries_read = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_enum_ctr_get_first_entry(PyObject *obj, void *closure)
{
	struct atsvc_enum_ctr *object = pytalloc_get_ptr(obj);
	PyObject *py_first_entry;
	if (object->first_entry == NULL) {
		Py_RETURN_NONE;
	}
	if (object->first_entry == NULL) {
		py_first_entry = Py_None;
		Py_INCREF(py_first_entry);
	} else {
		py_first_entry = PyList_New(object->entries_read);
		if (py_first_entry == NULL) {
			return NULL;
		}
		{
			int first_entry_cntr_1;
			for (first_entry_cntr_1 = 0; first_entry_cntr_1 < (object->entries_read); first_entry_cntr_1++) {
				PyObject *py_first_entry_1;
				py_first_entry_1 = pytalloc_reference_ex(&atsvc_JobEnumInfo_Type, object->first_entry, &(object->first_entry)[first_entry_cntr_1]);
				PyList_SetItem(py_first_entry, first_entry_cntr_1, py_first_entry_1);
			}
		}
	}
	return py_first_entry;
}

static int py_atsvc_enum_ctr_set_first_entry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_enum_ctr *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->first_entry));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->first_entry");
		return -1;
	}
	if (value == Py_None) {
		object->first_entry = NULL;
	} else {
		object->first_entry = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int first_entry_cntr_1;
			object->first_entry = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->first_entry, PyList_GET_SIZE(value));
			if (!object->first_entry) { return -1; }
			talloc_set_name_const(object->first_entry, "ARRAY: object->first_entry");
			for (first_entry_cntr_1 = 0; first_entry_cntr_1 < PyList_GET_SIZE(value); first_entry_cntr_1++) {
				if (PyList_GET_ITEM(value, first_entry_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct (object->first_entry)[first_entry_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&atsvc_JobEnumInfo_Type, PyList_GET_ITEM(value, first_entry_cntr_1), return -1;);
				if (talloc_reference(object->first_entry, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, first_entry_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->first_entry)[first_entry_cntr_1] = *(struct atsvc_JobEnumInfo *)pytalloc_get_ptr(PyList_GET_ITEM(value, first_entry_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_atsvc_enum_ctr_getsetters[] = {
	{
		.name = discard_const_p(char, "entries_read"),
		.get = py_atsvc_enum_ctr_get_entries_read,
		.set = py_atsvc_enum_ctr_set_entries_read,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "first_entry"),
		.get = py_atsvc_enum_ctr_get_first_entry,
		.set = py_atsvc_enum_ctr_set_first_entry,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_JobEnumInfo")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_enum_ctr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct atsvc_enum_ctr, type);
}


static PyTypeObject atsvc_enum_ctr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.enum_ctr",
	.tp_getset = py_atsvc_enum_ctr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_enum_ctr_new,
};



static PyObject *py_atsvc_JobAdd_in_get_servername(PyObject *obj, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_servername;
	if (object->in.servername == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.servername == NULL) {
		py_servername = Py_None;
		Py_INCREF(py_servername);
	} else {
		if (object->in.servername == NULL) {
			py_servername = Py_None;
			Py_INCREF(py_servername);
		} else {
			py_servername = PyUnicode_Decode(object->in.servername, strlen(object->in.servername), "utf-8", "ignore");
		}
	}
	return py_servername;
}

static int py_atsvc_JobAdd_in_set_servername(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.servername");
		return -1;
	}
	if (value == Py_None) {
		object->in.servername = NULL;
	} else {
		object->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.servername = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobAdd_in_get_job_info(PyObject *obj, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_job_info;
	if (object->in.job_info == NULL) {
		Py_RETURN_NONE;
	}
	py_job_info = pytalloc_reference_ex(&atsvc_JobInfo_Type, object->in.job_info, object->in.job_info);
	return py_job_info;
}

static int py_atsvc_JobAdd_in_set_job_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.job_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.job_info");
		return -1;
	}
	object->in.job_info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.job_info);
	if (object->in.job_info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&atsvc_JobInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.job_info = (struct atsvc_JobInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_atsvc_JobAdd_out_get_job_id(PyObject *obj, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_job_id;
	if (object->out.job_id == NULL) {
		Py_RETURN_NONE;
	}
	py_job_id = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.job_id));
	return py_job_id;
}

static int py_atsvc_JobAdd_out_set_job_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.job_id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.job_id");
		return -1;
	}
	object->out.job_id = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.job_id);
	if (object->out.job_id == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.job_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobAdd_get_result(PyObject *obj, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_atsvc_JobAdd_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_atsvc_JobAdd_getsetters[] = {
	{
		.name = discard_const_p(char, "in_servername"),
		.get = py_atsvc_JobAdd_in_get_servername,
		.set = py_atsvc_JobAdd_in_set_servername,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_job_info"),
		.get = py_atsvc_JobAdd_in_get_job_info,
		.set = py_atsvc_JobAdd_in_set_job_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_JobInfo")
	},
	{
		.name = discard_const_p(char, "out_job_id"),
		.get = py_atsvc_JobAdd_out_get_job_id,
		.set = py_atsvc_JobAdd_out_set_job_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_atsvc_JobAdd_get_result,
		.set = py_atsvc_JobAdd_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_JobAdd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct atsvc_JobAdd, type);
	struct atsvc_JobAdd *_self = (struct atsvc_JobAdd *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.job_info = talloc_zero(mem_ctx, struct atsvc_JobInfo);
	_self->out.job_id = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_atsvc_JobAdd_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_atsvc_JobAdd_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobAdd_ndr_pack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_atsvc_JobAdd_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobAdd_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_atsvc_JobAdd_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobAdd_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_atsvc_JobAdd_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobAdd_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_atsvc_JobAdd_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobAdd_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobAdd_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobAdd_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobAdd_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobAdd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_atsvc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobAdd_ndr_print");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[0];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_atsvc_JobAdd_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobAdd_ndr_print(py_obj, "atsvc_JobAdd_in", NDR_IN);
}

static PyObject *py_atsvc_JobAdd_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobAdd_ndr_print(py_obj, "atsvc_JobAdd_out", NDR_OUT);
}

static PyMethodDef py_atsvc_JobAdd_methods[] = {
	{ "opnum", (PyCFunction)py_atsvc_JobAdd_ndr_opnum, METH_NOARGS|METH_CLASS,
		"atsvc.JobAdd.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobAdd_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobAdd_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobAdd_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobAdd_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_atsvc_JobAdd_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_atsvc_JobAdd_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject atsvc_JobAdd_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.JobAdd",
	.tp_getset = py_atsvc_JobAdd_getsetters,
	.tp_methods = py_atsvc_JobAdd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_JobAdd_new,
};

static bool pack_py_atsvc_JobAdd_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobAdd *r)
{
	PyObject *py_servername;
	PyObject *py_job_info;
	const char *kwnames[] = {
		"servername", "job_info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:atsvc_JobAdd", discard_const_p(char *, kwnames), &py_servername, &py_job_info)) {
		return false;
	}

	if (py_servername == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.servername");
		return false;
	}
	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_servername)) {
				unicode = PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_servername)) {
				test_str = PyBytes_AS_STRING(py_servername);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.servername = talloc_str;
		}
	}
	if (py_job_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.job_info");
		return false;
	}
	r->in.job_info = talloc_ptrtype(r, r->in.job_info);
	if (r->in.job_info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&atsvc_JobInfo_Type, py_job_info, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_job_info)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.job_info = (struct atsvc_JobInfo *)pytalloc_get_ptr(py_job_info);
	return true;
}

static PyObject *unpack_py_atsvc_JobAdd_args_out(struct atsvc_JobAdd *r)
{
	PyObject *result;
	PyObject *py_job_id;
	py_job_id = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.job_id));
	result = py_job_id;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_atsvc_JobDel_in_get_servername(PyObject *obj, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(obj);
	PyObject *py_servername;
	if (object->in.servername == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.servername == NULL) {
		py_servername = Py_None;
		Py_INCREF(py_servername);
	} else {
		if (object->in.servername == NULL) {
			py_servername = Py_None;
			Py_INCREF(py_servername);
		} else {
			py_servername = PyUnicode_Decode(object->in.servername, strlen(object->in.servername), "utf-8", "ignore");
		}
	}
	return py_servername;
}

static int py_atsvc_JobDel_in_set_servername(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.servername");
		return -1;
	}
	if (value == Py_None) {
		object->in.servername = NULL;
	} else {
		object->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.servername = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobDel_in_get_min_job_id(PyObject *obj, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(obj);
	PyObject *py_min_job_id;
	py_min_job_id = PyLong_FromUnsignedLongLong((uint32_t)(object->in.min_job_id));
	return py_min_job_id;
}

static int py_atsvc_JobDel_in_set_min_job_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.min_job_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.min_job_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.min_job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobDel_in_get_max_job_id(PyObject *obj, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(obj);
	PyObject *py_max_job_id;
	py_max_job_id = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_job_id));
	return py_max_job_id;
}

static int py_atsvc_JobDel_in_set_max_job_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.max_job_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_job_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobDel_get_result(PyObject *obj, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_atsvc_JobDel_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_atsvc_JobDel_getsetters[] = {
	{
		.name = discard_const_p(char, "in_servername"),
		.get = py_atsvc_JobDel_in_get_servername,
		.set = py_atsvc_JobDel_in_set_servername,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_min_job_id"),
		.get = py_atsvc_JobDel_in_get_min_job_id,
		.set = py_atsvc_JobDel_in_set_min_job_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_max_job_id"),
		.get = py_atsvc_JobDel_in_get_max_job_id,
		.set = py_atsvc_JobDel_in_set_max_job_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_atsvc_JobDel_get_result,
		.set = py_atsvc_JobDel_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_JobDel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct atsvc_JobDel, type);
	return self;
}

static PyObject *py_atsvc_JobDel_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_atsvc_JobDel_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobDel_ndr_pack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_atsvc_JobDel_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobDel_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_atsvc_JobDel_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobDel_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_atsvc_JobDel_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobDel_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_atsvc_JobDel_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobDel_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobDel_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobDel_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobDel_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobDel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_atsvc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobDel_ndr_print");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[1];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_atsvc_JobDel_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobDel_ndr_print(py_obj, "atsvc_JobDel_in", NDR_IN);
}

static PyObject *py_atsvc_JobDel_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobDel_ndr_print(py_obj, "atsvc_JobDel_out", NDR_OUT);
}

static PyMethodDef py_atsvc_JobDel_methods[] = {
	{ "opnum", (PyCFunction)py_atsvc_JobDel_ndr_opnum, METH_NOARGS|METH_CLASS,
		"atsvc.JobDel.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobDel_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobDel_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobDel_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobDel_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_atsvc_JobDel_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_atsvc_JobDel_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject atsvc_JobDel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.JobDel",
	.tp_getset = py_atsvc_JobDel_getsetters,
	.tp_methods = py_atsvc_JobDel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_JobDel_new,
};

static bool pack_py_atsvc_JobDel_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobDel *r)
{
	PyObject *py_servername;
	PyObject *py_min_job_id;
	PyObject *py_max_job_id;
	const char *kwnames[] = {
		"servername", "min_job_id", "max_job_id", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:atsvc_JobDel", discard_const_p(char *, kwnames), &py_servername, &py_min_job_id, &py_max_job_id)) {
		return false;
	}

	if (py_servername == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.servername");
		return false;
	}
	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_servername)) {
				unicode = PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_servername)) {
				test_str = PyBytes_AS_STRING(py_servername);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.servername = talloc_str;
		}
	}
	if (py_min_job_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.min_job_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.min_job_id));
		if (PyLong_Check(py_min_job_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_min_job_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.min_job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_job_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.max_job_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_job_id));
		if (PyLong_Check(py_max_job_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_job_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_atsvc_JobDel_args_out(struct atsvc_JobDel *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_atsvc_JobEnum_in_get_servername(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_servername;
	if (object->in.servername == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.servername == NULL) {
		py_servername = Py_None;
		Py_INCREF(py_servername);
	} else {
		if (object->in.servername == NULL) {
			py_servername = Py_None;
			Py_INCREF(py_servername);
		} else {
			py_servername = PyUnicode_Decode(object->in.servername, strlen(object->in.servername), "utf-8", "ignore");
		}
	}
	return py_servername;
}

static int py_atsvc_JobEnum_in_set_servername(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.servername");
		return -1;
	}
	if (value == Py_None) {
		object->in.servername = NULL;
	} else {
		object->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.servername = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnum_in_get_ctr(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	if (object->in.ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_ctr = pytalloc_reference_ex(&atsvc_enum_ctr_Type, object->in.ctr, object->in.ctr);
	return py_ctr;
}

static int py_atsvc_JobEnum_in_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.ctr");
		return -1;
	}
	object->in.ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.ctr);
	if (object->in.ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&atsvc_enum_ctr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.ctr = (struct atsvc_enum_ctr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_atsvc_JobEnum_out_get_ctr(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_ctr;
	if (object->out.ctr == NULL) {
		Py_RETURN_NONE;
	}
	py_ctr = pytalloc_reference_ex(&atsvc_enum_ctr_Type, object->out.ctr, object->out.ctr);
	return py_ctr;
}

static int py_atsvc_JobEnum_out_set_ctr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.ctr));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.ctr");
		return -1;
	}
	object->out.ctr = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.ctr);
	if (object->out.ctr == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&atsvc_enum_ctr_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.ctr = (struct atsvc_enum_ctr *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_atsvc_JobEnum_in_get_preferred_max_len(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_preferred_max_len;
	py_preferred_max_len = PyLong_FromUnsignedLongLong((uint32_t)(object->in.preferred_max_len));
	return py_preferred_max_len;
}

static int py_atsvc_JobEnum_in_set_preferred_max_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.preferred_max_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.preferred_max_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.preferred_max_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnum_out_get_total_entries(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_total_entries;
	if (object->out.total_entries == NULL) {
		Py_RETURN_NONE;
	}
	py_total_entries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.total_entries));
	return py_total_entries;
}

static int py_atsvc_JobEnum_out_set_total_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.total_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.total_entries");
		return -1;
	}
	object->out.total_entries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.total_entries);
	if (object->out.total_entries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.total_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.total_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnum_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	}
	return py_resume_handle;
}

static int py_atsvc_JobEnum_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->in.resume_handle = NULL;
	} else {
		object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
		if (object->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnum_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	}
	return py_resume_handle;
}

static int py_atsvc_JobEnum_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.resume_handle");
		return -1;
	}
	if (value == Py_None) {
		object->out.resume_handle = NULL;
	} else {
		object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
		if (object->out.resume_handle == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->out.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobEnum_get_result(PyObject *obj, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_atsvc_JobEnum_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_atsvc_JobEnum_getsetters[] = {
	{
		.name = discard_const_p(char, "in_servername"),
		.get = py_atsvc_JobEnum_in_get_servername,
		.set = py_atsvc_JobEnum_in_set_servername,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_ctr"),
		.get = py_atsvc_JobEnum_in_get_ctr,
		.set = py_atsvc_JobEnum_in_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_enum_ctr")
	},
	{
		.name = discard_const_p(char, "out_ctr"),
		.get = py_atsvc_JobEnum_out_get_ctr,
		.set = py_atsvc_JobEnum_out_set_ctr,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_enum_ctr")
	},
	{
		.name = discard_const_p(char, "in_preferred_max_len"),
		.get = py_atsvc_JobEnum_in_get_preferred_max_len,
		.set = py_atsvc_JobEnum_in_set_preferred_max_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_total_entries"),
		.get = py_atsvc_JobEnum_out_get_total_entries,
		.set = py_atsvc_JobEnum_out_set_total_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_atsvc_JobEnum_in_get_resume_handle,
		.set = py_atsvc_JobEnum_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_atsvc_JobEnum_out_get_resume_handle,
		.set = py_atsvc_JobEnum_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_atsvc_JobEnum_get_result,
		.set = py_atsvc_JobEnum_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_JobEnum_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct atsvc_JobEnum, type);
	struct atsvc_JobEnum *_self = (struct atsvc_JobEnum *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.ctr = talloc_zero(mem_ctx, struct atsvc_enum_ctr);
	_self->out.ctr = talloc_zero(mem_ctx, struct atsvc_enum_ctr);
	_self->out.total_entries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_atsvc_JobEnum_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_atsvc_JobEnum_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobEnum_ndr_pack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_atsvc_JobEnum_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobEnum_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_atsvc_JobEnum_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobEnum_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_atsvc_JobEnum_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobEnum_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_atsvc_JobEnum_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobEnum_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobEnum_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobEnum_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobEnum_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobEnum *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_atsvc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobEnum_ndr_print");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[2];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_atsvc_JobEnum_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobEnum_ndr_print(py_obj, "atsvc_JobEnum_in", NDR_IN);
}

static PyObject *py_atsvc_JobEnum_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobEnum_ndr_print(py_obj, "atsvc_JobEnum_out", NDR_OUT);
}

static PyMethodDef py_atsvc_JobEnum_methods[] = {
	{ "opnum", (PyCFunction)py_atsvc_JobEnum_ndr_opnum, METH_NOARGS|METH_CLASS,
		"atsvc.JobEnum.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobEnum_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobEnum_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobEnum_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobEnum_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_atsvc_JobEnum_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_atsvc_JobEnum_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject atsvc_JobEnum_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.JobEnum",
	.tp_getset = py_atsvc_JobEnum_getsetters,
	.tp_methods = py_atsvc_JobEnum_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_JobEnum_new,
};

static bool pack_py_atsvc_JobEnum_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobEnum *r)
{
	PyObject *py_servername;
	PyObject *py_ctr;
	PyObject *py_preferred_max_len;
	PyObject *py_resume_handle;
	const char *kwnames[] = {
		"servername", "ctr", "preferred_max_len", "resume_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:atsvc_JobEnum", discard_const_p(char *, kwnames), &py_servername, &py_ctr, &py_preferred_max_len, &py_resume_handle)) {
		return false;
	}

	if (py_servername == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.servername");
		return false;
	}
	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_servername)) {
				unicode = PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_servername)) {
				test_str = PyBytes_AS_STRING(py_servername);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.servername = talloc_str;
		}
	}
	if (py_ctr == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.ctr");
		return false;
	}
	r->in.ctr = talloc_ptrtype(r, r->in.ctr);
	if (r->in.ctr == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(&atsvc_enum_ctr_Type, py_ctr, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_ctr)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.ctr = (struct atsvc_enum_ctr *)pytalloc_get_ptr(py_ctr);
	if (py_preferred_max_len == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.preferred_max_len");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.preferred_max_len));
		if (PyLong_Check(py_preferred_max_len)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_preferred_max_len);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.preferred_max_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.resume_handle");
		return false;
	}
	if (py_resume_handle == Py_None) {
		r->in.resume_handle = NULL;
	} else {
		r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
		if (r->in.resume_handle == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
			if (PyLong_Check(py_resume_handle)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.resume_handle = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	return true;
}

static PyObject *unpack_py_atsvc_JobEnum_args_out(struct atsvc_JobEnum *r)
{
	PyObject *result;
	PyObject *py_ctr;
	PyObject *py_total_entries;
	PyObject *py_resume_handle;
	result = PyTuple_New(3);
	py_ctr = pytalloc_reference_ex(&atsvc_enum_ctr_Type, r->out.ctr, r->out.ctr);
	PyTuple_SetItem(result, 0, py_ctr);
	py_total_entries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.total_entries));
	PyTuple_SetItem(result, 1, py_total_entries);
	if (r->out.resume_handle == NULL) {
		py_resume_handle = Py_None;
		Py_INCREF(py_resume_handle);
	} else {
		py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	}
	PyTuple_SetItem(result, 2, py_resume_handle);
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}


static PyObject *py_atsvc_JobGetInfo_in_get_servername(PyObject *obj, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_servername;
	if (object->in.servername == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.servername == NULL) {
		py_servername = Py_None;
		Py_INCREF(py_servername);
	} else {
		if (object->in.servername == NULL) {
			py_servername = Py_None;
			Py_INCREF(py_servername);
		} else {
			py_servername = PyUnicode_Decode(object->in.servername, strlen(object->in.servername), "utf-8", "ignore");
		}
	}
	return py_servername;
}

static int py_atsvc_JobGetInfo_in_set_servername(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.servername");
		return -1;
	}
	if (value == Py_None) {
		object->in.servername = NULL;
	} else {
		object->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.servername = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobGetInfo_in_get_job_id(PyObject *obj, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_job_id;
	py_job_id = PyLong_FromUnsignedLongLong((uint32_t)(object->in.job_id));
	return py_job_id;
}

static int py_atsvc_JobGetInfo_in_set_job_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->in.job_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.job_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_atsvc_JobGetInfo_out_get_job_info(PyObject *obj, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_job_info;
	if (object->out.job_info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.job_info == NULL) {
		py_job_info = Py_None;
		Py_INCREF(py_job_info);
	} else {
		py_job_info = pytalloc_reference_ex(&atsvc_JobInfo_Type, *object->out.job_info, *object->out.job_info);
	}
	return py_job_info;
}

static int py_atsvc_JobGetInfo_out_set_job_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.job_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.job_info");
		return -1;
	}
	object->out.job_info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.job_info);
	if (object->out.job_info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.job_info = NULL;
	} else {
		*object->out.job_info = NULL;
		PY_CHECK_TYPE(&atsvc_JobInfo_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.job_info = (struct atsvc_JobInfo *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_atsvc_JobGetInfo_get_result(PyObject *obj, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_atsvc_JobGetInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_atsvc_JobGetInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_servername"),
		.get = py_atsvc_JobGetInfo_in_get_servername,
		.set = py_atsvc_JobGetInfo_in_set_servername,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_job_id"),
		.get = py_atsvc_JobGetInfo_in_get_job_id,
		.set = py_atsvc_JobGetInfo_in_set_job_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_job_info"),
		.get = py_atsvc_JobGetInfo_out_get_job_info,
		.set = py_atsvc_JobGetInfo_out_set_job_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type atsvc_JobInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_atsvc_JobGetInfo_get_result,
		.set = py_atsvc_JobGetInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_atsvc_JobGetInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct atsvc_JobGetInfo, type);
	struct atsvc_JobGetInfo *_self = (struct atsvc_JobGetInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.job_info = talloc_zero(mem_ctx, struct atsvc_JobInfo *);
	return self;
}

static PyObject *py_atsvc_JobGetInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_atsvc_JobGetInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobGetInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_atsvc_JobGetInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobGetInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_atsvc_JobGetInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_atsvc_JobGetInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_atsvc_JobGetInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_atsvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobGetInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_atsvc_JobGetInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobGetInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobGetInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_atsvc_JobGetInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_atsvc_JobGetInfo_ndr_print(PyObject *py_obj, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct atsvc_JobGetInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret;
	char *retstr;

	if (ndr_table_atsvc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_atsvc_JobGetInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_atsvc.calls[3];

	retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_atsvc_JobGetInfo_ndr_print_in(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobGetInfo_ndr_print(py_obj, "atsvc_JobGetInfo_in", NDR_IN);
}

static PyObject *py_atsvc_JobGetInfo_ndr_print_out(PyObject *py_obj, PyObject *Py_UNUSED(ignored))
{
	return py_atsvc_JobGetInfo_ndr_print(py_obj, "atsvc_JobGetInfo_out", NDR_OUT);
}

static PyMethodDef py_atsvc_JobGetInfo_methods[] = {
	{ "opnum", (PyCFunction)py_atsvc_JobGetInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"atsvc.JobGetInfo.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobGetInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobGetInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobGetInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_atsvc_JobGetInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", (PyCFunction)py_atsvc_JobGetInfo_ndr_print_in, METH_NOARGS, "S.ndr_print_in(object) -> None\nNDR print input" },
	{ "__ndr_print_out__", (PyCFunction)py_atsvc_JobGetInfo_ndr_print_out, METH_NOARGS, "S.ndr_print_out(object) -> None\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject atsvc_JobGetInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.JobGetInfo",
	.tp_getset = py_atsvc_JobGetInfo_getsetters,
	.tp_methods = py_atsvc_JobGetInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_atsvc_JobGetInfo_new,
};

static bool pack_py_atsvc_JobGetInfo_args_in(PyObject *args, PyObject *kwargs, struct atsvc_JobGetInfo *r)
{
	PyObject *py_servername;
	PyObject *py_job_id;
	const char *kwnames[] = {
		"servername", "job_id", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:atsvc_JobGetInfo", discard_const_p(char *, kwnames), &py_servername, &py_job_id)) {
		return false;
	}

	if (py_servername == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.servername");
		return false;
	}
	if (py_servername == Py_None) {
		r->in.servername = NULL;
	} else {
		r->in.servername = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_servername)) {
				unicode = PyUnicode_AsEncodedString(py_servername, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_servername)) {
				test_str = PyBytes_AS_STRING(py_servername);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_servername)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.servername = talloc_str;
		}
	}
	if (py_job_id == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: struct r->in.job_id");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.job_id));
		if (PyLong_Check(py_job_id)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_job_id);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.job_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_atsvc_JobGetInfo_args_out(struct atsvc_JobGetInfo *r)
{
	PyObject *result;
	PyObject *py_job_info;
	if (*r->out.job_info == NULL) {
		py_job_info = Py_None;
		Py_INCREF(py_job_info);
	} else {
		py_job_info = pytalloc_reference_ex(&atsvc_JobInfo_Type, *r->out.job_info, *r->out.job_info);
	}
	result = py_job_info;
	if (NT_STATUS_IS_ERR(r->out.result)) {
		PyErr_SetNTSTATUS(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_atsvc_methods[] = {
	{ "JobAdd", "S.JobAdd(servername, job_info) -> job_id", (py_dcerpc_call_fn)dcerpc_atsvc_JobAdd_r, (py_data_pack_fn)pack_py_atsvc_JobAdd_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobAdd_args_out, 0, &ndr_table_atsvc },
	{ "JobDel", "S.JobDel(servername, min_job_id, max_job_id) -> None", (py_dcerpc_call_fn)dcerpc_atsvc_JobDel_r, (py_data_pack_fn)pack_py_atsvc_JobDel_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobDel_args_out, 1, &ndr_table_atsvc },
	{ "JobEnum", "S.JobEnum(servername, ctr, preferred_max_len, resume_handle) -> (ctr, total_entries, resume_handle)", (py_dcerpc_call_fn)dcerpc_atsvc_JobEnum_r, (py_data_pack_fn)pack_py_atsvc_JobEnum_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobEnum_args_out, 2, &ndr_table_atsvc },
	{ "JobGetInfo", "S.JobGetInfo(servername, job_id) -> job_info", (py_dcerpc_call_fn)dcerpc_atsvc_JobGetInfo_r, (py_data_pack_fn)pack_py_atsvc_JobGetInfo_args_in, (py_data_unpack_fn)unpack_py_atsvc_JobGetInfo_args_out, 3, &ndr_table_atsvc },
	{0}
};

static PyObject *interface_atsvc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_atsvc);
}

#define PY_DOC_ATSVC "Microsoft AT-Scheduler Service"
static PyTypeObject atsvc_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.atsvc",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "atsvc(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_ATSVC,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_atsvc_new,
};

static PyObject *syntax_atsvc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_atsvc.syntax_id);
}

#define PY_DOC_ATSVC_SYNTAX "Microsoft AT-Scheduler Service"
static PyTypeObject atsvc_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "atsvc.atsvc_abstract_syntax",
	.tp_doc = "atsvc_abstract_syntax()\n"PY_DOC_ATSVC_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_atsvc_new,
};

static PyMethodDef atsvc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "atsvc",
	.m_doc = "atsvc DCE/RPC",
	.m_size = -1,
	.m_methods = atsvc_methods,
};
MODULE_INIT_FUNC(atsvc)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	atsvc_JobInfo_Type.tp_base = BaseObject_Type;
	atsvc_JobInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_JobEnumInfo_Type.tp_base = BaseObject_Type;
	atsvc_JobEnumInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_enum_ctr_Type.tp_base = BaseObject_Type;
	atsvc_enum_ctr_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_JobAdd_Type.tp_base = BaseObject_Type;
	atsvc_JobAdd_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_JobDel_Type.tp_base = BaseObject_Type;
	atsvc_JobDel_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_JobEnum_Type.tp_base = BaseObject_Type;
	atsvc_JobEnum_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_JobGetInfo_Type.tp_base = BaseObject_Type;
	atsvc_JobGetInfo_Type.tp_basicsize = pytalloc_BaseObject_size();

	atsvc_InterfaceType.tp_base = ClientConnection_Type;

	atsvc_SyntaxType.tp_base = ndr_syntax_id_Type;
	atsvc_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&atsvc_JobInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_JobEnumInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_enum_ctr_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_JobAdd_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_JobDel_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_JobEnum_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_JobGetInfo_Type) < 0)
		goto out;
	if (PyType_Ready(&atsvc_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&atsvc_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&atsvc_InterfaceType, py_ndr_atsvc_methods))
		return NULL;

#ifdef PY_JOBINFO_PATCH
	PY_JOBINFO_PATCH(&atsvc_JobInfo_Type);
#endif
#ifdef PY_JOBENUMINFO_PATCH
	PY_JOBENUMINFO_PATCH(&atsvc_JobEnumInfo_Type);
#endif
#ifdef PY_ENUM_CTR_PATCH
	PY_ENUM_CTR_PATCH(&atsvc_enum_ctr_Type);
#endif
#ifdef PY_JOBADD_PATCH
	PY_JOBADD_PATCH(&atsvc_JobAdd_Type);
#endif
#ifdef PY_JOBDEL_PATCH
	PY_JOBDEL_PATCH(&atsvc_JobDel_Type);
#endif
#ifdef PY_JOBENUM_PATCH
	PY_JOBENUM_PATCH(&atsvc_JobEnum_Type);
#endif
#ifdef PY_JOBGETINFO_PATCH
	PY_JOBGETINFO_PATCH(&atsvc_JobGetInfo_Type);
#endif
#ifdef PY_ATSVC_PATCH
	PY_ATSVC_PATCH(&atsvc_InterfaceType);
#endif
#ifdef PY_ATSVC_ABSTRACT_SYNTAX_PATCH
	PY_ATSVC_ABSTRACT_SYNTAX_PATCH(&atsvc_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&atsvc_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "First", PyLong_FromUnsignedLongLong((uint32_t)(First)));
	PyModule_AddObject(m, "Second", PyLong_FromUnsignedLongLong((uint32_t)(Second)));
	PyModule_AddObject(m, "Third", PyLong_FromUnsignedLongLong((uint32_t)(Third)));
	PyModule_AddObject(m, "Fourth", PyLong_FromUnsignedLongLong((uint32_t)(Fourth)));
	PyModule_AddObject(m, "Fifth", PyLong_FromUnsignedLongLong((uint32_t)(Fifth)));
	PyModule_AddObject(m, "Sixth", PyLong_FromUnsignedLongLong((uint32_t)(Sixth)));
	PyModule_AddObject(m, "Seventh", PyLong_FromUnsignedLongLong((uint32_t)(Seventh)));
	PyModule_AddObject(m, "Eight", PyLong_FromUnsignedLongLong((uint32_t)(Eight)));
	PyModule_AddObject(m, "Ninth", PyLong_FromUnsignedLongLong((uint32_t)(Ninth)));
	PyModule_AddObject(m, "Tenth", PyLong_FromUnsignedLongLong((uint32_t)(Tenth)));
	PyModule_AddObject(m, "Eleventh", PyLong_FromUnsignedLongLong((uint32_t)(Eleventh)));
	PyModule_AddObject(m, "Twelfth", PyLong_FromUnsignedLongLong((uint32_t)(Twelfth)));
	PyModule_AddObject(m, "Thitteenth", PyLong_FromUnsignedLongLong((uint32_t)(Thitteenth)));
	PyModule_AddObject(m, "Fourteenth", PyLong_FromUnsignedLongLong((uint32_t)(Fourteenth)));
	PyModule_AddObject(m, "Fifteenth", PyLong_FromUnsignedLongLong((uint32_t)(Fifteenth)));
	PyModule_AddObject(m, "Sixteenth", PyLong_FromUnsignedLongLong((uint32_t)(Sixteenth)));
	PyModule_AddObject(m, "Seventeenth", PyLong_FromUnsignedLongLong((uint32_t)(Seventeenth)));
	PyModule_AddObject(m, "Eighteenth", PyLong_FromUnsignedLongLong((uint32_t)(Eighteenth)));
	PyModule_AddObject(m, "Nineteenth", PyLong_FromUnsignedLongLong((uint32_t)(Nineteenth)));
	PyModule_AddObject(m, "Twentyth", PyLong_FromUnsignedLongLong((uint32_t)(Twentyth)));
	PyModule_AddObject(m, "Twentyfirst", PyLong_FromUnsignedLongLong((uint32_t)(Twentyfirst)));
	PyModule_AddObject(m, "Twentysecond", PyLong_FromUnsignedLongLong((uint32_t)(Twentysecond)));
	PyModule_AddObject(m, "Twentythird", PyLong_FromUnsignedLongLong((uint32_t)(Twentythird)));
	PyModule_AddObject(m, "Twentyfourth", PyLong_FromUnsignedLongLong((uint32_t)(Twentyfourth)));
	PyModule_AddObject(m, "Twentyfifth", PyLong_FromUnsignedLongLong((uint32_t)(Twentyfifth)));
	PyModule_AddObject(m, "Twentysixth", PyLong_FromUnsignedLongLong((uint32_t)(Twentysixth)));
	PyModule_AddObject(m, "Twentyseventh", PyLong_FromUnsignedLongLong((uint32_t)(Twentyseventh)));
	PyModule_AddObject(m, "Twentyeighth", PyLong_FromUnsignedLongLong((uint32_t)(Twentyeighth)));
	PyModule_AddObject(m, "Twentyninth", PyLong_FromUnsignedLongLong((uint32_t)(Twentyninth)));
	PyModule_AddObject(m, "Thirtieth", PyLong_FromUnsignedLongLong((uint32_t)(Thirtieth)));
	PyModule_AddObject(m, "Thirtyfirst", PyLong_FromUnsignedLongLong((uint32_t)(Thirtyfirst)));
	PyModule_AddObject(m, "JOB_RUN_PERIODICALLY", PyLong_FromLong((uint16_t)(JOB_RUN_PERIODICALLY)));
	PyModule_AddObject(m, "JOB_EXEC_ERROR", PyLong_FromLong((uint16_t)(JOB_EXEC_ERROR)));
	PyModule_AddObject(m, "JOB_RUNS_TODAY", PyLong_FromLong((uint16_t)(JOB_RUNS_TODAY)));
	PyModule_AddObject(m, "JOB_ADD_CURRENT_DATE", PyLong_FromLong((uint16_t)(JOB_ADD_CURRENT_DATE)));
	PyModule_AddObject(m, "JOB_NONINTERACTIVE", PyLong_FromLong((uint16_t)(JOB_NONINTERACTIVE)));
	PyModule_AddObject(m, "DAYSOFWEEK_MONDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_MONDAY)));
	PyModule_AddObject(m, "DAYSOFWEEK_TUESDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_TUESDAY)));
	PyModule_AddObject(m, "DAYSOFWEEK_WEDNESDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_WEDNESDAY)));
	PyModule_AddObject(m, "DAYSOFWEEK_THURSDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_THURSDAY)));
	PyModule_AddObject(m, "DAYSOFWEEK_FRIDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_FRIDAY)));
	PyModule_AddObject(m, "DAYSOFWEEK_SATURDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_SATURDAY)));
	PyModule_AddObject(m, "DAYSOFWEEK_SUNDAY", PyLong_FromLong((uint16_t)(DAYSOFWEEK_SUNDAY)));
	Py_INCREF((PyObject *)(void *)&atsvc_JobInfo_Type);
	PyModule_AddObject(m, "JobInfo", (PyObject *)(void *)&atsvc_JobInfo_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_JobEnumInfo_Type);
	PyModule_AddObject(m, "JobEnumInfo", (PyObject *)(void *)&atsvc_JobEnumInfo_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_enum_ctr_Type);
	PyModule_AddObject(m, "enum_ctr", (PyObject *)(void *)&atsvc_enum_ctr_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_JobAdd_Type);
	PyModule_AddObject(m, "JobAdd", (PyObject *)(void *)&atsvc_JobAdd_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_JobDel_Type);
	PyModule_AddObject(m, "JobDel", (PyObject *)(void *)&atsvc_JobDel_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_JobEnum_Type);
	PyModule_AddObject(m, "JobEnum", (PyObject *)(void *)&atsvc_JobEnum_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_JobGetInfo_Type);
	PyModule_AddObject(m, "JobGetInfo", (PyObject *)(void *)&atsvc_JobGetInfo_Type);
	Py_INCREF((PyObject *)(void *)&atsvc_InterfaceType);
	PyModule_AddObject(m, "atsvc", (PyObject *)(void *)&atsvc_InterfaceType);
	Py_INCREF((PyObject *)(void *)&atsvc_SyntaxType);
	PyModule_AddObject(m, "atsvc_abstract_syntax", (PyObject *)(void *)&atsvc_SyntaxType);
	Py_INCREF((PyObject *)(void *)&atsvc_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&atsvc_SyntaxType);
#ifdef PY_MOD_ATSVC_PATCH
	PY_MOD_ATSVC_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
