/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_netlogon
#define _PIDL_HEADER_netlogon

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/nbt.h"
#define netr_DeltaEnum8Bit netr_DeltaEnum
#define netr_SamDatabaseID8Bit netr_SamDatabaseID
#define ENC_CRC32 KERB_ENCTYPE_DES_CBC_CRC
#define ENC_RSA_MD5 KERB_ENCTYPE_DES_CBC_MD5
#define ENC_RC4_HMAC_MD5 KERB_ENCTYPE_RC4_HMAC_MD5
#define ENC_HMAC_SHA1_96_AES128 KERB_ENCTYPE_AES128_CTS_HMAC_SHA1_96
#define ENC_HMAC_SHA1_96_AES256 KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96
#define ENC_HMAC_SHA1_96_AES256_SK KERB_ENCTYPE_AES256_CTS_HMAC_SHA1_96_SK
#define ENC_FAST_SUPPORTED KERB_ENCTYPE_FAST_SUPPORTED
#define ENC_COMPOUND_IDENTITY_SUPPORTED KERB_ENCTYPE_COMPOUND_IDENTITY_SUPPORTED
#define ENC_CLAIMS_SUPPORTED KERB_ENCTYPE_CLAIMS_SUPPORTED
#define ENC_RESOURCE_SID_COMPRESSION_DISABLED KERB_ENCTYPE_RESOURCE_SID_COMPRESSION_DISABLED
#define NETLOGON_SERVER_PIPE_STATE_MAGIC 0x4f555358
#define DS_SERVER_PDC NBT_SERVER_PDC
#define DS_SERVER_GC NBT_SERVER_GC
#define DS_SERVER_LDAP NBT_SERVER_LDAP
#define DS_SERVER_DS NBT_SERVER_DS
#define DS_SERVER_KDC NBT_SERVER_KDC
#define DS_SERVER_TIMESERV NBT_SERVER_TIMESERV
#define DS_SERVER_CLOSEST NBT_SERVER_CLOSEST
#define DS_SERVER_WRITABLE NBT_SERVER_WRITABLE
#define DS_SERVER_GOOD_TIMESERV NBT_SERVER_GOOD_TIMESERV
#define DS_SERVER_NDNC NBT_SERVER_NDNC
#define DS_SERVER_SELECT_SECRET_DOMAIN_6 NBT_SERVER_SELECT_SECRET_DOMAIN_6 /* 2008 / RODC */
#define DS_SERVER_FULL_SECRET_DOMAIN_6 NBT_SERVER_FULL_SECRET_DOMAIN_6 /* 2008 */
#define DS_SERVER_WEBSERV NBT_SERVER_ADS_WEB_SERVICE
#define DS_SERVER_DS_8 NBT_SERVER_DS_8 /* 2012 */
#define DS_SERVER_DS_9 NBT_SERVER_DS_9 /* 2012R2 */
#define DS_SERVER_DS_10 NBT_SERVER_DS_10 /* 2016 */
#define DS_DNS_CONTROLLER NBT_SERVER_HAS_DNS_NAME
#define DS_DNS_DOMAIN NBT_SERVER_IS_DEFAULT_NC
#define DS_DNS_FOREST_ROOT NBT_SERVER_FOREST_ROOT
#ifndef _HEADER_netlogon
#define _HEADER_netlogon

#define NETLOGON_NEG_128BIT	( NETLOGON_NEG_STRONG_KEYS )
#define NETLOGON_NEG_SCHANNEL	( NETLOGON_NEG_AUTHENTICATED_RPC )
#define DSGETDC_VALID_FLAGS	( (DS_FORCE_REDISCOVERY|DS_DIRECTORY_SERVICE_REQUIRED|DS_DIRECTORY_SERVICE_PREFERRED|DS_GC_SERVER_REQUIRED|DS_PDC_REQUIRED|DS_BACKGROUND_ONLY|DS_IP_REQUIRED|DS_KDC_REQUIRED|DS_TIMESERV_REQUIRED|DS_WRITABLE_REQUIRED|DS_GOOD_TIMESERV_PREFERRED|DS_AVOID_SELF|DS_ONLY_LDAP_NEEDED|DS_IS_FLAT_NAME|DS_IS_DNS_NAME|DS_TRY_NEXTCLOSEST_SITE|DS_DIRECTORY_SERVICE_6_REQUIRED|DS_WEB_SERVICE_REQUIRED|DS_DIRECTORY_SERVICE_8_REQUIRED|DS_DIRECTORY_SERVICE_9_REQUIRED|DS_DIRECTORY_SERVICE_10_REQUIRED|DS_RETURN_FLAT_NAME|DS_RETURN_DNS_NAME) )
#define NETLOGON_PASSWORD_VERSION_NUMBER_PRESENT	( 0x02231968 )
#define DS_GFTI_UPDATE_TDO	( 0x1 )
struct netr_UasInfo {
	const char *account_name;/* [charset(UTF16),unique] */
	uint32_t priv;
	uint32_t auth_flags;
	uint32_t logon_count;
	uint32_t bad_pw_count;
	time_t last_logon;
	time_t last_logoff;
	time_t logoff_time;
	time_t kickoff_time;
	uint32_t password_age;
	time_t pw_can_change;
	time_t pw_must_change;
	const char *computer;/* [charset(UTF16),unique] */
	const char *domain;/* [charset(UTF16),unique] */
	const char *script_path;/* [charset(UTF16),unique] */
	uint32_t unknown;
};

struct netr_UasLogoffInfo {
	uint32_t duration;
	uint16_t logon_count;
};

struct netr_AcctLockStr {
	int64_t lockout_duration;
	uint64_t reset_count;
	uint32_t bad_attempt_lockout;
	uint32_t dummy;
}/* [public] */;

/* bitmap netr_LogonParameterControl */
#define MSV1_0_CLEARTEXT_PASSWORD_ALLOWED ( 0x00000002 )
#define MSV1_0_UPDATE_LOGON_STATISTICS ( 0x00000004 )
#define MSV1_0_RETURN_USER_PARAMETERS ( 0x00000008 )
#define MSV1_0_DONT_TRY_GUEST_ACCOUNT ( 0x00000010 )
#define MSV1_0_ALLOW_SERVER_TRUST_ACCOUNT ( 0x00000020 )
#define MSV1_0_RETURN_PASSWORD_EXPIRY ( 0x00000040 )
#define MSV1_0_USE_CLIENT_CHALLENGE ( 0x00000080 )
#define MSV1_0_TRY_GUEST_ACCOUNT_ONLY ( 0x00000100 )
#define MSV1_0_RETURN_PROFILE_PATH ( 0x00000200 )
#define MSV1_0_TRY_SPECIFIED_DOMAIN_ONLY ( 0x00000400 )
#define MSV1_0_ALLOW_WORKSTATION_TRUST_ACCOUNT ( 0x00000800 )
#define MSV1_0_DISABLE_PERSONAL_FALLBACK ( 0x00001000 )
#define MSV1_0_ALLOW_FORCE_GUEST ( 0x00002000 )
#define MSV1_0_CLEARTEXT_PASSWORD_SUPPLIED ( 0x00004000 )
#define MSV1_0_USE_DOMAIN_FOR_ROUTING_ONLY ( 0x00008000 )
#define MSV1_0_ALLOW_MSVCHAPV2 ( 0x00010000 )
#define MSV1_0_S4U2SELF ( 0x00020000 )
#define MSV1_0_CHECK_LOGONHOURS_FOR_S4U ( 0x00040000 )
#define MSV1_0_SUBAUTHENTICATION_DLL_EX ( 0x00100000 )

struct netr_IdentityInfo {
	struct lsa_String domain_name;
	uint32_t parameter_control;
	uint64_t logon_id;
	struct lsa_String account_name;
	struct lsa_String workstation;
};

struct netr_PasswordInfo {
	struct netr_IdentityInfo identity_info;
	struct samr_Password lmpassword;
	struct samr_Password ntpassword;
};

struct netr_ChallengeResponse {
	uint16_t length;
	uint16_t size;/* [value(length)] */
	uint8_t *data;/* [length_is(length),size_is(length),unique] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_NetworkInfo {
	struct netr_IdentityInfo identity_info;
	uint8_t challenge[8];
	struct netr_ChallengeResponse nt;
	struct netr_ChallengeResponse lm;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_GenericInfo {
	struct netr_IdentityInfo identity_info;
	struct lsa_String package_name;
	uint32_t length;
	uint8_t *data;/* [size_is(length),unique] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

enum netr_LogonInfoClass
#ifndef USE_UINT_ENUMS
 {
	NetlogonInteractiveInformation=(int)(1),
	NetlogonNetworkInformation=(int)(2),
	NetlogonServiceInformation=(int)(3),
	NetlogonGenericInformation=(int)(4),
	NetlogonInteractiveTransitiveInformation=(int)(5),
	NetlogonNetworkTransitiveInformation=(int)(6),
	NetlogonServiceTransitiveInformation=(int)(7)
}
#else
 { __do_not_use_enum_netr_LogonInfoClass=INT_MAX}
#define NetlogonInteractiveInformation ( 1 )
#define NetlogonNetworkInformation ( 2 )
#define NetlogonServiceInformation ( 3 )
#define NetlogonGenericInformation ( 4 )
#define NetlogonInteractiveTransitiveInformation ( 5 )
#define NetlogonNetworkTransitiveInformation ( 6 )
#define NetlogonServiceTransitiveInformation ( 7 )
#endif
;

union netr_LogonLevel {
	struct netr_PasswordInfo *password;/* [case(NetlogonInteractiveInformation),unique] */
	struct netr_NetworkInfo *network;/* [case(NetlogonNetworkInformation),unique] */
	struct netr_GenericInfo *generic;/* [case(NetlogonGenericInformation),unique] */
}/* [public,switch_type(netr_LogonInfoClass)] */;

struct netr_UserSessionKey {
	uint8_t key[16];
}/* [flag(LIBNDR_PRINT_ARRAY_HEX),public] */;

struct netr_LMSessionKey {
	uint8_t key[8];
}/* [flag(LIBNDR_PRINT_ARRAY_HEX),public] */;

/* bitmap netr_UserFlags */
#define NETLOGON_GUEST ( 0x00000001 )
#define NETLOGON_NOENCRYPTION ( 0x00000002 )
#define NETLOGON_CACHED_ACCOUNT ( 0x00000004 )
#define NETLOGON_USED_LM_PASSWORD ( 0x00000008 )
#define NETLOGON_EXTRA_SIDS ( 0x00000020 )
#define NETLOGON_SUBAUTH_SESSION_KEY ( 0x00000040 )
#define NETLOGON_SERVER_TRUST_ACCOUNT ( 0x00000080 )
#define NETLOGON_NTLMV2_ENABLED ( 0x00000100 )
#define NETLOGON_RESOURCE_GROUPS ( 0x00000200 )
#define NETLOGON_PROFILE_PATH_RETURNED ( 0x00000400 )
#define NETLOGON_GRACE_LOGON ( 0x01000000 )

struct netr_SamBaseInfo {
	NTTIME logon_time;
	NTTIME logoff_time;
	NTTIME kickoff_time;
	NTTIME last_password_change;
	NTTIME allow_password_change;
	NTTIME force_password_change;
	struct lsa_String account_name;
	struct lsa_String full_name;
	struct lsa_String logon_script;
	struct lsa_String profile_path;
	struct lsa_String home_directory;
	struct lsa_String home_drive;
	uint16_t logon_count;
	uint16_t bad_password_count;
	uint32_t rid;
	uint32_t primary_gid;
	struct samr_RidWithAttributeArray groups;
	uint32_t user_flags;
	struct netr_UserSessionKey key;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
	struct lsa_StringLarge logon_server;
	struct lsa_StringLarge logon_domain;
	struct dom_sid2 *domain_sid;/* [unique] */
	struct netr_LMSessionKey LMSessKey;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
	uint32_t acct_flags;
	uint32_t sub_auth_status;
	NTTIME last_successful_logon;
	NTTIME last_failed_logon;
	uint32_t failed_logon_count;
	uint32_t reserved;
};

struct netr_SamInfo2 {
	struct netr_SamBaseInfo base;
};

struct netr_SidAttr {
	struct dom_sid2 *sid;/* [unique] */
	uint32_t attributes;
}/* [public] */;

struct netr_SamInfo3 {
	struct netr_SamBaseInfo base;
	uint32_t sidcount;
	struct netr_SidAttr *sids;/* [size_is(sidcount),unique] */
}/* [public] */;

struct netr_SamInfo6 {
	struct netr_SamBaseInfo base;
	uint32_t sidcount;
	struct netr_SidAttr *sids;/* [size_is(sidcount),unique] */
	struct lsa_String dns_domainname;
	struct lsa_String principal_name;
	uint32_t unknown4[20];
};

struct netr_PacInfo {
	uint32_t pac_size;
	uint8_t *pac;/* [size_is(pac_size),unique] */
	struct lsa_String logon_domain;
	struct lsa_String logon_server;
	struct lsa_String principal_name;
	uint32_t auth_size;
	uint8_t *auth;/* [size_is(auth_size),unique] */
	struct netr_UserSessionKey user_session_key;
	uint32_t expansionroom[10];
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
};

struct netr_GenericInfo2 {
	uint32_t length;
	uint8_t *data;/* [size_is(length),unique] */
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

enum netr_ValidationInfoClass
#ifndef USE_UINT_ENUMS
 {
	NetlogonValidationUasInfo=(int)(1),
	NetlogonValidationSamInfo=(int)(2),
	NetlogonValidationSamInfo2=(int)(3),
	NetlogonValidationGenericInfo2=(int)(5),
	NetlogonValidationSamInfo4=(int)(6)
}
#else
 { __do_not_use_enum_netr_ValidationInfoClass=INT_MAX}
#define NetlogonValidationUasInfo ( 1 )
#define NetlogonValidationSamInfo ( 2 )
#define NetlogonValidationSamInfo2 ( 3 )
#define NetlogonValidationGenericInfo2 ( 5 )
#define NetlogonValidationSamInfo4 ( 6 )
#endif
;

union netr_Validation {
	struct netr_SamInfo2 *sam2;/* [case(NetlogonValidationSamInfo),unique] */
	struct netr_SamInfo3 *sam3;/* [case(NetlogonValidationSamInfo2),unique] */
	struct netr_PacInfo *pac;/* [case(4),unique] */
	struct netr_GenericInfo2 *generic;/* [case(NetlogonValidationGenericInfo2),unique] */
	struct netr_SamInfo6 *sam6;/* [case(NetlogonValidationSamInfo4),unique] */
}/* [public,switch_type(uint16)] */;

struct netr_Credential {
	uint8_t data[8];
}/* [flag(LIBNDR_PRINT_ARRAY_HEX),public] */;

struct netlogon_server_pipe_state {
	struct netr_Credential client_challenge;
	struct netr_Credential server_challenge;
}/* [public] */;

struct netr_Authenticator {
	struct netr_Credential cred;
	time_t timestamp;
}/* [public] */;

struct netr_DELTA_DELETE_USER {
	const char *account_name;/* [charset(UTF16),unique] */
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_USER_KEY16 {
	uint16_t length;
	uint16_t size;/* [value(length)] */
	uint32_t flags;
	struct samr_Password pwd;
};

struct netr_PasswordHistory {
	uint16_t nt_length;
	uint16_t nt_size;/* [value(nt_length)] */
	uint32_t nt_flags;
	uint16_t lm_length;
	uint16_t lm_size;/* [value(lm_length)] */
	uint32_t lm_flags;
	uint8_t *nt_history;
	uint8_t *lm_history;
};

struct netr_USER_KEYS2 {
	struct netr_USER_KEY16 lmpassword;
	struct netr_USER_KEY16 ntpassword;
	struct netr_PasswordHistory history;
};

struct netr_USER_KEY_UNION {
	struct netr_USER_KEYS2 keys2;
};

struct netr_USER_KEYS {
	uint32_t version;
	struct netr_USER_KEY_UNION keys;
}/* [public] */;

struct netr_USER_PRIVATE_INFO {
	uint8_t SensitiveDataFlag;
	uint32_t DataLength;
	uint8_t *SensitiveData;/* [flag(LIBNDR_PRINT_ARRAY_HEX),size_is(DataLength),unique] */
};

struct netr_DELTA_USER {
	struct lsa_String account_name;
	struct lsa_String full_name;
	uint32_t rid;
	uint32_t primary_gid;
	struct lsa_String home_directory;
	struct lsa_String home_drive;
	struct lsa_String logon_script;
	struct lsa_String description;
	struct lsa_String workstations;
	NTTIME last_logon;
	NTTIME last_logoff;
	struct samr_LogonHours logon_hours;
	uint16_t bad_password_count;
	uint16_t logon_count;
	NTTIME last_password_change;
	NTTIME acct_expiry;
	uint32_t acct_flags;
	struct samr_Password lmpassword;
	struct samr_Password ntpassword;
	uint8_t nt_password_present;
	uint8_t lm_password_present;
	uint8_t password_expired;
	struct lsa_String comment;
	struct lsa_BinaryString parameters;
	uint16_t country_code;
	uint16_t code_page;
	struct netr_USER_PRIVATE_INFO user_private_info;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String profile_path;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_DOMAIN {
	struct lsa_String domain_name;
	struct lsa_String oem_information;
	int64_t force_logoff_time;
	uint16_t min_password_length;
	uint16_t password_history_length;
	int64_t max_password_age;
	int64_t min_password_age;
	uint64_t sequence_num;
	NTTIME domain_create_time;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_BinaryString account_lockout;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t logon_to_chgpass;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_GROUP {
	struct lsa_String group_name;
	uint32_t rid;
	uint32_t attributes;
	struct lsa_String description;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_RENAME {
	struct lsa_String OldName;
	struct lsa_String NewName;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_GROUP_MEMBER {
	uint32_t *rids;/* [size_is(num_rids),unique] */
	uint32_t *attribs;/* [size_is(num_rids),unique] */
	uint32_t num_rids;
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t unknown3;
	uint32_t unknown4;
};

struct netr_DELTA_ALIAS {
	struct lsa_String alias_name;
	uint32_t rid;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String description;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_ALIAS_MEMBER {
	struct lsa_SidArray sids;
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t unknown3;
	uint32_t unknown4;
};

struct netr_QUOTA_LIMITS {
	uint32_t pagedpoollimit;
	uint32_t nonpagedpoollimit;
	uint32_t minimumworkingsetsize;
	uint32_t maximumworkingsetsize;
	uint32_t pagefilelimit;
	NTTIME timelimit;
};

struct netr_DELTA_POLICY {
	uint32_t maxlogsize;
	NTTIME auditretentionperiod;
	uint8_t auditingmode;
	uint32_t maxauditeventcount;
	uint32_t *eventauditoptions;/* [size_is(maxauditeventcount+1),unique] */
	struct lsa_String primary_domain_name;
	struct dom_sid2 *sid;/* [unique] */
	struct netr_QUOTA_LIMITS quota_limits;
	uint64_t sequence_num;
	NTTIME db_create_time;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_TRUSTED_DOMAIN {
	struct lsa_String domain_name;
	uint32_t num_controllers;
	struct lsa_String *controller_names;/* [size_is(num_controllers),unique] */
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t posix_offset;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_DELTA_ACCOUNT {
	uint32_t privilege_entries;
	uint32_t privilege_control;
	uint32_t *privilege_attrib;/* [size_is(privilege_entries),unique] */
	struct lsa_String *privilege_name;/* [size_is(privilege_entries),unique] */
	struct netr_QUOTA_LIMITS quotalimits;
	uint32_t system_flags;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

struct netr_CIPHER_VALUE {
	uint32_t len;
	uint32_t maxlen;
	uint8_t *cipher_data;/* [length_is(len),size_is(maxlen),unique] */
};

struct netr_DELTA_SECRET {
	struct netr_CIPHER_VALUE current_cipher;
	NTTIME current_cipher_set_time;
	struct netr_CIPHER_VALUE old_cipher;
	NTTIME old_cipher_set_time;
	uint32_t SecurityInformation;
	struct sec_desc_buf sdbuf;
	struct lsa_String unknown1;
	struct lsa_String unknown2;
	struct lsa_String unknown3;
	struct lsa_String unknown4;
	uint32_t unknown5;
	uint32_t unknown6;
	uint32_t unknown7;
	uint32_t unknown8;
};

enum netr_DeltaEnum
#ifndef USE_UINT_ENUMS
 {
	NETR_DELTA_DOMAIN=(int)(1),
	NETR_DELTA_GROUP=(int)(2),
	NETR_DELTA_DELETE_GROUP=(int)(3),
	NETR_DELTA_RENAME_GROUP=(int)(4),
	NETR_DELTA_USER=(int)(5),
	NETR_DELTA_DELETE_USER=(int)(6),
	NETR_DELTA_RENAME_USER=(int)(7),
	NETR_DELTA_GROUP_MEMBER=(int)(8),
	NETR_DELTA_ALIAS=(int)(9),
	NETR_DELTA_DELETE_ALIAS=(int)(10),
	NETR_DELTA_RENAME_ALIAS=(int)(11),
	NETR_DELTA_ALIAS_MEMBER=(int)(12),
	NETR_DELTA_POLICY=(int)(13),
	NETR_DELTA_TRUSTED_DOMAIN=(int)(14),
	NETR_DELTA_DELETE_TRUST=(int)(15),
	NETR_DELTA_ACCOUNT=(int)(16),
	NETR_DELTA_DELETE_ACCOUNT=(int)(17),
	NETR_DELTA_SECRET=(int)(18),
	NETR_DELTA_DELETE_SECRET=(int)(19),
	NETR_DELTA_DELETE_GROUP2=(int)(20),
	NETR_DELTA_DELETE_USER2=(int)(21),
	NETR_DELTA_MODIFY_COUNT=(int)(22)
}
#else
 { __do_not_use_enum_netr_DeltaEnum=INT_MAX}
#define NETR_DELTA_DOMAIN ( 1 )
#define NETR_DELTA_GROUP ( 2 )
#define NETR_DELTA_DELETE_GROUP ( 3 )
#define NETR_DELTA_RENAME_GROUP ( 4 )
#define NETR_DELTA_USER ( 5 )
#define NETR_DELTA_DELETE_USER ( 6 )
#define NETR_DELTA_RENAME_USER ( 7 )
#define NETR_DELTA_GROUP_MEMBER ( 8 )
#define NETR_DELTA_ALIAS ( 9 )
#define NETR_DELTA_DELETE_ALIAS ( 10 )
#define NETR_DELTA_RENAME_ALIAS ( 11 )
#define NETR_DELTA_ALIAS_MEMBER ( 12 )
#define NETR_DELTA_POLICY ( 13 )
#define NETR_DELTA_TRUSTED_DOMAIN ( 14 )
#define NETR_DELTA_DELETE_TRUST ( 15 )
#define NETR_DELTA_ACCOUNT ( 16 )
#define NETR_DELTA_DELETE_ACCOUNT ( 17 )
#define NETR_DELTA_SECRET ( 18 )
#define NETR_DELTA_DELETE_SECRET ( 19 )
#define NETR_DELTA_DELETE_GROUP2 ( 20 )
#define NETR_DELTA_DELETE_USER2 ( 21 )
#define NETR_DELTA_MODIFY_COUNT ( 22 )
#endif
;

union netr_DELTA_UNION {
	struct netr_DELTA_DOMAIN *domain;/* [case(NETR_DELTA_DOMAIN),unique] */
	struct netr_DELTA_GROUP *group;/* [case(NETR_DELTA_GROUP),unique] */
	struct netr_DELTA_RENAME *rename_group;/* [case(NETR_DELTA_RENAME_GROUP),unique] */
	struct netr_DELTA_USER *user;/* [case(NETR_DELTA_USER),unique] */
	struct netr_DELTA_RENAME *rename_user;/* [case(NETR_DELTA_RENAME_USER),unique] */
	struct netr_DELTA_GROUP_MEMBER *group_member;/* [case(NETR_DELTA_GROUP_MEMBER),unique] */
	struct netr_DELTA_ALIAS *alias;/* [case(NETR_DELTA_ALIAS),unique] */
	struct netr_DELTA_RENAME *rename_alias;/* [case(NETR_DELTA_RENAME_ALIAS),unique] */
	struct netr_DELTA_ALIAS_MEMBER *alias_member;/* [case(NETR_DELTA_ALIAS_MEMBER),unique] */
	struct netr_DELTA_POLICY *policy;/* [case(NETR_DELTA_POLICY),unique] */
	struct netr_DELTA_TRUSTED_DOMAIN *trusted_domain;/* [case(NETR_DELTA_TRUSTED_DOMAIN),unique] */
	struct netr_DELTA_ACCOUNT *account;/* [case(NETR_DELTA_ACCOUNT),unique] */
	struct netr_DELTA_SECRET *secret;/* [case(NETR_DELTA_SECRET),unique] */
	struct netr_DELTA_DELETE_USER *delete_group;/* [case(NETR_DELTA_DELETE_GROUP2),unique] */
	struct netr_DELTA_DELETE_USER *delete_user;/* [case(NETR_DELTA_DELETE_USER2),unique] */
	uint64_t *modified_count;/* [case(NETR_DELTA_MODIFY_COUNT),unique] */
}/* [switch_type(netr_DeltaEnum)] */;

union netr_DELTA_ID_UNION {
	uint32_t rid;/* [case(NETR_DELTA_DOMAIN)] */
	struct dom_sid2 *sid;/* [case(NETR_DELTA_POLICY),unique] */
	const char *name;/* [case(NETR_DELTA_SECRET),charset(UTF16),unique] */
}/* [switch_type(netr_DeltaEnum)] */;

struct netr_DELTA_ENUM {
	enum netr_DeltaEnum delta_type;
	union netr_DELTA_ID_UNION delta_id_union;/* [switch_is(delta_type)] */
	union netr_DELTA_UNION delta_union;/* [switch_is(delta_type)] */
};

struct netr_DELTA_ENUM_ARRAY {
	uint32_t num_deltas;
	struct netr_DELTA_ENUM *delta_enum;/* [size_is(num_deltas),unique] */
};

struct netr_UAS_INFO_0 {
	uint8_t computer_name[16];
	uint32_t timecreated;
	uint32_t serial_number;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

struct netr_AccountBuffer {
	DATA_BLOB blob;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

/* bitmap netr_InfoFlags */
#define NETLOGON_REPLICATION_NEEDED ( 0x00000001 )
#define NETLOGON_REPLICATION_IN_PROGRESS ( 0x00000002 )
#define NETLOGON_FULL_SYNC_REPLICATION ( 0x00000004 )
#define NETLOGON_REDO_NEEDED ( 0x00000008 )
#define NETLOGON_HAS_IP ( 0x00000010 )
#define NETLOGON_HAS_TIMESERV ( 0x00000020 )
#define NETLOGON_DNS_UPDATE_FAILURE ( 0x00000040 )
#define NETLOGON_VERIFY_STATUS_RETURNED ( 0x00000080 )

struct netr_NETLOGON_INFO_1 {
	uint32_t flags;
	WERROR pdc_connection_status;
};

struct netr_NETLOGON_INFO_2 {
	uint32_t flags;
	WERROR pdc_connection_status;
	const char *trusted_dc_name;/* [charset(UTF16),unique] */
	WERROR tc_connection_status;
};

struct netr_NETLOGON_INFO_3 {
	uint32_t flags;
	uint32_t logon_attempts;
	uint32_t unknown1;
	uint32_t unknown2;
	uint32_t unknown3;
	uint32_t unknown4;
	uint32_t unknown5;
};

struct netr_NETLOGON_INFO_4 {
	const char *trusted_dc_name;/* [charset(UTF16),unique] */
	const char *trusted_domain_name;/* [charset(UTF16),unique] */
};

union netr_CONTROL_QUERY_INFORMATION {
	struct netr_NETLOGON_INFO_1 *info1;/* [case,unique] */
	struct netr_NETLOGON_INFO_2 *info2;/* [case(2),unique] */
	struct netr_NETLOGON_INFO_3 *info3;/* [case(3),unique] */
	struct netr_NETLOGON_INFO_4 *info4;/* [case(4),unique] */
}/* [public] */;

enum netr_LogonControlCode
#ifndef USE_UINT_ENUMS
 {
	NETLOGON_CONTROL_QUERY=(int)(0x00000001),
	NETLOGON_CONTROL_REPLICATE=(int)(0x00000002),
	NETLOGON_CONTROL_SYNCHRONIZE=(int)(0x00000003),
	NETLOGON_CONTROL_PDC_REPLICATE=(int)(0x00000004),
	NETLOGON_CONTROL_REDISCOVER=(int)(0x00000005),
	NETLOGON_CONTROL_TC_QUERY=(int)(0x00000006),
	NETLOGON_CONTROL_TRANSPORT_NOTIFY=(int)(0x00000007),
	NETLOGON_CONTROL_FIND_USER=(int)(0x00000008),
	NETLOGON_CONTROL_CHANGE_PASSWORD=(int)(0x00000009),
	NETLOGON_CONTROL_TC_VERIFY=(int)(0x0000000A),
	NETLOGON_CONTROL_FORCE_DNS_REG=(int)(0x0000000B),
	NETLOGON_CONTROL_QUERY_DNS_REG=(int)(0x0000000C),
	NETLOGON_CONTROL_BACKUP_CHANGE_LOG=(int)(0x0000FFFC),
	NETLOGON_CONTROL_TRUNCATE_LOG=(int)(0x0000FFFD),
	NETLOGON_CONTROL_SET_DBFLAG=(int)(0x0000FFFE),
	NETLOGON_CONTROL_BREAKPOINT=(int)(0x0000FFFF)
}
#else
 { __do_not_use_enum_netr_LogonControlCode=INT_MAX}
#define NETLOGON_CONTROL_QUERY ( 0x00000001 )
#define NETLOGON_CONTROL_REPLICATE ( 0x00000002 )
#define NETLOGON_CONTROL_SYNCHRONIZE ( 0x00000003 )
#define NETLOGON_CONTROL_PDC_REPLICATE ( 0x00000004 )
#define NETLOGON_CONTROL_REDISCOVER ( 0x00000005 )
#define NETLOGON_CONTROL_TC_QUERY ( 0x00000006 )
#define NETLOGON_CONTROL_TRANSPORT_NOTIFY ( 0x00000007 )
#define NETLOGON_CONTROL_FIND_USER ( 0x00000008 )
#define NETLOGON_CONTROL_CHANGE_PASSWORD ( 0x00000009 )
#define NETLOGON_CONTROL_TC_VERIFY ( 0x0000000A )
#define NETLOGON_CONTROL_FORCE_DNS_REG ( 0x0000000B )
#define NETLOGON_CONTROL_QUERY_DNS_REG ( 0x0000000C )
#define NETLOGON_CONTROL_BACKUP_CHANGE_LOG ( 0x0000FFFC )
#define NETLOGON_CONTROL_TRUNCATE_LOG ( 0x0000FFFD )
#define NETLOGON_CONTROL_SET_DBFLAG ( 0x0000FFFE )
#define NETLOGON_CONTROL_BREAKPOINT ( 0x0000FFFF )
#endif
;

union netr_CONTROL_DATA_INFORMATION {
	const char *domain;/* [case(NETLOGON_CONTROL_REDISCOVER),charset(UTF16),unique] */
	const char *user;/* [case(NETLOGON_CONTROL_FIND_USER),charset(UTF16),unique] */
	uint32_t debug_level;/* [case(NETLOGON_CONTROL_SET_DBFLAG)] */
}/* [public,switch_type(netr_LogonControlCode)] */;

/* bitmap netr_NegotiateFlags */
#define NETLOGON_NEG_ACCOUNT_LOCKOUT ( 0x00000001 )
#define NETLOGON_NEG_PERSISTENT_SAMREPL ( 0x00000002 )
#define NETLOGON_NEG_ARCFOUR ( 0x00000004 )
#define NETLOGON_NEG_PROMOTION_COUNT ( 0x00000008 )
#define NETLOGON_NEG_CHANGELOG_BDC ( 0x00000010 )
#define NETLOGON_NEG_FULL_SYNC_REPL ( 0x00000020 )
#define NETLOGON_NEG_MULTIPLE_SIDS ( 0x00000040 )
#define NETLOGON_NEG_REDO ( 0x00000080 )
#define NETLOGON_NEG_PASSWORD_CHANGE_REFUSAL ( 0x00000100 )
#define NETLOGON_NEG_SEND_PASSWORD_INFO_PDC ( 0x00000200 )
#define NETLOGON_NEG_GENERIC_PASSTHROUGH ( 0x00000400 )
#define NETLOGON_NEG_CONCURRENT_RPC ( 0x00000800 )
#define NETLOGON_NEG_AVOID_ACCOUNT_DB_REPL ( 0x00001000 )
#define NETLOGON_NEG_AVOID_SECURITYAUTH_DB_REPL ( 0x00002000 )
#define NETLOGON_NEG_STRONG_KEYS ( 0x00004000 )
#define NETLOGON_NEG_TRANSITIVE_TRUSTS ( 0x00008000 )
#define NETLOGON_NEG_DNS_DOMAIN_TRUSTS ( 0x00010000 )
#define NETLOGON_NEG_PASSWORD_SET2 ( 0x00020000 )
#define NETLOGON_NEG_GETDOMAININFO ( 0x00040000 )
#define NETLOGON_NEG_CROSS_FOREST_TRUSTS ( 0x00080000 )
#define NETLOGON_NEG_NEUTRALIZE_NT4_EMULATION ( 0x00100000 )
#define NETLOGON_NEG_RODC_PASSTHROUGH ( 0x00200000 )
#define NETLOGON_NEG_SUPPORTS_AES_SHA2 ( 0x00400000 )
#define NETLOGON_NEG_SUPPORTS_AES ( 0x01000000 )
#define NETLOGON_NEG_AUTHENTICATED_RPC_LSASS ( 0x20000000 )
#define NETLOGON_NEG_AUTHENTICATED_RPC ( 0x40000000 )

enum SyncStateEnum
#ifndef USE_UINT_ENUMS
 {
	SYNCSTATE_NORMAL_STATE=(int)(0),
	SYNCSTATE_DOMAIN_STATE=(int)(1),
	SYNCSTATE_GROUP_STATE=(int)(2),
	SYNCSTATE_UAS_BUILT_IN_GROUP_STATE=(int)(3),
	SYNCSTATE_USER_STATE=(int)(4),
	SYNCSTATE_GROUP_MEMBER_STATE=(int)(5),
	SYNCSTATE_ALIAS_STATE=(int)(6),
	SYNCSTATE_ALIAS_MEMBER_STATE=(int)(7),
	SYNCSTATE_SAM_DONE_STATE=(int)(8)
}
#else
 { __do_not_use_enum_SyncStateEnum=INT_MAX}
#define SYNCSTATE_NORMAL_STATE ( 0 )
#define SYNCSTATE_DOMAIN_STATE ( 1 )
#define SYNCSTATE_GROUP_STATE ( 2 )
#define SYNCSTATE_UAS_BUILT_IN_GROUP_STATE ( 3 )
#define SYNCSTATE_USER_STATE ( 4 )
#define SYNCSTATE_GROUP_MEMBER_STATE ( 5 )
#define SYNCSTATE_ALIAS_STATE ( 6 )
#define SYNCSTATE_ALIAS_MEMBER_STATE ( 7 )
#define SYNCSTATE_SAM_DONE_STATE ( 8 )
#endif
;

/* bitmap netr_ChangeLogFlags */
#define NETR_CHANGELOG_IMMEDIATE_REPL_REQUIRED ( 0x0001 )
#define NETR_CHANGELOG_CHANGED_PASSWORD ( 0x0002 )
#define NETR_CHANGELOG_SID_INCLUDED ( 0x0004 )
#define NETR_CHANGELOG_NAME_INCLUDED ( 0x0008 )
#define NETR_CHANGELOG_FIRST_PROMOTION_OBJ ( 0x0010 )

union netr_ChangeLogObject {
	struct dom_sid object_sid;/* [case(NETR_CHANGELOG_SID_INCLUDED)] */
	const char * object_name;/* [case(NETR_CHANGELOG_NAME_INCLUDED),flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2)] */
}/* [nodiscriminant] */;

struct netr_ChangeLogEntry {
	uint32_t serial_number1;
	uint32_t serial_number2;
	uint32_t object_rid;
	uint16_t flags;
	enum netr_SamDatabaseID8Bit db_index;
	enum netr_DeltaEnum8Bit delta_type;
	union netr_ChangeLogObject object;/* [switch_is(flags&(NETR_CHANGELOG_SID_INCLUDED|NETR_CHANGELOG_NAME_INCLUDED))] */
}/* [gensize,public] */;

struct netr_Blob {
	uint32_t length;
	uint8_t *data;/* [size_is(length),unique] */
};

/* bitmap netr_DsRGetDCName_flags */
#define DS_FORCE_REDISCOVERY ( 0x00000001 )
#define DS_DIRECTORY_SERVICE_REQUIRED ( 0x00000010 )
#define DS_DIRECTORY_SERVICE_PREFERRED ( 0x00000020 )
#define DS_GC_SERVER_REQUIRED ( 0x00000040 )
#define DS_PDC_REQUIRED ( 0x00000080 )
#define DS_BACKGROUND_ONLY ( 0x00000100 )
#define DS_IP_REQUIRED ( 0x00000200 )
#define DS_KDC_REQUIRED ( 0x00000400 )
#define DS_TIMESERV_REQUIRED ( 0x00000800 )
#define DS_WRITABLE_REQUIRED ( 0x00001000 )
#define DS_GOOD_TIMESERV_PREFERRED ( 0x00002000 )
#define DS_AVOID_SELF ( 0x00004000 )
#define DS_ONLY_LDAP_NEEDED ( 0x00008000 )
#define DS_IS_FLAT_NAME ( 0x00010000 )
#define DS_IS_DNS_NAME ( 0x00020000 )
#define DS_TRY_NEXTCLOSEST_SITE ( 0x00040000 )
#define DS_DIRECTORY_SERVICE_6_REQUIRED ( 0x00080000 )
#define DS_WEB_SERVICE_REQUIRED ( 0x00100000 )
#define DS_DIRECTORY_SERVICE_8_REQUIRED ( 0x00200000 )
#define DS_DIRECTORY_SERVICE_9_REQUIRED ( 0x00400000 )
#define DS_DIRECTORY_SERVICE_10_REQUIRED ( 0x00800000 )
#define DS_RETURN_DNS_NAME ( 0x40000000 )
#define DS_RETURN_FLAT_NAME ( 0x80000000 )

enum netr_DsRGetDCNameInfo_AddressType
#ifndef USE_UINT_ENUMS
 {
	DS_ADDRESS_TYPE_INET=(int)(1),
	DS_ADDRESS_TYPE_NETBIOS=(int)(2)
}
#else
 { __do_not_use_enum_netr_DsRGetDCNameInfo_AddressType=INT_MAX}
#define DS_ADDRESS_TYPE_INET ( 1 )
#define DS_ADDRESS_TYPE_NETBIOS ( 2 )
#endif
;

struct netr_DsRGetDCNameInfo {
	const char *dc_unc;/* [charset(UTF16),unique] */
	const char *dc_address;/* [charset(UTF16),unique] */
	enum netr_DsRGetDCNameInfo_AddressType dc_address_type;
	struct GUID domain_guid;
	const char *domain_name;/* [charset(UTF16),unique] */
	const char *forest_name;/* [charset(UTF16),unique] */
	uint32_t dc_flags;
	const char *dc_site_name;/* [charset(UTF16),unique] */
	const char *client_site_name;/* [charset(UTF16),unique] */
}/* [public] */;

union netr_Capabilities {
	uint32_t server_capabilities;/* [case] */
}/* [switch_type(uint32)] */;

/* bitmap netr_TrustFlags */
#define NETR_TRUST_FLAG_IN_FOREST ( 0x00000001 )
#define NETR_TRUST_FLAG_OUTBOUND ( 0x00000002 )
#define NETR_TRUST_FLAG_TREEROOT ( 0x00000004 )
#define NETR_TRUST_FLAG_PRIMARY ( 0x00000008 )
#define NETR_TRUST_FLAG_NATIVE ( 0x00000010 )
#define NETR_TRUST_FLAG_INBOUND ( 0x00000020 )
#define NETR_TRUST_FLAG_MIT_KRB5 ( 0x00000080 )
#define NETR_TRUST_FLAG_AES ( 0x00000100 )

/* bitmap netr_WorkstationFlags */
#define NETR_WS_FLAG_HANDLES_INBOUND_TRUSTS ( 0x00000001 )
#define NETR_WS_FLAG_HANDLES_SPN_UPDATE ( 0x00000002 )

/* bitmap netr_SuiteMask */
#define NETR_VER_SUITE_BACKOFFICE ( 0x0004 )
#define NETR_VER_SUITE_BLADE ( 0x0400 )
#define NETR_VER_SUITE_COMPUTE_SERVER ( 0x4000 )
#define NETR_VER_SUITE_DATACENTER ( 0x0080 )
#define NETR_VER_SUITE_ENTERPRISE ( 0x0002 )
#define NETR_VER_SUITE_EMBEDDEDNT ( 0x0040 )
#define NETR_VER_SUITE_PERSONAL ( 0x0200 )
#define NETR_VER_SUITE_SINGLEUSERTS ( 0x0100 )
#define NETR_VER_SUITE_SMALLBUSINESS ( 0x0001 )
#define NETR_VER_SUITE_SMALLBUSINESS_RESTRICTED ( 0x0020 )
#define NETR_VER_SUITE_STORAGE_SERVER ( 0x2000 )
#define NETR_VER_SUITE_TERMINAL ( 0x0010 )
#define NETR_VER_SUITE_WH_SERVER ( 0x8000 )

/* bitmap netr_ProductType */
#define NETR_VER_NT_DOMAIN_CONTROLLER ( 0x02 )
#define NETR_VER_NT_SERVER ( 0x03 )
#define NETR_VER_NT_WORKSTATION ( 0x01 )

struct netr_LsaPolicyInformation {
	uint32_t policy_size;
	uint8_t *policy;/* [size_is(policy_size),unique] */
};

struct netr_OsVersionInfoEx {
	uint32_t OSVersionInfoSize;/* [value(284)] */
	uint32_t MajorVersion;
	uint32_t MinorVersion;
	uint32_t BuildNumber;
	uint32_t PlatformId;
	const char * CSDVersion;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2),subcontext(0),subcontext_size(256)] */
	uint16_t ServicePackMajor;
	uint16_t ServicePackMinor;
	uint16_t SuiteMask;
	uint8_t ProductType;
	uint8_t Reserved;
};

struct netr_OsVersion {
	uint32_t length;/* [value(142)] */
	uint32_t dummy;/* [value(0)] */
	uint32_t size;/* [value(142)] */
	struct netr_OsVersionInfoEx os;/* [subcontext(0),subcontext_size(size*2)] */
};

struct netr_OsVersionContainer {
	uint16_t length;/* [value(os==NULL?0:284)] */
	uint16_t size;/* [value(os==NULL?0:284)] */
	struct netr_OsVersion *os;/* [unique] */
};

struct netr_WorkstationInformation {
	struct netr_LsaPolicyInformation lsa_policy;
	const char *dns_hostname;/* [charset(UTF16),unique] */
	const char *sitename;/* [charset(UTF16),unique] */
	const char *dummy1;/* [charset(UTF16),unique] */
	const char *dummy2;/* [charset(UTF16),unique] */
	const char *dummy3;/* [charset(UTF16),unique] */
	const char *dummy4;/* [charset(UTF16),unique] */
	struct netr_OsVersionContainer os_version;
	struct lsa_String os_name;
	struct lsa_String dummy_string3;
	struct lsa_String dummy_string4;
	uint32_t workstation_flags;
	uint32_t supported_enc_types;
	uint32_t dummy_long3;
	uint32_t dummy_long4;
};

union netr_WorkstationInfo {
	struct netr_WorkstationInformation *workstation_info;/* [case,unique] */
	struct netr_WorkstationInformation *lsa_policy_info;/* [case(2),unique] */
};

struct netr_trust_extension_info {
	uint32_t flags;
	uint32_t parent_index;
	enum lsa_TrustType trust_type;
	uint32_t trust_attributes;
};

struct netr_trust_extension {
	uint32_t length;/* [value(8)] */
	uint32_t dummy;/* [value(0)] */
	uint32_t size;/* [value(8)] */
	struct netr_trust_extension_info info;/* [subcontext(0),subcontext_size(size*2)] */
};

struct netr_trust_extension_container {
	uint16_t length;/* [value(info==NULL?0:16)] */
	uint16_t size;/* [value(info==NULL?0:16)] */
	struct netr_trust_extension *info;/* [unique] */
};

struct netr_OneDomainInfo {
	struct lsa_StringLarge domainname;
	struct lsa_StringLarge dns_domainname;
	struct lsa_StringLarge dns_forestname;
	struct GUID domain_guid;
	struct dom_sid2 *domain_sid;/* [unique] */
	struct netr_trust_extension_container trust_extension;
	struct lsa_StringLarge dummy_string2;
	struct lsa_StringLarge dummy_string3;
	struct lsa_StringLarge dummy_string4;
	uint32_t dummy_long1;
	uint32_t dummy_long2;
	uint32_t dummy_long3;
	uint32_t dummy_long4;
};

struct netr_DomainInformation {
	struct netr_OneDomainInfo primary_domain;
	uint32_t trusted_domain_count;
	struct netr_OneDomainInfo *trusted_domains;/* [size_is(trusted_domain_count),unique] */
	struct netr_LsaPolicyInformation lsa_policy;
	struct lsa_StringLarge dns_hostname;
	struct lsa_StringLarge dummy_string2;
	struct lsa_StringLarge dummy_string3;
	struct lsa_StringLarge dummy_string4;
	uint32_t workstation_flags;
	uint32_t supported_enc_types;
	uint32_t dummy_long3;
	uint32_t dummy_long4;
};

union netr_DomainInfo {
	struct netr_DomainInformation *domain_info;/* [case,unique] */
	struct netr_LsaPolicyInformation *lsa_policy_info;/* [case(2),unique] */
};

struct NL_PASSWORD_VERSION {
	uint32_t ReservedField;
	uint32_t PasswordVersionNumber;
	uint32_t PasswordVersionPresent;
};

struct netr_CryptPassword {
	uint8_t data[512];
	uint32_t length;
}/* [flag(LIBNDR_PRINT_ARRAY_HEX)] */;

enum netr_SendToSamType
#ifndef USE_UINT_ENUMS
 {
	SendToSamUpdatePassword=(int)(0),
	SendToSamResetBadPasswordCount=(int)(1),
	SendToSamUpdatePasswordForward=(int)(2),
	SendToSamUpdateLastLogonTimestamp=(int)(3),
	SendToSamResetSmartCardPassword=(int)(4)
}
#else
 { __do_not_use_enum_netr_SendToSamType=INT_MAX}
#define SendToSamUpdatePassword ( 0 )
#define SendToSamResetBadPasswordCount ( 1 )
#define SendToSamUpdatePasswordForward ( 2 )
#define SendToSamUpdateLastLogonTimestamp ( 3 )
#define SendToSamResetSmartCardPassword ( 4 )
#endif
;

struct netr_SendToSamResetBadPasswordCount {
	struct GUID guid;
};

union netr_SendToSamMessage {
	struct netr_SendToSamResetBadPasswordCount reset_bad_password;/* [case(SendToSamResetBadPasswordCount)] */
}/* [nodiscriminant,public,switch_type(netr_SendToSamType)] */;

struct netr_SendToSamBase {
	enum netr_SendToSamType message_type;
	uint32_t message_size;
	union netr_SendToSamMessage message;/* [subcontext(0),subcontext_size(message_size),switch_is(message_type)] */
}/* [public] */;

struct netr_DsRAddressToSitenamesWCtr {
	uint32_t count;
	struct lsa_String *sitename;/* [size_is(count),unique] */
};

struct netr_DsRAddress {
	uint8_t *buffer;/* [size_is(size),unique] */
	uint32_t size;
};

struct netr_DomainTrust {
	const char *netbios_name;/* [charset(UTF16),unique] */
	const char *dns_name;/* [charset(UTF16),unique] */
	uint32_t trust_flags;
	uint32_t parent_index;
	enum lsa_TrustType trust_type;
	uint32_t trust_attributes;
	struct dom_sid2 *sid;/* [unique] */
	struct GUID guid;
}/* [public] */;

struct netr_DomainTrustList {
	uint32_t count;
	struct netr_DomainTrust *array;/* [size_is(count),unique] */
}/* [public] */;

struct netr_DsRAddressToSitenamesExWCtr {
	uint32_t count;
	struct lsa_String *sitename;/* [size_is(count),unique] */
	struct lsa_String *subnetname;/* [size_is(count),unique] */
};

struct DcSitesCtr {
	uint32_t num_sites;
	struct lsa_String *sites;/* [size_is(num_sites),unique] */
};

/* bitmap netr_LogonSamLogon_flags */
#define NETLOGON_SAMLOGON_FLAG_PASS_TO_FOREST_ROOT ( 0x00000001 )
#define NETLOGON_SAMLOGON_FLAG_PASS_CROSS_FOREST_HOP ( 0x00000002 )
#define NETLOGON_SAMLOGON_FLAG_RODC_TO_OTHER_DOMAIN ( 0x00000004 )
#define NETLOGON_SAMLOGON_FLAG_RODC_NTLM_REQUEST ( 0x00000008 )

struct netr_TrustInfo {
	uint32_t count;
	uint32_t *data;/* [size_is(count),unique] */
	uint32_t entry_count;
	struct lsa_String *entries;/* [size_is(count),unique] */
};

enum netr_DnsType
#ifndef USE_UINT_ENUMS
 {
	NlDnsLdapAtSite=(int)(22),
	NlDnsGcAtSite=(int)(25),
	NlDnsDsaCname=(int)(28),
	NlDnsKdcAtSite=(int)(30),
	NlDnsDcAtSite=(int)(32),
	NlDnsRfc1510KdcAtSite=(int)(34),
	NlDnsGenericGcAtSite=(int)(36)
}
#else
 { __do_not_use_enum_netr_DnsType=INT_MAX}
#define NlDnsLdapAtSite ( 22 )
#define NlDnsGcAtSite ( 25 )
#define NlDnsDsaCname ( 28 )
#define NlDnsKdcAtSite ( 30 )
#define NlDnsDcAtSite ( 32 )
#define NlDnsRfc1510KdcAtSite ( 34 )
#define NlDnsGenericGcAtSite ( 36 )
#endif
;

enum netr_DnsDomainInfoType
#ifndef USE_UINT_ENUMS
 {
	NlDnsInfoTypeNone=(int)(0),
	NlDnsDomainName=(int)(1),
	NlDnsDomainNameAlias=(int)(2),
	NlDnsForestName=(int)(3),
	NlDnsForestNameAlias=(int)(4),
	NlDnsNdncDomainName=(int)(5),
	NlDnsRecordName=(int)(6)
}
#else
 { __do_not_use_enum_netr_DnsDomainInfoType=INT_MAX}
#define NlDnsInfoTypeNone ( 0 )
#define NlDnsDomainName ( 1 )
#define NlDnsDomainNameAlias ( 2 )
#define NlDnsForestName ( 3 )
#define NlDnsForestNameAlias ( 4 )
#define NlDnsNdncDomainName ( 5 )
#define NlDnsRecordName ( 6 )
#endif
;

struct NL_DNS_NAME_INFO {
	enum netr_DnsType type;
	const char *dns_domain_info;/* [charset(UTF16),unique] */
	enum netr_DnsDomainInfoType dns_domain_info_type;
	uint32_t priority;
	uint32_t weight;
	uint32_t port;
	uint32_t dns_register;
	uint32_t status;
};

struct NL_DNS_NAME_INFO_ARRAY {
	uint32_t count;
	struct NL_DNS_NAME_INFO *names;/* [size_is(count),unique] */
}/* [public] */;


struct netr_LogonUasLogon {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		const char *workstation;/* [charset(UTF16),ref] */
	} in;

	struct {
		struct netr_UasInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonUasLogoff {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		const char *workstation;/* [charset(UTF16),ref] */
	} in;

	struct {
		struct netr_UasLogoffInfo *info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonSamLogon {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),unique] */
		struct netr_Authenticator *credential;/* [unique] */
		enum netr_LogonInfoClass logon_level;
		union netr_LogonLevel *logon;/* [ref,switch_is(logon_level)] */
		uint16_t validation_level;
		struct netr_Authenticator *return_authenticator;/* [unique] */
	} in;

	struct {
		union netr_Validation *validation;/* [ref,switch_is(validation_level)] */
		uint8_t *authoritative;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [unique] */
		NTSTATUS result;
	} out;

};


struct netr_LogonSamLogoff {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),unique] */
		struct netr_Authenticator *credential;/* [unique] */
		enum netr_LogonInfoClass logon_level;
		union netr_LogonLevel logon;/* [switch_is(logon_level)] */
		struct netr_Authenticator *return_authenticator;/* [unique] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [unique] */
		NTSTATUS result;
	} out;

};


struct netr_ServerReqChallenge {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Credential *credentials;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerAuthenticate {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Credential *credentials;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerPasswordSet {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		struct samr_Password *new_password;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseDeltas {
	struct {
		const char *logon_server;/* [charset(UTF16),ref] */
		const char *computername;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		enum netr_SamDatabaseID database_id;
		uint32_t preferredmaximumlength;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint64_t *sequence_num;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY **delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint64_t *sequence_num;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseSync {
	struct {
		const char *logon_server;/* [charset(UTF16),ref] */
		const char *computername;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		enum netr_SamDatabaseID database_id;
		uint32_t preferredmaximumlength;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY **delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_AccountDeltas {
	struct {
		const char *logon_server;/* [charset(UTF16),unique] */
		const char *computername;/* [charset(UTF16),ref] */
		struct netr_Authenticator credential;
		struct netr_UAS_INFO_0 uas;
		uint32_t count;
		uint32_t level;
		uint32_t buffersize;
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		struct netr_AccountBuffer *buffer;/* [ref,subcontext(4)] */
		uint32_t *count_returned;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		struct netr_UAS_INFO_0 *recordid;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_AccountSync {
	struct {
		const char *logon_server;/* [charset(UTF16),unique] */
		const char *computername;/* [charset(UTF16),ref] */
		struct netr_Authenticator credential;
		uint32_t reference;
		uint32_t level;
		uint32_t buffersize;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct netr_UAS_INFO_0 *recordid;/* [ref] */
	} in;

	struct {
		struct netr_AccountBuffer *buffer;/* [ref,subcontext(4)] */
		uint32_t *count_returned;/* [ref] */
		uint32_t *total_entries;/* [ref] */
		uint32_t *next_reference;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct netr_UAS_INFO_0 *recordid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_GetDcName {
	struct {
		const char *logon_server;/* [charset(UTF16),ref] */
		const char *domainname;/* [charset(UTF16),unique] */
	} in;

	struct {
		const char **dcname;/* [charset(UTF16),ref] */
		WERROR result;
	} out;

};


struct netr_LogonControl {
	struct {
		const char *logon_server;/* [charset(UTF16),unique] */
		enum netr_LogonControlCode function_code;
		uint32_t level;
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *query;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct netr_GetAnyDCName {
	struct {
		const char *logon_server;/* [charset(UTF16),unique] */
		const char *domainname;/* [charset(UTF16),unique] */
	} in;

	struct {
		const char **dcname;/* [charset(UTF16),ref] */
		WERROR result;
	} out;

};


struct netr_LogonControl2 {
	struct {
		const char *logon_server;/* [charset(UTF16),unique] */
		enum netr_LogonControlCode function_code;
		uint32_t level;
		union netr_CONTROL_DATA_INFORMATION *data;/* [ref,switch_is(function_code)] */
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *query;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct netr_ServerAuthenticate2 {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Credential *credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseSync2 {
	struct {
		const char *logon_server;/* [charset(UTF16),ref] */
		const char *computername;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		enum netr_SamDatabaseID database_id;
		enum SyncStateEnum restart_state;
		uint32_t preferredmaximumlength;
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY **delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		uint32_t *sync_context;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DatabaseRedo {
	struct {
		const char *logon_server;/* [charset(UTF16),ref] */
		const char *computername;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		struct netr_ChangeLogEntry change_log_entry;/* [subcontext(4)] */
		uint32_t change_log_entry_size;/* [value(ndr_size_netr_ChangeLogEntry(&change_log_entry,ndr->flags))] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		struct netr_DELTA_ENUM_ARRAY **delta_enum_array;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_LogonControl2Ex {
	struct {
		const char *logon_server;/* [charset(UTF16),unique] */
		enum netr_LogonControlCode function_code;
		uint32_t level;
		union netr_CONTROL_DATA_INFORMATION *data;/* [ref,switch_is(function_code)] */
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *query;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct netr_NetrEnumerateTrustedDomains {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
	} in;

	struct {
		struct netr_Blob *trusted_domains_blob;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsRGetDCName {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *domain_name;/* [charset(UTF16),unique] */
		struct GUID *domain_guid;/* [unique] */
		struct GUID *site_guid;/* [unique] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonGetCapabilities {
	struct {
		const char *server_name;/* [charset(UTF16),ref] */
		const char *computer_name;/* [charset(UTF16),unique] */
		struct netr_Authenticator *credential;/* [ref] */
		uint32_t query_level;
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		union netr_Capabilities *capabilities;/* [ref,switch_is(query_level)] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_NETRLOGONSETSERVICEBITS {
	struct {
		WERROR result;
	} out;

};


struct netr_LogonGetTrustRid {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *domain_name;/* [charset(UTF16),unique] */
	} in;

	struct {
		uint32_t *rid;/* [ref] */
		WERROR result;
	} out;

};


struct netr_NETRLOGONCOMPUTESERVERDIGEST {
	struct {
		WERROR result;
	} out;

};


struct netr_NETRLOGONCOMPUTECLIENTDIGEST {
	struct {
		WERROR result;
	} out;

};


struct netr_ServerAuthenticate3 {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Credential *credentials;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
	} in;

	struct {
		struct netr_Credential *return_credentials;/* [ref] */
		uint32_t *rid;/* [ref] */
		uint32_t *negotiate_flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsRGetDCNameEx {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *domain_name;/* [charset(UTF16),unique] */
		struct GUID *domain_guid;/* [unique] */
		const char *site_name;/* [charset(UTF16),unique] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRGetSiteName {
	struct {
		const char *computer_name;/* [charset(UTF16),unique] */
	} in;

	struct {
		const char **site;/* [charset(UTF16),ref] */
		WERROR result;
	} out;

};


struct netr_LogonGetDomainInfo {
	struct {
		const char *server_name;/* [charset(UTF16),ref] */
		const char *computer_name;/* [charset(UTF16),unique] */
		struct netr_Authenticator *credential;/* [ref] */
		uint32_t level;
		union netr_WorkstationInfo *query;/* [ref,switch_is(level)] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
	} in;

	struct {
		union netr_DomainInfo *info;/* [ref,switch_is(level)] */
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerPasswordSet2 {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		struct netr_CryptPassword *new_password;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerPasswordGet {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct samr_Password *password;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_NetrLogonSendToSam {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		uint8_t *opaque_buffer;/* [ref,size_is(buffer_len)] */
		uint32_t buffer_len;
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsRAddressToSitenamesW {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		uint32_t count;/* [range(0,32000)] */
		struct netr_DsRAddress *addresses;/* [ref,size_is(count)] */
	} in;

	struct {
		struct netr_DsRAddressToSitenamesWCtr **ctr;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRGetDCNameEx2 {
	struct {
		const char *server_unc;/* [charset(UTF16),unique] */
		const char *client_account;/* [charset(UTF16),unique] */
		uint32_t mask;
		const char *domain_name;/* [charset(UTF16),unique] */
		struct GUID *domain_guid;/* [unique] */
		const char *site_name;/* [charset(UTF16),unique] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN {
	struct {
		WERROR result;
	} out;

};


struct netr_NetrEnumerateTrustedDomainsEx {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
	} in;

	struct {
		struct netr_DomainTrustList *dom_trust_list;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsRAddressToSitenamesExW {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		uint32_t count;/* [range(0,32000)] */
		struct netr_DsRAddress *addresses;/* [ref,size_is(count)] */
	} in;

	struct {
		struct netr_DsRAddressToSitenamesExWCtr **ctr;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsrGetDcSiteCoverageW {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
	} in;

	struct {
		struct DcSitesCtr **ctr;/* [ref] */
		WERROR result;
	} out;

};


struct netr_LogonSamLogonEx {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),unique] */
		enum netr_LogonInfoClass logon_level;
		union netr_LogonLevel *logon;/* [ref,switch_is(logon_level)] */
		uint16_t validation_level;
		uint32_t *flags;/* [ref] */
	} in;

	struct {
		union netr_Validation *validation;/* [ref,switch_is(validation_level)] */
		uint8_t *authoritative;/* [ref] */
		uint32_t *flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsrEnumerateDomainTrusts {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		uint32_t trust_flags;
	} in;

	struct {
		struct netr_DomainTrustList *trusts;/* [ref] */
		WERROR result;
	} out;

};


struct netr_DsrDeregisterDNSHostRecords {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *domain;/* [charset(UTF16),unique] */
		struct GUID *domain_guid;/* [unique] */
		struct GUID *dsa_guid;/* [unique] */
		const char *dns_host;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct netr_ServerTrustPasswordsGet {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct samr_Password *new_owf_password;/* [ref] */
		struct samr_Password *old_owf_password;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_DsRGetForestTrustInformation {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *trusted_domain_name;/* [charset(UTF16),unique] */
		uint32_t flags;
	} in;

	struct {
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		WERROR result;
	} out;

};


struct netr_GetForestTrustInformation {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		uint32_t flags;
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_LogonSamLogonWithFlags {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),unique] */
		struct netr_Authenticator *credential;/* [unique] */
		enum netr_LogonInfoClass logon_level;
		union netr_LogonLevel *logon;/* [ref,switch_is(logon_level)] */
		uint16_t validation_level;
		struct netr_Authenticator *return_authenticator;/* [unique] */
		uint32_t *flags;/* [ref] */
	} in;

	struct {
		union netr_Validation *validation;/* [ref,switch_is(validation_level)] */
		uint8_t *authoritative;/* [ref] */
		struct netr_Authenticator *return_authenticator;/* [unique] */
		uint32_t *flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_ServerGetTrustInfo {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *account_name;/* [charset(UTF16),ref] */
		enum netr_SchannelType secure_channel_type;
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct samr_Password *new_owf_password;/* [ref] */
		struct samr_Password *old_owf_password;/* [ref] */
		struct netr_TrustInfo **trust_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct netr_Unused47 {
	struct {
		NTSTATUS result;
	} out;

};


struct netr_DsrUpdateReadOnlyServerDnsRecords {
	struct {
		const char *server_name;/* [charset(UTF16),unique] */
		const char *computer_name;/* [charset(UTF16),ref] */
		struct netr_Authenticator *credential;/* [ref] */
		const char *site_name;/* [charset(UTF16),unique] */
		uint32_t dns_ttl;
		struct NL_DNS_NAME_INFO_ARRAY *dns_names;/* [ref] */
	} in;

	struct {
		struct netr_Authenticator *return_authenticator;/* [ref] */
		struct NL_DNS_NAME_INFO_ARRAY *dns_names;/* [ref] */
		NTSTATUS result;
	} out;

};

#endif /* _HEADER_netlogon */
#endif /* _PIDL_HEADER_netlogon */
