/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_winspool.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_winreg.h"
#include "librpc/gen_ndr/ndr_spoolss.h"
static enum ndr_err_code ndr_push_winspool_NOTIFY_REPLY_CONTAINER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winspool_NOTIFY_REPLY_CONTAINER *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pInfo));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pInfo) {
			NDR_CHECK(ndr_push_spoolss_NotifyInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->pInfo));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_NOTIFY_REPLY_CONTAINER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winspool_NOTIFY_REPLY_CONTAINER *r)
{
	uint32_t _ptr_pInfo;
	TALLOC_CTX *_mem_save_pInfo_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pInfo));
		if (_ptr_pInfo) {
			NDR_PULL_ALLOC(ndr, r->pInfo);
		} else {
			r->pInfo = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pInfo) {
			_mem_save_pInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pInfo, 0);
			NDR_CHECK(ndr_pull_spoolss_NotifyInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->pInfo));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInfo_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_NOTIFY_REPLY_CONTAINER(struct ndr_print *ndr, const char *name, const struct winspool_NOTIFY_REPLY_CONTAINER *r)
{
	ndr_print_struct(ndr, name, "winspool_NOTIFY_REPLY_CONTAINER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pInfo", r->pInfo);
	ndr->depth++;
	if (r->pInfo) {
		ndr_print_spoolss_NotifyInfo(ndr, "pInfo", r->pInfo);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_NOTIFY_OPTIONS_CONTAINER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winspool_NOTIFY_OPTIONS_CONTAINER *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pOptions));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pOptions) {
			NDR_CHECK(ndr_push_spoolss_NotifyOption(ndr, NDR_SCALARS|NDR_BUFFERS, r->pOptions));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_NOTIFY_OPTIONS_CONTAINER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winspool_NOTIFY_OPTIONS_CONTAINER *r)
{
	uint32_t _ptr_pOptions;
	TALLOC_CTX *_mem_save_pOptions_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pOptions));
		if (_ptr_pOptions) {
			NDR_PULL_ALLOC(ndr, r->pOptions);
		} else {
			r->pOptions = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pOptions) {
			_mem_save_pOptions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pOptions, 0);
			NDR_CHECK(ndr_pull_spoolss_NotifyOption(ndr, NDR_SCALARS|NDR_BUFFERS, r->pOptions));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pOptions_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_NOTIFY_OPTIONS_CONTAINER(struct ndr_print *ndr, const char *name, const struct winspool_NOTIFY_OPTIONS_CONTAINER *r)
{
	ndr_print_struct(ndr, name, "winspool_NOTIFY_OPTIONS_CONTAINER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pOptions", r->pOptions);
	ndr->depth++;
	if (r->pOptions) {
		ndr_print_spoolss_NotifyOption(ndr, "pOptions", r->pOptions);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_PrintPropertyType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winspool_PrintPropertyType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_PrintPropertyType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winspool_PrintPropertyType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_PrintPropertyType(struct ndr_print *ndr, const char *name, enum winspool_PrintPropertyType r)
{
	const char *val = NULL;

	switch (r) {
		case winspool_PropertyTypeString: val = "winspool_PropertyTypeString"; break;
		case winspool_PropertyTypeInt32: val = "winspool_PropertyTypeInt32"; break;
		case winspool_PropertyTypeInt64: val = "winspool_PropertyTypeInt64"; break;
		case winspool_PropertyTypeByte: val = "winspool_PropertyTypeByte"; break;
		case winspool_PropertyTypeTime: val = "winspool_PropertyTypeTime"; break;
		case winspool_PropertyTypeDevMode: val = "winspool_PropertyTypeDevMode"; break;
		case winspool_PropertyTypeSD: val = "winspool_PropertyTypeSD"; break;
		case winspool_PropertyTypeNotificationReply: val = "winspool_PropertyTypeNotificationReply"; break;
		case winspool_PropertyTypeNotificationOptions: val = "winspool_PropertyTypeNotificationOptions"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_winspool_PrintPropertyValueUnion(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union winspool_PrintPropertyValueUnion *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_winspool_PrintPropertyType(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 8));
		switch (level) {
			case winspool_PropertyTypeString: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->propertyString));
			break; }

			case winspool_PropertyTypeInt32: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->propertyInt32));
			break; }

			case winspool_PropertyTypeInt64: {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->propertyInt64));
			break; }

			case winspool_PropertyTypeByte: {
				NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->propertyByte));
			break; }

			case winspool_PropertyTypeTime: {
				NDR_CHECK(ndr_push_spoolss_TimeCtr(ndr, NDR_SCALARS, &r->propertyTimeContainer));
			break; }

			case winspool_PropertyTypeDevMode: {
				NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS, &r->propertyDevModeContainer));
			break; }

			case winspool_PropertyTypeSD: {
				NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS, &r->propertySDContainer));
			break; }

			case winspool_PropertyTypeNotificationReply: {
				NDR_CHECK(ndr_push_winspool_NOTIFY_REPLY_CONTAINER(ndr, NDR_SCALARS, &r->propertyReplyContainer));
			break; }

			case winspool_PropertyTypeNotificationOptions: {
				NDR_CHECK(ndr_push_winspool_NOTIFY_OPTIONS_CONTAINER(ndr, NDR_SCALARS, &r->propertyOptionsContainer));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case winspool_PropertyTypeString:
				if (r->propertyString) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->propertyString, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->propertyString, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->propertyString, ndr_charset_length(r->propertyString, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case winspool_PropertyTypeInt32:
			break;

			case winspool_PropertyTypeInt64:
			break;

			case winspool_PropertyTypeByte:
			break;

			case winspool_PropertyTypeTime:
				NDR_CHECK(ndr_push_spoolss_TimeCtr(ndr, NDR_BUFFERS, &r->propertyTimeContainer));
			break;

			case winspool_PropertyTypeDevMode:
				NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_BUFFERS, &r->propertyDevModeContainer));
			break;

			case winspool_PropertyTypeSD:
				NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_BUFFERS, &r->propertySDContainer));
			break;

			case winspool_PropertyTypeNotificationReply:
				NDR_CHECK(ndr_push_winspool_NOTIFY_REPLY_CONTAINER(ndr, NDR_BUFFERS, &r->propertyReplyContainer));
			break;

			case winspool_PropertyTypeNotificationOptions:
				NDR_CHECK(ndr_push_winspool_NOTIFY_OPTIONS_CONTAINER(ndr, NDR_BUFFERS, &r->propertyOptionsContainer));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_PrintPropertyValueUnion(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union winspool_PrintPropertyValueUnion *r)
{
	uint32_t level;
	uint16_t _level;
	TALLOC_CTX *_mem_save_propertyString_0 = NULL;
	uint32_t _ptr_propertyString;
	uint32_t size_propertyString_1 = 0;
	uint32_t length_propertyString_1 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 8));
		switch (level) {
			case winspool_PropertyTypeString: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_propertyString));
				if (_ptr_propertyString) {
					NDR_PULL_ALLOC(ndr, r->propertyString);
				} else {
					r->propertyString = NULL;
				}
			break; }

			case winspool_PropertyTypeInt32: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->propertyInt32));
			break; }

			case winspool_PropertyTypeInt64: {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->propertyInt64));
			break; }

			case winspool_PropertyTypeByte: {
				NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->propertyByte));
			break; }

			case winspool_PropertyTypeTime: {
				NDR_CHECK(ndr_pull_spoolss_TimeCtr(ndr, NDR_SCALARS, &r->propertyTimeContainer));
			break; }

			case winspool_PropertyTypeDevMode: {
				NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS, &r->propertyDevModeContainer));
			break; }

			case winspool_PropertyTypeSD: {
				NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS, &r->propertySDContainer));
			break; }

			case winspool_PropertyTypeNotificationReply: {
				NDR_CHECK(ndr_pull_winspool_NOTIFY_REPLY_CONTAINER(ndr, NDR_SCALARS, &r->propertyReplyContainer));
			break; }

			case winspool_PropertyTypeNotificationOptions: {
				NDR_CHECK(ndr_pull_winspool_NOTIFY_OPTIONS_CONTAINER(ndr, NDR_SCALARS, &r->propertyOptionsContainer));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case winspool_PropertyTypeString:
				if (r->propertyString) {
					_mem_save_propertyString_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->propertyString, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->propertyString));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->propertyString));
					NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->propertyString, &size_propertyString_1));
					NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->propertyString, &length_propertyString_1));
					if (length_propertyString_1 > size_propertyString_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_propertyString_1, length_propertyString_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_propertyString_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->propertyString, length_propertyString_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_propertyString_0, 0);
				}
			break;

			case winspool_PropertyTypeInt32:
			break;

			case winspool_PropertyTypeInt64:
			break;

			case winspool_PropertyTypeByte:
			break;

			case winspool_PropertyTypeTime:
				NDR_CHECK(ndr_pull_spoolss_TimeCtr(ndr, NDR_BUFFERS, &r->propertyTimeContainer));
			break;

			case winspool_PropertyTypeDevMode:
				NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_BUFFERS, &r->propertyDevModeContainer));
			break;

			case winspool_PropertyTypeSD:
				NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_BUFFERS, &r->propertySDContainer));
			break;

			case winspool_PropertyTypeNotificationReply:
				NDR_CHECK(ndr_pull_winspool_NOTIFY_REPLY_CONTAINER(ndr, NDR_BUFFERS, &r->propertyReplyContainer));
			break;

			case winspool_PropertyTypeNotificationOptions:
				NDR_CHECK(ndr_pull_winspool_NOTIFY_OPTIONS_CONTAINER(ndr, NDR_BUFFERS, &r->propertyOptionsContainer));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_PrintPropertyValueUnion(struct ndr_print *ndr, const char *name, const union winspool_PrintPropertyValueUnion *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "winspool_PrintPropertyValueUnion");
	switch (level) {
		case winspool_PropertyTypeString:
			ndr_print_ptr(ndr, "propertyString", r->propertyString);
			ndr->depth++;
			if (r->propertyString) {
				ndr_print_string(ndr, "propertyString", r->propertyString);
			}
			ndr->depth--;
		break;

		case winspool_PropertyTypeInt32:
			ndr_print_uint32(ndr, "propertyInt32", r->propertyInt32);
		break;

		case winspool_PropertyTypeInt64:
			ndr_print_hyper(ndr, "propertyInt64", r->propertyInt64);
		break;

		case winspool_PropertyTypeByte:
			ndr_print_uint8(ndr, "propertyByte", r->propertyByte);
		break;

		case winspool_PropertyTypeTime:
			ndr_print_spoolss_TimeCtr(ndr, "propertyTimeContainer", &r->propertyTimeContainer);
		break;

		case winspool_PropertyTypeDevMode:
			ndr_print_spoolss_DevmodeContainer(ndr, "propertyDevModeContainer", &r->propertyDevModeContainer);
		break;

		case winspool_PropertyTypeSD:
			ndr_print_sec_desc_buf(ndr, "propertySDContainer", &r->propertySDContainer);
		break;

		case winspool_PropertyTypeNotificationReply:
			ndr_print_winspool_NOTIFY_REPLY_CONTAINER(ndr, "propertyReplyContainer", &r->propertyReplyContainer);
		break;

		case winspool_PropertyTypeNotificationOptions:
			ndr_print_winspool_NOTIFY_OPTIONS_CONTAINER(ndr, "propertyOptionsContainer", &r->propertyOptionsContainer);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_winspool_PrintPropertyValue(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winspool_PrintPropertyValue *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_winspool_PrintPropertyType(ndr, NDR_SCALARS, r->PropertyType));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->value, r->PropertyType));
		NDR_CHECK(ndr_push_winspool_PrintPropertyValueUnion(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->value, r->PropertyType));
		NDR_CHECK(ndr_push_winspool_PrintPropertyValueUnion(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_PrintPropertyValue(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winspool_PrintPropertyValue *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_winspool_PrintPropertyType(ndr, NDR_SCALARS, &r->PropertyType));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->value, r->PropertyType));
		NDR_CHECK(ndr_pull_winspool_PrintPropertyValueUnion(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->value, r->PropertyType));
		NDR_CHECK(ndr_pull_winspool_PrintPropertyValueUnion(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_PrintPropertyValue(struct ndr_print *ndr, const char *name, const struct winspool_PrintPropertyValue *r)
{
	ndr_print_struct(ndr, name, "winspool_PrintPropertyValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_winspool_PrintPropertyType(ndr, "PropertyType", r->PropertyType);
	ndr_print_set_switch_value(ndr, &r->value, r->PropertyType);
	ndr_print_winspool_PrintPropertyValueUnion(ndr, "value", &r->value);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_PrintNamedProperty(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winspool_PrintNamedProperty *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->propertyName));
		NDR_CHECK(ndr_push_winspool_PrintPropertyValue(ndr, NDR_SCALARS, &r->propertyValue));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->propertyName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->propertyName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->propertyName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->propertyName, ndr_charset_length(r->propertyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_winspool_PrintPropertyValue(ndr, NDR_BUFFERS, &r->propertyValue));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_PrintNamedProperty(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winspool_PrintNamedProperty *r)
{
	uint32_t _ptr_propertyName;
	uint32_t size_propertyName_1 = 0;
	uint32_t length_propertyName_1 = 0;
	TALLOC_CTX *_mem_save_propertyName_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_propertyName));
		if (_ptr_propertyName) {
			NDR_PULL_ALLOC(ndr, r->propertyName);
		} else {
			r->propertyName = NULL;
		}
		NDR_CHECK(ndr_pull_winspool_PrintPropertyValue(ndr, NDR_SCALARS, &r->propertyValue));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->propertyName) {
			_mem_save_propertyName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->propertyName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->propertyName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->propertyName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->propertyName, &size_propertyName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->propertyName, &length_propertyName_1));
			if (length_propertyName_1 > size_propertyName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_propertyName_1, length_propertyName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_propertyName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->propertyName, length_propertyName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_propertyName_0, 0);
		}
		NDR_CHECK(ndr_pull_winspool_PrintPropertyValue(ndr, NDR_BUFFERS, &r->propertyValue));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_PrintNamedProperty(struct ndr_print *ndr, const char *name, const struct winspool_PrintNamedProperty *r)
{
	ndr_print_struct(ndr, name, "winspool_PrintNamedProperty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "propertyName", r->propertyName);
	ndr->depth++;
	if (r->propertyName) {
		ndr_print_string(ndr, "propertyName", r->propertyName);
	}
	ndr->depth--;
	ndr_print_winspool_PrintPropertyValue(ndr, "propertyValue", &r->propertyValue);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_PrintPropertiesCollection(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct winspool_PrintPropertiesCollection *r)
{
	uint32_t cntr_propertiesCollection_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->numberOfProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->propertiesCollection));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->propertiesCollection) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->numberOfProperties));
			for (cntr_propertiesCollection_1 = 0; cntr_propertiesCollection_1 < (r->numberOfProperties); cntr_propertiesCollection_1++) {
				NDR_CHECK(ndr_push_winspool_PrintNamedProperty(ndr, NDR_SCALARS, &r->propertiesCollection[cntr_propertiesCollection_1]));
			}
			for (cntr_propertiesCollection_1 = 0; cntr_propertiesCollection_1 < (r->numberOfProperties); cntr_propertiesCollection_1++) {
				NDR_CHECK(ndr_push_winspool_PrintNamedProperty(ndr, NDR_BUFFERS, &r->propertiesCollection[cntr_propertiesCollection_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_PrintPropertiesCollection(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct winspool_PrintPropertiesCollection *r)
{
	uint32_t _ptr_propertiesCollection;
	uint32_t size_propertiesCollection_1 = 0;
	uint32_t cntr_propertiesCollection_1;
	TALLOC_CTX *_mem_save_propertiesCollection_0 = NULL;
	TALLOC_CTX *_mem_save_propertiesCollection_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->numberOfProperties));
		if (r->numberOfProperties > 50) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->numberOfProperties), (uint32_t)(0), (uint32_t)(50));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_propertiesCollection));
		if (_ptr_propertiesCollection) {
			NDR_PULL_ALLOC(ndr, r->propertiesCollection);
		} else {
			r->propertiesCollection = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->propertiesCollection) {
			_mem_save_propertiesCollection_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->propertiesCollection, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->propertiesCollection));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->propertiesCollection, &size_propertiesCollection_1));
			NDR_PULL_ALLOC_N(ndr, r->propertiesCollection, size_propertiesCollection_1);
			_mem_save_propertiesCollection_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->propertiesCollection, 0);
			for (cntr_propertiesCollection_1 = 0; cntr_propertiesCollection_1 < (size_propertiesCollection_1); cntr_propertiesCollection_1++) {
				NDR_CHECK(ndr_pull_winspool_PrintNamedProperty(ndr, NDR_SCALARS, &r->propertiesCollection[cntr_propertiesCollection_1]));
			}
			for (cntr_propertiesCollection_1 = 0; cntr_propertiesCollection_1 < (size_propertiesCollection_1); cntr_propertiesCollection_1++) {
				NDR_CHECK(ndr_pull_winspool_PrintNamedProperty(ndr, NDR_BUFFERS, &r->propertiesCollection[cntr_propertiesCollection_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_propertiesCollection_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_propertiesCollection_0, 0);
		}
		if (r->propertiesCollection) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->propertiesCollection, r->numberOfProperties));
		}
		for (cntr_propertiesCollection_1 = 0; cntr_propertiesCollection_1 < (size_propertiesCollection_1); cntr_propertiesCollection_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_PrintPropertiesCollection(struct ndr_print *ndr, const char *name, const struct winspool_PrintPropertiesCollection *r)
{
	uint32_t cntr_propertiesCollection_1;
	ndr_print_struct(ndr, name, "winspool_PrintPropertiesCollection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "numberOfProperties", r->numberOfProperties);
	ndr_print_ptr(ndr, "propertiesCollection", r->propertiesCollection);
	ndr->depth++;
	if (r->propertiesCollection) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "propertiesCollection", (uint32_t)(r->numberOfProperties));
		ndr->depth++;
		for (cntr_propertiesCollection_1 = 0; cntr_propertiesCollection_1 < (r->numberOfProperties); cntr_propertiesCollection_1++) {
			ndr_print_winspool_PrintNamedProperty(ndr, "propertiesCollection", &r->propertiesCollection[cntr_propertiesCollection_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_InstallPrinterDriverFromPackageFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_InstallPrinterDriverFromPackageFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_InstallPrinterDriverFromPackageFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "IPDFP_FLAG_NONE", IPDFP_FLAG_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "IPDFP_COPY_ALL_FILES", IPDFP_COPY_ALL_FILES, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_UploadPrinterDriverPackageFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_UploadPrinterDriverPackageFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_UploadPrinterDriverPackageFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "UPDP_FLAG_NONE", UPDP_FLAG_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "UPDP_UPLOAD_ALWAYS", UPDP_UPLOAD_ALWAYS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "UPDP_CHECK_DRIVERSTORE", UPDP_CHECK_DRIVERSTORE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncOpenPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncOpenPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pDevModeContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pClientInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrinterName));
		if (r->in.pPrinterName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrinterName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrinterName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrinterName, ndr_charset_length(r->in.pPrinterName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDatatype));
		if (r->in.pDatatype) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDatatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDatatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pDatatype, ndr_charset_length(r->in.pDatatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.AccessRequired));
		NDR_CHECK(ndr_push_spoolss_UserLevelCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pClientInfo));
	}
	if (flags & NDR_OUT) {
		if (r->out.pHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.pHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncOpenPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncOpenPrinter *r)
{
	uint32_t _ptr_pPrinterName;
	uint32_t size_pPrinterName_1 = 0;
	uint32_t length_pPrinterName_1 = 0;
	uint32_t _ptr_pDatatype;
	uint32_t size_pDatatype_1 = 0;
	uint32_t length_pDatatype_1 = 0;
	TALLOC_CTX *_mem_save_pPrinterName_0 = NULL;
	TALLOC_CTX *_mem_save_pHandle_0 = NULL;
	TALLOC_CTX *_mem_save_pDatatype_0 = NULL;
	TALLOC_CTX *_mem_save_pDevModeContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pClientInfo_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinterName));
		if (_ptr_pPrinterName) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterName);
		} else {
			r->in.pPrinterName = NULL;
		}
		if (r->in.pPrinterName) {
			_mem_save_pPrinterName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrinterName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrinterName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrinterName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrinterName, &size_pPrinterName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrinterName, &length_pPrinterName_1));
			if (length_pPrinterName_1 > size_pPrinterName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrinterName_1, length_pPrinterName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrinterName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrinterName, length_pPrinterName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDatatype));
		if (_ptr_pDatatype) {
			NDR_PULL_ALLOC(ndr, r->in.pDatatype);
		} else {
			r->in.pDatatype = NULL;
		}
		if (r->in.pDatatype) {
			_mem_save_pDatatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDatatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDatatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pDatatype));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pDatatype, &size_pDatatype_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pDatatype, &length_pDatatype_1));
			if (length_pDatatype_1 > size_pDatatype_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pDatatype_1, length_pDatatype_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pDatatype_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pDatatype, length_pDatatype_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDatatype_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
		}
		_mem_save_pDevModeContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDevModeContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDevModeContainer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.AccessRequired));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pClientInfo);
		}
		_mem_save_pClientInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pClientInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_UserLevelCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pClientInfo));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pClientInfo_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pHandle);
		NDR_ZERO_STRUCTP(r->out.pHandle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pDevModeContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
			NDR_ZERO_STRUCTP(r->in.pDevModeContainer);
		}
		if (r->in.pClientInfo == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pClientInfo);
			NDR_ZERO_STRUCTP(r->in.pClientInfo);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pHandle);
		}
		_mem_save_pHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.pHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncOpenPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncOpenPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncOpenPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncOpenPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPrinterName", r->in.pPrinterName);
		ndr->depth++;
		if (r->in.pPrinterName) {
			ndr_print_string(ndr, "pPrinterName", r->in.pPrinterName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pDatatype", r->in.pDatatype);
		ndr->depth++;
		if (r->in.pDatatype) {
			ndr_print_string(ndr, "pDatatype", r->in.pDatatype);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth--;
		ndr_print_uint32(ndr, "AccessRequired", r->in.AccessRequired);
		ndr_print_ptr(ndr, "pClientInfo", r->in.pClientInfo);
		ndr->depth++;
		ndr_print_spoolss_UserLevelCtr(ndr, "pClientInfo", r->in.pClientInfo);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncOpenPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pHandle", r->out.pHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pHandle", r->out.pHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPrinterContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pDevModeContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pSecurityContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pClientInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPrinterContainer));
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSecurityContainer));
		NDR_CHECK(ndr_push_spoolss_UserLevelCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pClientInfo));
	}
	if (flags & NDR_OUT) {
		if (r->out.pHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.pHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddPrinter *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pPrinterContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pDevModeContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pSecurityContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pClientInfo_0 = NULL;
	TALLOC_CTX *_mem_save_pHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterContainer);
		}
		_mem_save_pPrinterContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrinterContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPrinterContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterContainer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
		}
		_mem_save_pDevModeContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDevModeContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDevModeContainer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pSecurityContainer);
		}
		_mem_save_pSecurityContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pSecurityContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSecurityContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSecurityContainer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pClientInfo);
		}
		_mem_save_pClientInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pClientInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_UserLevelCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pClientInfo));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pClientInfo_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pHandle);
		NDR_ZERO_STRUCTP(r->out.pHandle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pPrinterContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterContainer);
			NDR_ZERO_STRUCTP(r->in.pPrinterContainer);
		}
		if (r->in.pDevModeContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
			NDR_ZERO_STRUCTP(r->in.pDevModeContainer);
		}
		if (r->in.pSecurityContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pSecurityContainer);
			NDR_ZERO_STRUCTP(r->in.pSecurityContainer);
		}
		if (r->in.pClientInfo == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pClientInfo);
			NDR_ZERO_STRUCTP(r->in.pClientInfo);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pHandle);
		}
		_mem_save_pHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.pHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrinterContainer", r->in.pPrinterContainer);
		ndr->depth++;
		ndr_print_spoolss_SetPrinterInfoCtr(ndr, "pPrinterContainer", r->in.pPrinterContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pSecurityContainer", r->in.pSecurityContainer);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "pSecurityContainer", r->in.pSecurityContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pClientInfo", r->in.pClientInfo);
		ndr->depth++;
		ndr_print_spoolss_UserLevelCtr(ndr, "pClientInfo", r->in.pClientInfo);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pHandle", r->out.pHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pHandle", r->out.pHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncSetJob(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetJob *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pJobContainer));
		if (r->in.pJobContainer) {
			NDR_CHECK(ndr_push_spoolss_JobInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pJobContainer));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Command));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncSetJob(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetJob *r)
{
	uint32_t _ptr_pJobContainer;
	TALLOC_CTX *_mem_save_pJobContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pJobContainer));
		if (_ptr_pJobContainer) {
			NDR_PULL_ALLOC(ndr, r->in.pJobContainer);
		} else {
			r->in.pJobContainer = NULL;
		}
		if (r->in.pJobContainer) {
			_mem_save_pJobContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pJobContainer, 0);
			NDR_CHECK(ndr_pull_spoolss_JobInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pJobContainer));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pJobContainer_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Command));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetJob(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetJob *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetJob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetJob");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr_print_ptr(ndr, "pJobContainer", r->in.pJobContainer);
		ndr->depth++;
		if (r->in.pJobContainer) {
			ndr_print_spoolss_JobInfoContainer(ndr, "pJobContainer", r->in.pJobContainer);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Command", r->in.Command);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetJob");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetJob(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetJob *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pJob));
		if (r->in.pJob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pJob, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pJob));
		if (r->out.pJob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pJob, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetJob(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetJob *r)
{
	uint32_t _ptr_pJob;
	uint32_t size_pJob_1 = 0;
	TALLOC_CTX *_mem_save_pJob_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pJob));
		if (_ptr_pJob) {
			NDR_PULL_ALLOC(ndr, r->in.pJob);
		} else {
			r->in.pJob = NULL;
		}
		if (r->in.pJob) {
			_mem_save_pJob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pJob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pJob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pJob, &size_pJob_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pJob, size_pJob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pJob, size_pJob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pJob_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		if (r->in.pJob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pJob, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pJob));
		if (_ptr_pJob) {
			NDR_PULL_ALLOC(ndr, r->out.pJob);
		} else {
			r->out.pJob = NULL;
		}
		if (r->out.pJob) {
			_mem_save_pJob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pJob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pJob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pJob, &size_pJob_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pJob, size_pJob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pJob, size_pJob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pJob_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pJob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pJob, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetJob(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetJob *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetJob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetJob");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pJob", r->in.pJob);
		ndr->depth++;
		if (r->in.pJob) {
			ndr_print_array_uint8(ndr, "pJob", r->in.pJob, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "pJob", r->out.pJob);
		ndr->depth++;
		if (r->out.pJob) {
			ndr_print_array_uint8(ndr, "pJob", r->out.pJob, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumJobs(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumJobs *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.FirstJob));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.NoJobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pJob));
		if (r->in.pJob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pJob, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pJob));
		if (r->out.pJob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pJob, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumJobs(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumJobs *r)
{
	uint32_t _ptr_pJob;
	uint32_t size_pJob_1 = 0;
	TALLOC_CTX *_mem_save_pJob_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.FirstJob));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.NoJobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pJob));
		if (_ptr_pJob) {
			NDR_PULL_ALLOC(ndr, r->in.pJob);
		} else {
			r->in.pJob = NULL;
		}
		if (r->in.pJob) {
			_mem_save_pJob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pJob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pJob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pJob, &size_pJob_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pJob, size_pJob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pJob, size_pJob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pJob_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pJob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pJob, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pJob));
		if (_ptr_pJob) {
			NDR_PULL_ALLOC(ndr, r->out.pJob);
		} else {
			r->out.pJob = NULL;
		}
		if (r->out.pJob) {
			_mem_save_pJob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pJob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pJob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pJob, &size_pJob_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pJob, size_pJob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pJob, size_pJob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pJob_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pJob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pJob, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumJobs(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumJobs *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumJobs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumJobs");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "FirstJob", r->in.FirstJob);
		ndr_print_uint32(ndr, "NoJobs", r->in.NoJobs);
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pJob", r->in.pJob);
		ndr->depth++;
		if (r->in.pJob) {
			ndr_print_array_uint8(ndr, "pJob", r->in.pJob, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumJobs");
		ndr->depth++;
		ndr_print_ptr(ndr, "pJob", r->out.pJob);
		ndr->depth++;
		if (r->out.pJob) {
			ndr_print_array_uint8(ndr, "pJob", r->out.pJob, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddJob(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddJob *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pAddJob));
		if (r->in.pAddJob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pAddJob, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pAddJob));
		if (r->out.pAddJob) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pAddJob, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddJob(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddJob *r)
{
	uint32_t _ptr_pAddJob;
	uint32_t size_pAddJob_1 = 0;
	TALLOC_CTX *_mem_save_pAddJob_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pAddJob));
		if (_ptr_pAddJob) {
			NDR_PULL_ALLOC(ndr, r->in.pAddJob);
		} else {
			r->in.pAddJob = NULL;
		}
		if (r->in.pAddJob) {
			_mem_save_pAddJob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pAddJob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pAddJob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pAddJob, &size_pAddJob_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pAddJob, size_pAddJob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pAddJob, size_pAddJob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pAddJob_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		if (r->in.pAddJob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pAddJob, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pAddJob));
		if (_ptr_pAddJob) {
			NDR_PULL_ALLOC(ndr, r->out.pAddJob);
		} else {
			r->out.pAddJob = NULL;
		}
		if (r->out.pAddJob) {
			_mem_save_pAddJob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pAddJob, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pAddJob));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pAddJob, &size_pAddJob_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pAddJob, size_pAddJob_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pAddJob, size_pAddJob_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pAddJob_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pAddJob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pAddJob, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddJob(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddJob *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddJob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddJob");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pAddJob", r->in.pAddJob);
		ndr->depth++;
		if (r->in.pAddJob) {
			ndr_print_array_uint8(ndr, "pAddJob", r->in.pAddJob, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddJob");
		ndr->depth++;
		ndr_print_ptr(ndr, "pAddJob", r->out.pAddJob);
		ndr->depth++;
		if (r->out.pAddJob) {
			ndr_print_array_uint8(ndr, "pAddJob", r->out.pAddJob, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncScheduleJob(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncScheduleJob *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncScheduleJob(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncScheduleJob *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncScheduleJob(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncScheduleJob *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncScheduleJob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncScheduleJob");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncScheduleJob");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinter *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncSetPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPrinterContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pDevModeContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pSecurityContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPrinterContainer));
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_CHECK(ndr_push_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSecurityContainer));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Command));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncSetPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetPrinter *r)
{
	TALLOC_CTX *_mem_save_pPrinterContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pDevModeContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pSecurityContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterContainer);
		}
		_mem_save_pPrinterContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrinterContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_SetPrinterInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPrinterContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterContainer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
		}
		_mem_save_pDevModeContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDevModeContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDevModeContainer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pSecurityContainer);
		}
		_mem_save_pSecurityContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pSecurityContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_sec_desc_buf(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pSecurityContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSecurityContainer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Command));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pPrinterContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterContainer);
			NDR_ZERO_STRUCTP(r->in.pPrinterContainer);
		}
		if (r->in.pDevModeContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
			NDR_ZERO_STRUCTP(r->in.pDevModeContainer);
		}
		if (r->in.pSecurityContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pSecurityContainer);
			NDR_ZERO_STRUCTP(r->in.pSecurityContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pPrinterContainer", r->in.pPrinterContainer);
		ndr->depth++;
		ndr_print_spoolss_SetPrinterInfoCtr(ndr, "pPrinterContainer", r->in.pPrinterContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pSecurityContainer", r->in.pSecurityContainer);
		ndr->depth++;
		ndr_print_sec_desc_buf(ndr, "pSecurityContainer", r->in.pSecurityContainer);
		ndr->depth--;
		ndr_print_uint32(ndr, "Command", r->in.Command);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncGetPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrinter));
		if (r->in.pPrinter) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pPrinter, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pPrinter));
		if (r->out.pPrinter) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pPrinter, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncGetPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrinter *r)
{
	uint32_t _ptr_pPrinter;
	uint32_t size_pPrinter_1 = 0;
	TALLOC_CTX *_mem_save_pPrinter_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinter));
		if (_ptr_pPrinter) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinter);
		} else {
			r->in.pPrinter = NULL;
		}
		if (r->in.pPrinter) {
			_mem_save_pPrinter_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrinter, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrinter));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pPrinter, &size_pPrinter_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pPrinter, size_pPrinter_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pPrinter, size_pPrinter_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinter_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		if (r->in.pPrinter) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pPrinter, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinter));
		if (_ptr_pPrinter) {
			NDR_PULL_ALLOC(ndr, r->out.pPrinter);
		} else {
			r->out.pPrinter = NULL;
		}
		if (r->out.pPrinter) {
			_mem_save_pPrinter_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pPrinter, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pPrinter));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pPrinter, &size_pPrinter_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pPrinter, size_pPrinter_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pPrinter, size_pPrinter_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinter_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pPrinter) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pPrinter, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pPrinter", r->in.pPrinter);
		ndr->depth++;
		if (r->in.pPrinter) {
			ndr_print_array_uint8(ndr, "pPrinter", r->in.pPrinter, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPrinter", r->out.pPrinter);
		ndr->depth++;
		if (r->out.pPrinter) {
			ndr_print_array_uint8(ndr, "pPrinter", r->out.pPrinter, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncStartDocPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncStartDocPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pDocInfoContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_spoolss_DocumentInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDocInfoContainer));
	}
	if (flags & NDR_OUT) {
		if (r->out.pJobId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pJobId));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncStartDocPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncStartDocPrinter *r)
{
	TALLOC_CTX *_mem_save_pDocInfoContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pJobId_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDocInfoContainer);
		}
		_mem_save_pDocInfoContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDocInfoContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DocumentInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDocInfoContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDocInfoContainer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pJobId);
		NDR_ZERO_STRUCTP(r->out.pJobId);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pDocInfoContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDocInfoContainer);
			NDR_ZERO_STRUCTP(r->in.pDocInfoContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pJobId);
		}
		_mem_save_pJobId_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pJobId, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pJobId));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pJobId_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncStartDocPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncStartDocPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncStartDocPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncStartDocPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pDocInfoContainer", r->in.pDocInfoContainer);
		ndr->depth++;
		ndr_print_spoolss_DocumentInfoCtr(ndr, "pDocInfoContainer", r->in.pDocInfoContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncStartDocPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pJobId", r->out.pJobId);
		ndr->depth++;
		ndr_print_uint32(ndr, "pJobId", *r->out.pJobId);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncStartPagePrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncStartPagePrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncStartPagePrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncStartPagePrinter *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncStartPagePrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncStartPagePrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncStartPagePrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncStartPagePrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncStartPagePrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncWritePrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncWritePrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pBuf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pBuf, r->in.cbBuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcWritten == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcWritten));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncWritePrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncWritePrinter *r)
{
	uint32_t size_pBuf_1 = 0;
	TALLOC_CTX *_mem_save_pcWritten_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pBuf));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pBuf, &size_pBuf_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pBuf, size_pBuf_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pBuf, size_pBuf_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcWritten);
		NDR_ZERO_STRUCTP(r->out.pcWritten);
		if (r->in.pBuf) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pBuf, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcWritten);
		}
		_mem_save_pcWritten_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcWritten, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcWritten));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcWritten_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncWritePrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncWritePrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncWritePrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncWritePrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pBuf", r->in.pBuf);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pBuf", r->in.pBuf, r->in.cbBuf);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncWritePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pcWritten", r->out.pcWritten);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcWritten", *r->out.pcWritten);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEndPagePrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEndPagePrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEndPagePrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEndPagePrinter *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEndPagePrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEndPagePrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEndPagePrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEndPagePrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEndPagePrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEndDocPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEndDocPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEndDocPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEndDocPrinter *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEndDocPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEndDocPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEndDocPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEndDocPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEndDocPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAbortPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAbortPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAbortPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAbortPrinter *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAbortPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAbortPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAbortPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAbortPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAbortPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncGetPrinterData(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrinterData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pValueName, ndr_charset_length(r->in.pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.pType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pType));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pData, r->in.nSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncGetPrinterData(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrinterData *r)
{
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	uint32_t size_pData_1 = 0;
	TALLOC_CTX *_mem_save_pType_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pValueName, &size_pValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pValueName, &length_pValueName_1));
		if (length_pValueName_1 > size_pValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nSize));
		NDR_PULL_ALLOC(ndr, r->out.pType);
		NDR_ZERO_STRUCTP(r->out.pType);
		NDR_PULL_ALLOC_N(ndr, r->out.pData, r->in.nSize);
		memset(r->out.pData, 0, (r->in.nSize) * sizeof(*r->out.pData));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pType);
		}
		_mem_save_pType_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pType, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pType));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pType_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pData, &size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pData, size_pData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pData, size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pData, r->in.nSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrinterData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrinterData *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrinterData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrinterData");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pValueName", r->in.pValueName);
		ndr->depth++;
		ndr_print_string(ndr, "pValueName", r->in.pValueName);
		ndr->depth--;
		ndr_print_uint32(ndr, "nSize", r->in.nSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "pType", r->out.pType);
		ndr->depth++;
		ndr_print_uint32(ndr, "pType", *r->out.pType);
		ndr->depth--;
		ndr_print_ptr(ndr, "pData", r->out.pData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pData", r->out.pData, r->in.nSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetPrinterDataEx(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDataEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pKeyName, ndr_charset_length(r->in.pKeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pValueName, ndr_charset_length(r->in.pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.nSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.pType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pType));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.nSize));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pData, r->in.nSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetPrinterDataEx(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrinterDataEx *r)
{
	uint32_t size_pKeyName_1 = 0;
	uint32_t length_pKeyName_1 = 0;
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	uint32_t size_pData_1 = 0;
	TALLOC_CTX *_mem_save_pType_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pKeyName, &size_pKeyName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pKeyName, &length_pKeyName_1));
		if (length_pKeyName_1 > size_pKeyName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyName_1, length_pKeyName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pKeyName, length_pKeyName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pValueName, &size_pValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pValueName, &length_pValueName_1));
		if (length_pValueName_1 > size_pValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.nSize));
		NDR_PULL_ALLOC(ndr, r->out.pType);
		NDR_ZERO_STRUCTP(r->out.pType);
		NDR_PULL_ALLOC_N(ndr, r->out.pData, r->in.nSize);
		memset(r->out.pData, 0, (r->in.nSize) * sizeof(*r->out.pData));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pType);
		}
		_mem_save_pType_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pType, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pType));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pType_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pData, &size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pData, size_pData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pData, size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pData, r->in.nSize));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrinterDataEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDataEx *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrinterDataEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrinterDataEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth++;
		ndr_print_string(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pValueName", r->in.pValueName);
		ndr->depth++;
		ndr_print_string(ndr, "pValueName", r->in.pValueName);
		ndr->depth--;
		ndr_print_uint32(ndr, "nSize", r->in.nSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrinterDataEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "pType", r->out.pType);
		ndr->depth++;
		ndr_print_uint32(ndr, "pType", *r->out.pType);
		ndr->depth--;
		ndr_print_ptr(ndr, "pData", r->out.pData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pData", r->out.pData, r->in.nSize);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncSetPrinterData(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetPrinterData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pValueName, ndr_charset_length(r->in.pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Type));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pData, r->in.cbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbData));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncSetPrinterData(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetPrinterData *r)
{
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	uint32_t size_pData_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pValueName, &size_pValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pValueName, &length_pValueName_1));
		if (length_pValueName_1 > size_pValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pData, &size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pData, size_pData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pData, size_pData_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbData));
		if (r->in.pData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pData, r->in.cbData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetPrinterData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetPrinterData *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetPrinterData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetPrinterData");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pValueName", r->in.pValueName);
		ndr->depth++;
		ndr_print_string(ndr, "pValueName", r->in.pValueName);
		ndr->depth--;
		ndr_print_uint32(ndr, "Type", r->in.Type);
		ndr_print_ptr(ndr, "pData", r->in.pData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pData", r->in.pData, r->in.cbData);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbData", r->in.cbData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetPrinterData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncSetPrinterDataEx(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetPrinterDataEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pKeyName, ndr_charset_length(r->in.pKeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pValueName, ndr_charset_length(r->in.pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Type));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pData, r->in.cbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbData));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncSetPrinterDataEx(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetPrinterDataEx *r)
{
	uint32_t size_pKeyName_1 = 0;
	uint32_t length_pKeyName_1 = 0;
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	uint32_t size_pData_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pKeyName, &size_pKeyName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pKeyName, &length_pKeyName_1));
		if (length_pKeyName_1 > size_pKeyName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyName_1, length_pKeyName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pKeyName, length_pKeyName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pValueName, &size_pValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pValueName, &length_pValueName_1));
		if (length_pValueName_1 > size_pValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Type));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pData, &size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pData, size_pData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pData, size_pData_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbData));
		if (r->in.pData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pData, r->in.cbData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetPrinterDataEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetPrinterDataEx *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetPrinterDataEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetPrinterDataEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth++;
		ndr_print_string(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pValueName", r->in.pValueName);
		ndr->depth++;
		ndr_print_string(ndr, "pValueName", r->in.pValueName);
		ndr->depth--;
		ndr_print_uint32(ndr, "Type", r->in.Type);
		ndr_print_ptr(ndr, "pData", r->in.pData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pData", r->in.pData, r->in.cbData);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbData", r->in.cbData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetPrinterDataEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncClosePrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncClosePrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.phPrinter == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.phPrinter));
	}
	if (flags & NDR_OUT) {
		if (r->out.phPrinter == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phPrinter));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncClosePrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncClosePrinter *r)
{
	TALLOC_CTX *_mem_save_phPrinter_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.phPrinter);
		}
		_mem_save_phPrinter_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.phPrinter, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.phPrinter));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phPrinter_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.phPrinter);
		*r->out.phPrinter = *r->in.phPrinter;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.phPrinter == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.phPrinter);
			NDR_ZERO_STRUCTP(r->in.phPrinter);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phPrinter);
		}
		_mem_save_phPrinter_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phPrinter, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phPrinter));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phPrinter_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncClosePrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncClosePrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncClosePrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncClosePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "phPrinter", r->in.phPrinter);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phPrinter", r->in.phPrinter);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncClosePrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "phPrinter", r->out.phPrinter);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phPrinter", r->out.phPrinter);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddForm(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddForm *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pFormInfoContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_spoolss_AddFormInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pFormInfoContainer));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddForm(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddForm *r)
{
	TALLOC_CTX *_mem_save_pFormInfoContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pFormInfoContainer);
		}
		_mem_save_pFormInfoContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pFormInfoContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_AddFormInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pFormInfoContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pFormInfoContainer_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pFormInfoContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pFormInfoContainer);
			NDR_ZERO_STRUCTP(r->in.pFormInfoContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddForm(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddForm *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddForm");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddForm");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pFormInfoContainer", r->in.pFormInfoContainer);
		ndr->depth++;
		ndr_print_spoolss_AddFormInfoCtr(ndr, "pFormInfoContainer", r->in.pFormInfoContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddForm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeleteForm(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeleteForm *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pFormName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pFormName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pFormName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pFormName, ndr_charset_length(r->in.pFormName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeleteForm(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeleteForm *r)
{
	uint32_t size_pFormName_1 = 0;
	uint32_t length_pFormName_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pFormName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pFormName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pFormName, &size_pFormName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pFormName, &length_pFormName_1));
		if (length_pFormName_1 > size_pFormName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pFormName_1, length_pFormName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pFormName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pFormName, length_pFormName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeleteForm(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeleteForm *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeleteForm");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeleteForm");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pFormName", r->in.pFormName);
		ndr->depth++;
		ndr_print_string(ndr, "pFormName", r->in.pFormName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeleteForm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetForm(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetForm *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pFormName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pFormName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pFormName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pFormName, ndr_charset_length(r->in.pFormName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pForm));
		if (r->in.pForm) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pForm, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pForm));
		if (r->out.pForm) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pForm, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetForm(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetForm *r)
{
	uint32_t size_pFormName_1 = 0;
	uint32_t length_pFormName_1 = 0;
	uint32_t _ptr_pForm;
	uint32_t size_pForm_1 = 0;
	TALLOC_CTX *_mem_save_pForm_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pFormName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pFormName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pFormName, &size_pFormName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pFormName, &length_pFormName_1));
		if (length_pFormName_1 > size_pFormName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pFormName_1, length_pFormName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pFormName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pFormName, length_pFormName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pForm));
		if (_ptr_pForm) {
			NDR_PULL_ALLOC(ndr, r->in.pForm);
		} else {
			r->in.pForm = NULL;
		}
		if (r->in.pForm) {
			_mem_save_pForm_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pForm, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pForm));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pForm, &size_pForm_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pForm, size_pForm_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pForm, size_pForm_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pForm_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		if (r->in.pForm) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pForm, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pForm));
		if (_ptr_pForm) {
			NDR_PULL_ALLOC(ndr, r->out.pForm);
		} else {
			r->out.pForm = NULL;
		}
		if (r->out.pForm) {
			_mem_save_pForm_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pForm, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pForm));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pForm, &size_pForm_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pForm, size_pForm_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pForm, size_pForm_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pForm_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pForm) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pForm, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetForm(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetForm *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetForm");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetForm");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pFormName", r->in.pFormName);
		ndr->depth++;
		ndr_print_string(ndr, "pFormName", r->in.pFormName);
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pForm", r->in.pForm);
		ndr->depth++;
		if (r->in.pForm) {
			ndr_print_array_uint8(ndr, "pForm", r->in.pForm, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetForm");
		ndr->depth++;
		ndr_print_ptr(ndr, "pForm", r->out.pForm);
		ndr->depth++;
		if (r->out.pForm) {
			ndr_print_array_uint8(ndr, "pForm", r->out.pForm, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncSetForm(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetForm *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pFormName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pFormInfoContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pFormName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pFormName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pFormName, ndr_charset_length(r->in.pFormName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_spoolss_AddFormInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pFormInfoContainer));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncSetForm(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetForm *r)
{
	uint32_t size_pFormName_1 = 0;
	uint32_t length_pFormName_1 = 0;
	TALLOC_CTX *_mem_save_pFormInfoContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pFormName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pFormName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pFormName, &size_pFormName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pFormName, &length_pFormName_1));
		if (length_pFormName_1 > size_pFormName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pFormName_1, length_pFormName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pFormName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pFormName, length_pFormName_1, sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pFormInfoContainer);
		}
		_mem_save_pFormInfoContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pFormInfoContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_AddFormInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pFormInfoContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pFormInfoContainer_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pFormInfoContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pFormInfoContainer);
			NDR_ZERO_STRUCTP(r->in.pFormInfoContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetForm(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetForm *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetForm");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetForm");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pFormName", r->in.pFormName);
		ndr->depth++;
		ndr_print_string(ndr, "pFormName", r->in.pFormName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pFormInfoContainer", r->in.pFormInfoContainer);
		ndr->depth++;
		ndr_print_spoolss_AddFormInfoCtr(ndr, "pFormInfoContainer", r->in.pFormInfoContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetForm");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncEnumForms(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumForms *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pForm));
		if (r->in.pForm) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pForm, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pForm));
		if (r->out.pForm) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pForm, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncEnumForms(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumForms *r)
{
	uint32_t _ptr_pForm;
	uint32_t size_pForm_1 = 0;
	TALLOC_CTX *_mem_save_pForm_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pForm));
		if (_ptr_pForm) {
			NDR_PULL_ALLOC(ndr, r->in.pForm);
		} else {
			r->in.pForm = NULL;
		}
		if (r->in.pForm) {
			_mem_save_pForm_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pForm, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pForm));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pForm, &size_pForm_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pForm, size_pForm_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pForm, size_pForm_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pForm_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pForm) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pForm, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pForm));
		if (_ptr_pForm) {
			NDR_PULL_ALLOC(ndr, r->out.pForm);
		} else {
			r->out.pForm = NULL;
		}
		if (r->out.pForm) {
			_mem_save_pForm_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pForm, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pForm));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pForm, &size_pForm_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pForm, size_pForm_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pForm, size_pForm_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pForm_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pForm) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pForm, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumForms(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumForms *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumForms");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumForms");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pForm", r->in.pForm);
		ndr->depth++;
		if (r->in.pForm) {
			ndr_print_array_uint8(ndr, "pForm", r->in.pForm, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumForms");
		ndr->depth++;
		ndr_print_ptr(ndr, "pForm", r->out.pForm);
		ndr->depth++;
		if (r->out.pForm) {
			ndr_print_array_uint8(ndr, "pForm", r->out.pForm, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncGetPrinterDriver(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDriver *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDriver));
		if (r->in.pDriver) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pDriver, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwClientMajorVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwClientMinorVersion));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pdwServerMaxVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pdwServerMinVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pDriver));
		if (r->out.pDriver) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pDriver, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pdwServerMaxVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pdwServerMinVersion));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncGetPrinterDriver(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrinterDriver *r)
{
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t _ptr_pDriver;
	uint32_t size_pDriver_1 = 0;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	TALLOC_CTX *_mem_save_pDriver_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pdwServerMaxVersion_0 = NULL;
	TALLOC_CTX *_mem_save_pdwServerMinVersion_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDriver));
		if (_ptr_pDriver) {
			NDR_PULL_ALLOC(ndr, r->in.pDriver);
		} else {
			r->in.pDriver = NULL;
		}
		if (r->in.pDriver) {
			_mem_save_pDriver_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDriver, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDriver));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pDriver, &size_pDriver_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pDriver, size_pDriver_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pDriver, size_pDriver_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDriver_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwClientMajorVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwClientMinorVersion));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pdwServerMaxVersion);
		NDR_ZERO_STRUCTP(r->out.pdwServerMaxVersion);
		NDR_PULL_ALLOC(ndr, r->out.pdwServerMinVersion);
		NDR_ZERO_STRUCTP(r->out.pdwServerMinVersion);
		if (r->in.pDriver) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pDriver, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDriver));
		if (_ptr_pDriver) {
			NDR_PULL_ALLOC(ndr, r->out.pDriver);
		} else {
			r->out.pDriver = NULL;
		}
		if (r->out.pDriver) {
			_mem_save_pDriver_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pDriver, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pDriver));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pDriver, &size_pDriver_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pDriver, size_pDriver_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pDriver, size_pDriver_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDriver_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwServerMaxVersion);
		}
		_mem_save_pdwServerMaxVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwServerMaxVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pdwServerMaxVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwServerMaxVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwServerMinVersion);
		}
		_mem_save_pdwServerMinVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwServerMinVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pdwServerMinVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwServerMinVersion_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pDriver) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pDriver, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrinterDriver(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDriver *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrinterDriver");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrinterDriver");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pDriver", r->in.pDriver);
		ndr->depth++;
		if (r->in.pDriver) {
			ndr_print_array_uint8(ndr, "pDriver", r->in.pDriver, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr_print_uint32(ndr, "dwClientMajorVersion", r->in.dwClientMajorVersion);
		ndr_print_uint32(ndr, "dwClientMinorVersion", r->in.dwClientMinorVersion);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrinterDriver");
		ndr->depth++;
		ndr_print_ptr(ndr, "pDriver", r->out.pDriver);
		ndr->depth++;
		if (r->out.pDriver) {
			ndr_print_array_uint8(ndr, "pDriver", r->out.pDriver, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pdwServerMaxVersion", r->out.pdwServerMaxVersion);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwServerMaxVersion", *r->out.pdwServerMaxVersion);
		ndr->depth--;
		ndr_print_ptr(ndr, "pdwServerMinVersion", r->out.pdwServerMinVersion);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwServerMinVersion", *r->out.pdwServerMinVersion);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPrinterData(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterData *r)
{
	uint32_t cntr_pValueName_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwIndex));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbValueName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbData));
	}
	if (flags & NDR_OUT) {
		if (r->out.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pType == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbValueName / 2));
		for (cntr_pValueName_1 = 0; cntr_pValueName_1 < (r->in.cbValueName / 2); cntr_pValueName_1++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.pValueName[cntr_pValueName_1]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbValueName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pType));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pData, r->in.cbData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbData));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPrinterData(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrinterData *r)
{
	uint32_t size_pValueName_1 = 0;
	uint32_t cntr_pValueName_1;
	uint32_t size_pData_1 = 0;
	TALLOC_CTX *_mem_save_pValueName_1 = NULL;
	TALLOC_CTX *_mem_save_pcbValueName_0 = NULL;
	TALLOC_CTX *_mem_save_pType_0 = NULL;
	TALLOC_CTX *_mem_save_pcbData_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwIndex));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbValueName));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbData));
		NDR_PULL_ALLOC_N(ndr, r->out.pValueName, r->in.cbValueName / 2);
		memset(r->out.pValueName, 0, (r->in.cbValueName / 2) * sizeof(*r->out.pValueName));
		NDR_PULL_ALLOC(ndr, r->out.pcbValueName);
		NDR_ZERO_STRUCTP(r->out.pcbValueName);
		NDR_PULL_ALLOC(ndr, r->out.pType);
		NDR_ZERO_STRUCTP(r->out.pType);
		NDR_PULL_ALLOC_N(ndr, r->out.pData, r->in.cbData);
		memset(r->out.pData, 0, (r->in.cbData) * sizeof(*r->out.pData));
		NDR_PULL_ALLOC(ndr, r->out.pcbData);
		NDR_ZERO_STRUCTP(r->out.pcbData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pValueName));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pValueName, &size_pValueName_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pValueName, size_pValueName_1);
		}
		_mem_save_pValueName_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pValueName, 0);
		for (cntr_pValueName_1 = 0; cntr_pValueName_1 < (size_pValueName_1); cntr_pValueName_1++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.pValueName[cntr_pValueName_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pValueName_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbValueName);
		}
		_mem_save_pcbValueName_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbValueName, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbValueName));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbValueName_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pType);
		}
		_mem_save_pType_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pType, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pType));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pType_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pData, &size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pData, size_pData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pData, size_pData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbData);
		}
		_mem_save_pcbData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pValueName) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pValueName, r->in.cbValueName / 2));
		}
		if (r->out.pData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pData, r->in.cbData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrinterData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterData *r)
{
	uint32_t cntr_pValueName_1;
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrinterData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrinterData");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "dwIndex", r->in.dwIndex);
		ndr_print_uint32(ndr, "cbValueName", r->in.cbValueName);
		ndr_print_uint32(ndr, "cbData", r->in.cbData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrinterData");
		ndr->depth++;
		ndr_print_ptr(ndr, "pValueName", r->out.pValueName);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pValueName", (uint32_t)(r->in.cbValueName / 2));
		ndr->depth++;
		for (cntr_pValueName_1 = 0; cntr_pValueName_1 < (r->in.cbValueName / 2); cntr_pValueName_1++) {
			ndr_print_uint16(ndr, "pValueName", r->out.pValueName[cntr_pValueName_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbValueName", r->out.pcbValueName);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbValueName", *r->out.pcbValueName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pType", r->out.pType);
		ndr->depth++;
		ndr_print_uint32(ndr, "pType", *r->out.pType);
		ndr->depth--;
		ndr_print_ptr(ndr, "pData", r->out.pData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pData", r->out.pData, r->in.cbData);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbData", r->out.pcbData);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbData", *r->out.pcbData);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncEnumPrinterDataEx(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterDataEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pKeyName, ndr_charset_length(r->in.pKeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbEnumValues));
	}
	if (flags & NDR_OUT) {
		if (r->out.pEnumValues == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbEnumValues == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pnEnumValues == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbEnumValues));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pEnumValues, r->in.cbEnumValues));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbEnumValues));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pnEnumValues));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncEnumPrinterDataEx(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrinterDataEx *r)
{
	uint32_t size_pKeyName_1 = 0;
	uint32_t length_pKeyName_1 = 0;
	uint32_t size_pEnumValues_1 = 0;
	TALLOC_CTX *_mem_save_pcbEnumValues_0 = NULL;
	TALLOC_CTX *_mem_save_pnEnumValues_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pKeyName, &size_pKeyName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pKeyName, &length_pKeyName_1));
		if (length_pKeyName_1 > size_pKeyName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyName_1, length_pKeyName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pKeyName, length_pKeyName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbEnumValues));
		NDR_PULL_ALLOC_N(ndr, r->out.pEnumValues, r->in.cbEnumValues);
		memset(r->out.pEnumValues, 0, (r->in.cbEnumValues) * sizeof(*r->out.pEnumValues));
		NDR_PULL_ALLOC(ndr, r->out.pcbEnumValues);
		NDR_ZERO_STRUCTP(r->out.pcbEnumValues);
		NDR_PULL_ALLOC(ndr, r->out.pnEnumValues);
		NDR_ZERO_STRUCTP(r->out.pnEnumValues);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pEnumValues));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pEnumValues, &size_pEnumValues_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pEnumValues, size_pEnumValues_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pEnumValues, size_pEnumValues_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbEnumValues);
		}
		_mem_save_pcbEnumValues_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbEnumValues, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbEnumValues));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbEnumValues_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pnEnumValues);
		}
		_mem_save_pnEnumValues_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pnEnumValues, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pnEnumValues));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pnEnumValues_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pEnumValues) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pEnumValues, r->in.cbEnumValues));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrinterDataEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterDataEx *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrinterDataEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrinterDataEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth++;
		ndr_print_string(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbEnumValues", r->in.cbEnumValues);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrinterDataEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "pEnumValues", r->out.pEnumValues);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pEnumValues", r->out.pEnumValues, r->in.cbEnumValues);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbEnumValues", r->out.pcbEnumValues);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbEnumValues", *r->out.pcbEnumValues);
		ndr->depth--;
		ndr_print_ptr(ndr, "pnEnumValues", r->out.pnEnumValues);
		ndr->depth++;
		ndr_print_uint32(ndr, "pnEnumValues", *r->out.pnEnumValues);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncEnumPrinterKey(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterKey *r)
{
	uint32_t cntr_pSubkey_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pKeyName, ndr_charset_length(r->in.pKeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbSubkey));
	}
	if (flags & NDR_OUT) {
		if (r->out.pSubkey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbSubkey == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbSubkey / 2));
		for (cntr_pSubkey_1 = 0; cntr_pSubkey_1 < (r->in.cbSubkey / 2); cntr_pSubkey_1++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.pSubkey[cntr_pSubkey_1]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbSubkey));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncEnumPrinterKey(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrinterKey *r)
{
	uint32_t size_pKeyName_1 = 0;
	uint32_t length_pKeyName_1 = 0;
	uint32_t size_pSubkey_1 = 0;
	uint32_t cntr_pSubkey_1;
	TALLOC_CTX *_mem_save_pSubkey_1 = NULL;
	TALLOC_CTX *_mem_save_pcbSubkey_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pKeyName, &size_pKeyName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pKeyName, &length_pKeyName_1));
		if (length_pKeyName_1 > size_pKeyName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyName_1, length_pKeyName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pKeyName, length_pKeyName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbSubkey));
		NDR_PULL_ALLOC_N(ndr, r->out.pSubkey, r->in.cbSubkey / 2);
		memset(r->out.pSubkey, 0, (r->in.cbSubkey / 2) * sizeof(*r->out.pSubkey));
		NDR_PULL_ALLOC(ndr, r->out.pcbSubkey);
		NDR_ZERO_STRUCTP(r->out.pcbSubkey);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pSubkey));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pSubkey, &size_pSubkey_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pSubkey, size_pSubkey_1);
		}
		_mem_save_pSubkey_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pSubkey, 0);
		for (cntr_pSubkey_1 = 0; cntr_pSubkey_1 < (size_pSubkey_1); cntr_pSubkey_1++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.pSubkey[cntr_pSubkey_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSubkey_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbSubkey);
		}
		_mem_save_pcbSubkey_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbSubkey, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbSubkey));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbSubkey_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pSubkey) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pSubkey, r->in.cbSubkey / 2));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrinterKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterKey *r)
{
	uint32_t cntr_pSubkey_1;
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrinterKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrinterKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth++;
		ndr_print_string(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbSubkey", r->in.cbSubkey);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrinterKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "pSubkey", r->out.pSubkey);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pSubkey", (uint32_t)(r->in.cbSubkey / 2));
		ndr->depth++;
		for (cntr_pSubkey_1 = 0; cntr_pSubkey_1 < (r->in.cbSubkey / 2); cntr_pSubkey_1++) {
			ndr_print_uint16(ndr, "pSubkey", r->out.pSubkey[cntr_pSubkey_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbSubkey", r->out.pcbSubkey);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbSubkey", *r->out.pcbSubkey);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterData(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pValueName, ndr_charset_length(r->in.pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterData(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterData *r)
{
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pValueName, &size_pValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pValueName, &length_pValueName_1));
		if (length_pValueName_1 > size_pValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterData *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterData");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pValueName", r->in.pValueName);
		ndr->depth++;
		ndr_print_string(ndr, "pValueName", r->in.pValueName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterDataEx(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDataEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pValueName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pKeyName, ndr_charset_length(r->in.pKeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pValueName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pValueName, ndr_charset_length(r->in.pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterDataEx(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterDataEx *r)
{
	uint32_t size_pKeyName_1 = 0;
	uint32_t length_pKeyName_1 = 0;
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pKeyName, &size_pKeyName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pKeyName, &length_pKeyName_1));
		if (length_pKeyName_1 > size_pKeyName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyName_1, length_pKeyName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pKeyName, length_pKeyName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pValueName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pValueName, &size_pValueName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pValueName, &length_pValueName_1));
		if (length_pValueName_1 > size_pValueName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterDataEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDataEx *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterDataEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterDataEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth++;
		ndr_print_string(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pValueName", r->in.pValueName);
		ndr->depth++;
		ndr_print_string(ndr, "pValueName", r->in.pValueName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterDataEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterKey(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pKeyName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pKeyName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pKeyName, ndr_charset_length(r->in.pKeyName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterKey(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterKey *r)
{
	uint32_t size_pKeyName_1 = 0;
	uint32_t length_pKeyName_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pKeyName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pKeyName, &size_pKeyName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pKeyName, &length_pKeyName_1));
		if (length_pKeyName_1 > size_pKeyName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyName_1, length_pKeyName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pKeyName, length_pKeyName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterKey *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterKey");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth++;
		ndr_print_string(ndr, "pKeyName", r->in.pKeyName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncXcvData(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncXcvData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszDataName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pInputData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pdwStatus == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hXcv));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszDataName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszDataName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszDataName, ndr_charset_length(r->in.pszDataName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbInputData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pInputData, r->in.cbInputData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbInputData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbOutputData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.pdwStatus));
	}
	if (flags & NDR_OUT) {
		if (r->out.pOutputData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcbOutputNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pdwStatus == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbOutputData));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pOutputData, r->in.cbOutputData));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbOutputNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pdwStatus));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncXcvData(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncXcvData *r)
{
	uint32_t size_pszDataName_1 = 0;
	uint32_t length_pszDataName_1 = 0;
	uint32_t size_pInputData_1 = 0;
	uint32_t size_pOutputData_1 = 0;
	TALLOC_CTX *_mem_save_pcbOutputNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pdwStatus_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hXcv));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszDataName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszDataName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszDataName, &size_pszDataName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszDataName, &length_pszDataName_1));
		if (length_pszDataName_1 > size_pszDataName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataName_1, length_pszDataName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszDataName, length_pszDataName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pInputData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pInputData, &size_pInputData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pInputData, size_pInputData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pInputData, size_pInputData_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbInputData));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbOutputData));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pdwStatus);
		}
		_mem_save_pdwStatus_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pdwStatus, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.pdwStatus));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwStatus_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC_N(ndr, r->out.pOutputData, r->in.cbOutputData);
		memset(r->out.pOutputData, 0, (r->in.cbOutputData) * sizeof(*r->out.pOutputData));
		NDR_PULL_ALLOC(ndr, r->out.pcbOutputNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbOutputNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pdwStatus);
		*r->out.pdwStatus = *r->in.pdwStatus;
		if (r->in.pInputData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pInputData, r->in.cbInputData));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pdwStatus == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pdwStatus);
			NDR_ZERO_STRUCTP(r->in.pdwStatus);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pOutputData));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pOutputData, &size_pOutputData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pOutputData, size_pOutputData_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pOutputData, size_pOutputData_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbOutputNeeded);
		}
		_mem_save_pcbOutputNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbOutputNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbOutputNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbOutputNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwStatus);
		}
		_mem_save_pdwStatus_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwStatus, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pdwStatus));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwStatus_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pOutputData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pOutputData, r->in.cbOutputData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncXcvData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncXcvData *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncXcvData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncXcvData");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hXcv", &r->in.hXcv);
		ndr_print_ptr(ndr, "pszDataName", r->in.pszDataName);
		ndr->depth++;
		ndr_print_string(ndr, "pszDataName", r->in.pszDataName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pInputData", r->in.pInputData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pInputData", r->in.pInputData, r->in.cbInputData);
		ndr->depth--;
		ndr_print_uint32(ndr, "cbInputData", r->in.cbInputData);
		ndr_print_uint32(ndr, "cbOutputData", r->in.cbOutputData);
		ndr_print_ptr(ndr, "pdwStatus", r->in.pdwStatus);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwStatus", *r->in.pdwStatus);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncXcvData");
		ndr->depth++;
		ndr_print_ptr(ndr, "pOutputData", r->out.pOutputData);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pOutputData", r->out.pOutputData, r->in.cbOutputData);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbOutputNeeded", r->out.pcbOutputNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbOutputNeeded", *r->out.pcbOutputNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pdwStatus", r->out.pdwStatus);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwStatus", *r->out.pdwStatus);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncSendRecvBidiData(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSendRecvBidiData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pReqData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pAction));
		if (r->in.pAction) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pAction, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pAction, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pAction, ndr_charset_length(r->in.pAction, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_RPC_BIDI_REQUEST_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pReqData));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppRespData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppRespData));
		if (*r->out.ppRespData) {
			NDR_CHECK(ndr_push_RPC_BIDI_RESPONSE_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppRespData));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncSendRecvBidiData(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSendRecvBidiData *r)
{
	uint32_t _ptr_pAction;
	uint32_t size_pAction_1 = 0;
	uint32_t length_pAction_1 = 0;
	uint32_t _ptr_ppRespData;
	TALLOC_CTX *_mem_save_pAction_0 = NULL;
	TALLOC_CTX *_mem_save_pReqData_0 = NULL;
	TALLOC_CTX *_mem_save_ppRespData_0 = NULL;
	TALLOC_CTX *_mem_save_ppRespData_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pAction));
		if (_ptr_pAction) {
			NDR_PULL_ALLOC(ndr, r->in.pAction);
		} else {
			r->in.pAction = NULL;
		}
		if (r->in.pAction) {
			_mem_save_pAction_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pAction, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pAction));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pAction));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pAction, &size_pAction_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pAction, &length_pAction_1));
			if (length_pAction_1 > size_pAction_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pAction_1, length_pAction_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pAction_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pAction, length_pAction_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pAction_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pReqData);
		}
		_mem_save_pReqData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pReqData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_RPC_BIDI_REQUEST_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pReqData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pReqData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ppRespData);
		NDR_ZERO_STRUCTP(r->out.ppRespData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pReqData == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pReqData);
			NDR_ZERO_STRUCTP(r->in.pReqData);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppRespData);
		}
		_mem_save_ppRespData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppRespData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppRespData));
		if (_ptr_ppRespData) {
			NDR_PULL_ALLOC(ndr, *r->out.ppRespData);
		} else {
			*r->out.ppRespData = NULL;
		}
		if (*r->out.ppRespData) {
			_mem_save_ppRespData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppRespData, 0);
			NDR_CHECK(ndr_pull_RPC_BIDI_RESPONSE_CONTAINER(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppRespData));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppRespData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppRespData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSendRecvBidiData(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSendRecvBidiData *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSendRecvBidiData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSendRecvBidiData");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pAction", r->in.pAction);
		ndr->depth++;
		if (r->in.pAction) {
			ndr_print_string(ndr, "pAction", r->in.pAction);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pReqData", r->in.pReqData);
		ndr->depth++;
		ndr_print_RPC_BIDI_REQUEST_CONTAINER(ndr, "pReqData", r->in.pReqData);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSendRecvBidiData");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppRespData", r->out.ppRespData);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppRespData", *r->out.ppRespData);
		ndr->depth++;
		if (*r->out.ppRespData) {
			ndr_print_RPC_BIDI_RESPONSE_CONTAINER(ndr, "ppRespData", *r->out.ppRespData);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncCreatePrinterIC(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncCreatePrinterIC *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pDevModeContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
	}
	if (flags & NDR_OUT) {
		if (r->out.pHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.pHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncCreatePrinterIC(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncCreatePrinterIC *r)
{
	TALLOC_CTX *_mem_save_pHandle_0 = NULL;
	TALLOC_CTX *_mem_save_pDevModeContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
		}
		_mem_save_pDevModeContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDevModeContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDevModeContainer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pHandle);
		NDR_ZERO_STRUCTP(r->out.pHandle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pDevModeContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
			NDR_ZERO_STRUCTP(r->in.pDevModeContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pHandle);
		}
		_mem_save_pHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.pHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncCreatePrinterIC(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncCreatePrinterIC *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncCreatePrinterIC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncCreatePrinterIC");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncCreatePrinterIC");
		ndr->depth++;
		ndr_print_ptr(ndr, "pHandle", r->out.pHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "pHandle", r->out.pHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncPlayGdiScriptOnPrinterIC(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncPlayGdiScriptOnPrinterIC *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pIn == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinterIC));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cIn));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pIn, r->in.cIn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cIn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cOut));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.ul));
	}
	if (flags & NDR_OUT) {
		if (r->out.pOut == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cOut));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pOut, r->in.cOut));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncPlayGdiScriptOnPrinterIC(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncPlayGdiScriptOnPrinterIC *r)
{
	uint32_t size_pIn_1 = 0;
	uint32_t size_pOut_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinterIC));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pIn));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pIn, &size_pIn_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pIn, size_pIn_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pIn, size_pIn_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cIn));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cOut));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.ul));
		NDR_PULL_ALLOC_N(ndr, r->out.pOut, r->in.cOut);
		memset(r->out.pOut, 0, (r->in.cOut) * sizeof(*r->out.pOut));
		if (r->in.pIn) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pIn, r->in.cIn));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pOut));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pOut, &size_pOut_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pOut, size_pOut_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pOut, size_pOut_1));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pOut) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pOut, r->in.cOut));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncPlayGdiScriptOnPrinterIC(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncPlayGdiScriptOnPrinterIC *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncPlayGdiScriptOnPrinterIC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncPlayGdiScriptOnPrinterIC");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinterIC", &r->in.hPrinterIC);
		ndr_print_ptr(ndr, "pIn", r->in.pIn);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pIn", r->in.pIn, r->in.cIn);
		ndr->depth--;
		ndr_print_uint32(ndr, "cIn", r->in.cIn);
		ndr_print_uint32(ndr, "cOut", r->in.cOut);
		ndr_print_uint32(ndr, "ul", r->in.ul);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncPlayGdiScriptOnPrinterIC");
		ndr->depth++;
		ndr_print_ptr(ndr, "pOut", r->out.pOut);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pOut", r->out.pOut, r->in.cOut);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterIC(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterIC *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.phPrinterIC == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.phPrinterIC));
	}
	if (flags & NDR_OUT) {
		if (r->out.phPrinterIC == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phPrinterIC));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterIC(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterIC *r)
{
	TALLOC_CTX *_mem_save_phPrinterIC_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.phPrinterIC);
		}
		_mem_save_phPrinterIC_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.phPrinterIC, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.phPrinterIC));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phPrinterIC_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.phPrinterIC);
		*r->out.phPrinterIC = *r->in.phPrinterIC;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.phPrinterIC == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.phPrinterIC);
			NDR_ZERO_STRUCTP(r->in.phPrinterIC);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phPrinterIC);
		}
		_mem_save_phPrinterIC_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phPrinterIC, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phPrinterIC));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phPrinterIC_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterIC(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterIC *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterIC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterIC");
		ndr->depth++;
		ndr_print_ptr(ndr, "phPrinterIC", r->in.phPrinterIC);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phPrinterIC", r->in.phPrinterIC);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterIC");
		ndr->depth++;
		ndr_print_ptr(ndr, "phPrinterIC", r->out.phPrinterIC);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phPrinterIC", r->out.phPrinterIC);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPrinters(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrinters *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrinterEnum));
		if (r->in.pPrinterEnum) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pPrinterEnum, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pPrinterEnum));
		if (r->out.pPrinterEnum) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pPrinterEnum, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPrinters(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrinters *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pPrinterEnum;
	uint32_t size_pPrinterEnum_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pPrinterEnum_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinterEnum));
		if (_ptr_pPrinterEnum) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterEnum);
		} else {
			r->in.pPrinterEnum = NULL;
		}
		if (r->in.pPrinterEnum) {
			_mem_save_pPrinterEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrinterEnum, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrinterEnum));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pPrinterEnum, &size_pPrinterEnum_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pPrinterEnum, size_pPrinterEnum_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pPrinterEnum, size_pPrinterEnum_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterEnum_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pPrinterEnum) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pPrinterEnum, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinterEnum));
		if (_ptr_pPrinterEnum) {
			NDR_PULL_ALLOC(ndr, r->out.pPrinterEnum);
		} else {
			r->out.pPrinterEnum = NULL;
		}
		if (r->out.pPrinterEnum) {
			_mem_save_pPrinterEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pPrinterEnum, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pPrinterEnum));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pPrinterEnum, &size_pPrinterEnum_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pPrinterEnum, size_pPrinterEnum_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pPrinterEnum, size_pPrinterEnum_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterEnum_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pPrinterEnum) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pPrinterEnum, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrinters(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrinters *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrinters");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrinters");
		ndr->depth++;
		ndr_print_uint32(ndr, "Flags", r->in.Flags);
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pPrinterEnum", r->in.pPrinterEnum);
		ndr->depth++;
		if (r->in.pPrinterEnum) {
			ndr_print_array_uint8(ndr, "pPrinterEnum", r->in.pPrinterEnum, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrinters");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPrinterEnum", r->out.pPrinterEnum);
		ndr->depth++;
		if (r->out.pPrinterEnum) {
			ndr_print_array_uint8(ndr, "pPrinterEnum", r->out.pPrinterEnum, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncAddPrinterDriver(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddPrinterDriver *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pDriverContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_AddDriverInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDriverContainer));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwFileCopyFlags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncAddPrinterDriver(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddPrinterDriver *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pDriverContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDriverContainer);
		}
		_mem_save_pDriverContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDriverContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_AddDriverInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDriverContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDriverContainer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwFileCopyFlags));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pDriverContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDriverContainer);
			NDR_ZERO_STRUCTP(r->in.pDriverContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddPrinterDriver(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddPrinterDriver *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddPrinterDriver");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddPrinterDriver");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pDriverContainer", r->in.pDriverContainer);
		ndr->depth++;
		ndr_print_spoolss_AddDriverInfoCtr(ndr, "pDriverContainer", r->in.pDriverContainer);
		ndr->depth--;
		ndr_print_uint32(ndr, "dwFileCopyFlags", r->in.dwFileCopyFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddPrinterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPrinterDrivers(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterDrivers *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDrivers));
		if (r->in.pDrivers) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pDrivers, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pDrivers));
		if (r->out.pDrivers) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pDrivers, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPrinterDrivers(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrinterDrivers *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t _ptr_pDrivers;
	uint32_t size_pDrivers_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	TALLOC_CTX *_mem_save_pDrivers_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDrivers));
		if (_ptr_pDrivers) {
			NDR_PULL_ALLOC(ndr, r->in.pDrivers);
		} else {
			r->in.pDrivers = NULL;
		}
		if (r->in.pDrivers) {
			_mem_save_pDrivers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDrivers, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDrivers));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pDrivers, &size_pDrivers_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pDrivers, size_pDrivers_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pDrivers, size_pDrivers_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDrivers_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pDrivers) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pDrivers, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDrivers));
		if (_ptr_pDrivers) {
			NDR_PULL_ALLOC(ndr, r->out.pDrivers);
		} else {
			r->out.pDrivers = NULL;
		}
		if (r->out.pDrivers) {
			_mem_save_pDrivers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pDrivers, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pDrivers));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pDrivers, &size_pDrivers_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pDrivers, size_pDrivers_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pDrivers, size_pDrivers_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDrivers_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pDrivers) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pDrivers, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrinterDrivers(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrinterDrivers *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrinterDrivers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrinterDrivers");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pDrivers", r->in.pDrivers);
		ndr->depth++;
		if (r->in.pDrivers) {
			ndr_print_array_uint8(ndr, "pDrivers", r->in.pDrivers, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrinterDrivers");
		ndr->depth++;
		ndr_print_ptr(ndr, "pDrivers", r->out.pDrivers);
		ndr->depth++;
		if (r->out.pDrivers) {
			ndr_print_array_uint8(ndr, "pDrivers", r->out.pDrivers, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncGetPrinterDriverDirectory(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDriverDirectory *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDriverDirectory));
		if (r->in.pDriverDirectory) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pDriverDirectory, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pDriverDirectory));
		if (r->out.pDriverDirectory) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pDriverDirectory, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncGetPrinterDriverDirectory(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrinterDriverDirectory *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t _ptr_pDriverDirectory;
	uint32_t size_pDriverDirectory_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	TALLOC_CTX *_mem_save_pDriverDirectory_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDriverDirectory));
		if (_ptr_pDriverDirectory) {
			NDR_PULL_ALLOC(ndr, r->in.pDriverDirectory);
		} else {
			r->in.pDriverDirectory = NULL;
		}
		if (r->in.pDriverDirectory) {
			_mem_save_pDriverDirectory_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDriverDirectory, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDriverDirectory));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pDriverDirectory, &size_pDriverDirectory_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pDriverDirectory, size_pDriverDirectory_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pDriverDirectory, size_pDriverDirectory_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDriverDirectory_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		if (r->in.pDriverDirectory) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pDriverDirectory, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDriverDirectory));
		if (_ptr_pDriverDirectory) {
			NDR_PULL_ALLOC(ndr, r->out.pDriverDirectory);
		} else {
			r->out.pDriverDirectory = NULL;
		}
		if (r->out.pDriverDirectory) {
			_mem_save_pDriverDirectory_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pDriverDirectory, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pDriverDirectory));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pDriverDirectory, &size_pDriverDirectory_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pDriverDirectory, size_pDriverDirectory_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pDriverDirectory, size_pDriverDirectory_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDriverDirectory_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pDriverDirectory) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pDriverDirectory, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrinterDriverDirectory(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDriverDirectory *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrinterDriverDirectory");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrinterDriverDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pDriverDirectory", r->in.pDriverDirectory);
		ndr->depth++;
		if (r->in.pDriverDirectory) {
			ndr_print_array_uint8(ndr, "pDriverDirectory", r->in.pDriverDirectory, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrinterDriverDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "pDriverDirectory", r->out.pDriverDirectory);
		ndr->depth++;
		if (r->out.pDriverDirectory) {
			ndr_print_array_uint8(ndr, "pDriverDirectory", r->out.pDriverDirectory, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterDriver(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDriver *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pDriverName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDriverName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDriverName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pDriverName, ndr_charset_length(r->in.pDriverName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterDriver(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterDriver *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t size_pDriverName_1 = 0;
	uint32_t length_pDriverName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
		if (length_pEnvironment_1 > size_pEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDriverName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pDriverName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pDriverName, &size_pDriverName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pDriverName, &length_pDriverName_1));
		if (length_pDriverName_1 > size_pDriverName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pDriverName_1, length_pDriverName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pDriverName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pDriverName, length_pDriverName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterDriver(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDriver *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterDriver");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterDriver");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth--;
		ndr_print_ptr(ndr, "pDriverName", r->in.pDriverName);
		ndr->depth++;
		ndr_print_string(ndr, "pDriverName", r->in.pDriverName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterDriverEx(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDriverEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pDriverName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDriverName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDriverName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pDriverName, ndr_charset_length(r->in.pDriverName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDeleteFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwVersionNum));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterDriverEx(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterDriverEx *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t size_pDriverName_1 = 0;
	uint32_t length_pDriverName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
		if (length_pEnvironment_1 > size_pEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDriverName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pDriverName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pDriverName, &size_pDriverName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pDriverName, &length_pDriverName_1));
		if (length_pDriverName_1 > size_pDriverName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pDriverName_1, length_pDriverName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pDriverName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pDriverName, length_pDriverName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDeleteFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwVersionNum));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterDriverEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDriverEx *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterDriverEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterDriverEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth--;
		ndr_print_ptr(ndr, "pDriverName", r->in.pDriverName);
		ndr->depth++;
		ndr_print_string(ndr, "pDriverName", r->in.pDriverName);
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDeleteFlag", r->in.dwDeleteFlag);
		ndr_print_uint32(ndr, "dwVersionNum", r->in.dwVersionNum);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterDriverEx");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddPrintProcessor(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddPrintProcessor *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pPathName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pPrintProcessorName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPathName, ndr_charset_length(r->in.pPathName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrintProcessorName, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddPrintProcessor(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddPrintProcessor *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t size_pPathName_1 = 0;
	uint32_t length_pPathName_1 = 0;
	uint32_t size_pPrintProcessorName_1 = 0;
	uint32_t length_pPrintProcessorName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
		if (length_pEnvironment_1 > size_pEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPathName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPathName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPathName, &size_pPathName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPathName, &length_pPathName_1));
		if (length_pPathName_1 > size_pPathName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPathName_1, length_pPathName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pPathName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPathName, length_pPathName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrintProcessorName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrintProcessorName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrintProcessorName, &size_pPrintProcessorName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrintProcessorName, &length_pPrintProcessorName_1));
		if (length_pPrintProcessorName_1 > size_pPrintProcessorName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrintProcessorName_1, length_pPrintProcessorName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrintProcessorName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrintProcessorName, length_pPrintProcessorName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddPrintProcessor(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddPrintProcessor *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddPrintProcessor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddPrintProcessor");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth--;
		ndr_print_ptr(ndr, "pPathName", r->in.pPathName);
		ndr->depth++;
		ndr_print_string(ndr, "pPathName", r->in.pPathName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrintProcessorName", r->in.pPrintProcessorName);
		ndr->depth++;
		ndr_print_string(ndr, "pPrintProcessorName", r->in.pPrintProcessorName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddPrintProcessor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPrintProcessors(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrintProcessors *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrintProcessorInfo));
		if (r->in.pPrintProcessorInfo) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pPrintProcessorInfo, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pPrintProcessorInfo));
		if (r->out.pPrintProcessorInfo) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pPrintProcessorInfo, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPrintProcessors(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrintProcessors *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t _ptr_pPrintProcessorInfo;
	uint32_t size_pPrintProcessorInfo_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	TALLOC_CTX *_mem_save_pPrintProcessorInfo_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrintProcessorInfo));
		if (_ptr_pPrintProcessorInfo) {
			NDR_PULL_ALLOC(ndr, r->in.pPrintProcessorInfo);
		} else {
			r->in.pPrintProcessorInfo = NULL;
		}
		if (r->in.pPrintProcessorInfo) {
			_mem_save_pPrintProcessorInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrintProcessorInfo, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrintProcessorInfo));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pPrintProcessorInfo, &size_pPrintProcessorInfo_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pPrintProcessorInfo, size_pPrintProcessorInfo_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pPrintProcessorInfo, size_pPrintProcessorInfo_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrintProcessorInfo_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pPrintProcessorInfo) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pPrintProcessorInfo, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrintProcessorInfo));
		if (_ptr_pPrintProcessorInfo) {
			NDR_PULL_ALLOC(ndr, r->out.pPrintProcessorInfo);
		} else {
			r->out.pPrintProcessorInfo = NULL;
		}
		if (r->out.pPrintProcessorInfo) {
			_mem_save_pPrintProcessorInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pPrintProcessorInfo, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pPrintProcessorInfo));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pPrintProcessorInfo, &size_pPrintProcessorInfo_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pPrintProcessorInfo, size_pPrintProcessorInfo_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pPrintProcessorInfo, size_pPrintProcessorInfo_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrintProcessorInfo_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pPrintProcessorInfo) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pPrintProcessorInfo, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrintProcessors(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrintProcessors *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrintProcessors");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrintProcessors");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pPrintProcessorInfo", r->in.pPrintProcessorInfo);
		ndr->depth++;
		if (r->in.pPrintProcessorInfo) {
			ndr_print_array_uint8(ndr, "pPrintProcessorInfo", r->in.pPrintProcessorInfo, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrintProcessors");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPrintProcessorInfo", r->out.pPrintProcessorInfo);
		ndr->depth++;
		if (r->out.pPrintProcessorInfo) {
			ndr_print_array_uint8(ndr, "pPrintProcessorInfo", r->out.pPrintProcessorInfo, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetPrintProcessorDirectory(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrintProcessorDirectory *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrintProcessorDirectory));
		if (r->in.pPrintProcessorDirectory) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pPrintProcessorDirectory, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pPrintProcessorDirectory));
		if (r->out.pPrintProcessorDirectory) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pPrintProcessorDirectory, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetPrintProcessorDirectory(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrintProcessorDirectory *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t _ptr_pPrintProcessorDirectory;
	uint32_t size_pPrintProcessorDirectory_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	TALLOC_CTX *_mem_save_pPrintProcessorDirectory_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrintProcessorDirectory));
		if (_ptr_pPrintProcessorDirectory) {
			NDR_PULL_ALLOC(ndr, r->in.pPrintProcessorDirectory);
		} else {
			r->in.pPrintProcessorDirectory = NULL;
		}
		if (r->in.pPrintProcessorDirectory) {
			_mem_save_pPrintProcessorDirectory_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrintProcessorDirectory, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrintProcessorDirectory));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pPrintProcessorDirectory, &size_pPrintProcessorDirectory_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pPrintProcessorDirectory, size_pPrintProcessorDirectory_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pPrintProcessorDirectory, size_pPrintProcessorDirectory_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrintProcessorDirectory_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		if (r->in.pPrintProcessorDirectory) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pPrintProcessorDirectory, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrintProcessorDirectory));
		if (_ptr_pPrintProcessorDirectory) {
			NDR_PULL_ALLOC(ndr, r->out.pPrintProcessorDirectory);
		} else {
			r->out.pPrintProcessorDirectory = NULL;
		}
		if (r->out.pPrintProcessorDirectory) {
			_mem_save_pPrintProcessorDirectory_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pPrintProcessorDirectory, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pPrintProcessorDirectory));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pPrintProcessorDirectory, &size_pPrintProcessorDirectory_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pPrintProcessorDirectory, size_pPrintProcessorDirectory_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pPrintProcessorDirectory, size_pPrintProcessorDirectory_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrintProcessorDirectory_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pPrintProcessorDirectory) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pPrintProcessorDirectory, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrintProcessorDirectory(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrintProcessorDirectory *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrintProcessorDirectory");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrintProcessorDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pPrintProcessorDirectory", r->in.pPrintProcessorDirectory);
		ndr->depth++;
		if (r->in.pPrintProcessorDirectory) {
			ndr_print_array_uint8(ndr, "pPrintProcessorDirectory", r->in.pPrintProcessorDirectory, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrintProcessorDirectory");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPrintProcessorDirectory", r->out.pPrintProcessorDirectory);
		ndr->depth++;
		if (r->out.pPrintProcessorDirectory) {
			ndr_print_array_uint8(ndr, "pPrintProcessorDirectory", r->out.pPrintProcessorDirectory, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPorts(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPorts *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPort));
		if (r->in.pPort) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pPort, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pPort));
		if (r->out.pPort) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pPort, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPorts(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPorts *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pPort;
	uint32_t size_pPort_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pPort_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPort));
		if (_ptr_pPort) {
			NDR_PULL_ALLOC(ndr, r->in.pPort);
		} else {
			r->in.pPort = NULL;
		}
		if (r->in.pPort) {
			_mem_save_pPort_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPort, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPort));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pPort, &size_pPort_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pPort, size_pPort_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pPort, size_pPort_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPort_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pPort) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pPort, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPort));
		if (_ptr_pPort) {
			NDR_PULL_ALLOC(ndr, r->out.pPort);
		} else {
			r->out.pPort = NULL;
		}
		if (r->out.pPort) {
			_mem_save_pPort_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pPort, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pPort));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pPort, &size_pPort_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pPort, size_pPort_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pPort, size_pPort_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPort_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pPort) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pPort, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPorts(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPorts *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPorts");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPorts");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pPort", r->in.pPort);
		ndr->depth++;
		if (r->in.pPort) {
			ndr_print_array_uint8(ndr, "pPort", r->in.pPort, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPorts");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPort", r->out.pPort);
		ndr->depth++;
		if (r->out.pPort) {
			ndr_print_array_uint8(ndr, "pPort", r->out.pPort, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumMonitors(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumMonitors *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pMonitor));
		if (r->in.pMonitor) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pMonitor, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pMonitor));
		if (r->out.pMonitor) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pMonitor, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumMonitors(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumMonitors *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pMonitor;
	uint32_t size_pMonitor_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pMonitor_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pMonitor));
		if (_ptr_pMonitor) {
			NDR_PULL_ALLOC(ndr, r->in.pMonitor);
		} else {
			r->in.pMonitor = NULL;
		}
		if (r->in.pMonitor) {
			_mem_save_pMonitor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pMonitor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pMonitor));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pMonitor, &size_pMonitor_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pMonitor, size_pMonitor_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pMonitor, size_pMonitor_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pMonitor_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pMonitor) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pMonitor, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pMonitor));
		if (_ptr_pMonitor) {
			NDR_PULL_ALLOC(ndr, r->out.pMonitor);
		} else {
			r->out.pMonitor = NULL;
		}
		if (r->out.pMonitor) {
			_mem_save_pMonitor_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pMonitor, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pMonitor));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pMonitor, &size_pMonitor_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pMonitor, size_pMonitor_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pMonitor, size_pMonitor_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pMonitor_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pMonitor) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pMonitor, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumMonitors(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumMonitors *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumMonitors");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumMonitors");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pMonitor", r->in.pMonitor);
		ndr->depth++;
		if (r->in.pMonitor) {
			ndr_print_array_uint8(ndr, "pMonitor", r->in.pMonitor, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumMonitors");
		ndr->depth++;
		ndr_print_ptr(ndr, "pMonitor", r->out.pMonitor);
		ndr->depth++;
		if (r->out.pMonitor) {
			ndr_print_array_uint8(ndr, "pMonitor", r->out.pMonitor, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddPort(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddPort *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPortContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pPortVarContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pMonitorName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_SetPortInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPortContainer));
		NDR_CHECK(ndr_push_spoolss_PortVarContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPortVarContainer));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pMonitorName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pMonitorName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pMonitorName, ndr_charset_length(r->in.pMonitorName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddPort(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddPort *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t size_pMonitorName_1 = 0;
	uint32_t length_pMonitorName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pPortContainer_0 = NULL;
	TALLOC_CTX *_mem_save_pPortVarContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pPortContainer);
		}
		_mem_save_pPortContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pPortContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_SetPortInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPortContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPortContainer_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pPortVarContainer);
		}
		_mem_save_pPortVarContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pPortVarContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PortVarContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPortVarContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPortVarContainer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pMonitorName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pMonitorName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pMonitorName, &size_pMonitorName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pMonitorName, &length_pMonitorName_1));
		if (length_pMonitorName_1 > size_pMonitorName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pMonitorName_1, length_pMonitorName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pMonitorName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pMonitorName, length_pMonitorName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pPortContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pPortContainer);
			NDR_ZERO_STRUCTP(r->in.pPortContainer);
		}
		if (r->in.pPortVarContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pPortVarContainer);
			NDR_ZERO_STRUCTP(r->in.pPortVarContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddPort(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddPort *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddPort");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddPort");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPortContainer", r->in.pPortContainer);
		ndr->depth++;
		ndr_print_spoolss_SetPortInfoContainer(ndr, "pPortContainer", r->in.pPortContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pPortVarContainer", r->in.pPortVarContainer);
		ndr->depth++;
		ndr_print_spoolss_PortVarContainer(ndr, "pPortVarContainer", r->in.pPortVarContainer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pMonitorName", r->in.pMonitorName);
		ndr->depth++;
		ndr_print_string(ndr, "pMonitorName", r->in.pMonitorName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddPort");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncSetPort(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetPort *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPortContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPortName));
		if (r->in.pPortName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPortName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPortName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPortName, ndr_charset_length(r->in.pPortName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_SetPortInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPortContainer));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncSetPort(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetPort *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pPortName;
	uint32_t size_pPortName_1 = 0;
	uint32_t length_pPortName_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pPortName_0 = NULL;
	TALLOC_CTX *_mem_save_pPortContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPortName));
		if (_ptr_pPortName) {
			NDR_PULL_ALLOC(ndr, r->in.pPortName);
		} else {
			r->in.pPortName = NULL;
		}
		if (r->in.pPortName) {
			_mem_save_pPortName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPortName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPortName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPortName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPortName, &size_pPortName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPortName, &length_pPortName_1));
			if (length_pPortName_1 > size_pPortName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPortName_1, length_pPortName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pPortName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPortName, length_pPortName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPortName_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pPortContainer);
		}
		_mem_save_pPortContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pPortContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_SetPortInfoContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pPortContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPortContainer_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pPortContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pPortContainer);
			NDR_ZERO_STRUCTP(r->in.pPortContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetPort(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetPort *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetPort");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetPort");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPortName", r->in.pPortName);
		ndr->depth++;
		if (r->in.pPortName) {
			ndr_print_string(ndr, "pPortName", r->in.pPortName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPortContainer", r->in.pPortContainer);
		ndr->depth++;
		ndr_print_spoolss_SetPortInfoContainer(ndr, "pPortContainer", r->in.pPortContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetPort");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddMonitor(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddMonitor *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pMonitorContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Name));
		if (r->in.Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Name, ndr_charset_length(r->in.Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_MonitorContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pMonitorContainer));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddMonitor(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddMonitor *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	TALLOC_CTX *_mem_save_pMonitorContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->in.Name);
		} else {
			r->in.Name = NULL;
		}
		if (r->in.Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pMonitorContainer);
		}
		_mem_save_pMonitorContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pMonitorContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_MonitorContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pMonitorContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pMonitorContainer_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pMonitorContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pMonitorContainer);
			NDR_ZERO_STRUCTP(r->in.pMonitorContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddMonitor(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddMonitor *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddMonitor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddMonitor");
		ndr->depth++;
		ndr_print_ptr(ndr, "Name", r->in.Name);
		ndr->depth++;
		if (r->in.Name) {
			ndr_print_string(ndr, "Name", r->in.Name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pMonitorContainer", r->in.pMonitorContainer);
		ndr->depth++;
		ndr_print_spoolss_MonitorContainer(ndr, "pMonitorContainer", r->in.pMonitorContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddMonitor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeleteMonitor(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeleteMonitor *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pMonitorName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Name));
		if (r->in.Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Name, ndr_charset_length(r->in.Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pMonitorName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pMonitorName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pMonitorName, ndr_charset_length(r->in.pMonitorName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeleteMonitor(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeleteMonitor *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t size_pMonitorName_1 = 0;
	uint32_t length_pMonitorName_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->in.Name);
		} else {
			r->in.Name = NULL;
		}
		if (r->in.Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pMonitorName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pMonitorName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pMonitorName, &size_pMonitorName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pMonitorName, &length_pMonitorName_1));
		if (length_pMonitorName_1 > size_pMonitorName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pMonitorName_1, length_pMonitorName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pMonitorName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pMonitorName, length_pMonitorName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeleteMonitor(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeleteMonitor *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeleteMonitor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeleteMonitor");
		ndr->depth++;
		ndr_print_ptr(ndr, "Name", r->in.Name);
		ndr->depth++;
		if (r->in.Name) {
			ndr_print_string(ndr, "Name", r->in.Name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pMonitorName", r->in.pMonitorName);
		ndr->depth++;
		ndr_print_string(ndr, "pMonitorName", r->in.pMonitorName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeleteMonitor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrintProcessor(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrintProcessor *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPrintProcessorName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Name));
		if (r->in.Name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Name, ndr_charset_length(r->in.Name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pEnvironment));
		if (r->in.pEnvironment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pEnvironment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pEnvironment, ndr_charset_length(r->in.pEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrintProcessorName, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrintProcessor(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrintProcessor *r)
{
	uint32_t _ptr_Name;
	uint32_t size_Name_1 = 0;
	uint32_t length_Name_1 = 0;
	uint32_t _ptr_pEnvironment;
	uint32_t size_pEnvironment_1 = 0;
	uint32_t length_pEnvironment_1 = 0;
	uint32_t size_pPrintProcessorName_1 = 0;
	uint32_t length_pPrintProcessorName_1 = 0;
	TALLOC_CTX *_mem_save_Name_0 = NULL;
	TALLOC_CTX *_mem_save_pEnvironment_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Name));
		if (_ptr_Name) {
			NDR_PULL_ALLOC(ndr, r->in.Name);
		} else {
			r->in.Name = NULL;
		}
		if (r->in.Name) {
			_mem_save_Name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.Name, &size_Name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.Name, &length_Name_1));
			if (length_Name_1 > size_Name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Name_1, length_Name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Name, length_Name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pEnvironment));
		if (_ptr_pEnvironment) {
			NDR_PULL_ALLOC(ndr, r->in.pEnvironment);
		} else {
			r->in.pEnvironment = NULL;
		}
		if (r->in.pEnvironment) {
			_mem_save_pEnvironment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pEnvironment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pEnvironment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pEnvironment, &size_pEnvironment_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pEnvironment, &length_pEnvironment_1));
			if (length_pEnvironment_1 > size_pEnvironment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pEnvironment_1, length_pEnvironment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pEnvironment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pEnvironment, length_pEnvironment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pEnvironment_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrintProcessorName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrintProcessorName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrintProcessorName, &size_pPrintProcessorName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrintProcessorName, &length_pPrintProcessorName_1));
		if (length_pPrintProcessorName_1 > size_pPrintProcessorName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrintProcessorName_1, length_pPrintProcessorName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrintProcessorName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrintProcessorName, length_pPrintProcessorName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrintProcessor(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrintProcessor *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrintProcessor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrintProcessor");
		ndr->depth++;
		ndr_print_ptr(ndr, "Name", r->in.Name);
		ndr->depth++;
		if (r->in.Name) {
			ndr_print_string(ndr, "Name", r->in.Name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pEnvironment", r->in.pEnvironment);
		ndr->depth++;
		if (r->in.pEnvironment) {
			ndr_print_string(ndr, "pEnvironment", r->in.pEnvironment);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrintProcessorName", r->in.pPrintProcessorName);
		ndr->depth++;
		ndr_print_string(ndr, "pPrintProcessorName", r->in.pPrintProcessorName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrintProcessor");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPrintProcessorDatatypes(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPrintProcessorDatatypes *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pName));
		if (r->in.pName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pName, ndr_charset_length(r->in.pName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrintProcessorName));
		if (r->in.pPrintProcessorName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrintProcessorName, ndr_charset_length(r->in.pPrintProcessorName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDatatypes));
		if (r->in.pDatatypes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pDatatypes, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pDatatypes));
		if (r->out.pDatatypes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pDatatypes, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPrintProcessorDatatypes(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPrintProcessorDatatypes *r)
{
	uint32_t _ptr_pName;
	uint32_t size_pName_1 = 0;
	uint32_t length_pName_1 = 0;
	uint32_t _ptr_pPrintProcessorName;
	uint32_t size_pPrintProcessorName_1 = 0;
	uint32_t length_pPrintProcessorName_1 = 0;
	uint32_t _ptr_pDatatypes;
	uint32_t size_pDatatypes_1 = 0;
	TALLOC_CTX *_mem_save_pName_0 = NULL;
	TALLOC_CTX *_mem_save_pPrintProcessorName_0 = NULL;
	TALLOC_CTX *_mem_save_pDatatypes_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pName));
		if (_ptr_pName) {
			NDR_PULL_ALLOC(ndr, r->in.pName);
		} else {
			r->in.pName = NULL;
		}
		if (r->in.pName) {
			_mem_save_pName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pName, &size_pName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pName, &length_pName_1));
			if (length_pName_1 > size_pName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pName_1, length_pName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pName, length_pName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrintProcessorName));
		if (_ptr_pPrintProcessorName) {
			NDR_PULL_ALLOC(ndr, r->in.pPrintProcessorName);
		} else {
			r->in.pPrintProcessorName = NULL;
		}
		if (r->in.pPrintProcessorName) {
			_mem_save_pPrintProcessorName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrintProcessorName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrintProcessorName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrintProcessorName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrintProcessorName, &size_pPrintProcessorName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrintProcessorName, &length_pPrintProcessorName_1));
			if (length_pPrintProcessorName_1 > size_pPrintProcessorName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrintProcessorName_1, length_pPrintProcessorName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrintProcessorName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrintProcessorName, length_pPrintProcessorName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrintProcessorName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDatatypes));
		if (_ptr_pDatatypes) {
			NDR_PULL_ALLOC(ndr, r->in.pDatatypes);
		} else {
			r->in.pDatatypes = NULL;
		}
		if (r->in.pDatatypes) {
			_mem_save_pDatatypes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDatatypes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDatatypes));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pDatatypes, &size_pDatatypes_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pDatatypes, size_pDatatypes_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pDatatypes, size_pDatatypes_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDatatypes_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pDatatypes) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pDatatypes, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDatatypes));
		if (_ptr_pDatatypes) {
			NDR_PULL_ALLOC(ndr, r->out.pDatatypes);
		} else {
			r->out.pDatatypes = NULL;
		}
		if (r->out.pDatatypes) {
			_mem_save_pDatatypes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pDatatypes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pDatatypes));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pDatatypes, &size_pDatatypes_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pDatatypes, size_pDatatypes_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pDatatypes, size_pDatatypes_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDatatypes_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pDatatypes) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pDatatypes, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPrintProcessorDatatypes(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPrintProcessorDatatypes *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPrintProcessorDatatypes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPrintProcessorDatatypes");
		ndr->depth++;
		ndr_print_ptr(ndr, "pName", r->in.pName);
		ndr->depth++;
		if (r->in.pName) {
			ndr_print_string(ndr, "pName", r->in.pName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrintProcessorName", r->in.pPrintProcessorName);
		ndr->depth++;
		if (r->in.pPrintProcessorName) {
			ndr_print_string(ndr, "pPrintProcessorName", r->in.pPrintProcessorName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "Level", r->in.Level);
		ndr_print_ptr(ndr, "pDatatypes", r->in.pDatatypes);
		ndr->depth++;
		if (r->in.pDatatypes) {
			ndr_print_array_uint8(ndr, "pDatatypes", r->in.pDatatypes, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPrintProcessorDatatypes");
		ndr->depth++;
		ndr_print_ptr(ndr, "pDatatypes", r->out.pDatatypes);
		ndr->depth++;
		if (r->out.pDatatypes) {
			ndr_print_array_uint8(ndr, "pDatatypes", r->out.pDatatypes, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncAddPerMachineConnection(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncAddPerMachineConnection *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPrinterName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pPrintServer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pProvider == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pServer));
		if (r->in.pServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pServer, ndr_charset_length(r->in.pServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrinterName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrinterName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrinterName, ndr_charset_length(r->in.pPrinterName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintServer, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrintServer, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrintServer, ndr_charset_length(r->in.pPrintServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pProvider, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pProvider, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pProvider, ndr_charset_length(r->in.pProvider, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncAddPerMachineConnection(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncAddPerMachineConnection *r)
{
	uint32_t _ptr_pServer;
	uint32_t size_pServer_1 = 0;
	uint32_t length_pServer_1 = 0;
	uint32_t size_pPrinterName_1 = 0;
	uint32_t length_pPrinterName_1 = 0;
	uint32_t size_pPrintServer_1 = 0;
	uint32_t length_pPrintServer_1 = 0;
	uint32_t size_pProvider_1 = 0;
	uint32_t length_pProvider_1 = 0;
	TALLOC_CTX *_mem_save_pServer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pServer));
		if (_ptr_pServer) {
			NDR_PULL_ALLOC(ndr, r->in.pServer);
		} else {
			r->in.pServer = NULL;
		}
		if (r->in.pServer) {
			_mem_save_pServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pServer, &size_pServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pServer, &length_pServer_1));
			if (length_pServer_1 > size_pServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pServer_1, length_pServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pServer, length_pServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrinterName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrinterName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrinterName, &size_pPrinterName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrinterName, &length_pPrinterName_1));
		if (length_pPrinterName_1 > size_pPrinterName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrinterName_1, length_pPrinterName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrinterName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrinterName, length_pPrinterName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrintServer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrintServer));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrintServer, &size_pPrintServer_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrintServer, &length_pPrintServer_1));
		if (length_pPrintServer_1 > size_pPrintServer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrintServer_1, length_pPrintServer_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrintServer_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrintServer, length_pPrintServer_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pProvider));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pProvider));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pProvider, &size_pProvider_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pProvider, &length_pProvider_1));
		if (length_pProvider_1 > size_pProvider_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pProvider_1, length_pProvider_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pProvider_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pProvider, length_pProvider_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncAddPerMachineConnection(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncAddPerMachineConnection *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncAddPerMachineConnection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncAddPerMachineConnection");
		ndr->depth++;
		ndr_print_ptr(ndr, "pServer", r->in.pServer);
		ndr->depth++;
		if (r->in.pServer) {
			ndr_print_string(ndr, "pServer", r->in.pServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrinterName", r->in.pPrinterName);
		ndr->depth++;
		ndr_print_string(ndr, "pPrinterName", r->in.pPrinterName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrintServer", r->in.pPrintServer);
		ndr->depth++;
		ndr_print_string(ndr, "pPrintServer", r->in.pPrintServer);
		ndr->depth--;
		ndr_print_ptr(ndr, "pProvider", r->in.pProvider);
		ndr->depth++;
		ndr_print_string(ndr, "pProvider", r->in.pProvider);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncAddPerMachineConnection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePerMachineConnection(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePerMachineConnection *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pPrinterName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pServer));
		if (r->in.pServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pServer, ndr_charset_length(r->in.pServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrinterName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pPrinterName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pPrinterName, ndr_charset_length(r->in.pPrinterName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePerMachineConnection(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePerMachineConnection *r)
{
	uint32_t _ptr_pServer;
	uint32_t size_pServer_1 = 0;
	uint32_t length_pServer_1 = 0;
	uint32_t size_pPrinterName_1 = 0;
	uint32_t length_pPrinterName_1 = 0;
	TALLOC_CTX *_mem_save_pServer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pServer));
		if (_ptr_pServer) {
			NDR_PULL_ALLOC(ndr, r->in.pServer);
		} else {
			r->in.pServer = NULL;
		}
		if (r->in.pServer) {
			_mem_save_pServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pServer, &size_pServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pServer, &length_pServer_1));
			if (length_pServer_1 > size_pServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pServer_1, length_pServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pServer, length_pServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrinterName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pPrinterName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pPrinterName, &size_pPrinterName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pPrinterName, &length_pPrinterName_1));
		if (length_pPrinterName_1 > size_pPrinterName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPrinterName_1, length_pPrinterName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pPrinterName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pPrinterName, length_pPrinterName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePerMachineConnection(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePerMachineConnection *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePerMachineConnection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePerMachineConnection");
		ndr->depth++;
		ndr_print_ptr(ndr, "pServer", r->in.pServer);
		ndr->depth++;
		if (r->in.pServer) {
			ndr_print_string(ndr, "pServer", r->in.pServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrinterName", r->in.pPrinterName);
		ndr->depth++;
		ndr_print_string(ndr, "pPrinterName", r->in.pPrinterName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePerMachineConnection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumPerMachineConnections(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumPerMachineConnections *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pServer));
		if (r->in.pServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pServer, ndr_charset_length(r->in.pServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pPrinterEnum));
		if (r->in.pPrinterEnum) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.pPrinterEnum, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcbNeeded == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcReturned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pPrinterEnum));
		if (r->out.pPrinterEnum) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pPrinterEnum, r->in.cbBuf));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcbNeeded));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcReturned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumPerMachineConnections(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumPerMachineConnections *r)
{
	uint32_t _ptr_pServer;
	uint32_t size_pServer_1 = 0;
	uint32_t length_pServer_1 = 0;
	uint32_t _ptr_pPrinterEnum;
	uint32_t size_pPrinterEnum_1 = 0;
	TALLOC_CTX *_mem_save_pServer_0 = NULL;
	TALLOC_CTX *_mem_save_pPrinterEnum_0 = NULL;
	TALLOC_CTX *_mem_save_pcbNeeded_0 = NULL;
	TALLOC_CTX *_mem_save_pcReturned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pServer));
		if (_ptr_pServer) {
			NDR_PULL_ALLOC(ndr, r->in.pServer);
		} else {
			r->in.pServer = NULL;
		}
		if (r->in.pServer) {
			_mem_save_pServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pServer, &size_pServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pServer, &length_pServer_1));
			if (length_pServer_1 > size_pServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pServer_1, length_pServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pServer, length_pServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pServer_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinterEnum));
		if (_ptr_pPrinterEnum) {
			NDR_PULL_ALLOC(ndr, r->in.pPrinterEnum);
		} else {
			r->in.pPrinterEnum = NULL;
		}
		if (r->in.pPrinterEnum) {
			_mem_save_pPrinterEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pPrinterEnum, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pPrinterEnum));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pPrinterEnum, &size_pPrinterEnum_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pPrinterEnum, size_pPrinterEnum_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.pPrinterEnum, size_pPrinterEnum_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterEnum_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		NDR_ZERO_STRUCTP(r->out.pcbNeeded);
		NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		NDR_ZERO_STRUCTP(r->out.pcReturned);
		if (r->in.pPrinterEnum) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pPrinterEnum, r->in.cbBuf));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPrinterEnum));
		if (_ptr_pPrinterEnum) {
			NDR_PULL_ALLOC(ndr, r->out.pPrinterEnum);
		} else {
			r->out.pPrinterEnum = NULL;
		}
		if (r->out.pPrinterEnum) {
			_mem_save_pPrinterEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pPrinterEnum, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pPrinterEnum));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pPrinterEnum, &size_pPrinterEnum_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pPrinterEnum, size_pPrinterEnum_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pPrinterEnum, size_pPrinterEnum_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPrinterEnum_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcbNeeded);
		}
		_mem_save_pcbNeeded_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcbNeeded, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcbNeeded));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcbNeeded_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcReturned);
		}
		_mem_save_pcReturned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcReturned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcReturned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcReturned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pPrinterEnum) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pPrinterEnum, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumPerMachineConnections(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumPerMachineConnections *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncEnumPerMachineConnections");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumPerMachineConnections");
		ndr->depth++;
		ndr_print_ptr(ndr, "pServer", r->in.pServer);
		ndr->depth++;
		if (r->in.pServer) {
			ndr_print_string(ndr, "pServer", r->in.pServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pPrinterEnum", r->in.pPrinterEnum);
		ndr->depth++;
		if (r->in.pPrinterEnum) {
			ndr_print_array_uint8(ndr, "pPrinterEnum", r->in.pPrinterEnum, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumPerMachineConnections");
		ndr->depth++;
		ndr_print_ptr(ndr, "pPrinterEnum", r->out.pPrinterEnum);
		ndr->depth++;
		if (r->out.pPrinterEnum) {
			ndr_print_array_uint8(ndr, "pPrinterEnum", r->out.pPrinterEnum, r->in.cbBuf);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcbNeeded", r->out.pcbNeeded);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcbNeeded", *r->out.pcbNeeded);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcReturned", r->out.pcReturned);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcReturned", *r->out.pcReturned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_SyncRegisterForRemoteNotifications(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_SyncRegisterForRemoteNotifications *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pNotifyFilter == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pNotifyFilter));
	}
	if (flags & NDR_OUT) {
		if (r->out.phRpcHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phRpcHandle));
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_SyncRegisterForRemoteNotifications(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_SyncRegisterForRemoteNotifications *r)
{
	TALLOC_CTX *_mem_save_pNotifyFilter_0 = NULL;
	TALLOC_CTX *_mem_save_phRpcHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pNotifyFilter);
		}
		_mem_save_pNotifyFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pNotifyFilter, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pNotifyFilter));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pNotifyFilter_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.phRpcHandle);
		NDR_ZERO_STRUCTP(r->out.phRpcHandle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pNotifyFilter == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pNotifyFilter);
			NDR_ZERO_STRUCTP(r->in.pNotifyFilter);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phRpcHandle);
		}
		_mem_save_phRpcHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phRpcHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phRpcHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phRpcHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_SyncRegisterForRemoteNotifications(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_SyncRegisterForRemoteNotifications *r)
{
	ndr_print_struct(ndr, name, "winspool_SyncRegisterForRemoteNotifications");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_SyncRegisterForRemoteNotifications");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pNotifyFilter", r->in.pNotifyFilter);
		ndr->depth++;
		ndr_print_winspool_PrintPropertiesCollection(ndr, "pNotifyFilter", r->in.pNotifyFilter);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_SyncRegisterForRemoteNotifications");
		ndr->depth++;
		ndr_print_ptr(ndr, "phRpcHandle", r->out.phRpcHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phRpcHandle", r->out.phRpcHandle);
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_SyncUnRegisterForRemoteNotifications(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_SyncUnRegisterForRemoteNotifications *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.phRpcHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.phRpcHandle));
	}
	if (flags & NDR_OUT) {
		if (r->out.phRpcHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phRpcHandle));
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_SyncUnRegisterForRemoteNotifications(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_SyncUnRegisterForRemoteNotifications *r)
{
	TALLOC_CTX *_mem_save_phRpcHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.phRpcHandle);
		}
		_mem_save_phRpcHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.phRpcHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.phRpcHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phRpcHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.phRpcHandle);
		*r->out.phRpcHandle = *r->in.phRpcHandle;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.phRpcHandle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.phRpcHandle);
			NDR_ZERO_STRUCTP(r->in.phRpcHandle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phRpcHandle);
		}
		_mem_save_phRpcHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phRpcHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phRpcHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phRpcHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_SyncUnRegisterForRemoteNotifications(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_SyncUnRegisterForRemoteNotifications *r)
{
	ndr_print_struct(ndr, name, "winspool_SyncUnRegisterForRemoteNotifications");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_SyncUnRegisterForRemoteNotifications");
		ndr->depth++;
		ndr_print_ptr(ndr, "phRpcHandle", r->in.phRpcHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phRpcHandle", r->in.phRpcHandle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_SyncUnRegisterForRemoteNotifications");
		ndr->depth++;
		ndr_print_ptr(ndr, "phRpcHandle", r->out.phRpcHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phRpcHandle", r->out.phRpcHandle);
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_SyncRefreshRemoteNotifications(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_SyncRefreshRemoteNotifications *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pNotifyFilter == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hRpcHandle));
		NDR_CHECK(ndr_push_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pNotifyFilter));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppNotifyData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppNotifyData));
		if (*r->out.ppNotifyData) {
			NDR_CHECK(ndr_push_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNotifyData));
		}
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_SyncRefreshRemoteNotifications(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_SyncRefreshRemoteNotifications *r)
{
	uint32_t _ptr_ppNotifyData;
	TALLOC_CTX *_mem_save_pNotifyFilter_0 = NULL;
	TALLOC_CTX *_mem_save_ppNotifyData_0 = NULL;
	TALLOC_CTX *_mem_save_ppNotifyData_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hRpcHandle));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pNotifyFilter);
		}
		_mem_save_pNotifyFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pNotifyFilter, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pNotifyFilter));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pNotifyFilter_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ppNotifyData);
		NDR_ZERO_STRUCTP(r->out.ppNotifyData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pNotifyFilter == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pNotifyFilter);
			NDR_ZERO_STRUCTP(r->in.pNotifyFilter);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppNotifyData);
		}
		_mem_save_ppNotifyData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppNotifyData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppNotifyData));
		if (_ptr_ppNotifyData) {
			NDR_PULL_ALLOC(ndr, *r->out.ppNotifyData);
		} else {
			*r->out.ppNotifyData = NULL;
		}
		if (*r->out.ppNotifyData) {
			_mem_save_ppNotifyData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppNotifyData, 0);
			NDR_CHECK(ndr_pull_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNotifyData));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNotifyData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNotifyData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_SyncRefreshRemoteNotifications(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_SyncRefreshRemoteNotifications *r)
{
	ndr_print_struct(ndr, name, "winspool_SyncRefreshRemoteNotifications");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_SyncRefreshRemoteNotifications");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hRpcHandle", &r->in.hRpcHandle);
		ndr_print_ptr(ndr, "pNotifyFilter", r->in.pNotifyFilter);
		ndr->depth++;
		ndr_print_winspool_PrintPropertiesCollection(ndr, "pNotifyFilter", r->in.pNotifyFilter);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_SyncRefreshRemoteNotifications");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNotifyData", r->out.ppNotifyData);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNotifyData", *r->out.ppNotifyData);
		ndr->depth++;
		if (*r->out.ppNotifyData) {
			ndr_print_winspool_PrintPropertiesCollection(ndr, "ppNotifyData", *r->out.ppNotifyData);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetRemoteNotifications(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetRemoteNotifications *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hRpcHandle));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppNotifyData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppNotifyData));
		if (*r->out.ppNotifyData) {
			NDR_CHECK(ndr_push_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNotifyData));
		}
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetRemoteNotifications(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetRemoteNotifications *r)
{
	uint32_t _ptr_ppNotifyData;
	TALLOC_CTX *_mem_save_ppNotifyData_0 = NULL;
	TALLOC_CTX *_mem_save_ppNotifyData_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hRpcHandle));
		NDR_PULL_ALLOC(ndr, r->out.ppNotifyData);
		NDR_ZERO_STRUCTP(r->out.ppNotifyData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppNotifyData);
		}
		_mem_save_ppNotifyData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppNotifyData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppNotifyData));
		if (_ptr_ppNotifyData) {
			NDR_PULL_ALLOC(ndr, *r->out.ppNotifyData);
		} else {
			*r->out.ppNotifyData = NULL;
		}
		if (*r->out.ppNotifyData) {
			_mem_save_ppNotifyData_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppNotifyData, 0);
			NDR_CHECK(ndr_pull_winspool_PrintPropertiesCollection(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.ppNotifyData));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNotifyData_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNotifyData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetRemoteNotifications(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetRemoteNotifications *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetRemoteNotifications");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetRemoteNotifications");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hRpcHandle", &r->in.hRpcHandle);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetRemoteNotifications");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNotifyData", r->out.ppNotifyData);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNotifyData", *r->out.ppNotifyData);
		ndr->depth++;
		if (*r->out.ppNotifyData) {
			ndr_print_winspool_PrintPropertiesCollection(ndr, "ppNotifyData", *r->out.ppNotifyData);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncInstallPrinterDriverFromPackage(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncInstallPrinterDriverFromPackage *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszDriverName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pszEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszServer));
		if (r->in.pszServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszServer, ndr_charset_length(r->in.pszServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszInfPath));
		if (r->in.pszInfPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszInfPath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszInfPath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszInfPath, ndr_charset_length(r->in.pszInfPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszDriverName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszDriverName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszDriverName, ndr_charset_length(r->in.pszDriverName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszEnvironment, ndr_charset_length(r->in.pszEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_winspool_InstallPrinterDriverFromPackageFlags(ndr, NDR_SCALARS, r->in.dwFlags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncInstallPrinterDriverFromPackage(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncInstallPrinterDriverFromPackage *r)
{
	uint32_t _ptr_pszServer;
	uint32_t size_pszServer_1 = 0;
	uint32_t length_pszServer_1 = 0;
	uint32_t _ptr_pszInfPath;
	uint32_t size_pszInfPath_1 = 0;
	uint32_t length_pszInfPath_1 = 0;
	uint32_t size_pszDriverName_1 = 0;
	uint32_t length_pszDriverName_1 = 0;
	uint32_t size_pszEnvironment_1 = 0;
	uint32_t length_pszEnvironment_1 = 0;
	TALLOC_CTX *_mem_save_pszServer_0 = NULL;
	TALLOC_CTX *_mem_save_pszInfPath_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServer));
		if (_ptr_pszServer) {
			NDR_PULL_ALLOC(ndr, r->in.pszServer);
		} else {
			r->in.pszServer = NULL;
		}
		if (r->in.pszServer) {
			_mem_save_pszServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszServer, &size_pszServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszServer, &length_pszServer_1));
			if (length_pszServer_1 > size_pszServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServer_1, length_pszServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszServer, length_pszServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServer_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszInfPath));
		if (_ptr_pszInfPath) {
			NDR_PULL_ALLOC(ndr, r->in.pszInfPath);
		} else {
			r->in.pszInfPath = NULL;
		}
		if (r->in.pszInfPath) {
			_mem_save_pszInfPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszInfPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszInfPath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszInfPath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszInfPath, &size_pszInfPath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszInfPath, &length_pszInfPath_1));
			if (length_pszInfPath_1 > size_pszInfPath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszInfPath_1, length_pszInfPath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszInfPath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszInfPath, length_pszInfPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszInfPath_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszDriverName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszDriverName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszDriverName, &size_pszDriverName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszDriverName, &length_pszDriverName_1));
		if (length_pszDriverName_1 > size_pszDriverName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDriverName_1, length_pszDriverName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDriverName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszDriverName, length_pszDriverName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszEnvironment, &size_pszEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszEnvironment, &length_pszEnvironment_1));
		if (length_pszEnvironment_1 > size_pszEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszEnvironment_1, length_pszEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszEnvironment, length_pszEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_winspool_InstallPrinterDriverFromPackageFlags(ndr, NDR_SCALARS, &r->in.dwFlags));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncInstallPrinterDriverFromPackage(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncInstallPrinterDriverFromPackage *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncInstallPrinterDriverFromPackage");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncInstallPrinterDriverFromPackage");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszServer", r->in.pszServer);
		ndr->depth++;
		if (r->in.pszServer) {
			ndr_print_string(ndr, "pszServer", r->in.pszServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszInfPath", r->in.pszInfPath);
		ndr->depth++;
		if (r->in.pszInfPath) {
			ndr_print_string(ndr, "pszInfPath", r->in.pszInfPath);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszDriverName", r->in.pszDriverName);
		ndr->depth++;
		ndr_print_string(ndr, "pszDriverName", r->in.pszDriverName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth--;
		ndr_print_winspool_InstallPrinterDriverFromPackageFlags(ndr, "dwFlags", r->in.dwFlags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncInstallPrinterDriverFromPackage");
		ndr->depth++;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncUploadPrinterDriverPackage(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncUploadPrinterDriverPackage *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszInfPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pszEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pcchDestInfPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszServer));
		if (r->in.pszServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszServer, ndr_charset_length(r->in.pszServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszInfPath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszInfPath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszInfPath, ndr_charset_length(r->in.pszInfPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszEnvironment, ndr_charset_length(r->in.pszEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_winspool_UploadPrinterDriverPackageFlags(ndr, NDR_SCALARS, r->in.dwFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszDestInfPath));
		if (r->in.pszDestInfPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->in.pcchDestInfPath));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszDestInfPath, *r->in.pcchDestInfPath, sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.pcchDestInfPath));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcchDestInfPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pszDestInfPath));
		if (r->out.pszDestInfPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.pcchDestInfPath));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->out.pszDestInfPath, *r->out.pcchDestInfPath, sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcchDestInfPath));
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncUploadPrinterDriverPackage(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncUploadPrinterDriverPackage *r)
{
	uint32_t _ptr_pszServer;
	uint32_t size_pszServer_1 = 0;
	uint32_t length_pszServer_1 = 0;
	uint32_t size_pszInfPath_1 = 0;
	uint32_t length_pszInfPath_1 = 0;
	uint32_t size_pszEnvironment_1 = 0;
	uint32_t length_pszEnvironment_1 = 0;
	uint32_t _ptr_pszDestInfPath;
	uint32_t size_pszDestInfPath_1 = 0;
	TALLOC_CTX *_mem_save_pszServer_0 = NULL;
	TALLOC_CTX *_mem_save_pszDestInfPath_0 = NULL;
	TALLOC_CTX *_mem_save_pcchDestInfPath_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServer));
		if (_ptr_pszServer) {
			NDR_PULL_ALLOC(ndr, r->in.pszServer);
		} else {
			r->in.pszServer = NULL;
		}
		if (r->in.pszServer) {
			_mem_save_pszServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszServer, &size_pszServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszServer, &length_pszServer_1));
			if (length_pszServer_1 > size_pszServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServer_1, length_pszServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszServer, length_pszServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszInfPath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszInfPath));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszInfPath, &size_pszInfPath_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszInfPath, &length_pszInfPath_1));
		if (length_pszInfPath_1 > size_pszInfPath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszInfPath_1, length_pszInfPath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszInfPath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszInfPath, length_pszInfPath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszEnvironment, &size_pszEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszEnvironment, &length_pszEnvironment_1));
		if (length_pszEnvironment_1 > size_pszEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszEnvironment_1, length_pszEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszEnvironment, length_pszEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_winspool_UploadPrinterDriverPackageFlags(ndr, NDR_SCALARS, &r->in.dwFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDestInfPath));
		if (_ptr_pszDestInfPath) {
			NDR_PULL_ALLOC(ndr, r->in.pszDestInfPath);
		} else {
			r->in.pszDestInfPath = NULL;
		}
		if (r->in.pszDestInfPath) {
			_mem_save_pszDestInfPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszDestInfPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszDestInfPath));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pszDestInfPath, &size_pszDestInfPath_1));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszDestInfPath, size_pszDestInfPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDestInfPath_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pcchDestInfPath);
		}
		_mem_save_pcchDestInfPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pcchDestInfPath, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.pcchDestInfPath));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcchDestInfPath_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pcchDestInfPath);
		*r->out.pcchDestInfPath = *r->in.pcchDestInfPath;
		if (r->in.pszDestInfPath) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pszDestInfPath, *r->in.pcchDestInfPath));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pcchDestInfPath == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pcchDestInfPath);
			NDR_ZERO_STRUCTP(r->in.pcchDestInfPath);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDestInfPath));
		if (_ptr_pszDestInfPath) {
			NDR_PULL_ALLOC(ndr, r->out.pszDestInfPath);
		} else {
			r->out.pszDestInfPath = NULL;
		}
		if (r->out.pszDestInfPath) {
			_mem_save_pszDestInfPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pszDestInfPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pszDestInfPath));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pszDestInfPath, &size_pszDestInfPath_1));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->out.pszDestInfPath, size_pszDestInfPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDestInfPath_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcchDestInfPath);
		}
		_mem_save_pcchDestInfPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcchDestInfPath, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcchDestInfPath));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcchDestInfPath_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pszDestInfPath) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pszDestInfPath, *r->out.pcchDestInfPath));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncUploadPrinterDriverPackage(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncUploadPrinterDriverPackage *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncUploadPrinterDriverPackage");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncUploadPrinterDriverPackage");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszServer", r->in.pszServer);
		ndr->depth++;
		if (r->in.pszServer) {
			ndr_print_string(ndr, "pszServer", r->in.pszServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszInfPath", r->in.pszInfPath);
		ndr->depth++;
		ndr_print_string(ndr, "pszInfPath", r->in.pszInfPath);
		ndr->depth--;
		ndr_print_ptr(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth--;
		ndr_print_winspool_UploadPrinterDriverPackageFlags(ndr, "dwFlags", r->in.dwFlags);
		ndr_print_ptr(ndr, "pszDestInfPath", r->in.pszDestInfPath);
		ndr->depth++;
		if (r->in.pszDestInfPath) {
			ndr_print_string(ndr, "pszDestInfPath", r->in.pszDestInfPath);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcchDestInfPath", r->in.pcchDestInfPath);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcchDestInfPath", *r->in.pcchDestInfPath);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncUploadPrinterDriverPackage");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszDestInfPath", r->out.pszDestInfPath);
		ndr->depth++;
		if (r->out.pszDestInfPath) {
			ndr_print_string(ndr, "pszDestInfPath", r->out.pszDestInfPath);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcchDestInfPath", r->out.pcchDestInfPath);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcchDestInfPath", *r->out.pcchDestInfPath);
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncGetCorePrinterDrivers(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetCorePrinterDrivers *r)
{
	uint32_t cntr_pszzCoreDriverDependencies_1;
	uint32_t cntr_pCorePrinterDrivers_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pszzCoreDriverDependencies == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszServer));
		if (r->in.pszServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszServer, ndr_charset_length(r->in.pszServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszEnvironment, ndr_charset_length(r->in.pszEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cchCoreDrivers));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cchCoreDrivers));
		for (cntr_pszzCoreDriverDependencies_1 = 0; cntr_pszzCoreDriverDependencies_1 < (r->in.cchCoreDrivers); cntr_pszzCoreDriverDependencies_1++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.pszzCoreDriverDependencies[cntr_pszzCoreDriverDependencies_1]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cCorePrinterDrivers));
	}
	if (flags & NDR_OUT) {
		if (r->out.pCorePrinterDrivers == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cCorePrinterDrivers));
		for (cntr_pCorePrinterDrivers_1 = 0; cntr_pCorePrinterDrivers_1 < (r->in.cCorePrinterDrivers); cntr_pCorePrinterDrivers_1++) {
			NDR_CHECK(ndr_push_spoolss_CorePrinterDriver(ndr, NDR_SCALARS, &r->out.pCorePrinterDrivers[cntr_pCorePrinterDrivers_1]));
		}
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncGetCorePrinterDrivers(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetCorePrinterDrivers *r)
{
	uint32_t _ptr_pszServer;
	uint32_t size_pszServer_1 = 0;
	uint32_t length_pszServer_1 = 0;
	uint32_t size_pszEnvironment_1 = 0;
	uint32_t length_pszEnvironment_1 = 0;
	uint32_t size_pszzCoreDriverDependencies_1 = 0;
	uint32_t cntr_pszzCoreDriverDependencies_1;
	uint32_t size_pCorePrinterDrivers_1 = 0;
	uint32_t cntr_pCorePrinterDrivers_1;
	TALLOC_CTX *_mem_save_pszServer_0 = NULL;
	TALLOC_CTX *_mem_save_pszzCoreDriverDependencies_1 = NULL;
	TALLOC_CTX *_mem_save_pCorePrinterDrivers_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServer));
		if (_ptr_pszServer) {
			NDR_PULL_ALLOC(ndr, r->in.pszServer);
		} else {
			r->in.pszServer = NULL;
		}
		if (r->in.pszServer) {
			_mem_save_pszServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszServer, &size_pszServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszServer, &length_pszServer_1));
			if (length_pszServer_1 > size_pszServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServer_1, length_pszServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszServer, length_pszServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszEnvironment, &size_pszEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszEnvironment, &length_pszEnvironment_1));
		if (length_pszEnvironment_1 > size_pszEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszEnvironment_1, length_pszEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszEnvironment, length_pszEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cchCoreDrivers));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszzCoreDriverDependencies));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pszzCoreDriverDependencies, &size_pszzCoreDriverDependencies_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pszzCoreDriverDependencies, size_pszzCoreDriverDependencies_1);
		}
		_mem_save_pszzCoreDriverDependencies_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pszzCoreDriverDependencies, 0);
		for (cntr_pszzCoreDriverDependencies_1 = 0; cntr_pszzCoreDriverDependencies_1 < (size_pszzCoreDriverDependencies_1); cntr_pszzCoreDriverDependencies_1++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.pszzCoreDriverDependencies[cntr_pszzCoreDriverDependencies_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszzCoreDriverDependencies_1, 0);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cCorePrinterDrivers));
		NDR_PULL_ALLOC_N(ndr, r->out.pCorePrinterDrivers, r->in.cCorePrinterDrivers);
		memset(r->out.pCorePrinterDrivers, 0, (r->in.cCorePrinterDrivers) * sizeof(*r->out.pCorePrinterDrivers));
		if (r->in.pszzCoreDriverDependencies) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pszzCoreDriverDependencies, r->in.cchCoreDrivers));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pCorePrinterDrivers));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pCorePrinterDrivers, &size_pCorePrinterDrivers_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pCorePrinterDrivers, size_pCorePrinterDrivers_1);
		}
		_mem_save_pCorePrinterDrivers_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pCorePrinterDrivers, 0);
		for (cntr_pCorePrinterDrivers_1 = 0; cntr_pCorePrinterDrivers_1 < (size_pCorePrinterDrivers_1); cntr_pCorePrinterDrivers_1++) {
			NDR_CHECK(ndr_pull_spoolss_CorePrinterDriver(ndr, NDR_SCALARS, &r->out.pCorePrinterDrivers[cntr_pCorePrinterDrivers_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pCorePrinterDrivers_1, 0);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pCorePrinterDrivers) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pCorePrinterDrivers, r->in.cCorePrinterDrivers));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetCorePrinterDrivers(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetCorePrinterDrivers *r)
{
	uint32_t cntr_pszzCoreDriverDependencies_1;
	uint32_t cntr_pCorePrinterDrivers_1;
	ndr_print_struct(ndr, name, "winspool_AsyncGetCorePrinterDrivers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetCorePrinterDrivers");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszServer", r->in.pszServer);
		ndr->depth++;
		if (r->in.pszServer) {
			ndr_print_string(ndr, "pszServer", r->in.pszServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth--;
		ndr_print_uint32(ndr, "cchCoreDrivers", r->in.cchCoreDrivers);
		ndr_print_ptr(ndr, "pszzCoreDriverDependencies", r->in.pszzCoreDriverDependencies);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pszzCoreDriverDependencies", (uint32_t)(r->in.cchCoreDrivers));
		ndr->depth++;
		for (cntr_pszzCoreDriverDependencies_1 = 0; cntr_pszzCoreDriverDependencies_1 < (r->in.cchCoreDrivers); cntr_pszzCoreDriverDependencies_1++) {
			ndr_print_uint16(ndr, "pszzCoreDriverDependencies", r->in.pszzCoreDriverDependencies[cntr_pszzCoreDriverDependencies_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_uint32(ndr, "cCorePrinterDrivers", r->in.cCorePrinterDrivers);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetCorePrinterDrivers");
		ndr->depth++;
		ndr_print_ptr(ndr, "pCorePrinterDrivers", r->out.pCorePrinterDrivers);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pCorePrinterDrivers", (uint32_t)(r->in.cCorePrinterDrivers));
		ndr->depth++;
		for (cntr_pCorePrinterDrivers_1 = 0; cntr_pCorePrinterDrivers_1 < (r->in.cCorePrinterDrivers); cntr_pCorePrinterDrivers_1++) {
			ndr_print_spoolss_CorePrinterDriver(ndr, "pCorePrinterDrivers", &r->out.pCorePrinterDrivers[cntr_pCorePrinterDrivers_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncCorePrinterDriverInstalled(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncCorePrinterDriverInstalled *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszServer));
		if (r->in.pszServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszServer, ndr_charset_length(r->in.pszServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszEnvironment, ndr_charset_length(r->in.pszEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.CoreDriverGUID));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->in.ftDriverDate));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.dwlDriverVersion));
	}
	if (flags & NDR_OUT) {
		if (r->out.pbDriverInstalled == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, *r->out.pbDriverInstalled));
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncCorePrinterDriverInstalled(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncCorePrinterDriverInstalled *r)
{
	uint32_t _ptr_pszServer;
	uint32_t size_pszServer_1 = 0;
	uint32_t length_pszServer_1 = 0;
	uint32_t size_pszEnvironment_1 = 0;
	uint32_t length_pszEnvironment_1 = 0;
	TALLOC_CTX *_mem_save_pszServer_0 = NULL;
	TALLOC_CTX *_mem_save_pbDriverInstalled_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServer));
		if (_ptr_pszServer) {
			NDR_PULL_ALLOC(ndr, r->in.pszServer);
		} else {
			r->in.pszServer = NULL;
		}
		if (r->in.pszServer) {
			_mem_save_pszServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszServer, &size_pszServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszServer, &length_pszServer_1));
			if (length_pszServer_1 > size_pszServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServer_1, length_pszServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszServer, length_pszServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszEnvironment, &size_pszEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszEnvironment, &length_pszEnvironment_1));
		if (length_pszEnvironment_1 > size_pszEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszEnvironment_1, length_pszEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszEnvironment, length_pszEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.CoreDriverGUID));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->in.ftDriverDate));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.dwlDriverVersion));
		NDR_PULL_ALLOC(ndr, r->out.pbDriverInstalled);
		NDR_ZERO_STRUCTP(r->out.pbDriverInstalled);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pbDriverInstalled);
		}
		_mem_save_pbDriverInstalled_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pbDriverInstalled, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, r->out.pbDriverInstalled));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pbDriverInstalled_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncCorePrinterDriverInstalled(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncCorePrinterDriverInstalled *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncCorePrinterDriverInstalled");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncCorePrinterDriverInstalled");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszServer", r->in.pszServer);
		ndr->depth++;
		if (r->in.pszServer) {
			ndr_print_string(ndr, "pszServer", r->in.pszServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth--;
		ndr_print_GUID(ndr, "CoreDriverGUID", &r->in.CoreDriverGUID);
		ndr_print_NTTIME(ndr, "ftDriverDate", r->in.ftDriverDate);
		ndr_print_hyper(ndr, "dwlDriverVersion", r->in.dwlDriverVersion);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncCorePrinterDriverInstalled");
		ndr->depth++;
		ndr_print_ptr(ndr, "pbDriverInstalled", r->out.pbDriverInstalled);
		ndr->depth++;
		ndr_print_int32(ndr, "pbDriverInstalled", *r->out.pbDriverInstalled);
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetPrinterDriverPackagePath(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDriverPackagePath *r)
{
	uint32_t cntr_pszDriverPackageCab_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pszPackageID == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszServer));
		if (r->in.pszServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszServer, ndr_charset_length(r->in.pszServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszEnvironment, ndr_charset_length(r->in.pszEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszLanguage));
		if (r->in.pszLanguage) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszLanguage, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszLanguage, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszLanguage, ndr_charset_length(r->in.pszLanguage, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszPackageID, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszPackageID, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszPackageID, ndr_charset_length(r->in.pszPackageID, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszDriverPackageCab));
		if (r->in.pszDriverPackageCab) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cchDriverPackageCab));
			for (cntr_pszDriverPackageCab_1 = 0; cntr_pszDriverPackageCab_1 < (r->in.cchDriverPackageCab); cntr_pszDriverPackageCab_1++) {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.pszDriverPackageCab[cntr_pszDriverPackageCab_1]));
			}
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cchDriverPackageCab));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcchRequiredSize == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.pszDriverPackageCab));
		if (r->out.pszDriverPackageCab) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cchDriverPackageCab));
			for (cntr_pszDriverPackageCab_1 = 0; cntr_pszDriverPackageCab_1 < (r->in.cchDriverPackageCab); cntr_pszDriverPackageCab_1++) {
				NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.pszDriverPackageCab[cntr_pszDriverPackageCab_1]));
			}
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcchRequiredSize));
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetPrinterDriverPackagePath(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetPrinterDriverPackagePath *r)
{
	uint32_t _ptr_pszServer;
	uint32_t size_pszServer_1 = 0;
	uint32_t length_pszServer_1 = 0;
	uint32_t size_pszEnvironment_1 = 0;
	uint32_t length_pszEnvironment_1 = 0;
	uint32_t _ptr_pszLanguage;
	uint32_t size_pszLanguage_1 = 0;
	uint32_t length_pszLanguage_1 = 0;
	uint32_t size_pszPackageID_1 = 0;
	uint32_t length_pszPackageID_1 = 0;
	uint32_t _ptr_pszDriverPackageCab;
	uint32_t size_pszDriverPackageCab_1 = 0;
	uint32_t cntr_pszDriverPackageCab_1;
	TALLOC_CTX *_mem_save_pszServer_0 = NULL;
	TALLOC_CTX *_mem_save_pszLanguage_0 = NULL;
	TALLOC_CTX *_mem_save_pszDriverPackageCab_0 = NULL;
	TALLOC_CTX *_mem_save_pszDriverPackageCab_1 = NULL;
	TALLOC_CTX *_mem_save_pcchRequiredSize_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServer));
		if (_ptr_pszServer) {
			NDR_PULL_ALLOC(ndr, r->in.pszServer);
		} else {
			r->in.pszServer = NULL;
		}
		if (r->in.pszServer) {
			_mem_save_pszServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszServer, &size_pszServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszServer, &length_pszServer_1));
			if (length_pszServer_1 > size_pszServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServer_1, length_pszServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszServer, length_pszServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszEnvironment, &size_pszEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszEnvironment, &length_pszEnvironment_1));
		if (length_pszEnvironment_1 > size_pszEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszEnvironment_1, length_pszEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszEnvironment, length_pszEnvironment_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszLanguage));
		if (_ptr_pszLanguage) {
			NDR_PULL_ALLOC(ndr, r->in.pszLanguage);
		} else {
			r->in.pszLanguage = NULL;
		}
		if (r->in.pszLanguage) {
			_mem_save_pszLanguage_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszLanguage, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszLanguage));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszLanguage));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszLanguage, &size_pszLanguage_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszLanguage, &length_pszLanguage_1));
			if (length_pszLanguage_1 > size_pszLanguage_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszLanguage_1, length_pszLanguage_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszLanguage_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszLanguage, length_pszLanguage_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszLanguage_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszPackageID));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszPackageID));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszPackageID, &size_pszPackageID_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszPackageID, &length_pszPackageID_1));
		if (length_pszPackageID_1 > size_pszPackageID_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszPackageID_1, length_pszPackageID_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszPackageID_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszPackageID, length_pszPackageID_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDriverPackageCab));
		if (_ptr_pszDriverPackageCab) {
			NDR_PULL_ALLOC(ndr, r->in.pszDriverPackageCab);
		} else {
			r->in.pszDriverPackageCab = NULL;
		}
		if (r->in.pszDriverPackageCab) {
			_mem_save_pszDriverPackageCab_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszDriverPackageCab, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszDriverPackageCab));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.pszDriverPackageCab, &size_pszDriverPackageCab_1));
			NDR_PULL_ALLOC_N(ndr, r->in.pszDriverPackageCab, size_pszDriverPackageCab_1);
			_mem_save_pszDriverPackageCab_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszDriverPackageCab, 0);
			for (cntr_pszDriverPackageCab_1 = 0; cntr_pszDriverPackageCab_1 < (size_pszDriverPackageCab_1); cntr_pszDriverPackageCab_1++) {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.pszDriverPackageCab[cntr_pszDriverPackageCab_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDriverPackageCab_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDriverPackageCab_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cchDriverPackageCab));
		NDR_PULL_ALLOC(ndr, r->out.pcchRequiredSize);
		NDR_ZERO_STRUCTP(r->out.pcchRequiredSize);
		if (r->in.pszDriverPackageCab) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.pszDriverPackageCab, r->in.cchDriverPackageCab));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDriverPackageCab));
		if (_ptr_pszDriverPackageCab) {
			NDR_PULL_ALLOC(ndr, r->out.pszDriverPackageCab);
		} else {
			r->out.pszDriverPackageCab = NULL;
		}
		if (r->out.pszDriverPackageCab) {
			_mem_save_pszDriverPackageCab_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pszDriverPackageCab, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pszDriverPackageCab));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pszDriverPackageCab, &size_pszDriverPackageCab_1));
			NDR_PULL_ALLOC_N(ndr, r->out.pszDriverPackageCab, size_pszDriverPackageCab_1);
			_mem_save_pszDriverPackageCab_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.pszDriverPackageCab, 0);
			for (cntr_pszDriverPackageCab_1 = 0; cntr_pszDriverPackageCab_1 < (size_pszDriverPackageCab_1); cntr_pszDriverPackageCab_1++) {
				NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.pszDriverPackageCab[cntr_pszDriverPackageCab_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDriverPackageCab_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDriverPackageCab_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcchRequiredSize);
		}
		_mem_save_pcchRequiredSize_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcchRequiredSize, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcchRequiredSize));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcchRequiredSize_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pszDriverPackageCab) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pszDriverPackageCab, r->in.cchDriverPackageCab));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetPrinterDriverPackagePath(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetPrinterDriverPackagePath *r)
{
	uint32_t cntr_pszDriverPackageCab_1;
	ndr_print_struct(ndr, name, "winspool_AsyncGetPrinterDriverPackagePath");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetPrinterDriverPackagePath");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszServer", r->in.pszServer);
		ndr->depth++;
		if (r->in.pszServer) {
			ndr_print_string(ndr, "pszServer", r->in.pszServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth--;
		ndr_print_ptr(ndr, "pszLanguage", r->in.pszLanguage);
		ndr->depth++;
		if (r->in.pszLanguage) {
			ndr_print_string(ndr, "pszLanguage", r->in.pszLanguage);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszPackageID", r->in.pszPackageID);
		ndr->depth++;
		ndr_print_string(ndr, "pszPackageID", r->in.pszPackageID);
		ndr->depth--;
		ndr_print_ptr(ndr, "pszDriverPackageCab", r->in.pszDriverPackageCab);
		ndr->depth++;
		if (r->in.pszDriverPackageCab) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pszDriverPackageCab", (uint32_t)(r->in.cchDriverPackageCab));
			ndr->depth++;
			for (cntr_pszDriverPackageCab_1 = 0; cntr_pszDriverPackageCab_1 < (r->in.cchDriverPackageCab); cntr_pszDriverPackageCab_1++) {
				ndr_print_uint16(ndr, "pszDriverPackageCab", r->in.pszDriverPackageCab[cntr_pszDriverPackageCab_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "cchDriverPackageCab", r->in.cchDriverPackageCab);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetPrinterDriverPackagePath");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszDriverPackageCab", r->out.pszDriverPackageCab);
		ndr->depth++;
		if (r->out.pszDriverPackageCab) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pszDriverPackageCab", (uint32_t)(r->in.cchDriverPackageCab));
			ndr->depth++;
			for (cntr_pszDriverPackageCab_1 = 0; cntr_pszDriverPackageCab_1 < (r->in.cchDriverPackageCab); cntr_pszDriverPackageCab_1++) {
				ndr_print_uint16(ndr, "pszDriverPackageCab", r->out.pszDriverPackageCab[cntr_pszDriverPackageCab_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pcchRequiredSize", r->out.pcchRequiredSize);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcchRequiredSize", *r->out.pcchRequiredSize);
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeletePrinterDriverPackage(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDriverPackage *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszInfPath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.pszEnvironment == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszServer));
		if (r->in.pszServer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszServer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszServer, ndr_charset_length(r->in.pszServer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszInfPath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszInfPath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszInfPath, ndr_charset_length(r->in.pszInfPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszEnvironment, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszEnvironment, ndr_charset_length(r->in.pszEnvironment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeletePrinterDriverPackage(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeletePrinterDriverPackage *r)
{
	uint32_t _ptr_pszServer;
	uint32_t size_pszServer_1 = 0;
	uint32_t length_pszServer_1 = 0;
	uint32_t size_pszInfPath_1 = 0;
	uint32_t length_pszInfPath_1 = 0;
	uint32_t size_pszEnvironment_1 = 0;
	uint32_t length_pszEnvironment_1 = 0;
	TALLOC_CTX *_mem_save_pszServer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServer));
		if (_ptr_pszServer) {
			NDR_PULL_ALLOC(ndr, r->in.pszServer);
		} else {
			r->in.pszServer = NULL;
		}
		if (r->in.pszServer) {
			_mem_save_pszServer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszServer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszServer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszServer, &size_pszServer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszServer, &length_pszServer_1));
			if (length_pszServer_1 > size_pszServer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServer_1, length_pszServer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszServer, length_pszServer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServer_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszInfPath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszInfPath));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszInfPath, &size_pszInfPath_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszInfPath, &length_pszInfPath_1));
		if (length_pszInfPath_1 > size_pszInfPath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszInfPath_1, length_pszInfPath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszInfPath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszInfPath, length_pszInfPath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszEnvironment));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszEnvironment, &size_pszEnvironment_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszEnvironment, &length_pszEnvironment_1));
		if (length_pszEnvironment_1 > size_pszEnvironment_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszEnvironment_1, length_pszEnvironment_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszEnvironment_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszEnvironment, length_pszEnvironment_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeletePrinterDriverPackage(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeletePrinterDriverPackage *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeletePrinterDriverPackage");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeletePrinterDriverPackage");
		ndr->depth++;
		ndr_print_ptr(ndr, "pszServer", r->in.pszServer);
		ndr->depth++;
		if (r->in.pszServer) {
			ndr_print_string(ndr, "pszServer", r->in.pszServer);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszInfPath", r->in.pszInfPath);
		ndr->depth++;
		ndr_print_string(ndr, "pszInfPath", r->in.pszInfPath);
		ndr->depth--;
		ndr_print_ptr(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth++;
		ndr_print_string(ndr, "pszEnvironment", r->in.pszEnvironment);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeletePrinterDriverPackage");
		ndr->depth++;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncReadPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncReadPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.cbBuf));
	}
	if (flags & NDR_OUT) {
		if (r->out.pBuf == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pcNoBytesRead == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.cbBuf));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.pBuf, r->in.cbBuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcNoBytesRead));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncReadPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncReadPrinter *r)
{
	uint32_t size_pBuf_1 = 0;
	TALLOC_CTX *_mem_save_pcNoBytesRead_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.cbBuf));
		NDR_PULL_ALLOC_N(ndr, r->out.pBuf, r->in.cbBuf);
		memset(r->out.pBuf, 0, (r->in.cbBuf) * sizeof(*r->out.pBuf));
		NDR_PULL_ALLOC(ndr, r->out.pcNoBytesRead);
		NDR_ZERO_STRUCTP(r->out.pcNoBytesRead);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.pBuf));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.pBuf, &size_pBuf_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.pBuf, size_pBuf_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.pBuf, size_pBuf_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcNoBytesRead);
		}
		_mem_save_pcNoBytesRead_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcNoBytesRead, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcNoBytesRead));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcNoBytesRead_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.pBuf) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.pBuf, r->in.cbBuf));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncReadPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncReadPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncReadPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncReadPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "cbBuf", r->in.cbBuf);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncReadPrinter");
		ndr->depth++;
		ndr_print_ptr(ndr, "pBuf", r->out.pBuf);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "pBuf", r->out.pBuf, r->in.cbBuf);
		ndr->depth--;
		ndr_print_ptr(ndr, "pcNoBytesRead", r->out.pcNoBytesRead);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcNoBytesRead", *r->out.pcNoBytesRead);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncResetPrinter(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncResetPrinter *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pDevModeContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDatatype));
		if (r->in.pDatatype) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDatatype, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pDatatype, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pDatatype, ndr_charset_length(r->in.pDatatype, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncResetPrinter(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncResetPrinter *r)
{
	uint32_t _ptr_pDatatype;
	uint32_t size_pDatatype_1 = 0;
	uint32_t length_pDatatype_1 = 0;
	TALLOC_CTX *_mem_save_pDatatype_0 = NULL;
	TALLOC_CTX *_mem_save_pDevModeContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDatatype));
		if (_ptr_pDatatype) {
			NDR_PULL_ALLOC(ndr, r->in.pDatatype);
		} else {
			r->in.pDatatype = NULL;
		}
		if (r->in.pDatatype) {
			_mem_save_pDatatype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDatatype, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pDatatype));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pDatatype));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pDatatype, &size_pDatatype_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pDatatype, &length_pDatatype_1));
			if (length_pDatatype_1 > size_pDatatype_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pDatatype_1, length_pDatatype_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pDatatype_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pDatatype, length_pDatatype_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDatatype_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
		}
		_mem_save_pDevModeContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pDevModeContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_DevmodeContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pDevModeContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDevModeContainer_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pDevModeContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pDevModeContainer);
			NDR_ZERO_STRUCTP(r->in.pDevModeContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncResetPrinter(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncResetPrinter *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncResetPrinter");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncResetPrinter");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pDatatype", r->in.pDatatype);
		ndr->depth++;
		if (r->in.pDatatype) {
			ndr_print_string(ndr, "pDatatype", r->in.pDatatype);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth++;
		ndr_print_spoolss_DevmodeContainer(ndr, "pDevModeContainer", r->in.pDevModeContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncResetPrinter");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncGetJobNamedPropertyValue(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncGetJobNamedPropertyValue *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszName, ndr_charset_length(r->in.pszName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		if (r->out.pValue == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_spoolss_PrintPropertyValue(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pValue));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncGetJobNamedPropertyValue(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncGetJobNamedPropertyValue *r)
{
	uint32_t size_pszName_1 = 0;
	uint32_t length_pszName_1 = 0;
	TALLOC_CTX *_mem_save_pValue_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszName, &size_pszName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszName, &length_pszName_1));
		if (length_pszName_1 > size_pszName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszName_1, length_pszName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszName, length_pszName_1, sizeof(uint16_t), CH_UTF16));
		NDR_PULL_ALLOC(ndr, r->out.pValue);
		NDR_ZERO_STRUCTP(r->out.pValue);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pValue);
		}
		_mem_save_pValue_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pValue, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PrintPropertyValue(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pValue));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pValue_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncGetJobNamedPropertyValue(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncGetJobNamedPropertyValue *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncGetJobNamedPropertyValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncGetJobNamedPropertyValue");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr_print_ptr(ndr, "pszName", r->in.pszName);
		ndr->depth++;
		ndr_print_string(ndr, "pszName", r->in.pszName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncGetJobNamedPropertyValue");
		ndr->depth++;
		ndr_print_ptr(ndr, "pValue", r->out.pValue);
		ndr->depth++;
		ndr_print_spoolss_PrintPropertyValue(ndr, "pValue", r->out.pValue);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_winspool_AsyncSetJobNamedProperty(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncSetJobNamedProperty *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pProperty == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
		NDR_CHECK(ndr_push_spoolss_PrintNamedProperty(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pProperty));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winspool_AsyncSetJobNamedProperty(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncSetJobNamedProperty *r)
{
	TALLOC_CTX *_mem_save_pProperty_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pProperty);
		}
		_mem_save_pProperty_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pProperty, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_PrintNamedProperty(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pProperty));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pProperty_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pProperty == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pProperty);
			NDR_ZERO_STRUCTP(r->in.pProperty);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncSetJobNamedProperty(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncSetJobNamedProperty *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncSetJobNamedProperty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncSetJobNamedProperty");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr_print_ptr(ndr, "pProperty", r->in.pProperty);
		ndr->depth++;
		ndr_print_spoolss_PrintNamedProperty(ndr, "pProperty", r->in.pProperty);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncSetJobNamedProperty");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncDeleteJobNamedProperty(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncDeleteJobNamedProperty *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszName, ndr_charset_length(r->in.pszName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncDeleteJobNamedProperty(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncDeleteJobNamedProperty *r)
{
	uint32_t size_pszName_1 = 0;
	uint32_t length_pszName_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszName, &size_pszName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszName, &length_pszName_1));
		if (length_pszName_1 > size_pszName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszName_1, length_pszName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszName, length_pszName_1, sizeof(uint16_t), CH_UTF16));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncDeleteJobNamedProperty(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncDeleteJobNamedProperty *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncDeleteJobNamedProperty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncDeleteJobNamedProperty");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr_print_ptr(ndr, "pszName", r->in.pszName);
		ndr->depth++;
		ndr_print_string(ndr, "pszName", r->in.pszName);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncDeleteJobNamedProperty");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncEnumJobNamedProperties(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncEnumJobNamedProperties *r)
{
	uint32_t cntr_ppProperties_2;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.JobId));
	}
	if (flags & NDR_OUT) {
		if (r->out.pcProperties == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppProperties == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pcProperties));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.ppProperties));
		if (*r->out.ppProperties) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.pcProperties));
			for (cntr_ppProperties_2 = 0; cntr_ppProperties_2 < (*r->out.pcProperties); cntr_ppProperties_2++) {
				NDR_CHECK(ndr_push_spoolss_PrintNamedProperty(ndr, NDR_SCALARS, &(*r->out.ppProperties)[cntr_ppProperties_2]));
			}
			for (cntr_ppProperties_2 = 0; cntr_ppProperties_2 < (*r->out.pcProperties); cntr_ppProperties_2++) {
				NDR_CHECK(ndr_push_spoolss_PrintNamedProperty(ndr, NDR_BUFFERS, &(*r->out.ppProperties)[cntr_ppProperties_2]));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncEnumJobNamedProperties(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncEnumJobNamedProperties *r)
{
	uint32_t _ptr_ppProperties;
	uint32_t size_ppProperties_2 = 0;
	uint32_t cntr_ppProperties_2;
	TALLOC_CTX *_mem_save_pcProperties_0 = NULL;
	TALLOC_CTX *_mem_save_ppProperties_0 = NULL;
	TALLOC_CTX *_mem_save_ppProperties_1 = NULL;
	TALLOC_CTX *_mem_save_ppProperties_2 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.JobId));
		NDR_PULL_ALLOC(ndr, r->out.pcProperties);
		NDR_ZERO_STRUCTP(r->out.pcProperties);
		NDR_PULL_ALLOC(ndr, r->out.ppProperties);
		NDR_ZERO_STRUCTP(r->out.ppProperties);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pcProperties);
		}
		_mem_save_pcProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pcProperties, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pcProperties));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pcProperties_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppProperties);
		}
		_mem_save_ppProperties_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppProperties, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ppProperties));
		if (_ptr_ppProperties) {
			NDR_PULL_ALLOC(ndr, *r->out.ppProperties);
		} else {
			*r->out.ppProperties = NULL;
		}
		if (*r->out.ppProperties) {
			_mem_save_ppProperties_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppProperties, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.ppProperties));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.ppProperties, &size_ppProperties_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.ppProperties, size_ppProperties_2);
			_mem_save_ppProperties_2 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.ppProperties, 0);
			for (cntr_ppProperties_2 = 0; cntr_ppProperties_2 < (size_ppProperties_2); cntr_ppProperties_2++) {
				NDR_CHECK(ndr_pull_spoolss_PrintNamedProperty(ndr, NDR_SCALARS, &(*r->out.ppProperties)[cntr_ppProperties_2]));
			}
			for (cntr_ppProperties_2 = 0; cntr_ppProperties_2 < (size_ppProperties_2); cntr_ppProperties_2++) {
				NDR_CHECK(ndr_pull_spoolss_PrintNamedProperty(ndr, NDR_BUFFERS, &(*r->out.ppProperties)[cntr_ppProperties_2]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppProperties_2, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppProperties_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppProperties_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.ppProperties) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)r->out.ppProperties, *r->out.pcProperties));
		}
		for (cntr_ppProperties_2 = 0; cntr_ppProperties_2 < (size_ppProperties_2); cntr_ppProperties_2++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncEnumJobNamedProperties(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncEnumJobNamedProperties *r)
{
	uint32_t cntr_ppProperties_2;
	ndr_print_struct(ndr, name, "winspool_AsyncEnumJobNamedProperties");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncEnumJobNamedProperties");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_uint32(ndr, "JobId", r->in.JobId);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncEnumJobNamedProperties");
		ndr->depth++;
		ndr_print_ptr(ndr, "pcProperties", r->out.pcProperties);
		ndr->depth++;
		ndr_print_uint32(ndr, "pcProperties", *r->out.pcProperties);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppProperties", r->out.ppProperties);
		ndr->depth++;
		ndr_print_ptr(ndr, "ppProperties", *r->out.ppProperties);
		ndr->depth++;
		if (*r->out.ppProperties) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ppProperties", (uint32_t)(*r->out.pcProperties));
			ndr->depth++;
			for (cntr_ppProperties_2 = 0; cntr_ppProperties_2 < (*r->out.pcProperties); cntr_ppProperties_2++) {
				ndr_print_spoolss_PrintNamedProperty(ndr, "ppProperties", &(*r->out.ppProperties)[cntr_ppProperties_2]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winspool_AsyncLogJobInfoForBranchOffice(struct ndr_push *ndr, ndr_flags_type flags, const struct winspool_AsyncLogJobInfoForBranchOffice *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pBranchOfficeJobDataContainer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		NDR_CHECK(ndr_push_spoolss_BranchOfficeJobDataContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pBranchOfficeJobDataContainer));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winspool_AsyncLogJobInfoForBranchOffice(struct ndr_pull *ndr, ndr_flags_type flags, struct winspool_AsyncLogJobInfoForBranchOffice *r)
{
	TALLOC_CTX *_mem_save_pBranchOfficeJobDataContainer_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hPrinter));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pBranchOfficeJobDataContainer);
		}
		_mem_save_pBranchOfficeJobDataContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pBranchOfficeJobDataContainer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_spoolss_BranchOfficeJobDataContainer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pBranchOfficeJobDataContainer));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBranchOfficeJobDataContainer_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pBranchOfficeJobDataContainer == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pBranchOfficeJobDataContainer);
			NDR_ZERO_STRUCTP(r->in.pBranchOfficeJobDataContainer);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winspool_AsyncLogJobInfoForBranchOffice(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winspool_AsyncLogJobInfoForBranchOffice *r)
{
	ndr_print_struct(ndr, name, "winspool_AsyncLogJobInfoForBranchOffice");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winspool_AsyncLogJobInfoForBranchOffice");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hPrinter", &r->in.hPrinter);
		ndr_print_ptr(ndr, "pBranchOfficeJobDataContainer", r->in.pBranchOfficeJobDataContainer);
		ndr->depth++;
		ndr_print_spoolss_BranchOfficeJobDataContainer(ndr, "pBranchOfficeJobDataContainer", r->in.pBranchOfficeJobDataContainer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winspool_AsyncLogJobInfoForBranchOffice");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_iremotewinspool
static const struct ndr_interface_public_struct iremotewinspool_public_structs[] = {
	{ .name = NULL }
};

static const struct ndr_interface_call iremotewinspool_calls[] = {
	{
		"winspool_AsyncOpenPrinter",
		sizeof(struct winspool_AsyncOpenPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncOpenPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncOpenPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncOpenPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddPrinter",
		sizeof(struct winspool_AsyncAddPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetJob",
		sizeof(struct winspool_AsyncSetJob),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetJob,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetJob,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetJob,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetJob",
		sizeof(struct winspool_AsyncGetJob),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetJob,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetJob,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetJob,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumJobs",
		sizeof(struct winspool_AsyncEnumJobs),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumJobs,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumJobs,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumJobs,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddJob",
		sizeof(struct winspool_AsyncAddJob),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddJob,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddJob,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddJob,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncScheduleJob",
		sizeof(struct winspool_AsyncScheduleJob),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncScheduleJob,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncScheduleJob,
		(ndr_print_function_t) ndr_print_winspool_AsyncScheduleJob,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinter",
		sizeof(struct winspool_AsyncDeletePrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetPrinter",
		sizeof(struct winspool_AsyncSetPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrinter",
		sizeof(struct winspool_AsyncGetPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncStartDocPrinter",
		sizeof(struct winspool_AsyncStartDocPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncStartDocPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncStartDocPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncStartDocPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncStartPagePrinter",
		sizeof(struct winspool_AsyncStartPagePrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncStartPagePrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncStartPagePrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncStartPagePrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncWritePrinter",
		sizeof(struct winspool_AsyncWritePrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncWritePrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncWritePrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncWritePrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEndPagePrinter",
		sizeof(struct winspool_AsyncEndPagePrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEndPagePrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEndPagePrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncEndPagePrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEndDocPrinter",
		sizeof(struct winspool_AsyncEndDocPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEndDocPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEndDocPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncEndDocPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAbortPrinter",
		sizeof(struct winspool_AsyncAbortPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAbortPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAbortPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncAbortPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrinterData",
		sizeof(struct winspool_AsyncGetPrinterData),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrinterData,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrinterData,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrinterData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrinterDataEx",
		sizeof(struct winspool_AsyncGetPrinterDataEx),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrinterDataEx,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrinterDataEx,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrinterDataEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetPrinterData",
		sizeof(struct winspool_AsyncSetPrinterData),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetPrinterData,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetPrinterData,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetPrinterData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetPrinterDataEx",
		sizeof(struct winspool_AsyncSetPrinterDataEx),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetPrinterDataEx,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetPrinterDataEx,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetPrinterDataEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncClosePrinter",
		sizeof(struct winspool_AsyncClosePrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncClosePrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncClosePrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncClosePrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddForm",
		sizeof(struct winspool_AsyncAddForm),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddForm,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddForm,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddForm,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeleteForm",
		sizeof(struct winspool_AsyncDeleteForm),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeleteForm,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeleteForm,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeleteForm,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetForm",
		sizeof(struct winspool_AsyncGetForm),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetForm,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetForm,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetForm,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetForm",
		sizeof(struct winspool_AsyncSetForm),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetForm,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetForm,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetForm,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumForms",
		sizeof(struct winspool_AsyncEnumForms),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumForms,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumForms,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumForms,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrinterDriver",
		sizeof(struct winspool_AsyncGetPrinterDriver),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrinterDriver,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrinterDriver,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrinterDriver,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrinterData",
		sizeof(struct winspool_AsyncEnumPrinterData),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrinterData,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrinterData,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrinterData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrinterDataEx",
		sizeof(struct winspool_AsyncEnumPrinterDataEx),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrinterDataEx,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrinterDataEx,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrinterDataEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrinterKey",
		sizeof(struct winspool_AsyncEnumPrinterKey),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrinterKey,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrinterKey,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrinterKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterData",
		sizeof(struct winspool_AsyncDeletePrinterData),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterData,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterData,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterDataEx",
		sizeof(struct winspool_AsyncDeletePrinterDataEx),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterDataEx,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterDataEx,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterDataEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterKey",
		sizeof(struct winspool_AsyncDeletePrinterKey),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterKey,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterKey,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncXcvData",
		sizeof(struct winspool_AsyncXcvData),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncXcvData,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncXcvData,
		(ndr_print_function_t) ndr_print_winspool_AsyncXcvData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSendRecvBidiData",
		sizeof(struct winspool_AsyncSendRecvBidiData),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSendRecvBidiData,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSendRecvBidiData,
		(ndr_print_function_t) ndr_print_winspool_AsyncSendRecvBidiData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncCreatePrinterIC",
		sizeof(struct winspool_AsyncCreatePrinterIC),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncCreatePrinterIC,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncCreatePrinterIC,
		(ndr_print_function_t) ndr_print_winspool_AsyncCreatePrinterIC,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncPlayGdiScriptOnPrinterIC",
		sizeof(struct winspool_AsyncPlayGdiScriptOnPrinterIC),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncPlayGdiScriptOnPrinterIC,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncPlayGdiScriptOnPrinterIC,
		(ndr_print_function_t) ndr_print_winspool_AsyncPlayGdiScriptOnPrinterIC,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterIC",
		sizeof(struct winspool_AsyncDeletePrinterIC),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterIC,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterIC,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterIC,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrinters",
		sizeof(struct winspool_AsyncEnumPrinters),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrinters,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrinters,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrinters,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddPrinterDriver",
		sizeof(struct winspool_AsyncAddPrinterDriver),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddPrinterDriver,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddPrinterDriver,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddPrinterDriver,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrinterDrivers",
		sizeof(struct winspool_AsyncEnumPrinterDrivers),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrinterDrivers,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrinterDrivers,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrinterDrivers,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrinterDriverDirectory",
		sizeof(struct winspool_AsyncGetPrinterDriverDirectory),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrinterDriverDirectory,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrinterDriverDirectory,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrinterDriverDirectory,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterDriver",
		sizeof(struct winspool_AsyncDeletePrinterDriver),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterDriver,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterDriver,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterDriver,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterDriverEx",
		sizeof(struct winspool_AsyncDeletePrinterDriverEx),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterDriverEx,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterDriverEx,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterDriverEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddPrintProcessor",
		sizeof(struct winspool_AsyncAddPrintProcessor),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddPrintProcessor,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddPrintProcessor,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddPrintProcessor,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrintProcessors",
		sizeof(struct winspool_AsyncEnumPrintProcessors),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrintProcessors,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrintProcessors,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrintProcessors,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrintProcessorDirectory",
		sizeof(struct winspool_AsyncGetPrintProcessorDirectory),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrintProcessorDirectory,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrintProcessorDirectory,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrintProcessorDirectory,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPorts",
		sizeof(struct winspool_AsyncEnumPorts),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPorts,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPorts,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPorts,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumMonitors",
		sizeof(struct winspool_AsyncEnumMonitors),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumMonitors,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumMonitors,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumMonitors,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddPort",
		sizeof(struct winspool_AsyncAddPort),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddPort,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddPort,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddPort,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetPort",
		sizeof(struct winspool_AsyncSetPort),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetPort,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetPort,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetPort,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddMonitor",
		sizeof(struct winspool_AsyncAddMonitor),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddMonitor,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddMonitor,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddMonitor,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeleteMonitor",
		sizeof(struct winspool_AsyncDeleteMonitor),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeleteMonitor,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeleteMonitor,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeleteMonitor,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrintProcessor",
		sizeof(struct winspool_AsyncDeletePrintProcessor),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrintProcessor,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrintProcessor,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrintProcessor,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPrintProcessorDatatypes",
		sizeof(struct winspool_AsyncEnumPrintProcessorDatatypes),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPrintProcessorDatatypes,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPrintProcessorDatatypes,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPrintProcessorDatatypes,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncAddPerMachineConnection",
		sizeof(struct winspool_AsyncAddPerMachineConnection),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncAddPerMachineConnection,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncAddPerMachineConnection,
		(ndr_print_function_t) ndr_print_winspool_AsyncAddPerMachineConnection,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePerMachineConnection",
		sizeof(struct winspool_AsyncDeletePerMachineConnection),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePerMachineConnection,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePerMachineConnection,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePerMachineConnection,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumPerMachineConnections",
		sizeof(struct winspool_AsyncEnumPerMachineConnections),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumPerMachineConnections,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumPerMachineConnections,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumPerMachineConnections,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_SyncRegisterForRemoteNotifications",
		sizeof(struct winspool_SyncRegisterForRemoteNotifications),
		(ndr_push_flags_fn_t) ndr_push_winspool_SyncRegisterForRemoteNotifications,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_SyncRegisterForRemoteNotifications,
		(ndr_print_function_t) ndr_print_winspool_SyncRegisterForRemoteNotifications,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_SyncUnRegisterForRemoteNotifications",
		sizeof(struct winspool_SyncUnRegisterForRemoteNotifications),
		(ndr_push_flags_fn_t) ndr_push_winspool_SyncUnRegisterForRemoteNotifications,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_SyncUnRegisterForRemoteNotifications,
		(ndr_print_function_t) ndr_print_winspool_SyncUnRegisterForRemoteNotifications,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_SyncRefreshRemoteNotifications",
		sizeof(struct winspool_SyncRefreshRemoteNotifications),
		(ndr_push_flags_fn_t) ndr_push_winspool_SyncRefreshRemoteNotifications,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_SyncRefreshRemoteNotifications,
		(ndr_print_function_t) ndr_print_winspool_SyncRefreshRemoteNotifications,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetRemoteNotifications",
		sizeof(struct winspool_AsyncGetRemoteNotifications),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetRemoteNotifications,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetRemoteNotifications,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetRemoteNotifications,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncInstallPrinterDriverFromPackage",
		sizeof(struct winspool_AsyncInstallPrinterDriverFromPackage),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncInstallPrinterDriverFromPackage,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncInstallPrinterDriverFromPackage,
		(ndr_print_function_t) ndr_print_winspool_AsyncInstallPrinterDriverFromPackage,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncUploadPrinterDriverPackage",
		sizeof(struct winspool_AsyncUploadPrinterDriverPackage),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncUploadPrinterDriverPackage,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncUploadPrinterDriverPackage,
		(ndr_print_function_t) ndr_print_winspool_AsyncUploadPrinterDriverPackage,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetCorePrinterDrivers",
		sizeof(struct winspool_AsyncGetCorePrinterDrivers),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetCorePrinterDrivers,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetCorePrinterDrivers,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetCorePrinterDrivers,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncCorePrinterDriverInstalled",
		sizeof(struct winspool_AsyncCorePrinterDriverInstalled),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncCorePrinterDriverInstalled,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncCorePrinterDriverInstalled,
		(ndr_print_function_t) ndr_print_winspool_AsyncCorePrinterDriverInstalled,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetPrinterDriverPackagePath",
		sizeof(struct winspool_AsyncGetPrinterDriverPackagePath),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetPrinterDriverPackagePath,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetPrinterDriverPackagePath,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetPrinterDriverPackagePath,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeletePrinterDriverPackage",
		sizeof(struct winspool_AsyncDeletePrinterDriverPackage),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeletePrinterDriverPackage,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeletePrinterDriverPackage,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeletePrinterDriverPackage,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncReadPrinter",
		sizeof(struct winspool_AsyncReadPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncReadPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncReadPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncReadPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncResetPrinter",
		sizeof(struct winspool_AsyncResetPrinter),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncResetPrinter,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncResetPrinter,
		(ndr_print_function_t) ndr_print_winspool_AsyncResetPrinter,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncGetJobNamedPropertyValue",
		sizeof(struct winspool_AsyncGetJobNamedPropertyValue),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncGetJobNamedPropertyValue,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncGetJobNamedPropertyValue,
		(ndr_print_function_t) ndr_print_winspool_AsyncGetJobNamedPropertyValue,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncSetJobNamedProperty",
		sizeof(struct winspool_AsyncSetJobNamedProperty),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncSetJobNamedProperty,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncSetJobNamedProperty,
		(ndr_print_function_t) ndr_print_winspool_AsyncSetJobNamedProperty,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncDeleteJobNamedProperty",
		sizeof(struct winspool_AsyncDeleteJobNamedProperty),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncDeleteJobNamedProperty,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncDeleteJobNamedProperty,
		(ndr_print_function_t) ndr_print_winspool_AsyncDeleteJobNamedProperty,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncEnumJobNamedProperties",
		sizeof(struct winspool_AsyncEnumJobNamedProperties),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncEnumJobNamedProperties,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncEnumJobNamedProperties,
		(ndr_print_function_t) ndr_print_winspool_AsyncEnumJobNamedProperties,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winspool_AsyncLogJobInfoForBranchOffice",
		sizeof(struct winspool_AsyncLogJobInfoForBranchOffice),
		(ndr_push_flags_fn_t) ndr_push_winspool_AsyncLogJobInfoForBranchOffice,
		(ndr_pull_flags_fn_t) ndr_pull_winspool_AsyncLogJobInfoForBranchOffice,
		(ndr_print_function_t) ndr_print_winspool_AsyncLogJobInfoForBranchOffice,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const iremotewinspool_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
};

static const struct ndr_interface_string_array iremotewinspool_endpoints = {
	.count	= 1,
	.names	= iremotewinspool_endpoint_strings
};

static const char * const iremotewinspool_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array iremotewinspool_authservices = {
	.count	= 1,
	.names	= iremotewinspool_authservice_strings
};


const struct ndr_interface_table ndr_table_iremotewinspool = {
	.name		= "iremotewinspool",
	.syntax_id	= {
		{0x76f03f96,0xcdfd,0x44fc,{0xa2,0x2c},{0x64,0x95,0x0a,0x00,0x12,0x09}},
		NDR_IREMOTEWINSPOOL_VERSION
	},
	.helpstring	= NDR_IREMOTEWINSPOOL_HELPSTRING,
	.num_calls	= 75,
	.calls		= iremotewinspool_calls,
	.num_public_structs	= 0,
	.public_structs		= iremotewinspool_public_structs,
	.endpoints	= &iremotewinspool_endpoints,
	.authservices	= &iremotewinspool_authservices
};

#endif /* SKIP_NDR_TABLE_iremotewinspool */
