/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_winbind.h"

#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_samr.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_idmap.h"
static enum ndr_err_code ndr_push_wbint_TransID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_TransID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_id_type(ndr, NDR_SCALARS, r->type_hint));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->domain_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rid));
		NDR_CHECK(ndr_push_unixid(ndr, NDR_SCALARS, &r->xid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_TransID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_TransID *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_id_type(ndr, NDR_SCALARS, &r->type_hint));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->domain_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rid));
		NDR_CHECK(ndr_pull_unixid(ndr, NDR_SCALARS, &r->xid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_TransID(struct ndr_print *ndr, const char *name, const struct wbint_TransID *r)
{
	ndr_print_struct(ndr, name, "wbint_TransID");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_id_type(ndr, "type_hint", r->type_hint);
	ndr_print_uint32(ndr, "domain_index", r->domain_index);
	ndr_print_uint32(ndr, "rid", r->rid);
	ndr_print_unixid(ndr, "xid", &r->xid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_TransIDArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_TransIDArray *r)
{
	uint32_t cntr_ids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_ids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_ids));
		for (cntr_ids_0 = 0; cntr_ids_0 < (r->num_ids); cntr_ids_0++) {
			NDR_CHECK(ndr_push_wbint_TransID(ndr, NDR_SCALARS, &r->ids[cntr_ids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_TransIDArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_TransIDArray *r)
{
	uint32_t size_ids_0 = 0;
	uint32_t cntr_ids_0;
	TALLOC_CTX *_mem_save_ids_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->ids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_ids));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ids, &size_ids_0));
		NDR_PULL_ALLOC_N(ndr, r->ids, size_ids_0);
		_mem_save_ids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ids, 0);
		for (cntr_ids_0 = 0; cntr_ids_0 < (size_ids_0); cntr_ids_0++) {
			NDR_CHECK(ndr_pull_wbint_TransID(ndr, NDR_SCALARS, &r->ids[cntr_ids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ids_0, 0);
		if (r->ids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->ids, r->num_ids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_TransIDArray(struct ndr_print *ndr, const char *name, const struct wbint_TransIDArray *r)
{
	uint32_t cntr_ids_0;
	ndr_print_struct(ndr, name, "wbint_TransIDArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_ids", r->num_ids);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ids", (uint32_t)(r->num_ids));
	ndr->depth++;
	for (cntr_ids_0 = 0; cntr_ids_0 < (r->num_ids); cntr_ids_0++) {
		ndr_print_wbint_TransID(ndr, "ids", &r->ids[cntr_ids_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_userinfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_userinfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->acct_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->full_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->homedir));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->shell));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->uid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->primary_gid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->primary_group_name));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->user_sid));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->group_sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->acct_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->acct_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->acct_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->acct_name, ndr_charset_length(r->acct_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->full_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->full_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->full_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->full_name, ndr_charset_length(r->full_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->homedir) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->homedir, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->homedir, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->homedir, ndr_charset_length(r->homedir, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->shell) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->shell, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->shell, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->shell, ndr_charset_length(r->shell, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->primary_group_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->primary_group_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->primary_group_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->primary_group_name, ndr_charset_length(r->primary_group_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_userinfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_userinfo *r)
{
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_domain_name_0 = NULL;
	uint32_t _ptr_acct_name;
	uint32_t size_acct_name_1 = 0;
	uint32_t length_acct_name_1 = 0;
	TALLOC_CTX *_mem_save_acct_name_0 = NULL;
	uint32_t _ptr_full_name;
	uint32_t size_full_name_1 = 0;
	uint32_t length_full_name_1 = 0;
	TALLOC_CTX *_mem_save_full_name_0 = NULL;
	uint32_t _ptr_homedir;
	uint32_t size_homedir_1 = 0;
	uint32_t length_homedir_1 = 0;
	TALLOC_CTX *_mem_save_homedir_0 = NULL;
	uint32_t _ptr_shell;
	uint32_t size_shell_1 = 0;
	uint32_t length_shell_1 = 0;
	TALLOC_CTX *_mem_save_shell_0 = NULL;
	uint32_t _ptr_primary_group_name;
	uint32_t size_primary_group_name_1 = 0;
	uint32_t length_primary_group_name_1 = 0;
	TALLOC_CTX *_mem_save_primary_group_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_acct_name));
		if (_ptr_acct_name) {
			NDR_PULL_ALLOC(ndr, r->acct_name);
		} else {
			r->acct_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_full_name));
		if (_ptr_full_name) {
			NDR_PULL_ALLOC(ndr, r->full_name);
		} else {
			r->full_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_homedir));
		if (_ptr_homedir) {
			NDR_PULL_ALLOC(ndr, r->homedir);
		} else {
			r->homedir = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_shell));
		if (_ptr_shell) {
			NDR_PULL_ALLOC(ndr, r->shell);
		} else {
			r->shell = NULL;
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->uid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->primary_gid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_primary_group_name));
		if (_ptr_primary_group_name) {
			NDR_PULL_ALLOC(ndr, r->primary_group_name);
		} else {
			r->primary_group_name = NULL;
		}
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->user_sid));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->group_sid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->domain_name, &size_domain_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->domain_name, &length_domain_name_1));
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, length_domain_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		if (r->acct_name) {
			_mem_save_acct_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->acct_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->acct_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->acct_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->acct_name, &size_acct_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->acct_name, &length_acct_name_1));
			if (length_acct_name_1 > size_acct_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_acct_name_1, length_acct_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_acct_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->acct_name, length_acct_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_acct_name_0, 0);
		}
		if (r->full_name) {
			_mem_save_full_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->full_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->full_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->full_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->full_name, &size_full_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->full_name, &length_full_name_1));
			if (length_full_name_1 > size_full_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_full_name_1, length_full_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_full_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->full_name, length_full_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_full_name_0, 0);
		}
		if (r->homedir) {
			_mem_save_homedir_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->homedir, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->homedir));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->homedir));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->homedir, &size_homedir_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->homedir, &length_homedir_1));
			if (length_homedir_1 > size_homedir_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_homedir_1, length_homedir_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_homedir_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->homedir, length_homedir_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_homedir_0, 0);
		}
		if (r->shell) {
			_mem_save_shell_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->shell, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->shell));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->shell));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->shell, &size_shell_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->shell, &length_shell_1));
			if (length_shell_1 > size_shell_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_shell_1, length_shell_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_shell_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->shell, length_shell_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_shell_0, 0);
		}
		if (r->primary_group_name) {
			_mem_save_primary_group_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->primary_group_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->primary_group_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->primary_group_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->primary_group_name, &size_primary_group_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->primary_group_name, &length_primary_group_name_1));
			if (length_primary_group_name_1 > size_primary_group_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_primary_group_name_1, length_primary_group_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_primary_group_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->primary_group_name, length_primary_group_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_primary_group_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_userinfo(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_userinfo *r)
{
	ndr_print_wbint_userinfo(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_userinfo(struct ndr_print *ndr, const char *name, const struct wbint_userinfo *r)
{
	ndr_print_struct(ndr, name, "wbint_userinfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "acct_name", r->acct_name);
	ndr->depth++;
	if (r->acct_name) {
		ndr_print_string(ndr, "acct_name", r->acct_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "full_name", r->full_name);
	ndr->depth++;
	if (r->full_name) {
		ndr_print_string(ndr, "full_name", r->full_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "homedir", r->homedir);
	ndr->depth++;
	if (r->homedir) {
		ndr_print_string(ndr, "homedir", r->homedir);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "shell", r->shell);
	ndr->depth++;
	if (r->shell) {
		ndr_print_string(ndr, "shell", r->shell);
	}
	ndr->depth--;
	ndr_print_hyper(ndr, "uid", r->uid);
	ndr_print_hyper(ndr, "primary_gid", r->primary_gid);
	ndr_print_ptr(ndr, "primary_group_name", r->primary_group_name);
	ndr->depth++;
	if (r->primary_group_name) {
		ndr_print_string(ndr, "primary_group_name", r->primary_group_name);
	}
	ndr->depth--;
	ndr_print_dom_sid(ndr, "user_sid", &r->user_sid);
	ndr_print_dom_sid(ndr, "group_sid", &r->group_sid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_SidArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_SidArray *r)
{
	uint32_t cntr_sids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		for (cntr_sids_0 = 0; cntr_sids_0 < (r->num_sids); cntr_sids_0++) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sids[cntr_sids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_SidArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_SidArray *r)
{
	uint32_t size_sids_0 = 0;
	uint32_t cntr_sids_0;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_0));
		NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_0);
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
		for (cntr_sids_0 = 0; cntr_sids_0 < (size_sids_0); cntr_sids_0++) {
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sids[cntr_sids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		if (r->sids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_SidArray(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_SidArray *r)
{
	ndr_print_wbint_SidArray(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_SidArray(struct ndr_print *ndr, const char *name, const struct wbint_SidArray *r)
{
	uint32_t cntr_sids_0;
	ndr_print_struct(ndr, name, "wbint_SidArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->num_sids));
	ndr->depth++;
	for (cntr_sids_0 = 0; cntr_sids_0 < (r->num_sids); cntr_sids_0++) {
		ndr_print_dom_sid(ndr, "sids", &r->sids[cntr_sids_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_RidArray(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_RidArray *r)
{
	uint32_t cntr_rids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_rids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_rids));
		for (cntr_rids_0 = 0; cntr_rids_0 < (r->num_rids); cntr_rids_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->rids[cntr_rids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_RidArray(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_RidArray *r)
{
	uint32_t size_rids_0 = 0;
	uint32_t cntr_rids_0;
	TALLOC_CTX *_mem_save_rids_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->rids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_rids));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->rids, &size_rids_0));
		NDR_PULL_ALLOC_N(ndr, r->rids, size_rids_0);
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->rids, 0);
		for (cntr_rids_0 = 0; cntr_rids_0 < (size_rids_0); cntr_rids_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->rids[cntr_rids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, 0);
		if (r->rids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->rids, r->num_rids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_RidArray(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_RidArray *r)
{
	ndr_print_wbint_RidArray(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_RidArray(struct ndr_print *ndr, const char *name, const struct wbint_RidArray *r)
{
	uint32_t cntr_rids_0;
	ndr_print_struct(ndr, name, "wbint_RidArray");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_rids", r->num_rids);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "rids", (uint32_t)(r->num_rids));
	ndr->depth++;
	for (cntr_rids_0 = 0; cntr_rids_0 < (r->num_rids); cntr_rids_0++) {
		ndr_print_uint32(ndr, "rids", r->rids[cntr_rids_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_Principal(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_Principal *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, ndr_charset_length(r->name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_Principal(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_Principal *r)
{
	uint32_t _ptr_name;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, r->name);
		} else {
			r->name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->name) {
			_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->name, &size_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->name, &length_name_1));
			if (length_name_1 > size_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_name_1, length_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_Principal(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_Principal *r)
{
	ndr_print_wbint_Principal(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_Principal(struct ndr_print *ndr, const char *name, const struct wbint_Principal *r)
{
	ndr_print_struct(ndr, name, "wbint_Principal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr_print_lsa_SidType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "name", r->name);
	ndr->depth++;
	if (r->name) {
		ndr_print_string(ndr, "name", r->name);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_Principals(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_Principals *r)
{
	uint32_t cntr_principals_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_principals));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_principals));
		for (cntr_principals_0 = 0; cntr_principals_0 < (r->num_principals); cntr_principals_0++) {
			NDR_CHECK(ndr_push_wbint_Principal(ndr, NDR_SCALARS, &r->principals[cntr_principals_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_principals_0 = 0; cntr_principals_0 < (r->num_principals); cntr_principals_0++) {
			NDR_CHECK(ndr_push_wbint_Principal(ndr, NDR_BUFFERS, &r->principals[cntr_principals_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_Principals(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_Principals *r)
{
	uint32_t size_principals_0 = 0;
	uint32_t cntr_principals_0;
	TALLOC_CTX *_mem_save_principals_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->principals));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_principals));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->principals, &size_principals_0));
		NDR_PULL_ALLOC_N(ndr, r->principals, size_principals_0);
		_mem_save_principals_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->principals, 0);
		for (cntr_principals_0 = 0; cntr_principals_0 < (size_principals_0); cntr_principals_0++) {
			NDR_CHECK(ndr_pull_wbint_Principal(ndr, NDR_SCALARS, &r->principals[cntr_principals_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_principals_0, 0);
		if (r->principals) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->principals, r->num_principals));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->principals, &size_principals_0));
		_mem_save_principals_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->principals, 0);
		for (cntr_principals_0 = 0; cntr_principals_0 < (size_principals_0); cntr_principals_0++) {
			NDR_CHECK(ndr_pull_wbint_Principal(ndr, NDR_BUFFERS, &r->principals[cntr_principals_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_principals_0, 0);
		for (cntr_principals_0 = 0; cntr_principals_0 < (size_principals_0); cntr_principals_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_Principals(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_Principals *r)
{
	ndr_print_wbint_Principals(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_Principals(struct ndr_print *ndr, const char *name, const struct wbint_Principals *r)
{
	uint32_t cntr_principals_0;
	ndr_print_struct(ndr, name, "wbint_Principals");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_principals", r->num_principals);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "principals", (uint32_t)(r->num_principals));
	ndr->depth++;
	for (cntr_principals_0 = 0; cntr_principals_0 < (r->num_principals); cntr_principals_0++) {
		ndr_print_wbint_Principal(ndr, "principals", &r->principals[cntr_principals_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_userinfos(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_userinfos *r)
{
	uint32_t cntr_userinfos_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_userinfos));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_userinfos));
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < (r->num_userinfos); cntr_userinfos_0++) {
			NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_SCALARS, &r->userinfos[cntr_userinfos_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < (r->num_userinfos); cntr_userinfos_0++) {
			NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_BUFFERS, &r->userinfos[cntr_userinfos_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_userinfos(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_userinfos *r)
{
	uint32_t size_userinfos_0 = 0;
	uint32_t cntr_userinfos_0;
	TALLOC_CTX *_mem_save_userinfos_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->userinfos));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_userinfos));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->userinfos, &size_userinfos_0));
		NDR_PULL_ALLOC_N(ndr, r->userinfos, size_userinfos_0);
		_mem_save_userinfos_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->userinfos, 0);
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < (size_userinfos_0); cntr_userinfos_0++) {
			NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_SCALARS, &r->userinfos[cntr_userinfos_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_userinfos_0, 0);
		if (r->userinfos) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->userinfos, r->num_userinfos));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->userinfos, &size_userinfos_0));
		_mem_save_userinfos_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->userinfos, 0);
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < (size_userinfos_0); cntr_userinfos_0++) {
			NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_BUFFERS, &r->userinfos[cntr_userinfos_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_userinfos_0, 0);
		for (cntr_userinfos_0 = 0; cntr_userinfos_0 < (size_userinfos_0); cntr_userinfos_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_userinfos(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_userinfos *r)
{
	ndr_print_wbint_userinfos(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_userinfos(struct ndr_print *ndr, const char *name, const struct wbint_userinfos *r)
{
	uint32_t cntr_userinfos_0;
	ndr_print_struct(ndr, name, "wbint_userinfos");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_userinfos", r->num_userinfos);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "userinfos", (uint32_t)(r->num_userinfos));
	ndr->depth++;
	for (cntr_userinfos_0 = 0; cntr_userinfos_0 < (r->num_userinfos); cntr_userinfos_0++) {
		ndr_print_wbint_userinfo(ndr, "userinfos", &r->userinfos[cntr_userinfos_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_Validation(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_Validation *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->validation));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->krb5ccname));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->validation) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->validation, r->level));
			NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->validation));
		}
		if (r->krb5ccname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->krb5ccname, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->krb5ccname, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->krb5ccname, ndr_charset_length(r->krb5ccname, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_Validation(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_Validation *r)
{
	uint32_t _ptr_validation;
	TALLOC_CTX *_mem_save_validation_0 = NULL;
	uint32_t _ptr_krb5ccname;
	uint32_t size_krb5ccname_1 = 0;
	uint32_t length_krb5ccname_1 = 0;
	TALLOC_CTX *_mem_save_krb5ccname_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_validation));
		if (_ptr_validation) {
			NDR_PULL_ALLOC(ndr, r->validation);
		} else {
			r->validation = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_krb5ccname));
		if (_ptr_krb5ccname) {
			NDR_PULL_ALLOC(ndr, r->krb5ccname);
		} else {
			r->krb5ccname = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->validation) {
			_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->validation, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->validation, r->level));
			NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->validation));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, 0);
		}
		if (r->krb5ccname) {
			_mem_save_krb5ccname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->krb5ccname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->krb5ccname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->krb5ccname));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->krb5ccname, &size_krb5ccname_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->krb5ccname, &length_krb5ccname_1));
			if (length_krb5ccname_1 > size_krb5ccname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_krb5ccname_1, length_krb5ccname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_krb5ccname_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->krb5ccname, length_krb5ccname_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_krb5ccname_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_Validation(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_Validation *r)
{
	ndr_print_wbint_Validation(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_Validation(struct ndr_print *ndr, const char *name, const struct wbint_Validation *r)
{
	ndr_print_struct(ndr, name, "wbint_Validation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "level", r->level);
	ndr_print_ptr(ndr, "validation", r->validation);
	ndr->depth++;
	if (r->validation) {
		ndr_print_set_switch_value(ndr, r->validation, r->level);
		ndr_print_netr_Validation(ndr, "validation", r->validation);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "krb5ccname", r->krb5ccname);
	ndr->depth++;
	if (r->krb5ccname) {
		ndr_print_string(ndr, "krb5ccname", r->krb5ccname);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_AuthUserInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_AuthUserInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->username));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->password));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->krb5_cc_type));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->uid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->username) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->username, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->username, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->username, ndr_charset_length(r->username, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			if (r->password) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->password, CH_UTF8)));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->password, CH_UTF8)));
				NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->password, ndr_charset_length(r->password, CH_UTF8), sizeof(uint8_t), CH_UTF8));
			}
			ndr->flags = _flags_save_uint8;
		}
		if (r->krb5_cc_type) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->krb5_cc_type, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->krb5_cc_type, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->krb5_cc_type, ndr_charset_length(r->krb5_cc_type, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_AuthUserInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_AuthUserInfo *r)
{
	uint32_t _ptr_username;
	uint32_t size_username_1 = 0;
	uint32_t length_username_1 = 0;
	TALLOC_CTX *_mem_save_username_0 = NULL;
	uint32_t _ptr_password;
	uint32_t size_password_1 = 0;
	uint32_t length_password_1 = 0;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	uint32_t _ptr_krb5_cc_type;
	uint32_t size_krb5_cc_type_1 = 0;
	uint32_t length_krb5_cc_type_1 = 0;
	TALLOC_CTX *_mem_save_krb5_cc_type_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_username));
		if (_ptr_username) {
			NDR_PULL_ALLOC(ndr, r->username);
		} else {
			r->username = NULL;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
			if (_ptr_password) {
				NDR_PULL_ALLOC(ndr, r->password);
			} else {
				r->password = NULL;
			}
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_krb5_cc_type));
		if (_ptr_krb5_cc_type) {
			NDR_PULL_ALLOC(ndr, r->krb5_cc_type);
		} else {
			r->krb5_cc_type = NULL;
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->uid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->username) {
			_mem_save_username_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->username, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->username));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->username));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->username, &size_username_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->username, &length_username_1));
			if (length_username_1 > size_username_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_username_1, length_username_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_username_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->username, length_username_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_username_0, 0);
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			if (r->password) {
				_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->password, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->password));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->password));
				NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->password, &size_password_1));
				NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->password, &length_password_1));
				if (length_password_1 > size_password_1) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_password_1, length_password_1);
				}
				NDR_CHECK(ndr_check_string_terminator(ndr, length_password_1, sizeof(uint8_t)));
				NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->password, length_password_1, sizeof(uint8_t), CH_UTF8));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
			}
			ndr->flags = _flags_save_uint8;
		}
		if (r->krb5_cc_type) {
			_mem_save_krb5_cc_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->krb5_cc_type, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->krb5_cc_type));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->krb5_cc_type));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->krb5_cc_type, &size_krb5_cc_type_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->krb5_cc_type, &length_krb5_cc_type_1));
			if (length_krb5_cc_type_1 > size_krb5_cc_type_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_krb5_cc_type_1, length_krb5_cc_type_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_krb5_cc_type_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->krb5_cc_type, length_krb5_cc_type_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_krb5_cc_type_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_AuthUserInfo(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_AuthUserInfo *r)
{
	ndr_print_wbint_AuthUserInfo(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_AuthUserInfo(struct ndr_print *ndr, const char *name, const struct wbint_AuthUserInfo *r)
{
	ndr_print_struct(ndr, name, "wbint_AuthUserInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "username", r->username);
	ndr->depth++;
	if (r->username) {
		ndr_print_string(ndr, "username", r->username);
	}
	ndr->depth--;
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_ptr(ndr, "password", r->password);
		ndr->depth++;
		if (r->password) {
			ndr_print_string(ndr, "password", r->password);
		}
		ndr->depth--;
		ndr->flags = _flags_save_uint8;
	}
	ndr_print_ptr(ndr, "krb5_cc_type", r->krb5_cc_type);
	ndr->depth++;
	if (r->krb5_cc_type) {
		ndr_print_string(ndr, "krb5_cc_type", r->krb5_cc_type);
	}
	ndr->depth--;
	ndr_print_hyper(ndr, "uid", r->uid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_wbint_PamAuthCrapValidation(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct wbint_PamAuthCrapValidation *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->validation));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->validation) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->validation, r->level));
			NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->validation));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_wbint_PamAuthCrapValidation(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct wbint_PamAuthCrapValidation *r)
{
	uint32_t _ptr_validation;
	TALLOC_CTX *_mem_save_validation_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_validation));
		if (_ptr_validation) {
			NDR_PULL_ALLOC(ndr, r->validation);
		} else {
			r->validation = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->validation) {
			_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->validation, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->validation, r->level));
			NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->validation));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_wbint_PamAuthCrapValidation(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct wbint_PamAuthCrapValidation *r)
{
	ndr_print_wbint_PamAuthCrapValidation(ndr, name, r);
}

_PUBLIC_ void ndr_print_wbint_PamAuthCrapValidation(struct ndr_print *ndr, const char *name, const struct wbint_PamAuthCrapValidation *r)
{
	ndr_print_struct(ndr, name, "wbint_PamAuthCrapValidation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "level", r->level);
	ndr_print_ptr(ndr, "validation", r->validation);
	ndr->depth++;
	if (r->validation) {
		ndr_print_set_switch_value(ndr, r->validation, r->level);
		ndr_print_netr_Validation(ndr, "validation", r->validation);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DomainInfoFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DomainInfoFlags r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DomainInfoFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DomainInfoFlags *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DomainInfoFlags(struct ndr_print *ndr, const char *name, enum DomainInfoFlags r)
{
	const char *val = NULL;

	switch (r) {
		case WB_DOMINFO_DOMAIN_UNKNOWN: val = "WB_DOMINFO_DOMAIN_UNKNOWN"; break;
		case WB_DOMINFO_DOMAIN_NATIVE: val = "WB_DOMINFO_DOMAIN_NATIVE"; break;
		case WB_DOMINFO_DOMAIN_AD: val = "WB_DOMINFO_DOMAIN_AD"; break;
		case WB_DOMINFO_DOMAIN_PRIMARY: val = "WB_DOMINFO_DOMAIN_PRIMARY"; break;
		case WB_DOMINFO_DOMAIN_OFFLINE: val = "WB_DOMINFO_DOMAIN_OFFLINE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_wbint_Ping(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_Ping *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.in_data));
	}
	if (flags & NDR_OUT) {
		if (r->out.out_data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.out_data));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Ping(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_Ping *r)
{
	TALLOC_CTX *_mem_save_out_data_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.in_data));
		NDR_PULL_ALLOC(ndr, r->out.out_data);
		NDR_ZERO_STRUCTP(r->out.out_data);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.out_data);
		}
		_mem_save_out_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.out_data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.out_data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_data_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Ping(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_Ping *r)
{
	ndr_print_struct(ndr, name, "wbint_Ping");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Ping");
		ndr->depth++;
		ndr_print_uint32(ndr, "in_data", r->in.in_data);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Ping");
		ndr->depth++;
		ndr_print_ptr(ndr, "out_data", r->out.out_data);
		ndr->depth++;
		ndr_print_uint32(ndr, "out_data", *r->out.out_data);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupSid(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupSid *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, *r->out.type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domain));
		if (*r->out.domain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.domain, ndr_charset_length(*r->out.domain, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.name));
		if (*r->out.name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.name, ndr_charset_length(*r->out.name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupSid(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupSid *r)
{
	uint32_t _ptr_domain;
	uint32_t size_domain_2 = 0;
	uint32_t length_domain_2 = 0;
	uint32_t _ptr_name;
	uint32_t size_name_2 = 0;
	uint32_t length_name_2 = 0;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_type_0 = NULL;
	TALLOC_CTX *_mem_save_domain_0 = NULL;
	TALLOC_CTX *_mem_save_domain_1 = NULL;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_name_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.type);
		NDR_ZERO_STRUCTP(r->out.type);
		NDR_PULL_ALLOC(ndr, r->out.domain);
		NDR_ZERO_STRUCTP(r->out.domain);
		NDR_PULL_ALLOC(ndr, r->out.name);
		NDR_ZERO_STRUCTP(r->out.name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domain);
		}
		_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domain, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, *r->out.domain);
		} else {
			*r->out.domain = NULL;
		}
		if (*r->out.domain) {
			_mem_save_domain_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.domain));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.domain));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.domain, &size_domain_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.domain, &length_domain_2));
			if (length_domain_2 > size_domain_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_2, length_domain_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.domain, length_domain_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, *r->out.name);
		} else {
			*r->out.name = NULL;
		}
		if (*r->out.name) {
			_mem_save_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.name, &size_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.name, &length_name_2));
			if (length_name_2 > size_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_name_2, length_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.name, length_name_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupSid(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupSid *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupSid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupSid");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupSid");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_lsa_SidType(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->out.domain);
		ndr->depth++;
		ndr_print_ptr(ndr, "domain", *r->out.domain);
		ndr->depth++;
		if (*r->out.domain) {
			ndr_print_string(ndr, "domain", *r->out.domain);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		ndr_print_ptr(ndr, "name", *r->out.name);
		ndr->depth++;
		if (*r->out.name) {
			ndr_print_string(ndr, "name", *r->out.name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupSids(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupSids *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_CHECK(ndr_push_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupSids(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupSids *r)
{
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
		NDR_PULL_ALLOC(ndr, r->out.names);
		NDR_ZERO_STRUCTP(r->out.names);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_TransNameArray(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupSids(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupSids *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupSids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupSids");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_lsa_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupSids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_lsa_RefDomainList(ndr, "domains", r->out.domains);
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_lsa_TransNameArray(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupName(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain, ndr_charset_length(r->in.domain, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.name, ndr_charset_length(r->in.name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, *r->out.type));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupName(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupName *r)
{
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	uint32_t size_name_1 = 0;
	uint32_t length_name_1 = 0;
	TALLOC_CTX *_mem_save_type_0 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.domain, &size_domain_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.domain, &length_domain_1));
		if (length_domain_1 > size_domain_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_1, length_domain_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain, length_domain_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.name, &size_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.name, &length_name_1));
		if (length_name_1 > size_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_name_1, length_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.name, length_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.type);
		NDR_ZERO_STRUCTP(r->out.type);
		NDR_PULL_ALLOC(ndr, r->out.sid);
		NDR_ZERO_STRUCTP(r->out.sid);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.type);
		}
		_mem_save_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, r->out.type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupName *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupName");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "name", r->in.name);
		ndr->depth++;
		ndr_print_string(ndr, "name", r->in.name);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupName");
		ndr->depth++;
		ndr_print_ptr(ndr, "type", r->out.type);
		ndr->depth++;
		ndr_print_lsa_SidType(ndr, "type", *r->out.type);
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->out.sid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_Sids2UnixIDs(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_Sids2UnixIDs *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.ids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domains));
		NDR_CHECK(ndr_push_wbint_TransIDArray(ndr, NDR_SCALARS, r->in.ids));
	}
	if (flags & NDR_OUT) {
		if (r->out.ids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_TransIDArray(ndr, NDR_SCALARS, r->out.ids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_Sids2UnixIDs(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_Sids2UnixIDs *r)
{
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	TALLOC_CTX *_mem_save_ids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_RefDomainList(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.ids);
		}
		_mem_save_ids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.ids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_TransIDArray(ndr, NDR_SCALARS, r->in.ids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.ids);
		*r->out.ids = *r->in.ids;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.domains == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.domains);
			NDR_ZERO_STRUCTP(r->in.domains);
		}
		if (r->in.ids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.ids);
			NDR_ZERO_STRUCTP(r->in.ids);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ids);
		}
		_mem_save_ids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_TransIDArray(ndr, NDR_SCALARS, r->out.ids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_Sids2UnixIDs(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_Sids2UnixIDs *r)
{
	ndr_print_struct(ndr, name, "wbint_Sids2UnixIDs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_Sids2UnixIDs");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->in.domains);
		ndr->depth++;
		ndr_print_lsa_RefDomainList(ndr, "domains", r->in.domains);
		ndr->depth--;
		ndr_print_ptr(ndr, "ids", r->in.ids);
		ndr->depth++;
		ndr_print_wbint_TransIDArray(ndr, "ids", r->in.ids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_Sids2UnixIDs");
		ndr->depth++;
		ndr_print_ptr(ndr, "ids", r->out.ids);
		ndr->depth++;
		ndr_print_wbint_TransIDArray(ndr, "ids", r->out.ids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_UnixIDs2Sids(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_UnixIDs2Sids *r)
{
	uint32_t cntr_xids_0;
	uint32_t cntr_sids_0;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->in.domain_sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.num_ids));
		for (cntr_xids_0 = 0; cntr_xids_0 < (r->in.num_ids); cntr_xids_0++) {
			NDR_CHECK(ndr_push_unixid(ndr, NDR_SCALARS, &r->in.xids[cntr_xids_0]));
		}
	}
	if (flags & NDR_OUT) {
		for (cntr_xids_0 = 0; cntr_xids_0 < (r->in.num_ids); cntr_xids_0++) {
			NDR_CHECK(ndr_push_unixid(ndr, NDR_SCALARS, &r->out.xids[cntr_xids_0]));
		}
		for (cntr_sids_0 = 0; cntr_sids_0 < (r->in.num_ids); cntr_sids_0++) {
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->out.sids[cntr_sids_0]));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_UnixIDs2Sids(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_UnixIDs2Sids *r)
{
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	uint32_t size_xids_0 = 0;
	uint32_t cntr_xids_0;
	uint32_t size_sids_0 = 0;
	uint32_t cntr_sids_0;
	TALLOC_CTX *_mem_save_xids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.domain_name, &size_domain_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.domain_name, &length_domain_name_1));
		if (length_domain_name_1 > size_domain_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_1, length_domain_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->in.domain_sid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.num_ids));
		size_xids_0 = r->in.num_ids;
		NDR_PULL_ALLOC_N(ndr, r->in.xids, size_xids_0);
		_mem_save_xids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.xids, 0);
		for (cntr_xids_0 = 0; cntr_xids_0 < (size_xids_0); cntr_xids_0++) {
			NDR_CHECK(ndr_pull_unixid(ndr, NDR_SCALARS, &r->in.xids[cntr_xids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_xids_0, 0);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		size_xids_0 = r->in.num_ids;
		NDR_PULL_ALLOC_N(ndr, r->out.xids, size_xids_0);
		_mem_save_xids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.xids, 0);
		for (cntr_xids_0 = 0; cntr_xids_0 < (size_xids_0); cntr_xids_0++) {
			NDR_CHECK(ndr_pull_unixid(ndr, NDR_SCALARS, &r->out.xids[cntr_xids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_xids_0, 0);
		size_sids_0 = r->in.num_ids;
		NDR_PULL_ALLOC_N(ndr, r->out.sids, size_sids_0);
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, 0);
		for (cntr_sids_0 = 0; cntr_sids_0 < (size_sids_0); cntr_sids_0++) {
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->out.sids[cntr_sids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_UnixIDs2Sids(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_UnixIDs2Sids *r)
{
	uint32_t cntr_xids_0;
	uint32_t cntr_sids_0;
	ndr_print_struct(ndr, name, "wbint_UnixIDs2Sids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_UnixIDs2Sids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr_print_dom_sid(ndr, "domain_sid", &r->in.domain_sid);
		ndr_print_uint32(ndr, "num_ids", r->in.num_ids);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "xids", (uint32_t)(r->in.num_ids));
		ndr->depth++;
		for (cntr_xids_0 = 0; cntr_xids_0 < (r->in.num_ids); cntr_xids_0++) {
			ndr_print_unixid(ndr, "xids", &r->in.xids[cntr_xids_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_UnixIDs2Sids");
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "xids", (uint32_t)(r->in.num_ids));
		ndr->depth++;
		for (cntr_xids_0 = 0; cntr_xids_0 < (r->in.num_ids); cntr_xids_0++) {
			ndr_print_unixid(ndr, "xids", &r->out.xids[cntr_xids_0]);
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->in.num_ids));
		ndr->depth++;
		for (cntr_sids_0 = 0; cntr_sids_0 < (r->in.num_ids); cntr_sids_0++) {
			ndr_print_dom_sid(ndr, "sids", &r->out.sids[cntr_sids_0]);
		}
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_AllocateUid(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_AllocateUid *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.uid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.uid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_AllocateUid(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_AllocateUid *r)
{
	TALLOC_CTX *_mem_save_uid_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.uid);
		NDR_ZERO_STRUCTP(r->out.uid);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.uid);
		}
		_mem_save_uid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.uid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.uid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_AllocateUid(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_AllocateUid *r)
{
	ndr_print_struct(ndr, name, "wbint_AllocateUid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_AllocateUid");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_AllocateUid");
		ndr->depth++;
		ndr_print_ptr(ndr, "uid", r->out.uid);
		ndr->depth++;
		ndr_print_hyper(ndr, "uid", *r->out.uid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_AllocateGid(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_AllocateGid *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.gid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.gid));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_AllocateGid(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_AllocateGid *r)
{
	TALLOC_CTX *_mem_save_gid_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.gid);
		NDR_ZERO_STRUCTP(r->out.gid);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.gid);
		}
		_mem_save_gid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.gid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.gid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_AllocateGid(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_AllocateGid *r)
{
	ndr_print_struct(ndr, name, "wbint_AllocateGid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_AllocateGid");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_AllocateGid");
		ndr->depth++;
		ndr_print_ptr(ndr, "gid", r->out.gid);
		ndr->depth++;
		ndr_print_hyper(ndr, "gid", *r->out.gid);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_GetNssInfo(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_GetNssInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_userinfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_GetNssInfo(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_GetNssInfo *r)
{
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.info);
		*r->out.info = *r->in.info;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_userinfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_GetNssInfo(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_GetNssInfo *r)
{
	ndr_print_struct(ndr, name, "wbint_GetNssInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_GetNssInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_wbint_userinfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_GetNssInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_wbint_userinfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupUserAliases(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupUserAliases *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->in.sids));
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_RidArray(ndr, NDR_SCALARS, r->out.rids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupUserAliases(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupUserAliases *r)
{
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_rids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->in.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.rids);
		NDR_ZERO_STRUCTP(r->out.rids);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sids);
			NDR_ZERO_STRUCTP(r->in.sids);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_RidArray(ndr, NDR_SCALARS, r->out.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupUserAliases(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupUserAliases *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupUserAliases");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupUserAliases");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->in.sids);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "sids", r->in.sids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupUserAliases");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_wbint_RidArray(ndr, "rids", r->out.rids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupUserGroups(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupUserGroups *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupUserGroups(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupUserGroups *r)
{
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.sids);
		NDR_ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupUserGroups(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupUserGroups *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupUserGroups");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupUserGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupUserGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QuerySequenceNumber(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_QuerySequenceNumber *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.sequence == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.sequence));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QuerySequenceNumber(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_QuerySequenceNumber *r)
{
	TALLOC_CTX *_mem_save_sequence_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.sequence);
		NDR_ZERO_STRUCTP(r->out.sequence);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sequence);
		}
		_mem_save_sequence_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sequence, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.sequence));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sequence_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QuerySequenceNumber(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_QuerySequenceNumber *r)
{
	ndr_print_struct(ndr, name, "wbint_QuerySequenceNumber");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QuerySequenceNumber");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QuerySequenceNumber");
		ndr->depth++;
		ndr_print_ptr(ndr, "sequence", r->out.sequence);
		ndr->depth++;
		ndr_print_uint32(ndr, "sequence", *r->out.sequence);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupGroupMembers(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupGroupMembers *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->in.type));
	}
	if (flags & NDR_OUT) {
		if (r->out.members == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.members));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupGroupMembers(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupGroupMembers *r)
{
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_members_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->in.type));
		NDR_PULL_ALLOC(ndr, r->out.members);
		NDR_ZERO_STRUCTP(r->out.members);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.members);
		}
		_mem_save_members_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.members, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.members));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_members_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupGroupMembers(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupGroupMembers *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupGroupMembers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupGroupMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_lsa_SidType(ndr, "type", r->in.type);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupGroupMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "members", r->out.members);
		ndr->depth++;
		ndr_print_wbint_Principals(ndr, "members", r->out.members);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupAliasMembers(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupAliasMembers *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_CHECK(ndr_push_lsa_SidType(ndr, NDR_SCALARS, r->in.type));
	}
	if (flags & NDR_OUT) {
		if (r->out.sids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->out.sids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupAliasMembers(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupAliasMembers *r)
{
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_lsa_SidType(ndr, NDR_SCALARS, &r->in.type));
		NDR_PULL_ALLOC(ndr, r->out.sids);
		NDR_ZERO_STRUCTP(r->out.sids);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.sid);
			NDR_ZERO_STRUCTP(r->in.sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sids);
		}
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->out.sids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupAliasMembers(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupAliasMembers *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupAliasMembers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupAliasMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "sid", r->in.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->in.sid);
		ndr->depth--;
		ndr_print_lsa_SidType(ndr, "type", r->in.type);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupAliasMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "sids", r->out.sids);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "sids", r->out.sids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QueryGroupList(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_QueryGroupList *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.groups == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.groups));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QueryGroupList(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_QueryGroupList *r)
{
	TALLOC_CTX *_mem_save_groups_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.groups);
		NDR_ZERO_STRUCTP(r->out.groups);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.groups);
		}
		_mem_save_groups_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.groups, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.groups));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_groups_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QueryGroupList(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_QueryGroupList *r)
{
	ndr_print_struct(ndr, name, "wbint_QueryGroupList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QueryGroupList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QueryGroupList");
		ndr->depth++;
		ndr_print_ptr(ndr, "groups", r->out.groups);
		ndr->depth++;
		ndr_print_wbint_Principals(ndr, "groups", r->out.groups);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_QueryUserRidList(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_QueryUserRidList *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_RidArray(ndr, NDR_SCALARS, r->out.rids));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_QueryUserRidList(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_QueryUserRidList *r)
{
	TALLOC_CTX *_mem_save_rids_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.rids);
		NDR_ZERO_STRUCTP(r->out.rids);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_RidArray(ndr, NDR_SCALARS, r->out.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_QueryUserRidList(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_QueryUserRidList *r)
{
	ndr_print_struct(ndr, name, "wbint_QueryUserRidList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_QueryUserRidList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_QueryUserRidList");
		ndr->depth++;
		ndr_print_ptr(ndr, "rids", r->out.rids);
		ndr->depth++;
		ndr_print_wbint_RidArray(ndr, "rids", r->out.rids);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_DsGetDcName(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_DsGetDcName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain_name, ndr_charset_length(r->in.domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.domain_guid));
		if (r->in.domain_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.dc_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dc_info));
		if (*r->out.dc_info) {
			NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.dc_info));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_DsGetDcName(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_DsGetDcName *r)
{
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	uint32_t _ptr_domain_guid;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	uint32_t _ptr_dc_info;
	TALLOC_CTX *_mem_save_domain_guid_0 = NULL;
	TALLOC_CTX *_mem_save_site_name_0 = NULL;
	TALLOC_CTX *_mem_save_dc_info_0 = NULL;
	TALLOC_CTX *_mem_save_dc_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.domain_name, &size_domain_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.domain_name, &length_domain_name_1));
		if (length_domain_name_1 > size_domain_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_1, length_domain_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain_name, length_domain_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_guid));
		if (_ptr_domain_guid) {
			NDR_PULL_ALLOC(ndr, r->in.domain_guid);
		} else {
			r->in.domain_guid = NULL;
		}
		if (r->in.domain_guid) {
			_mem_save_domain_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.domain_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.site_name, &size_site_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.site_name, &length_site_name_1));
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.dc_info);
		NDR_ZERO_STRUCTP(r->out.dc_info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dc_info);
		}
		_mem_save_dc_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dc_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dc_info));
		if (_ptr_dc_info) {
			NDR_PULL_ALLOC(ndr, *r->out.dc_info);
		} else {
			*r->out.dc_info = NULL;
		}
		if (*r->out.dc_info) {
			_mem_save_dc_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dc_info, 0);
			NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.dc_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_DsGetDcName(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_DsGetDcName *r)
{
	ndr_print_struct(ndr, name, "wbint_DsGetDcName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", r->out.dc_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", *r->out.dc_info);
		ndr->depth++;
		if (*r->out.dc_info) {
			ndr_print_netr_DsRGetDCNameInfo(ndr, "dc_info", *r->out.dc_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_LookupRids(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_LookupRids *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.domain_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.rids == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->in.domain_sid));
		NDR_CHECK(ndr_push_wbint_RidArray(ndr, NDR_SCALARS, r->in.rids));
	}
	if (flags & NDR_OUT) {
		if (r->out.domain_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.domain_name));
		if (*r->out.domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.domain_name, ndr_charset_length(*r->out.domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_LookupRids(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_LookupRids *r)
{
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_2 = 0;
	uint32_t length_domain_name_2 = 0;
	TALLOC_CTX *_mem_save_domain_sid_0 = NULL;
	TALLOC_CTX *_mem_save_rids_0 = NULL;
	TALLOC_CTX *_mem_save_domain_name_0 = NULL;
	TALLOC_CTX *_mem_save_domain_name_1 = NULL;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.domain_sid);
		}
		_mem_save_domain_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.domain_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->in.domain_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_sid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.rids);
		}
		_mem_save_rids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.rids, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_RidArray(ndr, NDR_SCALARS, r->in.rids));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rids_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.domain_name);
		NDR_ZERO_STRUCTP(r->out.domain_name);
		NDR_PULL_ALLOC(ndr, r->out.names);
		NDR_ZERO_STRUCTP(r->out.names);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.domain_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.domain_sid);
			NDR_ZERO_STRUCTP(r->in.domain_sid);
		}
		if (r->in.rids == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.rids);
			NDR_ZERO_STRUCTP(r->in.rids);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domain_name);
		}
		_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domain_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, *r->out.domain_name);
		} else {
			*r->out.domain_name = NULL;
		}
		if (*r->out.domain_name) {
			_mem_save_domain_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.domain_name, &size_domain_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.domain_name, &length_domain_name_2));
			if (length_domain_name_2 > size_domain_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_2, length_domain_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.domain_name, length_domain_name_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.names);
		}
		_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Principals(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_LookupRids(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_LookupRids *r)
{
	ndr_print_struct(ndr, name, "wbint_LookupRids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_LookupRids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "domain_sid", r->in.domain_sid);
		ndr->depth--;
		ndr_print_ptr(ndr, "rids", r->in.rids);
		ndr->depth++;
		ndr_print_wbint_RidArray(ndr, "rids", r->in.rids);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_LookupRids");
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", r->out.domain_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "domain_name", *r->out.domain_name);
		ndr->depth++;
		if (*r->out.domain_name) {
			ndr_print_string(ndr, "domain_name", *r->out.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "names", r->out.names);
		ndr->depth++;
		ndr_print_wbint_Principals(ndr, "names", r->out.names);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_CheckMachineAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_CheckMachineAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_CheckMachineAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_CheckMachineAccount *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_CheckMachineAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_CheckMachineAccount *r)
{
	ndr_print_struct(ndr, name, "wbint_CheckMachineAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_CheckMachineAccount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_CheckMachineAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_ChangeMachineAccount(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_ChangeMachineAccount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dcname));
		if (r->in.dcname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dcname, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dcname, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dcname, ndr_charset_length(r->in.dcname, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_ChangeMachineAccount(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_ChangeMachineAccount *r)
{
	uint32_t _ptr_dcname;
	uint32_t size_dcname_1 = 0;
	uint32_t length_dcname_1 = 0;
	TALLOC_CTX *_mem_save_dcname_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dcname));
		if (_ptr_dcname) {
			NDR_PULL_ALLOC(ndr, r->in.dcname);
		} else {
			r->in.dcname = NULL;
		}
		if (r->in.dcname) {
			_mem_save_dcname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dcname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dcname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dcname));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.dcname, &size_dcname_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.dcname, &length_dcname_1));
			if (length_dcname_1 > size_dcname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dcname_1, length_dcname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dcname_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dcname, length_dcname_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_ChangeMachineAccount(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_ChangeMachineAccount *r)
{
	ndr_print_struct(ndr, name, "wbint_ChangeMachineAccount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_ChangeMachineAccount");
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", r->in.dcname);
		ndr->depth++;
		if (r->in.dcname) {
			ndr_print_string(ndr, "dcname", r->in.dcname);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_ChangeMachineAccount");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PingDc(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_PingDc *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.dcname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dcname));
		if (*r->out.dcname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.dcname, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.dcname, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.dcname, ndr_charset_length(*r->out.dcname, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PingDc(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_PingDc *r)
{
	uint32_t _ptr_dcname;
	uint32_t size_dcname_2 = 0;
	uint32_t length_dcname_2 = 0;
	TALLOC_CTX *_mem_save_dcname_0 = NULL;
	TALLOC_CTX *_mem_save_dcname_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.dcname);
		NDR_ZERO_STRUCTP(r->out.dcname);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dcname);
		}
		_mem_save_dcname_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dcname, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dcname));
		if (_ptr_dcname) {
			NDR_PULL_ALLOC(ndr, *r->out.dcname);
		} else {
			*r->out.dcname = NULL;
		}
		if (*r->out.dcname) {
			_mem_save_dcname_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dcname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.dcname));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.dcname));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.dcname, &size_dcname_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.dcname, &length_dcname_2));
			if (length_dcname_2 > size_dcname_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dcname_2, length_dcname_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dcname_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.dcname, length_dcname_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dcname_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PingDc(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_PingDc *r)
{
	ndr_print_struct(ndr, name, "wbint_PingDc");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PingDc");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PingDc");
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", r->out.dcname);
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", *r->out.dcname);
		ndr->depth++;
		if (*r->out.dcname) {
			ndr_print_string(ndr, "dcname", *r->out.dcname);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_ListTrustedDomains(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_ListTrustedDomains *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.client_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_name, ndr_charset_length(r->in.client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.client_pid));
	}
	if (flags & NDR_OUT) {
		if (r->out.domains == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_DomainTrustList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_ListTrustedDomains(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_ListTrustedDomains *r)
{
	uint32_t size_client_name_1 = 0;
	uint32_t length_client_name_1 = 0;
	TALLOC_CTX *_mem_save_domains_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_name, &size_client_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_name, &length_client_name_1));
		if (length_client_name_1 > size_client_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_name_1, length_client_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_name, length_client_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.client_pid));
		NDR_PULL_ALLOC(ndr, r->out.domains);
		NDR_ZERO_STRUCTP(r->out.domains);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.domains);
		}
		_mem_save_domains_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.domains, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_netr_DomainTrustList(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.domains));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domains_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_ListTrustedDomains(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_ListTrustedDomains *r)
{
	ndr_print_struct(ndr, name, "wbint_ListTrustedDomains");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_ListTrustedDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "client_name", r->in.client_name);
		ndr->depth++;
		ndr_print_string(ndr, "client_name", r->in.client_name);
		ndr->depth--;
		ndr_print_hyper(ndr, "client_pid", r->in.client_pid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_ListTrustedDomains");
		ndr->depth++;
		ndr_print_ptr(ndr, "domains", r->out.domains);
		ndr->depth++;
		ndr_print_netr_DomainTrustList(ndr, "domains", r->out.domains);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PamAuth(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_PamAuth *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.client_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.require_membership_of_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_name, ndr_charset_length(r->in.client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.client_pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_wbint_AuthUserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->in.require_membership_of_sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.validation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_wbint_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PamAuth(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_PamAuth *r)
{
	uint32_t size_client_name_1 = 0;
	uint32_t length_client_name_1 = 0;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_require_membership_of_sid_0 = NULL;
	TALLOC_CTX *_mem_save_validation_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_name, &size_client_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_name, &length_client_name_1));
		if (length_client_name_1 > size_client_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_name_1, length_client_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_name, length_client_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.client_pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_AuthUserInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.require_membership_of_sid);
		}
		_mem_save_require_membership_of_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.require_membership_of_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->in.require_membership_of_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_require_membership_of_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.validation);
		NDR_ZERO_STRUCTP(r->out.validation);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.info == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.info);
			NDR_ZERO_STRUCTP(r->in.info);
		}
		if (r->in.require_membership_of_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.require_membership_of_sid);
			NDR_ZERO_STRUCTP(r->in.require_membership_of_sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.validation);
		}
		_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.validation, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PamAuth(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_PamAuth *r)
{
	ndr_print_struct(ndr, name, "wbint_PamAuth");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PamAuth");
		ndr->depth++;
		ndr_print_ptr(ndr, "client_name", r->in.client_name);
		ndr->depth++;
		ndr_print_string(ndr, "client_name", r->in.client_name);
		ndr->depth--;
		ndr_print_hyper(ndr, "client_pid", r->in.client_pid);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_wbint_AuthUserInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_ptr(ndr, "require_membership_of_sid", r->in.require_membership_of_sid);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "require_membership_of_sid", r->in.require_membership_of_sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PamAuth");
		ndr->depth++;
		ndr_print_ptr(ndr, "validation", r->out.validation);
		ndr->depth++;
		ndr_print_wbint_Validation(ndr, "validation", r->out.validation);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PamAuthCrap(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_PamAuthCrap *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.client_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.user == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.workstation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.require_membership_of_sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_name, ndr_charset_length(r->in.client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.client_pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain, ndr_charset_length(r->in.domain, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.workstation, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.workstation, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.workstation, ndr_charset_length(r->in.workstation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.lm_resp));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.nt_resp));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.chal));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.logon_parameters));
		NDR_CHECK(ndr_push_wbint_SidArray(ndr, NDR_SCALARS, r->in.require_membership_of_sid));
	}
	if (flags & NDR_OUT) {
		if (r->out.authoritative == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.validation == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->out.authoritative));
		NDR_CHECK(ndr_push_wbint_PamAuthCrapValidation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PamAuthCrap(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_PamAuthCrap *r)
{
	uint32_t size_client_name_1 = 0;
	uint32_t length_client_name_1 = 0;
	uint32_t size_user_1 = 0;
	uint32_t length_user_1 = 0;
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	uint32_t size_workstation_1 = 0;
	uint32_t length_workstation_1 = 0;
	TALLOC_CTX *_mem_save_require_membership_of_sid_0 = NULL;
	TALLOC_CTX *_mem_save_authoritative_0 = NULL;
	TALLOC_CTX *_mem_save_validation_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_name, &size_client_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_name, &length_client_name_1));
		if (length_client_name_1 > size_client_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_name_1, length_client_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_name, length_client_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.client_pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.user, &size_user_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.user, &length_user_1));
		if (length_user_1 > size_user_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_user_1, length_user_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_user_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, length_user_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.domain, &size_domain_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.domain, &length_domain_1));
		if (length_domain_1 > size_domain_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_1, length_domain_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain, length_domain_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.workstation));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.workstation));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.workstation, &size_workstation_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.workstation, &length_workstation_1));
		if (length_workstation_1 > size_workstation_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_workstation_1, length_workstation_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_workstation_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.workstation, length_workstation_1, sizeof(uint8_t), CH_UTF8));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.lm_resp));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.nt_resp));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.chal));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.logon_parameters));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.require_membership_of_sid);
		}
		_mem_save_require_membership_of_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.require_membership_of_sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_SidArray(ndr, NDR_SCALARS, r->in.require_membership_of_sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_require_membership_of_sid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.authoritative);
		NDR_ZERO_STRUCTP(r->out.authoritative);
		NDR_PULL_ALLOC(ndr, r->out.validation);
		NDR_ZERO_STRUCTP(r->out.validation);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.require_membership_of_sid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.require_membership_of_sid);
			NDR_ZERO_STRUCTP(r->in.require_membership_of_sid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.authoritative);
		}
		_mem_save_authoritative_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.authoritative, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->out.authoritative));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_authoritative_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.validation);
		}
		_mem_save_validation_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.validation, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_wbint_PamAuthCrapValidation(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.validation));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_validation_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PamAuthCrap(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_PamAuthCrap *r)
{
	ndr_print_struct(ndr, name, "wbint_PamAuthCrap");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PamAuthCrap");
		ndr->depth++;
		ndr_print_ptr(ndr, "client_name", r->in.client_name);
		ndr->depth++;
		ndr_print_string(ndr, "client_name", r->in.client_name);
		ndr->depth--;
		ndr_print_hyper(ndr, "client_pid", r->in.client_pid);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		ndr_print_string(ndr, "user", r->in.user);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "workstation", r->in.workstation);
		ndr->depth++;
		ndr_print_string(ndr, "workstation", r->in.workstation);
		ndr->depth--;
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "lm_resp", r->in.lm_resp);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "nt_resp", r->in.nt_resp);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "chal", r->in.chal);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr_print_uint32(ndr, "logon_parameters", r->in.logon_parameters);
		ndr_print_ptr(ndr, "require_membership_of_sid", r->in.require_membership_of_sid);
		ndr->depth++;
		ndr_print_wbint_SidArray(ndr, "require_membership_of_sid", r->in.require_membership_of_sid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PamAuthCrap");
		ndr->depth++;
		ndr_print_ptr(ndr, "authoritative", r->out.authoritative);
		ndr->depth++;
		ndr_print_uint8(ndr, "authoritative", *r->out.authoritative);
		ndr->depth--;
		ndr_print_ptr(ndr, "validation", r->out.validation);
		ndr->depth++;
		ndr_print_wbint_PamAuthCrapValidation(ndr, "validation", r->out.validation);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PamLogOff(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_PamLogOff *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.client_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.user == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.krb5ccname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_name, ndr_charset_length(r->in.client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.client_pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.krb5ccname, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.krb5ccname, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.krb5ccname, ndr_charset_length(r->in.krb5ccname, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.uid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PamLogOff(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_PamLogOff *r)
{
	uint32_t size_client_name_1 = 0;
	uint32_t length_client_name_1 = 0;
	uint32_t size_user_1 = 0;
	uint32_t length_user_1 = 0;
	uint32_t size_krb5ccname_1 = 0;
	uint32_t length_krb5ccname_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_name, &size_client_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_name, &length_client_name_1));
		if (length_client_name_1 > size_client_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_name_1, length_client_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_name, length_client_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.client_pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.user, &size_user_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.user, &length_user_1));
		if (length_user_1 > size_user_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_user_1, length_user_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_user_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, length_user_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.krb5ccname));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.krb5ccname));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.krb5ccname, &size_krb5ccname_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.krb5ccname, &length_krb5ccname_1));
		if (length_krb5ccname_1 > size_krb5ccname_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_krb5ccname_1, length_krb5ccname_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_krb5ccname_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.krb5ccname, length_krb5ccname_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.uid));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PamLogOff(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_PamLogOff *r)
{
	ndr_print_struct(ndr, name, "wbint_PamLogOff");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PamLogOff");
		ndr->depth++;
		ndr_print_ptr(ndr, "client_name", r->in.client_name);
		ndr->depth++;
		ndr_print_string(ndr, "client_name", r->in.client_name);
		ndr->depth--;
		ndr_print_hyper(ndr, "client_pid", r->in.client_pid);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		ndr_print_string(ndr, "user", r->in.user);
		ndr->depth--;
		ndr_print_ptr(ndr, "krb5ccname", r->in.krb5ccname);
		ndr->depth++;
		ndr_print_string(ndr, "krb5ccname", r->in.krb5ccname);
		ndr->depth--;
		ndr_print_hyper(ndr, "uid", r->in.uid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PamLogOff");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PamAuthCrapChangePassword(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_PamAuthCrapChangePassword *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.client_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.user == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.domain == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_name, ndr_charset_length(r->in.client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.client_pid));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.domain, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.domain, ndr_charset_length(r->in.domain, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.new_nt_pswd));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.old_nt_hash_enc));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.new_lm_pswd));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->in.old_lm_hash_enc));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PamAuthCrapChangePassword(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_PamAuthCrapChangePassword *r)
{
	uint32_t size_client_name_1 = 0;
	uint32_t length_client_name_1 = 0;
	uint32_t size_user_1 = 0;
	uint32_t length_user_1 = 0;
	uint32_t size_domain_1 = 0;
	uint32_t length_domain_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_name, &size_client_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_name, &length_client_name_1));
		if (length_client_name_1 > size_client_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_name_1, length_client_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_name, length_client_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.client_pid));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.user, &size_user_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.user, &length_user_1));
		if (length_user_1 > size_user_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_user_1, length_user_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_user_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, length_user_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.domain));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.domain));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.domain, &size_domain_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.domain, &length_domain_1));
		if (length_domain_1 > size_domain_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_1, length_domain_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.domain, length_domain_1, sizeof(uint8_t), CH_UTF8));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.new_nt_pswd));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.old_nt_hash_enc));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.new_lm_pswd));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->in.old_lm_hash_enc));
			ndr->flags = _flags_save_DATA_BLOB;
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PamAuthCrapChangePassword(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_PamAuthCrapChangePassword *r)
{
	ndr_print_struct(ndr, name, "wbint_PamAuthCrapChangePassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PamAuthCrapChangePassword");
		ndr->depth++;
		ndr_print_ptr(ndr, "client_name", r->in.client_name);
		ndr->depth++;
		ndr_print_string(ndr, "client_name", r->in.client_name);
		ndr->depth--;
		ndr_print_hyper(ndr, "client_pid", r->in.client_pid);
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		ndr_print_string(ndr, "user", r->in.user);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "new_nt_pswd", r->in.new_nt_pswd);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "old_nt_hash_enc", r->in.old_nt_hash_enc);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "new_lm_pswd", r->in.new_lm_pswd);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_DATA_BLOB(ndr, "old_lm_hash_enc", r->in.old_lm_hash_enc);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PamAuthCrapChangePassword");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_PamAuthChangePassword(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_PamAuthChangePassword *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.client_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.user == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.old_password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.new_password == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_name, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_name, ndr_charset_length(r->in.client_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.client_pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.user, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.user, ndr_charset_length(r->in.user, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.old_password, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.old_password, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.old_password, ndr_charset_length(r->in.old_password, CH_UTF8), sizeof(uint8_t), CH_UTF8));
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.new_password, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.new_password, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.new_password, ndr_charset_length(r->in.new_password, CH_UTF8), sizeof(uint8_t), CH_UTF8));
			ndr->flags = _flags_save_uint8;
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.dominfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.reject_reason == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.dominfo));
		if (*r->out.dominfo) {
			NDR_CHECK(ndr_push_samr_DomInfo1(ndr, NDR_SCALARS, *r->out.dominfo));
		}
		NDR_CHECK(ndr_push_samPwdChangeReason(ndr, NDR_SCALARS, *r->out.reject_reason));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_PamAuthChangePassword(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_PamAuthChangePassword *r)
{
	uint32_t size_client_name_1 = 0;
	uint32_t length_client_name_1 = 0;
	uint32_t size_user_1 = 0;
	uint32_t length_user_1 = 0;
	uint32_t size_old_password_1 = 0;
	uint32_t length_old_password_1 = 0;
	uint32_t size_new_password_1 = 0;
	uint32_t length_new_password_1 = 0;
	uint32_t _ptr_dominfo;
	TALLOC_CTX *_mem_save_dominfo_0 = NULL;
	TALLOC_CTX *_mem_save_dominfo_1 = NULL;
	TALLOC_CTX *_mem_save_reject_reason_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_name, &size_client_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_name, &length_client_name_1));
		if (length_client_name_1 > size_client_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_name_1, length_client_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_client_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_name, length_client_name_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.client_pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.user));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.user));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.user, &size_user_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.user, &length_user_1));
		if (length_user_1 > size_user_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_user_1, length_user_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_user_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.user, length_user_1, sizeof(uint8_t), CH_UTF8));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.old_password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.old_password));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.old_password, &size_old_password_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.old_password, &length_old_password_1));
			if (length_old_password_1 > size_old_password_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_old_password_1, length_old_password_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_old_password_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.old_password, length_old_password_1, sizeof(uint8_t), CH_UTF8));
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.new_password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.new_password));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.new_password, &size_new_password_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.new_password, &length_new_password_1));
			if (length_new_password_1 > size_new_password_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_new_password_1, length_new_password_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_new_password_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.new_password, length_new_password_1, sizeof(uint8_t), CH_UTF8));
			ndr->flags = _flags_save_uint8;
		}
		NDR_PULL_ALLOC(ndr, r->out.dominfo);
		NDR_ZERO_STRUCTP(r->out.dominfo);
		NDR_PULL_ALLOC(ndr, r->out.reject_reason);
		NDR_ZERO_STRUCTP(r->out.reject_reason);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dominfo);
		}
		_mem_save_dominfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dominfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dominfo));
		if (_ptr_dominfo) {
			NDR_PULL_ALLOC(ndr, *r->out.dominfo);
		} else {
			*r->out.dominfo = NULL;
		}
		if (*r->out.dominfo) {
			_mem_save_dominfo_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.dominfo, 0);
			NDR_CHECK(ndr_pull_samr_DomInfo1(ndr, NDR_SCALARS, *r->out.dominfo));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dominfo_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dominfo_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.reject_reason);
		}
		_mem_save_reject_reason_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.reject_reason, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_samPwdChangeReason(ndr, NDR_SCALARS, r->out.reject_reason));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reject_reason_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_PamAuthChangePassword(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_PamAuthChangePassword *r)
{
	ndr_print_struct(ndr, name, "wbint_PamAuthChangePassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_PamAuthChangePassword");
		ndr->depth++;
		ndr_print_ptr(ndr, "client_name", r->in.client_name);
		ndr->depth++;
		ndr_print_string(ndr, "client_name", r->in.client_name);
		ndr->depth--;
		ndr_print_hyper(ndr, "client_pid", r->in.client_pid);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_ptr(ndr, "user", r->in.user);
		ndr->depth++;
		ndr_print_string(ndr, "user", r->in.user);
		ndr->depth--;
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_ptr(ndr, "old_password", r->in.old_password);
			ndr->depth++;
			ndr_print_string(ndr, "old_password", r->in.old_password);
			ndr->depth--;
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_ptr(ndr, "new_password", r->in.new_password);
			ndr->depth++;
			ndr_print_string(ndr, "new_password", r->in.new_password);
			ndr->depth--;
			ndr->flags = _flags_save_uint8;
		}
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_PamAuthChangePassword");
		ndr->depth++;
		ndr_print_ptr(ndr, "dominfo", r->out.dominfo);
		ndr->depth++;
		ndr_print_ptr(ndr, "dominfo", *r->out.dominfo);
		ndr->depth++;
		if (*r->out.dominfo) {
			ndr_print_samr_DomInfo1(ndr, "dominfo", *r->out.dominfo);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "reject_reason", r->out.reject_reason);
		ndr->depth++;
		ndr_print_samPwdChangeReason(ndr, "reject_reason", *r->out.reject_reason);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_wbint_InitConnection(struct ndr_push *ndr, ndr_flags_type flags, const struct wbint_InitConnection *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.dcname == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dcname, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dcname, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dcname, ndr_charset_length(r->in.dcname, CH_UTF8), sizeof(uint8_t), CH_UTF8));
	}
	if (flags & NDR_OUT) {
		if (r->out.name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.alt_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.sid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.name));
		if (*r->out.name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.name, ndr_charset_length(*r->out.name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.alt_name));
		if (*r->out.alt_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.alt_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.alt_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.alt_name, ndr_charset_length(*r->out.alt_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_CHECK(ndr_push_DomainInfoFlags(ndr, NDR_SCALARS, *r->out.flags));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_wbint_InitConnection(struct ndr_pull *ndr, ndr_flags_type flags, struct wbint_InitConnection *r)
{
	uint32_t size_dcname_1 = 0;
	uint32_t length_dcname_1 = 0;
	uint32_t _ptr_name;
	uint32_t size_name_2 = 0;
	uint32_t length_name_2 = 0;
	uint32_t _ptr_alt_name;
	uint32_t size_alt_name_2 = 0;
	uint32_t length_alt_name_2 = 0;
	TALLOC_CTX *_mem_save_name_0 = NULL;
	TALLOC_CTX *_mem_save_name_1 = NULL;
	TALLOC_CTX *_mem_save_alt_name_0 = NULL;
	TALLOC_CTX *_mem_save_alt_name_1 = NULL;
	TALLOC_CTX *_mem_save_sid_0 = NULL;
	TALLOC_CTX *_mem_save_flags_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dcname));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dcname));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.dcname, &size_dcname_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.dcname, &length_dcname_1));
		if (length_dcname_1 > size_dcname_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dcname_1, length_dcname_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dcname_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dcname, length_dcname_1, sizeof(uint8_t), CH_UTF8));
		NDR_PULL_ALLOC(ndr, r->out.name);
		NDR_ZERO_STRUCTP(r->out.name);
		NDR_PULL_ALLOC(ndr, r->out.alt_name);
		NDR_ZERO_STRUCTP(r->out.alt_name);
		NDR_PULL_ALLOC(ndr, r->out.sid);
		NDR_ZERO_STRUCTP(r->out.sid);
		NDR_PULL_ALLOC(ndr, r->out.flags);
		NDR_ZERO_STRUCTP(r->out.flags);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.name);
		}
		_mem_save_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_name));
		if (_ptr_name) {
			NDR_PULL_ALLOC(ndr, *r->out.name);
		} else {
			*r->out.name = NULL;
		}
		if (*r->out.name) {
			_mem_save_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.name, &size_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.name, &length_name_2));
			if (length_name_2 > size_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_name_2, length_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.name, length_name_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.alt_name);
		}
		_mem_save_alt_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.alt_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_alt_name));
		if (_ptr_alt_name) {
			NDR_PULL_ALLOC(ndr, *r->out.alt_name);
		} else {
			*r->out.alt_name = NULL;
		}
		if (*r->out.alt_name) {
			_mem_save_alt_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.alt_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.alt_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.alt_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.alt_name, &size_alt_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.alt_name, &length_alt_name_2));
			if (length_alt_name_2 > size_alt_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_alt_name_2, length_alt_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_alt_name_2, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.alt_name, length_alt_name_2, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alt_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_alt_name_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.sid);
		}
		_mem_save_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.sid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, r->out.sid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.flags);
		}
		_mem_save_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DomainInfoFlags(ndr, NDR_SCALARS, r->out.flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_wbint_InitConnection(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct wbint_InitConnection *r)
{
	ndr_print_struct(ndr, name, "wbint_InitConnection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "wbint_InitConnection");
		ndr->depth++;
		ndr_print_ptr(ndr, "dcname", r->in.dcname);
		ndr->depth++;
		ndr_print_string(ndr, "dcname", r->in.dcname);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "wbint_InitConnection");
		ndr->depth++;
		ndr_print_ptr(ndr, "name", r->out.name);
		ndr->depth++;
		ndr_print_ptr(ndr, "name", *r->out.name);
		ndr->depth++;
		if (*r->out.name) {
			ndr_print_string(ndr, "name", *r->out.name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "alt_name", r->out.alt_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "alt_name", *r->out.alt_name);
		ndr->depth++;
		if (*r->out.alt_name) {
			ndr_print_string(ndr, "alt_name", *r->out.alt_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "sid", r->out.sid);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "sid", r->out.sid);
		ndr->depth--;
		ndr_print_ptr(ndr, "flags", r->out.flags);
		ndr->depth++;
		ndr_print_DomainInfoFlags(ndr, "flags", *r->out.flags);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winbind_SamLogon(struct ndr_push *ndr, ndr_flags_type flags, const struct winbind_SamLogon *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.logon_level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_push_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.logon));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.validation_level));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_push_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.validation));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->out.authoritative));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winbind_SamLogon(struct ndr_pull *ndr, ndr_flags_type flags, struct winbind_SamLogon *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.logon_level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.logon, r->in.logon_level));
		NDR_CHECK(ndr_pull_netr_LogonLevel(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.logon));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.validation_level));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->out.validation, r->in.validation_level));
		NDR_CHECK(ndr_pull_netr_Validation(ndr, NDR_SCALARS|NDR_BUFFERS, &r->out.validation));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->out.authoritative));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winbind_SamLogon(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winbind_SamLogon *r)
{
	ndr_print_struct(ndr, name, "winbind_SamLogon");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_SamLogon");
		ndr->depth++;
		ndr_print_uint16(ndr, "logon_level", r->in.logon_level);
		ndr_print_set_switch_value(ndr, &r->in.logon, r->in.logon_level);
		ndr_print_netr_LogonLevel(ndr, "logon", &r->in.logon);
		ndr_print_uint16(ndr, "validation_level", r->in.validation_level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_SamLogon");
		ndr->depth++;
		ndr_print_set_switch_value(ndr, &r->out.validation, r->in.validation_level);
		ndr_print_netr_Validation(ndr, "validation", &r->out.validation);
		ndr_print_uint8(ndr, "authoritative", r->out.authoritative);
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winbind_DsrUpdateReadOnlyServerDnsRecords(struct ndr_push *ndr, ndr_flags_type flags, const struct winbind_DsrUpdateReadOnlyServerDnsRecords *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.dns_names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.site_name));
		if (r->in.site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.site_name, ndr_charset_length(r->in.site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dns_ttl));
		NDR_CHECK(ndr_push_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dns_names));
	}
	if (flags & NDR_OUT) {
		if (r->out.dns_names == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dns_names));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winbind_DsrUpdateReadOnlyServerDnsRecords(struct ndr_pull *ndr, ndr_flags_type flags, struct winbind_DsrUpdateReadOnlyServerDnsRecords *r)
{
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	TALLOC_CTX *_mem_save_site_name_0 = NULL;
	TALLOC_CTX *_mem_save_dns_names_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->in.site_name);
		} else {
			r->in.site_name = NULL;
		}
		if (r->in.site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.site_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.site_name, &size_site_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.site_name, &length_site_name_1));
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dns_ttl));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.dns_names);
		}
		_mem_save_dns_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.dns_names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.dns_names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.dns_names);
		*r->out.dns_names = *r->in.dns_names;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.dns_names == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.dns_names);
			NDR_ZERO_STRUCTP(r->in.dns_names);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.dns_names);
		}
		_mem_save_dns_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.dns_names, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NL_DNS_NAME_INFO_ARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.dns_names));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_names_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winbind_DsrUpdateReadOnlyServerDnsRecords(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winbind_DsrUpdateReadOnlyServerDnsRecords *r)
{
	ndr_print_struct(ndr, name, "winbind_DsrUpdateReadOnlyServerDnsRecords");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_DsrUpdateReadOnlyServerDnsRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dns_ttl", r->in.dns_ttl);
		ndr_print_ptr(ndr, "dns_names", r->in.dns_names);
		ndr->depth++;
		ndr_print_NL_DNS_NAME_INFO_ARRAY(ndr, "dns_names", r->in.dns_names);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_DsrUpdateReadOnlyServerDnsRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "dns_names", r->out.dns_names);
		ndr->depth++;
		ndr_print_NL_DNS_NAME_INFO_ARRAY(ndr, "dns_names", r->out.dns_names);
		ndr->depth--;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winbind_LogonControl(struct ndr_push *ndr, ndr_flags_type flags, const struct winbind_LogonControl *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.data == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_netr_LogonControlCode(ndr, NDR_SCALARS, r->in.function_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.data, r->in.function_code));
		NDR_CHECK(ndr_push_netr_CONTROL_DATA_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.data));
	}
	if (flags & NDR_OUT) {
		if (r->out.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_push_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winbind_LogonControl(struct ndr_pull *ndr, ndr_flags_type flags, struct winbind_LogonControl *r)
{
	TALLOC_CTX *_mem_save_data_0 = NULL;
	TALLOC_CTX *_mem_save_query_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_netr_LogonControlCode(ndr, NDR_SCALARS, &r->in.function_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.data);
		}
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.data, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.data, r->in.function_code));
		NDR_CHECK(ndr_pull_netr_CONTROL_DATA_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.data));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.query);
		NDR_ZERO_STRUCTP(r->out.query);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.data == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.data);
			NDR_ZERO_STRUCTP(r->in.data);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.query, r->in.level));
		NDR_CHECK(ndr_pull_netr_CONTROL_QUERY_INFORMATION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winbind_LogonControl(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winbind_LogonControl *r)
{
	ndr_print_struct(ndr, name, "winbind_LogonControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_LogonControl");
		ndr->depth++;
		ndr_print_netr_LogonControlCode(ndr, "function_code", r->in.function_code);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.data, r->in.function_code);
		ndr_print_netr_CONTROL_DATA_INFORMATION(ndr, "data", r->in.data);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_LogonControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "query", r->out.query);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.query, r->in.level);
		ndr_print_netr_CONTROL_QUERY_INFORMATION(ndr, "query", r->out.query);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winbind_GetForestTrustInformation(struct ndr_push *ndr, ndr_flags_type flags, const struct winbind_GetForestTrustInformation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.trusted_domain_name));
		if (r->in.trusted_domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.trusted_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.trusted_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.trusted_domain_name, ndr_charset_length(r->in.trusted_domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.forest_trust_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.forest_trust_info));
		if (*r->out.forest_trust_info) {
			NDR_CHECK(ndr_push_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winbind_GetForestTrustInformation(struct ndr_pull *ndr, ndr_flags_type flags, struct winbind_GetForestTrustInformation *r)
{
	uint32_t _ptr_trusted_domain_name;
	uint32_t size_trusted_domain_name_1 = 0;
	uint32_t length_trusted_domain_name_1 = 0;
	uint32_t _ptr_forest_trust_info;
	TALLOC_CTX *_mem_save_trusted_domain_name_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_0 = NULL;
	TALLOC_CTX *_mem_save_forest_trust_info_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_trusted_domain_name));
		if (_ptr_trusted_domain_name) {
			NDR_PULL_ALLOC(ndr, r->in.trusted_domain_name);
		} else {
			r->in.trusted_domain_name = NULL;
		}
		if (r->in.trusted_domain_name) {
			_mem_save_trusted_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.trusted_domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.trusted_domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.trusted_domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.trusted_domain_name, &size_trusted_domain_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.trusted_domain_name, &length_trusted_domain_name_1));
			if (length_trusted_domain_name_1 > size_trusted_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_trusted_domain_name_1, length_trusted_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_trusted_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.trusted_domain_name, length_trusted_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_trusted_domain_name_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		NDR_ZERO_STRUCTP(r->out.forest_trust_info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.forest_trust_info);
		}
		_mem_save_forest_trust_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.forest_trust_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_forest_trust_info));
		if (_ptr_forest_trust_info) {
			NDR_PULL_ALLOC(ndr, *r->out.forest_trust_info);
		} else {
			*r->out.forest_trust_info = NULL;
		}
		if (*r->out.forest_trust_info) {
			_mem_save_forest_trust_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.forest_trust_info, 0);
			NDR_CHECK(ndr_pull_lsa_ForestTrustInformation(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.forest_trust_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_forest_trust_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winbind_GetForestTrustInformation(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winbind_GetForestTrustInformation *r)
{
	ndr_print_struct(ndr, name, "winbind_GetForestTrustInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_GetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		ndr->depth++;
		if (r->in.trusted_domain_name) {
			ndr_print_string(ndr, "trusted_domain_name", r->in.trusted_domain_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_GetForestTrustInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", r->out.forest_trust_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "forest_trust_info", *r->out.forest_trust_info);
		ndr->depth++;
		if (*r->out.forest_trust_info) {
			ndr_print_lsa_ForestTrustInformation(ndr, "forest_trust_info", *r->out.forest_trust_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_winbind_SendToSam(struct ndr_push *ndr, ndr_flags_type flags, const struct winbind_SendToSam *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_netr_SendToSamBase(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.message));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_winbind_SendToSam(struct ndr_pull *ndr, ndr_flags_type flags, struct winbind_SendToSam *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_netr_SendToSamBase(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.message));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winbind_SendToSam(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct winbind_SendToSam *r)
{
	ndr_print_struct(ndr, name, "winbind_SendToSam");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "winbind_SendToSam");
		ndr->depth++;
		ndr_print_netr_SendToSamBase(ndr, "message", &r->in.message);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "winbind_SendToSam");
		ndr->depth++;
		ndr_print_NTSTATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_winbind
static const struct ndr_interface_public_struct winbind_public_structs[] = {
	{
		.name = "wbint_userinfo",
		.struct_size = sizeof(struct wbint_userinfo ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_userinfo,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_userinfo,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_userinfo,
	},
	{
		.name = "wbint_SidArray",
		.struct_size = sizeof(struct wbint_SidArray ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_SidArray,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_SidArray,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_SidArray,
	},
	{
		.name = "wbint_RidArray",
		.struct_size = sizeof(struct wbint_RidArray ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_RidArray,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_RidArray,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_RidArray,
	},
	{
		.name = "wbint_Principal",
		.struct_size = sizeof(struct wbint_Principal ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_Principal,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_Principal,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_Principal,
	},
	{
		.name = "wbint_Principals",
		.struct_size = sizeof(struct wbint_Principals ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_Principals,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_Principals,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_Principals,
	},
	{
		.name = "wbint_userinfos",
		.struct_size = sizeof(struct wbint_userinfos ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_userinfos,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_userinfos,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_userinfos,
	},
	{
		.name = "wbint_Validation",
		.struct_size = sizeof(struct wbint_Validation ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_Validation,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_Validation,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_Validation,
	},
	{
		.name = "wbint_AuthUserInfo",
		.struct_size = sizeof(struct wbint_AuthUserInfo ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_AuthUserInfo,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_AuthUserInfo,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_AuthUserInfo,
	},
	{
		.name = "wbint_PamAuthCrapValidation",
		.struct_size = sizeof(struct wbint_PamAuthCrapValidation ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_wbint_PamAuthCrapValidation,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_wbint_PamAuthCrapValidation,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_wbint_PamAuthCrapValidation,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call winbind_calls[] = {
	{
		"wbint_Ping",
		sizeof(struct wbint_Ping),
		(ndr_push_flags_fn_t) ndr_push_wbint_Ping,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Ping,
		(ndr_print_function_t) ndr_print_wbint_Ping,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupSid",
		sizeof(struct wbint_LookupSid),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupSid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupSid,
		(ndr_print_function_t) ndr_print_wbint_LookupSid,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupSids",
		sizeof(struct wbint_LookupSids),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupSids,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupSids,
		(ndr_print_function_t) ndr_print_wbint_LookupSids,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupName",
		sizeof(struct wbint_LookupName),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupName,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupName,
		(ndr_print_function_t) ndr_print_wbint_LookupName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_Sids2UnixIDs",
		sizeof(struct wbint_Sids2UnixIDs),
		(ndr_push_flags_fn_t) ndr_push_wbint_Sids2UnixIDs,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_Sids2UnixIDs,
		(ndr_print_function_t) ndr_print_wbint_Sids2UnixIDs,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_UnixIDs2Sids",
		sizeof(struct wbint_UnixIDs2Sids),
		(ndr_push_flags_fn_t) ndr_push_wbint_UnixIDs2Sids,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_UnixIDs2Sids,
		(ndr_print_function_t) ndr_print_wbint_UnixIDs2Sids,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_AllocateUid",
		sizeof(struct wbint_AllocateUid),
		(ndr_push_flags_fn_t) ndr_push_wbint_AllocateUid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_AllocateUid,
		(ndr_print_function_t) ndr_print_wbint_AllocateUid,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_AllocateGid",
		sizeof(struct wbint_AllocateGid),
		(ndr_push_flags_fn_t) ndr_push_wbint_AllocateGid,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_AllocateGid,
		(ndr_print_function_t) ndr_print_wbint_AllocateGid,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_GetNssInfo",
		sizeof(struct wbint_GetNssInfo),
		(ndr_push_flags_fn_t) ndr_push_wbint_GetNssInfo,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_GetNssInfo,
		(ndr_print_function_t) ndr_print_wbint_GetNssInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupUserAliases",
		sizeof(struct wbint_LookupUserAliases),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupUserAliases,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupUserAliases,
		(ndr_print_function_t) ndr_print_wbint_LookupUserAliases,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupUserGroups",
		sizeof(struct wbint_LookupUserGroups),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupUserGroups,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupUserGroups,
		(ndr_print_function_t) ndr_print_wbint_LookupUserGroups,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_QuerySequenceNumber",
		sizeof(struct wbint_QuerySequenceNumber),
		(ndr_push_flags_fn_t) ndr_push_wbint_QuerySequenceNumber,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QuerySequenceNumber,
		(ndr_print_function_t) ndr_print_wbint_QuerySequenceNumber,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupGroupMembers",
		sizeof(struct wbint_LookupGroupMembers),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupGroupMembers,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupGroupMembers,
		(ndr_print_function_t) ndr_print_wbint_LookupGroupMembers,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupAliasMembers",
		sizeof(struct wbint_LookupAliasMembers),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupAliasMembers,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupAliasMembers,
		(ndr_print_function_t) ndr_print_wbint_LookupAliasMembers,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_QueryGroupList",
		sizeof(struct wbint_QueryGroupList),
		(ndr_push_flags_fn_t) ndr_push_wbint_QueryGroupList,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QueryGroupList,
		(ndr_print_function_t) ndr_print_wbint_QueryGroupList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_QueryUserRidList",
		sizeof(struct wbint_QueryUserRidList),
		(ndr_push_flags_fn_t) ndr_push_wbint_QueryUserRidList,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_QueryUserRidList,
		(ndr_print_function_t) ndr_print_wbint_QueryUserRidList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_DsGetDcName",
		sizeof(struct wbint_DsGetDcName),
		(ndr_push_flags_fn_t) ndr_push_wbint_DsGetDcName,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_DsGetDcName,
		(ndr_print_function_t) ndr_print_wbint_DsGetDcName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_LookupRids",
		sizeof(struct wbint_LookupRids),
		(ndr_push_flags_fn_t) ndr_push_wbint_LookupRids,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_LookupRids,
		(ndr_print_function_t) ndr_print_wbint_LookupRids,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_CheckMachineAccount",
		sizeof(struct wbint_CheckMachineAccount),
		(ndr_push_flags_fn_t) ndr_push_wbint_CheckMachineAccount,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_CheckMachineAccount,
		(ndr_print_function_t) ndr_print_wbint_CheckMachineAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_ChangeMachineAccount",
		sizeof(struct wbint_ChangeMachineAccount),
		(ndr_push_flags_fn_t) ndr_push_wbint_ChangeMachineAccount,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_ChangeMachineAccount,
		(ndr_print_function_t) ndr_print_wbint_ChangeMachineAccount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_PingDc",
		sizeof(struct wbint_PingDc),
		(ndr_push_flags_fn_t) ndr_push_wbint_PingDc,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PingDc,
		(ndr_print_function_t) ndr_print_wbint_PingDc,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_ListTrustedDomains",
		sizeof(struct wbint_ListTrustedDomains),
		(ndr_push_flags_fn_t) ndr_push_wbint_ListTrustedDomains,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_ListTrustedDomains,
		(ndr_print_function_t) ndr_print_wbint_ListTrustedDomains,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_PamAuth",
		sizeof(struct wbint_PamAuth),
		(ndr_push_flags_fn_t) ndr_push_wbint_PamAuth,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PamAuth,
		(ndr_print_function_t) ndr_print_wbint_PamAuth,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_PamAuthCrap",
		sizeof(struct wbint_PamAuthCrap),
		(ndr_push_flags_fn_t) ndr_push_wbint_PamAuthCrap,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PamAuthCrap,
		(ndr_print_function_t) ndr_print_wbint_PamAuthCrap,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_PamLogOff",
		sizeof(struct wbint_PamLogOff),
		(ndr_push_flags_fn_t) ndr_push_wbint_PamLogOff,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PamLogOff,
		(ndr_print_function_t) ndr_print_wbint_PamLogOff,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_PamAuthCrapChangePassword",
		sizeof(struct wbint_PamAuthCrapChangePassword),
		(ndr_push_flags_fn_t) ndr_push_wbint_PamAuthCrapChangePassword,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PamAuthCrapChangePassword,
		(ndr_print_function_t) ndr_print_wbint_PamAuthCrapChangePassword,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_PamAuthChangePassword",
		sizeof(struct wbint_PamAuthChangePassword),
		(ndr_push_flags_fn_t) ndr_push_wbint_PamAuthChangePassword,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_PamAuthChangePassword,
		(ndr_print_function_t) ndr_print_wbint_PamAuthChangePassword,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"wbint_InitConnection",
		sizeof(struct wbint_InitConnection),
		(ndr_push_flags_fn_t) ndr_push_wbint_InitConnection,
		(ndr_pull_flags_fn_t) ndr_pull_wbint_InitConnection,
		(ndr_print_function_t) ndr_print_wbint_InitConnection,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winbind_SamLogon",
		sizeof(struct winbind_SamLogon),
		(ndr_push_flags_fn_t) ndr_push_winbind_SamLogon,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_SamLogon,
		(ndr_print_function_t) ndr_print_winbind_SamLogon,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winbind_DsrUpdateReadOnlyServerDnsRecords",
		sizeof(struct winbind_DsrUpdateReadOnlyServerDnsRecords),
		(ndr_push_flags_fn_t) ndr_push_winbind_DsrUpdateReadOnlyServerDnsRecords,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_DsrUpdateReadOnlyServerDnsRecords,
		(ndr_print_function_t) ndr_print_winbind_DsrUpdateReadOnlyServerDnsRecords,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winbind_LogonControl",
		sizeof(struct winbind_LogonControl),
		(ndr_push_flags_fn_t) ndr_push_winbind_LogonControl,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_LogonControl,
		(ndr_print_function_t) ndr_print_winbind_LogonControl,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winbind_GetForestTrustInformation",
		sizeof(struct winbind_GetForestTrustInformation),
		(ndr_push_flags_fn_t) ndr_push_winbind_GetForestTrustInformation,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_GetForestTrustInformation,
		(ndr_print_function_t) ndr_print_winbind_GetForestTrustInformation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"winbind_SendToSam",
		sizeof(struct winbind_SendToSam),
		(ndr_push_flags_fn_t) ndr_push_winbind_SendToSam,
		(ndr_pull_flags_fn_t) ndr_pull_winbind_SendToSam,
		(ndr_print_function_t) ndr_print_winbind_SendToSam,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const winbind_endpoint_strings[] = {
	"ncalrpc:", 
};

static const struct ndr_interface_string_array winbind_endpoints = {
	.count	= 1,
	.names	= winbind_endpoint_strings
};

static const char * const winbind_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array winbind_authservices = {
	.count	= 1,
	.names	= winbind_authservice_strings
};


const struct ndr_interface_table ndr_table_winbind = {
	.name		= "winbind",
	.syntax_id	= {
		{0xbf09192c,0xed60,0x4928,{0x9d,0xff},{0xd0,0xd7,0xbc,0xb0,0x3e,0xd8}},
		NDR_WINBIND_VERSION
	},
	.helpstring	= NDR_WINBIND_HELPSTRING,
	.num_calls	= 33,
	.calls		= winbind_calls,
	.num_public_structs	= 9,
	.public_structs		= winbind_public_structs,
	.endpoints	= &winbind_endpoints,
	.authservices	= &winbind_authservices
};

#endif /* SKIP_NDR_TABLE_winbind */
