/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_preg.h"

#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_preg_entry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct preg_entry *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "[", 2, sizeof(uint8_t), CH_DOS));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->keyname));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, ";", 2, sizeof(uint8_t), CH_DOS));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->valuename));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, ";", 2, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->type));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, ";", 2, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_winreg_Data_GPO(&r->data, r->type, ndr->flags)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, ";", 2, sizeof(uint8_t), CH_DOS));
			{
				libndr_flags _flags_save_winreg_Data_GPO = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				{
					struct ndr_push *_ndr_data;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_data, 0, ndr_size_winreg_Data_GPO(&r->data, r->type, ndr->flags)));
					NDR_CHECK(ndr_push_set_switch_value(_ndr_data, &r->data, r->type));
					NDR_CHECK(ndr_push_winreg_Data_GPO(_ndr_data, NDR_SCALARS|NDR_BUFFERS, &r->data));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_data, 0, ndr_size_winreg_Data_GPO(&r->data, r->type, ndr->flags)));
				}
				ndr->flags = _flags_save_winreg_Data_GPO;
			}
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "]", 2, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
			{
				libndr_flags _flags_save_winreg_Data_GPO = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr->flags = _flags_save_winreg_Data_GPO;
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_preg_entry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct preg_entry *r)
{
	uint32_t size__opening_bracket_0 = 0;
	uint32_t size__sep1_0 = 0;
	uint32_t size__sep2_0 = 0;
	uint32_t size__sep3_0 = 0;
	uint32_t size__sep4_0 = 0;
	uint32_t size__closing_bracket_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			size__opening_bracket_0 = 2;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->_opening_bracket, size__opening_bracket_0, sizeof(uint8_t), CH_DOS));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->keyname));
				ndr->flags = _flags_save_string;
			}
			size__sep1_0 = 2;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->_sep1, size__sep1_0, sizeof(uint8_t), CH_DOS));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->valuename));
				ndr->flags = _flags_save_string;
			}
			size__sep2_0 = 2;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->_sep2, size__sep2_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->type));
			size__sep3_0 = 2;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->_sep3, size__sep3_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
			size__sep4_0 = 2;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->_sep4, size__sep4_0, sizeof(uint8_t), CH_DOS));
			{
				libndr_flags _flags_save_winreg_Data_GPO = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				{
					struct ndr_pull *_ndr_data;
					ssize_t sub_size = r->size;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_data, 0, sub_size));
					NDR_CHECK(ndr_pull_set_switch_value(_ndr_data, &r->data, r->type));
					NDR_CHECK(ndr_pull_winreg_Data_GPO(_ndr_data, NDR_SCALARS|NDR_BUFFERS, &r->data));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_data, 0, sub_size));
				}
				ndr->flags = _flags_save_winreg_Data_GPO;
			}
			size__closing_bracket_0 = 2;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->_closing_bracket, size__closing_bracket_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
			{
				libndr_flags _flags_save_winreg_Data_GPO = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr->flags = _flags_save_winreg_Data_GPO;
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_preg_entry(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct preg_entry *r)
{
	ndr_print_preg_entry(ndr, name, r);
}

_PUBLIC_ void ndr_print_preg_entry(struct ndr_print *ndr, const char *name, const struct preg_entry *r)
{
	ndr_print_struct(ndr, name, "preg_entry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			ndr_print_string(ndr, "keyname", r->keyname);
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			ndr_print_string(ndr, "valuename", r->valuename);
			ndr->flags = _flags_save_string;
		}
		ndr_print_winreg_Type(ndr, "type", r->type);
		ndr_print_uint32(ndr, "size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_winreg_Data_GPO(&r->data, r->type, ndr->flags):r->size);
		{
			libndr_flags _flags_save_winreg_Data_GPO = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_set_switch_value(ndr, &r->data, r->type);
			ndr_print_winreg_Data_GPO(ndr, "data", &r->data);
			ndr->flags = _flags_save_winreg_Data_GPO;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_preg_header(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct preg_header *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "PReg", 4, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_preg_header(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct preg_header *r)
{
	uint32_t size_signature_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		size_signature_0 = 4;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->signature, size_signature_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_preg_header(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct preg_header *r)
{
	ndr_print_preg_header(ndr, name, r);
}

_PUBLIC_ void ndr_print_preg_header(struct ndr_print *ndr, const char *name, const struct preg_header *r)
{
	ndr_print_struct(ndr, name, "preg_header");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"PReg":r->signature);
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->version);
	ndr->depth--;
}

static void ndr_print_flags_preg_file(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct preg_file *r)
{
	ndr_print_preg_file(ndr, name, r);
}

_PUBLIC_ void ndr_print_preg_file(struct ndr_print *ndr, const char *name, const struct preg_file *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "preg_file");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_preg_header(ndr, "header", &r->header);
		ndr_print_uint32(ndr, "num_entries", r->num_entries);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->num_entries));
		ndr->depth++;
		for (cntr_entries_0 = 0; cntr_entries_0 < (r->num_entries); cntr_entries_0++) {
			ndr_print_preg_entry(ndr, "entries", &r->entries[cntr_entries_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_preg
static const struct ndr_interface_public_struct preg_public_structs[] = {
	{
		.name = "preg_entry",
		.struct_size = sizeof(struct preg_entry ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_preg_entry,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_preg_entry,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_preg_entry,
	},
	{
		.name = "preg_header",
		.struct_size = sizeof(struct preg_header ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_preg_header,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_preg_header,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_preg_header,
	},
	{
		.name = "preg_file",
		.struct_size = sizeof(struct preg_file ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_preg_file,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_preg_file,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_preg_file,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call preg_calls[] = {
	{ .name = NULL }
};

static const char * const preg_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\preg]", 
};

static const struct ndr_interface_string_array preg_endpoints = {
	.count	= 1,
	.names	= preg_endpoint_strings
};

static const char * const preg_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array preg_authservices = {
	.count	= 1,
	.names	= preg_authservice_strings
};


const struct ndr_interface_table ndr_table_preg = {
	.name		= "preg",
	.syntax_id	= {
		{0x67655250,0x0000,0x0000,{0x00,0x00},{0x00,0x00,0x00,0x00}},
		NDR_PREG_VERSION
	},
	.helpstring	= NDR_PREG_HELPSTRING,
	.num_calls	= 0,
	.calls		= preg_calls,
	.num_public_structs	= 3,
	.public_structs		= preg_public_structs,
	.endpoints	= &preg_endpoints,
	.authservices	= &preg_authservices
};

#endif /* SKIP_NDR_TABLE_preg */
