/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_negoex.h"

#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_negoex_AUTH_SCHEME(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_AUTH_SCHEME *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_negoex_AUTH_SCHEME(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_AUTH_SCHEME *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_negoex_AUTH_SCHEME(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct negoex_AUTH_SCHEME *r)
{
	ndr_print_negoex_AUTH_SCHEME(ndr, name, r);
}

_PUBLIC_ void ndr_print_negoex_AUTH_SCHEME(struct ndr_print *ndr, const char *name, const struct negoex_AUTH_SCHEME *r)
{
	ndr_print_struct(ndr, name, "negoex_AUTH_SCHEME");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_negoex_AUTH_SCHEME_VECTOR(struct ndr_print *ndr, const char *name, const struct negoex_AUTH_SCHEME_VECTOR *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "negoex_AUTH_SCHEME_VECTOR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_negoex_AUTH_SCHEME(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_negoex_ExtensionTypes(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum negoex_ExtensionTypes r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_ExtensionTypes(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum negoex_ExtensionTypes *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_ExtensionTypes(struct ndr_print *ndr, const char *name, enum negoex_ExtensionTypes r)
{
	const char *val = NULL;

	switch (r) {
		case NEGOEX_EXTENSION_TYPE_TODO: val = "NEGOEX_EXTENSION_TYPE_TODO"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_negoex_EXTENSION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_EXTENSION *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_negoex_ExtensionTypes(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_negoex_EXTENSION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_EXTENSION *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_negoex_ExtensionTypes(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_negoex_EXTENSION(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct negoex_EXTENSION *r)
{
	ndr_print_negoex_EXTENSION(ndr, name, r);
}

_PUBLIC_ void ndr_print_negoex_EXTENSION(struct ndr_print *ndr, const char *name, const struct negoex_EXTENSION *r)
{
	ndr_print_struct(ndr, name, "negoex_EXTENSION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_negoex_ExtensionTypes(ndr, "type", r->type);
	ndr_print_negoex_BYTE_VECTOR(ndr, "value", &r->value);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_negoex_EXTENSION_VECTOR(struct ndr_print *ndr, const char *name, const struct negoex_EXTENSION_VECTOR *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "negoex_EXTENSION_VECTOR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_negoex_EXTENSION(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_negoex_ChecksumSchemes(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum negoex_ChecksumSchemes r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_ChecksumSchemes(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum negoex_ChecksumSchemes *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_ChecksumSchemes(struct ndr_print *ndr, const char *name, enum negoex_ChecksumSchemes r)
{
	const char *val = NULL;

	switch (r) {
		case NEGOEX_CHECKSUM_SCHEME_RFC3961: val = "NEGOEX_CHECKSUM_SCHEME_RFC3961"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_negoex_CHECKSUM(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_CHECKSUM *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 20));
		NDR_CHECK(ndr_push_negoex_ChecksumSchemes(ndr, NDR_SCALARS, r->scheme));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_CHECKSUM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_CHECKSUM *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->header_length));
		NDR_CHECK(ndr_pull_negoex_ChecksumSchemes(ndr, NDR_SCALARS, &r->scheme));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_CHECKSUM(struct ndr_print *ndr, const char *name, const struct negoex_CHECKSUM *r)
{
	ndr_print_struct(ndr, name, "negoex_CHECKSUM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "header_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?20:r->header_length);
	ndr_print_negoex_ChecksumSchemes(ndr, "scheme", r->scheme);
	ndr_print_uint32(ndr, "type", r->type);
	ndr_print_negoex_BYTE_VECTOR(ndr, "value", &r->value);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_negoex_AlertReason(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum negoex_AlertReason r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_AlertReason(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum negoex_AlertReason *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_AlertReason(struct ndr_print *ndr, const char *name, enum negoex_AlertReason r)
{
	const char *val = NULL;

	switch (r) {
		case NEGOEX_ALERT_VERIFY_NO_KEY: val = "NEGOEX_ALERT_VERIFY_NO_KEY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_negoex_ALERT_PULSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_ALERT_PULSE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 4));
		NDR_CHECK(ndr_push_negoex_AlertReason(ndr, NDR_SCALARS, r->reason));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_negoex_ALERT_PULSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_ALERT_PULSE *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->header_length));
		NDR_CHECK(ndr_pull_negoex_AlertReason(ndr, NDR_SCALARS, &r->reason));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_negoex_ALERT_PULSE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct negoex_ALERT_PULSE *r)
{
	ndr_print_negoex_ALERT_PULSE(ndr, name, r);
}

_PUBLIC_ void ndr_print_negoex_ALERT_PULSE(struct ndr_print *ndr, const char *name, const struct negoex_ALERT_PULSE *r)
{
	ndr_print_struct(ndr, name, "negoex_ALERT_PULSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "header_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?4:r->header_length);
	ndr_print_negoex_AlertReason(ndr, "reason", r->reason);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_negoex_AlertTypes(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum negoex_AlertTypes r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_AlertTypes(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum negoex_AlertTypes *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_AlertTypes(struct ndr_print *ndr, const char *name, enum negoex_AlertTypes r)
{
	const char *val = NULL;

	switch (r) {
		case NEGOEX_ALERT_TYPE_PULSE: val = "NEGOEX_ALERT_TYPE_PULSE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_negoex_ALERT(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_ALERT *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_negoex_AlertTypes(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_negoex_ALERT(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_ALERT *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_negoex_AlertTypes(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_negoex_ALERT(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct negoex_ALERT *r)
{
	ndr_print_negoex_ALERT(ndr, name, r);
}

_PUBLIC_ void ndr_print_negoex_ALERT(struct ndr_print *ndr, const char *name, const struct negoex_ALERT *r)
{
	ndr_print_struct(ndr, name, "negoex_ALERT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_negoex_AlertTypes(ndr, "type", r->type);
	ndr_print_negoex_BYTE_VECTOR(ndr, "value", &r->value);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_negoex_ALERT_VECTOR(struct ndr_print *ndr, const char *name, const struct negoex_ALERT_VECTOR *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "negoex_ALERT_VECTOR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_negoex_ALERT(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_negoex_MESSAGE_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum negoex_MESSAGE_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_negoex_MESSAGE_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum negoex_MESSAGE_TYPE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_MESSAGE_TYPE(struct ndr_print *ndr, const char *name, enum negoex_MESSAGE_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO: val = "NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO"; break;
		case NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO: val = "NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO"; break;
		case NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA: val = "NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA"; break;
		case NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA: val = "NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA"; break;
		case NEGOEX_MESSAGE_TYPE_CHALLENGE: val = "NEGOEX_MESSAGE_TYPE_CHALLENGE"; break;
		case NEGOEX_MESSAGE_TYPE_AP_REQUEST: val = "NEGOEX_MESSAGE_TYPE_AP_REQUEST"; break;
		case NEGOEX_MESSAGE_TYPE_VERIFY: val = "NEGOEX_MESSAGE_TYPE_VERIFY"; break;
		case NEGOEX_MESSAGE_TYPE_ALERT: val = "NEGOEX_MESSAGE_TYPE_ALERT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_negoex_NEGO_PAYLOAD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_NEGO_PAYLOAD *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			{
				libndr_flags _flags_save_uint8 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->random, 32));
				ndr->flags = _flags_save_uint8;
			}
			NDR_CHECK(ndr_push_udlong(ndr, NDR_SCALARS, NEGOEX_PROTOCOL_VERSION_0));
			NDR_CHECK(ndr_push_negoex_AUTH_SCHEME_VECTOR(ndr, NDR_SCALARS, &r->auth_schemes));
			NDR_CHECK(ndr_push_negoex_EXTENSION_VECTOR(ndr, NDR_SCALARS, &r->extensions));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_negoex_AUTH_SCHEME_VECTOR(ndr, NDR_BUFFERS, &r->auth_schemes));
			NDR_CHECK(ndr_push_negoex_EXTENSION_VECTOR(ndr, NDR_BUFFERS, &r->extensions));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_NEGO_PAYLOAD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_NEGO_PAYLOAD *r)
{
	uint32_t size_random_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			{
				libndr_flags _flags_save_uint8 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
				size_random_0 = 32;
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->random, size_random_0));
				ndr->flags = _flags_save_uint8;
			}
			NDR_CHECK(ndr_pull_udlong(ndr, NDR_SCALARS, &r->protocol_version));
			NDR_CHECK(ndr_pull_negoex_AUTH_SCHEME_VECTOR(ndr, NDR_SCALARS, &r->auth_schemes));
			NDR_CHECK(ndr_pull_negoex_EXTENSION_VECTOR(ndr, NDR_SCALARS, &r->extensions));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_negoex_AUTH_SCHEME_VECTOR(ndr, NDR_BUFFERS, &r->auth_schemes));
			NDR_CHECK(ndr_pull_negoex_EXTENSION_VECTOR(ndr, NDR_BUFFERS, &r->extensions));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_NEGO_PAYLOAD(struct ndr_print *ndr, const char *name, const struct negoex_NEGO_PAYLOAD *r)
{
	ndr_print_struct(ndr, name, "negoex_NEGO_PAYLOAD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			ndr_print_array_uint8(ndr, "random", r->random, 32);
			ndr->flags = _flags_save_uint8;
		}
		ndr_print_udlong(ndr, "protocol_version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NEGOEX_PROTOCOL_VERSION_0:r->protocol_version);
		ndr_print_negoex_AUTH_SCHEME_VECTOR(ndr, "auth_schemes", &r->auth_schemes);
		ndr_print_negoex_EXTENSION_VECTOR(ndr, "extensions", &r->extensions);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_negoex_EXCHANGE_PAYLOAD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_EXCHANGE_PAYLOAD *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_negoex_AUTH_SCHEME(ndr, NDR_SCALARS, &r->auth_scheme));
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->exchange));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->exchange));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_EXCHANGE_PAYLOAD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_EXCHANGE_PAYLOAD *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_negoex_AUTH_SCHEME(ndr, NDR_SCALARS, &r->auth_scheme));
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_SCALARS, &r->exchange));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_negoex_BYTE_VECTOR(ndr, NDR_BUFFERS, &r->exchange));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_EXCHANGE_PAYLOAD(struct ndr_print *ndr, const char *name, const struct negoex_EXCHANGE_PAYLOAD *r)
{
	ndr_print_struct(ndr, name, "negoex_EXCHANGE_PAYLOAD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_negoex_AUTH_SCHEME(ndr, "auth_scheme", &r->auth_scheme);
	ndr_print_negoex_BYTE_VECTOR(ndr, "exchange", &r->exchange);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_negoex_VERIFY_PAYLOAD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_VERIFY_PAYLOAD *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_negoex_AUTH_SCHEME(ndr, NDR_SCALARS, &r->auth_scheme));
		NDR_CHECK(ndr_push_negoex_CHECKSUM(ndr, NDR_SCALARS, &r->checksum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_negoex_CHECKSUM(ndr, NDR_BUFFERS, &r->checksum));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_VERIFY_PAYLOAD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_VERIFY_PAYLOAD *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_negoex_AUTH_SCHEME(ndr, NDR_SCALARS, &r->auth_scheme));
		NDR_CHECK(ndr_pull_negoex_CHECKSUM(ndr, NDR_SCALARS, &r->checksum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_negoex_CHECKSUM(ndr, NDR_BUFFERS, &r->checksum));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_VERIFY_PAYLOAD(struct ndr_print *ndr, const char *name, const struct negoex_VERIFY_PAYLOAD *r)
{
	ndr_print_struct(ndr, name, "negoex_VERIFY_PAYLOAD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_negoex_AUTH_SCHEME(ndr, "auth_scheme", &r->auth_scheme);
	ndr_print_negoex_CHECKSUM(ndr, "checksum", &r->checksum);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_negoex_ALERT_PAYLOAD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_ALERT_PAYLOAD *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_negoex_AUTH_SCHEME(ndr, NDR_SCALARS, &r->auth_scheme));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_negoex_ALERT_VECTOR(ndr, NDR_SCALARS, &r->alerts));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_negoex_ALERT_VECTOR(ndr, NDR_BUFFERS, &r->alerts));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_negoex_ALERT_PAYLOAD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct negoex_ALERT_PAYLOAD *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_negoex_AUTH_SCHEME(ndr, NDR_SCALARS, &r->auth_scheme));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_negoex_ALERT_VECTOR(ndr, NDR_SCALARS, &r->alerts));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_negoex_ALERT_VECTOR(ndr, NDR_BUFFERS, &r->alerts));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_ALERT_PAYLOAD(struct ndr_print *ndr, const char *name, const struct negoex_ALERT_PAYLOAD *r)
{
	ndr_print_struct(ndr, name, "negoex_ALERT_PAYLOAD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_negoex_AUTH_SCHEME(ndr, "auth_scheme", &r->auth_scheme);
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_negoex_ALERT_VECTOR(ndr, "alerts", &r->alerts);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_negoex_PAYLOAD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union negoex_PAYLOAD *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO: {
				NDR_CHECK(ndr_push_negoex_NEGO_PAYLOAD(ndr, NDR_SCALARS, &r->nego));
			break; }

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO: {
				NDR_CHECK(ndr_push_negoex_NEGO_PAYLOAD(ndr, NDR_SCALARS, &r->nego));
			break; }

			case NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA: {
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA: {
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_CHALLENGE: {
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_AP_REQUEST: {
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_VERIFY: {
				NDR_CHECK(ndr_push_negoex_VERIFY_PAYLOAD(ndr, NDR_SCALARS, &r->verify));
			break; }

			case NEGOEX_MESSAGE_TYPE_ALERT: {
				NDR_CHECK(ndr_push_negoex_ALERT_PAYLOAD(ndr, NDR_SCALARS, &r->alert));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO:
				NDR_CHECK(ndr_push_negoex_NEGO_PAYLOAD(ndr, NDR_BUFFERS, &r->nego));
			break;

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO:
				NDR_CHECK(ndr_push_negoex_NEGO_PAYLOAD(ndr, NDR_BUFFERS, &r->nego));
			break;

			case NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA:
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA:
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_CHALLENGE:
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_AP_REQUEST:
				NDR_CHECK(ndr_push_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_VERIFY:
				NDR_CHECK(ndr_push_negoex_VERIFY_PAYLOAD(ndr, NDR_BUFFERS, &r->verify));
			break;

			case NEGOEX_MESSAGE_TYPE_ALERT:
				NDR_CHECK(ndr_push_negoex_ALERT_PAYLOAD(ndr, NDR_BUFFERS, &r->alert));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_negoex_PAYLOAD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union negoex_PAYLOAD *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO: {
				NDR_CHECK(ndr_pull_negoex_NEGO_PAYLOAD(ndr, NDR_SCALARS, &r->nego));
			break; }

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO: {
				NDR_CHECK(ndr_pull_negoex_NEGO_PAYLOAD(ndr, NDR_SCALARS, &r->nego));
			break; }

			case NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA: {
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA: {
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_CHALLENGE: {
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_AP_REQUEST: {
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_SCALARS, &r->exchange));
			break; }

			case NEGOEX_MESSAGE_TYPE_VERIFY: {
				NDR_CHECK(ndr_pull_negoex_VERIFY_PAYLOAD(ndr, NDR_SCALARS, &r->verify));
			break; }

			case NEGOEX_MESSAGE_TYPE_ALERT: {
				NDR_CHECK(ndr_pull_negoex_ALERT_PAYLOAD(ndr, NDR_SCALARS, &r->alert));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO:
				NDR_CHECK(ndr_pull_negoex_NEGO_PAYLOAD(ndr, NDR_BUFFERS, &r->nego));
			break;

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO:
				NDR_CHECK(ndr_pull_negoex_NEGO_PAYLOAD(ndr, NDR_BUFFERS, &r->nego));
			break;

			case NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA:
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA:
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_CHALLENGE:
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_AP_REQUEST:
				NDR_CHECK(ndr_pull_negoex_EXCHANGE_PAYLOAD(ndr, NDR_BUFFERS, &r->exchange));
			break;

			case NEGOEX_MESSAGE_TYPE_VERIFY:
				NDR_CHECK(ndr_pull_negoex_VERIFY_PAYLOAD(ndr, NDR_BUFFERS, &r->verify));
			break;

			case NEGOEX_MESSAGE_TYPE_ALERT:
				NDR_CHECK(ndr_pull_negoex_ALERT_PAYLOAD(ndr, NDR_BUFFERS, &r->alert));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_negoex_PAYLOAD(struct ndr_print *ndr, const char *name, const union negoex_PAYLOAD *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "negoex_PAYLOAD");
	switch (level) {
		case NEGOEX_MESSAGE_TYPE_INITIATOR_NEGO:
			ndr_print_negoex_NEGO_PAYLOAD(ndr, "nego", &r->nego);
		break;

		case NEGOEX_MESSAGE_TYPE_ACCEPTOR_NEGO:
			ndr_print_negoex_NEGO_PAYLOAD(ndr, "nego", &r->nego);
		break;

		case NEGOEX_MESSAGE_TYPE_INITIATOR_META_DATA:
			ndr_print_negoex_EXCHANGE_PAYLOAD(ndr, "exchange", &r->exchange);
		break;

		case NEGOEX_MESSAGE_TYPE_ACCEPTOR_META_DATA:
			ndr_print_negoex_EXCHANGE_PAYLOAD(ndr, "exchange", &r->exchange);
		break;

		case NEGOEX_MESSAGE_TYPE_CHALLENGE:
			ndr_print_negoex_EXCHANGE_PAYLOAD(ndr, "exchange", &r->exchange);
		break;

		case NEGOEX_MESSAGE_TYPE_AP_REQUEST:
			ndr_print_negoex_EXCHANGE_PAYLOAD(ndr, "exchange", &r->exchange);
		break;

		case NEGOEX_MESSAGE_TYPE_VERIFY:
			ndr_print_negoex_VERIFY_PAYLOAD(ndr, "verify", &r->verify);
		break;

		case NEGOEX_MESSAGE_TYPE_ALERT:
			ndr_print_negoex_ALERT_PAYLOAD(ndr, "alert", &r->alert);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_negoex_MESSAGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct negoex_MESSAGE *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "NEGOEXTS", 8, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_negoex_MESSAGE_TYPE(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sequence_number));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_negoex_MESSAGE_header_length(r)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_negoex_MESSAGE(r, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->conversation_id));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->p, r->type));
		NDR_CHECK(ndr_push_negoex_PAYLOAD(ndr, NDR_SCALARS, &r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->p, r->type));
		NDR_CHECK(ndr_push_negoex_PAYLOAD(ndr, NDR_BUFFERS, &r->p));
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_negoex_MESSAGE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct negoex_MESSAGE *r)
{
	ndr_print_negoex_MESSAGE(ndr, name, r);
}

_PUBLIC_ void ndr_print_negoex_MESSAGE(struct ndr_print *ndr, const char *name, const struct negoex_MESSAGE *r)
{
	ndr_print_struct(ndr, name, "negoex_MESSAGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"NEGOEXTS":r->signature);
	ndr_print_negoex_MESSAGE_TYPE(ndr, "type", r->type);
	ndr_print_uint32(ndr, "sequence_number", r->sequence_number);
	ndr_print_uint32(ndr, "header_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_negoex_MESSAGE_header_length(r):r->header_length);
	ndr_print_uint32(ndr, "message_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_negoex_MESSAGE(r, ndr->flags):r->message_length);
	ndr_print_GUID(ndr, "conversation_id", &r->conversation_id);
	ndr_print_set_switch_value(ndr, &r->p, r->type);
	ndr_print_negoex_PAYLOAD(ndr, "p", &r->p);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_negoex_MESSAGE(const struct negoex_MESSAGE *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_negoex_MESSAGE);
}

static void ndr_print_flags_negoex_MESSAGE_ARRAY(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct negoex_MESSAGE_ARRAY *r)
{
	ndr_print_negoex_MESSAGE_ARRAY(ndr, name, r);
}

_PUBLIC_ void ndr_print_negoex_MESSAGE_ARRAY(struct ndr_print *ndr, const char *name, const struct negoex_MESSAGE_ARRAY *r)
{
	uint32_t cntr_messages_0;
	ndr_print_struct(ndr, name, "negoex_MESSAGE_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", r->count);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "messages", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_messages_0 = 0; cntr_messages_0 < (r->count); cntr_messages_0++) {
			ndr_print_negoex_MESSAGE(ndr, "messages", &r->messages[cntr_messages_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_negoex
static const struct ndr_interface_public_struct negoex_public_structs[] = {
	{
		.name = "negoex_AUTH_SCHEME",
		.struct_size = sizeof(struct negoex_AUTH_SCHEME ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_negoex_AUTH_SCHEME,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_negoex_AUTH_SCHEME,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_negoex_AUTH_SCHEME,
	},
	{
		.name = "negoex_EXTENSION",
		.struct_size = sizeof(struct negoex_EXTENSION ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_negoex_EXTENSION,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_negoex_EXTENSION,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_negoex_EXTENSION,
	},
	{
		.name = "negoex_ALERT_PULSE",
		.struct_size = sizeof(struct negoex_ALERT_PULSE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_negoex_ALERT_PULSE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_negoex_ALERT_PULSE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_negoex_ALERT_PULSE,
	},
	{
		.name = "negoex_ALERT",
		.struct_size = sizeof(struct negoex_ALERT ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_negoex_ALERT,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_negoex_ALERT,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_negoex_ALERT,
	},
	{
		.name = "negoex_MESSAGE",
		.struct_size = sizeof(struct negoex_MESSAGE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_negoex_MESSAGE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_negoex_MESSAGE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_negoex_MESSAGE,
	},
	{
		.name = "negoex_MESSAGE_ARRAY",
		.struct_size = sizeof(struct negoex_MESSAGE_ARRAY ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_negoex_MESSAGE_ARRAY,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_negoex_MESSAGE_ARRAY,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_negoex_MESSAGE_ARRAY,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call negoex_calls[] = {
	{ .name = NULL }
};

static const char * const negoex_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\negoex]", 
};

static const struct ndr_interface_string_array negoex_endpoints = {
	.count	= 1,
	.names	= negoex_endpoint_strings
};

static const char * const negoex_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array negoex_authservices = {
	.count	= 1,
	.names	= negoex_authservice_strings
};


const struct ndr_interface_table ndr_table_negoex = {
	.name		= "negoex",
	.syntax_id	= {
		{0xfcc30ddc,0x98d0,0x11e5,{0x8a,0x56},{0x83,0xe9,0xa6,0x70,0x6f,0x2f}},
		NDR_NEGOEX_VERSION
	},
	.helpstring	= NDR_NEGOEX_HELPSTRING,
	.num_calls	= 0,
	.calls		= negoex_calls,
	.num_public_structs	= 6,
	.public_structs		= negoex_public_structs,
	.endpoints	= &negoex_endpoints,
	.authservices	= &negoex_authservices
};

#endif /* SKIP_NDR_TABLE_negoex */
