/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_krb5ccache.h"

static enum ndr_err_code ndr_push_PRINCIPAL(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct PRINCIPAL *r)
{
	uint32_t cntr_components_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->component_count));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->realm));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8);
			for (cntr_components_0 = 0; cntr_components_0 < (r->component_count); cntr_components_0++) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->components[cntr_components_0]));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PRINCIPAL(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct PRINCIPAL *r)
{
	uint32_t size_components_0 = 0;
	uint32_t cntr_components_0;
	TALLOC_CTX *_mem_save_components_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->component_count));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->realm));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8);
			size_components_0 = r->component_count;
			NDR_PULL_ALLOC_N(ndr, r->components, size_components_0);
			_mem_save_components_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->components, 0);
			for (cntr_components_0 = 0; cntr_components_0 < (size_components_0); cntr_components_0++) {
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->components[cntr_components_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_components_0, 0);
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PRINCIPAL(struct ndr_print *ndr, const char *name, const struct PRINCIPAL *r)
{
	uint32_t cntr_components_0;
	ndr_print_struct(ndr, name, "PRINCIPAL");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "name_type", r->name_type);
	ndr_print_uint32(ndr, "component_count", r->component_count);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8);
		ndr_print_string(ndr, "realm", r->realm);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "components", (uint32_t)(r->component_count));
		ndr->depth++;
		for (cntr_components_0 = 0; cntr_components_0 < (r->component_count); cntr_components_0++) {
			ndr_print_string(ndr, "components", r->components[cntr_components_0]);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_KEYBLOCK(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct KEYBLOCK *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->enctype));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_KEYBLOCK(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct KEYBLOCK *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->enctype));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_KEYBLOCK(struct ndr_print *ndr, const char *name, const struct KEYBLOCK *r)
{
	ndr_print_struct(ndr, name, "KEYBLOCK");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "enctype", r->enctype);
	ndr_print_DATA_BLOB(ndr, "data", r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ADDRESS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ADDRESS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->addrtype));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ADDRESS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ADDRESS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->addrtype));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ADDRESS(struct ndr_print *ndr, const char *name, const struct ADDRESS *r)
{
	ndr_print_struct(ndr, name, "ADDRESS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "addrtype", r->addrtype);
	ndr_print_DATA_BLOB(ndr, "data", r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ADDRESSES(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ADDRESSES *r)
{
	uint32_t cntr_data_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_data_0 = 0; cntr_data_0 < (r->count); cntr_data_0++) {
			NDR_CHECK(ndr_push_ADDRESS(ndr, NDR_SCALARS, &r->data[cntr_data_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ADDRESSES(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ADDRESSES *r)
{
	uint32_t size_data_0 = 0;
	uint32_t cntr_data_0;
	TALLOC_CTX *_mem_save_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		size_data_0 = r->count;
		NDR_PULL_ALLOC_N(ndr, r->data, size_data_0);
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
		for (cntr_data_0 = 0; cntr_data_0 < (size_data_0); cntr_data_0++) {
			NDR_CHECK(ndr_pull_ADDRESS(ndr, NDR_SCALARS, &r->data[cntr_data_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ADDRESSES(struct ndr_print *ndr, const char *name, const struct ADDRESSES *r)
{
	uint32_t cntr_data_0;
	ndr_print_struct(ndr, name, "ADDRESSES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "data", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_data_0 = 0; cntr_data_0 < (r->count); cntr_data_0++) {
		ndr_print_ADDRESS(ndr, "data", &r->data[cntr_data_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_AUTHDATUM(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct AUTHDATUM *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ad_type));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_AUTHDATUM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct AUTHDATUM *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ad_type));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_AUTHDATUM(struct ndr_print *ndr, const char *name, const struct AUTHDATUM *r)
{
	ndr_print_struct(ndr, name, "AUTHDATUM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "ad_type", r->ad_type);
	ndr_print_DATA_BLOB(ndr, "data", r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_AUTHDATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct AUTHDATA *r)
{
	uint32_t cntr_data_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_data_0 = 0; cntr_data_0 < (r->count); cntr_data_0++) {
			NDR_CHECK(ndr_push_AUTHDATUM(ndr, NDR_SCALARS, &r->data[cntr_data_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_AUTHDATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct AUTHDATA *r)
{
	uint32_t size_data_0 = 0;
	uint32_t cntr_data_0;
	TALLOC_CTX *_mem_save_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		size_data_0 = r->count;
		NDR_PULL_ALLOC_N(ndr, r->data, size_data_0);
		_mem_save_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->data, 0);
		for (cntr_data_0 = 0; cntr_data_0 < (size_data_0); cntr_data_0++) {
			NDR_CHECK(ndr_pull_AUTHDATUM(ndr, NDR_SCALARS, &r->data[cntr_data_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_data_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_AUTHDATA(struct ndr_print *ndr, const char *name, const struct AUTHDATA *r)
{
	uint32_t cntr_data_0;
	ndr_print_struct(ndr, name, "AUTHDATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "data", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_data_0 = 0; cntr_data_0 < (r->count); cntr_data_0++) {
		ndr_print_AUTHDATUM(ndr, "data", &r->data[cntr_data_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CREDENTIAL(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CREDENTIAL *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_PRINCIPAL(ndr, NDR_SCALARS, &r->client));
		NDR_CHECK(ndr_push_PRINCIPAL(ndr, NDR_SCALARS, &r->server));
		NDR_CHECK(ndr_push_KEYBLOCK(ndr, NDR_SCALARS, &r->keyblock));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->authtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->starttime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->endtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->renew_till));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->is_skey));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ticket_flags));
		NDR_CHECK(ndr_push_ADDRESSES(ndr, NDR_SCALARS, &r->addresses));
		NDR_CHECK(ndr_push_AUTHDATA(ndr, NDR_SCALARS, &r->authdata));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->ticket));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->second_ticket));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CREDENTIAL(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CREDENTIAL *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_PRINCIPAL(ndr, NDR_SCALARS, &r->client));
		NDR_CHECK(ndr_pull_PRINCIPAL(ndr, NDR_SCALARS, &r->server));
		NDR_CHECK(ndr_pull_KEYBLOCK(ndr, NDR_SCALARS, &r->keyblock));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->authtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->starttime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->endtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->renew_till));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->is_skey));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ticket_flags));
		NDR_CHECK(ndr_pull_ADDRESSES(ndr, NDR_SCALARS, &r->addresses));
		NDR_CHECK(ndr_pull_AUTHDATA(ndr, NDR_SCALARS, &r->authdata));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->ticket));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->second_ticket));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CREDENTIAL(struct ndr_print *ndr, const char *name, const struct CREDENTIAL *r)
{
	ndr_print_struct(ndr, name, "CREDENTIAL");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_PRINCIPAL(ndr, "client", &r->client);
	ndr_print_PRINCIPAL(ndr, "server", &r->server);
	ndr_print_KEYBLOCK(ndr, "keyblock", &r->keyblock);
	ndr_print_uint32(ndr, "authtime", r->authtime);
	ndr_print_uint32(ndr, "starttime", r->starttime);
	ndr_print_uint32(ndr, "endtime", r->endtime);
	ndr_print_uint32(ndr, "renew_till", r->renew_till);
	ndr_print_uint8(ndr, "is_skey", r->is_skey);
	ndr_print_uint32(ndr, "ticket_flags", r->ticket_flags);
	ndr_print_ADDRESSES(ndr, "addresses", &r->addresses);
	ndr_print_AUTHDATA(ndr, "authdata", &r->authdata);
	ndr_print_DATA_BLOB(ndr, "ticket", r->ticket);
	ndr_print_DATA_BLOB(ndr, "second_ticket", r->second_ticket);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DELTATIME_TAG(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DELTATIME_TAG *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DELTATIME_TAG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DELTATIME_TAG *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->kdc_sec_offset));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->kdc_usec_offset));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DELTATIME_TAG(struct ndr_print *ndr, const char *name, const struct DELTATIME_TAG *r)
{
	ndr_print_struct(ndr, name, "DELTATIME_TAG");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_int32(ndr, "kdc_sec_offset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->kdc_sec_offset);
	ndr_print_int32(ndr, "kdc_usec_offset", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->kdc_usec_offset);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FIELD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union FIELD *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_DELTATIME_TAG(ndr, NDR_SCALARS, &r->deltatime_tag));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FIELD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union FIELD *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_DELTATIME_TAG(ndr, NDR_SCALARS, &r->deltatime_tag));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FIELD(struct ndr_print *ndr, const char *name, const union FIELD *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "FIELD");
	switch (level) {
		case 1:
			ndr_print_DELTATIME_TAG(ndr, "deltatime_tag", &r->deltatime_tag);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_V4TAG(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct V4TAG *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 1));
		{
			struct ndr_push *_ndr_field;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_field, 2, -1));
			NDR_CHECK(ndr_push_set_switch_value(_ndr_field, &r->field, 1));
			NDR_CHECK(ndr_push_FIELD(_ndr_field, NDR_SCALARS, &r->field));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_field, 2, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_V4TAG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct V4TAG *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->tag));
		{
			struct ndr_pull *_ndr_field;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_field, 2, sub_size));
			NDR_CHECK(ndr_pull_set_switch_value(_ndr_field, &r->field, r->tag));
			NDR_CHECK(ndr_pull_FIELD(_ndr_field, NDR_SCALARS, &r->field));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_field, 2, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_V4TAG(struct ndr_print *ndr, const char *name, const struct V4TAG *r)
{
	ndr_print_struct(ndr, name, "V4TAG");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "tag", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->tag);
	ndr_print_set_switch_value(ndr, &r->field, r->tag);
	ndr_print_FIELD(ndr, "field", &r->field);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_V4TAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct V4TAGS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_V4TAG(ndr, NDR_SCALARS, &r->tag));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->further_tags));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_V4TAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct V4TAGS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_V4TAG(ndr, NDR_SCALARS, &r->tag));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->further_tags));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_V4TAGS(struct ndr_print *ndr, const char *name, const struct V4TAGS *r)
{
	ndr_print_struct(ndr, name, "V4TAGS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_V4TAG(ndr, "tag", &r->tag);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "further_tags", r->further_tags);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_V4HEADER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct V4HEADER *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_v4tags;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_v4tags, 2, -1));
			NDR_CHECK(ndr_push_V4TAGS(_ndr_v4tags, NDR_SCALARS, &r->v4tags));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_v4tags, 2, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_V4HEADER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct V4HEADER *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_v4tags;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_v4tags, 2, sub_size));
			NDR_CHECK(ndr_pull_V4TAGS(_ndr_v4tags, NDR_SCALARS, &r->v4tags));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_v4tags, 2, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_V4HEADER(struct ndr_print *ndr, const char *name, const struct V4HEADER *r)
{
	ndr_print_struct(ndr, name, "V4HEADER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_V4TAGS(ndr, "v4tags", &r->v4tags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OPTIONAL_HEADER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union OPTIONAL_HEADER *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 1));
		switch (level) {
			case 3: {
			break; }

			case 4: {
				NDR_CHECK(ndr_push_V4HEADER(ndr, NDR_SCALARS, &r->v4header));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 3:
			break;

			case 4:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OPTIONAL_HEADER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union OPTIONAL_HEADER *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 1));
		switch (level) {
			case 3: {
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_V4HEADER(ndr, NDR_SCALARS, &r->v4header));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 3:
			break;

			case 4:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OPTIONAL_HEADER(struct ndr_print *ndr, const char *name, const union OPTIONAL_HEADER *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "OPTIONAL_HEADER");
	switch (level) {
		case 3:
		break;

		case 4:
			ndr_print_V4HEADER(ndr, "v4header", &r->v4header);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_CCACHE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CCACHE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 5));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 4));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->optional_header, 4));
			NDR_CHECK(ndr_push_OPTIONAL_HEADER(ndr, NDR_SCALARS, &r->optional_header));
			NDR_CHECK(ndr_push_PRINCIPAL(ndr, NDR_SCALARS, &r->principal));
			NDR_CHECK(ndr_push_CREDENTIAL(ndr, NDR_SCALARS, &r->cred));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->further_creds));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->optional_header, 4));
			NDR_CHECK(ndr_push_OPTIONAL_HEADER(ndr, NDR_BUFFERS, &r->optional_header));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CCACHE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CCACHE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->pvno));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->optional_header, r->version));
			NDR_CHECK(ndr_pull_OPTIONAL_HEADER(ndr, NDR_SCALARS, &r->optional_header));
			NDR_CHECK(ndr_pull_PRINCIPAL(ndr, NDR_SCALARS, &r->principal));
			NDR_CHECK(ndr_pull_CREDENTIAL(ndr, NDR_SCALARS, &r->cred));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->further_creds));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->optional_header, r->version));
			NDR_CHECK(ndr_pull_OPTIONAL_HEADER(ndr, NDR_BUFFERS, &r->optional_header));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CCACHE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CCACHE *r)
{
	ndr_print_CCACHE(ndr, name, r);
}

_PUBLIC_ void ndr_print_CCACHE(struct ndr_print *ndr, const char *name, const struct CCACHE *r)
{
	ndr_print_struct(ndr, name, "CCACHE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint8(ndr, "pvno", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?5:r->pvno);
		ndr_print_uint8(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?4:r->version);
		ndr_print_set_switch_value(ndr, &r->optional_header, r->version);
		ndr_print_OPTIONAL_HEADER(ndr, "optional_header", &r->optional_header);
		ndr_print_PRINCIPAL(ndr, "principal", &r->principal);
		ndr_print_CREDENTIAL(ndr, "cred", &r->cred);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_DATA_BLOB(ndr, "further_creds", r->further_creds);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_MULTIPLE_CREDENTIALS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct MULTIPLE_CREDENTIALS *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_CREDENTIAL(ndr, NDR_SCALARS, &r->cred));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->further_creds));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_MULTIPLE_CREDENTIALS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct MULTIPLE_CREDENTIALS *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_CREDENTIAL(ndr, NDR_SCALARS, &r->cred));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->further_creds));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_MULTIPLE_CREDENTIALS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct MULTIPLE_CREDENTIALS *r)
{
	ndr_print_MULTIPLE_CREDENTIALS(ndr, name, r);
}

_PUBLIC_ void ndr_print_MULTIPLE_CREDENTIALS(struct ndr_print *ndr, const char *name, const struct MULTIPLE_CREDENTIALS *r)
{
	ndr_print_struct(ndr, name, "MULTIPLE_CREDENTIALS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_CREDENTIAL(ndr, "cred", &r->cred);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_DATA_BLOB(ndr, "further_creds", r->further_creds);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_krb5ccache
static const struct ndr_interface_public_struct krb5ccache_public_structs[] = {
	{
		.name = "CCACHE",
		.struct_size = sizeof(struct CCACHE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CCACHE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CCACHE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CCACHE,
	},
	{
		.name = "MULTIPLE_CREDENTIALS",
		.struct_size = sizeof(struct MULTIPLE_CREDENTIALS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_MULTIPLE_CREDENTIALS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_MULTIPLE_CREDENTIALS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_MULTIPLE_CREDENTIALS,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call krb5ccache_calls[] = {
	{ .name = NULL }
};

static const char * const krb5ccache_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\krb5ccache]", 
};

static const struct ndr_interface_string_array krb5ccache_endpoints = {
	.count	= 1,
	.names	= krb5ccache_endpoint_strings
};

static const char * const krb5ccache_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array krb5ccache_authservices = {
	.count	= 1,
	.names	= krb5ccache_authservice_strings
};


const struct ndr_interface_table ndr_table_krb5ccache = {
	.name		= "krb5ccache",
	.syntax_id	= {
		{0x1702b695,0x99ca,0x4f32,{0x93,0xe4},{0x1e,0x1c,0x4d,0x5d,0xdb,0x53}},
		NDR_KRB5CCACHE_VERSION
	},
	.helpstring	= NDR_KRB5CCACHE_HELPSTRING,
	.num_calls	= 0,
	.calls		= krb5ccache_calls,
	.num_public_structs	= 2,
	.public_structs		= krb5ccache_public_structs,
	.endpoints	= &krb5ccache_endpoints,
	.authservices	= &krb5ccache_authservices
};

#endif /* SKIP_NDR_TABLE_krb5ccache */
