/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_ioctl.h"

_PUBLIC_ enum ndr_err_code ndr_push_req_resume_key_rsp(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct req_resume_key_rsp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->resume_key, 24));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->context_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->context, 4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_req_resume_key_rsp(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct req_resume_key_rsp *r)
{
	uint32_t size_resume_key_0 = 0;
	uint32_t size_context_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		size_resume_key_0 = 24;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->resume_key, size_resume_key_0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->context_len));
		size_context_0 = 4;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->context, size_context_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_req_resume_key_rsp(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct req_resume_key_rsp *r)
{
	ndr_print_req_resume_key_rsp(ndr, name, r);
}

_PUBLIC_ void ndr_print_req_resume_key_rsp(struct ndr_print *ndr, const char *name, const struct req_resume_key_rsp *r)
{
	ndr_print_struct(ndr, name, "req_resume_key_rsp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "resume_key", r->resume_key, 24);
	ndr_print_uint32(ndr, "context_len", r->context_len);
	ndr_print_array_uint8(ndr, "context", r->context, 4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_srv_copychunk(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct srv_copychunk *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->source_off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->target_off));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_srv_copychunk(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct srv_copychunk *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->source_off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->target_off));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_srv_copychunk(struct ndr_print *ndr, const char *name, const struct srv_copychunk *r)
{
	ndr_print_struct(ndr, name, "srv_copychunk");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "source_off", r->source_off);
	ndr_print_hyper(ndr, "target_off", r->target_off);
	ndr_print_uint32(ndr, "length", r->length);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_srv_copychunk_copy(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct srv_copychunk_copy *r)
{
	uint32_t cntr_chunks_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->source_key, 24));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chunk_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_chunks_0 = 0; cntr_chunks_0 < (r->chunk_count); cntr_chunks_0++) {
			NDR_CHECK(ndr_push_srv_copychunk(ndr, NDR_SCALARS, &r->chunks[cntr_chunks_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srv_copychunk_copy(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct srv_copychunk_copy *r)
{
	uint32_t size_source_key_0 = 0;
	uint32_t size_chunks_0 = 0;
	uint32_t cntr_chunks_0;
	TALLOC_CTX *_mem_save_chunks_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		size_source_key_0 = 24;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->source_key, size_source_key_0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chunk_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		size_chunks_0 = r->chunk_count;
		NDR_PULL_ALLOC_N(ndr, r->chunks, size_chunks_0);
		_mem_save_chunks_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->chunks, 0);
		for (cntr_chunks_0 = 0; cntr_chunks_0 < (size_chunks_0); cntr_chunks_0++) {
			NDR_CHECK(ndr_pull_srv_copychunk(ndr, NDR_SCALARS, &r->chunks[cntr_chunks_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_chunks_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_srv_copychunk_copy(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct srv_copychunk_copy *r)
{
	ndr_print_srv_copychunk_copy(ndr, name, r);
}

_PUBLIC_ void ndr_print_srv_copychunk_copy(struct ndr_print *ndr, const char *name, const struct srv_copychunk_copy *r)
{
	uint32_t cntr_chunks_0;
	ndr_print_struct(ndr, name, "srv_copychunk_copy");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "source_key", r->source_key, 24);
	ndr_print_uint32(ndr, "chunk_count", r->chunk_count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "chunks", (uint32_t)(r->chunk_count));
	ndr->depth++;
	for (cntr_chunks_0 = 0; cntr_chunks_0 < (r->chunk_count); cntr_chunks_0++) {
		ndr_print_srv_copychunk(ndr, "chunks", &r->chunks[cntr_chunks_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_srv_copychunk_rsp(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct srv_copychunk_rsp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chunks_written));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->chunk_bytes_written));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->total_bytes_written));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_srv_copychunk_rsp(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct srv_copychunk_rsp *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chunks_written));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->chunk_bytes_written));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->total_bytes_written));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_srv_copychunk_rsp(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct srv_copychunk_rsp *r)
{
	ndr_print_srv_copychunk_rsp(ndr, name, r);
}

_PUBLIC_ void ndr_print_srv_copychunk_rsp(struct ndr_print *ndr, const char *name, const struct srv_copychunk_rsp *r)
{
	ndr_print_struct(ndr, name, "srv_copychunk_rsp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "chunks_written", r->chunks_written);
	ndr_print_uint32(ndr, "chunk_bytes_written", r->chunk_bytes_written);
	ndr_print_uint32(ndr, "total_bytes_written", r->total_bytes_written);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_device_copy_offload_descriptor(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct device_copy_offload_descriptor *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_token_lifetime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->default_token_lifetime));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->maximum_xfer_size));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->optimal_xfer_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_data_descriptors));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->maximum_xfer_length_per_descriptor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->optimal_xfer_length_per_descriptor));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->optimal_xfer_length_granularity));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->reserved, 2));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_device_copy_offload_descriptor(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct device_copy_offload_descriptor *r)
{
	uint32_t size_reserved_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_token_lifetime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->default_token_lifetime));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->maximum_xfer_size));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->optimal_xfer_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_data_descriptors));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->maximum_xfer_length_per_descriptor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->optimal_xfer_length_per_descriptor));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->optimal_xfer_length_granularity));
		size_reserved_0 = 2;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->reserved, size_reserved_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_device_copy_offload_descriptor(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct device_copy_offload_descriptor *r)
{
	ndr_print_device_copy_offload_descriptor(ndr, name, r);
}

_PUBLIC_ void ndr_print_device_copy_offload_descriptor(struct ndr_print *ndr, const char *name, const struct device_copy_offload_descriptor *r)
{
	ndr_print_struct(ndr, name, "device_copy_offload_descriptor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "maximum_token_lifetime", r->maximum_token_lifetime);
	ndr_print_uint32(ndr, "default_token_lifetime", r->default_token_lifetime);
	ndr_print_hyper(ndr, "maximum_xfer_size", r->maximum_xfer_size);
	ndr_print_hyper(ndr, "optimal_xfer_count", r->optimal_xfer_count);
	ndr_print_uint32(ndr, "maximum_data_descriptors", r->maximum_data_descriptors);
	ndr_print_uint32(ndr, "maximum_xfer_length_per_descriptor", r->maximum_xfer_length_per_descriptor);
	ndr_print_uint32(ndr, "optimal_xfer_length_per_descriptor", r->optimal_xfer_length_per_descriptor);
	ndr_print_uint16(ndr, "optimal_xfer_length_granularity", r->optimal_xfer_length_granularity);
	ndr_print_array_uint8(ndr, "reserved", r->reserved, 2);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_storage_offload_token(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct storage_offload_token *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->token_type));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->reserved, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->token_id_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->token, r->token_id_len));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_storage_offload_token(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct storage_offload_token *r)
{
	uint32_t size_reserved_0 = 0;
	uint32_t size_token_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->token_type));
		size_reserved_0 = 2;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->reserved, size_reserved_0));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->token_id_len));
		size_token_0 = r->token_id_len;
		NDR_PULL_ALLOC_N(ndr, r->token, size_token_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->token, size_token_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_storage_offload_token(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct storage_offload_token *r)
{
	ndr_print_storage_offload_token(ndr, name, r);
}

_PUBLIC_ void ndr_print_storage_offload_token(struct ndr_print *ndr, const char *name, const struct storage_offload_token *r)
{
	ndr_print_struct(ndr, name, "storage_offload_token");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "token_type", r->token_type);
	ndr_print_array_uint8(ndr, "reserved", r->reserved, 2);
	ndr_print_uint16(ndr, "token_id_len", r->token_id_len);
	ndr_print_array_uint8(ndr, "token", r->token, r->token_id_len);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_read_input(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_offload_read_input *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->token_time_to_live));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_offset));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_read_input(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_offload_read_input *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->token_time_to_live));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_offset));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_offload_read_input(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_offload_read_input *r)
{
	ndr_print_fsctl_offload_read_input(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_offload_read_input(struct ndr_print *ndr, const char *name, const struct fsctl_offload_read_input *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_read_input");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "token_time_to_live", r->token_time_to_live);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_hyper(ndr, "file_offset", r->file_offset);
	ndr_print_hyper(ndr, "length", r->length);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_offload_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_offload_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_offload_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "OFFLOAD_READ_FLAG_FILE_TOO_SMALL", OFFLOAD_READ_FLAG_FILE_TOO_SMALL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "OFFLOAD_READ_FLAG_ALL_ZERO_BEYOND_RANGE", OFFLOAD_READ_FLAG_ALL_ZERO_BEYOND_RANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "OFFLOAD_READ_FLAG_CANNOT_OFFLOAD_BEYOND_RANGE", OFFLOAD_READ_FLAG_CANNOT_OFFLOAD_BEYOND_RANGE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_read_output(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_offload_read_output *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_offload_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->xfer_length));
		NDR_CHECK(ndr_push_storage_offload_token(ndr, NDR_SCALARS, &r->token));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_read_output(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_offload_read_output *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_offload_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->xfer_length));
		NDR_CHECK(ndr_pull_storage_offload_token(ndr, NDR_SCALARS, &r->token));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_offload_read_output(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_offload_read_output *r)
{
	ndr_print_fsctl_offload_read_output(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_offload_read_output(struct ndr_print *ndr, const char *name, const struct fsctl_offload_read_output *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_read_output");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_offload_flags(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "xfer_length", r->xfer_length);
	ndr_print_storage_offload_token(ndr, "token", &r->token);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_write_input(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_offload_write_input *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_offload_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_offset));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->copy_length));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->xfer_offset));
		NDR_CHECK(ndr_push_storage_offload_token(ndr, NDR_SCALARS, &r->token));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_write_input(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_offload_write_input *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_offload_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_offset));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->copy_length));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->xfer_offset));
		NDR_CHECK(ndr_pull_storage_offload_token(ndr, NDR_SCALARS, &r->token));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_offload_write_input(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_offload_write_input *r)
{
	ndr_print_fsctl_offload_write_input(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_offload_write_input(struct ndr_print *ndr, const char *name, const struct fsctl_offload_write_input *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_write_input");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_offload_flags(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "file_offset", r->file_offset);
	ndr_print_hyper(ndr, "copy_length", r->copy_length);
	ndr_print_hyper(ndr, "xfer_offset", r->xfer_offset);
	ndr_print_storage_offload_token(ndr, "token", &r->token);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_offload_write_output(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_offload_write_output *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->length_written));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_offload_write_output(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_offload_write_output *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->length_written));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_offload_write_output(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_offload_write_output *r)
{
	ndr_print_fsctl_offload_write_output(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_offload_write_output(struct ndr_print *ndr, const char *name, const struct fsctl_offload_write_output *r)
{
	ndr_print_struct(ndr, name, "fsctl_offload_write_output");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "size", r->size);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_hyper(ndr, "length_written", r->length_written);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_dup_extents_to_file(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_dup_extents_to_file *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->source_fid, 16));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->source_off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->target_off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->byte_count));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_dup_extents_to_file(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_dup_extents_to_file *r)
{
	uint32_t size_source_fid_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		size_source_fid_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->source_fid, size_source_fid_0));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->source_off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->target_off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->byte_count));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_dup_extents_to_file(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_dup_extents_to_file *r)
{
	ndr_print_fsctl_dup_extents_to_file(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_dup_extents_to_file(struct ndr_print *ndr, const char *name, const struct fsctl_dup_extents_to_file *r)
{
	ndr_print_struct(ndr, name, "fsctl_dup_extents_to_file");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "source_fid", r->source_fid, 16);
	ndr_print_hyper(ndr, "source_off", r->source_off);
	ndr_print_hyper(ndr, "target_off", r->target_off);
	ndr_print_hyper(ndr, "byte_count", r->byte_count);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_copychunk
static const struct ndr_interface_public_struct copychunk_public_structs[] = {
	{
		.name = "req_resume_key_rsp",
		.struct_size = sizeof(struct req_resume_key_rsp ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_req_resume_key_rsp,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_req_resume_key_rsp,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_req_resume_key_rsp,
	},
	{
		.name = "srv_copychunk_copy",
		.struct_size = sizeof(struct srv_copychunk_copy ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_srv_copychunk_copy,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_srv_copychunk_copy,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_srv_copychunk_copy,
	},
	{
		.name = "srv_copychunk_rsp",
		.struct_size = sizeof(struct srv_copychunk_rsp ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_srv_copychunk_rsp,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_srv_copychunk_rsp,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_srv_copychunk_rsp,
	},
	{
		.name = "device_copy_offload_descriptor",
		.struct_size = sizeof(struct device_copy_offload_descriptor ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_device_copy_offload_descriptor,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_device_copy_offload_descriptor,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_device_copy_offload_descriptor,
	},
	{
		.name = "storage_offload_token",
		.struct_size = sizeof(struct storage_offload_token ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_storage_offload_token,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_storage_offload_token,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_storage_offload_token,
	},
	{
		.name = "fsctl_offload_read_input",
		.struct_size = sizeof(struct fsctl_offload_read_input ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_offload_read_input,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_offload_read_input,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_offload_read_input,
	},
	{
		.name = "fsctl_offload_read_output",
		.struct_size = sizeof(struct fsctl_offload_read_output ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_offload_read_output,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_offload_read_output,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_offload_read_output,
	},
	{
		.name = "fsctl_offload_write_input",
		.struct_size = sizeof(struct fsctl_offload_write_input ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_offload_write_input,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_offload_write_input,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_offload_write_input,
	},
	{
		.name = "fsctl_offload_write_output",
		.struct_size = sizeof(struct fsctl_offload_write_output ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_offload_write_output,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_offload_write_output,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_offload_write_output,
	},
	{
		.name = "fsctl_dup_extents_to_file",
		.struct_size = sizeof(struct fsctl_dup_extents_to_file ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_dup_extents_to_file,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_dup_extents_to_file,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_dup_extents_to_file,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call copychunk_calls[] = {
	{ .name = NULL }
};

static const char * const copychunk_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\copychunk]", 
};

static const struct ndr_interface_string_array copychunk_endpoints = {
	.count	= 1,
	.names	= copychunk_endpoint_strings
};

static const char * const copychunk_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array copychunk_authservices = {
	.count	= 1,
	.names	= copychunk_authservice_strings
};


const struct ndr_interface_table ndr_table_copychunk = {
	.name		= "copychunk",
	.num_calls	= 0,
	.calls		= copychunk_calls,
	.num_public_structs	= 10,
	.public_structs		= copychunk_public_structs,
	.endpoints	= &copychunk_endpoints,
	.authservices	= &copychunk_authservices
};

#endif /* SKIP_NDR_TABLE_copychunk */
_PUBLIC_ enum ndr_err_code ndr_push_compression_state(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct compression_state *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->format));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_compression_state(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct compression_state *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->format));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_compression_state(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct compression_state *r)
{
	ndr_print_compression_state(ndr, name, r);
}

_PUBLIC_ void ndr_print_compression_state(struct ndr_print *ndr, const char *name, const struct compression_state *r)
{
	ndr_print_struct(ndr, name, "compression_state");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "format", r->format);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_compression
static const struct ndr_interface_public_struct compression_public_structs[] = {
	{
		.name = "compression_state",
		.struct_size = sizeof(struct compression_state ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_compression_state,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_compression_state,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_compression_state,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call compression_calls[] = {
	{ .name = NULL }
};

static const char * const compression_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\compression]", 
};

static const struct ndr_interface_string_array compression_endpoints = {
	.count	= 1,
	.names	= compression_endpoint_strings
};

static const char * const compression_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array compression_authservices = {
	.count	= 1,
	.names	= compression_authservice_strings
};


const struct ndr_interface_table ndr_table_compression = {
	.name		= "compression",
	.num_calls	= 0,
	.calls		= compression_calls,
	.num_public_structs	= 1,
	.public_structs		= compression_public_structs,
	.endpoints	= &compression_endpoints,
	.authservices	= &compression_authservices
};

#endif /* SKIP_NDR_TABLE_compression */
static enum ndr_err_code ndr_push_fsctl_net_iface_capability(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_fsctl_net_iface_capability(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_net_iface_capability(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FSCTL_NET_IFACE_NONE_CAPABLE", FSCTL_NET_IFACE_NONE_CAPABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FSCTL_NET_IFACE_RSS_CAPABLE", FSCTL_NET_IFACE_RSS_CAPABLE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FSCTL_NET_IFACE_RDMA_CAPABLE", FSCTL_NET_IFACE_RDMA_CAPABLE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_fsctl_sockaddr_af(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum fsctl_sockaddr_af r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_fsctl_sockaddr_af(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum fsctl_sockaddr_af *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_sockaddr_af(struct ndr_print *ndr, const char *name, enum fsctl_sockaddr_af r)
{
	const char *val = NULL;

	switch (r) {
		case FSCTL_NET_IFACE_AF_INET: val = "FSCTL_NET_IFACE_AF_INET"; break;
		case FSCTL_NET_IFACE_AF_INET6: val = "FSCTL_NET_IFACE_AF_INET6"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_fsctl_sockaddr_in(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_sockaddr_in *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0));
			{
				libndr_flags _flags_save_ipv4address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
				ndr->flags = _flags_save_ipv4address;
			}
			NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_fsctl_sockaddr_in(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_sockaddr_in *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
			{
				libndr_flags _flags_save_ipv4address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
				ndr->flags = _flags_save_ipv4address;
			}
			NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->reserved));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_sockaddr_in(struct ndr_print *ndr, const char *name, const struct fsctl_sockaddr_in *r)
{
	ndr_print_struct(ndr, name, "fsctl_sockaddr_in");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint16(ndr, "port", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->port);
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
			ndr->flags = _flags_save_ipv4address;
		}
		ndr_print_hyper(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_fsctl_sockaddr_in6(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_sockaddr_in6 *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			{
				libndr_flags _flags_save_ipv6address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
				ndr->flags = _flags_save_ipv6address;
			}
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_fsctl_sockaddr_in6(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_sockaddr_in6 *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flowinfo));
			{
				libndr_flags _flags_save_ipv6address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
				ndr->flags = _flags_save_ipv6address;
			}
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->scopeid));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_sockaddr_in6(struct ndr_print *ndr, const char *name, const struct fsctl_sockaddr_in6 *r)
{
	ndr_print_struct(ndr, name, "fsctl_sockaddr_in6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint16(ndr, "port", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->port);
		ndr_print_uint32(ndr, "flowinfo", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->flowinfo);
		{
			libndr_flags _flags_save_ipv6address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
			ndr->flags = _flags_save_ipv6address;
		}
		ndr_print_uint32(ndr, "scopeid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->scopeid);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_fsctl_sockaddr_union(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union fsctl_sockaddr_union *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 8));
			switch (level) {
				case FSCTL_NET_IFACE_AF_INET: {
					NDR_CHECK(ndr_push_fsctl_sockaddr_in(ndr, NDR_SCALARS, &r->saddr_in));
				break; }

				case FSCTL_NET_IFACE_AF_INET6: {
					NDR_CHECK(ndr_push_fsctl_sockaddr_in6(ndr, NDR_SCALARS, &r->saddr_in6));
				break; }

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case FSCTL_NET_IFACE_AF_INET:
				break;

				case FSCTL_NET_IFACE_AF_INET6:
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_fsctl_sockaddr_union(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union fsctl_sockaddr_union *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 8));
			switch (level) {
				case FSCTL_NET_IFACE_AF_INET: {
					NDR_CHECK(ndr_pull_fsctl_sockaddr_in(ndr, NDR_SCALARS, &r->saddr_in));
				break; }

				case FSCTL_NET_IFACE_AF_INET6: {
					NDR_CHECK(ndr_pull_fsctl_sockaddr_in6(ndr, NDR_SCALARS, &r->saddr_in6));
				break; }

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case FSCTL_NET_IFACE_AF_INET:
				break;

				case FSCTL_NET_IFACE_AF_INET6:
				break;

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_sockaddr_union(struct ndr_print *ndr, const char *name, const union fsctl_sockaddr_union *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "fsctl_sockaddr_union");
		switch (level) {
			case FSCTL_NET_IFACE_AF_INET:
				ndr_print_fsctl_sockaddr_in(ndr, "saddr_in", &r->saddr_in);
			break;

			case FSCTL_NET_IFACE_AF_INET6:
				ndr_print_fsctl_sockaddr_in6(ndr, "saddr_in6", &r->saddr_in6);
			break;

			default:
				ndr_print_bad_level(ndr, name, level);
		}
		ndr->flags = _flags_save_UNION;
	}
}

static enum ndr_err_code ndr_push_fsctl_sockaddr_storage(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_sockaddr_storage *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_fsctl_sockaddr_af(ndr, NDR_SCALARS, r->family));
			{
				struct ndr_push *_ndr_saddr;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_saddr, 0, 126));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_saddr, &r->saddr, r->family));
				NDR_CHECK(ndr_push_fsctl_sockaddr_union(_ndr_saddr, NDR_SCALARS, &r->saddr));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_saddr, 0, 126));
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_fsctl_sockaddr_storage(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_sockaddr_storage *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			NDR_CHECK(ndr_pull_fsctl_sockaddr_af(ndr, NDR_SCALARS, &r->family));
			{
				struct ndr_pull *_ndr_saddr;
				ssize_t sub_size = 126;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_saddr, 0, sub_size));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_saddr, &r->saddr, r->family));
				NDR_CHECK(ndr_pull_fsctl_sockaddr_union(_ndr_saddr, NDR_SCALARS, &r->saddr));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_saddr, 0, sub_size));
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_fsctl_sockaddr_storage(struct ndr_print *ndr, const char *name, const struct fsctl_sockaddr_storage *r)
{
	ndr_print_struct(ndr, name, "fsctl_sockaddr_storage");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_fsctl_sockaddr_af(ndr, "family", r->family);
		ndr_print_set_switch_value(ndr, &r->saddr, r->family);
		ndr_print_fsctl_sockaddr_union(ndr, "saddr", &r->saddr);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_net_iface_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_net_iface_info *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->next));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ifindex));
		NDR_CHECK(ndr_push_fsctl_net_iface_capability(ndr, NDR_SCALARS, r->capability));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->linkspeed));
		NDR_CHECK(ndr_push_fsctl_sockaddr_storage(ndr, NDR_SCALARS, &r->sockaddr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
		if (r->next) {
			NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->next));
			NDR_CHECK(ndr_push_fsctl_net_iface_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->next));
		}
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_net_iface_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_net_iface_info *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	uint32_t _ptr_next;
	TALLOC_CTX *_mem_save_next_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next));
		if (_ptr_next) {
			NDR_PULL_ALLOC(ndr, r->next);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->next, _ptr_next));
		} else {
			r->next = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ifindex));
		NDR_CHECK(ndr_pull_fsctl_net_iface_capability(ndr, NDR_SCALARS, &r->capability));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->linkspeed));
		NDR_CHECK(ndr_pull_fsctl_sockaddr_storage(ndr, NDR_SCALARS, &r->sockaddr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
		if (r->next) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->next));
			_mem_save_next_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next, 0);
			NDR_RECURSION_CHECK(ndr, 20000);
			NDR_CHECK(ndr_pull_fsctl_net_iface_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_0, 0);
			if (ndr->offset > ndr->relative_highest_offset) {
				ndr->relative_highest_offset = ndr->offset;
			}
			ndr->offset = _relative_save_offset;
		}
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_net_iface_info(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_net_iface_info *r)
{
	ndr_print_fsctl_net_iface_info(ndr, name, r);
}

#ifndef SKIP_NDR_TABLE_netinterface
static const struct ndr_interface_public_struct netinterface_public_structs[] = {
	{
		.name = "fsctl_net_iface_info",
		.struct_size = sizeof(struct fsctl_net_iface_info ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_net_iface_info,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_net_iface_info,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_net_iface_info,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call netinterface_calls[] = {
	{ .name = NULL }
};

static const char * const netinterface_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\netinterface]", 
};

static const struct ndr_interface_string_array netinterface_endpoints = {
	.count	= 1,
	.names	= netinterface_endpoint_strings
};

static const char * const netinterface_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array netinterface_authservices = {
	.count	= 1,
	.names	= netinterface_authservice_strings
};


const struct ndr_interface_table ndr_table_netinterface = {
	.name		= "netinterface",
	.num_calls	= 0,
	.calls		= netinterface_calls,
	.num_public_structs	= 1,
	.public_structs		= netinterface_public_structs,
	.endpoints	= &netinterface_endpoints,
	.authservices	= &netinterface_authservices
};

#endif /* SKIP_NDR_TABLE_netinterface */
_PUBLIC_ enum ndr_err_code ndr_push_file_alloced_range_buf(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct file_alloced_range_buf *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_file_alloced_range_buf(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct file_alloced_range_buf *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_file_alloced_range_buf(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct file_alloced_range_buf *r)
{
	ndr_print_file_alloced_range_buf(ndr, name, r);
}

_PUBLIC_ void ndr_print_file_alloced_range_buf(struct ndr_print *ndr, const char *name, const struct file_alloced_range_buf *r)
{
	ndr_print_struct(ndr, name, "file_alloced_range_buf");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "file_off", r->file_off);
	ndr_print_hyper(ndr, "len", r->len);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_query_alloced_ranges_req(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_query_alloced_ranges_req *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_file_alloced_range_buf(ndr, NDR_SCALARS, &r->buf));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_query_alloced_ranges_req(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_query_alloced_ranges_req *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_file_alloced_range_buf(ndr, NDR_SCALARS, &r->buf));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_query_alloced_ranges_req(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_query_alloced_ranges_req *r)
{
	ndr_print_fsctl_query_alloced_ranges_req(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_query_alloced_ranges_req(struct ndr_print *ndr, const char *name, const struct fsctl_query_alloced_ranges_req *r)
{
	ndr_print_struct(ndr, name, "fsctl_query_alloced_ranges_req");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_file_alloced_range_buf(ndr, "buf", &r->buf);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_query_alloced_ranges_rsp(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_query_alloced_ranges_rsp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->far_buf_array));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_query_alloced_ranges_rsp(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_query_alloced_ranges_rsp *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->far_buf_array));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_query_alloced_ranges_rsp(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_query_alloced_ranges_rsp *r)
{
	ndr_print_fsctl_query_alloced_ranges_rsp(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_query_alloced_ranges_rsp(struct ndr_print *ndr, const char *name, const struct fsctl_query_alloced_ranges_rsp *r)
{
	ndr_print_struct(ndr, name, "fsctl_query_alloced_ranges_rsp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "far_buf_array", r->far_buf_array);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_file_zero_data_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct file_zero_data_info *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->beyond_final_zero));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_file_zero_data_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct file_zero_data_info *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->beyond_final_zero));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_file_zero_data_info(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct file_zero_data_info *r)
{
	ndr_print_file_zero_data_info(ndr, name, r);
}

_PUBLIC_ void ndr_print_file_zero_data_info(struct ndr_print *ndr, const char *name, const struct file_zero_data_info *r)
{
	ndr_print_struct(ndr, name, "file_zero_data_info");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "file_off", r->file_off);
	ndr_print_hyper(ndr, "beyond_final_zero", r->beyond_final_zero);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_set_zero_data_req(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_set_zero_data_req *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_file_zero_data_info(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_set_zero_data_req(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_set_zero_data_req *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_file_zero_data_info(ndr, NDR_SCALARS, &r->info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_set_zero_data_req(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_set_zero_data_req *r)
{
	ndr_print_fsctl_set_zero_data_req(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_set_zero_data_req(struct ndr_print *ndr, const char *name, const struct fsctl_set_zero_data_req *r)
{
	ndr_print_struct(ndr, name, "fsctl_set_zero_data_req");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_file_zero_data_info(ndr, "info", &r->info);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_sparse
static const struct ndr_interface_public_struct sparse_public_structs[] = {
	{
		.name = "file_alloced_range_buf",
		.struct_size = sizeof(struct file_alloced_range_buf ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_file_alloced_range_buf,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_file_alloced_range_buf,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_file_alloced_range_buf,
	},
	{
		.name = "fsctl_query_alloced_ranges_req",
		.struct_size = sizeof(struct fsctl_query_alloced_ranges_req ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_query_alloced_ranges_req,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_query_alloced_ranges_req,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_query_alloced_ranges_req,
	},
	{
		.name = "fsctl_query_alloced_ranges_rsp",
		.struct_size = sizeof(struct fsctl_query_alloced_ranges_rsp ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_query_alloced_ranges_rsp,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_query_alloced_ranges_rsp,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_query_alloced_ranges_rsp,
	},
	{
		.name = "file_zero_data_info",
		.struct_size = sizeof(struct file_zero_data_info ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_file_zero_data_info,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_file_zero_data_info,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_file_zero_data_info,
	},
	{
		.name = "fsctl_set_zero_data_req",
		.struct_size = sizeof(struct fsctl_set_zero_data_req ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_set_zero_data_req,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_set_zero_data_req,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_set_zero_data_req,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call sparse_calls[] = {
	{ .name = NULL }
};

static const char * const sparse_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\sparse]", 
};

static const struct ndr_interface_string_array sparse_endpoints = {
	.count	= 1,
	.names	= sparse_endpoint_strings
};

static const char * const sparse_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array sparse_authservices = {
	.count	= 1,
	.names	= sparse_authservice_strings
};


const struct ndr_interface_table ndr_table_sparse = {
	.name		= "sparse",
	.num_calls	= 0,
	.calls		= sparse_calls,
	.num_public_structs	= 5,
	.public_structs		= sparse_public_structs,
	.endpoints	= &sparse_endpoints,
	.authservices	= &sparse_authservices
};

#endif /* SKIP_NDR_TABLE_sparse */
_PUBLIC_ enum ndr_err_code ndr_push_network_resiliency_request(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct network_resiliency_request *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_network_resiliency_request(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct network_resiliency_request *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_network_resiliency_request(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct network_resiliency_request *r)
{
	ndr_print_network_resiliency_request(ndr, name, r);
}

_PUBLIC_ void ndr_print_network_resiliency_request(struct ndr_print *ndr, const char *name, const struct network_resiliency_request *r)
{
	ndr_print_struct(ndr, name, "network_resiliency_request");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "timeout", r->timeout);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_resiliency
static const struct ndr_interface_public_struct resiliency_public_structs[] = {
	{
		.name = "network_resiliency_request",
		.struct_size = sizeof(struct network_resiliency_request ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_network_resiliency_request,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_network_resiliency_request,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_network_resiliency_request,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call resiliency_calls[] = {
	{ .name = NULL }
};

static const char * const resiliency_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\resiliency]", 
};

static const struct ndr_interface_string_array resiliency_endpoints = {
	.count	= 1,
	.names	= resiliency_endpoint_strings
};

static const char * const resiliency_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array resiliency_authservices = {
	.count	= 1,
	.names	= resiliency_authservice_strings
};


const struct ndr_interface_table ndr_table_resiliency = {
	.name		= "resiliency",
	.num_calls	= 0,
	.calls		= resiliency_calls,
	.num_public_structs	= 1,
	.public_structs		= resiliency_public_structs,
	.endpoints	= &resiliency_endpoints,
	.authservices	= &resiliency_authservices
};

#endif /* SKIP_NDR_TABLE_resiliency */
_PUBLIC_ enum ndr_err_code ndr_push_file_level_trim_range(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct file_level_trim_range *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->off));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->len));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_file_level_trim_range(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct file_level_trim_range *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->off));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->len));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_file_level_trim_range(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct file_level_trim_range *r)
{
	ndr_print_file_level_trim_range(ndr, name, r);
}

_PUBLIC_ void ndr_print_file_level_trim_range(struct ndr_print *ndr, const char *name, const struct file_level_trim_range *r)
{
	ndr_print_struct(ndr, name, "file_level_trim_range");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "off", r->off);
	ndr_print_hyper(ndr, "len", r->len);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_file_level_trim_req(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_file_level_trim_req *r)
{
	uint32_t cntr_ranges_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->key));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_ranges));
		for (cntr_ranges_0 = 0; cntr_ranges_0 < (r->num_ranges); cntr_ranges_0++) {
			NDR_CHECK(ndr_push_file_level_trim_range(ndr, NDR_SCALARS, &r->ranges[cntr_ranges_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_file_level_trim_req(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_file_level_trim_req *r)
{
	uint32_t size_ranges_0 = 0;
	uint32_t cntr_ranges_0;
	TALLOC_CTX *_mem_save_ranges_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->key));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_ranges));
		size_ranges_0 = r->num_ranges;
		NDR_PULL_ALLOC_N(ndr, r->ranges, size_ranges_0);
		_mem_save_ranges_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ranges, 0);
		for (cntr_ranges_0 = 0; cntr_ranges_0 < (size_ranges_0); cntr_ranges_0++) {
			NDR_CHECK(ndr_pull_file_level_trim_range(ndr, NDR_SCALARS, &r->ranges[cntr_ranges_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ranges_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_file_level_trim_req(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_file_level_trim_req *r)
{
	ndr_print_fsctl_file_level_trim_req(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_file_level_trim_req(struct ndr_print *ndr, const char *name, const struct fsctl_file_level_trim_req *r)
{
	uint32_t cntr_ranges_0;
	ndr_print_struct(ndr, name, "fsctl_file_level_trim_req");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "key", r->key);
	ndr_print_uint32(ndr, "num_ranges", r->num_ranges);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ranges", (uint32_t)(r->num_ranges));
	ndr->depth++;
	for (cntr_ranges_0 = 0; cntr_ranges_0 < (r->num_ranges); cntr_ranges_0++) {
		ndr_print_file_level_trim_range(ndr, "ranges", &r->ranges[cntr_ranges_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_fsctl_file_level_trim_rsp(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_file_level_trim_rsp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_ranges_processed));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_file_level_trim_rsp(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_file_level_trim_rsp *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_ranges_processed));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_file_level_trim_rsp(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_file_level_trim_rsp *r)
{
	ndr_print_fsctl_file_level_trim_rsp(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_file_level_trim_rsp(struct ndr_print *ndr, const char *name, const struct fsctl_file_level_trim_rsp *r)
{
	ndr_print_struct(ndr, name, "fsctl_file_level_trim_rsp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_ranges_processed", r->num_ranges_processed);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_trim
static const struct ndr_interface_public_struct trim_public_structs[] = {
	{
		.name = "file_level_trim_range",
		.struct_size = sizeof(struct file_level_trim_range ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_file_level_trim_range,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_file_level_trim_range,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_file_level_trim_range,
	},
	{
		.name = "fsctl_file_level_trim_req",
		.struct_size = sizeof(struct fsctl_file_level_trim_req ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_file_level_trim_req,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_file_level_trim_req,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_file_level_trim_req,
	},
	{
		.name = "fsctl_file_level_trim_rsp",
		.struct_size = sizeof(struct fsctl_file_level_trim_rsp ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_file_level_trim_rsp,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_file_level_trim_rsp,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_file_level_trim_rsp,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call trim_calls[] = {
	{ .name = NULL }
};

static const char * const trim_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\trim]", 
};

static const struct ndr_interface_string_array trim_endpoints = {
	.count	= 1,
	.names	= trim_endpoint_strings
};

static const char * const trim_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array trim_authservices = {
	.count	= 1,
	.names	= trim_authservice_strings
};


const struct ndr_interface_table ndr_table_trim = {
	.name		= "trim",
	.num_calls	= 0,
	.calls		= trim_calls,
	.num_public_structs	= 3,
	.public_structs		= trim_public_structs,
	.endpoints	= &trim_endpoints,
	.authservices	= &trim_authservices
};

#endif /* SKIP_NDR_TABLE_trim */
_PUBLIC_ enum ndr_err_code ndr_push_fsctl_pipe_wait(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct fsctl_pipe_wait *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->timeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * strlen_m(r->pipe_name)));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->timeout_specified));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->padding));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pipe_name, 2 * strlen_m(r->pipe_name), sizeof(uint8_t), CH_UTF16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_fsctl_pipe_wait(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct fsctl_pipe_wait *r)
{
	uint32_t size_pipe_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->timeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pipe_name_len));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->timeout_specified));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->padding));
		size_pipe_name_0 = r->pipe_name_len;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pipe_name, size_pipe_name_0, sizeof(uint8_t), CH_UTF16));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_fsctl_pipe_wait(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct fsctl_pipe_wait *r)
{
	ndr_print_fsctl_pipe_wait(ndr, name, r);
}

_PUBLIC_ void ndr_print_fsctl_pipe_wait(struct ndr_print *ndr, const char *name, const struct fsctl_pipe_wait *r)
{
	ndr_print_struct(ndr, name, "fsctl_pipe_wait");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "timeout", r->timeout);
	ndr_print_uint32(ndr, "pipe_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * strlen_m(r->pipe_name):r->pipe_name_len);
	ndr_print_uint8(ndr, "timeout_specified", r->timeout_specified);
	ndr_print_uint8(ndr, "padding", r->padding);
	ndr_print_string(ndr, "pipe_name", r->pipe_name);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_fsctl
static const struct ndr_interface_public_struct fsctl_public_structs[] = {
	{
		.name = "fsctl_pipe_wait",
		.struct_size = sizeof(struct fsctl_pipe_wait ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_fsctl_pipe_wait,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_fsctl_pipe_wait,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_fsctl_pipe_wait,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call fsctl_calls[] = {
	{ .name = NULL }
};

static const char * const fsctl_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\fsctl]", 
};

static const struct ndr_interface_string_array fsctl_endpoints = {
	.count	= 1,
	.names	= fsctl_endpoint_strings
};

static const char * const fsctl_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array fsctl_authservices = {
	.count	= 1,
	.names	= fsctl_authservice_strings
};


const struct ndr_interface_table ndr_table_fsctl = {
	.name		= "fsctl",
	.num_calls	= 0,
	.calls		= fsctl_calls,
	.num_public_structs	= 1,
	.public_structs		= fsctl_public_structs,
	.endpoints	= &fsctl_endpoints,
	.authservices	= &fsctl_authservices
};

#endif /* SKIP_NDR_TABLE_fsctl */
