/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_gkdi.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_EnvelopeFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_EnvelopeFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_EnvelopeFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENVELOPE_FLAG_TRANSPORTING_PUBLIC_KEY", ENVELOPE_FLAG_TRANSPORTING_PUBLIC_KEY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "ENVELOPE_FLAG_KEY_MAY_ENCRYPT_NEW_DATA", ENVELOPE_FLAG_KEY_MAY_ENCRYPT_NEW_DATA, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_KeyEnvelope(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct KeyEnvelope *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x4b53444b));
		NDR_CHECK(ndr_push_EnvelopeFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l0_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l1_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l2_index));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->root_key_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->additional_info_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->domain_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->forest_name, CH_UTF16)));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->additional_info, r->additional_info_len));
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->forest_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_KeyEnvelope(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct KeyEnvelope *r)
{
	uint32_t size_additional_info_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		if (r->magic < 1263748171 || r->magic > 1263748171) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->magic), (uint32_t)(1263748171), (uint32_t)(1263748171));
		}
		NDR_CHECK(ndr_pull_EnvelopeFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l0_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l1_index));
		if (r->l1_index > 31) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->l1_index), (uint32_t)(0), (uint32_t)(31));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l2_index));
		if (r->l2_index > 31) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->l2_index), (uint32_t)(0), (uint32_t)(31));
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->root_key_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->additional_info_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->domain_name_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->forest_name_len));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			size_additional_info_0 = r->additional_info_len;
			NDR_PULL_ALLOC_N(ndr, r->additional_info, size_additional_info_0);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->additional_info, size_additional_info_0));
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->forest_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_KeyEnvelope(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct KeyEnvelope *r)
{
	ndr_print_KeyEnvelope(ndr, name, r);
}

_PUBLIC_ void ndr_print_KeyEnvelope(struct ndr_print *ndr, const char *name, const struct KeyEnvelope *r)
{
	ndr_print_struct(ndr, name, "KeyEnvelope");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x4b53444b:r->magic);
	ndr_print_EnvelopeFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "l0_index", r->l0_index);
	ndr_print_uint32(ndr, "l1_index", r->l1_index);
	ndr_print_uint32(ndr, "l2_index", r->l2_index);
	ndr_print_GUID(ndr, "root_key_id", &r->root_key_id);
	ndr_print_uint32(ndr, "additional_info_len", r->additional_info_len);
	ndr_print_uint32(ndr, "domain_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->domain_name, CH_UTF16):r->domain_name_len);
	ndr_print_uint32(ndr, "forest_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->forest_name, CH_UTF16):r->forest_name_len);
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_array_uint8(ndr, "additional_info", r->additional_info, r->additional_info_len);
		ndr->flags = _flags_save_uint8;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "domain_name", r->domain_name);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "forest_name", r->forest_name);
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_GroupKeyEnvelope(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct GroupKeyEnvelope *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x4b53444b));
		NDR_CHECK(ndr_push_EnvelopeFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l0_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l1_index));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l2_index));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->root_key_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->kdf_algorithm, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->kdf_parameters_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->secret_agreement_algorithm, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->secret_agreement_parameters_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->private_key_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->public_key_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l1_key_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->l2_key_len));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->domain_name, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->forest_name, CH_UTF16)));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->kdf_algorithm));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->kdf_parameters, r->kdf_parameters_len));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->secret_agreement_algorithm));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->secret_agreement_parameters, r->secret_agreement_parameters_len));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->forest_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->l1_key, r->l1_key_len));
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->l2_key, r->l2_key_len));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GroupKeyEnvelope(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct GroupKeyEnvelope *r)
{
	uint32_t size_kdf_parameters_0 = 0;
	uint32_t size_secret_agreement_parameters_0 = 0;
	uint32_t size_l1_key_0 = 0;
	uint32_t size_l2_key_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		if (r->magic < 1263748171 || r->magic > 1263748171) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->magic), (uint32_t)(1263748171), (uint32_t)(1263748171));
		}
		NDR_CHECK(ndr_pull_EnvelopeFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l0_index));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l1_index));
		if (r->l1_index > 31) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->l1_index), (uint32_t)(0), (uint32_t)(31));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l2_index));
		if (r->l2_index > 31) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->l2_index), (uint32_t)(0), (uint32_t)(31));
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->root_key_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->kdf_algorithm_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->kdf_parameters_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->secret_agreement_algorithm_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->secret_agreement_parameters_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->private_key_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->public_key_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l1_key_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->l2_key_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->domain_name_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->forest_name_len));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->kdf_algorithm));
			ndr->flags = _flags_save_string;
		}
		size_kdf_parameters_0 = r->kdf_parameters_len;
		NDR_PULL_ALLOC_N(ndr, r->kdf_parameters, size_kdf_parameters_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->kdf_parameters, size_kdf_parameters_0));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->secret_agreement_algorithm));
			ndr->flags = _flags_save_string;
		}
		size_secret_agreement_parameters_0 = r->secret_agreement_parameters_len;
		NDR_PULL_ALLOC_N(ndr, r->secret_agreement_parameters, size_secret_agreement_parameters_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->secret_agreement_parameters, size_secret_agreement_parameters_0));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->forest_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			size_l1_key_0 = r->l1_key_len;
			NDR_PULL_ALLOC_N(ndr, r->l1_key, size_l1_key_0);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->l1_key, size_l1_key_0));
			ndr->flags = _flags_save_uint8;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			size_l2_key_0 = r->l2_key_len;
			NDR_PULL_ALLOC_N(ndr, r->l2_key, size_l2_key_0);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->l2_key, size_l2_key_0));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_GroupKeyEnvelope(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct GroupKeyEnvelope *r)
{
	ndr_print_GroupKeyEnvelope(ndr, name, r);
}

_PUBLIC_ void ndr_print_GroupKeyEnvelope(struct ndr_print *ndr, const char *name, const struct GroupKeyEnvelope *r)
{
	ndr_print_struct(ndr, name, "GroupKeyEnvelope");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x4b53444b:r->magic);
	ndr_print_EnvelopeFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "l0_index", r->l0_index);
	ndr_print_uint32(ndr, "l1_index", r->l1_index);
	ndr_print_uint32(ndr, "l2_index", r->l2_index);
	ndr_print_GUID(ndr, "root_key_id", &r->root_key_id);
	ndr_print_uint32(ndr, "kdf_algorithm_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->kdf_algorithm, CH_UTF16):r->kdf_algorithm_len);
	ndr_print_uint32(ndr, "kdf_parameters_len", r->kdf_parameters_len);
	ndr_print_uint32(ndr, "secret_agreement_algorithm_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->secret_agreement_algorithm, CH_UTF16):r->secret_agreement_algorithm_len);
	ndr_print_uint32(ndr, "secret_agreement_parameters_len", r->secret_agreement_parameters_len);
	ndr_print_uint32(ndr, "private_key_len", r->private_key_len);
	ndr_print_uint32(ndr, "public_key_len", r->public_key_len);
	ndr_print_uint32(ndr, "l1_key_len", r->l1_key_len);
	ndr_print_uint32(ndr, "l2_key_len", r->l2_key_len);
	ndr_print_uint32(ndr, "domain_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->domain_name, CH_UTF16):r->domain_name_len);
	ndr_print_uint32(ndr, "forest_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->forest_name, CH_UTF16):r->forest_name_len);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "kdf_algorithm", r->kdf_algorithm);
		ndr->flags = _flags_save_string;
	}
	ndr_print_array_uint8(ndr, "kdf_parameters", r->kdf_parameters, r->kdf_parameters_len);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "secret_agreement_algorithm", r->secret_agreement_algorithm);
		ndr->flags = _flags_save_string;
	}
	ndr_print_array_uint8(ndr, "secret_agreement_parameters", r->secret_agreement_parameters, r->secret_agreement_parameters_len);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "domain_name", r->domain_name);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "forest_name", r->forest_name);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_array_uint8(ndr, "l1_key", r->l1_key, r->l1_key_len);
		ndr->flags = _flags_save_uint8;
	}
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_array_uint8(ndr, "l2_key", r->l2_key, r->l2_key_len);
		ndr->flags = _flags_save_uint8;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_KdfParameters(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct KdfParameters *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2 * ndr_charset_length(r->hash_algorithm, CH_UTF16)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->hash_algorithm));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_KdfParameters(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct KdfParameters *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->padding_0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->padding_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->hash_algorithm_len));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->padding_2));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->hash_algorithm));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_KdfParameters(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct KdfParameters *r)
{
	ndr_print_KdfParameters(ndr, name, r);
}

_PUBLIC_ void ndr_print_KdfParameters(struct ndr_print *ndr, const char *name, const struct KdfParameters *r)
{
	ndr_print_struct(ndr, name, "KdfParameters");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "padding_0", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->padding_0);
	ndr_print_uint32(ndr, "padding_1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->padding_1);
	ndr_print_uint32(ndr, "hash_algorithm_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2 * ndr_charset_length(r->hash_algorithm, CH_UTF16):r->hash_algorithm_len);
	ndr_print_uint32(ndr, "padding_2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->padding_2);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "hash_algorithm", r->hash_algorithm);
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_FfcDhParameters(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct FfcDhParameters *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 12 + 2 * r->key_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x4d504844));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->key_length));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->field_order, r->key_length));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->generator, r->key_length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_FfcDhParameters(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct FfcDhParameters *r)
{
	uint32_t size_field_order_0 = 0;
	uint32_t size_generator_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		if (r->magic < 1297107012 || r->magic > 1297107012) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->magic), (uint32_t)(1297107012), (uint32_t)(1297107012));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->key_length));
		size_field_order_0 = r->key_length;
		NDR_PULL_ALLOC_N(ndr, r->field_order, size_field_order_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->field_order, size_field_order_0));
		size_generator_0 = r->key_length;
		NDR_PULL_ALLOC_N(ndr, r->generator, size_generator_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->generator, size_generator_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_FfcDhParameters(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct FfcDhParameters *r)
{
	ndr_print_FfcDhParameters(ndr, name, r);
}

_PUBLIC_ void ndr_print_FfcDhParameters(struct ndr_print *ndr, const char *name, const struct FfcDhParameters *r)
{
	ndr_print_struct(ndr, name, "FfcDhParameters");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?12 + 2 * r->key_length:r->length);
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x4d504844:r->magic);
	ndr_print_uint32(ndr, "key_length", r->key_length);
	ndr_print_array_uint8(ndr, "field_order", r->field_order, r->key_length);
	ndr_print_array_uint8(ndr, "generator", r->generator, r->key_length);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_GkdiDerivationCtx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct GkdiDerivationCtx *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->l0_idx));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->l1_idx));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->l2_idx));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->target_security_descriptor));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GkdiDerivationCtx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct GkdiDerivationCtx *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->l0_idx));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->l1_idx));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->l2_idx));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->target_security_descriptor));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_GkdiDerivationCtx(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct GkdiDerivationCtx *r)
{
	ndr_print_GkdiDerivationCtx(ndr, name, r);
}

_PUBLIC_ void ndr_print_GkdiDerivationCtx(struct ndr_print *ndr, const char *name, const struct GkdiDerivationCtx *r)
{
	ndr_print_struct(ndr, name, "GkdiDerivationCtx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_int32(ndr, "l0_idx", r->l0_idx);
	ndr_print_int32(ndr, "l1_idx", r->l1_idx);
	ndr_print_int32(ndr, "l2_idx", r->l2_idx);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "target_security_descriptor", r->target_security_descriptor);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_gkdi_GetKey(struct ndr_push *ndr, ndr_flags_type flags, const struct gkdi_GetKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.target_sd == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.target_sd_len));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.target_sd_len));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.target_sd, r->in.target_sd_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.root_key_id));
		if (r->in.root_key_id) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.root_key_id));
		}
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.l0_key_id));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.l1_key_id));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->in.l2_key_id));
	}
	if (flags & NDR_OUT) {
		if (r->out.out_len == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.out_len));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.out));
		if (*r->out.out) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.out_len));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, *r->out.out, *r->out.out_len));
		}
		NDR_CHECK(ndr_push_HRESULT(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_gkdi_GetKey(struct ndr_pull *ndr, ndr_flags_type flags, struct gkdi_GetKey *r)
{
	uint32_t size_target_sd_1 = 0;
	uint32_t _ptr_root_key_id;
	uint32_t _ptr_out;
	uint32_t size_out_2 = 0;
	TALLOC_CTX *_mem_save_root_key_id_0 = NULL;
	TALLOC_CTX *_mem_save_out_len_0 = NULL;
	TALLOC_CTX *_mem_save_out_0 = NULL;
	TALLOC_CTX *_mem_save_out_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.target_sd_len));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.target_sd));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.target_sd, &size_target_sd_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.target_sd, size_target_sd_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.target_sd, size_target_sd_1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_root_key_id));
		if (_ptr_root_key_id) {
			NDR_PULL_ALLOC(ndr, r->in.root_key_id);
		} else {
			r->in.root_key_id = NULL;
		}
		if (r->in.root_key_id) {
			_mem_save_root_key_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.root_key_id, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.root_key_id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_root_key_id_0, 0);
		}
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.l0_key_id));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.l1_key_id));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->in.l2_key_id));
		NDR_PULL_ALLOC(ndr, r->out.out_len);
		NDR_ZERO_STRUCTP(r->out.out_len);
		NDR_PULL_ALLOC(ndr, r->out.out);
		NDR_ZERO_STRUCTP(r->out.out);
		if (r->in.target_sd) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.target_sd, r->in.target_sd_len));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.out_len);
		}
		_mem_save_out_len_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.out_len, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.out_len));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_len_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.out);
		}
		_mem_save_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_out));
		if (_ptr_out) {
			NDR_PULL_ALLOC(ndr, *r->out.out);
		} else {
			*r->out.out = NULL;
		}
		if (*r->out.out) {
			_mem_save_out_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.out, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.out));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)r->out.out, &size_out_2));
			NDR_PULL_ALLOC_N(ndr, *r->out.out, size_out_2);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, *r->out.out, size_out_2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_out_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_HRESULT(ndr, NDR_SCALARS, &r->out.result));
		if (*r->out.out) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)r->out.out, *r->out.out_len));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_gkdi_GetKey(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct gkdi_GetKey *r)
{
	ndr_print_struct(ndr, name, "gkdi_GetKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "gkdi_GetKey");
		ndr->depth++;
		ndr_print_uint32(ndr, "target_sd_len", r->in.target_sd_len);
		ndr_print_ptr(ndr, "target_sd", r->in.target_sd);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "target_sd", r->in.target_sd, r->in.target_sd_len);
		ndr->depth--;
		ndr_print_ptr(ndr, "root_key_id", r->in.root_key_id);
		ndr->depth++;
		if (r->in.root_key_id) {
			ndr_print_GUID(ndr, "root_key_id", r->in.root_key_id);
		}
		ndr->depth--;
		ndr_print_int32(ndr, "l0_key_id", r->in.l0_key_id);
		ndr_print_int32(ndr, "l1_key_id", r->in.l1_key_id);
		ndr_print_int32(ndr, "l2_key_id", r->in.l2_key_id);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "gkdi_GetKey");
		ndr->depth++;
		ndr_print_ptr(ndr, "out_len", r->out.out_len);
		ndr->depth++;
		ndr_print_uint32(ndr, "out_len", *r->out.out_len);
		ndr->depth--;
		ndr_print_ptr(ndr, "out", r->out.out);
		ndr->depth++;
		ndr_print_ptr(ndr, "out", *r->out.out);
		ndr->depth++;
		if (*r->out.out) {
			ndr_print_array_uint8(ndr, "out", *r->out.out, *r->out.out_len);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_HRESULT(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_gkdi
static const struct ndr_interface_public_struct gkdi_public_structs[] = {
	{
		.name = "KeyEnvelope",
		.struct_size = sizeof(struct KeyEnvelope ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_KeyEnvelope,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_KeyEnvelope,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_KeyEnvelope,
	},
	{
		.name = "GroupKeyEnvelope",
		.struct_size = sizeof(struct GroupKeyEnvelope ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_GroupKeyEnvelope,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_GroupKeyEnvelope,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_GroupKeyEnvelope,
	},
	{
		.name = "KdfParameters",
		.struct_size = sizeof(struct KdfParameters ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_KdfParameters,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_KdfParameters,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_KdfParameters,
	},
	{
		.name = "FfcDhParameters",
		.struct_size = sizeof(struct FfcDhParameters ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_FfcDhParameters,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_FfcDhParameters,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_FfcDhParameters,
	},
	{
		.name = "GkdiDerivationCtx",
		.struct_size = sizeof(struct GkdiDerivationCtx ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_GkdiDerivationCtx,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_GkdiDerivationCtx,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_GkdiDerivationCtx,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call gkdi_calls[] = {
	{
		"gkdi_GetKey",
		sizeof(struct gkdi_GetKey),
		(ndr_push_flags_fn_t) ndr_push_gkdi_GetKey,
		(ndr_pull_flags_fn_t) ndr_pull_gkdi_GetKey,
		(ndr_print_function_t) ndr_print_gkdi_GetKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const gkdi_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\lsass]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array gkdi_endpoints = {
	.count	= 3,
	.names	= gkdi_endpoint_strings
};

static const char * const gkdi_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array gkdi_authservices = {
	.count	= 1,
	.names	= gkdi_authservice_strings
};


const struct ndr_interface_table ndr_table_gkdi = {
	.name		= "gkdi",
	.syntax_id	= {
		{0xb9785960,0x524f,0x11df,{0x8b,0x6d},{0x83,0xdc,0xde,0xd7,0x20,0x85}},
		NDR_GKDI_VERSION
	},
	.helpstring	= NDR_GKDI_HELPSTRING,
	.num_calls	= 1,
	.calls		= gkdi_calls,
	.num_public_structs	= 5,
	.public_structs		= gkdi_public_structs,
	.endpoints	= &gkdi_endpoints,
	.authservices	= &gkdi_authservices
};

#endif /* SKIP_NDR_TABLE_gkdi */
