/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_drsuapi.h"

#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_samr.h"
#include "librpc/ndr/ndr_compression.h"
_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DrsOptions(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DrsOptions(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DrsOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_ASYNC_OP", DRSUAPI_DRS_ASYNC_OP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_GETCHG_CHECK", DRSUAPI_DRS_GETCHG_CHECK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_UPDATE_NOTIFICATION", DRSUAPI_DRS_UPDATE_NOTIFICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_ADD_REF", DRSUAPI_DRS_ADD_REF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SYNC_ALL", DRSUAPI_DRS_SYNC_ALL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_DEL_REF", DRSUAPI_DRS_DEL_REF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_WRIT_REP", DRSUAPI_DRS_WRIT_REP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_INIT_SYNC", DRSUAPI_DRS_INIT_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_PER_SYNC", DRSUAPI_DRS_PER_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_MAIL_REP", DRSUAPI_DRS_MAIL_REP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_ASYNC_REP", DRSUAPI_DRS_ASYNC_REP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_IGNORE_ERROR", DRSUAPI_DRS_IGNORE_ERROR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_TWOWAY_SYNC", DRSUAPI_DRS_TWOWAY_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_CRITICAL_ONLY", DRSUAPI_DRS_CRITICAL_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_GET_ANC", DRSUAPI_DRS_GET_ANC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_GET_NC_SIZE", DRSUAPI_DRS_GET_NC_SIZE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_LOCAL_ONLY", DRSUAPI_DRS_LOCAL_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_NONGC_RO_REP", DRSUAPI_DRS_NONGC_RO_REP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SYNC_BYNAME", DRSUAPI_DRS_SYNC_BYNAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_REF_OK", DRSUAPI_DRS_REF_OK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_FULL_SYNC_NOW", DRSUAPI_DRS_FULL_SYNC_NOW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_NO_SOURCE", DRSUAPI_DRS_NO_SOURCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_FULL_SYNC_IN_PROGRESS", DRSUAPI_DRS_FULL_SYNC_IN_PROGRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_FULL_SYNC_PACKET", DRSUAPI_DRS_FULL_SYNC_PACKET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SYNC_REQUEUE", DRSUAPI_DRS_SYNC_REQUEUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SYNC_URGENT", DRSUAPI_DRS_SYNC_URGENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_REF_GCSPN", DRSUAPI_DRS_REF_GCSPN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_NO_DISCARD", DRSUAPI_DRS_NO_DISCARD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_NEVER_SYNCED", DRSUAPI_DRS_NEVER_SYNCED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SPECIAL_SECRET_PROCESSING", DRSUAPI_DRS_SPECIAL_SECRET_PROCESSING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_INIT_SYNC_NOW", DRSUAPI_DRS_INIT_SYNC_NOW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_PREEMPTED", DRSUAPI_DRS_PREEMPTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SYNC_FORCED", DRSUAPI_DRS_SYNC_FORCED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_DISABLE_AUTO_SYNC", DRSUAPI_DRS_DISABLE_AUTO_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_DISABLE_PERIODIC_SYNC", DRSUAPI_DRS_DISABLE_PERIODIC_SYNC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_USE_COMPRESSION", DRSUAPI_DRS_USE_COMPRESSION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_NEVER_NOTIFY", DRSUAPI_DRS_NEVER_NOTIFY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_SYNC_PAS", DRSUAPI_DRS_SYNC_PAS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_GET_ALL_GROUP_MEMBERSHIP", DRSUAPI_DRS_GET_ALL_GROUP_MEMBERSHIP, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DrsMoreOptions(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DrsMoreOptions(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DrsMoreOptions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_GET_TGT", DRSUAPI_DRS_GET_TGT, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DrsUpdate(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DrsUpdate(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DrsUpdate(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_UPDATE_FLAGS", DRSUAPI_DRS_UPDATE_FLAGS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_UPDATE_ADDRESS", DRSUAPI_DRS_UPDATE_ADDRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DRS_UPDATE_SCHEDULE", DRSUAPI_DRS_UPDATE_SCHEDULE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_SupportedExtensions(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_SupportedExtensions(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_SupportedExtensions(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_BASE", DRSUAPI_SUPPORTED_EXTENSION_BASE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION", DRSUAPI_SUPPORTED_EXTENSION_ASYNC_REPLICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI", DRSUAPI_SUPPORTED_EXTENSION_REMOVEAPI, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2", DRSUAPI_SUPPORTED_EXTENSION_MOVEREQ_V2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS", DRSUAPI_SUPPORTED_EXTENSION_GETCHG_COMPRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1", DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V1, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION", DRSUAPI_SUPPORTED_EXTENSION_RESTORE_USN_OPTIMIZATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY", DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE", DRSUAPI_SUPPORTED_EXTENSION_KCC_EXECUTE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2", DRSUAPI_SUPPORTED_EXTENSION_ADDENTRY_V2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION", DRSUAPI_SUPPORTED_EXTENSION_LINKED_VALUE_REPLICATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2", DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD", DRSUAPI_SUPPORTED_EXTENSION_INSTANCE_TYPE_NOT_REQ_ON_MOD, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND", DRSUAPI_SUPPORTED_EXTENSION_CRYPTO_BIND, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO", DRSUAPI_SUPPORTED_EXTENSION_GET_REPL_INFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION", DRSUAPI_SUPPORTED_EXTENSION_STRONG_ENCRYPTION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01", DRSUAPI_SUPPORTED_EXTENSION_DCINFO_V01, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP", DRSUAPI_SUPPORTED_EXTENSION_TRANSITIVE_MEMBERSHIP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY", DRSUAPI_SUPPORTED_EXTENSION_ADD_SID_HISTORY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3", DRSUAPI_SUPPORTED_EXTENSION_POST_BETA3, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V5", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2", DRSUAPI_SUPPORTED_EXTENSION_GET_MEMBERSHIPS2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS", DRSUAPI_SUPPORTED_EXTENSION_NONDOMAIN_NCS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V8, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V5, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3", DRSUAPI_SUPPORTED_EXTENSION_ADDENTRYREPLY_V3, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREPLY_V7, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT", DRSUAPI_SUPPORTED_EXTENSION_VERIFY_OBJECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS", DRSUAPI_SUPPORTED_EXTENSION_XPRESS_COMPRESS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V10", DRSUAPI_SUPPORTED_EXTENSION_GETCHGREQ_V10, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_RESERVED_PART2", DRSUAPI_SUPPORTED_EXTENSION_RESERVED_PART2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_RESERVED_PART3", DRSUAPI_SUPPORTED_EXTENSION_RESERVED_PART3, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_SupportedExtensionsExt(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_SupportedExtensionsExt(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_SupportedExtensionsExt(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_ADAM", DRSUAPI_SUPPORTED_EXTENSION_ADAM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_LH_BETA2", DRSUAPI_SUPPORTED_EXTENSION_LH_BETA2, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_SUPPORTED_EXTENSION_RECYCLE_BIN", DRSUAPI_SUPPORTED_EXTENSION_RECYCLE_BIN, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBindInfo24(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfo24 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBindInfo24(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfo24 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsBindInfo24(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsBindInfo24 *r)
{
	ndr_print_drsuapi_DsBindInfo24(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo24(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo24 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo24");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "pid", r->pid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBindInfo28(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfo28 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->repl_epoch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBindInfo28(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfo28 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->repl_epoch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsBindInfo28(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsBindInfo28 *r)
{
	ndr_print_drsuapi_DsBindInfo28(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo28(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo28 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo28");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "pid", r->pid);
	ndr_print_uint32(ndr, "repl_epoch", r->repl_epoch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBindInfo32(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfo32 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->repl_epoch));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, r->supported_extensions_ext));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBindInfo32(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfo32 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->repl_epoch));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, &r->supported_extensions_ext));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsBindInfo32(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsBindInfo32 *r)
{
	ndr_print_drsuapi_DsBindInfo32(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo32(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo32 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo32");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "pid", r->pid);
	ndr_print_uint32(ndr, "repl_epoch", r->repl_epoch);
	ndr_print_drsuapi_SupportedExtensionsExt(ndr, "supported_extensions_ext", r->supported_extensions_ext);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBindInfo48(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfo48 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->repl_epoch));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, r->supported_extensions_ext));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->config_dn_guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBindInfo48(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfo48 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->repl_epoch));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, &r->supported_extensions_ext));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->config_dn_guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsBindInfo48(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsBindInfo48 *r)
{
	ndr_print_drsuapi_DsBindInfo48(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo48(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo48 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo48");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "pid", r->pid);
	ndr_print_uint32(ndr, "repl_epoch", r->repl_epoch);
	ndr_print_drsuapi_SupportedExtensionsExt(ndr, "supported_extensions_ext", r->supported_extensions_ext);
	ndr_print_GUID(ndr, "config_dn_guid", &r->config_dn_guid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBindInfo52(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfo52 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, r->supported_extensions));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->repl_epoch));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, r->supported_extensions_ext));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->config_dn_guid));
		NDR_CHECK(ndr_push_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, r->supported_capabilities_ext));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBindInfo52(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfo52 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensions(ndr, NDR_SCALARS, &r->supported_extensions));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->repl_epoch));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, &r->supported_extensions_ext));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->config_dn_guid));
		NDR_CHECK(ndr_pull_drsuapi_SupportedExtensionsExt(ndr, NDR_SCALARS, &r->supported_capabilities_ext));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsBindInfo52(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsBindInfo52 *r)
{
	ndr_print_drsuapi_DsBindInfo52(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfo52(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfo52 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfo52");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_SupportedExtensions(ndr, "supported_extensions", r->supported_extensions);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_uint32(ndr, "pid", r->pid);
	ndr_print_uint32(ndr, "repl_epoch", r->repl_epoch);
	ndr_print_drsuapi_SupportedExtensionsExt(ndr, "supported_extensions_ext", r->supported_extensions_ext);
	ndr_print_GUID(ndr, "config_dn_guid", &r->config_dn_guid);
	ndr_print_drsuapi_SupportedExtensionsExt(ndr, "supported_capabilities_ext", r->supported_capabilities_ext);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBindInfoFallBack(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfoFallBack *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBindInfoFallBack(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfoFallBack *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->info));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsBindInfoFallBack(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsBindInfoFallBack *r)
{
	ndr_print_drsuapi_DsBindInfoFallBack(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfoFallBack(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfoFallBack *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfoFallBack");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "info", r->info);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsBindInfoCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsBindInfoCtr *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->info, r->length));
			NDR_CHECK(ndr_push_drsuapi_DsBindInfo(ndr, NDR_SCALARS, &r->info));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsBindInfoCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsBindInfoCtr *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->length));
			if (r->length < 1 || r->length > 10000) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->length), (uint32_t)(1), (uint32_t)(10000));
			}
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_length));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->info, r->length));
			NDR_CHECK(ndr_pull_drsuapi_DsBindInfo(ndr, NDR_SCALARS, &r->info));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsBindInfoCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsBindInfoCtr *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBindInfoCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint3264(ndr, "length", r->length);
		ndr_print_uint32(ndr, "__ndr_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->length:r->__ndr_length);
		ndr_print_set_switch_value(ndr, &r->info, r->length);
		ndr_print_drsuapi_DsBindInfo(ndr, "info", &r->info);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectIdentifier(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, strlen_m(r->dn) + 1));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsReplicaObjectIdentifier(r, ndr->flags) - 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid28(&r->sid, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m(r->dn)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dn, strlen_m(r->dn) + 1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectIdentifier(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjectIdentifier *r)
{
	uint32_t size_dn_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->dn));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_sid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_dn));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->dn, &size_dn_0));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dn, size_dn_0, sizeof(uint16_t), CH_UTF16));
		if (r->dn) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->dn, r->__ndr_size_dn + 1));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaObjectIdentifier(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaObjectIdentifier *r)
{
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaObjectIdentifier(r, ndr->flags) - 4:r->__ndr_size);
	ndr_print_uint32(ndr, "__ndr_size_sid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid28(&r->sid, ndr->flags):r->__ndr_size_sid);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr_print_uint32(ndr, "__ndr_size_dn", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->dn):r->__ndr_size_dn);
	ndr_print_string(ndr, "dn", r->dn);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsReplicaObjectIdentifier(const struct drsuapi_DsReplicaObjectIdentifier *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier);
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaSyncRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaSyncRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_dns));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->source_dsa_dns) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_dns, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_dns, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_dns, ndr_charset_length(r->source_dsa_dns, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaSyncRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaSyncRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_source_dsa_dns;
	uint32_t size_source_dsa_dns_1 = 0;
	uint32_t length_source_dsa_dns_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_dns_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_dns));
		if (_ptr_source_dsa_dns) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_dns);
		} else {
			r->source_dsa_dns = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->source_dsa_dns) {
			_mem_save_source_dsa_dns_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_dns, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_dns));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_dns));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_dns, &size_source_dsa_dns_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_dns, &length_source_dsa_dns_1));
			if (length_source_dsa_dns_1 > size_source_dsa_dns_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_dns_1, length_source_dsa_dns_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_dns_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_dns, length_source_dsa_dns_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_dns_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSyncRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaSyncRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaSyncRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr_print_ptr(ndr, "source_dsa_dns", r->source_dsa_dns);
	ndr->depth++;
	if (r->source_dsa_dns) {
		ndr_print_string(ndr, "source_dsa_dns", r->source_dsa_dns);
	}
	ndr->depth--;
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaSyncRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaSyncRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaSyncRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaSyncRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSyncRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaSyncRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaSyncRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaSyncRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaHighWaterMark(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaHighWaterMark *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->tmp_highest_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->reserved_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaHighWaterMark(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaHighWaterMark *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->tmp_highest_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->reserved_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaHighWaterMark(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaHighWaterMark *r)
{
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaHighWaterMark(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaHighWaterMark *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaHighWaterMark");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "tmp_highest_usn", r->tmp_highest_usn);
	ndr_print_hyper(ndr, "reserved_usn", r->reserved_usn);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaCursor(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursor *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursor(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursor *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaCursor(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaCursor *r)
{
	ndr_print_drsuapi_DsReplicaCursor(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaCursorCtrEx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursorCtrEx *r)
{
	uint32_t cntr_cursors_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		for (cntr_cursors_0 = 0; cntr_cursors_0 < (r->count); cntr_cursors_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursorCtrEx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursorCtrEx *r)
{
	uint32_t size_cursors_0 = 0;
	uint32_t cntr_cursors_0;
	TALLOC_CTX *_mem_save_cursors_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->cursors));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved2));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->cursors, &size_cursors_0));
		NDR_PULL_ALLOC_N(ndr, r->cursors, size_cursors_0);
		_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
		for (cntr_cursors_0 = 0; cntr_cursors_0 < (size_cursors_0); cntr_cursors_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
		if (r->cursors) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->cursors, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursorCtrEx(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursorCtrEx *r)
{
	uint32_t cntr_cursors_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursorCtrEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->version);
	ndr_print_uint32(ndr, "reserved1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved1);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved2);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "cursors", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_cursors_0 = 0; cntr_cursors_0 < (r->count); cntr_cursors_0++) {
		ndr_print_drsuapi_DsReplicaCursor(ndr, "cursors", &r->cursors[cntr_cursors_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsExtendedOperation(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsExtendedOperation r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsExtendedOperation(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsExtendedOperation *r)
{
	uint32_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsExtendedOperation(struct ndr_print *ndr, const char *name, enum drsuapi_DsExtendedOperation r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case DRSUAPI_EXOP_NONE: val = "DRSUAPI_EXOP_NONE"; break;
			case DRSUAPI_EXOP_FSMO_REQ_ROLE: val = "DRSUAPI_EXOP_FSMO_REQ_ROLE"; break;
			case DRSUAPI_EXOP_FSMO_RID_ALLOC: val = "DRSUAPI_EXOP_FSMO_RID_ALLOC"; break;
			case DRSUAPI_EXOP_FSMO_RID_REQ_ROLE: val = "DRSUAPI_EXOP_FSMO_RID_REQ_ROLE"; break;
			case DRSUAPI_EXOP_FSMO_REQ_PDC: val = "DRSUAPI_EXOP_FSMO_REQ_PDC"; break;
			case DRSUAPI_EXOP_FSMO_ABANDON_ROLE: val = "DRSUAPI_EXOP_FSMO_ABANDON_ROLE"; break;
			case DRSUAPI_EXOP_REPL_OBJ: val = "DRSUAPI_EXOP_REPL_OBJ"; break;
			case DRSUAPI_EXOP_REPL_SECRET: val = "DRSUAPI_EXOP_REPL_SECRET"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsExtendedError(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsExtendedError r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsExtendedError(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsExtendedError *r)
{
	uint32_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsExtendedError(struct ndr_print *ndr, const char *name, enum drsuapi_DsExtendedError r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case DRSUAPI_EXOP_ERR_NONE: val = "DRSUAPI_EXOP_ERR_NONE"; break;
			case DRSUAPI_EXOP_ERR_SUCCESS: val = "DRSUAPI_EXOP_ERR_SUCCESS"; break;
			case DRSUAPI_EXOP_ERR_UNKNOWN_OP: val = "DRSUAPI_EXOP_ERR_UNKNOWN_OP"; break;
			case DRSUAPI_EXOP_ERR_FSMO_NOT_OWNER: val = "DRSUAPI_EXOP_ERR_FSMO_NOT_OWNER"; break;
			case DRSUAPI_EXOP_ERR_UPDATE_ERR: val = "DRSUAPI_EXOP_ERR_UPDATE_ERR"; break;
			case DRSUAPI_EXOP_ERR_EXCEPTION: val = "DRSUAPI_EXOP_ERR_EXCEPTION"; break;
			case DRSUAPI_EXOP_ERR_UNKNOWN_CALLER: val = "DRSUAPI_EXOP_ERR_UNKNOWN_CALLER"; break;
			case DRSUAPI_EXOP_ERR_RID_ALLOC: val = "DRSUAPI_EXOP_ERR_RID_ALLOC"; break;
			case DRSUAPI_EXOP_ERR_FSMO_OWNER_DELETED: val = "DRSUAPI_EXOP_ERR_FSMO_OWNER_DELETED"; break;
			case DRSUAPI_EXOP_ERR_FMSO_PENDING_OP: val = "DRSUAPI_EXOP_ERR_FMSO_PENDING_OP"; break;
			case DRSUAPI_EXOP_ERR_MISMATCH: val = "DRSUAPI_EXOP_ERR_MISMATCH"; break;
			case DRSUAPI_EXOP_ERR_COULDNT_CONTACT: val = "DRSUAPI_EXOP_ERR_COULDNT_CONTACT"; break;
			case DRSUAPI_EXOP_ERR_FSMO_REFUSING_ROLES: val = "DRSUAPI_EXOP_ERR_FSMO_REFUSING_ROLES"; break;
			case DRSUAPI_EXOP_ERR_DIR_ERROR: val = "DRSUAPI_EXOP_ERR_DIR_ERROR"; break;
			case DRSUAPI_EXOP_ERR_FSMO_MISSING_SETTINGS: val = "DRSUAPI_EXOP_ERR_FSMO_MISSING_SETTINGS"; break;
			case DRSUAPI_EXOP_ERR_ACCESS_DENIED: val = "DRSUAPI_EXOP_ERR_ACCESS_DENIED"; break;
			case DRSUAPI_EXOP_ERR_PARAM_ERROR: val = "DRSUAPI_EXOP_ERR_PARAM_ERROR"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesRequest5(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesRequest5 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_ndr_size));
		NDR_CHECK(ndr_push_drsuapi_DsExtendedOperation(ndr, NDR_SCALARS, r->extended_op));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->fsmo_info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesRequest5(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesRequest5 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_ndr_size));
		NDR_CHECK(ndr_pull_drsuapi_DsExtendedOperation(ndr, NDR_SCALARS, &r->extended_op));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->fsmo_info));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest5(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesRequest5 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesRequest5");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "destination_dsa_guid", &r->destination_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "highwatermark", &r->highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DrsOptions(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "max_object_count", r->max_object_count);
	ndr_print_uint32(ndr, "max_ndr_size", r->max_ndr_size);
	ndr_print_drsuapi_DsExtendedOperation(ndr, "extended_op", r->extended_op);
	ndr_print_hyper(ndr, "fsmo_info", r->fsmo_info);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaOID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaOID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->binary_oid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->binary_oid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->binary_oid, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaOID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaOID *r)
{
	uint32_t _ptr_binary_oid;
	uint32_t size_binary_oid_1 = 0;
	TALLOC_CTX *_mem_save_binary_oid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		if (r->length > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->length), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_oid));
		if (_ptr_binary_oid) {
			NDR_PULL_ALLOC(ndr, r->binary_oid);
		} else {
			r->binary_oid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->binary_oid) {
			_mem_save_binary_oid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->binary_oid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->binary_oid));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->binary_oid, &size_binary_oid_1));
			NDR_PULL_ALLOC_N(ndr, r->binary_oid, size_binary_oid_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->binary_oid, size_binary_oid_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_oid_0, 0);
		}
		if (r->binary_oid) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->binary_oid, r->length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaOIDMapping(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaOIDMapping *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->id_prefix));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOID(ndr, NDR_SCALARS, &r->oid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOID(ndr, NDR_BUFFERS, &r->oid));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaOIDMapping(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaOIDMapping *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->id_prefix));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOID(ndr, NDR_SCALARS, &r->oid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOID(ndr, NDR_BUFFERS, &r->oid));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOIDMapping(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOIDMapping *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOIDMapping");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "id_prefix", r->id_prefix);
	ndr_print_drsuapi_DsReplicaOID(ndr, "oid", &r->oid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	uint32_t cntr_mappings_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_mappings));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->mappings));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->mappings) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_mappings));
			for (cntr_mappings_1 = 0; cntr_mappings_1 < (r->num_mappings); cntr_mappings_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping(ndr, NDR_SCALARS, &r->mappings[cntr_mappings_1]));
			}
			for (cntr_mappings_1 = 0; cntr_mappings_1 < (r->num_mappings); cntr_mappings_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping(ndr, NDR_BUFFERS, &r->mappings[cntr_mappings_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	uint32_t _ptr_mappings;
	uint32_t size_mappings_1 = 0;
	uint32_t cntr_mappings_1;
	TALLOC_CTX *_mem_save_mappings_0 = NULL;
	TALLOC_CTX *_mem_save_mappings_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_mappings));
		if (r->num_mappings > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_mappings), (uint32_t)(0), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_mappings));
		if (_ptr_mappings) {
			NDR_PULL_ALLOC(ndr, r->mappings);
		} else {
			r->mappings = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->mappings) {
			_mem_save_mappings_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->mappings, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->mappings));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->mappings, &size_mappings_1));
			NDR_PULL_ALLOC_N(ndr, r->mappings, size_mappings_1);
			_mem_save_mappings_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->mappings, 0);
			for (cntr_mappings_1 = 0; cntr_mappings_1 < (size_mappings_1); cntr_mappings_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping(ndr, NDR_SCALARS, &r->mappings[cntr_mappings_1]));
			}
			for (cntr_mappings_1 = 0; cntr_mappings_1 < (size_mappings_1); cntr_mappings_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping(ndr, NDR_BUFFERS, &r->mappings[cntr_mappings_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_mappings_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_mappings_0, 0);
		}
		if (r->mappings) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->mappings, r->num_mappings));
		}
		for (cntr_mappings_1 = 0; cntr_mappings_1 < (size_mappings_1); cntr_mappings_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOIDMapping_Ctr *r)
{
	uint32_t cntr_mappings_1;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOIDMapping_Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_mappings", r->num_mappings);
	ndr_print_ptr(ndr, "mappings", r->mappings);
	ndr->depth++;
	if (r->mappings) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "mappings", (uint32_t)(r->num_mappings));
		ndr->depth++;
		for (cntr_mappings_1 = 0; cntr_mappings_1 < (r->num_mappings); cntr_mappings_1++) {
			ndr_print_drsuapi_DsReplicaOIDMapping(ndr, "mappings", &r->mappings[cntr_mappings_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsAttributeId(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAttributeId r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsAttributeId(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAttributeId *r)
{
	uint32_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAttributeId(struct ndr_print *ndr, const char *name, enum drsuapi_DsAttributeId r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case DRSUAPI_ATTID_objectClass: val = "DRSUAPI_ATTID_objectClass"; break;
			case DRSUAPI_ATTID_cn: val = "DRSUAPI_ATTID_cn"; break;
			case DRSUAPI_ATTID_ou: val = "DRSUAPI_ATTID_ou"; break;
			case DRSUAPI_ATTID_description: val = "DRSUAPI_ATTID_description"; break;
			case DRSUAPI_ATTID_member: val = "DRSUAPI_ATTID_member"; break;
			case DRSUAPI_ATTID_distinguishedName: val = "DRSUAPI_ATTID_distinguishedName"; break;
			case DRSUAPI_ATTID_instanceType: val = "DRSUAPI_ATTID_instanceType"; break;
			case DRSUAPI_ATTID_whenCreated: val = "DRSUAPI_ATTID_whenCreated"; break;
			case DRSUAPI_ATTID_possSuperiors: val = "DRSUAPI_ATTID_possSuperiors"; break;
			case DRSUAPI_ATTID_displayName: val = "DRSUAPI_ATTID_displayName"; break;
			case DRSUAPI_ATTID_hasMasterNCs: val = "DRSUAPI_ATTID_hasMasterNCs"; break;
			case DRSUAPI_ATTID_nCName: val = "DRSUAPI_ATTID_nCName"; break;
			case DRSUAPI_ATTID_subClassOf: val = "DRSUAPI_ATTID_subClassOf"; break;
			case DRSUAPI_ATTID_governsID: val = "DRSUAPI_ATTID_governsID"; break;
			case DRSUAPI_ATTID_mustContain: val = "DRSUAPI_ATTID_mustContain"; break;
			case DRSUAPI_ATTID_mayContain: val = "DRSUAPI_ATTID_mayContain"; break;
			case DRSUAPI_ATTID_rDNAttId: val = "DRSUAPI_ATTID_rDNAttId"; break;
			case DRSUAPI_ATTID_attributeID: val = "DRSUAPI_ATTID_attributeID"; break;
			case DRSUAPI_ATTID_attributeSyntax: val = "DRSUAPI_ATTID_attributeSyntax"; break;
			case DRSUAPI_ATTID_isSingleValued: val = "DRSUAPI_ATTID_isSingleValued"; break;
			case DRSUAPI_ATTID_rangeLower: val = "DRSUAPI_ATTID_rangeLower"; break;
			case DRSUAPI_ATTID_rangeUpper: val = "DRSUAPI_ATTID_rangeUpper"; break;
			case DRSUAPI_ATTID_dMDLocation: val = "DRSUAPI_ATTID_dMDLocation"; break;
			case DRSUAPI_ATTID_isDeleted: val = "DRSUAPI_ATTID_isDeleted"; break;
			case DRSUAPI_ATTID_objectVersion: val = "DRSUAPI_ATTID_objectVersion"; break;
			case DRSUAPI_ATTID_invocationId: val = "DRSUAPI_ATTID_invocationId"; break;
			case DRSUAPI_ATTID_showInAdvancedViewOnly: val = "DRSUAPI_ATTID_showInAdvancedViewOnly"; break;
			case DRSUAPI_ATTID_adminDisplayName: val = "DRSUAPI_ATTID_adminDisplayName"; break;
			case DRSUAPI_ATTID_adminDescription: val = "DRSUAPI_ATTID_adminDescription"; break;
			case DRSUAPI_ATTID_oMSyntax: val = "DRSUAPI_ATTID_oMSyntax"; break;
			case DRSUAPI_ATTID_ntSecurityDescriptor: val = "DRSUAPI_ATTID_ntSecurityDescriptor"; break;
			case DRSUAPI_ATTID_searchFlags: val = "DRSUAPI_ATTID_searchFlags"; break;
			case DRSUAPI_ATTID_auxiliaryClass: val = "DRSUAPI_ATTID_auxiliaryClass"; break;
			case DRSUAPI_ATTID_lDAPDisplayName: val = "DRSUAPI_ATTID_lDAPDisplayName"; break;
			case DRSUAPI_ATTID_name: val = "DRSUAPI_ATTID_name"; break;
			case DRSUAPI_ATTID_objectGUID: val = "DRSUAPI_ATTID_objectGUID"; break;
			case DRSUAPI_ATTID_replPropertyMetaData: val = "DRSUAPI_ATTID_replPropertyMetaData"; break;
			case DRSUAPI_ATTID_userAccountControl: val = "DRSUAPI_ATTID_userAccountControl"; break;
			case DRSUAPI_ATTID_badPwdCount: val = "DRSUAPI_ATTID_badPwdCount"; break;
			case DRSUAPI_ATTID_codePage: val = "DRSUAPI_ATTID_codePage"; break;
			case DRSUAPI_ATTID_countryCode: val = "DRSUAPI_ATTID_countryCode"; break;
			case DRSUAPI_ATTID_currentValue: val = "DRSUAPI_ATTID_currentValue"; break;
			case DRSUAPI_ATTID_homeDirectory: val = "DRSUAPI_ATTID_homeDirectory"; break;
			case DRSUAPI_ATTID_homeDrive: val = "DRSUAPI_ATTID_homeDrive"; break;
			case DRSUAPI_ATTID_lastLogoff: val = "DRSUAPI_ATTID_lastLogoff"; break;
			case DRSUAPI_ATTID_lastLogon: val = "DRSUAPI_ATTID_lastLogon"; break;
			case DRSUAPI_ATTID_dBCSPwd: val = "DRSUAPI_ATTID_dBCSPwd"; break;
			case DRSUAPI_ATTID_scriptPath: val = "DRSUAPI_ATTID_scriptPath"; break;
			case DRSUAPI_ATTID_logonHours: val = "DRSUAPI_ATTID_logonHours"; break;
			case DRSUAPI_ATTID_userWorkstations: val = "DRSUAPI_ATTID_userWorkstations"; break;
			case DRSUAPI_ATTID_unicodePwd: val = "DRSUAPI_ATTID_unicodePwd"; break;
			case DRSUAPI_ATTID_ntPwdHistory: val = "DRSUAPI_ATTID_ntPwdHistory"; break;
			case DRSUAPI_ATTID_pwdLastSet: val = "DRSUAPI_ATTID_pwdLastSet"; break;
			case DRSUAPI_ATTID_primaryGroupID: val = "DRSUAPI_ATTID_primaryGroupID"; break;
			case DRSUAPI_ATTID_priorValue: val = "DRSUAPI_ATTID_priorValue"; break;
			case DRSUAPI_ATTID_supplementalCredentials: val = "DRSUAPI_ATTID_supplementalCredentials"; break;
			case DRSUAPI_ATTID_trustAuthIncoming: val = "DRSUAPI_ATTID_trustAuthIncoming"; break;
			case DRSUAPI_ATTID_trustDirection: val = "DRSUAPI_ATTID_trustDirection"; break;
			case DRSUAPI_ATTID_trustPartner: val = "DRSUAPI_ATTID_trustPartner"; break;
			case DRSUAPI_ATTID_trustPosixOffset: val = "DRSUAPI_ATTID_trustPosixOffset"; break;
			case DRSUAPI_ATTID_trustAuthOutgoing: val = "DRSUAPI_ATTID_trustAuthOutgoing"; break;
			case DRSUAPI_ATTID_trustType: val = "DRSUAPI_ATTID_trustType"; break;
			case DRSUAPI_ATTID_userParameters: val = "DRSUAPI_ATTID_userParameters"; break;
			case DRSUAPI_ATTID_profilePath: val = "DRSUAPI_ATTID_profilePath"; break;
			case DRSUAPI_ATTID_operatorCount: val = "DRSUAPI_ATTID_operatorCount"; break;
			case DRSUAPI_ATTID_objectSid: val = "DRSUAPI_ATTID_objectSid"; break;
			case DRSUAPI_ATTID_schemaIDGUID: val = "DRSUAPI_ATTID_schemaIDGUID"; break;
			case DRSUAPI_ATTID_adminCount: val = "DRSUAPI_ATTID_adminCount"; break;
			case DRSUAPI_ATTID_comment: val = "DRSUAPI_ATTID_comment"; break;
			case DRSUAPI_ATTID_accountExpires: val = "DRSUAPI_ATTID_accountExpires"; break;
			case DRSUAPI_ATTID_lmPwdHistory: val = "DRSUAPI_ATTID_lmPwdHistory"; break;
			case DRSUAPI_ATTID_logonCount: val = "DRSUAPI_ATTID_logonCount"; break;
			case DRSUAPI_ATTID_systemPossSuperiors: val = "DRSUAPI_ATTID_systemPossSuperiors"; break;
			case DRSUAPI_ATTID_systemMayContain: val = "DRSUAPI_ATTID_systemMayContain"; break;
			case DRSUAPI_ATTID_systemMustContain: val = "DRSUAPI_ATTID_systemMustContain"; break;
			case DRSUAPI_ATTID_systemAuxiliaryClass: val = "DRSUAPI_ATTID_systemAuxiliaryClass"; break;
			case DRSUAPI_ATTID_sAMAccountName: val = "DRSUAPI_ATTID_sAMAccountName"; break;
			case DRSUAPI_ATTID_sAMAccountType: val = "DRSUAPI_ATTID_sAMAccountType"; break;
			case DRSUAPI_ATTID_options: val = "DRSUAPI_ATTID_options"; break;
			case DRSUAPI_ATTID_fSMORoleOwner: val = "DRSUAPI_ATTID_fSMORoleOwner"; break;
			case DRSUAPI_ATTID_systemFlags: val = "DRSUAPI_ATTID_systemFlags"; break;
			case DRSUAPI_ATTID_trustAttributes: val = "DRSUAPI_ATTID_trustAttributes"; break;
			case DRSUAPI_ATTID_trustParent: val = "DRSUAPI_ATTID_trustParent"; break;
			case DRSUAPI_ATTID_flatName: val = "DRSUAPI_ATTID_flatName"; break;
			case DRSUAPI_ATTID_serverReference: val = "DRSUAPI_ATTID_serverReference"; break;
			case DRSUAPI_ATTID_serverReferenceBL: val = "DRSUAPI_ATTID_serverReferenceBL"; break;
			case DRSUAPI_ATTID_nonSecurityMember: val = "DRSUAPI_ATTID_nonSecurityMember"; break;
			case DRSUAPI_ATTID_initialAuthIncoming: val = "DRSUAPI_ATTID_initialAuthIncoming"; break;
			case DRSUAPI_ATTID_initialAuthOutgoing: val = "DRSUAPI_ATTID_initialAuthOutgoing"; break;
			case DRSUAPI_ATTID_wellKnownObjects: val = "DRSUAPI_ATTID_wellKnownObjects"; break;
			case DRSUAPI_ATTID_dNSHostName: val = "DRSUAPI_ATTID_dNSHostName"; break;
			case DRSUAPI_ATTID_isMemberOfPartialAttributeSet: val = "DRSUAPI_ATTID_isMemberOfPartialAttributeSet"; break;
			case DRSUAPI_ATTID_managedBy: val = "DRSUAPI_ATTID_managedBy"; break;
			case DRSUAPI_ATTID_userPrincipalName: val = "DRSUAPI_ATTID_userPrincipalName"; break;
			case DRSUAPI_ATTID_groupType: val = "DRSUAPI_ATTID_groupType"; break;
			case DRSUAPI_ATTID_servicePrincipalName: val = "DRSUAPI_ATTID_servicePrincipalName"; break;
			case DRSUAPI_ATTID_lastKnownParent: val = "DRSUAPI_ATTID_lastKnownParent"; break;
			case DRSUAPI_ATTID_objectCategory: val = "DRSUAPI_ATTID_objectCategory"; break;
			case DRSUAPI_ATTID_gPLink: val = "DRSUAPI_ATTID_gPLink"; break;
			case DRSUAPI_ATTID_transportAddressAttribute: val = "DRSUAPI_ATTID_transportAddressAttribute"; break;
			case DRSUAPI_ATTID_schemaInfo: val = "DRSUAPI_ATTID_schemaInfo"; break;
			case DRSUAPI_ATTID_msDS_Behavior_Version: val = "DRSUAPI_ATTID_msDS_Behavior_Version"; break;
			case DRSUAPI_ATTID_msDS_TrustForestTrustInfo: val = "DRSUAPI_ATTID_msDS_TrustForestTrustInfo"; break;
			case DRSUAPI_ATTID_msDS_KeyVersionNumber: val = "DRSUAPI_ATTID_msDS_KeyVersionNumber"; break;
			case DRSUAPI_ATTID_msDS_NonMembers: val = "DRSUAPI_ATTID_msDS_NonMembers"; break;
			case DRSUAPI_ATTID_msDS_MembersForAzRole: val = "DRSUAPI_ATTID_msDS_MembersForAzRole"; break;
			case DRSUAPI_ATTID_msDS_HasDomainNCs: val = "DRSUAPI_ATTID_msDS_HasDomainNCs"; break;
			case DRSUAPI_ATTID_msDS_hasMasterNCs: val = "DRSUAPI_ATTID_msDS_hasMasterNCs"; break;
			case DRSUAPI_ATTID_msDS_NeverRevealGroup: val = "DRSUAPI_ATTID_msDS_NeverRevealGroup"; break;
			case DRSUAPI_ATTID_msDS_RevealOnDemandGroup: val = "DRSUAPI_ATTID_msDS_RevealOnDemandGroup"; break;
			case DRSUAPI_ATTID_msDS_SupportedEncryptionTypes: val = "DRSUAPI_ATTID_msDS_SupportedEncryptionTypes"; break;
			case DRSUAPI_ATTID_msDS_HostServiceAccount: val = "DRSUAPI_ATTID_msDS_HostServiceAccount"; break;
			case DRSUAPI_ATTID_isRecycled: val = "DRSUAPI_ATTID_isRecycled"; break;
			case DRSUAPI_ATTID_INVALID: val = "DRSUAPI_ATTID_INVALID"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsPartialAttributeSet(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsPartialAttributeSet *r)
{
	uint32_t cntr_attids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_attids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_attids));
		for (cntr_attids_0 = 0; cntr_attids_0 < (r->num_attids); cntr_attids_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attids[cntr_attids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsPartialAttributeSet(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsPartialAttributeSet *r)
{
	uint32_t size_attids_0 = 0;
	uint32_t cntr_attids_0;
	TALLOC_CTX *_mem_save_attids_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->attids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_attids));
		if (r->num_attids < 1 || r->num_attids > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_attids), (uint32_t)(1), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->attids, &size_attids_0));
		NDR_PULL_ALLOC_N(ndr, r->attids, size_attids_0);
		_mem_save_attids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->attids, 0);
		for (cntr_attids_0 = 0; cntr_attids_0 < (size_attids_0); cntr_attids_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attids[cntr_attids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attids_0, 0);
		if (r->attids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->attids, r->num_attids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsPartialAttributeSet(struct ndr_print *ndr, const char *name, const struct drsuapi_DsPartialAttributeSet *r)
{
	uint32_t cntr_attids_0;
	ndr_print_struct(ndr, name, "drsuapi_DsPartialAttributeSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->version);
	ndr_print_uint32(ndr, "reserved1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved1);
	ndr_print_uint32(ndr, "num_attids", r->num_attids);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "attids", (uint32_t)(r->num_attids));
	ndr->depth++;
	for (cntr_attids_0 = 0; cntr_attids_0 < (r->num_attids); cntr_attids_0++) {
		ndr_print_drsuapi_DsAttributeId(ndr, "attids", r->attids[cntr_attids_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesRequest8(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesRequest8 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_ndr_size));
		NDR_CHECK(ndr_push_drsuapi_DsExtendedOperation(ndr, NDR_SCALARS, r->extended_op));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->fsmo_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->partial_attribute_set));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->partial_attribute_set_ex));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
		}
		if (r->partial_attribute_set) {
			NDR_CHECK(ndr_push_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set));
		}
		if (r->partial_attribute_set_ex) {
			NDR_CHECK(ndr_push_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set_ex));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesRequest8(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesRequest8 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0 = NULL;
	uint32_t _ptr_partial_attribute_set;
	TALLOC_CTX *_mem_save_partial_attribute_set_0 = NULL;
	uint32_t _ptr_partial_attribute_set_ex;
	TALLOC_CTX *_mem_save_partial_attribute_set_ex_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_ndr_size));
		NDR_CHECK(ndr_pull_drsuapi_DsExtendedOperation(ndr, NDR_SCALARS, &r->extended_op));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->fsmo_info));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partial_attribute_set));
		if (_ptr_partial_attribute_set) {
			NDR_PULL_ALLOC(ndr, r->partial_attribute_set);
		} else {
			r->partial_attribute_set = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partial_attribute_set_ex));
		if (_ptr_partial_attribute_set_ex) {
			NDR_PULL_ALLOC(ndr, r->partial_attribute_set_ex);
		} else {
			r->partial_attribute_set_ex = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		if (r->partial_attribute_set) {
			_mem_save_partial_attribute_set_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->partial_attribute_set, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partial_attribute_set_0, 0);
		}
		if (r->partial_attribute_set_ex) {
			_mem_save_partial_attribute_set_ex_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->partial_attribute_set_ex, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set_ex));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partial_attribute_set_ex_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsGetNCChangesRequest8(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsGetNCChangesRequest8 *r)
{
	ndr_print_drsuapi_DsGetNCChangesRequest8(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest8(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesRequest8 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesRequest8");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "destination_dsa_guid", &r->destination_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "highwatermark", &r->highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DrsOptions(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "max_object_count", r->max_object_count);
	ndr_print_uint32(ndr, "max_ndr_size", r->max_ndr_size);
	ndr_print_drsuapi_DsExtendedOperation(ndr, "extended_op", r->extended_op);
	ndr_print_hyper(ndr, "fsmo_info", r->fsmo_info);
	ndr_print_ptr(ndr, "partial_attribute_set", r->partial_attribute_set);
	ndr->depth++;
	if (r->partial_attribute_set) {
		ndr_print_drsuapi_DsPartialAttributeSet(ndr, "partial_attribute_set", r->partial_attribute_set);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "partial_attribute_set_ex", r->partial_attribute_set_ex);
	ndr->depth++;
	if (r->partial_attribute_set_ex) {
		ndr_print_drsuapi_DsPartialAttributeSet(ndr, "partial_attribute_set_ex", r->partial_attribute_set_ex);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesRequest10(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesRequest10 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_ndr_size));
		NDR_CHECK(ndr_push_drsuapi_DsExtendedOperation(ndr, NDR_SCALARS, r->extended_op));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->fsmo_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->partial_attribute_set));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->partial_attribute_set_ex));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_push_drsuapi_DrsMoreOptions(ndr, NDR_SCALARS, r->more_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
		}
		if (r->partial_attribute_set) {
			NDR_CHECK(ndr_push_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set));
		}
		if (r->partial_attribute_set_ex) {
			NDR_CHECK(ndr_push_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set_ex));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesRequest10(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesRequest10 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0 = NULL;
	uint32_t _ptr_partial_attribute_set;
	TALLOC_CTX *_mem_save_partial_attribute_set_0 = NULL;
	uint32_t _ptr_partial_attribute_set_ex;
	TALLOC_CTX *_mem_save_partial_attribute_set_ex_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->destination_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_ndr_size));
		NDR_CHECK(ndr_pull_drsuapi_DsExtendedOperation(ndr, NDR_SCALARS, &r->extended_op));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->fsmo_info));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partial_attribute_set));
		if (_ptr_partial_attribute_set) {
			NDR_PULL_ALLOC(ndr, r->partial_attribute_set);
		} else {
			r->partial_attribute_set = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_partial_attribute_set_ex));
		if (_ptr_partial_attribute_set_ex) {
			NDR_PULL_ALLOC(ndr, r->partial_attribute_set_ex);
		} else {
			r->partial_attribute_set_ex = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_pull_drsuapi_DrsMoreOptions(ndr, NDR_SCALARS, &r->more_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		if (r->partial_attribute_set) {
			_mem_save_partial_attribute_set_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->partial_attribute_set, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partial_attribute_set_0, 0);
		}
		if (r->partial_attribute_set_ex) {
			_mem_save_partial_attribute_set_ex_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->partial_attribute_set_ex, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsPartialAttributeSet(ndr, NDR_SCALARS, r->partial_attribute_set_ex));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_partial_attribute_set_ex_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsGetNCChangesRequest10(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsGetNCChangesRequest10 *r)
{
	ndr_print_drsuapi_DsGetNCChangesRequest10(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest10(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesRequest10 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesRequest10");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "destination_dsa_guid", &r->destination_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "highwatermark", &r->highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DrsOptions(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "max_object_count", r->max_object_count);
	ndr_print_uint32(ndr, "max_ndr_size", r->max_ndr_size);
	ndr_print_drsuapi_DsExtendedOperation(ndr, "extended_op", r->extended_op);
	ndr_print_hyper(ndr, "fsmo_info", r->fsmo_info);
	ndr_print_ptr(ndr, "partial_attribute_set", r->partial_attribute_set);
	ndr->depth++;
	if (r->partial_attribute_set) {
		ndr_print_drsuapi_DsPartialAttributeSet(ndr, "partial_attribute_set", r->partial_attribute_set);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "partial_attribute_set_ex", r->partial_attribute_set_ex);
	ndr->depth++;
	if (r->partial_attribute_set_ex) {
		ndr_print_drsuapi_DsPartialAttributeSet(ndr, "partial_attribute_set_ex", r->partial_attribute_set_ex);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr_print_drsuapi_DrsMoreOptions(ndr, "more_flags", r->more_flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetNCChangesRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case 5: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest5(ndr, NDR_SCALARS, &r->req5));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest8(ndr, NDR_SCALARS, &r->req8));
			break; }

			case 10: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest10(ndr, NDR_SCALARS, &r->req10));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 5:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest5(ndr, NDR_BUFFERS, &r->req5));
			break;

			case 8:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest8(ndr, NDR_BUFFERS, &r->req8));
			break;

			case 10:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest10(ndr, NDR_BUFFERS, &r->req10));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetNCChangesRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case 5: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest5(ndr, NDR_SCALARS, &r->req5));
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest8(ndr, NDR_SCALARS, &r->req8));
			break; }

			case 10: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest10(ndr, NDR_SCALARS, &r->req10));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 5:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest5(ndr, NDR_BUFFERS, &r->req5));
			break;

			case 8:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest8(ndr, NDR_BUFFERS, &r->req8));
			break;

			case 10:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest10(ndr, NDR_BUFFERS, &r->req10));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNCChangesRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNCChangesRequest");
	switch (level) {
		case 5:
			ndr_print_drsuapi_DsGetNCChangesRequest5(ndr, "req5", &r->req5);
		break;

		case 8:
			ndr_print_drsuapi_DsGetNCChangesRequest8(ndr, "req8", &r->req8);
		break;

		case 10:
			ndr_print_drsuapi_DsGetNCChangesRequest10(ndr, "req10", &r->req10);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaCursor2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursor2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_sync_success));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursor2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursor2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_sync_success));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaCursor2(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaCursor2 *r)
{
	ndr_print_drsuapi_DsReplicaCursor2(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr_print_NTTIME(ndr, "last_sync_success", r->last_sync_success);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaCursor2CtrEx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	uint32_t cntr_cursors_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		for (cntr_cursors_0 = 0; cntr_cursors_0 < (r->count); cntr_cursors_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursor2CtrEx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	uint32_t size_cursors_0 = 0;
	uint32_t cntr_cursors_0;
	TALLOC_CTX *_mem_save_cursors_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->cursors));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved2));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->cursors, &size_cursors_0));
		NDR_PULL_ALLOC_N(ndr, r->cursors, size_cursors_0);
		_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
		for (cntr_cursors_0 = 0; cntr_cursors_0 < (size_cursors_0); cntr_cursors_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->cursors[cntr_cursors_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
		if (r->cursors) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->cursors, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor2CtrEx(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor2CtrEx *r)
{
	uint32_t cntr_cursors_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor2CtrEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?2:r->version);
	ndr_print_uint32(ndr, "reserved1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved1);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved2);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "cursors", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_cursors_0 = 0; cntr_cursors_0 < (r->count); cntr_cursors_0++) {
		ndr_print_drsuapi_DsReplicaCursor2(ndr, "cursors", &r->cursors[cntr_cursors_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAttributeValue(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAttributeValue *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_DATA_BLOB(0, r->blob, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->blob));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->blob) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->blob));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAttributeValue(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAttributeValue *r)
{
	uint32_t _ptr_blob;
	TALLOC_CTX *_mem_save_blob_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		if (r->__ndr_size > 26214400) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->__ndr_size), (uint32_t)(0), (uint32_t)(26214400));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_blob));
		if (_ptr_blob) {
			NDR_PULL_ALLOC(ndr, r->blob);
		} else {
			r->blob = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->blob) {
			_mem_save_blob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->blob, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->blob));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_blob_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAttributeValue(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAttributeValue *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAttributeValue");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DATA_BLOB(0, r->blob, 0):r->__ndr_size);
	ndr_print_ptr(ndr, "blob", r->blob);
	ndr->depth++;
	if (r->blob) {
		ndr_print_DATA_BLOB(ndr, "blob", *r->blob);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAttributeValueCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAttributeValueCtr *r)
{
	uint32_t cntr_values_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_values));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->values));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_values));
			for (cntr_values_1 = 0; cntr_values_1 < (r->num_values); cntr_values_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->values[cntr_values_1]));
			}
			for (cntr_values_1 = 0; cntr_values_1 < (r->num_values); cntr_values_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->values[cntr_values_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAttributeValueCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAttributeValueCtr *r)
{
	uint32_t _ptr_values;
	uint32_t size_values_1 = 0;
	uint32_t cntr_values_1;
	TALLOC_CTX *_mem_save_values_0 = NULL;
	TALLOC_CTX *_mem_save_values_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_values));
		if (r->num_values > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_values), (uint32_t)(0), (uint32_t)(10485760));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_values));
		if (_ptr_values) {
			NDR_PULL_ALLOC(ndr, r->values);
		} else {
			r->values = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->values));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->values, &size_values_1));
			NDR_PULL_ALLOC_N(ndr, r->values, size_values_1);
			_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->values[cntr_values_1]));
			}
			for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->values[cntr_values_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, 0);
		}
		if (r->values) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->values, r->num_values));
		}
		for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAttributeValueCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAttributeValueCtr *r)
{
	uint32_t cntr_values_1;
	ndr_print_struct(ndr, name, "drsuapi_DsAttributeValueCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_values", r->num_values);
	ndr_print_ptr(ndr, "values", r->values);
	ndr->depth++;
	if (r->values) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "values", (uint32_t)(r->num_values));
		ndr->depth++;
		for (cntr_values_1 = 0; cntr_values_1 < (r->num_values); cntr_values_1++) {
			ndr_print_drsuapi_DsAttributeValue(ndr, "values", &r->values[cntr_values_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectIdentifier3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsReplicaObjectIdentifier3(r, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid28(&r->sid, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m(r->dn)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dn, strlen_m(r->dn) + 1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectIdentifier3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	uint32_t size_dn_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_sid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_dn));
		size_dn_0 = r->__ndr_size_dn + 1;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dn, size_dn_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaObjectIdentifier3(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	ndr_print_drsuapi_DsReplicaObjectIdentifier3(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier3 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaObjectIdentifier3(r, ndr->flags):r->__ndr_size);
	ndr_print_uint32(ndr, "__ndr_size_sid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid28(&r->sid, ndr->flags):r->__ndr_size_sid);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr_print_uint32(ndr, "__ndr_size_dn", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->dn):r->__ndr_size_dn);
	ndr_print_string(ndr, "dn", r->dn);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsReplicaObjectIdentifier3(const struct drsuapi_DsReplicaObjectIdentifier3 *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsReplicaObjectIdentifier3);
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsReplicaObjectIdentifier3Binary_without_Binary(r, ndr->flags)));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dom_sid28(&r->sid, ndr->flags)));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m(r->dn)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dn, strlen_m(r->dn) + 1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->binary.length + 4));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	uint32_t size_dn_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_sid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_dn));
		size_dn_0 = r->__ndr_size_dn + 1;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dn, size_dn_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_binary));
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->binary));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	ndr_print_drsuapi_DsReplicaObjectIdentifier3Binary(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier3Binary(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier3Binary *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier3Binary");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsReplicaObjectIdentifier3Binary_without_Binary(r, ndr->flags):r->__ndr_size);
	ndr_print_uint32(ndr, "__ndr_size_sid", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dom_sid28(&r->sid, ndr->flags):r->__ndr_size_sid);
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr_print_uint32(ndr, "__ndr_size_dn", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->dn):r->__ndr_size_dn);
	ndr_print_string(ndr, "dn", r->dn);
	ndr_print_uint32(ndr, "__ndr_size_binary", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->binary.length + 4:r->__ndr_size_binary);
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "binary", r->binary);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaAttribute(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAttribute *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attid));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValueCtr(ndr, NDR_SCALARS, &r->value_ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValueCtr(ndr, NDR_BUFFERS, &r->value_ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaAttribute(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAttribute *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attid));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValueCtr(ndr, NDR_SCALARS, &r->value_ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValueCtr(ndr, NDR_BUFFERS, &r->value_ctr));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaAttribute(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaAttribute *r)
{
	ndr_print_drsuapi_DsReplicaAttribute(ndr, name, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAttributeCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAttributeCtr *r)
{
	uint32_t cntr_attributes_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_attributes));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attributes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_attributes));
			for (cntr_attributes_1 = 0; cntr_attributes_1 < (r->num_attributes); cntr_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAttribute(ndr, NDR_SCALARS, &r->attributes[cntr_attributes_1]));
			}
			for (cntr_attributes_1 = 0; cntr_attributes_1 < (r->num_attributes); cntr_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAttribute(ndr, NDR_BUFFERS, &r->attributes[cntr_attributes_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAttributeCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAttributeCtr *r)
{
	uint32_t _ptr_attributes;
	uint32_t size_attributes_1 = 0;
	uint32_t cntr_attributes_1;
	TALLOC_CTX *_mem_save_attributes_0 = NULL;
	TALLOC_CTX *_mem_save_attributes_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_attributes));
		if (r->num_attributes > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_attributes), (uint32_t)(0), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attributes));
		if (_ptr_attributes) {
			NDR_PULL_ALLOC(ndr, r->attributes);
		} else {
			r->attributes = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attributes) {
			_mem_save_attributes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attributes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attributes));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->attributes, &size_attributes_1));
			NDR_PULL_ALLOC_N(ndr, r->attributes, size_attributes_1);
			_mem_save_attributes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attributes, 0);
			for (cntr_attributes_1 = 0; cntr_attributes_1 < (size_attributes_1); cntr_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttribute(ndr, NDR_SCALARS, &r->attributes[cntr_attributes_1]));
			}
			for (cntr_attributes_1 = 0; cntr_attributes_1 < (size_attributes_1); cntr_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttribute(ndr, NDR_BUFFERS, &r->attributes[cntr_attributes_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attributes_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attributes_0, 0);
		}
		if (r->attributes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->attributes, r->num_attributes));
		}
		for (cntr_attributes_1 = 0; cntr_attributes_1 < (size_attributes_1); cntr_attributes_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttributeCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttributeCtr *r)
{
	uint32_t cntr_attributes_1;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttributeCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_attributes", r->num_attributes);
	ndr_print_ptr(ndr, "attributes", r->attributes);
	ndr->depth++;
	if (r->attributes) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "attributes", (uint32_t)(r->num_attributes));
		ndr->depth++;
		for (cntr_attributes_1 = 0; cntr_attributes_1 < (r->num_attributes); cntr_attributes_1++) {
			ndr_print_drsuapi_DsReplicaAttribute(ndr, "attributes", &r->attributes[cntr_attributes_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_OBJECT_FROM_MASTER", DRSUAPI_DS_REPLICA_OBJECT_FROM_MASTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_OBJECT_DYNAMIC", DRSUAPI_DS_REPLICA_OBJECT_DYNAMIC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_REPLICA_OBJECT_REMOTE_MODIFY", DRSUAPI_DS_REPLICA_OBJECT_REMOTE_MODIFY, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObject(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObject *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->identifier));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaAttributeCtr(ndr, NDR_SCALARS, &r->attribute_ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaAttributeCtr(ndr, NDR_BUFFERS, &r->attribute_ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObject(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObject *r)
{
	uint32_t _ptr_identifier;
	TALLOC_CTX *_mem_save_identifier_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_identifier));
		if (_ptr_identifier) {
			NDR_PULL_ALLOC(ndr, r->identifier);
		} else {
			r->identifier = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttributeCtr(ndr, NDR_SCALARS, &r->attribute_ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			_mem_save_identifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->identifier, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_identifier_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttributeCtr(ndr, NDR_BUFFERS, &r->attribute_ctr));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaObject(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaObject *r)
{
	ndr_print_drsuapi_DsReplicaObject(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObject(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObject *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObject");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "identifier", r->identifier);
	ndr->depth++;
	if (r->identifier) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "identifier", r->identifier);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaObjectFlags(ndr, "flags", r->flags);
	ndr_print_drsuapi_DsReplicaAttributeCtr(ndr, "attribute_ctr", &r->attribute_ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaMetaData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaMetaData *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME_1sec(ndr, NDR_SCALARS, r->originating_change_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaMetaData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaMetaData *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME_1sec(ndr, NDR_SCALARS, &r->originating_change_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaMetaData(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaMetaData *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaMetaData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME_1sec(ndr, "originating_change_time", r->originating_change_time);
	ndr_print_GUID(ndr, "originating_invocation_id", &r->originating_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaMetaDataCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaMetaDataCtr *r)
{
	uint32_t cntr_meta_data_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_meta_data_0 = 0; cntr_meta_data_0 < (r->count); cntr_meta_data_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data[cntr_meta_data_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaMetaDataCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaMetaDataCtr *r)
{
	uint32_t size_meta_data_0 = 0;
	uint32_t cntr_meta_data_0;
	TALLOC_CTX *_mem_save_meta_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->meta_data));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->meta_data, &size_meta_data_0));
		NDR_PULL_ALLOC_N(ndr, r->meta_data, size_meta_data_0);
		_mem_save_meta_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->meta_data, 0);
		for (cntr_meta_data_0 = 0; cntr_meta_data_0 < (size_meta_data_0); cntr_meta_data_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data[cntr_meta_data_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_meta_data_0, 0);
		if (r->meta_data) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->meta_data, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaMetaDataCtr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaMetaDataCtr *r)
{
	ndr_print_drsuapi_DsReplicaMetaDataCtr(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaMetaDataCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaMetaDataCtr *r)
{
	uint32_t cntr_meta_data_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaMetaDataCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "meta_data", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_meta_data_0 = 0; cntr_meta_data_0 < (r->count); cntr_meta_data_0++) {
		ndr_print_drsuapi_DsReplicaMetaData(ndr, "meta_data", &r->meta_data[cntr_meta_data_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectListItemEx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjectListItemEx *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next_object));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_nc_prefix));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->parent_object_guid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->meta_data_ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
		if (r->parent_object_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->parent_object_guid));
		}
		if (r->meta_data_ctr) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaDataCtr(ndr, NDR_SCALARS, r->meta_data_ctr));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectListItemEx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjectListItemEx *r)
{
	uint32_t _ptr_next_object;
	TALLOC_CTX *_mem_save_next_object_0 = NULL;
	uint32_t _ptr_parent_object_guid;
	TALLOC_CTX *_mem_save_parent_object_guid_0 = NULL;
	uint32_t _ptr_meta_data_ctr;
	TALLOC_CTX *_mem_save_meta_data_ctr_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next_object));
		if (_ptr_next_object) {
			NDR_PULL_ALLOC(ndr, r->next_object);
		} else {
			r->next_object = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_nc_prefix));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_parent_object_guid));
		if (_ptr_parent_object_guid) {
			NDR_PULL_ALLOC(ndr, r->parent_object_guid);
		} else {
			r->parent_object_guid = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_meta_data_ctr));
		if (_ptr_meta_data_ctr) {
			NDR_PULL_ALLOC(ndr, r->meta_data_ctr);
		} else {
			r->meta_data_ctr = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			_mem_save_next_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next_object, 0);
			NDR_RECURSION_CHECK(ndr, 20000);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_object_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
		if (r->parent_object_guid) {
			_mem_save_parent_object_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->parent_object_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->parent_object_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_parent_object_guid_0, 0);
		}
		if (r->meta_data_ctr) {
			_mem_save_meta_data_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->meta_data_ctr, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaDataCtr(ndr, NDR_SCALARS, r->meta_data_ctr));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_meta_data_ctr_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaObjectListItemEx(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaObjectListItemEx *r)
{
	ndr_print_drsuapi_DsReplicaObjectListItemEx(ndr, name, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesCtr1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_push_drsuapi_DsExtendedError(ndr, NDR_SCALARS, r->extended_ret));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsGetNCChangesCtr1(r, ndr->flags) + 55));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->first_object));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->more_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		}
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesCtr1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0 = NULL;
	uint32_t _ptr_first_object;
	TALLOC_CTX *_mem_save_first_object_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_pull_drsuapi_DsExtendedError(ndr, NDR_SCALARS, &r->extended_ret));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_first_object));
		if (_ptr_first_object) {
			NDR_PULL_ALLOC(ndr, r->first_object);
		} else {
			r->first_object = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->more_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context) {
			_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		}
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			_mem_save_first_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->first_object, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_first_object_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsGetNCChangesCtr1(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsGetNCChangesCtr1 *r)
{
	ndr_print_drsuapi_DsGetNCChangesCtr1(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	if (r->naming_context) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "old_highwatermark", &r->old_highwatermark);
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "new_highwatermark", &r->new_highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr_print_drsuapi_DsExtendedError(ndr, "extended_ret", r->extended_ret);
	ndr_print_uint32(ndr, "object_count", r->object_count);
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsGetNCChangesCtr1(r, ndr->flags) + 55:r->__ndr_size);
	ndr_print_ptr(ndr, "first_object", r->first_object);
	ndr->depth++;
	if (r->first_object) {
		ndr_print_drsuapi_DsReplicaObjectListItemEx(ndr, "first_object", r->first_object);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "more_data", r->more_data);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsGetNCChangesCtr1(const struct drsuapi_DsGetNCChangesCtr1 *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr1);
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsLinkedAttributeFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsLinkedAttributeFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsLinkedAttributeFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_LINKED_ATTRIBUTE_FLAG_ACTIVE", DRSUAPI_DS_LINKED_ATTRIBUTE_FLAG_ACTIVE, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaLinkedAttribute(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaLinkedAttribute *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->identifier));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attid));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_push_drsuapi_DsLinkedAttributeFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_NTTIME_1sec(ndr, NDR_SCALARS, r->originating_add_time));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
		}
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaLinkedAttribute(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaLinkedAttribute *r)
{
	uint32_t _ptr_identifier;
	TALLOC_CTX *_mem_save_identifier_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_identifier));
		if (_ptr_identifier) {
			NDR_PULL_ALLOC(ndr, r->identifier);
		} else {
			r->identifier = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attid));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_drsuapi_DsLinkedAttributeFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_NTTIME_1sec(ndr, NDR_SCALARS, &r->originating_add_time));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaMetaData(ndr, NDR_SCALARS, &r->meta_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->identifier) {
			_mem_save_identifier_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->identifier, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->identifier));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_identifier_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->value));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaLinkedAttribute(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaLinkedAttribute *r)
{
	ndr_print_drsuapi_DsReplicaLinkedAttribute(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaLinkedAttribute(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaLinkedAttribute *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaLinkedAttribute");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "identifier", r->identifier);
	ndr->depth++;
	if (r->identifier) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "identifier", r->identifier);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsAttributeId(ndr, "attid", r->attid);
	ndr_print_drsuapi_DsAttributeValue(ndr, "value", &r->value);
	ndr_print_drsuapi_DsLinkedAttributeFlags(ndr, "flags", r->flags);
	ndr_print_NTTIME_1sec(ndr, "originating_add_time", r->originating_add_time);
	ndr_print_drsuapi_DsReplicaMetaData(ndr, "meta_data", &r->meta_data);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr6(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesCtr6 *r)
{
	uint32_t cntr_linked_attributes_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->uptodateness_vector));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_push_drsuapi_DsExtendedError(ndr, NDR_SCALARS, r->extended_ret));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_drsuapi_DsGetNCChangesCtr6(r, ndr->flags) + 55));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->first_object));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->more_data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nc_object_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->nc_linked_attributes_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->linked_attributes_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->linked_attributes));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->drs_error));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		}
		if (r->uptodateness_vector) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2CtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
		}
		if (r->linked_attributes) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->linked_attributes_count));
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < (r->linked_attributes_count); cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_SCALARS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < (r->linked_attributes_count); cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_BUFFERS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr6(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesCtr6 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_uptodateness_vector;
	TALLOC_CTX *_mem_save_uptodateness_vector_0 = NULL;
	uint32_t _ptr_first_object;
	TALLOC_CTX *_mem_save_first_object_0 = NULL;
	uint32_t _ptr_linked_attributes;
	uint32_t size_linked_attributes_1 = 0;
	uint32_t cntr_linked_attributes_1;
	TALLOC_CTX *_mem_save_linked_attributes_0 = NULL;
	TALLOC_CTX *_mem_save_linked_attributes_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->old_highwatermark));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaHighWaterMark(ndr, NDR_SCALARS, &r->new_highwatermark));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_uptodateness_vector));
		if (_ptr_uptodateness_vector) {
			NDR_PULL_ALLOC(ndr, r->uptodateness_vector);
		} else {
			r->uptodateness_vector = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_SCALARS, &r->mapping_ctr));
		NDR_CHECK(ndr_pull_drsuapi_DsExtendedError(ndr, NDR_SCALARS, &r->extended_ret));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_first_object));
		if (_ptr_first_object) {
			NDR_PULL_ALLOC(ndr, r->first_object);
		} else {
			r->first_object = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->more_data));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->nc_object_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->nc_linked_attributes_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->linked_attributes_count));
		if (r->linked_attributes_count > 1048576) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->linked_attributes_count), (uint32_t)(0), (uint32_t)(1048576));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_linked_attributes));
		if (_ptr_linked_attributes) {
			NDR_PULL_ALLOC(ndr, r->linked_attributes);
		} else {
			r->linked_attributes = NULL;
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->drs_error));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context) {
			_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		}
		if (r->uptodateness_vector) {
			_mem_save_uptodateness_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->uptodateness_vector, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2CtrEx(ndr, NDR_SCALARS, r->uptodateness_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_uptodateness_vector_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr(ndr, NDR_BUFFERS, &r->mapping_ctr));
		if (r->first_object) {
			_mem_save_first_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->first_object, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItemEx(ndr, NDR_SCALARS|NDR_BUFFERS, r->first_object));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_first_object_0, 0);
		}
		if (r->linked_attributes) {
			_mem_save_linked_attributes_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->linked_attributes, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->linked_attributes));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->linked_attributes, &size_linked_attributes_1));
			NDR_PULL_ALLOC_N(ndr, r->linked_attributes, size_linked_attributes_1);
			_mem_save_linked_attributes_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->linked_attributes, 0);
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < (size_linked_attributes_1); cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_SCALARS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
			for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < (size_linked_attributes_1); cntr_linked_attributes_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaLinkedAttribute(ndr, NDR_BUFFERS, &r->linked_attributes[cntr_linked_attributes_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_linked_attributes_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_linked_attributes_0, 0);
		}
		if (r->linked_attributes) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->linked_attributes, r->linked_attributes_count));
		}
		for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < (size_linked_attributes_1); cntr_linked_attributes_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsGetNCChangesCtr6(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsGetNCChangesCtr6 *r)
{
	ndr_print_drsuapi_DsGetNCChangesCtr6(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr6(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr6 *r)
{
	uint32_t cntr_linked_attributes_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	if (r->naming_context) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "old_highwatermark", &r->old_highwatermark);
	ndr_print_drsuapi_DsReplicaHighWaterMark(ndr, "new_highwatermark", &r->new_highwatermark);
	ndr_print_ptr(ndr, "uptodateness_vector", r->uptodateness_vector);
	ndr->depth++;
	if (r->uptodateness_vector) {
		ndr_print_drsuapi_DsReplicaCursor2CtrEx(ndr, "uptodateness_vector", r->uptodateness_vector);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsReplicaOIDMapping_Ctr(ndr, "mapping_ctr", &r->mapping_ctr);
	ndr_print_drsuapi_DsExtendedError(ndr, "extended_ret", r->extended_ret);
	ndr_print_uint32(ndr, "object_count", r->object_count);
	ndr_print_uint32(ndr, "__ndr_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_drsuapi_DsGetNCChangesCtr6(r, ndr->flags) + 55:r->__ndr_size);
	ndr_print_ptr(ndr, "first_object", r->first_object);
	ndr->depth++;
	if (r->first_object) {
		ndr_print_drsuapi_DsReplicaObjectListItemEx(ndr, "first_object", r->first_object);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "more_data", r->more_data);
	ndr_print_uint32(ndr, "nc_object_count", r->nc_object_count);
	ndr_print_uint32(ndr, "nc_linked_attributes_count", r->nc_linked_attributes_count);
	ndr_print_uint32(ndr, "linked_attributes_count", r->linked_attributes_count);
	ndr_print_ptr(ndr, "linked_attributes", r->linked_attributes);
	ndr->depth++;
	if (r->linked_attributes) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "linked_attributes", (uint32_t)(r->linked_attributes_count));
		ndr->depth++;
		for (cntr_linked_attributes_1 = 0; cntr_linked_attributes_1 < (r->linked_attributes_count); cntr_linked_attributes_1++) {
			ndr_print_drsuapi_DsReplicaLinkedAttribute(ndr, "linked_attributes", &r->linked_attributes[cntr_linked_attributes_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_WERROR(ndr, "drs_error", r->drs_error);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_drsuapi_DsGetNCChangesCtr6(const struct drsuapi_DsGetNCChangesCtr6 *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_drsuapi_DsGetNCChangesCtr6);
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr1TS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesCtr1TS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_ctr1;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_ctr1, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr1(_ndr_ctr1, NDR_SCALARS|NDR_BUFFERS, &r->ctr1));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_ctr1, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr1TS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesCtr1TS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_ctr1;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ctr1, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1(_ndr_ctr1, NDR_SCALARS|NDR_BUFFERS, &r->ctr1));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ctr1, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsGetNCChangesCtr1TS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsGetNCChangesCtr1TS *r)
{
	ndr_print_drsuapi_DsGetNCChangesCtr1TS(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr1TS(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr1TS *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr1TS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsGetNCChangesCtr1(ndr, "ctr1", &r->ctr1);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr6TS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesCtr6TS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_ctr6;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_ctr6, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr6(_ndr_ctr6, NDR_SCALARS|NDR_BUFFERS, &r->ctr6));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_ctr6, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr6TS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesCtr6TS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_ctr6;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ctr6, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6(_ndr_ctr6, NDR_SCALARS|NDR_BUFFERS, &r->ctr6));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ctr6, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsGetNCChangesCtr6TS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsGetNCChangesCtr6TS *r)
{
	ndr_print_drsuapi_DsGetNCChangesCtr6TS(ndr, name, r);
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr6TS(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr6TS *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr6TS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsGetNCChangesCtr6(ndr, "ctr6", &r->ctr6);
	ndr->depth--;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesMSZIPCtr1 *r)
{
	uint32_t _ptr_ts;
	TALLOC_CTX *_mem_save_ts_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ts));
		if (_ptr_ts) {
			NDR_PULL_ALLOC(ndr, r->ts);
		} else {
			r->ts = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ts) {
			_mem_save_ts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ts, 0);
			{
				struct ndr_pull *_ndr_ts;
				ssize_t sub_size = r->compressed_length;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ts, 4, sub_size));
				{
					struct ndr_pull *_ndr_ts_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_ts, &_ndr_ts_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length, r->compressed_length));
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1TS(_ndr_ts_compressed, NDR_SCALARS|NDR_BUFFERS, r->ts));
					NDR_CHECK(ndr_pull_compression_end(_ndr_ts, _ndr_ts_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ts, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ts_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesMSZIPCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesMSZIPCtr1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesMSZIPCtr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "ts", r->ts);
	ndr->depth++;
	if (r->ts) {
		ndr_print_drsuapi_DsGetNCChangesCtr1TS(ndr, "ts", r->ts);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr6(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesMSZIPCtr6 *r)
{
	uint32_t _ptr_ts;
	TALLOC_CTX *_mem_save_ts_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ts));
		if (_ptr_ts) {
			NDR_PULL_ALLOC(ndr, r->ts);
		} else {
			r->ts = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ts) {
			_mem_save_ts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ts, 0);
			{
				struct ndr_pull *_ndr_ts;
				ssize_t sub_size = r->compressed_length;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ts, 4, sub_size));
				{
					struct ndr_pull *_ndr_ts_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_ts, &_ndr_ts_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length, r->compressed_length));
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6TS(_ndr_ts_compressed, NDR_SCALARS|NDR_BUFFERS, r->ts));
					NDR_CHECK(ndr_pull_compression_end(_ndr_ts, _ndr_ts_compressed, NDR_COMPRESSION_MSZIP, r->decompressed_length));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ts, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ts_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesMSZIPCtr6(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesMSZIPCtr6 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesMSZIPCtr6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "ts", r->ts);
	ndr->depth++;
	if (r->ts) {
		ndr_print_drsuapi_DsGetNCChangesCtr6TS(ndr, "ts", r->ts);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *r)
{
	uint32_t _ptr_ts;
	TALLOC_CTX *_mem_save_ts_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ts));
		if (_ptr_ts) {
			NDR_PULL_ALLOC(ndr, r->ts);
		} else {
			r->ts = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ts) {
			_mem_save_ts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ts, 0);
			{
				struct ndr_pull *_ndr_ts;
				ssize_t sub_size = r->compressed_length;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ts, 4, sub_size));
				{
					struct ndr_pull *_ndr_ts_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_ts, &_ndr_ts_compressed, NDR_COMPRESSION_WIN2K3_LZ77_DIRECT2, r->decompressed_length, r->compressed_length));
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1TS(_ndr_ts_compressed, NDR_SCALARS|NDR_BUFFERS, r->ts));
					NDR_CHECK(ndr_pull_compression_end(_ndr_ts, _ndr_ts_compressed, NDR_COMPRESSION_WIN2K3_LZ77_DIRECT2, r->decompressed_length));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ts, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ts_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "ts", r->ts);
	ndr->depth++;
	if (r->ts) {
		ndr_print_drsuapi_DsGetNCChangesCtr1TS(ndr, "ts", r->ts);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *r)
{
	uint32_t _ptr_ts;
	TALLOC_CTX *_mem_save_ts_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->decompressed_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->compressed_length));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ts));
		if (_ptr_ts) {
			NDR_PULL_ALLOC(ndr, r->ts);
		} else {
			r->ts = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->ts) {
			_mem_save_ts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ts, 0);
			{
				struct ndr_pull *_ndr_ts;
				ssize_t sub_size = r->compressed_length;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_ts, 4, sub_size));
				{
					struct ndr_pull *_ndr_ts_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_ts, &_ndr_ts_compressed, NDR_COMPRESSION_WIN2K3_LZ77_DIRECT2, r->decompressed_length, r->compressed_length));
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6TS(_ndr_ts_compressed, NDR_SCALARS|NDR_BUFFERS, r->ts));
					NDR_CHECK(ndr_pull_compression_end(_ndr_ts, _ndr_ts_compressed, NDR_COMPRESSION_WIN2K3_LZ77_DIRECT2, r->decompressed_length));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_ts, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ts_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "decompressed_length", r->decompressed_length);
	ndr_print_uint32(ndr, "compressed_length", r->compressed_length);
	ndr_print_ptr(ndr, "ts", r->ts);
	ndr->depth++;
	if (r->ts) {
		ndr_print_drsuapi_DsGetNCChangesCtr6TS(ndr, "ts", r->ts);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCompressionType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsGetNCChangesCompressionType r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCompressionType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsGetNCChangesCompressionType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCompressionType(struct ndr_print *ndr, const char *name, enum drsuapi_DsGetNCChangesCompressionType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_COMPRESSION_TYPE_MSZIP: val = "DRSUAPI_COMPRESSION_TYPE_MSZIP"; break;
		case DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2: val = "DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCompressedCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 5));
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16): {
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_SCALARS, &r->mszip1));
				break; }

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16): {
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_SCALARS, &r->mszip6));
				break; }

				case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16): {
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(ndr, NDR_SCALARS, &r->xpress1));
				break; }

				case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16): {
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(ndr, NDR_SCALARS, &r->xpress6));
				break; }

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_BUFFERS, &r->mszip1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_BUFFERS, &r->mszip6));
				break;

				case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(ndr, NDR_BUFFERS, &r->xpress1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
					NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(ndr, NDR_BUFFERS, &r->xpress6));
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 5));
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_SCALARS, &r->mszip1));
				break; }

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_SCALARS, &r->mszip6));
				break; }

				case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(ndr, NDR_SCALARS, &r->xpress1));
				break; }

				case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16): {
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(ndr, NDR_SCALARS, &r->xpress6));
				break; }

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_BUFFERS, &r->mszip1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, NDR_BUFFERS, &r->mszip6));
				break;

				case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(ndr, NDR_BUFFERS, &r->xpress1));
				break;

				case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
					NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(ndr, NDR_BUFFERS, &r->xpress6));
				break;

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCompressedCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNCChangesCompressedCtr *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "drsuapi_DsGetNCChangesCompressedCtr");
		switch (level) {
			case 1|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
				ndr_print_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, "mszip1", &r->mszip1);
			break;

			case 6|(DRSUAPI_COMPRESSION_TYPE_MSZIP<<16):
				ndr_print_drsuapi_DsGetNCChangesMSZIPCtr6(ndr, "mszip6", &r->mszip6);
			break;

			case 1|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
				ndr_print_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr1(ndr, "xpress1", &r->xpress1);
			break;

			case 6|(DRSUAPI_COMPRESSION_TYPE_WIN2K3_LZ77_DIRECT2<<16):
				ndr_print_drsuapi_DsGetNCChangesWIN2K3_LZ77_DIRECT2Ctr6(ndr, "xpress6", &r->xpress6);
			break;

			default:
				ndr_print_bad_level(ndr, name, level);
		}
		ndr->flags = _flags_save_UNION;
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesCtr2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_SCALARS, &r->mszip1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_BUFFERS, &r->mszip1));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesCtr2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_SCALARS, &r->mszip1));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, NDR_BUFFERS, &r->mszip1));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsGetNCChangesMSZIPCtr1(ndr, "mszip1", &r->mszip1);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr7(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNCChangesCtr7 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressionType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16)));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16)));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr7(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNCChangesCtr7 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->level));
		if (r->level > 6) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->level), (uint32_t)(0), (uint32_t)(6));
		}
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressionType(ndr, NDR_SCALARS, &r->type));
		if (r->type < 2 || r->type > 3) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%d) out of range (%d - %d)", (int)(r->type), (int)(2), (int)(3));
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16)));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_SCALARS, &r->ctr));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16)));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCompressedCtr(ndr, NDR_BUFFERS, &r->ctr));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr7(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNCChangesCtr7 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChangesCtr7");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "level", r->level);
	ndr_print_drsuapi_DsGetNCChangesCompressionType(ndr, "type", r->type);
	ndr_print_set_switch_value(ndr, &r->ctr, r->level | (r->type << 16));
	ndr_print_drsuapi_DsGetNCChangesCompressedCtr(ndr, "ctr", &r->ctr);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChangesCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetNCChangesCtr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr6(ndr, NDR_SCALARS, &r->ctr6));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr7(ndr, NDR_SCALARS, &r->ctr7));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 6:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr6(ndr, NDR_BUFFERS, &r->ctr6));
			break;

			case 7:
				NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr7(ndr, NDR_BUFFERS, &r->ctr7));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChangesCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetNCChangesCtr *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6(ndr, NDR_SCALARS, &r->ctr6));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr7(ndr, NDR_SCALARS, &r->ctr7));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 6:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr6(ndr, NDR_BUFFERS, &r->ctr6));
			break;

			case 7:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr7(ndr, NDR_BUFFERS, &r->ctr7));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChangesCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNCChangesCtr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNCChangesCtr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetNCChangesCtr1(ndr, "ctr1", &r->ctr1);
		break;

		case 2:
			ndr_print_drsuapi_DsGetNCChangesCtr2(ndr, "ctr2", &r->ctr2);
		break;

		case 6:
			ndr_print_drsuapi_DsGetNCChangesCtr6(ndr, "ctr6", &r->ctr6);
		break;

		case 7:
			ndr_print_drsuapi_DsGetNCChangesCtr7(ndr, "ctr7", &r->ctr7);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaUpdateRefsRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->dest_dsa_dns_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->dest_dsa_dns_name */
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->dest_dsa_guid));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dest_dsa_dns_name, CH_DOS)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dest_dsa_dns_name, CH_DOS)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dest_dsa_dns_name, ndr_charset_length(r->dest_dsa_dns_name, CH_DOS), sizeof(uint8_t), CH_DOS));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaUpdateRefsRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_dest_dsa_dns_name;
	uint32_t size_dest_dsa_dns_name_1 = 0;
	uint32_t length_dest_dsa_dns_name_1 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_dest_dsa_dns_name));
		if (_ptr_dest_dsa_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dest_dsa_dns_name);
		} else {
			r->dest_dsa_dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->dest_dsa_guid));
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->dest_dsa_dns_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->dest_dsa_dns_name));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dest_dsa_dns_name, &size_dest_dsa_dns_name_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dest_dsa_dns_name, &length_dest_dsa_dns_name_1));
		if (length_dest_dsa_dns_name_1 > size_dest_dsa_dns_name_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dest_dsa_dns_name_1, length_dest_dsa_dns_name_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_dest_dsa_dns_name_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dest_dsa_dns_name, length_dest_dsa_dns_name_1, sizeof(uint8_t), CH_DOS));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefsRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaUpdateRefsRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaUpdateRefsRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_ptr(ndr, "dest_dsa_dns_name", r->dest_dsa_dns_name);
	ndr->depth++;
	ndr_print_string(ndr, "dest_dsa_dns_name", r->dest_dsa_dns_name);
	ndr->depth--;
	ndr_print_GUID(ndr, "dest_dsa_guid", &r->dest_dsa_guid);
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaUpdateRefsRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaUpdateRefsRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefsRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaUpdateRefsRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaUpdateRefsRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaUpdateRefsRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAddRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAddRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_address));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->schedule, 84));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->source_dsa_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_address, ndr_charset_length(r->source_dsa_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAddRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAddRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_source_dsa_address;
	uint32_t size_source_dsa_address_1 = 0;
	uint32_t length_source_dsa_address_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_address_0 = NULL;
	uint32_t size_schedule_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_address));
		if (_ptr_source_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_address);
		} else {
			r->source_dsa_address = NULL;
		}
		size_schedule_0 = 84;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->schedule, size_schedule_0));
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->source_dsa_address) {
			_mem_save_source_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_address, &size_source_dsa_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_address, &length_source_dsa_address_1));
			if (length_source_dsa_address_1 > size_source_dsa_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_address_1, length_source_dsa_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_address, length_source_dsa_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_address_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAddRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAddRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAddRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_address", r->source_dsa_address);
	ndr->depth++;
	if (r->source_dsa_address) {
		ndr_print_string(ndr, "source_dsa_address", r->source_dsa_address);
	}
	ndr->depth--;
	ndr_print_array_uint8(ndr, "schedule", r->schedule, 84);
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAddRequest2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAddRequest2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->transport_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_address));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->schedule, 84));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->source_dsa_dn) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->source_dsa_dn));
		}
		if (r->transport_dn) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->transport_dn));
		}
		if (r->source_dsa_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_address, ndr_charset_length(r->source_dsa_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAddRequest2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAddRequest2 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_source_dsa_dn;
	TALLOC_CTX *_mem_save_source_dsa_dn_0 = NULL;
	uint32_t _ptr_transport_dn;
	TALLOC_CTX *_mem_save_transport_dn_0 = NULL;
	uint32_t _ptr_source_dsa_address;
	uint32_t size_source_dsa_address_1 = 0;
	uint32_t length_source_dsa_address_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_address_0 = NULL;
	uint32_t size_schedule_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_dn));
		if (_ptr_source_dsa_dn) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_dn);
		} else {
			r->source_dsa_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transport_dn));
		if (_ptr_transport_dn) {
			NDR_PULL_ALLOC(ndr, r->transport_dn);
		} else {
			r->transport_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_address));
		if (_ptr_source_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_address);
		} else {
			r->source_dsa_address = NULL;
		}
		size_schedule_0 = 84;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->schedule, size_schedule_0));
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->source_dsa_dn) {
			_mem_save_source_dsa_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_dn, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->source_dsa_dn));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_dn_0, 0);
		}
		if (r->transport_dn) {
			_mem_save_transport_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->transport_dn, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->transport_dn));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transport_dn_0, 0);
		}
		if (r->source_dsa_address) {
			_mem_save_source_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_address, &size_source_dsa_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_address, &length_source_dsa_address_1));
			if (length_source_dsa_address_1 > size_source_dsa_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_address_1, length_source_dsa_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_address, length_source_dsa_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_address_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAddRequest2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAddRequest2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAddRequest2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_dn", r->source_dsa_dn);
	ndr->depth++;
	if (r->source_dsa_dn) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "source_dsa_dn", r->source_dsa_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "transport_dn", r->transport_dn);
	ndr->depth++;
	if (r->transport_dn) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "transport_dn", r->transport_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_address", r->source_dsa_address);
	ndr->depth++;
	if (r->source_dsa_address) {
		ndr_print_string(ndr, "source_dsa_address", r->source_dsa_address);
	}
	ndr->depth--;
	ndr_print_array_uint8(ndr, "schedule", r->schedule, 84);
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAddRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaAddRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAddRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAddRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAddRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaAddRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAddRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaAddRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAddRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAddRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAddRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaAddRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAddRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaAddRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaAddRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaAddRequest1(ndr, "req1", &r->req1);
		break;

		case 2:
			ndr_print_drsuapi_DsReplicaAddRequest2(ndr, "req2", &r->req2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaDelRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaDelRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_address));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->source_dsa_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_address, ndr_charset_length(r->source_dsa_address, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaDelRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaDelRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_source_dsa_address;
	uint32_t size_source_dsa_address_1 = 0;
	uint32_t length_source_dsa_address_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_address_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_address));
		if (_ptr_source_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_address);
		} else {
			r->source_dsa_address = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->source_dsa_address) {
			_mem_save_source_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_address, &size_source_dsa_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_address, &length_source_dsa_address_1));
			if (length_source_dsa_address_1 > size_source_dsa_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_address_1, length_source_dsa_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_address_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_address, length_source_dsa_address_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_address_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaDelRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaDelRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaDelRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_address", r->source_dsa_address);
	ndr->depth++;
	if (r->source_dsa_address) {
		ndr_print_string(ndr, "source_dsa_address", r->source_dsa_address);
	}
	ndr->depth--;
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaDelRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaDelRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaDelRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaDelRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaDelRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaDelRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaDelRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaDelRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaDelRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaDelRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaDelRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaDelRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaModRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaModRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		if (r->naming_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ref_ptr(ndr)); /* r->naming_context */
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dra));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dra_address));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->schedule, 84));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->modify_fields));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		if (r->source_dra_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dra_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dra_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dra_address, ndr_charset_length(r->source_dra_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaModRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaModRequest1 *r)
{
	uint32_t _ptr_naming_context;
	TALLOC_CTX *_mem_save_naming_context_0 = NULL;
	uint32_t _ptr_source_dra_address;
	uint32_t size_source_dra_address_1 = 0;
	uint32_t length_source_dra_address_1 = 0;
	TALLOC_CTX *_mem_save_source_dra_address_0 = NULL;
	uint32_t size_schedule_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ref_ptr(ndr, &_ptr_naming_context));
		if (_ptr_naming_context) {
			NDR_PULL_ALLOC(ndr, r->naming_context);
		} else {
			r->naming_context = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dra));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dra_address));
		if (_ptr_source_dra_address) {
			NDR_PULL_ALLOC(ndr, r->source_dra_address);
		} else {
			r->source_dra_address = NULL;
		}
		size_schedule_0 = 84;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->schedule, size_schedule_0));
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->modify_fields));
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_naming_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->naming_context, 0);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->naming_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_0, 0);
		if (r->source_dra_address) {
			_mem_save_source_dra_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dra_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dra_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dra_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dra_address, &size_source_dra_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dra_address, &length_source_dra_address_1));
			if (length_source_dra_address_1 > size_source_dra_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dra_address_1, length_source_dra_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dra_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dra_address, length_source_dra_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dra_address_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaModRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaModRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaModRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context", r->naming_context);
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "naming_context", r->naming_context);
	ndr->depth--;
	ndr_print_GUID(ndr, "source_dra", &r->source_dra);
	ndr_print_ptr(ndr, "source_dra_address", r->source_dra_address);
	ndr->depth++;
	if (r->source_dra_address) {
		ndr_print_string(ndr, "source_dra_address", r->source_dra_address);
	}
	ndr->depth--;
	ndr_print_array_uint8(ndr, "schedule", r->schedule, 84);
	ndr_print_drsuapi_DrsOptions(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "modify_fields", r->modify_fields);
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaModRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaModRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaModRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaModRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaModRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaModRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaModRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaModRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaModRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaModRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaModRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsReplicaModRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsMembershipType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsMembershipType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsMembershipType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsMembershipType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsMembershipType(struct ndr_print *ndr, const char *name, enum drsuapi_DsMembershipType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_AND_DOMAIN_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_LOCAL_GROUPS2"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_UNIVERSAL_GROUPS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_GROUPMEMBERS"; break;
		case DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2: val = "DRSUAPI_DS_MEMBERSHIP_TYPE_DOMAIN_GROUPS2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMembershipsCtr1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetMembershipsCtr1 *r)
{
	uint32_t cntr_info_array_1;
	uint32_t cntr_group_attrs_1;
	uint32_t cntr_sids_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_memberships));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->group_attrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_memberships));
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (r->num_memberships); cntr_info_array_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array[cntr_info_array_1]));
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (r->num_memberships); cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
				}
			}
		}
		if (r->group_attrs) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_memberships));
			for (cntr_group_attrs_1 = 0; cntr_group_attrs_1 < (r->num_memberships); cntr_group_attrs_1++) {
				NDR_CHECK(ndr_push_security_GroupAttrs(ndr, NDR_SCALARS, r->group_attrs[cntr_group_attrs_1]));
			}
		}
		if (r->sids) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sids));
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->num_sids); cntr_sids_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->sids[cntr_sids_1]));
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (r->num_sids); cntr_sids_1++) {
				if (r->sids[cntr_sids_1]) {
					NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS|NDR_BUFFERS, r->sids[cntr_sids_1]));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMembershipsCtr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetMembershipsCtr1 *r)
{
	uint32_t _ptr_info_array;
	uint32_t size_info_array_1 = 0;
	uint32_t cntr_info_array_1;
	TALLOC_CTX *_mem_save_info_array_0 = NULL;
	TALLOC_CTX *_mem_save_info_array_1 = NULL;
	TALLOC_CTX *_mem_save_info_array_2 = NULL;
	uint32_t _ptr_group_attrs;
	uint32_t size_group_attrs_1 = 0;
	uint32_t cntr_group_attrs_1;
	TALLOC_CTX *_mem_save_group_attrs_0 = NULL;
	TALLOC_CTX *_mem_save_group_attrs_1 = NULL;
	uint32_t _ptr_sids;
	uint32_t size_sids_1 = 0;
	uint32_t cntr_sids_1;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	TALLOC_CTX *_mem_save_sids_1 = NULL;
	TALLOC_CTX *_mem_save_sids_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_memberships));
		if (r->num_memberships > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_memberships), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		if (r->num_sids > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_sids), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
		if (_ptr_info_array) {
			NDR_PULL_ALLOC(ndr, r->info_array);
		} else {
			r->info_array = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_attrs));
		if (_ptr_group_attrs) {
			NDR_PULL_ALLOC(ndr, r->group_attrs);
		} else {
			r->group_attrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
		if (_ptr_sids) {
			NDR_PULL_ALLOC(ndr, r->sids);
		} else {
			r->sids = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			_mem_save_info_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->info_array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->info_array, &size_info_array_1));
			NDR_PULL_ALLOC_N(ndr, r->info_array, size_info_array_1);
			_mem_save_info_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (size_info_array_1); cntr_info_array_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
				if (_ptr_info_array) {
					NDR_PULL_ALLOC(ndr, r->info_array[cntr_info_array_1]);
				} else {
					r->info_array[cntr_info_array_1] = NULL;
				}
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (size_info_array_1); cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					_mem_save_info_array_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info_array[cntr_info_array_1], 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_0, 0);
		}
		if (r->group_attrs) {
			_mem_save_group_attrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->group_attrs, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->group_attrs));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->group_attrs, &size_group_attrs_1));
			NDR_PULL_ALLOC_N(ndr, r->group_attrs, size_group_attrs_1);
			_mem_save_group_attrs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->group_attrs, 0);
			for (cntr_group_attrs_1 = 0; cntr_group_attrs_1 < (size_group_attrs_1); cntr_group_attrs_1++) {
				NDR_CHECK(ndr_pull_security_GroupAttrs(ndr, NDR_SCALARS, &r->group_attrs[cntr_group_attrs_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_attrs_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_attrs_0, 0);
		}
		if (r->sids) {
			_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_1));
			NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_1);
			_mem_save_sids_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sids));
				if (_ptr_sids) {
					NDR_PULL_ALLOC(ndr, r->sids[cntr_sids_1]);
				} else {
					r->sids[cntr_sids_1] = NULL;
				}
			}
			for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
				if (r->sids[cntr_sids_1]) {
					_mem_save_sids_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->sids[cntr_sids_1], 0);
					NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS|NDR_BUFFERS, r->sids[cntr_sids_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		}
		if (r->info_array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->info_array, r->num_memberships));
		}
		for (cntr_info_array_1 = 0; cntr_info_array_1 < (size_info_array_1); cntr_info_array_1++) {
		}
		if (r->group_attrs) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->group_attrs, r->num_memberships));
		}
		if (r->sids) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
		for (cntr_sids_1 = 0; cntr_sids_1 < (size_sids_1); cntr_sids_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetMembershipsCtr1 *r)
{
	uint32_t cntr_info_array_1;
	uint32_t cntr_group_attrs_1;
	uint32_t cntr_sids_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetMembershipsCtr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_uint32(ndr, "num_memberships", r->num_memberships);
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr_print_ptr(ndr, "info_array", r->info_array);
	ndr->depth++;
	if (r->info_array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "info_array", (uint32_t)(r->num_memberships));
		ndr->depth++;
		for (cntr_info_array_1 = 0; cntr_info_array_1 < (r->num_memberships); cntr_info_array_1++) {
			ndr_print_ptr(ndr, "info_array", r->info_array[cntr_info_array_1]);
			ndr->depth++;
			if (r->info_array[cntr_info_array_1]) {
				ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "info_array", r->info_array[cntr_info_array_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "group_attrs", r->group_attrs);
	ndr->depth++;
	if (r->group_attrs) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "group_attrs", (uint32_t)(r->num_memberships));
		ndr->depth++;
		for (cntr_group_attrs_1 = 0; cntr_group_attrs_1 < (r->num_memberships); cntr_group_attrs_1++) {
			ndr_print_security_GroupAttrs(ndr, "group_attrs", r->group_attrs[cntr_group_attrs_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sids", r->sids);
	ndr->depth++;
	if (r->sids) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->num_sids));
		ndr->depth++;
		for (cntr_sids_1 = 0; cntr_sids_1 < (r->num_sids); cntr_sids_1++) {
			ndr_print_ptr(ndr, "sids", r->sids[cntr_sids_1]);
			ndr->depth++;
			if (r->sids[cntr_sids_1]) {
				ndr_print_dom_sid28(ndr, "sids", r->sids[cntr_sids_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMembershipsCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetMembershipsCtr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMembershipsCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetMembershipsCtr *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMembershipsCtr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMembershipsCtr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMembershipsCtr1(ndr, "ctr1", &r->ctr1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMembershipsRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetMembershipsRequest1 *r)
{
	uint32_t cntr_info_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_drsuapi_DsMembershipType(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (r->count); cntr_info_array_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->info_array[cntr_info_array_1]));
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (r->count); cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
				}
			}
		}
		if (r->domain) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMembershipsRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetMembershipsRequest1 *r)
{
	uint32_t _ptr_info_array;
	uint32_t size_info_array_1 = 0;
	uint32_t cntr_info_array_1;
	TALLOC_CTX *_mem_save_info_array_0 = NULL;
	TALLOC_CTX *_mem_save_info_array_1 = NULL;
	TALLOC_CTX *_mem_save_info_array_2 = NULL;
	uint32_t _ptr_domain;
	TALLOC_CTX *_mem_save_domain_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 1 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(1), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
		if (_ptr_info_array) {
			NDR_PULL_ALLOC(ndr, r->info_array);
		} else {
			r->info_array = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_drsuapi_DsMembershipType(ndr, NDR_SCALARS, &r->type));
		if (r->type < 1 || r->type > 7) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%d) out of range (%d - %d)", (int)(r->type), (int)(1), (int)(7));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain));
		if (_ptr_domain) {
			NDR_PULL_ALLOC(ndr, r->domain);
		} else {
			r->domain = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info_array) {
			_mem_save_info_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->info_array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->info_array, &size_info_array_1));
			NDR_PULL_ALLOC_N(ndr, r->info_array, size_info_array_1);
			_mem_save_info_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info_array, 0);
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (size_info_array_1); cntr_info_array_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info_array));
				if (_ptr_info_array) {
					NDR_PULL_ALLOC(ndr, r->info_array[cntr_info_array_1]);
				} else {
					r->info_array[cntr_info_array_1] = NULL;
				}
			}
			for (cntr_info_array_1 = 0; cntr_info_array_1 < (size_info_array_1); cntr_info_array_1++) {
				if (r->info_array[cntr_info_array_1]) {
					_mem_save_info_array_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->info_array[cntr_info_array_1], 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->info_array[cntr_info_array_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_array_0, 0);
		}
		if (r->domain) {
			_mem_save_domain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->domain));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_0, 0);
		}
		if (r->info_array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->info_array, r->count));
		}
		for (cntr_info_array_1 = 0; cntr_info_array_1 < (size_info_array_1); cntr_info_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetMembershipsRequest1 *r)
{
	uint32_t cntr_info_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetMembershipsRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "info_array", r->info_array);
	ndr->depth++;
	if (r->info_array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "info_array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_info_array_1 = 0; cntr_info_array_1 < (r->count); cntr_info_array_1++) {
			ndr_print_ptr(ndr, "info_array", r->info_array[cntr_info_array_1]);
			ndr->depth++;
			if (r->info_array[cntr_info_array_1]) {
				ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "info_array", r->info_array[cntr_info_array_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_drsuapi_DsMembershipType(ndr, "type", r->type);
	ndr_print_ptr(ndr, "domain", r->domain);
	ndr->depth++;
	if (r->domain) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "domain", r->domain);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMembershipsRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetMembershipsRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMembershipsRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetMembershipsRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMembershipsRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMembershipsRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMembershipsRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMembershipsRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNT4ChangeLogFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNT4ChangeLogFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_NT4_CHANGELOG_GET_CHANGELOG", DRSUAPI_NT4_CHANGELOG_GET_CHANGELOG, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_NT4_CHANGELOG_GET_SERIAL_NUMBERS", DRSUAPI_NT4_CHANGELOG_GET_SERIAL_NUMBERS, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNT4ChangeLogRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->preferred_maximum_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->restart_length));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->restart_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->restart_data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->restart_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->restart_data, r->restart_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNT4ChangeLogRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	uint32_t _ptr_restart_data;
	uint32_t size_restart_data_1 = 0;
	TALLOC_CTX *_mem_save_restart_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->preferred_maximum_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->restart_length));
		if (r->restart_length > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->restart_length), (uint32_t)(0), (uint32_t)(10485760));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_restart_data));
		if (_ptr_restart_data) {
			NDR_PULL_ALLOC(ndr, r->restart_data);
		} else {
			r->restart_data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->restart_data) {
			_mem_save_restart_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->restart_data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->restart_data));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->restart_data, &size_restart_data_1));
			NDR_PULL_ALLOC_N(ndr, r->restart_data, size_restart_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->restart_data, size_restart_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_restart_data_0, 0);
		}
		if (r->restart_data) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->restart_data, r->restart_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNT4ChangeLogRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNT4ChangeLogRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsGetNT4ChangeLogFlags(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "preferred_maximum_length", r->preferred_maximum_length);
	ndr_print_uint32(ndr, "restart_length", r->restart_length);
	ndr_print_ptr(ndr, "restart_data", r->restart_data);
	ndr->depth++;
	if (r->restart_data) {
		ndr_print_array_uint8(ndr, "restart_data", r->restart_data, r->restart_length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNT4ChangeLogRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNT4ChangeLogRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNT4ChangeLogRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNT4ChangeLogRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetNT4ChangeLogRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNT4ChangeLogInfo1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->restart_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->log_length));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->sam_serial_number));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->sam_creation_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->builtin_serial_number));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->builtin_creation_time));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->lsa_serial_number));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->lsa_creation_time));
		NDR_CHECK(ndr_push_NTSTATUS(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->restart_data));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->log_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->restart_data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->restart_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->restart_data, r->restart_length));
		}
		if (r->log_data) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->log_length));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->log_data, r->log_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNT4ChangeLogInfo1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	uint32_t _ptr_restart_data;
	uint32_t size_restart_data_1 = 0;
	TALLOC_CTX *_mem_save_restart_data_0 = NULL;
	uint32_t _ptr_log_data;
	uint32_t size_log_data_1 = 0;
	TALLOC_CTX *_mem_save_log_data_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->restart_length));
		if (r->restart_length > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->restart_length), (uint32_t)(0), (uint32_t)(10485760));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->log_length));
		if (r->log_length > 10485760) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->log_length), (uint32_t)(0), (uint32_t)(10485760));
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->sam_serial_number));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->sam_creation_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->builtin_serial_number));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->builtin_creation_time));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->lsa_serial_number));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->lsa_creation_time));
		NDR_CHECK(ndr_pull_NTSTATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_restart_data));
		if (_ptr_restart_data) {
			NDR_PULL_ALLOC(ndr, r->restart_data);
		} else {
			r->restart_data = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_log_data));
		if (_ptr_log_data) {
			NDR_PULL_ALLOC(ndr, r->log_data);
		} else {
			r->log_data = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->restart_data) {
			_mem_save_restart_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->restart_data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->restart_data));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->restart_data, &size_restart_data_1));
			NDR_PULL_ALLOC_N(ndr, r->restart_data, size_restart_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->restart_data, size_restart_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_restart_data_0, 0);
		}
		if (r->log_data) {
			_mem_save_log_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->log_data, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->log_data));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->log_data, &size_log_data_1));
			NDR_PULL_ALLOC_N(ndr, r->log_data, size_log_data_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->log_data, size_log_data_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_log_data_0, 0);
		}
		if (r->restart_data) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->restart_data, r->restart_length));
		}
		if (r->log_data) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->log_data, r->log_length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetNT4ChangeLogInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNT4ChangeLogInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "restart_length", r->restart_length);
	ndr_print_uint32(ndr, "log_length", r->log_length);
	ndr_print_hyper(ndr, "sam_serial_number", r->sam_serial_number);
	ndr_print_NTTIME(ndr, "sam_creation_time", r->sam_creation_time);
	ndr_print_hyper(ndr, "builtin_serial_number", r->builtin_serial_number);
	ndr_print_NTTIME(ndr, "builtin_creation_time", r->builtin_creation_time);
	ndr_print_hyper(ndr, "lsa_serial_number", r->lsa_serial_number);
	ndr_print_NTTIME(ndr, "lsa_creation_time", r->lsa_creation_time);
	ndr_print_NTSTATUS(ndr, "status", r->status);
	ndr_print_ptr(ndr, "restart_data", r->restart_data);
	ndr->depth++;
	if (r->restart_data) {
		ndr_print_array_uint8(ndr, "restart_data", r->restart_data, r->restart_length);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "log_data", r->log_data);
	ndr->depth++;
	if (r->log_data) {
		ndr_print_array_uint8(ndr, "log_data", r->log_data, r->log_length);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNT4ChangeLogInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNT4ChangeLogInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_SCALARS, &r->info1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogInfo1(ndr, NDR_BUFFERS, &r->info1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLogInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetNT4ChangeLogInfo *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetNT4ChangeLogInfo");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetNT4ChangeLogInfo1(ndr, "info1", &r->info1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsNameStatus(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsNameStatus r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameStatus(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsNameStatus *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameStatus(struct ndr_print *ndr, const char *name, enum drsuapi_DsNameStatus r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_NAME_STATUS_OK: val = "DRSUAPI_DS_NAME_STATUS_OK"; break;
		case DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR: val = "DRSUAPI_DS_NAME_STATUS_RESOLVE_ERROR"; break;
		case DRSUAPI_DS_NAME_STATUS_NOT_FOUND: val = "DRSUAPI_DS_NAME_STATUS_NOT_FOUND"; break;
		case DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE: val = "DRSUAPI_DS_NAME_STATUS_NOT_UNIQUE"; break;
		case DRSUAPI_DS_NAME_STATUS_NO_MAPPING: val = "DRSUAPI_DS_NAME_STATUS_NO_MAPPING"; break;
		case DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY: val = "DRSUAPI_DS_NAME_STATUS_DOMAIN_ONLY"; break;
		case DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING: val = "DRSUAPI_DS_NAME_STATUS_NO_SYNTACTICAL_MAPPING"; break;
		case DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL: val = "DRSUAPI_DS_NAME_STATUS_TRUST_REFERRAL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsNameFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsNameFlags r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsNameFlags *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameFlags(struct ndr_print *ndr, const char *name, enum drsuapi_DsNameFlags r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_NAME_FLAG_NO_FLAGS: val = "DRSUAPI_DS_NAME_FLAG_NO_FLAGS"; break;
		case DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY: val = "DRSUAPI_DS_NAME_FLAG_SYNTACTICAL_ONLY"; break;
		case DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC: val = "DRSUAPI_DS_NAME_FLAG_EVAL_AT_DC"; break;
		case DRSUAPI_DS_NAME_FLAG_GCVERIFY: val = "DRSUAPI_DS_NAME_FLAG_GCVERIFY"; break;
		case DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL: val = "DRSUAPI_DS_NAME_FLAG_TRUST_REFERRAL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsNameFormat(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsNameFormat r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameFormat(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsNameFormat *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameFormat(struct ndr_print *ndr, const char *name, enum drsuapi_DsNameFormat r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_NAME_FORMAT_UNKNOWN: val = "DRSUAPI_DS_NAME_FORMAT_UNKNOWN"; break;
		case DRSUAPI_DS_NAME_FORMAT_FQDN_1779: val = "DRSUAPI_DS_NAME_FORMAT_FQDN_1779"; break;
		case DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT: val = "DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT"; break;
		case DRSUAPI_DS_NAME_FORMAT_DISPLAY: val = "DRSUAPI_DS_NAME_FORMAT_DISPLAY"; break;
		case DRSUAPI_DS_NAME_FORMAT_GUID: val = "DRSUAPI_DS_NAME_FORMAT_GUID"; break;
		case DRSUAPI_DS_NAME_FORMAT_CANONICAL: val = "DRSUAPI_DS_NAME_FORMAT_CANONICAL"; break;
		case DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL: val = "DRSUAPI_DS_NAME_FORMAT_USER_PRINCIPAL"; break;
		case DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX: val = "DRSUAPI_DS_NAME_FORMAT_CANONICAL_EX"; break;
		case DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL: val = "DRSUAPI_DS_NAME_FORMAT_SERVICE_PRINCIPAL"; break;
		case DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY: val = "DRSUAPI_DS_NAME_FORMAT_SID_OR_SID_HISTORY"; break;
		case DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN: val = "DRSUAPI_DS_NAME_FORMAT_DNS_DOMAIN"; break;
		case DRSUAPI_DS_NAME_FORMAT_UPN_AND_ALTSECID: val = "DRSUAPI_DS_NAME_FORMAT_UPN_AND_ALTSECID"; break;
		case DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT_NAME_SANS_DOMAIN_EX: val = "DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT_NAME_SANS_DOMAIN_EX"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_GLOBAL_CATALOG_SERVERS: val = "DRSUAPI_DS_NAME_FORMAT_LIST_GLOBAL_CATALOG_SERVERS"; break;
		case DRSUAPI_DS_NAME_FORMAT_UPN_FOR_LOGON: val = "DRSUAPI_DS_NAME_FORMAT_UPN_FOR_LOGON"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_SERVERS_WITH_DCS_IN_SITE: val = "DRSUAPI_DS_NAME_FORMAT_LIST_SERVERS_WITH_DCS_IN_SITE"; break;
		case DRSUAPI_DS_NAME_FORMAT_STRING_SID_NAME: val = "DRSUAPI_DS_NAME_FORMAT_STRING_SID_NAME"; break;
		case DRSUAPI_DS_NAME_FORMAT_ALT_SECURITY_IDENTITIES_NAME: val = "DRSUAPI_DS_NAME_FORMAT_ALT_SECURITY_IDENTITIES_NAME"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_NCS: val = "DRSUAPI_DS_NAME_FORMAT_LIST_NCS"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_DOMAINS: val = "DRSUAPI_DS_NAME_FORMAT_LIST_DOMAINS"; break;
		case DRSUAPI_DS_NAME_FORMAT_MAP_SCHEMA_GUID: val = "DRSUAPI_DS_NAME_FORMAT_MAP_SCHEMA_GUID"; break;
		case DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT_NAME_SANS_DOMAIN: val = "DRSUAPI_DS_NAME_FORMAT_NT4_ACCOUNT_NAME_SANS_DOMAIN"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_ROLES: val = "DRSUAPI_DS_NAME_FORMAT_LIST_ROLES"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_INFO_FOR_SERVER: val = "DRSUAPI_DS_NAME_FORMAT_LIST_INFO_FOR_SERVER"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_SERVERS_FOR_DOMAIN_IN_SITE: val = "DRSUAPI_DS_NAME_FORMAT_LIST_SERVERS_FOR_DOMAIN_IN_SITE"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_DOMAINS_IN_SITE: val = "DRSUAPI_DS_NAME_FORMAT_LIST_DOMAINS_IN_SITE"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_SERVERS_IN_SITE: val = "DRSUAPI_DS_NAME_FORMAT_LIST_SERVERS_IN_SITE"; break;
		case DRSUAPI_DS_NAME_FORMAT_LIST_SITES: val = "DRSUAPI_DS_NAME_FORMAT_LIST_SITES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsNameString(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsNameString *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->str));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->str, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->str, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->str, ndr_charset_length(r->str, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameString(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsNameString *r)
{
	uint32_t _ptr_str;
	uint32_t size_str_1 = 0;
	uint32_t length_str_1 = 0;
	TALLOC_CTX *_mem_save_str_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_str));
		if (_ptr_str) {
			NDR_PULL_ALLOC(ndr, r->str);
		} else {
			r->str = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str) {
			_mem_save_str_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->str, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->str));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->str));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->str, &size_str_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->str, &length_str_1));
			if (length_str_1 > size_str_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_str_1, length_str_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_str_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->str, length_str_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_str_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameString(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameString *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsNameString");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "str", r->str);
	ndr->depth++;
	if (r->str) {
		ndr_print_string(ndr, "str", r->str);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsNameRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsNameRequest1 *r)
{
	uint32_t cntr_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->codepage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->language));
		NDR_CHECK(ndr_push_drsuapi_DsNameFlags(ndr, NDR_SCALARS, r->format_flags));
		NDR_CHECK(ndr_push_drsuapi_DsNameFormat(ndr, NDR_SCALARS, r->format_offered));
		NDR_CHECK(ndr_push_drsuapi_DsNameFormat(ndr, NDR_SCALARS, r->format_desired));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsNameRequest1 *r)
{
	uint32_t _ptr_names;
	uint32_t size_names_1 = 0;
	uint32_t cntr_names_1;
	TALLOC_CTX *_mem_save_names_0 = NULL;
	TALLOC_CTX *_mem_save_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->codepage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->language));
		NDR_CHECK(ndr_pull_drsuapi_DsNameFlags(ndr, NDR_SCALARS, &r->format_flags));
		NDR_CHECK(ndr_pull_drsuapi_DsNameFormat(ndr, NDR_SCALARS, &r->format_offered));
		NDR_CHECK(ndr_pull_drsuapi_DsNameFormat(ndr, NDR_SCALARS, &r->format_desired));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count < 1 || r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(1), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_names));
		if (_ptr_names) {
			NDR_PULL_ALLOC(ndr, r->names);
		} else {
			r->names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->names) {
			_mem_save_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->names, &size_names_1));
			NDR_PULL_ALLOC_N(ndr, r->names, size_names_1);
			_mem_save_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->names, 0);
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->names[cntr_names_1]));
			}
			for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->names[cntr_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_names_0, 0);
		}
		if (r->names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->names, r->count));
		}
		for (cntr_names_1 = 0; cntr_names_1 < (size_names_1); cntr_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameRequest1 *r)
{
	uint32_t cntr_names_1;
	ndr_print_struct(ndr, name, "drsuapi_DsNameRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "codepage", r->codepage);
	ndr_print_uint32(ndr, "language", r->language);
	ndr_print_drsuapi_DsNameFlags(ndr, "format_flags", r->format_flags);
	ndr_print_drsuapi_DsNameFormat(ndr, "format_offered", r->format_offered);
	ndr_print_drsuapi_DsNameFormat(ndr, "format_desired", r->format_desired);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "names", r->names);
	ndr->depth++;
	if (r->names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "names", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_names_1 = 0; cntr_names_1 < (r->count); cntr_names_1++) {
			ndr_print_drsuapi_DsNameString(ndr, "names", &r->names[cntr_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsNameRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsNameRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsNameRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsNameRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsNameRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsNameRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsNameRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsNameRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsNameRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsNameRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsNameInfo1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsNameInfo1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsNameStatus(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->result_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dns_domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_domain_name, ndr_charset_length(r->dns_domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->result_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->result_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->result_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->result_name, ndr_charset_length(r->result_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameInfo1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsNameInfo1 *r)
{
	uint32_t _ptr_dns_domain_name;
	uint32_t size_dns_domain_name_1 = 0;
	uint32_t length_dns_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_dns_domain_name_0 = NULL;
	uint32_t _ptr_result_name;
	uint32_t size_result_name_1 = 0;
	uint32_t length_result_name_1 = 0;
	TALLOC_CTX *_mem_save_result_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsNameStatus(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_domain_name));
		if (_ptr_dns_domain_name) {
			NDR_PULL_ALLOC(ndr, r->dns_domain_name);
		} else {
			r->dns_domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_result_name));
		if (_ptr_result_name) {
			NDR_PULL_ALLOC(ndr, r->result_name);
		} else {
			r->result_name = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dns_domain_name) {
			_mem_save_dns_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dns_domain_name, &size_dns_domain_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dns_domain_name, &length_dns_domain_name_1));
			if (length_dns_domain_name_1 > size_dns_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dns_domain_name_1, length_dns_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_domain_name, length_dns_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_domain_name_0, 0);
		}
		if (r->result_name) {
			_mem_save_result_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->result_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->result_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->result_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->result_name, &size_result_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->result_name, &length_result_name_1));
			if (length_result_name_1 > size_result_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_result_name_1, length_result_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_result_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->result_name, length_result_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_result_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsNameInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsNameStatus(ndr, "status", r->status);
	ndr_print_ptr(ndr, "dns_domain_name", r->dns_domain_name);
	ndr->depth++;
	if (r->dns_domain_name) {
		ndr_print_string(ndr, "dns_domain_name", r->dns_domain_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "result_name", r->result_name);
	ndr->depth++;
	if (r->result_name) {
		ndr_print_string(ndr, "result_name", r->result_name);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsNameCtr1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsNameCtr1 *r)
{
	uint32_t cntr_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameCtr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsNameCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	TALLOC_CTX *_mem_save_array_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_1));
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsNameCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsNameCtr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_drsuapi_DsNameInfo1(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsNameCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsNameCtr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ctr1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->ctr1) {
					NDR_CHECK(ndr_push_drsuapi_DsNameCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsNameCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsNameCtr *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_ctr1_0 = NULL;
	uint32_t _ptr_ctr1;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ctr1));
				if (_ptr_ctr1) {
					NDR_PULL_ALLOC(ndr, r->ctr1);
				} else {
					r->ctr1 = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->ctr1) {
					_mem_save_ctr1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ctr1, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsNameCtr1(ndr, NDR_SCALARS|NDR_BUFFERS, r->ctr1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr1_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsNameCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsNameCtr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsNameCtr");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "ctr1", r->ctr1);
			ndr->depth++;
			if (r->ctr1) {
				ndr_print_drsuapi_DsNameCtr1(ndr, "ctr1", r->ctr1);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsSpnOperation(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsSpnOperation r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsSpnOperation(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsSpnOperation *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsSpnOperation(struct ndr_print *ndr, const char *name, enum drsuapi_DsSpnOperation r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_SPN_OPERATION_ADD: val = "DRSUAPI_DS_SPN_OPERATION_ADD"; break;
		case DRSUAPI_DS_SPN_OPERATION_REPLACE: val = "DRSUAPI_DS_SPN_OPERATION_REPLACE"; break;
		case DRSUAPI_DS_SPN_OPERATION_DELETE: val = "DRSUAPI_DS_SPN_OPERATION_DELETE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsWriteAccountSpnRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	uint32_t cntr_spn_names_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsSpnOperation(ndr, NDR_SCALARS, r->operation));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->spn_names));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->spn_names) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < (r->count); cntr_spn_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->spn_names[cntr_spn_names_1]));
			}
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < (r->count); cntr_spn_names_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->spn_names[cntr_spn_names_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsWriteAccountSpnRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	uint32_t _ptr_object_dn;
	uint32_t size_object_dn_1 = 0;
	uint32_t length_object_dn_1 = 0;
	TALLOC_CTX *_mem_save_object_dn_0 = NULL;
	uint32_t _ptr_spn_names;
	uint32_t size_spn_names_1 = 0;
	uint32_t cntr_spn_names_1;
	TALLOC_CTX *_mem_save_spn_names_0 = NULL;
	TALLOC_CTX *_mem_save_spn_names_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsSpnOperation(ndr, NDR_SCALARS, &r->operation));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_spn_names));
		if (_ptr_spn_names) {
			NDR_PULL_ALLOC(ndr, r->spn_names);
		} else {
			r->spn_names = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->object_dn, &size_object_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->object_dn, &length_object_dn_1));
			if (length_object_dn_1 > size_object_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_object_dn_1, length_object_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_object_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, length_object_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->spn_names) {
			_mem_save_spn_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->spn_names, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->spn_names));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->spn_names, &size_spn_names_1));
			NDR_PULL_ALLOC_N(ndr, r->spn_names, size_spn_names_1);
			_mem_save_spn_names_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->spn_names, 0);
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < (size_spn_names_1); cntr_spn_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_SCALARS, &r->spn_names[cntr_spn_names_1]));
			}
			for (cntr_spn_names_1 = 0; cntr_spn_names_1 < (size_spn_names_1); cntr_spn_names_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsNameString(ndr, NDR_BUFFERS, &r->spn_names[cntr_spn_names_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_spn_names_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_spn_names_0, 0);
		}
		if (r->spn_names) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->spn_names, r->count));
		}
		for (cntr_spn_names_1 = 0; cntr_spn_names_1 < (size_spn_names_1); cntr_spn_names_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsWriteAccountSpnRequest1 *r)
{
	uint32_t cntr_spn_names_1;
	ndr_print_struct(ndr, name, "drsuapi_DsWriteAccountSpnRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsSpnOperation(ndr, "operation", r->operation);
	ndr_print_uint32(ndr, "unknown1", r->unknown1);
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "spn_names", r->spn_names);
	ndr->depth++;
	if (r->spn_names) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "spn_names", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_spn_names_1 = 0; cntr_spn_names_1 < (r->count); cntr_spn_names_1++) {
			ndr_print_drsuapi_DsNameString(ndr, "spn_names", &r->spn_names[cntr_spn_names_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsWriteAccountSpnRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsWriteAccountSpnRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsWriteAccountSpnRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsWriteAccountSpnRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsWriteAccountSpnRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsWriteAccountSpnRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsWriteAccountSpnRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsWriteAccountSpnResult1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsWriteAccountSpnResult1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnResult1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsWriteAccountSpnResult1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsWriteAccountSpnResult1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_WERROR(ndr, "status", r->status);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsWriteAccountSpnResult(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsWriteAccountSpnResult *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnResult1(ndr, NDR_SCALARS, &r->res1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsWriteAccountSpnResult(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsWriteAccountSpnResult *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnResult1(ndr, NDR_SCALARS, &r->res1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpnResult(struct ndr_print *ndr, const char *name, const union drsuapi_DsWriteAccountSpnResult *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsWriteAccountSpnResult");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsWriteAccountSpnResult1(ndr, "res1", &r->res1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsRemoveDSServerRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->commit));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->domain_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_dn, ndr_charset_length(r->domain_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsRemoveDSServerRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	uint32_t _ptr_server_dn;
	uint32_t size_server_dn_1 = 0;
	uint32_t length_server_dn_1 = 0;
	TALLOC_CTX *_mem_save_server_dn_0 = NULL;
	uint32_t _ptr_domain_dn;
	uint32_t size_domain_dn_1 = 0;
	uint32_t length_domain_dn_1 = 0;
	TALLOC_CTX *_mem_save_domain_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_dn));
		if (_ptr_domain_dn) {
			NDR_PULL_ALLOC(ndr, r->domain_dn);
		} else {
			r->domain_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->commit));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->server_dn, &size_server_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->server_dn, &length_server_dn_1));
			if (length_server_dn_1 > size_server_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_server_dn_1, length_server_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, length_server_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
		if (r->domain_dn) {
			_mem_save_domain_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->domain_dn, &size_domain_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->domain_dn, &length_domain_dn_1));
			if (length_domain_dn_1 > size_domain_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_dn_1, length_domain_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_dn, length_domain_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsRemoveDSServerRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsRemoveDSServerRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "domain_dn", r->domain_dn);
	ndr->depth++;
	if (r->domain_dn) {
		ndr_print_string(ndr, "domain_dn", r->domain_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "commit", r->commit);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsRemoveDSServerRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsRemoveDSServerRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsRemoveDSServerRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsRemoveDSServerRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsRemoveDSServerRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsRemoveDSServerRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsRemoveDSServerRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsRemoveDSServerResult1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsRemoveDSServerResult1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->last_dc_in_domain));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsRemoveDSServerResult1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsRemoveDSServerResult1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->last_dc_in_domain));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerResult1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsRemoveDSServerResult1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsRemoveDSServerResult1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "last_dc_in_domain", r->last_dc_in_domain);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsRemoveDSServerResult(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsRemoveDSServerResult *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerResult1(ndr, NDR_SCALARS, &r->res1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsRemoveDSServerResult(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsRemoveDSServerResult *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerResult1(ndr, NDR_SCALARS, &r->res1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServerResult(struct ndr_print *ndr, const char *name, const union drsuapi_DsRemoveDSServerResult *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsRemoveDSServerResult");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsRemoveDSServerResult1(ndr, "res1", &r->res1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoCtrLevels(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsGetDCInfoCtrLevels r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoCtrLevels(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsGetDCInfoCtrLevels *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtrLevels(struct ndr_print *ndr, const char *name, enum drsuapi_DsGetDCInfoCtrLevels r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DC_INFO_CTR_1: val = "DRSUAPI_DC_INFO_CTR_1"; break;
		case DRSUAPI_DC_INFO_CTR_2: val = "DRSUAPI_DC_INFO_CTR_2"; break;
		case DRSUAPI_DC_INFO_CTR_3: val = "DRSUAPI_DC_INFO_CTR_3"; break;
		case DRSUAPI_DC_CONNECTION_CTR_01: val = "DRSUAPI_DC_CONNECTION_CTR_01"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfoRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtrLevels(ndr, NDR_SCALARS, r->level));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfoRequest1 *r)
{
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_domain_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtrLevels(ndr, NDR_SCALARS, &r->level));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->domain_name, &size_domain_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->domain_name, &length_domain_name_1));
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, length_domain_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsGetDCInfoCtrLevels(ndr, "level", r->level);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetDCInfoRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetDCInfoRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetDCInfoRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetDCInfoRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetDCInfoRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfo1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfo1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_pdc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_enabled));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->netbios_name, ndr_charset_length(r->netbios_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dns_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_name, ndr_charset_length(r->dns_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_name, ndr_charset_length(r->site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->computer_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_dn, ndr_charset_length(r->computer_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfo1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfo1 *r)
{
	uint32_t _ptr_netbios_name;
	uint32_t size_netbios_name_1 = 0;
	uint32_t length_netbios_name_1 = 0;
	TALLOC_CTX *_mem_save_netbios_name_0 = NULL;
	uint32_t _ptr_dns_name;
	uint32_t size_dns_name_1 = 0;
	uint32_t length_dns_name_1 = 0;
	TALLOC_CTX *_mem_save_dns_name_0 = NULL;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	TALLOC_CTX *_mem_save_site_name_0 = NULL;
	uint32_t _ptr_computer_dn;
	uint32_t size_computer_dn_1 = 0;
	uint32_t length_computer_dn_1 = 0;
	TALLOC_CTX *_mem_save_computer_dn_0 = NULL;
	uint32_t _ptr_server_dn;
	uint32_t size_server_dn_1 = 0;
	uint32_t length_server_dn_1 = 0;
	TALLOC_CTX *_mem_save_server_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_name));
		if (_ptr_netbios_name) {
			NDR_PULL_ALLOC(ndr, r->netbios_name);
		} else {
			r->netbios_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_name));
		if (_ptr_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dns_name);
		} else {
			r->dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->site_name);
		} else {
			r->site_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_dn));
		if (_ptr_computer_dn) {
			NDR_PULL_ALLOC(ndr, r->computer_dn);
		} else {
			r->computer_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_pdc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_enabled));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			_mem_save_netbios_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->netbios_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->netbios_name, &size_netbios_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->netbios_name, &length_netbios_name_1));
			if (length_netbios_name_1 > size_netbios_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_netbios_name_1, length_netbios_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_netbios_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->netbios_name, length_netbios_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_name_0, 0);
		}
		if (r->dns_name) {
			_mem_save_dns_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dns_name, &size_dns_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dns_name, &length_dns_name_1));
			if (length_dns_name_1 > size_dns_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dns_name_1, length_dns_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_name, length_dns_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_name_0, 0);
		}
		if (r->site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_name, &size_site_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_name, &length_site_name_1));
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		if (r->computer_dn) {
			_mem_save_computer_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->computer_dn, &size_computer_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->computer_dn, &length_computer_dn_1));
			if (length_computer_dn_1 > size_computer_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_computer_dn_1, length_computer_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_dn, length_computer_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_dn_0, 0);
		}
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->server_dn, &size_server_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->server_dn, &length_server_dn_1));
			if (length_server_dn_1 > size_server_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_server_dn_1, length_server_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, length_server_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfo1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfo1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfo1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "netbios_name", r->netbios_name);
	ndr->depth++;
	if (r->netbios_name) {
		ndr_print_string(ndr, "netbios_name", r->netbios_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_name", r->dns_name);
	ndr->depth++;
	if (r->dns_name) {
		ndr_print_string(ndr, "dns_name", r->dns_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_name", r->site_name);
	ndr->depth++;
	if (r->site_name) {
		ndr_print_string(ndr, "site_name", r->site_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "computer_dn", r->computer_dn);
	ndr->depth++;
	if (r->computer_dn) {
		ndr_print_string(ndr, "computer_dn", r->computer_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "is_pdc", r->is_pdc);
	ndr_print_uint32(ndr, "is_enabled", r->is_enabled);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoCtr1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfoCtr1 *r)
{
	uint32_t cntr_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoCtr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfoCtr1 *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	TALLOC_CTX *_mem_save_array_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_1));
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo1(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo1(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoCtr1 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoCtr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_drsuapi_DsGetDCInfo1(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfo2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfo2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ntds_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_pdc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_enabled));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_gc));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->computer_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->server_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->ntds_guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->netbios_name, ndr_charset_length(r->netbios_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dns_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_name, ndr_charset_length(r->dns_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_name, ndr_charset_length(r->site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_dn, ndr_charset_length(r->site_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->computer_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_dn, ndr_charset_length(r->computer_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->ntds_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ntds_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ntds_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ntds_dn, ndr_charset_length(r->ntds_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfo2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfo2 *r)
{
	uint32_t _ptr_netbios_name;
	uint32_t size_netbios_name_1 = 0;
	uint32_t length_netbios_name_1 = 0;
	TALLOC_CTX *_mem_save_netbios_name_0 = NULL;
	uint32_t _ptr_dns_name;
	uint32_t size_dns_name_1 = 0;
	uint32_t length_dns_name_1 = 0;
	TALLOC_CTX *_mem_save_dns_name_0 = NULL;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	TALLOC_CTX *_mem_save_site_name_0 = NULL;
	uint32_t _ptr_site_dn;
	uint32_t size_site_dn_1 = 0;
	uint32_t length_site_dn_1 = 0;
	TALLOC_CTX *_mem_save_site_dn_0 = NULL;
	uint32_t _ptr_computer_dn;
	uint32_t size_computer_dn_1 = 0;
	uint32_t length_computer_dn_1 = 0;
	TALLOC_CTX *_mem_save_computer_dn_0 = NULL;
	uint32_t _ptr_server_dn;
	uint32_t size_server_dn_1 = 0;
	uint32_t length_server_dn_1 = 0;
	TALLOC_CTX *_mem_save_server_dn_0 = NULL;
	uint32_t _ptr_ntds_dn;
	uint32_t size_ntds_dn_1 = 0;
	uint32_t length_ntds_dn_1 = 0;
	TALLOC_CTX *_mem_save_ntds_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_name));
		if (_ptr_netbios_name) {
			NDR_PULL_ALLOC(ndr, r->netbios_name);
		} else {
			r->netbios_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_name));
		if (_ptr_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dns_name);
		} else {
			r->dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->site_name);
		} else {
			r->site_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_dn));
		if (_ptr_site_dn) {
			NDR_PULL_ALLOC(ndr, r->site_dn);
		} else {
			r->site_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_dn));
		if (_ptr_computer_dn) {
			NDR_PULL_ALLOC(ndr, r->computer_dn);
		} else {
			r->computer_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ntds_dn));
		if (_ptr_ntds_dn) {
			NDR_PULL_ALLOC(ndr, r->ntds_dn);
		} else {
			r->ntds_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_pdc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_enabled));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_gc));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->computer_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->server_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->ntds_guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			_mem_save_netbios_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->netbios_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->netbios_name, &size_netbios_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->netbios_name, &length_netbios_name_1));
			if (length_netbios_name_1 > size_netbios_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_netbios_name_1, length_netbios_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_netbios_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->netbios_name, length_netbios_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_name_0, 0);
		}
		if (r->dns_name) {
			_mem_save_dns_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dns_name, &size_dns_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dns_name, &length_dns_name_1));
			if (length_dns_name_1 > size_dns_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dns_name_1, length_dns_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_name, length_dns_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_name_0, 0);
		}
		if (r->site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_name, &size_site_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_name, &length_site_name_1));
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		if (r->site_dn) {
			_mem_save_site_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_dn, &size_site_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_dn, &length_site_dn_1));
			if (length_site_dn_1 > size_site_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_dn_1, length_site_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_dn, length_site_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_dn_0, 0);
		}
		if (r->computer_dn) {
			_mem_save_computer_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->computer_dn, &size_computer_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->computer_dn, &length_computer_dn_1));
			if (length_computer_dn_1 > size_computer_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_computer_dn_1, length_computer_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_dn, length_computer_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_dn_0, 0);
		}
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->server_dn, &size_server_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->server_dn, &length_server_dn_1));
			if (length_server_dn_1 > size_server_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_server_dn_1, length_server_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, length_server_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
		if (r->ntds_dn) {
			_mem_save_ntds_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ntds_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ntds_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->ntds_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->ntds_dn, &size_ntds_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->ntds_dn, &length_ntds_dn_1));
			if (length_ntds_dn_1 > size_ntds_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ntds_dn_1, length_ntds_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ntds_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ntds_dn, length_ntds_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ntds_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfo2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfo2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfo2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "netbios_name", r->netbios_name);
	ndr->depth++;
	if (r->netbios_name) {
		ndr_print_string(ndr, "netbios_name", r->netbios_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_name", r->dns_name);
	ndr->depth++;
	if (r->dns_name) {
		ndr_print_string(ndr, "dns_name", r->dns_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_name", r->site_name);
	ndr->depth++;
	if (r->site_name) {
		ndr_print_string(ndr, "site_name", r->site_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_dn", r->site_dn);
	ndr->depth++;
	if (r->site_dn) {
		ndr_print_string(ndr, "site_dn", r->site_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "computer_dn", r->computer_dn);
	ndr->depth++;
	if (r->computer_dn) {
		ndr_print_string(ndr, "computer_dn", r->computer_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "ntds_dn", r->ntds_dn);
	ndr->depth++;
	if (r->ntds_dn) {
		ndr_print_string(ndr, "ntds_dn", r->ntds_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "is_pdc", r->is_pdc);
	ndr_print_uint32(ndr, "is_enabled", r->is_enabled);
	ndr_print_uint32(ndr, "is_gc", r->is_gc);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_GUID(ndr, "computer_guid", &r->computer_guid);
	ndr_print_GUID(ndr, "server_guid", &r->server_guid);
	ndr_print_GUID(ndr, "ntds_guid", &r->ntds_guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoCtr2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfoCtr2 *r)
{
	uint32_t cntr_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoCtr2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfoCtr2 *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	TALLOC_CTX *_mem_save_array_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_1));
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo2(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo2(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoCtr2 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoCtr2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_drsuapi_DsGetDCInfo2(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfo3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfo3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->netbios_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->server_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->ntds_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_pdc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_enabled));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_gc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_rodc));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->computer_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->server_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->ntds_guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->netbios_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->netbios_name, ndr_charset_length(r->netbios_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dns_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_name, ndr_charset_length(r->dns_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_name, ndr_charset_length(r->site_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_dn, ndr_charset_length(r->site_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->computer_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_dn, ndr_charset_length(r->computer_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->server_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->server_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->server_dn, ndr_charset_length(r->server_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->ntds_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ntds_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->ntds_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->ntds_dn, ndr_charset_length(r->ntds_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfo3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfo3 *r)
{
	uint32_t _ptr_netbios_name;
	uint32_t size_netbios_name_1 = 0;
	uint32_t length_netbios_name_1 = 0;
	TALLOC_CTX *_mem_save_netbios_name_0 = NULL;
	uint32_t _ptr_dns_name;
	uint32_t size_dns_name_1 = 0;
	uint32_t length_dns_name_1 = 0;
	TALLOC_CTX *_mem_save_dns_name_0 = NULL;
	uint32_t _ptr_site_name;
	uint32_t size_site_name_1 = 0;
	uint32_t length_site_name_1 = 0;
	TALLOC_CTX *_mem_save_site_name_0 = NULL;
	uint32_t _ptr_site_dn;
	uint32_t size_site_dn_1 = 0;
	uint32_t length_site_dn_1 = 0;
	TALLOC_CTX *_mem_save_site_dn_0 = NULL;
	uint32_t _ptr_computer_dn;
	uint32_t size_computer_dn_1 = 0;
	uint32_t length_computer_dn_1 = 0;
	TALLOC_CTX *_mem_save_computer_dn_0 = NULL;
	uint32_t _ptr_server_dn;
	uint32_t size_server_dn_1 = 0;
	uint32_t length_server_dn_1 = 0;
	TALLOC_CTX *_mem_save_server_dn_0 = NULL;
	uint32_t _ptr_ntds_dn;
	uint32_t size_ntds_dn_1 = 0;
	uint32_t length_ntds_dn_1 = 0;
	TALLOC_CTX *_mem_save_ntds_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_netbios_name));
		if (_ptr_netbios_name) {
			NDR_PULL_ALLOC(ndr, r->netbios_name);
		} else {
			r->netbios_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_name));
		if (_ptr_dns_name) {
			NDR_PULL_ALLOC(ndr, r->dns_name);
		} else {
			r->dns_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_name));
		if (_ptr_site_name) {
			NDR_PULL_ALLOC(ndr, r->site_name);
		} else {
			r->site_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_dn));
		if (_ptr_site_dn) {
			NDR_PULL_ALLOC(ndr, r->site_dn);
		} else {
			r->site_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_dn));
		if (_ptr_computer_dn) {
			NDR_PULL_ALLOC(ndr, r->computer_dn);
		} else {
			r->computer_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_server_dn));
		if (_ptr_server_dn) {
			NDR_PULL_ALLOC(ndr, r->server_dn);
		} else {
			r->server_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ntds_dn));
		if (_ptr_ntds_dn) {
			NDR_PULL_ALLOC(ndr, r->ntds_dn);
		} else {
			r->ntds_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_pdc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_enabled));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_gc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_rodc));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->site_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->computer_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->server_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->ntds_guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->netbios_name) {
			_mem_save_netbios_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->netbios_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->netbios_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->netbios_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->netbios_name, &size_netbios_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->netbios_name, &length_netbios_name_1));
			if (length_netbios_name_1 > size_netbios_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_netbios_name_1, length_netbios_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_netbios_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->netbios_name, length_netbios_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netbios_name_0, 0);
		}
		if (r->dns_name) {
			_mem_save_dns_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dns_name, &size_dns_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dns_name, &length_dns_name_1));
			if (length_dns_name_1 > size_dns_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dns_name_1, length_dns_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_name, length_dns_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_name_0, 0);
		}
		if (r->site_name) {
			_mem_save_site_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_name, &size_site_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_name, &length_site_name_1));
			if (length_site_name_1 > size_site_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_name_1, length_site_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_name, length_site_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_name_0, 0);
		}
		if (r->site_dn) {
			_mem_save_site_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_dn, &size_site_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_dn, &length_site_dn_1));
			if (length_site_dn_1 > size_site_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_dn_1, length_site_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_dn, length_site_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_dn_0, 0);
		}
		if (r->computer_dn) {
			_mem_save_computer_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->computer_dn, &size_computer_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->computer_dn, &length_computer_dn_1));
			if (length_computer_dn_1 > size_computer_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_computer_dn_1, length_computer_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_dn, length_computer_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_dn_0, 0);
		}
		if (r->server_dn) {
			_mem_save_server_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->server_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->server_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->server_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->server_dn, &size_server_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->server_dn, &length_server_dn_1));
			if (length_server_dn_1 > size_server_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_server_dn_1, length_server_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_server_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->server_dn, length_server_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_dn_0, 0);
		}
		if (r->ntds_dn) {
			_mem_save_ntds_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->ntds_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->ntds_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->ntds_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->ntds_dn, &size_ntds_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->ntds_dn, &length_ntds_dn_1));
			if (length_ntds_dn_1 > size_ntds_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ntds_dn_1, length_ntds_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ntds_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->ntds_dn, length_ntds_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ntds_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfo3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfo3 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfo3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "netbios_name", r->netbios_name);
	ndr->depth++;
	if (r->netbios_name) {
		ndr_print_string(ndr, "netbios_name", r->netbios_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_name", r->dns_name);
	ndr->depth++;
	if (r->dns_name) {
		ndr_print_string(ndr, "dns_name", r->dns_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_name", r->site_name);
	ndr->depth++;
	if (r->site_name) {
		ndr_print_string(ndr, "site_name", r->site_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "site_dn", r->site_dn);
	ndr->depth++;
	if (r->site_dn) {
		ndr_print_string(ndr, "site_dn", r->site_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "computer_dn", r->computer_dn);
	ndr->depth++;
	if (r->computer_dn) {
		ndr_print_string(ndr, "computer_dn", r->computer_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "server_dn", r->server_dn);
	ndr->depth++;
	if (r->server_dn) {
		ndr_print_string(ndr, "server_dn", r->server_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "ntds_dn", r->ntds_dn);
	ndr->depth++;
	if (r->ntds_dn) {
		ndr_print_string(ndr, "ntds_dn", r->ntds_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "is_pdc", r->is_pdc);
	ndr_print_uint32(ndr, "is_enabled", r->is_enabled);
	ndr_print_uint32(ndr, "is_gc", r->is_gc);
	ndr_print_uint32(ndr, "is_rodc", r->is_rodc);
	ndr_print_GUID(ndr, "site_guid", &r->site_guid);
	ndr_print_GUID(ndr, "computer_guid", &r->computer_guid);
	ndr_print_GUID(ndr, "server_guid", &r->server_guid);
	ndr_print_GUID(ndr, "ntds_guid", &r->ntds_guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoCtr3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCInfoCtr3 *r)
{
	uint32_t cntr_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo3(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfo3(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoCtr3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCInfoCtr3 *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	TALLOC_CTX *_mem_save_array_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_1));
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo3(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfo3(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCInfoCtr3 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCInfoCtr3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_drsuapi_DsGetDCInfo3(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCConnection01(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCConnection01 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->connection_time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unknown6));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_account));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client_account) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_account, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->client_account, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->client_account, ndr_charset_length(r->client_account, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCConnection01(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCConnection01 *r)
{
	uint32_t _ptr_client_account;
	uint32_t size_client_account_1 = 0;
	uint32_t length_client_account_1 = 0;
	TALLOC_CTX *_mem_save_client_account_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->connection_time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unknown6));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_account));
		if (_ptr_client_account) {
			NDR_PULL_ALLOC(ndr, r->client_account);
		} else {
			r->client_account = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->client_account) {
			_mem_save_client_account_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_account, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->client_account));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->client_account));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->client_account, &size_client_account_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->client_account, &length_client_account_1));
			if (length_client_account_1 > size_client_account_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_account_1, length_client_account_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_client_account_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->client_account, length_client_account_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_account_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCConnection01(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCConnection01 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCConnection01");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_ipv4address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv4address(ndr, "client_ip_address", r->client_ip_address);
		ndr->flags = _flags_save_ipv4address;
	}
	ndr_print_uint32(ndr, "unknown2", r->unknown2);
	ndr_print_uint32(ndr, "connection_time", r->connection_time);
	ndr_print_uint32(ndr, "unknown4", r->unknown4);
	ndr_print_uint32(ndr, "unknown5", r->unknown5);
	ndr_print_uint32(ndr, "unknown6", r->unknown6);
	ndr_print_ptr(ndr, "client_account", r->client_account);
	ndr->depth++;
	if (r->client_account) {
		ndr_print_string(ndr, "client_account", r->client_account);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCConnectionCtr01(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	uint32_t cntr_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnection01(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnection01(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCConnectionCtr01(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	uint32_t _ptr_array;
	uint32_t size_array_1 = 0;
	uint32_t cntr_array_1;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	TALLOC_CTX *_mem_save_array_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_array));
		if (_ptr_array) {
			NDR_PULL_ALLOC(ndr, r->array);
		} else {
			r->array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->array) {
			_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_1));
			NDR_PULL_ALLOC_N(ndr, r->array, size_array_1);
			_mem_save_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnection01(ndr, NDR_SCALARS, &r->array[cntr_array_1]));
			}
			for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnection01(ndr, NDR_BUFFERS, &r->array[cntr_array_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		}
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		for (cntr_array_1 = 0; cntr_array_1 < (size_array_1); cntr_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCConnectionCtr01(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetDCConnectionCtr01 *r)
{
	uint32_t cntr_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetDCConnectionCtr01");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "array", r->array);
	ndr->depth++;
	if (r->array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_array_1 = 0; cntr_array_1 < (r->count); cntr_array_1++) {
			ndr_print_drsuapi_DsGetDCConnection01(ndr, "array", &r->array[cntr_array_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDCInfoCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetDCInfoCtr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtrLevels(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case DRSUAPI_DC_INFO_CTR_2: {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case DRSUAPI_DC_INFO_CTR_3: {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr3(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			case DRSUAPI_DC_CONNECTION_CTR_01: {
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_SCALARS, &r->ctr01));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case DRSUAPI_DC_INFO_CTR_2:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case DRSUAPI_DC_INFO_CTR_3:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr3(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			case DRSUAPI_DC_CONNECTION_CTR_01:
				NDR_CHECK(ndr_push_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_BUFFERS, &r->ctr01));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDCInfoCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetDCInfoCtr *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			case DRSUAPI_DC_INFO_CTR_2: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case DRSUAPI_DC_INFO_CTR_3: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr3(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			case DRSUAPI_DC_CONNECTION_CTR_01: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_SCALARS, &r->ctr01));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DRSUAPI_DC_INFO_CTR_1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			case DRSUAPI_DC_INFO_CTR_2:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case DRSUAPI_DC_INFO_CTR_3:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr3(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			case DRSUAPI_DC_CONNECTION_CTR_01:
				NDR_CHECK(ndr_pull_drsuapi_DsGetDCConnectionCtr01(ndr, NDR_BUFFERS, &r->ctr01));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDCInfoCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetDCInfoCtr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetDCInfoCtr");
	switch (level) {
		case DRSUAPI_DC_INFO_CTR_1:
			ndr_print_drsuapi_DsGetDCInfoCtr1(ndr, "ctr1", &r->ctr1);
		break;

		case DRSUAPI_DC_INFO_CTR_2:
			ndr_print_drsuapi_DsGetDCInfoCtr2(ndr, "ctr2", &r->ctr2);
		break;

		case DRSUAPI_DC_INFO_CTR_3:
			ndr_print_drsuapi_DsGetDCInfoCtr3(ndr, "ctr3", &r->ctr3);
		break;

		case DRSUAPI_DC_CONNECTION_CTR_01:
			ndr_print_drsuapi_DsGetDCConnectionCtr01(ndr, "ctr01", &r->ctr01);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectListItem(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjectListItem *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next_object));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectListItem(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjectListItem *r)
{
	uint32_t _ptr_next_object;
	TALLOC_CTX *_mem_save_next_object_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next_object));
		if (_ptr_next_object) {
			NDR_PULL_ALLOC(ndr, r->next_object);
		} else {
			r->next_object = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_SCALARS, &r->object));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next_object) {
			_mem_save_next_object_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next_object, 0);
			NDR_RECURSION_CHECK(ndr, 20000);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS|NDR_BUFFERS, r->next_object));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_object_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObject(ndr, NDR_BUFFERS, &r->object));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_drsuapi_DsReplicaObjectListItem(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct drsuapi_DsReplicaObjectListItem *r)
{
	ndr_print_drsuapi_DsReplicaObjectListItem(ndr, name, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_DirErr(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAddEntry_DirErr r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_DirErr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAddEntry_DirErr *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_DirErr(struct ndr_print *ndr, const char *name, enum drsuapi_DsAddEntry_DirErr r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DIRERR_OK: val = "DRSUAPI_DIRERR_OK"; break;
		case DRSUAPI_DIRERR_ATTRIBUTE: val = "DRSUAPI_DIRERR_ATTRIBUTE"; break;
		case DRSUAPI_DIRERR_NAME: val = "DRSUAPI_DIRERR_NAME"; break;
		case DRSUAPI_DIRERR_REFERRAL: val = "DRSUAPI_DIRERR_REFERRAL"; break;
		case DRSUAPI_DIRERR_SECURITY: val = "DRSUAPI_DIRERR_SECURITY"; break;
		case DRSUAPI_DIRERR_SERVICE: val = "DRSUAPI_DIRERR_SERVICE"; break;
		case DRSUAPI_DIRERR_UPDATE: val = "DRSUAPI_DIRERR_UPDATE"; break;
		case DRSUAPI_DIRERR_SYSTEM: val = "DRSUAPI_DIRERR_SYSTEM"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryRequest2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryRequest2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS, &r->first_object));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_BUFFERS, &r->first_object));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryRequest2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryRequest2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS, &r->first_object));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_BUFFERS, &r->first_object));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryRequest2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryRequest2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryRequest2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectListItem(ndr, "first_object", &r->first_object);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_SecBufferType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_SecBufferType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_SecBufferType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_SecBufferType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_drsuapi_SecBuffer(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_SecBuffer *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buf_size));
		NDR_CHECK(ndr_push_drsuapi_SecBufferType(ndr, NDR_SCALARS, r->buf_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buffer));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->buf_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->buffer, r->buf_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_SecBuffer(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_SecBuffer *r)
{
	uint32_t _ptr_buffer;
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_buffer_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buf_size));
		if (r->buf_size > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->buf_size), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_drsuapi_SecBufferType(ndr, NDR_SCALARS, &r->buf_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffer));
		if (_ptr_buffer) {
			NDR_PULL_ALLOC(ndr, r->buffer);
		} else {
			r->buffer = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffer) {
			_mem_save_buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buffer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->buffer));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->buffer, &size_buffer_1));
			NDR_PULL_ALLOC_N(ndr, r->buffer, size_buffer_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->buffer, size_buffer_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_0, 0);
		}
		if (r->buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->buffer, r->buf_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_SecBuffer(struct ndr_print *ndr, const char *name, const struct drsuapi_SecBuffer *r)
{
	ndr_print_struct(ndr, name, "drsuapi_SecBuffer");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "buf_size", r->buf_size);
	ndr_print_drsuapi_SecBufferType(ndr, "buf_type", r->buf_type);
	ndr_print_ptr(ndr, "buffer", r->buffer);
	ndr->depth++;
	if (r->buffer) {
		ndr_print_array_uint8(ndr, "buffer", r->buffer, r->buf_size);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_SecBufferDesc(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_SecBufferDesc *r)
{
	uint32_t cntr_buffers_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->buff_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->buffers));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffers) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->buff_count));
			for (cntr_buffers_1 = 0; cntr_buffers_1 < (r->buff_count); cntr_buffers_1++) {
				NDR_CHECK(ndr_push_drsuapi_SecBuffer(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_1]));
			}
			for (cntr_buffers_1 = 0; cntr_buffers_1 < (r->buff_count); cntr_buffers_1++) {
				NDR_CHECK(ndr_push_drsuapi_SecBuffer(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_SecBufferDesc(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_SecBufferDesc *r)
{
	uint32_t _ptr_buffers;
	uint32_t size_buffers_1 = 0;
	uint32_t cntr_buffers_1;
	TALLOC_CTX *_mem_save_buffers_0 = NULL;
	TALLOC_CTX *_mem_save_buffers_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->buff_count));
		if (r->buff_count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->buff_count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_buffers));
		if (_ptr_buffers) {
			NDR_PULL_ALLOC(ndr, r->buffers);
		} else {
			r->buffers = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->buffers) {
			_mem_save_buffers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->buffers));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->buffers, &size_buffers_1));
			NDR_PULL_ALLOC_N(ndr, r->buffers, size_buffers_1);
			_mem_save_buffers_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->buffers, 0);
			for (cntr_buffers_1 = 0; cntr_buffers_1 < (size_buffers_1); cntr_buffers_1++) {
				NDR_CHECK(ndr_pull_drsuapi_SecBuffer(ndr, NDR_SCALARS, &r->buffers[cntr_buffers_1]));
			}
			for (cntr_buffers_1 = 0; cntr_buffers_1 < (size_buffers_1); cntr_buffers_1++) {
				NDR_CHECK(ndr_pull_drsuapi_SecBuffer(ndr, NDR_BUFFERS, &r->buffers[cntr_buffers_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffers_0, 0);
		}
		if (r->buffers) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->buffers, r->buff_count));
		}
		for (cntr_buffers_1 = 0; cntr_buffers_1 < (size_buffers_1); cntr_buffers_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_SecBufferDesc(struct ndr_print *ndr, const char *name, const struct drsuapi_SecBufferDesc *r)
{
	uint32_t cntr_buffers_1;
	ndr_print_struct(ndr, name, "drsuapi_SecBufferDesc");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->version);
	ndr_print_uint32(ndr, "buff_count", r->buff_count);
	ndr_print_ptr(ndr, "buffers", r->buffers);
	ndr->depth++;
	if (r->buffers) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "buffers", (uint32_t)(r->buff_count));
		ndr->depth++;
		for (cntr_buffers_1 = 0; cntr_buffers_1 < (r->buff_count); cntr_buffers_1++) {
			ndr_print_drsuapi_SecBuffer(ndr, "buffers", &r->buffers[cntr_buffers_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryRequest3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryRequest3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS, &r->first_object));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->client_creds));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectListItem(ndr, NDR_BUFFERS, &r->first_object));
		if (r->client_creds) {
			NDR_CHECK(ndr_push_drsuapi_SecBufferDesc(ndr, NDR_SCALARS|NDR_BUFFERS, r->client_creds));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryRequest3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryRequest3 *r)
{
	uint32_t _ptr_client_creds;
	TALLOC_CTX *_mem_save_client_creds_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_SCALARS, &r->first_object));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_creds));
		if (_ptr_client_creds) {
			NDR_PULL_ALLOC(ndr, r->client_creds);
		} else {
			r->client_creds = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectListItem(ndr, NDR_BUFFERS, &r->first_object));
		if (r->client_creds) {
			_mem_save_client_creds_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->client_creds, 0);
			NDR_CHECK(ndr_pull_drsuapi_SecBufferDesc(ndr, NDR_SCALARS|NDR_BUFFERS, r->client_creds));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_creds_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryRequest3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryRequest3 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryRequest3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaObjectListItem(ndr, "first_object", &r->first_object);
	ndr_print_ptr(ndr, "client_creds", r->client_creds);
	ndr->depth++;
	if (r->client_creds) {
		ndr_print_drsuapi_SecBufferDesc(ndr, "client_creds", r->client_creds);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsAddEntryRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest3(ndr, NDR_SCALARS, &r->req3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			case 3:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest3(ndr, NDR_BUFFERS, &r->req3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsAddEntryRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest3(ndr, NDR_SCALARS, &r->req3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest3(ndr, NDR_BUFFERS, &r->req3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryRequest");
	switch (level) {
		case 2:
			ndr_print_drsuapi_DsAddEntryRequest2(ndr, "req2", &r->req2);
		break;

		case 3:
			ndr_print_drsuapi_DsAddEntryRequest3(ndr, "req3", &r->req3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryErrorInfoX(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryErrorInfoX *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dsid));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->extended_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->extended_data));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->problem));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryErrorInfoX(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryErrorInfoX *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dsid));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->extended_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->extended_data));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->problem));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfoX(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorInfoX *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorInfoX");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dsid", r->dsid);
	ndr_print_WERROR(ndr, "extended_err", r->extended_err);
	ndr_print_uint32(ndr, "extended_data", r->extended_data);
	ndr_print_uint16(ndr, "problem", r->problem);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_AttrErr_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntry_AttrErr_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dsid));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->extended_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->extended_data));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->problem));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeId(ndr, NDR_SCALARS, r->attid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_val_returned));
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->attr_val));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->attr_val));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_AttrErr_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntry_AttrErr_V1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dsid));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->extended_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->extended_data));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->problem));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeId(ndr, NDR_SCALARS, &r->attid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_val_returned));
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_SCALARS, &r->attr_val));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsAttributeValue(ndr, NDR_BUFFERS, &r->attr_val));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_AttrErr_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntry_AttrErr_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntry_AttrErr_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dsid", r->dsid);
	ndr_print_WERROR(ndr, "extended_err", r->extended_err);
	ndr_print_uint32(ndr, "extended_data", r->extended_data);
	ndr_print_uint16(ndr, "problem", r->problem);
	ndr_print_drsuapi_DsAttributeId(ndr, "attid", r->attid);
	ndr_print_uint32(ndr, "is_val_returned", r->is_val_returned);
	ndr_print_drsuapi_DsAttributeValue(ndr, "attr_val", &r->attr_val);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_AttrErrListItem_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntry_AttrErrListItem_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_AttrErr_V1(ndr, NDR_SCALARS, &r->err_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next) {
			NDR_CHECK(ndr_push_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
		}
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_AttrErr_V1(ndr, NDR_BUFFERS, &r->err_data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_AttrErrListItem_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntry_AttrErrListItem_V1 *r)
{
	uint32_t _ptr_next;
	TALLOC_CTX *_mem_save_next_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next));
		if (_ptr_next) {
			NDR_PULL_ALLOC(ndr, r->next);
		} else {
			r->next = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_AttrErr_V1(ndr, NDR_SCALARS, &r->err_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next) {
			_mem_save_next_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next, 0);
			NDR_RECURSION_CHECK(ndr, 20000);
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_AttrErr_V1(ndr, NDR_BUFFERS, &r->err_data));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryErrorInfo_Attr_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, NDR_SCALARS, &r->first));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
		}
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, NDR_BUFFERS, &r->first));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryErrorInfo_Attr_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, NDR_SCALARS, &r->first));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, NDR_BUFFERS, &r->first));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfo_Attr_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorInfo_Attr_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorInfo_Attr_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_drsuapi_DsAddEntry_AttrErrListItem_V1(ndr, "first", &r->first);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryErrorInfo_Name_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryErrorInfo_Name_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dsid));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->extended_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->extended_data));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->problem));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id_matched));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id_matched) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id_matched));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryErrorInfo_Name_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryErrorInfo_Name_V1 *r)
{
	uint32_t _ptr_id_matched;
	TALLOC_CTX *_mem_save_id_matched_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dsid));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->extended_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->extended_data));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->problem));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id_matched));
		if (_ptr_id_matched) {
			NDR_PULL_ALLOC(ndr, r->id_matched);
		} else {
			r->id_matched = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id_matched) {
			_mem_save_id_matched_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id_matched, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id_matched));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_matched_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfo_Name_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorInfo_Name_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorInfo_Name_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dsid", r->dsid);
	ndr_print_WERROR(ndr, "extended_err", r->extended_err);
	ndr_print_uint32(ndr, "extended_data", r->extended_data);
	ndr_print_uint16(ndr, "problem", r->problem);
	ndr_print_ptr(ndr, "id_matched", r->id_matched);
	ndr->depth++;
	if (r->id_matched) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id_matched", r->id_matched);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_NameResOp_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_NameResOp_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 83));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_NameResOp_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_NameResOp_V1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->name_res));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->unused_pad));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->next_rdn));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_NameResOp_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_NameResOp_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_NameResOp_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "name_res", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?83:r->name_res);
	ndr_print_uint8(ndr, "unused_pad", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->unused_pad);
	ndr_print_uint16(ndr, "next_rdn", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->next_rdn);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_RefType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAddEntry_RefType r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_RefType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAddEntry_RefType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_RefType(struct ndr_print *ndr, const char *name, enum drsuapi_DsAddEntry_RefType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_CH_REFTYPE_SUPERIOR: val = "DRSUAPI_CH_REFTYPE_SUPERIOR"; break;
		case DRSUAPI_CH_REFTYPE_SUBORDINATE: val = "DRSUAPI_CH_REFTYPE_SUBORDINATE"; break;
		case DRSUAPI_CH_REFTYPE_NSSR: val = "DRSUAPI_CH_REFTYPE_NSSR"; break;
		case DRSUAPI_CH_REFTYPE_CROSS: val = "DRSUAPI_CH_REFTYPE_CROSS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_ChoiceType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAddEntry_ChoiceType r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_ChoiceType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsAddEntry_ChoiceType *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_ChoiceType(struct ndr_print *ndr, const char *name, enum drsuapi_DsAddEntry_ChoiceType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_SE_CHOICE_BASE_ONLY: val = "DRSUAPI_SE_CHOICE_BASE_ONLY"; break;
		case DRSUAPI_SE_CHOICE_IMMED_CHLDRN: val = "DRSUAPI_SE_CHOICE_IMMED_CHLDRN"; break;
		case DRSUAPI_SE_CHOICE_WHOLE_SUBTREE: val = "DRSUAPI_SE_CHOICE_WHOLE_SUBTREE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsaAddressListItem_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsaAddressListItem_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->address));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next) {
			NDR_CHECK(ndr_push_drsuapi_DsaAddressListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
		}
		if (r->address) {
			NDR_CHECK(ndr_push_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->address));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsaAddressListItem_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsaAddressListItem_V1 *r)
{
	uint32_t _ptr_next;
	TALLOC_CTX *_mem_save_next_0 = NULL;
	uint32_t _ptr_address;
	TALLOC_CTX *_mem_save_address_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next));
		if (_ptr_next) {
			NDR_PULL_ALLOC(ndr, r->next);
		} else {
			r->next = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_address));
		if (_ptr_address) {
			NDR_PULL_ALLOC(ndr, r->address);
		} else {
			r->address = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->next) {
			_mem_save_next_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next, 0);
			NDR_RECURSION_CHECK(ndr, 1024);
			NDR_CHECK(ndr_pull_drsuapi_DsaAddressListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_0, 0);
		}
		if (r->address) {
			_mem_save_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->address, 0);
			NDR_CHECK(ndr_pull_lsa_String(ndr, NDR_SCALARS|NDR_BUFFERS, r->address));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_address_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsaAddressListItem_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsaAddressListItem_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsaAddressListItem_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "next", r->next);
	ndr->depth++;
	if (r->next) {
		ndr_print_drsuapi_DsaAddressListItem_V1(ndr, "next", r->next);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "address", r->address);
	ndr->depth++;
	if (r->address) {
		ndr_print_lsa_String(ndr, "address", r->address);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_RefErrListItem_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntry_RefErrListItem_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id_target));
		NDR_CHECK(ndr_push_drsuapi_NameResOp_V1(ndr, NDR_SCALARS, &r->op_state));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_RefType(ndr, NDR_SCALARS, r->ref_type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->addr_list_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->addr_list));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->next));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_choice_set));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_ChoiceType(ndr, NDR_SCALARS, r->choice));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id_target) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id_target));
		}
		if (r->addr_list) {
			NDR_CHECK(ndr_push_drsuapi_DsaAddressListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->addr_list));
		}
		if (r->next) {
			NDR_CHECK(ndr_push_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_RefErrListItem_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntry_RefErrListItem_V1 *r)
{
	uint32_t _ptr_id_target;
	TALLOC_CTX *_mem_save_id_target_0 = NULL;
	uint32_t _ptr_addr_list;
	TALLOC_CTX *_mem_save_addr_list_0 = NULL;
	uint32_t _ptr_next;
	TALLOC_CTX *_mem_save_next_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id_target));
		if (_ptr_id_target) {
			NDR_PULL_ALLOC(ndr, r->id_target);
		} else {
			r->id_target = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_NameResOp_V1(ndr, NDR_SCALARS, &r->op_state));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->rdn_alias));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->rdn_internal));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_RefType(ndr, NDR_SCALARS, &r->ref_type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->addr_list_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_addr_list));
		if (_ptr_addr_list) {
			NDR_PULL_ALLOC(ndr, r->addr_list);
		} else {
			r->addr_list = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_next));
		if (_ptr_next) {
			NDR_PULL_ALLOC(ndr, r->next);
		} else {
			r->next = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_choice_set));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_ChoiceType(ndr, NDR_SCALARS, &r->choice));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id_target) {
			_mem_save_id_target_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id_target, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id_target));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_target_0, 0);
		}
		if (r->addr_list) {
			_mem_save_addr_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addr_list, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsaAddressListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->addr_list));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addr_list_0, 0);
		}
		if (r->next) {
			_mem_save_next_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->next, 0);
			NDR_RECURSION_CHECK(ndr, 20000);
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, NDR_SCALARS|NDR_BUFFERS, r->next));
			NDR_RECURSION_UNWIND(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_next_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_RefErrListItem_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntry_RefErrListItem_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntry_RefErrListItem_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "id_target", r->id_target);
	ndr->depth++;
	if (r->id_target) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id_target", r->id_target);
	}
	ndr->depth--;
	ndr_print_drsuapi_NameResOp_V1(ndr, "op_state", &r->op_state);
	ndr_print_uint16(ndr, "rdn_alias", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->rdn_alias);
	ndr_print_uint16(ndr, "rdn_internal", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->rdn_internal);
	ndr_print_drsuapi_DsAddEntry_RefType(ndr, "ref_type", r->ref_type);
	ndr_print_uint16(ndr, "addr_list_count", r->addr_list_count);
	ndr_print_ptr(ndr, "addr_list", r->addr_list);
	ndr->depth++;
	if (r->addr_list) {
		ndr_print_drsuapi_DsaAddressListItem_V1(ndr, "addr_list", r->addr_list);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "next", r->next);
	ndr->depth++;
	if (r->next) {
		ndr_print_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, "next", r->next);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "is_choice_set", r->is_choice_set);
	ndr_print_drsuapi_DsAddEntry_ChoiceType(ndr, "choice", r->choice);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryErrorInfo_Referr_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dsid));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->extended_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->extended_data));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, NDR_SCALARS, &r->refer));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, NDR_BUFFERS, &r->refer));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryErrorInfo_Referr_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dsid));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->extended_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->extended_data));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, NDR_SCALARS, &r->refer));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, NDR_BUFFERS, &r->refer));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfo_Referr_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryErrorInfo_Referr_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryErrorInfo_Referr_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dsid", r->dsid);
	ndr_print_WERROR(ndr, "extended_err", r->extended_err);
	ndr_print_uint32(ndr, "extended_data", r->extended_data);
	ndr_print_drsuapi_DsAddEntry_RefErrListItem_V1(ndr, "refer", &r->refer);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryErrorInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsAddEntryErrorInfo *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo_Attr_V1(ndr, NDR_SCALARS, &r->attr_err));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo_Name_V1(ndr, NDR_SCALARS, &r->name_err));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo_Referr_V1(ndr, NDR_SCALARS, &r->referral_err));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->security_err));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->service_err));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->update_err));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->system_err));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo_Attr_V1(ndr, NDR_BUFFERS, &r->attr_err));
			break;

			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo_Name_V1(ndr, NDR_BUFFERS, &r->name_err));
			break;

			case 3:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo_Referr_V1(ndr, NDR_BUFFERS, &r->referral_err));
			break;

			case 4:
			break;

			case 5:
			break;

			case 6:
			break;

			case 7:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryErrorInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsAddEntryErrorInfo *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo_Attr_V1(ndr, NDR_SCALARS, &r->attr_err));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo_Name_V1(ndr, NDR_SCALARS, &r->name_err));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo_Referr_V1(ndr, NDR_SCALARS, &r->referral_err));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->security_err));
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->service_err));
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->update_err));
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfoX(ndr, NDR_SCALARS, &r->system_err));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo_Attr_V1(ndr, NDR_BUFFERS, &r->attr_err));
			break;

			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo_Name_V1(ndr, NDR_BUFFERS, &r->name_err));
			break;

			case 3:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo_Referr_V1(ndr, NDR_BUFFERS, &r->referral_err));
			break;

			case 4:
			break;

			case 5:
			break;

			case 6:
			break;

			case 7:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryErrorInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryErrorInfo *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryErrorInfo");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsAddEntryErrorInfo_Attr_V1(ndr, "attr_err", &r->attr_err);
		break;

		case 2:
			ndr_print_drsuapi_DsAddEntryErrorInfo_Name_V1(ndr, "name_err", &r->name_err);
		break;

		case 3:
			ndr_print_drsuapi_DsAddEntryErrorInfo_Referr_V1(ndr, "referral_err", &r->referral_err);
		break;

		case 4:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "security_err", &r->security_err);
		break;

		case 5:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "service_err", &r->service_err);
		break;

		case 6:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "update_err", &r->update_err);
		break;

		case 7:
			ndr_print_drsuapi_DsAddEntryErrorInfoX(ndr, "system_err", &r->system_err);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_ErrData_V1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntry_ErrData_V1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_DirErr(ndr, NDR_SCALARS, r->dir_err));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->info, r->dir_err));
			NDR_CHECK(ndr_push_drsuapi_DsAddEntryErrorInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_ErrData_V1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntry_ErrData_V1 *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_DirErr(ndr, NDR_SCALARS, &r->dir_err));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->info, r->dir_err));
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntryErrorInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_ErrData_V1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntry_ErrData_V1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntry_ErrData_V1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_WERROR(ndr, "status", r->status);
	ndr_print_drsuapi_DsAddEntry_DirErr(ndr, "dir_err", r->dir_err);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_set_switch_value(ndr, r->info, r->dir_err);
		ndr_print_drsuapi_DsAddEntryErrorInfo(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntry_ErrData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsAddEntry_ErrData *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntry_ErrData_V1(ndr, NDR_SCALARS, &r->v1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntry_ErrData_V1(ndr, NDR_BUFFERS, &r->v1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntry_ErrData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsAddEntry_ErrData *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_ErrData_V1(ndr, NDR_SCALARS, &r->v1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_ErrData_V1(ndr, NDR_BUFFERS, &r->v1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry_ErrData(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntry_ErrData *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntry_ErrData");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsAddEntry_ErrData_V1(ndr, "v1", &r->v1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaObjectIdentifier2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjectIdentifier2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->guid));
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->sid));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjectIdentifier2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjectIdentifier2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjectIdentifier2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "guid", &r->guid);
	ndr_print_dom_sid28(ndr, "sid", &r->sid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryCtr2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryCtr2 *r)
{
	uint32_t cntr_objects_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntry_DirErr(ndr, NDR_SCALARS, r->dir_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dsid));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->extended_err));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->extended_data));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->problem));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->objects));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
		}
		if (r->objects) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_objects_1 = 0; cntr_objects_1 < (r->count); cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < (r->count); cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryCtr2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryCtr2 *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0 = NULL;
	uint32_t _ptr_objects;
	uint32_t size_objects_1 = 0;
	uint32_t cntr_objects_1;
	TALLOC_CTX *_mem_save_objects_0 = NULL;
	TALLOC_CTX *_mem_save_objects_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_DirErr(ndr, NDR_SCALARS, &r->dir_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dsid));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->extended_err));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->extended_data));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->problem));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objects));
		if (_ptr_objects) {
			NDR_PULL_ALLOC(ndr, r->objects);
		} else {
			r->objects = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		if (r->objects) {
			_mem_save_objects_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->objects));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->objects, &size_objects_1));
			NDR_PULL_ALLOC_N(ndr, r->objects, size_objects_1);
			_mem_save_objects_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			for (cntr_objects_1 = 0; cntr_objects_1 < (size_objects_1); cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < (size_objects_1); cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_0, 0);
		}
		if (r->objects) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->objects, r->count));
		}
		for (cntr_objects_1 = 0; cntr_objects_1 < (size_objects_1); cntr_objects_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryCtr2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryCtr2 *r)
{
	uint32_t cntr_objects_1;
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryCtr2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_drsuapi_DsAddEntry_DirErr(ndr, "dir_err", r->dir_err);
	ndr_print_uint32(ndr, "dsid", r->dsid);
	ndr_print_WERROR(ndr, "extended_err", r->extended_err);
	ndr_print_uint32(ndr, "extended_data", r->extended_data);
	ndr_print_uint16(ndr, "problem", r->problem);
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "objects", r->objects);
	ndr->depth++;
	if (r->objects) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "objects", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_objects_1 = 0; cntr_objects_1 < (r->count); cntr_objects_1++) {
			ndr_print_drsuapi_DsReplicaObjectIdentifier2(ndr, "objects", &r->objects[cntr_objects_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryCtr3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsAddEntryCtr3 *r)
{
	uint32_t cntr_objects_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->err_ver));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->err_data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->objects));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
		}
		if (r->err_data) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, r->err_data, r->err_ver));
			NDR_CHECK(ndr_push_drsuapi_DsAddEntry_ErrData(ndr, NDR_SCALARS|NDR_BUFFERS, r->err_data));
		}
		if (r->objects) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
			for (cntr_objects_1 = 0; cntr_objects_1 < (r->count); cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < (r->count); cntr_objects_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryCtr3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsAddEntryCtr3 *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0 = NULL;
	uint32_t _ptr_err_data;
	TALLOC_CTX *_mem_save_err_data_0 = NULL;
	uint32_t _ptr_objects;
	uint32_t size_objects_1 = 0;
	uint32_t cntr_objects_1;
	TALLOC_CTX *_mem_save_objects_0 = NULL;
	TALLOC_CTX *_mem_save_objects_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->err_ver));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_err_data));
		if (_ptr_err_data) {
			NDR_PULL_ALLOC(ndr, r->err_data);
		} else {
			r->err_data = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objects));
		if (_ptr_objects) {
			NDR_PULL_ALLOC(ndr, r->objects);
		} else {
			r->objects = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier(ndr, NDR_SCALARS|NDR_BUFFERS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		if (r->err_data) {
			_mem_save_err_data_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->err_data, 0);
			NDR_CHECK(ndr_pull_set_switch_value(ndr, r->err_data, r->err_ver));
			NDR_CHECK(ndr_pull_drsuapi_DsAddEntry_ErrData(ndr, NDR_SCALARS|NDR_BUFFERS, r->err_data));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_err_data_0, 0);
		}
		if (r->objects) {
			_mem_save_objects_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->objects));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->objects, &size_objects_1));
			NDR_PULL_ALLOC_N(ndr, r->objects, size_objects_1);
			_mem_save_objects_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->objects, 0);
			for (cntr_objects_1 = 0; cntr_objects_1 < (size_objects_1); cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_SCALARS, &r->objects[cntr_objects_1]));
			}
			for (cntr_objects_1 = 0; cntr_objects_1 < (size_objects_1); cntr_objects_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjectIdentifier2(ndr, NDR_BUFFERS, &r->objects[cntr_objects_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objects_0, 0);
		}
		if (r->objects) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->objects, r->count));
		}
		for (cntr_objects_1 = 0; cntr_objects_1 < (size_objects_1); cntr_objects_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryCtr3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsAddEntryCtr3 *r)
{
	uint32_t cntr_objects_1;
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntryCtr3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_drsuapi_DsReplicaObjectIdentifier(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "err_ver", r->err_ver);
	ndr_print_ptr(ndr, "err_data", r->err_data);
	ndr->depth++;
	if (r->err_data) {
		ndr_print_set_switch_value(ndr, r->err_data, r->err_ver);
		ndr_print_drsuapi_DsAddEntry_ErrData(ndr, "err_data", r->err_data);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "objects", r->objects);
	ndr->depth++;
	if (r->objects) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "objects", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_objects_1 = 0; cntr_objects_1 < (r->count); cntr_objects_1++) {
			ndr_print_drsuapi_DsReplicaObjectIdentifier2(ndr, "objects", &r->objects[cntr_objects_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsAddEntryCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsAddEntryCtr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr3(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 2:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr3(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsAddEntryCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsAddEntryCtr *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 2: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr2(ndr, NDR_SCALARS, &r->ctr2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr3(ndr, NDR_SCALARS, &r->ctr3));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 2:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr2(ndr, NDR_BUFFERS, &r->ctr2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr3(ndr, NDR_BUFFERS, &r->ctr3));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntryCtr(struct ndr_print *ndr, const char *name, const union drsuapi_DsAddEntryCtr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsAddEntryCtr");
	switch (level) {
		case 2:
			ndr_print_drsuapi_DsAddEntryCtr2(ndr, "ctr2", &r->ctr2);
		break;

		case 3:
			ndr_print_drsuapi_DsAddEntryCtr3(ndr, "ctr3", &r->ctr3);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsExecuteKCCFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsExecuteKCCFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsExecuteKCCFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_EXECUTE_KCC_ASYNCHRONOUS_OPERATION", DRSUAPI_DS_EXECUTE_KCC_ASYNCHRONOUS_OPERATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DRSUAPI_DS_EXECUTE_KCC_DAMPED", DRSUAPI_DS_EXECUTE_KCC_DAMPED, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsExecuteKCC1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsExecuteKCC1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->taskID));
		NDR_CHECK(ndr_push_drsuapi_DsExecuteKCCFlags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsExecuteKCC1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsExecuteKCC1 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->taskID));
		NDR_CHECK(ndr_pull_drsuapi_DsExecuteKCCFlags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsExecuteKCC1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsExecuteKCC1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsExecuteKCC1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "taskID", r->taskID);
	ndr_print_drsuapi_DsExecuteKCCFlags(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsExecuteKCCRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsExecuteKCCRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsExecuteKCC1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsExecuteKCCRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsExecuteKCCRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsExecuteKCC1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsExecuteKCCRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsExecuteKCCRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsExecuteKCCRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsExecuteKCC1(ndr, "ctr1", &r->ctr1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaGetInfoLevel(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsReplicaGetInfoLevel r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaGetInfoLevel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsReplicaGetInfoLevel *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoLevel(struct ndr_print *ndr, const char *name, enum drsuapi_DsReplicaGetInfoLevel r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_REPLICA_GET_INFO: val = "DRSUAPI_DS_REPLICA_GET_INFO"; break;
		case DRSUAPI_DS_REPLICA_GET_INFO2: val = "DRSUAPI_DS_REPLICA_GET_INFO2"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaInfoType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsReplicaInfoType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaInfoType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsReplicaInfoType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaInfoType(struct ndr_print *ndr, const char *name, enum drsuapi_DsReplicaInfoType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS: val = "DRSUAPI_DS_REPLICA_INFO_NEIGHBORS"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS"; break;
		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA: val = "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA"; break;
		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES: val = "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES"; break;
		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES: val = "DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES"; break;
		case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS: val = "DRSUAPI_DS_REPLICA_INFO_PENDING_OPS"; break;
		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA: val = "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS2: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS2"; break;
		case DRSUAPI_DS_REPLICA_INFO_CURSORS3: val = "DRSUAPI_DS_REPLICA_INFO_CURSORS3"; break;
		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2: val = "DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2"; break;
		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2: val = "DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2"; break;
		case DRSUAPI_DS_REPLICA_INFO_REPSTO: val = "DRSUAPI_DS_REPLICA_INFO_REPSTO"; break;
		case DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS: val = "DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS"; break;
		case DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1: val = "DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1"; break;
		case DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS: val = "DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaGetInfoRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, r->info_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaGetInfoRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	uint32_t _ptr_object_dn;
	uint32_t size_object_dn_1 = 0;
	uint32_t length_object_dn_1 = 0;
	TALLOC_CTX *_mem_save_object_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, &r->info_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->object_dn, &size_object_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->object_dn, &length_object_dn_1));
			if (length_object_dn_1 > size_object_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_object_dn_1, length_object_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_object_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, length_object_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaGetInfoRequest1 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaGetInfoRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaInfoType(ndr, "info_type", r->info_type);
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaGetInfoRequest2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, r->info_type));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->value_dn_str));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumeration_context));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->value_dn_str) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->value_dn_str, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->value_dn_str, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->value_dn_str, ndr_charset_length(r->value_dn_str, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaGetInfoRequest2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	uint32_t _ptr_object_dn;
	uint32_t size_object_dn_1 = 0;
	uint32_t length_object_dn_1 = 0;
	TALLOC_CTX *_mem_save_object_dn_0 = NULL;
	uint32_t _ptr_attribute_name;
	uint32_t size_attribute_name_1 = 0;
	uint32_t length_attribute_name_1 = 0;
	TALLOC_CTX *_mem_save_attribute_name_0 = NULL;
	uint32_t _ptr_value_dn_str;
	uint32_t size_value_dn_str_1 = 0;
	uint32_t length_value_dn_str_1 = 0;
	TALLOC_CTX *_mem_save_value_dn_str_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, &r->info_type));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_value_dn_str));
		if (_ptr_value_dn_str) {
			NDR_PULL_ALLOC(ndr, r->value_dn_str);
		} else {
			r->value_dn_str = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->object_dn, &size_object_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->object_dn, &length_object_dn_1));
			if (length_object_dn_1 > size_object_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_object_dn_1, length_object_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_object_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, length_object_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->attribute_name, &size_attribute_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->attribute_name, &length_attribute_name_1));
			if (length_attribute_name_1 > size_attribute_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_attribute_name_1, length_attribute_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_attribute_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, length_attribute_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		if (r->value_dn_str) {
			_mem_save_value_dn_str_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->value_dn_str, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->value_dn_str));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->value_dn_str));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->value_dn_str, &size_value_dn_str_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->value_dn_str, &length_value_dn_str_1));
			if (length_value_dn_str_1 > size_value_dn_str_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_value_dn_str_1, length_value_dn_str_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_value_dn_str_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->value_dn_str, length_value_dn_str_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_value_dn_str_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoRequest2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaGetInfoRequest2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaGetInfoRequest2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_drsuapi_DsReplicaInfoType(ndr, "info_type", r->info_type);
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "source_dsa_guid", &r->source_dsa_guid);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "value_dn_str", r->value_dn_str);
	ndr->depth++;
	if (r->value_dn_str) {
		ndr_print_string(ndr, "value_dn_str", r->value_dn_str);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "enumeration_context", r->enumeration_context);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaGetInfoRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaGetInfoRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoLevel(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case DRSUAPI_DS_REPLICA_GET_INFO2: {
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case DRSUAPI_DS_REPLICA_GET_INFO2:
				NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaGetInfoRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaGetInfoRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			case DRSUAPI_DS_REPLICA_GET_INFO2: {
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_SCALARS, &r->req2));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_GET_INFO:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			case DRSUAPI_DS_REPLICA_GET_INFO2:
				NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest2(ndr, NDR_BUFFERS, &r->req2));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfoRequest(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaGetInfoRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaGetInfoRequest");
	switch (level) {
		case DRSUAPI_DS_REPLICA_GET_INFO:
			ndr_print_drsuapi_DsReplicaGetInfoRequest1(ndr, "req1", &r->req1);
		break;

		case DRSUAPI_DS_REPLICA_GET_INFO2:
			ndr_print_drsuapi_DsReplicaGetInfoRequest2(ndr, "req2", &r->req2);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaNeighbour(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaNeighbour *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->naming_context_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_obj_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_address));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->transport_obj_dn));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->replica_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->naming_context_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->transport_obj_guid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->tmp_highest_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_success));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_attempt));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->result_last_attempt));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->consecutive_sync_failures));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->naming_context_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->naming_context_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->naming_context_dn, ndr_charset_length(r->naming_context_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->source_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_obj_dn, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->source_dsa_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_address, ndr_charset_length(r->source_dsa_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->transport_obj_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->transport_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->transport_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->transport_obj_dn, ndr_charset_length(r->transport_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaNeighbour(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaNeighbour *r)
{
	uint32_t _ptr_naming_context_dn;
	uint32_t size_naming_context_dn_1 = 0;
	uint32_t length_naming_context_dn_1 = 0;
	TALLOC_CTX *_mem_save_naming_context_dn_0 = NULL;
	uint32_t _ptr_source_dsa_obj_dn;
	uint32_t size_source_dsa_obj_dn_1 = 0;
	uint32_t length_source_dsa_obj_dn_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_obj_dn_0 = NULL;
	uint32_t _ptr_source_dsa_address;
	uint32_t size_source_dsa_address_1 = 0;
	uint32_t length_source_dsa_address_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_address_0 = NULL;
	uint32_t _ptr_transport_obj_dn;
	uint32_t size_transport_obj_dn_1 = 0;
	uint32_t length_transport_obj_dn_1 = 0;
	TALLOC_CTX *_mem_save_transport_obj_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_naming_context_dn));
		if (_ptr_naming_context_dn) {
			NDR_PULL_ALLOC(ndr, r->naming_context_dn);
		} else {
			r->naming_context_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_obj_dn));
		if (_ptr_source_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_obj_dn);
		} else {
			r->source_dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_address));
		if (_ptr_source_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_address);
		} else {
			r->source_dsa_address = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_transport_obj_dn));
		if (_ptr_transport_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->transport_obj_dn);
		} else {
			r->transport_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->replica_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->naming_context_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->transport_obj_guid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->tmp_highest_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_success));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_attempt));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->result_last_attempt));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->consecutive_sync_failures));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->naming_context_dn) {
			_mem_save_naming_context_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->naming_context_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->naming_context_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->naming_context_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->naming_context_dn, &size_naming_context_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->naming_context_dn, &length_naming_context_dn_1));
			if (length_naming_context_dn_1 > size_naming_context_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_naming_context_dn_1, length_naming_context_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_naming_context_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->naming_context_dn, length_naming_context_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_naming_context_dn_0, 0);
		}
		if (r->source_dsa_obj_dn) {
			_mem_save_source_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_obj_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_obj_dn, &size_source_dsa_obj_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_obj_dn, &length_source_dsa_obj_dn_1));
			if (length_source_dsa_obj_dn_1 > size_source_dsa_obj_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_obj_dn_1, length_source_dsa_obj_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_obj_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_obj_dn, length_source_dsa_obj_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_obj_dn_0, 0);
		}
		if (r->source_dsa_address) {
			_mem_save_source_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_address, &size_source_dsa_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_address, &length_source_dsa_address_1));
			if (length_source_dsa_address_1 > size_source_dsa_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_address_1, length_source_dsa_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_address, length_source_dsa_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_address_0, 0);
		}
		if (r->transport_obj_dn) {
			_mem_save_transport_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->transport_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->transport_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->transport_obj_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->transport_obj_dn, &size_transport_obj_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->transport_obj_dn, &length_transport_obj_dn_1));
			if (length_transport_obj_dn_1 > size_transport_obj_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_transport_obj_dn_1, length_transport_obj_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_transport_obj_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->transport_obj_dn, length_transport_obj_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_transport_obj_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaNeighbour(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaNeighbour *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaNeighbour");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "naming_context_dn", r->naming_context_dn);
	ndr->depth++;
	if (r->naming_context_dn) {
		ndr_print_string(ndr, "naming_context_dn", r->naming_context_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	ndr->depth++;
	if (r->source_dsa_obj_dn) {
		ndr_print_string(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "source_dsa_address", r->source_dsa_address);
	ndr->depth++;
	if (r->source_dsa_address) {
		ndr_print_string(ndr, "source_dsa_address", r->source_dsa_address);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "transport_obj_dn", r->transport_obj_dn);
	ndr->depth++;
	if (r->transport_obj_dn) {
		ndr_print_string(ndr, "transport_obj_dn", r->transport_obj_dn);
	}
	ndr->depth--;
	ndr_print_drsuapi_DrsOptions(ndr, "replica_flags", r->replica_flags);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr_print_GUID(ndr, "naming_context_obj_guid", &r->naming_context_obj_guid);
	ndr_print_GUID(ndr, "source_dsa_obj_guid", &r->source_dsa_obj_guid);
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_GUID(ndr, "transport_obj_guid", &r->transport_obj_guid);
	ndr_print_hyper(ndr, "tmp_highest_usn", r->tmp_highest_usn);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr_print_NTTIME(ndr, "last_success", r->last_success);
	ndr_print_NTTIME(ndr, "last_attempt", r->last_attempt);
	ndr_print_WERROR(ndr, "result_last_attempt", r->result_last_attempt);
	ndr_print_uint32(ndr, "consecutive_sync_failures", r->consecutive_sync_failures);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaNeighbourCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaNeighbourCtr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbour(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbour(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaNeighbourCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaNeighbourCtr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbour(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbour(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaNeighbourCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaNeighbourCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaNeighbourCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaNeighbour(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaCursorCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursorCtr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursorCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursorCtr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursorCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursorCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursorCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaCursor(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaObjMetaData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjMetaData *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_change_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjMetaData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjMetaData *r)
{
	uint32_t _ptr_attribute_name;
	uint32_t size_attribute_name_1 = 0;
	uint32_t length_attribute_name_1 = 0;
	TALLOC_CTX *_mem_save_attribute_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_change_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->attribute_name, &size_attribute_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->attribute_name, &length_attribute_name_1));
			if (length_attribute_name_1 > size_attribute_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_attribute_name_1, length_attribute_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_attribute_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, length_attribute_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaData(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaData *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_change_time", r->originating_change_time);
	ndr_print_GUID(ndr, "originating_invocation_id", &r->originating_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaObjMetaDataCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjMetaDataCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaDataCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaDataCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaObjMetaData(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaKccDsaFailure(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaKccDsaFailure *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dsa_obj_dn));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->dsa_obj_guid));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->first_failure));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_failures));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->last_result));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dsa_obj_dn, ndr_charset_length(r->dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaKccDsaFailure(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaKccDsaFailure *r)
{
	uint32_t _ptr_dsa_obj_dn;
	uint32_t size_dsa_obj_dn_1 = 0;
	uint32_t length_dsa_obj_dn_1 = 0;
	TALLOC_CTX *_mem_save_dsa_obj_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dsa_obj_dn));
		if (_ptr_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->dsa_obj_dn);
		} else {
			r->dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->dsa_obj_guid));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->first_failure));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_failures));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->last_result));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->dsa_obj_dn) {
			_mem_save_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dsa_obj_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dsa_obj_dn, &size_dsa_obj_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dsa_obj_dn, &length_dsa_obj_dn_1));
			if (length_dsa_obj_dn_1 > size_dsa_obj_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dsa_obj_dn_1, length_dsa_obj_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dsa_obj_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dsa_obj_dn, length_dsa_obj_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dsa_obj_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaKccDsaFailure(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaKccDsaFailure *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaKccDsaFailure");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "dsa_obj_dn", r->dsa_obj_dn);
	ndr->depth++;
	if (r->dsa_obj_dn) {
		ndr_print_string(ndr, "dsa_obj_dn", r->dsa_obj_dn);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "dsa_obj_guid", &r->dsa_obj_guid);
	ndr_print_NTTIME(ndr, "first_failure", r->first_failure);
	ndr_print_uint32(ndr, "num_failures", r->num_failures);
	ndr_print_WERROR(ndr, "last_result", r->last_result);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaKccDsaFailuresCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaKccDsaFailuresCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailure(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaKccDsaFailuresCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaKccDsaFailuresCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaKccDsaFailuresCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaKccDsaFailure(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaOpType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsReplicaOpType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaOpType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum drsuapi_DsReplicaOpType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOpType(struct ndr_print *ndr, const char *name, enum drsuapi_DsReplicaOpType r)
{
	const char *val = NULL;

	switch (r) {
		case DRSUAPI_DS_REPLICA_OP_TYPE_SYNC: val = "DRSUAPI_DS_REPLICA_OP_TYPE_SYNC"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_ADD: val = "DRSUAPI_DS_REPLICA_OP_TYPE_ADD"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_DELETE: val = "DRSUAPI_DS_REPLICA_OP_TYPE_DELETE"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY: val = "DRSUAPI_DS_REPLICA_OP_TYPE_MODIFY"; break;
		case DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS: val = "DRSUAPI_DS_REPLICA_OP_TYPE_UPDATE_REFS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaOp(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaOp *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->operation_start));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial_num));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->priority));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaOpType(ndr, NDR_SCALARS, r->operation_type));
		NDR_CHECK(ndr_push_drsuapi_DrsOptions(ndr, NDR_SCALARS, r->options));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->nc_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->remote_dsa_obj_dn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->remote_dsa_address));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->nc_obj_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->remote_dsa_obj_guid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->nc_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->nc_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->nc_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->nc_dn, ndr_charset_length(r->nc_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->remote_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_dsa_obj_dn, ndr_charset_length(r->remote_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->remote_dsa_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->remote_dsa_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->remote_dsa_address, ndr_charset_length(r->remote_dsa_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaOp(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaOp *r)
{
	uint32_t _ptr_nc_dn;
	uint32_t size_nc_dn_1 = 0;
	uint32_t length_nc_dn_1 = 0;
	TALLOC_CTX *_mem_save_nc_dn_0 = NULL;
	uint32_t _ptr_remote_dsa_obj_dn;
	uint32_t size_remote_dsa_obj_dn_1 = 0;
	uint32_t length_remote_dsa_obj_dn_1 = 0;
	TALLOC_CTX *_mem_save_remote_dsa_obj_dn_0 = NULL;
	uint32_t _ptr_remote_dsa_address;
	uint32_t size_remote_dsa_address_1 = 0;
	uint32_t length_remote_dsa_address_1 = 0;
	TALLOC_CTX *_mem_save_remote_dsa_address_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->operation_start));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial_num));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->priority));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaOpType(ndr, NDR_SCALARS, &r->operation_type));
		NDR_CHECK(ndr_pull_drsuapi_DrsOptions(ndr, NDR_SCALARS, &r->options));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_nc_dn));
		if (_ptr_nc_dn) {
			NDR_PULL_ALLOC(ndr, r->nc_dn);
		} else {
			r->nc_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_remote_dsa_obj_dn));
		if (_ptr_remote_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->remote_dsa_obj_dn);
		} else {
			r->remote_dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_remote_dsa_address));
		if (_ptr_remote_dsa_address) {
			NDR_PULL_ALLOC(ndr, r->remote_dsa_address);
		} else {
			r->remote_dsa_address = NULL;
		}
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->nc_obj_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->remote_dsa_obj_guid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->nc_dn) {
			_mem_save_nc_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->nc_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->nc_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->nc_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->nc_dn, &size_nc_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->nc_dn, &length_nc_dn_1));
			if (length_nc_dn_1 > size_nc_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_nc_dn_1, length_nc_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_nc_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->nc_dn, length_nc_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_nc_dn_0, 0);
		}
		if (r->remote_dsa_obj_dn) {
			_mem_save_remote_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->remote_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_dsa_obj_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_dsa_obj_dn, &size_remote_dsa_obj_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_dsa_obj_dn, &length_remote_dsa_obj_dn_1));
			if (length_remote_dsa_obj_dn_1 > size_remote_dsa_obj_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_dsa_obj_dn_1, length_remote_dsa_obj_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_dsa_obj_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_dsa_obj_dn, length_remote_dsa_obj_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_remote_dsa_obj_dn_0, 0);
		}
		if (r->remote_dsa_address) {
			_mem_save_remote_dsa_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->remote_dsa_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->remote_dsa_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->remote_dsa_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->remote_dsa_address, &size_remote_dsa_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->remote_dsa_address, &length_remote_dsa_address_1));
			if (length_remote_dsa_address_1 > size_remote_dsa_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_remote_dsa_address_1, length_remote_dsa_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_remote_dsa_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->remote_dsa_address, length_remote_dsa_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_remote_dsa_address_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOp(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOp *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "operation_start", r->operation_start);
	ndr_print_uint32(ndr, "serial_num", r->serial_num);
	ndr_print_uint32(ndr, "priority", r->priority);
	ndr_print_drsuapi_DsReplicaOpType(ndr, "operation_type", r->operation_type);
	ndr_print_drsuapi_DrsOptions(ndr, "options", r->options);
	ndr_print_ptr(ndr, "nc_dn", r->nc_dn);
	ndr->depth++;
	if (r->nc_dn) {
		ndr_print_string(ndr, "nc_dn", r->nc_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "remote_dsa_obj_dn", r->remote_dsa_obj_dn);
	ndr->depth++;
	if (r->remote_dsa_obj_dn) {
		ndr_print_string(ndr, "remote_dsa_obj_dn", r->remote_dsa_obj_dn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "remote_dsa_address", r->remote_dsa_address);
	ndr->depth++;
	if (r->remote_dsa_address) {
		ndr_print_string(ndr, "remote_dsa_address", r->remote_dsa_address);
	}
	ndr->depth--;
	ndr_print_GUID(ndr, "nc_obj_guid", &r->nc_obj_guid);
	ndr_print_GUID(ndr, "remote_dsa_obj_guid", &r->remote_dsa_obj_guid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaOpCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaOpCtr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->time));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaOp(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaOp(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaOpCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaOpCtr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->time));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaOp(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaOp(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaOpCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaOpCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaOpCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_NTTIME(ndr, "time", r->time);
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaOp(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAttrValMetaData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAttrValMetaData *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_DATA_BLOB(0, r->binary, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->binary));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->deleted));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->created));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_change_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->binary) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->binary));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAttrValMetaData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAttrValMetaData *r)
{
	uint32_t _ptr_attribute_name;
	uint32_t size_attribute_name_1 = 0;
	uint32_t length_attribute_name_1 = 0;
	TALLOC_CTX *_mem_save_attribute_name_0 = NULL;
	uint32_t _ptr_object_dn;
	uint32_t size_object_dn_1 = 0;
	uint32_t length_object_dn_1 = 0;
	TALLOC_CTX *_mem_save_object_dn_0 = NULL;
	uint32_t _ptr_binary;
	TALLOC_CTX *_mem_save_binary_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_binary));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary));
		if (_ptr_binary) {
			NDR_PULL_ALLOC(ndr, r->binary);
		} else {
			r->binary = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->deleted));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->created));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_change_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->attribute_name, &size_attribute_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->attribute_name, &length_attribute_name_1));
			if (length_attribute_name_1 > size_attribute_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_attribute_name_1, length_attribute_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_attribute_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, length_attribute_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->object_dn, &size_object_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->object_dn, &length_object_dn_1));
			if (length_object_dn_1 > size_object_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_object_dn_1, length_object_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_object_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, length_object_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->binary) {
			_mem_save_binary_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->binary, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaData(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaData *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "__ndr_size_binary", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DATA_BLOB(0, r->binary, 0):r->__ndr_size_binary);
	ndr_print_ptr(ndr, "binary", r->binary);
	ndr->depth++;
	if (r->binary) {
		ndr_print_DATA_BLOB(ndr, "binary", *r->binary);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "deleted", r->deleted);
	ndr_print_NTTIME(ndr, "created", r->created);
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_change_time", r->originating_change_time);
	ndr_print_GUID(ndr, "originating_invocation_id", &r->originating_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAttrValMetaDataCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAttrValMetaDataCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaDataCtr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaDataCtr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaDataCtr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaAttrValMetaData(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaCursor2Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursor2Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursor2Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursor2Ctr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor2Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor2Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor2Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaCursor2(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaCursor3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursor3 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->highest_usn));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_sync_success));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->source_dsa_obj_dn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->source_dsa_obj_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->source_dsa_obj_dn, ndr_charset_length(r->source_dsa_obj_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursor3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursor3 *r)
{
	uint32_t _ptr_source_dsa_obj_dn;
	uint32_t size_source_dsa_obj_dn_1 = 0;
	uint32_t length_source_dsa_obj_dn_1 = 0;
	TALLOC_CTX *_mem_save_source_dsa_obj_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->source_dsa_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->highest_usn));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_sync_success));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_source_dsa_obj_dn));
		if (_ptr_source_dsa_obj_dn) {
			NDR_PULL_ALLOC(ndr, r->source_dsa_obj_dn);
		} else {
			r->source_dsa_obj_dn = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->source_dsa_obj_dn) {
			_mem_save_source_dsa_obj_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->source_dsa_obj_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->source_dsa_obj_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->source_dsa_obj_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->source_dsa_obj_dn, &size_source_dsa_obj_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->source_dsa_obj_dn, &length_source_dsa_obj_dn_1));
			if (length_source_dsa_obj_dn_1 > size_source_dsa_obj_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_source_dsa_obj_dn_1, length_source_dsa_obj_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_source_dsa_obj_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->source_dsa_obj_dn, length_source_dsa_obj_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_source_dsa_obj_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor3(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor3 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "source_dsa_invocation_id", &r->source_dsa_invocation_id);
	ndr_print_hyper(ndr, "highest_usn", r->highest_usn);
	ndr_print_NTTIME(ndr, "last_sync_success", r->last_sync_success);
	ndr_print_ptr(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	ndr->depth++;
	if (r->source_dsa_obj_dn) {
		ndr_print_string(ndr, "source_dsa_obj_dn", r->source_dsa_obj_dn);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaCursor3Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaCursor3Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor3(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor3(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaCursor3Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaCursor3Ctr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor3(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor3(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaCursor3Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaCursor3Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaCursor3Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaCursor3(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaObjMetaData2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjMetaData2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_change_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->originating_dsa_dn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->originating_dsa_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->originating_dsa_dn, ndr_charset_length(r->originating_dsa_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjMetaData2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjMetaData2 *r)
{
	uint32_t _ptr_attribute_name;
	uint32_t size_attribute_name_1 = 0;
	uint32_t length_attribute_name_1 = 0;
	TALLOC_CTX *_mem_save_attribute_name_0 = NULL;
	uint32_t _ptr_originating_dsa_dn;
	uint32_t size_originating_dsa_dn_1 = 0;
	uint32_t length_originating_dsa_dn_1 = 0;
	TALLOC_CTX *_mem_save_originating_dsa_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_change_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_originating_dsa_dn));
		if (_ptr_originating_dsa_dn) {
			NDR_PULL_ALLOC(ndr, r->originating_dsa_dn);
		} else {
			r->originating_dsa_dn = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->attribute_name, &size_attribute_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->attribute_name, &length_attribute_name_1));
			if (length_attribute_name_1 > size_attribute_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_attribute_name_1, length_attribute_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_attribute_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, length_attribute_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		if (r->originating_dsa_dn) {
			_mem_save_originating_dsa_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->originating_dsa_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->originating_dsa_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->originating_dsa_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->originating_dsa_dn, &size_originating_dsa_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->originating_dsa_dn, &length_originating_dsa_dn_1));
			if (length_originating_dsa_dn_1 > size_originating_dsa_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_originating_dsa_dn_1, length_originating_dsa_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_originating_dsa_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->originating_dsa_dn, length_originating_dsa_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_originating_dsa_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaData2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaData2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaData2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_change_time", r->originating_change_time);
	ndr_print_GUID(ndr, "originating_invocation_id", &r->originating_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr_print_ptr(ndr, "originating_dsa_dn", r->originating_dsa_dn);
	ndr->depth++;
	if (r->originating_dsa_dn) {
		ndr_print_string(ndr, "originating_dsa_dn", r->originating_dsa_dn);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaObjMetaData2Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaObjMetaData2Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaObjMetaData2Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaObjMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaObjMetaData2Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaObjMetaData2(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAttrValMetaData2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->attribute_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->object_dn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_DATA_BLOB(0, r->binary, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->binary));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->deleted));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->created));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->originating_change_time));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->originating_usn));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->local_usn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->originating_dsa_dn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->attribute_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->attribute_name, ndr_charset_length(r->attribute_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->object_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->object_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->object_dn, ndr_charset_length(r->object_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->binary) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->binary));
		}
		if (r->originating_dsa_dn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->originating_dsa_dn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->originating_dsa_dn, ndr_charset_length(r->originating_dsa_dn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAttrValMetaData2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	uint32_t _ptr_attribute_name;
	uint32_t size_attribute_name_1 = 0;
	uint32_t length_attribute_name_1 = 0;
	TALLOC_CTX *_mem_save_attribute_name_0 = NULL;
	uint32_t _ptr_object_dn;
	uint32_t size_object_dn_1 = 0;
	uint32_t length_object_dn_1 = 0;
	TALLOC_CTX *_mem_save_object_dn_0 = NULL;
	uint32_t _ptr_binary;
	TALLOC_CTX *_mem_save_binary_0 = NULL;
	uint32_t _ptr_originating_dsa_dn;
	uint32_t size_originating_dsa_dn_1 = 0;
	uint32_t length_originating_dsa_dn_1 = 0;
	TALLOC_CTX *_mem_save_originating_dsa_dn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attribute_name));
		if (_ptr_attribute_name) {
			NDR_PULL_ALLOC(ndr, r->attribute_name);
		} else {
			r->attribute_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_object_dn));
		if (_ptr_object_dn) {
			NDR_PULL_ALLOC(ndr, r->object_dn);
		} else {
			r->object_dn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->__ndr_size_binary));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary));
		if (_ptr_binary) {
			NDR_PULL_ALLOC(ndr, r->binary);
		} else {
			r->binary = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->deleted));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->created));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->originating_change_time));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->originating_invocation_id));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->originating_usn));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->local_usn));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_originating_dsa_dn));
		if (_ptr_originating_dsa_dn) {
			NDR_PULL_ALLOC(ndr, r->originating_dsa_dn);
		} else {
			r->originating_dsa_dn = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->attribute_name) {
			_mem_save_attribute_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->attribute_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->attribute_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->attribute_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->attribute_name, &size_attribute_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->attribute_name, &length_attribute_name_1));
			if (length_attribute_name_1 > size_attribute_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_attribute_name_1, length_attribute_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_attribute_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->attribute_name, length_attribute_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attribute_name_0, 0);
		}
		if (r->object_dn) {
			_mem_save_object_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->object_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->object_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->object_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->object_dn, &size_object_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->object_dn, &length_object_dn_1));
			if (length_object_dn_1 > size_object_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_object_dn_1, length_object_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_object_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->object_dn, length_object_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_object_dn_0, 0);
		}
		if (r->binary) {
			_mem_save_binary_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->binary, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_0, 0);
		}
		if (r->originating_dsa_dn) {
			_mem_save_originating_dsa_dn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->originating_dsa_dn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->originating_dsa_dn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->originating_dsa_dn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->originating_dsa_dn, &size_originating_dsa_dn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->originating_dsa_dn, &length_originating_dsa_dn_1));
			if (length_originating_dsa_dn_1 > size_originating_dsa_dn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_originating_dsa_dn_1, length_originating_dsa_dn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_originating_dsa_dn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->originating_dsa_dn, length_originating_dsa_dn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_originating_dsa_dn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaData2(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaData2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaData2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "attribute_name", r->attribute_name);
	ndr->depth++;
	if (r->attribute_name) {
		ndr_print_string(ndr, "attribute_name", r->attribute_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "object_dn", r->object_dn);
	ndr->depth++;
	if (r->object_dn) {
		ndr_print_string(ndr, "object_dn", r->object_dn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "__ndr_size_binary", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DATA_BLOB(0, r->binary, 0):r->__ndr_size_binary);
	ndr_print_ptr(ndr, "binary", r->binary);
	ndr->depth++;
	if (r->binary) {
		ndr_print_DATA_BLOB(ndr, "binary", *r->binary);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "deleted", r->deleted);
	ndr_print_NTTIME(ndr, "created", r->created);
	ndr_print_uint32(ndr, "version", r->version);
	ndr_print_NTTIME(ndr, "originating_change_time", r->originating_change_time);
	ndr_print_GUID(ndr, "originating_invocation_id", &r->originating_invocation_id);
	ndr_print_hyper(ndr, "originating_usn", r->originating_usn);
	ndr_print_hyper(ndr, "local_usn", r->local_usn);
	ndr_print_ptr(ndr, "originating_dsa_dn", r->originating_dsa_dn);
	ndr->depth++;
	if (r->originating_dsa_dn) {
		ndr_print_string(ndr, "originating_dsa_dn", r->originating_dsa_dn);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->enumeration_context));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->enumeration_context));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData2(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAttrValMetaData2Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaAttrValMetaData2Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAttrValMetaData2Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "enumeration_context", r->enumeration_context);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaAttrValMetaData2(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaConnection04(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaConnection04 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->bind_guid));
		NDR_CHECK(ndr_push_NTTIME_1sec(ndr, NDR_SCALARS, r->bind_time));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u5));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaConnection04(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaConnection04 *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->bind_guid));
		NDR_CHECK(ndr_pull_NTTIME_1sec(ndr, NDR_SCALARS, &r->bind_time));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->client_ip_address));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u5));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaConnection04(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaConnection04 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaConnection04");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr_print_GUID(ndr, "bind_guid", &r->bind_guid);
	ndr_print_NTTIME_1sec(ndr, "bind_time", r->bind_time);
	{
		libndr_flags _flags_save_ipv4address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv4address(ndr, "client_ip_address", r->client_ip_address);
		ndr->flags = _flags_save_ipv4address;
	}
	ndr_print_uint32(ndr, "u5", r->u5);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaConnection04Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplicaConnection04Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplicaConnection04(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaConnection04Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplicaConnection04Ctr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplicaConnection04(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaConnection04Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplicaConnection04Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaConnection04Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplicaConnection04(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplica06(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplica06 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->str1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u5));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->u6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->u7));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str1) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->str1, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->str1, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->str1, ndr_charset_length(r->str1, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplica06(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplica06 *r)
{
	uint32_t _ptr_str1;
	uint32_t size_str1_1 = 0;
	uint32_t length_str1_1 = 0;
	TALLOC_CTX *_mem_save_str1_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_str1));
		if (_ptr_str1) {
			NDR_PULL_ALLOC(ndr, r->str1);
		} else {
			r->str1 = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u5));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->u6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->u7));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->str1) {
			_mem_save_str1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->str1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->str1));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->str1));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->str1, &size_str1_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->str1, &length_str1_1));
			if (length_str1_1 > size_str1_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_str1_1, length_str1_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_str1_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->str1, length_str1_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_str1_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplica06(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplica06 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplica06");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "str1", r->str1);
	ndr->depth++;
	if (r->str1) {
		ndr_print_string(ndr, "str1", r->str1);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "u1", r->u1);
	ndr_print_uint32(ndr, "u2", r->u2);
	ndr_print_uint32(ndr, "u3", r->u3);
	ndr_print_uint32(ndr, "u4", r->u4);
	ndr_print_uint32(ndr, "u5", r->u5);
	ndr_print_hyper(ndr, "u6", r->u6);
	ndr_print_uint32(ndr, "u7", r->u7);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplica06Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsReplica06Ctr *r)
{
	uint32_t cntr_array_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved));
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplica06(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
			NDR_CHECK(ndr_push_drsuapi_DsReplica06(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplica06Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsReplica06Ctr *r)
{
	uint32_t size_array_0 = 0;
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->array));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		if (r->count > 256) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->count), (uint32_t)(0), (uint32_t)(256));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplica06(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		if (r->array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->array, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->array, &size_array_0));
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
			NDR_CHECK(ndr_pull_drsuapi_DsReplica06(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
		for (cntr_array_0 = 0; cntr_array_0 < (size_array_0); cntr_array_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplica06Ctr(struct ndr_print *ndr, const char *name, const struct drsuapi_DsReplica06Ctr *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "drsuapi_DsReplica06Ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_uint32(ndr, "reserved", r->reserved);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "array", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_array_0 = 0; cntr_array_0 < (r->count); cntr_array_0++) {
		ndr_print_drsuapi_DsReplica06(ndr, "array", &r->array[cntr_array_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsReplicaInfo *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->neighbours));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->objmetadata));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->connectfailures));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->linkfailures));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pendingops));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->attrvalmetadata));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors2));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->cursors3));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->objmetadata2));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->attrvalmetadata2));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_REPSTO: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->repsto));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->clientctx));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->udv1));
			break; }

			case DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->srvoutgoingcalls));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
				if (r->neighbours) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->neighbours));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS:
				if (r->cursors) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtr(ndr, NDR_SCALARS, r->cursors));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
				if (r->objmetadata) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
				if (r->connectfailures) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->connectfailures));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
				if (r->linkfailures) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->linkfailures));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
				if (r->pendingops) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaOpCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->pendingops));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
				if (r->attrvalmetadata) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
				if (r->cursors2) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor2Ctr(ndr, NDR_SCALARS, r->cursors2));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
				if (r->cursors3) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursor3Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors3));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
				if (r->objmetadata2) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaObjMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata2));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
				if (r->attrvalmetadata2) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaAttrValMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata2));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_REPSTO:
				if (r->repsto) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->repsto));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS:
				if (r->clientctx) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaConnection04Ctr(ndr, NDR_SCALARS, r->clientctx));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1:
				if (r->udv1) {
					NDR_CHECK(ndr_push_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->udv1));
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS:
				if (r->srvoutgoingcalls) {
					NDR_CHECK(ndr_push_drsuapi_DsReplica06Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->srvoutgoingcalls));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsReplicaInfo *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_neighbours_0 = NULL;
	uint32_t _ptr_neighbours;
	TALLOC_CTX *_mem_save_cursors_0 = NULL;
	uint32_t _ptr_cursors;
	TALLOC_CTX *_mem_save_objmetadata_0 = NULL;
	uint32_t _ptr_objmetadata;
	TALLOC_CTX *_mem_save_connectfailures_0 = NULL;
	uint32_t _ptr_connectfailures;
	TALLOC_CTX *_mem_save_linkfailures_0 = NULL;
	uint32_t _ptr_linkfailures;
	TALLOC_CTX *_mem_save_pendingops_0 = NULL;
	uint32_t _ptr_pendingops;
	TALLOC_CTX *_mem_save_attrvalmetadata_0 = NULL;
	uint32_t _ptr_attrvalmetadata;
	TALLOC_CTX *_mem_save_cursors2_0 = NULL;
	uint32_t _ptr_cursors2;
	TALLOC_CTX *_mem_save_cursors3_0 = NULL;
	uint32_t _ptr_cursors3;
	TALLOC_CTX *_mem_save_objmetadata2_0 = NULL;
	uint32_t _ptr_objmetadata2;
	TALLOC_CTX *_mem_save_attrvalmetadata2_0 = NULL;
	uint32_t _ptr_attrvalmetadata2;
	TALLOC_CTX *_mem_save_repsto_0 = NULL;
	uint32_t _ptr_repsto;
	TALLOC_CTX *_mem_save_clientctx_0 = NULL;
	uint32_t _ptr_clientctx;
	TALLOC_CTX *_mem_save_udv1_0 = NULL;
	uint32_t _ptr_udv1;
	TALLOC_CTX *_mem_save_srvoutgoingcalls_0 = NULL;
	uint32_t _ptr_srvoutgoingcalls;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_neighbours));
				if (_ptr_neighbours) {
					NDR_PULL_ALLOC(ndr, r->neighbours);
				} else {
					r->neighbours = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors));
				if (_ptr_cursors) {
					NDR_PULL_ALLOC(ndr, r->cursors);
				} else {
					r->cursors = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objmetadata));
				if (_ptr_objmetadata) {
					NDR_PULL_ALLOC(ndr, r->objmetadata);
				} else {
					r->objmetadata = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_connectfailures));
				if (_ptr_connectfailures) {
					NDR_PULL_ALLOC(ndr, r->connectfailures);
				} else {
					r->connectfailures = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_linkfailures));
				if (_ptr_linkfailures) {
					NDR_PULL_ALLOC(ndr, r->linkfailures);
				} else {
					r->linkfailures = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pendingops));
				if (_ptr_pendingops) {
					NDR_PULL_ALLOC(ndr, r->pendingops);
				} else {
					r->pendingops = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attrvalmetadata));
				if (_ptr_attrvalmetadata) {
					NDR_PULL_ALLOC(ndr, r->attrvalmetadata);
				} else {
					r->attrvalmetadata = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors2));
				if (_ptr_cursors2) {
					NDR_PULL_ALLOC(ndr, r->cursors2);
				} else {
					r->cursors2 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_cursors3));
				if (_ptr_cursors3) {
					NDR_PULL_ALLOC(ndr, r->cursors3);
				} else {
					r->cursors3 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_objmetadata2));
				if (_ptr_objmetadata2) {
					NDR_PULL_ALLOC(ndr, r->objmetadata2);
				} else {
					r->objmetadata2 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_attrvalmetadata2));
				if (_ptr_attrvalmetadata2) {
					NDR_PULL_ALLOC(ndr, r->attrvalmetadata2);
				} else {
					r->attrvalmetadata2 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_REPSTO: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_repsto));
				if (_ptr_repsto) {
					NDR_PULL_ALLOC(ndr, r->repsto);
				} else {
					r->repsto = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_clientctx));
				if (_ptr_clientctx) {
					NDR_PULL_ALLOC(ndr, r->clientctx);
				} else {
					r->clientctx = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_udv1));
				if (_ptr_udv1) {
					NDR_PULL_ALLOC(ndr, r->udv1);
				} else {
					r->udv1 = NULL;
				}
			break; }

			case DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_srvoutgoingcalls));
				if (_ptr_srvoutgoingcalls) {
					NDR_PULL_ALLOC(ndr, r->srvoutgoingcalls);
				} else {
					r->srvoutgoingcalls = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
				if (r->neighbours) {
					_mem_save_neighbours_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->neighbours, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->neighbours));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_neighbours_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS:
				if (r->cursors) {
					_mem_save_cursors_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtr(ndr, NDR_SCALARS, r->cursors));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
				if (r->objmetadata) {
					_mem_save_objmetadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->objmetadata, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objmetadata_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
				if (r->connectfailures) {
					_mem_save_connectfailures_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->connectfailures, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->connectfailures));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_connectfailures_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
				if (r->linkfailures) {
					_mem_save_linkfailures_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->linkfailures, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->linkfailures));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_linkfailures_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
				if (r->pendingops) {
					_mem_save_pendingops_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pendingops, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaOpCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->pendingops));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pendingops_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
				if (r->attrvalmetadata) {
					_mem_save_attrvalmetadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->attrvalmetadata, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaDataCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attrvalmetadata_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
				if (r->cursors2) {
					_mem_save_cursors2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors2, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor2Ctr(ndr, NDR_SCALARS, r->cursors2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors2_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
				if (r->cursors3) {
					_mem_save_cursors3_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->cursors3, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursor3Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->cursors3));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_cursors3_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
				if (r->objmetadata2) {
					_mem_save_objmetadata2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->objmetadata2, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaObjMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->objmetadata2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_objmetadata2_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
				if (r->attrvalmetadata2) {
					_mem_save_attrvalmetadata2_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->attrvalmetadata2, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaAttrValMetaData2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->attrvalmetadata2));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_attrvalmetadata2_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_REPSTO:
				if (r->repsto) {
					_mem_save_repsto_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->repsto, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaNeighbourCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->repsto));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_repsto_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS:
				if (r->clientctx) {
					_mem_save_clientctx_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->clientctx, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaConnection04Ctr(ndr, NDR_SCALARS, r->clientctx));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_clientctx_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1:
				if (r->udv1) {
					_mem_save_udv1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->udv1, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplicaCursorCtrEx(ndr, NDR_SCALARS, r->udv1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_udv1_0, 0);
				}
			break;

			case DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS:
				if (r->srvoutgoingcalls) {
					_mem_save_srvoutgoingcalls_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->srvoutgoingcalls, 0);
					NDR_CHECK(ndr_pull_drsuapi_DsReplica06Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->srvoutgoingcalls));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_srvoutgoingcalls_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaInfo(struct ndr_print *ndr, const char *name, const union drsuapi_DsReplicaInfo *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsReplicaInfo");
	switch (level) {
		case DRSUAPI_DS_REPLICA_INFO_NEIGHBORS:
			ndr_print_ptr(ndr, "neighbours", r->neighbours);
			ndr->depth++;
			if (r->neighbours) {
				ndr_print_drsuapi_DsReplicaNeighbourCtr(ndr, "neighbours", r->neighbours);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS:
			ndr_print_ptr(ndr, "cursors", r->cursors);
			ndr->depth++;
			if (r->cursors) {
				ndr_print_drsuapi_DsReplicaCursorCtr(ndr, "cursors", r->cursors);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA:
			ndr_print_ptr(ndr, "objmetadata", r->objmetadata);
			ndr->depth++;
			if (r->objmetadata) {
				ndr_print_drsuapi_DsReplicaObjMetaDataCtr(ndr, "objmetadata", r->objmetadata);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_CONNECT_FAILURES:
			ndr_print_ptr(ndr, "connectfailures", r->connectfailures);
			ndr->depth++;
			if (r->connectfailures) {
				ndr_print_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, "connectfailures", r->connectfailures);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_KCC_DSA_LINK_FAILURES:
			ndr_print_ptr(ndr, "linkfailures", r->linkfailures);
			ndr->depth++;
			if (r->linkfailures) {
				ndr_print_drsuapi_DsReplicaKccDsaFailuresCtr(ndr, "linkfailures", r->linkfailures);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_PENDING_OPS:
			ndr_print_ptr(ndr, "pendingops", r->pendingops);
			ndr->depth++;
			if (r->pendingops) {
				ndr_print_drsuapi_DsReplicaOpCtr(ndr, "pendingops", r->pendingops);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA:
			ndr_print_ptr(ndr, "attrvalmetadata", r->attrvalmetadata);
			ndr->depth++;
			if (r->attrvalmetadata) {
				ndr_print_drsuapi_DsReplicaAttrValMetaDataCtr(ndr, "attrvalmetadata", r->attrvalmetadata);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS2:
			ndr_print_ptr(ndr, "cursors2", r->cursors2);
			ndr->depth++;
			if (r->cursors2) {
				ndr_print_drsuapi_DsReplicaCursor2Ctr(ndr, "cursors2", r->cursors2);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CURSORS3:
			ndr_print_ptr(ndr, "cursors3", r->cursors3);
			ndr->depth++;
			if (r->cursors3) {
				ndr_print_drsuapi_DsReplicaCursor3Ctr(ndr, "cursors3", r->cursors3);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_OBJ_METADATA2:
			ndr_print_ptr(ndr, "objmetadata2", r->objmetadata2);
			ndr->depth++;
			if (r->objmetadata2) {
				ndr_print_drsuapi_DsReplicaObjMetaData2Ctr(ndr, "objmetadata2", r->objmetadata2);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_ATTRIBUTE_VALUE_METADATA2:
			ndr_print_ptr(ndr, "attrvalmetadata2", r->attrvalmetadata2);
			ndr->depth++;
			if (r->attrvalmetadata2) {
				ndr_print_drsuapi_DsReplicaAttrValMetaData2Ctr(ndr, "attrvalmetadata2", r->attrvalmetadata2);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_REPSTO:
			ndr_print_ptr(ndr, "repsto", r->repsto);
			ndr->depth++;
			if (r->repsto) {
				ndr_print_drsuapi_DsReplicaNeighbourCtr(ndr, "repsto", r->repsto);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_CLIENT_CONTEXTS:
			ndr_print_ptr(ndr, "clientctx", r->clientctx);
			ndr->depth++;
			if (r->clientctx) {
				ndr_print_drsuapi_DsReplicaConnection04Ctr(ndr, "clientctx", r->clientctx);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_UPTODATE_VECTOR_V1:
			ndr_print_ptr(ndr, "udv1", r->udv1);
			ndr->depth++;
			if (r->udv1) {
				ndr_print_drsuapi_DsReplicaCursorCtrEx(ndr, "udv1", r->udv1);
			}
			ndr->depth--;
		break;

		case DRSUAPI_DS_REPLICA_INFO_SERVER_OUTGOING_CALLS:
			ndr_print_ptr(ndr, "srvoutgoingcalls", r->srvoutgoingcalls);
			ndr->depth++;
			if (r->srvoutgoingcalls) {
				ndr_print_drsuapi_DsReplica06Ctr(ndr, "srvoutgoingcalls", r->srvoutgoingcalls);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMemberships2Ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetMemberships2Ctr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMemberships2Ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetMemberships2Ctr *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2Ctr(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMemberships2Ctr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMemberships2Ctr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMembershipsCtr1(ndr, "ctr1", &r->ctr1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMemberships2Request1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsGetMemberships2Request1 *r)
{
	uint32_t cntr_req_array_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_req));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->req_array));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->req_array) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_req));
			for (cntr_req_array_1 = 0; cntr_req_array_1 < (r->num_req); cntr_req_array_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->req_array[cntr_req_array_1]));
			}
			for (cntr_req_array_1 = 0; cntr_req_array_1 < (r->num_req); cntr_req_array_1++) {
				if (r->req_array[cntr_req_array_1]) {
					NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS|NDR_BUFFERS, r->req_array[cntr_req_array_1]));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMemberships2Request1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsGetMemberships2Request1 *r)
{
	uint32_t _ptr_req_array;
	uint32_t size_req_array_1 = 0;
	uint32_t cntr_req_array_1;
	TALLOC_CTX *_mem_save_req_array_0 = NULL;
	TALLOC_CTX *_mem_save_req_array_1 = NULL;
	TALLOC_CTX *_mem_save_req_array_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_req));
		if (r->num_req < 1 || r->num_req > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_req), (uint32_t)(1), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_req_array));
		if (_ptr_req_array) {
			NDR_PULL_ALLOC(ndr, r->req_array);
		} else {
			r->req_array = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->req_array) {
			_mem_save_req_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->req_array, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->req_array));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->req_array, &size_req_array_1));
			NDR_PULL_ALLOC_N(ndr, r->req_array, size_req_array_1);
			_mem_save_req_array_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->req_array, 0);
			for (cntr_req_array_1 = 0; cntr_req_array_1 < (size_req_array_1); cntr_req_array_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_req_array));
				if (_ptr_req_array) {
					NDR_PULL_ALLOC(ndr, r->req_array[cntr_req_array_1]);
				} else {
					r->req_array[cntr_req_array_1] = NULL;
				}
			}
			for (cntr_req_array_1 = 0; cntr_req_array_1 < (size_req_array_1); cntr_req_array_1++) {
				if (r->req_array[cntr_req_array_1]) {
					_mem_save_req_array_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->req_array[cntr_req_array_1], 0);
					NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest1(ndr, NDR_SCALARS|NDR_BUFFERS, r->req_array[cntr_req_array_1]));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_array_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_array_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_array_0, 0);
		}
		if (r->req_array) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->req_array, r->num_req));
		}
		for (cntr_req_array_1 = 0; cntr_req_array_1 < (size_req_array_1); cntr_req_array_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2Request1(struct ndr_print *ndr, const char *name, const struct drsuapi_DsGetMemberships2Request1 *r)
{
	uint32_t cntr_req_array_1;
	ndr_print_struct(ndr, name, "drsuapi_DsGetMemberships2Request1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_req", r->num_req);
	ndr_print_ptr(ndr, "req_array", r->req_array);
	ndr->depth++;
	if (r->req_array) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "req_array", (uint32_t)(r->num_req));
		ndr->depth++;
		for (cntr_req_array_1 = 0; cntr_req_array_1 < (r->num_req); cntr_req_array_1++) {
			ndr_print_ptr(ndr, "req_array", r->req_array[cntr_req_array_1]);
			ndr->depth++;
			if (r->req_array[cntr_req_array_1]) {
				ndr_print_drsuapi_DsGetMembershipsRequest1(ndr, "req_array", r->req_array[cntr_req_array_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMemberships2Request(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_DsGetMemberships2Request *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Request1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Request1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMemberships2Request(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_DsGetMemberships2Request *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Request1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Request1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2Request(struct ndr_print *ndr, const char *name, const union drsuapi_DsGetMemberships2Request *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_DsGetMemberships2Request");
	switch (level) {
		case 1:
			ndr_print_drsuapi_DsGetMemberships2Request1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_DsSiteCostInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_DsSiteCostInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->error_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->site_cost));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsSiteCostInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_DsSiteCostInfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->error_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->site_cost));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsSiteCostInfo(struct ndr_print *ndr, const char *name, const struct drsuapi_DsSiteCostInfo *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsSiteCostInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_WERROR(ndr, "error_code", r->error_code);
	ndr_print_uint32(ndr, "site_cost", r->site_cost);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_QuerySitesByCostCtr1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_QuerySitesByCostCtr1 *r)
{
	uint32_t cntr_info_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_info));
			for (cntr_info_1 = 0; cntr_info_1 < (r->num_info); cntr_info_1++) {
				NDR_CHECK(ndr_push_drsuapi_DsSiteCostInfo(ndr, NDR_SCALARS, &r->info[cntr_info_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_QuerySitesByCostCtr1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_QuerySitesByCostCtr1 *r)
{
	uint32_t _ptr_info;
	uint32_t size_info_1 = 0;
	uint32_t cntr_info_1;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	TALLOC_CTX *_mem_save_info_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_info));
		if (r->num_info > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_info), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags_reserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->info));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->info, &size_info_1));
			NDR_PULL_ALLOC_N(ndr, r->info, size_info_1);
			_mem_save_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			for (cntr_info_1 = 0; cntr_info_1 < (size_info_1); cntr_info_1++) {
				NDR_CHECK(ndr_pull_drsuapi_DsSiteCostInfo(ndr, NDR_SCALARS, &r->info[cntr_info_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (r->info) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->info, r->num_info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_QuerySitesByCostCtr1(struct ndr_print *ndr, const char *name, const struct drsuapi_QuerySitesByCostCtr1 *r)
{
	uint32_t cntr_info_1;
	ndr_print_struct(ndr, name, "drsuapi_QuerySitesByCostCtr1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_info", r->num_info);
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "info", (uint32_t)(r->num_info));
		ndr->depth++;
		for (cntr_info_1 = 0; cntr_info_1 < (r->num_info); cntr_info_1++) {
			ndr_print_drsuapi_DsSiteCostInfo(ndr, "info", &r->info[cntr_info_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "flags_reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->flags_reserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_QuerySitesByCostCtr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_QuerySitesByCostCtr *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_QuerySitesByCostCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_QuerySitesByCostCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_QuerySitesByCostCtr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_QuerySitesByCostCtr *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_QuerySitesByCostCtr1(ndr, NDR_SCALARS, &r->ctr1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_QuerySitesByCostCtr1(ndr, NDR_BUFFERS, &r->ctr1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_QuerySitesByCostCtr(struct ndr_print *ndr, const char *name, const union drsuapi_QuerySitesByCostCtr *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_QuerySitesByCostCtr");
	switch (level) {
		case 1:
			ndr_print_drsuapi_QuerySitesByCostCtr1(ndr, "ctr1", &r->ctr1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_drsuapi_QuerySitesByCostRequest1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct drsuapi_QuerySitesByCostRequest1 *r)
{
	uint32_t cntr_site_to_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_from));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_req));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_to));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->site_from) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_from, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_from, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_from, ndr_charset_length(r->site_from, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->site_to) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_req));
			for (cntr_site_to_1 = 0; cntr_site_to_1 < (r->num_req); cntr_site_to_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->site_to[cntr_site_to_1]));
			}
			for (cntr_site_to_1 = 0; cntr_site_to_1 < (r->num_req); cntr_site_to_1++) {
				if (r->site_to[cntr_site_to_1]) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_to[cntr_site_to_1], CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->site_to[cntr_site_to_1], CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->site_to[cntr_site_to_1], ndr_charset_length(r->site_to[cntr_site_to_1], CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_QuerySitesByCostRequest1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct drsuapi_QuerySitesByCostRequest1 *r)
{
	uint32_t _ptr_site_from;
	uint32_t size_site_from_1 = 0;
	uint32_t length_site_from_1 = 0;
	TALLOC_CTX *_mem_save_site_from_0 = NULL;
	uint32_t _ptr_site_to;
	uint32_t size_site_to_1 = 0;
	uint32_t cntr_site_to_1;
	uint32_t size_site_to_3 = 0;
	uint32_t length_site_to_3 = 0;
	TALLOC_CTX *_mem_save_site_to_0 = NULL;
	TALLOC_CTX *_mem_save_site_to_1 = NULL;
	TALLOC_CTX *_mem_save_site_to_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_from));
		if (_ptr_site_from) {
			NDR_PULL_ALLOC(ndr, r->site_from);
		} else {
			r->site_from = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_req));
		if (r->num_req < 1 || r->num_req > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_req), (uint32_t)(1), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_to));
		if (_ptr_site_to) {
			NDR_PULL_ALLOC(ndr, r->site_to);
		} else {
			r->site_to = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->site_from) {
			_mem_save_site_from_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_from, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_from));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->site_from));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_from, &size_site_from_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_from, &length_site_from_1));
			if (length_site_from_1 > size_site_from_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_from_1, length_site_from_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_site_from_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_from, length_site_from_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_from_0, 0);
		}
		if (r->site_to) {
			_mem_save_site_to_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_to, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->site_to));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->site_to, &size_site_to_1));
			NDR_PULL_ALLOC_N(ndr, r->site_to, size_site_to_1);
			_mem_save_site_to_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->site_to, 0);
			for (cntr_site_to_1 = 0; cntr_site_to_1 < (size_site_to_1); cntr_site_to_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_site_to));
				if (_ptr_site_to) {
					NDR_PULL_ALLOC(ndr, r->site_to[cntr_site_to_1]);
				} else {
					r->site_to[cntr_site_to_1] = NULL;
				}
			}
			for (cntr_site_to_1 = 0; cntr_site_to_1 < (size_site_to_1); cntr_site_to_1++) {
				if (r->site_to[cntr_site_to_1]) {
					_mem_save_site_to_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->site_to[cntr_site_to_1], 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->site_to[cntr_site_to_1]));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->site_to[cntr_site_to_1]));
					NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->site_to[cntr_site_to_1], &size_site_to_3));
					NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->site_to[cntr_site_to_1], &length_site_to_3));
					if (length_site_to_3 > size_site_to_3) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_site_to_3, length_site_to_3);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_site_to_3, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->site_to[cntr_site_to_1], length_site_to_3, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_to_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_to_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_site_to_0, 0);
		}
		if (r->site_to) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->site_to, r->num_req));
		}
		for (cntr_site_to_1 = 0; cntr_site_to_1 < (size_site_to_1); cntr_site_to_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_QuerySitesByCostRequest1(struct ndr_print *ndr, const char *name, const struct drsuapi_QuerySitesByCostRequest1 *r)
{
	uint32_t cntr_site_to_1;
	ndr_print_struct(ndr, name, "drsuapi_QuerySitesByCostRequest1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "site_from", r->site_from);
	ndr->depth++;
	if (r->site_from) {
		ndr_print_string(ndr, "site_from", r->site_from);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "num_req", r->num_req);
	ndr_print_ptr(ndr, "site_to", r->site_to);
	ndr->depth++;
	if (r->site_to) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "site_to", (uint32_t)(r->num_req));
		ndr->depth++;
		for (cntr_site_to_1 = 0; cntr_site_to_1 < (r->num_req); cntr_site_to_1++) {
			ndr_print_ptr(ndr, "site_to", r->site_to[cntr_site_to_1]);
			ndr->depth++;
			if (r->site_to[cntr_site_to_1]) {
				ndr_print_string(ndr, "site_to", r->site_to[cntr_site_to_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_QuerySitesByCostRequest(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union drsuapi_QuerySitesByCostRequest *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_drsuapi_QuerySitesByCostRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_drsuapi_QuerySitesByCostRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_QuerySitesByCostRequest(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union drsuapi_QuerySitesByCostRequest *r)
{
	uint32_t level;
	uint32_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_drsuapi_QuerySitesByCostRequest1(ndr, NDR_SCALARS, &r->req1));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_drsuapi_QuerySitesByCostRequest1(ndr, NDR_BUFFERS, &r->req1));
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_QuerySitesByCostRequest(struct ndr_print *ndr, const char *name, const union drsuapi_QuerySitesByCostRequest *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "drsuapi_QuerySitesByCostRequest");
	switch (level) {
		case 1:
			ndr_print_drsuapi_QuerySitesByCostRequest1(ndr, "req1", &r->req1);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsBind(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsBind *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.bind_guid));
		if (r->in.bind_guid) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.bind_guid));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.bind_info));
		if (r->in.bind_info) {
			NDR_CHECK(ndr_push_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS, r->in.bind_info));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.bind_info));
		if (r->out.bind_info) {
			NDR_CHECK(ndr_push_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS, r->out.bind_info));
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.bind_handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsBind(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsBind *r)
{
	uint32_t _ptr_bind_guid;
	uint32_t _ptr_bind_info;
	TALLOC_CTX *_mem_save_bind_guid_0 = NULL;
	TALLOC_CTX *_mem_save_bind_info_0 = NULL;
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bind_guid));
		if (_ptr_bind_guid) {
			NDR_PULL_ALLOC(ndr, r->in.bind_guid);
		} else {
			r->in.bind_guid = NULL;
		}
		if (r->in.bind_guid) {
			_mem_save_bind_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_guid, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.bind_guid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_guid_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bind_info));
		if (_ptr_bind_info) {
			NDR_PULL_ALLOC(ndr, r->in.bind_info);
		} else {
			r->in.bind_info = NULL;
		}
		if (r->in.bind_info) {
			_mem_save_bind_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_info, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS, r->in.bind_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_info_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		NDR_ZERO_STRUCTP(r->out.bind_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_bind_info));
		if (_ptr_bind_info) {
			NDR_PULL_ALLOC(ndr, r->out.bind_info);
		} else {
			r->out.bind_info = NULL;
		}
		if (r->out.bind_info) {
			_mem_save_bind_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.bind_info, 0);
			NDR_CHECK(ndr_pull_drsuapi_DsBindInfoCtr(ndr, NDR_SCALARS, r->out.bind_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_info_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsBind(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsBind *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsBind");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsBind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_guid", r->in.bind_guid);
		ndr->depth++;
		if (r->in.bind_guid) {
			ndr_print_GUID(ndr, "bind_guid", r->in.bind_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "bind_info", r->in.bind_info);
		ndr->depth++;
		if (r->in.bind_info) {
			ndr_print_drsuapi_DsBindInfoCtr(ndr, "bind_info", r->in.bind_info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsBind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_info", r->out.bind_info);
		ndr->depth++;
		if (r->out.bind_info) {
			ndr_print_drsuapi_DsBindInfoCtr(ndr, "bind_info", r->out.bind_info);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsUnbind(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsUnbind *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.bind_handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsUnbind(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsUnbind *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		*r->out.bind_handle = *r->in.bind_handle;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsUnbind(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsUnbind *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsUnbind");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsUnbind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsUnbind");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->out.bind_handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaSync(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsReplicaSync *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaSyncRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaSync(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsReplicaSync *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaSyncRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaSync(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsReplicaSync *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaSync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaSync");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaSyncRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaSync");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNCChanges(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsGetNCChanges *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsGetNCChangesCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNCChanges(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsGetNCChanges *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNCChangesCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNCChanges(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsGetNCChanges *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNCChanges");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetNCChanges");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetNCChangesRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetNCChanges");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_DsGetNCChangesCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaUpdateRefs(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsReplicaUpdateRefs *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaUpdateRefsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaUpdateRefs(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsReplicaUpdateRefs *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaUpdateRefsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaUpdateRefs(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsReplicaUpdateRefs *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaUpdateRefs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaUpdateRefs");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaUpdateRefsRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaUpdateRefs");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaAdd(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsReplicaAdd *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaAddRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaAdd(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsReplicaAdd *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaAddRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaAdd(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsReplicaAdd *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaAddRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaAdd");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaDel(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsReplicaDel *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaDelRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaDel(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsReplicaDel *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaDelRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaDel(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsReplicaDel *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaDel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaDel");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaDelRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaDel");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaMod(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsReplicaMod *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaModRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaMod(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsReplicaMod *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaModRequest(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.req));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaMod(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsReplicaMod *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaMod");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaMod");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_set_switch_value(ndr, &r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaModRequest(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaMod");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DRSUAPI_VERIFY_NAMES(struct ndr_push *ndr, ndr_flags_type flags, const struct DRSUAPI_VERIFY_NAMES *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DRSUAPI_VERIFY_NAMES(struct ndr_pull *ndr, ndr_flags_type flags, struct DRSUAPI_VERIFY_NAMES *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DRSUAPI_VERIFY_NAMES(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DRSUAPI_VERIFY_NAMES *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_VERIFY_NAMES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_VERIFY_NAMES");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_VERIFY_NAMES");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMemberships(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsGetMemberships *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsGetMembershipsCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMemberships(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsGetMemberships *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMembershipsCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsGetMemberships *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetMemberships");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetMemberships");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetMembershipsRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetMemberships");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_DsGetMembershipsCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DRSUAPI_INTER_DOMAIN_MOVE(struct ndr_push *ndr, ndr_flags_type flags, const struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DRSUAPI_INTER_DOMAIN_MOVE(struct ndr_pull *ndr, ndr_flags_type flags, struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DRSUAPI_INTER_DOMAIN_MOVE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DRSUAPI_INTER_DOMAIN_MOVE *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_INTER_DOMAIN_MOVE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_INTER_DOMAIN_MOVE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_INTER_DOMAIN_MOVE");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetNT4ChangeLog(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsGetNT4ChangeLog *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsGetNT4ChangeLogInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetNT4ChangeLog(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsGetNT4ChangeLog *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsGetNT4ChangeLogInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetNT4ChangeLog(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsGetNT4ChangeLog *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetNT4ChangeLog");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetNT4ChangeLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetNT4ChangeLogRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetNT4ChangeLog");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, *r->out.level_out);
		ndr_print_drsuapi_DsGetNT4ChangeLogInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsCrackNames(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsCrackNames *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsNameRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsNameCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsCrackNames(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsCrackNames *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsNameRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsNameCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsCrackNames(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsCrackNames *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsCrackNames");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsCrackNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsNameRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsCrackNames");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_DsNameCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsWriteAccountSpn(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsWriteAccountSpn *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.res == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.res, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsWriteAccountSpnResult(ndr, NDR_SCALARS, r->out.res));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsWriteAccountSpn(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsWriteAccountSpn *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_res_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.res);
		NDR_ZERO_STRUCTP(r->out.res);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.res);
		}
		_mem_save_res_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.res, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.res, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsWriteAccountSpnResult(ndr, NDR_SCALARS, r->out.res));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_res_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsWriteAccountSpn(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsWriteAccountSpn *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsWriteAccountSpn");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsWriteAccountSpn");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsWriteAccountSpnRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsWriteAccountSpn");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "res", r->out.res);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.res, *r->out.level_out);
		ndr_print_drsuapi_DsWriteAccountSpnResult(ndr, "res", r->out.res);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsRemoveDSServer(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsRemoveDSServer *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.res == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.res, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsRemoveDSServerResult(ndr, NDR_SCALARS, r->out.res));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsRemoveDSServer(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsRemoveDSServer *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_res_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.res);
		NDR_ZERO_STRUCTP(r->out.res);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.res);
		}
		_mem_save_res_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.res, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.res, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsRemoveDSServerResult(ndr, NDR_SCALARS, r->out.res));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_res_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsRemoveDSServer(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsRemoveDSServer *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsRemoveDSServer");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsRemoveDSServer");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsRemoveDSServerRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsRemoveDSServer");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "res", r->out.res);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.res, *r->out.level_out);
		ndr_print_drsuapi_DsRemoveDSServerResult(ndr, "res", r->out.res);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DRSUAPI_REMOVE_DS_DOMAIN(struct ndr_push *ndr, ndr_flags_type flags, const struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DRSUAPI_REMOVE_DS_DOMAIN(struct ndr_pull *ndr, ndr_flags_type flags, struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DRSUAPI_REMOVE_DS_DOMAIN(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DRSUAPI_REMOVE_DS_DOMAIN *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REMOVE_DS_DOMAIN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REMOVE_DS_DOMAIN");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REMOVE_DS_DOMAIN");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetDomainControllerInfo(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsGetDomainControllerInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtrLevels(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsGetDCInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetDomainControllerInfo(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsGetDomainControllerInfo *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtrLevels(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsGetDCInfoCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetDomainControllerInfo(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsGetDomainControllerInfo *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetDomainControllerInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetDomainControllerInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetDCInfoRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetDomainControllerInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_drsuapi_DsGetDCInfoCtrLevels(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_DsGetDCInfoCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_drsuapi_DsAddEntry(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsAddEntry *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsAddEntryCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_drsuapi_DsAddEntry(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsAddEntry *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsAddEntryCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsAddEntry(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsAddEntry *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsAddEntry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsAddEntry");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsAddEntryRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsAddEntry");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_DsAddEntryCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsExecuteKCC(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsExecuteKCC *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsExecuteKCCRequest(ndr, NDR_SCALARS, r->in.req));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsExecuteKCC(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsExecuteKCC *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsExecuteKCCRequest(ndr, NDR_SCALARS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsExecuteKCC(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsExecuteKCC *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsExecuteKCC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsExecuteKCC");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsExecuteKCCRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsExecuteKCC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsReplicaGetInfo(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsReplicaGetInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoLevel(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaGetInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.info_type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, *r->out.info_type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.info, *r->out.info_type));
		NDR_CHECK(ndr_push_drsuapi_DsReplicaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsReplicaGetInfo(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsReplicaGetInfo *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_info_type_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoLevel(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaGetInfoRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.info_type);
		NDR_ZERO_STRUCTP(r->out.info_type);
		NDR_PULL_ALLOC(ndr, r->out.info);
		NDR_ZERO_STRUCTP(r->out.info);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info_type);
		}
		_mem_save_info_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info_type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfoType(ndr, NDR_SCALARS, r->out.info_type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.info, *r->out.info_type));
		NDR_CHECK(ndr_pull_drsuapi_DsReplicaInfo(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsReplicaGetInfo(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsReplicaGetInfo *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsReplicaGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsReplicaGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_drsuapi_DsReplicaGetInfoLevel(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsReplicaGetInfoRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsReplicaGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info_type", r->out.info_type);
		ndr->depth++;
		ndr_print_drsuapi_DsReplicaInfoType(ndr, "info_type", *r->out.info_type);
		ndr->depth--;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.info, *r->out.info_type);
		ndr_print_drsuapi_DsReplicaInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DRSUAPI_ADD_SID_HISTORY(struct ndr_push *ndr, ndr_flags_type flags, const struct DRSUAPI_ADD_SID_HISTORY *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DRSUAPI_ADD_SID_HISTORY(struct ndr_pull *ndr, ndr_flags_type flags, struct DRSUAPI_ADD_SID_HISTORY *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DRSUAPI_ADD_SID_HISTORY(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DRSUAPI_ADD_SID_HISTORY *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_ADD_SID_HISTORY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_ADD_SID_HISTORY");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_ADD_SID_HISTORY");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_DsGetMemberships2(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_DsGetMemberships2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Request(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_DsGetMemberships2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_DsGetMemberships2(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_DsGetMemberships2 *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Request(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_DsGetMemberships2Ctr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_DsGetMemberships2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_DsGetMemberships2 *r)
{
	ndr_print_struct(ndr, name, "drsuapi_DsGetMemberships2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_DsGetMemberships2");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_DsGetMemberships2Request(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_DsGetMemberships2");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_DsGetMemberships2Ctr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ndr_push *ndr, ndr_flags_type flags, const struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ndr_pull *ndr, ndr_flags_type flags, struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_REPLICA_VERIFY_OBJECTS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_REPLICA_VERIFY_OBJECTS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_REPLICA_VERIFY_OBJECTS");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DRSUAPI_GET_OBJECT_EXISTENCE(struct ndr_push *ndr, ndr_flags_type flags, const struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DRSUAPI_GET_OBJECT_EXISTENCE(struct ndr_pull *ndr, ndr_flags_type flags, struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DRSUAPI_GET_OBJECT_EXISTENCE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DRSUAPI_GET_OBJECT_EXISTENCE *r)
{
	ndr_print_struct(ndr, name, "DRSUAPI_GET_OBJECT_EXISTENCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DRSUAPI_GET_OBJECT_EXISTENCE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DRSUAPI_GET_OBJECT_EXISTENCE");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_drsuapi_QuerySitesByCost(struct ndr_push *ndr, ndr_flags_type flags, const struct drsuapi_QuerySitesByCost *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.bind_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.req == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.level));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_push_drsuapi_QuerySitesByCostRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.level_out == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ctr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.level_out));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_push_drsuapi_QuerySitesByCostCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_drsuapi_QuerySitesByCost(struct ndr_pull *ndr, ndr_flags_type flags, struct drsuapi_QuerySitesByCost *r)
{
	TALLOC_CTX *_mem_save_bind_handle_0 = NULL;
	TALLOC_CTX *_mem_save_req_0 = NULL;
	TALLOC_CTX *_mem_save_level_out_0 = NULL;
	TALLOC_CTX *_mem_save_ctr_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
		}
		_mem_save_bind_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.bind_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.bind_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_bind_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.level));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.req);
		}
		_mem_save_req_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.req, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.req, r->in.level));
		NDR_CHECK(ndr_pull_drsuapi_QuerySitesByCostRequest(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.req));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_req_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.level_out);
		NDR_ZERO_STRUCTP(r->out.level_out);
		NDR_PULL_ALLOC(ndr, r->out.ctr);
		NDR_ZERO_STRUCTP(r->out.ctr);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.bind_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.bind_handle);
			NDR_ZERO_STRUCTP(r->in.bind_handle);
		}
		if (r->in.req == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.req);
			NDR_ZERO_STRUCTP(r->in.req);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.level_out);
		}
		_mem_save_level_out_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.level_out, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.level_out));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_level_out_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ctr);
		}
		_mem_save_ctr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ctr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ctr, *r->out.level_out));
		NDR_CHECK(ndr_pull_drsuapi_QuerySitesByCostCtr(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ctr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ctr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_drsuapi_QuerySitesByCost(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct drsuapi_QuerySitesByCost *r)
{
	ndr_print_struct(ndr, name, "drsuapi_QuerySitesByCost");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "drsuapi_QuerySitesByCost");
		ndr->depth++;
		ndr_print_ptr(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "bind_handle", r->in.bind_handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "req", r->in.req);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.req, r->in.level);
		ndr_print_drsuapi_QuerySitesByCostRequest(ndr, "req", r->in.req);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "drsuapi_QuerySitesByCost");
		ndr->depth++;
		ndr_print_ptr(ndr, "level_out", r->out.level_out);
		ndr->depth++;
		ndr_print_uint32(ndr, "level_out", *r->out.level_out);
		ndr->depth--;
		ndr_print_ptr(ndr, "ctr", r->out.ctr);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ctr, *r->out.level_out);
		ndr_print_drsuapi_QuerySitesByCostCtr(ndr, "ctr", r->out.ctr);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_drsuapi
static const struct ndr_interface_public_struct drsuapi_public_structs[] = {
	{
		.name = "drsuapi_DsBindInfo24",
		.struct_size = sizeof(struct drsuapi_DsBindInfo24 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsBindInfo24,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBindInfo24,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsBindInfo24,
	},
	{
		.name = "drsuapi_DsBindInfo28",
		.struct_size = sizeof(struct drsuapi_DsBindInfo28 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsBindInfo28,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBindInfo28,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsBindInfo28,
	},
	{
		.name = "drsuapi_DsBindInfo32",
		.struct_size = sizeof(struct drsuapi_DsBindInfo32 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsBindInfo32,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBindInfo32,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsBindInfo32,
	},
	{
		.name = "drsuapi_DsBindInfo48",
		.struct_size = sizeof(struct drsuapi_DsBindInfo48 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsBindInfo48,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBindInfo48,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsBindInfo48,
	},
	{
		.name = "drsuapi_DsBindInfo52",
		.struct_size = sizeof(struct drsuapi_DsBindInfo52 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsBindInfo52,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBindInfo52,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsBindInfo52,
	},
	{
		.name = "drsuapi_DsBindInfoFallBack",
		.struct_size = sizeof(struct drsuapi_DsBindInfoFallBack ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsBindInfoFallBack,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBindInfoFallBack,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsBindInfoFallBack,
	},
	{
		.name = "drsuapi_DsReplicaObjectIdentifier",
		.struct_size = sizeof(struct drsuapi_DsReplicaObjectIdentifier ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaObjectIdentifier,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaObjectIdentifier,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaObjectIdentifier,
	},
	{
		.name = "drsuapi_DsReplicaHighWaterMark",
		.struct_size = sizeof(struct drsuapi_DsReplicaHighWaterMark ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaHighWaterMark,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaHighWaterMark,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaHighWaterMark,
	},
	{
		.name = "drsuapi_DsReplicaCursor",
		.struct_size = sizeof(struct drsuapi_DsReplicaCursor ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaCursor,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaCursor,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaCursor,
	},
	{
		.name = "drsuapi_DsReplicaOIDMapping_Ctr",
		.struct_size = sizeof(struct drsuapi_DsReplicaOIDMapping_Ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaOIDMapping_Ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaOIDMapping_Ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaOIDMapping_Ctr,
	},
	{
		.name = "drsuapi_DsGetNCChangesRequest8",
		.struct_size = sizeof(struct drsuapi_DsGetNCChangesRequest8 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChangesRequest8,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChangesRequest8,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsGetNCChangesRequest8,
	},
	{
		.name = "drsuapi_DsGetNCChangesRequest10",
		.struct_size = sizeof(struct drsuapi_DsGetNCChangesRequest10 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChangesRequest10,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChangesRequest10,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsGetNCChangesRequest10,
	},
	{
		.name = "drsuapi_DsReplicaCursor2",
		.struct_size = sizeof(struct drsuapi_DsReplicaCursor2 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaCursor2,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaCursor2,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaCursor2,
	},
	{
		.name = "drsuapi_DsReplicaObjectIdentifier3",
		.struct_size = sizeof(struct drsuapi_DsReplicaObjectIdentifier3 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaObjectIdentifier3,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaObjectIdentifier3,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaObjectIdentifier3,
	},
	{
		.name = "drsuapi_DsReplicaObjectIdentifier3Binary",
		.struct_size = sizeof(struct drsuapi_DsReplicaObjectIdentifier3Binary ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaObjectIdentifier3Binary,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaObjectIdentifier3Binary,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaObjectIdentifier3Binary,
	},
	{
		.name = "drsuapi_DsReplicaAttribute",
		.struct_size = sizeof(struct drsuapi_DsReplicaAttribute ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaAttribute,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaAttribute,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaAttribute,
	},
	{
		.name = "drsuapi_DsReplicaObject",
		.struct_size = sizeof(struct drsuapi_DsReplicaObject ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaObject,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaObject,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaObject,
	},
	{
		.name = "drsuapi_DsReplicaMetaDataCtr",
		.struct_size = sizeof(struct drsuapi_DsReplicaMetaDataCtr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaMetaDataCtr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaMetaDataCtr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaMetaDataCtr,
	},
	{
		.name = "drsuapi_DsReplicaObjectListItemEx",
		.struct_size = sizeof(struct drsuapi_DsReplicaObjectListItemEx ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaObjectListItemEx,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaObjectListItemEx,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaObjectListItemEx,
	},
	{
		.name = "drsuapi_DsGetNCChangesCtr1",
		.struct_size = sizeof(struct drsuapi_DsGetNCChangesCtr1 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChangesCtr1,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChangesCtr1,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsGetNCChangesCtr1,
	},
	{
		.name = "drsuapi_DsReplicaLinkedAttribute",
		.struct_size = sizeof(struct drsuapi_DsReplicaLinkedAttribute ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaLinkedAttribute,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaLinkedAttribute,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaLinkedAttribute,
	},
	{
		.name = "drsuapi_DsGetNCChangesCtr6",
		.struct_size = sizeof(struct drsuapi_DsGetNCChangesCtr6 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChangesCtr6,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChangesCtr6,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsGetNCChangesCtr6,
	},
	{
		.name = "drsuapi_DsGetNCChangesCtr1TS",
		.struct_size = sizeof(struct drsuapi_DsGetNCChangesCtr1TS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChangesCtr1TS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChangesCtr1TS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsGetNCChangesCtr1TS,
	},
	{
		.name = "drsuapi_DsGetNCChangesCtr6TS",
		.struct_size = sizeof(struct drsuapi_DsGetNCChangesCtr6TS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChangesCtr6TS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChangesCtr6TS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsGetNCChangesCtr6TS,
	},
	{
		.name = "drsuapi_DsReplicaObjectListItem",
		.struct_size = sizeof(struct drsuapi_DsReplicaObjectListItem ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaObjectListItem,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaObjectListItem,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_drsuapi_DsReplicaObjectListItem,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call drsuapi_calls[] = {
	{
		"drsuapi_DsBind",
		sizeof(struct drsuapi_DsBind),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsBind,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsBind,
		(ndr_print_function_t) ndr_print_drsuapi_DsBind,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsUnbind",
		sizeof(struct drsuapi_DsUnbind),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsUnbind,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsUnbind,
		(ndr_print_function_t) ndr_print_drsuapi_DsUnbind,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsReplicaSync",
		sizeof(struct drsuapi_DsReplicaSync),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaSync,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaSync,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaSync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsGetNCChanges",
		sizeof(struct drsuapi_DsGetNCChanges),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNCChanges,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNCChanges,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetNCChanges,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsReplicaUpdateRefs",
		sizeof(struct drsuapi_DsReplicaUpdateRefs),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaUpdateRefs,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaUpdateRefs,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaUpdateRefs,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsReplicaAdd",
		sizeof(struct drsuapi_DsReplicaAdd),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaAdd,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaAdd,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaAdd,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsReplicaDel",
		sizeof(struct drsuapi_DsReplicaDel),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaDel,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaDel,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaDel,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsReplicaMod",
		sizeof(struct drsuapi_DsReplicaMod),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaMod,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaMod,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaMod,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DRSUAPI_VERIFY_NAMES",
		sizeof(struct DRSUAPI_VERIFY_NAMES),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_VERIFY_NAMES,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_VERIFY_NAMES,
		(ndr_print_function_t) ndr_print_DRSUAPI_VERIFY_NAMES,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsGetMemberships",
		sizeof(struct drsuapi_DsGetMemberships),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetMemberships,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetMemberships,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetMemberships,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DRSUAPI_INTER_DOMAIN_MOVE",
		sizeof(struct DRSUAPI_INTER_DOMAIN_MOVE),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_INTER_DOMAIN_MOVE,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_INTER_DOMAIN_MOVE,
		(ndr_print_function_t) ndr_print_DRSUAPI_INTER_DOMAIN_MOVE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsGetNT4ChangeLog",
		sizeof(struct drsuapi_DsGetNT4ChangeLog),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetNT4ChangeLog,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetNT4ChangeLog,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetNT4ChangeLog,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsCrackNames",
		sizeof(struct drsuapi_DsCrackNames),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsCrackNames,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsCrackNames,
		(ndr_print_function_t) ndr_print_drsuapi_DsCrackNames,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsWriteAccountSpn",
		sizeof(struct drsuapi_DsWriteAccountSpn),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsWriteAccountSpn,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsWriteAccountSpn,
		(ndr_print_function_t) ndr_print_drsuapi_DsWriteAccountSpn,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsRemoveDSServer",
		sizeof(struct drsuapi_DsRemoveDSServer),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsRemoveDSServer,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsRemoveDSServer,
		(ndr_print_function_t) ndr_print_drsuapi_DsRemoveDSServer,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DRSUAPI_REMOVE_DS_DOMAIN",
		sizeof(struct DRSUAPI_REMOVE_DS_DOMAIN),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REMOVE_DS_DOMAIN,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REMOVE_DS_DOMAIN,
		(ndr_print_function_t) ndr_print_DRSUAPI_REMOVE_DS_DOMAIN,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsGetDomainControllerInfo",
		sizeof(struct drsuapi_DsGetDomainControllerInfo),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetDomainControllerInfo,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetDomainControllerInfo,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetDomainControllerInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsAddEntry",
		sizeof(struct drsuapi_DsAddEntry),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsAddEntry,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsAddEntry,
		(ndr_print_function_t) ndr_print_drsuapi_DsAddEntry,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsExecuteKCC",
		sizeof(struct drsuapi_DsExecuteKCC),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsExecuteKCC,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsExecuteKCC,
		(ndr_print_function_t) ndr_print_drsuapi_DsExecuteKCC,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsReplicaGetInfo",
		sizeof(struct drsuapi_DsReplicaGetInfo),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsReplicaGetInfo,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsReplicaGetInfo,
		(ndr_print_function_t) ndr_print_drsuapi_DsReplicaGetInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DRSUAPI_ADD_SID_HISTORY",
		sizeof(struct DRSUAPI_ADD_SID_HISTORY),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_ADD_SID_HISTORY,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_ADD_SID_HISTORY,
		(ndr_print_function_t) ndr_print_DRSUAPI_ADD_SID_HISTORY,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_DsGetMemberships2",
		sizeof(struct drsuapi_DsGetMemberships2),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_DsGetMemberships2,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_DsGetMemberships2,
		(ndr_print_function_t) ndr_print_drsuapi_DsGetMemberships2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DRSUAPI_REPLICA_VERIFY_OBJECTS",
		sizeof(struct DRSUAPI_REPLICA_VERIFY_OBJECTS),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_REPLICA_VERIFY_OBJECTS,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_REPLICA_VERIFY_OBJECTS,
		(ndr_print_function_t) ndr_print_DRSUAPI_REPLICA_VERIFY_OBJECTS,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DRSUAPI_GET_OBJECT_EXISTENCE",
		sizeof(struct DRSUAPI_GET_OBJECT_EXISTENCE),
		(ndr_push_flags_fn_t) ndr_push_DRSUAPI_GET_OBJECT_EXISTENCE,
		(ndr_pull_flags_fn_t) ndr_pull_DRSUAPI_GET_OBJECT_EXISTENCE,
		(ndr_print_function_t) ndr_print_DRSUAPI_GET_OBJECT_EXISTENCE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"drsuapi_QuerySitesByCost",
		sizeof(struct drsuapi_QuerySitesByCost),
		(ndr_push_flags_fn_t) ndr_push_drsuapi_QuerySitesByCost,
		(ndr_pull_flags_fn_t) ndr_pull_drsuapi_QuerySitesByCost,
		(ndr_print_function_t) ndr_print_drsuapi_QuerySitesByCost,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const drsuapi_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\lsass]", 
	"ncacn_np:[\\pipe\\protected_storage]", 
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array drsuapi_endpoints = {
	.count	= 4,
	.names	= drsuapi_endpoint_strings
};

static const char * const drsuapi_authservice_strings[] = {
	"ldap", 
};

static const struct ndr_interface_string_array drsuapi_authservices = {
	.count	= 1,
	.names	= drsuapi_authservice_strings
};


const struct ndr_interface_table ndr_table_drsuapi = {
	.name		= "drsuapi",
	.syntax_id	= {
		{0xe3514235,0x4b06,0x11d1,{0xab,0x04},{0x00,0xc0,0x4f,0xc2,0xdc,0xd2}},
		NDR_DRSUAPI_VERSION
	},
	.helpstring	= NDR_DRSUAPI_HELPSTRING,
	.num_calls	= 25,
	.calls		= drsuapi_calls,
	.num_public_structs	= 25,
	.public_structs		= drsuapi_public_structs,
	.endpoints	= &drsuapi_endpoints,
	.authservices	= &drsuapi_authservices
};

#endif /* SKIP_NDR_TABLE_drsuapi */
