/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_dnsserver.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_dnsp.h"
static enum ndr_err_code ndr_push_DNS_RPC_CLIENT_VERSION(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_RPC_CLIENT_VERSION r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_CLIENT_VERSION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_RPC_CLIENT_VERSION *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_CLIENT_VERSION(struct ndr_print *ndr, const char *name, enum DNS_RPC_CLIENT_VERSION r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_CLIENT_VERSION_W2K: val = "DNS_CLIENT_VERSION_W2K"; break;
		case DNS_CLIENT_VERSION_DOTNET: val = "DNS_CLIENT_VERSION_DOTNET"; break;
		case DNS_CLIENT_VERSION_LONGHORN: val = "DNS_CLIENT_VERSION_LONGHORN"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_RPC_BUFFER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_BUFFER *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwLength));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLength));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Buffer, r->dwLength));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_BUFFER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_BUFFER *r)
{
	uint32_t size_Buffer_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->Buffer));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLength));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->Buffer, &size_Buffer_0));
		NDR_PULL_ALLOC_N(ndr, r->Buffer, size_Buffer_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Buffer, size_Buffer_0));
		if (r->Buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->Buffer, r->dwLength));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_BUFFER(struct ndr_print *ndr, const char *name, const struct DNS_RPC_BUFFER *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_BUFFER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwLength", r->dwLength);
	ndr_print_array_uint8(ndr, "Buffer", r->Buffer, r->dwLength);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_UTF8_STRING_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_UTF8_STRING_LIST *r)
{
	uint32_t cntr_pszStrings_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwCount));
		for (cntr_pszStrings_0 = 0; cntr_pszStrings_0 < (r->dwCount); cntr_pszStrings_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszStrings[cntr_pszStrings_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_pszStrings_0 = 0; cntr_pszStrings_0 < (r->dwCount); cntr_pszStrings_0++) {
			if (r->pszStrings[cntr_pszStrings_0]) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszStrings[cntr_pszStrings_0], CH_UTF8)));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszStrings[cntr_pszStrings_0], CH_UTF8)));
				NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszStrings[cntr_pszStrings_0], ndr_charset_length(r->pszStrings[cntr_pszStrings_0], CH_UTF8), sizeof(uint8_t), CH_UTF8));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_UTF8_STRING_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_UTF8_STRING_LIST *r)
{
	uint32_t _ptr_pszStrings;
	uint32_t size_pszStrings_0 = 0;
	uint32_t cntr_pszStrings_0;
	uint32_t size_pszStrings_2 = 0;
	uint32_t length_pszStrings_2 = 0;
	TALLOC_CTX *_mem_save_pszStrings_0 = NULL;
	TALLOC_CTX *_mem_save_pszStrings_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->pszStrings));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwCount));
		if (r->dwCount > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->dwCount), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pszStrings, &size_pszStrings_0));
		NDR_PULL_ALLOC_N(ndr, r->pszStrings, size_pszStrings_0);
		_mem_save_pszStrings_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->pszStrings, 0);
		for (cntr_pszStrings_0 = 0; cntr_pszStrings_0 < (size_pszStrings_0); cntr_pszStrings_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszStrings));
			if (_ptr_pszStrings) {
				NDR_PULL_ALLOC(ndr, r->pszStrings[cntr_pszStrings_0]);
			} else {
				r->pszStrings[cntr_pszStrings_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszStrings_0, 0);
		if (r->pszStrings) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pszStrings, r->dwCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pszStrings, &size_pszStrings_0));
		_mem_save_pszStrings_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->pszStrings, 0);
		for (cntr_pszStrings_0 = 0; cntr_pszStrings_0 < (size_pszStrings_0); cntr_pszStrings_0++) {
			if (r->pszStrings[cntr_pszStrings_0]) {
				_mem_save_pszStrings_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->pszStrings[cntr_pszStrings_0], 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->pszStrings[cntr_pszStrings_0]));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->pszStrings[cntr_pszStrings_0]));
				NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszStrings[cntr_pszStrings_0], &size_pszStrings_2));
				NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszStrings[cntr_pszStrings_0], &length_pszStrings_2));
				if (length_pszStrings_2 > size_pszStrings_2) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszStrings_2, length_pszStrings_2);
				}
				NDR_CHECK(ndr_check_string_terminator(ndr, length_pszStrings_2, sizeof(uint8_t)));
				NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszStrings[cntr_pszStrings_0], length_pszStrings_2, sizeof(uint8_t), CH_UTF8));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszStrings_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszStrings_0, 0);
		for (cntr_pszStrings_0 = 0; cntr_pszStrings_0 < (size_pszStrings_0); cntr_pszStrings_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_UTF8_STRING_LIST(struct ndr_print *ndr, const char *name, const struct DNS_RPC_UTF8_STRING_LIST *r)
{
	uint32_t cntr_pszStrings_0;
	ndr_print_struct(ndr, name, "DNS_RPC_UTF8_STRING_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwCount", r->dwCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pszStrings", (uint32_t)(r->dwCount));
	ndr->depth++;
	for (cntr_pszStrings_0 = 0; cntr_pszStrings_0 < (r->dwCount); cntr_pszStrings_0++) {
		ndr_print_ptr(ndr, "pszStrings", r->pszStrings[cntr_pszStrings_0]);
		ndr->depth++;
		if (r->pszStrings[cntr_pszStrings_0]) {
			ndr_print_string(ndr, "pszStrings", r->pszStrings[cntr_pszStrings_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_NAME_AND_PARAM(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_NAME_AND_PARAM *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwParam));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszNodeName));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszNodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszNodeName, ndr_charset_length(r->pszNodeName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_NAME_AND_PARAM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_NAME_AND_PARAM *r)
{
	uint32_t _ptr_pszNodeName;
	uint32_t size_pszNodeName_1 = 0;
	uint32_t length_pszNodeName_1 = 0;
	TALLOC_CTX *_mem_save_pszNodeName_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwParam));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszNodeName));
		if (_ptr_pszNodeName) {
			NDR_PULL_ALLOC(ndr, r->pszNodeName);
		} else {
			r->pszNodeName = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszNodeName) {
			_mem_save_pszNodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszNodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszNodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszNodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszNodeName, &size_pszNodeName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszNodeName, &length_pszNodeName_1));
			if (length_pszNodeName_1 > size_pszNodeName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNodeName_1, length_pszNodeName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNodeName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszNodeName, length_pszNodeName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszNodeName_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_NAME_AND_PARAM(struct ndr_print *ndr, const char *name, const struct DNS_RPC_NAME_AND_PARAM *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_NAME_AND_PARAM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwParam", r->dwParam);
	ndr_print_ptr(ndr, "pszNodeName", r->pszNodeName);
	ndr->depth++;
	if (r->pszNodeName) {
		ndr_print_string(ndr, "pszNodeName", r->pszNodeName);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_DNS_RPC_NAME(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_NAME *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, strlen(r->str)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->str, strlen(r->str), sizeof(uint8_t), CH_UNIX));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DNS_RPC_NAME(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_NAME *r)
{
	uint32_t size_str_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->len));
		size_str_0 = r->len;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->str, size_str_0, sizeof(uint8_t), CH_UNIX));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_DNS_RPC_NAME(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct DNS_RPC_NAME *r)
{
	ndr_print_DNS_RPC_NAME(ndr, name, r);
}

_PUBLIC_ void ndr_print_DNS_RPC_NAME(struct ndr_print *ndr, const char *name, const struct DNS_RPC_NAME *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_NAME");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->str):r->len);
	ndr_print_string(ndr, "str", r->str);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_DNS_RPC_NAME(const struct DNS_RPC_NAME *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_NAME);
}

static enum ndr_err_code ndr_push_DNS_RPC_RECORD_SOA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_RECORD_SOA *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwSerialNo));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRefresh));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRetry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwExpire));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwMinimumTtl));
		NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->NamePrimaryServer));
		NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->ZoneAdministratorEmail));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_RECORD_SOA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_RECORD_SOA *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSerialNo));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRefresh));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRetry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwExpire));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwMinimumTtl));
		NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->NamePrimaryServer));
		NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->ZoneAdministratorEmail));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD_SOA(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORD_SOA *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_RECORD_SOA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwSerialNo", r->dwSerialNo);
	ndr_print_uint32(ndr, "dwRefresh", r->dwRefresh);
	ndr_print_uint32(ndr, "dwRetry", r->dwRetry);
	ndr_print_uint32(ndr, "dwExpire", r->dwExpire);
	ndr_print_uint32(ndr, "dwMinimumTtl", r->dwMinimumTtl);
	ndr_print_DNS_RPC_NAME(ndr, "NamePrimaryServer", &r->NamePrimaryServer);
	ndr_print_DNS_RPC_NAME(ndr, "ZoneAdministratorEmail", &r->ZoneAdministratorEmail);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_RECORD_NAME_PREFERENCE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_RECORD_NAME_PREFERENCE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPreference));
		NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->nameExchange));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_RECORD_NAME_PREFERENCE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_RECORD_NAME_PREFERENCE *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPreference));
		NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->nameExchange));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD_NAME_PREFERENCE(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORD_NAME_PREFERENCE *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_RECORD_NAME_PREFERENCE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wPreference", r->wPreference);
	ndr_print_DNS_RPC_NAME(ndr, "nameExchange", &r->nameExchange);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD_STRING(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORD_STRING *r)
{
	uint32_t cntr_str_0;
	ndr_print_struct(ndr, name, "DNS_RPC_RECORD_STRING");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "str", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_str_0 = 0; cntr_str_0 < (r->count); cntr_str_0++) {
		ndr_print_DNS_RPC_NAME(ndr, "str", &r->str[cntr_str_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_RECORD_SRV(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_RECORD_SRV *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPriority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wWeight));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPort));
		NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->nameTarget));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_RECORD_SRV(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_RECORD_SRV *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPriority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wWeight));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPort));
		NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->nameTarget));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD_SRV(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORD_SRV *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_RECORD_SRV");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wPriority", r->wPriority);
	ndr_print_uint16(ndr, "wWeight", r->wWeight);
	ndr_print_uint16(ndr, "wPort", r->wPort);
	ndr_print_DNS_RPC_NAME(ndr, "nameTarget", &r->nameTarget);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_RECORD_DATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union DNS_RPC_RECORD_DATA *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 4));
			switch (level) {
				case DNS_TYPE_TOMBSTONE: {
					NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->EntombedTime));
				break; }

				case DNS_TYPE_A: {
					{
						libndr_flags _flags_save_ipv4address = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
						NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
						ndr->flags = _flags_save_ipv4address;
					}
				break; }

				case DNS_TYPE_NS: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MD: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MF: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_CNAME: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_SOA: {
					NDR_CHECK(ndr_push_DNS_RPC_RECORD_SOA(ndr, NDR_SCALARS, &r->soa));
				break; }

				case DNS_TYPE_MB: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MG: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MR: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_PTR: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->ptr));
				break; }

				case DNS_TYPE_HINFO: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->hinfo));
				break; }

				case DNS_TYPE_MX: {
					NDR_CHECK(ndr_push_DNS_RPC_RECORD_NAME_PREFERENCE(ndr, NDR_SCALARS, &r->mx));
				break; }

				case DNS_TYPE_TXT: {
					NDR_CHECK(ndr_push_DNS_RPC_RECORD_STRING(ndr, NDR_SCALARS, &r->txt));
				break; }

				case DNS_TYPE_AAAA: {
					NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
				break; }

				case DNS_TYPE_SRV: {
					NDR_CHECK(ndr_push_DNS_RPC_RECORD_SRV(ndr, NDR_SCALARS, &r->srv));
				break; }

				case DNS_TYPE_DNAME: {
					NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case DNS_TYPE_TOMBSTONE:
				break;

				case DNS_TYPE_A:
				break;

				case DNS_TYPE_NS:
				break;

				case DNS_TYPE_MD:
				break;

				case DNS_TYPE_MF:
				break;

				case DNS_TYPE_CNAME:
				break;

				case DNS_TYPE_SOA:
				break;

				case DNS_TYPE_MB:
				break;

				case DNS_TYPE_MG:
				break;

				case DNS_TYPE_MR:
				break;

				case DNS_TYPE_PTR:
				break;

				case DNS_TYPE_HINFO:
				break;

				case DNS_TYPE_MX:
				break;

				case DNS_TYPE_TXT:
				break;

				case DNS_TYPE_AAAA:
				break;

				case DNS_TYPE_SRV:
				break;

				case DNS_TYPE_DNAME:
				break;

				default:
					return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_RECORD_DATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union DNS_RPC_RECORD_DATA *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 4));
			switch (level) {
				case DNS_TYPE_TOMBSTONE: {
					NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->EntombedTime));
				break; }

				case DNS_TYPE_A: {
					{
						libndr_flags _flags_save_ipv4address = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
						NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
						ndr->flags = _flags_save_ipv4address;
					}
				break; }

				case DNS_TYPE_NS: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MD: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MF: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_CNAME: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_SOA: {
					NDR_CHECK(ndr_pull_DNS_RPC_RECORD_SOA(ndr, NDR_SCALARS, &r->soa));
				break; }

				case DNS_TYPE_MB: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MG: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_MR: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				case DNS_TYPE_PTR: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->ptr));
				break; }

				case DNS_TYPE_HINFO: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->hinfo));
				break; }

				case DNS_TYPE_MX: {
					NDR_CHECK(ndr_pull_DNS_RPC_RECORD_NAME_PREFERENCE(ndr, NDR_SCALARS, &r->mx));
				break; }

				case DNS_TYPE_TXT: {
					NDR_CHECK(ndr_pull_DNS_RPC_RECORD_STRING(ndr, NDR_SCALARS, &r->txt));
				break; }

				case DNS_TYPE_AAAA: {
					NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
				break; }

				case DNS_TYPE_SRV: {
					NDR_CHECK(ndr_pull_DNS_RPC_RECORD_SRV(ndr, NDR_SCALARS, &r->srv));
				break; }

				case DNS_TYPE_DNAME: {
					NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->name));
				break; }

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case DNS_TYPE_TOMBSTONE:
				break;

				case DNS_TYPE_A:
				break;

				case DNS_TYPE_NS:
				break;

				case DNS_TYPE_MD:
				break;

				case DNS_TYPE_MF:
				break;

				case DNS_TYPE_CNAME:
				break;

				case DNS_TYPE_SOA:
				break;

				case DNS_TYPE_MB:
				break;

				case DNS_TYPE_MG:
				break;

				case DNS_TYPE_MR:
				break;

				case DNS_TYPE_PTR:
				break;

				case DNS_TYPE_HINFO:
				break;

				case DNS_TYPE_MX:
				break;

				case DNS_TYPE_TXT:
				break;

				case DNS_TYPE_AAAA:
				break;

				case DNS_TYPE_SRV:
				break;

				case DNS_TYPE_DNAME:
				break;

				default:
					return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD_DATA(struct ndr_print *ndr, const char *name, const union DNS_RPC_RECORD_DATA *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "DNS_RPC_RECORD_DATA");
		switch (level) {
			case DNS_TYPE_TOMBSTONE:
				ndr_print_NTTIME(ndr, "EntombedTime", r->EntombedTime);
			break;

			case DNS_TYPE_A:
				{
					libndr_flags _flags_save_ipv4address = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
					ndr->flags = _flags_save_ipv4address;
				}
			break;

			case DNS_TYPE_NS:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_MD:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_MF:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_CNAME:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_SOA:
				ndr_print_DNS_RPC_RECORD_SOA(ndr, "soa", &r->soa);
			break;

			case DNS_TYPE_MB:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_MG:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_MR:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			case DNS_TYPE_PTR:
				ndr_print_DNS_RPC_NAME(ndr, "ptr", &r->ptr);
			break;

			case DNS_TYPE_HINFO:
				ndr_print_DNS_RPC_NAME(ndr, "hinfo", &r->hinfo);
			break;

			case DNS_TYPE_MX:
				ndr_print_DNS_RPC_RECORD_NAME_PREFERENCE(ndr, "mx", &r->mx);
			break;

			case DNS_TYPE_TXT:
				ndr_print_DNS_RPC_RECORD_STRING(ndr, "txt", &r->txt);
			break;

			case DNS_TYPE_AAAA:
				ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
			break;

			case DNS_TYPE_SRV:
				ndr_print_DNS_RPC_RECORD_SRV(ndr, "srv", &r->srv);
			break;

			case DNS_TYPE_DNAME:
				ndr_print_DNS_RPC_NAME(ndr, "name", &r->name);
			break;

			default:
				ndr_print_bad_level(ndr, name, level);
		}
		ndr->flags = _flags_save_UNION;
	}
}

static size_t ndr_size_DNS_RPC_RECORD_DATA(const union DNS_RPC_RECORD_DATA *r, uint32_t level, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_NOALIGN;
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORD_DATA);
}

_PUBLIC_ enum ndr_err_code ndr_push_DNS_RPC_RECORD(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_RECORD *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_DNS_RPC_RECORD_DATA(&r->data, r->wType, 0)));
		NDR_CHECK(ndr_push_dns_record_type(ndr, NDR_SCALARS, r->wType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwSerial));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTtlSeconds));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTimeStamp));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved));
		{
			struct ndr_push *_ndr_data;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_data, 0, ndr_size_DNS_RPC_RECORD_DATA(&r->data, r->wType, 0)));
			NDR_CHECK(ndr_push_set_switch_value(_ndr_data, &r->data, r->wType));
			NDR_CHECK(ndr_push_DNS_RPC_RECORD_DATA(_ndr_data, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_data, 0, ndr_size_DNS_RPC_RECORD_DATA(&r->data, r->wType, 0)));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DNS_RPC_RECORD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_RECORD *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wDataLength));
		NDR_CHECK(ndr_pull_dns_record_type(ndr, NDR_SCALARS, &r->wType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSerial));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTtlSeconds));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTimeStamp));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved));
		{
			struct ndr_pull *_ndr_data;
			ssize_t sub_size = r->wDataLength;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_data, 0, sub_size));
			NDR_CHECK(ndr_pull_set_switch_value(_ndr_data, &r->data, r->wType));
			NDR_CHECK(ndr_pull_DNS_RPC_RECORD_DATA(_ndr_data, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_data, 0, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_DNS_RPC_RECORD(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct DNS_RPC_RECORD *r)
{
	ndr_print_DNS_RPC_RECORD(ndr, name, r);
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORD *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_RECORD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wDataLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DNS_RPC_RECORD_DATA(&r->data, r->wType, 0):r->wDataLength);
	ndr_print_dns_record_type(ndr, "wType", r->wType);
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_uint32(ndr, "dwSerial", r->dwSerial);
	ndr_print_uint32(ndr, "dwTtlSeconds", r->dwTtlSeconds);
	ndr_print_uint32(ndr, "dwTimeStamp", r->dwTimeStamp);
	ndr_print_uint32(ndr, "dwReserved", r->dwReserved);
	ndr_print_set_switch_value(ndr, &r->data, r->wType);
	ndr_print_DNS_RPC_RECORD_DATA(ndr, "data", &r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_RECORD_BUF(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_RECORD_BUF *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_size_DNS_RPC_RECORD_DATA(&r->rec.data, r->rec.wType, 0)));
		NDR_CHECK(ndr_push_DNS_RPC_RECORD(ndr, NDR_SCALARS, &r->rec));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_RECORD_BUF(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_RECORD_BUF *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->wContextLength));
		NDR_CHECK(ndr_pull_DNS_RPC_RECORD(ndr, NDR_SCALARS, &r->rec));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORD_BUF(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORD_BUF *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_RECORD_BUF");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint3264(ndr, "wContextLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_DNS_RPC_RECORD_DATA(&r->rec.data, r->rec.wType, 0):r->wContextLength);
	ndr_print_DNS_RPC_RECORD(ndr, "rec", &r->rec);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_IP4_ARRAY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct IP4_ARRAY *r)
{
	uint32_t cntr_AddrArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->AddrCount));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->AddrCount));
		for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (r->AddrCount); cntr_AddrArray_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->AddrArray[cntr_AddrArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_IP4_ARRAY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct IP4_ARRAY *r)
{
	uint32_t size_AddrArray_0 = 0;
	uint32_t cntr_AddrArray_0;
	TALLOC_CTX *_mem_save_AddrArray_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->AddrArray));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->AddrCount));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->AddrArray, &size_AddrArray_0));
		NDR_PULL_ALLOC_N(ndr, r->AddrArray, size_AddrArray_0);
		_mem_save_AddrArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->AddrArray, 0);
		for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (size_AddrArray_0); cntr_AddrArray_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->AddrArray[cntr_AddrArray_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AddrArray_0, 0);
		if (r->AddrArray) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->AddrArray, r->AddrCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_IP4_ARRAY(struct ndr_print *ndr, const char *name, const struct IP4_ARRAY *r)
{
	uint32_t cntr_AddrArray_0;
	ndr_print_struct(ndr, name, "IP4_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "AddrCount", r->AddrCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "AddrArray", (uint32_t)(r->AddrCount));
	ndr->depth++;
	for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (r->AddrCount); cntr_AddrArray_0++) {
		ndr_print_uint32(ndr, "AddrArray", r->AddrArray[cntr_AddrArray_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_ADDR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_ADDR *r)
{
	uint32_t cntr_DnsAddrUserDword_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->MaxSa, 32));
		for (cntr_DnsAddrUserDword_0 = 0; cntr_DnsAddrUserDword_0 < (8); cntr_DnsAddrUserDword_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->DnsAddrUserDword[cntr_DnsAddrUserDword_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_ADDR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_ADDR *r)
{
	uint32_t size_MaxSa_0 = 0;
	uint32_t size_DnsAddrUserDword_0 = 0;
	uint32_t cntr_DnsAddrUserDword_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		size_MaxSa_0 = 32;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->MaxSa, size_MaxSa_0));
		size_DnsAddrUserDword_0 = 8;
		for (cntr_DnsAddrUserDword_0 = 0; cntr_DnsAddrUserDword_0 < (size_DnsAddrUserDword_0); cntr_DnsAddrUserDword_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->DnsAddrUserDword[cntr_DnsAddrUserDword_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_ADDR(struct ndr_print *ndr, const char *name, const struct DNS_ADDR *r)
{
	uint32_t cntr_DnsAddrUserDword_0;
	ndr_print_struct(ndr, name, "DNS_ADDR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "MaxSa", r->MaxSa, 32);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "DnsAddrUserDword", (uint32_t)(8));
	ndr->depth++;
	for (cntr_DnsAddrUserDword_0 = 0; cntr_DnsAddrUserDword_0 < (8); cntr_DnsAddrUserDword_0++) {
		ndr_print_uint32(ndr, "DnsAddrUserDword", r->DnsAddrUserDword[cntr_DnsAddrUserDword_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_ADDR_ARRAY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_ADDR_ARRAY *r)
{
	uint32_t cntr_AddrArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->AddrCount));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MaxCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->AddrCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Tag));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Family));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->WordReserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MatchFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved2));
		for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (r->AddrCount); cntr_AddrArray_0++) {
			NDR_CHECK(ndr_push_DNS_ADDR(ndr, NDR_SCALARS, &r->AddrArray[cntr_AddrArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_ADDR_ARRAY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_ADDR_ARRAY *r)
{
	uint32_t size_AddrArray_0 = 0;
	uint32_t cntr_AddrArray_0;
	TALLOC_CTX *_mem_save_AddrArray_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->AddrArray));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MaxCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->AddrCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Tag));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Family));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WordReserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MatchFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved2));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->AddrArray, &size_AddrArray_0));
		NDR_PULL_ALLOC_N(ndr, r->AddrArray, size_AddrArray_0);
		_mem_save_AddrArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->AddrArray, 0);
		for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (size_AddrArray_0); cntr_AddrArray_0++) {
			NDR_CHECK(ndr_pull_DNS_ADDR(ndr, NDR_SCALARS, &r->AddrArray[cntr_AddrArray_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AddrArray_0, 0);
		if (r->AddrArray) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->AddrArray, r->AddrCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_ADDR_ARRAY(struct ndr_print *ndr, const char *name, const struct DNS_ADDR_ARRAY *r)
{
	uint32_t cntr_AddrArray_0;
	ndr_print_struct(ndr, name, "DNS_ADDR_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "MaxCount", r->MaxCount);
	ndr_print_uint32(ndr, "AddrCount", r->AddrCount);
	ndr_print_uint32(ndr, "Tag", r->Tag);
	ndr_print_uint16(ndr, "Family", r->Family);
	ndr_print_uint16(ndr, "WordReserved", r->WordReserved);
	ndr_print_uint32(ndr, "Flags", r->Flags);
	ndr_print_uint32(ndr, "MatchFlag", r->MatchFlag);
	ndr_print_uint32(ndr, "Reserved1", r->Reserved1);
	ndr_print_uint32(ndr, "Reserved2", r->Reserved2);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "AddrArray", (uint32_t)(r->AddrCount));
	ndr->depth++;
	for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (r->AddrCount); cntr_AddrArray_0++) {
		ndr_print_DNS_ADDR(ndr, "AddrArray", &r->AddrArray[cntr_AddrArray_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_IP_VALIDATE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_IP_VALIDATE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwContext));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszContextName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipValidateAddrs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszContextName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszContextName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszContextName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszContextName, ndr_charset_length(r->pszContextName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipValidateAddrs) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipValidateAddrs));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_IP_VALIDATE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_IP_VALIDATE *r)
{
	uint32_t _ptr_pszContextName;
	uint32_t size_pszContextName_1 = 0;
	uint32_t length_pszContextName_1 = 0;
	TALLOC_CTX *_mem_save_pszContextName_0 = NULL;
	uint32_t _ptr_aipValidateAddrs;
	TALLOC_CTX *_mem_save_aipValidateAddrs_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwContext));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszContextName));
		if (_ptr_pszContextName) {
			NDR_PULL_ALLOC(ndr, r->pszContextName);
		} else {
			r->pszContextName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipValidateAddrs));
		if (_ptr_aipValidateAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipValidateAddrs);
		} else {
			r->aipValidateAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszContextName) {
			_mem_save_pszContextName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszContextName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszContextName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszContextName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszContextName, &size_pszContextName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszContextName, &length_pszContextName_1));
			if (length_pszContextName_1 > size_pszContextName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszContextName_1, length_pszContextName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszContextName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszContextName, length_pszContextName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszContextName_0, 0);
		}
		if (r->aipValidateAddrs) {
			_mem_save_aipValidateAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipValidateAddrs, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipValidateAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipValidateAddrs_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_IP_VALIDATE(struct ndr_print *ndr, const char *name, const struct DNS_RPC_IP_VALIDATE *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_IP_VALIDATE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "dwContext", r->dwContext);
	ndr_print_uint32(ndr, "dwReserved1", r->dwReserved1);
	ndr_print_ptr(ndr, "pszContextName", r->pszContextName);
	ndr->depth++;
	if (r->pszContextName) {
		ndr_print_string(ndr, "pszContextName", r->pszContextName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipValidateAddrs", r->aipValidateAddrs);
	ndr->depth++;
	if (r->aipValidateAddrs) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipValidateAddrs", r->aipValidateAddrs);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_BOOT_METHOD(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_BOOT_METHOD r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_BOOT_METHOD(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_BOOT_METHOD *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_BOOT_METHOD(struct ndr_print *ndr, const char *name, enum DNS_BOOT_METHOD r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_BOOT_METHOD_UNINITIALIZED: val = "DNS_BOOT_METHOD_UNINITIALIZED"; break;
		case DNS_BOOT_METHOD_FILE: val = "DNS_BOOT_METHOD_FILE"; break;
		case DNS_BOOT_METHOD_REGISTRY: val = "DNS_BOOT_METHOD_REGISTRY"; break;
		case DNS_BOOT_METHOD_DIRECTORY: val = "DNS_BOOT_METHOD_DIRECTORY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_NAME_CHECK_FLAG(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_NAME_CHECK_FLAG r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_NAME_CHECK_FLAG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_NAME_CHECK_FLAG *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_NAME_CHECK_FLAG(struct ndr_print *ndr, const char *name, enum DNS_NAME_CHECK_FLAG r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_ALLOW_RFC_NAMES_ONLY: val = "DNS_ALLOW_RFC_NAMES_ONLY"; break;
		case DNS_ALLOW_NONRFC_NAMES: val = "DNS_ALLOW_NONRFC_NAMES"; break;
		case DNS_ALLOW_MULTIBYTE_NAMES: val = "DNS_ALLOW_MULTIBYTE_NAMES"; break;
		case DNS_ALLOW_ALL_NAMES: val = "DNS_ALLOW_ALL_NAMES"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_RPC_SERVER_INFO_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_SERVER_INFO_W2K *r)
{
	uint32_t cntr_dwReserveArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwVersion));
		NDR_CHECK(ndr_push_DNS_BOOT_METHOD(ndr, NDR_SCALARS, r->fBootMethod));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAdminConfigured));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fDsAvailable));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszServerName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDsContainer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipServerAddrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipListenAddrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipForwarders));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pExtension1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pExtension2));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pExtension3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pExtension4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pExtension5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLogLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDebugLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwardTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcProtocol));
		NDR_CHECK(ndr_push_DNS_NAME_CHECK_FLAG(ndr, NDR_SCALARS, r->dwNameCheckFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cAddressAnswerLimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRecursionRetry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRecursionTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwMaxCacheTtl));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsPollingInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwScavengingInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDefaultRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDefaultNoRefreshInterval));
		for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (10); cntr_dwReserveArray_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserveArray[cntr_dwReserveArray_0]));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAutoReverseZones));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAutoCacheUpdate));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fForwardDelegations));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fNoRecursion));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fSecureResponses));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fRoundRobin));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fLocalNetPriority));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fBindSecondaries));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fWriteAuthorityNs));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fStrictFileParsing));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fLooseWildcarding));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fDefaultAgingState));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->fReserveArray, 15));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServerName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServerName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszServerName, ndr_charset_length(r->pszServerName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDsContainer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDsContainer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDsContainer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDsContainer, ndr_charset_length(r->pszDsContainer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->aipServerAddrs) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipServerAddrs));
		}
		if (r->aipListenAddrs) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipListenAddrs));
		}
		if (r->aipForwarders) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
		}
		if (r->pExtension1) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->pExtension1));
		}
		if (r->pExtension2) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->pExtension2));
		}
		if (r->pExtension3) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->pExtension3));
		}
		if (r->pExtension4) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->pExtension4));
		}
		if (r->pExtension5) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->pExtension5));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_SERVER_INFO_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_SERVER_INFO_W2K *r)
{
	uint32_t _ptr_pszServerName;
	uint32_t size_pszServerName_1 = 0;
	uint32_t length_pszServerName_1 = 0;
	TALLOC_CTX *_mem_save_pszServerName_0 = NULL;
	uint32_t _ptr_pszDsContainer;
	uint32_t size_pszDsContainer_1 = 0;
	uint32_t length_pszDsContainer_1 = 0;
	TALLOC_CTX *_mem_save_pszDsContainer_0 = NULL;
	uint32_t _ptr_aipServerAddrs;
	TALLOC_CTX *_mem_save_aipServerAddrs_0 = NULL;
	uint32_t _ptr_aipListenAddrs;
	TALLOC_CTX *_mem_save_aipListenAddrs_0 = NULL;
	uint32_t _ptr_aipForwarders;
	TALLOC_CTX *_mem_save_aipForwarders_0 = NULL;
	uint32_t _ptr_pExtension1;
	TALLOC_CTX *_mem_save_pExtension1_0 = NULL;
	uint32_t _ptr_pExtension2;
	TALLOC_CTX *_mem_save_pExtension2_0 = NULL;
	uint32_t _ptr_pExtension3;
	TALLOC_CTX *_mem_save_pExtension3_0 = NULL;
	uint32_t _ptr_pExtension4;
	TALLOC_CTX *_mem_save_pExtension4_0 = NULL;
	uint32_t _ptr_pExtension5;
	TALLOC_CTX *_mem_save_pExtension5_0 = NULL;
	uint32_t size_dwReserveArray_0 = 0;
	uint32_t cntr_dwReserveArray_0;
	uint32_t size_fReserveArray_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwVersion));
		NDR_CHECK(ndr_pull_DNS_BOOT_METHOD(ndr, NDR_SCALARS, &r->fBootMethod));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAdminConfigured));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fDsAvailable));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServerName));
		if (_ptr_pszServerName) {
			NDR_PULL_ALLOC(ndr, r->pszServerName);
		} else {
			r->pszServerName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDsContainer));
		if (_ptr_pszDsContainer) {
			NDR_PULL_ALLOC(ndr, r->pszDsContainer);
		} else {
			r->pszDsContainer = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipServerAddrs));
		if (_ptr_aipServerAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipServerAddrs);
		} else {
			r->aipServerAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipListenAddrs));
		if (_ptr_aipListenAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipListenAddrs);
		} else {
			r->aipListenAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipForwarders));
		if (_ptr_aipForwarders) {
			NDR_PULL_ALLOC(ndr, r->aipForwarders);
		} else {
			r->aipForwarders = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pExtension1));
		if (_ptr_pExtension1) {
			NDR_PULL_ALLOC(ndr, r->pExtension1);
		} else {
			r->pExtension1 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pExtension2));
		if (_ptr_pExtension2) {
			NDR_PULL_ALLOC(ndr, r->pExtension2);
		} else {
			r->pExtension2 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pExtension3));
		if (_ptr_pExtension3) {
			NDR_PULL_ALLOC(ndr, r->pExtension3);
		} else {
			r->pExtension3 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pExtension4));
		if (_ptr_pExtension4) {
			NDR_PULL_ALLOC(ndr, r->pExtension4);
		} else {
			r->pExtension4 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pExtension5));
		if (_ptr_pExtension5) {
			NDR_PULL_ALLOC(ndr, r->pExtension5);
		} else {
			r->pExtension5 = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLogLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDebugLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwardTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcProtocol));
		NDR_CHECK(ndr_pull_DNS_NAME_CHECK_FLAG(ndr, NDR_SCALARS, &r->dwNameCheckFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cAddressAnswerLimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRecursionRetry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRecursionTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwMaxCacheTtl));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsPollingInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwScavengingInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDefaultRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDefaultNoRefreshInterval));
		size_dwReserveArray_0 = 10;
		for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (size_dwReserveArray_0); cntr_dwReserveArray_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserveArray[cntr_dwReserveArray_0]));
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAutoReverseZones));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAutoCacheUpdate));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fForwardDelegations));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fNoRecursion));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fSecureResponses));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fRoundRobin));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fLocalNetPriority));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fBindSecondaries));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fWriteAuthorityNs));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fStrictFileParsing));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fLooseWildcarding));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fDefaultAgingState));
		size_fReserveArray_0 = 15;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->fReserveArray, size_fReserveArray_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServerName) {
			_mem_save_pszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszServerName, &size_pszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszServerName, &length_pszServerName_1));
			if (length_pszServerName_1 > size_pszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServerName_1, length_pszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServerName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszServerName, length_pszServerName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServerName_0, 0);
		}
		if (r->pszDsContainer) {
			_mem_save_pszDsContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDsContainer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDsContainer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDsContainer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDsContainer, &size_pszDsContainer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDsContainer, &length_pszDsContainer_1));
			if (length_pszDsContainer_1 > size_pszDsContainer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDsContainer_1, length_pszDsContainer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDsContainer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDsContainer, length_pszDsContainer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDsContainer_0, 0);
		}
		if (r->aipServerAddrs) {
			_mem_save_aipServerAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipServerAddrs, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipServerAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipServerAddrs_0, 0);
		}
		if (r->aipListenAddrs) {
			_mem_save_aipListenAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipListenAddrs, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipListenAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipListenAddrs_0, 0);
		}
		if (r->aipForwarders) {
			_mem_save_aipForwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipForwarders, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipForwarders_0, 0);
		}
		if (r->pExtension1) {
			_mem_save_pExtension1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pExtension1, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->pExtension1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExtension1_0, 0);
		}
		if (r->pExtension2) {
			_mem_save_pExtension2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pExtension2, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->pExtension2));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExtension2_0, 0);
		}
		if (r->pExtension3) {
			_mem_save_pExtension3_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pExtension3, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->pExtension3));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExtension3_0, 0);
		}
		if (r->pExtension4) {
			_mem_save_pExtension4_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pExtension4, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->pExtension4));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExtension4_0, 0);
		}
		if (r->pExtension5) {
			_mem_save_pExtension5_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pExtension5, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->pExtension5));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pExtension5_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_SERVER_INFO_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_SERVER_INFO_W2K *r)
{
	uint32_t cntr_dwReserveArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_SERVER_INFO_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwVersion", r->dwVersion);
	ndr_print_DNS_BOOT_METHOD(ndr, "fBootMethod", r->fBootMethod);
	ndr_print_uint8(ndr, "fAdminConfigured", r->fAdminConfigured);
	ndr_print_uint8(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint8(ndr, "fDsAvailable", r->fDsAvailable);
	ndr_print_ptr(ndr, "pszServerName", r->pszServerName);
	ndr->depth++;
	if (r->pszServerName) {
		ndr_print_string(ndr, "pszServerName", r->pszServerName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDsContainer", r->pszDsContainer);
	ndr->depth++;
	if (r->pszDsContainer) {
		ndr_print_string(ndr, "pszDsContainer", r->pszDsContainer);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipServerAddrs", r->aipServerAddrs);
	ndr->depth++;
	if (r->aipServerAddrs) {
		ndr_print_IP4_ARRAY(ndr, "aipServerAddrs", r->aipServerAddrs);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipListenAddrs", r->aipListenAddrs);
	ndr->depth++;
	if (r->aipListenAddrs) {
		ndr_print_IP4_ARRAY(ndr, "aipListenAddrs", r->aipListenAddrs);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipForwarders", r->aipForwarders);
	ndr->depth++;
	if (r->aipForwarders) {
		ndr_print_IP4_ARRAY(ndr, "aipForwarders", r->aipForwarders);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pExtension1", r->pExtension1);
	ndr->depth++;
	if (r->pExtension1) {
		ndr_print_uint32(ndr, "pExtension1", *r->pExtension1);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pExtension2", r->pExtension2);
	ndr->depth++;
	if (r->pExtension2) {
		ndr_print_uint32(ndr, "pExtension2", *r->pExtension2);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pExtension3", r->pExtension3);
	ndr->depth++;
	if (r->pExtension3) {
		ndr_print_uint32(ndr, "pExtension3", *r->pExtension3);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pExtension4", r->pExtension4);
	ndr->depth++;
	if (r->pExtension4) {
		ndr_print_uint32(ndr, "pExtension4", *r->pExtension4);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pExtension5", r->pExtension5);
	ndr->depth++;
	if (r->pExtension5) {
		ndr_print_uint32(ndr, "pExtension5", *r->pExtension5);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwLogLevel", r->dwLogLevel);
	ndr_print_uint32(ndr, "dwDebugLevel", r->dwDebugLevel);
	ndr_print_uint32(ndr, "dwForwardTimeout", r->dwForwardTimeout);
	ndr_print_uint32(ndr, "dwRpcProtocol", r->dwRpcProtocol);
	ndr_print_DNS_NAME_CHECK_FLAG(ndr, "dwNameCheckFlag", r->dwNameCheckFlag);
	ndr_print_uint32(ndr, "cAddressAnswerLimit", r->cAddressAnswerLimit);
	ndr_print_uint32(ndr, "dwRecursionRetry", r->dwRecursionRetry);
	ndr_print_uint32(ndr, "dwRecursionTimeout", r->dwRecursionTimeout);
	ndr_print_uint32(ndr, "dwMaxCacheTtl", r->dwMaxCacheTtl);
	ndr_print_uint32(ndr, "dwDsPollingInterval", r->dwDsPollingInterval);
	ndr_print_uint32(ndr, "dwScavengingInterval", r->dwScavengingInterval);
	ndr_print_uint32(ndr, "dwDefaultRefreshInterval", r->dwDefaultRefreshInterval);
	ndr_print_uint32(ndr, "dwDefaultNoRefreshInterval", r->dwDefaultNoRefreshInterval);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dwReserveArray", (uint32_t)(10));
	ndr->depth++;
	for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (10); cntr_dwReserveArray_0++) {
		ndr_print_uint32(ndr, "dwReserveArray", r->dwReserveArray[cntr_dwReserveArray_0]);
	}
	ndr->depth--;
	ndr_print_uint8(ndr, "fAutoReverseZones", r->fAutoReverseZones);
	ndr_print_uint8(ndr, "fAutoCacheUpdate", r->fAutoCacheUpdate);
	ndr_print_uint8(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint8(ndr, "fForwardDelegations", r->fForwardDelegations);
	ndr_print_uint8(ndr, "fNoRecursion", r->fNoRecursion);
	ndr_print_uint8(ndr, "fSecureResponses", r->fSecureResponses);
	ndr_print_uint8(ndr, "fRoundRobin", r->fRoundRobin);
	ndr_print_uint8(ndr, "fLocalNetPriority", r->fLocalNetPriority);
	ndr_print_uint8(ndr, "fBindSecondaries", r->fBindSecondaries);
	ndr_print_uint8(ndr, "fWriteAuthorityNs", r->fWriteAuthorityNs);
	ndr_print_uint8(ndr, "fStrictFileParsing", r->fStrictFileParsing);
	ndr_print_uint8(ndr, "fLooseWildcarding", r->fLooseWildcarding);
	ndr_print_uint8(ndr, "fDefaultAgingState", r->fDefaultAgingState);
	ndr_print_array_uint8(ndr, "fReserveArray", r->fReserveArray, 15);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_EXTENSION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_EXTENSION *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->extension));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->extension) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->extension, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->extension, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->extension, ndr_charset_length(r->extension, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_EXTENSION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_EXTENSION *r)
{
	uint32_t _ptr_extension;
	uint32_t size_extension_1 = 0;
	uint32_t length_extension_1 = 0;
	TALLOC_CTX *_mem_save_extension_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_extension));
		if (_ptr_extension) {
			NDR_PULL_ALLOC(ndr, r->extension);
		} else {
			r->extension = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->extension) {
			_mem_save_extension_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->extension, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->extension));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->extension));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->extension, &size_extension_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->extension, &length_extension_1));
			if (length_extension_1 > size_extension_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_extension_1, length_extension_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_extension_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->extension, length_extension_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_extension_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_EXTENSION(struct ndr_print *ndr, const char *name, const struct DNS_EXTENSION *r)
{
	ndr_print_struct(ndr, name, "DNS_EXTENSION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "extension", r->extension);
	ndr->depth++;
	if (r->extension) {
		ndr_print_string(ndr, "extension", r->extension);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_DNS_RPC_SERVER_INFO_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_SERVER_INFO_DOTNET *r)
{
	uint32_t cntr_pExtensions_0;
	uint32_t cntr_dwReserveArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwVersion));
		NDR_CHECK(ndr_push_DNS_BOOT_METHOD(ndr, NDR_SCALARS, r->fBootMethod));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAdminConfigured));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fDsAvailable));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszServerName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDsContainer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipServerAddrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipListenAddrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipForwarders));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipLogFilter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pwszLogFilePath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDomainName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszForestName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDomainDirectoryPartition));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszForestDirectoryPartition));
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (6); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pExtensions[cntr_pExtensions_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLogLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDebugLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwardTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcProtocol));
		NDR_CHECK(ndr_push_DNS_NAME_CHECK_FLAG(ndr, NDR_SCALARS, r->dwNameCheckFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cAddressAnswerLimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRecursionRetry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRecursionTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwMaxCacheTtl));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsPollingInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLocalNetPriorityNetMask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwScavengingInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDefaultRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDefaultNoRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastScavengeTime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwEventLogLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLogFileMaxSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsForestVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsDomainVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsDsaVersion));
		for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (4); cntr_dwReserveArray_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserveArray[cntr_dwReserveArray_0]));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAutoReverseZones));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAutoCacheUpdate));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fForwardDelegations));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fNoRecursion));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fSecureResponses));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fRoundRobin));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fLocalNetPriority));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fBindSecondaries));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fWriteAuthorityNs));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fStrictFileParsing));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fLooseWildcarding));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fDefaultAgingState));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->fReserveArray, 15));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServerName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServerName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszServerName, ndr_charset_length(r->pszServerName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDsContainer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDsContainer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDsContainer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDsContainer, ndr_charset_length(r->pszDsContainer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->aipServerAddrs) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipServerAddrs));
		}
		if (r->aipListenAddrs) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipListenAddrs));
		}
		if (r->aipForwarders) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
		}
		if (r->aipLogFilter) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipLogFilter));
		}
		if (r->pwszLogFilePath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszLogFilePath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszLogFilePath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pwszLogFilePath, ndr_charset_length(r->pwszLogFilePath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pszDomainName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDomainName, ndr_charset_length(r->pszDomainName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszForestName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszForestName, ndr_charset_length(r->pszForestName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDomainDirectoryPartition) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDomainDirectoryPartition, ndr_charset_length(r->pszDomainDirectoryPartition, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszForestDirectoryPartition) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszForestDirectoryPartition, ndr_charset_length(r->pszForestDirectoryPartition, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (6); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pExtensions[cntr_pExtensions_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DNS_RPC_SERVER_INFO_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_SERVER_INFO_DOTNET *r)
{
	uint32_t _ptr_pszServerName;
	uint32_t size_pszServerName_1 = 0;
	uint32_t length_pszServerName_1 = 0;
	TALLOC_CTX *_mem_save_pszServerName_0 = NULL;
	uint32_t _ptr_pszDsContainer;
	uint32_t size_pszDsContainer_1 = 0;
	uint32_t length_pszDsContainer_1 = 0;
	TALLOC_CTX *_mem_save_pszDsContainer_0 = NULL;
	uint32_t _ptr_aipServerAddrs;
	TALLOC_CTX *_mem_save_aipServerAddrs_0 = NULL;
	uint32_t _ptr_aipListenAddrs;
	TALLOC_CTX *_mem_save_aipListenAddrs_0 = NULL;
	uint32_t _ptr_aipForwarders;
	TALLOC_CTX *_mem_save_aipForwarders_0 = NULL;
	uint32_t _ptr_aipLogFilter;
	TALLOC_CTX *_mem_save_aipLogFilter_0 = NULL;
	uint32_t _ptr_pwszLogFilePath;
	uint32_t size_pwszLogFilePath_1 = 0;
	uint32_t length_pwszLogFilePath_1 = 0;
	TALLOC_CTX *_mem_save_pwszLogFilePath_0 = NULL;
	uint32_t _ptr_pszDomainName;
	uint32_t size_pszDomainName_1 = 0;
	uint32_t length_pszDomainName_1 = 0;
	TALLOC_CTX *_mem_save_pszDomainName_0 = NULL;
	uint32_t _ptr_pszForestName;
	uint32_t size_pszForestName_1 = 0;
	uint32_t length_pszForestName_1 = 0;
	TALLOC_CTX *_mem_save_pszForestName_0 = NULL;
	uint32_t _ptr_pszDomainDirectoryPartition;
	uint32_t size_pszDomainDirectoryPartition_1 = 0;
	uint32_t length_pszDomainDirectoryPartition_1 = 0;
	TALLOC_CTX *_mem_save_pszDomainDirectoryPartition_0 = NULL;
	uint32_t _ptr_pszForestDirectoryPartition;
	uint32_t size_pszForestDirectoryPartition_1 = 0;
	uint32_t length_pszForestDirectoryPartition_1 = 0;
	TALLOC_CTX *_mem_save_pszForestDirectoryPartition_0 = NULL;
	uint32_t size_pExtensions_0 = 0;
	uint32_t cntr_pExtensions_0;
	uint32_t size_dwReserveArray_0 = 0;
	uint32_t cntr_dwReserveArray_0;
	uint32_t size_fReserveArray_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwVersion));
		NDR_CHECK(ndr_pull_DNS_BOOT_METHOD(ndr, NDR_SCALARS, &r->fBootMethod));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAdminConfigured));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fDsAvailable));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServerName));
		if (_ptr_pszServerName) {
			NDR_PULL_ALLOC(ndr, r->pszServerName);
		} else {
			r->pszServerName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDsContainer));
		if (_ptr_pszDsContainer) {
			NDR_PULL_ALLOC(ndr, r->pszDsContainer);
		} else {
			r->pszDsContainer = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipServerAddrs));
		if (_ptr_aipServerAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipServerAddrs);
		} else {
			r->aipServerAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipListenAddrs));
		if (_ptr_aipListenAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipListenAddrs);
		} else {
			r->aipListenAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipForwarders));
		if (_ptr_aipForwarders) {
			NDR_PULL_ALLOC(ndr, r->aipForwarders);
		} else {
			r->aipForwarders = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipLogFilter));
		if (_ptr_aipLogFilter) {
			NDR_PULL_ALLOC(ndr, r->aipLogFilter);
		} else {
			r->aipLogFilter = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszLogFilePath));
		if (_ptr_pwszLogFilePath) {
			NDR_PULL_ALLOC(ndr, r->pwszLogFilePath);
		} else {
			r->pwszLogFilePath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDomainName));
		if (_ptr_pszDomainName) {
			NDR_PULL_ALLOC(ndr, r->pszDomainName);
		} else {
			r->pszDomainName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszForestName));
		if (_ptr_pszForestName) {
			NDR_PULL_ALLOC(ndr, r->pszForestName);
		} else {
			r->pszForestName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDomainDirectoryPartition));
		if (_ptr_pszDomainDirectoryPartition) {
			NDR_PULL_ALLOC(ndr, r->pszDomainDirectoryPartition);
		} else {
			r->pszDomainDirectoryPartition = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszForestDirectoryPartition));
		if (_ptr_pszForestDirectoryPartition) {
			NDR_PULL_ALLOC(ndr, r->pszForestDirectoryPartition);
		} else {
			r->pszForestDirectoryPartition = NULL;
		}
		size_pExtensions_0 = 6;
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (size_pExtensions_0); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pExtensions[cntr_pExtensions_0]));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLogLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDebugLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwardTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcProtocol));
		NDR_CHECK(ndr_pull_DNS_NAME_CHECK_FLAG(ndr, NDR_SCALARS, &r->dwNameCheckFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cAddressAnswerLimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRecursionRetry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRecursionTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwMaxCacheTtl));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsPollingInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLocalNetPriorityNetMask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwScavengingInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDefaultRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDefaultNoRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastScavengeTime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwEventLogLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLogFileMaxSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsForestVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsDomainVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsDsaVersion));
		size_dwReserveArray_0 = 4;
		for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (size_dwReserveArray_0); cntr_dwReserveArray_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserveArray[cntr_dwReserveArray_0]));
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAutoReverseZones));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAutoCacheUpdate));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fForwardDelegations));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fNoRecursion));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fSecureResponses));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fRoundRobin));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fLocalNetPriority));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fBindSecondaries));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fWriteAuthorityNs));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fStrictFileParsing));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fLooseWildcarding));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fDefaultAgingState));
		size_fReserveArray_0 = 15;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->fReserveArray, size_fReserveArray_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServerName) {
			_mem_save_pszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszServerName, &size_pszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszServerName, &length_pszServerName_1));
			if (length_pszServerName_1 > size_pszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServerName_1, length_pszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServerName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszServerName, length_pszServerName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServerName_0, 0);
		}
		if (r->pszDsContainer) {
			_mem_save_pszDsContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDsContainer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDsContainer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDsContainer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDsContainer, &size_pszDsContainer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDsContainer, &length_pszDsContainer_1));
			if (length_pszDsContainer_1 > size_pszDsContainer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDsContainer_1, length_pszDsContainer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDsContainer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDsContainer, length_pszDsContainer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDsContainer_0, 0);
		}
		if (r->aipServerAddrs) {
			_mem_save_aipServerAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipServerAddrs, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipServerAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipServerAddrs_0, 0);
		}
		if (r->aipListenAddrs) {
			_mem_save_aipListenAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipListenAddrs, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipListenAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipListenAddrs_0, 0);
		}
		if (r->aipForwarders) {
			_mem_save_aipForwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipForwarders, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipForwarders_0, 0);
		}
		if (r->aipLogFilter) {
			_mem_save_aipLogFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipLogFilter, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipLogFilter));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipLogFilter_0, 0);
		}
		if (r->pwszLogFilePath) {
			_mem_save_pwszLogFilePath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pwszLogFilePath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pwszLogFilePath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pwszLogFilePath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pwszLogFilePath, &size_pwszLogFilePath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pwszLogFilePath, &length_pwszLogFilePath_1));
			if (length_pwszLogFilePath_1 > size_pwszLogFilePath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszLogFilePath_1, length_pwszLogFilePath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszLogFilePath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pwszLogFilePath, length_pwszLogFilePath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszLogFilePath_0, 0);
		}
		if (r->pszDomainName) {
			_mem_save_pszDomainName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDomainName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDomainName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDomainName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDomainName, &size_pszDomainName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDomainName, &length_pszDomainName_1));
			if (length_pszDomainName_1 > size_pszDomainName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDomainName_1, length_pszDomainName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDomainName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDomainName, length_pszDomainName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDomainName_0, 0);
		}
		if (r->pszForestName) {
			_mem_save_pszForestName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszForestName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszForestName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszForestName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszForestName, &size_pszForestName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszForestName, &length_pszForestName_1));
			if (length_pszForestName_1 > size_pszForestName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszForestName_1, length_pszForestName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszForestName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszForestName, length_pszForestName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszForestName_0, 0);
		}
		if (r->pszDomainDirectoryPartition) {
			_mem_save_pszDomainDirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDomainDirectoryPartition, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDomainDirectoryPartition));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDomainDirectoryPartition));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDomainDirectoryPartition, &size_pszDomainDirectoryPartition_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDomainDirectoryPartition, &length_pszDomainDirectoryPartition_1));
			if (length_pszDomainDirectoryPartition_1 > size_pszDomainDirectoryPartition_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDomainDirectoryPartition_1, length_pszDomainDirectoryPartition_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDomainDirectoryPartition_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDomainDirectoryPartition, length_pszDomainDirectoryPartition_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDomainDirectoryPartition_0, 0);
		}
		if (r->pszForestDirectoryPartition) {
			_mem_save_pszForestDirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszForestDirectoryPartition, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszForestDirectoryPartition));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszForestDirectoryPartition));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszForestDirectoryPartition, &size_pszForestDirectoryPartition_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszForestDirectoryPartition, &length_pszForestDirectoryPartition_1));
			if (length_pszForestDirectoryPartition_1 > size_pszForestDirectoryPartition_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszForestDirectoryPartition_1, length_pszForestDirectoryPartition_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszForestDirectoryPartition_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszForestDirectoryPartition, length_pszForestDirectoryPartition_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszForestDirectoryPartition_0, 0);
		}
		size_pExtensions_0 = 6;
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (size_pExtensions_0); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pExtensions[cntr_pExtensions_0]));
		}
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (size_pExtensions_0); cntr_pExtensions_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_DNS_RPC_SERVER_INFO_DOTNET(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct DNS_RPC_SERVER_INFO_DOTNET *r)
{
	ndr_print_DNS_RPC_SERVER_INFO_DOTNET(ndr, name, r);
}

_PUBLIC_ void ndr_print_DNS_RPC_SERVER_INFO_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_SERVER_INFO_DOTNET *r)
{
	uint32_t cntr_pExtensions_0;
	uint32_t cntr_dwReserveArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_SERVER_INFO_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "dwVersion", r->dwVersion);
	ndr_print_DNS_BOOT_METHOD(ndr, "fBootMethod", r->fBootMethod);
	ndr_print_uint8(ndr, "fAdminConfigured", r->fAdminConfigured);
	ndr_print_uint8(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint8(ndr, "fDsAvailable", r->fDsAvailable);
	ndr_print_ptr(ndr, "pszServerName", r->pszServerName);
	ndr->depth++;
	if (r->pszServerName) {
		ndr_print_string(ndr, "pszServerName", r->pszServerName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDsContainer", r->pszDsContainer);
	ndr->depth++;
	if (r->pszDsContainer) {
		ndr_print_string(ndr, "pszDsContainer", r->pszDsContainer);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipServerAddrs", r->aipServerAddrs);
	ndr->depth++;
	if (r->aipServerAddrs) {
		ndr_print_IP4_ARRAY(ndr, "aipServerAddrs", r->aipServerAddrs);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipListenAddrs", r->aipListenAddrs);
	ndr->depth++;
	if (r->aipListenAddrs) {
		ndr_print_IP4_ARRAY(ndr, "aipListenAddrs", r->aipListenAddrs);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipForwarders", r->aipForwarders);
	ndr->depth++;
	if (r->aipForwarders) {
		ndr_print_IP4_ARRAY(ndr, "aipForwarders", r->aipForwarders);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipLogFilter", r->aipLogFilter);
	ndr->depth++;
	if (r->aipLogFilter) {
		ndr_print_IP4_ARRAY(ndr, "aipLogFilter", r->aipLogFilter);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pwszLogFilePath", r->pwszLogFilePath);
	ndr->depth++;
	if (r->pwszLogFilePath) {
		ndr_print_string(ndr, "pwszLogFilePath", r->pwszLogFilePath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDomainName", r->pszDomainName);
	ndr->depth++;
	if (r->pszDomainName) {
		ndr_print_string(ndr, "pszDomainName", r->pszDomainName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszForestName", r->pszForestName);
	ndr->depth++;
	if (r->pszForestName) {
		ndr_print_string(ndr, "pszForestName", r->pszForestName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDomainDirectoryPartition", r->pszDomainDirectoryPartition);
	ndr->depth++;
	if (r->pszDomainDirectoryPartition) {
		ndr_print_string(ndr, "pszDomainDirectoryPartition", r->pszDomainDirectoryPartition);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszForestDirectoryPartition", r->pszForestDirectoryPartition);
	ndr->depth++;
	if (r->pszForestDirectoryPartition) {
		ndr_print_string(ndr, "pszForestDirectoryPartition", r->pszForestDirectoryPartition);
	}
	ndr->depth--;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pExtensions", (uint32_t)(6));
	ndr->depth++;
	for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (6); cntr_pExtensions_0++) {
		ndr_print_DNS_EXTENSION(ndr, "pExtensions", &r->pExtensions[cntr_pExtensions_0]);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwLogLevel", r->dwLogLevel);
	ndr_print_uint32(ndr, "dwDebugLevel", r->dwDebugLevel);
	ndr_print_uint32(ndr, "dwForwardTimeout", r->dwForwardTimeout);
	ndr_print_uint32(ndr, "dwRpcProtocol", r->dwRpcProtocol);
	ndr_print_DNS_NAME_CHECK_FLAG(ndr, "dwNameCheckFlag", r->dwNameCheckFlag);
	ndr_print_uint32(ndr, "cAddressAnswerLimit", r->cAddressAnswerLimit);
	ndr_print_uint32(ndr, "dwRecursionRetry", r->dwRecursionRetry);
	ndr_print_uint32(ndr, "dwRecursionTimeout", r->dwRecursionTimeout);
	ndr_print_uint32(ndr, "dwMaxCacheTtl", r->dwMaxCacheTtl);
	ndr_print_uint32(ndr, "dwDsPollingInterval", r->dwDsPollingInterval);
	ndr_print_uint32(ndr, "dwLocalNetPriorityNetMask", r->dwLocalNetPriorityNetMask);
	ndr_print_uint32(ndr, "dwScavengingInterval", r->dwScavengingInterval);
	ndr_print_uint32(ndr, "dwDefaultRefreshInterval", r->dwDefaultRefreshInterval);
	ndr_print_uint32(ndr, "dwDefaultNoRefreshInterval", r->dwDefaultNoRefreshInterval);
	ndr_print_uint32(ndr, "dwLastScavengeTime", r->dwLastScavengeTime);
	ndr_print_uint32(ndr, "dwEventLogLevel", r->dwEventLogLevel);
	ndr_print_uint32(ndr, "dwLogFileMaxSize", r->dwLogFileMaxSize);
	ndr_print_uint32(ndr, "dwDsForestVersion", r->dwDsForestVersion);
	ndr_print_uint32(ndr, "dwDsDomainVersion", r->dwDsDomainVersion);
	ndr_print_uint32(ndr, "dwDsDsaVersion", r->dwDsDsaVersion);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dwReserveArray", (uint32_t)(4));
	ndr->depth++;
	for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (4); cntr_dwReserveArray_0++) {
		ndr_print_uint32(ndr, "dwReserveArray", r->dwReserveArray[cntr_dwReserveArray_0]);
	}
	ndr->depth--;
	ndr_print_uint8(ndr, "fAutoReverseZones", r->fAutoReverseZones);
	ndr_print_uint8(ndr, "fAutoCacheUpdate", r->fAutoCacheUpdate);
	ndr_print_uint8(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint8(ndr, "fForwardDelegations", r->fForwardDelegations);
	ndr_print_uint8(ndr, "fNoRecursion", r->fNoRecursion);
	ndr_print_uint8(ndr, "fSecureResponses", r->fSecureResponses);
	ndr_print_uint8(ndr, "fRoundRobin", r->fRoundRobin);
	ndr_print_uint8(ndr, "fLocalNetPriority", r->fLocalNetPriority);
	ndr_print_uint8(ndr, "fBindSecondaries", r->fBindSecondaries);
	ndr_print_uint8(ndr, "fWriteAuthorityNs", r->fWriteAuthorityNs);
	ndr_print_uint8(ndr, "fStrictFileParsing", r->fStrictFileParsing);
	ndr_print_uint8(ndr, "fLooseWildcarding", r->fLooseWildcarding);
	ndr_print_uint8(ndr, "fDefaultAgingState", r->fDefaultAgingState);
	ndr_print_array_uint8(ndr, "fReserveArray", r->fReserveArray, 15);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_DNS_RPC_SERVER_INFO_LONGHORN(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_SERVER_INFO_LONGHORN *r)
{
	uint32_t cntr_pExtensions_0;
	uint32_t cntr_dwReserveArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwVersion));
		NDR_CHECK(ndr_push_DNS_BOOT_METHOD(ndr, NDR_SCALARS, r->fBootMethod));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAdminConfigured));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fDsAvailable));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszServerName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDsContainer));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipServerAddrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipListenAddrs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipForwarders));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipLogFilter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pwszLogFilePath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDomainName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszForestName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDomainDirectoryPartition));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszForestDirectoryPartition));
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (6); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pExtensions[cntr_pExtensions_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLogLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDebugLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwardTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcProtocol));
		NDR_CHECK(ndr_push_DNS_NAME_CHECK_FLAG(ndr, NDR_SCALARS, r->dwNameCheckFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cAddressAnswerLimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRecursionRetry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRecursionTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwMaxCacheTtl));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsPollingInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLocalNetPriorityNetMask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwScavengingInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDefaultRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDefaultNoRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastScavengeTime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwEventLogLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLogFileMaxSize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsForestVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsDomainVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDsDsaVersion));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fReadOnlyDC));
		for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (3); cntr_dwReserveArray_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserveArray[cntr_dwReserveArray_0]));
		}
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAutoReverseZones));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fAutoCacheUpdate));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fForwardDelegations));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fNoRecursion));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fSecureResponses));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fRoundRobin));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fLocalNetPriority));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fBindSecondaries));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fWriteAuthorityNs));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fStrictFileParsing));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fLooseWildcarding));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fDefaultAgingState));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->fReserveArray, 15));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServerName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServerName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszServerName, ndr_charset_length(r->pszServerName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDsContainer) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDsContainer, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDsContainer, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDsContainer, ndr_charset_length(r->pszDsContainer, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->aipServerAddrs) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipServerAddrs));
		}
		if (r->aipListenAddrs) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipListenAddrs));
		}
		if (r->aipForwarders) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
		}
		if (r->aipLogFilter) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipLogFilter));
		}
		if (r->pwszLogFilePath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszLogFilePath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszLogFilePath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pwszLogFilePath, ndr_charset_length(r->pwszLogFilePath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pszDomainName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDomainName, ndr_charset_length(r->pszDomainName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszForestName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszForestName, ndr_charset_length(r->pszForestName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDomainDirectoryPartition) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDomainDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDomainDirectoryPartition, ndr_charset_length(r->pszDomainDirectoryPartition, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszForestDirectoryPartition) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszForestDirectoryPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszForestDirectoryPartition, ndr_charset_length(r->pszForestDirectoryPartition, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (6); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pExtensions[cntr_pExtensions_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_SERVER_INFO_LONGHORN *r)
{
	uint32_t _ptr_pszServerName;
	uint32_t size_pszServerName_1 = 0;
	uint32_t length_pszServerName_1 = 0;
	TALLOC_CTX *_mem_save_pszServerName_0 = NULL;
	uint32_t _ptr_pszDsContainer;
	uint32_t size_pszDsContainer_1 = 0;
	uint32_t length_pszDsContainer_1 = 0;
	TALLOC_CTX *_mem_save_pszDsContainer_0 = NULL;
	uint32_t _ptr_aipServerAddrs;
	TALLOC_CTX *_mem_save_aipServerAddrs_0 = NULL;
	uint32_t _ptr_aipListenAddrs;
	TALLOC_CTX *_mem_save_aipListenAddrs_0 = NULL;
	uint32_t _ptr_aipForwarders;
	TALLOC_CTX *_mem_save_aipForwarders_0 = NULL;
	uint32_t _ptr_aipLogFilter;
	TALLOC_CTX *_mem_save_aipLogFilter_0 = NULL;
	uint32_t _ptr_pwszLogFilePath;
	uint32_t size_pwszLogFilePath_1 = 0;
	uint32_t length_pwszLogFilePath_1 = 0;
	TALLOC_CTX *_mem_save_pwszLogFilePath_0 = NULL;
	uint32_t _ptr_pszDomainName;
	uint32_t size_pszDomainName_1 = 0;
	uint32_t length_pszDomainName_1 = 0;
	TALLOC_CTX *_mem_save_pszDomainName_0 = NULL;
	uint32_t _ptr_pszForestName;
	uint32_t size_pszForestName_1 = 0;
	uint32_t length_pszForestName_1 = 0;
	TALLOC_CTX *_mem_save_pszForestName_0 = NULL;
	uint32_t _ptr_pszDomainDirectoryPartition;
	uint32_t size_pszDomainDirectoryPartition_1 = 0;
	uint32_t length_pszDomainDirectoryPartition_1 = 0;
	TALLOC_CTX *_mem_save_pszDomainDirectoryPartition_0 = NULL;
	uint32_t _ptr_pszForestDirectoryPartition;
	uint32_t size_pszForestDirectoryPartition_1 = 0;
	uint32_t length_pszForestDirectoryPartition_1 = 0;
	TALLOC_CTX *_mem_save_pszForestDirectoryPartition_0 = NULL;
	uint32_t size_pExtensions_0 = 0;
	uint32_t cntr_pExtensions_0;
	uint32_t size_dwReserveArray_0 = 0;
	uint32_t cntr_dwReserveArray_0;
	uint32_t size_fReserveArray_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwVersion));
		NDR_CHECK(ndr_pull_DNS_BOOT_METHOD(ndr, NDR_SCALARS, &r->fBootMethod));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAdminConfigured));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fDsAvailable));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServerName));
		if (_ptr_pszServerName) {
			NDR_PULL_ALLOC(ndr, r->pszServerName);
		} else {
			r->pszServerName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDsContainer));
		if (_ptr_pszDsContainer) {
			NDR_PULL_ALLOC(ndr, r->pszDsContainer);
		} else {
			r->pszDsContainer = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipServerAddrs));
		if (_ptr_aipServerAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipServerAddrs);
		} else {
			r->aipServerAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipListenAddrs));
		if (_ptr_aipListenAddrs) {
			NDR_PULL_ALLOC(ndr, r->aipListenAddrs);
		} else {
			r->aipListenAddrs = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipForwarders));
		if (_ptr_aipForwarders) {
			NDR_PULL_ALLOC(ndr, r->aipForwarders);
		} else {
			r->aipForwarders = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipLogFilter));
		if (_ptr_aipLogFilter) {
			NDR_PULL_ALLOC(ndr, r->aipLogFilter);
		} else {
			r->aipLogFilter = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszLogFilePath));
		if (_ptr_pwszLogFilePath) {
			NDR_PULL_ALLOC(ndr, r->pwszLogFilePath);
		} else {
			r->pwszLogFilePath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDomainName));
		if (_ptr_pszDomainName) {
			NDR_PULL_ALLOC(ndr, r->pszDomainName);
		} else {
			r->pszDomainName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszForestName));
		if (_ptr_pszForestName) {
			NDR_PULL_ALLOC(ndr, r->pszForestName);
		} else {
			r->pszForestName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDomainDirectoryPartition));
		if (_ptr_pszDomainDirectoryPartition) {
			NDR_PULL_ALLOC(ndr, r->pszDomainDirectoryPartition);
		} else {
			r->pszDomainDirectoryPartition = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszForestDirectoryPartition));
		if (_ptr_pszForestDirectoryPartition) {
			NDR_PULL_ALLOC(ndr, r->pszForestDirectoryPartition);
		} else {
			r->pszForestDirectoryPartition = NULL;
		}
		size_pExtensions_0 = 6;
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (size_pExtensions_0); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pExtensions[cntr_pExtensions_0]));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLogLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDebugLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwardTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcProtocol));
		NDR_CHECK(ndr_pull_DNS_NAME_CHECK_FLAG(ndr, NDR_SCALARS, &r->dwNameCheckFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cAddressAnswerLimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRecursionRetry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRecursionTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwMaxCacheTtl));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsPollingInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLocalNetPriorityNetMask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwScavengingInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDefaultRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDefaultNoRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastScavengeTime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwEventLogLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLogFileMaxSize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsForestVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsDomainVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDsDsaVersion));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fReadOnlyDC));
		size_dwReserveArray_0 = 3;
		for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (size_dwReserveArray_0); cntr_dwReserveArray_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserveArray[cntr_dwReserveArray_0]));
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAutoReverseZones));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fAutoCacheUpdate));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fForwardDelegations));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fNoRecursion));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fSecureResponses));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fRoundRobin));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fLocalNetPriority));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fBindSecondaries));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fWriteAuthorityNs));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fStrictFileParsing));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fLooseWildcarding));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fDefaultAgingState));
		size_fReserveArray_0 = 15;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->fReserveArray, size_fReserveArray_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServerName) {
			_mem_save_pszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszServerName, &size_pszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszServerName, &length_pszServerName_1));
			if (length_pszServerName_1 > size_pszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServerName_1, length_pszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServerName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszServerName, length_pszServerName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServerName_0, 0);
		}
		if (r->pszDsContainer) {
			_mem_save_pszDsContainer_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDsContainer, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDsContainer));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDsContainer));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDsContainer, &size_pszDsContainer_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDsContainer, &length_pszDsContainer_1));
			if (length_pszDsContainer_1 > size_pszDsContainer_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDsContainer_1, length_pszDsContainer_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDsContainer_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDsContainer, length_pszDsContainer_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDsContainer_0, 0);
		}
		if (r->aipServerAddrs) {
			_mem_save_aipServerAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipServerAddrs, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipServerAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipServerAddrs_0, 0);
		}
		if (r->aipListenAddrs) {
			_mem_save_aipListenAddrs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipListenAddrs, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipListenAddrs));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipListenAddrs_0, 0);
		}
		if (r->aipForwarders) {
			_mem_save_aipForwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipForwarders, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipForwarders_0, 0);
		}
		if (r->aipLogFilter) {
			_mem_save_aipLogFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipLogFilter, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipLogFilter));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipLogFilter_0, 0);
		}
		if (r->pwszLogFilePath) {
			_mem_save_pwszLogFilePath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pwszLogFilePath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pwszLogFilePath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pwszLogFilePath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pwszLogFilePath, &size_pwszLogFilePath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pwszLogFilePath, &length_pwszLogFilePath_1));
			if (length_pwszLogFilePath_1 > size_pwszLogFilePath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszLogFilePath_1, length_pwszLogFilePath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszLogFilePath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pwszLogFilePath, length_pwszLogFilePath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszLogFilePath_0, 0);
		}
		if (r->pszDomainName) {
			_mem_save_pszDomainName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDomainName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDomainName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDomainName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDomainName, &size_pszDomainName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDomainName, &length_pszDomainName_1));
			if (length_pszDomainName_1 > size_pszDomainName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDomainName_1, length_pszDomainName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDomainName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDomainName, length_pszDomainName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDomainName_0, 0);
		}
		if (r->pszForestName) {
			_mem_save_pszForestName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszForestName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszForestName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszForestName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszForestName, &size_pszForestName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszForestName, &length_pszForestName_1));
			if (length_pszForestName_1 > size_pszForestName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszForestName_1, length_pszForestName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszForestName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszForestName, length_pszForestName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszForestName_0, 0);
		}
		if (r->pszDomainDirectoryPartition) {
			_mem_save_pszDomainDirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDomainDirectoryPartition, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDomainDirectoryPartition));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDomainDirectoryPartition));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDomainDirectoryPartition, &size_pszDomainDirectoryPartition_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDomainDirectoryPartition, &length_pszDomainDirectoryPartition_1));
			if (length_pszDomainDirectoryPartition_1 > size_pszDomainDirectoryPartition_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDomainDirectoryPartition_1, length_pszDomainDirectoryPartition_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDomainDirectoryPartition_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDomainDirectoryPartition, length_pszDomainDirectoryPartition_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDomainDirectoryPartition_0, 0);
		}
		if (r->pszForestDirectoryPartition) {
			_mem_save_pszForestDirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszForestDirectoryPartition, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszForestDirectoryPartition));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszForestDirectoryPartition));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszForestDirectoryPartition, &size_pszForestDirectoryPartition_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszForestDirectoryPartition, &length_pszForestDirectoryPartition_1));
			if (length_pszForestDirectoryPartition_1 > size_pszForestDirectoryPartition_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszForestDirectoryPartition_1, length_pszForestDirectoryPartition_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszForestDirectoryPartition_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszForestDirectoryPartition, length_pszForestDirectoryPartition_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszForestDirectoryPartition_0, 0);
		}
		size_pExtensions_0 = 6;
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (size_pExtensions_0); cntr_pExtensions_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pExtensions[cntr_pExtensions_0]));
		}
		for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (size_pExtensions_0); cntr_pExtensions_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_DNS_RPC_SERVER_INFO_LONGHORN(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct DNS_RPC_SERVER_INFO_LONGHORN *r)
{
	ndr_print_DNS_RPC_SERVER_INFO_LONGHORN(ndr, name, r);
}

_PUBLIC_ void ndr_print_DNS_RPC_SERVER_INFO_LONGHORN(struct ndr_print *ndr, const char *name, const struct DNS_RPC_SERVER_INFO_LONGHORN *r)
{
	uint32_t cntr_pExtensions_0;
	uint32_t cntr_dwReserveArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_SERVER_INFO_LONGHORN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "dwVersion", r->dwVersion);
	ndr_print_DNS_BOOT_METHOD(ndr, "fBootMethod", r->fBootMethod);
	ndr_print_uint8(ndr, "fAdminConfigured", r->fAdminConfigured);
	ndr_print_uint8(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint8(ndr, "fDsAvailable", r->fDsAvailable);
	ndr_print_ptr(ndr, "pszServerName", r->pszServerName);
	ndr->depth++;
	if (r->pszServerName) {
		ndr_print_string(ndr, "pszServerName", r->pszServerName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDsContainer", r->pszDsContainer);
	ndr->depth++;
	if (r->pszDsContainer) {
		ndr_print_string(ndr, "pszDsContainer", r->pszDsContainer);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipServerAddrs", r->aipServerAddrs);
	ndr->depth++;
	if (r->aipServerAddrs) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipServerAddrs", r->aipServerAddrs);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipListenAddrs", r->aipListenAddrs);
	ndr->depth++;
	if (r->aipListenAddrs) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipListenAddrs", r->aipListenAddrs);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipForwarders", r->aipForwarders);
	ndr->depth++;
	if (r->aipForwarders) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipForwarders", r->aipForwarders);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipLogFilter", r->aipLogFilter);
	ndr->depth++;
	if (r->aipLogFilter) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipLogFilter", r->aipLogFilter);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pwszLogFilePath", r->pwszLogFilePath);
	ndr->depth++;
	if (r->pwszLogFilePath) {
		ndr_print_string(ndr, "pwszLogFilePath", r->pwszLogFilePath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDomainName", r->pszDomainName);
	ndr->depth++;
	if (r->pszDomainName) {
		ndr_print_string(ndr, "pszDomainName", r->pszDomainName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszForestName", r->pszForestName);
	ndr->depth++;
	if (r->pszForestName) {
		ndr_print_string(ndr, "pszForestName", r->pszForestName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDomainDirectoryPartition", r->pszDomainDirectoryPartition);
	ndr->depth++;
	if (r->pszDomainDirectoryPartition) {
		ndr_print_string(ndr, "pszDomainDirectoryPartition", r->pszDomainDirectoryPartition);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszForestDirectoryPartition", r->pszForestDirectoryPartition);
	ndr->depth++;
	if (r->pszForestDirectoryPartition) {
		ndr_print_string(ndr, "pszForestDirectoryPartition", r->pszForestDirectoryPartition);
	}
	ndr->depth--;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pExtensions", (uint32_t)(6));
	ndr->depth++;
	for (cntr_pExtensions_0 = 0; cntr_pExtensions_0 < (6); cntr_pExtensions_0++) {
		ndr_print_DNS_EXTENSION(ndr, "pExtensions", &r->pExtensions[cntr_pExtensions_0]);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwLogLevel", r->dwLogLevel);
	ndr_print_uint32(ndr, "dwDebugLevel", r->dwDebugLevel);
	ndr_print_uint32(ndr, "dwForwardTimeout", r->dwForwardTimeout);
	ndr_print_uint32(ndr, "dwRpcProtocol", r->dwRpcProtocol);
	ndr_print_DNS_NAME_CHECK_FLAG(ndr, "dwNameCheckFlag", r->dwNameCheckFlag);
	ndr_print_uint32(ndr, "cAddressAnswerLimit", r->cAddressAnswerLimit);
	ndr_print_uint32(ndr, "dwRecursionRetry", r->dwRecursionRetry);
	ndr_print_uint32(ndr, "dwRecursionTimeout", r->dwRecursionTimeout);
	ndr_print_uint32(ndr, "dwMaxCacheTtl", r->dwMaxCacheTtl);
	ndr_print_uint32(ndr, "dwDsPollingInterval", r->dwDsPollingInterval);
	ndr_print_uint32(ndr, "dwLocalNetPriorityNetMask", r->dwLocalNetPriorityNetMask);
	ndr_print_uint32(ndr, "dwScavengingInterval", r->dwScavengingInterval);
	ndr_print_uint32(ndr, "dwDefaultRefreshInterval", r->dwDefaultRefreshInterval);
	ndr_print_uint32(ndr, "dwDefaultNoRefreshInterval", r->dwDefaultNoRefreshInterval);
	ndr_print_uint32(ndr, "dwLastScavengeTime", r->dwLastScavengeTime);
	ndr_print_uint32(ndr, "dwEventLogLevel", r->dwEventLogLevel);
	ndr_print_uint32(ndr, "dwLogFileMaxSize", r->dwLogFileMaxSize);
	ndr_print_uint32(ndr, "dwDsForestVersion", r->dwDsForestVersion);
	ndr_print_uint32(ndr, "dwDsDomainVersion", r->dwDsDomainVersion);
	ndr_print_uint32(ndr, "dwDsDsaVersion", r->dwDsDsaVersion);
	ndr_print_uint8(ndr, "fReadOnlyDC", r->fReadOnlyDC);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dwReserveArray", (uint32_t)(3));
	ndr->depth++;
	for (cntr_dwReserveArray_0 = 0; cntr_dwReserveArray_0 < (3); cntr_dwReserveArray_0++) {
		ndr_print_uint32(ndr, "dwReserveArray", r->dwReserveArray[cntr_dwReserveArray_0]);
	}
	ndr->depth--;
	ndr_print_uint8(ndr, "fAutoReverseZones", r->fAutoReverseZones);
	ndr_print_uint8(ndr, "fAutoCacheUpdate", r->fAutoCacheUpdate);
	ndr_print_uint8(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint8(ndr, "fForwardDelegations", r->fForwardDelegations);
	ndr_print_uint8(ndr, "fNoRecursion", r->fNoRecursion);
	ndr_print_uint8(ndr, "fSecureResponses", r->fSecureResponses);
	ndr_print_uint8(ndr, "fRoundRobin", r->fRoundRobin);
	ndr_print_uint8(ndr, "fLocalNetPriority", r->fLocalNetPriority);
	ndr_print_uint8(ndr, "fBindSecondaries", r->fBindSecondaries);
	ndr_print_uint8(ndr, "fWriteAuthorityNs", r->fWriteAuthorityNs);
	ndr_print_uint8(ndr, "fStrictFileParsing", r->fStrictFileParsing);
	ndr_print_uint8(ndr, "fLooseWildcarding", r->fLooseWildcarding);
	ndr_print_uint8(ndr, "fDefaultAgingState", r->fDefaultAgingState);
	ndr_print_array_uint8(ndr, "fReserveArray", r->fReserveArray, 15);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_DP_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_DP_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_DP_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_DP_AUTOCREATED", DNS_DP_AUTOCREATED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_DP_LEGACY", DNS_DP_LEGACY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_DP_DOMAIN_DEFAULT", DNS_DP_DOMAIN_DEFAULT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_DP_FOREST_DEFAULT", DNS_DP_FOREST_DEFAULT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_DP_ENLISTED", DNS_DP_ENLISTED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_DP_DELETED", DNS_DP_DELETED, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_DP_REPLICA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_DP_REPLICA *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszReplicaDn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszReplicaDn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszReplicaDn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszReplicaDn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszReplicaDn, ndr_charset_length(r->pszReplicaDn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_DP_REPLICA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_DP_REPLICA *r)
{
	uint32_t _ptr_pszReplicaDn;
	uint32_t size_pszReplicaDn_1 = 0;
	uint32_t length_pszReplicaDn_1 = 0;
	TALLOC_CTX *_mem_save_pszReplicaDn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszReplicaDn));
		if (_ptr_pszReplicaDn) {
			NDR_PULL_ALLOC(ndr, r->pszReplicaDn);
		} else {
			r->pszReplicaDn = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszReplicaDn) {
			_mem_save_pszReplicaDn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszReplicaDn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszReplicaDn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszReplicaDn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszReplicaDn, &size_pszReplicaDn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszReplicaDn, &length_pszReplicaDn_1));
			if (length_pszReplicaDn_1 > size_pszReplicaDn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszReplicaDn_1, length_pszReplicaDn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszReplicaDn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszReplicaDn, length_pszReplicaDn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszReplicaDn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_DP_REPLICA(struct ndr_print *ndr, const char *name, const struct DNS_RPC_DP_REPLICA *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_DP_REPLICA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pszReplicaDn", r->pszReplicaDn);
	ndr->depth++;
	if (r->pszReplicaDn) {
		ndr_print_string(ndr, "pszReplicaDn", r->pszReplicaDn);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_DP_STATE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_DP_STATE r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_DP_STATE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_DP_STATE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_DP_STATE(struct ndr_print *ndr, const char *name, enum DNS_DP_STATE r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_DP_OKAY: val = "DNS_DP_OKAY"; break;
		case DNS_DP_STATE_REPL_INCOMING: val = "DNS_DP_STATE_REPL_INCOMING"; break;
		case DNS_DP_STATE_REPL_OUTGOING: val = "DNS_DP_STATE_REPL_OUTGOING"; break;
		case DNS_DP_STATE_UNKNOWN: val = "DNS_DP_STATE_UNKNOWN"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_RPC_DP_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_DP_INFO *r)
{
	uint32_t cntr_dwReserved_0;
	uint32_t cntr_pwszReserved_0;
	uint32_t cntr_ReplicaArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwReplicaCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpDn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszCrDn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneCount));
		NDR_CHECK(ndr_push_DNS_DP_STATE(ndr, NDR_SCALARS, r->dwState));
		for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (3); cntr_dwReserved_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved[cntr_dwReserved_0]));
		}
		for (cntr_pwszReserved_0 = 0; cntr_pwszReserved_0 < (3); cntr_pwszReserved_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pwszReserved[cntr_pwszReserved_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReplicaCount));
		for (cntr_ReplicaArray_0 = 0; cntr_ReplicaArray_0 < (r->dwReplicaCount); cntr_ReplicaArray_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->ReplicaArray[cntr_ReplicaArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDpDn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpDn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpDn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpDn, ndr_charset_length(r->pszDpDn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pszCrDn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszCrDn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszCrDn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszCrDn, ndr_charset_length(r->pszCrDn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		for (cntr_pwszReserved_0 = 0; cntr_pwszReserved_0 < (3); cntr_pwszReserved_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pwszReserved[cntr_pwszReserved_0]));
		}
		for (cntr_ReplicaArray_0 = 0; cntr_ReplicaArray_0 < (r->dwReplicaCount); cntr_ReplicaArray_0++) {
			if (r->ReplicaArray[cntr_ReplicaArray_0]) {
				NDR_CHECK(ndr_push_DNS_RPC_DP_REPLICA(ndr, NDR_SCALARS|NDR_BUFFERS, r->ReplicaArray[cntr_ReplicaArray_0]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_DP_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_DP_INFO *r)
{
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	uint32_t _ptr_pszDpDn;
	uint32_t size_pszDpDn_1 = 0;
	uint32_t length_pszDpDn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpDn_0 = NULL;
	uint32_t _ptr_pszCrDn;
	uint32_t size_pszCrDn_1 = 0;
	uint32_t length_pszCrDn_1 = 0;
	TALLOC_CTX *_mem_save_pszCrDn_0 = NULL;
	uint32_t size_dwReserved_0 = 0;
	uint32_t cntr_dwReserved_0;
	uint32_t size_pwszReserved_0 = 0;
	uint32_t cntr_pwszReserved_0;
	uint32_t _ptr_ReplicaArray;
	uint32_t size_ReplicaArray_0 = 0;
	uint32_t cntr_ReplicaArray_0;
	TALLOC_CTX *_mem_save_ReplicaArray_0 = NULL;
	TALLOC_CTX *_mem_save_ReplicaArray_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->ReplicaArray));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpDn));
		if (_ptr_pszDpDn) {
			NDR_PULL_ALLOC(ndr, r->pszDpDn);
		} else {
			r->pszDpDn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszCrDn));
		if (_ptr_pszCrDn) {
			NDR_PULL_ALLOC(ndr, r->pszCrDn);
		} else {
			r->pszCrDn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneCount));
		NDR_CHECK(ndr_pull_DNS_DP_STATE(ndr, NDR_SCALARS, &r->dwState));
		size_dwReserved_0 = 3;
		for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (size_dwReserved_0); cntr_dwReserved_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved[cntr_dwReserved_0]));
		}
		size_pwszReserved_0 = 3;
		for (cntr_pwszReserved_0 = 0; cntr_pwszReserved_0 < (size_pwszReserved_0); cntr_pwszReserved_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pwszReserved[cntr_pwszReserved_0]));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReplicaCount));
		if (r->dwReplicaCount > 10000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->dwReplicaCount), (uint32_t)(0), (uint32_t)(10000));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ReplicaArray, &size_ReplicaArray_0));
		NDR_PULL_ALLOC_N(ndr, r->ReplicaArray, size_ReplicaArray_0);
		_mem_save_ReplicaArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ReplicaArray, 0);
		for (cntr_ReplicaArray_0 = 0; cntr_ReplicaArray_0 < (size_ReplicaArray_0); cntr_ReplicaArray_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ReplicaArray));
			if (_ptr_ReplicaArray) {
				NDR_PULL_ALLOC(ndr, r->ReplicaArray[cntr_ReplicaArray_0]);
			} else {
				r->ReplicaArray[cntr_ReplicaArray_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReplicaArray_0, 0);
		if (r->ReplicaArray) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ReplicaArray, r->dwReplicaCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
		if (r->pszDpDn) {
			_mem_save_pszDpDn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpDn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpDn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpDn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpDn, &size_pszDpDn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpDn, &length_pszDpDn_1));
			if (length_pszDpDn_1 > size_pszDpDn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpDn_1, length_pszDpDn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpDn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpDn, length_pszDpDn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpDn_0, 0);
		}
		if (r->pszCrDn) {
			_mem_save_pszCrDn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszCrDn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszCrDn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszCrDn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszCrDn, &size_pszCrDn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszCrDn, &length_pszCrDn_1));
			if (length_pszCrDn_1 > size_pszCrDn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszCrDn_1, length_pszCrDn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszCrDn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszCrDn, length_pszCrDn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszCrDn_0, 0);
		}
		size_pwszReserved_0 = 3;
		for (cntr_pwszReserved_0 = 0; cntr_pwszReserved_0 < (size_pwszReserved_0); cntr_pwszReserved_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pwszReserved[cntr_pwszReserved_0]));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ReplicaArray, &size_ReplicaArray_0));
		_mem_save_ReplicaArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ReplicaArray, 0);
		for (cntr_ReplicaArray_0 = 0; cntr_ReplicaArray_0 < (size_ReplicaArray_0); cntr_ReplicaArray_0++) {
			if (r->ReplicaArray[cntr_ReplicaArray_0]) {
				_mem_save_ReplicaArray_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ReplicaArray[cntr_ReplicaArray_0], 0);
				NDR_CHECK(ndr_pull_DNS_RPC_DP_REPLICA(ndr, NDR_SCALARS|NDR_BUFFERS, r->ReplicaArray[cntr_ReplicaArray_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReplicaArray_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ReplicaArray_0, 0);
		for (cntr_pwszReserved_0 = 0; cntr_pwszReserved_0 < (size_pwszReserved_0); cntr_pwszReserved_0++) {
		}
		for (cntr_ReplicaArray_0 = 0; cntr_ReplicaArray_0 < (size_ReplicaArray_0); cntr_ReplicaArray_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_DP_INFO(struct ndr_print *ndr, const char *name, const struct DNS_RPC_DP_INFO *r)
{
	uint32_t cntr_dwReserved_0;
	uint32_t cntr_pwszReserved_0;
	uint32_t cntr_ReplicaArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_DP_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszDpDn", r->pszDpDn);
	ndr->depth++;
	if (r->pszDpDn) {
		ndr_print_string(ndr, "pszDpDn", r->pszDpDn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszCrDn", r->pszCrDn);
	ndr->depth++;
	if (r->pszCrDn) {
		ndr_print_string(ndr, "pszCrDn", r->pszCrDn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_uint32(ndr, "dwZoneCount", r->dwZoneCount);
	ndr_print_DNS_DP_STATE(ndr, "dwState", r->dwState);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dwReserved", (uint32_t)(3));
	ndr->depth++;
	for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (3); cntr_dwReserved_0++) {
		ndr_print_uint32(ndr, "dwReserved", r->dwReserved[cntr_dwReserved_0]);
	}
	ndr->depth--;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pwszReserved", (uint32_t)(3));
	ndr->depth++;
	for (cntr_pwszReserved_0 = 0; cntr_pwszReserved_0 < (3); cntr_pwszReserved_0++) {
		ndr_print_DNS_EXTENSION(ndr, "pwszReserved", &r->pwszReserved[cntr_pwszReserved_0]);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwReplicaCount", r->dwReplicaCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ReplicaArray", (uint32_t)(r->dwReplicaCount));
	ndr->depth++;
	for (cntr_ReplicaArray_0 = 0; cntr_ReplicaArray_0 < (r->dwReplicaCount); cntr_ReplicaArray_0++) {
		ndr_print_ptr(ndr, "ReplicaArray", r->ReplicaArray[cntr_ReplicaArray_0]);
		ndr->depth++;
		if (r->ReplicaArray[cntr_ReplicaArray_0]) {
			ndr_print_DNS_RPC_DP_REPLICA(ndr, "ReplicaArray", r->ReplicaArray[cntr_ReplicaArray_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_DP_ENUM(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_DP_ENUM *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneCount));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_DP_ENUM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_DP_ENUM *r)
{
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneCount));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_DP_ENUM(struct ndr_print *ndr, const char *name, const struct DNS_RPC_DP_ENUM *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_DP_ENUM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_uint32(ndr, "dwZoneCount", r->dwZoneCount);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_DP_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_DP_LIST *r)
{
	uint32_t cntr_DpArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwDpCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDpCount));
		for (cntr_DpArray_0 = 0; cntr_DpArray_0 < (r->dwDpCount); cntr_DpArray_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->DpArray[cntr_DpArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_DpArray_0 = 0; cntr_DpArray_0 < (r->dwDpCount); cntr_DpArray_0++) {
			if (r->DpArray[cntr_DpArray_0]) {
				NDR_CHECK(ndr_push_DNS_RPC_DP_ENUM(ndr, NDR_SCALARS|NDR_BUFFERS, r->DpArray[cntr_DpArray_0]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_DP_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_DP_LIST *r)
{
	uint32_t _ptr_DpArray;
	uint32_t size_DpArray_0 = 0;
	uint32_t cntr_DpArray_0;
	TALLOC_CTX *_mem_save_DpArray_0 = NULL;
	TALLOC_CTX *_mem_save_DpArray_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->DpArray));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDpCount));
		if (r->dwDpCount > 5000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->dwDpCount), (uint32_t)(0), (uint32_t)(5000));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->DpArray, &size_DpArray_0));
		NDR_PULL_ALLOC_N(ndr, r->DpArray, size_DpArray_0);
		_mem_save_DpArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->DpArray, 0);
		for (cntr_DpArray_0 = 0; cntr_DpArray_0 < (size_DpArray_0); cntr_DpArray_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DpArray));
			if (_ptr_DpArray) {
				NDR_PULL_ALLOC(ndr, r->DpArray[cntr_DpArray_0]);
			} else {
				r->DpArray[cntr_DpArray_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DpArray_0, 0);
		if (r->DpArray) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->DpArray, r->dwDpCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->DpArray, &size_DpArray_0));
		_mem_save_DpArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->DpArray, 0);
		for (cntr_DpArray_0 = 0; cntr_DpArray_0 < (size_DpArray_0); cntr_DpArray_0++) {
			if (r->DpArray[cntr_DpArray_0]) {
				_mem_save_DpArray_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DpArray[cntr_DpArray_0], 0);
				NDR_CHECK(ndr_pull_DNS_RPC_DP_ENUM(ndr, NDR_SCALARS|NDR_BUFFERS, r->DpArray[cntr_DpArray_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DpArray_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DpArray_0, 0);
		for (cntr_DpArray_0 = 0; cntr_DpArray_0 < (size_DpArray_0); cntr_DpArray_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_DP_LIST(struct ndr_print *ndr, const char *name, const struct DNS_RPC_DP_LIST *r)
{
	uint32_t cntr_DpArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_DP_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "dwDpCount", r->dwDpCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "DpArray", (uint32_t)(r->dwDpCount));
	ndr->depth++;
	for (cntr_DpArray_0 = 0; cntr_DpArray_0 < (r->dwDpCount); cntr_DpArray_0++) {
		ndr_print_ptr(ndr, "DpArray", r->DpArray[cntr_DpArray_0]);
		ndr->depth++;
		if (r->DpArray[cntr_DpArray_0]) {
			ndr_print_DNS_RPC_DP_ENUM(ndr, "DpArray", r->DpArray[cntr_DpArray_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ENLIST_DP(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ENLIST_DP *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwOperation));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ENLIST_DP(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ENLIST_DP *r)
{
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwOperation));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ENLIST_DP(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ENLIST_DP *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ENLIST_DP");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwOperation", r->dwOperation);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_CHANGE_DP(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_CHANGE_DP *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDestPartition));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDestPartition) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDestPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDestPartition, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDestPartition, ndr_charset_length(r->pszDestPartition, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_CHANGE_DP(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_CHANGE_DP *r)
{
	uint32_t _ptr_pszDestPartition;
	uint32_t size_pszDestPartition_1 = 0;
	uint32_t length_pszDestPartition_1 = 0;
	TALLOC_CTX *_mem_save_pszDestPartition_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDestPartition));
		if (_ptr_pszDestPartition) {
			NDR_PULL_ALLOC(ndr, r->pszDestPartition);
		} else {
			r->pszDestPartition = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszDestPartition) {
			_mem_save_pszDestPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDestPartition, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDestPartition));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDestPartition));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDestPartition, &size_pszDestPartition_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDestPartition, &length_pszDestPartition_1));
			if (length_pszDestPartition_1 > size_pszDestPartition_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDestPartition_1, length_pszDestPartition_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDestPartition_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDestPartition, length_pszDestPartition_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDestPartition_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_CHANGE_DP(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_CHANGE_DP *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_CHANGE_DP");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszDestPartition", r->pszDestPartition);
	ndr->depth++;
	if (r->pszDestPartition) {
		ndr_print_string(ndr, "pszDestPartition", r->pszDestPartition);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_ZONE_SECONDARY_SECURITY(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_ZONE_SECONDARY_SECURITY r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_ZONE_SECONDARY_SECURITY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_ZONE_SECONDARY_SECURITY *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_ZONE_SECONDARY_SECURITY(struct ndr_print *ndr, const char *name, enum DNS_ZONE_SECONDARY_SECURITY r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_ZONE_SECSECURE_NO_SECURITY: val = "DNS_ZONE_SECSECURE_NO_SECURITY"; break;
		case DNS_ZONE_SECSECURE_NS_ONLY: val = "DNS_ZONE_SECSECURE_NS_ONLY"; break;
		case DNS_ZONE_SECSECURE_LIST_ONLY: val = "DNS_ZONE_SECSECURE_LIST_ONLY"; break;
		case DNS_ZONE_SECSECURE_NO_XFER: val = "DNS_ZONE_SECSECURE_NO_XFER"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_ZONE_NOTIFY_LEVEL(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_ZONE_NOTIFY_LEVEL r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_ZONE_NOTIFY_LEVEL(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_ZONE_NOTIFY_LEVEL *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_ZONE_NOTIFY_LEVEL(struct ndr_print *ndr, const char *name, enum DNS_ZONE_NOTIFY_LEVEL r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_ZONE_NOTIFY_OFF: val = "DNS_ZONE_NOTIFY_OFF"; break;
		case DNS_ZONE_NOTIFY_ALL_SECONDARIES: val = "DNS_ZONE_NOTIFY_ALL_SECONDARIES"; break;
		case DNS_ZONE_NOTIFY_LIST_ONLY: val = "DNS_ZONE_NOTIFY_LIST_ONLY"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_PAUSED", DNS_RPC_ZONE_PAUSED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_SHUTDOWN", DNS_RPC_ZONE_SHUTDOWN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_REVERSE", DNS_RPC_ZONE_REVERSE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_AUTOCREATED", DNS_RPC_ZONE_AUTOCREATED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_DSINTEGRATED", DNS_RPC_ZONE_DSINTEGRATED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_AGING", DNS_RPC_ZONE_AGING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_UPDATE_UNSECURE", DNS_RPC_ZONE_UPDATE_UNSECURE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_UPDATE_SECURE", DNS_RPC_ZONE_UPDATE_SECURE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_ZONE_READONLY", DNS_RPC_ZONE_READONLY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_W2K *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_DNS_RPC_ZONE_FLAGS(ndr, NDR_SCALARS, r->Flags));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ZoneType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Version));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_W2K *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_RPC_ZONE_FLAGS(ndr, NDR_SCALARS, &r->Flags));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ZoneType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_W2K *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_DNS_RPC_ZONE_FLAGS(ndr, "Flags", r->Flags);
	ndr_print_uint8(ndr, "ZoneType", r->ZoneType);
	ndr_print_uint8(ndr, "Version", r->Version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_DOTNET *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_DNS_RPC_ZONE_FLAGS(ndr, NDR_SCALARS, r->Flags));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->ZoneType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->Version));
		NDR_CHECK(ndr_push_DNS_RPC_DP_FLAGS(ndr, NDR_SCALARS, r->dwDpFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_DOTNET *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_RPC_ZONE_FLAGS(ndr, NDR_SCALARS, &r->Flags));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->ZoneType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_pull_DNS_RPC_DP_FLAGS(ndr, NDR_SCALARS, &r->dwDpFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_DOTNET *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_DNS_RPC_ZONE_FLAGS(ndr, "Flags", r->Flags);
	ndr_print_uint8(ndr, "ZoneType", r->ZoneType);
	ndr_print_uint8(ndr, "Version", r->Version);
	ndr_print_DNS_RPC_DP_FLAGS(ndr, "dwDpFlags", r->dwDpFlags);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_LIST_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_LIST_W2K *r)
{
	uint32_t cntr_ZoneArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwZoneCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneCount));
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (r->dwZoneCount); cntr_ZoneArray_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneArray[cntr_ZoneArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (r->dwZoneCount); cntr_ZoneArray_0++) {
			if (r->ZoneArray[cntr_ZoneArray_0]) {
				NDR_CHECK(ndr_push_DNS_RPC_ZONE_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneArray[cntr_ZoneArray_0]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_LIST_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_LIST_W2K *r)
{
	uint32_t _ptr_ZoneArray;
	uint32_t size_ZoneArray_0 = 0;
	uint32_t cntr_ZoneArray_0;
	TALLOC_CTX *_mem_save_ZoneArray_0 = NULL;
	TALLOC_CTX *_mem_save_ZoneArray_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->ZoneArray));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneCount));
		if (r->dwZoneCount > 500000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->dwZoneCount), (uint32_t)(0), (uint32_t)(500000));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ZoneArray, &size_ZoneArray_0));
		NDR_PULL_ALLOC_N(ndr, r->ZoneArray, size_ZoneArray_0);
		_mem_save_ZoneArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ZoneArray, 0);
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (size_ZoneArray_0); cntr_ZoneArray_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneArray));
			if (_ptr_ZoneArray) {
				NDR_PULL_ALLOC(ndr, r->ZoneArray[cntr_ZoneArray_0]);
			} else {
				r->ZoneArray[cntr_ZoneArray_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneArray_0, 0);
		if (r->ZoneArray) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ZoneArray, r->dwZoneCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ZoneArray, &size_ZoneArray_0));
		_mem_save_ZoneArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ZoneArray, 0);
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (size_ZoneArray_0); cntr_ZoneArray_0++) {
			if (r->ZoneArray[cntr_ZoneArray_0]) {
				_mem_save_ZoneArray_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ZoneArray[cntr_ZoneArray_0], 0);
				NDR_CHECK(ndr_pull_DNS_RPC_ZONE_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneArray[cntr_ZoneArray_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneArray_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneArray_0, 0);
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (size_ZoneArray_0); cntr_ZoneArray_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_LIST_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_LIST_W2K *r)
{
	uint32_t cntr_ZoneArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_LIST_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwZoneCount", r->dwZoneCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ZoneArray", (uint32_t)(r->dwZoneCount));
	ndr->depth++;
	for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (r->dwZoneCount); cntr_ZoneArray_0++) {
		ndr_print_ptr(ndr, "ZoneArray", r->ZoneArray[cntr_ZoneArray_0]);
		ndr->depth++;
		if (r->ZoneArray[cntr_ZoneArray_0]) {
			ndr_print_DNS_RPC_ZONE_W2K(ndr, "ZoneArray", r->ZoneArray[cntr_ZoneArray_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_LIST_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_LIST_DOTNET *r)
{
	uint32_t cntr_ZoneArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->dwZoneCount));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneCount));
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (r->dwZoneCount); cntr_ZoneArray_0++) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneArray[cntr_ZoneArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (r->dwZoneCount); cntr_ZoneArray_0++) {
			if (r->ZoneArray[cntr_ZoneArray_0]) {
				NDR_CHECK(ndr_push_DNS_RPC_ZONE_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneArray[cntr_ZoneArray_0]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_LIST_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_LIST_DOTNET *r)
{
	uint32_t _ptr_ZoneArray;
	uint32_t size_ZoneArray_0 = 0;
	uint32_t cntr_ZoneArray_0;
	TALLOC_CTX *_mem_save_ZoneArray_0 = NULL;
	TALLOC_CTX *_mem_save_ZoneArray_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->ZoneArray));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneCount));
		if (r->dwZoneCount > 500000) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->dwZoneCount), (uint32_t)(0), (uint32_t)(500000));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ZoneArray, &size_ZoneArray_0));
		NDR_PULL_ALLOC_N(ndr, r->ZoneArray, size_ZoneArray_0);
		_mem_save_ZoneArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ZoneArray, 0);
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (size_ZoneArray_0); cntr_ZoneArray_0++) {
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneArray));
			if (_ptr_ZoneArray) {
				NDR_PULL_ALLOC(ndr, r->ZoneArray[cntr_ZoneArray_0]);
			} else {
				r->ZoneArray[cntr_ZoneArray_0] = NULL;
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneArray_0, 0);
		if (r->ZoneArray) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->ZoneArray, r->dwZoneCount));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->ZoneArray, &size_ZoneArray_0));
		_mem_save_ZoneArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->ZoneArray, 0);
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (size_ZoneArray_0); cntr_ZoneArray_0++) {
			if (r->ZoneArray[cntr_ZoneArray_0]) {
				_mem_save_ZoneArray_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ZoneArray[cntr_ZoneArray_0], 0);
				NDR_CHECK(ndr_pull_DNS_RPC_ZONE_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneArray[cntr_ZoneArray_0]));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneArray_1, 0);
			}
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneArray_0, 0);
		for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (size_ZoneArray_0); cntr_ZoneArray_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_LIST_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_LIST_DOTNET *r)
{
	uint32_t cntr_ZoneArray_0;
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_LIST_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "dwZoneCount", r->dwZoneCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "ZoneArray", (uint32_t)(r->dwZoneCount));
	ndr->depth++;
	for (cntr_ZoneArray_0 = 0; cntr_ZoneArray_0 < (r->dwZoneCount); cntr_ZoneArray_0++) {
		ndr_print_ptr(ndr, "ZoneArray", r->ZoneArray[cntr_ZoneArray_0]);
		ndr->depth++;
		if (r->ZoneArray[cntr_ZoneArray_0]) {
			ndr_print_DNS_RPC_ZONE_DOTNET(ndr, "ZoneArray", r->ZoneArray[cntr_ZoneArray_0]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_INFO_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_INFO_W2K *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fReverse));
		NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fPaused));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fShutdown));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAutoCreated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseDatabase));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDataFile));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipMasters));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipNotify));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseWins));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseNbstat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAging));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNoRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwAvailForScavengeTime));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipScavengeServers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pvReserved1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pvReserved2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pvReserved3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pvReserved4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDataFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDataFile, ndr_charset_length(r->pszDataFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipMasters) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
		}
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->aipNotify) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
		}
		if (r->aipScavengeServers) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipScavengeServers));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_INFO_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_INFO_W2K *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDataFile;
	uint32_t size_pszDataFile_1 = 0;
	uint32_t length_pszDataFile_1 = 0;
	TALLOC_CTX *_mem_save_pszDataFile_0 = NULL;
	uint32_t _ptr_aipMasters;
	TALLOC_CTX *_mem_save_aipMasters_0 = NULL;
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_aipNotify;
	TALLOC_CTX *_mem_save_aipNotify_0 = NULL;
	uint32_t _ptr_aipScavengeServers;
	TALLOC_CTX *_mem_save_aipScavengeServers_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fReverse));
		NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fPaused));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fShutdown));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAutoCreated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseDatabase));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDataFile));
		if (_ptr_pszDataFile) {
			NDR_PULL_ALLOC(ndr, r->pszDataFile);
		} else {
			r->pszDataFile = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipMasters));
		if (_ptr_aipMasters) {
			NDR_PULL_ALLOC(ndr, r->aipMasters);
		} else {
			r->aipMasters = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipNotify));
		if (_ptr_aipNotify) {
			NDR_PULL_ALLOC(ndr, r->aipNotify);
		} else {
			r->aipNotify = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseWins));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseNbstat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAging));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNoRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwAvailForScavengeTime));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipScavengeServers));
		if (_ptr_aipScavengeServers) {
			NDR_PULL_ALLOC(ndr, r->aipScavengeServers);
		} else {
			r->aipScavengeServers = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pvReserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pvReserved2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pvReserved3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pvReserved4));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDataFile) {
			_mem_save_pszDataFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDataFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDataFile, &size_pszDataFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDataFile, &length_pszDataFile_1));
			if (length_pszDataFile_1 > size_pszDataFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataFile_1, length_pszDataFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDataFile, length_pszDataFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDataFile_0, 0);
		}
		if (r->aipMasters) {
			_mem_save_aipMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipMasters, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipMasters_0, 0);
		}
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->aipNotify) {
			_mem_save_aipNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipNotify, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipNotify_0, 0);
		}
		if (r->aipScavengeServers) {
			_mem_save_aipScavengeServers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipScavengeServers, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipScavengeServers));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipScavengeServers_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_INFO_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_INFO_W2K *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_INFO_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwZoneType", r->dwZoneType);
	ndr_print_uint32(ndr, "fReverse", r->fReverse);
	ndr_print_dns_zone_update(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint32(ndr, "fPaused", r->fPaused);
	ndr_print_uint32(ndr, "fShutdown", r->fShutdown);
	ndr_print_uint32(ndr, "fAutoCreated", r->fAutoCreated);
	ndr_print_uint32(ndr, "fUseDatabase", r->fUseDatabase);
	ndr_print_ptr(ndr, "pszDataFile", r->pszDataFile);
	ndr->depth++;
	if (r->pszDataFile) {
		ndr_print_string(ndr, "pszDataFile", r->pszDataFile);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipMasters", r->aipMasters);
	ndr->depth++;
	if (r->aipMasters) {
		ndr_print_IP4_ARRAY(ndr, "aipMasters", r->aipMasters);
	}
	ndr->depth--;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_IP4_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipNotify", r->aipNotify);
	ndr->depth++;
	if (r->aipNotify) {
		ndr_print_IP4_ARRAY(ndr, "aipNotify", r->aipNotify);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "fUseWins", r->fUseWins);
	ndr_print_uint32(ndr, "fUseNbstat", r->fUseNbstat);
	ndr_print_uint32(ndr, "fAging", r->fAging);
	ndr_print_uint32(ndr, "dwNoRefreshInterval", r->dwNoRefreshInterval);
	ndr_print_uint32(ndr, "dwRefreshInterval", r->dwRefreshInterval);
	ndr_print_uint32(ndr, "dwAvailForScavengeTime", r->dwAvailForScavengeTime);
	ndr_print_ptr(ndr, "aipScavengeServers", r->aipScavengeServers);
	ndr->depth++;
	if (r->aipScavengeServers) {
		ndr_print_IP4_ARRAY(ndr, "aipScavengeServers", r->aipScavengeServers);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "pvReserved1", r->pvReserved1);
	ndr_print_uint32(ndr, "pvReserved2", r->pvReserved2);
	ndr_print_uint32(ndr, "pvReserved3", r->pvReserved3);
	ndr_print_uint32(ndr, "pvReserved4", r->pvReserved4);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_INFO_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_INFO_DOTNET *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fReverse));
		NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fPaused));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fShutdown));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAutoCreated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseDatabase));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDataFile));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipMasters));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipNotify));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseWins));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseNbstat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAging));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNoRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwAvailForScavengeTime));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipScavengeServers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwarderTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fForwarderSlave));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipLocalMasters));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDpFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pwszZoneDn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastSuccessfulSoaCheck));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastSuccessfulXfr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pReserved1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pReserved2));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pReserved3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pReserved4));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDataFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDataFile, ndr_charset_length(r->pszDataFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipMasters) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
		}
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->aipNotify) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
		}
		if (r->aipScavengeServers) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipScavengeServers));
		}
		if (r->aipLocalMasters) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipLocalMasters));
		}
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pwszZoneDn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszZoneDn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszZoneDn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pwszZoneDn, ndr_charset_length(r->pwszZoneDn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pReserved1) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved1, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved1, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pReserved1, ndr_charset_length(r->pReserved1, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pReserved2) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved2, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved2, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pReserved2, ndr_charset_length(r->pReserved2, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pReserved3) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved3, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved3, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pReserved3, ndr_charset_length(r->pReserved3, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pReserved4) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved4, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pReserved4, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pReserved4, ndr_charset_length(r->pReserved4, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_INFO_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_INFO_DOTNET *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDataFile;
	uint32_t size_pszDataFile_1 = 0;
	uint32_t length_pszDataFile_1 = 0;
	TALLOC_CTX *_mem_save_pszDataFile_0 = NULL;
	uint32_t _ptr_aipMasters;
	TALLOC_CTX *_mem_save_aipMasters_0 = NULL;
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_aipNotify;
	TALLOC_CTX *_mem_save_aipNotify_0 = NULL;
	uint32_t _ptr_aipScavengeServers;
	TALLOC_CTX *_mem_save_aipScavengeServers_0 = NULL;
	uint32_t _ptr_aipLocalMasters;
	TALLOC_CTX *_mem_save_aipLocalMasters_0 = NULL;
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	uint32_t _ptr_pwszZoneDn;
	uint32_t size_pwszZoneDn_1 = 0;
	uint32_t length_pwszZoneDn_1 = 0;
	TALLOC_CTX *_mem_save_pwszZoneDn_0 = NULL;
	uint32_t _ptr_pReserved1;
	uint32_t size_pReserved1_1 = 0;
	uint32_t length_pReserved1_1 = 0;
	TALLOC_CTX *_mem_save_pReserved1_0 = NULL;
	uint32_t _ptr_pReserved2;
	uint32_t size_pReserved2_1 = 0;
	uint32_t length_pReserved2_1 = 0;
	TALLOC_CTX *_mem_save_pReserved2_0 = NULL;
	uint32_t _ptr_pReserved3;
	uint32_t size_pReserved3_1 = 0;
	uint32_t length_pReserved3_1 = 0;
	TALLOC_CTX *_mem_save_pReserved3_0 = NULL;
	uint32_t _ptr_pReserved4;
	uint32_t size_pReserved4_1 = 0;
	uint32_t length_pReserved4_1 = 0;
	TALLOC_CTX *_mem_save_pReserved4_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fReverse));
		NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fPaused));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fShutdown));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAutoCreated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseDatabase));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDataFile));
		if (_ptr_pszDataFile) {
			NDR_PULL_ALLOC(ndr, r->pszDataFile);
		} else {
			r->pszDataFile = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipMasters));
		if (_ptr_aipMasters) {
			NDR_PULL_ALLOC(ndr, r->aipMasters);
		} else {
			r->aipMasters = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipNotify));
		if (_ptr_aipNotify) {
			NDR_PULL_ALLOC(ndr, r->aipNotify);
		} else {
			r->aipNotify = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseWins));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseNbstat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAging));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNoRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwAvailForScavengeTime));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipScavengeServers));
		if (_ptr_aipScavengeServers) {
			NDR_PULL_ALLOC(ndr, r->aipScavengeServers);
		} else {
			r->aipScavengeServers = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwarderTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fForwarderSlave));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipLocalMasters));
		if (_ptr_aipLocalMasters) {
			NDR_PULL_ALLOC(ndr, r->aipLocalMasters);
		} else {
			r->aipLocalMasters = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDpFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszZoneDn));
		if (_ptr_pwszZoneDn) {
			NDR_PULL_ALLOC(ndr, r->pwszZoneDn);
		} else {
			r->pwszZoneDn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastSuccessfulSoaCheck));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastSuccessfulXfr));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pReserved1));
		if (_ptr_pReserved1) {
			NDR_PULL_ALLOC(ndr, r->pReserved1);
		} else {
			r->pReserved1 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pReserved2));
		if (_ptr_pReserved2) {
			NDR_PULL_ALLOC(ndr, r->pReserved2);
		} else {
			r->pReserved2 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pReserved3));
		if (_ptr_pReserved3) {
			NDR_PULL_ALLOC(ndr, r->pReserved3);
		} else {
			r->pReserved3 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pReserved4));
		if (_ptr_pReserved4) {
			NDR_PULL_ALLOC(ndr, r->pReserved4);
		} else {
			r->pReserved4 = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDataFile) {
			_mem_save_pszDataFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDataFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDataFile, &size_pszDataFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDataFile, &length_pszDataFile_1));
			if (length_pszDataFile_1 > size_pszDataFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataFile_1, length_pszDataFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDataFile, length_pszDataFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDataFile_0, 0);
		}
		if (r->aipMasters) {
			_mem_save_aipMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipMasters, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipMasters_0, 0);
		}
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->aipNotify) {
			_mem_save_aipNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipNotify, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipNotify_0, 0);
		}
		if (r->aipScavengeServers) {
			_mem_save_aipScavengeServers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipScavengeServers, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipScavengeServers));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipScavengeServers_0, 0);
		}
		if (r->aipLocalMasters) {
			_mem_save_aipLocalMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipLocalMasters, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipLocalMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipLocalMasters_0, 0);
		}
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
		if (r->pwszZoneDn) {
			_mem_save_pwszZoneDn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pwszZoneDn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pwszZoneDn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pwszZoneDn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pwszZoneDn, &size_pwszZoneDn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pwszZoneDn, &length_pwszZoneDn_1));
			if (length_pwszZoneDn_1 > size_pwszZoneDn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszZoneDn_1, length_pwszZoneDn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszZoneDn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pwszZoneDn, length_pwszZoneDn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszZoneDn_0, 0);
		}
		if (r->pReserved1) {
			_mem_save_pReserved1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pReserved1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pReserved1));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pReserved1));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pReserved1, &size_pReserved1_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pReserved1, &length_pReserved1_1));
			if (length_pReserved1_1 > size_pReserved1_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pReserved1_1, length_pReserved1_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pReserved1_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pReserved1, length_pReserved1_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pReserved1_0, 0);
		}
		if (r->pReserved2) {
			_mem_save_pReserved2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pReserved2, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pReserved2));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pReserved2));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pReserved2, &size_pReserved2_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pReserved2, &length_pReserved2_1));
			if (length_pReserved2_1 > size_pReserved2_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pReserved2_1, length_pReserved2_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pReserved2_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pReserved2, length_pReserved2_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pReserved2_0, 0);
		}
		if (r->pReserved3) {
			_mem_save_pReserved3_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pReserved3, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pReserved3));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pReserved3));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pReserved3, &size_pReserved3_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pReserved3, &length_pReserved3_1));
			if (length_pReserved3_1 > size_pReserved3_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pReserved3_1, length_pReserved3_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pReserved3_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pReserved3, length_pReserved3_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pReserved3_0, 0);
		}
		if (r->pReserved4) {
			_mem_save_pReserved4_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pReserved4, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pReserved4));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pReserved4));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pReserved4, &size_pReserved4_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pReserved4, &length_pReserved4_1));
			if (length_pReserved4_1 > size_pReserved4_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pReserved4_1, length_pReserved4_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pReserved4_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pReserved4, length_pReserved4_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pReserved4_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_INFO_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_INFO_DOTNET *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_INFO_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwZoneType", r->dwZoneType);
	ndr_print_uint32(ndr, "fReverse", r->fReverse);
	ndr_print_dns_zone_update(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint32(ndr, "fPaused", r->fPaused);
	ndr_print_uint32(ndr, "fShutdown", r->fShutdown);
	ndr_print_uint32(ndr, "fAutoCreated", r->fAutoCreated);
	ndr_print_uint32(ndr, "fUseDatabase", r->fUseDatabase);
	ndr_print_ptr(ndr, "pszDataFile", r->pszDataFile);
	ndr->depth++;
	if (r->pszDataFile) {
		ndr_print_string(ndr, "pszDataFile", r->pszDataFile);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipMasters", r->aipMasters);
	ndr->depth++;
	if (r->aipMasters) {
		ndr_print_IP4_ARRAY(ndr, "aipMasters", r->aipMasters);
	}
	ndr->depth--;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_IP4_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipNotify", r->aipNotify);
	ndr->depth++;
	if (r->aipNotify) {
		ndr_print_IP4_ARRAY(ndr, "aipNotify", r->aipNotify);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "fUseWins", r->fUseWins);
	ndr_print_uint32(ndr, "fUseNbstat", r->fUseNbstat);
	ndr_print_uint32(ndr, "fAging", r->fAging);
	ndr_print_uint32(ndr, "dwNoRefreshInterval", r->dwNoRefreshInterval);
	ndr_print_uint32(ndr, "dwRefreshInterval", r->dwRefreshInterval);
	ndr_print_uint32(ndr, "dwAvailForScavengeTime", r->dwAvailForScavengeTime);
	ndr_print_ptr(ndr, "aipScavengeServers", r->aipScavengeServers);
	ndr->depth++;
	if (r->aipScavengeServers) {
		ndr_print_IP4_ARRAY(ndr, "aipScavengeServers", r->aipScavengeServers);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwForwarderTimeout", r->dwForwarderTimeout);
	ndr_print_uint32(ndr, "fForwarderSlave", r->fForwarderSlave);
	ndr_print_ptr(ndr, "aipLocalMasters", r->aipLocalMasters);
	ndr->depth++;
	if (r->aipLocalMasters) {
		ndr_print_IP4_ARRAY(ndr, "aipLocalMasters", r->aipLocalMasters);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwDpFlags", r->dwDpFlags);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pwszZoneDn", r->pwszZoneDn);
	ndr->depth++;
	if (r->pwszZoneDn) {
		ndr_print_string(ndr, "pwszZoneDn", r->pwszZoneDn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwLastSuccessfulSoaCheck", r->dwLastSuccessfulSoaCheck);
	ndr_print_uint32(ndr, "dwLastSuccessfulXfr", r->dwLastSuccessfulXfr);
	ndr_print_uint32(ndr, "dwReserved1", r->dwReserved1);
	ndr_print_uint32(ndr, "dwReserved2", r->dwReserved2);
	ndr_print_uint32(ndr, "dwReserved3", r->dwReserved3);
	ndr_print_uint32(ndr, "dwReserved4", r->dwReserved4);
	ndr_print_uint32(ndr, "dwReserved5", r->dwReserved5);
	ndr_print_ptr(ndr, "pReserved1", r->pReserved1);
	ndr->depth++;
	if (r->pReserved1) {
		ndr_print_string(ndr, "pReserved1", r->pReserved1);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pReserved2", r->pReserved2);
	ndr->depth++;
	if (r->pReserved2) {
		ndr_print_string(ndr, "pReserved2", r->pReserved2);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pReserved3", r->pReserved3);
	ndr->depth++;
	if (r->pReserved3) {
		ndr_print_string(ndr, "pReserved3", r->pReserved3);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pReserved4", r->pReserved4);
	ndr->depth++;
	if (r->pReserved4) {
		ndr_print_string(ndr, "pReserved4", r->pReserved4);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_INFO_LONGHORN(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_INFO_LONGHORN *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fReverse));
		NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fPaused));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fShutdown));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAutoCreated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseDatabase));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDataFile));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipMasters));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipNotify));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseWins));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fUseNbstat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAging));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNoRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRefreshInterval));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwAvailForScavengeTime));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipScavengeServers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwarderTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fForwarderSlave));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipLocalMasters));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDpFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pwszZoneDn));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastSuccessfulSoaCheck));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastSuccessfulXfr));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fQueuedForBackgroundLoad));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fBackgroundLoadInProgress));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fReadOnlyZone));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastXfrAttempt));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwLastXfrResult));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDataFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDataFile, ndr_charset_length(r->pszDataFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipMasters) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
		}
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->aipNotify) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
		}
		if (r->aipScavengeServers) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipScavengeServers));
		}
		if (r->aipLocalMasters) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipLocalMasters));
		}
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pwszZoneDn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszZoneDn, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pwszZoneDn, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pwszZoneDn, ndr_charset_length(r->pwszZoneDn, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_INFO_LONGHORN(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_INFO_LONGHORN *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDataFile;
	uint32_t size_pszDataFile_1 = 0;
	uint32_t length_pszDataFile_1 = 0;
	TALLOC_CTX *_mem_save_pszDataFile_0 = NULL;
	uint32_t _ptr_aipMasters;
	TALLOC_CTX *_mem_save_aipMasters_0 = NULL;
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_aipNotify;
	TALLOC_CTX *_mem_save_aipNotify_0 = NULL;
	uint32_t _ptr_aipScavengeServers;
	TALLOC_CTX *_mem_save_aipScavengeServers_0 = NULL;
	uint32_t _ptr_aipLocalMasters;
	TALLOC_CTX *_mem_save_aipLocalMasters_0 = NULL;
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	uint32_t _ptr_pwszZoneDn;
	uint32_t size_pwszZoneDn_1 = 0;
	uint32_t length_pwszZoneDn_1 = 0;
	TALLOC_CTX *_mem_save_pwszZoneDn_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fReverse));
		NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fPaused));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fShutdown));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAutoCreated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseDatabase));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDataFile));
		if (_ptr_pszDataFile) {
			NDR_PULL_ALLOC(ndr, r->pszDataFile);
		} else {
			r->pszDataFile = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipMasters));
		if (_ptr_aipMasters) {
			NDR_PULL_ALLOC(ndr, r->aipMasters);
		} else {
			r->aipMasters = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipNotify));
		if (_ptr_aipNotify) {
			NDR_PULL_ALLOC(ndr, r->aipNotify);
		} else {
			r->aipNotify = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseWins));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fUseNbstat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAging));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNoRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRefreshInterval));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwAvailForScavengeTime));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipScavengeServers));
		if (_ptr_aipScavengeServers) {
			NDR_PULL_ALLOC(ndr, r->aipScavengeServers);
		} else {
			r->aipScavengeServers = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwarderTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fForwarderSlave));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipLocalMasters));
		if (_ptr_aipLocalMasters) {
			NDR_PULL_ALLOC(ndr, r->aipLocalMasters);
		} else {
			r->aipLocalMasters = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDpFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszZoneDn));
		if (_ptr_pwszZoneDn) {
			NDR_PULL_ALLOC(ndr, r->pwszZoneDn);
		} else {
			r->pwszZoneDn = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastSuccessfulSoaCheck));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastSuccessfulXfr));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fQueuedForBackgroundLoad));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fBackgroundLoadInProgress));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fReadOnlyZone));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastXfrAttempt));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwLastXfrResult));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDataFile) {
			_mem_save_pszDataFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDataFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDataFile, &size_pszDataFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDataFile, &length_pszDataFile_1));
			if (length_pszDataFile_1 > size_pszDataFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataFile_1, length_pszDataFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDataFile, length_pszDataFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDataFile_0, 0);
		}
		if (r->aipMasters) {
			_mem_save_aipMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipMasters, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipMasters_0, 0);
		}
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->aipNotify) {
			_mem_save_aipNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipNotify, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipNotify_0, 0);
		}
		if (r->aipScavengeServers) {
			_mem_save_aipScavengeServers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipScavengeServers, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipScavengeServers));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipScavengeServers_0, 0);
		}
		if (r->aipLocalMasters) {
			_mem_save_aipLocalMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipLocalMasters, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipLocalMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipLocalMasters_0, 0);
		}
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
		if (r->pwszZoneDn) {
			_mem_save_pwszZoneDn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pwszZoneDn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pwszZoneDn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pwszZoneDn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pwszZoneDn, &size_pwszZoneDn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pwszZoneDn, &length_pwszZoneDn_1));
			if (length_pwszZoneDn_1 > size_pwszZoneDn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszZoneDn_1, length_pwszZoneDn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszZoneDn_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pwszZoneDn, length_pwszZoneDn_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszZoneDn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_INFO_LONGHORN(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_INFO_LONGHORN *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_INFO_LONGHORN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwZoneType", r->dwZoneType);
	ndr_print_uint32(ndr, "fReverse", r->fReverse);
	ndr_print_dns_zone_update(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint32(ndr, "fPaused", r->fPaused);
	ndr_print_uint32(ndr, "fShutdown", r->fShutdown);
	ndr_print_uint32(ndr, "fAutoCreated", r->fAutoCreated);
	ndr_print_uint32(ndr, "fUseDatabase", r->fUseDatabase);
	ndr_print_ptr(ndr, "pszDataFile", r->pszDataFile);
	ndr->depth++;
	if (r->pszDataFile) {
		ndr_print_string(ndr, "pszDataFile", r->pszDataFile);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipMasters", r->aipMasters);
	ndr->depth++;
	if (r->aipMasters) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipMasters", r->aipMasters);
	}
	ndr->depth--;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipNotify", r->aipNotify);
	ndr->depth++;
	if (r->aipNotify) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipNotify", r->aipNotify);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "fUseWins", r->fUseWins);
	ndr_print_uint32(ndr, "fUseNbstat", r->fUseNbstat);
	ndr_print_uint32(ndr, "fAging", r->fAging);
	ndr_print_uint32(ndr, "dwNoRefreshInterval", r->dwNoRefreshInterval);
	ndr_print_uint32(ndr, "dwRefreshInterval", r->dwRefreshInterval);
	ndr_print_uint32(ndr, "dwAvailForScavengeTime", r->dwAvailForScavengeTime);
	ndr_print_ptr(ndr, "aipScavengeServers", r->aipScavengeServers);
	ndr->depth++;
	if (r->aipScavengeServers) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipScavengeServers", r->aipScavengeServers);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwForwarderTimeout", r->dwForwarderTimeout);
	ndr_print_uint32(ndr, "fForwarderSlave", r->fForwarderSlave);
	ndr_print_ptr(ndr, "aipLocalMasters", r->aipLocalMasters);
	ndr->depth++;
	if (r->aipLocalMasters) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipLocalMasters", r->aipLocalMasters);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwDpFlags", r->dwDpFlags);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pwszZoneDn", r->pwszZoneDn);
	ndr->depth++;
	if (r->pwszZoneDn) {
		ndr_print_string(ndr, "pwszZoneDn", r->pwszZoneDn);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwLastSuccessfulSoaCheck", r->dwLastSuccessfulSoaCheck);
	ndr_print_uint32(ndr, "dwLastSuccessfulXfr", r->dwLastSuccessfulXfr);
	ndr_print_uint32(ndr, "fQueuedForBackgroundLoad", r->fQueuedForBackgroundLoad);
	ndr_print_uint32(ndr, "fBackgroundLoadInProgress", r->fBackgroundLoadInProgress);
	ndr_print_uint32(ndr, "fReadOnlyZone", r->fReadOnlyZone);
	ndr_print_uint32(ndr, "dwLastXfrAttempt", r->dwLastXfrAttempt);
	ndr_print_uint32(ndr, "dwLastXfrResult", r->dwLastXfrResult);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_SECONDARIES_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_SECONDARIES_W2K *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipNotify));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->aipNotify) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_SECONDARIES_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_SECONDARIES_W2K *r)
{
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_aipNotify;
	TALLOC_CTX *_mem_save_aipNotify_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipNotify));
		if (_ptr_aipNotify) {
			NDR_PULL_ALLOC(ndr, r->aipNotify);
		} else {
			r->aipNotify = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->aipNotify) {
			_mem_save_aipNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipNotify, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipNotify_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_SECONDARIES_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_SECONDARIES_W2K *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_SECONDARIES_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_IP4_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipNotify", r->aipNotify);
	ndr->depth++;
	if (r->aipNotify) {
		ndr_print_IP4_ARRAY(ndr, "aipNotify", r->aipNotify);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_SECONDARIES_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_SECONDARIES_DOTNET *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipNotify));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->aipNotify) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_SECONDARIES_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_SECONDARIES_DOTNET *r)
{
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_aipNotify;
	TALLOC_CTX *_mem_save_aipNotify_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipNotify));
		if (_ptr_aipNotify) {
			NDR_PULL_ALLOC(ndr, r->aipNotify);
		} else {
			r->aipNotify = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->aipNotify) {
			_mem_save_aipNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipNotify, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipNotify_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_SECONDARIES_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_SECONDARIES_DOTNET *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_SECONDARIES_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_IP4_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipNotify", r->aipNotify);
	ndr->depth++;
	if (r->aipNotify) {
		ndr_print_IP4_ARRAY(ndr, "aipNotify", r->aipNotify);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_SECONDARIES_LONGHORN(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipNotify));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->aipNotify) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_SECONDARIES_LONGHORN(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *r)
{
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_aipNotify;
	TALLOC_CTX *_mem_save_aipNotify_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipNotify));
		if (_ptr_aipNotify) {
			NDR_PULL_ALLOC(ndr, r->aipNotify);
		} else {
			r->aipNotify = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->aipNotify) {
			_mem_save_aipNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipNotify, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipNotify));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipNotify_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_SECONDARIES_LONGHORN(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_SECONDARIES_LONGHORN *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_SECONDARIES_LONGHORN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipNotify", r->aipNotify);
	ndr->depth++;
	if (r->aipNotify) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipNotify", r->aipNotify);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_DATABASE_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_DATABASE_W2K *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDsIntegrated));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszFileName));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszFileName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszFileName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszFileName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszFileName, ndr_charset_length(r->pszFileName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_DATABASE_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_DATABASE_W2K *r)
{
	uint32_t _ptr_pszFileName;
	uint32_t size_pszFileName_1 = 0;
	uint32_t length_pszFileName_1 = 0;
	TALLOC_CTX *_mem_save_pszFileName_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDsIntegrated));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszFileName));
		if (_ptr_pszFileName) {
			NDR_PULL_ALLOC(ndr, r->pszFileName);
		} else {
			r->pszFileName = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszFileName) {
			_mem_save_pszFileName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszFileName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszFileName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszFileName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszFileName, &size_pszFileName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszFileName, &length_pszFileName_1));
			if (length_pszFileName_1 > size_pszFileName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszFileName_1, length_pszFileName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszFileName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszFileName, length_pszFileName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszFileName_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_DATABASE_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_DATABASE_W2K *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_DATABASE_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "fDsIntegrated", r->fDsIntegrated);
	ndr_print_ptr(ndr, "pszFileName", r->pszFileName);
	ndr->depth++;
	if (r->pszFileName) {
		ndr_print_string(ndr, "pszFileName", r->pszFileName);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_DATABASE_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_DATABASE_DOTNET *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDsIntegrated));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszFileName));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszFileName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszFileName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszFileName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszFileName, ndr_charset_length(r->pszFileName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_DATABASE_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_DATABASE_DOTNET *r)
{
	uint32_t _ptr_pszFileName;
	uint32_t size_pszFileName_1 = 0;
	uint32_t length_pszFileName_1 = 0;
	TALLOC_CTX *_mem_save_pszFileName_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDsIntegrated));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszFileName));
		if (_ptr_pszFileName) {
			NDR_PULL_ALLOC(ndr, r->pszFileName);
		} else {
			r->pszFileName = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszFileName) {
			_mem_save_pszFileName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszFileName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszFileName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszFileName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszFileName, &size_pszFileName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszFileName, &length_pszFileName_1));
			if (length_pszFileName_1 > size_pszFileName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszFileName_1, length_pszFileName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszFileName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszFileName, length_pszFileName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszFileName_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_DATABASE_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_DATABASE_DOTNET *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_DATABASE_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "fDsIntegrated", r->fDsIntegrated);
	ndr_print_ptr(ndr, "pszFileName", r->pszFileName);
	ndr->depth++;
	if (r->pszFileName) {
		ndr_print_string(ndr, "pszFileName", r->pszFileName);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_CREATE_INFO_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_CREATE_INFO_W2K *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneType));
		NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAging));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDataFile));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDsIntegrated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fLoadExisting));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszAdmin));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipMasters));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved2));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved3));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved4));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved6));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved7));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pvReserved8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved2));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved3));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved6));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved7));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved8));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDataFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDataFile, ndr_charset_length(r->pszDataFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszAdmin) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszAdmin, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszAdmin, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszAdmin, ndr_charset_length(r->pszAdmin, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipMasters) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
		}
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->pvReserved1) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved1, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved1, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved1, ndr_charset_length(r->pvReserved1, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved2) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved2, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved2, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved2, ndr_charset_length(r->pvReserved2, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved3) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved3, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved3, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved3, ndr_charset_length(r->pvReserved3, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved4) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved4, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved4, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved4, ndr_charset_length(r->pvReserved4, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved5) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved5, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved5, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved5, ndr_charset_length(r->pvReserved5, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved6) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved6, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved6, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved6, ndr_charset_length(r->pvReserved6, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved7) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved7, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved7, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved7, ndr_charset_length(r->pvReserved7, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pvReserved8) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved8, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pvReserved8, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pvReserved8, ndr_charset_length(r->pvReserved8, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_CREATE_INFO_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_CREATE_INFO_W2K *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDataFile;
	uint32_t size_pszDataFile_1 = 0;
	uint32_t length_pszDataFile_1 = 0;
	TALLOC_CTX *_mem_save_pszDataFile_0 = NULL;
	uint32_t _ptr_pszAdmin;
	uint32_t size_pszAdmin_1 = 0;
	uint32_t length_pszAdmin_1 = 0;
	TALLOC_CTX *_mem_save_pszAdmin_0 = NULL;
	uint32_t _ptr_aipMasters;
	TALLOC_CTX *_mem_save_aipMasters_0 = NULL;
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_pvReserved1;
	uint32_t size_pvReserved1_1 = 0;
	uint32_t length_pvReserved1_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved1_0 = NULL;
	uint32_t _ptr_pvReserved2;
	uint32_t size_pvReserved2_1 = 0;
	uint32_t length_pvReserved2_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved2_0 = NULL;
	uint32_t _ptr_pvReserved3;
	uint32_t size_pvReserved3_1 = 0;
	uint32_t length_pvReserved3_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved3_0 = NULL;
	uint32_t _ptr_pvReserved4;
	uint32_t size_pvReserved4_1 = 0;
	uint32_t length_pvReserved4_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved4_0 = NULL;
	uint32_t _ptr_pvReserved5;
	uint32_t size_pvReserved5_1 = 0;
	uint32_t length_pvReserved5_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved5_0 = NULL;
	uint32_t _ptr_pvReserved6;
	uint32_t size_pvReserved6_1 = 0;
	uint32_t length_pvReserved6_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved6_0 = NULL;
	uint32_t _ptr_pvReserved7;
	uint32_t size_pvReserved7_1 = 0;
	uint32_t length_pvReserved7_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved7_0 = NULL;
	uint32_t _ptr_pvReserved8;
	uint32_t size_pvReserved8_1 = 0;
	uint32_t length_pvReserved8_1 = 0;
	TALLOC_CTX *_mem_save_pvReserved8_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneType));
		NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAging));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDataFile));
		if (_ptr_pszDataFile) {
			NDR_PULL_ALLOC(ndr, r->pszDataFile);
		} else {
			r->pszDataFile = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDsIntegrated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fLoadExisting));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszAdmin));
		if (_ptr_pszAdmin) {
			NDR_PULL_ALLOC(ndr, r->pszAdmin);
		} else {
			r->pszAdmin = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipMasters));
		if (_ptr_aipMasters) {
			NDR_PULL_ALLOC(ndr, r->aipMasters);
		} else {
			r->aipMasters = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved1));
		if (_ptr_pvReserved1) {
			NDR_PULL_ALLOC(ndr, r->pvReserved1);
		} else {
			r->pvReserved1 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved2));
		if (_ptr_pvReserved2) {
			NDR_PULL_ALLOC(ndr, r->pvReserved2);
		} else {
			r->pvReserved2 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved3));
		if (_ptr_pvReserved3) {
			NDR_PULL_ALLOC(ndr, r->pvReserved3);
		} else {
			r->pvReserved3 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved4));
		if (_ptr_pvReserved4) {
			NDR_PULL_ALLOC(ndr, r->pvReserved4);
		} else {
			r->pvReserved4 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved5));
		if (_ptr_pvReserved5) {
			NDR_PULL_ALLOC(ndr, r->pvReserved5);
		} else {
			r->pvReserved5 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved6));
		if (_ptr_pvReserved6) {
			NDR_PULL_ALLOC(ndr, r->pvReserved6);
		} else {
			r->pvReserved6 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved7));
		if (_ptr_pvReserved7) {
			NDR_PULL_ALLOC(ndr, r->pvReserved7);
		} else {
			r->pvReserved7 = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pvReserved8));
		if (_ptr_pvReserved8) {
			NDR_PULL_ALLOC(ndr, r->pvReserved8);
		} else {
			r->pvReserved8 = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved2));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved3));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved6));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved7));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved8));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDataFile) {
			_mem_save_pszDataFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDataFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDataFile, &size_pszDataFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDataFile, &length_pszDataFile_1));
			if (length_pszDataFile_1 > size_pszDataFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataFile_1, length_pszDataFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDataFile, length_pszDataFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDataFile_0, 0);
		}
		if (r->pszAdmin) {
			_mem_save_pszAdmin_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszAdmin, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszAdmin));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszAdmin));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszAdmin, &size_pszAdmin_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszAdmin, &length_pszAdmin_1));
			if (length_pszAdmin_1 > size_pszAdmin_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszAdmin_1, length_pszAdmin_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszAdmin_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszAdmin, length_pszAdmin_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszAdmin_0, 0);
		}
		if (r->aipMasters) {
			_mem_save_aipMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipMasters, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipMasters_0, 0);
		}
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->pvReserved1) {
			_mem_save_pvReserved1_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved1, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved1));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved1));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved1, &size_pvReserved1_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved1, &length_pvReserved1_1));
			if (length_pvReserved1_1 > size_pvReserved1_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved1_1, length_pvReserved1_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved1_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved1, length_pvReserved1_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved1_0, 0);
		}
		if (r->pvReserved2) {
			_mem_save_pvReserved2_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved2, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved2));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved2));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved2, &size_pvReserved2_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved2, &length_pvReserved2_1));
			if (length_pvReserved2_1 > size_pvReserved2_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved2_1, length_pvReserved2_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved2_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved2, length_pvReserved2_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved2_0, 0);
		}
		if (r->pvReserved3) {
			_mem_save_pvReserved3_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved3, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved3));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved3));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved3, &size_pvReserved3_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved3, &length_pvReserved3_1));
			if (length_pvReserved3_1 > size_pvReserved3_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved3_1, length_pvReserved3_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved3_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved3, length_pvReserved3_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved3_0, 0);
		}
		if (r->pvReserved4) {
			_mem_save_pvReserved4_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved4, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved4));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved4));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved4, &size_pvReserved4_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved4, &length_pvReserved4_1));
			if (length_pvReserved4_1 > size_pvReserved4_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved4_1, length_pvReserved4_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved4_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved4, length_pvReserved4_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved4_0, 0);
		}
		if (r->pvReserved5) {
			_mem_save_pvReserved5_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved5, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved5));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved5));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved5, &size_pvReserved5_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved5, &length_pvReserved5_1));
			if (length_pvReserved5_1 > size_pvReserved5_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved5_1, length_pvReserved5_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved5_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved5, length_pvReserved5_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved5_0, 0);
		}
		if (r->pvReserved6) {
			_mem_save_pvReserved6_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved6, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved6));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved6));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved6, &size_pvReserved6_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved6, &length_pvReserved6_1));
			if (length_pvReserved6_1 > size_pvReserved6_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved6_1, length_pvReserved6_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved6_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved6, length_pvReserved6_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved6_0, 0);
		}
		if (r->pvReserved7) {
			_mem_save_pvReserved7_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved7, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved7));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved7));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved7, &size_pvReserved7_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved7, &length_pvReserved7_1));
			if (length_pvReserved7_1 > size_pvReserved7_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved7_1, length_pvReserved7_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved7_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved7, length_pvReserved7_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved7_0, 0);
		}
		if (r->pvReserved8) {
			_mem_save_pvReserved8_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pvReserved8, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pvReserved8));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pvReserved8));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pvReserved8, &size_pvReserved8_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pvReserved8, &length_pvReserved8_1));
			if (length_pvReserved8_1 > size_pvReserved8_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pvReserved8_1, length_pvReserved8_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pvReserved8_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pvReserved8, length_pvReserved8_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pvReserved8_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_CREATE_INFO_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_CREATE_INFO_W2K *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_CREATE_INFO_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwZoneType", r->dwZoneType);
	ndr_print_dns_zone_update(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint32(ndr, "fAging", r->fAging);
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_ptr(ndr, "pszDataFile", r->pszDataFile);
	ndr->depth++;
	if (r->pszDataFile) {
		ndr_print_string(ndr, "pszDataFile", r->pszDataFile);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "fDsIntegrated", r->fDsIntegrated);
	ndr_print_uint32(ndr, "fLoadExisting", r->fLoadExisting);
	ndr_print_ptr(ndr, "pszAdmin", r->pszAdmin);
	ndr->depth++;
	if (r->pszAdmin) {
		ndr_print_string(ndr, "pszAdmin", r->pszAdmin);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipMasters", r->aipMasters);
	ndr->depth++;
	if (r->aipMasters) {
		ndr_print_IP4_ARRAY(ndr, "aipMasters", r->aipMasters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_IP4_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_ptr(ndr, "pvReserved1", r->pvReserved1);
	ndr->depth++;
	if (r->pvReserved1) {
		ndr_print_string(ndr, "pvReserved1", r->pvReserved1);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved2", r->pvReserved2);
	ndr->depth++;
	if (r->pvReserved2) {
		ndr_print_string(ndr, "pvReserved2", r->pvReserved2);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved3", r->pvReserved3);
	ndr->depth++;
	if (r->pvReserved3) {
		ndr_print_string(ndr, "pvReserved3", r->pvReserved3);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved4", r->pvReserved4);
	ndr->depth++;
	if (r->pvReserved4) {
		ndr_print_string(ndr, "pvReserved4", r->pvReserved4);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved5", r->pvReserved5);
	ndr->depth++;
	if (r->pvReserved5) {
		ndr_print_string(ndr, "pvReserved5", r->pvReserved5);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved6", r->pvReserved6);
	ndr->depth++;
	if (r->pvReserved6) {
		ndr_print_string(ndr, "pvReserved6", r->pvReserved6);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved7", r->pvReserved7);
	ndr->depth++;
	if (r->pvReserved7) {
		ndr_print_string(ndr, "pvReserved7", r->pvReserved7);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pvReserved8", r->pvReserved8);
	ndr->depth++;
	if (r->pvReserved8) {
		ndr_print_string(ndr, "pvReserved8", r->pvReserved8);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwReserved1", r->dwReserved1);
	ndr_print_uint32(ndr, "dwReserved2", r->dwReserved2);
	ndr_print_uint32(ndr, "dwReserved3", r->dwReserved3);
	ndr_print_uint32(ndr, "dwReserved4", r->dwReserved4);
	ndr_print_uint32(ndr, "dwReserved5", r->dwReserved5);
	ndr_print_uint32(ndr, "dwReserved6", r->dwReserved6);
	ndr_print_uint32(ndr, "dwReserved7", r->dwReserved7);
	ndr_print_uint32(ndr, "dwReserved8", r->dwReserved8);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_CREATE_INFO_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *r)
{
	uint32_t cntr_dwReserved_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneType));
		NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAging));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDataFile));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDsIntegrated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fLoadExisting));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszAdmin));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipMasters));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDpFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (32); cntr_dwReserved_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved[cntr_dwReserved_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDataFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDataFile, ndr_charset_length(r->pszDataFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszAdmin) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszAdmin, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszAdmin, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszAdmin, ndr_charset_length(r->pszAdmin, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipMasters) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
		}
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_CREATE_INFO_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDataFile;
	uint32_t size_pszDataFile_1 = 0;
	uint32_t length_pszDataFile_1 = 0;
	TALLOC_CTX *_mem_save_pszDataFile_0 = NULL;
	uint32_t _ptr_pszAdmin;
	uint32_t size_pszAdmin_1 = 0;
	uint32_t length_pszAdmin_1 = 0;
	TALLOC_CTX *_mem_save_pszAdmin_0 = NULL;
	uint32_t _ptr_aipMasters;
	TALLOC_CTX *_mem_save_aipMasters_0 = NULL;
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	uint32_t size_dwReserved_0 = 0;
	uint32_t cntr_dwReserved_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneType));
		NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAging));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDataFile));
		if (_ptr_pszDataFile) {
			NDR_PULL_ALLOC(ndr, r->pszDataFile);
		} else {
			r->pszDataFile = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDsIntegrated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fLoadExisting));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszAdmin));
		if (_ptr_pszAdmin) {
			NDR_PULL_ALLOC(ndr, r->pszAdmin);
		} else {
			r->pszAdmin = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipMasters));
		if (_ptr_aipMasters) {
			NDR_PULL_ALLOC(ndr, r->aipMasters);
		} else {
			r->aipMasters = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDpFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		size_dwReserved_0 = 32;
		for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (size_dwReserved_0); cntr_dwReserved_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved[cntr_dwReserved_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDataFile) {
			_mem_save_pszDataFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDataFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDataFile, &size_pszDataFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDataFile, &length_pszDataFile_1));
			if (length_pszDataFile_1 > size_pszDataFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataFile_1, length_pszDataFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDataFile, length_pszDataFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDataFile_0, 0);
		}
		if (r->pszAdmin) {
			_mem_save_pszAdmin_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszAdmin, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszAdmin));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszAdmin));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszAdmin, &size_pszAdmin_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszAdmin, &length_pszAdmin_1));
			if (length_pszAdmin_1 > size_pszAdmin_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszAdmin_1, length_pszAdmin_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszAdmin_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszAdmin, length_pszAdmin_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszAdmin_0, 0);
		}
		if (r->aipMasters) {
			_mem_save_aipMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipMasters, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipMasters_0, 0);
		}
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_CREATE_INFO_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_CREATE_INFO_DOTNET *r)
{
	uint32_t cntr_dwReserved_0;
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_CREATE_INFO_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwZoneType", r->dwZoneType);
	ndr_print_dns_zone_update(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint32(ndr, "fAging", r->fAging);
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_ptr(ndr, "pszDataFile", r->pszDataFile);
	ndr->depth++;
	if (r->pszDataFile) {
		ndr_print_string(ndr, "pszDataFile", r->pszDataFile);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "fDsIntegrated", r->fDsIntegrated);
	ndr_print_uint32(ndr, "fLoadExisting", r->fLoadExisting);
	ndr_print_ptr(ndr, "pszAdmin", r->pszAdmin);
	ndr->depth++;
	if (r->pszAdmin) {
		ndr_print_string(ndr, "pszAdmin", r->pszAdmin);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipMasters", r->aipMasters);
	ndr->depth++;
	if (r->aipMasters) {
		ndr_print_IP4_ARRAY(ndr, "aipMasters", r->aipMasters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_IP4_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_uint32(ndr, "dwTimeout", r->dwTimeout);
	ndr_print_uint32(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint32(ndr, "dwDpFlags", r->dwDpFlags);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dwReserved", (uint32_t)(32));
	ndr->depth++;
	for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (32); cntr_dwReserved_0++) {
		ndr_print_uint32(ndr, "dwReserved", r->dwReserved[cntr_dwReserved_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_CREATE_INFO_LONGHORN(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *r)
{
	uint32_t cntr_dwReserved_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwZoneType));
		NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->fAllowUpdate));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fAging));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDataFile));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDsIntegrated));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fLoadExisting));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszAdmin));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipMasters));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, r->fSecureSecondaries));
		NDR_CHECK(ndr_push_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, r->fNotifyLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDpFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszDpFqdn));
		for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (32); cntr_dwReserved_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved[cntr_dwReserved_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneName, ndr_charset_length(r->pszZoneName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszDataFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDataFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDataFile, ndr_charset_length(r->pszDataFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszAdmin) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszAdmin, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszAdmin, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszAdmin, ndr_charset_length(r->pszAdmin, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->aipMasters) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
		}
		if (r->aipSecondaries) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
		}
		if (r->pszDpFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszDpFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszDpFqdn, ndr_charset_length(r->pszDpFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_CREATE_INFO_LONGHORN(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *r)
{
	uint32_t _ptr_pszZoneName;
	uint32_t size_pszZoneName_1 = 0;
	uint32_t length_pszZoneName_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneName_0 = NULL;
	uint32_t _ptr_pszDataFile;
	uint32_t size_pszDataFile_1 = 0;
	uint32_t length_pszDataFile_1 = 0;
	TALLOC_CTX *_mem_save_pszDataFile_0 = NULL;
	uint32_t _ptr_pszAdmin;
	uint32_t size_pszAdmin_1 = 0;
	uint32_t length_pszAdmin_1 = 0;
	TALLOC_CTX *_mem_save_pszAdmin_0 = NULL;
	uint32_t _ptr_aipMasters;
	TALLOC_CTX *_mem_save_aipMasters_0 = NULL;
	uint32_t _ptr_aipSecondaries;
	TALLOC_CTX *_mem_save_aipSecondaries_0 = NULL;
	uint32_t _ptr_pszDpFqdn;
	uint32_t size_pszDpFqdn_1 = 0;
	uint32_t length_pszDpFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszDpFqdn_0 = NULL;
	uint32_t size_dwReserved_0 = 0;
	uint32_t cntr_dwReserved_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneName));
		if (_ptr_pszZoneName) {
			NDR_PULL_ALLOC(ndr, r->pszZoneName);
		} else {
			r->pszZoneName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwZoneType));
		NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->fAllowUpdate));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fAging));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDataFile));
		if (_ptr_pszDataFile) {
			NDR_PULL_ALLOC(ndr, r->pszDataFile);
		} else {
			r->pszDataFile = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDsIntegrated));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fLoadExisting));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszAdmin));
		if (_ptr_pszAdmin) {
			NDR_PULL_ALLOC(ndr, r->pszAdmin);
		} else {
			r->pszAdmin = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipMasters));
		if (_ptr_aipMasters) {
			NDR_PULL_ALLOC(ndr, r->aipMasters);
		} else {
			r->aipMasters = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipSecondaries));
		if (_ptr_aipSecondaries) {
			NDR_PULL_ALLOC(ndr, r->aipSecondaries);
		} else {
			r->aipSecondaries = NULL;
		}
		NDR_CHECK(ndr_pull_DNS_ZONE_SECONDARY_SECURITY(ndr, NDR_SCALARS, &r->fSecureSecondaries));
		NDR_CHECK(ndr_pull_DNS_ZONE_NOTIFY_LEVEL(ndr, NDR_SCALARS, &r->fNotifyLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDpFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszDpFqdn));
		if (_ptr_pszDpFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszDpFqdn);
		} else {
			r->pszDpFqdn = NULL;
		}
		size_dwReserved_0 = 32;
		for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (size_dwReserved_0); cntr_dwReserved_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved[cntr_dwReserved_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneName) {
			_mem_save_pszZoneName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneName, &size_pszZoneName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneName, &length_pszZoneName_1));
			if (length_pszZoneName_1 > size_pszZoneName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneName_1, length_pszZoneName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneName, length_pszZoneName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneName_0, 0);
		}
		if (r->pszDataFile) {
			_mem_save_pszDataFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDataFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDataFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDataFile, &size_pszDataFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDataFile, &length_pszDataFile_1));
			if (length_pszDataFile_1 > size_pszDataFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDataFile_1, length_pszDataFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDataFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDataFile, length_pszDataFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDataFile_0, 0);
		}
		if (r->pszAdmin) {
			_mem_save_pszAdmin_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszAdmin, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszAdmin));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszAdmin));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszAdmin, &size_pszAdmin_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszAdmin, &length_pszAdmin_1));
			if (length_pszAdmin_1 > size_pszAdmin_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszAdmin_1, length_pszAdmin_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszAdmin_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszAdmin, length_pszAdmin_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszAdmin_0, 0);
		}
		if (r->aipMasters) {
			_mem_save_aipMasters_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipMasters, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipMasters));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipMasters_0, 0);
		}
		if (r->aipSecondaries) {
			_mem_save_aipSecondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipSecondaries, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipSecondaries));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipSecondaries_0, 0);
		}
		if (r->pszDpFqdn) {
			_mem_save_pszDpFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszDpFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszDpFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszDpFqdn, &size_pszDpFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszDpFqdn, &length_pszDpFqdn_1));
			if (length_pszDpFqdn_1 > size_pszDpFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszDpFqdn_1, length_pszDpFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszDpFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszDpFqdn, length_pszDpFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszDpFqdn_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_CREATE_INFO_LONGHORN(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_CREATE_INFO_LONGHORN *r)
{
	uint32_t cntr_dwReserved_0;
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_CREATE_INFO_LONGHORN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszZoneName", r->pszZoneName);
	ndr->depth++;
	if (r->pszZoneName) {
		ndr_print_string(ndr, "pszZoneName", r->pszZoneName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwZoneType", r->dwZoneType);
	ndr_print_dns_zone_update(ndr, "fAllowUpdate", r->fAllowUpdate);
	ndr_print_uint32(ndr, "fAging", r->fAging);
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_ptr(ndr, "pszDataFile", r->pszDataFile);
	ndr->depth++;
	if (r->pszDataFile) {
		ndr_print_string(ndr, "pszDataFile", r->pszDataFile);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "fDsIntegrated", r->fDsIntegrated);
	ndr_print_uint32(ndr, "fLoadExisting", r->fLoadExisting);
	ndr_print_ptr(ndr, "pszAdmin", r->pszAdmin);
	ndr->depth++;
	if (r->pszAdmin) {
		ndr_print_string(ndr, "pszAdmin", r->pszAdmin);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipMasters", r->aipMasters);
	ndr->depth++;
	if (r->aipMasters) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipMasters", r->aipMasters);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "aipSecondaries", r->aipSecondaries);
	ndr->depth++;
	if (r->aipSecondaries) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipSecondaries", r->aipSecondaries);
	}
	ndr->depth--;
	ndr_print_DNS_ZONE_SECONDARY_SECURITY(ndr, "fSecureSecondaries", r->fSecureSecondaries);
	ndr_print_DNS_ZONE_NOTIFY_LEVEL(ndr, "fNotifyLevel", r->fNotifyLevel);
	ndr_print_uint32(ndr, "dwTimeout", r->dwTimeout);
	ndr_print_uint32(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint32(ndr, "dwDpFlags", r->dwDpFlags);
	ndr_print_ptr(ndr, "pszDpFqdn", r->pszDpFqdn);
	ndr->depth++;
	if (r->pszDpFqdn) {
		ndr_print_string(ndr, "pszDpFqdn", r->pszDpFqdn);
	}
	ndr->depth--;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dwReserved", (uint32_t)(32));
	ndr->depth++;
	for (cntr_dwReserved_0 = 0; cntr_dwReserved_0 < (32); cntr_dwReserved_0++) {
		ndr_print_uint32(ndr, "dwReserved", r->dwReserved[cntr_dwReserved_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ZONE_EXPORT_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ZONE_EXPORT_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszZoneExportFile));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneExportFile) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneExportFile, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszZoneExportFile, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszZoneExportFile, ndr_charset_length(r->pszZoneExportFile, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ZONE_EXPORT_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ZONE_EXPORT_INFO *r)
{
	uint32_t _ptr_pszZoneExportFile;
	uint32_t size_pszZoneExportFile_1 = 0;
	uint32_t length_pszZoneExportFile_1 = 0;
	TALLOC_CTX *_mem_save_pszZoneExportFile_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZoneExportFile));
		if (_ptr_pszZoneExportFile) {
			NDR_PULL_ALLOC(ndr, r->pszZoneExportFile);
		} else {
			r->pszZoneExportFile = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszZoneExportFile) {
			_mem_save_pszZoneExportFile_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszZoneExportFile, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszZoneExportFile));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszZoneExportFile));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszZoneExportFile, &size_pszZoneExportFile_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszZoneExportFile, &length_pszZoneExportFile_1));
			if (length_pszZoneExportFile_1 > size_pszZoneExportFile_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZoneExportFile_1, length_pszZoneExportFile_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZoneExportFile_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszZoneExportFile, length_pszZoneExportFile_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZoneExportFile_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ZONE_EXPORT_INFO(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ZONE_EXPORT_INFO *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_ZONE_EXPORT_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_ptr(ndr, "pszZoneExportFile", r->pszZoneExportFile);
	ndr->depth++;
	if (r->pszZoneExportFile) {
		ndr_print_string(ndr, "pszZoneExportFile", r->pszZoneExportFile);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_ENUM_ZONES_FILTER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_ENUM_ZONES_FILTER *r)
{
	uint32_t cntr_pszReserved_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFilter));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszPartitionFqdn));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszQueryString));
		for (cntr_pszReserved_0 = 0; cntr_pszReserved_0 < (6); cntr_pszReserved_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pszReserved[cntr_pszReserved_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszPartitionFqdn) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszPartitionFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszPartitionFqdn, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszPartitionFqdn, ndr_charset_length(r->pszPartitionFqdn, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->pszQueryString) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszQueryString, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszQueryString, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszQueryString, ndr_charset_length(r->pszQueryString, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		for (cntr_pszReserved_0 = 0; cntr_pszReserved_0 < (6); cntr_pszReserved_0++) {
			NDR_CHECK(ndr_push_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pszReserved[cntr_pszReserved_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_ENUM_ZONES_FILTER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_ENUM_ZONES_FILTER *r)
{
	uint32_t _ptr_pszPartitionFqdn;
	uint32_t size_pszPartitionFqdn_1 = 0;
	uint32_t length_pszPartitionFqdn_1 = 0;
	TALLOC_CTX *_mem_save_pszPartitionFqdn_0 = NULL;
	uint32_t _ptr_pszQueryString;
	uint32_t size_pszQueryString_1 = 0;
	uint32_t length_pszQueryString_1 = 0;
	TALLOC_CTX *_mem_save_pszQueryString_0 = NULL;
	uint32_t size_pszReserved_0 = 0;
	uint32_t cntr_pszReserved_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFilter));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszPartitionFqdn));
		if (_ptr_pszPartitionFqdn) {
			NDR_PULL_ALLOC(ndr, r->pszPartitionFqdn);
		} else {
			r->pszPartitionFqdn = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszQueryString));
		if (_ptr_pszQueryString) {
			NDR_PULL_ALLOC(ndr, r->pszQueryString);
		} else {
			r->pszQueryString = NULL;
		}
		size_pszReserved_0 = 6;
		for (cntr_pszReserved_0 = 0; cntr_pszReserved_0 < (size_pszReserved_0); cntr_pszReserved_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_SCALARS, &r->pszReserved[cntr_pszReserved_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszPartitionFqdn) {
			_mem_save_pszPartitionFqdn_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszPartitionFqdn, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszPartitionFqdn));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszPartitionFqdn));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszPartitionFqdn, &size_pszPartitionFqdn_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszPartitionFqdn, &length_pszPartitionFqdn_1));
			if (length_pszPartitionFqdn_1 > size_pszPartitionFqdn_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszPartitionFqdn_1, length_pszPartitionFqdn_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszPartitionFqdn_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszPartitionFqdn, length_pszPartitionFqdn_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszPartitionFqdn_0, 0);
		}
		if (r->pszQueryString) {
			_mem_save_pszQueryString_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszQueryString, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszQueryString));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszQueryString));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszQueryString, &size_pszQueryString_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszQueryString, &length_pszQueryString_1));
			if (length_pszQueryString_1 > size_pszQueryString_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszQueryString_1, length_pszQueryString_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszQueryString_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszQueryString, length_pszQueryString_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszQueryString_0, 0);
		}
		size_pszReserved_0 = 6;
		for (cntr_pszReserved_0 = 0; cntr_pszReserved_0 < (size_pszReserved_0); cntr_pszReserved_0++) {
			NDR_CHECK(ndr_pull_DNS_EXTENSION(ndr, NDR_BUFFERS, &r->pszReserved[cntr_pszReserved_0]));
		}
		for (cntr_pszReserved_0 = 0; cntr_pszReserved_0 < (size_pszReserved_0); cntr_pszReserved_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_ENUM_ZONES_FILTER(struct ndr_print *ndr, const char *name, const struct DNS_RPC_ENUM_ZONES_FILTER *r)
{
	uint32_t cntr_pszReserved_0;
	ndr_print_struct(ndr, name, "DNS_RPC_ENUM_ZONES_FILTER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "dwFilter", r->dwFilter);
	ndr_print_ptr(ndr, "pszPartitionFqdn", r->pszPartitionFqdn);
	ndr->depth++;
	if (r->pszPartitionFqdn) {
		ndr_print_string(ndr, "pszPartitionFqdn", r->pszPartitionFqdn);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pszQueryString", r->pszQueryString);
	ndr->depth++;
	if (r->pszQueryString) {
		ndr_print_string(ndr, "pszQueryString", r->pszQueryString);
	}
	ndr->depth--;
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pszReserved", (uint32_t)(6));
	ndr->depth++;
	for (cntr_pszReserved_0 = 0; cntr_pszReserved_0 < (6); cntr_pszReserved_0++) {
		ndr_print_DNS_EXTENSION(ndr, "pszReserved", &r->pszReserved[cntr_pszReserved_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_FORWARDERS_W2K(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_FORWARDERS_W2K *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwardTimeout));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipForwarders));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipForwarders) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_FORWARDERS_W2K(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_FORWARDERS_W2K *r)
{
	uint32_t _ptr_aipForwarders;
	TALLOC_CTX *_mem_save_aipForwarders_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwardTimeout));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipForwarders));
		if (_ptr_aipForwarders) {
			NDR_PULL_ALLOC(ndr, r->aipForwarders);
		} else {
			r->aipForwarders = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipForwarders) {
			_mem_save_aipForwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipForwarders, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipForwarders_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_FORWARDERS_W2K(struct ndr_print *ndr, const char *name, const struct DNS_RPC_FORWARDERS_W2K *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_FORWARDERS_W2K");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint32(ndr, "dwForwardTimeout", r->dwForwardTimeout);
	ndr_print_ptr(ndr, "aipForwarders", r->aipForwarders);
	ndr->depth++;
	if (r->aipForwarders) {
		ndr_print_IP4_ARRAY(ndr, "aipForwarders", r->aipForwarders);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_FORWARDERS_DOTNET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_FORWARDERS_DOTNET *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwardTimeout));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipForwarders));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipForwarders) {
			NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_FORWARDERS_DOTNET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_FORWARDERS_DOTNET *r)
{
	uint32_t _ptr_aipForwarders;
	TALLOC_CTX *_mem_save_aipForwarders_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwardTimeout));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipForwarders));
		if (_ptr_aipForwarders) {
			NDR_PULL_ALLOC(ndr, r->aipForwarders);
		} else {
			r->aipForwarders = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipForwarders) {
			_mem_save_aipForwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipForwarders, 0);
			NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipForwarders_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_FORWARDERS_DOTNET(struct ndr_print *ndr, const char *name, const struct DNS_RPC_FORWARDERS_DOTNET *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_FORWARDERS_DOTNET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint32(ndr, "dwForwardTimeout", r->dwForwardTimeout);
	ndr_print_ptr(ndr, "aipForwarders", r->aipForwarders);
	ndr->depth++;
	if (r->aipForwarders) {
		ndr_print_IP4_ARRAY(ndr, "aipForwarders", r->aipForwarders);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_FORWARDERS_LONGHORN(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_FORWARDERS_LONGHORN *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwForwardTimeout));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->aipForwarders));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipForwarders) {
			NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_FORWARDERS_LONGHORN(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_FORWARDERS_LONGHORN *r)
{
	uint32_t _ptr_aipForwarders;
	TALLOC_CTX *_mem_save_aipForwarders_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fRecurseAfterForwarding));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwForwardTimeout));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_aipForwarders));
		if (_ptr_aipForwarders) {
			NDR_PULL_ALLOC(ndr, r->aipForwarders);
		} else {
			r->aipForwarders = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->aipForwarders) {
			_mem_save_aipForwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->aipForwarders, 0);
			NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->aipForwarders));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_aipForwarders_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_FORWARDERS_LONGHORN(struct ndr_print *ndr, const char *name, const struct DNS_RPC_FORWARDERS_LONGHORN *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_FORWARDERS_LONGHORN");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_uint32(ndr, "fRecurseAfterForwarding", r->fRecurseAfterForwarding);
	ndr_print_uint32(ndr, "dwForwardTimeout", r->dwForwardTimeout);
	ndr_print_ptr(ndr, "aipForwarders", r->aipForwarders);
	ndr->depth++;
	if (r->aipForwarders) {
		ndr_print_DNS_ADDR_ARRAY(ndr, "aipForwarders", r->aipForwarders);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_AUTOCONFIG(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_RPC_AUTOCONFIG r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_AUTOCONFIG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_RPC_AUTOCONFIG *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_AUTOCONFIG(struct ndr_print *ndr, const char *name, enum DNS_RPC_AUTOCONFIG r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_RPC_AUTOCONFIG_INTERNAL_ROOTHINTS: val = "DNS_RPC_AUTOCONFIG_INTERNAL_ROOTHINTS"; break;
		case DNS_RPC_AUTOCONFIG_INTERNAL_FORWARDERS: val = "DNS_RPC_AUTOCONFIG_INTERNAL_FORWARDERS"; break;
		case DNS_RPC_AUTOCONFIG_INTERNAL_ZONES: val = "DNS_RPC_AUTOCONFIG_INTERNAL_ZONES"; break;
		case DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT: val = "DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT"; break;
		case DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_PREPEND: val = "DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_PREPEND"; break;
		case DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_APPEND: val = "DNS_RPC_AUTOCONFIG_INTERNAL_SELFPOINT_APPEND"; break;
		case DNS_RPC_AUTOCONFIG_INTERNAL_RETURN_ERROR: val = "DNS_RPC_AUTOCONFIG_INTERNAL_RETURN_ERROR"; break;
		case DNS_RPC_AUTOCONFIG_ALL: val = "DNS_RPC_AUTOCONFIG_ALL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNS_RPC_AUTOCONFIGURE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_AUTOCONFIGURE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwRpcStructureVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved0));
		NDR_CHECK(ndr_push_DNS_RPC_AUTOCONFIG(ndr, NDR_SCALARS, r->dwAutoConfigFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved1));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszNewDomainName));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszNewDomainName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszNewDomainName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszNewDomainName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszNewDomainName, ndr_charset_length(r->pszNewDomainName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_AUTOCONFIGURE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_AUTOCONFIGURE *r)
{
	uint32_t _ptr_pszNewDomainName;
	uint32_t size_pszNewDomainName_1 = 0;
	uint32_t length_pszNewDomainName_1 = 0;
	TALLOC_CTX *_mem_save_pszNewDomainName_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwRpcStructureVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved0));
		NDR_CHECK(ndr_pull_DNS_RPC_AUTOCONFIG(ndr, NDR_SCALARS, &r->dwAutoConfigFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved1));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszNewDomainName));
		if (_ptr_pszNewDomainName) {
			NDR_PULL_ALLOC(ndr, r->pszNewDomainName);
		} else {
			r->pszNewDomainName = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszNewDomainName) {
			_mem_save_pszNewDomainName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszNewDomainName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszNewDomainName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszNewDomainName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszNewDomainName, &size_pszNewDomainName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszNewDomainName, &length_pszNewDomainName_1));
			if (length_pszNewDomainName_1 > size_pszNewDomainName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNewDomainName_1, length_pszNewDomainName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNewDomainName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszNewDomainName, length_pszNewDomainName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszNewDomainName_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_AUTOCONFIGURE(struct ndr_print *ndr, const char *name, const struct DNS_RPC_AUTOCONFIGURE *r)
{
	ndr_print_struct(ndr, name, "DNS_RPC_AUTOCONFIGURE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwRpcStructureVersion", r->dwRpcStructureVersion);
	ndr_print_uint32(ndr, "dwReserved0", r->dwReserved0);
	ndr_print_DNS_RPC_AUTOCONFIG(ndr, "dwAutoConfigFlags", r->dwAutoConfigFlags);
	ndr_print_uint32(ndr, "dwReserved1", r->dwReserved1);
	ndr_print_ptr(ndr, "pszNewDomainName", r->pszNewDomainName);
	ndr->depth++;
	if (r->pszNewDomainName) {
		ndr_print_string(ndr, "pszNewDomainName", r->pszNewDomainName);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_SELECT_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_SELECT_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_SELECT_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_AUTHORITY_DATA", DNS_RPC_VIEW_AUTHORITY_DATA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_CACHE_DATA", DNS_RPC_VIEW_CACHE_DATA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_GLUE_DATA", DNS_RPC_VIEW_GLUE_DATA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_ROOT_HINT_DATA", DNS_RPC_VIEW_ROOT_HINT_DATA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_ADDITIONAL_DATA", DNS_RPC_VIEW_ADDITIONAL_DATA, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_NO_CHILDREN", DNS_RPC_VIEW_NO_CHILDREN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_VIEW_ONLY_CHILDREN", DNS_RPC_VIEW_ONLY_CHILDREN, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNSSRV_STAT_HEADER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNSSRV_STAT_HEADER *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->StatId));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wLength));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fClear));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->fReserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNSSRV_STAT_HEADER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNSSRV_STAT_HEADER *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->StatId));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wLength));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fClear));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->fReserved));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNSSRV_STAT_HEADER(struct ndr_print *ndr, const char *name, const struct DNSSRV_STAT_HEADER *r)
{
	ndr_print_struct(ndr, name, "DNSSRV_STAT_HEADER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "StatId", r->StatId);
	ndr_print_uint16(ndr, "wLength", r->wLength);
	ndr_print_uint8(ndr, "fClear", r->fClear);
	ndr_print_uint8(ndr, "fReserved", r->fReserved);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNSSRV_STAT(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNSSRV_STAT *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_DNSSRV_STAT_HEADER(ndr, NDR_SCALARS, &r->Header));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Buffer, 1));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNSSRV_STAT(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNSSRV_STAT *r)
{
	uint32_t size_Buffer_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_DNSSRV_STAT_HEADER(ndr, NDR_SCALARS, &r->Header));
		size_Buffer_0 = 1;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Buffer, size_Buffer_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNSSRV_STAT(struct ndr_print *ndr, const char *name, const struct DNSSRV_STAT *r)
{
	ndr_print_struct(ndr, name, "DNSSRV_STAT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_DNSSRV_STAT_HEADER(ndr, "Header", &r->Header);
	ndr_print_array_uint8(ndr, "Buffer", r->Buffer, 1);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DNS_RPC_TYPEID(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DNS_RPC_TYPEID r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNS_RPC_TYPEID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DNS_RPC_TYPEID *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNS_RPC_TYPEID(struct ndr_print *ndr, const char *name, enum DNS_RPC_TYPEID r)
{
	const char *val = NULL;

	switch (r) {
		case DNSSRV_TYPEID_NULL: val = "DNSSRV_TYPEID_NULL"; break;
		case DNSSRV_TYPEID_DWORD: val = "DNSSRV_TYPEID_DWORD"; break;
		case DNSSRV_TYPEID_LPSTR: val = "DNSSRV_TYPEID_LPSTR"; break;
		case DNSSRV_TYPEID_LPWSTR: val = "DNSSRV_TYPEID_LPWSTR"; break;
		case DNSSRV_TYPEID_IPARRAY: val = "DNSSRV_TYPEID_IPARRAY"; break;
		case DNSSRV_TYPEID_BUFFER: val = "DNSSRV_TYPEID_BUFFER"; break;
		case DNSSRV_TYPEID_SERVER_INFO_W2K: val = "DNSSRV_TYPEID_SERVER_INFO_W2K"; break;
		case DNSSRV_TYPEID_STATS: val = "DNSSRV_TYPEID_STATS"; break;
		case DNSSRV_TYPEID_FORWARDERS_W2K: val = "DNSSRV_TYPEID_FORWARDERS_W2K"; break;
		case DNSSRV_TYPEID_ZONE_W2K: val = "DNSSRV_TYPEID_ZONE_W2K"; break;
		case DNSSRV_TYPEID_ZONE_INFO_W2K: val = "DNSSRV_TYPEID_ZONE_INFO_W2K"; break;
		case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K: val = "DNSSRV_TYPEID_ZONE_SECONDARIES_W2K"; break;
		case DNSSRV_TYPEID_ZONE_DATABASE_W2K: val = "DNSSRV_TYPEID_ZONE_DATABASE_W2K"; break;
		case DNSSRV_TYPEID_ZONE_TYPE_RESET_W2K: val = "DNSSRV_TYPEID_ZONE_TYPE_RESET_W2K"; break;
		case DNSSRV_TYPEID_ZONE_CREATE_W2K: val = "DNSSRV_TYPEID_ZONE_CREATE_W2K"; break;
		case DNSSRV_TYPEID_NAME_AND_PARAM: val = "DNSSRV_TYPEID_NAME_AND_PARAM"; break;
		case DNSSRV_TYPEID_ZONE_LIST_W2K: val = "DNSSRV_TYPEID_ZONE_LIST_W2K"; break;
		case DNSSRV_TYPEID_ZONE_RENAME: val = "DNSSRV_TYPEID_ZONE_RENAME"; break;
		case DNSSRV_TYPEID_ZONE_EXPORT: val = "DNSSRV_TYPEID_ZONE_EXPORT"; break;
		case DNSSRV_TYPEID_SERVER_INFO_DOTNET: val = "DNSSRV_TYPEID_SERVER_INFO_DOTNET"; break;
		case DNSSRV_TYPEID_FORWARDERS_DOTNET: val = "DNSSRV_TYPEID_FORWARDERS_DOTNET"; break;
		case DNSSRV_TYPEID_ZONE: val = "DNSSRV_TYPEID_ZONE"; break;
		case DNSSRV_TYPEID_ZONE_INFO_DOTNET: val = "DNSSRV_TYPEID_ZONE_INFO_DOTNET"; break;
		case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET: val = "DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET"; break;
		case DNSSRV_TYPEID_ZONE_DATABASE: val = "DNSSRV_TYPEID_ZONE_DATABASE"; break;
		case DNSSRV_TYPEID_ZONE_TYPE_RESET_DOTNET: val = "DNSSRV_TYPEID_ZONE_TYPE_RESET_DOTNET"; break;
		case DNSSRV_TYPEID_ZONE_CREATE_DOTNET: val = "DNSSRV_TYPEID_ZONE_CREATE_DOTNET"; break;
		case DNSSRV_TYPEID_ZONE_LIST: val = "DNSSRV_TYPEID_ZONE_LIST"; break;
		case DNSSRV_TYPEID_DP_ENUM: val = "DNSSRV_TYPEID_DP_ENUM"; break;
		case DNSSRV_TYPEID_DP_INFO: val = "DNSSRV_TYPEID_DP_INFO"; break;
		case DNSSRV_TYPEID_DP_LIST: val = "DNSSRV_TYPEID_DP_LIST"; break;
		case DNSSRV_TYPEID_ENLIST_DP: val = "DNSSRV_TYPEID_ENLIST_DP"; break;
		case DNSSRV_TYPEID_ZONE_CHANGE_DP: val = "DNSSRV_TYPEID_ZONE_CHANGE_DP"; break;
		case DNSSRV_TYPEID_ENUM_ZONES_FILTER: val = "DNSSRV_TYPEID_ENUM_ZONES_FILTER"; break;
		case DNSSRV_TYPEID_ADDRARRAY: val = "DNSSRV_TYPEID_ADDRARRAY"; break;
		case DNSSRV_TYPEID_SERVER_INFO: val = "DNSSRV_TYPEID_SERVER_INFO"; break;
		case DNSSRV_TYPEID_ZONE_INFO: val = "DNSSRV_TYPEID_ZONE_INFO"; break;
		case DNSSRV_TYPEID_FORWARDERS: val = "DNSSRV_TYPEID_FORWARDERS"; break;
		case DNSSRV_TYPEID_ZONE_SECONDARIES: val = "DNSSRV_TYPEID_ZONE_SECONDARIES"; break;
		case DNSSRV_TYPEID_ZONE_TYPE_RESET: val = "DNSSRV_TYPEID_ZONE_TYPE_RESET"; break;
		case DNSSRV_TYPEID_ZONE_CREATE: val = "DNSSRV_TYPEID_ZONE_CREATE"; break;
		case DNSSRV_TYPEID_IP_VALIDATE: val = "DNSSRV_TYPEID_IP_VALIDATE"; break;
		case DNSSRV_TYPEID_AUTOCONFIGURE: val = "DNSSRV_TYPEID_AUTOCONFIGURE"; break;
		case DNSSRV_TYPEID_UTF8_STRING_LIST: val = "DNSSRV_TYPEID_UTF8_STRING_LIST"; break;
		case DNSSRV_TYPEID_UNICODE_STRING_LIST: val = "DNSSRV_TYPEID_UNICODE_STRING_LIST"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DNSSRV_RPC_UNION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union DNSSRV_RPC_UNION *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case DNSSRV_TYPEID_NULL: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Null));
			break; }

			case DNSSRV_TYPEID_DWORD: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Dword));
			break; }

			case DNSSRV_TYPEID_LPSTR: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->String));
			break; }

			case DNSSRV_TYPEID_LPWSTR: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->WideString));
			break; }

			case DNSSRV_TYPEID_IPARRAY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->IpArray));
			break; }

			case DNSSRV_TYPEID_BUFFER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Buffer));
			break; }

			case DNSSRV_TYPEID_SERVER_INFO_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ServerInfoW2K));
			break; }

			case DNSSRV_TYPEID_STATS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Stats));
			break; }

			case DNSSRV_TYPEID_FORWARDERS_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ForwardersW2K));
			break; }

			case DNSSRV_TYPEID_ZONE_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneW2K));
			break; }

			case DNSSRV_TYPEID_ZONE_INFO_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneInfoW2K));
			break; }

			case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->SecondariesW2K));
			break; }

			case DNSSRV_TYPEID_ZONE_DATABASE_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->DatabaseW2K));
			break; }

			case DNSSRV_TYPEID_ZONE_CREATE_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneCreateW2K));
			break; }

			case DNSSRV_TYPEID_NAME_AND_PARAM: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->NameAndParam));
			break; }

			case DNSSRV_TYPEID_ZONE_LIST_W2K: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneListW2K));
			break; }

			case DNSSRV_TYPEID_SERVER_INFO_DOTNET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ServerInfoDotNet));
			break; }

			case DNSSRV_TYPEID_FORWARDERS_DOTNET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ForwardersDotNet));
			break; }

			case DNSSRV_TYPEID_ZONE: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Zone));
			break; }

			case DNSSRV_TYPEID_ZONE_INFO_DOTNET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneInfoDotNet));
			break; }

			case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->SecondariesDotNet));
			break; }

			case DNSSRV_TYPEID_ZONE_DATABASE: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Database));
			break; }

			case DNSSRV_TYPEID_ZONE_CREATE_DOTNET: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneCreateDotNet));
			break; }

			case DNSSRV_TYPEID_ZONE_LIST: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneList));
			break; }

			case DNSSRV_TYPEID_ZONE_EXPORT: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneExport));
			break; }

			case DNSSRV_TYPEID_DP_INFO: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->DirectoryPartition));
			break; }

			case DNSSRV_TYPEID_DP_ENUM: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->DirectoryPartitionEnum));
			break; }

			case DNSSRV_TYPEID_DP_LIST: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->DirectoryPartitionList));
			break; }

			case DNSSRV_TYPEID_ENLIST_DP: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->EnlistDirectoryPartition));
			break; }

			case DNSSRV_TYPEID_ZONE_CHANGE_DP: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneChangeDirectoryPartition));
			break; }

			case DNSSRV_TYPEID_ENUM_ZONES_FILTER: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->EnumZonesFilter));
			break; }

			case DNSSRV_TYPEID_ADDRARRAY: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->AddrArray));
			break; }

			case DNSSRV_TYPEID_SERVER_INFO: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ServerInfo));
			break; }

			case DNSSRV_TYPEID_ZONE_CREATE: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneCreate));
			break; }

			case DNSSRV_TYPEID_FORWARDERS: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Forwarders));
			break; }

			case DNSSRV_TYPEID_ZONE_SECONDARIES: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Secondaries));
			break; }

			case DNSSRV_TYPEID_IP_VALIDATE: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->IpValidate));
			break; }

			case DNSSRV_TYPEID_ZONE_INFO: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->ZoneInfo));
			break; }

			case DNSSRV_TYPEID_AUTOCONFIGURE: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->AutoConfigure));
			break; }

			case DNSSRV_TYPEID_UTF8_STRING_LIST: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->Utf8StringList));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DNSSRV_TYPEID_NULL:
				if (r->Null) {
					NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->Null));
				}
			break;

			case DNSSRV_TYPEID_DWORD:
			break;

			case DNSSRV_TYPEID_LPSTR:
				if (r->String) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->String, CH_UTF8)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->String, CH_UTF8)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->String, ndr_charset_length(r->String, CH_UTF8), sizeof(uint8_t), CH_UTF8));
				}
			break;

			case DNSSRV_TYPEID_LPWSTR:
				if (r->WideString) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->WideString, CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->WideString, CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->WideString, ndr_charset_length(r->WideString, CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			break;

			case DNSSRV_TYPEID_IPARRAY:
				if (r->IpArray) {
					NDR_CHECK(ndr_push_IP4_ARRAY(ndr, NDR_SCALARS, r->IpArray));
				}
			break;

			case DNSSRV_TYPEID_BUFFER:
				if (r->Buffer) {
					NDR_CHECK(ndr_push_DNS_RPC_BUFFER(ndr, NDR_SCALARS, r->Buffer));
				}
			break;

			case DNSSRV_TYPEID_SERVER_INFO_W2K:
				if (r->ServerInfoW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_SERVER_INFO_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ServerInfoW2K));
				}
			break;

			case DNSSRV_TYPEID_STATS:
				if (r->Stats) {
					NDR_CHECK(ndr_push_DNSSRV_STAT(ndr, NDR_SCALARS, r->Stats));
				}
			break;

			case DNSSRV_TYPEID_FORWARDERS_W2K:
				if (r->ForwardersW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_FORWARDERS_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ForwardersW2K));
				}
			break;

			case DNSSRV_TYPEID_ZONE_W2K:
				if (r->ZoneW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneW2K));
				}
			break;

			case DNSSRV_TYPEID_ZONE_INFO_W2K:
				if (r->ZoneInfoW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_INFO_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneInfoW2K));
				}
			break;

			case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
				if (r->SecondariesW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_SECONDARIES_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->SecondariesW2K));
				}
			break;

			case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
				if (r->DatabaseW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_DATABASE_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->DatabaseW2K));
				}
			break;

			case DNSSRV_TYPEID_ZONE_CREATE_W2K:
				if (r->ZoneCreateW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_CREATE_INFO_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneCreateW2K));
				}
			break;

			case DNSSRV_TYPEID_NAME_AND_PARAM:
				if (r->NameAndParam) {
					NDR_CHECK(ndr_push_DNS_RPC_NAME_AND_PARAM(ndr, NDR_SCALARS|NDR_BUFFERS, r->NameAndParam));
				}
			break;

			case DNSSRV_TYPEID_ZONE_LIST_W2K:
				if (r->ZoneListW2K) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_LIST_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneListW2K));
				}
			break;

			case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
				if (r->ServerInfoDotNet) {
					NDR_CHECK(ndr_push_DNS_RPC_SERVER_INFO_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ServerInfoDotNet));
				}
			break;

			case DNSSRV_TYPEID_FORWARDERS_DOTNET:
				if (r->ForwardersDotNet) {
					NDR_CHECK(ndr_push_DNS_RPC_FORWARDERS_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ForwardersDotNet));
				}
			break;

			case DNSSRV_TYPEID_ZONE:
				if (r->Zone) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->Zone));
				}
			break;

			case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
				if (r->ZoneInfoDotNet) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_INFO_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneInfoDotNet));
				}
			break;

			case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
				if (r->SecondariesDotNet) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_SECONDARIES_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->SecondariesDotNet));
				}
			break;

			case DNSSRV_TYPEID_ZONE_DATABASE:
				if (r->Database) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_DATABASE_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->Database));
				}
			break;

			case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
				if (r->ZoneCreateDotNet) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_CREATE_INFO_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneCreateDotNet));
				}
			break;

			case DNSSRV_TYPEID_ZONE_LIST:
				if (r->ZoneList) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_LIST_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneList));
				}
			break;

			case DNSSRV_TYPEID_ZONE_EXPORT:
				if (r->ZoneExport) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_EXPORT_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneExport));
				}
			break;

			case DNSSRV_TYPEID_DP_INFO:
				if (r->DirectoryPartition) {
					NDR_CHECK(ndr_push_DNS_RPC_DP_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->DirectoryPartition));
				}
			break;

			case DNSSRV_TYPEID_DP_ENUM:
				if (r->DirectoryPartitionEnum) {
					NDR_CHECK(ndr_push_DNS_RPC_DP_ENUM(ndr, NDR_SCALARS|NDR_BUFFERS, r->DirectoryPartitionEnum));
				}
			break;

			case DNSSRV_TYPEID_DP_LIST:
				if (r->DirectoryPartitionList) {
					NDR_CHECK(ndr_push_DNS_RPC_DP_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, r->DirectoryPartitionList));
				}
			break;

			case DNSSRV_TYPEID_ENLIST_DP:
				if (r->EnlistDirectoryPartition) {
					NDR_CHECK(ndr_push_DNS_RPC_ENLIST_DP(ndr, NDR_SCALARS|NDR_BUFFERS, r->EnlistDirectoryPartition));
				}
			break;

			case DNSSRV_TYPEID_ZONE_CHANGE_DP:
				if (r->ZoneChangeDirectoryPartition) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_CHANGE_DP(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneChangeDirectoryPartition));
				}
			break;

			case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
				if (r->EnumZonesFilter) {
					NDR_CHECK(ndr_push_DNS_RPC_ENUM_ZONES_FILTER(ndr, NDR_SCALARS|NDR_BUFFERS, r->EnumZonesFilter));
				}
			break;

			case DNSSRV_TYPEID_ADDRARRAY:
				if (r->AddrArray) {
					NDR_CHECK(ndr_push_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->AddrArray));
				}
			break;

			case DNSSRV_TYPEID_SERVER_INFO:
				if (r->ServerInfo) {
					NDR_CHECK(ndr_push_DNS_RPC_SERVER_INFO_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->ServerInfo));
				}
			break;

			case DNSSRV_TYPEID_ZONE_CREATE:
				if (r->ZoneCreate) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_CREATE_INFO_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneCreate));
				}
			break;

			case DNSSRV_TYPEID_FORWARDERS:
				if (r->Forwarders) {
					NDR_CHECK(ndr_push_DNS_RPC_FORWARDERS_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->Forwarders));
				}
			break;

			case DNSSRV_TYPEID_ZONE_SECONDARIES:
				if (r->Secondaries) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_SECONDARIES_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->Secondaries));
				}
			break;

			case DNSSRV_TYPEID_IP_VALIDATE:
				if (r->IpValidate) {
					NDR_CHECK(ndr_push_DNS_RPC_IP_VALIDATE(ndr, NDR_SCALARS|NDR_BUFFERS, r->IpValidate));
				}
			break;

			case DNSSRV_TYPEID_ZONE_INFO:
				if (r->ZoneInfo) {
					NDR_CHECK(ndr_push_DNS_RPC_ZONE_INFO_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneInfo));
				}
			break;

			case DNSSRV_TYPEID_AUTOCONFIGURE:
				if (r->AutoConfigure) {
					NDR_CHECK(ndr_push_DNS_RPC_AUTOCONFIGURE(ndr, NDR_SCALARS|NDR_BUFFERS, r->AutoConfigure));
				}
			break;

			case DNSSRV_TYPEID_UTF8_STRING_LIST:
				if (r->Utf8StringList) {
					NDR_CHECK(ndr_push_DNS_RPC_UTF8_STRING_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, r->Utf8StringList));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DNSSRV_RPC_UNION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union DNSSRV_RPC_UNION *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_Null_0 = NULL;
	uint32_t _ptr_Null;
	TALLOC_CTX *_mem_save_String_0 = NULL;
	uint32_t _ptr_String;
	uint32_t size_String_1 = 0;
	uint32_t length_String_1 = 0;
	TALLOC_CTX *_mem_save_WideString_0 = NULL;
	uint32_t _ptr_WideString;
	uint32_t size_WideString_1 = 0;
	uint32_t length_WideString_1 = 0;
	TALLOC_CTX *_mem_save_IpArray_0 = NULL;
	uint32_t _ptr_IpArray;
	TALLOC_CTX *_mem_save_Buffer_0 = NULL;
	uint32_t _ptr_Buffer;
	TALLOC_CTX *_mem_save_ServerInfoW2K_0 = NULL;
	uint32_t _ptr_ServerInfoW2K;
	TALLOC_CTX *_mem_save_Stats_0 = NULL;
	uint32_t _ptr_Stats;
	TALLOC_CTX *_mem_save_ForwardersW2K_0 = NULL;
	uint32_t _ptr_ForwardersW2K;
	TALLOC_CTX *_mem_save_ZoneW2K_0 = NULL;
	uint32_t _ptr_ZoneW2K;
	TALLOC_CTX *_mem_save_ZoneInfoW2K_0 = NULL;
	uint32_t _ptr_ZoneInfoW2K;
	TALLOC_CTX *_mem_save_SecondariesW2K_0 = NULL;
	uint32_t _ptr_SecondariesW2K;
	TALLOC_CTX *_mem_save_DatabaseW2K_0 = NULL;
	uint32_t _ptr_DatabaseW2K;
	TALLOC_CTX *_mem_save_ZoneCreateW2K_0 = NULL;
	uint32_t _ptr_ZoneCreateW2K;
	TALLOC_CTX *_mem_save_NameAndParam_0 = NULL;
	uint32_t _ptr_NameAndParam;
	TALLOC_CTX *_mem_save_ZoneListW2K_0 = NULL;
	uint32_t _ptr_ZoneListW2K;
	TALLOC_CTX *_mem_save_ServerInfoDotNet_0 = NULL;
	uint32_t _ptr_ServerInfoDotNet;
	TALLOC_CTX *_mem_save_ForwardersDotNet_0 = NULL;
	uint32_t _ptr_ForwardersDotNet;
	TALLOC_CTX *_mem_save_Zone_0 = NULL;
	uint32_t _ptr_Zone;
	TALLOC_CTX *_mem_save_ZoneInfoDotNet_0 = NULL;
	uint32_t _ptr_ZoneInfoDotNet;
	TALLOC_CTX *_mem_save_SecondariesDotNet_0 = NULL;
	uint32_t _ptr_SecondariesDotNet;
	TALLOC_CTX *_mem_save_Database_0 = NULL;
	uint32_t _ptr_Database;
	TALLOC_CTX *_mem_save_ZoneCreateDotNet_0 = NULL;
	uint32_t _ptr_ZoneCreateDotNet;
	TALLOC_CTX *_mem_save_ZoneList_0 = NULL;
	uint32_t _ptr_ZoneList;
	TALLOC_CTX *_mem_save_ZoneExport_0 = NULL;
	uint32_t _ptr_ZoneExport;
	TALLOC_CTX *_mem_save_DirectoryPartition_0 = NULL;
	uint32_t _ptr_DirectoryPartition;
	TALLOC_CTX *_mem_save_DirectoryPartitionEnum_0 = NULL;
	uint32_t _ptr_DirectoryPartitionEnum;
	TALLOC_CTX *_mem_save_DirectoryPartitionList_0 = NULL;
	uint32_t _ptr_DirectoryPartitionList;
	TALLOC_CTX *_mem_save_EnlistDirectoryPartition_0 = NULL;
	uint32_t _ptr_EnlistDirectoryPartition;
	TALLOC_CTX *_mem_save_ZoneChangeDirectoryPartition_0 = NULL;
	uint32_t _ptr_ZoneChangeDirectoryPartition;
	TALLOC_CTX *_mem_save_EnumZonesFilter_0 = NULL;
	uint32_t _ptr_EnumZonesFilter;
	TALLOC_CTX *_mem_save_AddrArray_0 = NULL;
	uint32_t _ptr_AddrArray;
	TALLOC_CTX *_mem_save_ServerInfo_0 = NULL;
	uint32_t _ptr_ServerInfo;
	TALLOC_CTX *_mem_save_ZoneCreate_0 = NULL;
	uint32_t _ptr_ZoneCreate;
	TALLOC_CTX *_mem_save_Forwarders_0 = NULL;
	uint32_t _ptr_Forwarders;
	TALLOC_CTX *_mem_save_Secondaries_0 = NULL;
	uint32_t _ptr_Secondaries;
	TALLOC_CTX *_mem_save_IpValidate_0 = NULL;
	uint32_t _ptr_IpValidate;
	TALLOC_CTX *_mem_save_ZoneInfo_0 = NULL;
	uint32_t _ptr_ZoneInfo;
	TALLOC_CTX *_mem_save_AutoConfigure_0 = NULL;
	uint32_t _ptr_AutoConfigure;
	TALLOC_CTX *_mem_save_Utf8StringList_0 = NULL;
	uint32_t _ptr_Utf8StringList;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case DNSSRV_TYPEID_NULL: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Null));
				if (_ptr_Null) {
					NDR_PULL_ALLOC(ndr, r->Null);
				} else {
					r->Null = NULL;
				}
			break; }

			case DNSSRV_TYPEID_DWORD: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Dword));
			break; }

			case DNSSRV_TYPEID_LPSTR: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_String));
				if (_ptr_String) {
					NDR_PULL_ALLOC(ndr, r->String);
				} else {
					r->String = NULL;
				}
			break; }

			case DNSSRV_TYPEID_LPWSTR: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_WideString));
				if (_ptr_WideString) {
					NDR_PULL_ALLOC(ndr, r->WideString);
				} else {
					r->WideString = NULL;
				}
			break; }

			case DNSSRV_TYPEID_IPARRAY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_IpArray));
				if (_ptr_IpArray) {
					NDR_PULL_ALLOC(ndr, r->IpArray);
				} else {
					r->IpArray = NULL;
				}
			break; }

			case DNSSRV_TYPEID_BUFFER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Buffer));
				if (_ptr_Buffer) {
					NDR_PULL_ALLOC(ndr, r->Buffer);
				} else {
					r->Buffer = NULL;
				}
			break; }

			case DNSSRV_TYPEID_SERVER_INFO_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServerInfoW2K));
				if (_ptr_ServerInfoW2K) {
					NDR_PULL_ALLOC(ndr, r->ServerInfoW2K);
				} else {
					r->ServerInfoW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_STATS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Stats));
				if (_ptr_Stats) {
					NDR_PULL_ALLOC(ndr, r->Stats);
				} else {
					r->Stats = NULL;
				}
			break; }

			case DNSSRV_TYPEID_FORWARDERS_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ForwardersW2K));
				if (_ptr_ForwardersW2K) {
					NDR_PULL_ALLOC(ndr, r->ForwardersW2K);
				} else {
					r->ForwardersW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneW2K));
				if (_ptr_ZoneW2K) {
					NDR_PULL_ALLOC(ndr, r->ZoneW2K);
				} else {
					r->ZoneW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_INFO_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneInfoW2K));
				if (_ptr_ZoneInfoW2K) {
					NDR_PULL_ALLOC(ndr, r->ZoneInfoW2K);
				} else {
					r->ZoneInfoW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_SecondariesW2K));
				if (_ptr_SecondariesW2K) {
					NDR_PULL_ALLOC(ndr, r->SecondariesW2K);
				} else {
					r->SecondariesW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_DATABASE_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DatabaseW2K));
				if (_ptr_DatabaseW2K) {
					NDR_PULL_ALLOC(ndr, r->DatabaseW2K);
				} else {
					r->DatabaseW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_CREATE_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneCreateW2K));
				if (_ptr_ZoneCreateW2K) {
					NDR_PULL_ALLOC(ndr, r->ZoneCreateW2K);
				} else {
					r->ZoneCreateW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_NAME_AND_PARAM: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NameAndParam));
				if (_ptr_NameAndParam) {
					NDR_PULL_ALLOC(ndr, r->NameAndParam);
				} else {
					r->NameAndParam = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_LIST_W2K: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneListW2K));
				if (_ptr_ZoneListW2K) {
					NDR_PULL_ALLOC(ndr, r->ZoneListW2K);
				} else {
					r->ZoneListW2K = NULL;
				}
			break; }

			case DNSSRV_TYPEID_SERVER_INFO_DOTNET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServerInfoDotNet));
				if (_ptr_ServerInfoDotNet) {
					NDR_PULL_ALLOC(ndr, r->ServerInfoDotNet);
				} else {
					r->ServerInfoDotNet = NULL;
				}
			break; }

			case DNSSRV_TYPEID_FORWARDERS_DOTNET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ForwardersDotNet));
				if (_ptr_ForwardersDotNet) {
					NDR_PULL_ALLOC(ndr, r->ForwardersDotNet);
				} else {
					r->ForwardersDotNet = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Zone));
				if (_ptr_Zone) {
					NDR_PULL_ALLOC(ndr, r->Zone);
				} else {
					r->Zone = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_INFO_DOTNET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneInfoDotNet));
				if (_ptr_ZoneInfoDotNet) {
					NDR_PULL_ALLOC(ndr, r->ZoneInfoDotNet);
				} else {
					r->ZoneInfoDotNet = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_SecondariesDotNet));
				if (_ptr_SecondariesDotNet) {
					NDR_PULL_ALLOC(ndr, r->SecondariesDotNet);
				} else {
					r->SecondariesDotNet = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_DATABASE: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Database));
				if (_ptr_Database) {
					NDR_PULL_ALLOC(ndr, r->Database);
				} else {
					r->Database = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_CREATE_DOTNET: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneCreateDotNet));
				if (_ptr_ZoneCreateDotNet) {
					NDR_PULL_ALLOC(ndr, r->ZoneCreateDotNet);
				} else {
					r->ZoneCreateDotNet = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_LIST: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneList));
				if (_ptr_ZoneList) {
					NDR_PULL_ALLOC(ndr, r->ZoneList);
				} else {
					r->ZoneList = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_EXPORT: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneExport));
				if (_ptr_ZoneExport) {
					NDR_PULL_ALLOC(ndr, r->ZoneExport);
				} else {
					r->ZoneExport = NULL;
				}
			break; }

			case DNSSRV_TYPEID_DP_INFO: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DirectoryPartition));
				if (_ptr_DirectoryPartition) {
					NDR_PULL_ALLOC(ndr, r->DirectoryPartition);
				} else {
					r->DirectoryPartition = NULL;
				}
			break; }

			case DNSSRV_TYPEID_DP_ENUM: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DirectoryPartitionEnum));
				if (_ptr_DirectoryPartitionEnum) {
					NDR_PULL_ALLOC(ndr, r->DirectoryPartitionEnum);
				} else {
					r->DirectoryPartitionEnum = NULL;
				}
			break; }

			case DNSSRV_TYPEID_DP_LIST: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DirectoryPartitionList));
				if (_ptr_DirectoryPartitionList) {
					NDR_PULL_ALLOC(ndr, r->DirectoryPartitionList);
				} else {
					r->DirectoryPartitionList = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ENLIST_DP: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_EnlistDirectoryPartition));
				if (_ptr_EnlistDirectoryPartition) {
					NDR_PULL_ALLOC(ndr, r->EnlistDirectoryPartition);
				} else {
					r->EnlistDirectoryPartition = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_CHANGE_DP: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneChangeDirectoryPartition));
				if (_ptr_ZoneChangeDirectoryPartition) {
					NDR_PULL_ALLOC(ndr, r->ZoneChangeDirectoryPartition);
				} else {
					r->ZoneChangeDirectoryPartition = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ENUM_ZONES_FILTER: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_EnumZonesFilter));
				if (_ptr_EnumZonesFilter) {
					NDR_PULL_ALLOC(ndr, r->EnumZonesFilter);
				} else {
					r->EnumZonesFilter = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ADDRARRAY: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_AddrArray));
				if (_ptr_AddrArray) {
					NDR_PULL_ALLOC(ndr, r->AddrArray);
				} else {
					r->AddrArray = NULL;
				}
			break; }

			case DNSSRV_TYPEID_SERVER_INFO: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServerInfo));
				if (_ptr_ServerInfo) {
					NDR_PULL_ALLOC(ndr, r->ServerInfo);
				} else {
					r->ServerInfo = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_CREATE: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneCreate));
				if (_ptr_ZoneCreate) {
					NDR_PULL_ALLOC(ndr, r->ZoneCreate);
				} else {
					r->ZoneCreate = NULL;
				}
			break; }

			case DNSSRV_TYPEID_FORWARDERS: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Forwarders));
				if (_ptr_Forwarders) {
					NDR_PULL_ALLOC(ndr, r->Forwarders);
				} else {
					r->Forwarders = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_SECONDARIES: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Secondaries));
				if (_ptr_Secondaries) {
					NDR_PULL_ALLOC(ndr, r->Secondaries);
				} else {
					r->Secondaries = NULL;
				}
			break; }

			case DNSSRV_TYPEID_IP_VALIDATE: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_IpValidate));
				if (_ptr_IpValidate) {
					NDR_PULL_ALLOC(ndr, r->IpValidate);
				} else {
					r->IpValidate = NULL;
				}
			break; }

			case DNSSRV_TYPEID_ZONE_INFO: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ZoneInfo));
				if (_ptr_ZoneInfo) {
					NDR_PULL_ALLOC(ndr, r->ZoneInfo);
				} else {
					r->ZoneInfo = NULL;
				}
			break; }

			case DNSSRV_TYPEID_AUTOCONFIGURE: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_AutoConfigure));
				if (_ptr_AutoConfigure) {
					NDR_PULL_ALLOC(ndr, r->AutoConfigure);
				} else {
					r->AutoConfigure = NULL;
				}
			break; }

			case DNSSRV_TYPEID_UTF8_STRING_LIST: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Utf8StringList));
				if (_ptr_Utf8StringList) {
					NDR_PULL_ALLOC(ndr, r->Utf8StringList);
				} else {
					r->Utf8StringList = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DNSSRV_TYPEID_NULL:
				if (r->Null) {
					_mem_save_Null_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Null, 0);
					NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->Null));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Null_0, 0);
				}
			break;

			case DNSSRV_TYPEID_DWORD:
			break;

			case DNSSRV_TYPEID_LPSTR:
				if (r->String) {
					_mem_save_String_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->String, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->String));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->String));
					NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->String, &size_String_1));
					NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->String, &length_String_1));
					if (length_String_1 > size_String_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_String_1, length_String_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_String_1, sizeof(uint8_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->String, length_String_1, sizeof(uint8_t), CH_UTF8));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_String_0, 0);
				}
			break;

			case DNSSRV_TYPEID_LPWSTR:
				if (r->WideString) {
					_mem_save_WideString_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->WideString, 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->WideString));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->WideString));
					NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->WideString, &size_WideString_1));
					NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->WideString, &length_WideString_1));
					if (length_WideString_1 > size_WideString_1) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_WideString_1, length_WideString_1);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_WideString_1, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->WideString, length_WideString_1, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_WideString_0, 0);
				}
			break;

			case DNSSRV_TYPEID_IPARRAY:
				if (r->IpArray) {
					_mem_save_IpArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->IpArray, 0);
					NDR_CHECK(ndr_pull_IP4_ARRAY(ndr, NDR_SCALARS, r->IpArray));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_IpArray_0, 0);
				}
			break;

			case DNSSRV_TYPEID_BUFFER:
				if (r->Buffer) {
					_mem_save_Buffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Buffer, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_BUFFER(ndr, NDR_SCALARS, r->Buffer));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Buffer_0, 0);
				}
			break;

			case DNSSRV_TYPEID_SERVER_INFO_W2K:
				if (r->ServerInfoW2K) {
					_mem_save_ServerInfoW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ServerInfoW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_SERVER_INFO_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ServerInfoW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServerInfoW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_STATS:
				if (r->Stats) {
					_mem_save_Stats_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Stats, 0);
					NDR_CHECK(ndr_pull_DNSSRV_STAT(ndr, NDR_SCALARS, r->Stats));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Stats_0, 0);
				}
			break;

			case DNSSRV_TYPEID_FORWARDERS_W2K:
				if (r->ForwardersW2K) {
					_mem_save_ForwardersW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ForwardersW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_FORWARDERS_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ForwardersW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ForwardersW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_W2K:
				if (r->ZoneW2K) {
					_mem_save_ZoneW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_INFO_W2K:
				if (r->ZoneInfoW2K) {
					_mem_save_ZoneInfoW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneInfoW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_INFO_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneInfoW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneInfoW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
				if (r->SecondariesW2K) {
					_mem_save_SecondariesW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->SecondariesW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_SECONDARIES_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->SecondariesW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_SecondariesW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
				if (r->DatabaseW2K) {
					_mem_save_DatabaseW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->DatabaseW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_DATABASE_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->DatabaseW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DatabaseW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_CREATE_W2K:
				if (r->ZoneCreateW2K) {
					_mem_save_ZoneCreateW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneCreateW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_CREATE_INFO_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneCreateW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneCreateW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_NAME_AND_PARAM:
				if (r->NameAndParam) {
					_mem_save_NameAndParam_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->NameAndParam, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_NAME_AND_PARAM(ndr, NDR_SCALARS|NDR_BUFFERS, r->NameAndParam));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NameAndParam_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_LIST_W2K:
				if (r->ZoneListW2K) {
					_mem_save_ZoneListW2K_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneListW2K, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_LIST_W2K(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneListW2K));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneListW2K_0, 0);
				}
			break;

			case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
				if (r->ServerInfoDotNet) {
					_mem_save_ServerInfoDotNet_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ServerInfoDotNet, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_SERVER_INFO_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ServerInfoDotNet));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServerInfoDotNet_0, 0);
				}
			break;

			case DNSSRV_TYPEID_FORWARDERS_DOTNET:
				if (r->ForwardersDotNet) {
					_mem_save_ForwardersDotNet_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ForwardersDotNet, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_FORWARDERS_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ForwardersDotNet));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ForwardersDotNet_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE:
				if (r->Zone) {
					_mem_save_Zone_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Zone, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->Zone));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Zone_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
				if (r->ZoneInfoDotNet) {
					_mem_save_ZoneInfoDotNet_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneInfoDotNet, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_INFO_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneInfoDotNet));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneInfoDotNet_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
				if (r->SecondariesDotNet) {
					_mem_save_SecondariesDotNet_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->SecondariesDotNet, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_SECONDARIES_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->SecondariesDotNet));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_SecondariesDotNet_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_DATABASE:
				if (r->Database) {
					_mem_save_Database_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Database, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_DATABASE_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->Database));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Database_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
				if (r->ZoneCreateDotNet) {
					_mem_save_ZoneCreateDotNet_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneCreateDotNet, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_CREATE_INFO_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneCreateDotNet));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneCreateDotNet_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_LIST:
				if (r->ZoneList) {
					_mem_save_ZoneList_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneList, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_LIST_DOTNET(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneList));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneList_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_EXPORT:
				if (r->ZoneExport) {
					_mem_save_ZoneExport_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneExport, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_EXPORT_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneExport));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneExport_0, 0);
				}
			break;

			case DNSSRV_TYPEID_DP_INFO:
				if (r->DirectoryPartition) {
					_mem_save_DirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->DirectoryPartition, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_DP_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->DirectoryPartition));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DirectoryPartition_0, 0);
				}
			break;

			case DNSSRV_TYPEID_DP_ENUM:
				if (r->DirectoryPartitionEnum) {
					_mem_save_DirectoryPartitionEnum_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->DirectoryPartitionEnum, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_DP_ENUM(ndr, NDR_SCALARS|NDR_BUFFERS, r->DirectoryPartitionEnum));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DirectoryPartitionEnum_0, 0);
				}
			break;

			case DNSSRV_TYPEID_DP_LIST:
				if (r->DirectoryPartitionList) {
					_mem_save_DirectoryPartitionList_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->DirectoryPartitionList, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_DP_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, r->DirectoryPartitionList));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DirectoryPartitionList_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ENLIST_DP:
				if (r->EnlistDirectoryPartition) {
					_mem_save_EnlistDirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->EnlistDirectoryPartition, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ENLIST_DP(ndr, NDR_SCALARS|NDR_BUFFERS, r->EnlistDirectoryPartition));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_EnlistDirectoryPartition_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_CHANGE_DP:
				if (r->ZoneChangeDirectoryPartition) {
					_mem_save_ZoneChangeDirectoryPartition_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneChangeDirectoryPartition, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_CHANGE_DP(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneChangeDirectoryPartition));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneChangeDirectoryPartition_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
				if (r->EnumZonesFilter) {
					_mem_save_EnumZonesFilter_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->EnumZonesFilter, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ENUM_ZONES_FILTER(ndr, NDR_SCALARS|NDR_BUFFERS, r->EnumZonesFilter));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_EnumZonesFilter_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ADDRARRAY:
				if (r->AddrArray) {
					_mem_save_AddrArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->AddrArray, 0);
					NDR_CHECK(ndr_pull_DNS_ADDR_ARRAY(ndr, NDR_SCALARS, r->AddrArray));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AddrArray_0, 0);
				}
			break;

			case DNSSRV_TYPEID_SERVER_INFO:
				if (r->ServerInfo) {
					_mem_save_ServerInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ServerInfo, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->ServerInfo));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServerInfo_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_CREATE:
				if (r->ZoneCreate) {
					_mem_save_ZoneCreate_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneCreate, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_CREATE_INFO_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneCreate));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneCreate_0, 0);
				}
			break;

			case DNSSRV_TYPEID_FORWARDERS:
				if (r->Forwarders) {
					_mem_save_Forwarders_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Forwarders, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_FORWARDERS_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->Forwarders));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Forwarders_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_SECONDARIES:
				if (r->Secondaries) {
					_mem_save_Secondaries_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Secondaries, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_SECONDARIES_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->Secondaries));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Secondaries_0, 0);
				}
			break;

			case DNSSRV_TYPEID_IP_VALIDATE:
				if (r->IpValidate) {
					_mem_save_IpValidate_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->IpValidate, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_IP_VALIDATE(ndr, NDR_SCALARS|NDR_BUFFERS, r->IpValidate));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_IpValidate_0, 0);
				}
			break;

			case DNSSRV_TYPEID_ZONE_INFO:
				if (r->ZoneInfo) {
					_mem_save_ZoneInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->ZoneInfo, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_ZONE_INFO_LONGHORN(ndr, NDR_SCALARS|NDR_BUFFERS, r->ZoneInfo));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ZoneInfo_0, 0);
				}
			break;

			case DNSSRV_TYPEID_AUTOCONFIGURE:
				if (r->AutoConfigure) {
					_mem_save_AutoConfigure_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->AutoConfigure, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_AUTOCONFIGURE(ndr, NDR_SCALARS|NDR_BUFFERS, r->AutoConfigure));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AutoConfigure_0, 0);
				}
			break;

			case DNSSRV_TYPEID_UTF8_STRING_LIST:
				if (r->Utf8StringList) {
					_mem_save_Utf8StringList_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Utf8StringList, 0);
					NDR_CHECK(ndr_pull_DNS_RPC_UTF8_STRING_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, r->Utf8StringList));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Utf8StringList_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DNSSRV_RPC_UNION(struct ndr_print *ndr, const char *name, const union DNSSRV_RPC_UNION *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "DNSSRV_RPC_UNION");
	switch (level) {
		case DNSSRV_TYPEID_NULL:
			ndr_print_ptr(ndr, "Null", r->Null);
			ndr->depth++;
			if (r->Null) {
				ndr_print_uint8(ndr, "Null", *r->Null);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_DWORD:
			ndr_print_uint32(ndr, "Dword", r->Dword);
		break;

		case DNSSRV_TYPEID_LPSTR:
			ndr_print_ptr(ndr, "String", r->String);
			ndr->depth++;
			if (r->String) {
				ndr_print_string(ndr, "String", r->String);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_LPWSTR:
			ndr_print_ptr(ndr, "WideString", r->WideString);
			ndr->depth++;
			if (r->WideString) {
				ndr_print_string(ndr, "WideString", r->WideString);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_IPARRAY:
			ndr_print_ptr(ndr, "IpArray", r->IpArray);
			ndr->depth++;
			if (r->IpArray) {
				ndr_print_IP4_ARRAY(ndr, "IpArray", r->IpArray);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_BUFFER:
			ndr_print_ptr(ndr, "Buffer", r->Buffer);
			ndr->depth++;
			if (r->Buffer) {
				ndr_print_DNS_RPC_BUFFER(ndr, "Buffer", r->Buffer);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_SERVER_INFO_W2K:
			ndr_print_ptr(ndr, "ServerInfoW2K", r->ServerInfoW2K);
			ndr->depth++;
			if (r->ServerInfoW2K) {
				ndr_print_DNS_RPC_SERVER_INFO_W2K(ndr, "ServerInfoW2K", r->ServerInfoW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_STATS:
			ndr_print_ptr(ndr, "Stats", r->Stats);
			ndr->depth++;
			if (r->Stats) {
				ndr_print_DNSSRV_STAT(ndr, "Stats", r->Stats);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_FORWARDERS_W2K:
			ndr_print_ptr(ndr, "ForwardersW2K", r->ForwardersW2K);
			ndr->depth++;
			if (r->ForwardersW2K) {
				ndr_print_DNS_RPC_FORWARDERS_W2K(ndr, "ForwardersW2K", r->ForwardersW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_W2K:
			ndr_print_ptr(ndr, "ZoneW2K", r->ZoneW2K);
			ndr->depth++;
			if (r->ZoneW2K) {
				ndr_print_DNS_RPC_ZONE_W2K(ndr, "ZoneW2K", r->ZoneW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_INFO_W2K:
			ndr_print_ptr(ndr, "ZoneInfoW2K", r->ZoneInfoW2K);
			ndr->depth++;
			if (r->ZoneInfoW2K) {
				ndr_print_DNS_RPC_ZONE_INFO_W2K(ndr, "ZoneInfoW2K", r->ZoneInfoW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_W2K:
			ndr_print_ptr(ndr, "SecondariesW2K", r->SecondariesW2K);
			ndr->depth++;
			if (r->SecondariesW2K) {
				ndr_print_DNS_RPC_ZONE_SECONDARIES_W2K(ndr, "SecondariesW2K", r->SecondariesW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_DATABASE_W2K:
			ndr_print_ptr(ndr, "DatabaseW2K", r->DatabaseW2K);
			ndr->depth++;
			if (r->DatabaseW2K) {
				ndr_print_DNS_RPC_ZONE_DATABASE_W2K(ndr, "DatabaseW2K", r->DatabaseW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_CREATE_W2K:
			ndr_print_ptr(ndr, "ZoneCreateW2K", r->ZoneCreateW2K);
			ndr->depth++;
			if (r->ZoneCreateW2K) {
				ndr_print_DNS_RPC_ZONE_CREATE_INFO_W2K(ndr, "ZoneCreateW2K", r->ZoneCreateW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_NAME_AND_PARAM:
			ndr_print_ptr(ndr, "NameAndParam", r->NameAndParam);
			ndr->depth++;
			if (r->NameAndParam) {
				ndr_print_DNS_RPC_NAME_AND_PARAM(ndr, "NameAndParam", r->NameAndParam);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_LIST_W2K:
			ndr_print_ptr(ndr, "ZoneListW2K", r->ZoneListW2K);
			ndr->depth++;
			if (r->ZoneListW2K) {
				ndr_print_DNS_RPC_ZONE_LIST_W2K(ndr, "ZoneListW2K", r->ZoneListW2K);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_SERVER_INFO_DOTNET:
			ndr_print_ptr(ndr, "ServerInfoDotNet", r->ServerInfoDotNet);
			ndr->depth++;
			if (r->ServerInfoDotNet) {
				ndr_print_DNS_RPC_SERVER_INFO_DOTNET(ndr, "ServerInfoDotNet", r->ServerInfoDotNet);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_FORWARDERS_DOTNET:
			ndr_print_ptr(ndr, "ForwardersDotNet", r->ForwardersDotNet);
			ndr->depth++;
			if (r->ForwardersDotNet) {
				ndr_print_DNS_RPC_FORWARDERS_DOTNET(ndr, "ForwardersDotNet", r->ForwardersDotNet);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE:
			ndr_print_ptr(ndr, "Zone", r->Zone);
			ndr->depth++;
			if (r->Zone) {
				ndr_print_DNS_RPC_ZONE_DOTNET(ndr, "Zone", r->Zone);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_INFO_DOTNET:
			ndr_print_ptr(ndr, "ZoneInfoDotNet", r->ZoneInfoDotNet);
			ndr->depth++;
			if (r->ZoneInfoDotNet) {
				ndr_print_DNS_RPC_ZONE_INFO_DOTNET(ndr, "ZoneInfoDotNet", r->ZoneInfoDotNet);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES_DOTNET:
			ndr_print_ptr(ndr, "SecondariesDotNet", r->SecondariesDotNet);
			ndr->depth++;
			if (r->SecondariesDotNet) {
				ndr_print_DNS_RPC_ZONE_SECONDARIES_DOTNET(ndr, "SecondariesDotNet", r->SecondariesDotNet);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_DATABASE:
			ndr_print_ptr(ndr, "Database", r->Database);
			ndr->depth++;
			if (r->Database) {
				ndr_print_DNS_RPC_ZONE_DATABASE_DOTNET(ndr, "Database", r->Database);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_CREATE_DOTNET:
			ndr_print_ptr(ndr, "ZoneCreateDotNet", r->ZoneCreateDotNet);
			ndr->depth++;
			if (r->ZoneCreateDotNet) {
				ndr_print_DNS_RPC_ZONE_CREATE_INFO_DOTNET(ndr, "ZoneCreateDotNet", r->ZoneCreateDotNet);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_LIST:
			ndr_print_ptr(ndr, "ZoneList", r->ZoneList);
			ndr->depth++;
			if (r->ZoneList) {
				ndr_print_DNS_RPC_ZONE_LIST_DOTNET(ndr, "ZoneList", r->ZoneList);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_EXPORT:
			ndr_print_ptr(ndr, "ZoneExport", r->ZoneExport);
			ndr->depth++;
			if (r->ZoneExport) {
				ndr_print_DNS_RPC_ZONE_EXPORT_INFO(ndr, "ZoneExport", r->ZoneExport);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_DP_INFO:
			ndr_print_ptr(ndr, "DirectoryPartition", r->DirectoryPartition);
			ndr->depth++;
			if (r->DirectoryPartition) {
				ndr_print_DNS_RPC_DP_INFO(ndr, "DirectoryPartition", r->DirectoryPartition);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_DP_ENUM:
			ndr_print_ptr(ndr, "DirectoryPartitionEnum", r->DirectoryPartitionEnum);
			ndr->depth++;
			if (r->DirectoryPartitionEnum) {
				ndr_print_DNS_RPC_DP_ENUM(ndr, "DirectoryPartitionEnum", r->DirectoryPartitionEnum);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_DP_LIST:
			ndr_print_ptr(ndr, "DirectoryPartitionList", r->DirectoryPartitionList);
			ndr->depth++;
			if (r->DirectoryPartitionList) {
				ndr_print_DNS_RPC_DP_LIST(ndr, "DirectoryPartitionList", r->DirectoryPartitionList);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ENLIST_DP:
			ndr_print_ptr(ndr, "EnlistDirectoryPartition", r->EnlistDirectoryPartition);
			ndr->depth++;
			if (r->EnlistDirectoryPartition) {
				ndr_print_DNS_RPC_ENLIST_DP(ndr, "EnlistDirectoryPartition", r->EnlistDirectoryPartition);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_CHANGE_DP:
			ndr_print_ptr(ndr, "ZoneChangeDirectoryPartition", r->ZoneChangeDirectoryPartition);
			ndr->depth++;
			if (r->ZoneChangeDirectoryPartition) {
				ndr_print_DNS_RPC_ZONE_CHANGE_DP(ndr, "ZoneChangeDirectoryPartition", r->ZoneChangeDirectoryPartition);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ENUM_ZONES_FILTER:
			ndr_print_ptr(ndr, "EnumZonesFilter", r->EnumZonesFilter);
			ndr->depth++;
			if (r->EnumZonesFilter) {
				ndr_print_DNS_RPC_ENUM_ZONES_FILTER(ndr, "EnumZonesFilter", r->EnumZonesFilter);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ADDRARRAY:
			ndr_print_ptr(ndr, "AddrArray", r->AddrArray);
			ndr->depth++;
			if (r->AddrArray) {
				ndr_print_DNS_ADDR_ARRAY(ndr, "AddrArray", r->AddrArray);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_SERVER_INFO:
			ndr_print_ptr(ndr, "ServerInfo", r->ServerInfo);
			ndr->depth++;
			if (r->ServerInfo) {
				ndr_print_DNS_RPC_SERVER_INFO_LONGHORN(ndr, "ServerInfo", r->ServerInfo);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_CREATE:
			ndr_print_ptr(ndr, "ZoneCreate", r->ZoneCreate);
			ndr->depth++;
			if (r->ZoneCreate) {
				ndr_print_DNS_RPC_ZONE_CREATE_INFO_LONGHORN(ndr, "ZoneCreate", r->ZoneCreate);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_FORWARDERS:
			ndr_print_ptr(ndr, "Forwarders", r->Forwarders);
			ndr->depth++;
			if (r->Forwarders) {
				ndr_print_DNS_RPC_FORWARDERS_LONGHORN(ndr, "Forwarders", r->Forwarders);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_SECONDARIES:
			ndr_print_ptr(ndr, "Secondaries", r->Secondaries);
			ndr->depth++;
			if (r->Secondaries) {
				ndr_print_DNS_RPC_ZONE_SECONDARIES_LONGHORN(ndr, "Secondaries", r->Secondaries);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_IP_VALIDATE:
			ndr_print_ptr(ndr, "IpValidate", r->IpValidate);
			ndr->depth++;
			if (r->IpValidate) {
				ndr_print_DNS_RPC_IP_VALIDATE(ndr, "IpValidate", r->IpValidate);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_ZONE_INFO:
			ndr_print_ptr(ndr, "ZoneInfo", r->ZoneInfo);
			ndr->depth++;
			if (r->ZoneInfo) {
				ndr_print_DNS_RPC_ZONE_INFO_LONGHORN(ndr, "ZoneInfo", r->ZoneInfo);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_AUTOCONFIGURE:
			ndr_print_ptr(ndr, "AutoConfigure", r->AutoConfigure);
			ndr->depth++;
			if (r->AutoConfigure) {
				ndr_print_DNS_RPC_AUTOCONFIGURE(ndr, "AutoConfigure", r->AutoConfigure);
			}
			ndr->depth--;
		break;

		case DNSSRV_TYPEID_UTF8_STRING_LIST:
			ndr_print_ptr(ndr, "Utf8StringList", r->Utf8StringList);
			ndr->depth++;
			if (r->Utf8StringList) {
				ndr_print_DNS_RPC_UTF8_STRING_LIST(ndr, "Utf8StringList", r->Utf8StringList);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_DNS_RPC_RECORDS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct DNS_RPC_RECORDS *r)
{
	uint32_t cntr_records_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, (12 + ndr_size_DNS_RPC_NAME(&r->dnsNodeName, 0) + 3) & ~3));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wRecordCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwChildCount));
		NDR_CHECK(ndr_push_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->dnsNodeName));
		for (cntr_records_0 = 0; cntr_records_0 < (r->wRecordCount); cntr_records_0++) {
			NDR_CHECK(ndr_push_DNS_RPC_RECORD(ndr, NDR_SCALARS, &r->records[cntr_records_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DNS_RPC_RECORDS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct DNS_RPC_RECORDS *r)
{
	uint32_t size_records_0 = 0;
	uint32_t cntr_records_0;
	TALLOC_CTX *_mem_save_records_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wLength));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wRecordCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwChildCount));
		NDR_CHECK(ndr_pull_DNS_RPC_NAME(ndr, NDR_SCALARS, &r->dnsNodeName));
		size_records_0 = r->wRecordCount;
		NDR_PULL_ALLOC_N(ndr, r->records, size_records_0);
		_mem_save_records_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->records, 0);
		for (cntr_records_0 = 0; cntr_records_0 < (size_records_0); cntr_records_0++) {
			NDR_CHECK(ndr_pull_DNS_RPC_RECORD(ndr, NDR_SCALARS, &r->records[cntr_records_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_records_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_DNS_RPC_RECORDS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct DNS_RPC_RECORDS *r)
{
	ndr_print_DNS_RPC_RECORDS(ndr, name, r);
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORDS(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORDS *r)
{
	uint32_t cntr_records_0;
	ndr_print_struct(ndr, name, "DNS_RPC_RECORDS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?(12 + ndr_size_DNS_RPC_NAME(&r->dnsNodeName, 0) + 3) & ~3:r->wLength);
	ndr_print_uint16(ndr, "wRecordCount", r->wRecordCount);
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_uint32(ndr, "dwChildCount", r->dwChildCount);
	ndr_print_DNS_RPC_NAME(ndr, "dnsNodeName", &r->dnsNodeName);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "records", (uint32_t)(r->wRecordCount));
	ndr->depth++;
	for (cntr_records_0 = 0; cntr_records_0 < (r->wRecordCount); cntr_records_0++) {
		ndr_print_DNS_RPC_RECORD(ndr, "records", &r->records[cntr_records_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_DNS_RPC_RECORDS(const struct DNS_RPC_RECORDS *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORDS);
}

static void ndr_print_flags_DNS_RPC_RECORDS_ARRAY(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct DNS_RPC_RECORDS_ARRAY *r)
{
	ndr_print_DNS_RPC_RECORDS_ARRAY(ndr, name, r);
}

_PUBLIC_ void ndr_print_DNS_RPC_RECORDS_ARRAY(struct ndr_print *ndr, const char *name, const struct DNS_RPC_RECORDS_ARRAY *r)
{
	uint32_t cntr_rec_0;
	ndr_print_struct(ndr, name, "DNS_RPC_RECORDS_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "rec", (uint32_t)(r->count));
	ndr->depth++;
	for (cntr_rec_0 = 0; cntr_rec_0 < (r->count); cntr_rec_0++) {
		ndr_print_DNS_RPC_RECORDS(ndr, "rec", &r->rec[cntr_rec_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_DNS_RPC_RECORDS_ARRAY(const struct DNS_RPC_RECORDS_ARRAY *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_DNS_RPC_RECORDS_ARRAY);
}

static enum ndr_err_code ndr_push_DnssrvOperation(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvOperation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwContext));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszOperation));
		if (r->in.pszOperation) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszOperation, ndr_charset_length(r->in.pszOperation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->in.dwTypeId));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.pData, r->in.dwTypeId));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pData));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvOperation(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvOperation *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszOperation;
	uint32_t size_pszOperation_1 = 0;
	uint32_t length_pszOperation_1 = 0;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszOperation_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwContext));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszOperation));
		if (_ptr_pszOperation) {
			NDR_PULL_ALLOC(ndr, r->in.pszOperation);
		} else {
			r->in.pszOperation = NULL;
		}
		if (r->in.pszOperation) {
			_mem_save_pszOperation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszOperation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszOperation, &size_pszOperation_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszOperation, &length_pszOperation_1));
			if (length_pszOperation_1 > size_pszOperation_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszOperation_1, length_pszOperation_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszOperation_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszOperation, length_pszOperation_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszOperation_0, 0);
		}
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, &r->in.dwTypeId));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.pData, r->in.dwTypeId));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pData));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvOperation(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvOperation *r)
{
	ndr_print_struct(ndr, name, "DnssrvOperation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvOperation");
		ndr->depth++;
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwContext", r->in.dwContext);
		ndr_print_ptr(ndr, "pszOperation", r->in.pszOperation);
		ndr->depth++;
		if (r->in.pszOperation) {
			ndr_print_string(ndr, "pszOperation", r->in.pszOperation);
		}
		ndr->depth--;
		ndr_print_DNS_RPC_TYPEID(ndr, "dwTypeId", r->in.dwTypeId);
		ndr_print_set_switch_value(ndr, &r->in.pData, r->in.dwTypeId);
		ndr_print_DNSSRV_RPC_UNION(ndr, "pData", &r->in.pData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvOperation");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvQuery(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvQuery *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszOperation));
		if (r->in.pszOperation) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszOperation, ndr_charset_length(r->in.pszOperation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwTypeId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, *r->out.pdwTypeId));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ppData, *r->out.pdwTypeId));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppData));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvQuery(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvQuery *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszOperation;
	uint32_t size_pszOperation_1 = 0;
	uint32_t length_pszOperation_1 = 0;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszOperation_0 = NULL;
	TALLOC_CTX *_mem_save_pdwTypeId_0 = NULL;
	TALLOC_CTX *_mem_save_ppData_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszOperation));
		if (_ptr_pszOperation) {
			NDR_PULL_ALLOC(ndr, r->in.pszOperation);
		} else {
			r->in.pszOperation = NULL;
		}
		if (r->in.pszOperation) {
			_mem_save_pszOperation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszOperation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszOperation, &size_pszOperation_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszOperation, &length_pszOperation_1));
			if (length_pszOperation_1 > size_pszOperation_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszOperation_1, length_pszOperation_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszOperation_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszOperation, length_pszOperation_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszOperation_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.pdwTypeId);
		NDR_ZERO_STRUCTP(r->out.pdwTypeId);
		NDR_PULL_ALLOC(ndr, r->out.ppData);
		NDR_ZERO_STRUCTP(r->out.ppData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwTypeId);
		}
		_mem_save_pdwTypeId_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwTypeId, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->out.pdwTypeId));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwTypeId_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppData);
		}
		_mem_save_ppData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ppData, *r->out.pdwTypeId));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvQuery(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvQuery *r)
{
	ndr_print_struct(ndr, name, "DnssrvQuery");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvQuery");
		ndr->depth++;
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszOperation", r->in.pszOperation);
		ndr->depth++;
		if (r->in.pszOperation) {
			ndr_print_string(ndr, "pszOperation", r->in.pszOperation);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvQuery");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwTypeId", r->out.pdwTypeId);
		ndr->depth++;
		ndr_print_DNS_RPC_TYPEID(ndr, "pdwTypeId", *r->out.pdwTypeId);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppData", r->out.ppData);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ppData, *r->out.pdwTypeId);
		ndr_print_DNSSRV_RPC_UNION(ndr, "ppData", r->out.ppData);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvComplexOperation(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvComplexOperation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszOperation));
		if (r->in.pszOperation) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszOperation, ndr_charset_length(r->in.pszOperation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->in.dwTypeIn));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.pDataIn, r->in.dwTypeIn));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pDataIn));
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwTypeOut == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppDataOut == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, *r->out.pdwTypeOut));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ppDataOut, *r->out.pdwTypeOut));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppDataOut));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvComplexOperation(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvComplexOperation *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszOperation;
	uint32_t size_pszOperation_1 = 0;
	uint32_t length_pszOperation_1 = 0;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszOperation_0 = NULL;
	TALLOC_CTX *_mem_save_pdwTypeOut_0 = NULL;
	TALLOC_CTX *_mem_save_ppDataOut_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszOperation));
		if (_ptr_pszOperation) {
			NDR_PULL_ALLOC(ndr, r->in.pszOperation);
		} else {
			r->in.pszOperation = NULL;
		}
		if (r->in.pszOperation) {
			_mem_save_pszOperation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszOperation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszOperation, &size_pszOperation_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszOperation, &length_pszOperation_1));
			if (length_pszOperation_1 > size_pszOperation_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszOperation_1, length_pszOperation_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszOperation_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszOperation, length_pszOperation_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszOperation_0, 0);
		}
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, &r->in.dwTypeIn));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.pDataIn, r->in.dwTypeIn));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pDataIn));
		NDR_PULL_ALLOC(ndr, r->out.pdwTypeOut);
		NDR_ZERO_STRUCTP(r->out.pdwTypeOut);
		NDR_PULL_ALLOC(ndr, r->out.ppDataOut);
		NDR_ZERO_STRUCTP(r->out.ppDataOut);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwTypeOut);
		}
		_mem_save_pdwTypeOut_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwTypeOut, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->out.pdwTypeOut));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwTypeOut_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppDataOut);
		}
		_mem_save_ppDataOut_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppDataOut, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ppDataOut, *r->out.pdwTypeOut));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppDataOut));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppDataOut_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvComplexOperation(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvComplexOperation *r)
{
	ndr_print_struct(ndr, name, "DnssrvComplexOperation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvComplexOperation");
		ndr->depth++;
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszOperation", r->in.pszOperation);
		ndr->depth++;
		if (r->in.pszOperation) {
			ndr_print_string(ndr, "pszOperation", r->in.pszOperation);
		}
		ndr->depth--;
		ndr_print_DNS_RPC_TYPEID(ndr, "dwTypeIn", r->in.dwTypeIn);
		ndr_print_set_switch_value(ndr, &r->in.pDataIn, r->in.dwTypeIn);
		ndr_print_DNSSRV_RPC_UNION(ndr, "pDataIn", &r->in.pDataIn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvComplexOperation");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwTypeOut", r->out.pdwTypeOut);
		ndr->depth++;
		ndr_print_DNS_RPC_TYPEID(ndr, "pdwTypeOut", *r->out.pdwTypeOut);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppDataOut", r->out.ppDataOut);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ppDataOut, *r->out.pdwTypeOut);
		ndr_print_DNSSRV_RPC_UNION(ndr, "ppDataOut", r->out.ppDataOut);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvEnumRecords(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvEnumRecords *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszNodeName));
		if (r->in.pszNodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszNodeName, ndr_charset_length(r->in.pszNodeName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszStartChild));
		if (r->in.pszStartChild) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszStartChild, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszStartChild, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszStartChild, ndr_charset_length(r->in.pszStartChild, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_dns_record_type(ndr, NDR_SCALARS, r->in.wRecordType));
		NDR_CHECK(ndr_push_DNS_SELECT_FLAGS(ndr, NDR_SCALARS, r->in.fSelectFlag));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszFilterStart));
		if (r->in.pszFilterStart) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStart, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStart, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszFilterStart, ndr_charset_length(r->in.pszFilterStart, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszFilterStop));
		if (r->in.pszFilterStop) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStop, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStop, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszFilterStop, ndr_charset_length(r->in.pszFilterStop, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwBufferLength == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pdwBufferLength));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pBuffer));
		if (*r->out.pBuffer) {
			{
				struct ndr_push *_ndr_pBuffer;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_pBuffer, 4, *r->out.pdwBufferLength));
				NDR_CHECK(ndr_push_DNS_RPC_RECORDS_ARRAY(_ndr_pBuffer, NDR_SCALARS, *r->out.pBuffer));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_pBuffer, 4, *r->out.pdwBufferLength));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvEnumRecords(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvEnumRecords *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszNodeName;
	uint32_t size_pszNodeName_1 = 0;
	uint32_t length_pszNodeName_1 = 0;
	uint32_t _ptr_pszStartChild;
	uint32_t size_pszStartChild_1 = 0;
	uint32_t length_pszStartChild_1 = 0;
	uint32_t _ptr_pszFilterStart;
	uint32_t size_pszFilterStart_1 = 0;
	uint32_t length_pszFilterStart_1 = 0;
	uint32_t _ptr_pszFilterStop;
	uint32_t size_pszFilterStop_1 = 0;
	uint32_t length_pszFilterStop_1 = 0;
	uint32_t _ptr_pBuffer;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszNodeName_0 = NULL;
	TALLOC_CTX *_mem_save_pszStartChild_0 = NULL;
	TALLOC_CTX *_mem_save_pszFilterStart_0 = NULL;
	TALLOC_CTX *_mem_save_pszFilterStop_0 = NULL;
	TALLOC_CTX *_mem_save_pdwBufferLength_0 = NULL;
	TALLOC_CTX *_mem_save_pBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_pBuffer_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszNodeName));
		if (_ptr_pszNodeName) {
			NDR_PULL_ALLOC(ndr, r->in.pszNodeName);
		} else {
			r->in.pszNodeName = NULL;
		}
		if (r->in.pszNodeName) {
			_mem_save_pszNodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszNodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszNodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszNodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszNodeName, &size_pszNodeName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszNodeName, &length_pszNodeName_1));
			if (length_pszNodeName_1 > size_pszNodeName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNodeName_1, length_pszNodeName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNodeName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszNodeName, length_pszNodeName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszNodeName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszStartChild));
		if (_ptr_pszStartChild) {
			NDR_PULL_ALLOC(ndr, r->in.pszStartChild);
		} else {
			r->in.pszStartChild = NULL;
		}
		if (r->in.pszStartChild) {
			_mem_save_pszStartChild_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszStartChild, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszStartChild));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszStartChild));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszStartChild, &size_pszStartChild_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszStartChild, &length_pszStartChild_1));
			if (length_pszStartChild_1 > size_pszStartChild_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszStartChild_1, length_pszStartChild_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszStartChild_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszStartChild, length_pszStartChild_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszStartChild_0, 0);
		}
		NDR_CHECK(ndr_pull_dns_record_type(ndr, NDR_SCALARS, &r->in.wRecordType));
		NDR_CHECK(ndr_pull_DNS_SELECT_FLAGS(ndr, NDR_SCALARS, &r->in.fSelectFlag));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszFilterStart));
		if (_ptr_pszFilterStart) {
			NDR_PULL_ALLOC(ndr, r->in.pszFilterStart);
		} else {
			r->in.pszFilterStart = NULL;
		}
		if (r->in.pszFilterStart) {
			_mem_save_pszFilterStart_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszFilterStart, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszFilterStart));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszFilterStart));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszFilterStart, &size_pszFilterStart_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszFilterStart, &length_pszFilterStart_1));
			if (length_pszFilterStart_1 > size_pszFilterStart_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszFilterStart_1, length_pszFilterStart_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszFilterStart_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszFilterStart, length_pszFilterStart_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszFilterStart_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszFilterStop));
		if (_ptr_pszFilterStop) {
			NDR_PULL_ALLOC(ndr, r->in.pszFilterStop);
		} else {
			r->in.pszFilterStop = NULL;
		}
		if (r->in.pszFilterStop) {
			_mem_save_pszFilterStop_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszFilterStop, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszFilterStop));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszFilterStop));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszFilterStop, &size_pszFilterStop_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszFilterStop, &length_pszFilterStop_1));
			if (length_pszFilterStop_1 > size_pszFilterStop_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszFilterStop_1, length_pszFilterStop_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszFilterStop_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszFilterStop, length_pszFilterStop_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszFilterStop_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.pdwBufferLength);
		NDR_ZERO_STRUCTP(r->out.pdwBufferLength);
		NDR_PULL_ALLOC(ndr, r->out.pBuffer);
		NDR_ZERO_STRUCTP(r->out.pBuffer);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwBufferLength);
		}
		_mem_save_pdwBufferLength_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwBufferLength, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pdwBufferLength));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwBufferLength_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pBuffer);
		}
		_mem_save_pBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pBuffer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pBuffer));
		if (_ptr_pBuffer) {
			NDR_PULL_ALLOC(ndr, *r->out.pBuffer);
		} else {
			*r->out.pBuffer = NULL;
		}
		if (*r->out.pBuffer) {
			_mem_save_pBuffer_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pBuffer, 0);
			{
				struct ndr_pull *_ndr_pBuffer;
				ssize_t sub_size = *r->out.pdwBufferLength;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_pBuffer, 4, sub_size));
				NDR_CHECK(ndr_pull_DNS_RPC_RECORDS_ARRAY(_ndr_pBuffer, NDR_SCALARS, *r->out.pBuffer));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_pBuffer, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBuffer_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBuffer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvEnumRecords(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvEnumRecords *r)
{
	ndr_print_struct(ndr, name, "DnssrvEnumRecords");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvEnumRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszNodeName", r->in.pszNodeName);
		ndr->depth++;
		if (r->in.pszNodeName) {
			ndr_print_string(ndr, "pszNodeName", r->in.pszNodeName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszStartChild", r->in.pszStartChild);
		ndr->depth++;
		if (r->in.pszStartChild) {
			ndr_print_string(ndr, "pszStartChild", r->in.pszStartChild);
		}
		ndr->depth--;
		ndr_print_dns_record_type(ndr, "wRecordType", r->in.wRecordType);
		ndr_print_DNS_SELECT_FLAGS(ndr, "fSelectFlag", r->in.fSelectFlag);
		ndr_print_ptr(ndr, "pszFilterStart", r->in.pszFilterStart);
		ndr->depth++;
		if (r->in.pszFilterStart) {
			ndr_print_string(ndr, "pszFilterStart", r->in.pszFilterStart);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszFilterStop", r->in.pszFilterStop);
		ndr->depth++;
		if (r->in.pszFilterStop) {
			ndr_print_string(ndr, "pszFilterStop", r->in.pszFilterStop);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvEnumRecords");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwBufferLength", r->out.pdwBufferLength);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwBufferLength", *r->out.pdwBufferLength);
		ndr->depth--;
		ndr_print_ptr(ndr, "pBuffer", r->out.pBuffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "pBuffer", *r->out.pBuffer);
		ndr->depth++;
		if (*r->out.pBuffer) {
			ndr_print_DNS_RPC_RECORDS_ARRAY(ndr, "pBuffer", *r->out.pBuffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvUpdateRecord(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvUpdateRecord *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszNodeName));
		if (r->in.pszNodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszNodeName, ndr_charset_length(r->in.pszNodeName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pAddRecord));
		if (r->in.pAddRecord) {
			NDR_CHECK(ndr_push_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pAddRecord));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDeleteRecord));
		if (r->in.pDeleteRecord) {
			NDR_CHECK(ndr_push_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pDeleteRecord));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvUpdateRecord(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvUpdateRecord *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszNodeName;
	uint32_t size_pszNodeName_1 = 0;
	uint32_t length_pszNodeName_1 = 0;
	uint32_t _ptr_pAddRecord;
	uint32_t _ptr_pDeleteRecord;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszNodeName_0 = NULL;
	TALLOC_CTX *_mem_save_pAddRecord_0 = NULL;
	TALLOC_CTX *_mem_save_pDeleteRecord_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszNodeName));
		if (_ptr_pszNodeName) {
			NDR_PULL_ALLOC(ndr, r->in.pszNodeName);
		} else {
			r->in.pszNodeName = NULL;
		}
		if (r->in.pszNodeName) {
			_mem_save_pszNodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszNodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszNodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszNodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszNodeName, &size_pszNodeName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszNodeName, &length_pszNodeName_1));
			if (length_pszNodeName_1 > size_pszNodeName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNodeName_1, length_pszNodeName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNodeName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszNodeName, length_pszNodeName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszNodeName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pAddRecord));
		if (_ptr_pAddRecord) {
			NDR_PULL_ALLOC(ndr, r->in.pAddRecord);
		} else {
			r->in.pAddRecord = NULL;
		}
		if (r->in.pAddRecord) {
			_mem_save_pAddRecord_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pAddRecord, 0);
			NDR_CHECK(ndr_pull_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pAddRecord));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pAddRecord_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDeleteRecord));
		if (_ptr_pDeleteRecord) {
			NDR_PULL_ALLOC(ndr, r->in.pDeleteRecord);
		} else {
			r->in.pDeleteRecord = NULL;
		}
		if (r->in.pDeleteRecord) {
			_mem_save_pDeleteRecord_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDeleteRecord, 0);
			NDR_CHECK(ndr_pull_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pDeleteRecord));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDeleteRecord_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvUpdateRecord(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvUpdateRecord *r)
{
	ndr_print_struct(ndr, name, "DnssrvUpdateRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvUpdateRecord");
		ndr->depth++;
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszNodeName", r->in.pszNodeName);
		ndr->depth++;
		if (r->in.pszNodeName) {
			ndr_print_string(ndr, "pszNodeName", r->in.pszNodeName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pAddRecord", r->in.pAddRecord);
		ndr->depth++;
		if (r->in.pAddRecord) {
			ndr_print_DNS_RPC_RECORD_BUF(ndr, "pAddRecord", r->in.pAddRecord);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pDeleteRecord", r->in.pDeleteRecord);
		ndr->depth++;
		if (r->in.pDeleteRecord) {
			ndr_print_DNS_RPC_RECORD_BUF(ndr, "pDeleteRecord", r->in.pDeleteRecord);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvUpdateRecord");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvOperation2(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvOperation2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, r->in.dwClientVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwSettingFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwContext));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszOperation));
		if (r->in.pszOperation) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszOperation, ndr_charset_length(r->in.pszOperation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->in.dwTypeId));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.pData, r->in.dwTypeId));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pData));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvOperation2(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvOperation2 *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszOperation;
	uint32_t size_pszOperation_1 = 0;
	uint32_t length_pszOperation_1 = 0;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszOperation_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, &r->in.dwClientVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwSettingFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwContext));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszOperation));
		if (_ptr_pszOperation) {
			NDR_PULL_ALLOC(ndr, r->in.pszOperation);
		} else {
			r->in.pszOperation = NULL;
		}
		if (r->in.pszOperation) {
			_mem_save_pszOperation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszOperation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszOperation, &size_pszOperation_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszOperation, &length_pszOperation_1));
			if (length_pszOperation_1 > size_pszOperation_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszOperation_1, length_pszOperation_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszOperation_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszOperation, length_pszOperation_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszOperation_0, 0);
		}
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, &r->in.dwTypeId));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.pData, r->in.dwTypeId));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pData));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvOperation2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvOperation2 *r)
{
	ndr_print_struct(ndr, name, "DnssrvOperation2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvOperation2");
		ndr->depth++;
		ndr_print_DNS_RPC_CLIENT_VERSION(ndr, "dwClientVersion", r->in.dwClientVersion);
		ndr_print_uint32(ndr, "dwSettingFlags", r->in.dwSettingFlags);
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwContext", r->in.dwContext);
		ndr_print_ptr(ndr, "pszOperation", r->in.pszOperation);
		ndr->depth++;
		if (r->in.pszOperation) {
			ndr_print_string(ndr, "pszOperation", r->in.pszOperation);
		}
		ndr->depth--;
		ndr_print_DNS_RPC_TYPEID(ndr, "dwTypeId", r->in.dwTypeId);
		ndr_print_set_switch_value(ndr, &r->in.pData, r->in.dwTypeId);
		ndr_print_DNSSRV_RPC_UNION(ndr, "pData", &r->in.pData);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvOperation2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvQuery2(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvQuery2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, r->in.dwClientVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwSettingFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszOperation));
		if (r->in.pszOperation) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszOperation, ndr_charset_length(r->in.pszOperation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwTypeId == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppData == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, *r->out.pdwTypeId));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ppData, *r->out.pdwTypeId));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppData));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvQuery2(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvQuery2 *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszOperation;
	uint32_t size_pszOperation_1 = 0;
	uint32_t length_pszOperation_1 = 0;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszOperation_0 = NULL;
	TALLOC_CTX *_mem_save_pdwTypeId_0 = NULL;
	TALLOC_CTX *_mem_save_ppData_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, &r->in.dwClientVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwSettingFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszOperation));
		if (_ptr_pszOperation) {
			NDR_PULL_ALLOC(ndr, r->in.pszOperation);
		} else {
			r->in.pszOperation = NULL;
		}
		if (r->in.pszOperation) {
			_mem_save_pszOperation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszOperation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszOperation, &size_pszOperation_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszOperation, &length_pszOperation_1));
			if (length_pszOperation_1 > size_pszOperation_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszOperation_1, length_pszOperation_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszOperation_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszOperation, length_pszOperation_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszOperation_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.pdwTypeId);
		NDR_ZERO_STRUCTP(r->out.pdwTypeId);
		NDR_PULL_ALLOC(ndr, r->out.ppData);
		NDR_ZERO_STRUCTP(r->out.ppData);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwTypeId);
		}
		_mem_save_pdwTypeId_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwTypeId, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->out.pdwTypeId));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwTypeId_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppData);
		}
		_mem_save_ppData_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppData, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ppData, *r->out.pdwTypeId));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppData));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppData_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvQuery2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvQuery2 *r)
{
	ndr_print_struct(ndr, name, "DnssrvQuery2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvQuery2");
		ndr->depth++;
		ndr_print_DNS_RPC_CLIENT_VERSION(ndr, "dwClientVersion", r->in.dwClientVersion);
		ndr_print_uint32(ndr, "dwSettingFlags", r->in.dwSettingFlags);
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszOperation", r->in.pszOperation);
		ndr->depth++;
		if (r->in.pszOperation) {
			ndr_print_string(ndr, "pszOperation", r->in.pszOperation);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvQuery2");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwTypeId", r->out.pdwTypeId);
		ndr->depth++;
		ndr_print_DNS_RPC_TYPEID(ndr, "pdwTypeId", *r->out.pdwTypeId);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppData", r->out.ppData);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ppData, *r->out.pdwTypeId);
		ndr_print_DNSSRV_RPC_UNION(ndr, "ppData", r->out.ppData);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvComplexOperation2(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvComplexOperation2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, r->in.dwClientVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwSettingFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszOperation));
		if (r->in.pszOperation) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszOperation, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszOperation, ndr_charset_length(r->in.pszOperation, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->in.dwTypeIn));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->in.pDataIn, r->in.dwTypeIn));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pDataIn));
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwTypeOut == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.ppDataOut == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DNS_RPC_TYPEID(ndr, NDR_SCALARS, *r->out.pdwTypeOut));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.ppDataOut, *r->out.pdwTypeOut));
		NDR_CHECK(ndr_push_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppDataOut));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvComplexOperation2(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvComplexOperation2 *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszOperation;
	uint32_t size_pszOperation_1 = 0;
	uint32_t length_pszOperation_1 = 0;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszOperation_0 = NULL;
	TALLOC_CTX *_mem_save_pdwTypeOut_0 = NULL;
	TALLOC_CTX *_mem_save_ppDataOut_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, &r->in.dwClientVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwSettingFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszOperation));
		if (_ptr_pszOperation) {
			NDR_PULL_ALLOC(ndr, r->in.pszOperation);
		} else {
			r->in.pszOperation = NULL;
		}
		if (r->in.pszOperation) {
			_mem_save_pszOperation_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszOperation, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszOperation));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszOperation, &size_pszOperation_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszOperation, &length_pszOperation_1));
			if (length_pszOperation_1 > size_pszOperation_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszOperation_1, length_pszOperation_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszOperation_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszOperation, length_pszOperation_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszOperation_0, 0);
		}
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, &r->in.dwTypeIn));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->in.pDataIn, r->in.dwTypeIn));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.pDataIn));
		NDR_PULL_ALLOC(ndr, r->out.pdwTypeOut);
		NDR_ZERO_STRUCTP(r->out.pdwTypeOut);
		NDR_PULL_ALLOC(ndr, r->out.ppDataOut);
		NDR_ZERO_STRUCTP(r->out.ppDataOut);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwTypeOut);
		}
		_mem_save_pdwTypeOut_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwTypeOut, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DNS_RPC_TYPEID(ndr, NDR_SCALARS, r->out.pdwTypeOut));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwTypeOut_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppDataOut);
		}
		_mem_save_ppDataOut_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppDataOut, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.ppDataOut, *r->out.pdwTypeOut));
		NDR_CHECK(ndr_pull_DNSSRV_RPC_UNION(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppDataOut));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppDataOut_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvComplexOperation2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvComplexOperation2 *r)
{
	ndr_print_struct(ndr, name, "DnssrvComplexOperation2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvComplexOperation2");
		ndr->depth++;
		ndr_print_DNS_RPC_CLIENT_VERSION(ndr, "dwClientVersion", r->in.dwClientVersion);
		ndr_print_uint32(ndr, "dwSettingFlags", r->in.dwSettingFlags);
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszOperation", r->in.pszOperation);
		ndr->depth++;
		if (r->in.pszOperation) {
			ndr_print_string(ndr, "pszOperation", r->in.pszOperation);
		}
		ndr->depth--;
		ndr_print_DNS_RPC_TYPEID(ndr, "dwTypeIn", r->in.dwTypeIn);
		ndr_print_set_switch_value(ndr, &r->in.pDataIn, r->in.dwTypeIn);
		ndr_print_DNSSRV_RPC_UNION(ndr, "pDataIn", &r->in.pDataIn);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvComplexOperation2");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwTypeOut", r->out.pdwTypeOut);
		ndr->depth++;
		ndr_print_DNS_RPC_TYPEID(ndr, "pdwTypeOut", *r->out.pdwTypeOut);
		ndr->depth--;
		ndr_print_ptr(ndr, "ppDataOut", r->out.ppDataOut);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.ppDataOut, *r->out.pdwTypeOut);
		ndr_print_DNSSRV_RPC_UNION(ndr, "ppDataOut", r->out.ppDataOut);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvEnumRecords2(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvEnumRecords2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, r->in.dwClientVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwSettingFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszNodeName));
		if (r->in.pszNodeName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszNodeName, ndr_charset_length(r->in.pszNodeName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszStartChild));
		if (r->in.pszStartChild) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszStartChild, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszStartChild, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszStartChild, ndr_charset_length(r->in.pszStartChild, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_dns_record_type(ndr, NDR_SCALARS, r->in.wRecordType));
		NDR_CHECK(ndr_push_DNS_SELECT_FLAGS(ndr, NDR_SCALARS, r->in.fSelectFlag));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszFilterStart));
		if (r->in.pszFilterStart) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStart, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStart, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszFilterStart, ndr_charset_length(r->in.pszFilterStart, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszFilterStop));
		if (r->in.pszFilterStop) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStop, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszFilterStop, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszFilterStop, ndr_charset_length(r->in.pszFilterStop, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.pdwBufferLength == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pBuffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pdwBufferLength));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.pBuffer));
		if (*r->out.pBuffer) {
			{
				struct ndr_push *_ndr_pBuffer;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_pBuffer, 4, *r->out.pdwBufferLength));
				NDR_CHECK(ndr_push_DNS_RPC_RECORDS_ARRAY(_ndr_pBuffer, NDR_SCALARS, *r->out.pBuffer));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_pBuffer, 4, *r->out.pdwBufferLength));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvEnumRecords2(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvEnumRecords2 *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t _ptr_pszNodeName;
	uint32_t size_pszNodeName_1 = 0;
	uint32_t length_pszNodeName_1 = 0;
	uint32_t _ptr_pszStartChild;
	uint32_t size_pszStartChild_1 = 0;
	uint32_t length_pszStartChild_1 = 0;
	uint32_t _ptr_pszFilterStart;
	uint32_t size_pszFilterStart_1 = 0;
	uint32_t length_pszFilterStart_1 = 0;
	uint32_t _ptr_pszFilterStop;
	uint32_t size_pszFilterStop_1 = 0;
	uint32_t length_pszFilterStop_1 = 0;
	uint32_t _ptr_pBuffer;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pszNodeName_0 = NULL;
	TALLOC_CTX *_mem_save_pszStartChild_0 = NULL;
	TALLOC_CTX *_mem_save_pszFilterStart_0 = NULL;
	TALLOC_CTX *_mem_save_pszFilterStop_0 = NULL;
	TALLOC_CTX *_mem_save_pdwBufferLength_0 = NULL;
	TALLOC_CTX *_mem_save_pBuffer_0 = NULL;
	TALLOC_CTX *_mem_save_pBuffer_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, &r->in.dwClientVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwSettingFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszNodeName));
		if (_ptr_pszNodeName) {
			NDR_PULL_ALLOC(ndr, r->in.pszNodeName);
		} else {
			r->in.pszNodeName = NULL;
		}
		if (r->in.pszNodeName) {
			_mem_save_pszNodeName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszNodeName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszNodeName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszNodeName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszNodeName, &size_pszNodeName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszNodeName, &length_pszNodeName_1));
			if (length_pszNodeName_1 > size_pszNodeName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNodeName_1, length_pszNodeName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNodeName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszNodeName, length_pszNodeName_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszNodeName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszStartChild));
		if (_ptr_pszStartChild) {
			NDR_PULL_ALLOC(ndr, r->in.pszStartChild);
		} else {
			r->in.pszStartChild = NULL;
		}
		if (r->in.pszStartChild) {
			_mem_save_pszStartChild_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszStartChild, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszStartChild));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszStartChild));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszStartChild, &size_pszStartChild_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszStartChild, &length_pszStartChild_1));
			if (length_pszStartChild_1 > size_pszStartChild_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszStartChild_1, length_pszStartChild_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszStartChild_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszStartChild, length_pszStartChild_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszStartChild_0, 0);
		}
		NDR_CHECK(ndr_pull_dns_record_type(ndr, NDR_SCALARS, &r->in.wRecordType));
		NDR_CHECK(ndr_pull_DNS_SELECT_FLAGS(ndr, NDR_SCALARS, &r->in.fSelectFlag));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszFilterStart));
		if (_ptr_pszFilterStart) {
			NDR_PULL_ALLOC(ndr, r->in.pszFilterStart);
		} else {
			r->in.pszFilterStart = NULL;
		}
		if (r->in.pszFilterStart) {
			_mem_save_pszFilterStart_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszFilterStart, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszFilterStart));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszFilterStart));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszFilterStart, &size_pszFilterStart_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszFilterStart, &length_pszFilterStart_1));
			if (length_pszFilterStart_1 > size_pszFilterStart_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszFilterStart_1, length_pszFilterStart_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszFilterStart_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszFilterStart, length_pszFilterStart_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszFilterStart_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszFilterStop));
		if (_ptr_pszFilterStop) {
			NDR_PULL_ALLOC(ndr, r->in.pszFilterStop);
		} else {
			r->in.pszFilterStop = NULL;
		}
		if (r->in.pszFilterStop) {
			_mem_save_pszFilterStop_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszFilterStop, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszFilterStop));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszFilterStop));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszFilterStop, &size_pszFilterStop_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszFilterStop, &length_pszFilterStop_1));
			if (length_pszFilterStop_1 > size_pszFilterStop_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszFilterStop_1, length_pszFilterStop_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszFilterStop_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszFilterStop, length_pszFilterStop_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszFilterStop_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.pdwBufferLength);
		NDR_ZERO_STRUCTP(r->out.pdwBufferLength);
		NDR_PULL_ALLOC(ndr, r->out.pBuffer);
		NDR_ZERO_STRUCTP(r->out.pBuffer);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdwBufferLength);
		}
		_mem_save_pdwBufferLength_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdwBufferLength, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pdwBufferLength));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdwBufferLength_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pBuffer);
		}
		_mem_save_pBuffer_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pBuffer, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pBuffer));
		if (_ptr_pBuffer) {
			NDR_PULL_ALLOC(ndr, *r->out.pBuffer);
		} else {
			*r->out.pBuffer = NULL;
		}
		if (*r->out.pBuffer) {
			_mem_save_pBuffer_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.pBuffer, 0);
			{
				struct ndr_pull *_ndr_pBuffer;
				ssize_t sub_size = *r->out.pdwBufferLength;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_pBuffer, 4, sub_size));
				NDR_CHECK(ndr_pull_DNS_RPC_RECORDS_ARRAY(_ndr_pBuffer, NDR_SCALARS, *r->out.pBuffer));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_pBuffer, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBuffer_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBuffer_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvEnumRecords2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvEnumRecords2 *r)
{
	ndr_print_struct(ndr, name, "DnssrvEnumRecords2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvEnumRecords2");
		ndr->depth++;
		ndr_print_DNS_RPC_CLIENT_VERSION(ndr, "dwClientVersion", r->in.dwClientVersion);
		ndr_print_uint32(ndr, "dwSettingFlags", r->in.dwSettingFlags);
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszNodeName", r->in.pszNodeName);
		ndr->depth++;
		if (r->in.pszNodeName) {
			ndr_print_string(ndr, "pszNodeName", r->in.pszNodeName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszStartChild", r->in.pszStartChild);
		ndr->depth++;
		if (r->in.pszStartChild) {
			ndr_print_string(ndr, "pszStartChild", r->in.pszStartChild);
		}
		ndr->depth--;
		ndr_print_dns_record_type(ndr, "wRecordType", r->in.wRecordType);
		ndr_print_DNS_SELECT_FLAGS(ndr, "fSelectFlag", r->in.fSelectFlag);
		ndr_print_ptr(ndr, "pszFilterStart", r->in.pszFilterStart);
		ndr->depth++;
		if (r->in.pszFilterStart) {
			ndr_print_string(ndr, "pszFilterStart", r->in.pszFilterStart);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszFilterStop", r->in.pszFilterStop);
		ndr->depth++;
		if (r->in.pszFilterStop) {
			ndr_print_string(ndr, "pszFilterStop", r->in.pszFilterStop);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvEnumRecords2");
		ndr->depth++;
		ndr_print_ptr(ndr, "pdwBufferLength", r->out.pdwBufferLength);
		ndr->depth++;
		ndr_print_uint32(ndr, "pdwBufferLength", *r->out.pdwBufferLength);
		ndr->depth--;
		ndr_print_ptr(ndr, "pBuffer", r->out.pBuffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "pBuffer", *r->out.pBuffer);
		ndr->depth++;
		if (*r->out.pBuffer) {
			ndr_print_DNS_RPC_RECORDS_ARRAY(ndr, "pBuffer", *r->out.pBuffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DnssrvUpdateRecord2(struct ndr_push *ndr, ndr_flags_type flags, const struct DnssrvUpdateRecord2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pszNodeName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, r->in.dwClientVersion));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwSettingFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pwszServerName));
		if (r->in.pwszServerName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszServerName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszServerName, ndr_charset_length(r->in.pwszServerName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pszZone));
		if (r->in.pszZone) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszZone, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszZone, ndr_charset_length(r->in.pszZone, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pszNodeName, CH_UTF8)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pszNodeName, ndr_charset_length(r->in.pszNodeName, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pAddRecord));
		if (r->in.pAddRecord) {
			NDR_CHECK(ndr_push_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pAddRecord));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.pDeleteRecord));
		if (r->in.pDeleteRecord) {
			NDR_CHECK(ndr_push_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pDeleteRecord));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DnssrvUpdateRecord2(struct ndr_pull *ndr, ndr_flags_type flags, struct DnssrvUpdateRecord2 *r)
{
	uint32_t _ptr_pwszServerName;
	uint32_t size_pwszServerName_1 = 0;
	uint32_t length_pwszServerName_1 = 0;
	uint32_t _ptr_pszZone;
	uint32_t size_pszZone_1 = 0;
	uint32_t length_pszZone_1 = 0;
	uint32_t size_pszNodeName_1 = 0;
	uint32_t length_pszNodeName_1 = 0;
	uint32_t _ptr_pAddRecord;
	uint32_t _ptr_pDeleteRecord;
	TALLOC_CTX *_mem_save_pwszServerName_0 = NULL;
	TALLOC_CTX *_mem_save_pszZone_0 = NULL;
	TALLOC_CTX *_mem_save_pAddRecord_0 = NULL;
	TALLOC_CTX *_mem_save_pDeleteRecord_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_DNS_RPC_CLIENT_VERSION(ndr, NDR_SCALARS, &r->in.dwClientVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwSettingFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pwszServerName));
		if (_ptr_pwszServerName) {
			NDR_PULL_ALLOC(ndr, r->in.pwszServerName);
		} else {
			r->in.pwszServerName = NULL;
		}
		if (r->in.pwszServerName) {
			_mem_save_pwszServerName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pwszServerName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszServerName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pwszServerName, &size_pwszServerName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pwszServerName, &length_pwszServerName_1));
			if (length_pwszServerName_1 > size_pwszServerName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pwszServerName_1, length_pwszServerName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pwszServerName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszServerName, length_pwszServerName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pwszServerName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszZone));
		if (_ptr_pszZone) {
			NDR_PULL_ALLOC(ndr, r->in.pszZone);
		} else {
			r->in.pszZone = NULL;
		}
		if (r->in.pszZone) {
			_mem_save_pszZone_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pszZone, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszZone));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszZone, &size_pszZone_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszZone, &length_pszZone_1));
			if (length_pszZone_1 > size_pszZone_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszZone_1, length_pszZone_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszZone_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszZone, length_pszZone_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszZone_0, 0);
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pszNodeName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pszNodeName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.pszNodeName, &size_pszNodeName_1));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.pszNodeName, &length_pszNodeName_1));
		if (length_pszNodeName_1 > size_pszNodeName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszNodeName_1, length_pszNodeName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_pszNodeName_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pszNodeName, length_pszNodeName_1, sizeof(uint8_t), CH_UTF8));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pAddRecord));
		if (_ptr_pAddRecord) {
			NDR_PULL_ALLOC(ndr, r->in.pAddRecord);
		} else {
			r->in.pAddRecord = NULL;
		}
		if (r->in.pAddRecord) {
			_mem_save_pAddRecord_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pAddRecord, 0);
			NDR_CHECK(ndr_pull_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pAddRecord));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pAddRecord_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDeleteRecord));
		if (_ptr_pDeleteRecord) {
			NDR_PULL_ALLOC(ndr, r->in.pDeleteRecord);
		} else {
			r->in.pDeleteRecord = NULL;
		}
		if (r->in.pDeleteRecord) {
			_mem_save_pDeleteRecord_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.pDeleteRecord, 0);
			NDR_CHECK(ndr_pull_DNS_RPC_RECORD_BUF(ndr, NDR_SCALARS, r->in.pDeleteRecord));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDeleteRecord_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DnssrvUpdateRecord2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct DnssrvUpdateRecord2 *r)
{
	ndr_print_struct(ndr, name, "DnssrvUpdateRecord2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DnssrvUpdateRecord2");
		ndr->depth++;
		ndr_print_DNS_RPC_CLIENT_VERSION(ndr, "dwClientVersion", r->in.dwClientVersion);
		ndr_print_uint32(ndr, "dwSettingFlags", r->in.dwSettingFlags);
		ndr_print_ptr(ndr, "pwszServerName", r->in.pwszServerName);
		ndr->depth++;
		if (r->in.pwszServerName) {
			ndr_print_string(ndr, "pwszServerName", r->in.pwszServerName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszZone", r->in.pszZone);
		ndr->depth++;
		if (r->in.pszZone) {
			ndr_print_string(ndr, "pszZone", r->in.pszZone);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pszNodeName", r->in.pszNodeName);
		ndr->depth++;
		ndr_print_string(ndr, "pszNodeName", r->in.pszNodeName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pAddRecord", r->in.pAddRecord);
		ndr->depth++;
		if (r->in.pAddRecord) {
			ndr_print_DNS_RPC_RECORD_BUF(ndr, "pAddRecord", r->in.pAddRecord);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "pDeleteRecord", r->in.pDeleteRecord);
		ndr->depth++;
		if (r->in.pDeleteRecord) {
			ndr_print_DNS_RPC_RECORD_BUF(ndr, "pDeleteRecord", r->in.pDeleteRecord);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DnssrvUpdateRecord2");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_dnsserver
static const struct ndr_interface_public_struct dnsserver_public_structs[] = {
	{
		.name = "DNS_RPC_NAME",
		.struct_size = sizeof(struct DNS_RPC_NAME ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_DNS_RPC_NAME,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_DNS_RPC_NAME,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_DNS_RPC_NAME,
	},
	{
		.name = "DNS_RPC_RECORD",
		.struct_size = sizeof(struct DNS_RPC_RECORD ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_DNS_RPC_RECORD,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_DNS_RPC_RECORD,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_DNS_RPC_RECORD,
	},
	{
		.name = "DNS_RPC_SERVER_INFO_DOTNET",
		.struct_size = sizeof(struct DNS_RPC_SERVER_INFO_DOTNET ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_DNS_RPC_SERVER_INFO_DOTNET,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_DNS_RPC_SERVER_INFO_DOTNET,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_DNS_RPC_SERVER_INFO_DOTNET,
	},
	{
		.name = "DNS_RPC_SERVER_INFO_LONGHORN",
		.struct_size = sizeof(struct DNS_RPC_SERVER_INFO_LONGHORN ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_DNS_RPC_SERVER_INFO_LONGHORN,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_DNS_RPC_SERVER_INFO_LONGHORN,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_DNS_RPC_SERVER_INFO_LONGHORN,
	},
	{
		.name = "DNS_RPC_RECORDS",
		.struct_size = sizeof(struct DNS_RPC_RECORDS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_DNS_RPC_RECORDS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_DNS_RPC_RECORDS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_DNS_RPC_RECORDS,
	},
	{
		.name = "DNS_RPC_RECORDS_ARRAY",
		.struct_size = sizeof(struct DNS_RPC_RECORDS_ARRAY ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_DNS_RPC_RECORDS_ARRAY,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_DNS_RPC_RECORDS_ARRAY,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_DNS_RPC_RECORDS_ARRAY,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call dnsserver_calls[] = {
	{
		"DnssrvOperation",
		sizeof(struct DnssrvOperation),
		(ndr_push_flags_fn_t) ndr_push_DnssrvOperation,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvOperation,
		(ndr_print_function_t) ndr_print_DnssrvOperation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvQuery",
		sizeof(struct DnssrvQuery),
		(ndr_push_flags_fn_t) ndr_push_DnssrvQuery,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvQuery,
		(ndr_print_function_t) ndr_print_DnssrvQuery,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvComplexOperation",
		sizeof(struct DnssrvComplexOperation),
		(ndr_push_flags_fn_t) ndr_push_DnssrvComplexOperation,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvComplexOperation,
		(ndr_print_function_t) ndr_print_DnssrvComplexOperation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvEnumRecords",
		sizeof(struct DnssrvEnumRecords),
		(ndr_push_flags_fn_t) ndr_push_DnssrvEnumRecords,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvEnumRecords,
		(ndr_print_function_t) ndr_print_DnssrvEnumRecords,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvUpdateRecord",
		sizeof(struct DnssrvUpdateRecord),
		(ndr_push_flags_fn_t) ndr_push_DnssrvUpdateRecord,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvUpdateRecord,
		(ndr_print_function_t) ndr_print_DnssrvUpdateRecord,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvOperation2",
		sizeof(struct DnssrvOperation2),
		(ndr_push_flags_fn_t) ndr_push_DnssrvOperation2,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvOperation2,
		(ndr_print_function_t) ndr_print_DnssrvOperation2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvQuery2",
		sizeof(struct DnssrvQuery2),
		(ndr_push_flags_fn_t) ndr_push_DnssrvQuery2,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvQuery2,
		(ndr_print_function_t) ndr_print_DnssrvQuery2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvComplexOperation2",
		sizeof(struct DnssrvComplexOperation2),
		(ndr_push_flags_fn_t) ndr_push_DnssrvComplexOperation2,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvComplexOperation2,
		(ndr_print_function_t) ndr_print_DnssrvComplexOperation2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvEnumRecords2",
		sizeof(struct DnssrvEnumRecords2),
		(ndr_push_flags_fn_t) ndr_push_DnssrvEnumRecords2,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvEnumRecords2,
		(ndr_print_function_t) ndr_print_DnssrvEnumRecords2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"DnssrvUpdateRecord2",
		sizeof(struct DnssrvUpdateRecord2),
		(ndr_push_flags_fn_t) ndr_push_DnssrvUpdateRecord2,
		(ndr_pull_flags_fn_t) ndr_pull_DnssrvUpdateRecord2,
		(ndr_print_function_t) ndr_print_DnssrvUpdateRecord2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const dnsserver_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
	"ncacn_np:[\\pipe\\dnsserver]", 
};

static const struct ndr_interface_string_array dnsserver_endpoints = {
	.count	= 2,
	.names	= dnsserver_endpoint_strings
};

static const char * const dnsserver_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array dnsserver_authservices = {
	.count	= 1,
	.names	= dnsserver_authservice_strings
};


const struct ndr_interface_table ndr_table_dnsserver = {
	.name		= "dnsserver",
	.syntax_id	= {
		{0x50abc2a4,0x574d,0x40b3,{0x9d,0x66},{0xee,0x4f,0xd5,0xfb,0xa0,0x76}},
		NDR_DNSSERVER_VERSION
	},
	.helpstring	= NDR_DNSSERVER_HELPSTRING,
	.num_calls	= 10,
	.calls		= dnsserver_calls,
	.num_public_structs	= 6,
	.public_structs		= dnsserver_public_structs,
	.endpoints	= &dnsserver_endpoints,
	.authservices	= &dnsserver_authservices
};

#endif /* SKIP_NDR_TABLE_dnsserver */
