/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_dnsp.h"

#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_dns_record_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dns_record_type r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_record_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dns_record_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_record_type(struct ndr_print *ndr, const char *name, enum dns_record_type r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_TYPE_TOMBSTONE: val = "DNS_TYPE_TOMBSTONE"; break;
		case DNS_TYPE_A: val = "DNS_TYPE_A"; break;
		case DNS_TYPE_NS: val = "DNS_TYPE_NS"; break;
		case DNS_TYPE_MD: val = "DNS_TYPE_MD"; break;
		case DNS_TYPE_MF: val = "DNS_TYPE_MF"; break;
		case DNS_TYPE_CNAME: val = "DNS_TYPE_CNAME"; break;
		case DNS_TYPE_SOA: val = "DNS_TYPE_SOA"; break;
		case DNS_TYPE_MB: val = "DNS_TYPE_MB"; break;
		case DNS_TYPE_MG: val = "DNS_TYPE_MG"; break;
		case DNS_TYPE_MR: val = "DNS_TYPE_MR"; break;
		case DNS_TYPE_NULL: val = "DNS_TYPE_NULL"; break;
		case DNS_TYPE_WKS: val = "DNS_TYPE_WKS"; break;
		case DNS_TYPE_PTR: val = "DNS_TYPE_PTR"; break;
		case DNS_TYPE_HINFO: val = "DNS_TYPE_HINFO"; break;
		case DNS_TYPE_MINFO: val = "DNS_TYPE_MINFO"; break;
		case DNS_TYPE_MX: val = "DNS_TYPE_MX"; break;
		case DNS_TYPE_TXT: val = "DNS_TYPE_TXT"; break;
		case DNS_TYPE_RP: val = "DNS_TYPE_RP"; break;
		case DNS_TYPE_AFSDB: val = "DNS_TYPE_AFSDB"; break;
		case DNS_TYPE_X25: val = "DNS_TYPE_X25"; break;
		case DNS_TYPE_ISDN: val = "DNS_TYPE_ISDN"; break;
		case DNS_TYPE_RT: val = "DNS_TYPE_RT"; break;
		case DNS_TYPE_SIG: val = "DNS_TYPE_SIG"; break;
		case DNS_TYPE_KEY: val = "DNS_TYPE_KEY"; break;
		case DNS_TYPE_AAAA: val = "DNS_TYPE_AAAA"; break;
		case DNS_TYPE_LOC: val = "DNS_TYPE_LOC"; break;
		case DNS_TYPE_NXT: val = "DNS_TYPE_NXT"; break;
		case DNS_TYPE_SRV: val = "DNS_TYPE_SRV"; break;
		case DNS_TYPE_ATMA: val = "DNS_TYPE_ATMA"; break;
		case DNS_TYPE_NAPTR: val = "DNS_TYPE_NAPTR"; break;
		case DNS_TYPE_CERT: val = "DNS_TYPE_CERT"; break;
		case DNS_TYPE_DNAME: val = "DNS_TYPE_DNAME"; break;
		case DNS_TYPE_DS: val = "DNS_TYPE_DS"; break;
		case DNS_TYPE_SSHFP: val = "DNS_TYPE_SSHFP"; break;
		case DNS_TYPE_IPSECKEY: val = "DNS_TYPE_IPSECKEY"; break;
		case DNS_TYPE_RRSIG: val = "DNS_TYPE_RRSIG"; break;
		case DNS_TYPE_NSEC: val = "DNS_TYPE_NSEC"; break;
		case DNS_TYPE_DNSKEY: val = "DNS_TYPE_DNSKEY"; break;
		case DNS_TYPE_DHCID: val = "DNS_TYPE_DHCID"; break;
		case DNS_TYPE_NSEC3: val = "DNS_TYPE_NSEC3"; break;
		case DNS_TYPE_NSEC3PARAM: val = "DNS_TYPE_NSEC3PARAM"; break;
		case DNS_TYPE_TLSA: val = "DNS_TYPE_TLSA"; break;
		case DNS_TYPE_CDS: val = "DNS_TYPE_CDS"; break;
		case DNS_TYPE_CDNSKEY: val = "DNS_TYPE_CDNSKEY"; break;
		case DNS_TYPE_SVCB: val = "DNS_TYPE_SVCB"; break;
		case DNS_TYPE_HTTPS: val = "DNS_TYPE_HTTPS"; break;
		case DNS_TYPE_ALL: val = "DNS_TYPE_ALL"; break;
		case DNS_TYPE_URI: val = "DNS_TYPE_URI"; break;
		case DNS_TYPE_CAA: val = "DNS_TYPE_CAA"; break;
		case DNS_TYPE_WINS: val = "DNS_TYPE_WINS"; break;
		case DNS_TYPE_WINSR: val = "DNS_TYPE_WINSR"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dns_rpc_node_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_rpc_node_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_rpc_node_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_SUPPRESS_NOTIFY", DNS_RPC_FLAG_SUPPRESS_NOTIFY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_AGING_ON", DNS_RPC_FLAG_AGING_ON, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_OPEN_ACL", DNS_RPC_FLAG_OPEN_ACL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_RECORD_WIRE_FORMAT", DNS_RPC_FLAG_RECORD_WIRE_FORMAT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_SUPPRESS_RECORD_UPDATE_PTR", DNS_RPC_FLAG_SUPPRESS_RECORD_UPDATE_PTR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_NODE_COMPLETE", DNS_RPC_FLAG_NODE_COMPLETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_NODE_STICKY", DNS_RPC_FLAG_NODE_STICKY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_RECORD_CREATE_PTR", DNS_RPC_FLAG_RECORD_CREATE_PTR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_RECORD_TTL_CHANGE", DNS_RPC_FLAG_RECORD_TTL_CHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_RECORD_DEFAULT_TTL", DNS_RPC_FLAG_RECORD_DEFAULT_TTL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_ZONE_DELEGATION", DNS_RPC_FLAG_ZONE_DELEGATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_AUTH_ZONE_ROOT", DNS_RPC_FLAG_AUTH_ZONE_ROOT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_ZONE_ROOT", DNS_RPC_FLAG_ZONE_ROOT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DNS_RPC_FLAG_CACHE_DATA", DNS_RPC_FLAG_CACHE_DATA, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dns_record_rank(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dns_record_rank r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_record_rank(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dns_record_rank *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_record_rank(struct ndr_print *ndr, const char *name, enum dns_record_rank r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_RANK_NONE: val = "DNS_RANK_NONE"; break;
		case DNS_RANK_CACHE_BIT: val = "DNS_RANK_CACHE_BIT"; break;
		case DNS_RANK_ROOT_HINT: val = "DNS_RANK_ROOT_HINT"; break;
		case DNS_RANK_OUTSIDE_GLUE: val = "DNS_RANK_OUTSIDE_GLUE"; break;
		case DNS_RANK_CACHE_NA_ADDITIONAL: val = "DNS_RANK_CACHE_NA_ADDITIONAL"; break;
		case DNS_RANK_CACHE_NA_AUTHORITY: val = "DNS_RANK_CACHE_NA_AUTHORITY"; break;
		case DNS_RANK_CACHE_A_ADDITIONAL: val = "DNS_RANK_CACHE_A_ADDITIONAL"; break;
		case DNS_RANK_CACHE_NA_ANSWER: val = "DNS_RANK_CACHE_NA_ANSWER"; break;
		case DNS_RANK_CACHE_A_AUTHORITY: val = "DNS_RANK_CACHE_A_AUTHORITY"; break;
		case DNS_RANK_GLUE: val = "DNS_RANK_GLUE"; break;
		case DNS_RANK_NS_GLUE: val = "DNS_RANK_NS_GLUE"; break;
		case DNS_RANK_CACHE_A_ANSWER: val = "DNS_RANK_CACHE_A_ANSWER"; break;
		case DNS_RANK_ZONE: val = "DNS_RANK_ZONE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dns_zone_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dns_zone_type r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_zone_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dns_zone_type *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_zone_type(struct ndr_print *ndr, const char *name, enum dns_zone_type r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_ZONE_TYPE_CACHE: val = "DNS_ZONE_TYPE_CACHE"; break;
		case DNS_ZONE_TYPE_PRIMARY: val = "DNS_ZONE_TYPE_PRIMARY"; break;
		case DNS_ZONE_TYPE_SECONDARY: val = "DNS_ZONE_TYPE_SECONDARY"; break;
		case DNS_ZONE_TYPE_STUB: val = "DNS_ZONE_TYPE_STUB"; break;
		case DNS_ZONE_TYPE_FORWARDER: val = "DNS_ZONE_TYPE_FORWARDER"; break;
		case DNS_ZONE_TYPE_SECONDARY_CACHE: val = "DNS_ZONE_TYPE_SECONDARY_CACHE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dns_zone_update(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dns_zone_update r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dns_zone_update(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dns_zone_update *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_zone_update(struct ndr_print *ndr, const char *name, enum dns_zone_update r)
{
	const char *val = NULL;

	switch (r) {
		case DNS_ZONE_UPDATE_OFF: val = "DNS_ZONE_UPDATE_OFF"; break;
		case DNS_ZONE_UPDATE_UNSECURE: val = "DNS_ZONE_UPDATE_UNSECURE"; break;
		case DNS_ZONE_UPDATE_SECURE: val = "DNS_ZONE_UPDATE_SECURE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dns_property_id(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dns_property_id r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_property_id(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dns_property_id *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_property_id(struct ndr_print *ndr, const char *name, enum dns_property_id r)
{
	const char *val = NULL;

	switch (r) {
		case DSPROPERTY_ZONE_EMPTY: val = "DSPROPERTY_ZONE_EMPTY"; break;
		case DSPROPERTY_ZONE_TYPE: val = "DSPROPERTY_ZONE_TYPE"; break;
		case DSPROPERTY_ZONE_ALLOW_UPDATE: val = "DSPROPERTY_ZONE_ALLOW_UPDATE"; break;
		case DSPROPERTY_ZONE_SECURE_TIME: val = "DSPROPERTY_ZONE_SECURE_TIME"; break;
		case DSPROPERTY_ZONE_NOREFRESH_INTERVAL: val = "DSPROPERTY_ZONE_NOREFRESH_INTERVAL"; break;
		case DSPROPERTY_ZONE_SCAVENGING_SERVERS: val = "DSPROPERTY_ZONE_SCAVENGING_SERVERS"; break;
		case DSPROPERTY_ZONE_AGING_ENABLED_TIME: val = "DSPROPERTY_ZONE_AGING_ENABLED_TIME"; break;
		case DSPROPERTY_ZONE_REFRESH_INTERVAL: val = "DSPROPERTY_ZONE_REFRESH_INTERVAL"; break;
		case DSPROPERTY_ZONE_AGING_STATE: val = "DSPROPERTY_ZONE_AGING_STATE"; break;
		case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME: val = "DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME"; break;
		case DSPROPERTY_ZONE_MASTER_SERVERS: val = "DSPROPERTY_ZONE_MASTER_SERVERS"; break;
		case DSPROPERTY_ZONE_AUTO_NS_SERVERS: val = "DSPROPERTY_ZONE_AUTO_NS_SERVERS"; break;
		case DSPROPERTY_ZONE_DCPROMO_CONVERT: val = "DSPROPERTY_ZONE_DCPROMO_CONVERT"; break;
		case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA: val = "DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA"; break;
		case DSPROPERTY_ZONE_MASTER_SERVERS_DA: val = "DSPROPERTY_ZONE_MASTER_SERVERS_DA"; break;
		case DSPROPERTY_ZONE_NS_SERVERS_DA: val = "DSPROPERTY_ZONE_NS_SERVERS_DA"; break;
		case DSPROPERTY_ZONE_NODE_DBFLAGS: val = "DSPROPERTY_ZONE_NODE_DBFLAGS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dns_dcpromo_flag(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum dns_dcpromo_flag r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dns_dcpromo_flag(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum dns_dcpromo_flag *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dns_dcpromo_flag(struct ndr_print *ndr, const char *name, enum dns_dcpromo_flag r)
{
	const char *val = NULL;

	switch (r) {
		case DCPROMO_CONVERT_NONE: val = "DCPROMO_CONVERT_NONE"; break;
		case DCPROMO_CONVERT_DOMAIN: val = "DCPROMO_CONVERT_DOMAIN"; break;
		case DCPROMO_CONVERT_FOREST: val = "DCPROMO_CONVERT_FOREST"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_soa(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_soa *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->serial));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->refresh));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->retry));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->expire));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minimum));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->mname));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->rname));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_soa(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_soa *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->serial));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->refresh));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->retry));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->expire));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minimum));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->mname));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->rname));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_soa(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_soa *r)
{
	ndr_print_dnsp_soa(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_soa(struct ndr_print *ndr, const char *name, const struct dnsp_soa *r)
{
	ndr_print_struct(ndr, name, "dnsp_soa");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "serial", r->serial);
	ndr_print_uint32(ndr, "refresh", r->refresh);
	ndr_print_uint32(ndr, "retry", r->retry);
	ndr_print_uint32(ndr, "expire", r->expire);
	ndr_print_uint32(ndr, "minimum", r->minimum);
	ndr_print_dnsp_name(ndr, "mname", r->mname);
	ndr_print_dnsp_name(ndr, "rname", r->rname);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_mx(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_mx *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPriority));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->nameTarget));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_mx(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_mx *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPriority));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->nameTarget));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_mx(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_mx *r)
{
	ndr_print_dnsp_mx(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_mx(struct ndr_print *ndr, const char *name, const struct dnsp_mx *r)
{
	ndr_print_struct(ndr, name, "dnsp_mx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wPriority", r->wPriority);
	ndr_print_dnsp_name(ndr, "nameTarget", r->nameTarget);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_hinfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_hinfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_dnsp_string(ndr, NDR_SCALARS, r->cpu));
		NDR_CHECK(ndr_push_dnsp_string(ndr, NDR_SCALARS, r->os));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_hinfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_hinfo *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_dnsp_string(ndr, NDR_SCALARS, &r->cpu));
		NDR_CHECK(ndr_pull_dnsp_string(ndr, NDR_SCALARS, &r->os));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_hinfo(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_hinfo *r)
{
	ndr_print_dnsp_hinfo(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_hinfo(struct ndr_print *ndr, const char *name, const struct dnsp_hinfo *r)
{
	ndr_print_struct(ndr, name, "dnsp_hinfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dnsp_string(ndr, "cpu", r->cpu);
	ndr_print_dnsp_string(ndr, "os", r->os);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_srv(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_srv *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPriority));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wWeight));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->wPort));
		NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->nameTarget));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_srv(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_srv *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPriority));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wWeight));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wPort));
		NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->nameTarget));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_srv(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_srv *r)
{
	ndr_print_dnsp_srv(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_srv(struct ndr_print *ndr, const char *name, const struct dnsp_srv *r)
{
	ndr_print_struct(ndr, name, "dnsp_srv");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wPriority", r->wPriority);
	ndr_print_uint16(ndr, "wWeight", r->wWeight);
	ndr_print_uint16(ndr, "wPort", r->wPort);
	ndr_print_dnsp_name(ndr, "nameTarget", r->nameTarget);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dnsp_ip4_array(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_ip4_array *r)
{
	uint32_t cntr_addrArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->addrCount));
		for (cntr_addrArray_0 = 0; cntr_addrArray_0 < (r->addrCount); cntr_addrArray_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->addrArray[cntr_addrArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnsp_ip4_array(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_ip4_array *r)
{
	uint32_t size_addrArray_0 = 0;
	uint32_t cntr_addrArray_0;
	TALLOC_CTX *_mem_save_addrArray_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->addrCount));
		size_addrArray_0 = r->addrCount;
		NDR_PULL_ALLOC_N(ndr, r->addrArray, size_addrArray_0);
		_mem_save_addrArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->addrArray, 0);
		for (cntr_addrArray_0 = 0; cntr_addrArray_0 < (size_addrArray_0); cntr_addrArray_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->addrArray[cntr_addrArray_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addrArray_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_ip4_array(struct ndr_print *ndr, const char *name, const struct dnsp_ip4_array *r)
{
	uint32_t cntr_addrArray_0;
	ndr_print_struct(ndr, name, "dnsp_ip4_array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "addrCount", r->addrCount);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "addrArray", (uint32_t)(r->addrCount));
	ndr->depth++;
	for (cntr_addrArray_0 = 0; cntr_addrArray_0 < (r->addrCount); cntr_addrArray_0++) {
		ndr_print_uint32(ndr, "addrArray", r->addrArray[cntr_addrArray_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dnsp_dns_addr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_dns_addr *r)
{
	uint32_t cntr_unused_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->family));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->port));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pad, 8));
		for (cntr_unused_0 = 0; cntr_unused_0 < (8); cntr_unused_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->unused[cntr_unused_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnsp_dns_addr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_dns_addr *r)
{
	uint32_t size_pad_0 = 0;
	uint32_t size_unused_0 = 0;
	uint32_t cntr_unused_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->family));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->port));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
			ndr->flags = _flags_save_ipv4address;
		}
		NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
		size_pad_0 = 8;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pad, size_pad_0));
		size_unused_0 = 8;
		for (cntr_unused_0 = 0; cntr_unused_0 < (size_unused_0); cntr_unused_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->unused[cntr_unused_0]));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsp_dns_addr(struct ndr_print *ndr, const char *name, const struct dnsp_dns_addr *r)
{
	uint32_t cntr_unused_0;
	ndr_print_struct(ndr, name, "dnsp_dns_addr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "family", r->family);
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "port", r->port);
		ndr->flags = _flags_save_uint16;
	}
	{
		libndr_flags _flags_save_ipv4address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
		ndr->flags = _flags_save_ipv4address;
	}
	ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
	ndr_print_array_uint8(ndr, "pad", r->pad, 8);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "unused", (uint32_t)(8));
	ndr->depth++;
	for (cntr_unused_0 = 0; cntr_unused_0 < (8); cntr_unused_0++) {
		ndr_print_uint32(ndr, "unused", r->unused[cntr_unused_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_dns_addr_array(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_dns_addr_array *r)
{
	uint32_t cntr_AddrArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MaxCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->AddrCount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Tag));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Family));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Reserved0));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->MatchFlag));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved2));
		for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (r->AddrCount); cntr_AddrArray_0++) {
			NDR_CHECK(ndr_push_dnsp_dns_addr(ndr, NDR_SCALARS, &r->AddrArray[cntr_AddrArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_dns_addr_array(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_dns_addr_array *r)
{
	uint32_t size_AddrArray_0 = 0;
	uint32_t cntr_AddrArray_0;
	TALLOC_CTX *_mem_save_AddrArray_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MaxCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->AddrCount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Tag));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Family));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Reserved0));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->MatchFlag));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved2));
		size_AddrArray_0 = r->AddrCount;
		NDR_PULL_ALLOC_N(ndr, r->AddrArray, size_AddrArray_0);
		_mem_save_AddrArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->AddrArray, 0);
		for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (size_AddrArray_0); cntr_AddrArray_0++) {
			NDR_CHECK(ndr_pull_dnsp_dns_addr(ndr, NDR_SCALARS, &r->AddrArray[cntr_AddrArray_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AddrArray_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_dns_addr_array(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_dns_addr_array *r)
{
	ndr_print_dnsp_dns_addr_array(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_dns_addr_array(struct ndr_print *ndr, const char *name, const struct dnsp_dns_addr_array *r)
{
	uint32_t cntr_AddrArray_0;
	ndr_print_struct(ndr, name, "dnsp_dns_addr_array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "MaxCount", r->MaxCount);
	ndr_print_uint32(ndr, "AddrCount", r->AddrCount);
	ndr_print_uint32(ndr, "Tag", r->Tag);
	ndr_print_uint16(ndr, "Family", r->Family);
	ndr_print_uint16(ndr, "Reserved0", r->Reserved0);
	ndr_print_uint32(ndr, "Flags", r->Flags);
	ndr_print_uint32(ndr, "MatchFlag", r->MatchFlag);
	ndr_print_uint32(ndr, "Reserved1", r->Reserved1);
	ndr_print_uint32(ndr, "Reserved2", r->Reserved2);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "AddrArray", (uint32_t)(r->AddrCount));
	ndr->depth++;
	for (cntr_AddrArray_0 = 0; cntr_AddrArray_0 < (r->AddrCount); cntr_AddrArray_0++) {
		ndr_print_dnsp_dns_addr(ndr, "AddrArray", &r->AddrArray[cntr_AddrArray_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static void ndr_print_flags_dnsp_string_list(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_string_list *r)
{
	ndr_print_dnsp_string_list(ndr, name, r);
}

_PUBLIC_ size_t ndr_size_dnsp_string_list(const struct dnsp_string_list *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_dnsp_string_list);
}

static enum ndr_err_code ndr_push_dnsRecordData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dnsRecordData *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case DNS_TYPE_TOMBSTONE: {
				NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->EntombedTime));
			break; }

			case DNS_TYPE_A: {
				{
					libndr_flags _flags_save_ipv4address = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
					ndr->flags = _flags_save_ipv4address;
				}
			break; }

			case DNS_TYPE_NS: {
				NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->ns));
			break; }

			case DNS_TYPE_CNAME: {
				NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->cname));
			break; }

			case DNS_TYPE_SOA: {
				{
					libndr_flags _flags_save_dnsp_soa = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_dnsp_soa(ndr, NDR_SCALARS, &r->soa));
					ndr->flags = _flags_save_dnsp_soa;
				}
			break; }

			case DNS_TYPE_MX: {
				{
					libndr_flags _flags_save_dnsp_mx = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_dnsp_mx(ndr, NDR_SCALARS, &r->mx));
					ndr->flags = _flags_save_dnsp_mx;
				}
			break; }

			case DNS_TYPE_TXT: {
				NDR_CHECK(ndr_push_dnsp_string_list(ndr, NDR_SCALARS, &r->txt));
			break; }

			case DNS_TYPE_PTR: {
				NDR_CHECK(ndr_push_dnsp_name(ndr, NDR_SCALARS, r->ptr));
			break; }

			case DNS_TYPE_HINFO: {
				NDR_CHECK(ndr_push_dnsp_hinfo(ndr, NDR_SCALARS, &r->hinfo));
			break; }

			case DNS_TYPE_AAAA: {
				NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
			break; }

			case DNS_TYPE_SRV: {
				{
					libndr_flags _flags_save_dnsp_srv = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_push_dnsp_srv(ndr, NDR_SCALARS, &r->srv));
					ndr->flags = _flags_save_dnsp_srv;
				}
			break; }

			default: {
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnsRecordData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dnsRecordData *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case DNS_TYPE_TOMBSTONE: {
				NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->EntombedTime));
			break; }

			case DNS_TYPE_A: {
				{
					libndr_flags _flags_save_ipv4address = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
					ndr->flags = _flags_save_ipv4address;
				}
			break; }

			case DNS_TYPE_NS: {
				NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->ns));
			break; }

			case DNS_TYPE_CNAME: {
				NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->cname));
			break; }

			case DNS_TYPE_SOA: {
				{
					libndr_flags _flags_save_dnsp_soa = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_dnsp_soa(ndr, NDR_SCALARS, &r->soa));
					ndr->flags = _flags_save_dnsp_soa;
				}
			break; }

			case DNS_TYPE_MX: {
				{
					libndr_flags _flags_save_dnsp_mx = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_dnsp_mx(ndr, NDR_SCALARS, &r->mx));
					ndr->flags = _flags_save_dnsp_mx;
				}
			break; }

			case DNS_TYPE_TXT: {
				NDR_CHECK(ndr_pull_dnsp_string_list(ndr, NDR_SCALARS, &r->txt));
			break; }

			case DNS_TYPE_PTR: {
				NDR_CHECK(ndr_pull_dnsp_name(ndr, NDR_SCALARS, &r->ptr));
			break; }

			case DNS_TYPE_HINFO: {
				NDR_CHECK(ndr_pull_dnsp_hinfo(ndr, NDR_SCALARS, &r->hinfo));
			break; }

			case DNS_TYPE_AAAA: {
				NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
			break; }

			case DNS_TYPE_SRV: {
				{
					libndr_flags _flags_save_dnsp_srv = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					NDR_CHECK(ndr_pull_dnsp_srv(ndr, NDR_SCALARS, &r->srv));
					ndr->flags = _flags_save_dnsp_srv;
				}
			break; }

			default: {
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsRecordData(struct ndr_print *ndr, const char *name, const union dnsRecordData *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dnsRecordData");
	switch (level) {
		case DNS_TYPE_TOMBSTONE:
			ndr_print_NTTIME(ndr, "EntombedTime", r->EntombedTime);
		break;

		case DNS_TYPE_A:
			{
				libndr_flags _flags_save_ipv4address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
				ndr->flags = _flags_save_ipv4address;
			}
		break;

		case DNS_TYPE_NS:
			ndr_print_dnsp_name(ndr, "ns", r->ns);
		break;

		case DNS_TYPE_CNAME:
			ndr_print_dnsp_name(ndr, "cname", r->cname);
		break;

		case DNS_TYPE_SOA:
			{
				libndr_flags _flags_save_dnsp_soa = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				ndr_print_dnsp_soa(ndr, "soa", &r->soa);
				ndr->flags = _flags_save_dnsp_soa;
			}
		break;

		case DNS_TYPE_MX:
			{
				libndr_flags _flags_save_dnsp_mx = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				ndr_print_dnsp_mx(ndr, "mx", &r->mx);
				ndr->flags = _flags_save_dnsp_mx;
			}
		break;

		case DNS_TYPE_TXT:
			ndr_print_dnsp_string_list(ndr, "txt", &r->txt);
		break;

		case DNS_TYPE_PTR:
			ndr_print_dnsp_name(ndr, "ptr", r->ptr);
		break;

		case DNS_TYPE_HINFO:
			ndr_print_dnsp_hinfo(ndr, "hinfo", &r->hinfo);
		break;

		case DNS_TYPE_AAAA:
			ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
		break;

		case DNS_TYPE_SRV:
			{
				libndr_flags _flags_save_dnsp_srv = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				ndr_print_dnsp_srv(ndr, "srv", &r->srv);
				ndr->flags = _flags_save_dnsp_srv;
			}
		break;

		default:
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr_print_DATA_BLOB(ndr, "data", r->data);
				ndr->flags = _flags_save_DATA_BLOB;
			}
		break;

	}
}

static size_t ndr_size_dnsRecordData(const union dnsRecordData *r, uint32_t level, libndr_flags flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_dnsRecordData);
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_DnssrvRpcRecord(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_DnssrvRpcRecord *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_dnsRecordData(&r->data, r->wType, ndr->flags)));
		NDR_CHECK(ndr_push_dns_record_type(ndr, NDR_SCALARS, r->wType));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 5));
		NDR_CHECK(ndr_push_dns_record_rank(ndr, NDR_SCALARS, r->rank));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwSerial));
		{
			libndr_flags _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTtlSeconds));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTimeStamp));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->wType));
		NDR_CHECK(ndr_push_dnsRecordData(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_DnssrvRpcRecord(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_DnssrvRpcRecord *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->wDataLength));
		NDR_CHECK(ndr_pull_dns_record_type(ndr, NDR_SCALARS, &r->wType));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_dns_record_rank(ndr, NDR_SCALARS, &r->rank));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSerial));
		{
			libndr_flags _flags_save_uint32 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTtlSeconds));
			ndr->flags = _flags_save_uint32;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTimeStamp));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->wType));
		NDR_CHECK(ndr_pull_dnsRecordData(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_DnssrvRpcRecord(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_DnssrvRpcRecord *r)
{
	ndr_print_dnsp_DnssrvRpcRecord(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_DnssrvRpcRecord(struct ndr_print *ndr, const char *name, const struct dnsp_DnssrvRpcRecord *r)
{
	ndr_print_struct(ndr, name, "dnsp_DnssrvRpcRecord");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "wDataLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dnsRecordData(&r->data, r->wType, ndr->flags):r->wDataLength);
	ndr_print_dns_record_type(ndr, "wType", r->wType);
	ndr_print_uint8(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?5:r->version);
	ndr_print_dns_record_rank(ndr, "rank", r->rank);
	ndr_print_uint16(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "dwSerial", r->dwSerial);
	{
		libndr_flags _flags_save_uint32 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint32(ndr, "dwTtlSeconds", r->dwTtlSeconds);
		ndr->flags = _flags_save_uint32;
	}
	ndr_print_uint32(ndr, "dwReserved", r->dwReserved);
	ndr_print_uint32(ndr, "dwTimeStamp", r->dwTimeStamp);
	ndr_print_set_switch_value(ndr, &r->data, r->wType);
	ndr_print_dnsRecordData(ndr, "data", &r->data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dnsPropertyData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dnsPropertyData *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case DSPROPERTY_ZONE_EMPTY: {
			break; }

			case DSPROPERTY_ZONE_TYPE: {
				NDR_CHECK(ndr_push_dns_zone_type(ndr, NDR_SCALARS, r->zone_type));
			break; }

			case DSPROPERTY_ZONE_ALLOW_UPDATE: {
				NDR_CHECK(ndr_push_dns_zone_update(ndr, NDR_SCALARS, r->allow_update_flag));
			break; }

			case DSPROPERTY_ZONE_SECURE_TIME: {
				NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->zone_secure_time));
			break; }

			case DSPROPERTY_ZONE_NOREFRESH_INTERVAL: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->norefresh_hours));
			break; }

			case DSPROPERTY_ZONE_REFRESH_INTERVAL: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->refresh_hours));
			break; }

			case DSPROPERTY_ZONE_AGING_STATE: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->aging_enabled));
			break; }

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS: {
				NDR_CHECK(ndr_push_dnsp_ip4_array(ndr, NDR_SCALARS, &r->servers));
			break; }

			case DSPROPERTY_ZONE_AGING_ENABLED_TIME: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->next_scavenging_cycle_hours));
			break; }

			case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME: {
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->deleted_by_hostname));
					ndr->flags = _flags_save_string;
				}
			break; }

			case DSPROPERTY_ZONE_MASTER_SERVERS: {
				NDR_CHECK(ndr_push_dnsp_ip4_array(ndr, NDR_SCALARS, &r->master_servers));
			break; }

			case DSPROPERTY_ZONE_AUTO_NS_SERVERS: {
				NDR_CHECK(ndr_push_dnsp_ip4_array(ndr, NDR_SCALARS, &r->ns_servers));
			break; }

			case DSPROPERTY_ZONE_DCPROMO_CONVERT: {
				NDR_CHECK(ndr_push_dns_dcpromo_flag(ndr, NDR_SCALARS, r->dcpromo_flag));
			break; }

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA: {
				NDR_CHECK(ndr_push_dnsp_dns_addr_array(ndr, NDR_SCALARS, &r->s_ns_servers));
			break; }

			case DSPROPERTY_ZONE_MASTER_SERVERS_DA: {
				NDR_CHECK(ndr_push_dnsp_dns_addr_array(ndr, NDR_SCALARS, &r->z_master_servers));
			break; }

			case DSPROPERTY_ZONE_NS_SERVERS_DA: {
				NDR_CHECK(ndr_push_dnsp_dns_addr_array(ndr, NDR_SCALARS, &r->d_ns_servers));
			break; }

			case DSPROPERTY_ZONE_NODE_DBFLAGS: {
				NDR_CHECK(ndr_push_dns_rpc_node_flags(ndr, NDR_SCALARS, r->flags));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DSPROPERTY_ZONE_EMPTY:
			break;

			case DSPROPERTY_ZONE_TYPE:
			break;

			case DSPROPERTY_ZONE_ALLOW_UPDATE:
			break;

			case DSPROPERTY_ZONE_SECURE_TIME:
			break;

			case DSPROPERTY_ZONE_NOREFRESH_INTERVAL:
			break;

			case DSPROPERTY_ZONE_REFRESH_INTERVAL:
			break;

			case DSPROPERTY_ZONE_AGING_STATE:
			break;

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS:
			break;

			case DSPROPERTY_ZONE_AGING_ENABLED_TIME:
			break;

			case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME:
			break;

			case DSPROPERTY_ZONE_MASTER_SERVERS:
			break;

			case DSPROPERTY_ZONE_AUTO_NS_SERVERS:
			break;

			case DSPROPERTY_ZONE_DCPROMO_CONVERT:
			break;

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA:
			break;

			case DSPROPERTY_ZONE_MASTER_SERVERS_DA:
			break;

			case DSPROPERTY_ZONE_NS_SERVERS_DA:
			break;

			case DSPROPERTY_ZONE_NODE_DBFLAGS:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dnsPropertyData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dnsPropertyData *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case DSPROPERTY_ZONE_EMPTY: {
			break; }

			case DSPROPERTY_ZONE_TYPE: {
				NDR_CHECK(ndr_pull_dns_zone_type(ndr, NDR_SCALARS, &r->zone_type));
			break; }

			case DSPROPERTY_ZONE_ALLOW_UPDATE: {
				NDR_CHECK(ndr_pull_dns_zone_update(ndr, NDR_SCALARS, &r->allow_update_flag));
			break; }

			case DSPROPERTY_ZONE_SECURE_TIME: {
				NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->zone_secure_time));
			break; }

			case DSPROPERTY_ZONE_NOREFRESH_INTERVAL: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->norefresh_hours));
			break; }

			case DSPROPERTY_ZONE_REFRESH_INTERVAL: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->refresh_hours));
			break; }

			case DSPROPERTY_ZONE_AGING_STATE: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->aging_enabled));
			break; }

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS: {
				NDR_CHECK(ndr_pull_dnsp_ip4_array(ndr, NDR_SCALARS, &r->servers));
			break; }

			case DSPROPERTY_ZONE_AGING_ENABLED_TIME: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->next_scavenging_cycle_hours));
			break; }

			case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME: {
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->deleted_by_hostname));
					ndr->flags = _flags_save_string;
				}
			break; }

			case DSPROPERTY_ZONE_MASTER_SERVERS: {
				NDR_CHECK(ndr_pull_dnsp_ip4_array(ndr, NDR_SCALARS, &r->master_servers));
			break; }

			case DSPROPERTY_ZONE_AUTO_NS_SERVERS: {
				NDR_CHECK(ndr_pull_dnsp_ip4_array(ndr, NDR_SCALARS, &r->ns_servers));
			break; }

			case DSPROPERTY_ZONE_DCPROMO_CONVERT: {
				NDR_CHECK(ndr_pull_dns_dcpromo_flag(ndr, NDR_SCALARS, &r->dcpromo_flag));
			break; }

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA: {
				NDR_CHECK(ndr_pull_dnsp_dns_addr_array(ndr, NDR_SCALARS, &r->s_ns_servers));
			break; }

			case DSPROPERTY_ZONE_MASTER_SERVERS_DA: {
				NDR_CHECK(ndr_pull_dnsp_dns_addr_array(ndr, NDR_SCALARS, &r->z_master_servers));
			break; }

			case DSPROPERTY_ZONE_NS_SERVERS_DA: {
				NDR_CHECK(ndr_pull_dnsp_dns_addr_array(ndr, NDR_SCALARS, &r->d_ns_servers));
			break; }

			case DSPROPERTY_ZONE_NODE_DBFLAGS: {
				NDR_CHECK(ndr_pull_dns_rpc_node_flags(ndr, NDR_SCALARS, &r->flags));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case DSPROPERTY_ZONE_EMPTY:
			break;

			case DSPROPERTY_ZONE_TYPE:
			break;

			case DSPROPERTY_ZONE_ALLOW_UPDATE:
			break;

			case DSPROPERTY_ZONE_SECURE_TIME:
			break;

			case DSPROPERTY_ZONE_NOREFRESH_INTERVAL:
			break;

			case DSPROPERTY_ZONE_REFRESH_INTERVAL:
			break;

			case DSPROPERTY_ZONE_AGING_STATE:
			break;

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS:
			break;

			case DSPROPERTY_ZONE_AGING_ENABLED_TIME:
			break;

			case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME:
			break;

			case DSPROPERTY_ZONE_MASTER_SERVERS:
			break;

			case DSPROPERTY_ZONE_AUTO_NS_SERVERS:
			break;

			case DSPROPERTY_ZONE_DCPROMO_CONVERT:
			break;

			case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA:
			break;

			case DSPROPERTY_ZONE_MASTER_SERVERS_DA:
			break;

			case DSPROPERTY_ZONE_NS_SERVERS_DA:
			break;

			case DSPROPERTY_ZONE_NODE_DBFLAGS:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dnsPropertyData(struct ndr_print *ndr, const char *name, const union dnsPropertyData *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dnsPropertyData");
	switch (level) {
		case DSPROPERTY_ZONE_EMPTY:
		break;

		case DSPROPERTY_ZONE_TYPE:
			ndr_print_dns_zone_type(ndr, "zone_type", r->zone_type);
		break;

		case DSPROPERTY_ZONE_ALLOW_UPDATE:
			ndr_print_dns_zone_update(ndr, "allow_update_flag", r->allow_update_flag);
		break;

		case DSPROPERTY_ZONE_SECURE_TIME:
			ndr_print_NTTIME(ndr, "zone_secure_time", r->zone_secure_time);
		break;

		case DSPROPERTY_ZONE_NOREFRESH_INTERVAL:
			ndr_print_uint32(ndr, "norefresh_hours", r->norefresh_hours);
		break;

		case DSPROPERTY_ZONE_REFRESH_INTERVAL:
			ndr_print_uint32(ndr, "refresh_hours", r->refresh_hours);
		break;

		case DSPROPERTY_ZONE_AGING_STATE:
			ndr_print_uint32(ndr, "aging_enabled", r->aging_enabled);
		break;

		case DSPROPERTY_ZONE_SCAVENGING_SERVERS:
			ndr_print_dnsp_ip4_array(ndr, "servers", &r->servers);
		break;

		case DSPROPERTY_ZONE_AGING_ENABLED_TIME:
			ndr_print_uint32(ndr, "next_scavenging_cycle_hours", r->next_scavenging_cycle_hours);
		break;

		case DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME:
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				ndr_print_string(ndr, "deleted_by_hostname", r->deleted_by_hostname);
				ndr->flags = _flags_save_string;
			}
		break;

		case DSPROPERTY_ZONE_MASTER_SERVERS:
			ndr_print_dnsp_ip4_array(ndr, "master_servers", &r->master_servers);
		break;

		case DSPROPERTY_ZONE_AUTO_NS_SERVERS:
			ndr_print_dnsp_ip4_array(ndr, "ns_servers", &r->ns_servers);
		break;

		case DSPROPERTY_ZONE_DCPROMO_CONVERT:
			ndr_print_dns_dcpromo_flag(ndr, "dcpromo_flag", r->dcpromo_flag);
		break;

		case DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA:
			ndr_print_dnsp_dns_addr_array(ndr, "s_ns_servers", &r->s_ns_servers);
		break;

		case DSPROPERTY_ZONE_MASTER_SERVERS_DA:
			ndr_print_dnsp_dns_addr_array(ndr, "z_master_servers", &r->z_master_servers);
		break;

		case DSPROPERTY_ZONE_NS_SERVERS_DA:
			ndr_print_dnsp_dns_addr_array(ndr, "d_ns_servers", &r->d_ns_servers);
		break;

		case DSPROPERTY_ZONE_NODE_DBFLAGS:
			ndr_print_dns_rpc_node_flags(ndr, "flags", r->flags);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static size_t ndr_size_dnsPropertyData(const union dnsPropertyData *r, uint32_t level, libndr_flags flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_dnsPropertyData);
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_DnsProperty(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_DnsProperty *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_dnsPropertyData(&r->data, r->id, ndr->flags)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->namelength));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
			NDR_CHECK(ndr_push_dns_property_id(ndr, NDR_SCALARS, r->id));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->id));
			NDR_CHECK(ndr_push_dnsPropertyData(ndr, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->id));
			NDR_CHECK(ndr_push_dnsPropertyData(ndr, NDR_BUFFERS, &r->data));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_DnsProperty(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_DnsProperty *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->wDataLength));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->namelength));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flag));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_dns_property_id(ndr, NDR_SCALARS, &r->id));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->id));
			NDR_CHECK(ndr_pull_dnsPropertyData(ndr, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->id));
			NDR_CHECK(ndr_pull_dnsPropertyData(ndr, NDR_BUFFERS, &r->data));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_DnsProperty(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_DnsProperty *r)
{
	ndr_print_dnsp_DnsProperty(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_DnsProperty(struct ndr_print *ndr, const char *name, const struct dnsp_DnsProperty *r)
{
	ndr_print_struct(ndr, name, "dnsp_DnsProperty");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "wDataLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_dnsPropertyData(&r->data, r->id, ndr->flags):r->wDataLength);
		ndr_print_uint32(ndr, "namelength", r->namelength);
		ndr_print_uint32(ndr, "flag", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->flag);
		ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->version);
		ndr_print_dns_property_id(ndr, "id", r->id);
		ndr_print_set_switch_value(ndr, &r->data, r->id);
		ndr_print_dnsPropertyData(ndr, "data", &r->data);
		ndr_print_uint32(ndr, "name", r->name);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dnsp_DnsProperty_short(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dnsp_DnsProperty_short *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->namelength));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
			NDR_CHECK(ndr_push_dns_property_id(ndr, NDR_SCALARS, r->id));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, DSPROPERTY_ZONE_EMPTY));
			NDR_CHECK(ndr_push_dnsPropertyData(ndr, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, DSPROPERTY_ZONE_EMPTY));
			NDR_CHECK(ndr_push_dnsPropertyData(ndr, NDR_BUFFERS, &r->data));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dnsp_DnsProperty_short(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dnsp_DnsProperty_short *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->wDataLength));
			if (r->wDataLength > 0) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->wDataLength), (uint32_t)(0), (uint32_t)(0));
			}
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->namelength));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flag));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_dns_property_id(ndr, NDR_SCALARS, &r->id));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, DSPROPERTY_ZONE_EMPTY));
			NDR_CHECK(ndr_pull_dnsPropertyData(ndr, NDR_SCALARS, &r->data));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, DSPROPERTY_ZONE_EMPTY));
			NDR_CHECK(ndr_pull_dnsPropertyData(ndr, NDR_BUFFERS, &r->data));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dnsp_DnsProperty_short(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dnsp_DnsProperty_short *r)
{
	ndr_print_dnsp_DnsProperty_short(ndr, name, r);
}

_PUBLIC_ void ndr_print_dnsp_DnsProperty_short(struct ndr_print *ndr, const char *name, const struct dnsp_DnsProperty_short *r)
{
	ndr_print_struct(ndr, name, "dnsp_DnsProperty_short");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "wDataLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->wDataLength);
		ndr_print_uint32(ndr, "namelength", r->namelength);
		ndr_print_uint32(ndr, "flag", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->flag);
		ndr_print_uint32(ndr, "version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->version);
		ndr_print_dns_property_id(ndr, "id", r->id);
		ndr_print_set_switch_value(ndr, &r->data, DSPROPERTY_ZONE_EMPTY);
		ndr_print_dnsPropertyData(ndr, "data", &r->data);
		ndr_print_uint32(ndr, "name", r->name);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_dnsp
static const struct ndr_interface_public_struct dnsp_public_structs[] = {
	{
		.name = "dnsp_soa",
		.struct_size = sizeof(struct dnsp_soa ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_soa,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_soa,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_soa,
	},
	{
		.name = "dnsp_mx",
		.struct_size = sizeof(struct dnsp_mx ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_mx,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_mx,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_mx,
	},
	{
		.name = "dnsp_hinfo",
		.struct_size = sizeof(struct dnsp_hinfo ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_hinfo,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_hinfo,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_hinfo,
	},
	{
		.name = "dnsp_srv",
		.struct_size = sizeof(struct dnsp_srv ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_srv,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_srv,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_srv,
	},
	{
		.name = "dnsp_dns_addr_array",
		.struct_size = sizeof(struct dnsp_dns_addr_array ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_dns_addr_array,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_dns_addr_array,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_dns_addr_array,
	},
	{
		.name = "dnsp_string_list",
		.struct_size = sizeof(struct dnsp_string_list ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_string_list,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_string_list,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_string_list,
	},
	{
		.name = "dnsp_DnssrvRpcRecord",
		.struct_size = sizeof(struct dnsp_DnssrvRpcRecord ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_DnssrvRpcRecord,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_DnssrvRpcRecord,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_DnssrvRpcRecord,
	},
	{
		.name = "dnsp_DnsProperty",
		.struct_size = sizeof(struct dnsp_DnsProperty ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_DnsProperty,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_DnsProperty,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_DnsProperty,
	},
	{
		.name = "dnsp_DnsProperty_short",
		.struct_size = sizeof(struct dnsp_DnsProperty_short ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dnsp_DnsProperty_short,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dnsp_DnsProperty_short,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dnsp_DnsProperty_short,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call dnsp_calls[] = {
	{ .name = NULL }
};

static const char * const dnsp_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\dnsp]", 
};

static const struct ndr_interface_string_array dnsp_endpoints = {
	.count	= 1,
	.names	= dnsp_endpoint_strings
};

static const char * const dnsp_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array dnsp_authservices = {
	.count	= 1,
	.names	= dnsp_authservice_strings
};


const struct ndr_interface_table ndr_table_dnsp = {
	.name		= "dnsp",
	.syntax_id	= {
		{0xbdd66e9e,0xd45f,0x4202,{0x85,0xc0},{0x61,0x32,0xed,0xc4,0xf3,0x0a}},
		NDR_DNSP_VERSION
	},
	.helpstring	= NDR_DNSP_HELPSTRING,
	.num_calls	= 0,
	.calls		= dnsp_calls,
	.num_public_structs	= 9,
	.public_structs		= dnsp_public_structs,
	.endpoints	= &dnsp_endpoints,
	.authservices	= &dnsp_authservices
};

#endif /* SKIP_NDR_TABLE_dnsp */
