/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_dfsblobs.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_DFS_HEADER_FLAG(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DFS_HEADER_FLAG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DFS_HEADER_FLAG(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_HEADER_FLAG_REFERAL_SVR", DFS_HEADER_FLAG_REFERAL_SVR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_HEADER_FLAG_STORAGE_SVR", DFS_HEADER_FLAG_STORAGE_SVR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "DFS_HEADER_FLAG_TARGET_BCK", DFS_HEADER_FLAG_TARGET_BCK, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_DFS_SERVER_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DFS_SERVER_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DFS_SERVER_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DFS_SERVER_TYPE *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DFS_SERVER_TYPE(struct ndr_print *ndr, const char *name, enum DFS_SERVER_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case DFS_SERVER_NON_ROOT: val = "DFS_SERVER_NON_ROOT"; break;
		case DFS_SERVER_ROOT: val = "DFS_SERVER_ROOT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_DFS_FLAGS_REFERRAL(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum DFS_FLAGS_REFERRAL r)
{
	NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_DFS_FLAGS_REFERRAL(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum DFS_FLAGS_REFERRAL *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DFS_FLAGS_REFERRAL(struct ndr_print *ndr, const char *name, enum DFS_FLAGS_REFERRAL r)
{
	const char *val = NULL;

	switch (r) {
		case DFS_FLAG_REFERRAL_DOMAIN_RESP: val = "DFS_FLAG_REFERRAL_DOMAIN_RESP"; break;
		case DFS_FLAG_REFERRAL_FIRST_TARGET_SET: val = "DFS_FLAG_REFERRAL_FIRST_TARGET_SET"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_dfs_referral_v1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_referral_v1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->entry_flags));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->share_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->share_name) {
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->share_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_referral_v1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_referral_v1 *r)
{
	uint32_t _ptr_share_name;
	TALLOC_CTX *_mem_save_share_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->entry_flags));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share_name));
			if (_ptr_share_name) {
				NDR_PULL_ALLOC(ndr, r->share_name);
			} else {
				r->share_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->share_name) {
				_mem_save_share_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->share_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->share_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_name_0, 0);
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_referral_v1(struct ndr_print *ndr, const char *name, const struct dfs_referral_v1 *r)
{
	ndr_print_struct(ndr, name, "dfs_referral_v1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "size", r->size);
	ndr_print_uint16(ndr, "server_type", r->server_type);
	ndr_print_uint16(ndr, "entry_flags", r->entry_flags);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "share_name", r->share_name);
		ndr->depth++;
		if (r->share_name) {
			ndr_print_string(ndr, "share_name", r->share_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_referral_v2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_referral_v2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_DFS_SERVER_TYPE(ndr, NDR_SCALARS, r->server_type));
		NDR_CHECK(ndr_push_DFS_FLAGS_REFERRAL(ndr, NDR_SCALARS, r->entry_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->proximity));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ttl));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DFS_path));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DFS_alt_path));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->netw_address));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_path) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DFS_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DFS_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_alt_path) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DFS_alt_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DFS_alt_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->netw_address) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->netw_address));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->netw_address));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_referral_v2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_referral_v2 *r)
{
	uint16_t _ptr_DFS_path;
	TALLOC_CTX *_mem_save_DFS_path_0 = NULL;
	uint16_t _ptr_DFS_alt_path;
	TALLOC_CTX *_mem_save_DFS_alt_path_0 = NULL;
	uint16_t _ptr_netw_address;
	TALLOC_CTX *_mem_save_netw_address_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_DFS_SERVER_TYPE(ndr, NDR_SCALARS, &r->server_type));
		NDR_CHECK(ndr_pull_DFS_FLAGS_REFERRAL(ndr, NDR_SCALARS, &r->entry_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->proximity));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ttl));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DFS_path));
			if (_ptr_DFS_path) {
				NDR_PULL_ALLOC(ndr, r->DFS_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DFS_path, _ptr_DFS_path));
			} else {
				r->DFS_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DFS_alt_path));
			if (_ptr_DFS_alt_path) {
				NDR_PULL_ALLOC(ndr, r->DFS_alt_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DFS_alt_path, _ptr_DFS_alt_path));
			} else {
				r->DFS_alt_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_netw_address));
			if (_ptr_netw_address) {
				NDR_PULL_ALLOC(ndr, r->netw_address);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->netw_address, _ptr_netw_address));
			} else {
				r->netw_address = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DFS_path));
				_mem_save_DFS_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DFS_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DFS_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DFS_path_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_alt_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DFS_alt_path));
				_mem_save_DFS_alt_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DFS_alt_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DFS_alt_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DFS_alt_path_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->netw_address) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->netw_address));
				_mem_save_netw_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->netw_address, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->netw_address));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netw_address_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_referral_v2(struct ndr_print *ndr, const char *name, const struct dfs_referral_v2 *r)
{
	ndr_print_struct(ndr, name, "dfs_referral_v2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "size", r->size);
	ndr_print_DFS_SERVER_TYPE(ndr, "server_type", r->server_type);
	ndr_print_DFS_FLAGS_REFERRAL(ndr, "entry_flags", r->entry_flags);
	ndr_print_uint32(ndr, "proximity", r->proximity);
	ndr_print_uint32(ndr, "ttl", r->ttl);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "DFS_path", r->DFS_path);
		ndr->depth++;
		if (r->DFS_path) {
			ndr_print_string(ndr, "DFS_path", r->DFS_path);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "DFS_alt_path", r->DFS_alt_path);
		ndr->depth++;
		if (r->DFS_alt_path) {
			ndr_print_string(ndr, "DFS_alt_path", r->DFS_alt_path);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "netw_address", r->netw_address);
		ndr->depth++;
		if (r->netw_address) {
			ndr_print_string(ndr, "netw_address", r->netw_address);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_normal_referral(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_normal_referral *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DFS_path));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->DFS_alt_path));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->netw_address));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_path) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DFS_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DFS_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_alt_path) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->DFS_alt_path));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->DFS_alt_path));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->netw_address) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->netw_address));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->netw_address));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_normal_referral(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_normal_referral *r)
{
	uint16_t _ptr_DFS_path;
	TALLOC_CTX *_mem_save_DFS_path_0 = NULL;
	uint16_t _ptr_DFS_alt_path;
	TALLOC_CTX *_mem_save_DFS_alt_path_0 = NULL;
	uint16_t _ptr_netw_address;
	TALLOC_CTX *_mem_save_netw_address_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DFS_path));
			if (_ptr_DFS_path) {
				NDR_PULL_ALLOC(ndr, r->DFS_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DFS_path, _ptr_DFS_path));
			} else {
				r->DFS_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_DFS_alt_path));
			if (_ptr_DFS_alt_path) {
				NDR_PULL_ALLOC(ndr, r->DFS_alt_path);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DFS_alt_path, _ptr_DFS_alt_path));
			} else {
				r->DFS_alt_path = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_netw_address));
			if (_ptr_netw_address) {
				NDR_PULL_ALLOC(ndr, r->netw_address);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->netw_address, _ptr_netw_address));
			} else {
				r->netw_address = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DFS_path));
				_mem_save_DFS_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DFS_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DFS_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DFS_path_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->DFS_alt_path) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DFS_alt_path));
				_mem_save_DFS_alt_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DFS_alt_path, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->DFS_alt_path));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DFS_alt_path_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->netw_address) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->netw_address));
				_mem_save_netw_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->netw_address, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->netw_address));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_netw_address_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_normal_referral(struct ndr_print *ndr, const char *name, const struct dfs_normal_referral *r)
{
	ndr_print_struct(ndr, name, "dfs_normal_referral");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "DFS_path", r->DFS_path);
		ndr->depth++;
		if (r->DFS_path) {
			ndr_print_string(ndr, "DFS_path", r->DFS_path);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "DFS_alt_path", r->DFS_alt_path);
		ndr->depth++;
		if (r->DFS_alt_path) {
			ndr_print_string(ndr, "DFS_alt_path", r->DFS_alt_path);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "netw_address", r->netw_address);
		ndr->depth++;
		if (r->netw_address) {
			ndr_print_string(ndr, "netw_address", r->netw_address);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_domain_referral(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_domain_referral *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->special_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->nb_expanded_names));
		{
			libndr_flags _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_short_relative_ptr1(ndr, r->expanded_names));
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->special_name) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->special_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->special_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING|LIBNDR_FLAG_STR_NULLTERM);
			if (r->expanded_names) {
				NDR_CHECK(ndr_push_short_relative_ptr2(ndr, r->expanded_names));
				{
					struct ndr_push *_ndr_expanded_names;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_expanded_names, 0, -1));
					NDR_CHECK(ndr_push_string_array(_ndr_expanded_names, NDR_SCALARS, r->expanded_names));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_expanded_names, 0, -1));
				}
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_domain_referral(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_domain_referral *r)
{
	uint16_t _ptr_special_name;
	TALLOC_CTX *_mem_save_special_name_0 = NULL;
	uint16_t _ptr_expanded_names;
	TALLOC_CTX *_mem_save_expanded_names_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_special_name));
			if (_ptr_special_name) {
				NDR_PULL_ALLOC(ndr, r->special_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->special_name, _ptr_special_name));
			} else {
				r->special_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->nb_expanded_names));
		{
			libndr_flags _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_relative_ptr_short(ndr, &_ptr_expanded_names));
			if (_ptr_expanded_names) {
				NDR_PULL_ALLOC(ndr, r->expanded_names);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->expanded_names, _ptr_expanded_names));
			} else {
				r->expanded_names = NULL;
			}
			ndr->flags = _flags_save_string_array;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->special_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->special_name));
				_mem_save_special_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->special_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->special_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_special_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string_array = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING|LIBNDR_FLAG_STR_NULLTERM);
			if (r->expanded_names) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->expanded_names));
				_mem_save_expanded_names_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->expanded_names, 0);
				{
					struct ndr_pull *_ndr_expanded_names;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_expanded_names, 0, sub_size));
					NDR_CHECK(ndr_pull_string_array(_ndr_expanded_names, NDR_SCALARS, &r->expanded_names));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_expanded_names, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_expanded_names_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string_array;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_domain_referral(struct ndr_print *ndr, const char *name, const struct dfs_domain_referral *r)
{
	ndr_print_struct(ndr, name, "dfs_domain_referral");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "special_name", r->special_name);
		ndr->depth++;
		if (r->special_name) {
			ndr_print_string(ndr, "special_name", r->special_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint16(ndr, "nb_expanded_names", r->nb_expanded_names);
	{
		libndr_flags _flags_save_string_array = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_ptr(ndr, "expanded_names", r->expanded_names);
		ndr->depth++;
		if (r->expanded_names) {
			ndr_print_string_array(ndr, "expanded_names", r->expanded_names);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string_array;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_dfs_referral(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dfs_referral *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_push_dfs_normal_referral(ndr, NDR_SCALARS, &r->r1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_dfs_domain_referral(ndr, NDR_SCALARS, &r->r2));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				NDR_CHECK(ndr_push_dfs_normal_referral(ndr, NDR_BUFFERS, &r->r1));
			break;

			case 2:
				NDR_CHECK(ndr_push_dfs_domain_referral(ndr, NDR_BUFFERS, &r->r2));
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_referral(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dfs_referral *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 0: {
				NDR_CHECK(ndr_pull_dfs_normal_referral(ndr, NDR_SCALARS, &r->r1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_dfs_domain_referral(ndr, NDR_SCALARS, &r->r2));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
				NDR_CHECK(ndr_pull_dfs_normal_referral(ndr, NDR_BUFFERS, &r->r1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_dfs_domain_referral(ndr, NDR_BUFFERS, &r->r2));
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_referral(struct ndr_print *ndr, const char *name, const union dfs_referral *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dfs_referral");
	switch (level) {
		case 0:
			ndr_print_dfs_normal_referral(ndr, "r1", &r->r1);
		break;

		case 2:
			ndr_print_dfs_domain_referral(ndr, "r2", &r->r2);
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_dfs_padding(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dfs_padding *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 1));
		switch (level) {
			case 16: {
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->value, 16));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_padding(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dfs_padding *r)
{
	uint32_t level;
	uint32_t size_value_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 1));
		switch (level) {
			case 16: {
				size_value_0 = 16;
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->value, size_value_0));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_padding(struct ndr_print *ndr, const char *name, const union dfs_padding *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dfs_padding");
	switch (level) {
		case 16:
			ndr_print_array_uint8(ndr, "value", r->value, 16);
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_dfs_referral_v3(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_referral_v3 *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
			NDR_CHECK(ndr_push_DFS_SERVER_TYPE(ndr, NDR_SCALARS, r->server_type));
			NDR_CHECK(ndr_push_DFS_FLAGS_REFERRAL(ndr, NDR_SCALARS, r->entry_flags));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ttl));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->referrals, r->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP));
			NDR_CHECK(ndr_push_dfs_referral(ndr, NDR_SCALARS, &r->referrals));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->service_site_guid, r->size - 18));
			NDR_CHECK(ndr_push_dfs_padding(ndr, NDR_SCALARS, &r->service_site_guid));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->referrals, r->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP));
			NDR_CHECK(ndr_push_dfs_referral(ndr, NDR_BUFFERS, &r->referrals));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->service_site_guid, r->size - 18));
			NDR_CHECK(ndr_push_dfs_padding(ndr, NDR_BUFFERS, &r->service_site_guid));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_referral_v3(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_referral_v3 *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
			NDR_CHECK(ndr_pull_DFS_SERVER_TYPE(ndr, NDR_SCALARS, &r->server_type));
			NDR_CHECK(ndr_pull_DFS_FLAGS_REFERRAL(ndr, NDR_SCALARS, &r->entry_flags));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ttl));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->referrals, r->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP));
			NDR_CHECK(ndr_pull_dfs_referral(ndr, NDR_SCALARS, &r->referrals));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->service_site_guid, r->size - 18));
			NDR_CHECK(ndr_pull_dfs_padding(ndr, NDR_SCALARS, &r->service_site_guid));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->referrals, r->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP));
			NDR_CHECK(ndr_pull_dfs_referral(ndr, NDR_BUFFERS, &r->referrals));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->service_site_guid, r->size - 18));
			NDR_CHECK(ndr_pull_dfs_padding(ndr, NDR_BUFFERS, &r->service_site_guid));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_referral_v3(struct ndr_print *ndr, const char *name, const struct dfs_referral_v3 *r)
{
	ndr_print_struct(ndr, name, "dfs_referral_v3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint16(ndr, "size", r->size);
		ndr_print_DFS_SERVER_TYPE(ndr, "server_type", r->server_type);
		ndr_print_DFS_FLAGS_REFERRAL(ndr, "entry_flags", r->entry_flags);
		ndr_print_uint32(ndr, "ttl", r->ttl);
		ndr_print_set_switch_value(ndr, &r->referrals, r->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP);
		ndr_print_dfs_referral(ndr, "referrals", &r->referrals);
		ndr_print_set_switch_value(ndr, &r->service_site_guid, r->size - 18);
		ndr_print_dfs_padding(ndr, "service_site_guid", &r->service_site_guid);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_dfs_referral_version(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union dfs_referral_version *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_dfs_referral_v1(ndr, NDR_SCALARS, &r->v1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_dfs_referral_v2(ndr, NDR_SCALARS, &r->v2));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_dfs_referral_v3(ndr, NDR_SCALARS, &r->v3));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_dfs_referral_v3(ndr, NDR_SCALARS, &r->v4));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_push_dfs_referral_v1(ndr, NDR_BUFFERS, &r->v1));
			break;

			case 2:
				NDR_CHECK(ndr_push_dfs_referral_v2(ndr, NDR_BUFFERS, &r->v2));
			break;

			case 3:
				NDR_CHECK(ndr_push_dfs_referral_v3(ndr, NDR_BUFFERS, &r->v3));
			break;

			case 4:
				NDR_CHECK(ndr_push_dfs_referral_v3(ndr, NDR_BUFFERS, &r->v4));
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_referral_version(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union dfs_referral_version *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_dfs_referral_v1(ndr, NDR_SCALARS, &r->v1));
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_dfs_referral_v2(ndr, NDR_SCALARS, &r->v2));
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_dfs_referral_v3(ndr, NDR_SCALARS, &r->v3));
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_dfs_referral_v3(ndr, NDR_SCALARS, &r->v4));
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				NDR_CHECK(ndr_pull_dfs_referral_v1(ndr, NDR_BUFFERS, &r->v1));
			break;

			case 2:
				NDR_CHECK(ndr_pull_dfs_referral_v2(ndr, NDR_BUFFERS, &r->v2));
			break;

			case 3:
				NDR_CHECK(ndr_pull_dfs_referral_v3(ndr, NDR_BUFFERS, &r->v3));
			break;

			case 4:
				NDR_CHECK(ndr_pull_dfs_referral_v3(ndr, NDR_BUFFERS, &r->v4));
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_referral_version(struct ndr_print *ndr, const char *name, const union dfs_referral_version *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "dfs_referral_version");
	switch (level) {
		case 1:
			ndr_print_dfs_referral_v1(ndr, "v1", &r->v1);
		break;

		case 2:
			ndr_print_dfs_referral_v2(ndr, "v2", &r->v2);
		break;

		case 3:
			ndr_print_dfs_referral_v3(ndr, "v3", &r->v3);
		break;

		case 4:
			ndr_print_dfs_referral_v3(ndr, "v4", &r->v4);
		break;

		default:
		break;

	}
}

static enum ndr_err_code ndr_push_dfs_referral_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_referral_type *r)
{
	uint32_t _save_relative_base_offset = ndr_push_get_relative_base_offset(ndr);
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_setup_relative_base_offset1(ndr, r, ndr->offset));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->version));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->referral, r->version));
			NDR_CHECK(ndr_push_dfs_referral_version(ndr, NDR_SCALARS, &r->referral));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_setup_relative_base_offset2(ndr, r));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->referral, r->version));
			NDR_CHECK(ndr_push_dfs_referral_version(ndr, NDR_BUFFERS, &r->referral));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	ndr_push_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_dfs_referral_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_referral_type *r)
{
	uint32_t _save_relative_base_offset = ndr_pull_get_relative_base_offset(ndr);
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			NDR_CHECK(ndr_pull_setup_relative_base_offset1(ndr, r, ndr->offset));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->version));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->referral, r->version));
			NDR_CHECK(ndr_pull_dfs_referral_version(ndr, NDR_SCALARS, &r->referral));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_setup_relative_base_offset2(ndr, r));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->referral, r->version));
			NDR_CHECK(ndr_pull_dfs_referral_version(ndr, NDR_BUFFERS, &r->referral));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	ndr_pull_restore_relative_base_offset(ndr, _save_relative_base_offset);
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_referral_type(struct ndr_print *ndr, const char *name, const struct dfs_referral_type *r)
{
	ndr_print_struct(ndr, name, "dfs_referral_type");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint16(ndr, "version", r->version);
		ndr_print_set_switch_value(ndr, &r->referral, r->version);
		ndr_print_dfs_referral_version(ndr, "referral", &r->referral);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_referral_resp(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_referral_resp *r)
{
	uint32_t cntr_referral_entries_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->path_consumed));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->nb_referrals));
		NDR_CHECK(ndr_push_DFS_HEADER_FLAG(ndr, NDR_SCALARS, r->header_flags));
		for (cntr_referral_entries_0 = 0; cntr_referral_entries_0 < (r->nb_referrals); cntr_referral_entries_0++) {
			NDR_CHECK(ndr_push_dfs_referral_type(ndr, NDR_SCALARS, &r->referral_entries[cntr_referral_entries_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_referral_entries_0 = 0; cntr_referral_entries_0 < (r->nb_referrals); cntr_referral_entries_0++) {
			NDR_CHECK(ndr_push_dfs_referral_type(ndr, NDR_BUFFERS, &r->referral_entries[cntr_referral_entries_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_referral_resp(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_referral_resp *r)
{
	uint32_t size_referral_entries_0 = 0;
	uint32_t cntr_referral_entries_0;
	TALLOC_CTX *_mem_save_referral_entries_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->path_consumed));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->nb_referrals));
		NDR_CHECK(ndr_pull_DFS_HEADER_FLAG(ndr, NDR_SCALARS, &r->header_flags));
		size_referral_entries_0 = r->nb_referrals;
		NDR_PULL_ALLOC_N(ndr, r->referral_entries, size_referral_entries_0);
		_mem_save_referral_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->referral_entries, 0);
		for (cntr_referral_entries_0 = 0; cntr_referral_entries_0 < (size_referral_entries_0); cntr_referral_entries_0++) {
			NDR_CHECK(ndr_pull_dfs_referral_type(ndr, NDR_SCALARS, &r->referral_entries[cntr_referral_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_referral_entries_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		size_referral_entries_0 = r->nb_referrals;
		_mem_save_referral_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->referral_entries, 0);
		for (cntr_referral_entries_0 = 0; cntr_referral_entries_0 < (size_referral_entries_0); cntr_referral_entries_0++) {
			NDR_CHECK(ndr_pull_dfs_referral_type(ndr, NDR_BUFFERS, &r->referral_entries[cntr_referral_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_referral_entries_0, 0);
		for (cntr_referral_entries_0 = 0; cntr_referral_entries_0 < (size_referral_entries_0); cntr_referral_entries_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dfs_referral_resp(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dfs_referral_resp *r)
{
	ndr_print_dfs_referral_resp(ndr, name, r);
}

_PUBLIC_ void ndr_print_dfs_referral_resp(struct ndr_print *ndr, const char *name, const struct dfs_referral_resp *r)
{
	uint32_t cntr_referral_entries_0;
	ndr_print_struct(ndr, name, "dfs_referral_resp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "path_consumed", r->path_consumed);
	ndr_print_uint16(ndr, "nb_referrals", r->nb_referrals);
	ndr_print_DFS_HEADER_FLAG(ndr, "header_flags", r->header_flags);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "referral_entries", (uint32_t)(r->nb_referrals));
	ndr->depth++;
	for (cntr_referral_entries_0 = 0; cntr_referral_entries_0 < (r->nb_referrals); cntr_referral_entries_0++) {
		ndr_print_dfs_referral_type(ndr, "referral_entries", &r->referral_entries[cntr_referral_entries_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_GetDFSReferral_in(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct dfs_GetDFSReferral_in *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_referral_level));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->servername));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_GetDFSReferral_in(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct dfs_GetDFSReferral_in *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_referral_level));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->servername));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_dfs_GetDFSReferral_in(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct dfs_GetDFSReferral_in *r)
{
	ndr_print_dfs_GetDFSReferral_in(ndr, name, r);
}

_PUBLIC_ void ndr_print_dfs_GetDFSReferral_in(struct ndr_print *ndr, const char *name, const struct dfs_GetDFSReferral_in *r)
{
	ndr_print_struct(ndr, name, "dfs_GetDFSReferral_in");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "max_referral_level", r->max_referral_level);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_string(ndr, "servername", r->servername);
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_dfs_GetDFSReferral(struct ndr_push *ndr, ndr_flags_type flags, const struct dfs_GetDFSReferral *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_dfs_GetDFSReferral_in(ndr, NDR_SCALARS, &r->in.req));
	}
	if (flags & NDR_OUT) {
		if (r->out.resp == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_dfs_referral_resp(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.resp));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_dfs_GetDFSReferral(struct ndr_pull *ndr, ndr_flags_type flags, struct dfs_GetDFSReferral *r)
{
	TALLOC_CTX *_mem_save_resp_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_dfs_GetDFSReferral_in(ndr, NDR_SCALARS, &r->in.req));
		NDR_PULL_ALLOC(ndr, r->out.resp);
		NDR_ZERO_STRUCTP(r->out.resp);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.resp);
		}
		_mem_save_resp_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.resp, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_dfs_referral_resp(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.resp));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resp_0, LIBNDR_FLAG_REF_ALLOC);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_dfs_GetDFSReferral(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct dfs_GetDFSReferral *r)
{
	ndr_print_struct(ndr, name, "dfs_GetDFSReferral");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "dfs_GetDFSReferral");
		ndr->depth++;
		ndr_print_dfs_GetDFSReferral_in(ndr, "req", &r->in.req);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "dfs_GetDFSReferral");
		ndr->depth++;
		ndr_print_ptr(ndr, "resp", r->out.resp);
		ndr->depth++;
		ndr_print_dfs_referral_resp(ndr, "resp", r->out.resp);
		ndr->depth--;
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_dfsblobs
static const struct ndr_interface_public_struct dfsblobs_public_structs[] = {
	{
		.name = "dfs_referral_resp",
		.struct_size = sizeof(struct dfs_referral_resp ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dfs_referral_resp,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dfs_referral_resp,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dfs_referral_resp,
	},
	{
		.name = "dfs_GetDFSReferral_in",
		.struct_size = sizeof(struct dfs_GetDFSReferral_in ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_dfs_GetDFSReferral_in,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_dfs_GetDFSReferral_in,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_dfs_GetDFSReferral_in,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call dfsblobs_calls[] = {
	{
		"dfs_GetDFSReferral",
		sizeof(struct dfs_GetDFSReferral),
		(ndr_push_flags_fn_t) ndr_push_dfs_GetDFSReferral,
		(ndr_pull_flags_fn_t) ndr_pull_dfs_GetDFSReferral,
		(ndr_print_function_t) ndr_print_dfs_GetDFSReferral,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const dfsblobs_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\dfsblobs]", 
};

static const struct ndr_interface_string_array dfsblobs_endpoints = {
	.count	= 1,
	.names	= dfsblobs_endpoint_strings
};

static const char * const dfsblobs_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array dfsblobs_authservices = {
	.count	= 1,
	.names	= dfsblobs_authservice_strings
};


const struct ndr_interface_table ndr_table_dfsblobs = {
	.name		= "dfsblobs",
	.syntax_id	= {
		{0x12345778,0x1234,0xabcd,{0x00,0x01},{0x00,0x00,0x00,0x03}},
		NDR_DFSBLOBS_VERSION
	},
	.helpstring	= NDR_DFSBLOBS_HELPSTRING,
	.num_calls	= 1,
	.calls		= dfsblobs_calls,
	.num_public_structs	= 2,
	.public_structs		= dfsblobs_public_structs,
	.endpoints	= &dfsblobs_endpoints,
	.authservices	= &dfsblobs_authservices
};

#endif /* SKIP_NDR_TABLE_dfsblobs */
