/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_conditional_ace.h"

#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_token_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum token_type r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_token_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum token_type *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_token_type(struct ndr_print *ndr, const char *name, enum token_type r)
{
	const char *val = NULL;

	switch (r) {
		case CONDITIONAL_ACE_TOKEN_INVALID_OR_PADDING: val = "CONDITIONAL_ACE_TOKEN_INVALID_OR_PADDING"; break;
		case CONDITIONAL_ACE_TOKEN_INT8: val = "CONDITIONAL_ACE_TOKEN_INT8"; break;
		case CONDITIONAL_ACE_TOKEN_INT16: val = "CONDITIONAL_ACE_TOKEN_INT16"; break;
		case CONDITIONAL_ACE_TOKEN_INT32: val = "CONDITIONAL_ACE_TOKEN_INT32"; break;
		case CONDITIONAL_ACE_TOKEN_INT64: val = "CONDITIONAL_ACE_TOKEN_INT64"; break;
		case CONDITIONAL_ACE_TOKEN_UNICODE: val = "CONDITIONAL_ACE_TOKEN_UNICODE"; break;
		case CONDITIONAL_ACE_TOKEN_OCTET_STRING: val = "CONDITIONAL_ACE_TOKEN_OCTET_STRING"; break;
		case CONDITIONAL_ACE_TOKEN_COMPOSITE: val = "CONDITIONAL_ACE_TOKEN_COMPOSITE"; break;
		case CONDITIONAL_ACE_TOKEN_SID: val = "CONDITIONAL_ACE_TOKEN_SID"; break;
		case CONDITIONAL_ACE_LOCAL_ATTRIBUTE: val = "CONDITIONAL_ACE_LOCAL_ATTRIBUTE"; break;
		case CONDITIONAL_ACE_USER_ATTRIBUTE: val = "CONDITIONAL_ACE_USER_ATTRIBUTE"; break;
		case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE: val = "CONDITIONAL_ACE_RESOURCE_ATTRIBUTE"; break;
		case CONDITIONAL_ACE_DEVICE_ATTRIBUTE: val = "CONDITIONAL_ACE_DEVICE_ATTRIBUTE"; break;
		case CONDITIONAL_ACE_TOKEN_MEMBER_OF: val = "CONDITIONAL_ACE_TOKEN_MEMBER_OF"; break;
		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF: val = "CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF"; break;
		case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY: val = "CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY"; break;
		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY: val = "CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF: val = "CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF: val = "CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY: val = "CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY: val = "CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY"; break;
		case CONDITIONAL_ACE_TOKEN_EQUAL: val = "CONDITIONAL_ACE_TOKEN_EQUAL"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_EQUAL: val = "CONDITIONAL_ACE_TOKEN_NOT_EQUAL"; break;
		case CONDITIONAL_ACE_TOKEN_LESS_THAN: val = "CONDITIONAL_ACE_TOKEN_LESS_THAN"; break;
		case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL: val = "CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL"; break;
		case CONDITIONAL_ACE_TOKEN_GREATER_THAN: val = "CONDITIONAL_ACE_TOKEN_GREATER_THAN"; break;
		case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL: val = "CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL"; break;
		case CONDITIONAL_ACE_TOKEN_CONTAINS: val = "CONDITIONAL_ACE_TOKEN_CONTAINS"; break;
		case CONDITIONAL_ACE_TOKEN_ANY_OF: val = "CONDITIONAL_ACE_TOKEN_ANY_OF"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS: val = "CONDITIONAL_ACE_TOKEN_NOT_CONTAINS"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF: val = "CONDITIONAL_ACE_TOKEN_NOT_ANY_OF"; break;
		case CONDITIONAL_ACE_TOKEN_EXISTS: val = "CONDITIONAL_ACE_TOKEN_EXISTS"; break;
		case CONDITIONAL_ACE_TOKEN_NOT_EXISTS: val = "CONDITIONAL_ACE_TOKEN_NOT_EXISTS"; break;
		case CONDITIONAL_ACE_TOKEN_NOT: val = "CONDITIONAL_ACE_TOKEN_NOT"; break;
		case CONDITIONAL_ACE_TOKEN_AND: val = "CONDITIONAL_ACE_TOKEN_AND"; break;
		case CONDITIONAL_ACE_TOKEN_OR: val = "CONDITIONAL_ACE_TOKEN_OR"; break;
		case CONDITIONAL_ACE_SAMBA_RESULT_BOOL: val = "CONDITIONAL_ACE_SAMBA_RESULT_BOOL"; break;
		case CONDITIONAL_ACE_SAMBA_RESULT_NULL: val = "CONDITIONAL_ACE_SAMBA_RESULT_NULL"; break;
		case CONDITIONAL_ACE_SAMBA_RESULT_ERROR: val = "CONDITIONAL_ACE_SAMBA_RESULT_ERROR"; break;
		case CONDITIONAL_ACE_SAMBA_SDDL_PAREN: val = "CONDITIONAL_ACE_SAMBA_SDDL_PAREN"; break;
		case CONDITIONAL_ACE_SAMBA_SDDL_PAREN_END: val = "CONDITIONAL_ACE_SAMBA_SDDL_PAREN_END"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ace_condition_result(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_result *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_int64(ndr, NDR_SCALARS, r->value));
			NDR_CHECK(ndr_push_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ace_condition_result(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_result *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			NDR_CHECK(ndr_pull_int64(ndr, NDR_SCALARS, &r->value));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ace_condition_result(struct ndr_print *ndr, const char *name, const struct ace_condition_result *r)
{
	ndr_print_struct(ndr, name, "ace_condition_result");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_int64(ndr, "value", r->value);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_ace_condition_int(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_int *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_int64(ndr, NDR_SCALARS, r->value));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sign));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->base));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ace_condition_int(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_int *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_int64(ndr, NDR_SCALARS, &r->value));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sign));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->base));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ace_condition_int(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ace_condition_int *r)
{
	ndr_print_ace_condition_int(ndr, name, r);
}

_PUBLIC_ void ndr_print_ace_condition_int(struct ndr_print *ndr, const char *name, const struct ace_condition_int *r)
{
	ndr_print_struct(ndr, name, "ace_condition_int");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_int64(ndr, "value", r->value);
	ndr_print_uint8(ndr, "sign", r->sign);
	ndr_print_uint8(ndr, "base", r->base);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ace_condition_unicode(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_unicode *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_BYTESIZE|LIBNDR_FLAG_STR_NO_EMBEDDED_NUL);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->value));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ace_condition_unicode(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_unicode *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_BYTESIZE|LIBNDR_FLAG_STR_NO_EMBEDDED_NUL);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->value));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ace_condition_unicode(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ace_condition_unicode *r)
{
	ndr_print_ace_condition_unicode(ndr, name, r);
}

_PUBLIC_ void ndr_print_ace_condition_unicode(struct ndr_print *ndr, const char *name, const struct ace_condition_unicode *r)
{
	ndr_print_struct(ndr, name, "ace_condition_unicode");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_BYTESIZE|LIBNDR_FLAG_STR_NO_EMBEDDED_NUL);
		ndr_print_string(ndr, "value", r->value);
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ace_condition_sid(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_sid *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_sid;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_sid, 4, -1));
			NDR_CHECK(ndr_push_dom_sid(_ndr_sid, NDR_SCALARS, &r->sid));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_sid, 4, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ace_condition_sid(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_sid *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_sid;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_sid, 4, sub_size));
			NDR_CHECK(ndr_pull_dom_sid(_ndr_sid, NDR_SCALARS, &r->sid));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_sid, 4, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ace_condition_sid(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ace_condition_sid *r)
{
	ndr_print_ace_condition_sid(ndr, name, r);
}

_PUBLIC_ void ndr_print_ace_condition_sid(struct ndr_print *ndr, const char *name, const struct ace_condition_sid *r)
{
	ndr_print_struct(ndr, name, "ace_condition_sid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ace_condition_composite(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_composite *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->tokens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->n_members));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tokens) {
			NDR_CHECK(ndr_push_ace_condition_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->tokens));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ace_condition_composite(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_composite *r)
{
	uint32_t _ptr_tokens;
	TALLOC_CTX *_mem_save_tokens_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tokens));
		if (_ptr_tokens) {
			NDR_PULL_ALLOC(ndr, r->tokens);
		} else {
			r->tokens = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->n_members));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tokens) {
			_mem_save_tokens_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tokens, 0);
			NDR_CHECK(ndr_pull_ace_condition_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->tokens));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tokens_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ace_condition_composite(struct ndr_print *ndr, const char *name, const struct ace_condition_composite *r)
{
	ndr_print_struct(ndr, name, "ace_condition_composite");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "tokens", r->tokens);
	ndr->depth++;
	if (r->tokens) {
		ndr_print_ace_condition_token(ndr, "tokens", r->tokens);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "n_members", r->n_members);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ace_condition_op(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_op *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sddl_position));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ace_condition_op(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_op *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sddl_position));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ace_condition_op(struct ndr_print *ndr, const char *name, const struct ace_condition_op *r)
{
	ndr_print_struct(ndr, name, "ace_condition_op");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sddl_position", r->sddl_position);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ace_condition_sddl_op(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_sddl_op *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->start));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->position));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ace_condition_sddl_op(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_sddl_op *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->start));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->position));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ace_condition_sddl_op(struct ndr_print *ndr, const char *name, const struct ace_condition_sddl_op *r)
{
	ndr_print_struct(ndr, name, "ace_condition_sddl_op");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "start", r->start);
	ndr_print_uint32(ndr, "position", r->position);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ace_condition_token_data(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ace_condition_token_data *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 8));
		switch (level) {
			case CONDITIONAL_ACE_TOKEN_SID: {
				NDR_CHECK(ndr_push_ace_condition_sid(ndr, NDR_SCALARS, &r->sid));
			break; }

			case CONDITIONAL_ACE_TOKEN_COMPOSITE: {
				NDR_CHECK(ndr_push_ace_condition_composite(ndr, NDR_SCALARS, &r->composite));
			break; }

			case CONDITIONAL_ACE_TOKEN_OCTET_STRING: {
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->bytes));
			break; }

			case CONDITIONAL_ACE_TOKEN_UNICODE: {
				NDR_CHECK(ndr_push_ace_condition_unicode(ndr, NDR_SCALARS, &r->unicode));
			break; }

			case CONDITIONAL_ACE_LOCAL_ATTRIBUTE: {
				NDR_CHECK(ndr_push_ace_condition_unicode(ndr, NDR_SCALARS, &r->local_attr));
			break; }

			case CONDITIONAL_ACE_USER_ATTRIBUTE: {
				NDR_CHECK(ndr_push_ace_condition_unicode(ndr, NDR_SCALARS, &r->user_attr));
			break; }

			case CONDITIONAL_ACE_DEVICE_ATTRIBUTE: {
				NDR_CHECK(ndr_push_ace_condition_unicode(ndr, NDR_SCALARS, &r->device_attr));
			break; }

			case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE: {
				NDR_CHECK(ndr_push_ace_condition_unicode(ndr, NDR_SCALARS, &r->resource_attr));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT64: {
				NDR_CHECK(ndr_push_ace_condition_int(ndr, NDR_SCALARS, &r->int64));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT32: {
				NDR_CHECK(ndr_push_ace_condition_int(ndr, NDR_SCALARS, &r->int32));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT16: {
				NDR_CHECK(ndr_push_ace_condition_int(ndr, NDR_SCALARS, &r->int16));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT8: {
				NDR_CHECK(ndr_push_ace_condition_int(ndr, NDR_SCALARS, &r->int8));
			break; }

			case CONDITIONAL_ACE_SAMBA_SDDL_PAREN: {
				NDR_CHECK(ndr_push_ace_condition_sddl_op(ndr, NDR_SCALARS, &r->sddl_op));
			break; }

			case CONDITIONAL_ACE_SAMBA_RESULT_BOOL: {
				NDR_CHECK(ndr_push_ace_condition_result(ndr, NDR_SCALARS, &r->result));
			break; }

			case CONDITIONAL_ACE_SAMBA_RESULT_NULL: {
				NDR_CHECK(ndr_push_ace_condition_result(ndr, NDR_SCALARS, &r->result_null));
			break; }

			case CONDITIONAL_ACE_SAMBA_RESULT_ERROR: {
				NDR_CHECK(ndr_push_ace_condition_result(ndr, NDR_SCALARS, &r->result_error));
			break; }

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->device_member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->device_member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_device_member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_device_member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_EQUAL: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_EQUAL: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_LESS_THAN: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->less_than));
			break; }

			case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->less_or_equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_GREATER_THAN: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->greater_than));
			break; }

			case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->greater_or_equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_CONTAINS: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->contains));
			break; }

			case CONDITIONAL_ACE_TOKEN_ANY_OF: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->any_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_contains));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_any_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_AND: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->and));
			break; }

			case CONDITIONAL_ACE_TOKEN_OR: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->or));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not));
			break; }

			case CONDITIONAL_ACE_TOKEN_EXISTS: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->exists));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_EXISTS: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->not_exists));
			break; }

			default: {
				NDR_CHECK(ndr_push_ace_condition_op(ndr, NDR_SCALARS, &r->op));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case CONDITIONAL_ACE_TOKEN_SID:
			break;

			case CONDITIONAL_ACE_TOKEN_COMPOSITE:
				NDR_CHECK(ndr_push_ace_condition_composite(ndr, NDR_BUFFERS, &r->composite));
			break;

			case CONDITIONAL_ACE_TOKEN_OCTET_STRING:
			break;

			case CONDITIONAL_ACE_TOKEN_UNICODE:
			break;

			case CONDITIONAL_ACE_LOCAL_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_USER_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_DEVICE_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_TOKEN_INT64:
			break;

			case CONDITIONAL_ACE_TOKEN_INT32:
			break;

			case CONDITIONAL_ACE_TOKEN_INT16:
			break;

			case CONDITIONAL_ACE_TOKEN_INT8:
			break;

			case CONDITIONAL_ACE_SAMBA_SDDL_PAREN:
			break;

			case CONDITIONAL_ACE_SAMBA_RESULT_BOOL:
			break;

			case CONDITIONAL_ACE_SAMBA_RESULT_NULL:
			break;

			case CONDITIONAL_ACE_SAMBA_RESULT_ERROR:
			break;

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_LESS_THAN:
			break;

			case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_GREATER_THAN:
			break;

			case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_CONTAINS:
			break;

			case CONDITIONAL_ACE_TOKEN_ANY_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_AND:
			break;

			case CONDITIONAL_ACE_TOKEN_OR:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT:
			break;

			case CONDITIONAL_ACE_TOKEN_EXISTS:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_EXISTS:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ace_condition_token_data(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ace_condition_token_data *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 8));
		switch (level) {
			case CONDITIONAL_ACE_TOKEN_SID: {
				NDR_CHECK(ndr_pull_ace_condition_sid(ndr, NDR_SCALARS, &r->sid));
			break; }

			case CONDITIONAL_ACE_TOKEN_COMPOSITE: {
				NDR_CHECK(ndr_pull_ace_condition_composite(ndr, NDR_SCALARS, &r->composite));
			break; }

			case CONDITIONAL_ACE_TOKEN_OCTET_STRING: {
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->bytes));
			break; }

			case CONDITIONAL_ACE_TOKEN_UNICODE: {
				NDR_CHECK(ndr_pull_ace_condition_unicode(ndr, NDR_SCALARS, &r->unicode));
			break; }

			case CONDITIONAL_ACE_LOCAL_ATTRIBUTE: {
				NDR_CHECK(ndr_pull_ace_condition_unicode(ndr, NDR_SCALARS, &r->local_attr));
			break; }

			case CONDITIONAL_ACE_USER_ATTRIBUTE: {
				NDR_CHECK(ndr_pull_ace_condition_unicode(ndr, NDR_SCALARS, &r->user_attr));
			break; }

			case CONDITIONAL_ACE_DEVICE_ATTRIBUTE: {
				NDR_CHECK(ndr_pull_ace_condition_unicode(ndr, NDR_SCALARS, &r->device_attr));
			break; }

			case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE: {
				NDR_CHECK(ndr_pull_ace_condition_unicode(ndr, NDR_SCALARS, &r->resource_attr));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT64: {
				NDR_CHECK(ndr_pull_ace_condition_int(ndr, NDR_SCALARS, &r->int64));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT32: {
				NDR_CHECK(ndr_pull_ace_condition_int(ndr, NDR_SCALARS, &r->int32));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT16: {
				NDR_CHECK(ndr_pull_ace_condition_int(ndr, NDR_SCALARS, &r->int16));
			break; }

			case CONDITIONAL_ACE_TOKEN_INT8: {
				NDR_CHECK(ndr_pull_ace_condition_int(ndr, NDR_SCALARS, &r->int8));
			break; }

			case CONDITIONAL_ACE_SAMBA_SDDL_PAREN: {
				NDR_CHECK(ndr_pull_ace_condition_sddl_op(ndr, NDR_SCALARS, &r->sddl_op));
			break; }

			case CONDITIONAL_ACE_SAMBA_RESULT_BOOL: {
				NDR_CHECK(ndr_pull_ace_condition_result(ndr, NDR_SCALARS, &r->result));
			break; }

			case CONDITIONAL_ACE_SAMBA_RESULT_NULL: {
				NDR_CHECK(ndr_pull_ace_condition_result(ndr, NDR_SCALARS, &r->result_null));
			break; }

			case CONDITIONAL_ACE_SAMBA_RESULT_ERROR: {
				NDR_CHECK(ndr_pull_ace_condition_result(ndr, NDR_SCALARS, &r->result_error));
			break; }

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->device_member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->device_member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_device_member_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_device_member_of_any));
			break; }

			case CONDITIONAL_ACE_TOKEN_EQUAL: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_EQUAL: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_LESS_THAN: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->less_than));
			break; }

			case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->less_or_equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_GREATER_THAN: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->greater_than));
			break; }

			case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->greater_or_equal));
			break; }

			case CONDITIONAL_ACE_TOKEN_CONTAINS: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->contains));
			break; }

			case CONDITIONAL_ACE_TOKEN_ANY_OF: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->any_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_contains));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_any_of));
			break; }

			case CONDITIONAL_ACE_TOKEN_AND: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->and));
			break; }

			case CONDITIONAL_ACE_TOKEN_OR: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->or));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not));
			break; }

			case CONDITIONAL_ACE_TOKEN_EXISTS: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->exists));
			break; }

			case CONDITIONAL_ACE_TOKEN_NOT_EXISTS: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->not_exists));
			break; }

			default: {
				NDR_CHECK(ndr_pull_ace_condition_op(ndr, NDR_SCALARS, &r->op));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case CONDITIONAL_ACE_TOKEN_SID:
			break;

			case CONDITIONAL_ACE_TOKEN_COMPOSITE:
				NDR_CHECK(ndr_pull_ace_condition_composite(ndr, NDR_BUFFERS, &r->composite));
			break;

			case CONDITIONAL_ACE_TOKEN_OCTET_STRING:
			break;

			case CONDITIONAL_ACE_TOKEN_UNICODE:
			break;

			case CONDITIONAL_ACE_LOCAL_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_USER_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_DEVICE_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE:
			break;

			case CONDITIONAL_ACE_TOKEN_INT64:
			break;

			case CONDITIONAL_ACE_TOKEN_INT32:
			break;

			case CONDITIONAL_ACE_TOKEN_INT16:
			break;

			case CONDITIONAL_ACE_TOKEN_INT8:
			break;

			case CONDITIONAL_ACE_SAMBA_SDDL_PAREN:
			break;

			case CONDITIONAL_ACE_SAMBA_RESULT_BOOL:
			break;

			case CONDITIONAL_ACE_SAMBA_RESULT_NULL:
			break;

			case CONDITIONAL_ACE_SAMBA_RESULT_ERROR:
			break;

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY:
			break;

			case CONDITIONAL_ACE_TOKEN_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_LESS_THAN:
			break;

			case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_GREATER_THAN:
			break;

			case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL:
			break;

			case CONDITIONAL_ACE_TOKEN_CONTAINS:
			break;

			case CONDITIONAL_ACE_TOKEN_ANY_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF:
			break;

			case CONDITIONAL_ACE_TOKEN_AND:
			break;

			case CONDITIONAL_ACE_TOKEN_OR:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT:
			break;

			case CONDITIONAL_ACE_TOKEN_EXISTS:
			break;

			case CONDITIONAL_ACE_TOKEN_NOT_EXISTS:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ace_condition_token_data(struct ndr_print *ndr, const char *name, const union ace_condition_token_data *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "ace_condition_token_data");
	switch (level) {
		case CONDITIONAL_ACE_TOKEN_SID:
			ndr_print_ace_condition_sid(ndr, "sid", &r->sid);
		break;

		case CONDITIONAL_ACE_TOKEN_COMPOSITE:
			ndr_print_ace_condition_composite(ndr, "composite", &r->composite);
		break;

		case CONDITIONAL_ACE_TOKEN_OCTET_STRING:
			ndr_print_DATA_BLOB(ndr, "bytes", r->bytes);
		break;

		case CONDITIONAL_ACE_TOKEN_UNICODE:
			ndr_print_ace_condition_unicode(ndr, "unicode", &r->unicode);
		break;

		case CONDITIONAL_ACE_LOCAL_ATTRIBUTE:
			ndr_print_ace_condition_unicode(ndr, "local_attr", &r->local_attr);
		break;

		case CONDITIONAL_ACE_USER_ATTRIBUTE:
			ndr_print_ace_condition_unicode(ndr, "user_attr", &r->user_attr);
		break;

		case CONDITIONAL_ACE_DEVICE_ATTRIBUTE:
			ndr_print_ace_condition_unicode(ndr, "device_attr", &r->device_attr);
		break;

		case CONDITIONAL_ACE_RESOURCE_ATTRIBUTE:
			ndr_print_ace_condition_unicode(ndr, "resource_attr", &r->resource_attr);
		break;

		case CONDITIONAL_ACE_TOKEN_INT64:
			ndr_print_ace_condition_int(ndr, "int64", &r->int64);
		break;

		case CONDITIONAL_ACE_TOKEN_INT32:
			ndr_print_ace_condition_int(ndr, "int32", &r->int32);
		break;

		case CONDITIONAL_ACE_TOKEN_INT16:
			ndr_print_ace_condition_int(ndr, "int16", &r->int16);
		break;

		case CONDITIONAL_ACE_TOKEN_INT8:
			ndr_print_ace_condition_int(ndr, "int8", &r->int8);
		break;

		case CONDITIONAL_ACE_SAMBA_SDDL_PAREN:
			ndr_print_ace_condition_sddl_op(ndr, "sddl_op", &r->sddl_op);
		break;

		case CONDITIONAL_ACE_SAMBA_RESULT_BOOL:
			ndr_print_ace_condition_result(ndr, "result", &r->result);
		break;

		case CONDITIONAL_ACE_SAMBA_RESULT_NULL:
			ndr_print_ace_condition_result(ndr, "result_null", &r->result_null);
		break;

		case CONDITIONAL_ACE_SAMBA_RESULT_ERROR:
			ndr_print_ace_condition_result(ndr, "result_error", &r->result_error);
		break;

		case CONDITIONAL_ACE_TOKEN_MEMBER_OF:
			ndr_print_ace_condition_op(ndr, "member_of", &r->member_of);
		break;

		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF:
			ndr_print_ace_condition_op(ndr, "device_member_of", &r->device_member_of);
		break;

		case CONDITIONAL_ACE_TOKEN_MEMBER_OF_ANY:
			ndr_print_ace_condition_op(ndr, "member_of_any", &r->member_of_any);
		break;

		case CONDITIONAL_ACE_TOKEN_DEVICE_MEMBER_OF_ANY:
			ndr_print_ace_condition_op(ndr, "device_member_of_any", &r->device_member_of_any);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF:
			ndr_print_ace_condition_op(ndr, "not_member_of", &r->not_member_of);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF:
			ndr_print_ace_condition_op(ndr, "not_device_member_of", &r->not_device_member_of);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_MEMBER_OF_ANY:
			ndr_print_ace_condition_op(ndr, "not_member_of_any", &r->not_member_of_any);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_DEVICE_MEMBER_OF_ANY:
			ndr_print_ace_condition_op(ndr, "not_device_member_of_any", &r->not_device_member_of_any);
		break;

		case CONDITIONAL_ACE_TOKEN_EQUAL:
			ndr_print_ace_condition_op(ndr, "equal", &r->equal);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_EQUAL:
			ndr_print_ace_condition_op(ndr, "not_equal", &r->not_equal);
		break;

		case CONDITIONAL_ACE_TOKEN_LESS_THAN:
			ndr_print_ace_condition_op(ndr, "less_than", &r->less_than);
		break;

		case CONDITIONAL_ACE_TOKEN_LESS_OR_EQUAL:
			ndr_print_ace_condition_op(ndr, "less_or_equal", &r->less_or_equal);
		break;

		case CONDITIONAL_ACE_TOKEN_GREATER_THAN:
			ndr_print_ace_condition_op(ndr, "greater_than", &r->greater_than);
		break;

		case CONDITIONAL_ACE_TOKEN_GREATER_OR_EQUAL:
			ndr_print_ace_condition_op(ndr, "greater_or_equal", &r->greater_or_equal);
		break;

		case CONDITIONAL_ACE_TOKEN_CONTAINS:
			ndr_print_ace_condition_op(ndr, "contains", &r->contains);
		break;

		case CONDITIONAL_ACE_TOKEN_ANY_OF:
			ndr_print_ace_condition_op(ndr, "any_of", &r->any_of);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_CONTAINS:
			ndr_print_ace_condition_op(ndr, "not_contains", &r->not_contains);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_ANY_OF:
			ndr_print_ace_condition_op(ndr, "not_any_of", &r->not_any_of);
		break;

		case CONDITIONAL_ACE_TOKEN_AND:
			ndr_print_ace_condition_op(ndr, "and", &r->and);
		break;

		case CONDITIONAL_ACE_TOKEN_OR:
			ndr_print_ace_condition_op(ndr, "or", &r->or);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT:
			ndr_print_ace_condition_op(ndr, "not", &r->not);
		break;

		case CONDITIONAL_ACE_TOKEN_EXISTS:
			ndr_print_ace_condition_op(ndr, "exists", &r->exists);
		break;

		case CONDITIONAL_ACE_TOKEN_NOT_EXISTS:
			ndr_print_ace_condition_op(ndr, "not_exists", &r->not_exists);
		break;

		default:
			ndr_print_ace_condition_op(ndr, "op", &r->op);
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_ace_condition_token(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_token *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->type));
		NDR_CHECK(ndr_push_ace_condition_token_data(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_token_type(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->data, r->type));
		NDR_CHECK(ndr_push_ace_condition_token_data(ndr, NDR_BUFFERS, &r->data));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ace_condition_token(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_token *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->type));
		NDR_CHECK(ndr_pull_ace_condition_token_data(ndr, NDR_SCALARS, &r->data));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_token_type(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->data, r->type));
		NDR_CHECK(ndr_pull_ace_condition_token_data(ndr, NDR_BUFFERS, &r->data));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ace_condition_token(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ace_condition_token *r)
{
	ndr_print_ace_condition_token(ndr, name, r);
}

_PUBLIC_ void ndr_print_ace_condition_token(struct ndr_print *ndr, const char *name, const struct ace_condition_token *r)
{
	ndr_print_struct(ndr, name, "ace_condition_token");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_set_switch_value(ndr, &r->data, r->type);
	ndr_print_ace_condition_token_data(ndr, "data", &r->data);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_token_type(ndr, "type", r->type);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ace_condition_script(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ace_condition_script *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->tokens));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->stack));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->length));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tokens) {
			NDR_CHECK(ndr_push_ace_condition_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->tokens));
		}
		if (r->stack) {
			NDR_CHECK(ndr_push_ace_condition_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->stack));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ace_condition_script(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ace_condition_script *r)
{
	uint32_t _ptr_tokens;
	TALLOC_CTX *_mem_save_tokens_0 = NULL;
	uint32_t _ptr_stack;
	TALLOC_CTX *_mem_save_stack_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tokens));
		if (_ptr_tokens) {
			NDR_PULL_ALLOC(ndr, r->tokens);
		} else {
			r->tokens = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_stack));
		if (_ptr_stack) {
			NDR_PULL_ALLOC(ndr, r->stack);
		} else {
			r->stack = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->tokens) {
			_mem_save_tokens_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->tokens, 0);
			NDR_CHECK(ndr_pull_ace_condition_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->tokens));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tokens_0, 0);
		}
		if (r->stack) {
			_mem_save_stack_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->stack, 0);
			NDR_CHECK(ndr_pull_ace_condition_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->stack));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_stack_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ace_condition_script(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ace_condition_script *r)
{
	ndr_print_ace_condition_script(ndr, name, r);
}

_PUBLIC_ void ndr_print_ace_condition_script(struct ndr_print *ndr, const char *name, const struct ace_condition_script *r)
{
	ndr_print_struct(ndr, name, "ace_condition_script");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "tokens", r->tokens);
	ndr->depth++;
	if (r->tokens) {
		ndr_print_ace_condition_token(ndr, "tokens", r->tokens);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "stack", r->stack);
	ndr->depth++;
	if (r->stack) {
		ndr_print_ace_condition_token(ndr, "stack", r->stack);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "length", r->length);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_conditional_ace
static const struct ndr_interface_public_struct conditional_ace_public_structs[] = {
	{
		.name = "ace_condition_int",
		.struct_size = sizeof(struct ace_condition_int ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ace_condition_int,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ace_condition_int,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ace_condition_int,
	},
	{
		.name = "ace_condition_unicode",
		.struct_size = sizeof(struct ace_condition_unicode ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ace_condition_unicode,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ace_condition_unicode,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ace_condition_unicode,
	},
	{
		.name = "ace_condition_sid",
		.struct_size = sizeof(struct ace_condition_sid ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ace_condition_sid,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ace_condition_sid,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ace_condition_sid,
	},
	{
		.name = "ace_condition_token",
		.struct_size = sizeof(struct ace_condition_token ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ace_condition_token,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ace_condition_token,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ace_condition_token,
	},
	{
		.name = "ace_condition_script",
		.struct_size = sizeof(struct ace_condition_script ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ace_condition_script,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ace_condition_script,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ace_condition_script,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call conditional_ace_calls[] = {
	{ .name = NULL }
};

static const char * const conditional_ace_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\conditional_ace]", 
};

static const struct ndr_interface_string_array conditional_ace_endpoints = {
	.count	= 1,
	.names	= conditional_ace_endpoint_strings
};

static const char * const conditional_ace_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array conditional_ace_authservices = {
	.count	= 1,
	.names	= conditional_ace_authservice_strings
};


const struct ndr_interface_table ndr_table_conditional_ace = {
	.name		= "conditional_ace",
	.num_calls	= 0,
	.calls		= conditional_ace_calls,
	.num_public_structs	= 5,
	.public_structs		= conditional_ace_public_structs,
	.endpoints	= &conditional_ace_endpoints,
	.authservices	= &conditional_ace_authservices
};

#endif /* SKIP_NDR_TABLE_conditional_ace */
