/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_claims.h"

#include "librpc/ndr/ndr_compression.h"
static enum ndr_err_code ndr_push_CLAIM_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CLAIM_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIM_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CLAIM_TYPE *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIM_TYPE(struct ndr_print *ndr, const char *name, enum CLAIM_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case CLAIM_TYPE_INT64: val = "CLAIM_TYPE_INT64"; break;
		case CLAIM_TYPE_UINT64: val = "CLAIM_TYPE_UINT64"; break;
		case CLAIM_TYPE_STRING: val = "CLAIM_TYPE_STRING"; break;
		case CLAIM_TYPE_BOOLEAN: val = "CLAIM_TYPE_BOOLEAN"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_CLAIMS_SOURCE_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CLAIMS_SOURCE_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIMS_SOURCE_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CLAIMS_SOURCE_TYPE *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIMS_SOURCE_TYPE(struct ndr_print *ndr, const char *name, enum CLAIMS_SOURCE_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case CLAIMS_SOURCE_TYPE_AD: val = "CLAIMS_SOURCE_TYPE_AD"; break;
		case CLAIMS_SOURCE_TYPE_CERTIFICATE: val = "CLAIMS_SOURCE_TYPE_CERTIFICATE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_CLAIMS_COMPRESSION_FORMAT(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum CLAIMS_COMPRESSION_FORMAT r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIMS_COMPRESSION_FORMAT(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum CLAIMS_COMPRESSION_FORMAT *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIMS_COMPRESSION_FORMAT(struct ndr_print *ndr, const char *name, enum CLAIMS_COMPRESSION_FORMAT r)
{
	const char *val = NULL;

	switch (r) {
		case CLAIMS_COMPRESSION_FORMAT_NONE: val = "CLAIMS_COMPRESSION_FORMAT_NONE"; break;
		case CLAIMS_COMPRESSION_FORMAT_LZNT1: val = "CLAIMS_COMPRESSION_FORMAT_LZNT1"; break;
		case CLAIMS_COMPRESSION_FORMAT_XPRESS: val = "CLAIMS_COMPRESSION_FORMAT_XPRESS"; break;
		case CLAIMS_COMPRESSION_FORMAT_XPRESS_HUFF: val = "CLAIMS_COMPRESSION_FORMAT_XPRESS_HUFF"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_CLAIM_INT64(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIM_INT64 *r)
{
	uint32_t cntr_values_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->values));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->value_count));
			for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
				NDR_CHECK(ndr_push_int64(ndr, NDR_SCALARS, r->values[cntr_values_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIM_INT64(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIM_INT64 *r)
{
	uint32_t _ptr_values;
	uint32_t size_values_1 = 0;
	uint32_t cntr_values_1;
	TALLOC_CTX *_mem_save_values_0 = NULL;
	TALLOC_CTX *_mem_save_values_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value_count));
		if (r->value_count > 10*1024*1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->value_count), (uint32_t)(0), (uint32_t)(10*1024*1024));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_values));
		if (_ptr_values) {
			NDR_PULL_ALLOC(ndr, r->values);
		} else {
			r->values = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->values));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->values, &size_values_1));
			NDR_PULL_ALLOC_N(ndr, r->values, size_values_1);
			_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
				NDR_CHECK(ndr_pull_int64(ndr, NDR_SCALARS, &r->values[cntr_values_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, 0);
		}
		if (r->values) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->values, r->value_count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIM_INT64(struct ndr_print *ndr, const char *name, const struct CLAIM_INT64 *r)
{
	uint32_t cntr_values_1;
	ndr_print_struct(ndr, name, "CLAIM_INT64");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "value_count", r->value_count);
	ndr_print_ptr(ndr, "values", r->values);
	ndr->depth++;
	if (r->values) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "values", (uint32_t)(r->value_count));
		ndr->depth++;
		for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
			ndr_print_int64(ndr, "values", r->values[cntr_values_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLAIM_UINT64(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIM_UINT64 *r)
{
	uint32_t cntr_values_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->values));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->value_count));
			for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
				NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->values[cntr_values_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIM_UINT64(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIM_UINT64 *r)
{
	uint32_t _ptr_values;
	uint32_t size_values_1 = 0;
	uint32_t cntr_values_1;
	TALLOC_CTX *_mem_save_values_0 = NULL;
	TALLOC_CTX *_mem_save_values_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value_count));
		if (r->value_count > 10*1024*1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->value_count), (uint32_t)(0), (uint32_t)(10*1024*1024));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_values));
		if (_ptr_values) {
			NDR_PULL_ALLOC(ndr, r->values);
		} else {
			r->values = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->values));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->values, &size_values_1));
			NDR_PULL_ALLOC_N(ndr, r->values, size_values_1);
			_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
				NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->values[cntr_values_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, 0);
		}
		if (r->values) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->values, r->value_count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIM_UINT64(struct ndr_print *ndr, const char *name, const struct CLAIM_UINT64 *r)
{
	uint32_t cntr_values_1;
	ndr_print_struct(ndr, name, "CLAIM_UINT64");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "value_count", r->value_count);
	ndr_print_ptr(ndr, "values", r->values);
	ndr->depth++;
	if (r->values) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "values", (uint32_t)(r->value_count));
		ndr->depth++;
		for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
			ndr_print_hyper(ndr, "values", r->values[cntr_values_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLAIM_STRING(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIM_STRING *r)
{
	uint32_t cntr_values_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->values));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->value_count));
			for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->values[cntr_values_1]));
			}
			for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
				if (r->values[cntr_values_1]) {
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->values[cntr_values_1], CH_UTF16)));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
					NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->values[cntr_values_1], CH_UTF16)));
					NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->values[cntr_values_1], ndr_charset_length(r->values[cntr_values_1], CH_UTF16), sizeof(uint16_t), CH_UTF16));
				}
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIM_STRING(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIM_STRING *r)
{
	uint32_t _ptr_values;
	uint32_t size_values_1 = 0;
	uint32_t cntr_values_1;
	uint32_t size_values_3 = 0;
	uint32_t length_values_3 = 0;
	TALLOC_CTX *_mem_save_values_0 = NULL;
	TALLOC_CTX *_mem_save_values_1 = NULL;
	TALLOC_CTX *_mem_save_values_2 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value_count));
		if (r->value_count > 10*1024*1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->value_count), (uint32_t)(0), (uint32_t)(10*1024*1024));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_values));
		if (_ptr_values) {
			NDR_PULL_ALLOC(ndr, r->values);
		} else {
			r->values = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->values) {
			_mem_save_values_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->values));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->values, &size_values_1));
			NDR_PULL_ALLOC_N(ndr, r->values, size_values_1);
			_mem_save_values_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->values, 0);
			for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_values));
				if (_ptr_values) {
					NDR_PULL_ALLOC(ndr, r->values[cntr_values_1]);
				} else {
					r->values[cntr_values_1] = NULL;
				}
			}
			for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
				if (r->values[cntr_values_1]) {
					_mem_save_values_2 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->values[cntr_values_1], 0);
					NDR_CHECK(ndr_pull_array_size(ndr, &r->values[cntr_values_1]));
					NDR_CHECK(ndr_pull_array_length(ndr, &r->values[cntr_values_1]));
					NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->values[cntr_values_1], &size_values_3));
					NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->values[cntr_values_1], &length_values_3));
					if (length_values_3 > size_values_3) {
						return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_values_3, length_values_3);
					}
					NDR_CHECK(ndr_check_string_terminator(ndr, length_values_3, sizeof(uint16_t)));
					NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->values[cntr_values_1], length_values_3, sizeof(uint16_t), CH_UTF16));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_2, 0);
				}
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_values_0, 0);
		}
		if (r->values) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->values, r->value_count));
		}
		for (cntr_values_1 = 0; cntr_values_1 < (size_values_1); cntr_values_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIM_STRING(struct ndr_print *ndr, const char *name, const struct CLAIM_STRING *r)
{
	uint32_t cntr_values_1;
	ndr_print_struct(ndr, name, "CLAIM_STRING");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "value_count", r->value_count);
	ndr_print_ptr(ndr, "values", r->values);
	ndr->depth++;
	if (r->values) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "values", (uint32_t)(r->value_count));
		ndr->depth++;
		for (cntr_values_1 = 0; cntr_values_1 < (r->value_count); cntr_values_1++) {
			ndr_print_ptr(ndr, "values", r->values[cntr_values_1]);
			ndr->depth++;
			if (r->values[cntr_values_1]) {
				ndr_print_string(ndr, "values", r->values[cntr_values_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLAIM_ENTRY_VALUES(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union CLAIM_ENTRY_VALUES *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 5));
			NDR_CHECK(ndr_push_CLAIM_TYPE(ndr, NDR_SCALARS, level));
			NDR_CHECK(ndr_push_union_align(ndr, 5));
			switch (level) {
				case CLAIM_TYPE_INT64: {
					NDR_CHECK(ndr_push_CLAIM_INT64(ndr, NDR_SCALARS, &r->claim_int64));
				break; }

				case CLAIM_TYPE_UINT64: {
					NDR_CHECK(ndr_push_CLAIM_UINT64(ndr, NDR_SCALARS, &r->claim_uint64));
				break; }

				case CLAIM_TYPE_STRING: {
					NDR_CHECK(ndr_push_CLAIM_STRING(ndr, NDR_SCALARS, &r->claim_string));
				break; }

				case CLAIM_TYPE_BOOLEAN: {
					NDR_CHECK(ndr_push_CLAIM_UINT64(ndr, NDR_SCALARS, &r->claim_boolean));
				break; }

				default: {
				break; }

			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case CLAIM_TYPE_INT64:
					NDR_CHECK(ndr_push_CLAIM_INT64(ndr, NDR_BUFFERS, &r->claim_int64));
				break;

				case CLAIM_TYPE_UINT64:
					NDR_CHECK(ndr_push_CLAIM_UINT64(ndr, NDR_BUFFERS, &r->claim_uint64));
				break;

				case CLAIM_TYPE_STRING:
					NDR_CHECK(ndr_push_CLAIM_STRING(ndr, NDR_BUFFERS, &r->claim_string));
				break;

				case CLAIM_TYPE_BOOLEAN:
					NDR_CHECK(ndr_push_CLAIM_UINT64(ndr, NDR_BUFFERS, &r->claim_boolean));
				break;

				default:
				break;

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIM_ENTRY_VALUES(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union CLAIM_ENTRY_VALUES *r)
{
	uint32_t level;
	uint16_t _level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 5));
			NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
			if (_level != level) {
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
			}
			NDR_CHECK(ndr_pull_union_align(ndr, 5));
			switch (level) {
				case CLAIM_TYPE_INT64: {
					NDR_CHECK(ndr_pull_CLAIM_INT64(ndr, NDR_SCALARS, &r->claim_int64));
				break; }

				case CLAIM_TYPE_UINT64: {
					NDR_CHECK(ndr_pull_CLAIM_UINT64(ndr, NDR_SCALARS, &r->claim_uint64));
				break; }

				case CLAIM_TYPE_STRING: {
					NDR_CHECK(ndr_pull_CLAIM_STRING(ndr, NDR_SCALARS, &r->claim_string));
				break; }

				case CLAIM_TYPE_BOOLEAN: {
					NDR_CHECK(ndr_pull_CLAIM_UINT64(ndr, NDR_SCALARS, &r->claim_boolean));
				break; }

				default: {
				break; }

			}
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (!(ndr_flags & NDR_SCALARS)) {
				/* We didn't get it above, and the token is not needed after this. */
				NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			}
			switch (level) {
				case CLAIM_TYPE_INT64:
					NDR_CHECK(ndr_pull_CLAIM_INT64(ndr, NDR_BUFFERS, &r->claim_int64));
				break;

				case CLAIM_TYPE_UINT64:
					NDR_CHECK(ndr_pull_CLAIM_UINT64(ndr, NDR_BUFFERS, &r->claim_uint64));
				break;

				case CLAIM_TYPE_STRING:
					NDR_CHECK(ndr_pull_CLAIM_STRING(ndr, NDR_BUFFERS, &r->claim_string));
				break;

				case CLAIM_TYPE_BOOLEAN:
					NDR_CHECK(ndr_pull_CLAIM_UINT64(ndr, NDR_BUFFERS, &r->claim_boolean));
				break;

				default:
				break;

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIM_ENTRY_VALUES(struct ndr_print *ndr, const char *name, const union CLAIM_ENTRY_VALUES *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN8);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "CLAIM_ENTRY_VALUES");
		switch (level) {
			case CLAIM_TYPE_INT64:
				ndr_print_CLAIM_INT64(ndr, "claim_int64", &r->claim_int64);
			break;

			case CLAIM_TYPE_UINT64:
				ndr_print_CLAIM_UINT64(ndr, "claim_uint64", &r->claim_uint64);
			break;

			case CLAIM_TYPE_STRING:
				ndr_print_CLAIM_STRING(ndr, "claim_string", &r->claim_string);
			break;

			case CLAIM_TYPE_BOOLEAN:
				ndr_print_CLAIM_UINT64(ndr, "claim_boolean", &r->claim_boolean);
			break;

			default:
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

static enum ndr_err_code ndr_push_CLAIM_ENTRY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIM_ENTRY *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_CLAIM_TYPE(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->values, r->type));
		NDR_CHECK(ndr_push_CLAIM_ENTRY_VALUES(ndr, NDR_SCALARS, &r->values));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->id, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->id, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->id, ndr_charset_length(r->id, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->values, r->type));
		NDR_CHECK(ndr_push_CLAIM_ENTRY_VALUES(ndr, NDR_BUFFERS, &r->values));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIM_ENTRY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIM_ENTRY *r)
{
	uint32_t _ptr_id;
	uint32_t size_id_1 = 0;
	uint32_t length_id_1 = 0;
	TALLOC_CTX *_mem_save_id_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_CLAIM_TYPE(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->values, r->type));
		NDR_CHECK(ndr_pull_CLAIM_ENTRY_VALUES(ndr, NDR_SCALARS, &r->values));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->id));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->id));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->id, &size_id_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->id, &length_id_1));
			if (length_id_1 > size_id_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_id_1, length_id_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_id_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->id, length_id_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->values, r->type));
		NDR_CHECK(ndr_pull_CLAIM_ENTRY_VALUES(ndr, NDR_BUFFERS, &r->values));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIM_ENTRY(struct ndr_print *ndr, const char *name, const struct CLAIM_ENTRY *r)
{
	ndr_print_struct(ndr, name, "CLAIM_ENTRY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_string(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr_print_CLAIM_TYPE(ndr, "type", r->type);
	ndr_print_set_switch_value(ndr, &r->values, r->type);
	ndr_print_CLAIM_ENTRY_VALUES(ndr, "values", &r->values);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLAIMS_ARRAY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_ARRAY *r)
{
	uint32_t cntr_claim_entries_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_CLAIMS_SOURCE_TYPE(ndr, NDR_SCALARS, r->claims_source_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->claims_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->claim_entries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claim_entries) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->claims_count));
			for (cntr_claim_entries_1 = 0; cntr_claim_entries_1 < (r->claims_count); cntr_claim_entries_1++) {
				NDR_CHECK(ndr_push_CLAIM_ENTRY(ndr, NDR_SCALARS, &r->claim_entries[cntr_claim_entries_1]));
			}
			for (cntr_claim_entries_1 = 0; cntr_claim_entries_1 < (r->claims_count); cntr_claim_entries_1++) {
				NDR_CHECK(ndr_push_CLAIM_ENTRY(ndr, NDR_BUFFERS, &r->claim_entries[cntr_claim_entries_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIMS_ARRAY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_ARRAY *r)
{
	uint32_t _ptr_claim_entries;
	uint32_t size_claim_entries_1 = 0;
	uint32_t cntr_claim_entries_1;
	TALLOC_CTX *_mem_save_claim_entries_0 = NULL;
	TALLOC_CTX *_mem_save_claim_entries_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_CLAIMS_SOURCE_TYPE(ndr, NDR_SCALARS, &r->claims_source_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->claims_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_claim_entries));
		if (_ptr_claim_entries) {
			NDR_PULL_ALLOC(ndr, r->claim_entries);
		} else {
			r->claim_entries = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claim_entries) {
			_mem_save_claim_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->claim_entries, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->claim_entries));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->claim_entries, &size_claim_entries_1));
			NDR_PULL_ALLOC_N(ndr, r->claim_entries, size_claim_entries_1);
			_mem_save_claim_entries_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->claim_entries, 0);
			for (cntr_claim_entries_1 = 0; cntr_claim_entries_1 < (size_claim_entries_1); cntr_claim_entries_1++) {
				NDR_CHECK(ndr_pull_CLAIM_ENTRY(ndr, NDR_SCALARS, &r->claim_entries[cntr_claim_entries_1]));
			}
			for (cntr_claim_entries_1 = 0; cntr_claim_entries_1 < (size_claim_entries_1); cntr_claim_entries_1++) {
				NDR_CHECK(ndr_pull_CLAIM_ENTRY(ndr, NDR_BUFFERS, &r->claim_entries[cntr_claim_entries_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_claim_entries_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_claim_entries_0, 0);
		}
		if (r->claim_entries) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->claim_entries, r->claims_count));
		}
		for (cntr_claim_entries_1 = 0; cntr_claim_entries_1 < (size_claim_entries_1); cntr_claim_entries_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIMS_ARRAY(struct ndr_print *ndr, const char *name, const struct CLAIMS_ARRAY *r)
{
	uint32_t cntr_claim_entries_1;
	ndr_print_struct(ndr, name, "CLAIMS_ARRAY");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_CLAIMS_SOURCE_TYPE(ndr, "claims_source_type", r->claims_source_type);
	ndr_print_uint32(ndr, "claims_count", r->claims_count);
	ndr_print_ptr(ndr, "claim_entries", r->claim_entries);
	ndr->depth++;
	if (r->claim_entries) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "claim_entries", (uint32_t)(r->claims_count));
		ndr->depth++;
		for (cntr_claim_entries_1 = 0; cntr_claim_entries_1 < (r->claims_count); cntr_claim_entries_1++) {
			ndr_print_CLAIM_ENTRY(ndr, "claim_entries", &r->claim_entries[cntr_claim_entries_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLAIMS_SET_METADATA_CTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_SET_METADATA_CTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->metadata));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->metadata) {
			NDR_CHECK(ndr_push_CLAIMS_SET_METADATA(ndr, NDR_SCALARS|NDR_BUFFERS, r->metadata));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIMS_SET_METADATA_CTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_SET_METADATA_CTR *r)
{
	uint32_t _ptr_metadata;
	TALLOC_CTX *_mem_save_metadata_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_metadata));
		if (_ptr_metadata) {
			NDR_PULL_ALLOC(ndr, r->metadata);
		} else {
			r->metadata = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->metadata) {
			_mem_save_metadata_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->metadata, 0);
			NDR_CHECK(ndr_pull_CLAIMS_SET_METADATA(ndr, NDR_SCALARS|NDR_BUFFERS, r->metadata));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_metadata_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIMS_SET_METADATA_CTR(struct ndr_print *ndr, const char *name, const struct CLAIMS_SET_METADATA_CTR *r)
{
	ndr_print_struct(ndr, name, "CLAIMS_SET_METADATA_CTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "metadata", r->metadata);
	ndr->depth++;
	if (r->metadata) {
		ndr_print_CLAIMS_SET_METADATA(ndr, "metadata", r->metadata);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_CLAIMS_SET_CTR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_SET_CTR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->claims));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claims) {
			NDR_CHECK(ndr_push_CLAIMS_SET(ndr, NDR_SCALARS|NDR_BUFFERS, r->claims));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_CLAIMS_SET_CTR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_SET_CTR *r)
{
	uint32_t _ptr_claims;
	TALLOC_CTX *_mem_save_claims_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_claims));
		if (_ptr_claims) {
			NDR_PULL_ALLOC(ndr, r->claims);
		} else {
			r->claims = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claims) {
			_mem_save_claims_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->claims, 0);
			NDR_CHECK(ndr_pull_CLAIMS_SET(ndr, NDR_SCALARS|NDR_BUFFERS, r->claims));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_claims_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_CLAIMS_SET_CTR(struct ndr_print *ndr, const char *name, const struct CLAIMS_SET_CTR *r)
{
	ndr_print_struct(ndr, name, "CLAIMS_SET_CTR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "claims", r->claims);
	ndr->depth++;
	if (r->claims) {
		ndr_print_CLAIMS_SET(ndr, "claims", r->claims);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_CLAIMS_SET(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_SET *r)
{
	uint32_t cntr_claims_arrays_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->claims_array_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->claims_arrays));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved_field_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->reserved_field));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claims_arrays) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->claims_array_count));
			for (cntr_claims_arrays_1 = 0; cntr_claims_arrays_1 < (r->claims_array_count); cntr_claims_arrays_1++) {
				NDR_CHECK(ndr_push_CLAIMS_ARRAY(ndr, NDR_SCALARS, &r->claims_arrays[cntr_claims_arrays_1]));
			}
			for (cntr_claims_arrays_1 = 0; cntr_claims_arrays_1 < (r->claims_array_count); cntr_claims_arrays_1++) {
				NDR_CHECK(ndr_push_CLAIMS_ARRAY(ndr, NDR_BUFFERS, &r->claims_arrays[cntr_claims_arrays_1]));
			}
		}
		if (r->reserved_field) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->reserved_field_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->reserved_field, r->reserved_field_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CLAIMS_SET(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_SET *r)
{
	uint32_t _ptr_claims_arrays;
	uint32_t size_claims_arrays_1 = 0;
	uint32_t cntr_claims_arrays_1;
	TALLOC_CTX *_mem_save_claims_arrays_0 = NULL;
	TALLOC_CTX *_mem_save_claims_arrays_1 = NULL;
	uint32_t _ptr_reserved_field;
	uint32_t size_reserved_field_1 = 0;
	TALLOC_CTX *_mem_save_reserved_field_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->claims_array_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_claims_arrays));
		if (_ptr_claims_arrays) {
			NDR_PULL_ALLOC(ndr, r->claims_arrays);
		} else {
			r->claims_arrays = NULL;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved_field_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_reserved_field));
		if (_ptr_reserved_field) {
			NDR_PULL_ALLOC(ndr, r->reserved_field);
		} else {
			r->reserved_field = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claims_arrays) {
			_mem_save_claims_arrays_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->claims_arrays, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->claims_arrays));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->claims_arrays, &size_claims_arrays_1));
			NDR_PULL_ALLOC_N(ndr, r->claims_arrays, size_claims_arrays_1);
			_mem_save_claims_arrays_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->claims_arrays, 0);
			for (cntr_claims_arrays_1 = 0; cntr_claims_arrays_1 < (size_claims_arrays_1); cntr_claims_arrays_1++) {
				NDR_CHECK(ndr_pull_CLAIMS_ARRAY(ndr, NDR_SCALARS, &r->claims_arrays[cntr_claims_arrays_1]));
			}
			for (cntr_claims_arrays_1 = 0; cntr_claims_arrays_1 < (size_claims_arrays_1); cntr_claims_arrays_1++) {
				NDR_CHECK(ndr_pull_CLAIMS_ARRAY(ndr, NDR_BUFFERS, &r->claims_arrays[cntr_claims_arrays_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_claims_arrays_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_claims_arrays_0, 0);
		}
		if (r->reserved_field) {
			_mem_save_reserved_field_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->reserved_field, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->reserved_field));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->reserved_field, &size_reserved_field_1));
			NDR_PULL_ALLOC_N(ndr, r->reserved_field, size_reserved_field_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->reserved_field, size_reserved_field_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reserved_field_0, 0);
		}
		if (r->claims_arrays) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->claims_arrays, r->claims_array_count));
		}
		for (cntr_claims_arrays_1 = 0; cntr_claims_arrays_1 < (size_claims_arrays_1); cntr_claims_arrays_1++) {
		}
		if (r->reserved_field) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->reserved_field, r->reserved_field_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CLAIMS_SET(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CLAIMS_SET *r)
{
	ndr_print_CLAIMS_SET(ndr, name, r);
}

_PUBLIC_ void ndr_print_CLAIMS_SET(struct ndr_print *ndr, const char *name, const struct CLAIMS_SET *r)
{
	uint32_t cntr_claims_arrays_1;
	ndr_print_struct(ndr, name, "CLAIMS_SET");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "claims_array_count", r->claims_array_count);
	ndr_print_ptr(ndr, "claims_arrays", r->claims_arrays);
	ndr->depth++;
	if (r->claims_arrays) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "claims_arrays", (uint32_t)(r->claims_array_count));
		ndr->depth++;
		for (cntr_claims_arrays_1 = 0; cntr_claims_arrays_1 < (r->claims_array_count); cntr_claims_arrays_1++) {
			ndr_print_CLAIMS_ARRAY(ndr, "claims_arrays", &r->claims_arrays[cntr_claims_arrays_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint16(ndr, "reserved_type", r->reserved_type);
	ndr_print_uint32(ndr, "reserved_field_size", r->reserved_field_size);
	ndr_print_ptr(ndr, "reserved_field", r->reserved_field);
	ndr->depth++;
	if (r->reserved_field) {
		ndr_print_array_uint8(ndr, "reserved_field", r->reserved_field, r->reserved_field_size);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_CLAIMS_SET_NDR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_SET_NDR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_claims;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_claims, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_CLAIMS_SET_CTR(_ndr_claims, NDR_SCALARS|NDR_BUFFERS, &r->claims));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_claims, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CLAIMS_SET_NDR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_SET_NDR *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_claims;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_claims, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_CLAIMS_SET_CTR(_ndr_claims, NDR_SCALARS|NDR_BUFFERS, &r->claims));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_claims, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CLAIMS_SET_NDR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CLAIMS_SET_NDR *r)
{
	ndr_print_CLAIMS_SET_NDR(ndr, name, r);
}

_PUBLIC_ void ndr_print_CLAIMS_SET_NDR(struct ndr_print *ndr, const char *name, const struct CLAIMS_SET_NDR *r)
{
	ndr_print_struct(ndr, name, "CLAIMS_SET_NDR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_CLAIMS_SET_CTR(ndr, "claims", &r->claims);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_CLAIMS_SET_NDR(const struct CLAIMS_SET_NDR *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_CLAIMS_SET_NDR);
}

_PUBLIC_ enum ndr_err_code ndr_push_CLAIMS_SET_METADATA_NDR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_SET_METADATA_NDR *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_claims;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_claims, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_CLAIMS_SET_METADATA_CTR(_ndr_claims, NDR_SCALARS|NDR_BUFFERS, &r->claims));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_claims, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CLAIMS_SET_METADATA_NDR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_SET_METADATA_NDR *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_claims;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_claims, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_CLAIMS_SET_METADATA_CTR(_ndr_claims, NDR_SCALARS|NDR_BUFFERS, &r->claims));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_claims, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CLAIMS_SET_METADATA_NDR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CLAIMS_SET_METADATA_NDR *r)
{
	ndr_print_CLAIMS_SET_METADATA_NDR(ndr, name, r);
}

_PUBLIC_ void ndr_print_CLAIMS_SET_METADATA_NDR(struct ndr_print *ndr, const char *name, const struct CLAIMS_SET_METADATA_NDR *r)
{
	ndr_print_struct(ndr, name, "CLAIMS_SET_METADATA_NDR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_CLAIMS_SET_METADATA_CTR(ndr, "claims", &r->claims);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_CLAIMS_SET_METADATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CLAIMS_SET_METADATA *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_claims_compressed_size(r->claims_set, r->compression_format, ndr->flags)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->claims_set));
		NDR_CHECK(ndr_push_CLAIMS_COMPRESSION_FORMAT(ndr, NDR_SCALARS, ndr_claims_actual_wire_compression_alg(r->compression_format, ndr_size_CLAIMS_SET_NDR(r->claims_set, ndr->flags))));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_CLAIMS_SET_NDR(r->claims_set, ndr->flags)));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->reserved_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reserved_field_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->reserved_field));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claims_set) {
			{
				struct ndr_push *_ndr_claims_set;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_claims_set, 4, -1));
				{
					struct ndr_push *_ndr_claims_set_compressed;
					NDR_CHECK(ndr_push_compression_state_init(_ndr_claims_set, ndr_claims_compression_alg(ndr_claims_actual_wire_compression_alg(r->compression_format, ndr_size_CLAIMS_SET_NDR(r->claims_set, ndr->flags)))));
					NDR_CHECK(ndr_push_compression_start(_ndr_claims_set, &_ndr_claims_set_compressed));
					NDR_CHECK(ndr_push_CLAIMS_SET_NDR(_ndr_claims_set_compressed, NDR_SCALARS|NDR_BUFFERS, r->claims_set));
					NDR_CHECK(ndr_push_compression_end(_ndr_claims_set, _ndr_claims_set_compressed));
					TALLOC_FREE(_ndr_claims_set->cstate);
				}
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_claims_set, 4, -1));
			}
		}
		if (r->reserved_field) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->reserved_field_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->reserved_field, r->reserved_field_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CLAIMS_SET_METADATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CLAIMS_SET_METADATA *r)
{
	uint32_t _ptr_claims_set;
	TALLOC_CTX *_mem_save_claims_set_0 = NULL;
	uint32_t _ptr_reserved_field;
	uint32_t size_reserved_field_1 = 0;
	TALLOC_CTX *_mem_save_reserved_field_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->claims_set_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_claims_set));
		if (_ptr_claims_set) {
			NDR_PULL_ALLOC(ndr, r->claims_set);
		} else {
			r->claims_set = NULL;
		}
		NDR_CHECK(ndr_pull_CLAIMS_COMPRESSION_FORMAT(ndr, NDR_SCALARS, &r->compression_format));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->uncompressed_claims_set_size));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->reserved_type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved_field_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_reserved_field));
		if (_ptr_reserved_field) {
			NDR_PULL_ALLOC(ndr, r->reserved_field);
		} else {
			r->reserved_field = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->claims_set) {
			_mem_save_claims_set_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->claims_set, 0);
			{
				struct ndr_pull *_ndr_claims_set;
				ssize_t sub_size = -1;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_claims_set, 4, sub_size));
				{
					struct ndr_pull *_ndr_claims_set_compressed;
					NDR_CHECK(ndr_pull_compression_start(_ndr_claims_set, &_ndr_claims_set_compressed, ndr_claims_compression_alg(r->compression_format), r->uncompressed_claims_set_size, r->claims_set_size));
					NDR_CHECK(ndr_pull_CLAIMS_SET_NDR(_ndr_claims_set_compressed, NDR_SCALARS|NDR_BUFFERS, r->claims_set));
					NDR_CHECK(ndr_pull_compression_end(_ndr_claims_set, _ndr_claims_set_compressed, ndr_claims_compression_alg(r->compression_format), r->uncompressed_claims_set_size));
				}
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_claims_set, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_claims_set_0, 0);
		}
		if (r->reserved_field) {
			_mem_save_reserved_field_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->reserved_field, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->reserved_field));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->reserved_field, &size_reserved_field_1));
			NDR_PULL_ALLOC_N(ndr, r->reserved_field, size_reserved_field_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->reserved_field, size_reserved_field_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reserved_field_0, 0);
		}
		if (r->reserved_field) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->reserved_field, r->reserved_field_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CLAIMS_SET_METADATA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CLAIMS_SET_METADATA *r)
{
	ndr_print_CLAIMS_SET_METADATA(ndr, name, r);
}

_PUBLIC_ void ndr_print_CLAIMS_SET_METADATA(struct ndr_print *ndr, const char *name, const struct CLAIMS_SET_METADATA *r)
{
	ndr_print_struct(ndr, name, "CLAIMS_SET_METADATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "claims_set_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_claims_compressed_size(r->claims_set, r->compression_format, ndr->flags):r->claims_set_size);
	ndr_print_ptr(ndr, "claims_set", r->claims_set);
	ndr->depth++;
	if (r->claims_set) {
		ndr_print_CLAIMS_SET_NDR(ndr, "claims_set", r->claims_set);
	}
	ndr->depth--;
	ndr_print_CLAIMS_COMPRESSION_FORMAT(ndr, "compression_format", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_claims_actual_wire_compression_alg(r->compression_format, ndr_size_CLAIMS_SET_NDR(r->claims_set, ndr->flags)):r->compression_format);
	ndr_print_uint32(ndr, "uncompressed_claims_set_size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_CLAIMS_SET_NDR(r->claims_set, ndr->flags):r->uncompressed_claims_set_size);
	ndr_print_uint16(ndr, "reserved_type", r->reserved_type);
	ndr_print_uint32(ndr, "reserved_field_size", r->reserved_field_size);
	ndr_print_ptr(ndr, "reserved_field", r->reserved_field);
	ndr->depth++;
	if (r->reserved_field) {
		ndr_print_array_uint8(ndr, "reserved_field", r->reserved_field, r->reserved_field_size);
	}
	ndr->depth--;
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_claims
static const struct ndr_interface_public_struct claims_public_structs[] = {
	{
		.name = "CLAIMS_SET",
		.struct_size = sizeof(struct CLAIMS_SET ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CLAIMS_SET,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CLAIMS_SET,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CLAIMS_SET,
	},
	{
		.name = "CLAIMS_SET_NDR",
		.struct_size = sizeof(struct CLAIMS_SET_NDR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CLAIMS_SET_NDR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CLAIMS_SET_NDR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CLAIMS_SET_NDR,
	},
	{
		.name = "CLAIMS_SET_METADATA_NDR",
		.struct_size = sizeof(struct CLAIMS_SET_METADATA_NDR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CLAIMS_SET_METADATA_NDR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CLAIMS_SET_METADATA_NDR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CLAIMS_SET_METADATA_NDR,
	},
	{
		.name = "CLAIMS_SET_METADATA",
		.struct_size = sizeof(struct CLAIMS_SET_METADATA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CLAIMS_SET_METADATA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CLAIMS_SET_METADATA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CLAIMS_SET_METADATA,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call claims_calls[] = {
	{ .name = NULL }
};

static const char * const claims_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\claims]", 
};

static const struct ndr_interface_string_array claims_endpoints = {
	.count	= 1,
	.names	= claims_endpoint_strings
};

static const char * const claims_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array claims_authservices = {
	.count	= 1,
	.names	= claims_authservice_strings
};


const struct ndr_interface_table ndr_table_claims = {
	.name		= "claims",
	.syntax_id	= {
		{0xbba9cb76,0xeb0c,0x462c,{0xaa,0x1b},{0x5d,0x8c,0x34,0x41,0x57,0x01}},
		NDR_CLAIMS_VERSION
	},
	.helpstring	= NDR_CLAIMS_HELPSTRING,
	.num_calls	= 0,
	.calls		= claims_calls,
	.num_public_structs	= 4,
	.public_structs		= claims_public_structs,
	.endpoints	= &claims_endpoints,
	.authservices	= &claims_authservices
};

#endif /* SKIP_NDR_TABLE_claims */
