/* parser auto-generated by pidl */

#include "includes.h"
#include "bin/default/librpc/gen_ndr/ndr_auth.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_krb5pac.h"
_PUBLIC_ enum ndr_err_code ndr_push_auth_method(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum auth_method r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_method(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum auth_method *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_auth_method(struct ndr_print *ndr, const char *name, enum auth_method r)
{
	const char *val = NULL;

	switch (r) {
		case SEC_AUTH_METHOD_UNAUTHENTICATED: val = "SEC_AUTH_METHOD_UNAUTHENTICATED"; break;
		case SEC_AUTH_METHOD_NTLM: val = "SEC_AUTH_METHOD_NTLM"; break;
		case SEC_AUTH_METHOD_KERBEROS: val = "SEC_AUTH_METHOD_KERBEROS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_user_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_user_info *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->account_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->user_principal_name));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->user_principal_constructed));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dns_domain_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->full_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->logon_script));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->profile_path));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->home_directory));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->home_drive));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->logon_server));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logon));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_logoff));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->acct_expiry));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->last_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->allow_password_change));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->force_password_change));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->logon_count));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->bad_password_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->acct_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->user_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->account_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, ndr_charset_length(r->account_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->user_principal_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user_principal_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->user_principal_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->user_principal_name, ndr_charset_length(r->user_principal_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->domain_name, ndr_charset_length(r->domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->dns_domain_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dns_domain_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dns_domain_name, ndr_charset_length(r->dns_domain_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->full_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->full_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->full_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->full_name, ndr_charset_length(r->full_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->logon_script) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->logon_script, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->logon_script, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->logon_script, ndr_charset_length(r->logon_script, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->profile_path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->profile_path, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->profile_path, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->profile_path, ndr_charset_length(r->profile_path, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->home_directory) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->home_directory, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->home_directory, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->home_directory, ndr_charset_length(r->home_directory, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->home_drive) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->home_drive, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->home_drive, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->home_drive, ndr_charset_length(r->home_drive, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->logon_server) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->logon_server, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->logon_server, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->logon_server, ndr_charset_length(r->logon_server, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_user_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_user_info *r)
{
	uint32_t _ptr_account_name;
	uint32_t size_account_name_1 = 0;
	uint32_t length_account_name_1 = 0;
	TALLOC_CTX *_mem_save_account_name_0 = NULL;
	uint32_t _ptr_user_principal_name;
	uint32_t size_user_principal_name_1 = 0;
	uint32_t length_user_principal_name_1 = 0;
	TALLOC_CTX *_mem_save_user_principal_name_0 = NULL;
	uint32_t _ptr_domain_name;
	uint32_t size_domain_name_1 = 0;
	uint32_t length_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_domain_name_0 = NULL;
	uint32_t _ptr_dns_domain_name;
	uint32_t size_dns_domain_name_1 = 0;
	uint32_t length_dns_domain_name_1 = 0;
	TALLOC_CTX *_mem_save_dns_domain_name_0 = NULL;
	uint32_t _ptr_full_name;
	uint32_t size_full_name_1 = 0;
	uint32_t length_full_name_1 = 0;
	TALLOC_CTX *_mem_save_full_name_0 = NULL;
	uint32_t _ptr_logon_script;
	uint32_t size_logon_script_1 = 0;
	uint32_t length_logon_script_1 = 0;
	TALLOC_CTX *_mem_save_logon_script_0 = NULL;
	uint32_t _ptr_profile_path;
	uint32_t size_profile_path_1 = 0;
	uint32_t length_profile_path_1 = 0;
	TALLOC_CTX *_mem_save_profile_path_0 = NULL;
	uint32_t _ptr_home_directory;
	uint32_t size_home_directory_1 = 0;
	uint32_t length_home_directory_1 = 0;
	TALLOC_CTX *_mem_save_home_directory_0 = NULL;
	uint32_t _ptr_home_drive;
	uint32_t size_home_drive_1 = 0;
	uint32_t length_home_drive_1 = 0;
	TALLOC_CTX *_mem_save_home_drive_0 = NULL;
	uint32_t _ptr_logon_server;
	uint32_t size_logon_server_1 = 0;
	uint32_t length_logon_server_1 = 0;
	TALLOC_CTX *_mem_save_logon_server_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_account_name));
		if (_ptr_account_name) {
			NDR_PULL_ALLOC(ndr, r->account_name);
		} else {
			r->account_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_user_principal_name));
		if (_ptr_user_principal_name) {
			NDR_PULL_ALLOC(ndr, r->user_principal_name);
		} else {
			r->user_principal_name = NULL;
		}
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->user_principal_constructed));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_domain_name));
		if (_ptr_domain_name) {
			NDR_PULL_ALLOC(ndr, r->domain_name);
		} else {
			r->domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dns_domain_name));
		if (_ptr_dns_domain_name) {
			NDR_PULL_ALLOC(ndr, r->dns_domain_name);
		} else {
			r->dns_domain_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_full_name));
		if (_ptr_full_name) {
			NDR_PULL_ALLOC(ndr, r->full_name);
		} else {
			r->full_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_script));
		if (_ptr_logon_script) {
			NDR_PULL_ALLOC(ndr, r->logon_script);
		} else {
			r->logon_script = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_profile_path));
		if (_ptr_profile_path) {
			NDR_PULL_ALLOC(ndr, r->profile_path);
		} else {
			r->profile_path = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_home_directory));
		if (_ptr_home_directory) {
			NDR_PULL_ALLOC(ndr, r->home_directory);
		} else {
			r->home_directory = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_home_drive));
		if (_ptr_home_drive) {
			NDR_PULL_ALLOC(ndr, r->home_drive);
		} else {
			r->home_drive = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_logon_server));
		if (_ptr_logon_server) {
			NDR_PULL_ALLOC(ndr, r->logon_server);
		} else {
			r->logon_server = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logon));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_logoff));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->acct_expiry));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->last_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->allow_password_change));
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->force_password_change));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->logon_count));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->bad_password_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->acct_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->user_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->account_name) {
			_mem_save_account_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->account_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->account_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->account_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->account_name, &size_account_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->account_name, &length_account_name_1));
			if (length_account_name_1 > size_account_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_account_name_1, length_account_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, length_account_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_account_name_0, 0);
		}
		if (r->user_principal_name) {
			_mem_save_user_principal_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->user_principal_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->user_principal_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->user_principal_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->user_principal_name, &size_user_principal_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->user_principal_name, &length_user_principal_name_1));
			if (length_user_principal_name_1 > size_user_principal_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_user_principal_name_1, length_user_principal_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_user_principal_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->user_principal_name, length_user_principal_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_user_principal_name_0, 0);
		}
		if (r->domain_name) {
			_mem_save_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->domain_name, &size_domain_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->domain_name, &length_domain_name_1));
			if (length_domain_name_1 > size_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_domain_name_1, length_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_domain_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->domain_name, length_domain_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_domain_name_0, 0);
		}
		if (r->dns_domain_name) {
			_mem_save_dns_domain_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dns_domain_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dns_domain_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dns_domain_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dns_domain_name, &size_dns_domain_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dns_domain_name, &length_dns_domain_name_1));
			if (length_dns_domain_name_1 > size_dns_domain_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dns_domain_name_1, length_dns_domain_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dns_domain_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dns_domain_name, length_dns_domain_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dns_domain_name_0, 0);
		}
		if (r->full_name) {
			_mem_save_full_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->full_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->full_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->full_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->full_name, &size_full_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->full_name, &length_full_name_1));
			if (length_full_name_1 > size_full_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_full_name_1, length_full_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_full_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->full_name, length_full_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_full_name_0, 0);
		}
		if (r->logon_script) {
			_mem_save_logon_script_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->logon_script, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->logon_script));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->logon_script));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->logon_script, &size_logon_script_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->logon_script, &length_logon_script_1));
			if (length_logon_script_1 > size_logon_script_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_logon_script_1, length_logon_script_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_script_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->logon_script, length_logon_script_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_script_0, 0);
		}
		if (r->profile_path) {
			_mem_save_profile_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->profile_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->profile_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->profile_path));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->profile_path, &size_profile_path_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->profile_path, &length_profile_path_1));
			if (length_profile_path_1 > size_profile_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_profile_path_1, length_profile_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_profile_path_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->profile_path, length_profile_path_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_profile_path_0, 0);
		}
		if (r->home_directory) {
			_mem_save_home_directory_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->home_directory, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->home_directory));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->home_directory));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->home_directory, &size_home_directory_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->home_directory, &length_home_directory_1));
			if (length_home_directory_1 > size_home_directory_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_home_directory_1, length_home_directory_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_home_directory_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->home_directory, length_home_directory_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_home_directory_0, 0);
		}
		if (r->home_drive) {
			_mem_save_home_drive_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->home_drive, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->home_drive));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->home_drive));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->home_drive, &size_home_drive_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->home_drive, &length_home_drive_1));
			if (length_home_drive_1 > size_home_drive_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_home_drive_1, length_home_drive_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_home_drive_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->home_drive, length_home_drive_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_home_drive_0, 0);
		}
		if (r->logon_server) {
			_mem_save_logon_server_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->logon_server, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->logon_server));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->logon_server));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->logon_server, &size_logon_server_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->logon_server, &length_logon_server_1));
			if (length_logon_server_1 > size_logon_server_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_logon_server_1, length_logon_server_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_logon_server_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->logon_server, length_logon_server_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_logon_server_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_user_info(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_user_info *r)
{
	ndr_print_auth_user_info(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_user_info(struct ndr_print *ndr, const char *name, const struct auth_user_info *r)
{
	ndr_print_struct(ndr, name, "auth_user_info");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "account_name", r->account_name);
	ndr->depth++;
	if (r->account_name) {
		ndr_print_string(ndr, "account_name", r->account_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "user_principal_name", r->user_principal_name);
	ndr->depth++;
	if (r->user_principal_name) {
		ndr_print_string(ndr, "user_principal_name", r->user_principal_name);
	}
	ndr->depth--;
	ndr_print_uint8(ndr, "user_principal_constructed", r->user_principal_constructed);
	ndr_print_ptr(ndr, "domain_name", r->domain_name);
	ndr->depth++;
	if (r->domain_name) {
		ndr_print_string(ndr, "domain_name", r->domain_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "dns_domain_name", r->dns_domain_name);
	ndr->depth++;
	if (r->dns_domain_name) {
		ndr_print_string(ndr, "dns_domain_name", r->dns_domain_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "full_name", r->full_name);
	ndr->depth++;
	if (r->full_name) {
		ndr_print_string(ndr, "full_name", r->full_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "logon_script", r->logon_script);
	ndr->depth++;
	if (r->logon_script) {
		ndr_print_string(ndr, "logon_script", r->logon_script);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "profile_path", r->profile_path);
	ndr->depth++;
	if (r->profile_path) {
		ndr_print_string(ndr, "profile_path", r->profile_path);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "home_directory", r->home_directory);
	ndr->depth++;
	if (r->home_directory) {
		ndr_print_string(ndr, "home_directory", r->home_directory);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "home_drive", r->home_drive);
	ndr->depth++;
	if (r->home_drive) {
		ndr_print_string(ndr, "home_drive", r->home_drive);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "logon_server", r->logon_server);
	ndr->depth++;
	if (r->logon_server) {
		ndr_print_string(ndr, "logon_server", r->logon_server);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "last_logon", r->last_logon);
	ndr_print_NTTIME(ndr, "last_logoff", r->last_logoff);
	ndr_print_NTTIME(ndr, "acct_expiry", r->acct_expiry);
	ndr_print_NTTIME(ndr, "last_password_change", r->last_password_change);
	ndr_print_NTTIME(ndr, "allow_password_change", r->allow_password_change);
	ndr_print_NTTIME(ndr, "force_password_change", r->force_password_change);
	ndr_print_uint16(ndr, "logon_count", r->logon_count);
	ndr_print_uint16(ndr, "bad_password_count", r->bad_password_count);
	ndr_print_uint32(ndr, "acct_flags", r->acct_flags);
	ndr_print_uint32(ndr, "user_flags", r->user_flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_user_info_torture(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_user_info_torture *r)
{
	uint32_t cntr_dc_sids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_dc_sids));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_dc_sids));
		for (cntr_dc_sids_0 = 0; cntr_dc_sids_0 < (r->num_dc_sids); cntr_dc_sids_0++) {
			NDR_CHECK(ndr_push_auth_SidAttr(ndr, NDR_SCALARS, &r->dc_sids[cntr_dc_sids_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_user_info_torture(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_user_info_torture *r)
{
	uint32_t size_dc_sids_0 = 0;
	uint32_t cntr_dc_sids_0;
	TALLOC_CTX *_mem_save_dc_sids_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->dc_sids));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_dc_sids));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->dc_sids, &size_dc_sids_0));
		NDR_PULL_ALLOC_N(ndr, r->dc_sids, size_dc_sids_0);
		_mem_save_dc_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->dc_sids, 0);
		for (cntr_dc_sids_0 = 0; cntr_dc_sids_0 < (size_dc_sids_0); cntr_dc_sids_0++) {
			NDR_CHECK(ndr_pull_auth_SidAttr(ndr, NDR_SCALARS, &r->dc_sids[cntr_dc_sids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dc_sids_0, 0);
		if (r->dc_sids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->dc_sids, r->num_dc_sids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_user_info_torture(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_user_info_torture *r)
{
	ndr_print_auth_user_info_torture(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_user_info_torture(struct ndr_print *ndr, const char *name, const struct auth_user_info_torture *r)
{
	uint32_t cntr_dc_sids_0;
	ndr_print_struct(ndr, name, "auth_user_info_torture");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_dc_sids", r->num_dc_sids);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "dc_sids", (uint32_t)(r->num_dc_sids));
	ndr->depth++;
	for (cntr_dc_sids_0 = 0; cntr_dc_sids_0 < (r->num_dc_sids); cntr_dc_sids_0++) {
		ndr_print_auth_SidAttr(ndr, "dc_sids", &r->dc_sids[cntr_dc_sids_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_user_info_unix(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_user_info_unix *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->unix_name));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sanitized_username));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->unix_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->unix_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->unix_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->unix_name, ndr_charset_length(r->unix_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
		if (r->sanitized_username) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->sanitized_username, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->sanitized_username, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->sanitized_username, ndr_charset_length(r->sanitized_username, CH_UTF8), sizeof(uint8_t), CH_UTF8));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_user_info_unix(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_user_info_unix *r)
{
	uint32_t _ptr_unix_name;
	uint32_t size_unix_name_1 = 0;
	uint32_t length_unix_name_1 = 0;
	TALLOC_CTX *_mem_save_unix_name_0 = NULL;
	uint32_t _ptr_sanitized_username;
	uint32_t size_sanitized_username_1 = 0;
	uint32_t length_sanitized_username_1 = 0;
	TALLOC_CTX *_mem_save_sanitized_username_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unix_name));
		if (_ptr_unix_name) {
			NDR_PULL_ALLOC(ndr, r->unix_name);
		} else {
			r->unix_name = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sanitized_username));
		if (_ptr_sanitized_username) {
			NDR_PULL_ALLOC(ndr, r->sanitized_username);
		} else {
			r->sanitized_username = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->unix_name) {
			_mem_save_unix_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->unix_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->unix_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->unix_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->unix_name, &size_unix_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->unix_name, &length_unix_name_1));
			if (length_unix_name_1 > size_unix_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_unix_name_1, length_unix_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_unix_name_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->unix_name, length_unix_name_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unix_name_0, 0);
		}
		if (r->sanitized_username) {
			_mem_save_sanitized_username_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sanitized_username, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->sanitized_username));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->sanitized_username));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->sanitized_username, &size_sanitized_username_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->sanitized_username, &length_sanitized_username_1));
			if (length_sanitized_username_1 > size_sanitized_username_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_sanitized_username_1, length_sanitized_username_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_sanitized_username_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->sanitized_username, length_sanitized_username_1, sizeof(uint8_t), CH_UTF8));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sanitized_username_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_user_info_unix(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_user_info_unix *r)
{
	ndr_print_auth_user_info_unix(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_user_info_unix(struct ndr_print *ndr, const char *name, const struct auth_user_info_unix *r)
{
	ndr_print_struct(ndr, name, "auth_user_info_unix");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "unix_name", r->unix_name);
	ndr->depth++;
	if (r->unix_name) {
		ndr_print_string(ndr, "unix_name", r->unix_name);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "sanitized_username", r->sanitized_username);
	ndr->depth++;
	if (r->sanitized_username) {
		ndr_print_string(ndr, "sanitized_username", r->sanitized_username);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ticket_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ticket_type r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ticket_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ticket_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ticket_type(struct ndr_print *ndr, const char *name, enum ticket_type r)
{
	const char *val = NULL;

	switch (r) {
		case TICKET_TYPE_UNKNOWN: val = "TICKET_TYPE_UNKNOWN"; break;
		case TICKET_TYPE_TGT: val = "TICKET_TYPE_TGT"; break;
		case TICKET_TYPE_NON_TGT: val = "TICKET_TYPE_NON_TGT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_SidAttr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_SidAttr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_push_security_GroupAttrs(ndr, NDR_SCALARS, r->attrs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_SidAttr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_SidAttr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->sid));
		NDR_CHECK(ndr_pull_security_GroupAttrs(ndr, NDR_SCALARS, &r->attrs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_SidAttr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_SidAttr *r)
{
	ndr_print_auth_SidAttr(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_SidAttr(struct ndr_print *ndr, const char *name, const struct auth_SidAttr *r)
{
	ndr_print_struct(ndr, name, "auth_SidAttr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_dom_sid(ndr, "sid", &r->sid);
	ndr_print_security_GroupAttrs(ndr, "attrs", r->attrs);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_user_info_dc(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_user_info_dc *r)
{
	uint32_t cntr_sids_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_sids));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_sids));
		for (cntr_sids_0 = 0; cntr_sids_0 < (r->num_sids); cntr_sids_0++) {
			NDR_CHECK(ndr_push_auth_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_0]));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->user_session_key));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->lm_session_key));
		NDR_CHECK(ndr_push_ticket_type(ndr, NDR_SCALARS, r->ticket_type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			NDR_CHECK(ndr_push_auth_user_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_user_info_dc(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_user_info_dc *r)
{
	uint32_t size_sids_0 = 0;
	uint32_t cntr_sids_0;
	TALLOC_CTX *_mem_save_sids_0 = NULL;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_sids));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->sids));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->sids, &size_sids_0));
		NDR_PULL_ALLOC_N(ndr, r->sids, size_sids_0);
		_mem_save_sids_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->sids, 0);
		for (cntr_sids_0 = 0; cntr_sids_0 < (size_sids_0); cntr_sids_0++) {
			NDR_CHECK(ndr_pull_auth_SidAttr(ndr, NDR_SCALARS, &r->sids[cntr_sids_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sids_0, 0);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->user_session_key));
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->lm_session_key));
		NDR_CHECK(ndr_pull_ticket_type(ndr, NDR_SCALARS, &r->ticket_type));
		if (r->sids) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->sids, r->num_sids));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_auth_user_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_user_info_dc(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_user_info_dc *r)
{
	ndr_print_auth_user_info_dc(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_user_info_dc(struct ndr_print *ndr, const char *name, const struct auth_user_info_dc *r)
{
	uint32_t cntr_sids_0;
	ndr_print_struct(ndr, name, "auth_user_info_dc");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_sids", r->num_sids);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "sids", (uint32_t)(r->num_sids));
	ndr->depth++;
	for (cntr_sids_0 = 0; cntr_sids_0 < (r->num_sids); cntr_sids_0++) {
		ndr_print_auth_SidAttr(ndr, "sids", &r->sids[cntr_sids_0]);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_auth_user_info(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr_print_ticket_type(ndr, "ticket_type", r->ticket_type);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_session_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_session_info *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->security_token));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->unix_token));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->info));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->unix_info));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'torture' */
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->session_key));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		/* [ignore] 'credentials' */
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->unique_session_token));
		NDR_CHECK(ndr_push_ticket_type(ndr, NDR_SCALARS, r->ticket_type));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->security_token) {
			NDR_CHECK(ndr_push_security_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->security_token));
		}
		if (r->unix_token) {
			NDR_CHECK(ndr_push_security_unix_token(ndr, NDR_SCALARS, r->unix_token));
		}
		if (r->info) {
			NDR_CHECK(ndr_push_auth_user_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
		}
		if (r->unix_info) {
			NDR_CHECK(ndr_push_auth_user_info_unix(ndr, NDR_SCALARS|NDR_BUFFERS, r->unix_info));
		}
		/* [ignore] 'torture' */
		/* [ignore] 'credentials' */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_session_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_session_info *r)
{
	uint32_t _ptr_security_token;
	TALLOC_CTX *_mem_save_security_token_0 = NULL;
	uint32_t _ptr_unix_token;
	TALLOC_CTX *_mem_save_unix_token_0 = NULL;
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	uint32_t _ptr_unix_info;
	TALLOC_CTX *_mem_save_unix_info_0 = NULL;
	uint32_t _ptr_torture;
	uint32_t _ptr_credentials;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_security_token));
		if (_ptr_security_token) {
			NDR_PULL_ALLOC(ndr, r->security_token);
		} else {
			r->security_token = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unix_token));
		if (_ptr_unix_token) {
			NDR_PULL_ALLOC(ndr, r->unix_token);
		} else {
			r->unix_token = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->info);
		} else {
			r->info = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unix_info));
		if (_ptr_unix_info) {
			NDR_PULL_ALLOC(ndr, r->unix_info);
		} else {
			r->unix_info = NULL;
		}
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_torture));
		_ptr_torture = 0;
		if (_ptr_torture) {
		} else {
			r->torture = NULL;
		}
		/* [ignore] 'torture' */
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->session_key));
		NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &_ptr_credentials));
		_ptr_credentials = 0;
		if (_ptr_credentials) {
		} else {
			r->credentials = NULL;
		}
		/* [ignore] 'credentials' */
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->unique_session_token));
		NDR_CHECK(ndr_pull_ticket_type(ndr, NDR_SCALARS, &r->ticket_type));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->security_token) {
			_mem_save_security_token_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->security_token, 0);
			NDR_CHECK(ndr_pull_security_token(ndr, NDR_SCALARS|NDR_BUFFERS, r->security_token));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_security_token_0, 0);
		}
		if (r->unix_token) {
			_mem_save_unix_token_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->unix_token, 0);
			NDR_CHECK(ndr_pull_security_unix_token(ndr, NDR_SCALARS, r->unix_token));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unix_token_0, 0);
		}
		if (r->info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->info, 0);
			NDR_CHECK(ndr_pull_auth_user_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
		if (r->unix_info) {
			_mem_save_unix_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->unix_info, 0);
			NDR_CHECK(ndr_pull_auth_user_info_unix(ndr, NDR_SCALARS|NDR_BUFFERS, r->unix_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unix_info_0, 0);
		}
		/* [ignore] 'torture' */
		/* [ignore] 'credentials' */
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_session_info(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_session_info *r)
{
	ndr_print_auth_session_info(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_session_info(struct ndr_print *ndr, const char *name, const struct auth_session_info *r)
{
	ndr_print_struct(ndr, name, "auth_session_info");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "security_token", r->security_token);
	ndr->depth++;
	if (r->security_token) {
		ndr_print_security_token(ndr, "security_token", r->security_token);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "unix_token", r->unix_token);
	ndr->depth++;
	if (r->unix_token) {
		ndr_print_security_unix_token(ndr, "unix_token", r->unix_token);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "info", r->info);
	ndr->depth++;
	if (r->info) {
		ndr_print_auth_user_info(ndr, "info", r->info);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "unix_info", r->unix_info);
	ndr->depth++;
	if (r->unix_info) {
		ndr_print_auth_user_info_unix(ndr, "unix_info", r->unix_info);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "torture", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->torture);
	/* [ignore] 'torture' */
	ndr_print_ptr(ndr, "credentials", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->credentials);
	/* [ignore] 'credentials' */
	ndr_print_GUID(ndr, "unique_session_token", &r->unique_session_token);
	ndr_print_ticket_type(ndr, "ticket_type", r->ticket_type);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_auth_session_info_transport(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct auth_session_info_transport *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->session_info));
		NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->exported_gssapi_credentials));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->session_info) {
			NDR_CHECK(ndr_push_auth_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->session_info));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_auth_session_info_transport(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct auth_session_info_transport *r)
{
	uint32_t _ptr_session_info;
	TALLOC_CTX *_mem_save_session_info_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_session_info));
		if (_ptr_session_info) {
			NDR_PULL_ALLOC(ndr, r->session_info);
		} else {
			r->session_info = NULL;
		}
		NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->exported_gssapi_credentials));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->session_info) {
			_mem_save_session_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->session_info, 0);
			NDR_CHECK(ndr_pull_auth_session_info(ndr, NDR_SCALARS|NDR_BUFFERS, r->session_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_session_info_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_auth_session_info_transport(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct auth_session_info_transport *r)
{
	ndr_print_auth_session_info_transport(ndr, name, r);
}

_PUBLIC_ void ndr_print_auth_session_info_transport(struct ndr_print *ndr, const char *name, const struct auth_session_info_transport *r)
{
	ndr_print_struct(ndr, name, "auth_session_info_transport");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "session_info", r->session_info);
	ndr->depth++;
	if (r->session_info) {
		ndr_print_auth_session_info(ndr, "session_info", r->session_info);
	}
	ndr->depth--;
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_auth
static const struct ndr_interface_public_struct auth_public_structs[] = {
	{
		.name = "auth_user_info",
		.struct_size = sizeof(struct auth_user_info ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_user_info,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_user_info,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_user_info,
	},
	{
		.name = "auth_user_info_torture",
		.struct_size = sizeof(struct auth_user_info_torture ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_user_info_torture,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_user_info_torture,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_user_info_torture,
	},
	{
		.name = "auth_user_info_unix",
		.struct_size = sizeof(struct auth_user_info_unix ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_user_info_unix,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_user_info_unix,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_user_info_unix,
	},
	{
		.name = "auth_SidAttr",
		.struct_size = sizeof(struct auth_SidAttr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_SidAttr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_SidAttr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_SidAttr,
	},
	{
		.name = "auth_user_info_dc",
		.struct_size = sizeof(struct auth_user_info_dc ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_user_info_dc,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_user_info_dc,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_user_info_dc,
	},
	{
		.name = "auth_session_info",
		.struct_size = sizeof(struct auth_session_info ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_session_info,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_session_info,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_session_info,
	},
	{
		.name = "auth_session_info_transport",
		.struct_size = sizeof(struct auth_session_info_transport ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_auth_session_info_transport,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_auth_session_info_transport,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_auth_session_info_transport,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call auth_calls[] = {
	{ .name = NULL }
};

static const char * const auth_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\auth]", 
};

static const struct ndr_interface_string_array auth_endpoints = {
	.count	= 1,
	.names	= auth_endpoint_strings
};

static const char * const auth_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array auth_authservices = {
	.count	= 1,
	.names	= auth_authservice_strings
};


const struct ndr_interface_table ndr_table_auth = {
	.name		= "auth",
	.num_calls	= 0,
	.calls		= auth_calls,
	.num_public_structs	= 7,
	.public_structs		= auth_public_structs,
	.endpoints	= &auth_endpoints,
	.authservices	= &auth_authservices
};

#endif /* SKIP_NDR_TABLE_auth */
