/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_krb5ccache
#define _PIDL_HEADER_krb5ccache

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#ifndef _HEADER_krb5ccache
#define _HEADER_krb5ccache

struct PRINCIPAL {
	uint32_t name_type;
	uint32_t component_count;
	const char * realm;/* [flag(LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8)] */
	const char * *components;/* [flag(LIBNDR_FLAG_STR_SIZE4|LIBNDR_FLAG_STR_NOTERM|LIBNDR_FLAG_STR_UTF8)] */
};

struct KEYBLOCK {
	uint16_t enctype;
	DATA_BLOB data;
};

struct ADDRESS {
	uint16_t addrtype;
	DATA_BLOB data;
};

struct ADDRESSES {
	uint32_t count;
	struct ADDRESS *data;
};

struct AUTHDATUM {
	uint16_t ad_type;
	DATA_BLOB data;
};

struct AUTHDATA {
	uint32_t count;
	struct AUTHDATUM *data;
};

struct CREDENTIAL {
	struct PRINCIPAL client;
	struct PRINCIPAL server;
	struct KEYBLOCK keyblock;
	uint32_t authtime;
	uint32_t starttime;
	uint32_t endtime;
	uint32_t renew_till;
	uint8_t is_skey;
	uint32_t ticket_flags;
	struct ADDRESSES addresses;
	struct AUTHDATA authdata;
	DATA_BLOB ticket;
	DATA_BLOB second_ticket;
};

struct DELTATIME_TAG {
	int32_t kdc_sec_offset;/* [value(0)] */
	int32_t kdc_usec_offset;/* [value(0)] */
};

union FIELD {
	struct DELTATIME_TAG deltatime_tag;/* [case] */
}/* [nodiscriminant] */;

struct V4TAG {
	uint16_t tag;/* [value] */
	union FIELD field;/* [subcontext(2),switch_is(tag)] */
};

struct V4TAGS {
	struct V4TAG tag;
	DATA_BLOB further_tags;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

struct V4HEADER {
	struct V4TAGS v4tags;/* [subcontext(2)] */
};

union OPTIONAL_HEADER {
	struct V4HEADER v4header;/* [case(4)] */
}/* [nodiscriminant] */;

struct CCACHE {
	uint8_t pvno;/* [value(5)] */
	uint8_t version;/* [value(4)] */
	union OPTIONAL_HEADER optional_header;/* [switch_is(version)] */
	struct PRINCIPAL principal;
	struct CREDENTIAL cred;
	DATA_BLOB further_creds;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [flag(LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX),public] */;

struct MULTIPLE_CREDENTIALS {
	struct CREDENTIAL cred;
	DATA_BLOB further_creds;/* [flag(LIBNDR_FLAG_REMAINING)] */
}/* [flag(LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_BIGENDIAN|LIBNDR_PRINT_ARRAY_HEX),public] */;

#endif /* _HEADER_krb5ccache */
#endif /* _PIDL_HEADER_krb5ccache */
