/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_clusapi
#define _PIDL_HEADER_clusapi

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/winreg.h"
#include "librpc/gen_ndr/misc.h"
#ifndef _HEADER_clusapi
#define _HEADER_clusapi

struct RPC_SECURITY_DESCRIPTOR {
	uint8_t *lpSecurityDescriptor;/* [length_is(cbOutSecurityDescriptor),size_is(cbInSecurityDescriptor),unique] */
	uint32_t cbInSecurityDescriptor;
	uint32_t cbOutSecurityDescriptor;
};

struct RPC_SECURITY_ATTRIBUTES {
	uint32_t nLength;
	struct RPC_SECURITY_DESCRIPTOR RpcSecurityDescriptor;
	int32_t bInheritHandle;
};

struct CLUSTER_OPERATIONAL_VERSION_INFO {
	uint32_t dwSize;/* [value(20)] */
	uint32_t dwClusterHighestVersion;
	uint32_t dwClusterLowestVersion;
	uint32_t dwFlags;
	uint32_t dwReserved;
};

struct IDL_CLUSTER_SET_PASSWORD_STATUS {
	uint32_t NodeId;
	uint8_t SetAttempted;
	uint32_t ReturnStatus;
};

enum IDL_CLUSTER_SET_PASSWORD_FLAGS
#ifndef USE_UINT_ENUMS
 {
	IDL_CLUSTER_SET_PASSWORD_IGNORE_DOWN_NODES=(int)(1)
}
#else
 { __do_not_use_enum_IDL_CLUSTER_SET_PASSWORD_FLAGS=INT_MAX}
#define IDL_CLUSTER_SET_PASSWORD_IGNORE_DOWN_NODES ( 1 )
#endif
;

struct CLUSTER_CREATE_GROUP_INFO_RPC {
	uint32_t dwVersion;
	uint32_t dwGroupType;
};

/* bitmap ClusterEnumType */
#define CLUSTER_ENUM_NODE ( 0x00000001 )
#define CLUSTER_ENUM_RESTYPE ( 0x00000002 )
#define CLUSTER_ENUM_RESOURCE ( 0x00000004 )
#define CLUSTER_ENUM_GROUP ( 0x00000008 )
#define CLUSTER_ENUM_NETWORK ( 0x00000010 )
#define CLUSTER_ENUM_NETINTERFACE ( 0x00000020 )
#define CLUSTER_ENUM_INTERNAL_NETWORK ( 0x80000000 )
#define CLUSTER_ENUM_SHARED_VOLUME_RESOURCE ( 0x40000000 )

struct ENUM_ENTRY {
	uint32_t Type;
	const char *Name;/* [charset(UTF16),unique] */
};

struct ENUM_LIST {
	uint32_t EntryCount;
	struct ENUM_ENTRY *Entry;/* [size_is(EntryCount)] */
};

struct GROUP_ENUM_ENTRY {
	const char *Name;/* [charset(UTF16),unique] */
	const char *Id;/* [charset(UTF16),unique] */
	uint32_t dwState;
	const char *Owner;/* [charset(UTF16),unique] */
	uint32_t dwFlags;
	uint32_t cbProperties;
	uint8_t *Properties;/* [size_is(cbProperties),unique] */
	uint32_t cbRoProperties;
	uint8_t *RoProperties;/* [size_is(cbRoProperties),unique] */
};

struct RESOURCE_ENUM_ENTRY {
	const char *Name;/* [charset(UTF16),unique] */
	const char *Id;/* [charset(UTF16),unique] */
	const char *OwnerName;/* [charset(UTF16),unique] */
	const char *OwnerId;/* [charset(UTF16),unique] */
	uint32_t cbProperties;
	uint8_t *Properties;/* [size_is(cbProperties),unique] */
	uint32_t cbRoProperties;
	uint8_t *RoProperties;/* [size_is(cbRoProperties),unique] */
};

struct GROUP_ENUM_LIST {
	uint32_t EntryCount;
	struct GROUP_ENUM_ENTRY *Entry;/* [size_is(EntryCount)] */
};

struct RESOURCE_ENUM_LIST {
	uint32_t EntryCount;
	struct RESOURCE_ENUM_ENTRY *Entry;/* [size_is(EntryCount)] */
};

enum clusapi_CreateResourceFlags
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_RESOURCE_DEFAULT_MONITOR=(int)(0x00000000),
	CLUSTER_RESOURCE_SEPARATE_MONITOR=(int)(0x00000001)
}
#else
 { __do_not_use_enum_clusapi_CreateResourceFlags=INT_MAX}
#define CLUSTER_RESOURCE_DEFAULT_MONITOR ( 0x00000000 )
#define CLUSTER_RESOURCE_SEPARATE_MONITOR ( 0x00000001 )
#endif
;

enum clusapi_ClusterResourceState
#ifndef USE_UINT_ENUMS
 {
	ClusterResourceInitializing=(int)(0x00000001),
	ClusterResourceOnline=(int)(0x00000002),
	ClusterResourceOffline=(int)(0x00000003),
	ClusterResourceFailed=(int)(0x00000004),
	ClusterResourceOnlinePending=(int)(0x00000081),
	ClusterResourceOfflinePending=(int)(0x00000082),
	ClusterResourceStateUnknown=(int)(0xFFFFFFFF)
}
#else
 { __do_not_use_enum_clusapi_ClusterResourceState=INT_MAX}
#define ClusterResourceInitializing ( 0x00000001 )
#define ClusterResourceOnline ( 0x00000002 )
#define ClusterResourceOffline ( 0x00000003 )
#define ClusterResourceFailed ( 0x00000004 )
#define ClusterResourceOnlinePending ( 0x00000081 )
#define ClusterResourceOfflinePending ( 0x00000082 )
#define ClusterResourceStateUnknown ( 0xFFFFFFFF )
#endif
;

enum clusapi_ClusterGroupState
#ifndef USE_UINT_ENUMS
 {
	ClusterGroupOnline=(int)(0x00000000),
	ClusterGroupOffline=(int)(0x00000001),
	ClusterGroupFailed=(int)(0x00000002),
	ClusterGroupPartialOnline=(int)(0x00000003),
	ClusterGroupPending=(int)(0x00000004),
	ClusterGroupStateUnknown=(int)(0xFFFFFFFF)
}
#else
 { __do_not_use_enum_clusapi_ClusterGroupState=INT_MAX}
#define ClusterGroupOnline ( 0x00000000 )
#define ClusterGroupOffline ( 0x00000001 )
#define ClusterGroupFailed ( 0x00000002 )
#define ClusterGroupPartialOnline ( 0x00000003 )
#define ClusterGroupPending ( 0x00000004 )
#define ClusterGroupStateUnknown ( 0xFFFFFFFF )
#endif
;

/* bitmap ClusterGroupEnumType */
#define CLUSTER_GROUP_ENUM_CONTAINS ( 0x00000001 )
#define CLUSTER_GROUP_ENUM_NODES ( 0x00000002 )

enum clusapi_ClusterNodeState
#ifndef USE_UINT_ENUMS
 {
	ClusterNodeUp=(int)(0x00000000),
	ClusterNodeDown=(int)(0x00000001),
	ClusterNodePaused=(int)(0x00000002),
	ClusterNodeJoining=(int)(0x00000003),
	ClusterNodeStateUnknown=(int)(0xFFFFFFFF)
}
#else
 { __do_not_use_enum_clusapi_ClusterNodeState=INT_MAX}
#define ClusterNodeUp ( 0x00000000 )
#define ClusterNodeDown ( 0x00000001 )
#define ClusterNodePaused ( 0x00000002 )
#define ClusterNodeJoining ( 0x00000003 )
#define ClusterNodeStateUnknown ( 0xFFFFFFFF )
#endif
;

enum clusapi_ResourceClass
#ifndef USE_UINT_ENUMS
 {
	CLUS_RESCLASS_UNKNOWN=(int)(0x00000000),
	CLUS_RESCLASS_STORAGE=(int)(0x00000001),
	CLUS_RESCLASS_NETWORK=(int)(0x00000002)
}
#else
 { __do_not_use_enum_clusapi_ResourceClass=INT_MAX}
#define CLUS_RESCLASS_UNKNOWN ( 0x00000000 )
#define CLUS_RESCLASS_STORAGE ( 0x00000001 )
#define CLUS_RESCLASS_NETWORK ( 0x00000002 )
#endif
;

struct CLUS_RESOURCE_CLASS_INFO {
	enum clusapi_ResourceClass Class;
	uint32_t SubClass;
}/* [public] */;

enum clusapi_ResourceControlCode
#ifndef USE_UINT_ENUMS
 {
	CLUSCTL_RESOURCE_UNKNOWN=(int)(0x01000000),
	CLUSCTL_RESOURCE_GET_CHARACTERISTICS=(int)(0x01000005),
	CLUSCTL_RESOURCE_GET_FLAGS=(int)(0x01000009),
	CLUSCTL_RESOURCE_GET_CLASS_INFO=(int)(0x0100000D),
	CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES=(int)(0x01000011),
	CLUSCTL_RESOURCE_GET_NAME=(int)(0x01000029),
	CLUSCTL_RESOURCE_GET_RESOURCE_TYPE=(int)(0x0100002D),
	CLUSCTL_RESOURCE_GET_ID=(int)(0x01000039),
	CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES=(int)(0x01000051),
	CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES=(int)(0x01000055),
	CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES=(int)(0x01000059),
	CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES=(int)(0x0140005E),
	CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES=(int)(0x01000061),
	CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS=(int)(0x01000065),
	CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES=(int)(0x01000079),
	CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES=(int)(0x0100007D),
	CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES=(int)(0x01000081),
	CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES=(int)(0x01400086),
	CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES=(int)(0x01000089),
	CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS=(int)(0x0100008D),
	CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT=(int)(0x014000A2),
	CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT=(int)(0x014000A6),
	CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS=(int)(0x010000A9),
	CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT=(int)(0x014000AE),
	CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT=(int)(0x014000B2),
	CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS=(int)(0x010000B5),
	CLUSCTL_RESOURCE_UPGRADE_DLL=(int)(0x014000BA),
	CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT=(int)(0x014000BE),
	CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT=(int)(0x014000C2),
	CLUSCTL_RESOURCE_GET_NETWORK_NAME=(int)(0x01000169),
	CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS=(int)(0x01000172),
	CLUSCTL_RESOURCE_GET_DNS_NAME=(int)(0x01000175),
	CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO=(int)(0x0100017A),
	CLUSCTL_RESOURCE_NETNAME_DELETE_CO=(int)(0x0100017E),
	CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO=(int)(0x01000181),
	CLUSCTL_RESOURCE_NETNAME_RESET_VCO=(int)(0x01000185),
	CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED=(int)(0x01c0018a),
	CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO=(int)(0x01000191),
	CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID=(int)(0x01000199),
	CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE=(int)(0x014001BE),
	CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE=(int)(0x014001C2),
	CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE=(int)(0x010001E1),
	CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE=(int)(0x014001E6),
	CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER=(int)(0x014001EA),
	CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX=(int)(0x010001F1),
	CLUSCTL_RESOURCE_STORAGE_GET_DIRTY=(int)(0x01000219),
	CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS=(int)(0x01000211),
	CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO=(int)(0x01000225),
	CLUSCTL_RESOURCE_VM_START_MIGRATION=(int)(0x01600004),
	CLUSCTL_RESOURCE_VM_CANCEL_MIGRATION=(int)(0x01600008),
	CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE=(int)(0x01400296),
	CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO=(int)(0x0140028a),
	CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO=(int)(0x0140028e),
	CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE=(int)(0x0140029a),
	CLUSCTL_RESOURCE_GET_RELATED_RESOURCE_NAMES=(int)(0x01001fad),
	CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO=(int)(0x010002b5),
	CLUSCTL_RESOURCE_CLOUD_WITNESS_UPDATE_TOKEN=(int)(0x014020e6),
	CLUSCTL_RESOURCE_NETNAME_CHECK_OU_PERMISSIONS=(int)(0x07002121),
	CLUSCTL_RESOURCE_NETNAME_CHECK_AD_STATE=(int)(0x07002125)
}
#else
 { __do_not_use_enum_clusapi_ResourceControlCode=INT_MAX}
#define CLUSCTL_RESOURCE_UNKNOWN ( 0x01000000 )
#define CLUSCTL_RESOURCE_GET_CHARACTERISTICS ( 0x01000005 )
#define CLUSCTL_RESOURCE_GET_FLAGS ( 0x01000009 )
#define CLUSCTL_RESOURCE_GET_CLASS_INFO ( 0x0100000D )
#define CLUSCTL_RESOURCE_GET_REQUIRED_DEPENDENCIES ( 0x01000011 )
#define CLUSCTL_RESOURCE_GET_NAME ( 0x01000029 )
#define CLUSCTL_RESOURCE_GET_RESOURCE_TYPE ( 0x0100002D )
#define CLUSCTL_RESOURCE_GET_ID ( 0x01000039 )
#define CLUSCTL_RESOURCE_ENUM_COMMON_PROPERTIES ( 0x01000051 )
#define CLUSCTL_RESOURCE_GET_RO_COMMON_PROPERTIES ( 0x01000055 )
#define CLUSCTL_RESOURCE_GET_COMMON_PROPERTIES ( 0x01000059 )
#define CLUSCTL_RESOURCE_SET_COMMON_PROPERTIES ( 0x0140005E )
#define CLUSCTL_RESOURCE_VALIDATE_COMMON_PROPERTIES ( 0x01000061 )
#define CLUSCTL_RESOURCE_GET_COMMON_PROPERTY_FMTS ( 0x01000065 )
#define CLUSCTL_RESOURCE_ENUM_PRIVATE_PROPERTIES ( 0x01000079 )
#define CLUSCTL_RESOURCE_GET_RO_PRIVATE_PROPERTIES ( 0x0100007D )
#define CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTIES ( 0x01000081 )
#define CLUSCTL_RESOURCE_SET_PRIVATE_PROPERTIES ( 0x01400086 )
#define CLUSCTL_RESOURCE_VALIDATE_PRIVATE_PROPERTIES ( 0x01000089 )
#define CLUSCTL_RESOURCE_GET_PRIVATE_PROPERTY_FMTS ( 0x0100008D )
#define CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT ( 0x014000A2 )
#define CLUSCTL_RESOURCE_DELETE_REGISTRY_CHECKPOINT ( 0x014000A6 )
#define CLUSCTL_RESOURCE_GET_REGISTRY_CHECKPOINTS ( 0x010000A9 )
#define CLUSCTL_RESOURCE_ADD_CRYPTO_CHECKPOINT ( 0x014000AE )
#define CLUSCTL_RESOURCE_DELETE_CRYPTO_CHECKPOINT ( 0x014000B2 )
#define CLUSCTL_RESOURCE_GET_CRYPTO_CHECKPOINTS ( 0x010000B5 )
#define CLUSCTL_RESOURCE_UPGRADE_DLL ( 0x014000BA )
#define CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_64BIT ( 0x014000BE )
#define CLUSCTL_RESOURCE_ADD_REGISTRY_CHECKPOINT_32BIT ( 0x014000C2 )
#define CLUSCTL_RESOURCE_GET_NETWORK_NAME ( 0x01000169 )
#define CLUSCTL_RESOURCE_NETNAME_REGISTER_DNS_RECORDS ( 0x01000172 )
#define CLUSCTL_RESOURCE_GET_DNS_NAME ( 0x01000175 )
#define CLUSCTL_RESOURCE_NETNAME_SET_PWD_INFO ( 0x0100017A )
#define CLUSCTL_RESOURCE_NETNAME_DELETE_CO ( 0x0100017E )
#define CLUSCTL_RESOURCE_NETNAME_VALIDATE_VCO ( 0x01000181 )
#define CLUSCTL_RESOURCE_NETNAME_RESET_VCO ( 0x01000185 )
#define CLUSCTL_RESOURCE_NETNAME_CREDS_UPDATED ( 0x01c0018a )
#define CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO ( 0x01000191 )
#define CLUSCTL_RESOURCE_STORAGE_IS_PATH_VALID ( 0x01000199 )
#define CLUSCTL_RESOURCE_IPADDRESS_RENEW_LEASE ( 0x014001BE )
#define CLUSCTL_RESOURCE_IPADDRESS_RELEASE_LEASE ( 0x014001C2 )
#define CLUSCTL_RESOURCE_QUERY_MAINTENANCE_MODE ( 0x010001E1 )
#define CLUSCTL_RESOURCE_SET_MAINTENANCE_MODE ( 0x014001E6 )
#define CLUSCTL_RESOURCE_STORAGE_SET_DRIVELETTER ( 0x014001EA )
#define CLUSCTL_RESOURCE_STORAGE_GET_DISK_INFO_EX ( 0x010001F1 )
#define CLUSCTL_RESOURCE_STORAGE_GET_DIRTY ( 0x01000219 )
#define CLUSCTL_RESOURCE_STORAGE_GET_MOUNTPOINTS ( 0x01000211 )
#define CLUSCTL_RESOURCE_STORAGE_GET_SHARED_VOLUME_INFO ( 0x01000225 )
#define CLUSCTL_RESOURCE_VM_START_MIGRATION ( 0x01600004 )
#define CLUSCTL_RESOURCE_VM_CANCEL_MIGRATION ( 0x01600008 )
#define CLUSCTL_RESOURCE_SET_CSV_MAINTENANCE_MODE ( 0x01400296 )
#define CLUSCTL_RESOURCE_ENABLE_SHARED_VOLUME_DIRECTIO ( 0x0140028a )
#define CLUSCTL_RESOURCE_DISABLE_SHARED_VOLUME_DIRECTIO ( 0x0140028e )
#define CLUSCTL_RESOURCE_SET_SHARED_VOLUME_BACKUP_MODE ( 0x0140029a )
#define CLUSCTL_RESOURCE_GET_RELATED_RESOURCE_NAMES ( 0x01001fad )
#define CLUSCTL_RESOURCE_POOL_GET_DRIVE_INFO ( 0x010002b5 )
#define CLUSCTL_RESOURCE_CLOUD_WITNESS_UPDATE_TOKEN ( 0x014020e6 )
#define CLUSCTL_RESOURCE_NETNAME_CHECK_OU_PERMISSIONS ( 0x07002121 )
#define CLUSCTL_RESOURCE_NETNAME_CHECK_AD_STATE ( 0x07002125 )
#endif
;

enum clusapi_ResourceTypeControlCode
#ifndef USE_UINT_ENUMS
 {
	CLUSCTL_RESOURCE_TYPE_UNKNOWN=(int)(0x02000000),
	CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS=(int)(0x02000005),
	CLUSCTL_RESOURCE_TYPE_GET_FLAGS=(int)(0x02000009),
	CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO=(int)(0x0200000D),
	CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES=(int)(0x02000011),
	CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT=(int)(0x02000015),
	CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES=(int)(0x02000051),
	CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES=(int)(0x02000055),
	CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES=(int)(0x02000059),
	CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES=(int)(0x0240005E),
	CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES=(int)(0x02000061),
	CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS=(int)(0x02000065),
	CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS=(int)(0x02000069),
	CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES=(int)(0x02000079),
	CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES=(int)(0x0200007D),
	CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES=(int)(0x02000081),
	CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES=(int)(0x02400086),
	CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES=(int)(0x02000089),
	CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS=(int)(0x0200008D),
	CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS=(int)(0x02000091),
	CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS=(int)(0x02000195),
	CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME=(int)(0x02000235),
	CLUSCTL_RESOURCE_TYPE_VALIDATE_PATH=(int)(0x02000231),
	CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY=(int)(0x02000239),
	CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS=(int)(0x020001ED),
	CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX=(int)(0x020001F5),
	CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER=(int)(0x02000201),
	CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID=(int)(0x02000205),
	CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE=(int)(0x02000209),
	CLUSCTL_RESOURCE_TYPE_STORAGE_RELEASE_OWNERSHIP=(int)(0x0240020E),
	CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE=(int)(0x1000229),
	CLUSCTL_RESOURCE_TYPE_CLOUD_WITNESS_VALIDATE_CREDENTIALS=(int)(0x020020e1),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS=(int)(0x02002149),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS=(int)(0x0200214D),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS=(int)(0x02002151),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES=(int)(0x02002159),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME=(int)(0x0200215D),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS=(int)(0x02002155),
	CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP=(int)(0x02002161)
}
#else
 { __do_not_use_enum_clusapi_ResourceTypeControlCode=INT_MAX}
#define CLUSCTL_RESOURCE_TYPE_UNKNOWN ( 0x02000000 )
#define CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS ( 0x02000005 )
#define CLUSCTL_RESOURCE_TYPE_GET_FLAGS ( 0x02000009 )
#define CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO ( 0x0200000D )
#define CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES ( 0x02000011 )
#define CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT ( 0x02000015 )
#define CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES ( 0x02000051 )
#define CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES ( 0x02000055 )
#define CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES ( 0x02000059 )
#define CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES ( 0x0240005E )
#define CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES ( 0x02000061 )
#define CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS ( 0x02000065 )
#define CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS ( 0x02000069 )
#define CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES ( 0x02000079 )
#define CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES ( 0x0200007D )
#define CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES ( 0x02000081 )
#define CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES ( 0x02400086 )
#define CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES ( 0x02000089 )
#define CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS ( 0x0200008D )
#define CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS ( 0x02000091 )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS ( 0x02000195 )
#define CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME ( 0x02000235 )
#define CLUSCTL_RESOURCE_TYPE_VALIDATE_PATH ( 0x02000231 )
#define CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY ( 0x02000239 )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS ( 0x020001ED )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX ( 0x020001F5 )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER ( 0x02000201 )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID ( 0x02000205 )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE ( 0x02000209 )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_RELEASE_OWNERSHIP ( 0x0240020E )
#define CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE ( 0x1000229 )
#define CLUSCTL_RESOURCE_TYPE_CLOUD_WITNESS_VALIDATE_CREDENTIALS ( 0x020020e1 )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS ( 0x02002149 )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS ( 0x0200214D )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS ( 0x02002151 )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES ( 0x02002159 )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME ( 0x0200215D )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS ( 0x02002155 )
#define CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP ( 0x02002161 )
#endif
;

enum clusapi_GroupControlCode
#ifndef USE_UINT_ENUMS
 {
	CLUSCTL_GROUP_UNKNOWN=(int)(0x03000000),
	CLUSCTL_GROUP_GET_CHARACTERISTICS=(int)(0x03000005),
	CLUSCTL_GROUP_GET_FLAGS=(int)(0x03000009),
	CLUSCTL_GROUP_GET_NAME=(int)(0x03000029),
	CLUSCTL_GROUP_GET_ID=(int)(0x03000039),
	CLUSCTL_GROUP_ENUM_COMMON_PROPERTIES=(int)(0x03000051),
	CLUSCTL_GROUP_GET_RO_COMMON_PROPERTIES=(int)(0x03000055),
	CLUSCTL_GROUP_GET_COMMON_PROPERTIES=(int)(0x03000059),
	CLUSCTL_GROUP_SET_COMMON_PROPERTIES=(int)(0x0340005E),
	CLUSCTL_GROUP_VALIDATE_COMMON_PROPERTIES=(int)(0x03000061),
	CLUSCTL_GROUP_GET_COMMON_PROPERTY_FMTS=(int)(0x03000065),
	CLUSCTL_GROUP_ENUM_PRIVATE_PROPERTIES=(int)(0x03000079),
	CLUSCTL_GROUP_GET_RO_PRIVATE_PROPERTIES=(int)(0x0300007D),
	CLUSCTL_GROUP_GET_PRIVATE_PROPERTIES=(int)(0x03000081),
	CLUSCTL_GROUP_SET_PRIVATE_PROPERTIES=(int)(0x03400086),
	CLUSCTL_GROUP_VALIDATE_PRIVATE_PROPERTIES=(int)(0x03000089)
}
#else
 { __do_not_use_enum_clusapi_GroupControlCode=INT_MAX}
#define CLUSCTL_GROUP_UNKNOWN ( 0x03000000 )
#define CLUSCTL_GROUP_GET_CHARACTERISTICS ( 0x03000005 )
#define CLUSCTL_GROUP_GET_FLAGS ( 0x03000009 )
#define CLUSCTL_GROUP_GET_NAME ( 0x03000029 )
#define CLUSCTL_GROUP_GET_ID ( 0x03000039 )
#define CLUSCTL_GROUP_ENUM_COMMON_PROPERTIES ( 0x03000051 )
#define CLUSCTL_GROUP_GET_RO_COMMON_PROPERTIES ( 0x03000055 )
#define CLUSCTL_GROUP_GET_COMMON_PROPERTIES ( 0x03000059 )
#define CLUSCTL_GROUP_SET_COMMON_PROPERTIES ( 0x0340005E )
#define CLUSCTL_GROUP_VALIDATE_COMMON_PROPERTIES ( 0x03000061 )
#define CLUSCTL_GROUP_GET_COMMON_PROPERTY_FMTS ( 0x03000065 )
#define CLUSCTL_GROUP_ENUM_PRIVATE_PROPERTIES ( 0x03000079 )
#define CLUSCTL_GROUP_GET_RO_PRIVATE_PROPERTIES ( 0x0300007D )
#define CLUSCTL_GROUP_GET_PRIVATE_PROPERTIES ( 0x03000081 )
#define CLUSCTL_GROUP_SET_PRIVATE_PROPERTIES ( 0x03400086 )
#define CLUSCTL_GROUP_VALIDATE_PRIVATE_PROPERTIES ( 0x03000089 )
#endif
;

enum clusapi_NodeControlCode
#ifndef USE_UINT_ENUMS
 {
	CLUSCTL_NODE_UNKNOWN=(int)(0x04000000),
	CLUSCTL_NODE_GET_CHARACTERISTICS=(int)(0x04000005),
	CLUSCTL_NODE_GET_FLAGS=(int)(0x04000009),
	CLUSCTL_NODE_GET_NAME=(int)(0x04000029),
	CLUSCTL_NODE_GET_ID=(int)(0x04000039),
	CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME=(int)(0x04000041),
	CLUSCTL_NODE_ENUM_COMMON_PROPERTIES=(int)(0x04000051),
	CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES=(int)(0x04000055),
	CLUSCTL_NODE_GET_COMMON_PROPERTIES=(int)(0x04000059),
	CLUSCTL_NODE_SET_COMMON_PROPERTIES=(int)(0x0440005E),
	CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES=(int)(0x04000061),
	CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES=(int)(0x04000079),
	CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES=(int)(0x0400007D),
	CLUSCTL_NODE_GET_PRIVATE_PROPERTIES=(int)(0x04000081),
	CLUSCTL_NODE_SET_PRIVATE_PROPERTIES=(int)(0x04400086),
	CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES=(int)(0x04000089)
}
#else
 { __do_not_use_enum_clusapi_NodeControlCode=INT_MAX}
#define CLUSCTL_NODE_UNKNOWN ( 0x04000000 )
#define CLUSCTL_NODE_GET_CHARACTERISTICS ( 0x04000005 )
#define CLUSCTL_NODE_GET_FLAGS ( 0x04000009 )
#define CLUSCTL_NODE_GET_NAME ( 0x04000029 )
#define CLUSCTL_NODE_GET_ID ( 0x04000039 )
#define CLUSCTL_NODE_GET_CLUSTER_SERVICE_ACCOUNT_NAME ( 0x04000041 )
#define CLUSCTL_NODE_ENUM_COMMON_PROPERTIES ( 0x04000051 )
#define CLUSCTL_NODE_GET_RO_COMMON_PROPERTIES ( 0x04000055 )
#define CLUSCTL_NODE_GET_COMMON_PROPERTIES ( 0x04000059 )
#define CLUSCTL_NODE_SET_COMMON_PROPERTIES ( 0x0440005E )
#define CLUSCTL_NODE_VALIDATE_COMMON_PROPERTIES ( 0x04000061 )
#define CLUSCTL_NODE_ENUM_PRIVATE_PROPERTIES ( 0x04000079 )
#define CLUSCTL_NODE_GET_RO_PRIVATE_PROPERTIES ( 0x0400007D )
#define CLUSCTL_NODE_GET_PRIVATE_PROPERTIES ( 0x04000081 )
#define CLUSCTL_NODE_SET_PRIVATE_PROPERTIES ( 0x04400086 )
#define CLUSCTL_NODE_VALIDATE_PRIVATE_PROPERTIES ( 0x04000089 )
#endif
;

enum clusapi_ClusterNetworkState
#ifndef USE_UINT_ENUMS
 {
	ClusterNetworkUnavailable=(int)(0x00000000),
	ClusterNetworkDown=(int)(0x00000001),
	ClusterNetworkPartitioned=(int)(0x00000002),
	ClusterNetworkUp=(int)(0x00000003),
	ClusterNetworkStateUnknown=(int)(0xFFFFFFFF)
}
#else
 { __do_not_use_enum_clusapi_ClusterNetworkState=INT_MAX}
#define ClusterNetworkUnavailable ( 0x00000000 )
#define ClusterNetworkDown ( 0x00000001 )
#define ClusterNetworkPartitioned ( 0x00000002 )
#define ClusterNetworkUp ( 0x00000003 )
#define ClusterNetworkStateUnknown ( 0xFFFFFFFF )
#endif
;

enum clusapi_ClusterNetInterfaceState
#ifndef USE_UINT_ENUMS
 {
	ClusterNetInterfaceFailed=(int)(0x00000000),
	ClusterNetInterfaceUnreachable=(int)(0x00000001),
	ClusterNetInterfaceUnavailable=(int)(0x00000002),
	ClusterNetInterfaceUp=(int)(0x00000003),
	ClusterNetInterfaceStateUnknown=(int)(0xFFFFFFFF)
}
#else
 { __do_not_use_enum_clusapi_ClusterNetInterfaceState=INT_MAX}
#define ClusterNetInterfaceFailed ( 0x00000000 )
#define ClusterNetInterfaceUnreachable ( 0x00000001 )
#define ClusterNetInterfaceUnavailable ( 0x00000002 )
#define ClusterNetInterfaceUp ( 0x00000003 )
#define ClusterNetInterfaceStateUnknown ( 0xFFFFFFFF )
#endif
;

/* bitmap ClusterResTypeEnumType */
#define CLUSTER_RESOURCE_TYPE_ENUM_NODES ( 0x00000001 )
#define CLUSTER_RESOURCE_TYPE_ENUM_RESOURCES ( 0x00000002 )

enum clusapi_ClusterControlCode
#ifndef USE_UINT_ENUMS
 {
	CLUSCTL_CLUSTER_UNKNOWN=(int)(0x07000000),
	CLUSCTL_CLUSTER_GET_FQDN=(int)(0x0700003D),
	CLUSCTL_CLUSTER_CHECK_VOTER_EVICT=(int)(0x07000045),
	CLUSCTL_CLUSTER_CHECK_VOTER_DOWN=(int)(0x07000049),
	CLUSCTL_CLUSTER_SHUTDOWN=(int)(0x0700004D),
	CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES=(int)(0x07000051),
	CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES=(int)(0x07000055),
	CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES=(int)(0x07000059),
	CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES=(int)(0x0740005E),
	CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES=(int)(0x07000061),
	CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS=(int)(0x07000065),
	CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES=(int)(0x07000079),
	CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES=(int)(0x0700007D),
	CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES=(int)(0x07000081),
	CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES=(int)(0x07400086),
	CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES=(int)(0x07000089),
	CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID=(int)(0x07000291),
	CLUSCTL_CLUSTER_UPGRADE_CLUSTER_VERSION=(int)(0x074000ce),
	CLUSCTL_CLUSTER_CLEAR_UPGRADE_IN_PROGRESS=(int)(0x074000d2),
	CLUSCTL_CLUSTER_IS_READY_FOR_UPGRADE=(int)(0x070000d5)
}
#else
 { __do_not_use_enum_clusapi_ClusterControlCode=INT_MAX}
#define CLUSCTL_CLUSTER_UNKNOWN ( 0x07000000 )
#define CLUSCTL_CLUSTER_GET_FQDN ( 0x0700003D )
#define CLUSCTL_CLUSTER_CHECK_VOTER_EVICT ( 0x07000045 )
#define CLUSCTL_CLUSTER_CHECK_VOTER_DOWN ( 0x07000049 )
#define CLUSCTL_CLUSTER_SHUTDOWN ( 0x0700004D )
#define CLUSCTL_CLUSTER_ENUM_COMMON_PROPERTIES ( 0x07000051 )
#define CLUSCTL_CLUSTER_GET_RO_COMMON_PROPERTIES ( 0x07000055 )
#define CLUSCTL_CLUSTER_GET_COMMON_PROPERTIES ( 0x07000059 )
#define CLUSCTL_CLUSTER_SET_COMMON_PROPERTIES ( 0x0740005E )
#define CLUSCTL_CLUSTER_VALIDATE_COMMON_PROPERTIES ( 0x07000061 )
#define CLUSCTL_CLUSTER_GET_COMMON_PROPERTY_FMTS ( 0x07000065 )
#define CLUSCTL_CLUSTER_ENUM_PRIVATE_PROPERTIES ( 0x07000079 )
#define CLUSCTL_CLUSTER_GET_RO_PRIVATE_PROPERTIES ( 0x0700007D )
#define CLUSCTL_CLUSTER_GET_PRIVATE_PROPERTIES ( 0x07000081 )
#define CLUSCTL_CLUSTER_SET_PRIVATE_PROPERTIES ( 0x07400086 )
#define CLUSCTL_CLUSTER_VALIDATE_PRIVATE_PROPERTIES ( 0x07000089 )
#define CLUSCTL_CLUSTER_GET_SHARED_VOLUME_ID ( 0x07000291 )
#define CLUSCTL_CLUSTER_UPGRADE_CLUSTER_VERSION ( 0x074000ce )
#define CLUSCTL_CLUSTER_CLEAR_UPGRADE_IN_PROGRESS ( 0x074000d2 )
#define CLUSCTL_CLUSTER_IS_READY_FOR_UPGRADE ( 0x070000d5 )
#endif
;

enum CLUSTER_PROPERTY_SYNTAX
#ifndef USE_UINT_ENUMS
 {
	CLUSPROP_SYNTAX_ENDMARK=(int)(0x00000000),
	CLUSPROP_SYNTAX_NAME=(int)(0x00040003),
	CLUSPROP_SYNTAX_RESCLASS=(int)(0x00020002),
	CLUSPROP_SYNTAX_LIST_VALUE_SZ=(int)(0x00010003),
	CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ=(int)(0x00010004),
	CLUSPROP_SYNTAX_LIST_VALUE_DWORD=(int)(0x00010002),
	CLUSPROP_SYNTAX_LIST_VALUE_BINARY=(int)(0x00010001),
	CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ=(int)(0x00010005),
	CLUSPROP_SYNTAX_LIST_VALUE_LONG=(int)(0x00010007),
	CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ=(int)(0x00010008),
	CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR=(int)(0x00010009),
	CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER=(int)(0x0001000a),
	CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER=(int)(0x00010006),
	CLUSPROP_SYNTAX_LIST_VALUE_WORD=(int)(0x0001000b),
	CLUSPROP_SYNTAX_LIST_VALUE_FILETIME=(int)(0x0001000c),
	CLUSPROP_SYNTAX_DISK_SIGNATURE=(int)(0x00050002),
	CLUSPROP_SYNTAX_SCSI_ADDRESS=(int)(0x00060002),
	CLUSPROP_SYNTAX_DISK_NUMBER=(int)(0x00070002),
	CLUSPROP_SYNTAX_PARTITION_INFO=(int)(0x00080001),
	CLUSPROP_SYNTAX_DISK_SERIALNUMBER=(int)(0x000a0003),
	CLUSPROP_SYNTAX_DISK_GUID=(int)(0x000b0003),
	CLUSPROP_SYNTAX_DISK_SIZE=(int)(0x000c0006),
	CLUSPROP_SYNTAX_PARTITION_INFO_EX=(int)(0x000d0001)
}
#else
 { __do_not_use_enum_CLUSTER_PROPERTY_SYNTAX=INT_MAX}
#define CLUSPROP_SYNTAX_ENDMARK ( 0x00000000 )
#define CLUSPROP_SYNTAX_NAME ( 0x00040003 )
#define CLUSPROP_SYNTAX_RESCLASS ( 0x00020002 )
#define CLUSPROP_SYNTAX_LIST_VALUE_SZ ( 0x00010003 )
#define CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ ( 0x00010004 )
#define CLUSPROP_SYNTAX_LIST_VALUE_DWORD ( 0x00010002 )
#define CLUSPROP_SYNTAX_LIST_VALUE_BINARY ( 0x00010001 )
#define CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ ( 0x00010005 )
#define CLUSPROP_SYNTAX_LIST_VALUE_LONG ( 0x00010007 )
#define CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ ( 0x00010008 )
#define CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR ( 0x00010009 )
#define CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER ( 0x0001000a )
#define CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER ( 0x00010006 )
#define CLUSPROP_SYNTAX_LIST_VALUE_WORD ( 0x0001000b )
#define CLUSPROP_SYNTAX_LIST_VALUE_FILETIME ( 0x0001000c )
#define CLUSPROP_SYNTAX_DISK_SIGNATURE ( 0x00050002 )
#define CLUSPROP_SYNTAX_SCSI_ADDRESS ( 0x00060002 )
#define CLUSPROP_SYNTAX_DISK_NUMBER ( 0x00070002 )
#define CLUSPROP_SYNTAX_PARTITION_INFO ( 0x00080001 )
#define CLUSPROP_SYNTAX_DISK_SERIALNUMBER ( 0x000a0003 )
#define CLUSPROP_SYNTAX_DISK_GUID ( 0x000b0003 )
#define CLUSPROP_SYNTAX_DISK_SIZE ( 0x000c0006 )
#define CLUSPROP_SYNTAX_PARTITION_INFO_EX ( 0x000d0001 )
#endif
;

struct clusapi_propertyValues {
	enum CLUSTER_PROPERTY_SYNTAX Syntax;
	uint32_t Size;
	DATA_BLOB Buffer;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(Size)] */
	DATA_BLOB Padding;/* [flag(LIBNDR_FLAG_ALIGN4)] */
};

struct clusapi_propertyValue {
	enum CLUSTER_PROPERTY_SYNTAX syntax_name;/* [value(CLUSPROP_SYNTAX_NAME)] */
	uint32_t size;/* [value(strlen_m_term(buffer)*2)] */
	const char * buffer;/* [flag(LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2)] */
	DATA_BLOB padding;/* [flag(LIBNDR_FLAG_ALIGN2)] */
	struct clusapi_propertyValues PropertyValues;
	enum CLUSTER_PROPERTY_SYNTAX end_mark;/* [value(CLUSPROP_SYNTAX_ENDMARK)] */
};

struct clusapi_PROPERTY_LIST {
	uint32_t propertyCount;
	struct clusapi_propertyValue *propertyValues;
	enum CLUSTER_PROPERTY_SYNTAX end_mark;/* [value(CLUSPROP_SYNTAX_ENDMARK)] */
}/* [public] */;

/* bitmap clusapi_DesiredAccessMask */
#define CLUSAPI_READ_ACCESS ( 0x00000001 )
#define CLUSAPI_CHANGE_ACCESS ( 0x00000002 )
#define CLUSAPI_GENERIC_READ ( 0x80000000 )
#define CLUSAPI_GENERIC_WRITE ( 0x40000000 )
#define CLUSAPI_GENERIC_EXECUTE ( 0x20000000 )
#define CLUSAPI_GENERIC_ALL ( 0x10000000 )
#define CLUSAPI_MAXIMUM_ALLOWED ( 0x02000000 )

struct NOTIFY_FILTER_AND_TYPE_RPC {
	uint32_t dwObjectType;
	uint64_t FilterFlags;
};

struct NOTIFICATION_DATA_RPC {
	struct NOTIFY_FILTER_AND_TYPE_RPC FilterAndType;
	uint8_t *buffer;/* [size_is(dwBufferSize),unique] */
	uint32_t dwBufferSize;
	const char *ObjectId;/* [charset(UTF16),unique] */
	const char *ParentId;/* [charset(UTF16),unique] */
	const char *Name;/* [charset(UTF16),unique] */
	const char *Type;/* [charset(UTF16),unique] */
};

struct NOTIFICATION_RPC {
	uint32_t *dwNotifyKey;/* [unique] */
	struct NOTIFICATION_DATA_RPC NotificationData;
};

struct CLUSTER_DISKID {
	uint32_t DiskIdType;
	uint8_t DiskIdBlob[16];
};

struct CLUSTER_MRR_NODE_RESPONSE {
	const char *pszNodeName;/* [charset(UTF16),unique] */
	HRESULT ResultCode;
	uint32_t ResultSize;
	uint8_t *pResultData;/* [size_is(ResultSize),unique] */
};

struct CLUSTER_MRR_RESPONSE {
	uint32_t NodeCount;
	struct CLUSTER_MRR_NODE_RESPONSE *pNodes;/* [size_is(NodeCount),unique] */
};

struct NOTIFICATION_DATA_ASYNC_RPC {
	uint32_t dwNotifyKey;
	uint32_t dwFilter;
	const char *Name;/* [charset(UTF16),unique] */
};

enum CLUSDSK_DISKID_ENUM
#ifndef USE_UINT_ENUMS
 {
	DiskIdSignature=(int)(0x00000001),
	DiskIdGuid=(int)(0x00000002),
	DiskIdUnKnown=(int)(0x00001388)
}
#else
 { __do_not_use_enum_CLUSDSK_DISKID_ENUM=INT_MAX}
#define DiskIdSignature ( 0x00000001 )
#define DiskIdGuid ( 0x00000002 )
#define DiskIdUnKnown ( 0x00001388 )
#endif
;

enum CLUSTER_PROPERTY_TYPE
#ifndef USE_UINT_ENUMS
 {
	CLUSPROP_TYPE_ENDMARK=(int)(0x0000),
	CLUSPROP_TYPE_LIST_VALUE=(int)(0x0001),
	CLUSPROP_TYPE_RESCLASS=(int)(0x0002),
	CLUSPROP_TYPE_NAME=(int)(0x0004),
	CLUSPROP_TYPE_SIGNATURE=(int)(0x0005),
	CLUSPROP_TYPE_SCSIADDRESS=(int)(0x0006),
	CLUSPROP_TYPE_DISK_NUMBER=(int)(0x0007),
	CLUSPROP_TYPE_PARTITION_INFO=(int)(0x0008),
	CLUSPROP_TYPE_DISK_SERIALNUMBER=(int)(0x000a),
	CLUSPROP_TYPE_DISK_GUID=(int)(0x000b),
	CLUSPROP_TYPE_DISK_SIZE=(int)(0x000c),
	CLUSPROP_TYPE_PARTITION_INFO_EX=(int)(0x000d)
}
#else
 { __do_not_use_enum_CLUSTER_PROPERTY_TYPE=INT_MAX}
#define CLUSPROP_TYPE_ENDMARK ( 0x0000 )
#define CLUSPROP_TYPE_LIST_VALUE ( 0x0001 )
#define CLUSPROP_TYPE_RESCLASS ( 0x0002 )
#define CLUSPROP_TYPE_NAME ( 0x0004 )
#define CLUSPROP_TYPE_SIGNATURE ( 0x0005 )
#define CLUSPROP_TYPE_SCSIADDRESS ( 0x0006 )
#define CLUSPROP_TYPE_DISK_NUMBER ( 0x0007 )
#define CLUSPROP_TYPE_PARTITION_INFO ( 0x0008 )
#define CLUSPROP_TYPE_DISK_SERIALNUMBER ( 0x000a )
#define CLUSPROP_TYPE_DISK_GUID ( 0x000b )
#define CLUSPROP_TYPE_DISK_SIZE ( 0x000c )
#define CLUSPROP_TYPE_PARTITION_INFO_EX ( 0x000d )
#endif
;

enum CLUSTER_PROPERTY_FORMAT
#ifndef USE_UINT_ENUMS
 {
	CLUSPROP_FORMAT_UNKNOWN=(int)(0x0000),
	CLUSPROP_FORMAT_BINARY=(int)(0x0001),
	CLUSPROP_FORMAT_DWORD=(int)(0x0002),
	CLUSPROP_FORMAT_SZ=(int)(0x0003),
	CLUSPROP_FORMAT_EXPAND_SZ=(int)(0x0004),
	CLUSPROP_FORMAT_MULTI_SZ=(int)(0x0005),
	CLUSPROP_FORMAT_ULARGE_INTEGER=(int)(0x0006),
	CLUSPROP_FORMAT_LONG=(int)(0x0007),
	CLUSPROP_FORMAT_EXPANDED_SZ=(int)(0x0008),
	CLUSPROP_FORMAT_SECURITY_DESCRIPTOR=(int)(0x0009),
	CLUSPROP_FORMAT_LARGE_INTEGER=(int)(0x000a),
	CLUSPROP_FORMAT_WORD=(int)(0x000b),
	CLUSPROP_FORMAT_FILETIME=(int)(0x000c)
}
#else
 { __do_not_use_enum_CLUSTER_PROPERTY_FORMAT=INT_MAX}
#define CLUSPROP_FORMAT_UNKNOWN ( 0x0000 )
#define CLUSPROP_FORMAT_BINARY ( 0x0001 )
#define CLUSPROP_FORMAT_DWORD ( 0x0002 )
#define CLUSPROP_FORMAT_SZ ( 0x0003 )
#define CLUSPROP_FORMAT_EXPAND_SZ ( 0x0004 )
#define CLUSPROP_FORMAT_MULTI_SZ ( 0x0005 )
#define CLUSPROP_FORMAT_ULARGE_INTEGER ( 0x0006 )
#define CLUSPROP_FORMAT_LONG ( 0x0007 )
#define CLUSPROP_FORMAT_EXPANDED_SZ ( 0x0008 )
#define CLUSPROP_FORMAT_SECURITY_DESCRIPTOR ( 0x0009 )
#define CLUSPROP_FORMAT_LARGE_INTEGER ( 0x000a )
#define CLUSPROP_FORMAT_WORD ( 0x000b )
#define CLUSPROP_FORMAT_FILETIME ( 0x000c )
#endif
;

enum CLUS_CHARACTERISTICS
#ifndef USE_UINT_ENUMS
 {
	CLUS_CHAR_UNKNOWN=(int)(0x00000000),
	CLUS_CHAR_QUORUM=(int)(0x00000001),
	CLUS_CHAR_DELETE_REQUIRES_ALL_NODES=(int)(0x00000002),
	CLUS_CHAR_LOCAL_QUORUM=(int)(0x00000004),
	CLUS_CHAR_BROADCAST_DELETE=(int)(0x00000020),
	CLUS_CHAR_SINGLE_CLUSTER_INSTANCE=(int)(0x00000040),
	CLUS_CHAR_SINGLE_GROUP_INSTANCE=(int)(0x00000080),
	CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP=(int)(0x00000100),
	CLUS_CHAR_RESERVED1=(int)(0x00000200),
	CLUS_CHAR_MONITOR_DETACH=(int)(0x00000400),
	CLUS_CHAR_RESERVED2=(int)(0x00000800),
	CLUS_CHAR_RESERVED3=(int)(0x00001000),
	CLUS_CHAR_RESERVED4=(int)(0x00002000)
}
#else
 { __do_not_use_enum_CLUS_CHARACTERISTICS=INT_MAX}
#define CLUS_CHAR_UNKNOWN ( 0x00000000 )
#define CLUS_CHAR_QUORUM ( 0x00000001 )
#define CLUS_CHAR_DELETE_REQUIRES_ALL_NODES ( 0x00000002 )
#define CLUS_CHAR_LOCAL_QUORUM ( 0x00000004 )
#define CLUS_CHAR_BROADCAST_DELETE ( 0x00000020 )
#define CLUS_CHAR_SINGLE_CLUSTER_INSTANCE ( 0x00000040 )
#define CLUS_CHAR_SINGLE_GROUP_INSTANCE ( 0x00000080 )
#define CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP ( 0x00000100 )
#define CLUS_CHAR_RESERVED1 ( 0x00000200 )
#define CLUS_CHAR_MONITOR_DETACH ( 0x00000400 )
#define CLUS_CHAR_RESERVED2 ( 0x00000800 )
#define CLUS_CHAR_RESERVED3 ( 0x00001000 )
#define CLUS_CHAR_RESERVED4 ( 0x00002000 )
#endif
;

enum CLUS_FLAGS
#ifndef USE_UINT_ENUMS
 {
	CLUS_FLAG_CORE=(int)(0x00000001)
}
#else
 { __do_not_use_enum_CLUS_FLAGS=INT_MAX}
#define CLUS_FLAG_CORE ( 0x00000001 )
#endif
;

enum MAINTENANCE_MODE_TYPE
#ifndef USE_UINT_ENUMS
 {
	MaintenanceModeTypeDisableIsAliveCheck=(int)(1),
	MaintenanceModeTypeOfflineResource=(int)(2),
	MaintenanceModeTypeUnclusterResource=(int)(3)
}
#else
 { __do_not_use_enum_MAINTENANCE_MODE_TYPE=INT_MAX}
#define MaintenanceModeTypeDisableIsAliveCheck ( 1 )
#define MaintenanceModeTypeOfflineResource ( 2 )
#define MaintenanceModeTypeUnclusterResource ( 3 )
#endif
;

enum CLUSTER_CHANGE
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_NODE_STATE=(int)(0x00000001),
	CLUSTER_CHANGE_NODE_DELETED=(int)(0x00000002),
	CLUSTER_CHANGE_NODE_ADDED=(int)(0x00000004),
	CLUSTER_CHANGE_NODE_PROPERTY=(int)(0x00000008),
	CLUSTER_CHANGE_REGISTRY_NAME=(int)(0x00000010),
	CLUSTER_CHANGE_REGISTRY_ATTRIBUTES=(int)(0x00000020),
	CLUSTER_CHANGE_REGISTRY_VALUE=(int)(0x00000040),
	CLUSTER_CHANGE_REGISTRY_SUBTREE=(int)(0x00000080),
	CLUSTER_CHANGE_RESOURCE_STATE=(int)(0x00000100),
	CLUSTER_CHANGE_RESOURCE_DELETED=(int)(0x00000200),
	CLUSTER_CHANGE_RESOURCE_ADDED=(int)(0x00000400),
	CLUSTER_CHANGE_RESOURCE_PROPERTY=(int)(0x00000800),
	CLUSTER_CHANGE_GROUP_STATE=(int)(0x00001000),
	CLUSTER_CHANGE_GROUP_DELETED=(int)(0x00002000),
	CLUSTER_CHANGE_GROUP_ADDED=(int)(0x00004000),
	CLUSTER_CHANGE_GROUP_PROPERTY=(int)(0x00008000),
	CLUSTER_CHANGE_RESOURCE_TYPE_DELETED=(int)(0x00010000),
	CLUSTER_CHANGE_RESOURCE_TYPE_ADDED=(int)(0x00020000),
	CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY=(int)(0x00040000),
	CLUSTER_CHANGE_CLUSTER_RECONNECT=(int)(0x00080000),
	CLUSTER_CHANGE_NETWORK_STATE=(int)(0x00100000),
	CLUSTER_CHANGE_NETWORK_DELETED=(int)(0x00200000),
	CLUSTER_CHANGE_NETWORK_ADDED=(int)(0x00400000),
	CLUSTER_CHANGE_NETWORK_PROPERTY=(int)(0x00800000),
	CLUSTER_CHANGE_NETINTERFACE_STATE=(int)(0x01000000),
	CLUSTER_CHANGE_NETINTERFACE_DELETED=(int)(0x02000000),
	CLUSTER_CHANGE_NETINTERFACE_ADDED=(int)(0x04000000),
	CLUSTER_CHANGE_NETINTERFACE_PROPERTY=(int)(0x08000000),
	CLUSTER_CHANGE_QUORUM_STATE=(int)(0x10000000),
	CLUSTER_CHANGE_CLUSTER_STATE=(int)(0x20000000),
	CLUSTER_CHANGE_CLUSTER_PROPERTY=(int)(0x40000000),
	CLUSTER_CHANGE_HANDLE_CLOSE=(int)(0x80000000)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE=INT_MAX}
#define CLUSTER_CHANGE_NODE_STATE ( 0x00000001 )
#define CLUSTER_CHANGE_NODE_DELETED ( 0x00000002 )
#define CLUSTER_CHANGE_NODE_ADDED ( 0x00000004 )
#define CLUSTER_CHANGE_NODE_PROPERTY ( 0x00000008 )
#define CLUSTER_CHANGE_REGISTRY_NAME ( 0x00000010 )
#define CLUSTER_CHANGE_REGISTRY_ATTRIBUTES ( 0x00000020 )
#define CLUSTER_CHANGE_REGISTRY_VALUE ( 0x00000040 )
#define CLUSTER_CHANGE_REGISTRY_SUBTREE ( 0x00000080 )
#define CLUSTER_CHANGE_RESOURCE_STATE ( 0x00000100 )
#define CLUSTER_CHANGE_RESOURCE_DELETED ( 0x00000200 )
#define CLUSTER_CHANGE_RESOURCE_ADDED ( 0x00000400 )
#define CLUSTER_CHANGE_RESOURCE_PROPERTY ( 0x00000800 )
#define CLUSTER_CHANGE_GROUP_STATE ( 0x00001000 )
#define CLUSTER_CHANGE_GROUP_DELETED ( 0x00002000 )
#define CLUSTER_CHANGE_GROUP_ADDED ( 0x00004000 )
#define CLUSTER_CHANGE_GROUP_PROPERTY ( 0x00008000 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_DELETED ( 0x00010000 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_ADDED ( 0x00020000 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY ( 0x00040000 )
#define CLUSTER_CHANGE_CLUSTER_RECONNECT ( 0x00080000 )
#define CLUSTER_CHANGE_NETWORK_STATE ( 0x00100000 )
#define CLUSTER_CHANGE_NETWORK_DELETED ( 0x00200000 )
#define CLUSTER_CHANGE_NETWORK_ADDED ( 0x00400000 )
#define CLUSTER_CHANGE_NETWORK_PROPERTY ( 0x00800000 )
#define CLUSTER_CHANGE_NETINTERFACE_STATE ( 0x01000000 )
#define CLUSTER_CHANGE_NETINTERFACE_DELETED ( 0x02000000 )
#define CLUSTER_CHANGE_NETINTERFACE_ADDED ( 0x04000000 )
#define CLUSTER_CHANGE_NETINTERFACE_PROPERTY ( 0x08000000 )
#define CLUSTER_CHANGE_QUORUM_STATE ( 0x10000000 )
#define CLUSTER_CHANGE_CLUSTER_STATE ( 0x20000000 )
#define CLUSTER_CHANGE_CLUSTER_PROPERTY ( 0x40000000 )
#define CLUSTER_CHANGE_HANDLE_CLOSE ( 0x80000000 )
#endif
;

enum CLUSTER_REG_BATCH_COMMAND
#ifndef USE_UINT_ENUMS
 {
	CLUSREG_SET_VALUE=(int)(1),
	CLUSREG_CREATE_KEY=(int)(2),
	CLUSREG_DELETE_KEY=(int)(3),
	CLUSREG_DELETE_VALUE=(int)(4),
	CLUSREG_VALUE_DELETED=(int)(6),
	CLUSREG_READ_KEY=(int)(7),
	CLUSREG_READ_VALUE=(int)(8),
	CLUSREG_READ_ERROR=(int)(9)
}
#else
 { __do_not_use_enum_CLUSTER_REG_BATCH_COMMAND=INT_MAX}
#define CLUSREG_SET_VALUE ( 1 )
#define CLUSREG_CREATE_KEY ( 2 )
#define CLUSREG_DELETE_KEY ( 3 )
#define CLUSREG_DELETE_VALUE ( 4 )
#define CLUSREG_VALUE_DELETED ( 6 )
#define CLUSREG_READ_KEY ( 7 )
#define CLUSREG_READ_VALUE ( 8 )
#define CLUSREG_READ_ERROR ( 9 )
#endif
;

enum CLUSTER_QUORUM_VALUE
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_QUORUM_MAINTAINED=(int)(0),
	CLUSTER_QUORUM_LOST=(int)(1)
}
#else
 { __do_not_use_enum_CLUSTER_QUORUM_VALUE=INT_MAX}
#define CLUSTER_QUORUM_MAINTAINED ( 0 )
#define CLUSTER_QUORUM_LOST ( 1 )
#endif
;

enum CLUSTER_OBJECT_TYPE
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_OBJECT_TYPE_CLUSTER=(int)(0x00000001),
	CLUSTER_OBJECT_TYPE_GROUP=(int)(0x00000002),
	CLUSTER_OBJECT_TYPE_RESOURCE=(int)(0x00000003),
	CLUSTER_OBJECT_TYPE_RESOURCE_TYPE=(int)(0x00000004),
	CLUSTER_OBJECT_TYPE_NETWORK_INTERFACE=(int)(0x00000005),
	CLUSTER_OBJECT_TYPE_NETWORK=(int)(0x00000006),
	CLUSTER_OBJECT_TYPE_NODE=(int)(0x00000007),
	CLUSTER_OBJECT_TYPE_REGISTRY=(int)(0x00000008),
	CLUSTER_OBJECT_TYPE_QUORUM=(int)(0x00000009),
	CLUSTER_OBJECT_TYPE_SHARED_VOLUME=(int)(0x0000000a)
}
#else
 { __do_not_use_enum_CLUSTER_OBJECT_TYPE=INT_MAX}
#define CLUSTER_OBJECT_TYPE_CLUSTER ( 0x00000001 )
#define CLUSTER_OBJECT_TYPE_GROUP ( 0x00000002 )
#define CLUSTER_OBJECT_TYPE_RESOURCE ( 0x00000003 )
#define CLUSTER_OBJECT_TYPE_RESOURCE_TYPE ( 0x00000004 )
#define CLUSTER_OBJECT_TYPE_NETWORK_INTERFACE ( 0x00000005 )
#define CLUSTER_OBJECT_TYPE_NETWORK ( 0x00000006 )
#define CLUSTER_OBJECT_TYPE_NODE ( 0x00000007 )
#define CLUSTER_OBJECT_TYPE_REGISTRY ( 0x00000008 )
#define CLUSTER_OBJECT_TYPE_QUORUM ( 0x00000009 )
#define CLUSTER_OBJECT_TYPE_SHARED_VOLUME ( 0x0000000a )
#endif
;

enum CLUSTER_CHANGE_CLUSTER_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_CLUSTER_RECONNECT_V2=(int)(0x00000001),
	CLUSTER_CHANGE_CLUSTER_STATE_V2=(int)(0x00000002),
	CLUSTER_CHANGE_CLUSTER_GROUP_ADDED_V2=(int)(0x00000004),
	CLUSTER_CHANGE_CLUSTER_HANDLE_CLOSE_V2=(int)(0x00000008),
	CLUSTER_CHANGE_CLUSTER_NETWORK_ADDED_V2=(int)(0x00000010),
	CLUSTER_CHANGE_CLUSTER_NODE_ADDED_V2=(int)(0x00000020),
	CLUSTER_CHANGE_CLUSTER_RESOURCE_TYPE_ADDED_V2=(int)(0x00000040),
	CLUSTER_CHANGE_CLUSTER_COMMON_PROPERTY_V2=(int)(0x00000080),
	CLUSTER_CHANGE_CLUSTER_PRIVATE_PROPERTY_V2=(int)(0x00000100),
	CLUSTER_CHANGE_CLUSTER_LOST_NOTIFICATIONS_V2=(int)(0x00000200),
	CLUSTER_CHANGE_CLUSTER_RENAME_V2=(int)(0x00000400)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_CLUSTER_V2=INT_MAX}
#define CLUSTER_CHANGE_CLUSTER_RECONNECT_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_CLUSTER_STATE_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_CLUSTER_GROUP_ADDED_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_CLUSTER_HANDLE_CLOSE_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_CLUSTER_NETWORK_ADDED_V2 ( 0x00000010 )
#define CLUSTER_CHANGE_CLUSTER_NODE_ADDED_V2 ( 0x00000020 )
#define CLUSTER_CHANGE_CLUSTER_RESOURCE_TYPE_ADDED_V2 ( 0x00000040 )
#define CLUSTER_CHANGE_CLUSTER_COMMON_PROPERTY_V2 ( 0x00000080 )
#define CLUSTER_CHANGE_CLUSTER_PRIVATE_PROPERTY_V2 ( 0x00000100 )
#define CLUSTER_CHANGE_CLUSTER_LOST_NOTIFICATIONS_V2 ( 0x00000200 )
#define CLUSTER_CHANGE_CLUSTER_RENAME_V2 ( 0x00000400 )
#endif
;

enum CLUSTER_CHANGE_GROUP_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_GROUP_DELETED_V2=(int)(0x00000001),
	CLUSTER_CHANGE_GROUP_COMMON_PROPERTY_V2=(int)(0x00000002),
	CLUSTER_CHANGE_GROUP_PRIVATE_PROPERTY_V2=(int)(0x00000004),
	CLUSTER_CHANGE_GROUP_STATE_V2=(int)(0x00000008),
	CLUSTER_CHANGE_GROUP_OWNER_NODE_V2=(int)(0x00000010),
	CLUSTER_CHANGE_GROUP_PREFERRED_OWNERS_V2=(int)(0x00000020),
	CLUSTER_CHANGE_GROUP_RESOURCE_ADDED_V2=(int)(0x00000040),
	CLUSTER_CHANGE_GROUP_RESOURCE_GAINED_V2=(int)(0x00000080),
	CLUSTER_CHANGE_GROUP_RESOURCE_LOST_V2=(int)(0x00000100),
	CLUSTER_CHANGE_GROUP_HANDLE_CLOSE_V2=(int)(0x00000200)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_GROUP_V2=INT_MAX}
#define CLUSTER_CHANGE_GROUP_DELETED_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_GROUP_COMMON_PROPERTY_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_GROUP_PRIVATE_PROPERTY_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_GROUP_STATE_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_GROUP_OWNER_NODE_V2 ( 0x00000010 )
#define CLUSTER_CHANGE_GROUP_PREFERRED_OWNERS_V2 ( 0x00000020 )
#define CLUSTER_CHANGE_GROUP_RESOURCE_ADDED_V2 ( 0x00000040 )
#define CLUSTER_CHANGE_GROUP_RESOURCE_GAINED_V2 ( 0x00000080 )
#define CLUSTER_CHANGE_GROUP_RESOURCE_LOST_V2 ( 0x00000100 )
#define CLUSTER_CHANGE_GROUP_HANDLE_CLOSE_V2 ( 0x00000200 )
#endif
;

enum CLUSTER_CHANGE_RESOURCE_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_RESOURCE_COMMON_PROPERTY_V2=(int)(0x00000001),
	CLUSTER_CHANGE_RESOURCE_PRIVATE_PROPERTY_V2=(int)(0x00000002),
	CLUSTER_CHANGE_RESOURCE_STATE_V2=(int)(0x00000004),
	CLUSTER_CHANGE_RESOURCE_OWNER_GROUP_V2=(int)(0x00000008),
	CLUSTER_CHANGE_RESOURCE_DEPENDENCIES_V2=(int)(0x00000010),
	CLUSTER_CHANGE_RESOURCE_DEPENDENTS_V2=(int)(0x00000020),
	CLUSTER_CHANGE_RESOURCE_POSSIBLE_OWNERS_V2=(int)(0x00000040),
	CLUSTER_CHANGE_RESOURCE_DELETED_V2=(int)(0x00000080),
	CLUSTER_CHANGE_RESOURCE_DLL_UPGRADED_V2=(int)(0x00000100),
	CLUSTER_CHANGE_RESOURCE_HANDLE_CLOSE_V2=(int)(0x00000200)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_RESOURCE_V2=INT_MAX}
#define CLUSTER_CHANGE_RESOURCE_COMMON_PROPERTY_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_RESOURCE_PRIVATE_PROPERTY_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_RESOURCE_STATE_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_RESOURCE_OWNER_GROUP_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_RESOURCE_DEPENDENCIES_V2 ( 0x00000010 )
#define CLUSTER_CHANGE_RESOURCE_DEPENDENTS_V2 ( 0x00000020 )
#define CLUSTER_CHANGE_RESOURCE_POSSIBLE_OWNERS_V2 ( 0x00000040 )
#define CLUSTER_CHANGE_RESOURCE_DELETED_V2 ( 0x00000080 )
#define CLUSTER_CHANGE_RESOURCE_DLL_UPGRADED_V2 ( 0x00000100 )
#define CLUSTER_CHANGE_RESOURCE_HANDLE_CLOSE_V2 ( 0x00000200 )
#endif
;

enum CHANGE_RESOURCE_TYPE_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_RESOURCE_TYPE_DELETED_V2=(int)(0x00000001),
	CLUSTER_CHANGE_RESOURCE_TYPE_COMMON_PROPERTY_V2=(int)(0x00000002),
	CLUSTER_CHANGE_RESOURCE_TYPE_PRIVATE_PROPERTY_V2=(int)(0x00000004),
	CLUSTER_CHANGE_RESOURCE_TYPE_POSSIBLE_OWNERS_V2=(int)(0x00000008),
	CLUSTER_CHANGE_RESOURCE_TYPE_DLL_UPGRADED_V2=(int)(0x00000010)
}
#else
 { __do_not_use_enum_CHANGE_RESOURCE_TYPE_V2=INT_MAX}
#define CLUSTER_CHANGE_RESOURCE_TYPE_DELETED_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_COMMON_PROPERTY_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_PRIVATE_PROPERTY_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_POSSIBLE_OWNERS_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_RESOURCE_TYPE_DLL_UPGRADED_V2 ( 0x00000010 )
#endif
;

enum CLUSTER_CHANGE_NETINTERFACE_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_NETINTERFACE_DELETED_V2=(int)(0x00000001),
	CLUSTER_CHANGE_NETINTERFACE_COMMON_PROPERTY_V2=(int)(0x00000002),
	CLUSTER_CHANGE_NETINTERFACE_PRIVATE_PROPERTY_V2=(int)(0x00000004),
	CLUSTER_CHANGE_NETINTERFACE_STATE_V2=(int)(0x00000008),
	CLUSTER_CHANGE_NETINTERFACE_HANDLE_CLOSE_V2=(int)(0x00000010)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_NETINTERFACE_V2=INT_MAX}
#define CLUSTER_CHANGE_NETINTERFACE_DELETED_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_NETINTERFACE_COMMON_PROPERTY_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_NETINTERFACE_PRIVATE_PROPERTY_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_NETINTERFACE_STATE_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_NETINTERFACE_HANDLE_CLOSE_V2 ( 0x00000010 )
#endif
;

enum CLUSTER_CHANGE_NETWORK_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_NETWORK_DELETED_V2=(int)(0x00000001),
	CLUSTER_CHANGE_NETWORK_COMMON_PROPERTY_V2=(int)(0x00000002),
	CLUSTER_CHANGE_NETWORK_PRIVATE_PROPERTY_V2=(int)(0x00000004),
	CLUSTER_CHANGE_NETWORK_STATE_V2=(int)(0x00000008),
	CLUSTER_CHANGE_NETWORK_HANDLE_CLOSE_V2=(int)(0x00000010)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_NETWORK_V2=INT_MAX}
#define CLUSTER_CHANGE_NETWORK_DELETED_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_NETWORK_COMMON_PROPERTY_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_NETWORK_PRIVATE_PROPERTY_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_NETWORK_STATE_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_NETWORK_HANDLE_CLOSE_V2 ( 0x00000010 )
#endif
;

enum CLUSTER_CHANGE_NODE_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_NODE_NETINTERFACE_ADDED_V2=(int)(0x00000001),
	CLUSTER_CHANGE_NODE_DELETED_V2=(int)(0x00000002),
	CLUSTER_CHANGE_NODE_COMMON_PROPERTY_V2=(int)(0x00000004),
	CLUSTER_CHANGE_NODE_PRIVATE_PROPERTY_V2=(int)(0x00000008),
	CLUSTER_CHANGE_NODE_STATE_V2=(int)(0x00000010),
	CLUSTER_CHANGE_NODE_GROUP_GAINED_V2=(int)(0x00000020),
	CLUSTER_CHANGE_NODE_GROUP_LOST_V2=(int)(0x00000040),
	CLUSTER_CHANGE_NODE_HANDLE_CLOSE_V2=(int)(0x00000080)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_NODE_V2=INT_MAX}
#define CLUSTER_CHANGE_NODE_NETINTERFACE_ADDED_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_NODE_DELETED_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_NODE_COMMON_PROPERTY_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_NODE_PRIVATE_PROPERTY_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_NODE_STATE_V2 ( 0x00000010 )
#define CLUSTER_CHANGE_NODE_GROUP_GAINED_V2 ( 0x00000020 )
#define CLUSTER_CHANGE_NODE_GROUP_LOST_V2 ( 0x00000040 )
#define CLUSTER_CHANGE_NODE_HANDLE_CLOSE_V2 ( 0x00000080 )
#endif
;

enum CLUSTER_CHANGE_REGISTRY_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_REGISTRY_ATTRIBUTES_V2=(int)(0x00000001),
	CLUSTER_CHANGE_REGISTRY_NAME_V2=(int)(0x00000002),
	CLUSTER_CHANGE_REGISTRY_SUBTREE_V2=(int)(0x00000004),
	CLUSTER_CHANGE_REGISTRY_VALUE_V2=(int)(0x00000008),
	CLUSTER_CHANGE_REGISTRY_HANDLE_CLOSE_V2=(int)(0x00000010)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_REGISTRY_V2=INT_MAX}
#define CLUSTER_CHANGE_REGISTRY_ATTRIBUTES_V2 ( 0x00000001 )
#define CLUSTER_CHANGE_REGISTRY_NAME_V2 ( 0x00000002 )
#define CLUSTER_CHANGE_REGISTRY_SUBTREE_V2 ( 0x00000004 )
#define CLUSTER_CHANGE_REGISTRY_VALUE_V2 ( 0x00000008 )
#define CLUSTER_CHANGE_REGISTRY_HANDLE_CLOSE_V2 ( 0x00000010 )
#endif
;

enum CLUSTER_CHANGE_QUORUM_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_QUORUM_STATE_V2=(int)(0x00000001)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_QUORUM_V2=INT_MAX}
#define CLUSTER_CHANGE_QUORUM_STATE_V2 ( 0x00000001 )
#endif
;

enum CLUSTER_CHANGE_SHARED_VOLUME_V2
#ifndef USE_UINT_ENUMS
 {
	CLUSTER_CHANGE_SHARED_VOLUME_STATE_V2=(int)(0x00000001)
}
#else
 { __do_not_use_enum_CLUSTER_CHANGE_SHARED_VOLUME_V2=INT_MAX}
#define CLUSTER_CHANGE_SHARED_VOLUME_STATE_V2 ( 0x00000001 )
#endif
;

enum clusapi_GroupSetControlCode
#ifndef USE_UINT_ENUMS
 {
	CLUSCTL_GROUPSET_GET_ID=(int)(0x08000039),
	CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES=(int)(0x08000055),
	CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES=(int)(0x08000059),
	CLUSCTL_GROUPSET_GET_GROUPS=(int)(0x08002D71),
	CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS=(int)(0x08002D75),
	CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS=(int)(0x08002D79),
	CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES=(int)(0x0840005E)
}
#else
 { __do_not_use_enum_clusapi_GroupSetControlCode=INT_MAX}
#define CLUSCTL_GROUPSET_GET_ID ( 0x08000039 )
#define CLUSCTL_GROUPSET_GET_RO_COMMON_PROPERTIES ( 0x08000055 )
#define CLUSCTL_GROUPSET_GET_COMMON_PROPERTIES ( 0x08000059 )
#define CLUSCTL_GROUPSET_GET_GROUPS ( 0x08002D71 )
#define CLUSCTL_GROUPSET_GET_PROVIDER_GROUPS ( 0x08002D75 )
#define CLUSCTL_GROUPSET_GET_PROVIDER_GROUPSETS ( 0x08002D79 )
#define CLUSCTL_GROUPSET_SET_COMMON_PROPERTIES ( 0x0840005E )
#endif
;


struct clusapi_OpenCluster {
	struct {
		WERROR *Status;/* [ref] */
		struct policy_handle *Cluster;/* [ref] */
	} out;

};


struct clusapi_CloseCluster {
	struct {
		struct policy_handle *Cluster;/* [ref] */
	} in;

	struct {
		struct policy_handle *Cluster;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetClusterName {
	struct {
		const char *NewClusterName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetClusterName {
	struct {
		const char **ClusterName;/* [charset(UTF16),ref] */
		const char **NodeName;/* [charset(UTF16),ref] */
		WERROR result;
	} out;

};


struct clusapi_GetClusterVersion {
	struct {
		uint16_t *lpwMajorVersion;/* [ref] */
		uint16_t *lpwMinorVersion;/* [ref] */
		uint16_t *lpwBuildNumber;/* [ref] */
		const char **lpszVendorId;/* [charset(UTF16),ref] */
		const char **lpszCSDVersion;/* [charset(UTF16),ref] */
		WERROR result;
	} out;

};


struct clusapi_GetQuorumResource {
	struct {
		const char **lpszResourceName;/* [charset(UTF16),ref] */
		const char **lpszDeviceName;/* [charset(UTF16),ref] */
		uint32_t *pdwMaxQuorumLogSize;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetQuorumResource {
	struct {
		struct policy_handle hResource;
		const char *lpszDeviceName;/* [charset(UTF16),ref] */
		uint32_t dwMaxQuorumLogSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateEnum {
	struct {
		uint32_t dwType;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OpenResource {
	struct {
		const char *lpszResourceName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hResource;/* [ref] */
	} out;

};


struct clusapi_CreateResource {
	struct {
		struct policy_handle hGroup;
		const char *lpszResourceName;/* [charset(UTF16),ref] */
		const char *lpszResourceType;/* [charset(UTF16),ref] */
		enum clusapi_CreateResourceFlags dwFlags;
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hResource;/* [ref] */
	} out;

};


struct clusapi_DeleteResource {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CloseResource {
	struct {
		struct policy_handle *Resource;/* [ref] */
	} in;

	struct {
		struct policy_handle *Resource;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetResourceState {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		enum clusapi_ClusterResourceState *State;/* [ref] */
		const char **NodeName;/* [charset(UTF16),ref] */
		const char **GroupName;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetResourceName {
	struct {
		struct policy_handle hResource;
		const char *lpszResourceName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetResourceId {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		const char **pGuid;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetResourceType {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		const char **lpszResourceType;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_FailResource {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OnlineResource {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OfflineResource {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddResourceDependency {
	struct {
		struct policy_handle hResource;
		struct policy_handle hDependsOn;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RemoveResourceDependency {
	struct {
		struct policy_handle hResource;
		struct policy_handle hDependsOn;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CanResourceBeDependent {
	struct {
		struct policy_handle hResource;
		struct policy_handle hResourceDependent;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateResEnum {
	struct {
		struct policy_handle hResource;
		uint32_t dwType;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddResourceNode {
	struct {
		struct policy_handle hResource;
		struct policy_handle hNode;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RemoveResourceNode {
	struct {
		struct policy_handle hResource;
		struct policy_handle hNode;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ChangeResourceGroup {
	struct {
		struct policy_handle hResource;
		struct policy_handle hGroup;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateResourceType {
	struct {
		const char *lpszTypeName;/* [charset(UTF16),ref] */
		const char *lpszDisplayName;/* [charset(UTF16),ref] */
		const char *lpszDllName;/* [charset(UTF16),ref] */
		uint32_t dwLooksAlive;
		uint32_t dwIsAlive;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_DeleteResourceType {
	struct {
		const char *lpszTypeName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetRootKey {
	struct {
		uint32_t samDesired;
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *phKey;/* [ref] */
	} out;

};


struct clusapi_CreateKey {
	struct {
		struct policy_handle hKey;
		const char *lpSubKey;/* [charset(UTF16),ref] */
		uint32_t dwOptions;
		uint32_t samDesired;
		struct RPC_SECURITY_ATTRIBUTES *lpSecurityAttributes;/* [unique] */
	} in;

	struct {
		uint32_t *lpdwDisposition;/* [ref] */
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *phKey;/* [ref] */
	} out;

};


struct clusapi_OpenKey {
	struct {
		struct policy_handle hKey;
		const char *lpSubKey;/* [charset(UTF16),ref] */
		uint32_t samDesired;
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *phKey;/* [ref] */
	} out;

};


struct clusapi_EnumKey {
	struct {
		struct policy_handle hKey;
		uint32_t dwIndex;
	} in;

	struct {
		const char **KeyName;/* [charset(UTF16),ref] */
		NTTIME *lpftLastWriteTime;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetValue {
	struct {
		struct policy_handle hKey;
		const char *lpValueName;/* [charset(UTF16),ref] */
		enum winreg_Type dwType;
		uint8_t *lpData;/* [ref,size_is(cbData)] */
		uint32_t cbData;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_DeleteValue {
	struct {
		struct policy_handle hKey;
		const char *lpValueName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_QueryValue {
	struct {
		struct policy_handle hKey;
		const char *lpValueName;/* [charset(UTF16),ref] */
		uint32_t cbData;
	} in;

	struct {
		enum winreg_Type *lpValueType;/* [ref] */
		uint8_t *lpData;/* [ref,size_is(cbData)] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_DeleteKey {
	struct {
		struct policy_handle hKey;
		const char *lpSubKey;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_EnumValue {
	struct {
		struct policy_handle hKey;
		uint32_t dwIndex;
		uint32_t *lpcbData;/* [ref] */
	} in;

	struct {
		const char **lpValueName;/* [charset(UTF16),ref] */
		enum winreg_Type *lpType;/* [ref] */
		uint8_t *lpData;/* [ref,size_is(*lpcbData)] */
		uint32_t *TotalSize;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		uint32_t *lpcbData;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CloseKey {
	struct {
		struct policy_handle *pKey;/* [ref] */
	} in;

	struct {
		struct policy_handle *pKey;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_QueryInfoKey {
	struct {
		struct policy_handle hKey;
	} in;

	struct {
		uint32_t *lpcSubKeys;/* [ref] */
		uint32_t *lpcbMaxSubKeyLen;/* [ref] */
		uint32_t *lpcValues;/* [ref] */
		uint32_t *lpcbMaxValueNameLen;/* [ref] */
		uint32_t *lpcbMaxValueLen;/* [ref] */
		uint32_t *lpcbSecurityDescriptor;/* [ref] */
		NTTIME *lpftLastWriteTime;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetKeySecurity {
	struct {
		struct policy_handle hKey;
		uint32_t SecurityInformation;
		struct RPC_SECURITY_DESCRIPTOR *pRpcSecurityDescriptor;/* [ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetKeySecurity {
	struct {
		struct policy_handle hKey;
		uint32_t SecurityInformation;
		struct RPC_SECURITY_DESCRIPTOR *pRpcSecurityDescriptor;/* [ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		struct RPC_SECURITY_DESCRIPTOR *pRpcSecurityDescriptor;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OpenGroup {
	struct {
		const char *lpszGroupName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hGroup;/* [ref] */
	} out;

};


struct clusapi_CreateGroup {
	struct {
		const char *lpszGroupName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hGroup;/* [ref] */
	} out;

};


struct clusapi_DeleteGroup {
	struct {
		struct policy_handle Group;
		uint8_t force;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CloseGroup {
	struct {
		struct policy_handle *Group;/* [ref] */
	} in;

	struct {
		struct policy_handle *Group;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetGroupState {
	struct {
		struct policy_handle hGroup;
	} in;

	struct {
		enum clusapi_ClusterGroupState *State;/* [ref] */
		const char **NodeName;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetGroupName {
	struct {
		struct policy_handle hGroup;
		const char *lpszGroupName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetGroupId {
	struct {
		struct policy_handle hGroup;
	} in;

	struct {
		const char **pGuid;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNodeId {
	struct {
		struct policy_handle hNode;
	} in;

	struct {
		const char **pGuid;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OnlineGroup {
	struct {
		struct policy_handle hGroup;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OfflineGroup {
	struct {
		struct policy_handle hGroup;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_MoveGroup {
	struct {
		struct policy_handle hGroup;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_MoveGroupToNode {
	struct {
		struct policy_handle hGroup;
		struct policy_handle hNode;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateGroupResourceEnum {
	struct {
		struct policy_handle hGroup;
		uint32_t dwType;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetGroupNodeList {
	struct {
		struct policy_handle hGroup;
		uint16_t *multiSzNodeList;/* [size_is(cchListSize),unique] */
		uint32_t cchListSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateNotify {
	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNotify;/* [ref] */
	} out;

};


struct clusapi_CloseNotify {
	struct {
		struct policy_handle *Notify;/* [ref] */
	} in;

	struct {
		struct policy_handle *Notify;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyCluster {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hCluster;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyNode {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hNode;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
	} in;

	struct {
		uint32_t *dwStateSequence;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyGroup {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hGroup;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
	} in;

	struct {
		uint32_t *dwStateSequence;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyResource {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hResource;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
	} in;

	struct {
		uint32_t *dwStateSequence;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyKey {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hKey;
		uint32_t dwNotifyKey;
		uint32_t Filter;
		uint8_t WatchSubTree;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ReAddNotifyNode {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hNode;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
		uint32_t StateSequence;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ReAddNotifyGroup {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hGroup;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
		uint32_t StateSequence;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ReAddNotifyResource {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hResource;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
		uint32_t StateSequence;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNotify {
	struct {
		struct policy_handle hNotify;
	} in;

	struct {
		uint32_t *dwNotifyKey;/* [ref] */
		uint32_t *dwFilter;/* [ref] */
		uint32_t *dwStateSequence;/* [ref] */
		const char **Name;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OpenNode {
	struct {
		const char *lpszNodeName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNode;/* [ref] */
	} out;

};


struct clusapi_CloseNode {
	struct {
		struct policy_handle *Node;/* [ref] */
	} in;

	struct {
		struct policy_handle *Node;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNodeState {
	struct {
		struct policy_handle hNode;
	} in;

	struct {
		enum clusapi_ClusterNodeState *State;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_PauseNode {
	struct {
		struct policy_handle hNode;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ResumeNode {
	struct {
		struct policy_handle hNode;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_EvictNode {
	struct {
		struct policy_handle hNode;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeResourceControl {
	struct {
		struct policy_handle hResource;
		struct policy_handle hNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ResourceControl {
	struct {
		struct policy_handle hResource;
		enum clusapi_ResourceControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeResourceTypeControl {
	struct {
		struct policy_handle hCluster;
		const char *lpszResourceTypeName;/* [charset(UTF16),ref] */
		struct policy_handle hNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ResourceTypeControl {
	struct {
		struct policy_handle hCluster;
		const char *lpszResourceTypeName;/* [charset(UTF16),ref] */
		enum clusapi_ResourceTypeControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeGroupControl {
	struct {
		struct policy_handle hGroup;
		struct policy_handle hNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GroupControl {
	struct {
		struct policy_handle hGroup;
		enum clusapi_GroupControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeNodeControl {
	struct {
		struct policy_handle hNode;
		struct policy_handle hHostNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeControl {
	struct {
		struct policy_handle hNode;
		enum clusapi_NodeControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum80NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct clusapi_OpenNetwork {
	struct {
		const char *lpszNetworkName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNetwork;/* [ref] */
	} out;

};


struct clusapi_CloseNetwork {
	struct {
		struct policy_handle *Network;/* [ref] */
	} in;

	struct {
		struct policy_handle *Network;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNetworkState {
	struct {
		struct policy_handle hNetwork;
	} in;

	struct {
		enum clusapi_ClusterNetworkState *State;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetNetworkName {
	struct {
		struct policy_handle hNetwork;
		const char *lpszNetworkName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateNetworkEnum {
	struct {
		struct policy_handle hNetwork;
		uint32_t dwType;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNetworkId {
	struct {
		struct policy_handle hNetwork;
	} in;

	struct {
		const char **pGuid;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetNetworkPriorityOrder {
	struct {
		uint32_t NetworkCount;/* [range(0,1000)] */
		const char *NetworkIdList;/* [charset(UTF16),size_is(NetworkCount)] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeNetworkControl {
	struct {
		struct policy_handle hNetwork;
		struct policy_handle hNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NetworkControl {
	struct {
		struct policy_handle hNetwork;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyNetwork {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hNetwork;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
	} in;

	struct {
		uint32_t *dwStateSequence;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ReAddNotifyNetwork {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hNetwork;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
		uint32_t StateSequence;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OpenNetInterface {
	struct {
		const char *lpszNetInterfaceName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNetInterface;/* [ref] */
	} out;

};


struct clusapi_CloseNetInterface {
	struct {
		struct policy_handle *NetInterface;/* [ref] */
	} in;

	struct {
		struct policy_handle *NetInterface;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNetInterfaceState {
	struct {
		struct policy_handle hNetInterface;
	} in;

	struct {
		enum clusapi_ClusterNetInterfaceState *State;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNetInterface {
	struct {
		const char *lpszNodeName;/* [charset(UTF16),ref] */
		const char *lpszNetworkName;/* [charset(UTF16),ref] */
	} in;

	struct {
		const char **lppszInterfaceName;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNetInterfaceId {
	struct {
		struct policy_handle hNetInterface;
	} in;

	struct {
		const char **pGuid;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeNetInterfaceControl {
	struct {
		struct policy_handle hNetInterface;
		struct policy_handle hNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NetInterfaceControl {
	struct {
		struct policy_handle hNetInterface;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddNotifyNetInterface {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hNetInterface;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
	} in;

	struct {
		uint32_t *dwStateSequence;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ReAddNotifyNetInterface {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hNetInterface;
		uint32_t dwFilter;
		uint32_t dwNotifyKey;
		uint32_t StateSequence;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateNodeEnum {
	struct {
		struct policy_handle hNode;
		uint32_t dwType;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetClusterVersion2 {
	struct {
		uint16_t *lpwMajorVersion;/* [ref] */
		uint16_t *lpwMinorVersion;/* [ref] */
		uint16_t *lpwBuildNumber;/* [ref] */
		const char **lpszVendorId;/* [charset(UTF16),ref] */
		const char **lpszCSDVersion;/* [charset(UTF16),ref] */
		struct CLUSTER_OPERATIONAL_VERSION_INFO **ppClusterOpVerInfo;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateResTypeEnum {
	struct {
		const char *lpszTypeName;/* [charset(UTF16),ref] */
		uint32_t dwType;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_BackupClusterDatabase {
	struct {
		const char *lpszPathName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeClusterControl {
	struct {
		struct policy_handle hCluster;
		struct policy_handle hHostNode;
		uint32_t dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ClusterControl {
	struct {
		struct policy_handle hCluster;
		enum clusapi_ClusterControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_UnblockGetNotifyCall {
	struct {
		struct policy_handle hNotify;
	} in;

	struct {
		WERROR result;
	} out;

};


struct clusapi_SetServiceAccountPassword {
	struct {
		const char *lpszNewPassword;/* [charset(UTF16),ref] */
		enum IDL_CLUSTER_SET_PASSWORD_FLAGS dwFlags;
		uint32_t ReturnStatusBufferSize;/* [range(0,(64*1024))] */
	} in;

	struct {
		struct IDL_CLUSTER_SET_PASSWORD_STATUS *ReturnStatusBufferPtr;/* [length_is(*SizeReturned),size_is(ReturnStatusBufferSize)] */
		uint32_t *SizeReturned;/* [ref] */
		uint32_t *ExpectedBufferSize;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetResourceDependencyExpression {
	struct {
		struct policy_handle hResource;
		const char *lpszDependencyExpression;/* [charset(UTF16),unique] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetResourceDependencyExpression {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		const char **lpszDependencyExpression;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum111NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct clusapi_GetResourceNetworkName {
	struct {
		struct policy_handle hResource;
	} in;

	struct {
		const char **lpszName;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ExecuteBatch {
	struct {
		struct policy_handle hKey;
		uint32_t cbData;
		uint8_t *lpData;/* [ref,size_is(cbData)] */
	} in;

	struct {
		int32_t *pdwFailedCommand;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateBatchPort {
	struct {
		struct policy_handle hKey;
	} in;

	struct {
		struct policy_handle *phBatchPort;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetBatchNotification {
	struct {
		struct policy_handle hBatchNotify;
	} in;

	struct {
		uint32_t *cbData;/* [ref] */
		uint8_t **lpData;/* [ref,size_is(,*cbData)] */
		WERROR result;
	} out;

};


struct clusapi_CloseBatchPort {
	struct {
		struct policy_handle *phBatchPort;/* [ref] */
	} in;

	struct {
		struct policy_handle *phBatchPort;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OpenClusterEx {
	struct {
		uint32_t dwDesiredAccess;
	} in;

	struct {
		uint32_t *lpdwGrantedAccess;/* [ref] */
		WERROR *Status;/* [ref] */
		struct policy_handle *hCluster;/* [ref] */
	} out;

};


struct clusapi_OpenNodeEx {
	struct {
		const char *lpszNodeName;/* [charset(UTF16),ref] */
		uint32_t dwDesiredAccess;
	} in;

	struct {
		uint32_t *lpdwGrantedAccess;/* [ref] */
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNode;/* [ref] */
	} out;

};


struct clusapi_OpenGroupEx {
	struct {
		const char *lpszGroupName;/* [charset(UTF16),ref] */
		uint32_t dwDesiredAccess;
	} in;

	struct {
		uint32_t *lpdwGrantedAccess;/* [ref] */
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hGroup;/* [ref] */
	} out;

};


struct clusapi_OpenResourceEx {
	struct {
		const char *lpszResourceName;/* [charset(UTF16),ref] */
		uint32_t dwDesiredAccess;
	} in;

	struct {
		uint32_t *lpdwGrantedAccess;/* [ref] */
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hResource;/* [ref] */
	} out;

};


struct clusapi_OpenNetworkEx {
	struct {
		const char *lpszNetworkName;/* [charset(UTF16),ref] */
		uint32_t dwDesiredAccess;
	} in;

	struct {
		uint32_t *lpdwGrantedAccess;/* [ref] */
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNetwork;/* [ref] */
	} out;

};


struct clusapi_OpenNetInterfaceEx {
	struct {
		const char *lpszNetInterfaceName;/* [charset(UTF16),ref] */
		uint32_t dwDesiredAccess;
	} in;

	struct {
		uint32_t *lpdwGrantedAccess;/* [ref] */
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNetInterface;/* [ref] */
	} out;

};


struct clusapi_ChangeCsvState {
	struct {
		struct policy_handle hResource;
		uint32_t dwState;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateNodeEnumEx {
	struct {
		struct policy_handle hNode;
		uint32_t dwType;
		uint32_t dwOptions;
	} in;

	struct {
		struct ENUM_LIST **ReturnIdEnum;/* [ref] */
		struct ENUM_LIST **ReturnNameEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateEnumEx {
	struct {
		struct policy_handle hCluster;
		uint32_t dwType;
		uint32_t dwOptions;
	} in;

	struct {
		struct ENUM_LIST **ReturnIdEnum;/* [ref] */
		struct ENUM_LIST **ReturnNameEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_PauseNodeEx {
	struct {
		struct policy_handle hNode;
		uint8_t bDrainNode;
		uint32_t dwPauseFlags;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_PauseNodeWithDrainTarget {
	struct {
		struct policy_handle hNode;
		uint32_t dwPauseFlags;
		struct policy_handle hNodeDrainTarget;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ResumeNodeEx {
	struct {
		struct policy_handle hNode;
		uint32_t dwResumeFailbackType;
		uint32_t dwResumeFlagsReserved;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateGroupEx {
	struct {
		const char *lpszGroupName;/* [charset(UTF16),ref] */
		struct CLUSTER_CREATE_GROUP_INFO_RPC *pGroupInfo;/* [unique] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hGroup;/* [ref] */
	} out;

};


struct clusapi_OnlineGroupEx {
	struct {
		struct policy_handle hGroup;
		uint32_t dwOnlineFlags;
		uint8_t *lpInBuffer;/* [ref,size_is(cbInBufferSize)] */
		uint32_t cbInBufferSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OfflineGroupEx {
	struct {
		struct policy_handle hGroup;
		uint32_t dwOfflineFlags;
		uint8_t *lpInBuffer;/* [ref,size_is(cbInBufferSize)] */
		uint32_t cbInBufferSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_MoveGroupEx {
	struct {
		struct policy_handle hGroup;
		uint32_t dwMoveFlags;
		uint8_t *lpInBuffer;/* [ref,size_is(cbInBufferSize)] */
		uint32_t cbInBufferSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_MoveGroupToNodeEx {
	struct {
		struct policy_handle hGroup;
		struct policy_handle hNode;
		uint32_t dwMoveFlags;
		uint8_t *lpInBuffer;/* [ref,size_is(cbInBufferSize)] */
		uint32_t cbInBufferSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CancelClusterGroupOperation {
	struct {
		struct policy_handle hGroup;
		uint32_t dwCancelFlags;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OnlineResourceEx {
	struct {
		struct policy_handle hResource;
		uint32_t dwOnlineFlags;
		uint8_t *lpInBuffer;/* [ref,size_is(cbInBufferSize)] */
		uint32_t cbInBufferSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_OfflineResourceEx {
	struct {
		struct policy_handle hResource;
		uint32_t dwOfflineFlags;
		uint8_t *lpInBuffer;/* [ref,size_is(cbInBufferSize)] */
		uint32_t cbInBufferSize;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateNotifyV2 {
	struct {
		WERROR *rpc_error;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hNotify;/* [ref] */
	} out;

};


struct clusapi_AddNotifyV2 {
	struct {
		struct policy_handle hNotify;
		struct policy_handle hObject;
		struct NOTIFY_FILTER_AND_TYPE_RPC filter;
		uint32_t dwNotifyKey;
		uint32_t dwVersion;
		uint8_t isTargetedAtObject;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNotifyV2 {
	struct {
		struct policy_handle hNotify;
	} in;

	struct {
		struct NOTIFICATION_RPC **Notifications;/* [ref,size_is(,*dwNumNotifications)] */
		uint32_t *dwNumNotifications;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_QueryAllValues {
	struct {
		struct policy_handle hKey;
	} in;

	struct {
		uint32_t *pcbData;/* [ref] */
		uint8_t **ppData;/* [ref,size_is(1,*pcbData)] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_StmFindDisk {
	struct {
		struct policy_handle hCluster;
		uint32_t dwFlags;
		uint8_t *pUniqueId;/* [size_is(uniqueIdSize),unique] */
		uint32_t uniqueIdSize;
		struct CLUSTER_DISKID *pDiskId;/* [unique] */
	} in;

	struct {
		const char **ppszDeviceName;/* [charset(UTF16),ref] */
		WERROR *rpc_status;/* [ref] */
		struct CLUSTER_DISKID *pDiskId;/* [unique] */
		WERROR result;
	} out;

};


struct clusapi_ClusterMrr {
	struct {
		struct policy_handle hCluster;
		uint8_t fExcludeSelf;
		uint64_t nodeSet;
		uint32_t dwTimeout;
		uint32_t dwComponent;
		uint32_t dwControlCode;
		uint32_t inSize;
		uint8_t *pInData;/* [size_is(inSize),unique] */
	} in;

	struct {
		struct CLUSTER_MRR_RESPONSE **ppInfo;/* [ref,size_is(1,1)] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateGroupEnum {
	struct {
		struct policy_handle hCluster;
		uint8_t *pProperties;/* [size_is(cbProperties),unique] */
		uint32_t cbProperties;
		uint8_t *pRoProperties;/* [size_is(cbRoProperties),unique] */
		uint32_t cbRoProperties;
	} in;

	struct {
		struct GROUP_ENUM_LIST **ppResultList;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateResourceEnum {
	struct {
		struct policy_handle hCluster;
		uint8_t *pProperties;/* [size_is(cbProperties),unique] */
		uint32_t cbProperties;
		uint8_t *pRoProperties;/* [size_is(cbRoProperties),unique] */
		uint32_t cbRoProperties;
	} in;

	struct {
		struct RESOURCE_ENUM_LIST **ppResultList;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ExecuteReadBatch {
	struct {
		struct policy_handle hKey;
		uint32_t cbInData;
		uint8_t *lpInData;/* [ref,size_is(cbInData)] */
	} in;

	struct {
		uint32_t *cbOutData;/* [ref] */
		uint8_t **lpOutData;/* [ref,size_is(,*cbOutData)] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RestartResource {
	struct {
		struct policy_handle hResource;
		uint32_t dwFlags;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GetNotifyAsync {
	struct {
		struct policy_handle hNotify;
	} in;

	struct {
		struct NOTIFICATION_DATA_ASYNC_RPC **Notifications;/* [ref,size_is(,*dwNumNotifications)] */
		uint32_t *dwNumNotifications;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum148NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum149otUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum150NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum151NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum152NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum153NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum154NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct clusapi_AddNotifyResourceTypeV2 {
	struct {
		struct policy_handle hNotify;
		uint64_t filter;
		uint32_t dwNotifyKey;
		const char *resTypeName;/* [charset(UTF16),ref] */
		uint32_t dwVersion;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum156NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct clusapi_ExecuteReadBatchEx {
	struct {
		struct policy_handle hKey;
		uint32_t cbInData;
		uint8_t *lpInData;/* [ref,size_is(cbInData)] */
		uint32_t flags;
	} in;

	struct {
		uint32_t *cbOutData;/* [ref] */
		uint8_t **lpOutData;/* [ref,size_is(,*cbOutData)] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum158NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum159NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum160NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum161NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct Opnum162NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct clusapi_CreateGroupSet {
	struct {
		const char *lpszGroupSetName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hGroupSet;/* [ref] */
	} out;

};


struct clusapi_OpenGroupSet {
	struct {
		const char *lpszGroupSetName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *Status;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		struct policy_handle *hGroupSet;/* [ref] */
	} out;

};


struct clusapi_CloseGroupSet {
	struct {
		struct policy_handle *GroupSet;/* [ref] */
	} in;

	struct {
		struct policy_handle *GroupSet;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_DeleteGroupSet {
	struct {
		struct policy_handle GroupSet;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddGroupToGroupSet {
	struct {
		struct policy_handle GroupSet;
		struct policy_handle Group;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RemoveGroupFromGroupSet {
	struct {
		struct policy_handle Group;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_MoveGroupToGroupSet {
	struct {
		struct policy_handle GroupSet;
		struct policy_handle Group;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct Opnum170NotUsedOnWire {
	struct {
		WERROR result;
	} out;

};


struct clusapi_AddGroupSetDependency {
	struct {
		struct policy_handle DependentGroupSet;
		struct policy_handle ProviderGroupSet;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddGroupToGroupSetDependency {
	struct {
		struct policy_handle DependentGroup;
		struct policy_handle ProviderGroupSet;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_NodeGroupSetControl {
	struct {
		struct policy_handle hGroupSet;
		struct policy_handle hNode;
		enum clusapi_GroupSetControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;/* [range(0,0x7FFFFFFF)] */
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_GroupSetControl {
	struct {
		struct policy_handle hGroupSet;
		enum clusapi_GroupSetControlCode dwControlCode;
		uint8_t *lpInBuffer;/* [size_is(nInBufferSize),unique] */
		uint32_t nInBufferSize;
		uint32_t nOutBufferSize;/* [range(0,0x7FFFFFFF)] */
	} in;

	struct {
		uint8_t *lpOutBuffer;/* [length_is(*lpBytesReturned),ref,size_is(nOutBufferSize)] */
		uint32_t *lpBytesReturned;/* [ref] */
		uint32_t *lpcbRequired;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetGroupDependencyExpression {
	struct {
		struct policy_handle hGroup;
		const char *lpszDependencyExpression;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RemoveClusterGroupDependency {
	struct {
		struct policy_handle hGroup;
		struct policy_handle hDependsOn;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_SetGroupSetDependencyExpression {
	struct {
		struct policy_handle hGroupSet;
		const char *lpszDependencyExpression;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RemoveGroupSetDependency {
	struct {
		struct policy_handle hGroupSet;
		struct policy_handle hDependsOn;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_RemoveClusterGroupToGroupSetDependency {
	struct {
		struct policy_handle hGroup;
		struct policy_handle hDependsOn;
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateGroupSetEnum {
	struct {
		struct policy_handle hCluster;
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_CreateNetInterfaceEnum {
	struct {
		struct policy_handle hCluster;
		const char *lpszNodeName;/* [charset(UTF16),ref] */
		const char *lpszNetworkName;/* [charset(UTF16),ref] */
	} in;

	struct {
		struct ENUM_LIST **ReturnEnum;/* [ref] */
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_ChangeCsvStateEx {
	struct {
		struct policy_handle hResource;
		uint32_t dwState;
		const char *lpszVolumeName;/* [charset(UTF16),ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};


struct clusapi_AddGroupToGroupSetEx {
	struct {
		struct policy_handle GroupSet;
		struct policy_handle Group;
		uint32_t FaultDomain;
		uint32_t UpdateDomain;
		uint8_t UseDomains;
		uint32_t *Reserved;/* [ref] */
	} in;

	struct {
		WERROR *rpc_status;/* [ref] */
		WERROR result;
	} out;

};

#endif /* _HEADER_clusapi */
#endif /* _PIDL_HEADER_clusapi */
