/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_backupkey
#define _PIDL_HEADER_backupkey

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_backupkey
#define _HEADER_backupkey

#define BACKUPKEY_RESTORE_GUID	( "47270C64-2FC7-499B-AC5B-0E37CDCE899A" )
#define BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID	( "018FF48A-EABA-40C6-8F6D-72370240E967" )
#define BACKUPKEY_RESTORE_GUID_WIN2K	( "7FE94D50-178E-11D1-AB8F-00805F14DB40" )
#define BACKUPKEY_BACKUP_GUID	( "7F752B10-178E-11D1-AB8F-00805F14DB40" )
struct bkrp_exported_RSA_key_pair {
	uint32_t header1;/* [value(0x00000002)] */
	uint32_t header2;/* [value(0x00000494)] */
	uint32_t certificate_len;
	uint32_t magic1;/* [value(0x00000207)] */
	uint32_t magic2;/* [value(0x0000A400)] */
	uint32_t magic3;/* [value(0x32415352)] */
	uint32_t magic4;/* [value(0x00000800)] */
	DATA_BLOB public_exponent;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(4)] */
	DATA_BLOB modulus;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(256)] */
	DATA_BLOB prime1;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(128)] */
	DATA_BLOB prime2;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(128)] */
	DATA_BLOB exponent1;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(128)] */
	DATA_BLOB exponent2;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(128)] */
	DATA_BLOB coefficient;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(128)] */
	DATA_BLOB private_exponent;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(256)] */
	DATA_BLOB cert;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0),subcontext_size(certificate_len)] */
};

struct bkrp_dc_serverwrap_key {
	uint32_t magic;/* [value(0x00000001)] */
	uint8_t key[256];
};

struct bkrp_empty {
	char _empty_;
};

struct bkrp_client_side_wrapped {
	uint32_t version;
	uint32_t encrypted_secret_len;
	uint32_t access_check_len;
	struct GUID guid;
	uint8_t *encrypted_secret;
	uint8_t *access_check;
};

struct bkrp_client_side_unwrapped {
	uint32_t magic;/* [value(0x00000000)] */
	DATA_BLOB secret;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0)] */
};

struct bkrp_encrypted_secret_v2 {
	uint32_t secret_len;
	uint32_t magic;/* [value(0x00000020)] */
	uint8_t *secret;
	uint8_t payload_key[32];
};

struct bkrp_encrypted_secret_v3 {
	uint32_t secret_len;
	uint32_t magic1;/* [value(0x00000030)] */
	uint32_t magic2;/* [value(0x00006610)] */
	uint32_t magic3;/* [value(0x0000800e)] */
	uint8_t *secret;
	uint8_t payload_key[48];
};

struct bkrp_access_check_v2 {
	uint32_t magic;/* [value(0x00000001)] */
	uint32_t nonce_len;
	uint8_t *nonce;
	struct dom_sid sid;
	uint8_t hash[20];
};

struct bkrp_access_check_v3 {
	uint32_t magic;/* [value(0x00000001)] */
	uint32_t nonce_len;
	uint8_t *nonce;
	struct dom_sid sid;
	uint8_t hash[64];
};

struct bkrp_rc4encryptedpayload {
	uint8_t r3[32];
	uint8_t mac[20];
	struct dom_sid sid;
	DATA_BLOB secret_data;/* [flag(LIBNDR_FLAG_REMAINING),subcontext(0)] */
};

struct bkrp_server_side_wrapped {
	uint32_t magic;/* [value(0x00000001)] */
	uint32_t payload_length;
	uint32_t ciphertext_length;
	struct GUID guid;
	uint8_t r2[68];
	uint8_t *rc4encryptedpayload;
};

struct bkrp_opaque_blob {
	DATA_BLOB opaque;/* [flag(LIBNDR_FLAG_REMAINING)] */
};

enum bkrp_versions
#ifndef USE_UINT_ENUMS
 {
	BACKUPKEY_SERVER_WRAP_VERSION=(int)(1),
	BACKUPKEY_CLIENT_WRAP_VERSION2=(int)(2),
	BACKUPKEY_CLIENT_WRAP_VERSION3=(int)(3)
}
#else
 { __do_not_use_enum_bkrp_versions=INT_MAX}
#define BACKUPKEY_SERVER_WRAP_VERSION ( 1 )
#define BACKUPKEY_CLIENT_WRAP_VERSION2 ( 2 )
#define BACKUPKEY_CLIENT_WRAP_VERSION3 ( 3 )
#endif
;

enum bkrp_guid_to_integer
#ifndef USE_UINT_ENUMS
 {
	BACKUPKEY_INVALID_GUID_INTEGER=(int)(0xFFFF),
	BACKUPKEY_RESTORE_GUID_INTEGER=(int)(0x0000),
	BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER=(int)(0x0001),
	BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER=(int)(0x0002),
	BACKUPKEY_BACKUP_GUID_INTEGER=(int)(0x0003)
}
#else
 { __do_not_use_enum_bkrp_guid_to_integer=INT_MAX}
#define BACKUPKEY_INVALID_GUID_INTEGER ( 0xFFFF )
#define BACKUPKEY_RESTORE_GUID_INTEGER ( 0x0000 )
#define BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER ( 0x0001 )
#define BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER ( 0x0002 )
#define BACKUPKEY_BACKUP_GUID_INTEGER ( 0x0003 )
#endif
;

union bkrp_data_in_blob {
	struct bkrp_client_side_wrapped restore_req;/* [case(BACKUPKEY_RESTORE_GUID_INTEGER)] */
	struct bkrp_empty empty;/* [case(BACKUPKEY_RETRIEVE_BACKUP_KEY_GUID_INTEGER)] */
	struct bkrp_server_side_wrapped unsign_req;/* [case(BACKUPKEY_RESTORE_GUID_WIN2K_INTEGER)] */
	struct bkrp_opaque_blob sign_req;/* [case(BACKUPKEY_BACKUP_GUID_INTEGER)] */
}/* [nodiscriminant] */;


struct bkrp_BackupKey {
	struct {
		struct GUID *guidActionAgent;/* [ref] */
		uint8_t *data_in;/* [ref,size_is(data_in_len)] */
		uint32_t data_in_len;
		uint32_t param;
	} in;

	struct {
		uint8_t **data_out;/* [ref,size_is(,*data_out_len)] */
		uint32_t *data_out_len;/* [ref] */
		WERROR result;
	} out;

};

#endif /* _HEADER_backupkey */
#endif /* _PIDL_HEADER_backupkey */
