#ifndef __AUTH_GENSEC_GENSEC_TOPLEVEL_PROTO_H__
#define __AUTH_GENSEC_GENSEC_TOPLEVEL_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../auth/gensec/gensec.c  */

const char *gensec_final_auth_type(struct gensec_security *gensec_security);

/* The following definitions come from ../../auth/gensec/gensec_start.c  */

bool gensec_security_ops_enabled(const struct gensec_security_ops *ops, struct gensec_security *security);
const struct gensec_security_ops *gensec_security_by_name(struct gensec_security *gensec_security,
							  const char *name);

/**
 * @brief Get the sasl names from the gensec security context.
 *
 * @param[in]  gensec_security The gensec security context.
 *
 * @param[in]  mem_ctx The memory context to allocate memory on.
 *
 * @return An allocated array with sasl names, NULL on error.
 */
const char **gensec_security_sasl_names(struct gensec_security *gensec_security,
					TALLOC_CTX *mem_ctx);

/**
 * Start a GENSEC sub-mechanism with a specified mechanism structure, used in SPNEGO
 *
 */
NTSTATUS gensec_start_mech_by_ops(struct gensec_security *gensec_security,
				  const struct gensec_security_ops *ops);
int gensec_setting_int(struct gensec_settings *settings, const char *mechanism, const char *name, int default_value);
bool gensec_setting_bool(struct gensec_settings *settings, const char *mechanism, const char *name, bool default_value);

/* The following definitions come from ../../auth/gensec/gensec_util.c  */

NTSTATUS gensec_generate_session_info_pac(TALLOC_CTX *mem_ctx,
					  struct gensec_security *gensec_security,
					  struct smb_krb5_context *smb_krb5_context,
					  DATA_BLOB *pac_blob,
					  const char *principal_string,
					  const struct tsocket_address *remote_address,
					  struct auth_session_info **session_info);

/**
 * Check if the packet is one for the KRB5 mechanism
 *
 * NOTE: This is a helper that can be employed by multiple mechanisms, do
 * not make assumptions about the private_data
 *
 * @param gensec_security GENSEC state, unused
 * @param in The request, as a DATA_BLOB
 * @return Error, INVALID_PARAMETER if it's not a packet for us
 *                or NT_STATUS_OK if the packet is ok.
 */
NTSTATUS gensec_magic_check_krb5_oid(struct gensec_security *unused,
					const DATA_BLOB *blob);
void gensec_child_want_feature(struct gensec_security *gensec_security,
			       uint32_t feature);
bool gensec_child_have_feature(struct gensec_security *gensec_security,
			       uint32_t feature);
NTSTATUS gensec_child_unseal_packet(struct gensec_security *gensec_security,
				    uint8_t *data, size_t length,
				    const uint8_t *whole_pdu, size_t pdu_length,
				    const DATA_BLOB *sig);
NTSTATUS gensec_child_check_packet(struct gensec_security *gensec_security,
				   const uint8_t *data, size_t length,
				   const uint8_t *whole_pdu, size_t pdu_length,
				   const DATA_BLOB *sig);
NTSTATUS gensec_child_seal_packet(struct gensec_security *gensec_security,
				  TALLOC_CTX *mem_ctx,
				  uint8_t *data, size_t length,
				  const uint8_t *whole_pdu, size_t pdu_length,
				  DATA_BLOB *sig);
NTSTATUS gensec_child_sign_packet(struct gensec_security *gensec_security,
				  TALLOC_CTX *mem_ctx,
				  const uint8_t *data, size_t length,
				  const uint8_t *whole_pdu, size_t pdu_length,
				  DATA_BLOB *sig);
NTSTATUS gensec_child_wrap(struct gensec_security *gensec_security,
			   TALLOC_CTX *mem_ctx,
			   const DATA_BLOB *in,
			   DATA_BLOB *out);
NTSTATUS gensec_child_unwrap(struct gensec_security *gensec_security,
			     TALLOC_CTX *mem_ctx,
			     const DATA_BLOB *in,
			     DATA_BLOB *out);
size_t gensec_child_sig_size(struct gensec_security *gensec_security,
			     size_t data_size);
size_t gensec_child_max_input_size(struct gensec_security *gensec_security);
size_t gensec_child_max_wrapped_size(struct gensec_security *gensec_security);
NTSTATUS gensec_child_session_key(struct gensec_security *gensec_security,
				  TALLOC_CTX *mem_ctx,
				  DATA_BLOB *session_key);
NTSTATUS gensec_child_session_info(struct gensec_security *gensec_security,
				   TALLOC_CTX *mem_ctx,
				   struct auth_session_info **session_info);
NTTIME gensec_child_expire_time(struct gensec_security *gensec_security);
const char *gensec_child_final_auth_type(struct gensec_security *gensec_security);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __AUTH_GENSEC_GENSEC_TOPLEVEL_PROTO_H__ */

