/* Generated by hsaap.py */
/* Copyright (c) 2018-2022 Advanced Micro Devices, Inc.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE. */


#include <hsa/hsa_api_trace.h>
#include <atomic>
namespace roctracer::hsa_support::detail {
static CoreApiTable CoreApi_saved_before_cb;
static AmdExtTable AmdExt_saved_before_cb;
static ImageExtTable ImageExt_saved_before_cb;


/* section: API callback functions */

/* section: Static declarations */

/* block: CoreApi API */
static hsa_status_t hsa_init_callback() {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_init, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.phase_enter(HSA_API_ID_hsa_init, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_init_fn();

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_init, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_shut_down_callback() {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_shut_down, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.phase_enter(HSA_API_ID_hsa_shut_down, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_shut_down_fn();

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_shut_down, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_system_get_info_callback(hsa_system_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_system_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_system_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_system_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_system_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_system_get_info_fn(attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_system_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_system_extension_supported_callback(uint16_t extension, uint16_t version_major, uint16_t version_minor, bool* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_system_extension_supported, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_system_extension_supported.extension = extension;
      trace_data.api_data.args.hsa_system_extension_supported.version_major = version_major;
      trace_data.api_data.args.hsa_system_extension_supported.version_minor = version_minor;
      trace_data.api_data.args.hsa_system_extension_supported.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_system_extension_supported, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_system_extension_supported_fn(extension, version_major, version_minor, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_system_extension_supported, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_system_get_extension_table_callback(uint16_t extension, uint16_t version_major, uint16_t version_minor, void* table) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_system_get_extension_table, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_system_get_extension_table.extension = extension;
      trace_data.api_data.args.hsa_system_get_extension_table.version_major = version_major;
      trace_data.api_data.args.hsa_system_get_extension_table.version_minor = version_minor;
      trace_data.api_data.args.hsa_system_get_extension_table.table = table;
      trace_data.phase_enter(HSA_API_ID_hsa_system_get_extension_table, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_system_get_extension_table_fn(extension, version_major, version_minor, table);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_system_get_extension_table, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_iterate_agents_callback(hsa_status_t (* callback)(hsa_agent_t agent, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_iterate_agents, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_iterate_agents.callback = callback;
      trace_data.api_data.args.hsa_iterate_agents.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_iterate_agents, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_iterate_agents_fn(callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_iterate_agents, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_agent_get_info_callback(hsa_agent_t agent, hsa_agent_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_get_info.agent = agent;
      trace_data.api_data.args.hsa_agent_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_agent_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_get_info_fn(agent, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_queue_create_callback(hsa_agent_t agent, uint32_t size, hsa_queue_type32_t type, void (* callback)(hsa_status_t status, hsa_queue_t* source, void* data), void* data, uint32_t private_segment_size, uint32_t group_segment_size, hsa_queue_t** queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_create.agent = agent;
      trace_data.api_data.args.hsa_queue_create.size = size;
      trace_data.api_data.args.hsa_queue_create.type = type;
      trace_data.api_data.args.hsa_queue_create.callback = callback;
      trace_data.api_data.args.hsa_queue_create.data = data;
      trace_data.api_data.args.hsa_queue_create.private_segment_size = private_segment_size;
      trace_data.api_data.args.hsa_queue_create.group_segment_size = group_segment_size;
      trace_data.api_data.args.hsa_queue_create.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_queue_create_fn(agent, size, type, callback, data, private_segment_size, group_segment_size, queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_soft_queue_create_callback(hsa_region_t region, uint32_t size, hsa_queue_type32_t type, uint32_t features, hsa_signal_t doorbell_signal, hsa_queue_t** queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_soft_queue_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_soft_queue_create.region = region;
      trace_data.api_data.args.hsa_soft_queue_create.size = size;
      trace_data.api_data.args.hsa_soft_queue_create.type = type;
      trace_data.api_data.args.hsa_soft_queue_create.features = features;
      trace_data.api_data.args.hsa_soft_queue_create.doorbell_signal = doorbell_signal;
      trace_data.api_data.args.hsa_soft_queue_create.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_soft_queue_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_soft_queue_create_fn(region, size, type, features, doorbell_signal, queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_soft_queue_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_queue_destroy_callback(hsa_queue_t* queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_destroy.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_queue_destroy_fn(queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_queue_inactivate_callback(hsa_queue_t* queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_inactivate, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_inactivate.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_inactivate, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_queue_inactivate_fn(queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_inactivate, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static uint64_t hsa_queue_load_read_index_scacquire_callback(const hsa_queue_t* queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_load_read_index_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_load_read_index_scacquire.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_load_read_index_scacquire, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_load_read_index_scacquire_fn(queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_load_read_index_scacquire, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_load_read_index_relaxed_callback(const hsa_queue_t* queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_load_read_index_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_load_read_index_relaxed.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_load_read_index_relaxed, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_load_read_index_relaxed_fn(queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_load_read_index_relaxed, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_load_write_index_scacquire_callback(const hsa_queue_t* queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_load_write_index_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_load_write_index_scacquire.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_load_write_index_scacquire, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_load_write_index_scacquire_fn(queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_load_write_index_scacquire, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_load_write_index_relaxed_callback(const hsa_queue_t* queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_load_write_index_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_load_write_index_relaxed.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_load_write_index_relaxed, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_load_write_index_relaxed_fn(queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_load_write_index_relaxed, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static void hsa_queue_store_write_index_relaxed_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_store_write_index_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_store_write_index_relaxed.queue = queue;
      trace_data.api_data.args.hsa_queue_store_write_index_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_store_write_index_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_queue_store_write_index_relaxed_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_store_write_index_relaxed, &trace_data);
}
static void hsa_queue_store_write_index_screlease_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_store_write_index_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_store_write_index_screlease.queue = queue;
      trace_data.api_data.args.hsa_queue_store_write_index_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_store_write_index_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_queue_store_write_index_screlease_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_store_write_index_screlease, &trace_data);
}
static uint64_t hsa_queue_cas_write_index_scacq_screl_callback(const hsa_queue_t* queue, uint64_t expected, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_cas_write_index_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_cas_write_index_scacq_screl.queue = queue;
      trace_data.api_data.args.hsa_queue_cas_write_index_scacq_screl.expected = expected;
      trace_data.api_data.args.hsa_queue_cas_write_index_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_cas_write_index_scacq_screl, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_cas_write_index_scacq_screl_fn(queue, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_cas_write_index_scacq_screl, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_cas_write_index_scacquire_callback(const hsa_queue_t* queue, uint64_t expected, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_cas_write_index_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_cas_write_index_scacquire.queue = queue;
      trace_data.api_data.args.hsa_queue_cas_write_index_scacquire.expected = expected;
      trace_data.api_data.args.hsa_queue_cas_write_index_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_cas_write_index_scacquire, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_cas_write_index_scacquire_fn(queue, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_cas_write_index_scacquire, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_cas_write_index_relaxed_callback(const hsa_queue_t* queue, uint64_t expected, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_cas_write_index_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_cas_write_index_relaxed.queue = queue;
      trace_data.api_data.args.hsa_queue_cas_write_index_relaxed.expected = expected;
      trace_data.api_data.args.hsa_queue_cas_write_index_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_cas_write_index_relaxed, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_cas_write_index_relaxed_fn(queue, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_cas_write_index_relaxed, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_cas_write_index_screlease_callback(const hsa_queue_t* queue, uint64_t expected, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_cas_write_index_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_cas_write_index_screlease.queue = queue;
      trace_data.api_data.args.hsa_queue_cas_write_index_screlease.expected = expected;
      trace_data.api_data.args.hsa_queue_cas_write_index_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_cas_write_index_screlease, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_cas_write_index_screlease_fn(queue, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_cas_write_index_screlease, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_add_write_index_scacq_screl_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_add_write_index_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_add_write_index_scacq_screl.queue = queue;
      trace_data.api_data.args.hsa_queue_add_write_index_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_add_write_index_scacq_screl, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_add_write_index_scacq_screl_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_add_write_index_scacq_screl, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_add_write_index_scacquire_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_add_write_index_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_add_write_index_scacquire.queue = queue;
      trace_data.api_data.args.hsa_queue_add_write_index_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_add_write_index_scacquire, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_add_write_index_scacquire_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_add_write_index_scacquire, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_add_write_index_relaxed_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_add_write_index_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_add_write_index_relaxed.queue = queue;
      trace_data.api_data.args.hsa_queue_add_write_index_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_add_write_index_relaxed, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_add_write_index_relaxed_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_add_write_index_relaxed, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static uint64_t hsa_queue_add_write_index_screlease_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_add_write_index_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_add_write_index_screlease.queue = queue;
      trace_data.api_data.args.hsa_queue_add_write_index_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_add_write_index_screlease, &trace_data);
    }
  }

  trace_data.api_data.uint64_t_retval =   CoreApi_saved_before_cb.hsa_queue_add_write_index_screlease_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_add_write_index_screlease, &trace_data);
  return trace_data.api_data.uint64_t_retval;
}
static void hsa_queue_store_read_index_relaxed_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_store_read_index_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_store_read_index_relaxed.queue = queue;
      trace_data.api_data.args.hsa_queue_store_read_index_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_store_read_index_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_queue_store_read_index_relaxed_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_store_read_index_relaxed, &trace_data);
}
static void hsa_queue_store_read_index_screlease_callback(const hsa_queue_t* queue, uint64_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_queue_store_read_index_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_queue_store_read_index_screlease.queue = queue;
      trace_data.api_data.args.hsa_queue_store_read_index_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_queue_store_read_index_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_queue_store_read_index_screlease_fn(queue, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_queue_store_read_index_screlease, &trace_data);
}
static hsa_status_t hsa_agent_iterate_regions_callback(hsa_agent_t agent, hsa_status_t (* callback)(hsa_region_t region, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_iterate_regions, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_iterate_regions.agent = agent;
      trace_data.api_data.args.hsa_agent_iterate_regions.callback = callback;
      trace_data.api_data.args.hsa_agent_iterate_regions.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_iterate_regions, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_iterate_regions_fn(agent, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_iterate_regions, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_region_get_info_callback(hsa_region_t region, hsa_region_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_region_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_region_get_info.region = region;
      trace_data.api_data.args.hsa_region_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_region_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_region_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_region_get_info_fn(region, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_region_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_agent_get_exception_policies_callback(hsa_agent_t agent, hsa_profile_t profile, uint16_t* mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_get_exception_policies, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_get_exception_policies.agent = agent;
      trace_data.api_data.args.hsa_agent_get_exception_policies.profile = profile;
      trace_data.api_data.args.hsa_agent_get_exception_policies.mask = mask;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_get_exception_policies, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_get_exception_policies_fn(agent, profile, mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_get_exception_policies, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_agent_extension_supported_callback(uint16_t extension, hsa_agent_t agent, uint16_t version_major, uint16_t version_minor, bool* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_extension_supported, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_extension_supported.extension = extension;
      trace_data.api_data.args.hsa_agent_extension_supported.agent = agent;
      trace_data.api_data.args.hsa_agent_extension_supported.version_major = version_major;
      trace_data.api_data.args.hsa_agent_extension_supported.version_minor = version_minor;
      trace_data.api_data.args.hsa_agent_extension_supported.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_extension_supported, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_extension_supported_fn(extension, agent, version_major, version_minor, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_extension_supported, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_memory_register_callback(void* ptr, size_t size) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_memory_register, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_memory_register.ptr = ptr;
      trace_data.api_data.args.hsa_memory_register.size = size;
      trace_data.phase_enter(HSA_API_ID_hsa_memory_register, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_memory_register_fn(ptr, size);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_memory_register, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_memory_deregister_callback(void* ptr, size_t size) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_memory_deregister, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_memory_deregister.ptr = ptr;
      trace_data.api_data.args.hsa_memory_deregister.size = size;
      trace_data.phase_enter(HSA_API_ID_hsa_memory_deregister, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_memory_deregister_fn(ptr, size);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_memory_deregister, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_memory_allocate_callback(hsa_region_t region, size_t size, void** ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_memory_allocate, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_memory_allocate.region = region;
      trace_data.api_data.args.hsa_memory_allocate.size = size;
      trace_data.api_data.args.hsa_memory_allocate.ptr = ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_memory_allocate, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_memory_allocate_fn(region, size, ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_memory_allocate, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_memory_free_callback(void* ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_memory_free, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_memory_free.ptr = ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_memory_free, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_memory_free_fn(ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_memory_free, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_memory_copy_callback(void* dst, const void* src, size_t size) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_memory_copy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_memory_copy.dst = dst;
      trace_data.api_data.args.hsa_memory_copy.src = src;
      trace_data.api_data.args.hsa_memory_copy.size = size;
      trace_data.phase_enter(HSA_API_ID_hsa_memory_copy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_memory_copy_fn(dst, src, size);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_memory_copy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_memory_assign_agent_callback(void* ptr, hsa_agent_t agent, hsa_access_permission_t access) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_memory_assign_agent, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_memory_assign_agent.ptr = ptr;
      trace_data.api_data.args.hsa_memory_assign_agent.agent = agent;
      trace_data.api_data.args.hsa_memory_assign_agent.access = access;
      trace_data.phase_enter(HSA_API_ID_hsa_memory_assign_agent, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_memory_assign_agent_fn(ptr, agent, access);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_memory_assign_agent, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_signal_create_callback(hsa_signal_value_t initial_value, uint32_t num_consumers, const hsa_agent_t* consumers, hsa_signal_t* signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_create.initial_value = initial_value;
      trace_data.api_data.args.hsa_signal_create.num_consumers = num_consumers;
      trace_data.api_data.args.hsa_signal_create.consumers = consumers;
      trace_data.api_data.args.hsa_signal_create.signal = signal;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_signal_create_fn(initial_value, num_consumers, consumers, signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_signal_destroy_callback(hsa_signal_t signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_destroy.signal = signal;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_signal_destroy_fn(signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_signal_value_t hsa_signal_load_relaxed_callback(hsa_signal_t signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_load_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_load_relaxed.signal = signal;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_load_relaxed, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_load_relaxed_fn(signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_load_relaxed, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_load_scacquire_callback(hsa_signal_t signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_load_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_load_scacquire.signal = signal;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_load_scacquire, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_load_scacquire_fn(signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_load_scacquire, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static void hsa_signal_store_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_store_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_store_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_store_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_store_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_store_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_store_relaxed, &trace_data);
}
static void hsa_signal_store_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_store_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_store_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_store_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_store_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_store_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_store_screlease, &trace_data);
}
static hsa_signal_value_t hsa_signal_wait_relaxed_callback(hsa_signal_t signal, hsa_signal_condition_t condition, hsa_signal_value_t compare_value, uint64_t timeout_hint, hsa_wait_state_t wait_state_hint) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_wait_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_wait_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_wait_relaxed.condition = condition;
      trace_data.api_data.args.hsa_signal_wait_relaxed.compare_value = compare_value;
      trace_data.api_data.args.hsa_signal_wait_relaxed.timeout_hint = timeout_hint;
      trace_data.api_data.args.hsa_signal_wait_relaxed.wait_state_hint = wait_state_hint;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_wait_relaxed, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_wait_relaxed_fn(signal, condition, compare_value, timeout_hint, wait_state_hint);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_wait_relaxed, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_wait_scacquire_callback(hsa_signal_t signal, hsa_signal_condition_t condition, hsa_signal_value_t compare_value, uint64_t timeout_hint, hsa_wait_state_t wait_state_hint) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_wait_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_wait_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_wait_scacquire.condition = condition;
      trace_data.api_data.args.hsa_signal_wait_scacquire.compare_value = compare_value;
      trace_data.api_data.args.hsa_signal_wait_scacquire.timeout_hint = timeout_hint;
      trace_data.api_data.args.hsa_signal_wait_scacquire.wait_state_hint = wait_state_hint;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_wait_scacquire, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_wait_scacquire_fn(signal, condition, compare_value, timeout_hint, wait_state_hint);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_wait_scacquire, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static void hsa_signal_and_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_and_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_and_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_and_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_and_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_and_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_and_relaxed, &trace_data);
}
static void hsa_signal_and_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_and_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_and_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_and_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_and_scacquire, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_and_scacquire_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_and_scacquire, &trace_data);
}
static void hsa_signal_and_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_and_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_and_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_and_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_and_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_and_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_and_screlease, &trace_data);
}
static void hsa_signal_and_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_and_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_and_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_and_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_and_scacq_screl, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_and_scacq_screl_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_and_scacq_screl, &trace_data);
}
static void hsa_signal_or_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_or_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_or_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_or_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_or_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_or_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_or_relaxed, &trace_data);
}
static void hsa_signal_or_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_or_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_or_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_or_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_or_scacquire, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_or_scacquire_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_or_scacquire, &trace_data);
}
static void hsa_signal_or_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_or_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_or_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_or_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_or_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_or_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_or_screlease, &trace_data);
}
static void hsa_signal_or_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_or_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_or_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_or_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_or_scacq_screl, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_or_scacq_screl_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_or_scacq_screl, &trace_data);
}
static void hsa_signal_xor_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_xor_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_xor_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_xor_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_xor_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_xor_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_xor_relaxed, &trace_data);
}
static void hsa_signal_xor_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_xor_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_xor_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_xor_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_xor_scacquire, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_xor_scacquire_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_xor_scacquire, &trace_data);
}
static void hsa_signal_xor_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_xor_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_xor_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_xor_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_xor_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_xor_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_xor_screlease, &trace_data);
}
static void hsa_signal_xor_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_xor_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_xor_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_xor_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_xor_scacq_screl, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_xor_scacq_screl_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_xor_scacq_screl, &trace_data);
}
static hsa_signal_value_t hsa_signal_exchange_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_exchange_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_exchange_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_exchange_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_exchange_relaxed, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_exchange_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_exchange_relaxed, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_exchange_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_exchange_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_exchange_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_exchange_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_exchange_scacquire, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_exchange_scacquire_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_exchange_scacquire, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_exchange_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_exchange_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_exchange_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_exchange_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_exchange_screlease, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_exchange_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_exchange_screlease, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_exchange_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_exchange_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_exchange_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_exchange_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_exchange_scacq_screl, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_exchange_scacq_screl_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_exchange_scacq_screl, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static void hsa_signal_add_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_add_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_add_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_add_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_add_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_add_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_add_relaxed, &trace_data);
}
static void hsa_signal_add_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_add_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_add_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_add_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_add_scacquire, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_add_scacquire_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_add_scacquire, &trace_data);
}
static void hsa_signal_add_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_add_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_add_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_add_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_add_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_add_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_add_screlease, &trace_data);
}
static void hsa_signal_add_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_add_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_add_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_add_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_add_scacq_screl, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_add_scacq_screl_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_add_scacq_screl, &trace_data);
}
static void hsa_signal_subtract_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_subtract_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_subtract_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_subtract_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_subtract_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_subtract_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_subtract_relaxed, &trace_data);
}
static void hsa_signal_subtract_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_subtract_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_subtract_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_subtract_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_subtract_scacquire, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_subtract_scacquire_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_subtract_scacquire, &trace_data);
}
static void hsa_signal_subtract_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_subtract_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_subtract_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_subtract_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_subtract_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_subtract_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_subtract_screlease, &trace_data);
}
static void hsa_signal_subtract_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_subtract_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_subtract_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_subtract_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_subtract_scacq_screl, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_subtract_scacq_screl_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_subtract_scacq_screl, &trace_data);
}
static hsa_signal_value_t hsa_signal_cas_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_cas_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_cas_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_cas_relaxed.expected = expected;
      trace_data.api_data.args.hsa_signal_cas_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_cas_relaxed, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_cas_relaxed_fn(signal, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_cas_relaxed, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_cas_scacquire_callback(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_cas_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_cas_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_cas_scacquire.expected = expected;
      trace_data.api_data.args.hsa_signal_cas_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_cas_scacquire, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_cas_scacquire_fn(signal, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_cas_scacquire, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_cas_screlease_callback(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_cas_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_cas_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_cas_screlease.expected = expected;
      trace_data.api_data.args.hsa_signal_cas_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_cas_screlease, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_cas_screlease_fn(signal, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_cas_screlease, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_signal_value_t hsa_signal_cas_scacq_screl_callback(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_cas_scacq_screl, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_cas_scacq_screl.signal = signal;
      trace_data.api_data.args.hsa_signal_cas_scacq_screl.expected = expected;
      trace_data.api_data.args.hsa_signal_cas_scacq_screl.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_cas_scacq_screl, &trace_data);
    }
  }

  trace_data.api_data.hsa_signal_value_t_retval =   CoreApi_saved_before_cb.hsa_signal_cas_scacq_screl_fn(signal, expected, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_cas_scacq_screl, &trace_data);
  return trace_data.api_data.hsa_signal_value_t_retval;
}
static hsa_status_t hsa_isa_from_name_callback(const char* name, hsa_isa_t* isa) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_from_name, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_from_name.name = (name != NULL) ? strdup(name) : NULL;
      trace_data.api_data.args.hsa_isa_from_name.isa = isa;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_from_name, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_from_name_fn(name, isa);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_from_name, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_isa_get_info_callback(hsa_isa_t isa, hsa_isa_info_t attribute, uint32_t index, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_get_info.isa = isa;
      trace_data.api_data.args.hsa_isa_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_isa_get_info.index = index;
      trace_data.api_data.args.hsa_isa_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_get_info_fn(isa, attribute, index, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_isa_compatible_callback(hsa_isa_t code_object_isa, hsa_isa_t agent_isa, bool* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_compatible, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_compatible.code_object_isa = code_object_isa;
      trace_data.api_data.args.hsa_isa_compatible.agent_isa = agent_isa;
      trace_data.api_data.args.hsa_isa_compatible.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_compatible, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_compatible_fn(code_object_isa, agent_isa, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_compatible, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_serialize_callback(hsa_code_object_t code_object, hsa_status_t (* alloc_callback)(size_t size, hsa_callback_data_t data, void** address), hsa_callback_data_t callback_data, const char* options, void** serialized_code_object, size_t* serialized_code_object_size) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_serialize, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_serialize.code_object = code_object;
      trace_data.api_data.args.hsa_code_object_serialize.alloc_callback = alloc_callback;
      trace_data.api_data.args.hsa_code_object_serialize.callback_data = callback_data;
      trace_data.api_data.args.hsa_code_object_serialize.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_code_object_serialize.serialized_code_object = serialized_code_object;
      trace_data.api_data.args.hsa_code_object_serialize.serialized_code_object_size = serialized_code_object_size;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_serialize, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_serialize_fn(code_object, alloc_callback, callback_data, options, serialized_code_object, serialized_code_object_size);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_serialize, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_deserialize_callback(void* serialized_code_object, size_t serialized_code_object_size, const char* options, hsa_code_object_t* code_object) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_deserialize, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_deserialize.serialized_code_object = serialized_code_object;
      trace_data.api_data.args.hsa_code_object_deserialize.serialized_code_object_size = serialized_code_object_size;
      trace_data.api_data.args.hsa_code_object_deserialize.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_code_object_deserialize.code_object = code_object;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_deserialize, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_deserialize_fn(serialized_code_object, serialized_code_object_size, options, code_object);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_deserialize, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_destroy_callback(hsa_code_object_t code_object) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_destroy.code_object = code_object;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_destroy_fn(code_object);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_get_info_callback(hsa_code_object_t code_object, hsa_code_object_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_get_info.code_object = code_object;
      trace_data.api_data.args.hsa_code_object_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_code_object_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_get_info_fn(code_object, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_get_symbol_callback(hsa_code_object_t code_object, const char* symbol_name, hsa_code_symbol_t* symbol) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_get_symbol, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_get_symbol.code_object = code_object;
      trace_data.api_data.args.hsa_code_object_get_symbol.symbol_name = (symbol_name != NULL) ? strdup(symbol_name) : NULL;
      trace_data.api_data.args.hsa_code_object_get_symbol.symbol = symbol;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_get_symbol, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_get_symbol_fn(code_object, symbol_name, symbol);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_get_symbol, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_symbol_get_info_callback(hsa_code_symbol_t code_symbol, hsa_code_symbol_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_symbol_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_symbol_get_info.code_symbol = code_symbol;
      trace_data.api_data.args.hsa_code_symbol_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_code_symbol_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_code_symbol_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_symbol_get_info_fn(code_symbol, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_symbol_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_iterate_symbols_callback(hsa_code_object_t code_object, hsa_status_t (* callback)(hsa_code_object_t code_object, hsa_code_symbol_t symbol, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_iterate_symbols, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_iterate_symbols.code_object = code_object;
      trace_data.api_data.args.hsa_code_object_iterate_symbols.callback = callback;
      trace_data.api_data.args.hsa_code_object_iterate_symbols.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_iterate_symbols, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_iterate_symbols_fn(code_object, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_iterate_symbols, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_create_callback(hsa_profile_t profile, hsa_executable_state_t executable_state, const char* options, hsa_executable_t* executable) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_create.profile = profile;
      trace_data.api_data.args.hsa_executable_create.executable_state = executable_state;
      trace_data.api_data.args.hsa_executable_create.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_executable_create.executable = executable;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_create_fn(profile, executable_state, options, executable);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_destroy_callback(hsa_executable_t executable) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_destroy.executable = executable;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_destroy_fn(executable);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_load_code_object_callback(hsa_executable_t executable, hsa_agent_t agent, hsa_code_object_t code_object, const char* options) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_load_code_object, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_load_code_object.executable = executable;
      trace_data.api_data.args.hsa_executable_load_code_object.agent = agent;
      trace_data.api_data.args.hsa_executable_load_code_object.code_object = code_object;
      trace_data.api_data.args.hsa_executable_load_code_object.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_load_code_object, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_load_code_object_fn(executable, agent, code_object, options);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_load_code_object, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_freeze_callback(hsa_executable_t executable, const char* options) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_freeze, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_freeze.executable = executable;
      trace_data.api_data.args.hsa_executable_freeze.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_freeze, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_freeze_fn(executable, options);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_freeze, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_get_info_callback(hsa_executable_t executable, hsa_executable_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_get_info.executable = executable;
      trace_data.api_data.args.hsa_executable_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_executable_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_get_info_fn(executable, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_global_variable_define_callback(hsa_executable_t executable, const char* variable_name, void* address) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_global_variable_define, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_global_variable_define.executable = executable;
      trace_data.api_data.args.hsa_executable_global_variable_define.variable_name = (variable_name != NULL) ? strdup(variable_name) : NULL;
      trace_data.api_data.args.hsa_executable_global_variable_define.address = address;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_global_variable_define, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_global_variable_define_fn(executable, variable_name, address);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_global_variable_define, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_agent_global_variable_define_callback(hsa_executable_t executable, hsa_agent_t agent, const char* variable_name, void* address) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_agent_global_variable_define, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_agent_global_variable_define.executable = executable;
      trace_data.api_data.args.hsa_executable_agent_global_variable_define.agent = agent;
      trace_data.api_data.args.hsa_executable_agent_global_variable_define.variable_name = (variable_name != NULL) ? strdup(variable_name) : NULL;
      trace_data.api_data.args.hsa_executable_agent_global_variable_define.address = address;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_agent_global_variable_define, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_agent_global_variable_define_fn(executable, agent, variable_name, address);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_agent_global_variable_define, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_readonly_variable_define_callback(hsa_executable_t executable, hsa_agent_t agent, const char* variable_name, void* address) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_readonly_variable_define, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_readonly_variable_define.executable = executable;
      trace_data.api_data.args.hsa_executable_readonly_variable_define.agent = agent;
      trace_data.api_data.args.hsa_executable_readonly_variable_define.variable_name = (variable_name != NULL) ? strdup(variable_name) : NULL;
      trace_data.api_data.args.hsa_executable_readonly_variable_define.address = address;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_readonly_variable_define, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_readonly_variable_define_fn(executable, agent, variable_name, address);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_readonly_variable_define, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_validate_callback(hsa_executable_t executable, uint32_t* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_validate, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_validate.executable = executable;
      trace_data.api_data.args.hsa_executable_validate.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_validate, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_validate_fn(executable, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_validate, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_get_symbol_callback(hsa_executable_t executable, const char* module_name, const char* symbol_name, hsa_agent_t agent, int32_t call_convention, hsa_executable_symbol_t* symbol) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_get_symbol, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_get_symbol.executable = executable;
      trace_data.api_data.args.hsa_executable_get_symbol.module_name = (module_name != NULL) ? strdup(module_name) : NULL;
      trace_data.api_data.args.hsa_executable_get_symbol.symbol_name = (symbol_name != NULL) ? strdup(symbol_name) : NULL;
      trace_data.api_data.args.hsa_executable_get_symbol.agent = agent;
      trace_data.api_data.args.hsa_executable_get_symbol.call_convention = call_convention;
      trace_data.api_data.args.hsa_executable_get_symbol.symbol = symbol;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_get_symbol, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_get_symbol_fn(executable, module_name, symbol_name, agent, call_convention, symbol);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_get_symbol, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_symbol_get_info_callback(hsa_executable_symbol_t executable_symbol, hsa_executable_symbol_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_symbol_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_symbol_get_info.executable_symbol = executable_symbol;
      trace_data.api_data.args.hsa_executable_symbol_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_executable_symbol_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_symbol_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_symbol_get_info_fn(executable_symbol, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_symbol_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_iterate_symbols_callback(hsa_executable_t executable, hsa_status_t (* callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_iterate_symbols, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_iterate_symbols.executable = executable;
      trace_data.api_data.args.hsa_executable_iterate_symbols.callback = callback;
      trace_data.api_data.args.hsa_executable_iterate_symbols.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_iterate_symbols, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_iterate_symbols_fn(executable, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_iterate_symbols, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_status_string_callback(hsa_status_t status, const char** status_string) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_status_string, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_status_string.status = status;
      trace_data.api_data.args.hsa_status_string.status_string = status_string;
      trace_data.phase_enter(HSA_API_ID_hsa_status_string, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_status_string_fn(status, status_string);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_status_string, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_extension_get_name_callback(uint16_t extension, const char** name) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_extension_get_name, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_extension_get_name.extension = extension;
      trace_data.api_data.args.hsa_extension_get_name.name = name;
      trace_data.phase_enter(HSA_API_ID_hsa_extension_get_name, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_extension_get_name_fn(extension, name);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_extension_get_name, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_system_major_extension_supported_callback(uint16_t extension, uint16_t version_major, uint16_t* version_minor, bool* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_system_major_extension_supported, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_system_major_extension_supported.extension = extension;
      trace_data.api_data.args.hsa_system_major_extension_supported.version_major = version_major;
      trace_data.api_data.args.hsa_system_major_extension_supported.version_minor = version_minor;
      trace_data.api_data.args.hsa_system_major_extension_supported.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_system_major_extension_supported, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_system_major_extension_supported_fn(extension, version_major, version_minor, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_system_major_extension_supported, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_system_get_major_extension_table_callback(uint16_t extension, uint16_t version_major, size_t table_length, void* table) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_system_get_major_extension_table, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_system_get_major_extension_table.extension = extension;
      trace_data.api_data.args.hsa_system_get_major_extension_table.version_major = version_major;
      trace_data.api_data.args.hsa_system_get_major_extension_table.table_length = table_length;
      trace_data.api_data.args.hsa_system_get_major_extension_table.table = table;
      trace_data.phase_enter(HSA_API_ID_hsa_system_get_major_extension_table, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_system_get_major_extension_table_fn(extension, version_major, table_length, table);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_system_get_major_extension_table, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_agent_major_extension_supported_callback(uint16_t extension, hsa_agent_t agent, uint16_t version_major, uint16_t* version_minor, bool* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_major_extension_supported, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_major_extension_supported.extension = extension;
      trace_data.api_data.args.hsa_agent_major_extension_supported.agent = agent;
      trace_data.api_data.args.hsa_agent_major_extension_supported.version_major = version_major;
      trace_data.api_data.args.hsa_agent_major_extension_supported.version_minor = version_minor;
      trace_data.api_data.args.hsa_agent_major_extension_supported.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_major_extension_supported, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_major_extension_supported_fn(extension, agent, version_major, version_minor, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_major_extension_supported, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_cache_get_info_callback(hsa_cache_t cache, hsa_cache_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_cache_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_cache_get_info.cache = cache;
      trace_data.api_data.args.hsa_cache_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_cache_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_cache_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_cache_get_info_fn(cache, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_cache_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_agent_iterate_caches_callback(hsa_agent_t agent, hsa_status_t (* callback)(hsa_cache_t cache, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_iterate_caches, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_iterate_caches.agent = agent;
      trace_data.api_data.args.hsa_agent_iterate_caches.callback = callback;
      trace_data.api_data.args.hsa_agent_iterate_caches.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_iterate_caches, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_iterate_caches_fn(agent, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_iterate_caches, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static void hsa_signal_silent_store_relaxed_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_silent_store_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_silent_store_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_silent_store_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_silent_store_relaxed, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_silent_store_relaxed_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_silent_store_relaxed, &trace_data);
}
static void hsa_signal_silent_store_screlease_callback(hsa_signal_t signal, hsa_signal_value_t value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_silent_store_screlease, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_silent_store_screlease.signal = signal;
      trace_data.api_data.args.hsa_signal_silent_store_screlease.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_silent_store_screlease, &trace_data);
    }
  }

  CoreApi_saved_before_cb.hsa_signal_silent_store_screlease_fn(signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_silent_store_screlease, &trace_data);
}
static hsa_status_t hsa_signal_group_create_callback(uint32_t num_signals, const hsa_signal_t* signals, uint32_t num_consumers, const hsa_agent_t* consumers, hsa_signal_group_t* signal_group) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_group_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_group_create.num_signals = num_signals;
      trace_data.api_data.args.hsa_signal_group_create.signals = signals;
      trace_data.api_data.args.hsa_signal_group_create.num_consumers = num_consumers;
      trace_data.api_data.args.hsa_signal_group_create.consumers = consumers;
      trace_data.api_data.args.hsa_signal_group_create.signal_group = signal_group;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_group_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_signal_group_create_fn(num_signals, signals, num_consumers, consumers, signal_group);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_group_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_signal_group_destroy_callback(hsa_signal_group_t signal_group) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_group_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_group_destroy.signal_group = signal_group;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_group_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_signal_group_destroy_fn(signal_group);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_group_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_signal_group_wait_any_scacquire_callback(hsa_signal_group_t signal_group, const hsa_signal_condition_t* conditions, const hsa_signal_value_t* compare_values, hsa_wait_state_t wait_state_hint, hsa_signal_t* signal, hsa_signal_value_t* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_group_wait_any_scacquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_group_wait_any_scacquire.signal_group = signal_group;
      trace_data.api_data.args.hsa_signal_group_wait_any_scacquire.conditions = conditions;
      trace_data.api_data.args.hsa_signal_group_wait_any_scacquire.compare_values = compare_values;
      trace_data.api_data.args.hsa_signal_group_wait_any_scacquire.wait_state_hint = wait_state_hint;
      trace_data.api_data.args.hsa_signal_group_wait_any_scacquire.signal = signal;
      trace_data.api_data.args.hsa_signal_group_wait_any_scacquire.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_group_wait_any_scacquire, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_signal_group_wait_any_scacquire_fn(signal_group, conditions, compare_values, wait_state_hint, signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_group_wait_any_scacquire, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_signal_group_wait_any_relaxed_callback(hsa_signal_group_t signal_group, const hsa_signal_condition_t* conditions, const hsa_signal_value_t* compare_values, hsa_wait_state_t wait_state_hint, hsa_signal_t* signal, hsa_signal_value_t* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_signal_group_wait_any_relaxed, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_signal_group_wait_any_relaxed.signal_group = signal_group;
      trace_data.api_data.args.hsa_signal_group_wait_any_relaxed.conditions = conditions;
      trace_data.api_data.args.hsa_signal_group_wait_any_relaxed.compare_values = compare_values;
      trace_data.api_data.args.hsa_signal_group_wait_any_relaxed.wait_state_hint = wait_state_hint;
      trace_data.api_data.args.hsa_signal_group_wait_any_relaxed.signal = signal;
      trace_data.api_data.args.hsa_signal_group_wait_any_relaxed.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_signal_group_wait_any_relaxed, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_signal_group_wait_any_relaxed_fn(signal_group, conditions, compare_values, wait_state_hint, signal, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_signal_group_wait_any_relaxed, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_agent_iterate_isas_callback(hsa_agent_t agent, hsa_status_t (* callback)(hsa_isa_t isa, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_agent_iterate_isas, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_agent_iterate_isas.agent = agent;
      trace_data.api_data.args.hsa_agent_iterate_isas.callback = callback;
      trace_data.api_data.args.hsa_agent_iterate_isas.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_agent_iterate_isas, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_agent_iterate_isas_fn(agent, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_agent_iterate_isas, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_isa_get_info_alt_callback(hsa_isa_t isa, hsa_isa_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_get_info_alt, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_get_info_alt.isa = isa;
      trace_data.api_data.args.hsa_isa_get_info_alt.attribute = attribute;
      trace_data.api_data.args.hsa_isa_get_info_alt.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_get_info_alt, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_get_info_alt_fn(isa, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_get_info_alt, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_isa_get_exception_policies_callback(hsa_isa_t isa, hsa_profile_t profile, uint16_t* mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_get_exception_policies, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_get_exception_policies.isa = isa;
      trace_data.api_data.args.hsa_isa_get_exception_policies.profile = profile;
      trace_data.api_data.args.hsa_isa_get_exception_policies.mask = mask;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_get_exception_policies, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_get_exception_policies_fn(isa, profile, mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_get_exception_policies, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_isa_get_round_method_callback(hsa_isa_t isa, hsa_fp_type_t fp_type, hsa_flush_mode_t flush_mode, hsa_round_method_t* round_method) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_get_round_method, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_get_round_method.isa = isa;
      trace_data.api_data.args.hsa_isa_get_round_method.fp_type = fp_type;
      trace_data.api_data.args.hsa_isa_get_round_method.flush_mode = flush_mode;
      trace_data.api_data.args.hsa_isa_get_round_method.round_method = round_method;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_get_round_method, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_get_round_method_fn(isa, fp_type, flush_mode, round_method);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_get_round_method, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_wavefront_get_info_callback(hsa_wavefront_t wavefront, hsa_wavefront_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_wavefront_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_wavefront_get_info.wavefront = wavefront;
      trace_data.api_data.args.hsa_wavefront_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_wavefront_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_wavefront_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_wavefront_get_info_fn(wavefront, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_wavefront_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_isa_iterate_wavefronts_callback(hsa_isa_t isa, hsa_status_t (* callback)(hsa_wavefront_t wavefront, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_isa_iterate_wavefronts, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_isa_iterate_wavefronts.isa = isa;
      trace_data.api_data.args.hsa_isa_iterate_wavefronts.callback = callback;
      trace_data.api_data.args.hsa_isa_iterate_wavefronts.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_isa_iterate_wavefronts, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_isa_iterate_wavefronts_fn(isa, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_isa_iterate_wavefronts, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_get_symbol_from_name_callback(hsa_code_object_t code_object, const char* module_name, const char* symbol_name, hsa_code_symbol_t* symbol) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_get_symbol_from_name, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_get_symbol_from_name.code_object = code_object;
      trace_data.api_data.args.hsa_code_object_get_symbol_from_name.module_name = (module_name != NULL) ? strdup(module_name) : NULL;
      trace_data.api_data.args.hsa_code_object_get_symbol_from_name.symbol_name = (symbol_name != NULL) ? strdup(symbol_name) : NULL;
      trace_data.api_data.args.hsa_code_object_get_symbol_from_name.symbol = symbol;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_get_symbol_from_name, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_get_symbol_from_name_fn(code_object, module_name, symbol_name, symbol);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_get_symbol_from_name, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_reader_create_from_file_callback(hsa_file_t file, hsa_code_object_reader_t* code_object_reader) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_reader_create_from_file, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_reader_create_from_file.file = file;
      trace_data.api_data.args.hsa_code_object_reader_create_from_file.code_object_reader = code_object_reader;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_reader_create_from_file, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_reader_create_from_file_fn(file, code_object_reader);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_reader_create_from_file, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_reader_create_from_memory_callback(const void* code_object, size_t size, hsa_code_object_reader_t* code_object_reader) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_reader_create_from_memory, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_reader_create_from_memory.code_object = code_object;
      trace_data.api_data.args.hsa_code_object_reader_create_from_memory.size = size;
      trace_data.api_data.args.hsa_code_object_reader_create_from_memory.code_object_reader = code_object_reader;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_reader_create_from_memory, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_reader_create_from_memory_fn(code_object, size, code_object_reader);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_reader_create_from_memory, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_code_object_reader_destroy_callback(hsa_code_object_reader_t code_object_reader) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_code_object_reader_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_code_object_reader_destroy.code_object_reader = code_object_reader;
      trace_data.phase_enter(HSA_API_ID_hsa_code_object_reader_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_code_object_reader_destroy_fn(code_object_reader);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_code_object_reader_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_create_alt_callback(hsa_profile_t profile, hsa_default_float_rounding_mode_t default_float_rounding_mode, const char* options, hsa_executable_t* executable) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_create_alt, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_create_alt.profile = profile;
      trace_data.api_data.args.hsa_executable_create_alt.default_float_rounding_mode = default_float_rounding_mode;
      trace_data.api_data.args.hsa_executable_create_alt.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_executable_create_alt.executable = executable;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_create_alt, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_create_alt_fn(profile, default_float_rounding_mode, options, executable);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_create_alt, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_load_program_code_object_callback(hsa_executable_t executable, hsa_code_object_reader_t code_object_reader, const char* options, hsa_loaded_code_object_t* loaded_code_object) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_load_program_code_object, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_load_program_code_object.executable = executable;
      trace_data.api_data.args.hsa_executable_load_program_code_object.code_object_reader = code_object_reader;
      trace_data.api_data.args.hsa_executable_load_program_code_object.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_executable_load_program_code_object.loaded_code_object = loaded_code_object;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_load_program_code_object, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_load_program_code_object_fn(executable, code_object_reader, options, loaded_code_object);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_load_program_code_object, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_load_agent_code_object_callback(hsa_executable_t executable, hsa_agent_t agent, hsa_code_object_reader_t code_object_reader, const char* options, hsa_loaded_code_object_t* loaded_code_object) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_load_agent_code_object, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_load_agent_code_object.executable = executable;
      trace_data.api_data.args.hsa_executable_load_agent_code_object.agent = agent;
      trace_data.api_data.args.hsa_executable_load_agent_code_object.code_object_reader = code_object_reader;
      trace_data.api_data.args.hsa_executable_load_agent_code_object.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_executable_load_agent_code_object.loaded_code_object = loaded_code_object;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_load_agent_code_object, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_load_agent_code_object_fn(executable, agent, code_object_reader, options, loaded_code_object);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_load_agent_code_object, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_validate_alt_callback(hsa_executable_t executable, const char* options, uint32_t* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_validate_alt, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_validate_alt.executable = executable;
      trace_data.api_data.args.hsa_executable_validate_alt.options = (options != NULL) ? strdup(options) : NULL;
      trace_data.api_data.args.hsa_executable_validate_alt.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_validate_alt, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_validate_alt_fn(executable, options, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_validate_alt, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_get_symbol_by_name_callback(hsa_executable_t executable, const char* symbol_name, const hsa_agent_t* agent, hsa_executable_symbol_t* symbol) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_get_symbol_by_name, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_get_symbol_by_name.executable = executable;
      trace_data.api_data.args.hsa_executable_get_symbol_by_name.symbol_name = (symbol_name != NULL) ? strdup(symbol_name) : NULL;
      trace_data.api_data.args.hsa_executable_get_symbol_by_name.agent = agent;
      trace_data.api_data.args.hsa_executable_get_symbol_by_name.symbol = symbol;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_get_symbol_by_name, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_get_symbol_by_name_fn(executable, symbol_name, agent, symbol);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_get_symbol_by_name, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_iterate_agent_symbols_callback(hsa_executable_t executable, hsa_agent_t agent, hsa_status_t (* callback)(hsa_executable_t exec, hsa_agent_t agent, hsa_executable_symbol_t symbol, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_iterate_agent_symbols, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_iterate_agent_symbols.executable = executable;
      trace_data.api_data.args.hsa_executable_iterate_agent_symbols.agent = agent;
      trace_data.api_data.args.hsa_executable_iterate_agent_symbols.callback = callback;
      trace_data.api_data.args.hsa_executable_iterate_agent_symbols.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_iterate_agent_symbols, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_iterate_agent_symbols_fn(executable, agent, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_iterate_agent_symbols, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_executable_iterate_program_symbols_callback(hsa_executable_t executable, hsa_status_t (* callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_executable_iterate_program_symbols, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_executable_iterate_program_symbols.executable = executable;
      trace_data.api_data.args.hsa_executable_iterate_program_symbols.callback = callback;
      trace_data.api_data.args.hsa_executable_iterate_program_symbols.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_executable_iterate_program_symbols, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   CoreApi_saved_before_cb.hsa_executable_iterate_program_symbols_fn(executable, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_executable_iterate_program_symbols, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}

/* block: AmdExt API */
static hsa_status_t hsa_amd_coherency_get_type_callback(hsa_agent_t agent, hsa_amd_coherency_type_t* type) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_coherency_get_type, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_coherency_get_type.agent = agent;
      trace_data.api_data.args.hsa_amd_coherency_get_type.type = type;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_coherency_get_type, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_coherency_get_type_fn(agent, type);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_coherency_get_type, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_coherency_set_type_callback(hsa_agent_t agent, hsa_amd_coherency_type_t type) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_coherency_set_type, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_coherency_set_type.agent = agent;
      trace_data.api_data.args.hsa_amd_coherency_set_type.type = type;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_coherency_set_type, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_coherency_set_type_fn(agent, type);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_coherency_set_type, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_profiling_set_profiler_enabled_callback(hsa_queue_t* queue, int enable) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_profiling_set_profiler_enabled, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_profiling_set_profiler_enabled.queue = queue;
      trace_data.api_data.args.hsa_amd_profiling_set_profiler_enabled.enable = enable;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_profiling_set_profiler_enabled, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_profiling_set_profiler_enabled_fn(queue, enable);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_profiling_set_profiler_enabled, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_profiling_async_copy_enable_callback(bool enable) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_profiling_async_copy_enable, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_profiling_async_copy_enable.enable = enable;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_profiling_async_copy_enable, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_profiling_async_copy_enable_fn(enable);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_profiling_async_copy_enable, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_profiling_get_dispatch_time_callback(hsa_agent_t agent, hsa_signal_t signal, hsa_amd_profiling_dispatch_time_t* time) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_profiling_get_dispatch_time, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_profiling_get_dispatch_time.agent = agent;
      trace_data.api_data.args.hsa_amd_profiling_get_dispatch_time.signal = signal;
      trace_data.api_data.args.hsa_amd_profiling_get_dispatch_time.time = time;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_profiling_get_dispatch_time, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_profiling_get_dispatch_time_fn(agent, signal, time);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_profiling_get_dispatch_time, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_profiling_get_async_copy_time_callback(hsa_signal_t signal, hsa_amd_profiling_async_copy_time_t* time) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_profiling_get_async_copy_time, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_profiling_get_async_copy_time.signal = signal;
      trace_data.api_data.args.hsa_amd_profiling_get_async_copy_time.time = time;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_profiling_get_async_copy_time, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_profiling_get_async_copy_time_fn(signal, time);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_profiling_get_async_copy_time, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_profiling_convert_tick_to_system_domain_callback(hsa_agent_t agent, uint64_t agent_tick, uint64_t* system_tick) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_profiling_convert_tick_to_system_domain.agent = agent;
      trace_data.api_data.args.hsa_amd_profiling_convert_tick_to_system_domain.agent_tick = agent_tick;
      trace_data.api_data.args.hsa_amd_profiling_convert_tick_to_system_domain.system_tick = system_tick;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_profiling_convert_tick_to_system_domain_fn(agent, agent_tick, system_tick);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_signal_async_handler_callback(hsa_signal_t signal, hsa_signal_condition_t cond, hsa_signal_value_t value, hsa_amd_signal_handler handler, void* arg) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_signal_async_handler, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_signal_async_handler.signal = signal;
      trace_data.api_data.args.hsa_amd_signal_async_handler.cond = cond;
      trace_data.api_data.args.hsa_amd_signal_async_handler.value = value;
      trace_data.api_data.args.hsa_amd_signal_async_handler.handler = handler;
      trace_data.api_data.args.hsa_amd_signal_async_handler.arg = arg;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_signal_async_handler, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_signal_async_handler_fn(signal, cond, value, handler, arg);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_signal_async_handler, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_async_function_callback(void (* callback)(void* arg), void* arg) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_async_function, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_async_function.callback = callback;
      trace_data.api_data.args.hsa_amd_async_function.arg = arg;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_async_function, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_async_function_fn(callback, arg);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_async_function, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static uint32_t hsa_amd_signal_wait_any_callback(uint32_t signal_count, hsa_signal_t* signals, hsa_signal_condition_t* conds, hsa_signal_value_t* values, uint64_t timeout_hint, hsa_wait_state_t wait_hint, hsa_signal_value_t* satisfying_value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_signal_wait_any, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_signal_wait_any.signal_count = signal_count;
      trace_data.api_data.args.hsa_amd_signal_wait_any.signals = signals;
      trace_data.api_data.args.hsa_amd_signal_wait_any.conds = conds;
      trace_data.api_data.args.hsa_amd_signal_wait_any.values = values;
      trace_data.api_data.args.hsa_amd_signal_wait_any.timeout_hint = timeout_hint;
      trace_data.api_data.args.hsa_amd_signal_wait_any.wait_hint = wait_hint;
      trace_data.api_data.args.hsa_amd_signal_wait_any.satisfying_value = satisfying_value;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_signal_wait_any, &trace_data);
    }
  }

  trace_data.api_data.uint32_t_retval =   AmdExt_saved_before_cb.hsa_amd_signal_wait_any_fn(signal_count, signals, conds, values, timeout_hint, wait_hint, satisfying_value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_signal_wait_any, &trace_data);
  return trace_data.api_data.uint32_t_retval;
}
static hsa_status_t hsa_amd_queue_cu_set_mask_callback(const hsa_queue_t* queue, uint32_t num_cu_mask_count, const uint32_t* cu_mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_queue_cu_set_mask, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_queue_cu_set_mask.queue = queue;
      trace_data.api_data.args.hsa_amd_queue_cu_set_mask.num_cu_mask_count = num_cu_mask_count;
      trace_data.api_data.args.hsa_amd_queue_cu_set_mask.cu_mask = cu_mask;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_queue_cu_set_mask, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_queue_cu_set_mask_fn(queue, num_cu_mask_count, cu_mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_queue_cu_set_mask, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_pool_get_info_callback(hsa_amd_memory_pool_t memory_pool, hsa_amd_memory_pool_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_pool_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_pool_get_info.memory_pool = memory_pool;
      trace_data.api_data.args.hsa_amd_memory_pool_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_amd_memory_pool_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_pool_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_pool_get_info_fn(memory_pool, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_pool_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_agent_iterate_memory_pools_callback(hsa_agent_t agent, hsa_status_t (* callback)(hsa_amd_memory_pool_t memory_pool, void* data), void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_agent_iterate_memory_pools, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_agent_iterate_memory_pools.agent = agent;
      trace_data.api_data.args.hsa_amd_agent_iterate_memory_pools.callback = callback;
      trace_data.api_data.args.hsa_amd_agent_iterate_memory_pools.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_agent_iterate_memory_pools, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_agent_iterate_memory_pools_fn(agent, callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_agent_iterate_memory_pools, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_pool_allocate_callback(hsa_amd_memory_pool_t memory_pool, size_t size, uint32_t flags, void** ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_pool_allocate, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_pool_allocate.memory_pool = memory_pool;
      trace_data.api_data.args.hsa_amd_memory_pool_allocate.size = size;
      trace_data.api_data.args.hsa_amd_memory_pool_allocate.flags = flags;
      trace_data.api_data.args.hsa_amd_memory_pool_allocate.ptr = ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_pool_allocate, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_pool_allocate_fn(memory_pool, size, flags, ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_pool_allocate, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_pool_free_callback(void* ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_pool_free, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_pool_free.ptr = ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_pool_free, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_pool_free_fn(ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_pool_free, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_async_copy_callback(void* dst, hsa_agent_t dst_agent, const void* src, hsa_agent_t src_agent, size_t size, uint32_t num_dep_signals, const hsa_signal_t* dep_signals, hsa_signal_t completion_signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_async_copy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_async_copy.dst = dst;
      trace_data.api_data.args.hsa_amd_memory_async_copy.dst_agent = dst_agent;
      trace_data.api_data.args.hsa_amd_memory_async_copy.src = src;
      trace_data.api_data.args.hsa_amd_memory_async_copy.src_agent = src_agent;
      trace_data.api_data.args.hsa_amd_memory_async_copy.size = size;
      trace_data.api_data.args.hsa_amd_memory_async_copy.num_dep_signals = num_dep_signals;
      trace_data.api_data.args.hsa_amd_memory_async_copy.dep_signals = dep_signals;
      trace_data.api_data.args.hsa_amd_memory_async_copy.completion_signal = completion_signal;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_async_copy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_async_copy_fn(dst, dst_agent, src, src_agent, size, num_dep_signals, dep_signals, completion_signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_async_copy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_async_copy_on_engine_callback(void* dst, hsa_agent_t dst_agent, const void* src, hsa_agent_t src_agent, size_t size, uint32_t num_dep_signals, const hsa_signal_t* dep_signals, hsa_signal_t completion_signal, hsa_amd_sdma_engine_id_t engine_id, bool force_copy_on_sdma) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_async_copy_on_engine, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.dst = dst;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.dst_agent = dst_agent;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.src = src;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.src_agent = src_agent;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.size = size;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.num_dep_signals = num_dep_signals;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.dep_signals = dep_signals;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.completion_signal = completion_signal;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.engine_id = engine_id;
      trace_data.api_data.args.hsa_amd_memory_async_copy_on_engine.force_copy_on_sdma = force_copy_on_sdma;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_async_copy_on_engine, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_async_copy_on_engine_fn(dst, dst_agent, src, src_agent, size, num_dep_signals, dep_signals, completion_signal, engine_id, force_copy_on_sdma);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_async_copy_on_engine, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_copy_engine_status_callback(hsa_agent_t dst_agent, hsa_agent_t src_agent, uint32_t* engine_ids_mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_copy_engine_status, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_copy_engine_status.dst_agent = dst_agent;
      trace_data.api_data.args.hsa_amd_memory_copy_engine_status.src_agent = src_agent;
      trace_data.api_data.args.hsa_amd_memory_copy_engine_status.engine_ids_mask = engine_ids_mask;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_copy_engine_status, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_copy_engine_status_fn(dst_agent, src_agent, engine_ids_mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_copy_engine_status, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_agent_memory_pool_get_info_callback(hsa_agent_t agent, hsa_amd_memory_pool_t memory_pool, hsa_amd_agent_memory_pool_info_t attribute, void* value) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_agent_memory_pool_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_agent_memory_pool_get_info.agent = agent;
      trace_data.api_data.args.hsa_amd_agent_memory_pool_get_info.memory_pool = memory_pool;
      trace_data.api_data.args.hsa_amd_agent_memory_pool_get_info.attribute = attribute;
      trace_data.api_data.args.hsa_amd_agent_memory_pool_get_info.value = value;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_agent_memory_pool_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_agent_memory_pool_get_info_fn(agent, memory_pool, attribute, value);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_agent_memory_pool_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_agents_allow_access_callback(uint32_t num_agents, const hsa_agent_t* agents, const uint32_t* flags, const void* ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_agents_allow_access, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_agents_allow_access.num_agents = num_agents;
      trace_data.api_data.args.hsa_amd_agents_allow_access.agents = agents;
      trace_data.api_data.args.hsa_amd_agents_allow_access.flags = flags;
      trace_data.api_data.args.hsa_amd_agents_allow_access.ptr = ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_agents_allow_access, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_agents_allow_access_fn(num_agents, agents, flags, ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_agents_allow_access, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_pool_can_migrate_callback(hsa_amd_memory_pool_t src_memory_pool, hsa_amd_memory_pool_t dst_memory_pool, bool* result) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_pool_can_migrate, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_pool_can_migrate.src_memory_pool = src_memory_pool;
      trace_data.api_data.args.hsa_amd_memory_pool_can_migrate.dst_memory_pool = dst_memory_pool;
      trace_data.api_data.args.hsa_amd_memory_pool_can_migrate.result = result;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_pool_can_migrate, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_pool_can_migrate_fn(src_memory_pool, dst_memory_pool, result);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_pool_can_migrate, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_migrate_callback(const void* ptr, hsa_amd_memory_pool_t memory_pool, uint32_t flags) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_migrate, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_migrate.ptr = ptr;
      trace_data.api_data.args.hsa_amd_memory_migrate.memory_pool = memory_pool;
      trace_data.api_data.args.hsa_amd_memory_migrate.flags = flags;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_migrate, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_migrate_fn(ptr, memory_pool, flags);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_migrate, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_lock_callback(void* host_ptr, size_t size, hsa_agent_t* agents, int num_agent, void** agent_ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_lock, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_lock.host_ptr = host_ptr;
      trace_data.api_data.args.hsa_amd_memory_lock.size = size;
      trace_data.api_data.args.hsa_amd_memory_lock.agents = agents;
      trace_data.api_data.args.hsa_amd_memory_lock.num_agent = num_agent;
      trace_data.api_data.args.hsa_amd_memory_lock.agent_ptr = agent_ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_lock, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_lock_fn(host_ptr, size, agents, num_agent, agent_ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_lock, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_unlock_callback(void* host_ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_unlock, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_unlock.host_ptr = host_ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_unlock, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_unlock_fn(host_ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_unlock, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_fill_callback(void* ptr, uint32_t value, size_t count) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_fill, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_fill.ptr = ptr;
      trace_data.api_data.args.hsa_amd_memory_fill.value = value;
      trace_data.api_data.args.hsa_amd_memory_fill.count = count;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_fill, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_fill_fn(ptr, value, count);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_fill, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_interop_map_buffer_callback(uint32_t num_agents, hsa_agent_t* agents, int interop_handle, uint32_t flags, size_t* size, void** ptr, size_t* metadata_size, const void** metadata) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_interop_map_buffer, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_interop_map_buffer.num_agents = num_agents;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.agents = agents;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.interop_handle = interop_handle;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.flags = flags;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.size = size;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.ptr = ptr;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.metadata_size = metadata_size;
      trace_data.api_data.args.hsa_amd_interop_map_buffer.metadata = metadata;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_interop_map_buffer, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_interop_map_buffer_fn(num_agents, agents, interop_handle, flags, size, ptr, metadata_size, metadata);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_interop_map_buffer, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_interop_unmap_buffer_callback(void* ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_interop_unmap_buffer, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_interop_unmap_buffer.ptr = ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_interop_unmap_buffer, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_interop_unmap_buffer_fn(ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_interop_unmap_buffer, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_image_create_callback(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, const hsa_amd_image_descriptor_t* image_layout, const void* image_data, hsa_access_permission_t access_permission, hsa_ext_image_t* image) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_image_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_image_create.agent = agent;
      trace_data.api_data.args.hsa_amd_image_create.image_descriptor = image_descriptor;
      trace_data.api_data.args.hsa_amd_image_create.image_layout = image_layout;
      trace_data.api_data.args.hsa_amd_image_create.image_data = image_data;
      trace_data.api_data.args.hsa_amd_image_create.access_permission = access_permission;
      trace_data.api_data.args.hsa_amd_image_create.image = image;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_image_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_image_create_fn(agent, image_descriptor, image_layout, image_data, access_permission, image);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_image_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_pointer_info_callback(const void* ptr, hsa_amd_pointer_info_t* info, void* (* alloc)(size_t), uint32_t* num_agents_accessible, hsa_agent_t** accessible) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_pointer_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_pointer_info.ptr = ptr;
      trace_data.api_data.args.hsa_amd_pointer_info.info = info;
      trace_data.api_data.args.hsa_amd_pointer_info.alloc = alloc;
      trace_data.api_data.args.hsa_amd_pointer_info.num_agents_accessible = num_agents_accessible;
      trace_data.api_data.args.hsa_amd_pointer_info.accessible = accessible;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_pointer_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_pointer_info_fn(ptr, info, alloc, num_agents_accessible, accessible);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_pointer_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_pointer_info_set_userdata_callback(const void* ptr, void* userdata) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_pointer_info_set_userdata, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_pointer_info_set_userdata.ptr = ptr;
      trace_data.api_data.args.hsa_amd_pointer_info_set_userdata.userdata = userdata;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_pointer_info_set_userdata, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_pointer_info_set_userdata_fn(ptr, userdata);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_pointer_info_set_userdata, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_ipc_memory_create_callback(void* ptr, size_t len, hsa_amd_ipc_memory_t* handle) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_ipc_memory_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_ipc_memory_create.ptr = ptr;
      trace_data.api_data.args.hsa_amd_ipc_memory_create.len = len;
      trace_data.api_data.args.hsa_amd_ipc_memory_create.handle = handle;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_ipc_memory_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_ipc_memory_create_fn(ptr, len, handle);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_ipc_memory_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_ipc_memory_attach_callback(const hsa_amd_ipc_memory_t* handle, size_t len, uint32_t num_agents, const hsa_agent_t* mapping_agents, void** mapped_ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_ipc_memory_attach, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_ipc_memory_attach.handle = handle;
      trace_data.api_data.args.hsa_amd_ipc_memory_attach.len = len;
      trace_data.api_data.args.hsa_amd_ipc_memory_attach.num_agents = num_agents;
      trace_data.api_data.args.hsa_amd_ipc_memory_attach.mapping_agents = mapping_agents;
      trace_data.api_data.args.hsa_amd_ipc_memory_attach.mapped_ptr = mapped_ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_ipc_memory_attach, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_ipc_memory_attach_fn(handle, len, num_agents, mapping_agents, mapped_ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_ipc_memory_attach, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_ipc_memory_detach_callback(void* mapped_ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_ipc_memory_detach, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_ipc_memory_detach.mapped_ptr = mapped_ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_ipc_memory_detach, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_ipc_memory_detach_fn(mapped_ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_ipc_memory_detach, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_signal_create_callback(hsa_signal_value_t initial_value, uint32_t num_consumers, const hsa_agent_t* consumers, uint64_t attributes, hsa_signal_t* signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_signal_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_signal_create.initial_value = initial_value;
      trace_data.api_data.args.hsa_amd_signal_create.num_consumers = num_consumers;
      trace_data.api_data.args.hsa_amd_signal_create.consumers = consumers;
      trace_data.api_data.args.hsa_amd_signal_create.attributes = attributes;
      trace_data.api_data.args.hsa_amd_signal_create.signal = signal;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_signal_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_signal_create_fn(initial_value, num_consumers, consumers, attributes, signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_signal_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_ipc_signal_create_callback(hsa_signal_t signal, hsa_amd_ipc_signal_t* handle) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_ipc_signal_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_ipc_signal_create.signal = signal;
      trace_data.api_data.args.hsa_amd_ipc_signal_create.handle = handle;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_ipc_signal_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_ipc_signal_create_fn(signal, handle);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_ipc_signal_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_ipc_signal_attach_callback(const hsa_amd_ipc_signal_t* handle, hsa_signal_t* signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_ipc_signal_attach, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_ipc_signal_attach.handle = handle;
      trace_data.api_data.args.hsa_amd_ipc_signal_attach.signal = signal;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_ipc_signal_attach, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_ipc_signal_attach_fn(handle, signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_ipc_signal_attach, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_register_system_event_handler_callback(hsa_amd_system_event_callback_t callback, void* data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_register_system_event_handler, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_register_system_event_handler.callback = callback;
      trace_data.api_data.args.hsa_amd_register_system_event_handler.data = data;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_register_system_event_handler, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_register_system_event_handler_fn(callback, data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_register_system_event_handler, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_queue_intercept_create_callback(hsa_agent_t agent_handle, uint32_t size, hsa_queue_type32_t type, void (* callback)(hsa_status_t status, hsa_queue_t* source, void* data), void* data, uint32_t private_segment_size, uint32_t group_segment_size, hsa_queue_t** queue) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_queue_intercept_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_queue_intercept_create.agent_handle = agent_handle;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.size = size;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.type = type;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.callback = callback;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.data = data;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.private_segment_size = private_segment_size;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.group_segment_size = group_segment_size;
      trace_data.api_data.args.hsa_amd_queue_intercept_create.queue = queue;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_queue_intercept_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_queue_intercept_create_fn(agent_handle, size, type, callback, data, private_segment_size, group_segment_size, queue);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_queue_intercept_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_queue_intercept_register_callback(hsa_queue_t* queue, hsa_amd_queue_intercept_handler callback, void* user_data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_queue_intercept_register, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_queue_intercept_register.queue = queue;
      trace_data.api_data.args.hsa_amd_queue_intercept_register.callback = callback;
      trace_data.api_data.args.hsa_amd_queue_intercept_register.user_data = user_data;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_queue_intercept_register, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_queue_intercept_register_fn(queue, callback, user_data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_queue_intercept_register, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_queue_set_priority_callback(hsa_queue_t* queue, hsa_amd_queue_priority_t priority) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_queue_set_priority, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_queue_set_priority.queue = queue;
      trace_data.api_data.args.hsa_amd_queue_set_priority.priority = priority;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_queue_set_priority, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_queue_set_priority_fn(queue, priority);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_queue_set_priority, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_async_copy_rect_callback(const hsa_pitched_ptr_t* dst, const hsa_dim3_t* dst_offset, const hsa_pitched_ptr_t* src, const hsa_dim3_t* src_offset, const hsa_dim3_t* range, hsa_agent_t copy_agent, hsa_amd_copy_direction_t dir, uint32_t num_dep_signals, const hsa_signal_t* dep_signals, hsa_signal_t completion_signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_async_copy_rect, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.dst = dst;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.dst_offset = dst_offset;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.src = src;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.src_offset = src_offset;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.range = range;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.range__val = *(range);
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.copy_agent = copy_agent;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.dir = dir;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.num_dep_signals = num_dep_signals;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.dep_signals = dep_signals;
      trace_data.api_data.args.hsa_amd_memory_async_copy_rect.completion_signal = completion_signal;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_async_copy_rect, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_async_copy_rect_fn(dst, dst_offset, src, src_offset, range, copy_agent, dir, num_dep_signals, dep_signals, completion_signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_async_copy_rect, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_runtime_queue_create_register_callback(hsa_amd_runtime_queue_notifier callback, void* user_data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_runtime_queue_create_register, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_runtime_queue_create_register.callback = callback;
      trace_data.api_data.args.hsa_amd_runtime_queue_create_register.user_data = user_data;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_runtime_queue_create_register, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_runtime_queue_create_register_fn(callback, user_data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_runtime_queue_create_register, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_memory_lock_to_pool_callback(void* host_ptr, size_t size, hsa_agent_t* agents, int num_agent, hsa_amd_memory_pool_t pool, uint32_t flags, void** agent_ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_memory_lock_to_pool, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.host_ptr = host_ptr;
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.size = size;
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.agents = agents;
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.num_agent = num_agent;
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.pool = pool;
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.flags = flags;
      trace_data.api_data.args.hsa_amd_memory_lock_to_pool.agent_ptr = agent_ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_memory_lock_to_pool, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_memory_lock_to_pool_fn(host_ptr, size, agents, num_agent, pool, flags, agent_ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_memory_lock_to_pool, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_register_deallocation_callback_callback(void* ptr, hsa_amd_deallocation_callback_t callback, void* user_data) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_register_deallocation_callback, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_register_deallocation_callback.ptr = ptr;
      trace_data.api_data.args.hsa_amd_register_deallocation_callback.callback = callback;
      trace_data.api_data.args.hsa_amd_register_deallocation_callback.user_data = user_data;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_register_deallocation_callback, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_register_deallocation_callback_fn(ptr, callback, user_data);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_register_deallocation_callback, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_deregister_deallocation_callback_callback(void* ptr, hsa_amd_deallocation_callback_t callback) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_deregister_deallocation_callback, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_deregister_deallocation_callback.ptr = ptr;
      trace_data.api_data.args.hsa_amd_deregister_deallocation_callback.callback = callback;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_deregister_deallocation_callback, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_deregister_deallocation_callback_fn(ptr, callback);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_deregister_deallocation_callback, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_signal_value_pointer_callback(hsa_signal_t signal, volatile hsa_signal_value_t** value_ptr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_signal_value_pointer, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_signal_value_pointer.signal = signal;
      trace_data.api_data.args.hsa_amd_signal_value_pointer.value_ptr = value_ptr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_signal_value_pointer, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_signal_value_pointer_fn(signal, value_ptr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_signal_value_pointer, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_svm_attributes_set_callback(void* ptr, size_t size, hsa_amd_svm_attribute_pair_t* attribute_list, size_t attribute_count) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_svm_attributes_set, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_svm_attributes_set.ptr = ptr;
      trace_data.api_data.args.hsa_amd_svm_attributes_set.size = size;
      trace_data.api_data.args.hsa_amd_svm_attributes_set.attribute_list = attribute_list;
      trace_data.api_data.args.hsa_amd_svm_attributes_set.attribute_count = attribute_count;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_svm_attributes_set, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_svm_attributes_set_fn(ptr, size, attribute_list, attribute_count);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_svm_attributes_set, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_svm_attributes_get_callback(void* ptr, size_t size, hsa_amd_svm_attribute_pair_t* attribute_list, size_t attribute_count) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_svm_attributes_get, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_svm_attributes_get.ptr = ptr;
      trace_data.api_data.args.hsa_amd_svm_attributes_get.size = size;
      trace_data.api_data.args.hsa_amd_svm_attributes_get.attribute_list = attribute_list;
      trace_data.api_data.args.hsa_amd_svm_attributes_get.attribute_count = attribute_count;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_svm_attributes_get, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_svm_attributes_get_fn(ptr, size, attribute_list, attribute_count);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_svm_attributes_get, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_svm_prefetch_async_callback(void* ptr, size_t size, hsa_agent_t agent, uint32_t num_dep_signals, const hsa_signal_t* dep_signals, hsa_signal_t completion_signal) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_svm_prefetch_async, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_svm_prefetch_async.ptr = ptr;
      trace_data.api_data.args.hsa_amd_svm_prefetch_async.size = size;
      trace_data.api_data.args.hsa_amd_svm_prefetch_async.agent = agent;
      trace_data.api_data.args.hsa_amd_svm_prefetch_async.num_dep_signals = num_dep_signals;
      trace_data.api_data.args.hsa_amd_svm_prefetch_async.dep_signals = dep_signals;
      trace_data.api_data.args.hsa_amd_svm_prefetch_async.completion_signal = completion_signal;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_svm_prefetch_async, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_svm_prefetch_async_fn(ptr, size, agent, num_dep_signals, dep_signals, completion_signal);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_svm_prefetch_async, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_spm_acquire_callback(hsa_agent_t preferred_agent) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_spm_acquire, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_spm_acquire.preferred_agent = preferred_agent;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_spm_acquire, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_spm_acquire_fn(preferred_agent);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_spm_acquire, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_spm_release_callback(hsa_agent_t preferred_agent) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_spm_release, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_spm_release.preferred_agent = preferred_agent;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_spm_release, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_spm_release_fn(preferred_agent);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_spm_release, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_spm_set_dest_buffer_callback(hsa_agent_t preferred_agent, size_t size_in_bytes, uint32_t* timeout, uint32_t* size_copied, void* dest, bool* is_data_loss) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_spm_set_dest_buffer, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_spm_set_dest_buffer.preferred_agent = preferred_agent;
      trace_data.api_data.args.hsa_amd_spm_set_dest_buffer.size_in_bytes = size_in_bytes;
      trace_data.api_data.args.hsa_amd_spm_set_dest_buffer.timeout = timeout;
      trace_data.api_data.args.hsa_amd_spm_set_dest_buffer.size_copied = size_copied;
      trace_data.api_data.args.hsa_amd_spm_set_dest_buffer.dest = dest;
      trace_data.api_data.args.hsa_amd_spm_set_dest_buffer.is_data_loss = is_data_loss;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_spm_set_dest_buffer, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_spm_set_dest_buffer_fn(preferred_agent, size_in_bytes, timeout, size_copied, dest, is_data_loss);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_spm_set_dest_buffer, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_queue_cu_get_mask_callback(const hsa_queue_t* queue, uint32_t num_cu_mask_count, uint32_t* cu_mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_queue_cu_get_mask, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_queue_cu_get_mask.queue = queue;
      trace_data.api_data.args.hsa_amd_queue_cu_get_mask.num_cu_mask_count = num_cu_mask_count;
      trace_data.api_data.args.hsa_amd_queue_cu_get_mask.cu_mask = cu_mask;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_queue_cu_get_mask, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_queue_cu_get_mask_fn(queue, num_cu_mask_count, cu_mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_queue_cu_get_mask, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_portable_export_dmabuf_callback(const void* ptr, size_t size, int* dmabuf, uint64_t* offset) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_portable_export_dmabuf, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_portable_export_dmabuf.ptr = ptr;
      trace_data.api_data.args.hsa_amd_portable_export_dmabuf.size = size;
      trace_data.api_data.args.hsa_amd_portable_export_dmabuf.dmabuf = dmabuf;
      trace_data.api_data.args.hsa_amd_portable_export_dmabuf.offset = offset;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_portable_export_dmabuf, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_portable_export_dmabuf_fn(ptr, size, dmabuf, offset);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_portable_export_dmabuf, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_portable_close_dmabuf_callback(int dmabuf) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_portable_close_dmabuf, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_portable_close_dmabuf.dmabuf = dmabuf;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_portable_close_dmabuf, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_portable_close_dmabuf_fn(dmabuf);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_portable_close_dmabuf, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_address_reserve_callback(void** va, size_t size, uint64_t address, uint64_t flags) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_address_reserve, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_address_reserve.va = va;
      trace_data.api_data.args.hsa_amd_vmem_address_reserve.size = size;
      trace_data.api_data.args.hsa_amd_vmem_address_reserve.address = address;
      trace_data.api_data.args.hsa_amd_vmem_address_reserve.flags = flags;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_address_reserve, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_address_reserve_fn(va, size, address, flags);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_address_reserve, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_address_free_callback(void* va, size_t size) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_address_free, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_address_free.va = va;
      trace_data.api_data.args.hsa_amd_vmem_address_free.size = size;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_address_free, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_address_free_fn(va, size);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_address_free, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_handle_create_callback(hsa_amd_memory_pool_t pool, size_t size, hsa_amd_memory_type_t type, uint64_t flags, hsa_amd_vmem_alloc_handle_t* memory_handle) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_handle_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_handle_create.pool = pool;
      trace_data.api_data.args.hsa_amd_vmem_handle_create.size = size;
      trace_data.api_data.args.hsa_amd_vmem_handle_create.type = type;
      trace_data.api_data.args.hsa_amd_vmem_handle_create.flags = flags;
      trace_data.api_data.args.hsa_amd_vmem_handle_create.memory_handle = memory_handle;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_handle_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_handle_create_fn(pool, size, type, flags, memory_handle);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_handle_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_handle_release_callback(hsa_amd_vmem_alloc_handle_t memory_handle) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_handle_release, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_handle_release.memory_handle = memory_handle;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_handle_release, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_handle_release_fn(memory_handle);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_handle_release, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_map_callback(void* va, size_t size, size_t in_offset, hsa_amd_vmem_alloc_handle_t memory_handle, uint64_t flags) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_map, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_map.va = va;
      trace_data.api_data.args.hsa_amd_vmem_map.size = size;
      trace_data.api_data.args.hsa_amd_vmem_map.in_offset = in_offset;
      trace_data.api_data.args.hsa_amd_vmem_map.memory_handle = memory_handle;
      trace_data.api_data.args.hsa_amd_vmem_map.flags = flags;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_map, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_map_fn(va, size, in_offset, memory_handle, flags);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_map, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_unmap_callback(void* va, size_t size) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_unmap, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_unmap.va = va;
      trace_data.api_data.args.hsa_amd_vmem_unmap.size = size;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_unmap, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_unmap_fn(va, size);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_unmap, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_set_access_callback(void* va, size_t size, const hsa_amd_memory_access_desc_t* desc, size_t desc_cnt) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_set_access, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_set_access.va = va;
      trace_data.api_data.args.hsa_amd_vmem_set_access.size = size;
      trace_data.api_data.args.hsa_amd_vmem_set_access.desc = desc;
      trace_data.api_data.args.hsa_amd_vmem_set_access.desc_cnt = desc_cnt;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_set_access, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_set_access_fn(va, size, desc, desc_cnt);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_set_access, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_get_access_callback(void* va, hsa_access_permission_t* perms, hsa_agent_t agent_handle) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_get_access, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_get_access.va = va;
      trace_data.api_data.args.hsa_amd_vmem_get_access.perms = perms;
      trace_data.api_data.args.hsa_amd_vmem_get_access.agent_handle = agent_handle;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_get_access, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_get_access_fn(va, perms, agent_handle);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_get_access, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_export_shareable_handle_callback(int* dmabuf_fd, hsa_amd_vmem_alloc_handle_t handle, uint64_t flags) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_export_shareable_handle, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_export_shareable_handle.dmabuf_fd = dmabuf_fd;
      trace_data.api_data.args.hsa_amd_vmem_export_shareable_handle.handle = handle;
      trace_data.api_data.args.hsa_amd_vmem_export_shareable_handle.flags = flags;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_export_shareable_handle, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_export_shareable_handle_fn(dmabuf_fd, handle, flags);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_export_shareable_handle, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_import_shareable_handle_callback(int dmabuf_fd, hsa_amd_vmem_alloc_handle_t* handle) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_import_shareable_handle, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_import_shareable_handle.dmabuf_fd = dmabuf_fd;
      trace_data.api_data.args.hsa_amd_vmem_import_shareable_handle.handle = handle;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_import_shareable_handle, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_import_shareable_handle_fn(dmabuf_fd, handle);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_import_shareable_handle, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_retain_alloc_handle_callback(hsa_amd_vmem_alloc_handle_t* memory_handle, void* addr) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_retain_alloc_handle, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_retain_alloc_handle.memory_handle = memory_handle;
      trace_data.api_data.args.hsa_amd_vmem_retain_alloc_handle.addr = addr;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_retain_alloc_handle, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_retain_alloc_handle_fn(memory_handle, addr);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_retain_alloc_handle, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_amd_vmem_get_alloc_properties_from_handle_callback(hsa_amd_vmem_alloc_handle_t memory_handle, hsa_amd_memory_pool_t* pool, hsa_amd_memory_type_t* type) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_amd_vmem_get_alloc_properties_from_handle.memory_handle = memory_handle;
      trace_data.api_data.args.hsa_amd_vmem_get_alloc_properties_from_handle.pool = pool;
      trace_data.api_data.args.hsa_amd_vmem_get_alloc_properties_from_handle.type = type;
      trace_data.phase_enter(HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   AmdExt_saved_before_cb.hsa_amd_vmem_get_alloc_properties_from_handle_fn(memory_handle, pool, type);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}

/* block: ImageExt API */
static hsa_status_t hsa_ext_image_get_capability_callback(hsa_agent_t agent, hsa_ext_image_geometry_t geometry, const hsa_ext_image_format_t* image_format, uint32_t* capability_mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_get_capability, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_get_capability.agent = agent;
      trace_data.api_data.args.hsa_ext_image_get_capability.geometry = geometry;
      trace_data.api_data.args.hsa_ext_image_get_capability.image_format = image_format;
      trace_data.api_data.args.hsa_ext_image_get_capability.capability_mask = capability_mask;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_get_capability, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_get_capability_fn(agent, geometry, image_format, capability_mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_get_capability, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_data_get_info_callback(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, hsa_access_permission_t access_permission, hsa_ext_image_data_info_t* image_data_info) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_data_get_info, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_data_get_info.agent = agent;
      trace_data.api_data.args.hsa_ext_image_data_get_info.image_descriptor = image_descriptor;
      trace_data.api_data.args.hsa_ext_image_data_get_info.access_permission = access_permission;
      trace_data.api_data.args.hsa_ext_image_data_get_info.image_data_info = image_data_info;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_data_get_info, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_data_get_info_fn(agent, image_descriptor, access_permission, image_data_info);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_data_get_info, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_create_callback(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, const void* image_data, hsa_access_permission_t access_permission, hsa_ext_image_t* image) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_create.agent = agent;
      trace_data.api_data.args.hsa_ext_image_create.image_descriptor = image_descriptor;
      trace_data.api_data.args.hsa_ext_image_create.image_data = image_data;
      trace_data.api_data.args.hsa_ext_image_create.access_permission = access_permission;
      trace_data.api_data.args.hsa_ext_image_create.image = image;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_create_fn(agent, image_descriptor, image_data, access_permission, image);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_import_callback(hsa_agent_t agent, const void* src_memory, size_t src_row_pitch, size_t src_slice_pitch, hsa_ext_image_t dst_image, const hsa_ext_image_region_t* image_region) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_import, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_import.agent = agent;
      trace_data.api_data.args.hsa_ext_image_import.src_memory = src_memory;
      trace_data.api_data.args.hsa_ext_image_import.src_row_pitch = src_row_pitch;
      trace_data.api_data.args.hsa_ext_image_import.src_slice_pitch = src_slice_pitch;
      trace_data.api_data.args.hsa_ext_image_import.dst_image = dst_image;
      trace_data.api_data.args.hsa_ext_image_import.image_region = image_region;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_import, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_import_fn(agent, src_memory, src_row_pitch, src_slice_pitch, dst_image, image_region);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_import, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_export_callback(hsa_agent_t agent, hsa_ext_image_t src_image, void* dst_memory, size_t dst_row_pitch, size_t dst_slice_pitch, const hsa_ext_image_region_t* image_region) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_export, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_export.agent = agent;
      trace_data.api_data.args.hsa_ext_image_export.src_image = src_image;
      trace_data.api_data.args.hsa_ext_image_export.dst_memory = dst_memory;
      trace_data.api_data.args.hsa_ext_image_export.dst_row_pitch = dst_row_pitch;
      trace_data.api_data.args.hsa_ext_image_export.dst_slice_pitch = dst_slice_pitch;
      trace_data.api_data.args.hsa_ext_image_export.image_region = image_region;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_export, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_export_fn(agent, src_image, dst_memory, dst_row_pitch, dst_slice_pitch, image_region);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_export, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_copy_callback(hsa_agent_t agent, hsa_ext_image_t src_image, const hsa_dim3_t* src_offset, hsa_ext_image_t dst_image, const hsa_dim3_t* dst_offset, const hsa_dim3_t* range) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_copy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_copy.agent = agent;
      trace_data.api_data.args.hsa_ext_image_copy.src_image = src_image;
      trace_data.api_data.args.hsa_ext_image_copy.src_offset = src_offset;
      trace_data.api_data.args.hsa_ext_image_copy.dst_image = dst_image;
      trace_data.api_data.args.hsa_ext_image_copy.dst_offset = dst_offset;
      trace_data.api_data.args.hsa_ext_image_copy.range = range;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_copy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_copy_fn(agent, src_image, src_offset, dst_image, dst_offset, range);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_copy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_clear_callback(hsa_agent_t agent, hsa_ext_image_t image, const void* data, const hsa_ext_image_region_t* image_region) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_clear, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_clear.agent = agent;
      trace_data.api_data.args.hsa_ext_image_clear.image = image;
      trace_data.api_data.args.hsa_ext_image_clear.data = data;
      trace_data.api_data.args.hsa_ext_image_clear.image_region = image_region;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_clear, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_clear_fn(agent, image, data, image_region);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_clear, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_destroy_callback(hsa_agent_t agent, hsa_ext_image_t image) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_destroy.agent = agent;
      trace_data.api_data.args.hsa_ext_image_destroy.image = image;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_destroy_fn(agent, image);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_sampler_create_callback(hsa_agent_t agent, const hsa_ext_sampler_descriptor_t* sampler_descriptor, hsa_ext_sampler_t* sampler) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_sampler_create, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_sampler_create.agent = agent;
      trace_data.api_data.args.hsa_ext_sampler_create.sampler_descriptor = sampler_descriptor;
      trace_data.api_data.args.hsa_ext_sampler_create.sampler = sampler;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_sampler_create, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_sampler_create_fn(agent, sampler_descriptor, sampler);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_sampler_create, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_sampler_destroy_callback(hsa_agent_t agent, hsa_ext_sampler_t sampler) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_sampler_destroy, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_sampler_destroy.agent = agent;
      trace_data.api_data.args.hsa_ext_sampler_destroy.sampler = sampler;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_sampler_destroy, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_sampler_destroy_fn(agent, sampler);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_sampler_destroy, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_get_capability_with_layout_callback(hsa_agent_t agent, hsa_ext_image_geometry_t geometry, const hsa_ext_image_format_t* image_format, hsa_ext_image_data_layout_t image_data_layout, uint32_t* capability_mask) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_get_capability_with_layout, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_get_capability_with_layout.agent = agent;
      trace_data.api_data.args.hsa_ext_image_get_capability_with_layout.geometry = geometry;
      trace_data.api_data.args.hsa_ext_image_get_capability_with_layout.image_format = image_format;
      trace_data.api_data.args.hsa_ext_image_get_capability_with_layout.image_data_layout = image_data_layout;
      trace_data.api_data.args.hsa_ext_image_get_capability_with_layout.capability_mask = capability_mask;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_get_capability_with_layout, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_get_capability_with_layout_fn(agent, geometry, image_format, image_data_layout, capability_mask);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_get_capability_with_layout, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_data_get_info_with_layout_callback(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, hsa_access_permission_t access_permission, hsa_ext_image_data_layout_t image_data_layout, size_t image_data_row_pitch, size_t image_data_slice_pitch, hsa_ext_image_data_info_t* image_data_info) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_data_get_info_with_layout, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.agent = agent;
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.image_descriptor = image_descriptor;
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.access_permission = access_permission;
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.image_data_layout = image_data_layout;
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.image_data_row_pitch = image_data_row_pitch;
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.image_data_slice_pitch = image_data_slice_pitch;
      trace_data.api_data.args.hsa_ext_image_data_get_info_with_layout.image_data_info = image_data_info;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_data_get_info_with_layout, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_data_get_info_with_layout_fn(agent, image_descriptor, access_permission, image_data_layout, image_data_row_pitch, image_data_slice_pitch, image_data_info);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_data_get_info_with_layout, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}
static hsa_status_t hsa_ext_image_create_with_layout_callback(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, const void* image_data, hsa_access_permission_t access_permission, hsa_ext_image_data_layout_t image_data_layout, size_t image_data_row_pitch, size_t image_data_slice_pitch, hsa_ext_image_t* image) {
  hsa_trace_data_t trace_data;
  bool enabled{false};

  if (auto function = report_activity.load(std::memory_order_relaxed); function &&
      (enabled =
           function(ACTIVITY_DOMAIN_HSA_API, HSA_API_ID_hsa_ext_image_create_with_layout, &trace_data) == 0)) {
    if (trace_data.phase_enter != nullptr) {
      trace_data.api_data.args.hsa_ext_image_create_with_layout.agent = agent;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.image_descriptor = image_descriptor;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.image_data = image_data;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.access_permission = access_permission;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.image_data_layout = image_data_layout;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.image_data_row_pitch = image_data_row_pitch;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.image_data_slice_pitch = image_data_slice_pitch;
      trace_data.api_data.args.hsa_ext_image_create_with_layout.image = image;
      trace_data.phase_enter(HSA_API_ID_hsa_ext_image_create_with_layout, &trace_data);
    }
  }

  trace_data.api_data.hsa_status_t_retval =   ImageExt_saved_before_cb.hsa_ext_image_create_with_layout_fn(agent, image_descriptor, image_data, access_permission, image_data_layout, image_data_row_pitch, image_data_slice_pitch, image);

  if (enabled && trace_data.phase_exit != nullptr)
    trace_data.phase_exit(HSA_API_ID_hsa_ext_image_create_with_layout, &trace_data);
  return trace_data.api_data.hsa_status_t_retval;
}

/* section: API intercepting code */

/* block: CoreApi API */
static void InstallCoreApiWrappers(CoreApiTable* table) {
  CoreApi_saved_before_cb = *table;
  table->hsa_init_fn = hsa_init_callback;
  { void* p = (void*)hsa_shut_down_callback; (void)p; }
  table->hsa_system_get_info_fn = hsa_system_get_info_callback;
  table->hsa_system_extension_supported_fn = hsa_system_extension_supported_callback;
  table->hsa_system_get_extension_table_fn = hsa_system_get_extension_table_callback;
  table->hsa_iterate_agents_fn = hsa_iterate_agents_callback;
  table->hsa_agent_get_info_fn = hsa_agent_get_info_callback;
  table->hsa_queue_create_fn = hsa_queue_create_callback;
  table->hsa_soft_queue_create_fn = hsa_soft_queue_create_callback;
  table->hsa_queue_destroy_fn = hsa_queue_destroy_callback;
  table->hsa_queue_inactivate_fn = hsa_queue_inactivate_callback;
  table->hsa_queue_load_read_index_scacquire_fn = hsa_queue_load_read_index_scacquire_callback;
  table->hsa_queue_load_read_index_relaxed_fn = hsa_queue_load_read_index_relaxed_callback;
  table->hsa_queue_load_write_index_scacquire_fn = hsa_queue_load_write_index_scacquire_callback;
  table->hsa_queue_load_write_index_relaxed_fn = hsa_queue_load_write_index_relaxed_callback;
  table->hsa_queue_store_write_index_relaxed_fn = hsa_queue_store_write_index_relaxed_callback;
  table->hsa_queue_store_write_index_screlease_fn = hsa_queue_store_write_index_screlease_callback;
  table->hsa_queue_cas_write_index_scacq_screl_fn = hsa_queue_cas_write_index_scacq_screl_callback;
  table->hsa_queue_cas_write_index_scacquire_fn = hsa_queue_cas_write_index_scacquire_callback;
  table->hsa_queue_cas_write_index_relaxed_fn = hsa_queue_cas_write_index_relaxed_callback;
  table->hsa_queue_cas_write_index_screlease_fn = hsa_queue_cas_write_index_screlease_callback;
  table->hsa_queue_add_write_index_scacq_screl_fn = hsa_queue_add_write_index_scacq_screl_callback;
  table->hsa_queue_add_write_index_scacquire_fn = hsa_queue_add_write_index_scacquire_callback;
  table->hsa_queue_add_write_index_relaxed_fn = hsa_queue_add_write_index_relaxed_callback;
  table->hsa_queue_add_write_index_screlease_fn = hsa_queue_add_write_index_screlease_callback;
  table->hsa_queue_store_read_index_relaxed_fn = hsa_queue_store_read_index_relaxed_callback;
  table->hsa_queue_store_read_index_screlease_fn = hsa_queue_store_read_index_screlease_callback;
  table->hsa_agent_iterate_regions_fn = hsa_agent_iterate_regions_callback;
  table->hsa_region_get_info_fn = hsa_region_get_info_callback;
  table->hsa_agent_get_exception_policies_fn = hsa_agent_get_exception_policies_callback;
  table->hsa_agent_extension_supported_fn = hsa_agent_extension_supported_callback;
  table->hsa_memory_register_fn = hsa_memory_register_callback;
  table->hsa_memory_deregister_fn = hsa_memory_deregister_callback;
  table->hsa_memory_allocate_fn = hsa_memory_allocate_callback;
  table->hsa_memory_free_fn = hsa_memory_free_callback;
  table->hsa_memory_copy_fn = hsa_memory_copy_callback;
  table->hsa_memory_assign_agent_fn = hsa_memory_assign_agent_callback;
  table->hsa_signal_create_fn = hsa_signal_create_callback;
  table->hsa_signal_destroy_fn = hsa_signal_destroy_callback;
  table->hsa_signal_load_relaxed_fn = hsa_signal_load_relaxed_callback;
  table->hsa_signal_load_scacquire_fn = hsa_signal_load_scacquire_callback;
  table->hsa_signal_store_relaxed_fn = hsa_signal_store_relaxed_callback;
  table->hsa_signal_store_screlease_fn = hsa_signal_store_screlease_callback;
  table->hsa_signal_wait_relaxed_fn = hsa_signal_wait_relaxed_callback;
  table->hsa_signal_wait_scacquire_fn = hsa_signal_wait_scacquire_callback;
  table->hsa_signal_and_relaxed_fn = hsa_signal_and_relaxed_callback;
  table->hsa_signal_and_scacquire_fn = hsa_signal_and_scacquire_callback;
  table->hsa_signal_and_screlease_fn = hsa_signal_and_screlease_callback;
  table->hsa_signal_and_scacq_screl_fn = hsa_signal_and_scacq_screl_callback;
  table->hsa_signal_or_relaxed_fn = hsa_signal_or_relaxed_callback;
  table->hsa_signal_or_scacquire_fn = hsa_signal_or_scacquire_callback;
  table->hsa_signal_or_screlease_fn = hsa_signal_or_screlease_callback;
  table->hsa_signal_or_scacq_screl_fn = hsa_signal_or_scacq_screl_callback;
  table->hsa_signal_xor_relaxed_fn = hsa_signal_xor_relaxed_callback;
  table->hsa_signal_xor_scacquire_fn = hsa_signal_xor_scacquire_callback;
  table->hsa_signal_xor_screlease_fn = hsa_signal_xor_screlease_callback;
  table->hsa_signal_xor_scacq_screl_fn = hsa_signal_xor_scacq_screl_callback;
  table->hsa_signal_exchange_relaxed_fn = hsa_signal_exchange_relaxed_callback;
  table->hsa_signal_exchange_scacquire_fn = hsa_signal_exchange_scacquire_callback;
  table->hsa_signal_exchange_screlease_fn = hsa_signal_exchange_screlease_callback;
  table->hsa_signal_exchange_scacq_screl_fn = hsa_signal_exchange_scacq_screl_callback;
  table->hsa_signal_add_relaxed_fn = hsa_signal_add_relaxed_callback;
  table->hsa_signal_add_scacquire_fn = hsa_signal_add_scacquire_callback;
  table->hsa_signal_add_screlease_fn = hsa_signal_add_screlease_callback;
  table->hsa_signal_add_scacq_screl_fn = hsa_signal_add_scacq_screl_callback;
  table->hsa_signal_subtract_relaxed_fn = hsa_signal_subtract_relaxed_callback;
  table->hsa_signal_subtract_scacquire_fn = hsa_signal_subtract_scacquire_callback;
  table->hsa_signal_subtract_screlease_fn = hsa_signal_subtract_screlease_callback;
  table->hsa_signal_subtract_scacq_screl_fn = hsa_signal_subtract_scacq_screl_callback;
  table->hsa_signal_cas_relaxed_fn = hsa_signal_cas_relaxed_callback;
  table->hsa_signal_cas_scacquire_fn = hsa_signal_cas_scacquire_callback;
  table->hsa_signal_cas_screlease_fn = hsa_signal_cas_screlease_callback;
  table->hsa_signal_cas_scacq_screl_fn = hsa_signal_cas_scacq_screl_callback;
  table->hsa_isa_from_name_fn = hsa_isa_from_name_callback;
  table->hsa_isa_get_info_fn = hsa_isa_get_info_callback;
  table->hsa_isa_compatible_fn = hsa_isa_compatible_callback;
  table->hsa_code_object_serialize_fn = hsa_code_object_serialize_callback;
  table->hsa_code_object_deserialize_fn = hsa_code_object_deserialize_callback;
  table->hsa_code_object_destroy_fn = hsa_code_object_destroy_callback;
  table->hsa_code_object_get_info_fn = hsa_code_object_get_info_callback;
  table->hsa_code_object_get_symbol_fn = hsa_code_object_get_symbol_callback;
  table->hsa_code_symbol_get_info_fn = hsa_code_symbol_get_info_callback;
  table->hsa_code_object_iterate_symbols_fn = hsa_code_object_iterate_symbols_callback;
  table->hsa_executable_create_fn = hsa_executable_create_callback;
  table->hsa_executable_destroy_fn = hsa_executable_destroy_callback;
  table->hsa_executable_load_code_object_fn = hsa_executable_load_code_object_callback;
  table->hsa_executable_freeze_fn = hsa_executable_freeze_callback;
  table->hsa_executable_get_info_fn = hsa_executable_get_info_callback;
  table->hsa_executable_global_variable_define_fn = hsa_executable_global_variable_define_callback;
  table->hsa_executable_agent_global_variable_define_fn = hsa_executable_agent_global_variable_define_callback;
  table->hsa_executable_readonly_variable_define_fn = hsa_executable_readonly_variable_define_callback;
  table->hsa_executable_validate_fn = hsa_executable_validate_callback;
  table->hsa_executable_get_symbol_fn = hsa_executable_get_symbol_callback;
  table->hsa_executable_symbol_get_info_fn = hsa_executable_symbol_get_info_callback;
  table->hsa_executable_iterate_symbols_fn = hsa_executable_iterate_symbols_callback;
  table->hsa_status_string_fn = hsa_status_string_callback;
  table->hsa_extension_get_name_fn = hsa_extension_get_name_callback;
  table->hsa_system_major_extension_supported_fn = hsa_system_major_extension_supported_callback;
  table->hsa_system_get_major_extension_table_fn = hsa_system_get_major_extension_table_callback;
  table->hsa_agent_major_extension_supported_fn = hsa_agent_major_extension_supported_callback;
  table->hsa_cache_get_info_fn = hsa_cache_get_info_callback;
  table->hsa_agent_iterate_caches_fn = hsa_agent_iterate_caches_callback;
  table->hsa_signal_silent_store_relaxed_fn = hsa_signal_silent_store_relaxed_callback;
  table->hsa_signal_silent_store_screlease_fn = hsa_signal_silent_store_screlease_callback;
  table->hsa_signal_group_create_fn = hsa_signal_group_create_callback;
  table->hsa_signal_group_destroy_fn = hsa_signal_group_destroy_callback;
  table->hsa_signal_group_wait_any_scacquire_fn = hsa_signal_group_wait_any_scacquire_callback;
  table->hsa_signal_group_wait_any_relaxed_fn = hsa_signal_group_wait_any_relaxed_callback;
  table->hsa_agent_iterate_isas_fn = hsa_agent_iterate_isas_callback;
  table->hsa_isa_get_info_alt_fn = hsa_isa_get_info_alt_callback;
  table->hsa_isa_get_exception_policies_fn = hsa_isa_get_exception_policies_callback;
  table->hsa_isa_get_round_method_fn = hsa_isa_get_round_method_callback;
  table->hsa_wavefront_get_info_fn = hsa_wavefront_get_info_callback;
  table->hsa_isa_iterate_wavefronts_fn = hsa_isa_iterate_wavefronts_callback;
  table->hsa_code_object_get_symbol_from_name_fn = hsa_code_object_get_symbol_from_name_callback;
  table->hsa_code_object_reader_create_from_file_fn = hsa_code_object_reader_create_from_file_callback;
  table->hsa_code_object_reader_create_from_memory_fn = hsa_code_object_reader_create_from_memory_callback;
  table->hsa_code_object_reader_destroy_fn = hsa_code_object_reader_destroy_callback;
  table->hsa_executable_create_alt_fn = hsa_executable_create_alt_callback;
  table->hsa_executable_load_program_code_object_fn = hsa_executable_load_program_code_object_callback;
  table->hsa_executable_load_agent_code_object_fn = hsa_executable_load_agent_code_object_callback;
  table->hsa_executable_validate_alt_fn = hsa_executable_validate_alt_callback;
  table->hsa_executable_get_symbol_by_name_fn = hsa_executable_get_symbol_by_name_callback;
  table->hsa_executable_iterate_agent_symbols_fn = hsa_executable_iterate_agent_symbols_callback;
  table->hsa_executable_iterate_program_symbols_fn = hsa_executable_iterate_program_symbols_callback;
};
static void InstallAmdExtWrappers(AmdExtTable* table) {
  AmdExt_saved_before_cb = *table;

/* block: AmdExt API */
  table->hsa_amd_coherency_get_type_fn = hsa_amd_coherency_get_type_callback;
  table->hsa_amd_coherency_set_type_fn = hsa_amd_coherency_set_type_callback;
  table->hsa_amd_profiling_set_profiler_enabled_fn = hsa_amd_profiling_set_profiler_enabled_callback;
  table->hsa_amd_profiling_async_copy_enable_fn = hsa_amd_profiling_async_copy_enable_callback;
  table->hsa_amd_profiling_get_dispatch_time_fn = hsa_amd_profiling_get_dispatch_time_callback;
  table->hsa_amd_profiling_get_async_copy_time_fn = hsa_amd_profiling_get_async_copy_time_callback;
  table->hsa_amd_profiling_convert_tick_to_system_domain_fn = hsa_amd_profiling_convert_tick_to_system_domain_callback;
  table->hsa_amd_signal_async_handler_fn = hsa_amd_signal_async_handler_callback;
  table->hsa_amd_async_function_fn = hsa_amd_async_function_callback;
  table->hsa_amd_signal_wait_any_fn = hsa_amd_signal_wait_any_callback;
  table->hsa_amd_queue_cu_set_mask_fn = hsa_amd_queue_cu_set_mask_callback;
  table->hsa_amd_memory_pool_get_info_fn = hsa_amd_memory_pool_get_info_callback;
  table->hsa_amd_agent_iterate_memory_pools_fn = hsa_amd_agent_iterate_memory_pools_callback;
  table->hsa_amd_memory_pool_allocate_fn = hsa_amd_memory_pool_allocate_callback;
  table->hsa_amd_memory_pool_free_fn = hsa_amd_memory_pool_free_callback;
  table->hsa_amd_memory_async_copy_fn = hsa_amd_memory_async_copy_callback;
  table->hsa_amd_memory_async_copy_on_engine_fn = hsa_amd_memory_async_copy_on_engine_callback;
  table->hsa_amd_memory_copy_engine_status_fn = hsa_amd_memory_copy_engine_status_callback;
  table->hsa_amd_agent_memory_pool_get_info_fn = hsa_amd_agent_memory_pool_get_info_callback;
  table->hsa_amd_agents_allow_access_fn = hsa_amd_agents_allow_access_callback;
  table->hsa_amd_memory_pool_can_migrate_fn = hsa_amd_memory_pool_can_migrate_callback;
  table->hsa_amd_memory_migrate_fn = hsa_amd_memory_migrate_callback;
  table->hsa_amd_memory_lock_fn = hsa_amd_memory_lock_callback;
  table->hsa_amd_memory_unlock_fn = hsa_amd_memory_unlock_callback;
  table->hsa_amd_memory_fill_fn = hsa_amd_memory_fill_callback;
  table->hsa_amd_interop_map_buffer_fn = hsa_amd_interop_map_buffer_callback;
  table->hsa_amd_interop_unmap_buffer_fn = hsa_amd_interop_unmap_buffer_callback;
  table->hsa_amd_image_create_fn = hsa_amd_image_create_callback;
  table->hsa_amd_pointer_info_fn = hsa_amd_pointer_info_callback;
  table->hsa_amd_pointer_info_set_userdata_fn = hsa_amd_pointer_info_set_userdata_callback;
  table->hsa_amd_ipc_memory_create_fn = hsa_amd_ipc_memory_create_callback;
  table->hsa_amd_ipc_memory_attach_fn = hsa_amd_ipc_memory_attach_callback;
  table->hsa_amd_ipc_memory_detach_fn = hsa_amd_ipc_memory_detach_callback;
  table->hsa_amd_signal_create_fn = hsa_amd_signal_create_callback;
  table->hsa_amd_ipc_signal_create_fn = hsa_amd_ipc_signal_create_callback;
  table->hsa_amd_ipc_signal_attach_fn = hsa_amd_ipc_signal_attach_callback;
  table->hsa_amd_register_system_event_handler_fn = hsa_amd_register_system_event_handler_callback;
  table->hsa_amd_queue_intercept_create_fn = hsa_amd_queue_intercept_create_callback;
  table->hsa_amd_queue_intercept_register_fn = hsa_amd_queue_intercept_register_callback;
  table->hsa_amd_queue_set_priority_fn = hsa_amd_queue_set_priority_callback;
  table->hsa_amd_memory_async_copy_rect_fn = hsa_amd_memory_async_copy_rect_callback;
  table->hsa_amd_runtime_queue_create_register_fn = hsa_amd_runtime_queue_create_register_callback;
  table->hsa_amd_memory_lock_to_pool_fn = hsa_amd_memory_lock_to_pool_callback;
  table->hsa_amd_register_deallocation_callback_fn = hsa_amd_register_deallocation_callback_callback;
  table->hsa_amd_deregister_deallocation_callback_fn = hsa_amd_deregister_deallocation_callback_callback;
  table->hsa_amd_signal_value_pointer_fn = hsa_amd_signal_value_pointer_callback;
  table->hsa_amd_svm_attributes_set_fn = hsa_amd_svm_attributes_set_callback;
  table->hsa_amd_svm_attributes_get_fn = hsa_amd_svm_attributes_get_callback;
  table->hsa_amd_svm_prefetch_async_fn = hsa_amd_svm_prefetch_async_callback;
  table->hsa_amd_spm_acquire_fn = hsa_amd_spm_acquire_callback;
  table->hsa_amd_spm_release_fn = hsa_amd_spm_release_callback;
  table->hsa_amd_spm_set_dest_buffer_fn = hsa_amd_spm_set_dest_buffer_callback;
  table->hsa_amd_queue_cu_get_mask_fn = hsa_amd_queue_cu_get_mask_callback;
  table->hsa_amd_portable_export_dmabuf_fn = hsa_amd_portable_export_dmabuf_callback;
  table->hsa_amd_portable_close_dmabuf_fn = hsa_amd_portable_close_dmabuf_callback;
  table->hsa_amd_vmem_address_reserve_fn = hsa_amd_vmem_address_reserve_callback;
  table->hsa_amd_vmem_address_free_fn = hsa_amd_vmem_address_free_callback;
  table->hsa_amd_vmem_handle_create_fn = hsa_amd_vmem_handle_create_callback;
  table->hsa_amd_vmem_handle_release_fn = hsa_amd_vmem_handle_release_callback;
  table->hsa_amd_vmem_map_fn = hsa_amd_vmem_map_callback;
  table->hsa_amd_vmem_unmap_fn = hsa_amd_vmem_unmap_callback;
  table->hsa_amd_vmem_set_access_fn = hsa_amd_vmem_set_access_callback;
  table->hsa_amd_vmem_get_access_fn = hsa_amd_vmem_get_access_callback;
  table->hsa_amd_vmem_export_shareable_handle_fn = hsa_amd_vmem_export_shareable_handle_callback;
  table->hsa_amd_vmem_import_shareable_handle_fn = hsa_amd_vmem_import_shareable_handle_callback;
  table->hsa_amd_vmem_retain_alloc_handle_fn = hsa_amd_vmem_retain_alloc_handle_callback;
  table->hsa_amd_vmem_get_alloc_properties_from_handle_fn = hsa_amd_vmem_get_alloc_properties_from_handle_callback;
};
static void InstallImageExtWrappers(ImageExtTable* table) {
  ImageExt_saved_before_cb = *table;

/* block: ImageExt API */
  table->hsa_ext_image_get_capability_fn = hsa_ext_image_get_capability_callback;
  table->hsa_ext_image_data_get_info_fn = hsa_ext_image_data_get_info_callback;
  table->hsa_ext_image_create_fn = hsa_ext_image_create_callback;
  table->hsa_ext_image_import_fn = hsa_ext_image_import_callback;
  table->hsa_ext_image_export_fn = hsa_ext_image_export_callback;
  table->hsa_ext_image_copy_fn = hsa_ext_image_copy_callback;
  table->hsa_ext_image_clear_fn = hsa_ext_image_clear_callback;
  table->hsa_ext_image_destroy_fn = hsa_ext_image_destroy_callback;
  table->hsa_ext_sampler_create_fn = hsa_ext_sampler_create_callback;
  table->hsa_ext_sampler_destroy_fn = hsa_ext_sampler_destroy_callback;
  table->hsa_ext_image_get_capability_with_layout_fn = hsa_ext_image_get_capability_with_layout_callback;
  table->hsa_ext_image_data_get_info_with_layout_fn = hsa_ext_image_data_get_info_with_layout_callback;
  table->hsa_ext_image_create_with_layout_fn = hsa_ext_image_create_with_layout_callback;
};

/* section: API get_name function */

static const char* GetApiName(uint32_t id) {
  switch (id) {
    /* block: CoreApi API */
    case HSA_API_ID_hsa_init: return "hsa_init";
    case HSA_API_ID_hsa_shut_down: return "hsa_shut_down";
    case HSA_API_ID_hsa_system_get_info: return "hsa_system_get_info";
    case HSA_API_ID_hsa_system_extension_supported: return "hsa_system_extension_supported";
    case HSA_API_ID_hsa_system_get_extension_table: return "hsa_system_get_extension_table";
    case HSA_API_ID_hsa_iterate_agents: return "hsa_iterate_agents";
    case HSA_API_ID_hsa_agent_get_info: return "hsa_agent_get_info";
    case HSA_API_ID_hsa_queue_create: return "hsa_queue_create";
    case HSA_API_ID_hsa_soft_queue_create: return "hsa_soft_queue_create";
    case HSA_API_ID_hsa_queue_destroy: return "hsa_queue_destroy";
    case HSA_API_ID_hsa_queue_inactivate: return "hsa_queue_inactivate";
    case HSA_API_ID_hsa_queue_load_read_index_scacquire: return "hsa_queue_load_read_index_scacquire";
    case HSA_API_ID_hsa_queue_load_read_index_relaxed: return "hsa_queue_load_read_index_relaxed";
    case HSA_API_ID_hsa_queue_load_write_index_scacquire: return "hsa_queue_load_write_index_scacquire";
    case HSA_API_ID_hsa_queue_load_write_index_relaxed: return "hsa_queue_load_write_index_relaxed";
    case HSA_API_ID_hsa_queue_store_write_index_relaxed: return "hsa_queue_store_write_index_relaxed";
    case HSA_API_ID_hsa_queue_store_write_index_screlease: return "hsa_queue_store_write_index_screlease";
    case HSA_API_ID_hsa_queue_cas_write_index_scacq_screl: return "hsa_queue_cas_write_index_scacq_screl";
    case HSA_API_ID_hsa_queue_cas_write_index_scacquire: return "hsa_queue_cas_write_index_scacquire";
    case HSA_API_ID_hsa_queue_cas_write_index_relaxed: return "hsa_queue_cas_write_index_relaxed";
    case HSA_API_ID_hsa_queue_cas_write_index_screlease: return "hsa_queue_cas_write_index_screlease";
    case HSA_API_ID_hsa_queue_add_write_index_scacq_screl: return "hsa_queue_add_write_index_scacq_screl";
    case HSA_API_ID_hsa_queue_add_write_index_scacquire: return "hsa_queue_add_write_index_scacquire";
    case HSA_API_ID_hsa_queue_add_write_index_relaxed: return "hsa_queue_add_write_index_relaxed";
    case HSA_API_ID_hsa_queue_add_write_index_screlease: return "hsa_queue_add_write_index_screlease";
    case HSA_API_ID_hsa_queue_store_read_index_relaxed: return "hsa_queue_store_read_index_relaxed";
    case HSA_API_ID_hsa_queue_store_read_index_screlease: return "hsa_queue_store_read_index_screlease";
    case HSA_API_ID_hsa_agent_iterate_regions: return "hsa_agent_iterate_regions";
    case HSA_API_ID_hsa_region_get_info: return "hsa_region_get_info";
    case HSA_API_ID_hsa_agent_get_exception_policies: return "hsa_agent_get_exception_policies";
    case HSA_API_ID_hsa_agent_extension_supported: return "hsa_agent_extension_supported";
    case HSA_API_ID_hsa_memory_register: return "hsa_memory_register";
    case HSA_API_ID_hsa_memory_deregister: return "hsa_memory_deregister";
    case HSA_API_ID_hsa_memory_allocate: return "hsa_memory_allocate";
    case HSA_API_ID_hsa_memory_free: return "hsa_memory_free";
    case HSA_API_ID_hsa_memory_copy: return "hsa_memory_copy";
    case HSA_API_ID_hsa_memory_assign_agent: return "hsa_memory_assign_agent";
    case HSA_API_ID_hsa_signal_create: return "hsa_signal_create";
    case HSA_API_ID_hsa_signal_destroy: return "hsa_signal_destroy";
    case HSA_API_ID_hsa_signal_load_relaxed: return "hsa_signal_load_relaxed";
    case HSA_API_ID_hsa_signal_load_scacquire: return "hsa_signal_load_scacquire";
    case HSA_API_ID_hsa_signal_store_relaxed: return "hsa_signal_store_relaxed";
    case HSA_API_ID_hsa_signal_store_screlease: return "hsa_signal_store_screlease";
    case HSA_API_ID_hsa_signal_wait_relaxed: return "hsa_signal_wait_relaxed";
    case HSA_API_ID_hsa_signal_wait_scacquire: return "hsa_signal_wait_scacquire";
    case HSA_API_ID_hsa_signal_and_relaxed: return "hsa_signal_and_relaxed";
    case HSA_API_ID_hsa_signal_and_scacquire: return "hsa_signal_and_scacquire";
    case HSA_API_ID_hsa_signal_and_screlease: return "hsa_signal_and_screlease";
    case HSA_API_ID_hsa_signal_and_scacq_screl: return "hsa_signal_and_scacq_screl";
    case HSA_API_ID_hsa_signal_or_relaxed: return "hsa_signal_or_relaxed";
    case HSA_API_ID_hsa_signal_or_scacquire: return "hsa_signal_or_scacquire";
    case HSA_API_ID_hsa_signal_or_screlease: return "hsa_signal_or_screlease";
    case HSA_API_ID_hsa_signal_or_scacq_screl: return "hsa_signal_or_scacq_screl";
    case HSA_API_ID_hsa_signal_xor_relaxed: return "hsa_signal_xor_relaxed";
    case HSA_API_ID_hsa_signal_xor_scacquire: return "hsa_signal_xor_scacquire";
    case HSA_API_ID_hsa_signal_xor_screlease: return "hsa_signal_xor_screlease";
    case HSA_API_ID_hsa_signal_xor_scacq_screl: return "hsa_signal_xor_scacq_screl";
    case HSA_API_ID_hsa_signal_exchange_relaxed: return "hsa_signal_exchange_relaxed";
    case HSA_API_ID_hsa_signal_exchange_scacquire: return "hsa_signal_exchange_scacquire";
    case HSA_API_ID_hsa_signal_exchange_screlease: return "hsa_signal_exchange_screlease";
    case HSA_API_ID_hsa_signal_exchange_scacq_screl: return "hsa_signal_exchange_scacq_screl";
    case HSA_API_ID_hsa_signal_add_relaxed: return "hsa_signal_add_relaxed";
    case HSA_API_ID_hsa_signal_add_scacquire: return "hsa_signal_add_scacquire";
    case HSA_API_ID_hsa_signal_add_screlease: return "hsa_signal_add_screlease";
    case HSA_API_ID_hsa_signal_add_scacq_screl: return "hsa_signal_add_scacq_screl";
    case HSA_API_ID_hsa_signal_subtract_relaxed: return "hsa_signal_subtract_relaxed";
    case HSA_API_ID_hsa_signal_subtract_scacquire: return "hsa_signal_subtract_scacquire";
    case HSA_API_ID_hsa_signal_subtract_screlease: return "hsa_signal_subtract_screlease";
    case HSA_API_ID_hsa_signal_subtract_scacq_screl: return "hsa_signal_subtract_scacq_screl";
    case HSA_API_ID_hsa_signal_cas_relaxed: return "hsa_signal_cas_relaxed";
    case HSA_API_ID_hsa_signal_cas_scacquire: return "hsa_signal_cas_scacquire";
    case HSA_API_ID_hsa_signal_cas_screlease: return "hsa_signal_cas_screlease";
    case HSA_API_ID_hsa_signal_cas_scacq_screl: return "hsa_signal_cas_scacq_screl";
    case HSA_API_ID_hsa_isa_from_name: return "hsa_isa_from_name";
    case HSA_API_ID_hsa_isa_get_info: return "hsa_isa_get_info";
    case HSA_API_ID_hsa_isa_compatible: return "hsa_isa_compatible";
    case HSA_API_ID_hsa_code_object_serialize: return "hsa_code_object_serialize";
    case HSA_API_ID_hsa_code_object_deserialize: return "hsa_code_object_deserialize";
    case HSA_API_ID_hsa_code_object_destroy: return "hsa_code_object_destroy";
    case HSA_API_ID_hsa_code_object_get_info: return "hsa_code_object_get_info";
    case HSA_API_ID_hsa_code_object_get_symbol: return "hsa_code_object_get_symbol";
    case HSA_API_ID_hsa_code_symbol_get_info: return "hsa_code_symbol_get_info";
    case HSA_API_ID_hsa_code_object_iterate_symbols: return "hsa_code_object_iterate_symbols";
    case HSA_API_ID_hsa_executable_create: return "hsa_executable_create";
    case HSA_API_ID_hsa_executable_destroy: return "hsa_executable_destroy";
    case HSA_API_ID_hsa_executable_load_code_object: return "hsa_executable_load_code_object";
    case HSA_API_ID_hsa_executable_freeze: return "hsa_executable_freeze";
    case HSA_API_ID_hsa_executable_get_info: return "hsa_executable_get_info";
    case HSA_API_ID_hsa_executable_global_variable_define: return "hsa_executable_global_variable_define";
    case HSA_API_ID_hsa_executable_agent_global_variable_define: return "hsa_executable_agent_global_variable_define";
    case HSA_API_ID_hsa_executable_readonly_variable_define: return "hsa_executable_readonly_variable_define";
    case HSA_API_ID_hsa_executable_validate: return "hsa_executable_validate";
    case HSA_API_ID_hsa_executable_get_symbol: return "hsa_executable_get_symbol";
    case HSA_API_ID_hsa_executable_symbol_get_info: return "hsa_executable_symbol_get_info";
    case HSA_API_ID_hsa_executable_iterate_symbols: return "hsa_executable_iterate_symbols";
    case HSA_API_ID_hsa_status_string: return "hsa_status_string";
    case HSA_API_ID_hsa_extension_get_name: return "hsa_extension_get_name";
    case HSA_API_ID_hsa_system_major_extension_supported: return "hsa_system_major_extension_supported";
    case HSA_API_ID_hsa_system_get_major_extension_table: return "hsa_system_get_major_extension_table";
    case HSA_API_ID_hsa_agent_major_extension_supported: return "hsa_agent_major_extension_supported";
    case HSA_API_ID_hsa_cache_get_info: return "hsa_cache_get_info";
    case HSA_API_ID_hsa_agent_iterate_caches: return "hsa_agent_iterate_caches";
    case HSA_API_ID_hsa_signal_silent_store_relaxed: return "hsa_signal_silent_store_relaxed";
    case HSA_API_ID_hsa_signal_silent_store_screlease: return "hsa_signal_silent_store_screlease";
    case HSA_API_ID_hsa_signal_group_create: return "hsa_signal_group_create";
    case HSA_API_ID_hsa_signal_group_destroy: return "hsa_signal_group_destroy";
    case HSA_API_ID_hsa_signal_group_wait_any_scacquire: return "hsa_signal_group_wait_any_scacquire";
    case HSA_API_ID_hsa_signal_group_wait_any_relaxed: return "hsa_signal_group_wait_any_relaxed";
    case HSA_API_ID_hsa_agent_iterate_isas: return "hsa_agent_iterate_isas";
    case HSA_API_ID_hsa_isa_get_info_alt: return "hsa_isa_get_info_alt";
    case HSA_API_ID_hsa_isa_get_exception_policies: return "hsa_isa_get_exception_policies";
    case HSA_API_ID_hsa_isa_get_round_method: return "hsa_isa_get_round_method";
    case HSA_API_ID_hsa_wavefront_get_info: return "hsa_wavefront_get_info";
    case HSA_API_ID_hsa_isa_iterate_wavefronts: return "hsa_isa_iterate_wavefronts";
    case HSA_API_ID_hsa_code_object_get_symbol_from_name: return "hsa_code_object_get_symbol_from_name";
    case HSA_API_ID_hsa_code_object_reader_create_from_file: return "hsa_code_object_reader_create_from_file";
    case HSA_API_ID_hsa_code_object_reader_create_from_memory: return "hsa_code_object_reader_create_from_memory";
    case HSA_API_ID_hsa_code_object_reader_destroy: return "hsa_code_object_reader_destroy";
    case HSA_API_ID_hsa_executable_create_alt: return "hsa_executable_create_alt";
    case HSA_API_ID_hsa_executable_load_program_code_object: return "hsa_executable_load_program_code_object";
    case HSA_API_ID_hsa_executable_load_agent_code_object: return "hsa_executable_load_agent_code_object";
    case HSA_API_ID_hsa_executable_validate_alt: return "hsa_executable_validate_alt";
    case HSA_API_ID_hsa_executable_get_symbol_by_name: return "hsa_executable_get_symbol_by_name";
    case HSA_API_ID_hsa_executable_iterate_agent_symbols: return "hsa_executable_iterate_agent_symbols";
    case HSA_API_ID_hsa_executable_iterate_program_symbols: return "hsa_executable_iterate_program_symbols";

    /* block: AmdExt API */
    case HSA_API_ID_hsa_amd_coherency_get_type: return "hsa_amd_coherency_get_type";
    case HSA_API_ID_hsa_amd_coherency_set_type: return "hsa_amd_coherency_set_type";
    case HSA_API_ID_hsa_amd_profiling_set_profiler_enabled: return "hsa_amd_profiling_set_profiler_enabled";
    case HSA_API_ID_hsa_amd_profiling_async_copy_enable: return "hsa_amd_profiling_async_copy_enable";
    case HSA_API_ID_hsa_amd_profiling_get_dispatch_time: return "hsa_amd_profiling_get_dispatch_time";
    case HSA_API_ID_hsa_amd_profiling_get_async_copy_time: return "hsa_amd_profiling_get_async_copy_time";
    case HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain: return "hsa_amd_profiling_convert_tick_to_system_domain";
    case HSA_API_ID_hsa_amd_signal_async_handler: return "hsa_amd_signal_async_handler";
    case HSA_API_ID_hsa_amd_async_function: return "hsa_amd_async_function";
    case HSA_API_ID_hsa_amd_signal_wait_any: return "hsa_amd_signal_wait_any";
    case HSA_API_ID_hsa_amd_queue_cu_set_mask: return "hsa_amd_queue_cu_set_mask";
    case HSA_API_ID_hsa_amd_memory_pool_get_info: return "hsa_amd_memory_pool_get_info";
    case HSA_API_ID_hsa_amd_agent_iterate_memory_pools: return "hsa_amd_agent_iterate_memory_pools";
    case HSA_API_ID_hsa_amd_memory_pool_allocate: return "hsa_amd_memory_pool_allocate";
    case HSA_API_ID_hsa_amd_memory_pool_free: return "hsa_amd_memory_pool_free";
    case HSA_API_ID_hsa_amd_memory_async_copy: return "hsa_amd_memory_async_copy";
    case HSA_API_ID_hsa_amd_memory_async_copy_on_engine: return "hsa_amd_memory_async_copy_on_engine";
    case HSA_API_ID_hsa_amd_memory_copy_engine_status: return "hsa_amd_memory_copy_engine_status";
    case HSA_API_ID_hsa_amd_agent_memory_pool_get_info: return "hsa_amd_agent_memory_pool_get_info";
    case HSA_API_ID_hsa_amd_agents_allow_access: return "hsa_amd_agents_allow_access";
    case HSA_API_ID_hsa_amd_memory_pool_can_migrate: return "hsa_amd_memory_pool_can_migrate";
    case HSA_API_ID_hsa_amd_memory_migrate: return "hsa_amd_memory_migrate";
    case HSA_API_ID_hsa_amd_memory_lock: return "hsa_amd_memory_lock";
    case HSA_API_ID_hsa_amd_memory_unlock: return "hsa_amd_memory_unlock";
    case HSA_API_ID_hsa_amd_memory_fill: return "hsa_amd_memory_fill";
    case HSA_API_ID_hsa_amd_interop_map_buffer: return "hsa_amd_interop_map_buffer";
    case HSA_API_ID_hsa_amd_interop_unmap_buffer: return "hsa_amd_interop_unmap_buffer";
    case HSA_API_ID_hsa_amd_image_create: return "hsa_amd_image_create";
    case HSA_API_ID_hsa_amd_pointer_info: return "hsa_amd_pointer_info";
    case HSA_API_ID_hsa_amd_pointer_info_set_userdata: return "hsa_amd_pointer_info_set_userdata";
    case HSA_API_ID_hsa_amd_ipc_memory_create: return "hsa_amd_ipc_memory_create";
    case HSA_API_ID_hsa_amd_ipc_memory_attach: return "hsa_amd_ipc_memory_attach";
    case HSA_API_ID_hsa_amd_ipc_memory_detach: return "hsa_amd_ipc_memory_detach";
    case HSA_API_ID_hsa_amd_signal_create: return "hsa_amd_signal_create";
    case HSA_API_ID_hsa_amd_ipc_signal_create: return "hsa_amd_ipc_signal_create";
    case HSA_API_ID_hsa_amd_ipc_signal_attach: return "hsa_amd_ipc_signal_attach";
    case HSA_API_ID_hsa_amd_register_system_event_handler: return "hsa_amd_register_system_event_handler";
    case HSA_API_ID_hsa_amd_queue_intercept_create: return "hsa_amd_queue_intercept_create";
    case HSA_API_ID_hsa_amd_queue_intercept_register: return "hsa_amd_queue_intercept_register";
    case HSA_API_ID_hsa_amd_queue_set_priority: return "hsa_amd_queue_set_priority";
    case HSA_API_ID_hsa_amd_memory_async_copy_rect: return "hsa_amd_memory_async_copy_rect";
    case HSA_API_ID_hsa_amd_runtime_queue_create_register: return "hsa_amd_runtime_queue_create_register";
    case HSA_API_ID_hsa_amd_memory_lock_to_pool: return "hsa_amd_memory_lock_to_pool";
    case HSA_API_ID_hsa_amd_register_deallocation_callback: return "hsa_amd_register_deallocation_callback";
    case HSA_API_ID_hsa_amd_deregister_deallocation_callback: return "hsa_amd_deregister_deallocation_callback";
    case HSA_API_ID_hsa_amd_signal_value_pointer: return "hsa_amd_signal_value_pointer";
    case HSA_API_ID_hsa_amd_svm_attributes_set: return "hsa_amd_svm_attributes_set";
    case HSA_API_ID_hsa_amd_svm_attributes_get: return "hsa_amd_svm_attributes_get";
    case HSA_API_ID_hsa_amd_svm_prefetch_async: return "hsa_amd_svm_prefetch_async";
    case HSA_API_ID_hsa_amd_spm_acquire: return "hsa_amd_spm_acquire";
    case HSA_API_ID_hsa_amd_spm_release: return "hsa_amd_spm_release";
    case HSA_API_ID_hsa_amd_spm_set_dest_buffer: return "hsa_amd_spm_set_dest_buffer";
    case HSA_API_ID_hsa_amd_queue_cu_get_mask: return "hsa_amd_queue_cu_get_mask";
    case HSA_API_ID_hsa_amd_portable_export_dmabuf: return "hsa_amd_portable_export_dmabuf";
    case HSA_API_ID_hsa_amd_portable_close_dmabuf: return "hsa_amd_portable_close_dmabuf";
    case HSA_API_ID_hsa_amd_vmem_address_reserve: return "hsa_amd_vmem_address_reserve";
    case HSA_API_ID_hsa_amd_vmem_address_free: return "hsa_amd_vmem_address_free";
    case HSA_API_ID_hsa_amd_vmem_handle_create: return "hsa_amd_vmem_handle_create";
    case HSA_API_ID_hsa_amd_vmem_handle_release: return "hsa_amd_vmem_handle_release";
    case HSA_API_ID_hsa_amd_vmem_map: return "hsa_amd_vmem_map";
    case HSA_API_ID_hsa_amd_vmem_unmap: return "hsa_amd_vmem_unmap";
    case HSA_API_ID_hsa_amd_vmem_set_access: return "hsa_amd_vmem_set_access";
    case HSA_API_ID_hsa_amd_vmem_get_access: return "hsa_amd_vmem_get_access";
    case HSA_API_ID_hsa_amd_vmem_export_shareable_handle: return "hsa_amd_vmem_export_shareable_handle";
    case HSA_API_ID_hsa_amd_vmem_import_shareable_handle: return "hsa_amd_vmem_import_shareable_handle";
    case HSA_API_ID_hsa_amd_vmem_retain_alloc_handle: return "hsa_amd_vmem_retain_alloc_handle";
    case HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle: return "hsa_amd_vmem_get_alloc_properties_from_handle";

    /* block: ImageExt API */
    case HSA_API_ID_hsa_ext_image_get_capability: return "hsa_ext_image_get_capability";
    case HSA_API_ID_hsa_ext_image_data_get_info: return "hsa_ext_image_data_get_info";
    case HSA_API_ID_hsa_ext_image_create: return "hsa_ext_image_create";
    case HSA_API_ID_hsa_ext_image_import: return "hsa_ext_image_import";
    case HSA_API_ID_hsa_ext_image_export: return "hsa_ext_image_export";
    case HSA_API_ID_hsa_ext_image_copy: return "hsa_ext_image_copy";
    case HSA_API_ID_hsa_ext_image_clear: return "hsa_ext_image_clear";
    case HSA_API_ID_hsa_ext_image_destroy: return "hsa_ext_image_destroy";
    case HSA_API_ID_hsa_ext_sampler_create: return "hsa_ext_sampler_create";
    case HSA_API_ID_hsa_ext_sampler_destroy: return "hsa_ext_sampler_destroy";
    case HSA_API_ID_hsa_ext_image_get_capability_with_layout: return "hsa_ext_image_get_capability_with_layout";
    case HSA_API_ID_hsa_ext_image_data_get_info_with_layout: return "hsa_ext_image_data_get_info_with_layout";
    case HSA_API_ID_hsa_ext_image_create_with_layout: return "hsa_ext_image_create_with_layout";
  }
  return "unknown";
}

/* section: API get_code function */

static uint32_t GetApiCode(const char* str) {
  /* block: CoreApi API */
  if (strcmp("hsa_init", str) == 0) return HSA_API_ID_hsa_init;
  if (strcmp("hsa_shut_down", str) == 0) return HSA_API_ID_hsa_shut_down;
  if (strcmp("hsa_system_get_info", str) == 0) return HSA_API_ID_hsa_system_get_info;
  if (strcmp("hsa_system_extension_supported", str) == 0) return HSA_API_ID_hsa_system_extension_supported;
  if (strcmp("hsa_system_get_extension_table", str) == 0) return HSA_API_ID_hsa_system_get_extension_table;
  if (strcmp("hsa_iterate_agents", str) == 0) return HSA_API_ID_hsa_iterate_agents;
  if (strcmp("hsa_agent_get_info", str) == 0) return HSA_API_ID_hsa_agent_get_info;
  if (strcmp("hsa_queue_create", str) == 0) return HSA_API_ID_hsa_queue_create;
  if (strcmp("hsa_soft_queue_create", str) == 0) return HSA_API_ID_hsa_soft_queue_create;
  if (strcmp("hsa_queue_destroy", str) == 0) return HSA_API_ID_hsa_queue_destroy;
  if (strcmp("hsa_queue_inactivate", str) == 0) return HSA_API_ID_hsa_queue_inactivate;
  if (strcmp("hsa_queue_load_read_index_scacquire", str) == 0) return HSA_API_ID_hsa_queue_load_read_index_scacquire;
  if (strcmp("hsa_queue_load_read_index_relaxed", str) == 0) return HSA_API_ID_hsa_queue_load_read_index_relaxed;
  if (strcmp("hsa_queue_load_write_index_scacquire", str) == 0) return HSA_API_ID_hsa_queue_load_write_index_scacquire;
  if (strcmp("hsa_queue_load_write_index_relaxed", str) == 0) return HSA_API_ID_hsa_queue_load_write_index_relaxed;
  if (strcmp("hsa_queue_store_write_index_relaxed", str) == 0) return HSA_API_ID_hsa_queue_store_write_index_relaxed;
  if (strcmp("hsa_queue_store_write_index_screlease", str) == 0) return HSA_API_ID_hsa_queue_store_write_index_screlease;
  if (strcmp("hsa_queue_cas_write_index_scacq_screl", str) == 0) return HSA_API_ID_hsa_queue_cas_write_index_scacq_screl;
  if (strcmp("hsa_queue_cas_write_index_scacquire", str) == 0) return HSA_API_ID_hsa_queue_cas_write_index_scacquire;
  if (strcmp("hsa_queue_cas_write_index_relaxed", str) == 0) return HSA_API_ID_hsa_queue_cas_write_index_relaxed;
  if (strcmp("hsa_queue_cas_write_index_screlease", str) == 0) return HSA_API_ID_hsa_queue_cas_write_index_screlease;
  if (strcmp("hsa_queue_add_write_index_scacq_screl", str) == 0) return HSA_API_ID_hsa_queue_add_write_index_scacq_screl;
  if (strcmp("hsa_queue_add_write_index_scacquire", str) == 0) return HSA_API_ID_hsa_queue_add_write_index_scacquire;
  if (strcmp("hsa_queue_add_write_index_relaxed", str) == 0) return HSA_API_ID_hsa_queue_add_write_index_relaxed;
  if (strcmp("hsa_queue_add_write_index_screlease", str) == 0) return HSA_API_ID_hsa_queue_add_write_index_screlease;
  if (strcmp("hsa_queue_store_read_index_relaxed", str) == 0) return HSA_API_ID_hsa_queue_store_read_index_relaxed;
  if (strcmp("hsa_queue_store_read_index_screlease", str) == 0) return HSA_API_ID_hsa_queue_store_read_index_screlease;
  if (strcmp("hsa_agent_iterate_regions", str) == 0) return HSA_API_ID_hsa_agent_iterate_regions;
  if (strcmp("hsa_region_get_info", str) == 0) return HSA_API_ID_hsa_region_get_info;
  if (strcmp("hsa_agent_get_exception_policies", str) == 0) return HSA_API_ID_hsa_agent_get_exception_policies;
  if (strcmp("hsa_agent_extension_supported", str) == 0) return HSA_API_ID_hsa_agent_extension_supported;
  if (strcmp("hsa_memory_register", str) == 0) return HSA_API_ID_hsa_memory_register;
  if (strcmp("hsa_memory_deregister", str) == 0) return HSA_API_ID_hsa_memory_deregister;
  if (strcmp("hsa_memory_allocate", str) == 0) return HSA_API_ID_hsa_memory_allocate;
  if (strcmp("hsa_memory_free", str) == 0) return HSA_API_ID_hsa_memory_free;
  if (strcmp("hsa_memory_copy", str) == 0) return HSA_API_ID_hsa_memory_copy;
  if (strcmp("hsa_memory_assign_agent", str) == 0) return HSA_API_ID_hsa_memory_assign_agent;
  if (strcmp("hsa_signal_create", str) == 0) return HSA_API_ID_hsa_signal_create;
  if (strcmp("hsa_signal_destroy", str) == 0) return HSA_API_ID_hsa_signal_destroy;
  if (strcmp("hsa_signal_load_relaxed", str) == 0) return HSA_API_ID_hsa_signal_load_relaxed;
  if (strcmp("hsa_signal_load_scacquire", str) == 0) return HSA_API_ID_hsa_signal_load_scacquire;
  if (strcmp("hsa_signal_store_relaxed", str) == 0) return HSA_API_ID_hsa_signal_store_relaxed;
  if (strcmp("hsa_signal_store_screlease", str) == 0) return HSA_API_ID_hsa_signal_store_screlease;
  if (strcmp("hsa_signal_wait_relaxed", str) == 0) return HSA_API_ID_hsa_signal_wait_relaxed;
  if (strcmp("hsa_signal_wait_scacquire", str) == 0) return HSA_API_ID_hsa_signal_wait_scacquire;
  if (strcmp("hsa_signal_and_relaxed", str) == 0) return HSA_API_ID_hsa_signal_and_relaxed;
  if (strcmp("hsa_signal_and_scacquire", str) == 0) return HSA_API_ID_hsa_signal_and_scacquire;
  if (strcmp("hsa_signal_and_screlease", str) == 0) return HSA_API_ID_hsa_signal_and_screlease;
  if (strcmp("hsa_signal_and_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_and_scacq_screl;
  if (strcmp("hsa_signal_or_relaxed", str) == 0) return HSA_API_ID_hsa_signal_or_relaxed;
  if (strcmp("hsa_signal_or_scacquire", str) == 0) return HSA_API_ID_hsa_signal_or_scacquire;
  if (strcmp("hsa_signal_or_screlease", str) == 0) return HSA_API_ID_hsa_signal_or_screlease;
  if (strcmp("hsa_signal_or_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_or_scacq_screl;
  if (strcmp("hsa_signal_xor_relaxed", str) == 0) return HSA_API_ID_hsa_signal_xor_relaxed;
  if (strcmp("hsa_signal_xor_scacquire", str) == 0) return HSA_API_ID_hsa_signal_xor_scacquire;
  if (strcmp("hsa_signal_xor_screlease", str) == 0) return HSA_API_ID_hsa_signal_xor_screlease;
  if (strcmp("hsa_signal_xor_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_xor_scacq_screl;
  if (strcmp("hsa_signal_exchange_relaxed", str) == 0) return HSA_API_ID_hsa_signal_exchange_relaxed;
  if (strcmp("hsa_signal_exchange_scacquire", str) == 0) return HSA_API_ID_hsa_signal_exchange_scacquire;
  if (strcmp("hsa_signal_exchange_screlease", str) == 0) return HSA_API_ID_hsa_signal_exchange_screlease;
  if (strcmp("hsa_signal_exchange_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_exchange_scacq_screl;
  if (strcmp("hsa_signal_add_relaxed", str) == 0) return HSA_API_ID_hsa_signal_add_relaxed;
  if (strcmp("hsa_signal_add_scacquire", str) == 0) return HSA_API_ID_hsa_signal_add_scacquire;
  if (strcmp("hsa_signal_add_screlease", str) == 0) return HSA_API_ID_hsa_signal_add_screlease;
  if (strcmp("hsa_signal_add_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_add_scacq_screl;
  if (strcmp("hsa_signal_subtract_relaxed", str) == 0) return HSA_API_ID_hsa_signal_subtract_relaxed;
  if (strcmp("hsa_signal_subtract_scacquire", str) == 0) return HSA_API_ID_hsa_signal_subtract_scacquire;
  if (strcmp("hsa_signal_subtract_screlease", str) == 0) return HSA_API_ID_hsa_signal_subtract_screlease;
  if (strcmp("hsa_signal_subtract_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_subtract_scacq_screl;
  if (strcmp("hsa_signal_cas_relaxed", str) == 0) return HSA_API_ID_hsa_signal_cas_relaxed;
  if (strcmp("hsa_signal_cas_scacquire", str) == 0) return HSA_API_ID_hsa_signal_cas_scacquire;
  if (strcmp("hsa_signal_cas_screlease", str) == 0) return HSA_API_ID_hsa_signal_cas_screlease;
  if (strcmp("hsa_signal_cas_scacq_screl", str) == 0) return HSA_API_ID_hsa_signal_cas_scacq_screl;
  if (strcmp("hsa_isa_from_name", str) == 0) return HSA_API_ID_hsa_isa_from_name;
  if (strcmp("hsa_isa_get_info", str) == 0) return HSA_API_ID_hsa_isa_get_info;
  if (strcmp("hsa_isa_compatible", str) == 0) return HSA_API_ID_hsa_isa_compatible;
  if (strcmp("hsa_code_object_serialize", str) == 0) return HSA_API_ID_hsa_code_object_serialize;
  if (strcmp("hsa_code_object_deserialize", str) == 0) return HSA_API_ID_hsa_code_object_deserialize;
  if (strcmp("hsa_code_object_destroy", str) == 0) return HSA_API_ID_hsa_code_object_destroy;
  if (strcmp("hsa_code_object_get_info", str) == 0) return HSA_API_ID_hsa_code_object_get_info;
  if (strcmp("hsa_code_object_get_symbol", str) == 0) return HSA_API_ID_hsa_code_object_get_symbol;
  if (strcmp("hsa_code_symbol_get_info", str) == 0) return HSA_API_ID_hsa_code_symbol_get_info;
  if (strcmp("hsa_code_object_iterate_symbols", str) == 0) return HSA_API_ID_hsa_code_object_iterate_symbols;
  if (strcmp("hsa_executable_create", str) == 0) return HSA_API_ID_hsa_executable_create;
  if (strcmp("hsa_executable_destroy", str) == 0) return HSA_API_ID_hsa_executable_destroy;
  if (strcmp("hsa_executable_load_code_object", str) == 0) return HSA_API_ID_hsa_executable_load_code_object;
  if (strcmp("hsa_executable_freeze", str) == 0) return HSA_API_ID_hsa_executable_freeze;
  if (strcmp("hsa_executable_get_info", str) == 0) return HSA_API_ID_hsa_executable_get_info;
  if (strcmp("hsa_executable_global_variable_define", str) == 0) return HSA_API_ID_hsa_executable_global_variable_define;
  if (strcmp("hsa_executable_agent_global_variable_define", str) == 0) return HSA_API_ID_hsa_executable_agent_global_variable_define;
  if (strcmp("hsa_executable_readonly_variable_define", str) == 0) return HSA_API_ID_hsa_executable_readonly_variable_define;
  if (strcmp("hsa_executable_validate", str) == 0) return HSA_API_ID_hsa_executable_validate;
  if (strcmp("hsa_executable_get_symbol", str) == 0) return HSA_API_ID_hsa_executable_get_symbol;
  if (strcmp("hsa_executable_symbol_get_info", str) == 0) return HSA_API_ID_hsa_executable_symbol_get_info;
  if (strcmp("hsa_executable_iterate_symbols", str) == 0) return HSA_API_ID_hsa_executable_iterate_symbols;
  if (strcmp("hsa_status_string", str) == 0) return HSA_API_ID_hsa_status_string;
  if (strcmp("hsa_extension_get_name", str) == 0) return HSA_API_ID_hsa_extension_get_name;
  if (strcmp("hsa_system_major_extension_supported", str) == 0) return HSA_API_ID_hsa_system_major_extension_supported;
  if (strcmp("hsa_system_get_major_extension_table", str) == 0) return HSA_API_ID_hsa_system_get_major_extension_table;
  if (strcmp("hsa_agent_major_extension_supported", str) == 0) return HSA_API_ID_hsa_agent_major_extension_supported;
  if (strcmp("hsa_cache_get_info", str) == 0) return HSA_API_ID_hsa_cache_get_info;
  if (strcmp("hsa_agent_iterate_caches", str) == 0) return HSA_API_ID_hsa_agent_iterate_caches;
  if (strcmp("hsa_signal_silent_store_relaxed", str) == 0) return HSA_API_ID_hsa_signal_silent_store_relaxed;
  if (strcmp("hsa_signal_silent_store_screlease", str) == 0) return HSA_API_ID_hsa_signal_silent_store_screlease;
  if (strcmp("hsa_signal_group_create", str) == 0) return HSA_API_ID_hsa_signal_group_create;
  if (strcmp("hsa_signal_group_destroy", str) == 0) return HSA_API_ID_hsa_signal_group_destroy;
  if (strcmp("hsa_signal_group_wait_any_scacquire", str) == 0) return HSA_API_ID_hsa_signal_group_wait_any_scacquire;
  if (strcmp("hsa_signal_group_wait_any_relaxed", str) == 0) return HSA_API_ID_hsa_signal_group_wait_any_relaxed;
  if (strcmp("hsa_agent_iterate_isas", str) == 0) return HSA_API_ID_hsa_agent_iterate_isas;
  if (strcmp("hsa_isa_get_info_alt", str) == 0) return HSA_API_ID_hsa_isa_get_info_alt;
  if (strcmp("hsa_isa_get_exception_policies", str) == 0) return HSA_API_ID_hsa_isa_get_exception_policies;
  if (strcmp("hsa_isa_get_round_method", str) == 0) return HSA_API_ID_hsa_isa_get_round_method;
  if (strcmp("hsa_wavefront_get_info", str) == 0) return HSA_API_ID_hsa_wavefront_get_info;
  if (strcmp("hsa_isa_iterate_wavefronts", str) == 0) return HSA_API_ID_hsa_isa_iterate_wavefronts;
  if (strcmp("hsa_code_object_get_symbol_from_name", str) == 0) return HSA_API_ID_hsa_code_object_get_symbol_from_name;
  if (strcmp("hsa_code_object_reader_create_from_file", str) == 0) return HSA_API_ID_hsa_code_object_reader_create_from_file;
  if (strcmp("hsa_code_object_reader_create_from_memory", str) == 0) return HSA_API_ID_hsa_code_object_reader_create_from_memory;
  if (strcmp("hsa_code_object_reader_destroy", str) == 0) return HSA_API_ID_hsa_code_object_reader_destroy;
  if (strcmp("hsa_executable_create_alt", str) == 0) return HSA_API_ID_hsa_executable_create_alt;
  if (strcmp("hsa_executable_load_program_code_object", str) == 0) return HSA_API_ID_hsa_executable_load_program_code_object;
  if (strcmp("hsa_executable_load_agent_code_object", str) == 0) return HSA_API_ID_hsa_executable_load_agent_code_object;
  if (strcmp("hsa_executable_validate_alt", str) == 0) return HSA_API_ID_hsa_executable_validate_alt;
  if (strcmp("hsa_executable_get_symbol_by_name", str) == 0) return HSA_API_ID_hsa_executable_get_symbol_by_name;
  if (strcmp("hsa_executable_iterate_agent_symbols", str) == 0) return HSA_API_ID_hsa_executable_iterate_agent_symbols;
  if (strcmp("hsa_executable_iterate_program_symbols", str) == 0) return HSA_API_ID_hsa_executable_iterate_program_symbols;

  /* block: AmdExt API */
  if (strcmp("hsa_amd_coherency_get_type", str) == 0) return HSA_API_ID_hsa_amd_coherency_get_type;
  if (strcmp("hsa_amd_coherency_set_type", str) == 0) return HSA_API_ID_hsa_amd_coherency_set_type;
  if (strcmp("hsa_amd_profiling_set_profiler_enabled", str) == 0) return HSA_API_ID_hsa_amd_profiling_set_profiler_enabled;
  if (strcmp("hsa_amd_profiling_async_copy_enable", str) == 0) return HSA_API_ID_hsa_amd_profiling_async_copy_enable;
  if (strcmp("hsa_amd_profiling_get_dispatch_time", str) == 0) return HSA_API_ID_hsa_amd_profiling_get_dispatch_time;
  if (strcmp("hsa_amd_profiling_get_async_copy_time", str) == 0) return HSA_API_ID_hsa_amd_profiling_get_async_copy_time;
  if (strcmp("hsa_amd_profiling_convert_tick_to_system_domain", str) == 0) return HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain;
  if (strcmp("hsa_amd_signal_async_handler", str) == 0) return HSA_API_ID_hsa_amd_signal_async_handler;
  if (strcmp("hsa_amd_async_function", str) == 0) return HSA_API_ID_hsa_amd_async_function;
  if (strcmp("hsa_amd_signal_wait_any", str) == 0) return HSA_API_ID_hsa_amd_signal_wait_any;
  if (strcmp("hsa_amd_queue_cu_set_mask", str) == 0) return HSA_API_ID_hsa_amd_queue_cu_set_mask;
  if (strcmp("hsa_amd_memory_pool_get_info", str) == 0) return HSA_API_ID_hsa_amd_memory_pool_get_info;
  if (strcmp("hsa_amd_agent_iterate_memory_pools", str) == 0) return HSA_API_ID_hsa_amd_agent_iterate_memory_pools;
  if (strcmp("hsa_amd_memory_pool_allocate", str) == 0) return HSA_API_ID_hsa_amd_memory_pool_allocate;
  if (strcmp("hsa_amd_memory_pool_free", str) == 0) return HSA_API_ID_hsa_amd_memory_pool_free;
  if (strcmp("hsa_amd_memory_async_copy", str) == 0) return HSA_API_ID_hsa_amd_memory_async_copy;
  if (strcmp("hsa_amd_memory_async_copy_on_engine", str) == 0) return HSA_API_ID_hsa_amd_memory_async_copy_on_engine;
  if (strcmp("hsa_amd_memory_copy_engine_status", str) == 0) return HSA_API_ID_hsa_amd_memory_copy_engine_status;
  if (strcmp("hsa_amd_agent_memory_pool_get_info", str) == 0) return HSA_API_ID_hsa_amd_agent_memory_pool_get_info;
  if (strcmp("hsa_amd_agents_allow_access", str) == 0) return HSA_API_ID_hsa_amd_agents_allow_access;
  if (strcmp("hsa_amd_memory_pool_can_migrate", str) == 0) return HSA_API_ID_hsa_amd_memory_pool_can_migrate;
  if (strcmp("hsa_amd_memory_migrate", str) == 0) return HSA_API_ID_hsa_amd_memory_migrate;
  if (strcmp("hsa_amd_memory_lock", str) == 0) return HSA_API_ID_hsa_amd_memory_lock;
  if (strcmp("hsa_amd_memory_unlock", str) == 0) return HSA_API_ID_hsa_amd_memory_unlock;
  if (strcmp("hsa_amd_memory_fill", str) == 0) return HSA_API_ID_hsa_amd_memory_fill;
  if (strcmp("hsa_amd_interop_map_buffer", str) == 0) return HSA_API_ID_hsa_amd_interop_map_buffer;
  if (strcmp("hsa_amd_interop_unmap_buffer", str) == 0) return HSA_API_ID_hsa_amd_interop_unmap_buffer;
  if (strcmp("hsa_amd_image_create", str) == 0) return HSA_API_ID_hsa_amd_image_create;
  if (strcmp("hsa_amd_pointer_info", str) == 0) return HSA_API_ID_hsa_amd_pointer_info;
  if (strcmp("hsa_amd_pointer_info_set_userdata", str) == 0) return HSA_API_ID_hsa_amd_pointer_info_set_userdata;
  if (strcmp("hsa_amd_ipc_memory_create", str) == 0) return HSA_API_ID_hsa_amd_ipc_memory_create;
  if (strcmp("hsa_amd_ipc_memory_attach", str) == 0) return HSA_API_ID_hsa_amd_ipc_memory_attach;
  if (strcmp("hsa_amd_ipc_memory_detach", str) == 0) return HSA_API_ID_hsa_amd_ipc_memory_detach;
  if (strcmp("hsa_amd_signal_create", str) == 0) return HSA_API_ID_hsa_amd_signal_create;
  if (strcmp("hsa_amd_ipc_signal_create", str) == 0) return HSA_API_ID_hsa_amd_ipc_signal_create;
  if (strcmp("hsa_amd_ipc_signal_attach", str) == 0) return HSA_API_ID_hsa_amd_ipc_signal_attach;
  if (strcmp("hsa_amd_register_system_event_handler", str) == 0) return HSA_API_ID_hsa_amd_register_system_event_handler;
  if (strcmp("hsa_amd_queue_intercept_create", str) == 0) return HSA_API_ID_hsa_amd_queue_intercept_create;
  if (strcmp("hsa_amd_queue_intercept_register", str) == 0) return HSA_API_ID_hsa_amd_queue_intercept_register;
  if (strcmp("hsa_amd_queue_set_priority", str) == 0) return HSA_API_ID_hsa_amd_queue_set_priority;
  if (strcmp("hsa_amd_memory_async_copy_rect", str) == 0) return HSA_API_ID_hsa_amd_memory_async_copy_rect;
  if (strcmp("hsa_amd_runtime_queue_create_register", str) == 0) return HSA_API_ID_hsa_amd_runtime_queue_create_register;
  if (strcmp("hsa_amd_memory_lock_to_pool", str) == 0) return HSA_API_ID_hsa_amd_memory_lock_to_pool;
  if (strcmp("hsa_amd_register_deallocation_callback", str) == 0) return HSA_API_ID_hsa_amd_register_deallocation_callback;
  if (strcmp("hsa_amd_deregister_deallocation_callback", str) == 0) return HSA_API_ID_hsa_amd_deregister_deallocation_callback;
  if (strcmp("hsa_amd_signal_value_pointer", str) == 0) return HSA_API_ID_hsa_amd_signal_value_pointer;
  if (strcmp("hsa_amd_svm_attributes_set", str) == 0) return HSA_API_ID_hsa_amd_svm_attributes_set;
  if (strcmp("hsa_amd_svm_attributes_get", str) == 0) return HSA_API_ID_hsa_amd_svm_attributes_get;
  if (strcmp("hsa_amd_svm_prefetch_async", str) == 0) return HSA_API_ID_hsa_amd_svm_prefetch_async;
  if (strcmp("hsa_amd_spm_acquire", str) == 0) return HSA_API_ID_hsa_amd_spm_acquire;
  if (strcmp("hsa_amd_spm_release", str) == 0) return HSA_API_ID_hsa_amd_spm_release;
  if (strcmp("hsa_amd_spm_set_dest_buffer", str) == 0) return HSA_API_ID_hsa_amd_spm_set_dest_buffer;
  if (strcmp("hsa_amd_queue_cu_get_mask", str) == 0) return HSA_API_ID_hsa_amd_queue_cu_get_mask;
  if (strcmp("hsa_amd_portable_export_dmabuf", str) == 0) return HSA_API_ID_hsa_amd_portable_export_dmabuf;
  if (strcmp("hsa_amd_portable_close_dmabuf", str) == 0) return HSA_API_ID_hsa_amd_portable_close_dmabuf;
  if (strcmp("hsa_amd_vmem_address_reserve", str) == 0) return HSA_API_ID_hsa_amd_vmem_address_reserve;
  if (strcmp("hsa_amd_vmem_address_free", str) == 0) return HSA_API_ID_hsa_amd_vmem_address_free;
  if (strcmp("hsa_amd_vmem_handle_create", str) == 0) return HSA_API_ID_hsa_amd_vmem_handle_create;
  if (strcmp("hsa_amd_vmem_handle_release", str) == 0) return HSA_API_ID_hsa_amd_vmem_handle_release;
  if (strcmp("hsa_amd_vmem_map", str) == 0) return HSA_API_ID_hsa_amd_vmem_map;
  if (strcmp("hsa_amd_vmem_unmap", str) == 0) return HSA_API_ID_hsa_amd_vmem_unmap;
  if (strcmp("hsa_amd_vmem_set_access", str) == 0) return HSA_API_ID_hsa_amd_vmem_set_access;
  if (strcmp("hsa_amd_vmem_get_access", str) == 0) return HSA_API_ID_hsa_amd_vmem_get_access;
  if (strcmp("hsa_amd_vmem_export_shareable_handle", str) == 0) return HSA_API_ID_hsa_amd_vmem_export_shareable_handle;
  if (strcmp("hsa_amd_vmem_import_shareable_handle", str) == 0) return HSA_API_ID_hsa_amd_vmem_import_shareable_handle;
  if (strcmp("hsa_amd_vmem_retain_alloc_handle", str) == 0) return HSA_API_ID_hsa_amd_vmem_retain_alloc_handle;
  if (strcmp("hsa_amd_vmem_get_alloc_properties_from_handle", str) == 0) return HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle;

  /* block: ImageExt API */
  if (strcmp("hsa_ext_image_get_capability", str) == 0) return HSA_API_ID_hsa_ext_image_get_capability;
  if (strcmp("hsa_ext_image_data_get_info", str) == 0) return HSA_API_ID_hsa_ext_image_data_get_info;
  if (strcmp("hsa_ext_image_create", str) == 0) return HSA_API_ID_hsa_ext_image_create;
  if (strcmp("hsa_ext_image_import", str) == 0) return HSA_API_ID_hsa_ext_image_import;
  if (strcmp("hsa_ext_image_export", str) == 0) return HSA_API_ID_hsa_ext_image_export;
  if (strcmp("hsa_ext_image_copy", str) == 0) return HSA_API_ID_hsa_ext_image_copy;
  if (strcmp("hsa_ext_image_clear", str) == 0) return HSA_API_ID_hsa_ext_image_clear;
  if (strcmp("hsa_ext_image_destroy", str) == 0) return HSA_API_ID_hsa_ext_image_destroy;
  if (strcmp("hsa_ext_sampler_create", str) == 0) return HSA_API_ID_hsa_ext_sampler_create;
  if (strcmp("hsa_ext_sampler_destroy", str) == 0) return HSA_API_ID_hsa_ext_sampler_destroy;
  if (strcmp("hsa_ext_image_get_capability_with_layout", str) == 0) return HSA_API_ID_hsa_ext_image_get_capability_with_layout;
  if (strcmp("hsa_ext_image_data_get_info_with_layout", str) == 0) return HSA_API_ID_hsa_ext_image_data_get_info_with_layout;
  if (strcmp("hsa_ext_image_create_with_layout", str) == 0) return HSA_API_ID_hsa_ext_image_create_with_layout;
  return HSA_API_ID_NUMBER;
}

};