switch (GetOp()) {
  case HSA_API_ID_hsa_init:
    barectf_hsa_api_trace_hsa_init_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_shut_down:
    barectf_hsa_api_trace_hsa_shut_down_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_system_get_info:
    barectf_hsa_api_trace_hsa_system_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_system_extension_supported:
    barectf_hsa_api_trace_hsa_system_extension_supported_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_system_get_extension_table:
    barectf_hsa_api_trace_hsa_system_get_extension_table_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_iterate_agents:
    barectf_hsa_api_trace_hsa_iterate_agents_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_agent_get_info:
    barectf_hsa_api_trace_hsa_agent_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_create:
    barectf_hsa_api_trace_hsa_queue_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_soft_queue_create:
    barectf_hsa_api_trace_hsa_soft_queue_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_destroy:
    barectf_hsa_api_trace_hsa_queue_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_inactivate:
    barectf_hsa_api_trace_hsa_queue_inactivate_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_load_read_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_load_read_index_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_load_read_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_load_read_index_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_load_write_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_load_write_index_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_load_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_load_write_index_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_store_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_store_write_index_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_queue_store_write_index_screlease:
    barectf_hsa_api_trace_hsa_queue_store_write_index_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_scacq_screl:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_screlease:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_scacq_screl:
    barectf_hsa_api_trace_hsa_queue_add_write_index_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_add_write_index_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_add_write_index_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_screlease:
    barectf_hsa_api_trace_hsa_queue_add_write_index_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint64_t_retval)
    );
    break;
  case HSA_API_ID_hsa_queue_store_read_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_store_read_index_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_queue_store_read_index_screlease:
    barectf_hsa_api_trace_hsa_queue_store_read_index_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_agent_iterate_regions:
    barectf_hsa_api_trace_hsa_agent_iterate_regions_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_region_get_info:
    barectf_hsa_api_trace_hsa_region_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_agent_get_exception_policies:
    barectf_hsa_api_trace_hsa_agent_get_exception_policies_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_agent_extension_supported:
    barectf_hsa_api_trace_hsa_agent_extension_supported_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_memory_register:
    barectf_hsa_api_trace_hsa_memory_register_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_memory_deregister:
    barectf_hsa_api_trace_hsa_memory_deregister_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_memory_allocate:
    barectf_hsa_api_trace_hsa_memory_allocate_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_memory_free:
    barectf_hsa_api_trace_hsa_memory_free_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_memory_copy:
    barectf_hsa_api_trace_hsa_memory_copy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_memory_assign_agent:
    barectf_hsa_api_trace_hsa_memory_assign_agent_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_create:
    barectf_hsa_api_trace_hsa_signal_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_destroy:
    barectf_hsa_api_trace_hsa_signal_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_load_relaxed:
    barectf_hsa_api_trace_hsa_signal_load_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_load_scacquire:
    barectf_hsa_api_trace_hsa_signal_load_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_store_relaxed:
    barectf_hsa_api_trace_hsa_signal_store_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_store_screlease:
    barectf_hsa_api_trace_hsa_signal_store_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_wait_relaxed:
    barectf_hsa_api_trace_hsa_signal_wait_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_wait_scacquire:
    barectf_hsa_api_trace_hsa_signal_wait_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_and_relaxed:
    barectf_hsa_api_trace_hsa_signal_and_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_and_scacquire:
    barectf_hsa_api_trace_hsa_signal_and_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_and_screlease:
    barectf_hsa_api_trace_hsa_signal_and_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_and_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_and_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_or_relaxed:
    barectf_hsa_api_trace_hsa_signal_or_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_or_scacquire:
    barectf_hsa_api_trace_hsa_signal_or_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_or_screlease:
    barectf_hsa_api_trace_hsa_signal_or_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_or_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_or_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_xor_relaxed:
    barectf_hsa_api_trace_hsa_signal_xor_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_xor_scacquire:
    barectf_hsa_api_trace_hsa_signal_xor_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_xor_screlease:
    barectf_hsa_api_trace_hsa_signal_xor_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_xor_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_xor_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_relaxed:
    barectf_hsa_api_trace_hsa_signal_exchange_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_scacquire:
    barectf_hsa_api_trace_hsa_signal_exchange_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_screlease:
    barectf_hsa_api_trace_hsa_signal_exchange_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_exchange_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_add_relaxed:
    barectf_hsa_api_trace_hsa_signal_add_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_add_scacquire:
    barectf_hsa_api_trace_hsa_signal_add_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_add_screlease:
    barectf_hsa_api_trace_hsa_signal_add_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_add_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_add_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_relaxed:
    barectf_hsa_api_trace_hsa_signal_subtract_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_scacquire:
    barectf_hsa_api_trace_hsa_signal_subtract_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_screlease:
    barectf_hsa_api_trace_hsa_signal_subtract_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_subtract_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_cas_relaxed:
    barectf_hsa_api_trace_hsa_signal_cas_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_scacquire:
    barectf_hsa_api_trace_hsa_signal_cas_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_screlease:
    barectf_hsa_api_trace_hsa_signal_cas_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_cas_scacq_screl_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().hsa_signal_value_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_from_name:
    barectf_hsa_api_trace_hsa_isa_from_name_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_get_info:
    barectf_hsa_api_trace_hsa_isa_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_compatible:
    barectf_hsa_api_trace_hsa_isa_compatible_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_serialize:
    barectf_hsa_api_trace_hsa_code_object_serialize_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_deserialize:
    barectf_hsa_api_trace_hsa_code_object_deserialize_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_destroy:
    barectf_hsa_api_trace_hsa_code_object_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_get_info:
    barectf_hsa_api_trace_hsa_code_object_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_get_symbol:
    barectf_hsa_api_trace_hsa_code_object_get_symbol_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_symbol_get_info:
    barectf_hsa_api_trace_hsa_code_symbol_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_iterate_symbols:
    barectf_hsa_api_trace_hsa_code_object_iterate_symbols_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_create:
    barectf_hsa_api_trace_hsa_executable_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_destroy:
    barectf_hsa_api_trace_hsa_executable_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_load_code_object:
    barectf_hsa_api_trace_hsa_executable_load_code_object_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_freeze:
    barectf_hsa_api_trace_hsa_executable_freeze_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_get_info:
    barectf_hsa_api_trace_hsa_executable_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_global_variable_define:
    barectf_hsa_api_trace_hsa_executable_global_variable_define_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_agent_global_variable_define:
    barectf_hsa_api_trace_hsa_executable_agent_global_variable_define_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_readonly_variable_define:
    barectf_hsa_api_trace_hsa_executable_readonly_variable_define_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_validate:
    barectf_hsa_api_trace_hsa_executable_validate_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_get_symbol:
    barectf_hsa_api_trace_hsa_executable_get_symbol_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_symbol_get_info:
    barectf_hsa_api_trace_hsa_executable_symbol_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_iterate_symbols:
    barectf_hsa_api_trace_hsa_executable_iterate_symbols_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_status_string:
    barectf_hsa_api_trace_hsa_status_string_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_extension_get_name:
    barectf_hsa_api_trace_hsa_extension_get_name_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_system_major_extension_supported:
    barectf_hsa_api_trace_hsa_system_major_extension_supported_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_system_get_major_extension_table:
    barectf_hsa_api_trace_hsa_system_get_major_extension_table_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_agent_major_extension_supported:
    barectf_hsa_api_trace_hsa_agent_major_extension_supported_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_cache_get_info:
    barectf_hsa_api_trace_hsa_cache_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_agent_iterate_caches:
    barectf_hsa_api_trace_hsa_agent_iterate_caches_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_silent_store_relaxed:
    barectf_hsa_api_trace_hsa_signal_silent_store_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_silent_store_screlease:
    barectf_hsa_api_trace_hsa_signal_silent_store_screlease_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_signal_group_create:
    barectf_hsa_api_trace_hsa_signal_group_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_group_destroy:
    barectf_hsa_api_trace_hsa_signal_group_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_group_wait_any_scacquire:
    barectf_hsa_api_trace_hsa_signal_group_wait_any_scacquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_signal_group_wait_any_relaxed:
    barectf_hsa_api_trace_hsa_signal_group_wait_any_relaxed_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_agent_iterate_isas:
    barectf_hsa_api_trace_hsa_agent_iterate_isas_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_get_info_alt:
    barectf_hsa_api_trace_hsa_isa_get_info_alt_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_get_exception_policies:
    barectf_hsa_api_trace_hsa_isa_get_exception_policies_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_get_round_method:
    barectf_hsa_api_trace_hsa_isa_get_round_method_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_wavefront_get_info:
    barectf_hsa_api_trace_hsa_wavefront_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_isa_iterate_wavefronts:
    barectf_hsa_api_trace_hsa_isa_iterate_wavefronts_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_get_symbol_from_name:
    barectf_hsa_api_trace_hsa_code_object_get_symbol_from_name_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_reader_create_from_file:
    barectf_hsa_api_trace_hsa_code_object_reader_create_from_file_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_reader_create_from_memory:
    barectf_hsa_api_trace_hsa_code_object_reader_create_from_memory_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_code_object_reader_destroy:
    barectf_hsa_api_trace_hsa_code_object_reader_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_create_alt:
    barectf_hsa_api_trace_hsa_executable_create_alt_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_load_program_code_object:
    barectf_hsa_api_trace_hsa_executable_load_program_code_object_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_load_agent_code_object:
    barectf_hsa_api_trace_hsa_executable_load_agent_code_object_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_validate_alt:
    barectf_hsa_api_trace_hsa_executable_validate_alt_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_get_symbol_by_name:
    barectf_hsa_api_trace_hsa_executable_get_symbol_by_name_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_iterate_agent_symbols:
    barectf_hsa_api_trace_hsa_executable_iterate_agent_symbols_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_executable_iterate_program_symbols:
    barectf_hsa_api_trace_hsa_executable_iterate_program_symbols_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_coherency_get_type:
    barectf_hsa_api_trace_hsa_amd_coherency_get_type_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_coherency_set_type:
    barectf_hsa_api_trace_hsa_amd_coherency_set_type_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_set_profiler_enabled:
    barectf_hsa_api_trace_hsa_amd_profiling_set_profiler_enabled_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_async_copy_enable:
    barectf_hsa_api_trace_hsa_amd_profiling_async_copy_enable_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_get_dispatch_time:
    barectf_hsa_api_trace_hsa_amd_profiling_get_dispatch_time_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_get_async_copy_time:
    barectf_hsa_api_trace_hsa_amd_profiling_get_async_copy_time_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain:
    barectf_hsa_api_trace_hsa_amd_profiling_convert_tick_to_system_domain_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_signal_async_handler:
    barectf_hsa_api_trace_hsa_amd_signal_async_handler_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_async_function:
    barectf_hsa_api_trace_hsa_amd_async_function_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_signal_wait_any:
    barectf_hsa_api_trace_hsa_amd_signal_wait_any_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().uint32_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_queue_cu_set_mask:
    barectf_hsa_api_trace_hsa_amd_queue_cu_set_mask_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_get_info:
    barectf_hsa_api_trace_hsa_amd_memory_pool_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_agent_iterate_memory_pools:
    barectf_hsa_api_trace_hsa_amd_agent_iterate_memory_pools_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_allocate:
    barectf_hsa_api_trace_hsa_amd_memory_pool_allocate_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_free:
    barectf_hsa_api_trace_hsa_amd_memory_pool_free_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_async_copy:
    barectf_hsa_api_trace_hsa_amd_memory_async_copy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_async_copy_on_engine:
    barectf_hsa_api_trace_hsa_amd_memory_async_copy_on_engine_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_copy_engine_status:
    barectf_hsa_api_trace_hsa_amd_memory_copy_engine_status_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_agent_memory_pool_get_info:
    barectf_hsa_api_trace_hsa_amd_agent_memory_pool_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_agents_allow_access:
    barectf_hsa_api_trace_hsa_amd_agents_allow_access_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_can_migrate:
    barectf_hsa_api_trace_hsa_amd_memory_pool_can_migrate_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_migrate:
    barectf_hsa_api_trace_hsa_amd_memory_migrate_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_lock:
    barectf_hsa_api_trace_hsa_amd_memory_lock_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_unlock:
    barectf_hsa_api_trace_hsa_amd_memory_unlock_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_fill:
    barectf_hsa_api_trace_hsa_amd_memory_fill_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_interop_map_buffer:
    barectf_hsa_api_trace_hsa_amd_interop_map_buffer_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_interop_unmap_buffer:
    barectf_hsa_api_trace_hsa_amd_interop_unmap_buffer_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_image_create:
    barectf_hsa_api_trace_hsa_amd_image_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_pointer_info:
    barectf_hsa_api_trace_hsa_amd_pointer_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_pointer_info_set_userdata:
    barectf_hsa_api_trace_hsa_amd_pointer_info_set_userdata_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_memory_create:
    barectf_hsa_api_trace_hsa_amd_ipc_memory_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_memory_attach:
    barectf_hsa_api_trace_hsa_amd_ipc_memory_attach_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_memory_detach:
    barectf_hsa_api_trace_hsa_amd_ipc_memory_detach_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_signal_create:
    barectf_hsa_api_trace_hsa_amd_signal_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_signal_create:
    barectf_hsa_api_trace_hsa_amd_ipc_signal_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_signal_attach:
    barectf_hsa_api_trace_hsa_amd_ipc_signal_attach_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_register_system_event_handler:
    barectf_hsa_api_trace_hsa_amd_register_system_event_handler_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_queue_intercept_create:
    barectf_hsa_api_trace_hsa_amd_queue_intercept_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_queue_intercept_register:
    barectf_hsa_api_trace_hsa_amd_queue_intercept_register_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_queue_set_priority:
    barectf_hsa_api_trace_hsa_amd_queue_set_priority_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_async_copy_rect:
    barectf_hsa_api_trace_hsa_amd_memory_async_copy_rect_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_runtime_queue_create_register:
    barectf_hsa_api_trace_hsa_amd_runtime_queue_create_register_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_lock_to_pool:
    barectf_hsa_api_trace_hsa_amd_memory_lock_to_pool_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_register_deallocation_callback:
    barectf_hsa_api_trace_hsa_amd_register_deallocation_callback_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_deregister_deallocation_callback:
    barectf_hsa_api_trace_hsa_amd_deregister_deallocation_callback_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_signal_value_pointer:
    barectf_hsa_api_trace_hsa_amd_signal_value_pointer_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_svm_attributes_set:
    barectf_hsa_api_trace_hsa_amd_svm_attributes_set_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_svm_attributes_get:
    barectf_hsa_api_trace_hsa_amd_svm_attributes_get_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_svm_prefetch_async:
    barectf_hsa_api_trace_hsa_amd_svm_prefetch_async_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_spm_acquire:
    barectf_hsa_api_trace_hsa_amd_spm_acquire_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_spm_release:
    barectf_hsa_api_trace_hsa_amd_spm_release_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_spm_set_dest_buffer:
    barectf_hsa_api_trace_hsa_amd_spm_set_dest_buffer_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_queue_cu_get_mask:
    barectf_hsa_api_trace_hsa_amd_queue_cu_get_mask_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_portable_export_dmabuf:
    barectf_hsa_api_trace_hsa_amd_portable_export_dmabuf_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_portable_close_dmabuf:
    barectf_hsa_api_trace_hsa_amd_portable_close_dmabuf_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_address_reserve:
    barectf_hsa_api_trace_hsa_amd_vmem_address_reserve_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_address_free:
    barectf_hsa_api_trace_hsa_amd_vmem_address_free_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_handle_create:
    barectf_hsa_api_trace_hsa_amd_vmem_handle_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_handle_release:
    barectf_hsa_api_trace_hsa_amd_vmem_handle_release_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_map:
    barectf_hsa_api_trace_hsa_amd_vmem_map_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_unmap:
    barectf_hsa_api_trace_hsa_amd_vmem_unmap_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_set_access:
    barectf_hsa_api_trace_hsa_amd_vmem_set_access_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_get_access:
    barectf_hsa_api_trace_hsa_amd_vmem_get_access_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_export_shareable_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_export_shareable_handle_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_import_shareable_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_import_shareable_handle_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_retain_alloc_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_retain_alloc_handle_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_get_alloc_properties_from_handle_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_get_capability:
    barectf_hsa_api_trace_hsa_ext_image_get_capability_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_data_get_info:
    barectf_hsa_api_trace_hsa_ext_image_data_get_info_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_create:
    barectf_hsa_api_trace_hsa_ext_image_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_import:
    barectf_hsa_api_trace_hsa_ext_image_import_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_export:
    barectf_hsa_api_trace_hsa_ext_image_export_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_copy:
    barectf_hsa_api_trace_hsa_ext_image_copy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_clear:
    barectf_hsa_api_trace_hsa_ext_image_clear_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_destroy:
    barectf_hsa_api_trace_hsa_ext_image_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_sampler_create:
    barectf_hsa_api_trace_hsa_ext_sampler_create_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_sampler_destroy:
    barectf_hsa_api_trace_hsa_ext_sampler_destroy_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_get_capability_with_layout:
    barectf_hsa_api_trace_hsa_ext_image_get_capability_with_layout_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_data_get_info_with_layout:
    barectf_hsa_api_trace_hsa_ext_image_data_get_info_with_layout_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
  case HSA_API_ID_hsa_ext_image_create_with_layout:
    barectf_hsa_api_trace_hsa_ext_image_create_with_layout_end(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().hsa_status_t_retval)
    );
    break;
}