switch (GetOp()) {
  case HSA_API_ID_hsa_init:
    barectf_hsa_api_trace_hsa_init_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_shut_down:
    barectf_hsa_api_trace_hsa_shut_down_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId()
    );
    break;
  case HSA_API_ID_hsa_system_get_info:
    barectf_hsa_api_trace_hsa_system_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().args.hsa_system_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_system_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_system_extension_supported:
    barectf_hsa_api_trace_hsa_system_extension_supported_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_extension_supported.extension),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_extension_supported.version_major),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_extension_supported.version_minor),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_system_extension_supported.result))
    );
    break;
  case HSA_API_ID_hsa_system_get_extension_table:
    barectf_hsa_api_trace_hsa_system_get_extension_table_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_get_extension_table.extension),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_get_extension_table.version_major),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_get_extension_table.version_minor),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_system_get_extension_table.table))
    );
    break;
  case HSA_API_ID_hsa_iterate_agents:
    barectf_hsa_api_trace_hsa_iterate_agents_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_iterate_agents.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_iterate_agents.data))
    );
    break;
  case HSA_API_ID_hsa_agent_get_info:
    barectf_hsa_api_trace_hsa_agent_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_get_info.agent.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_agent_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_queue_create:
    barectf_hsa_api_trace_hsa_queue_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_create.agent.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_queue_create.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_queue_create.type),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_create.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_create.data)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_queue_create.private_segment_size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_queue_create.group_segment_size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_create.queue))
    );
    break;
  case HSA_API_ID_hsa_soft_queue_create:
    barectf_hsa_api_trace_hsa_soft_queue_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_soft_queue_create.region.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_soft_queue_create.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_soft_queue_create.type),
      static_cast<std::uint32_t>(GetApiData().args.hsa_soft_queue_create.features),
      static_cast<std::uint64_t>(GetApiData().args.hsa_soft_queue_create.doorbell_signal.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_soft_queue_create.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_destroy:
    barectf_hsa_api_trace_hsa_queue_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_destroy.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_inactivate:
    barectf_hsa_api_trace_hsa_queue_inactivate_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_inactivate.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_load_read_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_load_read_index_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_load_read_index_scacquire.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_load_read_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_load_read_index_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_load_read_index_relaxed.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_load_write_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_load_write_index_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_load_write_index_scacquire.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_load_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_load_write_index_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_load_write_index_relaxed.queue))
    );
    break;
  case HSA_API_ID_hsa_queue_store_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_store_write_index_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_store_write_index_relaxed.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_store_write_index_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_queue_store_write_index_screlease:
    barectf_hsa_api_trace_hsa_queue_store_write_index_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_store_write_index_screlease.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_store_write_index_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_scacq_screl:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_cas_write_index_scacq_screl.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_scacq_screl.expected),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_cas_write_index_scacquire.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_scacquire.expected),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_cas_write_index_relaxed.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_relaxed.expected),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_queue_cas_write_index_screlease:
    barectf_hsa_api_trace_hsa_queue_cas_write_index_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_cas_write_index_screlease.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_screlease.expected),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_cas_write_index_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_scacq_screl:
    barectf_hsa_api_trace_hsa_queue_add_write_index_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_add_write_index_scacq_screl.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_add_write_index_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_scacquire:
    barectf_hsa_api_trace_hsa_queue_add_write_index_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_add_write_index_scacquire.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_add_write_index_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_add_write_index_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_add_write_index_relaxed.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_add_write_index_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_queue_add_write_index_screlease:
    barectf_hsa_api_trace_hsa_queue_add_write_index_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_add_write_index_screlease.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_add_write_index_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_queue_store_read_index_relaxed:
    barectf_hsa_api_trace_hsa_queue_store_read_index_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_store_read_index_relaxed.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_store_read_index_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_queue_store_read_index_screlease:
    barectf_hsa_api_trace_hsa_queue_store_read_index_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_queue_store_read_index_screlease.queue)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_queue_store_read_index_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_agent_iterate_regions:
    barectf_hsa_api_trace_hsa_agent_iterate_regions_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_iterate_regions.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_iterate_regions.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_iterate_regions.data))
    );
    break;
  case HSA_API_ID_hsa_region_get_info:
    barectf_hsa_api_trace_hsa_region_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_region_get_info.region.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_region_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_region_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_agent_get_exception_policies:
    barectf_hsa_api_trace_hsa_agent_get_exception_policies_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_get_exception_policies.agent.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_agent_get_exception_policies.profile),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_get_exception_policies.mask))
    );
    break;
  case HSA_API_ID_hsa_agent_extension_supported:
    barectf_hsa_api_trace_hsa_agent_extension_supported_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_agent_extension_supported.extension),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_extension_supported.agent.handle),
      static_cast<std::uint16_t>(GetApiData().args.hsa_agent_extension_supported.version_major),
      static_cast<std::uint16_t>(GetApiData().args.hsa_agent_extension_supported.version_minor),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_extension_supported.result))
    );
    break;
  case HSA_API_ID_hsa_memory_register:
    barectf_hsa_api_trace_hsa_memory_register_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_register.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_memory_register.size)
    );
    break;
  case HSA_API_ID_hsa_memory_deregister:
    barectf_hsa_api_trace_hsa_memory_deregister_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_deregister.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_memory_deregister.size)
    );
    break;
  case HSA_API_ID_hsa_memory_allocate:
    barectf_hsa_api_trace_hsa_memory_allocate_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_memory_allocate.region.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_memory_allocate.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_allocate.ptr))
    );
    break;
  case HSA_API_ID_hsa_memory_free:
    barectf_hsa_api_trace_hsa_memory_free_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_free.ptr))
    );
    break;
  case HSA_API_ID_hsa_memory_copy:
    barectf_hsa_api_trace_hsa_memory_copy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_copy.dst)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_copy.src)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_memory_copy.size)
    );
    break;
  case HSA_API_ID_hsa_memory_assign_agent:
    barectf_hsa_api_trace_hsa_memory_assign_agent_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_memory_assign_agent.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_memory_assign_agent.agent.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_memory_assign_agent.access)
    );
    break;
  case HSA_API_ID_hsa_signal_create:
    barectf_hsa_api_trace_hsa_signal_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_create.initial_value),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_create.num_consumers),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_create.consumers)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_create.signal))
    );
    break;
  case HSA_API_ID_hsa_signal_destroy:
    barectf_hsa_api_trace_hsa_signal_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_destroy.signal.handle)
    );
    break;
  case HSA_API_ID_hsa_signal_load_relaxed:
    barectf_hsa_api_trace_hsa_signal_load_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_load_relaxed.signal.handle)
    );
    break;
  case HSA_API_ID_hsa_signal_load_scacquire:
    barectf_hsa_api_trace_hsa_signal_load_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_load_scacquire.signal.handle)
    );
    break;
  case HSA_API_ID_hsa_signal_store_relaxed:
    barectf_hsa_api_trace_hsa_signal_store_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_store_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_store_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_store_screlease:
    barectf_hsa_api_trace_hsa_signal_store_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_store_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_store_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_wait_relaxed:
    barectf_hsa_api_trace_hsa_signal_wait_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_wait_relaxed.signal.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_wait_relaxed.condition),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_wait_relaxed.compare_value),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_wait_relaxed.timeout_hint),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_wait_relaxed.wait_state_hint)
    );
    break;
  case HSA_API_ID_hsa_signal_wait_scacquire:
    barectf_hsa_api_trace_hsa_signal_wait_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_wait_scacquire.signal.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_wait_scacquire.condition),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_wait_scacquire.compare_value),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_wait_scacquire.timeout_hint),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_wait_scacquire.wait_state_hint)
    );
    break;
  case HSA_API_ID_hsa_signal_and_relaxed:
    barectf_hsa_api_trace_hsa_signal_and_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_and_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_and_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_and_scacquire:
    barectf_hsa_api_trace_hsa_signal_and_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_and_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_and_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_and_screlease:
    barectf_hsa_api_trace_hsa_signal_and_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_and_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_and_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_and_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_and_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_and_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_and_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_signal_or_relaxed:
    barectf_hsa_api_trace_hsa_signal_or_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_or_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_or_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_or_scacquire:
    barectf_hsa_api_trace_hsa_signal_or_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_or_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_or_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_or_screlease:
    barectf_hsa_api_trace_hsa_signal_or_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_or_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_or_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_or_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_or_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_or_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_or_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_signal_xor_relaxed:
    barectf_hsa_api_trace_hsa_signal_xor_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_xor_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_xor_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_xor_scacquire:
    barectf_hsa_api_trace_hsa_signal_xor_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_xor_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_xor_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_xor_screlease:
    barectf_hsa_api_trace_hsa_signal_xor_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_xor_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_xor_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_xor_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_xor_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_xor_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_xor_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_relaxed:
    barectf_hsa_api_trace_hsa_signal_exchange_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_exchange_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_exchange_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_scacquire:
    barectf_hsa_api_trace_hsa_signal_exchange_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_exchange_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_exchange_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_screlease:
    barectf_hsa_api_trace_hsa_signal_exchange_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_exchange_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_exchange_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_exchange_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_exchange_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_exchange_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_exchange_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_signal_add_relaxed:
    barectf_hsa_api_trace_hsa_signal_add_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_add_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_add_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_add_scacquire:
    barectf_hsa_api_trace_hsa_signal_add_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_add_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_add_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_add_screlease:
    barectf_hsa_api_trace_hsa_signal_add_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_add_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_add_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_add_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_add_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_add_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_add_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_relaxed:
    barectf_hsa_api_trace_hsa_signal_subtract_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_subtract_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_subtract_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_scacquire:
    barectf_hsa_api_trace_hsa_signal_subtract_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_subtract_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_subtract_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_screlease:
    barectf_hsa_api_trace_hsa_signal_subtract_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_subtract_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_subtract_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_subtract_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_subtract_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_subtract_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_subtract_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_relaxed:
    barectf_hsa_api_trace_hsa_signal_cas_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_cas_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_relaxed.expected),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_scacquire:
    barectf_hsa_api_trace_hsa_signal_cas_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_cas_scacquire.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_scacquire.expected),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_scacquire.value)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_screlease:
    barectf_hsa_api_trace_hsa_signal_cas_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_cas_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_screlease.expected),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_cas_scacq_screl:
    barectf_hsa_api_trace_hsa_signal_cas_scacq_screl_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_cas_scacq_screl.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_scacq_screl.expected),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_cas_scacq_screl.value)
    );
    break;
  case HSA_API_ID_hsa_isa_from_name:
    barectf_hsa_api_trace_hsa_isa_from_name_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      GetApiData().args.hsa_isa_from_name.name ? GetApiData().args.hsa_isa_from_name.name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_from_name.isa))
    );
    break;
  case HSA_API_ID_hsa_isa_get_info:
    barectf_hsa_api_trace_hsa_isa_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_get_info.isa.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_isa_get_info.attribute),
      static_cast<std::uint32_t>(GetApiData().args.hsa_isa_get_info.index),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_isa_compatible:
    barectf_hsa_api_trace_hsa_isa_compatible_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_compatible.code_object_isa.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_compatible.agent_isa.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_compatible.result))
    );
    break;
  case HSA_API_ID_hsa_code_object_serialize:
    barectf_hsa_api_trace_hsa_code_object_serialize_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_serialize.code_object.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_serialize.alloc_callback)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_serialize.callback_data.handle),
      GetApiData().args.hsa_code_object_serialize.options ? GetApiData().args.hsa_code_object_serialize.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_serialize.serialized_code_object)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_serialize.serialized_code_object_size))
    );
    break;
  case HSA_API_ID_hsa_code_object_deserialize:
    barectf_hsa_api_trace_hsa_code_object_deserialize_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_deserialize.serialized_code_object)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_deserialize.serialized_code_object_size),
      GetApiData().args.hsa_code_object_deserialize.options ? GetApiData().args.hsa_code_object_deserialize.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_deserialize.code_object))
    );
    break;
  case HSA_API_ID_hsa_code_object_destroy:
    barectf_hsa_api_trace_hsa_code_object_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_destroy.code_object.handle)
    );
    break;
  case HSA_API_ID_hsa_code_object_get_info:
    barectf_hsa_api_trace_hsa_code_object_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_get_info.code_object.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_code_object_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_code_object_get_symbol:
    barectf_hsa_api_trace_hsa_code_object_get_symbol_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_get_symbol.code_object.handle),
      GetApiData().args.hsa_code_object_get_symbol.symbol_name ? GetApiData().args.hsa_code_object_get_symbol.symbol_name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_get_symbol.symbol))
    );
    break;
  case HSA_API_ID_hsa_code_symbol_get_info:
    barectf_hsa_api_trace_hsa_code_symbol_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_symbol_get_info.code_symbol.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_code_symbol_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_symbol_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_code_object_iterate_symbols:
    barectf_hsa_api_trace_hsa_code_object_iterate_symbols_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_iterate_symbols.code_object.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_iterate_symbols.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_iterate_symbols.data))
    );
    break;
  case HSA_API_ID_hsa_executable_create:
    barectf_hsa_api_trace_hsa_executable_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_executable_create.profile),
      static_cast<std::uint32_t>(GetApiData().args.hsa_executable_create.executable_state),
      GetApiData().args.hsa_executable_create.options ? GetApiData().args.hsa_executable_create.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_create.executable))
    );
    break;
  case HSA_API_ID_hsa_executable_destroy:
    barectf_hsa_api_trace_hsa_executable_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_destroy.executable.handle)
    );
    break;
  case HSA_API_ID_hsa_executable_load_code_object:
    barectf_hsa_api_trace_hsa_executable_load_code_object_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_code_object.executable.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_code_object.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_code_object.code_object.handle),
      GetApiData().args.hsa_executable_load_code_object.options ? GetApiData().args.hsa_executable_load_code_object.options : ""
    );
    break;
  case HSA_API_ID_hsa_executable_freeze:
    barectf_hsa_api_trace_hsa_executable_freeze_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_freeze.executable.handle),
      GetApiData().args.hsa_executable_freeze.options ? GetApiData().args.hsa_executable_freeze.options : ""
    );
    break;
  case HSA_API_ID_hsa_executable_get_info:
    barectf_hsa_api_trace_hsa_executable_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_get_info.executable.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_executable_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_executable_global_variable_define:
    barectf_hsa_api_trace_hsa_executable_global_variable_define_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_global_variable_define.executable.handle),
      GetApiData().args.hsa_executable_global_variable_define.variable_name ? GetApiData().args.hsa_executable_global_variable_define.variable_name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_global_variable_define.address))
    );
    break;
  case HSA_API_ID_hsa_executable_agent_global_variable_define:
    barectf_hsa_api_trace_hsa_executable_agent_global_variable_define_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_agent_global_variable_define.executable.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_agent_global_variable_define.agent.handle),
      GetApiData().args.hsa_executable_agent_global_variable_define.variable_name ? GetApiData().args.hsa_executable_agent_global_variable_define.variable_name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_agent_global_variable_define.address))
    );
    break;
  case HSA_API_ID_hsa_executable_readonly_variable_define:
    barectf_hsa_api_trace_hsa_executable_readonly_variable_define_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_readonly_variable_define.executable.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_readonly_variable_define.agent.handle),
      GetApiData().args.hsa_executable_readonly_variable_define.variable_name ? GetApiData().args.hsa_executable_readonly_variable_define.variable_name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_readonly_variable_define.address))
    );
    break;
  case HSA_API_ID_hsa_executable_validate:
    barectf_hsa_api_trace_hsa_executable_validate_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_validate.executable.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_validate.result))
    );
    break;
  case HSA_API_ID_hsa_executable_get_symbol:
    barectf_hsa_api_trace_hsa_executable_get_symbol_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_get_symbol.executable.handle),
      GetApiData().args.hsa_executable_get_symbol.module_name ? GetApiData().args.hsa_executable_get_symbol.module_name : "",
      GetApiData().args.hsa_executable_get_symbol.symbol_name ? GetApiData().args.hsa_executable_get_symbol.symbol_name : "",
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_get_symbol.agent.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_executable_get_symbol.call_convention),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_get_symbol.symbol))
    );
    break;
  case HSA_API_ID_hsa_executable_symbol_get_info:
    barectf_hsa_api_trace_hsa_executable_symbol_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_symbol_get_info.executable_symbol.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_executable_symbol_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_symbol_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_executable_iterate_symbols:
    barectf_hsa_api_trace_hsa_executable_iterate_symbols_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_iterate_symbols.executable.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_iterate_symbols.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_iterate_symbols.data))
    );
    break;
  case HSA_API_ID_hsa_status_string:
    barectf_hsa_api_trace_hsa_status_string_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_status_string.status),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_status_string.status_string))
    );
    break;
  case HSA_API_ID_hsa_extension_get_name:
    barectf_hsa_api_trace_hsa_extension_get_name_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_extension_get_name.extension),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_extension_get_name.name))
    );
    break;
  case HSA_API_ID_hsa_system_major_extension_supported:
    barectf_hsa_api_trace_hsa_system_major_extension_supported_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_major_extension_supported.extension),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_major_extension_supported.version_major),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_system_major_extension_supported.version_minor)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_system_major_extension_supported.result))
    );
    break;
  case HSA_API_ID_hsa_system_get_major_extension_table:
    barectf_hsa_api_trace_hsa_system_get_major_extension_table_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_get_major_extension_table.extension),
      static_cast<std::uint16_t>(GetApiData().args.hsa_system_get_major_extension_table.version_major),
      static_cast<std::uint64_t>(GetApiData().args.hsa_system_get_major_extension_table.table_length),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_system_get_major_extension_table.table))
    );
    break;
  case HSA_API_ID_hsa_agent_major_extension_supported:
    barectf_hsa_api_trace_hsa_agent_major_extension_supported_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint16_t>(GetApiData().args.hsa_agent_major_extension_supported.extension),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_major_extension_supported.agent.handle),
      static_cast<std::uint16_t>(GetApiData().args.hsa_agent_major_extension_supported.version_major),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_major_extension_supported.version_minor)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_major_extension_supported.result))
    );
    break;
  case HSA_API_ID_hsa_cache_get_info:
    barectf_hsa_api_trace_hsa_cache_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_cache_get_info.cache.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_cache_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_cache_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_agent_iterate_caches:
    barectf_hsa_api_trace_hsa_agent_iterate_caches_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_iterate_caches.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_iterate_caches.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_iterate_caches.data))
    );
    break;
  case HSA_API_ID_hsa_signal_silent_store_relaxed:
    barectf_hsa_api_trace_hsa_signal_silent_store_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_silent_store_relaxed.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_silent_store_relaxed.value)
    );
    break;
  case HSA_API_ID_hsa_signal_silent_store_screlease:
    barectf_hsa_api_trace_hsa_signal_silent_store_screlease_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_silent_store_screlease.signal.handle),
      static_cast<std::int64_t>(GetApiData().args.hsa_signal_silent_store_screlease.value)
    );
    break;
  case HSA_API_ID_hsa_signal_group_create:
    barectf_hsa_api_trace_hsa_signal_group_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_group_create.num_signals),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_create.signals)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_group_create.num_consumers),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_create.consumers)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_create.signal_group))
    );
    break;
  case HSA_API_ID_hsa_signal_group_destroy:
    barectf_hsa_api_trace_hsa_signal_group_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_group_destroy.signal_group.handle)
    );
    break;
  case HSA_API_ID_hsa_signal_group_wait_any_scacquire:
    barectf_hsa_api_trace_hsa_signal_group_wait_any_scacquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_group_wait_any_scacquire.signal_group.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_scacquire.conditions)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_scacquire.compare_values)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_group_wait_any_scacquire.wait_state_hint),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_scacquire.signal)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_scacquire.value))
    );
    break;
  case HSA_API_ID_hsa_signal_group_wait_any_relaxed:
    barectf_hsa_api_trace_hsa_signal_group_wait_any_relaxed_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_signal_group_wait_any_relaxed.signal_group.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_relaxed.conditions)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_relaxed.compare_values)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_signal_group_wait_any_relaxed.wait_state_hint),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_relaxed.signal)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_signal_group_wait_any_relaxed.value))
    );
    break;
  case HSA_API_ID_hsa_agent_iterate_isas:
    barectf_hsa_api_trace_hsa_agent_iterate_isas_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_agent_iterate_isas.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_iterate_isas.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_agent_iterate_isas.data))
    );
    break;
  case HSA_API_ID_hsa_isa_get_info_alt:
    barectf_hsa_api_trace_hsa_isa_get_info_alt_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_get_info_alt.isa.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_isa_get_info_alt.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_get_info_alt.value))
    );
    break;
  case HSA_API_ID_hsa_isa_get_exception_policies:
    barectf_hsa_api_trace_hsa_isa_get_exception_policies_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_get_exception_policies.isa.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_isa_get_exception_policies.profile),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_get_exception_policies.mask))
    );
    break;
  case HSA_API_ID_hsa_isa_get_round_method:
    barectf_hsa_api_trace_hsa_isa_get_round_method_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_get_round_method.isa.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_isa_get_round_method.fp_type),
      static_cast<std::uint32_t>(GetApiData().args.hsa_isa_get_round_method.flush_mode),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_get_round_method.round_method))
    );
    break;
  case HSA_API_ID_hsa_wavefront_get_info:
    barectf_hsa_api_trace_hsa_wavefront_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_wavefront_get_info.wavefront.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_wavefront_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_wavefront_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_isa_iterate_wavefronts:
    barectf_hsa_api_trace_hsa_isa_iterate_wavefronts_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_isa_iterate_wavefronts.isa.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_iterate_wavefronts.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_isa_iterate_wavefronts.data))
    );
    break;
  case HSA_API_ID_hsa_code_object_get_symbol_from_name:
    barectf_hsa_api_trace_hsa_code_object_get_symbol_from_name_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_get_symbol_from_name.code_object.handle),
      GetApiData().args.hsa_code_object_get_symbol_from_name.module_name ? GetApiData().args.hsa_code_object_get_symbol_from_name.module_name : "",
      GetApiData().args.hsa_code_object_get_symbol_from_name.symbol_name ? GetApiData().args.hsa_code_object_get_symbol_from_name.symbol_name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_get_symbol_from_name.symbol))
    );
    break;
  case HSA_API_ID_hsa_code_object_reader_create_from_file:
    barectf_hsa_api_trace_hsa_code_object_reader_create_from_file_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().args.hsa_code_object_reader_create_from_file.file),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_reader_create_from_file.code_object_reader))
    );
    break;
  case HSA_API_ID_hsa_code_object_reader_create_from_memory:
    barectf_hsa_api_trace_hsa_code_object_reader_create_from_memory_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_reader_create_from_memory.code_object)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_reader_create_from_memory.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_code_object_reader_create_from_memory.code_object_reader))
    );
    break;
  case HSA_API_ID_hsa_code_object_reader_destroy:
    barectf_hsa_api_trace_hsa_code_object_reader_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_code_object_reader_destroy.code_object_reader.handle)
    );
    break;
  case HSA_API_ID_hsa_executable_create_alt:
    barectf_hsa_api_trace_hsa_executable_create_alt_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_executable_create_alt.profile),
      static_cast<std::uint32_t>(GetApiData().args.hsa_executable_create_alt.default_float_rounding_mode),
      GetApiData().args.hsa_executable_create_alt.options ? GetApiData().args.hsa_executable_create_alt.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_create_alt.executable))
    );
    break;
  case HSA_API_ID_hsa_executable_load_program_code_object:
    barectf_hsa_api_trace_hsa_executable_load_program_code_object_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_program_code_object.executable.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_program_code_object.code_object_reader.handle),
      GetApiData().args.hsa_executable_load_program_code_object.options ? GetApiData().args.hsa_executable_load_program_code_object.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_load_program_code_object.loaded_code_object))
    );
    break;
  case HSA_API_ID_hsa_executable_load_agent_code_object:
    barectf_hsa_api_trace_hsa_executable_load_agent_code_object_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_agent_code_object.executable.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_agent_code_object.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_load_agent_code_object.code_object_reader.handle),
      GetApiData().args.hsa_executable_load_agent_code_object.options ? GetApiData().args.hsa_executable_load_agent_code_object.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_load_agent_code_object.loaded_code_object))
    );
    break;
  case HSA_API_ID_hsa_executable_validate_alt:
    barectf_hsa_api_trace_hsa_executable_validate_alt_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_validate_alt.executable.handle),
      GetApiData().args.hsa_executable_validate_alt.options ? GetApiData().args.hsa_executable_validate_alt.options : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_validate_alt.result))
    );
    break;
  case HSA_API_ID_hsa_executable_get_symbol_by_name:
    barectf_hsa_api_trace_hsa_executable_get_symbol_by_name_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_get_symbol_by_name.executable.handle),
      GetApiData().args.hsa_executable_get_symbol_by_name.symbol_name ? GetApiData().args.hsa_executable_get_symbol_by_name.symbol_name : "",
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_get_symbol_by_name.agent)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_get_symbol_by_name.symbol))
    );
    break;
  case HSA_API_ID_hsa_executable_iterate_agent_symbols:
    barectf_hsa_api_trace_hsa_executable_iterate_agent_symbols_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_iterate_agent_symbols.executable.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_iterate_agent_symbols.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_iterate_agent_symbols.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_iterate_agent_symbols.data))
    );
    break;
  case HSA_API_ID_hsa_executable_iterate_program_symbols:
    barectf_hsa_api_trace_hsa_executable_iterate_program_symbols_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_executable_iterate_program_symbols.executable.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_iterate_program_symbols.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_executable_iterate_program_symbols.data))
    );
    break;
  case HSA_API_ID_hsa_amd_coherency_get_type:
    barectf_hsa_api_trace_hsa_amd_coherency_get_type_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_coherency_get_type.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_coherency_get_type.type))
    );
    break;
  case HSA_API_ID_hsa_amd_coherency_set_type:
    barectf_hsa_api_trace_hsa_amd_coherency_set_type_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_coherency_set_type.agent.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_coherency_set_type.type)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_set_profiler_enabled:
    barectf_hsa_api_trace_hsa_amd_profiling_set_profiler_enabled_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_profiling_set_profiler_enabled.queue)),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_profiling_set_profiler_enabled.enable)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_async_copy_enable:
    barectf_hsa_api_trace_hsa_amd_profiling_async_copy_enable_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_profiling_async_copy_enable.enable)
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_get_dispatch_time:
    barectf_hsa_api_trace_hsa_amd_profiling_get_dispatch_time_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_profiling_get_dispatch_time.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_profiling_get_dispatch_time.signal.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_profiling_get_dispatch_time.time))
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_get_async_copy_time:
    barectf_hsa_api_trace_hsa_amd_profiling_get_async_copy_time_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_profiling_get_async_copy_time.signal.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_profiling_get_async_copy_time.time))
    );
    break;
  case HSA_API_ID_hsa_amd_profiling_convert_tick_to_system_domain:
    barectf_hsa_api_trace_hsa_amd_profiling_convert_tick_to_system_domain_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_profiling_convert_tick_to_system_domain.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_profiling_convert_tick_to_system_domain.agent_tick),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_profiling_convert_tick_to_system_domain.system_tick))
    );
    break;
  case HSA_API_ID_hsa_amd_signal_async_handler:
    barectf_hsa_api_trace_hsa_amd_signal_async_handler_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_signal_async_handler.signal.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_signal_async_handler.cond),
      static_cast<std::int64_t>(GetApiData().args.hsa_amd_signal_async_handler.value),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_async_handler.handler)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_async_handler.arg))
    );
    break;
  case HSA_API_ID_hsa_amd_async_function:
    barectf_hsa_api_trace_hsa_amd_async_function_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_async_function.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_async_function.arg))
    );
    break;
  case HSA_API_ID_hsa_amd_signal_wait_any:
    barectf_hsa_api_trace_hsa_amd_signal_wait_any_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_signal_wait_any.signal_count),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_wait_any.signals)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_wait_any.conds)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_wait_any.values)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_signal_wait_any.timeout_hint),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_signal_wait_any.wait_hint),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_wait_any.satisfying_value))
    );
    break;
  case HSA_API_ID_hsa_amd_queue_cu_set_mask:
    barectf_hsa_api_trace_hsa_amd_queue_cu_set_mask_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_cu_set_mask.queue)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_cu_set_mask.num_cu_mask_count),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_cu_set_mask.cu_mask))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_get_info:
    barectf_hsa_api_trace_hsa_amd_memory_pool_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_pool_get_info.memory_pool.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_memory_pool_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_pool_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_amd_agent_iterate_memory_pools:
    barectf_hsa_api_trace_hsa_amd_agent_iterate_memory_pools_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_agent_iterate_memory_pools.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_agent_iterate_memory_pools.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_agent_iterate_memory_pools.data))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_allocate:
    barectf_hsa_api_trace_hsa_amd_memory_pool_allocate_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_pool_allocate.memory_pool.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_pool_allocate.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_pool_allocate.flags),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_pool_allocate.ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_free:
    barectf_hsa_api_trace_hsa_amd_memory_pool_free_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_pool_free.ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_async_copy:
    barectf_hsa_api_trace_hsa_amd_memory_async_copy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy.dst)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy.dst_agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy.src)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy.src_agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy.num_dep_signals),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy.dep_signals)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy.completion_signal.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_async_copy_on_engine:
    barectf_hsa_api_trace_hsa_amd_memory_async_copy_on_engine_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.dst)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.dst_agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.src)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.src_agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.num_dep_signals),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.dep_signals)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.completion_signal.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.engine_id),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_memory_async_copy_on_engine.force_copy_on_sdma)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_copy_engine_status:
    barectf_hsa_api_trace_hsa_amd_memory_copy_engine_status_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_copy_engine_status.dst_agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_copy_engine_status.src_agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_copy_engine_status.engine_ids_mask))
    );
    break;
  case HSA_API_ID_hsa_amd_agent_memory_pool_get_info:
    barectf_hsa_api_trace_hsa_amd_agent_memory_pool_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_agent_memory_pool_get_info.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_agent_memory_pool_get_info.memory_pool.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_agent_memory_pool_get_info.attribute),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_agent_memory_pool_get_info.value))
    );
    break;
  case HSA_API_ID_hsa_amd_agents_allow_access:
    barectf_hsa_api_trace_hsa_amd_agents_allow_access_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_agents_allow_access.num_agents),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_agents_allow_access.agents)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_agents_allow_access.flags)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_agents_allow_access.ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_pool_can_migrate:
    barectf_hsa_api_trace_hsa_amd_memory_pool_can_migrate_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_pool_can_migrate.src_memory_pool.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_pool_can_migrate.dst_memory_pool.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_pool_can_migrate.result))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_migrate:
    barectf_hsa_api_trace_hsa_amd_memory_migrate_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_migrate.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_migrate.memory_pool.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_migrate.flags)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_lock:
    barectf_hsa_api_trace_hsa_amd_memory_lock_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_lock.host_ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_lock.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_lock.agents)),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_memory_lock.num_agent),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_lock.agent_ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_unlock:
    barectf_hsa_api_trace_hsa_amd_memory_unlock_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_unlock.host_ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_fill:
    barectf_hsa_api_trace_hsa_amd_memory_fill_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_fill.ptr)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_fill.value),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_fill.count)
    );
    break;
  case HSA_API_ID_hsa_amd_interop_map_buffer:
    barectf_hsa_api_trace_hsa_amd_interop_map_buffer_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_interop_map_buffer.num_agents),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_interop_map_buffer.agents)),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_interop_map_buffer.interop_handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_interop_map_buffer.flags),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_interop_map_buffer.size)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_interop_map_buffer.ptr)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_interop_map_buffer.metadata_size)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_interop_map_buffer.metadata))
    );
    break;
  case HSA_API_ID_hsa_amd_interop_unmap_buffer:
    barectf_hsa_api_trace_hsa_amd_interop_unmap_buffer_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_interop_unmap_buffer.ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_image_create:
    barectf_hsa_api_trace_hsa_amd_image_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_image_create.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_image_create.image_descriptor)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_image_create.image_layout)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_image_create.image_data)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_image_create.access_permission),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_image_create.image))
    );
    break;
  case HSA_API_ID_hsa_amd_pointer_info:
    barectf_hsa_api_trace_hsa_amd_pointer_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info.ptr)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info.info)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info.alloc)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info.num_agents_accessible)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info.accessible))
    );
    break;
  case HSA_API_ID_hsa_amd_pointer_info_set_userdata:
    barectf_hsa_api_trace_hsa_amd_pointer_info_set_userdata_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info_set_userdata.ptr)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_pointer_info_set_userdata.userdata))
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_memory_create:
    barectf_hsa_api_trace_hsa_amd_ipc_memory_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_memory_create.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_ipc_memory_create.len),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_memory_create.handle))
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_memory_attach:
    barectf_hsa_api_trace_hsa_amd_ipc_memory_attach_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_memory_attach.handle)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_ipc_memory_attach.len),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_ipc_memory_attach.num_agents),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_memory_attach.mapping_agents)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_memory_attach.mapped_ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_memory_detach:
    barectf_hsa_api_trace_hsa_amd_ipc_memory_detach_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_memory_detach.mapped_ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_signal_create:
    barectf_hsa_api_trace_hsa_amd_signal_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int64_t>(GetApiData().args.hsa_amd_signal_create.initial_value),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_signal_create.num_consumers),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_create.consumers)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_signal_create.attributes),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_create.signal))
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_signal_create:
    barectf_hsa_api_trace_hsa_amd_ipc_signal_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_ipc_signal_create.signal.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_signal_create.handle))
    );
    break;
  case HSA_API_ID_hsa_amd_ipc_signal_attach:
    barectf_hsa_api_trace_hsa_amd_ipc_signal_attach_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_signal_attach.handle)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_ipc_signal_attach.signal))
    );
    break;
  case HSA_API_ID_hsa_amd_register_system_event_handler:
    barectf_hsa_api_trace_hsa_amd_register_system_event_handler_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_register_system_event_handler.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_register_system_event_handler.data))
    );
    break;
  case HSA_API_ID_hsa_amd_queue_intercept_create:
    barectf_hsa_api_trace_hsa_amd_queue_intercept_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_queue_intercept_create.agent_handle.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_intercept_create.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_intercept_create.type),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_intercept_create.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_intercept_create.data)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_intercept_create.private_segment_size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_intercept_create.group_segment_size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_intercept_create.queue))
    );
    break;
  case HSA_API_ID_hsa_amd_queue_intercept_register:
    barectf_hsa_api_trace_hsa_amd_queue_intercept_register_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_intercept_register.queue)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_intercept_register.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_intercept_register.user_data))
    );
    break;
  case HSA_API_ID_hsa_amd_queue_set_priority:
    barectf_hsa_api_trace_hsa_amd_queue_set_priority_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_set_priority.queue)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_set_priority.priority)
    );
    break;
  case HSA_API_ID_hsa_amd_memory_async_copy_rect:
    barectf_hsa_api_trace_hsa_amd_memory_async_copy_rect_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.dst)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.dst_offset)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.src)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.src_offset)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.range)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.range__val.x),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.range__val.y),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.range__val.z),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.copy_agent.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.dir),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.num_dep_signals),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.dep_signals)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_async_copy_rect.completion_signal.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_runtime_queue_create_register:
    barectf_hsa_api_trace_hsa_amd_runtime_queue_create_register_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_runtime_queue_create_register.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_runtime_queue_create_register.user_data))
    );
    break;
  case HSA_API_ID_hsa_amd_memory_lock_to_pool:
    barectf_hsa_api_trace_hsa_amd_memory_lock_to_pool_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.host_ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.agents)),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.num_agent),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.pool.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.flags),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_memory_lock_to_pool.agent_ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_register_deallocation_callback:
    barectf_hsa_api_trace_hsa_amd_register_deallocation_callback_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_register_deallocation_callback.ptr)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_register_deallocation_callback.callback)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_register_deallocation_callback.user_data))
    );
    break;
  case HSA_API_ID_hsa_amd_deregister_deallocation_callback:
    barectf_hsa_api_trace_hsa_amd_deregister_deallocation_callback_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_deregister_deallocation_callback.ptr)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_deregister_deallocation_callback.callback))
    );
    break;
  case HSA_API_ID_hsa_amd_signal_value_pointer:
    barectf_hsa_api_trace_hsa_amd_signal_value_pointer_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_signal_value_pointer.signal.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_signal_value_pointer.value_ptr))
    );
    break;
  case HSA_API_ID_hsa_amd_svm_attributes_set:
    barectf_hsa_api_trace_hsa_amd_svm_attributes_set_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_svm_attributes_set.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_attributes_set.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_svm_attributes_set.attribute_list)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_attributes_set.attribute_count)
    );
    break;
  case HSA_API_ID_hsa_amd_svm_attributes_get:
    barectf_hsa_api_trace_hsa_amd_svm_attributes_get_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_svm_attributes_get.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_attributes_get.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_svm_attributes_get.attribute_list)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_attributes_get.attribute_count)
    );
    break;
  case HSA_API_ID_hsa_amd_svm_prefetch_async:
    barectf_hsa_api_trace_hsa_amd_svm_prefetch_async_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_svm_prefetch_async.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_prefetch_async.size),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_prefetch_async.agent.handle),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_svm_prefetch_async.num_dep_signals),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_svm_prefetch_async.dep_signals)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_svm_prefetch_async.completion_signal.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_spm_acquire:
    barectf_hsa_api_trace_hsa_amd_spm_acquire_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_spm_acquire.preferred_agent.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_spm_release:
    barectf_hsa_api_trace_hsa_amd_spm_release_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_spm_release.preferred_agent.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_spm_set_dest_buffer:
    barectf_hsa_api_trace_hsa_amd_spm_set_dest_buffer_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_spm_set_dest_buffer.preferred_agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_spm_set_dest_buffer.size_in_bytes),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_spm_set_dest_buffer.timeout)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_spm_set_dest_buffer.size_copied)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_spm_set_dest_buffer.dest)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_spm_set_dest_buffer.is_data_loss))
    );
    break;
  case HSA_API_ID_hsa_amd_queue_cu_get_mask:
    barectf_hsa_api_trace_hsa_amd_queue_cu_get_mask_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_cu_get_mask.queue)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_queue_cu_get_mask.num_cu_mask_count),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_queue_cu_get_mask.cu_mask))
    );
    break;
  case HSA_API_ID_hsa_amd_portable_export_dmabuf:
    barectf_hsa_api_trace_hsa_amd_portable_export_dmabuf_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_portable_export_dmabuf.ptr)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_portable_export_dmabuf.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_portable_export_dmabuf.dmabuf)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_portable_export_dmabuf.offset))
    );
    break;
  case HSA_API_ID_hsa_amd_portable_close_dmabuf:
    barectf_hsa_api_trace_hsa_amd_portable_close_dmabuf_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_portable_close_dmabuf.dmabuf)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_address_reserve:
    barectf_hsa_api_trace_hsa_amd_vmem_address_reserve_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_address_reserve.va)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_address_reserve.size),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_address_reserve.address),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_address_reserve.flags)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_address_free:
    barectf_hsa_api_trace_hsa_amd_vmem_address_free_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_address_free.va)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_address_free.size)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_handle_create:
    barectf_hsa_api_trace_hsa_amd_vmem_handle_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_handle_create.pool.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_handle_create.size),
      static_cast<std::uint32_t>(GetApiData().args.hsa_amd_vmem_handle_create.type),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_handle_create.flags),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_handle_create.memory_handle))
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_handle_release:
    barectf_hsa_api_trace_hsa_amd_vmem_handle_release_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_handle_release.memory_handle.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_map:
    barectf_hsa_api_trace_hsa_amd_vmem_map_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_map.va)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_map.size),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_map.in_offset),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_map.memory_handle.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_map.flags)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_unmap:
    barectf_hsa_api_trace_hsa_amd_vmem_unmap_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_unmap.va)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_unmap.size)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_set_access:
    barectf_hsa_api_trace_hsa_amd_vmem_set_access_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_set_access.va)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_set_access.size),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_set_access.desc)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_set_access.desc_cnt)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_get_access:
    barectf_hsa_api_trace_hsa_amd_vmem_get_access_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_get_access.va)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_get_access.perms)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_get_access.agent_handle.handle)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_export_shareable_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_export_shareable_handle_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_export_shareable_handle.dmabuf_fd)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_export_shareable_handle.handle.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_export_shareable_handle.flags)
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_import_shareable_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_import_shareable_handle_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::int32_t>(GetApiData().args.hsa_amd_vmem_import_shareable_handle.dmabuf_fd),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_import_shareable_handle.handle))
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_retain_alloc_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_retain_alloc_handle_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_retain_alloc_handle.memory_handle)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_retain_alloc_handle.addr))
    );
    break;
  case HSA_API_ID_hsa_amd_vmem_get_alloc_properties_from_handle:
    barectf_hsa_api_trace_hsa_amd_vmem_get_alloc_properties_from_handle_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_amd_vmem_get_alloc_properties_from_handle.memory_handle.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_get_alloc_properties_from_handle.pool)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_amd_vmem_get_alloc_properties_from_handle.type))
    );
    break;
  case HSA_API_ID_hsa_ext_image_get_capability:
    barectf_hsa_api_trace_hsa_ext_image_get_capability_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_get_capability.agent.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_ext_image_get_capability.geometry),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_get_capability.image_format)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_get_capability.capability_mask))
    );
    break;
  case HSA_API_ID_hsa_ext_image_data_get_info:
    barectf_hsa_api_trace_hsa_ext_image_data_get_info_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_data_get_info.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_data_get_info.image_descriptor)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_ext_image_data_get_info.access_permission),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_data_get_info.image_data_info))
    );
    break;
  case HSA_API_ID_hsa_ext_image_create:
    barectf_hsa_api_trace_hsa_ext_image_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_create.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_create.image_descriptor)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_create.image_data)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_ext_image_create.access_permission),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_create.image))
    );
    break;
  case HSA_API_ID_hsa_ext_image_import:
    barectf_hsa_api_trace_hsa_ext_image_import_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_import.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_import.src_memory)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_import.src_row_pitch),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_import.src_slice_pitch),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_import.dst_image.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_import.image_region))
    );
    break;
  case HSA_API_ID_hsa_ext_image_export:
    barectf_hsa_api_trace_hsa_ext_image_export_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_export.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_export.src_image.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_export.dst_memory)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_export.dst_row_pitch),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_export.dst_slice_pitch),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_export.image_region))
    );
    break;
  case HSA_API_ID_hsa_ext_image_copy:
    barectf_hsa_api_trace_hsa_ext_image_copy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_copy.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_copy.src_image.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_copy.src_offset)),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_copy.dst_image.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_copy.dst_offset)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_copy.range))
    );
    break;
  case HSA_API_ID_hsa_ext_image_clear:
    barectf_hsa_api_trace_hsa_ext_image_clear_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_clear.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_clear.image.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_clear.data)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_clear.image_region))
    );
    break;
  case HSA_API_ID_hsa_ext_image_destroy:
    barectf_hsa_api_trace_hsa_ext_image_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_destroy.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_destroy.image.handle)
    );
    break;
  case HSA_API_ID_hsa_ext_sampler_create:
    barectf_hsa_api_trace_hsa_ext_sampler_create_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_sampler_create.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_sampler_create.sampler_descriptor)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_sampler_create.sampler))
    );
    break;
  case HSA_API_ID_hsa_ext_sampler_destroy:
    barectf_hsa_api_trace_hsa_ext_sampler_destroy_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_sampler_destroy.agent.handle),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_sampler_destroy.sampler.handle)
    );
    break;
  case HSA_API_ID_hsa_ext_image_get_capability_with_layout:
    barectf_hsa_api_trace_hsa_ext_image_get_capability_with_layout_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_get_capability_with_layout.agent.handle),
      static_cast<std::int32_t>(GetApiData().args.hsa_ext_image_get_capability_with_layout.geometry),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_get_capability_with_layout.image_format)),
      static_cast<std::int32_t>(GetApiData().args.hsa_ext_image_get_capability_with_layout.image_data_layout),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_get_capability_with_layout.capability_mask))
    );
    break;
  case HSA_API_ID_hsa_ext_image_data_get_info_with_layout:
    barectf_hsa_api_trace_hsa_ext_image_data_get_info_with_layout_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.image_descriptor)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.access_permission),
      static_cast<std::int32_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.image_data_layout),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.image_data_row_pitch),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.image_data_slice_pitch),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_data_get_info_with_layout.image_data_info))
    );
    break;
  case HSA_API_ID_hsa_ext_image_create_with_layout:
    barectf_hsa_api_trace_hsa_ext_image_create_with_layout_begin(
      &barectf_ctx,
      GetThreadId(),
      GetQueueId(),
      GetAgentId(),
      GetCorrelationId(),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_create_with_layout.agent.handle),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_create_with_layout.image_descriptor)),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_create_with_layout.image_data)),
      static_cast<std::uint32_t>(GetApiData().args.hsa_ext_image_create_with_layout.access_permission),
      static_cast<std::int32_t>(GetApiData().args.hsa_ext_image_create_with_layout.image_data_layout),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_create_with_layout.image_data_row_pitch),
      static_cast<std::uint64_t>(GetApiData().args.hsa_ext_image_create_with_layout.image_data_slice_pitch),
      static_cast<std::uint64_t>(reinterpret_cast<std::uintptr_t>(GetApiData().args.hsa_ext_image_create_with_layout.image))
    );
    break;
}