/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt -i src/tools/roc_recv/cmdline.ggo -F cmdline --output-dir build/src/x86_64-pc-linux-gnu/gcc-13.2.1-release/tools/roc_recv --set-version 0.3.0 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: roc-recv OPTIONS";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nOptions:",
  "  -v, --verbose                 Increase verbosity level (may be used multiple\n                                  times)",
  "  -L, --list-supported          list supported schemes and formats",
  "  -o, --output=IO_URI           Output file or device URI",
  "      --output-format=FILE_FORMAT\n                                Force output file format",
  "      --backup=IO_URI           Backup file or device URI (if set, used when\n                                  there are no sessions)",
  "      --backup-format=FILE_FORMAT\n                                Force backup file format",
  "  -s, --source=ENDPOINT_URI     Local source endpoint",
  "  -r, --repair=ENDPOINT_URI     Local repair endpoint",
  "  -c, --control=ENDPOINT_URI    Local control endpoint",
  "      --miface=MIFACE           IPv4 or IPv6 address of the network interface\n                                  on which to join the multicast group",
  "      --reuseaddr               enable SO_REUSEADDR when binding sockets",
  "      --sess-latency=STRING     Session target latency, TIME units",
  "      --io-latency=STRING       Playback target latency, TIME units",
  "      --latency-tolerance=STRING\n                                Maximum latency deviation, TIME units",
  "      --no-play-timeout=STRING  No playback timeout, TIME units",
  "      --choppy-play-timeout=STRING\n                                Choppy playback timeout, TIME units",
  "      --packet-limit=INT        Maximum packet size, in bytes",
  "      --frame-limit=INT         Maximum internal frame size, in bytes",
  "      --frame-length=TIME       Duration of the internal frames, TIME units",
  "      --rate=INT                Override output sample rate, Hz",
  "      --clock-backend=ENUM      Clock synchronization backend  (possible\n                                  values=\"disable\", \"niq\" default=`niq')",
  "      --clock-profile=ENUM      Clock synchronization profile  (possible\n                                  values=\"default\", \"responsive\",\n                                  \"gradual\" default=`default')",
  "      --resampler-backend=ENUM  Resampler backend  (possible\n                                  values=\"default\", \"builtin\", \"speex\",\n                                  \"speexdec\" default=`default')",
  "      --resampler-profile=ENUM  Resampler profile  (possible values=\"low\",\n                                  \"medium\", \"high\" default=`medium')",
  "  -1, --oneshot                 Exit when last connected client disconnects\n                                  (default=off)",
  "      --profiling               Enable self-profiling  (default=off)",
  "      --beep                    Enable beeping on packet loss  (default=off)",
  "      --color=ENUM              Set colored logging mode for stderr output\n                                  (possible values=\"auto\", \"always\",\n                                  \"never\" default=`auto')",
  "\nENDPOINT_URI is a network endpoint URI, e.g.:\n  rtp://0.0.0.0:10001; rtp+rs8m://127.0.0.1:10001; rs8m://[::1]:10001\n\nIO_URI is a device or file URI, e.g.:\n  pulse://default; pulse://alsa_input.pci-0000_00_1f.3.analog-stereo\n  file:///home/user/test.wav; file:./test.wav; file:-\n\nFILE_FORMAT is the output file format name, e.g.:\n  wav; ogg; mp3\n\nTIME is an integer number with a suffix, e.g.:\n  123ns; 123us; 123ms; 123s; 123m; 123h;\n\nUse --list-supported option to print the list of the supported\nURI schemes and file formats.\n\nSee further details in roc-recv(1) manual page locally or online:\nhttps://roc-streaming.org/toolkit/docs/manuals/roc_recv.html",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

const char *cmdline_parser_clock_backend_values[] = {"disable", "niq", 0}; /*< Possible values for clock-backend. */
const char *cmdline_parser_clock_profile_values[] = {"default", "responsive", "gradual", 0}; /*< Possible values for clock-profile. */
const char *cmdline_parser_resampler_backend_values[] = {"default", "builtin", "speex", "speexdec", 0}; /*< Possible values for resampler-backend. */
const char *cmdline_parser_resampler_profile_values[] = {"low", "medium", "high", 0}; /*< Possible values for resampler-profile. */
const char *cmdline_parser_color_values[] = {"auto", "always", "never", 0}; /*< Possible values for color. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->list_supported_given = 0 ;
  args_info->output_given = 0 ;
  args_info->output_format_given = 0 ;
  args_info->backup_given = 0 ;
  args_info->backup_format_given = 0 ;
  args_info->source_given = 0 ;
  args_info->repair_given = 0 ;
  args_info->control_given = 0 ;
  args_info->miface_given = 0 ;
  args_info->reuseaddr_given = 0 ;
  args_info->sess_latency_given = 0 ;
  args_info->io_latency_given = 0 ;
  args_info->latency_tolerance_given = 0 ;
  args_info->no_play_timeout_given = 0 ;
  args_info->choppy_play_timeout_given = 0 ;
  args_info->packet_limit_given = 0 ;
  args_info->frame_limit_given = 0 ;
  args_info->frame_length_given = 0 ;
  args_info->rate_given = 0 ;
  args_info->clock_backend_given = 0 ;
  args_info->clock_profile_given = 0 ;
  args_info->resampler_backend_given = 0 ;
  args_info->resampler_profile_given = 0 ;
  args_info->oneshot_given = 0 ;
  args_info->profiling_given = 0 ;
  args_info->beep_given = 0 ;
  args_info->color_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->output_format_arg = NULL;
  args_info->output_format_orig = NULL;
  args_info->backup_arg = NULL;
  args_info->backup_orig = NULL;
  args_info->backup_format_arg = NULL;
  args_info->backup_format_orig = NULL;
  args_info->source_arg = NULL;
  args_info->source_orig = NULL;
  args_info->repair_arg = NULL;
  args_info->repair_orig = NULL;
  args_info->control_arg = NULL;
  args_info->control_orig = NULL;
  args_info->miface_arg = NULL;
  args_info->miface_orig = NULL;
  args_info->sess_latency_arg = NULL;
  args_info->sess_latency_orig = NULL;
  args_info->io_latency_arg = NULL;
  args_info->io_latency_orig = NULL;
  args_info->latency_tolerance_arg = NULL;
  args_info->latency_tolerance_orig = NULL;
  args_info->no_play_timeout_arg = NULL;
  args_info->no_play_timeout_orig = NULL;
  args_info->choppy_play_timeout_arg = NULL;
  args_info->choppy_play_timeout_orig = NULL;
  args_info->packet_limit_orig = NULL;
  args_info->frame_limit_orig = NULL;
  args_info->frame_length_arg = NULL;
  args_info->frame_length_orig = NULL;
  args_info->rate_orig = NULL;
  args_info->clock_backend_arg = clock_backend_arg_niq;
  args_info->clock_backend_orig = NULL;
  args_info->clock_profile_arg = clock_profile_arg_default;
  args_info->clock_profile_orig = NULL;
  args_info->resampler_backend_arg = resampler_backend_arg_default;
  args_info->resampler_backend_orig = NULL;
  args_info->resampler_profile_arg = resampler_profile_arg_medium;
  args_info->resampler_profile_orig = NULL;
  args_info->oneshot_flag = 0;
  args_info->profiling_flag = 0;
  args_info->beep_flag = 0;
  args_info->color_arg = color_arg_auto;
  args_info->color_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->verbose_help = gengetopt_args_info_help[3] ;
  args_info->verbose_min = 0;
  args_info->verbose_max = 0;
  args_info->list_supported_help = gengetopt_args_info_help[4] ;
  args_info->output_help = gengetopt_args_info_help[5] ;
  args_info->output_format_help = gengetopt_args_info_help[6] ;
  args_info->backup_help = gengetopt_args_info_help[7] ;
  args_info->backup_format_help = gengetopt_args_info_help[8] ;
  args_info->source_help = gengetopt_args_info_help[9] ;
  args_info->source_min = 0;
  args_info->source_max = 0;
  args_info->repair_help = gengetopt_args_info_help[10] ;
  args_info->repair_min = 0;
  args_info->repair_max = 0;
  args_info->control_help = gengetopt_args_info_help[11] ;
  args_info->control_min = 0;
  args_info->control_max = 0;
  args_info->miface_help = gengetopt_args_info_help[12] ;
  args_info->miface_min = 0;
  args_info->miface_max = 0;
  args_info->reuseaddr_help = gengetopt_args_info_help[13] ;
  args_info->sess_latency_help = gengetopt_args_info_help[14] ;
  args_info->io_latency_help = gengetopt_args_info_help[15] ;
  args_info->latency_tolerance_help = gengetopt_args_info_help[16] ;
  args_info->no_play_timeout_help = gengetopt_args_info_help[17] ;
  args_info->choppy_play_timeout_help = gengetopt_args_info_help[18] ;
  args_info->packet_limit_help = gengetopt_args_info_help[19] ;
  args_info->frame_limit_help = gengetopt_args_info_help[20] ;
  args_info->frame_length_help = gengetopt_args_info_help[21] ;
  args_info->rate_help = gengetopt_args_info_help[22] ;
  args_info->clock_backend_help = gengetopt_args_info_help[23] ;
  args_info->clock_profile_help = gengetopt_args_info_help[24] ;
  args_info->resampler_backend_help = gengetopt_args_info_help[25] ;
  args_info->resampler_profile_help = gengetopt_args_info_help[26] ;
  args_info->oneshot_help = gengetopt_args_info_help[27] ;
  args_info->profiling_help = gengetopt_args_info_help[28] ;
  args_info->beep_help = gengetopt_args_info_help[29] ;
  args_info->color_help = gengetopt_args_info_help[30] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->output_format_arg));
  free_string_field (&(args_info->output_format_orig));
  free_string_field (&(args_info->backup_arg));
  free_string_field (&(args_info->backup_orig));
  free_string_field (&(args_info->backup_format_arg));
  free_string_field (&(args_info->backup_format_orig));
  free_multiple_string_field (args_info->source_given, &(args_info->source_arg), &(args_info->source_orig));
  free_multiple_string_field (args_info->repair_given, &(args_info->repair_arg), &(args_info->repair_orig));
  free_multiple_string_field (args_info->control_given, &(args_info->control_arg), &(args_info->control_orig));
  free_multiple_string_field (args_info->miface_given, &(args_info->miface_arg), &(args_info->miface_orig));
  free_string_field (&(args_info->sess_latency_arg));
  free_string_field (&(args_info->sess_latency_orig));
  free_string_field (&(args_info->io_latency_arg));
  free_string_field (&(args_info->io_latency_orig));
  free_string_field (&(args_info->latency_tolerance_arg));
  free_string_field (&(args_info->latency_tolerance_orig));
  free_string_field (&(args_info->no_play_timeout_arg));
  free_string_field (&(args_info->no_play_timeout_orig));
  free_string_field (&(args_info->choppy_play_timeout_arg));
  free_string_field (&(args_info->choppy_play_timeout_orig));
  free_string_field (&(args_info->packet_limit_orig));
  free_string_field (&(args_info->frame_limit_orig));
  free_string_field (&(args_info->frame_length_arg));
  free_string_field (&(args_info->frame_length_orig));
  free_string_field (&(args_info->rate_orig));
  free_string_field (&(args_info->clock_backend_orig));
  free_string_field (&(args_info->clock_profile_orig));
  free_string_field (&(args_info->resampler_backend_orig));
  free_string_field (&(args_info->resampler_profile_orig));
  free_string_field (&(args_info->color_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  write_multiple_into_file(outfile, args_info->verbose_given, "verbose", 0, 0);
  if (args_info->list_supported_given)
    write_into_file(outfile, "list-supported", 0, 0 );
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->output_format_given)
    write_into_file(outfile, "output-format", args_info->output_format_orig, 0);
  if (args_info->backup_given)
    write_into_file(outfile, "backup", args_info->backup_orig, 0);
  if (args_info->backup_format_given)
    write_into_file(outfile, "backup-format", args_info->backup_format_orig, 0);
  write_multiple_into_file(outfile, args_info->source_given, "source", args_info->source_orig, 0);
  write_multiple_into_file(outfile, args_info->repair_given, "repair", args_info->repair_orig, 0);
  write_multiple_into_file(outfile, args_info->control_given, "control", args_info->control_orig, 0);
  write_multiple_into_file(outfile, args_info->miface_given, "miface", args_info->miface_orig, 0);
  if (args_info->reuseaddr_given)
    write_into_file(outfile, "reuseaddr", 0, 0 );
  if (args_info->sess_latency_given)
    write_into_file(outfile, "sess-latency", args_info->sess_latency_orig, 0);
  if (args_info->io_latency_given)
    write_into_file(outfile, "io-latency", args_info->io_latency_orig, 0);
  if (args_info->latency_tolerance_given)
    write_into_file(outfile, "latency-tolerance", args_info->latency_tolerance_orig, 0);
  if (args_info->no_play_timeout_given)
    write_into_file(outfile, "no-play-timeout", args_info->no_play_timeout_orig, 0);
  if (args_info->choppy_play_timeout_given)
    write_into_file(outfile, "choppy-play-timeout", args_info->choppy_play_timeout_orig, 0);
  if (args_info->packet_limit_given)
    write_into_file(outfile, "packet-limit", args_info->packet_limit_orig, 0);
  if (args_info->frame_limit_given)
    write_into_file(outfile, "frame-limit", args_info->frame_limit_orig, 0);
  if (args_info->frame_length_given)
    write_into_file(outfile, "frame-length", args_info->frame_length_orig, 0);
  if (args_info->rate_given)
    write_into_file(outfile, "rate", args_info->rate_orig, 0);
  if (args_info->clock_backend_given)
    write_into_file(outfile, "clock-backend", args_info->clock_backend_orig, cmdline_parser_clock_backend_values);
  if (args_info->clock_profile_given)
    write_into_file(outfile, "clock-profile", args_info->clock_profile_orig, cmdline_parser_clock_profile_values);
  if (args_info->resampler_backend_given)
    write_into_file(outfile, "resampler-backend", args_info->resampler_backend_orig, cmdline_parser_resampler_backend_values);
  if (args_info->resampler_profile_given)
    write_into_file(outfile, "resampler-profile", args_info->resampler_profile_orig, cmdline_parser_resampler_profile_values);
  if (args_info->oneshot_given)
    write_into_file(outfile, "oneshot", 0, 0 );
  if (args_info->profiling_given)
    write_into_file(outfile, "profiling", 0, 0 );
  if (args_info->beep_given)
    write_into_file(outfile, "beep", 0, 0 );
  if (args_info->color_given)
    write_into_file(outfile, "color", args_info->color_orig, cmdline_parser_color_values);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->source_given, args_info->source_min, args_info->source_max, "'--source' ('-s')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->repair_given, args_info->repair_min, args_info->repair_max, "'--repair' ('-r')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->control_given, args_info->control_min, args_info->control_max, "'--control' ('-c')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->miface_given, args_info->miface_min, args_info->miface_max, "'--miface'"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
    case ARG_ENUM:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_ENUM:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
      case ARG_ENUM:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * source_list = NULL;
  struct generic_list * repair_list = NULL;
  struct generic_list * control_list = NULL;
  struct generic_list * miface_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "list-supported",	0, NULL, 'L' },
        { "output",	1, NULL, 'o' },
        { "output-format",	1, NULL, 0 },
        { "backup",	1, NULL, 0 },
        { "backup-format",	1, NULL, 0 },
        { "source",	1, NULL, 's' },
        { "repair",	1, NULL, 'r' },
        { "control",	1, NULL, 'c' },
        { "miface",	1, NULL, 0 },
        { "reuseaddr",	0, NULL, 0 },
        { "sess-latency",	1, NULL, 0 },
        { "io-latency",	1, NULL, 0 },
        { "latency-tolerance",	1, NULL, 0 },
        { "no-play-timeout",	1, NULL, 0 },
        { "choppy-play-timeout",	1, NULL, 0 },
        { "packet-limit",	1, NULL, 0 },
        { "frame-limit",	1, NULL, 0 },
        { "frame-length",	1, NULL, 0 },
        { "rate",	1, NULL, 0 },
        { "clock-backend",	1, NULL, 0 },
        { "clock-profile",	1, NULL, 0 },
        { "resampler-backend",	1, NULL, 0 },
        { "resampler-profile",	1, NULL, 0 },
        { "oneshot",	0, NULL, '1' },
        { "profiling",	0, NULL, 0 },
        { "beep",	0, NULL, 0 },
        { "color",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVvLo:s:r:c:1", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Increase verbosity level (may be used multiple times).  */
        
          local_args_info.verbose_given++;
        
          break;
        case 'L':	/* list supported schemes and formats.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->list_supported_given),
              &(local_args_info.list_supported_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "list-supported", 'L',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output file or device URI.  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Local source endpoint.  */
        
          if (update_multiple_arg_temp(&source_list, 
              &(local_args_info.source_given), optarg, 0, 0, ARG_STRING,
              "source", 's',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Local repair endpoint.  */
        
          if (update_multiple_arg_temp(&repair_list, 
              &(local_args_info.repair_given), optarg, 0, 0, ARG_STRING,
              "repair", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Local control endpoint.  */
        
          if (update_multiple_arg_temp(&control_list, 
              &(local_args_info.control_given), optarg, 0, 0, ARG_STRING,
              "control", 'c',
              additional_error))
            goto failure;
        
          break;
        case '1':	/* Exit when last connected client disconnects.  */
        
        
          if (update_arg((void *)&(args_info->oneshot_flag), 0, &(args_info->oneshot_given),
              &(local_args_info.oneshot_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "oneshot", '1',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Force output file format.  */
          if (strcmp (long_options[option_index].name, "output-format") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_format_arg), 
                 &(args_info->output_format_orig), &(args_info->output_format_given),
                &(local_args_info.output_format_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-format", '-',
                additional_error))
              goto failure;
          
          }
          /* Backup file or device URI (if set, used when there are no sessions).  */
          else if (strcmp (long_options[option_index].name, "backup") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->backup_arg), 
                 &(args_info->backup_orig), &(args_info->backup_given),
                &(local_args_info.backup_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "backup", '-',
                additional_error))
              goto failure;
          
          }
          /* Force backup file format.  */
          else if (strcmp (long_options[option_index].name, "backup-format") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->backup_format_arg), 
                 &(args_info->backup_format_orig), &(args_info->backup_format_given),
                &(local_args_info.backup_format_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "backup-format", '-',
                additional_error))
              goto failure;
          
          }
          /* IPv4 or IPv6 address of the network interface on which to join the multicast group.  */
          else if (strcmp (long_options[option_index].name, "miface") == 0)
          {
          
            if (update_multiple_arg_temp(&miface_list, 
                &(local_args_info.miface_given), optarg, 0, 0, ARG_STRING,
                "miface", '-',
                additional_error))
              goto failure;
          
          }
          /* enable SO_REUSEADDR when binding sockets.  */
          else if (strcmp (long_options[option_index].name, "reuseaddr") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->reuseaddr_given),
                &(local_args_info.reuseaddr_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "reuseaddr", '-',
                additional_error))
              goto failure;
          
          }
          /* Session target latency, TIME units.  */
          else if (strcmp (long_options[option_index].name, "sess-latency") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->sess_latency_arg), 
                 &(args_info->sess_latency_orig), &(args_info->sess_latency_given),
                &(local_args_info.sess_latency_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sess-latency", '-',
                additional_error))
              goto failure;
          
          }
          /* Playback target latency, TIME units.  */
          else if (strcmp (long_options[option_index].name, "io-latency") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->io_latency_arg), 
                 &(args_info->io_latency_orig), &(args_info->io_latency_given),
                &(local_args_info.io_latency_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "io-latency", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum latency deviation, TIME units.  */
          else if (strcmp (long_options[option_index].name, "latency-tolerance") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->latency_tolerance_arg), 
                 &(args_info->latency_tolerance_orig), &(args_info->latency_tolerance_given),
                &(local_args_info.latency_tolerance_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "latency-tolerance", '-',
                additional_error))
              goto failure;
          
          }
          /* No playback timeout, TIME units.  */
          else if (strcmp (long_options[option_index].name, "no-play-timeout") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->no_play_timeout_arg), 
                 &(args_info->no_play_timeout_orig), &(args_info->no_play_timeout_given),
                &(local_args_info.no_play_timeout_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "no-play-timeout", '-',
                additional_error))
              goto failure;
          
          }
          /* Choppy playback timeout, TIME units.  */
          else if (strcmp (long_options[option_index].name, "choppy-play-timeout") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->choppy_play_timeout_arg), 
                 &(args_info->choppy_play_timeout_orig), &(args_info->choppy_play_timeout_given),
                &(local_args_info.choppy_play_timeout_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "choppy-play-timeout", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum packet size, in bytes.  */
          else if (strcmp (long_options[option_index].name, "packet-limit") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->packet_limit_arg), 
                 &(args_info->packet_limit_orig), &(args_info->packet_limit_given),
                &(local_args_info.packet_limit_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "packet-limit", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum internal frame size, in bytes.  */
          else if (strcmp (long_options[option_index].name, "frame-limit") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->frame_limit_arg), 
                 &(args_info->frame_limit_orig), &(args_info->frame_limit_given),
                &(local_args_info.frame_limit_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "frame-limit", '-',
                additional_error))
              goto failure;
          
          }
          /* Duration of the internal frames, TIME units.  */
          else if (strcmp (long_options[option_index].name, "frame-length") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->frame_length_arg), 
                 &(args_info->frame_length_orig), &(args_info->frame_length_given),
                &(local_args_info.frame_length_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "frame-length", '-',
                additional_error))
              goto failure;
          
          }
          /* Override output sample rate, Hz.  */
          else if (strcmp (long_options[option_index].name, "rate") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->rate_arg), 
                 &(args_info->rate_orig), &(args_info->rate_given),
                &(local_args_info.rate_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "rate", '-',
                additional_error))
              goto failure;
          
          }
          /* Clock synchronization backend.  */
          else if (strcmp (long_options[option_index].name, "clock-backend") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->clock_backend_arg), 
                 &(args_info->clock_backend_orig), &(args_info->clock_backend_given),
                &(local_args_info.clock_backend_given), optarg, cmdline_parser_clock_backend_values, "niq", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "clock-backend", '-',
                additional_error))
              goto failure;
          
          }
          /* Clock synchronization profile.  */
          else if (strcmp (long_options[option_index].name, "clock-profile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->clock_profile_arg), 
                 &(args_info->clock_profile_orig), &(args_info->clock_profile_given),
                &(local_args_info.clock_profile_given), optarg, cmdline_parser_clock_profile_values, "default", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "clock-profile", '-',
                additional_error))
              goto failure;
          
          }
          /* Resampler backend.  */
          else if (strcmp (long_options[option_index].name, "resampler-backend") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->resampler_backend_arg), 
                 &(args_info->resampler_backend_orig), &(args_info->resampler_backend_given),
                &(local_args_info.resampler_backend_given), optarg, cmdline_parser_resampler_backend_values, "default", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "resampler-backend", '-',
                additional_error))
              goto failure;
          
          }
          /* Resampler profile.  */
          else if (strcmp (long_options[option_index].name, "resampler-profile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->resampler_profile_arg), 
                 &(args_info->resampler_profile_orig), &(args_info->resampler_profile_given),
                &(local_args_info.resampler_profile_given), optarg, cmdline_parser_resampler_profile_values, "medium", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "resampler-profile", '-',
                additional_error))
              goto failure;
          
          }
          /* Enable self-profiling.  */
          else if (strcmp (long_options[option_index].name, "profiling") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->profiling_flag), 0, &(args_info->profiling_given),
                &(local_args_info.profiling_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "profiling", '-',
                additional_error))
              goto failure;
          
          }
          /* Enable beeping on packet loss.  */
          else if (strcmp (long_options[option_index].name, "beep") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->beep_flag), 0, &(args_info->beep_given),
                &(local_args_info.beep_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "beep", '-',
                additional_error))
              goto failure;
          
          }
          /* Set colored logging mode for stderr output.  */
          else if (strcmp (long_options[option_index].name, "color") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->color_arg), 
                 &(args_info->color_orig), &(args_info->color_given),
                &(local_args_info.color_given), optarg, cmdline_parser_color_values, "auto", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "color", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->source_arg),
    &(args_info->source_orig), args_info->source_given,
    local_args_info.source_given, 0,
    ARG_STRING, source_list);
  update_multiple_arg((void *)&(args_info->repair_arg),
    &(args_info->repair_orig), args_info->repair_given,
    local_args_info.repair_given, 0,
    ARG_STRING, repair_list);
  update_multiple_arg((void *)&(args_info->control_arg),
    &(args_info->control_orig), args_info->control_given,
    local_args_info.control_given, 0,
    ARG_STRING, control_list);
  update_multiple_arg((void *)&(args_info->miface_arg),
    &(args_info->miface_orig), args_info->miface_given,
    local_args_info.miface_given, 0,
    ARG_STRING, miface_list);

  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  args_info->source_given += local_args_info.source_given;
  local_args_info.source_given = 0;
  args_info->repair_given += local_args_info.repair_given;
  local_args_info.repair_given = 0;
  args_info->control_given += local_args_info.control_given;
  local_args_info.control_given = 0;
  args_info->miface_given += local_args_info.miface_given;
  local_args_info.miface_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (source_list, 1 );
  free_list (repair_list, 1 );
  free_list (control_list, 1 );
  free_list (miface_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
