/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "roc-copy"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "roc-copy"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "0.3.0"
#endif

enum enum_resampler_backend { resampler_backend__NULL = -1, resampler_backend_arg_default = 0, resampler_backend_arg_builtin, resampler_backend_arg_speex, resampler_backend_arg_speexdec };
enum enum_resampler_profile { resampler_profile__NULL = -1, resampler_profile_arg_low = 0, resampler_profile_arg_medium, resampler_profile_arg_high };
enum enum_color { color__NULL = -1, color_arg_auto = 0, color_arg_always, color_arg_never };

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  unsigned int verbose_min; /**< @brief Increase verbosity level (may be used multiple times)'s minimum occurreces */
  unsigned int verbose_max; /**< @brief Increase verbosity level (may be used multiple times)'s maximum occurreces */
  const char *verbose_help; /**< @brief Increase verbosity level (may be used multiple times) help description.  */
  const char *list_supported_help; /**< @brief list supported schemes and formats help description.  */
  char * input_arg;	/**< @brief Input file URI.  */
  char * input_orig;	/**< @brief Input file URI original value given at command line.  */
  const char *input_help; /**< @brief Input file URI help description.  */
  char * output_arg;	/**< @brief Output file URI.  */
  char * output_orig;	/**< @brief Output file URI original value given at command line.  */
  const char *output_help; /**< @brief Output file URI help description.  */
  char * input_format_arg;	/**< @brief Force input file format.  */
  char * input_format_orig;	/**< @brief Force input file format original value given at command line.  */
  const char *input_format_help; /**< @brief Force input file format help description.  */
  char * output_format_arg;	/**< @brief Force output file format.  */
  char * output_format_orig;	/**< @brief Force output file format original value given at command line.  */
  const char *output_format_help; /**< @brief Force output file format help description.  */
  char * frame_length_arg;	/**< @brief Duration of the internal frames, TIME units.  */
  char * frame_length_orig;	/**< @brief Duration of the internal frames, TIME units original value given at command line.  */
  const char *frame_length_help; /**< @brief Duration of the internal frames, TIME units help description.  */
  int rate_arg;	/**< @brief Output sample rate, Hz.  */
  char * rate_orig;	/**< @brief Output sample rate, Hz original value given at command line.  */
  const char *rate_help; /**< @brief Output sample rate, Hz help description.  */
  enum enum_resampler_backend resampler_backend_arg;	/**< @brief Resampler backend (default='default').  */
  char * resampler_backend_orig;	/**< @brief Resampler backend original value given at command line.  */
  const char *resampler_backend_help; /**< @brief Resampler backend help description.  */
  enum enum_resampler_profile resampler_profile_arg;	/**< @brief Resampler profile (default='medium').  */
  char * resampler_profile_orig;	/**< @brief Resampler profile original value given at command line.  */
  const char *resampler_profile_help; /**< @brief Resampler profile help description.  */
  int profiling_flag;	/**< @brief Enable self profiling (default=off).  */
  const char *profiling_help; /**< @brief Enable self profiling help description.  */
  enum enum_color color_arg;	/**< @brief Set colored logging mode for stderr output (default='auto').  */
  char * color_orig;	/**< @brief Set colored logging mode for stderr output original value given at command line.  */
  const char *color_help; /**< @brief Set colored logging mode for stderr output help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int list_supported_given ;	/**< @brief Whether list-supported was given.  */
  unsigned int input_given ;	/**< @brief Whether input was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int input_format_given ;	/**< @brief Whether input-format was given.  */
  unsigned int output_format_given ;	/**< @brief Whether output-format was given.  */
  unsigned int frame_length_given ;	/**< @brief Whether frame-length was given.  */
  unsigned int rate_given ;	/**< @brief Whether rate was given.  */
  unsigned int resampler_backend_given ;	/**< @brief Whether resampler-backend was given.  */
  unsigned int resampler_profile_given ;	/**< @brief Whether resampler-profile was given.  */
  unsigned int profiling_given ;	/**< @brief Whether profiling was given.  */
  unsigned int color_given ;	/**< @brief Whether color was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_resampler_backend_values[];  /**< @brief Possible values for resampler-backend. */
extern const char *cmdline_parser_resampler_profile_values[];  /**< @brief Possible values for resampler-profile. */
extern const char *cmdline_parser_color_values[];  /**< @brief Possible values for color. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
