
#line 1 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
/*
 * Copyright (c) 2019 Roc Streaming authors
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "roc_address/endpoint_uri.h"
#include "roc_address/protocol_map.h"
#include "roc_core/log.h"
#include "roc_core/panic.h"

namespace roc {
namespace address {


#line 21 "build/src/x86_64-pc-linux-gnu/gcc-13.2.1-release/internal_modules/roc_address/endpoint_uri_parse.cpp"
static const char _parse_endpoint_uri_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 6, 2, 2, 0, 
	2, 2, 6, 2, 3, 0, 2, 3, 
	6, 2, 4, 6, 2, 5, 6, 3, 
	0, 5, 6, 3, 2, 5, 6, 3, 
	3, 5, 6, 3, 4, 5, 6, 4, 
	2, 0, 5, 6
};

static const char _parse_endpoint_uri_key_offsets[] = {
	0, 0, 6, 7, 8, 13, 15, 19, 
	23, 30, 36, 38, 40, 42, 46, 53, 
	60, 62, 66, 71
};

static const char _parse_endpoint_uri_trans_keys[] = {
	43, 58, 48, 57, 97, 122, 47, 47, 
	47, 58, 64, 91, 93, 48, 57, 47, 
	64, 91, 93, 47, 64, 91, 93, 43, 
	47, 63, 48, 57, 97, 122, 47, 58, 
	63, 64, 91, 93, 35, 63, 35, 63, 
	35, 63, 47, 63, 48, 57, 35, 47, 
	58, 63, 64, 91, 93, 35, 47, 58, 
	63, 64, 91, 93, 35, 63, 35, 63, 
	48, 57, 35, 47, 63, 48, 57, 47, 
	58, 63, 0
};

static const char _parse_endpoint_uri_single_lengths[] = {
	0, 2, 1, 1, 5, 0, 4, 4, 
	3, 6, 2, 2, 2, 2, 7, 7, 
	2, 2, 3, 3
};

static const char _parse_endpoint_uri_range_lengths[] = {
	0, 2, 0, 0, 0, 1, 0, 0, 
	2, 0, 0, 0, 0, 1, 0, 0, 
	0, 1, 1, 0
};

static const char _parse_endpoint_uri_index_offsets[] = {
	0, 0, 5, 7, 9, 15, 17, 22, 
	27, 33, 40, 43, 46, 49, 53, 61, 
	69, 72, 76, 81
};

static const char _parse_endpoint_uri_indicies[] = {
	0, 2, 0, 0, 1, 3, 1, 4, 
	1, 1, 1, 1, 6, 1, 5, 7, 
	1, 1, 1, 1, 1, 8, 1, 1, 
	1, 9, 8, 10, 11, 12, 10, 10, 
	1, 14, 15, 16, 1, 1, 1, 13, 
	1, 18, 17, 1, 1, 19, 1, 1, 
	20, 21, 23, 22, 1, 13, 25, 26, 
	16, 19, 19, 19, 24, 13, 25, 28, 
	16, 20, 20, 20, 27, 1, 18, 29, 
	1, 1, 30, 20, 1, 31, 23, 32, 
	20, 14, 15, 33, 1, 0
};

static const char _parse_endpoint_uri_trans_targs[] = {
	1, 0, 2, 3, 4, 9, 6, 13, 
	7, 19, 1, 10, 11, 9, 10, 5, 
	14, 10, 11, 12, 12, 10, 13, 11, 
	15, 16, 17, 15, 17, 16, 18, 16, 
	18, 11
};

static const char _parse_endpoint_uri_trans_actions[] = {
	0, 0, 3, 0, 0, 1, 1, 1, 
	0, 0, 1, 1, 0, 0, 13, 5, 
	5, 0, 9, 1, 0, 19, 0, 7, 
	1, 13, 13, 0, 5, 0, 1, 19, 
	0, 5
};

static const char _parse_endpoint_uri_eof_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	11, 16, 25, 31, 28, 22, 47, 35, 
	43, 28, 39, 16
};

static const int parse_endpoint_uri_start = 8;
static const int parse_endpoint_uri_first_final = 8;
static const int parse_endpoint_uri_error = 0;

static const int parse_endpoint_uri_en_main = 8;


#line 20 "src/internal_modules/roc_address/endpoint_uri_parse.rl"


namespace {

bool parse_endpoint_uri_imp(const char* str, EndpointUri::Subset subset, EndpointUri& result) {
    if (!str) {
        roc_log(LogError, "parse endpoint uri: input string is null");
        return false;
    }

    result.clear(subset);

    // for ragel
    const char* p = str;
    const char *pe = str + strlen(str);

    const char *eof = pe;
    int cs = 0;

    // for actions
    Protocol proto = Proto_None;
    const char* start_p = NULL;

    // parse result
    bool success = false;

    
#line 140 "build/src/x86_64-pc-linux-gnu/gcc-13.2.1-release/internal_modules/roc_address/endpoint_uri_parse.cpp"
	{
	cs = parse_endpoint_uri_start;
	}

#line 145 "build/src/x86_64-pc-linux-gnu/gcc-13.2.1-release/internal_modules/roc_address/endpoint_uri_parse.cpp"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _parse_endpoint_uri_trans_keys + _parse_endpoint_uri_key_offsets[cs];
	_trans = _parse_endpoint_uri_index_offsets[cs];

	_klen = _parse_endpoint_uri_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _parse_endpoint_uri_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _parse_endpoint_uri_indicies[_trans];
	cs = _parse_endpoint_uri_trans_targs[_trans];

	if ( _parse_endpoint_uri_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _parse_endpoint_uri_actions + _parse_endpoint_uri_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 47 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            start_p = p;
        }
	break;
	case 1:
#line 51 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            char scheme[16] = {};
            if (p - start_p >= sizeof(scheme)) {
                roc_log(LogError, "parse endpoint uri: invalid protocol");
                return false;
            }
            strncpy(scheme, start_p, p - start_p);

            const ProtocolAttrs* attrs = ProtocolMap::instance().find_by_scheme(scheme);
            if (!attrs) {
                roc_log(LogError, "parse endpoint uri: invalid protocol");
                return false;
            }

            if (!result.set_proto(attrs->protocol)) {
                roc_log(LogError, "parse endpoint uri: invalid protocol");
                return false;
            }
        }
	break;
	case 2:
#line 71 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (subset != EndpointUri::Subset_Full) {
                roc_log(LogError,
                        "parse endpoint uri: unexpected host when parsing resource");
                return false;
            }
            if (!result.set_host(start_p, p - start_p)) {
                roc_log(LogError, "parse endpoint uri: invalid host");
                return false;
            }
        }
	break;
	case 3:
#line 83 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (subset != EndpointUri::Subset_Full) {
                roc_log(LogError,
                        "parse endpoint uri: unexpected port when parsing resource");
                return false;
            }

            char* end_p = NULL;
            long port = strtol(start_p, &end_p, 10);

            if (port == LONG_MAX || port == LONG_MIN || end_p != p) {
                roc_log(LogError, "parse endpoint uri: invalid port");
                return false;
            }

            if (!result.set_port((int)port)) {
                roc_log(LogError, "parse endpoint uri: invalid port");
                return false;
            }
        }
	break;
	case 4:
#line 104 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (!result.set_encoded_path(start_p, p - start_p)) {
                roc_log(LogError, "parse endpoint uri: invalid path");
                return false;
            }
        }
	break;
#line 293 "build/src/x86_64-pc-linux-gnu/gcc-13.2.1-release/internal_modules/roc_address/endpoint_uri_parse.cpp"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _parse_endpoint_uri_actions + _parse_endpoint_uri_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 0:
#line 47 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            start_p = p;
        }
	break;
	case 2:
#line 71 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (subset != EndpointUri::Subset_Full) {
                roc_log(LogError,
                        "parse endpoint uri: unexpected host when parsing resource");
                return false;
            }
            if (!result.set_host(start_p, p - start_p)) {
                roc_log(LogError, "parse endpoint uri: invalid host");
                return false;
            }
        }
	break;
	case 3:
#line 83 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (subset != EndpointUri::Subset_Full) {
                roc_log(LogError,
                        "parse endpoint uri: unexpected port when parsing resource");
                return false;
            }

            char* end_p = NULL;
            long port = strtol(start_p, &end_p, 10);

            if (port == LONG_MAX || port == LONG_MIN || end_p != p) {
                roc_log(LogError, "parse endpoint uri: invalid port");
                return false;
            }

            if (!result.set_port((int)port)) {
                roc_log(LogError, "parse endpoint uri: invalid port");
                return false;
            }
        }
	break;
	case 4:
#line 104 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (!result.set_encoded_path(start_p, p - start_p)) {
                roc_log(LogError, "parse endpoint uri: invalid path");
                return false;
            }
        }
	break;
	case 5:
#line 111 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{
            if (!result.set_encoded_query(start_p, p - start_p)) {
                roc_log(LogError, "parse endpoint uri: invalid query");
                return false;
            }
        }
	break;
	case 6:
#line 131 "src/internal_modules/roc_address/endpoint_uri_parse.rl"
	{ success = true; }
	break;
#line 374 "build/src/x86_64-pc-linux-gnu/gcc-13.2.1-release/internal_modules/roc_address/endpoint_uri_parse.cpp"
		}
	}
	}

	_out: {}
	}

#line 136 "src/internal_modules/roc_address/endpoint_uri_parse.rl"


    if (!success) {
        if (subset == EndpointUri::Subset_Full) {
            roc_log(LogError,
                    "parse endpoint uri: expected"
                    " 'PROTO://HOST[:PORT][/PATH][?QUERY]',\n"
                    " got '%s'",
                    str);
        } else {
            roc_log(LogError,
                    "parse endpoint uri: expected"
                    " '[/PATH][?QUERY]',\n"
                    " got '%s'",
                    str);
        }
        return false;
    }

    if (!result.verify(subset)) {
        roc_log(LogError, "parse endpoint uri: invalud uri");
        return false;
    }

    return true;
}

} // namespace

bool parse_endpoint_uri(const char* str, EndpointUri::Subset subset, EndpointUri& result) {
    if (!parse_endpoint_uri_imp(str, subset, result)) {
        result.invalidate(subset);
        return false;
    }
    return true;
}

} // namespace address
} // namespace roc
