#include "ink_stroke_modeler/types.h"
#include "ink_stroke_modeler/params.h"
#include "ink_stroke_modeler/stroke_modeler.h"
#include "extras.h"
#include "autocxxgen_ffi.h"
#include <array>
#include <cstddef>
#include <cstdint>
#include <memory>
#include <new>
#include <string>
#include <type_traits>
#include <utility>
#include <vector>

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

namespace {
template <typename T>
class impl;
} // namespace

class String;

#ifndef CXXBRIDGE1_RUST_STR
#define CXXBRIDGE1_RUST_STR
class Str final {
public:
  Str() noexcept;
  Str(const String &) noexcept;
  Str(const std::string &);
  Str(const char *);
  Str(const char *, std::size_t);

  Str &operator=(const Str &) &noexcept = default;

  explicit operator std::string() const;

  const char *data() const noexcept;
  std::size_t size() const noexcept;
  std::size_t length() const noexcept;
  bool empty() const noexcept;

  Str(const Str &) noexcept = default;
  ~Str() noexcept = default;

  using iterator = const char *;
  using const_iterator = const char *;
  const_iterator begin() const noexcept;
  const_iterator end() const noexcept;
  const_iterator cbegin() const noexcept;
  const_iterator cend() const noexcept;

  bool operator==(const Str &) const noexcept;
  bool operator!=(const Str &) const noexcept;
  bool operator<(const Str &) const noexcept;
  bool operator<=(const Str &) const noexcept;
  bool operator>(const Str &) const noexcept;
  bool operator>=(const Str &) const noexcept;

  void swap(Str &) noexcept;

private:
  class uninit;
  Str(uninit) noexcept;
  friend impl<Str>;

  std::array<std::uintptr_t, 2> repr;
};
#endif // CXXBRIDGE1_RUST_STR

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

#ifndef CXXBRIDGE1_RELOCATABLE
#define CXXBRIDGE1_RELOCATABLE
namespace detail {
template <typename... Ts>
struct make_void {
  using type = void;
};

template <typename... Ts>
using void_t = typename make_void<Ts...>::type;

template <typename Void, template <typename...> class, typename...>
struct detect : std::false_type {};
template <template <typename...> class T, typename... A>
struct detect<void_t<T<A...>>, T, A...> : std::true_type {};

template <template <typename...> class T, typename... A>
using is_detected = detect<void, T, A...>;

template <typename T>
using detect_IsRelocatable = typename T::IsRelocatable;

template <typename T>
struct get_IsRelocatable
    : std::is_same<typename T::IsRelocatable, std::true_type> {};
} // namespace detail

template <typename T>
struct IsRelocatable
    : std::conditional<
          detail::is_detected<detail::detect_IsRelocatable, T>::value,
          detail::get_IsRelocatable<T>,
          std::integral_constant<
              bool, std::is_trivially_move_constructible<T>::value &&
                        std::is_trivially_destructible<T>::value>>::type {};
#endif // CXXBRIDGE1_RELOCATABLE

namespace detail {
template <typename T, typename = void *>
struct operator_new {
  void *operator()(::std::size_t sz) { return ::operator new(sz); }
};

template <typename T>
struct operator_new<T, decltype(T::operator new(sizeof(T)))> {
  void *operator()(::std::size_t sz) { return T::operator new(sz); }
};
} // namespace detail

template <typename T>
union MaybeUninit {
  T value;
  void *operator new(::std::size_t sz) { return detail::operator_new<T>{}(sz); }
  MaybeUninit() {}
  ~MaybeUninit() {}
};

namespace {
template <typename T>
void destroy(T *ptr) {
  ptr->~T();
}

template <bool> struct deleter_if {
  template <typename T> void operator()(T *) {}
};

template <> struct deleter_if<true> {
  template <typename T> void operator()(T *ptr) { ptr->~T(); }
};
} // namespace
} // namespace cxxbridge1
} // namespace rust

static_assert(
    ::rust::IsRelocatable<::ink::stroke_model::Vec2>::value,
    "type ink::stroke_model::Vec2 should be trivially move constructible and trivially destructible in C++ to be used as an argument of `input_new_autocxx_wrapper_0x2bea8d22859dde10` or return value of `input_get_position`, `result_get_position`, `result_get_velocity` in Rust");
static_assert(
    ::rust::IsRelocatable<::ink::stroke_model::Input::EventType>::value,
    "type ink::stroke_model::Input::EventType should be trivially move constructible and trivially destructible in C++ to be used as an argument of `input_new_autocxx_wrapper_0x2bea8d22859dde10` or return value of `input_get_event_type` in Rust");
static_assert(
    ::rust::IsRelocatable<::BdWobbleSmootherParams>::value,
    "type BdWobbleSmootherParams should be trivially move constructible and trivially destructible in C++ to be used as an argument of `bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10` in Rust");
static_assert(
    ::rust::IsRelocatable<::BdPositionModelerParams>::value,
    "type BdPositionModelerParams should be trivially move constructible and trivially destructible in C++ to be used as an argument of `bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10` in Rust");
static_assert(
    ::rust::IsRelocatable<::BdSamplingParams>::value,
    "type BdSamplingParams should be trivially move constructible and trivially destructible in C++ to be used as an argument of `bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10` in Rust");
static_assert(
    ::rust::IsRelocatable<::BdStylusStateModelerParams>::value,
    "type BdStylusStateModelerParams should be trivially move constructible and trivially destructible in C++ to be used as an argument of `bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10`, `bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10` in Rust");
static_assert(
    ::rust::IsRelocatable<::BdKalmanPredictorParams>::value,
    "type BdKalmanPredictorParams should be trivially move constructible and trivially destructible in C++ to be used as an argument of `bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10` in Rust");
static_assert(
    ::rust::IsRelocatable<::c_int>::value,
    "type c_int should be trivially move constructible and trivially destructible in C++ to be used as a return value of `stroke_modeler_reset`, `stroke_modeler_reset_w_params_autocxx_wrapper_0x2bea8d22859dde10`, `stroke_modeler_update_autocxx_wrapper_0x2bea8d22859dde10` in Rust");

extern "C" {
::std::string *cxxbridge1$autocxx_make_string_0x2bea8d22859dde10(::rust::Str str_) noexcept {
  ::std::unique_ptr<::std::string> (*autocxx_make_string_0x2bea8d22859dde10$)(::rust::Str) = ::autocxx_make_string_0x2bea8d22859dde10;
  return autocxx_make_string_0x2bea8d22859dde10$(str_).release();
}

::ink::stroke_model::Vec2 *cxxbridge1$Vec2_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::ink::stroke_model::Vec2 *(*Vec2_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::Vec2_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return Vec2_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$Vec2_free_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Vec2 *arg0) noexcept {
  void (*Vec2_free_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Vec2 *) = ::Vec2_free_autocxx_wrapper_0x2bea8d22859dde10;
  Vec2_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::ink::stroke_model::Input *cxxbridge1$Input_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::ink::stroke_model::Input *(*Input_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::Input_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return Input_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$Input_free_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Input *arg0) noexcept {
  void (*Input_free_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Input *) = ::Input_free_autocxx_wrapper_0x2bea8d22859dde10;
  Input_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::ink::stroke_model::Result *cxxbridge1$Result_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::ink::stroke_model::Result *(*Result_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::Result_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return Result_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$Result_free_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Result *arg0) noexcept {
  void (*Result_free_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Result *) = ::Result_free_autocxx_wrapper_0x2bea8d22859dde10;
  Result_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::ink::stroke_model::StrokeModeler *cxxbridge1$StrokeModeler_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::ink::stroke_model::StrokeModeler *(*StrokeModeler_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::StrokeModeler_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return StrokeModeler_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$StrokeModeler_free_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler *arg0) noexcept {
  void (*StrokeModeler_free_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler *) = ::StrokeModeler_free_autocxx_wrapper_0x2bea8d22859dde10;
  StrokeModeler_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}
} // extern "C"

namespace ink {
namespace stroke_model {
extern "C" {
float ink$stroke_model$cxxbridge1$Vec2$Magnitude(::ink::stroke_model::Vec2 const &self) noexcept {
  float (::ink::stroke_model::Vec2::*Magnitude$)() const = &::ink::stroke_model::Vec2::Magnitude;
  return (self.*Magnitude$)();
}
} // extern "C"
} // namespace stroke_model
} // namespace ink

extern "C" {
void cxxbridge1$ink_stroke_model_StrokeModeler_Reset_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &autocxx_gen_this, ::ink::stroke_model::StrokeModelParams const &stroke_model_params, ::absl::lts_20230802::Status *placement_return_type) noexcept {
  void (*ink_stroke_model_StrokeModeler_Reset_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &, ::ink::stroke_model::StrokeModelParams const &, ::absl::lts_20230802::Status *) = ::ink_stroke_model_StrokeModeler_Reset_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_StrokeModeler_Reset_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, stroke_model_params, placement_return_type);
}

void cxxbridge1$Reset1_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &autocxx_gen_this, ::absl::lts_20230802::Status *placement_return_type) noexcept {
  void (*Reset1_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &, ::absl::lts_20230802::Status *) = ::Reset1_autocxx_wrapper_0x2bea8d22859dde10;
  Reset1_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, placement_return_type);
}

void cxxbridge1$ink_stroke_model_StrokeModeler_Update_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &autocxx_gen_this, ::ink::stroke_model::Input const &input, ::std::vector<::ink::stroke_model::Result> &results, ::absl::lts_20230802::Status *placement_return_type) noexcept {
  void (*ink_stroke_model_StrokeModeler_Update_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &, ::ink::stroke_model::Input const &, ::std::vector<::ink::stroke_model::Result> &, ::absl::lts_20230802::Status *) = ::ink_stroke_model_StrokeModeler_Update_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_StrokeModeler_Update_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, input, results, placement_return_type);
}

void cxxbridge1$Predict_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &autocxx_gen_this, ::std::vector<::ink::stroke_model::Result> &results, ::absl::lts_20230802::Status *placement_return_type) noexcept {
  void (*Predict_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &, ::std::vector<::ink::stroke_model::Result> &, ::absl::lts_20230802::Status *) = ::Predict_autocxx_wrapper_0x2bea8d22859dde10;
  Predict_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, results, placement_return_type);
}

void cxxbridge1$ink_stroke_model_StrokeModeler_Save_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &autocxx_gen_this) noexcept {
  void (*ink_stroke_model_StrokeModeler_Save_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &) = ::ink_stroke_model_StrokeModeler_Save_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_StrokeModeler_Save_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$ink_stroke_model_StrokeModeler_Restore_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &autocxx_gen_this) noexcept {
  void (*ink_stroke_model_StrokeModeler_Restore_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &) = ::ink_stroke_model_StrokeModeler_Restore_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_StrokeModeler_Restore_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

::BdWobbleSmootherParams *cxxbridge1$BdWobbleSmootherParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdWobbleSmootherParams *(*BdWobbleSmootherParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdWobbleSmootherParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdWobbleSmootherParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdWobbleSmootherParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *arg0) noexcept {
  void (*BdWobbleSmootherParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams *) = ::BdWobbleSmootherParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdWobbleSmootherParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::BdPositionModelerParams *cxxbridge1$BdPositionModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdPositionModelerParams *(*BdPositionModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdPositionModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdPositionModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdPositionModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdPositionModelerParams *arg0) noexcept {
  void (*BdPositionModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdPositionModelerParams *) = ::BdPositionModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdPositionModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::BdSamplingParams *cxxbridge1$BdSamplingParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdSamplingParams *(*BdSamplingParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdSamplingParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdSamplingParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdSamplingParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdSamplingParams *arg0) noexcept {
  void (*BdSamplingParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdSamplingParams *) = ::BdSamplingParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdSamplingParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::BdStylusStateModelerParams *cxxbridge1$BdStylusStateModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdStylusStateModelerParams *(*BdStylusStateModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdStylusStateModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdStylusStateModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdStylusStateModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdStylusStateModelerParams *arg0) noexcept {
  void (*BdStylusStateModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStylusStateModelerParams *) = ::BdStylusStateModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdStylusStateModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::BdKalmanPredictorConfidenceParams *cxxbridge1$BdKalmanPredictorConfidenceParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdKalmanPredictorConfidenceParams *(*BdKalmanPredictorConfidenceParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdKalmanPredictorConfidenceParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdKalmanPredictorConfidenceParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdKalmanPredictorConfidenceParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorConfidenceParams *arg0) noexcept {
  void (*BdKalmanPredictorConfidenceParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorConfidenceParams *) = ::BdKalmanPredictorConfidenceParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorConfidenceParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::BdKalmanPredictorParams *cxxbridge1$BdKalmanPredictorParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdKalmanPredictorParams *(*BdKalmanPredictorParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdKalmanPredictorParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdKalmanPredictorParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdKalmanPredictorParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorParams *arg0) noexcept {
  void (*BdKalmanPredictorParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorParams *) = ::BdKalmanPredictorParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

::BdStrokeModelParams *cxxbridge1$BdStrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::BdStrokeModelParams *(*BdStrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::BdStrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return BdStrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$BdStrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10(::BdStrokeModelParams *arg0) noexcept {
  void (*BdStrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStrokeModelParams *) = ::BdStrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  BdStrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

void cxxbridge1$bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *wobble_smoother_params, ::BdPositionModelerParams *position_modeler_params, ::BdSamplingParams *sampling_params, ::BdStylusStateModelerParams *stylus_state_modeler_params, ::BdStrokeModelParams *placement_return_type) noexcept {
  void (*bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams, ::BdPositionModelerParams, ::BdSamplingParams, ::BdStylusStateModelerParams, ::BdStrokeModelParams *) = ::bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10;
  bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10$(::std::move(*wobble_smoother_params), ::std::move(*position_modeler_params), ::std::move(*sampling_params), ::std::move(*stylus_state_modeler_params), placement_return_type);
}

void cxxbridge1$bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *wobble_smoother_params, ::BdPositionModelerParams *position_modeler_params, ::BdSamplingParams *sampling_params, ::BdStylusStateModelerParams *stylus_state_modeler_params, ::BdKalmanPredictorParams *kalman_predictor_params, ::BdStrokeModelParams *placement_return_type) noexcept {
  void (*bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams, ::BdPositionModelerParams, ::BdSamplingParams, ::BdStylusStateModelerParams, ::BdKalmanPredictorParams, ::BdStrokeModelParams *) = ::bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10;
  bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10$(::std::move(*wobble_smoother_params), ::std::move(*position_modeler_params), ::std::move(*sampling_params), ::std::move(*stylus_state_modeler_params), ::std::move(*kalman_predictor_params), placement_return_type);
}

void cxxbridge1$bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *wobble_smoother_params, ::BdPositionModelerParams *position_modeler_params, ::BdSamplingParams *sampling_params, ::BdStylusStateModelerParams *stylus_state_modeler_params, ::BdStrokeModelParams *placement_return_type) noexcept {
  void (*bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams, ::BdPositionModelerParams, ::BdSamplingParams, ::BdStylusStateModelerParams, ::BdStrokeModelParams *) = ::bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10;
  bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10$(::std::move(*wobble_smoother_params), ::std::move(*position_modeler_params), ::std::move(*sampling_params), ::std::move(*stylus_state_modeler_params), placement_return_type);
}

void cxxbridge1$stroke_modeler_new_autocxx_wrapper_0x2bea8d22859dde10(::BdStrokeModelParams *bd_params, ::ink::stroke_model::StrokeModeler *placement_return_type) noexcept {
  void (*stroke_modeler_new_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStrokeModelParams *, ::ink::stroke_model::StrokeModeler *) = ::stroke_modeler_new_autocxx_wrapper_0x2bea8d22859dde10;
  stroke_modeler_new_autocxx_wrapper_0x2bea8d22859dde10$(bd_params, placement_return_type);
}

void cxxbridge1$stroke_modeler_reset(::ink::stroke_model::StrokeModeler &stroke_modeler, ::c_int *return$) noexcept {
  ::c_int (*stroke_modeler_reset$)(::ink::stroke_model::StrokeModeler &) = ::stroke_modeler_reset;
  new (return$) ::c_int(stroke_modeler_reset$(stroke_modeler));
}

void cxxbridge1$stroke_modeler_reset_w_params_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &stroke_modeler, ::BdStrokeModelParams *bd_params, ::c_int *return$) noexcept {
  ::c_int (*stroke_modeler_reset_w_params_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &, ::BdStrokeModelParams *) = ::stroke_modeler_reset_w_params_autocxx_wrapper_0x2bea8d22859dde10;
  new (return$) ::c_int(stroke_modeler_reset_w_params_autocxx_wrapper_0x2bea8d22859dde10$(stroke_modeler, bd_params));
}

void cxxbridge1$stroke_modeler_update_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler &stroke_modeler, ::ink::stroke_model::Input *input, ::std::vector<::ink::stroke_model::Result> &modeler_results, ::c_int *return$) noexcept {
  ::c_int (*stroke_modeler_update_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler &, ::ink::stroke_model::Input *, ::std::vector<::ink::stroke_model::Result> &) = ::stroke_modeler_update_autocxx_wrapper_0x2bea8d22859dde10;
  new (return$) ::c_int(stroke_modeler_update_autocxx_wrapper_0x2bea8d22859dde10$(stroke_modeler, input, modeler_results));
}

void cxxbridge1$stroke_modeler_predict(::ink::stroke_model::StrokeModeler &stroke_modeler, ::std::vector<::ink::stroke_model::Result> &modeler_results, ::c_int *return$) noexcept {
  ::c_int (*stroke_modeler_predict$)(::ink::stroke_model::StrokeModeler &, ::std::vector<::ink::stroke_model::Result> &) = ::stroke_modeler_predict;
  new (return$) ::c_int(stroke_modeler_predict$(stroke_modeler, modeler_results));
}

void cxxbridge1$input_new_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Input::EventType *event_type, ::ink::stroke_model::Vec2 *pos, double time, float pressure, float tilt, float orientation, ::ink::stroke_model::Input *placement_return_type) noexcept {
  void (*input_new_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Input::EventType, ::ink::stroke_model::Vec2, double, float, float, float, ::ink::stroke_model::Input *) = ::input_new_autocxx_wrapper_0x2bea8d22859dde10;
  input_new_autocxx_wrapper_0x2bea8d22859dde10$(::std::move(*event_type), ::std::move(*pos), time, pressure, tilt, orientation, placement_return_type);
}

void cxxbridge1$input_get_event_type(::ink::stroke_model::Input const &input, ::ink::stroke_model::Input::EventType *return$) noexcept {
  ::ink::stroke_model::Input::EventType (*input_get_event_type$)(::ink::stroke_model::Input const &) = ::input_get_event_type;
  new (return$) ::ink::stroke_model::Input::EventType(input_get_event_type$(input));
}

void cxxbridge1$input_get_position(::ink::stroke_model::Input const &input, ::ink::stroke_model::Vec2 *return$) noexcept {
  ::ink::stroke_model::Vec2 (*input_get_position$)(::ink::stroke_model::Input const &) = ::input_get_position;
  new (return$) ::ink::stroke_model::Vec2(input_get_position$(input));
}

double cxxbridge1$input_get_time(::ink::stroke_model::Input const &input) noexcept {
  double (*input_get_time$)(::ink::stroke_model::Input const &) = ::input_get_time;
  return input_get_time$(input);
}

float cxxbridge1$input_get_pressure(::ink::stroke_model::Input const &input) noexcept {
  float (*input_get_pressure$)(::ink::stroke_model::Input const &) = ::input_get_pressure;
  return input_get_pressure$(input);
}

float cxxbridge1$input_get_tilt(::ink::stroke_model::Input const &input) noexcept {
  float (*input_get_tilt$)(::ink::stroke_model::Input const &) = ::input_get_tilt;
  return input_get_tilt$(input);
}

float cxxbridge1$input_get_orientation(::ink::stroke_model::Input const &input) noexcept {
  float (*input_get_orientation$)(::ink::stroke_model::Input const &) = ::input_get_orientation;
  return input_get_orientation$(input);
}

::std::vector<::ink::stroke_model::Result> *cxxbridge1$results_new_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::std::unique_ptr<::std::vector<::ink::stroke_model::Result>> (*results_new_autocxx_wrapper_0x2bea8d22859dde10$)() = ::results_new_autocxx_wrapper_0x2bea8d22859dde10;
  return results_new_autocxx_wrapper_0x2bea8d22859dde10$().release();
}

::ink::stroke_model::Result *cxxbridge1$result_make_unique_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Result *result) noexcept {
  ::std::unique_ptr<::ink::stroke_model::Result> (*result_make_unique_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Result *) = ::result_make_unique_autocxx_wrapper_0x2bea8d22859dde10;
  return result_make_unique_autocxx_wrapper_0x2bea8d22859dde10$(result).release();
}

void cxxbridge1$result_get_position(::ink::stroke_model::Result const &result, ::ink::stroke_model::Vec2 *return$) noexcept {
  ::ink::stroke_model::Vec2 (*result_get_position$)(::ink::stroke_model::Result const &) = ::result_get_position;
  new (return$) ::ink::stroke_model::Vec2(result_get_position$(result));
}

void cxxbridge1$result_get_velocity(::ink::stroke_model::Result const &result, ::ink::stroke_model::Vec2 *return$) noexcept {
  ::ink::stroke_model::Vec2 (*result_get_velocity$)(::ink::stroke_model::Result const &) = ::result_get_velocity;
  new (return$) ::ink::stroke_model::Vec2(result_get_velocity$(result));
}

double cxxbridge1$result_get_time(::ink::stroke_model::Result const &result) noexcept {
  double (*result_get_time$)(::ink::stroke_model::Result const &) = ::result_get_time;
  return result_get_time$(result);
}

float cxxbridge1$result_get_pressure(::ink::stroke_model::Result const &result) noexcept {
  float (*result_get_pressure$)(::ink::stroke_model::Result const &) = ::result_get_pressure;
  return result_get_pressure$(result);
}

float cxxbridge1$result_get_tilt(::ink::stroke_model::Result const &result) noexcept {
  float (*result_get_tilt$)(::ink::stroke_model::Result const &) = ::result_get_tilt;
  return result_get_tilt$(result);
}

float cxxbridge1$result_get_orientation(::ink::stroke_model::Result const &result) noexcept {
  float (*result_get_orientation$)(::ink::stroke_model::Result const &) = ::result_get_orientation;
  return result_get_orientation$(result);
}

void cxxbridge1$ink_stroke_model_Vec2_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Vec2 *autocxx_gen_this) noexcept {
  void (*ink_stroke_model_Vec2_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Vec2 *) = ::ink_stroke_model_Vec2_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Vec2_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$ink_stroke_model_Vec2_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Vec2 *autocxx_gen_this, ::ink::stroke_model::Vec2 *other) noexcept {
  void (*ink_stroke_model_Vec2_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Vec2 *, ::ink::stroke_model::Vec2 *) = ::ink_stroke_model_Vec2_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Vec2_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$ink_stroke_model_Vec2_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Vec2 *autocxx_gen_this, ::ink::stroke_model::Vec2 const &other) noexcept {
  void (*ink_stroke_model_Vec2_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Vec2 *, ::ink::stroke_model::Vec2 const &) = ::ink_stroke_model_Vec2_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Vec2_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$Vec2_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Vec2 *autocxx_gen_this) noexcept {
  void (*Vec2_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Vec2 *) = ::Vec2_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  Vec2_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$ink_stroke_model_Result_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Result *autocxx_gen_this) noexcept {
  void (*ink_stroke_model_Result_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Result *) = ::ink_stroke_model_Result_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Result_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$ink_stroke_model_Result_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Result *autocxx_gen_this, ::ink::stroke_model::Result *other) noexcept {
  void (*ink_stroke_model_Result_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Result *, ::ink::stroke_model::Result *) = ::ink_stroke_model_Result_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Result_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$ink_stroke_model_Result_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Result *autocxx_gen_this, ::ink::stroke_model::Result const &other) noexcept {
  void (*ink_stroke_model_Result_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Result *, ::ink::stroke_model::Result const &) = ::ink_stroke_model_Result_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Result_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$Result_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Result *autocxx_gen_this) noexcept {
  void (*Result_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Result *) = ::Result_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  Result_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdWobbleSmootherParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *autocxx_gen_this) noexcept {
  void (*BdWobbleSmootherParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams *) = ::BdWobbleSmootherParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdWobbleSmootherParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdWobbleSmootherParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *autocxx_gen_this, ::BdWobbleSmootherParams *other) noexcept {
  void (*BdWobbleSmootherParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams *, ::BdWobbleSmootherParams *) = ::BdWobbleSmootherParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdWobbleSmootherParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdWobbleSmootherParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *autocxx_gen_this, ::BdWobbleSmootherParams const &other) noexcept {
  void (*BdWobbleSmootherParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams *, ::BdWobbleSmootherParams const &) = ::BdWobbleSmootherParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdWobbleSmootherParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdWobbleSmootherParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdWobbleSmootherParams *autocxx_gen_this) noexcept {
  void (*BdWobbleSmootherParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdWobbleSmootherParams *) = ::BdWobbleSmootherParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdWobbleSmootherParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdPositionModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdPositionModelerParams *autocxx_gen_this) noexcept {
  void (*BdPositionModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdPositionModelerParams *) = ::BdPositionModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdPositionModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdPositionModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdPositionModelerParams *autocxx_gen_this, ::BdPositionModelerParams *other) noexcept {
  void (*BdPositionModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdPositionModelerParams *, ::BdPositionModelerParams *) = ::BdPositionModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdPositionModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdPositionModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdPositionModelerParams *autocxx_gen_this, ::BdPositionModelerParams const &other) noexcept {
  void (*BdPositionModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdPositionModelerParams *, ::BdPositionModelerParams const &) = ::BdPositionModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdPositionModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdPositionModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdPositionModelerParams *autocxx_gen_this) noexcept {
  void (*BdPositionModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdPositionModelerParams *) = ::BdPositionModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdPositionModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdSamplingParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdSamplingParams *autocxx_gen_this) noexcept {
  void (*BdSamplingParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdSamplingParams *) = ::BdSamplingParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdSamplingParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdSamplingParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdSamplingParams *autocxx_gen_this, ::BdSamplingParams *other) noexcept {
  void (*BdSamplingParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdSamplingParams *, ::BdSamplingParams *) = ::BdSamplingParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdSamplingParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdSamplingParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdSamplingParams *autocxx_gen_this, ::BdSamplingParams const &other) noexcept {
  void (*BdSamplingParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdSamplingParams *, ::BdSamplingParams const &) = ::BdSamplingParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdSamplingParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdSamplingParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdSamplingParams *autocxx_gen_this) noexcept {
  void (*BdSamplingParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdSamplingParams *) = ::BdSamplingParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdSamplingParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdStylusStateModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdStylusStateModelerParams *autocxx_gen_this) noexcept {
  void (*BdStylusStateModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStylusStateModelerParams *) = ::BdStylusStateModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdStylusStateModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdStylusStateModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdStylusStateModelerParams *autocxx_gen_this, ::BdStylusStateModelerParams *other) noexcept {
  void (*BdStylusStateModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStylusStateModelerParams *, ::BdStylusStateModelerParams *) = ::BdStylusStateModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdStylusStateModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdStylusStateModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdStylusStateModelerParams *autocxx_gen_this, ::BdStylusStateModelerParams const &other) noexcept {
  void (*BdStylusStateModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStylusStateModelerParams *, ::BdStylusStateModelerParams const &) = ::BdStylusStateModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdStylusStateModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdStylusStateModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdStylusStateModelerParams *autocxx_gen_this) noexcept {
  void (*BdStylusStateModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStylusStateModelerParams *) = ::BdStylusStateModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdStylusStateModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdKalmanPredictorConfidenceParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorConfidenceParams *autocxx_gen_this) noexcept {
  void (*BdKalmanPredictorConfidenceParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorConfidenceParams *) = ::BdKalmanPredictorConfidenceParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorConfidenceParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdKalmanPredictorConfidenceParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorConfidenceParams *autocxx_gen_this, ::BdKalmanPredictorConfidenceParams *other) noexcept {
  void (*BdKalmanPredictorConfidenceParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorConfidenceParams *, ::BdKalmanPredictorConfidenceParams *) = ::BdKalmanPredictorConfidenceParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorConfidenceParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdKalmanPredictorConfidenceParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorConfidenceParams *autocxx_gen_this, ::BdKalmanPredictorConfidenceParams const &other) noexcept {
  void (*BdKalmanPredictorConfidenceParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorConfidenceParams *, ::BdKalmanPredictorConfidenceParams const &) = ::BdKalmanPredictorConfidenceParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorConfidenceParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdKalmanPredictorConfidenceParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorConfidenceParams *autocxx_gen_this) noexcept {
  void (*BdKalmanPredictorConfidenceParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorConfidenceParams *) = ::BdKalmanPredictorConfidenceParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorConfidenceParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdKalmanPredictorParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorParams *autocxx_gen_this) noexcept {
  void (*BdKalmanPredictorParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorParams *) = ::BdKalmanPredictorParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdKalmanPredictorParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorParams *autocxx_gen_this, ::BdKalmanPredictorParams *other) noexcept {
  void (*BdKalmanPredictorParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorParams *, ::BdKalmanPredictorParams *) = ::BdKalmanPredictorParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdKalmanPredictorParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorParams *autocxx_gen_this, ::BdKalmanPredictorParams const &other) noexcept {
  void (*BdKalmanPredictorParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorParams *, ::BdKalmanPredictorParams const &) = ::BdKalmanPredictorParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdKalmanPredictorParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdKalmanPredictorParams *autocxx_gen_this) noexcept {
  void (*BdKalmanPredictorParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdKalmanPredictorParams *) = ::BdKalmanPredictorParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdKalmanPredictorParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdStrokeModelParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(::BdStrokeModelParams *autocxx_gen_this) noexcept {
  void (*BdStrokeModelParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStrokeModelParams *) = ::BdStrokeModelParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10;
  BdStrokeModelParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$BdStrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdStrokeModelParams *autocxx_gen_this, ::BdStrokeModelParams *other) noexcept {
  void (*BdStrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStrokeModelParams *, ::BdStrokeModelParams *) = ::BdStrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdStrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdStrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdStrokeModelParams *autocxx_gen_this, ::BdStrokeModelParams const &other) noexcept {
  void (*BdStrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStrokeModelParams *, ::BdStrokeModelParams const &) = ::BdStrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdStrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$BdStrokeModelParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::BdStrokeModelParams *autocxx_gen_this) noexcept {
  void (*BdStrokeModelParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::BdStrokeModelParams *) = ::BdStrokeModelParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  BdStrokeModelParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$ink_stroke_model_Input_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Input *autocxx_gen_this, ::ink::stroke_model::Input *other) noexcept {
  void (*ink_stroke_model_Input_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Input *, ::ink::stroke_model::Input *) = ::ink_stroke_model_Input_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Input_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$ink_stroke_model_Input_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Input *autocxx_gen_this, ::ink::stroke_model::Input const &other) noexcept {
  void (*ink_stroke_model_Input_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Input *, ::ink::stroke_model::Input const &) = ::ink_stroke_model_Input_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_Input_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$Input_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::Input *autocxx_gen_this) noexcept {
  void (*Input_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::Input *) = ::Input_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  Input_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

void cxxbridge1$StrokeModeler_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModeler *autocxx_gen_this) noexcept {
  void (*StrokeModeler_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModeler *) = ::StrokeModeler_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  StrokeModeler_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this);
}

::ink::stroke_model::StrokeModelParams *cxxbridge1$StrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::ink::stroke_model::StrokeModelParams *(*StrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::StrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return StrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$StrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModelParams *arg0) noexcept {
  void (*StrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModelParams *) = ::StrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10;
  StrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

void cxxbridge1$ink_stroke_model_StrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModelParams *autocxx_gen_this, ::ink::stroke_model::StrokeModelParams *other) noexcept {
  void (*ink_stroke_model_StrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModelParams *, ::ink::stroke_model::StrokeModelParams *) = ::ink_stroke_model_StrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_StrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

void cxxbridge1$ink_stroke_model_StrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(::ink::stroke_model::StrokeModelParams *autocxx_gen_this, ::ink::stroke_model::StrokeModelParams const &other) noexcept {
  void (*ink_stroke_model_StrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$)(::ink::stroke_model::StrokeModelParams *, ::ink::stroke_model::StrokeModelParams const &) = ::ink_stroke_model_StrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10;
  ink_stroke_model_StrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, other);
}

::absl::lts_20230802::Status *cxxbridge1$Status_alloc_autocxx_wrapper_0x2bea8d22859dde10() noexcept {
  ::absl::lts_20230802::Status *(*Status_alloc_autocxx_wrapper_0x2bea8d22859dde10$)() = ::Status_alloc_autocxx_wrapper_0x2bea8d22859dde10;
  return Status_alloc_autocxx_wrapper_0x2bea8d22859dde10$();
}

void cxxbridge1$Status_free_autocxx_wrapper_0x2bea8d22859dde10(::absl::lts_20230802::Status *arg0) noexcept {
  void (*Status_free_autocxx_wrapper_0x2bea8d22859dde10$)(::absl::lts_20230802::Status *) = ::Status_free_autocxx_wrapper_0x2bea8d22859dde10;
  Status_free_autocxx_wrapper_0x2bea8d22859dde10$(arg0);
}

void cxxbridge1$absl_lts_20230802_Status_new2_autocxx_wrapper_0x2bea8d22859dde10(::absl::lts_20230802::Status *autocxx_gen_this, ::absl::lts_20230802::Status const &arg1) noexcept {
  void (*absl_lts_20230802_Status_new2_autocxx_wrapper_0x2bea8d22859dde10$)(::absl::lts_20230802::Status *, ::absl::lts_20230802::Status const &) = ::absl_lts_20230802_Status_new2_autocxx_wrapper_0x2bea8d22859dde10;
  absl_lts_20230802_Status_new2_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, arg1);
}

void cxxbridge1$absl_lts_20230802_Status_new3_autocxx_wrapper_0x2bea8d22859dde10(::absl::lts_20230802::Status *autocxx_gen_this, ::absl::lts_20230802::Status *arg1) noexcept {
  void (*absl_lts_20230802_Status_new3_autocxx_wrapper_0x2bea8d22859dde10$)(::absl::lts_20230802::Status *, ::absl::lts_20230802::Status *) = ::absl_lts_20230802_Status_new3_autocxx_wrapper_0x2bea8d22859dde10;
  absl_lts_20230802_Status_new3_autocxx_wrapper_0x2bea8d22859dde10$(autocxx_gen_this, arg1);
}

static_assert(::rust::detail::is_complete<::ink::stroke_model::Vec2>::value, "definition of Vec2 is required");
static_assert(sizeof(::std::unique_ptr<::ink::stroke_model::Vec2>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::ink::stroke_model::Vec2>) == alignof(void *), "");
void cxxbridge1$unique_ptr$ink$stroke_model$Vec2$null(::std::unique_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Vec2>();
}
::ink::stroke_model::Vec2 *cxxbridge1$unique_ptr$ink$stroke_model$Vec2$uninit(::std::unique_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::ink::stroke_model::Vec2 *uninit = reinterpret_cast<::ink::stroke_model::Vec2 *>(new ::rust::MaybeUninit<::ink::stroke_model::Vec2>);
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Vec2>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$ink$stroke_model$Vec2$raw(::std::unique_ptr<::ink::stroke_model::Vec2> *ptr, ::ink::stroke_model::Vec2 *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Vec2>(raw);
}
::ink::stroke_model::Vec2 const *cxxbridge1$unique_ptr$ink$stroke_model$Vec2$get(::std::unique_ptr<::ink::stroke_model::Vec2> const &ptr) noexcept {
  return ptr.get();
}
::ink::stroke_model::Vec2 *cxxbridge1$unique_ptr$ink$stroke_model$Vec2$release(::std::unique_ptr<::ink::stroke_model::Vec2> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$ink$stroke_model$Vec2$drop(::std::unique_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::ink::stroke_model::Vec2>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::ink::stroke_model::Vec2>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::ink::stroke_model::Vec2>) == alignof(void *), "");
void cxxbridge1$shared_ptr$ink$stroke_model$Vec2$null(::std::shared_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Vec2>();
}
::ink::stroke_model::Vec2 *cxxbridge1$shared_ptr$ink$stroke_model$Vec2$uninit(::std::shared_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::ink::stroke_model::Vec2 *uninit = reinterpret_cast<::ink::stroke_model::Vec2 *>(new ::rust::MaybeUninit<::ink::stroke_model::Vec2>);
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Vec2>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$ink$stroke_model$Vec2$clone(::std::shared_ptr<::ink::stroke_model::Vec2> const &self, ::std::shared_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Vec2>(self);
}
::ink::stroke_model::Vec2 const *cxxbridge1$shared_ptr$ink$stroke_model$Vec2$get(::std::shared_ptr<::ink::stroke_model::Vec2> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$ink$stroke_model$Vec2$drop(::std::shared_ptr<::ink::stroke_model::Vec2> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::ink::stroke_model::Vec2>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::ink::stroke_model::Vec2>) == alignof(void *), "");
void cxxbridge1$weak_ptr$ink$stroke_model$Vec2$null(::std::weak_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Vec2>();
}
void cxxbridge1$weak_ptr$ink$stroke_model$Vec2$clone(::std::weak_ptr<::ink::stroke_model::Vec2> const &self, ::std::weak_ptr<::ink::stroke_model::Vec2> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Vec2>(self);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Vec2$downgrade(::std::shared_ptr<::ink::stroke_model::Vec2> const &shared, ::std::weak_ptr<::ink::stroke_model::Vec2> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::ink::stroke_model::Vec2>(shared);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Vec2$upgrade(::std::weak_ptr<::ink::stroke_model::Vec2> const &weak, ::std::shared_ptr<::ink::stroke_model::Vec2> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::ink::stroke_model::Vec2>(weak.lock());
}
void cxxbridge1$weak_ptr$ink$stroke_model$Vec2$drop(::std::weak_ptr<::ink::stroke_model::Vec2> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::ink::stroke_model::Vec2> *cxxbridge1$std$vector$ink$stroke_model$Vec2$new() noexcept {
  return new ::std::vector<::ink::stroke_model::Vec2>();
}
::std::size_t cxxbridge1$std$vector$ink$stroke_model$Vec2$size(::std::vector<::ink::stroke_model::Vec2> const &s) noexcept {
  return s.size();
}
::ink::stroke_model::Vec2 *cxxbridge1$std$vector$ink$stroke_model$Vec2$get_unchecked(::std::vector<::ink::stroke_model::Vec2> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$ink$stroke_model$Vec2$push_back(::std::vector<::ink::stroke_model::Vec2> *v, ::ink::stroke_model::Vec2 *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$ink$stroke_model$Vec2$pop_back(::std::vector<::ink::stroke_model::Vec2> *v, ::ink::stroke_model::Vec2 *out) noexcept {
  ::new (out) ::ink::stroke_model::Vec2(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Vec2$null(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>>();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Vec2$raw(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>> *ptr, ::std::vector<::ink::stroke_model::Vec2> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>>(raw);
}
::std::vector<::ink::stroke_model::Vec2> const *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Vec2$get(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::ink::stroke_model::Vec2> *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Vec2$release(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Vec2$drop(::std::unique_ptr<::std::vector<::ink::stroke_model::Vec2>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::ink::stroke_model::Input>::value, "definition of Input is required");
static_assert(sizeof(::std::unique_ptr<::ink::stroke_model::Input>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::ink::stroke_model::Input>) == alignof(void *), "");
void cxxbridge1$unique_ptr$ink$stroke_model$Input$null(::std::unique_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Input>();
}
::ink::stroke_model::Input *cxxbridge1$unique_ptr$ink$stroke_model$Input$uninit(::std::unique_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::ink::stroke_model::Input *uninit = reinterpret_cast<::ink::stroke_model::Input *>(new ::rust::MaybeUninit<::ink::stroke_model::Input>);
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Input>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$ink$stroke_model$Input$raw(::std::unique_ptr<::ink::stroke_model::Input> *ptr, ::ink::stroke_model::Input *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Input>(raw);
}
::ink::stroke_model::Input const *cxxbridge1$unique_ptr$ink$stroke_model$Input$get(::std::unique_ptr<::ink::stroke_model::Input> const &ptr) noexcept {
  return ptr.get();
}
::ink::stroke_model::Input *cxxbridge1$unique_ptr$ink$stroke_model$Input$release(::std::unique_ptr<::ink::stroke_model::Input> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$ink$stroke_model$Input$drop(::std::unique_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::ink::stroke_model::Input>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::ink::stroke_model::Input>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::ink::stroke_model::Input>) == alignof(void *), "");
void cxxbridge1$shared_ptr$ink$stroke_model$Input$null(::std::shared_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Input>();
}
::ink::stroke_model::Input *cxxbridge1$shared_ptr$ink$stroke_model$Input$uninit(::std::shared_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::ink::stroke_model::Input *uninit = reinterpret_cast<::ink::stroke_model::Input *>(new ::rust::MaybeUninit<::ink::stroke_model::Input>);
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Input>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$ink$stroke_model$Input$clone(::std::shared_ptr<::ink::stroke_model::Input> const &self, ::std::shared_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Input>(self);
}
::ink::stroke_model::Input const *cxxbridge1$shared_ptr$ink$stroke_model$Input$get(::std::shared_ptr<::ink::stroke_model::Input> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$ink$stroke_model$Input$drop(::std::shared_ptr<::ink::stroke_model::Input> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::ink::stroke_model::Input>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::ink::stroke_model::Input>) == alignof(void *), "");
void cxxbridge1$weak_ptr$ink$stroke_model$Input$null(::std::weak_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Input>();
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$clone(::std::weak_ptr<::ink::stroke_model::Input> const &self, ::std::weak_ptr<::ink::stroke_model::Input> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Input>(self);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$downgrade(::std::shared_ptr<::ink::stroke_model::Input> const &shared, ::std::weak_ptr<::ink::stroke_model::Input> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::ink::stroke_model::Input>(shared);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$upgrade(::std::weak_ptr<::ink::stroke_model::Input> const &weak, ::std::shared_ptr<::ink::stroke_model::Input> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::ink::stroke_model::Input>(weak.lock());
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$drop(::std::weak_ptr<::ink::stroke_model::Input> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::ink::stroke_model::Input> *cxxbridge1$std$vector$ink$stroke_model$Input$new() noexcept {
  return new ::std::vector<::ink::stroke_model::Input>();
}
::std::size_t cxxbridge1$std$vector$ink$stroke_model$Input$size(::std::vector<::ink::stroke_model::Input> const &s) noexcept {
  return s.size();
}
::ink::stroke_model::Input *cxxbridge1$std$vector$ink$stroke_model$Input$get_unchecked(::std::vector<::ink::stroke_model::Input> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$ink$stroke_model$Input$push_back(::std::vector<::ink::stroke_model::Input> *v, ::ink::stroke_model::Input *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$ink$stroke_model$Input$pop_back(::std::vector<::ink::stroke_model::Input> *v, ::ink::stroke_model::Input *out) noexcept {
  ::new (out) ::ink::stroke_model::Input(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$null(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Input>>();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$raw(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>> *ptr, ::std::vector<::ink::stroke_model::Input> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Input>>(raw);
}
::std::vector<::ink::stroke_model::Input> const *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$get(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::ink::stroke_model::Input> *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$release(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$drop(::std::unique_ptr<::std::vector<::ink::stroke_model::Input>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::ink::stroke_model::Input::EventType>::value, "definition of EventType is required");
static_assert(sizeof(::std::unique_ptr<::ink::stroke_model::Input::EventType>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::ink::stroke_model::Input::EventType>) == alignof(void *), "");
void cxxbridge1$unique_ptr$ink$stroke_model$Input$EventType$null(::std::unique_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Input::EventType>();
}
::ink::stroke_model::Input::EventType *cxxbridge1$unique_ptr$ink$stroke_model$Input$EventType$uninit(::std::unique_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::ink::stroke_model::Input::EventType *uninit = reinterpret_cast<::ink::stroke_model::Input::EventType *>(new ::rust::MaybeUninit<::ink::stroke_model::Input::EventType>);
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Input::EventType>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$ink$stroke_model$Input$EventType$raw(::std::unique_ptr<::ink::stroke_model::Input::EventType> *ptr, ::ink::stroke_model::Input::EventType *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Input::EventType>(raw);
}
::ink::stroke_model::Input::EventType const *cxxbridge1$unique_ptr$ink$stroke_model$Input$EventType$get(::std::unique_ptr<::ink::stroke_model::Input::EventType> const &ptr) noexcept {
  return ptr.get();
}
::ink::stroke_model::Input::EventType *cxxbridge1$unique_ptr$ink$stroke_model$Input$EventType$release(::std::unique_ptr<::ink::stroke_model::Input::EventType> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$ink$stroke_model$Input$EventType$drop(::std::unique_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::ink::stroke_model::Input::EventType>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::ink::stroke_model::Input::EventType>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::ink::stroke_model::Input::EventType>) == alignof(void *), "");
void cxxbridge1$shared_ptr$ink$stroke_model$Input$EventType$null(::std::shared_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Input::EventType>();
}
::ink::stroke_model::Input::EventType *cxxbridge1$shared_ptr$ink$stroke_model$Input$EventType$uninit(::std::shared_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::ink::stroke_model::Input::EventType *uninit = reinterpret_cast<::ink::stroke_model::Input::EventType *>(new ::rust::MaybeUninit<::ink::stroke_model::Input::EventType>);
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Input::EventType>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$ink$stroke_model$Input$EventType$clone(::std::shared_ptr<::ink::stroke_model::Input::EventType> const &self, ::std::shared_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Input::EventType>(self);
}
::ink::stroke_model::Input::EventType const *cxxbridge1$shared_ptr$ink$stroke_model$Input$EventType$get(::std::shared_ptr<::ink::stroke_model::Input::EventType> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$ink$stroke_model$Input$EventType$drop(::std::shared_ptr<::ink::stroke_model::Input::EventType> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::ink::stroke_model::Input::EventType>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::ink::stroke_model::Input::EventType>) == alignof(void *), "");
void cxxbridge1$weak_ptr$ink$stroke_model$Input$EventType$null(::std::weak_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Input::EventType>();
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$EventType$clone(::std::weak_ptr<::ink::stroke_model::Input::EventType> const &self, ::std::weak_ptr<::ink::stroke_model::Input::EventType> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Input::EventType>(self);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$EventType$downgrade(::std::shared_ptr<::ink::stroke_model::Input::EventType> const &shared, ::std::weak_ptr<::ink::stroke_model::Input::EventType> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::ink::stroke_model::Input::EventType>(shared);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$EventType$upgrade(::std::weak_ptr<::ink::stroke_model::Input::EventType> const &weak, ::std::shared_ptr<::ink::stroke_model::Input::EventType> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::ink::stroke_model::Input::EventType>(weak.lock());
}
void cxxbridge1$weak_ptr$ink$stroke_model$Input$EventType$drop(::std::weak_ptr<::ink::stroke_model::Input::EventType> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::ink::stroke_model::Input::EventType> *cxxbridge1$std$vector$ink$stroke_model$Input$EventType$new() noexcept {
  return new ::std::vector<::ink::stroke_model::Input::EventType>();
}
::std::size_t cxxbridge1$std$vector$ink$stroke_model$Input$EventType$size(::std::vector<::ink::stroke_model::Input::EventType> const &s) noexcept {
  return s.size();
}
::ink::stroke_model::Input::EventType *cxxbridge1$std$vector$ink$stroke_model$Input$EventType$get_unchecked(::std::vector<::ink::stroke_model::Input::EventType> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$ink$stroke_model$Input$EventType$push_back(::std::vector<::ink::stroke_model::Input::EventType> *v, ::ink::stroke_model::Input::EventType *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$ink$stroke_model$Input$EventType$pop_back(::std::vector<::ink::stroke_model::Input::EventType> *v, ::ink::stroke_model::Input::EventType *out) noexcept {
  ::new (out) ::ink::stroke_model::Input::EventType(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$EventType$null(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>>();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$EventType$raw(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>> *ptr, ::std::vector<::ink::stroke_model::Input::EventType> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>>(raw);
}
::std::vector<::ink::stroke_model::Input::EventType> const *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$EventType$get(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::ink::stroke_model::Input::EventType> *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$EventType$release(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Input$EventType$drop(::std::unique_ptr<::std::vector<::ink::stroke_model::Input::EventType>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::ink::stroke_model::Result>::value, "definition of Result is required");
static_assert(sizeof(::std::unique_ptr<::ink::stroke_model::Result>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::ink::stroke_model::Result>) == alignof(void *), "");
void cxxbridge1$unique_ptr$ink$stroke_model$Result$null(::std::unique_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Result>();
}
::ink::stroke_model::Result *cxxbridge1$unique_ptr$ink$stroke_model$Result$uninit(::std::unique_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::ink::stroke_model::Result *uninit = reinterpret_cast<::ink::stroke_model::Result *>(new ::rust::MaybeUninit<::ink::stroke_model::Result>);
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Result>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$ink$stroke_model$Result$raw(::std::unique_ptr<::ink::stroke_model::Result> *ptr, ::ink::stroke_model::Result *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::Result>(raw);
}
::ink::stroke_model::Result const *cxxbridge1$unique_ptr$ink$stroke_model$Result$get(::std::unique_ptr<::ink::stroke_model::Result> const &ptr) noexcept {
  return ptr.get();
}
::ink::stroke_model::Result *cxxbridge1$unique_ptr$ink$stroke_model$Result$release(::std::unique_ptr<::ink::stroke_model::Result> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$ink$stroke_model$Result$drop(::std::unique_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::ink::stroke_model::Result>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::ink::stroke_model::Result>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::ink::stroke_model::Result>) == alignof(void *), "");
void cxxbridge1$shared_ptr$ink$stroke_model$Result$null(::std::shared_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Result>();
}
::ink::stroke_model::Result *cxxbridge1$shared_ptr$ink$stroke_model$Result$uninit(::std::shared_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::ink::stroke_model::Result *uninit = reinterpret_cast<::ink::stroke_model::Result *>(new ::rust::MaybeUninit<::ink::stroke_model::Result>);
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Result>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$ink$stroke_model$Result$clone(::std::shared_ptr<::ink::stroke_model::Result> const &self, ::std::shared_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::Result>(self);
}
::ink::stroke_model::Result const *cxxbridge1$shared_ptr$ink$stroke_model$Result$get(::std::shared_ptr<::ink::stroke_model::Result> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$ink$stroke_model$Result$drop(::std::shared_ptr<::ink::stroke_model::Result> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::ink::stroke_model::Result>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::ink::stroke_model::Result>) == alignof(void *), "");
void cxxbridge1$weak_ptr$ink$stroke_model$Result$null(::std::weak_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Result>();
}
void cxxbridge1$weak_ptr$ink$stroke_model$Result$clone(::std::weak_ptr<::ink::stroke_model::Result> const &self, ::std::weak_ptr<::ink::stroke_model::Result> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::Result>(self);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Result$downgrade(::std::shared_ptr<::ink::stroke_model::Result> const &shared, ::std::weak_ptr<::ink::stroke_model::Result> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::ink::stroke_model::Result>(shared);
}
void cxxbridge1$weak_ptr$ink$stroke_model$Result$upgrade(::std::weak_ptr<::ink::stroke_model::Result> const &weak, ::std::shared_ptr<::ink::stroke_model::Result> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::ink::stroke_model::Result>(weak.lock());
}
void cxxbridge1$weak_ptr$ink$stroke_model$Result$drop(::std::weak_ptr<::ink::stroke_model::Result> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::ink::stroke_model::Result> *cxxbridge1$std$vector$ink$stroke_model$Result$new() noexcept {
  return new ::std::vector<::ink::stroke_model::Result>();
}
::std::size_t cxxbridge1$std$vector$ink$stroke_model$Result$size(::std::vector<::ink::stroke_model::Result> const &s) noexcept {
  return s.size();
}
::ink::stroke_model::Result *cxxbridge1$std$vector$ink$stroke_model$Result$get_unchecked(::std::vector<::ink::stroke_model::Result> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$ink$stroke_model$Result$push_back(::std::vector<::ink::stroke_model::Result> *v, ::ink::stroke_model::Result *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$ink$stroke_model$Result$pop_back(::std::vector<::ink::stroke_model::Result> *v, ::ink::stroke_model::Result *out) noexcept {
  ::new (out) ::ink::stroke_model::Result(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Result$null(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Result>>();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Result$raw(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>> *ptr, ::std::vector<::ink::stroke_model::Result> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::Result>>(raw);
}
::std::vector<::ink::stroke_model::Result> const *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Result$get(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::ink::stroke_model::Result> *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Result$release(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$Result$drop(::std::unique_ptr<::std::vector<::ink::stroke_model::Result>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::ink::stroke_model::StrokeModeler>::value, "definition of StrokeModeler is required");
static_assert(sizeof(::std::unique_ptr<::ink::stroke_model::StrokeModeler>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::ink::stroke_model::StrokeModeler>) == alignof(void *), "");
void cxxbridge1$unique_ptr$ink$stroke_model$StrokeModeler$null(::std::unique_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::StrokeModeler>();
}
::ink::stroke_model::StrokeModeler *cxxbridge1$unique_ptr$ink$stroke_model$StrokeModeler$uninit(::std::unique_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::ink::stroke_model::StrokeModeler *uninit = reinterpret_cast<::ink::stroke_model::StrokeModeler *>(new ::rust::MaybeUninit<::ink::stroke_model::StrokeModeler>);
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::StrokeModeler>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$ink$stroke_model$StrokeModeler$raw(::std::unique_ptr<::ink::stroke_model::StrokeModeler> *ptr, ::ink::stroke_model::StrokeModeler *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::StrokeModeler>(raw);
}
::ink::stroke_model::StrokeModeler const *cxxbridge1$unique_ptr$ink$stroke_model$StrokeModeler$get(::std::unique_ptr<::ink::stroke_model::StrokeModeler> const &ptr) noexcept {
  return ptr.get();
}
::ink::stroke_model::StrokeModeler *cxxbridge1$unique_ptr$ink$stroke_model$StrokeModeler$release(::std::unique_ptr<::ink::stroke_model::StrokeModeler> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$ink$stroke_model$StrokeModeler$drop(::std::unique_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::ink::stroke_model::StrokeModeler>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::ink::stroke_model::StrokeModeler>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::ink::stroke_model::StrokeModeler>) == alignof(void *), "");
void cxxbridge1$shared_ptr$ink$stroke_model$StrokeModeler$null(::std::shared_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::StrokeModeler>();
}
::ink::stroke_model::StrokeModeler *cxxbridge1$shared_ptr$ink$stroke_model$StrokeModeler$uninit(::std::shared_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::ink::stroke_model::StrokeModeler *uninit = reinterpret_cast<::ink::stroke_model::StrokeModeler *>(new ::rust::MaybeUninit<::ink::stroke_model::StrokeModeler>);
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::StrokeModeler>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$ink$stroke_model$StrokeModeler$clone(::std::shared_ptr<::ink::stroke_model::StrokeModeler> const &self, ::std::shared_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::StrokeModeler>(self);
}
::ink::stroke_model::StrokeModeler const *cxxbridge1$shared_ptr$ink$stroke_model$StrokeModeler$get(::std::shared_ptr<::ink::stroke_model::StrokeModeler> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$ink$stroke_model$StrokeModeler$drop(::std::shared_ptr<::ink::stroke_model::StrokeModeler> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::ink::stroke_model::StrokeModeler>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::ink::stroke_model::StrokeModeler>) == alignof(void *), "");
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModeler$null(::std::weak_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::StrokeModeler>();
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModeler$clone(::std::weak_ptr<::ink::stroke_model::StrokeModeler> const &self, ::std::weak_ptr<::ink::stroke_model::StrokeModeler> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::StrokeModeler>(self);
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModeler$downgrade(::std::shared_ptr<::ink::stroke_model::StrokeModeler> const &shared, ::std::weak_ptr<::ink::stroke_model::StrokeModeler> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::ink::stroke_model::StrokeModeler>(shared);
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModeler$upgrade(::std::weak_ptr<::ink::stroke_model::StrokeModeler> const &weak, ::std::shared_ptr<::ink::stroke_model::StrokeModeler> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::ink::stroke_model::StrokeModeler>(weak.lock());
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModeler$drop(::std::weak_ptr<::ink::stroke_model::StrokeModeler> *self) noexcept {
  self->~weak_ptr();
}

static_assert(::rust::detail::is_complete<::BdWobbleSmootherParams>::value, "definition of BdWobbleSmootherParams is required");
static_assert(sizeof(::std::unique_ptr<::BdWobbleSmootherParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdWobbleSmootherParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdWobbleSmootherParams$null(::std::unique_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdWobbleSmootherParams>();
}
::BdWobbleSmootherParams *cxxbridge1$unique_ptr$BdWobbleSmootherParams$uninit(::std::unique_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::BdWobbleSmootherParams *uninit = reinterpret_cast<::BdWobbleSmootherParams *>(new ::rust::MaybeUninit<::BdWobbleSmootherParams>);
  ::new (ptr) ::std::unique_ptr<::BdWobbleSmootherParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdWobbleSmootherParams$raw(::std::unique_ptr<::BdWobbleSmootherParams> *ptr, ::BdWobbleSmootherParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdWobbleSmootherParams>(raw);
}
::BdWobbleSmootherParams const *cxxbridge1$unique_ptr$BdWobbleSmootherParams$get(::std::unique_ptr<::BdWobbleSmootherParams> const &ptr) noexcept {
  return ptr.get();
}
::BdWobbleSmootherParams *cxxbridge1$unique_ptr$BdWobbleSmootherParams$release(::std::unique_ptr<::BdWobbleSmootherParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdWobbleSmootherParams$drop(::std::unique_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdWobbleSmootherParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdWobbleSmootherParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdWobbleSmootherParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdWobbleSmootherParams$null(::std::shared_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdWobbleSmootherParams>();
}
::BdWobbleSmootherParams *cxxbridge1$shared_ptr$BdWobbleSmootherParams$uninit(::std::shared_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::BdWobbleSmootherParams *uninit = reinterpret_cast<::BdWobbleSmootherParams *>(new ::rust::MaybeUninit<::BdWobbleSmootherParams>);
  ::new (ptr) ::std::shared_ptr<::BdWobbleSmootherParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdWobbleSmootherParams$clone(::std::shared_ptr<::BdWobbleSmootherParams> const &self, ::std::shared_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdWobbleSmootherParams>(self);
}
::BdWobbleSmootherParams const *cxxbridge1$shared_ptr$BdWobbleSmootherParams$get(::std::shared_ptr<::BdWobbleSmootherParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdWobbleSmootherParams$drop(::std::shared_ptr<::BdWobbleSmootherParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdWobbleSmootherParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdWobbleSmootherParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdWobbleSmootherParams$null(::std::weak_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdWobbleSmootherParams>();
}
void cxxbridge1$weak_ptr$BdWobbleSmootherParams$clone(::std::weak_ptr<::BdWobbleSmootherParams> const &self, ::std::weak_ptr<::BdWobbleSmootherParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdWobbleSmootherParams>(self);
}
void cxxbridge1$weak_ptr$BdWobbleSmootherParams$downgrade(::std::shared_ptr<::BdWobbleSmootherParams> const &shared, ::std::weak_ptr<::BdWobbleSmootherParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdWobbleSmootherParams>(shared);
}
void cxxbridge1$weak_ptr$BdWobbleSmootherParams$upgrade(::std::weak_ptr<::BdWobbleSmootherParams> const &weak, ::std::shared_ptr<::BdWobbleSmootherParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdWobbleSmootherParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdWobbleSmootherParams$drop(::std::weak_ptr<::BdWobbleSmootherParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdWobbleSmootherParams> *cxxbridge1$std$vector$BdWobbleSmootherParams$new() noexcept {
  return new ::std::vector<::BdWobbleSmootherParams>();
}
::std::size_t cxxbridge1$std$vector$BdWobbleSmootherParams$size(::std::vector<::BdWobbleSmootherParams> const &s) noexcept {
  return s.size();
}
::BdWobbleSmootherParams *cxxbridge1$std$vector$BdWobbleSmootherParams$get_unchecked(::std::vector<::BdWobbleSmootherParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdWobbleSmootherParams$push_back(::std::vector<::BdWobbleSmootherParams> *v, ::BdWobbleSmootherParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdWobbleSmootherParams$pop_back(::std::vector<::BdWobbleSmootherParams> *v, ::BdWobbleSmootherParams *out) noexcept {
  ::new (out) ::BdWobbleSmootherParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdWobbleSmootherParams$null(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdWobbleSmootherParams$raw(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>> *ptr, ::std::vector<::BdWobbleSmootherParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>>(raw);
}
::std::vector<::BdWobbleSmootherParams> const *cxxbridge1$unique_ptr$std$vector$BdWobbleSmootherParams$get(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdWobbleSmootherParams> *cxxbridge1$unique_ptr$std$vector$BdWobbleSmootherParams$release(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdWobbleSmootherParams$drop(::std::unique_ptr<::std::vector<::BdWobbleSmootherParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::BdPositionModelerParams>::value, "definition of BdPositionModelerParams is required");
static_assert(sizeof(::std::unique_ptr<::BdPositionModelerParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdPositionModelerParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdPositionModelerParams$null(::std::unique_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdPositionModelerParams>();
}
::BdPositionModelerParams *cxxbridge1$unique_ptr$BdPositionModelerParams$uninit(::std::unique_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::BdPositionModelerParams *uninit = reinterpret_cast<::BdPositionModelerParams *>(new ::rust::MaybeUninit<::BdPositionModelerParams>);
  ::new (ptr) ::std::unique_ptr<::BdPositionModelerParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdPositionModelerParams$raw(::std::unique_ptr<::BdPositionModelerParams> *ptr, ::BdPositionModelerParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdPositionModelerParams>(raw);
}
::BdPositionModelerParams const *cxxbridge1$unique_ptr$BdPositionModelerParams$get(::std::unique_ptr<::BdPositionModelerParams> const &ptr) noexcept {
  return ptr.get();
}
::BdPositionModelerParams *cxxbridge1$unique_ptr$BdPositionModelerParams$release(::std::unique_ptr<::BdPositionModelerParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdPositionModelerParams$drop(::std::unique_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdPositionModelerParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdPositionModelerParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdPositionModelerParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdPositionModelerParams$null(::std::shared_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdPositionModelerParams>();
}
::BdPositionModelerParams *cxxbridge1$shared_ptr$BdPositionModelerParams$uninit(::std::shared_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::BdPositionModelerParams *uninit = reinterpret_cast<::BdPositionModelerParams *>(new ::rust::MaybeUninit<::BdPositionModelerParams>);
  ::new (ptr) ::std::shared_ptr<::BdPositionModelerParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdPositionModelerParams$clone(::std::shared_ptr<::BdPositionModelerParams> const &self, ::std::shared_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdPositionModelerParams>(self);
}
::BdPositionModelerParams const *cxxbridge1$shared_ptr$BdPositionModelerParams$get(::std::shared_ptr<::BdPositionModelerParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdPositionModelerParams$drop(::std::shared_ptr<::BdPositionModelerParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdPositionModelerParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdPositionModelerParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdPositionModelerParams$null(::std::weak_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdPositionModelerParams>();
}
void cxxbridge1$weak_ptr$BdPositionModelerParams$clone(::std::weak_ptr<::BdPositionModelerParams> const &self, ::std::weak_ptr<::BdPositionModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdPositionModelerParams>(self);
}
void cxxbridge1$weak_ptr$BdPositionModelerParams$downgrade(::std::shared_ptr<::BdPositionModelerParams> const &shared, ::std::weak_ptr<::BdPositionModelerParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdPositionModelerParams>(shared);
}
void cxxbridge1$weak_ptr$BdPositionModelerParams$upgrade(::std::weak_ptr<::BdPositionModelerParams> const &weak, ::std::shared_ptr<::BdPositionModelerParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdPositionModelerParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdPositionModelerParams$drop(::std::weak_ptr<::BdPositionModelerParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdPositionModelerParams> *cxxbridge1$std$vector$BdPositionModelerParams$new() noexcept {
  return new ::std::vector<::BdPositionModelerParams>();
}
::std::size_t cxxbridge1$std$vector$BdPositionModelerParams$size(::std::vector<::BdPositionModelerParams> const &s) noexcept {
  return s.size();
}
::BdPositionModelerParams *cxxbridge1$std$vector$BdPositionModelerParams$get_unchecked(::std::vector<::BdPositionModelerParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdPositionModelerParams$push_back(::std::vector<::BdPositionModelerParams> *v, ::BdPositionModelerParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdPositionModelerParams$pop_back(::std::vector<::BdPositionModelerParams> *v, ::BdPositionModelerParams *out) noexcept {
  ::new (out) ::BdPositionModelerParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdPositionModelerParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdPositionModelerParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdPositionModelerParams$null(::std::unique_ptr<::std::vector<::BdPositionModelerParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdPositionModelerParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdPositionModelerParams$raw(::std::unique_ptr<::std::vector<::BdPositionModelerParams>> *ptr, ::std::vector<::BdPositionModelerParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdPositionModelerParams>>(raw);
}
::std::vector<::BdPositionModelerParams> const *cxxbridge1$unique_ptr$std$vector$BdPositionModelerParams$get(::std::unique_ptr<::std::vector<::BdPositionModelerParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdPositionModelerParams> *cxxbridge1$unique_ptr$std$vector$BdPositionModelerParams$release(::std::unique_ptr<::std::vector<::BdPositionModelerParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdPositionModelerParams$drop(::std::unique_ptr<::std::vector<::BdPositionModelerParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::BdSamplingParams>::value, "definition of BdSamplingParams is required");
static_assert(sizeof(::std::unique_ptr<::BdSamplingParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdSamplingParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdSamplingParams$null(::std::unique_ptr<::BdSamplingParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdSamplingParams>();
}
::BdSamplingParams *cxxbridge1$unique_ptr$BdSamplingParams$uninit(::std::unique_ptr<::BdSamplingParams> *ptr) noexcept {
  ::BdSamplingParams *uninit = reinterpret_cast<::BdSamplingParams *>(new ::rust::MaybeUninit<::BdSamplingParams>);
  ::new (ptr) ::std::unique_ptr<::BdSamplingParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdSamplingParams$raw(::std::unique_ptr<::BdSamplingParams> *ptr, ::BdSamplingParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdSamplingParams>(raw);
}
::BdSamplingParams const *cxxbridge1$unique_ptr$BdSamplingParams$get(::std::unique_ptr<::BdSamplingParams> const &ptr) noexcept {
  return ptr.get();
}
::BdSamplingParams *cxxbridge1$unique_ptr$BdSamplingParams$release(::std::unique_ptr<::BdSamplingParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdSamplingParams$drop(::std::unique_ptr<::BdSamplingParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdSamplingParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdSamplingParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdSamplingParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdSamplingParams$null(::std::shared_ptr<::BdSamplingParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdSamplingParams>();
}
::BdSamplingParams *cxxbridge1$shared_ptr$BdSamplingParams$uninit(::std::shared_ptr<::BdSamplingParams> *ptr) noexcept {
  ::BdSamplingParams *uninit = reinterpret_cast<::BdSamplingParams *>(new ::rust::MaybeUninit<::BdSamplingParams>);
  ::new (ptr) ::std::shared_ptr<::BdSamplingParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdSamplingParams$clone(::std::shared_ptr<::BdSamplingParams> const &self, ::std::shared_ptr<::BdSamplingParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdSamplingParams>(self);
}
::BdSamplingParams const *cxxbridge1$shared_ptr$BdSamplingParams$get(::std::shared_ptr<::BdSamplingParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdSamplingParams$drop(::std::shared_ptr<::BdSamplingParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdSamplingParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdSamplingParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdSamplingParams$null(::std::weak_ptr<::BdSamplingParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdSamplingParams>();
}
void cxxbridge1$weak_ptr$BdSamplingParams$clone(::std::weak_ptr<::BdSamplingParams> const &self, ::std::weak_ptr<::BdSamplingParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdSamplingParams>(self);
}
void cxxbridge1$weak_ptr$BdSamplingParams$downgrade(::std::shared_ptr<::BdSamplingParams> const &shared, ::std::weak_ptr<::BdSamplingParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdSamplingParams>(shared);
}
void cxxbridge1$weak_ptr$BdSamplingParams$upgrade(::std::weak_ptr<::BdSamplingParams> const &weak, ::std::shared_ptr<::BdSamplingParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdSamplingParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdSamplingParams$drop(::std::weak_ptr<::BdSamplingParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdSamplingParams> *cxxbridge1$std$vector$BdSamplingParams$new() noexcept {
  return new ::std::vector<::BdSamplingParams>();
}
::std::size_t cxxbridge1$std$vector$BdSamplingParams$size(::std::vector<::BdSamplingParams> const &s) noexcept {
  return s.size();
}
::BdSamplingParams *cxxbridge1$std$vector$BdSamplingParams$get_unchecked(::std::vector<::BdSamplingParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdSamplingParams$push_back(::std::vector<::BdSamplingParams> *v, ::BdSamplingParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdSamplingParams$pop_back(::std::vector<::BdSamplingParams> *v, ::BdSamplingParams *out) noexcept {
  ::new (out) ::BdSamplingParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdSamplingParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdSamplingParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdSamplingParams$null(::std::unique_ptr<::std::vector<::BdSamplingParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdSamplingParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdSamplingParams$raw(::std::unique_ptr<::std::vector<::BdSamplingParams>> *ptr, ::std::vector<::BdSamplingParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdSamplingParams>>(raw);
}
::std::vector<::BdSamplingParams> const *cxxbridge1$unique_ptr$std$vector$BdSamplingParams$get(::std::unique_ptr<::std::vector<::BdSamplingParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdSamplingParams> *cxxbridge1$unique_ptr$std$vector$BdSamplingParams$release(::std::unique_ptr<::std::vector<::BdSamplingParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdSamplingParams$drop(::std::unique_ptr<::std::vector<::BdSamplingParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::BdStylusStateModelerParams>::value, "definition of BdStylusStateModelerParams is required");
static_assert(sizeof(::std::unique_ptr<::BdStylusStateModelerParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdStylusStateModelerParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdStylusStateModelerParams$null(::std::unique_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdStylusStateModelerParams>();
}
::BdStylusStateModelerParams *cxxbridge1$unique_ptr$BdStylusStateModelerParams$uninit(::std::unique_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::BdStylusStateModelerParams *uninit = reinterpret_cast<::BdStylusStateModelerParams *>(new ::rust::MaybeUninit<::BdStylusStateModelerParams>);
  ::new (ptr) ::std::unique_ptr<::BdStylusStateModelerParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdStylusStateModelerParams$raw(::std::unique_ptr<::BdStylusStateModelerParams> *ptr, ::BdStylusStateModelerParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdStylusStateModelerParams>(raw);
}
::BdStylusStateModelerParams const *cxxbridge1$unique_ptr$BdStylusStateModelerParams$get(::std::unique_ptr<::BdStylusStateModelerParams> const &ptr) noexcept {
  return ptr.get();
}
::BdStylusStateModelerParams *cxxbridge1$unique_ptr$BdStylusStateModelerParams$release(::std::unique_ptr<::BdStylusStateModelerParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdStylusStateModelerParams$drop(::std::unique_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdStylusStateModelerParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdStylusStateModelerParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdStylusStateModelerParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdStylusStateModelerParams$null(::std::shared_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdStylusStateModelerParams>();
}
::BdStylusStateModelerParams *cxxbridge1$shared_ptr$BdStylusStateModelerParams$uninit(::std::shared_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::BdStylusStateModelerParams *uninit = reinterpret_cast<::BdStylusStateModelerParams *>(new ::rust::MaybeUninit<::BdStylusStateModelerParams>);
  ::new (ptr) ::std::shared_ptr<::BdStylusStateModelerParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdStylusStateModelerParams$clone(::std::shared_ptr<::BdStylusStateModelerParams> const &self, ::std::shared_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdStylusStateModelerParams>(self);
}
::BdStylusStateModelerParams const *cxxbridge1$shared_ptr$BdStylusStateModelerParams$get(::std::shared_ptr<::BdStylusStateModelerParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdStylusStateModelerParams$drop(::std::shared_ptr<::BdStylusStateModelerParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdStylusStateModelerParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdStylusStateModelerParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdStylusStateModelerParams$null(::std::weak_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdStylusStateModelerParams>();
}
void cxxbridge1$weak_ptr$BdStylusStateModelerParams$clone(::std::weak_ptr<::BdStylusStateModelerParams> const &self, ::std::weak_ptr<::BdStylusStateModelerParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdStylusStateModelerParams>(self);
}
void cxxbridge1$weak_ptr$BdStylusStateModelerParams$downgrade(::std::shared_ptr<::BdStylusStateModelerParams> const &shared, ::std::weak_ptr<::BdStylusStateModelerParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdStylusStateModelerParams>(shared);
}
void cxxbridge1$weak_ptr$BdStylusStateModelerParams$upgrade(::std::weak_ptr<::BdStylusStateModelerParams> const &weak, ::std::shared_ptr<::BdStylusStateModelerParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdStylusStateModelerParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdStylusStateModelerParams$drop(::std::weak_ptr<::BdStylusStateModelerParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdStylusStateModelerParams> *cxxbridge1$std$vector$BdStylusStateModelerParams$new() noexcept {
  return new ::std::vector<::BdStylusStateModelerParams>();
}
::std::size_t cxxbridge1$std$vector$BdStylusStateModelerParams$size(::std::vector<::BdStylusStateModelerParams> const &s) noexcept {
  return s.size();
}
::BdStylusStateModelerParams *cxxbridge1$std$vector$BdStylusStateModelerParams$get_unchecked(::std::vector<::BdStylusStateModelerParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdStylusStateModelerParams$push_back(::std::vector<::BdStylusStateModelerParams> *v, ::BdStylusStateModelerParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdStylusStateModelerParams$pop_back(::std::vector<::BdStylusStateModelerParams> *v, ::BdStylusStateModelerParams *out) noexcept {
  ::new (out) ::BdStylusStateModelerParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdStylusStateModelerParams$null(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdStylusStateModelerParams$raw(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>> *ptr, ::std::vector<::BdStylusStateModelerParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>>(raw);
}
::std::vector<::BdStylusStateModelerParams> const *cxxbridge1$unique_ptr$std$vector$BdStylusStateModelerParams$get(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdStylusStateModelerParams> *cxxbridge1$unique_ptr$std$vector$BdStylusStateModelerParams$release(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdStylusStateModelerParams$drop(::std::unique_ptr<::std::vector<::BdStylusStateModelerParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::BdKalmanPredictorConfidenceParams>::value, "definition of BdKalmanPredictorConfidenceParams is required");
static_assert(sizeof(::std::unique_ptr<::BdKalmanPredictorConfidenceParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdKalmanPredictorConfidenceParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdKalmanPredictorConfidenceParams$null(::std::unique_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdKalmanPredictorConfidenceParams>();
}
::BdKalmanPredictorConfidenceParams *cxxbridge1$unique_ptr$BdKalmanPredictorConfidenceParams$uninit(::std::unique_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::BdKalmanPredictorConfidenceParams *uninit = reinterpret_cast<::BdKalmanPredictorConfidenceParams *>(new ::rust::MaybeUninit<::BdKalmanPredictorConfidenceParams>);
  ::new (ptr) ::std::unique_ptr<::BdKalmanPredictorConfidenceParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdKalmanPredictorConfidenceParams$raw(::std::unique_ptr<::BdKalmanPredictorConfidenceParams> *ptr, ::BdKalmanPredictorConfidenceParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdKalmanPredictorConfidenceParams>(raw);
}
::BdKalmanPredictorConfidenceParams const *cxxbridge1$unique_ptr$BdKalmanPredictorConfidenceParams$get(::std::unique_ptr<::BdKalmanPredictorConfidenceParams> const &ptr) noexcept {
  return ptr.get();
}
::BdKalmanPredictorConfidenceParams *cxxbridge1$unique_ptr$BdKalmanPredictorConfidenceParams$release(::std::unique_ptr<::BdKalmanPredictorConfidenceParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdKalmanPredictorConfidenceParams$drop(::std::unique_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdKalmanPredictorConfidenceParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdKalmanPredictorConfidenceParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdKalmanPredictorConfidenceParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdKalmanPredictorConfidenceParams$null(::std::shared_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdKalmanPredictorConfidenceParams>();
}
::BdKalmanPredictorConfidenceParams *cxxbridge1$shared_ptr$BdKalmanPredictorConfidenceParams$uninit(::std::shared_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::BdKalmanPredictorConfidenceParams *uninit = reinterpret_cast<::BdKalmanPredictorConfidenceParams *>(new ::rust::MaybeUninit<::BdKalmanPredictorConfidenceParams>);
  ::new (ptr) ::std::shared_ptr<::BdKalmanPredictorConfidenceParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdKalmanPredictorConfidenceParams$clone(::std::shared_ptr<::BdKalmanPredictorConfidenceParams> const &self, ::std::shared_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdKalmanPredictorConfidenceParams>(self);
}
::BdKalmanPredictorConfidenceParams const *cxxbridge1$shared_ptr$BdKalmanPredictorConfidenceParams$get(::std::shared_ptr<::BdKalmanPredictorConfidenceParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdKalmanPredictorConfidenceParams$drop(::std::shared_ptr<::BdKalmanPredictorConfidenceParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdKalmanPredictorConfidenceParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdKalmanPredictorConfidenceParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdKalmanPredictorConfidenceParams$null(::std::weak_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdKalmanPredictorConfidenceParams>();
}
void cxxbridge1$weak_ptr$BdKalmanPredictorConfidenceParams$clone(::std::weak_ptr<::BdKalmanPredictorConfidenceParams> const &self, ::std::weak_ptr<::BdKalmanPredictorConfidenceParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdKalmanPredictorConfidenceParams>(self);
}
void cxxbridge1$weak_ptr$BdKalmanPredictorConfidenceParams$downgrade(::std::shared_ptr<::BdKalmanPredictorConfidenceParams> const &shared, ::std::weak_ptr<::BdKalmanPredictorConfidenceParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdKalmanPredictorConfidenceParams>(shared);
}
void cxxbridge1$weak_ptr$BdKalmanPredictorConfidenceParams$upgrade(::std::weak_ptr<::BdKalmanPredictorConfidenceParams> const &weak, ::std::shared_ptr<::BdKalmanPredictorConfidenceParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdKalmanPredictorConfidenceParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdKalmanPredictorConfidenceParams$drop(::std::weak_ptr<::BdKalmanPredictorConfidenceParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdKalmanPredictorConfidenceParams> *cxxbridge1$std$vector$BdKalmanPredictorConfidenceParams$new() noexcept {
  return new ::std::vector<::BdKalmanPredictorConfidenceParams>();
}
::std::size_t cxxbridge1$std$vector$BdKalmanPredictorConfidenceParams$size(::std::vector<::BdKalmanPredictorConfidenceParams> const &s) noexcept {
  return s.size();
}
::BdKalmanPredictorConfidenceParams *cxxbridge1$std$vector$BdKalmanPredictorConfidenceParams$get_unchecked(::std::vector<::BdKalmanPredictorConfidenceParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdKalmanPredictorConfidenceParams$push_back(::std::vector<::BdKalmanPredictorConfidenceParams> *v, ::BdKalmanPredictorConfidenceParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdKalmanPredictorConfidenceParams$pop_back(::std::vector<::BdKalmanPredictorConfidenceParams> *v, ::BdKalmanPredictorConfidenceParams *out) noexcept {
  ::new (out) ::BdKalmanPredictorConfidenceParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorConfidenceParams$null(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorConfidenceParams$raw(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>> *ptr, ::std::vector<::BdKalmanPredictorConfidenceParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>>(raw);
}
::std::vector<::BdKalmanPredictorConfidenceParams> const *cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorConfidenceParams$get(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdKalmanPredictorConfidenceParams> *cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorConfidenceParams$release(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorConfidenceParams$drop(::std::unique_ptr<::std::vector<::BdKalmanPredictorConfidenceParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::BdKalmanPredictorParams>::value, "definition of BdKalmanPredictorParams is required");
static_assert(sizeof(::std::unique_ptr<::BdKalmanPredictorParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdKalmanPredictorParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdKalmanPredictorParams$null(::std::unique_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdKalmanPredictorParams>();
}
::BdKalmanPredictorParams *cxxbridge1$unique_ptr$BdKalmanPredictorParams$uninit(::std::unique_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::BdKalmanPredictorParams *uninit = reinterpret_cast<::BdKalmanPredictorParams *>(new ::rust::MaybeUninit<::BdKalmanPredictorParams>);
  ::new (ptr) ::std::unique_ptr<::BdKalmanPredictorParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdKalmanPredictorParams$raw(::std::unique_ptr<::BdKalmanPredictorParams> *ptr, ::BdKalmanPredictorParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdKalmanPredictorParams>(raw);
}
::BdKalmanPredictorParams const *cxxbridge1$unique_ptr$BdKalmanPredictorParams$get(::std::unique_ptr<::BdKalmanPredictorParams> const &ptr) noexcept {
  return ptr.get();
}
::BdKalmanPredictorParams *cxxbridge1$unique_ptr$BdKalmanPredictorParams$release(::std::unique_ptr<::BdKalmanPredictorParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdKalmanPredictorParams$drop(::std::unique_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdKalmanPredictorParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdKalmanPredictorParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdKalmanPredictorParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdKalmanPredictorParams$null(::std::shared_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdKalmanPredictorParams>();
}
::BdKalmanPredictorParams *cxxbridge1$shared_ptr$BdKalmanPredictorParams$uninit(::std::shared_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::BdKalmanPredictorParams *uninit = reinterpret_cast<::BdKalmanPredictorParams *>(new ::rust::MaybeUninit<::BdKalmanPredictorParams>);
  ::new (ptr) ::std::shared_ptr<::BdKalmanPredictorParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdKalmanPredictorParams$clone(::std::shared_ptr<::BdKalmanPredictorParams> const &self, ::std::shared_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdKalmanPredictorParams>(self);
}
::BdKalmanPredictorParams const *cxxbridge1$shared_ptr$BdKalmanPredictorParams$get(::std::shared_ptr<::BdKalmanPredictorParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdKalmanPredictorParams$drop(::std::shared_ptr<::BdKalmanPredictorParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdKalmanPredictorParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdKalmanPredictorParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdKalmanPredictorParams$null(::std::weak_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdKalmanPredictorParams>();
}
void cxxbridge1$weak_ptr$BdKalmanPredictorParams$clone(::std::weak_ptr<::BdKalmanPredictorParams> const &self, ::std::weak_ptr<::BdKalmanPredictorParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdKalmanPredictorParams>(self);
}
void cxxbridge1$weak_ptr$BdKalmanPredictorParams$downgrade(::std::shared_ptr<::BdKalmanPredictorParams> const &shared, ::std::weak_ptr<::BdKalmanPredictorParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdKalmanPredictorParams>(shared);
}
void cxxbridge1$weak_ptr$BdKalmanPredictorParams$upgrade(::std::weak_ptr<::BdKalmanPredictorParams> const &weak, ::std::shared_ptr<::BdKalmanPredictorParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdKalmanPredictorParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdKalmanPredictorParams$drop(::std::weak_ptr<::BdKalmanPredictorParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdKalmanPredictorParams> *cxxbridge1$std$vector$BdKalmanPredictorParams$new() noexcept {
  return new ::std::vector<::BdKalmanPredictorParams>();
}
::std::size_t cxxbridge1$std$vector$BdKalmanPredictorParams$size(::std::vector<::BdKalmanPredictorParams> const &s) noexcept {
  return s.size();
}
::BdKalmanPredictorParams *cxxbridge1$std$vector$BdKalmanPredictorParams$get_unchecked(::std::vector<::BdKalmanPredictorParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdKalmanPredictorParams$push_back(::std::vector<::BdKalmanPredictorParams> *v, ::BdKalmanPredictorParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdKalmanPredictorParams$pop_back(::std::vector<::BdKalmanPredictorParams> *v, ::BdKalmanPredictorParams *out) noexcept {
  ::new (out) ::BdKalmanPredictorParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorParams$null(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorParams$raw(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>> *ptr, ::std::vector<::BdKalmanPredictorParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>>(raw);
}
::std::vector<::BdKalmanPredictorParams> const *cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorParams$get(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdKalmanPredictorParams> *cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorParams$release(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdKalmanPredictorParams$drop(::std::unique_ptr<::std::vector<::BdKalmanPredictorParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::BdStrokeModelParams>::value, "definition of BdStrokeModelParams is required");
static_assert(sizeof(::std::unique_ptr<::BdStrokeModelParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::BdStrokeModelParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$BdStrokeModelParams$null(::std::unique_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdStrokeModelParams>();
}
::BdStrokeModelParams *cxxbridge1$unique_ptr$BdStrokeModelParams$uninit(::std::unique_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::BdStrokeModelParams *uninit = reinterpret_cast<::BdStrokeModelParams *>(new ::rust::MaybeUninit<::BdStrokeModelParams>);
  ::new (ptr) ::std::unique_ptr<::BdStrokeModelParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$BdStrokeModelParams$raw(::std::unique_ptr<::BdStrokeModelParams> *ptr, ::BdStrokeModelParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::BdStrokeModelParams>(raw);
}
::BdStrokeModelParams const *cxxbridge1$unique_ptr$BdStrokeModelParams$get(::std::unique_ptr<::BdStrokeModelParams> const &ptr) noexcept {
  return ptr.get();
}
::BdStrokeModelParams *cxxbridge1$unique_ptr$BdStrokeModelParams$release(::std::unique_ptr<::BdStrokeModelParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$BdStrokeModelParams$drop(::std::unique_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::BdStrokeModelParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::BdStrokeModelParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::BdStrokeModelParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$BdStrokeModelParams$null(::std::shared_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdStrokeModelParams>();
}
::BdStrokeModelParams *cxxbridge1$shared_ptr$BdStrokeModelParams$uninit(::std::shared_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::BdStrokeModelParams *uninit = reinterpret_cast<::BdStrokeModelParams *>(new ::rust::MaybeUninit<::BdStrokeModelParams>);
  ::new (ptr) ::std::shared_ptr<::BdStrokeModelParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$BdStrokeModelParams$clone(::std::shared_ptr<::BdStrokeModelParams> const &self, ::std::shared_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::BdStrokeModelParams>(self);
}
::BdStrokeModelParams const *cxxbridge1$shared_ptr$BdStrokeModelParams$get(::std::shared_ptr<::BdStrokeModelParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$BdStrokeModelParams$drop(::std::shared_ptr<::BdStrokeModelParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::BdStrokeModelParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::BdStrokeModelParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$BdStrokeModelParams$null(::std::weak_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdStrokeModelParams>();
}
void cxxbridge1$weak_ptr$BdStrokeModelParams$clone(::std::weak_ptr<::BdStrokeModelParams> const &self, ::std::weak_ptr<::BdStrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::BdStrokeModelParams>(self);
}
void cxxbridge1$weak_ptr$BdStrokeModelParams$downgrade(::std::shared_ptr<::BdStrokeModelParams> const &shared, ::std::weak_ptr<::BdStrokeModelParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::BdStrokeModelParams>(shared);
}
void cxxbridge1$weak_ptr$BdStrokeModelParams$upgrade(::std::weak_ptr<::BdStrokeModelParams> const &weak, ::std::shared_ptr<::BdStrokeModelParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::BdStrokeModelParams>(weak.lock());
}
void cxxbridge1$weak_ptr$BdStrokeModelParams$drop(::std::weak_ptr<::BdStrokeModelParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::BdStrokeModelParams> *cxxbridge1$std$vector$BdStrokeModelParams$new() noexcept {
  return new ::std::vector<::BdStrokeModelParams>();
}
::std::size_t cxxbridge1$std$vector$BdStrokeModelParams$size(::std::vector<::BdStrokeModelParams> const &s) noexcept {
  return s.size();
}
::BdStrokeModelParams *cxxbridge1$std$vector$BdStrokeModelParams$get_unchecked(::std::vector<::BdStrokeModelParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$BdStrokeModelParams$push_back(::std::vector<::BdStrokeModelParams> *v, ::BdStrokeModelParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$BdStrokeModelParams$pop_back(::std::vector<::BdStrokeModelParams> *v, ::BdStrokeModelParams *out) noexcept {
  ::new (out) ::BdStrokeModelParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::BdStrokeModelParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::BdStrokeModelParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$BdStrokeModelParams$null(::std::unique_ptr<::std::vector<::BdStrokeModelParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdStrokeModelParams>>();
}
void cxxbridge1$unique_ptr$std$vector$BdStrokeModelParams$raw(::std::unique_ptr<::std::vector<::BdStrokeModelParams>> *ptr, ::std::vector<::BdStrokeModelParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::BdStrokeModelParams>>(raw);
}
::std::vector<::BdStrokeModelParams> const *cxxbridge1$unique_ptr$std$vector$BdStrokeModelParams$get(::std::unique_ptr<::std::vector<::BdStrokeModelParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::BdStrokeModelParams> *cxxbridge1$unique_ptr$std$vector$BdStrokeModelParams$release(::std::unique_ptr<::std::vector<::BdStrokeModelParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$BdStrokeModelParams$drop(::std::unique_ptr<::std::vector<::BdStrokeModelParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::ink::stroke_model::StrokeModelParams>::value, "definition of StrokeModelParams is required");
static_assert(sizeof(::std::unique_ptr<::ink::stroke_model::StrokeModelParams>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::ink::stroke_model::StrokeModelParams>) == alignof(void *), "");
void cxxbridge1$unique_ptr$ink$stroke_model$StrokeModelParams$null(::std::unique_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::StrokeModelParams>();
}
::ink::stroke_model::StrokeModelParams *cxxbridge1$unique_ptr$ink$stroke_model$StrokeModelParams$uninit(::std::unique_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::ink::stroke_model::StrokeModelParams *uninit = reinterpret_cast<::ink::stroke_model::StrokeModelParams *>(new ::rust::MaybeUninit<::ink::stroke_model::StrokeModelParams>);
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::StrokeModelParams>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$ink$stroke_model$StrokeModelParams$raw(::std::unique_ptr<::ink::stroke_model::StrokeModelParams> *ptr, ::ink::stroke_model::StrokeModelParams *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::ink::stroke_model::StrokeModelParams>(raw);
}
::ink::stroke_model::StrokeModelParams const *cxxbridge1$unique_ptr$ink$stroke_model$StrokeModelParams$get(::std::unique_ptr<::ink::stroke_model::StrokeModelParams> const &ptr) noexcept {
  return ptr.get();
}
::ink::stroke_model::StrokeModelParams *cxxbridge1$unique_ptr$ink$stroke_model$StrokeModelParams$release(::std::unique_ptr<::ink::stroke_model::StrokeModelParams> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$ink$stroke_model$StrokeModelParams$drop(::std::unique_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::ink::stroke_model::StrokeModelParams>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::ink::stroke_model::StrokeModelParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::ink::stroke_model::StrokeModelParams>) == alignof(void *), "");
void cxxbridge1$shared_ptr$ink$stroke_model$StrokeModelParams$null(::std::shared_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::StrokeModelParams>();
}
::ink::stroke_model::StrokeModelParams *cxxbridge1$shared_ptr$ink$stroke_model$StrokeModelParams$uninit(::std::shared_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::ink::stroke_model::StrokeModelParams *uninit = reinterpret_cast<::ink::stroke_model::StrokeModelParams *>(new ::rust::MaybeUninit<::ink::stroke_model::StrokeModelParams>);
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::StrokeModelParams>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$ink$stroke_model$StrokeModelParams$clone(::std::shared_ptr<::ink::stroke_model::StrokeModelParams> const &self, ::std::shared_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::ink::stroke_model::StrokeModelParams>(self);
}
::ink::stroke_model::StrokeModelParams const *cxxbridge1$shared_ptr$ink$stroke_model$StrokeModelParams$get(::std::shared_ptr<::ink::stroke_model::StrokeModelParams> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$ink$stroke_model$StrokeModelParams$drop(::std::shared_ptr<::ink::stroke_model::StrokeModelParams> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::ink::stroke_model::StrokeModelParams>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::ink::stroke_model::StrokeModelParams>) == alignof(void *), "");
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModelParams$null(::std::weak_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::StrokeModelParams>();
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModelParams$clone(::std::weak_ptr<::ink::stroke_model::StrokeModelParams> const &self, ::std::weak_ptr<::ink::stroke_model::StrokeModelParams> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::ink::stroke_model::StrokeModelParams>(self);
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModelParams$downgrade(::std::shared_ptr<::ink::stroke_model::StrokeModelParams> const &shared, ::std::weak_ptr<::ink::stroke_model::StrokeModelParams> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::ink::stroke_model::StrokeModelParams>(shared);
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModelParams$upgrade(::std::weak_ptr<::ink::stroke_model::StrokeModelParams> const &weak, ::std::shared_ptr<::ink::stroke_model::StrokeModelParams> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::ink::stroke_model::StrokeModelParams>(weak.lock());
}
void cxxbridge1$weak_ptr$ink$stroke_model$StrokeModelParams$drop(::std::weak_ptr<::ink::stroke_model::StrokeModelParams> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::ink::stroke_model::StrokeModelParams> *cxxbridge1$std$vector$ink$stroke_model$StrokeModelParams$new() noexcept {
  return new ::std::vector<::ink::stroke_model::StrokeModelParams>();
}
::std::size_t cxxbridge1$std$vector$ink$stroke_model$StrokeModelParams$size(::std::vector<::ink::stroke_model::StrokeModelParams> const &s) noexcept {
  return s.size();
}
::ink::stroke_model::StrokeModelParams *cxxbridge1$std$vector$ink$stroke_model$StrokeModelParams$get_unchecked(::std::vector<::ink::stroke_model::StrokeModelParams> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$ink$stroke_model$StrokeModelParams$push_back(::std::vector<::ink::stroke_model::StrokeModelParams> *v, ::ink::stroke_model::StrokeModelParams *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$ink$stroke_model$StrokeModelParams$pop_back(::std::vector<::ink::stroke_model::StrokeModelParams> *v, ::ink::stroke_model::StrokeModelParams *out) noexcept {
  ::new (out) ::ink::stroke_model::StrokeModelParams(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$StrokeModelParams$null(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>>();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$StrokeModelParams$raw(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>> *ptr, ::std::vector<::ink::stroke_model::StrokeModelParams> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>>(raw);
}
::std::vector<::ink::stroke_model::StrokeModelParams> const *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$StrokeModelParams$get(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::ink::stroke_model::StrokeModelParams> *cxxbridge1$unique_ptr$std$vector$ink$stroke_model$StrokeModelParams$release(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$ink$stroke_model$StrokeModelParams$drop(::std::unique_ptr<::std::vector<::ink::stroke_model::StrokeModelParams>> *ptr) noexcept {
  ptr->~unique_ptr();
}

static_assert(::rust::detail::is_complete<::absl::lts_20230802::Status>::value, "definition of Status is required");
static_assert(sizeof(::std::unique_ptr<::absl::lts_20230802::Status>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::absl::lts_20230802::Status>) == alignof(void *), "");
void cxxbridge1$unique_ptr$absl$lts_20230802$Status$null(::std::unique_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::absl::lts_20230802::Status>();
}
::absl::lts_20230802::Status *cxxbridge1$unique_ptr$absl$lts_20230802$Status$uninit(::std::unique_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::absl::lts_20230802::Status *uninit = reinterpret_cast<::absl::lts_20230802::Status *>(new ::rust::MaybeUninit<::absl::lts_20230802::Status>);
  ::new (ptr) ::std::unique_ptr<::absl::lts_20230802::Status>(uninit);
  return uninit;
}
void cxxbridge1$unique_ptr$absl$lts_20230802$Status$raw(::std::unique_ptr<::absl::lts_20230802::Status> *ptr, ::absl::lts_20230802::Status *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::absl::lts_20230802::Status>(raw);
}
::absl::lts_20230802::Status const *cxxbridge1$unique_ptr$absl$lts_20230802$Status$get(::std::unique_ptr<::absl::lts_20230802::Status> const &ptr) noexcept {
  return ptr.get();
}
::absl::lts_20230802::Status *cxxbridge1$unique_ptr$absl$lts_20230802$Status$release(::std::unique_ptr<::absl::lts_20230802::Status> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$absl$lts_20230802$Status$drop(::std::unique_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::absl::lts_20230802::Status>::value>{}(ptr);
}

static_assert(sizeof(::std::shared_ptr<::absl::lts_20230802::Status>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::absl::lts_20230802::Status>) == alignof(void *), "");
void cxxbridge1$shared_ptr$absl$lts_20230802$Status$null(::std::shared_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::absl::lts_20230802::Status>();
}
::absl::lts_20230802::Status *cxxbridge1$shared_ptr$absl$lts_20230802$Status$uninit(::std::shared_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::absl::lts_20230802::Status *uninit = reinterpret_cast<::absl::lts_20230802::Status *>(new ::rust::MaybeUninit<::absl::lts_20230802::Status>);
  ::new (ptr) ::std::shared_ptr<::absl::lts_20230802::Status>(uninit);
  return uninit;
}
void cxxbridge1$shared_ptr$absl$lts_20230802$Status$clone(::std::shared_ptr<::absl::lts_20230802::Status> const &self, ::std::shared_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::absl::lts_20230802::Status>(self);
}
::absl::lts_20230802::Status const *cxxbridge1$shared_ptr$absl$lts_20230802$Status$get(::std::shared_ptr<::absl::lts_20230802::Status> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$absl$lts_20230802$Status$drop(::std::shared_ptr<::absl::lts_20230802::Status> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::weak_ptr<::absl::lts_20230802::Status>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::weak_ptr<::absl::lts_20230802::Status>) == alignof(void *), "");
void cxxbridge1$weak_ptr$absl$lts_20230802$Status$null(::std::weak_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::absl::lts_20230802::Status>();
}
void cxxbridge1$weak_ptr$absl$lts_20230802$Status$clone(::std::weak_ptr<::absl::lts_20230802::Status> const &self, ::std::weak_ptr<::absl::lts_20230802::Status> *ptr) noexcept {
  ::new (ptr) ::std::weak_ptr<::absl::lts_20230802::Status>(self);
}
void cxxbridge1$weak_ptr$absl$lts_20230802$Status$downgrade(::std::shared_ptr<::absl::lts_20230802::Status> const &shared, ::std::weak_ptr<::absl::lts_20230802::Status> *weak) noexcept {
  ::new (weak) ::std::weak_ptr<::absl::lts_20230802::Status>(shared);
}
void cxxbridge1$weak_ptr$absl$lts_20230802$Status$upgrade(::std::weak_ptr<::absl::lts_20230802::Status> const &weak, ::std::shared_ptr<::absl::lts_20230802::Status> *shared) noexcept {
  ::new (shared) ::std::shared_ptr<::absl::lts_20230802::Status>(weak.lock());
}
void cxxbridge1$weak_ptr$absl$lts_20230802$Status$drop(::std::weak_ptr<::absl::lts_20230802::Status> *self) noexcept {
  self->~weak_ptr();
}

::std::vector<::absl::lts_20230802::Status> *cxxbridge1$std$vector$absl$lts_20230802$Status$new() noexcept {
  return new ::std::vector<::absl::lts_20230802::Status>();
}
::std::size_t cxxbridge1$std$vector$absl$lts_20230802$Status$size(::std::vector<::absl::lts_20230802::Status> const &s) noexcept {
  return s.size();
}
::absl::lts_20230802::Status *cxxbridge1$std$vector$absl$lts_20230802$Status$get_unchecked(::std::vector<::absl::lts_20230802::Status> *s, ::std::size_t pos) noexcept {
  return &(*s)[pos];
}
void cxxbridge1$std$vector$absl$lts_20230802$Status$push_back(::std::vector<::absl::lts_20230802::Status> *v, ::absl::lts_20230802::Status *value) noexcept {
  v->push_back(::std::move(*value));
  ::rust::destroy(value);
}
void cxxbridge1$std$vector$absl$lts_20230802$Status$pop_back(::std::vector<::absl::lts_20230802::Status> *v, ::absl::lts_20230802::Status *out) noexcept {
  ::new (out) ::absl::lts_20230802::Status(::std::move(v->back()));
  v->pop_back();
}
static_assert(sizeof(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>>) == alignof(void *), "");
void cxxbridge1$unique_ptr$std$vector$absl$lts_20230802$Status$null(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>>();
}
void cxxbridge1$unique_ptr$std$vector$absl$lts_20230802$Status$raw(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>> *ptr, ::std::vector<::absl::lts_20230802::Status> *raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>>(raw);
}
::std::vector<::absl::lts_20230802::Status> const *cxxbridge1$unique_ptr$std$vector$absl$lts_20230802$Status$get(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>> const &ptr) noexcept {
  return ptr.get();
}
::std::vector<::absl::lts_20230802::Status> *cxxbridge1$unique_ptr$std$vector$absl$lts_20230802$Status$release(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$std$vector$absl$lts_20230802$Status$drop(::std::unique_ptr<::std::vector<::absl::lts_20230802::Status>> *ptr) noexcept {
  ptr->~unique_ptr();
}
} // extern "C"
