#ifndef __AUTOCXXGEN_H__
#define __AUTOCXXGEN_H__

#include <memory>
#include <string>
#include "cxx.h"
#include <stddef.h>
#ifndef AUTOCXX_NEW_AND_DELETE_PRELUDE
#define AUTOCXX_NEW_AND_DELETE_PRELUDE
// Mechanics to call custom operator new and delete
template <typename T>
auto delete_imp(T *ptr, int) -> decltype((void)T::operator delete(ptr)) {
  T::operator delete(ptr);
}
template <typename T> void delete_imp(T *ptr, long) { ::operator delete(ptr); }
template <typename T> void delete_appropriately(T *obj) {
  // 0 is a better match for the first 'delete_imp' so will match
  // preferentially.
  delete_imp(obj, 0);
}
template <typename T>
auto new_imp(size_t count, int) -> decltype(T::operator new(count)) {
  return T::operator new(count);
}
template <typename T> void *new_imp(size_t count, long) {
  return ::operator new(count);
}
template <typename T> T *new_appropriately() {
  // 0 is a better match for the first 'delete_imp' so will match
  // preferentially.
  return static_cast<T *>(new_imp<T>(sizeof(T), 0));
}
#endif // AUTOCXX_NEW_AND_DELETE_PRELUDE
#include "ink_stroke_modeler/types.h"
#include "ink_stroke_modeler/params.h"
#include "ink_stroke_modeler/stroke_modeler.h"
#include "extras.h"

typedef int c_int;

inline std::unique_ptr<std::string> autocxx_make_string_0x2bea8d22859dde10(::rust::Str str) { return std::make_unique<std::string>(std::string(str)); }
inline ink::stroke_model::Vec2* Vec2_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<ink::stroke_model::Vec2>();; }
inline void Vec2_free_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Vec2* arg0)  { delete_appropriately<ink::stroke_model::Vec2>(arg0);; }
static_assert(::rust::IsRelocatable<ink::stroke_model::Vec2>::value, "type ink::stroke_model::Vec2 should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline ink::stroke_model::Input* Input_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<ink::stroke_model::Input>();; }
inline void Input_free_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Input* arg0)  { delete_appropriately<ink::stroke_model::Input>(arg0);; }
inline ink::stroke_model::Result* Result_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<ink::stroke_model::Result>();; }
inline void Result_free_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Result* arg0)  { delete_appropriately<ink::stroke_model::Result>(arg0);; }
inline ink::stroke_model::StrokeModeler* StrokeModeler_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<ink::stroke_model::StrokeModeler>();; }
inline void StrokeModeler_free_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler* arg0)  { delete_appropriately<ink::stroke_model::StrokeModeler>(arg0);; }
inline void ink_stroke_model_StrokeModeler_Reset_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& autocxx_gen_this, const ink::stroke_model::StrokeModelParams& arg1, absl::lts_20230802::Status* arg2)  { new(arg2) absl::lts_20230802::Status(autocxx_gen_this.Reset(arg1)); }
inline void Reset1_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& autocxx_gen_this, absl::lts_20230802::Status* arg1)  { new(arg1) absl::lts_20230802::Status(autocxx_gen_this.Reset()); }
inline void ink_stroke_model_StrokeModeler_Update_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& autocxx_gen_this, const ink::stroke_model::Input& arg1, std::vector<ink::stroke_model::Result>& arg2, absl::lts_20230802::Status* arg3)  { new(arg3) absl::lts_20230802::Status(autocxx_gen_this.Update(arg1, arg2)); }
inline void Predict_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& autocxx_gen_this, std::vector<ink::stroke_model::Result>& arg1, absl::lts_20230802::Status* arg2)  { new(arg2) absl::lts_20230802::Status(autocxx_gen_this.Predict(arg1)); }
inline void ink_stroke_model_StrokeModeler_Save_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& autocxx_gen_this)  { autocxx_gen_this.Save(); }
inline void ink_stroke_model_StrokeModeler_Restore_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& autocxx_gen_this)  { autocxx_gen_this.Restore(); }
inline BdWobbleSmootherParams* BdWobbleSmootherParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdWobbleSmootherParams>();; }
inline void BdWobbleSmootherParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams* arg0)  { delete_appropriately<BdWobbleSmootherParams>(arg0);; }
static_assert(::rust::IsRelocatable<BdWobbleSmootherParams>::value, "type BdWobbleSmootherParams should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline BdPositionModelerParams* BdPositionModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdPositionModelerParams>();; }
inline void BdPositionModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdPositionModelerParams* arg0)  { delete_appropriately<BdPositionModelerParams>(arg0);; }
static_assert(::rust::IsRelocatable<BdPositionModelerParams>::value, "type BdPositionModelerParams should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline BdSamplingParams* BdSamplingParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdSamplingParams>();; }
inline void BdSamplingParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdSamplingParams* arg0)  { delete_appropriately<BdSamplingParams>(arg0);; }
static_assert(::rust::IsRelocatable<BdSamplingParams>::value, "type BdSamplingParams should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline BdStylusStateModelerParams* BdStylusStateModelerParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdStylusStateModelerParams>();; }
inline void BdStylusStateModelerParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdStylusStateModelerParams* arg0)  { delete_appropriately<BdStylusStateModelerParams>(arg0);; }
static_assert(::rust::IsRelocatable<BdStylusStateModelerParams>::value, "type BdStylusStateModelerParams should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline BdKalmanPredictorConfidenceParams* BdKalmanPredictorConfidenceParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdKalmanPredictorConfidenceParams>();; }
inline void BdKalmanPredictorConfidenceParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorConfidenceParams* arg0)  { delete_appropriately<BdKalmanPredictorConfidenceParams>(arg0);; }
static_assert(::rust::IsRelocatable<BdKalmanPredictorConfidenceParams>::value, "type BdKalmanPredictorConfidenceParams should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline BdKalmanPredictorParams* BdKalmanPredictorParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdKalmanPredictorParams>();; }
inline void BdKalmanPredictorParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorParams* arg0)  { delete_appropriately<BdKalmanPredictorParams>(arg0);; }
static_assert(::rust::IsRelocatable<BdKalmanPredictorParams>::value, "type BdKalmanPredictorParams should be trivially move constructible and trivially destructible to be used with generate_pod! in autocxx");
inline BdStrokeModelParams* BdStrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<BdStrokeModelParams>();; }
inline void BdStrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10(BdStrokeModelParams* arg0)  { delete_appropriately<BdStrokeModelParams>(arg0);; }
inline void bd_stroke_model_params_new_w_stroke_end_predictor_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams arg0, BdPositionModelerParams arg1, BdSamplingParams arg2, BdStylusStateModelerParams arg3, BdStrokeModelParams* arg4)  { new(arg4) BdStrokeModelParams(bd_stroke_model_params_new_w_stroke_end_predictor(arg0, arg1, arg2, arg3)); }
inline void bd_stroke_model_params_new_w_kalman_predictor_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams arg0, BdPositionModelerParams arg1, BdSamplingParams arg2, BdStylusStateModelerParams arg3, BdKalmanPredictorParams arg4, BdStrokeModelParams* arg5)  { new(arg5) BdStrokeModelParams(bd_stroke_model_params_new_w_kalman_predictor(arg0, arg1, arg2, arg3, arg4)); }
inline void bd_stroke_model_params_new_w_disabled_predictor_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams arg0, BdPositionModelerParams arg1, BdSamplingParams arg2, BdStylusStateModelerParams arg3, BdStrokeModelParams* arg4)  { new(arg4) BdStrokeModelParams(bd_stroke_model_params_new_w_disabled_predictor(arg0, arg1, arg2, arg3)); }
inline void stroke_modeler_new_autocxx_wrapper_0x2bea8d22859dde10(BdStrokeModelParams* arg0, ink::stroke_model::StrokeModeler* arg1)  { new(arg1) ink::stroke_model::StrokeModeler(stroke_modeler_new(std::move(*arg0))); }
inline int stroke_modeler_reset_w_params_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& arg0, BdStrokeModelParams* arg1)  { return stroke_modeler_reset_w_params(arg0, std::move(*arg1)); }
inline int stroke_modeler_update_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler& arg0, ink::stroke_model::Input* arg1, std::vector<ink::stroke_model::Result>& arg2)  { return stroke_modeler_update(arg0, std::move(*arg1), arg2); }
inline void input_new_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Input::EventType arg0, ink::stroke_model::Vec2 arg1, double arg2, float arg3, float arg4, float arg5, ink::stroke_model::Input* arg6)  { new(arg6) ink::stroke_model::Input(input_new(arg0, arg1, arg2, arg3, arg4, arg5)); }
inline std::unique_ptr<std::vector<ink::stroke_model::Result>> results_new_autocxx_wrapper_0x2bea8d22859dde10()  { return std::make_unique<std::vector<ink::stroke_model::Result>>(results_new()); }
inline std::unique_ptr<ink::stroke_model::Result> result_make_unique_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Result* arg0)  { return result_make_unique(std::move(*arg0)); }
inline void ink_stroke_model_Vec2_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Vec2* autocxx_gen_this)  { new (autocxx_gen_this) ink::stroke_model::Vec2(); }
inline void ink_stroke_model_Vec2_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Vec2* autocxx_gen_this, ink::stroke_model::Vec2* arg1)  { new (autocxx_gen_this) ink::stroke_model::Vec2(std::move(*arg1)); }
inline void ink_stroke_model_Vec2_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Vec2* autocxx_gen_this, const ink::stroke_model::Vec2& arg1)  { new (autocxx_gen_this) ink::stroke_model::Vec2(arg1); }
inline void Vec2_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Vec2* arg0)  { { using ink::stroke_model::Vec2; arg0->Vec2::~Vec2(); }; }
inline void ink_stroke_model_Result_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Result* autocxx_gen_this)  { new (autocxx_gen_this) ink::stroke_model::Result(); }
inline void ink_stroke_model_Result_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Result* autocxx_gen_this, ink::stroke_model::Result* arg1)  { new (autocxx_gen_this) ink::stroke_model::Result(std::move(*arg1)); }
inline void ink_stroke_model_Result_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Result* autocxx_gen_this, const ink::stroke_model::Result& arg1)  { new (autocxx_gen_this) ink::stroke_model::Result(arg1); }
inline void Result_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Result* arg0)  { { using ink::stroke_model::Result; arg0->Result::~Result(); }; }
inline void BdWobbleSmootherParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams* autocxx_gen_this)  { new (autocxx_gen_this) BdWobbleSmootherParams(); }
inline void BdWobbleSmootherParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams* autocxx_gen_this, BdWobbleSmootherParams* arg1)  { new (autocxx_gen_this) BdWobbleSmootherParams(std::move(*arg1)); }
inline void BdWobbleSmootherParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams* autocxx_gen_this, const BdWobbleSmootherParams& arg1)  { new (autocxx_gen_this) BdWobbleSmootherParams(arg1); }
inline void BdWobbleSmootherParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdWobbleSmootherParams* arg0)  { arg0->BdWobbleSmootherParams::~BdWobbleSmootherParams(); }
inline void BdPositionModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdPositionModelerParams* autocxx_gen_this)  { new (autocxx_gen_this) BdPositionModelerParams(); }
inline void BdPositionModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdPositionModelerParams* autocxx_gen_this, BdPositionModelerParams* arg1)  { new (autocxx_gen_this) BdPositionModelerParams(std::move(*arg1)); }
inline void BdPositionModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdPositionModelerParams* autocxx_gen_this, const BdPositionModelerParams& arg1)  { new (autocxx_gen_this) BdPositionModelerParams(arg1); }
inline void BdPositionModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdPositionModelerParams* arg0)  { arg0->BdPositionModelerParams::~BdPositionModelerParams(); }
inline void BdSamplingParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdSamplingParams* autocxx_gen_this)  { new (autocxx_gen_this) BdSamplingParams(); }
inline void BdSamplingParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdSamplingParams* autocxx_gen_this, BdSamplingParams* arg1)  { new (autocxx_gen_this) BdSamplingParams(std::move(*arg1)); }
inline void BdSamplingParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdSamplingParams* autocxx_gen_this, const BdSamplingParams& arg1)  { new (autocxx_gen_this) BdSamplingParams(arg1); }
inline void BdSamplingParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdSamplingParams* arg0)  { arg0->BdSamplingParams::~BdSamplingParams(); }
inline void BdStylusStateModelerParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdStylusStateModelerParams* autocxx_gen_this)  { new (autocxx_gen_this) BdStylusStateModelerParams(); }
inline void BdStylusStateModelerParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdStylusStateModelerParams* autocxx_gen_this, BdStylusStateModelerParams* arg1)  { new (autocxx_gen_this) BdStylusStateModelerParams(std::move(*arg1)); }
inline void BdStylusStateModelerParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdStylusStateModelerParams* autocxx_gen_this, const BdStylusStateModelerParams& arg1)  { new (autocxx_gen_this) BdStylusStateModelerParams(arg1); }
inline void BdStylusStateModelerParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdStylusStateModelerParams* arg0)  { arg0->BdStylusStateModelerParams::~BdStylusStateModelerParams(); }
inline void BdKalmanPredictorConfidenceParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorConfidenceParams* autocxx_gen_this)  { new (autocxx_gen_this) BdKalmanPredictorConfidenceParams(); }
inline void BdKalmanPredictorConfidenceParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorConfidenceParams* autocxx_gen_this, BdKalmanPredictorConfidenceParams* arg1)  { new (autocxx_gen_this) BdKalmanPredictorConfidenceParams(std::move(*arg1)); }
inline void BdKalmanPredictorConfidenceParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorConfidenceParams* autocxx_gen_this, const BdKalmanPredictorConfidenceParams& arg1)  { new (autocxx_gen_this) BdKalmanPredictorConfidenceParams(arg1); }
inline void BdKalmanPredictorConfidenceParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorConfidenceParams* arg0)  { arg0->BdKalmanPredictorConfidenceParams::~BdKalmanPredictorConfidenceParams(); }
inline void BdKalmanPredictorParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorParams* autocxx_gen_this)  { new (autocxx_gen_this) BdKalmanPredictorParams(); }
inline void BdKalmanPredictorParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorParams* autocxx_gen_this, BdKalmanPredictorParams* arg1)  { new (autocxx_gen_this) BdKalmanPredictorParams(std::move(*arg1)); }
inline void BdKalmanPredictorParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorParams* autocxx_gen_this, const BdKalmanPredictorParams& arg1)  { new (autocxx_gen_this) BdKalmanPredictorParams(arg1); }
inline void BdKalmanPredictorParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdKalmanPredictorParams* arg0)  { arg0->BdKalmanPredictorParams::~BdKalmanPredictorParams(); }
inline void BdStrokeModelParams_new_autocxx_autocxx_wrapper_0x2bea8d22859dde10(BdStrokeModelParams* autocxx_gen_this)  { new (autocxx_gen_this) BdStrokeModelParams(); }
inline void BdStrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdStrokeModelParams* autocxx_gen_this, BdStrokeModelParams* arg1)  { new (autocxx_gen_this) BdStrokeModelParams(std::move(*arg1)); }
inline void BdStrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdStrokeModelParams* autocxx_gen_this, const BdStrokeModelParams& arg1)  { new (autocxx_gen_this) BdStrokeModelParams(arg1); }
inline void BdStrokeModelParams_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(BdStrokeModelParams* arg0)  { arg0->BdStrokeModelParams::~BdStrokeModelParams(); }
inline void ink_stroke_model_Input_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Input* autocxx_gen_this, ink::stroke_model::Input* arg1)  { new (autocxx_gen_this) ink::stroke_model::Input(std::move(*arg1)); }
inline void ink_stroke_model_Input_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Input* autocxx_gen_this, const ink::stroke_model::Input& arg1)  { new (autocxx_gen_this) ink::stroke_model::Input(arg1); }
inline void Input_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::Input* arg0)  { { using ink::stroke_model::Input; arg0->Input::~Input(); }; }
inline void StrokeModeler_synthetic_destructor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModeler* arg0)  { { using ink::stroke_model::StrokeModeler; arg0->StrokeModeler::~StrokeModeler(); }; }
inline ink::stroke_model::StrokeModelParams* StrokeModelParams_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<ink::stroke_model::StrokeModelParams>();; }
inline void StrokeModelParams_free_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModelParams* arg0)  { delete_appropriately<ink::stroke_model::StrokeModelParams>(arg0);; }
inline void ink_stroke_model_StrokeModelParams_new_synthetic_move_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModelParams* autocxx_gen_this, ink::stroke_model::StrokeModelParams* arg1)  { new (autocxx_gen_this) ink::stroke_model::StrokeModelParams(std::move(*arg1)); }
inline void ink_stroke_model_StrokeModelParams_new_synthetic_const_copy_ctor_0x2bea8d22859dde10_autocxx_wrapper_0x2bea8d22859dde10(ink::stroke_model::StrokeModelParams* autocxx_gen_this, const ink::stroke_model::StrokeModelParams& arg1)  { new (autocxx_gen_this) ink::stroke_model::StrokeModelParams(arg1); }
inline absl::lts_20230802::Status* Status_alloc_autocxx_wrapper_0x2bea8d22859dde10()  { return new_appropriately<absl::lts_20230802::Status>();; }
inline void Status_free_autocxx_wrapper_0x2bea8d22859dde10(absl::lts_20230802::Status* arg0)  { delete_appropriately<absl::lts_20230802::Status>(arg0);; }
inline void absl_lts_20230802_Status_new2_autocxx_wrapper_0x2bea8d22859dde10(absl::lts_20230802::Status* autocxx_gen_this, const absl::lts_20230802::Status& arg1)  { new (autocxx_gen_this) absl::lts_20230802::Status(arg1); }
inline void absl_lts_20230802_Status_new3_autocxx_wrapper_0x2bea8d22859dde10(absl::lts_20230802::Status* autocxx_gen_this, absl::lts_20230802::Status* arg1)  { new (autocxx_gen_this) absl::lts_20230802::Status(std::move(*arg1)); }
#endif // __AUTOCXXGEN_H__
