
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rnnoise_data.h"


#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_weights_float_DEFINED
#define WEIGHTS_conv1_weights_float_TYPE WEIGHT_TYPE_float
static const float conv1_weights_float[24960] = {
    0.017067527398467064, -0.0075201536528766155, -0.004641992039978504, 0.003118357388302684, 0.007930063642561436, -0.04757816717028618, 0.027245942503213882, -0.058781709522008896,
    -0.04250109940767288, -0.00456750625744462, 0.016618963330984116, -0.015199024230241776, 0.06048556789755821, 0.03194425255060196, 0.06064014136791229, 0.05970624089241028,
    0.01130896620452404, -0.001807725871913135, -0.006320847664028406, 0.025784334167838097, 0.03459395468235016, -0.039262887090444565, 0.031072838231921196, -0.027256986126303673,
    -0.03999316319823265, 0.0164959579706192, -0.014000890776515007, -0.0629119724035263, 0.0207250714302063, 0.051833510398864746, -0.0070905741304159164, 0.0027564342599362135,
    0.011550871655344963, 0.01938730664551258, 0.025868520140647888, 0.05988603085279465, -0.011479596607387066, -0.013402817770838737, 0.02675125002861023, -0.03325110673904419,
    -0.044895801693201065, -0.0019379912409931421, 0.0030525897163897753, -0.056626491248607635, -0.08306550979614258, 0.011977829039096832, -0.12744168937206268, -0.017554515972733498,
    -0.008490747772157192, -0.09090171754360199, -0.012199737131595612, 0.08705215156078339, 0.005497656296938658, 0.04583197087049484, -0.044803500175476074, -0.02210887335240841,
    -0.07484690845012665, -0.01989956758916378, -0.023241076618433, -0.1165221631526947, 0.16566267609596252, 0.016500990837812424, -0.029439009726047516, 0.024810699746012688,
    0.023893848061561584, -0.058041125535964966, -0.017588166519999504, 0.03199947997927666, 0.014394555240869522, -0.0427137054502964, -0.017908820882439613, -0.05435529351234436,
    -0.006833154242485762, -0.03487752750515938, 0.019758861511945724, 0.02732403576374054, 0.06692714244127274, 0.01815481297671795, 0.09394443780183792, 0.026075147092342377,
    -0.005495466757565737, -0.06199938431382179, -0.016809457913041115, 0.04281154274940491, -0.0331311859190464, 0.09776781499385834, -0.10349451750516891, -0.04535288363695145,
    -0.0175930168479681, 0.043771255761384964, 0.003200017847120762, -0.047546107321977615, 0.04964360594749451, -0.003108870005235076, 0.015285782516002655, -0.00020159738778602332,
    0.03287887200713158, -0.06268925964832306, -0.12507113814353943, -0.0044255307875573635, 0.11522523313760757, -0.01226806826889515, 0.041270650923252106, 0.00013585842680186033,
    0.008941605687141418, -0.03953743353486061, 0.0066193281672894955, 0.13030432164669037, 0.06583581864833832, 0.03128695487976074, -0.01765059307217598, 0.007956290617585182,
    -0.1233857274055481, -0.07752712815999985, -0.0018903790041804314, -0.07837482541799545, -0.05796122923493385, -0.014670690521597862, 0.012251162901520729, -0.013188525103032589,
    -0.0019845732022076845, 0.06570489704608917, -0.040558964014053345, -0.021815476939082146, -0.018174776807427406, -0.03940766304731369, 0.03281994163990021, -0.08661500364542007,
    0.056666549295186996, -0.040104351937770844, 0.034756992012262344, -0.006996986921876669, -0.03805800527334213, 0.018626220524311066, 0.015320027247071266, -0.018687298521399498,
    -0.07234373688697815, -0.07004222273826599, 0.031841080635786057, 0.01285267248749733, 0.015615652315318584, -0.017254626378417015, 0.04602619633078575, -0.05215892195701599,
    0.05947883799672127, -0.002955301431939006, 0.08592528104782104, -0.025729583576321602, -0.003995742183178663, -0.0658951848745346, 0.07702983915805817, 0.025051457807421684,
    0.007831241004168987, 0.03064187802374363, 0.021163757890462875, 0.07133466750383377, 0.0016592543106526136, 0.010233646258711815, -0.036707568913698196, 0.017396507784724236,
    -0.006465650629252195, -0.017947841435670853, -0.009166496805846691, 0.07701452821493149, 0.0153252724558115, 0.043578535318374634, 0.07800809293985367, -0.03793419152498245,
    0.020713992416858673, 0.04830608889460564, -0.0194970965385437, -0.0433582179248333, 0.06807548552751541, -0.03270381689071655, 0.08384036272764206, 0.050760652869939804,
    0.020517952740192413, -0.070602647960186, -0.050636112689971924, -0.03595026209950447, -0.004638501442968845, 0.12363727390766144, -0.09452686458826065, 0.014301523566246033,
    0.0021892415825277567, -0.009174766018986702, 0.03255457058548927, -0.07259976863861084, -0.034242548048496246, -0.02236516959965229, -0.022449053823947906, 0.020966248586773872,
    0.029756590723991394, -0.041784219443798065, -0.0044095697812736034, 0.026833737269043922, 0.0003754550125449896, 0.05746478587388992, -0.009739553555846214, 0.02949981577694416,
    0.017181336879730225, 0.02702164091169834, 0.012777877040207386, 0.02035016380250454, -0.05259073153138161, -0.037682972848415375, 0.04029162973165512, 0.0014618032146245241,
    -0.048450976610183716, 0.021254941821098328, 0.007073278538882732, 0.013242061249911785, 0.0637165755033493, 0.020039547234773636, -0.05688896402716637, -0.08401686698198318,
    -0.006352518685162067, 0.016188308596611023, -0.015045931562781334, 0.05342170223593712, -0.008018645457923412, -0.005790251307189465, 0.0486861914396286, 0.018422013148665428,
    0.046293653547763824, -0.013143873773515224, 0.04211192950606346, -0.011591046117246151, 0.06302523612976074, 0.012978334911167622, 0.02533559501171112, 0.0036832469049841166,
    -0.03227176144719124, 0.01415002066642046, 0.00906218308955431, 0.11442038416862488, -0.09040628373622894, -0.009918770752847195, -0.06207247078418732, -0.04007014259696007,
    -0.20302307605743408, 0.04508329927921295, -0.013372965157032013, 0.034609355032444, 0.014536645263433456, -0.037746280431747437, -0.06946118921041489, -0.010904494673013687,
    -0.00916423462331295, -0.03992898762226105, -0.027865227311849594, -0.003926893230527639, -0.01487791258841753, 0.029879439622163773, -0.0336240753531456, -0.0008041657274588943,
    0.038125570863485336, -0.08523451536893845, -0.014954824000597, -0.04978681728243828, -0.05313912779092789, 0.045395635068416595, 0.07125388830900192, 0.02347843535244465,
    0.04491865262389183, -0.016287483274936676, 0.004267233423888683, -0.02732202038168907, -0.006278051529079676, -0.08225098252296448, 0.009819683618843555, 0.09379643946886063,
    -0.0001232670183526352, -0.019285455346107483, -0.06283347308635712, -0.01980285346508026, -0.021808121353387833, 0.053720854222774506, -0.0013472592690959573, 0.0029614553786814213,
    0.011219209991395473, -0.07434139400720596, -0.02469658851623535, 0.04646073654294014, 0.07229986786842346, 0.04012773185968399, -0.015145808458328247, 0.04733544588088989,
    -0.010851167142391205, -0.052182722836732864, 0.08475326001644135, 0.026024863123893738, -0.0018572439439594746, -0.05121581628918648, 0.018115904182195663, -0.007734646555036306,
    -0.027704481035470963, 0.04081578180193901, -0.01677200384438038, 0.03161365166306496, 0.002750249346718192, -0.0022123921662569046, -0.0738799199461937, -0.03564099222421646,
    0.023967817425727844, 0.025053512305021286, -0.026020659133791924, 0.06934358179569244, -0.0073950220830738544, -0.0519658699631691, -0.004143245983868837, -0.0014055832289159298,
    0.07706207782030106, -0.00723298080265522, -0.023669203743338585, 0.1366502046585083, -0.13767880201339722, -0.04113408550620079, 0.032280340790748596, -0.06524298340082169,
    -0.061147477477788925, -0.032700635492801666, -0.020603889599442482, 0.00104508176445961, 0.026289042085409164, 0.01561687607318163, 0.0032073287293314934, 0.04615490138530731,
    0.025989193469285965, -0.0604148805141449, -8.664008782943711e-05, -0.0070301746018230915, -0.02013900876045227, 0.0822862833738327, -0.045252345502376556, 0.010582328774034977,
    0.03726879134774208, 0.034397535026073456, -0.002237277338281274, 0.008027243427932262, 0.05005273222923279, 0.004636405035853386, -0.0550849549472332, -0.0022283054422587156,
    0.022153450176119804, 0.0419180728495121, -0.02982473373413086, -0.034104008227586746, -0.11392366141080856, 0.05393396317958832, -0.0037459793966263533, 0.09340675920248032,
    -0.08375167101621628, -0.023899095132946968, 0.05006250739097595, -0.021984005346894264, -0.025465339422225952, -0.0065496088936924934, -0.06543637067079544, 0.030339568853378296,
    0.06061937287449837, 0.08087268471717834, -0.009180685505270958, 0.08648819476366043, -0.05735556781291962, 0.04315461590886116, 0.010109052993357182, -0.02489919774234295,
    0.03415096178650856, -0.036725033074617386, -0.005248628091067076, -0.048235390335321426, 0.04593051224946976, -0.08635451644659042, -0.007875636219978333, 0.06415502727031708,
    -0.04965560510754585, 0.10815900564193726, -0.023982420563697815, 0.03822923079133034, 0.010517574846744537, -0.025241339579224586, 0.006105267908424139, -0.019890690222382545,
    0.10333722829818726, 0.009463788010179996, 0.06789916008710861, 0.013596630655229092, -0.03818737342953682, 0.0359995998442173, -0.03255708888173103, 0.026521962136030197,
    0.028178885579109192, 0.06296474486589432, -0.018065301701426506, 0.010473902337253094, -0.00587108638137579, 1.813337621570099e-05, -0.12192954868078232, 0.0904402807354927,
    0.046065010130405426, 0.028307363390922546, -0.004258437547832727, 0.034422602504491806, -0.010124864988029003, -0.09436263889074326, -0.122008316218853, -0.023489555343985558,
    -0.06975235790014267, 0.007949764840304852, -0.014363361522555351, 0.08404510468244553, 0.00415752362459898, -0.008626511320471764, 0.04890643060207367, -0.0169692263007164,
    -0.027723757550120354, -0.07394617050886154, -0.016378510743379593, -0.01312238723039627, -0.025171473622322083, -0.026142021641135216, 0.032316748052835464, 0.010206988081336021,
    0.012052892707288265, -0.05144692212343216, -0.008106488734483719, -0.010772336274385452, -0.05380132421851158, -0.07050475478172302, -0.029269857332110405, -0.02066098526120186,
    -0.025305772200226784, 0.020823724567890167, -0.07045385241508484, 0.013145701959729195, 0.017071623355150223, -0.05146273225545883, -0.05348343774676323, 0.025577519088983536,
    -0.00139673613011837, 0.012006308883428574, 0.015129582025110722, -0.02084086276590824, 0.04162249341607094, -0.01347898319363594, 0.015163072384893894, 0.05652904137969017,
    0.0446067750453949, 0.12849104404449463, -0.0628960058093071, 0.03840458765625954, 0.0039866832084953785, -0.007909963838756084, -0.039329737424850464, -0.03171854093670845,
    -0.043580006808042526, 0.020233601331710815, -0.00952962413430214, 0.05069613829255104, -0.039645321667194366, 0.001174254692159593, -0.016958054155111313, -0.027903562411665916,
    -0.0355493426322937, -0.0038989451713860035, 0.04365377500653267, -0.0060323686338961124, -0.054615411907434464, -0.008725576102733612, 0.043010737746953964, -0.010906502604484558,
    0.01947830058634281, 0.08709561079740524, 0.031692806631326675, 0.09907978028059006, 0.03377656266093254, 0.0260359775274992, 0.006338734179735184, -0.019959239289164543,
    -0.08946377784013748, -0.0073864455334842205, -0.15329426527023315, 0.017869649454951286, 0.01810905896127224, -0.03307364881038666, 0.08793262392282486, -0.005825376138091087,
    -0.029502013698220253, 0.006687430664896965, -0.03707011416554451, -0.023735368624329567, 0.08755191415548325, 0.04096467047929764, -0.002990532200783491, 0.03481287136673927,
    0.024398256093263626, 0.05466083809733391, -0.000859878200571984, -0.05571391433477402, 0.00036600511521101, -0.008032645098865032, -0.021417753770947456, 0.07693352550268173,
    0.03533005714416504, -0.0562145859003067, -0.003345569595694542, 0.0028612343594431877, 0.040780577808618546, -0.023584827780723572, -0.038021672517061234, 0.011381609365344048,
    -0.045908477157354355, -0.004584841430187225, -0.0014370277058333158, 0.08647330850362778, -0.015317513607442379, -0.055577125400304794, 0.018601108342409134, 0.015124470926821232,
    -0.027152447029948235, -0.04253007099032402, -0.008762059733271599, -0.005470105912536383, 0.024789096787571907, 0.09968028217554092, -0.022201087325811386, -0.09958170354366302,
    0.050703611224889755, -0.0287419855594635, 0.04270603507757187, -0.0816933810710907, 0.018675871193408966, 0.12212598323822021, 0.1422845870256424, 0.06386247277259827,
    0.005804219748824835, 0.11088257282972336, -0.019130751490592957, 0.01498628780245781, -0.02072860859334469, -0.0030397975351661444, 0.05722789466381073, 0.03400192782282829,
    0.03183724731206894, 0.008065315894782543, 0.04485626146197319, 0.03682776540517807, 0.01567310094833374, 0.038740307092666626, 0.026355329900979996, 0.05052369460463524,
    0.025866467505693436, -0.06915062665939331, 0.04513213410973549, -0.13849538564682007, -0.035427242517471313, -0.0026294540148228407, 0.0029853610321879387, 0.06529980897903442,
    -0.0605388805270195, -0.04581792652606964, -0.0758637934923172, -0.009713232517242432, 0.05609956756234169, 0.07519620656967163, -0.0785006508231163, -0.009365553967654705,
    0.00854772049933672, 0.014828139916062355, 0.0411657989025116, -0.008696645498275757, 0.07445160299539566, -0.03339296951889992, -0.024625178426504135, -0.024551156908273697,
    0.008612717501819134, 0.0854223221540451, 0.12739665806293488, -0.027692602947354317, -0.022792186588048935, 0.06987474858760834, 0.014573698863387108, 0.06448696553707123,
    0.00016237868112511933, -0.006589432246983051, -0.0007412872510030866, -6.373284850269556e-05, -0.08467608690261841, 0.02484971657395363, -0.011020654812455177, 0.028173649683594704,
    0.07917885482311249, -0.03907204046845436, -0.06389632076025009, 0.002732040360569954, 0.0011331127025187016, -0.04293294996023178, 0.03461575135588646, 0.026644056662917137,
    0.009626375511288643, -0.04701875150203705, -0.02686115726828575, 0.009531339630484581, -0.051317062228918076, -0.08424045890569687, 0.05112266167998314, 0.03271958604454994,
    0.047872621566057205, -0.023362116888165474, 0.03206567466259003, -0.012620175257325172, -0.04145655781030655, -0.019897596910595894, 0.040208227932453156, 0.011848862282931805,
    0.00965800415724516, -0.06498558819293976, 0.032167647033929825, 0.02204245701432228, -0.03469767048954964, -0.02636479213833809, -0.08833025395870209, -0.011409804224967957,
    -0.08785875886678696, -0.020160317420959473, 0.012067688629031181, 0.021168813109397888, 0.004365221597254276, 0.04199173301458359, 0.006336046848446131, -0.02012631483376026,
    0.02712741494178772, 0.05583810806274414, 0.005105899181216955, -0.01004632655531168, -0.01213011983782053, -0.034571725875139236, 0.00451995711773634, -0.029110383242368698,
    0.014980011619627476, -0.035844989120960236, -0.006677974481135607, 0.015909507870674133, 0.0495317280292511, 0.06857794523239136, 0.13631343841552734, -0.0035652611404657364,
    -0.025516385212540627, -0.04422968253493309, -0.0482889823615551, 0.02700015716254711, -0.03235921263694763, -0.10369694977998734, 0.10138903558254242, -0.023449787870049477,
    0.03917854279279709, -0.007966435514390469, -0.09831888973712921, 0.049296289682388306, -0.103849858045578, -0.015424046665430069, -0.07046183943748474, 0.06686116755008698,
    0.044691577553749084, -0.04376913607120514, -0.019269999116659164, -0.10122408717870712, 0.0491081140935421, 0.06481778621673584, 0.002408369444310665, 0.07606489956378937,
    -0.01684563048183918, 0.03634602576494217, 0.0471809059381485, 0.0894014909863472, 0.0075522130355238914, -0.08384526520967484, 0.0008724711951799691, -0.0001733067474560812,
    0.0037086419761180878, 0.03988692909479141, -0.0654224082827568, 0.011924099177122116, -0.03799079731106758, -0.029476141557097435, 0.03618704900145531, 0.03763331472873688,
    0.023366428911685944, -0.07335115969181061, 0.005151162855327129, 0.035511117428541183, -0.08009320497512817, 0.002766395453363657, 0.06432371586561203, -0.0275155957788229,
    0.11147236078977585, 0.03266865387558937, 0.1350812017917633, -0.019751721993088722, 0.014028873294591904, 0.03723232075572014, 0.04889431595802307, 0.029074780642986298,
    0.00576892402023077, -0.051424503326416016, -0.0664563849568367, 0.05492760241031647, -0.0020407792180776596, -0.025736374780535698, -0.052699293941259384, -0.09216252714395523,
    -0.010350894182920456, -0.05132551118731499, -0.023942522704601288, -0.057385172694921494, -0.038129404187202454, 0.07761234790086746, 0.10040800273418427, 0.022122269496321678,
    0.04136652126908302, 0.03403327241539955, 0.036389920860528946, 0.07721403986215591, 0.06717228889465332, -0.04400733858346939, -0.03820673003792763, 0.03595636785030365,
    -0.012672393582761288, 0.04012809321284294, -0.02326037921011448, 0.015774071216583252, -0.025684744119644165, -0.03982444480061531, -0.01710204966366291, -0.016599558293819427,
    -0.039749886840581894, -0.004104109946638346, 0.02209831401705742, 0.036146048456430435, 0.0033277145121246576, -0.015806162729859352, -0.07244862616062164, 6.731024041073397e-05,
    0.024094806984066963, -0.008857088163495064, 0.000155794492457062, -0.010288788005709648, -0.04195578023791313, 0.005713393911719322, 0.033666398376226425, -0.03667342662811279,
    0.03710213303565979, 0.015303394757211208, -0.06059907004237175, -0.04432439059019089, -0.04690329730510712, -0.03970670700073242, -0.018844397738575935, -0.08576604723930359,
    0.013018484227359295, 0.04097716510295868, 0.026411674916744232, -0.06014803797006607, -0.016948271542787552, -0.0006752867484465241, -0.10899696499109268, -0.03900530934333801,
    -0.0004657487734220922, 0.050128694623708725, 0.11478954553604126, -0.010944967158138752, 0.00381723465397954, -0.004202253185212612, -0.07228224724531174, 0.04506705701351166,
    0.00849927868694067, 0.019941002130508423, 0.050285108387470245, -0.00824684090912342, 0.013927746564149857, 0.016684887930750847, -0.083956278860569, 0.021541357040405273,
    -0.004243329633027315, 0.03273008018732071, 0.12504710257053375, -0.015356842428445816, 0.002876162063330412, -0.08773235231637955, -0.03763319551944733, 0.0050999172963202,
    0.03328149393200874, 0.08210642635822296, -0.04766945168375969, 0.013408089987933636, 0.023435404524207115, -0.0720428079366684, -0.015103978104889393, 0.004877147264778614,
    0.011692707426846027, -0.08748164027929306, -0.03528572618961334, -0.05790940672159195, -0.05603567138314247, 0.06023363769054413, 0.015223165042698383, 0.020556392148137093,
    0.07429936528205872, 0.0012101589236408472, 0.04750853031873703, -0.02247494086623192, -0.012312861159443855, -0.017720749601721764, -0.028544772416353226, -0.016841042786836624,
    -0.010633495636284351, -0.003974375780671835, -0.010239146649837494, 0.0047134836204349995, 0.03679963946342468, 0.029598986729979515, 0.006582001689821482, 0.04717700555920601,
    -0.0019926668610423803, -0.011621436104178429, -0.02931112051010132, -0.020559951663017273, -0.03484643995761871, -0.05543028563261032, -0.005253315903246403, 0.016477737575769424,
    -0.014546694234013557, -0.003075100015848875, -0.009303304366767406, 0.05778781324625015, 0.0023950296454131603, 0.07289236783981323, 0.05087529122829437, -0.05237741023302078,
    -0.059754855930805206, 0.046604230999946594, 0.031870678067207336, 0.03045484982430935, -0.008985846303403378, -0.0559522844851017, -0.12395162135362625, 0.025853976607322693,
    -0.01932724565267563, -0.02451685257256031, -0.05787935107946396, 0.05052575841546059, -0.04952770844101906, -0.07457584887742996, -0.0711163803935051, 0.0013588503934442997,
    0.0020204714965075254, -0.01239236444234848, -0.04287736117839813, 0.036783553659915924, -0.0010758733842521906, 0.009854105301201344, -0.0763918086886406, 0.11095339804887772,
    0.1046668142080307, -0.06079252436757088, -0.048115964978933334, 0.041954148560762405, -0.026338739320635796, -0.002987201325595379, 0.011871020309627056, 0.006205156911164522,
    -0.037859849631786346, 0.05763571336865425, -0.021583721041679382, -0.02881104312837124, 0.1030803993344307, -0.014297423884272575, -0.06843802332878113, -0.0790664479136467,
    -0.003501306287944317, -0.036285992711782455, 0.06396361440420151, 0.07467847317457199, -0.030328817665576935, 0.05634355545043945, 0.0352979451417923, 0.04325283318758011,
    -0.04251043498516083, -0.06881511956453323, -0.007674034219235182, 0.02889762446284294, 0.030990594998002052, -0.0048540448769927025, -0.0025494806468486786, -0.023580970242619514,
    0.007817288860678673, 0.0045708660036325455, -0.0170605331659317, 0.009080610238015652, -0.0067086732015013695, -0.02962697483599186, -0.022621899843215942, -0.006117370445281267,
    0.026987850666046143, -0.01409116294234991, -0.015076914802193642, -0.03894264996051788, -0.006979002151638269, 0.04887447506189346, 0.0230580884963274, 0.00848734937608242,
    -0.007065647281706333, -0.03831685334444046, -0.05445726960897446, 0.015366092324256897, 0.00946644227951765, 0.0208904966711998, 0.07072070986032486, -0.033027444034814835,
    -0.0642206072807312, -0.03883066773414612, 0.012867281213402748, -0.013860305771231651, -0.06783249229192734, 0.07386932522058487, -0.009062368422746658, -0.05170222744345665,
    -0.0007520524668507278, 0.020415451377630234, -0.06778126955032349, -0.01699797250330448, 0.03870946913957596, -0.056792277842760086, 0.018508082255721092, -0.027804380282759666,
    -0.041243840008974075, 0.08213989436626434, -0.008039490319788456, -0.056575946509838104, -0.051439546048641205, -0.032207731157541275, -0.00883196759968996, 0.0577736496925354,
    -0.0337970107793808, -0.01656455174088478, -0.05426982045173645, -0.03034130670130253, 0.07413670420646667, -0.003528555855154991, -0.06824344396591187, -0.02589544840157032,
    -0.009476548060774803, 0.019951052963733673, -0.0012911721132695675, 0.06670814752578735, -0.023633526638150215, 0.0055222222581505775, 0.10136767476797104, 0.008390126749873161,
    -0.050987359136343, -0.0626666471362114, -0.012899933382868767, 0.007874435745179653, -0.02672453038394451, -0.0555478073656559, -0.025840457528829575, 0.0918242335319519,
    0.044945262372493744, 0.047988321632146835, -0.040085431188344955, 0.03656945750117302, 0.09821730107069016, 9.841995779424906e-05, 0.033628299832344055, 0.019834991544485092,
    0.02379348687827587, 0.03313432261347771, 0.04415715113282204, -0.06177645921707153, -0.023477094247937202, 0.03248557448387146, 0.03190537542104721, 0.02981601096689701,
    0.053574979305267334, -0.039280444383621216, 0.054934293031692505, 0.0642140582203865, 0.049842994660139084, 0.0485786497592926, 0.015343356877565384, 0.028299201279878616,
    -0.10865610092878342, 0.015766525641083717, -0.0574253611266613, -0.031569160521030426, 0.006361623760312796, 0.011259753257036209, -0.0025338209234178066, 0.010017823427915573,
    -0.020003272220492363, 0.011170677840709686, -0.02135077863931656, -0.04685378819704056, -0.026899412274360657, -0.009152999147772789, -0.036779243499040604, -0.0029083320405334234,
    -0.05843772739171982, -0.044814158231019974, -0.0696430578827858, -0.022959601134061813, 0.0010324547765776515, -0.006513874512165785, -0.05080119147896767, -0.06932909041643143,
    0.02825310081243515, 0.0803850069642067, -0.005635671317577362, 0.023053880780935287, -0.04270155355334282, -0.0028923575300723314, -0.0028982048388570547, 0.06921922415494919,
    -0.04966586455702782, 0.02122925966978073, -0.08302527666091919, 0.04280722886323929, -0.04935011640191078, 0.04866534471511841, 0.012115176767110825, -0.03941697999835014,
    -0.005564246326684952, -0.0015633509028702974, -0.037038691341876984, 0.022662630304694176, -0.038577355444431305, 0.032975032925605774, -0.07601412385702133, 0.06822337955236435,
    0.03752373531460762, 0.0285368449985981, -0.0793619230389595, -0.025225618854165077, -0.049633853137493134, -0.10219499468803406, 0.015815356746315956, 0.040454793721437454,
    0.11625445634126663, 0.005700197536498308, -0.04211808741092682, 0.05049634724855423, 0.07530394196510315, 0.05735267326235771, 0.01031715888530016, 0.011612333357334137,
    -0.030090902000665665, -0.0066625801846385, -0.01651756465435028, 0.022941336035728455, -0.010174794122576714, -0.004338088445365429, 0.028403785079717636, -0.037200383841991425,
    0.038101404905319214, -0.05693430081009865, -0.013953888788819313, 0.01889706216752529, 0.022866077721118927, 0.02764166332781315, 0.011201679706573486, -0.027383433654904366,
    0.003462286200374365, 0.03382771462202072, -0.00739325163885951, 0.020060429349541664, -0.017598221078515053, 0.0457550585269928, -0.09744948893785477, 0.03447515517473221,
    0.009204928763210773, 0.0229184553027153, 0.02008436806499958, -0.06685712933540344, 0.039957113564014435, 0.013486655429005623, 0.006838142406195402, 0.03300175815820694,
    0.022947212681174278, -0.07831764221191406, 0.03676394373178482, 0.03920523449778557, 0.02031976729631424, -0.01616712100803852, -0.048491470515728, -0.050401102751493454,
    0.012699455954134464, -0.07456214725971222, -0.006911827716976404, -0.008336974307894707, 0.022980382665991783, 0.011164875701069832, 0.05128226429224014, 0.035834718495607376,
    -0.007719231769442558, -0.04753968492150307, -0.06007156893610954, -0.07224121689796448, -0.003673447063192725, -0.051683515310287476, 0.026395076885819435, -0.0010135035263374448,
    -0.010647574439644814, -0.030375543981790543, -0.021740660071372986, 0.004036537371575832, -0.009934778325259686, 0.021487358957529068, -0.05923200026154518, -0.04403864964842796,
    -0.013061967678368092, 0.009422680363059044, 0.05149435997009277, 0.046604011207818985, 0.0014475076459348202, 0.015810856595635414, -0.016005462035536766, 0.0021970104426145554,
    -0.009431085549294949, -0.022807404398918152, 0.0859566256403923, -0.010653650388121605, -0.02862975001335144, 0.023061338812112808, -0.09329574555158615, 0.012613190338015556,
    0.017623478546738625, -0.03277483955025673, -0.023421550169587135, -0.039372436702251434, 0.07260424643754959, -0.017345525324344635, -0.01806941069662571, -0.08148445188999176,
    -0.005019360687583685, -0.07152004539966583, 0.01000332459807396, 0.07113014906644821, -0.04099981486797333, -0.005206161644309759, -0.02866661176085472, -0.059947673231363297,
    0.0003990638942923397, -0.02876749075949192, -0.024706987664103508, -0.04809436574578285, 0.015858018770813942, 0.026397719979286194, -0.06867697089910507, 0.01919928379356861,
    0.0026810206472873688, 0.003965994343161583, 0.08591241389513016, 0.02093728817999363, -0.015298613347113132, -0.0036397443618625402, 0.06828027963638306, -0.06332855671644211,
    0.009488463401794434, -0.02771567367017269, 0.03460206836462021, -0.013323508203029633, 0.06340154260396957, 0.017611278221011162, -0.027993706986308098, -0.06958837062120438,
    0.033625226467847824, 0.007061163429170847, -0.017055297270417213, -0.01801491528749466, -0.07212408632040024, -0.041763003915548325, 0.0319753997027874, -0.0035248734056949615,
    0.04476255178451538, -0.038553137332201004, 0.0033217158634215593, -0.0710863322019577, 0.05520806461572647, -0.02444801852107048, 0.021326104179024696, -0.03154783695936203,
    0.004067126661539078, 0.06122554838657379, 0.020309189334511757, -0.017506780102849007, -0.0064628547988832, 0.0038737202994525433, -0.03331884369254112, 0.047503795474767685,
    0.00057583226589486, -0.06629223376512527, -0.01705373264849186, -0.01405936386436224, 0.0169842466711998, 0.01576950214803219, -0.07768736779689789, 0.009725305251777172,
    -0.0020525723230093718, 0.00936993956565857, 0.008055035956203938, -0.07550659030675888, -0.025565916672348976, -0.013886166736483574, -0.18307721614837646, -0.011636613868176937,
    0.06027107685804367, 0.04749792441725731, -0.0049134488217532635, -0.06239152327179909, -0.01718246564269066, -0.016301600262522697, 0.06078839302062988, -0.07179398834705353,
    -0.043461874127388, 0.009046962484717369, 0.00249846326187253, 0.05320658162236214, -0.004944643005728722, -0.021015184000134468, -0.10224047303199768, -0.03357325494289398,
    0.09347467124462128, 0.028189722448587418, 0.02706364542245865, 0.03533143550157547, -0.013913286849856377, -0.041759178042411804, -0.04981156066060066, -0.06776631623506546,
    -0.0010044299997389317, 0.04982108622789383, 0.014390618540346622, -0.07535809278488159, -0.07175992429256439, 0.03703835979104042, -0.08515668660402298, -0.010759050026535988,
    0.12748628854751587, 0.055514756590127945, -0.02323491871356964, 0.053472984582185745, 0.010028371587395668, -0.00896674208343029, 0.006386605091392994, -0.01246105320751667,
    -0.002872403711080551, -0.02052329294383526, 0.0016712064389139414, 0.015568391419947147, -0.002662481041625142, 0.008486528880894184, -0.05965956300497055, 0.01921730302274227,
    0.01944076456129551, 0.006694498937577009, -0.020329289138317108, 0.03194274753332138, 0.01580050215125084, 0.048038411885499954, -0.026827124878764153, 0.03741966187953949,
    -0.06104671210050583, 0.07811758667230606, -0.027577368542551994, -0.024295998737215996, 0.007849625311791897, 0.02521485649049282, 0.04751783236861229, -0.013508048839867115,
    0.02567005157470703, 0.0185661893337965, 0.0083901546895504, -0.03031449019908905, -0.060181472450494766, 0.011574075557291508, -0.027072923257946968, 0.016145803034305573,
    -0.014424841850996017, 0.013143048621714115, -0.07586266845464706, -0.04913982003927231, -0.050296600908041, 0.046512022614479065, -0.018536273390054703, -0.031082095578312874,
    0.048461101949214935, 0.040705788880586624, -0.03603637218475342, 0.05213133990764618, 0.008035792969167233, 0.09399303793907166, -0.0005301694618538022, 0.05099199712276459,
    -0.03304737061262131, 0.01742940954864025, -0.06469156593084335, 0.026676002889871597, 0.06606514006853104, 0.02434384636580944, -0.014132763259112835, 0.027140114456415176,
    0.009401680901646614, 0.0643080323934555, -0.030816491693258286, -0.05103046074509621, -0.02401859126985073, 0.050187963992357254, -0.022720109671354294, 0.002646347042173147,
    -0.016380127519369125, 0.06657959520816803, 0.013248334638774395, 0.012597983703017235, -0.07431842386722565, -0.018195079639554024, 0.020159965381026268, 0.059573590755462646,
    0.045163486152887344, -0.047534726560115814, 0.01965968683362007, 0.025529012084007263, 0.020406218245625496, -0.002921909326687455, -0.03586411848664284, -0.023216191679239273,
    0.06468835473060608, 0.0404525063931942, 0.08028797805309296, 0.0748334601521492, 0.04902645945549011, 0.014791237190365791, 0.070954829454422, 0.0486355721950531,
    0.004507611971348524, -0.009457970969378948, -0.058683909475803375, 0.0129599804058671, 0.005078175105154514, 0.02936900593340397, -0.017163751646876335, 0.09814053773880005,
    0.07450374215841293, -0.02528234012424946, 0.016725266352295876, -0.03041226416826248, -0.02607090212404728, 0.01949509233236313, 0.07199642062187195, 0.012467548251152039,
    0.10844489932060242, -0.012152358889579773, -0.008508242666721344, 0.039641425013542175, 0.054090216755867004, 0.048886992037296295, 0.024442873895168304, -0.03026074543595314,
    -0.021592993289232254, 0.05018734186887741, 0.03416745364665985, 0.051920823752880096, 0.02528226748108864, 0.03954445570707321, -0.03273569792509079, -0.025743374601006508,
    -0.03936292603611946, 0.03974244371056557, -0.008184773847460747, -0.024485666304826736, 0.01813521981239319, 0.021711261942982674, -0.04465186595916748, 0.02338242717087269,
    -0.009317039512097836, 0.0765310674905777, -0.04185155779123306, -0.06818544864654541, -0.06988056749105453, 0.042893555015325546, 0.024399198591709137, -0.015261678025126457,
    0.0004853985155932605, 0.009140824899077415, -0.042631231248378754, -0.10374155640602112, -0.07763198763132095, -0.002688248874619603, 0.07092023640871048, -0.010811365209519863,
    0.06956276297569275, -0.06972939521074295, 0.03432401642203331, -0.0032148470636457205, -0.015398867428302765, -0.07387486845254898, 0.004125144798308611, -0.01733723096549511,
    0.03894474729895592, 0.007538383360952139, -0.01281050406396389, -0.025016572326421738, 0.017436480149626732, 0.001282060518860817, -0.012634758837521076, -0.00447377935051918,
    0.06151137501001358, -0.05361573025584221, 0.010559002868831158, 0.07544974237680435, 0.02822098694741726, 0.06195586174726486, -0.058487702161073685, 0.07748325914144516,
    -0.022627471014857292, 0.0013500807108357549, 0.011727279983460903, 0.018634188920259476, 0.06675457209348679, -0.05849677696824074, 0.017770811915397644, -0.005212927702814341,
    0.05720209330320358, 0.016314661130309105, 0.021687159314751625, 0.039254069328308105, 0.0076452200300991535, 0.07760658115148544, -0.05102986842393875, 0.019393345341086388,
    0.0020580566488206387, 0.0391574501991272, 0.07189775258302689, -0.0482187420129776, 0.038043759763240814, 0.05890443176031113, -0.06938903778791428, -0.034223202615976334,
    0.04383080080151558, -0.031121309846639633, 0.09633738547563553, -0.005207108333706856, -0.05940725654363632, -0.07141964137554169, -0.020438851788640022, -0.015512753278017044,
    -0.0597456730902195, 0.038713790476322174, 0.023379992693662643, -0.02853528782725334, -0.043530870229005814, -0.07831977307796478, -0.052680931985378265, 0.03796542435884476,
    -0.04794079810380936, -0.05110282078385353, -0.016290467232465744, 0.027688728645443916, -0.017942799255251884, -0.07285357266664505, -0.020068185403943062, -0.005969883408397436,
    0.005995931103825569, 0.04738708585500717, -0.045834142714738846, -0.011900734156370163, -0.010081054642796516, 0.06558528542518616, -0.01737385429441929, -0.0050903246738016605,
    -0.03602105751633644, 0.004308520816266537, 0.03450087085366249, 0.011953904293477535, 0.027222800999879837, 0.04286789521574974, 0.04106062650680542, -0.02659076452255249,
    0.012221306562423706, 0.015207498334348202, 0.018852416425943375, -0.0018129140371456742, 0.017544956877827644, 0.04806830734014511, 0.03352554142475128, -0.045067332684993744,
    -0.06332089006900787, -0.0555073544383049, -0.05573020502924919, -0.03348037600517273, -0.04049017280340195, -0.027863457798957825, -0.0430193766951561, -0.036056891083717346,
    0.06352632492780685, -0.05267852544784546, -0.02003958635032177, 0.008155988529324532, -0.015528201125562191, -0.016074635088443756, 0.05141652747988701, -0.008108275942504406,
    -0.045077983289957047, 0.004491643980145454, 0.06597371399402618, -0.04435134306550026, 0.009964574128389359, -0.022463416680693626, -0.017967214807868004, 0.034051649272441864,
    -0.06309829652309418, -0.013684180565178394, 0.051352452486753464, 0.05489528179168701, -0.054932497441768646, 0.007418095134198666, 0.007832856848835945, 0.06736253947019577,
    -0.008414572104811668, 0.10670698434114456, -0.034652628004550934, 0.00522886635735631, 0.04357146844267845, -0.05356340855360031, 0.05480246618390083, -0.010570410639047623,
    -0.0006265681586228311, -0.007266146130859852, -0.019360478967428207, -0.009664778597652912, 0.028635676950216293, 0.0014547902392223477, -0.013858392834663391, -0.0179721862077713,
    -0.02982119843363762, -0.04826812073588371, -0.016124503687024117, 0.010197932831943035, 0.01407688669860363, 0.04083915427327156, -0.0007689269259572029, 0.12144692242145538,
    -0.03420477733016014, -0.005071012303233147, 0.007156181614845991, -0.011480012908577919, -0.05106116831302643, 0.0018233105074614286, -0.029719430953264236, -0.05684512481093407,
    -0.0003382995491847396, -0.024006176739931107, 0.000454401335446164, -0.023148730397224426, 0.01408104132860899, -0.038860984146595, -0.05785604566335678, -0.048956409096717834,
    0.026132071390748024, -0.016544321551918983, -0.0033368077129125595, 0.016530076041817665, 0.05525095760822296, -0.08467084169387817, 0.06816667318344116, 0.023042162880301476,
    0.018420422449707985, 0.021839603781700134, 0.027325786650180817, -0.017568916082382202, 0.04652778059244156, 0.05893438681960106, 0.006593897473067045, 0.007392727304250002,
    0.004866139031946659, 0.033251162618398666, 0.07781610637903214, 0.011913684196770191, 0.058312565088272095, 0.005149638280272484, -0.036609187722206116, 0.012175659649074078,
    -0.0009394755470566452, -0.042393073439598083, 0.09182235598564148, -0.06813641637563705, -0.014733191579580307, 0.06193980947136879, 0.00704047828912735, -0.009915972128510475,
    0.020380688831210136, -0.021054059267044067, -0.04548751935362816, -0.029583925381302834, -0.014606880024075508, -0.014598612673580647, 0.01817193627357483, -0.09319119155406952,
    -0.008969803340733051, 0.06172878295183182, -0.016157858073711395, 0.03598524630069733, 0.0006369557231664658, -0.028617901727557182, -0.019218700006604195, 0.06183279678225517,
    0.039970170706510544, -0.011674946174025536, -0.009537582285702229, 0.011221160180866718, 0.016110671684145927, -0.03360661491751671, -0.0287703275680542, -0.04062784090638161,
    0.013378983363509178, -0.03372615575790405, -0.014638192020356655, -0.037096865475177765, 0.0694851353764534, 0.03515911474823952, -0.02808529883623123, -0.025488518178462982,
    0.06414800882339478, -0.08286941051483154, -0.02136348746716976, -0.05791467800736427, 0.01498885452747345, 0.003049299120903015, -0.0046718306839466095, 0.04835531860589981,
    -0.06750991940498352, 0.039769452065229416, 0.014015411958098412, 0.0043958937749266624, -0.02144060842692852, -0.025542190298438072, -0.026345912367105484, -0.04648793861269951,
    -0.03664083406329155, 0.04546777158975601, -0.010987776331603527, 0.005700806155800819, -0.014417403377592564, 0.04587295278906822, -0.018292289227247238, -0.033251456916332245,
    0.036173462867736816, -0.08989973366260529, 0.06541625410318375, 0.09153606742620468, 0.08644495904445648, 0.01723635569214821, 0.041366491466760635, -0.012400605715811253,
    -0.06040048226714134, 0.017062729224562645, 0.03948412835597992, -0.056644782423973083, -0.007876004092395306, 0.009524259716272354, 0.002220242517068982, 0.002944224514067173,
    0.005221973173320293, -0.03924278914928436, -0.0011969991028308868, -0.016948465257883072, 0.01173592172563076, 0.010054143145680428, -0.009778640232980251, -0.04116658866405487,
    -0.07690317183732986, 0.031035607680678368, -0.08499197661876678, 0.036090750247240067, 0.06503653526306152, 0.04536467790603638, 0.009381878189742565, 0.006296505220234394,
    0.01771129108965397, 0.005754847079515457, -0.03893723711371422, 0.0076459976844489574, -0.007036875002086163, -0.031588371843099594, -0.008702322840690613, -0.014666219241917133,
    -0.0031955381855368614, 0.02501707337796688, 0.013652193360030651, 0.011634795926511288, -0.043038610368967056, 0.06016218289732933, -0.007217739708721638, -0.024142909795045853,
    -0.04618684947490692, -0.023572171106934547, 0.007012404501438141, 0.011789347976446152, -0.054316196590662, -0.016140354797244072, 0.0021313875913619995, 0.046247780323028564,
    0.04806932434439659, 0.00059468176914379, 0.03216717019677162, -0.05288998782634735, -0.001757472287863493, 0.022672083228826523, -0.03781156614422798, 0.03424444422125816,
    0.09344909340143204, -0.03617741912603378, -0.003900868119671941, 0.0025528150144964457, -0.025123542174696922, -0.08376404643058777, 0.011471083387732506, 0.11812516301870346,
    -0.0506773479282856, 0.05422429367899895, 0.009455818682909012, 0.00504685752093792, 0.006718283984810114, -0.0503888763487339, -0.00905583519488573, 0.11002225428819656,
    0.08409992605447769, -0.12679684162139893, 0.006866385228931904, -0.09651488065719604, -0.04196370765566826, 0.043724097311496735, -0.05128360167145729, 0.009355111047625542,
    -0.07097244262695312, -0.030765391886234283, 0.02148984745144844, 0.03003009594976902, -0.03107207454741001, 0.091779425740242, 0.0494331531226635, -0.02313491329550743,
    0.015188053250312805, -0.011869614943861961, 0.024256132543087006, -0.04218801483511925, 0.027498282492160797, 0.0663309097290039, 0.020132165402173996, -0.025960227474570274,
    -0.06199708580970764, -0.05116650462150574, -0.06298940628767014, 0.09638660401105881, 0.008995698764920235, 0.014534847810864449, 0.019811004400253296, -0.004515642765909433,
    -0.01657797209918499, 0.007763133849948645, 0.031456999480724335, -7.592376277898438e-06, -0.09280332177877426, 0.06891941279172897, -0.03220795467495918, -0.030605843290686607,
    -0.008035946637392044, 0.05937407165765762, -0.00257035787217319, -0.017174432054162025, 0.027117513120174408, 0.0479147844016552, 0.0017969977343454957, 0.012832216918468475,
    -0.042419373989105225, 0.07869862020015717, 0.020188825204968452, 0.013093620538711548, 0.024688992649316788, 0.01937737502157688, -0.10526087880134583, -0.05012064054608345,
    0.03672259673476219, -0.02488996461033821, 0.011720043607056141, -0.04455423727631569, -0.02874489314854145, -0.09821362793445587, -0.0551605150103569, 0.013852257281541824,
    0.014469255693256855, -0.05961519852280617, 0.07685910910367966, 0.004851968493312597, 0.011221915483474731, -0.02903994917869568, 0.017313973978161812, 0.02627318538725376,
    -0.04842182993888855, -0.0004134814953431487, -0.0049205650575459, 0.0641501247882843, 0.03310045227408409, -0.06236600875854492, -0.07434162497520447, -0.0032819523476064205,
    -0.03746948763728142, -0.010718912817537785, 0.03747960925102234, 0.027582969516515732, 0.0029758589807897806, -0.05651932954788208, -0.06036178022623062, -0.030701396986842155,
    -0.010369934141635895, -0.015354329720139503, 0.011748223565518856, -0.053899627178907394, -0.015001200139522552, 0.005167066119611263, -0.026136087253689766, 0.010019305162131786,
    0.07261349260807037, -0.014030296355485916, 9.545568173052743e-05, -0.00441590603441, -0.027408456429839134, 0.05382765829563141, -0.003862443147227168, 0.009660420939326286,
    0.018960164859890938, 0.04095397889614105, 0.003969358280301094, -0.03355320543050766, 0.021281860768795013, 0.00927914772182703, -0.029746079817414284, 0.047988977283239365,
    -0.01815984584391117, 0.07651650905609131, -0.060565199702978134, -0.017456132918596268, 0.0005168091738596559, 0.03973861783742905, 0.0162432212382555, 0.01618179865181446,
    0.02542361244559288, 0.022126881405711174, -0.05744883418083191, 0.0004477430775295943, 0.0014941635308787227, -0.053652070462703705, 0.044340331107378006, -0.05704893544316292,
    -0.011772474274039268, 0.030492741614580154, -0.013662478886544704, -0.03441076725721359, 0.05258151888847351, -0.009044953621923923, 0.06043315306305885, -0.0363788828253746,
    -0.026981765404343605, -0.033090103417634964, -0.02981041558086872, -0.016883371397852898, -0.02149726264178753, 0.049979496747255325, -0.06286892294883728, 0.030191680416464806,
    0.027233734726905823, -0.06721558421850204, 0.02682391181588173, -0.023388871923089027, 0.012317732907831669, 0.012049886398017406, 0.012527326121926308, -0.007319482509046793,
    0.022442663088440895, 0.009057075716555119, 0.020115552470088005, 0.0067265331745147705, -0.009049235843122005, 0.014378109946846962, 0.036542631685733795, 0.01618277095258236,
    -0.08504393696784973, -0.1153271421790123, -0.015749851241707802, 0.007094344589859247, -0.020553739741444588, -0.02090362086892128, -0.00799483060836792, 0.0033264767844229937,
    0.008372602052986622, -0.03588798642158508, -0.00764577928930521, 0.08751961588859558, 0.05581890791654587, -0.01471357699483633, 0.021347779780626297, 0.009433417581021786,
    0.010923616588115692, -0.05648202821612358, -0.023905005306005478, 0.01617964543402195, 0.009579598903656006, -0.040148649364709854, 0.033064983785152435, -0.015400906093418598,
    0.023925533518195152, 0.016588930040597916, -0.04744606837630272, 0.048856087028980255, 0.021889647468924522, 0.012806090526282787, -0.044356171041727066, -0.031261783093214035,
    0.03844693675637245, 0.006737605668604374, -0.06058316305279732, 0.022750290110707283, 0.010127444751560688, -0.02899111434817314, 0.0012816069647669792, -0.0374520942568779,
    0.038513846695423126, -0.012096945196390152, 0.006920626387000084, 0.002036180580034852, 0.017686685547232628, 0.03988203778862953, -0.07706254720687866, 0.03362772986292839,
    0.0912710428237915, 0.009503952227532864, -0.0304143987596035, -0.06014247611165047, 0.03670825436711311, -0.043338969349861145, 0.03581615537405014, 0.06953877955675125,
    0.0007671521743759513, -0.020107360556721687, 0.053921278566122055, -0.016906604170799255, 0.015921717509627342, 0.038580674678087234, 0.008444037288427353, -0.025767862796783447,
    0.010463480837643147, -0.07569010555744171, 0.002801569178700447, -0.0054471055045723915, 0.024006158113479614, 0.021334713324904442, -0.017493760213255882, -0.026392901316285133,
    0.008391394279897213, 0.04776651784777641, 0.055450327694416046, 0.0012837606482207775, -0.005491919349879026, -0.028667956590652466, -0.006078463513404131, 0.005542172584682703,
    0.026058362796902657, 0.050737664103507996, -0.0006444698665291071, 0.03975715860724449, 0.04183591529726982, -0.05816977471113205, 0.0182463601231575, -0.038628242909908295,
    0.0541314072906971, 0.016996189951896667, -0.07477590441703796, 0.014339964836835861, 0.00023407985281664878, 0.05867936834692955, -0.019161121919751167, -0.0021545346826314926,
    -0.03292989358305931, 0.010470832698047161, 0.037697095423936844, 0.004193731117993593, 0.0029173013754189014, 0.05312846973538399, 0.015106750652194023, 0.016811570152640343,
    0.07592257112264633, 0.037287354469299316, 0.022186603397130966, -0.006706792861223221, -0.0642675831913948, 0.03566103056073189, 0.08155695348978043, -0.026152431964874268,
    0.00493616983294487, -0.018592625856399536, -0.028220204636454582, -0.0063316128216683865, 0.0521981418132782, -0.047113556414842606, -0.07079308480024338, 0.03797004371881485,
    -0.011676138266921043, 0.13385291397571564, 0.026916896924376488, 0.03339557349681854, 0.000908097077626735, -0.030754266306757927, -0.04025301709771156, -0.01937028579413891,
    -0.017338667064905167, 0.001071742968633771, -0.05629269406199455, -0.029838789254426956, -0.08648937195539474, 0.005437574815005064, -0.029473621398210526, 0.009946920908987522,
    -0.03224807605147362, -0.05399484559893608, -0.024782562628388405, 0.021010708063840866, -0.012130934745073318, 0.0117240184918046, -0.024346327409148216, -0.06313684582710266,
    -0.005288650281727314, 0.016541212797164917, -0.001995122991502285, -0.03580348938703537, -0.012579054571688175, -0.0009164279326796532, 0.017218001186847687, 0.03871364891529083,
    -0.0249006487429142, -0.0379047654569149, 0.034481149166822433, -0.06840184330940247, -0.10434029251337051, -0.019816983491182327, 0.004002466797828674, 0.0008527536992914975,
    -0.10115550458431244, 0.02934209816157818, 0.059420496225357056, -0.0125272860750556, -0.038083579391241074, 0.04777925834059715, 0.04254874959588051, -0.004587898030877113,
    -0.028476716950535774, 0.04850766807794571, 0.024734579026699066, -0.039509985595941544, -0.020898880437016487, 0.03801838681101799, 0.0595661960542202, -0.06576349586248398,
    -0.011824182234704494, -0.009989689104259014, -0.05506925657391548, 0.04085409641265869, -0.011617415584623814, 0.004522941540926695, 0.0059946379624307156, -0.015086549334228039,
    -0.0072723859921097755, -0.024683820083737373, 0.07286545634269714, 0.00484207458794117, 0.03894639387726784, -0.006797189824283123, 0.02950150892138481, -0.059823449701070786,
    -0.03141804412007332, -0.00881884153932333, -0.041765037924051285, 0.022134631872177124, -0.07745201140642166, -0.04141665995121002, -0.008224451914429665, 0.00022189124138094485,
    -0.015321471728384495, 0.1013292521238327, 0.006159286480396986, 0.05411505326628685, 0.031468465924263, -0.041232917457818985, -0.03417004272341728, 0.030794894322752953,
    -0.01655762828886509, 0.045448146760463715, -0.042517151683568954, 0.004750281572341919, -0.05092163756489754, 0.05995534732937813, -0.04681698977947235, 0.08204744756221771,
    -0.013395880348980427, 0.00835441891103983, -0.06120109558105469, 0.003504197346046567, 0.022302381694316864, 0.03536263480782509, -0.03575873374938965, -0.016910158097743988,
    0.05129687488079071, -0.06849869340658188, 0.02714885026216507, 0.07319080829620361, -0.12132572382688522, 0.024065041914582253, 0.01571395993232727, -0.014658127911388874,
    -0.011360546573996544, -0.0024845253210514784, 0.052577029913663864, -0.019770078361034393, 0.06581742316484451, 0.06410855799913406, 0.0499422587454319, -0.06836336106061935,
    -0.027004748582839966, 0.026000984013080597, 0.021234475076198578, -0.01693553850054741, 0.052842285484075546, 0.052755337208509445, 0.08592358976602554, -0.06323159486055374,
    0.04955244064331055, 0.050698380917310715, -0.05627121403813362, 0.025990484282374382, -0.00761371711269021, 0.004739849362522364, 0.02964203990995884, 0.029714973643422127,
    -0.027632936835289, -0.05247940123081207, 0.01862463168799877, 0.01830984652042389, 0.05126234143972397, 0.03877326846122742, -0.07138413935899734, 0.04312651604413986,
    0.030317267403006554, 0.06939541548490524, 0.0034316827077418566, 0.013391266576945782, -0.11107237637042999, -0.01689545065164566, 0.08569800853729248, 0.020083751529455185,
    -0.00497413519769907, 0.03425703942775726, -0.02895023673772812, -0.038559895008802414, -0.04364430159330368, 0.04094040021300316, -0.05754641443490982, -0.023569636046886444,
    -0.042150937020778656, 0.03157075121998787, 0.015685472637414932, 0.024015851318836212, -0.040777549147605896, -0.056097134947776794, -0.047561775892972946, -0.01361396536231041,
    0.04656698927283287, 0.0012628071708604693, 0.0032899039797484875, -0.03778594732284546, -0.0057571446523070335, -0.02616298571228981, 0.018711032345891, -0.02916576899588108,
    0.03918462619185448, -0.08932521939277649, 0.06847351044416428, 0.0004182109551038593, -0.02494167722761631, 0.006893416400998831, -0.05728757008910179, 0.0432528518140316,
    0.038444288074970245, 0.017204169183969498, -0.0005826348788104951, -0.008396128192543983, 0.03347206860780716, 0.009976236149668694, 0.053448375314474106, 0.025020822882652283,
    0.04721653833985329, -0.007481908425688744, 0.07807005196809769, -0.02389657124876976, 0.01662503555417061, 0.002678034594282508, 0.027321727946400642, -0.050684910267591476,
    0.04633961245417595, 0.011039387434720993, 0.011540633626282215, -0.018668830394744873, 0.033090658485889435, 0.0742560625076294, -0.022315988317131996, 0.0037758375983685255,
    0.01050998643040657, 0.021645646542310715, 0.1071920096874237, -0.03444533422589302, -0.03556337207555771, 0.006912337616086006, 0.0009312164620496333, 0.05156821012496948,
    -0.03805602341890335, -0.016158876940608025, -0.05870765075087547, 0.0660790279507637, 0.006010298617184162, -0.06495100259780884, 0.025599097833037376, -0.042540498077869415,
    0.06878460943698883, 0.0050875642336905, -0.04381804168224335, -0.020373515784740448, -0.004234845284372568, -0.07838162779808044, -0.029359878972172737, -0.023633001372218132,
    0.019311193376779556, 0.08247870206832886, 0.0057630217634141445, -0.07664510607719421, -0.0007880431367084384, -0.011008193716406822, -0.023564225062727928, -0.04746776819229126,
    0.05806102603673935, 0.012678786180913448, -0.1078607589006424, 0.017715001478791237, 0.05857592448592186, 0.01197466067969799, 0.0017082830891013145, -0.040170758962631226,
    -0.017139814794063568, -0.05516159534454346, -0.02178587019443512, -0.016055293381214142, -0.03347230330109596, 0.05948638170957565, -0.0400373600423336, -0.044052936136722565,
    -0.025627028197050095, -0.03106873668730259, 0.034836530685424805, 0.07491803169250488, 3.581380224204622e-05, -0.01995011977851391, -0.07621122896671295, 0.012492074631154537,
    0.0007233285577967763, 0.04970014467835426, 0.12810347974300385, -0.05009746178984642, -0.01332947425544262, -0.017900744453072548, 0.010182826779782772, 0.0771632269024849,
    -0.012400064617395401, -0.06454221904277802, 0.06271079182624817, 0.04813313111662865, -0.03350095823407173, 0.062375281006097794, -0.012520244345068932, -0.021226493641734123,
    -0.013258382678031921, -0.07437882572412491, 0.0012287924764677882, 0.007437342777848244, 0.023428410291671753, 0.04354063421487808, -0.0011481104884296656, 0.020824884995818138,
    -0.030358126387000084, 0.009784169495105743, -0.02612208016216755, 0.05814104527235031, -0.06772137433290482, -0.0723709911108017, 0.042446840554475784, -0.016583258286118507,
    -0.015100477263331413, 0.0785842090845108, 0.011673461645841599, -0.021202677860856056, 0.017304373905062675, 0.030505811795592308, 0.049485329538583755, 0.0748668909072876,
    -0.013079865835607052, 0.10202284157276154, 0.06502017378807068, -0.05539606884121895, 0.005253707058727741, -0.008868340402841568, -0.027159176766872406, 0.0295904241502285,
    -0.05486878380179405, 0.024690749123692513, -0.06947736442089081, 0.0021707334090024233, -0.004882033448666334, 0.04344826936721802, 0.009936150163412094, 0.014072726480662823,
    -0.052505116909742355, 0.03310873731970787, 0.0667894184589386, 0.031317174434661865, 0.036890659481287, -0.015947530046105385, -0.011091078631579876, -0.052765749394893646,
    -0.009013560600578785, -0.0553773008286953, -0.0016273612855002284, 0.009202740155160427, -0.04142729938030243, 0.04563802108168602, 0.05179476737976074, 0.08658633381128311,
    0.0332021564245224, 0.03620964288711548, 0.018330425024032593, 0.05799337476491928, 0.019785411655902863, -0.023040883243083954, -0.004136847332119942, -0.08021107316017151,
    -0.02666291780769825, -0.041389524936676025, -0.014244220219552517, 0.0027923567686229944, 0.011996698565781116, 0.05059971660375595, 0.06144994497299194, 0.04334753006696701,
    0.055637821555137634, -0.0638975203037262, -0.016018541529774666, 0.044480517506599426, -0.0038545269053429365, -0.0411466509103775, 0.013253130950033665, -0.07262349873781204,
    -0.06269970536231995, -0.07121778279542923, 0.029947303235530853, -0.03053981252014637, 0.029617736116051674, 0.007841470651328564, 0.05613664165139198, 0.01561999786645174,
    0.05365661159157753, -0.04256323724985123, 0.09690119326114655, -0.016251644119620323, -0.06658405065536499, 0.043512966483831406, -0.02558259479701519, 0.016401143744587898,
    0.014006668701767921, -0.01624833419919014, 0.04253522679209709, -0.02119872346520424, -0.044172707945108414, 0.017909826710820198, 0.03001336008310318, 0.05904573202133179,
    0.03261152654886246, -0.01973395049571991, 0.03214346244931221, -0.06979609280824661, 0.00016701582353562117, 0.018568873405456543, 0.03247753530740738, -0.00047013902803882957,
    0.015719236806035042, -0.054382894188165665, -0.08519487828016281, -0.001618370064534247, 0.02213434875011444, -0.015070860274136066, -0.006360429339110851, 0.12315543740987778,
    0.018793337047100067, -0.006936496589332819, -0.02427251823246479, 0.029556596651673317, -0.0014418043429031968, -0.052454106509685516, 0.010273195803165436, -0.030484091490507126,
    0.007846328429877758, 0.0844963863492012, -0.05014598369598389, 0.03058018907904625, 0.004303171765059233, -0.032475654035806656, 0.07450000941753387, 0.06478150188922882,
    -0.03714258223772049, 0.04525269195437431, -0.005211234092712402, 0.02378186769783497, 0.013787220232188702, -0.012196148745715618, -0.06423261761665344, 0.03151445463299751,
    -0.048099588602781296, -0.010685160756111145, 0.1055581122636795, 0.10096476972103119, 0.03420119732618332, -0.036438003182411194, 0.03915056958794594, -0.013387982733547688,
    0.008733554743230343, -0.13471467792987823, 0.07641636580228806, -0.026595864444971085, -0.013482607901096344, 0.020104188472032547, 0.016645289957523346, -0.004129103850573301,
    0.09521611779928207, -0.0602237731218338, -0.08603297919034958, -0.0161999873816967, -0.059694912284612656, -0.021700607612729073, 0.0025037003215402365, 0.0009245622786693275,
    0.032400477677583694, -0.024585073813796043, 0.07387425005435944, 0.08625809103250504, -0.05111488327383995, -0.005860458593815565, 0.010579995810985565, -0.04300764575600624,
    -0.011603896506130695, 0.0012745570857077837, -0.022276710718870163, 0.014785762876272202, 0.049871187657117844, 0.03164377436041832, -0.023285100236535072, -0.016759537160396576,
    -0.03872128576040268, 0.0023823133669793606, 0.012339507229626179, -0.01846529357135296, 0.03141065686941147, 0.08400659263134003, 0.014203250408172607, -0.04335862025618553,
    0.024813158437609673, -0.03854953497648239, 0.008961549960076809, 0.01673918403685093, -0.001968314638361335, 0.008008042350411415, -0.04958990216255188, 0.02371481992304325,
    -0.010090643540024757, 0.03980837017297745, -0.015925919637084007, -0.010380029678344727, 0.005602668039500713, -0.0274351853877306, -0.001270587439648807, -0.019067805260419846,
    0.07769771665334702, 0.08968725055456161, 0.10289628058671951, 0.037352994084358215, -0.03172442317008972, -0.04433825984597206, -0.050256580114364624, -0.01121812779456377,
    -0.024785125628113747, -0.009961322881281376, -0.1158955916762352, -0.023666037246584892, -0.06349004805088043, 0.002574328798800707, -0.00029074179474264383, -0.049468472599983215,
    -0.0023508802987635136, 1.5815461665624753e-05, -0.03468543291091919, -0.03479393199086189, 0.018150633201003075, 0.05765208974480629, -0.0330466628074646, 0.019260119646787643,
    0.045176416635513306, -0.026547426357865334, 0.011279437690973282, -0.0073433853685855865, -0.020483259111642838, -0.04207110404968262, 0.023364275693893433, 0.03531474620103836,
    -0.008894527330994606, -0.004498062655329704, -0.04499359056353569, 0.0020702730398625135, 0.0555109828710556, 0.040383581072092056, -0.03234754875302315, 0.06696075201034546,
    -0.003545304760336876, 0.003076688852161169, 0.010566755197942257, 0.010534647852182388, 0.1080511063337326, 0.022096781060099602, 0.010057507082819939, -0.012042783200740814,
    0.03956805542111397, -0.014815065078437328, 0.05053539201617241, 0.07510682195425034, 0.04496696963906288, 0.02298700623214245, -0.010984612628817558, 0.06250803917646408,
    0.05602828040719032, 0.05031503364443779, 0.03611231967806816, 0.04132549464702606, -0.008074946701526642, 0.06443389505147934, 0.004272974096238613, -0.012691992335021496,
    0.010273431427776814, -0.0015866425819694996, -0.01666499488055706, -0.11668803542852402, 0.033612340688705444, 0.005448352545499802, -0.03257919102907181, 0.0042524272575974464,
    0.022519012913107872, 0.08463209122419357, 0.05335021764039993, -0.045201484113931656, -0.03083876334130764, 0.07752633094787598, 0.009647008962929249, 0.009292281232774258,
    -0.0018271428998559713, -0.026976749300956726, -0.022672293707728386, -0.009431978687644005, 0.1262163668870926, -0.022866662591695786, 0.11379073560237885, 0.039625171571969986,
    0.010034198872745037, 0.026496458798646927, 0.027473928406834602, 0.08086642622947693, -0.03643275797367096, 0.08382919430732727, 0.015888528898358345, -0.008028697222471237,
    -0.07155665755271912, -0.013207540847361088, -0.03348885476589203, 0.013520500622689724, 0.032106198370456696, 0.012674814090132713, 0.008477437309920788, 0.008711316622793674,
    0.03504406660795212, -0.04409152641892433, -0.04367551580071449, -0.02408435381948948, -0.019316628575325012, 0.030172353610396385, 0.03785869479179382, -0.006891424302011728,
    0.0564766526222229, 0.048806533217430115, 0.0031926592346280813, 0.028733985498547554, -0.017032796517014503, -0.09188922494649887, -0.011657539755105972, 0.0259296465665102,
    0.052362941205501556, -0.015462380833923817, 0.014372061006724834, 0.030332356691360474, 0.007229291368275881, -0.059386592358350754, -0.02391671948134899, 0.039904121309518814,
    0.024144371971488, -0.03631092607975006, -0.05221853777766228, -0.033193375915288925, 0.08303333818912506, 0.05708532780408859, 0.10932507365942001, -0.0010232323547825217,
    0.007436699233949184, -0.01999209262430668, 0.09899188578128815, -0.005126102827489376, -0.037312719970941544, 0.023881224915385246, 0.005841987207531929, 0.0009493685211054981,
    -0.0085188839584589, 0.005312245339155197, -0.020516229793429375, -0.04245468229055405, -0.010605523362755775, 0.025775747373700142, 0.07807649672031403, -0.014495691284537315,
    -0.023833811283111572, 0.03476810082793236, -0.0002989108907058835, 0.07814163714647293, 0.0072122304700315, 0.030523018911480904, 0.05218590423464775, 0.03433309122920036,
    0.003670332720503211, -0.05695818364620209, 0.09806786477565765, 0.013139684684574604, 0.038395315408706665, -0.07182953506708145, -0.01581050641834736, 0.05361121520400047,
    0.011744450777769089, 0.0021445744205266237, 0.02600298821926117, 0.03119843266904354, -0.02998816967010498, -0.05374005064368248, -0.012310633435845375, -0.07938990741968155,
    -0.08149354159832001, -0.04852314665913582, -0.01564260758459568, -0.05141664296388626, -0.0339965783059597, 0.028864368796348572, -0.042621418833732605, 0.009713503532111645,
    -0.04258577525615692, -0.013436666689813137, -0.015320666134357452, 0.003439367050305009, -0.0535992756485939, -0.06194358691573143, -0.03781748563051224, -0.017766080796718597,
    0.0706823319196701, 0.030899962410330772, -0.0048781647346913815, 0.0288831889629364, 0.020421434193849564, -0.0013692800421267748, -0.02117890678346157, -0.0025562713854014874,
    0.02477983385324478, 0.01824532262980938, 0.05502619966864586, 0.013851845636963844, -0.005578773561865091, -0.01734934002161026, -0.03538493439555168, -0.0302517618983984,
    -0.06116361543536186, 0.08289241045713425, -0.0010332788806408644, 0.005090623162686825, -0.06838766485452652, 0.058790963143110275, 0.06952732801437378, 0.05845585837960243,
    -0.004506455734372139, -0.07417863607406616, 0.01782396249473095, -0.029108582064509392, 0.017391139641404152, -0.0895344689488411, 0.04596072807908058, -0.04400404170155525,
    0.00017130615015048534, 0.05289814993739128, -0.012710576876997948, 0.0014460710808634758, 0.08889102190732956, 0.035808078944683075, -0.02176966518163681, -0.003777013858780265,
    -0.025029147043824196, -0.04612909257411957, -0.03928733989596367, 0.007221120875328779, 0.0559665709733963, 0.01212346088141203, -0.006461846176534891, 0.03140528127551079,
    -0.00480406591668725, 0.010524233803153038, -0.02742355689406395, 0.05127010494470596, 0.0063201915472745895, 0.08197025954723358, -0.048900406807661057, -0.032035887241363525,
    0.005835550371557474, 0.012952027842402458, -0.018407264724373817, 0.03370175510644913, -0.015743905678391457, 0.08088144659996033, 0.053657062351703644, -0.05079088732600212,
    -0.05681711062788963, 0.0006462063756771386, 0.11650796979665756, -0.03705635666847229, -0.014106311835348606, -0.00958374422043562, 0.022483771666884422, 0.00617600791156292,
    0.0439375676214695, 0.007405092474073172, -0.06991922110319138, 0.0003766452718991786, 0.017842276021838188, -0.00538688013330102, -0.03397710248827934, -0.04115396738052368,
    0.03297019749879837, 0.003897167509421706, 0.004296824801713228, -0.012514821253716946, -0.026813609525561333, 0.06639683991670609, 0.012609228491783142, 0.024862075224518776,
    0.03382888063788414, 0.05140142887830734, -0.030094165354967117, -0.04340728372335434, -0.02915837988257408, -0.029209494590759277, 0.026379967108368874, -0.02000623568892479,
    0.07568316161632538, -0.010779637843370438, -0.04181444272398949, -0.02261374145746231, -0.03725359961390495, 0.07633928209543228, 0.01679539866745472, 0.04342401772737503,
    0.008251273073256016, -0.048061076551675797, 0.018075531348586082, 0.03448181599378586, -0.09132598340511322, 0.13253459334373474, -0.054812364280223846, 0.02192775160074234,
    0.026828287169337273, 0.05006827041506767, -0.06077909097075462, 0.09542722254991531, 0.04774177446961403, 0.012836758978664875, 0.04165507107973099, 0.0367121621966362,
    0.03169507160782814, -0.004900605883449316, -0.016615044325590134, 0.026231709867715836, -0.032829709351062775, 0.06888891011476517, -0.03365522623062134, -0.010766463354229927,
    0.11843305826187134, -0.004271060694009066, -0.039213474839925766, 0.041728854179382324, 0.006556752137839794, -0.05300654470920563, -0.06482423096895218, -0.09936606884002686,
    0.02361169457435608, -0.03214261308312416, 0.07123473286628723, 0.00908963568508625, 0.0443289577960968, 0.05452674254775047, 0.04239717498421669, 0.01288672536611557,
    0.058571211993694305, -0.08057986199855804, 0.008913219906389713, -0.012388941831886768, 0.03836787864565849, -0.05050401762127876, 0.04449673369526863, -0.02541048265993595,
    -0.013166003860533237, 0.04522164538502693, 0.03353340923786163, 0.03486420214176178, 0.031593866646289825, 0.04859965667128563, -0.010226763784885406, 0.025708381086587906,
    0.0561615452170372, 0.06235725060105324, -0.04021858796477318, -0.00013401628530118614, 0.00424110796302557, 0.031016040593385696, 0.004066528286784887, -0.02350957877933979,
    0.005838137120008469, -0.0618494413793087, 0.021589266136288643, -0.015784677118062973, -0.02243293635547161, -0.027478203177452087, 0.001063163741491735, -0.02292611077427864,
    0.031034523621201515, 0.0059428452514112, 0.03480706736445427, 0.008546855300664902, 0.0006946861394681036, -0.09582007676362991, -0.08154091984033585, 0.0640808641910553,
    0.002493180800229311, -0.0003277720243204385, -0.03908003121614456, 0.0011334704468026757, 0.022148022428154945, 0.011402012780308723, 0.0042587341740727425, -0.002399391494691372,
    0.018522702157497406, 0.08034711331129074, 0.009416001848876476, 0.00801172573119402, 0.04309277981519699, -0.01596086286008358, 0.01147355418652296, 0.05410108342766762,
    0.01388908177614212, -0.07031925022602081, 0.08893822133541107, -0.04835457354784012, 0.02732711471617222, 0.02260221168398857, -0.02199595421552658, 0.0004784305056091398,
    0.05188049376010895, -0.01566403917968273, 0.027693387120962143, -0.043962493538856506, 0.015311350114643574, -0.006983139552175999, -0.07774416357278824, -0.042857617139816284,
    -0.09013544023036957, -0.016922172158956528, -0.003809921909123659, 0.0032610695343464613, 0.012932966463267803, 0.027705883607268333, 0.040177542716264725, 0.00858937855809927,
    0.004613620229065418, -0.01912851259112358, -0.11461462080478668, -0.023162852972745895, -0.03378572687506676, 0.04097447544336319, 0.014899884350597858, -0.060383882373571396,
    0.006136758718639612, 0.021339382976293564, -0.06024625524878502, 0.0693456307053566, 0.016317708417773247, -0.028590908274054527, -0.0032839130144566298, -0.04647071659564972,
    0.06420183926820755, -0.06132298707962036, 0.037118099629879, 0.03526237979531288, -0.007256501354277134, 0.002827730728313327, 0.05487538501620293, 0.010416251607239246,
    0.007905205711722374, 0.05350779369473457, 0.038965292274951935, -0.04274209588766098, -0.01583462581038475, 0.02556558884680271, -0.01849294826388359, -0.07281118631362915,
    0.0735536739230156, 0.016804970800876617, 0.018224727362394333, -0.07023294270038605, -0.021798983216285706, -0.007191088516265154, 0.02190639264881611, 0.011542228981852531,
    0.0544636994600296, -0.0011388360289856791, 0.039145711809396744, -0.022878950461745262, 0.05790475010871887, -0.032992396503686905, 0.04632432013750076, 0.041644349694252014,
    -0.05233833193778992, 0.02209743671119213, 0.05953756347298622, -0.0193125382065773, 0.05370490998029709, 0.03292827680706978, 0.06342273950576782, 0.011383932083845139,
    0.05282653123140335, -0.056284140795469284, 0.012969831004738808, 0.059905171394348145, 0.03337574377655983, -0.03093932382762432, 0.04100716859102249, 0.04220465198159218,
    -0.08655901998281479, -0.001673179562203586, 0.03109750524163246, -0.005149237345904112, 0.04961910843849182, -0.0022458748426288366, 0.0190187469124794, 0.06252801418304443,
    -0.0849420353770256, -0.05857490375638008, 0.000811432721093297, -0.00847709458321333, -0.021136047318577766, -0.03188440948724747, -0.04071183502674103, 0.05300042778253555,
    -0.01283647958189249, 0.03019009344279766, 0.01814192719757557, -0.06411133706569672, -0.016141528263688087, 0.03514875844120979, -0.05082185938954353, -0.04179412126541138,
    0.005342321004718542, -0.04569409415125847, -0.003490198403596878, -0.049898259341716766, -0.006791203282773495, -0.15060792863368988, 0.0364450179040432, -0.015660958364605904,
    0.04353725537657738, -0.08661282807588577, 0.087561696767807, 0.08835981041193008, 0.04921659082174301, -0.025427302345633507, 0.025448257103562355, 0.005021742079406977,
    0.08191622793674469, 0.018867507576942444, -0.05077991262078285, 0.029637282714247704, 0.04102460667490959, -0.031940966844558716, -0.09575638175010681, 0.007370990235358477,
    -0.06759881228208542, 0.002017635852098465, -0.004873059224337339, -0.07999388128519058, 0.04181930422782898, 0.03366512805223465, 0.00415849918499589, 0.05318283289670944,
    -0.03111124411225319, 0.005647155921906233, 0.0023155019152909517, 0.015706701204180717, -0.018742654472589493, -0.019266249611973763, 0.023296015337109566, -0.026582397520542145,
    0.02419303171336651, -0.03697692230343819, 0.026871854439377785, -0.02306339517235756, 0.062029238790273666, -0.06603218615055084, 0.0487690195441246, -0.04197876527905464,
    -0.02505498193204403, 0.009125921875238419, -0.1429668664932251, -0.006786893587559462, 0.028525233268737793, -0.07064002752304077, -0.010726035572588444, 0.04676974192261696,
    -0.03226182609796524, 0.0013362966710701585, -0.05750318616628647, 0.06303240358829498, -0.057578664273023605, -0.045544810593128204, 0.0037642514798790216, 0.010189322754740715,
    0.021241523325443268, 0.05911027267575264, 0.02735128253698349, 0.03895151987671852, -0.035399604588747025, -0.008602491579949856, -0.010958661325275898, -0.012845860794186592,
    0.006182819604873657, -0.010193104855716228, 0.006820528768002987, 0.022759120911359787, -0.05239149555563927, -0.02986558899283409, -0.040075305849313736, -0.03717067837715149,
    0.022973721846938133, 0.02122008241713047, 0.03426583111286163, 0.012867067009210587, -0.0009922534227371216, 0.042246874421834946, 0.05013493448495865, 0.0004037427715957165,
    -0.07921954244375229, 0.008569234982132912, -0.014822659082710743, 0.01672939397394657, 0.01949152536690235, -0.03452295809984207, 0.04334724321961403, -0.0032010567374527454,
    -0.0081008430570364, -0.001912193256430328, 0.07692460715770721, 0.03948047384619713, 0.04974207282066345, 0.0589250773191452, 0.022269127890467644, 0.00548739917576313,
    0.01798431947827339, 0.016750667244195938, 0.046814192086458206, -0.03179606422781944, -0.008861236274242401, 0.00807704497128725, 0.004479765426367521, -0.027579309418797493,
    -0.034271735697984695, -0.004902887158095837, 0.13109859824180603, -0.01245304848998785, -0.023429926484823227, 0.07285209745168686, -0.0046802302822470665, 0.02600035071372986,
    0.06155581772327423, 0.07457087934017181, 0.01648665778338909, -0.013318310491740704, -0.023312116041779518, -0.02611471526324749, 0.04904492571949959, -0.0022205663844943047,
    -0.06856360286474228, 0.01582726277410984, -0.04406505823135376, -0.03082924336194992, 0.005947158671915531, 0.10152345895767212, 0.03257640823721886, -0.014916274696588516,
    -0.025863096117973328, 0.03743903711438179, -0.003110564313828945, 0.05063008517026901, 0.08835233002901077, -0.007808119989931583, -0.022173650562763214, 0.0163642056286335,
    0.030610550194978714, -0.012948926538228989, 0.06785938888788223, -0.03177938237786293, 0.05425911769270897, 0.026320818811655045, -0.033166300505399704, -0.07117760926485062,
    -0.028795523568987846, 0.047693923115730286, -0.01034516654908657, 0.028427934274077415, 0.05848319083452225, -0.023671751841902733, -0.03361913189291954, 0.029083827510476112,
    -0.06089933216571808, -0.1355036348104477, -0.035743772983551025, 0.010304729454219341, 0.03134797513484955, 0.0543341264128685, -0.049118101596832275, -0.012683060951530933,
    -0.011549518443644047, 0.012671957723796368, 0.024986708536744118, -0.03789471834897995, 0.04233439266681671, -0.044218484312295914, -0.010341803543269634, -0.039811570197343826,
    -0.030858447775244713, -0.001780436490662396, 0.0740458220243454, 0.023857735097408295, 0.01729089766740799, 0.15127262473106384, 0.024787504225969315, 0.010133479721844196,
    0.0803871676325798, 0.021356619894504547, 0.06467823684215546, 0.07634060084819794, 0.00867236964404583, 0.0016946797259151936, 0.031054053455591202, -0.008856615051627159,
    0.0304916612803936, 0.056562770158052444, 0.04763128608465195, 0.024715952575206757, -0.00019680616969708353, 0.09861719608306885, 0.04066474735736847, 0.05852857232093811,
    0.03607106953859329, -0.013759330846369267, -0.07195407897233963, 0.04640244320034981, 0.0015508863143622875, -0.03866671398282051, 0.022476503625512123, -0.05386305972933769,
    0.01884349435567856, -0.06946569681167603, 0.003618914168328047, 0.09270205348730087, -0.061907462775707245, 0.03796818107366562, 0.016566839069128036, -0.036058519035577774,
    -0.02356017380952835, -0.012132362462580204, -0.0665198490023613, 0.004607370588928461, 0.0065795909613370895, -0.014524457044899464, -0.005794986616820097, 0.01743396930396557,
    0.01592620462179184, -0.03132913261651993, -0.06942812353372574, 0.12315861880779266, 0.07420002669095993, 0.003619190538302064, -0.030036911368370056, 0.035308588296175,
    -0.01684315875172615, -0.0014653316466137767, 0.005904956255108118, -0.03728828579187393, -0.07904031872749329, 0.020498966798186302, 0.01686997152864933, -0.002828987780958414,
    -0.030504217371344566, -0.0071908640675246716, -0.021031344309449196, 0.012863672338426113, 0.0036712808068841696, -0.029212037101387978, -0.036121055483818054, -0.04135335609316826,
    0.01002062950283289, -0.017652200534939766, -0.012926006689667702, -0.006442751735448837, 0.03902449831366539, -0.03334544226527214, -0.021546320989727974, 0.019852768629789352,
    -0.0007643235148862004, -0.01535758189857006, 0.005370422266423702, -0.014435537159442902, 0.027987273409962654, 0.05711321905255318, 0.013022552244365215, 0.019359733909368515,
    0.026128478348255157, 0.11776431649923325, -0.03804538771510124, -0.08476287126541138, 0.019201019778847694, 0.0036112703382968903, 0.04206307232379913, 0.011226192116737366,
    0.05006219074130058, -0.05252690240740776, -0.09311983734369278, -0.03333020582795143, 0.0007301046862266958, 0.008481631055474281, -0.06375986337661743, 0.02983672358095646,
    0.01946195214986801, -0.03968164324760437, -0.0037405674811452627, -0.02728516422212124, 0.014168228954076767, 0.004741632379591465, 0.021158212795853615, 0.016156090423464775,
    0.03699941188097, 0.06216713786125183, -0.02235390990972519, -0.030101248994469643, -0.031030727550387383, 0.05429428443312645, 0.04483447223901749, 0.0020659214351326227,
    -0.014800443314015865, -0.06172404810786247, -0.02079971507191658, -0.04523366317152977, -0.040636271238327026, 0.03335176408290863, 0.007550919894129038, -0.0038798076566308737,
    0.005217745900154114, 0.012632020749151707, 0.008149220608174801, 0.02435525879263878, -0.0398515947163105, -0.0049188085831701756, -0.0647473931312561, 0.024865157902240753,
    0.011090444400906563, -0.052450355142354965, -0.010301732458174229, -0.027263794094324112, -0.05756135284900665, -0.03038819693028927, 0.1585201472043991, 0.029327653348445892,
    -0.07507185637950897, 0.0023069714661687613, -0.019658904522657394, -0.03941791504621506, -0.034922726452350616, 0.007520756218582392, -0.0028285307344049215, -0.02513737604022026,
    0.058369360864162445, 0.0090766167268157, -0.05018765479326248, -0.05681341513991356, -0.04345230013132095, 0.0512201189994812, -0.018176481127738953, -0.06507744640111923,
    0.05712170898914337, 0.08232435584068298, 0.09323763102293015, -0.012494721449911594, 0.03464624658226967, -0.015674911439418793, 0.031072527170181274, 0.0927569791674614,
    0.01615179516375065, 0.012241174466907978, 0.05773993581533432, -0.0009869334753602743, 0.02284565009176731, 0.022508880123496056, -0.017327038571238518, 0.00849114265292883,
    -0.02182181552052498, -0.039613887667655945, 0.003446524729952216, 0.017477180808782578, 0.044978752732276917, 0.018308475613594055, -0.0003284750855527818, 0.036876097321510315,
    0.06307008862495422, -0.03579934686422348, -0.01410521287471056, 0.03653845936059952, 0.047922126948833466, 0.010496615432202816, -0.014846253208816051, -0.004249678924679756,
    0.010047625750303268, -0.028951594606041908, -0.014568692073225975, -0.006423088256269693, 0.04296724125742912, -0.02209918573498726, 0.07385743409395218, 0.11270224303007126,
    -0.07420766353607178, -0.04450265318155289, -0.007596905808895826, 0.03907877951860428, 0.008217280730605125, 0.01046708133071661, 0.08084976673126221, -0.06339988112449646,
    -0.03629465028643608, -0.0028733275830745697, -0.11714004725217819, 0.02726704254746437, -0.0009626462706364691, -0.09182404726743698, -0.00013225807924754918, 0.0007585161365568638,
    0.10352349281311035, -0.15737707912921906, -0.05331806093454361, -0.035147495567798615, -0.034729424864053726, -0.06718111783266068, -0.04020407050848007, 0.02927957847714424,
    -0.0799332931637764, -0.021125350147485733, 0.08139996230602264, -0.05189889669418335, 0.02780253253877163, -0.0002438557567074895, -0.04347525164484978, -0.050854235887527466,
    0.059851471334695816, -0.01764301210641861, 0.02087537758052349, -0.09643261134624481, 0.007731020450592041, 0.019733907654881477, -0.0706138014793396, -0.03628147020936012,
    0.02888261154294014, 0.029390450567007065, 0.0012155133299529552, -0.004649524576961994, 0.02227279357612133, 0.08077248185873032, -0.0207083597779274, -0.008506802842020988,
    -0.030080677941441536, -0.013612685725092888, -0.03855697438120842, -0.004967863671481609, -0.03458752855658531, -0.026888705790042877, 0.03410853445529938, 0.10366760939359665,
    -0.04187917709350586, 0.033097993582487106, 0.0796239897608757, -0.007895929738879204, 0.004580349661409855, 0.10463161766529083, -0.08237094432115555, -0.017176546156406403,
    -0.08584535866975784, 0.0810585469007492, -0.025098374113440514, 0.12889377772808075, 0.010651705786585808, -0.04155765846371651, 0.07621422410011292, -0.031935010105371475,
    -0.026649421080946922, 0.09515991061925888, 0.024160411208868027, -0.02627534791827202, 0.06952817738056183, 0.021752117201685905, 0.030622776597738266, -0.08262109756469727,
    0.007929815910756588, 0.0032590667251497507, 0.05420240759849548, -0.019445978105068207, -0.04934704303741455, 0.030707497149705887, 0.05837017670273781, -0.06076335534453392,
    0.019251380115747452, -0.06367219984531403, -0.07703382521867752, 0.0010228990577161312, -0.007415181025862694, 0.06071901693940163, 0.07099033892154694, -0.04531775042414665,
    -0.020862871780991554, -0.028840379789471626, 0.028443118557333946, -0.061049167066812515, -0.046506572514772415, 0.02085215412080288, -0.02900705486536026, 0.004427018575370312,
    0.03920893743634224, -0.01600305363535881, 0.013627810403704643, -0.03561390936374664, -0.012507614679634571, -0.09816749393939972, -0.0046584727242589, 0.06320472806692123,
    -0.10023842751979828, 0.01312082726508379, -0.011914607137441635, -0.013304367661476135, -0.07576841861009598, 0.03339514881372452, -0.003592405002564192, -0.011710761114954948,
    0.12941685318946838, -0.039673611521720886, 0.03421390801668167, 0.005345923826098442, 0.021222980692982674, -0.036730773746967316, -0.005777865182608366, 0.026500388979911804,
    -0.0569399930536747, 0.011580982245504856, 0.015708044171333313, -0.018696937710046768, -0.01128305308520794, 0.014132142066955566, 0.017616841942071915, -0.019259702414274216,
    0.002935590920969844, -0.025147851556539536, -0.10490790754556656, -0.05354159325361252, 0.021270819008350372, 0.033328406512737274, -0.017157450318336487, -0.03154689818620682,
    -0.05968811362981796, 0.12364891916513443, -0.038127779960632324, 0.08807544410228729, 0.019971437752246857, 0.03879118338227272, -0.004275355488061905, 0.040580034255981445,
    0.023890336975455284, 0.008431828580796719, -0.06612986326217651, -0.00348761398345232, -0.036750536412000656, 0.08105294406414032, -0.04693926125764847, 0.01291931513696909,
    0.06300802528858185, -0.03069145232439041, 0.0003849031636491418, -0.04403022676706314, 0.05032096803188324, -0.02777395211160183, -0.06699441373348236, -0.0037504828069359064,
    0.02761860564351082, -0.03393366187810898, -0.03872052952647209, 0.054562315344810486, 0.053571268916130066, 0.08302876353263855, -0.09688829630613327, 0.01888859272003174,
    0.04702415689826012, -0.01894671842455864, -0.03576919436454773, -0.012631111778318882, 0.025817569345235825, -0.03810283914208412, -0.01927150972187519, 0.08346803486347198,
    0.002628110349178314, -0.015853455290198326, -0.029549892991781235, 0.05603184923529625, 0.043138787150382996, -0.02604953944683075, 0.004894910845905542, 0.014657591469585896,
    -0.03722093626856804, -0.018741145730018616, -0.0040935249999165535, 0.03770614042878151, -0.027965059503912926, 0.05099273473024368, 0.09602261334657669, -0.08841938525438309,
    0.029683366417884827, 0.043310411274433136, 0.020728252828121185, -0.06364288181066513, -0.02125212363898754, 0.009156066924333572, 0.02963489480316639, -0.15475241839885712,
    -0.00031184277031570673, -0.01191545370966196, 0.037376437336206436, 0.04414815455675125, 0.0004472209548112005, 0.029353035613894463, -0.050913725048303604, -0.024473823606967926,
    0.0464271642267704, 0.011523549444973469, -0.015101571567356586, -0.022558636963367462, 0.05485719442367554, 0.06253058463335037, 0.03071621246635914, -0.05188114196062088,
    -0.025082696229219437, 0.053680308163166046, 0.05909932404756546, 0.04901807755231857, 0.03827662020921707, -0.025633862242102623, 0.069163978099823, -0.015437420457601547,
    -0.002391889225691557, 0.05224832147359848, 0.004854778293520212, 0.004720691591501236, -0.010206230916082859, 0.051517803221940994, -0.0001195031072711572, -0.0539834164083004,
    -0.05251147225499153, -0.0050972821190953255, -0.07658090442419052, -0.018453404307365417, -0.0001215842567034997, -0.029437340795993805, 0.028839094564318657, 0.006895252037793398,
    0.09428787976503372, -0.025995314121246338, 0.006755823269486427, -0.017354777082800865, -0.03637699782848358, -0.017226314172148705, 0.021795256063342094, -0.028962718322873116,
    -0.0391925647854805, 0.09317117929458618, 0.06468232721090317, 0.01744665391743183, -0.004011259879916906, -0.03991831839084625, -0.013523567467927933, -0.04217762500047684,
    -0.03031153604388237, -0.034392569214105606, -0.07127902656793594, 0.055265020579099655, 0.00888915453106165, -0.08333905786275864, -0.03384917601943016, -0.04599734768271446,
    0.0912524163722992, -0.025158312171697617, 0.004052054136991501, 0.05408739298582077, -0.041166823357343674, -0.006544878240674734, 0.08505022525787354, 0.058999933302402496,
    -0.0487220324575901, 0.004322756547480822, 0.04211105406284332, -0.02381431683897972, 0.024995850399136543, 0.049027781933546066, -0.07261187583208084, 0.0006187947001308203,
    -0.0773962140083313, -0.028258075937628746, -0.04637676104903221, 0.01852785237133503, -0.001321990741416812, -0.09860642999410629, -0.06868506222963333, 0.06500887870788574,
    -0.032792747020721436, -0.03807307779788971, 0.028886426240205765, 0.04625054821372032, 0.017813891172409058, 0.026052890345454216, 0.02170558273792267, 0.007309387903660536,
    0.09827644377946854, -0.03240732476115227, 0.014979217201471329, -0.0313369482755661, -0.06434667855501175, 0.055018674582242966, 0.04146679490804672, 0.07779869437217712,
    -0.002469003899022937, -0.033955737948417664, -0.03977303206920624, 0.03756403177976608, -0.01060815341770649, 0.012359852902591228, -0.015425115823745728, 0.026435168460011482,
    0.05813276767730713, -0.01506818551570177, -0.04106797277927399, -0.012114301323890686, -0.02316657267510891, -0.02775830216705799, 0.05681208148598671, -0.0728028193116188,
    -0.03470267355442047, -0.03323473036289215, 0.030591491609811783, 0.014141620136797428, 0.022723136469721794, 0.053300973027944565, -0.021804114803671837, -0.041484933346509933,
    0.02327892743051052, 0.008827313780784607, 0.0067296684719622135, 0.004361484665423632, -0.012034330517053604, -0.10341202467679977, 0.008538506925106049, -0.05644436553120613,
    0.011746172793209553, -0.025009721517562866, 0.047302260994911194, -0.0039240699261426926, 0.09535184502601624, -0.08627738058567047, 0.0009756037616170943, 0.08771361410617828,
    0.038740843534469604, -0.01669551059603691, 0.015054497867822647, 0.034085962921381, -0.011009941808879375, 0.01689957082271576, -0.012477798387408257, 0.04010633006691933,
    0.012327291071414948, -0.017353342846035957, 0.012917755171656609, 0.04860541597008705, 0.0909668430685997, -0.005576170980930328, -0.01281365379691124, -0.02515246532857418,
    0.020557500422000885, 0.06250397861003876, -0.015772441402077675, -0.04905093461275101, -0.06705334782600403, -0.03812939301133156, -0.005825352389365435, -0.04064910113811493,
    -0.017988266423344612, -0.028566604480147362, 0.01297092903405428, -0.027637874707579613, 0.00564245879650116, -0.17035572230815887, 0.03241444379091263, 0.023531083017587662,
    0.0273092370480299, 0.07920043915510178, 0.007894342765212059, -0.04840278625488281, 0.017088765278458595, 0.04410277679562569, 0.049668051302433014, -0.03834737464785576,
    0.02915995940566063, -0.023202938959002495, -0.05404379963874817, -0.002732694149017334, 0.04499812051653862, -0.06655815988779068, 0.05330546200275421, 0.02771684341132641,
    0.01452221442013979, -0.08337919414043427, -0.06979981064796448, 0.010013049468398094, 0.00652345409616828, 0.009288273751735687, -0.0413750484585762, 0.02209286391735077,
    0.04250437393784523, -0.006491269916296005, 0.03273042291402817, 0.013257453218102455, -0.013161671347916126, 0.014889596961438656, -0.036188218742609024, 0.0035700667649507523,
    0.04149000346660614, -0.023539161309599876, 0.07885666936635971, -0.06492406874895096, 0.022798137739300728, -0.03186885640025139, -0.041900843381881714, -0.013806108385324478,
    -0.060207877308130264, 0.011653185822069645, 0.01585221476852894, -0.022484587505459785, 0.054552897810935974, 0.014444172382354736, -0.02594246156513691, 0.028124991804361343,
    0.022476110607385635, -0.0027263318188488483, 0.0468420535326004, 0.03133067488670349, -0.052007950842380524, 0.02107628993690014, -0.027647465467453003, -0.006910276133567095,
    -0.034686848521232605, -0.03239154443144798, 0.0364522747695446, -0.04421845078468323, -0.01942138560116291, 0.14176560938358307, 0.0987842008471489, 0.032085344195365906,
    -0.030016731470823288, 0.061269376426935196, -0.003980686888098717, 0.03169824555516243, 0.06167878583073616, 0.002446818398311734, 0.05885489284992218, -0.023071452975273132,
    -0.039196643978357315, 0.056956175714731216, 0.027477987110614777, 0.019935529679059982, 0.02103370986878872, 0.03328549116849899, 0.12044673413038254, 0.16338160634040833,
    0.06675194948911667, -0.020116377621889114, -0.024002403020858765, 0.02083427831530571, -0.04864952340722084, -0.024869883432984352, -0.04049324989318848, 0.006479264236986637,
    -0.06661670655012131, 0.007853723131120205, -0.027001306414604187, 0.04802282154560089, -0.02320759929716587, 0.029598690569400787, 0.006041236221790314, -0.05075151473283768,
    -0.009439275600016117, 0.02858424372971058, -0.022149711847305298, 0.06002257391810417, 0.017162932083010674, -0.005444351118057966, -0.041168127208948135, -0.015306160785257816,
    0.00639873743057251, -0.03530405834317207, -0.04290401190519333, -0.0010464164661243558, 0.025221606716513634, 0.025678537786006927, 0.00016863681958056986, -0.011989403516054153,
    0.01018926128745079, 0.017252232879400253, -0.042940404266119, 0.04040012136101723, -0.07609546184539795, 0.05385146290063858, 0.0035782097838819027, -0.0658184140920639,
    0.058369752019643784, -0.033722687512636185, -0.00547963660210371, -0.0006069363444112241, -0.0011547848116606474, -0.039392683655023575, -0.0981466993689537, 0.061000097543001175,
    -0.04897533357143402, -0.01861822046339512, 0.019201207906007767, 0.017076602205634117, -0.0051252287812530994, -0.021756375208497047, -0.039335060864686966, 0.05998937413096428,
    0.014474266208708286, -0.016863737255334854, -0.043404266238212585, -0.03547307103872299, 0.05325958877801895, 0.06491334736347198, 0.012378619983792305, 0.009095600806176662,
    -0.09790270030498505, 0.10861086845397949, -0.09370924532413483, -0.027681687846779823, 0.004858007654547691, 0.05005316808819771, 0.02949381433427334, -0.002730856416746974,
    0.004929009359329939, 0.037624213844537735, -0.08191094547510147, -0.020975464954972267, 0.01909707859158516, 0.0704735517501831, -0.02058507688343525, -0.037840306758880615,
    -0.07114352285861969, 0.0031114153098315, -0.05758459493517876, -0.04608694836497307, 0.07175510376691818, 0.008226078934967518, 0.03371608629822731, -0.08378203213214874,
    -0.009022057987749577, 0.04392820596694946, 0.060501497238874435, 0.05855661630630493, 0.034356098622083664, -0.017534589394927025, -0.020475761964917183, -0.029702352359890938,
    0.005972730927169323, -0.0090546989813447, -0.07964033633470535, -0.005266255233436823, -0.01511911116540432, -0.04730089381337166, -0.004965017084032297, -0.05694892257452011,
    -0.011443697847425938, 0.0648488774895668, 0.022367233410477638, 0.027360524982213974, -0.068180613219738, -0.033471837639808655, -0.059766847640275955, 0.008562039583921432,
    -0.04240948706865311, -0.0752015933394432, -0.017983771860599518, 0.01144030038267374, 0.12127943336963654, -0.014157557860016823, -0.013384159654378891, -0.10812364518642426,
    -0.04370250552892685, -0.045726366341114044, 0.044887591153383255, -0.09910357743501663, -0.05861338973045349, -0.027058105915784836, 0.024303331971168518, 0.09792676568031311,
    -0.035881150513887405, -0.014682749286293983, 0.003786092158406973, 0.04380439221858978, -0.022450663149356842, -0.015639349818229675, 0.027447860687971115, -0.05469118431210518,
    -0.03726004436612129, 0.04577486589550972, -0.025922760367393494, -0.06965440511703491, -0.0385306142270565, -0.0014973252546042204, 0.04100295901298523, -0.028524838387966156,
    -0.03794851899147034, 0.06274330615997314, -0.08139755576848984, -0.02604808658361435, 0.015289097093045712, -0.006537273991852999, 0.08156058937311172, 0.026041444391012192,
    -0.003163012908771634, -0.012751871719956398, 0.06277243047952652, -0.046142879873514175, 0.05598194897174835, -0.04901943728327751, -0.06047568470239639, 0.04224541783332825,
    -0.13245537877082825, -0.08688919991254807, 0.006867328193038702, -0.01692887209355831, -0.0436682365834713, 0.03200722858309746, 0.01870664954185486, 0.07251036912202835,
    -0.0066405790857970715, -0.023979682475328445, -0.05408180132508278, -0.009261867962777615, -0.026724429801106453, 0.052202798426151276, 0.015176012180745602, -0.09205649048089981,
    -0.030458511784672737, -0.11502590030431747, -0.01593969762325287, 0.021650828421115875, -0.014823098666965961, -0.014758708886802197, 0.024165404960513115, -0.03295633941888809,
    -0.006492439657449722, -0.057182300835847855, -0.006417571101337671, 0.007788998540490866, -0.01756514050066471, -0.10525614023208618, -0.0007101361406967044, -0.004725506529211998,
    0.13530996441841125, -0.13274617493152618, 0.001517734257504344, -0.06190631911158562, 0.013019930571317673, 0.01916126161813736, 0.02855788543820381, -0.03337499499320984,
    -0.04035411402583122, -0.02527620457112789, 0.07155875116586685, -0.02161594294011593, -0.001298431889154017, 0.04262351989746094, 0.08019175380468369, 0.06618419289588928,
    -0.06367842108011246, 0.029916170984506607, 0.03494878113269806, -0.0016612644540145993, -0.03634386882185936, 0.05951870605349541, 0.05328621342778206, -0.018247032538056374,
    0.06886501610279083, -0.06686379760503769, 0.003667483339086175, 0.03394855931401253, -0.01868433505296707, -0.02992483228445053, -0.028930742293596268, 0.02197054587304592,
    0.010256105102598667, -0.030233250930905342, 0.018331794068217278, 0.056071020662784576, 0.06934922933578491, 0.07500430941581726, 0.052681248635053635, -0.0018811342306435108,
    -0.004883517511188984, -0.021748913452029228, 0.0430799163877964, 0.034861791878938675, -0.01399203110486269, 0.04451396316289902, -0.07519185543060303, 0.07706381380558014,
    0.06758952140808105, 0.07307269424200058, 0.058743905276060104, -0.07800595462322235, -0.011432649567723274, 0.05900813266634941, 0.05404188111424446, -0.00699688820168376,
    0.022453369572758675, 0.024627283215522766, 0.03219585493206978, 0.04449189826846123, 0.027549350634217262, 0.08769415318965912, 0.021821867674589157, -0.016984736546874046,
    0.03729240968823433, -0.018182722851634026, -0.07008782774209976, 0.0632895976305008, -0.047331634908914566, -0.006417195778340101, -0.07670582830905914, -0.034561093896627426,
    -0.016125140711665154, -0.015499038621783257, 0.010953116230666637, 0.0005671466933563352, -0.015018240548670292, 0.0007037937757559121, -0.039858847856521606, 0.06465290486812592,
    0.01952407881617546, -0.01935679279267788, 0.011881033889949322, 0.008503670804202557, 0.029555436223745346, -0.06931830942630768, 0.0005238255253061652, -0.009148853830993176,
    0.00015498667198698968, -0.013142477720975876, -0.01987849362194538, 0.03037659451365471, -0.026516256853938103, -0.12847545742988586, -0.010530984029173851, 0.004170740023255348,
    0.0323154479265213, 0.0004180646501481533, -0.005942710675299168, 0.02617003209888935, 0.006496613845229149, -0.017365921288728714, -0.012129251845180988, 0.007611569948494434,
    0.03572157397866249, 0.015685033053159714, -0.02327292412519455, -0.029262270778417587, 0.024487270042300224, 0.03665447235107422, 0.05720486491918564, 0.03139287233352661,
    0.015507141128182411, 0.002543928101658821, 0.002343151019886136, 0.10228414833545685, 0.023384567350149155, -0.016943391412496567, 0.005140320863574743, -0.042551107704639435,
    0.017400754615664482, 0.03166596218943596, -0.0397423692047596, -0.025898423045873642, -0.029827069491147995, 0.03340376913547516, -0.00020131983910687268, -0.0221044160425663,
    -0.029540512710809708, 0.005909966304898262, -0.04915158450603485, 0.03030293434858322, 0.09696411341428757, -0.010931948199868202, -0.046173952519893646, 0.04825308918952942,
    -0.0037637106142938137, 0.04439299926161766, 0.014888782985508442, -0.04798406362533569, -0.040854014456272125, -0.030611658468842506, 0.07857727259397507, 0.02004994824528694,
    0.02662418596446514, -0.009966970421373844, -0.01341771986335516, -0.009918865747749805, 0.03013007901608944, 0.02551603503525257, -0.02764013037085533, 0.01814623549580574,
    -0.08524320274591446, 0.0014210202498361468, 0.053568772971630096, 0.014546369202435017, -0.03398514911532402, 0.00923830084502697, -0.09065946936607361, 0.023769978433847427,
    0.07311057299375534, 0.10363882035017014, -0.02306394651532173, -0.021504340693354607, -0.027975331991910934, -0.0025857496075332165, 0.022206328809261322, 0.01780320517718792,
    -0.08010713011026382, -0.016288697719573975, -0.017478445544838905, 0.007061016280204058, -0.002266247058287263, 0.0017787625547498465, 0.015861399471759796, 0.005993389990180731,
    0.004277023486793041, -0.0066727628000080585, 0.03714971989393234, -0.008562403731048107, 0.014760513789951801, 0.01836245134472847, -0.0017085314029827714, 0.035961080342531204,
    0.01319512352347374, 0.04424484819173813, 0.020935241132974625, 0.0697309672832489, 0.0076516782864928246, 0.015352983959019184, -0.01947130262851715, 0.0539085678756237,
    0.03344206139445305, -0.0462382547557354, -0.002293293597176671, 0.016660025343298912, -0.04180797189474106, -0.009909349493682384, -0.016816595569252968, 0.05412055552005768,
    -0.03267938271164894, -0.023957422003149986, 0.02050538919866085, -0.052140358835458755, -0.022267259657382965, 0.03371252492070198, -0.061711303889751434, -0.0034879734739661217,
    0.04105043783783913, -0.03367473557591438, 0.019820626825094223, -0.010621869936585426, 0.012968362309038639, -0.01580411195755005, -0.0276245828717947, -0.025687281042337418,
    -0.02191496267914772, 0.0037123621441423893, -0.027814190834760666, 0.036511991173028946, -0.08797881007194519, 0.060428354889154434, -0.036583397537469864, 0.023152722045779228,
    0.03179381042718887, -0.030534330755472183, 0.030754663050174713, -0.03460372984409332, -0.02582896500825882, -0.04513769969344139, 0.00812164694070816, -0.045168932527303696,
    0.024165796115994453, 0.03748343512415886, 0.007438804488629103, -0.019773269072175026, 0.035029176622629166, 0.002325142500922084, -0.06360745429992676, -0.012759223580360413,
    -0.03415418043732643, 0.01658007502555847, 0.005310609005391598, 0.03479868546128273, -0.023035861551761627, -0.024741165339946747, -0.03215109184384346, 0.02124934457242489,
    0.052219852805137634, -0.0022378398571163416, -0.03410179913043976, -0.05003182217478752, -0.013600479811429977, 0.01051381602883339, -0.053145866841077805, 0.05367785692214966,
    -0.0023821417707949877, -0.0038458076305687428, -0.01417283620685339, -0.0009789593750610948, 0.04187621548771858, 0.0038999486714601517, -0.017881033942103386, -0.022045068442821503,
    -0.006438655313104391, -0.007622541859745979, 0.005498920101672411, -0.005815085954964161, 0.014170537702739239, -0.009883175604045391, 0.05945754051208496, -0.0033016586676239967,
    0.014806908555328846, -0.013914428651332855, 0.008165710605680943, -0.016151893883943558, -0.007155179046094418, 0.002862624591216445, -0.003845387604087591, 0.04277355596423149,
    -0.024722496047616005, 0.032575394958257675, 0.00023718681768514216, 0.039887551218271255, 0.020040418952703476, 0.04187297448515892, -0.032850705087184906, 0.004380010534077883,
    0.010540478862822056, 0.015211611986160278, -0.028345707803964615, -0.022284504026174545, 0.003111911006271839, -0.006868542637676001, 0.05867832526564598, 0.05505302920937538,
    -0.048383526504039764, 0.050950247794389725, -0.026021594181656837, 0.04109135642647743, -0.03597892448306084, -0.012306167744100094, 0.04513276368379593, -0.05917976796627045,
    -0.014083733782172203, 0.01660327799618244, 0.038891829550266266, 0.017306959256529808, 0.00918683409690857, 0.020724209025502205, -0.025596827268600464, 0.01567922718822956,
    -0.03181018680334091, 0.023634588345885277, -0.013363818638026714, -0.003030942054465413, -0.015795879065990448, -0.031248673796653748, -0.01629960723221302, -0.03462730348110199,
    0.004281143192201853, -0.04303797334432602, -0.0656624585390091, -0.05706348270177841, 0.0037906707730144262, -0.04486297443509102, 0.020740877836942673, 0.04489406570792198,
    -0.002413250971585512, 0.004667241591960192, -0.003672088962048292, 0.0384916253387928, -0.0008710717083886266, -9.255430086341221e-06, -0.043905749917030334, 0.030484573915600777,
    -0.014213942922651768, 0.03488810360431671, -0.018476665019989014, 0.03849906101822853, -0.03175538405776024, -0.019718503579497337, 0.021963052451610565, 0.025303326547145844,
    0.02023574896156788, -0.0448395311832428, 0.021161478012800217, 0.02417798712849617, -0.03848154842853546, -0.030997255817055702, 0.026024095714092255, 0.0010759953875094652,
    -0.043191682547330856, 0.009500459767878056, 0.021759992465376854, -0.027579525485634804, -0.03957899659872055, 0.015188086777925491, -0.0014411300653591752, -0.020825279876589775,
    0.01738070882856846, 0.05019805207848549, 0.0198055487126112, 0.013162318617105484, -0.0174462478607893, -0.027225298807024956, -0.02231062762439251, 0.018219098448753357,
    -0.008445708081126213, -0.03202706202864647, -0.022318989038467407, -0.010299019515514374, 0.03125240281224251, 0.011297110468149185, 0.010782531462609768, 0.011800097301602364,
    0.0274081751704216, 0.024027496576309204, -0.008690742775797844, 0.04619354009628296, -0.0023874505423009396, -0.02903003618121147, 0.013552944175899029, 0.06130487844347954,
    -0.021738240495324135, -0.00804065354168415, 0.035577669739723206, -0.07989814132452011, 0.0001869397674454376, 0.011786110699176788, 0.0020391105208545923, 0.00966273806989193,
    -0.03530697524547577, -0.003928682766854763, -0.01720687747001648, -0.017426583915948868, 0.04135063290596008, -0.02804180048406124, -0.034118473529815674, 0.018120788037776947,
    0.007753393612802029, -0.005596123170107603, -0.012438426725566387, -0.006312147714197636, -0.01649157702922821, -0.024584440514445305, 0.04270678013563156, -0.0301000215113163,
    0.03819959983229637, 0.02545355074107647, -0.05952586606144905, 0.019459761679172516, 0.004074241034686565, -0.00781259685754776, -0.018564751371741295, 0.008114631287753582,
    -0.014077901840209961, 0.05782347172498703, 0.013263873755931854, 0.0073076155968010426, 0.03351602703332901, 0.008232823573052883, 0.02128048986196518, 0.026691628620028496,
    0.01158059947192669, -0.04254615306854248, 0.0029886921402066946, 0.002135194605216384, 0.013111740350723267, 0.031055666506290436, 0.014804086647927761, -0.022113395854830742,
    0.048117753118276596, -0.01562596671283245, -0.001015428570099175, -0.002875163685530424, 0.004426942206919193, -0.0149695361033082, -0.011441457085311413, 0.03995241969823837,
    0.011883595027029514, 0.02468906156718731, -0.017404679208993912, 0.03413164243102074, 0.015258729457855225, 0.05420837923884392, -0.005365258082747459, -0.023088723421096802,
    -0.01520282868295908, -0.05894756689667702, -0.0048852101899683475, 0.06434005498886108, -0.009338484145700932, -0.04215862229466438, -0.00803337525576353, -0.03465297818183899,
    0.010117749683558941, 0.0013890259433537722, -0.0112478481605649, 0.054751429706811905, 0.006731678266078234, -0.006540374364703894, -0.04322359338402748, -0.0165066197514534,
    0.02716526761651039, -0.012419118545949459, -0.036060579121112823, 0.02613574080169201, 0.009692121297121048, -0.04182034358382225, -0.009316833689808846, 0.021504279226064682,
    -0.02947348728775978, 0.031924959272146225, -0.0035755750723183155, 0.02249038591980934, -0.038106150925159454, -0.023354750126600266, 0.011232628487050533, -0.010536903515458107,
    -0.01505784410983324, -0.027400163933634758, 0.022252196446061134, -0.00823716726154089, 0.03196629881858826, -0.027132166549563408, -0.01766430400311947, 0.020532460883259773,
    -0.008741786703467369, 0.019810516387224197, -0.00775440689176321, -0.009280930273234844, 0.023875702172517776, 0.0018987219082191586, -0.011737081222236156, -0.017564337700605392,
    0.024900544434785843, 0.01782904751598835, -0.08680574595928192, -0.0010491835419088602, 0.016627371311187744, 0.012382840737700462, 0.020792704075574875, -0.02610912173986435,
    -0.01313865277916193, -0.011016663163900375, -0.04808877408504486, -0.016328003257513046, -0.004438257310539484, 0.03856615349650383, -0.004427013918757439, 0.0012732403120025992,
    0.023829594254493713, -0.014122058637440205, 0.032613128423690796, 0.019154610112309456, 0.00951353833079338, -0.03133769705891609, 0.013154563494026661, -0.002301625907421112,
    -0.002139277057722211, -0.018735777586698532, 0.027572041377425194, 0.0007090367726050317, -0.02310587279498577, -0.05089432746171951, -0.01159852184355259, 0.0418575257062912,
    0.0030169477686285973, -0.012595579028129578, 0.004486849531531334, 0.0026819624472409487, 0.008308228105306625, 0.009962527081370354, -0.005124712362885475, -5.839821096742526e-05,
    -0.022618398070335388, -0.0087851257994771, -0.008263589814305305, -0.008660625666379929, -0.05643273890018463, 0.04303096607327461, -0.02712484635412693, -0.0006019219872541726,
    0.03766656666994095, 0.03800838068127632, -0.020501747727394104, 0.031300246715545654, -0.012336872518062592, 0.010562373325228691, -0.008407602086663246, -0.01718294993042946,
    0.003967770375311375, 0.05255722999572754, -0.003509856527671218, 0.021189074963331223, 0.02300627902150154, -0.016712529584765434, -0.010955401696264744, 0.04374149814248085,
    -0.008855526335537434, 0.005684711504727602, 0.0386774018406868, 0.005385918077081442, 0.019668083637952805, 0.04090733826160431, -0.01976296864449978, 0.030964283272624016,
    -0.01716756820678711, 0.018899738788604736, -0.0015461747534573078, 0.0007151263416744769, 0.03424515202641487, 0.058167632669210434, 0.033703673630952835, -0.00828191265463829,
    -0.011289693415164948, -0.046508967876434326, -0.002818822395056486, 0.009955988265573978, 0.010446753352880478, 0.007362615782767534, 0.02742653898894787, -0.021968448534607887,
    -0.03279847279191017, -0.0070116231217980385, 0.0014135991223156452, 0.058675024658441544, -0.011149350553750992, 0.009971529245376587, -0.025280099362134933, 0.0013351556845009327,
    0.04407009482383728, -0.01032322272658348, 0.02783474326133728, -0.003689342178404331, -0.013579628430306911, 0.040485452860593796, 0.037488922476768494, 0.033896297216415405,
    0.004860465414822102, -0.0021778205409646034, -0.028488999232649803, 0.019238945096731186, 0.014791538938879967, 0.013999768532812595, 0.006255864631384611, 0.03686090186238289,
    0.005361638031899929, 0.00511838449165225, -0.013706640340387821, 0.007909264415502548, -0.014085317961871624, -0.007803218439221382, 0.024379638954997063, -0.07972975075244904,
    -0.016905346885323524, 0.016571316868066788, -0.006838726811110973, -0.05008717626333237, -0.01042024977505207, -0.01824910193681717, -0.0039115240797400475, -0.0036442053969949484,
    -0.01897590421140194, 0.0014297985471785069, -0.012086073867976665, -0.0077139767818152905, 0.0014147587353363633, -0.031802330166101456, -0.03315500542521477, 0.02089189924299717,
    -0.00024819059763103724, 0.021185733377933502, -0.02476157620549202, 0.004477201960980892, 0.0023409740533679724, -0.05590447783470154, 0.02364225871860981, 0.007688972633332014,
    -0.005429035052657127, 0.006477035116404295, -0.06685736775398254, 0.018729956820607185, -0.01369532011449337, -0.014792891219258308, 0.05094518885016441, 0.011904304847121239,
    -0.07057612389326096, -0.015336275100708008, -0.03263530880212784, 0.03484742343425751, -0.006070495117455721, 0.01574893109500408, -0.01776358298957348, -0.015607618726789951,
    0.012978545390069485, -0.014922461472451687, -0.025305617600679398, 0.037757083773612976, 0.023837978020310402, 0.008023794740438461, -0.02997574582695961, -0.005402532871812582,
    -0.060908377170562744, 0.02140435390174389, 0.038186509162187576, -0.025278307497501373, -0.014365260489284992, 0.007292401045560837, 0.01414357591420412, 0.010738792829215527,
    0.08053949475288391, -0.009244008921086788, 0.008009505458176136, -0.025538580492138863, 0.008370875380933285, -0.013230717740952969, 0.002252213889732957, -0.010676666162908077,
    0.029477559030056, -0.02157530002295971, -0.013377495110034943, 0.04128260537981987, -0.006058903876692057, 0.02440636232495308, 0.030344365164637566, -0.044758789241313934,
    -0.01412741094827652, 0.006419573910534382, -1.9411389075685292e-05, 0.054828010499477386, 0.0014878694200888276, 0.008843963034451008, -0.009764226153492928, -0.02239198051393032,
    0.005885757505893707, -0.018805136904120445, -0.02131478860974312, 0.0034644417464733124, 0.0032512058969587088, 0.0014424532419070601, -0.0056592002511024475, 0.006907750852406025,
    -0.03320106863975525, -0.012387087568640709, -0.023289861157536507, -0.019102782011032104, 0.0232450719922781, -0.032567985355854034, 0.001397405518218875, 0.012429352849721909,
    0.0025218382943421602, -0.004519031848758459, 0.009217322804033756, -0.050669532269239426, 0.019380154088139534, 0.010305697098374367, 0.012661565095186234, -0.012290991842746735,
    -0.04123229533433914, -0.014834017492830753, 0.008976001292467117, 0.03523166477680206, 0.0038153594359755516, -0.03921947255730629, 0.004385161213576794, -0.007006226107478142,
    -0.010249956510961056, -0.010022146627306938, -0.009660132229328156, -0.005469048861414194, -0.02060096524655819, -0.026796139776706696, -0.041095878928899765, -0.014039292000234127,
    0.03762542083859444, 0.024046314880251884, 0.03185455501079559, 0.012353009544312954, -0.01954624615609646, 0.029414698481559753, -0.04687882214784622, -0.008232725784182549,
    -0.0270505640655756, -0.003490845439955592, -0.044389136135578156, 0.0335121713578701, -0.015946542844176292, 0.04238983988761902, -0.021756611764431, 0.002235822379589081,
    0.0056385076604783535, 0.018220821395516396, 0.003439255291596055, 0.06854403764009476, -0.009715068154036999, 0.020843401551246643, -0.047352053225040436, 0.020086735486984253,
    -0.0012760577956214547, 0.004806538578122854, 0.025223305448889732, 0.014736449345946312, -0.003293336136266589, 0.0320502445101738, -0.03563442826271057, 0.03039274923503399,
    -0.027235498651862144, 0.014542712830007076, 0.05185949057340622, 0.00020187057089060545, -0.05011051893234253, -0.0276056956499815, 0.023063357919454575, 0.0063624815084040165,
    -0.023707924410700798, 0.01389741338789463, 0.01938679814338684, -0.016344444826245308, -0.026682842522859573, 0.0019513021688908339, 0.023098058998584747, 0.06471821665763855,
    -0.005169866140931845, -0.026831263676285744, 0.020147494971752167, 0.017224961891770363, -0.030380239710211754, 0.012476216070353985, 0.00582055514678359, -0.020002121105790138,
    0.03549240902066231, 0.00780512997880578, -0.03152301162481308, 0.019354714080691338, 0.00894070416688919, 0.06020895391702652, 0.03391147404909134, -0.0005492607015185058,
    -0.025369031354784966, 0.0019942321814596653, -0.016700150445103645, -0.008545261807739735, -0.025398271158337593, 0.018157709389925003, 0.004924379289150238, 0.024681206792593002,
    0.014190509915351868, -0.00682014599442482, -0.004025173373520374, -0.010892961174249649, 0.029492394998669624, 0.042958322912454605, 0.02469373308122158, -0.04769067093729973,
    0.02466803416609764, -0.01612950675189495, 0.008671491406857967, -0.0055906446650624275, 0.019282201305031776, 0.018308000639081, -0.004058256279677153, 0.002460654592141509,
    0.03902733698487282, 0.013314083218574524, -0.028037179261446, 0.038989730179309845, 0.00951100792735815, -0.011886651627719402, -0.02847789041697979, -0.013229872100055218,
    0.017957642674446106, -0.015079958364367485, 0.021359821781516075, 0.007193122990429401, 0.024788890033960342, -0.03473220765590668, -0.054553307592868805, -0.011564470827579498,
    0.015946583822369576, 0.011265717446804047, -0.00405708234757185, -0.025316521525382996, 0.014427758753299713, -0.021966710686683655, 0.02379520796239376, -0.009538857266306877,
    0.029519809409976006, -0.0020507187582552433, -0.011605847626924515, 0.05247315391898155, -0.015651816502213478, 0.00985664501786232, 0.006820192094892263, -0.02047925814986229,
    -0.0040001217275857925, -0.023839876055717468, -0.003947273828089237, 0.03287654370069504, 0.0029673385433852673, 0.004478422924876213, 0.00723186694085598, -0.025198981165885925,
    -0.011075115762650967, 0.03747433423995972, -0.013924548402428627, 0.033182546496391296, 0.0005898635718040168, -0.01843346655368805, 0.022172914817929268, 0.004476452246308327,
    0.019997669383883476, 0.006589896976947784, -0.0022913056891411543, -0.007886008359491825, 0.010076241567730904, -0.03127695992588997, -0.034555211663246155, 0.023894811049103737,
    0.007491101045161486, 0.007720048073679209, 0.026103230193257332, 0.036868203431367874, 0.020473802462220192, -0.040320996195077896, 0.004637955222278833, -0.05107065662741661,
    -0.015195135027170181, -0.021724969148635864, -0.004423128440976143, 0.0062055583111941814, -0.015766067430377007, -0.037108734250068665, -0.02409932389855385, -0.00017421875963918865,
    0.0366625040769577, -0.020361652597784996, -0.007058414630591869, -0.007036230992525816, -0.0025344043970108032, 0.0008887867443263531, 0.013717335648834705, 0.020525634288787842,
    0.008772756904363632, 0.0241638645529747, -0.00560101168230176, 0.03527555987238884, 0.026105450466275215, 0.0039022641722112894, -0.027948323637247086, 0.02382552996277809,
    0.023781830444931984, -0.01664135232567787, 0.0010949901770800352, -0.018052101135253906, 0.018993807956576347, -0.04737873002886772, 0.00881912000477314, -0.017381776124238968,
    -0.0010700502898544073, -0.006359701510518789, -0.03755838796496391, 0.0012775841169059277, -0.005751795135438442, 0.01748151145875454, 0.0004303312744013965, 0.0015246588736772537,
    0.0013053634902462363, 0.006332662422209978, 0.007246025837957859, 0.02868942730128765, 0.03453263267874718, 0.01369850430637598, 0.013712194748222828, -0.02415427938103676,
    0.0012686786940321326, -0.005483145359903574, 0.016476713120937347, 0.003873815294355154, -0.0009568839450366795, -0.00941931176930666, 0.009712794795632362, 0.053165122866630554,
    0.01210281066596508, -0.0023932040203362703, 0.001633192179724574, 0.021267900243401527, 4.75246888527181e-05, -0.009936816059052944, -0.029413623735308647, -0.02486858144402504,
    -0.025323951616883278, -0.02057051472365856, 0.018738720566034317, 0.03466622903943062, 0.0028926036320626736, -0.005208923947066069, -0.06730064749717712, 0.005609996151179075,
    -0.022737646475434303, -0.025897301733493805, 0.01178420428186655, 0.021469485014677048, -0.009467831812798977, -0.00746562983840704, 0.007905527018010616, 0.010206936858594418,
    -0.006719925440847874, 0.0031792132649570704, 0.008526426739990711, -0.014201351441442966, 0.028296081349253654, -0.019129840657114983, -0.02183854952454567, -0.013421449810266495,
    -0.001115472987294197, -0.014427730813622475, 0.007382241543382406, -0.011045732535421848, 0.006294936873018742, 0.023103885352611542, 0.04823359102010727, -0.02784622833132744,
    -0.007900819182395935, 0.006254276726394892, -0.02407345362007618, 0.01927640475332737, 0.026663808152079582, -0.02988770231604576, -0.003030929947271943, -0.007407613564282656,
    -0.014234226197004318, -0.0016993270255625248, 0.017015526071190834, 0.00895804911851883, 0.05397151783108711, 0.004730321001261473, 0.0004966032574884593, -0.06725248694419861,
    0.004716274328529835, -0.017176643013954163, 0.005373398773372173, -0.007605597376823425, 0.022988857701420784, -0.030223488807678223, -0.02989966608583927, 0.01090744324028492,
    0.010041939094662666, -0.014946965500712395, 0.029487188905477524, 0.0015630550915375352, -0.011452249251306057, 0.050946127623319626, 0.00851871632039547, -0.019662529230117798,
    0.019708266481757164, -0.019411513581871986, -0.0020622971933335066, -0.01722811721265316, 0.0073834811337292194, 0.0015808100579306483, 0.012192999012768269, -0.004684675484895706,
    -0.008947907015681267, -0.016825247555971146, -0.02311556413769722, 0.0027109996881335974, -0.0044470191933214664, -0.029787307605147362, -0.01030317135155201, 0.020085684955120087,
    -0.0001406402443535626, 6.006357216392644e-05, 0.010985073633491993, 0.004382038954645395, 0.017751002684235573, 0.027716873213648796, 0.001178267877548933, 0.01384398341178894,
    -0.0023809680715203285, -0.005085351876914501, -0.00020663517352659255, 0.003320516087114811, -0.028177505359053612, -0.008301171474158764, -0.04451544210314751, -0.010679753497242928,
    0.014036551117897034, -0.01233922690153122, 0.01777905970811844, -0.002809281460940838, 0.019700225442647934, -0.006411966867744923, -0.01849524863064289, 0.0007788932416588068,
    -0.02064155787229538, 0.03666504845023155, -0.036910682916641235, -0.002003011992201209, 0.018647821620106697, -0.009135608561336994, 0.010164054110646248, -0.0040631964802742004,
    0.004130657762289047, -0.024867156520485878, -0.000371870759408921, -0.01826694793999195, 0.008197523653507233, 0.02303430251777172, -0.0036739048082381487, 0.00842871330678463,
    -0.04177023097872734, 0.022135471925139427, -0.03407377377152443, -0.029645748436450958, 0.028502173721790314, -0.01056993193924427, -0.022308284416794777, 0.0029708731453865767,
    -0.022500324994325638, 0.015719138085842133, 0.0028920627664774656, 0.014687805436551571, 0.003368930658325553, -0.00550093362107873, -0.02406402677297592, 0.006933083292096853,
    0.03560645133256912, -0.003763099666684866, 0.004587676376104355, 0.005851306952536106, 0.03744066134095192, -0.025593165308237076, -0.005629038903862238, 0.008393660187721252,
    -0.01328346598893404, -0.005281008780002594, 0.008958880789577961, 0.04519306495785713, -0.015746479853987694, 0.021630123257637024, 0.005029480438679457, 0.03134976699948311,
    0.005598256830126047, -0.0403289794921875, -0.002119530690833926, 0.011573608964681625, 0.005417241249233484, -0.005989811848849058, -0.019067546352744102, 0.01012968085706234,
    0.01765577308833599, 0.04804018884897232, 0.011363144963979721, -0.009410722181200981, 0.027643658220767975, 0.03887869045138359, -0.023296630010008812, -0.001007543527521193,
    0.03154866769909859, -0.007263706531375647, 0.010319252498447895, 0.017576392740011215, -0.032395560294389725, 0.0036705101374536753, -0.021259501576423645, 0.02264716476202011,
    -0.03378542885184288, 0.03972207009792328, -0.016186345368623734, 0.015478265471756458, -0.03358280286192894, 0.030296355485916138, -0.018346505239605904, 0.04198920726776123,
    -0.034152280539274216, -0.00667802058160305, 0.0018614075379446149, -0.0006359100807458162, -0.0029375161975622177, -0.024922452867031097, -0.023887721821665764, -0.012792309746146202,
    0.006234799046069384, 0.0005815887125208974, -0.031438153237104416, 0.0013457678724080324, -0.0043611894361674786, 0.024687673896551132, 0.028351975604891777, -0.004430707078427076,
    -0.02959187515079975, 0.0008785098907537758, -0.026135969907045364, 0.012883505783975124, 0.01898215152323246, -0.012568310834467411, -0.004708384163677692, -0.023045465350151062,
    -0.01622459664940834, -0.016044989228248596, -0.005631820764392614, -0.016584007069468498, 0.0014135539531707764, -0.014633032493293285, -0.011530697345733643, -0.009516226127743721,
    -0.023199619725346565, -0.0020408248528838158, 0.031704410910606384, 0.02650274708867073, -0.0075127193704247475, 0.038631148636341095, -0.009595546871423721, -0.0051284669898450375,
    -0.02229158766567707, -0.027750877663493156, 0.017781967297196388, -0.021983593702316284, -0.004514847416430712, -0.011477716267108917, 0.007326075807213783, 0.0026065544225275517,
    0.04324451461434364, 0.045632947236299515, 0.012132790870964527, 0.003402130911126733, -0.03518468886613846, 0.0028459192253649235, 0.024111449718475342, 0.0031686488073319197,
    -0.0041778734885156155, -0.019169196486473083, 0.020584845915436745, 0.025778578594326973, -0.004139987751841545, -0.003635192522779107, 0.0025576672051101923, -0.03437959402799606,
    0.038090065121650696, -0.025883885100483894, 0.02437092922627926, -0.012021035887300968, 0.0035225844476372004, 0.021022645756602287, 0.0036136212293058634, 0.004018348641693592,
    0.027784304693341255, -0.002774198539555073, -0.03599761426448822, 0.009749500080943108, 0.012975474819540977, -0.006462665740400553, -0.003407530952244997, 0.001092016464099288,
    -0.01785440556704998, -0.05192309990525246, 0.019951142370700836, -0.006745804101228714, -0.0029754219576716423, -0.028994480147957802, -0.005442270543426275, 0.006072473246604204,
    1.5802446796442382e-05, 0.009602151811122894, -0.01963556744158268, -0.007775565143674612, 0.0033941122237592936, -0.026673514395952225, 0.04037844017148018, 0.015013390220701694,
    0.022270532324910164, 0.030486734583973885, 0.024070916697382927, 0.030209878459572792, -0.0011066757142543793, 0.0098110968247056, -0.008353758603334427, 0.012537877075374126,
    -0.01604377292096615, -0.004165634047240019, 0.003858911106362939, 0.026540977880358696, -0.01047270093113184, -0.02979290671646595, -0.050524670630693436, 0.03404620662331581,
    0.018556296825408936, 0.021481601521372795, -0.013065334409475327, 0.007752657867968082, -0.019152577966451645, 0.015962377190589905, 0.006216947454959154, 0.04635608568787575,
    -0.005844420753419399, -0.001471559051424265, -0.01695219986140728, 0.009428851306438446, -0.004189551342278719, 0.004441645462065935, -0.017022497951984406, -0.0007875404553487897,
    -0.027293406426906586, 0.013685381039977074, -0.0324011966586113, -0.03917575255036354, 0.002437732880935073, 0.01786126010119915, -0.02755592204630375, -0.004043031949549913,
    -0.03426939621567726, 0.012471006251871586, 0.007815715856850147, 0.02391485497355461, -0.0032278604339808226, -0.010310797020792961, -0.01591935008764267, 0.018711555749177933,
    0.04024828225374222, 0.029782788828015327, -0.03356494382023811, 0.013347313739359379, 0.02398821711540222, 0.04091411456465721, -0.01956646516919136, 0.010834435001015663,
    -0.03357808291912079, -0.00484143802896142, -0.02815345674753189, -0.0021002828143537045, -0.0022887354716658592, -0.01232105027884245, 0.005513139069080353, 0.00354800489731133,
    0.0019354879623278975, -0.015159420669078827, -0.0055956849828362465, -0.03188600763678551, 0.0025894884020090103, -0.0006890439544804394, -0.00513248797506094, -0.03839077055454254,
    0.007147618103772402, 0.04144915193319321, 0.0112684341147542, 0.03945323824882507, 0.006847755517810583, 0.025824442505836487, 0.02416815236210823, -0.017578357830643654,
    -0.05420669913291931, 0.025604188442230225, 0.015213696286082268, -0.0030053346417844296, 0.04683991149067879, -0.023155786097049713, 0.013795855455100536, 0.029420675709843636,
    0.012672298587858677, 0.021555524319410324, -0.0067182607017457485, 0.0002714246802497655, -0.029019545763731003, -0.016081109642982483, 0.025465277954936028, 0.009271920658648014,
    0.0035083128605037928, 0.0016418775776401162, 0.022876979783177376, 0.034418802708387375, 0.0021259121131151915, 0.021465308964252472, 0.015444649383425713, -0.0034064624924212694,
    0.010467723943293095, -0.01902337186038494, -0.01504161860793829, 0.022506825625896454, -0.01599727012217045, 0.04178846627473831, -0.004488624166697264, 0.010507592000067234,
    -0.013194217346608639, -0.0035125561989843845, -0.018761588260531425, -0.004894985351711512, -0.0068165031261742115, -0.009262075647711754, -0.011530832387506962, -0.02233458310365677,
    -0.002228720113635063, 0.012992698699235916, 0.008868545293807983, -0.047015231102705, -0.013945324346423149, -0.016763033345341682, -0.03099920228123665, 0.0010530949803069234,
    0.010636251419782639, -0.016635922715067863, 0.045388586819171906, -0.01092406827956438, 0.0009611905552446842, -0.01704883947968483, -0.002255448140203953, -0.01818259060382843,
    0.0021281521767377853, -0.015018309466540813, -0.005429990589618683, 0.03045627847313881, 0.029724717140197754, -0.03455561399459839, 0.007515301462262869, 0.010033167898654938,
    -0.020841160789132118, -0.023530559614300728, 0.04241858795285225, -0.001065342454239726, -0.02831498719751835, -0.0370715893805027, -0.01352972537279129, -0.050271376967430115,
    -0.03848912939429283, 0.0344771109521389, -0.01426870096474886, 0.021319812163710594, -0.013529492542147636, 0.05553867295384407, -0.011670480482280254, 0.004602027591317892,
    0.034737132489681244, -0.03687075152993202, 0.004706341773271561, 0.0333126038312912, 0.0038700562436133623, 0.01182357408106327, -0.030242448672652245, -0.02716934122145176,
    -0.0218503475189209, 0.007442974951118231, 0.027488062158226967, 0.014981038868427277, -0.0045375037007033825, -0.009792368859052658, -0.023994097486138344, 0.010960815474390984,
    -0.01857099123299122, -0.005500981584191322, -0.01794322580099106, 0.025097880512475967, 0.01254845317453146, 0.013423962518572807, 0.01929338090121746, -0.007700814865529537,
    -0.02853376232087612, 0.012180069461464882, 0.011334909126162529, -0.03387327864766121, 0.009288507513701916, 0.005482182372361422, 0.006534976419061422, -0.009953306056559086,
    0.006611982360482216, 0.017003558576107025, 0.01737981289625168, 0.016688447445631027, 0.006183283403515816, 0.007548420690000057, -0.014466258697211742, -0.002201787196099758,
    -0.014607696793973446, -0.0004167587903793901, 0.003040757728740573, 0.031504642218351364, -0.0230622086673975, 0.011148987337946892, -0.00030753485043533146, 0.012448643334209919,
    -0.0032573759090155363, 0.02475886046886444, -0.019830891862511635, 0.02468889206647873, 0.0028091396670788527, 0.004127100110054016, -0.00461024371907115, 0.018556607887148857,
    -0.005595396272838116, -0.021044034510850906, 0.017715541645884514, 0.05952777341008186, 0.02959434501826763, 0.01897001825273037, 0.00201027886942029, -0.012738009914755821,
    -0.006174302194267511, 0.014264771714806557, -0.02619764767587185, 0.01938462257385254, 0.0019461249466985464, -0.015515778213739395, 0.005341747310012579, 0.004302214831113815,
    0.005254717543721199, 0.03343019634485245, 0.0017557289684191346, 0.005715570878237486, -0.05833335593342781, 0.011881228536367416, -0.0650036409497261, -0.03442898020148277,
    -0.0044729141518473625, 0.021000681445002556, 0.006428544409573078, 0.01842137612402439, 0.038774289190769196, 0.01148243434727192, -0.02868298627436161, -0.011017736047506332,
    0.005386658012866974, 0.00020303083874750882, 0.008218980394303799, 0.00988402497023344, 0.020508907735347748, 0.03405003249645233, -0.01660156063735485, 0.012456580996513367,
    0.012566938996315002, -0.021336831152439117, -0.023773588240146637, -0.0204609502106905, -0.0041955579072237015, -0.007559923455119133, 0.021982278674840927, -0.01628919318318367,
    -0.0168765801936388, -0.0032934597693383694, -0.03599638119339943, -0.01167480181902647, 0.01245042309165001, -0.003556228242814541, 0.0013900322373956442, -0.017173664644360542,
    0.010730991140007973, -0.004692602436989546, 0.04351618513464928, -0.018179139122366905, -0.005112875252962112, -0.003413410624489188, 0.014233440160751343, 0.017099503427743912,
    0.012206900864839554, 0.014812185429036617, 0.01293779443949461, 0.011434115469455719, 0.027795538306236267, -0.014881055802106857, -0.003705320879817009, -0.03125625103712082,
    0.005983503069728613, 0.01192906592041254, 0.00603798171505332, -0.012975156307220459, 0.009517745114862919, -0.013290739618241787, 0.01394092757254839, 0.01430937834084034,
    0.011523691937327385, -0.0028623626567423344, -0.007005427964031696, 0.008521114476025105, -0.0021570995450019836, 0.010152243077754974, 0.000900780491065234, -0.0013005895307287574,
    0.020826268941164017, -0.004929739981889725, -0.03657131642103195, -0.05961640551686287, -0.039204735308885574, -0.011411651968955994, 0.01111133024096489, 0.007503483910113573,
    0.026519637554883957, -0.010687953792512417, -0.011037733405828476, 0.0376146174967289, 0.018859125673770905, -0.04432138800621033, 0.01500317919999361, 0.011872312054038048,
    -0.0059475586749613285, 0.01926710084080696, 0.026565615087747574, -0.025163041427731514, -0.027224577963352203, -0.01503195520490408, -0.01991421915590763, 0.007494540419429541,
    0.015428932383656502, -0.0025047226808965206, 0.02383742295205593, -0.020929740741848946, 0.020441556349396706, -0.018049154430627823, 0.044196609407663345, -0.011956787668168545,
    -0.002984523307532072, 0.034834787249565125, -9.297163342125714e-05, -0.011336893774569035, -0.02326836623251438, -0.0017994348891079426, -0.004623653367161751, 0.010853608138859272,
    0.02406168542802334, -0.020467357710003853, -0.02387969009578228, 0.0064755151979625225, 0.020033670589327812, -0.026530880481004715, 0.02072969451546669, -0.03556196391582489,
    -0.007100891787558794, -0.0040153139270842075, 0.014920789748430252, -0.036294229328632355, -0.002220350317656994, 0.023429779335856438, -0.0028443546034395695, -0.017727097496390343,
    -0.002356876851990819, 0.015531154349446297, 0.015976330265402794, 0.006785887759178877, 0.000105180217360612, -0.007849489338696003, 0.0021563125774264336, 0.0007930339779704809,
    0.024121742695569992, -0.03136764094233513, 0.0025700589176267385, 0.011077389121055603, 0.020200327038764954, -0.01800384372472763, -0.03918920457363129, 0.011308614164590836,
    -0.023478934541344643, 0.0018114845734089613, 0.007325988728553057, -0.050099026411771774, 0.02387993410229683, -0.01520594209432602, -0.0466923750936985, 0.0034417062997817993,
    0.036373089998960495, 0.005324787460267544, 0.026559442281723022, -0.011031483300030231, 8.875130151864141e-05, 0.01991092786192894, 0.01658322662115097, -0.0242577213793993,
    0.0201176218688488, -0.002927620429545641, 0.04305923730134964, 0.008033625781536102, 0.03400593623518944, -0.010572535917162895, -0.03138572350144386, 0.000746888283174485,
    0.01849002204835415, -0.04425682872533798, 0.005322200246155262, -0.01336946152150631, 0.018059950321912766, -0.05210341885685921, -0.006341482978314161, -0.025570208206772804,
    -0.03314640372991562, -0.009477044455707073, -0.006954807322472334, -0.0003484897024463862, -0.013161413371562958, -0.00933844968676567, 0.0062615228816866875, -0.03438737615942955,
    -5.1161801820853725e-05, 0.005019057542085648, -0.009163249284029007, 0.023654676973819733, -0.012780574150383472, -0.005138109903782606, -0.015466639772057533, 0.03751532733440399,
    -0.011193905957043171, -0.031553179025650024, -0.037292905151844025, 0.014216664247214794, -0.0023245662450790405, -0.01904412917792797, -0.00560339167714119, 0.03987911716103554,
    0.023922143504023552, 0.024637527763843536, -0.028078800067305565, 0.031194236129522324, -0.0028229926247149706, -0.024644246324896812, 0.0328359454870224, -0.016269052401185036,
    -0.017048360779881477, 0.029509801417589188, 0.009637241251766682, -0.030246010050177574, 0.0014250192325562239, 0.04369702562689781, -0.00034544902155175805, 0.020225374028086662,
    -0.0021667114924639463, -0.010878341272473335, -0.002131611341610551, -0.0027708769775927067, -0.006637397222220898, -3.945431672036648e-05, 0.014864645898342133, 0.01223021000623703,
    -0.02228832058608532, 0.012994752265512943, 0.02959091030061245, 0.004297041799873114, 0.006490690633654594, 0.005342700518667698, -0.008096075616776943, 0.01933213882148266,
    0.022490156814455986, -0.027378998696804047, 0.03603268414735794, 0.005140603054314852, -0.0019472114508971572, -0.020933357998728752, 0.014205696992576122, 0.004330658353865147,
    0.009169741533696651, 0.011728441342711449, 0.054010070860385895, 0.02040010504424572, -0.0073663885705173016, -0.006648023147135973, 0.01824445277452469, -0.0005162219749763608,
    0.024262333288788795, 0.008450336754322052, 0.020515451207756996, 0.01463194377720356, 0.055684592574834824, -0.003650595434010029, -0.0076985107734799385, 0.07217331975698471,
    0.008046767674386501, -0.015575319528579712, 0.013045769184827805, 0.0012493474641814828, 0.04129611700773239, 0.02979101799428463, -0.012855748645961285, 0.01830929145216942,
    -0.027283350005745888, -0.017414959147572517, -0.04936503991484642, -0.03388421982526779, 0.0007699327543377876, -0.020655140280723572, 0.02024202048778534, -0.003455987200140953,
    0.029268277809023857, 0.027828514575958252, -0.008879107423126698, 0.030600035563111305, -0.005397093947976828, -0.03832283243536949, 0.020932326093316078, 0.009835517965257168,
    0.009073245339095592, 0.015981944277882576, -0.005524093750864267, -0.04494836926460266, 0.015492727980017662, 0.03191978111863136, 0.027182038873434067, 0.01861361600458622,
    -0.01116193924099207, -0.0007206134614534676, -0.016283979639410973, -0.004308696836233139, 0.05690500885248184, 0.03238852322101593, 0.008763562887907028, 0.016089843586087227,
    -0.0035645351745188236, 0.024895189329981804, 0.005182129796594381, 0.011041753925383091, 0.02326788939535618, 0.010376015678048134, -0.004529239144176245, -0.0035713938996195793,
    0.019157227128744125, -0.01796971820294857, -0.003050944535061717, 0.013472984544932842, 0.004450306762009859, -0.003127926727756858, 0.0324309766292572, 0.00898850616067648,
    -0.0013895874144509435, -0.003900062059983611, -0.0058580623008310795, -0.015089200809597969, -0.014364848844707012, 0.022167574614286423, -0.017636524513363838, -0.033472783863544464,
    -0.004417718388140202, 0.04372566193342209, 0.02680768258869648, -0.016920380294322968, -0.0010956937912851572, -0.004920612089335918, 0.04751838371157646, 0.00909874401986599,
    -0.02826215699315071, 0.002197485649958253, -0.01989569514989853, -0.030441908165812492, 0.03199931979179382, 0.018011733889579773, 0.018176129087805748, 0.020485110580921173,
    0.02420944720506668, 0.0007971734739840031, -0.016987718641757965, 0.0021503421012312174, -8.091232302831486e-06, 0.05949205905199051, 0.018089838325977325, -0.03967401012778282,
    0.0059600574895739555, 0.0039765196852386, 0.0016429137904196978, 0.022577716037631035, 0.029880544170737267, 0.025494828820228577, 0.004167990759015083, 0.009992511011660099,
    0.006292376667261124, -0.03880518674850464, -0.01038437895476818, -0.017726294696331024, -0.0034325572196394205, 0.0032381212804466486, 0.018606049939990044, -0.010341399349272251,
    -0.019439762458205223, 0.0015266148839145899, -0.01842786930501461, -0.014832386747002602, -0.017498264089226723, -0.014910328201949596, -0.009573061019182205, -0.012586613185703754,
    -0.011796856299042702, -0.012126032263040543, 0.005521575454622507, 0.03134002909064293, 0.008892560377717018, -0.005898337811231613, -0.012688351795077324, -0.022950883954763412,
    -0.013203809969127178, -0.02287336252629757, -0.01111090462654829, -0.017938990145921707, 0.013875306583940983, -0.03806523606181145, 0.018776847049593925, 0.01370721310377121,
    -0.004739623982459307, 0.00046421607839874923, 0.017098570242524147, 0.019125809893012047, 0.01692635752260685, 0.030288077890872955, -0.0203146580606699, 0.006619463674724102,
    -0.014781888574361801, 0.008151334710419178, -0.034452758729457855, -0.018808681517839432, 0.04547201842069626, 0.011933969333767891, -0.018456675112247467, 0.02368256263434887,
    -0.014974221587181091, 0.008456842973828316, 0.003293429734185338, 0.009650913067162037, -0.037058282643556595, -0.01122237928211689, 0.026663295924663544, 0.022234050557017326,
    -0.01792026124894619, -0.023486174643039703, -0.03193194046616554, -0.0037499128375202417, -0.0019227189477533102, 0.007799106650054455, 0.014628171920776367, 0.008038556203246117,
    -0.001859958516433835, 0.022418513894081116, -0.018653670325875282, -0.006315384991466999, 0.0243702195584774, -0.012113874778151512, 0.0027205226942896843, 0.010804751887917519,
    0.021835245192050934, -0.05188101902604103, 0.013795594684779644, 0.03728299215435982, 0.020158130675554276, -0.05456685274839401, 0.015176263637840748, 0.02154618687927723,
    -0.02126922458410263, -0.004621485248208046, 0.030070161446928978, -0.01567598059773445, -0.007108701858669519, 0.019784031435847282, -0.03011644072830677, -0.010965900495648384,
    0.016635678708553314, -0.011616728268563747, 0.004353993106633425, -0.009067419916391373, -0.019893977791070938, 0.004118665121495724, -0.006225252989679575, -0.044267185032367706,
    -0.015158085152506828, -0.01940680295228958, -0.013607115484774113, 0.025765344500541687, -0.020434390753507614, 0.06206199899315834, -0.042589861899614334, 0.0024644997902214527,
    -0.026705117896199226, 0.00844049733132124, -0.008437404409050941, -0.02058713324368, 0.010052447207272053, 0.024373013526201248, -0.014036078006029129, -0.0052425917237997055,
    -0.0279241893440485, -0.01533292606472969, 0.013143288902938366, 0.026074973866343498, -0.02045595645904541, 0.005585028324276209, -0.029721947386860847, -0.010964388959109783,
    -0.01924802176654339, 0.0179124865680933, 0.018560418859124184, 0.017663387581706047, -0.016056247055530548, -0.023476658388972282, 0.00980883277952671, -0.023109829053282738,
    0.016233986243605614, 0.0008370567229576409, -0.02148861065506935, 0.008523459546267986, 0.012126369401812553, -0.006994228810071945, 0.015160312876105309, 0.010166831314563751,
    0.008808433078229427, 0.04429255425930023, -0.025769710540771484, -0.025369005277752876, -0.050200436264276505, -0.00314223556779325, 0.00601663114503026, -0.004443471785634756,
    -0.012144295498728752, 0.010654430836439133, 0.010574505664408207, 0.016432054340839386, -0.014036504551768303, -0.021225139498710632, 0.009260975755751133, 0.01786213554441929,
    -0.009036521427333355, 0.028915105387568474, -0.008794121444225311, -0.052126459777355194, -0.05887901782989502, -0.010544533841311932, -0.035421594977378845, 0.04333505034446716,
    0.02428806573152542, -0.03283559903502464, -0.0227445587515831, 0.0072438097558915615, 0.029101621359586716, -0.03835856914520264, -0.011760002002120018, -0.000160333322128281,
    -0.04334153234958649, 0.007822519168257713, 0.019008569419384003, -0.00403160136193037, -0.03931476175785065, 0.002523483708500862, 0.0181150883436203, -0.01717015542089939,
    -0.013947121798992157, -0.022890999913215637, 0.004915278870612383, 0.041152242571115494, -0.001209972775541246, -0.025701332837343216, -0.0317043699324131, 0.023712391033768654,
    0.009999297559261322, -0.005164336878806353, -0.0008500474505126476, 0.013434766791760921, -0.005874271038919687, 0.010058590210974216, -0.015236648730933666, -0.01962132565677166,
    0.011397399939596653, -0.034153249114751816, 0.08078008145093918, 0.04581127688288689, -0.007739004213362932, 0.021017706021666527, -0.01674823649227619, -0.021068355068564415,
    -0.027651837095618248, 0.02837834507226944, 0.008878840133547783, 0.01770114339888096, 0.004395454656332731, -0.021590054035186768, -0.03128881752490997, 0.0027160756289958954,
    -0.0035656148102134466, -0.003793562762439251, 0.01577288843691349, 0.02414078079164028, -0.023840101435780525, -0.019086502492427826, -0.005989248864352703, -0.0006225339602679014,
    -0.0226537324488163, 0.004755668807774782, 0.006748999934643507, 0.04007861763238907, 0.02303478680551052, -0.0070530325174331665, 0.01472589373588562, 0.018708959221839905,
    -0.008108820766210556, -0.01613801158964634, 0.007839715108275414, -0.026976820081472397, 0.01205530110746622, -0.010766327381134033, 0.04127373546361923, 0.013753050938248634,
    0.006135365925729275, -0.02642599307000637, 0.015310599468648434, 0.011968704871833324, -0.0016753484960645437, 0.004360671620815992, -0.00810767151415348, -0.005586492363363504,
    -0.019673485308885574, 0.015017473138868809, -0.008888667449355125, -0.024705668911337852, -0.01395073626190424, 0.009108191356062889, 0.01113148219883442, -0.001121295033954084,
    0.004119700286537409, 0.0060897585935890675, 0.01630920171737671, -0.012387030757963657, -0.006326005328446627, 0.020721038803458214, 0.052769143134355545, -0.0003299711097497493,
    0.014377879910171032, -0.025194916874170303, 0.04665294662117958, -0.004854579456150532, -0.027562612667679787, -0.01312296837568283, -0.0062264022417366505, -0.00835386198014021,
    0.005158665589988232, 0.0031736386008560658, -0.007379511371254921, -0.0006371447234414518, 0.020363448187708855, -0.004231288563460112, -0.011210327968001366, -0.04318824037909508,
    -0.015305643901228905, 0.0038551578763872385, 0.004521703347563744, 0.04640393331646919, 0.011405074037611485, -0.026619959622621536, 0.02435063011944294, -0.017876196652650833,
    0.02640581503510475, -0.024723947048187256, 0.030122004449367523, -0.021378055214881897, 0.013997816480696201, 0.0014613489620387554, 0.016266310587525368, 0.0019343021558597684,
    0.009908098727464676, -0.020768558606505394, -0.016726044937968254, 0.010595274157822132, 0.02899833954870701, -0.03319673612713814, -0.0312725268304348, -0.05313682183623314,
    -0.004682841710746288, -0.017195619642734528, -0.00425821915268898, -0.020879225805401802, 0.03071674145758152, 0.01567249745130539, 0.005719261709600687, -0.018203018233180046,
    -0.008353175595402718, 0.02273247204720974, 0.01844717375934124, -0.003508857451379299, -8.110314229270443e-05, 0.04008770361542702, -0.048287633806467056, -0.001649568323045969,
    -0.008243108168244362, 0.0016722057480365038, -0.004523094743490219, 0.053788430988788605, 0.005242766812443733, 0.001558954012580216, -0.019452229142189026, -0.04150233045220375,
    -0.01027275063097477, 0.01179567538201809, -0.023805830627679825, 0.016797062009572983, 0.07538013160228729, -0.022009016945958138, -0.035554006695747375, 0.03441132977604866,
    -0.03149481117725372, 0.008133938536047935, -0.03102315589785576, 0.0007558700744993985, -0.028239848092198372, -0.015022335574030876, 0.02937229722738266, -0.023599619045853615,
    -0.023795971646904945, 0.026387808844447136, -0.01966872625052929, 0.007122310344129801, -0.026627283543348312, 0.039018239825963974, -0.02342495508491993, -0.0186284389346838,
    0.029986510053277016, 0.00012814778892789036, -0.003289176383987069, -0.005702866706997156, 0.0025201463140547276, -0.03025909699499607, -0.05707006901502609, 0.006151173263788223,
    0.02489255741238594, -0.01623455248773098, 0.022928304970264435, -0.008050360716879368, -0.022681334987282753, 0.020817231386899948, 0.008495934307575226, 0.025606399402022362,
    -0.013086976483464241, 0.0013556618941947818, -0.018580839037895203, 0.034224893897771835, 0.006900401785969734, 0.000314730335958302, 0.020289599895477295, 0.02619604580104351,
    -0.00929109938442707, 0.009074466302990913, -0.0038075780030339956, 0.01241599302738905, -0.028810258954763412, 0.017778031527996063, -0.0022676235530525446, 0.05447205901145935,
    -0.007947472855448723, -0.01226555835455656, 0.01272646989673376, 0.03849893808364868, -0.03336620330810547, -0.01914984919130802, -0.020390283316373825, -0.02230977639555931,
    -0.014537465758621693, 0.0450698584318161, -0.0001009433253784664, 0.0421292670071125, 0.028125688433647156, 0.014503310434520245, -0.04392443597316742, -0.009823364205658436,
    0.04571369290351868, 0.05096288397908211, 0.009194587357342243, 0.0038885604590177536, 0.018671900033950806, 0.0044608935713768005, -0.005570851732045412, 0.047787707298994064,
    0.03700103238224983, -0.017856787890195847, 0.006655743345618248, 0.04555274173617363, -0.001777816447429359, -0.013440935872495174, 0.0011296361917629838, 0.04321791231632233,
    0.0028954017907381058, -0.005965124815702438, -0.038103215396404266, -0.011994735337793827, 0.004735992290079594, -0.002891997341066599, -0.0041798874735832214, 0.006119434721767902,
    0.014552030712366104, -0.01288614422082901, -0.022978486493229866, 0.013601532205939293, 0.009121938608586788, -0.0018197557656094432, 0.017225679010152817, -0.027964875102043152,
    -0.01881217397749424, 0.018491454422473907, -0.008542846888303757, -0.013217674568295479, -0.020884539932012558, 0.02214667946100235, -0.056034449487924576, -0.015824126079678535,
    0.02591230906546116, -0.02739345282316208, -0.01366137620061636, 0.05389918386936188, -0.025537429377436638, -0.018637383356690407, 0.03568768873810768, -0.005738391075283289,
    0.0038979756645858288, -0.0009628177504055202, 0.0294344499707222, -0.03406058996915817, 0.0021987094078212976, -0.01761399768292904, -0.0048538134433329105, 0.018748247995972633,
    -0.007589093409478664, 0.009385468438267708, 0.014426850713789463, -0.03059290535748005, 0.005338066723197699, 0.008691617287695408, 0.007033170200884342, 0.006375896744430065,
    0.03706573694944382, -0.005636942572891712, 0.025334250181913376, 0.004524875432252884, 0.0076394337229430676, -0.011671552434563637, -0.01729710027575493, 0.021418562158942223,
    0.017992546781897545, -0.028519099578261375, 0.004002426750957966, 0.001712621538899839, 0.0305301696062088, -0.017752444371581078, -0.0030613471753895283, 0.004686535336077213,
    0.029276816174387932, 0.003870885819196701, 0.006600824184715748, -0.013905112631618977, -0.010218590497970581, 0.020321063697338104, 0.02716461382806301, -0.01401083916425705,
    -0.008301683701574802, 0.01575782336294651, 0.01392312627285719, 0.05331486463546753, -0.02231367863714695, 0.02736528404057026, -0.025300098583102226, -0.010933197103440762,
    0.032625023275613785, 0.029049664735794067, 0.022689586505293846, -0.041589438915252686, 0.027698714286088943, -0.021815482527017593, 0.004215131979435682, 0.012067812494933605,
    0.017414212226867676, -0.011496040970087051, 0.01909021846950054, -4.32196247857064e-06, 0.003695661900565028, 0.003273552283644676, 0.016288122162222862, -0.06073882430791855,
    0.013630243949592113, 0.0002568054187577218, 0.017829744145274162, 0.018205435946583748, -0.011518485844135284, 0.020216234028339386, -0.004413825459778309, 0.012662334367632866,
    -0.007114331237971783, -0.02206936478614807, -0.007175743114203215, -0.017959322780370712, 0.025920774787664413, 0.02709371969103813, 0.00040818704292178154, -0.0007186775910668075,
    0.04357478767633438, 0.030875541269779205, 0.01337018795311451, -0.02597784250974655, -0.02026381902396679, -0.005839408840984106, 0.0060868714936077595, -0.010428001172840595,
    -0.016734257340431213, 0.010530500672757626, -0.000153758330270648, 0.034350428730249405, -0.021424170583486557, 0.032151367515325546, 0.009200399741530418, -0.01997016929090023,
    -0.012205803766846657, 0.01834205351769924, 0.003851126879453659, 0.005929949227720499, -0.007116072811186314, 0.0467337965965271, -0.0008843907853588462, 0.012073277495801449,
    0.002774183638393879, -0.03154808655381203, -0.022643063217401505, -0.012503942474722862, 0.013047635555267334, 0.015567035414278507, 0.012091035023331642, -0.01775052398443222,
    -0.06344133615493774, 0.019133059307932854, -0.008513578213751316, -0.02797504886984825, -0.044829461723566055, 0.00741225341334939, 0.00030037626856938004, 0.0006296018837019801,
    -0.0036814622581005096, 0.0353243313729763, 0.026670970022678375, 0.0026838381309062243, 0.014441156759858131, 0.05711052194237709, -0.02156258001923561, 0.044326700270175934,
    0.014503080397844315, 0.024810777977108955, 0.017262788489460945, -0.03321121633052826, -0.035361651331186295, 0.04059136286377907, 0.0029006500262767076, 0.00209174957126379,
    -0.026694679632782936, -0.013246338814496994, -0.04041757807135582, 0.005564911291003227, 0.036571577191352844, 0.014787743799388409, -0.023348962888121605, -0.029990850016474724,
    0.015191466547548771, -0.040977414697408676, 0.0022900255862623453, 0.000272726989351213, 0.024529511108994484, -0.015730423852801323, 0.010720469988882542, 0.004908091854304075,
    -0.014841653406620026, 0.0026936030481010675, -0.03566325828433037, 0.011466498486697674, -0.03648597002029419, 0.028821274638175964, 0.008400820195674896, 0.0029461306985467672,
    0.02513173222541809, -0.002095374744385481, -0.016678975895047188, -0.033563967794179916, -0.0012891299556940794, -0.033482905477285385, -0.00769532797858119, 0.014776750467717648,
    -0.008550018072128296, -0.014714817516505718, 0.009065164253115654, -0.04545488953590393, -0.02569453790783882, 0.005202322266995907, 0.004685761407017708, 0.05433289334177971,
    -0.027355512604117393, 0.0052969008684158325, -0.0056284526363015175, 0.012111532501876354, 0.006677216850221157, 0.002490472747012973, 0.02034221962094307, 0.00550851970911026,
    -0.012552532367408276, -0.00045532776857726276, -0.006665516644716263, -0.0025194366462528706, 0.028126301243901253, 0.03189714252948761, 0.0245584137737751, 0.009226399473845959,
    0.0020942427217960358, -0.029986336827278137, -0.009376944974064827, 0.019518088549375534, 0.003965251613408327, -0.0017616568366065621, -0.003753221593797207, -0.008367115631699562,
    -0.024233000352978706, -0.016545351594686508, 0.009910108521580696, -0.016348015516996384, -0.007779809180647135, -0.015448366291821003, -0.006329597905278206, -0.005542670842260122,
    0.05023645609617233, 0.04363076016306877, -0.0034667158033698797, -0.011935535818338394, -0.02455066330730915, -0.00350105669349432, 0.023335885256528854, -0.025872305035591125,
    0.019444508478045464, -0.008051090873777866, 0.023112650960683823, 0.019404765218496323, -0.013390898704528809, -0.0011803394882008433, -0.006511455401778221, -0.023481279611587524,
    0.008695483207702637, -0.015135925263166428, 0.0296896044164896, 0.026439638808369637, -0.003337122732773423, 0.002233309904113412, 0.0013331352965906262, 0.028463466092944145,
    0.03806959092617035, -0.01549810916185379, -0.05570105463266373, -0.01599331572651863, 0.017975429072976112, -0.0400906577706337, -0.014832214452326298, -0.012364670634269714,
    -0.04461526870727539, -0.0019629495218396187, 0.028002487495541573, -0.008778175339102745, -0.023423729464411736, 0.0019630687311291695, 0.028275175020098686, -0.015036292374134064,
    -0.018397917971014977, -0.00013204861897975206, 0.014836856164038181, 0.05038441717624664, -0.017297398298978806, 0.017264174297451973, -0.00032590972841717303, 0.006904357112944126,
    0.015952976420521736, -0.022144030779600143, -0.019687606021761894, 0.044860124588012695, 0.037883080542087555, 0.004579067695885897, -0.014224817045032978, -0.011144229210913181,
    0.021674245595932007, -0.04639381542801857, -0.014903017319738865, -0.008258293382823467, -0.006946335081011057, -0.020125465467572212, -0.023031190037727356, 0.015929365530610085,
    0.00032501117675565183, -0.007796938996762037, -0.0027416879311203957, -0.006414739415049553, -0.005931186489760876, -0.02484423667192459, 0.009988832287490368, 0.02458856999874115,
    0.010034932754933834, -0.023190848529338837, 0.016065802425146103, 0.001202641287818551, 0.025878939777612686, -0.018901903182268143, -0.03598375618457794, 0.01938648335635662,
    0.023719092831015587, -0.027022967115044594, -0.02888326160609722, 0.01332393754273653, 0.02684926427900791, -0.010716121643781662, -0.0006682698731310666, -0.003350883489474654,
    -0.005255378317087889, 0.025327840819954872, 0.022104378789663315, 0.0002373050374444574, 0.02029072493314743, 0.02308598905801773, 0.00303262984380126, -0.025318514555692673,
    0.01366167701780796, -0.0071860430762171745, -0.029497426003217697, -0.026446819305419922, -0.0001567782019264996, -0.032055459916591644, -0.03409232199192047, 0.03704628720879555,
    -0.0010360737796872854, 0.01246450375765562, 0.003951021935790777, -0.017070287838578224, -0.0552409365773201, 0.008219943381845951, 0.04896603897213936, 0.017499713227152824,
    -0.010534537024796009, 0.02349964715540409, 0.007525915279984474, -0.008925370872020721, -0.01884719915688038, -0.027796298265457153, -0.004042213317006826, 0.0008579246932640672,
    0.0015361002879217267, -0.0037959564942866564, 0.002864510752260685, -0.03234142065048218, 0.004523122683167458, -0.02472071349620819, 0.003121020970866084, -0.008762841112911701,
    0.0683743804693222, 0.008963288739323616, -0.025141414254903793, -0.014586091972887516, -0.016397597268223763, -0.00675596809014678, 0.022358784452080727, -0.002776769921183586,
    -0.014391087926924229, 0.014300608076155186, 0.026679862290620804, 0.03582524508237839, 0.020742880180478096, -0.0004777604772243649, -0.021702025085687637, -0.01668640971183777,
    -0.03264118731021881, 0.012253881432116032, -0.024072827771306038, 0.03314804658293724, -0.02849133312702179, 0.015532944351434708, 0.050622615963220596, 0.024914981797337532,
    -0.014269202947616577, 0.002131439046934247, 0.028013084083795547, 0.04558984935283661, 0.006012281868606806, 0.002385229803621769, 0.0009863576851785183, 0.01597660593688488,
    0.008906451985239983, -0.005294308997690678, 0.017775719985365868, -0.0066671534441411495, -0.04759979248046875, -0.03322193771600723, 0.009856410324573517, 0.026847705245018005,
    -0.000654039264190942, -0.008184902369976044, 0.017249679192900658, -0.014597260393202305, 0.024073636159300804, -0.025890495628118515, -0.02151879109442234, -0.004230172839015722,
    -0.008566209115087986, -0.015552941709756851, 0.010882166214287281, 0.03749481216073036, -0.02801630273461342, -0.0047060586512088776, -0.012593617662787437, -0.020202333107590675,
    -0.024146566167473793, 0.0055228970013558865, 0.007414379622787237, -0.005400063935667276, 0.02805056795477867, 0.008472131565213203, -0.005967424716800451, -0.0025026132352650166,
    0.005186775233596563, 0.005023628007620573, 0.017824839800596237, -0.005703332368284464, 0.03143028914928436, 0.048796068876981735, -0.012351702898740768, -0.02896197885274887,
    -0.01032550074160099, -0.009755145758390427, -0.0007152781472541392, -0.015916984528303146, -0.012360023334622383, -0.009028654545545578, -0.00968426838517189, -0.02543933317065239,
    0.01712026074528694, 0.028095049783587456, 0.015564884059131145, -0.00600734306499362, -0.012727852910757065, 0.015820130705833435, -0.00947854109108448, 0.02089366875588894,
    -0.01961367204785347, -0.024645764380693436, 0.03357458487153053, -0.013684434816241264, -0.013121632859110832, 0.02035355567932129, 0.007872529327869415, 0.0287493709474802,
    -0.03052065148949623, -0.03463573008775711, -0.03835929557681084, 0.011849508620798588, 0.008537297137081623, 0.01651531271636486, -0.01803095079958439, -0.008488813415169716,
    0.033850669860839844, -0.014406489208340645, 0.00037073605926707387, -0.001433217665180564, -0.014521228149533272, 0.017353171482682228, 0.0039584641344845295, 0.008653681725263596,
    -0.009364596568048, -0.011944742873311043, 0.0036962307058274746, 0.007005950435996056, -0.017180517315864563, -0.012591891922056675, 0.03595539927482605, -0.019815189763903618,
    0.02499529719352722, 0.02387557551264763, 0.01297488808631897, 0.02456146478652954, -0.007157095242291689, -0.019147228449583054, 0.025130771100521088, -0.023378439247608185,
    0.0016267008613795042, -0.015552874654531479, 0.011811819858849049, 0.03530555218458176, -0.010467011481523514, -0.0067262970842421055, -0.015562099404633045, 0.011547759175300598,
    0.016519533470273018, 0.02497285231947899, 0.011374483816325665, -0.05293012037873268, 0.034065380692481995, 0.06974763423204422, 0.038831669837236404, 0.0318087600171566,
    0.0031004894990473986, 0.005480473395437002, 0.0017429228173568845, -0.025101181119680405, -0.01321775745600462, -0.022270765155553818, 0.001598130096681416, 0.03191538527607918,
    -0.0010863508796319366, -0.021399209275841713, -1.3164103620511014e-06, 0.0017701198812574148, -0.03266548737883568, -0.022282226011157036, -0.006258194800466299, 0.02080482244491577,
    -0.05729607865214348, 0.009735559113323689, 0.029451187700033188, -0.0009115846478380263, 0.06319420784711838, -0.011013425886631012, 0.024976767599582672, 0.031902775168418884,
    0.012878247536718845, 0.01273359451442957, 0.029917122796177864, -0.04096171259880066, 0.0018383878050372005, 0.0191635899245739, -3.4732143831206486e-05, -0.014856460504233837,
    -0.032246336340904236, -0.006992893293499947, -0.04555521905422211, -0.012658912688493729, 0.016056880354881287, 0.008165215142071247, 0.04156595468521118, 0.01655346341431141,
    0.0055384086444973946, 0.008505727164447308, -0.030302394181489944, -0.06504590064287186, 0.0134016377851367, -0.006512099876999855, -0.029563436284661293, -0.03531704843044281,
    0.008225583471357822, 0.005941327195614576, 0.005936599802225828, 0.014426019974052906, -0.06658890098333359, -0.00766434520483017, 0.029557952657341957, 0.001252607791684568,
    0.019121078774333, 0.002792241284623742, -0.01732993870973587, -0.008206192404031754, -0.0031763555016368628, -0.019201090559363365, 0.022251393646001816, -0.0072978101670742035,
    0.0190911665558815, 0.00319296820089221, -0.015006446279585361, -0.005723526235669851, 0.0286219734698534, -0.011167180724442005, -0.02358764037489891, -0.001022846787236631,
    -0.009435629472136497, -0.011450378224253654, 0.0694563016295433, 0.007873354479670525, -0.0039498331025242805, -0.012449147179722786, -0.03349081054329872, 0.02103389985859394,
    0.017018701881170273, 0.05401066690683365, -0.025724003091454506, -0.020704595372080803, 0.017155127599835396, -0.003485089400783181, 0.0008164372411556542, -0.005671173799782991,
    0.0067794970236718655, -0.0205879844725132, -0.009029488079249859, 0.021087152883410454, 0.026187609881162643, -0.02383955754339695, 0.004712583031505346, -0.013182314112782478,
    -0.004879353102296591, 0.0062703019939363, 0.012630518525838852, -0.007624428253620863, -0.00036583852488547564, -0.020663831382989883, -0.02772282250225544, -0.01320147980004549,
    -0.034258775413036346, -0.008322537876665592, 0.06382971256971359, -0.03106728382408619, -0.017483094707131386, 0.0064337593503296375, -0.0009924615733325481, 0.0010518879862502217,
    0.002949291607365012, -0.0030900435522198677, -0.02932891808450222, -0.0011833905009552836, -0.006080894730985165, -0.005610170774161816, -0.03926371783018112, -0.004567345604300499,
    0.0005671696271747351, -0.008969107642769814, 0.019919583573937416, -0.010602209717035294, 0.009944782592356205, -0.010799771174788475, -0.003062688745558262, 0.027418017387390137,
    0.003481269348412752, -0.030490610748529434, 0.0182143896818161, -0.006343234330415726, -0.0006811034982092679, 0.03793787211179733, 0.012125973589718342, -0.02942671813070774,
    0.0210674200206995, 0.007925856858491898, -0.009142187424004078, -0.003698907792568207, -0.009352380409836769, -0.003142394358292222, 0.022167691960930824, 0.01748555898666382,
    -0.0024723950773477554, 0.011489104479551315, -0.010682961903512478, 0.005563465878367424, -0.0028904718346893787, -0.003049589926376939, -0.012666118331253529, 0.01880474016070366,
    -0.03766739368438721, 0.021018335595726967, -0.003999519627541304, 0.021038349717855453, 0.027405772358179092, 0.017054235562682152, -0.0023716555442661047, 0.014326062053442001,
    0.0038051747251302004, -0.010128606110811234, 0.025222022086381912, -0.026345474645495415, -0.01092430017888546, -0.020045127719640732, -0.03773349151015282, 0.0006589483236894011,
    0.002244699513539672, -0.024285946041345596, 0.012619414366781712, -0.016221908852458, 0.011152385734021664, 0.044381216168403625, -0.03645927086472511, 0.012089816853404045,
    -0.005755562800914049, -0.023776333779096603, -0.01886426843702793, -0.015286027453839779, -0.00879341084510088, -0.01140565238893032, 0.023848650977015495, -0.0022023951169103384,
    -0.03172070160508156, -0.01272277720272541, -0.030616672709584236, 0.013532239012420177, -0.00914357602596283, -0.018178356811404228, 0.0027431414928287268, 0.038448136299848557,
    0.006117035169154406, -0.024937259033322334, -0.007405474316328764, 0.0388898104429245, 0.0029874409083276987, 0.010716676712036133, 0.00797873642295599, -0.018481818959116936,
    0.004126681014895439, 0.018130585551261902, 0.02060343511402607, 0.004961722530424595, -0.014695410616695881, 0.01030980609357357, -0.02175978757441044, -0.02093181200325489,
    0.03521798923611641, -0.04582520201802254, -0.009274041280150414, -0.02275034971535206, -0.019693370908498764, 0.025814784690737724, 0.006029999814927578, 0.01626763865351677,
    -0.01654057949781418, 0.01517398376017809, -0.018459530547261238, -0.051938243210315704, -0.02821660228073597, -0.0020544661674648523, 0.013800391927361488, 0.0007513148593716323,
    0.019650351256132126, 0.008736013434827328, 0.02709684520959854, -0.016940133646130562, -0.018982671201229095, 0.01183901447802782, 0.038413211703300476, -0.0014796055620536208,
    0.027808599174022675, -0.020221177488565445, 0.029435930773615837, -0.0019886400550603867, 0.0050592790357768536, 0.012101068161427975, -0.02482910454273224, -0.0054361335933208466,
    -0.02519909292459488, 0.02739153988659382, -0.01801859401166439, -0.015741899609565735, 0.011356410570442677, 0.004340497776865959, -0.01365683414041996, -0.0042581153102219105,
    -0.006085746455937624, 0.015527582727372646, -0.0006336670485325158, 0.029338929802179337, -0.03536906838417053, 0.021046096459031105, 0.014213266782462597, -0.004180032294243574,
    0.014956987462937832, 0.03165043890476227, -0.002535816514864564, 0.009318104945123196, -0.016864214092493057, 0.008504808880388737, 0.014610908925533295, -0.0292256698012352,
    -0.052084602415561676, 0.0014765631640329957, -0.03532829508185387, 0.026208003982901573, 0.026645870879292488, 0.016710665076971054, 0.004631452728062868, -0.036836881190538406,
    0.006749331019818783, -0.009829695336520672, 0.035950660705566406, -0.01404188945889473, 0.030920471996068954, 0.0027944673784077168, 0.010906802490353584, -0.017790278419852257,
    0.021644078195095062, -0.007356391288340092, -0.004943578504025936, 0.025526156648993492, 0.02198883518576622, -0.0042763808742165565, -0.03095911629498005, 0.010032117366790771,
    -0.0195798147469759, 0.00494342902675271, -0.05075083300471306, 0.03555963560938835, -0.012050151824951172, -0.0056416247971355915, -0.029140179976820946, -0.005148970056325197,
    -0.01786406897008419, 0.005519813392311335, 0.0011668562656268477, -0.0202538650482893, 0.0020800239872187376, -0.04004310816526413, -0.0170602984726429, 0.002476068679243326,
    0.03323084115982056, 0.012907641008496284, 0.010599524714052677, 0.030174268409609795, 0.001957218162715435, 0.005427263211458921, -0.0011605806648731232, -0.011505530215799809,
    0.013581917621195316, -0.03097160905599594, 0.0068573784083127975, -0.019450651481747627, -0.005695939529687166, -0.006669820286333561, -0.018539339303970337, 0.023551788181066513,
    -0.0002522116992622614, 0.0023863515816628933, -0.010625822469592094, 0.019988084211945534, -0.001922858995385468, -0.0361173190176487, -0.04625939950346947, 0.0651688426733017,
    -0.06133735179901123, 0.03792118653655052, -0.0015979761956259608, 0.04290233179926872, 0.03516453504562378, -0.03098587691783905, 0.0223800390958786, -0.006398769561201334,
    -0.017314262688159943, 0.016871249303221703, -0.011809872463345528, -0.0027788698207587004, -0.006551800761371851, -0.003062646836042404, 0.031505830585956573, 0.03538522124290466,
    0.054328661412000656, -0.043098412454128265, -0.0012986864894628525, -0.01301562786102295, -0.006161161698400974, -0.01434091292321682, 0.0042947037145495415, 0.03637627139687538,
    0.0019316942198202014, 0.012773673050105572, -0.003737113205716014, 0.009682903997600079, -0.01995592750608921, -0.011584657244384289, -0.006703061517328024, -0.01759650930762291,
    0.010576088912785053, 0.02024228498339653, -0.0167886633425951, -0.029633795842528343, -0.010450201109051704, -0.05460403859615326, 0.04067743197083473, 0.006699634250253439,
    0.014054553583264351, -0.011051771230995655, -0.006610859651118517, 0.005996964406222105, -0.02021835558116436, -0.018311724066734314, 0.0041904449462890625, -0.017182650044560432,
    -0.03159654513001442, -0.02049250528216362, 0.006742709316313267, -0.010955359786748886, 0.01837400533258915, -0.028011126443743706, 0.00931693334132433, -0.022265708073973656,
    -0.019799571484327316, -0.021950023248791695, 0.0018802785780280828, -0.0015780131798237562, 0.039161622524261475, 0.005290582310408354, 0.009862788952887058, 0.021774444729089737,
    -0.0019318260019645095, -0.0007033763104118407, 0.01911243237555027, 0.03868472948670387, 0.018567081540822983, 0.01285807229578495, -0.02044576406478882, 0.04189068824052811,
    -0.0019251647172495723, 0.027205461636185646, 0.01441042311489582, 0.016816571354866028, 0.020238785073161125, -0.007871348410844803, 0.003976333886384964, -0.020298859104514122,
    0.019170133396983147, 0.029293665662407875, -0.001313279033638537, -0.03443366661667824, -0.017014071345329285, 0.0011755614541471004, -0.04704727604985237, -0.03365449234843254,
    -0.010724561288952827, 0.044984299689531326, 0.013842235319316387, 0.02031073532998562, -0.0022225605789572, 0.012907055206596851, -0.0930929183959961, 0.0024554396513849497,
    -0.02174968458712101, -0.013651831075549126, 0.006391873583197594, -0.04897455498576164, 0.04453347995877266, 0.0380074568092823, -0.004264601971954107, -0.05170220136642456,
    -0.044714879244565964, -0.024406027048826218, -0.00950642954558134, 0.002487563993781805, -0.028205575421452522, 0.06845948845148087, -0.016502104699611664, -0.015074976719915867,
    -0.00812299083918333, -0.023005738854408264, 0.008203502744436264, 0.015450040809810162, 0.0010205910075455904, 0.003176738740876317, -0.023540187627077103, -0.02012382075190544,
    -0.01873583160340786, -0.03139844164252281, -0.011106696911156178, 0.016416899859905243, 0.009678356349468231, 0.01962268352508545, -0.009420307353138924, 0.03866598382592201,
    -0.002047268208116293, -0.02371091954410076, -0.03200756758451462, -0.019576814025640488, -0.0018570353277027607, 0.015362508594989777, 0.028318220749497414, -0.015398213639855385,
    0.014498578384518623, -0.028465373441576958, -0.029696743935346603, 0.046368733048439026, -0.033697471022605896, -0.006138216238468885, 0.030772358179092407, 0.004400673322379589,
    0.014987600967288017, 0.019564634189009666, -0.0027127116918563843, -0.05649867653846741, -0.013707946985960007, -0.02374565601348877, 0.07149647921323776, -0.019292378798127174,
    -0.027612611651420593, -0.011761041358113289, 0.0008699094760231674, 0.007548027206212282, 0.036676160991191864, -0.008410031907260418, 0.05810239166021347, -0.02839098684489727,
    0.007145861629396677, 0.01958678662776947, -0.01974114403128624, 0.03451964259147644, 0.01808830164372921, 0.011231178417801857, 0.006237367168068886, -0.010075287893414497,
    0.007387305144220591, 0.017902789637446404, -0.057761069387197495, -0.01880742609500885, -0.026198290288448334, 0.01029079407453537, 0.009495875798165798, 0.014084205962717533,
    -0.00602299626916647, 0.04471936449408531, 0.0309204813092947, -0.07087090611457825, 0.020048225298523903, 0.004386876244097948, -0.017124582082033157, 0.0009149928227998316,
    0.010777815245091915, 0.021973878145217896, 0.01335522998124361, 0.022369589656591415, -0.0015918910503387451, -0.014038470573723316, 0.046494778245687485, -0.01051031332463026,
    0.026411106809973717, 0.03561941534280777, 0.021294139325618744, 0.0372917540371418, 0.038380470126867294, 0.0173052791506052, 0.02569865621626377, 0.004631277173757553,
    0.011942371726036072, 0.005051987245678902, -0.020165221765637398, 0.01445965189486742, 0.07557709515094757, 0.015278141014277935, -0.03956756368279457, -0.005797362886369228,
    0.008785272017121315, 0.0008427544380538166, -0.004319763742387295, -0.006626416463404894, 0.001215339289046824, 0.04042821750044823, -0.012825198471546173, 0.026956025511026382,
    0.006856916937977076, 0.006897781044244766, -0.05367608368396759, -0.007751145400106907, -0.001556618488393724, 0.0009196163737215102, 0.0019467354286462069, 0.010052706114947796,
    0.031394582241773605, 0.027026483789086342, -0.024117838591337204, 0.04223677143454552, 0.055446695536375046, 0.03226924315094948, -0.040345318615436554, -0.003800543025135994,
    0.023709118366241455, 0.0018275495385751128, 0.0028640322852879763, 0.00906120054423809, -4.990772140445188e-05, 0.03309359773993492, -0.015982961282134056, 0.01445300318300724,
    -0.002796891378238797, 0.07073770463466644, 0.03038652613759041, 0.009411326609551907, 0.009894994087517262, 0.044771529734134674, 0.03802871331572533, 0.009023087099194527,
    -0.0332811065018177, -0.013513593934476376, -0.03412419185042381, -0.004905661102384329, 0.0036388488952070475, 0.0011482638074085116, -0.04751037806272507, -0.031524352729320526,
    -0.0010931402212008834, -0.005250603426247835, 0.05754934251308441, 0.03165998309850693, 0.02819160185754299, -0.004853181075304747, -0.0028288124594837427, 0.0077415709383785725,
    0.00694719422608614, 0.00027511746156960726, -0.002384489169344306, -0.034828126430511475, -0.040073420852422714, 0.02059461735188961, 0.0020256759598851204, -0.008916153572499752,
    0.037594832479953766, -0.005629712715744972, 0.009390192106366158, 0.004580232780426741, -3.635455868788995e-05, -0.025511134415864944, -0.03495191037654877, -0.005122989881783724,
    0.0026743761263787746, 0.04224737361073494, 0.01927744597196579, 0.018327713012695312, -0.004829974379390478, 0.04939361661672592, -0.02956252172589302, -0.03672519698739052,
    -0.014774621464312077, -0.030681543052196503, -0.01776820793747902, 0.03394988924264908, -0.050170086324214935, -0.026946282014250755, -0.00020918877271469682, 0.019950956106185913,
    0.020903075113892555, -0.017981749027967453, -0.026415985077619553, 0.006954355631023645, -0.027862364426255226, -0.01705249398946762, 0.01030327845364809, 0.031142935156822205,
    0.003619119757786393, -0.02402721717953682, 0.023681912571191788, -0.01525493897497654, 0.033960241824388504, -0.020930515602231026, 0.0228668674826622, -0.002363446867093444,
    -0.008426764979958534, -0.019321100786328316, -0.00892694666981697, -0.013108374550938606, 0.00331778428517282, 0.03288233280181885, -0.004878182429820299, -0.03891812264919281,
    0.07567940652370453, -0.004540850408375263, -0.05208937078714371, 0.007055556867271662, 0.007966467179358006, 0.0104962307959795, -0.03221691772341728, -0.01305327657610178,
    0.03809167072176933, 0.010209192521870136, 0.0007293770904652774, -0.00445116451010108, 0.04900244623422623, 0.002864873269572854, 0.03262842446565628, 0.0027695433236658573,
    0.04190501570701599, 0.001320409937761724, -0.0014623294118791819, 0.01327611692249775, -0.02470637671649456, 0.02347872592508793, -0.0057270945981144905, 0.015145988203585148,
    0.01971791684627533, -0.04609424248337746, 0.012869644910097122, -0.0022820679005235434, 0.015332802198827267, 0.022111721336841583, -0.024198666214942932, -0.033676985651254654,
    0.020642949268221855, 0.0011784357484430075, 0.006583087611943483, -0.04352942109107971, -0.008704010397195816, 0.003378667403012514, -0.007330369669944048, 0.042863477021455765,
    -0.016042526811361313, 0.0006788414902985096, -0.018457500264048576, 0.007874411530792713, 0.01823839358985424, -0.033455703407526016, 0.021512238308787346, 0.029103126376867294,
    -0.02849142625927925, -0.03766077011823654, -0.0024470656644552946, 0.0027079987339675426, 0.010480303317308426, 0.019592296332120895, 0.04215759411454201, 0.01604558527469635,
    -0.014766394160687923, -0.031053178012371063, -0.04079382121562958, 0.01074891071766615, 0.023966198787093163, 0.012735970318317413, -0.017854198813438416, -0.023898905143141747,
    0.04059825837612152, 0.001910369610413909, -0.03513464704155922, 0.011124999262392521, 0.010234097950160503, 0.006120764184743166, -0.011224711313843727, 0.010135537944734097,
    -0.023705076426267624, -0.015035652555525303, -0.020162777975201607, -0.012983865104615688, 0.012407631613314152, 0.04360531270503998, 0.018032608553767204, 0.017947079613804817,
    0.04588036984205246, 0.013972662389278412, -0.017046339809894562, -0.022059891372919083, 0.0007833014824427664, 0.04271969944238663, 0.005460858345031738, -0.019513575360178947,
    0.01498475857079029, -0.011250953190028667, -0.02889888547360897, -0.028727270662784576, -0.024156922474503517, -0.014447752386331558, -0.005674853455275297, 0.02067529410123825,
    0.01024460420012474, 0.026233401149511337, 0.001232879818417132, -0.02524506486952305, -2.1921672669122927e-05, 0.0006333489436656237, 0.0116133326664567, 0.00779467448592186,
    -0.00825513619929552, 0.018018031492829323, -0.0016262438148260117, -0.021282298490405083, 0.02597857266664505, -0.01907133124768734, -0.02041107974946499, -0.031924858689308167,
    -0.03947267308831215, 0.007829543203115463, -0.003938150126487017, 0.020616229623556137, -0.01673314906656742, -0.006335132289677858, -0.039220668375492096, 0.008317780680954456,
    0.010760127566754818, 0.006297932006418705, -0.0037160732317715883, -0.01265646517276764, -0.0055275182239711285, 0.00809205137193203, 0.011746471747756004, 0.006104419007897377,
    0.008336981758475304, -0.002592321252450347, -0.05620444566011429, 0.031841717660427094, 0.007282653357833624, 0.050890661776065826, -0.04305694252252579, -0.017226263880729675,
    0.01599445752799511, 0.009862948209047318, -0.01690198853611946, 0.04116114601492882, 0.031166434288024902, -0.0320802740752697, -0.0023108208552002907, -0.05721515789628029,
    -0.04099147766828537, -0.010362640023231506, -0.009130463935434818, -0.011098867282271385, -0.019504189491271973, -0.01485692709684372, -0.06828047335147858, 0.002003772184252739,
    0.028353098779916763, 0.01260399166494608, 0.042298443615436554, 0.014294597320258617, -0.019090600311756134, 0.008234355598688126, -0.03006819449365139, -0.0011446041753515601,
    -0.01718873903155327, -0.03574080765247345, -0.012192723341286182, -0.004920567851513624, 0.030872758477926254, -0.02456243894994259, -0.009443958289921284, -0.03652457147836685,
    -0.008791936561465263, -0.008288288488984108, 0.003544552717357874, -0.04401886463165283, -0.025295516476035118, 0.03886719420552254, 0.024072129279375076, -0.03446046635508537,
    -0.054193250834941864, 0.02822604961693287, 0.017865395173430443, 0.020511731505393982, 0.008837394416332245, 0.01511275302618742, -0.01656043715775013, -0.026623275130987167,
    0.010080115869641304, -0.02299809828400612, 0.022883163765072823, -0.006195773836225271, -0.013137112371623516, -0.020406853407621384, -0.023556731641292572, 0.0018640069756656885,
    0.04180382937192917, 0.0273329745978117, 0.040592484176158905, -0.023233607411384583, 0.020900797098875046, 0.00012222673103678972, -0.000458818074548617, 0.0111268050968647,
    -0.0077322786673903465, -0.0023975460790097713, -0.07939720153808594, 0.00775022292509675, -0.01946645975112915, 0.01670004613697529, 0.023369640111923218, -0.02703115902841091,
    0.02387896180152893, 0.0011068489402532578, 0.013454613275825977, 0.021316470578312874, -0.008810537867248058, 0.03585691377520561, -0.005071256775408983, -0.021564265713095665,
    0.01693575084209442, -0.0018078642897307873, 0.02564779669046402, 0.008890180848538876, 0.004757449496537447, 0.019314859062433243, -0.03320423886179924, 0.0015433619264513254,
    0.01583757996559143, 0.03805737569928169, -0.012639191001653671, -0.003531316528096795, -0.009347065351903439, -0.048523273319005966, 0.027949102222919464, -0.041747018694877625,
    -0.023342978209257126, 0.007599635515362024, 0.01262229960411787, 0.015820715576410294, 0.0037657723296433687, 0.0027490442153066397, -0.004600150510668755, 0.03749072551727295,
    0.0014819044154137373, 0.03311838582158089, 0.02575487643480301, -0.00926064234226942, 0.009970970451831818, -0.013207423500716686, -0.0043807923793792725, -0.031783584505319595,
    0.013103065080940723, -0.009077300317585468, 0.017231158912181854, -0.028116250410676003, -0.026871753856539726, -0.008026030845940113, 0.017165781930088997, -0.000589171308092773,
    0.005866235122084618, 0.020447708666324615, -0.02402626723051071, -0.011205339804291725, 0.0023341174237430096, -0.035438597202301025, 0.027113469317555428, -0.0065381769090890884,
    -0.030580054968595505, 0.007093858439475298, 0.023894330486655235, -0.008341246284544468, 0.003238297300413251, 0.01306853350251913, -0.014096551574766636, 0.008171449415385723,
    0.018243445083498955, -0.0017603622982278466, 0.014392300508916378, -0.00367008987814188, -0.03888867422938347, 0.003911235835403204, 0.030406471341848373, -0.0023564696311950684,
    0.029808269813656807, 0.015647493302822113, -0.06853248178958893, -0.0178255382925272, 0.0025702693965286016, 0.03640015050768852, -0.0217205248773098, -0.005822574719786644,
    0.0005554464878514409, -0.03872004896402359, 0.02485438995063305, -0.028724465519189835, 0.0330352745950222, 0.02092299796640873, -0.007709963247179985, 0.007735860999673605,
    0.029982630163431168, -0.0008049721946008503, 0.011107740923762321, 0.01868004910647869, -0.011582896113395691, -0.03634168580174446, -0.00857392605394125, 0.014241203665733337,
    0.018583109602332115, -0.018986184149980545, -0.0474783219397068, 0.013740886002779007, -0.0033205668441951275, -0.0016127063427120447, -0.00017356681928504258, 0.00784377008676529,
    -0.02030857652425766, -0.006192075088620186, 0.00023103281273506582, 0.02882385440170765, 0.007955321110785007, -0.00600699195638299, 0.0008319602929987013, -0.009263832122087479,
    -0.014310063794255257, 0.01009688712656498, -0.04249749332666397, -0.01243387721478939, -0.0017742534400895238, 0.05879593640565872, 0.03969716653227806, 0.04189629852771759,
    0.031526677310466766, 0.012074343860149384, -0.06677661836147308, 0.0168340802192688, 0.027182037010788918, 0.011599463410675526, -0.03554196655750275, 0.009116487577557564,
    -0.0051655955612659454, -0.004637627862393856, -0.01215244922786951, -0.03745843097567558, 0.012044960632920265, 0.05404110252857208, 0.024121109396219254, 0.011624547652900219,
    0.01405247487127781, -0.004633365664631128, -0.026033105328679085, -0.008034229278564453, 0.017167644575238228, -0.03224603459239006, -0.030210867524147034, -0.02356618456542492,
    0.015058554708957672, 0.03436615318059921, -0.00574088841676712, -0.03336526080965996, 0.012807723134756088, -0.019133366644382477, 0.004165356047451496, 0.012014759704470634,
    0.01620691642165184, -0.01409232895821333, 0.018919089809060097, -0.010487760417163372, 0.033113058656454086, 0.018361421301960945, -0.013829019851982594, -0.016465438529849052,
    -0.03368062525987625, 0.008334257639944553, 0.005205148831009865, -0.0414801649749279, -0.008092712610960007, 0.044614147394895554, -0.0553315207362175, -0.028902070596814156,
    0.017188746482133865, 0.02567652054131031, -0.01785866543650627, 0.012871013954281807, 0.015522683039307594, 0.026863576844334602, 0.0038243683520704508, 0.006559019908308983,
    0.035340070724487305, -0.008316107094287872, -0.018703412264585495, -0.022563617676496506, -0.030263198539614677, 0.006862781010568142, -0.019664496183395386, -0.046515244990587234,
    -0.023762138560414314, -0.005512412637472153, -0.002868909388780594, -0.003845080267637968, 0.04213237389922142, -0.008895084261894226, 0.0004850633558817208, -0.004089086316525936,
    0.0422455333173275, -0.009173919446766376, -0.0038341814652085304, 0.05109848454594612, -0.016493646427989006, 0.02354622818529606, 0.028015177696943283, 0.00808321125805378,
    -0.010961467400193214, -0.012987425550818443, -0.04883020371198654, -0.0009774290956556797, -0.017097821459174156, -0.014381506480276585, -0.031194103881716728, -0.018404221162199974,
    0.012323006987571716, -0.0018866320606321096, -0.0034838321153074503, -0.07554105669260025, -0.02187291905283928, -0.00726914219558239, -0.015416726469993591, 0.013978803530335426,
    0.004174863453954458, -0.0190602857619524, 0.021331895142793655, 0.01467977836728096, 0.002474796259775758, -0.007435413543134928, -0.0010057272156700492, 0.03356951102614403,
    -0.007012539077550173, 0.01292173471301794, -0.023861009627580643, 0.00264109973795712, 0.03300832584500313, -0.016996677964925766, -0.03226315602660179, -0.03077348694205284,
    0.004680178593844175, 0.012006943114101887, 0.03195779398083687, -0.03301398456096649, 0.0015052560484036803, -0.008390337228775024, 0.025068582966923714, 0.014213352464139462,
    0.0015842043794691563, -0.020940883085131645, 0.02086779475212097, 0.01602289080619812, 0.011159040965139866, -0.043592777103185654, -0.03486868366599083, 0.00717554334551096,
    0.00452593807131052, 0.01784687116742134, -0.018722206354141235, -0.025208521634340286, -0.05437992513179779, 0.021241236478090286, -0.002025728113949299, -0.021191507577896118,
    -0.007468078751116991, 0.001903379219584167, 0.038106802850961685, 0.02919185906648636, 0.05072515085339546, 0.03392288088798523, 0.005231726448982954, 0.03854658827185631,
    -0.014352036640048027, 0.012705233879387379, -0.016008710488677025, -1.3277937796374317e-05, -0.0002753000590018928, -0.025382742285728455, 0.006412899121642113, -0.01560298539698124,
    -0.009891996160149574, 0.034195974469184875, 0.043972887098789215, 0.040711186826229095, 0.010557153262197971, -0.03403181582689285, -0.005014334339648485, 0.014982405118644238,
    0.07505395263433456, -0.002272358164191246, -0.014326481148600578, -0.012708699330687523, 0.03600290045142174, -0.011554049327969551, -0.022068263962864876, 0.018202107399702072,
    0.016249001026153564, -0.01387797761708498, -0.0525694414973259, -0.019326968118548393, 0.007001073099672794, -0.07981228083372116, 0.018313759937882423, -0.01984989084303379,
    0.0017262410838156939, -0.02708505466580391, 0.044139835983514786, -0.005956469569355249, -0.0058371941559016705, 0.0036205188371241093, -0.023139091208577156, -0.004599128849804401,
    0.042411867529153824, -0.009442646987736225, 0.014424359425902367, -0.00398788508027792, 0.016523919999599457, -0.04441023990511894, -0.009826263412833214, -0.02281397394835949,
    0.048463497310876846, 0.01608584262430668, 0.03274102136492729, -0.019081825390458107, 0.06140638142824173, -0.032921213656663895, -0.03215818852186203, 0.005554741248488426,
    -0.01250132080167532, -0.006033462472259998, 0.027039363980293274, -0.00019627728033810854, 0.05927547067403793, 0.016693029552698135, 0.03551364317536354, 0.021486585959792137,
    0.03330572322010994, -0.037336621433496475, 0.04286991432309151, 0.01860848069190979, 0.005167579744011164, 0.013357099145650864, 0.013283771462738514, -0.024180831387639046,
    -0.006687348708510399, -0.013610209338366985, -0.010571790859103203, 0.015900658443570137, -0.00836634635925293, 0.015552019700407982, 0.026048894971609116, 0.027193456888198853,
    0.02598682790994644, 0.0006061892490833998, -0.023712269961833954, -0.012622800655663013, 0.05819818750023842, -0.023707572370767593, -0.012430444359779358, -0.019844071939587593,
    0.041559647768735886, -0.018732508644461632, -0.06657682359218597, 0.0011515626683831215, -0.034579914063215256, -0.019894316792488098, 0.038053736090660095, -0.004189673345535994,
    -0.04434339329600334, -0.027019444853067398, 0.029653122648596764, 0.0023699093144387007, 0.02099001593887806, -0.030639031901955605, 0.03440901264548302, -0.03583284467458725,
    -0.015879077836871147, -0.017771104350686073, -0.010041801258921623, -0.02444392256438732, -0.008582647889852524, 0.007156006526201963, -0.008557215332984924, -0.005908368155360222,
    0.016132498160004616, -0.03678622841835022, -0.06683734059333801, -0.011349290609359741, 0.027491549029946327, 0.02816011570394039, -0.05596267804503441, 0.025416888296604156,
    0.015980396419763565, 0.014150703325867653, -0.015389258973300457, 0.023924758657813072, 0.002514190971851349, 0.009104150347411633, -0.041770629584789276, -0.014864662662148476,
    0.04599921032786369, -0.025856876745820045, -0.029845047742128372, 0.03357237949967384, 0.021715613082051277, -0.02487599104642868, -0.051317233592271805, -0.07449343055486679,
    -0.03225579485297203, -0.008653848432004452, 0.018437238410115242, 0.016286702826619148, -0.0032599170226603746, 0.017775332555174828, -0.022660747170448303, 0.0046678329817950726,
    -0.018100149929523468, -0.0142075065523386, -0.013427053578197956, 0.017070142552256584, 0.03735395893454552, 0.005637242458760738, -0.026459477841854095, 0.009840331971645355,
    -0.005228363908827305, -0.043691471219062805, 0.006642654538154602, 0.005341362673789263, 0.010537590831518173, 0.02323118783533573, -0.007910991087555885, 0.0027210235130041838,
    0.01783456653356552, 0.01608140580356121, -0.015974625945091248, 0.008125124499201775, 0.02838101051747799, 0.032300885766744614, 0.012796705588698387, -0.05222831666469574,
    0.020797312259674072, -0.006558283232152462, -0.009958073496818542, -0.008157174102962017, -0.03136767819523811, 0.010855686850845814, -0.04015028849244118, 0.04448462650179863,
    -0.0415862537920475, 0.016683606430888176, -0.020439838990569115, 0.019931277260184288, 0.02305992692708969, -0.009364555589854717, 0.011134524829685688, -0.029379060491919518,
    0.0036526534240692854, -0.00303466385230422, -0.018721234053373337, -0.03197677433490753, -0.03532490134239197, 0.02220269851386547, -0.007218935526907444, -0.043200425803661346,
    0.006925273686647415, -0.0013169392477720976, -0.0035985042341053486, -0.03206910938024521, 0.01879691146314144, 0.003707049647346139, 0.021094391122460365, 0.0010974708711728454,
    0.015770789235830307, -0.021198777481913567, -0.02405090257525444, -0.008753752335906029, -0.010038796812295914, 0.04463427513837814, 0.0001797364529920742, 0.02645733579993248,
    -0.037681031972169876, -0.03665813058614731, -0.010522862896323204, -0.014160879887640476, -0.04030126333236694, -0.0066710300743579865, 0.003340783528983593, -0.009109484031796455,
    0.029660962522029877, -0.005827715154737234, -0.03759964555501938, -0.005370930768549442, 0.0347672700881958, -0.0200712438672781, -0.015965426340699196, -0.047654952853918076,
    0.0505618117749691, 0.005753621459007263, 0.00850799772888422, -0.02019755356013775, -0.015031454153358936, 0.022829774767160416, -0.009714593179523945, 0.015494011342525482,
    0.05377970635890961, -0.02890566922724247, 0.023636406287550926, -0.025910859927535057, -0.014675674960017204, -0.0010276346001774073, -0.020884964615106583, 0.05961456149816513,
    0.030710071325302124, -0.0023208872880786657, -0.05143937095999718, 0.0033934740349650383, 0.005582235287874937, -0.01953069679439068, 0.034453921020030975, -0.008924605324864388,
    0.012555870227515697, 0.021775642409920692, -0.0064498623833060265, 0.010088110342621803, 0.00769235473126173, -0.025183342397212982, 0.017659595236182213, -8.143099694279954e-05,
    -0.041099999099969864, -0.03265288099646568, -0.024943234398961067, 0.005012448411434889, 0.00014531392662320286, 0.045915279537439346, 0.02827472798526287, -0.018077000975608826,
    -0.013050940819084644, 0.016268473118543625, -0.018726959824562073, 0.009338406845927238, 0.019742580130696297, 0.009355046786367893, -0.021269455552101135, 0.02123473957180977,
    0.02539432980120182, -0.009747708216309547, -0.008374694734811783, 0.023664118722081184, -0.031093647703528404, 0.01865842007100582, 0.005784887354820967, 0.009650757536292076,
    0.019218187779188156, -0.027371535077691078, -0.01704435795545578, 0.01867806166410446, -0.016385860741138458, -0.0018745275447145104, -0.02178262360394001, -0.01682589016854763,
    0.02567160688340664, 0.005857103504240513, 0.02762746438384056, 0.01097389031201601, 0.01744750514626503, 0.020411835983395576, -0.0008434977498836815, 0.023589203134179115,
    -0.011761455796658993, -0.0008195731788873672, 0.01969977654516697, -0.014813914895057678, -0.008549784310162067, -0.0030508805066347122, -0.003441642038524151, -0.028041081503033638,
    0.00019648468878585845, -0.00702629704028368, -0.00764459790661931, -0.005669597070664167, -0.003029315732419491, 0.011893512681126595, -0.004091303795576096, -0.00010673276119632646,
    0.011261249892413616, -0.0052542961202561855, -0.02282281406223774, 0.013528561219573021, 0.0008928803727030754, 0.02036268077790737, 0.01635678857564926, -0.017947204411029816,
    -0.001839038566686213, 0.01942206174135208, 0.007427824195474386, -0.008550141006708145, -0.007035973481833935, -0.014652911573648453, -0.00941692665219307, 0.01104813627898693,
    -0.01054195687174797, 0.01641005463898182, 0.010175470262765884, 0.009439833462238312, 0.03489737957715988, 0.001363178831525147, 0.050684988498687744, -0.004342000465840101,
    -0.008454824797809124, 0.008183415979146957, 0.0015727570280432701, -0.026036959141492844, 0.0027783119585365057, 0.025700073689222336, 0.0011249225353822112, 0.013934968970716,
    -0.007098393980413675, -0.035934653133153915, 0.009096800349652767, -0.009183269925415516, 0.00046464279876090586, 0.012377174571156502, 0.012331357225775719, -0.009550211951136589,
    0.005130901001393795, -9.48450542637147e-05, 0.004483342170715332, -0.017337359488010406, -0.01146166305989027, 0.012380868196487427, 0.0226709246635437, 0.02521061897277832,
    -0.003812504233792424, 0.00428611459210515, 0.004208129830658436, 0.020321527495980263, 0.01451470609754324, 0.0021539046429097652, 0.0057039023377001286, 0.0017437109490856528,
    0.0011101807467639446, -0.002208947902545333, -0.002997551579028368, 0.02025243081152439, -0.004334348253905773, -0.0016566442791372538, 0.011501294560730457, -0.018612464889883995,
    0.006400467827916145, -0.006739367265254259, 0.001530480571091175, -0.0006511574611067772, -0.01135479286313057, -0.005280659068375826, -0.006802182178944349, -0.03212102875113487,
    0.0007609861204400659, -0.002459671115502715, -0.04273093491792679, -0.0012186968233436346, 0.011164605617523193, 0.0173582024872303, 0.006629199720919132, 0.0024094018153846264,
    0.006805261131376028, -0.00473420787602663, -0.005680651403963566, -0.005623918026685715, 0.016077395528554916, -0.008630332536995411, 0.007009849883615971, 0.0056313867680728436,
    -0.026748692616820335, -0.013028358109295368, -0.010998154059052467, -0.0033139425795525312, 0.005495575722306967, 0.01728796772658825, -0.014158600009977818, -0.00982875470072031,
    0.008296303451061249, 0.002886742353439331, -0.013219423592090607, -0.024990379810333252, -0.0018705639522522688, -0.005517310928553343, 0.0008475871873088181, 0.011322022415697575,
    0.0029256639536470175, -0.007619144860655069, -0.011238392442464828, -0.006158662494271994, 0.003921338822692633, 0.008624223992228508, 0.003099854802712798, -0.02322251908481121,
    0.026600828394293785, -0.0030222395434975624, 0.08125632256269455, -0.037485845386981964, -0.08395323157310486, -0.036737121641635895, -0.005031324923038483, 0.009531076066195965,
    0.022512877359986305, 0.02899983525276184, -0.00013936578761786222, 0.007311465684324503, -0.011447452008724213, -0.02962559089064598, -0.01904173567891121, 0.057549308985471725,
    0.03637082129716873, 0.0067719048820436, -0.03318309411406517, -0.04762451350688934, -0.016756169497966766, -0.05529811233282089, -0.022896017879247665, 0.0555119588971138,
    0.027179190889000893, 0.007164489943534136, -0.02061677724123001, -0.053273845463991165, 0.011671006679534912, -0.060255102813243866, -0.028313638642430305, 0.03386429697275162,
    -0.02330324426293373, 0.08797875046730042, 0.05705157294869423, 0.026013826951384544, -0.03538963571190834, -0.0332367867231369, 0.051644466817379, 0.010234666056931019,
    0.011127011850476265, 0.06643259525299072, -0.0675918236374855, 0.01872744783759117, 0.03249078989028931, -0.015154770575463772, 0.013151721097528934, 0.01042825635522604,
    -0.045332279056310654, -0.05953092500567436, 0.052131108939647675, 0.08990854024887085, 0.0815339982509613, 0.06582818925380707, -0.07455118745565414, -0.03998887538909912,
    0.009892036207020283, 0.01709926687180996, -0.03313196450471878, 0.02954886294901371, 0.04518210515379906, -0.016411414369940758, -0.01416674442589283, -0.029760953038930893,
    -0.02426401898264885, 0.03904397413134575, 0.033885229378938675, 0.0010942267253994942, -0.007602524943649769, 0.029700137674808502, 0.024508725851774216, 0.01711510866880417,
    0.007307994179427624, -0.021809080615639687, -0.02350194752216339, -0.022033900022506714, 0.025628304108977318, -0.07410567998886108, 0.05482283979654312, -0.04438517615199089,
    0.0249142125248909, 0.03760639578104019, 0.02212965302169323, -0.005321161821484566, -0.0471903420984745, 0.022505905479192734, -0.0007004901417531073, -0.030226480215787888,
    0.016021231189370155, -0.06363368779420853, -0.02660517953336239, 0.05520545691251755, 0.06407523900270462, -0.07370483875274658, -0.0674542784690857, -0.07400187104940414,
    0.027860309928655624, 0.009493619203567505, 4.968286884832196e-05, 0.053646840155124664, 0.01688438095152378, -0.04857713356614113, 0.011926958337426186, 0.0243480633944273,
    0.048361483961343765, 0.07562199980020523, 0.01963745430111885, 0.01335572823882103, 0.025889744982123375, 0.00018368690507486463, -0.042451128363609314, -0.028950752690434456,
    -0.008806208148598671, -0.0019361801678314805, 0.044309183955192566, 0.024937015026807785, 0.008144961670041084, -0.021337376907467842, -0.027211956679821014, -0.031217649579048157,
    -0.005453535821288824, -0.02560647390782833, 0.004035130143165588, 0.051315195858478546, -0.05636076629161835, -0.04252026602625847, 0.007709720637649298, 0.00468035601079464,
    -0.002116196556016803, -0.020369868725538254, 0.01908917911350727, -0.017344553023576736, -0.010906094685196877, 0.009889621287584305, 0.05160214379429817, 0.0428188256919384,
    0.025263288989663124, 0.04449896886944771, -0.03271816670894623, -0.015977611765265465, 0.037426408380270004, 0.003490447299554944, 0.04605003073811531, -0.0019551808945834637,
    0.009983347728848457, 0.00976941641420126, -0.021107353270053864, 0.03770681470632553, -0.007083824370056391, -0.03372756764292717, -0.01024444680660963, -0.056646645069122314,
    0.08489286154508591, 0.020103542134165764, -0.0059430538676679134, -0.03566339612007141, -0.03402077034115791, -0.04586416110396385, -0.07289556413888931, -0.0401938371360302,
    0.029690686613321304, -0.052809786051511765, 0.0416739247739315, 0.015900954604148865, -0.03602553531527519, -0.010432078503072262, 0.029359113425016403, -0.0385068915784359,
    -0.03287205845117569, 0.11731114238500595, 0.03343797102570534, -0.0035698311403393745, -0.021644046530127525, -0.005526605062186718, 0.05648259446024895, 0.00883968360722065,
    -0.02862318977713585, -0.030903402715921402, 0.04291338846087456, -0.010176022537052631, -0.03574662655591965, -0.006934547331184149, 0.04162440076470375, -0.025115950033068657,
    -0.09556184709072113, 0.005199809558689594, -0.01835036836564541, -0.06127045303583145, 0.0212868545204401, -0.0281277634203434, 0.03423910215497017, -0.05283384770154953,
    -0.0039706164970994, -0.009933188557624817, 0.012271528132259846, 0.0045214127749204636, 0.01168105285614729, -0.0005883126868866384, -0.022071827203035355, 0.07958146184682846,
    0.006317283026874065, 0.025398263707756996, -0.026513373479247093, -0.00993694830685854, -0.007209050934761763, -0.07508651167154312, 0.03314437344670296, -0.0026816579047590494,
    0.0573129765689373, -0.03461665287613869, -0.013650456443428993, -0.019878024235367775, -0.03767528012394905, 0.048488304018974304, 0.013447333127260208, 0.0026961069088429213,
    0.023818805813789368, -0.015309897251427174, -0.0002866199938580394, -0.052005868405103683, -0.027985719963908195, -0.028248164802789688, -0.012880707159638405, -0.0034581590443849564,
    -0.024792490527033806, -0.03500596806406975, 0.03459518402814865, 0.006261497735977173, 0.01533390674740076, -0.007501896936446428, -0.020276447758078575, -0.05201328545808792,
    -0.017884423956274986, -0.0019484844524413347, -0.002961697755381465, 0.056549910455942154, -0.0686430111527443, -0.01093845721334219, -0.004319885745644569, 0.02403370663523674,
    0.026649776846170425, -0.04282863438129425, 0.04578520730137825, 0.02091226354241371, 0.006314015947282314, -0.037760790437459946, 0.00390764232724905, -0.03479839861392975,
    0.025542018935084343, 0.006402318831533194, -0.05451463907957077, 0.03538110479712486, -0.02965250052511692, -0.012411633506417274, -0.039826590567827225, 0.025794686749577522,
    0.003031256841495633, -0.0024855751544237137, -0.02470235899090767, 0.008888996206223965, 0.0413118414580822, 0.07424532622098923, -0.01624883897602558, -0.003644118085503578,
    -0.005936219356954098, 0.04051756486296654, 0.009420291520655155, 0.013270962983369827, 0.01984669640660286, 0.0147348428145051, 0.08509613573551178, -0.06140259653329849,
    0.018680868670344353, -0.0006372570060193539, 0.012442720122635365, 0.030389243736863136, -0.07652698457241058, 0.03970280662178993, -0.003972189966589212, 0.025591377168893814,
    -0.03685446456074715, 0.00439798180013895, -0.0028441143222153187, 0.02028311789035797, -0.010547511279582977, -0.020199421793222427, -0.011569974943995476, 0.03015173226594925,
    -0.009654872119426727, -0.10280204564332962, -0.02272718772292137, -0.02261849120259285, 0.03971864655613899, -0.006433398928493261, -0.0110335573554039, -0.04446259140968323,
    0.06909012049436569, 0.07581596076488495, 0.05054345726966858, -0.02833530865609646, 0.04906463623046875, 0.05866684019565582, -0.035090599209070206, 0.040259409695863724,
    -0.01946672424674034, 0.016389867290854454, -0.025790583342313766, 0.02444792166352272, -0.0625881627202034, 0.011085492558777332, 0.010117468424141407, -0.019704002887010574,
    0.007174474187195301, 0.0021849372424185276, -0.028210945427417755, -0.040280748158693314, -0.05845970660448074, 0.0103213582187891, 0.014135644771158695, 0.008835778571665287,
    0.013411549851298332, -0.07256489247083664, -0.033383555710315704, -0.013731379061937332, -2.0879865587630775e-06, 0.08024859428405762, -0.01524810679256916, -0.1009516566991806,
    0.010657484643161297, -0.03584110364317894, -0.03156019002199173, -0.1176154837012291, -0.05287141725420952, 0.005299714393913746, 0.03171005845069885, -0.00422232411801815,
    -0.07455907016992569, -0.02176397293806076, 0.035780686885118484, -0.023758964613080025, -0.01656048744916916, 0.021244527772068977, 0.010923881083726883, -0.0481497161090374,
    -0.029743533581495285, 0.05008777976036072, -0.043489135801792145, -0.12045276165008545, -0.08426118642091751, 0.07033954560756683, -0.01754111610352993, -0.0016815685667097569,
    -0.10380474478006363, -0.028539735823869705, 0.056985992938280106, -0.010757772251963615, -0.016890184953808784, 0.04269874468445778, 0.004991395864635706, -0.052840545773506165,
    -0.02619856782257557, -0.01947963237762451, 0.00029662379529327154, -0.009092547930777073, -0.09991486370563507, -0.05294886976480484, -0.048739511519670486, -0.0115559296682477,
    0.05550619959831238, -0.03308556228876114, -0.02995152398943901, -0.013391917571425438, -0.024205133318901062, 0.027574846521019936, -0.028859125450253487, 0.059084560722112656,
    0.001309641171246767, -0.03192809596657753, 0.009489410556852818, -0.010054558515548706, -0.011439846828579903, 0.047623615711927414, -0.08466396480798721, -0.024985449388623238,
    0.0750025138258934, 0.04378725215792656, 0.0884309709072113, -0.001426106202416122, 0.059712737798690796, -0.015826545655727386, 0.01731332391500473, -0.050067801028490067,
    -0.006312517449259758, 0.03634911775588989, 0.06608344614505768, -0.0059732478111982346, -0.01696656085550785, 0.05346820503473282, -0.05107588693499565, -0.00011873012408614159,
    0.01892480067908764, -0.021150575950741768, 0.07739637047052383, -0.01662062667310238, -0.012354210019111633, 0.05013331398367882, -0.031081590801477432, 0.052616942673921585,
    -0.08212655037641525, -0.02249211259186268, -0.05444325506687164, -0.04483015835285187, 0.02507835626602173, -0.030336620286107063, 0.018999973312020302, 0.011898369528353214,
    -0.02549087442457676, -0.03666829690337181, 0.08224822580814362, -0.03930468484759331, 0.025446834042668343, 0.0473749116063118, -0.01738692820072174, 0.01906236819922924,
    0.04791228100657463, -0.07441890984773636, -0.0582440085709095, 0.002346462570130825, -0.0327916257083416, -0.03491576761007309, -0.06729431450366974, -0.05692124366760254,
    0.013469291850924492, 0.01225994061678648, 0.008214005269110203, 0.04540214687585831, 0.011188965290784836, -0.06881831586360931, 0.015115022659301758, -0.04362212494015694,
    -0.09593147039413452, 0.0027443848084658384, 0.04651116579771042, -0.060960426926612854, -0.014601198956370354, -0.017721056938171387, 0.0006059926236048341, 0.024258330464363098,
    -0.027723044157028198, 0.04596935957670212, -0.005663125775754452, 0.02394668385386467, 0.005107369273900986, -0.014764429070055485, 0.0028003237675875425, -0.09379824250936508,
    0.02176625095307827, 0.0312185101211071, 0.024512261152267456, 0.009690718725323677, 0.053665995597839355, 0.013987744227051735, 0.008056973107159138, -0.07087506353855133,
    -0.0528259240090847, -0.05035632103681564, -0.0670117512345314, 0.017106886953115463, -0.02833360619843006, 0.04815294221043587, 0.008372102864086628, -0.07913028448820114,
    -0.01658431999385357, 0.0016455217264592648, -0.04210452735424042, -0.013390755280852318, -0.0691501721739769, 0.026754777878522873, -0.012483241967856884, -0.08310739696025848,
    -0.016302138566970825, 0.043663036078214645, -0.020218556746840477, -0.07007021456956863, -0.03874168172478676, 0.01933368667960167, -0.005508968140929937, 0.023570161312818527,
    0.026291459798812866, -0.02257622964680195, -0.01512867771089077, -0.016810527071356773, 0.003599279560148716, 0.03727045655250549, -0.06819043308496475, -0.002522501163184643,
    0.05018281564116478, 0.022585038095712662, -0.010727738961577415, -0.010727182030677795, 0.009339078329503536, 0.03288988023996353, -0.0024141205940395594, -0.020607013255357742,
    -0.06372830271720886, 0.06118066981434822, 0.030115164816379547, 0.01590661145746708, -0.007755167316645384, -0.036016449332237244, -0.0015080781886354089, -0.0007005771622061729,
    0.01212739385664463, -0.025423768907785416, 0.06334826350212097, 0.06592290848493576, -0.024067003279924393, -0.06798482686281204, -0.05299490690231323, 0.03886895254254341,
    -0.044270940124988556, 0.05998939648270607, -0.0014274941058829427, -0.024261103942990303, 0.06881965696811676, 0.007621324621140957, 0.011812740005552769, -0.024462800472974777,
    -0.0016511025605723262, 0.021119387820363045, -0.028378957882523537, -0.014142277650535107, -0.0027187264058738947, 0.01777738891541958, 0.029114382341504097, 0.0012428322806954384,
    -0.01565493829548359, 6.175634916871786e-05, -0.011816538870334625, 0.02043207548558712, -0.015382098965346813, 0.010120797902345657, -0.0073274774476885796, 0.02052045613527298,
    -0.022369230166077614, 0.05233445763587952, 0.0898074135184288, 0.0468413308262825, 0.024221308529376984, 0.0053206500597298145, 0.027955731377005577, -0.030983448028564453,
    -0.036080483347177505, -0.008656836114823818, -0.05427287891507149, -0.010139216668903828, -0.06135602667927742, 0.00243353727273643, -0.04349904879927635, -0.014731506817042828,
    0.004659330938011408, 0.00749596580862999, -0.027300402522087097, 0.03257450461387634, 0.007813824340701103, -0.01842493563890457, 0.004640557803213596, 0.04388302192091942,
    -0.0363752506673336, 0.02611684985458851, 0.13044501841068268, -0.0605185404419899, 0.013465032912790775, 0.1130351647734642, -0.014185191132128239, -0.021009372547268867,
    -0.0614299401640892, 0.10700611770153046, -0.030572526156902313, 0.02273961901664734, 0.02734634466469288, 0.014712991192936897, -0.027261987328529358, 0.05987239256501198,
    0.03711521252989769, 0.0755256935954094, -0.030805621296167374, 0.08550203591585159, 0.013361497782170773, -0.01095882523804903, -0.006182476412504911, -0.05544920265674591,
    0.08553972840309143, 0.01915282942354679, 0.07066904008388519, 0.031642645597457886, 0.003363837953656912, -0.06877972185611725, 0.03151955455541611, -0.03667908161878586,
    -0.035562172532081604, -0.009541966952383518, -0.05207541212439537, -0.020746201276779175, -0.026017488911747932, -0.019399909302592278, 0.08362575620412827, -0.0925915390253067,
    -0.011670982465147972, 0.07134102284908295, -0.01796281896531582, 0.02458583377301693, -0.017428727820515633, 0.05316688492894173, -0.02074231579899788, -0.022078368812799454,
    -0.00024726189440116286, 0.028473729267716408, 0.007102243136614561, -0.04961603507399559, -0.015867726877331734, 0.05504763498902321, -0.06160828098654747, 0.015943618491292,
    0.0018551520770415664, -0.02911899797618389, 0.002545382594689727, 0.050884053111076355, -0.03967227414250374, -0.06555750221014023, -0.030368542298674583, -0.025547675788402557,
    -0.003222912084311247, -0.05359784886240959, 0.00511529203504324, 0.07601116597652435, -0.07392799854278564, -0.08533924072980881, -0.054717179387807846, 0.013051776215434074,
    0.059112656861543655, 0.022074196487665176, -0.04469525068998337, 0.07892657071352005, -0.017188336700201035, 0.0002049759787041694, 0.01055031456053257, 0.005892864894121885,
    0.030046973377466202, 0.018279921263456345, -0.0010128029389306903, -0.04959451034665108, 0.02417861483991146, 0.014414956793189049, 0.03980139642953873, -0.03012189455330372,
    -0.046347588300704956, 0.0798109918832779, -0.07420814782381058, -0.008613776415586472, -0.05117963254451752, -0.032735392451286316, -0.01903318427503109, 0.05262594670057297,
    0.05275661125779152, -0.0034194891341030598, -0.007359981536865234, -0.05902900919318199, -0.03966823220252991, 0.07104069739580154, -0.050719253718853, -0.018671628087759018,
    0.013531321659684181, -0.003650292754173279, 0.037389833480119705, 0.035503651946783066, 0.04898163303732872, -0.09126630425453186, -0.030714886263012886, -0.028591159731149673,
    0.02955845184624195, 0.030950026586651802, 0.007120619993656874, -0.04844224825501442, -0.023923739790916443, 0.05521523952484131, 0.004852033220231533, -0.014398912899196148,
    0.04465515539050102, -0.010946163907647133, -0.05348731577396393, -0.030804535374045372, -0.012735962867736816, -0.026356929913163185, -0.011297364719212055, 0.02292393334209919,
    0.05289464816451073, 0.026812516152858734, -0.036134518682956696, -0.005533657968044281, 0.0099655631929636, -0.0923914909362793, 0.08388974517583847, 0.036463893949985504,
    -0.04888434335589409, -0.03428878262639046, -0.04899798333644867, -0.033825282007455826, 0.014423870481550694, -0.03456687182188034, -0.03736972436308861, -0.09860767424106598,
    0.07453259825706482, -0.12213873863220215, -0.018716923892498016, -0.07410621643066406, -0.0073654744774103165, 0.07254578918218613, -0.007598136551678181, 0.06233523413538933,
    0.012923551723361015, 0.03919513523578644, -0.06802163273096085, 0.050514690577983856, 0.02431407757103443, -0.06601853668689728, 0.06803105026483536, 0.01277780532836914,
    -0.03759145736694336, -0.009046218357980251, -0.12087962031364441, -0.0378493070602417, 0.0055327387526631355, 0.005956120789051056, 0.13168521225452423, -0.022691193968057632,
    -0.01384799275547266, -0.011579387821257114, 0.0543333999812603, 0.08073285967111588, -0.027374565601348877, -0.05220327153801918, -0.027804745361208916, 0.038023244589567184,
    -0.04212971404194832, 0.022404717281460762, 0.04892772436141968, 0.0350988507270813, 0.01438386831432581, -0.008771318010985851, -0.06517703831195831, -0.04172225296497345,
    -0.0399894081056118, 0.028895175084471703, -0.017529014497995377, 0.002645106054842472, -0.01194179616868496, 0.05228475481271744, -0.0018462027655914426, 0.022180885076522827,
    0.05120238661766052, 0.04898104444146156, -0.02205650694668293, 0.017430270090699196, -0.06964494287967682, -0.07650892436504364, -0.0004762235621456057, 0.03146465867757797,
    0.068613201379776, 0.03672809898853302, -0.0033500385470688343, 0.0471317432820797, 0.09269465506076813, -0.03437681496143341, 0.0293093454092741, 0.04507584497332573,
    0.05851568654179573, 0.06779788434505463, 0.054580554366111755, 0.09152583032846451, -0.02551281452178955, 0.006305195391178131, 0.03904680907726288, -0.02307318150997162,
    -0.048045769333839417, -0.08913184702396393, 0.17404261231422424, -0.010855463333427906, 0.03016977198421955, -0.00014639981964137405, -0.005971033126115799, -0.03448304533958435,
    0.06512703001499176, 0.07788696140050888, -0.0026024323888123035, -0.05339638516306877, 0.04836259037256241, -0.031034113839268684, 0.05375951901078224, 0.06463904678821564,
    0.01416661124676466, -0.05588564649224281, 0.01286311261355877, -0.04920437932014465, 0.06900697201490402, 0.06646981835365295, -0.009846508502960205, -0.051946401596069336,
    0.06240412965416908, 0.0036870550829917192, -0.02281096950173378, -0.05418477579951286, 0.0524560809135437, -0.054896268993616104, 0.03266986459493637, -0.0583040788769722,
    -0.03243638947606087, 0.0754551962018013, 0.021830575540661812, 0.029427487403154373, -0.04565570503473282, 0.022437483072280884, -0.053635332733392715, 0.04409639164805412,
    0.0306877251714468, -0.038127727806568146, -0.025661220774054527, -0.06258486211299896, 0.027344804257154465, 0.025613712146878242, 0.1210566982626915, 0.07316466420888901,
    -0.019981633871793747, -0.03859623149037361, 0.0847751572728157, -0.004885106347501278, 0.006457891780883074, -0.0202331580221653, 0.04295123741030693, 0.019530337303876877,
    -0.014337707310914993, 0.10900919884443283, -0.012997646816074848, 0.02005247212946415, -0.06304822117090225, 0.028364090248942375, -0.02552221715450287, 0.007469880394637585,
    0.028070272877812386, -0.007543135900050402, 0.06162003427743912, 0.02250707894563675, -0.07002564519643784, -0.05822642520070076, -0.032146185636520386, 0.024938559159636497,
    0.053375449031591415, 0.02881672792136669, 0.017870720475912094, 0.0028616252820938826, 0.03007301315665245, 0.02127978578209877, 0.012631166726350784, 0.04861032962799072,
    0.08735930174589157, -0.10403703898191452, -0.03454186022281647, 0.07404031604528427, -0.0010764534818008542, 0.04460440203547478, -0.009228103794157505, -0.03248089179396629,
    0.029002832248806953, 0.03948714956641197, -0.034919705241918564, -0.029676565900444984, 0.017597122117877007, 0.049204543232917786, -0.06108332425355911, -0.02050594799220562,
    -0.01859496347606182, 0.043524112552404404, -0.003940454684197903, -0.03175940364599228, -0.04427441582083702, -0.05724451690912247, -0.0044295890256762505, 0.06323545426130295,
    -0.056338854134082794, 0.03806719183921814, -0.025219496339559555, 0.01584966666996479, -0.025419514626264572, -0.013827153481543064, 0.021801823750138283, -0.01357794925570488,
    0.03884967043995857, -0.0036706076934933662, 0.06700421869754791, 0.10811042785644531, -0.04248349368572235, 0.012727188877761364, -0.008169757202267647, -0.055318333208560944,
    0.05738712474703789, 0.06656049191951752, 0.02115962840616703, -0.006510024890303612, 0.06753408163785934, -0.011504354886710644, 0.022440021857619286, -0.006410844624042511,
    -0.03484365716576576, 0.07005053758621216, -0.06406959146261215, -0.00877450779080391, 0.04769375920295715, 0.07300083339214325, -0.03394510969519615, -0.0644310787320137,
    0.04846584051847458, -0.04852338135242462, 0.02379174903035164, -0.021130796521902084, 0.0005669009988196194, 0.04724762961268425, -0.015496481209993362, 0.027852827683091164,
    0.038687292486429214, -0.0003213741583749652, -0.024016957730054855, -0.04896337166428566, 0.01300899963825941, -0.1093289703130722, -0.030672846361994743, -0.023203086107969284,
    0.07019998133182526, 0.03729826956987381, -0.08361035585403442, 0.01536355447024107, -0.047264013439416885, 0.02434837818145752, -0.015006125904619694, 0.05034857615828514,
    -0.009732418693602085, 0.04381251707673073, -0.0007919829222373664, -0.007089610677212477, 0.03347206488251686, 0.0067669665440917015, -0.04840271547436714, 0.011774237267673016,
    0.012891603633761406, -0.036204490810632706, -0.021456124261021614, 0.043665315955877304, -0.012020997703075409, -0.07821381092071533, 0.038233738392591476, 0.0763186365365982,
    -0.0137034235522151, -0.04695601388812065, 0.02686184272170067, 0.007798240520060062, 0.03135285899043083, -0.012421615421772003, 0.01886756345629692, 0.06953121721744537,
    -0.059001002460718155, -0.010979325510561466, 0.02201247774064541, -0.058505818247795105, 0.048938311636447906, 0.09730497747659683, -0.03485434502363205, 0.03337664157152176,
    -0.061150211840867996, 0.0033941168803721666, -0.06227245554327965, 0.003247723914682865, -0.02793417125940323, -0.01355995237827301, 0.009443993680179119, 0.008479146286845207,
    0.09261868894100189, 0.022368602454662323, -0.00850985012948513, 0.08255977183580399, -0.006000468973070383, 0.018645619973540306, -0.05879977345466614, 0.025570355355739594,
    -0.002265781396999955, -0.07412833720445633, -0.05675344169139862, -0.03301379829645157, 0.0030712257139384747, -0.03377216309309006, 0.0628027692437172, 0.011594089679419994,
    -0.07827437669038773, -0.05610978603363037, 0.006517982576042414, -0.016039978712797165, -0.052864715456962585, 0.048548001796007156, -0.07050006836652756, 0.005463117267936468,
    0.024026719853281975, 0.03580629825592041, -0.013567877933382988, -0.05323424190282822, 0.06374378502368927, -0.0765133798122406, 0.026469631120562553, 0.021410146728157997,
    -0.022951828315854073, -0.08449666947126389, 0.04244720935821533, -0.01795470342040062, -0.05808734893798828, 0.06898968666791916, -0.021580247208476067, -0.02231251448392868,
    -0.021657107397913933, 0.03885563090443611, 0.05283411592245102, -0.00527693098410964, -0.05407281219959259, -0.029661238193511963, -0.0390082411468029, -0.015528964810073376,
    0.01531660184264183, 0.029434798285365105, -0.01568775624036789, -0.05319810286164284, 0.02982904389500618, -0.008322091773152351, 0.013886573724448681, 0.06620423495769501,
    0.03922316059470177, -0.018568988889455795, -0.03781114146113396, 0.027779439464211464, 0.06562066078186035, 0.03097868151962757, 0.05823756009340286, 0.0600547231733799,
    0.06274084001779556, -0.09359203279018402, 0.006734443362802267, -0.07547116279602051, -0.06886539608240128, -0.038952670991420746, 0.08713027834892273, 0.02287685126066208,
    -0.035621434450149536, -0.020642422139644623, 0.013340571895241737, 0.005235855933278799, 0.01621713861823082, 0.1294979453086853, 0.028527377173304558, 0.018841279670596123,
    -0.07477433979511261, 0.029190074652433395, -0.07546219974756241, -0.006417109631001949, -0.02818405069410801, 0.013300593011081219, 0.01606757752597332, 0.07658868283033371,
    -0.008454572409391403, 0.008590374141931534, -0.04811084643006325, -0.014620446600019932, 0.023000288754701614, -0.036877818405628204, -0.010041830129921436, 0.04601837322115898,
    0.031670525670051575, 0.0003175823367200792, -0.013321214355528355, 0.01456551905721426, 0.001616654102690518, 0.017453856766223907, 0.024553239345550537, -0.09340822696685791,
    0.030766000971198082, -0.10486778616905212, 0.028265222907066345, 0.023454928770661354, -0.013482734560966492, 0.023566899821162224, -0.0342990942299366, 0.008222955279052258,
    0.09834770113229752, -0.06583631783723831, 0.03595377504825592, 0.0936269536614418, 0.058398887515068054, 0.0280007254332304, -0.015554052777588367, 0.02199806645512581,
    0.028353802859783173, -0.045183371752500534, 0.029089054092764854, -0.0709073394536972, -0.03438761085271835, -0.017059698700904846, -0.046489350497722626, 0.0023573816288262606,
    0.07985919713973999, 0.024932801723480225, -0.07691998034715652, 0.004020045045763254, -0.0325356163084507, -0.031204944476485252, 0.03233722969889641, -0.05306881666183472,
    -0.00482493219897151, 0.04090798273682594, -0.014878750778734684, 0.008281247690320015, -0.00016201278776861727, 0.02854038029909134, 0.0027527231723070145, 0.02257860265672207,
    -0.06820891052484512, -0.0847598984837532, 0.022807111963629723, -0.014723652973771095, 0.02420545555651188, -0.052728574723005295, 0.0019373663235455751, 0.0060365772806108,
    0.02180023118853569, 0.044669777154922485, 0.0357075110077858, -0.03750444948673248, 0.12506335973739624, 0.002510370686650276, 0.00419851578772068, 0.039812907576560974,
    0.14074672758579254, 0.11658228933811188, -0.011008183471858501, -0.02671174332499504, 0.04067124053835869, -0.05509723722934723, 0.00672894436866045, -0.09550803154706955,
    -0.02081109583377838, 0.03214641660451889, 0.04633971303701401, -0.010087807662785053, 0.03610638156533241, 0.07765065878629684, -0.031463682651519775, 0.00796249695122242,
    0.014556282199919224, 0.0323304682970047, -0.0036358570214360952, 0.08902701735496521, -0.04229158163070679, 0.06180921196937561, 0.01651184819638729, -0.009094946086406708,
    0.02090202271938324, -0.04798722639679909, 0.04702706262469292, 0.04055723920464516, -0.07263027131557465, 0.0025647885631769896, -0.04753941670060158, 0.058309826999902725,
    0.1339510977268219, 0.02757178619503975, 0.0580475851893425, 0.018842924386262894, 0.11710254102945328, -0.018365120515227318, 0.06989304721355438, 0.04073110595345497,
    0.00040134473238140345, -0.08813513815402985, -0.0211824718862772, 0.03262793645262718, 0.047950491309165955, -0.025202644988894463, 0.05303208529949188, 0.03234991058707237,
    -0.06699574738740921, 0.027515333145856857, 0.0658109188079834, -0.004251932259649038, -0.04613524675369263, 0.03553654998540878, -0.006756816059350967, 0.0577869638800621,
    0.00287799839861691, 0.030562572181224823, 0.0034154262393712997, 0.01883961632847786, 0.0032082449179142714, -0.0817020833492279, 0.031643595546483994, -0.026187915354967117,
    -0.00198783609084785, 0.13125504553318024, -0.024904845282435417, 0.025202272459864616, 0.00562454154714942, -0.060873255133628845, -0.0056718485429883, -0.02057013101875782,
    -0.01626025140285492, -0.07762936502695084, -0.041508108377456665, 0.006419162731617689, 0.02615821547806263, -0.04774821922183037, -0.013269857503473759, -0.026404021307826042,
    -0.06028909981250763, 0.08189000934362411, -0.01645638421177864, 0.012030216865241528, 0.0366395078599453, -0.028186960145831108, 0.010681531392037868, 0.03172111511230469,
    0.06602372229099274, -0.047033149749040604, 0.057015400379896164, -0.05576031655073166, -0.04943695664405823, 0.006341204978525639, 0.10076108574867249, 0.03213255852460861,
    -0.04207707941532135, 0.015974191948771477, -0.0772557333111763, 0.0017339676851406693, -0.039575573056936264, -0.004671523813158274, 0.02484131045639515, 0.021107621490955353,
    0.022658221423625946, 0.12694692611694336, -0.026843668892979622, -0.004222914110869169, -0.025933701545000076, 0.03928513079881668, 0.029986536130309105, 0.04817467927932739,
    0.013020903803408146, -0.05674222484230995, 0.03183313459157944, 0.044625572860240936, 0.00013767908967565745, -0.028937892988324165, 0.012532130815088749, 0.015522572211921215,
    -0.005590390879660845, -0.00901783537119627, 0.00044730896479450166, 0.009706809185445309, 0.0621350035071373, 0.05731503665447235, 0.006722719874233007, 0.013836600817739964,
    -0.00033997997525148094, -0.07700064778327942, -0.06917331367731094, 0.0005326676182448864, 0.05314360186457634, -0.0300221536308527, 0.006627134047448635, -0.008681260980665684,
    -0.03212164714932442, -0.024911385029554367, -0.013022701255977154, -0.00032711116364225745, 0.0066033657640218735, -0.01213313639163971, 0.06273580342531204, 0.06332971900701523,
    -0.046331629157066345, 0.06828398257493973, 0.043816231191158295, 0.09873712062835693, -0.05409282073378563, 0.049255531281232834, 0.03501655533909798, 0.04905632883310318,
    -0.01861627772450447, 0.10042816400527954, 0.010574662126600742, 0.0399007685482502, -0.0641060620546341, -0.10727977752685547, -0.0556274838745594, -0.05429157614707947,
    0.017873652279376984, -0.02255184017121792, -0.034890756011009216, 0.014401381835341454, -0.06739556789398193, -0.04402690380811691, 0.03337682783603668, 0.013376973569393158,
    -0.028336133807897568, -0.04095588997006416, 0.03778790310025215, -0.0739300549030304, 0.018316565081477165, -0.07647275924682617, 0.02019990235567093, -0.02907923236489296,
    -0.01078606117516756, 0.039325881749391556, 0.0019262121059000492, -0.0069656576961278915, -0.020599238574504852, -0.020930761471390724, 0.011492383666336536, 0.025948496535420418,
    -0.02924741432070732, 0.05484316498041153, 0.015488597564399242, -0.005716456566005945, -0.016833564266562462, 0.004884803202003241, 0.03266616538167, 0.010991686023771763,
    -0.10602299124002457, -0.003203915199264884, 0.041000206023454666, -0.011034941300749779, 0.0034869471564888954, 0.016809986904263496, -0.029685132205486298, 0.005469967145472765,
    -0.048147499561309814, -0.0833612009882927, 0.03451951593160629, -0.015345276333391666, 0.0062563917599618435, -0.023393597453832626, -0.034380700439214706, 0.029456857591867447,
    -0.05096552148461342, -0.00477605639025569, 0.04574498534202576, -0.13008107244968414, 0.03017217293381691, 0.0306403748691082, -0.00035463765379972756, -0.01195701863616705,
    0.05069425329566002, 0.0036581370513886213, -0.10188191384077072, 0.08192329853773117, 0.01232701912522316, -0.049209728837013245, -0.02808460220694542, 0.05005165934562683,
    -0.14036500453948975, -0.03572031483054161, -0.05113007873296738, 0.04123080521821976, 0.05986234173178673, 0.013131107203662395, -0.01755957119166851, -0.03798576071858406,
    0.10079046338796616, 0.06502136588096619, -0.08714956790208817, -0.0361906960606575, -0.0217713862657547, -0.028589900583028793, 0.052822697907686234, -0.010859893634915352,
    0.02315153181552887, -0.11210762709379196, -0.09451208263635635, 0.04710138216614723, -0.05575808882713318, 0.10330839455127716, -0.0485687293112278, -0.011693130247294903,
    0.07292613387107849, 0.007510121911764145, -0.0021046726033091545, 0.07810619473457336, -0.16297370195388794, -0.0365850105881691, -0.030646754428744316, -0.02694973163306713,
    -0.08328963071107864, 0.010524490848183632, 0.1294456124305725, -0.05125347524881363, -0.02065996080636978, 0.0015962417237460613, -0.002296365797519684, -0.03556530550122261,
    -0.0007421812624670565, 0.009749453514814377, -0.07828428596258163, 0.06480491161346436, 0.02839668095111847, -0.02458825521171093, 0.04380493611097336, -0.01725265569984913,
    -0.07284056395292282, 0.09786543250083923, -0.056985050439834595, -0.07815967500209808, 0.012985103763639927, 0.07911859452724457, -0.0005455181817524135, 0.04099758341908455,
    0.005351930856704712, -0.11760453134775162, 0.04055406153202057, -0.02034725621342659, 0.05794735997915268, -0.03558548539876938, -0.07616882026195526, -0.007190430071204901,
    0.059268660843372345, -0.02641110308468342, 0.014265154488384724, -0.03194238618016243, -0.04381294921040535, -0.04769335687160492, 0.08028700202703476, 0.09651650488376617,
    0.0014672912657260895, 0.06871522963047028, 0.07065445184707642, -0.04090361297130585, -0.056976575404405594, 0.12938730418682098, 0.027584509924054146, 0.03195333853363991,
    0.044663362205028534, 0.017829030752182007, -0.007961621508002281, 0.012896242551505566, 0.017690414562821388, 0.05056009814143181, -0.01237792894244194, -0.06183529272675514,
    0.07772647589445114, 0.01934024505317211, 0.023275557905435562, 0.0037450562231242657, 0.0214359350502491, 0.022227361798286438, 0.05833810940384865, -0.08278538286685944,
    -0.007936392910778522, -0.11187877506017685, 0.06964991241693497, 0.012514437548816204, -0.022870035842061043, -0.020974066108465195, -0.01114576030522585, 0.005740088410675526,
    -0.02454531006515026, -0.02620941773056984, -0.020685987547039986, -0.02426844835281372, 0.023159755393862724, 0.05129791051149368, -0.05719909071922302, -0.07391119003295898,
    0.0720892995595932, 0.020302675664424896, 0.017950857058167458, -0.05966645106673241, -0.008261316455900669, 0.007401271723210812, -0.017379101365804672, -0.0333123505115509,
    -0.03839127719402313, -0.020063908770680428, 0.14385466277599335, 0.04652117192745209, 0.0760810449719429, 0.008228961378335953, 0.06037651374936104, 0.014663171954452991,
    -0.06124144047498703, -0.05099523067474365, -0.047802671790122986, 0.09693802148103714, -0.023881355300545692, 0.006754782050848007, -0.05927959457039833, -0.055769164115190506,
    0.03612538427114487, -0.086567223072052, -0.00024345632118638605, -0.0956728383898735, 0.0016120666405186057, 0.07944384217262268, 0.005906242411583662, 0.0160615723580122,
    0.011470318771898746, -0.049418844282627106, -0.0728825256228447, 0.005442394874989986, -0.04990103840827942, -0.02961806207895279, -0.013948159292340279, -0.03624645993113518,
    0.031635478138923645, 0.042492639273405075, -0.06086820363998413, 0.03313435614109039, -0.19155864417552948, -0.06466078013181686, -0.012170585803687572, 0.12068799138069153,
    0.08278548717498779, 0.06490447372198105, -0.01803760416805744, 0.024893950670957565, -0.017213070765137672, -0.09796765446662903, 0.06925370544195175, -0.01609337329864502,
    0.03737066313624382, 0.015778688713908195, -0.053912024945020676, -0.09576771408319473, -0.0005797334015369415, 0.015206008218228817, -0.036905158311128616, 0.03548713028430939,
    -0.05793967843055725, 0.019749321043491364, -0.07770679891109467, 0.09839868545532227, 0.04036032408475876, 0.07138210535049438, 0.0059527563862502575, 0.00599353201687336,
    0.03404495492577553, 0.05350769683718681, 0.019285207614302635, 0.010783413425087929, 0.054568760097026825, 0.09814036637544632, 0.023575302213430405, 0.029939547181129456,
    0.12100818753242493, -0.013159521855413914, -0.014286880381405354, 0.05629976838827133, 0.09508763253688812, -0.05679664760828018, 0.03584877774119377, 0.06535665690898895,
    -0.030415184795856476, 0.07398321479558945, -0.008683224208652973, -0.010821803472936153, -0.01132987067103386, -0.07270921021699905, 0.0151041429489851, 0.02928399294614792,
    -0.05221116915345192, 0.05011219158768654, 0.0016789943911135197, 0.012265878729522228, -0.03447992727160454, -0.033297017216682434, 0.008499979972839355, -0.07979191839694977,
    0.05910536274313927, 0.027245117351412773, -0.011947435326874256, 0.025715652853250504, 0.001997414045035839, 0.0026732413098216057, 0.0031795348040759563, 0.0165337435901165,
    0.022408057004213333, -0.09522577375173569, 0.0679425597190857, 0.010018124245107174, -0.0012472504749894142, -0.02297583594918251, -0.032081667333841324, 0.01596674509346485,
    0.005075513385236263, -0.039037834852933884, -0.037934303283691406, -0.021067742258310318, 0.029025541618466377, -0.1577911525964737, -0.02416256256401539, -0.11615893989801407,
    -0.05298011377453804, 0.060083430260419846, 0.06637445092201233, 0.06606642156839371, -0.028366677463054657, -0.013277191668748856, 0.016499806195497513, -0.014780941419303417,
    -0.032901581376791, 0.015793856233358383, -0.15344828367233276, 0.09254761785268784, -0.03250972554087639, 0.013717185705900192, 0.0669972151517868, 0.0011370297288522124,
    0.10988124459981918, -0.05495757982134819, -0.02963666059076786, -0.0030941120348870754, -0.01640160009264946, 0.018472064286470413, -0.030926693230867386, -0.0454154908657074,
    0.04425546154379845, -0.11590777337551117, 0.012639347463846207, -0.002902028849348426, -0.05278830975294113, 0.032331518828868866, 0.0039039652328938246, -0.01354303676635027,
    0.015937447547912598, 0.0020357221364974976, 0.1938149780035019, -0.008782671764492989, -0.0006887298077344894, -0.029967963695526123, 0.03579355776309967, 0.039561640471220016,
    -0.04610450938344002, 0.013357214629650116, -0.024884795770049095, -0.025923319160938263, -0.021703846752643585, 0.017340216785669327, -0.02379571460187435, 0.06309361010789871,
    -0.033820848912000656, -0.1231861263513565, -0.08823896199464798, -0.010467076674103737, 0.022552387788891792, 0.01008179597556591, 0.01115190889686346, -0.03467242419719696,
    -0.014458037912845612, -0.004448094870895147, -0.056772634387016296, -0.043419741094112396, -0.033909812569618225, -0.05901166424155235, -0.014619460329413414, -0.03383846580982208,
    -0.10691703110933304, 0.03848354145884514, 0.0193418450653553, 0.044444940984249115, 0.04489662125706673, 0.03509491682052612, 0.00648176996037364, 0.027417629957199097,
    0.006208278238773346, 0.05600098520517349, 0.018836984410881996, -0.03339129313826561, -0.019670449197292328, 0.04939147084951401, 0.0586298406124115, -0.035839762538671494,
    -0.025655081495642662, -0.027103612199425697, 0.019208019599318504, 0.04078247770667076, -0.09554452449083328, -0.00016038316243793815, 0.03709303215146065, -0.012868562713265419,
    -0.034228939563035965, -0.04840349778532982, -0.012221523560583591, -0.002090895315632224, 0.043835509568452835, 0.02391146868467331, 0.039655014872550964, 0.01903875544667244,
    -0.10514233261346817, 0.03576158732175827, -0.0024520859587937593, -0.03561463579535484, 0.008476510643959045, -0.02048756554722786, -0.04063526540994644, -0.06414242088794708,
    0.057457540184259415, 0.11979782581329346, -0.006454739253968, 0.02800094708800316, -0.01290977094322443, 0.009844466112554073, 0.02085958421230316, 0.05060941353440285,
    0.06058824807405472, 0.0755852609872818, -0.000315479701384902, -0.01069459319114685, 0.014332666993141174, 0.003769494825974107, 0.08723408728837967, -0.026159195229411125,
    0.042655956000089645, -0.05809921398758888, -0.04257501661777496, -0.02540784887969494, -0.0019142875680699944, 0.1163632720708847, -0.05052436143159866, 0.08196137845516205,
    -0.047158364206552505, -0.1195177286863327, 0.019155938178300858, 0.056514959782361984, 0.0071837445721030235, 0.04418021813035011, 0.05611085146665573, 0.04060206562280655,
    0.0595066174864769, 0.04313771426677704, 0.1671702116727829, 0.14770212769508362, -0.07442881166934967, -0.0018760388484224677, 0.11246109753847122, 0.006094827316701412,
    0.2164386808872223, 0.002941095270216465, 0.035227809101343155, -0.027038712054491043, 0.06774500757455826, 0.02706373669207096, 0.029874132946133614, -0.01176306139677763,
    -0.02956274151802063, -0.04567447677254677, -0.03369470313191414, -0.01062059123069048, -0.016367115080356598, 0.06459613889455795, 0.05270760878920555, -0.023455394431948662,
    0.026312610134482384, -0.025055259466171265, 0.08534267544746399, 0.0022622121032327414, 0.013629788532853127, 0.07080402225255966, -0.025688836351037025, 0.0035279749426990747,
    -0.04427967965602875, -0.00839476753026247, -0.01556302048265934, -0.03638165444135666, 0.16287709772586823, 0.025021307170391083, 0.016807543113827705, -0.0635165274143219,
    -0.07836738973855972, 0.16813687980175018, 0.09012210369110107, -0.036091577261686325, 0.07886681705713272, 0.04992321878671646, 0.023324280977249146, 0.008065133355557919,
    -0.016695844009518623, 0.035150930285453796, -0.0024303134996443987, -0.018130440264940262, -0.004618071019649506, 0.029639767482876778, -0.008010415360331535, -0.05180514603853226,
    0.024514731019735336, 0.019946809858083725, 0.022053848952054977, -0.12390580773353577, -0.0018115679267793894, 0.008095812052488327, 0.05452923849225044, 0.0006114265415817499,
    -0.06386560201644897, -0.10895579308271408, 0.08025556057691574, -0.003417034400627017, 0.025083759799599648, 0.062204811722040176, -0.012289537116885185, -0.09291977435350418,
    -0.08497443050146103, -0.010764220729470253, 0.04759282246232033, 0.0016741517465561628, 0.04484713450074196, -0.008765371516346931, -0.012793226167559624, -0.024114904925227165,
    0.03593197837471962, -0.12661828100681305, 0.007394381333142519, -0.005554622504860163, 0.002861575223505497, -0.058175258338451385, 0.06514240056276321, -0.005681260954588652,
    0.05142368748784065, -0.07221587002277374, 0.0322992168366909, -0.005519338417798281, 0.03027419000864029, 0.024892956018447876, -0.005729338154196739, 0.0787413939833641,
    -0.017446046695113182, 0.029021557420492172, 0.0050423638895154, 0.038770463317632675, 0.031738851219415665, 0.0029228872153908014, -0.041211050003767014, 0.04490780457854271,
    0.008710215799510479, 0.17501769959926605, -0.014105982147157192, 0.012509768828749657, -0.008074760437011719, -0.01767219416797161, 0.029290420934557915, 0.04351520165801048,
    -0.00583525188267231, 0.013977555558085442, 0.049029652029275894, 0.031061692163348198, 0.017069686204195023, -0.08208055049180984, -0.019147660583257675, 0.03478037565946579,
    0.11504961550235748, 0.10407643765211105, 0.07517608255147934, -0.036013614386320114, 0.0017372441943734884, -0.0035605437587946653, 0.04720845818519592, 0.03360859677195549,
    0.04984922334551811, -0.03140074387192726, -0.1400076448917389, 0.100682333111763, -0.0753033235669136, 0.028921611607074738, 0.05442684888839722, 0.021113835275173187,
    0.032521698623895645, -0.0003625329118221998, -0.07355131953954697, 0.05472492054104805, 0.11040797829627991, -0.017249371856451035, -0.07994314283132553, 0.003027313621714711,
    -0.11571116745471954, 0.09293728321790695, 0.04498045891523361, 0.10166336596012115, -0.002987255109474063, 0.03906926140189171, -0.029502175748348236, -0.00584412319585681,
    -0.0449681356549263, 0.018753694370388985, -0.1759539246559143, 0.01393992081284523, -0.10239758342504501, -0.02816770412027836, -0.008836477063596249, -0.0192052461206913,
    0.007546551525592804, 0.03809210658073425, 0.01803475245833397, -0.008647889830172062, 0.11765795201063156, -0.07133469730615616, 0.033450424671173096, -0.06071736663579941,
    0.09591632336378098, -0.12563851475715637, 0.02071409672498703, 0.005261497106403112, -0.015237224288284779, -0.02403545379638672, 0.07356817275285721, -0.09556885063648224,
    -0.0027024168521165848, -0.023697465658187866, 0.02387065626680851, -0.06004985049366951, -0.04641897603869438, 0.04004061594605446, 0.02427505888044834, -0.03968924283981323,
    0.0038609420880675316, 0.05949344113469124, 0.002834317507222295, 0.0674188956618309, 0.037023745477199554, 0.03721189126372337, 0.07916873693466187, -0.006599410902708769,
    -0.07519262284040451, 0.08763779699802399, 0.034693557769060135, -0.027330679818987846, 0.059194415807724, -0.005055792164057493, -0.018681511282920837, 0.03548648953437805,
    -0.13841098546981812, -0.04081089794635773, -0.013480066321790218, 0.05196934565901756, 0.024066103622317314, 0.010612008161842823, -0.00020189541100990027, 0.06922806054353714,
    0.0033434368669986725, -0.009183214977383614, 0.06114385277032852, -0.048200298100709915, -0.0008563633309677243, -0.02653101645410061, 0.030471818521618843, 0.035443272441625595,
    0.032680951058864594, 0.03813934326171875, -0.014183980412781239, -0.012707497924566269, -0.002123507671058178, -0.022942539304494858, -0.03547045588493347, 0.05612606182694435,
    0.03361878916621208, 0.002910003764554858, -0.02845722809433937, -0.02844393625855446, 0.0008137872791849077, 0.05239839106798172, -0.05646898224949837, 0.12523984909057617,
    0.10380538552999496, 0.04080365225672722, 0.121500663459301, -0.07248827815055847, -0.007897657342255116, -0.0053023784421384335, -0.007168585900217295, 0.06366750597953796,
    0.009283625520765781, -0.013723375275731087, -0.01694953627884388, 0.03931406885385513, 0.02076522633433342, -0.07238815724849701, -0.037699244916439056, 0.04443755000829697,
    -0.13110214471817017, -0.07380953431129456, 0.0526980459690094, 0.07865037024021149, -0.011844553984701633, -0.016958946362137794, 0.010533072985708714, 0.026668356731534004,
    0.043500158935785294, -0.012726236134767532, 0.0870877355337143, 0.07017984241247177, -0.0019193171756342053, -0.008861584588885307, -0.009505356661975384, 0.023892125114798546,
    -0.16217315196990967, 0.03379285708069801, -0.06569414585828781, 0.01451990008354187, 0.02681092359125614, -0.02913922257721424, -0.04019278287887573, 0.01790144480764866,
    -0.014923082664608955, 0.14788228273391724, 0.03028322197496891, 0.046682700514793396, -0.04474944248795509, 0.01658575050532818, 0.004440625198185444, 0.035213369876146317,
    -0.04453974589705467, -0.07231949269771576, -0.10590236634016037, 0.028917567804455757, 0.04502664506435394, -0.0811760425567627, 0.04249146580696106, 0.005379395093768835,
    -0.050252437591552734, 0.009819400496780872, -0.02178359404206276, 0.0644301176071167, -0.08448042720556259, -0.07529327273368835, 0.010945380665361881, 0.02769261784851551,
    0.050874583423137665, 0.06684616953134537, -0.016411500051617622, -0.035322174429893494, -0.02809915319085121, -0.0024718742351979017, 0.06361415237188339, -0.07056856900453568,
    0.035313431173563004, 0.010011077858507633, -0.005367750767618418, 0.002469712868332863, 0.025464344769716263, 0.08356897532939911, 0.014939368702471256, 0.030887849628925323,
    -0.05712217092514038, 0.009638034738600254, 0.014847749844193459, -0.00022924276709090918, 0.049289897084236145, -0.03829742968082428, 0.04107562452554703, 0.00915679894387722,
    -0.02590072900056839, -0.05128718540072441, -0.00025260611437261105, -0.01008665096014738, -0.021900471299886703, -0.040835410356521606, -0.016116110607981682, 0.0721123218536377,
    -0.08117150515317917, 0.048301126807928085, -0.030207697302103043, 0.021877389401197433, -0.09265675395727158, -0.08783379942178726, 0.026054594665765762, 0.10546401143074036,
    -0.0073187085799872875, -0.05993489921092987, 0.057638343423604965, -0.0680098906159401, 0.03847722336649895, 0.010919792577624321, -0.001331230509094894, 0.022899866104125977,
    0.06395787745714188, 0.03063572570681572, -0.056152503937482834, 0.03708473592996597, -0.021614430472254753, -0.03355970233678818, -0.016198476776480675, 0.02064879611134529,
    0.05309857055544853, 0.04557804390788078, 0.08193373680114746, 0.015413262881338596, 0.009349159896373749, 0.009558925405144691, -0.0031957076862454414, 0.018490802496671677,
    0.05423804745078087, -0.09077978879213333, 0.10618573427200317, -0.014423942193388939, 0.025891825556755066, 0.014096379280090332, 0.046500109136104584, 0.021945061162114143,
    0.010084002278745174, 0.001911908620968461, 0.02463803067803383, -0.004525400698184967, -0.026007046923041344, 0.05681508406996727, 0.022943250834941864, -0.029031231999397278,
    0.018129967153072357, 0.012084110639989376, 0.03837128356099129, 0.06558801233768463, 0.02324787713587284, -0.09485580772161484, 0.08920904248952866, 0.045419514179229736,
    0.07474759966135025, -0.01975712552666664, -0.03439880535006523, -0.013219260610640049, 0.03412393853068352, 0.01063433475792408, 0.045966099947690964, 0.023993339389562607,
    -0.21799981594085693, -0.02690691314637661, -0.045789800584316254, -0.04983028024435043, -0.013046027161180973, 0.03635115548968315, -0.055498648434877396, -0.08507835865020752,
    0.0018172230338677764, 0.07165683060884476, -0.03402198851108551, 0.03920510411262512, -0.02906043827533722, -0.0238955020904541, 0.06283269822597504, -0.005140373017638922,
    -0.01929672807455063, 0.03333045169711113, 0.25119999051094055, -0.00257630436681211, -0.009782584384083748, 0.11945868283510208, -0.021175753325223923, -0.009553438983857632,
    -0.04688682779669762, -0.02616117149591446, -0.06172081455588341, 0.04139498993754387, -0.10461331903934479, 0.06790047883987427, -0.04529259353876114, -0.011264491826295853,
    -0.11896536499261856, 0.029487665742635727, 0.0068701389245688915, -0.03475537151098251, -0.005933829117566347, 0.052697062492370605, 0.11048253625631332, 0.0012562675401568413,
    -0.04391173645853996, 0.04269352927803993, -0.016525356099009514, 0.05520482361316681, -0.04042147099971771, 0.07485742121934891, 0.011989347636699677, -0.07628988474607468,
    -0.09999492764472961, -0.016534337773919106, -0.007369077764451504, -0.1564069539308548, 0.032112620770931244, -0.016411807388067245, 0.06063268706202507, 0.05380836874246597,
    -0.04477575793862343, -0.012535154819488525, 0.08952473849058151, -0.007295386865735054, -0.07490986585617065, -0.003587516024708748, 0.010561360977590084, -0.13235928118228912,
    -0.12088575959205627, 0.02705729939043522, 0.01316121593117714, -0.0212915800511837, 0.11893311142921448, -0.09893838316202164, 0.028472023084759712, 0.019500305876135826,
    0.005063175689429045, -0.05737421289086342, -0.0857863575220108, -0.04084410145878792, 0.05793721228837967, -0.05570421740412712, 0.01959608867764473, 0.04106926918029785,
    -0.0015976987779140472, 0.05270383134484291, -0.03145971521735191, -0.023554163053631783, -0.05642715096473694, -0.04695949703454971, 0.034879688173532486, 0.07795925438404083,
    -0.005477671977132559, 0.0353749543428421, 0.05459040403366089, -0.020415887236595154, 0.011036456562578678, 0.0007768960203975439, 0.005034028552472591, -0.01048928964883089,
    -0.034218672662973404, -0.14469176530838013, 0.007245282176882029, -0.030276594683527946, 0.01061499584466219, 0.04043063148856163, 0.02826213836669922, -0.03612769767642021,
    -0.014391551725566387, -0.04526563361287117, 0.03532996028661728, -0.008289326913654804, 0.016517017036676407, -0.09028874337673187, -0.03014100342988968, -0.1194489598274231,
    0.1512407660484314, 0.0656183660030365, 0.039210282266139984, -0.006478011142462492, -0.03395732864737511, 0.05582944676280022, 0.005953117273747921, -0.01881294697523117,
    0.10890668630599976, -0.007798417471349239, -0.005809187423437834, -0.00792743917554617, -0.024127233773469925, 0.010008465498685837, 1.0837587751666433e-06, -0.04249564930796623,
    0.06197764724493027, -0.0312882699072361, -0.0038558365777134895, 0.0005901639815419912, -0.0747818872332573, -0.00614125607535243, 0.0639045313000679, -0.06926268339157104,
    0.007681265007704496, -0.10733485966920853, -0.05427336320281029, 0.00471858587116003, -0.037259019911289215, -0.02578023634850979, 0.025269055739045143, -0.011844377964735031,
    -0.03186506778001785, -0.07847775518894196, 0.13283675909042358, 0.03355519846081734, 0.06645578145980835, -0.04816799610853195, 0.03789767995476723, 0.05487837642431259,
    -0.007741075474768877, -0.020803984254598618, 0.03125959262251854, -0.08274546265602112, -0.048191580921411514, -0.22124096751213074, 0.04276592284440994, 0.02914467267692089,
    -0.021082092076539993, -0.06458206474781036, -0.012025163508951664, -0.05820927396416664, 0.025079654529690742, -0.012083838693797588, 0.04918535053730011, 0.07201609015464783,
    -0.011244413442909718, 0.03169305622577667, 0.03569813445210457, 0.07868362218141556, -0.13861338794231415, 0.03328096494078636, 0.013828972354531288, -0.09179122000932693,
    -0.028551828116178513, 0.03417767956852913, -0.11444374918937683, 0.13346317410469055, -0.09527784585952759, 0.050491999834775925, -0.04244808852672577, 0.03983425721526146,
    -0.06258389353752136, 0.08210522681474686, 0.07563428580760956, -0.04073890671133995, 0.06781552731990814, 0.03863091394305229, 0.04220778867602348, -0.021932218223810196,
    -0.032384082674980164, -0.0340733677148819, 0.013744296506047249, -0.039938755333423615, -0.019417624920606613, -0.04466930031776428, -0.014720951206982136, 0.03774720057845116,
    0.0077001131139695644, -0.016716938465833664, 0.03099946491420269, -0.027106065303087234, -0.02956557646393776, 0.09619935601949692, 0.03127611055970192, 0.0028772528748959303,
    0.025475360453128815, 0.045720867812633514, -0.0976884514093399, 0.014043946750462055, 0.016741065308451653, 0.09850867837667465, 0.037923529744148254, -0.005411888938397169,
    -0.03961959853768349, -0.012953625060617924, 0.13101089000701904, 0.004254505038261414, 0.002664219820871949, -0.028829500079154968, 0.001494041527621448, 0.07333295047283173,
    -0.09800597280263901, -0.046868059784173965, -0.05122160166501999, -0.03770006075501442, -0.025950543582439423, -0.04045947268605232, 0.09250914305448532, -0.026148537173867226,
    0.030635563656687737, 0.07268883287906647, -0.06452160328626633, -0.02919694036245346, 0.038666531443595886, -0.02466389536857605, 0.02025945857167244, 0.011826871894299984,
    -0.164972186088562, -0.13076800107955933, 0.054791003465652466, -0.040971070528030396, 0.0593806691467762, 0.04742453619837761, -0.017589254304766655, -0.03511453792452812,
    0.058602239936590195, 0.01688546873629093, 0.06947844475507736, 0.1585286557674408, 0.004261469468474388, -0.06323525309562683, 0.08822441846132278, 0.012354793027043343,
    0.22723621129989624, -0.02619408629834652, -0.008341066539287567, -0.05407317355275154, 0.02351451851427555, 0.0028103890363126993, 0.10999241471290588, 0.006524374708533287,
    -0.02526365965604782, -0.125839963555336, -0.029202887788414955, 0.01293251197785139, 0.010159684345126152, -0.029243431985378265, 0.026744216680526733, -0.005070478655397892,
    0.009391252882778645, 0.02902097813785076, -0.2419268935918808, 0.06961406022310257, -0.0334441252052784, -0.018935127183794975, 0.021932551637291908, -0.0037469100207090378,
    -0.0035085370764136314, 0.018791116774082184, 0.11913137882947922, -0.04249143600463867, 0.004194779321551323, 0.06394051015377045, 0.06802700459957123, 0.04560314118862152,
    0.14455316960811615, 0.010462078265845776, -0.04903366416692734, 0.02599022164940834, 0.001998626161366701, 0.09840226173400879, -0.033292610198259354, 0.029743652790784836,
    0.01787721738219261, -0.013239113613963127, 0.05379384011030197, 0.04914930462837219, -0.09203162044286728, -0.004395114257931709, -0.012342975474894047, -0.06143207848072052,
    0.00795206893235445, -0.025385024026036263, 0.002038168255239725, 0.05891088768839836, -0.026002345606684685, 0.09208466112613678, 0.015040108002722263, 0.040471334010362625,
    -0.06660470366477966, -0.040353789925575256, 0.15797297656536102, -0.001859892625361681, 0.06774207204580307, 0.12320021539926529, 0.02171347290277481, 0.1252181977033615,
    0.033152658492326736, -0.0707712471485138, 0.07616333663463593, -0.04046870768070221, -0.044283490628004074, 0.05672413855791092, -0.004010716453194618, 0.059115856885910034,
    -0.02431885339319706, 0.024979226291179657, 0.09561567008495331, -0.0012985302601009607, -0.015902096405625343, 0.027906430885195732, 0.056636564433574677, 0.02626529335975647,
    0.0274165291339159, 0.06653120368719101, -0.10036774724721909, 0.045560333877801895, 0.046994246542453766, -0.07998546957969666, 0.007760780863463879, -0.05997517332434654,
    0.051121849566698074, 0.0536334291100502, 0.03120422177016735, 0.02324332855641842, 0.006732169073075056, -0.0043345182202756405, -0.08622109144926071, 0.06657999008893967,
    -0.09578792005777359, 0.13444754481315613, -0.019486157223582268, 0.040797751396894455, 0.04390857368707657, 0.04215672239661217, -0.056494589895009995, 0.017547711730003357,
    -0.03970562294125557, -0.02565012127161026, -0.06550689786672592, -0.00906996801495552, 0.004452087450772524, 0.12643815577030182, 0.033738311380147934, -0.11025770008563995,
    0.07094809412956238, 0.11277718096971512, 0.0053753238171339035, 0.0034812705125659704, 0.06876866519451141, 0.07614294439554214, -0.04400308430194855, -0.0625399649143219,
    -0.057913243770599365, 0.016236137598752975, -0.037121083587408066, 0.08984802663326263, 0.05585411190986633, -0.05355393514037132, 0.02923172526061535, -0.03696872666478157,
    0.10805732756853104, -0.05081864446401596, 0.017567569389939308, 0.027744915336370468, 0.006050101015716791, -0.08982722461223602, 0.2134937345981598, -0.005844009108841419,
    0.03716929629445076, 0.0161484032869339, -0.01709561049938202, -0.09041472524404526, 0.006421282887458801, 0.021501852199435234, -0.04633732885122299, -0.05929255113005638,
    0.032957807183265686, 0.031712427735328674, -0.06141495704650879, 0.011698592454195023, -0.06229892745614052, 0.11124368011951447, 0.04657069593667984, 0.1044764369726181,
    0.04474259912967682, -0.0010684727458283305, 0.07612410187721252, -0.010473091155290604, 0.011824319139122963, -0.012001972645521164, -0.0015860041603446007, 0.014224832877516747,
    -0.06364314258098602, -0.01132788322865963, 0.016116270795464516, 0.15665742754936218, -0.012565567158162594, 0.1326168328523636, -0.016425620764493942, 0.0453074611723423,
    -0.06791031360626221, -0.010202043689787388, 0.09897733479738235, -0.04385547712445259, -0.029995447024703026, -0.02913915365934372, 0.01964656449854374, 0.05205044895410538,
    -0.08681251853704453, 0.05889139324426651, 0.06267469376325607, -0.07249540835618973, 0.00856146588921547, 0.007220264058560133, -0.0375681146979332, -0.035711877048015594,
    -0.05292513221502304, -0.014960264787077904, 0.14930808544158936, -0.008857394568622112, -0.014535171911120415, 0.07148370146751404, -0.14218679070472717, -0.01635797880589962,
    -0.03935150057077408, -0.07704120874404907, -0.023429719731211662, -0.04495130851864815, 0.03790353983640671, 0.09328558295965195, -0.018746640533208847, 0.08537374436855316,
    -0.04469924420118332, -0.06195099651813507, 0.05613509193062782, -0.021800855174660683, 0.02613830380141735, -0.10390257090330124, 0.05527363717556, -0.005676885601133108,
    -0.04770665988326073, 0.13270390033721924, -0.010330146178603172, -0.023927608504891396, -0.0016735963290557265, -0.05802299082279205, -0.002105350373312831, 0.0820344015955925,
    0.05555601418018341, 0.05610755831003189, -0.05689524859189987, -0.0022202928084880114, -0.0358755886554718, 0.12269573658704758, -0.06505663692951202, -0.01208366546779871,
    0.021906428039073944, 0.12819163501262665, -0.034316133707761765, 0.05961214005947113, -0.02194920741021633, -0.12736502289772034, -0.04718650132417679, -0.05997753143310547,
    0.05103493109345436, -0.008399665355682373, 0.01864030957221985, -0.013166417367756367, -0.025015924125909805, -0.1170707419514656, 0.005173387937247753, 0.018682369962334633,
    0.07813509553670883, -0.030123652890324593, 0.036718446761369705, 0.13267257809638977, 0.054003626108169556, -0.007466964423656464, 0.09876856207847595, -0.07091014087200165,
    0.09962861984968185, -0.0215996615588665, 0.09246256947517395, 0.11467961966991425, -0.006176712457090616, -0.022972650825977325, 0.009089508093893528, 0.06648711115121841,
    -0.08311649411916733, -0.08515357226133347, -0.013027284294366837, -0.022687263786792755, 0.05944284051656723, -0.034559424966573715, 0.048939771950244904, -0.019288446754217148,
    -0.0616738423705101, 0.029745792970061302, 0.0002945056767202914, -0.026941830292344093, 0.0018445285968482494, -0.02136066183447838, 0.01586286351084709, -0.008161727339029312,
    0.042414870113134384, -0.019719813019037247, 0.1847657859325409, -0.04290666803717613, -0.03816496580839157, -0.01911061257123947, 0.07910460978746414, 0.12335740029811859,
    0.009599575772881508, -0.01623663119971752, 0.039060067385435104, 0.08764784038066864, 0.02996407262980938, -0.17462238669395447, 0.04526975005865097, -0.0043626208789646626,
    -0.04908435419201851, 0.014163647778332233, -0.0004459555493667722, 0.05122944712638855, 0.03655946999788284, 0.08002563565969467, -0.01749054715037346, 0.06153741478919983,
    0.011916319839656353, -0.002829210599884391, 0.03496900945901871, 0.017727704718708992, 0.00920377392321825, 0.003933395259082317, -0.04455449432134628, 0.07620833814144135,
    0.03273450955748558, -0.009087631478905678, 0.09326865524053574, 0.0750819519162178, 0.02117546834051609, 0.035894762724637985, 0.0749652311205864, -0.03493616357445717,
    -0.01438483502715826, 0.016035595908761024, 0.11504291743040085, 0.012149255722761154, -0.06445064395666122, -0.04338844120502472, 0.061508357524871826, -0.045750416815280914,
    -0.03579355776309967, -0.07513036578893661, 0.09898584336042404, 0.034941140562295914, -0.00696229562163353, -0.00658946018666029, 0.04888312518596649, 0.12031146138906479,
    0.034477654844522476, -0.007346439640969038, 0.03830007463693619, 0.06822516024112701, -0.014043006114661694, 0.21205753087997437, 0.007923448458313942, -0.012634500861167908,
    -0.0420578196644783, 0.010427461937069893, -0.007345393765717745, -0.01808748207986355, -0.009054644964635372, -0.00280738458968699, 0.025992093607783318, 0.0008076047524809837,
    0.09536373615264893, 0.0329185426235199, -0.10858290642499924, 0.010831869207322598, 0.04818437620997429, -0.01730155572295189, 0.09017318487167358, -0.054983217269182205,
    -0.021741241216659546, -0.055504210293293, 0.0590696856379509, 0.018371904268860817, 0.021527670323848724, 0.13740234076976776, -0.03957328200340271, -0.0012453485978767276,
    0.009248831309378147, -0.10169754177331924, -0.05101805180311203, 0.05924439802765846, 0.03287617862224579, 0.06000863015651703, 0.04114842414855957, 0.033254511654376984,
    -0.10976134985685349, -0.17128734290599823, 0.1333504468202591, -0.10630405694246292, -0.03541082143783569, -0.10369322448968887, 0.037230852991342545, -0.005184454843401909,
    -0.07047349214553833, 0.007860799320042133, -0.06615480035543442, -0.08162848651409149, 0.009402970783412457, 0.026948167011141777, 0.015248789452016354, 0.00979501474648714,
    -0.15543921291828156, -0.030803577974438667, -0.07582198083400726, -0.0037811645306646824, 0.09268305450677872, 0.06992604583501816, -0.025929953902959824, 0.05457466095685959,
    -0.11472883075475693, -0.03227381408214569, 0.05516941472887993, -0.03200162947177887, -0.007248288486152887, -0.041574884206056595, -0.05934182181954384, 0.045691508799791336,
    0.10121775418519974, -0.07267837971448898, 0.035261787474155426, -0.056177522987127304, -0.0434555746614933, -0.04113587364554405, 0.056147027760744095, 0.008583183400332928,
    0.02974923886358738, -0.023960622027516365, -0.0251962561160326, 0.09281955659389496, -0.044436804950237274, 0.18564006686210632, 0.10071457177400589, 0.01144879125058651,
    0.14888755977153778, 0.058337461203336716, -0.026347696781158447, 0.02483072131872177, -0.02256939560174942, -0.10007072985172272, -0.044437225908041, 0.08813069015741348,
    0.0061805834993720055, 0.015415158122777939, 0.017705153673887253, -0.09721873700618744, -0.020482823252677917, -0.09384031593799591, -0.03333396464586258, -0.07452215999364853,
    0.09808868169784546, -0.015415764413774014, 0.050640977919101715, 0.07851549983024597, 0.06714079529047012, 0.050347283482551575, 0.15267981588840485, -0.04025619477033615,
    -0.02753911167383194, -0.07263873517513275, 0.042051829397678375, -0.0875607579946518, 0.07801525294780731, 0.030880551785230637, -0.038821183145046234, -0.017237327992916107,
    -0.057054851204156876, -0.016403667628765106, -0.06195881590247154, 0.06011565402150154, -0.07087165862321854, -0.02987339347600937, 0.015600206330418587, 0.025275370106101036,
    -0.04617670178413391, 0.020212572067975998, -0.13693377375602722, 0.01938992366194725, -0.03715302050113678, -0.11091940104961395, 0.05171767249703407, -0.020974405109882355,
    0.09597046673297882, -0.006950967945158482, -0.01134855579584837, 0.003449804149568081, -0.0695813000202179, -0.056666865944862366, 0.007095223292708397, 0.05812298506498337,
    -0.09447018802165985, 0.050359342247247696, 0.05701688677072525, 0.09008318185806274, 0.0037978645414114, -0.12618452310562134, 0.12448835372924805, 0.04261055961251259,
    0.19008119404315948, -0.06579198688268661, -0.07552484422922134, -0.0596071220934391, 0.01201596949249506, -0.11404459923505783, -0.04161103442311287, 0.01712161675095558,
    0.009115790948271751, -0.07119603455066681, 0.00987023115158081, 0.025463417172431946, 0.0225349273532629, 0.058310315012931824, -0.0004931628354825079, -0.001047226833179593,
    0.02012924663722515, 0.23186872899532318, 0.08120320737361908, -0.22116391360759735, -0.06119220331311226, -0.05059871822595596, 0.009378707036376, -0.03289619833230972,
    0.01472964696586132, 0.003939504269510508, 0.0934211015701294, 0.017627015709877014, -0.013735665939748287, 0.09590701758861542, -0.02566121146082878, -0.06423662602901459,
    -0.03951016068458557, -0.09350831806659698, -0.10174532234668732, 0.1153588742017746, -0.02965828962624073, -0.010538197122514248, 0.06570464372634888, 0.0013455094303935766,
    -0.029998375102877617, 0.009881177917122841, 0.006690664682537317, 0.03174665942788124, 0.03968195244669914, -0.0029834576416760683, -0.02248881570994854, 0.029238194227218628,
    0.06687217205762863, -0.06261348724365234, -0.24894943833351135, -0.0030188586097210646, 0.058739323168992996, 0.05959000065922737, 0.08273819088935852, -0.12408490478992462,
    0.030535291880369186, -0.007591955829411745, -0.07994884997606277, 0.18330034613609314, 0.015558137558400631, -0.187776118516922, -0.031977761536836624, 0.014966231770813465,
    -0.09026119112968445, -0.016701430082321167, 0.022586200386285782, 0.0018141970504075289, -0.007931132800877094, -0.10217656195163727, 0.05182277038693428, 0.07993259280920029,
    0.01404622383415699, -0.002609558869153261, 0.038341619074344635, 0.13164736330509186, -0.0035681044682860374, 0.023631611838936806, -0.03071434050798416, -0.06833861768245697,
    0.16789144277572632, 0.04486440494656563, 0.021713795140385628, -0.10306431353092194, -0.06524863839149475, 0.16359290480613708, 0.04847485199570656, -0.006344422698020935,
    0.053218401968479156, 0.10777080059051514, 0.04752199351787567, -0.053314462304115295, 0.04090803861618042, -0.02767273038625717, 0.02251376584172249, 0.031192252412438393,
    -0.1616179347038269, 0.0641382709145546, -0.048437077552080154, 0.013758894987404346, 0.05232255905866623, -0.030177844688296318, 0.02948250062763691, 0.0938037633895874,
    -0.03342495486140251, 0.008280699141323566, -0.059006135910749435, 0.10037065297365189, 0.08380591869354248, -0.038388438522815704, 0.004941586405038834, 0.07209231704473495,
    0.01166839525103569, 0.04275402054190636, 0.004974096082150936, -0.0578751303255558, 0.0973644107580185, -0.006530801299959421, -0.006706084590405226, -0.021710747852921486,
    0.024002805352211, 0.1034836694598198, 0.14146623015403748, 0.014047699049115181, 0.046751588582992554, -0.01614062674343586, 0.01728612743318081, 0.12149372696876526,
    0.03694593161344528, 0.0355716310441494, -0.01409097295254469, 0.06990095227956772, 0.020922692492604256, 0.10654883086681366, 0.035710155963897705, 0.0687355324625969,
    -0.0030455435626208782, -0.03213153034448624, 0.0011107386089861393, -0.01051691547036171, 0.020168203860521317, -0.05205615609884262, -0.04901350289583206, -0.03994397446513176,
    0.054283447563648224, -0.15737074613571167, -0.0186639241874218, -0.11585871875286102, 0.0368226058781147, -0.06739411503076553, -0.06974446773529053, -0.04664020985364914,
    -0.02403600700199604, -0.050506528466939926, -0.11504244059324265, -0.05729734152555466, 0.06852979958057404, 0.08197242021560669, 0.03130021691322327, 0.010609278455376625,
    0.10416467487812042, -0.02156907506287098, 0.001372834900394082, 0.05264243111014366, -0.15128755569458008, -0.022353002801537514, -0.0602005198597908, 0.020592885091900826,
    0.010072180069983006, 0.04858860373497009, 0.030731262639164925, 0.08930641412734985, -0.009956881403923035, 0.010757802054286003, 0.01502294186502695, 0.021164845675230026,
    -0.11106542497873306, -0.06092197075486183, 0.03515573963522911, -0.015640391036868095, -0.0054128123447299, -0.0183225367218256, 0.04866523668169975, -0.1743171066045761,
    0.0045794048346579075, -0.03565456345677376, -0.028757154941558838, 0.06891463696956635, 0.059299152344465256, -0.05424603819847107, -0.16433851420879364, -0.08258858323097229,
    -0.15904618799686432, 0.011827419511973858, -0.017254067584872246, -0.03726369887590408, 0.03399449214339256, -0.05370048061013222, 0.03486811742186546, 0.025032198056578636,
    -0.05626065656542778, -0.044142987579107285, 0.004184994846582413, 0.030661478638648987, -0.11633411049842834, 0.017775122076272964, -0.061978258192539215, 0.07462215423583984,
    0.02722647227346897, 0.026766259223222733, -0.034972380846738815, 0.0976066142320633, 0.0348164327442646, -0.03113625757396221, 0.0344458632171154, -0.016464125365018845,
    0.001011733547784388, -0.035199400037527084, 0.04515395313501358, 0.001261167461052537, 0.01626214012503624, 0.05281383544206619, -0.08060827851295471, -0.006665339227765799,
    -0.09232952445745468, -0.05362880229949951, 0.00602137204259634, -0.10710866749286652, -0.06792791932821274, 0.02776448056101799, 0.04560757055878639, 0.08785545825958252,
    0.004448572173714638, -0.05257302522659302, 0.05491889268159866, 0.10061987489461899, 0.12555356323719025, 0.0027390921022742987, 0.0019738893024623394, 0.03916575759649277,
    -0.11905337870121002, 0.03366335108876228, -0.022421324625611305, 0.01612826995551586, 0.11201602965593338, -0.057241421192884445, -0.005697671789675951, -0.038930587470531464,
    0.02384781651198864, 0.05261083319783211, 0.08453637361526489, -0.01123938150703907, -0.01557697169482708, -0.008058029226958752, 0.061078161001205444, 0.07001553475856781,
    0.04681362956762314, 0.11253377050161362, -0.054087214171886444, 0.03005581721663475, -0.015392010100185871, -0.08059550076723099, 0.033887289464473724, -0.08005991578102112,
    -0.09272122383117676, -0.003165970789268613, 0.0314905121922493, 0.010756256990134716, 0.01634153537452221, -0.006019060034304857, -0.055919867008924484, -0.05028821900486946,
    -0.10448375344276428, -0.03069816529750824, 0.0372694730758667, 0.19592231512069702, 0.011715312488377094, 0.04969792813062668, -0.050522785633802414, -0.07012287527322769,
    -0.05529005825519562, -0.00577582698315382, 0.10917994379997253, 0.009272203780710697, 0.07603546231985092, -0.03900587558746338, 0.003838243428617716, 0.023623161017894745,
    0.07388780266046524, -0.07647371292114258, 0.06851110607385635, -0.07160112261772156, 0.005215892102569342, -0.10860662907361984, -0.0035480440128594637, -0.09557756036520004,
    0.07637832313776016, 0.028332408517599106, -0.04019300639629364, -0.1012108251452446, 0.0473962239921093, 0.0042306710965931416, 0.06591366231441498, 0.0335017628967762,
    -0.01935509219765663, -0.011879846453666687, 0.13229231536388397, 0.002685676561668515, -0.0329207144677639, -0.019846923649311066, -0.028083087876439095, -0.169588103890419,
    -0.02524634450674057, 0.05457569286227226, -0.0085779232904315, -0.08235572278499603, -0.06714734435081482, 0.19006283581256866, -0.05340135470032692, 0.021552380174398422,
    0.07735902070999146, 0.017299849539995193, -0.027391264215111732, 0.01689882203936577, -0.038742225617170334, -0.07841582596302032, -0.009339623153209686, -0.030329551547765732,
    -0.017438463866710663, 0.016060393303632736, 0.01992396079003811, 0.05135532096028328, -0.1109662652015686, 0.12494851648807526, -0.04071616008877754, 0.138240784406662,
    0.04923366382718086, 0.04232604801654816, -0.16744661331176758, -0.001004617428407073, -0.09166567027568817, -0.16942274570465088, -0.07735610753297806, -0.12238730490207672,
    0.06315833330154419, 0.04171295464038849, 0.109210304915905, -0.027351949363946915, 0.07184990495443344, -0.01790822669863701, -0.025425462052226067, -0.02664472721517086,
    -0.026394575834274292, 0.06486725062131882, -0.027561141178011894, 0.011124762706458569, 0.017388027161359787, -0.005227974150329828, 0.08981676399707794, 0.04425517097115517,
    -0.015555502846837044, -0.02114463597536087, -0.05720721557736397, 0.03584100678563118, 0.04985983669757843, -0.13484756648540497, 0.013250943273305893, 0.0049667139537632465,
    0.12806139886379242, 0.14646266400814056, 0.028111226856708527, -0.0281809251755476, -0.0062028695829212666, -0.13783545792102814, 0.004971659276634455, -0.054460618644952774,
    0.015991564840078354, 0.048858173191547394, -0.02355826646089554, 0.016514211893081665, 0.013782384805381298, -0.05107637122273445, -0.04125814512372017, 0.031337935477495193,
    -0.0330996997654438, 0.08831898868083954, 0.04234611615538597, 0.06948190182447433, -0.019372833892703056, 0.008204051293432713, -0.05371801182627678, 0.2466224581003189,
    -0.02580985426902771, -0.023035939782857895, -0.03272483870387077, 0.02948027476668358, 0.05860515683889389, -0.029299093410372734, -0.009944693185389042, -0.02506665140390396,
    0.10062523186206818, 0.21987424790859222, -0.037046246230602264, -0.040260832756757736, 0.13239848613739014, 0.10373593866825104, 0.022600015625357628, -0.05859506502747536,
    0.1048428937792778, -0.03477991744875908, -0.04976668208837509, -0.09410984069108963, 0.012747135013341904, -0.009527609683573246, -0.017634401097893715, -0.014508891850709915,
    0.03252110630273819, -0.10128562897443771, 0.12863421440124512, -0.2763414978981018, 0.09219108521938324, 0.05710471794009209, 0.038185831159353256, -0.16010993719100952,
    0.09323814511299133, 0.029744679108262062, 0.026806145906448364, -0.15866105258464813, -0.007540667429566383, 0.03297252953052521, 0.05226488411426544, 0.027435915544629097,
    0.13551007211208344, 0.05477023869752884, -0.024381117895245552, 0.01794922724366188, -0.05545582249760628, 0.0866536796092987, 0.016520444303750992, 0.002280163811519742,
    -0.0038411510176956654, -0.013573492877185345, 0.08705007284879684, -0.0700397714972496, -0.09644392877817154, -0.19695769250392914, 0.11144783347845078, 0.04207820072770119,
    0.03466716408729553, -0.05923764407634735, 0.003307023551315069, -0.04397380352020264, 0.0017004382098093629, 0.00157949049025774, -0.0288920309394598, -0.010614670813083649,
    -0.01331466343253851, -0.03200359269976616, -0.023599283769726753, -0.007717188447713852, 0.033604785799980164, -0.0844760611653328, 0.052104949951171875, 0.03693343326449394,
    -0.08372961729764938, 0.056729063391685486, -0.04215122014284134, -0.06935504823923111, -0.00020125549053773284, -0.04596201330423355, -0.06848658621311188, -0.14384105801582336,
    0.029232798144221306, 0.02925293892621994, 0.05599187687039375, 0.029600949957966805, 0.18049561977386475, 0.04645650461316109, 0.06351900845766068, 0.10007544606924057,
    -0.008366667665541172, -0.1041409894824028, 0.026471175253391266, 0.020576270297169685, -0.009589011780917645, 0.004549182020127773, -0.02507689595222473, -0.02786937728524208,
    0.031242648139595985, -0.036237217485904694, -0.015760812908411026, -0.013909698463976383, 0.07526803761720657, 0.0977540910243988, 0.001055102446116507, 0.022930588573217392,
    -0.0022832942195236683, -0.0153431361541152, 0.03177570179104805, -0.008791063912212849, 0.027379106730222702, -0.11736656725406647, 0.04227900505065918, -0.07296392321586609,
    -0.0628516674041748, 0.003822691272944212, -0.0806354284286499, -0.007476132363080978, -0.07945988327264786, 0.08857473731040955, -0.024731470271945, 0.058046553283929825,
    0.02007737010717392, -0.08482125401496887, 0.023327965289354324, -0.006788453087210655, -0.01989164389669895, -0.06682717055082321, 0.09535008668899536, -0.10157311707735062,
    -0.011214288882911205, -0.06877093762159348, -0.044737476855516434, 0.03301914781332016, 0.035462670028209686, -0.11318236589431763, -0.04554380849003792, -0.019192801788449287,
    -0.009711485356092453, -0.2917560040950775, 0.0989496111869812, -0.10507847368717194, 0.09685148298740387, -0.006064233835786581, 0.09573601931333542, -0.023755662143230438,
    0.21648217737674713, 0.01363822165876627, 0.05679628998041153, -0.02238016575574875, 0.005935899447649717, -0.15561790764331818, -0.08227246254682541, 0.08794980496168137,
    -0.10339712351560593, -0.005439885426312685, -0.039558056741952896, -0.26362308859825134, 0.0758882686495781, 0.12915858626365662, 0.30396419763565063, -0.0799640491604805,
    0.10217218101024628, -0.08848944306373596, 0.0375940278172493, -0.10217946022748947, 0.02556524984538555, 0.03023930825293064, 0.01126283872872591, 0.029541391879320145,
    0.0705232098698616, -0.039611175656318665, -0.17691849172115326, 0.015332772396504879, 0.04534170776605606, -0.037817228585481644, 0.06055031344294548, 0.09724180400371552,
    0.001725104870274663, -0.016830669716000557, 0.10902398079633713, -0.13707444071769714, 0.1075172945857048, 0.09959337115287781, -0.058957457542419434, 0.05291667580604553,
    -0.06515616923570633, 0.07093874365091324, 0.04947478324174881, 0.039831098169088364, -0.0809500515460968, -0.07914265990257263, -0.06412690132856369, -0.007449996192008257,
    0.0021816501393914223, -0.0071088457480072975, -0.004863480105996132, -0.023485325276851654, -0.01007962878793478, -0.03147009015083313, 0.004719771444797516, -0.1678280383348465,
    -0.059807658195495605, 0.013113133609294891, -0.03925313800573349, 0.04985969141125679, 0.03153332322835922, 0.024988310411572456, -0.02574900910258293, -0.011105909943580627,
    -0.02244751527905464, -0.006589573808014393, -0.10788098722696304, -0.003086569719016552, 0.003860121127218008, 0.07911220192909241, 0.04276324063539505, -0.047265540808439255,
    -0.0199909470975399, 0.021224193274974823, -0.05328221246600151, 0.027153359726071358, -0.00981900840997696, -0.04940955713391304, 0.04051682725548744, 0.006591813173145056,
    -0.014382184483110905, -0.06676685810089111, -0.10822761058807373, -0.0654270276427269, 0.04194415733218193, -0.010350978933274746, -0.019116675481200218, 0.07075214385986328,
    -0.09741100668907166, -0.0020865912083536386, -0.06296881288290024, 0.03493494167923927, -0.1478709727525711, -0.08428347110748291, 0.03495286405086517, -0.03155200183391571,
    0.1038062646985054, 0.015599184669554234, 0.07346317917108536, 0.020340122282505035, 0.052382487803697586, 0.0640181452035904, -0.06231261417269707, -0.05152963474392891,
    0.09917250275611877, -0.09746181219816208, 0.08464142680168152, -0.03098864108324051, -0.03408169001340866, -0.044504545629024506, 0.09567108005285263, -0.006869007833302021,
    0.05211721360683441, -0.042113952338695526, -0.005652950145304203, -0.029647186398506165, 0.016336608678102493, 0.007184226997196674, 0.053668394684791565, -0.1397111862897873,
    -0.07051505893468857, 0.16349278390407562, 0.07998917996883392, 0.04887796565890312, -0.003377872984856367, -0.03875747323036194, 0.10432714223861694, -7.816866127541289e-05,
    0.03810802474617958, -0.01760808378458023, -0.04582880809903145, -0.015441185794770718, -0.08337715268135071, 0.0071499100886285305, -0.06546834856271744, 0.08346399664878845,
    -0.019728438928723335, -0.01831829361617565, -0.07223208993673325, -0.03911249339580536, 0.02243701182305813, -0.01455084141343832, 0.10893499106168747, -0.04291943833231926,
    0.008036483079195023, -0.13290640711784363, -0.09516841173171997, -0.09266289323568344, -0.015483695082366467, 0.004020500462502241, -0.08404143899679184, 0.006812304724007845,
    -0.0010693140793591738, 0.027102861553430557, 0.0028034523129463196, -0.03848656639456749, -0.06446376442909241, -0.032975781708955765, 0.03281418979167938, 0.156502828001976,
    0.027992362156510353, -0.03843465819954872, 0.06123967096209526, 0.01520255021750927, 0.1405894011259079, 0.0140272481366992, -0.08780595660209656, -0.01874006725847721,
    0.029689334332942963, -0.04504775255918503, 0.04779813811182976, -0.05273821949958801, -0.12655307352542877, 0.0022468443494290113, -0.0849907249212265, -0.14784137904644012,
    -0.031600553542375565, -0.030837006866931915, -0.0614151656627655, -0.0629558265209198, 8.161295409081504e-05, -0.03920843452215195, -0.008159398101270199, -0.2724359333515167,
    -0.04375847429037094, -0.004094048403203487, 0.009204215370118618, 0.07872958481311798, 0.07651855051517487, 0.0006651714793406427, 0.04826498404145241, 0.032976385205984116,
    0.0288836732506752, 0.04086608067154884, -0.08790218830108643, -0.020726129412651062, 0.02063628099858761, 0.0001355551794404164, -0.13245560228824615, -0.04832702875137329,
    -0.000964272185228765, 0.01809273473918438, 0.04867926612496376, 0.020573295652866364, 0.0469602607190609, -0.11265882849693298, 0.07676287740468979, -0.02876662090420723,
    0.0006196426111273468, -0.08130037784576416, -0.08345139026641846, -0.06445115804672241, 0.04835069552063942, -0.16392381489276886, 0.056856635957956314, 0.02822999283671379,
    -0.0450667105615139, 0.05756383016705513, -0.012300307862460613, 0.0293144378811121, 0.03139982372522354, 0.005285677500069141, 0.010039210319519043, -0.04519687592983246,
    0.04330406337976456, -0.04542294144630432, 0.10654359310865402, -0.003549311077222228, -0.017216548323631287, -0.0577554851770401, 0.004925079178065062, -0.07968727499246597,
    0.11241419613361359, 0.13382865488529205, -0.014267127960920334, -0.041215065866708755, -0.011010360904037952, -0.03785443678498268, 0.09003479033708572, -0.12248453497886658,
    0.08206655085086823, -0.012918077409267426, 0.07296005636453629, 0.028444552794098854, 0.02550969459116459, -0.03741331771016121, -0.07888548821210861, -0.007897858507931232,
    0.09936867654323578, 0.03521902114152908, 0.07037403434515, 0.08097817748785019, -0.04739159345626831, -0.06552555412054062, 0.0032657673582434654, 0.015218797139823437,
    -0.020591534674167633, 0.058522533625364304, -0.0008288357057608664, 0.005777937360107899, -0.029512455686926842, -0.06333426386117935, 0.014421393163502216, -0.02983269840478897,
    0.04015311226248741, 0.04189670458436012, -0.1507202535867691, 0.024224882945418358, 0.01925036869943142, -0.05528205633163452, -0.004234060179442167, -0.012695605866611004,
    -0.0535425990819931, 0.0072575900703668594, -0.009100010618567467, -0.04574616998434067, 0.01456166710704565, 0.00023656876874156296, 0.05935482308268547, 0.03909346088767052,
    0.12675483524799347, -0.03690106421709061, 0.14016303420066833, -0.08969564735889435, -0.003677499946206808, 0.017927035689353943, 0.043924394994974136, 0.15158747136592865,
    -0.02618321217596531, -0.023939654231071472, 0.039114873856306076, 0.0032993725035339594, 0.049595899879932404, -0.023451263085007668, -0.04800936207175255, 0.04270944371819496,
    0.08365245163440704, -0.005641547031700611, 0.007134787272661924, 0.05923137813806534, -0.10902971774339676, -0.019234534353017807, -0.07516927272081375, -0.09636086225509644,
    -0.021411318331956863, -0.00792394857853651, -0.09395358711481094, 0.09128530323505402, 0.06205862760543823, 0.035481907427310944, -0.056910257786512375, -0.15687772631645203,
    -0.03729213774204254, -0.028983524069190025, 0.00132247363217175, -0.08168379217386246, 0.07769963145256042, 0.06823814660310745, 0.016824856400489807, -0.05305999889969826,
    -0.05095773935317993, 0.012379559688270092, 0.06352166086435318, -0.0061155641451478004, 0.11025428026914597, -0.07571915537118912, -0.04923118278384209, 0.012315275147557259,
    0.0261510219424963, -0.06340041756629944, 0.02119511552155018, -0.07222580909729004, 0.006680752616375685, -0.11079667508602142, -0.08406398445367813, 0.06457561999559402,
    0.024706436321139336, 0.07968543469905853, 0.04409363865852356, 6.546443182742223e-05, 0.0050405096262693405, 0.2463507056236267, -0.09714752435684204, -0.0019208285957574844,
    0.07596530765295029, -0.06693243980407715, -0.015149089507758617, 0.012415374629199505, -0.08366627991199493, -0.009264321997761726, -0.01742212474346161, -0.07889815419912338,
    -0.017810827121138573, 0.018999895080924034, 0.04158993437886238, -0.03159942850470543, -0.05855182185769081, -0.13936221599578857, -0.06980178505182266, -0.0710344910621643,
    -0.02033565565943718, 0.10792325437068939, -0.026025032624602318, -0.09301938861608505, -0.0067956470884382725, 0.012500831857323647, 0.053399499505758286, 0.03722689673304558,
    0.06753551959991455, -0.04838723689317703, 0.07636906206607819, 0.013607767410576344, -0.002260559005662799, -0.022605879232287407, -0.0036456091329455376, 0.031241871416568756,
    0.017909586429595947, -0.15249857306480408, 0.04472003132104874, -0.08355128020048141, 0.021335633471608162, 0.00024732283782213926, -0.05787768214941025, -0.1311701387166977,
    -0.08957650512456894, -0.032191433012485504, 0.004930858500301838, -0.033849623054265976, -0.044326286762952805, 0.011343228630721569, -0.034729257225990295, 0.02158188261091709,
    -0.003724565263837576, -0.055956482887268066, -0.050796620547771454, -0.08789394050836563, -0.04278460144996643, -0.03737372159957886, -0.07610009610652924, -0.00136164843570441,
    -0.1305631697177887, 0.09792070835828781, -0.10228841751813889, 0.028014911338686943, 0.010350123047828674, 0.019273672252893448, 0.02924724481999874, 0.019447706639766693,
    0.08389659225940704, -0.03130396082997322, -0.008926229551434517, -0.027286620810627937, -0.1157335415482521, 0.008390950970351696, 0.001332754036411643, -0.012081719003617764,
    0.013661111705005169, -0.0013944542733952403, 0.015791354700922966, -0.029049338772892952, -0.20277628302574158, 0.20827339589595795, -0.018698709085583687, 0.002701346529647708,
    -0.06618105620145798, 0.02222437784075737, -0.07177611440420151, 0.04200942441821098, 0.12048159539699554, -0.09952051937580109, -0.0935221016407013, -0.032583754509687424,
    -0.061751384288072586, -0.009086640551686287, -0.06772258877754211, 0.06007302552461624, -0.048128560185432434, 0.029533952474594116, 0.016127049922943115, 0.1423354595899582,
    -0.07861432433128357, -0.0036934700328856707, -0.09791110455989838, 0.006632279139012098, -0.026445666328072548, -0.0185216274112463, 0.07454521954059601, -0.008370616473257542,
    -0.09320991486310959, 0.02352350950241089, 0.024336572736501694, 0.03535277768969536, -0.0012601101770997047, 0.007960912771522999, -0.14241783320903778, -0.037498198449611664,
    -0.06655047833919525, -0.0003340728289913386, -0.004885424394160509, 0.006824564188718796, -0.05971943214535713, -0.06642476469278336, -0.10473905503749847, -0.043258436024188995,
    -0.005951202008873224, -0.07393814623355865, -0.040071215480566025, -0.016888385638594627, -0.0250663161277771, -0.22980228066444397, -0.03082837164402008, 0.0065691969357430935,
    0.03947468474507332, -0.01940283738076687, 0.07038093358278275, -0.021570077165961266, -0.028358761221170425, 0.07908649742603302, -0.0035208065528422594, 0.0017170357750728726,
    -0.0008825730183161795, 0.020114406943321228, -0.055718451738357544, 0.04717716574668884, 0.09869416803121567, -0.0528087243437767, 0.0343194417655468, -0.07717665284872055,
    0.001432035001926124, -0.038557521998882294, -0.07034243643283844, -0.04749425873160362, 0.010363511741161346, -0.01109337992966175, 0.018450427800416946, 0.03414255380630493,
    0.07823821157217026, -0.10139293223619461, 0.018479980528354645, -0.07151512056589127, 0.02307644486427307, 0.044189997017383575, 0.02180546522140503, 0.08177048712968826,
    -0.08518324047327042, 0.24475117027759552, 0.06541735678911209, -0.006587416864931583, 0.004475526977330446, 0.06826275587081909, -0.07415502518415451, -0.06873498111963272,
    0.10917509347200394, -0.05083266273140907, -0.004321445245295763, 0.04024107754230499, 0.0193560179322958, 0.01151058916002512, 0.0033929829951375723, -0.08354143798351288,
    0.09216445684432983, 0.03746659681200981, -0.04858620837330818, 0.04254791885614395, 0.029862750321626663, -0.01555297989398241, 0.04761924222111702, -0.057973627001047134,
    -0.11106893420219421, 0.03168315812945366, -0.004427533131092787, 0.01619064062833786, 0.002364748390391469, -0.01659652590751648, 0.033815860748291016, 0.007823653519153595,
    0.056324928998947144, -0.04014897719025612, -0.06390506774187088, -0.02512769214808941, -0.035531897097826004, -0.045678745955228806, -0.01739703305065632, -0.1918981969356537,
    -0.034193288534879684, 0.03165813907980919, 0.07335694879293442, -0.06950744241476059, -0.04541878402233124, -0.096866175532341, -0.15721341967582703, 0.04170789569616318,
    -0.09362227469682693, -0.0728403627872467, -0.014203465543687344, 0.02283625118434429, 0.20306897163391113, -0.08624112606048584, -0.03698933124542236, -0.04138714820146561,
    0.02593335323035717, -0.03618159890174866, -0.0022963692899793386, 0.01699814200401306, 0.026661932468414307, -0.05274152010679245, 0.021751845255494118, 0.2581838071346283,
    -0.10042238235473633, 0.011567514389753342, -0.011674322187900543, 0.03752551227807999, 0.026359405368566513, -0.005571265704929829, 0.04002363607287407, 0.021429138258099556,
    -0.10713114589452744, 0.01258572842925787, -0.04265901818871498, -0.02144196443259716, -0.05597110092639923, -0.018144400790333748, 0.023234238848090172, -0.05629793554544449,
    -0.03843911364674568, 0.027154741808772087, 0.03157014772295952, 0.04557907581329346, 0.04643212631344795, -0.0508723258972168, 0.02752014249563217, 0.044826019555330276,
    0.003485889406874776, 0.020180515944957733, 0.09335006773471832, -0.01693924143910408, 0.04293224960565567, 0.11143692582845688, -0.030100936070084572, 0.00657173665240407,
    -0.05002651363611221, -0.11811210215091705, 0.11828744411468506, 0.017484132200479507, 0.0018451963551342487, 0.014959888532757759, 0.042831990867853165, 0.09789974987506866,
    -0.04347647354006767, -0.031318970024585724, -0.11979998648166656, -0.009146403521299362, -0.029381223022937775, 0.04995589703321457, -0.02202504687011242, -0.12696228921413422,
    -0.1093522161245346, -0.04467444866895676, -0.018661174923181534, -0.04492635279893875, -0.026496930047869682, -0.026515282690525055, -0.020303355529904366, 0.00014637969434261322,
    0.020804913714528084, -0.1146431639790535, 0.014784064143896103, -0.04573572799563408, 0.03560708463191986, -0.06882793456315994, -0.003063363954424858, -0.0043344260193407536,
    0.12118284404277802, -0.1420743763446808, -0.03688071668148041, 0.0130636440590024, -0.036547884345054626, 0.01622048206627369, 0.08843594789505005, -0.10998601466417313,
    -0.16973558068275452, 0.013665994629263878, 0.057769715785980225, 0.0065231965854763985, -0.014948416501283646, -0.021433744579553604, 0.05946502089500427, -0.03502757102251053,
    -0.01789621077477932, -0.05363667383790016, -0.0010493571171537042, 0.04437050223350525, -0.057655926793813705, 0.01722348853945732, -0.061385106295347214, -0.07511573284864426,
    -0.04788139462471008, -0.11268569529056549, -0.013672200962901115, 0.0810868963599205, 0.028018193319439888, 0.04585536941885948, 0.038015834987163544, -0.014169905334711075,
    -0.008316388353705406, -0.012715364806354046, -0.05313511937856674, -0.023761257529258728, 0.06710999459028244, 0.05947668477892876, 0.010392743162810802, -0.18613247573375702,
    0.05526005104184151, -0.01402120292186737, 0.026349112391471863, 0.03973981365561485, 0.07987803220748901, 0.11893340200185776, -0.12687790393829346, 0.05218875780701637,
    0.10753877460956573, 0.04010503366589546, 0.014372827485203743, -0.06382662802934647, 0.16742044687271118, 0.08529463410377502, 0.01369587704539299, -0.051180195063352585,
    -0.027116931974887848, 0.018893323838710785, -0.003630656749010086, 0.06084384769201279, 0.01692487858235836, 0.027491500601172447, -0.0029355185106396675, -0.008279182016849518,
    0.000991480308584869, 0.017222987487912178, 0.004681963473558426, 0.04003165289759636, -0.022236954420804977, 0.007625315338373184, -0.029730290174484253, -0.037684787064790726,
    -0.015575557015836239, 0.0058297342620790005, -0.03375421464443207, -0.05996133014559746, -0.03999703750014305, -0.04371200501918793, -0.014319205656647682, -0.0401490218937397,
    -0.014160491526126862, 0.05213671922683716, -0.005793790332973003, -0.015455440618097782, -0.000226847012527287, -0.01779630035161972, -0.009023192338645458, 0.02312442846596241,
    0.009389146231114864, -0.034056082367897034, -0.08231928944587708, -0.05812380835413933, -0.03112832084298134, -0.10398025065660477, -0.03492863103747368, -0.01663106493651867,
    -7.00792734278366e-05, -0.04093053564429283, -0.002483154647052288, -0.002453806810081005, 0.02748684026300907, -0.037402622401714325, 0.017732804641127586, 0.0024483599700033665,
    0.041815683245658875, 0.002699900884181261, 0.007471689023077488, 0.0021210438571870327, 0.04151375964283943, 0.044255439192056656, 0.0551014319062233, 0.01938788779079914,
    0.032357100397348404, 0.016949785873293877, -0.025991100817918777, 0.032861754298210144, -0.07666631042957306, 0.04177971929311752, 0.0072907074354588985, -0.07553619891405106,
    0.010726338252425194, -0.013192071579396725, -0.021074410527944565, 0.01265404187142849, -0.002600653562694788, 0.002405691659078002, 0.025849653407931328, -0.031896959990262985,
    0.03239760175347328, -0.0014644896145910025, -0.06919218599796295, 0.02679304964840412, 0.016508111730217934, 0.010480925440788269, 0.055549465119838715, -0.009184597060084343,
    0.0016628805315122008, -0.03477267920970917, -0.002231334336102009, 0.002672553528100252, -0.01686902716755867, -0.06195782497525215, 0.06037129461765289, -0.04834670200943947,
    0.03874501585960388, 0.016562052071094513, 0.012168127112090588, -0.04594973474740982, 0.039007339626550674, 0.00424693850800395, 0.011879988946020603, 0.0057303281500935555,
    -0.02641420252621174, 0.03149297833442688, 0.0260020662099123, -0.007894315756857395, 0.0109922606498003, -0.015328019857406616, -0.046268850564956665, 0.020854879170656204,
    0.019398974254727364, 0.03391173481941223, -0.03824582323431969, 0.006156585644930601, 0.0033510844223201275, -0.034377750009298325, 0.007664823904633522, 0.04803020879626274,
    -0.02422509342432022, 0.032822076231241226, 0.003917886409908533, 0.004731904715299606, -0.048645421862602234, 0.014883183874189854, 0.034852612763643265, 0.012226507067680359,
    -0.0223246980458498, 0.0212278813123703, 0.04647434502840042, 0.030351314693689346, 0.0540611632168293, -0.0007167786243371665, -0.02963014505803585, -0.00020036837668158114,
    -0.011997892521321774, 0.035261351615190506, -0.00928018894046545, -0.03257308900356293, -0.004149756859987974, 0.0010599823435768485, 0.06730854511260986, 0.03111569955945015,
    0.031231757253408432, -0.04606728255748749, 0.06455198675394058, -0.001457298407331109, -0.0406082347035408, -0.04645569249987602, -0.02137005142867565, 0.04391978681087494,
    -0.0626622885465622, -0.007324926555156708, -0.0035254070535302162, -0.015608828514814377, 0.019194021821022034, 0.017359262332320213, -0.01491678785532713, -0.005298474803566933,
    -0.02329491823911667, -0.039268556982278824, 0.006565673742443323, -0.024461595341563225, -0.004683099687099457, 0.033733099699020386, -0.008826389908790588, -0.03991740196943283,
    0.002774468855932355, 0.02821151539683342, 0.005364636890590191, 0.01485908217728138, -0.05129086971282959, 0.07139785587787628, 0.004883993417024612, -0.002378166187554598,
    -0.00932479090988636, 0.023456918075680733, 0.0351577065885067, 0.005209396127611399, -0.011433495208621025, -0.037547796964645386, -0.05991051346063614, 0.0043343049474060535,
    0.05644890293478966, -0.01019550021737814, 0.05327131226658821, -0.07822998613119125, 0.025285758078098297, 0.009289024397730827, -0.030548540875315666, -0.00969874206930399,
    0.004062258172780275, 0.02040509320795536, 0.0072138081304728985, -0.023268479853868484, 0.008926835842430592, -0.029245171695947647, -0.039025988429784775, 0.036092232912778854,
    0.0019044425571337342, -0.0051241121254861355, -0.044200677424669266, -0.012213481590151787, 0.0068698786199092865, 0.011664772406220436, 0.022425087168812752, 0.05552030727267265,
    0.00981164537370205, 0.009860946796834469, -0.0034034813288599253, -0.03945648670196533, 0.0030518840067088604, 0.015285713598132133, 0.042707230895757675, -0.06125980615615845,
    -0.00973182637244463, 0.0005734423757530749, 0.009812673553824425, -0.020964238792657852, 0.02204669639468193, 0.03193623572587967, 0.04537295550107956, 0.008243231102824211,
    0.010822992771863937, -0.01072566956281662, -0.005946013610810041, 0.004526525270193815, -0.005416475236415863, -0.008152917958796024, 0.015695566311478615, 0.04968933016061783,
    -0.019554920494556427, 0.013134334236383438, -0.0038690592627972364, 0.0008049188763834536, -0.0496666394174099, 0.04920218139886856, 0.010623106732964516, -0.0036461753770709038,
    -0.041143324226140976, -0.007773930672556162, -0.008659451268613338, -0.046987809240818024, 0.022346798330545425, 0.016809586435556412, 0.04148199036717415, 0.007791160140186548,
    -0.008161368779838085, 0.01911582052707672, -0.040634509176015854, 0.007316841743886471, -0.05195090174674988, 0.029290370643138885, 0.03256949037313461, 0.009982073679566383,
    -0.029637619853019714, 0.011172009631991386, 0.026665084064006805, 0.006954522803425789, 0.05977616086602211, -0.0018018544651567936, -0.030192218720912933, -0.02006569877266884,
    -0.013131124898791313, 0.010713616386055946, -0.032682307064533234, 0.015661118552088737, 0.02621045708656311, -0.03333328664302826, 0.03849625959992409, -0.023085495457053185,
    0.016748523339629173, -0.0217583030462265, -0.02234421670436859, -0.06304432451725006, -0.043065447360277176, -0.011835316196084023, 0.019237060099840164, 0.025026652961969376,
    -0.040272306650877, 0.02397940121591091, -0.0035784405190497637, -0.054176878184080124, -0.012181629426777363, 0.04854714125394821, -0.05018243566155434, 0.016720233485102654,
    0.020892299711704254, 0.009290292859077454, 0.07763293385505676, -0.020428242161870003, 0.018267713487148285, -0.08261686563491821, 0.05274418741464615, 0.015037448145449162,
    -0.020974192768335342, 0.0032949147280305624, 0.011000756174325943, 0.017755791544914246, -0.04741906747221947, -0.025642359629273415, 0.023125458508729935, -0.01409760769456625,
    0.012423655949532986, 0.015936201438307762, 0.0023790833074599504, -0.012945463880896568, -0.01601237617433071, 0.03978637233376503, 0.026267241686582565, 0.026010213419795036,
    0.020898086950182915, 0.03765885531902313, -0.0006715334602631629, 0.03265581652522087, 0.01596851460635662, 0.021073346957564354, -0.031044218689203262, -0.017492162063717842,
    0.038438137620687485, -0.02078825607895851, -0.024379750713706017, 0.002465489786118269, 0.03536246716976166, -0.022706693038344383, 0.0369025394320488, 0.027438927441835403,
    0.01849418319761753, 0.013320243917405605, -0.02188667096197605, 0.0033731781877577305, 0.013115845620632172, 0.027447786182165146, -0.004444186110049486, 0.03797604516148567,
    -0.03811286389827728, 0.007725496776401997, 0.020508447661995888, -0.087774358689785, -0.024128133431077003, -0.017597448080778122, 0.004379537422209978, -0.009083627723157406,
    0.02044987864792347, -0.008379694074392319, -0.017079351469874382, -0.01998499035835266, 0.046530451625585556, -0.03590550646185875, 0.010625218041241169, 0.01605936698615551,
    0.017874179407954216, -0.03998749330639839, -0.019282372668385506, -0.01920757070183754, -0.010417305864393711, -0.02724308893084526, 0.04200655594468117, 0.008470085449516773,
    0.018889643251895905, -0.008720128796994686, -0.0362342931330204, -0.02384820580482483, 0.00432271882891655, 0.017986105754971504, -0.021426087245345116, 0.003327942220494151,
    -0.040874186903238297, 0.06890326738357544, -0.013686968944966793, -0.016076093539595604, 0.015589226968586445, 0.02131746895611286, 0.028734594583511353, -0.010306019335985184,
    -0.010620014742016792, -0.01626439206302166, 0.030965909361839294, -0.008894420228898525, 0.04074692726135254, 0.024904929101467133, 0.008515173569321632, -0.0018473603995516896,
    0.056581635028123856, 0.007257402408868074, -0.029532846063375473, 0.012283849529922009, -0.006414758041501045, -0.04211778566241264, -0.01846289075911045, 0.03514887019991875,
    -0.023698609322309494, -0.006474985275417566, -0.021650927141308784, 0.042748745530843735, -0.0008332632714882493, 0.07039311528205872, 0.023930227383971214, -0.029773399233818054,
    -0.01614489033818245, -0.019206363707780838, 0.014020663686096668, 0.03573545068502426, -0.04366740211844444, -0.022112395614385605, 0.04064541682600975, -0.012883971445262432,
    0.018077140673995018, 0.008556639775633812, -0.02960338443517685, -0.05024990439414978, 0.018735991790890694, -0.02747931145131588, 0.009442056529223919, -0.016835495829582214,
    0.01692374050617218, 0.005100597161799669, 0.0024487811606377363, -0.03644980862736702, -0.023527823388576508, -0.014403256587684155, 0.0016555446200072765, 0.03511810675263405,
    -0.018513353541493416, 0.013316577300429344, -0.01974152773618698, -0.0392272062599659, -0.012756481766700745, -0.0031314033549278975, 0.03135712072253227, -0.03023265115916729,
    -0.00683979969471693, -0.02504074200987816, 0.02982422150671482, -0.012957176193594933, 0.053453478962183, -0.016395023092627525, 0.01783732697367668, 0.08232356607913971,
    0.028216389939188957, -0.004828276112675667, 0.0008667619549669325, -0.001936163636855781, 0.00977738481014967, -0.07514797151088715, 0.033154211938381195, -0.03464877977967262,
    0.05396096035838127, -0.017528235912322998, -0.02813062258064747, 0.012541701085865498, 0.007507375907152891, 0.009196333587169647, 0.033315349370241165, -0.07455214858055115,
    0.011907986365258694, -0.023784006014466286, -0.04694593325257301, -0.009491211734712124, -0.007162300869822502, -0.017963062971830368, -0.026586540043354034, -0.023876629769802094,
    0.05191187933087349, -0.03474245220422745, 0.01725422963500023, 0.044074054807424545, -0.03688916191458702, -0.019524499773979187, -0.0016735055251047015, 0.026806391775608063,
    -0.03645005822181702, -0.00459532905369997, 0.0398113913834095, -0.003531399415805936, -0.021718190982937813, -0.04708165302872658, -0.0020559304393827915, -0.05177000164985657,
    0.036017484962940216, 0.008886422961950302, -0.006850865203887224, 0.007151653524488211, 0.003476125653833151, -0.026493553072214127, -0.021447891369462013, -0.0167809147387743,
    -0.008460108190774918, -0.0073913587257266045, -0.0389784574508667, 0.014563513919711113, -0.00041434451122768223, 0.06155866011977196, -0.002354593016207218, -0.0001990328310057521,
    -0.001351074781268835, 0.06520976126194, 0.03422185406088829, 0.055520132184028625, -0.01027336809784174, 0.005737995728850365, 0.021474387496709824, -0.004267225041985512,
    -0.016582658514380455, -0.005159053020179272, 0.05290180444717407, 0.0219285786151886, -0.016983848065137863, -0.024903269484639168, 0.01880747452378273, 0.10026639699935913,
    -0.04906835779547691, 0.011866654269397259, 0.03300046920776367, 0.02942640334367752, 0.02800774946808815, 0.03598417341709137, 0.004741321317851543, 0.011745250783860683,
    -0.03475387394428253, 0.03565295785665512, -0.007736496161669493, 0.059255994856357574, 0.03722681477665901, 0.09951117634773254, 0.017023397609591484, 0.012131594121456146,
    -0.041641589254140854, -0.01645262911915779, 0.04703884944319725, 0.03390783816576004, 0.02898269146680832, -0.006761404685676098, 0.012645235285162926, 0.002914224285632372,
    -0.0010945083340629935, -0.027172701433300972, 0.0059672328643500805, -0.007870489731431007, 0.00647742347791791, -0.013786837458610535, -0.0168315377086401, 0.01020984910428524,
    -0.030458951368927956, -0.02900073304772377, -0.012104826979339123, 0.0415683314204216, 0.02058577351272106, 0.01586224138736725, 0.03065735287964344, 0.008019112050533295,
    0.0438426174223423, 0.008010352030396461, -0.00793734472244978, 0.01169967744499445, -0.019023103639483452, 0.017683692276477814, -0.03100994974374771, 0.01251653116196394,
    0.01689072884619236, -0.014321903698146343, 0.010402346029877663, 0.05627581477165222, -0.00424074474722147, -0.022156523540616035, -0.01006542518734932, -0.07901889085769653,
    0.014241235330700874, 0.004231688566505909, 0.03443480655550957, -0.04424372315406799, -0.010366158559918404, -0.005142103414982557, -0.027069104835391045, -0.021346239373087883,
    -0.0427800789475441, 0.008439306169748306, -0.023230670019984245, -0.037400662899017334, -0.011197738349437714, -0.04346639662981033, 0.02027190290391445, 0.011501554399728775,
    0.040978651493787766, -0.032559528946876526, -0.04331572726368904, 0.02647126093506813, 0.00042038338142447174, -0.03431630879640579, 0.05884033069014549, -0.05099952965974808,
    0.015351799316704273, 0.024486497044563293, -0.06449161469936371, 0.05255957692861557, -0.013217071071267128, 0.010721683502197266, -0.008295097388327122, -0.025263825431466103,
    -0.0054875146597623825, 0.03178069740533829, -0.03173623979091644, -0.003269054228439927, -0.041768480092287064, 0.038279976695775986, -0.003487484762445092, 0.08617591857910156,
    -6.507950456580147e-05, -0.039733923971652985, -0.01900455541908741, 0.02316933497786522, 0.001045767217874527, 0.032538387924432755, 0.04308827221393585, 0.0277445986866951,
    0.010779515840113163, 0.034352175891399384, 0.04139627516269684, -0.042647141963243484, -0.010134884156286716, -0.022368047386407852, 0.04214460775256157, -0.003599973628297448,
    0.046114008873701096, -0.06827112287282944, -0.024153439328074455, 0.03645370900630951, 0.052850425243377686, -0.02241533249616623, 0.017652617767453194, -0.013568337075412273,
    0.039546042680740356, -0.018818438053131104, -0.020351702347397804, 0.032352108508348465, 0.022651782259345055, 0.01427009142935276, -0.003832327201962471, -0.05407539755105972,
    -0.015161666087806225, -0.015339728444814682, 0.001867483020760119, 0.005271408706903458, 0.03184545785188675, -0.019003381952643394, -0.003793638199567795, 0.011866900138556957,
    0.03193714842200279, -0.00047178156091831625, 0.0067739724181592464, -0.02076038159430027, 0.03261827304959297, -0.014196349307894707, -0.03549152612686157, -0.03297322243452072,
    0.0232559647411108, -0.014027765020728111, -0.056046921759843826, -0.07609160989522934, -0.019054556265473366, -0.05397509038448334, -0.003622035263106227, 0.018163859844207764,
    -0.003898237133398652, -0.02823169343173504, -0.01770915649831295, -0.04361674562096596, 0.05136075243353844, -0.020610196515917778, 0.04554406926035881, 0.010167445056140423,
    -0.09319530427455902, 0.0025186690036207438, 0.0015513204270973802, -0.0135341240093112, 0.007805017754435539, -0.020828599110245705, 0.040161069482564926, -0.014124411158263683,
    -0.02639150246977806, -0.008285664021968842, -0.012522420845925808, -0.0205049067735672, 0.020688766613602638, 0.022810382768511772, -0.014813721179962158, -0.021362051367759705,
    0.029301991686224937, 0.07905511558055878, -0.008971932344138622, 0.0588032528758049, 0.005445564165711403, 0.06522570550441742, 0.03266629949212074, 0.03373720496892929,
    -0.0636214166879654, 0.03790218383073807, 0.0707128718495369, 0.03710075095295906, -0.017929576337337494, 0.04464052990078926, -0.013694396242499352, -0.012301520444452763,
    0.0031575399916619062, 0.0363849475979805, 0.0313141904771328, -0.004736626520752907, -0.004050715826451778, 0.03713328763842583, -0.04135759547352791, 0.03637009114027023,
    -0.0016822228208184242, 0.0356857031583786, 0.002277531661093235, 0.011234785430133343, -0.006086391396820545, 0.059627167880535126, 0.03722628206014633, 0.041405290365219116,
    -0.0437513068318367, 0.012166573666036129, 0.028588201850652695, -0.01937277242541313, -0.0058896890841424465, -0.035679373890161514, -0.03908267989754677, 0.015112588182091713,
    -0.010945303365588188, -0.011712473817169666, 0.03545435145497322, 0.007582968566566706, 0.025851503014564514, -0.007588956505060196, 0.02840464375913143, -0.021006328985095024,
    -0.015461578033864498, -0.04717528074979782, -0.04022791236639023, 0.002136820927262306, 0.005027799867093563, 0.0609859935939312, -0.009277058765292168, 0.0064896526746451855,
    -0.01769924722611904, -0.02187585085630417, -0.033969711512327194, -0.022134831175208092, 0.015462090261280537, 0.02430845983326435, 0.04547717794775963, -0.0037316540256142616,
    -0.010630265809595585, 0.05030962824821472, 0.0023406636901199818, 0.032578449696302414, -0.036393072456121445, 0.03160388022661209, 0.03233586996793747, -0.027371205389499664,
    0.010652812197804451, -0.03207027167081833, -0.01628389209508896, -0.01821400225162506, 0.03609452396631241, 0.05355818197131157, 0.021886518225073814, -0.020678527653217316,
    -0.011527121998369694, -0.004751987289637327, -0.032866470515728, 0.008024059236049652, 0.02462083101272583, 0.013780049979686737, 0.04411586746573448, -0.006141575053334236,
    -0.026217510923743248, -0.043232511729002, -0.004781655967235565, 0.05104580894112587, -0.02552511915564537, 0.015531722456216812, 0.0018575915601104498, 0.002368144690990448,
    0.003700112923979759, 0.00025836259010247886, -0.03751692920923233, 0.007809294853359461, 0.06125444918870926, 0.0059357392601668835, -0.02555081807076931, -0.04076559841632843,
    0.016316598281264305, 0.024194251745939255, -0.022387107834219933, -0.03957728296518326, -0.028844233602285385, -0.03395700827240944, 0.02856489270925522, 0.02576059103012085,
    0.09860382229089737, 0.023390088230371475, -0.003043640172109008, -0.013131734915077686, -0.018553171306848526, 0.009007688611745834, -0.017026137560606003, -0.0016760918078944087,
    0.003641461953520775, -0.01669737510383129, -0.007034973707050085, 0.010559480637311935, -0.0225211288779974, -0.027437405660748482, 0.006085260771214962, 0.026062093675136566,
    -0.013059276156127453, 0.011805982328951359, -0.02423468977212906, 0.07791922241449356, 0.02049071155488491, -0.021343128755688667, -0.038302745670080185, 0.062353719025850296,
    0.021435167640447617, -0.004706363193690777, 0.017546532675623894, 0.009250577539205551, 0.005740406922996044, -0.06706172227859497, 0.029236678034067154, 0.006942038424313068,
    -0.05710119381546974, -0.022678764536976814, 0.025893960148096085, -0.0021153679117560387, 0.025657279416918755, -0.018288157880306244, 0.00703284190967679, 0.013788840733468533,
    0.0017916490323841572, -0.011600247584283352, -0.009297194890677929, -0.018005844205617905, -0.007959394715726376, -0.01750802993774414, 0.031718213111162186, 0.009175911545753479,
    0.02965836226940155, 0.030481582507491112, -0.013609195128083229, -0.034328002482652664, -0.02862352505326271, 0.031270161271095276, 0.05986746400594711, -0.001561937853693962,
    -0.007333060260862112, -0.001957779750227928, -0.01632474735379219, 0.06814291328191757, 0.002049136906862259, -0.0031921083573251963, -0.03821433335542679, 0.009543830528855324,
    0.005084124393761158, 0.018325377255678177, -0.026993853971362114, -0.041492145508527756, 0.01011598389595747, -0.04625406116247177, 0.05184047669172287, 0.0030080918222665787,
    -0.014688735827803612, -0.0381157360970974, -0.0038294224068522453, -0.024220814928412437, 0.006355168763548136, -0.017853209748864174, -0.012165558524429798, -0.01229808758944273,
    -0.03198587894439697, -0.019844135269522667, 0.00822294969111681, -0.015565498732030392, -0.010595954023301601, -0.02813877910375595, 0.023725459352135658, -0.00465699378401041,
    -0.00786567758768797, -0.0038209310732781887, 0.021927401423454285, 0.03168265148997307, 0.009900378063321114, 0.0011119800619781017, -0.0025014218408614397, 0.03670158609747887,
    0.0012207921827211976, -0.009984179399907589, 0.03696400299668312, 0.06408268213272095, -0.03690500929951668, 0.018868830054998398, 0.008640472777187824, 0.0026128143072128296,
    -0.016116954386234283, -0.007580577861517668, 0.048684343695640564, 0.019819321110844612, 0.020437195897102356, -0.013810144737362862, -0.0022234616335481405, 0.04944564029574394,
    -0.008714777417480946, -0.016211623325943947, -0.02082057297229767, 0.005109572317451239, -0.055919431149959564, -0.016288353130221367, 0.04374707117676735, 0.0005774602177552879,
    -0.004542962647974491, 0.015341365709900856, 0.025985505431890488, -0.02674148604273796, 0.04397561028599739, 0.014991726726293564, -0.05315034091472626, -0.0015825179871171713,
    0.02148420549929142, 0.0012188645778223872, -0.01885918155312538, 0.039319463074207306, 0.01595493219792843, 0.05260644108057022, 0.04161185026168823, -0.04588884487748146,
    0.02489762380719185, 0.006344534922391176, -0.013343054801225662, 0.03546178340911865, -0.03246073052287102, 0.006364088039845228, 0.041151948273181915, -0.025698546320199966,
    -0.007358700968325138, -0.0755041316151619, 0.029463695362210274, 0.04700395464897156, 0.024140994995832443, 0.041458576917648315, 0.04654809087514877, -0.08175017684698105,
    -0.01243356242775917, -0.011418487876653671, 0.04641447961330414, -0.029446488246321678, 0.025947829708456993, 0.0007766346680000424, -0.01848611794412136, -0.002412074478343129,
    0.0023302570916712284, -0.023912394419312477, 0.029133839532732964, 0.02052587829530239, -0.005916030611842871, 0.03134152665734291, -0.01105042640119791, -0.01009360607713461,
    0.0329902358353138, 0.011248110793530941, 0.030749021098017693, -0.020222308114171028, 0.0017101909033954144, -0.03405583277344704, 0.02394658699631691, -0.01268817763775587,
    -0.014053557999432087, -0.0024749364238232374, 0.02122102491557598, 0.026588616892695427, -0.023489734157919884, -0.03528701886534691, 0.04447055980563164, -0.04402273893356323,
    -0.01943347416818142, -0.023054402321577072, 0.008532180450856686, -0.00627886550500989, 0.03661663830280304, 0.007845418527722359, 0.012474363669753075, 0.007302604150027037,
    0.011496484279632568, 0.008595388382673264, -0.023624058812856674, -0.006815983913838863, 0.025223825126886368, -0.0180765800178051, -0.02444429136812687, 0.017117492854595184,
    0.0015557840233668685, -0.035481132566928864, 0.009201828390359879, 0.0002377986820647493, -0.027984775602817535, 0.005135801155120134, -0.030108720064163208, 0.0029427672270685434,
    0.0463465191423893, -0.01340826228260994, 0.009016355499625206, 0.0286884605884552, 0.059188347309827805, -0.005451083183288574, 0.007797927130013704, 0.067212775349617,
    0.019246943295001984, -0.004237946588546038, -0.02046063169836998, -0.023134034126996994, -0.02680346556007862, 0.00502478564158082, -0.034444134682416916, -0.021865881979465485,
    -0.02381008304655552, -0.0038615218363702297, -0.036879219114780426, -0.03695417568087578, -0.012919457629323006, -0.05987561494112015, 0.01798800565302372, 0.006153410766273737,
    -0.031492944806814194, -0.023075265809893608, 0.038832928985357285, 0.01996455527842045, 0.018753955140709877, -0.056537386029958725, 0.03518867865204811, 0.03127594664692879,
    -0.03729834035038948, 0.02585488185286522, 0.015776045620441437, -0.011598415672779083, -0.056980110704898834, 0.016101446002721786, 0.022729838266968727, 0.021533094346523285,
    0.033470600843429565, -0.01969684101641178, 0.017540069296956062, -0.013904789462685585, -0.013514009304344654, 0.04428607225418091, 0.04526684805750847, -0.008739795535802841,
    -0.026377424597740173, 0.008322966285049915, -0.019116953015327454, 0.03195253387093544, 0.008865222334861755, -0.0323665477335453, 0.008765118196606636, 0.01890549063682556,
    -0.037207793444395065, 0.01989586651325226, 0.00771894957870245, 0.0059151118621230125, 0.01044557336717844, -0.0030317571945488453, -0.06349270790815353, -0.01395649928599596,
    0.019974319264292717, 0.010643752291798592, 0.012202375568449497, 0.020887341350317, -0.0015188812976703048, -0.04157103970646858, -0.03536515682935715, 0.0332782082259655,
    -0.019280852749943733, -0.04595955088734627, -0.022867638617753983, 0.002552753547206521, -0.04971165582537651, -0.005277086980640888, -0.016524340957403183, 0.04395200312137604,
    0.026484956964850426, -0.012343311682343483, 0.033525921404361725, -0.009235027246177197, 0.005606381688266993, -0.0014481812249869108, 0.0004961517406627536, 0.010662670247256756,
    0.03328166902065277, 0.045686349272727966, -0.05497132986783981, 0.02350250631570816, 0.008085313253104687, 0.025713959708809853, 0.0019416147843003273, -0.0203513503074646,
    0.0034900156315416098, -0.000646206084638834, 0.0009036845876835287, 0.06495430320501328, 0.0032634229864925146, -0.041234489530324936, -0.04326760768890381, 0.046466417610645294,
    -0.01748630590736866, 0.026483234018087387, -0.009960326366126537, 0.017117802053689957, -0.03130180388689041, -0.004269665107131004, -0.04243100807070732, 0.036947403103113174,
    0.017268244177103043, -0.002511626109480858, 0.02568557672202587, 0.020658012479543686, -0.006071767769753933, 0.011496419087052345, 0.008880557492375374, 0.03885870799422264,
    0.007081742864102125, 0.0145803764462471, 0.0021350516472011805, 0.006804714445024729, 0.024471132084727287, 0.027819223701953888, -0.01401966530829668, -0.02404450625181198,
    0.09118307381868362, 0.06219297647476196, -0.013085691258311272, 0.0019910300616174936, -0.03649865463376045, 0.02494613081216812, 0.06111794337630272, 0.009734680876135826,
    -0.0060423268005251884, 0.008198587223887444, 0.031352218240499496, 0.0048784832470119, -0.04478754848241806, 0.010577445849776268, 0.03711772337555885, -0.03278270363807678,
    0.021552542224526405, -0.0021304318215698004, 0.028830109164118767, -0.020319009199738503, -0.017111705616116524, 0.001244844519533217, 0.02277423068881035, -0.03398406133055687,
    0.0559503398835659, -0.046198125928640366, -0.028858115896582603, 0.03708669915795326, -0.047718580812215805, -0.015387995168566704, 0.014701624400913715, 0.004521702416241169,
    -0.03765392675995827, -0.016646306961774826, 0.03910619020462036, 2.171053711208515e-05, -0.0457451306283474, -0.04812416806817055, 0.01306196115911007, -0.0016010233666747808,
    0.027519231662154198, 0.034232866019010544, -0.03797745704650879, 0.012925121001899242, 0.019861510023474693, 0.010211129672825336, -0.040854353457689285, 0.015848428010940552,
    0.02158438228070736, 0.03436841815710068, -0.041586633771657944, 0.019163411110639572, -0.011881220154464245, -0.002951157744973898, 0.010807855986058712, -0.0064313532784581184,
    -0.0005596870905719697, 0.024905048310756683, 0.011788791045546532, 0.028888169676065445, 0.012693910859525204, -0.038119830191135406, 0.0034272021148353815, -0.021553214639425278,
    0.012152060866355896, -0.013404624536633492, 0.016991514712572098, 0.015998272225260735, 0.007707539014518261, 0.050459202378988266, -0.014689620584249496, 0.06326670199632645,
    0.026632120832800865, -0.02333931252360344, -0.025486059486865997, 0.02316863089799881, 0.018505699932575226, -0.00838351808488369, -0.025554658845067024, 0.04896968975663185,
    0.015446624718606472, 0.0025334861129522324, 0.0022978743072599173, -0.041556552052497864, 0.013474076986312866, 0.018081465736031532, -0.0005520650302059948, 0.018923943862318993,
    -0.06063432618975639, -4.655956581700593e-05, 0.016507882624864578, -0.025436341762542725, 0.0029197128023952246, -0.0098532410338521, 0.0004693055816460401, 0.01931428164243698,
    0.019106946885585785, 0.03084297850728035, -0.0688035637140274, -0.0018411950441077352, 0.01626814343035221, 0.05140920355916023, 0.00011423445539548993, -0.015935227274894714,
    -0.0526566319167614, 0.0018671824363991618, 0.006900726817548275, 0.039160195738077164, 0.03542916104197502, 0.013792881742119789, -0.02808154560625553, -0.013781661167740822,
    0.011364494450390339, -0.000961913785431534, -0.040682945400476456, -0.023740047588944435, 0.005538045894354582, -0.0053466083481907845, 0.019542265683412552, -0.022307273000478745,
    -0.008028711192309856, 0.03672501817345619, 0.03565138578414917, 0.02119370922446251, -0.01485266350209713, -0.01733585074543953, 0.015736522153019905, -0.0009693123865872622,
    -0.002813913393765688, 0.026860849931836128, -0.012954538688063622, -0.03765202686190605, 0.02266819402575493, -0.0025841593742370605, 0.047008540481328964, 0.0027234219014644623,
    -0.026030326262116432, -0.0067346664145588875, -0.008098413236439228, -0.01831863261759281, -0.010702481493353844, 0.007071133237332106, -0.0061808992177248, 0.046654775738716125,
    -0.027593085542321205, -0.008351240307092667, 0.00245444243773818, 0.04026396572589874, 0.009904284030199051, 0.06736017018556595, -0.02394004724919796, 0.012715090066194534,
    -0.017079660668969154, -0.0302774328738451, -0.009820154868066311, -0.029299233108758926, 0.014322888106107712, 0.051531318575143814, -0.028833827003836632, -0.004805449862033129,
    0.022355414927005768, -0.005438476335257292, -0.023395583033561707, -0.010675954632461071, -0.03316359594464302, 0.022863395512104034, -0.01615777052938938, -0.043166883289813995,
    -0.007682109251618385, -0.028943052515387535, 0.003406127914786339, -0.031948819756507874, 0.0041065942496061325, -0.00248211738653481, -0.024810057133436203, -0.011794023215770721,
    -0.03834744542837143, -0.003981528803706169, -0.011979238130152225, -0.010404041036963463, -0.0016512342263013124, -0.04218728467822075, -0.012813613750040531, -0.029051659628748894,
    -0.010743044316768646, 0.019875051453709602, 0.01939336583018303, 0.033027831465005875, -0.03357269614934921, 0.0020726968068629503, -0.02599676512181759, -0.015666665509343147,
    -0.018792981281876564, -0.011038891971111298, 0.013403214514255524, 0.041619572788476944, -0.02655673958361149, 0.03266151621937752, 0.02228333242237568, -0.04130205512046814,
    0.0036454517394304276, -0.040064290165901184, -0.008589920587837696, -0.014934164471924305, 7.312900834222091e-06, -0.009089319966733456, 0.03216773644089699, 0.007983277551829815,
    0.03642965853214264, 0.004416997544467449, 0.035711869597435, -0.026105623692274094, -0.005535820499062538, 0.014158498495817184, 0.05578675493597984, -0.04448346793651581,
    -0.043798334896564484, -0.029284322634339333, -0.0058464547619223595, -0.002343405270949006, 0.0013952723238617182, 0.001661997870542109, 0.036678384989500046, -0.0054486035369336605,
    0.008401344530284405, -0.011036939918994904, -0.03584471344947815, -0.026812123134732246, -0.009174548089504242, 0.033158764243125916, -0.014909536577761173, -0.06117023900151253,
    -0.044165585190057755, 0.011996068060398102, -0.00801317673176527, -0.031586211174726486, 0.006769408006221056, -4.930786235490814e-05, 0.026007259264588356, 0.0020530635956674814,
    -0.00983121246099472, 0.032774899154901505, -0.019885942339897156, 0.020387742668390274, 0.0057913572527468204, 0.0008626016206108034, 0.01844436675310135, -0.002084203762933612,
    0.007649039849638939, 0.007094468455761671, 0.023949183523654938, 0.040132787078619, 0.005778630264103413, 0.007988237775862217, 0.011401373893022537, -0.002262731781229377,
    0.010415002703666687, 0.01929960586130619, 0.030753839761018753, 0.0122994938865304, 0.06298628449440002, 0.006187840364873409, 0.00901474803686142, 0.044422704726457596,
    -0.010739495046436787, 0.012774630449712276, 0.010721475817263126, 0.02569035068154335, 0.02492927573621273, 0.019585486501455307, -0.011875558644533157, 0.017207639291882515,
    -0.008206017315387726, 0.014615599997341633, -0.014256036840379238, 0.03818397596478462, 0.003374551422894001, -0.03783315792679787, -0.0006165103986859322, -0.0404428131878376,
    -0.043625958263874054, 0.0110907182097435, 0.01610269583761692, 0.020287390798330307, -0.03227720409631729, 0.00825255922973156, -0.004142113495618105, -0.004490851424634457,
    -0.01923205330967903, -0.004137354902923107, -0.005083578638732433, -0.011827593669295311, -0.01732403226196766, 0.054241955280303955, 0.0006959015154279768, -0.012988421134650707,
    0.0003014066314790398, 0.00992658082395792, 0.028579650446772575, 0.010516817681491375, -0.007010664790868759, 0.026283923536539078, 0.009899369440972805, 0.020562704652547836,
    0.00732692563906312, -0.02767934836447239, 0.0011336980387568474, -0.06238890066742897, 0.010346414521336555, -0.0556369423866272, -0.006689512636512518, -0.029316788539290428,
    0.02045619487762451, -0.05653294175863266, -0.06129247322678566, -0.0015690289437770844, -0.0629417896270752, -0.0038736709393560886, -0.02015957236289978, 0.011900700628757477,
    0.007060698699206114, 0.014803334139287472, -0.006944526918232441, -0.024392420426011086, 0.012494887225329876, 0.047371331602334976, 0.026480164378881454, 0.021109338849782944,
    0.007560366299003363, -0.03877897560596466, -0.006602464243769646, 0.04246869310736656, -0.012674958445131779, 0.006176957860589027, -0.016562586650252342, -0.017433416098356247,
    0.028049541637301445, 0.019321748986840248, 0.02105027250945568, 0.04620872810482979, -0.0014994130469858646, -0.009174035862088203, 0.04583391174674034, 0.021100500598549843,
    -0.0024527173954993486, -0.03317273408174515, 0.01114578451961279, 0.004889307543635368, -0.026714108884334564, 0.03100767731666565, -0.026467105373740196, -0.00610756129026413,
    -0.011653426103293896, 0.025680141523480415, -0.03860853239893913, -0.01225610077381134, -0.022493235766887665, -0.044365569949150085, 0.01375516876578331, 0.014665411785244942,
    0.0006946784560568631, 0.006325665861368179, 0.014281224459409714, -0.019459236413240433, -0.021373489871621132, -0.07137838751077652, 0.027967995032668114, 0.01753726787865162,
    -0.000903273350559175, -0.005256991367787123, 0.046747952699661255, -0.03496461361646652, -0.03422730788588524, -0.03365766257047653, 0.029892411082983017, -0.010399631224572659,
    -0.020769333466887474, 0.009006872773170471, -0.03916558623313904, -0.039203714579343796, 0.015405640006065369, -0.014922776259481907, 0.02136710099875927, 0.034206412732601166,
    0.05151798576116562, 0.025913912802934647, -0.02894589677453041, 0.015389583073556423, -0.033047083765268326, -0.030370276421308517, 0.04309069365262985, -0.0009535617427900434,
    0.006682461127638817, -0.025207117199897766, 0.0026089875027537346, 0.00848712120205164, 0.012581683695316315, 0.005641194060444832, 0.00013465189840644598, -0.011966276913881302,
    -0.006348045542836189, -0.018839659169316292, -0.0009133722633123398, -0.003237939439713955, 0.010028442367911339, 0.025136670097708702, -0.013730575330555439, 0.025661323219537735,
    0.0033017306122928858, 0.006535328458994627, 0.00149484199937433, 0.004399918485432863, -0.009510701522231102, -0.06319458037614822, 0.018099432811141014, 0.031181883066892624,
    0.021138424053788185, 0.009698241017758846, 0.030340081080794334, 0.03999816253781319, 0.007407112047076225, -0.0218694768846035, -0.05610543116927147, -0.0054479846730828285,
    -0.011820564977824688, -0.023627283051609993, -0.038311365991830826, -0.0013014917494729161, 0.04055080562829971, -0.049932811409235, -0.040475476533174515, -0.02979119122028351,
    0.03470582142472267, 0.02005618065595627, -0.029064830392599106, -0.027076777070760727, -0.01872241497039795, 0.029001720249652863, -0.002153709763661027, 0.007865015417337418,
    -0.02878657914698124, -0.03328363224864006, 0.000510192709043622, -0.06150272861123085, -0.0182806309312582, 0.06912212073802948, -0.004156188108026981, 0.037562355399131775,
    -0.022701222449541092, -0.039148055016994476, -0.03796440735459328, -0.0059577482752501965, -0.02837943285703659, 0.046219393610954285, 0.009962115436792374, 0.026994401589035988,
    0.001977232750505209, -0.016989268362522125, -0.003267796477302909, -0.046081043779850006, 0.03197585791349411, 0.04107930138707161, 0.013589269481599331, -0.032167594879865646,
    0.00650414451956749, 0.005888587795197964, -0.06467798352241516, 0.002137354575097561, -0.021252324804663658, 0.012898216024041176, 0.01686074770987034, 0.006540109869092703,
    0.01582024060189724, 0.0046134511940181255, -0.018118305131793022, 0.02288520708680153, -0.008398054167628288, -0.05263233184814453, 0.011161290109157562, 0.01698261685669422,
    0.02365163527429104, -0.01839407905936241, -0.055905167013406754, 0.06096680089831352, -0.015260109677910805, 0.003973225597292185, 0.028623266145586967, 0.004482395015656948,
    -0.018638603389263153, -0.04498632624745369, 0.000392673333408311, -0.007290179841220379, -0.009449289180338383, -0.044394221156835556, -0.0101269306614995, -0.0037651422899216413,
    -0.013255266472697258, 0.006910579279065132, -0.03672080114483833, -0.012282279320061207, -0.01378230657428503, 0.015661053359508514, 0.016948699951171875, 0.04729265347123146,
    -0.03167281299829483, 0.009210113435983658, 0.015372305177152157, -0.004991333000361919, -0.03318001329898834, -0.022257475182414055, -0.0025444820057600737, -0.0042030648328363895,
    0.014594441279768944, -0.08830192685127258, -0.02001550979912281, 0.024329042062163353, 0.013485242612659931, -0.010130193084478378, 0.0700274333357811, -0.05627034977078438,
    -0.020989064127206802, -0.010491272434592247, 0.011757375672459602, -0.009709841571748257, -0.018781401216983795, -0.012037411332130432, 0.03109845146536827, -0.03410385921597481,
    0.03367242589592934, 0.03242180868983269, 0.048258889466524124, 0.04211850091814995, 0.05128585174679756, -0.016194390133023262, -0.005547632928937674, 0.015066736377775669,
    0.030305778607726097, -0.01010677870362997, 0.022318627685308456, 0.015464497730135918, 0.01735536940395832, 0.012189404107630253, -0.008589374832808971, 0.010307317599654198,
    -0.0023566128220409155, -0.010959622450172901, -0.03594569116830826, -0.03956412151455879, 0.02596864104270935, -0.02982720360159874, 0.02129487693309784, 0.028662893921136856,
    0.022291652858257294, -0.02840823493897915, 0.004191352054476738, 0.02458227053284645, 0.010571968741714954, -0.03756270930171013, 0.021159594878554344, 0.01927242986857891,
    0.014842423610389233, 0.011511498130857944, -0.024362262338399887, -0.014859762042760849, 0.03309367969632149, -0.005302039440721273, 0.05806966498494148, 0.015510346740484238,
    0.012567290104925632, -0.007292131427675486, -0.0002005702117457986, 0.0006784458528272808, -0.02538292668759823, 0.01031527854502201, -0.025140877813100815, -0.058361660689115524,
    0.0009993350831791759, 0.0014541435521095991, 0.0037375183310359716, -0.03006446734070778, 0.05393609404563904, 0.06229093298316002, 0.004565236158668995, -0.02190946601331234,
    0.0030230931006371975, -0.049844708293676376, 0.034559037536382675, 0.019244778901338577, 0.000797612767200917, 0.032062362879514694, -0.010349237360060215, 0.028825296089053154,
    -0.007724998984485865, 0.0036091802176088095, 0.018033349886536598, -0.027344774454832077, 0.01409322302788496, -0.0119449682533741, -0.002778977621346712, -0.021071000024676323,
    0.00827574823051691, 0.024110322818160057, 0.05253829434514046, -0.0334959514439106, 0.007500107400119305, 0.013286505825817585, 0.026721050962805748, -0.01980636827647686,
    -0.029922811314463615, 0.03831605240702629, -0.030751459300518036, -0.040951669216156006, 0.02435830980539322, -0.014816764742136002, -0.04684807360172272, 0.036809615790843964,
    0.007088944781571627, 0.032507795840501785, 0.0077611044980585575, -0.040460072457790375, 0.05374358966946602, 0.0388464480638504, 0.010092348791658878, 0.05141609162092209,
    -0.029312001541256905, 0.03320476412773132, -0.01583913341164589, 0.041100744158029556, -0.03288989141583443, 0.04776295647025108, -0.01303638331592083, 0.027622414752840996,
    0.013245833106338978, 0.0029225009493529797, 0.0074070109985768795, -0.049138009548187256, 0.012519166804850101, -0.012152066454291344, -0.0037657846696674824, 0.007611723151057959,
    0.013360423967242241, -0.00038590707117691636, -0.025847043842077255, -0.03969142585992813, 0.004869629628956318, -0.016669927164912224, 0.04180467128753662, -0.016426362097263336,
    0.011708317324519157, 0.009685688652098179, 0.015580964274704456, 0.026208017021417618, -0.001234669703990221, 0.05979562923312187, 0.01033809594810009, -0.00288778287358582,
    -0.01611076109111309, -0.015252653509378433, -0.038492005318403244, 0.011221261695027351, 0.05567700043320656, -0.0486142672598362, 0.007537058088928461, 0.015875963494181633,
    -0.02526625245809555, -0.011328917928040028, -0.011734933592379093, 0.01162160187959671, -0.014830890111625195, 0.005335799418389797, 0.02718784287571907, 0.022124791517853737,
    0.010437825694680214, -0.023802272975444794, -0.006218512076884508, -0.0055871400982141495, 0.021468395367264748, 0.013808319345116615, 0.019185619428753853, 0.031300418078899384,
    -0.0012201998615637422, 0.024629566818475723, -0.0003184575471095741, 0.054115209728479385, -0.00609930232167244, 0.012367768213152885, 0.021121492609381676, 0.018360560759902,
    -0.022673388943076134, -0.041923947632312775, 0.005859253462404013, -0.02226240001618862, -0.008645846508443356, -0.020054996013641357, 5.2743114792974666e-05, 0.010870599187910557,
    -0.009318855591118336, -0.007325686980038881, -0.001790412818081677, -0.05969022214412689, -0.030207373201847076, -0.0037874067202210426, -0.013776646926999092, 0.02097264863550663,
    0.016169019043445587, -0.031099095940589905, 0.010175810195505619, 0.028086261823773384, -0.006645184475928545, 0.02758781798183918, 0.017908383160829544, -0.00206353678368032,
    -0.016564564779400826, -0.07391127198934555, -0.039851609617471695, -0.0008577486732974648, -0.032358333468437195, 0.008871993981301785, -0.036368515342473984, 0.05373089760541916,
    0.019885335117578506, -0.042601052671670914, 0.005749126430600882, 0.00402818014845252, 5.00364440085832e-05, 0.02167770266532898, -0.024198904633522034, -0.016296660527586937,
    0.017659103497862816, 0.0008434599149040878, 0.004234469961374998, 0.0033470180351287127, -0.02063630521297455, 0.009546122513711452, -0.004450091626495123, -0.04304198548197746,
    0.028473664075136185, 0.01159107219427824, 0.017177561298012733, -0.029585016891360283, -0.00791497714817524, -0.02075240947306156, -0.009425978176295757, -0.016996901482343674,
    0.004984007216989994, -0.03313453495502472, 0.002256534295156598, 0.015213487669825554, 0.004415192641317844, 0.0051910183392465115, 0.04058046266436577, -0.0037268127780407667,
    0.025641562417149544, 0.03777433931827545, -0.020856056362390518, 0.007227963302284479, -0.02595982328057289, 0.024478835985064507, -0.015846751630306244, -0.011528111062943935,
    0.013316425494849682, 0.013156087137758732, 0.001058101188391447, -0.03126375377178192, -0.004907018505036831, -0.029092585667967796, 0.022103222087025642, 0.0048138475976884365,
    0.02959645353257656, 0.042514849454164505, -0.010477225296199322, -0.014963415451347828, -0.007522213738411665, 0.02685651369392872, -0.012585144490003586, -0.03825791925191879,
    -0.02941439300775528, 0.024876607581973076, 0.009182886220514774, -0.016156818717718124, -0.03764437511563301, -0.03778000921010971, -0.016711827367544174, 0.015757199376821518,
    -0.013191178441047668, 0.0034481568727642298, 0.024651963263750076, -0.025873159989714622, 0.000448087346740067, 0.004569300450384617, 0.01239802222698927, 0.012373104691505432,
    0.040869176387786865, -0.02555190958082676, -0.045910533517599106, 0.03602587804198265, -0.01727999933063984, -0.03712267056107521, 0.037926509976387024, 0.010721112601459026,
    -0.023705827072262764, -0.013911155983805656, 0.024569347500801086, -0.0042666299268603325, -0.017179913818836212, 0.022871697321534157, -0.0015325723215937614, -0.04964560642838478,
    0.0061455098912119865, -0.019844800233840942, 0.006679139565676451, 0.056333526968955994, -0.012123415246605873, -0.025982046499848366, 0.037165284156799316, 0.00988180935382843,
    0.022027533501386642, 0.011003692634403706, 0.0026240996085107327, 0.009183311834931374, 0.006680479273200035, -0.003931999672204256, 0.002760006347671151, -0.030280768871307373,
    -0.017335008829832077, -0.024858208373188972, 0.03534640371799469, 0.038512010127305984, -0.004424532875418663, 0.008549002930521965, -0.013101551681756973, -0.017095377668738365,
    0.002285582944750786, 0.026320289820432663, 0.020259708166122437, -0.05928710475564003, -0.012838621623814106, 0.014748846180737019, -0.009631816297769547, 0.010531242936849594,
    -0.015213225036859512, -0.016111906617879868, -0.005227148998528719, -0.008215843699872494, 0.02313724346458912, -0.014254031702876091, 0.012055778875946999, -0.018626920878887177,
    -0.031438156962394714, 0.024788714945316315, -0.02216515503823757, 0.0043050977401435375, 0.008560952730476856, -0.005530791822820902, 0.017243247479200363, 0.032891832292079926,
    -0.04197244718670845, -0.01244133710861206, 0.03599601238965988, 0.02658623270690441, -0.01945059560239315, -0.029025565832853317, -0.04919040575623512, -0.012189017608761787,
    0.04763048142194748, -0.003683161921799183, -0.03463394567370415, 0.02993815951049328, -0.020805027335882187, 0.010846609249711037, -0.0693054348230362, 0.02715839259326458,
    -0.045913130044937134, 0.037484146654605865, -0.006276894826442003, 0.02973383106291294, -0.01906503736972809, 0.00011583478044485673, 0.007693693041801453, -0.02144353836774826,
    0.004732930567115545, -0.010896415449678898, 0.01133774034678936, -0.02915768139064312, -0.0026541873812675476, -0.01379088032990694, 0.036853790283203125, -0.011159206740558147,
    -0.016961881890892982, 0.001298886607401073, 0.03000900149345398, 0.01944015361368656, 0.020635059103369713, 0.009967876598238945, 0.016832929104566574, -0.005847151856869459,
    0.048681292682886124, 0.00761039275676012, -0.02293134666979313, -0.014143839478492737, 0.007702050264924765, -0.0004720896831713617, -0.028135180473327637, 0.017877958714962006,
    0.01861422322690487, 0.0390051044523716, -0.004198815207928419, 0.04838882014155388, 0.01967080682516098, -0.014413975179195404, -0.009708057157695293, -0.015125039033591747,
    0.020970700308680534, 0.01009772066026926, 0.0024338376242667437, -0.0034042317420244217, -0.03774390369653702, 0.029264885932207108, 0.004626702982932329, 0.0015111472457647324,
    -0.0492081344127655, 0.015290766954421997, -0.025797246024012566, -0.01141389086842537, 0.045469000935554504, 0.010839376598596573, 0.006586592178791761, -0.012230664491653442,
    -0.001454705256037414, 0.016989318653941154, 0.0029691378585994244, -0.023970263078808784, -0.025153184309601784, -0.0014263498596847057, -0.016185492277145386, 0.04154109209775925,
    -0.015211688354611397, 0.029730144888162613, 0.006407464854419231, -0.012858957052230835, 0.047395169734954834, -0.004088991321623325, -0.008580222725868225, -0.013166753575205803,
    0.01293935813009739, -0.04429831728339195, 0.019050467759370804, 0.01089365966618061, 0.001187192159704864, 0.02376588247716427, 0.011894956231117249, -0.042986124753952026,
    0.04023411497473717, -0.01885438710451126, -0.02723202481865883, 0.021451300010085106, 0.029014525935053825, -0.03440304473042488, -0.01662336103618145, -0.0008078648243099451,
    -0.017684206366539, -0.008342203684151173, 0.002449129708111286, -0.02307029627263546, 0.01967654563486576, 0.012390674091875553, 0.022261545062065125, -0.04007000848650932,
    -0.007068580016493797, -0.0501069501042366, -0.030673934146761894, 0.029042908921837807, -0.0076811728067696095, 4.454414010979235e-05, 0.024486003443598747, -0.01749458722770214,
    -0.005427329335361719, -0.027867959812283516, -0.0030633306596428156, 0.020102715119719505, -0.006516657304018736, 0.004025553353130817, -0.015876201912760735, 4.823987910640426e-05,
    0.025884151458740234, 0.011713421903550625, 0.023465733975172043, -0.0024977128487080336, -0.009760514833033085, -0.012327352538704872, -0.00044486706610769033, 0.015331210568547249,
    -0.021945107728242874, 0.016979986801743507, -0.05594637989997864, -0.007749056909233332, -0.01240971963852644, -0.019597938284277916, 0.02127506025135517, -0.003981520887464285,
    -0.024450289085507393, 0.0022573245223611593, -0.0073706358671188354, 0.028599517419934273, -0.017123304307460785, -0.023825502023100853, -0.017353516072034836, 0.005223940126597881,
    0.01886671967804432, -0.024691898375749588, 0.014749485068023205, 0.025081809610128403, -0.028753848746418953, 0.016279755160212517, -0.034477438777685165, -0.016455581411719322,
    -0.07061180472373962, -0.019395384937524796, 0.04904317110776901, 0.00023875804618000984, -0.0032390013802796602, 0.002640052232891321, 0.01377920713275671, 0.021062888205051422,
    -0.01779300719499588, 0.020909281447529793, -0.013319380581378937, -0.025437576696276665, 0.022540464997291565, -0.03390083834528923, -0.006769291590899229, -0.016550032421946526,
    -0.014103560708463192, -0.02141997404396534, -0.03110424242913723, -0.03667684271931648, 0.04350435361266136, -0.009591951034963131, -0.001387165393680334, -0.03074123151600361,
    -0.0021151008550077677, -0.027446439489722252, -0.006329823285341263, 0.013023965060710907, 0.01798098348081112, -0.011056572198867798, 0.03937697038054466, 0.0469418540596962,
    -0.01492943987250328, -0.021721795201301575, -0.0035228105261921883, 0.029457390308380127, 0.0265488438308239, -0.012520164251327515, 0.0015425931196659803, -0.04657399281859398,
    0.052093349397182465, 0.030708782374858856, -0.04606151580810547, -0.009960896335542202, 0.03540389612317085, 0.01374833658337593, -0.03430523723363876, 0.01564778946340084,
    0.007606071420013905, -0.019541962072253227, 0.014421265572309494, 0.02549087069928646, 0.014626755379140377, -0.04198897257447243, 0.008905075490474701, 0.021753085777163506,
    -0.019147278741002083, 0.047030556946992874, -0.0044838241301476955, -0.046944454312324524, -0.017527414485812187, -0.005167397204786539, 0.010922444052994251, 0.025533368811011314,
    -0.015600777231156826, 0.010652387514710426, -0.01944168470799923, 0.02789243683218956, -0.027605600655078888, 0.0192731861025095, -0.024658327922225, -0.027763348072767258,
    0.025398174300789833, -0.017008643597364426, -0.022337613627314568, -0.014381647109985352, -0.02121897228062153, 0.041755445301532745, -0.011921803466975689, 0.022665346041321754,
    0.00485540647059679, -0.02207990735769272, 0.0017315527657046914, 0.009863367304205894, -0.02167525887489319, 0.04476847127079964, 0.004604528192430735, 0.05118536949157715,
    0.060887422412633896, -0.018910380080342293, 0.007098641712218523, -0.01297431718558073, 0.0006364135188050568, -0.012683525681495667, -0.002824486931785941, 0.030084526166319847,
    0.05971081182360649, 0.006650426425039768, -0.007808090187609196, -0.02767033502459526, -0.00467293243855238, 0.016044339165091515, 0.0064961276948452, 0.009700759314000607,
    0.014408120885491371, 0.0006818627007305622, -0.014767847023904324, -0.004857971798628569, -0.01013246737420559, -0.04007904976606369, -0.011484398506581783, 0.016832619905471802,
    -0.021529709920287132, -0.0008558770059607923, 0.014864234253764153, -0.020868318155407906, 0.048296790570020676, -0.030611176043748856, -0.0011351851280778646, -0.021210642531514168,
    -0.005775124300271273, -0.011135063134133816, 0.05484502390027046, 0.01905156299471855, -0.03518805652856827, 0.034037839621305466, -0.02112402208149433, 0.02603697031736374,
    -0.0022866856306791306, 0.0059425137005746365, -0.01656443625688553, -0.01790112629532814, 0.0006184601807035506, -0.020831821486353874, -0.009787020273506641, 0.007951402105391026,
    0.01440610084682703, 0.04452395439147949, -0.03049043007194996, 0.0029173053335398436, -0.026101844385266304, 0.022243158891797066, 0.042268943041563034, 0.040267884731292725,
    0.025189248844981194, 0.0032487690914422274, 0.02190564200282097, -0.0167985986918211, 0.002798010827973485, -0.01509169116616249, -0.028465116396546364, 0.023710371926426888,
    -0.008912571705877781, 0.02947649545967579, 0.008219231851398945, 0.006608187686651945, -0.00028499230393208563, 0.0005804016254842281, 0.0202788095921278, 0.0031840340234339237,
    0.036980435252189636, 0.010830189101397991, -0.03136949613690376, -0.0316198393702507, -0.0006720342207700014, 0.004170017316937447, -0.05976206436753273, -0.026600904762744904,
    0.002073991345241666, -0.0487995408475399, 0.029549824073910713, 0.01847386360168457, -0.06288239359855652, -0.05122225731611252, 0.003536153119057417, 0.009622977115213871,
    -0.009364908561110497, -0.0027050457429140806, -0.001054431893862784, 0.022396234795451164, 0.02001109905540943, 0.026225000619888306, -0.017950693145394325, 0.017949460074305534,
    0.03221709281206131, -0.0068400343880057335, -0.0037006582133471966, 0.0159095898270607, -0.0048127626068890095, 0.02794099599123001, -0.025748305022716522, -0.007184733636677265,
    0.040948934853076935, -0.02461998723447323, -0.052853718400001526, -0.0025524499360471964, 0.022473640739917755, -0.00663843285292387, -0.0015522724715992808, 0.06430619955062866,
    -0.019736289978027344, 0.006535945925861597, 0.030510950833559036, -0.04735182970762253, -0.00070605194196105, 0.000571821175981313, -0.00432777451351285, -0.0006680201622657478,
    -0.0008676990400999784, 0.02919994480907917, 0.010843363590538502, -0.022015340626239777, -0.01708967611193657, -0.030983425676822662, 0.03393155708909035, -0.016031790524721146,
    -0.023635709658265114, -0.029080266132950783, -0.029254138469696045, -0.02650202438235283, 0.004540249705314636, 0.0048012337647378445, 0.046985041350126266, -0.04888731986284256,
    0.003430658020079136, 0.0077631715685129166, 0.04239075630903244, 0.0008447962463833392, -0.03100094385445118, -0.004023449961096048, -0.03921620920300484, -0.016521012410521507,
    -0.0003201728977728635, -0.002614690689370036, -0.08118393272161484, -0.016138562932610512, -0.014730417169630527, -0.010300558991730213, 0.011732148006558418, 0.00895225815474987,
    0.020892521366477013, 0.01521364413201809, -0.009618463926017284, 0.061140771955251694, -0.004909302573651075, 0.0424591600894928, 0.024183860048651695, 0.02312544174492359,
    -0.0039709582924842834, -0.005202949047088623, 0.021846668794751167, 0.01248133834451437, 0.022632738575339317, 0.011040976271033287, -0.03211066871881485, 0.03143296763300896,
    -0.0051903314888477325, -0.03428465873003006, -0.029877351596951485, 0.013973202556371689, 0.00955141894519329, 0.009347542189061642, -0.023907920345664024, 0.0010402892949059606,
    0.015150261111557484, -0.04295347258448601, -0.014229604043066502, 0.014809811487793922, -0.00871807336807251, -0.008064850233495235, 0.01681477576494217, 0.01609840989112854,
    -0.017907047644257545, 0.04210089519619942, 0.004865709692239761, 0.022226592525839806, 0.0004665582673624158, 0.07449090480804443, -0.03037881664931774, -0.011126301251351833,
    -0.002229530829936266, -0.010676019825041294, 0.007107686251401901, -0.008436656557023525, -0.004924582317471504, 0.030865473672747612, 0.025387614965438843, 0.0017950410256162286,
    0.03178640827536583, 0.008298803120851517, -0.017445657402276993, -0.012611371465027332, 0.010824793949723244, 0.01267437543720007, 0.011213407851755619, 0.040311798453330994,
    0.0403047539293766, 0.057123731821775436, 0.019232215359807014, -0.00887613371014595, -0.05374758318066597, -0.016917584463953972, -0.05431487783789635, 0.009568891488015652,
    -0.00013239601685199887, -0.010816226713359356, -0.013448487967252731, 0.006009738892316818, -0.04123600572347641, 0.002060715574771166, 0.037953704595565796, -0.023054778575897217,
    0.02843601442873478, 0.011812139302492142, -0.04413723945617676, 0.021532244980335236, 0.005038161296397448, -0.06291227042675018, -0.006901170127093792, -0.0007733889506198466,
    -0.03244651108980179, 0.000560570100788027, -0.002941594459116459, 0.010788393206894398, -0.016402199864387512, 0.013019103556871414, -0.024820566177368164, -0.03302815929055214,
    0.04473397880792618, -0.00833069160580635, -0.008443980477750301, -0.05697016790509224, -0.018911924213171005, 0.042250726372003555, -0.010659429244697094, 0.005540922284126282,
    0.01288745179772377, 0.03336826711893082, -0.03777052462100983, 0.006685745902359486, 0.018003348261117935, 0.03965285047888756, 0.01536236610263586, 0.024605438113212585,
    -0.013780465349555016, -0.010559559799730778, -0.021132832393050194, 0.01197676733136177, -0.010548668913543224, -0.048376474529504776, 0.0645676776766777, 0.022878309711813927,
    0.0038955211639404297, 0.007106989622116089, 0.006260971538722515, 0.03438641130924225, 0.009997829794883728, 0.012170960195362568, 0.0513952299952507, -0.0389401949942112,
    0.0029746743384748697, 0.015489672310650349, -0.07083916664123535, 0.04995068907737732, -0.033319417387247086, -0.008196266368031502, 0.02668835036456585, 0.031728073954582214,
    0.03386833146214485, -0.03285522386431694, 0.004884189926087856, -0.03376459330320358, -0.012363996356725693, -0.014833752065896988, -0.04269082844257355, -0.021546024829149246,
    0.002292599296197295, -0.007816162891685963, 0.006582718808203936, -0.006556049920618534, 0.0040448750369250774, 0.0048092324286699295, -0.01097093429416418, 0.01656133309006691,
    6.780976400477812e-05, 0.041548293083906174, 0.0076066916808485985, -0.003473635297268629, 0.0071013206616044044, -0.02780056744813919, 0.02696218714118004, 0.01946117728948593,
    0.02107376791536808, 0.027919650077819824, -0.006069147493690252, 0.03214147314429283, 0.03345343470573425, 0.010252159088850021, 0.03591533750295639, -0.007079967763274908,
    0.010753592476248741, 0.030439702793955803, 0.010166000574827194, -0.013287018984556198, 0.005947116296738386, -0.036745890974998474, -0.04608186334371567, -0.02870665304362774,
    0.011370875872671604, 0.010903959162533283, -0.014020949602127075, -0.04601336643099785, -0.022577837109565735, 0.0022689523175358772, 0.0235580001026392, -0.013800542801618576,
    -0.05549545958638191, -0.00404574116691947, -8.210699161281809e-05, 0.017063036561012268, 0.0005426084389910102, -0.016162222251296043, -0.01659737527370453, 0.054051198065280914,
    0.007877900265157223, 0.013573743402957916, -0.023439522832632065, -0.03509144484996796, -0.029714662581682205, -0.021752964705228806, 0.007727238815277815, 0.044274456799030304,
    -0.01451148372143507, -0.013379749841988087, -0.018175926059484482, 0.0025288488250225782, 0.07206755876541138, -0.0472373440861702, 0.020646680146455765, 0.020008115097880363,
    0.00023376410536002368, -0.006258085370063782, 0.02581416629254818, 0.01075769029557705, -0.007416786625981331, -0.010548608377575874, -0.024594420567154884, -0.004719657823443413,
    0.02512124739587307, -0.016034750267863274, 0.01985463686287403, -0.031097369268536568, -0.01887103170156479, -0.029030324891209602, -0.02667185664176941, 0.0084846131503582,
    -0.03533455729484558, -0.021204890683293343, 0.018118202686309814, -0.05754156783223152, -0.018540913239121437, 0.031017189845442772, 0.010689237155020237, -0.07372482120990753,
    0.005163131281733513, 0.018111297860741615, -0.0015776195796206594, -0.04367586225271225, -0.01016803178936243, -0.0205905232578516, 0.027203325182199478, -0.028532953932881355,
    -0.05060017108917236, -0.049069859087467194, -0.04551089555025101, -4.355777127784677e-05, -0.008665302768349648, 0.023485669866204262, 0.05169815942645073, -0.030678309500217438,
    -0.012872849591076374, -0.00676076952368021, 0.03508128970861435, -0.06551526486873627, -0.012808195315301418, -0.011548873037099838, 0.03795022517442703, 0.019200680777430534,
    0.011128040961921215, -0.026171378791332245, -0.06223472207784653, 0.04680207744240761, -0.0062365056946873665, 0.0008617775747552514, -0.013846877962350845, 0.009570912458002567,
    0.014696522615849972, 0.0002933091018348932, 0.015585465356707573, -0.02491992712020874, -0.001691701472736895, 0.038712840527296066, 0.006251977756619453, -0.044941745698451996,
    -0.0005985261523164809, 0.0044965846464037895, -0.028605371713638306, -0.013634014874696732, 0.0009064902551472187, -0.015749486163258553, 0.014532887376844883, -0.02028599940240383,
    0.03343451768159866, 0.009531605057418346, 0.02345501072704792, 0.03227640315890312, 0.002093864604830742, -0.011375591158866882, -0.0003665691474452615, 0.0006459467695094645,
    0.023396698758006096, -0.013818490318953991, -0.02105962671339512, -0.010853763669729233, -0.014565011486411095, -0.019298942759633064, -0.03613036870956421, -0.00852638203650713,
    -0.0075426553376019, -0.020119236782193184, -0.0008949653129093349, -0.03676408901810646, 0.0013289275811985135, 0.018309051170945168, -0.05077855661511421, 0.02401917427778244,
    -0.04769538715481758, 0.021757416427135468, -0.010584836825728416, -0.0531231053173542, -0.012029867619276047, -0.02236148715019226, 0.03790602087974548, 0.018494319170713425,
    0.025766434147953987, -0.009879956021904945, -0.0207147765904665, 0.027022460475564003, 0.008716285228729248, -0.006037818267941475, -0.015570932067930698, 0.014007866382598877,
    0.023460600525140762, -0.011781059205532074, -0.05937662348151207, 0.018547099083662033, 0.039490967988967896, -0.021297138184309006, 0.0028820298612117767, 0.021068589761853218,
    0.022939201444387436, 0.008876236155629158, -0.004831323865801096, 0.014595101587474346, -0.07835543155670166, -0.005009910091757774, -0.006775276269763708, -0.030079223215579987,
    -0.025041406974196434, 0.03665711730718613, -0.004207854624837637, -0.012903201393783092, 0.008782160468399525, -0.020577190443873405, 0.02779514528810978, 0.0199288297444582,
    0.019382547587156296, -0.05044516921043396, -0.01951952837407589, -0.049339234828948975, -0.06252606958150864, 0.0010052341967821121, -0.022257816046476364, 0.024170149117708206,
    -0.01567382924258709, -0.01232501957565546, -0.017315682023763657, -0.02161998860538006, -0.03614600747823715, 0.03401168808341026, 0.013185548596084118, 0.014553344808518887,
    -0.00485275499522686, -0.009139187633991241, -0.07790696620941162, 0.01779097691178322, 0.0007931027212180197, -0.006425321102142334, 0.03689034655690193, -0.006952356547117233,
    0.015448382124304771, 0.02791370078921318, 0.00382764614187181, -0.0010384760098531842, -0.01078796572983265, -0.03182365000247955, 0.03456197679042816, 0.0031720336992293596,
    0.019715260714292526, 0.0027999551966786385, 0.044328462332487106, -0.03313326835632324, 0.0033014854416251183, -0.011462233029305935, -0.021616287529468536, 0.02583921141922474,
    -0.012950214557349682, 0.021067874506115913, -0.02275196835398674, -0.03144940361380577, 0.054889313876628876, 0.029222333803772926, 0.025492696091532707, 0.041943106800317764,
    0.0049096690490841866, 0.024325981736183167, 0.010226885788142681, -0.019908884540200233, 0.024939408525824547, -0.01976926065981388, 0.05671095848083496, -0.03559526801109314,
    0.019185783341526985, -0.009266220033168793, 0.002902566222473979, -0.01783536933362484, 0.015532967634499073, -0.008250650018453598, -0.0031347721815109253, -0.009439866058528423,
    0.014085846021771431, 0.039250072091817856, -0.007479741703718901, 0.002340198028832674, 0.005277605261653662, -0.004615333862602711, 0.0009506280184723437, 0.018735917285084724,
    -0.013851037248969078, -0.017141055315732956, 0.002357222605496645, 0.003727777861058712, 0.005673435516655445, -0.01395178772509098, -0.020714376121759415, 0.005212458781898022,
    -0.022532107308506966, 0.013006199151277542, 0.00879684928804636, 0.025240570306777954, 0.007552586030215025, -0.024263232946395874, -0.01441605482250452, 0.028838321566581726,
    0.018688224256038666, -0.006900623440742493, -0.004743107594549656, -0.03341161832213402, 0.009244757704436779, 0.0321207158267498, 0.06404964625835419, -0.01614542305469513,
    0.007752678822726011, -0.006388851907104254, 0.010168428532779217, 0.00885701086372137, -0.028603175655007362, -0.016501709818840027, -0.026762906461954117, -0.030527494847774506,
    0.04030125215649605, -0.018902910873293877, -0.025401871651411057, -0.03345673903822899, -0.020757896825671196, -0.011620805598795414, 0.010057072155177593, 0.011493739672005177,
    -0.030757330358028412, 0.0022042682394385338, -0.024204326793551445, 0.018628302961587906, 0.02700846642255783, -0.029302572831511497, -0.059839241206645966, 0.01555594615638256,
    0.027502190321683884, -0.019221261143684387, -0.0017849417636170983, -0.023762382566928864, 0.0005091775674372911, 0.017207611352205276, -0.04455941915512085, -0.039331648498773575,
    -0.023364076390862465, 0.02193756401538849, 0.01564258709549904, 0.0026674510445445776, -0.020921140909194946, -0.0020119077526032925, -0.02546563372015953, 0.03312717750668526,
    -0.005162556190043688, -0.033985789865255356, -0.0033563331235200167, -0.03358006477355957, -0.009260259568691254, -0.024907153099775314, 0.016141066327691078, -0.015099994838237762,
    0.004999904427677393, -0.003054352244362235, -0.03636520355939865, -0.004663164261728525, -0.010472549125552177, 0.02663072943687439, 0.028959311544895172, -0.012174544855952263,
    -0.01575862057507038, -0.026563197374343872, -0.02315812185406685, -0.028029710054397583, -0.005450946278870106, 0.002928496804088354, 0.008778568357229233, 0.023525618016719818,
    0.03309699892997742, 0.03507407382130623, 0.012806105427443981, -0.037071291357278824, 0.0024354855995625257, -0.009315435774624348, 0.03174090385437012, 0.027756549417972565,
    0.03101922757923603, -0.044997189193964005, -0.04024753347039223, 0.00015887364861555398, -0.025453219190239906, 0.009737471118569374, 0.0004226546734571457, -0.02703961171209812,
    -0.05115097016096115, -0.04795927181839943, 0.004960773512721062, -0.017838243395090103, -0.0056032645516097546, -0.02556467615067959, -0.061049968004226685, -0.02017189748585224,
    -0.013901381753385067, 0.007387648802250624, -0.025161653757095337, 0.03584570810198784, -0.031268082559108734, 0.04131114482879639, -0.00626404257491231, -0.030299795791506767,
    0.02477218210697174, 0.007299029268324375, -0.004454595502465963, 0.03456239029765129, 0.008260278031229973, 0.009233742021024227, 0.013379957526922226, -0.001571360044181347,
    0.01297694444656372, -0.006717585492879152, -0.011440022848546505, -0.0012327234726399183, -0.022809471935033798, 0.004125183913856745, 0.014143315143883228, -0.03167279064655304,
    0.004942942876368761, -0.003672837046906352, -0.07309187203645706, 0.004065059125423431, 0.0012826513266190886, 0.03347645327448845, -0.0060567366890609264, -0.028565244749188423,
    -0.0005808498826809227, 0.04349268600344658, -0.016535473987460136, -0.011891929432749748, -0.003771324409171939, 0.031258318573236465, -0.008731353096663952, -0.026898907497525215,
    0.0635104551911354, -0.029766857624053955, -0.03122737631201744, 0.01870601251721382, 0.002556096762418747, 0.05412030592560768, -0.008906853385269642, -0.016954747959971428,
    0.019581452012062073, -0.008377950638532639, -0.029098106548190117, 0.016009196639060974, -0.009745881892740726, 0.003916293382644653, -0.07235917448997498, 0.0292167030274868,
    -0.022640720009803772, -0.017479732632637024, 0.000948504894040525, 0.01642468199133873, -0.006155833136290312, -0.011741956695914268, 0.03471163287758827, 0.020961062982678413,
    0.019049035385251045, -0.04765467718243599, 0.01208404265344143, 0.04615502804517746, 0.00886517483741045, 0.01630701869726181, -0.03202559053897858, -0.01962888427078724,
    0.008255379274487495, 0.03221840411424637, -0.05448851361870766, 0.005469138268381357, -0.004877517465502024, -0.0024287858977913857, -0.024558251723647118, -0.0348423570394516,
    0.04804137349128723, -0.014533181674778461, 0.002895126584917307, 0.008354880847036839, -0.0004973711329512298, 0.025296302512288094, 0.01938501186668873, 0.030019722878932953,
    -0.007928785867989063, -0.028552288189530373, 0.057610299438238144, -0.02230416052043438, -0.015124409459531307, -0.022743187844753265, 0.022250911220908165, 0.022338369861245155,
    -0.07398764044046402, -0.00341966119594872, -0.008560041896998882, 0.055937260389328, 0.018428971990942955, -0.03257210552692413, -0.0007594733033329248, 0.01799136772751808,
    -0.028523830696940422, 0.027965841814875603, -0.020954662933945656, -0.017059508711099625, -0.002467074431478977, 0.0038167054299265146, 0.008042841218411922, -0.017412133514881134,
    -0.016969755291938782, 0.012907862663269043, -0.016409311443567276, 0.013496448285877705, -0.026447556912899017, 0.008410576730966568, 0.0015415899688377976, 0.05106191709637642,
    0.056761134415864944, 0.013278406113386154, -0.003849041648209095, -0.00298054120503366, 0.025552192702889442, -0.00043040208402089775, 0.021223708987236023, -0.0032022218219935894,
    0.00882689468562603, -0.005074979271739721, 0.024618804454803467, -0.0029586211312562227, -0.014042187482118607, -0.03656570613384247, -0.04270879924297333, -0.0381157286465168,
    0.007660967297852039, -0.0009283382096327841, -0.021574463695287704, -0.06491246819496155, -0.018620066344738007, -0.01737772673368454, 0.06527363508939743, 0.0013118346687406301,
    0.006122721824795008, -0.03651447966694832, -0.009090440347790718, -0.029116230085492134, 0.017316605895757675, 0.014567370526492596, -0.024000540375709534, -0.013194005005061626,
    -0.030560586601495743, -0.03569796681404114, 0.006461906246840954, -0.027311965823173523, -0.006237441673874855, -0.05793341249227524, 0.025299137458205223, 0.006029332987964153,
    0.00082728813868016, -0.02128690481185913, 0.014713048003613949, -0.06018558517098427, -0.01430016290396452, 0.06935250014066696, -0.005119150970131159, 0.00511140888556838,
    0.02786051295697689, 0.03204412758350372, -0.014111353084445, -0.0022515482269227505, 0.03427518904209137, -0.040355533361434937, -0.004903810098767281, -0.0205732099711895,
    0.014070655219256878, 0.025855829939246178, 0.06193576753139496, 0.0374455489218235, -0.07864736020565033, -0.014701304957270622, 0.007980730384588242, -0.04515412449836731,
    0.02115676738321781, -0.0055208285339176655, -0.032246485352516174, 0.012011379934847355, -0.038107309490442276, -0.02004430629312992, 0.002055741846561432, -0.01352694258093834,
    0.05779373645782471, -6.190281419549137e-05, -0.009032461792230606, -0.007111228071153164, 0.009005879051983356, -0.006164005026221275, -0.0431550107896328, -0.040362488478422165,
    0.014665048569440842, 0.011467374861240387, 0.015963494777679443, 0.010622668080031872, -0.02036285027861595, -0.008076672442257404, 0.0013395638670772314, -0.029703501611948013,
    0.00871961284428835, 0.005148609168827534, -0.03061898984014988, 0.0093989884480834, 0.006677583325654268, 0.063882976770401, -0.040598660707473755, 0.0014316602610051632,
    0.017889942973852158, 0.025363771244883537, 0.03347226232290268, -0.0036535998806357384, 0.022411620244383812, 0.011282948777079582, -0.04323852062225342, -0.016636177897453308,
    0.014675542712211609, -0.006471036002039909, -0.00588420731946826, 0.02145930752158165, -0.013113478198647499, 0.022703317925333977, 0.026276560500264168, 0.028379691764712334,
    0.013056580908596516, 0.00975327380001545, 0.01557235885411501, 0.012436737306416035, 0.01277910266071558, -0.017241720110177994, 0.05859646946191788, -0.018239984288811684,
    0.04569554328918457, 0.01587231270968914, -0.08105091005563736, 0.059002671390771866, -0.10189700871706009, -0.007864890620112419, -0.005141726695001125, -0.03723471239209175,
    0.004074302036315203, 0.035588350147008896, -0.008401044644415379, -0.02239902690052986, -0.015076005831360817, -0.025121012702584267, 0.017335088923573494, 0.03708255663514137,
    0.014359435997903347, 0.019847311079502106, -0.009017343632876873, -0.0336136631667614, 0.03318009525537491, -0.023296087980270386, 0.004014561418443918, 0.0004637311212718487,
    -0.026203591376543045, -0.004353856202214956, 0.04157295078039169, 0.003725609742105007, -0.007771011907607317, -0.00492940004914999, 0.022342665120959282, -0.015734782442450523,
    0.0526563860476017, -0.04333493486046791, -0.01572505198419094, -0.009412609040737152, -0.011799270287156105, 0.04832878336310387, 0.0038977123331278563, -0.027674982324242592,
    0.0031568133272230625, 0.007219205144792795, -0.01784670539200306, -0.03316546976566315, -0.022244170308113098, 0.007043110206723213, -0.02510327287018299, -0.004319165367633104,
    0.016361283138394356, 0.029204612597823143, -0.011236514896154404, -0.021435365080833435, -0.02226444147527218, 0.028978658840060234, -0.007078985683619976, -0.01966421864926815,
    0.007393004838377237, -0.000368037901353091, -0.012350047938525677, 0.00974639318883419, 0.05177910253405571, -0.058546822518110275, -0.03692815452814102, 0.0001285023899981752,
    -0.043696239590644836, -0.028616895899176598, 0.03807705268263817, -0.0114120589569211, -0.020015476271510124, -0.013998035341501236, 0.02418997883796692, 0.04098784923553467,
    0.021453768014907837, -0.011997691355645657, -0.00046070883399806917, 0.041649091988801956, -0.03503458946943283, -0.023653240874409676, -0.0036452561616897583, 0.036029983311891556,
    -0.011934848502278328, 0.014637701213359833, 0.003304349025711417, -0.03588777780532837, -0.0037666689604520798, 0.05393526330590248, -0.0025351729709655046, -0.0033458746038377285,
    -0.025547614321112633, 0.011271314695477486, -0.003294539637863636, -0.023146476596593857, -0.025285568088293076, -0.02328813076019287, -0.004128366708755493, 0.043371643871068954,
    0.025339510291814804, -0.007541824132204056, 0.02120153419673443, -0.02185860462486744, -0.018091963604092598, 0.0048470464535057545, 0.0029939357191324234, 0.01106064859777689,
    0.006364075001329184, 0.011968519538640976, 0.05261486396193504, 0.02352755330502987, -0.02516232803463936, 0.015885649248957634, 0.009798000566661358, -0.050130754709243774,
    -0.017006561160087585, -0.01248383428901434, -0.023001281544566154, -0.023593826219439507, -0.0027527809143066406, -0.009250408038496971, -0.0058100298047065735, -0.012110507115721703,
    -0.010513688437640667, 0.00350583135150373, 0.03269757702946663, -0.025454996153712273, -0.0023005588445812464, -0.015768028795719147, -0.005400153808295727, 0.027211440727114677,
    -0.03622721508145332, 0.04199273884296417, -0.014832824468612671, -0.028005847707390785, -0.020488662645220757, 0.0006612542783841491, -0.005385979078710079, -0.05482720956206322,
    -0.02732185833156109, -0.005840132478624582, 0.012063436210155487, -0.027079567313194275, 0.017327651381492615, -0.0015334357740357518, 0.02568129077553749, -0.0042610010132193565,
    -0.010912652127444744, 0.03954652324318886, 0.006131301634013653, 0.009878920391201973, -0.029415056109428406, 0.010295539163053036, -0.04435841366648674, -0.04582662880420685,
    0.009027221240103245, 0.018276898190379143, 0.02765040472149849, 0.020317742601037025, 0.04120289161801338, 0.01340118981897831, -0.028844278305768967, -0.04040508344769478,
    -0.014654821716248989, 0.04324742406606674, -0.0018688477575778961, 0.027327971532940865, -0.014525022357702255, -0.01737665943801403, -0.008842662908136845, 0.04541553184390068,
    -0.009146465919911861, 0.01976585201919079, 0.02409868873655796, 0.01738097332417965, -0.03665266931056976, -0.04753047600388527, 0.03741263598203659, -0.024591851979494095,
    -0.014847999438643456, -0.021063826978206635, -0.005546762607991695, 0.03282197192311287, 0.036396730691194534, 0.055051762610673904, 0.03162659704685211, 0.0017672196263447404,
    -0.000845216098241508, 0.013906586915254593, -0.07650358229875565, 0.027098430320620537, -0.006539298687130213, -0.027483969926834106, -0.07576490938663483, -0.010664830915629864,
    0.008369123563170433, -0.0022676591761410236, 0.0526646263897419, 0.005726512987166643, -0.008414515294134617, 0.023756759241223335, 0.033732086420059204, -0.010804862715303898,
    0.04773358628153801, 0.014837316237390041, 0.0038103084079921246, -0.01870410516858101, -0.018679428845643997, -0.02909587323665619, -0.0015636958414688706, -0.03213909640908241,
    0.031953394412994385, -0.038608379662036896, -0.0017999672563746572, 0.017549214884638786, 0.011282701976597309, 0.01644948311150074, -0.0588725283741951, 0.008368557319045067,
    -0.008613502606749535, -0.0059547387063503265, 0.002195673994719982, 0.0014850982697680593, -0.05971929803490639, -0.0033108005300164223, -0.03366315737366676, -0.021968122571706772,
    -0.01702585443854332, 0.0397370420396328, -0.04108181968331337, -0.011769698932766914, -0.02779059112071991, 0.004690941888839006, 0.008360879495739937, 0.013671754859387875,
    -0.01587539352476597, 0.02293669432401657, -0.051056426018476486, -0.00838408898562193, 0.021632634103298187, 0.013526293449103832, 0.03513878583908081, 0.013651566579937935,
    0.035223450511693954, -0.005892375484108925, -0.014818033203482628, 0.03325026482343674, 0.013184101320803165, 0.026891222223639488, -0.004177906084805727, -0.009162955917418003,
    0.02601146139204502, 0.022686203941702843, -0.0012587419478222728, 0.02447216771543026, -0.002633984899148345, 0.035659413784742355, 0.08404026925563812, 0.0014071352779865265,
    -0.007462893147021532, 0.003226562635973096, -0.009799736551940441, -0.016364580020308495, -0.04227257892489433, -0.014220336452126503, 0.0025515693705528975, 0.006185484118759632,
    -0.04518792778253555, -0.02723064459860325, -0.01555568352341652, -0.005528613924980164, -0.009762614965438843, -0.0020688504446297884, 0.02536967024207115, 0.060281381011009216,
    0.014132299460470676, -0.0024490361101925373, -0.006625230889767408, 0.01848672889173031, -0.014870323240756989, -0.033079393208026886, -0.03821069374680519, 0.009360166266560555,
    -0.02424965426325798, 0.016356071457266808, -0.0031431668903678656, 0.007251294795423746, -0.023254593834280968, 0.006440699566155672, 0.02653074823319912, 0.0016828253865242004,
    -0.08343245834112167, 0.02878170646727085, 0.005280055105686188, 0.016520878300070763, 0.021093592047691345, 0.0312609039247036, -0.007979849353432655, 0.008765052072703838,
    0.03921455889940262, 0.006053250283002853, 0.05593755468726158, 0.0070443726144731045, -0.03604689612984657, -0.015126358717679977, -0.006532788742333651, 0.023374823853373528,
    0.02288816310465336, 1.4797234143770766e-05, -0.005422560032457113, -0.03472261130809784, -0.06136006489396095, -0.014981972053647041, -0.05062839016318321, -0.008460156619548798,
    -0.008864880539476871, -0.017711326479911804, -0.01865246891975403, 0.032820988446474075, -0.05645376071333885, -0.019263213500380516, 0.014536415226757526, 0.021170876920223236,
    -0.07498075067996979, -0.03351636603474617, -0.008334562182426453, -0.018319206312298775, -0.005062378477305174, 0.006762444972991943, -0.025684965774416924, 0.03197726607322693,
    -0.03566813841462135, 0.005480242893099785, -0.011064264923334122, -0.009312920272350311, -0.0002152634406229481, -0.058467160910367966, 0.004581218119710684, -0.01478586159646511,
    -0.004922216292470694, -0.01620803214609623, -0.0482301190495491, -0.0391145683825016, -0.02146431803703308, 0.005485333502292633, -0.030750710517168045, -0.04345468804240227,
    -0.011059246025979519, -0.031124800443649292, -0.01980556920170784, -0.0209047868847847, -0.013359597884118557, 0.007439285982400179, -0.025558358058333397, 0.015986867249011993,
    0.04031280428171158, -0.02587718330323696, 0.02019299566745758, -0.06516728550195694, -0.040578898042440414, -0.0038579904939979315, -0.0375034362077713, -0.02382972091436386,
    -0.0027922808658331633, 0.030755767598748207, -0.0472530759871006, 0.013655856251716614, 0.029116658493876457, 0.030231891199946404, 0.0779133215546608, -0.013336162082850933,
    -0.025779979303479195, 0.0036695548333227634, -0.007359286304563284, 0.02744980901479721, -0.0028589910361915827, 0.03430734947323799, -0.03723927214741707, 0.05294514074921608,
    -0.03963127359747887, 0.019343402236700058, 0.023103732615709305, -0.0007057719049043953, 0.0057621849700808525, 0.02742794156074524, 0.07079938054084778, 0.03713240846991539,
    -0.012043002992868423, 0.0384955070912838, -0.06600511074066162, 0.013825532980263233, -0.028805814683437347, 0.007854350842535496, -0.002538080792874098, -0.01860080100595951,
    0.009554236195981503, -0.00878910906612873, 0.0071639930829405785, 0.012980214320123196, 0.0029093327466398478, 0.04141639173030853, -0.03511371091008186, -0.003864547237753868,
    -0.012902913615107536, 0.04842940717935562, 0.006646071560680866, -0.0006069873925298452, 0.004657587502151728, -0.012785227037966251, -0.04191731661558151, -0.0033095870167016983,
    0.01242526900023222, 0.02706613391637802, 0.018261924386024475, -0.0029135423246771097, 0.01460716500878334, 0.019237805157899857, 0.012815846130251884, 0.007418523542582989,
    -0.05822242051362991, -0.010654333047568798, 0.03946467861533165, 0.00676280353218317, -0.010483009740710258, -0.028211623430252075, -0.012359639629721642, -0.026729118078947067,
    0.013159969821572304, -0.02028528042137623, -0.026529747992753983, -0.026545008644461632, -0.01952505111694336, 0.0032599549740552902, 0.03622620180249214, -0.03298434987664223,
    -0.04014888405799866, 0.004144907929003239, -0.007989490404725075, -0.025150315836071968, -0.019588971510529518, -0.012415600940585136, -0.018662961199879646, -0.01867544837296009,
    -0.024033404886722565, 0.003693272126838565, -0.016709892079234123, 0.0007649831823073328, 0.02074718475341797, -0.030301041901111603, -0.00612439913675189, -0.055950265377759933,
    -0.04014015197753906, 0.011449992656707764, 0.07190515846014023, 0.009570821188390255, -0.011127933859825134, 0.017134983092546463, 0.005147644318640232, -0.032269615679979324,
    0.011229182593524456, 0.0007488821283914149, 0.012177354656159878, -0.036943208426237106, 0.006429546047002077, 0.016387905925512314, 0.03398982062935829, 0.028227150440216064,
    0.03229347616434097, -0.019259678199887276, 0.04203806072473526, -0.029096150770783424, -0.0071930247358977795, 0.018907546997070312, -0.01445692777633667, 0.02121223509311676,
    0.00669268611818552, -0.0183170847594738, 0.017635811120271683, 0.029354842379689217, -0.031448520720005035, -0.03002568706870079, -0.03760654106736183, -0.034714773297309875,
    0.023759543895721436, -0.015554822981357574, -0.013783407397568226, -0.014805210754275322, -0.0028221383690834045, 0.03802412748336792, 0.009605996310710907, 0.03820527344942093,
    -0.03272395208477974, 0.034238118678331375, -0.036893945187330246, -0.0004930101567879319, 0.004043353255838156, 0.03220437094569206, 0.038573313504457474, -0.00984580721706152,
    0.042502667754888535, 2.99102822509667e-07, -0.021094560623168945, 0.05734735727310181, 0.010957015678286552, -0.011593533679842949, -0.030382921919226646, -0.006145097780972719,
    -0.029195869341492653, 0.02861349657177925, 0.01213203277438879, 0.027640502899885178, 6.027566269040108e-05, 0.042323317378759384, -0.014064396731555462, 0.025321725755929947,
    -0.011378289200365543, -0.0215078704059124, -0.0617009699344635, 0.010341084562242031, -0.040260158479213715, 0.005809454247355461, -0.0013724323362112045, -0.013318286277353764,
    -0.012363426387310028, 0.0019361086888238788, 0.010318448767066002, -0.034596797078847885, 0.03107623942196369, -0.03095005266368389, 0.0006093960837461054, -0.03496643900871277,
    0.031138109043240547, -0.03145012632012367, 0.008159343153238297, 0.005207798909395933, 0.0008644243353046477, -0.019674908369779587, -0.010172025300562382, -0.02618264965713024,
    -0.00032401926000602543, 0.004562498070299625, 0.02107166312634945, -0.014118766412138939, -0.03350084647536278, -0.03862350061535835, 0.006125219631940126, -0.004537591710686684,
    -0.03279143199324608, 0.031065838411450386, -0.0575108528137207, 0.04215357452630997, -0.0032572615891695023, 0.033584319055080414, -0.018566736951470375, -0.005524092819541693,
    0.013722926378250122, 0.02903098799288273, -0.03166953846812248, -0.033592354506254196, -0.020105944946408272, -0.02366654947400093, 0.012041649781167507, 0.03083023801445961,
    -0.01916082762181759, 0.015302625484764576, 0.006478667259216309, -0.045009877532720566, -0.024449529126286507, -0.0005703412462025881, 0.016623103991150856, -0.002185444114729762,
    -0.028349537402391434, -0.014460526406764984, -0.015951454639434814, -0.05662383884191513, 0.0005552339134737849, -0.03111124597489834, 0.00737574091181159, -0.010881226509809494,
    -0.03226523846387863, 0.020446261391043663, -0.03512878343462944, -0.00775537546724081, -0.03784425929188728, 0.014669458381831646, -0.07235390692949295, 0.013470463454723358,
    0.0314975380897522, 0.004925481975078583, 0.0016575061017647386, -0.005458872299641371, -0.004968523513525724, 0.027464793995022774, 0.010165759362280369, -0.01916942186653614,
    -0.05611247196793556, 0.039805736392736435, 0.00431101256981492, -0.032103389501571655, -0.01616077683866024, 0.00995622668415308, -0.010674376972019672, -0.010317605920135975,
    -0.022980818524956703, -0.008636333048343658, -0.02066921815276146, 0.009572588838636875, 0.04373740404844284, -0.026579007506370544, 0.03301851078867912, -0.03250855207443237,
    -0.024262405931949615, 0.0120729124173522, 0.02134096994996071, 0.0032606860622763634, 0.0009034397662617266, -0.025004921481013298, -0.03091852366924286, 0.028809577226638794,
    0.007198289968073368, 0.001853907946497202, 0.0346728190779686, 0.017075443640351295, -0.027437802404165268, -0.031253814697265625, -0.03347611799836159, 0.012485119514167309,
    0.011963649652898312, 0.015235643833875656, 0.020635683089494705, -0.013812601566314697, -0.000135981070343405, 0.02676551602780819, -0.0006824185838922858, 0.0010998282814398408,
    0.02658182382583618, -0.02680802531540394, 0.010272049345076084, -0.023487696424126625, 0.02235790528357029, 0.050596609711647034, -0.018932964652776718, 0.017890091985464096,
    -0.016710860654711723, 0.010478428564965725, 0.0100383460521698, -0.05773098021745682, -0.05357511341571808, -0.007385568227618933, -0.025620730593800545, -0.016261791810393333,
    -0.020115403458476067, 0.012325569987297058, -0.00038134754868224263, 0.03210493177175522, 0.01923559233546257, 0.030211441218852997, -0.022199952974915504, -0.022686148062348366,
    -0.007273843511939049, 0.00710402661934495, 0.015238429419696331, 0.03568118065595627, 0.007242207415401936, 0.034391239285469055, -0.02472652494907379, -0.0025718158576637506,
    -0.018692374229431152, 0.016765911132097244, 0.005532724782824516, 0.0682743713259697, 0.006586968433111906, -0.007811734452843666, 0.03609350323677063, -0.019607553258538246,
    0.047843486070632935, 0.06218818202614784, 0.01359855942428112, -0.021141955628991127, 0.01506031397730112, 0.01985805667936802, 0.01791052520275116, 0.01932624727487564,
    0.006584841758012772, 0.016883574426174164, -0.03946724534034729, -0.024466389790177345, -0.0021590886171907187, -0.0014058136148378253, 0.01033913902938366, 0.03093547374010086,
    -0.02508668228983879, -0.03487122803926468, 0.020732086151838303, -0.019074469804763794, 0.008574615232646465, -0.013077820651233196, -0.011320598423480988, 0.002088165609166026,
    0.0003463809844106436, 0.007386400830000639, -0.028729794546961784, 0.020041493698954582, 0.023700494319200516, 0.003028188832104206, -0.04828278720378876, 0.001060854527167976,
    -0.02261229231953621, 0.007131573744118214, -0.013970359228551388, 0.043647002428770065, 0.08126821368932724, -0.01366597693413496, -0.028115786612033844, -0.02764243446290493,
    0.003123963251709938, 0.004057401791214943, 0.009070365689694881, -0.0237515140324831, -0.015838399529457092, 0.005195023491978645, 0.030703015625476837, 0.009683719836175442,
    0.036846112459897995, -0.010933945886790752, -0.025842268019914627, -0.014873222447931767, 0.01783877983689308, -0.02963634394109249, 0.04315371438860893, -0.013124137185513973,
    -0.018613601103425026, -0.023775918409228325, 0.047519128769636154, -0.009251869283616543, 0.0034986764658242464, -0.0010606676805764437, -0.005045653320848942, 0.0025891258846968412,
    0.011093034408986568, 0.007032129913568497, -0.01234233845025301, -0.013998265378177166, -0.03045623004436493, -0.012907109223306179, 0.009720818139612675, 0.027240173891186714,
    -0.016675874590873718, 0.03546573221683502, -0.04442160204052925, 0.014647011645138264, 0.013112231157720089, 0.04515336453914642, 0.03761568292975426, -0.01112739834934473,
    -0.04750274494290352, -0.03572399541735649, -0.014681250788271427, 7.847249435144477e-06, 0.005352276377379894, 0.017000308260321617, 0.0024069843348115683, -0.01933901757001877,
    0.0031711719930171967, 0.030270198360085487, -0.0383523665368557, -0.02708582952618599, -0.015168208628892899, -0.002723600948229432, 0.06674255430698395, -0.017298216000199318,
    -0.011955690570175648, 0.0022870241664350033, 0.032481614500284195, 0.023558026179671288, 0.009463193826377392, 0.0029478075448423624, -0.012822755612432957, 0.05509430170059204,
    -0.0052553098648786545, -0.05390683189034462, -0.008510950952768326, -0.023068366572260857, -0.016473624855279922, 0.012200168333947659, -0.03243772312998772, -0.011759469285607338,
    -0.014057477004826069, 0.0029932840261608362, 0.006362424232065678, 0.04316290467977524, 0.003867184277623892, 0.0345601812005043, 0.02660403400659561, -0.025212569162249565,
    0.034556880593299866, 0.004740389063954353, 0.05336804687976837, -0.024439532309770584, -0.02505207434296608, -0.0262550488114357, -0.03260073810815811, 0.010305441915988922,
    -0.09194739907979965, 0.003078164765611291, -0.035623639822006226, 0.017131661996245384, 0.007912552915513515, 0.005528951529413462, 0.008015341125428677, -0.011719424277544022,
    -0.003903277451172471, 0.018198367208242416, -0.03663673251867294, 0.02876204065978527, 0.04457791522145271, -0.011235447600483894, -0.009961115196347237, -0.0059908595867455006,
    0.040167756378650665, 0.03158027306199074, -0.02133721299469471, -0.02565198577940464, -0.00815384741872549, -0.01534087210893631, 0.06769851595163345, 0.017378531396389008,
    -0.020419152453541756, -0.010403819382190704, 0.017942575737833977, -0.06598132848739624, 0.029469003900885582, 0.01691870391368866, 0.003411706071346998, 0.003325824160128832,
    -0.010463958606123924, -0.027935458347201347, 0.012857524678111076, -0.008911263197660446, 0.04366335645318031, 0.0342254675924778, 0.024478698149323463, 0.028458312153816223,
    -0.0385323129594326, 0.023021753877401352, -0.00032317728619091213, 0.013154408894479275, -0.0019104901002719998, 0.04046494513750076, -0.015519857406616211, -0.023834623396396637,
    0.009420529007911682, 0.01614001952111721, -0.08751225471496582, -0.0328092947602272, -0.009510854259133339, -0.0019087637774646282, -0.020306846126914024, -0.008242513984441757,
    0.0005163810565136373, -0.005304435733705759, -0.03360500931739807, -0.012006380595266819, -0.03689303621649742, 0.031140604987740517, 0.01942756213247776, -0.03456750512123108,
    0.022207679226994514, -0.014458485879004002, -0.027773117646574974, -0.0392705462872982, 0.007396289613097906, -0.03252066671848297, -0.011878530494868755, -0.011929718777537346,
    -0.033374302089214325, 0.020208807662129402, -0.01574287749826908, -0.014432860538363457, 0.008998925797641277, 0.008811108767986298, 0.03753931447863579, -0.01365762297064066,
    0.014588076621294022, 0.017936989665031433, 0.004384253639727831, 0.02229403518140316, -0.0030763193499296904, 0.02735137939453125, 0.0031621968373656273, -0.03209688141942024,
    -0.011033047921955585, 0.03429076075553894, 0.009708655998110771, 0.003270314307883382, -0.006689734291285276, 0.016818858683109283, 0.022467616945505142, -0.03767069801688194,
    -0.02766181342303753, -0.008058853447437286, 0.012431073933839798, 0.02025255188345909, -0.02996845170855522, 0.02480143867433071, 0.018126124516129494, -0.01864556409418583,
    -0.0033739390783011913, -0.034265752881765366, 0.004410712979733944, -0.0025106852408498526, 0.01534992828965187, -0.03522230684757233, -0.008128649555146694, -0.015199815854430199,
    0.02940603718161583, 0.007556757424026728, 0.03127499669790268, -0.010042431764304638, 0.048520278185606, 0.012975933961570263, -0.025392191484570503, 0.018156180158257484,
    0.00780078861862421, 0.03609668090939522, -0.02674003690481186, -0.01899954117834568, -0.01728551834821701, 0.03528448939323425, 0.025887828320264816, -0.02237614244222641,
    -0.005049800965934992, 0.04248064383864403, 0.044187888503074646, -0.026306284591555595, -0.015301528386771679, -0.01768358238041401, 0.01599557138979435, 0.012408887967467308,
    -0.0065903025679290295, -0.010877752676606178, -0.013098148629069328, -0.012154343537986279, -0.024812350049614906, -0.03877770155668259, -0.01716773957014084, -0.018478332087397575,
    -0.02844994142651558, -0.00024411160848103464, 0.013849270530045033, 0.00509120337665081, -0.03164655342698097, -0.05925920605659485, -0.012226149439811707, 0.02404203824698925,
    7.5528361776378e-05, -0.007506948430091143, 0.006470313761383295, 0.007748491130769253, -0.03290918096899986, 0.006248884834349155, -0.019961321726441383, 0.007986616343259811,
    0.022967765107750893, 0.0030926272738724947, 0.0015227271942421794, -0.007297228090465069, 0.0037218050565570593, 0.006674426142126322, -0.006752032320946455, -0.008753708563745022,
    0.009258100762963295, 0.006364926695823669, 0.013899357989430428, 0.01989789865911007, 0.0015551375690847635, -0.002435558009892702, 0.01368175819516182, -0.0025654302444308996,
    0.014951814897358418, -0.010649889707565308, -0.009720365516841412, -0.005288574378937483, -0.004229451529681683, 0.006753473076969385, -0.010183287784457207, -0.0055775889195501804,
    0.014646472409367561, -0.0013373164692893624, 0.009184458293020725, 0.004199326504021883, 0.014784452505409718, 5.179264917387627e-05, 0.060108743607997894, 0.006006801966577768,
    0.006515497341752052, 0.0018876928370445967, 0.0071791550144553185, -0.025110244750976562, -0.033104270696640015, -0.009324289858341217, -0.006577441468834877, -0.004983144346624613,
    -0.008681327104568481, 0.010942397639155388, -0.013330178335309029, -0.0016095357714220881, 0.0014385206159204245, 0.008437070995569229, -0.005684354342520237, 0.00887774396687746,
    -0.0009580601472407579, -0.004274007398635149, 0.027015982195734978, 0.014542819000780582, 0.007036571390926838, 0.002455437323078513, -0.0019577443599700928, 0.008048157207667828,
    -0.015194287523627281, 0.0031313577201217413, -0.012036184780299664, -0.018173983320593834, 0.009548572823405266, -0.010992497205734253, 0.010412133298814297, 0.0031248952727764845,
    -0.002209532307460904, 0.0007434127037413418, 0.016149498522281647, -0.011075166054069996, 0.014537189155817032, 0.010420046746730804, -0.0034855054691433907, 0.003140512853860855,
    -0.009210660122334957, 0.009204324334859848, -0.005327939055860043, -0.008340219967067242, -0.003946536686271429, 0.025747964158654213, -0.014953245408833027, 0.02224278263747692,
    -0.007657981477677822, 0.000939959951210767, -0.008973944000899792, -0.0038329344242811203, -0.003122480120509863, -0.01294534932821989, -0.022252481430768967, 0.005535531789064407,
    0.01386287808418274, -0.007328921463340521, 0.0044490741565823555, -0.002940398408100009, 0.005277395248413086, -0.005034842528402805, -0.0021693205926567316, -0.015685243532061577,
    -0.011312954127788544, -0.004601598251610994, -0.010094496421515942, 0.009434162639081478, -0.0007755950791761279, -0.0073989382945001125, -0.004893078003078699, 0.006903367582708597,
    -0.008972937241196632, 0.010724546387791634, 0.0071267313323915005, -0.004713024944067001, -0.0030602426268160343, 0.0056780604645609856, 0.0029754778370261192, -0.018867872655391693,
    0.01054807286709547, -0.0025174401234835386, 0.002929150592535734, -0.004228309728205204, 0.0008321229834109545, 0.0021244119852781296, -5.364354728953913e-05, -0.008645634166896343,
    -0.07060611993074417, -0.04891270399093628, -0.07766648381948471, 0.02869763784110546, 0.07843466103076935, 0.07991167157888412, -0.044353701174259186, 0.054261915385723114,
    0.020001763477921486, 0.010607115924358368, -0.012166270054876804, 0.01993877999484539, -0.057433441281318665, -0.004982716869562864, -0.04116160050034523, -0.11202054470777512,
    -0.04828711599111557, -0.0016764565370976925, 0.04237588122487068, 0.03247511759400368, -0.014140068553388119, 0.09392867982387543, -0.006370718590915203, -0.03649939224123955,
    0.013657036237418652, -0.028558500111103058, -0.03833390772342682, 0.1147426888346672, -0.04574975371360779, 0.00642342958599329, 0.03731977567076683, -0.0412607416510582,
    -0.035793133080005646, -0.10452929139137268, -0.07787381112575531, -0.09030337631702423, 0.0442999005317688, 0.03187897801399231, -0.08059270679950714, 0.055582452565431595,
    0.03688214719295502, -0.06727705895900726, 0.062325991690158844, 0.04026378318667412, 0.05661914870142937, -0.00780793372541666, 0.12556536495685577, 0.004946775268763304,
    0.05099968612194061, 0.14825506508350372, -0.03717617318034172, -0.17600345611572266, -0.09220065176486969, -0.11196480691432953, 0.11765921860933304, 0.05884673073887825,
    0.06594226509332657, 0.005166758317500353, 0.05256279185414314, 0.08977579325437546, -0.22043673694133759, 9.827259054873139e-05, 0.04773102328181267, -0.00349614885635674,
    -0.0018734803888946772, 0.018469421193003654, -0.0027639693580567837, 0.06321102380752563, -0.010984539054334164, 0.020226607099175453, 0.028829535469412804, 0.04472774267196655,
    0.011923118494451046, 0.047622278332710266, 0.007578621152788401, -0.006209324114024639, -0.0949828177690506, 0.056096386164426804, -0.1483558565378189, 0.02017313241958618,
    -0.018822217360138893, 0.06360624730587006, 0.010299624875187874, -0.038920070976018906, 0.08840133249759674, -0.11720610409975052, 0.10130297392606735, 0.10100981593132019,
    -0.000580274558160454, 0.013922911137342453, 0.02728479914367199, -0.00980529747903347, -0.11142496019601822, 0.07675391435623169, 0.05046745389699936, 0.07856305688619614,
    -0.06284172832965851, 0.05215219780802727, 0.12649931013584137, -0.052693337202072144, -0.15799066424369812, 0.06823918968439102, -0.05336751043796539, 0.040360819548368454,
    -0.057319533079862595, -0.04568469896912575, -0.02416851371526718, -0.14907294511795044, -0.09513822942972183, -0.04870307072997093, 0.06067197397351265, 0.01762498915195465,
    0.13862164318561554, 0.09738163650035858, -0.03517526760697365, 0.0557706244289875, 0.046083420515060425, 0.03270799294114113, 0.014414875768125057, 0.04426516965031624,
    -0.0025866192299872637, -0.05047282949090004, 0.037790779024362564, -0.029121851548552513, 0.07510051131248474, 0.08342937380075455, -0.039294786751270294, 0.07885430753231049,
    -0.07105803489685059, -0.0015546868089586496, -0.0666433647274971, 0.042706266045570374, 0.06794072687625885, 0.038440000265836716, -0.11661946773529053, -0.0024023354053497314,
    0.07216540724039078, 0.11122844368219376, 0.030133966356515884, -0.06337058544158936, -0.09060461074113846, 0.03730741888284683, -0.09538590162992477, 0.06572232395410538,
    -0.11343789845705032, -0.06109367683529854, -0.08029042184352875, 0.030791789293289185, -0.012375463731586933, 0.09672342985868454, -0.07690183818340302, 0.1040942370891571,
    -0.10547054558992386, -0.007586597464978695, 0.004513856489211321, -0.07553189992904663, 0.13284896314144135, 0.04364703595638275, 0.10014034062623978, 0.03744128718972206,
    -0.07573477923870087, 0.05758383125066757, -0.029882945120334625, -0.14379945397377014, 0.0065476358868181705, 0.06660114228725433, -0.11171810328960419, 0.0733909159898758,
    -0.047148577868938446, -0.1538911610841751, -0.016290513798594475, 0.09701307862997055, -0.012156221084296703, 0.011944184079766273, -0.0694458857178688, -0.0944850891828537,
    -0.041552066802978516, 0.09066716581583023, 0.03692854195833206, 0.1300005167722702, 0.10860522091388702, -0.10788823664188385, 0.0749705508351326, 0.059017427265644073,
    0.09934195876121521, -0.0022375534754246473, 0.0075136939994990826, 0.11705123633146286, 0.025252657011151314, -0.04117588326334953, -0.011099818162620068, 0.06825754046440125,
    -0.0536142960190773, 0.04843275994062424, 0.031155329197645187, 0.059975992888212204, 0.0005307599203661084, -0.13401728868484497, -0.023919250816106796, -0.11829090863466263,
    -0.11292503029108047, 0.03338601440191269, -0.022692285478115082, -0.039095211774110794, 0.04726211354136467, 0.11148834228515625, -0.08026948571205139, 0.01529686525464058,
    0.017416764050722122, 0.023945624008774757, -0.06740331649780273, -0.014490579254925251, -0.06590017676353455, -0.06921438127756119, -0.019777314737439156, 0.05930601805448532,
    0.01301672775298357, 0.0016258357791230083, 0.0072333975695073605, 0.02500212751328945, 0.048561472445726395, 0.025161633267998695, -0.04090270400047302, -0.04374462366104126,
    -0.06570415943861008, 0.010643703863024712, -0.06365494430065155, -0.023128891363739967, -0.1067809984087944, 0.05930866673588753, 0.014375748112797737, 0.01646127738058567,
    0.06570340692996979, -0.04389435052871704, -0.006411201786249876, -0.18171174824237823, 0.15541310608386993, 0.1388481706380844, 0.07488080859184265, 0.06877502053976059,
    0.1872054487466812, 0.04090488329529762, -0.04654340073466301, -0.04864412546157837, -0.03657990321516991, 0.07344264537096024, 0.04960324987769127, 0.1040882095694542,
    0.09095615893602371, 0.1334330290555954, 0.16137544810771942, -0.08760321140289307, 0.09523766487836838, 0.01761876605451107, 0.06718556582927704, 0.008251436986029148,
    -0.035517215728759766, 0.08781374990940094, 0.012697163969278336, 0.05711732432246208, -0.023408886045217514, -0.06999123841524124, -0.09762820601463318, -0.010911139659583569,
    0.023427847772836685, 0.06794063746929169, 0.010404703207314014, 0.07074883580207825, -0.07378892600536346, 0.14035634696483612, -0.09332145005464554, -0.0340220183134079,
    -0.10951478034257889, 0.13268420100212097, 0.02522764354944229, 0.05827215686440468, 0.08500710874795914, -0.08070637285709381, 0.017670026049017906, -0.046486709266901016,
    0.02132154442369938, 0.15030261874198914, -0.018169675022363663, -0.1393418163061142, -0.16611666977405548, 0.033541351556777954, -0.029171518981456757, 0.004682967904955149,
    0.04565805196762085, 0.1459549218416214, -0.06503196805715561, -0.09577521681785583, -0.08873004466295242, -0.07146495580673218, -0.021519355475902557, 0.0025858422741293907,
    -0.056439608335494995, -0.10095224529504776, -0.055857013911008835, 0.09598546475172043, 0.018122518435120583, -0.11555373668670654, 0.07316099107265472, -0.08275645226240158,
    -0.06793664395809174, -0.06992583721876144, 0.08759994804859161, -0.140750452876091, 0.0241814237087965, 0.06475016474723816, 0.04809083044528961, 0.1277032047510147,
    -0.1164814904332161, -0.00031724924338050187, 0.13976483047008514, -0.14633770287036896, 0.21165835857391357, 0.15961499512195587, -0.08070213347673416, 0.09813431650400162,
    -0.027730973437428474, 0.08252137154340744, 0.12724314630031586, -0.015762902796268463, 0.005754911806434393, -0.0683785155415535, -0.012692690826952457, 0.041070692241191864,
    0.05488252267241478, -0.018509158864617348, -0.011631731875240803, 0.09391593188047409, 0.03805144131183624, -0.08972334861755371, -0.012522895820438862, 0.010951192118227482,
    0.08011694252490997, -0.05726621672511101, 0.10085645318031311, -0.019176224246621132, -0.1547904759645462, -0.038091663271188736, -0.06741660088300705, -0.08373445272445679,
    0.07342687249183655, -0.1176224946975708, 0.09125480055809021, 0.20170237123966217, 0.19720551371574402, -0.11938183009624481, 0.021979903802275658, -0.12062130123376846,
    0.10995369404554367, 0.020261384546756744, -0.04362832382321358, -0.00879020243883133, 0.03287351131439209, 0.09692616760730743, 0.09868290275335312, 0.034269388765096664,
    -0.010438887402415276, -0.15767857432365417, -0.030909016728401184, -0.09501561522483826, 0.1784488707780838, -0.0071067800745368, 0.06501501798629761, 0.1276993304491043,
    -0.09338291734457016, 0.09455577284097672, 0.045925602316856384, 0.07800635695457458, 0.003489543916657567, 0.11919254809617996, -0.024417169392108917, -0.100470632314682,
    0.05405078083276749, -0.20496226847171783, -0.06825412809848785, -0.1487656831741333, 0.099511057138443, 0.027034766972064972, 0.05212785303592682, 0.10836958885192871,
    -0.07756013423204422, -0.05308204144239426, -0.12715721130371094, -0.02025865577161312, -0.144022598862648, -0.07845747470855713, -0.015549304895102978, -0.07645171135663986,
    0.06236770749092102, -0.0038302543107420206, -0.15493769943714142, 0.10482854396104813, 0.06310746818780899, 0.004604964517056942, 0.2262260615825653, -0.06718196719884872,
    -0.12483171373605728, -0.13480830192565918, -0.09845128655433655, 0.04099394381046295, 0.004064179491251707, 0.11709833145141602, 0.17011135816574097, -0.24050483107566833,
    0.1574234813451767, 0.01492183655500412, 0.030834676697850227, -0.056749843060970306, 0.04838314652442932, 0.1121046170592308, -0.1410059630870819, 0.08685531467199326,
    0.006660144310444593, 0.08809966593980789, -0.08705349266529083, 0.025035496801137924, -0.05242067202925682, -0.10359854251146317, -0.018613643944263458, -0.09222295880317688,
    0.117566779255867, 0.10227105021476746, 0.022025585174560547, 0.09391037374734879, 0.08319450914859772, 0.023186465725302696, 0.10982702672481537, 0.0711250826716423,
    0.11370819807052612, -0.07722748816013336, 0.0716947391629219, -0.08432561159133911, -0.15061281621456146, 0.12841461598873138, 0.07848677039146423, 0.017243703827261925,
    0.009375677444040775, 0.0715712234377861, 0.0744294673204422, 0.04771924763917923, -0.04868904501199722, -0.3266963064670563, -0.134794682264328, -0.05240665748715401,
    -0.09094743430614471, -0.22117489576339722, 0.16854526102542877, -0.07309731841087341, 0.023531457409262657, 0.04006258398294449, 0.05066395550966263, 0.11609535664319992,
    0.026343900710344315, 0.04053283855319023, -0.08435904234647751, -0.04329420253634453, -0.029573993757367134, -0.03444134443998337, 0.03920992836356163, 0.08632122725248337,
    0.0956462025642395, 0.03265063092112541, -0.22316902875900269, -0.032364778220653534, -0.011732338927686214, -0.08598411083221436, -0.05055145174264908, -0.12453102320432663,
    0.007085158955305815, -0.1554727852344513, 0.0745912417769432, -0.05397859215736389, -0.006861070170998573, -0.01046608667820692, 0.021473538130521774, 0.10392896831035614,
    0.07702815532684326, 0.046779830008745193, 0.22831913828849792, 0.07100605219602585, 0.048678040504455566, 0.09917028993368149, -0.103511743247509, 0.0328403078019619,
    -0.033833619207143784, -0.014688021503388882, -0.007832437753677368, 0.020120956003665924, -0.04698280990123749, -0.18063797056674957, 0.12265638262033463, -0.05811532586812973,
    -0.10601291805505753, 5.6885888625402004e-05, 0.12024050951004028, 0.01837768591940403, 0.06761123985052109, -0.001985735958442092, -0.08183357864618301, -0.16407513618469238,
    -0.177892804145813, 0.17408907413482666, -0.09993390738964081, -0.10338030010461807, -0.00037607294507324696, 0.004013701342046261, 0.0005673960549756885, 0.05620160698890686,
    0.04283513128757477, 0.019044959917664528, -0.02415032871067524, -0.195641428232193, -0.048125457018613815, -0.026515845209360123, 0.07270298153162003, -0.17106884717941284,
    0.14227358996868134, 0.06727372854948044, -0.06960532069206238, -0.15215009450912476, 0.044078391045331955, -0.09730637818574905, 0.06217041239142418, 0.09383983910083771,
    -0.06415549665689468, -0.0019594093319028616, 0.014171302318572998, 0.14766912162303925, -0.04935944080352783, -0.07424917072057724, -0.06254024803638458, -0.05485140159726143,
    0.07147067040205002, -0.22132273018360138, 0.04511303827166557, -0.07161235064268112, 0.2354564219713211, -0.01423770934343338, -0.08476994931697845, -0.10267379879951477,
    -0.06583821028470993, -0.09789814054965973, -0.08058782666921616, -0.04096017777919769, -0.05629986152052879, 0.06702595949172974, -0.0602419450879097, -0.03216833621263504,
    0.06103416904807091, 0.043218426406383514, 0.08703190088272095, 0.17963573336601257, 0.07273552566766739, -0.0547434538602829, 0.09439640492200851, -0.08411597460508347,
    0.1857435703277588, 0.0295169148594141, 0.09692028164863586, 0.08189807832241058, 0.1369657963514328, -0.12889114022254944, 0.09839637577533722, -0.07995878159999847,
    -0.04561177268624306, 0.16858021914958954, -0.11146000772714615, 0.08234205096960068, -0.09802674502134323, 0.21486511826515198, -0.04244549944996834, 0.039358556270599365,
    0.0426824688911438, -0.1966465264558792, -0.014260496012866497, 0.063552625477314, 0.0029062225949019194, -0.18973228335380554, 0.017424345016479492, -0.11237483471632004,
    -0.226083904504776, 0.11787433922290802, 0.02120128460228443, -0.001786289270967245, 0.14749765396118164, 0.0393647775053978, 0.0993637964129448, -0.017773205414414406,
    -0.1552668958902359, 0.035226233303546906, 0.2587873041629791, -0.07841434329748154, 0.013591409660875797, 0.0538146048784256, 0.06642932444810867, -0.10410141199827194,
    -0.10080816596746445, -0.04007437825202942, 0.11843349784612656, 0.019750064238905907, 0.02563655935227871, 0.17317630350589752, -0.1467328518629074, 0.11285069584846497,
    0.03519962355494499, 0.07318148761987686, 0.003734349738806486, 0.11928842216730118, 0.051230307668447495, -0.013934951275587082, -0.13653773069381714, 0.025990372523665428,
    -0.027775900438427925, 0.09454284608364105, 0.008642585016787052, 0.011521807871758938, 0.027167396619915962, 0.1903778463602066, 0.2143339365720749, -0.16757121682167053,
    0.06430482864379883, 0.01868456043303013, 0.14494480192661285, -0.19123385846614838, -0.01499704085290432, 0.006976516917347908, -0.028742602095007896, 0.13715235888957977,
    0.10319293290376663, -0.09619522839784622, 0.22996386885643005, -0.07032614946365356, 0.028668219223618507, 0.0948789045214653, -0.020874105393886566, 0.05934007465839386,
    -0.0600634440779686, 0.03264717012643814, 0.10490207374095917, -0.10412149876356125, 0.021867752075195312, -0.07283461093902588, -0.1598537564277649, 0.06179310381412506,
    0.07756675779819489, 0.06900301575660706, 0.14314094185829163, 0.08182033896446228, 0.12147961556911469, 0.164785698056221, -0.12447746843099594, 0.053502023220062256,
    -0.05047887936234474, 0.11421389132738113, 0.19800704717636108, 0.07381457835435867, 0.12161771208047867, -0.04996531456708908, 0.11266086250543594, 0.13498415052890778,
    -0.06916453689336777, -0.003748453687876463, -0.003666226752102375, 0.14186601340770721, -0.30059224367141724, -0.24892695248126984, 0.10037259757518768, -0.2137104570865631,
    -0.013349801301956177, -0.11702485382556915, -0.03946227952837944, -0.06710969656705856, 0.029986387118697166, 0.010526425205171108, 0.03011905401945114, -0.009103371761739254,
    -0.22057396173477173, -0.08241338282823563, 0.18682225048542023, 0.0383027009665966, 0.09087171405553818, -0.11215640604496002, -0.024693092331290245, -0.10982455313205719,
    -0.033778801560401917, 0.0542592890560627, 0.051688507199287415, -0.009444121271371841, 0.24312356114387512, -0.042885880917310715, -0.01121470145881176, -0.014853059314191341,
    -0.07785024493932724, 0.014914844185113907, -0.13815797865390778, -0.012272131629288197, -0.02093626745045185, -0.23045141994953156, -0.06294191628694534, 0.006371303927153349,
    0.1381085366010666, 0.1683923453092575, 0.16290555894374847, 0.016405491158366203, -0.01355133205652237, 0.18015459179878235, -0.004655942320823669, 0.12724176049232483,
    0.14999593794345856, -0.11161118000745773, -0.01601570099592209, 0.08968734741210938, 0.14638879895210266, -0.06481810659170151, -0.022197222337126732, -0.1419496387243271,
    0.00888723786920309, -0.07529918104410172, -0.29897841811180115, -0.2180478274822235, -0.022797487676143646, 0.010523797012865543, 0.10039293020963669, -0.13291218876838684,
    -0.09743215143680573, -0.11450047791004181, 0.08644254505634308, 0.0872950404882431, 0.12303867191076279, -0.024832988157868385, -0.15578387677669525, 0.08518500626087189,
    0.13797898590564728, -0.06229910999536514, -0.07346732914447784, -0.0029875149484723806, 0.021616414189338684, 0.08571366965770721, 0.008134640753269196, -0.023474978283047676,
    0.016666747629642487, 0.001753545948304236, 0.007104691118001938, -0.002963583916425705, 0.008364010602235794, -0.054905861616134644, 0.11349277943372726, -0.03500744700431824,
    0.005596789065748453, -0.011862587183713913, 0.13539758324623108, -0.09167397767305374, -0.2234940230846405, -0.10211922228336334, 0.12109692394733429, 0.16910028457641602,
    0.11371694505214691, -0.11462464928627014, -0.12350856512784958, 0.0627245083451271, -0.012447279877960682, 0.1899019479751587, 0.032910749316215515, 0.08451162278652191,
    -0.05485628545284271, -0.06056738644838333, -0.19235579669475555, -0.11603144556283951, -0.05134641379117966, 0.08396229892969131, 0.07121170312166214, 0.09019217640161514,
    0.05085376277565956, -0.042209383100271225, 0.022089974954724312, 0.17184202373027802, 0.0726831778883934, 0.12509256601333618, 0.038135092705488205, -0.018761880695819855,
    -0.07512618601322174, -0.27366745471954346, -0.3171183168888092, 0.15529945492744446, -0.005309990607202053, 0.0441165529191494, -0.05304089933633804, -0.01967567577958107,
    -0.16794762015342712, -0.06450539827346802, 0.0363457165658474, 0.03741590306162834, 0.10286485403776169, 0.03508222848176956, 0.023200927302241325, -0.03477964177727699,
    -0.053979627788066864, 0.10846894234418869, 0.03690600395202637, 0.13348568975925446, 0.10715300589799881, 0.06137033551931381, -0.020374417304992676, -0.061894044280052185,
    -0.09944881498813629, 0.003737029153853655, 0.00690636970102787, 0.06373440474271774, 0.00731526967138052, -0.05715453624725342, -0.04461010918021202, 0.015224316157400608,
    -0.039042215794324875, -0.10935672372579575, -0.03574526682496071, -0.0277834665030241, -0.24330130219459534, -0.013806686736643314, 0.042459163814783096, -0.08357523381710052,
    0.010590899735689163, -0.20610642433166504, -0.016523327678442, 0.0907493308186531, 0.0013275380479171872, 0.15412327647209167, -0.014075899496674538, -0.06276748329401016,
    0.1941658854484558, 0.07339988648891449, -0.0283417459577322, -0.06860512495040894, 0.007711806334555149, -0.10672938823699951, 0.03914395347237587, 0.014519493095576763,
    0.06515198200941086, 0.12956425547599792, -0.06658691167831421, -0.16407078504562378, 0.126937597990036, 0.1388290822505951, 0.0729430541396141, 0.06286532431840897,
    0.07710237056016922, -0.014489298686385155, 0.2508432865142822, -0.18019601702690125, 0.16086207330226898, 0.06859222054481506, 0.14047212898731232, -0.12430250644683838,
    0.025722553953528404, -0.0738154873251915, -0.04632750526070595, 0.07005331665277481, 0.13990794122219086, -0.1906125396490097, 0.07659298926591873, -0.09436456859111786,
    -0.22166089713573456, -0.12227890640497208, 0.13347604870796204, -0.07048273831605911, 0.033603567630052567, 0.003340330673381686, -0.006458647549152374, 0.01957046240568161,
    0.0064074210822582245, -0.09341354668140411, -0.09727290272712708, 0.08707213401794434, -0.16338810324668884, -0.1555863469839096, 0.17759573459625244, 0.09982091188430786,
    0.017665766179561615, 0.06161613017320633, -0.12096328288316727, -0.11719730496406555, -0.10079383105039597, -0.08750534057617188, 0.1344648152589798, -0.17989715933799744,
    -0.14700524508953094, 0.29213955998420715, -0.1346217691898346, -0.022489529103040695, -0.11041097342967987, 0.15694507956504822, -0.0994081199169159, 0.06154178828001022,
    -0.018641404807567596, 0.016097741201519966, -0.19686943292617798, -0.24557296931743622, 0.039473071694374084, 0.01831352338194847, 0.036077629774808884, 0.10076388716697693,
    0.03663008660078049, -0.04502509534358978, 0.0803523063659668, -0.19470803439617157, 0.0011212609242647886, -0.03679075837135315, 0.009387821890413761, -0.08048363775014877,
    -0.03697207570075989, 0.17320816218852997, 0.10226956009864807, 0.10086404532194138, -0.040763262659311295, -0.06199802830815315, -0.15212175250053406, -0.04300925135612488,
    -0.07214962691068649, 0.16535066068172455, -0.03858990594744682, -0.01340417843312025, 0.1648085117340088, -0.10694324225187302, -0.033999621868133545, 0.2133803516626358,
    -0.015793299302458763, 0.08950924873352051, 0.0046578580513596535, 0.1067216619849205, 0.08550643175840378, -0.0004999794182367623, -0.012624847702682018, 0.06782912462949753,
    0.28049203753471375, -0.1945374608039856, 0.017808308824896812, 0.006958328653126955, 0.06282354146242142, -0.008256785571575165, 0.02349356934428215, -0.1471385955810547,
    0.04587982967495918, -0.07263273745775223, 0.05100296065211296, 0.1083795353770256, -0.12236519902944565, 0.10134384781122208, 0.06287453323602676, -0.10448206216096878,
    -0.13065512478351593, -0.2595749497413635, 0.03352569416165352, -0.02130422368645668, 0.009004281833767891, -0.10412687063217163, -0.08749847114086151, -0.10211168229579926,
    0.20965273678302765, 0.016075966879725456, 0.08547347784042358, -0.01851908676326275, 0.005355304107069969, 0.011064667254686356, -0.05293693765997887, -0.07075635343790054,
    -0.21639491617679596, -0.02148282900452614, -0.03438163548707962, 0.04774868115782738, -0.09213263541460037, -0.07791028171777725, -0.16483676433563232, 0.13782179355621338,
    0.0750856027007103, -0.01997891627252102, -0.1405087411403656, 0.07091092318296432, 0.05607113614678383, -0.04838312789797783, 0.02072901278734207, -0.12105555087327957,
    0.2332664132118225, 0.04677927866578102, -0.11519672721624374, -0.07704233378171921, -0.03285718709230423, -0.13278739154338837, 0.14412930607795715, -0.06178002804517746,
    0.029027309268712997, -0.14699150621891022, 0.10423995554447174, 0.04534837603569031, 0.029956815764307976, 0.02427322417497635, 0.051653843373060226, 0.030639419332146645,
    -0.10698819905519485, 0.06221660226583481, -0.1503610461950302, 0.07091974467039108, 0.04149487614631653, 0.20942504703998566, 0.1746884286403656, 0.015153824351727962,
    0.02932392619550228, 0.007595134433358908, 0.05933142080903053, 0.05205563083291054, 0.18298622965812683, -0.0011679348535835743, 0.11089178919792175, 0.046780601143836975,
    -0.06088928505778313, -0.38012996315956116, 0.2294567972421646, 0.058811988681554794, 0.0341380350291729, -0.0128556489944458, -0.02459857426583767, -0.11296612024307251,
    0.09577522426843643, 0.033210620284080505, -0.01339448057115078, -0.12858495116233826, 0.05820875242352486, -0.08235102891921997, 0.06168219819664955, -0.02986450120806694,
    0.10283872485160828, 0.002273304620757699, 0.0517282634973526, -0.13437819480895996, -0.0532875619828701, -0.2135276049375534, 0.11008051782846451, -0.11960829794406891,
    -0.07406865805387497, -0.020684558898210526, 0.19375157356262207, 0.10085092484951019, -0.09127925336360931, -0.0006972994306124747, 0.012265694327652454, 0.09343629330396652,
    -0.1779080331325531, 0.155767023563385, -0.034002579748630524, -0.03521623834967613, -0.32953357696533203, -0.07991524785757065, -0.1402474045753479, 0.0043389382772147655,
    0.013106133788824081, 0.11935222893953323, -0.012546519748866558, -0.0732136070728302, 0.05738360807299614, 0.015620460733771324, -0.03911934792995453, 0.08419468253850937,
    -0.0330783911049366, -0.12689846754074097, 0.08229535073041916, -0.07258705794811249, -0.030997570604085922, -0.11940956860780716, 0.01651032641530037, -0.12246972322463989,
    0.10935060679912567, -0.05699625611305237, 0.013536312617361546, -0.06344421952962875, 0.25925910472869873, 0.06842757016420364, 0.07929643243551254, -0.15027190744876862,
    -0.12910036742687225, 0.11497431248426437, -0.0037967595271766186, 0.14583727717399597, -0.01533084362745285, 0.08579164743423462, -0.13112592697143555, 0.06858622282743454,
    0.017902355641126633, -0.0270000621676445, -0.005238320678472519, -0.09971462190151215, -0.008886599913239479, 0.20635800063610077, 0.020958054810762405, 0.08160457015037537,
    0.14956466853618622, -0.05127979442477226, 0.09386587142944336, 0.057520005851984024, -0.10173532366752625, -0.08703500032424927, -0.06989677995443344, 0.039990413933992386,
    0.010716915130615234, 0.08587586134672165, 0.000915240787435323, 0.20961998403072357, 0.0028805178590118885, 0.027395980432629585, 0.10953928530216217, -0.029038727283477783,
    0.26934507489204407, 0.017894702032208443, 0.054924990981817245, -0.043874189257621765, -0.09330382943153381, 0.09490860998630524, 0.0627729669213295, -0.01107326615601778,
    -0.06328772008419037, 0.1638789176940918, -0.023985913023352623, -0.09939101338386536, 0.005937264300882816, -0.07941067963838577, 0.12311415374279022, -0.032734256237745285,
    -0.16965749859809875, 0.06363335251808167, 0.0693398118019104, 0.055773649364709854, 0.008045529015362263, -0.11780991405248642, 0.13893325626850128, -0.027342025190591812,
    -0.01412340346723795, 0.007646125741302967, 0.039478931576013565, 0.05870530381798744, 0.3093454837799072, -0.02847285196185112, 0.02535044401884079, 0.17944946885108948,
    0.15874886512756348, 0.3662310838699341, -0.12364903837442398, 0.030070116743445396, -0.07800650596618652, -0.0037988515105098486, -0.052854668349027634, -0.0023100764956325293,
    -0.0074815889820456505, 0.0577213354408741, -0.003478976199403405, 0.09332459419965744, 0.06297814846038818, -0.022109700366854668, 0.04666244983673096, -0.05667427182197571,
    0.082338348031044, 0.01127149909734726, -0.17483459413051605, 0.19496284425258636, -0.07694100588560104, -0.19746965169906616, -0.052365466952323914, 0.10716263949871063,
    -0.04127022996544838, -0.19877584278583527, -0.018643155694007874, 0.06001991033554077, -0.22009889781475067, -0.039983462542295456, 0.34519162774086, 0.10260731726884842,
    -0.15852949023246765, 0.05431891977787018, 0.03049376979470253, -0.03047090955078602, 0.24201397597789764, 0.007502278313040733, -0.13675729930400848, -0.28982552886009216,
    -0.03359794616699219, 0.11675728112459183, 0.18510626256465912, -0.07594354450702667, 0.026339510455727577, 0.049997903406620026, -0.0033623529598116875, 0.02401048131287098,
    -0.2601191997528076, -0.09290797263383865, 0.06013695150613785, -0.04478578642010689, -0.0259485375136137, -0.0725189596414566, 0.0016428555827587843, -0.12165582180023193,
    0.05817199498414993, 0.09171343594789505, -0.030098918825387955, -0.03450661525130272, -0.103274405002594, -0.004269737284630537, 0.023801347240805626, 0.04640469700098038,
    0.1526835709810257, 0.3387274146080017, -0.06257625669240952, 0.032486531883478165, 0.03985146805644035, -0.05632120370864868, 0.03233729302883148, -0.029641618952155113,
    0.015165731310844421, -0.06597843021154404, 0.04095057025551796, 0.041049517691135406, 0.006776255555450916, -0.19424395263195038, -0.008205675520002842, 0.13442100584506989,
    -0.04173223301768303, 0.08261359483003616, 0.08485127240419388, -0.12654396891593933, -0.06255532056093216, -0.057992368936538696, 0.11746048182249069, -0.02694886364042759,
    -0.1311289370059967, -0.004380923695862293, 0.11948122084140778, 0.10752715915441513, -0.01858564466238022, -0.04322097823023796, 0.02340295910835266, 0.09602176398038864,
    -0.11315320432186127, -0.13580548763275146, 0.061297375708818436, 0.11030158400535583, 0.02559814415872097, 0.02225378155708313, 0.07838787138462067, -0.03835329785943031,
    -0.1683671474456787, 0.25100088119506836, 0.03172102943062782, -0.20778775215148926, 0.00010185113933403045, -0.13944576680660248, 0.05542188882827759, -0.012286628596484661,
    -0.16583341360092163, 0.032118525356054306, 0.051396068185567856, -0.03456854820251465, -0.028035098686814308, -0.07762719690799713, 0.11256951093673706, 0.05783212557435036,
    -0.033302467316389084, -0.018380045890808105, 0.011246501468122005, -0.09569700807332993, 0.048069071024656296, -0.15292558073997498, 0.039348576217889786, -0.11463356018066406,
    -0.10230568796396255, -0.2671588361263275, -0.08892472833395004, 0.05032350495457649, -0.10549049079418182, 0.0004723019083030522, -0.17042164504528046, -0.1184767559170723,
    0.0002532716025598347, 0.07875929027795792, 0.03367628902196884, 0.16184452176094055, 0.15149793028831482, 0.08569052815437317, 0.03428417444229126, -0.03842296451330185,
    0.12538522481918335, -0.05554501339793205, -0.03389773517847061, -0.1669120192527771, -0.054028961807489395, -0.07002665102481842, -0.10744833946228027, -8.995636744657531e-05,
    -0.0666678324341774, 0.31363004446029663, -0.11818301677703857, 0.051894739270210266, -0.07146481424570084, 0.05774616822600365, 0.06335245072841644, -0.212358295917511,
    -0.00619677547365427, -0.035556986927986145, 0.00020469226001296192, -0.03278570994734764, -0.06155353784561157, 0.08413472771644592, -0.004719191696494818, -0.15906506776809692,
    0.017832864075899124, -0.09780916571617126, 0.22596172988414764, 0.04158547893166542, 0.10601922124624252, -0.08291669934988022, 0.0953182652592659, -0.02183378115296364,
    0.09907864779233932, -0.07693987339735031, -0.06667041033506393, -0.08951182663440704, 0.1536991447210312, -0.13230738043785095, -0.0006238361238501966, -0.07858824729919434,
    -0.04498133808374405, 0.12148161232471466, -0.010925809852778912, 0.003239104989916086, -0.12830671668052673, -0.026299159973859787, 0.031910240650177, 0.0007612641784362495,
    0.09352283179759979, 0.04444626718759537, -0.1918487846851349, -0.18548843264579773, -0.0349675789475441, -0.01164273638278246, -0.17993012070655823, -0.22630566358566284,
    0.046190958470106125, 0.06000495329499245, 0.05279833823442459, -0.05626682564616203, 0.013887816108763218, 0.0984790250658989, 0.03509533777832985, -0.09830732643604279,
    -0.16328969597816467, -0.12240304797887802, 0.09507273882627487, -0.07797357439994812, -0.010556931607425213, -0.2291182428598404, -0.08955665677785873, -0.05758015438914299,
    -0.10306417942047119, 0.02323109097778797, -0.2561866343021393, -0.06712979078292847, -0.09363891184329987, -0.025051990523934364, 0.028026314452290535, 0.03155858814716339,
    -0.42637142539024353, -0.08585332334041595, 0.007689162623137236, -0.0554555207490921, -0.0359850712120533, -0.1552819460630417, -0.023611702024936676, 0.06367547810077667,
    0.0906858891248703, 0.1317880004644394, 0.04051355645060539, -0.00933497678488493, -0.013281552121043205, -0.10251285135746002, 0.09196072816848755, -0.019606349989771843,
    -0.10722328722476959, -0.06812728941440582, -0.2650150954723358, 0.029907654970884323, 0.04474235326051712, 0.1866142749786377, 0.09872650355100632, 0.21277911961078644,
    -0.10413520038127899, -0.09096374362707138, -0.02759125456213951, -0.02162034623324871, -0.13074937462806702, -0.06546351313591003, -0.10650676488876343, -0.04621503874659538,
    -0.14273345470428467, 0.12167072296142578, 0.17132961750030518, 0.0770258828997612, 0.08493242412805557, 0.16930605471134186, -0.054385822266340256, -0.07151700556278229,
    -0.012220319360494614, 0.017507214099168777, -0.015128743834793568, -0.05283566191792488, 0.0415872298181057, 0.057285893708467484, 0.024484381079673767, 0.03331862390041351,
    -0.016931412741541862, 0.017022043466567993, 0.031269371509552, -0.2750995457172394, -0.060616977512836456, -0.12126531451940536, 0.011628170497715473, -0.18165065348148346,
    -0.02120227925479412, -0.2547081410884857, -0.14685964584350586, 0.02511165477335453, -0.1711469292640686, 0.13514095544815063, -0.0684599056839943, 0.036265015602111816,
    -0.1349584013223648, -0.17136938869953156, 0.05290251225233078, 0.0741337463259697, -0.1041775792837143, 0.05278052017092705, 0.004375480115413666, 0.09356708079576492,
    0.008056598715484142, -0.015166244469583035, -0.00494401203468442, 0.07912616431713104, 0.05542754754424095, 0.01674751564860344, 0.10965032875537872, 0.03810349479317665,
    0.16487911343574524, -0.07409816980361938, -0.3578120470046997, -0.025103425607085228, 0.1717807501554489, -0.11106574535369873, 0.050949763506650925, 0.13500824570655823,
    -0.004095262382179499, 0.04373367130756378, -0.03652600571513176, 0.04754194617271423, 0.17171068489551544, -0.04388309270143509, 0.1488441526889801, 0.0326370969414711,
    0.01316513866186142, -0.38188350200653076, 0.01238738838583231, -0.03252974897623062, 0.02498135156929493, 0.04127125069499016, 0.002225524978712201, 0.049392372369766235,
    -0.05682526156306267, -0.0813930556178093, 0.07343987375497818, 0.07537972182035446, 0.010071635246276855, 0.028533833101391792, 0.07909272611141205, 0.09106890857219696,
    0.28420785069465637, 0.08568300306797028, -0.006193279754370451, 0.15055587887763977, 0.03409958630800247, -0.22267884016036987, -0.13447295129299164, -0.1146460697054863,
    0.07322338223457336, -0.01637345924973488, 0.3425055146217346, 0.041317425668239594, -0.09048037230968475, 0.034214068204164505, -0.0024431694764643908, -0.001537783769890666,
    -0.24220333993434906, 0.0015291739255189896, 0.20156969130039215, 0.0485113263130188, 0.0589958094060421, -0.1113135814666748, 0.1233227401971817, 0.12023629993200302,
    0.13786107301712036, -0.15570181608200073, -0.022536640986800194, 0.08393680304288864, 0.008321219123899937, -0.03367580100893974, -0.10078775137662888, 0.021030686795711517,
    -0.03772050887346268, 0.09795813262462616, -0.19645307958126068, 0.07102865725755692, 0.012340636923909187, -0.1258636713027954, 0.046500056982040405, 0.09969069063663483,
    -0.03578978031873703, -0.13661682605743408, -0.1098678708076477, -0.14075888693332672, -0.2981418967247009, -0.019087545573711395, -0.01659916713833809, -0.08315292000770569,
    0.27847588062286377, 0.0473165363073349, -0.022367743775248528, 0.015072852373123169, 0.0581665076315403, 0.06374631077051163, -0.14362022280693054, -0.12860718369483948,
    0.0644950196146965, 0.044949330389499664, -0.12369789183139801, 0.07014894485473633, -0.006385376211255789, -0.016624951735138893, 0.1448337733745575, 0.05224518105387688,
    -0.010094726458191872, 0.0702267438173294, 0.061315663158893585, 0.2998112738132477, 0.016263309866189957, -0.1328318864107132, 0.04880998656153679, -0.21208776533603668,
    -0.07227132469415665, 0.10963317006826401, -0.010600821115076542, 0.07655209302902222, -0.15563996136188507, 0.0253248680382967, 0.11875732988119125, 0.23973119258880615,
    -0.22150786221027374, 0.03666345030069351, -0.06372194737195969, -0.006842200178653002, 0.22409795224666595, 0.0693420022726059, -0.012562574818730354, 0.14400769770145416,
    -0.022784536704421043, -0.004999835975468159, -0.23334336280822754, -0.011891970410943031, -0.07765065133571625, -0.03305995464324951, 0.012463250197470188, -0.14273372292518616,
    -0.12870042026042938, -0.18317431211471558, -0.32110822200775146, 0.029019666835665703, 0.019153045490384102, -0.12498954683542252, -0.0003715993952937424, 0.04505675658583641,
    -0.02083025872707367, -0.02654971182346344, -0.08143050223588943, -0.03751559928059578, -0.03202437609434128, -0.06702084094285965, 0.06700681895017624, -0.005378218367695808,
    -0.08476719260215759, -0.2759861350059509, -0.12418412417173386, 0.11670489609241486, 0.019513849169015884, -0.0415198877453804, 0.11077990382909775, 0.19109730422496796,
    -0.14185133576393127, 0.04658038169145584, 0.04831993579864502, 0.07486604154109955, 0.023344440385699272, -0.09909903258085251, 0.036373116075992584, 0.19935373961925507,
    -0.13268381357192993, 0.0076247393153607845, 0.15053746104240417, 0.15212750434875488, 0.1587395817041397, -0.1322534829378128, 0.027745846658945084, -0.2468908280134201,
    -0.061586666852235794, 0.0010334240505471826, -0.36142343282699585, -0.0454433299601078, 0.054016370326280594, 0.024726638570427895, -0.06754519790410995, -0.05084986984729767,
    0.2680209279060364, 0.07146284729242325, 0.021973952651023865, -0.06086824834346771, -0.15268293023109436, -0.042069416493177414, -0.03930067643523216, 0.026360969990491867,
    0.06204448640346527, -0.28702467679977417, 0.05856100097298622, 0.16583819687366486, 0.05437370017170906, 0.004218329209834337, -0.01500467024743557, 0.0003337897651363164,
    0.13093672692775726, 0.017323197796940804, 0.3878079056739807, -0.01165719609707594, 0.00025713146897032857, -0.1817605346441269, -0.006521350238472223, 0.024791480973362923,
    0.050726599991321564, -0.037911638617515564, -0.033648256212472916, -0.020105931907892227, -0.10638949275016785, -0.054909851402044296, 0.24451996386051178, 0.055864568799734116,
    -0.09117429703474045, -0.17502136528491974, -0.2135668694972992, -0.0619068406522274, 0.04318970814347267, -0.0753135085105896, -0.16559743881225586, -0.032629359513521194,
    0.0341067761182785, 0.05407333001494408, -0.22115914523601532, 0.18871568143367767, -0.1120532751083374, -0.05753139406442642, 0.05468384176492691, 0.08160194754600525,
    -0.005293919704854488, 0.08777233958244324, -0.08311024308204651, -0.0040735951624810696, 0.0895097479224205, -0.18011458218097687, 0.04521429166197777, 0.005199340172111988,
    -0.07659664005041122, 0.13317136466503143, 0.1874713897705078, -0.05560661479830742, -0.14336739480495453, -0.11587847769260406, 0.1492571085691452, -0.03436145931482315,
    -0.04008006304502487, 0.13753311336040497, 0.08321171253919601, -0.01322164572775364, -0.17299920320510864, 0.08964146673679352, -0.05313538759946823, -0.1363496035337448,
    0.04846106097102165, 0.0972868800163269, -0.13759678602218628, 0.06484387814998627, 0.04503907263278961, 0.01826287806034088, 0.023988917469978333, 0.030378488823771477,
    -0.05426591634750366, 0.05512668192386627, -0.08283042907714844, 0.07699282467365265, 0.057116154581308365, -0.06197281926870346, 0.0009804225992411375, -0.026018187403678894,
    -0.0094881197437644, -0.02718733437359333, -0.10421265661716461, 0.042558781802654266, -0.14121240377426147, -0.18822512030601501, 0.0309187900274992, 0.01235161442309618,
    -0.10003604739904404, 0.170845627784729, -0.06848057359457016, -0.055171191692352295, 0.026952266693115234, 0.07189225405454636, 0.1257719099521637, -0.19837671518325806,
    -0.014539327472448349, 0.11366251856088638, -0.04103008285164833, 0.009573924355208874, -0.00036407430889084935, 0.265451043844223, -0.014453367330133915, -0.18325699865818024,
    -0.1500747799873352, -0.10541116446256638, 0.04396937042474747, 0.04911724478006363, 0.09137933701276779, -0.15467798709869385, 0.02710089460015297, -0.303261935710907,
    -0.008449540473520756, 0.01655612513422966, 0.3494910001754761, -0.16826938092708588, 0.028304889798164368, -0.20649394392967224, -0.1410953253507614, 0.043612219393253326,
    0.5590122938156128, 0.019602952525019646, -0.2287120670080185, 0.03634249418973923, -0.017651643604040146, -0.0006590922130271792, -0.09833437204360962, 0.09881280362606049,
    0.1299113780260086, -0.13743671774864197, 0.10432416945695877, 0.04869265854358673, 0.043541084975004196, 0.006108689121901989, -0.012434782460331917, 0.039349064230918884,
    0.07390080392360687, -0.13480344414710999, 0.2456948310136795, 0.0002367355045862496, 0.06515485793352127, 0.27511516213417053, 0.06484757363796234, -0.07239697873592377,
    0.024878500029444695, -0.02818136475980282, -0.027630768716335297, 0.009885271079838276, 0.27809762954711914, 0.09064211696386337, 0.25537607073783875, -0.05802019685506821,
    -0.21315176784992218, 0.22874115407466888, 0.16555869579315186, -0.01070121768862009, 0.0011048465967178345, 0.02173943817615509, 0.13422419130802155, -0.04533495008945465,
    0.010720956139266491, 0.03241319581866264, -0.1358170062303543, 0.09826207906007767, -0.06142324209213257, 0.15942734479904175, 0.1893375813961029, 0.026032768189907074,
    -0.0930902436375618, 0.048943016678094864, -0.094786137342453, -0.25000786781311035, 0.1179499626159668, -0.04167981073260307, -0.053584761917591095, 0.08997021615505219,
    -0.11886584758758545, -0.3258236050605774, -0.05871410667896271, -0.14452636241912842, 0.03935756906867027, 0.03998030722141266, 0.08329377323389053, -0.09734132885932922,
    0.14010249078273773, 0.08330453187227249, -0.046720001846551895, 0.05155429616570473, 0.015905648469924927, 0.22204038500785828, 0.012186145409941673, -0.13744470477104187,
    -0.0534372441470623, 0.12625505030155182, -0.0441649928689003, 0.02841106802225113, 0.07657498121261597, -0.02472800761461258, 0.08550329506397247, 0.14599297940731049,
    0.015034593641757965, 0.11941331624984741, 0.006708542350679636, 0.029774149879813194, 0.10121461749076843, -0.09044285863637924, 0.07869928330183029, 0.0023605029564350843,
    0.005071580410003662, 0.041707102209329605, -0.09415332973003387, 0.036101099103689194, 0.10055456310510635, 0.02060871198773384, 0.09259451180696487, -0.04328127205371857,
    0.040735747665166855, 0.36868125200271606, 0.17467769980430603, 0.06695351749658585, 0.02422926388680935, 0.0006788403261452913, -0.13136380910873413, -0.0691322535276413,
    -0.04663733392953873, -0.001275360002182424, 0.0355917252600193, -0.012667001225054264, -0.00586515199393034, -0.009804414585232735, 0.0704827830195427, -0.16292884945869446,
    0.32103803753852844, 0.2118104249238968, 0.08442354947328568, -0.20717588067054749, -0.01612929441034794, -0.04617980867624283, -0.12727274000644684, -0.24805708229541779,
    0.00263691577129066, -0.029958609491586685, -0.25456130504608154, -0.14470942318439484, 0.0037163165397942066, -0.08727643638849258, 0.01824563927948475, 0.03905164450407028,
    0.21064236760139465, 0.05519069358706474, -0.20604625344276428, -0.03406911343336105, 0.11566720902919769, -0.05134665593504906, 0.1001744344830513, 0.1886243373155594,
    -0.09808872640132904, 0.2732656002044678, -0.25235122442245483, 0.1519000083208084, 0.0038395829033106565, -0.11769089847803116, -0.2115645855665207, 0.02903740294277668,
    0.07342018932104111, 0.07804477959871292, -0.43674272298812866, -0.003977975808084011, -0.05895058438181877, -0.08400709182024002, 0.09049241989850998, -0.1386769711971283,
    -0.02211332693696022, -0.03726698458194733, -0.01235900353640318, -0.03598202392458916, 0.2152104377746582, -0.09603003412485123, 0.06668221205472946, 0.0003704085247591138,
    0.17267397046089172, -0.16842079162597656, -0.004976286087185144, -0.010560733266174793, -0.04485173895955086, 0.11330320686101913, 0.10465911775827408, 0.021313047036528587,
    -0.03737670183181763, 0.009029055014252663, 0.06688746064901352, -0.10455067455768585, 0.12444505840539932, -0.019385026767849922, 0.021163927391171455, 0.07063588500022888,
    -0.24567843973636627, 0.02227560430765152, 0.06789330393075943, 0.2488674521446228, 0.06379774212837219, 0.09065758436918259, -0.055609479546546936, 0.0037094017025083303,
    -0.17046944797039032, 0.2538115382194519, -0.18040427565574646, -0.04849855601787567, 0.04570117965340614, -0.0675940215587616, 0.023609980940818787, 0.1017085462808609,
    0.10006438940763474, -0.06481993943452835, 0.020321115851402283, 0.15499034523963928, 0.1683720499277115, 0.22114574909210205, 0.09156649559736252, -0.006785912439227104,
    -0.012790541164577007, 0.16861499845981598, -0.06613382697105408, -0.1577957570552826, 0.11717191338539124, -0.04614816978573799, 0.054688964039087296, -0.03991320729255676,
    0.10186740756034851, 0.12241825461387634, 0.11762741208076477, 0.0033596607390791178, 0.0411929115653038, -0.12545745074748993, 0.04258084297180176, -0.08040779829025269,
    0.11263415217399597, -0.01833259128034115, -0.05163126811385155, -0.028055554255843163, 0.004590875469148159, 0.14552104473114014, 0.12388430535793304, 0.09933213144540787,
    0.025740988552570343, 0.24716253578662872, 0.06077265366911888, 0.05492757633328438, -0.005165416281670332, 0.01134895347058773, -0.016240769997239113, 0.0534512922167778,
    -0.01637800969183445, 0.03171916306018829, 0.0629897192120552, -0.009980431757867336, -0.0054163443855941296, -0.10904142260551453, 0.02524617128074169, 0.11912759393453598,
    -0.24683119356632233, -0.10865531116724014, 0.11763361096382141, -0.013977457769215107, 0.017318282276391983, -0.16953162848949432, -0.15024618804454803, -0.1352391541004181,
    -0.09956548362970352, -0.006960171274840832, 0.17412935197353363, -0.0890592709183693, 0.09911484271287918, 0.019951755180954933, -0.13174466788768768, 0.011502131819725037,
    -0.43074673414230347, 0.07541205734014511, 0.10625316947698593, -0.25140243768692017, -0.09899509698152542, -0.04515153914690018, 0.2237987220287323, -0.003989939112216234,
    -0.19351665675640106, 0.26421165466308594, -0.17778128385543823, 0.1791871041059494, 0.020483728498220444, -0.0684720054268837, 0.0691726952791214, 0.009895890951156616,
    -0.054224882274866104, 0.07483874261379242, -0.18925900757312775, 0.03229263797402382, 0.13501547276973724, -0.1823856681585312, -0.020873913541436195, -0.185095876455307,
    0.02839985117316246, 0.008710481226444244, 0.06349427253007889, -0.01571335271000862, -0.02784663811326027, -0.006119858473539352, -0.04039348289370537, 0.1585484743118286,
    0.23276962339878082, 0.07738986611366272, -0.14481355249881744, 0.11314767599105835, -0.1529361605644226, 0.19937816262245178, 0.1962704211473465, -0.10270420461893082,
    0.013927123509347439, -0.0024472505319863558, 0.0107555091381073, 0.015347362495958805, 0.14128264784812927, -0.05889521911740303, 0.023719284683465958, -0.03816764056682587,
    -0.12170819193124771, -0.09502898901700974, 0.09494715929031372, 0.17662964761257172, 0.024454781785607338, -0.10172713547945023, -0.04344305768609047, -0.13653095066547394,
    -0.12776722013950348, -0.120137058198452, -0.061344027519226074, -0.09496543556451797, -0.2513650059700012, 0.05452973395586014, -0.10118816792964935, 0.06100109964609146,
    0.0745769515633583, -0.10652540624141693, 0.09628548473119736, -0.027386309579014778, -0.18993309140205383, 0.028647638857364655, 0.08880696445703506, 0.17820215225219727,
    0.03958430513739586, 0.1773434728384018, -0.1267738938331604, -0.12790118157863617, 0.02355062961578369, 0.05600550025701523, 0.05044165626168251, 0.06940434873104095,
    -0.14417973160743713, 0.07070621103048325, 0.4204597771167755, -0.0655168890953064, 0.14422495663166046, 0.051620710641145706, 0.04235639423131943, -0.07194440066814423,
    0.015583142638206482, 0.014801139943301678, -0.0010524449171498418, 0.02633792720735073, -0.016632558777928352, 0.0157613642513752, 0.11847785860300064, -0.0017706950893625617,
    -0.13610483705997467, -0.23000547289848328, 0.03994451463222504, -0.01123826950788498, 0.04305681213736534, -0.045238196849823, 0.13639479875564575, -0.06695239245891571,
    0.05719039961695671, -0.03097342513501644, 0.07296628504991531, 0.0043629007413983345, -0.013685527257621288, 0.24544663727283478, 0.07933036983013153, 0.13631390035152435,
    -0.005402085836976767, -0.08825985342264175, 0.1262734979391098, 0.10196316242218018, 0.12125907093286514, -0.05152689665555954, -0.008190080523490906, 0.06468069553375244,
    -0.12141875922679901, 0.051316700875759125, -0.11332240700721741, -0.18956828117370605, -0.13204696774482727, -0.019709009677171707, -0.3077784478664398, 0.09665605425834656,
    -0.5393770337104797, 0.06885143369436264, 0.004900219850242138, 0.028790010139346123, -0.2284405380487442, -0.1405472755432129, 0.13340100646018982, -0.05547831952571869,
    -0.07912981510162354, -0.025033168494701385, 0.11302682757377625, 0.0373457632958889, 0.032958462834358215, -0.09393516927957535, 0.05201457068324089, -0.028799014165997505,
    -0.07389272749423981, -0.02132323570549488, 0.5366751551628113, 0.018329616636037827, 0.003274014452472329, 0.2545769214630127, 0.1263960748910904, -0.010117174126207829,
    0.04542163014411926, -0.08159997314214706, -0.014203494414687157, -0.16684743762016296, -0.24407263100147247, 0.11303593218326569, -0.0504840612411499, -0.17687352001667023,
    -0.2956216037273407, 0.06665770709514618, 0.21149106323719025, 0.12845194339752197, -0.10051804780960083, -0.10510069131851196, 0.26910242438316345, 0.06120544672012329,
    0.0678810179233551, -0.026115741580724716, 0.025167135521769524, 0.11499415338039398, -0.07102149724960327, -0.04886739328503609, 0.026697369292378426, 0.005832805298268795,
    -0.1835477203130722, -0.017166893929243088, 0.22929216921329498, -0.2993564009666443, -0.07698211073875427, -0.11131785809993744, -0.14992158114910126, -0.08598192036151886,
    -0.11946767568588257, -0.01790083572268486, -0.04748707637190819, -0.13998539745807648, -0.26114514470100403, 0.07903940230607986, 0.038689985871315, -0.17206256091594696,
    -0.08913391828536987, 0.10743822902441025, -0.004257022403180599, 0.06351780891418457, 0.09584805369377136, -0.10440447926521301, -0.07978769391775131, 0.022909101098775864,
    -0.04757225885987282, 0.14760728180408478, -0.2990500330924988, 0.058944351971149445, 0.05579255521297455, -0.05533970147371292, 0.09626477211713791, 0.028600845485925674,
    -0.022124184295535088, 0.22077637910842896, 0.19395659863948822, 0.06372113525867462, 0.05305298790335655, -0.2250189632177353, 0.0018108664080500603, -0.03322076424956322,
    -0.00964736845344305, 0.03955645114183426, 0.033665213733911514, 0.021186145022511482, -0.005628826096653938, -0.12156282365322113, 0.13676953315734863, -0.0015514119295403361,
    0.023113451898097992, -0.3590770661830902, 0.03875409811735153, -0.06415937095880508, -0.01598794013261795, 0.034912001341581345, -0.11177629977464676, -0.06951075792312622,
    0.12922053039073944, 0.02592325024306774, -0.03993124142289162, -0.04679415374994278, 0.0094459792599082, -0.11725077778100967, 0.05323345214128494, 0.08916088938713074,
    0.2717975080013275, 0.25691452622413635, 0.10456721484661102, 0.013250960037112236, -0.014578652568161488, 0.16593995690345764, 0.12732301652431488, 0.17009778320789337,
    -0.3030164837837219, -0.007409507408738136, 0.03654945641756058, -0.1692003607749939, -0.09048306196928024, -0.12200319766998291, -0.032251276075839996, 0.1471104621887207,
    0.07849892973899841, 0.05169687792658806, -0.011771167628467083, 0.07773149013519287, -0.03259895369410515, 0.060907330363988876, -0.06171165779232979, -0.07627730816602707,
    0.0909361019730568, -0.20496712625026703, -0.06835257261991501, -0.13930504024028778, 0.0003557771269697696, -0.09540435671806335, 0.03773678094148636, -0.014402979053556919,
    0.15897341072559357, -0.18261957168579102, 0.14490950107574463, 0.06591504067182541, -0.013803130947053432, -0.11646798253059387, -0.008561634458601475, 0.04673885926604271,
    -0.039333973079919815, 0.039793793112039566, -0.03897778317332268, -0.11364725232124329, -0.13156592845916748, -0.4031555950641632, -0.01824839785695076, -0.05332411453127861,
    0.07813990861177444, -0.16266731917858124, -0.045263517647981644, 0.059234827756881714, 0.020309124141931534, -0.28183436393737793, 0.10614465177059174, 0.1102425754070282,
    0.05961482599377632, 0.005554450210183859, 0.09263721853494644, -0.07161184400320053, -0.07089840620756149, 0.1926340013742447, -0.01249888725578785, 0.0039958893321454525,
    -0.2270834594964981, -0.03047592006623745, 0.4034044146537781, 0.13370542228221893, 0.007148149888962507, -0.0693393424153328, -0.025462839752435684, -0.2110365331172943,
    -0.0696212574839592, 0.0677558109164238, -0.3830319344997406, -0.1558612734079361, 0.2475864142179489, -0.10141181945800781, 0.34845811128616333, -0.05508039519190788,
    0.04702923819422722, -0.020342012867331505, 0.0028224291745573282, 0.012982693500816822, 0.006275797262787819, -0.04832339286804199, -0.14462104439735413, -0.015609043650329113,
    0.02218051254749298, -0.07671526819467545, 0.05654963478446007, 0.03839549422264099, 0.02757994644343853, -0.008737843483686447, 0.096443310379982, 0.08984606713056564,
    0.11666521430015564, 0.08050961792469025, -0.009009432047605515, 0.04920045658946037, 0.09195137768983841, 0.08900010585784912, -0.06976108998060226, -0.1347714215517044,
    -0.14881378412246704, -0.02972087636590004, 0.09125889092683792, -0.07503325492143631, 0.025664810091257095, -0.10861175507307053, 0.13715870678424835, 0.08894902467727661,
    0.009838868863880634, -0.08532502502202988, 0.02297540195286274, -0.025810735300183296, 0.043514396995306015, -0.11956170946359634, -0.17953820526599884, -0.09404602646827698,
    0.1966446340084076, -0.09635037183761597, -0.005887060891836882, 0.004042874090373516, 0.02959059178829193, 0.03821566328406334, 0.05057992786169052, 0.22519966959953308,
    -0.3561787009239197, -0.3019239902496338, 0.12126974016427994, -0.16346870362758636, 0.021062400192022324, 0.12013231217861176, -0.07732775807380676, -0.11219519376754761,
    -0.27344027161598206, 0.03245823085308075, 0.04965128377079964, 0.15445572137832642, 0.07611071318387985, -0.25865596532821655, 0.1690155267715454, 0.029499802738428116,
    0.5634416341781616, 0.09435199946165085, -0.00609310669824481, -0.0075205424800515175, 0.06501228362321854, 0.20202143490314484, -0.07441863417625427, 0.02073206938803196,
    0.13276158273220062, -0.10730894654989243, -0.06491078436374664, -0.0032203183509409428, -0.005480364430695772, -0.1082785353064537, -0.07535829395055771, 0.037264496088027954,
    0.14298364520072937, 0.07762514054775238, -0.4286234378814697, -0.010841593146324158, -0.03200289234519005, -0.14141149818897247, -0.047574009746313095, 0.02618367411196232,
    0.018175670877099037, 0.016149040311574936, 0.11341612040996552, 0.014386038295924664, 0.09823676198720932, 0.03637206554412842, 0.04628893733024597, 0.058361344039440155,
    0.2715093195438385, 0.12951962649822235, -0.03846345469355583, -0.05459558218717575, 0.08675046265125275, -0.16449832916259766, 0.05105606094002724, 0.13372157514095306,
    0.04655573144555092, -0.043218694627285004, 0.12527643144130707, -0.07869666069746017, 0.13225169479846954, -0.08564300835132599, -0.003266414860263467, 0.04700298234820366,
    -0.14767234027385712, -0.06051445007324219, -0.17943567037582397, 0.09165853261947632, 0.06907372176647186, 0.06651108711957932, -0.03289295360445976, -0.15604037046432495,
    -0.025980154052376747, -0.05437802895903587, -0.47094038128852844, -0.26926708221435547, 0.25629401206970215, -0.08242322504520416, 0.04303959012031555, 0.16529987752437592,
    -0.08372979611158371, -0.030785147100687027, 0.08129764348268509, 0.05535983294248581, -0.02867927774786949, -0.020167695358395576, -0.10092641413211823, -0.03269147500395775,
    -0.02597728930413723, -0.006318121682852507, 0.04111773893237114, -0.0025398978032171726, 0.13733841478824615, 0.12625227868556976, 0.1374630630016327, 0.06024682894349098,
    -0.04101165384054184, -0.08234426379203796, 0.009981951676309109, -0.03134730085730553, 0.121527761220932, -0.08711590617895126, 0.04968392848968506, -0.055760227143764496,
    0.06747451424598694, 0.08749523013830185, -0.044135503470897675, 0.05292946472764015, -0.04042716696858406, 0.0704602375626564, 0.01019118633121252, 0.1617203950881958,
    -0.1395735889673233, 0.3296101987361908, -0.07636544853448868, 0.06413663178682327, -0.00017021439271047711, 0.144183948636055, 0.1312033236026764, 0.299548476934433,
    0.02344590425491333, -0.13328658044338226, 0.057263460010290146, 0.05634530633687973, 0.02227821946144104, 0.27423498034477234, 0.04834519326686859, -0.24050508439540863,
    0.16719868779182434, 0.2682083249092102, 0.010697469115257263, -0.14212140440940857, 0.1480649709701538, 0.0401257760822773, 0.021804064512252808, -0.18962141871452332,
    -0.08226273208856583, -0.03169694542884827, -0.07798925042152405, 0.12401037663221359, 0.1740674525499344, -0.07151870429515839, -0.074042409658432, 0.08140519261360168,
    0.2477484494447708, 0.18019801378250122, 0.055144891142845154, 0.12247761338949203, -0.01609482429921627, -0.1300654411315918, -0.1178722158074379, 0.024118473753333092,
    -0.0880853459239006, 0.176853746175766, 0.042921844869852066, -0.1465441733598709, -0.0063828942365944386, 0.0012914326507598162, -0.0413203239440918, 0.031307436525821686,
    -0.010293401777744293, 0.04054228588938713, -0.23895566165447235, -0.0059003764763474464, -0.08975296467542648, 0.2762742340564728, 0.037116482853889465, 0.10011588037014008,
    0.040308598428964615, -0.024563271552324295, 0.17870593070983887, 0.12178215384483337, 0.04316096380352974, -0.04440433904528618, -0.10777530819177628, 0.013183598406612873,
    -0.16629375517368317, 0.026011377573013306, 0.10291294753551483, -0.020991675555706024, -0.03253545984625816, -0.12720778584480286, 0.276882141828537, 0.0672382265329361,
    0.040710870176553726, 0.015362600795924664, 0.16701781749725342, -0.24892638623714447, 0.3105207681655884, -0.09290016442537308, -0.013086914084851742, 0.125087171792984,
    -0.05846327170729637, -0.04809229448437691, -0.34042888879776, -0.1862342804670334, 0.12097585946321487, -0.05247718468308449, 0.02121829055249691, -0.17820385098457336,
    -0.016586054116487503, -0.029702523723244667, -0.11156375706195831, -0.3012961149215698, -0.01220269687473774, -0.17552965879440308, -0.397452175617218, -0.0976930633187294,
    -0.0880647674202919, 0.020298374816775322, -0.02027105540037155, -0.052443187683820724, -0.009576689451932907, 0.01949034258723259, -0.16363848745822906, -0.0723983570933342,
    0.03672626614570618, -0.02029344066977501, -0.14902149140834808, 0.018622225150465965, 0.11453036218881607, -0.277133047580719, 0.12714576721191406, -0.03977440297603607,
    -0.2385205179452896, -0.01544208638370037, 0.18354038894176483, 0.0032528480514883995, 0.14810776710510254, -0.12519988417625427, 0.013692265376448631, 0.1650093048810959,
    0.05092232674360275, 0.09084942191839218, -0.16966331005096436, 0.044727299362421036, 0.044313810765743256, 0.06439879536628723, -0.21729148924350739, 0.18462371826171875,
    -0.15884651243686676, 0.25801271200180054, 0.01914147287607193, -0.036579232662916183, 0.018811959773302078, -0.11158435791730881, 0.028046876192092896, -0.10574273020029068,
    -0.1290467232465744, 0.0711873471736908, 0.0029789162799715996, -0.043310366570949554, -0.009271621704101562, -0.14404049515724182, -0.0255744569003582, -0.009898727759718895,
    0.05100320652127266, 0.014088149182498455, 0.05508098006248474, 0.3177185356616974, -0.07022535055875778, 0.0176529623568058, -0.05660364404320717, -0.11555954813957214,
    0.020298436284065247, 0.014175496995449066, 0.17502380907535553, 0.0844995379447937, -0.022559596225619316, -0.04121733456850052, 0.0666055828332901, -0.007911872118711472,
    -0.2900126874446869, 0.022358186542987823, -0.18207091093063354, 0.013240809552371502, -0.21170534193515778, -0.2596893906593323, -0.2565155327320099, 0.017845679074525833,
    -0.053710728883743286, 0.07350276410579681, -0.010476245544850826, -0.29776716232299805, 0.0637475922703743, 0.1185087040066719, 0.15698112547397614, -0.021429169923067093,
    0.014408652670681477, 0.005429373588413, 0.4006800949573517, -0.09028712660074234, 0.04381353035569191, -0.15665243566036224, 0.10199635475873947, 0.09490197151899338,
    0.03690464794635773, -0.04716780409216881, 0.17338934540748596, -0.08620156347751617, -0.06213223189115524, -0.283277302980423, -0.031656861305236816, 0.05649634823203087,
    -0.13010530173778534, -0.1019449457526207, -0.09966137260198593, -0.12185738980770111, 0.032609108835458755, 0.03952053189277649, 0.2572196125984192, 0.1613186150789261,
    0.009253112599253654, 0.027301236987113953, 0.012724123895168304, -0.015091423876583576, -0.061082031577825546, -0.030030343681573868, 0.007694200146943331, 0.1418178677558899,
    0.09939289838075638, -0.07304675877094269, 0.15939652919769287, 0.15144075453281403, -0.007278370205312967, 0.057730820029973984, 0.09033883363008499, -0.17892934381961823,
    -0.016811225563287735, 0.09555426239967346, -0.13248616456985474, -0.141440749168396, -0.06224127858877182, -0.24858565628528595, 0.09701937437057495, -0.1407044231891632,
    0.13538582623004913, -0.0014045782154425979, 0.016899950802326202, -0.11404205858707428, 0.058820199221372604, -0.2801894545555115, -0.25922051072120667, 0.12361913174390793,
    -0.017254821956157684, 0.11606798321008682, 0.1543782353401184, 0.22956934571266174, -0.034292519092559814, 0.19721448421478271, 0.08540815114974976, 0.12788569927215576,
    0.04572185128927231, -0.12676647305488586, -0.04569847136735916, 0.013216132298111916, 0.04237426817417145, -0.040647514164447784, 0.04654768481850624, -0.07825609296560287,
    0.1307206153869629, 0.21226251125335693, -0.10843440890312195, -0.07560446858406067, 0.013182951137423515, -0.04859332740306854, -0.13607503473758698, 0.06804166734218597,
    -0.015986615791916847, -0.23450809717178345, 0.27873992919921875, -0.23840126395225525, 0.04487060382962227, 0.14189596474170685, -0.1449432671070099, -0.19457712769508362,
    -0.18560175597667694, 0.03833898529410362, -0.04226479306817055, -0.037688907235860825, 0.05828586220741272, -0.04851732775568962, -0.0004960063961334527, 0.1333366334438324,
    -0.23335421085357666, -0.44389355182647705, 0.12164901196956635, -0.011053115129470825, -0.10469482839107513, -0.049143437296152115, 0.061377234756946564, 0.1420551985502243,
    -0.23233401775360107, -0.002044005785137415, -0.1879318505525589, -0.25123512744903564, 0.07918823510408401, 0.173813596367836, 0.04584743082523346, 0.04860038310289383,
    -0.399917334318161, -0.01499670185148716, -0.24431918561458588, -0.18351133167743683, -0.012174835428595543, 0.1877894401550293, -0.06076256185770035, 0.023036105558276176,
    -0.1606382429599762, -0.11464324593544006, -0.06738322973251343, -0.26175495982170105, 0.07695112377405167, -0.01499333418905735, -0.09400315582752228, 0.009241858497262001,
    0.20157179236412048, 0.11458846926689148, 0.10600296407938004, -0.053300388157367706, 0.062128134071826935, -0.10281547904014587, -0.0695384219288826, 0.0738588273525238,
    0.043243128806352615, 0.017189661040902138, -0.03527418524026871, -0.3616606593132019, 0.02418835461139679, 0.3631884455680847, 0.29639890789985657, -0.03126457333564758,
    0.1890966296195984, 0.16340234875679016, -0.007438101340085268, -0.08605808764696121, -0.03693513572216034, 0.132058247923851, 0.3109731674194336, 0.09976977854967117,
    0.06679677218198776, -0.05373096838593483, 0.06470568478107452, -0.1104896292090416, -0.10172263532876968, 0.018548471853137016, 0.07511131465435028, -0.07020989060401917,
    0.1081041693687439, 0.05510511249303818, 0.09271936863660812, 0.05313446745276451, 0.10136184096336365, -0.0036668144166469574, 0.163185253739357, 0.009549472481012344,
    0.02231314405798912, -0.12358731031417847, -0.17249242961406708, -0.32248249650001526, 0.05724259838461876, -0.1365986317396164, -0.0781308189034462, 0.14532126486301422,
    0.1920584738254547, 0.017505401745438576, -0.0002422911929897964, 0.005713199265301228, -0.09618020802736282, -0.15232829749584198, -0.17269283533096313, -0.09766373038291931,
    0.014728952199220657, -0.10546015948057175, -0.35858744382858276, 0.04045747220516205, 0.10946035385131836, -0.21654529869556427, 0.037675146013498306, 0.027104299515485764,
    0.17846351861953735, -0.14207832515239716, -0.06511532515287399, 0.04907171428203583, -0.18236424028873444, -0.21157415211200714, 0.04466040059924126, -0.05162466689944267,
    -0.11597824096679688, 0.04510883986949921, -0.07100678235292435, 0.0437074638903141, 0.01756877824664116, -0.05498795211315155, 0.11767866462469101, 0.09406905621290207,
    0.20163916051387787, -0.11716939508914948, -0.07290387153625488, -0.07449240237474442, -0.010972694493830204, -0.1131637841463089, -0.22764013707637787, -0.15595750510692596,
    -0.0670548602938652, 0.11528907716274261, -0.16428625583648682, -0.02765219658613205, 0.09853582829236984, 0.14699149131774902, -0.05685253441333771, 0.1450335681438446,
    0.1335311233997345, 0.5687243938446045, 0.24340714514255524, -0.17404501140117645, 0.07518605142831802, 0.01633327640593052, -0.01644233800470829, -0.1333959996700287,
    0.059646401554346085, 0.04644143953919411, 0.1719042956829071, 0.2705594003200531, -0.08814841508865356, 0.19567836821079254, -0.06278286874294281, -0.010833296924829483,
    -0.04627065733075142, 0.07902757078409195, 0.024289363995194435, 0.13773226737976074, 0.002472911961376667, 0.14971603453159332, 0.3638272285461426, -0.026842571794986725,
    -0.083865687251091, -0.1507340669631958, -0.03490961715579033, -0.10500462353229523, 0.06732281297445297, 0.09579375386238098, -0.06082471087574959, -0.033772993832826614,
    0.13072578608989716, -0.04913437366485596, -0.39277344942092896, -0.07976590096950531, 0.04930121824145317, 0.10898794233798981, -0.0166320763528347, -0.10097499191761017,
    -0.02073591761291027, -0.0755506232380867, -0.11729872226715088, -0.30903029441833496, 0.021290283650159836, -0.41480758786201477, -0.014300860464572906, 0.038678716868162155,
    -0.04708255082368851, -0.15867425501346588, 0.044180940836668015, -0.05817660316824913, -0.01620270311832428, -0.009523586370050907, 0.1742616444826126, 0.11869096010923386,
    0.005396103952080011, -0.03861928731203079, -0.07545223087072372, 0.11492922157049179, 0.14431758224964142, -0.09492883831262589, 0.02192290499806404, -0.15370534360408783,
    0.3296118676662445, -0.020637476816773415, 0.1838163286447525, -0.10099601745605469, -0.07368693500757217, 0.18823212385177612, -0.05005333945155144, 0.07441820204257965,
    0.07546862959861755, 0.1300121396780014, -0.2683190703392029, -0.19280143082141876, 0.11132107675075531, -0.04398204758763313, 0.05152798071503639, -0.03965962305665016,
    0.06084010377526283, 0.18208657205104828, 0.08325089514255524, 0.06463436782360077, 0.11776263266801834, -0.12606288492679596, -0.04893367737531662, -0.07504363358020782,
    -0.014540337957441807, -0.20270930230617523, -0.08631636947393417, -0.08829103410243988, 0.1105695441365242, 0.20027808845043182, 0.011038477532565594, -0.04418095946311951,
    -0.07314219325780869, -0.09801694005727768, 0.028159992769360542, -0.026988331228494644, -0.013219879008829594, -0.06429192423820496, -0.05333537980914116, 0.016865616664290428,
    0.08700360357761383, 0.10789842903614044, 0.06110035255551338, 0.015771957114338875, -0.02058119885623455, 0.215012326836586, 0.09747307747602463, 0.0489046573638916,
    -0.15118630230426788, 0.09240411221981049, 0.00907867681235075, 0.198496013879776, 0.019883792847394943, 0.0188722163438797, 0.1477823704481125, -0.09657362103462219,
    0.05014732852578163, 0.08374694734811783, -0.03201010823249817, 0.07160741090774536, 0.07527080178260803, -0.2038668990135193, 0.08609111607074738, -0.07566185295581818,
    0.05352979898452759, -0.3153577744960785, 0.0967317447066307, -0.08412033319473267, 0.3771580159664154, -0.12036237120628357, 0.04994652420282364, -0.19823138415813446,
    -0.1376780867576599, 0.027648141607642174, -0.10925387591123581, 0.32247230410575867, 0.037336066365242004, 0.07883867621421814, -0.0025123252999037504, 0.03935554623603821,
    0.27034199237823486, 0.15715093910694122, 0.11372789740562439, 0.11834418028593063, -0.31071707606315613, -0.0774659812450409, 0.23581665754318237, -0.030851248651742935,
    0.015323296189308167, -0.048349589109420776, 0.20865081250667572, 0.07167945057153702, 0.057999543845653534, 0.10430977493524551, -0.09583859890699387, 0.04946921393275261,
    0.17335590720176697, 0.011269016191363335, -0.0036226483061909676, -0.005458222236484289, 0.023171933367848396, -0.05961121246218681, -0.02651379629969597, -0.3010401129722595,
    -0.00516769802197814, -0.06798353046178818, -0.04772305116057396, 0.06426180154085159, 0.09979275614023209, 0.060427311807870865, -0.16645178198814392, -0.14178849756717682,
    -0.08750758320093155, 0.18314269185066223, 0.04847482964396477, -0.08680225908756256, 0.0242255050688982, 0.13103421032428741, 0.20854738354682922, -0.0114827835932374,
    -0.09766125679016113, -0.007660203147679567, -0.11827877908945084, -0.05920478701591492, 0.03422437235713005, 0.10396042466163635, 0.07356248050928116, 0.1321699023246765,
    0.18558269739151, 0.0195477232336998, 0.10356013476848602, 0.11698240786790848, 0.14854468405246735, -0.11426015198230743, -0.01243511214852333, 0.23461051285266876,
    0.09810920059680939, -0.12186863273382187, -0.008660242892801762, -0.13254572451114655, 0.15547162294387817, 0.022220171988010406, -0.04628134146332741, -0.22493502497673035,
    0.12740395963191986, 0.1213168054819107, 0.023518865928053856, -0.15990221500396729, -0.07557651400566101, 0.07998297363519669, -0.041157662868499756, 0.10426432639360428,
    -0.0030851943884044886, -0.1311110407114029, 0.0971943587064743, 0.1026778295636177, 0.28303277492523193, 0.03790372237563133, -0.030842909589409828, -0.059910848736763,
    -0.18390533328056335, 0.07916020601987839, 0.06215617433190346, -0.02144165337085724, 0.11136794090270996, -0.05412306636571884, 0.026727257296442986, 0.05264489725232124,
    0.11643921583890915, 0.1305309236049652, 0.0008512521162629128, -0.027816321700811386, 0.02764873206615448, 0.14649483561515808, 0.007146334275603294, 0.009881380945444107,
    0.03026360087096691, 0.08158064633607864, 0.049737293273210526, 0.08834872394800186, 0.028267184272408485, -0.044676847755908966, 0.1600630134344101, -0.18300101161003113,
    0.05195709690451622, 0.21155378222465515, -0.011140705086290836, 0.03808663785457611, 0.04766266047954559, 0.21432064473628998, -0.03975683078169823, -0.08770597726106644,
    -0.22553397715091705, -0.06713048368692398, 0.14278176426887512, 0.3236527442932129, 0.09408663958311081, -0.009762337431311607, -0.05311885103583336, -0.003133817808702588,
    -0.3032839298248291, -0.011843007989227772, 0.09388764202594757, 0.2250409573316574, -0.01779712177813053, -0.017987113445997238, 0.10396680235862732, 0.07366956025362015,
    0.10824448615312576, 0.022179093211889267, 0.1443902552127838, 0.1153402030467987, -0.0869847908616066, -0.32431939244270325, -0.04610063135623932, -0.1807800680398941,
    -0.027693510055541992, 0.12011855840682983, 0.10868286341428757, -0.027312520891427994, -0.007497330661863089, 0.02229691483080387, 0.11738096922636032, -0.019294776022434235,
    0.30429017543792725, -0.020257098600268364, 0.40753617882728577, -0.03514246270060539, -0.05668364092707634, -0.10519066452980042, -0.09956460446119308, -0.2903747260570526,
    0.006967044435441494, -0.009393637999892235, -0.1594122052192688, -0.010277179069817066, -0.17923301458358765, 0.33121275901794434, 0.006066561210900545, 0.10713720321655273,
    0.1926724910736084, -0.07394947856664658, -0.0038758092559874058, -0.0649014264345169, 0.052924737334251404, 0.002393518341705203, 0.18375776708126068, 0.01739482209086418,
    -0.032456543296575546, -0.04051877185702324, -0.18659523129463196, -0.07624275982379913, 0.04061144217848778, 0.2154819369316101, 0.0005061720148660243, 0.31106024980545044,
    0.056834012269973755, -0.08302254974842072, 0.04232840985059738, 0.13012538850307465, 0.07876355946063995, -0.2419539988040924, 0.12290352582931519, 0.15165981650352478,
    0.2654695212841034, 0.08303623646497726, 0.08142823725938797, -0.1384214609861374, 0.19093438982963562, -0.03803092613816261, -0.20748114585876465, -0.11082251369953156,
    0.16391655802726746, 0.07577165961265564, 0.04695309326052666, -0.11126087605953217, -0.0041966428980231285, 0.0711391493678093, -0.14827705919742584, -0.021060865372419357,
    -0.013137143105268478, -0.0011511985212564468, -0.12088967859745026, 0.027959801256656647, 0.08157330751419067, -0.13408245146274567, -0.018588334321975708, -0.03296535834670067,
    0.16222020983695984, 0.0350324884057045, 0.027478517964482307, -0.1035526916384697, 0.03359417989850044, -0.08387264609336853, -0.0067183650098741055, 0.15961024165153503,
    0.04574044793844223, 0.1617041975259781, -0.09950476139783859, 0.06571950763463974, 0.06469665467739105, -0.0403335876762867, 0.03572237864136696, -0.0499078594148159,
    0.08341626822948456, 0.1250154823064804, 0.2571775019168854, -0.04807353392243385, -0.022304855287075043, 0.06215460225939751, -0.07982310652732849, 0.22912609577178955,
    0.04874137043952942, 0.2187403440475464, 0.027021564543247223, 0.005264328792691231, 0.08166969567537308, 0.023338990285992622, 0.10941055417060852, -0.03622521832585335,
    0.16756483912467957, 0.3818548619747162, 0.010074076242744923, -0.04041290655732155, 0.02496972493827343, 0.06089342013001442, 0.0020359621848911047, 0.004972225986421108,
    -0.38496583700180054, -0.040505651384592056, -0.08049982786178589, 0.04054223746061325, -0.11396709084510803, 0.03826146572828293, 0.09600497782230377, -0.11831086128950119,
    -0.030758649110794067, -0.1166749969124794, 0.17022556066513062, 0.053639668971300125, 0.06253556907176971, 0.12144529074430466, 0.04797348007559776, -0.09747631847858429,
    -0.09378840029239655, 0.1595337837934494, 0.1260252296924591, -0.1551056206226349, 0.03175107762217522, -0.0711159035563469, 0.06624084711074829, -0.00017804150411393493,
    0.2981744706630707, 0.041578199714422226, -0.03520826995372772, 0.001139231724664569, 0.05044151470065117, 0.07653158158063889, 0.05385635048151016, -0.058893218636512756,
    -0.0786004513502121, 0.023645253852009773, 0.04647816717624664, -0.08994831144809723, -0.316575825214386, -0.29983291029930115, 0.26923084259033203, 0.06081083416938782,
    0.12034714221954346, 0.0006690990412607789, -0.012622196227312088, -0.13470780849456787, 0.03287583217024803, 0.014248552732169628, -0.10503924638032913, -0.06099086254835129,
    -0.05679097771644592, 0.008078877814114094, -0.10633961111307144, -0.05842849239706993, 0.2131011188030243, -0.017881933599710464, 0.03265722468495369, 0.17832988500595093,
    -0.03390117362141609, -0.01650816760957241, 0.1494593620300293, -0.13701306283473969, -0.08934103697538376, -0.056123606860637665, 0.020132089033722878, 0.07825545966625214,
    0.28978872299194336, -0.018719661980867386, 0.06563346087932587, -0.0780092179775238, 0.38988032937049866, -0.07063881307840347, 0.09498034417629242, 0.07103664427995682,
    0.11141769587993622, -0.35149234533309937, -0.0021630432456731796, -0.01684332825243473, 0.030733145773410797, 0.09981737285852432, -0.14109057188034058, -0.006214119028300047,
    -0.004901465494185686, 0.0009771337499842048, -0.07275105267763138, -0.05713272467255592, 0.08368878066539764, 0.11050194501876831, -0.01611356995999813, -0.06478136032819748,
    0.10008390992879868, -0.10647598654031754, 0.045834749937057495, -0.044077977538108826, 0.07441101223230362, -0.0482323132455349, -0.003763859160244465, 0.11067312955856323,
    -0.10697896778583527, 0.09924088418483734, -0.03590557351708412, -0.016667714342474937, -0.04421982541680336, 0.052160970866680145, -0.039427876472473145, 0.034935612231492996,
    -0.12610194087028503, -0.1956997513771057, 0.13104137778282166, -0.12134312838315964, 0.044026508927345276, 0.020654339343309402, 0.12412198632955551, -0.08584167808294296,
    0.04907657206058502, 0.20414628088474274, -0.057410117238759995, -0.03557942435145378, 0.02304154634475708, 0.0016441732877865434, -0.08571314066648483, 0.07670678198337555,
    -0.1005445346236229, -0.3894234895706177, 0.057201072573661804, -0.30188384652137756, 0.1483166217803955, -0.1934162825345993, 0.0898929089307785, 0.042374979704618454,
    -0.04158713296055794, 0.06813676655292511, 0.05024336278438568, -0.056175392121076584, -0.013782733120024204, -0.07142917811870575, -0.024247705936431885, -0.007168151438236237,
    -0.09538701921701431, -0.06801922619342804, -0.20144891738891602, 0.11768749356269836, -0.08486570417881012, 0.36872029304504395, 0.3463677167892456, -0.031518325209617615,
    -0.017138613387942314, -0.03163984417915344, 0.06980641931295395, 0.07448094338178635, -0.022860020399093628, -0.02153402753174305, -0.031217332929372787, -0.005977442022413015,
    0.08186378329992294, -0.0765509232878685, -0.2971510589122772, 0.06080596521496773, 0.1747428923845291, -0.017968691885471344, 0.01842842809855938, 0.08606552332639694,
    0.015919461846351624, -0.005839298013597727, 0.13500036299228668, -0.1122014969587326, 0.20253989100456238, 0.10041530430316925, -0.09279985725879669, 0.07480284571647644,
    -0.17423763871192932, 0.05863826721906662, -0.0842837244272232, -0.11509130150079727, -0.22210153937339783, -0.11691059172153473, -0.12459857016801834, -0.0511031337082386,
    0.046795185655355453, -0.021256178617477417, -0.10462360084056854, 0.05587685480713844, 0.06780575960874557, -0.13177937269210815, 0.07916727662086487, -0.09020794183015823,
    -0.08616903424263, -0.0782175213098526, -0.028512828052043915, 0.0320759192109108, -0.14976069331169128, 0.030086593702435493, 0.010444552637636662, 0.07520341128110886,
    0.06592672318220139, -0.01448499783873558, -0.17495742440223694, -0.17363613843917847, 0.08414027094841003, -0.10182435810565948, -0.04933333769440651, -0.020497268065810204,
    -0.07188338041305542, -0.005286180879920721, -0.06602787226438522, -0.04560140147805214, -0.0756363496184349, -0.028348108753561974, -0.057129234075546265, 0.09814317524433136,
    -0.0195078793913126, -0.16853956878185272, -0.1694280058145523, -0.07047134637832642, 0.10890241712331772, 0.13844351470470428, 0.04122384637594223, 0.03101470321416855,
    -0.09447035193443298, 0.06188831105828285, 0.15651632845401764, 0.034262530505657196, 0.0016833143308758736, -0.07241934537887573, 0.05363049358129501, 0.22343169152736664,
    0.125466987490654, 0.12658467888832092, 0.043775420635938644, 0.060975175350904465, 0.05950871482491493, 0.016821742057800293, -0.04467278718948364, -0.18007336556911469,
    0.12293504178524017, -0.10059081763029099, 0.05445384979248047, -0.054243750870227814, -0.04332588613033295, 0.018107181414961815, 0.027469543740153313, 0.21238206326961517,
    0.05745401605963707, 0.14944259822368622, -0.04880905896425247, -0.006866244599223137, 0.03034309297800064, 0.09329791367053986, 0.040956392884254456, -0.13172845542430878,
    -0.0992356464266777, 0.19280651211738586, -0.01682235114276409, -0.023527543991804123, 0.10765716433525085, -0.16763079166412354, 0.10081080347299576, 0.07695825397968292,
    -0.12882351875305176, -0.012856321409344673, -0.0032053482718765736, -0.10901498049497604, 0.09988368302583694, 0.08160409331321716, 0.02300289459526539, 0.02181396633386612,
    -0.12998512387275696, 0.031265269964933395, -0.12396517395973206, 0.37264761328697205, -0.0851929783821106, -0.038831502199172974, 0.3291519284248352, 0.019063588231801987,
    -0.034917183220386505, -0.11067995429039001, 0.0006748224259354174, -0.09595274925231934, -0.005792496260255575, -0.04077470302581787, -0.15443788468837738, 0.04148147255182266,
    -0.07161975651979446, -0.040983762592077255, -0.03379391133785248, 0.022205550223588943, 0.1654556691646576, -0.051225561648607254, -0.03936462476849556, 0.31461426615715027,
    -0.013304841704666615, -0.009202031418681145, 0.18454620242118835, 0.18857689201831818, 0.21507495641708374, 0.02429233305156231, -0.17420929670333862, 0.05660208314657211,
    -0.059647321701049805, -0.0035908501595258713, -0.03901372477412224, -0.18290407955646515, -0.22447679936885834, 0.1391766220331192, -0.20139844715595245, -0.2851451635360718,
    0.041951365768909454, -0.03638460859656334, -0.16631320118904114, -0.020974760875105858, 0.06020441651344299, -0.06339127570390701, -0.07995578646659851, -0.13818520307540894,
    -0.1642037183046341, -0.024618834257125854, -0.030869700014591217, 0.06692273914813995, 0.1014782264828682, -0.06292195618152618, 0.11464127898216248, 0.09995252639055252,
    -0.002501079812645912, -0.03950567543506622, 0.09776502847671509, -0.22120308876037598, 0.2172330617904663, -0.130029559135437, -0.13257195055484772, -0.04883143678307533,
    -0.026864515617489815, -0.028586771339178085, -0.002468171762302518, -0.09929852932691574, 0.00712246960029006, -0.21179145574569702, 0.04863547161221504, 0.16237714886665344,
    -0.019891228526830673, -0.10959729552268982, -0.0727132186293602, -0.09359211474657059, 0.10751236975193024, -0.27867087721824646, 0.04029777646064758, -0.024499891325831413,
    -0.013815934769809246, 0.22284074127674103, 0.037609998136758804, -0.04890020191669464, 0.15769924223423004, -0.039133500307798386, -0.06800202280282974, 0.07260328531265259,
    0.000830847944598645, 0.12012796103954315, 0.24065706133842468, 0.018286172300577164, 0.03029247745871544, -0.02278466522693634, 0.06479407101869583, -0.18196314573287964,
    0.026796504855155945, 0.15995672345161438, -0.03281642869114876, 0.1059289425611496, 0.05952867493033409, -0.06901588290929794, -0.17441561818122864, -0.029248777776956558,
    -0.1372697651386261, 0.23973239958286285, 0.014671391807496548, 0.08219613879919052, 0.03966595232486725, -0.08910024911165237, -0.10504481941461563, 0.10463492572307587,
    0.09278176724910736, 0.12445403635501862, 0.03619907796382904, 0.290069043636322, -0.043892547488212585, -0.0383581705391407, -0.026522012427449226, 0.07273036241531372,
    -0.18501651287078857, -0.0008855148334987462, 0.009419657289981842, -0.05901626497507095, 0.06954741477966309, -0.137703076004982, 0.0074841976165771484, -0.08204947412014008,
    0.019153153523802757, 0.07042577862739563, -0.12021225690841675, 0.11076200008392334, -0.052630044519901276, -0.1527705192565918, -0.0167820043861866, 0.16817013919353485,
    -0.018572062253952026, 0.046915993094444275, 0.02671962045133114, -0.1230521947145462, -0.028039833530783653, -0.054594386368989944, 0.0067160483449697495, -0.05446114018559456,
    0.1515759378671646, 0.04944964870810509, 0.11878534406423569, -0.08250051736831665, 0.1357056349515915, 0.0287605170160532, -0.05433845892548561, 0.2562727630138397,
    -0.03953041508793831, 0.024682793766260147, 0.04941215366125107, 0.05289934575557709, 0.07484354078769684, -0.051703400909900665, -0.11763917654752731, -0.09264110028743744,
    0.24859851598739624, -0.07710351049900055, 0.06732930988073349, -0.043525438755750656, -0.09920980781316757, 0.08337415009737015, -0.36736607551574707, -0.2414652705192566,
    0.02956734225153923, 0.0006478570285253227, -0.23121707141399384, 0.19802553951740265, 0.1650782823562622, -0.09974338114261627, 0.003396111074835062, -0.07883104681968689,
    -0.23544055223464966, -0.02946268767118454, 0.04031003266572952, -0.11842101812362671, 0.05046875774860382, -0.004897403530776501, -0.027798278257250786, -0.02494354546070099,
    -0.14273233711719513, 0.013662098906934261, 0.2013789266347885, -0.14953379333019257, 0.5103356838226318, -0.23502738773822784, 0.15881933271884918, 0.11598574370145798,
    0.10473751276731491, -0.06208597868680954, 0.01093511562794447, -0.08356261253356934, 0.0171767957508564, -0.18510913848876953, -0.13709770143032074, 0.19016289710998535,
    -0.03585505113005638, 0.09029028564691544, 0.053660620003938675, 0.011394807137548923, 0.10810404270887375, 0.3944908678531647, -0.01647084578871727, -0.04019682854413986,
    0.022899581119418144, 0.070687435567379, 0.0940975472331047, 0.03995714709162712, 0.2521236538887024, 0.0013402178883552551, -0.002375807147473097, -0.018963925540447235,
    -0.12235897034406662, 0.07235383242368698, 0.07611203193664551, -0.003695534775033593, -0.06851805746555328, -0.21725697815418243, -0.0893898755311966, -0.1095752865076065,
    -0.07360459864139557, 0.16183090209960938, -0.04246062785387039, 0.010722309350967407, -0.008859728462994099, 0.05735797807574272, -0.1260945200920105, -0.04041248559951782,
    -0.006538298446685076, 0.08498768508434296, -0.008208860643208027, -0.09799618273973465, -9.87405437626876e-05, -0.08437304943799973, 0.11706927418708801, 0.04242568090558052,
    -0.048625051975250244, -0.31582531332969666, -0.01931125298142433, -0.05589693412184715, 0.15840831398963928, 0.004504895769059658, 0.002043775049969554, 0.0018448102055117488,
    -0.06485593318939209, 0.01665310189127922, 0.023305069655179977, 0.08205382525920868, 0.044366151094436646, -0.019032655283808708, 0.04185657948255539, -0.012806546874344349,
    -0.023961426690220833, 0.12355756759643555, 0.030848251655697823, -0.03147235885262489, -0.1102806106209755, -0.05427456274628639, 0.023551486432552338, 0.11999563872814178,
    -0.14952433109283447, 0.21727217733860016, -0.01748739928007126, -0.02440747804939747, -0.021344797685742378, -0.029730241745710373, -0.008393329568207264, -0.03570231795310974,
    0.08247168362140656, -0.05094127357006073, -0.12924335896968842, -0.02608640305697918, 0.0063264816999435425, -0.029843688011169434, -0.014868110418319702, 0.051331985741853714,
    -0.05472676083445549, 0.11354483664035797, -0.11142703145742416, -0.11422348767518997, -0.20278559625148773, 0.24885688722133636, -0.08007896691560745, -0.084783636033535,
    -0.10441593080759048, 0.14216943085193634, -0.0037798904813826084, -0.01923666149377823, 0.05853734165430069, 0.011452875100076199, -0.29416409134864807, -0.14529791474342346,
    0.04354223981499672, -0.009659208357334137, -0.08134263008832932, 0.15912319719791412, 0.04343491420149803, -0.007956413552165031, -0.02948427014052868, 0.306131511926651,
    -0.2264338582754135, -0.02952883020043373, -0.27665722370147705, 0.03310493379831314, 0.1185217872262001, 0.0036550862714648247, 0.045627713203430176, 0.036740630865097046,
    -0.1663324236869812, -0.08047673851251602, 0.02832699939608574, -0.1256036013364792, 0.215785413980484, -0.05324346944689751, -0.038957130163908005, 0.013475273735821247,
    -0.06052393466234207, 0.06438407301902771, 0.07880198210477829, -0.039771176874637604, -0.10968933254480362, -0.19619272649288177, -0.07309777289628983, 0.21964463591575623,
    0.010617109946906567, 0.004073878284543753, -0.09277870506048203, -0.03612128645181656, -0.013271695002913475, -0.35203713178634644, 0.002846790011972189, -0.007409075740724802,
    -0.025115784257650375, 0.039672937244176865, 0.1232801228761673, 0.06125640496611595, 0.05801660194993019, 0.05292770266532898, 0.0011530674528330564, 0.12134271115064621,
    -0.06792427599430084, 0.054466310888528824, 0.02232252061367035, 0.04504089802503586, 0.14520733058452606, 0.02226152829825878, 0.020908307284116745, -0.09521816670894623,
    -0.06908338516950607, -0.12915951013565063, -0.1277044266462326, 0.017903883010149002, -0.0007038679905235767, -0.0040321131236851215, -0.025634968653321266, 0.0887676253914833,
    -0.06128101423382759, -0.06280487775802612, -0.12951013445854187, 0.06121229752898216, 0.03819146752357483, 0.1735990196466446, 0.0516127273440361, 0.08593111485242844,
    -0.1701515018939972, 0.3446289002895355, 0.1458134949207306, 0.06964819133281708, 0.07838953286409378, 0.11552715301513672, -0.0727475956082344, -0.11307939887046814,
    0.25324520468711853, -0.03438904881477356, 0.014863145537674427, 0.10335174202919006, 0.03533763065934181, -0.06432236731052399, -0.10820348560810089, 0.028269048780202866,
    0.010368826799094677, 0.12116476148366928, 0.15453414618968964, 0.11558914929628372, 0.06794429570436478, 0.04797083139419556, 0.10937617719173431, 0.01170890312641859,
    -0.06674857437610626, 0.09965081512928009, -0.02630157209932804, 0.0031021356116980314, -0.019335780292749405, -0.09096706658601761, -0.11601034551858902, 0.009327772073447704,
    0.007154947146773338, -0.009382786229252815, -0.07017430663108826, -0.0895751565694809, 0.07838132232427597, -0.08527552336454391, 0.07687525451183319, -0.14268843829631805,
    -0.030954308807849884, 0.06784065812826157, 0.12861917912960052, -0.10289548337459564, -0.09214911609888077, -0.30693233013153076, -0.29610195755958557, -0.023148106411099434,
    -0.12709717452526093, -0.11769485473632812, -0.006005798000842333, 0.12002155929803848, 0.21350274980068207, 0.026521630585193634, -0.33281832933425903, -0.16632795333862305,
    0.013812567107379436, 0.051903098821640015, -0.10187415033578873, 0.03207454830408096, 0.044730059802532196, -0.12338679283857346, -0.027309797704219818, 0.37368202209472656,
    -0.06474462896585464, -0.0033259137999266386, -0.06514624506235123, -0.0531311109662056, 0.046460479497909546, 0.06593755632638931, -0.022697359323501587, -0.01990921050310135,
    -0.19597290456295013, -0.0029748263768851757, 0.04660477489233017, -0.1570563018321991, 0.06540992856025696, 0.07360358536243439, 0.22404591739177704, -0.02082180604338646,
    0.01715598627924919, 0.10839321464300156, 0.10182955116033554, -0.03575871139764786, 0.05553745850920677, -0.1105411946773529, 0.0777396634221077, 0.28683632612228394,
    0.025129184126853943, 0.05035698413848877, 0.1665385216474533, 0.05667861923575401, 0.049358200281858444, 0.18550583720207214, 0.0007606110302731395, -0.003587530693039298,
    -0.1306561380624771, -0.08252082020044327, 0.16183225810527802, 0.015103617683053017, 0.09672839939594269, -0.036138977855443954, -0.031653642654418945, 0.17320536077022552,
    -0.04329569265246391, -0.006748030427843332, -0.05759970098733902, 0.012895346619188786, -0.05670614913105965, 0.1429327130317688, -0.09620214998722076, -0.20433859527111053,
    -0.15271669626235962, -0.11829226464033127, -0.008054453879594803, 0.15367162227630615, -0.005707916803658009, 0.06303216516971588, 0.051887959241867065, -0.14151640236377716,
    0.004315265920013189, -0.07236570119857788, 0.05112969130277634, 0.013042076490819454, 0.0004191409097984433, -0.06825412064790726, -0.010229408740997314, -0.058464519679546356,
    0.07679380476474762, -0.28427696228027344, -0.06055840849876404, 0.07117990404367447, -0.060299940407276154, 0.017164411023259163, 0.184207022190094, -0.05737681686878204,
    -0.300212025642395, 0.05142548307776451, -0.014337019063532352, 0.003909606486558914, 0.04357528313994408, -0.06925544887781143, 0.029159827157855034, 0.10838798433542252,
    0.04148273542523384, 0.011045889928936958, 0.0705702006816864, -0.0005586448241956532, -0.08195464313030243, 0.06812255829572678, -0.07100708037614822, 0.015096169896423817,
    0.07694634050130844, -0.16583940386772156, -0.080930694937706, -0.05455968901515007, 0.03793300315737724, -0.06915972381830215, -0.0035379265900701284, -0.027084598317742348,
    -0.07718576490879059, -0.11937834322452545, -0.08432341367006302, -0.04951079189777374, 0.029360981658101082, 0.05882546305656433, -0.078077033162117, -0.1108776181936264,
    0.0017917519435286522, 0.010808510705828667, 0.10372284054756165, 0.04892390966415405, 0.13504831492900848, 0.15213660895824432, -0.0811421126127243, -0.054546695202589035,
    0.12235350161790848, 0.06108429282903671, 0.043020099401474, -0.07563541829586029, 0.2314019501209259, 0.22926416993141174, -0.1359015852212906, -0.11207035183906555,
    -0.04859571531414986, 0.07004284113645554, 0.04335140064358711, 0.09980516880750656, -0.03006899543106556, -0.11532250791788101, -0.055682044476270676, 0.029023049399256706,
    0.06388039141893387, -0.03556680679321289, -0.07372380048036575, 0.075990229845047, 0.07092541456222534, -0.05684399604797363, 0.03451722115278244, -0.20078057050704956,
    -0.0645785853266716, -0.0013054670998826623, -0.07192514836788177, -0.0470721609890461, 0.050908420234918594, -0.06847751140594482, 0.14731191098690033, -0.043261412531137466,
    0.009576783515512943, -0.01160888746380806, -0.008585219271481037, -0.07099325954914093, -0.008727947250008583, -0.031477589160203934, 0.15677551925182343, -0.10685311257839203,
    -0.06408166140317917, -0.05914449691772461, -0.06103988364338875, 0.07975229620933533, -0.06925419718027115, -0.14869102835655212, -0.07998193800449371, -0.0486222468316555,
    0.021615779027342796, -0.12490198016166687, 0.017897475510835648, -0.09717787802219391, 0.08379378914833069, 0.019291047006845474, -0.059337127953767776, 0.10672955214977264,
    0.06876899302005768, 0.04949934035539627, 0.09866593778133392, 0.004047158174216747, 0.04093955084681511, 0.09614665806293488, 0.10857683420181274, 0.07252109050750732,
    -0.05471739545464516, 0.02909059263765812, 0.07698662579059601, 0.053349606692790985, 0.08008351176977158, -0.015112298540771008, -0.05202839523553848, -0.06406281143426895,
    0.17095547914505005, -0.13725966215133667, -0.04990087077021599, 0.05455870181322098, -0.09260633587837219, -0.0014487605076283216, -0.040151678025722504, -0.18085132539272308,
    0.0015400371048599482, 0.0054468815214931965, -0.13764344155788422, 0.16315710544586182, -0.008863886818289757, 0.04001722112298012, 0.0564919151365757, 0.04417000710964203,
    0.04380672052502632, -0.08241645991802216, 0.029512325301766396, 0.04209018126130104, -0.023129355162382126, 0.1013481542468071, -0.11206667125225067, -0.09954410046339035,
    0.018562979996204376, -0.027213474735617638, -0.11622431129217148, 0.12540969252586365, -0.002930074231699109, 0.07291273772716522, 0.12230976670980453, 0.047891370952129364,
    -0.00859883800148964, 0.02435629814863205, -0.05904506519436836, 0.10540463775396347, 3.525387228364707e-06, -0.014238900505006313, 0.17960651218891144, 0.08160330355167389,
    0.0907215103507042, 0.15547893941402435, -0.0070475246757268906, 0.0005208466318435967, -0.03642868623137474, -0.0755648985505104, -0.12733444571495056, 0.0989779531955719,
    -0.006476822774857283, 0.06631648540496826, -0.11196310073137283, -0.005282717756927013, -0.1483076512813568, -0.00922483205795288, 0.13043871521949768, 0.09162171930074692,
    -0.15161757171154022, -0.03349847346544266, 0.004150972235947847, 0.17691895365715027, 0.06853334605693817, 0.04300500452518463, -0.008663972839713097, -0.02277153730392456,
    -0.04281636327505112, 0.033356454223394394, -0.1026984304189682, -0.11274634301662445, -0.0920150950551033, -0.1321340948343277, -0.0032748770900070667, 0.12576988339424133,
    0.13569030165672302, -0.061471473425626755, -0.008484231308102608, -0.011591541580855846, -0.05685073137283325, -0.09657445549964905, 0.11143074184656143, 0.015005321241915226,
    -0.08596674352884293, -0.038065798580646515, -0.022343378514051437, 0.02152165398001671, 0.11428648233413696, 0.1298140287399292, 0.0759633332490921, 0.0021980719175189734,
    -0.01225479505956173, -0.05657481029629707, 0.019127393141388893, -0.0023110718466341496, -0.010599005967378616, -0.0489712655544281, 0.1146160215139389, -0.09272559732198715,
    -0.031842686235904694, -0.09161131829023361, -0.00869365781545639, 0.05895038694143295, -0.11719081550836563, 0.056759268045425415, -0.03171028941869736, -0.037706974893808365,
    0.08648724853992462, 0.017211465165019035, 0.09199424833059311, -0.1168036237359047, -0.059302035719156265, -0.07135748118162155, -0.0216438639909029, -0.03261450305581093,
    0.08507253229618073, 0.02503928728401661, 0.17202262580394745, -0.04583306983113289, 0.006782335229218006, 0.15555720031261444, -0.11630337685346603, 0.034267909824848175,
    -0.062012698501348495, 0.0012297602370381355, 0.0831725001335144, 0.032357584685087204, 0.005668097175657749, 0.026247793808579445, -0.04396932199597359, 0.047768522053956985,
    0.0996956080198288, -0.07901551574468613, -0.2031550109386444, 0.012082322500646114, -0.03162601217627525, -0.037804555147886276, 0.01502254232764244, 0.09289835393428802,
    -0.00042473821667954326, -0.04246026650071144, -0.04056137427687645, 0.01563907414674759, 0.04220025986433029, 0.022629449144005775, 0.06659849733114243, -0.16684237122535706,
    -0.13960400223731995, -0.015606767497956753, -0.02611454762518406, 0.019990958273410797, 0.029013970866799355, -0.04817473143339157, 0.052661895751953125, -0.07108818739652634,
    0.006946224253624678, -0.03168879449367523, -0.19305522739887238, 0.03164825215935707, -0.05380065739154816, -0.09940429776906967, 0.058258216828107834, 0.13085071742534637,
    0.04119780659675598, 0.03636571019887924, -0.13988395035266876, 0.05261342599987984, 0.0035183383151888847, 0.06294845789670944, 0.15259385108947754, 0.014307769946753979,
    -0.13274209201335907, -0.09194507449865341, 0.0005102374707348645, -0.05023546889424324, 0.08248896896839142, -0.011646261438727379, -0.057220831513404846, 0.15605466067790985,
    -0.020540716126561165, 0.008315970189869404, -0.15382371842861176, -0.054184690117836, -0.059138428419828415, 0.11032451689243317, 0.056107308715581894, -0.033416926860809326,
    -0.004936350975185633, 0.038893453776836395, 0.008840612135827541, 0.12120451778173447, 0.03987584635615349, -0.11327946186065674, 0.09807784855365753, -0.023223431780934334,
    -0.049552638083696365, -0.04831552505493164, -0.09492464363574982, 0.010739767923951149, 0.023104161024093628, 0.08059684187173843, 0.07911352068185806, -0.060246311128139496,
    0.08846471458673477, -0.03674132376909256, -0.03220498934388161, -0.11152783781290054, -0.07815683633089066, -0.10842909663915634, 0.13638898730278015, -0.02203385904431343,
    -0.04876387491822243, 0.027100984007120132, 0.008939549326896667, -0.025147361680865288, 0.005195221863687038, 0.14636024832725525, -0.05674930661916733, 0.06199822202324867,
    0.08330763131380081, -0.014930101111531258, 0.03440558910369873, 0.03344620391726494, 0.01982192136347294, -0.19925135374069214, 0.213874951004982, 0.0003396057873032987,
    0.05863536149263382, 0.02476472035050392, 0.10251610726118088, 0.022068766877055168, -0.022698432207107544, 0.01949288323521614, -0.06899411231279373, -0.005991098005324602,
    0.04177405312657356, 0.10699193179607391, -0.003702078713104129, -0.012053749524056911, -0.08731264621019363, -0.0729752704501152, 0.0071132308803498745, 0.1319389045238495,
    0.10118351876735687, 0.12902936339378357, 0.05666372925043106, -0.0075856600888073444, 0.01921815611422062, 0.08565942943096161, -0.11809156835079193, 0.04529346153140068,
    -0.06024045869708061, -0.09062941372394562, -0.08503882586956024, 0.008219960145652294, -0.07880431413650513, 0.03524995222687721, 0.05614689737558365, 0.10725050419569016,
    0.005350241903215647, 0.017245283350348473, -0.14112836122512817, 0.0428672656416893, 0.034661807119846344, 0.052444979548454285, -0.0013358001597225666, 0.22851108014583588,
    -0.061754483729600906, 0.062092024832963943, -0.03409244492650032, -0.2660118639469147, 0.055944062769412994, -0.08210622519254684, 0.0028607742860913277, -0.0803111344575882,
    -0.11728332191705704, 0.10088564455509186, 0.011493842117488384, -0.01145497988909483, 0.10002695769071579, -0.06956443190574646, 0.0846509337425232, -0.024740753695368767,
    0.02360088750720024, 0.04614049568772316, -0.05309661105275154, -0.10204893350601196, 0.06795541942119598, -0.1909950226545334, -0.002391079207882285, -0.04779978469014168,
    -0.0011793700978159904, 0.016436630859971046, -0.15263451635837555, -0.06664212793111801, 0.006002041976898909, 0.034603361040353775, -0.2976761758327484, -0.006806326564401388,
    -0.13423141837120056, -0.05712444707751274, -0.03128516674041748, -0.03519979864358902, 0.12721362709999084, 0.035129107534885406, 0.13923192024230957, -0.02533259429037571,
    -0.06300689280033112, 0.06862162798643112, 0.026496563106775284, 0.002204787451773882, 0.04089730605483055, 0.08181922137737274, 0.06115618348121643, -0.004163611680269241,
    0.11959215253591537, 0.0222561564296484, -0.01712089031934738, -0.00705069350078702, -0.007225304376333952, -0.1906391829252243, 0.1205100417137146, 0.05724785104393959,
    -0.09237100183963776, 0.0071838004514575005, 0.01789006218314171, 0.20309801399707794, 0.03985690325498581, 0.4194278419017792, -0.019391080364584923, -0.08078283816576004,
    -0.006859293673187494, -0.039705995470285416, 0.0424095019698143, 0.07899197190999985, 0.021747414022684097, -0.03772592917084694, 0.13943210244178772, -0.2189932018518448,
    -0.03569215163588524, 0.007638700772076845, -0.08264419436454773, 0.027010181918740273, 0.06891000270843506, -0.1390959471464157, -0.017891740426421165, -0.033819276839494705,
    0.04622988402843475, -0.06372824311256409, -0.06408039480447769, -0.08196451514959335, -0.014675243757665157, -0.024813959375023842, 0.14481185376644135, 0.030524834990501404,
    0.019486840814352036, 0.12372095882892609, -0.04654427990317345, -0.043731123208999634, 0.0014595641987398267, -0.039154183119535446, -0.048675402998924255, -0.014280912466347218,
    -0.05564374104142189, -0.07715105265378952, 0.0351283960044384, 0.008671378716826439, 0.13888657093048096, -0.02337629161775112, -0.05735250189900398, 0.1699472963809967,
    0.06599924713373184, 0.09744957834482193, -0.07130283862352371, -0.022085580974817276, 0.05750424787402153, -0.016463791951537132, -0.05396714061498642, 0.011804143898189068,
    0.04798346385359764, 0.031153257936239243, -0.1629778891801834, 0.09300968796014786, 0.0293476190418005, 0.03701623156666756, 0.0498170405626297, -0.09209723770618439,
    0.12316439300775528, -0.03525355085730553, -0.08706223219633102, 0.019840359687805176, 0.004754248075187206, 0.00851092766970396, -0.026977339759469032, -0.017822274938225746,
    0.022656481713056564, -0.00042575178667902946, -0.015927940607070923, 0.033658407628536224, -0.10667210817337036, -0.1225755512714386, 0.029674595221877098, 0.0631542056798935,
    0.038457196205854416, 0.003710111603140831, 0.03783239424228668, 0.08282984793186188, 0.032274264842271805, 0.047682177275419235, -0.09757282584905624, 0.05679459124803543,
    0.04030795395374298, 0.020772239193320274, -0.05672848969697952, 0.052199844270944595, 0.09941927343606949, 0.03896498307585716, 0.01597120426595211, -0.11241210252046585,
    0.045311905443668365, 0.05955410376191139, 0.03739197924733162, 0.007009255699813366, -0.03179037943482399, 0.10777735710144043, -0.24828261137008667, 0.012736980803310871,
    0.10408063232898712, 0.034451574087142944, 0.03951160982251167, 0.008323454298079014, 0.062313225120306015, -0.056216783821582794, -0.024548325687646866, -0.022654887288808823,
    -0.03405030071735382, 0.021380476653575897, 0.0948767438530922, 0.02237132005393505, -0.027968397364020348, 0.0313619002699852, 0.08445584774017334, 0.22665518522262573,
    -0.1369623988866806, -0.030306054279208183, 0.01677783578634262, 0.19989243149757385, -0.014156957156956196, -0.013517140410840511, 0.00822675134986639, 0.04732297360897064,
    -0.0802772268652916, -0.018633967265486717, -0.0497918538749218, 0.07766693085432053, 0.01955384574830532, 0.3684823513031006, 0.03367745503783226, 0.0016132013406604528,
    -0.051821958273649216, -0.0016666987212374806, 0.04157399386167526, 0.032637014985084534, 0.0037661115638911724, 0.01305184792727232, -0.04274870455265045, 0.02728818729519844,
    -0.01709629036486149, -0.013096531853079796, -0.04990599676966667, 0.06496459990739822, 0.23762840032577515, -0.06137071177363396, -0.14185258746147156, -0.019360408186912537,
    -0.2583697736263275, 0.009374490939080715, 0.11795797199010849, -0.0002548373013269156, -0.009789076633751392, 0.017510607838630676, 0.059080611914396286, 0.010857921093702316,
    0.018378904089331627, 0.05571110546588898, -0.12301415950059891, -0.010452108457684517, 0.014566350728273392, -0.0030495659448206425, -0.0538688562810421, -0.05511152371764183,
    0.014325468800961971, 0.07341248542070389, 0.04428831860423088, 0.06840457767248154, 0.0145436255261302, -0.051086630672216415, 0.01662161387503147, -0.17373117804527283,
    0.026247143745422363, 0.06306317448616028, -0.08978355675935745, -0.02669116109609604, -0.03443780168890953, 0.05399075150489807, -0.10523144900798798, -0.018664399161934853,
    -0.04365268349647522, 0.0421050488948822, -0.08102753013372421, 0.017035236582159996, -0.001013971515931189, -0.03992609307169914, 0.01617194525897503, -0.056512247771024704,
    0.023495523259043694, -0.08256065100431442, -0.1118881106376648, -0.06063075363636017, 0.017959795892238617, -0.09824186563491821, 0.001705956761725247, 0.012426016852259636,
    0.015629569068551064, 0.01036224514245987, -0.07779295742511749, 0.16446420550346375, -0.15733738243579865, -0.023922709748148918, 0.017272114753723145, -0.0839163288474083,
    -0.07529152184724808, 0.0009087652433663607, -0.03500790148973465, 0.1388063281774521, -0.10520564019680023, 0.20392413437366486, -0.017598774284124374, -0.01043385174125433,
    -0.014453191310167313, -0.13873612880706787, -0.11992640048265457, 0.015718869864940643, -0.059416286647319794, 0.030672382563352585, 0.03214516490697861, 0.12569786608219147,
    0.14683076739311218, 0.07110309600830078, -0.006138388998806477, -0.06645578891038895, -0.009201512672007084, 0.017898043617606163, 0.02291453815996647, -0.00350265228189528,
    0.11167042702436447, -0.07880107313394547, 0.022162161767482758, 0.039500750601291656, 0.1439495086669922, -0.009592922404408455, -0.015515698119997978, -0.05709869787096977,
    -0.007036018185317516, 0.04947425052523613, 0.0020282582845538855, 0.10345049947500229, -0.007482231128960848, 0.021512409672141075, 0.021294917911291122, -0.16350598633289337,
    0.0067414529621601105, 0.0028244706336408854, 0.005584610626101494, 0.12379108369350433, -0.03234009072184563, 0.04096515104174614, 0.1229061409831047, 0.0374746136367321,
    -0.0653376579284668, -0.03185490891337395, -0.045424118638038635, -0.032643724232912064, 0.09721777588129044, -0.06300446391105652, -0.012198668904602528, 0.023678936064243317,
    0.057523712515830994, -0.04829562082886696, -0.15675486624240875, -0.07352025806903839, 0.025808539241552353, -0.03463549166917801, -0.05211595073342323, 0.08880364149808884,
    -0.021113693714141846, 0.005453955847769976, -0.08795405924320221, 0.03392212092876434, 0.10613151639699936, 0.08711304515600204, 0.10334380716085434, 0.05637132748961449,
    -0.16620078682899475, -0.03773438557982445, -0.004406745079904795, -0.044233936816453934, 0.03812656179070473, -0.12593960762023926, 0.0308240856975317, 0.0047499313950538635,
    0.0024870524648576975, -0.02470250055193901, -0.07706738263368607, -0.01291637308895588, 0.008074222132563591, 0.061300866305828094, 0.011256794445216656, -0.02065417170524597,
    0.056620292365550995, 0.15421617031097412, -0.04101244732737541, 0.20140936970710754, 0.02935737557709217, 0.06388309597969055, 0.010338876396417618, 0.07993607968091965,
    -0.06267029047012329, 0.08160820603370667, -0.06842910498380661, -0.0450824536383152, -0.04588756337761879, 0.06324063241481781, -0.08162446320056915, -0.0022992563899606466,
    -0.05023608356714249, 0.04857434332370758, 0.014117992483079433, 0.06255503743886948, 0.03198259323835373, 0.049508143216371536, -0.08478815853595734, 0.04736432060599327,
    -0.044763993471860886, 0.041000958532094955, 0.009124472737312317, -0.025468790903687477, 0.01902078464627266, 0.12821169197559357, -0.006643179804086685, 0.1162400171160698,
    -0.040729254484176636, -0.0474378764629364, 0.0649397075176239, -0.01641235128045082, -0.12271693348884583, 0.006283696740865707, -0.059891004115343094, -0.05154527351260185,
    -0.10142787545919418, 0.018781406804919243, 0.026008376851677895, 0.018014712259173393, -0.02624513953924179, 0.06925728917121887, 0.034564029425382614, -0.05826161801815033,
    -0.03985152021050453, -0.14068681001663208, -0.06334633380174637, -0.10475511848926544, 0.011465057730674744, 0.04728933796286583, 0.09130319207906723, 0.0442918986082077,
    0.04321083426475525, -0.115632563829422, -0.07427798211574554, -0.002890706295147538, 0.014535265974700451, 0.07160017639398575, 0.10717960447072983, -0.017671965062618256,
    0.009957081638276577, 0.020557204261422157, -0.026112698018550873, 0.02686481922864914, -0.08912742882966995, 0.05172131210565567, 0.05532316863536835, -0.0077641187235713005,
    0.008900563232600689, 0.00669430335983634, 0.024457214400172234, 0.035132743418216705, 0.0912175178527832, 0.13911740481853485, 0.023771971464157104, -0.08318033814430237,
    0.10596726834774017, -0.007474127225577831, 0.005725243128836155, 0.07624464482069016, -0.03781270608305931, -0.05441144108772278, 0.17020262777805328, 0.005173113662749529,
    -0.06721802800893784, 0.05153663828969002, 0.04578394070267677, 0.13527511060237885, -0.028613343834877014, -0.036654189229011536, -0.06740084290504456, -0.03478449583053589,
    0.06706976890563965, 0.024325180798768997, -0.08238819241523743, 0.03804152086377144, 0.030876178294420242, -0.06257890909910202, -0.08322366327047348, -0.08862581104040146,
    0.056734126061201096, 0.0510653480887413, -0.08266188949346542, 0.06948333978652954, -0.0458141528069973, -0.052391212433576584, 0.04028717428445816, -0.05922877416014671,
    0.15857675671577454, 0.04687521979212761, 0.002104420680552721, -0.04276907071471214, -0.03378550708293915, -0.0639437809586525, 0.056950893253088, -0.03031369112432003,
    0.036856766790151596, 0.026647450402379036, -0.03908649832010269, -0.04562448337674141, -0.04017280042171478, -0.08788889646530151, 0.03584665805101395, 0.020637689158320427,
    -0.04107331484556198, 0.027734698727726936, -0.06937985122203827, 0.25757500529289246, 0.19480791687965393, -0.06768616288900375, 0.00431415718048811, 0.1335531771183014,
    0.007609032094478607, 0.11177056282758713, -0.11895826458930969, 0.035016126930713654, 0.08045075833797455, -0.17529110610485077, 0.048824332654476166, 0.027380282059311867,
    -0.051059309393167496, -0.012368091382086277, 0.06408743560314178, 0.026755694299936295, -0.03176739811897278, -0.0036108933854848146, -0.0038229916244745255, 0.01538015902042389,
    0.0775500237941742, 0.1000630185008049, 0.01199415698647499, 0.0371912345290184, 0.04455873370170593, -0.035327911376953125, -0.07715185731649399, 0.033516108989715576,
    0.024071888998150826, 0.023528648540377617, -0.010224485769867897, -0.14459504187107086, -0.09481074661016464, 0.054022569209337234, 0.12028440088033676, 0.010315679013729095,
    0.004645534325391054, 0.03201744705438614, -0.020566770806908607, 0.087246835231781, 0.07048841565847397, 0.1357564926147461, 0.07780003547668457, 0.04568914324045181,
    0.01969664730131626, 0.11281700432300568, 0.04379143565893173, -0.16495734453201294, 0.08417469263076782, -0.11708343029022217, 0.09561818093061447, 0.018431909382343292,
    -0.070228211581707, -0.18890561163425446, -0.030758976936340332, 0.05575813353061676, 0.031721487641334534, -0.0044863261282444, 0.06478248536586761, 0.02311290241777897,
    -0.06068441644310951, 0.02600473165512085, -0.006112714763730764, 0.051217056810855865, 0.09249517321586609, -0.05076412856578827, 0.09087729454040527, -0.04634721204638481,
    0.06321539729833603, 0.030578505247831345, -0.0308893583714962, 0.13221295177936554, 0.018679320812225342, -0.009205149486660957, -0.06712335348129272, 0.12398657947778702,
    -0.08218631893396378, 0.004995380993932486, 0.022992011159658432, 0.038752228021621704, -0.04908191040158272, -0.08426783978939056, 0.008107427507638931, 0.005840055178850889,
    -0.028361866250634193, 0.006814886815845966, 0.08305742591619492, 0.09710156917572021, -0.011328347958624363, -0.11935468763113022, 0.07285548746585846, 0.03871982917189598,
    -0.005414473824203014, -0.03346453234553337, 0.007313670124858618, 0.0335395410656929, -0.06769027560949326, 0.02149396389722824, 0.07029539346694946, 0.04884529858827591,
    0.04501909390091896, -0.033243577927351, 0.034758515655994415, -0.015191849321126938, 0.13626354932785034, 0.12192287296056747, -0.035520605742931366, -0.02361840382218361,
    0.04709414392709732, -0.051294341683387756, 0.04330776259303093, -0.0513220876455307, 0.016165150329470634, 0.02965092845261097, 0.021172814071178436, -0.024746080860495567,
    -0.003231682348996401, -0.06356719136238098, -0.0008109479676932096, 0.04568960890173912, 0.034831661731004715, -0.008610479533672333, 0.07825218141078949, 0.0022009771782904863,
    0.00015996462025213987, -0.051651548594236374, 0.0783209279179573, 0.20466439425945282, 0.07091917097568512, -0.022930655628442764, -0.0214616060256958, -0.20184889435768127,
    -0.03697538748383522, -0.05434431508183479, -0.048288777470588684, -0.07541680335998535, -0.023430723696947098, -0.012846237979829311, 0.038326241075992584, 0.050268471240997314,
    -0.05983500927686691, -0.04634181037545204, 0.03974730148911476, 0.15587174892425537, 0.016734028235077858, 0.04681044816970825, 0.032568201422691345, -0.012556802481412888,
    0.14756321907043457, 0.0294504314661026, -0.024465234950184822, 0.026814263314008713, 0.03454964980483055, -0.0532742477953434, 0.04001709446310997, -0.0017253300175070763,
    0.0031482980120927095, -0.04655895382165909, 0.012417846359312534, 0.05751925706863403, -0.057628631591796875, -0.1062641516327858, 0.05329080671072006, -0.06823314726352692,
    0.03424987941980362, 0.003557471791282296, 0.0022772017400711775, 0.016174567863345146, -0.004584771115332842, 0.06210140138864517, 0.03472231328487396, -0.007611061912029982,
    -0.025055082514882088, 0.08573676645755768, -0.08472266793251038, -0.07802858203649521, 0.010393536649644375, -0.002477569505572319, -0.09517314285039902, 0.05531619116663933,
    -0.03920554369688034, -0.08330879360437393, -0.028289111331105232, -0.013307287357747555, -0.028166169300675392, -0.004149763844907284, 0.02172677405178547, -0.005751667078584433,
    0.04147293418645859, 0.03910520672798157, -0.017979800701141357, 0.030083246529102325, 0.16908089816570282, 0.05450785532593727, 0.03471303731203079, 0.05589411035180092,
    -9.36980068217963e-05, 0.057486534118652344, -0.08445092290639877, 0.03695793077349663, -0.09175567328929901, -0.0011261102044954896, -0.00454114843159914, -0.10279236733913422,
    -0.004640483763068914, -0.022112363949418068, -0.030675645917654037, -0.10027371346950531, -0.052227407693862915, -0.10130822658538818, 0.019732575863599777, -0.03835626319050789,
    -0.03356405720114708, 0.0008950875489972532, 0.11845897883176804, 0.11962893605232239, -0.06863078474998474, -0.1791447103023529, 0.05296257138252258, 0.0320618562400341,
    -0.0320311076939106, 0.0331074483692646, -0.012570916675031185, 0.009509015828371048, -0.021125691011548042, -0.048298608511686325, 0.12279755622148514, 0.027432864531874657,
    -0.011506139300763607, 0.001631193794310093, -0.052922166883945465, 0.008615551516413689, 0.044511858373880386, 0.16054996848106384, 0.010845289565622807, 0.003567199921235442,
    -0.034303683787584305, 0.040867019444704056, 0.04389870911836624, 0.05343140289187431, 0.01124198455363512, -0.06637336313724518, -0.005198713857680559, 0.024085791781544685,
    0.006680916529148817, -0.00022722336871083826, 0.01584606245160103, 0.046590499579906464, 0.07066305726766586, 0.010523535311222076, 0.015607480891048908, 0.007884022779762745,
    0.08096839487552643, 0.008039451204240322, 0.09389948099851608, 0.16643376648426056, 0.06596904247999191, -0.05112859979271889, 0.04772600904107094, 0.016416216269135475,
    -0.05095376819372177, -0.018048949539661407, -0.11062105745077133, 0.004549064673483372, -0.05054451897740364, -0.04360683634877205, 0.03987940400838852, 0.05370332673192024,
    -0.048791468143463135, -0.052084099501371384, -0.04545767605304718, -0.0021145630162209272, -0.003996679559350014, -0.06502088904380798, 0.033708665519952774, 0.07703887671232224,
    0.07025599479675293, 0.15078476071357727, -0.050112225115299225, -0.003351778257638216, 0.026970062404870987, -0.011685828678309917, 0.016181260347366333, -0.09303068369626999,
    -0.0011239944724366069, -0.013134238310158253, 0.039008256047964096, 0.08307205885648727, 0.028685929253697395, -0.06371338665485382, -0.08437862247228622, 0.0713161900639534,
    0.040913671255111694, -0.04223858565092087, -0.0037966552190482616, 0.008358437567949295, -0.02749585546553135, 0.08966246247291565, -0.05361783877015114, 0.0037619767244905233,
    0.057227279990911484, -0.03356188163161278, 0.028346361592411995, 0.020432062447071075, -0.010244175791740417, 0.0702546238899231, -0.017212972044944763, -0.011304440908133984,
    -0.04177252575755119, 0.0674339160323143, -0.05847278982400894, -0.04119357466697693, 0.029594939202070236, 0.028117546811699867, -0.005813957192003727, 0.008721470832824707,
    0.12663546204566956, 0.13972435891628265, 0.02036316692829132, -0.04003846272826195, -0.002395234303548932, -0.008368072099983692, 0.11476656794548035, 0.08728039264678955,
    -0.043310392647981644, -0.02413002774119377, -0.007730321958661079, 0.09517624229192734, -0.07051844894886017, -0.05458659678697586, 0.0249819103628397, -0.01902918890118599,
    0.05253775045275688, -0.012391967698931694, 0.0493449792265892, -0.03915918990969658, 0.022438468411564827, -0.0017124363221228123, 0.055188361555337906, -0.012934583239257336,
    -0.01402635220438242, -0.006132673937827349, -0.0032561977859586477, 0.08524081856012344, -0.049929264932870865, -0.05858644098043442, 0.03750276565551758, -0.07417017966508865,
    -0.024890387430787086, 0.002048831433057785, 0.09101472795009613, 0.04102573171257973, -0.05406597629189491, -0.06012620031833649, 0.0702693909406662, 0.08377090841531754,
    0.043167825788259506, 0.012240627780556679, -0.08744446933269501, 0.006226640194654465, -0.01988331787288189, 0.007714488543570042, -0.017556585371494293, 0.000670771871227771,
    -0.0077632213942706585, 0.032513298094272614, -0.029724013060331345, 0.010682363994419575, -0.023646634072065353, -0.0602579191327095, 0.020870737731456757, -0.0011470760218799114,
    0.04858526214957237, 0.02856014110147953, -0.009015890769660473, 0.05957404524087906, 0.08593349158763885, -0.006209478713572025, -0.0039040620904415846, -0.004346973728388548,
    0.010369542986154556, 0.014641333371400833, 0.0318722203373909, 0.12812449038028717, 0.10969535261392593, -0.09142129123210907, -0.03752633184194565, 0.08671293407678604,
    0.025009652599692345, -0.05199071764945984, -0.0877116248011589, -0.012867940589785576, 0.033116258680820465, 0.024611415341496468, 0.038314808160066605, 0.038857292383909225,
    -0.015163363888859749, -0.006837470456957817, -0.017161371186375618, -0.14736098051071167, -0.018065867945551872, 0.042744867503643036, 0.038744766265153885, -0.00890131015330553,
    -0.12120453268289566, 0.045407652854919434, 0.04709973931312561, 0.02782757580280304, 0.02667352370917797, -0.010879028588533401, -0.016057219356298447, 0.02752656489610672,
    0.001043301192112267, 0.01621401309967041, -0.040029607713222504, 0.02744949609041214, 0.07981978356838226, 0.0797208845615387, -0.04631054401397705, -0.032548028975725174,
    -0.06833591312170029, 0.03949464112520218, -0.01959392800927162, -0.04334289953112602, 0.04297923296689987, 0.08013741672039032, 0.002048155292868614, -0.009786867536604404,
    0.025398103520274162, -0.020060570910573006, 0.0029811731074005365, -0.1283741444349289, 0.10391347110271454, 0.0531751923263073, 0.0023948377929627895, -0.01501257624477148,
    -0.030210087075829506, 0.07253880053758621, 0.008483565412461758, 0.03185699135065079, -0.0033792650792747736, -0.015517866238951683, 0.07229238003492355, 0.02165699563920498,
    -0.06563753634691238, 0.1597345769405365, -0.032906755805015564, -0.03483305126428604, 0.03730447217822075, -0.023518744856119156, 0.1096329540014267, 0.02419963851571083,
    0.03198811039328575, -0.013757716864347458, -0.057389602065086365, 0.10290966182947159, 0.009096345864236355, -0.06533517688512802, -0.039156682789325714, 0.041801489889621735,
    -0.007414829917252064, 0.020857591181993484, 0.03737393021583557, -0.014006040059030056, 0.0040855263359844685, -0.012967657297849655, -0.023072777315974236, -0.033036623150110245,
    -0.04973606392741203, 0.033338144421577454, 0.015456847846508026, 0.07076363265514374, -0.010842923074960709, 0.03491717576980591, -0.015887726098299026, 0.009064207784831524,
    0.02386375702917576, 0.006770328152924776, -0.038542479276657104, -0.013048801571130753, -0.03243179991841316, 0.00814775563776493, -0.057689569890499115, -0.022577568888664246,
    -0.009596200659871101, -0.01896670274436474, 0.011488103307783604, -0.0651763454079628, 0.03204767405986786, 0.029449963942170143, -0.04990900307893753, 0.018234794959425926,
    -0.04609917849302292, -0.04995063319802284, 0.07194188237190247, -0.014463956467807293, 0.026839787140488625, -0.05454716086387634, -0.05640136078000069, -0.09373020380735397,
    0.011405578814446926, -0.017694558948278427, 0.015432033687829971, 0.09571875631809235, 0.04015777260065079, 0.04544934630393982, 0.08738896995782852, -0.004057495854794979,
    -0.04000704362988472, -0.03323064371943474, 0.05475211516022682, 0.16379991173744202, 0.05590638145804405, -0.02506265975534916, 0.023152871057391167, -0.08438077569007874,
    0.01634039916098118, -0.08587747812271118, -0.010801334865391254, -0.0299269650131464, -0.007916071452200413, 0.07681490480899811, 0.11125358939170837, -0.04028911888599396,
    -0.023718655109405518, -0.007826627232134342, 0.03142932429909706, -0.07229594141244888, -0.0014244059566408396, 0.007312627974897623, 0.09444107860326767, -0.10051265358924866,
    -0.1161104142665863, -0.06098867580294609, 0.05785786360502243, 0.030640877783298492, -0.0010873894207179546, -0.02288043312728405, 0.021257461979985237, -0.002837254898622632,
    -0.02526869624853134, -0.011953027918934822, 0.07841583341360092, -0.02098706364631653, 0.00439879298210144, 0.10749581456184387, -0.0012646630639210343, -0.020487375557422638,
    -0.06587420403957367, -0.04581641033291817, -0.006664716172963381, -0.03185868263244629, 7.818117592250928e-05, 0.06797460466623306, 0.07007218152284622, -0.04506654292345047,
    -0.025314144790172577, -0.0189905297011137, 0.05536419898271561, -0.05821853503584862, 0.03765644505620003, 0.029354743659496307, 0.03928391635417938, -0.011381195858120918,
    -0.016751006245613098, 0.0332164466381073, 0.01438981294631958, 0.08356789499521255, 0.01803954876959324, -0.011631025932729244, 0.12497220933437347, 0.0055496301501989365,
    0.02432049810886383, 0.048149023205041885, 0.02212376892566681, 0.022681498900055885, 0.11972079426050186, 0.04630225524306297, 0.035623058676719666, 0.04180425405502319,
    0.003572282614186406, -0.006564068142324686, -0.0176059752702713, 0.13907490670681, 0.0229352880269289, 0.04711144044995308, 0.0938538983464241, -0.016811901703476906,
    -0.09716589748859406, -0.020725909620523453, -0.05601909011602402, -0.01734510250389576, 0.046207111328840256, -0.05453978478908539, 0.0007292095106095076, -0.06672108173370361,
    0.049441542476415634, -0.014496894553303719, 0.05725545436143875, 0.06014600768685341, -0.012389224022626877, 0.04521993547677994, -0.0004931177827529609, -0.03943416103720665,
    0.01771561987698078, -0.00868321768939495, -0.06211012601852417, -0.014670923352241516, -0.01799114979803562, 0.09864243119955063, -0.04782326519489288, 0.02253342792391777,
    0.015093663707375526, 0.005195222329348326, 0.04847237467765808, -0.05667253956198692, 0.01545143872499466, 5.0102307795896195e-06, 0.026177097111940384, -0.043091218918561935,
    -0.014964430592954159, -0.0571388341486454, 0.02383052371442318, -0.008403302170336246, -0.010120878927409649, -0.10358938574790955, -0.02880726382136345, -0.017274459823966026,
    -0.03753498196601868, -0.03274824097752571, 0.019978884607553482, -0.010634337551891804, -0.021776506677269936, -0.07619276642799377, 0.10551903396844864, -0.010848094709217548,
    0.04142778366804123, -0.03880684822797775, 0.020967800170183182, 0.08547897636890411, 0.07553565502166748, -0.06631465256214142, -0.024526868015527725, -0.016739534214138985,
    -0.006402777042239904, -0.1303129941225052, -0.04666510224342346, 0.021838072687387466, -0.04607604816555977, 0.08760276436805725, 0.02460155263543129, -0.09767509996891022,
    -0.01404551975429058, -0.003261700738221407, -0.03212130442261696, -0.01515953615307808, 0.010130871087312698, -0.009284907020628452, 0.08182349056005478, 0.047389913350343704,
    -0.057108212262392044, -0.024070413783192635, -0.029362348839640617, 0.03846585750579834, 0.00844962615519762, 0.02507537044584751, 0.002903092885389924, 0.018902014940977097,
    0.02604636363685131, 0.011511086486279964, 0.03736252337694168, 0.007912687957286835, -0.04597489908337593, -0.007916063070297241, 0.019457707181572914, 0.0200322438031435,
    -0.02158074826002121, 0.01010978315025568, -0.0003930919920094311, -0.13256746530532837, -0.04376635700464249, -0.04334731772542, 0.0016486825188621879, 0.05227986350655556,
    0.03283900395035744, -0.06425382196903229, 0.1564241498708725, -0.06548845767974854, -0.10519757121801376, -0.05748232826590538, 0.09193165600299835, 0.027194643393158913,
    -0.04005036875605583, -0.026312973350286484, -0.07665463536977768, -0.015314796008169651, -0.0008881496614776552, -0.01862788014113903, 0.024093272164463997, -0.025056825950741768,
    0.08047283440828323, 0.09229303151369095, -0.06520627439022064, 0.007125662639737129, -0.047919053584337234, -0.017905591055750847, 0.11411252617835999, -0.031223956495523453,
    0.01585080660879612, 0.030812056735157967, -0.055162519216537476, 0.08787406235933304, 0.08881372213363647, -0.10387188196182251, 0.10715530812740326, -0.0038363239727914333,
    0.05632023885846138, 0.00803385954350233, 0.041741110384464264, -0.09675277024507523, 0.05275295674800873, -0.02202000841498375, 0.08202574402093887, -0.07279057800769806,
    -0.013802386820316315, -0.019399143755435944, 0.018698018044233322, 0.08396989107131958, -0.06639440357685089, -0.12303273379802704, 0.017536310479044914, 0.031295713037252426,
    -0.02339193969964981, -0.013848107308149338, 0.008116825483739376, 0.05333150923252106, 0.012041076086461544, -0.032362498342990875, -0.0774310976266861, -0.027406537905335426,
    0.041698407381772995, 0.011290534399449825, -0.05097280070185661, -0.04743625223636627, 0.022914590314030647, -0.03798004984855652, -0.04060075804591179, -0.0005843667313456535,
    0.051537029445171356, 0.04906947538256645, 0.012062128633260727, 0.03935111314058304, -0.018734170123934746, 0.07117396593093872, -0.028141839429736137, 0.0205564945936203,
    0.02994639426469803, -0.045495953410863876, 0.07150419801473618, -0.0577293336391449, 0.003432492958381772, 0.003944423981010914, 0.0352945439517498, -0.00639420235529542,
    0.00448669632896781, -0.030855024233460426, -0.05287216231226921, 0.009057855233550072, 0.08235461264848709, 0.0001685801980784163, -0.02590087614953518, -0.003439537715166807,
    0.021741358563303947, -0.13349071145057678, -0.01965145207941532, -0.05195892974734306, 0.046442776918411255, 0.03723517060279846, 0.05386805161833763, -0.05265537276864052,
    -0.032809801399707794, 0.01032394077628851, -0.15322822332382202, -0.04858284443616867, 0.046580832451581955, 0.008677750825881958, 0.07903198897838593, 0.02147791162133217,
    -0.02004118636250496, 0.02781551703810692, 0.07170266658067703, -0.033831387758255005, 0.005967515986412764, -0.05192612111568451, -0.05962207540869713, -0.002159367548301816,
    -0.009280309081077576, 0.007724005728960037, 0.026913056150078773, 0.1651584506034851, -0.06886416673660278, 0.04860389605164528, 0.07166710495948792, -0.02360178902745247,
    -0.0371277742087841, -0.01850436069071293, -0.002731681801378727, -0.044471681118011475, 0.05559143051505089, 0.05819591134786606, -0.041356295347213745, 0.00021811560145579278,
    -0.026299284771084785, -0.012674383819103241, -0.030171310529112816, 0.010834207758307457, 0.015951789915561676, 0.03682473301887512, 0.07208707183599472, 0.04984654486179352,
    -0.055971693247556686, 0.04408629611134529, 0.02603365294635296, -0.05334405228495598, -0.012651815079152584, -0.004733601119369268, 0.028406400233507156, 0.0027221490163356066,
    0.04012933745980263, -0.034944139420986176, -0.0023976019583642483, 0.011977490037679672, -0.01349892932921648, 0.00347820739261806, 0.1978132575750351, -0.07838071137666702,
    0.023899046704173088, -0.040279753506183624, -0.011633229441940784, -0.049708299338817596, -0.004117526579648256, -0.03942526504397392, 0.031657326966524124, -0.005250437185168266,
    -0.026566294953227043, -0.01371171697974205, 0.014437832869589329, 0.012911573983728886, 0.131575807929039, -0.09199851006269455, -0.0009726020507514477, -0.02138645388185978,
    0.021942101418972015, -0.020320536568760872, 0.026422293856739998, 0.07836475968360901, 0.02681298926472664, -0.004898198414593935, 0.008488897234201431, 0.03166600316762924,
    -0.05659026652574539, -0.013917163014411926, -0.005228858441114426, -0.03236586973071098, 0.07339474558830261, -0.06868822127580643, -0.03805690258741379, 0.05789527669548988,
    -0.029129449278116226, 0.01414153166115284, -0.0036208052188158035, 0.005235576536506414, -0.004183836281299591, -0.048174936324357986, -0.019698848947882652, -0.018344542011618614,
    0.04607730358839035, 0.04101148247718811, 0.023374266922473907, -0.01935618557035923, 0.024371730163693428, 0.023122012615203857, 0.036346178501844406, 0.07110816240310669,
    0.01854543387889862, 0.006254448089748621, 0.010198787786066532, -0.0051187146455049515, -0.007649394683539867, 0.009626799263060093, 0.05047723650932312, -0.030610891059041023,
    0.00893480610102415, 0.013939681462943554, -0.006305541843175888, -0.06025563180446625, 0.024116478860378265, -0.04475885629653931, 0.03960051015019417, -0.08142255991697311,
    0.024926600977778435, -0.1231263056397438, -0.0001433592551620677, -0.012180193327367306, -0.0113270478323102, 0.04453699290752411, -0.04054031893610954, 0.03115888126194477,
    0.021212659776210785, -0.0067781745456159115, -0.06843921542167664, -0.053170815110206604, -0.010915474034845829, -0.011566126719117165, 0.0012298094807192683, -0.045299384742975235,
    -0.003631556872278452, 0.05825233459472656, 0.07343247532844543, 0.019949747249484062, 0.02537982352077961, -0.010765728540718555, 0.07397611439228058, 0.004615004640072584,
    -0.010521764867007732, 0.019677747040987015, 0.05064165219664574, 0.021755093708634377, -0.021302610635757446, 0.002840376691892743, -0.05024894326925278, -0.05716660991311073,
    0.0018128060037270188, -0.042966220527887344, 0.009441711939871311, -0.09110012650489807, 0.05805386230349541, 0.10825321078300476, 0.05528971552848816, 0.016908470541238785,
    -0.00861257966607809, 0.04186280816793442, 0.04906300827860832, 0.061141956597566605, 0.07323039323091507, 0.07915545254945755, 0.018975896760821342, 0.07150690257549286,
    -0.021870775148272514, -0.0118954386562109, -0.0014033338520675898, -0.09463296830654144, -0.038519710302352905, 0.007134158164262772, -0.009594514966011047, -0.010976120829582214,
    0.04534154012799263, 0.043189238756895065, 0.02178826369345188, 0.03698575869202614, 0.0011914479546248913, 0.048127252608537674, 0.12304801493883133, -0.009082856588065624,
    0.06341917812824249, -0.02856774628162384, 0.05065739527344704, 0.025323236361145973, -0.012300476431846619, 0.010098407045006752, 0.014497300609946251, 0.0007590800523757935,
    -0.02657606080174446, -0.004572490230202675, -0.06211846321821213, -0.10076673328876495, 0.03126143664121628, -0.11832188814878464, -0.011824263259768486, -0.07055193930864334,
    -0.06884358078241348, 0.0272626131772995, -0.024321191012859344, 0.06434068828821182, -0.05578804016113281, 0.020972197875380516, -0.004087523091584444, 0.08757083863019943,
    0.0013990080915391445, 0.025613080710172653, -0.05799225717782974, 0.014860169030725956, 0.08210420608520508, 0.058880262076854706, -0.024554548785090446, -0.004069983959197998,
    -0.04638443514704704, 0.03324797749519348, 0.05175049602985382, 0.028793103992938995, -0.03184584900736809, 0.004824611358344555, -0.020178699865937233, 0.022523321211338043,
    -0.026577536016702652, -0.06061158701777458, 0.015759186819195747, 0.003641164628788829, -0.03859259560704231, 0.02083776518702507, 0.004924015142023563, 0.032591868191957474,
    0.031022461131215096, -0.06040388345718384, 0.01785258948802948, -0.03557055443525314, -0.040309660136699677, -0.022458603605628014, 0.09757174551486969, 0.007388770114630461,
    -0.04905255511403084, -0.014460473321378231, 0.004959010053426027, -0.07719630002975464, 0.07311013340950012, -0.041567008942365646, -0.03037400357425213, 0.02907000109553337,
    -0.00995471328496933, -0.16642950475215912, 0.015527084469795227, 0.031715087592601776, -0.00410103052854538, 0.04518898203969002, -0.02360023744404316, 0.014328943565487862,
    0.00622392725199461, -0.0880240872502327, -0.08343697339296341, -0.025632057338953018, -0.0024888510815799236, 0.00219744723290205, -0.059830550104379654, -0.041351787745952606,
    -0.008802506141364574, -0.017950421199202538, 0.03066398948431015, -0.016972368583083153, -0.015003367327153683, 0.055856842547655106, -0.02277492918074131, -0.06356073170900345,
    -0.01659557782113552, -0.0015398889081552625, 0.09288211166858673, -0.03334128111600876, -0.12451470643281937, 0.0760800912976265, -0.053965721279382706, -0.03717352822422981,
    -0.003094135317951441, 0.0402647890150547, -0.0009901018347591162, -0.013765128329396248, -0.041650671511888504, 0.0179409421980381, 0.005152927711606026, 0.024690566584467888,
    0.010737392120063305, 0.09079623222351074, 0.06540608406066895, 0.05249578133225441, 0.016247045248746872, 0.052127595990896225, 0.03620925545692444, -0.05330796539783478,
    0.00908148754388094, -0.006260936614125967, 0.03138246014714241, -0.04437656328082085, 0.04809344932436943, -0.05657089501619339, -0.055734191089868546, -0.03151535987854004,
    0.04516184702515602, 0.15286746621131897, -0.03655575215816498, -0.04541715607047081, 0.012054787948727608, -0.030033376067876816, 0.06955509632825851, -0.025387803092598915,
    -0.010702555999159813, -0.0013933000154793262, 0.03626447170972824, -0.0015522603644058108, -0.012731236405670643, -0.06656190752983093, 0.0451236329972744, 0.003587183775380254,
    -0.0021637817844748497, -0.010731587186455727, 0.05984507128596306, -0.1159389391541481, -0.053117621690034866, -0.032220371067523956, 0.024944037199020386, -0.024026252329349518,
    -0.03206200152635574, -0.010400587692856789, -0.0879080668091774, 0.1093018651008606, -0.0008099447004497051, -0.09973572939634323, 0.015345965512096882, 0.02562902867794037,
    -0.007183915935456753, 0.018737364560365677, 0.000969786720816046, 0.023432841524481773, 0.048068974167108536, 0.011058549396693707, -0.08664128184318542, -0.023213865235447884,
    -0.04593827947974205, -0.0040948279201984406, 0.012154754251241684, 0.027523523196578026, -0.08334099501371384, -0.06163628026843071, -0.013530793599784374, 0.05409230664372444,
    0.050668030977249146, -0.062375638633966446, 0.005150916986167431, 0.004434197209775448, 0.022715071216225624, -0.0700969249010086, 0.005769416689872742, -0.05380155146121979,
    0.015958158299326897, -0.052944064140319824, 0.04358256980776787, -0.006578817963600159, -0.021364225074648857, 0.09417439252138138, 0.010942419059574604, -0.0060320207849144936,
    0.013058826327323914, 0.04963253065943718, -0.051428113132715225, -0.15724772214889526, -0.014579005539417267, -0.09835882484912872, 0.010733227245509624, 0.012926045805215836,
    0.0014296595472842455, -0.1371806412935257, -0.0026332575362175703, 0.012399605475366116, -0.02613946981728077, -0.07382246851921082, -0.00369406514801085, 0.006325329653918743,
    -0.036055587232112885, 0.02300342172384262, -0.019940564408898354, -0.03726205602288246, -0.014111816883087158, 0.008906194940209389, -0.016199667006731033, 0.005833650939166546,
    -0.032312970608472824, -0.024024760350584984, 0.11148462444543839, 0.0037718627136200666, 0.01845279335975647, -0.05508662387728691, 0.05379592627286911, -0.04185802862048149,
    0.023141905665397644, -0.024439921602606773, 0.03359042480587959, 0.05221626162528992, -0.09857557713985443, -0.001323734875768423, -0.09648682922124863, 0.045858848839998245,
    -0.14600993692874908, -0.0028272310737520456, 0.02737743966281414, -0.0052566868253052235, -0.009557261131703854, 0.03909023851156235, 0.032888494431972504, -0.026966603472828865,
    0.001968052703887224, 0.0710533857345581, 0.05395789071917534, 0.0018323772819712758, 0.04618965461850166, -0.0031409182120114565, 0.06973272562026978, -0.0495116300880909,
    -0.0007196703227236867, -0.0063911681063473225, 0.06167326495051384, -0.019614866003394127, 0.046511515974998474, 0.015003212727606297, 0.02088611014187336, -0.016436127945780754,
    -0.00532687921077013, 0.035350192338228226, -0.014862836338579655, -0.013035142794251442, 0.019373903051018715, 0.0035698949359357357, 0.022632954642176628, -0.01407470554113388,
    0.04895121604204178, -0.04124663770198822, 0.04534578323364258, 0.044707585126161575, 0.08651001006364822, -0.0412086620926857, -0.009117593057453632, -0.0166704673320055,
    0.05372622609138489, 0.010623034089803696, -0.026297833770513535, -0.14135439693927765, -0.14769577980041504, -0.03196660801768303, 0.0048906514421105385, 0.0491204671561718,
    0.013654490001499653, 0.024820365011692047, -0.04267849400639534, 0.09170620143413544, 0.10565340518951416, 0.01889091730117798, -0.06023894250392914, -0.016540396958589554,
    0.0046973214484751225, 0.01374881248921156, -0.06187710165977478, 0.0016390690580010414, 8.703627099748701e-05, -0.02294306829571724, -0.06077975779771805, 0.06863860785961151,
    -0.040042415261268616, 0.0014516132650896907, 0.018431667238473892, -0.010386791080236435, 0.029424624517560005, -0.014236814342439175, -0.11394555866718292, -0.051209017634391785,
    0.0037306523881852627, -0.023322639986872673, -0.0035674176178872585, 0.0390808992087841, -0.04097395017743111, -0.003309020074084401, 0.01570558361709118, -0.01600594073534012,
    0.004933939315378666, -0.03396150842308998, -0.008179583586752415, 0.0041875834576785564, 0.04453219100832939, -0.051571961492300034, 0.06436754763126373, 0.03284058719873428,
    -0.03453271463513374, 0.013614927418529987, -0.051414549350738525, -0.14372465014457703, 0.036721423268318176, -0.02370517887175083, -0.023022014647722244, -0.08831062912940979,
    -0.027605298906564713, -0.23802408576011658, 0.03292510285973549, -0.009393124841153622, 0.006838301662355661, -0.02963303029537201, -0.0019357100827619433, 0.02689121663570404,
    -0.004076757933944464, -0.05950022488832474, -0.014349428936839104, -0.021584492176771164, 0.011314020492136478, -0.0027614939026534557, -0.03375128284096718, -0.0076514193788170815,
    -0.006472540553659201, -0.07382288575172424, 0.04503711313009262, -0.00437144236639142, 0.012628991156816483, 0.051765456795692444, -0.0002662101178430021, 0.04528144747018814,
    -0.031037868931889534, -0.0031912417616695166, 0.02732471562922001, 0.06948663294315338, -0.04340915009379387, -0.019375011324882507, 0.020587123930454254, -0.010587777942419052,
    -0.08295860141515732, -0.03726278245449066, -0.04524000361561775, 0.021278750151395798, 0.0446283333003521, 0.02431773766875267, -0.011382310651242733, 0.028049439191818237,
    0.04080736264586449, 0.06420807540416718, 0.020252175629138947, 0.049560051411390305, 0.03508956357836723, 0.0027425026055425406, 0.03519100323319435, -0.02519557997584343,
    -0.014793098904192448, 0.019793005660176277, 0.16841988265514374, 0.032477155327796936, -0.02084510214626789, -0.018177004531025887, 0.00828920304775238, -0.0365733839571476,
    0.08095193654298782, 0.03850928694009781, 0.0022128536365926266, 0.0265663955360651, 0.03365747258067131, -0.023659560829401016, 0.05965285748243332, 0.05229130759835243,
    0.02592582069337368, -0.04792346432805061, 0.0029893573373556137, -0.09842251986265182, 0.07223197817802429, -0.023078829050064087, -0.007699236739426851, 0.037543706595897675,
    -0.0842038244009018, -0.03385397046804428, 0.03395280987024307, -0.029511161148548126, -0.06454865634441376, -0.013019058853387833, 0.07400557398796082, 0.08233317732810974,
    0.07796189188957214, -0.00844421423971653, -0.05618569254875183, 0.06410985440015793, 0.08523641526699066, 0.01600024662911892, 0.017705924808979034, -0.02921759895980358,
    0.003617697861045599, -0.036167941987514496, -0.11492770910263062, -0.04129794239997864, -0.05972377583384514, 0.006216051056981087, -0.13690993189811707, -0.01012733019888401,
    -0.07720068097114563, 0.012668648734688759, 0.045204099267721176, -0.0034063532948493958, 0.023225238546729088, 0.07166264951229095, 0.011713821440935135, 0.00045501382555812597,
    0.05793466791510582, 0.08703669905662537, -0.004130271263420582, 0.00456327386200428, 0.019837159663438797, -0.026519712060689926, -0.016271615400910378, 0.07257694005966187,
    -0.006078361999243498, -0.04311443120241165, 0.022849615663290024, 0.07160955667495728, 0.012102541513741016, 0.07431568950414658, 0.10382233560085297, 0.026703055948019028,
    -0.07100985199213028, 0.02514301985502243, -0.06037195026874542, -0.17661353945732117, 0.02631560154259205, -0.04470931366086006, 0.041923511773347855, 0.0548006072640419,
    -0.010528034530580044, -0.13249807059764862, -0.03175332024693489, 0.012208678759634495, -0.017860883846879005, 0.01190335862338543, 0.016772478818893433, -0.01712975464761257,
    0.006043369881808758, 0.0045618596486747265, 0.032842256128787994, -0.04967619851231575, -0.017218725755810738, 0.023477589711546898, -0.07627949118614197, 0.015248246490955353,
    0.0003129905089735985, -0.014424683526158333, 0.11628192663192749, 0.05749460309743881, 0.010883564129471779, -0.0014791053254157305, -0.0015038609271869063, -0.010100065730512142,
    0.015477354638278484, -0.016879886388778687, 0.012685291469097137, 0.04764067754149437, -0.05476630479097366, 0.025687094777822495, 0.06955074518918991, 0.02640238031744957,
    -0.029835792258381844, -0.011090831831097603, 0.05384880676865578, -0.03890140354633331, 0.034019023180007935, 0.00903746485710144, 0.014418485574424267, 0.06519631296396255,
    -0.031353022903203964, 0.059385403990745544, 0.04777677357196808, 0.09399597346782684, 0.02402961254119873, 0.05575926601886749, 0.0031023144256323576, 0.010867292061448097,
    -0.019653044641017914, -0.049936890602111816, 0.008848285302519798, -0.011760087683796883, 0.027770807966589928, -0.02643314190208912, -0.005872812587767839, -0.0009425057796761394,
    -0.012111322022974491, 0.029037712141871452, -0.018189674243330956, -0.013290406204760075, 0.014986531808972359, 0.011717498302459717, 0.04326169192790985, -0.025872087106108665,
    0.02992154471576214, -0.010916554369032383, 0.022361671552062035, -0.037538670003414154, 0.0036571284290403128, -0.05931679904460907, 0.0303247831761837, 0.023536402732133865,
    0.011225930415093899, 0.03511789068579674, -0.03445148468017578, -0.03316056355834007, -0.029002390801906586, 0.011127786710858345, 0.06307119131088257, 0.05332298204302788,
    -0.005113781895488501, -0.0019088530680164695, -0.06631437689065933, 0.0005992533988319337, 0.049405667930841446, -0.002794192638248205, -0.019937612116336823, 0.01670275442302227,
    -0.0268955510109663, 0.012711559422314167, -0.030975377187132835, 0.09143858402967453, -0.10283616185188293, -0.05228566378355026, -0.07816773653030396, 0.04954659938812256,
    -0.10121658444404602, -0.005568761378526688, 0.003364858217537403, 0.0329875610768795, 0.0707985907793045, 0.08337540179491043, -0.010377731174230576, 0.036422230303287506,
    0.05219704657793045, -0.03808724135160446, 0.0020851069130003452, 0.0071870991960167885, -0.027475154027342796, 0.06727495044469833, -0.1402955949306488, 0.035292405635118484,
    0.007000528741627932, -0.07454047352075577, -0.07157184928655624, 0.02397003397345543, 0.03501121699810028, -0.04459705576300621, 0.06857378035783768, 0.024494333192706108,
    0.05217910557985306, 0.020374296233057976, -0.01756080612540245, -0.2020353376865387, -0.07586470991373062, -0.044050395488739014, -0.044909894466400146, -0.028395764529705048,
    0.011483166366815567, -0.15510813891887665, 0.010466482490301132, -0.03674151748418808, 0.0049887108616530895, -0.0334927998483181, 0.06046467646956444, 0.01722346432507038,
    0.0093739815056324, -0.0032294110860675573, -0.09627453982830048, -0.08083295822143555, -0.013571718707680702, -0.013954955153167248, -0.00010655946971382946, -0.054889533668756485,
    0.033750295639038086, -0.02187681384384632, 0.10664385557174683, 0.033239804208278656, 0.0035932594910264015, 0.032313961535692215, -0.039685290306806564, -0.0031607209239155054,
    -0.04724317044019699, -0.02930370718240738, 0.05921316146850586, 0.03979799523949623, -0.12641552090644836, 0.017020966857671738, 0.038496993482112885, -0.03408649191260338,
    0.05451768636703491, -0.02328764647245407, -0.048545338213443756, 0.03834381327033043, 0.037694159895181656, 0.09945453703403473, 0.007288764696568251, -0.0002502494608052075,
    -0.03214741498231888, 0.09068475663661957, 0.03151541203260422, 0.11877340078353882, 0.038933638483285904, 0.030146388337016106, -0.017333757132291794, -0.04883331432938576,
    -0.025788158178329468, 0.006633657030761242, -0.021713968366384506, -0.048037443310022354, 0.014296316541731358, 0.009077162481844425, -0.0783967599272728, -0.01319930050522089,
    0.06223779544234276, 0.04350810497999191, 0.008261133916676044, 0.02148279920220375, 0.024870041757822037, 0.002201355993747711, 0.01648547500371933, 0.03980134427547455,
    -0.006252721417695284, -0.01679508201777935, 0.05198575183749199, -0.046203576028347015, -0.04801779240369797, 0.03744557127356529, 0.019711464643478394, -0.009943155571818352,
    0.037808023393154144, -0.013391819782555103, 0.020712383091449738, -0.03350769728422165, -0.0801238864660263, 0.016406293958425522, 0.05228062719106674, 0.048644039779901505,
    0.02819354087114334, 0.003644198179244995, -0.006297926418483257, 0.004217252600938082, 0.06408817321062088, -0.04861544072628021, -0.009639552794396877, 0.02573040872812271,
    -0.014471028931438923, -0.0056269061751663685, -0.05306553840637207, -0.052346307784318924, -0.05753276124596596, -0.057811565697193146, -0.049756258726119995, 0.03132982179522514,
    -0.09875009208917618, -0.004168734420090914, 0.05278623849153519, 0.03945572301745415, -0.060160454362630844, 0.03701956197619438, 0.09664300084114075, 0.029855497181415558,
    0.11789488047361374, -0.045540694147348404, 0.025221552699804306, 0.06719883531332016, -0.002903864486142993, -0.05631516873836517, -0.12408828735351562, 0.03356263041496277,
    -0.009265572763979435, -0.009054119698703289, 0.013407627120614052, -0.009118042886257172, 0.07069713622331619, -0.00012470572255551815, 0.06528881192207336, 0.01575096696615219,
    0.05444810539484024, 0.006937576923519373, -0.037888601422309875, -0.18434280157089233, -0.05935511738061905, -0.0657070130109787, 0.000808592070825398, 0.02107185497879982,
    0.013249817304313183, -0.10107070952653885, -0.033008962869644165, 0.008174349553883076, -0.02757246233522892, -0.04036002606153488, -0.015925372019410133, 0.04510588198900223,
    -0.020881572738289833, -0.025126565247774124, -0.015066507272422314, 0.0005271630943752825, -0.002942499704658985, -0.015986740589141846, -0.003168280702084303, 0.028509626165032387,
    -0.03129380941390991, -0.0428193174302578, 0.0687820091843605, -0.037635695189237595, 0.004701731726527214, 0.0344923734664917, -0.053546659648418427, -0.016804680228233337,
    0.02736528404057026, 0.0051572578959167, -0.07562620937824249, -0.006942612584680319, -0.01573408953845501, 0.022204862907528877, -0.015234485268592834, 0.014853514730930328,
    0.008218025788664818, 0.002994526643306017, 0.006649679038673639, -0.013504104688763618, 0.027282116934657097, 0.10061882436275482, -0.008835168555378914, 0.03679923340678215,
    0.02763528749346733, 0.10778743773698807, 0.012418541125953197, 0.0478522926568985, 0.07328879833221436, -0.08895441144704819, -0.001163174631074071, -0.031500425189733505,
    0.018628040328621864, 0.00921695027500391, 0.06158024072647095, -0.0021842247806489468, 0.0058168391697108746, -0.036925025284290314, 0.026044128462672234, -0.03534505516290665,
    0.12135394662618637, 0.03250826895236969, -0.014253759756684303, -0.027172941714525223, 0.008205410093069077, 0.023698998615145683, 0.01938709057867527, -0.030549172312021255,
    0.021331848576664925, -0.0172098558396101, 0.03187636658549309, -0.04975060001015663, 0.007936173118650913, -0.0657174289226532, -0.027497660368680954, 0.021693171933293343,
    -0.06837992370128632, 0.019684866070747375, -0.01836455799639225, -0.12576088309288025, -0.047596175223588943, -0.010767555795609951, 0.0276754479855299, 0.04845946282148361,
    0.017438318580389023, 0.010904272086918354, 0.018308913335204124, 0.03853389993309975, 0.10512477904558182, -0.05571208894252777, 0.016036368906497955, 0.04864270240068436,
    0.04241666942834854, 0.03565192222595215, -0.05856059491634369, 0.014448165893554688, 0.0219118669629097, -0.013000238686800003, -0.04018319398164749, 0.10336723178625107,
    -0.004623197019100189, -0.020919259637594223, -0.004291123244911432, 0.037398744374513626, 0.029687052592635155, -0.005954947788268328, 0.03894875943660736, -0.02603800594806671,
    -0.006563075352460146, -0.03322969749569893, 0.04383055120706558, 0.00872847530990839, -0.021566204726696014, -0.024561099708080292, -0.11853453516960144, 0.05257093533873558,
    0.04696125537157059, -0.016344334930181503, 0.033574625849723816, -0.005505828186869621, 0.013296973891556263, 0.027650808915495872, 0.021101947873830795, 0.034194089472293854,
    -0.007419902365654707, -0.013087747618556023, 0.00923664215952158, -0.13696809113025665, -0.06260555982589722, -0.031144581735134125, -0.008250045590102673, -0.007964475080370903,
    0.03217064589262009, -0.13817214965820312, -0.05600573495030403, -0.037726547569036484, -0.014556040056049824, 0.019344354048371315, 0.10730161517858505, -0.01425256859511137,
    -0.006015254650264978, -0.05609721690416336, -0.024781731888651848, -0.026145268231630325, 0.003837263211607933, 0.037098947912454605, -0.013874361291527748, -0.061832256615161896,
    -0.04172162339091301, -0.05987312272191048, 0.08143285661935806, 0.025868326425552368, -0.0278033297508955, 0.015547684393823147, -0.0533224381506443, 0.0267051812261343,
    -0.026401178911328316, -0.052301112562417984, -0.057558901607990265, 0.1163209080696106, -0.05363466590642929, 0.011102895252406597, -7.373075732175494e-06, 0.020007215440273285,
    0.02110964059829712, 0.021248696371912956, -0.01977108046412468, -0.012407196685671806, -0.03343870863318443, 0.004296187311410904, 0.02033430151641369, -0.023509640246629715,
    -0.01452100370079279, 0.16244976222515106, -0.04008699581027031, 0.04784974083304405, 0.052473314106464386, -0.08174239844083786, 0.02092728391289711, -0.009373861365020275,
    0.08914420753717422, 0.03230414539575577, 0.030516041442751884, -0.007609335705637932, 0.010801364667713642, 0.02180095948278904, 0.014583268202841282, -0.024942468851804733,
    0.09675119817256927, -0.010091706179082394, -0.018978742882609367, 0.007675617467612028, -0.03768409416079521, -0.048203982412815094, -0.010962539352476597, 0.019311979413032532,
    0.0404139906167984, 0.002381047001108527, 0.020992791280150414, -0.05680965259671211, -0.005848617758601904, 0.009380935691297054, 0.005059361457824707, 0.03155086934566498,
    -0.006288069766014814, -0.0010735514806583524, 0.022410346195101738, -0.06405359506607056, -0.03144289180636406, 0.039422374218702316, 0.08607124537229538, 0.07387295365333557,
    0.02422606572508812, 0.0022881499025970697, -0.026170015335083008, -0.03232843801379204, 0.09211989492177963, -0.04670243337750435, -0.01186571829020977, 0.03494749590754509,
    -0.0008751376299187541, -0.004198651295155287, -0.025695975869894028, -0.00987981352955103, 0.1029246523976326, -0.009427044540643692, -0.048670753836631775, 0.12444276362657547,
    0.03696539252996445, 0.016024814918637276, -0.002152729546651244, 0.07178561389446259, -0.06791651248931885, 0.023172402754426003, 0.07417716085910797, 0.023197658360004425,
    0.0021375734359025955, -0.06334711611270905, -0.022850720211863518, -0.028424961492419243, 0.03132633864879608, -0.057185232639312744, -0.138118177652359, 0.057805608958005905,
    -0.0017072296468541026, 0.017536306753754616, 0.03364141657948494, -0.015474268235266209, -0.01605718955397606, -0.037109848111867905, 0.09823290258646011, -0.017642421647906303,
    0.015966830775141716, -0.02742541953921318, -0.003654212225228548, -0.13671903312206268, -0.1298748105764389, -0.11297231912612915, -0.02593948133289814, 0.07236585766077042,
    0.0021820683032274246, -0.10272253304719925, -0.06226713955402374, -0.03158118948340416, 0.022740723565220833, 0.04743340611457825, 0.08051501959562302, 0.09847274422645569,
    -0.03838499262928963, 0.008549782447516918, -0.022435098886489868, -0.09276788681745529, -0.04366280883550644, -0.04469539225101471, 0.002131564309820533, -0.003488880582153797,
    -0.0798392966389656, -0.0675792247056961, 0.09298023581504822, 0.020171573385596275, -0.025592179968953133, -0.05120887607336044, -0.003835936076939106, 0.01605168730020523,
    0.0461624339222908, 0.06468953937292099, -0.0011348319239914417, -0.0052862390875816345, 0.03625188395380974, 0.026268333196640015, 0.02009379118680954, 0.022936347872018814,
    -0.005655932240188122, -0.0012366104638203979, 0.0028070220723748207, -0.06700606644153595, 0.036960624158382416, -0.044548917561769485, 0.058587078005075455, 0.04168643802404404,
    0.02214164100587368, 0.10550928115844727, 0.05475260317325592, -0.0015345540596172214, 0.043209534138441086, 0.0015018389094620943, -0.022933758795261383, -0.012060736306011677,
    0.04414176568388939, 0.036881741136312485, -0.006394670344889164, -0.02239217422902584, -0.003154071280732751, 0.04982242360711098, -0.06899737566709518, -0.022474735975265503,
    0.10697024315595627, 0.042707622051239014, 0.01556831132620573, 0.023204192519187927, 0.014489357359707355, 0.055754076689481735, -0.006015507970005274, 0.007787792012095451,
    0.022802220657467842, 0.03297935798764229, -0.10248688608407974, 0.013779369182884693, 0.02739546447992325, -0.04689342528581619, -0.003579584648832679, 0.045498400926589966,
    -0.042386043816804886, -0.02841014228761196, -0.02453746274113655, -0.039834264665842056, -0.041359130293130875, -0.0019821582827717066, 0.016325563192367554, 0.06796639412641525,
    0.002887537470087409, -0.009935779497027397, 0.04822676628828049, -0.00026221323059871793, 0.023170748725533485, -0.045335523784160614, -0.07202927023172379, -0.06701815128326416,
    0.05241287499666214, -0.011295411735773087, -0.09914340078830719, -0.009426798671483994, 0.04658457264304161, -0.02655116654932499, -0.01763344183564186, 0.039916615933179855,
    0.028068140149116516, 0.0036932106595486403, -0.008623367175459862, 0.031208688393235207, 0.007337193936109543, -0.009892077185213566, 0.003566236700862646, 0.004129922483116388,
    -0.015190030448138714, -0.07669336348772049, 0.0371086522936821, -0.025551868602633476, -0.06427906453609467, 0.027389535680413246, -0.1595131903886795, 0.053241096436977386,
    0.018029216676950455, 0.008754304610192776, 0.003069833619520068, -0.0705639123916626, 0.018675345927476883, 0.07854008674621582, 0.05186806619167328, 0.01494708750396967,
    -0.05034424364566803, -0.008088442496955395, -0.0054634939879179, -0.1536291539669037, -0.025567052885890007, -0.06416996568441391, 0.026774901896715164, 0.003060357877984643,
    0.009440305642783642, -0.12371622771024704, -0.029964420944452286, 0.008731232024729252, -0.023331603035330772, 0.011826127767562866, 0.0535690113902092, 0.02326052635908127,
    -0.03047260083258152, 0.023220647126436234, 0.06367457658052444, -0.0490439273416996, -0.02327977493405342, 0.04474975913763046, -0.030197907239198685, 0.009766758419573307,
    0.02308199368417263, -0.0028480561450123787, 0.0674758329987526, 0.02737322635948658, -0.004914750810712576, 0.045870810747146606, -0.029108231887221336, -0.02747427113354206,
    -0.04421164095401764, -0.04625513404607773, 0.017548320814967155, -0.05648106709122658, -0.034957386553287506, 0.020524127408862114, 0.017504924908280373, 0.02114783599972725,
    0.02381247468292713, 0.014066040515899658, 0.009110108017921448, -0.0441809706389904, -0.02979162521660328, -0.03741954267024994, -0.018643276765942574, 0.06455101072788239,
    -0.015552797354757786, 0.16739042103290558, 0.0021483281161636114, 0.12286221235990524, 0.05195154994726181, 0.04326961189508438, 0.011915655806660652, -0.06021291762590408,
    0.08382727205753326, -0.002998376963660121, 0.03554080054163933, -0.0051462650299072266, -0.016436288133263588, 0.026835575699806213, -0.058715857565402985, -0.014804300852119923,
    0.11695469915866852, 0.08947956562042236, -0.007829386740922928, 0.04405331611633301, -0.005329194478690624, -0.05159687250852585, 0.020566426217556, -0.05250944197177887,
    0.024871859699487686, -0.028512241318821907, -0.10910390317440033, -0.010883653536438942, -0.01237418595701456, -0.019702507182955742, 0.022371850907802582, -0.004681670106947422,
    0.02218543365597725, 0.020444627851247787, 0.05196889862418175, 0.010603946633636951, -0.0073738107457757, 0.05833614245057106, 0.03968219831585884, 0.001918021123856306,
    0.058310847729444504, -0.00490590138360858, 0.007300639990717173, -0.021417759358882904, 0.09804937988519669, -0.014141310937702656, -0.010606915690004826, -0.06108730658888817,
    0.008371594361960888, -0.02799323946237564, 0.03827502205967903, 0.0013773587998002768, -0.05833534896373749, -0.007535133045166731, 0.02790534310042858, 0.11369527131319046,
    0.019389187917113304, -0.01830066367983818, -0.01827285625040531, 0.043365802615880966, 0.0031343908049166203, -0.036549828946590424, 0.07689309865236282, 0.0022509091068059206,
    0.04783904179930687, -0.0024682062212377787, -0.013365481048822403, 0.002729964442551136, 0.006879804190248251, 0.03169998526573181, -0.12321481108665466, 0.062390584498643875,
    0.03310881182551384, 0.039724819362163544, 0.01294108759611845, -0.04200434684753418, 0.0415327213704586, -0.02623821794986725, 0.06249050423502922, 0.02490083873271942,
    -0.021693086251616478, 0.0018569712992757559, -0.015793994069099426, -0.07206916809082031, -0.03473296016454697, -0.10484880208969116, -0.02915058098733425, 0.0035314206033945084,
    0.03977959603071213, -0.0706399604678154, 0.06926334649324417, 0.02041448839008808, -0.018337685614824295, 0.07378683984279633, 0.06290066242218018, 0.02467465028166771,
    -0.06745178997516632, 0.00038083348772488534, -0.11340074986219406, -0.004707298707216978, -0.0146888867020607, 0.008986320346593857, -0.028176192194223404, -0.015373860485851765,
    -0.07064465433359146, 0.03247622400522232, 0.007791194599121809, 0.03504046052694321, -0.019387168809771538, -0.01635696366429329, 0.026390118524432182, 0.04595886543393135,
    0.007156053092330694, 0.05443107709288597, -0.04437001794576645, 0.0770278126001358, -0.08293614536523819, 0.055747050791978836, -0.009489248506724834, -0.03635136038064957,
    0.045669808983802795, -0.011943701654672623, -0.028016716241836548, -0.1277104914188385, 0.0341896191239357, -0.05953218415379524, 0.046449605375528336, 0.04476745054125786,
    -0.02220614068210125, 0.06576436758041382, -0.029375294223427773, 0.004689511843025684, 0.04046183079481125, -0.015174414031207561, -0.024666640907526016, -3.395488238311373e-05,
    -0.0011863538529723883, -0.01049590390175581, 0.028606250882148743, -0.03850531578063965, -0.027774930000305176, 0.02642848528921604, -0.025222934782505035, -0.0035862771328538656,
    0.11313966661691666, -0.021491456776857376, 0.020328398793935776, -0.004119778051972389, -0.014573972672224045, -0.02424272894859314, -0.005668408237397671, -0.05686090886592865,
    0.002422213088721037, -0.04816879704594612, -0.0627361610531807, 0.0031147655099630356, -0.026571795344352722, -0.04107296094298363, 0.012296685948967934, -0.00972860399633646,
    -0.021562984213232994, -0.004167941864579916, -0.02152612991631031, -0.018851706758141518, -0.025484340265393257, 0.08332567662000656, 0.04081433638930321, -0.05196303501725197,
    0.018132377415895462, -0.044250573962926865, 0.06894378364086151, 0.02875964529812336, 0.07887709885835648, -0.047752540558576584, -0.005812835413962603, -0.044158902019262314,
    -0.02428356744349003, 0.016562972217798233, 0.06112992390990257, 0.06648537516593933, -0.026642613112926483, -0.03224273771047592, -0.033524103462696075, 0.09334748238325119,
    0.07998131960630417, -0.007910222746431828, -0.0038567676674574614, 0.042528148740530014, 0.0019969106651842594, -0.04742750525474548, -0.017178744077682495, -0.0077395327389240265,
    0.012725809589028358, 0.003952828701585531, 0.0040122270584106445, 0.010630159638822079, -0.010567896068096161, 0.04342903569340706, -0.1513645499944687, 0.013086560182273388,
    0.0027058932464569807, 0.006033779121935368, 0.06782428175210953, 0.02788679488003254, 0.06568025797605515, 0.0547160841524601, 0.03152959793806076, 0.0050180754624307156,
    -0.014947224408388138, -0.00644879462197423, -0.006261372938752174, -0.015527023933827877, -0.06761853396892548, -0.08537569642066956, 0.045184604823589325, 0.06536614149808884,
    0.028895169496536255, -0.09064190834760666, 0.03442283347249031, 0.0017477612709626555, 0.012557766400277615, 0.0574713870882988, 0.11625108867883682, -0.03596596419811249,
    -0.006315404549241066, 0.014229937456548214, -0.021562375128269196, 0.02716989628970623, -0.0036718177143484354, 0.0437135174870491, 0.011598709039390087, 0.0035595602821558714,
    0.010058218613266945, -0.01727008819580078, -0.021747758612036705, 0.00717721926048398, 0.019079722464084625, -0.01751892641186714, -0.003983885515481234, -0.0020332515705376863,
    -0.02154972404241562, -0.04623711109161377, -0.07308011502027512, 0.08245115727186203, -0.19861756265163422, 0.0289112888276577, -0.018191322684288025, -0.021813003346323967,
    0.016675082966685295, -0.02414468117058277, 0.02192043885588646, -0.049106016755104065, -0.04793912172317505, -0.06815525144338608, 0.03762140870094299, 0.009077840484678745,
    0.0028361680451780558, 0.14210493862628937, 0.0179884172976017, 0.027159757912158966, 0.04518146440386772, -0.019314659759402275, -0.004940128419548273, -0.003925727680325508,
    0.04541657865047455, -0.034677084535360336, 0.041619352996349335, 0.010866481810808182, -0.011285796761512756, 0.015081576071679592, 0.05872049182653427, -0.006064427550882101,
    0.11547699570655823, -0.05176341533660889, -0.027143530547618866, -0.03721456229686737, 0.019934862852096558, 0.02673228643834591, -0.024203162640333176, -0.050844352692365646,
    -0.03176353499293327, -0.05386499688029289, 0.011094455607235432, -0.14667609333992004, 0.07682988047599792, 0.0069489870220422745, 0.0053911516442894936, 0.018859367817640305,
    -0.032061994075775146, 0.020022781565785408, 0.0014808839187026024, -0.037512682378292084, 0.031264614313840866, 0.02132461406290531, 0.012740718200802803, -0.09171798825263977,
    0.03713855892419815, -0.019044185057282448, -0.02854575403034687, 9.285931446356699e-05, 0.07079625874757767, -0.05505172908306122, -0.06556528061628342, 0.08472946286201477,
    0.045355163514614105, -0.005101620685309172, 0.07015835493803024, -0.03252771496772766, 0.04033821076154709, 0.006091299466788769, 0.02047058567404747, 0.09797994047403336,
    0.07637277990579605, 0.0006083871121518314, -0.03579843044281006, 0.03778260201215744, -0.030187584459781647, 0.09230461716651917, 0.043344415724277496, 0.02622365951538086,
    0.015343786217272282, -0.013734524138271809, 0.014876888133585453, -0.0461491160094738, 0.00706343911588192, 0.05232852324843407, -0.08801127225160599, 0.02113158069550991,
    0.018254678696393967, 0.038788292557001114, 0.02816297858953476, -0.0858871266245842, 0.053680114448070526, -0.011401291005313396, 0.0379047617316246, 0.009036905132234097,
    -0.05449799820780754, 0.020413123071193695, -0.00688693905249238, 0.021044569090008736, -0.06587257981300354, -0.05866702273488045, -0.03216846287250519, 0.07648070901632309,
    -0.015339464880526066, -0.033111974596977234, 0.019763553515076637, -0.031866684556007385, 0.02034730277955532, 0.041312988847494125, 0.0806688517332077, -0.05978971719741821,
    -0.04350801557302475, -0.016058754175901413, -0.054782282561063766, -0.034132298082113266, -0.00035177619429305196, -0.021529998630285263, -0.047328852117061615, 0.051391489803791046,
    -0.007794683333486319, 0.035623013973236084, -0.0046560256741940975, 0.05153290554881096, -0.00606864970177412, -0.007962086237967014, 0.002862178487703204, 0.052418388426303864,
    -0.008380685932934284, -0.01140714529901743, 0.04739199951291084, -0.05536751076579094, -0.10229405760765076, 0.020809601992368698, -0.03747054934501648, -0.0426088310778141,
    0.1256687343120575, 0.013435805216431618, -0.03207240626215935, -0.07330919057130814, 0.006740827579051256, 0.011216788552701473, 0.10356937348842621, -0.0017884372500702739,
    -0.0013816908467561007, 0.12499331682920456, 0.03243466466665268, 0.010459146462380886, 0.03281557559967041, 0.0629802942276001, 0.0015743367839604616, -0.00035984331043437123,
    0.016977351158857346, 0.040093570947647095, 0.07717368006706238, 0.004328848794102669, 0.01764145866036415, 0.006544624920934439, -0.008778666146099567, 0.008147096261382103,
    0.09082964062690735, 0.06609071791172028, -0.035229019820690155, -0.023356996476650238, -0.030751612037420273, 0.0021066477056592703, -0.04082617536187172, 0.018909212201833725,
    -0.006403606850653887, 0.007104826625436544, 0.09813269227743149, -0.048181526362895966, 0.006151912268251181, 0.036131080240011215, 0.014012496918439865, -0.013193350285291672,
    -0.04638258367776871, -0.01078052632510662, -0.004060582723468542, 0.020276382565498352, -0.004153568763285875, 0.04142611846327782, 0.04134422913193703, -0.030350888147950172,
    0.01999611034989357, -0.04621792957186699, -0.011869964189827442, 0.0635160431265831, -0.011290909722447395, 0.0020609984640032053, -0.0727253332734108, 0.08795987069606781,
    -0.051188819110393524, -0.023547224700450897, 0.05541727691888809, -0.00922493264079094, -0.02366768755018711, 0.05475888401269913, 0.04693000763654709, 0.0027337949723005295,
    0.12093962728977203, -0.03620481491088867, 0.03394479677081108, 0.013118247501552105, -0.06144023314118385, 0.02269092947244644, 0.004117424134165049, -0.03431301936507225,
    0.06759387999773026, -0.045686379075050354, -0.0289450716227293, -0.04198874533176422, 0.004925318527966738, 0.04750293493270874, -0.17147275805473328, 0.009634235873818398,
    -0.00896588433533907, -0.031224386766552925, 0.054411400109529495, -0.06896564364433289, -0.03796303644776344, 0.017452076077461243, 0.008472512476146221, -0.028421854600310326,
    -0.0642872303724289, 0.00415125023573637, -0.07220210880041122, -0.03309420868754387, -0.030100084841251373, -0.12076255679130554, 0.008314372040331364, -0.01423620991408825,
    -0.00807212945073843, -0.05074615404009819, -0.09639522433280945, 0.0119736697524786, 0.00010382194159319624, 0.08804736286401749, 0.08585462719202042, -0.06720235198736191,
    -0.005445792339742184, 0.012279466725885868, -0.03534866124391556, -0.011051720939576626, -0.00566985784098506, 0.006076074671000242, -0.01696787029504776, 0.07051718980073929,
    0.027128955349326134, 0.03719437122344971, -0.022861892357468605, 0.04340348765254021, 0.03792143240571022, 0.042469631880521774, -0.06454192101955414, 0.030360061675310135,
    -0.0410914346575737, -0.0047763935290277, 0.02058602310717106, 0.03673606365919113, -0.007243808824568987, 0.010682649910449982, -0.007568498607724905, 0.005965759977698326,
    0.0015154932625591755, 0.016205983236432076, 0.039916761219501495, -0.08479838818311691, 0.027760935947299004, -0.048212651163339615, 0.10096688568592072, 0.0351836197078228,
    0.02941250242292881, 0.03663131967186928, 0.021136749535799026, 0.06981290876865387, -0.0023187780752778053, 0.054065149277448654, -0.01642320677638054, 0.014427699148654938,
    -0.0159137062728405, 0.0709560364484787, 0.01769721880555153, 0.0061187464743852615, -0.026952974498271942, 0.006794012151658535, 0.002702978439629078, 0.007260966580361128,
    0.05552441626787186, 0.05278463661670685, -0.011973239481449127, 0.04624441638588905, 0.09534826874732971, -0.01546516828238964, -0.011434515938162804, 0.02948121912777424,
    -0.005134361330419779, 0.0018448121845722198, 0.023399194702506065, -0.031028971076011658, -0.00043572118738666177, -0.012287970632314682, -0.041543200612068176, -0.011478899046778679,
    -0.00644279969856143, -0.002097377786412835, 0.004579280503094196, 0.000757122877985239, -0.04802088066935539, -0.021732386201620102, 0.06700513511896133, -0.044583696871995926,
    -0.02010921575129032, 0.01146731898188591, 0.0029830688145011663, -0.00129737239331007, 0.0191932525485754, -0.025754593312740326, -0.01653037965297699, -0.009256293065845966,
    -0.1061318963766098, -0.00603562593460083, 0.002227239543572068, 8.575496758567169e-05, -0.02191108837723732, 0.04091067612171173, 0.036452438682317734, 0.0482364222407341,
    -0.0030996932182461023, 0.020577801391482353, -0.016607273370027542, 0.012054537422955036, -0.04103120416402817, 0.009584395214915276, -0.0015033520758152008, 0.01375572569668293,
    -0.02854294888675213, 0.04084434732794762, 0.00141916424036026, -0.08568842709064484, -0.016511160880327225, 0.033582717180252075, -0.19538193941116333, -0.007710677105933428,
    0.023992249742150307, -0.07667676359415054, 0.015021917410194874, -0.02594400942325592, 0.027010859921574593, 0.0399358905851841, 0.020837334915995598, 0.044517792761325836,
    -0.031047383323311806, 0.019284620881080627, -0.028985917568206787, -0.05184687301516533, 0.007978997193276882, -0.027600284665822983, 0.02050233632326126, -0.0010565733537077904,
    0.010041722096502781, 0.010122028179466724, -0.06669560819864273, -0.0013952647568657994, -0.018951617181301117, 0.01872653141617775, 0.0415596067905426, -0.07973706722259521,
    -0.0076712146401405334, -0.03365561366081238, 0.013801760040223598, 0.09299884736537933, 0.0035242110025137663, -0.017075588926672935, -0.04519123584032059, -0.0016340345609933138,
    0.021308565512299538, 0.05994759872555733, -0.002469352912157774, 0.013380971737205982, 0.03557228296995163, 0.02798503451049328, -0.016221284866333008, 0.07128693163394928,
    -0.019911564886569977, -0.0014089969918131828, -0.026843318715691566, 0.006734521593898535, -0.01869017444550991, 0.05892597511410713, -0.0696101188659668, -0.035534147173166275,
    0.05774443596601486, -0.02481621503829956, -0.021805686876177788, -0.05144369229674339, 0.013023948296904564, 0.04401850700378418, -0.01862763613462448, 0.014164420776069164,
    -0.03644206374883652, 0.03212516009807587, 0.03876493498682976, 0.06313657015562057, 0.0457172654569149, -0.0004881038621533662, -0.02319779247045517, 0.0198989138007164,
    0.007571300491690636, 0.037601493299007416, 0.04735331982374191, 0.0490068681538105, -0.027212142944335938, 0.02361498959362507, -0.00965797994285822, -0.0009854589588940144,
    -0.002368501154705882, 0.05117257311940193, -0.015212036669254303, -0.01744987815618515, 0.001466734567657113, -0.004663384053856134, -0.04852144420146942, 0.09387972950935364,
    0.0035643624141812325, -0.027532653883099556, -0.01203199103474617, -0.030521618202328682, -0.07561832666397095, -0.025547021999955177, -0.01157771609723568, 0.048232223838567734,
    -0.010621964931488037, -0.035250961780548096, 0.018511462956666946, -0.03094692900776863, -0.07558386027812958, -0.027287302538752556, 0.014717143028974533, 0.010250572115182877,
    0.05704030022025108, -0.06627480685710907, 0.0060747950337827206, 0.014393607154488564, 0.003977133892476559, 0.06137540936470032, -0.06854584813117981, -0.07679904997348785,
    -0.111143559217453, -0.02170511521399021, 0.05322981998324394, 0.007773298304527998, 0.009313037618994713, 0.033637091517448425, -0.016834577545523643, 0.009496905840933323,
    0.013294493779540062, 0.001600616960786283, 0.03389082849025726, 0.08156470209360123, -0.005263985134661198, -0.05096091702580452, -0.030499817803502083, 0.01912206970155239,
    0.07887154817581177, -0.000971526256762445, 0.007002438884228468, -0.1088290885090828, 0.03654132038354874, 0.027240661904215813, -0.09593116492033005, -0.06705058366060257,
    -0.024610932916402817, -0.011892539449036121, 0.04199741780757904, -0.04739895462989807, 0.04606493562459946, 0.007967776618897915, 0.033598434180021286, 0.003100653411820531,
    -0.006617316044867039, 0.009536392986774445, -0.04472993686795235, -0.05385100468993187, 0.06004362180829048, -0.06183234602212906, -0.009807633236050606, -0.031495049595832825,
    0.0663362368941307, -0.005974071566015482, -0.04734691604971886, -0.006459257565438747, 0.018181422725319862, 0.020316991955041885, 0.04331737384200096, -0.026027917861938477,
    -0.0032131781335920095, -0.021770967170596123, -0.026980658993124962, 0.0032059599179774523, 0.0006110012182034552, 0.02415965497493744, -0.0046122451312839985, 0.04809488728642464,
    -0.06525067985057831, 0.043540384620428085, -0.07335963845252991, 0.008710453286767006, 0.029819348827004433, 0.10049264132976532, -0.03494781628251076, 0.01624879240989685,
    0.026303833350539207, 0.011175197549164295, -0.029963523149490356, 0.07568252831697464, 0.05432340130209923, 0.017551936209201813, -0.030440088361501694, 0.06427300721406937,
    0.003065379336476326, -0.020268725231289864, 0.0177463386207819, -0.06437528133392334, 0.08253370225429535, 0.036290302872657776, 0.033430978655815125, 0.040633779019117355,
    0.03721192106604576, 0.03388969227671623, 0.00446456391364336, 0.04175206646323204, -0.01973426528275013, 0.019489673897624016, -0.005340295378118753, 0.0340987928211689,
    0.012400702573359013, -0.011391530744731426, 0.006147297564893961, 0.025243127718567848, -0.00021593116980511695, 0.005673154257237911, 0.04739604517817497, 0.027347898110747337,
    0.00936066173017025, 0.02476401813328266, -0.030839908868074417, -0.006960691884160042, 0.014853157103061676, -0.020371388643980026, 0.017912879586219788, 0.04520672187209129,
    -7.009213004494086e-05, 0.006720675155520439, -0.0581318698823452, 0.010470272973179817, 0.013567494228482246, -0.01019914261996746, -0.029853668063879013, -0.08721941709518433,
    0.05830282345414162, 0.03892652690410614, 0.008848985657095909, -0.02927110344171524, -0.051744572818279266, -0.03200896084308624, -0.0008702785708010197, -0.004145825747400522,
    -0.036601729691028595, 0.017966706305742264, 0.058797840029001236, -0.09584715217351913, 0.04868614673614502, -0.06612184643745422, -0.04831785708665848, -0.03653663769364357,
    -0.07465580105781555, -0.014314873144030571, -0.027053752914071083, -0.021792711690068245, 0.07143344730138779, 0.018008027225732803, -0.05586943402886391, 0.03884781152009964,
    0.06618519872426987, -0.01213319692760706, 0.0008674946730025113, 0.02265004813671112, 0.03811902552843094, 0.1118110790848732, -0.030579132959246635, -0.009086785838007927,
    -0.033934902399778366, 0.07939933985471725, -0.00872157234698534, -0.12393929809331894, -0.015013501979410648, 0.007499489933252335, -0.12605340778827667, -0.035441525280475616,
    0.026895642280578613, -0.0296050775796175, -0.00035418817424215376, -0.031840626150369644, 0.002322156447917223, 0.007849176414310932, 0.0011644646292552352, -0.02686881646513939,
    -0.04052592068910599, -0.007720348425209522, 0.0363655760884285, -0.011828217655420303, -0.003126728581264615, -0.03962362930178642, -0.0037178376223891973, 0.0059311604127287865,
    -0.05706039443612099, 0.06085085868835449, -0.04007492959499359, -0.0016383036272600293, -0.0012982654152438045, -0.005192455369979143, -0.020405154675245285, -0.06078391894698143,
    -0.01607821322977543, 0.021693900227546692, 0.05503927171230316, -0.03163323923945427, 0.0025380742736160755, -0.046577565371990204, -0.04467931017279625, 0.06153566390275955,
    0.010141185484826565, -0.024014068767428398, 0.029855411499738693, -0.009089949540793896, 0.04560340195894241, -0.04124670848250389, 0.047161586582660675, 0.04819504916667938,
    -0.05771416425704956, -0.0013351553352549672, 0.012123160064220428, -0.042383987456560135, -0.05545562878251076, 0.01163662038743496, -0.08090085536241531, -0.06870557367801666,
    0.044279683381319046, 0.0014968595933169127, -0.007900427095592022, 0.010044604539871216, 0.08812152594327927, 0.022153524681925774, 0.006033177487552166, 0.014111362397670746,
    -0.06720152497291565, 0.030844910070300102, 0.043999504297971725, 0.050877586007118225, -0.014563278295099735, 0.05552717670798302, -0.0021794934291392565, -0.007352475076913834,
    0.007242002058774233, 0.032906267791986465, 0.0757354274392128, 0.045641347765922546, -0.016675278544425964, -0.03334428742527962, -0.07171956449747086, 0.0018569329986348748,
    0.07162415981292725, 0.0238193329423666, -0.01787908375263214, 0.06233757361769676, 0.011666734702885151, -0.007219389546662569, -0.005648808088153601, 0.025724070146679878,
    -0.04054874926805496, 0.015552754513919353, -0.06440769881010056, -0.05590343102812767, 0.021213246509432793, -0.09586123377084732, -0.0009564916836097836, 0.013488022610545158,
    -0.02743568643927574, -0.03640162944793701, 0.003936445340514183, -0.008920246735215187, 0.06880791485309601, -0.02466289885342121, 0.05178491398692131, -0.0023015590850263834,
    0.0036604285705834627, -0.022377584129571915, 0.022842254489660263, 0.0489075630903244, 0.03272586688399315, -0.008222735486924648, -0.033646754920482635, 0.019493425264954567,
    -0.028681805357336998, -0.027855725958943367, 0.021220289170742035, 0.07050598412752151, 0.020619763061404228, 0.022256091237068176, 0.0069696661084890366, 0.0004518193891271949,
    -0.02541392855346203, 0.01868940331041813, -0.02147125080227852, -0.002926645101979375, -0.00826243031769991, -0.008774825371801853, 0.044951390475034714, -0.0075506665743887424,
    0.002628046553581953, 0.014047907665371895, 0.024706857278943062, -0.09375380724668503, 0.01070871390402317, 0.008510456420481205, -0.018197208642959595, 0.021034641191363335,
    0.022536881268024445, -0.01642977073788643, 0.026037022471427917, -0.0028496566228568554, -0.028781725093722343, -0.009597878903150558, 0.06880726665258408, 0.011493625119328499,
    -0.015402192249894142, -0.003584071062505245, -0.06679998338222504, -0.025247132405638695, 0.16104699671268463, -0.057397812604904175, 0.03311935067176819, 0.013505132868885994,
    0.03333345055580139, 0.0029435146134346724, -0.13477003574371338, 0.039118025451898575, 0.03068324364721775, 0.025366684421896935, 0.013300091028213501, -0.09868447482585907,
    -0.03925883024930954, -0.034264564514160156, 0.010038867592811584, -0.03381158784031868, -0.02143281139433384, 0.00637664832174778, -0.014789366163313389, -0.03248266130685806,
    -0.028161225840449333, 0.011782575398683548, -0.07432980835437775, 0.021011555567383766, 0.02685372531414032, 0.07831127941608429, -0.052895016968250275, 0.0009556227014400065,
    0.01295878179371357, -0.015543568879365921, -0.012000630609691143, -0.0025467583909630775, 0.06885389238595963, 0.0448952317237854, -0.01786000281572342, 0.0795510932803154,
    0.06368618458509445, 0.01103976834565401, 0.02915079891681671, -0.052357010543346405, 0.09256089478731155, -0.0010314855026081204, 0.011538145132362843, 0.02221539616584778,
    0.08596234023571014, -0.015775948762893677, 0.0569138377904892, 0.0863480418920517, 0.02846171148121357, 0.08890077471733093, 0.0060684881173074245, -0.024771904572844505,
    -0.036545224487781525, 0.02478739619255066, 0.008961413986980915, 0.031101277098059654, -0.03504422679543495, -0.012596461921930313, -0.0032130961772054434, 0.015955453738570213,
    -0.0996835008263588, -0.0107758529484272, -0.011621834710240364, 0.0662369579076767, 0.041195426136255264, -0.010851177386939526, -0.02391900308430195, -0.03943515941500664,
    -0.009050339460372925, -0.04509790241718292, 0.0030632722191512585, -0.006432697176933289, -0.017690619453787804, 0.033331867307424545, 0.0003711546305567026, 0.020496051758527756,
    0.10253942012786865, 0.028798729181289673, 0.018212156370282173, 0.011116775684058666, 0.09702574461698532, 0.002340880688279867, 0.031025949865579605, 0.08962224423885345,
    -0.012799838557839394, 0.019508138298988342, -0.016481373459100723, -0.015377427451312542, 0.03640994802117348, -0.04342007637023926, -0.03907722234725952, 0.05667757987976074,
    -0.06491746008396149, -0.03684031218290329, 0.0819132998585701, -0.01449856162071228, -0.018621399998664856, 0.029414936900138855, -0.026477346196770668, 0.04260318726301193,
    -0.03783441334962845, -0.02099822834134102, 0.020045002922415733, 0.011626924388110638, 0.05411549657583237, 0.04418950527906418, -0.03421112522482872, 0.05439366027712822,
    -0.007791711017489433, 0.049114298075437546, 0.04323538765311241, -0.06342033296823502, 0.009351883083581924, 0.00795003492385149, -0.003723363857716322, -0.06292182207107544,
    -0.007543829269707203, -0.018516020849347115, -0.016910305246710777, 0.004579192027449608, -0.03414439409971237, 0.02076176553964615, 0.036372244358062744, 0.020404312759637833,
    0.05930449441075325, 0.005256579257547855, 0.01987682282924652, -0.040083494037389755, 0.05177215859293938, -0.006723431870341301, -0.006411424838006496, 0.026193322613835335,
    0.009716774336993694, 0.00414638128131628, -0.17181719839572906, -0.027234267443418503, -0.01646820455789566, 0.06022122502326965, 0.017437366768717766, -0.0078081716783344746,
    0.007495760917663574, -0.030677011236548424, 0.0104147307574749, 0.05055398494005203, -0.013196749612689018, -0.009272297844290733, -0.04614071547985077, -0.036865655332803726,
    -0.0022139393258839846, 0.0035006802063435316, -0.008257544599473476, -0.004780712071806192, 0.008609647862613201, -0.024382442235946655, -0.05232415348291397, 0.009984615258872509,
    -0.011899948120117188, 0.03766602650284767, -0.004845310468226671, -0.011775495484471321, -0.005561769008636475, 0.03490154817700386, 0.03377988189458847, -0.07240403443574905,
    0.05266648530960083, 0.00307083735242486, -0.017304690554738045, 0.014159140177071095, -0.00026198726845905185, 0.009829158894717693, -0.024918491020798683, 0.006185863167047501,
    -0.0341658815741539, -0.029040943831205368, 0.050900354981422424, -0.007620395626872778, -0.07331360876560211, 0.06332281976938248, -0.03712274879217148, 0.004344809800386429,
    0.01155130472034216, -0.033823080360889435, 0.010133686475455761, 0.003753124037757516, 0.00174176343716681, -0.060823772102594376, 0.03532927483320236, 0.019049135968089104,
    -0.05263414978981018, -0.021853841841220856, -0.0021941482555121183, 0.01622631959617138, 0.04609336331486702, 0.014012886211276054, 0.013809951022267342, 0.036956578493118286,
    -0.04674431309103966, 0.014476784504950047, 0.04866975173354149, -0.025639856234192848, 0.04024485871195793, -0.023826591670513153, -0.00532738771289587, -0.006581330671906471,
    -0.05422332137823105, -0.016660667955875397, 0.0027608920354396105, -0.029659859836101532, 0.0071607488207519054, -0.04390500858426094, -0.0049809617921710014, 0.018646320328116417,
    0.02998679131269455, -0.002673370996490121, 0.009644562378525734, -0.01953250728547573, -0.011068508960306644, -0.020641542971134186, -0.01348532922565937, -0.008958378806710243,
    -0.034774139523506165, -0.005488324444741011, -0.01633603312075138, -0.009426328353583813, -0.009809854440391064, 0.021658331155776978, -0.03330326825380325, 0.034650254994630814,
    0.056397002190351486, -0.013061892241239548, -0.007806353271007538, 0.06739918142557144, -0.03288991376757622, 0.029055699706077576, -0.027473149821162224, 0.004244083538651466,
    0.011633344925940037, 0.019708266481757164, 0.003273364156484604, -0.016809893772006035, -0.010289418511092663, 0.0027833464555442333, -0.024129489436745644, 0.011562840081751347,
    -0.0160451028496027, -0.024270765483379364, 0.0002467232116032392, -0.0175656508654356, 0.06149662658572197, -0.01812734082341194, -0.5109840631484985, 0.0012081776512786746,
    0.004588821437209845, 0.01982659287750721, -0.014773227274417877, 0.02666204608976841, 0.19511379301548004, 0.09948708862066269, 0.0005258144810795784, -0.0789056196808815,
    -0.0025763167068362236, -0.000713484303560108, -0.06089819222688675, 0.018540045246481895, -0.005108597222715616, -0.036147940903902054, -0.04108639433979988, -0.009090207517147064,
    0.014910144731402397, 0.0011394355678930879, -0.0060272496193647385, -0.04541875422000885, -0.01420185249298811, -0.0050141713581979275, -0.025008676573634148, -0.013477341271936893,
    -0.02274978905916214, -0.015135490335524082, 0.0010373620316386223, -0.0027442025020718575, -1.4594414234161377, -0.02561485394835472, 0.007898114621639252, 0.012658873572945595,
    -0.007858593948185444, -0.006012665573507547, 0.021378207951784134, -0.004830983001738787, -0.0006095063872635365, -0.015132184140384197, 0.009515474550426006, -0.007110205478966236,
    0.07584206759929657, 0.0014226954663172364, -0.0015211572172120214, -0.021671760827302933, 0.006236095912754536, -0.03253434598445892, 0.012181109748780727, -0.023160595446825027,
    -0.006631054449826479, 0.036122627556324005, 0.11800874024629593, 0.025498218834400177, -0.009940178133547306, 0.007409031502902508, 0.02064148150384426, -0.017148282378911972,
    -0.047103919088840485, -0.03231806680560112, -0.006687189918011427, 0.007683939766138792, -0.009866331703960896, -0.017826611176133156, -0.06748303771018982, 0.01769634522497654,
    -0.03306302800774574, -0.08661845326423645, -0.01819099485874176, -0.016177285462617874, -0.02525998093187809, 0.005995189771056175, -0.12925177812576294, -0.016153555363416672,
    0.011693570762872696, -0.017840838059782982, -0.0007112803868949413, 0.043304216116666794, 0.007161105517297983, -0.04889501631259918, 0.023793432861566544, 0.005699371453374624,
    0.010056824423372746, -0.013193126767873764, -0.0019260201370343566, -0.028429299592971802, -0.041973624378442764, -0.00408563669770956, 0.018596958369016647, 0.00334305502474308
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_bias_DEFINED
#define WEIGHTS_conv1_bias_TYPE WEIGHT_TYPE_float
static const float conv1_bias[128] = {
    -0.03467089310288429, 0.7054533958435059, 0.04220760986208916, -0.3211784064769745, 0.18379876017570496, 0.12234236299991608, 0.30766433477401733, 0.19862201809883118,
    -0.2797451913356781, -0.5010833144187927, 0.218307226896286, -0.3583465814590454, 0.058016594499349594, -0.07783688604831696, -0.24169450998306274, 0.23962365090847015,
    0.20052962005138397, -0.35192275047302246, 0.1786917895078659, -0.3941802382469177, -0.15353474020957947, -0.19972997903823853, -0.16951307654380798, 0.2581140100955963,
    -0.05513213947415352, -0.03685590624809265, 0.4832572340965271, 0.3039650321006775, 0.49259284138679504, 0.13318970799446106, -0.2986827492713928, 0.0885065495967865,
    -0.4377451539039612, 0.2733010947704315, 0.18623775243759155, -0.0723043754696846, 0.10051946341991425, -0.057749006897211075, 0.526908814907074, 0.13639242947101593,
    -0.3355027139186859, 0.271157830953598, 0.023743094876408577, 0.11988247185945511, -0.27613940834999084, -0.348859578371048, 0.08249887079000473, 0.017384622246026993,
    -0.367512047290802, -0.14845533668994904, -0.3593342900276184, 0.22902162373065948, 0.1578422337770462, -0.13162322342395782, -0.14708895981311798, -0.1365327090024948,
    0.18459682166576385, 0.6291872262954712, -0.41788986325263977, -0.14682774245738983, 0.06243904307484627, -0.17840605974197388, 0.20978133380413055, -0.14827872812747955,
    -0.17757512629032135, 0.3011390268802643, 0.2436922788619995, -0.3359017074108124, 0.03807944804430008, 0.1598978340625763, 0.258927583694458, 0.18942511081695557,
    -0.1442248672246933, -0.16342562437057495, 0.3077623248100281, 0.064948171377182, -0.20400932431221008, -0.08025918155908585, -0.18583780527114868, 0.28667837381362915,
    -0.13917528092861176, 0.32980117201805115, 0.333322137594223, 0.11428771167993546, 0.2714596688747406, 0.2261859029531479, 0.13577020168304443, -0.9436054229736328,
    0.849489688873291, 0.374915212392807, 0.3224475681781769, -0.30400049686431885, -0.15759240090847015, 0.012529125437140465, -0.17355430126190186, -0.23146456480026245,
    0.15526363253593445, -0.5322745442390442, 0.0797283872961998, -0.14305560290813446, 0.05089208111166954, -0.4379185736179352, -0.3153000473976135, 0.5146224498748779,
    0.16846014559268951, -0.23644064366817474, -0.6552860140800476, 0.1157529354095459, -0.05409948527812958, -0.01632203906774521, -0.02568044140934944, -0.15215358138084412,
    0.16941644251346588, -0.43376046419143677, -0.10243357717990875, 0.07745698094367981, -0.43685561418533325, 0.1849045604467392, -0.3470224440097809, 0.0679205134510994,
    0.048307865858078, 0.3506048023700714, 0.42989781498908997, -0.11881612241268158, -0.3236740827560425, -0.03669966384768486, -0.04257078468799591, -0.16305109858512878
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv2_weights_int8_DEFINED
#define WEIGHTS_conv2_weights_int8_TYPE WEIGHT_TYPE_int8
static const opus_int8 conv2_weights_int8[147456] = {
    -23, -30, -60, -3, 7, 17, 7, 27,
    -12, 43, 21, 2, 12, -18, 27, 11,
    12, -5, -20, -3, -3, 11, -7, 7,
    7, 5, -12, 6, -12, 21, -24, -3,
    -36, -12, 1, -28, 3, -2, -16, 25,
    15, 26, 19, 2, 31, 0, -2, -21,
    -2, 24, 1, -40, -28, 11, 12, 5,
    2, 7, 1, -9, -7, -29, 9, -28,
    -8, -4, -3, -6, -3, -14, 17, 7,
    15, -47, 26, 31, -19, -7, -4, 3,
    2, -9, -25, 19, 29, -9, -15, 38,
    -8, -7, 6, 4, 10, -4, -33, 25,
    18, 3, -23, -41, 5, 5, -40, -40,
    24, -40, 51, -5, -9, -8, 3, 2,
    3, -1, 28, 5, 6, -5, -17, -6,
    -10, -17, 15, -1, 7, -6, 7, -24,
    -22, -13, 5, 2, -10, 3, 32, -27,
    15, 17, 44, 1, -3, 49, 17, 2,
    13, -3, -45, 13, -21, 13, -19, 5,
    10, -21, 22, 13, 15, -6, 8, -17,
    -7, -11, -62, -31, -2, -13, 9, 6,
    14, 3, -9, 12, 17, -48, -3, -18,
    21, 7, -1, 11, -11, 20, -3, -1,
    -1, -4, 9, 18, 34, -26, -53, -57,
    -36, 13, -2, 3, -4, 1, 9, -22,
    -9, 50, 60, 2, 10, -7, -11, -12,
    20, -35, 9, 30, -13, -46, -7, 47,
    7, -1, -11, 10, 19, -6, 9, -9,
    1, 10, 24, 6, 9, 17, 7, 17,
    42, 28, -11, 10, -15, -28, -18, -25,
    12, -24, 15, -21, 16, 34, 13, 0,
    4, 20, 17, -13, -5, 41, -24, 55,
    -22, -24, -33, -5, -5, 4, 7, 15,
    20, 20, 11, 4, 22, -10, 22, -11,
    -7, -34, -10, 10, -48, -2, -10, 22,
    -2, 6, 0, 7, -10, 52, -21, -4,
    -8, 17, -8, 0, 6, 7, -17, -9,
    3, 4, -21, -17, -9, -8, 6, 3,
    4, -23, -16, -1, -9, 28, -28, 35,
    4, 7, 41, 18, -11, 1, -4, 8,
    27, -46, -35, -2, 20, -26, 5, -5,
    21, -19, -19, -56, 15, 6, -9, 8,
    29, -20, -21, 11, 44, -43, 1, 2,
    -41, 16, -12, -10, 52, -8, -32, -2,
    3, 29, 14, 5, 32, -8, 7, 5,
    -9, 85, -6, 14, 0, 1, 6, -1,
    -2, -10, -27, -8, -19, -8, 40, 8,
    -4, -10, -13, 8, -4, 2, 1, 29,
    32, 19, 14, -12, 14, 15, 0, -5,
    -19, -22, 18, -19, 28, -3, 18, -30,
    -8, -21, 5, 6, 76, 18, 9, -7,
    14, -17, -27, 9, 9, 20, 12, 4,
    -28, -1, -3, 4, -1, 39, 3, 25,
    -7, -2, 44, 35, 26, 21, -10, -2,
    -2, -38, -13, -9, -28, -9, -9, -26,
    0, -12, -9, 3, -10, 3, 9, -4,
    -16, -12, 17, 18, -9, 37, 4, 39,
    0, 47, 8, 11, 9, -2, 40, -27,
    -34, 39, -7, 0, 15, 14, 29, 4,
    24, 14, 4, -40, -42, -21, 31, 29,
    16, 30, 20, -8, 45, 43, 13, 10,
    86, 14, -1, 6, 26, -16, -13, 16,
    -4, -5, 15, 0, 65, 11, -28, -5,
    18, 7, -17, -2, -19, -6, -8, -51,
    7, 14, -3, 0, 53, -8, -22, 2,
    -35, 41, 20, 5, -13, -6, -11, 23,
    -20, 18, -12, -36, 0, 11, 13, -10,
    -7, -5, 19, -1, -6, -19, 38, -3,
    13, -11, -9, -2, 7, -15, -8, -48,
    -32, 10, -7, -22, -29, -11, -16, 10,
    2, -10, 0, -3, -15, -12, 7, 27,
    -15, 10, -18, -19, -4, -4, 17, 8,
    11, 13, -10, -17, 4, -12, 17, 25,
    -44, 42, 16, -16, -9, -15, 6, -17,
    -14, -20, 2, -27, -14, 5, 3, 26,
    2, -5, 16, 29, 11, 30, -16, -6,
    -4, -35, 22, 15, 26, 7, 5, 26,
    34, -4, -5, -1, -21, 0, 8, 3,
    1, -20, 0, -25, 21, -20, 22, -1,
    42, -29, -1, 7, 1, -26, -31, 24,
    16, 17, -13, -31, 1, 15, 8, 2,
    35, 5, -35, 10, -26, -39, 15, -18,
    -74, 21, 0, -5, -11, 6, -19, 4,
    26, 12, 6, 14, 17, 20, 16, 17,
    -3, 30, -5, 18, 21, 11, -1, -22,
    -33, -11, 14, -50, 9, -17, 16, 5,
    1, -10, -29, -25, 4, -11, 43, -23,
    -11, -5, -36, 10, -2, 41, 27, -23,
    6, 12, -12, -7, 19, 33, 1, 11,
    8, -4, 10, 28, -32, 2, -18, -4,
    37, 5, 13, -2, 1, -5, 10, -49,
    -17, 13, -22, -23, -8, 13, 3, -17,
    26, 22, -3, -8, 22, 24, -12, 12,
    19, 44, 46, 17, 12, 31, 5, -7,
    -4, 2, 13, 0, -30, 44, 26, 16,
    0, 1, 26, 6, 22, 17, 4, -15,
    -58, 8, -7, 33, -16, -21, 4, 21,
    16, 16, 23, -25, -15, 28, -4, 4,
    -8, 12, -21, -10, -27, 7, 31, 27,
    36, -9, -15, 12, 3, 47, -40, -12,
    21, 27, 6, 2, -13, -25, -18, 13,
    3, -3, -19, 4, 6, -9, -37, -43,
    9, 25, -3, 40, -23, -37, -3, 3,
    -8, -42, 20, -11, 18, -31, 6, 33,
    13, -10, 9, -2, 11, 8, -6, 0,
    14, 72, 23, 28, -20, 14, -14, -32,
    10, 12, 1, 25, -9, 1, -20, -31,
    9, -13, -22, 12, -24, 17, -51, -10,
    -30, 9, -24, -22, -8, 1, -20, 17,
    3, -16, 17, -2, 1, 16, 11, 11,
    40, -26, -23, -30, 0, -45, 8, -21,
    7, -10, 7, 18, -9, 9, 8, -7,
    -17, -5, -12, 6, -4, 3, -8, 22,
    -25, -41, 47, -13, -15, -3, 3, 1,
    -3, 4, 7, -26, -11, 18, 13, -15,
    12, -16, -6, -4, -57, 2, -1, 14,
    11, -8, 28, -20, -10, -3, 17, 8,
    31, 78, 49, 10, -12, 0, 14, 14,
    -1, -7, -29, 27, -23, -13, -33, -3,
    -2, 1, -2, -1, 17, -10, -13, -6,
    8, 10, -24, -19, -4, 30, 6, 22,
    -20, 31, -43, -69, 9, -24, 27, -25,
    -15, 7, 10, -42, 3, -2, 17, 26,
    -10, 10, -23, -12, -45, 12, 17, -1,
    29, 26, 9, -12, -24, 82, 47, 12,
    -5, -22, 8, 36, -24, -7, 6, -3,
    -8, -34, -5, 13, 21, -27, 10, 3,
    -20, 5, 20, -3, 10, -20, 32, -13,
    -2, -30, -29, 37, 16, 7, 5, 44,
    9, 75, 29, -77, 16, -17, 18, -26,
    2, 5, -44, -41, 16, 18, -13, -24,
    -18, 7, -9, -22, -24, 14, -10, -22,
    -14, -68, 6, -13, -10, -39, -11, 13,
    37, 21, -13, -11, 30, -11, -18, 7,
    -25, -15, 4, -22, -31, 1, 6, 34,
    -6, -6, 6, 17, 1, -30, 1, -26,
    14, 24, -4, 47, -8, -8, -10, 18,
    1, -39, -18, -51, 11, 1, 36, -21,
    23, 11, 15, 48, 2, 0, -5, 7,
    -8, 3, -57, 19, -4, -10, -20, -17,
    10, 11, -8, 14, -1, 21, -1, -27,
    -7, -56, 15, -6, -6, 4, -18, -38,
    24, -1, 8, -6, 1, -17, -4, 27,
    -3, -34, -7, -22, 20, -3, 2, -11,
    -14, -6, 13, -13, -8, -2, -48, -60,
    2, -26, -17, -4, 8, 30, -22, -5,
    9, 0, 16, 18, -24, 8, 18, 18,
    9, -18, -6, 12, 29, 17, -31, -3,
    -22, -40, -55, 33, 24, -44, 42, -16,
    -28, 59, -48, -28, -3, -16, -34, 8,
    24, -6, 7, -11, 23, 13, 22, 28,
    0, -8, 20, 11, 30, 12, -49, -80,
    37, 15, -12, -8, 51, 9, -1, -16,
    -26, -55, 52, -7, -39, -9, 5, 8,
    34, -53, -2, 32, 1, 3, 16, -23,
    20, -13, -3, 17, 13, -11, 14, 7,
    37, 27, 25, 16, -1, 23, -2, 2,
    34, 68, 0, 10, -4, -25, 24, 2,
    -22, -20, 39, -18, 16, 9, -3, 1,
    4, 37, -24, -4, -1, 14, 11, 42,
    6, 49, 3, 17, -8, -33, -41, -12,
    51, -14, -3, 21, 41, -30, -39, -6,
    -2, -30, -15, 7, -18, 54, 54, 5,
    9, 9, 3, -13, -25, 39, 11, 41,
    -2, 2, -9, 0, 11, 2, -29, -8,
    -26, 6, -33, -8, -15, -8, -2, -11,
    31, -4, -2, -8, -1, 8, -21, 16,
    6, 3, 40, 25, 10, -13, -6, -1,
    -20, -24, -78, 18, 11, 26, 17, -15,
    45, -15, -11, -21, -16, -37, -14, 10,
    60, -19, -31, 4, -10, 26, 14, 14,
    -13, -11, -23, 5, 67, -15, -27, -4,
    -28, 22, -17, 2, 16, 3, 7, 55,
    -15, 26, -27, -8, -1, 0, -23, 0,
    13, 18, 3, 9, 4, -10, 8, 4,
    -22, -10, 2, 10, -28, -2, -7, 7,
    9, 16, 2, 20, 2, 14, -1, -25,
    -1, 41, 1, 10, -17, -22, 21, 15,
    -7, -19, 14, 16, 1, -41, 49, 53,
    17, -1, 1, -10, 4, 21, -1, 9,
    -2, 12, -5, -14, -12, 62, 1, -12,
    30, 19, -19, -5, 11, -11, 15, -2,
    -9, -7, 16, -27, 60, 10, -39, -33,
    10, 11, -22, 11, -11, 42, -4, -16,
    -14, 0, 53, -3, -10, 50, 3, 40,
    19, 11, -14, 66, -17, -31, 2, 28,
    -8, -1, 6, -9, 2, -20, -2, 8,
    6, 8, 27, 21, -34, -17, 3, 22,
    36, 7, 28, -9, 50, 18, 7, -12,
    2, 16, 3, 12, 30, -14, -10, 9,
    39, -8, -8, 19, 67, 16, -33, -4,
    1, 15, -24, -7, -32, -14, -39, -68,
    -66, 49, -19, -1, 16, -5, -37, 17,
    21, -25, -24, 26, 3, -1, -30, 18,
    12, 27, 26, -19, 23, -2, 10, -19,
    7, 30, 27, 2, -2, -11, 31, -6,
    12, -32, -10, 0, 6, -6, 2, -50,
    5, -16, 26, -10, -3, -6, -9, -42,
    7, 3, 1, 7, -11, -13, -9, -26,
    -54, -10, -2, 10, 11, 17, 22, 9,
    -24, -16, 10, 3, 0, -5, 6, -7,
    -31, 8, 9, 9, -31, 11, -9, 2,
    9, -17, 24, 12, -49, -12, -24, -5,
    13, 16, 4, -1, 13, 21, -8, -14,
    8, -49, 14, -13, 36, 12, 50, -17,
    -6, 5, -14, 12, 29, 43, 1, -25,
    5, -33, 5, -30, -7, -20, 4, 29,
    -9, -32, -2, -13, -19, -31, -50, 56,
    32, 10, 4, -2, -32, -2, 8, -2,
    22, -15, -53, 24, -24, -35, 12, 3,
    -13, 18, -6, -5, -4, -7, 1, -19,
    17, 4, -9, 6, 16, 17, -35, -19,
    -25, 34, -44, 21, 18, 0, -18, -16,
    -12, 16, 16, -56, -9, 9, -1, 5,
    -1, 2, -14, 3, 0, -10, -1, -15,
    -5, -18, -9, 6, -14, 20, 42, -19,
    -10, 3, -20, -2, 21, 27, -2, 19,
    -75, 16, 26, 38, -11, 20, 0, 7,
    30, -5, 19, 2, -2, -18, -20, 13,
    6, 7, -23, -7, -5, -6, 9, -23,
    27, -19, 56, -38, -15, 36, 20, 30,
    -55, -18, 26, -2, -23, -5, -13, -17,
    5, -30, 23, 16, 50, -23, -32, 8,
    11, -3, 8, -10, -1, 8, -4, 26,
    -18, 15, -40, 25, -24, 6, -23, 42,
    -10, -2, -16, -14, -12, 5, 26, -5,
    21, 4, -26, 17, -18, 18, -7, 13,
    2, 4, -3, -13, -7, 32, -12, 7,
    10, 24, 6, -3, -17, -15, -3, 8,
    -6, -17, 27, -8, 4, -3, -11, -56,
    -8, -5, 20, 50, -18, -26, 38, 2,
    -7, -32, 29, -11, 1, 0, 8, 31,
    63, -5, 9, -1, 33, 3, -6, -6,
    -8, 24, 30, 1, 19, 2, 1, -19,
    23, 4, 19, 13, 7, 3, 24, -5,
    1, -7, -8, -6, 7, 34, -30, 4,
    -5, -8, -30, -99, -31, -10, -62, -16,
    -1, -58, -13, -13, -17, 40, 8, 2,
    12, -10, -27, -29, -46, 6, -1, 14,
    -28, -32, 36, 16, -23, 18, 6, 4,
    2, 17, -14, 30, -38, 7, 14, 17,
    22, -14, -40, -35, 33, -11, -2, 10,
    21, 6, -15, -29, -8, 28, 19, 6,
    31, -7, 7, -15, -44, -27, -13, 5,
    12, 14, 34, -3, -23, 12, -18, -11,
    4, 38, 34, 33, -18, -2, 21, 37,
    -2, -14, 29, 40, -6, -39, -15, 42,
    7, -2, 15, -3, 32, -3, -6, -14,
    7, 19, -9, -49, -6, 20, -15, 16,
    -7, 121, 30, -38, 13, 1, 4, -2,
    7, -3, 8, 11, 5, 23, 9, 38,
    22, -7, -35, -8, -50, 0, 6, -10,
    8, 11, 51, 4, 6, 25, 32, -10,
    21, 12, -18, 16, -12, -30, 2, 9,
    7, -30, 10, 1, -8, 13, 5, -11,
    -30, 5, 8, -12, -3, -39, 35, 1,
    2, -22, -92, 45, -5, 13, 15, 12,
    -6, 81, 6, -3, 6, -7, -4, 29,
    14, 8, 8, 6, 9, -20, -29, 49,
    3, 15, -23, 59, 20, 15, 12, 63,
    -16, -15, 8, 1, -22, -48, -50, -29,
    -13, 58, 54, -4, -24, -1, -6, 20,
    6, -11, -5, -36, 25, -13, -5, 13,
    69, -15, -16, -10, -19, -13, 19, -56,
    48, 0, -24, 35, -9, -14, -38, -14,
    9, -50, 31, 43, -26, -37, 7, 27,
    -20, 41, 53, 27, -40, -1, 22, 25,
    -50, 6, -59, 1, -1, 2, -5, -5,
    32, 9, 34, 35, -5, 10, 10, -32,
    28, -25, -13, 48, 13, 32, 9, -4,
    0, 15, -63, -19, -1, 6, 10, -16,
    -13, -54, -52, -4, 11, -13, -7, 14,
    9, 21, 81, -26, 8, 30, -10, -33,
    63, -13, 106, -15, 14, 18, -6, -5,
    1, 26, -43, -39, -21, 30, -33, 0,
    -22, -14, 29, 40, 33, -6, -3, -7,
    -23, 3, 5, 25, 10, -6, 10, -44,
    53, -7, -71, -27, 17, 4, 71, 39,
    -13, -38, 31, -46, -2, -13, -23, 15,
    -23, 14, 34, 4, 38, -12, -10, -61,
    60, 13, -13, 12, 29, -16, 0, -12,
    -10, -18, 41, 5, -8, 20, -4, 0,
    5, 14, 2, -16, -49, 69, 12, 34,
    43, -22, -6, 26, -31, -1, 6, -3,
    -8, -3, 19, -57, -2, -1, -4, 15,
    -54, -26, -12, -9, 15, -7, 18, -9,
    -4, 9, -69, 14, -60, 37, -25, 27,
    2, 46, -18, 38, 36, 15, 0, 14,
    4, -16, -43, 10, -23, -106, -31, -12,
    62, -42, 47, 26, 36, 46, -28, 2,
    -25, 0, -23, -38, 16, -5, -21, -14,
    13, -18, -28, -69, -20, 13, 3, 20,
    -2, 30, -8, 9, -34, 2, -36, 32,
    -18, 52, 18, 11, -40, 0, -14, -30,
    67, -23, 64, 43, -7, 23, -39, -39,
    25, 2, 75, 26, -7, -11, -19, 1,
    -48, 5, -56, 29, 43, -9, 1, -35,
    17, 21, 2, -4, -26, 2, 3, 35,
    34, -30, -50, 51, -83, 20, 0, -36,
    -60, 14, -58, -46, 50, -19, -41, -16,
    -27, 18, -18, 33, 6, -10, -1, 35,
    -4, 77, -45, -30, -7, 6, -39, 3,
    63, 14, 32, -117, -10, 10, 55, -6,
    -49, -15, -11, -2, -56, 4, -34, 30,
    -2, 42, -61, -16, 43, 29, 39, -1,
    -30, -33, 6, -16, -12, -9, 12, 8,
    -51, -53, -22, 36, -14, -37, -37, -92,
    -8, -50, 2, -5, -14, 5, -5, 11,
    -1, -27, -6, -20, 33, 27, 14, 15,
    29, -48, 9, -50, 40, 22, -15, -25,
    8, -71, 122, 7, -32, -6, -28, 24,
    0, -37, 6, 17, 7, -2, 7, -22,
    35, 16, 35, 8, 5, 30, 55, -9,
    26, 28, -27, -9, 0, -12, -6, 29,
    19, -24, 53, -16, 2, -43, -22, -48,
    -1, -6, -29, -19, -48, 17, 17, 30,
    -12, 8, 27, 19, 38, -5, -33, 10,
    22, -14, 10, -20, 16, -32, 43, 49,
    -8, -25, -85, -21, 30, 12, 53, 12,
    -18, -5, -1, 6, -41, 12, -34, -61,
    -106, 108, -49, 10, 19, -35, 2, 9,
    73, 43, -23, -7, -3, -2, -24, 14,
    -16, 53, 42, -36, -35, -61, 7, -6,
    -14, -48, 33, 0, -20, 12, 34, -19,
    -3, -34, -36, 66, 3, 10, -1, -53,
    81, 10, -1, 42, 6, -33, -38, 19,
    82, 3, 2, -22, 36, -6, -9, -18,
    -98, -31, -16, -24, -6, 13, 0, 9,
    -25, -21, 17, -15, 16, 7, -19, -4,
    39, -5, 13, 70, -6, -11, -16, -10,
    -45, 23, 60, -2, 38, -13, -23, -30,
    -5, 17, 36, 10, 14, 13, 7, -23,
    19, -127, 1, -79, 6, 70, 35, 9,
    7, 6, -9, 33, 14, -13, 3, -25,
    -18, 51, -15, -14, -66, 101, -64, 56,
    -52, -28, -22, -36, -23, 23, -34, 21,
    -9, -2, -10, -38, 0, 9, -36, -4,
    46, -73, -48, 16, 0, -39, -16, -39,
    -23, 14, 11, 6, -20, -31, 17, -3,
    10, -1, 18, -9, -6, 1, -80, -5,
    13, 65, -30, 17, 8, 15, -16, -30,
    -3, -36, 2, -29, 1, -6, -5, 3,
    -20, 2, 17, 35, -55, 11, -25, -10,
    4, 4, -32, 32, -14, 16, 19, -9,
    -48, 38, -9, -45, 21, 19, 29, 19,
    -73, 11, 16, 27, 13, 0, 29, -34,
    -18, -26, 56, -24, -46, 32, -1, -36,
    -31, 78, -30, 39, 12, 21, -13, 29,
    -5, -22, 6, 59, -16, 28, 35, 15,
    21, 49, -33, 1, -13, -20, 16, -30,
    37, 71, 21, 0, 35, -23, -13, 10,
    83, -1, 22, -9, 4, 87, -9, 22,
    -26, 0, -9, 72, -22, 19, -11, 21,
    30, 21, -44, -1, 4, -23, 11, 7,
    8, 51, 22, -12, -34, -17, 19, -82,
    30, 25, -6, -75, 11, 39, -23, 7,
    28, 40, -42, -12, -19, 27, 18, 29,
    21, 1, 9, -21, 29, -17, -34, -95,
    -2, 2, 18, 23, -31, 9, 10, -30,
    -3, -46, 19, -10, 29, -56, 10, 21,
    51, -29, 4, -14, 14, 10, -14, -6,
    -25, 58, -23, 84, 7, 9, 29, -14,
    49, 32, 45, 8, 17, -23, 46, -13,
    5, -13, -26, -22, 48, 45, -44, -5,
    34, -38, -8, -104, -24, 21, -41, -3,
    -15, -33, -48, 5, -18, -18, 16, -11,
    -54, 20, 12, -60, -64, -24, -38, -19,
    -2, -7, 45, 48, -12, 0, -30, -17,
    -2, -29, -68, -12, -38, 30, 48, 6,
    -43, -14, 22, 39, 1, -26, -30, 1,
    35, 16, 18, 13, -14, 19, -16, -43,
    20, 2, 8, -23, -35, -7, 9, 6,
    33, 38, 42, -3, -35, 13, -44, 22,
    35, 49, -5, 48, -7, 2, 28, 49,
    71, -30, 38, 53, -16, -2, 28, -50,
    38, -17, 0, -17, 42, 8, 2, -18,
    13, -44, -18, -46, 3, 3, 14, -13,
    11, 118, 54, 72, 0, -8, -29, 46,
    27, 12, 46, -50, 35, -85, -72, 15,
    20, 2, -43, -60, -60, 15, 4, 41,
    38, 37, 49, -21, 56, -18, 29, 13,
    -13, -63, -5, 7, -4, 3, -15, 5,
    -5, 54, 47, 12, 8, 17, 19, 12,
    -24, -48, 7, -12, -6, -58, 3, -19,
    5, -27, -12, 48, 4, -14, 32, 16,
    1, -4, 38, -1, 20, -28, 37, -9,
    -19, -27, 9, 17, -1, -36, 23, -32,
    6, -2, -2, -23, -16, -2, 16, 4,
    -1, 54, -51, 25, 6, 13, -3, -24,
    4, 4, -28, 43, -35, -45, -30, -26,
    9, -5, 6, 9, -4, 13, 16, 9,
    -14, 19, -4, 14, 27, -29, 6, -18,
    28, 38, 19, -10, 18, -11, 12, 18,
    21, 6, -8, -26, -5, -3, -23, -46,
    3, 23, -14, 27, 24, 0, -33, -12,
    -8, 13, 13, -20, 22, -24, 1, 0,
    -17, 29, -12, 6, 31, 14, 4, 22,
    0, 6, 5, 10, -52, -43, -64, 32,
    1, -15, -5, 8, -14, 5, -7, 53,
    3, -5, 29, 9, 61, -15, -6, -49,
    -38, -18, -36, 3, 8, -19, -16, 32,
    -5, -15, 16, -22, -19, -25, -9, -25,
    -1, 0, -28, -1, 7, 39, -6, 2,
    -24, -17, 15, 23, -1, -1, 3, 10,
    -14, 22, -43, -23, -7, -6, 7, -25,
    -6, 1, -8, 29, -5, -30, 9, -2,
    -23, 26, -27, 17, 36, 4, -11, -41,
    -27, 0, -14, 20, 0, 14, -2, -20,
    36, 70, -30, -43, 4, -35, 9, -5,
    20, 57, 25, -9, 23, 35, 25, -67,
    13, -4, -15, 3, -33, 10, -15, 17,
    -6, 25, -2, 23, -30, -26, 1, 10,
    -1, -9, 14, 26, -34, -30, 7, -24,
    62, -10, 8, -7, -24, 29, -16, -29,
    -7, 3, 12, -17, -50, 25, -25, 2,
    20, 15, 12, -8, -17, -2, 27, -4,
    -22, -64, 10, -63, -31, -9, 10, 6,
    20, -4, 0, 23, -3, 1, -23, 9,
    -30, -24, 8, 14, -5, 5, 20, 35,
    -31, -9, 11, -13, 18, 0, 0, 43,
    -54, 10, 25, -10, -4, 20, -18, 5,
    -11, -13, -8, -3, -26, -41, -5, 7,
    -6, 4, -1, 1, -11, 28, 20, -18,
    7, 32, 20, -17, 9, 3, -24, 19,
    41, 49, 13, -3, 22, -14, 32, -21,
    -32, 17, 1, 16, -12, -16, -85, 32,
    30, -2, 20, -4, -6, -37, -43, 2,
    22, -4, 1, 2, -4, 10, 10, -5,
    -1, -30, -2, -8, -6, -20, 16, 3,
    -9, 8, 14, -59, 33, 35, 24, 14,
    -4, -3, 3, -1, -3, -21, -29, -19,
    11, -8, -10, -6, 7, 7, -2, 1,
    -23, -10, 56, 23, 14, 22, -13, -34,
    -42, -6, 11, 35, -43, -79, 33, 46,
    3, -36, 14, -19, 13, -21, -9, 9,
    6, -20, -30, -7, 8, -3, 39, -15,
    -12, 24, 9, 61, -7, 1, -6, -13,
    65, -15, 9, 2, -20, -24, 7, -6,
    -35, 15, -7, -18, -60, -16, 16, -6,
    -25, -8, 9, 9, 15, -27, 47, -19,
    1, -6, 39, -19, -10, 42, 6, -38,
    13, -22, -21, -14, -39, -82, 35, -39,
    18, -6, -42, 3, -31, -3, -24, 4,
    0, 10, -9, -9, 11, -31, -14, 21,
    -9, 12, 58, 13, -21, 10, 12, -6,
    -37, -11, 16, 7, -13, -4, -5, -16,
    19, -10, 8, -24, -18, 8, -39, 2,
    3, 4, -16, 26, 17, 9, -22, -11,
    -36, 8, 18, 13, -16, 22, 9, 4,
    8, 24, 1, -7, -17, 1, -61, -31,
    4, -2, -2, 20, -9, -26, 44, 7,
    16, -13, -2, 17, 20, 35, -8, -17,
    -21, -33, 13, -8, -6, 17, -19, 32,
    -4, -13, 9, -28, 41, 27, 12, -38,
    -6, 54, 0, -16, 2, 3, 19, -39,
    0, 12, 8, -31, -6, -12, 8, 0,
    22, 0, -41, -47, 15, -10, -7, 20,
    2, 6, -29, -42, 40, -9, 6, 35,
    32, -13, -12, 6, 5, -15, -3, 19,
    -11, 27, 8, -15, 19, -11, 10, 29,
    -39, -8, 22, 22, -2, -38, -43, 6,
    15, 2, -6, 2, -26, -23, -12, -10,
    -21, 27, 5, 6, 2, 5, -26, -21,
    -10, 10, -13, -2, 6, 10, 24, 18,
    12, 1, -9, -64, -24, -2, -4, -33,
    5, -4, -13, 14, -4, 23, -7, -16,
    -3, 26, 15, 15, 16, -19, 5, 8,
    -1, -26, 20, 20, -5, 11, -1, 3,
    -26, 8, -52, 1, -29, -14, -8, 8,
    0, -27, -12, -15, 50, 18, -18, 46,
    3, -5, 39, 18, -7, 9, 1, 15,
    -5, -32, 4, -28, 82, 12, 36, 14,
    11, -1, -5, 1, 32, 0, -25, 6,
    0, -19, -15, 6, -66, 43, 20, 13,
    -9, 19, -11, -19, 9, 14, 27, -14,
    -5, 8, -5, -29, -13, 6, 21, 22,
    11, -23, -24, -2, 1, -13, -18, 73,
    17, -49, -12, 13, 14, 51, -52, 33,
    -38, -17, 1, 49, 3, -44, 15, 0,
    -4, -12, -19, 4, -5, -16, -26, 45,
    -49, -20, -4, 2, -36, 54, -38, 13,
    11, 0, 0, -16, -58, 85, -30, 14,
    -28, 15, 12, 1, 20, -23, -2, -52,
    19, -11, 2, 36, 39, 11, -19, 39,
    -2, 59, -14, 13, -8, 4, 15, -15,
    5, 2, 10, 1, 29, -14, 56, 49,
    1, -4, 3, 8, 28, 30, 11, -11,
    -13, 1, -22, -6, -8, -4, -25, 3,
    0, 5, -24, 67, -21, 38, 10, 11,
    6, 32, 13, 4, 12, 33, 31, -15,
    11, 13, 8, 29, 7, -52, -26, 9,
    -38, -6, -18, 17, 22, 30, 33, -31,
    -24, 25, -2, 9, 3, -25, 8, 4,
    -10, 40, 7, -20, -30, -1, 16, -8,
    -19, -29, -8, -5, 3, -13, -27, 50,
    -5, -27, 15, 3, -17, -22, -6, -34,
    -79, 17, -21, 13, -10, 3, 6, -9,
    -23, 9, 7, 21, -6, 38, -2, -1,
    -11, 4, -11, -4, 18, -1, 2, -2,
    -11, -14, -5, 5, 7, -33, -1, -17,
    -16, 15, -16, 7, -16, -11, 3, -19,
    11, 22, 28, -14, 29, 6, 2, 18,
    2, -6, 2, -16, 18, -2, -43, 1,
    -1, 6, 16, 25, 0, 9, 42, 3,
    5, -7, -2, -36, -16, -15, -24, 26,
    2, 27, 12, 37, 42, -3, -31, -22,
    -26, -14, 0, 20, 3, 4, -13, 23,
    -11, 18, 13, -15, -14, -2, 9, 28,
    47, 49, -21, 35, 5, 17, -2, 6,
    14, 13, 11, 26, 30, -61, 30, 29,
    4, -4, 6, 1, -1, 15, -18, 9,
    -12, -7, -7, 10, -12, -16, 7, 14,
    22, -26, 69, -6, 11, 3, -12, -6,
    -8, -4, -22, 53, -15, 9, 10, 3,
    -1, -9, 3, 2, 15, -7, 16, -19,
    24, 9, 7, -14, -29, -11, -1, -35,
    -7, 1, -2, -29, -27, -38, 29, -26,
    26, 17, 23, -3, -53, -38, -15, 32,
    -9, 5, 10, 10, 12, 23, 12, 59,
    -49, -14, -4, -6, 7, -15, 13, -4,
    26, 11, -6, -18, 29, -3, 22, -14,
    -9, -21, -15, -26, -11, -19, 50, -63,
    4, 6, 26, 1, 20, -21, 0, 7,
    -16, -6, -8, 29, 2, -5, -17, -24,
    -3, -38, 27, 33, 6, 1, 60, -5,
    -16, 6, 43, -27, -43, 44, -62, -42,
    -17, 13, -29, 28, 6, -56, 0, 64,
    -6, -17, 4, 4, 30, -33, 44, -65,
    24, 11, -22, -29, 8, -20, -51, -8,
    -14, -34, 25, -8, -31, 6, -59, -21,
    10, 7, 27, 0, 20, 6, 53, 6,
    3, 13, 3, -8, -9, -4, 8, 4,
    25, -31, 24, -18, -37, -34, -51, 36,
    -18, 19, 9, -4, -14, -29, -6, 39,
    14, 5, -9, -2, 10, 34, 13, -37,
    6, -17, 16, -5, 6, -4, -15, 13,
    -6, -34, -23, -41, -41, -32, 0, -15,
    -11, 19, 25, 6, -1, -23, -6, -49,
    2, -14, -7, -6, 53, -24, 14, -6,
    -25, 30, -11, -1, 2, -5, -1, -22,
    -8, -25, -11, -4, 33, -19, -34, -7,
    15, 37, 15, 9, 13, 66, -22, -23,
    9, -14, 21, -3, 28, 46, 14, -12,
    2, -63, -44, 9, -7, 8, 2, 15,
    14, -98, 61, -19, -20, 40, 21, 19,
    18, -16, -14, 27, -28, 6, 2, 44,
    -6, 23, 39, 8, -28, -24, -12, -15,
    -17, 9, -24, -13, 0, 4, 18, 8,
    -41, -12, 29, -12, -1, 3, -9, 0,
    -14, -9, 3, -2, -46, -3, -42, 12,
    3, 6, 13, 18, -19, 2, 20, -30,
    -1, 29, 16, -20, 17, -12, -10, 9,
    -2, 48, -9, 3, 31, -22, -41, -18,
    -13, 12, 12, -8, 30, -29, -127, 2,
    -2, -10, -1, -7, 0, 9, 16, 9,
    -37, -2, 14, 12, 2, -10, -24, 2,
    11, 10, -25, -23, -18, -22, 32, -12,
    -12, 22, 19, 8, -7, 22, -10, -7,
    -11, -15, -34, -17, -7, -33, -2, 3,
    -3, -16, 28, -32, 8, 22, 6, 4,
    34, 6, 20, 23, 16, -15, -10, 7,
    -5, 14, -28, -8, -53, -10, 13, 62,
    -25, -10, 25, 10, -9, 12, -1, 12,
    -5, -4, 15, -21, 4, -23, -18, 7,
    15, 56, -53, -6, 37, 12, -13, 8,
    4, -13, 11, -10, 12, 0, -1, 58,
    -1, 11, -33, -16, -32, -4, 2, 26,
    0, 12, -11, 18, 23, 8, 10, -21,
    -6, -22, 6, -12, 11, -5, 30, -35,
    2, -26, 26, -1, -66, -59, 53, -88,
    -3, -8, -2, -23, 25, -12, -6, 32,
    -21, 0, 1, 23, -5, -4, 20, -5,
    -19, 17, -22, 10, -12, 0, -42, -34,
    -47, -4, 0, -8, 0, 16, -37, -75,
    92, -6, -3, -9, -18, -5, -25, 7,
    -17, -16, 3, 21, 63, 4, -5, 23,
    -12, -72, 2, 11, -47, -15, 20, -3,
    1, -27, -1, -12, -18, 54, -51, -57,
    10, 18, 18, 15, -22, 29, 5, 23,
    6, 2, 12, 14, -8, -10, -8, -16,
    -11, -19, 8, -14, 8, -15, -3, 14,
    8, -14, -4, -17, 34, -11, 33, -91,
    -13, -13, -5, -17, -4, 10, 28, 29,
    1, -8, -2, 24, 1, -7, -15, -11,
    20, -15, 0, 0, 15, -5, 8, 4,
    8, -4, 3, 2, 44, -20, 12, 35,
    16, -13, -6, 29, -5, -13, -12, 20,
    -6, 16, 9, 13, 7, -10, -12, 9,
    -13, 3, 44, -27, 11, -66, -68, 12,
    5, 13, -3, 29, 88, -19, -25, -37,
    13, -3, -9, 11, -26, -15, -10, -25,
    5, 21, 5, 18, -38, -12, -26, 4,
    -17, 13, -29, 46, -29, 0, 36, -30,
    -30, 11, 20, -19, -43, 17, 2, -78,
    19, -5, 8, -26, -15, -25, -14, -27,
    16, -16, -7, 25, 45, -2, -5, 30,
    -17, 55, -32, 30, -29, 21, -50, -17,
    24, 7, -9, -1, -19, -28, -51, 44,
    -15, -4, -13, 13, -36, 7, -7, 0,
    28, -51, -2, -11, 17, 11, 20, 15,
    12, 19, -27, -2, 8, -28, -39, -5,
    -18, 18, 1, -34, -33, 0, -19, 19,
    1, -2, -24, 23, 2, -17, -2, -6,
    -24, 14, -17, 61, 17, 21, -54, 15,
    -5, 53, 21, 3, 24, -24, 44, -8,
    -13, -6, 33, 50, -2, -16, 31, -45,
    10, -15, -17, 13, -14, 11, -31, 34,
    -8, 18, -33, -22, 16, 2, 4, 44,
    -30, 17, -20, 0, -10, 6, 17, -9,
    -24, -1, 14, -28, -22, 9, 45, -58,
    29, 6, -61, 4, 6, -18, 14, 28,
    0, 2, 20, -9, 7, 12, -13, 28,
    28, 9, 2, 4, 14, -1, 18, -9,
    14, -4, 19, 0, 8, 57, 17, 29,
    20, -9, -11, -6, 25, 4, -10, -32,
    -16, 4, -9, -2, -23, 6, -28, -2,
    -11, 39, -28, 47, -16, 33, 37, -5,
    22, -21, 10, 11, 76, -24, -23, -50,
    34, -9, -1, 13, 47, 41, 15, 14,
    3, -10, 16, 0, -24, 15, 18, -9,
    -26, 27, -38, -28, 30, -14, -29, 26,
    -20, -11, 6, 3, -9, 40, 29, 45,
    48, 8, -2, 8, -6, -7, -38, 13,
    -9, 9, 6, 10, 2, 13, 17, 16,
    -99, -15, 3, 40, 64, 18, -6, -6,
    -8, 31, -10, -3, 39, 25, -15, -17,
    -16, -6, 4, 18, -36, 6, -14, -30,
    -9, 36, 20, 23, 36, 0, 1, 18,
    8, -5, -22, 18, -19, -29, -8, -27,
    -11, 21, 17, -14, 22, 46, 24, -46,
    1, -10, 0, -6, -3, -12, 24, 7,
    20, 5, 0, -1, 30, -4, -2, 27,
    24, 29, -54, -46, 5, 9, 5, 7,
    28, 16, -24, -41, -6, -27, 20, -31,
    -7, -18, 9, -18, 24, 8, 32, 3,
    -30, -40, 5, -15, -16, 41, 3, -10,
    2, -3, -16, -11, -36, 5, 16, 12,
    11, 16, 5, 3, 41, 4, 51, 52,
    -9, -20, 20, -14, -4, 40, -8, 2,
    -6, -59, -13, 8, -23, 3, 1, 14,
    45, -22, 86, -14, 12, 5, -8, 31,
    -15, 1, -26, -14, -39, -23, -38, -35,
    -10, 2, -15, 38, -7, -8, -52, 20,
    -3, 1, 28, 33, -19, -6, -63, -30,
    -53, 8, 49, -63, 94, 35, 29, -84,
    -7, 31, 26, -13, 59, -31, 10, 35,
    -7, -5, 30, -23, 11, 43, 31, 23,
    -13, 18, -19, -12, 13, 42, -12, -9,
    25, -7, -3, 6, -13, 4, -21, -20,
    -10, -20, -27, -33, -1, -15, 92, 24,
    -10, 31, 25, -33, -30, -24, 31, 76,
    -28, -28, 20, 0, -20, 21, 18, 33,
    24, -94, 15, 29, 6, 38, 107, -24,
    -20, -16, -7, -27, -20, 52, 60, 51,
    1, 12, 13, -30, -4, -10, 43, -4,
    20, 28, -7, 19, 29, 19, 10, 11,
    86, -7, 58, -25, 7, 21, 20, -19,
    9, -11, 17, -18, -61, 8, 53, 26,
    -16, -31, -2, 0, 1, 0, -1, 27,
    31, 98, 25, -18, -11, -31, -15, 40,
    13, -13, 26, -37, 0, -33, -49, -1,
    -6, 10, -3, -69, -34, 23, 27, 55,
    17, 7, 18, -10, 9, 17, 39, -40,
    4, 19, -13, -23, -15, -14, -24, 39,
    -37, -77, 4, 35, -43, -56, -5, 6,
    40, -28, 2, 46, -61, -65, -18, 53,
    -10, 16, 10, -20, 55, -3, 7, 53,
    64, 16, -3, -10, -33, 63, 3, -45,
    -49, 47, -38, -21, -1, -45, -5, -25,
    -47, 21, -10, 19, 29, -29, 46, -36,
    62, 32, -15, 6, 8, 73, 42, -37,
    -38, 23, -9, 18, -69, 60, -18, 8,
    26, -21, -6, 47, 11, 22, 23, -39,
    8, -9, -11, 36, -55, -39, -55, -48,
    13, 19, -21, 13, 2, -1, -49, -23,
    11, -16, -1, 27, 24, 47, -59, -70,
    8, -16, 20, -7, 15, 35, -29, -15,
    2, -11, 31, 18, -30, 49, -63, -6,
    20, 4, 27, -20, -28, -17, 17, -25,
    8, 8, 4, -20, 15, 19, -15, -5,
    -47, 19, 29, -40, 3, 37, 48, -4,
    54, 27, 8, 74, -14, 69, 89, -31,
    -30, -3, 12, -15, -39, -30, 55, 0,
    -10, 0, 15, -30, -60, 23, -40, 39,
    -26, 5, -6, -4, -31, -21, 40, 8,
    12, 23, 79, 22, -37, -28, 41, -41,
    1, 28, -46, -26, -19, -24, -38, 11,
    12, 5, 35, 2, -13, 0, 27, -43,
    100, -81, -29, 17, 46, 51, -77, -29,
    38, 22, -7, -50, 8, 56, 55, 33,
    -2, -28, 6, 53, 6, 20, 1, -86,
    25, -14, 3, -22, -59, -43, -69, -13,
    4, 47, -27, -28, -13, -39, -46, -5,
    -5, 5, 22, -17, 18, 83, -30, 28,
    55, 10, 8, 12, -83, -46, 82, 46,
    16, 28, -8, -3, -36, -7, -38, -4,
    -45, 1, -68, 52, 61, 18, 41, -78,
    27, -20, 43, 43, -24, 9, 69, 50,
    -25, -13, -11, -28, 18, 3, 59, 52,
    9, -16, -25, -23, 12, 89, 32, 2,
    -16, 1, -36, -34, 21, 44, -10, -1,
    -90, -1, -23, -56, -36, 54, 12, 24,
    127, -31, 8, 17, 14, -6, -32, -28,
    -12, -33, 13, 9, -2, -3, -24, -1,
    23, -97, -47, -8, -74, -16, 0, 18,
    15, -25, 30, -21, 20, 43, -64, -20,
    -7, -11, 11, 13, 10, 11, -52, 20,
    13, 14, -18, 12, -29, 23, 18, -4,
    25, 9, 4, -27, -47, -14, -37, 26,
    -54, 22, 22, 0, -43, -12, 33, 89,
    -30, -36, -5, -42, 70, -75, 9, -1,
    9, 16, 3, -66, 45, -4, 0, -4,
    17, 9, 22, 107, -12, 4, 15, -35,
    94, -26, -21, 13, -49, -54, 13, 19,
    -11, -9, 5, -1, 32, -35, -29, -25,
    -10, -5, 3, 16, 66, -2, 0, -32,
    27, -15, 20, -70, -16, -66, -59, 43,
    -67, -62, -8, 2, 74, -3, 1, 12,
    47, -42, 0, 27, 36, 14, -19, 36,
    -5, -14, 12, 1, -52, 9, -56, 8,
    -24, -26, 11, 50, -59, -18, 30, -26,
    -27, 59, 40, 5, -62, 42, 22, -4,
    -12, -38, -12, 28, 13, -56, -14, -33,
    -13, -6, -26, -59, 46, -18, -13, 27,
    3, 61, -33, 42, -43, 11, -52, 9,
    15, -24, 23, -14, 27, -47, -41, 62,
    -28, 9, -32, 14, -6, -13, 1, -26,
    13, 29, 8, -18, -47, 15, -24, 13,
    45, -9, -15, -53, 14, -35, -19, -16,
    -17, -4, -6, -37, 20, -24, 9, -26,
    -9, 7, 19, -22, 5, 23, -19, -4,
    -28, 60, -2, -5, 97, -9, -58, 64,
    -66, 91, 3, 37, -11, 82, -16, -11,
    -8, 13, -12, 46, -26, 60, 50, -22,
    14, -21, 9, -6, 36, 5, 24, 49,
    4, -14, 25, -18, 28, 53, 18, -12,
    35, 50, 44, -10, -49, 67, 33, -79,
    31, 57, 36, -20, -58, -4, -28, -32,
    4, 2, -9, -14, -29, -35, 16, 18,
    -23, 3, 4, 27, -41, -37, 34, -59,
    81, -24, 16, 8, 4, -17, -37, 18,
    22, -36, -7, 21, -66, 46, 21, 51,
    74, 17, 23, -27, -10, 10, -6, -43,
    -27, -7, -3, -18, -31, 28, -19, 7,
    6, 27, 35, 70, -68, 14, 13, -13,
    30, 11, -28, 2, -18, -47, 29, -107,
    -12, -31, -7, 54, 10, 60, -34, 26,
    17, -24, -11, 5, -14, -71, -33, -23,
    -17, 13, -17, -93, 76, -4, -4, 38,
    -25, -49, -4, -8, 5, -7, -1, -8,
    23, 12, 15, -4, 68, -8, -24, 19,
    32, 20, -24, 13, -37, -23, 44, 11,
    -49, -54, 76, -7, 8, -27, 73, 46,
    -18, 24, 27, 29, 28, 43, 6, -22,
    -41, -22, 27, -16, -38, 25, -47, -12,
    -18, 12, 2, 18, 47, 16, -32, 2,
    58, -41, 28, 17, -14, -44, -50, 44,
    42, 26, -19, -49, -48, 0, -27, 44,
    -9, -23, -5, 33, -35, -4, 14, -61,
    1, 18, -20, 39, 26, 8, 48, -30,
    -3, 6, -46, 72, 10, -39, 31, -12,
    33, -62, -23, -5, -26, 26, 39, 60,
    26, 22, 16, -38, 30, 10, -25, -25,
    -2, -99, -37, -18, 17, 74, -20, -23,
    -22, -39, 12, -69, -49, 53, -20, -9,
    11, -19, 8, -11, 10, 47, 23, 32,
    -29, 12, -7, -21, 7, 26, -59, 6,
    -4, 13, -2, -8, -33, 35, -15, 51,
    -19, -15, -29, -21, 17, 15, 16, -6,
    -32, -30, 4, -2, 5, 23, 18, -11,
    -24, 2, -10, 1, 1, 1, -4, 7,
    9, 11, -13, -17, -16, -10, -4, 3,
    0, -2, -27, 19, -10, -5, 24, 11,
    3, 15, -7, 7, 11, -1, 0, 22,
    2, 11, 5, 18, 1, -3, 0, 0,
    -2, -4, 5, -10, 4, 4, -8, 9,
    -27, -11, 10, 11, -23, -2, 20, -8,
    27, 18, 12, -10, 36, 12, 19, -10,
    21, -3, 23, 0, 3, 4, -8, -1,
    7, -11, -13, 13, 10, 6, 19, 1,
    -2, -16, 0, 1, -8, -30, 3, 8,
    -6, -1, 23, 54, 18, -33, -14, 15,
    22, -13, -25, -11, -6, -9, 0, 2,
    -10, 7, 3, -13, 3, -15, 7, 19,
    -22, 47, -29, -25, 11, -48, -12, -3,
    2, 7, 10, 13, 15, -7, -7, -24,
    -25, 18, 3, 10, -5, 2, -4, -2,
    -14, 9, 4, 3, -23, 28, 20, -10,
    43, 15, 3, -44, 12, -9, -28, 30,
    19, -7, 8, -28, -15, 3, -24, -16,
    -40, 40, 21, -14, -3, -7, 0, -1,
    2, 12, 7, -7, 3, 2, 11, 4,
    11, 9, -15, -35, 25, -47, -44, -6,
    9, 20, -13, -21, 8, -5, 10, -37,
    33, -5, -6, 10, -1, 5, -5, -2,
    20, -14, -12, -4, 23, -4, 12, -21,
    -12, -16, -44, -4, 40, 9, 6, 14,
    -1, 17, -9, 18, -3, 32, -19, 18,
    -5, 9, -9, 9, -2, 1, 7, -5,
    -14, -12, -2, 22, -21, 2, 13, -37,
    33, 18, -33, -31, -16, -65, -5, 5,
    16, -9, 2, -3, -12, 14, -22, 26,
    2, 36, 8, -7, 4, 1, 0, 6,
    -7, -2, -4, -19, -15, 1, 11, 9,
    13, -30, -8, 5, 13, -13, 4, -4,
    10, 1, -4, 7, 34, -4, -1, -28,
    8, 5, 8, 8, 2, 3, 5, 1,
    -23, -9, 1, -3, -7, 34, 2, 10,
    35, 19, -16, -12, -34, -43, -22, 12,
    14, -21, 38, -29, -2, -9, -9, -5,
    8, -24, 22, 4, 0, -1, -1, -2,
    20, -14, -8, -18, 12, 37, 8, -10,
    -12, 39, -7, -24, 2, -4, -14, 8,
    5, 4, -15, -3, -1, -8, 19, -8,
    19, 3, 9, -27, 2, 2, 0, -1,
    -3, 16, -29, -21, -4, -21, -3, -19,
    -42, 5, 24, 19, 13, -6, 16, 17,
    -34, -30, 4, -4, 4, -14, -36, 21,
    -21, -15, -17, 21, -2, -4, 2, -6,
    10, -27, 12, 2, -5, -13, 7, 11,
    -1, 19, -41, 6, -9, 15, -4, 25,
    17, 22, -24, 19, 29, 28, -18, -7,
    26, -1, 6, 1, 0, 0, 3, -1,
    0, -4, -20, -6, -18, 23, -22, 14,
    -24, -2, -21, 44, 3, -2, 24, 18,
    -25, 30, -41, 7, 19, 24, -10, 15,
    7, 27, -24, 30, -3, -9, -1, 1,
    -9, -4, 17, -29, 31, -1, -23, 7,
    25, 21, 23, -12, 16, 4, 1, -2,
    -40, -7, 41, 2, -9, 13, 15, 13,
    3, 5, 0, 11, -1, -3, -3, -1,
    11, 12, -28, -10, 17, 8, -5, -13,
    20, -28, -10, 3, 12, 11, -16, -20,
    -20, -68, -15, 2, 36, -5, 13, -12,
    0, -10, 32, -8, 0, -4, 2, 0,
    -22, -38, -5, -45, -6, -6, 15, 2,
    7, 11, 8, 44, 4, -5, 22, 13,
    19, -5, 26, -6, 2, 25, 11, 9,
    -19, -24, -2, 27, 3, -1, -3, -3,
    -3, -9, 28, -16, -10, 17, -18, 12,
    -20, -23, -11, -14, -16, 0, 23, -32,
    -2, -12, 18, 12, 9, 1, -4, 8,
    4, -3, -6, -1, -3, 1, -1, 2,
    3, -17, 0, -14, 32, 11, -3, 5,
    34, 33, -51, 47, 22, -7, 12, -18,
    16, 51, -21, 20, 47, -1, -32, 18,
    4, -7, -3, 8, -3, 5, 8, 0,
    2, -14, 14, -33, 5, 14, 11, 4,
    -19, 14, 13, -31, 11, -15, 3, -11,
    -1, 23, 8, -7, 0, -12, 0, -15,
    3, 1, 12, 20, 1, 0, 3, 5,
    -7, -10, 18, 4, 12, 20, 35, 1,
    -37, -14, 19, 0, 10, -23, -9, -10,
    -26, -2, -48, 27, -15, -30, 16, -12,
    -12, -9, 15, 12, -7, -3, -4, 9,
    -28, 6, -27, 6, 4, 13, 18, -24,
    28, 31, -3, 20, 3, 25, -7, -35,
    1, 36, 30, 5, -3, -20, -7, 12,
    21, -6, -23, 15, -7, -3, 7, -1,
    -17, -16, 1, 28, 5, -1, -12, -9,
    -14, 7, -38, -4, -7, 2, 12, 26,
    0, -9, 22, -10, 23, -5, 7, -4,
    -13, 21, 11, 15, -1, -3, 2, 2,
    -37, -37, 8, 11, 2, -28, 2, 35,
    -24, -14, -29, -3, -7, -3, -44, 28,
    -27, 8, -1, 3, -6, -4, 11, -25,
    26, -6, -11, 4, -8, 5, 3, 1,
    -2, -5, 20, -11, -3, -5, -7, 29,
    8, -30, 14, -8, 21, -15, -26, 34,
    -5, 12, -12, 27, 18, -17, 5, 4,
    0, -11, -14, 13, -1, 2, 6, -4,
    -7, 24, -6, 24, -15, 1, -26, 20,
    0, 3, -21, -4, 12, 60, -16, 18,
    -42, -8, 22, 25, 14, 6, 19, -17,
    -23, -33, -8, 32, -2, 6, 5, 0,
    -5, 3, 21, -9, 19, 1, -7, 1,
    -7, -16, -31, 16, 2, -3, 0, -14,
    8, 12, 10, -26, 20, -8, -19, -29,
    -21, -7, 32, 5, 1, 3, 2, -3,
    -20, -2, 7, -15, 14, -29, -10, 10,
    -30, -48, -5, 16, -1, 28, -19, -3,
    0, -4, -32, 15, -36, 30, 12, -45,
    3, -21, -4, 16, 6, 3, 1, 3,
    -5, 7, 6, -7, -17, -21, 0, -2,
    2, 18, 10, -6, 1, -19, 0, 13,
    -19, -22, 8, 17, -16, 4, 9, 26,
    18, 8, 26, 18, 4, -1, -3, -5,
    16, 10, 2, -23, 12, -25, -7, -16,
    -19, -39, -8, -8, 39, -42, -19, -3,
    33, -27, -11, 29, 7, 10, 5, 12,
    -20, -12, 18, -38, 7, 0, 1, -4,
    -15, 19, -14, -10, -1, -63, -9, -8,
    -6, -3, 22, -1, -7, 5, 9, -2,
    -7, 1, -27, 2, -13, 6, -5, -30,
    2, 14, 8, 5, 0, -3, 0, 4,
    14, -26, -8, -13, -7, -6, 0, -5,
    -14, -5, -11, -1, -12, 25, -54, 65,
    -53, -9, -9, 50, 11, 2, 26, 60,
    -3, -6, -11, -27, 1, -5, 1, 8,
    -17, 4, -25, -30, -6, -6, 6, -4,
    -4, -15, -35, 52, -49, -19, 2, -22,
    52, 50, -15, 58, 27, 3, -8, -17,
    -23, -20, -32, -4, -1, -7, -1, 1,
    -12, 27, 9, -1, 34, 29, 9, 13,
    9, 9, 26, -32, -5, 10, -11, -8,
    12, -1, -50, 14, -10, 14, 17, -4,
    11, 5, -11, -31, 2, 0, -2, 5,
    -11, -15, 14, -2, 10, 9, 6, 6,
    18, 4, -19, 13, -5, -60, 1, 37,
    -27, 13, -36, 16, 3, 35, -40, -2,
    20, -26, -5, 47, -1, 3, -5, 2,
    16, 25, 10, 9, 7, -1, 4, -4,
    -10, -53, -31, -20, 1, -52, 43, 22,
    20, -2, 14, 5, -9, 14, -34, -10,
    -44, -28, -10, 0, -5, 3, 0, 0,
    -3, -23, -25, 15, -4, 40, -4, 2,
    11, -15, 0, -44, 2, -12, -19, -31,
    29, 0, -15, 28, -46, -19, 21, 15,
    -14, 25, -12, -15, 5, -1, -3, 2,
    11, 21, 3, -21, 11, 42, 12, -6,
    -19, 10, 0, -11, 22, 49, -31, -29,
    8, -42, 2, 43, -12, 43, 12, 2,
    11, 20, -8, -53, -1, -2, -1, 3,
    55, -23, 9, 25, 19, 2, 30, 8,
    -2, -11, -35, 11, 25, -17, 1, 57,
    2, 24, 13, -8, 3, -36, 23, -15,
    38, 24, -19, -7, -5, 2, 5, -3,
    -16, 5, -1, 34, -43, 4, 11, -5,
    29, -10, -26, -17, -40, -21, -50, 9,
    15, 19, -19, -29, -12, 26, 33, 1,
    6, 65, 30, -25, -2, 4, -1, 1,
    -13, -2, 17, 34, -16, -3, 27, -32,
    36, -20, -9, 17, -5, -25, -17, -31,
    16, -3, -10, 26, 11, 6, 14, 0,
    17, -15, -4, 6, 2, 0, 3, 5,
    9, -8, 1, 21, -5, 23, 6, 15,
    -25, -3, 5, 31, -58, 16, -19, 23,
    33, -9, -33, 5, 9, 15, 21, -14,
    -51, 37, 9, -2, -4, -4, -4, -4,
    64, -27, 3, -12, -9, -2, -2, -7,
    10, 23, -61, 10, 22, 23, -39, 52,
    9, 3, -1, 20, -44, 0, -5, -47,
    9, 7, -47, -20, 0, 7, 0, -3,
    -15, 13, -1, -15, 1, -18, -22, -8,
    -2, -17, 6, 28, 25, -40, 37, -50,
    -32, -13, -13, -57, -47, 4, 4, 1,
    -7, -20, 2, 80, 2, -2, 3, -2,
    24, -10, -7, -22, -14, 13, -5, -8,
    10, -19, -1, 29, -54, -8, -16, 15,
    -40, -7, 46, 17, -7, -15, 0, 21,
    34, 38, -39, -13, -4, -3, 0, -2,
    2, 20, -10, -9, -29, -9, 25, 10,
    4, -19, -14, 13, -18, 19, -21, -34,
    47, -14, 9, -37, 21, 26, -15, -22,
    7, 9, -8, 23, 4, -8, -7, 0,
    2, -3, 17, -11, 9, 10, -3, 14,
    21, 7, -29, -32, -30, -4, 31, -5,
    -34, 18, 5, 3, 4, 30, -54, -44,
    30, 6, -9, 8, 2, 0, 1, -3,
    -17, 2, -15, -4, -7, -7, 1, 16,
    22, 19, -23, 11, -26, 19, -25, 3,
    -15, 13, -18, -13, 22, 7, -48, -9,
    -17, -5, 11, 5, -5, -1, 2, 0,
    -4, -30, -7, -44, -15, -12, 9, 8,
    18, 19, 12, -16, -4, 10, 1, -23,
    -7, 15, 33, 13, -11, 13, -4, 11,
    -11, 4, 7, -12, 20, 1, 1, 0,
    -10, -22, 14, 15, 0, 25, -24, 29,
    -4, -7, 12, 17, -37, -15, -2, 18,
    25, 19, -11, -14, 9, -1, -3, -25,
    -11, -16, -11, 3, -2, 4, 0, -4,
    0, -5, 19, 0, 42, -6, 9, 30,
    12, 60, -32, -12, 26, -10, 14, -11,
    -3, 15, -27, -33, 11, 41, -16, 22,
    -12, -25, 3, -16, -3, 2, -2, -4,
    -31, -30, 7, 27, 0, 16, -14, -9,
    -12, 5, -5, -16, -25, 49, -18, 10,
    38, 8, -24, -95, 1, -10, -3, 23,
    23, 2, -44, 8, -2, 0, 2, -5,
    -24, 21, 2, 21, -4, 7, -14, 34,
    15, 25, -6, 10, -24, -24, 35, 13,
    35, -51, -13, 36, -34, -26, 27, -4,
    -26, 0, -13, 4, -1, 2, -5, 12,
    16, 20, 13, -7, 4, 2, -4, -30,
    -14, 32, -29, 37, 25, -8, 2, -13,
    3, -37, -35, -20, -1, 22, 22, 7,
    8, -36, 14, 23, -9, -5, 2, 0,
    1, -30, -3, -23, -5, 4, 29, -45,
    -5, -13, 2, 15, 12, -29, -13, -11,
    19, 35, 38, 63, 2, 10, 17, -28,
    24, -34, -3, -49, 6, -11, -7, 0,
    -14, 5, 49, 11, -28, 29, 3, 18,
    -13, 2, -5, -71, 27, -59, 30, 22,
    -13, 23, -5, -14, -28, -8, -20, -60,
    -28, 11, 21, -26, -9, 2, 1, 0,
    -11, -4, -7, 7, -15, 6, -16, 4,
    37, -7, 7, -16, -8, 9, 0, 43,
    -36, 4, -38, 15, -17, -23, 0, -17,
    7, -26, 14, 10, -4, 3, 6, 0,
    -32, -3, -16, 14, -19, 10, -7, 16,
    43, -14, -17, -9, -2, 20, 40, 13,
    -32, -26, 1, 22, 10, -17, -2, -35,
    23, 22, 6, 1, 0, 4, 1, 3,
    20, 26, -6, 14, 25, -12, -5, -28,
    -8, -24, -41, 10, 13, 32, 1, -4,
    15, -34, 17, 35, -10, -18, -14, 2,
    -3, -2, 17, -3, -1, 1, -5, -1,
    -11, -12, 21, -30, -10, -40, 7, -1,
    -4, -39, -45, -52, -19, 1, -1, 37,
    -58, -13, -21, -7, -1, 11, -3, -22,
    -1, -7, -5, -19, 3, 4, 2, 3,
    -5, 7, -37, -36, 26, -27, 0, 17,
    -2, 10, 9, 24, 32, 16, 25, 1,
    16, 2, -5, -35, 4, 6, -33, -34,
    -8, 2, -1, 1, 5, -1, -3, -3,
    3, 0, 11, 4, 2, -17, -7, 2,
    -18, 63, 15, -77, -23, -2, 27, 34,
    2, -28, 8, 29, -2, -17, 14, 23,
    -5, 96, 22, -10, 0, -2, 1, -6,
    38, 38, -13, -5, 3, -55, -12, 0,
    15, 28, 27, -15, 11, -88, -16, 4,
    10, 57, -26, 14, 7, -23, -9, -13,
    -17, -8, 10, 19, 2, -4, 0, 6,
    -7, -20, -6, -23, 27, 17, 14, 5,
    5, -3, 92, 4, -54, -7, 79, 21,
    4, 25, -8, -48, -20, -11, -34, 1,
    6, -8, -12, 3, -4, -4, -11, 5,
    -24, 18, 32, 12, -15, 6, 2, 37,
    -28, -58, -14, -53, 27, 5, -15, 34,
    -4, 11, 19, -48, -4, -25, 13, 21,
    44, -21, -17, -10, -1, 6, 5, 1,
    57, 72, 2, 35, -55, -9, -5, -40,
    41, -2, -15, 9, -48, 26, -5, -60,
    21, 6, -3, -25, -2, 14, -42, 6,
    0, -40, 7, 10, 6, 0, 8, 3,
    -12, 3, 61, 21, 46, 7, -21, -24,
    -2, -7, 51, -19, -26, -32, -76, 36,
    17, -10, 3, -13, 11, 1, 30, 99,
    8, -21, 49, -50, 3, 1, 14, -24,
    -7, 40, -39, -29, -13, 0, 12, 9,
    1, -80, 65, 15, 54, -37, -37, 57,
    3, -23, -85, 5, -20, 51, -5, 23,
    4, -47, 48, -14, -13, 9, 0, -2,
    22, -3, 44, -23, -26, 5, -83, -2,
    -78, 9, 5, -37, -18, -13, -2, -37,
    -24, -68, -5, 28, -17, 33, 41, 12,
    -6, 11, -32, -68, 22, -7, 3, 5,
    43, -26, -63, 24, 13, 21, 10, -3,
    14, -38, -4, -51, -38, -8, -57, 12,
    14, 12, 11, 5, -54, 31, 11, 2,
    -2, 5, -13, -20, -9, -21, 2, 3,
    -27, -42, 10, 27, -18, -31, 39, -106,
    22, -21, -18, -36, 21, 2, 42, -16,
    72, 20, -3, -35, 28, 6, 30, 1,
    -56, -22, 20, 1, -2, 4, 11, 1,
    -16, -33, 39, -26, 48, 55, 0, 52,
    15, -28, 27, -12, -53, 20, -29, -18,
    18, 16, -5, -7, -34, -27, 3, -13,
    20, -110, -28, -10, 0, 9, 0, -5,
    0, -3, 10, -43, -8, 113, 39, -10,
    -14, -31, -28, -18, -9, -21, 6, 30,
    -11, -6, 4, -44, -12, 61, 13, -10,
    10, 18, -41, -26, 5, 9, 45, -5,
    -19, 10, 16, 50, -39, 36, 3, -3,
    -57, 9, -22, 37, -38, -30, 37, -11,
    13, 11, -9, -60, 40, 34, 8, 25,
    6, 23, 19, -34, 0, -14, 0, -7,
    -13, -68, 25, -8, -24, 8, -49, -4,
    36, 21, 2, 22, 27, -16, -20, -26,
    -12, -1, -29, -26, -30, -2, 61, 20,
    18, 3, -4, 107, -33, 0, 7, 17,
    -20, 28, 5, -7, 12, 27, -48, 23,
    20, 13, 20, 54, 16, 10, -13, -49,
    27, -36, 3, 52, -71, 10, 25, 25,
    7, 88, 0, -62, 13, 7, 11, -14,
    -31, 53, -22, 5, -45, -33, 20, 104,
    27, -13, 74, 7, -27, 24, 0, -10,
    8, 72, -11, -20, -5, -30, -52, 10,
    -70, -7, 12, 18, -3, 8, 12, 1,
    43, -5, 2, -21, 31, 29, 0, 7,
    19, -5, -50, -7, 7, -4, -9, 25,
    -28, 18, -20, -37, 31, 18, -13, 17,
    -28, -8, 22, -10, -4, -11, -2, 10,
    14, 5, -30, 49, -25, 23, 19, 9,
    37, -23, -17, -17, -70, -27, -3, -46,
    25, -29, -56, -13, -3, 33, -18, 22,
    -38, 35, -9, 16, 5, 7, 20, 6,
    -36, -27, 63, 7, 127, -26, -25, 7,
    9, -17, 28, 17, 36, 11, -4, 16,
    29, 3, -22, -35, -27, 14, -7, 4,
    16, -17, -28, 4, 5, -8, -5, 1,
    -12, 49, 18, -32, -70, -21, 16, -14,
    32, -1, 20, 39, -17, 16, 29, 5,
    31, 26, 33, -7, 17, 49, 7, -6,
    81, 14, -39, -9, 127, -5, -1, -8,
    35, -25, 10, 18, -27, -58, -19, -51,
    22, 22, 23, -14, 29, 1, -1, 44,
    -11, 16, 3, -8, -3, -5, -12, -30,
    47, 5, -28, -19, -2, 7, -1, 0,
    -7, 4, 23, 43, -36, 9, -10, 8,
    -24, -39, 64, -10, -8, -20, -20, -24,
    57, -60, 87, -25, 3, 13, -30, 8,
    -35, 40, -30, 26, 1, 3, -8, -4,
    20, -46, -11, 28, 7, 6, 64, -6,
    33, 5, -21, 19, 22, 60, -74, 8,
    -3, 31, -46, 57, 1, 8, -10, -3,
    -17, -51, -54, -37, -29, -3, -2, -4,
    30, 28, -45, -28, -16, -2, -90, -11,
    -43, 16, -3, -3, -36, 66, 10, 20,
    -64, 82, 5, 19, -7, 9, -8, 10,
    29, -30, -4, 23, -4, -3, -12, 5,
    29, -1, -15, 1, -65, 30, -56, -40,
    -3, -58, 35, -45, -13, 18, 20, -32,
    39, -41, 15, 34, -22, 5, -6, 31,
    3, 55, 4, -46, -6, -13, -31, 2,
    17, 14, 8, 19, 7, -22, -2, -15,
    27, -26, 11, -12, -48, 87, -8, -27,
    28, 18, 9, -34, -16, 40, -25, 72,
    -35, 2, 42, 63, 12, -13, -10, 11,
    -18, 27, -63, 6, 10, -14, -8, -50,
    23, -12, 54, 34, 9, 6, -39, -14,
    63, -30, 39, 63, -14, 18, -24, 15,
    0, 17, -25, -29, 12, 11, -6, -5,
    -27, -13, -8, -2, -10, -28, -20, -11,
    44, -4, -21, 4, -87, -9, 58, 71,
    61, -4, 20, 19, 5, -25, -9, -4,
    -3, 7, -4, 1, -1, 8, 16, -6,
    -71, -18, -63, 32, 25, -3, 26, 42,
    15, 34, 36, 37, -9, 30, 1, -24,
    33, -1, 33, 83, 20, 6, 9, -28,
    16, 16, -3, 0, 1, 8, 9, -1,
    25, 36, -8, -25, 38, -16, 9, 12,
    -16, -25, -25, -2, 28, -18, 19, -2,
    12, 17, 3, -1, -13, -10, 25, -33,
    -48, -81, -21, -1, 12, -2, 20, 3,
    7, -3, 28, -12, 63, 3, -6, 32,
    2, -19, 59, -22, 34, 43, -1, 16,
    -78, -51, 23, -49, 11, 14, 13, 25,
    26, 11, -33, 4, 8, 9, 8, -15,
    62, 19, -7, -5, 48, -18, 6, -17,
    -19, -6, -43, 19, 49, 10, 8, 30,
    -26, 19, 20, -26, 12, 4, 15, -18,
    -13, 22, -13, -12, 6, -2, -6, 0,
    -10, -7, 34, 43, -24, 10, -9, -16,
    2, 127, 23, -14, -5, 3, 13, 61,
    11, 40, 51, 41, -25, -60, 0, -69,
    -6, 67, -44, 21, 3, -9, -4, 5,
    29, 53, 51, 19, -9, 66, 6, -22,
    -12, 2, -35, 2, 30, 21, 18, 23,
    -41, -24, 62, 17, 19, -14, 12, 10,
    4, -11, -13, 0, 13, 2, -6, 10,
    17, 29, -16, -4, 19, -52, 14, 7,
    11, 6, 12, 22, 4, -12, -18, -18,
    -16, 17, 11, 4, -11, -15, -21, -4,
    21, -13, -26, -6, 1, 10, -21, -17,
    -4, -1, -20, -46, 5, 1, 14, -103,
    23, -4, -5, -17, -1, -23, -39, 15,
    -5, -19, 50, -1, -6, -19, 5, 8,
    -22, 11, 4, -18, 16, -26, -8, -5,
    5, 5, -6, -3, -4, -50, 33, 7,
    18, -9, -33, 0, 26, -13, -16, -37,
    15, -12, 49, -32, -8, 16, -8, -14,
    -8, -5, 6, 27, -36, -14, 32, 11,
    -23, -6, 3, 8, -32, 37, 44, -43,
    -22, 43, -5, -12, -13, -31, 65, -9,
    -14, -22, -26, 0, -11, 3, 7, 43,
    11, 11, -37, 23, 18, -32, 14, -9,
    -26, -12, -6, 17, 18, -22, 8, 14,
    2, -20, -4, -7, 42, -6, -76, -28,
    -5, -15, 10, 1, 5, 27, 3, 38,
    41, -17, -27, -32, -14, -22, -12, 20,
    -18, 12, 24, 8, -1, 2, -2, 34,
    13, 37, 24, -14, -3, -4, 10, -3,
    14, 7, 13, -13, 9, 6, -40, 10,
    16, 1, 15, -89, 29, 9, -3, -13,
    13, 1, 3, -24, -12, 26, 10, -19,
    46, 11, -6, -12, -5, 19, -7, -20,
    7, -25, 6, -4, 5, 3, 10, -21,
    -22, 3, -34, 14, -13, -4, 14, -24,
    -44, -10, 8, 15, 7, 11, 6, -18,
    20, -1, 21, 19, 3, -15, -4, 25,
    -49, 1, -1, -4, -23, 2, 8, -31,
    -86, 7, 19, 54, 18, 13, -3, 0,
    -6, 13, -14, -2, 2, 2, -2, -34,
    -22, 10, 18, 13, -3, -20, 34, -17,
    -19, 48, -27, -23, -20, 26, 13, 22,
    -26, -4, -47, 0, 3, 13, 2, -4,
    -21, -22, -12, 2, -8, 46, -10, -24,
    -19, -7, -4, 16, 31, 62, -40, 37,
    -2, -20, -2, 31, -21, 4, 24, 11,
    -16, 39, 10, 36, 14, 10, -4, 3,
    5, 22, 6, 21, 22, -13, -2, -7,
    17, -2, 16, -25, 20, -21, 2, -27,
    -23, -14, 40, 32, 21, 6, -18, 21,
    27, -56, -23, -14, -3, 33, -9, 4,
    -3, 17, -14, -7, -6, 21, 17, 2,
    -25, 8, -21, 10, 10, -11, 2, 57,
    7, 15, 24, -9, -21, -23, 33, 2,
    36, 32, 32, 21, -25, 28, -13, -2,
    1, 3, 26, -3, 4, -51, 23, -14,
    11, -7, 37, -6, 29, 17, -26, 16,
    7, -52, -12, 2, -3, -51, 11, 21,
    16, 42, 45, -59, -21, 19, 16, 13,
    -15, -2, 12, 12, 6, -38, 15, 16,
    -5, 18, -39, -28, -6, 60, -27, 21,
    0, -1, -1, -22, 0, -11, -9, -32,
    -45, 12, -15, -11, 5, -24, -18, -28,
    -8, 21, -11, 5, 10, 48, -6, -2,
    -15, 23, 32, -4, -16, 44, 12, 1,
    -7, 25, -1, 9, 8, 3, -28, 9,
    -23, -2, 34, -12, -31, -43, 14, 12,
    3, 0, -26, -23, -13, 68, -24, 13,
    20, 1, -34, 5, -17, 21, -13, -26,
    -11, 29, -25, -11, -8, 3, 14, -16,
    -22, 48, -13, 24, -35, 13, 15, 7,
    -7, -6, 23, 1, -6, -4, 57, 16,
    -1, 10, 10, -10, -15, -35, 21, -4,
    11, -46, -3, -54, -7, -17, 19, 11,
    -7, -2, -11, 31, 14, -23, 28, -13,
    -11, -53, -41, 14, -2, -14, 36, 3,
    8, -5, 11, 13, 29, -7, 0, -3,
    -26, 6, 45, 22, 18, -8, -10, 3,
    -24, 34, -12, 17, 14, -18, 6, -2,
    29, -33, 25, -15, 16, -7, -29, 0,
    -6, 25, 17, 5, 8, -20, 9, 1,
    47, -5, -2, 24, -11, -8, -16, -2,
    67, -8, -4, -27, -25, 11, 2, 8,
    22, 12, 0, -2, 11, 5, 61, 39,
    -56, -50, 11, -16, -17, -34, -29, -17,
    30, 70, 2, -11, -20, 13, 19, -3,
    -24, 1, 2, -11, 20, -22, 1, 32,
    43, 2, 27, -7, -55, -8, -4, 22,
    -11, 27, -9, -39, 15, 11, -16, 17,
    -27, 34, 11, 14, -7, 17, -10, -38,
    -8, 7, 45, -36, -17, 58, 3, 31,
    -33, 0, 4, 28, 33, 5, -18, 29,
    22, 5, 18, -4, -5, 46, -20, 37,
    19, 7, 33, -25, 4, -9, -28, -9,
    21, 34, 35, -3, 10, 21, -14, -1,
    5, 11, -37, -7, -8, 1, -38, -8,
    -30, -8, 8, -34, 35, 33, -35, 8,
    12, 19, 14, -11, -17, -10, 10, 21,
    -1, 49, -5, -18, -22, 33, 9, 24,
    21, 5, 23, -30, 43, 53, -15, -19,
    -44, 17, 4, 13, -31, -3, -25, -49,
    -41, 3, 4, 3, 27, -17, -6, 13,
    15, 2, 24, -5, -9, 15, -3, 6,
    22, 20, 9, 1, -11, -19, 20, -48,
    9, 0, 38, 5, -54, 52, 19, 0,
    59, -9, 10, -19, -15, 3, 0, 11,
    -37, -22, -20, -18, -8, -2, -25, -41,
    5, -32, -21, -17, 11, -9, -14, 13,
    -6, -12, -44, 23, -1, -7, 48, -21,
    -22, -9, -17, 38, 12, 31, -11, 3,
    5, -17, -16, -7, 34, -46, 20, 35,
    9, -3, 15, 2, 2, -6, 18, 7,
    9, 21, -4, -15, -30, -54, -30, -3,
    25, -8, -48, -22, -12, -20, 11, 23,
    -31, 13, 43, -41, 12, 32, -31, 20,
    -19, 0, -5, 2, -50, -33, -9, 51,
    27, 15, -23, -26, 22, 11, 6, -12,
    46, -36, 14, -6, 0, 4, 29, 24,
    -1, -25, -5, -4, -20, -3, 11, 20,
    -24, -23, 5, -4, 27, 13, -13, 24,
    -23, 6, 43, 13, 37, -12, -7, 29,
    38, -21, 18, 2, -21, 10, -6, 24,
    -35, 30, 34, -29, 17, -27, -15, -25,
    1, 20, -7, 27, 38, -28, 19, -16,
    -10, 9, -48, -12, 37, 3, -11, 14,
    -13, 14, -14, 30, -5, -9, -17, 24,
    3, 19, 4, -55, 4, 0, 2, -5,
    -11, -21, 12, -5, -40, -29, -38, 49,
    34, -13, 8, -8, -34, 2, 25, -30,
    46, -20, -1, -29, 13, -12, 4, 13,
    -22, -49, -29, -33, -20, 29, 10, -3,
    1, 11, -2, 20, -6, 16, 2, -8,
    7, 2, -24, 18, -18, -23, 16, -4,
    -9, -6, -9, -6, 12, -3, -38, 34,
    39, -24, 13, -5, -31, 4, 20, -33,
    10, 2, 21, 23, -10, -2, 2, -20,
    -31, 6, -21, 47, 2, 7, 19, -10,
    -11, 28, -37, -26, -5, -13, -6, 10,
    15, -4, 55, 18, 15, 3, 24, 31,
    14, 0, -3, 30, 6, -13, 47, 15,
    6, 13, -58, -19, 7, -3, -8, -2,
    -28, -14, 36, -22, 27, 8, 17, 18,
    5, 52, 7, -14, -4, 9, 3, 12,
    1, 22, -7, -7, -16, -3, 26, 9,
    24, 1, -35, 11, 19, -37, 19, -33,
    35, -1, 32, -23, -9, 3, 13, 32,
    1, -5, -8, 41, -18, 1, 6, 11,
    -28, -19, 2, 6, -14, 19, 40, 15,
    -22, 21, 8, -6, -30, -3, -5, -25,
    -23, -39, -7, -1, -3, -17, 17, 3,
    2, -30, 1, -16, -12, -26, -21, -11,
    -42, 7, 3, -8, 43, 15, -28, 19,
    -39, -14, -31, -13, 60, -5, -14, -40,
    -27, -27, -75, 35, 0, 18, 4, 23,
    4, 20, -45, -43, -1, -27, 0, 42,
    8, 21, -9, -2, 15, 1, 15, -2,
    12, 55, 8, -20, 2, -32, -21, -4,
    -8, 43, -6, 17, 3, -9, 16, 19,
    5, -14, 21, -56, 12, 5, -55, 3,
    -4, 11, 2, 22, 4, -22, 22, -7,
    20, 9, -20, 12, 2, 5, -3, 26,
    -12, 28, 27, 7, -39, 0, 4, 26,
    53, 21, -10, 30, -28, -53, 18, -9,
    -33, 17, 15, 25, 71, -50, 3, 23,
    10, 51, 17, 32, -8, -30, -19, 41,
    -5, -28, -29, 34, -14, 2, 13, -20,
    -17, 18, 23, 21, -10, -27, 4, -5,
    -32, -20, -13, 11, -3, -39, -14, 2,
    5, -26, 4, -16, -7, 31, 20, 26,
    7, -5, -72, -10, -22, -9, 13, -9,
    -15, -25, -19, 4, -6, 12, -14, -12,
    -11, -15, 3, -6, -5, -13, 10, -20,
    4, -9, -27, 23, 23, 35, -16, 23,
    10, -6, 6, 2, 21, 16, 53, 3,
    -14, -1, 60, 22, 3, 4, 31, 18,
    9, 7, 8, 12, 28, -13, 41, -28,
    -5, -30, -21, 20, -4, -80, -52, -28,
    34, 9, 38, -2, 34, -25, -27, 7,
    38, -19, 4, 30, -35, 43, 8, 51,
    2, -12, -35, -10, 24, 31, -25, 41,
    2, 27, -9, -31, -13, -31, -5, 6,
    -10, 19, 4, -28, 7, -30, 3, -14,
    -10, 26, 21, 19, -26, 25, -17, -1,
    0, 12, 20, -6, 31, -28, 1, -37,
    14, 12, -15, -35, 3, 27, -39, -13,
    39, -73, 6, 26, -24, -19, -29, 4,
    17, 24, 56, -33, -37, -1, -10, 10,
    -6, -16, 15, -10, -38, 1, 0, 13,
    -16, -12, 1, 81, -8, 25, -31, 27,
    -20, 45, 32, -41, -22, -27, 6, -8,
    -19, 12, 53, 40, -4, -20, -19, -25,
    9, 13, 12, -6, -17, 7, 4, 6,
    -1, 20, 29, 32, -7, -8, 26, -2,
    -1, 16, -27, 25, 28, -3, 19, -29,
    11, 6, -21, 4, -28, -18, -16, -16,
    -9, -11, 0, -14, 20, 36, -31, 1,
    -4, -7, 14, 42, -13, 14, -16, -15,
    -22, -25, -9, 12, -10, 8, 26, 17,
    56, -12, 20, 12, -29, 32, 27, -18,
    11, -9, 3, 12, 38, -21, -7, -5,
    -39, -58, 35, -6, -31, 5, 0, 5,
    66, -34, -15, -25, -9, -34, 5, 6,
    -43, -52, 27, 10, -11, 21, -16, -16,
    -12, -36, -5, -4, -11, 29, -10, 17,
    14, -45, -2, -2, -6, -28, -5, 11,
    -20, 18, 40, 19, 13, 14, 9, 19,
    -35, 6, -40, 41, 4, 17, -1, 6,
    15, -29, 20, 61, 4, -3, -26, 22,
    -14, -5, 12, 30, 9, -9, 9, 8,
    22, 20, 0, 5, -23, -16, 9, -4,
    -22, 18, -16, 13, 25, -1, 5, 7,
    22, 12, 11, 13, 23, 19, 68, 2,
    -2, 39, -23, 23, -18, -27, -74, -25,
    4, 35, -18, 14, -10, 4, -11, -25,
    -15, 23, -46, 7, -1, 9, 45, 8,
    17, -18, -4, -13, 53, -34, 11, -57,
    32, 17, -27, 2, 13, 4, -25, 3,
    -4, 28, -10, 36, 16, 13, -16, 4,
    1, 28, 12, 35, -8, 18, 25, -9,
    -3, 19, 29, 27, -20, 16, -8, -5,
    20, -42, -52, 18, 26, 42, -8, 26,
    14, -26, 24, -27, 34, 0, -6, -6,
    -27, 3, -15, 4, -5, -10, 27, 11,
    5, -14, -16, 0, 4, 17, 22, -21,
    11, 5, 22, 20, 5, 62, -58, -36,
    -25, -16, 32, -11, 3, 6, 25, 3,
    15, 43, 6, -21, -9, -5, -32, 18,
    32, 19, 40, 15, 32, 39, 6, 20,
    -3, 31, -9, 11, 17, -69, -5, -36,
    -18, 50, 39, -15, 6, -4, -6, 5,
    -14, 49, 39, -24, 21, 5, -17, -16,
    -17, 24, 21, 7, 15, 18, 4, 19,
    0, -4, 31, -15, -9, 3, -18, -48,
    -2, -20, 51, 49, -24, -2, 6, 8,
    16, 22, -8, 8, 34, -19, -39, -53,
    2, -26, 1, -36, 20, -19, -29, 41,
    -32, 59, 6, 0, -6, 17, 43, -34,
    -11, -25, -30, 32, 30, 12, -17, 12,
    -5, -27, 35, -19, 36, -23, 19, 17,
    2, -2, -2, 2, 28, 21, -41, -15,
    26, -28, 35, -51, 44, -3, -12, -33,
    -7, 56, -43, 11, 7, -3, 13, 13,
    -14, 26, 6, 7, -4, -20, 1, 31,
    -10, -9, 18, 0, 4, -18, -23, 5,
    40, 58, 10, -13, 0, 17, 8, 7,
    13, 5, 10, -34, -15, -24, -14, 15,
    17, 1, -3, 4, 5, -41, 11, 19,
    14, -28, -9, -5, -7, -19, -39, -21,
    -2, 36, 22, 32, 41, -3, -27, 30,
    12, -30, 40, 3, -17, -7, 2, 16,
    3, 19, 29, -18, 14, -18, -37, 37,
    -26, -1, 12, 62, -45, -15, 9, -35,
    15, -4, -19, 24, 24, -3, 18, 13,
    48, 6, 0, 14, -12, 5, 2, -10,
    23, 1, -86, -5, 8, 9, -25, -2,
    -11, -13, -28, -19, -48, -13, -59, -24,
    42, 43, 28, -58, -20, -16, -3, -19,
    5, 16, -7, -6, -2, -4, -15, -6,
    25, -43, -13, 26, -13, 39, -5, 10,
    18, -2, -15, 14, -19, -5, -3, 9,
    49, -8, 82, 25, -17, 55, 5, 16,
    8, 11, -39, 8, -4, 21, -8, 7,
    45, 14, 22, 14, -13, -19, 35, -10,
    5, -20, -22, 31, -11, 14, -33, -27,
    3, -1, -11, -38, 12, -8, 74, -66,
    -29, -16, -2, 87, 15, 9, -41, -37,
    -11, 35, 53, 12, 2, 11, -18, -11,
    16, 21, 4, -18, -18, -13, -5, 20,
    -40, -5, 22, 93, 78, -59, 41, 55,
    -18, -59, -17, -7, 22, -9, 17, 26,
    39, 55, -4, 27, 46, -21, -28, 23,
    -59, 13, -9, -65, -74, 3, -10, 1,
    6, -21, 42, -5, -15, -50, -6, -11,
    12, -1, -29, -39, -27, -5, 17, 87,
    21, 16, 55, -59, -8, -36, -17, -18,
    -45, -32, 35, -26, 47, 46, -35, 89,
    28, 9, 1, 16, -6, -2, -58, -13,
    17, 57, -23, -43, 17, -51, 39, -24,
    59, 34, 26, 22, -31, -30, -39, 24,
    9, 28, 29, -8, 41, 44, 27, -37,
    0, -21, -6, -58, 91, 15, -37, -58,
    -1, 8, -13, 3, -28, -1, -48, -34,
    -16, 9, 25, 3, 20, -10, 52, 10,
    39, 19, -18, 36, -14, -11, -24, -18,
    -6, -28, -4, -2, -47, -24, -56, -32,
    42, -14, -7, 78, 17, -36, 38, 54,
    -54, -47, -1, 1, 3, -24, -21, 21,
    18, 1, -27, 4, 26, -52, -15, -64,
    -11, -1, -34, 48, -50, 62, 13, 39,
    -40, -11, 14, 25, 38, -13, 14, -1,
    -89, 36, 10, -4, -49, -8, 22, 1,
    39, -27, 7, -1, 22, -127, 20, 4,
    -51, -73, 39, -1, -42, 16, -60, 65,
    -20, 27, 50, 9, 41, -28, -74, 36,
    51, -24, -2, -65, 4, -10, -15, -59,
    -57, -22, 7, 8, -27, 55, -17, -20,
    23, -17, 42, 53, 12, 21, 49, 30,
    13, -27, -64, -16, -22, 58, 17, 4,
    -41, 38, -19, -5, 6, -16, -26, -8,
    -9, 12, -44, 34, 3, -5, -12, 16,
    18, -14, 42, -5, 39, 43, -7, 23,
    7, 2, 17, 33, 42, -3, 127, -20,
    2, 42, 63, -37, -2, 4, -21, 21,
    -4, -1, -2, -21, -3, -41, -13, -36,
    2, 25, -4, -71, -20, -109, -15, -70,
    1, -90, -39, -23, 7, 40, -7, -6,
    -49, -47, 51, 78, -10, -14, 13, 52,
    26, 35, 2, -13, 88, -58, -77, 26,
    2, 1, -17, -5, -14, 23, 17, 18,
    -49, -11, 5, -7, 30, -48, -12, -3,
    10, -22, -70, -36, 22, 56, 14, -66,
    -4, 38, 9, -29, 44, 20, 8, -21,
    -17, -33, 54, 9, -58, 15, -52, -36,
    27, -34, 0, 58, 29, -8, -19, 30,
    -32, 29, -3, 107, -82, -47, -27, 6,
    -6, -71, 17, 21, 16, 1, -5, -37,
    -28, 38, -19, -7, -56, 18, -42, 5,
    -26, 31, -15, 20, -16, 14, 18, 3,
    81, -81, 9, -31, -18, -10, -60, -32,
    55, 5, -13, -43, -86, -17, 31, 22,
    7, -2, -38, -38, 46, -24, 29, 8,
    -40, -89, 18, 21, -25, -7, 16, -22,
    -24, 11, -61, -53, 32, -4, -34, -27,
    -34, -24, -50, -79, 35, -19, -30, -3,
    52, -23, -2, -67, 0, -9, 51, -56,
    -66, -12, 57, 3, 25, -13, -35, 10,
    74, 4, -42, 27, 2, 27, 27, -9,
    9, -9, -40, -21, 82, -25, -17, -39,
    85, 27, -19, -1, -34, -41, 14, -18,
    -4, -17, 22, -22, 6, 3, 36, -16,
    9, 115, 6, -4, 4, 4, 2, 1,
    44, -61, 3, -13, -31, -16, 0, -15,
    -36, 19, -5, -20, -35, -59, 7, -42,
    -63, 27, 41, -25, -35, 34, 17, 45,
    -48, -58, -38, -10, -8, 24, 1, 16,
    -3, 4, 22, 56, -30, -29, -30, -23,
    41, 18, 10, -24, 10, -39, 37, 18,
    37, 24, -35, 54, -63, -14, 39, -1,
    -89, 12, -15, 11, 21, -7, 16, 42,
    -4, -5, 16, 20, -10, 8, 57, 38,
    21, -31, 64, -8, -24, 29, -70, 5,
    -23, -2, -49, -23, 36, -45, -43, -75,
    48, -13, -11, 11, -70, 1, -9, 2,
    24, -24, 31, 27, -49, -49, 19, -55,
    -25, -64, -46, -7, -11, 35, -29, 83,
    0, 22, -68, 28, -95, -2, 0, -16,
    12, -31, -16, -2, 4, 24, -1, 51,
    7, 0, 14, -53, 7, 45, -10, 22,
    18, 13, 40, 10, 46, 19, 38, 35,
    -23, 74, -26, -5, 64, -32, 19, -22,
    -28, 74, 58, 3, 3, -5, 21, 14,
    -16, 29, -18, -5, -8, 23, 49, 24,
    18, 13, -104, -25, 23, 91, -25, -37,
    -95, -3, -35, 34, -5, 28, 5, 27,
    47, -72, 9, -5, -10, -6, 19, -20,
    32, -22, 20, 25, -24, -26, -16, -15,
    -1, -109, 48, 11, -51, -75, -18, -70,
    -60, 1, 61, 12, -11, -16, 30, 20,
    66, -36, -66, -48, 5, 47, 5, 5,
    10, -3, -24, 4, 15, 79, -10, 59,
    -31, -45, -33, -61, -97, 22, 5, -127,
    45, 32, 14, 34, -18, -3, 14, -17,
    34, -51, -60, 15, -26, -9, -36, -22,
    72, -44, 28, 29, 12, 23, -5, 74,
    32, -22, 32, -24, 2, -49, 43, -48,
    -41, 51, 41, 27, 67, -25, -1, 8,
    20, -61, 27, -18, 3, -32, 15, 19,
    68, 1, -10, 10, 50, 43, -83, -5,
    57, 6, -29, 32, 20, -20, -3, -61,
    -15, 44, 30, 24, 31, 12, 7, 32,
    -65, -7, -14, 58, -23, 9, -43, 21,
    -8, -23, 44, 82, 58, 8, 46, 0,
    -52, -4, -26, 47, -97, -23, -14, -4,
    44, 48, 2, -58, 9, -27, 30, -4,
    48, -6, 63, -19, 61, -37, 5, 45,
    59, 3, -1, -30, -15, -16, -32, -51,
    23, -38, -26, -11, 36, -5, -58, 54,
    7, 29, 57, 42, -14, -16, 22, -93,
    -15, -44, -17, -35, -2, -12, -56, 61,
    -76, -23, 53, -28, 6, -11, 53, -17,
    -35, -64, 90, -54, 24, 17, 12, -38,
    90, -16, -10, 3, -18, 8, 29, 1,
    -52, -39, -22, 45, 22, 28, -5, 13,
    -41, -32, -20, -9, 15, 23, 3, -16,
    36, -22, -53, 99, -26, -59, -38, -61,
    -24, 22, 1, 22, -26, -1, -17, -9,
    -6, -2, 47, 73, 8, 28, 18, -35,
    6, 14, 10, 31, -59, 31, -50, -13,
    -33, 69, 0, -30, -64, 39, 8, 31,
    4, 1, 34, 1, -61, -14, 50, -30,
    5, 99, -86, -1, 3, -41, 7, -5,
    -31, -31, -9, 19, -18, -15, 50, 27,
    -23, -12, 5, 3, 18, -3, -30, -4,
    -12, -4, -14, 34, 15, 11, -1, -10,
    -42, 11, 20, -39, -12, 3, -16, 6,
    0, 1, -9, -13, 37, -37, -18, -20,
    -26, -34, -15, 10, -13, 12, 24, -5,
    29, 15, 5, -1, 28, 43, 20, -1,
    6, -56, 28, -20, -1, 12, 8, -11,
    -6, -1, -2, -12, 7, 1, 8, -45,
    26, -3, 14, -4, -11, 17, -18, 27,
    -14, -3, -19, 10, -4, -13, -13, 17,
    -34, -2, 36, 18, -25, -4, -18, 18,
    -4, 18, -22, 2, 13, 16, -33, 48,
    -14, 18, 2, -1, 0, 38, -38, -17,
    13, -1, -55, -19, -48, 25, -24, 2,
    34, 11, 1, -24, 11, -12, 3, 3,
    -10, 15, -1, -7, 10, -23, 18, 5,
    1, 32, 5, -1, -42, -11, -40, 28,
    -9, 14, -14, -7, 25, -25, 1, 16,
    23, 26, -16, 22, -1, -11, -18, 12,
    20, -20, -32, 23, -1, -14, 14, -15,
    6, -18, -3, 16, 29, 42, 36, 10,
    -6, 1, -17, 30, -5, 9, -27, -14,
    14, 19, 13, -76, 7, -1, 6, -2,
    1, 11, 0, 6, -32, -29, 35, -2,
    -9, -27, -19, -6, -27, -18, -8, 30,
    -14, -8, -2, 2, -18, -2, -43, 43,
    -11, -42, -8, 17, -2, 11, 3, -16,
    25, -1, 4, 12, 31, 15, -19, -17,
    -3, 19, -10, 15, 53, 60, -24, -11,
    -2, 15, 22, -9, -25, -27, 16, 8,
    -20, 6, 2, 14, -27, 3, 4, -45,
    -2, -33, 7, -7, 12, -4, -23, -36,
    6, 7, 4, 1, 11, -8, 52, -19,
    6, 12, 2, -8, -5, -14, 4, 6,
    8, 20, 43, -1, -14, 8, -10, -1,
    15, -28, -2, -15, 32, -11, -15, -18,
    -8, -6, 12, 23, -16, -13, 3, -29,
    -13, -12, 11, -6, -18, -25, 0, -1,
    10, -4, 2, -7, 21, 14, -8, 2,
    -13, -4, 1, 10, 28, -9, -19, -40,
    -29, -3, -11, 2, -16, -59, -5, 15,
    0, -6, 6, -8, -23, -7, 4, -3,
    -6, 40, 47, -6, -3, -5, -26, -17,
    12, -2, 13, -13, -32, 27, 37, 14,
    32, -1, 6, 19, 4, -27, 1, -41,
    -8, 19, 5, -20, -9, 4, 9, -8,
    14, 0, -13, -32, 9, 0, 1, -5,
    25, -22, -13, 7, -23, -2, 15, 34,
    11, 29, 19, -7, 20, -5, 2, 5,
    4, 8, 8, -3, -28, 4, 7, -44,
    2, 2, -2, 41, 19, -8, -1, -13,
    20, 7, -5, 8, 25, -16, -15, -26,
    40, 38, -1, 36, 27, -27, 28, -2,
    15, -13, -7, -11, 13, 20, 2, 15,
    -7, -22, -19, -25, -11, 14, 12, 0,
    -17, 11, 7, 6, 13, -24, 5, 13,
    35, -2, 22, 19, -40, -8, 14, -21,
    -4, 11, 21, 0, 13, 31, 67, -16,
    -26, -33, -13, -5, -7, -26, 7, 18,
    7, 7, 3, -14, -5, 6, 18, -32,
    1, -8, -19, -25, -30, -20, -1, 0,
    13, 1, 11, 20, 21, -43, 24, 15,
    5, -3, 13, -10, 5, 2, 24, -6,
    32, 18, -3, -3, 38, 4, -56, -2,
    -6, 7, 15, 1, -20, -19, -24, 5,
    4, 30, 11, 1, 13, -24, 24, 20,
    -28, 33, 30, 12, 21, -33, -3, -5,
    11, 42, 1, -11, -7, -22, 14, 24,
    -15, 8, -3, -13, 6, -48, 23, 31,
    4, 6, -29, 15, 2, 0, -15, 37,
    34, 37, 17, 30, -12, 3, -15, 13,
    3, -15, 11, -3, 16, 24, -3, -25,
    3, -19, -1, -25, -18, 32, -20, -22,
    -7, 9, 0, 8, 5, -14, -6, 25,
    7, -22, 18, 6, 0, 12, -28, -7,
    0, 21, -26, 9, 1, -14, -4, -24,
    -1, -43, 13, -41, 17, -21, -9, -3,
    -18, -3, -8, 18, 2, -14, 21, 11,
    12, -10, 13, -44, 18, 5, -4, -10,
    -22, -12, 3, 8, -33, -11, -14, -2,
    3, -5, 4, -5, -25, -3, -7, 18,
    7, -9, -5, 6, 12, 26, 2, -18,
    8, -9, 30, 13, -13, 1, -14, 12,
    -8, -11, 31, 4, -28, -24, 11, -23,
    -21, 12, -2, 5, 14, 20, -7, -9,
    -23, -21, 24, 11, 20, -27, 2, -8,
    3, 37, -15, 6, -7, -16, 23, -15,
    6, 2, -19, -36, -14, -29, 3, 2,
    -1, 6, -30, -2, 5, 14, 15, 24,
    0, -13, 23, -19, -2, 7, 2, -27,
    -17, -5, 28, -29, -12, -6, -15, -2,
    -28, -17, 43, -2, -2, -42, 6, -7,
    17, -12, -14, -23, 60, 18, -13, 27,
    -26, 8, -7, -12, 7, 44, -57, -26,
    9, -2, 26, -31, -18, -19, -18, 43,
    15, 3, 11, -8, -12, -15, -2, 25,
    -36, 29, 33, -28, -6, 28, -18, 6,
    8, -10, 26, 6, -2, 10, 1, -46,
    12, -8, -29, 22, -33, 19, 10, 13,
    -5, 8, -5, -7, 10, 45, -16, 45,
    -1, -13, -1, -6, 8, 27, 7, 22,
    -17, 0, -26, -3, 16, 7, -26, -24,
    3, -28, 7, -9, -19, -22, -3, 0,
    -7, 0, -20, 21, 6, -14, -6, -63,
    7, -37, 4, -21, 8, -32, -15, 42,
    -8, 6, 0, 11, -6, 4, -34, 24,
    -2, -30, -9, -4, -4, 30, 6, -13,
    -8, 7, 12, 4, -23, 7, 5, -9,
    -11, 6, 4, 22, -21, 52, 0, 27,
    -12, 6, -7, 19, 9, -38, 6, 6,
    -4, 16, -3, 9, -15, -18, -1, -20,
    11, -8, 5, -3, -11, 5, 20, -54,
    28, -4, 10, 16, -58, 51, 0, -3,
    0, -11, -14, 14, -36, -20, -20, 18,
    4, -28, 23, -1, -12, 4, -2, -22,
    -3, 5, 21, 10, 12, -5, 15, -3,
    10, -7, 19, 14, 1, 53, -21, 47,
    -10, 12, -7, 9, -6, 1, -14, 9,
    -34, -14, -17, 4, 28, -7, -15, -22,
    3, -4, -6, 20, 30, -7, -23, -40,
    27, -4, 23, 6, -58, 27, 21, -43,
    1, -14, 13, 10, 2, 9, -2, -48,
    -23, -11, -18, 6, 3, -15, -15, 4,
    -3, -2, -2, 4, -22, 6, -31, 28,
    -1, -9, 15, 0, 10, 10, -6, 18,
    19, -1, 1, -3, 0, -6, -15, -8,
    5, 10, 2, -7, 8, 9, -19, 0,
    -12, -18, -6, -20, -1, 5, -2, -16,
    3, -3, -29, 46, 40, -7, 44, -57,
    -16, -7, -22, 25, 52, -9, -23, -26,
    -6, -7, 21, -4, -14, 8, -31, -3,
    11, 16, -37, -9, 16, -37, 32, 59,
    4, 2, -1, -2, -53, -7, -13, 14,
    -2, 9, -10, 13, -21, -15, 7, -12,
    -18, 9, 35, -43, 5, 9, -1, -4,
    -35, 9, 2, 22, -21, 17, -16, -36,
    -29, -25, 37, 3, 24, 46, 27, -33,
    -21, 11, -2, 19, 22, -15, -11, -67,
    24, 12, -24, -8, 0, 1, 0, -6,
    -5, -14, 26, -3, 13, 18, -5, 22,
    -11, -35, -6, -29, -1, -24, -38, -9,
    0, 0, -29, -25, 25, -58, 19, -1,
    39, -27, 14, 18, -1, -11, -15, -9,
    12, 30, -8, -12, 20, 31, 16, 27,
    -19, 8, -12, -18, 10, -4, 60, 30,
    7, -3, 10, -3, -18, -61, 33, -14,
    53, -13, 25, 1, 22, 8, 42, -15,
    -36, -23, -65, -13, 12, -11, -19, -20,
    5, 2, 54, 18, -14, 0, -12, 35,
    -6, 9, 13, 22, -40, 3, 4, 51,
    -18, -22, 54, -3, -31, 32, -17, -11,
    5, 13, 23, -5, 14, 3, 33, -19,
    -4, 39, -8, 4, -10, 42, -1, 27,
    -49, -2, -2, 1, -39, 25, -8, -19,
    -23, 12, 4, -8, 15, 30, 8, -2,
    -1, 41, -4, 5, 54, 2, -37, -10,
    47, 5, 2, 5, 29, 25, 0, -4,
    -5, 28, 22, -14, 52, -60, 13, -8,
    24, -81, -12, -15, -31, 46, 0, -38,
    -9, -35, -32, 1, 0, 54, -12, -11,
    0, -25, -24, 5, 16, 55, 18, -1,
    -2, 7, -8, -11, 3, -1, -22, 19,
    3, -7, 32, -6, -20, -6, -14, 1,
    6, -11, -9, 22, 23, -12, 21, -17,
    3, -5, -3, 8, -17, -16, -7, -13,
    -12, -6, 7, 6, 40, -32, -14, 36,
    2, -11, -28, 15, 15, -6, -15, 9,
    -11, -19, -13, 14, 16, -10, 1, -22,
    9, -18, -36, 1, 8, 2, 0, -1,
    -3, 2, 11, -18, -39, -2, -20, -18,
    -22, 7, 56, -13, 3, -13, 28, -33,
    -12, -9, 15, 37, -27, 46, -49, -12,
    17, 3, -10, -2, 2, 3, 38, -51,
    -1, 17, -8, -2, -15, 5, -2, -16,
    23, 9, -33, -23, 10, -9, 23, 11,
    51, -25, -24, -6, -10, -8, 0, 37,
    -26, 25, 9, -14, 2, -10, 0, -5,
    -4, -2, 2, 9, -35, -24, 42, 39,
    18, 9, 23, 19, 38, 6, -8, -34,
    -36, 11, -5, 13, 17, 25, -25, -33,
    -8, -35, 26, 5, 75, -27, -53, 1,
    -13, -20, 10, -13, 32, -28, 6, -2,
    -47, 25, -53, -46, -47, 1, 11, 25,
    6, -24, 27, -4, 0, 0, -5, 39,
    35, -4, 18, 2, -22, 5, 7, 18,
    16, -9, 24, 7, -7, 14, -62, 32,
    12, -11, -31, 42, 1, -51, 24, -11,
    10, -14, 4, 12, 22, -7, 33, -51,
    -23, -40, -5, 14, -36, -7, -20, 39,
    5, -8, 22, 10, -6, -44, 7, -17,
    19, -1, 3, -17, 12, 12, 10, -28,
    5, 27, -20, -36, 11, 5, -63, 2,
    7, 9, -26, 11, 10, -4, 29, 4,
    -4, 6, 0, -3, 42, 22, -16, 11,
    -18, -14, -22, -2, 18, 3, 4, 0,
    73, 56, 15, -9, -34, 30, 9, 16,
    7, -5, 0, 0, -10, -22, 9, -3,
    -4, 2, -13, -9, 14, 25, 17, -6,
    7, 2, -22, 1, -2, 22, -10, 3,
    7, 10, 29, 26, 5, -22, 4, 19,
    -15, 6, -3, -9, 25, 8, 20, 2,
    0, 14, -13, -6, -37, 38, 11, 6,
    9, 10, -1, 9, 30, 17, -2, 19,
    -9, 2, 7, 2, 10, 4, 15, -19,
    -5, 20, -13, -19, -57, -42, -16, 33,
    -19, 27, 10, 2, 61, -31, 6, -44,
    -43, 19, 7, 9, -16, 22, -38, -4,
    36, -8, 5, -1, -7, -17, 4, -53,
    -65, 18, -19, 22, 22, -16, 4, 46,
    4, -2, -10, -51, 12, 7, 23, -18,
    2, -4, -15, 50, -28, 26, 26, -13,
    -1, -31, 10, -30, -20, -39, -12, 0,
    25, -33, 3, 8, -46, 29, 6, -4,
    8, -31, 6, 12, 17, -7, -40, -19,
    14, 11, 49, -9, 0, -14, 21, -3,
    12, -44, 2, -33, -43, -11, -3, 15,
    5, 45, -23, -5, 9, -49, 14, -34,
    4, -42, -18, -23, -3, 30, 4, 49,
    -4, 0, -14, -4, 3, 7, -1, -35,
    9, 2, 11, 69, -4, -7, 49, -1,
    -11, 19, 52, 17, 22, 15, -15, -12,
    3, 10, 21, 5, 7, -65, -7, 13,
    -17, 34, 1, -40, -27, -7, 14, 24,
    31, -39, 35, -20, 2, -7, 9, 32,
    -8, 10, 13, -25, 23, 4, 4, -4,
    10, 6, 10, 2, 60, -15, 49, 67,
    0, -9, 47, -30, -14, 4, 13, 6,
    -5, -26, 42, 17, 13, -5, -6, 38,
    -31, -15, 11, -1, 35, 6, 57, -18,
    -19, -10, 12, -14, 44, -7, -4, -18,
    14, 15, -45, -17, -21, 10, -11, 5,
    4, -21, -21, 33, 4, 9, -37, -63,
    11, -9, -4, -6, 13, 16, 18, 80,
    5, -28, 15, 23, -9, 26, 9, -2,
    -8, -7, 16, -3, -39, -7, 9, -11,
    29, -31, 2, 10, 6, 16, 0, -20,
    0, 22, 16, 13, -34, 38, 11, 6,
    -23, 4, 3, 40, -27, 69, -9, -16,
    -53, 6, 14, -14, -4, 3, 5, -14,
    10, 13, 54, 13, -1, 4, 35, -11,
    13, 0, -23, 5, -7, -5, 29, 26,
    -12, 7, -21, -6, 14, 4, -27, -39,
    2, -9, -5, -8, -6, 23, -11, 4,
    13, 2, -1, -43, -30, 10, -3, -28,
    11, -25, -23, 4, 1, 1, 47, 65,
    5, 5, 32, 3, 9, -6, 49, -3,
    30, -19, -38, -5, 10, 21, 22, -21,
    13, -35, 28, -30, 0, 7, -52, -18,
    19, 14, 29, -21, 8, -6, 3, 23,
    -21, 15, -1, 12, 24, 43, 80, 47,
    10, 11, 19, -27, -37, -22, 20, -4,
    20, 40, -15, -13, 17, 6, -3, -47,
    2, -60, -12, -9, -47, -64, 67, 13,
    16, -20, 20, 1, -16, -13, 9, -31,
    -20, 0, -24, -12, 43, -17, 3, 13,
    13, 18, 0, -1, 26, 4, 25, 7,
    -10, 12, 39, -5, -18, -38, -20, 12,
    -14, -2, -20, -40, 31, 0, -7, 8,
    -32, 3, -9, 43, 8, 6, -27, -23,
    45, 14, 14, 31, 22, -41, -47, -35,
    -69, -60, 4, -18, 55, -17, 15, 64,
    -62, -34, 20, 24, 8, 26, 20, -33,
    -2, 46, -10, 8, -12, 22, -1, -10,
    47, -1, -18, 41, 48, 21, 23, 41,
    -17, -32, -53, 76, 71, -20, -66, 4,
    -11, -2, -31, 8, 13, -24, 1, 32,
    34, 17, -3, 14, 12, 36, 6, 13,
    6, -1, -18, -3, 11, 10, 14, -30,
    40, 63, 5, 54, 27, -1, -52, 95,
    14, -21, -22, -16, 23, -21, 32, 73,
    12, 20, 47, -11, 6, 2, -12, 60,
    11, 5, 15, -38, 12, 12, 12, -42,
    -9, 12, 6, 72, 70, 31, 3, -25,
    24, -4, -7, -20, -7, -60, -19, 12,
    31, -63, -1, 45, 54, -12, 8, -36,
    -24, 33, 49, -28, 13, 26, -27, 14,
    13, 34, -36, 40, 31, 18, 16, 25,
    2, 4, 54, -31, -34, -20, -21, -19,
    34, 27, 25, -15, 40, -48, -21, 47,
    9, 16, 6, -12, -28, 48, -127, 17,
    37, -25, -15, 17, -9, -43, 22, 40,
    -13, -8, -9, -5, 7, 20, 8, 44,
    47, 44, -2, -28, 9, 33, 12, -57,
    -12, 19, 0, -25, -3, -38, -24, 89,
    63, 21, 45, -8, -62, -67, 8, -45,
    -7, -24, 53, -81, -57, -21, 21, 14,
    17, 26, 16, 12, 4, -15, -29, 22,
    -40, 5, -19, 35, -37, 79, 3, 113,
    -17, -30, 13, 26, 24, -88, 19, 24,
    6, -78, -9, 11, -5, -24, -28, -1,
    9, 1, -57, 16, -6, 41, -9, 0,
    57, -39, 25, -17, 33, -84, 47, -2,
    -35, -9, -13, -22, 22, 15, -14, -8,
    -17, -10, 33, -9, 47, -56, -34, 37,
    -37, -28, -85, -4, 6, -21, 36, -6,
    35, -9, 7, 6, 54, 18, 2, -8,
    -18, 57, -54, 29, -6, 75, 58, 44,
    18, 18, 21, -18, -28, 12, -1, -49,
    -13, -32, 3, 7, -75, 52, -29, 24,
    16, -24, -3, 7, 60, -8, -69, -4,
    -27, 20, 18, -6, -14, 6, 44, 24,
    42, 2, 16, 28, -39, 35, 31, 3,
    10, 6, -8, -1, 19, -10, -23, 5,
    0, -3, 10, -14, 42, 4, -5, 33,
    -18, -41, -8, -7, 4, 70, -24, -104,
    22, -6, 16, 10, 32, 1, 2, -111,
    -29, -29, 2, -39, -26, 12, 12, 65,
    2, 13, -18, -28, 3, 32, -31, -23,
    -47, -32, -50, -48, 8, -42, -85, 30,
    16, 40, 38, -51, -56, 28, 40, 60,
    -30, 17, 26, 53, 80, 49, -32, -15,
    15, -10, -13, 26, -37, -34, 33, 18,
    -52, 12, -37, 0, 19, 33, -20, -2,
    -19, -1, 40, -10, 36, 7, -33, -58,
    14, 12, 30, -3, -22, -28, 0, -3,
    30, -23, -25, -3, 4, -31, -6, 1,
    -44, -4, -3, 29, -47, 20, -1, 23,
    7, 12, 0, -1, -20, 39, 13, -32,
    44, -24, -15, 2, 70, -2, -13, 38,
    44, -2, 53, 26, -112, 35, -28, -44,
    24, 3, -1, -7, 2, 77, -32, 15,
    33, -7, 3, 17, 50, -21, 22, 31,
    -35, 1, 19, 3, -42, 34, 41, -14,
    -23, -40, -7, -8, -11, 50, -2, 21,
    25, -25, -15, -24, 23, 15, 1, 39,
    -23, 26, -10, -3, 62, 67, 8, 23,
    37, -11, -15, 20, -8, -6, 3, 47,
    -41, 10, -22, -44, -18, 25, 6, -10,
    -5, -19, -47, -10, 89, -51, 37, -11,
    18, 7, -8, 3, -10, 42, -21, -26,
    4, 28, -47, 18, 5, 10, -3, -43,
    -21, 26, 9, -16, -8, -20, -27, 6,
    -1, 9, 49, 18, 4, -8, 31, -5,
    49, 48, 23, -40, -17, 73, -27, 29,
    -32, 3, -55, 0, 40, -51, 35, -25,
    -29, 26, -7, -1, -46, -72, -89, -34,
    66, 15, 0, -13, -56, 4, 4, 53,
    -12, -31, 21, -45, 32, 0, 113, 2,
    31, -20, -75, -53, -6, 7, 29, 19,
    14, -41, -55, 56, 8, -13, 24, 23,
    41, 38, 20, -14, 26, 39, 43, 16,
    -2, -28, 19, 22, 11, -2, 46, 7,
    -70, -59, -30, -7, -36, -3, -1, -28,
    15, -6, 22, -32, 55, 7, 43, 43,
    -5, -33, 29, 11, 0, -26, 18, -73,
    12, -42, -16, -31, -14, -14, -10, 90,
    42, -21, -19, 24, -8, -32, 28, -22,
    2, -10, -31, -14, -38, -5, -18, -55,
    1, -12, -40, 9, -47, -42, 89, 25,
    -6, -37, 59, 70, 12, 45, -24, 16,
    4, 33, 13, 23, 31, -60, 8, -67,
    4, 43, 9, 7, -84, 33, 0, 70,
    7, -21, 17, 30, -8, -70, 60, -101,
    -3, 26, -39, 63, 25, 6, 22, -27,
    0, 6, -12, 2, 37, -7, 3, -17,
    4, 7, -14, -33, 13, -59, 112, 1,
    21, 3, -9, -3, 28, 19, -21, -25,
    -5, -31, 90, -12, -8, -20, -30, -28,
    3, 86, -60, -7, 26, 16, -5, 11,
    -17, -10, 38, 11, -46, 0, -41, -72,
    -18, 0, 1, 72, -2, -59, -1, 41,
    -47, 23, -3, 45, -27, 0, -13, 15,
    59, 3, -16, -33, -5, -47, 8, 11,
    -19, 37, 9, 32, -13, 24, -14, -6,
    -15, 6, 30, -7, 8, -52, 32, 45,
    -45, 3, -13, 41, -110, 35, 30, -74,
    23, 8, 29, -22, 37, 33, 21, -40,
    -37, 28, -6, 19, -59, 16, 68, -19,
    0, -17, 12, -6, 29, -14, -63, -10,
    -11, 20, -24, 5, -49, -8, -18, -62,
    -26, 44, -1, 16, -40, 13, 15, -1,
    9, -1, -23, -19, 71, -32, -41, -4,
    -15, -2, -18, -58, -41, 30, -37, -47,
    -13, -5, 72, -35, 5, 23, 22, -85,
    51, 28, 10, 2, 14, -10, -21, 16,
    15, -3, 10, 9, 31, 10, -63, 0,
    -41, -9, -1, -12, 41, -73, -22, 1,
    -19, 23, -22, 31, 6, -11, 25, 56,
    53, 44, -44, -53, -12, 16, -2, -45,
    15, 18, -8, 28, 5, 8, 28, -10,
    -67, 15, -45, 1, -34, 6, 3, -29,
    7, -46, 11, -34, -29, -35, 47, -18,
    31, 17, 7, 44, -6, -50, 13, 32,
    1, 28, 10, 7, 15, 7, -10, -15,
    -3, -7, -12, 3, -21, 0, -10, 3,
    8, -3, -5, -38, 20, 21, 17, 16,
    5, -39, 13, 34, 4, 1, -1, -4,
    -11, -6, 0, -40, 22, 15, -1, 48,
    8, -1, 5, 1, 6, -7, 14, 11,
    8, -7, 21, 18, -22, -17, 17, 1,
    11, 3, 14, 12, -7, -4, -9, -8,
    5, 0, -20, 0, 25, 2, 24, 15,
    -3, 10, 13, 0, -24, 25, 1, -18,
    -4, 13, -13, 15, -6, -8, -15, 5,
    3, 51, -18, -20, 8, -2, 18, -3,
    -19, -15, -1, 27, 8, 5, 1, -11,
    3, 8, 19, -10, -4, -20, 26, -34,
    13, -7, 24, 36, -8, -22, -35, 24,
    -9, -9, -17, 6, 0, -1, 12, 11,
    -5, -1, -2, 15, -17, -19, -18, 25,
    18, 5, 20, -1, 10, -11, 33, 6,
    4, -11, -15, 27, 9, 34, -14, 5,
    -45, -26, -6, 44, 0, -4, 6, 13,
    3, -9, 1, 2, -4, 39, -19, 8,
    24, -11, -6, -12, 23, -14, 15, -22,
    -22, -2, 22, -47, -5, -17, -37, 4,
    -30, 23, 17, 27, -5, 8, -2, -4,
    9, 41, -15, -33, 1, -17, 10, 53,
    -20, 1, -13, 12, -3, -2, -13, -15,
    13, -9, 6, 12, -14, -13, 6, 3,
    38, 14, -4, -2, -5, 12, -5, 8,
    38, -12, 17, 17, 18, 1, -20, -13,
    -11, -10, 9, 15, 11, 22, -18, -18,
    -36, -1, 22, -13, -62, 6, 17, 21,
    9, -7, 47, -25, 8, -8, -10, 34,
    -18, -19, -3, 16, -18, -19, 4, -4,
    -6, 0, -14, -10, 14, 8, 31, -17,
    -24, -12, -15, 12, -19, 1, 10, -6,
    -27, 9, 55, -36, 14, -1, -13, -5,
    -18, 33, 7, 16, -43, -16, 4, 13,
    4, 8, 10, 20, 21, 12, 41, 2,
    2, 27, 13, -4, -27, -37, -14, -11,
    15, 9, 32, -24, -22, -11, -3, -17,
    7, 11, 14, 32, 22, 50, -16, -15,
    12, 5, 4, 7, -8, -23, -5, -2,
    16, -26, -22, 19, 24, 6, -9, -8,
    34, 13, 10, 43, 10, -9, -10, 11,
    -51, 1, -23, -24, -20, -35, -5, -21,
    -5, -9, 7, -19, -11, 10, 9, -8,
    1, 7, 18, 20, 5, 12, -16, 7,
    20, -24, 6, -50, 14, 2, -31, -17,
    34, 11, -5, 11, -24, -14, -35, -22,
    9, -1, -30, 15, 15, -15, -27, 11,
    11, -1, -18, -16, 7, 25, 25, -34,
    -3, -50, 4, 6, -10, -1, -21, -9,
    15, -3, 1, 9, 20, 1, -5, -31,
    -10, -26, -3, -11, 2, 3, 1, 6,
    -81, 4, -14, -19, -26, 11, 9, -15,
    21, 23, -3, 35, 10, 27, -5, -4,
    -20, -3, -27, -36, 7, 26, -19, 32,
    -2, 11, -2, 2, -1, 12, -34, -6,
    -20, 34, -26, -24, -19, -25, 11, 17,
    10, -35, 26, -23, -25, -5, 0, 10,
    -6, -17, 4, 17, 3, 0, -22, -5,
    30, -18, 9, -4, 35, 22, 5, 5,
    -3, 11, 2, -10, 12, -12, 14, -3,
    -10, -17, 23, 68, -19, 4, 12, -15,
    -8, 6, -28, 33, 34, -54, -2, -13,
    18, 17, 18, 8, -14, 16, 16, 30,
    20, -52, -5, -13, 9, -12, -14, 0,
    2, 8, 25, 17, -7, -23, 24, 10,
    -16, -41, 24, -3, 33, -17, -14, -6,
    1, -10, 16, 23, -39, -8, -1, -2,
    -6, 13, 0, -6, 21, 35, -14, -20,
    -5, 11, -25, 8, 2, -8, -3, 9,
    16, -1, -2, 28, 14, 7, -8, -15,
    9, 18, 26, 10, 3, 8, 9, -6,
    20, -3, -4, 15, 47, -31, -12, -19,
    -15, 34, -16, 45, 1, -5, 8, 10,
    4, -13, -1, 36, -10, 20, 19, -3,
    -13, 16, 0, -1, -6, 13, 27, -37,
    7, -22, 18, 20, -4, 27, -15, 12,
    -43, 26, 44, -17, 12, -7, -26, 9,
    -5, -21, 23, 4, -27, -8, 16, 2,
    19, -3, -10, -11, -3, -18, 45, 22,
    -15, -3, 37, 27, -22, 9, -40, -8,
    39, 18, 17, 25, 23, -15, 14, 11,
    43, 1, 16, 5, -28, -22, -16, -6,
    28, -16, -9, -2, 0, 15, -3, 11,
    19, 1, -8, -6, -14, -25, 10, -6,
    -22, -43, 11, 17, -11, -8, -18, 30,
    18, 29, -20, 14, 5, -21, 14, -8,
    26, 2, -1, -8, -5, -2, -20, -8,
    54, -5, -12, -20, -26, 34, 5, -18,
    -9, -57, -23, 26, 14, 2, 5, 9,
    27, 11, 7, -38, 10, 0, -21, -20,
    4, -29, 11, 3, 2, -9, 9, 43,
    -19, 2, -44, -26, 20, -22, 4, 21,
    -3, 9, -17, -7, -12, -18, -13, 28,
    -28, -49, 26, -13, 6, 7, -28, 10,
    15, -20, -5, 2, 1, -12, 2, 0,
    25, -41, 6, -36, -11, 29, -13, 28,
    34, -18, 25, 83, -16, -27, -27, -44,
    22, -8, -13, -6, -27, 2, -2, 25,
    -11, -3, -1, -3, -35, -8, -4, -28,
    2, 3, -2, -16, -23, 14, -5, -10,
    -46, 46, 4, -5, 9, 17, 7, 5,
    13, 4, 19, 0, -9, 2, -17, -35,
    -12, 6, 7, 1, 10, -6, 3, -15,
    -9, 34, 4, 24, 11, 37, 18, -26,
    -38, -3, 38, 37, -9, 5, 3, 16,
    -4, -28, 31, 14, 1, 10, 12, -10,
    -3, 7, 12, -12, -4, -3, 17, -38,
    9, -43, -7, 11, 8, -16, 1, -11,
    -15, 40, 16, -28, 7, 12, 10, 12,
    3, 11, -11, 13, 23, -30, -8, -5,
    16, 2, 1, -31, 13, 8, 25, -8,
    23, 1, -11, -4, 26, 8, 0, 7,
    -21, 24, 6, 13, -16, 0, -8, -7,
    29, 4, -4, 14, -11, -16, -11, -12,
    -8, -13, -5, 1, 0, 0, -7, 13,
    -14, -18, 13, 7, 13, 5, -11, -19,
    -4, -15, -1, 49, -14, -10, 16, 19,
    15, -12, -1, -8, 38, -16, -9, -8,
    1, 3, -8, 2, 15, 12, 11, -5,
    9, -8, -27, 27, -4, -43, -17, 8,
    28, -5, 31, 10, -6, -2, -22, 0,
    -33, -9, -25, 0, -9, -26, -4, 27,
    -7, -2, -22, -17, -23, 45, 37, -4,
    -21, 0, -10, -38, -20, -14, -14, 10,
    17, 2, -11, 8, -3, -18, -4, -16,
    -5, 23, 18, -7, -30, 10, -27, -24,
    -1, -3, -27, -9, 6, 18, -49, -16,
    -10, 1, 0, 24, -12, 14, 14, 17,
    -19, -55, -47, 24, -15, -15, -30, 1,
    8, -15, 13, -11, -1, 3, 1, -16,
    -14, 8, 7, 13, 13, 29, 29, 14,
    2, 27, -2, 18, -42, -15, -14, -3,
    -16, 3, 11, -8, -14, 2, 4, -2,
    35, -5, -24, -6, 28, 4, 37, 8,
    3, -3, 7, 11, -9, 11, -75, 18,
    17, -6, -21, -1, 14, -11, 15, 19,
    -2, 20, 16, -16, -1, -8, -12, -19,
    7, -17, 11, 37, -2, -12, 12, -12,
    30, -2, 5, 0, 7, -64, -11, -18,
    -4, 14, -22, -10, 20, 34, -8, -8,
    -5, -6, -4, 22, 21, -20, -6, 9,
    -6, 32, 5, 3, 3, -5, -8, -13,
    17, 7, 29, -10, 5, -9, 34, -9,
    1, 15, -20, 16, 3, 4, -38, 27,
    2, -6, -17, 22, 5, -1, 0, 12,
    30, -11, -20, 12, -11, 45, 14, -36,
    5, -28, -16, 9, 5, -21, -2, -15,
    0, 9, -7, -69, -11, 1, 17, 18,
    4, -3, 16, 2, -7, 16, 15, -15,
    -24, 19, -71, -3, 47, 0, 21, 35,
    -2, 29, -2, 1, 10, 9, -4, -38,
    15, -12, -10, 11, 14, -20, 6, 26,
    3, 4, -16, 0, 4, 30, 2, 9,
    16, -47, 21, 1, -5, 6, -16, 23,
    -2, -37, -7, 22, 32, 39, -32, 12,
    -32, 7, 15, 0, -8, 19, 27, 1,
    -21, 12, 30, -29, 8, 13, 5, -19,
    14, -50, 14, 29, -8, -33, -5, 32,
    1, 29, -8, 13, 21, 10, -10, -12,
    -24, -49, -27, -2, -19, -1, 9, -3,
    -18, -15, 22, -1, 1, 25, 32, -6,
    -20, -26, 19, -23, -20, 0, 11, 11,
    5, -9, 19, 0, 2, 11, 48, 34,
    3, 11, 10, -14, 1, -14, -10, -23,
    -10, 10, 10, 16, 5, -11, 8, -10,
    8, 5, 27, 5, 12, 23, -10, -12,
    12, 23, -13, -1, 63, -38, -38, -21,
    46, -36, -21, 8, -4, 9, 31, -24,
    33, 5, -2, 46, 9, 10, -9, -8,
    -21, 10, -13, 6, 5, -18, 23, 8,
    1, -1, -5, 0, -1, -3, 11, 9,
    -15, -12, 46, 53, -8, 3, -18, 4,
    -3, -18, -30, -25, 6, 8, -5, -12,
    30, 18, 15, 29, -15, -24, -3, -22,
    -4, -19, -9, 30, 26, -3, -58, 4,
    26, 10, 8, -35, 14, 0, -5, -15,
    -21, -19, 26, 13, -10, -10, -16, 2,
    21, 18, -19, 51, -31, 19, -22, -5,
    -3, -11, -1, -13, -2, 17, 7, 43,
    -46, -2, 6, 6, -43, 5, 57, 14,
    -1, 9, -26, -11, -17, 16, 29, -4,
    -30, -2, -41, -34, 29, 16, -38, -25,
    -16, 0, -14, 21, 21, 11, 25, -8,
    41, -10, -18, -11, -1, -16, -3, 37,
    36, 19, 18, -10, 5, 27, 4, 6,
    -16, -8, -20, -3, 2, 12, -36, -20,
    21, 8, 19, -19, 60, -13, 28, 44,
    -7, -7, -10, -17, 13, -12, 2, -28,
    1, -12, -3, -4, -17, -5, -8, -20,
    -17, 22, 37, 14, -10, -61, -17, -43,
    19, -6, 1, 9, -45, -14, 22, 34,
    -2, -3, 20, 3, 37, -16, -20, 8,
    3, 0, -14, -19, 8, 7, 11, 7,
    -25, 5, 0, -15, 7, -18, 10, -4,
    -9, 16, 7, 15, -80, -3, -15, -62,
    -27, 8, 4, 7, 14, 10, 4, -16,
    -24, -16, -31, -4, -3, 25, -7, -41,
    21, -5, -32, 18, 24, 6, 8, -6,
    11, 5, 12, -13, -15, 15, -5, -13,
    6, 14, -21, 9, -4, -8, 7, 0,
    -12, 3, -1, -24, -6, 5, 20, -6,
    -4, 5, 2, -9, -34, 4, 35, 15,
    23, 8, -10, -3, 15, -22, -33, -51,
    3, -30, 4, 25, 3, 24, -35, 30,
    -19, 27, 54, -6, -13, -43, -13, -26,
    6, -42, 13, -1, -6, -10, 6, 1,
    20, -15, -1, -2, 37, -19, -2, -15,
    4, -10, 20, -6, 15, 27, -5, -7,
    -1, -13, 4, 14, 5, -21, -4, 8,
    5, 5, 16, -44, 9, -21, -14, -25,
    34, 0, -4, -2, 2, -21, -13, 10,
    15, 5, 6, -26, -9, 20, -49, -1,
    -9, -26, -6, 30, 5, -13, -6, 37,
    2, 19, -6, -14, -6, -19, -18, 2,
    37, 25, -6, 5, 23, -4, -59, -46,
    -1, -12, 8, 11, -15, 11, 24, -30,
    19, -18, -50, 4, 26, -11, -24, 9,
    4, 13, 5, -34, 4, 32, -5, -45,
    11, -75, -16, 1, -2, 10, -20, 37,
    -12, -15, 18, 52, 7, -27, 31, 5,
    -27, 10, 18, 6, -6, -23, 47, 8,
    -16, -55, -7, -41, -27, -19, -7, 25,
    1, -46, 3, 33, 8, -19, -13, 26,
    33, -6, 25, -18, -5, -8, 11, 4,
    -4, 15, -11, -30, -11, 9, 9, 12,
    -12, -14, -10, -18, 13, -12, -18, 15,
    4, -3, 1, -1, 6, 39, 4, -1,
    -11, 27, -25, -11, -8, 21, 18, 4,
    -26, 36, 3, 10, -3, -20, -4, 7,
    7, 13, -3, -14, 20, -34, -5, -46,
    -13, 21, -2, 7, -23, 17, -5, -22,
    13, 14, 22, -35, -1, 24, 7, 22,
    5, -21, -9, 44, 3, 5, -24, 43,
    -24, -33, 23, 4, 3, -5, 5, -18,
    -1, -7, 3, -35, -12, 14, 6, -46,
    8, -15, -8, -7, -22, -9, 10, -25,
    8, 35, 24, 11, -23, -6, -10, -6,
    11, 8, -7, 1, -5, 14, -12, 23,
    21, -9, 2, -1, -11, -15, 43, 45,
    -18, 5, -9, -34, 14, 24, 0, 5,
    -31, 18, -4, -6, -1, -20, -15, 23,
    61, -11, 2, -9, 41, -41, 27, -11,
    11, -5, 18, -6, 44, 17, 35, 54,
    -15, 3, 2, -25, 12, -19, 5, -25,
    30, -18, 18, 10, 3, -14, 20, 22,
    -30, -12, 6, 11, 7, -32, 6, 5,
    8, 18, -12, 32, -14, -12, 24, -31,
    21, -49, 0, -10, -5, -10, -13, 7,
    -24, -6, 5, -6, -5, 15, -8, 32,
    -51, -8, 5, -29, 15, -71, 6, 63,
    -2, 13, -1, -5, 16, -1, 22, -22,
    28, 26, -12, -15, 5, 5, 2, 12,
    7, -39, -23, -4, -26, 19, -8, -24,
    -38, 48, 17, 3, -26, -4, -11, -34,
    7, 2, -59, -30, 7, -14, -92, 11,
    27, 12, 52, 15, 13, 8, -40, 11,
    -14, -28, 62, -42, 1, -3, 51, 29,
    10, 7, -4, -64, -23, -7, 9, -70,
    12, -24, -4, 1, -7, 27, 22, 21,
    36, -33, -7, 18, 39, 21, 39, -12,
    12, -39, 1, 26, 23, -4, -6, -27,
    44, -19, 25, 26, -29, -10, -12, 20,
    -10, -8, 6, 2, 16, -16, -21, 72,
    -56, 27, 1, -21, 47, 4, -7, -34,
    -3, -32, 31, 60, -16, -12, 6, 10,
    17, -27, 7, 6, 31, 1, 48, 22,
    27, 11, 0, 3, -15, -60, -17, 34,
    11, 56, -34, -12, 32, 17, 39, 0,
    23, 3, 7, 11, 11, 31, -22, 25,
    1, 8, 28, -16, -33, -15, 25, 47,
    13, -2, 34, -30, 52, -17, 30, -39,
    -31, 23, -64, -2, 6, -77, -43, 4,
    68, 9, -32, -88, 4, 11, 6, -9,
    12, -13, 14, 29, -15, 63, -29, -16,
    36, 0, -30, 24, -22, 42, 4, -4,
    4, -49, 6, 31, -13, -22, -2, 40,
    19, -65, -17, -71, -10, 0, 3, 3,
    -66, 32, -98, -22, 21, 22, 15, -29,
    -10, 13, 0, 31, -10, 51, 3, -30,
    14, 27, 5, -6, -5, -14, 16, -8,
    58, -5, -12, -52, 38, -53, -5, 13,
    41, -38, 14, -33, -13, -28, -25, 23,
    -6, -8, 16, -10, 3, 64, -53, 89,
    11, 5, 24, 8, 127, -70, -18, -17,
    -25, -21, -45, 18, 15, -23, 63, 1,
    29, 3, 14, 42, -25, -26, -57, 24,
    16, -2, -19, 2, 21, 31, -59, -41,
    -12, 6, -3, -10, -33, -12, -14, -24,
    35, -49, -42, 71, 10, -35, 17, -45,
    -17, -6, 72, -44, -46, -24, 20, 23,
    -28, 10, 24, 11, -28, 6, 49, 0,
    17, 20, 51, 3, 35, 14, 19, -16,
    3, -6, 36, -23, -14, 19, 11, -15,
    7, 4, 1, -4, -7, -14, -46, 22,
    15, -15, 6, -25, -15, -39, -51, 6,
    -50, 23, 14, 10, 12, -14, 7, 35,
    12, -10, 41, -44, -14, 27, 51, -3,
    29, -7, 44, -21, 50, -60, 3, -20,
    -9, 9, -43, -10, -31, 37, -14, 13,
    15, -4, -10, -10, 8, -34, -22, 8,
    10, 5, 4, 81, -21, 12, -15, 13,
    27, -27, 10, 17, -16, -5, 35, -44,
    -21, -17, -20, 3, -29, -15, -74, 17,
    -5, -47, 34, 95, 1, 54, -39, 48,
    -5, 43, -5, -24, 11, 19, 14, -9,
    65, -4, -10, 19, -15, 14, 26, -9,
    -18, -21, -1, 2, -23, 21, -25, -37,
    56, 31, 33, -18, 20, -37, -5, 20,
    -27, 79, -49, 0, 14, -9, -15, 18,
    -32, 89, -42, -41, -8, 22, 3, 3,
    -31, 24, -20, 17, -9, 67, 20, 12,
    8, -22, 21, 1, 35, 13, -8, -6,
    -24, 55, 52, -9, 34, 21, -11, 6,
    -26, 71, 6, -4, 44, -17, -8, -2,
    34, 10, 48, 21, 44, -46, 51, 77,
    88, -11, -29, 23, -1, 33, 40, 47,
    26, 9, 29, -47, -5, -20, 27, 26,
    -7, 44, 24, 17, -35, -94, -55, -57,
    31, 10, -13, -4, -96, 77, -3, 25,
    38, 24, 6, 1, -33, 75, -5, 4,
    28, 71, -26, -5, -28, 18, -2, 21,
    -26, -39, 5, -21, 14, -62, 13, 9,
    -26, 25, -6, 25, -61, 52, 12, -30,
    -21, -11, -11, -65, -58, -53, 8, -6,
    -30, 12, -46, 41, 11, 1, -4, 46,
    14, -21, -21, 53, 8, 17, -7, 21,
    4, -10, -9, -10, -11, -20, 11, -32,
    -38, 5, -18, -30, -49, 44, 14, -19,
    -2, -21, 17, -14, 1, -6, 35, 3,
    2, -12, 3, -9, -54, 6, 50, -23,
    42, 48, -23, -29, 69, -53, -49, -50,
    9, -27, 10, -12, 14, -34, -6, -58,
    9, -4, 45, 72, 15, -8, 55, 9,
    -19, -110, -30, 40, -9, 24, 0, 67,
    -3, -10, -29, -8, -3, -13, -67, -18,
    35, -35, 20, -39, -24, 24, 57, 13,
    -36, -52, -6, 41, -7, -11, -69, -60,
    -4, 17, 14, -45, -18, 23, -47, 36,
    54, -20, 4, -1, -27, 13, -44, -10,
    27, 13, -19, -22, 14, 3, 20, 2,
    4, 102, -32, 44, -7, -1, -42, 34,
    9, -43, -29, -20, -2, 21, 48, -22,
    64, 65, -17, -10, 60, 60, -9, -30,
    -9, 1, -34, 58, 18, -12, 3, 31,
    59, 70, -40, -12, 28, 14, 6, -6,
    24, 44, 43, -66, 13, 5, -54, -2,
    -2, -48, 21, 33, 11, 20, 69, -20,
    49, -96, -4, -27, 7, -20, 40, -22,
    -61, 13, 73, 33, 13, 8, -29, 0,
    -29, -90, 26, -33, -2, 19, -25, 22,
    -49, -45, -10, 25, -37, -57, 13, -34,
    -8, 33, -35, -2, 31, -8, -16, -28,
    -62, -28, 32, -18, 16, -11, -47, 27,
    11, -27, -25, 3, 0, -25, 6, -18,
    11, 19, -5, -9, 4, 14, -36, -42,
    12, -28, 49, -11, 9, -9, -51, 25,
    58, -14, 66, -16, -12, 18, -58, -12,
    9, 19, -2, 2, -3, -20, 33, -44,
    -16, 21, -15, 2, -6, 14, -16, 0,
    43, 16, -2, 8, -26, -4, -2, -16,
    16, 45, -56, 65, 23, -26, 2, 16,
    -68, -6, -62, 1, 13, 7, 14, -47,
    -46, 18, -2, -17, -9, -11, 17, 46,
    -7, 37, -16, 19, 48, 38, 34, -32,
    12, -44, -78, -8, 21, 13, -6, -36,
    68, 4, 61, 1, -16, 11, -5, 25,
    33, -9, -14, 19, 37, -27, -9, 25,
    -11, 19, 16, 18, 16, 30, -13, -25,
    -62, -25, -17, -16, -6, -5, 22, -24,
    3, -10, 34, 16, 0, -8, -37, -32,
    35, 3, 26, 10, 43, 39, 44, 12,
    -14, -5, -5, -6, 36, -4, -21, 40,
    -30, -3, -12, -39, -27, 7, -42, 8,
    -25, 1, -44, 28, -41, -35, -14, -4,
    0, 15, -5, -7, -71, -58, -4, -86,
    54, -45, 31, 9, 10, 8, 83, -25,
    -44, -60, -52, -12, 4, 23, 20, -6,
    -51, -5, -5, -51, -25, -71, 21, 38,
    2, -2, -4, 2, 27, 45, -23, -45,
    -31, 37, 17, -8, -23, 6, 5, -14,
    -11, -27, -16, -57, -20, -19, 37, -3,
    -39, 14, 35, -16, 2, -28, 16, 3,
    -9, 36, 1, 27, -23, 8, -52, -30,
    5, -29, 26, 4, 10, -6, -10, 21,
    16, 12, -2, -26, -6, -14, 10, 9,
    -34, -12, -71, 25, -10, -2, -16, -8,
    -19, 16, -14, 30, -3, 28, -1, 40,
    10, 11, 2, -6, -22, 16, 9, -4,
    13, 14, -25, 3, 13, 29, -12, 0,
    40, 0, -11, 25, 4, -3, 10, -15,
    0, -13, 7, 50, -3, -23, 6, -44,
    28, 9, 14, 6, 4, -9, -12, -4,
    9, 7, 18, 7, 3, -11, 0, -19,
    -32, 4, 54, -15, 6, -8, -4, -19,
    12, 8, -48, -38, -18, -14, -42, 7,
    -1, -26, 1, 13, 11, 0, -11, -11,
    -5, 30, 13, -4, -14, -1, -12, -19,
    -17, -21, -35, -10, -16, 1, -3, 23,
    28, -33, 97, -4, -8, 8, 12, -61,
    31, 0, 2, 37, 6, 4, 8, 6,
    -27, 9, -15, -4, 11, -4, 1, 8,
    -32, -23, 33, 22, -2, -12, -22, 24,
    3, 19, -19, 2, -7, 21, -57, 14,
    -3, -3, -18, 15, -2, -6, -16, 4,
    -48, -26, 26, 22, -8, 14, 17, 7,
    -25, 39, 27, 23, -21, 9, -20, 11,
    -18, 16, 1, 28, 4, -39, 22, 0,
    42, 10, -9, 12, -6, -16, 8, 4,
    33, 18, 2, -26, 36, -4, 25, -1,
    -43, 11, 5, 30, -11, 14, -15, 20,
    -5, 5, -4, -17, 48, 24, -5, -13,
    -17, -9, 29, -14, 14, 18, -5, 15,
    11, -54, -7, -15, 20, -10, -27, 26,
    13, 14, 0, -5, 2, 19, 14, 0,
    -33, -8, -27, 12, 46, -7, -35, -37,
    -23, -61, 18, 1, 4, 9, 0, 14,
    -13, 1, 4, -15, -2, -1, -8, 21,
    18, 45, -26, 23, 0, 14, -12, 11,
    9, 15, -45, -7, -48, -5, 19, 2,
    39, 28, 18, 14, -11, 8, 4, -19,
    -2, -24, 5, -13, 5, 14, 7, -1,
    56, -38, 43, 43, -15, -33, -31, -8,
    48, -40, 38, -21, 23, 4, -21, 6,
    31, 8, 4, 3, 12, 13, -10, -4,
    -24, 10, 6, 13, 9, 7, 0, 10,
    -43, 11, -12, 14, -5, -12, -6, -8,
    -20, -12, 15, -30, -74, 48, 14, 22,
    -1, 13, -18, -10, 6, 4, 17, 13,
    3, -33, -3, -25, 8, -4, 5, -2,
    -9, -6, -18, 49, -6, 6, -23, -3,
    19, -4, -26, -68, -8, 6, 41, 8,
    1, 6, -25, 10, -19, 27, 11, -10,
    5, -30, 4, 24, -5, 3, -13, -7,
    -30, -31, -39, 21, -26, -38, -17, -1,
    -20, 39, -16, -3, 15, 13, 14, 20,
    -12, 16, -13, 17, 6, -7, 4, -13,
    -18, -10, -11, -4, 17, 2, -20, 12,
    18, 13, -34, -4, 17, -2, 6, -20,
    -60, 33, 44, -38, 47, -33, -27, 37,
    -11, 25, -5, -26, -23, 1, 3, -2,
    9, 21, 18, -12, 22, 17, -19, -7,
    5, 12, 4, 45, 18, -6, 26, 1,
    -4, 38, -5, 17, 34, 31, 35, 21,
    22, -1, -7, -12, 9, -9, -13, -18,
    16, 2, -3, -1, -19, -13, 14, -6,
    21, 25, 43, 7, 0, 3, -4, -3,
    12, 50, -1, -36, 13, 19, -16, 17,
    27, 9, 18, -11, -5, -11, -10, -3,
    13, -5, -16, 17, 1, -30, -11, 8,
    -7, -25, 46, -5, 19, -2, 9, -12,
    25, 24, 15, 3, -34, -7, -15, -1,
    15, 7, 35, 12, -3, 11, 2, 19,
    -9, 33, -23, -7, -3, -25, -25, -6,
    5, 21, 21, 7, -11, 42, -12, 17,
    12, 65, -4, 15, 30, -3, -18, -18,
    -19, 10, 8, 8, -21, 9, 2, 9,
    13, -30, -2, -8, -15, 37, 7, 8,
    -18, -17, 9, 55, -14, -20, -16, 10,
    -8, -39, -18, 19, -4, 14, -21, 10,
    -19, 23, 30, 37, -7, 2, 0, -2,
    -12, -6, 24, -14, 4, -22, -33, 8,
    45, 24, -37, 28, 18, 18, 7, 17,
    -13, -5, 29, -48, -35, -13, 27, -10,
    12, -7, -7, -31, -2, -7, -15, 2,
    18, -1, 42, 13, -34, -7, 11, 0,
    14, 11, -17, 21, 9, 9, 3, -4,
    19, -16, 58, -17, 25, 55, 42, 13,
    6, -21, -40, 26, -1, -2, 20, -1,
    13, -6, -1, -10, 11, -20, 20, 9,
    -4, -4, 40, 35, -16, -16, 15, -23,
    17, -31, -12, -24, -20, 0, 35, -11,
    -4, -26, -24, 10, 19, -1, 10, -10,
    10, 11, -5, -12, 4, 2, -19, -7,
    5, 42, 44, 12, -20, 11, -9, 13,
    1, 41, 2, 33, 22, 33, 0, -28,
    2, -50, 6, -3, -7, 25, -7, -7,
    0, -4, 12, 10, -36, -1, -16, 25,
    11, 42, 36, 29, -12, 2, 4, 12,
    8, -37, -1, -2, 37, 33, -26, -23,
    -6, 5, -25, 22, -20, 3, 12, -23,
    3, -1, -26, 0, -29, 10, 7, 6,
    -31, 14, -57, 1, 9, 8, -4, -6,
    22, -12, 1, 27, -4, -7, -4, -1,
    19, -11, 25, 9, 2, 4, 1, 3,
    8, 36, -29, 3, -8, -14, -4, 9,
    25, -31, 23, -29, 3, -7, 17, -2,
    4, 12, 18, -20, 8, 1, -8, 1,
    20, 4, -12, 47, 2, 2, -6, -8,
    -5, 2, 20, 45, 8, 24, 26, 7,
    -30, -53, -9, -32, 3, -2, 0, 13,
    21, -34, -25, -11, -31, -43, 19, 36,
    19, -11, -10, -46, 0, 5, -6, 3,
    14, -13, 21, -7, -11, 12, -4, -22,
    19, 18, 0, 5, 13, 0, 1, -4,
    -16, -7, 29, 50, 5, -29, -33, 35,
    -4, 14, 16, -21, -6, -1, -13, -6,
    28, 0, 21, -8, -7, -12, -2, 26,
    46, -29, -25, 2, -11, 25, 9, -14,
    11, 7, 0, -16, 10, 48, 30, 3,
    -14, -22, 3, -8, 11, 1, -21, 13,
    2, -9, -17, -26, 2, 9, 18, 2,
    12, -13, 29, 6, 22, 1, 7, 0,
    -36, 8, 0, 21, 31, 34, 20, -3,
    7, -7, -27, -1, 6, 1, 9, 0,
    4, 20, -8, -4, -5, 11, 31, 41,
    -13, 41, 17, -6, -18, -8, 9, -20,
    -3, 3, 1, -6, 57, -8, 10, 6,
    -41, -33, -3, -3, 23, -6, -5, 12,
    -5, 13, -10, 2, -13, 26, -9, 5,
    -12, 25, 60, -39, 2, 1, -18, 12,
    25, 7, 44, -45, -20, 14, -41, -16,
    -15, 1, 3, 40, 5, -6, -6, 9,
    1, 14, 25, -31, 2, -9, 9, -12,
    -6, -11, -9, -31, -11, 0, 3, -1,
    -84, -1, 19, -36, 16, 13, -1, 15,
    12, 2, -6, -42, 0, 5, 13, -6,
    35, 12, -34, 22, -11, 2, -11, 4,
    -51, 32, 3, -7, 28, -9, 9, -11,
    5, -1, 37, -5, -42, -20, 51, -52,
    9, -9, 22, 7, 7, 0, -1, -4,
    -10, 1, 31, -18, 4, 8, 40, -41,
    68, 13, 33, 17, -17, -3, -13, 13,
    -5, 16, 11, 63, -33, 10, 13, -9,
    -23, 1, -15, 13, 8, 12, -7, 18,
    5, 32, 11, 1, -10, -5, -20, -7,
    -6, -4, -47, 9, 4, 9, -6, -14,
    24, -39, -2, -20, 8, 12, 12, -55,
    28, -11, -59, 3, 7, 7, 22, 13,
    3, -14, -20, -24, 15, -6, -28, -6,
    17, -23, -48, 31, -22, -5, 7, 5,
    53, -38, 72, -35, 24, 65, 11, -16,
    -8, 35, -6, -6, 6, -10, -8, 22,
    -17, -6, 2, 23, 17, 6, 5, -15,
    -11, 17, -24, 51, 2, -12, 7, 12,
    70, -5, -9, 24, -9, -35, 0, 13,
    -1, 35, -10, 37, 3, 14, 3, -9,
    -9, 15, 1, -13, 9, 7, -4, -13,
    14, -68, 3, 9, 15, 24, 7, -15,
    4, -13, -6, -43, 36, 36, 16, -22,
    -29, 39, 21, -14, 17, 35, -4, -5,
    42, -20, -4, -10, -18, 10, 9, -11,
    49, -22, -4, -42, 0, -32, 1, -3,
    -18, -9, 0, 36, -2, 20, -1, -16,
    -9, -50, -25, -53, 1, 26, 16, -12,
    -6, 4, 28, -12, 5, -19, -14, 18,
    -14, -28, 34, 56, 13, 3, 9, -3,
    -10, -14, -24, 5, -63, -1, 49, 0,
    37, 16, -3, 37, 2, 16, -9, 13,
    5, -16, -8, 3, -4, 4, 18, 3,
    -9, -64, 46, -11, -2, -25, -15, -17,
    1, 0, 34, -1, 39, 76, 36, -11,
    -7, 31, 20, 3, -5, -21, 14, -7,
    -8, -9, -2, -9, -3, 7, -11, 10,
    24, 18, -104, 27, 3, 8, 22, 25,
    14, -2, -21, -27, -98, 39, -15, 18,
    -11, -7, -23, -42, -3, 6, -4, -15,
    -7, -9, -7, -16, -15, 10, 12, -13,
    -36, -13, 3, 17, 4, -11, -15, -4,
    -16, -1, 3, 27, -18, -33, 60, -27,
    0, 6, 19, -4, 13, 19, -14, 10,
    6, -21, 0, 13, -29, -16, 9, 10,
    2, -26, 18, 44, 10, -9, -4, -16,
    20, -16, -73, -13, 4, 13, 53, -17,
    -24, -6, 56, 33, 17, 5, -11, -1,
    -38, -5, 11, 38, 35, 11, -7, 8,
    34, 6, -9, 22, 0, 11, 8, -29,
    23, 19, -53, -4, 21, -42, 25, 29,
    43, 9, 26, 27, -10, 22, 4, 8,
    21, -11, 0, -13, 11, -9, 12, -3,
    46, 0, 4, -18, -30, 1, -9, 17,
    -13, -27, -55, -45, -13, -17, 21, 21,
    18, -3, 17, 7, 18, 4, 10, 19,
    -4, -4, 9, 22, 10, 2, 6, -13,
    32, 12, -28, -62, -22, 5, -1, -6,
    48, 18, 6, -15, 68, -46, -55, 44,
    32, 4, 4, -8, -20, 6, -2, -3,
    23, -5, -13, 14, 14, 20, -2, 4,
    -3, 76, 28, -7, 9, 7, 22, -7,
    11, -40, 18, 17, -29, 23, -18, 25,
    36, -14, 35, -14, 6, 12, -4, -44,
    -16, 28, -51, 24, -9, -5, -21, -1,
    -20, 54, 12, 37, -31, 31, -5, 14,
    -4, 38, 20, 15, 26, 12, -13, -15,
    -2, 0, 13, -28, -11, 7, 8, 26,
    15, -21, -9, -3, 34, 30, 1, 0,
    17, -19, 11, -17, -15, -5, 4, 22,
    29, 2, 44, -1, -24, 64, -6, 44,
    17, 59, -13, 28, 12, -10, -14, -24,
    19, 25, 11, 4, 24, 13, 16, -11,
    22, -117, 0, -58, 2, -18, -7, 11,
    -56, -8, 4, 43, -47, -17, -22, -27,
    -15, 7, -13, -9, -4, 1, -12, 21,
    22, -16, 30, 10, -25, -5, 1, -8,
    -10, -35, -20, -51, -14, 6, 11, -6,
    -32, 15, 20, -14, 3, 14, -2, 21,
    0, -18, -36, 45, 12, -4, -6, 0,
    28, 2, -10, -3, -13, 2, 11, 8,
    -39, 77, 21, 14, 11, -6, 22, -31,
    4, -19, 22, 35, -25, 9, 37, -29,
    34, 12, 27, 27, 33, 4, -6, -12,
    -2, 21, -6, 5, 1, 7, 14, -3,
    -11, -41, -9, 7, -8, 16, -14, 16,
    44, 66, 7, 3, 0, 7, 1, -33,
    13, -12, 42, 3, -3, 11, -17, -10,
    -12, 2, -3, -20, 11, 13, 11, -16,
    19, 5, 16, -1, -11, 13, -41, -1,
    57, -19, -27, 8, 64, 38, -39, 17,
    -35, 15, -19, 9, -18, 31, 9, -22,
    -20, -20, -1, -28, 19, 6, 10, -4,
    -18, 4, -2, 9, -26, 15, 8, -15,
    2, -8, 12, 22, -8, -4, 28, -8,
    -4, -17, 44, 2, -4, -1, 7, 0,
    -29, 43, -16, -17, -3, 20, -1, 3,
    58, -13, -21, -31, -1, -7, -9, -8,
    86, -16, 13, -31, -7, 34, -17, -10,
    6, 4, -21, 23, -7, 0, -6, -14,
    -13, 4, 33, 1, 38, 37, 10, -8,
    40, 38, 3, -2, -3, 16, -13, 11,
    32, 15, -33, -29, -5, -30, -14, 22,
    -5, -14, -11, -32, 11, 29, 13, -2,
    14, -23, 2, 5, 0, 0, -23, 6,
    -26, -63, -30, 14, -2, -3, 20, 13,
    -31, 4, 28, -27, -26, -20, -14, 81,
    -16, -16, -19, 9, 16, 17, 3, 22,
    24, 3, -14, -25, -9, 1, -11, 12,
    44, -77, 17, -27, 14, -7, 18, -7,
    3, -54, 2, 11, -19, 61, -54, 8,
    -10, -7, 6, -30, 18, -3, -10, 19,
    -29, -3, 17, -2, 14, -11, 10, -3,
    -5, -11, 58, 7, 24, 17, 0, 6,
    16, -2, -18, -1, 24, 12, 3, 11,
    15, -1, -13, -7, -26, 0, 11, 0,
    2, -10, 4, 10, 10, 6, -2, -9,
    3, 9, -1, 1, -1, -29, 18, 6,
    -23, 6, 0, 1, 36, -50, -31, 19,
    -32, -29, 24, -11, -14, 12, 29, -3,
    6, 12, -18, -3, 8, -13, 3, 32,
    -25, 75, 36, 30, -28, 13, -2, -8,
    -36, 36, 24, 79, -35, 2, -11, 31,
    -21, 28, 6, 32, -2, -4, 1, -31,
    1, 27, 54, 36, -11, -10, -6, 34,
    27, 11, 7, 33, -4, -13, 16, 9,
    32, 11, -41, 4, -38, -11, 14, -1,
    -14, 13, 41, -67, 3, 2, 5, 0,
    42, 15, -28, -10, -25, 4, -28, -9,
    29, -33, 12, -41, -18, -20, -16, -29,
    -19, 31, 15, -84, -56, -51, 58, 44,
    -6, -21, -3, -4, -7, -8, -37, 17,
    33, 9, 44, -29, -9, 16, -22, -8,
    72, 6, -23, 28, 28, 4, -34, -14,
    -20, -31, -7, -64, -43, -15, -22, -4,
    0, -40, -27, 13, 29, 6, 28, 21,
    -25, 19, -1, 43, 11, 29, 31, -26,
    -20, -9, -13, 11, -23, 26, 9, 52,
    -24, -1, 13, -7, -3, 45, -5, -32,
    33, 24, 8, 43, -3, -5, 14, 13,
    -6, -21, 72, -20, -49, 15, 17, 12,
    -37, -62, 67, 61, -36, -58, 30, 42,
    -30, -6, 65, -33, 12, 94, -4, -15,
    -41, 16, 17, 6, 8, -7, -15, -11,
    -21, -4, 68, 30, 7, 27, 13, -26,
    46, 9, 18, 20, -4, 24, -8, 20,
    -6, 18, -2, 8, -83, -14, -5, 25,
    57, 23, 14, 4, 23, 2, 6, 2,
    27, 0, 21, 1, 1, 36, -3, -30,
    13, -68, -16, 51, 16, -5, 9, -44,
    -71, 91, 14, -46, 15, 81, 25, 15,
    -37, 44, 40, -8, -29, 16, 7, -31,
    127, -44, 18, -34, -116, -13, -1, 20,
    84, 1, 56, 39, 70, -9, 37, 30,
    7, -35, -20, -32, -3, 20, -65, -20,
    3, -10, -29, -18, -10, -11, 27, -7,
    -8, 8, 25, -18, 2, -35, -20, -28,
    -12, -71, 16, 8, -13, -25, 61, -9,
    5, -42, -36, 6, -66, -3, 27, 33,
    38, 16, 27, 10, 25, -6, 6, 17,
    -20, -4, -3, -4, 16, 8, 10, -42,
    -61, -38, 17, -4, -20, -20, -78, -17,
    -22, -87, 5, -61, 45, -11, 78, -1,
    19, 110, 66, -23, -22, 15, 58, -13,
    -43, 1, 13, 7, 3, 30, 16, -7,
    73, -38, 13, -13, 9, 2, -11, 45,
    62, -6, -21, -27, -44, 34, 16, -2,
    50, 41, 0, -1, 9, -5, 15, 6,
    -6, -12, 3, -34, 26, -32, 22, 36,
    -50, -54, -6, 20, -11, -14, -31, 14,
    -11, 3, -33, 4, -26, -60, 80, -74,
    -5, -33, 23, 61, 46, -14, -7, -17,
    -9, 1, 5, 23, -29, -14, 39, -58,
    72, 17, 28, -19, -5, -13, -3, 18,
    69, -34, 46, 57, -20, 0, 78, 16,
    12, 8, 53, -5, -27, 28, -22, 8,
    23, 5, -4, 39, -21, 4, 37, 33,
    -18, 11, 11, 62, 9, -28, -56, -28,
    28, -43, -28, -46, -17, -42, 51, 48,
    0, 4, 52, 27, -31, 54, -3, 29,
    31, 13, -21, 21, 28, 8, 11, -8,
    18, -1, 24, -22, 10, -5, -24, 37,
    47, -70, -13, 0, -27, -32, 34, -6,
    26, 15, 2, 11, -3, 5, 2, -12,
    32, -22, 50, 65, -36, -17, 5, -2,
    -7, 40, -17, 38, -13, -2, 2, 40,
    -5, 9, -3, -4, 72, 19, -14, 51,
    47, 16, 29, -11, 21, -15, -4, -7,
    8, 14, -37, 12, -19, -5, 28, -2,
    -7, -50, -40, -14, -23, -38, 22, -2,
    78, -39, 7, -25, -45, 11, -7, 7,
    25, -5, 34, -31, 6, 23, 6, -28,
    20, -1, -31, -1, 6, -5, -32, -10,
    -76, 20, -9, -101, -99, -30, 9, -10,
    -12, 44, -19, 18, -9, 2, -20, 38,
    -16, -12, -4, 22, 38, -6, -9, 26,
    -37, -43, 16, -9, 88, 26, -35, -27,
    -34, -14, -49, 48, -27, 12, -43, 0,
    -41, -66, -34, -43, -30, 87, -9, 41,
    5, -60, -32, 56, 18, 13, -15, 14,
    31, -2, 41, -31, 0, 23, -2, 8,
    -88, 74, 20, 43, -23, 22, 28, 31,
    117, -1, -57, 16, -1, -7, -70, -59,
    -18, 0, 5, -41, 39, 0, 18, 0,
    18, -19, 25, -16, 78, -27, -14, -8,
    10, -33, 5, -19, 30, 41, 32, 7,
    1, -32, 29, 28, 5, -14, -12, 5,
    6, 36, -59, 20, 56, -16, 11, 1,
    8, 1, -12, -6, -21, -40, -14, -10,
    21, 31, -19, 37, 9, 7, -1, -30,
    -43, 43, -35, 24, -38, -3, 32, 19,
    48, 34, 8, -23, 117, 12, -26, -13,
    -2, 12, 30, -12, -3, -7, -2, 4,
    13, -15, -66, 50, -16, -24, 10, 22,
    -5, 33, 30, 52, -41, 7, 52, -15,
    35, -34, 83, 1, -15, -15, -7, 22,
    -25, 19, -31, -11, 3, -20, 20, 9,
    21, 108, 25, 61, 26, 39, -31, -17,
    26, 94, -67, 11, 15, 39, 11, 41,
    1, 0, -5, 107, -46, 51, 15, 3,
    10, -7, -48, 15, 19, -30, -6, 22,
    65, 22, 5, -51, 0, 15, -15, -1,
    -69, -40, 42, 29, -28, 12, 96, 5,
    42, -104, 58, 8, -5, -5, -16, -8,
    -34, 33, -35, -16, -18, 27, -9, -3,
    -52, 39, -33, 5, -32, 17, -58, 10,
    -9, -38, 43, -21, 4, 49, 33, 3,
    -38, 57, 6, 86, -46, 18, -19, 11,
    -7, 21, 35, 5, -9, -1, -49, 0,
    31, 10, 32, -66, 17, 1, 21, -12,
    21, 20, -68, 0, 68, -30, 28, -25,
    45, 32, -50, -41, -29, -23, 27, -7,
    26, -18, -12, -17, -1, -57, 15, 19,
    -64, 18, 68, -14, -8, -4, 61, 2,
    -11, 5, 5, 41, -8, 33, -13, -6,
    -23, -42, 11, 44, 9, 22, 35, 16,
    5, 4, 30, -3, -45, 12, 4, 0,
    45, 31, 6, -9, 3, -5, -3, 16,
    -26, -39, 35, 94, -34, 51, -17, -38,
    -27, -19, -5, -1, 25, -3, -1, -11,
    -16, -2, 18, 31, -5, -18, -21, -15,
    -11, 43, 3, 19, 23, 33, -7, 26,
    44, -41, -18, 51, -22, 21, 0, 13,
    34, -14, 18, 34, -29, -18, -18, 6,
    2, -12, 16, 11, 14, -49, -58, -44,
    -69, 16, 59, 15, -1, 13, 40, -13,
    7, -29, -40, 0, 32, -40, -8, 40,
    -97, -1, 40, -48, -37, 32, 16, -20,
    -5, 24, -24, -19, 11, 19, -45, 13,
    27, -59, 34, 69, -6, -42, 16, -15,
    16, -6, -16, 0, 20, 12, -2, -25,
    -19, 5, -10, 24, -4, -7, -18, -24,
    4, 2, 6, 2, -1, 21, -20, 14,
    -4, -9, -2, 2, -52, 17, -21, -10,
    28, 23, -9, -11, 32, -10, 18, -25,
    3, -9, -6, -8, -5, -11, 5, -12,
    -1, 0, -1, 5, -3, -10, 12, 8,
    -13, 10, -22, -18, 7, -3, 1, 15,
    15, 20, -4, 8, -8, -17, 41, -10,
    -5, 13, 16, -23, -6, 1, 49, 1,
    -2, -4, 6, -3, -12, -7, -15, -3,
    -19, 30, 29, -30, 7, 8, 19, -33,
    14, 2, 0, -22, -5, -22, 8, -33,
    7, 16, -2, -14, -12, 34, 51, 9,
    -3, 2, 6, -2, -9, 14, 3, -28,
    -15, -34, 32, -25, 5, 0, 26, -17,
    19, -2, 6, -6, -11, 3, -6, -3,
    -19, 12, 21, 21, 31, 48, -58, 15,
    -4, -2, -1, 5, -17, 13, 10, 22,
    -22, -56, -5, 9, 11, -1, -24, -11,
    12, -20, 31, 47, -25, 3, 28, -18,
    -19, -18, 16, 6, 33, 10, 11, -10,
    3, -2, -8, 2, 15, -5, 10, -18,
    -21, 9, -20, -15, 6, 22, -5, 38,
    -22, 3, -17, 13, 0, -25, 3, 3,
    2, 4, 10, -12, -56, -34, -16, 14,
    0, -9, -3, 0, -19, -7, 3, 29,
    -2, 29, -13, -44, 3, -11, 21, -32,
    -11, -32, -40, -14, -33, -22, -40, -8,
    -8, -19, 23, -13, -27, 64, 29, -14,
    3, -3, 0, -4, -8, 19, 0, 14,
    7, 1, -6, -8, 34, 18, -17, -11,
    6, 25, 3, -15, 5, 56, 34, 27,
    11, -1, 14, -22, 4, 5, -12, 17,
    2, 4, 11, 2, -13, 33, -19, -10,
    -5, -27, -21, -13, -6, 54, 41, 7,
    71, 1, 24, 19, 37, 16, -8, 11,
    17, 9, 29, -32, 26, -5, 16, -14,
    7, -7, -19, 2, 14, 14, -5, -14,
    -12, 25, -11, -14, 8, 4, 13, 31,
    -19, -1, -12, 32, -28, 16, -2, 8,
    -24, -5, -6, 21, 8, 16, -17, 14,
    5, 1, 6, -1, 10, -9, -12, 3,
    14, 26, -19, 34, -6, -1, 25, 5,
    3, -11, 25, -1, -3, 0, 13, -11,
    2, -29, -1, -16, -34, -20, -29, 19,
    -4, 8, 6, 3, -4, 8, 36, 20,
    -20, -11, 1, 2, -15, -45, 11, -20,
    -20, 16, -30, 15, 21, -24, -10, 42,
    -24, -3, -6, 17, 0, 19, -9, 12,
    2, -1, -3, 0, 6, 0, -8, -10,
    -10, -11, 2, 12, -24, 4, 13, -10,
    -18, -34, 21, -6, 11, -23, -15, -26,
    38, 0, -8, 17, -7, -8, -12, 4,
    -4, -2, 2, 2, 5, -15, 2, -12,
    20, 20, -19, -16, 50, -34, -43, -17,
    -3, 5, 5, -6, -15, 41, 11, -28,
    -5, -12, -13, -19, -2, -12, -4, 36,
    -4, -5, 5, 2, -24, -9, 2, -5,
    -18, 11, -13, -7, -39, -6, 20, -14,
    21, -11, 37, -33, 11, 19, 8, -3,
    15, -11, 33, 6, 6, -5, 4, 0,
    -2, -7, -1, 6, -19, -16, 30, -7,
    -43, 6, -1, 10, 5, 11, 46, -46,
    2, -17, -2, 16, 15, -38, -3, -26,
    32, -30, 12, 10, 11, -6, -4, 10,
    10, 3, -1, -5, 1, -30, 1, -6,
    -18, -17, 14, -37, -37, -16, 19, -15,
    -20, -8, 17, 29, -4, 20, -13, -8,
    -34, 10, -12, 15, 0, 2, 19, 1,
    18, 12, 2, 2, 7, 7, -9, 32,
    37, -10, -12, 2, -6, 7, -47, 28,
    31, 10, 31, 2, 30, -34, 52, 4,
    3, -3, -10, -8, 9, 1, 25, -10,
    -4, -3, 4, -5, -9, -15, -2, -8,
    -14, 14, -25, -1, 0, 34, -6, 23,
    13, -19, 2, 11, 12, -30, -8, 15,
    -17, 0, -18, -4, 9, 10, 8, 15,
    -4, -1, 5, -10, 9, -19, 6, 23,
    -25, -3, -15, 14, -29, -24, -48, 16,
    29, 3, -14, 33, 14, -11, 3, 37,
    14, -10, 0, -17, -42, 7, -8, -7,
    -1, 4, -2, 3, -29, -3, -20, -7,
    16, 35, -13, -11, 39, 20, 14, 11,
    22, -6, 24, 4, 65, -32, 6, 3,
    2, -16, 6, -12, 7, 2, -21, -9,
    -7, -3, 5, 9, 9, 5, 18, -5,
    -13, 1, -13, -4, 26, -11, 23, -33,
    20, -9, 1, 14, 10, 5, 31, -40,
    -7, -18, -11, 0, -17, 8, 16, 10,
    -4, 0, 3, 13, -10, 16, 19, 19,
    -10, -7, 7, 20, 25, 14, -7, 10,
    -8, -6, 28, -27, 2, -22, -10, -35,
    22, -13, -31, -28, -8, -6, 56, -1,
    -2, -10, -11, 10, -13, 3, 6, 18,
    -2, -49, 4, -11, -59, -4, 3, 39,
    -1, -37, -19, -23, 31, 15, -25, -16,
    25, -14, -30, 28, -13, 4, -3, -5,
    -4, -8, -11, 15, -6, 20, -21, -10,
    -9, 20, -4, -20, 19, 9, -4, -33,
    -17, -7, 55, -11, 10, -13, -1, -29,
    -4, -14, 28, 11, -9, 13, 36, -9,
    2, -3, 1, 5, -10, -5, 3, -9,
    -27, 30, -14, 25, 11, 0, 8, -28,
    -42, -38, -27, 3, -36, -13, -6, -5,
    -14, 2, 37, 20, -12, -25, 18, 44,
    -8, 6, 5, -5, -40, 2, 5, -7,
    -16, -13, -29, -3, -28, -24, 2, 1,
    -17, -5, 34, -32, 5, -32, 39, -7,
    -26, 34, 19, 23, 17, -19, -17, -45,
    7, -4, 1, 5, 7, 12, 5, 15,
    34, 26, 12, 12, 5, 13, 18, -22,
    26, -23, -36, -28, 50, 3, 28, 12,
    -10, 3, -4, 9, 8, -11, 11, -32,
    0, -1, 6, -9, -18, 3, -14, 2,
    -24, 3, -27, -5, -12, -37, -1, 26,
    2, -1, 7, 23, -13, -53, 4, -19,
    6, 2, 22, -13, -8, -34, -22, 19,
    -5, 1, 3, 7, 3, 3, -4, -12,
    -5, 15, -15, -4, -13, -17, 1, 47,
    -9, -1, -34, 44, -12, -14, -36, -5,
    0, 22, 5, 4, 0, -28, -30, -11,
    -7, 4, -7, 1, 5, 6, -3, 20,
    -15, -2, -19, -12, 12, 15, 45, -5,
    -4, 2, 13, -48, -21, -2, -3, -6,
    -7, 20, 3, 1, -11, -45, -16, -18,
    3, 2, -7, 5, -3, 0, 4, 9,
    8, -2, 15, 6, -9, 5, -10, -8,
    -3, 3, 6, 39, 6, 4, -7, -5,
    -15, 10, -39, -6, -18, 8, -22, 25,
    0, -7, 8, 6, -4, 5, -19, 41,
    35, 7, 41, 25, -48, 21, 12, -42,
    25, 6, -9, 2, -32, -7, 26, -31,
    11, 8, 22, 18, 9, 16, 4, 25,
    -7, 3, -1, -9, -14, 14, -9, 9,
    -1, -24, -43, -16, -11, -5, -10, 6,
    18, 2, -12, -3, 5, 1, -23, 19,
    -1, -14, -9, -25, 10, -2, 25, 1,
    -3, -2, 1, -7, 20, 0, -1, -40,
    1, 15, -12, -5, -16, 2, -11, 7,
    -1, -4, 3, 13, 0, 4, 61, 57,
    2, -25, 6, -21, -19, -43, -9, 21,
    -6, 1, 6, 4, 6, -30, -22, -18,
    -38, 21, -28, -24, -7, 15, -7, -38,
    7, -17, 3, 13, 20, -39, 20, -23,
    -10, -21, -4, 8, 31, 23, 16, 22,
    3, -2, -5, -3, -21, -9, 18, 10,
    -27, -9, -78, 12, 17, 30, -14, 13,
    47, -11, 24, 40, -38, 3, -15, -31,
    -2, 1, 19, -21, 18, 20, -25, 29,
    11, 12, -3, 2, -21, 12, 9, -1,
    8, -7, -25, 14, 5, 25, -18, 3,
    -43, 8, -20, -3, 61, -20, 28, -3,
    -4, -11, 5, 7, -24, 23, 10, -6,
    9, -8, -2, 3, -38, 17, -9, 2,
    -15, 4, 7, -39, -2, -49, 10, -10,
    -1, -29, -44, -21, 18, -18, -47, 34,
    -13, 26, -24, -13, -31, 13, 25, 18,
    6, -12, 7, -1, -2, 2, -13, -17,
    13, -40, -33, 44, -30, 27, -17, -16,
    28, -8, 16, -8, -3, 22, -4, -17,
    20, 11, 0, 9, 15, -5, -8, -12,
    6, -3, 9, 4, -18, 40, -13, 28,
    -24, 40, 12, 4, -24, -3, 2, -24,
    48, -8, 25, -14, 22, 9, 12, -24,
    12, -15, 42, -10, 46, -26, 10, 9,
    8, -4, -33, 4, 3, 9, -25, 10,
    -33, 3, -5, 27, -15, 12, -1, -30,
    -39, -35, 0, 45, 29, 51, 60, 11,
    27, 16, 6, 2, 10, -2, -18, 2,
    0, 3, -3, -4, -1, -24, -15, -19,
    -7, -47, -63, 19, -4, 20, -12, 11,
    -9, 5, -3, 15, -16, -2, 35, 25,
    22, -14, 20, 3, 12, -18, -16, -46,
    14, 8, -4, -2, 1, -19, 17, -4,
    29, 2, 4, -26, -27, -8, 22, -27,
    -22, 23, -50, -14, 23, -6, -41, 1,
    -14, 16, -20, -1, -18, 2, 21, 4,
    2, 2, -7, 5, -19, 7, -7, 8,
    -10, -26, 47, 24, -50, -19, 14, -18,
    20, -19, 7, -3, -5, -31, -61, -19,
    24, -2, 14, -12, 14, -30, 34, 4,
    4, 1, -5, 3, 14, -30, -33, 6,
    63, 33, -28, 19, 53, 7, -7, 11,
    5, 6, -13, -8, 11, 61, 13, -12,
    9, 24, 16, 1, -18, -15, 15, 34,
    8, -11, 2, -6, 9, -21, -7, 8,
    -18, -12, 11, 6, -2, -9, 32, -15,
    15, 4, 22, -14, -4, 26, 26, -3,
    2, -20, -32, -14, 21, -4, 30, 11,
    -2, -6, 1, 3, -5, -29, 3, -14,
    -12, 16, -3, 51, 13, -4, 6, 2,
    1, 3, 5, 1, -24, 31, -4, -23,
    10, -31, 14, 4, 15, 53, -20, -2,
    12, -8, 6, 0, 26, 25, -20, -2,
    -67, -11, 27, -14, -17, 18, 28, -16,
    -38, 26, -7, 35, 8, 9, -20, 70,
    -10, -1, 7, 32, 5, 7, 13, 19,
    3, -6, 3, -3, -7, 0, -2, -5,
    37, -28, -2, 9, 4, -6, -48, 91,
    20, 17, 25, -12, 5, -3, 45, -31,
    17, 0, -10, -33, 4, -4, 27, -3,
    -7, 2, 6, -8, 1, 5, -11, -4,
    -13, -23, -22, 3, 26, 25, 33, 54,
    10, 9, 36, 0, 3, -34, 28, 9,
    -33, -24, -3, 24, 3, -17, -25, -25,
    2, 0, 0, -17, 3, -4, -9, 4,
    -8, 26, -34, -37, -25, -9, -23, 11,
    27, -1, -16, 34, -3, 4, 26, -27,
    26, 6, 8, 5, -38, 8, -35, -23,
    3, 5, -3, 1, -8, 8, 22, -17,
    9, 14, -6, -35, 64, -1, -21, 16,
    -11, -9, 10, 6, 11, -19, -5, -3,
    8, -16, 21, -5, 1, -30, 6, -15,
    -4, -3, 0, 11, -1, -3, 22, -7,
    -5, -41, -18, -1, -31, -20, 14, -15,
    19, -16, 15, 21, 24, 8, 24, -50,
    1, -15, 25, -32, -6, -3, 38, 57,
    -5, -7, -8, 0, -11, 5, -4, 20,
    -28, -16, 12, 44, 16, -6, -41, 13,
    17, -2, -29, 0, -7, -5, -10, -10,
    6, 21, -6, 24, -2, -40, -7, -26,
    -3, -5, 9, -4, 13, -9, -9, 1,
    17, -30, -36, -30, 13, -7, 10, -14,
    17, -24, 5, -39, -27, 2, -30, -10,
    16, -16, -12, 8, -3, 9, 33, -31,
    -6, 0, -17, 1, -11, -4, -4, -10,
    28, 22, -11, -31, -14, -19, -12, -16,
    4, 10, 29, 2, 26, -10, -38, -17,
    -6, -27, -25, 0, -25, -7, -9, -10,
    2, -3, 4, 4, -13, -13, 9, -13,
    9, 44, -14, 27, 5, 37, 19, -14,
    -18, -11, -5, 22, -43, -5, -26, -45,
    1, 25, -10, 15, -12, -36, 17, -6,
    -3, 4, 6, -1, 9, 7, 16, -3,
    21, -12, -13, -11, 15, -35, 10, -39,
    8, 4, 14, -27, 48, -23, 50, -55,
    -32, -27, 4, -4, 17, -13, -8, -41,
    4, 7, -1, 6, -8, 31, 8, 14,
    37, 17, -13, 33, 8, -56, -14, 51,
    1, -9, -32, 52, 37, 19, 78, -31,
    -25, -20, 9, -21, -3, -3, 3, -9,
    0, -6, 6, 1, -22, 12, -33, -17,
    -15, 33, -5, 19, -32, -31, 26, 9,
    -15, 21, -12, 5, -5, -35, -23, -21,
    4, -21, -10, -1, -10, -2, 14, 8,
    -1, -5, 6, 3, 10, 7, 41, -8,
    24, 13, 34, 1, -38, -13, -6, -7,
    -25, -3, -12, 26, 18, -9, -7, -62,
    28, 1, -13, 5, 28, -11, 10, 20,
    -5, 13, 4, -1, 11, 7, 17, 29,
    3, 28, -1, -52, 35, 26, 12, -24,
    9, 16, -4, -56, -57, -48, 17, 6,
    -3, 18, -18, -5, 23, -28, -2, 9,
    -3, -3, 15, 6, 18, -1, -1, 16,
    40, -42, 29, 30, 1, -3, 4, 36,
    -11, 3, 9, 56, -31, 0, 33, 42,
    -3, -2, 6, -10, -6, -2, -70, 18,
    10, -5, 2, -3, 11, -4, 41, -7,
    36, -6, -31, -63, -36, 11, -35, -94,
    12, -49, 2, 2, -5, 36, -20, -9,
    3, -18, 1, 21, -57, 59, 49, -4,
    13, -15, -11, -2, 10, 4, 0, 4,
    36, 56, 26, -17, -3, 12, 0, -15,
    21, 7, -7, -4, 78, 13, 1, 0,
    1, 9, -50, 16, -35, 23, 30, 21,
    0, -6, -15, 13, -23, 5, -8, 26,
    -30, 6, -25, -7, 4, 10, 34, 17,
    -27, 10, -21, 3, -30, 32, 41, 36,
    -9, 14, 11, 23, 10, -19, 9, 52,
    -2, -17, -11, -7, -10, 33, -22, 14,
    55, -8, -5, 14, -7, -29, -2, 8,
    35, -50, -44, -36, -52, -18, 50, 57,
    17, -41, 16, -69, 9, -26, -50, 39,
    8, -2, -20, 15, 9, -27, -49, -3,
    32, 18, -1, 10, -18, 54, -29, -22,
    -27, 63, 9, 14, -41, 61, -67, -21,
    47, 10, -19, -16, -7, 29, -3, 16,
    -15, 10, -8, -7, -3, -13, -7, -25,
    -8, -9, 82, -58, 8, 83, -12, 28,
    -26, 69, -1, -48, 38, -17, -5, 46,
    34, -12, 20, -12, -11, 39, 19, -27,
    18, 7, -7, -22, 23, 9, -15, 28,
    -7, -86, 2, 37, 28, -105, 10, -59,
    25, 31, -84, 4, 34, 18, 61, -5,
    -20, 12, -32, 40, 36, 93, -44, 44,
    -13, -20, -18, 7, -78, 18, -35, -29,
    -46, 32, -71, -45, -1, 1, 14, -11,
    8, -29, -37, 2, -28, -51, 57, -55,
    11, -3, -42, 16, 15, 95, 39, 13,
    1, -27, -17, -7, -11, -14, -37, -35,
    -1, -63, -3, 3, -36, -53, -3, -29,
    45, 6, 29, -15, 6, 11, 22, 8,
    -5, -12, 17, -3, 42, -40, 96, -26,
    27, -12, -100, 9, 12, -2, -12, -7,
    17, 20, -13, -28, -13, 26, 13, -10,
    -53, -76, -32, 63, 38, 12, 7, 12,
    1, -3, 15, -65, -29, 74, -14, 25,
    -11, 11, 13, -20, -49, 16, 26, 11,
    1, 41, 11, -65, 0, 70, 19, 38,
    4, 3, 19, 29, -45, -31, 11, 12,
    -20, 10, 20, 59, -32, 7, -19, -70,
    104, 25, 3, -36, 51, 12, 44, -1,
    -5, -1, 45, -10, -19, -10, 33, -41,
    -63, -9, -48, -18, 50, 41, -60, -3,
    2, 13, 5, -3, -19, -68, 0, 25,
    17, -13, -12, -1, 17, 17, -30, -54,
    109, -29, -9, -42, -63, 11, 48, 17,
    -9, -29, 78, -20, -18, -74, -27, 41,
    -13, 38, -15, -7, 20, 15, 41, -15,
    -9, -3, -3, 12, -8, -49, 28, 33,
    -52, 44, 50, -50, 23, 5, 28, -13,
    -28, 5, -5, -5, 48, 60, 34, 16,
    11, 35, 43, 11, 8, 3, -24, 19,
    -11, -1, 1, -17, 13, 33, -20, -5,
    -56, 24, -58, -29, 37, -17, 3, 13,
    10, 17, 74, 13, -26, 57, 16, 0,
    -11, -11, -3, -12, 34, -12, 1, 7,
    10, -3, -22, -9, -10, 8, 21, 10,
    -71, 7, 28, -11, 17, -66, 8, -44,
    -28, 29, -26, 11, -58, 89, 7, -7,
    -43, 5, -44, 14, -22, 1, 28, 8,
    0, -17, 3, 0, -6, 1, -14, -9,
    0, -71, -34, -16, -5, 38, -26, 1,
    -41, -23, -17, -41, 9, -18, 10, 51,
    52, 1, -9, -17, 37, -16, 24, 9,
    -64, -6, 9, 31, 74, -28, 7, 21,
    -37, 49, -17, -59, 17, -18, -43, 67,
    11, 21, 21, 15, -4, 7, 11, -21,
    55, 40, 12, 12, -21, 8, 4, -27,
    -11, 5, 14, 9, 39, -10, -6, 15,
    18, -13, -30, 11, -53, 41, 13, 44,
    37, 77, -8, -7, -55, -65, -24, 0,
    23, 11, 18, 28, -17, -8, -28, -6,
    -7, -32, 18, -37, 41, 41, 5, -43,
    17, -19, -6, -103, 19, 4, -4, 41,
    -4, -22, -9, -6, 20, 12, 48, -67,
    39, 1, 33, 22, 19, -15, 10, -24,
    9, 5, 4, 0, -5, 6, 104, -2,
    -42, 0, 63, 17, 33, 26, -100, -16,
    -5, -14, -30, 22, -40, -4, -52, 13,
    7, -2, -39, -8, -13, -23, -21, -33,
    -1, 2, 7, 12, -7, -23, 17, 5,
    15, -25, 20, -22, -31, -56, -24, -41,
    8, -41, 52, 16, -2, 29, -7, -40,
    16, 25, 0, 23, 16, -35, 36, -25,
    12, 37, 37, 13, 14, 10, 89, 18,
    26, 19, -28, -55, 27, -23, -49, -5,
    -48, 32, 7, -17, -16, -2, 32, -20,
    -30, 12, 36, -40, 79, 8, -36, -48,
    -5, -2, 38, -9, 6, 2, -13, -3,
    -42, 37, 19, 60, -21, -19, -16, 2,
    -7, 5, 35, -29, -50, 29, -11, 10,
    -18, -11, 5, -26, -5, 8, 64, 7,
    -28, -6, -7, -21, -45, 10, -1, -14,
    67, -26, 29, -24, -12, -22, 19, 29,
    -9, -29, 66, -4, -33, 54, -47, 1,
    2, 8, -25, 12, 16, -11, -20, 7,
    7, -13, -10, 5, 10, -10, -30, -19,
    23, 9, 4, 12, -17, 63, 34, -8,
    34, -8, 7, -3, 6, -17, -9, -68,
    35, -5, 7, -17, 32, 8, 2, 30,
    -15, -27, 4, -9, 1, -11, -4, -33,
    26, -3, -12, 56, 17, -45, 15, -45,
    -36, -10, 44, 11, 127, -21, 32, -12,
    -29, -24, -91, -38, 25, -17, 37, -93,
    5, 7, -20, 4, -2, -13, -5, 2,
    -69, -60, -65, -48, -3, -37, 22, 22,
    15, -17, -49, 64, 39, 12, 26, -32,
    -42, 5, 11, -15, -37, -5, 50, -41,
    11, -6, 4, 6, -17, -9, 17, 21,
    27, -44, 33, -45, -25, -11, 5, -4,
    21, 10, -16, -35, 21, -15, -20, -7,
    -1, -23, -52, 5, 30, 12, 26, -3,
    11, -14, 27, -2, -13, -3, -17, -27,
    6, -18, 32, 20, -38, -4, -47, 38,
    -4, 10, -25, -47, 14, -5, 3, -47,
    11, -22, -27, -32, 25, 43, 24, -50,
    3, 9, 3, -19, 19, -32, -68, -61,
    5, -40, -67, 93, 7, 51, 89, -18,
    70, -8, -57, -62, -2, 1, 21, 61,
    -16, -35, 2, 5, -14, -10, 19, 11,
    -20, -6, 38, 9, -5, 12, 14, 44,
    -13, 93, 20, -16, 19, 20, -8, 19,
    -14, 3, 32, -51, -8, -4, 21, 2,
    1, -4, -27, 31, 18, 11, 28, -31,
    -11, 15, 22, -18, -12, -8, -7, -7,
    14, 2, -18, -2, 16, -2, -29, 21,
    -27, -35, 23, -27, 9, 6, -7, -13,
    -30, -8, -9, -3, 50, 21, 15, -15,
    53, -16, -43, -6, 26, 5, -6, 27,
    -11, 1, 15, -4, 34, 13, 6, 21,
    20, 15, -24, -18, -34, -10, -35, -23,
    8, 14, 6, -33, 26, 2, 19, -1,
    19, -6, 11, 11, 31, -2, -11, -3,
    1, 2, 16, -5, -16, -22, -9, -19,
    18, 36, 38, 9, -11, -1, 7, -3,
    -20, 12, -10, -27, 16, -20, 31, -20,
    20, -3, -6, -13, -4, -2, -14, 5,
    9, -16, -6, 9, 10, -37, -24, 21,
    9, -40, 1, -42, -7, 12, 14, 1,
    35, -15, -39, 2, 8, 13, 46, -29,
    -11, -19, 0, -13, 27, 2, -4, 18,
    -2, 11, -40, -23, -39, -16, -4, -24,
    59, 2, -4, 61, -3, 41, -3, -24,
    3, 31, -3, 1, 48, -50, -21, -15,
    -11, -11, 42, -6, -27, -35, -17, -14,
    5, 3, 2, 1, -13, -31, -11, 40,
    -15, -23, 7, -7, -4, -1, -13, -12,
    9, -11, -29, 38, -5, -28, -16, -10,
    -1, -3, 25, -15, 16, 8, -24, -23,
    3, -16, 7, 29, 30, 43, -12, 23,
    16, 18, 8, 3, -10, 6, 5, 12,
    17, 6, -28, 26, -2, -2, -23, -9,
    3, 13, -33, 9, 22, 3, -17, 4,
    16, 3, -11, 13, 63, -36, 22, 2,
    1, -23, -9, 24, 4, 2, 6, -7,
    11, -40, -46, 10, -11, -21, 2, -11,
    -26, -20, -18, -5, -4, 3, 8, 18,
    11, 11, -15, 0, 5, -11, -1, -24,
    21, -37, -16, -39, 6, 2, 10, -1,
    -19, -1, 29, 3, 17, 3, 3, 0,
    6, 2, 2, 8, 5, 24, 11, 4,
    -17, -24, 6, -4, 29, -15, 22, 26,
    -55, -22, -22, 49, -4, 0, 10, -3,
    15, 11, -28, -32, 28, -11, 33, 20,
    -21, 2, -2, 40, 2, -2, -5, 7,
    5, 8, -9, 11, 28, -12, 5, -9,
    -18, -9, -25, -39, -7, 18, 10, 13,
    -24, 17, -5, -27, -17, -25, 6, -28,
    10, 9, 7, -10, 11, 3, 12, 17,
    -4, 7, 1, 2, -36, -6, -19, -33,
    8, 3, 8, 41, 4, 10, 23, -20,
    0, 27, 46, -38, 35, -4, -16, -2,
    -6, -40, 4, 6, 3, 32, -23, 7,
    9, -13, -4, -8, 33, -12, -10, -31,
    75, 40, -28, -17, -7, 1, 1, -23,
    27, -4, 13, 40, 3, 11, -3, 25,
    13, -14, 18, -5, -18, 18, -4, -4,
    13, -12, 12, 17, 13, -9, -23, -9,
    -36, -19, -51, -7, -21, -17, 12, 19,
    -3, -6, 0, 3, -17, 29, -31, 12,
    6, -21, 3, -11, 13, -5, -3, 14,
    1, -4, 11, 15, -11, -26, -13, 20,
    -6, 33, -1, -5, -1, -18, 31, 30,
    -50, 10, -38, -36, 3, -6, -16, -8,
    43, -5, 16, 0, 24, 3, -4, -9,
    -23, -11, 11, -8, 21, -4, -7, 22,
    18, -9, 25, -24, -6, 33, 11, 0,
    -23, -13, -7, -8, 48, -8, 27, -5,
    -2, -13, 0, -17, -23, -12, 10, -10,
    24, 6, -11, -14, 9, -2, -22, -9,
    -18, -27, -29, -6, -34, 17, 54, 7,
    -39, -12, -36, 46, -2, 47, -7, 1,
    7, -26, 7, -14, -2, 3, -15, 18,
    -9, 21, -37, 15, 7, 17, 10, -3,
    -55, 10, 20, -3, 21, 0, -19, -18,
    -8, 44, -32, -45, -1, 1, -7, -18,
    -24, 36, 25, -8, -6, -14, -8, 3,
    -27, 16, -20, 16, -20, 25, -4, -15,
    66, -41, 3, 10, 18, 11, 46, -37,
    25, -38, -61, -21, 1, 41, 4, 51,
    9, 29, -1, -29, -28, -17, 10, 44,
    20, 13, -11, -8, -46, 34, -8, -15,
    11, -26, 1, 18, -28, -12, 26, 2,
    -25, -7, 20, -24, 4, -2, 3, -32,
    -28, 18, 15, 45, 6, 12, 5, 23,
    -4, 1, -18, 1, -23, 1, 12, -22,
    -58, 17, -54, -7, -14, -16, 4, 34,
    -16, -12, 13, -13, 7, -18, 5, -26,
    11, -6, 7, 8, 4, -3, 9, -19,
    7, -4, 17, -7, 6, -35, 26, -2,
    5, -40, 45, 36, -46, -37, 21, 0,
    7, 3, -11, -20, 34, -9, 25, -22,
    -4, 27, 9, -2, 7, 5, -2, 5,
    -14, 17, -5, 10, -9, -23, -16, 33,
    -12, -53, 52, 4, -19, 14, 6, -14,
    -33, 20, -34, 22, 22, 9, 50, 22,
    -9, -6, -20, 25, -23, -3, -17, -17,
    21, -8, 1, 1, 7, -15, -50, -2,
    27, 21, -29, -39, 58, 12, 7, -1,
    14, -24, 43, -14, -15, 23, 56, 10,
    17, 12, -15, 22, 23, 7, -34, -33,
    -18, 18, 0, 22, -3, 35, 23, 31,
    2, 11, 28, 6, -9, -14, 20, -9,
    -6, 28, 3, 1, -2, -19, -48, 10,
    2, -13, -11, 15, -3, -3, 17, 1,
    14, -17, -16, -10, -33, -12, -55, 3,
    -1, -12, 23, -14, 19, -1, -10, 11,
    28, 45, 15, 13, 64, 17, -20, -10,
    24, 2, -24, 27, -8, -6, -18, 2,
    4, 2, 27, 0, -25, 26, 21, 5,
    -15, 10, 2, -22, 11, 9, 23, -14,
    -33, -19, -15, -42, 9, 6, 48, -38,
    9, -16, -30, -25, -12, -16, 2, 26,
    -44, 7, -1, -3, -25, -11, -18, -21,
    -17, -22, 44, -25, 10, 20, 36, 2,
    -59, -16, -9, 18, 20, -19, 68, 27,
    24, -26, 21, -12, 12, -20, -15, -7,
    -22, 4, -11, 9, -23, -17, -24, 6,
    14, -15, -2, 15, -5, 4, 23, -5,
    12, 4, -2, 16, -26, -4, -49, -10,
    13, -14, 21, -12, -16, 10, 26, -4,
    4, -7, 19, 6, 12, -6, -7, -9,
    -10, 51, 6, -3, -16, -11, 20, -40,
    15, -1, 42, -2, 11, -5, 24, 12,
    0, -4, -13, -6, -4, 13, 9, -1,
    34, 4, 14, -6, 3, 44, 47, 5,
    -28, -19, -33, -4, 9, -63, 7, 1,
    8, 29, 21, -21, -15, 6, -15, 26,
    3, -17, 13, -6, -12, 15, -21, -9,
    13, 8, 15, 8, 11, 16, -20, 29,
    30, -19, 3, 11, -4, 12, 48, 23,
    9, 13, 28, -6, 15, 1, -3, -8,
    -7, 2, 3, 3, -8, -5, 27, -36,
    7, 5, 10, 5, -9, -2, -11, -62,
    -4, -26, 25, -6, -25, 58, -12, -4,
    45, -23, 1, -1, 3, 8, 10, -45,
    49, -23, -22, -11, -2, -27, -1, 5,
    11, -18, -5, 0, -27, 30, -7, 11,
    -15, 22, 35, -5, -20, -6, 41, -29,
    -16, 10, -28, -2, 40, -3, 2, -12,
    35, -16, 10, -49, 46, -11, 8, 15,
    0, -17, -12, -7, 10, -16, 19, -8,
    -10, 58, 17, -52, -23, 23, -12, -11,
    17, -24, 16, 6, -12, -10, 51, -20,
    8, -24, -2, -12, -28, -17, 4, 19,
    -1, 22, 10, -24, 21, -1, 32, 32,
    -24, -4, 47, -35, 3, 21, 6, 24,
    15, -26, -34, 23, -1, -6, -7, -6,
    37, -7, 71, -6, 10, 1, 22, -1,
    12, 9, -61, -6, -7, 0, -46, 21,
    24, -24, 6, 61, -42, 33, 31, 7,
    -12, -13, 4, 26, 42, -24, 29, -37,
    -44, 15, -10, 24, -20, -17, -14, 2,
    13, -23, -7, -11, 23, -47, -16, 1,
    -16, 20, 5, 2, -36, -1, -23, -12,
    7, -19, -16, -15, 17, -24, -17, -19,
    50, 3, 17, -31, 5, 11, -11, -7,
    10, -6, -12, 16, 3, 1, -25, 14,
    -8, -30, -19, 47, 7, 18, -7, 32,
    9, 21, 1, -6, 19, -10, -5, -53,
    -33, -32, 5, 20, 6, -39, -15, -13,
    7, 8, 4, -1, 40, 1, 7, 25,
    -7, -15, -69, -8, 3, -44, 1, -9,
    2, 53, 66, 0, -23, 17, 50, -5,
    -14, -17, -58, 1, 8, -9, -14, 14,
    22, 10, -9, 2, 10, 18, 47, 26,
    -12, -16, -11, -5, 17, 25, -3, 1,
    -1, 2, 38, -1, -17, -11, -4, -3,
    6, -14, -24, 5, 19, 19, 9, 17,
    -13, -13, -7, -21, -6, -14, 29, 12,
    -6, -23, 8, 10, 0, -7, -11, 29,
    8, 4, 53, -8, 33, 5, 69, 22,
    -23, 1, -7, -11, 1, -9, -34, 25,
    8, -2, -2, 4, -28, -20, -36, -12,
    8, 1, 18, -54, -11, -5, -6, -1,
    -3, -9, 5, -40, -62, -43, -4, -14,
    12, -16, 17, 21, 1, -3, 24, 20,
    4, 13, -5, 2, -37, -16, -8, 6,
    10, -18, -4, -21, -6, 24, -18, 17,
    34, 14, -13, -13, 23, -15, -16, 2,
    43, 15, -26, -16, -9, 1, -7, 5,
    -18, 2, -29, 3, -2, 0, 19, -7,
    60, -18, 35, -9, 12, -29, 7, 6,
    23, 58, -26, 16, 7, 35, -13, 20,
    50, -5, -27, -26, -10, 26, -36, -22,
    -16, -30, 17, 10, 19, 28, -39, -7,
    -15, -32, 16, -6, -6, -30, 2, -39,
    -6, -5, 3, 21, -11, 36, 9, -2,
    1, -40, 17, -28, 20, -10, -16, 6,
    -4, 4, 7, -47, 7, -23, -8, 18,
    -47, 32, -7, 34, -44, -1, 12, 9,
    1, -10, -47, 21, 2, -14, -16, -2,
    4, -1, -24, 10, 4, -2, -35, -20,
    -21, -1, -16, -36, -22, -24, -41, 7,
    15, -31, -24, -1, 19, -16, 18, -11,
    20, -53, 15, -20, 39, -54, 28, -9,
    -35, 36, -4, -33, -19, -4, 2, -9,
    -3, 7, 4, 2, 51, 0, 32, -17,
    -10, 0, -26, 17, -18, 10, 25, 24,
    -30, -12, -51, 15, -12, 1, 11, -11,
    2, 23, -3, -37, -22, -14, -5, 24,
    10, -2, -35, -3, -23, -9, 21, 22,
    5, 32, 14, 5, -8, -6, 1, 12,
    -25, 15, 8, 4, -14, -1, -31, -15,
    7, 17, 29, 9, 12, -21, -9, -9,
    -4, 24, -35, 18, -46, -3, -16, -8,
    9, 6, -13, 27, -26, -20, 36, 30,
    -22, -37, -3, 48, -21, 11, 39, 58,
    -19, 1, 5, -8, 5, -21, -7, 11,
    0, 8, -1, 19, -6, 23, -21, 25,
    8, -13, -13, -5, -7, 0, 11, -33,
    -6, -1, -26, 27, 23, 5, -4, -15,
    1, 56, 12, -19, 4, 9, -3, 41,
    19, 2, 16, -16, 22, -13, 1, 6,
    7, -30, 3, -23, -22, -22, 16, 31,
    11, -7, 5, -7, -14, -6, -14, -29,
    -25, 19, 17, -11, 33, 37, 24, -16,
    2, 36, 15, -24, 12, 6, 17, 13,
    21, -1, -24, 25, -47, -58, -8, 20,
    35, 15, 5, -29, 32, -34, 15, 2,
    -17, -7, -10, -5, 23, -6, -6, -6,
    -12, 3, 7, -6, 7, -20, -36, 26,
    -20, 14, 47, 22, -18, 52, 15, -36,
    -7, -19, -57, -9, 9, 15, -25, 12,
    -44, 2, 10, 0, -19, -11, 17, -27,
    19, -10, 8, -23, 40, -62, 29, -7,
    -14, 20, -4, -33, 30, -46, -5, -24,
    -58, 11, 4, -47, 11, -5, 30, -1,
    30, -6, 34, -13, 11, 6, -14, -58,
    -10, 22, 15, -5, 6, 19, 11, 19,
    -10, -20, -6, 3, -18, 10, -7, 11,
    -9, -10, 31, 4, -2, -7, -40, 11,
    -3, 6, -19, 1, 36, 1, 19, -15,
    -14, -4, -12, -6, 0, 10, -10, -3,
    -2, -14, -17, -5, -1, -41, -7, 29,
    -10, 79, -13, 22, 31, 24, -8, 10,
    39, -8, 18, 7, -19, 12, -1, -2,
    -9, -14, 1, -15, 21, 13, 0, 14,
    -30, -50, -18, -21, -2, -16, 17, 1,
    -4, -16, 35, -10, -2, 13, 43, -29,
    10, 15, -4, -6, -14, -11, 3, 22,
    -10, 5, 13, 15, -3, 32, 27, 14,
    48, 6, 8, -19, 13, -1, 28, -12,
    -31, 3, 15, 25, -3, -11, 43, 0,
    17, -23, -13, -16, 18, 4, -40, 11,
    -5, -9, -12, 5, 40, 15, 2, 7,
    5, 15, -7, 8, -39, -19, 30, 7,
    -1, -17, -19, -4, -22, 3, -44, -4,
    7, 8, 3, -32, 0, -5, 25, 18,
    10, 4, -12, -12, 7, 4, -8, -18,
    -24, 21, -50, 3, 20, 12, 2, -27,
    29, -3, -31, 14, 19, 11, 27, 12,
    -9, -18, 25, 18, -15, 2, -2, -26,
    12, 11, 10, -22, -15, 22, 19, 20,
    16, -36, -44, -5, 4, -64, -8, -9,
    -38, -22, 24, -20, -2, 5, -8, 53,
    -8, -18, 33, -38, -3, -7, -56, -43,
    -12, 24, 1, 0, -5, -25, -29, 46,
    14, -34, 30, 22, 27, 12, 48, 60,
    -23, -17, 31, 57, 30, 5, 31, -5,
    -33, 22, -44, -20, -13, 17, 34, -68,
    8, -5, -31, -31, -9, -24, 17, -19,
    18, 53, 35, -3, 12, 57, 0, 3,
    40, 37, -33, -3, -34, -35, 41, -74,
    42, 71, -16, 9, 25, -10, -3, 6,
    -7, 24, 6, 26, 17, 16, 10, 9,
    34, 7, -4, -9, -15, -14, 56, -24,
    31, 10, 49, 37, 83, 0, -25, -11,
    23, -40, -108, -7, 119, -33, -18, 19,
    27, -2, 11, 32, 35, -24, 35, 1,
    -36, 30, -48, -27, -32, 3, -55, -45,
    5, 45, 13, -8, -14, -12, 96, 21,
    0, -18, 10, 52, -27, -6, 7, -20,
    -5, -21, 1, -3, 16, 42, -2, -16,
    38, 21, -3, -21, -2, 47, -33, 17,
    -20, 32, 8, 65, -30, 0, 16, -5,
    46, -18, -49, 41, 70, 34, -1, 15,
    15, -26, -6, 12, 11, 71, 25, -64,
    -20, 41, -14, 18, -60, -12, 50, 22,
    -21, 51, -3, 36, 16, 8, 88, -83,
    -27, 20, -71, 20, 3, -42, -43, -21,
    -18, -11, -27, -5, 72, -4, -43, -86,
    23, -88, 7, 53, -29, 34, -24, -21,
    42, -51, -36, 8, 96, -49, 1, -19,
    -66, -6, 19, -11, 4, 8, -15, -5,
    68, -8, -2, 37, 17, 4, -13, 28,
    -61, 41, 15, -58, 22, -48, -28, 25,
    -83, -24, 47, -33, 36, 10, -30, -70,
    -72, -24, 40, 16, 1, -28, -26, -23,
    -9, -19, 20, -11, -62, 37, -26, 34,
    -24, -20, 6, -3, 13, 17, 26, -24,
    -11, -59, -2, -34, -19, -23, 20, -7,
    -30, 42, -52, 2, 15, -17, 42, 50,
    -6, 17, 10, -16, 32, -70, -86, 8,
    -32, -28, 4, 34, -2, 21, 34, -58,
    26, 14, 56, -50, -53, -16, 26, -17,
    6, -13, -38, 1, 43, 25, -2, -9,
    -22, -11, 6, -3, 8, -20, 62, 24,
    74, -51, -94, 39, -22, 25, -26, 60,
    -6, 36, 36, 71, 48, -11, 27, 38,
    -48, 93, -1, 44, -39, -81, -74, 9,
    14, 10, -53, 4, -17, 6, -26, 12,
    41, -28, 88, -11, 52, 6, -6, -33,
    5, -46, 16, 36, -91, -38, 14, 6,
    14, -27, 45, 24, 6, 6, 24, -1,
    7, 16, 18, 56, -22, -1, 48, -49,
    -19, 82, -7, -49, -68, 25, -33, 21,
    -24, 22, -42, -51, 70, 13, 9, -31,
    37, 12, -19, -9, -6, 53, -49, 10,
    -15, 10, -6, -8, 13, 81, -4, -63,
    -19, -35, -34, 3, 5, -29, -16, -24,
    -4, -45, 3, -5, 6, 49, 40, 65,
    9, 78, -96, -33, -13, 10, -30, -28,
    -50, -19, 4, 6, 0, 2, 22, 50,
    100, -52, 14, 8, -4, -21, -50, -24,
    35, -11, -52, 49, -4, 53, 67, -27,
    8, 7, -31, 52, 29, -3, -40, -23,
    54, -10, -31, -9, 4, -26, 74, -24,
    -115, 52, 46, -29, -8, -14, 1, 3,
    -82, -47, -11, 19, 7, -16, -20, 20,
    -23, 7, -5, 11, 12, 2, -18, -37,
    -60, 5, 7, -36, -30, -29, -4, 5,
    -29, 13, -33, -7, 37, 30, 8, -19,
    36, 77, 22, 2, -13, -34, 62, -8,
    -45, -11, -7, -40, -22, -23, -8, -19,
    -34, 17, 1, 18, -9, 64, 48, -13,
    -52, 10, 17, -40, -39, 2, 23, 61,
    -70, 24, -13, 19, 0, -17, -2, 8,
    14, 90, 9, 45, 36, -20, 0, -18,
    116, 13, 3, 43, -126, 34, 44, 2,
    83, -15, 17, -25, -30, -12, -8, 6,
    -10, 30, -22, 15, -14, 6, -36, -2,
    65, 11, 12, -18, -11, -1, 0, 1,
    22, 14, -43, -25, -14, 6, 13, -2,
    -6, -71, -87, -15, -38, -33, 41, 6,
    32, -23, 31, 16, 40, -70, 71, 27,
    -56, -2, -11, -17, 21, -60, -41, 19,
    -14, 11, 2, 27, 5, 30, -32, -14,
    6, 19, -13, -34, 7, 10, 8, 36,
    15, 21, -44, -32, -2, -5, -14, -6,
    34, 72, 29, 7, 8, -24, 11, 71,
    28, 41, 69, -20, -26, -10, -36, 39,
    -44, -42, 10, 15, -43, -48, 34, 4,
    22, -9, 3, 13, -54, -18, -22, -34,
    34, 40, 3, -16, 41, 88, 67, -20,
    31, -27, 13, -13, -5, 17, 22, 25,
    -6, -56, 8, -64, 5, -37, 63, 15,
    -12, -20, 20, 18, 59, -52, 30, -12,
    14, -1, -1, -28, 4, 5, 10, -2,
    -1, 26, 18, -5, -22, -38, 12, -22,
    -98, 53, 49, 59, -20, 49, -30, -99,
    8, -23, 0, -9, -10, 30, 0, 37,
    19, -70, -1, -48, 0, -24, -27, -4,
    40, -11, -9, 1, 10, 15, 25, 43,
    -71, 30, 32, 9, 81, -92, 28, -65,
    15, -19, 51, 10, 37, -27, 18, 63,
    -21, -18, 21, -51, 1, 3, 24, -90,
    -28, 0, 21, -17, 59, 33, 43, -8,
    -71, -15, -59, 0, -8, -33, -41, -15,
    -29, 25, -55, -17, 24, 19, -58, 11,
    19, 16, -44, 0, 52, 7, 23, -21,
    -25, -6, -37, -24, -22, 3, -4, 12,
    -23, -1, -4, -67, 61, -56, -35, 69,
    6, 30, -22, 21, 0, 50, -18, -3,
    -66, -36, -19, 25, -32, 14, -6, 1,
    -6, -23, 1, -37, 14, -24, 33, -2,
    -72, -57, 18, -21, 22, -21, -8, -7,
    -4, -32, 72, -18, 75, 7, 24, -58,
    11, 42, 41, 55, -34, -27, -3, 22,
    -8, -26, 27, 11, 26, 50, -41, -29,
    47, -20, -27, 62, -4, -21, 24, -5,
    31, 20, 10, -46, -10, -9, 38, -52,
    11, -23, -57, 37, -2, -46, -55, 15,
    58, 5, -43, 4, 44, -2, 7, -6,
    38, 14, -11, -15, -71, -16, -12, -28,
    -34, -10, -21, -3, -60, 20, -75, 6,
    -8, 15, -5, -108, -5, 7, 31, 17,
    -3, -5, -8, -21, 16, 10, -29, -27,
    3, -1, -19, 18, 27, 18, 15, 6,
    5, -79, -55, 40, 23, 7, 17, -28,
    -67, -26, 51, 34, -18, -37, -3, -18,
    -24, -17, 7, -7, 17, -26, 25, -43,
    52, 15, -53, -22, -23, -69, -27, 14,
    -6, 94, -44, -3, 22, 12, -12, 28,
    -43, -67, 42, 12, 7, 25, -20, -52,
    -4, 6, -72, 7, 14, 51, 11, 46,
    2, 4, -33, 3, -29, -21, 51, 10,
    9, -3, 24, 8, 6, -17, 14, -47,
    6, -7, 9, 4, 4, 8, 24, -3,
    -22, 2, 30, -3, 21, 3, -11, -3,
    24, 12, 1, -10, 15, -19, 11, -1,
    5, 12, -10, 29, 5, -11, 13, 31,
    46, 1, 7, 13, -13, 1, 22, 0,
    47, -29, 32, -8, -26, -10, 2, -22,
    -2, 14, 7, 16, 29, -30, -17, 1,
    -3, 18, 22, -4, -15, 26, 29, -7,
    23, 0, -23, 24, 13, -9, -25, -29,
    -31, -19, 4, -33, 15, 14, 3, 20,
    14, 3, 32, -33, 4, -13, -21, -11,
    -22, -33, -15, -25, -1, 18, 61, -13,
    -8, -3, -20, 18, 19, -18, -20, -8,
    7, -45, 32, -9, 8, 15, 23, 22,
    24, -8, -13, 32, 41, -11, -33, -41,
    -13, 26, -4, -23, -37, 19, -39, 18,
    0, 8, 18, 39, 8, 16, -15, -6,
    41, -5, -29, -4, -8, 23, -3, 19,
    -15, 16, 36, -3, 35, -1, -35, -6,
    -29, -10, -10, 29, -28, -29, 25, -25,
    -18, -18, -25, 22, -22, 4, -13, 0,
    -18, -16, 28, -4, 5, -7, -20, -5,
    -44, -4, 2, 14, -3, -14, -9, 5,
    -25, -1, 6, -10, 9, -11, -5, -20,
    1, -3, 9, -26, -7, -31, -5, 6,
    42, -31, -21, -14, -17, -18, -28, -12,
    24, 7, 10, -65, 8, -21, -29, -5,
    -80, -34, 23, 4, -12, 52, 10, 6,
    -3, 15, 23, 1, -10, -11, 7, -11,
    18, -22, 6, -45, -24, 11, 9, 11,
    13, 48, 42, -3, 4, -9, -13, 30,
    -21, 8, -27, -29, 0, -53, 13, -20,
    0, -7, -24, -14, -10, 25, 0, 26,
    -33, 40, 5, 44, -40, 28, 7, -4,
    12, 22, 20, 6, -39, -8, -88, 10,
    -28, 1, -35, 25, 29, 2, 31, -23,
    -3, 6, -54, -6, 10, -5, -17, 1,
    -12, -4, 10, 29, 7, -23, 1, -11,
    21, -1, -18, 3, -24, 4, 4, -23,
    20, -25, -20, -44, -4, 37, 6, -5,
    -8, 3, 28, 8, 10, 19, -23, -3,
    -14, -10, 25, -26, 0, -14, -29, -4,
    36, 35, 34, 16, -27, 37, -12, 9,
    -7, 23, 16, -30, 15, -18, -39, -13,
    -29, -24, -21, -7, 3, -5, 13, 3,
    -20, 10, 29, -12, -8, -15, -11, -1,
    -23, 9, -12, 0, -7, 9, -27, -24,
    -10, -31, 30, 6, 39, 8, -50, 28,
    -6, -6, -5, 8, -1, 16, -2, -9,
    19, -14, -7, 12, -3, 7, 4, 10,
    9, -5, 20, -2, -7, 6, -29, -14,
    -1, 31, 56, -21, -18, 9, 14, -34,
    22, 5, -6, -30, 2, -5, -18, -20,
    27, 14, -6, -15, -19, -4, -6, 0,
    -5, -16, -31, 7, 15, -10, -18, 19,
    12, -13, 19, 43, -26, 8, -2, -41,
    22, -2, 13, 8, 25, 0, -16, 21,
    4, -15, -31, -7, -9, 7, -7, 2,
    24, 11, 18, -4, 0, 0, 49, -15,
    -13, 10, 10, -17, 22, 12, 3, 36,
    -2, 14, -8, -7, -8, 25, 15, -4,
    122, 0, -14, 50, 32, -2, 18, 18,
    17, -23, 26, 3, -4, 50, -29, -17,
    -5, 1, -13, 2, -23, -19, 44, 13,
    25, 24, -30, -5, 18, -27, 10, 8,
    29, -3, -2, 1, 6, -8, 12, -4,
    -16, 7, -8, -52, 11, 11, -1, -20,
    2, 34, -18, 4, 1, -11, 53, -43,
    72, 17, -22, 23, 3, 6, -8, -1,
    -6, 47, -21, -29, -5, 40, 8, -12,
    8, 4, 9, -4, -7, -13, -35, -14,
    37, -7, -23, 0, -19, -2, 48, 23,
    -6, 2, -38, 24, 5, -7, 21, 29,
    -26, -3, 25, 61, 36, -40, 21, -14,
    -32, -32, -20, 24, 3, 24, 0, 29,
    -17, 2, -13, -10, 27, -17, 13, -19,
    14, -16, 15, 16, 6, -11, -2, -8,
    18, 2, 14, -16, 18, -1, -3, 9,
    -3, 2, 31, 3, -12, 16, 9, -13,
    -11, 24, 25, 11, 28, -29, 12, -9,
    -2, 19, 10, -11, -22, 20, -6, 34,
    6, 25, 16, 18, 10, 19, -11, 16,
    -16, 11, 35, 17, -13, 17, -6, -5,
    -1, 8, -4, -7, 3, 3, -23, -32,
    2, 14, -9, -32, 7, -7, 23, -23,
    44, 10, 52, 21, -9, 7, -9, -2,
    15, 8, -8, 14, -3, 6, -19, 3,
    -27, 6, -30, 33, -10, 17, 14, -57,
    27, -7, 26, 20, 3, -5, -7, 15,
    -4, 37, 2, 0, 13, 4, 9, -8,
    6, -7, -21, 24, 33, -40, -30, 11,
    -19, 28, 11, -4, 2, -19, 49, 12,
    -12, 22, -24, 8, -8, 8, 3, -3,
    12, -20, 25, -44, 23, 12, -4, -35,
    36, -14, -27, -25, -10, 3, 7, 10,
    -28, -18, 34, -5, 38, -22, -17, 9,
    -27, 10, -22, 15, 7, -23, -22, -4,
    24, 16, -4, -7, 5, -13, -40, -9,
    6, 7, -1, -16, 21, 26, -32, -25,
    -12, 2, 21, 1, 13, -2, 14, 18,
    -4, 9, 16, -1, 16, -22, 0, -12,
    -6, -25, 1, 5, 25, -4, 15, 1,
    -60, 10, -29, 25, 38, 10, 16, -36,
    -14, 8, -3, -16, -22, -77, -31, 27,
    -29, 19, 3, 12, -25, 2, -5, -11,
    -37, -19, 37, 41, -2, -23, -11, 13,
    25, 29, -6, -4, 29, 1, -31, -10,
    11, -14, -7, -10, 31, -22, -6, 27,
    22, 2, -18, -12, 11, -9, -19, -20,
    2, 1, -5, -12, 12, -20, 12, 12,
    16, 11, -33, -4, -4, -2, -6, -3,
    21, -3, -37, -1, 42, 20, -4, 1,
    -62, 14, -16, -24, 12, -1, -18, 3,
    -4, -4, -5, -18, 31, 6, 0, -9,
    3, -26, 13, 0, 33, 44, -31, 4,
    13, -7, 22, -6, -20, -5, 20, 40,
    -7, 20, -5, 8, -9, -7, 16, -20,
    15, -26, -16, -20, -9, 3, 36, -24,
    -6, -13, 10, 2, -27, -14, 25, -10,
    -24, -70, -31, 27, 2, -42, -40, -23,
    -13, 9, 1, -3, 0, 2, 2, 23,
    3, -9, 45, 38, -11, -52, -24, -8,
    -3, -14, 14, -25, -11, 22, -58, 9,
    4, 9, 11, 12, -26, 33, 6, -4,
    -6, 1, -64, -14, -10, -25, -7, -19,
    -22, 13, -26, 1, -11, 8, 23, -4,
    -3, 3, 40, -7, -23, -5, 44, -34,
    -4, 16, -23, 41, 27, 5, 55, -16,
    -11, -19, 21, -8, 0, 0, 20, -11,
    -6, -2, 24, 13, 13, 13, 13, 16,
    -57, -4, 18, -28, -1, -28, 6, -36,
    4, 10, -8, 10, -39, 33, 28, 18,
    -10, -34, 3, -1, 8, 1, 10, 9,
    6, -1, 24, 17, 3, -6, -15, -3,
    4, 19, 1, 39, 61, -11, -9, -18,
    -49, 30, 25, 30, 20, -14, -9, 14,
    31, -7, -67, 10, 3, -8, -8, -23,
    -4, -8, 40, 3, 1, -11, -3, 8,
    0, -1, 6, -11, -38, 5, 29, 19,
    16, 32, -11, 4, -50, 30, -26, -28,
    -7, -6, 12, -8, 13, -10, -15, -23,
    -12, 22, -6, 12, 3, -7, -20, 16,
    27, 18, 0, 98, 38, -13, 3, -3,
    -7, 14, -15, 8, -18, 18, -17, 7,
    27, 13, 2, 56, 24, 8, -14, -21,
    28, -11, 19, -7, -2, 19, 11, 4,
    -25, 15, 13, 8, 55, 3, -8, 10,
    22, 2, -2, -2, -44, 19, -15, 20,
    -30, 11, -27, 34, -35, -3, -19, -4,
    -15, -14, -4, 29, 9, -5, 0, 0,
    -80, 3, 4, 22, -14, 2, -22, -22,
    -26, -11, 19, -30, -15, 32, 28, -50,
    -17, -9, 6, -11, -24, 18, 2, 26,
    17, -20, 1, -31, -6, -15, -8, -5,
    0, -12, 1, -63, 19, -30, 2, -24,
    -53, 7, 20, 21, 1, -41, -31, 43,
    -8, -2, 11, -12, -9, -10, 3, -1,
    62, -44, 29, -17, 4, 15, 15, -10,
    22, 28, 19, -11, 7, 2, -10, 34,
    -11, -8, -53, 4, 17, 31, -18, -8,
    -8, -11, -6, -16, -5, -7, -14, 18,
    -25, -11, -4, 35, -29, -19, 5, -23,
    -5, 10, 25, -9, -58, 1, -97, -7,
    -9, -7, 2, 9, -24, -23, 6, -22,
    -19, -6, -38, 3, 26, 8, -18, 0,
    -10, -9, 19, -1, 0, -22, -5, -1,
    21, -16, -55, 4, -23, -17, 18, 17,
    -27, 25, -22, -12, -15, 57, -51, 5,
    8, -8, 13, 2, 5, -34, -12, 18,
    -20, 6, -22, -1, 5, 4, 7, -1,
    44, -5, 28, -15, -28, 24, -8, 30,
    -10, 32, -30, 38, 41, -8, -25, 43,
    -30, -16, 6, -8, 27, 16, 8, -40,
    15, 6, 7, -11, -6, -18, -15, -15,
    -12, 9, -54, 27, -16, 73, 2, -16,
    -54, -34, 27, 29, 41, -20, -19, 25,
    37, -21, -22, -19, -3, -7, -11, -4,
    -34, -22, -9, 35, 9, 29, 8, -10,
    -29, -4, 20, -18, 22, 15, -26, -24,
    -22, -4, 2, -21, 57, 11, -7, -20,
    -10, 9, -12, 3, -18, -11, 20, -9,
    16, -9, -20, -9, -17, -11, 3, -6,
    3, -34, -24, -12, -2, 0, -16, 21,
    -26, -14, 10, 12, 24, 12, 44, -9,
    -28, 3, 5, 23, 14, 6, -8, -4,
    8, -41, 8, -33, 23, 2, -4, -14,
    19, -35, 5, 18, -3, -12, 31, 15,
    11, 43, 22, 8, 31, 43, 13, -9,
    2, 5, -2, 13, -1, 12, 5, -17,
    77, 0, -1, -36, 1, 18, 13, -5,
    10, -11, 52, 17, 10, 19, -14, -8,
    -10, 38, -29, 15, -52, 5, 16, -1,
    14, -49, -5, -12, 2, -6, 1, 3,
    37, 40, -22, -8, 13, -3, -12, 12,
    -3, 7, 14, 4, 32, -17, 2, -41,
    -1, 31, -5, 27, 8, 24, -2, 5,
    83, 29, -12, -38, 8, -1, 2, -9,
    0, 20, -26, 6, 2, 17, 12, -28,
    21, -20, 15, -3, -10, -4, -50, -25,
    8, 0, -8, 23, -19, -22, 22, 4,
    -3, 1, -27, 10, -5, -2, 19, 19,
    -28, -27, 1, -10, -1, -3, 12, -6,
    4, -32, -6, -11, 5, 5, 7, 53,
    47, 32, 12, -18, 0, -34, 32, -16,
    -54, 2, 6, 33, 3, -9, -24, 2,
    18, -4, 34, -41, -16, 12, 2, 12,
    54, 5, 0, -5, 8, 9, -16, 35,
    16, 6, 20, -15, 39, -30, 11, -35,
    15, 21, -7, -17, 3, 13, -10, 23,
    23, -7, 32, -65, -31, 1, -13, -20,
    -10, 6, 50, 38, 2, 20, 8, 2,
    6, -10, -14, -5, -26, 9, 9, -21,
    0, 24, 2, -27, 14, 10, 12, -32,
    22, 10, 36, 0, -7, -6, 2, 4,
    -20, -23, 7, -12, -14, -20, -34, 0,
    -33, 8, -43, 27, -20, -32, 21, -32,
    34, 20, -12, 6, 10, 16, 1, -14,
    4, 14, -54, 2, -14, 0, -9, -15,
    -9, -12, -17, 39, 36, -31, -16, -17,
    4, -46, 39, -8, 13, -13, -22, -18,
    -20, -24, 20, 0, -23, 20, 24, 9,
    10, -10, -27, -38, -3, 22, -4, 6,
    36, -4, -29, 35, 24, 12, -4, -1,
    10, -50, 4, -8, -6, -7, 64, 16,
    1, 11, 26, 11, -31, -24, 12, -15,
    25, 16, -19, 7, -13, 13, -29, 2,
    11, -13, 33, -11, 16, 45, -10, -19,
    -3, 2, 9, -3, 33, -20, 17, -7,
    -6, 13, 25, 17, 26, -9, -13, 5,
    29, -10, 9, 3, -5, -24, 14, -7,
    -64, 14, 30, 70, 26, -20, 10, -1,
    29, -47, 18, 29, -36, -8, 24, 35,
    -58, 25, 13, 13, -28, 1, -16, -9,
    7, -16, 19, 1, -19, -4, -2, 2,
    -38, -10, -6, -23, 32, -1, -35, 4,
    18, -4, -33, 21, 29, 16, 19, 3,
    -9, 8, -1, -18, -14, -2, 14, -6,
    -23, 24, 9, -22, 6, -11, 0, 8,
    18, -18, -19, 48, -13, 30, -11, 13,
    -4, 3, -30, 12, 8, 8, -16, 34,
    -12, 16, 2, 31, 17, -12, -17, 2,
    7, 4, -17, -10, 17, 1, -4, -18,
    30, -16, 27, -11, 30, 28, -66, 17,
    -13, -21, 35, -39, 4, -7, -2, 30,
    7, 33, -12, -7, -12, -1, 4, 2,
    28, 0, 12, 1, -11, -1, 10, 7,
    3, 8, -1, 29, -10, -7, 20, 12,
    -44, 17, -6, -5, -17, 2, 11, -25,
    -28, -8, 11, 20, 8, 2, 12, 7,
    -5, -22, 45, 7, -5, -41, 2, 38,
    -19, 38, -28, -15, 9, 49, -96, 16,
    25, 12, -3, -25, -42, -9, -16, 9,
    -25, -46, -17, -1, 1, -4, -15, -21,
    -8, 5, -5, 2, -15, 14, -5, 2,
    10, 33, 51, 23, -6, -13, 32, -27,
    14, 9, -76, -9, 35, -10, 5, 65,
    -11, 0, 29, -41, 24, 1, 67, -15,
    -23, 1, -65, -10, -4, 9, 8, -9,
    -19, -18, 30, -45, -12, -2, 2, 10,
    -5, -23, 7, -48, -10, 21, 6, -37,
    -39, -47, -1, -10, -28, -71, 9, 22,
    -10, 11, 4, 3, -40, -23, 24, -6,
    -7, -1, 5, 16, 68, -3, 15, 9,
    29, 22, -24, -37, 55, 6, 21, -46,
    81, -8, -26, 7, -11, 0, 4, 31,
    0, 13, 16, 40, 17, 2, 2, -35,
    -8, 4, -20, 27, -41, -10, 60, -24,
    32, 15, 66, 51, -42, 9, 23, -31,
    -34, -36, 19, 25, 11, 61, -25, 31,
    -23, 80, 14, -3, 0, 16, -5, 34,
    85, 23, -7, 106, 31, -33, -9, -17,
    -44, -61, 9, 51, -5, -24, 6, 77,
    39, 19, 75, 38, 55, -20, 30, -24,
    -56, -42, -53, 15, 13, -55, 2, 16,
    -104, 54, -8, 31, 86, 8, 20, 11,
    -51, 19, 0, -30, -5, -6, 50, 19,
    -6, 4, 16, 36, -57, -3, -1, 5,
    58, 26, 4, -86, 34, -25, 8, 11,
    -35, 53, -6, 11, -39, 39, -12, -18,
    37, 15, 4, -44, -17, 61, -7, 9,
    -28, 69, -4, -41, 13, 39, 11, 25,
    -17, 59, -16, -17, -10, 34, 5, -22,
    1, 50, -5, -103, 35, -4, -37, -63,
    63, 18, -37, -50, 23, 13, -2, -21,
    19, -11, -15, -25, -1, 30, -37, -9,
    54, 75, -6, 11, 127, -17, -18, 10,
    17, 64, 8, -12, 17, 8, -61, -3,
    -3, 11, 43, -10, 63, -22, -67, -62,
    -6, 29, 30, 12, -8, -19, 30, 9,
    -32, -18, 9, -36, -36, -19, -13, 20,
    29, -5, -1, -18, -57, -5, -94, -13,
    -30, 18, -15, -26, -25, 35, -26, -44,
    -48, -11, -44, 0, 22, -18, 5, -1,
    -31, -9, 24, -52, 3, -16, -22, -31,
    -7, -66, -44, 35, -8, -29, 21, 60,
    -49, 50, 2, 33, 11, -35, 6, 11,
    -12, -67, 20, 22, -30, -32, -48, 54,
    15, -62, -11, 14, -21, 8, -2, 8,
    73, 27, 10, -75, -5, 3, 9, 5,
    7, -54, -44, -7, -10, -43, -74, -29,
    -46, -3, -24, -12, 44, 28, 24, -50,
    22, 7, 48, 1, -11, 5, -43, 15,
    -69, -17, -52, -11, 12, 117, -15, -47,
    3, -28, 14, 87, 58, 23, -15, 10,
    40, -32, -3, -1, -74, -55, -28, 8,
    -49, 9, 23, -91, 9, -19, 7, 64,
    -30, -67, 30, -31, 21, 9, -25, -7,
    3, 23, 1, -58, 40, -8, 33, -5,
    25, 46, -81, -47, -12, -13, 26, -11,
    -60, 42, 22, 24, 37, 14, -44, -18,
    50, -36, -17, -24, -31, 20, 13, 61,
    7, 6, -21, 20, 15, 0, 6, -24,
    -36, 29, 27, 60, -5, 5, 12, -35,
    -5, -8, 75, -79, -15, -44, 8, -2,
    -2, -16, 7, -29, 21, -15, 30, 32,
    22, 14, -18, -9, 62, 46, 0, 46,
    23, 0, -6, 21, -2, 3, 19, -19,
    78, -5, 1, -4, 41, 22, -17, 21,
    -17, 40, 25, 1, 17, 31, -4, 5,
    22, -13, 16, -3, 44, -76, -5, 28,
    3, 26, 13, -17, -43, 33, 57, 1,
    -7, -45, 35, 4, 4, 9, -18, -4,
    26, 7, 29, -44, 26, -14, 12, -6,
    -80, -49, -19, -7, -5, 22, -9, -75,
    112, 17, 2, -10, 0, -30, 17, -2,
    -3, -38, -1, -13, 21, -60, 1, 0,
    33, 4, 18, -26, -1, 15, -35, -2,
    -32, 48, -32, -20, -67, -5, -19, -30,
    6, -12, -45, 52, 9, -12, 15, 16,
    -3, -4, -24, -91, -47, 26, 25, 8,
    -2, -47, -84, -27, 19, -8, -1, 4,
    -18, -4, 11, 49, -8, 0, 78, 32,
    -12, 17, 19, 84, 11, 18, -17, 9,
    -22, 50, -11, 49, 12, 37, 39, 12,
    60, -3, -7, 39, 28, 1, -47, 19,
    65, 8, -1, 22, -21, -96, 46, 0,
    29, 13, -6, 33, 50, -14, 16, -28,
    5, -17, 28, 8, -1, -14, 14, 7,
    -39, 47, 34, 47, -20, -21, -16, -19,
    -13, 8, -1, -45, -30, 5, -10, -10,
    -3, 34, 9, -48, 17, 37, 18, -28,
    -45, -59, -17, 3, -14, 8, 24, 8,
    -18, -50, 52, -58, -22, -49, -15, -8,
    -29, 4, 18, -32, -15, 7, 23, -41,
    81, -27, 7, -3, 3, 11, 60, -32,
    12, -42, -15, 3, -30, -14, 15, 31,
    27, 32, -41, 37, 4, -23, -5, 25,
    41, 13, 2, -7, 37, 7, 12, 25,
    -49, -23, 37, -14, -14, 16, 10, -5,
    37, -5, -14, 57, 39, -26, 12, -5,
    21, 34, -9, 49, 11, -1, -6, -1,
    -19, 27, -28, 55, 11, 10, 44, -10,
    -31, 19, 15, -36, -64, -64, 41, 9,
    -18, 40, 19, 31, -14, 12, 3, 13,
    25, -20, 10, -7, 8, 65, 4, 3,
    -5, 2, 25, 14, 43, 21, 7, -54,
    -17, 53, 32, 24, 36, -35, 24, -4,
    -9, 27, 21, 15, 26, 9, 22, -4,
    -96, 3, 45, 70, 13, -35, 35, -33,
    -6, 34, -31, 22, 17, -10, 12, 55,
    -77, -10, 11, -23, -4, 6, -25, 1,
    -39, -19, -60, -5, 25, -14, 52, 12,
    -10, 12, 23, -35, 16, -5, -21, 8,
    -47, 0, 84, -20, 27, 43, 27, -6,
    5, 24, -4, -16, -62, -4, -4, -4,
    -9, -45, 41, 6, 6, 29, -1, -28,
    -27, -14, 9, 120, -8, 39, -8, -6,
    -24, -19, -7, -14, -42, 8, -7, 33,
    -11, 14, 16, 41, 16, -5, -26, 57,
    -28, 28, -20, 8, 4, 14, 13, 11,
    76, -41, 48, -13, 9, 14, -50, 15,
    14, -30, -38, 30, 48, -20, 3, 88,
    21, 17, -13, 35, -10, -16, -5, -24,
    3, 29, -36, -82, 12, -1, -11, 29,
    16, 18, 37, 5, 6, 13, 19, -6,
    -24, 108, 20, 17, 53, -2, 38, -1,
    -23, -1, 16, 21, -18, 14, -22, -41,
    -32, -22, -8, -75, 24, 38, 37, -11,
    12, 38, -16, -37, 30, 10, -106, 28,
    -24, 31, -7, -16, 7, 31, -43, -12,
    -34, -8, -67, -22, -15, 9, -51, -12,
    59, -5, -12, 3, -14, -9, -16, -4,
    -14, 59, 4, 8, -9, -8, 19, -14,
    24, 4, -1, -32, -7, 1, -26, -21,
    -10, 5, 15, -8, 1, -10, -10, -12,
    10, 15, -6, 13, -5, -16, -36, -20,
    8, 1, -11, 19, 18, -14, 11, -26,
    11, -2, 1, -24, 47, -27, -10, 1,
    -23, -9, 0, 11, 4, 46, -5, -35,
    -14, -27, -13, -15, -13, 13, 6, -9,
    -10, -4, 9, -3, 7, 1, -10, 19,
    2, 23, -16, 8, -9, -26, -32, 20,
    10, -2, -4, -35, -34, 2, 12, -6,
    24, 34, 23, -25, -12, -6, -37, 10,
    1, -11, -9, -11, 0, 30, -7, -8,
    -16, -22, 6, 43, -35, 12, -29, 6,
    -10, -7, -43, 6, -1, -35, -6, 17,
    9, 4, 34, -2, -1, -2, 15, 31,
    -7, -19, 12, 14, -9, -13, -23, -26,
    -1, 10, -6, 27, -14, 28, -14, 12,
    10, -5, -2, 26, 6, 26, 16, 35,
    5, -7, -6, 25, -19, -7, -18, 2,
    -2, -5, -8, -25, 9, -3, -1, 10,
    -14, -23, -15, -5, -13, -10, -15, -16,
    -2, -25, 23, 21, 9, 4, -6, -6,
    16, -15, 7, -49, 6, 8, 11, -20,
    14, 12, 77, -6, 4, -20, -6, 0,
    -22, -34, -1, -17, 9, -15, 10, -23,
    13, 14, 21, -10, 8, 1, -20, 25,
    22, -9, 12, -12, -2, -4, -4, 38,
    20, 6, -4, -12, 14, 13, 2, 0,
    0, 6, 20, -10, 14, 44, 8, 12,
    28, -48, -1, -35, -1, 3, 2, 22,
    -38, 34, -8, 3, 11, 15, -15, -11,
    -64, 1, -4, -15, 19, 2, -21, -28,
    -17, -3, 29, 0, -18, 12, 20, -49,
    8, 5, 0, 16, -15, 2, 12, 3,
    -37, -6, 34, 12, -1, 29, -4, -39,
    -1, 0, 4, 24, -3, 0, 7, -8,
    -1, -38, -7, 6, -17, 5, 4, 34,
    -38, 3, -6, -8, -6, 31, 15, 23,
    26, 4, 2, 26, -24, 7, 17, 5,
    7, 7, 1, 13, 2, -11, 4, 1,
    -1, -11, -26, 2, -26, -23, -33, 18,
    -25, 3, 3, 16, -1, 17, 1, 3,
    29, 24, -3, 0, -9, -13, 1, 12,
    2, 14, 21, -30, 1, 10, 14, 7,
    -16, -11, -39, -13, 12, 31, -61, 10,
    -20, 4, 12, -5, 25, 23, -16, -23,
    -40, 26, 26, 4, 4, -15, -4, 5,
    10, -13, -18, 6, 15, 2, 4, -5,
    17, 8, -3, 26, -6, -24, -11, -12,
    -25, -28, 42, 19, -20, 0, 7, 18,
    -20, 19, -24, -22, 7, 5, 22, 21,
    15, 5, -15, -6, 3, 24, -2, -7,
    -36, -18, 3, -1, -22, 7, 16, 3,
    31, -9, 14, -3, -10, -6, -29, 15,
    13, -12, -26, -2, 11, 1, -17, 10,
    -19, 6, 14, 7, -4, -20, -3, 25,
    -3, 9, -28, -2, 18, 3, 51, -4,
    10, -9, -21, -26, 0, 27, -12, -11,
    -26, -1, 36, 8, -7, 20, -1, -17,
    -31, -11, -2, 15, 13, 2, -20, -6,
    26, -20, -18, 5, -66, -13, -29, -26,
    6, 6, -19, 3, 14, 12, 11, 11,
    -11, 51, -15, 8, 18, 19, -9, -4,
    -7, 40, 19, -73, 0, -6, -4, 0,
    -5, 1, -37, -6, -6, 21, 16, 48,
    -29, 36, -1, -16, 4, -3, -1, 5,
    -22, -74, 15, -10, -21, 10, -8, 20,
    3, 15, 13, -12, 2, -1, -9, -13,
    -4, 24, -3, -48, 12, -4, -40, 9,
    -7, 2, -20, 16, -2, 1, 11, 13,
    16, -21, 33, -17, 17, -6, -7, 21,
    11, -5, -11, -20, -15, -15, -10, 11,
    32, -33, -7, -8, 3, -16, -14, -32,
    -12, 2, -1, 16, 3, -5, 12, 30,
    -15, -3, 28, 34, -2, 4, 3, 11,
    16, 11, 21, -7, -12, 16, 15, -23,
    18, 3, 9, -25, -1, -10, -16, -22,
    6, -44, 1, -43, -24, -7, -5, 31,
    -6, 28, 20, 30, 21, -64, 10, -32,
    -14, 46, 4, -6, 30, -14, 4, 32,
    -3, 19, -22, 23, 7, -41, -49, -25,
    -14, 12, -41, -12, 5, -2, -11, 0,
    1, 20, 20, -11, -34, -8, 0, -4,
    2, -8, 0, -71, -4, 15, 2, 20,
    -10, 13, -14, -5, -11, 35, -43, 33,
    -9, 10, -20, -7, 42, 5, -49, 11,
    -15, 12, -24, -6, -5, 57, -7, -34,
    -4, 5, -4, -14, 13, -8, 4, 14,
    7, 31, 2, -15, 10, 27, 12, -21,
    4, -4, -2, 43, 37, 23, 10, -11,
    -6, -3, -2, 18, 4, 18, 29, -32,
    17, -12, 5, 5, -37, 14, 19, 3,
    10, 37, -10, -40, -11, -1, -22, 15,
    25, -34, -20, -19, -4, 26, -1, -11,
    25, -6, 36, -10, 18, 24, -10, -30,
    15, -8, 19, 9, 17, -7, -9, 11,
    -5, 6, -27, 28, 3, 27, 9, -7,
    34, -4, 14, 7, -9, 4, -12, -28,
    14, -16, -22, -26, -18, -19, 7, 5,
    -40, 19, -18, 53, -5, 13, -12, -14,
    17, 9, -7, 17, -23, 10, 23, -21,
    -2, 10, 3, -2, 11, -9, -34, -4,
    22, 3, 11, 22, 7, 14, -1, 1,
    -5, 14, 11, -8, -24, -1, 5, 8,
    8, -1, -2, -4, 6, -1, -7, -3,
    32, 24, 4, 15, -18, -9, -13, 38,
    -39, -50, -24, 31, -9, -20, -10, 26,
    -1, -4, 1, -24, -6, -22, 14, -21,
    56, -20, 22, -12, -41, 16, -20, 6,
    -33, 7, 3, -7, -1, 17, -7, 16,
    1, -6, -4, 34, -44, 18, -14, 19,
    -17, 20, 14, 8, -3, -19, 1, 29,
    47, 14, 5, -26, -21, -6, -5, 64,
    -40, 17, 22, 18, 1, 0, -7, 13,
    55, -19, 23, 0, -54, -1, 0, 33,
    8, -10, -8, 21, 19, 15, -28, 1,
    -7, -10, -6, 3, 28, -8, 2, 38,
    4, 10, 1, 25, -3, 17, 4, -15,
    -10, -16, -6, 0, 18, 13, -8, 1,
    -8, -2, 21, -9, -22, 4, -20, 4,
    -24, -49, -22, 12, 4, 35, 0, -57,
    28, 28, 53, -19, 5, 16, 8, 2,
    12, 7, -23, 15, -2, -5, 13, -26,
    0, 5, 8, -5, 12, 35, -1, 7,
    3, -28, 0, -10, 36, 6, 0, -6,
    23, -1, -2, 61, 19, 19, -2, 31,
    -27, -20, 47, 6, 34, -8, 14, -25,
    -26, 58, 10, 1, -2, -9, 10, -7,
    34, -1, -11, -13, 28, -8, -2, -4,
    -11, -2, -27, 12, -28, 7, 3, -23,
    -3, 17, -13, 8, 0, -10, -22, -15,
    26, -19, -10, -13, 29, -8, 9, -19,
    19, -26, -3, -4, 31, 0, 9, -6,
    60, 4, 19, 10, 22, 20, -3, 14,
    35, -20, -4, 8, 15, -3, -16, -5,
    -4, -6, 18, -4, 13, 2, -5, 26,
    -26, 12, 19, -31, -2, 23, 4, -29,
    -27, -10, -35, -19, -6, -7, 0, -5,
    -13, 21, 29, 20, -1, -7, -23, -5,
    -20, 7, 1, -18, 0, 26, -4, -5,
    -6, -38, 0, -16, 17, -26, -6, -9,
    -5, -13, 7, -29, -3, -5, -7, -26,
    -22, -18, 13, 8, -8, -16, -10, 8,
    6, 7, 3, 12, 0, 1, -46, -7,
    -14, -18, 23, 12, -7, -3, 28, 33,
    -17, 11, 30, 27, 10, 23, 6, -11,
    18, -2, 9, -30, -5, 3, -10, 19,
    2, -25, 30, 12, 5, 26, 1, 22,
    7, -13, -12, -12, -8, 16, 10, 3,
    34, 8, 13, -40, 10, -9, -21, -16,
    -23, -9, -32, 110, -8, 3, 17, -18,
    -17, 8, 52, 12, -6, -23, -1, 4,
    -14, -12, -2, -32, 12, 11, -37, -7,
    -14, -20, 4, 18, -6, -16, -10, 14,
    9, 23, 20, 8, 9, 1, -2, 16,
    2, -9, -2, -5, 16, 44, 0, 18,
    10, -6, -1, 14, -12, -13, 1, 22,
    0, -22, 21, -5, -19, 11, -6, -11,
    29, -28, 32, 36, -14, 33, -5, -8,
    -73, 35, 12, 11, 11, 1, -3, -29,
    -14, 18, -8, -17, -34, -14, 7, -1,
    16, -60, 3, 16, -19, -2, -9, -2,
    -45, 17, -45, -10, 4, 30, -7, -20,
    -3, 2, 11, 11, 9, 12, 13, 8,
    -10, -33, -8, 28, -10, 9, -2, 57,
    -8, 32, 16, 3, 5, 2, -17, 12,
    -6, 34, -29, 57, 7, -5, -4, -4,
    -21, 23, 10, -4, 4, 2, 13, -6,
    -8, -25, -14, -1, 16, -9, 11, -25,
    9, 2, 25, -2, 18, -5, -13, -1,
    29, -39, 15, 10, -25, -12, -6, 3,
    -1, -2, 27, -25, -7, 10, -4, 0,
    -18, -17, -16, -36, -14, -6, -19, 28,
    1, -3, 3, 23, 5, 32, 17, -7,
    -27, 38, 25, -9, -3, -6, 1, 10,
    -9, -3, -13, -3, 12, -1, -16, -14,
    19, -18, 7, -5, -5, -52, -4, 13,
    17, 15, -23, -22, -11, 13, 21, -17,
    -2, 10, 0, 17, 16, 3, 1, -19,
    15, -16, -12, 2, -12, 25, 12, 3,
    -7, -11, 10, 6, -1, 36, 19, 5,
    -39, -54, 11, 7, -24, 3, 27, -8,
    20, -5, 39, 0, -4, 17, -12, 41,
    -5, 0, -13, -15, 0, -36, 1, 10,
    -15, 0, 3, -10, -27, -2, 46, -18,
    8, -13, -17, 1, 19, 3, -4, -16,
    16, -11, 51, 20, -1, -14, 12, 4,
    -49, -20, -17, 7, 27, 0, 14, 14,
    22, 0, -18, 9, -55, 21, -2, 11,
    -56, 8, 34, 8, -1, -13, 31, -15,
    -13, 3, 28, 21, 19, 3, 17, -5,
    7, 25, 14, -69, -19, -23, 19, 5,
    1, 12, -23, 0, 41, -10, -4, 73,
    32, 7, -20, 1, -4, -1, 7, 14,
    -15, 24, 5, -23, -18, -6, -6, 14,
    6, -10, 30, 14, 0, 8, 2, -40,
    -2, 2, -2, 5, -20, -12, -13, 35,
    -48, -34, -17, -21, 20, -8, 3, 10,
    23, 13, 19, -53, 7, -3, 10, 19,
    2, -13, -3, -7, -32, -7, -7, 10,
    11, 5, -3, 19, 12, 18, 7, -8,
    1, 2, 0, 23, 8, 0, -12, 30,
    -61, 16, 27, -13, 6, 3, 1, 16,
    2, -11, 6, 9, 1, -17, -23, -21,
    -15, 1, -10, 22, 0, -16, -28, 5,
    3, 43, -1, 6, -38, 4, 10, -6,
    -7, 11, 12, -16, -7, -24, 4, -22,
    -4, 84, -1, -6, -2, -2, -13, 28,
    5, 22, -12, 28, 37, 55, 3, 21,
    -26, 20, -4, -6, 7, -20, -9, -12,
    -3, 22, -6, -22, -5, 7, 1, 1,
    -1, 19, -3, -68, 23, 15, -26, 1,
    -28, 2, -8, -7, -34, 54, -12, 27,
    60, -5, 6, 2, 9, 1, -14, 13,
    6, 41, -36, -23, 3, 43, -18, -24,
    -4, -14, 16, 4, 3, 16, 10, -5,
    -2, 17, -10, -3, 44, 19, 8, -38,
    -21, 58, -16, -31, 8, -8, 2, -10,
    26, -28, -68, 29, -7, 13, 13, -8,
    -12, 12, -12, -21, -14, -12, 20, -8,
    4, 22, 14, -4, 11, 18, 26, -36,
    -19, 0, 16, 32, -7, 28, 2, 7,
    13, -2, 32, -21, 7, 7, 2, 3,
    8, -7, -20, -11, 2, -14, -13, 23,
    5, 11, -30, -14, -12, -17, -79, 20,
    -4, 8, 4, -19, 13, 21, 20, -8,
    -48, 3, -38, 15, 3, 7, 2, -9,
    -65, 1, -3, 68, -5, 14, -13, -15,
    5, 6, 14, 18, -23, -39, -3, -12,
    -11, 21, -9, 9, 10, 11, -46, -12,
    -18, 7, 7, 26, 19, 18, -13, 3,
    -14, -18, 2, -18, -50, 18, 13, 2,
    -12, -8, 6, -14, -29, 38, -21, 40,
    29, -18, -1, 28, 13, 19, 20, 24,
    -5, 1, 10, 3, -10, -6, 9, 31,
    -9, -13, 20, -9, 10, -2, 24, -10,
    68, -8, 30, 0, 19, 28, -21, 16,
    -36, -14, 18, 12, -22, -25, -17, 22,
    26, 37, 0, 3, -22, -10, -5, 24,
    11, -2, 13, -1, 9, -11, 17, 15,
    12, -6, 9, -7, -3, -23, -9, 14,
    -11, 17, -39, -24, -16, -11, -14, -13,
    18, -3, -48, 13, -48, -9, -33, 19,
    -11, -20, -20, -14, 18, 23, -37, -17,
    5, 9, -9, 16, 9, -11, -7, 19,
    12, -4, -10, 14, 1, 0, -2, 12,
    -18, -13, -10, 36, -5, -7, -15, 14,
    14, 17, 16, -4, -24, -7, -10, 1,
    -3, -14, 14, -8, 22, 14, 24, 17,
    -5, -6, -3, -22, -13, -12, 5, 2,
    31, 10, 39, 31, -2, -3, 1, -13,
    -4, -5, -4, -2, -7, 43, 7, -17,
    12, 3, -16, 1, -14, -26, -25, -11,
    19, 31, -33, -9, -3, 21, -2, 19,
    -14, 7, 57, 9, 18, -1, -8, -12,
    -48, 66, -16, -29, 29, -20, 24, -30,
    7, -7, -1, -48, -83, -39, 3, -41,
    -19, -4, -27, 37, -10, 14, 18, -62,
    6, 15, 35, 80, -8, 18, 44, -109,
    34, 64, -15, 24, 35, -36, 5, -48,
    -7, -14, 32, -6, 0, 10, -69, 57,
    4, -32, 32, -13, -50, -79, 11, -2,
    -2, -2, 51, 6, -44, -22, 8, -5,
    -3, 1, 33, -2, 9, 28, -16, 41,
    -9, 4, 34, -62, 15, 10, 52, 54,
    28, 5, -39, 39, 5, -15, -19, 9,
    -21, -6, -44, 84, 12, -3, 35, -30,
    -38, -25, 3, -10, -18, 64, -7, -4,
    13, -24, -12, 21, 12, -30, -39, -16,
    -32, -72, 5, -23, 13, 11, 22, 3,
    42, -55, 29, -22, 35, 34, 2, -3,
    -3, -10, 19, 3, -2, 15, -108, -5,
    15, -78, 16, -5, 4, -12, -64, -23,
    -38, 37, -9, 34, -9, -10, 13, 3,
    7, 21, -75, 24, 12, 1, -49, 17,
    -17, 39, -14, -18, 72, 24, 25, 19,
    2, -2, -47, 13, 21, -14, 2, -29,
    -2, -23, -5, -32, 3, -31, -2, 15,
    -18, 2, 69, 17, 7, -55, -40, -6,
    3, -22, 60, 33, -20, -33, -8, 24,
    43, -4, 21, 2, -33, -27, -57, -4,
    3, 11, 8, -48, 37, -22, -12, -22,
    -17, -15, 24, 52, -21, -10, 10, 9,
    -15, -37, -18, -32, 24, 61, -2, 38,
    104, 25, -33, -6, 2, -33, 5, -30,
    -26, -37, -37, 30, 34, 3, 19, -43,
    -23, 8, -2, -54, -12, -101, -35, -38,
    -97, -17, -4, -46, 3, -62, 40, -50,
    -1, -3, -14, -2, -127, 20, -36, 4,
    -1, 65, 22, 31, 1, 18, 53, 52,
    -32, -7, -21, 22, -11, -17, 22, 61,
    -7, -6, 8, 64, 5, 14, 20, 11,
    -3, -35, 36, 33, 30, 54, -13, 71,
    -7, 13, 77, -1, 3, -25, -59, -9,
    2, -41, -11, -27, 12, 6, 2, -38,
    1, -16, -16, 15, -15, -2, -16, -33,
    -7, 22, -25, 15, 21, 48, 48, 36,
    13, -45, -50, 52, 22, -13, -5, -24,
    -36, 59, 18, 15, -26, 39, 82, 13,
    0, -10, 76, 23, -22, 11, 21, -10,
    0, 0, 7, -37, 3, -12, 25, 20,
    -6, -32, 22, 23, 27, 4, -62, -7,
    37, 75, 62, 11, 27, 1, -8, -29,
    -17, 13, -6, -40, 29, -23, 29, -3,
    -45, -30, 1, 87, -12, -28, 1, 60,
    23, -21, -23, -46, 23, -6, 52, 42,
    19, 34, -26, -12, 12, -44, 10, 17,
    7, -36, 51, 2, -29, 49, 2, 9,
    23, -32, 1, 12, -31, -20, -27, -7,
    -12, 13, -15, -14, 31, 21, -16, -9,
    -37, -32, 22, 19, 24, 13, -27, -17,
    34, 9, 19, 23, -19, -55, -22, 49,
    0, -38, -2, -23, 31, -22, -36, 25,
    -35, 20, -9, 43, -10, 0, 27, 23,
    62, -31, -26, -11, -31, -28, -60, -5,
    -127, 5, -3, -12, 13, 3, 54, 31,
    12, 18, 7, -30, -29, 4, 19, 13,
    17, 25, 32, 0, 98, -17, -25, 9,
    -18, -7, -5, -8, -19, -32, -44, -27,
    -1, 31, 23, -41, -5, -43, 29, 4,
    14, 30, 3, -5, 28, 33, -4, 124,
    35, 49, 65, -16, 28, -4, -5, -4,
    -1, 18, 11, -16, 99, 0, 22, -28,
    -15, 3, 41, 36, 40, 22, 6, -29,
    -1, -19, -8, 11, -10, 18, 73, 1,
    -127, 7, 10, 51, -21, -28, 8, -30,
    0, 21, 35, 15, 15, 6, 13, 33,
    9, -6, -9, 5, -41, -1, 12, -44,
    6, 42, 13, -1, -25, 53, 40, 34,
    2, -14, 5, 16, -5, 7, -15, -3,
    -26, -24, -3, -31, 33, -6, -27, -14,
    -37, 28, -63, -11, 53, -66, -28, -60,
    6, -33, 6, -53, 30, 67, 9, -14,
    -30, -58, 3, 27, 49, -6, 64, -1,
    17, -106, 57, 3, 28, 47, 74, 55,
    -17, 103, 1, -18, 28, -3, -5, 56,
    31, -7, 54, -1, -37, 117, 20, -27,
    14, 27, 36, -2, 28, -49, -1, -7,
    2, 32, 0, -50, -13, -32, -20, -6,
    56, -43, 33, -78, 52, 8, -8, 3,
    -14, 9, 19, 0, 69, -9, -25, 78,
    43, 4, 14, -14, -10, -9, 19, 0,
    -30, 62, -54, -30, 26, 56, 72, -47,
    10, 49, -5, -48, 22, 59, 27, 50,
    -29, 13, -20, 16, -9, 10, -13, 69,
    -26, 0, -31, -18, 12, -23, -7, 12,
    20, -41, 14, -23, 6, -22, 27, 17,
    -35, 46, -8, 30, -36, -70, 59, 17,
    25, 3, -38, 9, 2, -10, -69, 10,
    23, -34, 4, 7, 33, -53, -3, 21,
    31, -44, -24, 63, 25, -11, -64, -35,
    -6, -14, -3, -39, 32, 29, -10, 58,
    13, 4, -26, 9, -4, -6, -8, 5,
    3, -6, 29, 1, 27, 38, -48, 37,
    5, -22, 64, 65, -8, -41, 65, -33,
    -90, 14, -5, 90, -4, 15, -24, -6,
    17, -11, 10, 13, -52, -31, -34, 45,
    17, -5, 0, 3, 57, -7, 30, 9,
    47, -23, 2, 40, 71, 12, -2, 9,
    -22, -32, -22, -32, -94, 7, 23, 5,
    22, -6, 32, -6, 61, -54, 39, 5,
    23, 71, 8, 42, -40, 24, 0, 41,
    -11, 20, 13, 85, 4, 1, -10, 90,
    -23, -32, 10, 21, 6, 33, 10, -35,
    12, 41, 3, -6, 10, 66, 9, -5,
    41, -45, 52, 27, -2, -10, -15, 19,
    -34, -14, -55, -11, -72, -19, 35, 0,
    76, 35, -44, 20, 49, -18, 58, 71,
    40, -25, 2, -10, 42, 18, 0, 0,
    -43, 19, -6, 8, -80, -12, 12, -48,
    -51, -52, -35, 36, -53, -21, 18, -21,
    5, 9, -28, 63, 47, 19, -84, -36,
    9, -17, 14, 33, -5, -32, -7, 44,
    65, -34, -14, -7, 9, -7, 10, 12,
    -71, -1, -6, -46, -30, -33, 11, 14,
    22, 15, 77, -19, -41, -18, -18, -14,
    44, 41, 77, -20, -20, 28, 55, 28,
    -48, -18, -44, -6, -27, 17, 3, 11,
    -21, -7, -62, 30, 7, -8, -1, 12,
    40, 23, -2, 15, -25, 43, 20, -23,
    -13, 23, 8, 15, 14, 21, -4, 24,
    9, -24, -46, -32, -20, -29, -8, -44,
    -8, 25, -2, -16, -30, 12, 4, 19,
    -24, -12, 11, -27, 49, -39, 9, 6,
    12, -4, 9, -19, 6, 3, 9, 6,
    11, -21, -49, -1, -9, -4, 10, 8,
    -19, 37, -3, 1, 43, -18, 18, 27,
    7, -30, 18, -5, 12, -19, -4, 9,
    -10, -7, 3, 1, 12, -1, 11, 9,
    53, 0, 13, 20, -18, -28, 5, 10,
    -2, -2, -2, -6, -25, -32, 31, -3,
    -43, 4, 11, -45, 9, 18, 2, -15,
    21, 0, 6, 3, 10, -2, -3, -2,
    -10, 11, -9, 4, 9, -6, -38, 11,
    -2, 8, 4, 14, 22, -20, -25, -3,
    43, -45, -8, -1, 0, -27, -17, -40,
    0, -3, -10, -3, 2, -2, 3, 5,
    32, -29, 32, -4, -5, 2, -7, -23,
    -2, 12, 5, 3, -21, 5, -35, -11,
    -16, 14, -19, -15, 13, 31, 15, 27,
    3, -7, -6, -4, -1, -12, -14, 13,
    -28, 23, -18, 15, -21, -27, 6, -6,
    -3, 17, -6, 1, 31, -7, 20, 21,
    -4, -26, -10, 18, -8, 23, -14, 14,
    -8, -1, 8, -16, 12, -3, -20, -5,
    -9, 4, 57, 37, 32, -36, -15, 17,
    -13, 4, -13, -1, -21, 13, 25, -10,
    -39, -40, -10, -10, -34, -19, 51, -2,
    2, 28, -4, 9, 6, 16, 11, -2,
    9, -2, -2, 32, -21, 12, 8, 15,
    -23, -5, 48, -8, -14, -10, 22, 63,
    5, -38, 6, -14, 33, -20, 5, 32,
    1, 9, -6, 3, -10, 16, 3, 12,
    8, 6, -6, -6, 9, -24, 24, 15,
    0, -10, 9, -6, 6, 23, 18, -14,
    -11, -22, -37, 3, -9, -17, 29, 16,
    -2, 13, -8, -1, 8, 17, -3, 16,
    -4, 5, 7, -1, -9, -29, -50, -8,
    -82, 6, 24, 1, 0, -51, -35, -2,
    5, 16, -6, 24, -12, 16, -2, -11,
    -40, 2, -17, -2, -7, -4, -5, -2,
    26, -23, -22, -2, -8, -24, -43, 26,
    1, 8, 5, 13, -37, -13, -13, -7,
    54, -14, -12, 4, 8, -5, 11, -23,
    12, -29, -39, -16, -2, 4, 3, 5,
    -40, -35, 10, -9, 13, -30, 9, -23,
    11, 14, -1, -2, 15, -1, 15, -1,
    -2, 29, -2, -32, -1, -27, 36, -5,
    15, 21, 4, -4, -7, -4, -10, -10,
    -24, -8, -30, -5, 5, -18, 3, 9,
    -5, -16, 20, 4, -26, -10, 22, 29,
    12, 29, 24, 6, 58, -11, -48, 10,
    8, 0, 11, 5, -12, 5, 14, -15,
    9, -30, -29, 20, 32, 10, 1, 2,
    2, -2, -8, 23, 24, 10, -24, -23,
    30, -32, 19, 12, -2, 9, -8, -24,
    -2, 4, 16, 13, -4, 13, 3, 10,
    6, -4, 33, 15, 2, -2, 6, 0,
    0, 0, -4, -13, -3, -8, -18, -19,
    15, 10, -33, 22, 26, 46, -19, -4,
    3, -2, -5, -19, 0, -26, -8, 17,
    30, 2, 7, -16, -6, -21, 23, 3,
    -9, 2, -1, 8, -2, 1, 58, 16,
    -29, -24, 59, 28, 28, 15, 22, 39,
    5, 14, 3, 13, -16, 0, -3, -1,
    24, -14, -17, 28, -8, 0, -23, -10,
    14, -8, -11, -23, -75, 16, -44, -21,
    6, 27, -27, -6, 8, 8, -9, 2,
    -21, -10, -8, 1, -2, -2, -2, 7,
    -5, 18, -10, 37, -24, -15, -8, -6,
    1, 7, 27, -41, 34, 20, -15, -30,
    -4, 0, 12, -30, 22, 11, 2, -26,
    20, -12, -20, 15, 8, 5, -12, 2,
    -24, -5, -8, 0, 8, -9, 20, -13,
    3, -7, 41, 15, 11, 10, -13, -7,
    -12, -7, 39, 28, -9, -5, 18, 3,
    4, 8, 0, -4, 0, -4, -6, -9,
    -33, -13, 9, -9, -16, 17, -5, 8,
    17, 13, -12, 2, -9, -10, 20, 4,
    -2, 57, 10, 13, 21, 29, -7, -10,
    12, -25, -3, -15, -11, -8, 1, 5,
    -8, -19, -9, 1, -15, -45, -9, 19,
    -1, -2, 12, 22, -16, 19, 51, 26,
    -22, 6, -23, -7, -17, -10, -3, 1,
    -10, -3, 8, 4, 4, 1, 4, 10,
    -26, -23, 13, 58, -1, -3, -34, -8,
    -2, 47, -10, -14, -1, -3, -16, 0,
    43, 26, -14, 25, 33, 18, 34, 34,
    -15, -3, 6, -2, 5, -3, -3, 15,
    24, 25, -29, 13, -9, 18, 7, -19,
    9, 10, -12, -55, -17, -21, 50, -13,
    -2, 0, -29, 13, 30, 23, -24, 13,
    -19, 7, -1, 5, 2, -4, -13, 5,
    -3, -7, -3, -4, -14, -30, -19, 42,
    12, 1, 13, -14, -4, -4, -20, 48,
    15, 22, -2, 25, -77, 23, 1, 1,
    -1, -13, -7, 4, 10, -6, -4, 2,
    -19, -1, 36, -17, 15, 10, 18, 30,
    9, 0, -22, 2, -45, 30, 1, 15,
    -33, 4, -9, 76, 57, -15, -49, 3,
    -8, -14, 3, 1, 2, -9, 3, -2,
    15, -20, 2, 9, 3, 19, 17, 2,
    0, -2, -22, 8, 5, 31, 31, 3,
    -26, -13, -18, -11, -23, -20, -18, -6,
    14, 6, 0, -13, 11, 17, -6, -7,
    28, -16, 3, 9, 12, -6, 6, 6,
    -27, 8, -6, 107, -48, 17, -8, 23,
    -12, 22, 81, -6, -19, 11, 47, 6,
    -4, 8, 14, -19, -1, 8, 0, -14,
    -51, -24, 11, 38, 39, 41, 10, -43,
    -7, -2, -14, -8, -8, -11, 1, -75,
    1, 14, -18, -25, -3, 2, -2, -33,
    -15, -17, -5, -23, 13, 6, 3, -1,
    17, 13, -1, -21, 25, 6, 20, -5,
    0, -15, -7, 6, 2, 1, -32, -14,
    20, -10, 31, -3, 14, -21, -38, 26,
    -8, 2, -24, 15, -3, 10, -11, 13,
    -21, -15, -30, -5, -1, -1, 28, 11,
    -2, 17, 13, -17, 62, 25, 0, 15,
    -10, -7, 6, 45, -10, 8, -32, -5,
    5, -5, 20, 2, -10, 14, 4, -1,
    -44, 0, -16, 16, 16, 14, 7, -19,
    -7, -3, -10, -3, 10, 38, -31, -11,
    15, 26, -7, -4, -50, -8, 21, 61,
    2, 7, -10, 4, 12, -5, -3, -16,
    -6, 32, -1, -1, -1, 13, 7, 15,
    -15, -5, 16, -13, 2, 15, 30, -18,
    -25, 20, 39, -13, 15, 7, -13, 6,
    27, -10, 12, 35, -13, -2, -14, 1,
    14, 6, -16, -32, -5, -27, 21, -28,
    9, -4, 6, -21, -19, -29, 0, 2,
    5, 3, 29, -53, 55, -17, 67, 2,
    -4, -5, 30, 8, 5, 3, 10, 9,
    20, -14, 30, -31, -3, -5, 35, 18,
    -23, 51, 1, -7, -3, -12, 26, 26,
    -37, -24, 39, 7, -33, 4, 9, -16,
    -8, -8, -16, 0, 6, -12, -4, 12,
    16, -30, 11, 15, -25, -10, -10, -20,
    -3, 8, -8, 4, -13, 3, 20, 24,
    -2, -10, -33, -46, -9, 18, 31, -7,
    28, 9, 1, -5, 1, 1, 17, -1,
    25, 3, 33, 0, 30, -4, -8, -6,
    0, -7, 3, 25, 16, -26, 3, -8,
    11, -37, 7, 0, 11, -4, -16, -21,
    -11, 9, -20, 5, -22, 5, 3, 0,
    13, -29, 8, -27, -13, 27, 2, -5,
    -7, -15, 0, -11, -38, 4, -4, -29,
    -3, 2, 12, 2, 54, 19, 13, 53,
    2, 6, -25, 1, -4, -9, -31, 10,
    -16, 35, -27, -14, 10, -10, -46, -17,
    2, 14, 7, 0, 41, 6, 25, 23,
    -11, -36, 68, -45, 3, -42, 24, -29,
    -17, 16, 19, 6, 23, 17, 4, -9,
    -19, -8, 9, -49, 22, -7, -13, 22,
    -8, 6, -7, 0, -13, -20, 14, 39,
    87, -24, 13, -42, 38, -49, 32, 5,
    -5, 18, -7, 6, 9, 23, -1, -6,
    41, 11, 8, -21, -4, 7, -4, 23,
    7, 3, 39, 9, 27, -37, -6, 42,
    41, -49, -41, -35, 8, -87, -35, -23,
    9, 39, 0, -21, 3, 23, 4, 13,
    -9, -80, 1, -15, 7, 5, 16, 22,
    9, 7, -5, -2, 1, -1, 22, -23,
    -3, -2, 37, 32, 13, 3, 4, -4,
    -3, 7, -5, 7, 0, -3, -10, 3,
    2, -29, -1, 5, 2, -23, -23, 17,
    -99, 14, -10, 7, 12, 5, -42, -19,
    7, -11, -20, -18, 15, -26, 22, -13,
    -43, -9, -17, -3, -9, 7, -12, 21,
    18, -11, -13, -13, 6, -16, -30, 29,
    -1, 0, 3, 27, -24, 15, -17, 0,
    1, 9, -14, 10, 31, 51, -32, -36,
    9, -38, -62, -19, 4, -16, 19, 0,
    14, -20, 38, 4, 10, -32, -25, -9,
    13, 3, 2, -1, -35, 23, -8, -31,
    12, 36, 6, 14, -23, -14, 41, -17,
    -4, 2, 7, 0, -7, -4, -2, 5,
    13, -5, 0, -7, 8, -14, -2, 12,
    7, -10, 21, 16, -58, 6, 28, 45,
    14, -7, 35, -6, 44, 5, -25, -3,
    -5, 6, 2, -2, -4, 2, 5, -2,
    25, -12, 2, 14, -3, 3, 24, -15,
    6, 5, -5, 4, 7, 14, -22, 3,
    41, 12, 14, -12, 10, -14, -30, -42,
    -6, 11, 21, 25, -4, 18, 5, 29,
    18, -12, 42, 14, -4, 18, 8, 19,
    -9, 11, 3, 0, 43, -7, -24, 26,
    -7, 39, -14, -2, -14, 37, 9, -51,
    25, -2, 10, -18, -4, -28, 28, 14,
    26, -10, 35, -25, 0, -54, 9, 1,
    -13, 12, -4, 1, 42, -29, 44, 15,
    52, 1, -12, -36, -3, 64, -22, 40,
    -5, 10, 0, -5, -14, 4, -4, -2,
    -15, -15, -37, -40, 22, -12, -43, -23,
    -7, -22, 1, -18, -14, 6, -24, 12,
    -1, -26, 15, 2, -3, 38, -26, -5,
    -19, -34, 0, 8, 37, -1, -11, 19,
    8, -25, -1, 13, 10, -3, -13, -16,
    -10, 8, 20, -52, -1, 13, -22, -48,
    10, -9, 12, 31, 17, 0, 11, 31,
    25, -14, -3, -6, 3, 2, 3, -1,
    -1, -4, -22, 16, -16, -1, 34, -43,
    2, -4, 37, 15, -20, 5, 12, 40,
    -42, -36, 5, 15, 34, -11, 23, -10,
    -5, 5, -4, -4, 2, -16, -4, 2,
    -5, -23, 35, 6, -31, 13, 16, 3,
    20, 2, 12, 12, -17, 4, 3, -26,
    -2, -61, 57, -37, -7, -24, -6, 6,
    22, -19, 5, -40, 9, 17, 1, 21,
    -11, 26, 25, 24, 41, -24, 5, -23,
    -20, -5, 2, 30, -17, -1, -1, 8,
    -32, 15, -14, -2, 17, -3, 30, -61,
    15, 3, 7, 15, -23, -9, -3, 4,
    -80, 2, 12, 25, -31, -9, 0, 13,
    4, 56, 1, -5, -9, -8, -7, -34,
    -49, -10, 16, 18, 40, 22, 38, 26,
    -13, -8, -1, 1, 4, -36, -5, 12,
    -30, 30, -4, 9, -36, 19, -36, -14,
    18, 13, 2, -48, -45, 5, -3, -1,
    -17, -61, 10, 43, 42, -28, 12, -15,
    -25, 10, 1, -15, -7, 25, -4, -13,
    -10, -30, 10, 4, 7, -26, -7, 27,
    8, 9, 5, -11, 11, 1, -28, 20,
    35, -24, -44, 25, -42, 107, 29, 3,
    -10, 8, -9, 28, 8, -20, 8, -29,
    -48, 7, -17, -53, -4, 6, 31, -11,
    -26, 15, 3, 15, 17, 60, 20, 13,
    52, 31, 58, 48, 20, -43, -1, 24,
    15, -13, -22, -8, -31, 25, 2, -10,
    -13, -5, -2, -16, 38, 11, 4, 10,
    3, -7, 1, -6, 10, -2, 20, 13,
    6, -20, -29, -2, -3, -44, -30, 2,
    5, 29, 11, 7, 8, -2, 27, -6,
    36, 4, 49, -13, 19, 16, -2, 4,
    -34, 1, -14, 121, -45, 12, -22, 8,
    -9, 45, 37, -34, -4, 24, 18, 26,
    11, -9, 10, 0, -11, 10, -3, -15,
    -17, 6, 27, 3, 51, 16, -23, -56,
    -5, 1, -11, -9, 14, 20, 17, -67,
    -10, 17, 23, -43, -17, -64, -6, -25,
    -28, -7, -10, 7, 10, -5, -12, 35,
    -1, 2, 2, -27, 0, -5, -15, -25,
    -2, -27, -22, -11, 17, 26, -59, 15,
    -29, -13, 59, -3, 12, -11, -11, -6,
    -19, -1, -43, 11, -15, 11, -10, 19,
    12, -16, -18, -66, 14, -18, -17, 11,
    6, 9, 18, 6, 47, -12, 9, -49,
    -15, -27, 6, -12, 6, -21, 35, 11,
    5, 7, 41, 23, -3, -2, -7, 4,
    -19, -27, -17, 17, 15, 14, 13, -33,
    -9, -2, -5, -19, -1, 20, 18, 12,
    33, 10, 2, -5, -25, -26, -46, 37,
    0, -2, -2, 6, 13, -5, -6, 6,
    5, 14, 22, 16, 30, -7, 25, -32,
    -21, 5, 3, -6, -5, 10, 14, 13,
    -10, 19, -40, -7, -41, 24, -12, -43,
    23, -10, 21, 18, 5, -5, 2, 4,
    8, -23, 4, 21, -10, -12, 59, -27,
    4, 7, 3, -18, -28, -1, 24, 19,
    -11, -13, -86, 53, 1, -24, -24, -43,
    6, -7, 41, 13, -2, -6, 13, -27,
    -21, 3, -4, -7, 26, -20, 54, -15,
    -22, 50, 12, -20, -55, -27, -48, -25,
    35, 69, -6, 12, -15, -33, 18, -4,
    -48, 11, -7, 1, -9, -89, 2, 4,
    -11, 41, 13, -19, 22, 6, -30, -25,
    6, -7, -16, -6, 57, 46, 32, 45,
    -17, -10, -16, 71, -11, 35, 24, 22,
    49, 29, -7, -9, -5, 4, 24, -2,
    10, 24, -5, -18, 34, 6, 40, 3,
    -8, -2, -2, 21, 37, -8, 11, 7,
    -76, 46, 13, -53, 39, 16, 19, 6,
    -12, -13, 0, 0, -65, -64, 57, 13,
    -27, 13, -13, 28, -14, 98, 10, 9,
    -11, -13, -8, -14, -26, 4, -15, -37,
    16, -30, -50, 7, 77, -57, -22, 28,
    1, -2, -29, 9, 13, -6, 14, 7,
    -18, 1, 3, 32, -2, 35, -42, -17,
    1, 20, 11, -6, 17, 55, -11, 48,
    -35, 79, -7, -14, 34, -11, 12, -4,
    -72, 33, 34, -1, 16, 94, 41, -21,
    42, -10, -43, -86, 14, -6, -24, 5,
    -1, -12, 6, -4, -27, 14, -66, 17,
    -50, 67, 3, -23, -5, 4, 57, -2,
    11, 6, 3, 42, 85, 30, -2, -9,
    -30, -4, -27, -37, -26, 32, -2, -3,
    -3, -20, 48, 20, -81, -48, 1, 80,
    20, 40, 9, 61, 22, -23, 18, -26,
    -11, 45, 0, -16, 4, -24, 0, -19,
    18, 12, -3, 52, -44, -54, -22, 61,
    6, -3, -5, -11, -26, 23, 24, 11,
    32, 61, 59, -4, -35, 71, 46, -9,
    1, -1, 32, 35, 6, -22, 17, 44,
    -9, 30, 45, 14, 24, 3, 42, -11,
    -96, 13, 2, -1, 9, 56, -67, -11,
    32, 3, -45, 34, -2, 4, -21, 31,
    -55, -17, -14, 0, 9, 7, -8, 41,
    25, -41, -23, -39, 10, 30, -17, 27,
    -1, 0, -11, 35, -28, -10, -2, 9,
    8, -91, -108, -14, -18, -70, -16, -32,
    8, -55, -105, -24, 15, -24, 78, -32,
    27, 45, -5, 21, -19, -7, 25, 23,
    -4, -5, -18, -5, 2, -14, -8, 46,
    -36, 29, -46, 4, -13, -35, -6, -54,
    -7, -14, 3, -14, -38, -12, -4, -5,
    -24, -11, -32, 65, 28, -3, 4, -53,
    8, -23, 32, 15, -39, -15, 56, -15,
    -11, 0, -20, -109, 84, 13, -15, -44,
    2, -16, 7, -9, -1, -20, 56, -9,
    18, 7, 13, -35, -32, 30, 14, -13,
    -1, 8, 1, 20, -8, 23, -9, -35,
    -117, -5, 32, 2, -7, 11, -56, -68,
    2, 14, 38, 68, 4, 22, 45, 44,
    7, -6, 19, -19, 16, -25, -12, 57,
    -15, 9, 18, 7, -18, 26, 64, 29,
    -9, 55, 96, -54, 47, 66, -26, 55,
    15, -4, 17, -39, -31, -42, 82, 19,
    -24, -33, 16, -25, -6, -28, 11, -33,
    14, 25, -22, 27, 49, -10, 22, -21,
    64, 33, -15, -7, -14, 127, -37, -9,
    11, 7, -5, -22, -15, 7, -17, 22,
    -19, -1, -43, -20, -25, 0, 5, 36,
    3, -9, 0, -14, -92, 18, 24, -5,
    0, -43, -5, 13, -31, 47, -29, 13,
    -52, -60, -15, 3, 97, -1, -11, 17,
    -8, 8, 26, 9, -55, 34, 40, -2,
    9, -2, 20, -42, 1, 19, 18, -10,
    11, -32, -25, 3, 45, -15, 15, -59,
    5, -3, -12, -3, 1, -2, -4, 0,
    -30, 2, -20, 53, 56, 5, 21, 5,
    14, -8, 55, -9, -19, -29, 13, 7,
    4, -13, 22, -80, 67, -7, 40, 9,
    8, -3, -7, -23, -10, -9, 5, -35,
    -5, 6, 6, -28, -16, -15, 5, -64,
    24, 10, 3, 5, 3, -2, -19, -38,
    -50, 12, -33, 40, 75, 6, -53, 11,
    -1, -42, -6, -62, 71, 23, 2, 45,
    -20, 0, -12, 57, -8, 47, 8, 51,
    1, 4, 3, 23, -4, -43, -21, 24,
    56, -8, -23, 68, 18, -6, 67, -58,
    8, 3, 19, 26, 9, -25, -1, -20,
    -52, -30, 28, 43, -8, 15, 14, -11,
    -7, 58, 14, 8, 1, 21, 21, -23,
    14, -49, 22, 23, 63, -7, 27, 27,
    -42, 3, -4, -12, 28, -38, -1, 19,
    27, -1, 25, 3, 28, -12, 25, 14,
    19, 26, -7, -56, -63, -14, -57, 15,
    25, -13, -44, -37, 7, -12, 34, -3,
    -27, -9, 0, -23, -25, 60, -39, 3,
    -50, -40, 64, -45, -24, -15, 15, -16,
    25, 7, 4, 11, 49, -74, -31, -69,
    33, -46, 48, -83, -58, 84, -45, -14,
    -11, -1, -34, 6, 0, -31, 14, -35,
    20, -50, -40, -25, 39, -32, -37, -92,
    -9, 26, 3, 9, 37, 22, 104, -12,
    -1, -40, 42, -103, -11, -20, -30, -8,
    25, -13, -2, -14, -71, 53, -12, 8,
    17, 17, 55, 28, -12, 13, 43, -102,
    -3, -11, 5, 11, -18, -39, 53, -28,
    -31, 62, 4, 11, -23, -56, -78, -2,
    4, 49, 18, 8, 7, -8, 88, -1,
    20, -41, -13, 12, 14, 50, -16, -13,
    -37, 0, -7, 127, -56, 54, -34, 17,
    -36, -37, 5, -27, 16, -16, 8, -32,
    24, -2, 19, 15, -61, 37, -7, -7,
    -37, 12, 9, 40, 5, -59, -19, -34,
    15, 5, -19, -12, 17, 1, 3, -33,
    -32, -20, 14, 80, 72, -93, 28, -12,
    -51, 0, -22, -10, 36, 8, -22, 62,
    20, -25, 4, -38, -10, 38, 70, -12,
    -18, -35, -16, 3, 21, 10, 27, 28,
    -14, 36, -71, 26, 31, -32, -19, -13,
    -26, -1, -66, 6, -11, 15, -20, -1,
    -25, 11, 58, 3, 52, 8, 5, 27,
    21, 22, -4, 10, 83, 37, -24, 32,
    -20, 46, 29, -80, -5, -18, -9, -1,
    14, -4, 93, 2, 10, -30, 3, 32,
    -6, -3, -39, -16, 23, 38, -52, -5,
    -21, -7, 5, 3, -32, 43, 20, -9,
    17, 11, -26, -57, -68, 22, 10, 39,
    13, 3, -3, -14, -2, 4, 1, -20,
    19, 24, 17, -2, 13, -19, 12, -89,
    -39, 4, 21, 13, 13, -23, 28, 38,
    55, -56, -18, -13, 18, 19, 0, -83,
    39, -36, 61, 29, -27, -36, 3, -40,
    6, -42, -19, 22, -33, -6, 65, 45,
    -6, 8, -7, -12, 30, 86, 37, 48,
    -8, 24, 11, -28, 15, -30, -13, -26,
    -13, -5, 0, -33, -5, -11, 29, -13,
    31, 14, 10, 44, 25, -4, -9, 12,
    7, 14, -11, -3, -4, -12, 18, -9,
    -38, -3, 13, 3, 5, 17, -20, 17,
    -29, 16, 21, 12, -11, -5, 17, -7,
    -39, 1, -4, -21, -11, -28, -1, -1,
    -28, -66, 10, -1, 17, 32, -18, 1,
    2, -4, -28, 6, -3, -6, -5, -12,
    63, 3, 48, -26, 12, 4, 41, -1,
    -28, -21, -21, 1, -4, 9, 35, 3,
    -17, -6, -16, 23, 13, 1, -23, -16,
    2, 5, -17, -13, 10, -21, 30, 1,
    4, -54, 20, -12, -8, -7, 35, -19,
    12, -31, 26, -1, 0, 3, 2, 11,
    31, 8, -11, -16, -11, -6, 23, 17,
    -4, 30, -13, 4, 1, 10, 17, -36,
    23, -3, 10, -24, 24, 19, 14, -11,
    -6, 19, 3, 31, -9, 6, 9, 12,
    -47, -21, -31, -20, 9, -10, -7, -16,
    17, 11, 12, 3, -8, -19, 1, -14,
    7, -40, -10, -24, 11, -18, 24, -9,
    -20, 43, -5, -21, 13, -9, -38, -4,
    -10, -12, -36, -6, -10, 3, 0, 7,
    1, 7, -21, 9, 5, -8, 22, 3,
    -22, 10, -7, -34, 11, -48, -14, -30,
    -8, 19, 10, -5, -20, 21, 9, -15,
    17, 8, 24, -22, -10, -3, 6, -7,
    -2, 15, 31, 8, -26, -2, -14, -22,
    -46, -14, 21, -6, -23, 10, -1, 3,
    -37, -26, -13, 27, -1, 35, -23, 32,
    -25, -10, -12, 9, -22, 1, -17, -10,
    -1, 10, 10, -22, -1, 15, 6, 6,
    -6, 23, 10, 9, -9, 19, 2, -9,
    -33, -23, 21, -24, -7, 20, -40, 12,
    4, 9, 20, -11, 19, 19, 20, 6,
    -11, -8, -16, -3, 8, 12, -29, 26,
    19, 10, -39, -8, -3, -3, -5, -29,
    1, -1, 27, -34, 8, 5, -5, -26,
    -31, 53, -40, -3, -23, -4, 10, 3,
    -19, -18, -15, 3, -10, -11, 5, 16,
    24, -35, -8, -21, -10, 9, -5, 11,
    16, -4, 11, 1, 7, 33, -31, 8,
    -28, -33, -9, -2, -18, 15, 3, -5,
    -5, 7, -15, 5, 4, 33, -12, 7,
    -42, 9, -28, 7, 13, 0, 9, -21,
    -6, -19, -2, 3, -1, -2, 22, 11,
    -5, 19, 0, 22, 12, 19, -19, -1,
    11, 4, -13, -5, 7, -8, -14, -2,
    -22, -12, -20, 3, 1, -4, -31, 10,
    31, -6, -17, 2, -60, 7, 1, -3,
    -17, -7, -13, 27, -16, 9, -2, 10,
    4, 25, 16, -2, 22, -16, -1, -9,
    -13, -29, -18, -25, 6, 10, -24, 2,
    39, -7, -28, -6, 7, 19, -11, -26,
    36, 21, 2, -36, 18, -9, 9, -21,
    15, -11, 0, 5, 15, 5, 1, -15,
    -31, -9, -36, -17, -1, 14, -6, -23,
    -9, -3, 26, 6, -16, 5, 3, 0,
    -24, -17, 11, -8, 20, -11, -25, 1,
    -38, 7, 15, -11, -30, -36, 5, -10,
    29, 4, -19, -4, -23, -30, 0, -2,
    -5, -20, -32, 26, -1, -24, 53, 24,
    -17, -38, 16, -13, -26, -11, -18, 14,
    -3, -7, 0, -23, 9, -5, 7, 54,
    14, -34, 1, 16, -18, -2, 6, 29,
    41, 14, 2, -31, -8, -29, 20, 6,
    9, -21, -5, -14, -12, -17, -9, 21,
    -2, -2, 27, 18, -6, -1, -3, 6,
    8, 6, 6, 36, 7, 47, -26, 21,
    -23, 16, 32, 20, 13, 13, 1, -16,
    26, -9, -7, -6, -12, 24, 10, -30,
    8, -18, -22, 5, -13, -6, -38, -8,
    -13, -3, 14, 38, -13, -19, -10, 1,
    -15, 18, -32, -21, 22, -2, 14, 8,
    -3, 5, -5, 0, 4, -23, -10, -19,
    26, -29, -30, 24, 5, -12, 1, -10,
    18, 37, 6, 47, 2, -19, 20, -8,
    -17, 9, 19, -17, 8, -1, 9, 43,
    3, -5, 13, -6, 3, -34, -32, -24,
    6, 8, 27, 3, 8, 2, 13, 10,
    -27, -37, 7, 4, 7, -7, 2, -15,
    11, -21, -5, 30, -6, 13, -10, -17,
    51, 11, -26, 21, -3, 1, -44, 34,
    -9, -1, -12, -15, -36, -17, -28, 22,
    1, -9, -34, 1, 2, 23, -14, 10,
    -25, -26, 22, -30, 0, 16, -26, 0,
    -33, -17, 14, 3, -14, -1, -1, 1,
    -7, 3, 10, 9, 9, 1, -14, 4,
    -13, -10, 45, -28, -17, 14, 2, -6,
    3, -10, -17, 0, 14, 12, 10, 16,
    -22, -7, 0, 17, -13, -12, 15, -27,
    2, 22, -13, -5, -3, 10, 4, -14,
    4, 8, -29, -9, 11, 13, 27, -20,
    0, -5, 0, 13, 31, -8, -16, 1,
    -2, -24, -28, -5, 28, 11, -16, -13,
    -16, 9, 5, 6, 8, 10, -1, -11,
    20, -1, 2, 18, 9, 15, 6, -20,
    19, -17, 7, 45, -25, -50, -33, -14,
    61, -12, -2, 35, 3, 2, 30, -12,
    -4, -11, 14, 11, 11, 8, 6, 30,
    13, 13, 0, 16, -13, 6, 20, -29,
    -18, -10, -8, 12, 10, -2, -20, -6,
    -24, 9, 18, 5, 4, -17, 15, -9,
    -8, -9, -5, -18, -22, 2, 12, -7,
    11, 31, 3, -10, 2, -50, 17, 0,
    28, 36, 3, 17, -7, 2, -8, -15,
    10, 29, 14, -5, 2, 16, -14, 14,
    -4, 8, -4, -1, 19, -9, 16, -26,
    50, -18, 14, -45, -6, 17, -9, -1,
    -25, 21, 27, 9, 3, -17, -25, 27,
    -58, 1, -36, 15, 4, -21, -19, 30,
    -11, 2, 10, -20, -8, 11, -4, -12,
    35, -9, -12, -16, 24, -3, 0, -2,
    -45, 14, 27, -8, 14, 0, -14, 32,
    -32, -19, 13, 1, 19, 1, -20, 24,
    24, 8, -11, -17, 11, -4, 8, 3,
    -8, -16, 11, -1, 1, -18, -18, -23,
    -1, 9, -4, -5, -23, -3, 0, 20,
    3, 10, 21, -16, 2, -4, 19, -1,
    5, -44, 8, 16, 2, -17, -37, -8,
    31, 28, -14, -22, 1, -7, 12, -10,
    -19, -19, -2, 22, 7, 5, -2, -6,
    -15, 45, -17, -11, 29, -28, -3, 0,
    18, -14, -23, -26, 15, -19, 26, 10,
    12, -69, -44, -17, -2, 7, -8, -1,
    8, 19, 15, -3, -7, 24, 9, 9,
    26, -4, -6, -24, -3, 3, -13, -22,
    -6, 22, 37, -2, -24, -45, 11, 2,
    -53, 17, 18, 10, -2, 4, -9, -13,
    20, 8, 36, -3, 6, -11, 6, -37,
    -20, 14, -43, 25, 4, 5, -24, 17,
    1, -26, 14, 11, 10, 7, -13, 11,
    -23, 12, -10, 25, -12, 31, 16, -18,
    70, 40, -45, -6, 12, -6, -1, 35,
    61, -9, -1, 3, -19, 17, -6, 1,
    9, 1, 7, -4, -1, -13, -8, -5,
    18, 9, -83, 44, -4, 23, -14, -6,
    -3, -19, 24, -10, -6, -3, 33, 8,
    11, -11, 41, 16, 7, -6, 7, -23,
    6, 5, 26, -9, 39, 16, 14, 20,
    -43, -11, -8, -5, 15, -3, -8, 0,
    -6, 11, -7, 3, 15, 43, -12, 8,
    20, -22, -9, -29, -6, -13, 7, -25,
    12, 1, -2, 3, 7, -1, 4, -31,
    -15, 32, -64, -39, -10, -2, 28, 24,
    -6, 9, -8, 54, 21, -6, -2, 2,
    18, 26, 35, -41, -7, 5, -2, 1,
    26, 16, 5, 23, -3, -22, 6, -49,
    9, 1, -3, 36, -17, -12, 3, -22,
    32, 62, -31, -8, 7, -48, -21, 14,
    -4, 25, -6, 16, 2, -24, 6, -9,
    13, -5, -9, 33, -7, -12, -5, -22,
    5, -5, -15, -13, -20, -4, -15, 10,
    -89, -21, -17, 45, -14, 30, 3, 14,
    -9, -2, 8, 6, 2, 25, 7, -5,
    4, 25, 26, -14, -4, -14, 16, -9,
    -47, 49, 13, -21, 38, -12, 23, -30,
    -51, 33, 33, -1, -5, -22, -1, -19,
    -65, -1, -6, -34, 1, 18, -14, 5,
    -2, -21, 5, 26, -33, 27, 6, -9,
    -26, -36, 44, -15, -23, -12, 28, 20,
    -46, -43, 35, -10, -29, -29, 15, 14,
    -11, -68, -31, -16, 13, 33, -54, -11,
    -15, -11, -12, -3, 5, 9, -10, 22,
    3, -3, -7, 0, -7, 13, 0, -21,
    25, 41, -10, 5, -5, -11, 1, 0,
    18, 93, -30, 7, -8, -5, -11, -5,
    6, -40, -31, 4, -2, 11, -2, 4,
    9, -69, -56, 21, 4, -2, -15, 17,
    -11, -35, 15, -44, 7, -6, -19, -12,
    -2, -61, 15, -11, 20, -27, -19, 9,
    -21, 9, -30, 19, 23, 22, 2, 6,
    5, -27, 24, 35, 22, -22, 9, -31,
    -25, 1, -58, 13, 3, -3, 18, 17,
    12, 0, 23, -10, 3, 14, 7, -7,
    6, 14, -16, 5, 1, 24, 15, 14,
    -45, -1, 2, -10, -12, -10, -6, -15,
    -18, 23, -51, -2, -3, -2, -5, 16,
    17, 26, -45, -43, 10, -1, 19, -25,
    26, 10, 13, 2, 8, -19, 0, 7,
    25, -7, -18, 66, -39, -4, 7, -6,
    18, 11, -20, -21, -4, 19, -40, -11,
    -27, -15, -6, -29, 48, -15, 21, 8,
    20, -14, 2, -5, 1, 9, 8, -6,
    41, 7, 24, -21, 37, -19, -52, -13,
    4, -9, -9, 29, -10, -27, 13, -3,
    15, 7, 12, -33, -9, 7, 34, 17,
    -31, -8, 15, 7, 5, -52, 21, 11,
    37, -7, 2, 49, -17, 1, 20, -12,
    -32, 4, -7, 60, -7, -2, 27, 3,
    -39, -24, 16, -18, -14, 1, -2, 20,
    1, 5, -18, -13, 12, -7, 4, 76,
    -72, 33, 67, 16, 60, 2, 22, 20,
    17, 26, -10, 11, 19, 13, 0, -1,
    18, -5, -19, -17, -26, 12, 6, -1,
    -7, -12, -14, -11, -14, -9, -8, -10,
    22, -6, 16, 68, 6, 33, -28, -46,
    7, 2, -1, -52, -5, 13, -30, -14,
    17, -72, -4, -29, -18, -16, 19, -7,
    19, 8, -26, 13, -13, 7, -24, 2,
    21, 22, 8, 20, -24, 17, -17, -3,
    0, -23, -11, 2, 2, 2, 3, -1,
    -15, -24, 31, -1, 4, -8, -20, -7,
    20, -23, -3, 10, 12, -5, 5, -9,
    -12, -80, -10, -68, 11, 8, 15, -26,
    5, 25, 6, 13, -10, 10, 2, 18,
    23, 47, -22, -19, -26, -19, -21, 5,
    -30, -2, -18, 1, 12, 25, -10, -3,
    13, -11, -4, 4, 18, -33, 14, 5,
    14, 14, 6, 64, 21, -14, 6, -18,
    -7, 21, -29, -3, 13, 5, 1, -11,
    1, 37, 9, 0, -34, -13, 6, 8,
    -1, -24, -7, -28, 32, -50, 49, 7,
    28, 0, 33, -5, 61, 7, 33, -6,
    26, 22, 31, 40, -8, -10, -21, -18,
    -22, 7, 3, -10, -3, -1, 23, 27,
    -16, -93, 48, 76, 28, -3, -17, -2,
    34, 14, 21, -9, 6, 6, -30, -18,
    3, 23, -59, -58, -14, -8, 15, -5,
    0, 21, 31, 11, 5, -22, 5, 2,
    3, -24, -27, 50, 21, -37, -41, -9,
    2, -35, 31, -25, 30, 3, -30, -33,
    -17, 67, 38, 12, 9, 36, 23, 0,
    -9, -4, -35, -15, -1, -6, 2, -10,
    -4, 45, 9, -28, 31, 7, 28, 14,
    -2, -18, -17, -8, -32, -20, 12, -12,
    24, -27, -85, -24, -11, 1, 0, -2,
    -7, 12, 16, 11, -23, 4, 9, 64,
    26, 27, -12, 45, -17, 6, -2, -18,
    -48, -31, 10, -13, 16, 20, 1, -3,
    -16, -1, -25, -13, 9, 12, -5, 6,
    -16, 3, -2, 4, -1, 20, 23, -9,
    5, -19, 28, -58, 12, -18, -7, 27,
    -14, -10, -6, 32, -1, 20, -24, -3,
    -13, 4, -27, -14, 33, 18, 19, -17,
    -6, -12, -20, 2, 15, 6, 18, 15,
    13, -33, 11, 30, -44, 4, 40, -1,
    24, -11, 50, 43, -28, -5, -5, -17,
    0, -13, 14, -16, 20, -8, -5, 1,
    -1, -10, -11, -25, -5, 14, -12, -6,
    9, -16, 16, 3, 12, 20, 6, -6,
    5, -9, -23, 15, 18, 8, 23, 39,
    42, -14, -16, 4, 18, 27, -5, 35,
    1, -15, -3, 8, -36, -25, -21, -17,
    6, -23, -4, -8, 33, -19, 4, -3,
    -5, 12, -14, 16, 14, 20, -1, -25,
    8, 0, 68, 38, 30, 25, 16, 7,
    35, -15, -4, -10, -17, -13, -35, -8,
    24, 27, -15, -50, -10, -50, 30, 33,
    21, 27, -54, -3, -15, -18, -1, -14,
    5, -50, -71, -16, 60, -10, 27, -21,
    -13, 9, -7, -4, -1, 0, 20, 2,
    9, 48, -38, 7, 34, 5, -19, 21,
    -7, 50, -31, -47, -14, 2, -6, 4,
    -22, 6, 7, -39, 23, 9, 2, 12,
    2, 0, 2, 35, -28, -40, -7, -21,
    26, -5, 13, -30, 13, -7, 6, 37,
    40, -5, 23, -36, 1, -21, 67, 18,
    9, 12, 59, -127, 35, -16, 11, -28,
    -21, -28, -11, -40, 37, 16, -28, 3,
    4, 64, 72, 4, 5, 8, 7, -37,
    -16, 11, 15, 61, -4, -78, 15, -63,
    -35, -73, -22, 3, -54, 27, 25, -14,
    -10, 26, 9, -1, 9, 45, 5, -10,
    -15, -20, 47, 48, 3, -6, -36, 35,
    -7, -33, 24, -11, -8, 2, -81, -28,
    41, 3, -17, 40, -28, -5, 28, -63,
    12, -9, -32, -6, 8, 27, 10, -17,
    0, 64, -19, 18, -20, -33, -16, 6,
    -43, 24, -33, 17, -5, -65, -23, -20,
    57, -9, -12, -30, 28, 30, 18, -36,
    -20, -42, 12, 36, -17, -2, -37, 22,
    -28, 42, -47, -82, 0, -42, -5, -19,
    28, -24, -33, -3, -10, -33, -5, 1,
    23, 87, 11, -26, -7, -26, 29, 22,
    4, 4, 26, 22, -35, -14, 15, -41,
    -24, 20, -8, 65, 11, -34, -2, -5,
    5, -26, 27, 2, -33, 14, 41, -9,
    -56, -62, -1, -38, 27, 8, -9, -19,
    -3, 29, -17, -4, -14, -14, -11, 1,
    62, 30, -17, 82, 15, -34, 4, 11,
    35, -14, 3, 29, 44, -35, 3, -48,
    78, -36, 14, 12, 2, -51, -6, 8,
    25, 23, 10, -1, -42, 14, 4, 8,
    -22, 57, -10, -29, 102, 4, -26, -19,
    -53, -10, -22, -44, 43, 33, 17, -87,
    -89, -36, -19, -13, 28, 6, -24, 41,
    -12, 14, -30, -15, -64, -8, 20, -22,
    -14, 13, 8, 63, -10, 16, 37, 5,
    -20, 0, 50, 22, -5, -17, 24, -1,
    11, 19, 13, 51, -22, -22, -26, 44,
    -4, 1, -10, 15, 27, 35, -15, 80,
    27, 42, -39, 16, 2, -24, 4, -43,
    -31, 14, 15, 28, -44, -23, 1, -12,
    22, 28, -5, 30, -15, 1, 35, -11,
    -48, 3, -17, 32, 34, -4, 4, 27,
    50, 56, 86, -22, -43, 14, -4, 4,
    -14, 52, -60, -27, 11, -21, 2, -38,
    -12, -6, 34, 10, 127, -23, -40, -27,
    4, -4, -30, -2, 12, 17, 21, -23,
    37, 29, -42, -40, -1, -11, -39, 39,
    -1, 48, 11, 21, -1, -50, 25, -3,
    16, 53, 32, -32, -25, -20, -5, -30,
    4, -12, 1, 7, 13, -11, 49, 16,
    -10, -46, -59, 0, -10, 13, 9, -18,
    -96, -33, -17, 28, 94, 35, 29, -1,
    8, -56, -27, 27, 53, -14, 28, 7,
    11, -32, 36, -1, -4, -20, 13, -10,
    -19, -25, 4, 0, -37, -6, -47, 30,
    17, -33, -52, -50, 50, 18, -24, 5,
    -2, 0, -36, -53, 20, -32, 9, -41,
    -6, -1, -29, 28, 4, 26, 23, 2,
    -30, -11, -28, -25, 6, -4, -43, -22,
    44, -71, -31, -10, 18, 7, -28, 2,
    -4, 35, -62, 37, -23, 3, 2, 1,
    -23, -37, -9, 4, 4, -49, -13, -13,
    82, -49, 14, -9, 4, 6, 14, 13,
    -7, -17, 34, 14, 51, 31, -26, 26,
    -34, -51, -27, -62, -51, 55, -27, 12,
    12, 15, 18, -12, 9, -8, 31, 98,
    46, -13, -79, 8, -33, 31, 5, 10,
    -45, -17, -5, 18, -1, -24, -24, 16,
    -37, -38, 25, -23, 27, -32, -26, 12,
    16, -35, 14, -2, 22, -5, -39, -2,
    2, -15, -10, -61, -40, -44, -28, 40,
    47, -11, -12, -2, -4, 0, -8, 31,
    36, -6, 6, 96, -25, -1, 20, 5,
    10, 23, -40, -12, -39, 1, -65, 13,
    -21, 14, 31, -9, -9, -9, -4, 28,
    -6, -3, -3, 0, -22, -6, 27, 35,
    -14, -45, 13, 13, -10, 12, -27, 24,
    0, 14, 20, 22, 12, -14, -12, 10,
    21, 5, 1, -74, 10, 49, 1, -19,
    13, 32, 6, -26, -7, -31, 9, -55,
    35, -21, 61, -28, 12, 48, 8, 22,
    -19, 24, -24, 0, 22, 75, 14, 32,
    -41, -53, 30, 16, -44, -14, 28, 101,
    13, 26, 62, -38, -53, -11, 65, -13,
    42, 41, 19, 12, -27, -9, 72, -21,
    6, -15, -9, -1, -13, -29, 13, 8,
    28, -26, -11, -25, -9, -40, 30, 12,
    20, -53, 28, 7, -24, -33, 11, 15,
    14, 28, 17, 26, -26, 16, 42, -2,
    6, -25, 13, 32, 40, 5, -8, 30,
    -11, 14, -1, -56, 63, -21, 4, 20,
    -23, 16, 0, -17, 50, 6, 32, 34,
    31, -6, -12, -52, -22, 13, 23, -35,
    14, 43, -10, 5, 25, 34, 22, 27,
    -4, -1, 42, -28, -14, -24, -38, 7,
    47, 18, -29, 26, -28, -25, 11, 60,
    -10, -31, -14, -17, 8, 94, 12, 53,
    12, 13, 41, -11, -4, -22, 2, -33,
    -54, 36, -29, -24, 54, 10, -28, -12,
    57, -6, -39, 22, 10, 41, -36, 13,
    19, -23, 20, 24, 7, -11, -40, 29,
    -15, -12, 1, 28, -17, 8, -10, 84,
    44, -3, -38, 33, 25, -16, -6, -17,
    15, -75, -19, -14, -23, -21, 23, -17,
    3, -17, -16, -38, 11, -25, -20, -8,
    11, -3, 17, 17, -18, 14, -10, 6,
    24, 22, 10, 45, 28, 2, -19, -9,
    34, 33, 24, 49, -35, 20, 9, -41,
    -75, 2, 27, 28, 32, 71, 17, 8,
    -5, 0, 43, -32, -3, 34, 56, 15,
    -57, 17, -71, -8, -31, -37, -21, 24,
    -58, -26, -86, 68, 36, -5, -11, -29,
    -42, -5, 25, -71, 9, -27, -7, 11,
    6, 39, 35, 19, -28, 37, -15, -20,
    3, -65, 12, 63, -8, 8, 14, 19,
    -12, -2, -62, 4, -20, 36, 41, -48,
    38, -53, 107, -4, 5, 27, 48, -34,
    46, -11, -18, -3, 5, -13, 9, -4,
    45, -21, 13, 14, 16, -10, -13, -39,
    4, -25, 8, 6, -22, 31, -15, 8,
    49, -15, 6, 21, 12, -3, 33, 18,
    66, 63, -5, -17, 5, 3, -6, -32,
    13, -32, 50, 66, -10, -37, -20, 0,
    41, 39, -59, 25, -45, -45, 52, 26,
    -17, -54, -119, 21, 37, 7, 53, -19,
    -27, -11, 15, 21, -5, -7, 5, 17,
    -4, -19, -25, 29, -13, -21, 14, -12,
    -18, -36, -40, -7, 1, -21, -17, -17,
    -92, 10, 55, -15, -2, -2, -49, -19,
    -17, -6, -28, -11, -21, -25, 20, -11,
    -28, -43, 18, 38, -6, 5, -51, -2,
    -17, -32, 72, 2, 4, 3, 10, 1,
    0, 3, 11, 16, 12, 10, -11, 33,
    32, 1, 15, -1, 10, -27, -8, 17,
    12, -5, -16, -26, 6, 26, -3, -31,
    8, -17, -5, -38, 2, 5, -9, -4,
    -25, 13, -6, 12, 24, 41, -28, -10,
    -19, -20, 17, 8, -9, -2, 0, 24,
    36, 38, -8, -3, -11, -4, 19, 0,
    -4, -13, -17, -10, -26, 7, -5, -30,
    -1, -20, -14, 26, -3, -8, -14, 52,
    -19, -19, 3, -2, -17, -12, 32, -11,
    3, 23, -21, -15, -48, -2, 25, 50,
    -1, 7, -9, -60, 14, 3, -5, -17,
    12, 21, -33, -6, -22, 26, -3, -13,
    5, -7, 4, 8, 23, 20, 31, 6,
    2, -21, 14, 20, 14, 13, -24, -8,
    -8, -36, 27, -2, 5, -4, -9, -1,
    -4, 14, 34, -2, 0, 0, 37, 28,
    39, -9, -12, 25, -3, 28, 6, -16,
    18, -12, -9, -52, 2, -6, -56, 7,
    -15, 7, -44, 17, -25, -2, 21, -7,
    -17, -11, -3, 8, 10, -13, 5, -36,
    8, 2, -10, 18, -14, -5, 0, -5,
    -13, -21, -12, -12, -10, 47, 13, -12,
    -14, 6, 2, -5, 21, -1, 4, 16,
    -41, 14, -14, 9, 12, 74, 2, 7,
    -3, -16, -3, -36, 0, -28, -12, -18,
    37, 23, 8, 20, 9, -56, 1, 12,
    22, 15, 14, 4, 12, 9, -23, -16,
    -10, -27, -2, 21, 6, 3, 8, 12,
    -25, 7, -20, -27, 13, -37, -15, -7,
    -22, 17, 20, 22, 3, 25, 2, -26,
    18, -9, 16, 40, -8, -16, 2, 9,
    16, 9, -29, 8, -36, -11, -16, 2,
    -21, 19, -41, -5, -19, -2, 9, 8,
    -26, 31, -7, 13, 9, 49, 4, 48,
    -32, -45, -27, -21, 10, 1, 9, 3,
    -9, -23, -20, 18, -36, 21, 14, 6,
    28, -7, -6, 10, -32, 35, 7, -9,
    -6, 5, -10, -40, -35, -18, -17, -2,
    19, 1, -11, -30, 33, 8, 6, 22,
    11, -17, -6, -13, 4, 19, -12, 2,
    -44, 25, 2, -16, 13, 2, -7, 12,
    -7, -31, -10, 40, 8, 22, -22, -8,
    6, 1, -2, -32, 9, -12, 22, -3,
    19, 10, -14, -17, 2, -1, -61, 32,
    -14, -18, 26, 16, 10, 21, 11, -9,
    3, 30, 5, 26, -7, 43, 10, -8,
    -31, -7, -41, 14, 8, 2, 12, 4,
    13, 10, 12, 4, -26, 4, -24, -6,
    -15, 4, 7, -10, 8, -2, 17, 6,
    -12, 22, -27, -16, -31, -56, -35, -55,
    5, 24, 10, 12, -3, -3, 25, -5,
    3, 0, -1, -26, -22, 2, -15, 4,
    -24, 11, -42, -12, 28, 7, -27, -16,
    -21, -3, -25, 2, 39, 10, -45, -19,
    -5, -33, -22, 13, 0, -13, 17, -7,
    19, -21, 21, 11, 1, -7, -23, 29,
    13, 1, 23, -19, 0, -3, 4, 22,
    -3, 31, 6, -33, 9, -54, -16, 9,
    11, -57, -22, -22, 6, 10, 0, -25,
    -7, -6, 1, -1, 46, -8, 20, -11,
    -21, 32, 52, 34, -18, 14, 0, 19,
    -3, 21, -28, -32, 13, 20, 10, 4,
    46, 24, -17, 0, 4, 21, -16, -10,
    -14, 22, 4, -1, -25, 24, 13, 23,
    12, 62, 15, 4, -10, -17, 7, -6,
    -8, -67, 63, -20, -25, -8, -49, -49,
    -15, 56, -15, 13, 4, -16, -16, -20,
    1, 19, 0, 6, -10, 13, 0, -26,
    0, 5, 1, -31, -11, 6, 6, -4,
    -32, 3, 53, 22, 11, 5, -17, -44,
    -2, -24, 9, 21, -3, -7, 8, -25,
    29, -20, -21, -28, 26, -11, -22, -46,
    -19, -10, -17, 14, -31, 13, -33, -8,
    14, -32, 32, -12, 8, -21, -47, 4,
    2, 16, 4, 16, -23, -9, 29, -25,
    -3, -24, 4, -3, -11, -7, 19, -15,
    -20, -12, 27, -10, -5, -5, 19, 1,
    -58, 34, -72, 10, 11, -9, -35, -19,
    -1, 15, -14, -15, 10, 15, -3, 10,
    -13, 7, 14, -15, 20, -1, 34, 24,
    -2, 8, -21, 3, 6, -28, -19, 24,
    17, -14, -23, 5, -23, -1, 13, 1,
    -48, 17, 21, 44, 2, -2, 13, 6,
    -23, -18, 30, -3, 4, -33, -42, -16,
    2, -21, 8, -15, 11, 17, 1, 12,
    -2, -5, 13, -9, 1, 12, -31, 14,
    -42, -9, -6, -16, -9, 0, -9, 29,
    -6, -25, -14, -4, -19, 46, 29, 4,
    15, 33, -31, 14, 7, -14, -15, 8,
    39, -12, -14, 3, 16, -8, -10, -43,
    9, -1, 29, 32, -24, 21, -4, -13,
    3, -5, -5, -10, 0, -52, -1, 17,
    -3, -11, -7, -23, 5, 12, 20, -13,
    -29, -17, -20, -20, -43, 10, 33, -43,
    -39, 18, 37, 6, 20, -3, -12, 14,
    -7, 4, 27, -20, -36, 66, -32, 29,
    2, 0, -39, -31, -10, 17, 5, -16,
    -4, 13, 11, -51, 24, 8, 27, 11,
    -3, -4, 4, -9, 8, -10, -14, -12,
    8, -16, 16, 20, 15, -16, 13, -13,
    23, 14, -4, 29, 14, 6, 29, -1,
    10, -38, 1, -46, -34, -31, -16, 38,
    27, 8, 13, 41, -5, 0, -20, 17,
    26, -13, 24, -32, 9, 9, 25, 4,
    12, 7, -3, 1, 12, -3, -6, 22,
    -8, 25, -18, -2, -35, -4, 16, 51,
    -35, 27, 3, 34, 12, -1, 24, -5,
    -8, -28, 4, -6, -20, -20, -2, -21,
    15, -18, 0, 17, 37, 21, -2, -14,
    -24, 3, 49, 25, 42, -3, -10, -5,
    9, 8, 15, -6, -2, 3, 16, -8,
    -8, 20, 17, -8, 9, -3, 23, 3,
    -6, 16, 8, 3, 21, 7, -8, -10,
    16, -25, 6, -15, 37, 34, 20, -11,
    23, 7, 31, -13, 19, -2, -6, -6,
    10, -8, 11, -8, 41, 5, 36, -14,
    6, -20, 15, 10, 2, 8, 5, -30,
    -12, 51, 19, 6, -47, 9, 52, 32,
    3, 13, -26, -13, -1, 11, -3, 20,
    -4, -23, 25, 4, -15, -4, -9, -13,
    20, -21, -20, 6, -4, 16, -34, 0,
    41, 23, -24, 35, 50, 13, 0, -41,
    -13, 17, 30, 30, 15, -30, 1, -13,
    -3, -10, -20, 16, 17, 54, 24, 22,
    -11, 2, -44, 9, -23, -11, 9, 11,
    -18, -20, 4, -5, -2, 20, -30, 27,
    3, -29, 5, -44, -1, 3, 6, -14,
    4, -13, -2, -31, 39, 27, -2, 9,
    5, -28, 26, -15, 7, 17, -8, 19,
    10, -11, -4, 4, -38, 7, 18, -43,
    30, -9, -7, -13, 1, 6, -19, -3,
    41, -2, -10, 21, 0, -12, -24, 4,
    -31, -19, -92, 80, -3, -11, 13, 0,
    5, 0, -47, 10, 8, -9, -20, -31,
    19, -7, 21, -25, 4, 17, -16, -13,
    -4, -32, -32, -30, 6, -11, 2, 23,
    -21, -36, -46, 73, -2, 14, 2, 6,
    -2, -26, 11, -2, -1, -60, 19, -2,
    17, 35, 26, -36, -19, -8, -9, -1,
    41, 4, 4, -13, -29, -33, 47, -27,
    30, -24, 26, 37, 12, 11, -4, 21,
    -25, -77, 25, -9, -6, 17, 6, 51,
    13, -39, -24, 11, -25, 11, 35, 5,
    0, -9, -8, 1, -8, 16, 73, 19,
    54, 25, 53, 65, 43, -2, -13, -25,
    7, -8, 54, 2, 8, -40, -2, -48,
    -15, 13, 0, 11, -29, 38, 22, -45,
    14, -7, -12, -20, 18, -26, -28, 3,
    2, -24, -2, 26, 54, 10, 6, -19,
    25, -46, -7, -11, -53, 53, 9, 3,
    -58, -32, -4, -29, 1, 30, 19, 4,
    -6, -24, -20, -4, -29, 56, 16, -1,
    39, 23, 15, -12, 20, -53, -40, 2,
    48, 25, -11, -2, 15, 22, -9, -14,
    28, 77, 37, 16, 9, 34, -10, 10,
    -8, 9, 1, -6, -23, 19, -39, -30,
    -26, -11, 32, -53, 14, 3, -9, -1,
    -49, 19, -12, 1, 28, 13, -16, 35,
    1, -7, -35, -17, -20, 23, -15, -10,
    14, 23, 27, 33, 9, 16, -56, -15,
    -5, -14, -6, -22, -5, 4, 14, -1,
    10, 67, -5, 27, -35, 7, 32, 12,
    26, -56, -19, 7, -3, 5, 22, 30,
    28, -8, -10, -13, -47, 2, 0, -6,
    -37, 73, 14, -40, 3, -19, 1, 4,
    1, -18, -1, -16, -24, -3, -63, 26,
    38, -29, -52, 18, 28, -26, -10, 15,
    -26, -18, 13, -10, -61, 6, 56, 6,
    -20, 23, -4, 4, 16, -14, 20, -11,
    20, -34, 21, 40, 27, 12, -18, -25,
    15, -7, -21, -19, -12, -21, 23, -22,
    29, 27, -12, 17, -18, -15, -25, 2,
    0, -35, 30, 38, 19, 27, 13, -3,
    16, 19, 2, 1, -32, -26, -42, -27,
    -23, 10, -35, 2, 40, -25, -2, 0,
    13, 9, -29, 20, -30, 10, 11, -40,
    5, 25, -57, -37, 48, 9, 21, -5,
    8, 19, 6, 9, -16, -24, -26, -25,
    -12, -11, 21, 29, 2, 14, 36, 5,
    17, 1, -22, -16, 31, -8, -17, 5,
    24, 30, 8, 31, -9, 1, -5, -7,
    41, 24, 15, 14, -43, -9, -20, -40,
    7, -4, -1, 13, 7, 4, 9, -8,
    -3, -12, 5, 3, -41, 37, 20, -16,
    46, -35, 67, 36, -2, 4, -34, 35,
    -53, 69, 36, 10, 6, -46, -74, -1,
    -5, -29, 27, 5, 22, 10, 5, 28,
    21, -28, 4, -7, -30, 7, 7, 21,
    -27, 36, 2, 25, -8, -8, 18, 9,
    -1, -14, -11, 0, -15, 5, 18, -17,
    -29, -25, -18, 7, -23, -21, 20, -10,
    -9, -11, 4, 2, -5, 22, -28, 10,
    -30, 10, 4, 9, -8, -9, 7, 18,
    6, -53, 36, -42, -42, -29, -14, 3,
    32, 35, -14, -41, 15, -3, -12, -25,
    8, 5, 4, -8, -14, 9, -13, -27,
    29, -22, -14, -19, 1, 12, -3, -2,
    -21, 37, 42, 27, -18, -12, 4, 48,
    -11, -12, 5, 12, -24, -7, 15, 9,
    16, -16, -6, -16, 22, -40, -31, 4,
    7, 3, 31, 9, -7, -3, -42, -9,
    5, 0, 29, -8, -35, 6, -34, 17,
    0, -2, -28, 6, -3, 5, 4, 3,
    1, -29, -34, -5, -25, -1, 9, 28,
    -32, -26, -12, 17, -23, -5, -16, -3,
    -29, 49, -65, -1, -1, -24, 6, -23,
    46, 40, 9, 59, 15, 19, 8, 38,
    -20, -18, 0, 7, 24, 18, 33, 18,
    12, -5, -41, -1, 6, -3, -11, 15,
    45, 0, -28, 33, -15, 47, -33, -18,
    0, 34, -34, 27, 0, -9, -18, 1,
    5, -39, 14, 20, -8, 42, -23, -41,
    4, -24, 9, 50, 21, -24, 43, 33,
    22, -50, 44, 20, -18, -8, -29, -12,
    -41, -36, 16, 4, 16, -22, 45, 9,
    4, -8, -18, -26, 13, 7, -26, 25,
    -4, -27, 33, -4, 29, 18, -32, 9,
    3, 6, -38, 10, 25, 63, -1, 5,
    -19, 11, 33, 3, -11, 54, -8, -3,
    29, -37, -29, 45, -6, 39, 24, -23,
    -61, 52, 5, -13, 15, 11, 35, -3,
    -27, -23, -26, 44, -5, 9, 18, -3,
    38, -31, 15, 12, 32, 11, 1, 11,
    -4, 33, -6, -20, -50, 3, 6, -55,
    19, -39, 18, -6, 4, 11, -35, 4,
    -45, 9, 32, -32, 66, 30, 16, 8,
    -20, 28, -34, -14, 3, 6, 0, 3,
    26, -18, 23, 0, 17, -11, -14, -16,
    -16, 1, 16, 7, 27, 6, 3, -22,
    -6, 19, 2, -22, -16, -30, -5, 26,
    2, -32, -29, 19, -15, -11, 4, -4,
    -5, -2, -2, -17, -5, 11, 13, 16,
    -46, -42, 6, 6, 26, -8, 24, 5,
    -36, 32, 3, 0, -75, 37, 18, -7,
    52, 8, 36, -1, 17, 15, 28, -31,
    19, -19, 16, 4, 5, 7, 0, 56,
    -30, 17, 17, 66, -4, 1, 34, -25,
    -8, 18, 8, -44, 8, 19, -26, 29,
    20, -4, -41, -16, -8, 1, 29, -8,
    -7, 3, 15, -19, -25, 18, -22, 10,
    -17, 1, -19, 10, 12, -1, -37, -3,
    -1, 10, 12, 0, 40, -8, 33, 27,
    19, -9, -10, 15, 14, -1, -8, 2,
    -36, -18, 13, -4, 58, -4, 23, 7,
    -37, 10, -36, 3, 28, 8, 30, -10,
    16, 78, 52, 32, -23, -3, -1, 39,
    -11, -9, 5, -44, -22, 9, 6, -16,
    18, 11, 7, -21, -23, -1, 0, -29,
    -42, 2, -28, -20, 22, 23, -18, -11,
    -8, 48, -5, -2, 27, 22, -8, -21,
    8, 32, 4, -15, 21, 19, -1, 3,
    -17, 37, 4, -11, -25, -6, 14, 11,
    8, -4, -36, -7, 4, -9, -2, 13,
    -58, -45, -5, 45, 21, 22, 4, 80,
    42, -30, -34, -95, 19, -3, 5, 12,
    -28, 5, 63, 9, -51, 10, -7, 4,
    -5, 3, 11, -17, -32, 33, 34, 47,
    26, -36, -31, 30, 8, -44, 47, -13,
    -23, -48, 32, 16, -25, 24, -6, -23,
    66, -46, -29, 48, 17, 36, -30, 53,
    5, -20, -19, -10, -44, 3, 64, -5,
    -29, 33, -15, 16, -36, -37, -29, -52,
    -9, 9, -55, -8, -39, 14, -10, 33,
    -3, 3, -43, -31, 31, 19, 7, -65,
    -15, -8, -2, -59, 36, 11, 46, -48,
    -22, 4, -16, 3, -12, -63, -20, 38,
    -12, 3, 83, 6, -1, -33, 35, 0,
    15, 17, -55, 26, -23, -22, 48, 6,
    11, 4, -87, 18, -15, 14, 12, 29,
    -10, -116, 65, -23, 23, 17, -45, -25,
    56, -57, 28, 31, 41, 26, 29, -7,
    -21, -9, 31, -9, 17, -21, 10, 50,
    10, 13, 24, 43, 34, 4, -20, 16,
    -31, -17, 63, 20, -12, -8, 8, -13,
    28, -31, 26, 40, 8, 11, 43, -13,
    17, -24, 6, 0, 50, 10, 7, 57,
    10, 44, 1, 19, -44, 5, 6, -33,
    24, -10, -36, 17, -20, 49, 14, -8,
    -5, -55, -19, -17, -1, 17, 6, 14,
    40, -56, 6, -10, 19, 36, 12, -33,
    69, -40, 1, 23, 6, -6, -6, 4,
    46, -43, 10, -52, 82, 47, -11, -14,
    108, -56, -19, 35, -2, 0, -30, 44,
    15, 0, 38, -66, 52, 61, 6, -48,
    -3, -36, -49, 41, 16, 52, 38, 32,
    -68, -29, 10, 38, 26, 62, -7, 10,
    -8, -11, -16, -3, 4, 25, 2, 50,
    14, -57, 94, 2, 1, 5, -67, -14,
    19, -5, 20, 2, 0, -2, 38, -40,
    24, 55, 32, 34, -17, -18, 43, -56,
    7, -55, -45, -24, 21, -11, 36, 12,
    20, 10, -10, -16, -24, 13, -1, -9,
    27, -40, 19, 1, 61, 26, 23, -21,
    63, 14, -9, -16, -52, 48, -34, 43,
    -26, -14, -54, 7, 26, 17, -25, -7,
    -43, 17, 72, -12, -16, 12, 33, 7,
    -35, 16, -13, -30, 25, -30, -32, -3,
    -26, -8, 45, 57, 17, 27, -17, -24,
    1, 0, 38, 18, -32, -3, 2, 53,
    25, 30, -4, -2, -17, -33, -49, -18,
    22, -54, -14, -6, -11, -4, -33, 3,
    5, -25, -45, -3, -27, -19, -24, -32,
    26, 16, 17, 35, 18, -40, -7, 10,
    14, 39, -11, 47, -89, -10, -50, 70,
    26, -17, 16, 18, 22, 25, 23, -53,
    -58, -33, -8, 3, 36, 13, -21, -22,
    -11, 9, -13, -76, -13, 19, 15, -35,
    42, -3, 8, -2, 74, -21, -40, 73,
    -31, -51, 19, -17, -84, 17, -17, -26,
    42, 3, 17, 30, -11, 31, 0, -50,
    -37, 98, -71, -5, -42, 9, -44, 15,
    30, -34, 33, 3, 34, 53, -9, 17,
    5, -67, -9, 21, -16, 4, -25, 13,
    -74, 64, -24, 11, -4, -61, -21, 3,
    -42, -15, 34, -6, -15, 15, 43, 6,
    -7, -40, 1, -9, 17, 12, -38, -7,
    43, -16, -2, -6, 53, -16, -6, 10,
    1, 28, -38, -9, 10, 29, 19, -37,
    -33, -4, -39, 1, 18, 6, -18, -3,
    21, 14, 27, 6, 40, 2, -47, 0,
    -42, 68, -10, -17, -51, 46, 1, 24,
    -7, -41, 78, 24, 53, -27, -49, -44,
    77, 26, -37, 48, 74, 55, -29, -13,
    11, -27, -4, -25, -8, -23, 11, -15,
    -22, 33, -9, -27, 24, -3, -11, 2,
    33, 57, 16, 48, -41, -6, 1, -3,
    -16, -30, 29, 59, -20, -14, 8, 33,
    -48, 17, 2, -1, -29, -34, -46, -34,
    18, 27, -12, -10, 1, -56, -35, -30,
    -12, 11, 7, 7, -57, -26, -101, 47,
    58, -120, 88, -25, -10, -13, 0, -6,
    10, 23, -7, -53, -20, -19, -31, -37,
    -11, -34, -63, -66, 0, -32, -13, -25,
    3, 73, 2, 16, -46, -27, 8, 84,
    33, 19, 83, 6, 33, -7, 34, 11,
    -4, -21, -22, -10, 81, 24, 47, 20,
    7, 11, -16, -4, 16, 12, -6, 5,
    79, 3, 10, 41, -117, 69, -14, -27,
    39, -10, -28, 4, 11, 30, 1, -9,
    -1, -38, 30, 28, -67, 35, -33, -35,
    -20, 63, -11, -54, 20, -28, -13, -12,
    -16, 3, 13, 17, -10, 15, 1, -6,
    72, -31, -1, 99, 36, 2, 6, 12,
    -74, -55, -1, 8, 53, 76, -51, -7,
    -5, -22, -18, 32, -4, -21, -12, -2,
    15, 4, 17, -4, 11, 26, 29, -38,
    -64, 39, -22, 2, -5, 97, -6, -30,
    36, -29, -48, 28, 59, 25, 57, -60,
    31, -9, 17, -23, 39, 0, -25, 39,
    8, 22, -21, 16, -24, 17, 10, 0,
    94, -99, 60, 36, 37, -19, 39, -3,
    9, 98, -33, -1, -53, 10, 7, -7,
    59, 57, 26, 0, 28, -19, -12, 6,
    -39, 39, -16, -25, 64, -23, 56, -24,
    -12, 28, -78, -10, 2, -26, -2, -24,
    -10, -35, 49, 10, 0, 54, 19, -9,
    25, 23, -13, 35, -24, -1, -30, 54,
    -20, -26, 5, 12, 12, 13, -33, 3,
    -13, -55, -24, 15, 26, 29, 6, 24,
    40, 1, 31, -20, -20, -5, 6, -27,
    -51, 2, 39, -30, 3, -30, 15, 22,
    -45, 48, -10, 0, 6, 6, -4, -11,
    39, -11, -19, 43, -8, -27, -7, -74,
    -58, 35, -10, 3, 83, 39, 22, 53,
    -13, -16, 24, -25, -29, 3, 0, 3,
    -46, 11, 2, 15, -26, -38, -9, 54,
    21, -24, 23, -32, -17, -32, 48, -13,
    20, 15, -11, -32, 9, 26, -65, -33,
    1, 14, 31, 7, -26, -3, -2, -22,
    26, -26, -16, -34, -23, 0, -51, -24,
    -47, -33, -7, -16, 9, -14, -9, -7,
    -19, -20, 14, 32, 29, 15, 0, 30,
    29, 11, 37, -41, 22, 9, 33, 96,
    -34, 60, -4, 27, -36, -39, 20, 5,
    -14, -1, 32, -14, -33, 9, -17, 43,
    43, 55, 43, 34, 43, 39, 77, -30,
    53, -15, 59, -13, -13, 8, -26, -24,
    -47, -82, -3, 24, -23, -5, -58, -43,
    -31, -45, -37, -60, -18, -5, -29, -31,
    -42, 63, 20, -10, 17, 17, 28, 61,
    -7, 17, 25, -1, 6, 0, 43, -25,
    -13, 40, -17, 16, 14, -7, -16, 3,
    -16, -32, 31, 66, 4, 6, 5, 5,
    -9, 25, -15, 4, -6, -14, -25, -17,
    -46, 3, 16, 0, -12, -2, -18, 4,
    -8, -8, -22, 8, -17, 14, 7, -14,
    0, -18, 2, -7, -14, 1, 4, 1,
    12, -13, 20, 11, 10, 14, 2, -14,
    -20, 1, -41, -4, 12, -3, -2, -15,
    -23, -12, 6, 17, 4, 16, -37, -14,
    14, -15, -3, 27, -14, -1, -17, -7,
    -1, -26, -13, -10, 11, 9, -5, -23,
    -20, 45, -6, -14, -33, 29, -27, -5,
    -7, 12, 0, 27, 21, 43, 9, -7,
    -20, 1, -28, 20, 5, -6, 2, 16,
    -5, 20, -4, 5, -20, 23, 47, 13,
    2, -34, -45, -24, -1, -23, 2, -16,
    -9, 14, 12, 35, 11, -24, -4, 11,
    34, 36, -31, 31, -17, -15, 24, 7,
    8, 6, 6, 46, 7, -28, 4, 21,
    -5, 3, -21, -9, -21, 25, -9, -20,
    -1, -15, 27, -9, 23, -10, 7, -46,
    16, 24, -17, -4, -7, 1, 9, 10,
    -11, 7, 2, 0, 7, -5, 34, -43,
    57, 16, -18, -6, -26, 8, 3, -1,
    -14, 13, 31, 1, -7, -33, 22, 31,
    20, -24, -8, -18, -7, -6, 4, -3,
    -4, -13, 1, 16, -9, 11, 25, -39,
    -6, -3, -31, -17, -27, -26, 22, -7,
    -6, -15, 14, -15, 20, 28, 12, -25,
    -7, -24, -5, -46, -1, -13, -3, 25,
    -13, 4, 12, -6, -14, -1, -2, -19,
    -11, 6, -18, -24, 15, -31, -1, -21,
    -77, 6, 5, -7, -9, 11, -38, -20,
    40, -1, 4, 14, -9, 7, 4, -2,
    8, 20, -2, -7, 2, -5, -10, 13,
    -20, 20, 31, 1, 3, 5, 4, 20,
    -17, -3, 5, 41, 17, -19, -16, -7,
    -18, -21, -8, -13, -39, -10, 6, -6,
    25, -23, 5, -15, 25, 18, 7, 19,
    25, -17, -44, 23, -32, -18, 3, -7,
    23, -5, -13, -4, -6, 1, 24, 1,
    6, -10, -30, -1, -14, 8, -2, 7,
    -13, 38, -3, 1, -70, -18, 2, -2,
    14, -40, -38, -13, 4, 35, 22, 8,
    -24, -6, 12, -2, 3, 2, 10, 19,
    25, 34, 15, -22, 32, -8, -7, -6,
    8, 13, -18, 4, -18, 19, -4, 21,
    15, 27, -39, -11, 2, 14, 0, 7,
    -15, 3, 8, 19, 10, 24, -11, 2,
    -23, -17, 11, -1, -17, 3, -13, 5,
    -5, 6, 1, 6, 7, -5, -5, 11,
    -4, -29, 39, -4, -10, 11, 37, 17,
    11, 2, -4, 17, 17, 6, 19, 11,
    34, 33, 35, -27, 13, -21, 12, -4,
    0, -11, -14, -9, -13, -6, -16, -25,
    -33, -36, -11, -1, 36, -4, -4, -25,
    14, 4, 6, -27, -14, -6, -3, -32,
    -9, -16, 4, 3, 0, 2, -9, -6,
    12, -18, 13, 23, 4, 5, -1, -14,
    33, -13, 32, -11, 20, -1, -16, 5,
    11, 2, -3, -12, -5, 2, 0, 14,
    19, -32, 11, -13, 7, -8, -29, 15,
    -31, 0, -6, 16, 11, 52, -27, 20,
    -6, 3, 0, -4, 25, 39, -14, 2,
    -9, 5, -6, -47, 13, 33, -47, 4,
    -7, 54, -6, -22, 9, 8, 9, 9,
    13, 2, -2, 21, 7, 7, 9, 9,
    9, -21, 32, -25, -11, 15, 15, -20,
    -6, -12, 33, -3, 6, 34, -18, 6,
    14, 2, -17, 7, 0, 22, -1, 6,
    18, -11, -7, -18, -6, -9, 2, -16,
    -14, 13, -23, -5, 14, -10, 5, 21,
    2, 1, 4, -17, -10, -1, 1, 20,
    -5, 25, -22, 3, -6, 0, -2, 4,
    23, -9, -21, 13, 10, -3, 15, -12,
    21, 13, -31, -6, 2, -4, -4, -18,
    -3, 17, 3, -15, 37, -14, 18, -7,
    38, -9, 11, -10, 3, -5, 5, -5,
    0, -11, -14, 21, -1, -17, -13, -20,
    -7, -38, -14, -24, 3, -17, -5, -2,
    -36, 51, -3, -16, -10, -22, -11, -37,
    3, -3, -43, 3, 8, -6, -6, 22,
    8, 3, -4, 19, 5, -13, 2, 2,
    4, 24, 9, -32, -9, 17, 13, -10,
    -15, -25, -15, -15, 16, 22, 8, 27,
    -1, -17, 31, 20, 9, -13, -4, -23,
    3, 29, -7, 5, 14, 3, -6, -5,
    -38, -5, 4, 59, -3, 15, 20, -25,
    10, 4, 4, -8, -5, -16, 22, -53,
    -20, -24, -42, 32, 4, -8, 3, -6,
    -21, 14, -21, 46, 15, -1, -14, 10,
    59, -16, -16, -27, -3, 8, -15, -8,
    20, -10, 2, 2, 26, 4, -7, -4,
    2, 0, -21, 3, -4, 6, 5, -8,
    -5, 8, 16, -8, 1, -9, 27, -13,
    -25, -1, 21, -1, 12, 2, 7, 3,
    2, 5, 6, -7, 1, -11, 23, 34,
    0, 19, 47, -1, -4, 1, -6, 18,
    21, 11, 10, 4, 25, -2, 1, -5,
    30, -15, 13, 38, 14, 8, 2, -4,
    -35, 19, 14, 100, 9, -7, -17, -13,
    -25, 15, -3, -3, -25, -14, -12, -9,
    17, 24, 0, -17, -3, 1, -24, 18,
    8, -23, -20, 1, -1, 12, 7, 7,
    -27, -6, -4, -7, -17, 11, 13, 44,
    7, 24, 23, -26, -12, -10, -12, 3,
    -25, -19, 16, 29, -14, -8, 5, -10,
    -3, 39, -18, 20, 33, -51, 1, 2,
    -16, -6, 1, 17, -4, 10, -12, -15,
    -24, 25, 16, 13, -18, -11, 2, 6,
    -27, 3, 3, -18, -5, -12, 6, -15,
    5, -38, 1, 63, 7, 24, 6, -3,
    -9, 12, -3, -8, -21, 3, -3, -2,
    -22, 0, 16, 8, -12, 1, -12, -7,
    -29, -12, -14, -15, 40, -3, 15, 21,
    27, 6, -30, 16, -19, 32, -6, -1,
    5, 3, 29, 3, -17, 19, -11, -11,
    -13, -10, 16, -20, -12, 10, -4, 4,
    9, -7, -1, 2, -15, 9, -16, -23,
    23, 12, -7, 24, -5, -6, -6, -27,
    -2, 16, -17, -9, 7, 30, 23, -33,
    8, -34, 32, 22, -8, 2, -4, 15,
    -5, 12, -33, -4, -29, 42, 15, -3,
    5, -19, -18, -49, 21, 12, -2, 15,
    4, 14, 0, 22, -10, 24, 19, 27,
    -28, 13, 2, 2, 18, 12, 21, 10,
    -20, -17, 31, 1, -8, -1, -14, 9,
    36, 23, 38, -13, 14, 13, 27, -2,
    -39, 28, 13, -30, -8, -2, -58, -22,
    10, -24, -5, 56, 16, -1, -4, 23,
    13, 37, -32, -12, -2, -10, 38, -8,
    -37, -32, 20, 36, 21, -8, -1, 3,
    19, -27, -6, -1, 11, -21, -5, 25,
    22, -13, 17, -28, 12, -9, 14, -7,
    11, -1, 0, 31, 10, 9, 3, 14,
    -5, -25, 15, 27, -7, 31, 26, -50,
    6, -25, -30, 0, -19, 44, -60, 18,
    36, 24, 5, 16, -46, 0, -28, -18,
    -8, -8, 8, -15, -17, -9, -25, -48,
    3, -2, -20, 23, 5, 17, -1, 22,
    16, -18, 0, 20, 48, 69, 14, -16,
    25, -25, 35, 17, 13, -10, -19, 0,
    28, 25, -10, 9, -3, -3, -11, -3,
    36, -36, -10, -11, -8, -16, -9, -28,
    17, 6, 55, -7, -9, -9, -4, 16,
    -5, 19, 95, 34, -35, -6, -3, 8,
    -10, -49, 70, 19, 25, 4, -15, 0,
    -8, -5, -23, -59, 8, -10, -20, 20,
    7, -20, -6, 18, 28, -4, -6, 25,
    -4, 0, 45, 45, -14, 21, 17, 19,
    -35, 8, -4, 39, -12, -7, 18, -51,
    -24, -16, -61, 37, -16, 22, 8, -18,
    0, 2, 35, 7, -8, -34, 0, 45,
    12, 24, -18, -46, -36, -7, -6, -3,
    10, 14, -16, -25, -14, -2, 11, 26,
    -37, -1, -33, 31, -21, -1, 1, 24,
    -11, -23, -5, 30, 26, -29, 22, 27,
    7, -36, -27, -58, 16, -12, -1, 1,
    -31, 13, -13, 12, -28, -36, 7, 6,
    -31, 4, -40, -22, 14, 5, 16, -15,
    -79, -12, 2, -3, -21, -1, -57, 33,
    19, -8, -25, -24, 0, 17, 15, -24,
    3, 43, -35, -11, -14, -39, 25, 31,
    3, 4, 29, -29, 2, 4, -1, 15,
    -12, 7, 4, 33, 40, 12, -4, 1,
    0, -2, -7, 14, -34, -8, -5, -6,
    -10, -13, -21, 3, 17, 30, 20, 33,
    -2, 13, 45, 51, -9, 4, -19, -4,
    -1, 20, -4, -11, 4, 0, -23, -4,
    -13, -25, 4, -5, -8, 10, 21, 14,
    -3, 45, 43, 44, 19, -7, 20, -3,
    -9, -24, -45, -57, -4, 19, 23, 12,
    -18, -8, 15, 15, 17, 5, 19, 3,
    9, 10, -8, -35, 17, -21, -6, 7,
    -29, -6, -9, -23, 23, 27, 28, 19,
    51, 62, -21, -39, -11, -15, 32, 49,
    -5, -6, -2, 43, 21, -7, -17, 9,
    37, 18, 0, 12, -19, -15, -12, 13,
    -19, 13, 3, 17, 12, 11, -11, 24,
    -22, -25, -4, -35, 74, 6, 19, -21,
    0, 14, -17, 8, 16, -18, -29, -24,
    28, -16, 11, -22, 8, -15, -2, -29,
    2, -67, -15, -15, 10, 15, -14, -49,
    40, -8, 16, -32, -2, -32, 15, 4,
    -6, -10, -25, 6, -9, -11, -47, 18,
    -12, 7, -34, 41, -3, -1, -27, -5,
    -13, 17, 39, 37, 14, -9, 0, -18,
    40, 32, 8, -23, -1, -20, 5, 29,
    -22, -21, 23, -16, 4, 18, 29, 55,
    -47, -32, -11, 15, 6, -8, -2, 10,
    -13, 35, 27, 15, 25, 35, -14, 20,
    8, 52, -44, 1, -13, 16, -3, -7,
    -13, -24, 12, -32, -17, 35, -3, -14,
    -39, 7, -5, -15, 0, -23, 18, 2,
    10, 37, -30, 15, 0, -27, 6, -6,
    6, -39, 44, 9, 4, -3, -4, -35,
    -12, 1, 50, -21, 4, 0, 1, -32,
    -6, -12, 13, 35, 10, 16, -5, 8,
    2, 10, 5, -46, 9, -6, 23, -31,
    32, 1, 6, -5, 16, 7, -5, 5,
    -5, 3, -11, 13, 1, 6, -22, 14,
    -50, -1, 37, 3, -3, 1, -15, 25,
    40, -3, -3, 1, 17, -4, 3, -8,
    -7, 58, 18, 29, -3, -14, -17, 21,
    2, 4, 7, -8, 54, 20, 13, -54,
    29, -44, 48, -27, -11, 0, -8, 0,
    14, 22, 5, 25, -16, 2, 7, 6,
    -29, -7, 2, -1, 56, -3, 11, 3,
    -11, 80, -11, 13, 38, 9, -11, -61,
    7, 17, -19, -9, 15, -9, 0, -9,
    18, -8, -10, -41, -26, -5, 0, 9,
    54, 15, 61, -26, -29, 10, -15, -15,
    17, 30, -26, -23, 65, 12, 26, 52,
    -6, 42, -8, 14, 7, -13, 7, -27,
    -3, -15, 1, -7, 11, -23, 35, 1,
    -5, 22, 54, -12, -16, 10, 10, -36,
    9, 0, -6, -26, 3, 10, 13, 0,
    5, -11, 23, 3, -2, 2, -3, 8,
    14, -4, -19, 43, 6, 10, 32, -1,
    12, 14, -27, -5, 1, -15, 29, 19,
    -41, 1, -19, 8, 53, -38, -6, 50,
    -18, 49, -59, 3, -17, -2, -22, 20,
    -3, 29, -21, 8, 17, -7, -51, 32,
    -55, -9, -52, -36, 3, 20, -19, 32,
    -2, -4, 11, 5, 28, -10, -3, 84,
    -2, -6, 24, 43, -18, 1, -5, 41,
    0, 30, -30, 18, -24, -5, -23, -15,
    72, -37, 3, 43, 1, -11, -7, 1,
    -16, 6, 7, 107, 26, 9, -33, -14,
    -5, 17, -7, -13, -18, -41, -19, 5,
    18, 14, -27, -14, -2, -46, -6, 31,
    -23, -47, 23, 22, 23, 21, 8, 28,
    -13, 23, 5, 20, -2, 22, 15, 36,
    18, 25, 3, -48, -17, -9, -18, 6,
    -10, -18, 4, 3, -12, 30, -14, 19,
    30, -64, -19, -13, 13, -39, -12, -4,
    -5, -9, -13, -26, -19, 8, 0, -60,
    14, 28, 6, -62, -7, -1, 2, 38,
    -26, 17, 28, -24, -27, -10, -5, -20,
    21, -21, -26, -42, 3, 6, 0, -4,
    22, -17, -7, 15, 26, 39, 16, -21,
    21, -7, 2, -70, -16, 2, 4, -2,
    -19, -20, -32, -27, -10, -8, 27, -13,
    17, 15, 25, 36, -11, 13, -13, 17,
    -6, 11, 12, 39, 13, 8, 9, -27,
    -10, -20, 20, 23, 1, 15, -10, 1,
    16, 30, 14, 5, -38, -1, -19, -14,
    28, -52, -81, -23, 59, 13, -25, 11,
    5, 10, 1, 37, -14, 4, 15, -7,
    -1, 27, 23, -5, 0, -7, 8, 30,
    37, 67, -5, -24, -10, -20, 30, 30,
    -49, -18, -33, -46, 24, 24, -4, -6,
    -27, -7, 12, -21, -25, 66, 15, 14,
    -10, 52, -7, 9, 18, 5, 1, -5,
    17, -15, 16, 26, 6, 19, -20, -9,
    27, 102, -16, 54, 10, -1, -24, -20,
    -17, 31, 24, -31, 18, -3, -35, -60,
    47, -11, -13, -32, 10, 15, -15, 47,
    38, 44, 9, -91, -24, 4, 21, 55,
    -2, -9, -17, 24, 10, -2, 18, -27,
    33, 8, 26, -26, 29, -16, 7, 35,
    -15, -16, -4, 46, -9, 4, 14, 6,
    -16, -46, 8, 30, -29, 14, 8, -5,
    -7, 6, -21, -25, 27, 45, 8, -80,
    -3, -47, -1, -25, -21, 25, -9, 21,
    -46, -15, 28, 23, -82, -10, -38, -2,
    19, -61, -61, -13, 9, -13, 6, -56,
    -48, -4, -58, -35, 32, -1, 40, 9,
    14, -48, 3, 10, 83, 15, -9, -36,
    4, 5, 0, -30, 14, -26, -26, -42,
    44, -16, 55, 30, -19, 5, -30, 1,
    17, -71, -25, -24, -21, 4, 16, -8,
    4, 41, 36, -36, -7, 34, 13, 30,
    -15, 4, -67, -30, -126, -3, 6, 7,
    10, -100, 9, 9, 11, 52, 9, 14,
    7, -76, 15, -26, -7, 18, 14, -62,
    -21, 16, -53, -25, 32, -5, -45, 12,
    -10, 0, -12, 9, -22, 21, 33, 27,
    16, -2, -33, 8, -18, 5, -55, -74,
    -41, 24, -40, 20, -18, 14, 12, 19,
    9, -67, 35, 49, -30, -65, -3, 33,
    -33, -16, -11, 9, -83, 7, 0, 16,
    5, -41, 16, -36, 13, 12, 10, -34,
    79, 47, -61, 16, -91, -38, -30, -18,
    -12, -11, 31, 27, -29, 20, 16, -16,
    10, 16, -33, 50, 29, -33, 44, 4,
    -21, -17, -24, -13, -39, 13, 36, 31,
    32, 77, -32, -30, -5, -36, -28, -7,
    -80, -22, -18, 11, -25, 32, -67, 16,
    10, 63, 2, 2, -10, 65, 26, -30,
    -4, -28, 33, 23, -3, 56, 13, 47,
    14, -13, 44, -34, 21, 26, -11, -7,
    1, 22, 4, 20, 46, -1, 10, -19,
    14, -2, 43, 47, -40, -15, 3, -6,
    -21, -64, -22, -25, -34, 12, 11, 43,
    -34, -40, -29, 22, 29, -12, 20, 23,
    9, 28, 49, 17, 33, -25, -39, -23,
    8, 1, 23, -22, -10, 38, 23, 22,
    9, 22, 95, 34, 37, -19, 4, 33,
    -35, -52, -29, -8, 14, 1, 38, 11,
    -23, 8, 30, 37, -2, -18, 4, -19,
    -17, 19, 5, 5, 40, -20, -6, -19,
    -4, 21, -10, 15, 29, 11, 24, 6,
    41, 23, -7, -28, 64, 16, -5, -77,
    24, -38, -14, 41, 19, 13, -38, 20,
    -2, -17, -6, -7, -2, -29, -22, -1,
    17, -6, 9, 17, 16, -1, 22, 17,
    9, 5, 28, 40, 30, -17, 18, -31,
    11, 12, -29, -24, -22, -43, -46, -13,
    -36, -15, 50, -23, 13, -28, -14, -43,
    4, 9, -48, -9, -12, 69, -16, -18,
    4, -9, 39, -17, -4, -26, -18, 12,
    -19, 9, -56, 56, -6, -21, -33, -6,
    -12, 71, 68, 18, -28, 10, -43, -3,
    -19, 28, 21, 5, -50, -34, 98, -6,
    99, -18, 60, -36, -51, -13, 6, 53,
    -70, -26, 16, -41, -21, 62, 48, 58,
    12, 27, -14, 12, 10, -6, -22, 3,
    0, 17, -13, 25, 9, 29, -3, -16,
    22, 3, 15, -18, 44, -11, 11, 20,
    -2, -9, -13, -39, 61, 68, 29, 2,
    -9, 1, 16, -21, 26, -57, 14, -8,
    47, 23, -47, 23, -3, 27, 13, -4,
    48, -64, 50, -29, -26, 6, -27, 14,
    -2, -4, 57, 2, -15, 16, 10, -27,
    -8, -21, 19, 79, 13, 25, 12, 56,
    -4, 16, 6, 1, 1, 13, 24, -34,
    49, -7, 11, 26, 30, 21, 5, -16,
    3, 3, 14, 40, 27, -1, 3, 5,
    41, -9, 24, -1, -15, -8, -26, 39,
    82, -25, -10, 33, -16, -38, -1, 8,
    -36, -13, 54, -26, 19, 27, -27, 15,
    -24, 13, 10, 28, 66, 42, -29, -6,
    -19, -66, 17, 15, -34, 6, -3, -4,
    -27, -8, 23, 29, -19, 30, -28, 30,
    26, -51, 28, 5, 18, -15, 56, -10,
    -31, 106, -24, 19, -7, 6, 41, -7,
    -26, 11, 14, -30, 23, -3, 8, -15,
    24, -17, 52, -35, -17, 32, -42, -48,
    -58, -21, -1, -35, -1, -29, 21, -8,
    51, 19, 24, -38, 26, -21, 58, 54,
    35, 20, -2, -6, 25, -21, -15, -21,
    -16, -14, 6, -58, 2, -6, 20, 13,
    -22, 8, -10, 91, 27, 2, 13, 10,
    15, 23, 31, -55, 33, -23, -15, 43,
    75, 10, -38, 24, 24, 29, -17, -24,
    67, -14, -14, 63, -8, 7, -1, 0,
    87, -89, -26, -9, -15, 49, -29, 15,
    -69, 30, -39, 16, 58, -35, 8, 18,
    -30, -10, 31, -77, -2, -5, -81, 63,
    35, 8, -37, 52, 1, -52, 6, -9,
    81, 25, 44, -30, -11, 9, 5, -2,
    26, -24, 34, 2, 20, -69, -24, 75,
    -82, 5, -35, 33, -35, -10, -69, 69,
    -43, 20, 19, 13, 4, -27, -31, 18,
    67, 31, 6, 51, 19, -3, -51, -2,
    -28, -21, -46, 127, 14, -42, -25, -29,
    -43, -25, -25, 5, -39, -56, -20, -8,
    41, 6, -22, -10, -11, -3, 12, 28,
    6, -74, 21, -10, -42, -17, 36, 17,
    -9, 39, 8, -3, 15, 40, 18, 19,
    -19, -20, -66, -40, -52, -11, -25, 7,
    -3, 16, -27, 27, 23, 42, 28, -40,
    70, -53, 25, -23, -45, -41, 90, -43,
    19, 4, 2, -28, -13, 6, 26, -36,
    -4, -51, -12, 43, 2, -11, -6, 66,
    14, -7, 24, 35, -5, 19, -35, -12,
    -46, -24, 11, 31, -24, 10, 18, -23,
    29, 0, -6, -5, 10, 47, 91, -38,
    -10, 15, -22, 29, -28, 13, 6, -4,
    -38, -4, 20, -54, 28, 27, -14, 20,
    23, -15, 1, -59, 7, -7, -17, 40,
    -22, 15, -43, 29, 16, -31, 52, 6,
    -51, 4, -1, -60, 1, 7, -22, -18,
    -10, -16, -12, -27, -57, 27, 17, -18,
    43, -1, 16, -12, 68, -49, -36, -16,
    -13, 15, 34, -5, -28, -49, -18, 58,
    4, 38, -24, 0, -25, -9, 4, 70,
    17, 67, -27, -38, -4, -6, 84, 2,
    -56, -11, -4, -53, -6, -13, -17, 10,
    -6, -26, -3, 9, -52, 67, 8, -6,
    -16, -64, 6, -18, 45, -18, 15, -1,
    -11, 6, -11, -9, 7, -9, 69, 4,
    -9, 10, 7, 17, 6, -16, -25, -45,
    23, -2, 10, 13, -19, 1, -9, -21,
    28, 62, 6, -8, -29, -29, 21, -23,
    7, 7, -8, 29, 15, -18, 19, 16,
    -31, 12, -3, -15, 7, -9, -27, -14,
    1, 13, -4, 18, -7, -10, 13, 8,
    -8, 13, 29, 8, -2, -14, -33, -13,
    -9, -10, 5, -17, 19, -7, -7, -21,
    7, 21, -5, 21, 37, 10, -11, 13,
    0, 6, 1, -2, -29, 14, 11, 6,
    10, -48, -4, -4, 13, 14, -14, 27,
    5, 20, 12, 10, -33, 3, 4, -12,
    9, 12, 33, 23, 21, 34, 14, -8,
    7, -3, -6, 5, 2, 12, 10, 8,
    3, 8, -4, 19, -37, 7, -19, 17,
    -3, 5, 11, -1, 40, 14, -24, -35,
    7, 38, 9, 33, -4, 37, -28, 5,
    -6, 23, 1, 13, -19, 19, 44, 0,
    2, -9, 17, -6, 0, 7, -4, 1,
    -7, 2, 6, -9, 58, -3, -2, -38,
    -9, 16, 4, -24, 3, -1, -1, 4,
    -9, 8, -7, -3, 53, -13, 5, -39,
    -3, 11, 0, 3, -2, 17, -18, -9,
    -1, -2, 1, -9, -22, -8, -8, 3,
    -14, 13, 28, 5, -8, 2, -4, -35,
    -4, -13, -2, -2, -4, 29, -20, -21,
    -3, 19, 46, 19, -34, -9, -26, 22,
    -12, -15, 4, -19, -8, -15, 2, 12,
    -19, 1, -3, 18, 15, 36, -19, -43,
    5, 14, 6, 4, 8, 10, 6, -1,
    6, 18, 0, 4, -25, 10, 17, -27,
    3, -2, 3, 7, -2, 26, 35, -19,
    2, 11, 43, 1, -29, -19, -3, -15,
    -15, 2, -20, -1, -10, -14, 25, -20,
    -34, 0, 17, -10, -22, -35, -9, -11,
    -2, 2, 6, 11, 35, 0, -5, 22,
    20, -2, 7, 11, 22, -10, -14, 30,
    2, 42, 6, -16, 34, -22, 7, -3,
    2, -5, 9, -23, -17, -5, -25, 11,
    19, 1, -2, -6, -24, 0, -18, -30,
    -10, 11, 26, -22, 10, -23, -28, 27,
    1, 6, 5, -5, -17, 31, 4, -24,
    -8, 4, 8, 2, 41, -4, 21, 2,
    -3, -10, -4, 3, -4, -7, 10, 20,
    2, -18, -10, -6, -23, -28, -20, -27,
    -13, -22, 30, 9, 7, -25, -39, -21,
    12, -3, 6, 1, -2, 1, -17, 27,
    6, -8, 6, -3, -39, 42, -13, 48,
    12, 7, 17, -9, -23, -2, -2, 29,
    4, 3, -10, 21, 2, -5, 4, 10,
    -6, -2, -4, 10, 21, -11, 34, -28,
    21, 12, 1, -4, -17, 5, -38, -8,
    2, -22, 14, -3, 13, -13, 18, -26,
    6, -3, -11, -15, -17, 3, 29, -3,
    14, 1, -9, 7, -37, 30, -9, -5,
    4, -12, 5, 10, -10, -6, -40, -25,
    -5, 8, 5, -15, -15, -3, 36, 1,
    -4, 5, 1, 19, 32, -12, -12, -12,
    21, -3, 6, -6, -35, 6, 10, -1,
    12, 8, 8, 8, 17, -5, 15, 32,
    -8, 2, -17, 11, 20, 2, 16, -43,
    -16, -20, -7, 15, 7, 3, 12, 12,
    -7, 3, -4, -7, 8, 20, 2, -11,
    8, -5, 4, -11, -14, 29, 4, 2,
    -23, -21, 0, -20, -30, 4, 16, 4,
    7, 0, -1, 11, -10, 14, -31, -25,
    -1, 16, 3, 16, 26, -11, -24, 5,
    -1, -1, -14, -11, -14, 42, -13, 9,
    -9, -32, 16, 7, -8, 10, -11, 44,
    1, -18, -12, -17, 23, 12, 21, -9,
    -1, 2, -17, 13, -12, -1, 33, -27,
    -1, 6, 3, 4, 26, -18, -26, 4,
    -9, -16, 31, 2, 10, -2, -16, 23,
    30, 34, -18, -8, 12, -2, 18, 15,
    -7, -10, -6, -4, 5, 17, -28, 15,
    0, -4, 9, -15, -11, -14, -12, -22,
    -17, -10, 25, -22, -29, -54, -6, 23,
    15, -6, 12, -7, -3, 12, 7, 13,
    -12, -4, -13, 18, 4, 15, 11, -10,
    16, -11, -4, 0, -24, 33, -18, 10,
    0, -16, 5, 1, 12, 21, -36, 2,
    7, -18, 13, 2, -2, -13, 23, 33,
    7, -12, -4, -5, -23, 40, 4, -38,
    -15, -2, -16, -19, -6, -17, -3, -13,
    -9, -4, -14, 26, -21, 3, -31, -22,
    10, 1, 16, 9, 6, -11, -13, 11,
    5, 3, 18, -41, -16, 8, -16, 23,
    -6, -27, 13, 9, -5, -13, 21, 55,
    12, -52, 42, 8, 17, -11, 12, 24,
    18, -3, 3, -3, -17, -23, 21, -27,
    18, 7, 20, 6, 10, 13, -17, 1,
    5, -21, -14, 4, 3, 17, 47, 6,
    -16, 1, -15, -27, 29, 1, -13, 31,
    -10, 2, -2, 3, 41, -19, -31, 13,
    2, 3, -13, 1, -15, 38, -30, 57,
    -10, 7, -1, 3, 21, -5, -4, -3,
    1, 9, -12, 14, -2, -1, -15, 6,
    0, 3, -19, -14, -21, -12, 13, 4,
    -5, -3, 12, -6, -19, 18, -10, 33,
    -11, 2, -8, 19, 12, 25, -7, 0,
    -23, 16, 3, 22, 6, 20, -3, 29,
    10, -2, -2, -52, -12, -9, -5, 27,
    4, -3, -2, 44, 16, 15, -16, 25,
    -1, 7, -2, 5, -24, -13, -7, -29,
    -17, -8, 14, 2, -24, 14, -13, 8,
    -3, -8, -12, -17, 3, -5, -20, 1,
    15, -5, -16, 7, 3, 21, 18, -5,
    5, 11, 3, -16, 48, 35, 5, -4,
    10, -10, 1, -38, -2, 7, 21, 1,
    5, -17, 3, -4, -40, 10, -18, -5,
    8, 2, 9, -7, 27, -5, -30, 7,
    2, 9, 12, 4, 21, -5, -13, 1,
    19, -6, 2, -16, -16, 3, -20, -10,
    2, 10, 8, 4, -25, -2, -8, 21,
    5, -34, 4, -5, -28, 8, 10, -4,
    -4, -2, -13, -12, 0, -10, -28, 15,
    -30, 11, -6, -5, 18, -10, -26, 15,
    -6, -24, -6, -3, -13, -12, -4, -13,
    3, 11, -18, 6, -12, -1, -7, 1,
    -6, -17, 13, -20, 23, 27, -28, 2,
    8, -1, -15, -12, -32, 1, 11, -4,
    -13, -42, -30, -1, 3, -18, 16, 25,
    0, -18, 10, -18, -12, 1, -9, 30,
    -8, 0, -7, 0, -4, 25, 3, -23,
    19, 2, 0, 18, 2, -9, -26, -8,
    -4, -2, 10, 5, 11, 15, 19, -7,
    -13, 5, 1, -8, 22, 20, -8, 24,
    -1, -11, 2, 9, -9, -25, 17, 23,
    20, 11, -15, 42, -3, -6, -2, -21,
    22, -19, -8, 7, -30, 21, 1, 37,
    34, 85, 3, -9, 7, -16, 47, -9,
    5, -1, -16, -6, -19, -23, 29, 6,
    17, 42, 4, -18, 19, 17, -32, 11,
    -9, 16, 11, 4, -16, -9, 0, 2,
    -1, -2, 37, 1, -15, -25, 10, 8,
    -12, -1, 3, -18, 28, -34, -19, -10,
    -18, 6, 18, -22, 15, -2, -8, 0,
    -3, 15, -14, 20, 24, -5, -18, 13,
    1, -51, 11, -8, 8, 7, 17, -21,
    -2, 15, 1, 2, 0, 26, 39, -7,
    -19, 18, 4, 18, 28, -7, 15, -19,
    1, 2, -1, 11, -23, -41, 7, 31,
    -5, 8, -12, 19, -1, -45, 6, 27,
    12, -8, 14, -9, 2, 51, -11, 2,
    3, 10, -5, 5, 26, -12, 0, -45,
    -11, -7, -11, 15, -20, 16, 13, -26,
    -13, -14, 25, -10, 14, 2, -34, -39,
    1, -3, 10, 8, 45, -8, 40, -8,
    5, 22, 5, -15, -9, -15, -6, 34,
    -19, 0, -10, -6, -24, 24, 4, -18,
    9, -8, -1, 22, 0, 4, 2, 35,
    4, -1, 10, -1, 6, 8, -17, 2,
    -28, 2, 28, 24, -53, 26, 20, -7,
    -12, 0, -7, -1, 0, 82, 14, -46,
    -9, 8, 44, 4, -26, -12, -5, -4,
    -13, 0, -3, -8, 24, -19, 12, 15,
    -13, -26, -20, 10, 36, 25, -21, -45,
    21, 1, -7, -10, 8, 62, -23, -5,
    12, 15, -8, 2, -6, -18, -9, 10,
    -2, -13, 23, 9, -14, 12, 31, -6,
    0, -1, 42, -1, -8, -22, 13, 40,
    -21, -1, -25, -1, 8, 85, 16, 1,
    -30, 10, 4, -10, 5, 13, 35, 34,
    -14, -12, 2, -4, 25, -29, 1, -4,
    22, 14, 19, -1, 2, -20, -2, 41,
    -1, 48, 3, -20, 31, -28, -21, 45,
    4, -8, 10, -39, -8, -10, 5, 14,
    23, -4, -19, 0, -16, 23, 3, -1,
    0, 11, 43, -42, -10, -51, -27, -12,
    -2, 5, -8, 9, -22, 4, 31, -24,
    -4, 10, 11, 12, 9, 10, -30, -14,
    -9, 6, -3, -4, 4, 1, -52, 17,
    3, 1, -8, 2, -30, -38, -33, -9,
    -24, -22, 17, 11, 16, 2, -25, -11,
    -1, -15, -22, 9, -16, -16, -17, -1,
    28, -6, 12, 14, -67, 70, -19, 38,
    7, 15, 15, 1, -14, -5, -46, 16,
    18, 0, -3, 33, 14, 14, -5, -5,
    -15, -9, -7, 6, -6, -10, 23, 47,
    10, 6, -8, 4, -36, -7, 12, -23,
    -20, -38, 11, -23, 3, 33, -33, 35,
    -16, -5, -8, 3, -3, 39, -17, 39,
    16, 3, -2, -1, 8, 43, -17, -23,
    3, -5, -3, -11, -27, -13, -17, -32,
    1, 20, -16, -21, -6, -7, 19, 37,
    6, 12, -4, 11, 12, 9, 52, 41,
    6, 2, -19, -19, -22, -4, -28, -7,
    -7, -3, -2, 5, 36, -8, 39, 24,
    7, 17, 3, 4, 17, 24, 26, -14,
    5, -7, -23, 25, 10, -8, -13, -31,
    -5, 3, -12, 17, 89, 2, -40, -28,
    -2, -7, -11, -1, 9, 29, 24, 33,
    -1, -30, -19, -6, -13, 23, -15, -3,
    15, -11, -11, 2, -39, 6, -24, -33,
    2, 11, -8, 14, 12, 3, -21, -1,
    6, -5, -3, -9, -12, 60, -47, 16,
    -18, 9, 11, 24, 6, 27, -22, -33,
    -6, -61, -15, -22, 15, 9, 15, 2,
    -4, 15, -13, 5, -23, 23, 24, 27,
    -5, 0, 7, 10, 1, 1, -34, -3,
    6, 20, 32, 3, 21, -1, 3, -38,
    5, 46, 11, 0, 6, -9, 34, -19,
    -9, -5, -12, 4, -2, -3, -11, 11,
    -6, -6, 15, 23, 5, -14, -5, -22,
    -27, 27, 14, -6, -6, 14, -14, -31,
    2, 24, 14, 19, -59, -31, -26, 88,
    -22, -8, 10, 12, -4, -7, 10, -25,
    9, -6, 8, -12, -36, 35, -18, 8,
    -35, -12, 1, 41, 28, 8, -30, 46,
    -19, -20, 47, -12, 3, 0, -29, 5,
    11, -24, 10, 17, 22, 11, 10, -8,
    -14, -10, 0, 5, -13, -23, -33, -30,
    23, -35, 24, 24, 31, -16, 24, -4,
    13, 16, 0, 8, -6, -41, -23, -4,
    -7, 1, 0, -52, -18, 21, 1, 22,
    2, 15, -2, 2, 36, 35, 8, 42,
    67, -15, 58, 8, -3, 11, -38, -13,
    -1, 2, 2, 14, -15, -52, -26, 1,
    6, 9, 15, 4, -6, 11, -13, 0,
    9, -8, -5, 21, 9, 26, 18, 5,
    -39, -2, 14, -20, 2, -3, -62, -11,
    -2, -19, -14, -22, 10, 10, 47, -32,
    6, 9, -4, -17, -32, -21, 8, 13,
    -17, 4, 5, 6, 37, 22, -34, -16,
    20, -15, 3, -4, -17, -1, 1, 2,
    -8, 9, -13, -8, -47, -2, 21, -43,
    8, -1, -10, -1, -42, 18, -40, 29,
    -3, -6, -16, 18, 32, 13, 11, 5,
    -26, -28, -25, 1, 15, 5, 20, 19,
    4, -8, -3, -43, -46, -28, -9, 26,
    20, -13, 11, 42, 19, -15, -23, 13,
    0, -11, 2, 5, -45, 35, 3, -24,
    -9, -23, -21, 19, 25, 41, 9, 1,
    8, -10, -10, -10, -19, -9, 14, -7,
    2, 0, -12, 11, 26, 43, 12, 17,
    -6, 18, 9, -4, 43, 34, 5, 4,
    3, 22, -16, -8, -23, -20, -36, -30,
    6, -29, 1, 2, 22, -17, -13, -11,
    13, 6, -9, 20, 1, 7, -37, 24,
    -10, 1, -9, -5, -28, -26, -30, 13,
    -1, -11, -4, 22, 16, -8, -35, 11,
    -3, 15, 8, 2, 5, 12, -5, 40,
    1, -25, -18, 3, -52, -4, -21, -37,
    -4, 7, -7, 5, -7, 19, -33, 43,
    -37, -25, -44, -40, 28, -6, 40, 33,
    0, -19, 4, -20, 7, -7, 22, 6,
    9, 21, -1, 2, -20, -24, -11, -23,
    -11, -12, 10, 4, 8, 29, -23, -7,
    18, -1, 3, 40, -7, 19, 1, -23,
    -6, -41, -36, -21, 9, 30, 7, -36,
    2, -1, 6, 5, -28, -12, 2, 49,
    4, 2, -3, 24, -12, 6, -1, -14,
    5, -30, -25, -35, 8, 0, 18, 7,
    -2, -25, -8, -6, -31, -24, 31, -35,
    8, -18, 5, -4, -20, -15, 20, -22,
    8, -10, 8, -12, 14, -32, 34, 10,
    -11, 11, -4, 55, -12, 5, 59, 22,
    9, -20, 9, -18, -25, 20, 40, 26,
    30, 99, 12, 4, -13, -18, -6, 34,
    10, -6, -11, 29, -16, -38, 36, 17,
    1, 88, -19, -40, 49, 9, -29, -15,
    -4, 29, 19, 26, -4, 43, 18, 26,
    -4, 6, 53, 18, 30, 10, 2, -45,
    -4, -1, -16, -6, 8, -91, -34, -9,
    5, 13, 63, 25, -15, -39, 52, 19,
    -3, 13, -44, 10, -35, -4, 54, -36,
    -10, -62, -1, -6, 13, -16, 31, -16,
    -22, 10, -4, -6, -2, 12, -12, -16,
    -50, 13, 36, 11, -30, 8, -28, -56,
    7, -8, -3, 21, 6, -14, -6, -64,
    25, -5, -13, -7, 21, 27, 45, 51,
    3, -4, -41, 25, -11, 23, -11, 49,
    29, 23, -43, 16, 29, -9, 38, -100,
    -7, -50, -23, -12, 21, 13, 38, -3,
    9, -26, -21, -25, 0, -7, -12, 2,
    5, -6, -29, 7, 58, 17, -23, 26,
    -29, 36, -54, 3, 12, -39, -7, -16,
    -37, 39, -58, -3, 8, 0, 11, -18,
    3, -20, -4, 10, 30, 9, -28, 41,
    -22, 22, -17, -21, 31, 48, -22, 2,
    -2, -50, 9, 17, 48, -32, 22, -22,
    -35, 26, -2, 7, -7, 16, -10, -4,
    15, 15, 71, 17, -23, -10, -15, -20,
    -8, 12, -6, -19, 11, -38, -1, 14,
    -47, -82, 27, -19, 33, -10, -38, 0,
    63, 36, -21, 2, 12, -49, 31, -2,
    15, 12, 2, -3, -1, -36, -7, 7,
    -4, 16, -26, 41, -39, 14, 51, -18,
    19, 16, 23, -18, 6, -15, -30, 54,
    -29, -8, -68, 0, 22, -55, 2, 0,
    -28, 0, -15, -1, 24, 15, -11, 17,
    -13, -17, -1, -23, 21, -91, 38, 4,
    5, -6, 2, -4, -2, -23, -20, 7,
    14, 30, 23, -21, -6, 35, -1, 35,
    -13, -36, 8, -48, 18, -3, 2, -20,
    57, -11, -56, 16, -42, 35, 16, 7,
    -12, 15, 45, -16, -65, 31, 84, -24,
    -20, 34, 0, 1, -23, 7, 6, -10,
    -15, 23, 5, -10, -40, 0, -2, 5,
    -5, 6, -23, -20, 16, 14, -48, -50,
    -27, -14, 15, 6, -35, -8, -8, 70,
    -19, -30, 20, 39, 53, 13, 20, 32,
    -10, 1, 4, -5, -45, -22, -56, 3,
    124, 5, 7, -31, -50, 51, -8, 46,
    18, 39, 43, -7, -13, 52, -9, -8,
    18, 4, -7, 64, -11, 26, 10, 41,
    -3, -18, -28, 10, -13, -1, -24, 49,
    0, -32, -26, 18, -28, -32, 41, -13,
    10, -39, 52, -32, -16, 37, 23, 45,
    -12, -1, -1, -1, 44, 10, -1, -11,
    20, -7, -7, 4, 49, 20, -23, -6,
    -5, -14, 10, -6, -30, 17, 13, -36,
    56, 24, -56, -38, 9, -41, -26, 7,
    40, 4, -1, 21, -24, -22, -13, 18,
    -8, 5, -15, -10, -11, -11, -43, -26,
    19, 5, -15, -35, -9, -47, 2, 36,
    1, 0, 19, -45, 80, 7, 26, -4,
    11, 12, -48, 36, 22, 9, 24, -15,
    15, 0, 3, 12, 127, -9, -21, 24,
    -19, 5, -2, -14, 3, 29, 7, 28,
    -47, -64, 1, -11, 9, -6, -46, -4,
    -8, -10, -21, 8, 45, -79, 11, 11,
    5, -3, -46, 0, 59, -9, -19, -20,
    -19, 18, 19, -9, -3, 60, -63, 20,
    -20, -19, 0, 91, -10, -20, 9, 44,
    4, -86, 4, -12, 24, -30, 7, -18,
    4, 24, -31, 3, -6, 9, -23, 16,
    -79, 2, 12, 2, -43, 41, -29, -52,
    16, 33, 43, -2, -7, 40, 20, -53,
    21, 108, 12, -16, -17, 6, 34, 32,
    6, -3, -5, 10, -35, -5, 7, -15,
    -8, 3, 41, 36, -14, -1, -4, 4,
    0, -18, -4, 23, 49, 61, 36, 93,
    -12, 41, 11, 10, 43, -79, 19, 29,
    6, -7, 4, -27, 4, -3, 36, 17,
    -8, -11, -17, -35, -66, 86, -40, 20,
    -74, 4, 19, 4, -67, -9, 0, 20,
    -11, -17, 82, 19, 20, -73, -84, -45,
    -27, -21, -12, -10, 32, -51, -1, 35,
    5, -2, 17, -30, 10, -11, -6, -14,
    -53, -30, -35, 23, -6, 18, -14, 1,
    -11, 24, 9, 2, -14, 17, -23, 16,
    2, 8, 9, -68, -24, 26, 4, 9,
    13, 22, 3, 6, 59, 70, -2, 53,
    65, -74, 101, 21, -62, 31, 15, -13,
    8, -10, 23, 1, -32, 32, -10, -22,
    -7, 20, 13, -1, -8, 6, 13, -39,
    -4, 37, 49, 57, -3, 60, 15, 13,
    -44, 1, -8, -61, -1, 11, 44, -16,
    -9, -28, -11, 4, 11, 0, -19, -12,
    -4, -9, -5, -2, 12, -65, 12, -25,
    -1, -7, 30, -21, 12, 50, -50, 24,
    37, -26, 13, -11, 16, 25, 54, -17,
    -28, 2, -5, 8, -32, -14, -41, -30,
    7, -5, -16, -8, -27, -20, -28, -10,
    -41, -14, 19, -13, 28, 32, 28, 41,
    -3, -7, 6, -4, 36, -29, 27, 28,
    6, -23, -15, -47, -27, -42, 2, 15,
    42, -24, -6, 40, 70, 21, -10, 7,
    6, -19, -23, 17, -24, 21, 31, -23,
    6, -31, 14, 25, 59, 43, 13, 13,
    3, 10, 3, -8, 12, -12, -25, 36,
    1, -1, 8, -7, 27, -11, 9, 52,
    11, -7, -5, -19, 16, 101, 27, 12,
    55, -9, -15, -38, -4, -18, -31, -8,
    -11, -47, 7, 23, -22, 23, -18, 24,
    9, -3, -28, -2, 20, 23, 33, 1,
    -3, 3, -4, 19, -49, -27, -24, -25,
    -17, -3, 18, -29, -42, -4, -7, -40,
    -1, -3, -23, -13, 39, -40, -31, -7,
    3, -35, -4, -23, -91, -10, -16, -52,
    -1, -16, -3, -1, -8, 18, -50, 25,
    -97, -29, -55, -23, 46, -32, -16, 7,
    -15, -69, -8, -12, -5, 6, 45, 25,
    -10, 20, -7, 1, -33, -20, 30, 2,
    -16, -19, 37, 10, 48, -14, -7, -23,
    23, 8, -31, 75, 37, 10, -27, 61,
    4, -5, -38, -1, 62, 39, 32, 22,
    -8, 10, 19, 13, 22, 9, 27, 3,
    12, 5, 5, -50, -19, -4, -18, 37,
    24, 21, 22, -1, -4, 17, 8, 28,
    -11, -27, -30, -20, 10, 44, -16, -27,
    -5, 9, 16, -2, -5, 3, 21, -38,
    -5, -27, 34, -25, 17, -25, 59, -17,
    5, 4, -20, 28, -1, 19, -38, -39,
    0, 8, 3, -20, -5, -13, -2, 17,
    10, -2, 12, 1, 13, 8, 31, -1,
    -30, -28, -29, -25, -16, -15, 17, -6,
    0, 21, -14, 21, 19, 23, -1, -14,
    -7, -11, -10, 8, -8, -5, -13, 10,
    -24, -3, 8, 0, 20, 0, 4, 2,
    11, -9, -6, 30, -12, -15, -30, 8,
    -17, -6, 25, 31, -10, 18, -2, -20,
    -20, -5, 17, 14, 11, 20, 6, 11,
    13, -2, 8, 15, 28, -24, 34, -4,
    7, 22, 17, 0, 16, 4, 14, 34,
    -2, -1, -14, 8, -7, -24, 20, 61,
    20, -4, -19, 44, -21, -2, -15, 4,
    -1, 9, 16, 10, -9, 11, -7, -36,
    -8, -11, -2, 20, 8, -14, -13, -26,
    -43, 14, 27, 5, 3, 67, -15, 9,
    -11, 20, 18, -20, -12, -10, 3, 0,
    10, 20, -19, -1, 5, 4, 7, -17,
    -5, 22, 26, -24, 3, -37, 19, -12,
    -10, -9, -13, 37, 10, 7, -31, 3,
    7, -17, -19, 13, -2, -14, 2, -1,
    12, 14, -8, 3, 20, -8, 14, 10,
    13, -23, -14, 6, 4, -12, -19, -29,
    -1, -5, 13, -24, -41, -17, -3, 6,
    -32, 11, -12, 32, -10, -17, 12, -12,
    -17, 4, -5, 0, 4, -4, 12, -23,
    -4, -4, -26, 5, 13, 9, -13, 5,
    -49, 7, 0, -4, -48, 56, -12, 14,
    -27, -29, 8, -3, -4, 5, 9, 12,
    -3, 3, 4, 10, 0, -45, -14, 7,
    -21, -17, 10, -3, -15, -38, -28, 2,
    32, -4, -1, 14, -19, -19, 5, -24,
    -6, -13, -19, 11, 11, 17, 5, 10,
    3, -5, 29, -5, -17, -11, 11, 18,
    -34, -9, 2, -25, 19, 27, -57, 9,
    -9, -5, 11, 11, 20, 40, 7, 1,
    -37, -27, -7, 45, 28, -26, 4, 1,
    2, -7, -15, -3, 10, -32, 11, 17,
    14, 23, 18, 6, -7, -19, -23, 13,
    -3, -10, 6, 38, -10, -25, -10, -26,
    7, 1, 4, -6, 9, -12, 10, 8,
    -10, 19, 10, -12, 1, -13, -11, 6,
    -6, 15, -24, 9, 23, 16, 16, -5,
    37, -16, -3, 34, 10, -8, -9, 3,
    66, 47, -1, 8, 8, -11, 9, 2,
    14, 9, -3, 4, -4, 9, -3, -20,
    22, -17, 13, 8, -19, 3, -4, 10,
    -40, -9, -2, 9, -33, -16, -35, 23,
    -73, -19, 0, 8, 14, 14, 16, 2,
    30, 16, 4, -6, -8, 15, -25, -16,
    -22, 23, 4, 18, -31, 5, -1, 6,
    -7, 24, 17, 24, -21, -34, -32, 18,
    -8, 14, -13, -8, 3, -4, 23, -10,
    21, 20, 5, -10, 1, -12, -7, 2,
    -12, -5, -13, -2, -2, -22, -4, 11,
    39, 29, -20, -5, 30, 11, -16, -7,
    14, -13, -7, -25, 3, -2, 15, -4,
    -4, 10, 13, 4, -13, -11, 10, 25,
    21, -2, -23, 14, -48, 31, -10, -1,
    13, -41, -68, -9, 19, -39, 32, 5,
    10, -44, 9, -5, -7, -7, 14, 3,
    9, -2, -7, -17, 20, -3, -1, -2,
    16, 12, 45, -20, -13, 12, 12, -7,
    8, 9, -10, -14, 29, -1, 21, 17,
    11, 4, 22, 2, 3, 1, 2, -13,
    -11, -7, -6, -2, 40, -34, 17, -14,
    15, 13, 6, 24, 3, -22, 24, 21,
    12, 1, 12, -46, -4, -17, -16, -60,
    17, -10, -24, 26, 16, 26, -10, -7,
    16, 7, 6, 4, -3, 0, 7, -6,
    -10, -7, 9, -2, 6, 26, -3, 43,
    42, 2, -6, -13, 43, -3, 16, -17,
    11, -14, -20, -8, 3, 3, 0, 13,
    10, -5, -5, 8, -7, 6, 6, -6,
    10, 24, 16, -11, -3, 9, -1, -17,
    14, -10, 22, -21, 4, 37, 8, 21,
    -9, -21, 6, -42, 16, -6, 20, -14,
    3, -16, 8, -8, 29, 57, -13, -7,
    -1, -13, -11, -13, 9, 8, 8, 19,
    15, -13, -15, -8, -42, -22, 2, -18,
    -9, -10, 23, 6, 5, -4, -13, 3,
    -8, -4, -16, -11, -12, 25, 1, 28,
    11, 18, 8, -1, 1, -14, 23, -29,
    44, 12, 29, -3, -31, 6, 6, 8,
    -4, 9, -22, 20, 4, -2, 22, 39,
    -12, -13, 10, 10, 2, -6, 25, -10,
    0, 14, -15, 36, 10, 7, -5, 27,
    20, -45, -18, 12, 34, 30, -2, 3,
    -4, -8, 9, -5, -13, -27, 10, 26,
    -2, 6, -3, 16, 1, -12, -20, 47,
    -4, 7, -28, 38, 9, 13, 21, 10,
    7, 6, 13, -13, -34, 3, -4, -21,
    26, -39, 19, 5, 17, -7, -4, 10,
    4, -6, 12, 18, 15, -2, 22, 23,
    -13, -9, 19, 10, 12, -48, -25, -27,
    25, -9, 6, 44, -25, -19, -23, -29,
    -29, -11, -30, 11, -3, 9, -1, -11,
    8, 4, -3, -21, -9, 4, 1, -40,
    -10, -13, -5, -8, 14, -23, -8, 19,
    -30, -5, -40, -17, -2, 23, 10, -21,
    21, -35, 1, 15, 5, 2, 24, 8,
    16, 13, -2, -7, -1, -10, 21, -1,
    21, 7, 16, 0, 23, 28, 8, -26,
    1, -8, -64, 4, 13, -24, -24, 11,
    -10, 4, -3, 1, 8, -15, -1, -2,
    4, 10, 30, -8, -23, 20, 8, -2,
    -8, 8, -9, 31, -7, 6, 0, -1,
    0, 0, 13, 18, 3, 26, 10, 9,
    -8, -33, -7, -11, -3, 23, 14, 5,
    -23, -11, -1, 11, -17, 23, 20, 11,
    1, 9, 12, 19, 29, -8, -38, -5,
    -30, 19, -33, 0, 7, -1, -3, -18,
    -6, -8, 19, -22, -19, 21, 6, 13,
    8, -19, -18, 3, 11, 24, 25, 20,
    0, 6, -24, 23, 4, -14, -9, 0,
    -12, 26, -11, -10, -39, -18, -5, 40,
    10, -28, 18, -30, 2, -10, 11, 5,
    5, 12, 4, 16, 20, 5, 4, -34,
    19, -17, 31, 12, 13, 10, 0, 10,
    11, -31, -31, -23, -5, -40, -8, 3,
    12, 2, -16, 13, -13, -4, 1, -14,
    2, 3, -7, -25, 17, -13, 6, 45,
    -2, -9, -17, 42, -32, 11, -2, 3,
    4, -11, 11, -1, -2, 9, -8, -4,
    24, -25, -6, -3, -12, 5, 26, -2,
    2, 2, 14, 2, -5, 30, -5, 28,
    -13, 38, -5, -8, 26, -6, 0, -1,
    -1, -7, 33, -24, -5, 5, -29, -26,
    -24, 1, -11, 0, 17, -14, -8, -12,
    12, -2, 17, -17, -19, 3, 52, -29,
    -16, -19, 2, -17, -22, -24, -23, 37,
    -50, -20, 6, 6, -44, -16, 26, 9,
    12, 2, -34, 4, -5, 8, -9, 9,
    16, -16, 11, -4, 39, -6, -9, 18,
    -9, -11, 2, -7, -24, 18, -8, -27,
    -29, 3, 1, 45, 19, 0, 4, 31,
    -22, -24, 21, -15, 10, 22, 10, 0,
    -1, 2, -12, 19, 9, -21, 29, -7,
    20, -29, 6, 4, 3, 9, 44, 30,
    25, -4, -3, -4, -18, -16, -1, 29,
    13, -20, -3, 8, 0, 2, 11, 2,
    -16, 17, 10, 3, -29, 5, -1, -14,
    -1, -1, 31, -14, -42, -25, -33, 16,
    -14, 46, 43, 11, -29, 41, -28, 0,
    -23, 5, -2, -14, -4, -1, 15, 14,
    5, 17, -34, -7, 13, -11, -7, 34,
    -14, 12, -5, 11, -18, -17, -35, -3,
    14, -42, -9, -24, 11, -31, -22, -24,
    0, -19, 14, 3, 1, -12, 4, -12,
    12, 5, -9, 50, 20, 13, 20, -12,
    -27, 5, -34, -19, -10, 39, -15, -19,
    45, 19, 10, -2, 9, 23, 10, -7,
    -58, -3, 6, 17, 27, -24, 8, -6,
    -29, 8, 5, 12, -16, 31, 0, -28,
    13, -19, -6, -16, 52, 25, -6, 3,
    -80, 20, -1, -27, -58, -17, -46, 3,
    -27, 6, -33, -12, 6, 3, -2, 10,
    -22, 1, 21, 19, -16, -30, -40, 7,
    -26, -4, -22, 36, 9, 21, -19, 30,
    61, -42, 15, -11, -5, -15, -15, -6,
    14, -22, -18, -9, 15, -10, 6, -7,
    7, -11, 16, -26, -18, 3, 0, 32,
    -16, 5, -46, -1, 11, -2, -7, 29,
    -7, 1, 25, -5, -8, 9, 15, -18,
    4, -1, -16, 8, 24, -8, -10, 5,
    -1, 0, -16, 7, 13, -17, 7, 14,
    -11, 7, 32, -33, 3, -10, -51, 19,
    -26, 21, -1, -7, -39, 28, 7, 25,
    -28, -31, 5, 11, 14, -2, -13, 16,
    3, -21, 11, -5, 4, -10, 21, 13,
    -24, 25, -33, 22, 24, 12, -39, 38,
    4, 4, -1, 0, -20, 1, 14, -7,
    66, 63, -10, 11, 5, 3, 2, 4,
    17, 19, -2, 3, 5, 6, 4, -23,
    -10, -8, -17, 18, 28, 2, -2, -26,
    -40, -3, -2, 18, 10, -38, 33, -13,
    -45, 1, -28, -4, 3, 9, 17, 10,
    20, -7, 14, 6, -10, -5, -47, -18,
    -1, 0, -10, -22, 0, 35, 20, 3,
    -7, 62, -12, 25, 13, 14, 24, 43,
    5, -14, 6, 25, -12, -13, 8, -26,
    29, 26, 0, -4, -29, -22, -24, -9,
    6, 0, -6, -19, 30, -4, 13, 41,
    -13, 29, -6, -14, -41, 22, 31, 20,
    14, -31, -8, -14, 4, 1, 7, 4,
    -17, 1, -7, 30, -18, -22, -42, -7,
    -5, -14, -39, -2, -8, 8, 35, 3,
    32, -26, 17, -22, -10, -5, -18, -9,
    -13, -35, -10, -3, -1, -5, 21, -10,
    15, -10, 10, 35, 16, -11, 5, 8,
    33, 6, 9, -6, -7, 3, -8, 12,
    -10, 4, 9, 2, 11, 8, 11, 13,
    -7, -2, 7, -19, 4, -16, -11, -19,
    -3, -26, 13, 12, 65, -61, 33, -1,
    -14, -46, 8, 19, -7, 17, 5, 16,
    36, 53, 30, 5, -8, -7, 2, 32,
    10, -5, -11, -3, 14, 5, -18, -19,
    9, -1, 15, -8, 1, -3, 15, 10,
    -12, 3, 3, 35, 25, -17, -7, 14,
    38, -12, 8, 27, 71, -31, -1, 40,
    -23, -16, -17, 25, 9, 14, 6, -7,
    -13, -2, -8, 23, 22, 21, -4, 10,
    12, -7, 7, 17, 1, 2, 2, 31,
    2, -60, 32, -76, 9, -12, 22, 27,
    0, 4, -27, -5, 11, 19, 6, -12,
    11, -25, -8, -24, 15, 42, -20, 26,
    12, 8, 29, 20, 28, -12, -11, -33,
    0, -33, -31, 10, 4, -17, 7, 22,
    10, -10, -11, 9, -25, -11, 5, -4,
    -7, 1, 3, 16, 4, 21, 19, 20,
    34, -2, -15, -31, -34, -16, -41, 36,
    -11, 40, -22, -31, -15, -10, 1, 0,
    26, 25, -17, 28, 13, 8, 7, 38,
    20, -10, -2, 9, 13, -10, 32, -12,
    3, 35, 3, 30, 7, -53, 16, 17,
    16, -7, 41, 16, 26, 4, 24, 13,
    -14, 22, 15, -15, -8, -15, -2, -7,
    15, 17, 14, 31, -13, -12, 17, -7,
    -16, -9, 31, -11, -9, 3, 29, 23,
    -14, -28, -9, -4, 18, -9, 15, -11,
    24, 3, 12, -19, -21, 20, -3, -6,
    -13, 5, 18, 10, 17, -1, -20, 5,
    14, -3, -13, 24, 8, -30, 34, -5,
    36, -20, -22, 50, -28, 3, 28, -6,
    -22, -8, 16, -42, -12, 4, 12, -1,
    12, -7, -9, 6, 12, 1, -23, -23,
    1, -28, -6, -8, 21, -5, -10, 43,
    -13, 7, -7, -40, 20, 5, 14, -31,
    22, -30, 25, 12, 0, -1, 18, -7,
    13, 12, -5, -5, 1, -25, 15, -3,
    54, 10, -15, -3, 8, 33, -21, -6,
    -2, -6, -25, -17, 33, -12, -24, 1,
    -9, 19, -2, -9, -9, 3, -2, 9,
    -14, 11, 29, 2, -45, 6, 11, 20,
    18, -9, 24, 46, 1, -14, -10, -14,
    16, -15, -35, -11, -9, -6, 3, 16,
    -22, 1, 0, -7, -35, 12, 6, -8,
    4, -16, 1, 2, 21, -30, -5, 43,
    -14, -14, 2, 6, 20, 5, -4, -23,
    8, -21, 29, 25, -11, 1, 16, 33,
    11, -11, -5, 9, 14, 27, -6, 6,
    9, -19, 9, 19, 33, 5, 37, -3,
    -48, -3, -37, -20, -54, 5, -32, 9,
    -17, 2, 10, 0, -38, -32, 2, 1,
    -2, -1, -13, -10, 19, -18, 5, 3,
    8, 14, -17, 22, 7, 8, 8, -24,
    -19, 2, 20, -6, -1, 28, -2, 9,
    18, -33, -62, -5, -52, -34, -8, -37,
    1, 24, -26, -52, -9, -9, 1, -8,
    -6, 7, 7, 3, 2, -1, -10, 43,
    -8, -5, -19, 9, -5, 6, 8, -53,
    -34, -36, 41, 5, -8, 28, -6, 10,
    -19, 5, -5, 8, -12, -6, -15, -9,
    -11, 19, 9, -2, 4, -10, 2, 18,
    -2, -6, 10, -2, 69, -9, 23, 3,
    -22, 7, -55, -37, 31, 4, 66, 50,
    -14, 6, 4, -43, -9, -25, -19, -46,
    4, -11, 40, -24, 8, 14, 127, -39,
    2, -17, -2, -13, 5, -14, 13, 20,
    -18, 5, -30, -41, 25, -9, 23, -25,
    -34, -27, -36, -8, -17, -9, -32, -13,
    42, -59, -4, -10, 45, -61, -26, -11,
    18, -8, 9, -21, -13, -41, 12, -4,
    -9, -20, -17, -14, 3, -39, -72, -56,
    -11, 0, -13, 0, 34, 32, 7, 9,
    -6, 2, -42, 32, -8, 2, 17, -35,
    -18, -45, -26, -9, -18, 15, -15, 26,
    -2, 21, -61, -4, -47, -31, -26, 12,
    -19, -5, 43, -18, -25, 47, 19, 22,
    -8, 40, 14, -34, -36, -4, -15, -46,
    32, 7, 17, -7, 37, -32, -22, 48,
    -28, -16, -2, 31, 13, 37, -23, -47,
    -30, -48, 24, -24, -19, 1, 48, 81,
    13, 20, -71, -2, -3, -59, -39, 38,
    1, -8, -15, -16, 14, -24, 32, 23,
    3, 50, -46, -26, -46, 32, 76, 53,
    0, -30, 0, 56, 20, -9, -12, -3,
    29, 44, -11, 73, -1, 36, 35, 38,
    13, -24, 42, -12, -25, -23, 52, 0,
    -54, -22, -7, -38, -60, -54, 17, 36,
    61, 17, -1, -37, 11, -14, 1, -12,
    -68, -10, -1, 29, -27, 15, 8, -27,
    -7, -16, -3, -29, -71, 1, 17, -33,
    50, 34, 9, 62, 82, 5, 10, -81,
    28, -37, 6, -11, 1, -16, 22, 2,
    3, 35, 15, 29, 7, -98, -86, 8,
    18, -22, -17, 22, 5, -16, -53, -35,
    6, -20, -5, -1, -15, -6, 36, 1,
    3, -16, 0, -24, 26, -8, 20, -34,
    13, -10, -22, -58, -26, 1, 24, 62,
    -3, 50, 20, 53, 7, -39, 20, -5,
    -3, 55, -11, 32, -3, 78, 38, 3,
    -27, 2, -6, -7, 9, -4, -39, -23,
    1, 0, -10, 15, 48, -23, 0, 24,
    4, 14, 36, -47, 3, -11, -117, -7,
    72, -36, -39, 38, -4, 46, -2, -13,
    -20, -32, 15, 48, -5, -47, -14, 29,
    -27, -37, 4, -9, -14, -75, 5, 34,
    -7, 47, 4, 13, -3, 57, 66, -14,
    6, 16, -68, -59, -45, 2, -33, -37,
    -11, 49, -4, -19, -31, -19, 6, -24,
    -21, 15, 13, 7, 14, 5, -29, -30,
    -20, 34, -56, -11, 86, 43, 15, -74,
    31, 47, -10, 41, 75, 15, -14, 52,
    -27, -21, 67, 34, 11, -18, 49, 6,
    36, -31, 8, 19, -56, 21, -65, 10,
    -6, -18, -21, 42, -16, 36, 28, 40,
    -64, -46, -1, -3, 23, 8, -26, 64,
    58, 44, 63, 66, 11, -7, 5, -16,
    36, 79, -3, 4, 21, -19, -19, -26,
    8, -7, -33, -42, 17, -25, 29, -56,
    32, -19, 1, 101, 61, 12, 0, 21,
    -14, -13, 44, 3, 15, -4, -4, 25,
    -46, -19, -29, 65, -38, -29, -29, 30,
    -9, -3, -2, -36, -9, 16, 2, 3,
    -67, 33, -33, 1, 6, 3, -1, 63,
    12, -47, 23, 7, -25, 37, 14, 30,
    28, -38, 66, 56, 23, -44, -6, 30,
    91, 15, -20, -3, 0, -25, -45, -11,
    30, -23, -50, 17, -14, -61, -41, 13,
    -12, -15, 29, -5, -9, -11, 25, -15,
    4, -33, 17, 5, 60, -23, 38, -25,
    12, 7, -10, 13, -13, -40, 26, 15,
    11, -66, 10, -50, -15, -17, -10, -26,
    19, -3, -22, 1, -5, -18, -15, 4,
    7, -7, 18, -17, 8, 24, 30, 57,
    -21, -8, -5, 16, 79, -6, -23, -45,
    -75, 42, 24, 0, 44, -16, 25, -30,
    -114, 9, -34, -9, -8, 16, -24, 7,
    -24, 15, -7, 53, 5, 10, 19, -42,
    -18, -12, 22, -15, -27, -38, 1, 12,
    -58, 122, -5, 68, -7, 14, 112, -52,
    27, 32, 5, 18, 15, 18, 10, 44,
    39, -48, -14, -19, 14, 86, -18, 14,
    30, -28, 66, 22, 22, -33, 14, -82,
    -33, 43, -49, 59, -79, -35, -33, -78,
    71, -30, -6, 22, 37, -5, 35, 7,
    22, -3, 32, 67, 67, 2, -1, 90,
    -12, 5, -35, -29, 9, -59, -74, 75,
    99, 30, 39, -23, -4, 28, -29, 19,
    -59, -31, -57, 12, -20, 8, 6, 28,
    10, 21, -23, 19, 25, -20, 38, -3,
    9, 48, -17, 25, -36, 106, 9, -5,
    -52, 109, 4, -21, 3, 21, 2, -111,
    6, -85, -50, 24, -4, -67, 34, 40,
    -14, 13, 39, 46, -48, -48, -7, -1,
    -15, -18, 18, -53, -5, -41, 9, 4,
    -17, 18, 30, 9, -26, 19, 1, 12,
    50, -51, 47, -34, 30, 5, -26, -24,
    -75, -44, 34, -3, 22, -27, -39, -25,
    5, -20, -28, -12, -47, 72, -23, 32,
    -36, -4, 39, 12, -26, 17, -19, -3,
    11, 11, 31, -13, 1, 7, 24, 16,
    6, 0, 47, 16, -13, 7, -28, -55,
    15, 5, 15, -20, -2, 12, 51, 41,
    -56, -15, -25, -32, 4, -6, -31, -49,
    15, 25, 95, -15, -3, 27, 32, 5,
    3, 30, 8, 12, 28, -21, 46, 20,
    94, -17, -33, -14, 34, -9, 42, -25,
    -9, -19, 28, -29, 0, 32, -36, -1,
    28, 29, 42, -16, -27, -32, 21, -1,
    -55, 13, 127, -9, -52, 13, 14, 52,
    18, -16, 3, 48, -4, 16, -10, 68,
    49, 47, 13, -45, 4, 49, -69, -44,
    -17, 90, 55, -7, 0, 15, 50, 10,
    -9, -11, 4, -30, -1, 2, 15, 43,
    -4, -15, -7, -10, -76, -11, -37, -29,
    61, 53, -37, -29, -4, -12, -23, -37,
    21, 14, 15, -37, 12, 38, 6, 2,
    29, -15, 47, 48, 27, 5, 61, 6,
    -92, -37, -30, -19, -24, -11, -8, 2,
    48, 25, 0, 46, -53, -23, 15, 12,
    -46, -12, -36, 21, 7, -9, -10, -2,
    14, 8, -60, 52, 26, -48, 1, 32,
    -24, -7, -18, -27, -30, 17, -1, -7,
    -47, 34, 45, -23, -60, 49, 101, -16,
    4, 81, 20, 31, -7, 0, -1, -9,
    -37, 27, 0, 27, 17, 58, -4, 79,
    3, 37, 5, -7, -2, -11, 11, 41,
    3, -9, 0, -42, -13, -11, 28, -54,
    15, 3, 15, 19, -2, 46, -38, 3,
    -17, 45, 16, -13, -42, -1, -13, 11,
    -29, -26, -12, -9, 7, 63, 36, -50,
    18, -11, -6, 15, -2, 32, -6, -2,
    27, 21, -43, 32, -32, 24, 19, -4,
    -32, 9, -57, -15, 9, -5, -19, -5,
    -2, -12, 4, -11, 9, 0, -30, 13,
    -6, 7, -11, 9, 15, -24, 12, -36,
    -3, 29, -21, -23, 0, 15, 0, 2,
    26, 0, -65, 26, 2, 10, 2, -3,
    -20, -10, -31, 8, -31, 3, 6, -18,
    -6, 12, -11, 4, -15, 6, 35, -24,
    3, 1, -19, -10, -1, 18, 2, 5,
    5, 33, 0, 21, 9, -2, 18, -8,
    28, 0, 24, -16, 22, 5, 6, -16,
    -12, 19, 19, 1, 22, -15, 15, 0,
    -21, -1, -1, -27, -39, -1, 42, -8,
    8, 3, 37, 44, -15, -14, 8, 3,
    4, -11, 32, -24, 12, 7, 32, -17,
    -20, 8, -22, 6, -23, -8, -4, -28,
    -5, -18, -19, 13, 35, -4, -12, -8,
    -37, -21, 57, 17, -21, -6, 13, 1,
    -16, -24, 4, -1, -19, 12, -22, -21,
    12, 26, -1, 9, 8, 1, 6, -26,
    -8, 56, -9, 16, 8, 26, 49, -15,
    20, -7, 31, 3, -20, -5, -5, 24,
    -18, -10, -26, 1, 3, 9, -3, -3,
    -8, 14, 26, 6, 46, -20, 26, -45,
    6, 21, 31, 34, -37, -41, -2, -43,
    20, -21, -5, -8, 17, 17, -3, 6,
    -7, 27, 17, -5, 20, 12, 1, -26,
    28, 16, -2, 15, 1, 8, 15, 0,
    -15, 23, -16, 22, -43, 14, 21, -23,
    -8, 13, 10, -34, 29, -11, -26, 16,
    10, -31, -1, 33, -16, 8, -17, 14,
    -11, -9, -14, -9, -2, 37, 12, 7,
    18, -28, -34, -53, 10, -2, -8, -36,
    19, 13, -16, -28, 25, 1, 7, -8,
    -3, -6, -9, -65, -7, 11, 12, 10,
    -5, -28, 2, -7, 2, -31, 5, 4,
    4, 0, 11, -6, -4, -35, -25, 21,
    23, 14, 30, -20, -15, -4, 14, -18,
    -60, -18, 1, 30, 9, -22, 8, -18,
    3, 12, -2, 0, 37, -45, -32, 33,
    -23, -58, -10, 28, -34, 30, -29, -14,
    -13, -12, -1, -4, -11, 17, -1, 17,
    40, 15, -38, 22, 7, -13, -21, -7,
    -12, -4, 6, -5, -9, -18, -11, -21,
    0, -6, -19, 1, 10, 31, 17, 16,
    -3, -24, 9, 31, 28, -2, -22, -21,
    16, -4, 16, -6, 3, 6, -2, -24,
    -2, -9, -5, 1, 17, -21, -39, 27,
    -4, 50, -33, -14, -26, 16, 6, 21,
    -19, 30, 21, -22, -30, -9, 21, 19,
    -17, -7, 28, 13, -15, -24, -16, 8,
    1, 8, 0, -14, 23, -8, 6, -8,
    -17, -73, 13, 6, 55, 14, -2, -34,
    -25, -32, 3, 13, 14, 5, 2, 31,
    -7, 26, -33, 25, -5, -27, -2, 4,
    -16, 5, 12, -2, -7, 9, 19, -8,
    -21, 4, 37, 7, -16, -12, 2, 18,
    15, 9, -32, 14, -13, -11, -14, -9,
    3, -12, 30, 21, -6, -18, 1, 0,
    -29, 38, -5, 1, -8, -29, -39, 10,
    -127, -1, 17, -15, -12, -5, 13, -13,
    -57, -6, -3, 36, -46, 5, -5, 23,
    -18, 20, -16, -11, -14, -3, -6, 0,
    14, -3, 7, -24, 9, -12, 27, -8,
    11, 27, -18, -26, 3, 10, -6, -36,
    52, -60, 9, 26, -1, -10, 14, 8,
    17, -41, 35, -6, -6, -19, 15, 15,
    6, 4, -1, -6, 22, 16, -7, 6,
    -1, -26, -33, 43, -4, 13, -15, 35,
    -39, 9, -9, -18, -11, 10, -6, -9,
    -17, 5, 7, 18, 0, -13, -8, 43,
    13, 2, 0, -8, -17, -18, -2, 76,
    -2, 1, -20, -18, 5, -8, -24, -35,
    23, -4, 0, -20, -8, 16, -8, -26,
    -6, -1, -15, 7, -15, 1, -5, -8,
    -12, 3, 4, 11, -25, 0, 11, -7,
    -47, -12, -38, 5, 34, -37, 24, -30,
    -31, 21, -43, 35, -12, -18, -6, -8,
    -9, 31, 1, 30, 3, 32, -10, -9,
    -13, 21, 16, -16, 33, -7, 1, -30,
    -9, -32, -10, -12, 15, 28, -5, -6,
    14, -13, 32, -22, -18, -22, 2, -17,
    -12, -20, -5, -33, 10, -12, 8, 10,
    0, -10, -4, -28, -38, 7, 11, -7,
    -34, -23, -14, -29, -15, -6, 38, -15,
    -4, 7, 2, 14, -8, 25, -19, -1,
    -55, -1, -32, 5, -11, -15, -11, 2,
    11, -15, 8, -6, -12, -14, 13, 12,
    12, -4, -1, 31, -11, -35, -38, 22,
    11, 6, -16, -68, -4, 23, -14, -11,
    -1, 17, -28, 13, -1, -12, -1, 27,
    -11, -17, -2, 31, -11, -8, -33, -10,
    -76, 61, 13, -30, 9, 30, 24, 18,
    10, 3, -32, -19, 3, 23, 4, 0,
    37, 24, -13, -18, -9, -10, -13, -10,
    -5, 4, -25, 1, 9, 15, -13, 49,
    -76, 38, 30, -27, 8, -1, -29, -39,
    21, -2, -22, -28, -26, 2, 9, -23,
    -34, 11, 38, 6, -4, -8, 11, -11,
    -18, 11, 7, -3, -14, 3, 19, 3,
    -58, 40, 35, -20, -35, 22, 12, -34,
    30, 7, 40, -25, 7, 7, -6, -1,
    -17, 37, -17, 22, -8, 37, -14, 21,
    1, -13, 5, 7, 26, 1, -11, 10,
    -5, -25, 15, -18, 34, 3, 16, -19,
    11, -12, 12, -1, 8, 29, 3, 14,
    -17, 31, 9, -48, -13, 2, -2, 17,
    -19, -18, 8, 11, 44, 19, 6, -16,
    -11, 17, 12, 5, 6, -1, -7, 35,
    -1, -29, 30, 1, -31, 6, 3, 3,
    -6, 15, -17, 19, 2, 15, 12, -9,
    -15, 10, 5, 8, 26, -25, 12, -28,
    81, -6, -4, 18, 36, 11, 6, 4,
    14, -25, -5, -5, -11, -6, 0, 13,
    4, -12, 8, 26, 6, -14, 13, 16,
    7, -2, 6, -11, 6, -9, -10, 36,
    21, 7, -16, 20, 10, 30, -4, 15,
    -22, 3, 54, -8, 15, 6, 3, 29,
    36, 8, 19, 7, -9, 8, 2, 4,
    2, 9, -4, -6, -2, -45, -16, -3,
    -13, -3, -28, 5, -8, 17, -13, 0,
    10, -10, -66, 20, 1, 24, 5, -4,
    17, 13, 9, -17, 5, -6, -3, 1,
    -4, -14, -10, -9, -22, -4, 7, -9,
    27, -4, -7, -30, -9, 35, -6, 37,
    1, -6, 12, 3, 5, 14, -10, 0,
    18, -10, 27, -33, 13, -37, -8, 4,
    6, -7, 15, -2, -1, 22, -21, 6,
    16, 9, -7, -23, -13, 20, 18, 39,
    -25, 13, -20, 27, 1, -1, 22, 14,
    -17, -20, 1, 9, -20, 13, -4, 19,
    8, -22, -11, -10, -29, -1, -13, -51,
    -13, -24, -10, 19, -40, 11, -5, -35,
    -37, -2, -54, 21, -9, -14, 8, -12,
    24, -12, 3, 7, -6, 12, -8, -13,
    3, 16, -19, 1, -20, 0, 26, 6,
    -6, -2, -9, 23, -3, 7, -12, -2,
    65, 2, 68, -18, -10, -2, 4, 7,
    1, 15, 16, 18, 0, -3, -26, 35,
    -9, 6, 5, 4, 20, 10, 5, 11,
    4, 6, -18, -1, -26, -1, -11, -14,
    -23, 3, -21, 2, 13, 3, -1, -6,
    -10, 45, 21, -5, 6, 7, 2, 21,
    -24, 22, -22, 15, 0, -19, -22, -16,
    15, -2, -4, -1, -10, 19, -119, 5,
    21, -8, 48, -20, -12, 14, -3, 0,
    -13, -1, 7, -28, 3, -7, 15, -17,
    2, -6, -16, 1, -8, 27, 12, -14,
    8, -28, -1, -2, 11, 21, 27, -26,
    39, -4, 3, 10, -21, -26, -23, -21,
    -14, -12, -12, 15, 16, 16, -8, 8,
    17, -9, 30, -3, 24, -4, -3, -15,
    -10, 4, 7, 4, -9, -49, -14, -14,
    -22, -2, 5, -30, -5, -3, -1, -1,
    21, 12, 7, 13, 31, -26, 2, -1,
    28, -4, 6, -2, 31, -6, 12, 22,
    2, -10, -24, -7, 5, 24, 27, -32,
    1, -33, 38, 19, -22, 4, -22, 7,
    -22, -21, 37, 25, -18, 14, 8, -9,
    -46, 5, 1, -6, 1, 36, -15, -14,
    14, -4, -20, -10, -9, -2, -4, -1,
    -14, -57, 6, 11, 31, 22, 31, -3,
    -15, -18, -21, 11, -5, 10, 2, -6,
    2, -9, 3, 3, -9, -30, 10, 29,
    -14, 1, 24, 9, -8, 3, 11, 30,
    7, -13, 32, -4, -7, -5, 4, -28,
    -22, -13, 9, 29, 5, -2, 5, -4,
    13, -16, -17, -9, 64, -15, -13, 4,
    -33, -37, 8, 14, 40, -34, 8, -8,
    42, -65, -65, -16, -26, -6, 2, 16,
    13, -10, 24, -4, -9, 14, 5, -19,
    -16, -28, 24, 5, -13, -15, 3, -22,
    -8, 12, 17, -9, 12, 34, 2, -54,
    -34, -24, -42, 34, 12, 3, -13, -20,
    -41, 6, 8, -17, -4, -6, -5, -1,
    -3, 3, -6, 0, 23, -3, -6, 24,
    2, -4, -19, 2, -27, -19, 11, 24,
    -30, -8, 88, 37, -5, 10, 1, 1,
    40, 32, 16, -6, 18, -6, -14, 8,
    13, -4, -29, -8, -40, 13, 32, -14,
    -9, -1, -59, 11, 3, 0, 18, 1,
    4, 30, 41, -18, -24, -6, -20, 13,
    -36, -8, 23, -2, -16, 8, -16, -12,
    -5, 8, -3, 2, 30, 16, 31, 5,
    -35, 8, -9, 26, 11, -24, -17, -27,
    25, -38, 36, -2, -10, 6, -16, -40,
    14, -54, 18, 25, 31, 9, -13, 0,
    -7, 70, 1, 5, -11, -22, -25, 17,
    -54, 7, 18, -8, 18, 2, -7, 4,
    25, 5, -64, -45, -48, 17, -15, 1,
    -49, 5, 51, 12, -18, 7, 5, 23,
    -9, 3, -1, -3, -11, 19, -7, -24,
    7, 32, -3, -12, 4, -13, 19, -9,
    35, 64, -3, 3, 0, 13, 14, 9,
    19, -11, -34, -27, 10, 44, -1, 12,
    -9, -4, 15, -18, -4, 16, -24, -1,
    24, -21, -6, 25, 4, 0, -20, 26,
    -60, 8, -24, 0, -7, -16, -15, -3,
    -16, 7, -27, -21, -9, 14, -25, 3,
    8, -4, 6, -4, 21, 29, 8, 6,
    -9, -11, -19, -13, -5, 9, 12, -20,
    -8, -13, -1, 1, 4, -10, -10, 9,
    20, 14, -5, -12, 4, 5, -11, 2,
    13, 4, 4, 3, -46, 27, 24, 33,
    17, -22, 22, -35, 52, -4, 2, -21,
    19, 11, -10, 21, -1, -23, -13, 25,
    33, 30, 10, 54, -21, 20, 13, -14,
    7, 21, 56, 4, 18, 0, -53, 20,
    9, 14, -16, 6, -24, 7, -17, -31,
    5, -14, 35, 19, 31, -25, -12, -23,
    -23, 0, -13, -5, -8, -6, 3, -8,
    10, 16, -15, -24, -29, -4, 37, -10,
    -17, 28, -7, -9, -22, -41, 15, -13,
    -15, 35, -4, -15, -29, 10, -18, -4,
    6, 30, -42, -24, 26, -20, 5, 13,
    8, -4, 18, -13, -16, -6, -8, 41,
    0, 1, 6, 16, -14, -6, -7, -22,
    -44, -26, -25, 94, -1, -10, 2, 1,
    -46, -4, -12, -4, 16, -19, 4, 18,
    -11, -4, 9, -2, -5, 24, 4, -25,
    -33, 18, -18, -38, 13, -2, 35, 10,
    -3, -23, 58, -19, 13, -11, 5, -26,
    -66, 23, 60, 0, 20, -8, -18, 4,
    -12, 3, -36, -12, -24, 24, -4, 32,
    -44, 18, -6, 25, -4, 7, -40, 7,
    -7, 10, 27, -3, 12, 2, -10, -7,
    -81, 47, -1, -18, -22, -2, -10, -9,
    10, 3, -1, -9, -54, 20, 6, 14,
    -11, 10, 28, -5, -33, 1, 5, 1,
    -39, 37, 37, -14, 9, -5, -1, -1,
    -7, 51, -2, 24, -5, 10, -22, 7,
    2, 4, 4, 7, 10, 2, -24, -7,
    -4, 21, 2, 13, 1, 0, -38, -44,
    45, 21, 30, -34, -24, -4, -2, 24,
    -5, -9, 11, -3, 11, 5, -13, -2,
    9, 2, -13, -4, 6, -1, -43, 9,
    12, -14, -10, -3, 8, -5, -6, 37,
    13, 8, 10, 8, -8, -2, 10, 18,
    -4, 27, -2, 3, -1, 10, -2, -5,
    13, 22, 2, -8, 12, -13, 4, -14,
    46, -4, 16, -17, 5, 9, 4, -25,
    -17, 35, -38, -6, -9, -11, 9, -3,
    23, -37, -12, 3, -9, -9, 20, -4,
    -6, 6, 11, 10, 8, -4, -4, 15,
    -12, 14, 7, -1, -4, 9, 5, -13,
    -13, 16, 8, 0, -20, -5, -1, -22,
    29, 7, 14, 0, -13, 8, 2, -20,
    -4, 15, 11, 15, 2, -43, -4, 4,
    -28, -4, -41, 13, -8, 32, 19, -18,
    3, 3, 30, -7, -14, 3, -12, 8,
    -2, 2, -16, 2, 2, 9, 0, 3,
    -9, 3, 11, -11, -2, -9, -16, -14,
    0, -9, 13, -23, 21, 27, -4, 15,
    55, -6, -13, -12, -4, 10, -3, -9,
    13, 22, 4, -36, -12, 20, 15, 2,
    -11, -7, 4, 3, -29, -15, 27, -33,
    -29, -5, 8, -6, -9, -15, 17, 7,
    10, 11, 24, -3, -6, -8, -10, -22,
    19, -15, 44, -63, 2, 1, -13, -8,
    -11, -4, 5, 11, -3, 15, -18, -2,
    36, -25, -21, 32, 9, 35, 50, 28,
    32, -1, 11, -25, 16, -4, 22, 11,
    -85, -37, -11, -2, 12, -22, 14, 15,
    16, 31, 6, 16, -24, 15, 4, -12,
    -8, -25, 8, 12, -14, 40, 18, 79,
    66, -2, 1, 14, 37, -9, 3, 8,
    37, 18, -19, 34, -14, -16, -38, 41,
    -19, -22, -3, 11, 0, 30, -16, -28,
    12, 9, -48, -36, -7, -10, -47, 66,
    19, 4, 60, 40, 11, -7, 26, 4,
    16, 23, 51, 33, 21, -35, 49, -18,
    -16, 33, 14, 26, -10, -12, -92, -14,
    6, 18, -37, 0, -24, -1, 81, -34,
    120, -2, 21, -50, 9, -10, 14, -12,
    -47, -5, 13, -23, 11, -27, -20, -38,
    9, -7, -16, -2, 65, 27, -11, -61,
    6, 12, 31, 3, -12, 34, -31, -26,
    86, -62, -44, -49, 11, 18, -28, -45,
    2, -59, 4, 17, 57, -6, -16, 30,
    -15, -5, 17, 14, 25, 1, -8, -3,
    11, -87, 10, 65, -8, -22, -23, 9,
    30, 15, -11, -44, 11, -28, 0, 26,
    30, 61, 8, -20, 33, -29, 6, -32,
    -10, -3, -2, -6, 25, 28, 3, 26,
    -35, 18, 9, -37, -71, -26, 26, 38,
    0, -33, -67, 24, -31, -16, 4, 1,
    -27, -45, -32, -6, -21, -21, 9, -18,
    -61, 19, -2, 5, -47, -35, 3, -14,
    -27, -85, 25, 36, -18, -9, -14, -41,
    5, -127, 24, -14, 11, -32, 10, 17,
    -6, 109, 7, 8, -14, 9, -15, 17,
    6, -12, 7, 19, -20, -1, 17, 71,
    9, 24, 1, 30, -11, -19, 58, 16,
    45, -9, 40, -29, 11, 13, -13, 1,
    -47, -28, 30, 19, -2, -21, 30, 2,
    23, 26, -33, 7, 105, -45, -69, -24,
    21, -27, -19, -10, 2, 30, 48, 47,
    25, -4, 2, -36, 44, -3, 45, 26,
    -7, -30, 44, 56, -6, 15, 31, -32,
    -17, -35, 46, 32, 15, -22, 45, 16,
    -3, -6, 35, 5, 27, -7, 78, -13,
    -51, 13, 25, 0, 0, 7, 12, -20,
    -24, -47, 35, -68, -26, 5, -2, 13,
    8, -10, -10, 8, -3, 46, 17, -22,
    16, 6, -30, -28, -18, -83, -10, 29,
    -9, -44, 75, 7, 42, 24, 2, -15,
    52, -74, 35, 40, 83, 38, -11, 17,
    -18, -14, 17, -13, -49, 9, 38, -11,
    -45, -17, 17, 10, 7, 19, 64, -64,
    -14, 11, 30, -65, -28, -28, -6, -18,
    -15, -7, -44, 5, -5, 29, -46, -10,
    35, 33, 5, 5, 32, 25, 81, 48,
    5, -12, -36, -13, -43, -8, -33, -2,
    -11, 59, -39, -20, 12, 17, -2, 38,
    26, -16, 28, 1, 35, 1, 0, 40,
    -5, 119, -9, -14, -42, 8, -46, -4,
    -116, 40, 10, -50, -65, 9, 48, 4,
    -78, 19, -20, 17, -127, 5, 10, 4,
    22, -6, -7, 6, 5, -3, -16, 26,
    2, 3, 6, -15, 4, 16, -5, -6,
    26, 7, -34, -3, -57, 63, 50, -2,
    -11, 22, 16, 7, 1, -5, -4, 7,
    6, -45, 46, -41, 34, 44, -65, 7,
    -12, 24, 11, -8, -13, -26, -16, -64,
    17, -25, -3, 3, 63, 66, 3, 52,
    -94, 58, -37, -1, 25, 6, 16, -22,
    -64, -65, -14, 45, 102, 27, -21, 26,
    45, -6, 0, 16, 34, 49, -2, 53,
    0, 1, -19, 27, -11, 17, 43, 38,
    -59, -9, 7, -62, 3, 2, 1, 24,
    38, 11, -22, -27, -7, 16, -2, 13,
    13, 8, 23, 18, -53, 38, -22, -23,
    7, 46, 36, -30, 29, 5, -31, -55,
    62, -31, 10, 40, 16, 45, -33, 14,
    51, -39, 56, 38, -6, -23, 17, -22,
    -14, 58, 127, -5, -1, 15, -102, -8,
    -15, 47, 13, -27, -32, 37, -22, -38,
    -72, -29, 15, 20, -26, 23, -31, 5,
    16, 11, 2, -17, -16, 8, 26, 52,
    17, 4, -9, -23, 37, -1, 54, 9,
    68, 31, 51, -2, 31, -26, 30, 2,
    55, 37, 17, -23, 35, 11, 38, -11,
    -56, -25, -55, -52, 29, 2, -2, 22,
    20, -1, 5, 0, -18, 18, -40, 46,
    -22, 16, 21, -30, 14, 40, 27, -58,
    21, -13, 55, 31, 9, -12, -9, -17,
    -10, -67, 26, 6, -14, 8, -10, 12,
    16, 21, 7, -20, -39, 33, -24, 44,
    -8, 42, 3, 55, 1, 14, 22, 18,
    -64, 14, -60, 6, -38, 57, -22, 45,
    9, -28, 0, -27, -5, -62, 50, 14,
    -22, -16, -26, -10, -11, 42, -45, 7,
    -7, -45, 4, 18, -38, 0, -31, 44,
    3, 2, 79, -33, 12, 12, 10, 1,
    -5, 58, 39, -25, -10, 40, -15, -11,
    -26, -17, -2, 11, -101, 28, -12, 17,
    -77, 7, -10, 1, -28, -18, -19, -20,
    66, -38, 4, -17, -22, 0, -23, 5,
    27, 40, 10, 26, -4, 0, -3, 0,
    21, -37, -14, 3, 45, -7, -68, -53,
    0, 8, 3, -30, -5, 13, 8, -42,
    28, 13, 9, -5, 4, 16, 5, -26,
    -23, 10, 0, 3, -6, 37, 1, 17,
    -11, -40, -6, 9, -17, 6, -33, 39,
    -56, -31, -34, 6, 11, -3, 88, -16,
    -11, 41, 47, -108, -10, -10, 9, -38,
    62, 29, 68, -4, 28, 21, -29, -17,
    12, 7, -3, 19, 14, 45, 1, -3,
    45, -3, -38, -25, 78, -5, 39, 17,
    -52, -2, 36, -13, 50, -10, -17, -29,
    -43, 37, 77, -15, -35, -16, 7, -27,
    0, 7, 0, -2, 33, 9, -16, -15,
    -39, 24, 13, 2, 0, -23, 30, 38,
    -9, 24, -84, 15, -20, 14, -17, 1,
    61, -19, -40, -40, -16, -2, -17, -25,
    -14, 10, 0, 20, 27, -21, 1, -6,
    -30, 4, -23, 8, -14, 30, -21, -33,
    16, -3, 16, -100, -4, 9, 18, -15,
    6, 10, -31, -23, -18, 36, 7, 74,
    7, -3, -16, 9, 24, 18, 23, 7,
    12, 50, 9, -5, 20, -31, 51, 8,
    -34, -32, -49, -49, -5, 2, -7, -11,
    -30, -16, 9, -5, -14, -3, 17, -13,
    -14, -8, 11, -24, -9, 27, -16, 23,
    -21, -15, 18, -8, -17, 4, -19, 6,
    9, 3, 1, -20, 7, 4, -32, -11,
    -3, 6, -9, -32, 16, 0, -1, 12,
    23, -10, -22, 23, 8, 17, 14, -2,
    2, 14, -23, 15, 13, -18, 4, -12,
    -21, 19, -1, 39, -21, 31, 40, -1,
    -14, -27, 23, -25, -30, 17, -9, -4,
    3, 12, 10, 10, -10, -24, -20, -3,
    34, 23, 47, 0, -13, 8, 13, -10,
    14, 18, 15, 16, 12, -19, -44, 30,
    -11, 17, -11, -32, -12, -13, -28, 22,
    -9, 2, -6, 16, 14, -7, 12, -3,
    -27, 29, -12, -11, 6, -1, 25, 9,
    -18, 8, -14, -15, 23, -33, -11, 16,
    0, 48, 17, 24, -4, -16, -30, -22,
    -14, 37, -2, -29, -5, 1, -9, -25,
    -18, -20, -4, 34, -4, -26, 0, -27,
    20, -5, 8, -12, 15, 24, -43, -21,
    -6, -29, 12, 21, -22, 12, -12, -3,
    -24, 13, -27, -18, 45, -8, -14, 19,
    -14, -1, -33, 32, 22, -4, -4, -23,
    2, 22, -22, 0, -3, 11, -28, -9,
    -9, 4, 36, -20, 13, 16, -15, 8,
    9, -36, -8, 1, 0, -2, 15, 8,
    19, 20, -26, -28, 2, -8, -2, 1,
    31, 15, -12, -19, 41, -16, -4, 7,
    -19, 28, 5, 31, 9, -18, 12, 40,
    -53, -23, 5, 15, 14, 19, 29, -6,
    -1, -30, -4, -13, 60, 45, -1, 9,
    18, -29, -5, -15, -4, -19, -1, 4,
    11, -14, 29, -5, 47, 9, 12, 48,
    -17, -8, 11, 6, -1, 15, -23, 2,
    -9, -7, 30, 2, 6, 23, -12, 22,
    -23, -33, -2, -15, 12, 12, -15, 13,
    -26, 38, -4, -27, -16, -22, 10, -3,
    10, -3, 0, 25, 4, -4, -8, -2,
    12, 28, 20, -18, 1, -4, -14, -15,
    3, 3, -6, -12, 14, -10, -5, -3,
    29, -20, -7, 10, -2, 3, 17, -25,
    26, -20, -10, 9, 2, 22, -9, 1,
    45, 41, -13, -10, -21, 22, 22, 5,
    23, 11, -8, 21, 10, 11, 0, 8,
    9, -30, -38, 20, 41, -6, -18, -2,
    1, -10, 0, 26, -16, 44, 10, 7,
    25, -31, 32, 3, -15, 1, 25, 15,
    18, 5, 13, -51, 2, 30, 32, -22,
    -21, 0, -7, -34, 18, 2, 41, -23,
    6, 5, -5, 7, -22, 17, 3, 21,
    -31, -20, 4, 34, -14, -11, 23, -5,
    -11, -2, 7, 20, -27, 4, 26, -1,
    26, -9, -8, 0, -4, 13, 31, -18,
    -23, 4, -30, -18, 21, -16, -20, -37,
    18, 3, -29, 28, 24, 15, -9, 21,
    22, 17, 22, 8, -5, -29, 17, -9,
    -10, -34, 0, -4, 4, -10, -6, 8,
    24, 14, -23, 25, -20, -3, -16, -12,
    -7, -31, 21, 7, 3, -16, -6, 8,
    3, -10, 12, -25, 17, -4, -22, 9,
    -15, -12, 5, -23, 5, -18, 31, 19,
    49, 9, -2, -1, 14, -11, 36, -3,
    3, -2, 55, 6, 8, -4, -21, 27,
    -13, 30, 6, -3, -38, 17, 35, 32,
    -10, 5, -22, -14, 22, -10, 1, -27,
    6, -11, 11, 9, -6, 23, -29, -20,
    23, -45, 17, 15, -9, 4, 6, 16,
    -33, 29, -10, 13, 0, -17, -4, 7,
    1, 3, 25, -18, -3, 15, -7, 18,
    9, 15, 1, -18, 12, 25, 17, -5,
    -11, -3, -6, -7, 8, -31, -9, 19,
    12, 3, 10, -25, 21, 13, -24, 11,
    -7, -7, 3, 4, 3, 24, -17, 32,
    27, -37, 1, 4, 0, -11, 18, -10,
    -10, 15, 4, -27, -33, 3, 18, 7,
    -19, -13, 8, -32, -12, -30, 12, 22,
    16, -2, -4, 15, -3, 5, 2, -4,
    20, 11, -6, -25, -7, 14, 9, -10,
    6, 26, -9, -1, 10, 13, 5, 2,
    -33, -3, -43, -32, 29, -5, 5, -15,
    -6, 0, 22, 3, 0, 2, -9, 23,
    1, 27, -7, 11, -2, -2, 30, 10,
    26, 25, -1, 9, 1, -17, -6, -1,
    -5, -11, 7, -12, -19, 4, 8, 4,
    -3, -12, 31, -21, -13, 23, -15, -35,
    18, 20, -5, -11, 18, 9, 2, -7,
    -18, -35, 0, -1, -2, -7, -25, 1,
    3, -27, -8, -14, 43, -9, 47, 10,
    -41, -6, 13, 1, -12, 0, 13, -14,
    8, 33, -8, 15, -7, -3, -5, 4,
    6, -24, -63, 42, 0, -1, 6, -12,
    -9, 1, -15, 43, -17, -24, 22, -8,
    -30, -40, -2, 5, -14, 1, -15, 2,
    22, 15, 12, -27, 31, 5, 13, -2,
    -8, -20, -22, 50, 0, -5, 14, -7,
    -6, -31, -32, 23, -43, -16, -18, -30,
    1, 17, 30, 18, -3, -9, -9, -11,
    18, 6, -48, 9, -1, 16, -8, 10,
    -13, -35, -19, -11, 26, -19, -27, -3,
    6, -25, 27, 15, 11, 24, 27, 5,
    2, 17, -23, 9, -39, 17, 15, -36,
    21, -15, -17, 12, -16, -7, -7, -6,
    19, 17, -2, 25, 11, 23, -2, 15,
    -34, 19, 2, 5, -18, -18, -11, -22,
    -12, -17, 0, -9, 35, -2, -4, -9,
    -18, 9, -16, 13, 27, -7, 5, 3,
    -33, 22, -8, 14, 4, -7, -1, -9,
    -12, 22, -3, -12, -10, -1, 30, -32,
    -8, -40, -11, 24, 34, 25, 1, -16,
    25, -17, 17, 15, -5, 5, 0, 37,
    -9, 22, 0, 12, -2, 33, 3, 10,
    -13, 31, -22, -5, -48, -8, 6, 8,
    -12, -21, 15, 21, -38, 24, -34, -3,
    27, 5, -12, 14, 5, -17, 1, 13,
    -11, -20, -26, -3, -13, -27, -8, -13,
    2, 13, 8, 4, 22, -37, -25, 34,
    11, -3, 18, -9, -22, 5, -21, -31,
    3, -13, -13, -33, 20, -22, -20, -14,
    -31, 12, 41, 34, -2, -18, -4, 20,
    -5, 12, -21, 22, -1, 7, 12, -34,
    6, -4, -1, 9, -25, 35, -8, -5,
    -35, -13, -20, 6, 19, 10, 13, 18,
    25, 53, -19, 35, -4, 55, 41, -18,
    23, 5, 21, 42, 6, -12, 8, 3,
    -15, 3, 22, -3, -18, 9, 33, -11,
    -2, -1, 15, -2, 24, -19, -12, 33,
    -20, 44, -7, 26, 9, 6, 0, 29,
    12, 3, -5, 13, -1, -2, -8, -6,
    5, -1, -4, 0, 3, -1, 28, 18,
    -15, -8, -3, -9, 1, 15, -5, -33,
    -17, -23, -12, -7, 37, 16, 5, 5,
    1, 5, -9, -25, 3, 8, -20, -63,
    -26, 2, -22, -37, 11, 1, 16, 31,
    5, 24, -12, -15, -4, -7, 25, 13,
    48, 6, 0, -21, 6, -19, 14, -8,
    34, 18, 14, -9, -8, 17, 4, -15,
    29, -14, 4, 1, -53, -2, -4, -5,
    14, 20, 6, 12, 27, 9, 38, 25,
    19, -19, -1, -2, -4, 25, 12, -40,
    0, 9, -15, 32, 24, -13, -1, 3,
    16, -12, -23, -9, 17, 30, -52, 17,
    18, 2, 0, 28, 13, -41, -3, -15,
    6, -32, -12, 9, 28, -9, 8, 14,
    18, -7, 8, -50, -25, -5, 26, -30,
    -1, 37, -10, 9, 15, -8, 30, 70,
    -4, -1, -26, 1, 42, 17, -51, -1,
    16, -18, 31, -2, 19, -13, 2, -41,
    15, 4, 17, 26, 0, 27, 20, 2,
    23, -16, -58, 0, -22, -18, 23, 16,
    5, 2, -10, -27, -23, 4, -13, -17,
    -28, -3, 13, 16, 36, -7, 22, 36,
    3, 33, 5, -27, 15, -25, 33, -24,
    4, 7, -66, 4, -6, 14, 64, 2,
    15, -30, -10, -15, 20, 35, -11, -8,
    -37, -27, -1, -24, 14, -7, 9, -21,
    -39, -36, 2, -6, 9, 2, -18, 14,
    20, -6, 14, -2, -13, 21, 11, -28,
    -11, 23, 4, -7, 44, 18, -15, -11,
    -9, 4, -6, -14, 28, 5, -4, 26,
    17, 35, 14, -23, 13, -56, -29, -17,
    21, 35, 18, 41, 72, 57, 34, -4,
    -15, -3, -14, -6, 8, 35, -32, 20,
    -6, -20, 23, -18, 14, -4, 15, 26,
    -13, -22, 5, -26, 5, -16, -5, 31,
    -20, 13, 13, -9, -16, -6, 35, -2,
    7, 5, -2, -10, 23, 4, 8, -23,
    1, 4, -29, 1, -9, 2, -2, 16,
    8, 5, -17, -34, 12, 6, 6, -2,
    7, -20, -2, -8, 9, -12, 22, 12,
    25, -18, -7, 8, -24, -13, 28, -1,
    -40, 14, 23, -23, -2, 13, 1, -7,
    -14, -20, 15, -12, 29, -35, 31, -2,
    20, 0, -18, 19, -42, 12, -64, 11,
    -20, 5, -21, 4, -8, 37, 41, -22,
    -5, -17, -15, -13, 3, 5, 0, 6,
    -8, -11, 8, 12, 14, 19, 23, -32,
    13, -4, -28, 27, -27, -24, 13, 8,
    -4, -19, 13, -2, 17, -11, -12, 4,
    22, 20, 0, 30, -33, -16, 5, 22,
    45, 1, -8, -34, 27, 26, 36, 30,
    -23, 12, -5, 27, -37, 7, -8, 28,
    -11, 22, 6, 9, 16, 57, 8, 6,
    0, -5, -32, 9, 32, 11, 4, -28,
    -26, 1, 13, 24, 5, 12, -7, -3,
    -3, 0, -9, 5, 33, -8, -9, 1,
    -4, 11, -7, 9, -40, 26, -20, 27,
    2, -43, 2, -43, -18, 5, -14, 17,
    -46, -15, -3, 16, 3, -2, -11, 9,
    -13, -4, 20, -13, 49, -5, -27, 6,
    53, 25, 29, 14, -5, -1, 30, 11,
    -29, 25, 19, 7, -17, -9, -16, -7,
    0, 7, 20, 44, -16, 2, -33, 1,
    34, -11, 41, 17, 15, -20, -9, -18,
    9, -14, 6, 2, 8, 58, -11, -16,
    7, -9, 4, 0, -35, -11, 1, 12,
    3, -51, 17, 10, 18, -45, 1, 12,
    1, 32, 28, 7, -76, -21, 15, 22,
    5, -8, -7, -13, 23, 36, 5, 49,
    27, 18, -13, -38, 21, -4, -24, -13,
    -15, -13, 18, -24, 15, -9, -39, 19,
    -10, -18, 12, -24, 2, -39, -18, -1,
    -6, -12, -3, 2, 34, 4, 33, -31,
    -4, 12, -16, -8, -11, 8, 3, 0,
    -12, -23, 7, 49, -64, -18, 8, 18,
    5, 21, 14, -32, -23, -16, 3, 14,
    36, 1, 7, -11, 10, -41, -11, -21,
    15, 14, 40, 18, 19, -26, 4, -45,
    -40, 36, -10, -14, 5, 2, 8, 34,
    47, 3, -24, -33, 38, -50, 16, -46,
    7, -5, 27, 15, -74, -3, 10, 55,
    -28, 13, -25, -33, -5, -25, -38, 27,
    3, 4, 3, 43, -8, 16, 0, 12,
    21, -5, 8, -11, -29, -22, 20, 7,
    -3, 6, -12, -3, 26, 12, -30, -1,
    14, -9, -16, -19, -1, 9, 3, 4,
    3, -2, -11, -20, 36, -3, 13, 5,
    -8, -32, 9, 1, -48, 10, -40, -2,
    10, 16, 3, 6, 4, 28, 46, -4,
    -32, -5, -49, 44, -17, 1, -17, -10,
    -39, 13, 29, -34, -6, -13, -6, 0,
    -22, -21, 5, -33, -14, -2, -2, 7,
    2, 12, 1, -13, -32, -46, 39, -72,
    2, 21, -33, 15, -6, -23, -8, 4,
    -33, -5, -25, 39, -18, 22, 11, 25,
    6, -31, -13, -3, 16, -21, 12, 17,
    14, -9, -26, 20, -6, 19, 41, -4,
    -1, 8, 26, -34, -1, 16, 0, 29,
    -1, 19, 5, 7, -7, -8, 37, -39,
    -31, 14, -12, 6, 20, 31, -20, 69,
    34, 16, -17, 2, 25, 2, 4, 2,
    9, 1, -5, 14, 3, -12, 6, 13,
    -2, 30, 32, 3, 2, 2, -8, -3,
    2, 13, -20, -9, 40, 3, 8, -15,
    11, -12, 12, -2, 13, -7, 20, 20,
    -1, 6, 17, 15, 27, 30, -11, 21,
    -18, 27, 4, 3, -22, 35, -29, -27,
    6, -30, 22, 4, 4, -8, 16, -2,
    29, -17, 3, 5, -11, -31, -32, -19,
    -13, 26, 17, 26, -9, 12, -28, -7,
    1, 13, 46, 2, 1, 2, 30, 14,
    -12, 5, -11, 11, 12, 8, -43, -6,
    7, 1, -5, -5, 10, 2, -9, 3,
    -43, -34, -16, -9, -14, -15, -8, 9,
    -2, 12, 44, -3, 59, -20, 10, -7,
    7, -2, -11, -33, -11, 21, -33, 11,
    15, 5, 8, -11, 3, 4, 24, -15,
    0, -3, 28, 52, 17, 2, -7, 14,
    -7, 2, -1, 3, 13, 4, 0, -6,
    -11, 8, -5, -6, 22, 9, 26, 14,
    3, 14, -19, -1, -18, -22, -12, -18,
    -21, 6, -5, -25, 13, 33, 27, 10,
    -22, -20, -40, 6, 3, 15, -4, -27,
    21, -1, 33, 9, -9, 33, -19, -65,
    3, -12, -4, 5, -30, -41, 23, 36,
    -33, 25, 0, -4, -16, -4, 15, 1,
    35, 6, 0, 14, -18, 37, -17, 9,
    9, 22, -2, -16, 9, -16, 38, -14,
    3, 5, 28, -21, -8, 24, 17, -29,
    25, -2, 15, 5, 2, -5, -59, -2,
    33, 11, -9, 12, -2, -10, -30, 54,
    -13, 4, 29, 90, -4, -17, 37, -55,
    -21, -16, -33, 1, -50, -27, -25, 45,
    -22, -19, 40, -46, 10, -30, 5, -5,
    -66, -8, 44, -49, 22, 51, -29, -10,
    26, 23, 8, -14, 2, 71, 11, -4,
    15, 11, -16, -31, 10, 22, -1, 14,
    -49, -23, -35, 48, -21, 8, -29, 39,
    3, 11, -7, 4, -8, 24, 16, 85,
    5, -10, 70, 8, 24, 10, 57, 4,
    23, 33, -3, 6, -10, 23, -4, 36,
    40, -32, 2, 13, 4, -4, -6, -3,
    24, -16, -30, -1, 8, 50, -14, 11,
    15, 46, 14, -41, 14, 40, 1, -75,
    -30, -50, -60, -13, 5, 19, 49, 80,
    19, -39, 37, -14, -56, 26, 33, 33,
    24, -51, 42, -38, 5, 7, -5, 0,
    37, -11, 17, 18, 4, 10, 36, 30,
    22, 15, 58, -13, 1, 70, 28, 29,
    8, -6, 41, 15, -9, 31, 11, -10,
    -15, 48, -4, 0, 52, -59, 37, -19,
    50, -79, -36, -14, 28, -39, 42, -32,
    0, -1, 11, -20, -53, -37, 21, 9,
    8, 8, -3, -27, -36, -22, -2, 33,
    45, -23, -7, -19, 3, -9, -14, -43,
    29, 5, -13, -23, -15, 34, 2, 53,
    41, -1, -24, -21, 59, 4, 42, -15,
    -30, 52, -47, 61, -63, 3, 4, 9,
    31, 12, -6, 11, 42, -33, -26, 72,
    5, 11, 11, 30, -10, -43, 26, -17,
    -2, -3, 10, 24, -44, -84, 17, -8,
    0, -5, -53, 19, 2, 9, -27, -31,
    -16, 76, 89, 40, 27, 19, 43, -38,
    -11, 40, 22, 8, 8, -59, -47, 13,
    24, 9, 24, -35, 41, 16, -28, 20,
    -33, -35, 10, -22, 6, 17, 3, -4,
    3, -5, -5, -5, 18, 26, -36, 6,
    7, -35, -39, 12, 6, 11, 13, -17,
    8, -1, 3, 0, 64, 4, -10, -2,
    -56, 47, 22, -40, -14, -35, -9, 24,
    -18, 34, -38, -6, -13, 10, 19, -10,
    -26, 2, -17, -37, -37, -63, 41, 39,
    18, 21, -57, -19, 23, -21, 77, -73,
    -15, 39, 17, 5, 18, -21, 53, -7,
    8, -7, -6, 7, -10, 40, -2, 37,
    79, 3, -31, 33, 30, -10, -18, -32,
    -32, -18, -2, 64, -15, -42, 44, -14,
    48, -17, -17, -2, 14, -7, -11, -114,
    29, -13, 31, 19, -2, 20, 3, 17,
    -39, 26, -3, 35, 24, 16, -10, -50,
    28, -12, 12, 22, 29, 3, -6, 29,
    -13, 24, -1, 5, -77, -52, 39, 0,
    16, -4, -8, -15, -56, 1, -16, -4,
    24, 23, 9, 7, 22, -49, 77, -36,
    19, -16, 9, -27, 74, 20, -31, -44,
    -32, 29, 30, 3, -18, -7, 39, -1,
    -8, -45, 22, -15, 18, 41, 27, -27,
    9, -24, 7, -5, 13, -27, -15, 46,
    94, 14, -47, -18, -27, 20, -50, 25,
    28, 15, -62, -20, -98, 25, -16, 31,
    14, -1, -67, -14, 59, 16, 23, -32,
    30, -70, 12, -28, -10, -18, -12, 10,
    -6, 40, -1, -7, 4, -60, 37, -9,
    -56, -1, -35, -11, -5, -5, 36, 0,
    -30, 50, 15, -10, -19, 17, 18, 16,
    -1, 109, 38, -12, 127, -17, -1, 15,
    7, -37, -21, -12, 24, -45, -11, -63,
    73, -17, 22, -2, 58, 37, -6, 28,
    -29, -12, 21, 48, -45, -14, -18, 26,
    -103, -26, -6, -39, -14, -1, -34, -3,
    -31, -3, 4, 0, 12, -30, 5, -5,
    45, 3, -1, 26, 48, -15, 2, 30,
    34, -41, 17, 5, -96, -14, 6, -17,
    -5, 6, -3, 8, 34, -4, 10, 5,
    20, 11, 21, -16, -18, 69, 16, 16,
    11, -24, 45, -1, 1, -16, -28, 10,
    45, -51, 32, -40, 16, 43, -10, 28,
    -27, -48, -34, 13, -44, -4, -3, 62,
    25, -28, 38, -3, 8, -27, 13, -45,
    -1, -3, -22, 12, 9, 10, 6, -41,
    -23, -20, -30, 20, -41, -3, -18, -30,
    36, -10, -21, 15, 63, -36, 59, 66,
    -39, 8, -13, -11, 32, -13, -3, -10,
    -32, 10, -40, -30, 46, -38, 6, -1,
    -25, -35, 33, -5, 25, -14, -27, 4,
    -11, 25, -59, 9, -2, 28, 47, -16,
    -11, -30, 13, 27, -17, -76, 6, 2,
    43, 14, 45, -30, 21, -20, 9, 16,
    -52, -52, 77, -17, 19, 6, -29, 40,
    -21, 9, -27, 2, -37, 46, 10, 6,
    34, -28, 3, 12, -5, 42, -11, 49,
    -33, 45, 70, 8, 2, -14, -6, 34,
    3, -14, -1, -57, -1, 34, 105, -33,
    62, -9, 9, -62, 17, 26, 2, -18,
    28, 10, -22, 4, 18, 24, -24, 0,
    28, -8, 11, 14, -1, -13, 59, 15,
    37, 24, 21, 29, -35, -17, 39, -9,
    7, 19, 54, -6, -5, 8, 25, -5,
    66, 13, 3, 8, -27, 26, 38, -2,
    44, -28, -16, 13, -20, 3, -23, 18,
    10, -21, -5, -16, -17, -14, -16, -3,
    -12, -1, 0, 16, 1, -12, 5, 1,
    29, -21, 0, 17, -34, -47, -13, -12,
    28, 31, 10, 28, -31, -25, -11, -1,
    -5, 54, 1, 10, 2, -2, -51, -78,
    69, 0, 22, 19, -19, 10, -5, 87,
    5, -3, -14, -13, -45, -56, 69, 45,
    -1, -28, -48, -32, -26, -26, 57, -13,
    52, -12, 23, -39, 2, -2, -17, 19,
    -30, 22, -58, 5, -13, -60, 7, 1,
    -41, 3, 5, -20, 15, 28, -10, -9,
    -99, -23, 42, 22, -3, 10, 17, 3,
    -49, -24, 72, -25, 66, 32, 28, 14,
    -5, 12, -18, -17, 1, 38, 7, 47,
    23, -19, -19, -8, -21, -3, 35, 22,
    20, 10, -40, -32, 9, 11, -8, -49,
    1, -16, -34, -6, 13, 19, -19, 6,
    -11, -10, -12, 42, 12, 7, -13, 67,
    49, 80, 7, -22, 18, -14, -10, -34,
    -10, -27, -89, -40, -40, -52, -20, 4,
    -8, 7, -52, 5, -37, 49, 12, 10,
    17, -8, -19, 53, 11, -83, -89, 16,
    -10, 25, -9, 17, -12, 55, -2, -15,
    -32, -9, -29, -3, 26, 46, -28, -16,
    12, -45, -29, 11, 2, 15, -43, -6,
    15, 74, -37, -11, -28, 28, -66, -1,
    -1, -10, 9, 2, 18, -29, 2, -13,
    7, 5, 17, 5, -17, -16, -24, -14,
    2, 31, -3, 0, 6, 14, 11, 9,
    4, 8, 29, -3, -15, -15, 15, 2,
    5, -10, -22, -9, -34, 22, 19, -31,
    -9, 15, 25, 36, -23, 8, -28, -8,
    -11, -19, 20, -18, -36, -12, 23, -5,
    -9, -3, 5, -17, -18, 3, -4, 10,
    0, -1, 5, -5, -23, -7, 28, -11,
    16, -7, -20, 18, -32, 11, 12, 1,
    34, -45, 16, 7, -45, -6, 3, 4,
    1, 1, -15, -16, -2, 13, 15, 12,
    -5, 8, 5, 3, 15, -27, 13, 40,
    -2, 22, 0, 10, 15, -28, 15, 2,
    10, -9, -45, 0, -20, 6, -8, -11,
    20, 4, 17, 34, 5, 9, 2, 19,
    2, -1, 6, 5, -3, -10, -36, 20,
    -1, -15, 17, -42, -2, 24, 46, -34,
    -29, -35, 0, -3, -12, -17, -34, 21,
    8, 18, 18, -17, 9, 31, -1, -1,
    -9, -3, -2, 0, -25, 5, -10, 17,
    16, -21, -48, -5, -18, 0, 10, -10,
    10, -20, 0, -34, 12, 5, -3, 4,
    -30, 18, -7, -9, -11, 5, -1, -6,
    -9, 5, 4, 2, 31, 20, -24, 36,
    31, 2, -6, 3, -20, 39, 2, -6,
    -3, -14, -3, 5, 5, 17, -18, -6,
    -13, -15, 3, 18, -11, -3, 15, -9,
    -6, -2, 12, -5, 7, 24, -35, 43,
    -5, -18, -1, 5, -35, -10, -16, 23,
    33, -15, 35, 16, 22, -9, 8, 3,
    -22, 15, -12, -22, -43, 24, 12, 12,
    4, -3, 21, 8, -26, 55, 2, -19,
    12, -39, 40, -4, -6, -22, -42, 41,
    -24, -49, -19, 34, -15, -6, 10, 5,
    -27, 1, 12, 16, -2, -1, 23, 5,
    -7, 9, -10, 4, 20, 4, 28, -25,
    -15, 5, 6, -31, 23, 29, 19, 20,
    13, 3, -38, -36, -17, 24, -7, -3,
    7, -14, 7, 12, 13, 36, -8, -2,
    8, -12, 1, 3, -23, -20, -2, 18,
    12, 32, 18, 1, -25, -27, 8, 16,
    10, -14, 54, 4, 15, 4, -9, -24,
    8, 3, 39, 10, 6, 2, -6, -4,
    10, 19, -5, -8, -6, -43, -18, 6,
    0, 6, 8, 9, 16, 21, 19, 19,
    1, 2, -2, 7, 21, 1, 7, 41,
    -17, 12, 14, 18, -3, -5, 0, 1,
    4, -2, 7, 1, -20, -45, -2, 25,
    11, 11, 7, -32, -14, -7, -28, 0,
    -5, -33, -5, 7, -1, 5, 10, 1,
    30, -4, -9, -19, -4, -4, 6, 40,
    -5, -13, 5, -2, 32, -10, -42, -14,
    -12, 9, 23, 29, 3, -1, -17, -16,
    -18, 22, -1, -17, -5, 24, -6, 0,
    1, 7, 4, 0, -12, -5, 4, 8,
    2, -4, 4, -6, -29, 25, -33, -16,
    28, -13, -11, -25, 7, -14, -21, 31,
    -10, -34, 28, -2, 7, -6, -6, -16,
    27, 5, 5, 3, 6, -9, 13, -4,
    3, -3, -7, 1, -8, 4, -28, 3,
    -1, 1, -14, -16, 10, -26, -32, -1,
    -19, 34, -4, 18, 40, 12, 6, -17,
    -4, -4, -11, -2, 13, -14, -3, 4,
    -11, -4, 1, -9, 33, -78, 43, 10,
    7, -13, -22, 10, 26, -53, -21, -13,
    55, 18, -19, -2, -22, 12, 2, -18,
    36, 24, 3, -1, -1, -8, -2, -1,
    1, -5, -8, -9, -25, 18, 22, -1,
    -17, 14, -4, -14, -33, -13, -6, -35,
    -21, -14, 22, -3, -7, 34, -29, 9,
    8, 2, 8, -1, 8, -32, 11, 1,
    -6, 6, 3, -2, -15, -10, -11, 1,
    20, 43, -1, -34, 3, -31, 0, 26,
    35, -4, -16, 37, 8, -13, -2, 2,
    -11, 21, -10, 26, -25, 15, -3, 17,
    0, 11, 3, 3, 0, -44, -41, 10,
    1, 21, -25, -22, 34, 10, -19, -13,
    20, 16, 29, -28, -19, 6, 10, -15,
    -3, -7, 9, -5, -4, 30, 24, -12,
    11, -5, 2, -1, -1, -27, 1, -30,
    -21, -45, 25, 17, -25, -21, -32, 9,
    -41, -5, 24, 7, 13, 9, 21, 18,
    3, 11, 6, 0, 5, 18, -19, 5,
    -5, -1, -17, 28, -4, 2, 14, 3,
    -13, -36, 24, 11, -12, 15, 20, 13,
    39, 22, 63, -43, -17, -12, -19, -2,
    7, -8, 46, -37, 0, 17, 20, -1,
    -11, -10, 9, 5, 14, 5, 15, 27,
    -18, -40, -15, 18, 23, 26, 4, -15,
    20, 6, -33, -43, -17, -10, -13, -11,
    -3, -9, 16, -25, 2, 2, 8, -9,
    8, -4, -7, 8, 10, -21, 9, -39,
    -21, -33, -7, 47, -7, 44, 17, -30,
    42, 13, 3, 61, 19, 1, -28, -10,
    -41, -7, 13, -12, 0, -13, 4, 7,
    -11, 8, 7, -9, 0, 15, 4, -21,
    28, 3, -4, 10, -27, -16, -2, -12,
    -4, -31, -13, 29, 1, 13, 21, 26,
    17, -8, 1, 5, -21, -4, 6, -6,
    -1, 17, 7, -3, 32, -25, 34, 7,
    -4, 19, -30, -7, 10, -11, 13, 9,
    40, 12, 20, -2, -19, -9, -16, -11,
    -7, 0, -23, 33, 13, 5, 6, 0,
    -5, 7, 2, 4, -30, -4, -3, 12,
    7, 13, -51, -9, -20, -1, -6, 16,
    18, 28, 4, -10, 15, 18, 5, 32,
    -21, -16, 14, 23, 19, 5, -7, 14,
    0, 9, -8, 3, 12, 1, 7, -7,
    -19, -32, -6, 3, 12, 6, 6, 3,
    -12, 10, -19, 10, -28, -30, -2, 24,
    -8, -12, 12, -21, 3, -1, 0, 6,
    -2, 10, 4, 0, -6, -2, 4, 9,
    -25, -38, 0, 17, -7, 29, 36, -16,
    -34, 7, -31, -38, 16, 10, 26, 20,
    -26, -10, 22, -13, 10, 22, -5, -15,
    3, 2, -12, 6, -3, -14, 7, -3,
    21, -13, -26, -11, 37, 8, -8, -31,
    -2, 8, 27, 16, -6, -5, -6, -6,
    -2, -9, 7, -5, -8, -12, 9, -17,
    1, 1, -4, -4, -3, -8, 19, -15,
    23, -16, 2, 19, 4, -7, -40, 13,
    -70, -59, 34, 20, 13, 2, 20, 4,
    2, -13, -17, -22, 9, 2, -10, -4,
    6, 21, -19, 15, -21, 2, 38, 5,
    -4, 24, 14, 13, 7, -14, -18, -13,
    19, -7, 30, -2, 10, 14, 2, 2,
    -11, -12, 7, -2, -3, -8, 11, -8,
    -24, -10, 8, 5, 5, -8, -63, 0,
    -39, -10, -23, 36, -32, -7, 48, 2,
    38, 43, 38, -37, -18, -1, -24, 1,
    3, 16, 3, -5, -1, 5, 10, -8,
    -26, 5, -4, -11, -19, 17, 7, -13,
    -30, -16, -13, 36, -45, -18, -13, -19,
    7, -21, 52, -11, 29, 0, -5, -29,
    -17, -36, 23, -37, 23, 11, 3, 13,
    12, -2, -10, -3, -21, -26, 33, -22,
    4, 8, -47, 26, 2, -8, 80, -19,
    0, -54, 7, 24, -16, 1, 56, 23,
    -3, -1, -16, -7, 4, 8, 4, -13,
    -7, -12, 50, -31, 24, -13, 43, 38,
    25, 70, 17, 4, 15, 39, 20, 49,
    49, 18, 8, -19, -16, 3, -2, -27,
    22, -30, 23, 7, -2, -5, -11, 16,
    -4, 1, -22, 4, -2, -15, 0, 6,
    2, 4, 42, -40, -15, -1, -47, 9,
    -13, -30, -12, -3, 26, -13, 26, 30,
    -13, 20, 48, -23, 5, 31, -26, -15,
    8, 7, 10, -15, -7, 10, 8, -2,
    -7, -11, -55, 0, -52, 30, 4, 35,
    9, -53, -66, -1, -34, 39, 4, 14,
    -21, -28, 0, -3, -3, 18, -2, 9,
    -4, 3, -8, -9, -26, -3, -19, 25,
    22, -20, 10, -18, -21, -32, 22, 10,
    -45, 28, -9, -39, 3, 6, -9, -10,
    -2, -9, 10, 8, -4, -12, 37, -3,
    -10, -23, 46, -23, 8, 10, -24, 25,
    -22, -19, 29, 10, 3, 3, 51, -4,
    40, -37, -37, 0, 61, -1, 19, 19,
    -12, -35, -3, -15, -24, 15, -19, -7,
    0, 1, -15, 16, -3, -17, -12, -3,
    28, 13, -31, 28, -15, 26, 16, -8,
    5, 34, -1, 12, -14, -9, -61, -4,
    -29, 4, -25, 8, -11, -1, 24, 12,
    0, 2, -40, -3, 22, -14, 15, -58,
    -9, 3, -16, -24, -3, 9, 1, -8,
    0, -43, -18, -35, -10, 24, -18, 29,
    19, -7, -25, -1, 17, 22, -14, 5,
    17, -5, 11, 28, -12, 31, 15, 26,
    -62, 9, 17, 63, -28, 20, -8, 33,
    -7, -21, 24, 17, 34, -28, -12, -21,
    30, -17, 33, 10, 3, -7, 49, 0,
    4, 21, 4, -3, 20, -33, -19, 43,
    9, 11, -21, 30, 18, -3, 12, -44,
    10, 19, 2, -28, 7, -3, 6, 18,
    -21, 6, 34, -6, 3, 0, -8, -10,
    12, 32, 15, 5, -12, -4, -5, 30,
    2, 25, -19, 22, -20, -31, 18, 65,
    -2, -78, -23, -3, -9, 10, -2, -7,
    27, -22, -15, -14, 2, 9, -2, 24,
    -7, 4, -16, 1, 16, -12, 0, -49,
    -27, -23, -30, 9, 41, 9, 31, 3,
    29, 23, -24, -41, -38, -15, 10, -2,
    19, 12, 13, -7, -3, -2, 6, 7,
    -4, -12, 25, 25, -34, 49, -76, 6,
    38, -13, -6, -16, 0, -3, -39, 10,
    -47, -19, -11, -11, 4, -12, -5, -10,
    -13, -19, 0, 9, 22, 14, -20, 27,
    21, -1, 3, 10, -24, 2, 2, -3,
    -23, -30, -23, -52, -13, 13, -5, -13,
    -12, -11, 1, 17, 8, -9, 31, 13,
    -42, 13, 5, 3, 14, -17, -18, 1,
    13, -17, -25, -3, 33, -3, -14, 1,
    -24, 53, -41, 6, 49, -61, 31, -25,
    38, -24, 61, -19, -14, 26, 13, -7,
    -34, -5, 1, -12, -7, -22, 0, -13,
    14, -8, -2, -4, -19, 8, 23, -8,
    -11, 2, -14, -7, 4, -6, 25, -6,
    20, 15, -14, 0, 0, 1, -20, -10,
    14, 7, 8, -23, 0, -3, 18, -9,
    -2, 7, 0, 3, -28, -31, -20, -6,
    -10, 16, 21, -19, -16, -51, -7, -13,
    -6, 29, 0, -10, -39, 0, 5, -15,
    -45, -5, -30, 7, -3, 1, 0, -1,
    17, -3, 7, 5, 36, -28, 21, 4,
    21, -1, 19, -44, 39, -45, 8, 1,
    19, 28, 6, 38, 10, 40, 4, 6,
    -20, -14, 15, -21, 1, 17, -4, -8,
    9, 7, 6, 20, -23, -19, 39, -33,
    15, -21, -33, -96, 36, 4, -13, -27,
    36, -50, 37, 37, -35, 18, 18, -14,
    8, 3, -24, 4, -17, 15, -1, 2,
    -10, -10, -23, 23, -4, 0, 35, 17,
    32, -15, -35, 16, -65, 58, 4, -1,
    33, 39, 54, -43, -3, -11, -40, 9,
    -4, 18, 46, -45, -1, 13, 20, -5,
    -1, -42, -29, -11, 34, -38, 15, 22,
    -2, -26, -51, 3, 2, -61, 59, 16,
    18, -39, 15, 13, -13, 24, -20, -40,
    19, -15, -5, -23, 3, -10, -5, -2,
    -4, 3, 1, 11, 4, -37, -18, -7,
    -5, -43, 1, 29, 22, -44, -13, -51,
    31, -32, 13, -48, 0, 11, 16, -10,
    -48, 23, 4, -13, -14, 3, -24, 6,
    -5, -8, -41, 3, -2, -38, 41, 36,
    -8, -14, 4, 19, 38, -30, 3, 97,
    11, 25, 15, -5, 6, -14, -6, 21,
    31, -21, 5, 39, -15, 15, -3, -35,
    -2, 16, 14, -5, 21, -29, 5, -26,
    13, 37, -16, 4, 16, -26, 39, 4,
    24, -1, 39, -8, -2, 29, 1, -11,
    29, -8, -7, 17, 1, -19, 2, -1,
    -21, 2, 13, 8, 15, -12, -5, 17,
    23, -20, -22, -33, -7, -4, -33, 65,
    -10, 7, 11, -17, 5, -6, 17, 4,
    -13, 2, 13, 4, 4, 14, -9, -14,
    10, 6, -11, 8, 28, 14, 14, 11,
    13, -2, 24, 20, 21, 27, 36, 2,
    9, -1, 25, 10, -12, 3, 10, -9,
    24, 51, -18, -41, 8, -6, -23, 2,
    -16, 29, -1, 10, 33, -17, 2, 6,
    30, -11, -1, -33, -18, -17, 17, -20,
    3, -35, 47, 63, 28, 17, -19, -28,
    -15, 5, 20, -14, 19, -11, -34, -14,
    -5, -7, 1, 4, -33, -5, 32, 2,
    0, -5, 39, -19, -17, -14, -7, 1,
    19, 8, -29, 58, -4, -10, 8, 20,
    7, 11, 3, -3, 6, 3, -9, -13,
    8, 4, -13, 24, 16, 3, 4, 16,
    -29, -4, 29, -16, 18, 25, 1, 45,
    -67, -12, 28, 0, 16, -40, 31, 1,
    -8, 16, 14, -4, -5, 1, 31, -15,
    10, -12, -12, 8, -43, 50, -32, -47,
    5, 73, 26, 18, 6, 3, 43, -2,
    -21, 25, 16, 17, 6, -3, 13, 14,
    14, -8, 7, 17, 1, -2, 4, -1,
    -44, -5, 15, 20, -5, -15, -30, 75,
    26, -11, -12, -50, 12, -15, 42, 45,
    -1, 70, 14, 48, 2, 11, 21, 0,
    13, 6, 54, -38, 2, -15, -26, -3,
    -51, 13, 13, -15, 34, 65, -9, 25,
    33, -41, 27, -21, 30, -26, 38, 38,
    9, -3, -1, -13, -2, 3, -21, -25,
    -35, -94, 21, -37, -22, 22, 30, 7,
    7, 6, -6, 6, 7, -19, -25, 2,
    -1, 14, 31, -31, 29, 4, -23, 15,
    -50, -24, 25, 0, -17, 3, 35, 67,
    14, -20, -68, 28, -2, -1, -22, 11,
    -1, -5, 65, -44, 33, 29, -8, 46,
    11, -53, 37, -28, -43, -11, 96, 0,
    42, 1, -19, -25, 38, -4, 7, -71,
    66, -86, 41, -11, 11, -26, 38, 59,
    -2, 18, -38, 13, 43, 61, -15, -32,
    -6, 24, 55, -21, -2, -32, -7, -21,
    -28, 12, 57, -11, 47, 1, -60, 1,
    -8, -2, 57, -27, -6, -42, -48, 7,
    21, 11, -4, -15, 58, -56, -12, 17,
    -70, 34, -16, -29, -42, 12, 17, 1,
    27, 7, -34, -13, 8, -75, 61, 10,
    -32, -5, 57, -11, -3, 52, -23, 6,
    -28, 5, -9, -17, -16, -19, 4, 38,
    -42, 2, -7, 18, 22, -14, 5, 32,
    59, -5, -10, -44, 96, 33, -11, -27,
    60, -82, 13, 8, -21, -41, 26, -6,
    -18, -41, 97, -27, -5, -41, 34, 26,
    -21, -21, 27, 69, -67, 9, -9, -37,
    5, 25, 9, -9, 73, -18, -36, 39,
    1, -21, -19, -50, 74, 55, 4, 49,
    5, 17, -24, 19, -32, -44, -28, -2,
    18, -47, -3, -60, -28, -43, 34, -11,
    17, -49, -37, -26, -15, 56, 31, 48,
    -28, -57, -59, 28, -19, 19, 21, 32,
    4, 5, -37, -20, -9, 23, -42, -25,
    -10, 8, -39, -6, -24, 38, -14, -1,
    8, -20, 23, -42, 2, -16, -15, 18,
    -7, -6, -28, -48, -18, 20, -4, -3,
    18, 6, 23, 87, 28, 77, -31, 10,
    25, -65, -17, -1, 36, -8, 25, 13,
    17, 39, -15, -6, -3, -38, -46, -36,
    -22, -13, 14, 46, -22, 42, 8, 22,
    58, 9, 3, -3, -84, 24, -5, 72,
    -23, 14, -23, -22, -22, 0, 33, 40,
    -5, 39, 25, -33, 30, 17, -5, 57,
    -30, 2, 10, 25, -9, 3, -15, -2,
    29, 100, 8, -12, 22, 58, -4, -26,
    46, -17, -9, -9, 25, 17, -39, -90,
    -50, -1, -41, 23, 6, -5, 46, 15,
    56, -12, -18, -6, 19, -11, -13, 74,
    -6, -6, -38, 0, -13, -4, -51, -9,
    3, 7, 58, -47, -45, 2, -8, 68,
    20, -13, -21, 21, -10, 11, 25, -15,
    2, -31, 22, -14, -4, -15, -14, -29,
    -12, 4, 20, 31, 28, -2, -19, 38,
    41, 18, -42, 29, 41, 13, 30, -83,
    -15, -39, -29, -59, 5, 36, -8, 7,
    -3, -11, -2, 12, 6, -1, -27, 13,
    8, 2, -5, 7, -12, 10, 46, 34,
    -72, -38, 38, 45, -69, 81, 56, 31,
    -2, -28, 11, -22, 96, -43, -22, -23,
    -37, 32, 0, -37, 24, 20, 12, -6,
    39, -5, -59, -7, -4, 51, -49, -6,
    11, -30, 28, 27, -57, 32, -47, 15,
    -15, -10, 9, -16, 35, 27, 50, -24,
    -62, -9, -27, 8, -2, -41, -11, -7,
    36, -13, 5, 3, 16, 8, -17, -30,
    23, 25, -19, 52, 13, 20, 3, 2,
    27, 2, -16, -26, -12, 0, -39, -15,
    -8, 23, 7, -14, 13, -54, 36, -8,
    8, 0, 5, -22, -18, -16, -26, -20,
    -25, 24, 20, 64, 0, -16, 5, 6,
    -53, 78, -5, -4, -36, -12, -11, -25,
    -13, -6, -3, 23, -19, 29, -14, 3,
    17, -28, 18, -19, -122, 110, 24, 12,
    -21, -24, -13, 15, -28, -30, 36, -18,
    5, 37, -30, -18, -17, -41, 34, 66,
    30, 4, 85, -96, 1, 6, 21, 9,
    -3, -3, -10, 49, -47, 40, 36, 40,
    31, 27, -24, 102, 1, 40, 47, 37,
    -33, -32, -27, -45, 8, 12, 0, -4,
    -26, -10, -17, -34, 18, 8, 40, 1,
    -21, 5, -7, 20, 16, 48, 15, 42,
    -28, -4, -6, 22, 50, 39, -2, -25,
    -10, -36, 19, -27, 15, -1, -27, 7,
    3, 45, 25, -44, 13, 13, -5, -12,
    -1, -76, -37, -58, -15, 11, 17, -36,
    3, 10, 43, 3, 17, -6, 15, 15,
    -5, 16, -4, -14, 26, 6, -23, -20,
    92, -40, 17, -46, 7, 18, -16, -36,
    13, -25, 23, 23, 7, 68, 4, -24,
    -30, 81, 21, -2, -81, 47, 21, 13,
    42, -6, 13, 22, 50, -4, 11, -66,
    -56, 91, -21, 50, 20, -19, 21, -5,
    -2, -14, -57, 10, 47, -26, 3, 1,
    8, -40, 25, 73, 3, -39, 33, 8,
    61, 29, -11, 38, 26, 9, 24, 6,
    9, -45, 31, 84, -29, -8, -3, 2,
    -9, 31, 17, 4, -8, 15, -67, -7,
    -34, 3, -18, -12, -42, 12, -26, -7,
    58, 27, -42, -2, 14, -9, 28, -7,
    51, -25, -20, 26, 2, -18, -26, 16,
    -43, 0, 3, 11, 91, 36, 32, 17,
    0, 46, 14, -13, -16, 3, -31, 18,
    -9, -29, -17, -38, 22, 83, -7, 43,
    38, 31, -5, -25, 4, -5, 7, 18,
    39, -3, 11, 4, 6, 21, -94, -35,
    25, 15, 17, -45, 9, 12, -26, 22,
    -9, 90, -26, -20, -34, -12, -26, 21,
    0, 16, -21, -53, 17, 19, -2, 1,
    -23, 36, 5, 41, 0, 2, -53, 4,
    9, -11, -30, 37, 3, -9, -55, 0,
    6, -17, 9, 20, -31, 22, 23, -23,
    -8, -2, 48, -43, 19, -12, -16, -26,
    -4, -3, 17, 2, -45, -18, -39, 13,
    18, 14, -37, 37, -40, -9, -26, -10,
    45, 15, 19, 46, -20, -43, 23, 43,
    -25, 26, 8, -8, 19, 3, -11, -36,
    3, 1, -18, 66, 15, -18, 20, 32,
    -3, 30, 51, 11, -39, 36, -25, -26,
    3, 1, 85, -42, -9, -82, -31, 73,
    -68, 8, 17, -19, -23, 57, 69, 13,
    15, -35, 6, 1, -2, 15, -29, 30,
    30, -45, -22, -26, 0, -16, 41, 0,
    13, 49, 7, 45, -16, 30, -11, -4,
    -10, -11, -29, 7, -17, -67, -10, -27,
    5, -7, -22, 16, 37, 2, 13, 10,
    15, -3, -17, 6, 9, 35, -7, -33,
    16, 12, 5, 6, -15, -3, -20, -3,
    16, -8, 23, 15, 17, -5, 25, 5,
    -31, -33, -17, 22, -22, -34, 23, -4,
    -14, -19, 6, -1, -2, -9, 25, -1,
    -12, 3, 0, -5, 9, -15, -14, 10,
    -22, -17, 5, -6, -15, 34, -7, 2,
    15, 2, 15, -16, 4, -3, 8, 3,
    -12, -7, 37, -9, 10, -3, -15, -4,
    2, -7, -14, 11, 15, -3, -13, 8,
    -18, 0, -9, -3, 24, 19, 10, -26,
    -2, 7, 15, -15, 15, 5, 4, -8,
    24, 0, 29, -13, 19, -15, 42, -27,
    -3, 5, -8, -17, -17, 4, -16, -20,
    -5, -5, -24, -17, -11, 6, 8, 11,
    13, -3, 15, -2, 2, -5, 4, 18,
    -5, 18, -2, 19, -21, -7, -11, -18,
    4, -5, -17, -6, 7, 20, -9, 1,
    -9, -21, -12, 14, -3, 7, 21, 5,
    -1, 13, -20, -15, -8, -18, -2, -1,
    5, 21, 27, -10, 10, -66, 13, 9,
    3, -6, -2, -6, 2, -8, -25, 9,
    4, 42, 3, 6, 14, 0, 12, -18,
    -5, 13, 2, 24, -22, -16, -5, -6,
    -1, -28, 8, -5, -9, -12, -1, -33,
    14, -13, 30, 16, -18, -4, -2, -10,
    3, 14, 4, 17, 19, 1, -9, -13,
    0, -24, -41, 44, 5, 20, -5, 9,
    21, -8, -7, 4, -28, -27, -18, 8,
    -4, -9, 4, 5, 4, 23, 8, 26,
    18, -18, 0, 22, -9, -23, -46, -11,
    -8, 21, -32, 45, -21, 6, 2, 24,
    -52, 7, -14, 15, -18, -1, 1, -23,
    81, -2, -6, -8, 4, 17, 1, -17,
    16, -16, -6, -25, -10, -12, 44, -6,
    -18, -9, -3, 8, 9, 18, -12, 3,
    5, -44, 31, -21, 20, 9, 1, -3,
    0, -14, -10, -19, -5, -6, -9, 8,
    15, 15, 8, 9, -4, -14, 12, -5,
    17, 32, -56, -2, -15, -5, -2, 6,
    6, 12, -6, -10, -32, 17, -6, 11,
    12, 3, -14, -3, -2, -31, -21, -8,
    -8, 0, 6, -3, 23, -7, 1, 18,
    -6, 41, 22, 15, 0, -8, 6, -20,
    7, -30, 14, -19, 12, -12, 13, -20,
    9, 12, -11, -2, 7, -13, -7, -6,
    -5, 0, -8, -1, -8, -9, 3, -12,
    -28, -21, -5, -3, -2, -18, -9, 10,
    18, -10, -23, 38, 32, -9, -7, 32,
    20, -7, 4, -12, 9, 10, 11, 11,
    -1, 20, -8, 17, 18, -20, 17, -27,
    15, -12, 13, -10, -4, -6, -2, -7,
    3, -7, -17, 9, 4, -6, -14, -10,
    -3, 5, 2, -21, 17, 8, -10, -6,
    -5, 19, 3, -9, -2, 33, -36, -43,
    -14, -28, 34, 22, -29, -19, 7, -16,
    16, -13, -9, 9, 44, 21, -5, 9,
    12, 8, -3, -3, -16, -21, 3, 30,
    -7, 10, -2, -6, -12, -25, -22, 0,
    -41, 4, -8, -17, -15, -5, -14, -20,
    -22, 32, -10, 7, 3, -16, 8, -2,
    -17, 16, 7, -13, 5, -11, -6, -15,
    -63, 26, -40, 19, -11, -4, 27, 14,
    -4, 17, 26, -20, -12, -22, 9, -13,
    9, -10, -12, -35, -27, -55, -10, -9,
    -1, 9, -21, -80, -16, -4, 7, 0,
    3, 24, 10, -13, 11, -43, 27, 27,
    12, 29, 59, -24, 30, 10, -11, 15,
    3, 2, 33, 9, 24, 3, 15, -31,
    -9, 16, -2, -7, 10, 20, -15, -4,
    -21, 14, -5, -5, -37, -9, 12, 30,
    -8, -16, -18, -13, -9, 25, -6, 8,
    -9, -7, -7, 12, 19, -31, 10, 5,
    8, 4, 0, 2, -7, 2, -14, 3,
    4, 6, -31, 4, -20, 20, -7, 0,
    -34, -27, -31, 22, -18, -7, 39, -5,
    19, 4, -2, -6, 28, 13, 0, -33,
    12, -1, -15, -8, 9, -6, -8, -11,
    -26, -12, -14, -14, -14, 0, 21, -8,
    9, 14, 12, 2, 15, 1, 11, 10,
    12, 46, 33, 19, 16, -22, 20, 37,
    5, -39, -1, 2, -17, 12, -34, -8,
    3, -1, 1, -1, 13, 10, -21, 2,
    -2, -6, 9, 5, 7, 12, -10, 2,
    -7, 16, -20, -17, 2, 5, -6, -5,
    -5, 4, 4, -10, 19, 15, 3, -7,
    -5, -2, -1, -5, 31, -22, 4, 2,
    -3, -5, -22, -17, 11, 3, -22, 36,
    -19, 2, 19, -15, 12, -32, -8, 10,
    8, -5, -11, 16, -28, 11, -3, 16,
    -9, 16, 10, -27, 5, -14, -29, 9,
    21, -1, 13, 34, 4, -6, -1, 5,
    1, -12, -1, 18, -2, 4, 2, -5,
    -6, 9, 5, 8, 5, -18, -20, 13,
    -12, 1, 19, -23, -8, 0, 20, 0,
    -4, -20, 5, -9, 2, -2, -9, -3,
    -7, -20, 15, 5, -15, 11, -10, -6,
    -9, -10, -1, 7, -1, 10, -5, -7,
    -11, 1, 11, -32, 10, 0, 2, -25,
    17, -21, 8, 33, 10, 20, 9, 13,
    -15, 4, 1, 27, -2, -16, 9, 34,
    34, -4, 8, -66, 4, 2, 5, 7,
    -10, -8, 23, -3, 17, -4, -2, 17,
    51, 7, 9, -25, -8, -32, -35, 4,
    -4, -35, 12, 17, -13, -31, 17, 18,
    -11, 7, 11, 7, -3, 14, 10, -21,
    -7, -19, -14, -13, 0, 4, 12, 27,
    8, 17, -42, 3, -6, -9, 9, -16,
    26, 1, 11, -3, -15, 5, 11, -7,
    4, -1, 8, 3, 3, -11, -24, 20,
    12, 16, 1, 15, -53, 20, 25, 0,
    19, 35, 6, 2, 28, 8, -3, -18,
    -16, -17, 5, -1, 41, -17, 18, -16,
    1, 1, 8, 10, -15, 0, -3, 1,
    29, -10, 7, 5, -27, -15, -23, 1,
    22, 7, 41, -15, 10, -5, 2, 23,
    -2, -24, 4, 24, -7, 0, 19, -16,
    7, 13, 2, -9, 6, 8, -2, 11,
    10, -4, -25, 24, -6, 25, -9, 15,
    6, -6, -6, 22, -27, -2, -21, 2,
    4, -9, -9, 11, -1, 12, 33, 13,
    -9, 14, 10, 15, 5, -9, -2, -28,
    -14, 3, 9, -36, 5, 0, 1, 17,
    -3, -2, -3, 13, 7, -5, 20, 28,
    -21, -4, 9, -19, 3, -10, -17, -37,
    14, -5, 1, 6, 20, -22, -4, 9,
    5, -37, 7, -28, -5, -1, -35, 14,
    -10, 2, 22, 34, 35, 7, -30, 8,
    -13, 5, 6, -21, -29, 40, -28, -36,
    17, 9, 5, -6, -10, -3, -19, -16,
    19, -8, -16, 4, -5, -6, -46, -83,
    11, -44, -33, -20, -31, -6, 20, -11,
    -17, -9, 9, -2, 21, -7, 13, -9,
    3, 0, 6, -2, -25, -24, 3, 8,
    -8, -13, 4, 1, 37, 22, 11, 26,
    -22, 2, -11, 9, -1, -1, -2, -31,
    17, 2, 0, -5, 18, -20, 4, -6,
    18, 7, -4, 14, -11, 3, -37, 4,
    -3, 1, 10, -5, 1, -4, 22, 13,
    25, 37, -5, 28, 4, -29, 1, -28,
    20, -42, 18, 34, -13, 6, -5, 14,
    0, -7, -3, -2, 25, -2, 11, -15,
    -1, -32, -8, -19, -5, 14, -3, -3,
    -3, -31, 25, 11, 4, -1, -3, 6,
    25, -18, -13, 27, -19, -1, -49, -44,
    -10, -5, -4, 15, -3, 16, 18, 14,
    -10, -16, -13, 44, 12, -20, 13, -14,
    40, -17, 18, 49, -15, 5, -28, -32,
    -14, 57, 13, -7, 31, -16, 15, 23,
    6, 1, 9, 6, 31, -10, 13, 11,
    -2, 19, 55, 37, 7, -18, -29, 6,
    17, -10, 9, 37, -13, 11, -4, 6,
    14, -29, 30, 1, -20, -30, -6, 1,
    -20, 1, 14, 10, 3, 6, -7, -11,
    -45, 45, -9, 13, -54, 46, 4, -4,
    -15, 34, 44, -2, 1, -3, -17, 56,
    10, 16, 7, -45, 16, 7, 19, 39,
    -6, 12, 1, 1, 1, 23, -11, 15,
    2, -15, -21, -31, -18, -24, -1, 4,
    2, 4, -1, -33, -22, -3, -23, 34,
    -73, -23, -6, -24, -37, -67, -6, -15,
    88, -14, -12, 1, 19, 7, 13, 33,
    11, 27, -8, 5, 10, 37, 12, -6,
    -27, -9, 1, -11, 10, 0, 11, 16,
    -13, -34, 11, 10, 17, 7, 19, 0,
    2, -3, 2, -13, -1, -3, -4, -8,
    18, 22, 7, 27, 42, -12, 15, 1,
    -64, 38, 11, -26, 47, -4, 0, 14,
    -23, 11, -10, -5, 8, -27, -15, -6,
    -8, -11, -6, -4, -41, 6, -49, -7,
    -30, -37, -55, -2, -17, -30, 37, -32,
    -19, 16, 2, 24, 5, -12, 16, -6,
    -9, -7, 11, 16, 0, -40, 3, -11,
    9, 4, -22, -1, 23, 8, -9, -3,
    -13, -7, -15, -23, -1, -2, -31, -11,
    6, 8, 38, -5, -5, -6, -22, 4,
    39, 11, -18, 5, 10, 5, -6, 13,
    3, 15, -1, -18, -15, -5, 3, 8,
    -28, 25, -28, 7, 42, -19, -21, 5,
    15, -8, 7, 25, -23, -6, -27, -16,
    -8, -31, -4, -4, -1, 10, 17, 16,
    -4, -12, 9, 4, -2, -2, -8, -6,
    4, -36, 1, -7, -20, 71, 4, -28,
    5, 13, 30, 22, -9, -20, 5, -6,
    28, -3, -37, 45, 54, -11, 37, 4,
    -9, -9, -5, 7, -41, -9, -19, 35,
    6, 1, -27, 4, -16, 10, 12, 42,
    -19, 10, -8, 21, -45, 1, 5, -18,
    -24, 42, 33, 8, 7, -15, -30, 2,
    7, 8, 5, 2, 27, -3, 24, 30,
    -68, 17, -1, 5, 3, -2, 10, -1,
    17, -13, 7, -19, 7, -21, 0, -7,
    -19, -18, -6, -26, 6, 4, 21, 1,
    3, -13, -16, -60, -24, 0, 13, -4,
    23, -3, -6, -13, 10, 30, 23, 33,
    2, -4, 20, -26, 17, 5, -4, 39,
    5, 19, 46, -6, -3, -19, -8, 4,
    12, 4, 6, -3, 8, 18, -3, -25,
    -2, -15, -4, 7, -14, -3, 3, 12,
    -3, -4, -2, 28, -9, 18, 1, -5,
    17, -13, 3, -17, -5, 5, 30, 25,
    -5, -4, -7, -1, -6, 11, -33, 8,
    19, -11, -5, -28, 20, -21, 4, 21,
    27, 23, -27, 1, -38, -10, 23, 34,
    -2, 46, 14, -5, 36, -1, -20, -17,
    25, 4, 9, -3, 22, -6, 1, -35,
    4, 1, -22, -33, -8, 3, -37, -18,
    -34, -8, 7, 43, 14, 18, 27, 13,
    -3, 57, 11, 2, 0, -7, 1, 2,
    1, -50, -12, 11, 7, 7, -18, 28,
    9, 6, 1, 23, 17, -3, -2, 45,
    -35, -15, -45, -2, -2, -8, 24, 11,
    9, 39, 23, -21, -4, 6, -1, -23,
    3, -6, 20, 11, 5, -18, -1, -14,
    24, -29, 19, -21, 47, -2, 43, -14,
    -13, -6, 20, 57, 8, 7, -21, 2,
    -25, -33, 42, -3, 33, -27, -13, 27,
    0, -1, 3, -6, -8, -1, -17, 17,
    0, 20, -39, -12, 38, 4, -12, -55,
    33, -33, 35, 15, -24, 10, 18, 24,
    -8, 10, -22, 5, -20, 1, 51, 44,
    7, 18, 0, 19, 12, -22, -41, 25,
    32, -25, -1, 7, 8, -31, 31, -25,
    15, 26, -14, -2, -2, -8, 15, -13,
    -11, 6, -7, -17, -11, -14, 23, 13,
    3, 8, -11, -5, 34, -8, 17, 4,
    -5, -29, -26, -30, -40, 5, 16, -20,
    -21, -20, 31, 29, 0, 1, -15, 14,
    -19, -17, -4, 62, -8, 22, 5, 28,
    38, 6, 6, -106, 14, 18, -3, 10,
    -7, -8, 16, -2, 38, -5, 3, 10,
    14, 14, 8, -43, -17, -17, -26, -7,
    -7, -2, -2, 1, 14, -29, 0, -33,
    17, -13, 11, 0, -1, -4, 32, 13,
    -28, -11, -2, -16, -10, 22, 5, 49,
    20, 10, 9, 2, -2, -23, 10, -16,
    -12, -58, 16, -9, -17, 1, 34, 23,
    10, 3, 2, 2, -22, 21, -4, 13,
    -15, 18, 15, 36, -21, 20, 19, -19,
    13, 46, 16, -15, 7, -8, -6, -30,
    16, -22, 17, -6, -18, -14, 4, -32,
    8, 12, -5, -25, -7, 4, 18, 35,
    9, -5, -37, -8, 14, -18, -43, 17,
    -11, -3, -9, 12, 37, -2, 9, -16,
    2, -15, 14, 41, -9, -5, 5, -11,
    4, -14, -5, 1, 9, -2, 12, -6,
    18, -21, 45, 2, 19, 17, 29, 8,
    28, 21, -18, 42, -7, -21, -11, -4,
    15, -6, 6, 10, 18, 2, 36, -44,
    19, -8, -11, -5, -8, 22, -28, -21,
    -42, 23, 6, 26, -13, 30, -28, 38,
    10, 34, 37, 5, 15, -30, -5, 3,
    -22, -4, 16, -1, 23, 2, -7, -29,
    -11, -4, 12, -21, 23, -30, -18, 5,
    5, -18, -7, -16, -33, 31, 20, -8,
    40, -1, 1, -51, 23, 6, 25, -10,
    -4, 8, -15, -27, 9, 45, 47, -32,
    23, 4, -14, 0, -17, -21, -50, -34,
    0, -21, -71, -58, -4, 26, 9, 11,
    -21, -35, 19, -14, -8, -27, 11, -20,
    -9, -14, 5, -16, -43, 21, 58, -11,
    -12, -30, 0, 5, 8, 14, -16, 47,
    11, -40, -45, 41, -41, 14, 1, -37,
    45, -12, -29, -58, -6, -18, -24, -15,
    3, -1, -16, 18, -37, -6, 4, -4,
    -1, -13, -8, -11, -21, -11, -13, 16,
    2, 9, 22, 35, -55, 30, 8, -9,
    16, -48, 75, 2, -8, -16, 2, -3,
    5, -10, 9, 40, -16, 9, -3, -15,
    -17, 6, -13, 7, 41, 4, -1, -39,
    0, -6, -11, 22, 31, 1, 40, -34,
    -1, -16, 52, 38, 26, -17, 21, -4,
    21, 6, -41, 11, -31, 1, -30, 10,
    7, 22, -29, -3, 6, -4, -7, 3,
    25, 35, 86, 27, 29, -51, -15, -30,
    -80, -23, 0, 4, 18, 19, -37, -48,
    -3, 15, 8, 9, -52, 25, -19, 1,
    -11, 13, 9, 8, 26, 30, 12, 14,
    43, -39, -6, -39, 3, -15, 36, -33,
    51, 51, -9, 39, -8, 11, -1, -2,
    -29, -25, 18, -25, 4, -2, 12, 2,
    4, 3, 37, -25, -46, -48, -2, 40,
    14, 7, -6, -29, -8, -20, 3, -86,
    3, -52, -25, -15, -16, -60, -15, 66,
    3, 5, -1, 40, 4, 14, 13, 53,
    -14, 2, 11, 5, 2, 29, -19, -13,
    -56, -41, -25, 28, 15, 75, 11, 13,
    14, -42, 79, 50, -15, 18, 14, 71,
    -83, 30, -4, 8, 19, 40, 35, -5,
    127, -3, 2, 4, -6, -53, -3, 61,
    -15, -4, -56, 0, 9, 12, -69, -46,
    5, 25, 6, -30, -7, 4, -7, 25,
    -17, -41, 19, 19, -17, -12, -8, -16,
    -8, -14, 7, -39, 42, -7, 7, -15,
    -6, 17, 7, 17, 3, -39, 31, 3,
    3, 21, -7, -20, 27, -39, -55, 4,
    -9, 0, 3, -6, 29, 61, -10, -40,
    0, 0, -4, -28, -39, 1, -88, 19,
    2, -14, -22, 14, -28, 33, -34, -15,
    -36, 18, 16, 56, 5, 5, -9, 18,
    -9, -15, 24, 9, -33, 26, -11, 17,
    18, -16, -30, -9, 63, 12, -5, 41,
    31, -14, 28, -1, 34, 33, -4, 74,
    22, -69, 30, -24, -39, 19, -24, -5,
    -2, -16, 2, 75, -6, -21, -6, -14,
    18, 22, -2, 6, -14, 2, -40, -5,
    10, -7, 26, -19, -1, 66, -14, 2,
    19, -35, -9, 26, -11, -7, -46, -37,
    -29, -16, -9, -20, -7, 38, -27, 15,
    24, -14, -11, 7, -62, -42, -41, 28,
    10, -22, 18, -33, 15, 35, 47, 56,
    -41, 16, -48, -53, -55, -45, 33, -14,
    21, 7, -25, 42, -9, -38, 42, -30,
    3, -4, 22, 0, -50, -72, -65, 26,
    -24, -4, -14, 24, 23, -3, 40, 41,
    -86, 16, 1, 6, 4, 3, 3, 0,
    29, 53, -20, -4, -7, -16, 49, -6,
    0, 2, -24, -20, -5, 15, 75, 54,
    -59, 32, 14, 24, 70, -5, 0, -15,
    3, -17, -7, -9, -7, -14, -22, -12,
    -40, -1, 9, -40, -7, -63, -30, -14,
    27, -22, -24, -60, -16, 27, -4, 6,
    2, -35, 57, -20, -40, -33, 0, 13,
    -2, 20, 4, 47, -8, 6, -14, 50,
    11, 27, 29, -44, -19, -17, 14, 7,
    6, 12, -22, -20, 2, 10, 9, -79,
    7, 20, -4, -16, -23, 16, 1, -4,
    -27, -6, 7, -21, 22, 18, 18, -25,
    24, -9, -13, 32, 21, 14, 4, -71,
    -14, 5, 7, -11, 19, 59, -46, -22,
    0, -27, -10, 23, 15, 21, 15, -17,
    19, -41, 11, -21, -18, -1, 23, 19,
    65, 64, 38, 2, -20, 4, -16, 11,
    13, -7, 27, -6, 77, 52, -19, -84,
    14, 77, -41, 65, 11, -22, -15, -64,
    -14, 31, 0, 33, 21, 16, 23, 30,
    9, 61, 2, 4, 66, -43, 19, -9,
    16, -74, 0, -7, -15, 15, 38, 26,
    -6, 12, -31, 5, 6, -44, 2, -1,
    33, -73, 46, -1, 5, -5, 28, -9,
    13, 16, -5, -30, -16, 19, -23, -4,
    -27, -2, -4, 8, 67, -58, 46, -6,
    14, -39, 54, -15, -50, -47, -40, 19,
    -17, 52, 0, -35, -24, 13, -14, -14,
    -5, 5, 19, -8, 22, -24, -49, -80,
    -9, -4, -2, -9, -47, 8, 3, 0,
    17, 7, -8, 16, 37, -33, -15, 21,
    25, -82, -74, -5, 2, -12, 20, 6,
    -33, -11, 40, -6, 3, 3, -23, -50,
    -14, -16, 13, 1, 49, -22, -81, 17,
    28, 49, -3, 43, 16, -1, -3, 17,
    -4, 22, 33, 29, -16, -4, -49, -80,
    -34, -11, -22, -7, 2, -2, -42, 5,
    -2, 13, -1, 8, 67, -51, 45, -11,
    30, -48, 22, -21, 29, 36, -3, 42,
    40, -20, 10, 10, 22, 6, 13, 4,
    -2, -9, -20, 85, 47, -44, 37, 1,
    13, -9, 13, -117, -7, 41, -22, -4,
    -36, 5, 23, -20, 22, -2, 27, 17,
    -45, 18, 26, 11, -13, -36, -16, -2,
    21, -2, -22, -11, -16, -14, 18, 46,
    -2, 5, -9, 12, 1, 9, 27, 3,
    6, 29, 1, 4, 13, -4, 34, 1,
    -42, 18, 72, -51, -6, -26, -23, -3,
    46, -18, -1, 10, -46, -53, -44, -13,
    3, 18, -16, -19, -82, 13, 18, 39,
    -17, 12, -2, 28, -29, 22, -23, -22,
    -20, -5, 2, -14, 24, 4, -25, -19,
    8, 4, 21, -24, -12, -58, -6, 20,
    -9, 5, 24, 2, 9, 4, -1, -5,
    16, 38, -20, -20, -22, 13, 37, -24,
    34, 12, -7, 36, 30, -39, 16, -21,
    -5, -30, -18, -18, -15, -2, -3, -11,
    16, -10, 14, -4, 55, -21, 38, -11,
    19, 2, 15, 25, -4, 5, 29, -18,
    9, 43, 18, -6, -23, -30, -36, -14,
    -17, -22, 18, 2, 11, 0, -39, 75,
    6, -23, -12, 19, 12, 5, -58, -18,
    -29, -2, 11, -14, 27, 55, -15, -6,
    -13, -57, 3, 32, 21, -57, 8, 3,
    0, -29, -8, -4, -15, -64, -7, 13,
    -21, 0, 8, -19, 30, 39, -64, 25,
    6, -7, 0, -23, 12, 9, 75, -20,
    4, -15, 36, 11, 5, -22, -6, -2,
    -6, 20, 9, 3, 7, -11, 8, -32,
    10, -8, -1, 3, -17, -2, 12, -8,
    -8, 4, -28, 18, -5, 8, -4, -1,
    -28, -24, -11, -14, -38, 7, -4, -12,
    -23, 9, -1, -10, -7, 0, 2, -4,
    3, 4, -7, 8, -10, -1, -4, -32,
    -21, -11, -27, 0, 1, -4, -12, -1,
    -31, 19, 21, 2, -11, 24, 0, 12,
    48, -15, 9, -9, 5, 4, 19, 1,
    5, 5, -4, 15, -19, -4, 20, 38,
    16, -13, 10, 24, 9, -1, -1, -5,
    -2, -3, 17, -10, 18, -12, 13, -11,
    -4, 9, 7, 8, 6, -22, 16, 5,
    -13, -6, 5, 12, -18, -9, 41, -3,
    -25, 15, -9, -6, 3, 4, -3, -5,
    -18, -8, -13, 16, -32, -52, 15, 20,
    0, 1, 20, 4, 7, 13, 21, 0,
    -11, 4, -5, 12, 36, -6, 31, 13,
    0, 23, -23, 25, -22, -2, -7, 2,
    7, -3, 12, 9, -15, 3, -19, -13,
    -31, -26, 11, 0, -4, -2, 14, -4,
    8, -18, 1, 13, 9, -31, -13, -14,
    -5, -4, -7, 7, 7, 5, -4, -1,
    -14, -13, -17, -4, 1, -1, -24, 0,
    -36, -10, 28, -32, 10, -15, -5, -16,
    4, 16, -11, -14, -18, -4, 14, 8,
    -7, 6, -4, 40, 9, 4, -2, -11,
    -12, 4, 20, 19, 3, 59, -2, -17,
    8, -52, -20, -4, 4, -14, -15, -22,
    -25, -6, 6, -7, -10, -6, 8, 7,
    -7, 11, -6, -10, -9, 15, -7, 10,
    -12, -6, 24, 3, 23, -4, -19, -46,
    23, 6, -19, 34, 10, -26, -11, 1,
    20, -4, 5, -3, -5, 12, 17, 4,
    4, -14, 32, -22, -2, -15, -17, -6,
    -24, -10, 1, -6, 6, 1, -2, -16,
    -10, -3, -8, -10, -2, 16, 20, -24,
    -15, 8, 12, -6, -1, 29, 11, 18,
    -2, -18, 8, -7, 5, 4, -10, 2,
    6, 5, 20, -4, -11, 13, -39, -5,
    -44, 6, -35, 23, 7, 21, 1, 7,
    -20, 6, 4, -8, -39, 20, 6, 12,
    -4, -35, 36, -10, -4, 0, -12, -6,
    11, -6, 22, -11, 35, 16, -18, 35,
    14, 18, 33, 7, 17, -7, -5, -13,
    10, 17, -9, 12, 17, 23, 11, 1,
    8, 49, 7, 5, -15, 12, -6, 0,
    27, -12, 0, -5, 39, -16, -2, 20,
    -26, 8, -16, 25, 20, 13, -21, -13,
    1, 2, -4, -21, 8, -4, 26, 9,
    16, -2, 17, -11, -24, -14, 6, -9,
    1, 6, 4, 29, 45, 43, -16, -5,
    -4, -22, -21, 15, 5, 10, -21, 6,
    -4, -2, 3, 14, -13, -10, -6, -15,
    -3, 3, 8, 44, 3, -8, 4, 18,
    -3, 27, 37, -14, -45, 1, -2, 43,
    18, 22, -16, 35, 1, 23, -22, -14,
    8, -10, -6, -3, -6, -3, 19, -5,
    3, 48, 0, 22, -6, 0, 12, 14,
    49, -23, -21, 14, -35, 8, -29, -6,
    -30, -1, -55, -12, 4, 7, 4, -1,
    -2, -4, 8, 16, -7, -8, -16, -13,
    -5, -7, 4, -13, -17, 0, 3, 9,
    2, 6, 6, -1, -11, -6, -6, -7,
    -25, 4, 14, -7, 18, -33, 18, 10,
    6, -5, 1, 4, 14, 28, 1, -8,
    -13, -18, -11, 5, -19, -7, -3, 2,
    -10, 15, 12, 29, 5, -6, -8, 13,
    34, -13, -12, 17, 11, -1, 7, 4,
    -1, 16, 18, 1, -1, -8, -27, 40,
    6, 27, 24, 1, 5, -9, 7, 1,
    -18, -15, 11, 18, -12, -15, -2, -3,
    -5, 8, -7, 16, 6, -12, 3, 19,
    -8, 5, 3, -2, -15, 5, -12, 18,
    14, -6, 14, -13, 5, -6, -4, -15,
    -27, 42, 38, -16, -15, 20, -2, 46,
    40, -29, 6, -39, 12, 5, 13, 3,
    10, 14, -2, -8, 25, -44, 17, 11,
    5, 1, 22, -12, -1, 7, -3, -5,
    -8, 0, -18, -11, 5, -12, 23, -20,
    6, 5, 3, 14, 6, -18, -6, -26,
    -3, -19, 4, 12, 12, 47, -25, -19,
    -11, -15, 67, -29, 2, -3, -1, -15,
    -21, 1, -18, -9, -33, 11, -47, 28,
    2, 4, -2, -7, -17, -10, 5, 0,
    -8, -5, 1, 17, 14, 11, -14, 22,
    -9, 11, 9, 26, -9, 13, -7, 10,
    5, -7, -10, -9, 13, 35, 25, -42,
    52, -35, -45, 1, 4, 2, -3, -10,
    -13, 11, 9, -2, 3, 24, -20, -19,
    4, 66, 5, -20, -8, 8, -7, 7,
    -19, 15, 20, 31, 8, 24, -50, 61,
    -21, 9, 10, -4, -1, 0, -6, 24,
    16, -6, 5, -11, 27, 17, -11, -17,
    -2, 20, -35, 29, 15, -5, -16, 7,
    -27, 8, 30, 17, 13, 23, -6, 24,
    -27, -40, 38, -24, 2, -28, 2, -21,
    -16, 8, 4, -3, -26, 50, -22, -16,
    -21, -6, -3, 29, -2, -5, 0, 7,
    -31, -10, -16, 6, -25, -8, 24, -18,
    18, 8, -6, -8, -3, -4, -3, -10,
    6, -2, -3, -8, 20, -25, -7, -25,
    -15, -8, 3, 17, 2, 1, 1, 1,
    24, -30, 16, -2, -41, 1, -31, -1,
    -3, -47, -28, 5, -7, -5, -8, 31,
    2, 4, 1, -8, 9, 5, 29, -19,
    -40, 16, -30, -43, -2, 5, -7, -7,
    8, 1, 5, 0, -46, -25, -38, -8,
    -4, -47, 17, 23, -7, -8, -9, -4,
    0, -8, 8, -2, -4, -15, 6, -26,
    27, -17, -35, -7, 7, -5, -17, -14,
    19, -1, 35, 4, 19, -18, -3, 18,
    20, -36, -25, 27, 2, -10, -11, -10,
    3, 3, -3, -1, 4, 27, 17, -8,
    -19, 3, 12, 25, -14, 2, 1, -3,
    -1, -21, 4, -10, 45, 12, 5, 1,
    13, -37, -11, 20, -11, 1, 15, -16,
    0, 10, 26, -1, -7, 2, -35, -2,
    9, -5, 11, 7, 9, -4, -11, 6,
    1, 10, -42, -21, 3, 22, -12, -18,
    -7, 2, -24, 45, -15, 1, -14, 0,
    -5, -10, -28, 5, -28, 34, 0, -8,
    -2, 12, 6, -22, -1, -2, 1, -5,
    -21, 10, -14, 14, 25, 23, 16, -4,
    9, -2, 7, -10, -4, 14, -17, 7,
    -4, -17, 1, 3, -23, 0, -5, 33,
    7, 2, 6, -7, 6, 12, 8, 18,
    -1, -2, 49, 17, -5, -27, 44, -41,
    11, 16, -1, 5, 6, -2, 14, 22,
    7, -10, 4, -5, -8, -1, -47, -2,
    -12, 11, -30, -31, -2, -4, -29, 1,
    -23, -13, 8, -2, -53, 7, 28, -38,
    -5, 23, -6, 19, -8, -3, -8, 1,
    11, 11, -15, 4, 25, 13, 19, -20,
    -56, -26, -35, -12, 26, 10, -3, 5,
    1, 0, -17, 7, 29, 31, -24, 28,
    6, -6, 38, -31, -3, 4, -9, -10,
    -2, 13, 0, 59, 17, 5, 13, -4,
    18, 2, -17, -16, 18, -4, -6, -5,
    14, 5, -15, 1, 9, 75, -17, 57,
    -14, 27, -18, 8, -6, 19, -10, 1,
    2, 18, 5, 9, -6, 4, -11, 34,
    -15, -34, 5, 28, -12, 7, -14, -5,
    4, -14, -25, -23, 19, -37, 33, 19,
    15, 39, 6, 11, -2, 22, -1, 1,
    -15, 11, -14, 15, 34, 1, 44, 33,
    19, -8, 25, -5, -17, 1, 13, 18,
    -5, 3, 25, -7, -33, 9, -6, -1,
    -23, 16, -46, 2, -18, -14, 13, 7,
    4, -23, 47, 19, 8, 13, 10, -66,
    31, -7, 15, -22, -12, 0, 6, -1,
    38, 10, -8, 3, 93, -32, -4, 17,
    -20, 0, 31, 11, -13, -8, 6, -18,
    -5, 5, -1, 5, 7, 21, 3, -13,
    25, 9, -6, -30, 3, -9, -10, 14,
    1, -20, 30, 6, 50, 12, 5, -50,
    11, 40, 30, 23, 17, -13, -16, 0,
    22, -22, 4, -9, -13, 22, 1, -64,
    -17, -40, 20, 33, -12, 0, 16, -1,
    -22, -37, 7, 15, 8, 19, 1, -28,
    25, 13, -27, 10, 11, 24, -9, -5,
    5, 0, 7, -6, -21, -11, 25, 16,
    14, -54, 6, 24, 8, 1, 2, -2,
    -12, -2, -11, -6, -5, 9, 22, -18,
    -24, -10, 9, -27, -21, -5, -7, -14,
    -18, 5, 2, -23, 6, 9, 23, 30,
    2, -40, -47, -20, 15, 16, -37, -1,
    0, 28, 33, 15, -23, 24, 6, -6,
    -50, 8, -35, 14, 8, 20, -23, -6,
    -17, -10, 4, 5, 11, 16, -6, 21,
    10, -12, -55, -7, 3, -3, -9, -47,
    38, 3, 13, 8, -20, 15, 13, 10,
    -3, 12, -27, -12, 15, -5, -6, -6,
    4, 21, -19, 4, -5, 6, 21, -20,
    33, 62, -25, 31, -39, 9, -13, 9,
    12, -7, 8, 3, -7, -11, -11, 19,
    -44, -1, 10, 27, 12, 12, -4, 3,
    9, 11, 3, -23, 24, 14, -11, -35,
    -22, 9, 68, 16, 16, -9, 21, -12,
    -7, 14, 14, 16, 51, 27, -33, 20,
    -21, -46, -8, 0, 6, 2, -3, -10,
    -13, -1, 10, 25, -57, 9, -9, -7,
    30, -35, 20, 13, -1, -4, -11, 12,
    22, 31, -37, 3, 6, 31, -2, 2,
    32, -48, -21, 18, 11, 15, -19, -4,
    35, 1, 1, -3, 31, 14, 38, -13,
    9, -12, -3, 30, -5, -6, 6, 0,
    38, -14, 19, 2, -27, -28, 50, -19,
    -94, 4, 19, 19, 14, -17, 14, -2,
    -6, -5, 11, 20, -38, 33, -13, -25,
    -30, -16, -18, -33, -13, 17, -6, -6,
    34, 0, 9, 6, 4, 3, 0, -25,
    7, 29, 25, 16, -25, -9, 6, 7,
    1, 3, -12, 10, 32, 63, 19, -11,
    -16, -8, 24, -16, 6, -16, -8, 4,
    -27, 13, -3, -6, -13, 31, -18, -20,
    6, 27, -36, -27, 16, -16, 11, 3,
    -1, 15, 20, 12, -7, -17, -27, -8,
    6, 27, 23, 2, 2, -2, -5, -9,
    -1, 15, -2, 11, -13, -19, 8, -51,
    -26, -11, -14, 13, -3, 1, -9, -7,
    -65, 2, 20, 0, 17, -5, -20, -20,
    -14, 3, -6, 7, 0, 5, 4, 2,
    -5, 49, 36, -16, -18, -27, 74, 1,
    49, 12, -28, -1, 19, 12, 14, -12,
    11, 1, 13, -3, 3, -43, -11, 32,
    -12, 25, -3, 3, -4, 3, 9, 9,
    -17, -32, -6, -5, 5, -38, 4, -52,
    -37, 3, -1, -18, -8, 4, -2, 9,
    -13, -14, -14, 13, -17, -6, 11, 16,
    5, -1, -3, 7, -15, 2, 0, 8,
    8, 1, -6, -26, -48, -25, 8, 20,
    -29, -9, -22, -22, -17, -8, 3, 3,
    18, 2, -10, 16, 6, -2, 21, 18,
    -21, -14, -21, 0, -11, -13, -3, 8,
    -15, -2, -4, 14, 8, -39, 17, 3,
    -2, -14, 7, 16, -2, -34, 37, 9,
    -7, 4, 24, -6, 4, -15, -15, 31,
    4, 36, 5, 45, -3, 14, -14, -7,
    -10, 33, -5, 28, 32, -18, -58, -32,
    11, 9, -47, -53, 6, -19, -23, 17,
    8, -16, 18, -22, 32, 24, 23, 11,
    -4, -4, -63, -1, 4, 4, -5, -5,
    -3, -6, 0, 8, 29, -34, 15, 51,
    -7, -34, 55, -27, 17, -11, -16, -13,
    -20, 0, -5, -3, 18, 16, -4, 34,
    59, -24, 34, 29, 25, -2, -17, -11,
    -7, -9, -10, 10, 7, 30, -6, -2,
    6, 11, -18, 13, 1, 13, -12, -12,
    2, -2, -5, -9, -6, -12, -25, 0,
    -44, 1, -5, 9, -5, -2, -12, -2,
    28, 7, -1, 6, -44, -20, -4, 15,
    21, -64, 22, -20, 3, -1, -2, -4,
    8, 8, -2, 11, -9, -25, -39, 22,
    21, 31, 9, -57, 8, -9, 0, -1,
    -3, -1, 2, -10, -37, 29, -6, -56,
    -7, 56, 14, -6, -9, 16, -7, -30,
    5, -11, -5, -7, -1, -19, 26, -7,
    3, 19, -18, 3, 1, -1, -18, -5,
    -18, -16, 9, -25, 30, -17, 23, -27,
    52, -18, -33, -21, -7, -8, 3, -9,
    9, 24, 13, -3, -13, -10, 10, -1,
    -19, 6, -14, 27, -13, 8, -1, -7,
    -2, -14, 9, 4, 8, -18, 12, 26,
    -8, 16, 28, -16, -9, 18, -13, -18,
    -11, 16, 27, -2, 8, 9, -17, -2,
    32, -4, 12, 16, 11, -8, 0, -10,
    5, -31, -2, 8, -10, -2, 31, -12,
    16, 60, 81, -8, -2, 5, 21, 25,
    -2, -13, -42, 7, -23, -13, -4, -53,
    0, 45, 13, -7, -4, 2, 1, 2,
    1, -14, -6, -2, -13, 18, 50, 24,
    44, 5, 25, 7, 23, -12, -20, 11,
    -18, 3, -4, -7, -4, 14, -16, 12,
    35, -42, 4, -35, -11, 2, 8, 22,
    5, 8, -49, 12, 15, -76, 39, -86,
    26, 2, -10, -12, -21, -14, 5, 52,
    11, -16, 17, -2, 30, 2, -48, -26,
    11, 5, -61, -47, -18, 4, -49, -35,
    11, 10, 44, 26, -8, -41, -30, -11,
    -70, -59, 25, -27, 2, 4, -5, -24,
    11, 31, -9, 14, 10, -51, 10, 44,
    27, -19, 47, -43, 14, 24, -23, 5,
    39, -18, 0, -46, 11, -20, 51, 12,
    -3, -35, -96, 30, -20, 6, -28, -4,
    0, 6, -9, 127, 16, 18, 24, -4,
    63, -11, -87, 4, 7, -7, -25, -3,
    -27, -38, -23, 21, -26, -4, -11, -64,
    1, -39, 60, -20, 39, 27, -11, -38,
    5, 39, 8, 16, 6, -59, -15, -26,
    11, -54, 20, 37, -3, -13, -15, -40,
    45, 13, 45, -11, -11, 39, 19, 8,
    -22, 17, -39, 24, 11, 12, -4, -1,
    -11, 7, -31, 23, -22, -47, 40, -40,
    25, -30, -11, 46, -23, 3, -15, 29,
    -47, 15, -53, 24, -127, 22, 13, 37,
    29, -11, -19, -77, 34, -25, 19, -16,
    13, -8, 70, 31, -44, -2, -5, 51,
    -49, 32, -1, 12, 8, -23, 14, 15,
    -13, 54, -4, -26, -76, 9, 13, 56,
    22, -15, -18, 0, -27, -79, 9, -7,
    0, 3, -2, 8, -37, 38, -2, -4,
    61, -17, -15, -32, 11, -33, -4, 16,
    28, 5, 20, 27, 25, -19, -36, -5,
    -43, 15, -13, 42, -6, -15, 22, 7,
    29, -13, 7, -2, 58, 32, 2, 1,
    3, 4, 36, -65, -18, -3, 48, 6,
    -13, 22, 83, 46, -14, 4, -52, -48,
    31, 51, 17, 25, -14, -54, -19, 5,
    8, 3, 9, -17, -3, 9, -79, 44,
    -7, -11, 20, -23, 7, 14, -33, -3,
    12, 2, -17, -4, 24, -7, -59, 25,
    -31, -43, -11, -32, -14, -21, -9, -7,
    -16, 4, -4, -32, 9, -12, 36, 24,
    6, -7, -31, -36, 11, 10, -91, 5,
    31, -25, -64, -20, 50, -87, -11, 12,
    28, 64, -9, 4, 10, 36, -77, -5,
    -28, -14, 5, 2, -13, -6, -1, -11,
    -29, -45, -57, 8, 5, 28, -5, -124,
    14, -9, -39, 0, -2, -19, 24, -78,
    -6, 8, 26, -40, 27, 11, 14, 52,
    -17, 20, -25, -5, -40, -29, -9, -40,
    -19, 22, 3, 10, -29, 7, -7, 43,
    -20, 18, -23, 50, -7, 29, 24, 11,
    71, 7, 76, -35, 31, 32, 18, -12,
    16, -21, -11, -41, -37, -46, 3, 53,
    48, 71, 6, 20, 57, 13, 40, 1,
    -8, -12, -53, -38, -46, -20, 58, 19,
    -101, 67, 36, -2, -1, -32, 57, -30,
    -37, 8, 11, 31, -4, -4, 14, 6,
    5, -21, 31, -21, 15, -4, -58, 32,
    -3, 4, -10, -35, 17, 3, 9, 45,
    -41, -4, 79, 5, 8, -74, -47, -28,
    34, 14, -4, 2, -41, 36, 53, 43,
    -1, -10, -18, 14, 11, -2, 1, 5,
    56, 4, 4, 6, 26, -28, 73, 51,
    30, 28, -19, -48, 4, 7, 30, -4,
    4, 6, 10, 23, -35, 17, 22, 26,
    -6, -8, -7, -14, 10, 20, -35, -15,
    15, 105, -20, -2, 3, 30, -7, 18,
    10, -71, 16, 2, -42, 6, 7, 16,
    0, -4, -26, 0, 10, 25, 21, -2,
    -36, 17, 24, 3, 19, -92, -29, 7,
    92, 20, 6, 4, -69, 16, -30, 33,
    -4, 66, -40, -8, -2, 17, -6, -15,
    -2, -12, 24, 14, -47, 38, -13, 10,
    62, 14, 1, -4, -30, -1, -5, 10,
    4, 0, -4, -13, -15, -14, 29, 5,
    -71, 2, -31, 9, -15, 20, -18, 5,
    -83, -3, 13, 10, 16, -21, -12, 37,
    -25, 46, 26, -84, -4, -5, -9, 3,
    3, -64, -6, 5, -5, -33, -45, 33,
    -11, 38, -18, 69, 37, 12, 26, -65,
    7, -11, 14, -11, 39, -14, 20, -42,
    36, -38, -33, -96, 3, -2, 33, -20,
    38, -24, 12, 4, 38, 58, -21, 48,
    -38, -15, 21, -62, -15, 11, 2, 7,
    -24, 4, 2, -5, 25, -4, 58, 4,
    -13, 18, -44, -39, -17, 8, -3, 36,
    41, -7, 24, -25, -6, -65, -10, 7,
    -1, -29, -53, -37, 11, 2, 22, -5,
    18, 5, 0, 12, 19, -19, -9, -3,
    18, -51, 10, 12, -16, -35, -8, 13,
    -32, 18, 9, -3, 3, -33, 67, -14,
    31, -38, -2, -13, -77, -52, 26, 27,
    12, -8, 15, -11, 27, 63, -75, 31,
    -54, 5, 32, -50, 10, 9, -36, 70,
    -7, -80, 83, -33, -46, -13, 70, -37,
    2, 31, 71, 27, 14, -22, -29, 45,
    -6, 1, 21, -29, -25, -31, -11, 8,
    -12, -48, -3, -48, -3, -14, 14, -4,
    6, -33, 6, -22, 44, -72, 13, 37,
    -42, 29, 28, -31, 78, -4, 14, 42,
    -36, -4, 7, 4, 40, -52, -23, 55,
    31, 1, -32, 16, 57, 14, -6, 8,
    -5, -17, -29, 8, -35, 14, 7, -7,
    32, 0, 29, -32, -13, 23, -18, -15,
    -8, -5, 5, 1, 24, -23, -1, -24,
    2, -42, -31, 17, 3, 8, -31, -4,
    -23, -31, -20, 46, -61, 8, 16, -13,
    -15, 33, 12, 19, 60, -1, 37, 3,
    -1, 27, 16, 2, -4, -25, 1, 10,
    -61, 24, 30, -13, -10, -25, 28, -23,
    8, 57, -15, 9, -19, 1, 32, -3,
    -2, 43, -13, 24, -50, 18, -36, -44,
    12, -8, -21, -4, -23, -21, -30, -1,
    -12, 21, 45, -13, 14, -7, -72, -23,
    -5, -42, -59, 36, 39, -10, -21, 28,
    -1, 23, 7, -59, 7, -17, 4, -8,
    23, 33, -13, -6, 1, -17, -43, -61,
    -1, 10, -58, -65, -19, 23, 25, -53,
    8, 0, 30, -8, 3, -20, -5, -61,
    -8, 36, 11, -72, -14, -9, -7, -18,
    1, 17, 33, -7, -47, 16, 31, 3,
    5, 10, 12, 50, 18, -17, 10, 12,
    -14, -27, 31, -6, -24, -62, -6, 6,
    -66, 21, 27, 27, -6, -2, -17, 45,
    3, -25, -90, -17, -33, -16, 22, -23,
    -13, 76, 68, -14, -5, 17, 12, 61,
    -7, -30, -50, -63, 32, 5, -14, 6,
    37, -12, 41, 17, 54, -12, 4, 31,
    -28, -7, -12, -8, -27, -102, 53, 17,
    22, -21, -27, -36, -12, 20, 44, 33,
    -2, 2, 5, 15, -11, 1, -3, 45,
    -17, -14, -51, 12, 10, 14, 35, -3,
    -3, 7, 2, 2, -5, 11, -30, -5,
    10, 4, -22, 28, -21, 5, 14, -8,
    4, 3, 4, 12, -15, 17, 11, 10,
    -29, -39, 6, -30, -15, -8, -3, -9,
    -9, 12, -4, 14, 37, -32, 8, -11,
    -3, -4, -15, -34, -11, 42, 2, 21,
    5, 11, 2, 0, 31, 12, -33, 6,
    7, 8, 22, 5, -37, 0, 28, 0,
    11, 7, 24, -12, -10, -7, 10, 3,
    26, -3, -33, 3, -20, 12, -14, -31,
    8, 7, -10, 12, 22, 5, -39, 14,
    -35, -8, -1, -15, 21, -11, 35, -31,
    2, -5, 0, 17, 22, 21, -1, -25,
    -16, -1, -11, 16, -34, -5, -25, 15,
    10, -25, 2, 9, -24, -22, 14, 19,
    -16, -4, 34, -10, -21, -36, 10, 12,
    -7, 15, 21, -12, -37, 7, 29, 4,
    3, -8, -16, 29, 8, 22, -2, 30,
    -1, -10, -6, 6, -4, -8, -6, -3,
    46, 11, 40, -25, -14, -13, -4, 18,
    -17, -17, 8, -5, 15, -14, 3, -17,
    30, 3, -10, -2, -15, 22, 42, 15,
    14, -8, -10, 5, 21, 7, 11, -1,
    5, -21, 7, -56, -6, 23, -7, 10,
    11, 17, -18, -26, -23, -11, 19, 24,
    3, -12, 6, 3, -9, 38, 6, -20,
    25, -44, -3, -10, 23, -26, 4, -26,
    25, 3, -19, -17, 23, -46, 37, -2,
    12, 0, -20, 31, 21, 6, -10, -17,
    -13, 11, -8, 6, 1, 1, 4, -9,
    -18, -11, -21, -22, 27, -34, -66, 25,
    22, -3, 6, 5, 13, 14, -12, -14,
    -5, -4, -6, 20, 12, 15, 6, 8,
    -28, -21, 2, 8, 18, -16, -24, -6,
    5, 2, -7, -7, 9, -3, -5, -21,
    6, -19, -22, 29, 11, 5, -13, 1,
    15, 16, 6, -9, 18, -1, 9, -14,
    -5, 7, -4, 12, -40, -4, -5, 16,
    -24, 23, 0, -5, -1, 17, 7, 10,
    -14, -19, 14, 2, 9, 12, 16, 10,
    1, -18, -7, 3, -23, 10, -5, 4,
    -17, -19, -15, 13, 2, 22, 3, -8,
    8, 2, -11, 8, 9, 9, 1, -10,
    -1, -1, 10, 15, 17, -9, -10, 16,
    -6, 0, -8, -10, -14, -19, -24, -5,
    7, 18, 23, -5, 11, -23, -9, -3,
    -16, -13, 13, -6, -6, -27, 9, -31,
    4, -6, 10, -8, 2, 2, 10, -36,
    18, -19, -3, -21, -7, 33, 8, -4,
    26, -1, 19, -17, -54, 4, 17, -5,
    1, -10, 16, -6, 12, 10, 7, 15,
    20, 20, 38, 6, -15, 6, -30, 2,
    18, 29, 7, 12, 4, -4, 9, 11,
    0, 17, 0, 7, 32, 23, -1, -6,
    16, -32, -2, -5, -6, -1, -14, 21,
    -5, 37, 21, 6, -5, 9, -18, -41,
    -5, 12, 12, 10, -5, -31, -3, -48,
    6, 7, 44, -21, -20, -14, -8, 20,
    -45, -8, -10, 11, -28, 0, -17, -1,
    26, 30, -43, -49, 40, -39, 5, 30,
    2, -29, 26, 10, -13, 0, 0, 25,
    -10, -40, -44, 6, -19, 7, 8, -28,
    20, -3, -28, -8, 6, -7, -17, -9,
    -5, -13, -21, -3, 2, 34, 0, 13,
    9, -3, -5, 9, -3, 5, 7, -5,
    -28, -3, -16, -12, -19, 20, 0, 8,
    6, -4, 22, -14, 0, 29, -5, 1,
    -2, -12, -2, -40, 16, -3, 7, 31,
    12, 5, -3, -11, -3, -10, 5, -23,
    -8, 22, -20, -30, 11, 20, -7, -31,
    -10, 9, -11, 0, -9, 26, -20, -7,
    29, -16, 15, 43, -9, 24, -8, -5,
    1, -14, 20, 16, -5, -21, 9, -14,
    6, -5, 0, -22, -14, -26, -28, 7,
    23, -19, -14, 4, 1, 16, -14, -4,
    46, 47, -2, -49, -68, 26, 10, -4,
    30, 30, 2, 3, 7, -5, 4, -19,
    -31, 7, 42, -28, -7, -2, -3, -3,
    11, 9, -12, -4, 15, -3, -6, 5,
    21, -18, 9, 48, 4, -1, 0, -1,
    7, -2, -30, -4, -2, -1, -14, 21,
    -23, 2, -24, -14, 4, 11, -14, 16,
    2, -1, 15, 3, -21, 9, 66, -13,
    -6, 20, 20, 3, -23, -26, -43, 15,
    22, -15, 18, 4, -3, 34, 4, 3,
    -9, 12, -13, 22, -44, -1, 20, -9,
    -2, -17, -22, -1, 1, -29, -5, 34,
    2, 1, 24, -81, 6, -20, 10, 24,
    17, 7, -9, 14, 5, -4, 19, -9,
    2, 6, -3, -19, 13, 11, -16, 17,
    7, 18, -7, -14, 17, 16, -2, 35,
    -14, 18, -7, 4, -14, -31, -4, 21,
    21, -9, 10, 5, 42, -14, 20, -20,
    15, 22, 10, -21, -9, 10, -15, -15,
    30, -14, 2, 8, -29, 17, -1, 17,
    -5, 20, 15, 25, 5, -8, 20, -5,
    -32, -4, 29, 6, 44, -25, -32, 4,
    -22, 13, 23, -13, -4, 13, -9, -24,
    26, -13, 4, 12, -41, 15, 4, -12,
    -1, 1, 2, 11, -14, 10, -61, -9,
    -10, -22, -14, 3, 9, -7, 40, -5,
    -11, 33, 18, -3, -17, 4, 21, 2,
    13, 21, -2, 6, 27, 53, 31, 8,
    39, -13, -21, 6, -19, 0, -17, -8,
    16, -18, -56, -11, -25, 2, 11, -3,
    -11, -7, 29, -4, 32, 14, 14, 17,
    21, 9, -1, 35, -36, 11, -23, -21,
    -42, -23, -12, -15, 3, -54, 5, -6,
    -11, 16, 9, -27, 3, 10, -20, -16,
    -20, -5, -2, 5, -18, 4, 12, 6,
    -16, -4, -2, -9, -57, 14, -21, 0,
    -5, 0, 27, 39, 11, 4, 15, -6,
    11, -16, -9, 3, -15, -4, -9, -9,
    -21, 43, 34, -22, -13, 21, -29, -7,
    16, -5, 26, -8, 24, 14, 15, -27,
    20, 17, -20, -1, -8, 24, -2, 22,
    0, -7, 13, -6, -24, -11, 22, -10,
    2, 11, -15, -4, 20, -1, -3, 8,
    -20, 37, 9, 0, 1, 17, 17, -12,
    6, -19, -9, -21, 0, 19, -2, 3,
    7, 20, 9, 22, -5, -8, -12, 5,
    28, 13, 2, -9, 16, 16, 2, 4,
    5, 7, 10, -22, 24, 2, 18, 11,
    8, -45, 15, -23, 26, 39, -27, 16,
    -13, 16, 29, -27, -11, -8, 28, -10,
    41, -28, -1, 20, 13, 9, -19, 7,
    -9, 3, -31, -5, -8, -14, 40, -50,
    -28, -8, -34, -4, 18, 29, 41, 88,
    6, 8, 18, -9, -10, 1, -2, -14,
    -12, 2, 37, 23, -22, -6, -13, 16,
    17, 16, -16, 16, 67, 3, 15, -11,
    -22, -20, 13, -16, 56, -7, 30, -8,
    17, 25, 31, 6, -7, -15, -1, 0,
    -42, -9, 16, 18, 8, -11, -3, -26,
    -5, -6, -7, -29, -11, -15, 25, -2,
    7, 7, 19, 4, -14, 2, 5, -32,
    -15, 4, 41, -22, 13, 9, -12, -15,
    -9, -7, 14, -1, -18, 16, -11, -18,
    25, 37, -5, -7, -3, 20, -4, 10,
    4, -12, -17, -15, -7, -81, -27, -78,
    -18, -44, 8, -32, -16, -7, -13, -20,
    14, 17, -28, 34, -8, 16, 24, 33,
    -12, -26, 20, 1, 25, 33, -57, 1,
    -16, -22, -11, 8, 36, -6, -78, -45,
    36, -9, 28, 0, 9, 9, 18, 18,
    25, 10, -16, 19, -21, 23, -21, 18,
    27, 11, 8, -1, 48, -7, -17, -6,
    11, 7, 16, -21, -41, -19, 13, 30,
    -36, -1, -11, -6, 20, -2, -22, -17,
    32, 14, -29, -2, 36, -8, 81, 11,
    -11, 13, -15, 15, 15, -127, 5, 3,
    0, 12, 13, -19, -45, 29, -27, -2,
    -18, 5, -6, -19, 29, -28, 16, 1,
    46, -1, 2, 12, -11, 38, -1, -17,
    -11, -37, 19, -6, 18, 24, 31, 22,
    55, -12, 34, 19, 36, 54, -6, -32,
    -15, -25, -14, 11, -4, 8, -15, -14,
    1, 32, 19, 36, -16, 22, -1, -28,
    -20, -2, 15, 15, 12, -27, -43, -23,
    20, 31, -14, 33, 17, 5, 16, 15,
    5, -33, 5, 15, 21, -19, 6, 3,
    -15, 10, -22, 11, 11, -14, 1, -4,
    9, 20, -22, 24, 31, -12, 3, -43,
    -2, -20, -35, 6, 2, -16, 11, 38,
    20, 9, -10, -26, -5, 5, -1, -24,
    -12, -18, -6, 2, -15, 7, -8, 27,
    -20, -12, 12, 13, 29, 58, 37, -25,
    33, 28, 27, 15, -67, -4, -46, -51,
    15, -2, 5, -21, 16, 6, 2, -11,
    -18, 23, -24, -8, -1, -8, 16, -4,
    15, 4, 3, -2, 14, -3, 13, 38,
    10, 4, -27, 39, 27, 21, -10, -6,
    -35, -1, 5, 20, -23, 3, 11, 25,
    24, 12, 6, 11, 17, -22, 6, -10,
    -35, -19, -6, -12, -14, 13, 7, 19,
    -13, -37, 30, 7, -5, 49, -60, 9,
    -12, 9, -11, -32, 2, -3, 22, -3,
    -27, -7, 9, -13, 0, 10, 9, -13,
    -6, -23, 5, 2, 51, -12, -23, -13,
    -24, 23, 54, -19, 2, 10, -6, 33,
    -3, -30, -6, -24, 12, 21, 7, 14,
    5, 21, 29, 21, 22, 36, -13, 19,
    -16, -8, 13, -26, 14, -18, -10, -14,
    -6, 20, -18, 58, 12, -33, -17, -55,
    -21, -22, -36, -10, -29, -23, 26, -48,
    -6, 4, 63, -3, 11, -6, 3, -8,
    -34, 10, -8, -18, 6, 13, -6, 19,
    16, -7, 22, -10, 59, -33, 21, -8,
    3, 5, 12, 0, -20, 5, -16, -4,
    -29, -26, 20, -12, -12, -8, -25, -4,
    30, -9, -5, -3, 23, 13, 37, -26,
    94, -35, 20, 4, -51, 12, -43, -8,
    10, 4, -28, 2, -6, 24, 1, -19,
    14, 27, 21, 2, -18, -7, 35, -4,
    33, 3, 11, 6, 3, -24, 1, 42,
    -5, 30, 19, 1, 12, 20, -6, -13,
    -16, 33, -17, 5, 7, -9, -6, 9,
    11, -3, -22, -4, -20, 9, -4, -65,
    14, -9, 0, 27, -5, -14, 3, 7,
    22, -4, 30, 16, 29, 8, 19, -26,
    -6, -10, 23, 11, -4, -1, -3, 1,
    -9, -14, 8, 20, 21, -3, -20, -14,
    22, 26, -25, -15, 39, -8, 26, 50,
    4, -2, -10, 16, -32, -43, -26, -60,
    0, 1, 34, 16, 24, -32, 3, 15,
    -2, 26, -46, -10, 18, 27, -40, -54,
    -2, 9, 10, 4, -59, -7, 1, -50,
    3, -18, -11, -27, -57, 27, -16, 14,
    -12, -6, 6, 30, 7, 2, -7, -11,
    -9, -7, 12, -36, 24, -11, 7, 46,
    26, -27, 22, -7, 3, 26, -28, -15,
    -5, 14, 16, 4, -3, -24, -20, 16,
    -5, 32, 21, 13, -32, 27, -1, -16,
    -16, 0, -48, -2, 19, 9, -29, -2,
    0, 12, 2, -12, -35, -3, 51, 12,
    -25, 44, 26, -27, 8, 70, -50, -54,
    -26, 8, 15, -23, 4, -22, 0, 10,
    0, -1, 20, 15, 24, -4, -31, 61,
    12, -9, -29, 7, 5, 10, 41, 16,
    21, -7, -23, -1, -47, -20, 20, -14,
    -57, -4, -7, -29, 10, -26, 7, -4,
    3, -19, 28, -32, 20, -13, -5, 53,
    -2, 14, -39, -20, 17, -24, -40, 33,
    0, -26, 44, 32, 36, 33, -22, -29,
    10, -47, 26, -16, 31, -6, 35, 2,
    -4, 7, 7, 30, 16, 26, -40, 7,
    14, 10, -20, 15, -17, -10, -5, -8,
    15, 7, -7, 2, -12, -59, 22, -5,
    -12, -18, -1, -32, -11, 25, 40, -8,
    -12, 12, 46, 14, 9, 27, 8, 19,
    0, -11, -20, -19, 16, 11, -10, 24,
    9, -13, -16, 31, 27, 56, -9, -8,
    -11, -2, -6, -4, -32, 19, -4, -32,
    28, 1, 24, 37, 7, -1, -5, -24,
    -11, 1, 7, 1, 26, 11, -37, 26,
    -9, 8, 36, -32, -2, 2, -69, -16,
    -31, 16, -33, -30, -9, 13, -2, 13,
    -31, 11, -39, -30, -13, 54, -6, -30,
    9, 17, -20, -3, -23, -29, 9, -40,
    -18, -17, 14, -8, -43, -31, -53, -9,
    4, -13, -4, -15, 1, 6, 4, 5,
    -17, 56, 15, -1, -51, 13, -21, -19,
    20, 10, 28, -13, -43, -24, -44, 16,
    0, -1, -5, 10, 1, 28, 5, 5,
    10, -16, -10, -26, -7, -1, 31, 2,
    -35, -22, -16, 9, 33, 0, 4, -28,
    15, -6, -12, -1, 31, 12, -21, -3,
    -5, 29, 36, 22, -30, -8, -20, -9,
    -23, -43, 15, 43, 6, -12, -9, 7,
    20, -11, 3, 12, -7, 32, 12, -11,
    35, 33, -9, 9, -15, -3, 8, -33,
    15, -13, 12, 4, -8, -41, 61, 24,
    -7, -21, -35, -22, -11, 9, 3, -6,
    2, -27, 29, 27, -5, 33, 13, 0,
    28, 13, 26, 11, 34, -34, -26, 17,
    4, -4, 7, 48, -63, 15, 1, -68,
    -21, -9, -7, 50, 4, -5, -6, 4,
    25, 6, -38, -23, -8, -11, 46, -16,
    -4, 11, -6, -15, 3, 26, 36, 16,
    5, -23, 28, 24, -18, -49, -50, -58,
    -50, 16, 7, -20, -3, 10, -22, 4,
    33, 43, 36, 20, -14, -7, 26, -34,
    -1, -1, -17, -47, -6, 42, -37, 25,
    44, 13, 96, 18, -3, -22, -22, -53,
    11, 12, -44, 47, 23, 18, -32, -33,
    44, -47, 37, -52, -9, 5, -50, 40,
    -10, 22, 5, 20, -7, -29, 5, 13,
    -14, -18, -13, -4, -29, 57, -59, -22,
    -23, 4, -1, 2, -25, -29, 4, 2,
    10, -19, 11, -10, 62, 59, 26, 84,
    19, 4, 19, -4, -30, 4, 32, -32,
    -41, -15, 33, -2, 48, 51, 93, 27,
    -25, -57, -39, 53, -18, -17, 50, 48,
    24, -20, 3, 31, 24, -2, -26, -17,
    -13, 5, -46, -33, 0, -9, 36, -11,
    -43, 38, -24, 9, 13, -4, -41, -32,
    -29, -6, 26, 22, 2, 14, -6, -18,
    -43, -17, -9, -7, 43, -43, 21, 25,
    26, 1, -3, -42, -46, 41, -22, 27,
    23, 53, -20, 2, 40, -76, 11, 12,
    10, 13, -6, -3, 24, 33, -6, 24,
    -23, 24, -3, 12, 17, 1, 2, 31,
    13, 29, -6, 34, -52, -3, -8, 0,
    23, 32, 31, 53, -3, -38, -12, 21,
    69, 60, 72, 7, -13, 5, -23, -48,
    40, -6, 25, -44, -11, 60, -30, -81,
    6, 12, -12, 12, 6, 63, 35, -40,
    29, 22, -5, -35, -26, -38, -19, -26,
    -3, 70, -45, -10, -2, -23, 23, -40,
    -23, 5, 45, -2, 3, -63, -8, 42,
    -3, -21, -58, -15, 16, 12, 15, 50,
    9, -12, -16, 29, 1, 11, -27, 51,
    -9, -27, -58, -13, 11, 24, -13, -5,
    44, 25, -27, -9, -8, -31, 11, 22,
    23, 1, -21, -21, -19, -11, -41, 30,
    46, -69, -34, -9, -6, -11, 12, 40,
    -1, -32, -25, 31, -13, -17, 20, 4,
    41, -7, 30, -25, -31, 11, 51, -17,
    38, 51, 9, -6, -9, -23, 46, -38,
    -1, -33, -39, -25, 46, 21, 62, 35,
    -38, -40, 27, 23, -3, -29, 22, -15,
    21, 15, -25, -13, 40, 17, -12, -5,
    -5, -12, -12, 28, 21, 9, -16, -39,
    -56, 3, 17, -3, 64, 29, 47, -48,
    20, 10, 14, -11, -7, 11, 9, -40,
    4, -18, 9, -12, 74, -22, -23, 3,
    19, 17, -42, 9, -49, 19, -2, 6,
    26, 24, 59, 70, 9, 38, 45, 41,
    -3, 19, 1, 43, -2, -1, 5, 27,
    -27, 12, -34, -21, 11, 43, -23, 33,
    -10, 16, -25, -36, 5, 8, 50, -15,
    -69, 12, 29, 39, -52, -56, 42, -2,
    17, 6, 16, 61, 27, -9, 6, 45,
    -16, 40, -76, -15, 30, -14, -44, 24,
    0, -16, 3, 3, 8, 16, 22, -15,
    53, -41, 69, 41, -21, -7, -38, -4,
    37, 43, -12, 28, -113, -16, -17, -22,
    -54, 51, 17, 13, -3, -50, -29, -27,
    -12, -21, 4, -17, -39, 23, 27, -10,
    19, 14, 32, 3, 1, -70, 22, -9,
    11, -66, 9, 12, -14, -39, 25, -4,
    54, -15, -22, -10, -23, 16, -17, 4,
    127, -12, 17, 11, 11, 2, 1, -36,
    7, -25, -16, 14, 28, -22, -9, -6,
    5, -32, -10, -60, -15, -25, -7, 17,
    85, -25, 18, -26, -15, 15, 3, -80,
    27, -19, 6, 22, 43, -24, 12, -15,
    -12, 2, 32, 7, -9, 11, -22, 29,
    6, 2, -10, 13, 7, 1, -21, -13,
    -31, -29, 40, -56, -1, 14, -12, -11,
    -13, -51, 27, 16, -63, -37, -20, -72,
    4, 12, -40, 21, 45, 71, -17, 31,
    -11, -11, -3, 31, -28, 62, -37, 30,
    24, 10, 7, 29, 12, -20, -19, -104,
    0, 19, 19, 19, 30, 54, 23, 52,
    19, -32, -88, 46, 50, 40, 2, 20,
    20, -8, 35, -17, 31, 20, 13, 30,
    -46, 15, 70, -14, 47, -24, 4, 66,
    -59, 7, -5, -1, 49, -45, -13, -6,
    -9, 0, 10, 8, 3, 6, 27, 8,
    -14, 22, -56, 8, -8, -39, 13, 2,
    61, -6, 37, 2, 23, 65, -4, -7,
    29, 16, 39, 16, 24, -27, -15, -68,
    -58, 93, 12, 5, 37, -18, -7, 27,
    -29, -67, -2, 58, 15, -35, -7, -24,
    23, 75, 54, -28, 8, 8, -37, -6,
    -13, -34, -14, -28, 13, 31, 26, -70,
    -18, -17, 32, -39, 8, 4, -12, -6,
    -10, -27, -2, -23, 7, 60, -9, 0,
    23, -71, 15, -5, 34, 22, -19, 127,
    -19, -3, 12, 23, 40, -13, -30, -65,
    -24, -53, -42, 28, 37, 14, 17, 6,
    73, -10, 6, 10, -21, 45, 37, -57,
    -72, -21, -16, 3, -14, 105, 4, 49,
    32, 11, -30, 23, -43, -21, 1, -10,
    11, 30, 25, 9, -7, 25, 52, 8,
    -9, 36, 24, -1, -66, 19, 41, -16,
    3, -43, -13, -13, 24, 8, -6, 28,
    -14, -38, -1, 24, -27, -24, -1, -52,
    32, 19, 12, -7, 1, -12, -4, 19,
    4, -8, -26, -8, -29, 1, -14, -47,
    -82, -11, -9, 58, -5, 67, -8, -9,
    -17, 17, -64, -41, -33, -7, -6, 29,
    6, 23, 30, 1, -55, 34, 65, -24,
    -21, 21, -4, -16, -33, -30, 59, -17,
    -33, 15, -10, 3, -59, 52, -30, -80,
    -30, -9, 10, 18, -6, -2, -14, 34,
    -9, -12, -39, -19, 12, 55, 38, 41,
    -49, 31, -4, 23, 59, 11, -13, 29,
    7, -19, -57, 1, -39, 0, 41, 66,
    0, -8, -30, -15, -27, -15, -26, 17,
    -13, 11, 17, 54, -27, 39, 14, 9,
    16, 20, -11, -17, 39, -15, -6, 21,
    -33, -8, 11, 15, 79, 3, -3, -32,
    32, -29, -15, -17, 4, 0, -3, 7,
    -9, 39, 49, -9, -23, -38, -8, -95,
    -1, -50, 4, 29, 39, 9, 2, -23,
    -47, -82, 34, 38, -15, 9, -21, 28,
    -4, -14, 20, 19, -15, -56, 43, -2,
    18, 19, 14, 26, 19, 41, 94, 15,
    32, 20, 39, 36, 3, 23, -25, 14,
    -25, 48, -35, 5, -48, 80, 53, -26,
    25, -9, 10, 15, 2, -22, 80, 49,
    -4, 7, -22, -37, -5, -1, 14, -31,
    -21, -8, 7, 2, -3, 0, 11, -7,
    -16, -9, -23, -18, -2, -3, 0, 11,
    27, -16, 38, 14, -6, -19, 7, -8,
    8, 24, -15, 5, -12, 16, -7, 14,
    22, -7, -12, -18, 7, 10, -1, 10,
    -21, -9, 5, -16, 6, 9, 3, 4,
    14, 11, 15, -55, -16, -5, -9, 31,
    3, -24, -5, -5, 21, -28, -7, 14,
    -4, 13, 23, -13, 10, -8, -7, 7,
    -11, 1, 29, -26, 10, 4, -12, -11,
    18, 46, -2, -14, -1, 44, 20, -19,
    1, -3, -19, 18, -2, -18, -14, -5,
    -43, 35, 15, -2, 7, 7, -12, 2,
    22, -27, 54, 24, 9, 1, 2, -2,
    -30, -14, 1, 15, -30, -11, -11, -1,
    23, -3, -14, -14, 33, 8, 27, -22,
    -7, 28, -7, -15, 1, -12, 15, -18,
    6, 13, -23, -18, 6, -9, 5, 7,
    -21, -30, -11, 23, -5, 6, 30, 16,
    37, -3, -4, 20, -9, 0, 28, -8,
    -4, 18, -30, 31, 2, 10, -11, -4,
    -3, 17, -6, 8, 12, -17, -3, 23,
    -21, 13, -14, 18, 18, -31, 6, -7,
    -4, -11, 16, -17, -20, 13, 11, 15,
    43, 0, 2, 12, -8, -10, 8, 2,
    22, -5, 2, -6, 14, -1, -1, 14,
    12, 25, 3, 14, -15, -42, 4, -11,
    -13, 5, -18, 8, -17, -14, 12, 2,
    69, -35, 21, 14, 5, -4, -6, -1,
    1, 21, -18, 3, 4, 13, 10, -8,
    -13, 7, -2, -37, -32, 17, 22, -11,
    -10, 18, -7, -14, 5, -5, 5, 9,
    13, -7, 15, -20, 6, 19, 4, 10,
    5, 52, 12, -1, -1, 2, 1, -11,
    -21, 5, -2, -14, -12, -65, 19, 26,
    14, -10, -37, -3, 7, 23, -8, -14,
    30, -19, 2, 5, 3, -1, 18, 2,
    13, -31, 5, 6, -4, 2, -4, -7,
    -14, -7, -6, -11, 3, -43, 26, -19,
    3, -2, 47, -10, -6, 1, -42, 2,
    -7, -8, 0, 26, -6, -2, 8, -3,
    -28, 35, 10, 5, 4, -12, -23, 6,
    6, -17, 16, -1, -19, 29, 18, -31,
    5, 31, 14, 4, -5, 6, 4, 18,
    -5, -26, 18, 19, 7, -11, -5, 13,
    16, 22, 18, 6, 20, 5, -7, 6,
    -18, -40, -9, 20, 3, -48, 7, -31,
    -12, -1, 12, 11, -19, -12, 12, -4,
    -16, -27, -3, 5, 6, 21, -11, 0,
    -8, -7, 7, 23, -9, -2, 8, -10,
    52, -23, -3, 11, 17, 15, 2, -4,
    14, 3, -11, -32, -2, 12, 3, -1,
    36, -29, -4, -7, 5, 27, -1, 7,
    13, 16, -10, 10, -11, -11, 8, 12,
    -16, -1, 7, -8, 17, -19, 5, 11,
    19, 4, 15, -7, 16, 8, -18, 2,
    10, -28, -13, -3, -4, -8, 17, 7,
    3, 20, -24, 19, 4, 1, 14, -5,
    25, -7, -18, 30, 4, -30, -42, -6,
    1, 13, -10, -5, 11, -11, -12, 6,
    -10, -18, -10, -48, -8, 16, -11, 2,
    -15, -7, 12, -13, -15, 4, -15, 8,
    -26, 33, 2, -2, -45, 24, 26, -40,
    21, 17, -2, -5, -3, -9, 7, 4,
    6, 7, 4, -18, 1, -5, -3, 5,
    -25, -20, 5, -14, 3, -5, -9, 13,
    3, -18, 33, 34, -9, 7, -36, -13,
    15, 10, -12, 16, -1, 19, -34, 13,
    -2, -30, 48, -1, -10, -13, -3, 4,
    9, -3, -3, -6, 3, -9, 15, 10,
    -48, -3, -20, -14, 3, -16, -7, 9,
    -1, -5, 12, 8, -2, -5, 0, -3,
    -6, 19, -15, 22, -2, 7, -9, 10,
    1, -47, -3, -19, -5, -10, 1, -9,
    -4, 4, 0, 18, -1, -4, 23, -44,
    29, 4, -7, 2, 8, 1, -18, -14,
    13, 16, 15, -38, 8, -16, -3, 3,
    7, -23, -20, -12, 0, 0, -15, -10,
    16, 23, -42, 1, 56, 23, -2, -26,
    12, -7, 23, -4, 4, -16, 6, -1,
    16, -17, 30, -25, -22, 6, -1, -14,
    -9, 21, -29, -30, 15, -20, -9, 13,
    -37, 13, 0, -12, -21, -6, 7, 23,
    10, -27, 18, 5, 19, -10, 9, -10,
    1, -7, -61, 37, -16, 19, 5, -17,
    7, 25, -40, -1, -9, -6, -15, 6,
    -23, -16, -45, 7, -31, -22, 7, 38,
    4, -7, -1, -30, 20, 14, 17, 9,
    5, -4, 5, -35, -13, 4, 9, -20,
    36, 37, 12, -3, -5, 2, -1, -12,
    33, 34, -43, 8, -9, 20, -12, -6,
    -20, 5, 36, -24, -7, 8, 6, -23,
    8, -29, 40, -10, 25, 5, 5, -16,
    2, 13, -13, -23, -9, 1, -7, 12,
    30, 5, -10, 30, 42, 18, 11, 40,
    -19, 29, -7, 9, 12, -1, 13, -27,
    -52, 30, 63, 9, -11, -8, 2, -1,
    1, -45, 21, -2, -11, 3, 2, 7,
    4, 2, 28, 24, -30, 5, 3, 19,
    -4, -4, 7, 2, 11, -9, -18, -25,
    -35, -15, 0, 0, 9, -10, 5, 7,
    -7, -25, 11, -6, -4, 2, -12, -13,
    -1, 0, 23, 61, -5, 43, 31, 18,
    -45, -15, -10, 3, 1, 16, 1, -8,
    -16, -15, 36, 28, -17, -5, -15, -2,
    0, -33, -21, -16, -7, 2, 1, 11,
    -29, 63, 18, -6, -16, 30, -34, -10,
    -12, 15, -19, 1, -25, -16, -10, -10,
    24, 7, 6, 41, 3, 13, -16, 3,
    13, 28, 13, 10, 7, 17, 1, 11,
    -25, 30, 2, 5, 2, 18, 52, -8,
    11, -5, -26, -9, 5, -12, -6, 1,
    29, -18, 44, 26, -7, -9, 2, 5,
    57, -23, -13, 42, -5, 2, -13, -8,
    -6, 11, 1, 12, 26, -9, -27, -31,
    -2, 12, 5, 4, -12, 9, -25, 0,
    -5, -11, 12, 17, -11, -8, -4, -9,
    19, -23, -10, 7, -10, -4, 0, 7,
    -5, 46, 11, -46, -19, -6, -13, 59,
    0, -1, 25, 15, 10, 2, -3, -25,
    -3, 1, 47, -10, -10, 19, 2, 5,
    -6, 28, 17, -6, -23, -5, 17, 7,
    -7, 16, -16, -4, 25, 61, -9, 45,
    10, -32, -11, -19, 2, 16, -10, 31,
    -13, -2, -14, -8, 2, 11, 3, -4,
    -10, 3, 17, 23, 13, -30, -2, 2,
    0, -16, -61, 21, -14, -25, -47, 28,
    -3, 7, 37, -6, -7, 8, -2, -21,
    -29, 3, -7, -44, -16, -9, -18, -9,
    -18, -3, 7, -23, 4, -5, -6, 15,
    20, 52, 26, 3, -28, 32, 14, 12,
    -34, -18, 7, 7, -12, -2, 0, 11,
    10, 30, -18, 58, 11, 6, 5, 25,
    -2, -20, -10, 5, 8, 2, -6, -6,
    36, -29, 61, -67, -3, 4, -1, 42,
    -14, -9, -16, 3, -11, -16, -16, 14,
    -25, 16, 55, -11, 9, -2, -5, 18,
    -6, -3, -12, -29, 3, -1, -12, -2,
    26, -13, 32, -16, 35, -38, 30, -3,
    27, 9, -1, 7, 1, 35, -3, 0,
    -7, 44, -47, 37, 19, 16, -11, -17,
    6, -1, -5, 38, 5, 3, 20, -10,
    35, 0, 48, 13, 20, -74, 34, -27,
    -15, 3, 19, 29, -7, -28, 7, -16,
    43, -7, 19, 16, -2, -8, 25, 6,
    33, -16, 41, -13, 5, 0, 12, -2,
    9, 13, -61, -67, 13, -16, 39, 11,
    -11, -13, 19, -26, 39, 9, -29, -34,
    -5, -8, -11, 52, -3, -22, -6, -10,
    45, 39, -7, 32, 22, -11, -22, 14,
    40, 50, 6, -1, -74, 8, 27, -28,
    24, 1, -6, 6, -3, -25, 1, 39,
    -5, 6, -5, 74, -17, -21, 9, -12,
    5, -19, 19, -17, 13, -11, -5, 17,
    -34, 46, -2, 39, 18, 26, -13, -25,
    -22, -31, -21, 35, -18, 0, 26, -13,
    4, -27, 69, 8, -19, 6, -1, -13,
    21, 6, 29, 10, -27, 8, -3, -14,
    -8, -8, -59, 14, -23, -15, -27, 15,
    5, 20, 8, 16, 20, -11, 14, 5,
    -3, 1, 7, 21, 11, -18, -15, 6,
    -15, 25, -13, -65, 1, 23, -10, 2,
    -20, 30, 2, 19, 21, -49, 4, 10,
    8, 0, -39, -24, 5, -3, -31, 4,
    24, 9, 24, 33, 9, 7, 4, -11,
    20, -10, -5, 10, -4, 7, -18, -4,
    52, 8, 10, -14, -20, -45, 33, 8,
    17, 13, 33, -23, 7, -8, 14, -13,
    5, -15, -28, 24, -6, 7, 7, 6,
    -29, -3, 61, -5, -3, -20, -5, -3,
    23, -23, 29, 59, 10, 43, 0, 0,
    9, 4, -1, -3, -33, -8, -10, 28,
    20, -11, -29, -32, 3, -11, 9, 29,
    17, 5, 21, -14, -1, 2, -7, -6,
    8, 14, 17, -43, 10, -48, -14, -9,
    1, 1, -19, 6, -13, 6, -2, 10,
    1, -33, -14, 54, 15, 20, -29, -10,
    33, 21, 22, 18, -19, 0, -3, -4,
    2, 8, 19, -23, -3, -14, 2, -18,
    -15, 5, -2, -19, -11, 2, -12, -22,
    77, 7, -9, -30, -8, 14, -7, -14,
    55, -5, 6, 12, -30, -9, 8, 7,
    -17, -14, 20, -14, 48, 3, -20, 44,
    -5, 4, -23, -15, -8, -6, 0, -30,
    11, -33, 38, -26, -1, -27, 34, 7,
    -17, 4, -2, 14, 4, 2, 2, -8,
    -35, 13, 36, 14, 31, 5, 30, 15,
    -24, -16, 5, -44, -6, -24, -12, 10,
    -23, -11, 19, 0, 6, 10, 8, 1,
    -35, 24, -6, 6, -10, -4, -3, 1,
    26, 48, -2, -2, 11, 8, -10, -9,
    20, -16, 6, -5, 10, 4, 0, 16,
    68, 31, 5, 12, -18, -16, 5, 10,
    -16, -2, -6, -12, 13, -5, -9, -2,
    -18, 24, 5, -64, 3, 11, 10, -86,
    -9, 20, -16, 2, -11, -8, -23, 2,
    -26, 9, -3, -18, -9, -5, -13, 1,
    22, 28, -3, 3, 5, 14, 2, -26,
    -6, 14, -14, -15, -13, -1, 18, -8,
    -14, 3, -12, 23, -1, 9, -6, 0,
    2, -3, -8, -31, 6, 9, -14, -8,
    -2, -18, 9, -13, 18, 7, 3, -27,
    28, -14, 3, 51, 18, 68, 32, 20,
    -10, 13, -10, 24, -2, 11, -22, 29,
    46, -7, 18, 4, -12, 13, -2, 23,
    -26, -7, 7, -28, 22, -6, -12, -8,
    -8, 28, -16, 29, -43, 35, 30, -37,
    29, -28, 14, -23, 19, -30, 6, -17,
    -49, -45, 5, -124, -24, -20, -8, -15,
    -44, -36, -32, -50, 36, -10, 3, -7,
    -8, -26, 8, 6, 53, -12, 16, 41,
    -16, -1, 6, -4, 3, 11, 14, -19,
    4, 14, 21, 20, -5, 3, 17, -17,
    -5, -4, 1, 5, -9, -10, -27, 8,
    13, 17, 8, -1, 17, 4, -22, 51,
    5, 12, -4, -15, -5, -15, 4, -10,
    8, -21, 1, 3, -16, -16, -3, -32,
    -32, 3, 10, 9, -1, 6, -8, -16,
    12, -4, 44, -36, -1, 74, 1, 0,
    -3, -25, 7, 9, 7, 19, 12, 10,
    66, -10, -57, -5, 5, 10, 6, 18,
    6, 36, -26, 24, -5, -2, 15, 0,
    60, 19, 49, 9, -19, -35, 56, 17,
    10, -11, 8, 32, -8, 7, -23, -23,
    -7, -4, -33, -3, -7, -3, 11, 31,
    -3, 38, -55, -21, -18, 7, 13, 2,
    7, 8, -10, 42, -33, -36, -11, -4,
    -3, -10, 19, 0, 22, 13, -8, -28,
    -52, 11, 19, 9, 18, 5, 6, 5,
    -13, -19, 21, 15, -15, 8, 2, -9,
    35, -7, 3, 48, 54, 24, 23, -18,
    -6, -21, 7, 29, 11, 4, -4, -5,
    27, -6, 25, 51, -3, 2, -11, 16,
    10, -7, -26, -18, -18, -18, 12, 18,
    23, 51, 52, 10, -41, 12, -28, -5,
    -31, -10, -29, -21, -6, -19, 14, 5,
    -8, 14, -18, -47, -4, -14, -10, 0,
    49, 10, -1, -15, 6, 66, 15, 7,
    -37, 7, -10, 37, 0, 25, -21, 8,
    2, 7, 7, 4, 8, -23, 20, 7,
    21, -16, -20, 36, 16, -5, -7, 19,
    52, -9, 37, 1, 0, 8, -18, -26,
    49, 36, 11, 19, 19, -12, 23, 21,
    -11, -2, -15, -17, -14, 4, -8, -2,
    -19, -22, 72, 26, -8, 8, 5, -8,
    10, 5, -9, 55, 0, -14, -8, -9,
    51, -22, 26, -45, -28, 43, -24, -22,
    -19, 4, -15, 33, -7, -1, -13, -5,
    56, -7, 6, -29, -3, 0, -15, -2,
    29, 7, 40, -14, -58, 7, 18, 12,
    43, -45, -13, 13, 12, 38, -44, 0,
    5, -4, -2, -22, 0, 3, 19, -1,
    0, -30, -14, 22, -13, 25, -2, 6,
    -12, -16, 38, -15, 12, -24, 16, 9,
    5, -19, 64, 65, -18, -16, -14, -6,
    -20, -15, 28, 40, 8, 1, -25, 9,
    16, -21, -37, 80, -27, -7, 1, -3,
    -23, -16, -63, 17, 2, -5, 21, 46,
    -38, -11, 27, 18, -7, 48, 21, 22,
    3, -7, -12, 14, -39, -19, 26, -36,
    -31, 127, 69, -23, 28, -17, -33, 39,
    -13, -13, 2, 4, 41, -6, -15, -19,
    44, -43, -22, 26, -40, -11, -47, 13,
    1, -14, 36, -12, 14, -25, -56, 49,
    40, -21, 21, -66, 24, -4, -14, -12,
    -12, -11, -21, 34, -2, 2, -22, 3,
    2, -38, -10, 3, -70, -28, -25, 51,
    6, -1, -25, -68, 0, -47, -18, -3,
    3, -64, 25, -27, 20, 32, -61, 1,
    12, 21, -3, -10, 3, 3, 5, -56,
    48, -66, -54, -72, -5, -55, 32, -61,
    -38, -33, -55, 34, -62, -67, -68, -22,
    -11, 40, -43, -45, -22, 17, -16, 4,
    5, -70, -46, 41, 21, 1, 9, -13,
    27, 41, 3, -3, 94, 22, -63, 43,
    -16, -17, 24, -17, -24, 72, -7, -29,
    -10, -84, 5, -103, 1, -29, 14, 13,
    53, 36, -3, 25, 58, -55, -18, 10,
    1, -25, 27, 18, -43, 35, 34, -22,
    -46, -15, -11, 0, -18, 14, 16, -2,
    -54, 11, -16, -13, -18, -30, -6, -31,
    -59, -21, 25, -51, 42, -43, -7, 4,
    -45, -17, -66, -14, 14, -92, -20, 64,
    7, -69, 51, -50, -17, 48, -14, -2,
    9, 84, -13, -11, 2, -1, -8, -31,
    69, -4, 6, 41, -47, 37, -8, -36,
    -29, 42, 13, 49, 10, 42, 26, 53,
    -17, -4, -2, 13, 6, 11, -49, 0,
    14, 22, -28, 61, 0, -10, 3, -6,
    -32, -51, 6, 27, -4, 5, -36, -6,
    6, -44, 60, 36, 26, -50, 47, 53,
    45, 0, -101, -10, 12, -18, -9, -9,
    34, -17, 35, -32, 8, -13, -12, -17,
    38, -36, -73, -44, 9, -9, -7, -3,
    -22, 10, -24, -43, -9, 43, 31, -18,
    33, -74, 39, 18, 2, -5, 1, 24,
    -21, -43, 70, 12, -26, 32, 2, 0,
    -12, -56, 52, -36, -2, -60, 7, -6,
    -50, -26, 19, -9, -47, 13, 28, -87,
    29, -26, -18, 4, 18, -29, 9, 44,
    9, 20, 31, -3, 13, -17, 5, 5,
    25, -39, 24, -22, 13, 2, 7, -26,
    -26, -10, -22, -43, -68, -42, 20, 0,
    23, 12, -4, -24, 34, -29, -2, -18,
    70, -2, -50, -59, -12, 2, -23, 31,
    90, -75, 26, -46, -24, 6, -4, 20,
    -32, -3, -28, 37, 0, 73, -64, 11,
    -9, 1, 24, 22, -14, 32, 14, 22,
    -14, 19, 31, -51, 21, 17, 10, -7,
    -59, -10, 25, -23, -27, -1, 39, 18,
    22, 0, -6, 9, -30, 0, 28, -65,
    -5, 11, 3, 8, 20, -22, 8, 16,
    36, 42, -50, 57, 21, -39, 52, -28,
    32, -70, -14, -11, 6, -11, -30, 8,
    -47, 13, 26, -6, 31, 6, -6, -44,
    -16, 6, 1, -9, 0, -13, -20, 13,
    -33, -20, 48, -95, 27, -3, -13, -1,
    -12, 54, -27, -19, 6, 5, 17, 7,
    -36, 40, -47, -2, -39, -14, 4, -19,
    95, -11, -8, 0, 21, 11, 7, -3,
    6, 11, 1, -21, -58, 5, 10, 15,
    54, -13, -38, -16, 43, -32, 1, 11,
    -40, 26, 27, 77, -98, 23, 20, 52,
    -122, -7, 4, -22, -54, 3, 5, 5,
    6, 30, 8, -73, -1, -1, -6, -8,
    21, -31, 1, -9, 12, 40, 18, -87,
    100, 6, -18, 11, 23, 7, 51, -22,
    1, 19, -8, 0, 39, 26, 27, -10,
    1, -41, -27, 29, 1, -19, -13, 3,
    28, -16, -51, 7, 10, 27, -4, -32,
    41, 13, 6, 20, -4, -54, -62, -42,
    -18, 90, -8, 1, 13, 10, -6, 17,
    -6, 6, -1, 86, -12, 43, 10, 11,
    16, 37, 40, 36, 52, 8, 6, -17,
    17, 42, 71, 9, -57, 45, 5, 10,
    -34, 3, 8, 20, -13, -23, 40, 18,
    -26, 10, -37, 1, -31, -5, -1, -20,
    24, -18, -14, -77, 111, -13, 6, 19,
    63, 28, -19, -5, -72, -29, -22, 54,
    40, -7, 54, -3, -11, -34, -21, -30,
    35, -56, 10, 11, -30, 7, 26, -22,
    19, -12, 43, -21, -2, 31, -41, 1,
    -37, 22, 59, -30, 47, -38, 13, -58,
    -5, -2, -20, 48, -7, -11, -5, 37,
    126, -3, -39, -54, -57, -72, 5, -33,
    -72, -57, -12, 55, -19, 11, -3, 36,
    25, -16, -9, -47, 19, -103, 58, -63,
    35, -20, 12, 4, 22, -30, 35, 36,
    21, 91, -26, 60, 41, 2, 19, -6,
    -25, -72, 46, 28, 25, 6, 59, 6,
    3, 27, 55, -120, 17, -31, -35, -53,
    6, 18, -38, 6, -5, 9, 8, -23,
    -11, 25, 88, 29, 14, 1, 15, 50,
    -24, 22, 81, -10, -11, 47, 49, 24,
    39, -1, -22, -2, 25, -18, -5, -8,
    -16, 6, 19, 1, 54, -1, -2, -10,
    -8, -70, -35, -6, 9, -1, 22, 10,
    -25, -13, 18, 23, -13, 8, 18, -12,
    18, 40, 29, 41, -24, -12, -41, -25,
    3, 3, 21, -23, 21, 23, -5, -5,
    61, 49, 21, 67, -2, 26, -15, -1,
    62, -13, -17, 14, 1, 9, 39, 25,
    -9, 12, -21, -7, 36, 68, 0, 31,
    -2, -6, 10, -3, 8, -45, 26, 7,
    3, -42, -38, -46, -9, 5, -33, 3,
    -26, -36, 17, 14, -5, 116, -9, -1,
    -65, -8, 5, -56, -59, -26, 5, -4,
    27, 20, -10, 6, -24, -27, 1, -3,
    -58, 32, 21, -16, -15, -9, -17, -4,
    -52, 34, -32, -32, 5, 10, 17, -11,
    29, -27, -13, -58, 12, -3, -54, -72,
    7, -11, 56, 32, -8, -36, 5, -37,
    -2, 30, 30, 12, 2, 9, -24, 5,
    -8, 11, 64, -64, 9, -46, -27, -13,
    22, -58, -20, -22, 47, 67, -1, 67,
    -20, -4, 4, 68, -48, -38, -30, 8,
    9, -26, 41, 43, -4, -6, 0, 11,
    -10, -25, -11, -4, -119, -10, 45, 60,
    -46, -16, 2, -1, 24, -48, 30, -41,
    9, 24, 49, -21, 13, 10, 24, -21,
    -11, 40, -66, 45, -7, 54, 4, 10,
    -15, 14, -74, -54, 0, -13, 11, 4,
    -35, -4, -54, -35, -18, 6, 31, 16,
    2, -55, -17, -6, -25, -30, -29, -6,
    -3, -6, 9, -7, -10, 11, -6, -9,
    -29, -35, 16, 51, 12, 6, -6, -12,
    1, 0, 12, 17, -10, 4, 1, 19,
    21, -18, 5, -7, 4, -2, 11, 5,
    -12, -6, -24, -30, -26, -29, 15, -26,
    34, -14, -32, 28, -21, 39, 10, -12,
    21, 19, -8, -26, 12, -22, -33, -23,
    5, 33, 29, 1, -37, 4, 19, -9,
    8, 11, -4, 2, -9, 24, 3, 13,
    -61, -40, -21, -17, 21, -11, -1, 6,
    26, 5, 46, 0, -7, 16, -3, 17,
    10, -8, 28, -32, 11, -28, 35, 11,
    -28, -17, 5, -3, -10, -11, 3, -8,
    14, -4, 14, -46, -38, -1, -10, 11,
    1, 23, -23, -3, 39, 0, -33, -22,
    11, 30, -23, 21, -16, 5, -13, 22,
    6, -25, 5, -10, 21, -2, 11, 28,
    -42, -4, -30, 9, 26, 20, 10, -13,
    -15, -25, -41, -12, 14, -4, 5, -17,
    37, -2, -8, -1, -8, 5, 27, -26,
    1, -6, 8, -16, -3, 1, -19, -29,
    -4, -68, -19, -24, 8, 1, -38, 3,
    5, 7, -2, 20, 47, -40, -31, 42,
    -21, -35, 0, -11, -31, -34, -26, -31,
    -20, 10, -6, 2, -28, 2, -16, 3,
    -20, -33, 18, 39, 1, 12, 20, 20,
    12, 32, -21, -42, -23, 41, 14, -38,
    2, 29, -20, 1, -21, -11, -9, -14,
    -1, 30, -2, 2, 17, -11, 5, 12,
    44, 17, 54, 28, -15, -5, -9, 56,
    10, 19, 15, -20, -18, 9, -8, 56,
    18, -16, 6, 33, 7, 36, 19, -9,
    -2, 16, -43, 11, -15, 19, -25, 39,
    44, 47, -14, 54, -14, -17, -7, -11,
    -6, 4, 6, 23, -13, -8, 32, 32,
    20, -13, -3, -10, 3, -51, 6, -4,
    -7, -12, -14, 18, 6, -12, -18, 4,
    -15, -21, -44, 11, -19, 45, 21, 16,
    -16, -15, -20, 28, 64, -30, -16, -21,
    8, 15, 17, 7, 0, -5, 8, 20,
    28, -33, -36, -11, 33, -5, -8, -10,
    -22, 13, 4, 22, -17, 6, -17, 20,
    13, 14, -20, 6, -8, 29, 33, -33,
    0, 17, -17, 0, -3, 2, -26, 10,
    -25, 4, 7, 18, 2, 11, 6, 23,
    11, -23, 26, -1, 38, 22, 9, -4,
    -40, -28, -2, 30, 15, -15, 3, -25,
    -27, 10, 3, 5, -7, -27, 10, 14,
    -4, -3, -19, 4, 30, -4, -9, -15,
    15, 5, -1, -14, -28, -9, 21, -2,
    22, 4, 12, 8, -44, 1, 8, 6,
    -11, 4, 4, 22, -12, 10, 14, 32,
    -6, -10, 17, -18, -18, 8, 2, -38,
    -39, -31, 24, -26, -27, 10, -14, 21,
    11, -7, -28, -8, 13, 7, -9, 11,
    -4, -1, -10, 11, 4, 18, 7, -23,
    -26, 1, -14, 1, -20, -48, -12, 6,
    22, -1, -44, 28, 6, -17, 3, -2,
    20, 2, 34, 1, 25, 0, 10, -25,
    -44, -2, -4, 23, -7, -7, 28, 3,
    1, -7, -49, -22, 2, 20, 3, -27,
    9, -33, 13, -22, -6, -10, -4, 19,
    -33, -29, 8, -21, -17, -22, -10, -11,
    -4, 1, -14, 16, -3, -32, 7, 20,
    22, -34, 3, 0, 21, -46, 16, 7,
    14, -2, -46, -11, -1, -11, 25, 12,
    -17, -33, 6, 18, -12, 48, -29, 16,
    15, 9, 24, 12, 13, -6, -12, 22,
    -1, 4, 4, -16, 16, 16, 5, -8,
    25, 10, -19, -38, -10, 15, -1, 7,
    -17, -18, -5, -7, 10, -27, 8, 12,
    -21, -18, 11, 36, -2, -42, 11, 6,
    -24, 28, -7, -16, -5, 6, 5, -2,
    -34, 40, -3, 28, -7, -2, -2, -30,
    13, 6, 56, 22, -20, 25, 12, -1,
    -12, 40, 16, 0, -11, 12, -1, -23,
    22, 9, -10, 0, 23, 5, 24, 46,
    -4, 53, 24, 23, -13, -11, 7, 27,
    29, 4, -26, 28, -21, 46, 15, -3,
    8, -9, -21, 27, -2, 1, -22, 8,
    -19, -4, 18, -9, -11, -12, 16, 2,
    -5, 28, -27, 18, 4, -8, 0, -16,
    -31, 6, 24, 24, 48, 10, 25, 16,
    29, 28, -12, 1, -2, -14, 2, 13,
    -37, -15, 10, -10, -11, 17, 5, 24,
    37, -4, 10, 8, -20, 9, 6, -27,
    -25, -18, 12, 16, -14, 19, 13, -30,
    20, 2, 4, -11, 34, 23, -24, -17,
    17, -4, 19, 5, -19, -3, 24, -6,
    -7, 42, -13, 16, -9, -5, -15, 21,
    39, 15, -37, 15, 4, 25, -14, 14,
    -1, 26, 40, 8, -15, -22, 21, -7,
    -27, 0, -2, 15, 3, 3, 1, 37,
    74, 22, 18, -32, -32, 47, -26, -23,
    -19, 43, -9, 18, 2, 9, 46, 24,
    -3, -22, 13, 16, -36, -3, 13, 10,
    9, 23, -31, 2, 6, -3, -7, -3,
    -37, -30, 10, -25, -63, 7, 55, -10,
    -2, 42, 5, 8, 5, -10, -17, 5,
    -30, 19, 26, 13, -19, 7, -9, 2,
    7, 4, 0, 1, 25, -10, 5, 0,
    -27, -22, -86, -24, -7, 25, -8, 5,
    7, 6, -16, 10, 14, 14, 17, 11,
    2, -1, 6, 15, -14, -48, -12, 9,
    6, 3, 9, -2, 8, 27, 37, 4,
    15, -9, -1, -39, -14, 21, -5, 22,
    -20, 23, -10, -1, 20, -28, -56, 8,
    -3, -15, 6, -19, 12, -9, 7, 14,
    37, 4, -28, 18, 18, 10, -28, 8,
    -30, 12, 43, 4, -2, -1, -12, -9,
    39, -33, -1, 4, 3, 15, 3, -15,
    37, 1, -13, -3, 40, 13, 6, -16,
    5, 16, 11, 11, -58, 6, 20, -11,
    15, 0, -11, -19, 2, 8, 16, 27,
    7, -26, 27, 22, -9, -6, -9, -42,
    -37, -12, 0, 21, -27, -5, 26, 8,
    11, -24, 5, -11, 17, -19, -18, -28,
    -24, 13, -2, -1, 20, -2, -36, 1,
    30, 29, 15, -28, 37, 12, -31, 26,
    -17, 27, -12, -3, 8, -3, -10, -27,
    10, 11, 1, 7, -19, -6, -10, 28,
    36, -5, 43, 15, -5, -28, 4, -10,
    -28, 17, 3, -41, 7, -25, -11, 13,
    -10, -15, 11, -9, 12, -2, 0, 23,
    -1, -70, 15, -3, 10, -13, -8, -4,
    -7, 57, -14, 15, 21, 17, -11, 9,
    29, -5, 9, 37, -25, 6, 2, -22,
    15, -35, 56, -22, -41, -16, -22, -5,
    1, -5, -30, 33, 36, 1, -3, -13,
    -35, -34, 71, -9, -8, 8, 16, -14,
    50, -63, 6, 5, -28, -31, 20, 1,
    -3, 13, 19, -10, -22, 21, 0, 6,
    0, 33, -4, 13, -43, -10, 29, -17,
    -18, 9, 38, -62, 11, 15, -18, -1,
    -22, -13, -44, -10, 3, -16, -75, -25,
    -37, 28, 24, 2, 20, 8, 64, -37,
    8, 5, -19, 10, -16, 30, -28, 25,
    9, -5, -26, -4, 10, -11, -12, -3,
    5, 0, 22, -55, -10, -23, -4, 71,
    -8, -27, -28, 5, -22, 11, -20, 6,
    -17, -2, -4, -6, -1, -15, 27, -6,
    -28, 3, 9, -26, -8, 0, -27, 38,
    -8, -13, -56, -37, 55, -12, 10, -1,
    16, 13, 40, 9, 19, -15, 18, 34,
    3, 12, 16, 14, 3, -10, 13, 22,
    1, 35, -27, 20, 18, 13, 34, 12,
    -24, -43, 19, 11, 41, -24, -25, -34,
    5, -39, -13, 45, -4, 1, -2, 14,
    -9, 16, -1, -33, 13, 0, -11, 19,
    -12, -28, 6, -47, 10, -17, 29, -2,
    -43, 25, -4, -23, 8, 8, -25, -19,
    -10, -33, -13, -16, -20, 4, 9, 9,
    -3, 18, 1, 21, 24, 20, -9, -10,
    8, 9, 25, 17, -36, 21, 16, 2,
    -18, -40, -35, 14, 18, -68, -16, -2,
    -40, -89, -27, 7, 2, 21, 30, 7,
    -31, 29, -2, -31, 16, -4, -22, 15,
    43, 5, 11, 17, -33, -10, 36, -46,
    15, 31, 14, 9, -2, 24, 28, 56,
    7, -42, -2, -14, 8, 4, -5, -30,
    -10, -30, 1, 4, 10, 31, 4, 6,
    25, 20, 34, 14, -15, -21, 14, 15,
    8, 30, 33, 10, -26, -30, 40, 17,
    -3, 26, 17, 3, 15, -23, 16, 26,
    14, -8, -15, 14, 17, -2, 0, -13,
    -25, -1, -36, -3, 32, 21, 10, 12,
    -47, -43, -12, 20, -5, 44, -23, -9,
    -36, 27, 31, -27, 17, -79, -55, 6,
    -14, -18, 34, -26, 9, 8, 11, -13,
    62, 14, -52, -39, -89, 12, -29, 21,
    18, 20, 14, 21, 19, 22, 11, -2,
    26, 21, -5, -24, 28, -19, -10, -26,
    4, 8, 17, 11, 1, 5, 3, -8,
    -9, -20, 17, 33, 5, -13, -4, -10,
    -20, 27, -36, -20, 21, -8, 25, 37,
    -33, 15, -10, -1, 11, -19, 16, -16,
    35, -15, -22, -40, 32, 2, 9, -6,
    49, -47, 49, -77, -27, 0, 4, 39,
    -6, -45, -39, 23, -11, 8, -28, -51,
    24, 12, -30, 8, 25, 30, 52, 15,
    -20, 15, 33, -3, 14, 18, 0, -21,
    -10, -20, 18, 19, -11, -5, -17, 16,
    -10, -10, -25, -24, -2, -4, -20, -21,
    -14, 13, -28, -25, 23, -12, 45, 26,
    -7, -9, 0, -10, -33, -4, 20, 35,
    34, -10, -16, -40, -9, -13, -21, -33,
    13, -7, -14, -1, 68, -34, -24, -24,
    -11, 13, -2, 0, -12, 6, 8, 1,
    -21, 7, 6, -18, 22, 5, -22, 8,
    3, -27, -10, -30, -24, -13, 7, -5,
    -81, -13, -14, -16, 7, 35, 14, -8,
    -7, 12, -32, 20, 2, 33, 1, -18,
    33, 8, -8, -19, 2, -34, 9, -6,
    5, 19, -21, 37, 19, 13, 18, 17,
    -19, 0, -15, 10, -20, 34, -23, 35,
    9, 31, -27, 14, -4, 28, 9, 0,
    4, 13, 3, 4, -2, 29, -12, 32,
    4, -33, -40, 26, -7, -6, -9, -15,
    12, -32, -7, 4, -4, -10, -7, -17,
    8, 6, 10, 0, 16, 3, -13, -4,
    -16, 7, 5, -17, -3, 10, 14, 4,
    -61, 11, 7, 21, -8, -7, 7, 12,
    3, 28, 35, 15, -37, -34, 32, -1,
    -22, 46, 41, 9, 19, -8, -38, -40,
    23, -30, 3, -11, -19, -27, -5, 14,
    -14, -78, 29, 33, 23, -57, 32, -10,
    24, 12, -37, 2, -5, 15, 27, 36,
    16, -10, -39, -2, 44, -2, -27, 33,
    -17, -4, 31, -9, -2, -13, -9, 11,
    17, 48, 9, 47, -30, -19, -7, -31,
    -27, -30, 17, 20, -10, 21, 4, 3,
    -24, 11, 27, 2, -7, 5, 7, 18,
    3, -7, 35, 9, -39, 7, -2, 4,
    12, 8, 39, 15, -10, -23, -36, -38,
    -22, 5, -51, 39, -18, -24, -7, -18,
    3, -33, -21, 34, 7, -17, 6, 36,
    0, -12, 5, 1, 14, -12, 12, 3,
    -3, 30, 31, 20, -15, -32, 16, 38,
    -33, -4, -76, 22, 3, -67, 8, -30,
    11, 19, -45, -14, 31, -26, 42, -8,
    -30, -4, 5, 12, -2, -28, 9, -5,
    46, 22, 22, -6, 27, -27, -51, -45,
    -22, 5, 37, -96, -11, 6, 8, -7,
    4, -11, -3, -15, 11, 13, 4, 37,
    -25, 31, 2, -22, -7, 5, 4, 24,
    9, -12, -26, -4, 9, -26, 42, -38,
    -11, 16, -10, 23, 41, -23, 19, -4,
    -35, 19, -2, -6, -13, 41, 11, -11,
    -16, -8, -7, -2, 28, -15, 20, -3,
    -41, -29, -78, 5, -6, 34, -3, 12,
    29, -14, 13, -42, 8, 18, 51, 31,
    7, 12, 28, 15, 2, 15, -17, 12,
    -6, -5, 8, 22, -12, 18, 13, -7,
    38, 18, 26, -19, 1, -35, 9, 11,
    -1, 9, 0, 35, 26, 17, -60, 4,
    -14, 17, -25, -16, 49, -6, 3, 7,
    -14, -16, -2, 11, 1, 2, 1, -9,
    -9, -22, -9, 4, 20, 41, 3, 35,
    -23, -11, 17, -5, -30, 0, -9, -19,
    -14, 4, 13, -43, -20, 20, 8, 5,
    -14, 16, -22, -21, -4, 4, 31, -13,
    -41, 5, -4, -18, -10, 0, -5, -31,
    21, 8, -21, -58, -9, -15, -5, -20,
    -4, 10, -24, 13, -12, 23, -15, 51,
    9, 3, 26, 2, 21, -17, -24, -26,
    36, 34, 30, 7, 27, -18, -7, -3,
    -15, 35, -14, -30, 14, -24, -24, 62,
    -8, 32, 21, 54, 48, 33, 11, -18,
    -16, 8, -22, 28, -25, -9, -16, 34,
    69, -4, 6, 42, -24, -27, 3, -10,
    -26, -14, -29, -30, -5, -63, 14, 27,
    -26, -24, 15, 17, 11, 10, 0, -6,
    -12, -6, 8, -17, -10, -16, -2, 22,
    -13, 7, -7, 20, 23, 3, 1, 4,
    -14, 6, -41, -2, -54, 0, -101, 67,
    13, -17, -38, -19, -2, -16, 8, 20,
    23, 14, -3, 18, 29, 6, 13, 46,
    38, -31, 115, -56, -10, 13, -78, 5,
    17, 5, 61, -47, -4, 41, -26, -34,
    -20, 0, 52, -67, -22, -6, 43, 18,
    16, 27, -18, 49, 72, 57, -19, -19,
    -13, -31, 15, -5, 11, 21, 33, -2,
    -45, 22, 56, 34, 34, 11, 26, -35,
    22, 22, -28, -49, 3, -34, 8, -44,
    -26, 3, 60, -25, -4, 33, 1, 5,
    -10, -61, -123, 72, -15, 1, 22, -11,
    26, 40, 23, -9, 8, 58, 24, -4,
    -8, -61, -25, -33, 37, 7, 28, -26,
    -2, 76, -31, 3, -19, 40, -61, 37,
    3, -46, -29, 121, -19, -19, 45, -33,
    -20, -12, -12, 18, -13, -114, -54, 0,
    -80, -17, -13, 41, 35, -127, -71, -40,
    -10, 48, -10, -1, 7, 3, -13, -34,
    74, -4, 50, -63, -47, 31, -15, -24,
    -58, 6, -6, 10, 30, -25, 43, -33,
    -63, -5, 50, 40, 12, -30, -20, -33,
    11, -23, -49, 44, -12, 34, -14, 61,
    31, -22, -38, -84, 6, 45, -78, -17,
    -35, -30, -4, -15, -16, 72, 10, -24,
    19, -15, -15, -6, 62, -42, 9, -7,
    18, 0, 16, 6, -29, -9, -17, -1,
    97, -84, 35, 56, 22, 4, 8, 26,
    7, -47, 20, 36, 127, -5, -27, 25,
    16, 9, -48, -61, 60, 25, -20, 29,
    -25, -5, 15, 32, 9, 14, 6, 19,
    -22, 28, 53, -102, -21, 21, 59, 28,
    5, 11, -23, -6, 23, 44, -28, 23,
    -33, 59, 40, -12, 13, 9, 27, 17,
    -5, -37, 36, -2, 19, -32, -8, -78,
    10, 3, 117, -10, -11, -66, -45, 18,
    7, 21, 74, -1, 21, -30, 81, 15,
    14, 14, 10, 4, 20, -42, 32, 16,
    14, 9, -21, -20, 28, 18, 17, 8,
    -47, -22, -27, 53, 39, 9, 11, -14,
    -5, 32, -8, 20, -8, -2, -28, 60,
    38, -11, 1, 17, 50, 10, 3, -21,
    -43, -30, 23, -20, -39, -24, 45, 21,
    -17, 75, 5, -80, 40, 61, -21, -19,
    7, -30, 41, 6, 1, -22, -20, -27,
    38, -61, 46, -21, 13, 23, -14, 51,
    36, -6, 22, -71, 10, 11, -4, -33,
    26, 25, 1, 76, -19, -54, 11, -55,
    94, 35, -36, -23, -10, 44, -14, -28,
    8, -22, 10, 0, 4, -1, -33, 22,
    -67, -62, -11, -4, -41, 73, -17, 2,
    73, 47, 9, -112, 44, 35, 5, 13,
    -4, -21, 8, -40, -14, -49, 63, -19,
    -31, -5, 67, 35, -35, -31, 23, -21,
    27, 18, -35, 9, 4, -70, -2, 45,
    -34, -23, -68, 22, -58, -6, 27, 0,
    -47, 4, 0, 114, 7, 25, 106, -34,
    -11, -32, -2, 15, 9, -55, 5, 17,
    40, -4, -46, -18, 38, 40, 25, 7,
    27, -32, -35, 31, 9, -29, 12, 38,
    -1, 22, -4, -31, 61, -9, -35, 39,
    -32, 65, -48, -36, -67, 33, 28, 7,
    -10, 0, 23, 12, -18, -21, 49, 19,
    -10, 15, -48, -48, -8, 12, 41, 19,
    20, -8, 17, -31, 1, -5, 24, 12,
    0, -33, 27, 52, -26, -63, -58, -9,
    14, -6, 17, -8, -49, 40, 24, 16,
    -76, 23, -105, 31, 12, -50, -35, 10,
    -81, -7, 16, -17, -61, -68, -11, 25,
    -16, -25, 34, -10, -30, -47, -5, -16,
    18, -6, -4, 14, -15, 1, -21, -45,
    -35, -18, -3, 53, -52, 21, 13, -56,
    53, -28, -27, -17, -10, 42, 5, -110,
    9, 7, 13, -5, 22, 10, -10, -9,
    -35, -8, -12, 9, -22, -2, 21, -6,
    -23, 9, 28, 70, -36, 12, 11, -30,
    59, -52, 36, -78, -3, 72, 10, 42,
    23, -8, -33, 14, -15, 39, 18, 25,
    4, -21, 23, -9, 3, 4, -39, -26,
    28, -38, 1, -54, 40, -12, -14, -9,
    -39, 7, -16, 26, -47, -41, 4, -21,
    8, 52, 26, -2, -12, -10, 65, 38,
    54, -9, -11, -10, -44, -36, -36, -52,
    -6, 20, 78, -1, -37, 16, 12, -3,
    -17, 30, 16, 17, -8, -34, -9, -4,
    -2, -41, 18, 16, 33, 50, 6, 25,
    6, -6, 9, 10, -45, -30, -19, 35,
    110, -10, 61, 62, 33, -48, 37, -32,
    18, -50, -32, -2, 12, -11, -22, 5,
    16, -39, -20, -40, -94, 63, -8, -49,
    -7, 25, 11, 58, 34, 6, -19, 34,
    -11, 82, 11, -69, -53, -4, -40, -8,
    -25, -3, 16, 2, 74, -82, 65, 15,
    1, -33, 38, 23, -42, 15, 28, 12,
    38, -11, -49, -31, -15, -7, -20, -4,
    -14, 29, -81, 8, -46, 18, 26, 50,
    34, -43, 42, 2, -49, -17, -24, -51,
    -35, 31, -22, 18, -24, 23, -13, 6,
    32, -29, 4, -15, -75, 0, -48, -46,
    -74, 123, -88, -37, 34, -1, -39, -9,
    6, -9, -63, 23, 19, 38, 23, 20,
    -49, -27, -43, 11, 26, -22, -33, -12,
    -25, 9, -48, -7, -26, 26, -14, -15,
    -25, -91, -42, -27, -11, 35, -17, 2,
    56, 34, 11, 53, 30, -65, 18, 2,
    -74, 0, 9, -7, 1, 53, -5, 28,
    40, -18, -23, -15, -2, -49, -32, -65,
    -44, -36, 41, -85, -16, 1, -1, 40,
    -38, -17, 46, -32, -20, 25, 19, 67,
    -14, -29, 59, -12, -24, -10, -43, -34,
    20, 32, 12, 8, 29, 12, 30, 11,
    28, -77, -100, -29, 83, 46, 29, 23,
    46, -25, 69, -26, 17, 37, -11, -21,
    12, 9, 18, 9, 8, -12, -25, -15,
    -29, 2, -25, -24, 69, -17, 9, 4,
    16, 16, -1, -43, -25, -12, -23, -28,
    3, 35, 7, -44, -35, 11, 10, 3,
    49, 31, -23, -25, 4, -9, -21, 9,
    10, 11, 0, 16, 14, 19, -21, 40,
    -28, 68, -3, -28, 24, -10, -39, -11,
    -2, 14, -17, 3, 94, -36, 2, -52,
    3, 1, 29, 47, 17, 30, 40, 17,
    5, -17, 11, -66, 22, -37, 21, -71,
    89, 18, -42, 2, -50, -25, -4, 27,
    -17, -15, 9, 32, 6, 21, 12, -1,
    13, 34, -26, 6, -43, -46, -1, -6,
    -3, -21, 14, -6, 33, 13, 27, 21,
    -26, -89, 3, 5, 35, -46, -21, 8,
    -7, 3, 6, 12, 32, -13, -30, 17,
    3, 2, 17, 5, -3, -4, 3, 11,
    -31, -27, 7, -16, 7, -16, 22, -4,
    6, 18, 29, -8, 16, 1, 24, -49,
    -2, 29, -13, -30, 28, 6, 3, 6,
    -14, 5, 6, -22, -11, 1, -1, -17,
    9, 4, 9, 14, 2, 7, -4, 15,
    7, 11, 26, -1, -34, 17, -2, -1,
    -5, 15, -40, 3, -34, -30, -17, 1,
    -28, 9, -6, -27, -3, 7, -7, -6,
    -17, -1, -22, -1, -1, -1, -13, 6,
    -15, -11, 7, -15, 17, 38, 15, 7,
    -31, 26, -27, 21, 21, -16, 10, -43,
    -11, -2, -63, -8, -9, -3, 0, -6,
    -16, -22, -30, 7, -26, 10, 17, 24,
    -23, -23, -9, 22, 4, -6, 28, 19,
    37, 35, -24, 23, -15, -24, 2, -14,
    -4, -7, 15, -20, -12, -3, -8, 3,
    10, 0, -16, 14, -1, 55, -55, 4,
    3, 15, -34, -9, -29, -23, -16, 45,
    0, 63, 10, -24, 11, -24, -5, 24,
    21, 5, -34, 16, 20, -1, -12, -5,
    -11, -22, -15, 0, 16, -23, -20, 24,
    -12, -29, 1, 54, 4, -43, 22, -59,
    18, 7, 8, 23, -21, -10, -11, 2,
    -17, 36, 7, -19, 17, -3, 0, -4,
    16, -36, 2, 4, 25, -15, 2, -25,
    44, 6, 0, -26, 6, 29, -23, 19,
    0, 31, -5, -3, 15, -14, 10, 8,
    42, 8, 10, 8, -6, -14, 4, -4,
    -8, 12, -12, -54, -48, 11, 18, 4,
    -3, -22, -16, 3, -45, -24, -3, 58,
    -4, -29, -9, 12, 47, -4, 5, -11,
    -9, -31, 11, 1, -5, -10, 3, 3,
    -17, 0, -10, -26, -18, -9, 25, -2,
    5, 14, -12, -4, -32, 24, 1, -20,
    -21, -2, -1, 1, 27, 15, -5, -26,
    -18, 25, 10, -10, -10, -1, 7, 9,
    0, 3, -12, 21, -3, -2, -3, -8,
    33, -54, 0, 6, -4, -15, 7, -33,
    -19, -43, -60, 3, 17, -22, -21, -11,
    7, 16, -6, -9, 10, 5, 3, -3,
    -9, -3, 10, -8, -32, 14, -6, 6,
    -15, 9, -13, -3, -17, -8, 19, 35,
    5, 27, -25, 12, 14, 22, -5, 16,
    -10, -17, -11, 2, -6, 3, 4, -3,
    12, -11, 21, 20, -12, -9, 3, -4,
    0, 2, 12, -23, -25, -4, -33, -34,
    -11, -17, 25, 15, 26, -17, -30, 19,
    -9, 17, 8, 1, -1, -4, 3, 4,
    8, -46, 4, -15, -2, -10, 0, 8,
    4, -20, 6, -24, -12, 8, -20, -5,
    3, -14, 6, 2, 21, -5, 20, -6,
    25, 5, -16, 7, -1, 2, 5, -5,
    -7, 8, 4, -8, 4, 5, -11, -2,
    22, 23, 11, 21, -17, -40, -36, 11,
    -33, 3, 21, -31, -20, 20, 35, 33,
    -3, -14, -37, 22, -12, 19, 4, -12,
    27, 18, -11, 24, 0, -2, -2, 10,
    45, 23, 26, -3, -59, 38, 0, -36,
    -19, 22, -21, 4, -12, 15, 38, -1,
    4, 1, -5, 0, -4, -3, -8, 0,
    51, -11, -21, 13, -19, -20, -7, -17,
    -54, -15, 17, 3, -17, -4, -22, -1,
    -32, 46, 2, -5, 0, 26, -2, -29,
    29, 20, 8, 5, -14, 6, -2, -2,
    11, -31, -11, 26, -5, -38, -3, 2,
    0, -5, -7, -35, -10, -42, 41, 22,
    9, -9, 7, -20, 16, -39, -45, -2,
    0, -6, 22, 16, 6, -4, 1, 13,
    1, 9, 29, -27, 8, 48, 0, 19,
    -9, 45, -7, -40, 3, 28, 27, 28,
    17, 22, -33, -12, -16, 34, -15, -9,
    -48, 26, 18, 6, 7, 7, -4, -4,
    10, 2, -3, 40, 32, -18, -19, -25,
    -4, -18, 1, -10, 5, 11, 26, 13,
    -16, -58, -36, -44, -13, -11, 7, -20,
    3, 10, 3, 1, -2, -1, 7, -4,
    12, -21, 16, 6, 5, -9, 5, 23,
    -2, -2, 9, 14, 9, -44, -29, 36,
    3, -18, -17, 4, -8, -30, 10, -16,
    -14, -5, -5, 2, -15, 6, 2, -7,
    14, 25, -25, 18, 19, 31, -24, 2,
    6, -10, 20, -13, 9, -21, 23, 18,
    -60, -2, -29, -11, -9, -12, 7, 0,
    -15, -8, 18, -9, 4, -12, -9, -14,
    7, 46, 15, -2, -21, 23, -14, 27,
    -24, -23, 2, -21, -27, -7, -24, -24,
    18, 18, 3, 15, -24, -9, -19, -4,
    -13, 2, 15, 15, -7, -7, -2, -16,
    -26, 16, -5, -20, -9, -4, -6, 21,
    -2, -12, -7, 3, 43, 16, 4, 4,
    -5, 42, -36, 11, -11, 18, 10, -9,
    -3, 13, -17, 1, -6, 7, 6, 4,
    22, 37, -17, 9, 29, -12, -8, -2,
    43, 6, -19, 5, -43, 50, 34, -32,
    19, -12, -2, -3, 32, -1, 31, 19,
    -1, -6, -2, 14, -10, 9, -2, 3,
    -4, 15, 9, 10, -28, 4, 9, 3,
    -32, 1, 17, 23, 47, 11, -7, -13,
    -20, 41, 2, 19, 4, 11, 8, -73,
    12, -12, 8, 6, 5, 1, 0, 3,
    16, -14, -7, 29, 21, 0, -1, 3,
    -25, 12, 9, -4, 42, -37, 6, 5,
    24, 9, 17, 16, -26, 46, -8, -13,
    10, -2, -8, -23, 12, -1, -2, 3,
    -20, -23, 24, 26, 1, 11, -6, 10,
    -6, -10, 7, 13, -63, 13, -7, 9,
    2, 7, 8, -20, -18, 15, -10, -7,
    -8, 2, -7, 1, 8, -4, -7, -3,
    -60, -16, -14, 13, -2, -18, 23, 11,
    1, 4, 0, -29, 49, 8, -10, 1,
    1, 1, 21, 4, -2, 17, 8, -11,
    -10, -11, 7, 20, 3, 0, 9, 9,
    -38, 8, -11, 9, 4, 12, -20, -5,
    9, 24, 12, -4, 38, -14, 13, -5,
    33, 35, -5, 10, -14, 11, -6, -8,
    15, 3, -9, 1, 4, 11, -5, 5,
    13, -13, 19, -32, 9, -5, -19, -24,
    4, -16, 9, -5, 12, -32, 19, -10,
    -6, 3, -26, -60, -30, 54, -1, -25,
    -9, 31, 26, 0, 7, 4, -13, 7,
    -3, -17, 14, 16, 4, -26, -5, -21,
    30, -15, 13, 25, -19, -10, -26, -7,
    52, -47, -17, 29, -5, 24, 18, 17,
    12, 1, 0, -5, 6, -12, 5, -6,
    5, 17, -2, -9, 1, 18, 3, 1,
    -6, 32, 20, -21, 7, -6, 11, 28,
    6, 21, 24, 34, 47, -1, 6, 10,
    13, 10, -24, 2, 0, 5, -3, 21,
    -1, -27, 16, -21, 7, -27, -29, 16,
    10, 20, 26, 34, 16, 7, -11, -5,
    9, -6, 9, 33, 19, 32, 28, -18,
    -42, 9, 17, -8, -4, 11, 4, -1,
    -18, 1, 21, -13, -20, 4, 3, -1,
    -21, -20, 3, -13, 24, -27, -16, -3,
    -48, 9, 19, 27, 34, -49, 7, -9,
    14, 8, 16, -21, 0, 11, 1, -7,
    4, -6, -16, 6, -3, 5, 0, -4,
    -17, 23, -21, -9, -31, 3, 8, 12,
    12, 63, -12, -25, -10, -6, 19, 35,
    25, 5, -4, -9, 5, -9, -1, -6,
    14, -5, 3, -21, -1, 3, 19, 9,
    12, -12, 42, 2, 32, -1, 29, 17,
    -7, 18, -54, -21, -16, -35, -45, -5,
    -2, 23, -12, -2, -7, 3, 5, 16,
    -4, -3, -31, 12, -19, 15, 15, 45,
    -18, -8, 39, 11, -5, -30, 60, -12,
    14, 7, -45, -16, 1, 5, 40, -56,
    -17, 29, -36, -34, 6, 19, -11, 3,
    17, -14, 7, -21, -8, -8, 39, -27,
    13, -20, 41, -23, -14, -30, -56, 30,
    24, -64, -10, 36, 6, -6, -21, -50,
    -16, 27, -8, -5, -19, 13, 4, -2,
    28, -40, 15, 4, -19, 10, 2, -7,
    17, 0, 9, 4, -12, -14, -15, 22,
    23, 25, 36, 58, -42, 2, 2, -31,
    30, 11, -6, 4, -6, 0, 20, 5,
    18, 0, -30, -6, -2, 14, 7, 2,
    13, -17, 8, -22, 3, 16, 6, 84,
    -10, 26, -2, 5, 72, -23, 27, 5,
    -15, 1, -13, 14, -9, 8, 8, -4,
    12, 9, -13, -14, -12, 29, 0, 4,
    4, 8, -16, -2, -24, 18, -54, -5,
    -8, -3, -4, 6, 8, 35, 3, -10,
    12, -1, -7, -17, -1, 3, -9, 5,
    -5, -14, 7, -9, -4, -3, -6, 11,
    2, -37, -14, 7, -3, -14, -8, -36,
    5, -13, 15, -32, 14, -3, 3, 15,
    -16, 3, -22, 0, -6, -14, 15, 5,
    -6, 27, -7, 16, -40, -12, -5, 22,
    -33, 6, 6, -14, -2, -23, -12, -2,
    11, 16, -16, -16, 6, 36, -23, 9,
    -26, -21, -9, -1, 2, 4, 4, -28,
    17, -5, -13, 10, -22, -12, -16, -46,
    9, 9, 13, -9, -30, -19, -45, -7,
    -22, 5, 13, 28, 14, -21, 9, 10,
    -17, 28, -14, 9, 13, -7, 2, 6,
    -22, -36, 14, -4, 6, -15, 22, 0,
    11, -3, -13, -11, 15, 11, -27, 11,
    -5, 17, -19, -3, 5, 18, 25, 6,
    1, 11, 6, -8, -10, 0, 12, -6,
    22, 13, -12, -20, -5, -28, 11, 3,
    -10, 0, 27, -7, 12, -24, -11, 5,
    11, 3, 20, 3, 2, -17, 1, -2,
    -21, -37, 1, -12, 1, -2, 5, -2,
    -7, 0, -35, -17, 11, 0, -5, 4,
    -8, 8, 9, 2, -21, 66, 16, -15,
    -19, 9, -4, -8, -21, -25, -27, -36,
    -8, -14, -1, -43, -5, -4, -7, -6,
    51, -14, -21, -5, -22, -1, -49, -5,
    -66, -17, 5, -4, -12, -51, 6, 7,
    -45, 22, -1, -2, -11, -24, -17, -5,
    -8, 12, 2, 8, 1, -11, 2, -1,
    11, -27, 31, 2, -9, -36, 1, 2,
    -3, -51, 8, -21, -33, 10, 22, 25,
    5, -34, 6, 38, -1, -24, -3, 0,
    -13, -14, 11, 27, 26, -3, 1, 8,
    35, 7, 35, 0, 9, -14, 6, -5,
    14, 21, -21, -27, 0, -49, 22, 11,
    17, 6, 19, -20, -16, 41, 11, -13,
    -23, -17, 16, -6, 5, -3, 3, 15,
    -2, -3, -3, 0, 22, -11, 2, -20,
    -27, 23, -9, 10, -12, 30, 26, 12,
    -1, -4, -45, -10, 37, 0, 21, 16,
    15, -16, -12, 3, -5, 7, -22, 9,
    3, -30, 20, -2, 19, 20, 10, 10,
    -9, -8, 3, -8, 9, -51, -21, -2,
    1, 1, 4, -57, -63, -50, -14, -7,
    -17, -18, -29, -1, 1, -1, -4, 7,
    -22, 20, -7, -13, 11, 11, -18, -10,
    14, -15, 10, 18, 10, -27, 1, 14,
    -21, 17, -39, -5, -23, -16, 2, 25,
    -34, 2, 5, -28, 1, -4, -8, -12,
    -18, 32, -17, -2, -5, -23, -2, 25,
    -31, -19, 18, -18, -6, 24, -3, 5,
    10, 9, -2, -21, -7, -6, 49, 12,
    -26, -6, -7, -12, -3, -2, 2, -13,
    -30, -10, 17, 4, 14, -15, 30, 15,
    -10, 2, -14, -21, 36, -9, -24, -10,
    0, -19, 64, -20, 29, 12, -3, -11,
    17, -25, 5, -2, 5, 1, -8, 8,
    12, -31, -1, -7, 35, -4, -14, -12,
    7, -9, -49, -3, 4, 52, 28, -18,
    -22, -11, -60, 30, -2, 11, 31, 1,
    29, -12, 17, 8, -6, 11, -14, 13,
    16, -3, 34, 18, 22, -12, -16, -1,
    20, -8, 1, 17, -2, 4, 8, 34,
    -27, -20, 15, 20, 14, 13, -25, -94,
    22, -9, 5, 24, -7, 13, 4, 5,
    47, -8, -23, 28, 33, 19, 11, 9,
    -36, 18, 29, -5, 13, -29, 6, -11,
    -10, 16, -6, 14, -30, 19, 1, -28,
    14, 1, -10, 0, -9, 1, 5, -5,
    4, -11, 42, 39, -2, -29, -8, 25,
    11, -23, 0, -18, -22, 3, 16, -16,
    3, -6, -20, -4, 8, -34, -8, 24,
    12, -10, 9, -8, 14, 19, -2, 0,
    -31, 14, -21, -16, 19, -4, 43, -6,
    16, 26, -9, -8, 69, 23, -10, -12,
    10, 40, 0, -37, -41, -12, -17, -18,
    -4, -35, -7, -23, 0, 2, 5, 21,
    -60, -7, 9, 21, -14, 8, -13, -31,
    41, 11, 11, 6, 26, -30, -1, -22,
    -13, -22, -50, 22, 8, 14, -9, -46,
    12, -4, 26, 11, -1, 1, 5, 8,
    -2, -7, -24, -19, 15, -10, 8, 1,
    -10, -14, 3, -5, -23, -29, 1, 17,
    4, 25, -10, -40, -4, 100, 0, -18,
    -14, 13, 9, -11, 1, 2, -3, 13,
    -8, -17, 18, 10, -13, -7, 13, -35,
    19, -1, 21, 42, 12, 16, 18, -21,
    -3, 76, -8, -4, 20, -7, 9, 42,
    16, -11, 28, 6, 11, 6, 9, -4,
    -17, -3, 3, 0, 4, 25, 5, 23,
    -5, -24, 24, -9, -25, 21, 2, -7,
    -13, 29, -5, -50, 19, 6, 8, -32,
    -20, -4, -66, -12, -6, 3, -28, 17,
    -2, -25, -8, -9, 24, -5, 10, 2,
    12, -1, -28, -34, -48, 31, -33, 27,
    58, 1, 48, 81, 0, 5, 21, 4,
    -17, 14, 48, 18, -21, -4, 15, 15,
    -6, 36, 21, -34, 2, -11, 55, 33,
    1, 8, 1, 21, 29, -62, -3, 72,
    -2, 12, 45, 7, -7, -51, 14, 26,
    -34, -9, -14, 30, 0, 8, 6, -7,
    -10, -2, 30, -16, -6, -15, -24, -10,
    4, -21, -8, -8, -35, 9, -20, -17,
    38, -9, 49, -32, -1, -45, 3, 5,
    16, 17, -3, -17, 3, -2, 7, -22,
    3, 45, 11, -35, 4, -24, 40, 32,
    -33, -22, 9, 43, 53, -34, 3, -100,
    -49, -12, 60, 4, 17, -58, 34, -27,
    1, 29, 7, -8, -18, 4, 10, 15,
    -3, -28, 10, 8, 29, -40, -38, -34,
    20, -61, -18, -23, -12, -31, 0, -74,
    -39, -60, -38, 16, -5, -32, 33, 5,
    28, 45, 11, -9, -27, -2, 6, 13,
    44, -3, -50, 34, -2, -12, -28, 13,
    6, 25, -24, -53, 92, -33, 5, 12,
    -36, 20, 7, -25, -61, 20, -36, -18,
    7, -5, 24, 29, 1, 24, 8, -7,
    15, 18, 5, -14, -32, -44, 21, 11,
    -3, -44, 4, 11, 30, -57, -22, 61,
    50, -44, 27, -45, -47, 4, 2, 4,
    -15, 21, 19, -13, 13, 10, 12, -24,
    32, 8, 2, 42, 98, 24, 21, 40,
    102, 15, -24, 32, -23, -81, 95, -40,
    -3, -24, 21, 3, 58, -53, -22, 15,
    -21, -23, 16, 43, -4, 14, 1, 6,
    25, 33, 6, 33, -23, -15, -7, 42,
    -31, 4, 26, 25, 31, -44, -41, 61,
    -1, -4, -16, -22, -6, 48, -28, -12,
    -12, -19, -13, 2, -7, -6, 20, -19,
    13, -15, -20, -25, -11, -3, -8, 15,
    12, -39, -17, 34, -34, -48, 10, -31,
    -9, -39, 96, -48, -3, -19, -28, -7,
    13, -1, -7, -13, -8, -23, -8, 7,
    -20, -1, -32, -24, -8, 41, 30, -36,
    58, -38, -32, -2, -70, -51, 47, -79,
    -21, -27, -25, -32, -2, 21, -17, 12,
    -6, -1, -6, 36, -3, 0, 8, -16,
    -24, -5, -41, -49, -45, 6, -36, 22,
    8, 9, 22, 27, -30, -49, -55, 61,
    37, 17, -32, -4, -12, -11, 23, -11,
    1, 17, -17, -54, -6, -14, 1, 7,
    -4, -64, 7, -38, 19, 11, 17, 74,
    35, 49, 12, 30, 7, 21, 25, -25,
    -15, 18, -23, -6, -4, 7, 27, 2,
    -37, 36, -31, -35, -14, -4, 5, -19,
    22, 16, 6, -3, 7, -20, -14, -7,
    -73, -56, 7, -37, 34, 37, 10, 103,
    35, 34, 24, 40, -52, 8, 65, 1,
    -14, -5, 24, 16, -11, -2, -2, 4,
    -68, -15, 15, -84, -22, 11, -15, 13,
    17, -29, 20, 32, -9, -46, 54, -49,
    23, 6, 45, 2, -7, -14, -28, -26,
    -65, 4, -4, -24, 2, -6, -3, -13,
    98, 31, -21, 0, -11, 49, 27, -5,
    -125, 49, 7, -12, 43, -90, 14, -40,
    71, -15, -27, -12, 42, 20, 21, -26,
    -5, -51, -6, 12, 13, 6, -12, -9,
    27, -1, -18, 10, -27, -10, -43, -11,
    -34, -7, 11, -9, 43, 78, -32, 36,
    -36, 10, 1, -1, -11, -16, -31, 18,
    6, 13, 13, 12, 127, -2, 8, 22,
    85, 0, -11, 5, -94, -35, 10, -42,
    9, -7, 14, 5, -75, -11, 0, -8,
    -12, 7, 22, -17, 1, 42, 10, 36,
    28, -54, -1, -52, 16, -3, 2, 3,
    -41, -11, 20, -53, 2, 21, -11, 31,
    -31, 29, -9, -6, -2, 38, 29, 56,
    6, -25, 12, -4, -13, -15, -37, -34,
    -20, 11, -56, -7, 15, -26, -17, -5,
    -10, -16, 7, 15, 6, 28, 44, 3,
    17, 18, -6, -10, 55, 4, -33, -81,
    23, -26, 1, -29, -3, -86, -52, 20,
    -26, -9, -29, 13, 3, -6, 5, -9,
    -11, -24, 2, -1, -49, 2, 63, 12,
    -22, 30, 46, 25, -4, -73, 20, -28,
    10, 3, 20, -7, 18, -12, -11, 28,
    34, -22, 34, -19, -10, -13, 13, -19,
    -10, 5, 13, -24, -3, 53, -1, 22,
    43, -38, 57, -28, -31, -18, 6, 26,
    -8, -10, -92, 18, -19, -1, -28, 5,
    -10, -16, -48, -29, 3, -11, -5, -6,
    -10, -16, -7, 9, 19, 21, -35, -38,
    -39, 39, 4, -5, -14, -16, -75, 57,
    14, 14, -49, -5, -7, 19, 29, -3,
    -3, 0, 0, 55, -13, -3, 8, 25,
    18, -83, 44, -25, -58, 25, -5, -31,
    -18, 7, 1, -30, 42, -88, -15, 4,
    -29, -24, -36, 26, -17, 16, -33, 50,
    9, 28, -21, 19, -6, -12, -8, 28,
    4, -1, -20, -39, -21, -5, -16, 2,
    -5, 11, 13, 5, 30, 26, -42, 40,
    -27, 3, 40, 36, 34, -5, -12, -117,
    28, -34, -9, 8, -1, -3, 17, 1,
    56, 24, -14, 4, 36, -37, 14, -10,
    -49, -35, -39, -14, -10, 1, 90, -7,
    -21, 43, -20, -2, -33, 69, 7, 23,
    -41, 22, -32, 12, -35, -3, 0, 21,
    -6, -65, 8, 46, 19, 7, 12, 28,
    6, -12, 8, -19, 25, 44, 43, -42,
    -13, -13, 48, -4, -5, -35, -9, -19,
    -24, -64, -9, -3, -9, 7, 5, 0,
    -13, 34, -25, 0, -12, -15, -36, -4,
    20, 22, 6, -6, 21, 10, -52, 65,
    -27, 23, -38, -51, 28, -27, 12, 32,
    11, -13, -13, 9, 2, -8, -4, -5,
    -45, -5, -12, -21, 24, -37, -14, -20,
    61, 20, 24, -47, -55, -4, -31, -40,
    -37, -51, 67, 38, -3, 20, 24, 16,
    46, 24, -8, -14, -1, -4, 16, -10,
    -9, -15, 15, 11, -11, 5, -8, -11,
    12, -27, 5, -32, -67, -62, 25, 26,
    -11, 7, -3, -12, 10, 101, 2, -33,
    -65, -64, -37, -5, -14, -5, -13, 23,
    42, 3, 24, 3, -5, 51, 60, 4,
    -6, 26, 49, -8, 50, 11, -4, 36,
    8, 20, 17, -5, 10, -19, 14, -10,
    -24, -28, -2, -15, 3, 6, -43, -8,
    -11, -28, 6, 3, -27, -47, -2, -46,
    16, -46, -17, 4, 21, -21, -1, 42,
    1, -22, 11, 3, -16, -20, 18, 23,
    11, 9, 12, 3, 38, -4, 19, 14,
    9, 29, 23, 23, -9, -14, 0, 22,
    -5, 0, -16, 22, 1, 26, 23, 9,
    -15, -1, -14, -25, -22, 15, 5, -30,
    -13, 1, 11, -10, -7, 20, -7, 9,
    -20, 20, -38, -46, 3, 17, -13, 2,
    -34, -28, -7, -26, -10, -13, 15, 3,
    8, 22, -9, 10, -1, 19, -3, -4,
    9, -8, 20, -12, 0, 9, 12, -21,
    17, 14, 27, -14, 13, 13, 21, -3,
    -13, 1, 17, -18, -22, -18, 37, -23,
    4, 27, 31, -22, -16, -1, 21, -11,
    19, 1, -6, -9, 21, 21, 33, 12,
    -7, 57, 25, 2, -21, 1, 23, 0,
    0, 20, 27, -43, 14, 8, -9, -1,
    -16, 5, -9, 1, -2, -1, 7, -36,
    -1, -10, 22, 14, -15, 2, 11, 9,
    -29, -9, -7, 16, -6, -3, -6, 16,
    -13, 37, -22, 18, -24, -7, -17, -66,
    -11, 10, -19, -15, 1, 2, 6, 9,
    -6, 3, -15, -3, 6, -25, -18, -22,
    0, 18, 31, 12, 1, 11, 34, 16,
    31, 29, 24, -46, -24, 7, 16, 13,
    0, 5, 0, -12, -19, 3, -17, -26,
    -4, 9, 12, -6, -4, -7, 17, 14,
    -19, 17, 9, -34, 14, 10, -21, -35,
    -54, -17, -11, 4, -15, 16, 17, 3,
    -3, 16, 6, 5, -12, 0, -10, 32,
    7, 11, -10, 22, 5, -12, -15, -2,
    54, -4, -11, 42, 20, 0, 1, -24,
    20, 25, -7, 26, 19, -32, 7, -4,
    1, -12, 22, 3, 5, -23, -53, 20,
    1, -17, 1, -3, -11, -59, -9, 38,
    -31, -29, 66, -29, 8, -15, -9, -1,
    -8, 31, 56, 14, 11, 6, 14, -5,
    -25, -18, 6, -2, 4, 0, -11, 16,
    -15, -9, -1, -8, 19, -1, 10, -16,
    -6, 11, -7, 8, -6, -14, -4, -19,
    18, 14, 13, 0, -5, 3, 7, 19,
    -15, 6, 11, 5, -41, -2, 18, 8,
    -14, 19, 7, -15, -15, -2, -23, -2,
    -9, 60, 7, 24, -9, 10, 2, 17,
    -15, -34, 3, -9, -27, 12, -35, -18,
    11, -9, 0, 8, -12, -21, -23, 9,
    -8, 3, -6, 20, -24, -3, -9, 23,
    14, -38, 3, -22, 9, -14, -4, -42,
    -22, -14, -20, -10, 12, 15, -7, 10,
    26, -2, -15, -5, 5, 25, 12, -7,
    10, -2, 3, 3, -1, -34, 11, 5,
    -19, 0, 3, 54, -24, -4, -11, 26,
    7, 8, 9, 52, -44, -27, 0, 11,
    -8, 15, -19, -3, 12, 27, 3, 30,
    7, 10, 12, 0, 11, -4, 27, 17,
    32, 10, 8, 15, 15, 13, 9, -11,
    15, -31, 9, -9, 48, -15, 19, 22,
    -21, 8, 14, -5, -11, 19, -2, 12,
    -19, -1, 7, 9, 53, -11, -18, 6,
    -15, 2, 30, -18, -10, -24, -1, 13,
    -16, 14, 1, -23, 42, 7, -45, 37,
    -36, 2, -8, -24, 4, -8, -23, 8,
    -19, -11, -18, -2, -17, -17, -6, 30,
    13, -29, -20, 31, 19, 32, -7, -7,
    23, 6, 30, -42, 20, -5, -30, -6,
    -19, -7, -10, 6, 8, -1, -8, -1,
    9, 5, -8, 7, 10, 10, -37, -18,
    -34, 22, 48, -3, 0, -27, 10, -7,
    -3, 41, 20, 31, 29, 42, -26, -18,
    -7, 2, -3, 15, 8, -9, 30, -27,
    -1, 0, -12, -9, -6, -1, -3, -60,
    -23, -18, 17, 19, 17, 11, 2, -7,
    4, -30, 6, 17, 8, -16, 12, 2,
    -4, 0, -14, -1, -17, 9, 2, 16,
    1, -1, -28, -1, -16, 10, -4, -37,
    -43, 26, -3, -33, 7, 13, -2, -4,
    -31, 10, -6, 52, -56, 17, 0, 5,
    -20, -6, 1, -14, -39, 77, -25, 21,
    13, 9, -6, 1, -17, 18, 32, -28,
    -37, -17, 25, -37, 0, 43, -15, 18,
    -10, 7, 17, 11, 18, 3, -21, -39,
    4, 6, -1, -1, -4, -31, -13, 3,
    -6, -13, -4, -5, -27, 15, 1, 21,
    68, -3, -3, 0, 15, -12, -9, -14,
    2, 6, -2, 9, 1, 16, 33, -6,
    -29, 2, -46, 12, -1, 7, -38, -37,
    -14, -1, 4, 8, -18, 9, -2, 8,
    -15, 30, -58, -58, -24, 10, 11, -11,
    -21, 39, 1, 13, 9, 20, 15, 8,
    -4, 5, -8, -4, 7, -11, 21, -30,
    -10, 21, -6, 11, -23, 18, -4, -5,
    5, -32, -13, 28, -16, -31, -26, 28,
    11, -19, 5, 32, 1, 29, 2, 17,
    18, 8, 13, 6, -33, 31, 24, -9,
    -15, 5, 10, 5, 40, -26, 3, 32,
    -22, -4, 40, -37, 7, -14, -2, 30,
    13, 34, 19, 28, 17, -33, -23, -37,
    -18, 8, -1, 2, -45, -3, 57, 3,
    1, -13, 19, -1, -13, -3, -7, 7,
    -28, 27, -9, -13, -19, 7, 27, 14,
    10, 17, -21, 4, 17, 23, -11, 3,
    7, 14, -5, -4, -14, 40, 0, 10,
    3, -2, -15, -12, 16, -5, -16, 13,
    9, 7, 11, 18, -19, 39, 27, 12,
    -33, -24, 43, 8, -26, -48, 17, -1,
    9, -15, -31, 19, 61, -5, 73, -2,
    -12, 0, -5, -12, 1, 13, 0, 12,
    11, -4, 15, 34, 10, -16, 12, -17,
    -3, -39, -21, -10, 19, -13, 30, 34,
    9, 24, 15, 9, 28, 21, 5, -10,
    2, 11, -7, 8, -4, -5, -1, 4,
    18, 50, -4, 5, -16, 37, -14, 11,
    -38, 54, -24, -12, -21, 37, -34, 11,
    17, 8, 12, 4, -16, 32, 21, 6,
    3, 5, 7, 7, -32, 41, -40, -24,
    -13, 24, 22, -10, -6, -23, 0, 15,
    -21, 19, 5, 10, 12, 6, -23, 55,
    17, 18, -21, 3, 20, 42, -58, -8,
    6, 19, -17, 3, -12, -5, 25, 7,
    -5, -22, -39, 28, 18, 16, -10, 5,
    -2, 4, -22, 26, -13, -29, 1, 5,
    -10, 7, -15, -35, 27, 22, -13, 4,
    -3, -4, 2, -14, 18, 1, 5, -28,
    26, -1, 16, 9, 8, 6, 1, 24,
    -6, 18, 23, -9, 17, 9, 6, -1,
    -5, -8, -3, 8, 31, -21, -6, 22,
    -7, 11, 12, 12, -18, -2, 13, 3,
    5, 1, -6, 24, 4, 21, -6, -3,
    -13, -10, -15, 6, 5, 8, 27, 13,
    10, -9, 27, 6, -37, 0, 0, -11,
    13, -8, 3, 7, 43, -9, 27, -22,
    -22, -2, -26, -71, 5, -3, -39, -21,
    -9, -10, 27, -38, 12, 8, 16, 19,
    -13, -4, -12, -27, -32, 20, 21, -3,
    -4, 6, -6, -21, 13, -18, 21, 20,
    0, -12, -15, -12, -4, -8, 23, -2,
    -71, 0, 3, -29, 17, 7, -2, -21,
    11, 14, 6, -8, -10, 25, -2, 21,
    17, -5, -15, 15, -14, 16, -49, 9,
    33, -15, 16, 6, 4, -4, 10, -10,
    19, -26, -14, 23, -44, 19, 23, -5,
    19, -18, 13, -18, 10, 38, 48, 14,
    10, 4, -15, 9, -38, -48, -24, 15,
    -12, 59, 26, -3, -8, -2, 41, -4,
    -8, 16, -4, -21, 31, 12, 10, -93,
    2, 3, 17, 11, 28, 14, 51, -13,
    15, 3, 25, 18, -18, 38, 22, 21,
    -5, 17, -38, 20, 4, -10, 29, 7,
    -24, 3, -26, 19, 14, 10, -3, -3,
    -16, 10, 7, 9, 15, -21, 15, 3,
    7, 0, -3, 5, -18, -23, 0, -15,
    -14, 5, -2, -10, 24, 19, 25, 1,
    -30, 12, -38, -3, -35, 1, 3, -26,
    -7, 2, -1, 3, 23, -7, -4, 14,
    -2, -3, -1, -15, -26, -2, 10, -29,
    -16, 3, -1, 28, -10, 31, -2, -8,
    -6, -37, 8, -11, -91, 6, 17, 20,
    -16, -17, 16, 4, -4, -27, -11, -48,
    4, -6, -5, 7, -29, 22, 15, -17,
    34, 31, -11, 26, 23, 20, -10, -11,
    41, 3, -23, 36, -41, 77, 5, -57,
    1, -23, -4, 4, -6, -7, 14, 23,
    10, -14, 1, -10, 12, 57, 38, -47,
    -30, -16, 9, 23, 12, -7, -19, 9,
    -14, 26, -63, 4, -13, 5, -26, 2,
    -31, -5, 10, 2, -7, 36, -35, 35,
    -4, 6, -9, 1, 11, -5, 27, 19,
    18, 4, -11, -7, -7, -6, -4, 4,
    4, 8, 14, -34, 11, 23, -15, -18,
    -16, 12, -5, 3, 1, -36, 41, -9,
    -8, 7, -4, -17, -40, -32, 36, 1,
    3, -21, 15, 13, 9, -32, 26, 2,
    18, 0, 29, 18, 3, -15, -37, -67,
    7, -4, -14, 8, -72, -13, -21, 24,
    2, -5, 2, 4, -3, 11, 8, -6,
    -21, -25, 1, -2, -9, -13, 2, -6,
    24, 3, 21, 2, 4, -12, 28, -20,
    19, 9, 4, -7, 34, 11, -11, -23,
    1, 21, 10, -9, 31, 3, 24, 10,
    19, -3, -16, -29, 15, 2, -36, 10,
    36, 0, 44, -11, -15, 2, -48, -66,
    -9, -4, -2, -28, -16, 13, -39, -27,
    0, -6, 2, 8, 22, -6, 18, -7,
    -21, 21, -4, 44, -15, 8, -18, 21,
    40, 19, 0, 0, -36, -36, 36, 20,
    -3, 2, 11, -6, 9, 31, 0, -4,
    -5, 13, 6, -24, -4, 29, 29, -37,
    -1, -46, 31, -8, -28, -32, 32, 4,
    -4, 33, -29, -4, -3, 31, -27, -19,
    -32, -9, -13, -10, -26, 1, -5, -26,
    -11, 1, -12, 4, 5, 25, -26, -12,
    -46, -34, -6, 27, 11, -2, 6, 17,
    34, 11, -38, -27, -16, 13, 40, 57,
    -5, 14, -5, 5, -4, 34, -10, -21,
    -12, 7, -17, 10, 7, 40, -6, -15,
    4, -10, 12, -16, 4, -10, 17, 5,
    16, 2, 28, -11, 5, -42, -31, -15,
    4, 12, 4, 13, 22, -5, 21, -11,
    0, -4, -9, -7, 6, 23, 15, -1,
    -3, -21, -15, 45, -1, 2, 12, -13,
    -8, -24, -4, 35, -8, 4, -3, -44,
    8, 2, -2, 8, 8, 12, -3, -62,
    -1, 2, -19, -3, -34, -13, 6, 3,
    -30, 15, 1, -17, 8, 7, 17, 9,
    -24, -8, 13, 16, 3, 30, -18, -15,
    -13, -16, 7, 1, -13, 47, 40, 48,
    -7, 5, 21, -5, -15, -44, 13, -18,
    -16, 23, -44, 30, -18, 14, -13, 2,
    -6, -3, 42, 55, -28, 15, -12, -11,
    0, -6, -11, 6, 24, -44, -55, -8,
    3, 2, 8, -6, -14, 15, 24, -15,
    35, 15, 7, 5, -6, -9, -28, 23,
    6, -20, 0, -48, -28, -6, 16, -24,
    -20, 2, -6, 15, 9, 23, 9, -26,
    -6, 11, 8, 14, -47, -48, -29, 13,
    15, 4, 0, -35, -8, -4, 15, -18,
    -42, 53, -15, 10, 1, 0, 27, 4,
    5, -1, 9, 13, 32, -20, -43, -9,
    7, 20, 6, 5, 14, -22, -14, 40,
    -8, -26, 10, -6, -28, -21, -42, 9,
    50, -54, 21, 38, 23, 31, -15, -68,
    8, 33, -8, 8, 23, 38, 4, -8,
    19, 12, 7, -6, 10, -32, -12, -33,
    -14, 11, 31, -14, 4, 13, 13, 37,
    2, 2, -30, 11, 13, 21, -53, 17,
    7, -4, 5, 7, -78, 29, 0, -17,
    -9, -8, 7, -1, -37, 4, 4, -33,
    -38, -11, 33, -19, 11, 26, -11, -3,
    15, -26, 19, 17, 30, -34, 29, -19,
    -15, -11, 11, -2, -10, 7, -2, -13,
    -14, 10, -11, -4, -3, -29, 18, 7,
    6, 50, 18, 31, 2, 10, 35, 6,
    8, 13, 6, 10, 11, -3, 7, 31,
    19, 11, -4, 17, 19, 9, -8, 15,
    0, -5, -5, -32, -8, -32, -11, -9,
    -22, -59, 51, 25, -2, -1, 1, 2,
    12, 19, -10, -29, -11, -19, 26, 7,
    4, 0, -12, 1, 13, -2, 38, 24,
    11, 0, -5, 16, 34, 30, -3, 38,
    -13, 29, 28, -4, 3, 5, 13, 29,
    -7, -26, 25, 0, -35, 1, -19, -13,
    -13, 0, 4, -12, -22, 9, 19, 1,
    -7, 6, 21, -9, -26, 36, 14, 30,
    30, 15, -11, -20, -22, -22, 1, 21,
    6, -1, 30, -30, -18, -16, -20, 49,
    5, 12, -18, 14, -5, -5, 2, 45,
    9, 3, 0, 13, 21, 3, 14, 11,
    -3, -3, 7, -26, 12, -10, -3, 7,
    -44, 22, -25, 7, 0, -18, 65, -27,
    0, 2, -6, -7, 28, 11, -33, 13,
    2, -10, -4, -18, -7, -13, 11, -24,
    36, 8, -22, -13, -9, 15, -6, 16,
    -18, 5, -18, -21, 12, -34, -51, 3,
    17, -22, -21, 7, -6, 36, 22, 18,
    3, 15, 12, 3, -22, -5, -8, -12,
    25, -21, -11, -7, 32, 2, -6, -5,
    -24, 10, 30, 2, 4, -20, 8, 20,
    4, -11, 7, -5, 8, 7, -27, -102,
    9, -10, 15, -43, 17, -5, 30, -23,
    31, -8, 33, -18, 65, -9, 41, 3,
    41, -14, 47, 42, -23, 7, -24, -22,
    4, -25, -6, 5, 28, -1, 20, 38,
    6, 4, -21, 19, -48, 38, 2, -27,
    -7, -10, 22, 52, -39, -23, 34, -7,
    81, 48, -27, 56, -30, -33, -17, 20,
    -8, -2, 12, -18, -36, 4, 65, 4,
    -4, -16, -2, 19, -40, 20, -32, -16,
    -3, -18, 44, 44, -17, 22, 50, 23,
    8, -16, 24, 44, 12, 12, 9, 50,
    6, -24, -38, -19, -7, 6, -21, 19,
    -6, 16, 0, 28, 20, -30, 17, -5,
    56, -46, -47, 5, -10, -23, 11, 6,
    -3, 1, -14, 6, 4, 66, 32, 88,
    12, -14, -30, -10, -43, 30, -25, 8,
    53, -1, -11, 28, -23, 41, -72, 21,
    12, 50, 98, -59, -26, -4, -69, -36,
    -21, -1, -17, -17, 26, 79, 0, 33,
    -17, 10, 19, 23, 1, 51, -21, -15,
    20, 2, -23, 12, -45, -50, -2, -31,
    35, -63, -4, 31, -32, 47, 0, -21,
    -43, 14, 10, 72, 93, -1, -35, -36,
    -91, -38, 1, 7, -19, -16, 20, 43,
    29, -23, 1, -13, 36, -47, 14, 4,
    -27, -30, 4, -3, 41, 18, -11, 6,
    -47, 49, 2, 29, 68, -33, -17, -58,
    24, -6, -2, -4, -33, 55, 6, -35,
    -3, -13, 11, 22, 32, 35, 30, 22,
    -57, 39, 0, 26, 1, 18, -62, -3,
    -49, -43, 53, -5, -93, -33, 31, 81,
    -12, -20, -27, 29, 18, 0, 61, -20,
    2, -31, 9, -7, -11, -45, 21, -9,
    -24, 12, 38, 36, 4, 39, 21, 8,
    17, -33, -5, -18, -22, 37, 41, -25,
    -10, 4, 2, 3, 18, 21, 10, -8,
    -17, -10, -127, 2, 9, 1, 17, 30,
    -12, -18, 20, 2, 1, -31, 16, -6,
    30, 36, 0, -10, 19, 42, -57, -26,
    -31, -39, -44, -33, 84, -25, -3, -57,
    -3, 19, -2, -66, 60, -4, -50, 23,
    16, 65, -59, -23, -27, 78, 21, 61,
    -80, 11, 5, -47, 70, 14, -17, -17,
    -15, 15, -13, -4, -52, -22, -11, -4,
    15, 39, 5, 17, -14, -2, 6, 48,
    -25, -3, 24, 35, 78, 34, 12, -24,
    -67, -32, -23, 17, 50, -47, 44, 11,
    -2, -7, 23, 19, -28, 17, -7, -39,
    8, 40, 44, 4, 64, -8, -13, -10,
    -67, -16, 21, -57, -31, -13, -43, -6,
    8, 18, 10, -43, 97, 26, 41, -26,
    6, -18, 35, -39, -54, -8, -7, -33,
    -5, 9, -28, -12, -60, 6, -35, -20,
    -57, 16, -46, -76, 4, -39, -19, 17,
    -12, 31, -2, 23, 21, 108, -61, -22,
    6, -68, -11, 30, 23, 16, -58, 13,
    10, 14, 24, 1, 55, 24, 15, -37,
    28, -53, -63, 62, -10, -26, -51, -34,
    34, 17, -21, 11, -57, 49, 18, -5,
    -25, 11, 17, 15, 0, 20, 10, 0,
    -12, 11, -9, 10, -77, 44, -54, -67,
    -32, -43, -18, -24, -9, -34, 25, 20,
    14, 37, 37, 80, -46, 13, -79, -17,
    4, -11, -21, 0, -9, -18, -5, 14,
    -20, -9, -59, 11, 0, -44, -23, -14,
    10, -5, -47, -25, -63, 37, 52, -1,
    -29, 48, -44, 11, -17, 68, -23, -4,
    22, -5, -18, -29, -97, -5, 41, 52,
    -96, -13, 1, 22, -10, 41, 0, -57,
    7, 105, 10, 2, -62, 19, 47, 69,
    -39, 10, -30, 21, 77, -30, 29, 30,
    19, 17, 5, 37, 16, 17, 18, -30,
    5, -5, -30, -13, -68, 10, 24, 52,
    19, 5, 0, -17, 3, -8, 28, -5,
    83, -19, -14, -60, -14, 3, 18, 16,
    28, 36, -4, -8, 90, -59, -62, 29,
    -20, 15, 23, 1, -7, -45, 28, 18,
    -4, 17, -54, -50, 77, -29, 2, -86,
    -22, 46, 10, -21, -12, -43, 16, 26,
    -40, -14, 10, -14, 65, 7, -45, -2,
    32, 21, 14, -17, -29, 12, 105, 24,
    -37, 7, 28, 47, -41, 24, -56, -73,
    -9, -32, -33, -47, 27, 50, -53, -11,
    3, 34, 7, 20, -28, -63, -31, -24,
    13, -23, 1, 21, -20, -20, -37, 29,
    17, -2, 15, -15, 37, -23, 0, -37,
    22, 18, 2, 34, -18, 0, 32, -10,
    -29, -7, 21, 29, 15, 0, 17, -11,
    6, 21, 0, 39, 65, 13, 12, -109,
    -48, -36, -74, -8, -36, 51, 67, -56,
    59, -10, -11, 31, 7, -30, 40, 38,
    -35, 19, -9, -5, 0, -66, 48, 61,
    2, 14, -1, 4, 4, 73, -27, -20,
    -66, 66, 14, 74, 26, -43, -86, -11,
    -43, -50, -6, -49, 33, -76, 31, 19,
    16, 1, 10, 2, 65, 12, -14, 49,
    -30, -16, -1, -10, 9, 5, 23, 3,
    29, 32, -51, 41, -16, 11, 6, 5,
    -37, -17, 22, -82, -3, 3, 40, -8,
    -18, -24, 37, -7, -21, -59, -18, -14,
    -12, 14, -35, -7, -13, 4, 11, 34,
    30, -72, 17, 15, 45, -16, -55, -2,
    -54, 28, -19, -26, 15, 53, -51, 29,
    45, 29, 36, 20, -71, 21, -20, 10,
    -3, -41, 6, -39, 8, -11, 12, 15,
    33, 49, 47, 49, 10, 0, -12, -12,
    -4, -21, -31, -40, -16, -3, -18, -38,
    -34, -6, -45, 23, 5, -4, 18, 72,
    -8, -2, -91, 6, -33, 0, 0, 23,
    -33, -48, -34, -12, 16, -7, 13, 11,
    0, -62, 5, 9, 87, -2, 52, -11,
    -7, -1, -34, -8, -60, -31, -40, 1,
    6, 13, -5, -10, -47, -1, 22, -15,
    -8, -4, -49, -35, -7, -78, 33, -20,
    20, -30, -81, -9, -54, 40, 5, -39,
    -34, -20, 0, -5, -34, 0, -2, -94,
    -4, 10, -18, 5, 6, 8, -15, 25,
    66, -36, 31, -44, 13, -4, 3, -1,
    -14, -10, 13, -7, 2, 4, 12, 21,
    9, 6, -2, 49, 74, -32, 29, 27,
    -1, -13, 0, -7, -20, -38, 79, -11,
    22, -66, -86, 127, 6, 22, -16, -71,
    -22, -29, -98, 29, 18, -14, -25, -49,
    26, -11, -30, -25, -2, 90, 0, -42,
    18, -8, 12, 1, 59, 7, -29, -37,
    -4, -43, -41, -43, -2, -39, 29, 43,
    11, -54, -10, 29, 14, 36, -13, -42,
    -27, 22, -37, -13, -60, 21, -10, -84,
    2, 4, 35, -9, -6, -8, 15, -3,
    13, 22, 0, 11, -2, 3, 4, -7,
    -17, 6, -16, 22, 4, 0, -14, -13,
    25, -5, 5, 1, 18, -21, -4, 44,
    -13, 2, 0, -29, 6, 6, 2, -14,
    -17, -1, -2, 0, 37, -10, -2, -1,
    -36, -10, -13, 21, 0, 0, 0, -9,
    -20, -1, -13, 10, -56, 30, 35, 18,
    12, 3, 1, -19, -13, -21, -4, 1,
    -2, -20, 0, -3, 26, -11, 0, -2,
    -1, 14, 4, -13, 4, 4, -17, -2,
    0, -15, 40, -4, -4, 24, 7, -4,
    -6, 23, -3, -27, 1, 0, -1, -13,
    -13, 1, 2, 13, -16, -16, -15, -12,
    6, -21, 11, 16, 1, 1, -7, 15,
    15, 17, 21, 8, 7, -39, 1, 14,
    1, -11, -1, -12, 7, 5, 11, 2,
    -10, -5, 0, 10, 8, -7, 2, -30,
    2, 13, 46, 9, -6, -5, 19, 1,
    -8, 9, 10, 16, -13, -32, -13, -31,
    0, -22, -4, 3, 1, 1, 16, 2,
    13, -22, -17, 23, 7, -6, -10, 26,
    -27, -3, -2, 12, -15, 3, 1, -21,
    -16, -18, -8, -17, -15, 0, 10, 6,
    -6, 8, -9, -3, -4, -24, -3, 2,
    -9, 8, 17, -2, 2, -20, -1, 27,
    12, 27, -14, -13, -3, 5, 4, -3,
    -28, 54, -18, -10, 0, -46, -2, -20,
    11, -7, -18, -16, 19, -13, -13, -1,
    9, 1, 16, 10, -3, 9, -30, 21,
    -15, 21, 14, 11, -17, 6, -15, -2,
    -10, -26, 0, 15, -76, 24, -30, 0,
    -4, -6, 23, 34, 2, -5, 1, 12,
    -34, -3, -1, -10, 11, -21, -4, 7,
    -28, 32, 17, -54, 17, -8, 14, -8,
    7, 17, 16, 7, 54, -4, 8, 35,
    -6, 2, -20, 9, 15, 4, -6, 0,
    2, -3, -9, 3, 0, -10, 2, -21,
    -14, 12, 29, 8, 5, 5, 27, -1,
    -3, -22, 14, -7, 3, 0, -5, -15,
    -13, -15, 5, 2, -15, 9, 22, -17,
    0, -3, -11, 8, -47, -34, -26, 33,
    11, -3, 0, 32, -8, 29, 3, -5,
    5, -1, -13, -36, 9, -63, 27, 33,
    -24, -18, 24, 0, -7, -10, -2, 23,
    -8, -12, 9, 20, -12, 13, 5, -37,
    -9, 11, -2, 28, 18, 12, -8, 2,
    -8, -20, -28, 25, -8, 11, -5, 38,
    11, -22, -4, -3, -1, 11, -4, 0,
    6, 5, 3, -4, -27, 22, 1, -1,
    -11, -7, 12, 8, -1, 7, -4, -8,
    -6, 24, -1, 6, -6, 15, 35, -7,
    11, -2, -15, 10, 2, -12, -2, 8,
    6, 5, 5, -9, 9, -5, 12, -15,
    11, -26, -5, -8, -3, -10, -9, 3,
    -2, 46, -18, 31, 16, 1, -30, -63,
    7, 6, -12, 1, -6, 6, -1, 0,
    0, 6, -3, -7, -5, -7, -26, 17,
    23, 12, -32, -16, 6, 0, -6, 4,
    12, 2, 35, -5, 48, 19, -25, -35,
    4, 0, -9, -12, -7, -4, 4, 13,
    -25, -13, -4, -11, -16, -4, 0, -1,
    20, 9, -31, 6, -3, 5, 2, -10,
    34, -11, 19, -18, 42, -65, -31, -51,
    -6, 18, -2, -25, 14, 6, 3, -4,
    -8, -1, 7, -35, -11, 3, 10, -2,
    5, 36, 27, -31, 4, 0, 0, 13,
    -8, 28, -35, -6, 12, -3, 38, -27,
    -9, 4, 7, 14, 4, -6, 1, 13,
    2, 33, 26, -34, -22, 15, 19, 14,
    -19, 12, 11, 30, -2, -7, 3, -3,
    31, -39, -24, 45, 7, -14, 47, 37,
    4, -13, -5, 6, 1, -10, -15, 2,
    2, -26, 1, -17, 4, 0, 0, -13,
    8, 7, -8, -13, 2, -5, 3, 10,
    -3, 46, -5, 33, 22, -32, -2, 34,
    2, 26, -6, 22, -14, 9, 17, 4,
    9, 0, 6, 7, 20, -2, -34, 4,
    -17, -2, -6, -7, -5, -9, -12, -5,
    32, -10, 30, 41, 38, 91, 5, 15,
    -2, 9, 2, 8, 4, 0, 18, -1,
    -11, 23, -18, 3, -23, -8, -8, 7,
    -1, 39, 29, 20, 7, -12, -6, 9,
    9, 21, 38, 6, 50, -9, 2, -6,
    -4, -4, 1, -24, -1, -4, -11, -15,
    5, -17, 4, -5, 7, -9, 8, -18,
    -3, 10, -6, -32, -7, 7, -2, 6,
    7, 13, 3, 12, -17, -3, -21, -64,
    14, -13, 35, -12, 8, 6, -10, -5,
    -3, -9, -2, -16, 11, -20, -4, 6,
    1, -9, 20, 6, -5, 3, 1, 6,
    20, 20, 1, 5, -20, -31, 4, -54,
    7, -1, -1, -10, -10, -7, 1, -19,
    13, 15, -12, -14, 1, 12, 6, -4,
    -13, 24, 11, 3, 11, 14, -13, -2,
    -1, -16, 12, -15, 61, -18, -66, -29,
    22, -20, 12, -17, 4, -3, 15, -20,
    -16, -2, 13, 2, -19, -24, 20, -27,
    -20, 15, 0, 10, -11, 7, -7, 6,
    -5, 25, -12, -17, -14, -11, 13, 47,
    -10, 10, 4, -5, -3, -3, -3, 7,
    10, 0, 7, 36, -9, 2, 6, -12,
    -8, -30, 15, -10, 10, -3, -6, -4,
    2, -1, 19, 4, 3, -50, -18, 5,
    20, -9, 11, -11, 3, -12, 12, -1,
    12, -12, 9, 14, 29, 34, 22, -7,
    -5, -58, 0, 25, -8, -17, -20, -3,
    -6, -23, 1, -13, 42, -16, -11, -22,
    3, 8, 10, -3, -12, -8, -1, -9,
    18, 13, -4, 8, -7, 9, 9, 16,
    12, -2, 1, 42, 0, -7, -11, 10,
    6, 8, 20, -31, 13, 12, -8, -51,
    13, 9, 24, -7, -2, 5, 16, -16,
    1, 27, -9, -3, 35, -36, -23, 1,
    -28, -22, -5, 8, 26, -18, 4, -15,
    -13, -11, 3, 13, -44, -9, 40, -7,
    -12, 14, -16, 23, 4, 2, 3, 1,
    3, -2, 7, -12, -12, 22, 34, -1,
    -1, 20, -10, 16, 1, 6, 4, -10,
    16, -7, -7, 12, -24, 4, -28, 71,
    -17, -15, 0, -1, 0, 2, 2, -8,
    -10, 0, -1, -10, -11, -15, 15, 5,
    -4, -6, -41, -37, 8, 6, -4, -25,
    -11, -2, -1, -61, -30, -42, -15, -56,
    -8, 7, 12, 21, -9, -5, 18, 33,
    2, 1, 5, 4, 4, 14, -15, 20,
    12, 26, -3, -44, -4, 11, 12, -7,
    1, 20, -53, -25, -59, 4, 46, -40,
    -10, 2, 40, -28, 0, -9, 36, -23,
    2, 18, 15, 2, -19, 9, -52, -59,
    -35, 21, -53, 33, 1, 6, -12, 14,
    -11, -29, -12, -10, 8, 55, 19, 36,
    4, -9, -16, -10, -1, -1, -21, -1,
    -6, -10, -3, 4, 15, -30, 21, 30,
    0, 8, 21, 25, -12, 0, -3, 4,
    -18, -13, -12, -14, -56, 7, 37, -12,
    25, -10, -16, -12, 11, -25, 5, 7,
    1, -28, 9, -5, 6, -9, 5, -22,
    63, 29, -8, 1, 9, 8, -1, 0,
    1, 70, -17, -72, -17, 38, -60, 50,
    4, 28, 5, -35, 4, 12, -1, 2,
    -14, 5, 2, 10, 21, 3, 3, 2,
    17, -19, 31, 23, -3, -19, -15, 19,
    -47, 51, 19, -7, 6, -58, -12, -16,
    -18, -16, -41, -14, 20, 8, -8, -12,
    0, 5, -7, 0, -23, -25, 45, 14,
    54, 0, 45, 30, -1, -2, 10, -15,
    -26, -49, -59, 50, 6, -32, -112, 21,
    -10, -12, -1, 13, 25, 0, -10, -4,
    22, -36, -14, 7, -22, -46, 24, 36,
    8, 38, -40, -3, -7, -7, 15, -12,
    -3, 57, 8, 2, -5, -16, 6, 8,
    -8, 8, 9, -23, 9, -11, -10, -7,
    5, 5, 13, 18, -37, -14, 5, -12,
    5, 15, 7, -21, 4, 0, -8, 12,
    42, -3, 1, 63, -14, 5, 52, 13,
    0, -47, -25, -2, 14, -26, -26, 7,
    0, 20, 19, 10, 19, -28, -17, 5,
    -30, 40, 46, 31, -11, 10, -4, -1,
    -29, 71, -38, 59, -71, -15, -2, -12,
    -8, -12, 10, 24, 7, 6, -11, 16,
    -22, -13, 13, -4, -6, 17, -19, 2,
    -22, 31, 19, -55, 19, 10, 16, -2,
    5, 28, 37, 8, 26, -15, -6, 25,
    -4, -6, -21, 14, 5, 13, 3, -3,
    1, -16, -14, 15, 20, -13, -10, -24,
    -18, 1, 11, -12, -3, 6, 36, -4,
    38, -17, -27, 23, 40, -7, -24, -21,
    0, -20, 24, 21, -4, 11, 29, -24,
    4, -16, -20, -6, -55, -7, 30, 17,
    -7, 43, 25, 35, -9, 9, 5, -17,
    16, 2, 12, 1, 31, -40, 35, 38,
    -21, -10, 30, 4, -14, -8, 2, 14,
    -5, -13, 13, 3, -8, -12, -26, -30,
    -12, -25, -3, 6, 3, -3, -1, 11,
    -46, -43, -29, 21, 10, 20, -3, 42,
    -9, 14, -3, -17, -5, 9, -4, -7,
    -6, -5, 2, -17, -9, -18, 18, 31,
    -5, -17, 18, 7, -4, -7, 2, -2,
    -6, -28, 3, -17, 17, 27, -21, 2,
    -3, -6, -7, 28, 8, 8, -4, 17,
    24, -6, 6, -12, 6, 43, 4, -30,
    31, 5, 39, -31, 7, 0, 2, -4,
    -57, -19, 27, 0, 62, 7, -21, 26,
    5, 18, -6, 7, -11, -12, 8, -6,
    -10, 1, -3, -22, -27, 10, -5, 11,
    5, 11, -9, 13, 4, 1, -4, 10,
    37, 20, -29, -29, 58, 18, 42, -8,
    20, -6, -25, -20, -1, 1, -6, 5,
    -7, -20, -3, -1, -6, 9, -7, -35,
    24, -30, 3, 20, 6, 5, -9, 9,
    2, 0, 16, -28, 33, 10, -37, -53,
    1, -8, -4, -12, 10, -1, -1, 9,
    5, -3, 23, -25, 53, -1, 5, 1,
    -16, -6, 31, -24, 8, 13, 0, 18,
    -8, -4, -7, -19, 2, 4, 14, -64,
    1, 9, 7, 0, 5, -7, -1, 5,
    -4, 51, 33, 5, 6, 4, -18, -7,
    -41, 8, 19, 6, -28, 9, 4, 11,
    19, -10, -5, 20, 6, -7, 24, -7,
    1, -2, 10, -6, -15, 2, 5, -8,
    0, -25, 1, -5, -2, -8, 5, -2,
    19, -1, -42, -4, 15, -3, -5, -1,
    -52, 1, -57, -10, 0, 56, -35, -2,
    -5, 49, -7, 24, 8, 36, -4, 17,
    -5, -17, -15, -10, -7, 27, 3, 40,
    -16, -39, -26, 2, -15, -3, -1, -6,
    100, -5, -3, -43, 35, 55, 17, 60,
    2, 14, 3, 41, -16, 5, 7, -5,
    -3, 16, 20, 20, 6, -30, -3, -27,
    11, 26, -21, -6, -15, -11, -10, -7,
    34, -15, 7, -14, 20, -43, 8, -23,
    3, 25, 13, -29, 7, -11, 0, -2,
    -4, -12, -3, -12, 30, 18, 33, -24,
    -31, 11, 28, -54, -4, 8, -6, 2,
    6, 33, -47, -72, -1, 25, -33, 24,
    19, -1, 10, 9, 2, 21, -8, 18,
    -1, -3, 3, -6, 16, -12, -17, -1,
    24, -19, 45, 12, -3, 2, -5, 13,
    -11, -78, 31, 8, -16, -29, -4, -5,
    5, 13, -34, -17, 7, -2, -11, -29,
    18, -10, -8, -7, 26, -9, 19, -22,
    -4, 25, 26, -15, 5, 2, -6, -2,
    -9, -37, -13, 21, 25, 31, -48, -6,
    -4, -8, 25, -35, -1, 3, 2, -27,
    10, 0, -11, 10, -35, -19, 44, -13,
    -1, 3, 36, 9, -1, 14, 1, 6,
    -7, 63, -15, -16, 2, -23, 7, 44,
    -1, 26, -21, -3, 5, 5, 6, -2,
    5, 5, 5, 29, 7, 16, 45, -1,
    -11, -33, -4, -15, 5, 8, -4, -6,
    14, 20, -27, -26, 23, -32, -7, -19,
    16, 3, 10, -11, 26, -14, 5, -13,
    -7, -9, 3, 6, -13, -6, -4, 19,
    0, -26, 5, 32, 12, 4, -19, -12,
    36, 19, -3, 13, 9, -1, 1, -33,
    -16, -9, 20, 2, 3, 1, -14, -11,
    12, -5, 1, 0, -31, 7, 22, 10,
    13, -21, 42, 44, -20, -7, -19, 8,
    5, 4, 28, 33, -8, 3, -21, -7,
    25, 4, 2, -6, 16, -4, 6, -27,
    -16, 14, 4, 2, 33, -11, -22, -26,
    -20, -29, 7, 21, 7, 4, 4, -6,
    -25, 3, 33, -15, -36, 1, -19, -16,
    5, 6, -28, 18, -1, -12, -2, 0,
    4, 8, 3, 2, -26, -9, 48, 2,
    -22, 40, -43, 20, 1, 6, 2, -2,
    -22, -33, 7, 10, 31, 3, 29, 45,
    0, -14, 21, -2, 5, 7, 2, -7,
    1, -58, -10, -2, -36, 16, 4, 9,
    -25, 2, -5, -32, 9, 1, 0, -9,
    25, -2, 12, -12, -40, -1, 0, -44,
    12, 18, 26, 50, -14, 1, 25, 32,
    0, 0, 6, -7, -15, 57, -26, -5,
    -23, 16, -57, -28, 7, 9, -9, 4,
    13, 8, -28, 34, -82, 31, 3, -4,
    11, 0, 87, -66, 9, 1, 84, -59,
    2, 22, 44, 24, -27, 1, -89, -23,
    -65, 35, -84, 59, -16, 8, -29, 21,
    20, -36, -12, -71, -12, 16, 3, -1,
    26, -21, -37, 2, 23, -9, -21, 7,
    -17, -25, -32, -4, 0, 6, 13, 37,
    -50, 35, -3, 16, 9, 30, 7, 10,
    4, 0, -2, 21, 5, -1, -18, -44,
    42, -5, -36, -5, 47, -42, 32, 18,
    -5, -31, 6, -16, 36, -12, 36, 30,
    93, 33, 29, 5, 24, 5, 4, -5,
    4, 14, 2, 79, -28, 11, -24, -15,
    -5, 29, -9, -1, 2, 19, 1, -13,
    -10, 14, -13, 2, 18, -40, 25, 27,
    -26, -12, 9, 31, -11, -11, 21, -28,
    13, 9, 35, -22, -9, -30, -14, 28,
    -37, -21, -34, -17, 38, 14, -61, -68,
    -4, 56, 39, -9, -36, -51, 55, 30,
    26, -4, 42, 47, -26, 5, -3, -25,
    18, 68, 94, -66, 1, -87, -50, -21,
    2, -40, -9, 10, 46, -47, -35, -57,
    25, -33, -9, 35, -21, 0, -25, 9,
    35, 46, 5, 24, 48, -1, -8, 0,
    -1, -30, 6, 22, -51, 29, 0, -51,
    -2, 13, -2, -28, 33, -22, -4, -18,
    12, 21, 12, 33, -52, 4, 1, -19,
    4, 42, 7, -100, -40, -24, 3, 6,
    73, -10, -49, -80, 29, 0, -6, -34,
    31, -76, -50, 12, 10, -44, -84, 28,
    -44, -30, 14, -6, 6, -43, 42, -45,
    38, 14, 71, -23, 1, -15, 26, -8,
    -49, -35, -15, -49, -74, 30, -51, -12,
    -15, 4, -5, 58, -3, -37, -26, 42,
    -23, -9, -20, -20, 1, 5, -18, -2,
    -27, 30, 16, -86, 21, 0, -17, -8,
    -47, 35, 22, -11, -19, -32, -15, 23,
    -27, -16, -5, 7, 34, 17, 8, 4,
    -7, -36, 1, 8, 31, -13, -15, -36,
    -54, -26, -31, -18, -15, 3, 123, 6,
    15, 26, -4, 8, -12, -41, -25, 14,
    4, -28, -1, 16, 0, -9, 41, -26,
    -4, -26, 5, -4, -41, 5, 111, 14,
    -37, 27, 56, 44, 2, -35, 37, 3,
    0, -11, -16, 37, 2, -77, 55, 29,
    -35, -12, 17, -14, -40, -6, 9, 27,
    19, -13, 20, 3, -39, -31, 16, -20,
    28, -34, -4, -6, -90, -33, -3, 22,
    29, 55, 17, -1, -14, -29, -6, 18,
    -32, 30, -44, 11, -5, 44, -8, -27,
    -6, -7, 1, -40, 30, -21, 22, 0,
    -17, 46, 77, 28, 6, 18, 15, -13,
    -29, 32, 2, -2, 7, 43, -4, 34,
    -6, -16, -37, 55, -11, 8, 8, 37,
    42, 19, -1, 3, -27, 46, -9, -34,
    62, 67, 8, -46, 19, 22, 28, 30,
    29, -37, 45, 21, 3, 15, 22, 40,
    -14, 33, 15, 8, -10, -3, 29, 13,
    2, 1, 16, -27, 6, 29, -35, 10,
    -5, 30, 20, 76, -29, -17, -5, 37,
    10, 23, 29, 59, 41, 33, 20, 17,
    10, -4, -40, -18, 3, -8, -29, -28,
    -23, -38, -10, -10, -54, 25, 27, -44,
    40, -19, 13, 100, 27, 3, 25, 37,
    9, 20, -2, -5, 6, 1, -6, -49,
    12, -29, 1, -14, 4, 9, 4, 1,
    2, 23, 35, -35, 91, 38, 18, -7,
    27, 77, 11, -14, 31, 12, -14, 19,
    -54, -16, 9, 30, 8, -65, 45, -6,
    -1, 8, 5, 20, 4, -3, 0, -13,
    -4, 127, 46, -2, 7, 25, 4, 61,
    -25, -53, 29, -13, 75, 10, -16, -4,
    3, -16, 40, -83, -2, -3, 18, 20,
    5, -4, -14, -19, -1, -7, 1, -31,
    43, -47, -1, 2, 19, 19, 11, 31,
    -20, 16, -71, 14, -2, 15, -5, 11,
    -33, 42, 67, -55, 36, 40, -3, 26,
    -12, 18, 28, 24, 13, 75, 9, 36,
    -36, -24, -21, -24, -11, 74, -22, 63,
    8, -56, -37, 17, 5, 30, -7, -2,
    -111, 1, -44, 41, 1, 74, 8, 84,
    17, 6, -7, 85, -30, 12, 0, 40,
    28, 21, 34, -1, -31, -20, 7, -117,
    -1, -18, -62, -35, -52, -28, -15, 5,
    -38, 2, 38, 23, -26, -32, -9, -13,
    12, 67, 7, -25, 31, 4, 26, -5,
    -23, -9, -1, -7, -10, 4, 33, -28,
    -85, -13, -5, -75, -36, -4, 9, 12,
    -24, -4, 5, 25, 43, 17, -1, 20,
    24, 4, -14, 45, 11, 48, 4, 37,
    -3, -15, 2, 19, 40, -54, -85, 1,
    44, -59, 28, 41, -9, -25, -56, -3,
    -44, 20, -62, 54, 57, -24, 54, -16,
    -16, -28, -64, -1, -10, 12, 5, -39,
    17, -1, 3, -12, 17, -19, 29, 17,
    15, 6, 11, -32, 11, -23, -22, 20,
    -93, 65, -37, 37, 1, 1, -27, 1,
    11, -12, 19, -22, -4, 7, 32, -75,
    27, -7, 7, -8, -50, -32, 39, 9,
    10, -5, 23, 64, 19, 15, -8, 13,
    -29, 4, 44, -39, 14, -3, -4, 60,
    11, 20, -18, 1, 23, 16, -10, -4,
    -2, 16, 19, 50, -18, -9, 43, 2,
    -38, 27, -3, 24, 4, 44, 33, -9,
    -2, -32, 15, -9, 23, 2, -17, -5,
    26, -11, 3, -30, 68, 10, 3, -31,
    -10, -30, 13, 4, 2, 15, -7, 7,
    29, -38, -8, -16, 23, 24, 2, -2,
    13, -17, -41, -3, 59, -10, 16, -14,
    -19, -13, 10, 26, -11, -7, -19, -41,
    -1, -43, -13, 10, -40, -1, 27, 4,
    88, 9, 43, 60, 46, 13, 54, 2,
    -24, 40, 15, 17, 3, 26, 25, -26,
    10, 7, -10, -1, 34, -2, 8, -29,
    -17, 35, 2, 10, 6, 19, -39, -48,
    -65, -11, -31, 17, 2, 25, 1, -26,
    -44, -44, -8, -48, -35, -19, 32, -19,
    5, 14, -42, -13, -6, 3, -17, -9,
    2, 0, 0, 20, -41, -20, 68, -1,
    -37, 65, -1, 35, -4, 29, -1, 15,
    -13, -7, -21, -36, 35, 2, 22, -35,
    -20, -15, 5, 25, 11, -20, -24, -21,
    1, -104, -13, 15, -52, 8, -12, 56,
    -29, -15, 28, -14, 7, -9, 18, 6,
    20, -5, -26, -22, -15, -30, -28, 5,
    -1, -5, 55, 74, -34, 10, 37, 79,
    2, 9, 13, -2, -16, 40, -24, 1,
    27, -26, -50, -40, 43, -1, 11, 15,
    22, -42, -27, -40, 31, 25, 23, -5,
    2, -4, -10, 12, -10, -31, 17, 14,
    -42, -32, 20, -4, -8, -12, 22, 14,
    19, 1, 43, 21, 43, 23, -30, 16,
    17, 4, 1, 27, 11, -7, 5, -30,
    0, -10, 0, -1, 29, 1, -7, 9,
    1, -15, -6, -8, 9, 3, -8, 13,
    14, -12, 4, -39, 8, 4, -5, 24,
    -22, 15, 26, 21, -10, -7, -24, -7,
    10, 1, 4, -1, 23, -18, 7, -3,
    -6, -1, -3, 3, 12, -27, 10, 21,
    -35, -10, -12, -26, 24, -25, 30, 21,
    21, 57, 28, -32, -7, -19, -5, -13,
    -2, 1, -12, -13, -12, -3, 11, -16,
    -59, 0, -42, 19, -8, 8, 13, -5,
    45, 17, -10, -6, 26, 12, -24, -6,
    27, 23, 1, 6, -35, 17, -71, -1,
    -6, -5, 9, 0, 12, 22, -11, -6,
    36, 41, 2, -5, 39, 14, -5, -15,
    -6, 15, 9, 16, -4, 19, -25, -45,
    -3, -28, -28, -18, -30, 24, -29, 33,
    1, -5, -6, 33, -15, -1, -3, -9,
    29, 9, -50, 7, -11, -24, -7, -16,
    -7, -15, 15, -27, 38, -24, -38, 20,
    -82, 27, -25, 26, -52, -7, -13, 12,
    0, -7, 2, 0, -3, -33, -15, -8,
    4, 21, 16, 31, 1, 8, -5, -9,
    -27, -10, -4, -5, -10, -60, 0, -16,
    -14, -16, -24, 15, -23, 38, 16, 8,
    7, -3, -7, -8, -19, 15, 7, 22,
    -59, -12, -20, 9, -36, -9, 2, 8,
    10, -6, 7, -32, -6, 32, 17, 0,
    -19, 8, 7, -41, 1, 31, -17, -1,
    8, -2, -15, -2, -11, 15, 24, 18,
    6, -11, 17, 11, 1, 14, -12, 14,
    8, -1, 23, -11, 46, 15, -5, 0,
    -22, 56, 21, 33, -40, -11, 0, -9,
    4, -11, -8, -7, -7, 5, 20, 25,
    -34, -4, 16, -4, 2, 8, 13, 7,
    26, -3, -12, -35, -2, 5, -26, -25,
    23, -20, -7, 1, 55, -51, 3, 18,
    10, 4, 3, -6, 16, -7, -23, -8,
    19, 22, -4, -11, -5, 39, 16, 7,
    -19, 37, 37, 1, 10, -8, 16, -29,
    10, 18, 46, -8, 4, -29, -22, -1,
    -1, 2, 9, 15, 1, 7, 10, 1,
    9, -5, 18, 10, 15, 5, 14, 8,
    19, 8, 2, -35, 18, 20, -13, 27,
    -20, -34, 25, 5, 17, 15, 5, -26,
    -5, -12, -13, 0, -10, -16, -12, -5,
    -8, 42, 25, 3, -4, -11, -7, -10,
    35, 4, -16, 8, 8, 0, -8, -20,
    -50, -9, 21, -13, 16, 33, -10, 20,
    -2, -11, 10, 5, -52, 1, 11, -13,
    8, -21, 15, 16, 1, 2, -1, -22,
    7, -6, 3, -31, -66, 23, 13, -19,
    -1, 25, 10, -13, -20, 15, 13, 11,
    2, -3, 8, 0, 30, -13, 1, 1,
    -39, 31, -16, 1, 10, -15, -3, 22,
    -16, -1, -2, 17, -3, 17, -34, 8,
    36, 3, 37, 20, -3, -19, -27, 10,
    6, 10, 11, -1, 43, -2, 26, -17,
    -54, -43, -23, 19, 35, 11, -15, -12,
    -11, -5, 3, 15, 8, 9, 13, -18,
    -40, 52, 3, 14, -39, 22, -5, -28,
    -9, 7, -8, 2, -33, 7, 14, 26,
    12, -2, 3, 21, 13, -32, -7, -22,
    14, 28, -4, -1, -12, 49, -20, 20,
    -8, -52, -7, 31, -5, 11, 13, 13,
    4, 1, 5, 3, -9, 17, 34, -10,
    3, 6, -9, 6, -21, 18, 16, -16,
    22, -10, 11, 0, 14, -8, -17, 6,
    -30, 25, 11, -7, -2, -3, -19, 9,
    12, -18, 2, -2, 26, -10, 13, 3,
    24, 10, 15, 4, 14, -4, -11, 11,
    14, 2, 0, 15, 18, -8, -15, -45,
    -61, -25, 16, 14, 20, -37, 48, -23,
    7, -2, 14, -14, -8, 8, 4, -2,
    -17, -19, -7, -18, 9, 15, -4, 16,
    -32, 29, -11, -2, 18, 36, 5, 5,
    -10, 73, -44, 28, 22, 0, 8, -17,
    -3, -14, -7, 1, -21, 19, 9, 16,
    20, 29, 7, -4, 7, -8, 0, 0,
    -12, -5, 14, 7, -55, -37, -40, 13,
    42, 0, -27, -21, -71, -58, 60, -27,
    -14, 3, 1, 16, 11, -5, -7, 38,
    18, 31, 7, -10, 0, -4, 0, 10,
    14, -7, 5, 6, 27, -56, 64, 10,
    8, 14, 42, 31, -1, 9, 15, -43,
    1, -12, -5, -8, 8, -1, 0, 15,
    14, -13, -19, 45, -36, -1, 14, 4,
    -21, -50, 25, 28, 6, 3, -6, -24,
    48, -27, 0, -9, 31, 0, 1, 28,
    -5, 3, 5, 15, -22, 9, -3, 10,
    -3, -18, 27, -15, 25, -18, -2, -8,
    2, -4, -35, -5, 16, 4, -26, 7,
    11, -49, 7, 5, -33, 18, 1, 115,
    -1, 2, -8, 11, 7, -18, 12, -33,
    6, 27, 46, -63, 10, -11, -4, -32,
    20, -37, 16, -3, 9, 7, 0, 50,
    3, -47, -17, -29, -49, -18, -25, 4,
    -4, 1, 8, 7, 21, -16, 0, 13,
    3, 0, 14, 26, -2, 15, -15, -20,
    -10, -3, 2, -3, -23, -12, -32, -36,
    -16, -4, -42, 26, -17, 26, 8, -42,
    6, -11, 6, -5, 16, -30, -3, 16,
    -2, 16, 17, -6, -8, 13, 9, 7,
    3, -17, -19, 0, 25, 44, -26, -50,
    15, -42, -20, -1, 35, -14, -9, -42,
    3, 10, -4, -2, 21, -25, -22, -15,
    -19, -8, 3, -5, 18, -12, -13, -2,
    15, -9, 30, -15, 37, -3, 18, -22,
    -23, 6, 8, 37, 3, 5, 36, -25,
    1, -20, 5, -16, 10, -10, -24, 5,
    -27, 21, 6, -3, 24, 1, -14, 12,
    34, -6, 22, -37, 18, -2, 11, -20,
    -27, -1, -32, -10, 4, 6, -14, -34,
    9, -2, -4, 0, -15, 9, -24, 10,
    -29, 3, -17, 17, 3, 1, 5, -8,
    -12, 0, 2, -11, 5, 22, -19, 3,
    0, 59, 13, -54, -8, -13, 29, -26,
    -4, 6, -15, -10, -17, -10, -12, 6,
    19, 39, -6, 10, -10, -9, -2, 1,
    -6, -11, 13, 18, -39, -3, 25, -9,
    22, 16, -41, 23, -46, -14, -3, 9,
    2, 12, 4, 3, -6, -6, -16, 12,
    9, -13, 4, -16, -17, 23, -8, -9,
    11, 0, -16, 31, -21, -2, 18, -13,
    25, 8, -15, -21, 10, 28, -27, 23,
    11, -8, 5, 36, -2, -2, 15, -37,
    -21, -20, 1, -38, 12, 2, 13, -11,
    21, -12, 22, 30, 46, 18, 43, -11,
    -19, 17, 43, -17, 24, -11, 14, 2,
    -11, -19, 2, -14, 4, -19, -15, -6,
    -31, -19, -3, -2, 34, 38, 1, 0,
    -10, 18, -1, -35, 5, -26, 0, -2,
    30, 8, 34, -2, -13, -23, -4, -40,
    1, 10, 13, 5, 13, -32, 2, -19,
    11, 34, -7, -12, -16, -18, 43, -8,
    -20, 6, 1, -37, 37, 1, 29, 45,
    2, 18, 26, -24, -13, 1, -40, -13,
    -22, 11, -2, 17, 3, 1, -12, 1,
    17, 37, 21, -22, -30, -18, -4, 9,
    32, 33, 3, 23, 5, -13, 8, -54,
    22, 29, 32, 10, 15, -3, -24, -13,
    0, -3, 9, -6, 20, 9, -14, -13,
    -10, 2, 13, 7, 22, 3, -2, -12,
    31, 13, 25, 21, -25, 60, 24, -9,
    -46, -1, -33, 4, 7, 38, -1, 16,
    6, -5, 30, 38, -1, -9, -17, -21,
    -14, -10, -13, 12, 19, -9, 21, 17,
    13, -16, 11, -25, -23, 22, 7, -36,
    -8, -6, -9, 12, -75, 6, 14, 0,
    14, -5, -1, -4, -31, -10, -17, -21,
    -78, 18, 8, 0, -16, -10, 13, -13,
    -12, -44, -7, 7, 8, -37, -36, -27,
    11, -17, -13, 32, -5, -22, 51, 27,
    11, -21, 0, -46, 9, -16, 12, 1,
    -48, -23, -22, -8, 21, -34, -21, 28,
    12, -21, 1, -52, -35, -22, 5, 36,
    -18, 83, -10, 19, -8, -16, 56, 41,
    18, 25, -2, -14, 12, 20, -6, 14,
    -7, -11, -10, 56, 0, 33, 10, -6,
    12, -7, 19, 30, 69, 12, -15, -6,
    -18, 43, 25, 39, 14, 28, -1, 19,
    -9, 0, -1, 7, -25, -17, 4, 12,
    -32, 37, 1, -17, 3, 12, 16, 24,
    36, 1, 4, -29, -17, -13, 22, -24,
    13, -1, 34, 51, 13, -41, -12, -59,
    -5, -14, 10, 1, -3, -30, -5, 0,
    -22, -29, -50, 26, 39, 1, 9, -8,
    -33, 67, 36, 28, 12, 21, 28, 3,
    -11, 7, 19, 4, -31, -8, -34, 14,
    -6, 7, -3, -5, -7, -6, -19, -7,
    13, 0, -8, -24, 14, 24, -5, -5,
    25, -8, -11, -11, 22, 12, 6, -12,
    7, -43, 27, 4, -26, 59, 1, 34,
    -29, -9, -4, -3, -3, -16, 22, 18,
    5, -5, -19, 38, 10, -5, 0, 5,
    8, -2, -24, -6, 15, -16, -7, -6,
    -14, -31, 9, -35, 7, -24, 9, -12,
    -16, -26, 8, 0, 18, 26, 32, -26,
    27, -29, -23, 9, 11, -6, 16, -31,
    1, -59, -21, -30, -48, 22, 21, -25,
    -22, 35, -42, 11, 8, 13, 7, -24,
    4, 8, -17, -7, 14, 6, 21, 1,
    -27, -16, -60, 37, 14, -13, -2, 25,
    -9, -24, -1, -26, -12, -19, 20, 6,
    12, -14, 54, -44, 0, -29, -8, 1,
    6, -12, -7, -23, 95, -18, -5, -23,
    -43, -34, 22, 21, 17, 24, 7, 39,
    -9, -36, -17, -5, -15, -46, -21, 12,
    10, 20, 5, -3, -5, 58, -44, -11,
    21, 0, -35, 3, -9, -5, 4, 11,
    7, -36, -11, 35, 33, -28, -3, -17,
    18, 34, -8, -14, -2, -53, 32, 31,
    -3, -2, -15, -3, 4, 7, -8, -28,
    -3, 5, -4, -3, 1, 3, 25, 3,
    20, -21, -34, 18, -11, 2, -2, 4,
    12, 6, 13, -22, -18, 15, -3, 78,
    1, 10, -20, 10, -5, -20, -5, 3,
    2, -8, 5, -37, -1, -11, -1, 20,
    -8, 13, -6, -12, -6, -7, -20, 8,
    5, 0, 2, -18, 12, -35, -15, 50,
    -21, -22, 32, 24, -1, -1, 14, 20,
    3, 16, 28, -27, 0, 5, 0, 18,
    47, 22, -3, -10, 6, 15, -14, 25,
    1, 11, 52, -24, -36, 7, -8, 55,
    -28, 26, 6, -16, -29, 28, 25, 22,
    13, 7, 3, -11, 24, -32, 6, 2,
    23, 54, -26, 10, -34, 22, 1, 34,
    -1, -7, -2, -56, -25, -70, -45, -28,
    19, 16, -17, -8, -25, -36, 24, -25,
    -8, -8, -18, 23, -22, 8, 6, 30,
    20, 28, 25, -15, -9, -4, 3, 10,
    18, -12, 24, 16, -53, 0, -16, 9,
    3, -5, 3, -54, 13, 37, -10, 12,
    15, -23, -16, 6, 15, -22, -8, 26,
    7, 10, -16, 44, -34, 2, 42, -18,
    -15, -50, -34, 27, -15, -28, 67, 22,
    6, 16, -24, -41, -15, -17, 47, -46,
    -15, 37, 16, 11, -14, -1, -21, -2,
    30, -30, 3, 34, 11, 14, 30, -11,
    13, 9, -58, 18, -21, -1, -19, 19,
    26, -42, 28, -16, -36, -14, -11, -18,
    30, -11, 3, -1, 6, -13, -6, 4,
    41, -17, 30, -7, -8, 4, -10, -25,
    44, -41, 3, 9, 9, 7, -6, 39,
    45, 0, -27, -27, -55, -7, -2, 9,
    -2, 2, -1, 0, 24, -8, 8, -5,
    1, 16, 24, 34, -13, -12, 5, -15,
    1, -10, -52, -12, 36, 27, 29, -93,
    -6, 17, -7, 36, 39, 4, -28, -40,
    4, -16, -8, -2, 24, -3, -20, -22,
    3, -6, 3, 7, -44, 16, -15, 3,
    41, -25, -21, 10, -20, 19, 17, -40,
    30, 27, 39, 17, 12, 27, -5, 34,
    3, 26, -7, -4, 35, -17, -2, 19,
    -7, -1, 20, -17, -1, -6, -6, 11,
    29, -22, 19, 7, 3, -3, 2, 11,
    -48, -12, 46, 11, 44, 0, -41, 11,
    0, 1, 21, -15, -20, -8, 7, 0,
    0, 13, 13, -17, 10, -8, 2, 22,
    43, 4, 74, -43, -31, 6, 13, -30,
    -20, 19, -16, -1, -1, 6, 8, -19,
    28, -30, -14, -12, -9, 2, 4, -1,
    -12, 12, 16, 38, 16, -20, -16, 23,
    -7, -1, 33, -5, -19, -35, 24, -17,
    -2, -1, 7, -23, -27, -5, -6, -11,
    -27, 5, -13, -2, -20, 17, 15, 3,
    21, 94, -4, 18, 2, 14, 9, 30,
    -6, 4, 14, -7, -15, -4, -67, 14,
    12, 15, -12, -12, -32, -51, -26, -49,
    3, -4, -12, 9, -6, -28, 3, -13,
    -2, -5, -8, -7, -12, -10, -23, -33,
    -50, -22, 1, 22, -6, -23, 20, 19,
    15, 31, 32, 35, -18, 6, -22, 59,
    22, -8, 11, 57, -3, -9, -1, 21,
    -34, -32, -10, 7, -7, -6, 0, -12,
    4, -31, 18, 0, 46, -13, -30, 0,
    -20, -78, 27, -15, -41, 14, -26, 56,
    -15, -24, 5, -27, -7, -34, -16, -6,
    43, 21, -4, 19, 7, 19, -30, 6,
    22, -18, 15, -30, -15, -2, 18, -43,
    99, 20, 20, -13, -11, 5, 24, -17,
    12, 19, 39, -1, -11, -12, 0, -5,
    -9, 42, 27, 41, 16, 4, -33, -1,
    -23, -3, 63, -41, 37, -46, -5, -18,
    4, -51, 75, -4, -41, 32, -55, 0,
    -43, 17, -4, 32, 19, 30, -9, 27,
    28, 18, -14, 59, -43, -56, 23, 26,
    46, 68, -44, -22, 20, -70, -14, 28,
    -7, 14, 22, -29, -9, 48, -8, -52,
    11, 6, 10, 4, 5, -35, 30, 5,
    3, 60, 26, 14, -12, -3, 28, -29,
    46, 41, 40, -10, -15, -4, 47, -15,
    -16, 10, 66, 4, 0, 6, -27, 1,
    -2, -7, 106, 23, 6, -7, 1, 11,
    -40, -20, -18, 18, -23, 5, 23, -34,
    27, -18, -4, -44, 21, 1, 46, 43,
    -52, 7, -2, 21, 7, 18, 29, 26,
    4, 14, 2, 28, 17, -2, 8, -24,
    54, 12, -1, -2, 19, 15, -4, -37,
    18, -52, -11, 38, -23, -57, -3, -64,
    -60, -17, 5, -96, -19, -18, 55, -70,
    12, -50, -30, -87, 49, 4, 35, 7,
    -119, -10, 11, -78, -3, -12, -57, 32,
    5, 6, 26, -35, -17, -7, 15, -16,
    6, -41, 8, 16, -48, -51, -64, -64,
    6, -18, -21, -27, 48, -6, -10, -6,
    -68, 61, 30, 28, 6, 14, 9, -43,
    6, -41, 0, 57, 44, 62, -11, -25,
    -32, -18, 2, 25, -15, 24, -44, 29,
    -4, -1, 2, 19, -26, -21, 4, -32,
    19, 13, 27, 61, -8, -3, 10, 30,
    20, 11, 3, -16, -17, -29, -8, -35,
    -3, -126, 29, -51, -25, -40, 64, -28,
    -19, -22, 27, -8, -37, 6, 8, -45,
    -28, 62, -9, -12, 21, -21, -8, 13,
    -34, 13, 29, 37, 41, -86, -29, 31,
    -77, -44, -21, 29, -37, -37, 40, -7,
    -46, 21, 4, -7, -32, 18, -72, -4,
    24, 5, 44, -10, -19, 7, 31, -4,
    11, 26, 20, -11, 28, -31, -32, -16,
    92, -42, 12, -58, -7, 38, 30, -16,
    -70, 0, 11, 6, -13, -36, 9, 51,
    -34, 7, -29, -3, -8, -1, 13, -31,
    -1, 36, -40, -8, 41, -44, -17, -57,
    41, 55, 34, 18, 23, -8, 43, 18,
    -19, -54, 10, -3, 38, 30, -28, -8,
    8, -7, -25, 21, -48, -9, 2, -17,
    0, -80, -27, 12, -6, -16, 13, -42,
    -16, 24, 9, -2, 32, 18, -12, 32,
    1, -14, -49, -5, -16, -10, -2, -18,
    33, -20, 0, -34, 13, 47, 2, -13,
    5, -84, 3, -10, 3, -12, 11, 23,
    42, 5, 19, 3, -2, -38, 35, 3,
    6, -6, -18, -41, 127, -10, -46, 7,
    -17, 18, 13, -37, 4, 12, -13, -6,
    -28, -27, 44, -10, -30, 19, -36, 5,
    58, -7, -1, -20, -35, 16, -34, 5,
    14, -9, -59, 2, 16, -21, -23, 4,
    22, 71, -4, 7, -41, -88, 33, -6,
    -8, 127, -17, 10, -10, -26, -23, -8,
    -110, -1, -24, -63, 2, -18, 2, -67,
    -4, -5, -7, 27, -7, 8, 2, -10,
    7, -63, 27, -5, -40, -22, 7, 36,
    2, -32, 13, -22, -35, 28, -40, -47,
    67, -1, -13, -4, -2, -7, -14, 8,
    -2, 16, 2, -90, -13, 20, 6, -33,
    44, -13, 14, -16, -12, 15, 2, 11,
    -5, -11, 6, 16, 42, -24, -12, 2,
    5, -12, -13, -13, 3, 74, -34, -18,
    16, 13, 50, -19, 35, 17, 34, 14,
    10, -3, -17, -18, -5, -22, -22, 18,
    31, 69, 41, 5, 34, 5, 12, -16,
    -39, -4, 66, 33, -70, 14, 4, -40,
    26, 13, 13, 6, -4, -84, 11, 2,
    -13, 90, 35, -15, -18, 28, 11, 38,
    49, 30, -17, -61, -78, -51, 76, -63,
    -84, 33, -2, -38, -4, -21, -12, -25,
    -17, -19, 0, 25, -49, 14, -9, 37,
    16, 19, 47, 16, -25, -17, -12, 7,
    44, -15, 55, 19, 28, -28, 7, -16,
    -18, -23, -27, 22, 52, 11, 2, 36,
    19, -20, -37, 22, 17, 4, -8, -15,
    -42, -2, -51, 63, -2, 9, 34, -9,
    -112, -2, -42, -28, -31, -28, 56, 55,
    19, 56, 33, 13, -24, 80, 45, -56,
    0, 77, 55, -7, 21, 11, 9, -1,
    46, 14, 36, 11, -60, 52, -18, -30,
    90, -13, -67, 25, 27, -9, -31, 4,
    14, 78, -31, -17, -22, 19, -16, -27,
    29, -9, 19, 21, 9, 10, -54, 1,
    -28, 56, -9, -52, 21, 0, -11, -56,
    23, -23, -3, 24, 21, 47, 6, 56,
    44, -9, 91, 10, -44, 14, 52, 11,
    -14, 13, -4, -7, 65, 0, 25, -30,
    -47, -39, -26, 49, 12, -12, 19, -13,
    8, 19, -77, -16, 6, -23, 13, -72,
    -5, 88, 19, 21, 36, -10, -22, -100,
    -1, -52, 8, -2, -2, -18, -12, 10,
    -35, 17, 24, -26, -48, -35, -4, 10,
    61, -18, 26, -25, -26, 63, 4, 18,
    5, -19, -3, -5, 43, -9, -41, 33,
    29, 36, 14, -10, 28, 6, -7, 0,
    -32, -1, 3, 1, -1, -21, 30, 51,
    28, -35, 16, -26, 18, 21, 15, 21,
    -115, -12, -13, -35, 96, 30, -51, 5,
    -2, -9, 33, -26, -52, -19, 4, -23,
    20, 24, -25, -9, -7, -10, 19, 25,
    49, -14, 59, -82, 1, -6, -75, -7,
    -30, 5, 48, 33, 28, 53, 30, 66,
    76, -58, -12, -19, 17, 0, 36, 7,
    35, 14, 40, 14, 20, -2, -38, -32,
    49, -2, 68, 18, -5, -10, 28, -23,
    7, -65, -76, -8, 27, -49, 17, 13,
    -50, 6, -5, -11, -10, 27, 30, -1,
    79, 22, -55, 77, -6, 27, -17, -19,
    22, 4, 10, -21, -56, -24, -59, 37,
    48, 12, -4, -41, 16, -2, 15, 35,
    7, -39, 2, 18, -25, -25, 12, -56,
    -33, 35, -10, -9, 21, -30, -12, -24,
    -51, 37, 29, 59, -31, 28, -10, -8,
    -44, -38, -23, -29, 7, -6, 25, 23,
    -30, -49, 31, 35, -19, 1, -64, 7,
    -30, 18, -28, 3, 10, -8, -3, -2,
    8, 25, 22, -9, 3, -5, -2, 16,
    30, 11, -19, 54, 3, 26, -3, 22,
    -10, 4, 30, -26, 50, 1, 14, 29,
    81, -26, -10, 1, -12, 7, -2, 21,
    -6, -16, 11, -29, -17, -1, -9, -1,
    18, -2, 21, 9, -4, 24, -16, -14,
    6, -39, -32, -9, 35, 22, 20, -11,
    4, 11, 16, -21, 16, 11, 8, 39,
    -4, -4, -3, -17, 14, 22, 4, -9,
    -42, 2, -4, -41, 0, 32, -25, -14,
    2, -38, -2, -56, 3, -25, 24, -21,
    13, -15, 28, -20, 2, 12, 8, 30,
    -4, 11, 1, 15, -5, 1, 8, -15,
    11, 0, -24, -2, -36, 18, -48, 43,
    -3, 11, 33, -37, -15, -8, -32, 4,
    -7, 12, -6, -28, -6, -12, -1, -15,
    -10, 0, -5, 4, 2, -8, -1, 31,
    7, -26, -19, 27, -31, 4, -6, 11,
    -6, 22, -11, 35, 21, 8, -38, -1,
    26, 5, 5, -32, 14, -26, -18, -25,
    17, -28, -25, -2, 9, 20, 8, 11,
    2, 6, -24, 19, 4, -24, 0, -15,
    -25, 4, 6, -27, 11, 13, 2, 13,
    -26, -49, 12, -15, 9, 27, -12, 1,
    11, 9, 7, -21, -22, 0, -20, -15,
    8, -29, 10, -9, -15, 18, 0, 7,
    -13, -45, -10, 3, 52, 46, -8, 17,
    8, 21, -14, -17, -20, -5, 6, 21,
    1, -26, 7, 28, -2, 3, 8, -9,
    27, -14, -37, -3, -9, -3, 55, -8,
    -10, 1, -23, 9, -15, 49, -3, -24,
    4, 2, -29, 9, -5, -9, 19, -2,
    -1, 19, -7, 12, 1, -14, 7, 6,
    -6, 7, -7, 14, 15, 15, 19, -9,
    -6, 27, -11, -3, 5, 20, 13, 1,
    13, -23, -8, 29, -2, 11, 24, -8,
    3, -11, -21, -21, 7, 26, 0, -6,
    -17, -10, -1, -5, 35, 47, 14, 19,
    -27, 12, 9, 5, 6, 8, 12, 11,
    -4, -17, -3, 3, -3, -20, -17, 14,
    1, -6, -9, 19, 17, -37, -1, 10,
    14, -21, -8, 13, -2, -28, 3, 31,
    14, 34, -3, 7, -15, -17, -22, -8,
    19, 6, 5, 2, 15, -3, -7, -13,
    -6, -14, -20, 7, 17, -10, -8, 12,
    -18, -43, 32, 18, 25, 0, -23, 12,
    -7, -1, 4, 11, 7, -50, 4, -7,
    7, -6, -13, 3, -14, 5, -8, 22,
    32, -11, 11, -1, -5, 11, 4, 1,
    26, 17, 24, 49, 12, 25, -13, 15,
    -8, 13, 30, 0, -12, -39, 37, -6,
    15, -1, 58, 0, -18, -12, 3, -4,
    12, 15, 10, 3, 11, -7, -13, 23,
    4, -15, -10, 12, -2, -6, 12, -30,
    -23, 22, -21, 11, 2, 17, -2, 22,
    -4, -11, 4, 7, 8, 10, -1, -13,
    -8, -10, -26, -18, -24, 2, -12, 2,
    32, -23, -34, -41, 19, 7, -13, -25,
    4, -32, -23, 9, -6, -4, 63, -13,
    32, -31, -12, -24, 14, -12, -27, -19,
    10, -16, -21, 6, 5, 23, -7, 20,
    9, -43, -28, 20, -20, -5, 4, -2,
    19, 31, -9, 38, -2, -38, 12, -4,
    1, -29, 19, -9, 13, -11, 3, 2,
    9, -4, -20, -13, 4, 3, 29, -8,
    15, -20, 10, -10, -19, 8, 10, 12,
    -9, 19, -12, 39, 18, 16, 18, -13,
    32, -31, 8, 19, -10, 16, 13, -11,
    9, 5, -7, -20, 3, 16, -3, 4,
    -3, 21, 11, -13, 15, -2, -4, -9,
    7, 31, -3, 21, -32, -31, 0, 6,
    -22, -6, -4, 17, 14, -19, 18, -11,
    2, -5, -14, -5, 13, 24, -19, -3,
    20, -19, 11, 13, -19, -3, 2, -19,
    -29, -10, -31, -17, -9, 15, -21, 15,
    34, -4, 11, -2, -19, -38, -4, -3,
    11, -10, 8, -2, 8, 1, -6, -20,
    6, -1, -16, 4, -13, 9, 12, -2,
    -11, 2, -64, -24, -5, 13, 19, -15,
    10, -1, -24, 11, -4, 12, -11, -3,
    1, -21, 14, -17, 4, -7, 8, 4,
    35, 30, -34, 13, -36, 7, 42, -14,
    19, 2, -15, 31, 27, -44, -38, 0,
    34, 5, -1, 28, -6, 7, -23, -1,
    -27, 5, 3, -16, -13, -1, 13, -4,
    12, 21, -21, -14, -26, -14, -1, 21,
    13, 5, -15, 34, -2, 12, 10, 25,
    4, -1, 22, -29, -1, 2, -1, 6,
    -1, -11, 18, 0, 0, -14, -13, 7,
    -17, 18, 4, -13, -12, -27, -16, 25,
    6, -7, 30, 18, -5, -29, -6, -4,
    7, 0, 48, 20, 7, -13, -12, -14,
    21, -44, -18, -20, 12, -23, 21, -27,
    -5, -19, 2, -4, 2, 8, -6, -6,
    -2, -12, 53, 27, 16, -33, 49, -27,
    3, -3, -26, -30, 3, 23, -16, -24,
    27, 13, 4, 22, -1, 12, 3, 6,
    56, 34, 31, -2, -7, -2, -4, -13,
    -21, 5, -11, 21, 6, 30, 10, 27,
    0, -9, 21, 15, 9, -6, 21, 17,
    1, -5, -2, -1, 15, 15, -4, 1,
    25, -18, -17, 37, -9, 7, -18, 1,
    32, -1, 6, 8, -16, -46, 9, 21,
    -2, -2, 3, -30, -5, -10, 2, 29,
    2, -11, 21, -2, 2, 5, -6, 14,
    -51, 18, 5, 30, -5, -13, 27, 11,
    26, -16, 15, 7, 19, 22, 0, 20,
    -7, 22, -13, -31, -4, -22, -4, 13,
    34, -1, 10, -8, 14, -4, 24, -12,
    -43, -5, -47, 8, 14, 6, -20, -21,
    12, 12, -2, -8, -16, 3, -24, -3,
    0, -13, 3, -6, 18, 2, -10, 3,
    -12, 4, 9, -5, -13, 15, 12, -2,
    -25, 4, 22, 43, 0, 20, 0, -3,
    12, 30, -7, -23, -17, -24, -15, 49,
    -10, 17, -13, 9, -6, -8, -2, 1,
    -3, -7, 1, -11, -4, 4, 26, 4,
    14, 15, 9, 6, -3, -14, 6, 7,
    -17, 5, 9, -23, -16, -37, -2, 22,
    2, 37, -5, -8, -8, -21, -15, 4,
    7, 2, 4, -9, 15, 15, 15, -13,
    38, 59, -10, 13, 2, -16, -4, 12,
    13, -3, -4, 11, 19, 30, -33, -25,
    2, -6, 5, -3, -4, -6, 12, 3,
    -8, -34, 9, -11, -2, -2, 4, -7,
    22, -23, -7, -70, 22, -6, -39, 23,
    -20, -20, -22, -31, 8, 14, 33, -38,
    11, 19, -3, 35, 13, -9, -19, 1,
    19, 16, -1, 6, -9, -15, -32, -9,
    3, -51, -6, 5, 0, 14, 1, -27,
    39, -5, 16, -29, -44, 1, -5, -11,
    10, 10, -26, 7, 16, -1, 5, -2,
    4, 5, 22, -21, 5, 10, -1, 8,
    -13, -1, -28, 0, 13, 20, 19, 31,
    -22, -17, -3, -34, 21, 39, 39, -54,
    11, -5, -34, -12, 12, 1, -2, 1,
    -12, -6, -6, 11, 7, 15, -27, 16,
    6, 58, 24, -62, -12, -52, -4, -23,
    25, -23, 13, -55, -21, -63, -24, 9,
    -18, -39, 1, -54, 4, -7, 4, -7,
    1, 16, -1, 12, 2, 0, 4, 15,
    -51, -27, -8, -15, -34, -10, 45, 10,
    10, 24, 3, -26, 3, 3, 20, 13,
    27, -16, -28, -30, -8, -1, -18, 4,
    -12, 0, -18, 17, 5, 12, 12, 25,
    21, -68, -3, 43, -14, 28, 54, 75,
    -23, 19, -36, -10, -7, 27, 10, 46,
    -22, 1, 16, -10, -1, -3, 12, -14,
    10, -3, -35, -1, -15, 17, -31, 4,
    -24, -37, -20, -4, -86, -23, -6, 18,
    -11, -9, 13, -13, 4, -24, 3, 3,
    3, -37, 10, -6, 6, 12, -18, -6,
    -17, -6, -6, 2, -53, -25, 1, 4,
    43, -7, 17, 22, -37, -32, 3, 20,
    -18, 14, -7, 29, 82, 36, -22, 21,
    11, 26, 1, 13, -2, 18, -27, 19,
    -6, -4, 8, 6, -22, -7, 13, -11,
    4, 15, 3, 5, -8, -24, -80, -20,
    -30, 71, 17, -13, -1, 21, 40, 4,
    -4, -37, -24, -1, 5, 16, -31, -1,
    -5, -8, -7, -12, -7, -24, 3, -12,
    -13, -11, 20, -24, 17, 14, -20, 14,
    -4, 4, 0, -7, -5, -1, -5, 16,
    11, -36, 7, 1, -3, -2, 8, -4,
    6, 8, -11, -7, -3, 28, 10, -14,
    -6, 6, -33, 23, 21, -25, -3, 23,
    -2, -26, -3, -3, 27, 10, -34, -22,
    8, -10, -44, -26, -4, 2, 14, 32,
    23, -9, -10, 5, 5, -7, 12, -5,
    16, -8, -18, 19, 34, -30, -5, -8,
    5, 36, 19, -28, 15, -15, -1, -24,
    8, 10, 9, 39, 1, 4, 10, -28,
    -3, -3, -8, -6, -10, -21, 15, 14,
    21, -51, -6, 18, -1, 5, 19, 5,
    -18, -19, -2, 21, 13, -27, 15, 33,
    -1, -13, 14, -38, 2, -1, 4, 4,
    8, -1, -10, -18, 17, 19, 7, 9,
    26, 33, -1, -13, 6, -40, 21, -3,
    -6, 25, 1, -14, 82, 30, -12, 2,
    -25, -5, 16, 28, -5, 3, 14, -2,
    -20, -7, 14, -9, -17, -2, -2, -6,
    -52, 23, 39, 10, 6, -18, -10, 34,
    -22, -17, -25, -16, 15, 23, -5, 33,
    13, 12, 18, -7, -3, 9, 6, -10,
    10, -15, -6, -8, 1, -3, -3, 13,
    41, 10, -40, 7, 44, -5, 0, 36,
    -21, 21, 8, 22, -1, -11, -27, 13,
    30, -1, -1, -15, -3, -9, -2, -5,
    -49, -2, 5, -1, -35, 2, 6, -6,
    -2, -45, 8, 2, 11, 28, -2, 13,
    -3, -23, 29, 51, -3, -57, -18, -15,
    -20, -26, -12, 4, -1, -27, 0, -4,
    5, 1, -10, -5, 3, -4, 24, 1,
    -2, -7, 8, -6, 5, 3, 16, 63,
    15, -24, 18, 24, 18, -13, 34, 14,
    11, -9, -3, 14, -9, 8, 6, -12,
    6, 9, -7, -16, 7, -30, -9, -2,
    19, -4, 3, 12, 3, -5, 22, 59,
    32, 14, 30, -19, -39, -37, -9, -36,
    -2, 5, 15, 27, 0, -5, 10, -16,
    -9, 6, 9, -11, 16, 9, -12, 19,
    31, -5, 13, -27, 35, -14, -13, -25,
    -20, -11, -2, 0, 31, 11, 11, 11,
    6, -21, -17, -18, -3, -4, -14, 25,
    -6, -10, -3, 8, -20, 8, -8, 16,
    42, -27, -2, -38, -20, 24, -6, -28,
    -2, 1, -20, -3, -18, -1, -16, 12,
    0, 2, -11, -3, -10, 11, 9, -1,
    -3, 10, 11, 6, 1, -1, 8, 2,
    45, 14, 7, 17, 12, -11, -5, 2,
    -11, 25, 8, 29, -60, -10, 37, -3,
    -1, -18, 8, 3, 8, -3, -21, -21,
    19, 5, 8, -2, -16, 35, -6, 3,
    6, -1, -28, 14, -1, 34, 36, 46,
    -15, 3, 15, -6, 8, -46, 41, 9,
    30, 0, -9, 56, 2, 8, 1, -6,
    1, 25, 0, -4, -11, -38, 11, 7,
    51, -57, 17, 22, 0, 4, 7, 84,
    18, -21, 13, -21, 11, 4, 4, -10,
    -23, -5, -27, 12, -18, 2, 4, -21,
    -9, -1, -4, -15, 6, -12, 23, -12,
    6, -2, -24, -3, 5, -17, 0, 24,
    -23, -18, -8, -5, 37, -3, -26, 24,
    37, -14, 29, 10, -17, -3, -3, -1,
    -14, 2, 0, 4, -29, 7, 2, 9,
    54, 58, 19, 14, 11, -2, -16, 5,
    15, 1, 25, 33, -11, -16, 33, 12,
    -15, -2, 9, 21, 27, -10, 8, 1,
    -10, -10, -10, -9, 9, 0, 25, -12,
    12, -22, 3, 42, 16, 24, 10, -33,
    -38, -14, -41, 14, 2, 46, -23, 24,
    27, 49, 23, -49, -3, -24, 1, 31,
    -8, -5, 22, 3, -17, 15, -18, 29,
    19, -13, 21, -6, -29, -46, 13, 13,
    5, -19, -2, 17, 25, 23, -41, -4,
    -20, 15, -51, 0, 8, 16, 15, 7,
    7, 1, 1, -1, 25, -12, 52, -4,
    -18, 0, 38, 3, -10, -9, -15, -30,
    37, -11, -2, 6, -20, -7, -3, 29,
    -11, -8, 6, 16, -5, -9, 7, 3,
    29, -6, -18, 3, -6, -12, -8, -37,
    -14, -8, 11, 17, 36, 20, 35, -1,
    -24, -8, 6, 8, -24, -18, -7, 65,
    -8, 46, -25, -19, -9, 11, -9, -9,
    -10, -8, 10, -4, -37, -9, 28, -2,
    33, -15, -21, 8, -17, -5, -12, -36,
    -8, -1, -25, -13, 39, 4, 31, 29,
    -5, 41, -5, 7, 2, -23, 21, -13,
    6, -12, 4, -2, -18, -25, 1, 12,
    -20, 78, 17, 17, -4, 27, -30, -11,
    -5, 5, 1, -18, 5, 6, -6, 2,
    3, 2, -20, -10, -4, -45, 10, 5,
    -15, -11, 8, -10, 11, 14, 2, -26,
    54, -25, 65, -12, 42, 5, 43, -29,
    -25, -50, -9, -19, -99, -21, -18, -4,
    7, -4, -6, -24, 10, 9, 20, -27,
    5, 1, 7, -22, 43, 1, 2, -13,
    9, -62, -3, -109, -23, -15, -30, -46,
    -9, 26, -21, 24, -3, -2, -3, 23,
    -16, 40, 8, -23, -35, 4, 22, -18,
    10, 6, 8, -5, 17, 4, -3, -9,
    5, -7, -24, -10, -26, -8, -36, -58,
    49, 66, 40, -6, -4, 54, -37, -19,
    -49, 9, 7, 10, -8, 1, -7, -50,
    -9, 3, 7, -15, -36, 25, 1, 9,
    12, 43, 26, 4, 27, 48, 19, 27,
    -27, -23, -4, -32, 6, 26, 16, -3,
    1, 39, 0, 22, 37, -7, 1, -11,
    -5, 3, -14, 2, 18, 14, -14, 22,
    -25, 21, -10, -1, 55, 2, -57, -70,
    -6, -30, 7, 12, 11, 13, 10, -5,
    27, -127, 43, 17, -8, 4, 47, -6,
    -9, 18, -17, -5, 38, 71, 58, -32,
    -30, -48, 32, -52, -2, 62, -3, -21,
    -30, 12, 33, -2, 53, 28, 62, -64,
    -57, -14, -4, 22, -10, -10, -23, 4,
    17, 1, -23, -27, -8, -33, -25, -6,
    14, 42, -8, -24, 85, 19, 12, -23,
    15, 5, -14, 16, 47, -17, 2, 17,
    14, 34, 8, 26, 1, -26, 0, 7,
    -4, -4, -1, 6, 51, 30, 6, 14,
    67, 28, -18, -1, -8, -52, -8, 19,
    0, -13, 19, -47, -8, 35, -25, -41,
    31, -10, 55, 4, 21, -16, 8, -20,
    17, -11, -8, 23, -52, 3, 4, 35,
    17, -4, 5, -4, 19, -18, 36, 8,
    -78, -12, 28, -30, -21, -79, -28, 4,
    -12, 103, 3, -14, -8, -26, -2, 35,
    -23, -10, -23, -18, 6, -5, 4, -12,
    -14, 39, 17, -42, -12, 7, -32, 50,
    8, 7, 1, 9, 38, -11, -28, -9,
    -2, -27, -1, 21, 7, -7, -18, -6,
    5, 17, 1, 7, 6, 15, 26, -2,
    34, 33, 52, 44, -32, 36, 5, -12,
    5, -42, -19, 8, -35, 12, 46, -11,
    -59, 22, -9, 7, 29, 37, -3, 31,
    27, -22, -16, 7, 4, 38, 4, -18,
    36, -1, -32, 35, -3, 62, -58, 14,
    -4, -9, 14, -19, 28, -43, 17, 20,
    -17, 15, -15, -3, -12, -3, -3, -33,
    7, 7, 24, -17, -17, 39, 6, 24,
    79, 3, -36, -54, -1, 16, 3, 89,
    -18, 20, -11, 0, 46, 6, -6, -123,
    7, -33, 3, -15, 21, 4, 24, 46,
    -19, 27, -4, 8, -9, -37, -25, 6,
    -52, 0, -84, -34, 13, 7, -44, 45,
    -65, -2, 49, 25, -77, -2, 32, 42,
    4, 3, -10, -8, 21, 0, 16, -23,
    -18, -44, 20, -19, -12, 2, -6, -19,
    -67, 30, -2, -23, 29, 23, 38, -49,
    23, -25, 7, 18, -45, -12, 33, 3,
    -15, 17, 4, 5, -23, 0, -34, -1,
    36, -3, -6, 31, -8, 22, 12, -38,
    -1, 22, 22, 31, 68, -19, 33, -49,
    -15, 11, 34, -10, -45, 19, -22, -92,
    -7, 6, 7, 10, -13, -10, 35, -34,
    -115, -14, 11, -49, -8, -40, 22, 36,
    0, -77, -8, 23, -14, 13, -57, 10,
    -5, -35, 52, 77, -17, -2, -14, 14,
    20, -6, 14, 0, 28, -11, -26, 2,
    -23, -9, -7, 14, -69, 15, 15, 0,
    -11, -13, 14, -13, 49, -16, 5, -68,
    -28, -45, 25, 27, 27, -22, -10, 14,
    -16, 17, 13, 26, 27, 26, -12, 2,
    36, 8, 3, -5, -21, -9, -16, 28,
    5, -7, 16, -41, 25, 11, 13, -13,
    44, 23, 20, -11, -17, -2, 2, 26,
    43, 1, 10, -28, -25, 7, -23, 24,
    -12, 8, 5, 20, -10, -2, 10, -20,
    -12, 93, 127, 2, 11, -5, -13, 50,
    -1, -8, -17, 6, 20, 62, -14, -25,
    14, -46, 22, 18, 26, 11, 33, -18,
    -6, 9, -37, 45, -1, 10, 2, 6,
    -49, -7, -21, 15, 5, 3, -22, -7,
    -1, 43, -5, -10, 1, -10, -36, 21,
    17, 4, 54, -18, 34, -10, 40, -27,
    9, 45, 3, 18, 18, 0, -13, -37,
    38, 12, 6, 8, -62, -22, -4, 1,
    0, -3, 39, 42, 26, -29, 11, 41,
    21, -6, 4, -16, 25, -6, 10, -24,
    41, 5, 4, -5, 14, 21, -31, -28,
    23, 29, -6, -85, 25, 45, -31, 8,
    -17, -13, 6, 37, 32, -12, -16, -15,
    -3, -2, 20, 20, 11, 0, -20, -21,
    -11, 29, 16, 21, 31, 35, 43, -46,
    -8, 18, -63, 54, -39, -34, 19, -73,
    13, 6, -12, -35, -78, 2, 21, 82,
    98, -44, -28, -66, 14, -2, -8, 31,
    -49, 46, -3, 14, 2, 20, -24, -11,
    -12, -17, -11, 19, -29, -13, 9, 19,
    19, -19, 3, 24, 11, -11, 83, -33,
    7, -20, 47, 16, 31, -28, -33, 30,
    -5, -5, 20, 21, 1, -3, -7, 21,
    68, 5, -36, 19, 20, -2, 13, -23,
    -33, 26, 14, 21, -18, 37, 6, 32,
    -4, 4, -34, 17, 17, 1, -1, 8,
    -30, -8, -26, 3, 25, -1, -23, 1,
    -5, -17, -16, 17, -9, 6, 19, -17,
    -3, 0, -11, -46, -9, -40, 8, -12,
    -53, 31, 18, 16, -4, -17, 36, 54,
    -3, -3, 34, -17, -5, -5, -15, 14,
    1, 17, 14, -66, -42, 11, -49, 39,
    -12, -32, 31, 3, -14, 45, -18, 16,
    -13, 1, 67, -55, -40, 58, -5, -29,
    -8, 8, -16, 5, 5, 7, -73, -56,
    7, -21, 108, 18, -53, -21, 37, 16,
    19, 4, -3, 8, 0, 35, 36, -15,
    -9, 13, 29, -16, -8, -24, 7, -19,
    58, -7, -29, 24, -17, -30, -4, 12,
    21, 22, -35, 6, 60, -3, -31, 12,
    -51, -24, 33, 24, -4, -43, 48, -1,
    7, 14, 22, -11, -3, -31, 17, 43,
    5, 13, -19, 28, -35, -7, -18, 17,
    -8, -69, -18, -30, -5, 25, 9, -9,
    -16, 37, -19, -21, 28, -26, 12, -82,
    11, 52, -39, 4, 4, 0, 71, 58,
    -11, -31, 46, 20, 4, -67, -33, -51,
    -37, -28, 12, 9, -15, -60, 7, -5,
    -2, 38, -23, -31, 12, 5, 55, -32,
    -11, -34, -13, 36, -14, -16, -7, -6,
    1, 21, -3, 25, -7, -24, 14, -33,
    9, -28, -10, 32, 18, 5, 7, 4,
    22, -3, -41, 5, -5, -10, -4, 9,
    -4, 19, 0, -5, 29, 10, -9, -4,
    10, -18, -11, -9, 5, -1, -15, 1,
    -9, 1, 10, 4, 4, 1, 3, 3,
    -5, 7, 15, 20, 31, 0, 10, 20,
    -3, 15, 1, 14, -48, 18, 15, 16,
    -4, 20, 2, 17, 5, -4, 1, 2,
    23, 9, -25, 17, 8, 1, -19, -17,
    -2, 2, 33, -27, -7, 5, -6, 19,
    20, -11, 2, -6, 16, -7, -4, -4,
    20, 18, 23, -12, 6, 12, -10, 3,
    7, -22, -6, 3, -18, -49, -12, -17,
    12, 25, 11, 3, 15, 12, 5, -17,
    7, 12, 19, 2, -20, -5, -18, -10,
    2, 15, 16, -19, -3, 7, -1, 13,
    -10, 22, 31, 12, 21, -2, 11, 4,
    -19, 37, -1, 22, 10, -30, 16, -10,
    31, -13, 3, 5, -32, -3, 15, -21,
    -15, -16, -4, -5, -2, 0, 2, 3,
    -11, -11, 5, 0, -25, 10, 3, 19,
    -14, -24, 63, -20, -33, 25, 17, -8,
    20, -20, -6, -12, -3, 10, 20, 55,
    16, 1, -10, -12, -10, -11, -2, -21,
    0, 27, -9, 12, 6, 9, -3, -20,
    12, -6, -6, -19, -10, -22, 11, 3,
    18, -4, 0, -30, -24, -11, 5, 6,
    5, 16, 2, 7, 0, 9, 4, 4,
    -13, -24, -18, -7, -2, -8, -6, 15,
    60, -12, -22, -13, 24, -10, 14, 11,
    6, 2, -13, -7, 20, -12, 12, -33,
    -9, -9, -9, 6, -2, 17, 9, -2,
    -16, 26, 8, -12, 16, -37, 4, -24,
    -26, -1, 23, -8, 1, -9, 28, 6,
    2, -4, -18, 16, 9, 28, 39, -13,
    8, 2, 6, -11, 3, -17, 5, -3,
    -15, 35, -16, -15, -5, 21, 8, -2,
    36, -20, -19, -5, 0, -2, 6, 28,
    -22, -1, -16, -12, -23, -21, -10, 6,
    19, 10, 12, -11, 0, 2, 7, -5,
    -13, 2, 17, 12, -7, -4, 6, -12,
    21, -2, 7, 14, -19, 13, -18, -13,
    -2, -7, -11, 9, 21, -10, 22, -7,
    9, -1, -2, 11, -10, 4, 8, -1,
    7, 22, 5, -13, -8, 24, 13, -16,
    -12, -38, 10, -38, -17, 3, 7, -1,
    21, 12, 16, 7, -10, -11, 6, -9,
    6, -11, 8, -6, 7, 1, -11, 17,
    -11, 10, -15, 33, 29, 7, -33, -11,
    15, -25, -11, 14, 2, 26, 7, 9,
    -4, -2, -7, -14, 41, -13, 52, -47,
    -43, 8, 3, 8, 3, 8, 5, -10,
    7, -17, -6, -11, 24, 9, -44, 15,
    20, -35, -13, -1, -14, -2, 21, 1,
    9, 15, 4, -5, -10, 19, 32, 46,
    -2, 31, -6, 24, -20, -6, -8, 2,
    -19, -5, 6, -31, -11, 12, 15, 3,
    23, -8, 55, -59, 5, -12, 20, -31,
    1, -14, -3, 6, 23, -45, 10, 9,
    -3, 1, -1, -10, -5, -10, 4, -5,
    17, 19, 14, 22, -10, -1, -51, 3,
    -17, -5, 31, -11, 36, 27, -3, 37,
    -5, -1, -19, 13, 13, 4, -21, 5,
    3, 10, 6, 8, -10, 3, -10, -21,
    -10, 4, -10, 12, -9, 10, 5, -2,
    -1, -20, 37, 30, -47, 69, -7, 26,
    0, -17, -24, -10, 45, 8, -20, 0,
    11, 9, -1, 9, 4, -1, -6, 4,
    -2, -1, -1, 7, 7, -5, -8, 37,
    1, -6, -6, -11, 25, -26, -10, -17,
    -6, -2, 6, -17, 9, -4, 37, 16,
    -13, -3, -15, 5, 5, -4, 6, -1,
    -14, 25, -2, -11, 5, 9, 13, 16,
    -25, -54, 37, -21, 0, 20, 3, -25,
    -2, -7, -4, -5, -5, -19, -31, -23,
    11, -9, -8, -20, -9, -14, 4, 7,
    -3, -2, 19, -9, -10, -1, -43, -33,
    -18, 28, 21, -19, -14, -14, 54, -14,
    7, 6, 3, 0, -39, 29, 40, -36,
    -8, 9, -17, 7, 0, 6, 13, -6,
    5, -2, 8, -4, 3, -16, 17, -28,
    19, 2, -37, 28, -16, 12, 20, -4,
    5, -1, -6, -6, -23, -9, 1, -22,
    4, -15, -3, 4, -2, 3, 4, -9,
    33, 14, 4, 28, -25, 11, 20, 6,
    24, 7, -4, -6, 15, -8, -14, 6,
    4, -6, 6, 2, -13, 1, 50, -23,
    -7, 5, -17, 22, -10, -11, -8, 24,
    -3, -6, -7, 15, -49, 0, -21, -15,
    -11, 0, -53, -20, 3, -32, 39, 6,
    -16, 13, 0, -6, 21, 3, -23, -16,
    -5, 10, -19, 16, 6, -5, -6, 2,
    -2, 7, -6, -14, -8, 2, 4, -8,
    -39, 17, 7, -10, 16, 0, 0, -49,
    30, -16, 8, 26, 11, 16, 1, 50,
    -13, -16, 18, -30, 12, -8, 3, 9,
    23, 10, 5, -8, -30, 23, 20, -17,
    14, -61, 11, 2, 49, -21, -7, 22,
    0, 5, -11, -28, 23, 2, -14, 19,
    -35, -1, 8, -4, 1, -4, -4, 6,
    13, -11, -35, -29, -10, -5, -5, -24,
    1, -9, -12, 10, -27, -10, 3, -16,
    21, 26, 1, -23, -25, 5, -9, 13,
    4, 16, 12, -8, -11, 4, 3, -1,
    6, -21, -8, 15, -1, 17, -24, -14,
    -30, -23, -14, 56, 26, 2, 32, -21,
    -15, 8, 7, -3, 25, 7, 5, 15,
    -41, -12, -1, 14, 9, -5, 4, 6,
    -20, 6, 5, 26, 14, 0, -23, 4,
    -32, -6, 5, -17, 40, -17, -23, -32,
    -11, 6, -1, -6, 0, -30, 1, 4,
    -3, -9, 9, -5, 7, 7, 5, 1,
    -21, -51, -12, 2, 26, 26, -1, 13,
    -17, 16, -19, 3, 11, 3, -17, 4,
    -7, -4, -1, 0, -5, 24, -18, 16,
    18, 4, 5, 29, -8, -3, -2, 15,
    -25, -15, 1, 19, 26, 4, -5, 8,
    -25, -37, 26, 28, -27, -18, -14, -13,
    -2, 3, 4, -6, 6, 9, 24, 5,
    -1, -20, 9, -9, -1, 1, -4, -10,
    5, -7, 4, -8, -3, -5, 4, -10,
    24, -1, -21, -17, -48, 14, -2, -19,
    -2, 17, -13, -3, -13, -14, 49, 19,
    -5, -8, -9, 5, -10, -6, 0, 1,
    18, -8, 10, -28, -15, 19, 0, -14,
    -26, 7, -22, -27, 0, -7, 21, 27,
    -8, -9, -9, 1, 0, 2, -3, 12,
    -15, 18, 21, 5, 0, 5, 0, 0,
    -6, -15, -3, 29, 9, -8, -10, 11,
    40, 12, -34, -4, 7, -11, -22, -18,
    6, 12, 14, 11, 20, 4, -20, -60,
    6, -8, -19, -10, 8, -4, -23, 23,
    11, -12, 13, -2, 15, -6, 5, 2,
    -8, 17, 37, 24, 26, 13, 12, 1,
    -6, 4, 0, -5, -9, -27, 13, 21,
    -4, -8, -15, 18, -2, -5, -5, 4,
    27, 8, -19, 45, 10, 22, 19, -25,
    -15, 7, 25, 6, -7, 13, -4, -30,
    14, 2, 12, -7, 27, 11, -45, 12,
    20, 9, 42, -2, 15, 5, -6, -13,
    8, 8, -22, 28, 0, -11, 28, -21,
    34, -39, 6, 16, 5, 21, 26, -23,
    14, 20, 12, 14, 16, 17, -2, 24,
    14, 40, 7, -10, -5, 3, -11, 12,
    -3, 39, -36, -23, 21, 3, 32, 21,
    -6, 29, -6, 15, -12, -5, 15, 5,
    20, 5, 6, 9, -2, 1, -69, -3,
    -16, -26, 5, 8, 2, 2, 6, 9,
    -13, 20, 21, 70, -5, 38, 2, -25,
    -5, -43, 65, -51, 7, -12, 2, -15,
    3, -7, 3, -5, 20, 22, -5, 20,
    3, -8, -10, -3, -16, 9, -20, -41,
    -28, -19, 1, 13, -32, -18, -7, 14,
    -10, -3, -2, -22, 5, -20, 15, -5,
    5, 5, -16, -22, 45, 22, 0, 13,
    -16, -11, -7, 18, -8, 12, 8, -12,
    13, -7, 7, -10, 1, -18, -16, 17,
    59, 24, -40, -3, -19, 12, 12, -26,
    8, -13, 5, 11, 21, 45, 5, 5,
    -9, -43, 1, 35, -14, 13, 4, -9,
    -35, -5, 30, -1, -3, -41, -33, 21,
    0, 38, 49, 39, 13, -39, 32, 6,
    8, -4, 31, 8, 23, 55, 12, -25,
    7, 3, -27, 19, 6, -10, 15, 17,
    -13, 46, 0, -21, 7, 14, 1, -29,
    27, -9, 8, -9, 11, -14, 9, 40,
    -2, 7, -30, -17, 18, 1, -13, 7,
    0, 7, 3, -17, 12, 2, 3, -12,
    -50, 22, 23, -3, 7, 5, 0, 2,
    24, -1, 3, 26, 40, -20, 23, 20,
    4, 15, -27, -10, 43, -49, 41, -26,
    0, -5, 16, 14, -20, 19, 24, 1,
    0, -2, -13, 15, 1, 12, 4, 10,
    17, -6, 13, -11, -9, -29, 32, -38,
    3, 4, -2, 10, -4, -13, 33, -53,
    -20, 3, 16, -10, 3, 0, -18, 27,
    -26, 25, -7, 41, -1, -3, -8, 1,
    -4, -30, -36, -8, 27, 9, 15, -5,
    -29, 3, -4, -5, 69, -23, 39, -22,
    -33, 1, 7, 0, 14, 16, -7, 10,
    -30, -21, -4, 1, 5, -24, 12, -34,
    -3, 13, -71, -14, 9, 10, 29, -6,
    19, -10, -30, -23, 12, 62, 39, 35,
    -19, 18, 6, 8, -28, -1, -13, -5,
    2, 19, -57, 6, -26, 14, -27, -15,
    -12, 14, 50, -43, 11, 10, -21, -7,
    5, 5, -18, 21, -14, -11, 35, 19,
    -1, -13, -8, 5, -6, -9, -7, -15,
    -18, 17, 32, 19, -7, 1, -23, -1,
    19, -4, 19, -16, -6, 3, -44, -4,
    -23, -7, 16, -7, 41, -5, -4, 42,
    -11, 4, 32, 1, 3, -5, 15, -41,
    -19, 21, 5, -2, 19, -4, -12, 1,
    -12, -12, 39, 1, -9, -19, -4, 13,
    -9, 7, -14, -2, 72, 4, 2, 22,
    5, 28, -13, 1, 9, 11, -4, -6,
    -10, 34, -9, -42, 14, 0, 3, 27,
    5, -9, -6, 12, 6, -16, -21, -24,
    12, -2, -3, -12, -4, 5, 10, -23,
    -9, -9, -10, 21, 6, 18, 3, -29,
    -2, 26, -14, -23, 4, 6, -12, -1,
    -33, -39, 15, -17, -13, 9, 11, -14,
    -3, -11, -3, 8, 14, 19, -11, -19,
    15, 2, -13, -8, 2, -5, 0, -4,
    48, 10, 35, -38, 36, -1, 4, -40,
    11, 7, 55, -36, -48, 14, -14, 5,
    11, 9, 6, -12, 19, -11, -37, 17,
    11, 12, -15, 35, 2, 9, 8, 6,
    -12, -19, -16, -26, -6, -20, 12, -6,
    -7, 12, 15, 5, 3, -5, 3, 20,
    19, -8, 1, 24, 10, -11, -21, -34,
    8,