// Generated by zig-wayland

// Copyright © 2008-2013 Kristian Høgsberg
// Copyright © 2013      Rafael Antognolli
// Copyright © 2013      Jasper St. Pierre
// Copyright © 2010-2013 Intel Corporation
// Copyright © 2015-2017 Samsung Electronics Co., Ltd
// Copyright © 2015-2017 Red Hat Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice (including the next
// paragraph) shall be included in all copies or substantial portions of the
// Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
// 

const os = @import("std").os;
const server = @import("wayland.zig").server;
const common = @import("common.zig");pub const WmBase = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.xdg.wm_base.getInterface;pub const Error = common.xdg.wm_base.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*WmBase {
    return @ptrCast(try server.wl.Resource.create(_client, WmBase, _version, _id));
}pub fn destroy(_wm_base: *WmBase) void {
    return @as(*server.wl.Resource, @ptrCast(_wm_base)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *WmBase {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_wm_base: *WmBase) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_wm_base)).getLink();
}pub fn getClient(_wm_base: *WmBase) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_wm_base)).getClient();
}pub fn getId(_wm_base: *WmBase) u32 {
    return @as(*server.wl.Resource, @ptrCast(_wm_base)).getId();
}pub fn getVersion(_wm_base: *WmBase) u32 {
    return @as(*server.wl.Resource, @ptrCast(_wm_base)).getVersion();
}pub fn postNoMemory(_wm_base: *WmBase) void {
    return @as(*server.wl.Resource, @ptrCast(_wm_base)).postNoMemory();
}pub fn postError(wm_base: *WmBase, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(wm_base)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,create_positioner: struct {id:u32,},
get_xdg_surface: struct {id:u32,surface:*server.wl.Surface,},
pong: struct {serial:u32,},
};
pub inline fn setHandler(
    _wm_base: *WmBase,
    comptime T: type,
    handle_request: *const fn (_wm_base: *WmBase, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_wm_base: *WmBase, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_wm_base);
    _resource.setDispatcher(
        common.Dispatcher(WmBase, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*WmBase, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendPing(_wm_base: *WmBase, _serial:u32) void {const _resource: *server.wl.Resource = @ptrCast(_wm_base);var _args = [_]common.Argument{.{ .u = _serial},};
_resource.postEvent(0, &_args);}
};
pub const Positioner = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.xdg.positioner.getInterface;pub const Error = common.xdg.positioner.Error;
pub const Anchor = common.xdg.positioner.Anchor;
pub const Gravity = common.xdg.positioner.Gravity;
pub const ConstraintAdjustment = common.xdg.positioner.ConstraintAdjustment;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Positioner {
    return @ptrCast(try server.wl.Resource.create(_client, Positioner, _version, _id));
}pub fn destroy(_positioner: *Positioner) void {
    return @as(*server.wl.Resource, @ptrCast(_positioner)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Positioner {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_positioner: *Positioner) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_positioner)).getLink();
}pub fn getClient(_positioner: *Positioner) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_positioner)).getClient();
}pub fn getId(_positioner: *Positioner) u32 {
    return @as(*server.wl.Resource, @ptrCast(_positioner)).getId();
}pub fn getVersion(_positioner: *Positioner) u32 {
    return @as(*server.wl.Resource, @ptrCast(_positioner)).getVersion();
}pub fn postNoMemory(_positioner: *Positioner) void {
    return @as(*server.wl.Resource, @ptrCast(_positioner)).postNoMemory();
}pub fn postError(positioner: *Positioner, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(positioner)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,set_size: struct {width:i32,height:i32,},
set_anchor_rect: struct {x:i32,y:i32,width:i32,height:i32,},
set_anchor: struct {anchor:Anchor,},
set_gravity: struct {gravity:Gravity,},
set_constraint_adjustment: struct {constraint_adjustment:u32,},
set_offset: struct {x:i32,y:i32,},
};
pub inline fn setHandler(
    _positioner: *Positioner,
    comptime T: type,
    handle_request: *const fn (_positioner: *Positioner, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_positioner: *Positioner, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_positioner);
    _resource.setDispatcher(
        common.Dispatcher(Positioner, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Positioner, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const Surface = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.xdg.surface.getInterface;pub const Error = common.xdg.surface.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Surface {
    return @ptrCast(try server.wl.Resource.create(_client, Surface, _version, _id));
}pub fn destroy(_surface: *Surface) void {
    return @as(*server.wl.Resource, @ptrCast(_surface)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Surface {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_surface: *Surface) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getLink();
}pub fn getClient(_surface: *Surface) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getClient();
}pub fn getId(_surface: *Surface) u32 {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getId();
}pub fn getVersion(_surface: *Surface) u32 {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getVersion();
}pub fn postNoMemory(_surface: *Surface) void {
    return @as(*server.wl.Resource, @ptrCast(_surface)).postNoMemory();
}pub fn postError(surface: *Surface, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(surface)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,get_toplevel: struct {id:u32,},
get_popup: struct {id:u32,parent:?*server.xdg.Surface,positioner:*server.xdg.Positioner,},
set_window_geometry: struct {x:i32,y:i32,width:i32,height:i32,},
ack_configure: struct {serial:u32,},
};
pub inline fn setHandler(
    _surface: *Surface,
    comptime T: type,
    handle_request: *const fn (_surface: *Surface, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_surface: *Surface, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_surface);
    _resource.setDispatcher(
        common.Dispatcher(Surface, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Surface, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendConfigure(_surface: *Surface, _serial:u32) void {const _resource: *server.wl.Resource = @ptrCast(_surface);var _args = [_]common.Argument{.{ .u = _serial},};
_resource.postEvent(0, &_args);}
};
pub const Toplevel = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.xdg.toplevel.getInterface;pub const Error = common.xdg.toplevel.Error;
pub const ResizeEdge = common.xdg.toplevel.ResizeEdge;
pub const State = common.xdg.toplevel.State;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Toplevel {
    return @ptrCast(try server.wl.Resource.create(_client, Toplevel, _version, _id));
}pub fn destroy(_toplevel: *Toplevel) void {
    return @as(*server.wl.Resource, @ptrCast(_toplevel)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Toplevel {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_toplevel: *Toplevel) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_toplevel)).getLink();
}pub fn getClient(_toplevel: *Toplevel) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_toplevel)).getClient();
}pub fn getId(_toplevel: *Toplevel) u32 {
    return @as(*server.wl.Resource, @ptrCast(_toplevel)).getId();
}pub fn getVersion(_toplevel: *Toplevel) u32 {
    return @as(*server.wl.Resource, @ptrCast(_toplevel)).getVersion();
}pub fn postNoMemory(_toplevel: *Toplevel) void {
    return @as(*server.wl.Resource, @ptrCast(_toplevel)).postNoMemory();
}pub fn postError(toplevel: *Toplevel, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(toplevel)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,set_parent: struct {parent:?*server.xdg.Toplevel,},
set_title: struct {title:[*:0]const u8,},
set_app_id: struct {app_id:[*:0]const u8,},
show_window_menu: struct {seat:*server.wl.Seat,serial:u32,x:i32,y:i32,},
move: struct {seat:*server.wl.Seat,serial:u32,},
resize: struct {seat:*server.wl.Seat,serial:u32,edges:ResizeEdge,},
set_max_size: struct {width:i32,height:i32,},
set_min_size: struct {width:i32,height:i32,},
set_maximized: void,unset_maximized: void,set_fullscreen: struct {output:?*server.wl.Output,},
unset_fullscreen: void,set_minimized: void,};
pub inline fn setHandler(
    _toplevel: *Toplevel,
    comptime T: type,
    handle_request: *const fn (_toplevel: *Toplevel, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_toplevel: *Toplevel, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_toplevel);
    _resource.setDispatcher(
        common.Dispatcher(Toplevel, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Toplevel, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendConfigure(_toplevel: *Toplevel, _width:i32, _height:i32, _states:*common.Array) void {const _resource: *server.wl.Resource = @ptrCast(_toplevel);var _args = [_]common.Argument{.{ .i = _width},.{ .i = _height},.{ .a = _states},};
_resource.postEvent(0, &_args);}
pub fn sendClose(_toplevel: *Toplevel) void {const _resource: *server.wl.Resource = @ptrCast(_toplevel);_resource.postEvent(1, null);}
};
pub const Popup = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.xdg.popup.getInterface;pub const Error = common.xdg.popup.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Popup {
    return @ptrCast(try server.wl.Resource.create(_client, Popup, _version, _id));
}pub fn destroy(_popup: *Popup) void {
    return @as(*server.wl.Resource, @ptrCast(_popup)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Popup {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_popup: *Popup) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_popup)).getLink();
}pub fn getClient(_popup: *Popup) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_popup)).getClient();
}pub fn getId(_popup: *Popup) u32 {
    return @as(*server.wl.Resource, @ptrCast(_popup)).getId();
}pub fn getVersion(_popup: *Popup) u32 {
    return @as(*server.wl.Resource, @ptrCast(_popup)).getVersion();
}pub fn postNoMemory(_popup: *Popup) void {
    return @as(*server.wl.Resource, @ptrCast(_popup)).postNoMemory();
}pub fn postError(popup: *Popup, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(popup)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,grab: struct {seat:*server.wl.Seat,serial:u32,},
};
pub inline fn setHandler(
    _popup: *Popup,
    comptime T: type,
    handle_request: *const fn (_popup: *Popup, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_popup: *Popup, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_popup);
    _resource.setDispatcher(
        common.Dispatcher(Popup, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Popup, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendConfigure(_popup: *Popup, _x:i32, _y:i32, _width:i32, _height:i32) void {const _resource: *server.wl.Resource = @ptrCast(_popup);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .i = _width},.{ .i = _height},};
_resource.postEvent(0, &_args);}
pub fn sendPopupDone(_popup: *Popup) void {const _resource: *server.wl.Resource = @ptrCast(_popup);_resource.postEvent(1, null);}
};
