// Generated by zig-wayland

// Copyright © 2008-2011 Kristian Høgsberg
// Copyright © 2010-2011 Intel Corporation
// Copyright © 2012-2013 Collabora, Ltd.
// 
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge,
// publish, distribute, sublicense, and/or sell copies of the Software,
// and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
// 
// The above copyright notice and this permission notice (including the
// next paragraph) shall be included in all copies or substantial
// portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
// BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 

const os = @import("std").os;
const server = @import("wayland.zig").server;
const common = @import("common.zig");pub const Display = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.display.getInterface;pub const Error = common.wl.display.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Display {
    return @ptrCast(try server.wl.Resource.create(_client, Display, _version, _id));
}pub fn destroy(_display: *Display) void {
    return @as(*server.wl.Resource, @ptrCast(_display)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Display {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_display: *Display) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_display)).getLink();
}pub fn getClient(_display: *Display) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_display)).getClient();
}pub fn getId(_display: *Display) u32 {
    return @as(*server.wl.Resource, @ptrCast(_display)).getId();
}pub fn getVersion(_display: *Display) u32 {
    return @as(*server.wl.Resource, @ptrCast(_display)).getVersion();
}pub fn postNoMemory(_display: *Display) void {
    return @as(*server.wl.Resource, @ptrCast(_display)).postNoMemory();
}pub fn postError(display: *Display, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(display)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {sync: struct {callback:u32,},
get_registry: struct {registry:u32,},
};
pub inline fn setHandler(
    _display: *Display,
    comptime T: type,
    handle_request: *const fn (_display: *Display, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_display: *Display, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_display);
    _resource.setDispatcher(
        common.Dispatcher(Display, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Display, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendError(_display: *Display, _object_id:*common.Object, _code:u32, _message:[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_display);var _args = [_]common.Argument{.{ .o = @ptrCast(_object_id) },.{ .u = _code},.{ .s = _message},};
_resource.postEvent(0, &_args);}
pub fn sendDeleteId(_display: *Display, _id:u32) void {const _resource: *server.wl.Resource = @ptrCast(_display);var _args = [_]common.Argument{.{ .u = _id},};
_resource.postEvent(1, &_args);}
};
pub const Registry = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.registry.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Registry {
    return @ptrCast(try server.wl.Resource.create(_client, Registry, _version, _id));
}pub fn destroy(_registry: *Registry) void {
    return @as(*server.wl.Resource, @ptrCast(_registry)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Registry {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_registry: *Registry) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_registry)).getLink();
}pub fn getClient(_registry: *Registry) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_registry)).getClient();
}pub fn getId(_registry: *Registry) u32 {
    return @as(*server.wl.Resource, @ptrCast(_registry)).getId();
}pub fn getVersion(_registry: *Registry) u32 {
    return @as(*server.wl.Resource, @ptrCast(_registry)).getVersion();
}pub fn postNoMemory(_registry: *Registry) void {
    return @as(*server.wl.Resource, @ptrCast(_registry)).postNoMemory();
}pub const Request = union(enum) {bind: struct {name:u32,interface_name: [*:0]const u8, version: u32,id: u32,},
};
pub inline fn setHandler(
    _registry: *Registry,
    comptime T: type,
    handle_request: *const fn (_registry: *Registry, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_registry: *Registry, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_registry);
    _resource.setDispatcher(
        common.Dispatcher(Registry, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Registry, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendGlobal(_registry: *Registry, _name:u32, _interface:[*:0]const u8, _version:u32) void {const _resource: *server.wl.Resource = @ptrCast(_registry);var _args = [_]common.Argument{.{ .u = _name},.{ .s = _interface},.{ .u = _version},};
_resource.postEvent(0, &_args);}
pub fn sendGlobalRemove(_registry: *Registry, _name:u32) void {const _resource: *server.wl.Resource = @ptrCast(_registry);var _args = [_]common.Argument{.{ .u = _name},};
_resource.postEvent(1, &_args);}
};
pub const Callback = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.callback.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Callback {
    return @ptrCast(try server.wl.Resource.create(_client, Callback, _version, _id));
}pub fn destroy(_callback: *Callback) void {
    return @as(*server.wl.Resource, @ptrCast(_callback)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Callback {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_callback: *Callback) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_callback)).getLink();
}pub fn getClient(_callback: *Callback) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_callback)).getClient();
}pub fn getId(_callback: *Callback) u32 {
    return @as(*server.wl.Resource, @ptrCast(_callback)).getId();
}pub fn getVersion(_callback: *Callback) u32 {
    return @as(*server.wl.Resource, @ptrCast(_callback)).getVersion();
}pub fn postNoMemory(_callback: *Callback) void {
    return @as(*server.wl.Resource, @ptrCast(_callback)).postNoMemory();
}pub inline fn setHandler(
    _callback: *Callback,
    comptime T: type,
    comptime handle_destroy: ?fn (_callback: *Callback, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_callback);
    _resource.setDispatcher(
        null,
        null,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Callback, @ptrCast(__resource)),
                    @as(?*anyopaque, @ptrFromInt(@intFromPtr(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn destroySendDone(_callback: *Callback, _callback_data:u32) void {const _resource: *server.wl.Resource = @ptrCast(_callback);var _args = [_]common.Argument{.{ .u = _callback_data},};
_resource.postEvent(0, &_args);_resource.destroy();}
};
pub const Buffer = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.buffer.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Buffer {
    return @ptrCast(try server.wl.Resource.create(_client, Buffer, _version, _id));
}pub fn destroy(_buffer: *Buffer) void {
    return @as(*server.wl.Resource, @ptrCast(_buffer)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Buffer {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_buffer: *Buffer) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_buffer)).getLink();
}pub fn getClient(_buffer: *Buffer) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_buffer)).getClient();
}pub fn getId(_buffer: *Buffer) u32 {
    return @as(*server.wl.Resource, @ptrCast(_buffer)).getId();
}pub fn getVersion(_buffer: *Buffer) u32 {
    return @as(*server.wl.Resource, @ptrCast(_buffer)).getVersion();
}pub fn postNoMemory(_buffer: *Buffer) void {
    return @as(*server.wl.Resource, @ptrCast(_buffer)).postNoMemory();
}pub const Request = union(enum) {destroy: void,};
pub inline fn setHandler(
    _buffer: *Buffer,
    comptime T: type,
    handle_request: *const fn (_buffer: *Buffer, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_buffer: *Buffer, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_buffer);
    _resource.setDispatcher(
        common.Dispatcher(Buffer, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Buffer, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendRelease(_buffer: *Buffer) void {const _resource: *server.wl.Resource = @ptrCast(_buffer);_resource.postEvent(0, null);}
};
pub const Compositor = opaque {
 pub const generated_version = 4;
 pub const getInterface = common.wl.compositor.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Compositor {
    return @ptrCast(try server.wl.Resource.create(_client, Compositor, _version, _id));
}pub fn destroy(_compositor: *Compositor) void {
    return @as(*server.wl.Resource, @ptrCast(_compositor)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Compositor {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_compositor: *Compositor) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_compositor)).getLink();
}pub fn getClient(_compositor: *Compositor) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_compositor)).getClient();
}pub fn getId(_compositor: *Compositor) u32 {
    return @as(*server.wl.Resource, @ptrCast(_compositor)).getId();
}pub fn getVersion(_compositor: *Compositor) u32 {
    return @as(*server.wl.Resource, @ptrCast(_compositor)).getVersion();
}pub fn postNoMemory(_compositor: *Compositor) void {
    return @as(*server.wl.Resource, @ptrCast(_compositor)).postNoMemory();
}pub const Request = union(enum) {create_surface: struct {id:u32,},
create_region: struct {id:u32,},
};
pub inline fn setHandler(
    _compositor: *Compositor,
    comptime T: type,
    handle_request: *const fn (_compositor: *Compositor, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_compositor: *Compositor, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_compositor);
    _resource.setDispatcher(
        common.Dispatcher(Compositor, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Compositor, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const Surface = opaque {
 pub const generated_version = 4;
 pub const getInterface = common.wl.surface.getInterface;pub const Error = common.wl.surface.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Surface {
    return @ptrCast(try server.wl.Resource.create(_client, Surface, _version, _id));
}pub fn destroy(_surface: *Surface) void {
    return @as(*server.wl.Resource, @ptrCast(_surface)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Surface {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_surface: *Surface) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getLink();
}pub fn getClient(_surface: *Surface) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getClient();
}pub fn getId(_surface: *Surface) u32 {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getId();
}pub fn getVersion(_surface: *Surface) u32 {
    return @as(*server.wl.Resource, @ptrCast(_surface)).getVersion();
}pub fn postNoMemory(_surface: *Surface) void {
    return @as(*server.wl.Resource, @ptrCast(_surface)).postNoMemory();
}pub fn postError(surface: *Surface, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(surface)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,attach: struct {buffer:?*server.wl.Buffer,x:i32,y:i32,},
damage: struct {x:i32,y:i32,width:i32,height:i32,},
frame: struct {callback:u32,},
set_opaque_region: struct {region:?*server.wl.Region,},
set_input_region: struct {region:?*server.wl.Region,},
commit: void,set_buffer_transform: struct {transform:common.wl.output.Transform,},
set_buffer_scale: struct {scale:i32,},
damage_buffer: struct {x:i32,y:i32,width:i32,height:i32,},
};
pub inline fn setHandler(
    _surface: *Surface,
    comptime T: type,
    handle_request: *const fn (_surface: *Surface, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_surface: *Surface, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_surface);
    _resource.setDispatcher(
        common.Dispatcher(Surface, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Surface, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendEnter(_surface: *Surface, _output:*server.wl.Output) void {const _resource: *server.wl.Resource = @ptrCast(_surface);var _args = [_]common.Argument{.{ .o = @ptrCast(_output) },};
_resource.postEvent(0, &_args);}
pub fn sendLeave(_surface: *Surface, _output:*server.wl.Output) void {const _resource: *server.wl.Resource = @ptrCast(_surface);var _args = [_]common.Argument{.{ .o = @ptrCast(_output) },};
_resource.postEvent(1, &_args);}
};
pub const Region = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.region.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Region {
    return @ptrCast(try server.wl.Resource.create(_client, Region, _version, _id));
}pub fn destroy(_region: *Region) void {
    return @as(*server.wl.Resource, @ptrCast(_region)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Region {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_region: *Region) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_region)).getLink();
}pub fn getClient(_region: *Region) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_region)).getClient();
}pub fn getId(_region: *Region) u32 {
    return @as(*server.wl.Resource, @ptrCast(_region)).getId();
}pub fn getVersion(_region: *Region) u32 {
    return @as(*server.wl.Resource, @ptrCast(_region)).getVersion();
}pub fn postNoMemory(_region: *Region) void {
    return @as(*server.wl.Resource, @ptrCast(_region)).postNoMemory();
}pub const Request = union(enum) {destroy: void,add: struct {x:i32,y:i32,width:i32,height:i32,},
subtract: struct {x:i32,y:i32,width:i32,height:i32,},
};
pub inline fn setHandler(
    _region: *Region,
    comptime T: type,
    handle_request: *const fn (_region: *Region, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_region: *Region, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_region);
    _resource.setDispatcher(
        common.Dispatcher(Region, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Region, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const Subcompositor = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.subcompositor.getInterface;pub const Error = common.wl.subcompositor.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Subcompositor {
    return @ptrCast(try server.wl.Resource.create(_client, Subcompositor, _version, _id));
}pub fn destroy(_subcompositor: *Subcompositor) void {
    return @as(*server.wl.Resource, @ptrCast(_subcompositor)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Subcompositor {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_subcompositor: *Subcompositor) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_subcompositor)).getLink();
}pub fn getClient(_subcompositor: *Subcompositor) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_subcompositor)).getClient();
}pub fn getId(_subcompositor: *Subcompositor) u32 {
    return @as(*server.wl.Resource, @ptrCast(_subcompositor)).getId();
}pub fn getVersion(_subcompositor: *Subcompositor) u32 {
    return @as(*server.wl.Resource, @ptrCast(_subcompositor)).getVersion();
}pub fn postNoMemory(_subcompositor: *Subcompositor) void {
    return @as(*server.wl.Resource, @ptrCast(_subcompositor)).postNoMemory();
}pub fn postError(subcompositor: *Subcompositor, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(subcompositor)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,get_subsurface: struct {id:u32,surface:*server.wl.Surface,parent:*server.wl.Surface,},
};
pub inline fn setHandler(
    _subcompositor: *Subcompositor,
    comptime T: type,
    handle_request: *const fn (_subcompositor: *Subcompositor, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_subcompositor: *Subcompositor, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_subcompositor);
    _resource.setDispatcher(
        common.Dispatcher(Subcompositor, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Subcompositor, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const Subsurface = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.subsurface.getInterface;pub const Error = common.wl.subsurface.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Subsurface {
    return @ptrCast(try server.wl.Resource.create(_client, Subsurface, _version, _id));
}pub fn destroy(_subsurface: *Subsurface) void {
    return @as(*server.wl.Resource, @ptrCast(_subsurface)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Subsurface {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_subsurface: *Subsurface) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_subsurface)).getLink();
}pub fn getClient(_subsurface: *Subsurface) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_subsurface)).getClient();
}pub fn getId(_subsurface: *Subsurface) u32 {
    return @as(*server.wl.Resource, @ptrCast(_subsurface)).getId();
}pub fn getVersion(_subsurface: *Subsurface) u32 {
    return @as(*server.wl.Resource, @ptrCast(_subsurface)).getVersion();
}pub fn postNoMemory(_subsurface: *Subsurface) void {
    return @as(*server.wl.Resource, @ptrCast(_subsurface)).postNoMemory();
}pub fn postError(subsurface: *Subsurface, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(subsurface)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,set_position: struct {x:i32,y:i32,},
place_above: struct {sibling:*server.wl.Surface,},
place_below: struct {sibling:*server.wl.Surface,},
set_sync: void,set_desync: void,};
pub inline fn setHandler(
    _subsurface: *Subsurface,
    comptime T: type,
    handle_request: *const fn (_subsurface: *Subsurface, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_subsurface: *Subsurface, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_subsurface);
    _resource.setDispatcher(
        common.Dispatcher(Subsurface, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Subsurface, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const Shm = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.shm.getInterface;pub const Error = common.wl.shm.Error;
pub const Format = common.wl.shm.Format;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Shm {
    return @ptrCast(try server.wl.Resource.create(_client, Shm, _version, _id));
}pub fn destroy(_shm: *Shm) void {
    return @as(*server.wl.Resource, @ptrCast(_shm)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Shm {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_shm: *Shm) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_shm)).getLink();
}pub fn getClient(_shm: *Shm) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_shm)).getClient();
}pub fn getId(_shm: *Shm) u32 {
    return @as(*server.wl.Resource, @ptrCast(_shm)).getId();
}pub fn getVersion(_shm: *Shm) u32 {
    return @as(*server.wl.Resource, @ptrCast(_shm)).getVersion();
}pub fn postNoMemory(_shm: *Shm) void {
    return @as(*server.wl.Resource, @ptrCast(_shm)).postNoMemory();
}pub fn postError(shm: *Shm, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(shm)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {create_pool: struct {id:u32,fd:i32,size:i32,},
};
pub inline fn setHandler(
    _shm: *Shm,
    comptime T: type,
    handle_request: *const fn (_shm: *Shm, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_shm: *Shm, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_shm);
    _resource.setDispatcher(
        common.Dispatcher(Shm, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Shm, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendFormat(_shm: *Shm, _format:Format) void {const _resource: *server.wl.Resource = @ptrCast(_shm);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(Format )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_format))),
    .Struct => @bitCast(_format),
    else => unreachable,
 }},};
_resource.postEvent(0, &_args);}
};
pub const ShmPool = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.shm_pool.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*ShmPool {
    return @ptrCast(try server.wl.Resource.create(_client, ShmPool, _version, _id));
}pub fn destroy(_shm_pool: *ShmPool) void {
    return @as(*server.wl.Resource, @ptrCast(_shm_pool)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *ShmPool {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_shm_pool: *ShmPool) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_shm_pool)).getLink();
}pub fn getClient(_shm_pool: *ShmPool) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_shm_pool)).getClient();
}pub fn getId(_shm_pool: *ShmPool) u32 {
    return @as(*server.wl.Resource, @ptrCast(_shm_pool)).getId();
}pub fn getVersion(_shm_pool: *ShmPool) u32 {
    return @as(*server.wl.Resource, @ptrCast(_shm_pool)).getVersion();
}pub fn postNoMemory(_shm_pool: *ShmPool) void {
    return @as(*server.wl.Resource, @ptrCast(_shm_pool)).postNoMemory();
}pub const Request = union(enum) {create_buffer: struct {id:u32,offset:i32,width:i32,height:i32,stride:i32,format:common.wl.shm.Format,},
destroy: void,resize: struct {size:i32,},
};
pub inline fn setHandler(
    _shm_pool: *ShmPool,
    comptime T: type,
    handle_request: *const fn (_shm_pool: *ShmPool, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_shm_pool: *ShmPool, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_shm_pool);
    _resource.setDispatcher(
        common.Dispatcher(ShmPool, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*ShmPool, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const Output = opaque {
 pub const generated_version = 4;
 pub const getInterface = common.wl.output.getInterface;pub const Subpixel = common.wl.output.Subpixel;
pub const Transform = common.wl.output.Transform;
pub const Mode = common.wl.output.Mode;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Output {
    return @ptrCast(try server.wl.Resource.create(_client, Output, _version, _id));
}pub fn destroy(_output: *Output) void {
    return @as(*server.wl.Resource, @ptrCast(_output)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Output {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_output: *Output) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_output)).getLink();
}pub fn getClient(_output: *Output) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_output)).getClient();
}pub fn getId(_output: *Output) u32 {
    return @as(*server.wl.Resource, @ptrCast(_output)).getId();
}pub fn getVersion(_output: *Output) u32 {
    return @as(*server.wl.Resource, @ptrCast(_output)).getVersion();
}pub fn postNoMemory(_output: *Output) void {
    return @as(*server.wl.Resource, @ptrCast(_output)).postNoMemory();
}pub const Request = union(enum) {release: void,};
pub inline fn setHandler(
    _output: *Output,
    comptime T: type,
    handle_request: *const fn (_output: *Output, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_output: *Output, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_output);
    _resource.setDispatcher(
        common.Dispatcher(Output, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Output, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendGeometry(_output: *Output, _x:i32, _y:i32, _physical_width:i32, _physical_height:i32, _subpixel:Subpixel, _make:[*:0]const u8, _model:[*:0]const u8, _transform:Transform) void {const _resource: *server.wl.Resource = @ptrCast(_output);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .i = _physical_width},.{ .i = _physical_height},.{ .i = switch (@typeInfo(Subpixel )) {
    .Enum => @as(i32, @intCast(@intFromEnum(_subpixel))),
    .Struct => @bitCast(_subpixel),
    else => unreachable,
 }},.{ .s = _make},.{ .s = _model},.{ .i = switch (@typeInfo(Transform )) {
    .Enum => @as(i32, @intCast(@intFromEnum(_transform))),
    .Struct => @bitCast(_transform),
    else => unreachable,
 }},};
_resource.postEvent(0, &_args);}
pub fn sendMode(_output: *Output, _flags:Mode, _width:i32, _height:i32, _refresh:i32) void {const _resource: *server.wl.Resource = @ptrCast(_output);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(Mode )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_flags))),
    .Struct => @bitCast(_flags),
    else => unreachable,
 }},.{ .i = _width},.{ .i = _height},.{ .i = _refresh},};
_resource.postEvent(1, &_args);}
pub fn sendDone(_output: *Output) void {const _resource: *server.wl.Resource = @ptrCast(_output);_resource.postEvent(2, null);}
pub fn sendScale(_output: *Output, _factor:i32) void {const _resource: *server.wl.Resource = @ptrCast(_output);var _args = [_]common.Argument{.{ .i = _factor},};
_resource.postEvent(3, &_args);}
pub fn sendName(_output: *Output, _name:[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_output);var _args = [_]common.Argument{.{ .s = _name},};
_resource.postEvent(4, &_args);}
pub fn sendDescription(_output: *Output, _description:[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_output);var _args = [_]common.Argument{.{ .s = _description},};
_resource.postEvent(5, &_args);}
};
pub const Seat = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.seat.getInterface;pub const Capability = common.wl.seat.Capability;
pub const Error = common.wl.seat.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Seat {
    return @ptrCast(try server.wl.Resource.create(_client, Seat, _version, _id));
}pub fn destroy(_seat: *Seat) void {
    return @as(*server.wl.Resource, @ptrCast(_seat)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Seat {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_seat: *Seat) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_seat)).getLink();
}pub fn getClient(_seat: *Seat) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_seat)).getClient();
}pub fn getId(_seat: *Seat) u32 {
    return @as(*server.wl.Resource, @ptrCast(_seat)).getId();
}pub fn getVersion(_seat: *Seat) u32 {
    return @as(*server.wl.Resource, @ptrCast(_seat)).getVersion();
}pub fn postNoMemory(_seat: *Seat) void {
    return @as(*server.wl.Resource, @ptrCast(_seat)).postNoMemory();
}pub fn postError(seat: *Seat, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(seat)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {get_pointer: struct {id:u32,},
get_keyboard: struct {id:u32,},
get_touch: struct {id:u32,},
release: void,};
pub inline fn setHandler(
    _seat: *Seat,
    comptime T: type,
    handle_request: *const fn (_seat: *Seat, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_seat: *Seat, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_seat);
    _resource.setDispatcher(
        common.Dispatcher(Seat, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Seat, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendCapabilities(_seat: *Seat, _capabilities:Capability) void {const _resource: *server.wl.Resource = @ptrCast(_seat);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(Capability )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_capabilities))),
    .Struct => @bitCast(_capabilities),
    else => unreachable,
 }},};
_resource.postEvent(0, &_args);}
pub fn sendName(_seat: *Seat, _name:[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_seat);var _args = [_]common.Argument{.{ .s = _name},};
_resource.postEvent(1, &_args);}
};
pub const Pointer = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.pointer.getInterface;pub const Error = common.wl.pointer.Error;
pub const ButtonState = common.wl.pointer.ButtonState;
pub const Axis = common.wl.pointer.Axis;
pub const AxisSource = common.wl.pointer.AxisSource;
pub const AxisRelativeDirection = common.wl.pointer.AxisRelativeDirection;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Pointer {
    return @ptrCast(try server.wl.Resource.create(_client, Pointer, _version, _id));
}pub fn destroy(_pointer: *Pointer) void {
    return @as(*server.wl.Resource, @ptrCast(_pointer)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Pointer {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_pointer: *Pointer) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_pointer)).getLink();
}pub fn getClient(_pointer: *Pointer) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_pointer)).getClient();
}pub fn getId(_pointer: *Pointer) u32 {
    return @as(*server.wl.Resource, @ptrCast(_pointer)).getId();
}pub fn getVersion(_pointer: *Pointer) u32 {
    return @as(*server.wl.Resource, @ptrCast(_pointer)).getVersion();
}pub fn postNoMemory(_pointer: *Pointer) void {
    return @as(*server.wl.Resource, @ptrCast(_pointer)).postNoMemory();
}pub fn postError(pointer: *Pointer, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(pointer)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {set_cursor: struct {serial:u32,surface:?*server.wl.Surface,hotspot_x:i32,hotspot_y:i32,},
release: void,};
pub inline fn setHandler(
    _pointer: *Pointer,
    comptime T: type,
    handle_request: *const fn (_pointer: *Pointer, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_pointer: *Pointer, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_pointer);
    _resource.setDispatcher(
        common.Dispatcher(Pointer, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Pointer, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendEnter(_pointer: *Pointer, _serial:u32, _surface:*server.wl.Surface, _surface_x:common.Fixed, _surface_y:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _serial},.{ .o = @ptrCast(_surface) },.{ .f = _surface_x},.{ .f = _surface_y},};
_resource.postEvent(0, &_args);}
pub fn sendLeave(_pointer: *Pointer, _serial:u32, _surface:*server.wl.Surface) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _serial},.{ .o = @ptrCast(_surface) },};
_resource.postEvent(1, &_args);}
pub fn sendMotion(_pointer: *Pointer, _time:u32, _surface_x:common.Fixed, _surface_y:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _time},.{ .f = _surface_x},.{ .f = _surface_y},};
_resource.postEvent(2, &_args);}
pub fn sendButton(_pointer: *Pointer, _serial:u32, _time:u32, _button:u32, _state:ButtonState) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _serial},.{ .u = _time},.{ .u = _button},.{ .u = switch (@typeInfo(ButtonState )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_state))),
    .Struct => @bitCast(_state),
    else => unreachable,
 }},};
_resource.postEvent(3, &_args);}
pub fn sendAxis(_pointer: *Pointer, _time:u32, _axis:Axis, _value:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _time},.{ .u = switch (@typeInfo(Axis )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_axis))),
    .Struct => @bitCast(_axis),
    else => unreachable,
 }},.{ .f = _value},};
_resource.postEvent(4, &_args);}
pub fn sendFrame(_pointer: *Pointer) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);_resource.postEvent(5, null);}
pub fn sendAxisSource(_pointer: *Pointer, _axis_source:AxisSource) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(AxisSource )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_axis_source))),
    .Struct => @bitCast(_axis_source),
    else => unreachable,
 }},};
_resource.postEvent(6, &_args);}
pub fn sendAxisStop(_pointer: *Pointer, _time:u32, _axis:Axis) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _time},.{ .u = switch (@typeInfo(Axis )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_axis))),
    .Struct => @bitCast(_axis),
    else => unreachable,
 }},};
_resource.postEvent(7, &_args);}
pub fn sendAxisDiscrete(_pointer: *Pointer, _axis:Axis, _discrete:i32) void {const _resource: *server.wl.Resource = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(Axis )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_axis))),
    .Struct => @bitCast(_axis),
    else => unreachable,
 }},.{ .i = _discrete},};
_resource.postEvent(8, &_args);}
};
pub const Keyboard = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.keyboard.getInterface;pub const KeymapFormat = common.wl.keyboard.KeymapFormat;
pub const KeyState = common.wl.keyboard.KeyState;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Keyboard {
    return @ptrCast(try server.wl.Resource.create(_client, Keyboard, _version, _id));
}pub fn destroy(_keyboard: *Keyboard) void {
    return @as(*server.wl.Resource, @ptrCast(_keyboard)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Keyboard {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_keyboard: *Keyboard) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_keyboard)).getLink();
}pub fn getClient(_keyboard: *Keyboard) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_keyboard)).getClient();
}pub fn getId(_keyboard: *Keyboard) u32 {
    return @as(*server.wl.Resource, @ptrCast(_keyboard)).getId();
}pub fn getVersion(_keyboard: *Keyboard) u32 {
    return @as(*server.wl.Resource, @ptrCast(_keyboard)).getVersion();
}pub fn postNoMemory(_keyboard: *Keyboard) void {
    return @as(*server.wl.Resource, @ptrCast(_keyboard)).postNoMemory();
}pub const Request = union(enum) {release: void,};
pub inline fn setHandler(
    _keyboard: *Keyboard,
    comptime T: type,
    handle_request: *const fn (_keyboard: *Keyboard, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_keyboard: *Keyboard, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_keyboard);
    _resource.setDispatcher(
        common.Dispatcher(Keyboard, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Keyboard, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendKeymap(_keyboard: *Keyboard, _format:KeymapFormat, _fd:i32, _size:u32) void {const _resource: *server.wl.Resource = @ptrCast(_keyboard);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(KeymapFormat )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_format))),
    .Struct => @bitCast(_format),
    else => unreachable,
 }},.{ .h = _fd},.{ .u = _size},};
_resource.postEvent(0, &_args);}
pub fn sendEnter(_keyboard: *Keyboard, _serial:u32, _surface:*server.wl.Surface, _keys:*common.Array) void {const _resource: *server.wl.Resource = @ptrCast(_keyboard);var _args = [_]common.Argument{.{ .u = _serial},.{ .o = @ptrCast(_surface) },.{ .a = _keys},};
_resource.postEvent(1, &_args);}
pub fn sendLeave(_keyboard: *Keyboard, _serial:u32, _surface:*server.wl.Surface) void {const _resource: *server.wl.Resource = @ptrCast(_keyboard);var _args = [_]common.Argument{.{ .u = _serial},.{ .o = @ptrCast(_surface) },};
_resource.postEvent(2, &_args);}
pub fn sendKey(_keyboard: *Keyboard, _serial:u32, _time:u32, _key:u32, _state:KeyState) void {const _resource: *server.wl.Resource = @ptrCast(_keyboard);var _args = [_]common.Argument{.{ .u = _serial},.{ .u = _time},.{ .u = _key},.{ .u = switch (@typeInfo(KeyState )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_state))),
    .Struct => @bitCast(_state),
    else => unreachable,
 }},};
_resource.postEvent(3, &_args);}
pub fn sendModifiers(_keyboard: *Keyboard, _serial:u32, _mods_depressed:u32, _mods_latched:u32, _mods_locked:u32, _group:u32) void {const _resource: *server.wl.Resource = @ptrCast(_keyboard);var _args = [_]common.Argument{.{ .u = _serial},.{ .u = _mods_depressed},.{ .u = _mods_latched},.{ .u = _mods_locked},.{ .u = _group},};
_resource.postEvent(4, &_args);}
pub fn sendRepeatInfo(_keyboard: *Keyboard, _rate:i32, _delay:i32) void {const _resource: *server.wl.Resource = @ptrCast(_keyboard);var _args = [_]common.Argument{.{ .i = _rate},.{ .i = _delay},};
_resource.postEvent(5, &_args);}
};
pub const Touch = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.touch.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*Touch {
    return @ptrCast(try server.wl.Resource.create(_client, Touch, _version, _id));
}pub fn destroy(_touch: *Touch) void {
    return @as(*server.wl.Resource, @ptrCast(_touch)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *Touch {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_touch: *Touch) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_touch)).getLink();
}pub fn getClient(_touch: *Touch) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_touch)).getClient();
}pub fn getId(_touch: *Touch) u32 {
    return @as(*server.wl.Resource, @ptrCast(_touch)).getId();
}pub fn getVersion(_touch: *Touch) u32 {
    return @as(*server.wl.Resource, @ptrCast(_touch)).getVersion();
}pub fn postNoMemory(_touch: *Touch) void {
    return @as(*server.wl.Resource, @ptrCast(_touch)).postNoMemory();
}pub const Request = union(enum) {release: void,};
pub inline fn setHandler(
    _touch: *Touch,
    comptime T: type,
    handle_request: *const fn (_touch: *Touch, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_touch: *Touch, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_touch);
    _resource.setDispatcher(
        common.Dispatcher(Touch, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*Touch, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendDown(_touch: *Touch, _serial:u32, _time:u32, _surface:*server.wl.Surface, _id:i32, _x:common.Fixed, _y:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_touch);var _args = [_]common.Argument{.{ .u = _serial},.{ .u = _time},.{ .o = @ptrCast(_surface) },.{ .i = _id},.{ .f = _x},.{ .f = _y},};
_resource.postEvent(0, &_args);}
pub fn sendUp(_touch: *Touch, _serial:u32, _time:u32, _id:i32) void {const _resource: *server.wl.Resource = @ptrCast(_touch);var _args = [_]common.Argument{.{ .u = _serial},.{ .u = _time},.{ .i = _id},};
_resource.postEvent(1, &_args);}
pub fn sendMotion(_touch: *Touch, _time:u32, _id:i32, _x:common.Fixed, _y:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_touch);var _args = [_]common.Argument{.{ .u = _time},.{ .i = _id},.{ .f = _x},.{ .f = _y},};
_resource.postEvent(2, &_args);}
pub fn sendFrame(_touch: *Touch) void {const _resource: *server.wl.Resource = @ptrCast(_touch);_resource.postEvent(3, null);}
pub fn sendCancel(_touch: *Touch) void {const _resource: *server.wl.Resource = @ptrCast(_touch);_resource.postEvent(4, null);}
pub fn sendShape(_touch: *Touch, _id:i32, _major:common.Fixed, _minor:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_touch);var _args = [_]common.Argument{.{ .i = _id},.{ .f = _major},.{ .f = _minor},};
_resource.postEvent(5, &_args);}
pub fn sendOrientation(_touch: *Touch, _id:i32, _orientation:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_touch);var _args = [_]common.Argument{.{ .i = _id},.{ .f = _orientation},};
_resource.postEvent(6, &_args);}
};
pub const DataDeviceManager = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_device_manager.getInterface;pub const DndAction = common.wl.data_device_manager.DndAction;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*DataDeviceManager {
    return @ptrCast(try server.wl.Resource.create(_client, DataDeviceManager, _version, _id));
}pub fn destroy(_data_device_manager: *DataDeviceManager) void {
    return @as(*server.wl.Resource, @ptrCast(_data_device_manager)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *DataDeviceManager {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_data_device_manager: *DataDeviceManager) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_data_device_manager)).getLink();
}pub fn getClient(_data_device_manager: *DataDeviceManager) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_data_device_manager)).getClient();
}pub fn getId(_data_device_manager: *DataDeviceManager) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_device_manager)).getId();
}pub fn getVersion(_data_device_manager: *DataDeviceManager) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_device_manager)).getVersion();
}pub fn postNoMemory(_data_device_manager: *DataDeviceManager) void {
    return @as(*server.wl.Resource, @ptrCast(_data_device_manager)).postNoMemory();
}pub const Request = union(enum) {create_data_source: struct {id:u32,},
get_data_device: struct {id:u32,seat:*server.wl.Seat,},
};
pub inline fn setHandler(
    _data_device_manager: *DataDeviceManager,
    comptime T: type,
    handle_request: *const fn (_data_device_manager: *DataDeviceManager, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_data_device_manager: *DataDeviceManager, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_data_device_manager);
    _resource.setDispatcher(
        common.Dispatcher(DataDeviceManager, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*DataDeviceManager, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const DataSource = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_source.getInterface;pub const Error = common.wl.data_source.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*DataSource {
    return @ptrCast(try server.wl.Resource.create(_client, DataSource, _version, _id));
}pub fn destroy(_data_source: *DataSource) void {
    return @as(*server.wl.Resource, @ptrCast(_data_source)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *DataSource {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_data_source: *DataSource) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_data_source)).getLink();
}pub fn getClient(_data_source: *DataSource) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_data_source)).getClient();
}pub fn getId(_data_source: *DataSource) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_source)).getId();
}pub fn getVersion(_data_source: *DataSource) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_source)).getVersion();
}pub fn postNoMemory(_data_source: *DataSource) void {
    return @as(*server.wl.Resource, @ptrCast(_data_source)).postNoMemory();
}pub fn postError(data_source: *DataSource, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(data_source)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {offer: struct {mime_type:[*:0]const u8,},
destroy: void,set_actions: struct {dnd_actions:common.wl.data_device_manager.DndAction,},
};
pub inline fn setHandler(
    _data_source: *DataSource,
    comptime T: type,
    handle_request: *const fn (_data_source: *DataSource, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_data_source: *DataSource, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_data_source);
    _resource.setDispatcher(
        common.Dispatcher(DataSource, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*DataSource, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendTarget(_data_source: *DataSource, _mime_type:?[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_data_source);var _args = [_]common.Argument{.{ .s = _mime_type},};
_resource.postEvent(0, &_args);}
pub fn sendSend(_data_source: *DataSource, _mime_type:[*:0]const u8, _fd:i32) void {const _resource: *server.wl.Resource = @ptrCast(_data_source);var _args = [_]common.Argument{.{ .s = _mime_type},.{ .h = _fd},};
_resource.postEvent(1, &_args);}
pub fn sendCancelled(_data_source: *DataSource) void {const _resource: *server.wl.Resource = @ptrCast(_data_source);_resource.postEvent(2, null);}
pub fn sendDndDropPerformed(_data_source: *DataSource) void {const _resource: *server.wl.Resource = @ptrCast(_data_source);_resource.postEvent(3, null);}
pub fn sendDndFinished(_data_source: *DataSource) void {const _resource: *server.wl.Resource = @ptrCast(_data_source);_resource.postEvent(4, null);}
pub fn sendAction(_data_source: *DataSource, _dnd_action:common.wl.data_device_manager.DndAction) void {const _resource: *server.wl.Resource = @ptrCast(_data_source);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(common.wl.data_device_manager.DndAction )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_dnd_action))),
    .Struct => @bitCast(_dnd_action),
    else => unreachable,
 }},};
_resource.postEvent(5, &_args);}
};
pub const DataDevice = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_device.getInterface;pub const Error = common.wl.data_device.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*DataDevice {
    return @ptrCast(try server.wl.Resource.create(_client, DataDevice, _version, _id));
}pub fn destroy(_data_device: *DataDevice) void {
    return @as(*server.wl.Resource, @ptrCast(_data_device)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *DataDevice {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_data_device: *DataDevice) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_data_device)).getLink();
}pub fn getClient(_data_device: *DataDevice) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_data_device)).getClient();
}pub fn getId(_data_device: *DataDevice) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_device)).getId();
}pub fn getVersion(_data_device: *DataDevice) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_device)).getVersion();
}pub fn postNoMemory(_data_device: *DataDevice) void {
    return @as(*server.wl.Resource, @ptrCast(_data_device)).postNoMemory();
}pub fn postError(data_device: *DataDevice, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(data_device)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {start_drag: struct {source:?*server.wl.DataSource,origin:*server.wl.Surface,icon:?*server.wl.Surface,serial:u32,},
set_selection: struct {source:?*server.wl.DataSource,serial:u32,},
release: void,};
pub inline fn setHandler(
    _data_device: *DataDevice,
    comptime T: type,
    handle_request: *const fn (_data_device: *DataDevice, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_data_device: *DataDevice, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_data_device);
    _resource.setDispatcher(
        common.Dispatcher(DataDevice, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*DataDevice, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendDataOffer(_data_device: *DataDevice, _id:*server.wl.DataOffer) void {const _resource: *server.wl.Resource = @ptrCast(_data_device);var _args = [_]common.Argument{.{ .o = @ptrCast(_id) },};
_resource.postEvent(0, &_args);}
pub fn sendEnter(_data_device: *DataDevice, _serial:u32, _surface:*server.wl.Surface, _x:common.Fixed, _y:common.Fixed, _id:?*server.wl.DataOffer) void {const _resource: *server.wl.Resource = @ptrCast(_data_device);var _args = [_]common.Argument{.{ .u = _serial},.{ .o = @ptrCast(_surface) },.{ .f = _x},.{ .f = _y},.{ .o = @ptrCast(_id) },};
_resource.postEvent(1, &_args);}
pub fn sendLeave(_data_device: *DataDevice) void {const _resource: *server.wl.Resource = @ptrCast(_data_device);_resource.postEvent(2, null);}
pub fn sendMotion(_data_device: *DataDevice, _time:u32, _x:common.Fixed, _y:common.Fixed) void {const _resource: *server.wl.Resource = @ptrCast(_data_device);var _args = [_]common.Argument{.{ .u = _time},.{ .f = _x},.{ .f = _y},};
_resource.postEvent(3, &_args);}
pub fn sendDrop(_data_device: *DataDevice) void {const _resource: *server.wl.Resource = @ptrCast(_data_device);_resource.postEvent(4, null);}
pub fn sendSelection(_data_device: *DataDevice, _id:?*server.wl.DataOffer) void {const _resource: *server.wl.Resource = @ptrCast(_data_device);var _args = [_]common.Argument{.{ .o = @ptrCast(_id) },};
_resource.postEvent(5, &_args);}
};
pub const DataOffer = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_offer.getInterface;pub const Error = common.wl.data_offer.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*DataOffer {
    return @ptrCast(try server.wl.Resource.create(_client, DataOffer, _version, _id));
}pub fn destroy(_data_offer: *DataOffer) void {
    return @as(*server.wl.Resource, @ptrCast(_data_offer)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *DataOffer {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_data_offer: *DataOffer) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_data_offer)).getLink();
}pub fn getClient(_data_offer: *DataOffer) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_data_offer)).getClient();
}pub fn getId(_data_offer: *DataOffer) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_offer)).getId();
}pub fn getVersion(_data_offer: *DataOffer) u32 {
    return @as(*server.wl.Resource, @ptrCast(_data_offer)).getVersion();
}pub fn postNoMemory(_data_offer: *DataOffer) void {
    return @as(*server.wl.Resource, @ptrCast(_data_offer)).postNoMemory();
}pub fn postError(data_offer: *DataOffer, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(data_offer)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {accept: struct {serial:u32,mime_type:?[*:0]const u8,},
receive: struct {mime_type:[*:0]const u8,fd:i32,},
destroy: void,finish: void,set_actions: struct {dnd_actions:common.wl.data_device_manager.DndAction,preferred_action:common.wl.data_device_manager.DndAction,},
};
pub inline fn setHandler(
    _data_offer: *DataOffer,
    comptime T: type,
    handle_request: *const fn (_data_offer: *DataOffer, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_data_offer: *DataOffer, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_data_offer);
    _resource.setDispatcher(
        common.Dispatcher(DataOffer, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*DataOffer, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendOffer(_data_offer: *DataOffer, _mime_type:[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_data_offer);var _args = [_]common.Argument{.{ .s = _mime_type},};
_resource.postEvent(0, &_args);}
pub fn sendSourceActions(_data_offer: *DataOffer, _source_actions:common.wl.data_device_manager.DndAction) void {const _resource: *server.wl.Resource = @ptrCast(_data_offer);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(common.wl.data_device_manager.DndAction )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_source_actions))),
    .Struct => @bitCast(_source_actions),
    else => unreachable,
 }},};
_resource.postEvent(1, &_args);}
pub fn sendAction(_data_offer: *DataOffer, _dnd_action:common.wl.data_device_manager.DndAction) void {const _resource: *server.wl.Resource = @ptrCast(_data_offer);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(common.wl.data_device_manager.DndAction )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_dnd_action))),
    .Struct => @bitCast(_dnd_action),
    else => unreachable,
 }},};
_resource.postEvent(2, &_args);}
};
