// Generated by zig-wayland

// Copyright © 2008-2011 Kristian Høgsberg
// Copyright © 2010-2011 Intel Corporation
// Copyright © 2012-2013 Collabora, Ltd.
// 
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge,
// publish, distribute, sublicense, and/or sell copies of the Software,
// and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
// 
// The above copyright notice and this permission notice (including the
// next paragraph) shall be included in all copies or substantial
// portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
// BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 

const std = @import("std");
const os = std.os;
const client = @import("wayland.zig").client;
const common = @import("common.zig");pub const Display = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.display.getInterface;pub const Error = common.wl.display.Error;
pub fn setQueue(_display: *Display, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_display);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {@"error": struct {object_id:?*common.Object,code:u32,message:[*:0]const u8,},
delete_id: struct {id:u32,},
};
pub inline fn setListener(
    _display: *Display,
    comptime T: type,
    _listener: *const fn (display: *Display, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_display);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Display, T).dispatcher, _listener, _mut_data);
}pub fn sync(_display: *Display) !*client.wl.Callback{const _proxy: *client.wl.Proxy = @ptrCast(_display);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(0, &_args, client.wl.Callback.getInterface()));}
pub fn getRegistry(_display: *Display) !*client.wl.Registry{const _proxy: *client.wl.Proxy = @ptrCast(_display);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.wl.Registry.getInterface()));}
extern fn wl_display_connect(name: ?[*:0]const u8) ?*Display;
pub inline fn connect(name: ?[*:0]const u8) error{ConnectFailed}!*Display {
    return wl_display_connect(name) orelse return error.ConnectFailed;
}

extern fn wl_display_connect_to_fd(fd: c_int) ?*Display;
pub inline fn connectToFd(fd: c_int) error{ConnectFailed}!*Display {
    return wl_display_connect_to_fd(fd) orelse return error.ConnectFailed;
}

extern fn wl_display_disconnect(display: *Display) void;
pub const disconnect = wl_display_disconnect;

extern fn wl_display_get_fd(display: *Display) c_int;
pub const getFd = wl_display_get_fd;

extern fn wl_display_dispatch(display: *Display) c_int;
pub inline fn dispatch(display: *Display) os.E {
    return os.errno(wl_display_dispatch(display));
}

extern fn wl_display_dispatch_queue(display: *Display, queue: *client.wl.EventQueue) c_int;
pub inline fn dispatchQueue(display: *Display, queue: *client.wl.EventQueue) os.E {
    return os.errno(wl_display_dispatch_queue(display, queue));
}

extern fn wl_display_dispatch_pending(display: *Display) c_int;
pub inline fn dispatchPending(display: *Display) os.E {
    return os.errno(wl_display_dispatch_pending(display));
}

extern fn wl_display_dispatch_queue_pending(display: *Display, queue: *client.wl.EventQueue) c_int;
pub inline fn dispatchQueuePending(display: *Display, queue: *client.wl.EventQueue) os.E {
    return os.errno(wl_display_dispatch_queue_pending(display, queue));
}

extern fn wl_display_roundtrip(display: *Display) c_int;
pub inline fn roundtrip(display: *Display) os.E {
    return os.errno(wl_display_roundtrip(display));
}

extern fn wl_display_roundtrip_queue(display: *Display, queue: *client.wl.EventQueue) c_int;
pub inline fn roundtripQueue(display: *Display, queue: *client.wl.EventQueue) os.E {
    return os.errno(wl_display_roundtrip_queue(display, queue));
}

extern fn wl_display_flush(display: *Display) c_int;
pub inline fn flush(display: *Display) os.E {
    return os.errno(wl_display_flush(display));
}

extern fn wl_display_create_queue(display: *Display) ?*client.wl.EventQueue;
pub inline fn createQueue(display: *Display) error{OutOfMemory}!*client.wl.EventQueue {
    return wl_display_create_queue(display) orelse error.OutOfMemory;
}

extern fn wl_display_get_error(display: *Display) c_int;
pub const getError = wl_display_get_error;

extern fn wl_display_prepare_read_queue(display: *Display, queue: *client.wl.EventQueue) c_int;
/// Succeeds if the queue is empty and returns true.
/// Fails and returns false if the queue was not empty.
pub inline fn prepareReadQueue(display: *Display, queue: *client.wl.EventQueue) bool {
    switch (wl_display_prepare_read_queue(display, queue)) {
        0 => return true,
        -1 => return false,
        else => unreachable,
    }
}

extern fn wl_display_prepare_read(display: *Display) c_int;
/// Succeeds if the queue is empty and returns true.
/// Fails and returns false if the queue was not empty.
pub inline fn prepareRead(display: *Display) bool {
    switch (wl_display_prepare_read(display)) {
        0 => return true,
        -1 => return false,
        else => unreachable,
    }
}

extern fn wl_display_cancel_read(display: *Display) void;
pub const cancelRead = wl_display_cancel_read;

extern fn wl_display_read_events(display: *Display) c_int;
pub inline fn readEvents(display: *Display) os.E {
    return os.errno(wl_display_read_events(display));
}
};
pub const Registry = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.registry.getInterface;pub fn setQueue(_registry: *Registry, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_registry);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {global: struct {name:u32,interface:[*:0]const u8,version:u32,},
global_remove: struct {name:u32,},
};
pub inline fn setListener(
    _registry: *Registry,
    comptime T: type,
    _listener: *const fn (registry: *Registry, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_registry);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Registry, T).dispatcher, _listener, _mut_data);
}pub fn bind(_registry: *Registry, _name:u32, comptime T: type, _version: u32) !*T {const version_to_construct = @min(T.generated_version, _version);const _proxy: *client.wl.Proxy = @ptrCast(_registry);var _args = [_]common.Argument{.{ .u = _name},.{ .s = T.getInterface().name },
.{ .u = version_to_construct },.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructorVersioned(0, &_args, T.getInterface(), version_to_construct));}
pub fn destroy(_registry: *Registry) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_registry);
    _proxy.destroy();
}};
pub const Callback = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.callback.getInterface;pub fn setQueue(_callback: *Callback, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_callback);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {done: struct {callback_data:u32,},
};
pub inline fn setListener(
    _callback: *Callback,
    comptime T: type,
    _listener: *const fn (callback: *Callback, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_callback);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Callback, T).dispatcher, _listener, _mut_data);
}pub fn destroy(_callback: *Callback) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_callback);
    _proxy.destroy();
}};
pub const Buffer = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.buffer.getInterface;pub fn setQueue(_buffer: *Buffer, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_buffer);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {release: void,};
pub inline fn setListener(
    _buffer: *Buffer,
    comptime T: type,
    _listener: *const fn (buffer: *Buffer, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_buffer);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Buffer, T).dispatcher, _listener, _mut_data);
}pub fn destroy(_buffer: *Buffer) void {const _proxy: *client.wl.Proxy = @ptrCast(_buffer);_proxy.marshal(0, null);_proxy.destroy();}
};
pub const Compositor = opaque {
 pub const generated_version = 4;
 pub const getInterface = common.wl.compositor.getInterface;pub fn setQueue(_compositor: *Compositor, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_compositor);
    _proxy.setQueue(_queue);
}pub fn createSurface(_compositor: *Compositor) !*client.wl.Surface{const _proxy: *client.wl.Proxy = @ptrCast(_compositor);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(0, &_args, client.wl.Surface.getInterface()));}
pub fn createRegion(_compositor: *Compositor) !*client.wl.Region{const _proxy: *client.wl.Proxy = @ptrCast(_compositor);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.wl.Region.getInterface()));}
pub fn destroy(_compositor: *Compositor) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_compositor);
    _proxy.destroy();
}};
pub const Surface = opaque {
 pub const generated_version = 4;
 pub const getInterface = common.wl.surface.getInterface;pub const Error = common.wl.surface.Error;
pub fn setQueue(_surface: *Surface, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_surface);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {enter: struct {output:?*client.wl.Output,},
leave: struct {output:?*client.wl.Output,},
};
pub inline fn setListener(
    _surface: *Surface,
    comptime T: type,
    _listener: *const fn (surface: *Surface, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_surface);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Surface, T).dispatcher, _listener, _mut_data);
}pub fn destroy(_surface: *Surface) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);_proxy.marshal(0, null);_proxy.destroy();}
pub fn attach(_surface: *Surface, _buffer:?*client.wl.Buffer, _x:i32, _y:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .o = @ptrCast(_buffer) },.{ .i = _x},.{ .i = _y},};
_proxy.marshal(1, &_args);}
pub fn damage(_surface: *Surface, _x:i32, _y:i32, _width:i32, _height:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .i = _width},.{ .i = _height},};
_proxy.marshal(2, &_args);}
pub fn frame(_surface: *Surface) !*client.wl.Callback{const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(3, &_args, client.wl.Callback.getInterface()));}
pub fn setOpaqueRegion(_surface: *Surface, _region:?*client.wl.Region) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .o = @ptrCast(_region) },};
_proxy.marshal(4, &_args);}
pub fn setInputRegion(_surface: *Surface, _region:?*client.wl.Region) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .o = @ptrCast(_region) },};
_proxy.marshal(5, &_args);}
pub fn commit(_surface: *Surface) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);_proxy.marshal(6, null);}
pub fn setBufferTransform(_surface: *Surface, _transform:common.wl.output.Transform) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .i = switch (@typeInfo(common.wl.output.Transform )) {
    .Enum => @as(i32, @intCast(@intFromEnum(_transform))),
    .Struct => @bitCast(_transform),
    else => unreachable,
 }},};
_proxy.marshal(7, &_args);}
pub fn setBufferScale(_surface: *Surface, _scale:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .i = _scale},};
_proxy.marshal(8, &_args);}
pub fn damageBuffer(_surface: *Surface, _x:i32, _y:i32, _width:i32, _height:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_surface);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .i = _width},.{ .i = _height},};
_proxy.marshal(9, &_args);}
};
pub const Region = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.region.getInterface;pub fn setQueue(_region: *Region, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_region);
    _proxy.setQueue(_queue);
}pub fn destroy(_region: *Region) void {const _proxy: *client.wl.Proxy = @ptrCast(_region);_proxy.marshal(0, null);_proxy.destroy();}
pub fn add(_region: *Region, _x:i32, _y:i32, _width:i32, _height:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_region);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .i = _width},.{ .i = _height},};
_proxy.marshal(1, &_args);}
pub fn subtract(_region: *Region, _x:i32, _y:i32, _width:i32, _height:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_region);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .i = _width},.{ .i = _height},};
_proxy.marshal(2, &_args);}
};
pub const Subcompositor = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.subcompositor.getInterface;pub const Error = common.wl.subcompositor.Error;
pub fn setQueue(_subcompositor: *Subcompositor, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_subcompositor);
    _proxy.setQueue(_queue);
}pub fn destroy(_subcompositor: *Subcompositor) void {const _proxy: *client.wl.Proxy = @ptrCast(_subcompositor);_proxy.marshal(0, null);_proxy.destroy();}
pub fn getSubsurface(_subcompositor: *Subcompositor, _surface:*client.wl.Surface, _parent:*client.wl.Surface) !*client.wl.Subsurface{const _proxy: *client.wl.Proxy = @ptrCast(_subcompositor);var _args = [_]common.Argument{.{ .o = null },.{ .o = @ptrCast(_surface) },.{ .o = @ptrCast(_parent) },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.wl.Subsurface.getInterface()));}
};
pub const Subsurface = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.subsurface.getInterface;pub const Error = common.wl.subsurface.Error;
pub fn setQueue(_subsurface: *Subsurface, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);
    _proxy.setQueue(_queue);
}pub fn destroy(_subsurface: *Subsurface) void {const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);_proxy.marshal(0, null);_proxy.destroy();}
pub fn setPosition(_subsurface: *Subsurface, _x:i32, _y:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},};
_proxy.marshal(1, &_args);}
pub fn placeAbove(_subsurface: *Subsurface, _sibling:*client.wl.Surface) void {const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);var _args = [_]common.Argument{.{ .o = @ptrCast(_sibling) },};
_proxy.marshal(2, &_args);}
pub fn placeBelow(_subsurface: *Subsurface, _sibling:*client.wl.Surface) void {const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);var _args = [_]common.Argument{.{ .o = @ptrCast(_sibling) },};
_proxy.marshal(3, &_args);}
pub fn setSync(_subsurface: *Subsurface) void {const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);_proxy.marshal(4, null);}
pub fn setDesync(_subsurface: *Subsurface) void {const _proxy: *client.wl.Proxy = @ptrCast(_subsurface);_proxy.marshal(5, null);}
};
pub const Shm = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.shm.getInterface;pub const Error = common.wl.shm.Error;
pub const Format = common.wl.shm.Format;
pub fn setQueue(_shm: *Shm, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_shm);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {format: struct {format:Format,},
};
pub inline fn setListener(
    _shm: *Shm,
    comptime T: type,
    _listener: *const fn (shm: *Shm, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_shm);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Shm, T).dispatcher, _listener, _mut_data);
}pub fn createPool(_shm: *Shm, _fd:i32, _size:i32) !*client.wl.ShmPool{const _proxy: *client.wl.Proxy = @ptrCast(_shm);var _args = [_]common.Argument{.{ .o = null },.{ .h = _fd},.{ .i = _size},};
return @ptrCast(try _proxy.marshalConstructor(0, &_args, client.wl.ShmPool.getInterface()));}
pub fn destroy(_shm: *Shm) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_shm);
    _proxy.destroy();
}};
pub const ShmPool = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.wl.shm_pool.getInterface;pub fn setQueue(_shm_pool: *ShmPool, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_shm_pool);
    _proxy.setQueue(_queue);
}pub fn createBuffer(_shm_pool: *ShmPool, _offset:i32, _width:i32, _height:i32, _stride:i32, _format:common.wl.shm.Format) !*client.wl.Buffer{const _proxy: *client.wl.Proxy = @ptrCast(_shm_pool);var _args = [_]common.Argument{.{ .o = null },.{ .i = _offset},.{ .i = _width},.{ .i = _height},.{ .i = _stride},.{ .u = switch (@typeInfo(common.wl.shm.Format )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_format))),
    .Struct => @bitCast(_format),
    else => unreachable,
 }},};
return @ptrCast(try _proxy.marshalConstructor(0, &_args, client.wl.Buffer.getInterface()));}
pub fn destroy(_shm_pool: *ShmPool) void {const _proxy: *client.wl.Proxy = @ptrCast(_shm_pool);_proxy.marshal(1, null);_proxy.destroy();}
pub fn resize(_shm_pool: *ShmPool, _size:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_shm_pool);var _args = [_]common.Argument{.{ .i = _size},};
_proxy.marshal(2, &_args);}
};
pub const Output = opaque {
 pub const generated_version = 4;
 pub const getInterface = common.wl.output.getInterface;pub const Subpixel = common.wl.output.Subpixel;
pub const Transform = common.wl.output.Transform;
pub const Mode = common.wl.output.Mode;
pub fn setQueue(_output: *Output, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_output);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {geometry: struct {x:i32,y:i32,physical_width:i32,physical_height:i32,subpixel:Subpixel,make:[*:0]const u8,model:[*:0]const u8,transform:Transform,},
mode: struct {flags:Mode,width:i32,height:i32,refresh:i32,},
done: void,scale: struct {factor:i32,},
name: struct {name:[*:0]const u8,},
description: struct {description:[*:0]const u8,},
};
pub inline fn setListener(
    _output: *Output,
    comptime T: type,
    _listener: *const fn (output: *Output, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_output);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Output, T).dispatcher, _listener, _mut_data);
}pub fn release(_output: *Output) void {const _proxy: *client.wl.Proxy = @ptrCast(_output);_proxy.marshal(0, null);_proxy.destroy();}
pub fn destroy(_output: *Output) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_output);
    _proxy.destroy();
}};
pub const Seat = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.seat.getInterface;pub const Capability = common.wl.seat.Capability;
pub const Error = common.wl.seat.Error;
pub fn setQueue(_seat: *Seat, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_seat);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {capabilities: struct {capabilities:Capability,},
name: struct {name:[*:0]const u8,},
};
pub inline fn setListener(
    _seat: *Seat,
    comptime T: type,
    _listener: *const fn (seat: *Seat, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_seat);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Seat, T).dispatcher, _listener, _mut_data);
}pub fn getPointer(_seat: *Seat) !*client.wl.Pointer{const _proxy: *client.wl.Proxy = @ptrCast(_seat);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(0, &_args, client.wl.Pointer.getInterface()));}
pub fn getKeyboard(_seat: *Seat) !*client.wl.Keyboard{const _proxy: *client.wl.Proxy = @ptrCast(_seat);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.wl.Keyboard.getInterface()));}
pub fn getTouch(_seat: *Seat) !*client.wl.Touch{const _proxy: *client.wl.Proxy = @ptrCast(_seat);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(2, &_args, client.wl.Touch.getInterface()));}
pub fn release(_seat: *Seat) void {const _proxy: *client.wl.Proxy = @ptrCast(_seat);_proxy.marshal(3, null);_proxy.destroy();}
pub fn destroy(_seat: *Seat) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_seat);
    _proxy.destroy();
}};
pub const Pointer = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.pointer.getInterface;pub const Error = common.wl.pointer.Error;
pub const ButtonState = common.wl.pointer.ButtonState;
pub const Axis = common.wl.pointer.Axis;
pub const AxisSource = common.wl.pointer.AxisSource;
pub const AxisRelativeDirection = common.wl.pointer.AxisRelativeDirection;
pub fn setQueue(_pointer: *Pointer, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_pointer);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {enter: struct {serial:u32,surface:?*client.wl.Surface,surface_x:common.Fixed,surface_y:common.Fixed,},
leave: struct {serial:u32,surface:?*client.wl.Surface,},
motion: struct {time:u32,surface_x:common.Fixed,surface_y:common.Fixed,},
button: struct {serial:u32,time:u32,button:u32,state:ButtonState,},
axis: struct {time:u32,axis:Axis,value:common.Fixed,},
frame: void,axis_source: struct {axis_source:AxisSource,},
axis_stop: struct {time:u32,axis:Axis,},
axis_discrete: struct {axis:Axis,discrete:i32,},
};
pub inline fn setListener(
    _pointer: *Pointer,
    comptime T: type,
    _listener: *const fn (pointer: *Pointer, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_pointer);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Pointer, T).dispatcher, _listener, _mut_data);
}pub fn setCursor(_pointer: *Pointer, _serial:u32, _surface:?*client.wl.Surface, _hotspot_x:i32, _hotspot_y:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_pointer);var _args = [_]common.Argument{.{ .u = _serial},.{ .o = @ptrCast(_surface) },.{ .i = _hotspot_x},.{ .i = _hotspot_y},};
_proxy.marshal(0, &_args);}
pub fn release(_pointer: *Pointer) void {const _proxy: *client.wl.Proxy = @ptrCast(_pointer);_proxy.marshal(1, null);_proxy.destroy();}
pub fn destroy(_pointer: *Pointer) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_pointer);
    _proxy.destroy();
}};
pub const Keyboard = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.keyboard.getInterface;pub const KeymapFormat = common.wl.keyboard.KeymapFormat;
pub const KeyState = common.wl.keyboard.KeyState;
pub fn setQueue(_keyboard: *Keyboard, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_keyboard);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {keymap: struct {format:KeymapFormat,fd:i32,size:u32,},
enter: struct {serial:u32,surface:?*client.wl.Surface,keys:*common.Array,},
leave: struct {serial:u32,surface:?*client.wl.Surface,},
key: struct {serial:u32,time:u32,key:u32,state:KeyState,},
modifiers: struct {serial:u32,mods_depressed:u32,mods_latched:u32,mods_locked:u32,group:u32,},
repeat_info: struct {rate:i32,delay:i32,},
};
pub inline fn setListener(
    _keyboard: *Keyboard,
    comptime T: type,
    _listener: *const fn (keyboard: *Keyboard, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_keyboard);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Keyboard, T).dispatcher, _listener, _mut_data);
}pub fn release(_keyboard: *Keyboard) void {const _proxy: *client.wl.Proxy = @ptrCast(_keyboard);_proxy.marshal(0, null);_proxy.destroy();}
pub fn destroy(_keyboard: *Keyboard) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_keyboard);
    _proxy.destroy();
}};
pub const Touch = opaque {
 pub const generated_version = 7;
 pub const getInterface = common.wl.touch.getInterface;pub fn setQueue(_touch: *Touch, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_touch);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {down: struct {serial:u32,time:u32,surface:?*client.wl.Surface,id:i32,x:common.Fixed,y:common.Fixed,},
up: struct {serial:u32,time:u32,id:i32,},
motion: struct {time:u32,id:i32,x:common.Fixed,y:common.Fixed,},
frame: void,cancel: void,shape: struct {id:i32,major:common.Fixed,minor:common.Fixed,},
orientation: struct {id:i32,orientation:common.Fixed,},
};
pub inline fn setListener(
    _touch: *Touch,
    comptime T: type,
    _listener: *const fn (touch: *Touch, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_touch);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(Touch, T).dispatcher, _listener, _mut_data);
}pub fn release(_touch: *Touch) void {const _proxy: *client.wl.Proxy = @ptrCast(_touch);_proxy.marshal(0, null);_proxy.destroy();}
pub fn destroy(_touch: *Touch) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_touch);
    _proxy.destroy();
}};
pub const DataDeviceManager = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_device_manager.getInterface;pub const DndAction = common.wl.data_device_manager.DndAction;
pub fn setQueue(_data_device_manager: *DataDeviceManager, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_device_manager);
    _proxy.setQueue(_queue);
}pub fn createDataSource(_data_device_manager: *DataDeviceManager) !*client.wl.DataSource{const _proxy: *client.wl.Proxy = @ptrCast(_data_device_manager);var _args = [_]common.Argument{.{ .o = null },};
return @ptrCast(try _proxy.marshalConstructor(0, &_args, client.wl.DataSource.getInterface()));}
pub fn getDataDevice(_data_device_manager: *DataDeviceManager, _seat:*client.wl.Seat) !*client.wl.DataDevice{const _proxy: *client.wl.Proxy = @ptrCast(_data_device_manager);var _args = [_]common.Argument{.{ .o = null },.{ .o = @ptrCast(_seat) },};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.wl.DataDevice.getInterface()));}
pub fn destroy(_data_device_manager: *DataDeviceManager) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_device_manager);
    _proxy.destroy();
}};
pub const DataSource = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_source.getInterface;pub const Error = common.wl.data_source.Error;
pub fn setQueue(_data_source: *DataSource, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_source);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {target: struct {mime_type:?[*:0]const u8,},
send: struct {mime_type:[*:0]const u8,fd:i32,},
cancelled: void,dnd_drop_performed: void,dnd_finished: void,action: struct {dnd_action:common.wl.data_device_manager.DndAction,},
};
pub inline fn setListener(
    _data_source: *DataSource,
    comptime T: type,
    _listener: *const fn (data_source: *DataSource, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_source);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(DataSource, T).dispatcher, _listener, _mut_data);
}pub fn offer(_data_source: *DataSource, _mime_type:[*:0]const u8) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_source);var _args = [_]common.Argument{.{ .s = _mime_type},};
_proxy.marshal(0, &_args);}
pub fn destroy(_data_source: *DataSource) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_source);_proxy.marshal(1, null);_proxy.destroy();}
pub fn setActions(_data_source: *DataSource, _dnd_actions:common.wl.data_device_manager.DndAction) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_source);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(common.wl.data_device_manager.DndAction )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_dnd_actions))),
    .Struct => @bitCast(_dnd_actions),
    else => unreachable,
 }},};
_proxy.marshal(2, &_args);}
};
pub const DataDevice = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_device.getInterface;pub const Error = common.wl.data_device.Error;
pub fn setQueue(_data_device: *DataDevice, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_device);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {data_offer: struct {id: *client.wl.DataOffer,},
enter: struct {serial:u32,surface:?*client.wl.Surface,x:common.Fixed,y:common.Fixed,id:?*client.wl.DataOffer,},
leave: void,motion: struct {time:u32,x:common.Fixed,y:common.Fixed,},
drop: void,selection: struct {id:?*client.wl.DataOffer,},
};
pub inline fn setListener(
    _data_device: *DataDevice,
    comptime T: type,
    _listener: *const fn (data_device: *DataDevice, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_device);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(DataDevice, T).dispatcher, _listener, _mut_data);
}pub fn startDrag(_data_device: *DataDevice, _source:?*client.wl.DataSource, _origin:*client.wl.Surface, _icon:?*client.wl.Surface, _serial:u32) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_device);var _args = [_]common.Argument{.{ .o = @ptrCast(_source) },.{ .o = @ptrCast(_origin) },.{ .o = @ptrCast(_icon) },.{ .u = _serial},};
_proxy.marshal(0, &_args);}
pub fn setSelection(_data_device: *DataDevice, _source:?*client.wl.DataSource, _serial:u32) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_device);var _args = [_]common.Argument{.{ .o = @ptrCast(_source) },.{ .u = _serial},};
_proxy.marshal(1, &_args);}
pub fn release(_data_device: *DataDevice) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_device);_proxy.marshal(2, null);_proxy.destroy();}
pub fn destroy(_data_device: *DataDevice) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_device);
    _proxy.destroy();
}};
pub const DataOffer = opaque {
 pub const generated_version = 3;
 pub const getInterface = common.wl.data_offer.getInterface;pub const Error = common.wl.data_offer.Error;
pub fn setQueue(_data_offer: *DataOffer, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {offer: struct {mime_type:[*:0]const u8,},
source_actions: struct {source_actions:common.wl.data_device_manager.DndAction,},
action: struct {dnd_action:common.wl.data_device_manager.DndAction,},
};
pub inline fn setListener(
    _data_offer: *DataOffer,
    comptime T: type,
    _listener: *const fn (data_offer: *DataOffer, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(DataOffer, T).dispatcher, _listener, _mut_data);
}pub fn accept(_data_offer: *DataOffer, _serial:u32, _mime_type:?[*:0]const u8) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);var _args = [_]common.Argument{.{ .u = _serial},.{ .s = _mime_type},};
_proxy.marshal(0, &_args);}
pub fn receive(_data_offer: *DataOffer, _mime_type:[*:0]const u8, _fd:i32) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);var _args = [_]common.Argument{.{ .s = _mime_type},.{ .h = _fd},};
_proxy.marshal(1, &_args);}
pub fn destroy(_data_offer: *DataOffer) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);_proxy.marshal(2, null);_proxy.destroy();}
pub fn finish(_data_offer: *DataOffer) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);_proxy.marshal(3, null);}
pub fn setActions(_data_offer: *DataOffer, _dnd_actions:common.wl.data_device_manager.DndAction, _preferred_action:common.wl.data_device_manager.DndAction) void {const _proxy: *client.wl.Proxy = @ptrCast(_data_offer);var _args = [_]common.Argument{.{ .u = switch (@typeInfo(common.wl.data_device_manager.DndAction )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_dnd_actions))),
    .Struct => @bitCast(_dnd_actions),
    else => unreachable,
 }},.{ .u = switch (@typeInfo(common.wl.data_device_manager.DndAction )) {
    .Enum => @as(u32, @intCast(@intFromEnum(_preferred_action))),
    .Struct => @bitCast(_preferred_action),
    else => unreachable,
 }},};
_proxy.marshal(4, &_args);}
};
