// Generated by zig-wayland

// Copyright 2014 © Stephen "Lyude" Chandler Paul
// Copyright 2015-2016 © Red Hat, Inc.
// 
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation files
// (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge,
// publish, distribute, sublicense, and/or sell copies of the Software,
// and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
// 
// The above copyright notice and this permission notice (including the
// next paragraph) shall be included in all copies or substantial
// portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
// BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 

// This description provides a high-level overview of the interplay between
// the interfaces defined this protocol. For details, see the protocol
// specification.
// 
// More than one tablet may exist, and device-specifics matter. Tablets are
// not represented by a single virtual device like wl_pointer. A client
// binds to the tablet manager object which is just a proxy object. From
// that, the client requests wp_tablet_manager.get_tablet_seat(wl_seat)
// and that returns the actual interface that has all the tablets. With
// this indirection, we can avoid merging wp_tablet into the actual Wayland
// protocol, a long-term benefit.
// 
// The wp_tablet_seat sends a "tablet added" event for each tablet
// connected. That event is followed by descriptive events about the
// hardware; currently that includes events for name, vid/pid and
// a wp_tablet.path event that describes a local path. This path can be
// used to uniquely identify a tablet or get more information through
// libwacom. Emulated or nested tablets can skip any of those, e.g. a
// virtual tablet may not have a vid/pid. The sequence of descriptive
// events is terminated by a wp_tablet.done event to signal that a client
// may now finalize any initialization for that tablet.
// 
// Events from tablets require a tool in proximity. Tools are also managed
// by the tablet seat; a "tool added" event is sent whenever a tool is new
// to the compositor. That event is followed by a number of descriptive
// events about the hardware; currently that includes capabilities,
// hardware id and serial number, and tool type. Similar to the tablet
// interface, a wp_tablet_tool.done event is sent to terminate that initial
// sequence.
// 
// Any event from a tool happens on the wp_tablet_tool interface. When the
// tool gets into proximity of the tablet, a proximity_in event is sent on
// the wp_tablet_tool interface, listing the tablet and the surface. That
// event is followed by a motion event with the coordinates. After that,
// it's the usual motion, axis, button, etc. events. The protocol's
// serialisation means events are grouped by wp_tablet_tool.frame events.
// 
// Two special events (that don't exist in X) are down and up. They signal
// "tip touching the surface". For tablets without real proximity
// detection, the sequence is: proximity_in, motion, down, frame.
// 
// When the tool leaves proximity, a proximity_out event is sent. If any
// button is still down, a button release event is sent before this
// proximity event. These button events are sent in the same frame as the
// proximity event to signal to the client that the buttons were held when
// the tool left proximity.
// 
// If the tool moves out of the surface but stays in proximity (i.e.
// between windows), compositor-specific grab policies apply. This usually
// means that the proximity-out is delayed until all buttons are released.
// 
// Moving a tool physically from one tablet to the other has no real effect
// on the protocol, since we already have the tool object from the "tool
// added" event. All the information is already there and the proximity
// events on both tablets are all a client needs to reconstruct what
// happened.
// 
// Some extra axes are normalized, i.e. the client knows the range as
// specified in the protocol (e.g. [0, 65535]), the granularity however is
// unknown. The current normalized axes are pressure, distance, and slider.
// 
// Other extra axes are in physical units as specified in the protocol.
// The current extra axes with physical units are tilt, rotation and
// wheel rotation.
// 
// Since tablets work independently of the pointer controlled by the mouse,
// the focus handling is independent too and controlled by proximity.
// The wp_tablet_tool.set_cursor request sets a tool-specific cursor.
// This cursor surface may be the same as the mouse cursor, and it may be
// the same across tools but it is possible to be more fine-grained. For
// example, a client may set different cursors for the pen and eraser.
// 
// Tools are generally independent of tablets and it is
// compositor-specific policy when a tool can be removed. Common approaches
// will likely include some form of removing a tool when all tablets the
// tool was used on are removed.
// 
// Warning! The protocol described in this file is experimental and
// backward incompatible changes may be made. Backward compatible changes
// may be added together with the corresponding interface version bump.
// Backward incompatible changes are done by bumping the version number in
// the protocol and interface names and resetting the interface version.
// Once the protocol is to be declared stable, the 'z' prefix and the
// version number in the protocol and interface names are removed and the
// interface version number is reset.
// 

const common = @import("common.zig");pub const tablet_manager_v2 = struct {
 extern const zwp_tablet_manager_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_manager_v2_interface;
 }};pub const tablet_seat_v2 = struct {
 extern const zwp_tablet_seat_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_seat_v2_interface;
 }};pub const tablet_v2 = struct {
 extern const zwp_tablet_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_v2_interface;
 }};pub const tablet_tool_v2 = struct {
 extern const zwp_tablet_tool_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_tool_v2_interface;
 }pub const Type = enum(c_int) {pen= 0x140,eraser= 0x141,brush= 0x142,pencil= 0x143,airbrush= 0x144,finger= 0x145,mouse= 0x146,lens= 0x147,_,};
pub const Capability = enum(c_int) {tilt= 1,pressure= 2,distance= 3,rotation= 4,slider= 5,wheel= 6,_,};
pub const ButtonState = enum(c_int) {released= 0,pressed= 1,_,};
pub const Error = enum(c_int) {role= 0,_,};
};pub const tablet_pad_v2 = struct {
 extern const zwp_tablet_pad_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_pad_v2_interface;
 }pub const ButtonState = enum(c_int) {released= 0,pressed= 1,_,};
};pub const tablet_pad_group_v2 = struct {
 extern const zwp_tablet_pad_group_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_pad_group_v2_interface;
 }};pub const tablet_pad_ring_v2 = struct {
 extern const zwp_tablet_pad_ring_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_pad_ring_v2_interface;
 }pub const Source = enum(c_int) {finger= 1,_,};
};pub const tablet_pad_strip_v2 = struct {
 extern const zwp_tablet_pad_strip_v2_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_tablet_pad_strip_v2_interface;
 }pub const Source = enum(c_int) {finger= 1,_,};
};