// Generated by zig-wayland

// Copyright 2020-2021 The River Developers
// 
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
// 
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
// 

// This protocol specifies a way for clients to propose arbitrary positions
// and dimensions for a set of views on a specific output of a compositor
// through the river_layout_v3 object.
// 
// Layouts are a strictly linear list of views, the position and dimensions
// of which are supplied by the client. Any complex underlying data structure
// a client may use when generating the layout is lost in transmission. This
// is an intentional limitation.
// 
// Additionally, this protocol allows the compositor to deliver arbitrary
// user-provided commands associated with a layout to clients. A client
// may use these commands to implement runtime configuration/control, or
// may ignore them entirely. How the user provides these commands to the
// compositor is not specified by this protocol and left to compositor policy.
// 
// Warning! The protocol described in this file is currently in the
// testing phase. Backward compatible changes may be added together with
// the corresponding interface version bump. Backward incompatible changes
// can only be done by creating a new major version of the extension.
// 

const os = @import("std").os;
const server = @import("wayland.zig").server;
const common = @import("common.zig");pub const LayoutManagerV3 = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.river.layout_manager_v3.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*LayoutManagerV3 {
    return @ptrCast(try server.wl.Resource.create(_client, LayoutManagerV3, _version, _id));
}pub fn destroy(_layout_manager_v3: *LayoutManagerV3) void {
    return @as(*server.wl.Resource, @ptrCast(_layout_manager_v3)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *LayoutManagerV3 {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_layout_manager_v3: *LayoutManagerV3) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_layout_manager_v3)).getLink();
}pub fn getClient(_layout_manager_v3: *LayoutManagerV3) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_layout_manager_v3)).getClient();
}pub fn getId(_layout_manager_v3: *LayoutManagerV3) u32 {
    return @as(*server.wl.Resource, @ptrCast(_layout_manager_v3)).getId();
}pub fn getVersion(_layout_manager_v3: *LayoutManagerV3) u32 {
    return @as(*server.wl.Resource, @ptrCast(_layout_manager_v3)).getVersion();
}pub fn postNoMemory(_layout_manager_v3: *LayoutManagerV3) void {
    return @as(*server.wl.Resource, @ptrCast(_layout_manager_v3)).postNoMemory();
}pub const Request = union(enum) {destroy: void,get_layout: struct {id:u32,output:*server.wl.Output,namespace:[*:0]const u8,},
};
pub inline fn setHandler(
    _layout_manager_v3: *LayoutManagerV3,
    comptime T: type,
    handle_request: *const fn (_layout_manager_v3: *LayoutManagerV3, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_layout_manager_v3: *LayoutManagerV3, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_layout_manager_v3);
    _resource.setDispatcher(
        common.Dispatcher(LayoutManagerV3, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*LayoutManagerV3, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const LayoutV3 = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.river.layout_v3.getInterface;pub const Error = common.river.layout_v3.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*LayoutV3 {
    return @ptrCast(try server.wl.Resource.create(_client, LayoutV3, _version, _id));
}pub fn destroy(_layout_v3: *LayoutV3) void {
    return @as(*server.wl.Resource, @ptrCast(_layout_v3)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *LayoutV3 {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_layout_v3: *LayoutV3) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_layout_v3)).getLink();
}pub fn getClient(_layout_v3: *LayoutV3) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_layout_v3)).getClient();
}pub fn getId(_layout_v3: *LayoutV3) u32 {
    return @as(*server.wl.Resource, @ptrCast(_layout_v3)).getId();
}pub fn getVersion(_layout_v3: *LayoutV3) u32 {
    return @as(*server.wl.Resource, @ptrCast(_layout_v3)).getVersion();
}pub fn postNoMemory(_layout_v3: *LayoutV3) void {
    return @as(*server.wl.Resource, @ptrCast(_layout_v3)).postNoMemory();
}pub fn postError(layout_v3: *LayoutV3, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(layout_v3)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,push_view_dimensions: struct {x:i32,y:i32,width:u32,height:u32,serial:u32,},
commit: struct {layout_name:[*:0]const u8,serial:u32,},
};
pub inline fn setHandler(
    _layout_v3: *LayoutV3,
    comptime T: type,
    handle_request: *const fn (_layout_v3: *LayoutV3, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_layout_v3: *LayoutV3, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_layout_v3);
    _resource.setDispatcher(
        common.Dispatcher(LayoutV3, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*LayoutV3, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendNamespaceInUse(_layout_v3: *LayoutV3) void {const _resource: *server.wl.Resource = @ptrCast(_layout_v3);_resource.postEvent(0, null);}
pub fn sendLayoutDemand(_layout_v3: *LayoutV3, _view_count:u32, _usable_width:u32, _usable_height:u32, _tags:u32, _serial:u32) void {const _resource: *server.wl.Resource = @ptrCast(_layout_v3);var _args = [_]common.Argument{.{ .u = _view_count},.{ .u = _usable_width},.{ .u = _usable_height},.{ .u = _tags},.{ .u = _serial},};
_resource.postEvent(1, &_args);}
pub fn sendUserCommand(_layout_v3: *LayoutV3, _command:[*:0]const u8) void {const _resource: *server.wl.Resource = @ptrCast(_layout_v3);var _args = [_]common.Argument{.{ .s = _command},};
_resource.postEvent(2, &_args);}
pub fn sendUserCommandTags(_layout_v3: *LayoutV3, _tags:u32) void {const _resource: *server.wl.Resource = @ptrCast(_layout_v3);var _args = [_]common.Argument{.{ .u = _tags},};
_resource.postEvent(3, &_args);}
};
