// Generated by zig-wayland

// Copyright 2020-2021 The River Developers
// 
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
// 
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
// 

// This protocol specifies a way for clients to propose arbitrary positions
// and dimensions for a set of views on a specific output of a compositor
// through the river_layout_v3 object.
// 
// Layouts are a strictly linear list of views, the position and dimensions
// of which are supplied by the client. Any complex underlying data structure
// a client may use when generating the layout is lost in transmission. This
// is an intentional limitation.
// 
// Additionally, this protocol allows the compositor to deliver arbitrary
// user-provided commands associated with a layout to clients. A client
// may use these commands to implement runtime configuration/control, or
// may ignore them entirely. How the user provides these commands to the
// compositor is not specified by this protocol and left to compositor policy.
// 
// Warning! The protocol described in this file is currently in the
// testing phase. Backward compatible changes may be added together with
// the corresponding interface version bump. Backward incompatible changes
// can only be done by creating a new major version of the extension.
// 

const std = @import("std");
const os = std.os;
const client = @import("wayland.zig").client;
const common = @import("common.zig");pub const LayoutManagerV3 = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.river.layout_manager_v3.getInterface;pub fn setQueue(_layout_manager_v3: *LayoutManagerV3, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_layout_manager_v3);
    _proxy.setQueue(_queue);
}pub fn destroy(_layout_manager_v3: *LayoutManagerV3) void {const _proxy: *client.wl.Proxy = @ptrCast(_layout_manager_v3);_proxy.marshal(0, null);_proxy.destroy();}
pub fn getLayout(_layout_manager_v3: *LayoutManagerV3, _output:*client.wl.Output, _namespace:[*:0]const u8) !*client.river.LayoutV3{const _proxy: *client.wl.Proxy = @ptrCast(_layout_manager_v3);var _args = [_]common.Argument{.{ .o = null },.{ .o = @ptrCast(_output) },.{ .s = _namespace},};
return @ptrCast(try _proxy.marshalConstructor(1, &_args, client.river.LayoutV3.getInterface()));}
};
pub const LayoutV3 = opaque {
 pub const generated_version = 2;
 pub const getInterface = common.river.layout_v3.getInterface;pub const Error = common.river.layout_v3.Error;
pub fn setQueue(_layout_v3: *LayoutV3, _queue: *client.wl.EventQueue) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_layout_v3);
    _proxy.setQueue(_queue);
}pub const Event = union(enum) {namespace_in_use: void,layout_demand: struct {view_count:u32,usable_width:u32,usable_height:u32,tags:u32,serial:u32,},
user_command: struct {command:[*:0]const u8,},
user_command_tags: struct {tags:u32,},
};
pub inline fn setListener(
    _layout_v3: *LayoutV3,
    comptime T: type,
    _listener: *const fn (layout_v3: *LayoutV3, event: Event, data: T) void,
    _data: T,
) void {
    const _proxy: *client.wl.Proxy = @ptrCast(_layout_v3);
    const _mut_data: ?*anyopaque = @ptrFromInt(@intFromPtr(_data));
    _proxy.addDispatcher(common.Dispatcher(LayoutV3, T).dispatcher, _listener, _mut_data);
}pub fn destroy(_layout_v3: *LayoutV3) void {const _proxy: *client.wl.Proxy = @ptrCast(_layout_v3);_proxy.marshal(0, null);_proxy.destroy();}
pub fn pushViewDimensions(_layout_v3: *LayoutV3, _x:i32, _y:i32, _width:u32, _height:u32, _serial:u32) void {const _proxy: *client.wl.Proxy = @ptrCast(_layout_v3);var _args = [_]common.Argument{.{ .i = _x},.{ .i = _y},.{ .u = _width},.{ .u = _height},.{ .u = _serial},};
_proxy.marshal(1, &_args);}
pub fn commit(_layout_v3: *LayoutV3, _layout_name:[*:0]const u8, _serial:u32) void {const _proxy: *client.wl.Proxy = @ptrCast(_layout_v3);var _args = [_]common.Argument{.{ .s = _layout_name},.{ .u = _serial},};
_proxy.marshal(2, &_args);}
};
