// Generated by zig-wayland

// Copyright © 2014      Jonas Ådahl
// Copyright © 2015      Red Hat Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice (including the next
// paragraph) shall be included in all copies or substantial portions of the
// Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
// 

// This protocol specifies a set of interfaces used for adding constraints to
// the motion of a pointer. Possible constraints include confining pointer
// motions to a given region, or locking it to its current position.
// 
// In order to constrain the pointer, a client must first bind the global
// interface "wp_pointer_constraints" which, if a compositor supports pointer
// constraints, is exposed by the registry. Using the bound global object, the
// client uses the request that corresponds to the type of constraint it wants
// to make. See wp_pointer_constraints for more details.
// 
// Warning! The protocol described in this file is experimental and backward
// incompatible changes may be made. Backward compatible changes may be added
// together with the corresponding interface version bump. Backward
// incompatible changes are done by bumping the version number in the protocol
// and interface names and resetting the interface version. Once the protocol
// is to be declared stable, the 'z' prefix and the version number in the
// protocol and interface names are removed and the interface version number is
// reset.
// 

const common = @import("common.zig");pub const pointer_constraints_v1 = struct {
 extern const zwp_pointer_constraints_v1_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_pointer_constraints_v1_interface;
 }pub const Error = enum(c_int) {already_constrained= 1,_,};
pub const Lifetime = enum(c_int) {oneshot= 1,persistent= 2,_,};
};pub const locked_pointer_v1 = struct {
 extern const zwp_locked_pointer_v1_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_locked_pointer_v1_interface;
 }};pub const confined_pointer_v1 = struct {
 extern const zwp_confined_pointer_v1_interface: common.Interface;
 pub inline fn getInterface() *const common.Interface {
  return &zwp_confined_pointer_v1_interface;
 }};