// Generated by zig-wayland

// Copyright 2021 Isaac Freund
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 

// This protocol allows for a privileged Wayland client to lock the session
// and display arbitrary graphics while the session is locked.
// 
// The compositor may choose to restrict this protocol to a special client
// launched by the compositor itself or expose it to all privileged clients,
// this is compositor policy.
// 
// The client is responsible for performing authentication and informing the
// compositor when the session should be unlocked. If the client dies while
// the session is locked the session remains locked, possibly permanently
// depending on compositor policy.
// 
// The key words "must", "must not", "required", "shall", "shall not",
// "should", "should not", "recommended",  "may", and "optional" in this
// document are to be interpreted as described in IETF RFC 2119.
// 
// Warning! The protocol described in this file is currently in the
// testing phase. Backward compatible changes may be added together with
// the corresponding interface version bump. Backward incompatible changes
// can only be done by creating a new major version of the extension.
// 

const os = @import("std").os;
const server = @import("wayland.zig").server;
const common = @import("common.zig");pub const SessionLockManagerV1 = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.ext.session_lock_manager_v1.getInterface;pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*SessionLockManagerV1 {
    return @ptrCast(try server.wl.Resource.create(_client, SessionLockManagerV1, _version, _id));
}pub fn destroy(_session_lock_manager_v1: *SessionLockManagerV1) void {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_manager_v1)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *SessionLockManagerV1 {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_session_lock_manager_v1: *SessionLockManagerV1) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_manager_v1)).getLink();
}pub fn getClient(_session_lock_manager_v1: *SessionLockManagerV1) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_manager_v1)).getClient();
}pub fn getId(_session_lock_manager_v1: *SessionLockManagerV1) u32 {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_manager_v1)).getId();
}pub fn getVersion(_session_lock_manager_v1: *SessionLockManagerV1) u32 {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_manager_v1)).getVersion();
}pub fn postNoMemory(_session_lock_manager_v1: *SessionLockManagerV1) void {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_manager_v1)).postNoMemory();
}pub const Request = union(enum) {destroy: void,lock: struct {id:u32,},
};
pub inline fn setHandler(
    _session_lock_manager_v1: *SessionLockManagerV1,
    comptime T: type,
    handle_request: *const fn (_session_lock_manager_v1: *SessionLockManagerV1, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_session_lock_manager_v1: *SessionLockManagerV1, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_session_lock_manager_v1);
    _resource.setDispatcher(
        common.Dispatcher(SessionLockManagerV1, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*SessionLockManagerV1, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}};
pub const SessionLockV1 = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.ext.session_lock_v1.getInterface;pub const Error = common.ext.session_lock_v1.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*SessionLockV1 {
    return @ptrCast(try server.wl.Resource.create(_client, SessionLockV1, _version, _id));
}pub fn destroy(_session_lock_v1: *SessionLockV1) void {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_v1)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *SessionLockV1 {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_session_lock_v1: *SessionLockV1) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_v1)).getLink();
}pub fn getClient(_session_lock_v1: *SessionLockV1) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_v1)).getClient();
}pub fn getId(_session_lock_v1: *SessionLockV1) u32 {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_v1)).getId();
}pub fn getVersion(_session_lock_v1: *SessionLockV1) u32 {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_v1)).getVersion();
}pub fn postNoMemory(_session_lock_v1: *SessionLockV1) void {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_v1)).postNoMemory();
}pub fn postError(session_lock_v1: *SessionLockV1, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(session_lock_v1)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,get_lock_surface: struct {id:u32,surface:*server.wl.Surface,output:*server.wl.Output,},
unlock_and_destroy: void,};
pub inline fn setHandler(
    _session_lock_v1: *SessionLockV1,
    comptime T: type,
    handle_request: *const fn (_session_lock_v1: *SessionLockV1, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_session_lock_v1: *SessionLockV1, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_session_lock_v1);
    _resource.setDispatcher(
        common.Dispatcher(SessionLockV1, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*SessionLockV1, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendLocked(_session_lock_v1: *SessionLockV1) void {const _resource: *server.wl.Resource = @ptrCast(_session_lock_v1);_resource.postEvent(0, null);}
pub fn sendFinished(_session_lock_v1: *SessionLockV1) void {const _resource: *server.wl.Resource = @ptrCast(_session_lock_v1);_resource.postEvent(1, null);}
};
pub const SessionLockSurfaceV1 = opaque {
 pub const generated_version = 1;
 pub const getInterface = common.ext.session_lock_surface_v1.getInterface;pub const Error = common.ext.session_lock_surface_v1.Error;
pub fn create(_client: *server.wl.Client, _version: u32, _id: u32) !*SessionLockSurfaceV1 {
    return @ptrCast(try server.wl.Resource.create(_client, SessionLockSurfaceV1, _version, _id));
}pub fn destroy(_session_lock_surface_v1: *SessionLockSurfaceV1) void {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_surface_v1)).destroy();
}pub fn fromLink(_link: *server.wl.list.Link) *SessionLockSurfaceV1 {
    return @ptrCast(server.wl.Resource.fromLink(_link));
}pub fn getLink(_session_lock_surface_v1: *SessionLockSurfaceV1) *server.wl.list.Link {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_surface_v1)).getLink();
}pub fn getClient(_session_lock_surface_v1: *SessionLockSurfaceV1) *server.wl.Client {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_surface_v1)).getClient();
}pub fn getId(_session_lock_surface_v1: *SessionLockSurfaceV1) u32 {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_surface_v1)).getId();
}pub fn getVersion(_session_lock_surface_v1: *SessionLockSurfaceV1) u32 {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_surface_v1)).getVersion();
}pub fn postNoMemory(_session_lock_surface_v1: *SessionLockSurfaceV1) void {
    return @as(*server.wl.Resource, @ptrCast(_session_lock_surface_v1)).postNoMemory();
}pub fn postError(session_lock_surface_v1: *SessionLockSurfaceV1, _err: Error, _message: [*:0]const u8) void {
    return @as(*server.wl.Resource, @ptrCast(session_lock_surface_v1)).postError(@intCast(@intFromEnum(_err)), _message);
}pub const Request = union(enum) {destroy: void,ack_configure: struct {serial:u32,},
};
pub inline fn setHandler(
    _session_lock_surface_v1: *SessionLockSurfaceV1,
    comptime T: type,
    handle_request: *const fn (_session_lock_surface_v1: *SessionLockSurfaceV1, request: Request, data: T) void,
    comptime handle_destroy: ?fn (_session_lock_surface_v1: *SessionLockSurfaceV1, data: T) void,
    _data: T,
) void {
    const _resource: *server.wl.Resource = @ptrCast(_session_lock_surface_v1);
    _resource.setDispatcher(
        common.Dispatcher(SessionLockSurfaceV1, T).dispatcher,
        handle_request,
        @ptrFromInt(@intFromPtr(_data)),
        if (handle_destroy) |_handler| struct {
            fn _wrapper(__resource: *server.wl.Resource) callconv(.C) void {
                @call(.always_inline, _handler, .{
                    @as(*SessionLockSurfaceV1, @ptrCast(__resource)),
                    @as(T, @ptrCast(@alignCast(__resource.getUserData()))),
                });
            }
        }._wrapper else null,
    );
}pub fn sendConfigure(_session_lock_surface_v1: *SessionLockSurfaceV1, _serial:u32, _width:u32, _height:u32) void {const _resource: *server.wl.Resource = @ptrCast(_session_lock_surface_v1);var _args = [_]common.Argument{.{ .u = _serial},.{ .u = _width},.{ .u = _height},};
_resource.postEvent(0, &_args);}
};
