/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ipc-runner-private.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Retro.Runner
 * ------------------------------------------------------------------------
 */

/**
 * PRIVATE:IpcRunner
 * @title: IpcRunner
 * @short_description: Generated C code for the org.gnome.Retro.Runner D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Retro.Runner ---- */

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_get_properties_OUT_ARG_game_loaded =
{
  {
    -1,
    (gchar *) "game_loaded",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_get_properties_OUT_ARG_fps =
{
  {
    -1,
    (gchar *) "fps",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_get_properties_OUT_ARG_support_no_game =
{
  {
    -1,
    (gchar *) "support_no_game",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_ipc_runner_method_info_get_properties_OUT_ARG_game_loaded.parent_struct,
  &_ipc_runner_method_info_get_properties_OUT_ARG_fps.parent_struct,
  &_ipc_runner_method_info_get_properties_OUT_ARG_support_no_game.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_ipc_runner_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_boot_IN_ARG_defaults =
{
  {
    -1,
    (gchar *) "defaults",
    (gchar *) "a(ss)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_boot_IN_ARG_medias =
{
  {
    -1,
    (gchar *) "medias",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_boot_IN_ARG_default_controller =
{
  {
    -1,
    (gchar *) "default_controller",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_boot_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_boot_IN_ARG_defaults.parent_struct,
  &_ipc_runner_method_info_boot_IN_ARG_medias.parent_struct,
  &_ipc_runner_method_info_boot_IN_ARG_default_controller.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_boot_OUT_ARG_variables =
{
  {
    -1,
    (gchar *) "variables",
    (gchar *) "a(ss)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_boot_OUT_ARG_framebuffer =
{
  {
    -1,
    (gchar *) "framebuffer",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_boot_OUT_ARG_pointers[] =
{
  &_ipc_runner_method_info_boot_OUT_ARG_variables.parent_struct,
  &_ipc_runner_method_info_boot_OUT_ARG_framebuffer.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_boot =
{
  {
    -1,
    (gchar *) "Boot",
    (GDBusArgInfo **) &_ipc_runner_method_info_boot_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_runner_method_info_boot_OUT_ARG_pointers,
    NULL
  },
  "handle-boot",
  TRUE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_set_current_media_IN_ARG_index =
{
  {
    -1,
    (gchar *) "index",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_set_current_media_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_set_current_media_IN_ARG_index.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_set_current_media =
{
  {
    -1,
    (gchar *) "SetCurrentMedia",
    (GDBusArgInfo **) &_ipc_runner_method_info_set_current_media_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-current-media",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_run =
{
  {
    -1,
    (gchar *) "Run",
    NULL,
    NULL,
    NULL
  },
  "handle-run",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_reset =
{
  {
    -1,
    (gchar *) "Reset",
    NULL,
    NULL,
    NULL
  },
  "handle-reset",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_iteration =
{
  {
    -1,
    (gchar *) "Iteration",
    NULL,
    NULL,
    NULL
  },
  "handle-iteration",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_get_can_access_state_OUT_ARG_can_access_state =
{
  {
    -1,
    (gchar *) "can_access_state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_get_can_access_state_OUT_ARG_pointers[] =
{
  &_ipc_runner_method_info_get_can_access_state_OUT_ARG_can_access_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_get_can_access_state =
{
  {
    -1,
    (gchar *) "GetCanAccessState",
    NULL,
    (GDBusArgInfo **) &_ipc_runner_method_info_get_can_access_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-can-access-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_save_state_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_save_state_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_save_state_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_save_state =
{
  {
    -1,
    (gchar *) "SaveState",
    (GDBusArgInfo **) &_ipc_runner_method_info_save_state_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-save-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_load_state_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_load_state_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_load_state_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_load_state =
{
  {
    -1,
    (gchar *) "LoadState",
    (GDBusArgInfo **) &_ipc_runner_method_info_load_state_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-load-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_get_memory_size_IN_ARG_memory_type =
{
  {
    -1,
    (gchar *) "memory_type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_get_memory_size_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_get_memory_size_IN_ARG_memory_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_get_memory_size_OUT_ARG_size =
{
  {
    -1,
    (gchar *) "size",
    (gchar *) "t",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_get_memory_size_OUT_ARG_pointers[] =
{
  &_ipc_runner_method_info_get_memory_size_OUT_ARG_size.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_get_memory_size =
{
  {
    -1,
    (gchar *) "GetMemorySize",
    (GDBusArgInfo **) &_ipc_runner_method_info_get_memory_size_IN_ARG_pointers,
    (GDBusArgInfo **) &_ipc_runner_method_info_get_memory_size_OUT_ARG_pointers,
    NULL
  },
  "handle-get-memory-size",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_save_memory_IN_ARG_memory_type =
{
  {
    -1,
    (gchar *) "memory_type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_save_memory_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_save_memory_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_save_memory_IN_ARG_memory_type.parent_struct,
  &_ipc_runner_method_info_save_memory_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_save_memory =
{
  {
    -1,
    (gchar *) "SaveMemory",
    (GDBusArgInfo **) &_ipc_runner_method_info_save_memory_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-save-memory",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_load_memory_IN_ARG_memory_type =
{
  {
    -1,
    (gchar *) "memory_type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_load_memory_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_load_memory_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_load_memory_IN_ARG_memory_type.parent_struct,
  &_ipc_runner_method_info_load_memory_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_load_memory =
{
  {
    -1,
    (gchar *) "LoadMemory",
    (GDBusArgInfo **) &_ipc_runner_method_info_load_memory_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-load-memory",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_update_variable_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_update_variable_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_update_variable_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_update_variable_IN_ARG_key.parent_struct,
  &_ipc_runner_method_info_update_variable_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_update_variable =
{
  {
    -1,
    (gchar *) "UpdateVariable",
    (GDBusArgInfo **) &_ipc_runner_method_info_update_variable_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-variable",
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_set_controller_IN_ARG_port =
{
  {
    -1,
    (gchar *) "port",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_set_controller_IN_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_set_controller_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_set_controller_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_set_controller_IN_ARG_port.parent_struct,
  &_ipc_runner_method_info_set_controller_IN_ARG_type.parent_struct,
  &_ipc_runner_method_info_set_controller_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_set_controller =
{
  {
    -1,
    (gchar *) "SetController",
    (GDBusArgInfo **) &_ipc_runner_method_info_set_controller_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-controller",
  TRUE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_key_event_IN_ARG_pressed =
{
  {
    -1,
    (gchar *) "pressed",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_key_event_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_key_event_IN_ARG_character =
{
  {
    -1,
    (gchar *) "character",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_method_info_key_event_IN_ARG_modifiers =
{
  {
    -1,
    (gchar *) "modifiers",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_method_info_key_event_IN_ARG_pointers[] =
{
  &_ipc_runner_method_info_key_event_IN_ARG_pressed.parent_struct,
  &_ipc_runner_method_info_key_event_IN_ARG_keycode.parent_struct,
  &_ipc_runner_method_info_key_event_IN_ARG_character.parent_struct,
  &_ipc_runner_method_info_key_event_IN_ARG_modifiers.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ipc_runner_method_info_key_event =
{
  {
    -1,
    (gchar *) "KeyEvent",
    (GDBusArgInfo **) &_ipc_runner_method_info_key_event_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-key-event",
  FALSE
};

static const GDBusMethodInfo * const _ipc_runner_method_info_pointers[] =
{
  &_ipc_runner_method_info_get_properties.parent_struct,
  &_ipc_runner_method_info_boot.parent_struct,
  &_ipc_runner_method_info_set_current_media.parent_struct,
  &_ipc_runner_method_info_run.parent_struct,
  &_ipc_runner_method_info_stop.parent_struct,
  &_ipc_runner_method_info_reset.parent_struct,
  &_ipc_runner_method_info_iteration.parent_struct,
  &_ipc_runner_method_info_get_can_access_state.parent_struct,
  &_ipc_runner_method_info_save_state.parent_struct,
  &_ipc_runner_method_info_load_state.parent_struct,
  &_ipc_runner_method_info_get_memory_size.parent_struct,
  &_ipc_runner_method_info_save_memory.parent_struct,
  &_ipc_runner_method_info_load_memory.parent_struct,
  &_ipc_runner_method_info_update_variable.parent_struct,
  &_ipc_runner_method_info_set_controller.parent_struct,
  &_ipc_runner_method_info_key_event.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_variables_set_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "a(ss)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_signal_info_variables_set_ARG_pointers[] =
{
  &_ipc_runner_signal_info_variables_set_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_runner_signal_info_variables_set =
{
  {
    -1,
    (gchar *) "VariablesSet",
    (GDBusArgInfo **) &_ipc_runner_signal_info_variables_set_ARG_pointers,
    NULL
  },
  "variables-set"
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_set_rumble_state_ARG_port =
{
  {
    -1,
    (gchar *) "port",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_set_rumble_state_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_set_rumble_state_ARG_strength =
{
  {
    -1,
    (gchar *) "strength",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_signal_info_set_rumble_state_ARG_pointers[] =
{
  &_ipc_runner_signal_info_set_rumble_state_ARG_port.parent_struct,
  &_ipc_runner_signal_info_set_rumble_state_ARG_type.parent_struct,
  &_ipc_runner_signal_info_set_rumble_state_ARG_strength.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_runner_signal_info_set_rumble_state =
{
  {
    -1,
    (gchar *) "SetRumbleState",
    (GDBusArgInfo **) &_ipc_runner_signal_info_set_rumble_state_ARG_pointers,
    NULL
  },
  "set-rumble-state"
};

static const _ExtendedGDBusSignalInfo _ipc_runner_signal_info_video_output =
{
  {
    -1,
    (gchar *) "VideoOutput",
    NULL,
    NULL
  },
  "video-output"
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_log_ARG_domain =
{
  {
    -1,
    (gchar *) "domain",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_log_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_log_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_signal_info_log_ARG_pointers[] =
{
  &_ipc_runner_signal_info_log_ARG_domain.parent_struct,
  &_ipc_runner_signal_info_log_ARG_level.parent_struct,
  &_ipc_runner_signal_info_log_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_runner_signal_info_log =
{
  {
    -1,
    (gchar *) "Log",
    (GDBusArgInfo **) &_ipc_runner_signal_info_log_ARG_pointers,
    NULL
  },
  "log"
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_message_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ipc_runner_signal_info_message_ARG_frames =
{
  {
    -1,
    (gchar *) "frames",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ipc_runner_signal_info_message_ARG_pointers[] =
{
  &_ipc_runner_signal_info_message_ARG_message.parent_struct,
  &_ipc_runner_signal_info_message_ARG_frames.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ipc_runner_signal_info_message =
{
  {
    -1,
    (gchar *) "Message",
    (GDBusArgInfo **) &_ipc_runner_signal_info_message_ARG_pointers,
    NULL
  },
  "message"
};

static const GDBusSignalInfo * const _ipc_runner_signal_info_pointers[] =
{
  &_ipc_runner_signal_info_variables_set.parent_struct,
  &_ipc_runner_signal_info_set_rumble_state.parent_struct,
  &_ipc_runner_signal_info_video_output.parent_struct,
  &_ipc_runner_signal_info_log.parent_struct,
  &_ipc_runner_signal_info_message.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_api_version =
{
  {
    -1,
    (gchar *) "ApiVersion",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "api-version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_system_directory =
{
  {
    -1,
    (gchar *) "SystemDirectory",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "system-directory",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_content_directory =
{
  {
    -1,
    (gchar *) "ContentDirectory",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "content-directory",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_save_directory =
{
  {
    -1,
    (gchar *) "SaveDirectory",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "save-directory",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_game_loaded =
{
  {
    -1,
    (gchar *) "GameLoaded",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "game-loaded",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_frames_per_second =
{
  {
    -1,
    (gchar *) "FramesPerSecond",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "frames-per-second",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_support_no_game =
{
  {
    -1,
    (gchar *) "SupportNoGame",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "support-no-game",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_speed_rate =
{
  {
    -1,
    (gchar *) "SpeedRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "speed-rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ipc_runner_property_info_runahead =
{
  {
    -1,
    (gchar *) "Runahead",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "runahead",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ipc_runner_property_info_pointers[] =
{
  &_ipc_runner_property_info_api_version.parent_struct,
  &_ipc_runner_property_info_system_directory.parent_struct,
  &_ipc_runner_property_info_content_directory.parent_struct,
  &_ipc_runner_property_info_save_directory.parent_struct,
  &_ipc_runner_property_info_game_loaded.parent_struct,
  &_ipc_runner_property_info_frames_per_second.parent_struct,
  &_ipc_runner_property_info_support_no_game.parent_struct,
  &_ipc_runner_property_info_speed_rate.parent_struct,
  &_ipc_runner_property_info_runahead.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ipc_runner_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Retro.Runner",
    (GDBusMethodInfo **) &_ipc_runner_method_info_pointers,
    (GDBusSignalInfo **) &_ipc_runner_signal_info_pointers,
    (GDBusPropertyInfo **) &_ipc_runner_property_info_pointers,
    NULL
  },
  "runner",
};


/**
 * ipc_runner_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ipc_runner_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ipc_runner_interface_info.parent_struct;
}

/**
 * ipc_runner_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #IpcRunner interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ipc_runner_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "api-version");
  g_object_class_override_property (klass, property_id_begin++, "system-directory");
  g_object_class_override_property (klass, property_id_begin++, "content-directory");
  g_object_class_override_property (klass, property_id_begin++, "save-directory");
  g_object_class_override_property (klass, property_id_begin++, "game-loaded");
  g_object_class_override_property (klass, property_id_begin++, "frames-per-second");
  g_object_class_override_property (klass, property_id_begin++, "support-no-game");
  g_object_class_override_property (klass, property_id_begin++, "speed-rate");
  g_object_class_override_property (klass, property_id_begin++, "runahead");
  return property_id_begin - 1;
}



/**
 * IpcRunner:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link>.
 */

/**
 * IpcRunnerIface:
 * @parent_iface: The parent interface.
 * @handle_boot: Handler for the #IpcRunner::handle-boot signal.
 * @handle_get_can_access_state: Handler for the #IpcRunner::handle-get-can-access-state signal.
 * @handle_get_memory_size: Handler for the #IpcRunner::handle-get-memory-size signal.
 * @handle_get_properties: Handler for the #IpcRunner::handle-get-properties signal.
 * @handle_iteration: Handler for the #IpcRunner::handle-iteration signal.
 * @handle_key_event: Handler for the #IpcRunner::handle-key-event signal.
 * @handle_load_memory: Handler for the #IpcRunner::handle-load-memory signal.
 * @handle_load_state: Handler for the #IpcRunner::handle-load-state signal.
 * @handle_reset: Handler for the #IpcRunner::handle-reset signal.
 * @handle_run: Handler for the #IpcRunner::handle-run signal.
 * @handle_save_memory: Handler for the #IpcRunner::handle-save-memory signal.
 * @handle_save_state: Handler for the #IpcRunner::handle-save-state signal.
 * @handle_set_controller: Handler for the #IpcRunner::handle-set-controller signal.
 * @handle_set_current_media: Handler for the #IpcRunner::handle-set-current-media signal.
 * @handle_stop: Handler for the #IpcRunner::handle-stop signal.
 * @handle_update_variable: Handler for the #IpcRunner::handle-update-variable signal.
 * @get_api_version: Getter for the #IpcRunner:api-version property.
 * @get_content_directory: Getter for the #IpcRunner:content-directory property.
 * @get_frames_per_second: Getter for the #IpcRunner:frames-per-second property.
 * @get_game_loaded: Getter for the #IpcRunner:game-loaded property.
 * @get_runahead: Getter for the #IpcRunner:runahead property.
 * @get_save_directory: Getter for the #IpcRunner:save-directory property.
 * @get_speed_rate: Getter for the #IpcRunner:speed-rate property.
 * @get_support_no_game: Getter for the #IpcRunner:support-no-game property.
 * @get_system_directory: Getter for the #IpcRunner:system-directory property.
 * @log: Handler for the #IpcRunner::log signal.
 * @message: Handler for the #IpcRunner::message signal.
 * @set_rumble_state: Handler for the #IpcRunner::set-rumble-state signal.
 * @variables_set: Handler for the #IpcRunner::variables-set signal.
 * @video_output: Handler for the #IpcRunner::video-output signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link>.
 */

typedef IpcRunnerIface IpcRunnerInterface;
G_DEFINE_INTERFACE (IpcRunner, ipc_runner, G_TYPE_OBJECT)

static void
ipc_runner_default_init (IpcRunnerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * IpcRunner::handle-get-properties:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcRunner::handle-boot:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_defaults: Argument passed by remote caller.
   * @arg_medias: Argument passed by remote caller.
   * @arg_default_controller: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.Boot">Boot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_boot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-boot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_boot),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_STRV, G_TYPE_VARIANT);

  /**
   * IpcRunner::handle-set-current-media:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_index: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetCurrentMedia">SetCurrentMedia()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_set_current_media() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-current-media",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_set_current_media),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * IpcRunner::handle-run:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.Run">Run()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_run() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-run",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_run),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcRunner::handle-stop:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcRunner::handle-reset:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.Reset">Reset()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_reset() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_reset),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcRunner::handle-iteration:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.Iteration">Iteration()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_iteration() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-iteration",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_iteration),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcRunner::handle-get-can-access-state:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetCanAccessState">GetCanAccessState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_get_can_access_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-can-access-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_get_can_access_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * IpcRunner::handle-save-state:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveState">SaveState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_save_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_save_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcRunner::handle-load-state:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadState">LoadState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_load_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_load_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * IpcRunner::handle-get-memory-size:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_memory_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetMemorySize">GetMemorySize()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_get_memory_size() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-memory-size",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_get_memory_size),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * IpcRunner::handle-save-memory:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_memory_type: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveMemory">SaveMemory()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_save_memory() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-memory",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_save_memory),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * IpcRunner::handle-load-memory:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_memory_type: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadMemory">LoadMemory()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_load_memory() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load-memory",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_load_memory),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * IpcRunner::handle-update-variable:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.UpdateVariable">UpdateVariable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_update_variable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-variable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_update_variable),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * IpcRunner::handle-set-controller:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_port: Argument passed by remote caller.
   * @arg_type: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetController">SetController()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_set_controller() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-controller",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_set_controller),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * IpcRunner::handle-key-event:
   * @object: A #IpcRunner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pressed: Argument passed by remote caller.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_character: Argument passed by remote caller.
   * @arg_modifiers: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Retro-Runner.KeyEvent">KeyEvent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ipc_runner_complete_key_event() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-key-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, handle_key_event),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * IpcRunner::variables-set:
   * @object: A #IpcRunner.
   * @arg_data: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Retro-Runner.VariablesSet">"VariablesSet"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("variables-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, variables_set),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * IpcRunner::set-rumble-state:
   * @object: A #IpcRunner.
   * @arg_port: Argument.
   * @arg_type: Argument.
   * @arg_strength: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Retro-Runner.SetRumbleState">"SetRumbleState"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("set-rumble-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, set_rumble_state),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * IpcRunner::video-output:
   * @object: A #IpcRunner.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Retro-Runner.VideoOutput">"VideoOutput"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("video-output",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, video_output),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /**
   * IpcRunner::log:
   * @object: A #IpcRunner.
   * @arg_domain: Argument.
   * @arg_level: Argument.
   * @arg_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Retro-Runner.Log">"Log"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("log",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, log),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * IpcRunner::message:
   * @object: A #IpcRunner.
   * @arg_message: Argument.
   * @arg_frames: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Retro-Runner.Message">"Message"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("message",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (IpcRunnerIface, message),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * IpcRunner:api-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.ApiVersion">"ApiVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("api-version", "ApiVersion", "ApiVersion", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:system-directory:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.SystemDirectory">"SystemDirectory"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("system-directory", "SystemDirectory", "SystemDirectory", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:content-directory:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.ContentDirectory">"ContentDirectory"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("content-directory", "ContentDirectory", "ContentDirectory", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:save-directory:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.SaveDirectory">"SaveDirectory"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("save-directory", "SaveDirectory", "SaveDirectory", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:game-loaded:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.GameLoaded">"GameLoaded"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("game-loaded", "GameLoaded", "GameLoaded", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:frames-per-second:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.FramesPerSecond">"FramesPerSecond"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("frames-per-second", "FramesPerSecond", "FramesPerSecond", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:support-no-game:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.SupportNoGame">"SupportNoGame"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("support-no-game", "SupportNoGame", "SupportNoGame", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:speed-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.SpeedRate">"SpeedRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("speed-rate", "SpeedRate", "SpeedRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * IpcRunner:runahead:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Retro-Runner.Runahead">"Runahead"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("runahead", "Runahead", "Runahead", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ipc_runner_get_api_version: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.ApiVersion">"ApiVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
ipc_runner_get_api_version (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), 0);

  return IPC_RUNNER_GET_IFACE (object)->get_api_version (object);
}

/**
 * ipc_runner_set_api_version: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.ApiVersion">"ApiVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_runner_set_api_version (IpcRunner *object, guint value)
{
  g_object_set (G_OBJECT (object), "api-version", value, NULL);
}

/**
 * ipc_runner_get_system_directory: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.SystemDirectory">"SystemDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_runner_dup_system_directory() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_runner_get_system_directory (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), NULL);

  return IPC_RUNNER_GET_IFACE (object)->get_system_directory (object);
}

/**
 * ipc_runner_dup_system_directory: (skip)
 * @object: A #IpcRunner.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Retro-Runner.SystemDirectory">"SystemDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_runner_dup_system_directory (IpcRunner *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "system-directory", &value, NULL);
  return value;
}

/**
 * ipc_runner_set_system_directory: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.SystemDirectory">"SystemDirectory"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ipc_runner_set_system_directory (IpcRunner *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "system-directory", value, NULL);
}

/**
 * ipc_runner_get_content_directory: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.ContentDirectory">"ContentDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_runner_dup_content_directory() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_runner_get_content_directory (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), NULL);

  return IPC_RUNNER_GET_IFACE (object)->get_content_directory (object);
}

/**
 * ipc_runner_dup_content_directory: (skip)
 * @object: A #IpcRunner.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Retro-Runner.ContentDirectory">"ContentDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_runner_dup_content_directory (IpcRunner *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "content-directory", &value, NULL);
  return value;
}

/**
 * ipc_runner_set_content_directory: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.ContentDirectory">"ContentDirectory"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ipc_runner_set_content_directory (IpcRunner *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "content-directory", value, NULL);
}

/**
 * ipc_runner_get_save_directory: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.SaveDirectory">"SaveDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ipc_runner_dup_save_directory() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ipc_runner_get_save_directory (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), NULL);

  return IPC_RUNNER_GET_IFACE (object)->get_save_directory (object);
}

/**
 * ipc_runner_dup_save_directory: (skip)
 * @object: A #IpcRunner.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Retro-Runner.SaveDirectory">"SaveDirectory"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ipc_runner_dup_save_directory (IpcRunner *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "save-directory", &value, NULL);
  return value;
}

/**
 * ipc_runner_set_save_directory: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.SaveDirectory">"SaveDirectory"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ipc_runner_set_save_directory (IpcRunner *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "save-directory", value, NULL);
}

/**
 * ipc_runner_get_game_loaded: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.GameLoaded">"GameLoaded"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ipc_runner_get_game_loaded (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), FALSE);

  return IPC_RUNNER_GET_IFACE (object)->get_game_loaded (object);
}

/**
 * ipc_runner_set_game_loaded: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.GameLoaded">"GameLoaded"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_runner_set_game_loaded (IpcRunner *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "game-loaded", value, NULL);
}

/**
 * ipc_runner_get_frames_per_second: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.FramesPerSecond">"FramesPerSecond"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
ipc_runner_get_frames_per_second (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), 0.0);

  return IPC_RUNNER_GET_IFACE (object)->get_frames_per_second (object);
}

/**
 * ipc_runner_set_frames_per_second: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.FramesPerSecond">"FramesPerSecond"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_runner_set_frames_per_second (IpcRunner *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "frames-per-second", value, NULL);
}

/**
 * ipc_runner_get_support_no_game: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.SupportNoGame">"SupportNoGame"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ipc_runner_get_support_no_game (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), FALSE);

  return IPC_RUNNER_GET_IFACE (object)->get_support_no_game (object);
}

/**
 * ipc_runner_set_support_no_game: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.SupportNoGame">"SupportNoGame"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ipc_runner_set_support_no_game (IpcRunner *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "support-no-game", value, NULL);
}

/**
 * ipc_runner_get_speed_rate: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.SpeedRate">"SpeedRate"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
ipc_runner_get_speed_rate (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), 0.0);

  return IPC_RUNNER_GET_IFACE (object)->get_speed_rate (object);
}

/**
 * ipc_runner_set_speed_rate: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.SpeedRate">"SpeedRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ipc_runner_set_speed_rate (IpcRunner *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "speed-rate", value, NULL);
}

/**
 * ipc_runner_get_runahead: (skip)
 * @object: A #IpcRunner.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Retro-Runner.Runahead">"Runahead"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
ipc_runner_get_runahead (IpcRunner *object)
{
  g_return_val_if_fail (IPC_IS_RUNNER (object), 0);

  return IPC_RUNNER_GET_IFACE (object)->get_runahead (object);
}

/**
 * ipc_runner_set_runahead: (skip)
 * @object: A #IpcRunner.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Retro-Runner.Runahead">"Runahead"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
ipc_runner_set_runahead (IpcRunner *object, guint value)
{
  g_object_set (G_OBJECT (object), "runahead", value, NULL);
}

/**
 * ipc_runner_emit_variables_set:
 * @object: A #IpcRunner.
 * @arg_data: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Retro-Runner.VariablesSet">"VariablesSet"</link> D-Bus signal.
 */
void
ipc_runner_emit_variables_set (
    IpcRunner *object,
    GVariant *arg_data)
{
  g_signal_emit_by_name (object, "variables-set", arg_data);
}

/**
 * ipc_runner_emit_set_rumble_state:
 * @object: A #IpcRunner.
 * @arg_port: Argument to pass with the signal.
 * @arg_type: Argument to pass with the signal.
 * @arg_strength: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Retro-Runner.SetRumbleState">"SetRumbleState"</link> D-Bus signal.
 */
void
ipc_runner_emit_set_rumble_state (
    IpcRunner *object,
    guint arg_port,
    guint arg_type,
    guint16 arg_strength)
{
  g_signal_emit_by_name (object, "set-rumble-state", arg_port, arg_type, arg_strength);
}

/**
 * ipc_runner_emit_video_output:
 * @object: A #IpcRunner.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Retro-Runner.VideoOutput">"VideoOutput"</link> D-Bus signal.
 */
void
ipc_runner_emit_video_output (
    IpcRunner *object)
{
  g_signal_emit_by_name (object, "video-output");
}

/**
 * ipc_runner_emit_log:
 * @object: A #IpcRunner.
 * @arg_domain: Argument to pass with the signal.
 * @arg_level: Argument to pass with the signal.
 * @arg_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Retro-Runner.Log">"Log"</link> D-Bus signal.
 */
void
ipc_runner_emit_log (
    IpcRunner *object,
    const gchar *arg_domain,
    guint arg_level,
    const gchar *arg_message)
{
  g_signal_emit_by_name (object, "log", arg_domain, arg_level, arg_message);
}

/**
 * ipc_runner_emit_message:
 * @object: A #IpcRunner.
 * @arg_message: Argument to pass with the signal.
 * @arg_frames: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Retro-Runner.Message">"Message"</link> D-Bus signal.
 */
void
ipc_runner_emit_message (
    IpcRunner *object,
    const gchar *arg_message,
    guint arg_frames)
{
  g_signal_emit_by_name (object, "message", arg_message, arg_frames);
}

/**
 * ipc_runner_call_get_properties:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_get_properties_finish() to get the result of the operation.
 *
 * See ipc_runner_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_get_properties (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_get_properties_finish:
 * @proxy: A #IpcRunnerProxy.
 * @out_game_loaded: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_support_no_game: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_get_properties_finish (
    IpcRunner *proxy,
    gboolean *out_game_loaded,
    gdouble *out_fps,
    gboolean *out_support_no_game,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bdb)",
                 out_game_loaded,
                 out_fps,
                 out_support_no_game);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_get_properties_sync:
 * @proxy: A #IpcRunnerProxy.
 * @out_game_loaded: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_support_no_game: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_get_properties_sync (
    IpcRunner *proxy,
    gboolean *out_game_loaded,
    gdouble *out_fps,
    gboolean *out_support_no_game,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bdb)",
                 out_game_loaded,
                 out_fps,
                 out_support_no_game);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_boot:
 * @proxy: A #IpcRunnerProxy.
 * @arg_defaults: Argument to pass with the method invocation.
 * @arg_medias: Argument to pass with the method invocation.
 * @arg_default_controller: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Boot">Boot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_boot_finish() to get the result of the operation.
 *
 * See ipc_runner_call_boot_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_boot (
    IpcRunner *proxy,
    GVariant *arg_defaults,
    const gchar *const *arg_medias,
    GVariant *arg_default_controller,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Boot",
    g_variant_new ("(@a(ss)^as@h)",
                   arg_defaults,
                   arg_medias,
                   arg_default_controller),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_boot_finish:
 * @proxy: A #IpcRunnerProxy.
 * @out_variables: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_framebuffer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_boot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_boot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_boot_finish (
    IpcRunner *proxy,
    GVariant **out_variables,
    GVariant **out_framebuffer,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ss)@h)",
                 out_variables,
                 out_framebuffer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_boot_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_defaults: Argument to pass with the method invocation.
 * @arg_medias: Argument to pass with the method invocation.
 * @arg_default_controller: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_variables: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_framebuffer: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Boot">Boot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_boot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_boot_sync (
    IpcRunner *proxy,
    GVariant *arg_defaults,
    const gchar *const *arg_medias,
    GVariant *arg_default_controller,
    GUnixFDList  *fd_list,
    GVariant **out_variables,
    GVariant **out_framebuffer,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Boot",
    g_variant_new ("(@a(ss)^as@h)",
                   arg_defaults,
                   arg_medias,
                   arg_default_controller),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(ss)@h)",
                 out_variables,
                 out_framebuffer);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_set_current_media:
 * @proxy: A #IpcRunnerProxy.
 * @arg_index: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetCurrentMedia">SetCurrentMedia()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_set_current_media_finish() to get the result of the operation.
 *
 * See ipc_runner_call_set_current_media_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_set_current_media (
    IpcRunner *proxy,
    guint arg_index,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetCurrentMedia",
    g_variant_new ("(u)",
                   arg_index),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_set_current_media_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_set_current_media().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_set_current_media().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_set_current_media_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_set_current_media_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_index: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetCurrentMedia">SetCurrentMedia()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_set_current_media() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_set_current_media_sync (
    IpcRunner *proxy,
    guint arg_index,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetCurrentMedia",
    g_variant_new ("(u)",
                   arg_index),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_run:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Run">Run()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_run_finish() to get the result of the operation.
 *
 * See ipc_runner_call_run_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_run (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Run",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_run_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_run().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_run().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_run_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_run_sync:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Run">Run()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_run() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_run_sync (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Run",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_stop:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_stop_finish() to get the result of the operation.
 *
 * See ipc_runner_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_stop (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_stop_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_stop_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_stop_sync:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_stop_sync (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_reset:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Reset">Reset()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_reset_finish() to get the result of the operation.
 *
 * See ipc_runner_call_reset_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_reset (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reset",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_reset_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_reset().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_reset().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_reset_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_reset_sync:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Reset">Reset()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_reset() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_reset_sync (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reset",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_iteration:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Iteration">Iteration()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_iteration_finish() to get the result of the operation.
 *
 * See ipc_runner_call_iteration_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_iteration (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Iteration",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_iteration_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_iteration().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_iteration().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_iteration_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_iteration_sync:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.Iteration">Iteration()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_iteration() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_iteration_sync (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Iteration",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_get_can_access_state:
 * @proxy: A #IpcRunnerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetCanAccessState">GetCanAccessState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_get_can_access_state_finish() to get the result of the operation.
 *
 * See ipc_runner_call_get_can_access_state_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_get_can_access_state (
    IpcRunner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCanAccessState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_get_can_access_state_finish:
 * @proxy: A #IpcRunnerProxy.
 * @out_can_access_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_get_can_access_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_get_can_access_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_get_can_access_state_finish (
    IpcRunner *proxy,
    gboolean *out_can_access_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_access_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_get_can_access_state_sync:
 * @proxy: A #IpcRunnerProxy.
 * @out_can_access_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetCanAccessState">GetCanAccessState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_get_can_access_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_get_can_access_state_sync (
    IpcRunner *proxy,
    gboolean *out_can_access_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCanAccessState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_access_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_save_state:
 * @proxy: A #IpcRunnerProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveState">SaveState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_save_state_finish() to get the result of the operation.
 *
 * See ipc_runner_call_save_state_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_save_state (
    IpcRunner *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveState",
    g_variant_new ("(s)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_save_state_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_save_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_save_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_save_state_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_save_state_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveState">SaveState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_save_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_save_state_sync (
    IpcRunner *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveState",
    g_variant_new ("(s)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_load_state:
 * @proxy: A #IpcRunnerProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadState">LoadState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_load_state_finish() to get the result of the operation.
 *
 * See ipc_runner_call_load_state_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_load_state (
    IpcRunner *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LoadState",
    g_variant_new ("(s)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_load_state_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_load_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_load_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_load_state_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_load_state_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadState">LoadState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_load_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_load_state_sync (
    IpcRunner *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LoadState",
    g_variant_new ("(s)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_get_memory_size:
 * @proxy: A #IpcRunnerProxy.
 * @arg_memory_type: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetMemorySize">GetMemorySize()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_get_memory_size_finish() to get the result of the operation.
 *
 * See ipc_runner_call_get_memory_size_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_get_memory_size (
    IpcRunner *proxy,
    guint arg_memory_type,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMemorySize",
    g_variant_new ("(u)",
                   arg_memory_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_get_memory_size_finish:
 * @proxy: A #IpcRunnerProxy.
 * @out_size: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_get_memory_size().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_get_memory_size().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_get_memory_size_finish (
    IpcRunner *proxy,
    guint64 *out_size,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(t)",
                 out_size);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_get_memory_size_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_memory_type: Argument to pass with the method invocation.
 * @out_size: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetMemorySize">GetMemorySize()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_get_memory_size() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_get_memory_size_sync (
    IpcRunner *proxy,
    guint arg_memory_type,
    guint64 *out_size,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMemorySize",
    g_variant_new ("(u)",
                   arg_memory_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(t)",
                 out_size);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_save_memory:
 * @proxy: A #IpcRunnerProxy.
 * @arg_memory_type: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveMemory">SaveMemory()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_save_memory_finish() to get the result of the operation.
 *
 * See ipc_runner_call_save_memory_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_save_memory (
    IpcRunner *proxy,
    guint arg_memory_type,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveMemory",
    g_variant_new ("(us)",
                   arg_memory_type,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_save_memory_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_save_memory().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_save_memory().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_save_memory_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_save_memory_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_memory_type: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveMemory">SaveMemory()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_save_memory() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_save_memory_sync (
    IpcRunner *proxy,
    guint arg_memory_type,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveMemory",
    g_variant_new ("(us)",
                   arg_memory_type,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_load_memory:
 * @proxy: A #IpcRunnerProxy.
 * @arg_memory_type: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadMemory">LoadMemory()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_load_memory_finish() to get the result of the operation.
 *
 * See ipc_runner_call_load_memory_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_load_memory (
    IpcRunner *proxy,
    guint arg_memory_type,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "LoadMemory",
    g_variant_new ("(us)",
                   arg_memory_type,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_load_memory_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_load_memory().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_load_memory().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_load_memory_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_load_memory_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_memory_type: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadMemory">LoadMemory()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_load_memory() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_load_memory_sync (
    IpcRunner *proxy,
    guint arg_memory_type,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "LoadMemory",
    g_variant_new ("(us)",
                   arg_memory_type,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_update_variable:
 * @proxy: A #IpcRunnerProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.UpdateVariable">UpdateVariable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_update_variable_finish() to get the result of the operation.
 *
 * See ipc_runner_call_update_variable_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_update_variable (
    IpcRunner *proxy,
    const gchar *arg_key,
    const gchar *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateVariable",
    g_variant_new ("(ss)",
                   arg_key,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_update_variable_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_update_variable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_update_variable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_update_variable_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_update_variable_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.UpdateVariable">UpdateVariable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_update_variable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_update_variable_sync (
    IpcRunner *proxy,
    const gchar *arg_key,
    const gchar *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateVariable",
    g_variant_new ("(ss)",
                   arg_key,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_set_controller:
 * @proxy: A #IpcRunnerProxy.
 * @arg_port: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetController">SetController()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_set_controller_finish() to get the result of the operation.
 *
 * See ipc_runner_call_set_controller_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_set_controller (
    IpcRunner *proxy,
    guint arg_port,
    guint arg_type,
    GVariant *arg_data,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "SetController",
    g_variant_new ("(uu@h)",
                   arg_port,
                   arg_type,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_set_controller_finish:
 * @proxy: A #IpcRunnerProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_set_controller().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_set_controller().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_set_controller_finish (
    IpcRunner *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_set_controller_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_port: Argument to pass with the method invocation.
 * @arg_type: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetController">SetController()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_set_controller() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_set_controller_sync (
    IpcRunner *proxy,
    guint arg_port,
    guint arg_type,
    GVariant *arg_data,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "SetController",
    g_variant_new ("(uu@h)",
                   arg_port,
                   arg_type,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_key_event:
 * @proxy: A #IpcRunnerProxy.
 * @arg_pressed: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_character: Argument to pass with the method invocation.
 * @arg_modifiers: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.KeyEvent">KeyEvent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_call_key_event_finish() to get the result of the operation.
 *
 * See ipc_runner_call_key_event_sync() for the synchronous, blocking version of this method.
 */
void
ipc_runner_call_key_event (
    IpcRunner *proxy,
    gboolean arg_pressed,
    guint arg_keycode,
    guint arg_character,
    guint arg_modifiers,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "KeyEvent",
    g_variant_new ("(buuu)",
                   arg_pressed,
                   arg_keycode,
                   arg_character,
                   arg_modifiers),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ipc_runner_call_key_event_finish:
 * @proxy: A #IpcRunnerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_call_key_event().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ipc_runner_call_key_event().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_key_event_finish (
    IpcRunner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_call_key_event_sync:
 * @proxy: A #IpcRunnerProxy.
 * @arg_pressed: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_character: Argument to pass with the method invocation.
 * @arg_modifiers: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Retro-Runner.KeyEvent">KeyEvent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_call_key_event() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ipc_runner_call_key_event_sync (
    IpcRunner *proxy,
    gboolean arg_pressed,
    guint arg_keycode,
    guint arg_character,
    guint arg_modifiers,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "KeyEvent",
    g_variant_new ("(buuu)",
                   arg_pressed,
                   arg_keycode,
                   arg_character,
                   arg_modifiers),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ipc_runner_complete_get_properties:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @game_loaded: Parameter to return.
 * @fps: Parameter to return.
 * @support_no_game: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_get_properties (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean game_loaded,
    gdouble fps,
    gboolean support_no_game)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bdb)",
                   game_loaded,
                   fps,
                   support_no_game));
}

/**
 * ipc_runner_complete_boot:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @variables: Parameter to return.
 * @framebuffer: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.Boot">Boot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_boot (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *variables,
    GVariant *framebuffer)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@a(ss)@h)",
                   variables,
                   framebuffer),
    fd_list);
}

/**
 * ipc_runner_complete_set_current_media:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetCurrentMedia">SetCurrentMedia()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_set_current_media (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_run:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.Run">Run()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_run (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_stop:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_stop (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_reset:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.Reset">Reset()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_reset (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_iteration:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.Iteration">Iteration()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_iteration (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_get_can_access_state:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @can_access_state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetCanAccessState">GetCanAccessState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_get_can_access_state (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean can_access_state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   can_access_state));
}

/**
 * ipc_runner_complete_save_state:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveState">SaveState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_save_state (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_load_state:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadState">LoadState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_load_state (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_get_memory_size:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @size: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.GetMemorySize">GetMemorySize()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_get_memory_size (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint64 size)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(t)",
                   size));
}

/**
 * ipc_runner_complete_save_memory:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.SaveMemory">SaveMemory()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_save_memory (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_load_memory:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.LoadMemory">LoadMemory()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_load_memory (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_update_variable:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.UpdateVariable">UpdateVariable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_update_variable (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ipc_runner_complete_set_controller:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.SetController">SetController()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_set_controller (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * ipc_runner_complete_key_event:
 * @object: A #IpcRunner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Retro-Runner.KeyEvent">KeyEvent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ipc_runner_complete_key_event (
    IpcRunner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * IpcRunnerProxy:
 *
 * The #IpcRunnerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcRunnerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcRunnerProxy.
 */

struct _IpcRunnerProxyPrivate
{
  GData *qdata;
};

static void ipc_runner_proxy_iface_init (IpcRunnerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcRunnerProxy, ipc_runner_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (IpcRunnerProxy)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_RUNNER, ipc_runner_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcRunnerProxy, ipc_runner_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_RUNNER, ipc_runner_proxy_iface_init))

#endif
static void
ipc_runner_proxy_finalize (GObject *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ipc_runner_proxy_parent_class)->finalize (object);
}

static void
ipc_runner_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_runner_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ipc_runner_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Retro.Runner: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ipc_runner_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_runner_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Retro.Runner", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ipc_runner_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ipc_runner_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ipc_runner_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], IPC_TYPE_RUNNER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_RUNNER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ipc_runner_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_runner_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_runner_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
ipc_runner_proxy_get_api_version (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ApiVersion");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ipc_runner_proxy_get_system_directory (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SystemDirectory");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ipc_runner_proxy_get_content_directory (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ContentDirectory");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ipc_runner_proxy_get_save_directory (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SaveDirectory");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
ipc_runner_proxy_get_game_loaded (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "GameLoaded");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
ipc_runner_proxy_get_frames_per_second (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "FramesPerSecond");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
ipc_runner_proxy_get_support_no_game (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportNoGame");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
ipc_runner_proxy_get_speed_rate (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SpeedRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
ipc_runner_proxy_get_runahead (IpcRunner *object)
{
  IpcRunnerProxy *proxy = IPC_RUNNER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Runahead");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
ipc_runner_proxy_init (IpcRunnerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ipc_runner_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, IPC_TYPE_RUNNER_PROXY, IpcRunnerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ipc_runner_interface_info ());
}

static void
ipc_runner_proxy_class_init (IpcRunnerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ipc_runner_proxy_finalize;
  gobject_class->get_property = ipc_runner_proxy_get_property;
  gobject_class->set_property = ipc_runner_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ipc_runner_proxy_g_signal;
  proxy_class->g_properties_changed = ipc_runner_proxy_g_properties_changed;

  ipc_runner_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcRunnerProxyPrivate));
#endif
}

static void
ipc_runner_proxy_iface_init (IpcRunnerIface *iface)
{
  iface->get_api_version = ipc_runner_proxy_get_api_version;
  iface->get_system_directory = ipc_runner_proxy_get_system_directory;
  iface->get_content_directory = ipc_runner_proxy_get_content_directory;
  iface->get_save_directory = ipc_runner_proxy_get_save_directory;
  iface->get_game_loaded = ipc_runner_proxy_get_game_loaded;
  iface->get_frames_per_second = ipc_runner_proxy_get_frames_per_second;
  iface->get_support_no_game = ipc_runner_proxy_get_support_no_game;
  iface->get_speed_rate = ipc_runner_proxy_get_speed_rate;
  iface->get_runahead = ipc_runner_proxy_get_runahead;
}

/**
 * ipc_runner_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_proxy_new_finish() to get the result of the operation.
 *
 * See ipc_runner_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_runner_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_RUNNER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Retro.Runner", NULL);
}

/**
 * ipc_runner_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_runner_proxy_new().
 *
 * Returns: (transfer full) (type IpcRunnerProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcRunner *
ipc_runner_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_RUNNER (ret);
  else
    return NULL;
}

/**
 * ipc_runner_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcRunnerProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcRunner *
ipc_runner_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_RUNNER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Retro.Runner", NULL);
  if (ret != NULL)
    return IPC_RUNNER (ret);
  else
    return NULL;
}


/**
 * ipc_runner_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ipc_runner_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ipc_runner_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ipc_runner_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ipc_runner_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (IPC_TYPE_RUNNER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Retro.Runner", NULL);
}

/**
 * ipc_runner_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ipc_runner_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ipc_runner_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type IpcRunnerProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcRunner *
ipc_runner_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return IPC_RUNNER (ret);
  else
    return NULL;
}

/**
 * ipc_runner_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ipc_runner_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ipc_runner_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type IpcRunnerProxy): The constructed proxy object or %NULL if @error is set.
 */
IpcRunner *
ipc_runner_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (IPC_TYPE_RUNNER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Retro.Runner", NULL);
  if (ret != NULL)
    return IPC_RUNNER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * IpcRunnerSkeleton:
 *
 * The #IpcRunnerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * IpcRunnerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #IpcRunnerSkeleton.
 */

struct _IpcRunnerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ipc_runner_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], IPC_TYPE_RUNNER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, IPC_TYPE_RUNNER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ipc_runner_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_runner_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ipc_runner_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ipc_runner_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ipc_runner_skeleton_vtable =
{
  _ipc_runner_skeleton_handle_method_call,
  _ipc_runner_skeleton_handle_get_property,
  _ipc_runner_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ipc_runner_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ipc_runner_interface_info ();
}

static GDBusInterfaceVTable *
ipc_runner_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ipc_runner_skeleton_vtable;
}

static GVariant *
ipc_runner_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ipc_runner_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ipc_runner_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ipc_runner_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ipc_runner_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Retro.Runner", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ipc_runner_emit_changed (gpointer user_data);

static void
ipc_runner_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ipc_runner_emit_changed (skeleton);
}

static void
_ipc_runner_on_signal_variables_set (
    IpcRunner *object,
    GVariant *arg_data)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a(ss))",
                   arg_data));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Retro.Runner", "VariablesSet",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ipc_runner_on_signal_set_rumble_state (
    IpcRunner *object,
    guint arg_port,
    guint arg_type,
    guint16 arg_strength)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uuq)",
                   arg_port,
                   arg_type,
                   arg_strength));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Retro.Runner", "SetRumbleState",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ipc_runner_on_signal_video_output (
    IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Retro.Runner", "VideoOutput",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ipc_runner_on_signal_log (
    IpcRunner *object,
    const gchar *arg_domain,
    guint arg_level,
    const gchar *arg_message)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sus)",
                   arg_domain,
                   arg_level,
                   arg_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Retro.Runner", "Log",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_ipc_runner_on_signal_message (
    IpcRunner *object,
    const gchar *arg_message,
    guint arg_frames)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(su)",
                   arg_message,
                   arg_frames));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Retro.Runner", "Message",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ipc_runner_skeleton_iface_init (IpcRunnerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (IpcRunnerSkeleton, ipc_runner_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (IpcRunnerSkeleton)
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_RUNNER, ipc_runner_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (IpcRunnerSkeleton, ipc_runner_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (IPC_TYPE_RUNNER, ipc_runner_skeleton_iface_init))

#endif
static void
ipc_runner_skeleton_finalize (GObject *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ipc_runner_skeleton_parent_class)->finalize (object);
}

static void
ipc_runner_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ipc_runner_emit_changed (gpointer user_data)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Retro.Runner",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ipc_runner_schedule_emit_changed (IpcRunnerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ipc_runner_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ipc_runner_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ipc_runner_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ipc_runner_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _ipc_runner_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ipc_runner_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ipc_runner_skeleton_init (IpcRunnerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ipc_runner_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, IPC_TYPE_RUNNER_SKELETON, IpcRunnerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UINT);
}

static guint 
ipc_runner_skeleton_get_api_version (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ipc_runner_skeleton_get_system_directory (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ipc_runner_skeleton_get_content_directory (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ipc_runner_skeleton_get_save_directory (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
ipc_runner_skeleton_get_game_loaded (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
ipc_runner_skeleton_get_frames_per_second (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
ipc_runner_skeleton_get_support_no_game (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
ipc_runner_skeleton_get_speed_rate (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
ipc_runner_skeleton_get_runahead (IpcRunner *object)
{
  IpcRunnerSkeleton *skeleton = IPC_RUNNER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ipc_runner_skeleton_class_init (IpcRunnerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ipc_runner_skeleton_finalize;
  gobject_class->get_property = ipc_runner_skeleton_get_property;
  gobject_class->set_property = ipc_runner_skeleton_set_property;
  gobject_class->notify       = ipc_runner_skeleton_notify;


  ipc_runner_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ipc_runner_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ipc_runner_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ipc_runner_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ipc_runner_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (IpcRunnerSkeletonPrivate));
#endif
}

static void
ipc_runner_skeleton_iface_init (IpcRunnerIface *iface)
{
  iface->variables_set = _ipc_runner_on_signal_variables_set;
  iface->set_rumble_state = _ipc_runner_on_signal_set_rumble_state;
  iface->video_output = _ipc_runner_on_signal_video_output;
  iface->log = _ipc_runner_on_signal_log;
  iface->message = _ipc_runner_on_signal_message;
  iface->get_api_version = ipc_runner_skeleton_get_api_version;
  iface->get_system_directory = ipc_runner_skeleton_get_system_directory;
  iface->get_content_directory = ipc_runner_skeleton_get_content_directory;
  iface->get_save_directory = ipc_runner_skeleton_get_save_directory;
  iface->get_game_loaded = ipc_runner_skeleton_get_game_loaded;
  iface->get_frames_per_second = ipc_runner_skeleton_get_frames_per_second;
  iface->get_support_no_game = ipc_runner_skeleton_get_support_no_game;
  iface->get_speed_rate = ipc_runner_skeleton_get_speed_rate;
  iface->get_runahead = ipc_runner_skeleton_get_runahead;
}

/**
 * ipc_runner_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Retro-Runner.top_of_page">org.gnome.Retro.Runner</link>.
 *
 * Returns: (transfer full) (type IpcRunnerSkeleton): The skeleton object.
 */
IpcRunner *
ipc_runner_skeleton_new (void)
{
  return IPC_RUNNER (g_object_new (IPC_TYPE_RUNNER_SKELETON, NULL));
}

