
#line 1 "src/desc.rl"
#include "desc.h"

#include <err.h>
#include "package.h"
#include "util.h"


#line 55 "src/desc.rl"



#line 15 "src/desc.c"
static const int desc_start = 180;
static const int desc_error = 0;

static const int desc_en_main = 180;


#line 58 "src/desc.rl"

void desc_parser_init(struct desc_parser *parser)
{
    *parser = (struct desc_parser){0};
    
#line 63 "src/desc.rl"
    
#line 30 "src/desc.c"
	{
	 parser->cs = desc_start;
	}

#line 64 "src/desc.rl"
}

ssize_t desc_parser_feed(struct desc_parser *parser, struct pkg *pkg,
                         char *buf, size_t buf_len)
{
    char *p = buf;
    char *pe = p + buf_len;

    
#line 73 "src/desc.rl"
    
#line 47 "src/desc.c"
	{
	if ( p == pe )
		goto _test_eof;
	switch (  parser->cs )
	{
st180:
	if ( ++p == pe )
		goto _test_eof180;
case 180:
	switch( (*p) ) {
		case 10: goto st180;
		case 37: goto st1;
	}
	goto st0;
st0:
 parser->cs = 0;
	goto _out;
st1:
	if ( ++p == pe )
		goto _test_eof1;
case 1:
	switch( (*p) ) {
		case 65: goto st2;
		case 66: goto st9;
		case 67: goto st23;
		case 68: goto st50;
		case 70: goto st66;
		case 71: goto st77;
		case 73: goto st84;
		case 76: goto st90;
		case 77: goto st98;
		case 78: goto st110;
		case 79: goto st115;
		case 80: goto st126;
		case 82: goto st149;
		case 83: goto st158;
		case 85: goto st168;
		case 86: goto st172;
	}
	goto st0;
st2:
	if ( ++p == pe )
		goto _test_eof2;
case 2:
	if ( (*p) == 82 )
		goto st3;
	goto st0;
st3:
	if ( ++p == pe )
		goto _test_eof3;
case 3:
	if ( (*p) == 67 )
		goto st4;
	goto st0;
st4:
	if ( ++p == pe )
		goto _test_eof4;
case 4:
	if ( (*p) == 72 )
		goto st5;
	goto st0;
st5:
	if ( ++p == pe )
		goto _test_eof5;
case 5:
	if ( (*p) == 37 )
		goto st6;
	goto st0;
st6:
	if ( ++p == pe )
		goto _test_eof6;
case 6:
	if ( (*p) == 10 )
		goto tr21;
	goto st0;
tr21:
#line 38 "src/desc.rl"
	{ parser->entry = PKG_ARCH; }
	goto st7;
tr24:
#line 17 "src/desc.rl"
	{
        const char *entry = parser->store;
        const size_t entry_len = parser->pos;
        parser->store[parser->pos] = 0;
        parser->pos = 0;

        package_set(pkg, parser->entry, entry, entry_len);
    }
	goto st7;
tr30:
#line 28 "src/desc.rl"
	{ parser->entry = PKG_PKGBASE; }
	goto st7;
tr39:
#line 39 "src/desc.rl"
	{ parser->entry = PKG_BUILDDATE; }
	goto st7;
tr54:
#line 47 "src/desc.rl"
	{ parser->entry = PKG_CHECKDEPENDS; }
	goto st7;
tr63:
#line 43 "src/desc.rl"
	{ parser->entry = PKG_CONFLICTS; }
	goto st7;
tr68:
#line 32 "src/desc.rl"
	{ parser->entry = PKG_CSIZE; }
	goto st7;
tr77:
#line 49 "src/desc.rl"
	{ parser->entry = PKG_FILES; }
	goto st7;
tr83:
#line 42 "src/desc.rl"
	{ parser->entry = PKG_DEPENDS; }
	goto st7;
tr86:
#line 30 "src/desc.rl"
	{ parser->entry = PKG_DESCRIPTION; }
	goto st7;
tr96:
#line 26 "src/desc.rl"
	{ parser->entry = PKG_FILENAME; }
	goto st7;
tr98:
#line 48 "src/desc.rl"
	{ parser->entry = PKG_FILES; }
	goto st7;
tr105:
#line 31 "src/desc.rl"
	{ parser->entry = PKG_GROUPS; }
	goto st7;
tr111:
#line 33 "src/desc.rl"
	{ parser->entry = PKG_ISIZE; }
	goto st7;
tr119:
#line 37 "src/desc.rl"
	{ parser->entry = PKG_LICENSE; }
	goto st7;
tr131:
#line 46 "src/desc.rl"
	{ parser->entry = PKG_MAKEDEPENDS; }
	goto st7;
tr136:
#line 27 "src/desc.rl"
	{ parser->entry = PKG_PKGNAME; }
	goto st7;
tr147:
#line 45 "src/desc.rl"
	{ parser->entry = PKG_OPTDEPENDS; }
	goto st7;
tr158:
#line 40 "src/desc.rl"
	{ parser->entry = PKG_PACKAGER; }
	goto st7;
tr164:
#line 35 "src/desc.rl"
	{ parser->entry = PKG_PGPSIG; }
	goto st7;
tr172:
#line 44 "src/desc.rl"
	{ parser->entry = PKG_PROVIDES; }
	goto st7;
tr181:
#line 41 "src/desc.rl"
	{ parser->entry = PKG_REPLACES; }
	goto st7;
tr191:
#line 34 "src/desc.rl"
	{ parser->entry = PKG_SHA256SUM; }
	goto st7;
tr195:
#line 36 "src/desc.rl"
	{ parser->entry = PKG_URL; }
	goto st7;
tr203:
#line 29 "src/desc.rl"
	{ parser->entry = PKG_VERSION; }
	goto st7;
st7:
	if ( ++p == pe )
		goto _test_eof7;
case 7:
#line 234 "src/desc.c"
	switch( (*p) ) {
		case 10: goto st180;
		case 37: goto st0;
	}
	goto tr22;
tr22:
#line 10 "src/desc.rl"
	{
        parser->store[parser->pos++] = (*p);
        if (parser->pos == LINE_MAX) {
            errx(1, "desc line too long");
        }
    }
	goto st8;
st8:
	if ( ++p == pe )
		goto _test_eof8;
case 8:
#line 253 "src/desc.c"
	switch( (*p) ) {
		case 10: goto tr24;
		case 37: goto st0;
	}
	goto tr22;
st9:
	if ( ++p == pe )
		goto _test_eof9;
case 9:
	switch( (*p) ) {
		case 65: goto st10;
		case 85: goto st14;
	}
	goto st0;
st10:
	if ( ++p == pe )
		goto _test_eof10;
case 10:
	if ( (*p) == 83 )
		goto st11;
	goto st0;
st11:
	if ( ++p == pe )
		goto _test_eof11;
case 11:
	if ( (*p) == 69 )
		goto st12;
	goto st0;
st12:
	if ( ++p == pe )
		goto _test_eof12;
case 12:
	if ( (*p) == 37 )
		goto st13;
	goto st0;
st13:
	if ( ++p == pe )
		goto _test_eof13;
case 13:
	if ( (*p) == 10 )
		goto tr30;
	goto st0;
st14:
	if ( ++p == pe )
		goto _test_eof14;
case 14:
	if ( (*p) == 73 )
		goto st15;
	goto st0;
st15:
	if ( ++p == pe )
		goto _test_eof15;
case 15:
	if ( (*p) == 76 )
		goto st16;
	goto st0;
st16:
	if ( ++p == pe )
		goto _test_eof16;
case 16:
	if ( (*p) == 68 )
		goto st17;
	goto st0;
st17:
	if ( ++p == pe )
		goto _test_eof17;
case 17:
	if ( (*p) == 68 )
		goto st18;
	goto st0;
st18:
	if ( ++p == pe )
		goto _test_eof18;
case 18:
	if ( (*p) == 65 )
		goto st19;
	goto st0;
st19:
	if ( ++p == pe )
		goto _test_eof19;
case 19:
	if ( (*p) == 84 )
		goto st20;
	goto st0;
st20:
	if ( ++p == pe )
		goto _test_eof20;
case 20:
	if ( (*p) == 69 )
		goto st21;
	goto st0;
st21:
	if ( ++p == pe )
		goto _test_eof21;
case 21:
	if ( (*p) == 37 )
		goto st22;
	goto st0;
st22:
	if ( ++p == pe )
		goto _test_eof22;
case 22:
	if ( (*p) == 10 )
		goto tr39;
	goto st0;
st23:
	if ( ++p == pe )
		goto _test_eof23;
case 23:
	switch( (*p) ) {
		case 72: goto st24;
		case 79: goto st36;
		case 83: goto st45;
	}
	goto st0;
st24:
	if ( ++p == pe )
		goto _test_eof24;
case 24:
	if ( (*p) == 69 )
		goto st25;
	goto st0;
st25:
	if ( ++p == pe )
		goto _test_eof25;
case 25:
	if ( (*p) == 67 )
		goto st26;
	goto st0;
st26:
	if ( ++p == pe )
		goto _test_eof26;
case 26:
	if ( (*p) == 75 )
		goto st27;
	goto st0;
st27:
	if ( ++p == pe )
		goto _test_eof27;
case 27:
	if ( (*p) == 68 )
		goto st28;
	goto st0;
st28:
	if ( ++p == pe )
		goto _test_eof28;
case 28:
	if ( (*p) == 69 )
		goto st29;
	goto st0;
st29:
	if ( ++p == pe )
		goto _test_eof29;
case 29:
	if ( (*p) == 80 )
		goto st30;
	goto st0;
st30:
	if ( ++p == pe )
		goto _test_eof30;
case 30:
	if ( (*p) == 69 )
		goto st31;
	goto st0;
st31:
	if ( ++p == pe )
		goto _test_eof31;
case 31:
	if ( (*p) == 78 )
		goto st32;
	goto st0;
st32:
	if ( ++p == pe )
		goto _test_eof32;
case 32:
	if ( (*p) == 68 )
		goto st33;
	goto st0;
st33:
	if ( ++p == pe )
		goto _test_eof33;
case 33:
	if ( (*p) == 83 )
		goto st34;
	goto st0;
st34:
	if ( ++p == pe )
		goto _test_eof34;
case 34:
	if ( (*p) == 37 )
		goto st35;
	goto st0;
st35:
	if ( ++p == pe )
		goto _test_eof35;
case 35:
	if ( (*p) == 10 )
		goto tr54;
	goto st0;
st36:
	if ( ++p == pe )
		goto _test_eof36;
case 36:
	if ( (*p) == 78 )
		goto st37;
	goto st0;
st37:
	if ( ++p == pe )
		goto _test_eof37;
case 37:
	if ( (*p) == 70 )
		goto st38;
	goto st0;
st38:
	if ( ++p == pe )
		goto _test_eof38;
case 38:
	if ( (*p) == 76 )
		goto st39;
	goto st0;
st39:
	if ( ++p == pe )
		goto _test_eof39;
case 39:
	if ( (*p) == 73 )
		goto st40;
	goto st0;
st40:
	if ( ++p == pe )
		goto _test_eof40;
case 40:
	if ( (*p) == 67 )
		goto st41;
	goto st0;
st41:
	if ( ++p == pe )
		goto _test_eof41;
case 41:
	if ( (*p) == 84 )
		goto st42;
	goto st0;
st42:
	if ( ++p == pe )
		goto _test_eof42;
case 42:
	if ( (*p) == 83 )
		goto st43;
	goto st0;
st43:
	if ( ++p == pe )
		goto _test_eof43;
case 43:
	if ( (*p) == 37 )
		goto st44;
	goto st0;
st44:
	if ( ++p == pe )
		goto _test_eof44;
case 44:
	if ( (*p) == 10 )
		goto tr63;
	goto st0;
st45:
	if ( ++p == pe )
		goto _test_eof45;
case 45:
	if ( (*p) == 73 )
		goto st46;
	goto st0;
st46:
	if ( ++p == pe )
		goto _test_eof46;
case 46:
	if ( (*p) == 90 )
		goto st47;
	goto st0;
st47:
	if ( ++p == pe )
		goto _test_eof47;
case 47:
	if ( (*p) == 69 )
		goto st48;
	goto st0;
st48:
	if ( ++p == pe )
		goto _test_eof48;
case 48:
	if ( (*p) == 37 )
		goto st49;
	goto st0;
st49:
	if ( ++p == pe )
		goto _test_eof49;
case 49:
	if ( (*p) == 10 )
		goto tr68;
	goto st0;
st50:
	if ( ++p == pe )
		goto _test_eof50;
case 50:
	if ( (*p) == 69 )
		goto st51;
	goto st0;
st51:
	if ( ++p == pe )
		goto _test_eof51;
case 51:
	switch( (*p) ) {
		case 76: goto st52;
		case 80: goto st57;
		case 83: goto st63;
	}
	goto st0;
st52:
	if ( ++p == pe )
		goto _test_eof52;
case 52:
	if ( (*p) == 84 )
		goto st53;
	goto st0;
st53:
	if ( ++p == pe )
		goto _test_eof53;
case 53:
	if ( (*p) == 65 )
		goto st54;
	goto st0;
st54:
	if ( ++p == pe )
		goto _test_eof54;
case 54:
	if ( (*p) == 83 )
		goto st55;
	goto st0;
st55:
	if ( ++p == pe )
		goto _test_eof55;
case 55:
	if ( (*p) == 37 )
		goto st56;
	goto st0;
st56:
	if ( ++p == pe )
		goto _test_eof56;
case 56:
	if ( (*p) == 10 )
		goto tr77;
	goto st0;
st57:
	if ( ++p == pe )
		goto _test_eof57;
case 57:
	if ( (*p) == 69 )
		goto st58;
	goto st0;
st58:
	if ( ++p == pe )
		goto _test_eof58;
case 58:
	if ( (*p) == 78 )
		goto st59;
	goto st0;
st59:
	if ( ++p == pe )
		goto _test_eof59;
case 59:
	if ( (*p) == 68 )
		goto st60;
	goto st0;
st60:
	if ( ++p == pe )
		goto _test_eof60;
case 60:
	if ( (*p) == 83 )
		goto st61;
	goto st0;
st61:
	if ( ++p == pe )
		goto _test_eof61;
case 61:
	if ( (*p) == 37 )
		goto st62;
	goto st0;
st62:
	if ( ++p == pe )
		goto _test_eof62;
case 62:
	if ( (*p) == 10 )
		goto tr83;
	goto st0;
st63:
	if ( ++p == pe )
		goto _test_eof63;
case 63:
	if ( (*p) == 67 )
		goto st64;
	goto st0;
st64:
	if ( ++p == pe )
		goto _test_eof64;
case 64:
	if ( (*p) == 37 )
		goto st65;
	goto st0;
st65:
	if ( ++p == pe )
		goto _test_eof65;
case 65:
	if ( (*p) == 10 )
		goto tr86;
	goto st0;
st66:
	if ( ++p == pe )
		goto _test_eof66;
case 66:
	if ( (*p) == 73 )
		goto st67;
	goto st0;
st67:
	if ( ++p == pe )
		goto _test_eof67;
case 67:
	if ( (*p) == 76 )
		goto st68;
	goto st0;
st68:
	if ( ++p == pe )
		goto _test_eof68;
case 68:
	if ( (*p) == 69 )
		goto st69;
	goto st0;
st69:
	if ( ++p == pe )
		goto _test_eof69;
case 69:
	switch( (*p) ) {
		case 78: goto st70;
		case 83: goto st75;
	}
	goto st0;
st70:
	if ( ++p == pe )
		goto _test_eof70;
case 70:
	if ( (*p) == 65 )
		goto st71;
	goto st0;
st71:
	if ( ++p == pe )
		goto _test_eof71;
case 71:
	if ( (*p) == 77 )
		goto st72;
	goto st0;
st72:
	if ( ++p == pe )
		goto _test_eof72;
case 72:
	if ( (*p) == 69 )
		goto st73;
	goto st0;
st73:
	if ( ++p == pe )
		goto _test_eof73;
case 73:
	if ( (*p) == 37 )
		goto st74;
	goto st0;
st74:
	if ( ++p == pe )
		goto _test_eof74;
case 74:
	if ( (*p) == 10 )
		goto tr96;
	goto st0;
st75:
	if ( ++p == pe )
		goto _test_eof75;
case 75:
	if ( (*p) == 37 )
		goto st76;
	goto st0;
st76:
	if ( ++p == pe )
		goto _test_eof76;
case 76:
	if ( (*p) == 10 )
		goto tr98;
	goto st0;
st77:
	if ( ++p == pe )
		goto _test_eof77;
case 77:
	if ( (*p) == 82 )
		goto st78;
	goto st0;
st78:
	if ( ++p == pe )
		goto _test_eof78;
case 78:
	if ( (*p) == 79 )
		goto st79;
	goto st0;
st79:
	if ( ++p == pe )
		goto _test_eof79;
case 79:
	if ( (*p) == 85 )
		goto st80;
	goto st0;
st80:
	if ( ++p == pe )
		goto _test_eof80;
case 80:
	if ( (*p) == 80 )
		goto st81;
	goto st0;
st81:
	if ( ++p == pe )
		goto _test_eof81;
case 81:
	if ( (*p) == 83 )
		goto st82;
	goto st0;
st82:
	if ( ++p == pe )
		goto _test_eof82;
case 82:
	if ( (*p) == 37 )
		goto st83;
	goto st0;
st83:
	if ( ++p == pe )
		goto _test_eof83;
case 83:
	if ( (*p) == 10 )
		goto tr105;
	goto st0;
st84:
	if ( ++p == pe )
		goto _test_eof84;
case 84:
	if ( (*p) == 83 )
		goto st85;
	goto st0;
st85:
	if ( ++p == pe )
		goto _test_eof85;
case 85:
	if ( (*p) == 73 )
		goto st86;
	goto st0;
st86:
	if ( ++p == pe )
		goto _test_eof86;
case 86:
	if ( (*p) == 90 )
		goto st87;
	goto st0;
st87:
	if ( ++p == pe )
		goto _test_eof87;
case 87:
	if ( (*p) == 69 )
		goto st88;
	goto st0;
st88:
	if ( ++p == pe )
		goto _test_eof88;
case 88:
	if ( (*p) == 37 )
		goto st89;
	goto st0;
st89:
	if ( ++p == pe )
		goto _test_eof89;
case 89:
	if ( (*p) == 10 )
		goto tr111;
	goto st0;
st90:
	if ( ++p == pe )
		goto _test_eof90;
case 90:
	if ( (*p) == 73 )
		goto st91;
	goto st0;
st91:
	if ( ++p == pe )
		goto _test_eof91;
case 91:
	if ( (*p) == 67 )
		goto st92;
	goto st0;
st92:
	if ( ++p == pe )
		goto _test_eof92;
case 92:
	if ( (*p) == 69 )
		goto st93;
	goto st0;
st93:
	if ( ++p == pe )
		goto _test_eof93;
case 93:
	if ( (*p) == 78 )
		goto st94;
	goto st0;
st94:
	if ( ++p == pe )
		goto _test_eof94;
case 94:
	if ( (*p) == 83 )
		goto st95;
	goto st0;
st95:
	if ( ++p == pe )
		goto _test_eof95;
case 95:
	if ( (*p) == 69 )
		goto st96;
	goto st0;
st96:
	if ( ++p == pe )
		goto _test_eof96;
case 96:
	if ( (*p) == 37 )
		goto st97;
	goto st0;
st97:
	if ( ++p == pe )
		goto _test_eof97;
case 97:
	if ( (*p) == 10 )
		goto tr119;
	goto st0;
st98:
	if ( ++p == pe )
		goto _test_eof98;
case 98:
	if ( (*p) == 65 )
		goto st99;
	goto st0;
st99:
	if ( ++p == pe )
		goto _test_eof99;
case 99:
	if ( (*p) == 75 )
		goto st100;
	goto st0;
st100:
	if ( ++p == pe )
		goto _test_eof100;
case 100:
	if ( (*p) == 69 )
		goto st101;
	goto st0;
st101:
	if ( ++p == pe )
		goto _test_eof101;
case 101:
	if ( (*p) == 68 )
		goto st102;
	goto st0;
st102:
	if ( ++p == pe )
		goto _test_eof102;
case 102:
	if ( (*p) == 69 )
		goto st103;
	goto st0;
st103:
	if ( ++p == pe )
		goto _test_eof103;
case 103:
	if ( (*p) == 80 )
		goto st104;
	goto st0;
st104:
	if ( ++p == pe )
		goto _test_eof104;
case 104:
	if ( (*p) == 69 )
		goto st105;
	goto st0;
st105:
	if ( ++p == pe )
		goto _test_eof105;
case 105:
	if ( (*p) == 78 )
		goto st106;
	goto st0;
st106:
	if ( ++p == pe )
		goto _test_eof106;
case 106:
	if ( (*p) == 68 )
		goto st107;
	goto st0;
st107:
	if ( ++p == pe )
		goto _test_eof107;
case 107:
	if ( (*p) == 83 )
		goto st108;
	goto st0;
st108:
	if ( ++p == pe )
		goto _test_eof108;
case 108:
	if ( (*p) == 37 )
		goto st109;
	goto st0;
st109:
	if ( ++p == pe )
		goto _test_eof109;
case 109:
	if ( (*p) == 10 )
		goto tr131;
	goto st0;
st110:
	if ( ++p == pe )
		goto _test_eof110;
case 110:
	if ( (*p) == 65 )
		goto st111;
	goto st0;
st111:
	if ( ++p == pe )
		goto _test_eof111;
case 111:
	if ( (*p) == 77 )
		goto st112;
	goto st0;
st112:
	if ( ++p == pe )
		goto _test_eof112;
case 112:
	if ( (*p) == 69 )
		goto st113;
	goto st0;
st113:
	if ( ++p == pe )
		goto _test_eof113;
case 113:
	if ( (*p) == 37 )
		goto st114;
	goto st0;
st114:
	if ( ++p == pe )
		goto _test_eof114;
case 114:
	if ( (*p) == 10 )
		goto tr136;
	goto st0;
st115:
	if ( ++p == pe )
		goto _test_eof115;
case 115:
	if ( (*p) == 80 )
		goto st116;
	goto st0;
st116:
	if ( ++p == pe )
		goto _test_eof116;
case 116:
	if ( (*p) == 84 )
		goto st117;
	goto st0;
st117:
	if ( ++p == pe )
		goto _test_eof117;
case 117:
	if ( (*p) == 68 )
		goto st118;
	goto st0;
st118:
	if ( ++p == pe )
		goto _test_eof118;
case 118:
	if ( (*p) == 69 )
		goto st119;
	goto st0;
st119:
	if ( ++p == pe )
		goto _test_eof119;
case 119:
	if ( (*p) == 80 )
		goto st120;
	goto st0;
st120:
	if ( ++p == pe )
		goto _test_eof120;
case 120:
	if ( (*p) == 69 )
		goto st121;
	goto st0;
st121:
	if ( ++p == pe )
		goto _test_eof121;
case 121:
	if ( (*p) == 78 )
		goto st122;
	goto st0;
st122:
	if ( ++p == pe )
		goto _test_eof122;
case 122:
	if ( (*p) == 68 )
		goto st123;
	goto st0;
st123:
	if ( ++p == pe )
		goto _test_eof123;
case 123:
	if ( (*p) == 83 )
		goto st124;
	goto st0;
st124:
	if ( ++p == pe )
		goto _test_eof124;
case 124:
	if ( (*p) == 37 )
		goto st125;
	goto st0;
st125:
	if ( ++p == pe )
		goto _test_eof125;
case 125:
	if ( (*p) == 10 )
		goto tr147;
	goto st0;
st126:
	if ( ++p == pe )
		goto _test_eof126;
case 126:
	switch( (*p) ) {
		case 65: goto st127;
		case 71: goto st135;
		case 82: goto st141;
	}
	goto st0;
st127:
	if ( ++p == pe )
		goto _test_eof127;
case 127:
	if ( (*p) == 67 )
		goto st128;
	goto st0;
st128:
	if ( ++p == pe )
		goto _test_eof128;
case 128:
	if ( (*p) == 75 )
		goto st129;
	goto st0;
st129:
	if ( ++p == pe )
		goto _test_eof129;
case 129:
	if ( (*p) == 65 )
		goto st130;
	goto st0;
st130:
	if ( ++p == pe )
		goto _test_eof130;
case 130:
	if ( (*p) == 71 )
		goto st131;
	goto st0;
st131:
	if ( ++p == pe )
		goto _test_eof131;
case 131:
	if ( (*p) == 69 )
		goto st132;
	goto st0;
st132:
	if ( ++p == pe )
		goto _test_eof132;
case 132:
	if ( (*p) == 82 )
		goto st133;
	goto st0;
st133:
	if ( ++p == pe )
		goto _test_eof133;
case 133:
	if ( (*p) == 37 )
		goto st134;
	goto st0;
st134:
	if ( ++p == pe )
		goto _test_eof134;
case 134:
	if ( (*p) == 10 )
		goto tr158;
	goto st0;
st135:
	if ( ++p == pe )
		goto _test_eof135;
case 135:
	if ( (*p) == 80 )
		goto st136;
	goto st0;
st136:
	if ( ++p == pe )
		goto _test_eof136;
case 136:
	if ( (*p) == 83 )
		goto st137;
	goto st0;
st137:
	if ( ++p == pe )
		goto _test_eof137;
case 137:
	if ( (*p) == 73 )
		goto st138;
	goto st0;
st138:
	if ( ++p == pe )
		goto _test_eof138;
case 138:
	if ( (*p) == 71 )
		goto st139;
	goto st0;
st139:
	if ( ++p == pe )
		goto _test_eof139;
case 139:
	if ( (*p) == 37 )
		goto st140;
	goto st0;
st140:
	if ( ++p == pe )
		goto _test_eof140;
case 140:
	if ( (*p) == 10 )
		goto tr164;
	goto st0;
st141:
	if ( ++p == pe )
		goto _test_eof141;
case 141:
	if ( (*p) == 79 )
		goto st142;
	goto st0;
st142:
	if ( ++p == pe )
		goto _test_eof142;
case 142:
	if ( (*p) == 86 )
		goto st143;
	goto st0;
st143:
	if ( ++p == pe )
		goto _test_eof143;
case 143:
	if ( (*p) == 73 )
		goto st144;
	goto st0;
st144:
	if ( ++p == pe )
		goto _test_eof144;
case 144:
	if ( (*p) == 68 )
		goto st145;
	goto st0;
st145:
	if ( ++p == pe )
		goto _test_eof145;
case 145:
	if ( (*p) == 69 )
		goto st146;
	goto st0;
st146:
	if ( ++p == pe )
		goto _test_eof146;
case 146:
	if ( (*p) == 83 )
		goto st147;
	goto st0;
st147:
	if ( ++p == pe )
		goto _test_eof147;
case 147:
	if ( (*p) == 37 )
		goto st148;
	goto st0;
st148:
	if ( ++p == pe )
		goto _test_eof148;
case 148:
	if ( (*p) == 10 )
		goto tr172;
	goto st0;
st149:
	if ( ++p == pe )
		goto _test_eof149;
case 149:
	if ( (*p) == 69 )
		goto st150;
	goto st0;
st150:
	if ( ++p == pe )
		goto _test_eof150;
case 150:
	if ( (*p) == 80 )
		goto st151;
	goto st0;
st151:
	if ( ++p == pe )
		goto _test_eof151;
case 151:
	if ( (*p) == 76 )
		goto st152;
	goto st0;
st152:
	if ( ++p == pe )
		goto _test_eof152;
case 152:
	if ( (*p) == 65 )
		goto st153;
	goto st0;
st153:
	if ( ++p == pe )
		goto _test_eof153;
case 153:
	if ( (*p) == 67 )
		goto st154;
	goto st0;
st154:
	if ( ++p == pe )
		goto _test_eof154;
case 154:
	if ( (*p) == 69 )
		goto st155;
	goto st0;
st155:
	if ( ++p == pe )
		goto _test_eof155;
case 155:
	if ( (*p) == 83 )
		goto st156;
	goto st0;
st156:
	if ( ++p == pe )
		goto _test_eof156;
case 156:
	if ( (*p) == 37 )
		goto st157;
	goto st0;
st157:
	if ( ++p == pe )
		goto _test_eof157;
case 157:
	if ( (*p) == 10 )
		goto tr181;
	goto st0;
st158:
	if ( ++p == pe )
		goto _test_eof158;
case 158:
	if ( (*p) == 72 )
		goto st159;
	goto st0;
st159:
	if ( ++p == pe )
		goto _test_eof159;
case 159:
	if ( (*p) == 65 )
		goto st160;
	goto st0;
st160:
	if ( ++p == pe )
		goto _test_eof160;
case 160:
	if ( (*p) == 50 )
		goto st161;
	goto st0;
st161:
	if ( ++p == pe )
		goto _test_eof161;
case 161:
	if ( (*p) == 53 )
		goto st162;
	goto st0;
st162:
	if ( ++p == pe )
		goto _test_eof162;
case 162:
	if ( (*p) == 54 )
		goto st163;
	goto st0;
st163:
	if ( ++p == pe )
		goto _test_eof163;
case 163:
	if ( (*p) == 83 )
		goto st164;
	goto st0;
st164:
	if ( ++p == pe )
		goto _test_eof164;
case 164:
	if ( (*p) == 85 )
		goto st165;
	goto st0;
st165:
	if ( ++p == pe )
		goto _test_eof165;
case 165:
	if ( (*p) == 77 )
		goto st166;
	goto st0;
st166:
	if ( ++p == pe )
		goto _test_eof166;
case 166:
	if ( (*p) == 37 )
		goto st167;
	goto st0;
st167:
	if ( ++p == pe )
		goto _test_eof167;
case 167:
	if ( (*p) == 10 )
		goto tr191;
	goto st0;
st168:
	if ( ++p == pe )
		goto _test_eof168;
case 168:
	if ( (*p) == 82 )
		goto st169;
	goto st0;
st169:
	if ( ++p == pe )
		goto _test_eof169;
case 169:
	if ( (*p) == 76 )
		goto st170;
	goto st0;
st170:
	if ( ++p == pe )
		goto _test_eof170;
case 170:
	if ( (*p) == 37 )
		goto st171;
	goto st0;
st171:
	if ( ++p == pe )
		goto _test_eof171;
case 171:
	if ( (*p) == 10 )
		goto tr195;
	goto st0;
st172:
	if ( ++p == pe )
		goto _test_eof172;
case 172:
	if ( (*p) == 69 )
		goto st173;
	goto st0;
st173:
	if ( ++p == pe )
		goto _test_eof173;
case 173:
	if ( (*p) == 82 )
		goto st174;
	goto st0;
st174:
	if ( ++p == pe )
		goto _test_eof174;
case 174:
	if ( (*p) == 83 )
		goto st175;
	goto st0;
st175:
	if ( ++p == pe )
		goto _test_eof175;
case 175:
	if ( (*p) == 73 )
		goto st176;
	goto st0;
st176:
	if ( ++p == pe )
		goto _test_eof176;
case 176:
	if ( (*p) == 79 )
		goto st177;
	goto st0;
st177:
	if ( ++p == pe )
		goto _test_eof177;
case 177:
	if ( (*p) == 78 )
		goto st178;
	goto st0;
st178:
	if ( ++p == pe )
		goto _test_eof178;
case 178:
	if ( (*p) == 37 )
		goto st179;
	goto st0;
st179:
	if ( ++p == pe )
		goto _test_eof179;
case 179:
	if ( (*p) == 10 )
		goto tr203;
	goto st0;
	}
	_test_eof180:  parser->cs = 180; goto _test_eof; 
	_test_eof1:  parser->cs = 1; goto _test_eof; 
	_test_eof2:  parser->cs = 2; goto _test_eof; 
	_test_eof3:  parser->cs = 3; goto _test_eof; 
	_test_eof4:  parser->cs = 4; goto _test_eof; 
	_test_eof5:  parser->cs = 5; goto _test_eof; 
	_test_eof6:  parser->cs = 6; goto _test_eof; 
	_test_eof7:  parser->cs = 7; goto _test_eof; 
	_test_eof8:  parser->cs = 8; goto _test_eof; 
	_test_eof9:  parser->cs = 9; goto _test_eof; 
	_test_eof10:  parser->cs = 10; goto _test_eof; 
	_test_eof11:  parser->cs = 11; goto _test_eof; 
	_test_eof12:  parser->cs = 12; goto _test_eof; 
	_test_eof13:  parser->cs = 13; goto _test_eof; 
	_test_eof14:  parser->cs = 14; goto _test_eof; 
	_test_eof15:  parser->cs = 15; goto _test_eof; 
	_test_eof16:  parser->cs = 16; goto _test_eof; 
	_test_eof17:  parser->cs = 17; goto _test_eof; 
	_test_eof18:  parser->cs = 18; goto _test_eof; 
	_test_eof19:  parser->cs = 19; goto _test_eof; 
	_test_eof20:  parser->cs = 20; goto _test_eof; 
	_test_eof21:  parser->cs = 21; goto _test_eof; 
	_test_eof22:  parser->cs = 22; goto _test_eof; 
	_test_eof23:  parser->cs = 23; goto _test_eof; 
	_test_eof24:  parser->cs = 24; goto _test_eof; 
	_test_eof25:  parser->cs = 25; goto _test_eof; 
	_test_eof26:  parser->cs = 26; goto _test_eof; 
	_test_eof27:  parser->cs = 27; goto _test_eof; 
	_test_eof28:  parser->cs = 28; goto _test_eof; 
	_test_eof29:  parser->cs = 29; goto _test_eof; 
	_test_eof30:  parser->cs = 30; goto _test_eof; 
	_test_eof31:  parser->cs = 31; goto _test_eof; 
	_test_eof32:  parser->cs = 32; goto _test_eof; 
	_test_eof33:  parser->cs = 33; goto _test_eof; 
	_test_eof34:  parser->cs = 34; goto _test_eof; 
	_test_eof35:  parser->cs = 35; goto _test_eof; 
	_test_eof36:  parser->cs = 36; goto _test_eof; 
	_test_eof37:  parser->cs = 37; goto _test_eof; 
	_test_eof38:  parser->cs = 38; goto _test_eof; 
	_test_eof39:  parser->cs = 39; goto _test_eof; 
	_test_eof40:  parser->cs = 40; goto _test_eof; 
	_test_eof41:  parser->cs = 41; goto _test_eof; 
	_test_eof42:  parser->cs = 42; goto _test_eof; 
	_test_eof43:  parser->cs = 43; goto _test_eof; 
	_test_eof44:  parser->cs = 44; goto _test_eof; 
	_test_eof45:  parser->cs = 45; goto _test_eof; 
	_test_eof46:  parser->cs = 46; goto _test_eof; 
	_test_eof47:  parser->cs = 47; goto _test_eof; 
	_test_eof48:  parser->cs = 48; goto _test_eof; 
	_test_eof49:  parser->cs = 49; goto _test_eof; 
	_test_eof50:  parser->cs = 50; goto _test_eof; 
	_test_eof51:  parser->cs = 51; goto _test_eof; 
	_test_eof52:  parser->cs = 52; goto _test_eof; 
	_test_eof53:  parser->cs = 53; goto _test_eof; 
	_test_eof54:  parser->cs = 54; goto _test_eof; 
	_test_eof55:  parser->cs = 55; goto _test_eof; 
	_test_eof56:  parser->cs = 56; goto _test_eof; 
	_test_eof57:  parser->cs = 57; goto _test_eof; 
	_test_eof58:  parser->cs = 58; goto _test_eof; 
	_test_eof59:  parser->cs = 59; goto _test_eof; 
	_test_eof60:  parser->cs = 60; goto _test_eof; 
	_test_eof61:  parser->cs = 61; goto _test_eof; 
	_test_eof62:  parser->cs = 62; goto _test_eof; 
	_test_eof63:  parser->cs = 63; goto _test_eof; 
	_test_eof64:  parser->cs = 64; goto _test_eof; 
	_test_eof65:  parser->cs = 65; goto _test_eof; 
	_test_eof66:  parser->cs = 66; goto _test_eof; 
	_test_eof67:  parser->cs = 67; goto _test_eof; 
	_test_eof68:  parser->cs = 68; goto _test_eof; 
	_test_eof69:  parser->cs = 69; goto _test_eof; 
	_test_eof70:  parser->cs = 70; goto _test_eof; 
	_test_eof71:  parser->cs = 71; goto _test_eof; 
	_test_eof72:  parser->cs = 72; goto _test_eof; 
	_test_eof73:  parser->cs = 73; goto _test_eof; 
	_test_eof74:  parser->cs = 74; goto _test_eof; 
	_test_eof75:  parser->cs = 75; goto _test_eof; 
	_test_eof76:  parser->cs = 76; goto _test_eof; 
	_test_eof77:  parser->cs = 77; goto _test_eof; 
	_test_eof78:  parser->cs = 78; goto _test_eof; 
	_test_eof79:  parser->cs = 79; goto _test_eof; 
	_test_eof80:  parser->cs = 80; goto _test_eof; 
	_test_eof81:  parser->cs = 81; goto _test_eof; 
	_test_eof82:  parser->cs = 82; goto _test_eof; 
	_test_eof83:  parser->cs = 83; goto _test_eof; 
	_test_eof84:  parser->cs = 84; goto _test_eof; 
	_test_eof85:  parser->cs = 85; goto _test_eof; 
	_test_eof86:  parser->cs = 86; goto _test_eof; 
	_test_eof87:  parser->cs = 87; goto _test_eof; 
	_test_eof88:  parser->cs = 88; goto _test_eof; 
	_test_eof89:  parser->cs = 89; goto _test_eof; 
	_test_eof90:  parser->cs = 90; goto _test_eof; 
	_test_eof91:  parser->cs = 91; goto _test_eof; 
	_test_eof92:  parser->cs = 92; goto _test_eof; 
	_test_eof93:  parser->cs = 93; goto _test_eof; 
	_test_eof94:  parser->cs = 94; goto _test_eof; 
	_test_eof95:  parser->cs = 95; goto _test_eof; 
	_test_eof96:  parser->cs = 96; goto _test_eof; 
	_test_eof97:  parser->cs = 97; goto _test_eof; 
	_test_eof98:  parser->cs = 98; goto _test_eof; 
	_test_eof99:  parser->cs = 99; goto _test_eof; 
	_test_eof100:  parser->cs = 100; goto _test_eof; 
	_test_eof101:  parser->cs = 101; goto _test_eof; 
	_test_eof102:  parser->cs = 102; goto _test_eof; 
	_test_eof103:  parser->cs = 103; goto _test_eof; 
	_test_eof104:  parser->cs = 104; goto _test_eof; 
	_test_eof105:  parser->cs = 105; goto _test_eof; 
	_test_eof106:  parser->cs = 106; goto _test_eof; 
	_test_eof107:  parser->cs = 107; goto _test_eof; 
	_test_eof108:  parser->cs = 108; goto _test_eof; 
	_test_eof109:  parser->cs = 109; goto _test_eof; 
	_test_eof110:  parser->cs = 110; goto _test_eof; 
	_test_eof111:  parser->cs = 111; goto _test_eof; 
	_test_eof112:  parser->cs = 112; goto _test_eof; 
	_test_eof113:  parser->cs = 113; goto _test_eof; 
	_test_eof114:  parser->cs = 114; goto _test_eof; 
	_test_eof115:  parser->cs = 115; goto _test_eof; 
	_test_eof116:  parser->cs = 116; goto _test_eof; 
	_test_eof117:  parser->cs = 117; goto _test_eof; 
	_test_eof118:  parser->cs = 118; goto _test_eof; 
	_test_eof119:  parser->cs = 119; goto _test_eof; 
	_test_eof120:  parser->cs = 120; goto _test_eof; 
	_test_eof121:  parser->cs = 121; goto _test_eof; 
	_test_eof122:  parser->cs = 122; goto _test_eof; 
	_test_eof123:  parser->cs = 123; goto _test_eof; 
	_test_eof124:  parser->cs = 124; goto _test_eof; 
	_test_eof125:  parser->cs = 125; goto _test_eof; 
	_test_eof126:  parser->cs = 126; goto _test_eof; 
	_test_eof127:  parser->cs = 127; goto _test_eof; 
	_test_eof128:  parser->cs = 128; goto _test_eof; 
	_test_eof129:  parser->cs = 129; goto _test_eof; 
	_test_eof130:  parser->cs = 130; goto _test_eof; 
	_test_eof131:  parser->cs = 131; goto _test_eof; 
	_test_eof132:  parser->cs = 132; goto _test_eof; 
	_test_eof133:  parser->cs = 133; goto _test_eof; 
	_test_eof134:  parser->cs = 134; goto _test_eof; 
	_test_eof135:  parser->cs = 135; goto _test_eof; 
	_test_eof136:  parser->cs = 136; goto _test_eof; 
	_test_eof137:  parser->cs = 137; goto _test_eof; 
	_test_eof138:  parser->cs = 138; goto _test_eof; 
	_test_eof139:  parser->cs = 139; goto _test_eof; 
	_test_eof140:  parser->cs = 140; goto _test_eof; 
	_test_eof141:  parser->cs = 141; goto _test_eof; 
	_test_eof142:  parser->cs = 142; goto _test_eof; 
	_test_eof143:  parser->cs = 143; goto _test_eof; 
	_test_eof144:  parser->cs = 144; goto _test_eof; 
	_test_eof145:  parser->cs = 145; goto _test_eof; 
	_test_eof146:  parser->cs = 146; goto _test_eof; 
	_test_eof147:  parser->cs = 147; goto _test_eof; 
	_test_eof148:  parser->cs = 148; goto _test_eof; 
	_test_eof149:  parser->cs = 149; goto _test_eof; 
	_test_eof150:  parser->cs = 150; goto _test_eof; 
	_test_eof151:  parser->cs = 151; goto _test_eof; 
	_test_eof152:  parser->cs = 152; goto _test_eof; 
	_test_eof153:  parser->cs = 153; goto _test_eof; 
	_test_eof154:  parser->cs = 154; goto _test_eof; 
	_test_eof155:  parser->cs = 155; goto _test_eof; 
	_test_eof156:  parser->cs = 156; goto _test_eof; 
	_test_eof157:  parser->cs = 157; goto _test_eof; 
	_test_eof158:  parser->cs = 158; goto _test_eof; 
	_test_eof159:  parser->cs = 159; goto _test_eof; 
	_test_eof160:  parser->cs = 160; goto _test_eof; 
	_test_eof161:  parser->cs = 161; goto _test_eof; 
	_test_eof162:  parser->cs = 162; goto _test_eof; 
	_test_eof163:  parser->cs = 163; goto _test_eof; 
	_test_eof164:  parser->cs = 164; goto _test_eof; 
	_test_eof165:  parser->cs = 165; goto _test_eof; 
	_test_eof166:  parser->cs = 166; goto _test_eof; 
	_test_eof167:  parser->cs = 167; goto _test_eof; 
	_test_eof168:  parser->cs = 168; goto _test_eof; 
	_test_eof169:  parser->cs = 169; goto _test_eof; 
	_test_eof170:  parser->cs = 170; goto _test_eof; 
	_test_eof171:  parser->cs = 171; goto _test_eof; 
	_test_eof172:  parser->cs = 172; goto _test_eof; 
	_test_eof173:  parser->cs = 173; goto _test_eof; 
	_test_eof174:  parser->cs = 174; goto _test_eof; 
	_test_eof175:  parser->cs = 175; goto _test_eof; 
	_test_eof176:  parser->cs = 176; goto _test_eof; 
	_test_eof177:  parser->cs = 177; goto _test_eof; 
	_test_eof178:  parser->cs = 178; goto _test_eof; 
	_test_eof179:  parser->cs = 179; goto _test_eof; 

	_test_eof: {}
	_out: {}
	}

#line 74 "src/desc.rl"

    (void)desc_en_main;
    if (parser->cs == desc_error)
        return -1;

    return buf_len;
}

ssize_t read_desc(struct archive *archive, struct pkg *pkg)
{
    char *buf;
    ssize_t nbytes_r = 0;
    struct desc_parser parser;
    desc_parser_init(&parser);

    for (;;) {
        size_t bufsize;
        archive_read(archive, &buf, &bufsize);

        ssize_t result = desc_parser_feed(&parser, pkg, buf, bufsize);
        if (result < 0) {
            return result;
        } else {
            nbytes_r += result;
        }

        break;
    }

    return nbytes_r;
}
