/* This file is autogenerated. DO NOT CHANGE. All changes will be lost */

#include "google/protobuf/timestamp.qpb.h"
#include <QtCore/QTimeZone>
#include <QtProtobuf/qprotobufserializer.h>
#include <cmath>

namespace google::protobuf {

class Timestamp_QtProtobufData : public QSharedData
{
public:
    Timestamp_QtProtobufData()
        : QSharedData(),
          m_seconds(0),
          m_nanos(0)
    {
    }

    Timestamp_QtProtobufData(const Timestamp_QtProtobufData &other)
        : QSharedData(other),
          m_seconds(other.m_seconds),
          m_nanos(other.m_nanos)
    {
    }

    QtProtobuf::int64 m_seconds;
    QtProtobuf::int32 m_nanos;
};

Timestamp::~Timestamp() = default;

static constexpr struct {
    QtProtobufPrivate::QProtobufPropertyOrdering::Data data;
    const std::array<uint, 9> qt_protobuf_Timestamp_uint_data;
    const char qt_protobuf_Timestamp_char_data[41];
} qt_protobuf_Timestamp_metadata {
    // data
    {
        0, /* = version */
        2, /* = num fields */
        3, /* = field number offset */
        5, /* = property index offset */
        7, /* = field flags offset */
        25, /* = message full name length */
    },
    // uint_data
    {
        // JSON name offsets:
        26, /* = seconds */
        34, /* = nanos */
        40, /* = end-of-string-marker */
        // Field numbers:
        1, /* = seconds */
        2, /* = nanos */
        // Property indices:
        0, /* = seconds */
        1, /* = nanos */
        // Field flags:
        QtProtobufPrivate::NoFlags, /* = seconds */
        QtProtobufPrivate::NoFlags, /* = nanos */
    },
    // char_data
    /* metadata char_data: */
    "google.protobuf.Timestamp\0" /* = full message name */
    /* field char_data: */
    "seconds\0nanos\0"
};

const QtProtobufPrivate::QProtobufPropertyOrdering Timestamp::propertyOrdering = {
    &qt_protobuf_Timestamp_metadata.data
};

void Timestamp::registerTypes()
{
    qRegisterMetaType<Timestamp>();
    qRegisterMetaType<TimestampRepeated>();
}

Timestamp::Timestamp()
    : QProtobufMessage(&Timestamp::staticMetaObject),
      dptr(new Timestamp_QtProtobufData)
{
}

Timestamp::Timestamp(const Timestamp &other)
    : QProtobufMessage(other),
      dptr(other.dptr)
{
}
Timestamp &Timestamp::operator =(const Timestamp &other)
{
    QProtobufMessage::operator=(other);
    dptr = other.dptr;
    return *this;
}
Timestamp::Timestamp(Timestamp &&other) noexcept
    : QProtobufMessage(std::move(other)),
      dptr(std::move(other.dptr))
{
}
Timestamp &Timestamp::operator =(Timestamp &&other) noexcept
{
    QProtobufMessage::operator=(std::move(other));
    dptr.swap(other.dptr);
    return *this;
}
bool Timestamp::operator ==(const Timestamp &other) const
{
    return QProtobufMessage::isEqual(*this, other)
        && dptr->m_seconds == other.dptr->m_seconds
        && dptr->m_nanos == other.dptr->m_nanos;
}

bool Timestamp::operator !=(const Timestamp &other) const
{
    return !this->operator ==(other);
}

QtProtobuf::int64 Timestamp::seconds() const
{
    return dptr->m_seconds;
}

QtProtobuf::int32 Timestamp::nanos() const
{
    return dptr->m_nanos;
}

void Timestamp::setSeconds(const QtProtobuf::int64 &seconds)
{
    if (dptr->m_seconds != seconds) {
        dptr.detach();
        dptr->m_seconds = seconds;
    }
}

void Timestamp::setNanos(const QtProtobuf::int32 &nanos)
{
    if (dptr->m_nanos != nanos) {
        dptr.detach();
        dptr->m_nanos = nanos;
    }
}

Timestamp Timestamp::fromDateTime(const QDateTime &dateTime)
{
    Timestamp ts;
    ts.setSeconds(dateTime.toMSecsSinceEpoch() / 1000);
    ts.setNanos((dateTime.toMSecsSinceEpoch() % 1000) * 1000000);
    return ts;
}

QDateTime Timestamp::toDateTime() const
{
    return QDateTime::fromMSecsSinceEpoch(
            seconds() * 1000 + nanos() / 1000000, QTimeZone(QTimeZone::UTC));
}

} // namespace google::protobuf

#include "moc_timestamp.qpb.cpp"
