/*
QmidiCtl - A MIDI remote controller via IP/UDP multicast.

   Copyright (C) 2010-2023, rncbc aka Rui Nuno Capela. All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 
*/

/********************************************************************************
** Form generated from reading UI file 'qmidictlOptionsForm.ui'
**
** Created by: Qt User Interface Compiler version 6.6.1
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_QMIDICTLOPTIONSFORM_H
#define UI_QMIDICTLOPTIONSFORM_H

#include <QtCore/QVariant>
#include <QtGui/QIcon>
#include <QtWidgets/QAbstractButton>
#include <QtWidgets/QApplication>
#include <QtWidgets/QComboBox>
#include <QtWidgets/QDialog>
#include <QtWidgets/QDialogButtonBox>
#include <QtWidgets/QGridLayout>
#include <QtWidgets/QGroupBox>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QLabel>
#include <QtWidgets/QSpacerItem>
#include <QtWidgets/QSpinBox>
#include <QtWidgets/QVBoxLayout>

QT_BEGIN_NAMESPACE

class Ui_qmidictlOptionsForm
{
public:
    QVBoxLayout *MainCentralLayout;
    QHBoxLayout *hboxLayout;
    QVBoxLayout *vboxLayout;
    QGroupBox *MidiGroupBox;
    QGridLayout *gridLayout;
    QLabel *MmcDeviceTextLabel;
    QSpinBox *MmcDeviceSpinBox;
    QSpacerItem *spacerItem;
    QGroupBox *NetworkGroupBox;
    QGridLayout *gridLayout1;
    QLabel *InterfaceTextLabel;
    QComboBox *InterfaceComboBox;
    QLabel *UdpAddrTextLabel;
    QComboBox *UdpAddrComboBox;
    QLabel *UdpPortTextLabel;
    QSpinBox *UdpPortSpinBox;
    QSpacerItem *spacerItem1;
    QDialogButtonBox *DialogButtonBox;

    void setupUi(QDialog *qmidictlOptionsForm)
    {
        if (qmidictlOptionsForm->objectName().isEmpty())
            qmidictlOptionsForm->setObjectName("qmidictlOptionsForm");
        qmidictlOptionsForm->resize(320, 240);
        const QIcon icon = QIcon(QString::fromUtf8(":/images/qmidictl.svg"));
        qmidictlOptionsForm->setWindowIcon(icon);
        MainCentralLayout = new QVBoxLayout(qmidictlOptionsForm);
        MainCentralLayout->setSpacing(8);
        MainCentralLayout->setContentsMargins(0, 0, 0, 0);
        MainCentralLayout->setObjectName("MainCentralLayout");
        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(8);
        hboxLayout->setContentsMargins(8, 8, 8, 8);
        hboxLayout->setObjectName("hboxLayout");
        vboxLayout = new QVBoxLayout();
        vboxLayout->setSpacing(8);
        vboxLayout->setObjectName("vboxLayout");
        MidiGroupBox = new QGroupBox(qmidictlOptionsForm);
        MidiGroupBox->setObjectName("MidiGroupBox");
        QFont font;
        font.setBold(true);
        MidiGroupBox->setFont(font);
        MidiGroupBox->setFlat(true);
        gridLayout = new QGridLayout(MidiGroupBox);
        gridLayout->setSpacing(8);
        gridLayout->setContentsMargins(8, 8, 8, 8);
        gridLayout->setObjectName("gridLayout");
        MmcDeviceTextLabel = new QLabel(MidiGroupBox);
        MmcDeviceTextLabel->setObjectName("MmcDeviceTextLabel");
        QFont font1;
        font1.setBold(false);
        MmcDeviceTextLabel->setFont(font1);

        gridLayout->addWidget(MmcDeviceTextLabel, 0, 0, 1, 1);

        MmcDeviceSpinBox = new QSpinBox(MidiGroupBox);
        MmcDeviceSpinBox->setObjectName("MmcDeviceSpinBox");
        MmcDeviceSpinBox->setFont(font1);
        MmcDeviceSpinBox->setAccelerated(true);
        MmcDeviceSpinBox->setMaximum(127);
        MmcDeviceSpinBox->setValue(127);

        gridLayout->addWidget(MmcDeviceSpinBox, 0, 1, 1, 1);

        spacerItem = new QSpacerItem(20, 8, QSizePolicy::Minimum, QSizePolicy::Expanding);

        gridLayout->addItem(spacerItem, 1, 0, 1, 4);


        vboxLayout->addWidget(MidiGroupBox);

        NetworkGroupBox = new QGroupBox(qmidictlOptionsForm);
        NetworkGroupBox->setObjectName("NetworkGroupBox");
        NetworkGroupBox->setFont(font);
        NetworkGroupBox->setFlat(true);
        gridLayout1 = new QGridLayout(NetworkGroupBox);
        gridLayout1->setSpacing(8);
        gridLayout1->setContentsMargins(8, 8, 8, 8);
        gridLayout1->setObjectName("gridLayout1");
        InterfaceTextLabel = new QLabel(NetworkGroupBox);
        InterfaceTextLabel->setObjectName("InterfaceTextLabel");
        InterfaceTextLabel->setFont(font1);

        gridLayout1->addWidget(InterfaceTextLabel, 0, 0, 1, 1);

        InterfaceComboBox = new QComboBox(NetworkGroupBox);
        InterfaceComboBox->setObjectName("InterfaceComboBox");
        InterfaceComboBox->setFont(font1);
        InterfaceComboBox->setEditable(true);

        gridLayout1->addWidget(InterfaceComboBox, 0, 1, 1, 1);

        UdpAddrTextLabel = new QLabel(NetworkGroupBox);
        UdpAddrTextLabel->setObjectName("UdpAddrTextLabel");
        UdpAddrTextLabel->setFont(font1);

        gridLayout1->addWidget(UdpAddrTextLabel, 1, 0, 1, 1);

        UdpAddrComboBox = new QComboBox(NetworkGroupBox);
        UdpAddrComboBox->setObjectName("UdpAddrComboBox");
        UdpAddrComboBox->setFont(font1);
        UdpAddrComboBox->setEditable(true);

        gridLayout1->addWidget(UdpAddrComboBox, 1, 1, 1, 2);

        UdpPortTextLabel = new QLabel(NetworkGroupBox);
        UdpPortTextLabel->setObjectName("UdpPortTextLabel");
        UdpPortTextLabel->setFont(font1);

        gridLayout1->addWidget(UdpPortTextLabel, 2, 0, 1, 1);

        UdpPortSpinBox = new QSpinBox(NetworkGroupBox);
        UdpPortSpinBox->setObjectName("UdpPortSpinBox");
        UdpPortSpinBox->setFont(font1);
        UdpPortSpinBox->setAccelerated(true);
        UdpPortSpinBox->setMaximum(65535);

        gridLayout1->addWidget(UdpPortSpinBox, 2, 1, 1, 1);

        spacerItem1 = new QSpacerItem(20, 8, QSizePolicy::Minimum, QSizePolicy::Expanding);

        gridLayout1->addItem(spacerItem1, 3, 0, 1, 4);


        vboxLayout->addWidget(NetworkGroupBox);


        hboxLayout->addLayout(vboxLayout);

        DialogButtonBox = new QDialogButtonBox(qmidictlOptionsForm);
        DialogButtonBox->setObjectName("DialogButtonBox");
        DialogButtonBox->setOrientation(Qt::Vertical);
        DialogButtonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok|QDialogButtonBox::Reset);

        hboxLayout->addWidget(DialogButtonBox);


        MainCentralLayout->addLayout(hboxLayout);

#if QT_CONFIG(shortcut)
        MmcDeviceTextLabel->setBuddy(MmcDeviceSpinBox);
        InterfaceTextLabel->setBuddy(InterfaceComboBox);
        UdpAddrTextLabel->setBuddy(UdpAddrComboBox);
        UdpPortTextLabel->setBuddy(UdpPortSpinBox);
#endif // QT_CONFIG(shortcut)
        QWidget::setTabOrder(MmcDeviceSpinBox, InterfaceComboBox);
        QWidget::setTabOrder(InterfaceComboBox, UdpAddrComboBox);
        QWidget::setTabOrder(UdpAddrComboBox, UdpPortSpinBox);
        QWidget::setTabOrder(UdpPortSpinBox, DialogButtonBox);

        retranslateUi(qmidictlOptionsForm);

        QMetaObject::connectSlotsByName(qmidictlOptionsForm);
    } // setupUi

    void retranslateUi(QDialog *qmidictlOptionsForm)
    {
        qmidictlOptionsForm->setWindowTitle(QCoreApplication::translate("qmidictlOptionsForm", "Options", nullptr));
        MidiGroupBox->setTitle(QCoreApplication::translate("qmidictlOptionsForm", "MIDI", nullptr));
        MmcDeviceTextLabel->setText(QCoreApplication::translate("qmidictlOptionsForm", "MMC &Device:", nullptr));
        NetworkGroupBox->setTitle(QCoreApplication::translate("qmidictlOptionsForm", "Network", nullptr));
        InterfaceTextLabel->setText(QCoreApplication::translate("qmidictlOptionsForm", "&Interface:", nullptr));
        UdpAddrTextLabel->setText(QCoreApplication::translate("qmidictlOptionsForm", "&UDP Address:", nullptr));
        UdpPortTextLabel->setText(QCoreApplication::translate("qmidictlOptionsForm", "UDP &Port:", nullptr));
    } // retranslateUi

};

namespace Ui {
    class qmidictlOptionsForm: public Ui_qmidictlOptionsForm {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_QMIDICTLOPTIONSFORM_H
