/*
QmidiCtl - A MIDI remote controller via IP/UDP multicast.

   Copyright (C) 2010-2024, rncbc aka Rui Nuno Capela. All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 
*/

/********************************************************************************
** Form generated from reading UI file 'qmidictlMainForm.ui'
**
** Created by: Qt User Interface Compiler version 6.6.1
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_QMIDICTLMAINFORM_H
#define UI_QMIDICTLMAINFORM_H

#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QIcon>
#include <QtWidgets/QApplication>
#include <QtWidgets/QDial>
#include <QtWidgets/QGridLayout>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QLabel>
#include <QtWidgets/QMainWindow>
#include <QtWidgets/QMenuBar>
#include <QtWidgets/QPushButton>
#include <QtWidgets/QSpacerItem>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QWidget>
#include "qmidictlMixerStrip.h"

QT_BEGIN_NAMESPACE

class Ui_qmidictlMainForm
{
public:
    QAction *optionsAction;
    QAction *configureAction;
    QAction *aboutAction;
    QAction *exitAction;
    QMenuBar *MainMenuBar;
    QWidget *MainCentralWidget;
    QVBoxLayout *MainCentralLayout;
    QGridLayout *gridLayout;
    QHBoxLayout *hboxLayout;
    QSpacerItem *spacerItem;
    QLabel *midiInTextLabel;
    QLabel *midiInLedLabel;
    QLabel *midiOutTextLabel;
    QLabel *midiOutLedLabel;
    QHBoxLayout *hboxLayout1;
    qmidictlMixerStrip *strip1;
    qmidictlMixerStrip *strip2;
    qmidictlMixerStrip *strip3;
    qmidictlMixerStrip *strip4;
    QDial *jogWheelDial;
    QHBoxLayout *hboxLayout2;
    QPushButton *resetButton;
    QPushButton *rewindButton;
    QPushButton *playButton;
    QPushButton *stopButton;
    QPushButton *recordButton;
    QPushButton *forwardButton;
    QHBoxLayout *hboxLayout3;
    QPushButton *prevStripPageButton;
    QSpacerItem *spacerItem1;
    QPushButton *nextStripPageButton;

    void setupUi(QMainWindow *qmidictlMainForm)
    {
        if (qmidictlMainForm->objectName().isEmpty())
            qmidictlMainForm->setObjectName("qmidictlMainForm");
        qmidictlMainForm->resize(480, 240);
        const QIcon icon = QIcon(QString::fromUtf8(":/images/qmidictl.svg"));
        qmidictlMainForm->setWindowIcon(icon);
        optionsAction = new QAction(qmidictlMainForm);
        optionsAction->setObjectName("optionsAction");
        configureAction = new QAction(qmidictlMainForm);
        configureAction->setObjectName("configureAction");
        aboutAction = new QAction(qmidictlMainForm);
        aboutAction->setObjectName("aboutAction");
        exitAction = new QAction(qmidictlMainForm);
        exitAction->setObjectName("exitAction");
        MainMenuBar = new QMenuBar(qmidictlMainForm);
        MainMenuBar->setObjectName("MainMenuBar");
        qmidictlMainForm->setMenuBar(MainMenuBar);
        MainCentralWidget = new QWidget(qmidictlMainForm);
        MainCentralWidget->setObjectName("MainCentralWidget");
        MainCentralLayout = new QVBoxLayout(MainCentralWidget);
        MainCentralLayout->setSpacing(8);
        MainCentralLayout->setContentsMargins(0, 0, 0, 0);
        MainCentralLayout->setObjectName("MainCentralLayout");
        gridLayout = new QGridLayout();
        gridLayout->setSpacing(0);
        gridLayout->setContentsMargins(4, 4, 4, 4);
        gridLayout->setObjectName("gridLayout");
        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(8);
        hboxLayout->setObjectName("hboxLayout");
        spacerItem = new QSpacerItem(40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout->addItem(spacerItem);

        midiInTextLabel = new QLabel(MainCentralWidget);
        midiInTextLabel->setObjectName("midiInTextLabel");
        midiInTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);

        hboxLayout->addWidget(midiInTextLabel);

        midiInLedLabel = new QLabel(MainCentralWidget);
        midiInLedLabel->setObjectName("midiInLedLabel");
        midiInLedLabel->setPixmap(QPixmap(QString::fromUtf8(":/images/ledOff.png")));

        hboxLayout->addWidget(midiInLedLabel);

        midiOutTextLabel = new QLabel(MainCentralWidget);
        midiOutTextLabel->setObjectName("midiOutTextLabel");
        midiOutTextLabel->setAlignment(Qt::AlignRight|Qt::AlignTrailing|Qt::AlignVCenter);

        hboxLayout->addWidget(midiOutTextLabel);

        midiOutLedLabel = new QLabel(MainCentralWidget);
        midiOutLedLabel->setObjectName("midiOutLedLabel");
        midiOutLedLabel->setPixmap(QPixmap(QString::fromUtf8(":/images/ledOff.png")));

        hboxLayout->addWidget(midiOutLedLabel);


        gridLayout->addLayout(hboxLayout, 0, 1, 1, 1);

        hboxLayout1 = new QHBoxLayout();
        hboxLayout1->setSpacing(8);
        hboxLayout1->setContentsMargins(4, 4, 4, 4);
        hboxLayout1->setObjectName("hboxLayout1");
        strip1 = new qmidictlMixerStrip(MainCentralWidget);
        strip1->setObjectName("strip1");

        hboxLayout1->addWidget(strip1);

        strip2 = new qmidictlMixerStrip(MainCentralWidget);
        strip2->setObjectName("strip2");

        hboxLayout1->addWidget(strip2);

        strip3 = new qmidictlMixerStrip(MainCentralWidget);
        strip3->setObjectName("strip3");

        hboxLayout1->addWidget(strip3);

        strip4 = new qmidictlMixerStrip(MainCentralWidget);
        strip4->setObjectName("strip4");

        hboxLayout1->addWidget(strip4);


        gridLayout->addLayout(hboxLayout1, 1, 0, 1, 1);

        jogWheelDial = new QDial(MainCentralWidget);
        jogWheelDial->setObjectName("jogWheelDial");
        QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(jogWheelDial->sizePolicy().hasHeightForWidth());
        jogWheelDial->setSizePolicy(sizePolicy);
        jogWheelDial->setMinimumSize(QSize(220, 220));
        jogWheelDial->setFocusPolicy(Qt::NoFocus);
        jogWheelDial->setMaximum(100);
        jogWheelDial->setWrapping(true);

        gridLayout->addWidget(jogWheelDial, 1, 1, 1, 1);

        hboxLayout2 = new QHBoxLayout();
        hboxLayout2->setSpacing(8);
        hboxLayout2->setObjectName("hboxLayout2");
        resetButton = new QPushButton(MainCentralWidget);
        resetButton->setObjectName("resetButton");
        const QIcon icon1 = QIcon(QString::fromUtf8(":/images/formReset.png"));
        resetButton->setIcon(icon1);

        hboxLayout2->addWidget(resetButton);

        rewindButton = new QPushButton(MainCentralWidget);
        rewindButton->setObjectName("rewindButton");
        const QIcon icon2 = QIcon(QString::fromUtf8(":/images/formRewind.png"));
        rewindButton->setIcon(icon2);
        rewindButton->setCheckable(true);

        hboxLayout2->addWidget(rewindButton);

        playButton = new QPushButton(MainCentralWidget);
        playButton->setObjectName("playButton");
        const QIcon icon3 = QIcon(QString::fromUtf8(":/images/formPlay.png"));
        playButton->setIcon(icon3);
        playButton->setCheckable(true);

        hboxLayout2->addWidget(playButton);

        stopButton = new QPushButton(MainCentralWidget);
        stopButton->setObjectName("stopButton");
        const QIcon icon4 = QIcon(QString::fromUtf8(":/images/formStop.png"));
        stopButton->setIcon(icon4);

        hboxLayout2->addWidget(stopButton);

        recordButton = new QPushButton(MainCentralWidget);
        recordButton->setObjectName("recordButton");
        const QIcon icon5 = QIcon(QString::fromUtf8(":/images/formRecord.png"));
        recordButton->setIcon(icon5);
        recordButton->setCheckable(true);

        hboxLayout2->addWidget(recordButton);

        forwardButton = new QPushButton(MainCentralWidget);
        forwardButton->setObjectName("forwardButton");
        const QIcon icon6 = QIcon(QString::fromUtf8(":/images/formForward.png"));
        forwardButton->setIcon(icon6);
        forwardButton->setCheckable(true);

        hboxLayout2->addWidget(forwardButton);


        gridLayout->addLayout(hboxLayout2, 2, 0, 1, 2);

        hboxLayout3 = new QHBoxLayout();
        hboxLayout3->setSpacing(8);
        hboxLayout3->setObjectName("hboxLayout3");
        prevStripPageButton = new QPushButton(MainCentralWidget);
        prevStripPageButton->setObjectName("prevStripPageButton");
        prevStripPageButton->setMaximumSize(QSize(32, 16));

        hboxLayout3->addWidget(prevStripPageButton);

        spacerItem1 = new QSpacerItem(20, 8, QSizePolicy::Expanding, QSizePolicy::Minimum);

        hboxLayout3->addItem(spacerItem1);

        nextStripPageButton = new QPushButton(MainCentralWidget);
        nextStripPageButton->setObjectName("nextStripPageButton");
        nextStripPageButton->setMaximumSize(QSize(32, 16));

        hboxLayout3->addWidget(nextStripPageButton);


        gridLayout->addLayout(hboxLayout3, 0, 0, 1, 1);


        MainCentralLayout->addLayout(gridLayout);

        qmidictlMainForm->setCentralWidget(MainCentralWidget);
        QWidget::setTabOrder(prevStripPageButton, nextStripPageButton);
        QWidget::setTabOrder(nextStripPageButton, jogWheelDial);
        QWidget::setTabOrder(jogWheelDial, resetButton);
        QWidget::setTabOrder(resetButton, rewindButton);
        QWidget::setTabOrder(rewindButton, playButton);
        QWidget::setTabOrder(playButton, stopButton);
        QWidget::setTabOrder(stopButton, recordButton);
        QWidget::setTabOrder(recordButton, forwardButton);

        MainMenuBar->addAction(optionsAction);
        MainMenuBar->addAction(configureAction);
        MainMenuBar->addAction(aboutAction);
        MainMenuBar->addAction(exitAction);

        retranslateUi(qmidictlMainForm);

        QMetaObject::connectSlotsByName(qmidictlMainForm);
    } // setupUi

    void retranslateUi(QMainWindow *qmidictlMainForm)
    {
        optionsAction->setText(QCoreApplication::translate("qmidictlMainForm", "&Options", nullptr));
        configureAction->setText(QCoreApplication::translate("qmidictlMainForm", "&Configure", nullptr));
        aboutAction->setText(QCoreApplication::translate("qmidictlMainForm", "&About", nullptr));
        exitAction->setText(QCoreApplication::translate("qmidictlMainForm", "E&xit", nullptr));
        midiInTextLabel->setText(QCoreApplication::translate("qmidictlMainForm", "MIDI In", nullptr));
        midiOutTextLabel->setText(QCoreApplication::translate("qmidictlMainForm", "Out", nullptr));
        resetButton->setText(QCoreApplication::translate("qmidictlMainForm", "RS&T", nullptr));
        rewindButton->setText(QCoreApplication::translate("qmidictlMainForm", "RE&W", nullptr));
        playButton->setText(QCoreApplication::translate("qmidictlMainForm", "&PLAY", nullptr));
        stopButton->setText(QCoreApplication::translate("qmidictlMainForm", "&STOP", nullptr));
        recordButton->setText(QCoreApplication::translate("qmidictlMainForm", "&REC", nullptr));
        forwardButton->setText(QCoreApplication::translate("qmidictlMainForm", "&FFWD", nullptr));
        prevStripPageButton->setText(QCoreApplication::translate("qmidictlMainForm", "<", nullptr));
        nextStripPageButton->setText(QCoreApplication::translate("qmidictlMainForm", ">", nullptr));
        (void)qmidictlMainForm;
    } // retranslateUi

};

namespace Ui {
    class qmidictlMainForm: public Ui_qmidictlMainForm {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_QMIDICTLMAINFORM_H
