/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.3
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtOpenGL.h"

#line 26 "/build/pyqt6/src/PyQt6-6.7.0/sip/QtOpenGL/qopenglbuffer.sip"
#include <qopenglbuffer.h>
#line 29 "/build/pyqt6/src/PyQt6-6.7.0/build/QtOpenGL/sipQtOpenGLQOpenGLBuffer.cpp"

#line 25 "/build/pyqt6/src/PyQt6-6.7.0/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 33 "/build/pyqt6/src/PyQt6-6.7.0/build/QtOpenGL/sipQtOpenGLQOpenGLBuffer.cpp"


PyDoc_STRVAR(doc_QOpenGLBuffer_type, "type(self) -> QOpenGLBuffer.Type");

extern "C" {static PyObject *meth_QOpenGLBuffer_type(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            ::QOpenGLBuffer::Type sipRes;

            sipRes = sipCpp->type();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QOpenGLBuffer_Type);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_type, doc_QOpenGLBuffer_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_usagePattern, "usagePattern(self) -> QOpenGLBuffer.UsagePattern");

extern "C" {static PyObject *meth_QOpenGLBuffer_usagePattern(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_usagePattern(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            ::QOpenGLBuffer::UsagePattern sipRes;

            sipRes = sipCpp->usagePattern();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QOpenGLBuffer_UsagePattern);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_usagePattern, doc_QOpenGLBuffer_usagePattern);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_setUsagePattern, "setUsagePattern(self, value: QOpenGLBuffer.UsagePattern)");

extern "C" {static PyObject *meth_QOpenGLBuffer_setUsagePattern(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_setUsagePattern(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer::UsagePattern a0;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, sipType_QOpenGLBuffer_UsagePattern, &a0))
        {
            sipCpp->setUsagePattern(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_setUsagePattern, doc_QOpenGLBuffer_setUsagePattern);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_create, "create(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLBuffer_create(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_create(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->create();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_create, doc_QOpenGLBuffer_create);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_isCreated, "isCreated(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLBuffer_isCreated(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_isCreated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isCreated();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_isCreated, doc_QOpenGLBuffer_isCreated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_destroy, "destroy(self)");

extern "C" {static PyObject *meth_QOpenGLBuffer_destroy(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_destroy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            sipCpp->destroy();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_destroy, doc_QOpenGLBuffer_destroy);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_bind, "bind(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLBuffer_bind(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_bind(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->bind();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_bind, doc_QOpenGLBuffer_bind);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_release, "release(self)\n"
"release(type: QOpenGLBuffer.Type)");

extern "C" {static PyObject *meth_QOpenGLBuffer_release(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_release(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            sipCpp->release();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QOpenGLBuffer::Type a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CE", &sipSelf, sipType_QOpenGLBuffer_Type, &a0))
        {
            ::QOpenGLBuffer::release(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_release, doc_QOpenGLBuffer_release);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_bufferId, "bufferId(self) -> int");

extern "C" {static PyObject *meth_QOpenGLBuffer_bufferId(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_bufferId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->bufferId();

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_bufferId, doc_QOpenGLBuffer_bufferId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_size, "size(self) -> int");

extern "C" {static PyObject *meth_QOpenGLBuffer_size(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_size, doc_QOpenGLBuffer_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_read, "read(self, offset: int, data: Optional[PyQt6.sip.voidptr], count: int) -> bool");

extern "C" {static PyObject *meth_QOpenGLBuffer_read(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_read(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        void* a1;
        int a2;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bivi", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, &a0, &a1, &a2))
        {
            bool sipRes;

            sipRes = sipCpp->read(a0, a1, a2);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_read, doc_QOpenGLBuffer_read);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_write, "write(self, offset: int, data: Optional[PyQt6.sip.voidptr], count: int)");

extern "C" {static PyObject *meth_QOpenGLBuffer_write(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_write(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const void* a1;
        int a2;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bivi", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->write(a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_write, doc_QOpenGLBuffer_write);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_allocate, "allocate(self, data: Optional[PyQt6.sip.voidptr], count: int)\n"
"allocate(self, count: int)");

extern "C" {static PyObject *meth_QOpenGLBuffer_allocate(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_allocate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const void* a0;
        int a1;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bvi", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, &a0, &a1))
        {
            sipCpp->allocate(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, &a0))
        {
            sipCpp->allocate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_allocate, doc_QOpenGLBuffer_allocate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_map, "map(self, access: QOpenGLBuffer.Access) -> Optional[PyQt6.sip.voidptr]");

extern "C" {static PyObject *meth_QOpenGLBuffer_map(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_map(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer::Access a0;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, sipType_QOpenGLBuffer_Access, &a0))
        {
            void*sipRes;

            sipRes = sipCpp->map(a0);

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_map, doc_QOpenGLBuffer_map);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_unmap, "unmap(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLBuffer_unmap(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_unmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLBuffer, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->unmap();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_unmap, doc_QOpenGLBuffer_unmap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_mapRange, "mapRange(self, offset: int, count: int, access: QOpenGLBuffer.RangeAccessFlag) -> Optional[PyQt6.sip.voidptr]");

extern "C" {static PyObject *meth_QOpenGLBuffer_mapRange(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_mapRange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        ::QOpenGLBuffer::RangeAccessFlags* a2;
        int a2State = 0;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiiJ1", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, &a0, &a1, sipType_QFlags_0100QOpenGLBuffer_RangeAccessFlag, &a2, &a2State))
        {
            void*sipRes;

            sipRes = sipCpp->mapRange(a0, a1, *a2);
            sipReleaseType(a2, sipType_QFlags_0100QOpenGLBuffer_RangeAccessFlag, a2State);

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_mapRange, doc_QOpenGLBuffer_mapRange);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLBuffer_swap, "swap(self, other: QOpenGLBuffer)");

extern "C" {static PyObject *meth_QOpenGLBuffer_swap(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLBuffer_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLBuffer* a0;
        ::QOpenGLBuffer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QOpenGLBuffer, &sipCpp, sipType_QOpenGLBuffer, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLBuffer, sipName_swap, doc_QOpenGLBuffer_swap);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QOpenGLBuffer___len__(PyObject *);}
static Py_ssize_t slot_QOpenGLBuffer___len__(PyObject *sipSelf)
{
    ::QOpenGLBuffer *sipCpp = reinterpret_cast<::QOpenGLBuffer *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QOpenGLBuffer));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->size();
#line 530 "/build/pyqt6/src/PyQt6-6.7.0/build/QtOpenGL/sipQtOpenGLQOpenGLBuffer.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QOpenGLBuffer(void *, int);}
static void release_QOpenGLBuffer(void *sipCppV, int)
{
    delete reinterpret_cast<::QOpenGLBuffer *>(sipCppV);
}


extern "C" {static void *array_QOpenGLBuffer(Py_ssize_t);}
static void *array_QOpenGLBuffer(Py_ssize_t sipNrElem)
{
    return new ::QOpenGLBuffer[sipNrElem];
}


extern "C" {static void array_delete_QOpenGLBuffer(void *);}
static void array_delete_QOpenGLBuffer(void *sipCpp)
{
    delete[] reinterpret_cast<::QOpenGLBuffer *>(sipCpp);
}


extern "C" {static void assign_QOpenGLBuffer(void *, Py_ssize_t, void *);}
static void assign_QOpenGLBuffer(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::QOpenGLBuffer *>(sipDst)[sipDstIdx] = *reinterpret_cast<::QOpenGLBuffer *>(sipSrc);
}


extern "C" {static void *copy_QOpenGLBuffer(const void *, Py_ssize_t);}
static void *copy_QOpenGLBuffer(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QOpenGLBuffer(reinterpret_cast<const ::QOpenGLBuffer *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QOpenGLBuffer(sipSimpleWrapper *);}
static void dealloc_QOpenGLBuffer(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QOpenGLBuffer(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QOpenGLBuffer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QOpenGLBuffer(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QOpenGLBuffer *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QOpenGLBuffer();

            return sipCpp;
        }
    }

    {
        ::QOpenGLBuffer::Type a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QOpenGLBuffer_Type, &a0))
        {
            sipCpp = new ::QOpenGLBuffer(a0);

            return sipCpp;
        }
    }

    {
        const ::QOpenGLBuffer* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QOpenGLBuffer, &a0))
        {
            sipCpp = new ::QOpenGLBuffer(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QOpenGLBuffer[] = {
    {(void *)slot_QOpenGLBuffer___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QOpenGLBuffer[] = {
    {sipName_allocate, meth_QOpenGLBuffer_allocate, METH_VARARGS, doc_QOpenGLBuffer_allocate},
    {sipName_bind, meth_QOpenGLBuffer_bind, METH_VARARGS, doc_QOpenGLBuffer_bind},
    {sipName_bufferId, meth_QOpenGLBuffer_bufferId, METH_VARARGS, doc_QOpenGLBuffer_bufferId},
    {sipName_create, meth_QOpenGLBuffer_create, METH_VARARGS, doc_QOpenGLBuffer_create},
    {sipName_destroy, meth_QOpenGLBuffer_destroy, METH_VARARGS, doc_QOpenGLBuffer_destroy},
    {sipName_isCreated, meth_QOpenGLBuffer_isCreated, METH_VARARGS, doc_QOpenGLBuffer_isCreated},
    {sipName_map, meth_QOpenGLBuffer_map, METH_VARARGS, doc_QOpenGLBuffer_map},
    {sipName_mapRange, meth_QOpenGLBuffer_mapRange, METH_VARARGS, doc_QOpenGLBuffer_mapRange},
    {sipName_read, meth_QOpenGLBuffer_read, METH_VARARGS, doc_QOpenGLBuffer_read},
    {sipName_release, meth_QOpenGLBuffer_release, METH_VARARGS, doc_QOpenGLBuffer_release},
    {sipName_setUsagePattern, meth_QOpenGLBuffer_setUsagePattern, METH_VARARGS, doc_QOpenGLBuffer_setUsagePattern},
    {sipName_size, meth_QOpenGLBuffer_size, METH_VARARGS, doc_QOpenGLBuffer_size},
    {sipName_swap, meth_QOpenGLBuffer_swap, METH_VARARGS, doc_QOpenGLBuffer_swap},
    {sipName_type, meth_QOpenGLBuffer_type, METH_VARARGS, doc_QOpenGLBuffer_type},
    {sipName_unmap, meth_QOpenGLBuffer_unmap, METH_VARARGS, doc_QOpenGLBuffer_unmap},
    {sipName_usagePattern, meth_QOpenGLBuffer_usagePattern, METH_VARARGS, doc_QOpenGLBuffer_usagePattern},
    {sipName_write, meth_QOpenGLBuffer_write, METH_VARARGS, doc_QOpenGLBuffer_write}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QOpenGLBuffer[] = {
    {sipName_ReadOnly, static_cast<int>(::QOpenGLBuffer::ReadOnly)},
    {sipName_WriteOnly, static_cast<int>(::QOpenGLBuffer::WriteOnly)},
    {sipName_ReadWrite, static_cast<int>(::QOpenGLBuffer::ReadWrite)},
    {sipName_RangeRead, static_cast<int>(::QOpenGLBuffer::RangeRead)},
    {sipName_RangeWrite, static_cast<int>(::QOpenGLBuffer::RangeWrite)},
    {sipName_RangeInvalidate, static_cast<int>(::QOpenGLBuffer::RangeInvalidate)},
    {sipName_RangeInvalidateBuffer, static_cast<int>(::QOpenGLBuffer::RangeInvalidateBuffer)},
    {sipName_RangeFlushExplicit, static_cast<int>(::QOpenGLBuffer::RangeFlushExplicit)},
    {sipName_RangeUnsynchronized, static_cast<int>(::QOpenGLBuffer::RangeUnsynchronized)},
    {sipName_VertexBuffer, static_cast<int>(::QOpenGLBuffer::VertexBuffer)},
    {sipName_IndexBuffer, static_cast<int>(::QOpenGLBuffer::IndexBuffer)},
    {sipName_PixelPackBuffer, static_cast<int>(::QOpenGLBuffer::PixelPackBuffer)},
    {sipName_PixelUnpackBuffer, static_cast<int>(::QOpenGLBuffer::PixelUnpackBuffer)},
    {sipName_StreamDraw, static_cast<int>(::QOpenGLBuffer::StreamDraw)},
    {sipName_StreamRead, static_cast<int>(::QOpenGLBuffer::StreamRead)},
    {sipName_StreamCopy, static_cast<int>(::QOpenGLBuffer::StreamCopy)},
    {sipName_StaticDraw, static_cast<int>(::QOpenGLBuffer::StaticDraw)},
    {sipName_StaticRead, static_cast<int>(::QOpenGLBuffer::StaticRead)},
    {sipName_StaticCopy, static_cast<int>(::QOpenGLBuffer::StaticCopy)},
    {sipName_DynamicDraw, static_cast<int>(::QOpenGLBuffer::DynamicDraw)},
    {sipName_DynamicRead, static_cast<int>(::QOpenGLBuffer::DynamicRead)},
    {sipName_DynamicCopy, static_cast<int>(::QOpenGLBuffer::DynamicCopy)},
    {0, 0}
};

PyDoc_STRVAR(doc_QOpenGLBuffer, "\1QOpenGLBuffer()\n"
"QOpenGLBuffer(type: QOpenGLBuffer.Type)\n"
"QOpenGLBuffer(other: QOpenGLBuffer)");


sipClassTypeDef sipTypeDef_QtOpenGL_QOpenGLBuffer = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QOpenGLBuffer,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QOpenGLBuffer,
        {0, 0, 1},
        17, methods_QOpenGLBuffer,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QOpenGLBuffer, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QOpenGLBuffer,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QOpenGLBuffer,
    init_type_QOpenGLBuffer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QOpenGLBuffer,
    assign_QOpenGLBuffer,
    array_QOpenGLBuffer,
    copy_QOpenGLBuffer,
    release_QOpenGLBuffer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QOpenGLBuffer,
    sizeof (::QOpenGLBuffer),
};
