/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.3
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6-DataVisualization.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtDataVisualization.h"

#line 27 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/sip/QtDataVisualization/qlist.sip"
#include <qlist.h>
#line 29 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/build/QtDataVisualization/sipQtDataVisualizationQList0601QList0100QBarDataItem.cpp"

#line 26 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/sip/QtDataVisualization/qbardataitem.sip"
#include <qbardataitem.h>
#line 33 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/build/QtDataVisualization/sipQtDataVisualizationQList0601QList0100QBarDataItem.cpp"


extern "C" {static void assign_QList_0601QList_0100QBarDataItem(void *, Py_ssize_t, void *);}
static void assign_QList_0601QList_0100QBarDataItem(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<QList<QList<QBarDataItem>*> *>(sipDst)[sipDstIdx] = *reinterpret_cast<QList<QList<QBarDataItem>*> *>(sipSrc);
}


extern "C" {static void *array_QList_0601QList_0100QBarDataItem(Py_ssize_t);}
static void *array_QList_0601QList_0100QBarDataItem(Py_ssize_t sipNrElem)
{
    return new QList<QList<QBarDataItem>*>[sipNrElem];
}


extern "C" {static void *copy_QList_0601QList_0100QBarDataItem(const void *, Py_ssize_t);}
static void *copy_QList_0601QList_0100QBarDataItem(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new QList<QList<QBarDataItem>*>(reinterpret_cast<const QList<QList<QBarDataItem>*> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_0601QList_0100QBarDataItem(void *, int, void *);}
static void release_QList_0601QList_0100QBarDataItem(void *sipCppV, int, void *)
{
    QList<QList<QBarDataItem>*> *sipCpp = reinterpret_cast<QList<QList<QBarDataItem>*> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_0601QList_0100QBarDataItem(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_0601QList_0100QBarDataItem(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    QList<QList<QBarDataItem>*> **sipCppPtr = reinterpret_cast<QList<QList<QBarDataItem>*> **>(sipCppPtrV);

#line 73 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/sip/QtDataVisualization/qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<QList<QBarDataItem> *> *ql = new QList<QList<QBarDataItem> *>;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyObject *vec_iter = PyObject_GetIter(itm);

        if (!vec_iter)
        {
            PyErr_Format(PyExc_TypeError, "index %zd is not iterable", i);

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        QList<QBarDataItem> *qv = new QList<QBarDataItem>;

        ql->append(qv);

        for (Py_ssize_t j = 0; ; ++j)
        {
            PyErr_Clear();
            PyObject *vec_itm = PyIter_Next(vec_iter);

            if (!vec_itm)
            {
                if (PyErr_Occurred())
                {
                    Py_DECREF(vec_iter);
                    delete ql;
                    Py_DECREF(iter);
                    *sipIsErr = 1;

                    return 0;
                }

                break;
            }

            int state;
            QBarDataItem *t = reinterpret_cast<QBarDataItem *>(
                    sipForceConvertToType(vec_itm, sipType_QBarDataItem,
                            sipTransferObj, SIP_NOT_NONE, &state, sipIsErr));
 
            if (*sipIsErr)
            {
                PyErr_Format(PyExc_TypeError,
                        "index %zd, %zd has type '%s' but 'QBarDataItem' is expected",
                        i, j, sipPyTypeName(Py_TYPE(itm)));

                Py_DECREF(vec_itm);
                Py_DECREF(vec_iter);

                Py_DECREF(itm);
                delete ql;
                Py_DECREF(iter);

                return 0;
            }

            qv->append(*t);

            sipReleaseType(t, sipType_QBarDataItem, state);
            Py_DECREF(vec_itm);
        }

        Py_DECREF(vec_iter);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);
 
    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 185 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/build/QtDataVisualization/sipQtDataVisualizationQList0601QList0100QBarDataItem.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0601QList_0100QBarDataItem(void *, PyObject *);}
static PyObject *convertFrom_QList_0601QList_0100QBarDataItem(void *sipCppV, PyObject *sipTransferObj)
{
    QList<QList<QBarDataItem>*> *sipCpp = reinterpret_cast<QList<QList<QBarDataItem>*> *>(sipCppV);

#line 31 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/sip/QtDataVisualization/qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QList<QBarDataItem> *t_vec = sipCpp->at(i);

        PyObject *v = PyList_New(t_vec->size());

        if (!v)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, v);

        for (int j = 0; j < t_vec->size(); ++j)
        {
            QBarDataItem *t = new QBarDataItem(t_vec->at(i));
            PyObject *tobj = sipConvertFromType(t, sipType_QBarDataItem,
                    sipTransferObj);

            if (!tobj)
            {
                delete t;
                Py_DECREF(l);

                return 0;
            }

            PyList_SetItem(v, j, tobj);
        }
    }

    return l;
#line 234 "/build/pyqt6-datavisualization/src/PyQt6_DataVisualization-6.7.0/build/QtDataVisualization/sipQtDataVisualizationQList0601QList0100QBarDataItem.cpp"
}


sipMappedTypeDef sipTypeDef_QtDataVisualization_QList_0601QList_0100QBarDataItem = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_954,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QList_0601QList_0100QBarDataItem,
    array_QList_0601QList_0100QBarDataItem,
    copy_QList_0601QList_0100QBarDataItem,
    release_QList_0601QList_0100QBarDataItem,
    convertTo_QList_0601QList_0100QBarDataItem,
    convertFrom_QList_0601QList_0100QBarDataItem
};
