// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package main

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type KProbeMultiPWRUEventT struct {
	Pid        uint32
	Type       uint32
	Addr       uint64
	SkbAddr    uint64
	Ts         uint64
	PrintSkbId uint64
	Meta       struct {
		Netns    uint32
		Mark     uint32
		Ifindex  uint32
		Len      uint32
		Mtu      uint32
		Protocol uint16
		Pad      uint16
	}
	Tuple struct {
		Saddr struct {
			V4addr uint32
			_      [12]byte
		}
		Daddr struct {
			V4addr uint32
			_      [12]byte
		}
		Sport   uint16
		Dport   uint16
		L3Proto uint16
		L4Proto uint8
		Pad     uint8
	}
	PrintStackId int64
	ParamSecond  uint64
	CpuId        uint32
}

type KProbeMultiPWRUPrintSkbValue struct {
	Len uint32
	Str [2048]int8
}

// LoadKProbeMultiPWRU returns the embedded CollectionSpec for KProbeMultiPWRU.
func LoadKProbeMultiPWRU() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_KProbeMultiPWRUBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load KProbeMultiPWRU: %w", err)
	}

	return spec, err
}

// LoadKProbeMultiPWRUObjects loads KProbeMultiPWRU and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*KProbeMultiPWRUObjects
//	*KProbeMultiPWRUPrograms
//	*KProbeMultiPWRUMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadKProbeMultiPWRUObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadKProbeMultiPWRU()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// KProbeMultiPWRUSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbeMultiPWRUSpecs struct {
	KProbeMultiPWRUProgramSpecs
	KProbeMultiPWRUMapSpecs
}

// KProbeMultiPWRUSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbeMultiPWRUProgramSpecs struct {
	FentryTc                     *ebpf.ProgramSpec `ebpf:"fentry_tc"`
	FexitSkbClone                *ebpf.ProgramSpec `ebpf:"fexit_skb_clone"`
	FexitSkbCopy                 *ebpf.ProgramSpec `ebpf:"fexit_skb_copy"`
	KprobeSkb1                   *ebpf.ProgramSpec `ebpf:"kprobe_skb_1"`
	KprobeSkb2                   *ebpf.ProgramSpec `ebpf:"kprobe_skb_2"`
	KprobeSkb3                   *ebpf.ProgramSpec `ebpf:"kprobe_skb_3"`
	KprobeSkb4                   *ebpf.ProgramSpec `ebpf:"kprobe_skb_4"`
	KprobeSkb5                   *ebpf.ProgramSpec `ebpf:"kprobe_skb_5"`
	KprobeSkbByStackid           *ebpf.ProgramSpec `ebpf:"kprobe_skb_by_stackid"`
	KprobeSkbLifetimeTermination *ebpf.ProgramSpec `ebpf:"kprobe_skb_lifetime_termination"`
}

// KProbeMultiPWRUMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type KProbeMultiPWRUMapSpecs struct {
	Events        *ebpf.MapSpec `ebpf:"events"`
	PrintSkbMap   *ebpf.MapSpec `ebpf:"print_skb_map"`
	PrintStackMap *ebpf.MapSpec `ebpf:"print_stack_map"`
	SkbAddresses  *ebpf.MapSpec `ebpf:"skb_addresses"`
	SkbStackid    *ebpf.MapSpec `ebpf:"skb_stackid"`
	StackidSkb    *ebpf.MapSpec `ebpf:"stackid_skb"`
}

// KProbeMultiPWRUObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadKProbeMultiPWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbeMultiPWRUObjects struct {
	KProbeMultiPWRUPrograms
	KProbeMultiPWRUMaps
}

func (o *KProbeMultiPWRUObjects) Close() error {
	return _KProbeMultiPWRUClose(
		&o.KProbeMultiPWRUPrograms,
		&o.KProbeMultiPWRUMaps,
	)
}

// KProbeMultiPWRUMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadKProbeMultiPWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbeMultiPWRUMaps struct {
	Events        *ebpf.Map `ebpf:"events"`
	PrintSkbMap   *ebpf.Map `ebpf:"print_skb_map"`
	PrintStackMap *ebpf.Map `ebpf:"print_stack_map"`
	SkbAddresses  *ebpf.Map `ebpf:"skb_addresses"`
	SkbStackid    *ebpf.Map `ebpf:"skb_stackid"`
	StackidSkb    *ebpf.Map `ebpf:"stackid_skb"`
}

func (m *KProbeMultiPWRUMaps) Close() error {
	return _KProbeMultiPWRUClose(
		m.Events,
		m.PrintSkbMap,
		m.PrintStackMap,
		m.SkbAddresses,
		m.SkbStackid,
		m.StackidSkb,
	)
}

// KProbeMultiPWRUPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadKProbeMultiPWRUObjects or ebpf.CollectionSpec.LoadAndAssign.
type KProbeMultiPWRUPrograms struct {
	FentryTc                     *ebpf.Program `ebpf:"fentry_tc"`
	FexitSkbClone                *ebpf.Program `ebpf:"fexit_skb_clone"`
	FexitSkbCopy                 *ebpf.Program `ebpf:"fexit_skb_copy"`
	KprobeSkb1                   *ebpf.Program `ebpf:"kprobe_skb_1"`
	KprobeSkb2                   *ebpf.Program `ebpf:"kprobe_skb_2"`
	KprobeSkb3                   *ebpf.Program `ebpf:"kprobe_skb_3"`
	KprobeSkb4                   *ebpf.Program `ebpf:"kprobe_skb_4"`
	KprobeSkb5                   *ebpf.Program `ebpf:"kprobe_skb_5"`
	KprobeSkbByStackid           *ebpf.Program `ebpf:"kprobe_skb_by_stackid"`
	KprobeSkbLifetimeTermination *ebpf.Program `ebpf:"kprobe_skb_lifetime_termination"`
}

func (p *KProbeMultiPWRUPrograms) Close() error {
	return _KProbeMultiPWRUClose(
		p.FentryTc,
		p.FexitSkbClone,
		p.FexitSkbCopy,
		p.KprobeSkb1,
		p.KprobeSkb2,
		p.KprobeSkb3,
		p.KprobeSkb4,
		p.KprobeSkb5,
		p.KprobeSkbByStackid,
		p.KprobeSkbLifetimeTermination,
	)
}

func _KProbeMultiPWRUClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed kprobemultipwru_x86_bpfel.o
var _KProbeMultiPWRUBytes []byte
