
/*  This file is part of the program psim.

    Copyright (C) 1994-1995, Andrew Cagney <cagney@highland.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.

    --

    This file was generated by the program igen */

#ifndef _SEMANTICS_C_
#define _SEMANTICS_C_


#include "cpu.h"
#include "idecode.h"
#include "semantics.h"
#include "tree.h"
#ifdef HAVE_COMMON_FPU
#include "sim-inline.h"
#include "sim-fpu.h"
#endif
#include "support.h"

int option_mpc860c0 = 0;

PSIM_EXTERN_SEMANTICS(void)
semantic_init(device* root)
{
  option_mpc860c0 = 0;
  if (tree_find_property(root, "/options/mpc860c0"))
    option_mpc860c0 = tree_find_integer_property(root, "/options/mpc860c0");
    option_mpc860c0 *= 4;   /* convert word count to byte count */
}


PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_instruction_call(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_instruction_call
#undef MY_PREFIX
#define MY_PREFIX instruction_call

  /* extraction: 0.0,6./,11./,16./,21./,31.1 #define get-values-from-icache */
#line 62 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1493 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics instruction_call\n"));
#line 68 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_instruction_call, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1493 "../../../sim/ppc/powerpc.igen"
  {
    if (!os_emul_instruction_call(processor, cia, real_addr(cia, 1)))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
  }
#line 83 "semantics.c"
  return nia;
  /* extraction: 0.0,6./,11./,16./,21./,31.1 #undef get-values-from-icache */
#line 86 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Trap_Word_Immediate(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Trap_Word_Immediate

  /* extraction: 0.3,6.TO,11.RA,16.SI #define get-values-from-icache */
#define TO cache_entry->crack.D.TO /* default in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 109 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2897 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Trap Word Immediate\n"));
#line 115 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Trap_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2897 "../../../sim/ppc/powerpc.igen"
  {
    signed_word a = EXTENDED(*rA);
    signed_word b = EXTS(SI);
    if ((a < b && TO_0_)
        || (a > b && TO_1_)
        || (a == b && TO_2_)
        || ((unsigned_word)a < (unsigned_word)b && TO_3_)
        || ((unsigned_word)a > (unsigned_word)b && TO_4_)
        )
      program_interrupt(processor, cia,
                        trap_program_interrupt);
  }
#line 137 "semantics.c"
  return nia;
  /* extraction: 0.3,6.TO,11.RA,16.SI #undef get-values-from-icache */
#undef TO
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 146 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Immediate(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Immediate
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Immediate

  /* extraction: 0.7,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 171 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2687 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Immediate\n"));
#line 177 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2687 "../../../sim/ppc/powerpc.igen"
  {
    signed_word prod = *rA * EXTS(SI);
    *rT = prod;
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
  }
#line 192 "semantics.c"
  return nia;
  /* extraction: 0.7,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 203 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Immediate_Carrying(cpu *processor,
                                          idecode_cache *cache_entry,
                                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Immediate_Carrying

  /* extraction: 0.8,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 228 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2574 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Immediate Carrying\n"));
#line 234 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Immediate_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2574 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(EXTS(SI));
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
  }
#line 252 "semantics.c"
  return nia;
  /* extraction: 0.8,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 263 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare_Logical_Immediate(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical_Immediate

  /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #define get-values-from-icache */
#define BF cache_entry->crack.D.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.D.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.D.L /* default in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 288 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2833 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare Logical Immediate\n"));
#line 294 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare_Logical_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2833 "../../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      unsigned_word a;
      unsigned_word b = UI;
      if (L == 0)
        a = MASKED(*rA, 32, 63);
      else
        a = *rA;
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
  }
#line 319 "semantics.c"
  return nia;
  /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 330 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare_Immediate(cpu *processor,
                           idecode_cache *cache_entry,
                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Immediate

  /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #define get-values-from-icache */
#define BF cache_entry->crack.D.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.D.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.D.L /* default in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 355 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2791 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare Immediate\n"));
#line 361 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2791 "../../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      signed_word a;
      signed_word b = EXTS(SI);
      if (L == 0)
        a = EXTENDED(*rA);
      else
        a = *rA;
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
  }
#line 386 "semantics.c"
  return nia;
  /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 397 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Carrying(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying

  /* extraction: 0.12,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 422 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2554 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Carrying\n"));
#line 428 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2554 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(EXTS(SI));
    ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
  }
#line 444 "semantics.c"
  return nia;
  /* extraction: 0.12,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 455 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Carrying_and_Record(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying_and_Record
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying_and_Record

  /* extraction: 0.13,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 480 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2564 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Carrying and Record\n"));
#line 486 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Carrying_and_Record, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2564 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(EXTS(SI));
    ALU_END(*rT, 1/*CA*/, 0/*OE*/, 1/*Rc*/);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 1/*Rc*/);
  }
#line 502 "semantics.c"
  return nia;
  /* extraction: 0.13,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 513 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_RA0(cpu *processor,
                           idecode_cache *cache_entry,
                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA0

  /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA 0 /* in icache - constant field */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 538 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2512 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 544 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2512 "../../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI);
    else		*rT = *rA + EXTS(SI);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 560 "semantics.c"
  return nia;
  /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 571 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_RA(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA

  /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 596 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2512 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 602 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2512 "../../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI);
    else		*rT = *rA + EXTS(SI);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 618 "semantics.c"
  return nia;
  /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 629 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Shifted_RA0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA0

  /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA 0 /* in icache - constant field */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 654 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2522 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 660 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2522 "../../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI) << 16;
    else		*rT = *rA + (EXTS(SI) << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 676 "semantics.c"
  return nia;
  /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 687 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Shifted_RA(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA

  /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 712 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2522 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 718 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2522 "../../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI) << 16;
    else		*rT = *rA + (EXTS(SI) << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 734 "semantics.c"
  return nia;
  /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 745 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 767 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 773 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 822 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 830 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 852 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 858 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 907 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 915 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 937 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 943 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 992 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1000 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1022 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1028 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1077 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1085 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1107 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1113 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1162 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1170 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1192 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1198 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1247 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1255 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1277 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1283 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1332 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1340 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1362 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1368 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1417 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1425 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1447 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1453 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1502 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1510 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1532 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1538 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1587 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1595 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1617 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1623 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1672 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1680 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1702 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1708 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1757 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1765 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1787 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1793 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1842 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1850 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1872 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1878 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1927 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1935 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1957 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1963 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2012 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2020 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2042 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2048 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2097 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2105 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2127 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2133 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2182 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2190 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2212 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2218 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2267 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2275 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2297 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2303 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2352 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2360 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2382 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2388 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2437 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2445 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2467 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2473 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2522 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2530 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2552 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2558 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2607 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2615 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2637 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2643 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2692 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2700 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2722 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2728 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2777 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2785 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2807 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2813 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2862 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2870 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2892 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2898 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2947 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2955 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2977 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2983 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3032 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3040 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3062 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3068 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3117 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3125 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3147 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3153 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3202 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3210 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3232 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3238 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3287 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3295 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3317 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3323 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3372 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3380 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3402 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3408 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3457 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3465 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3487 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3493 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3542 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3550 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3572 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3578 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3627 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3635 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3657 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3663 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3712 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3720 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3742 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3748 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3797 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3805 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3827 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3833 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3882 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3890 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3912 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3918 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3967 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3975 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3997 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4003 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4052 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4060 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4082 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4088 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4137 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4145 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4167 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4173 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4222 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4230 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4252 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4258 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4307 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4315 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4337 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4343 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4392 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4400 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4422 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4428 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4477 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4485 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4507 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4513 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4562 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4570 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4592 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4598 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4647 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4655 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4677 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4683 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4732 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4740 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4762 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4768 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4817 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4825 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4847 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4853 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4902 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4910 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4932 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4938 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4987 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4995 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5017 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5023 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5072 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5080 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5102 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5108 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5157 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5165 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5187 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5193 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5242 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5250 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5272 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5278 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5327 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5335 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5357 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5363 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5412 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5420 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5442 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5448 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5497 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5505 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5527 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5533 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5582 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5590 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5612 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5618 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5667 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5675 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5697 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5703 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5752 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5760 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5782 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5788 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5837 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5845 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5867 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5873 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5922 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5930 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5952 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5958 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6007 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6015 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 6037 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6043 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6092 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6100 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 6122 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6128 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6177 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6185 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6207 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6213 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6262 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6270 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6292 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6298 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6347 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6355 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6377 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6383 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6432 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6440 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6462 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6468 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6517 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6525 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6547 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6553 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6602 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6610 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6632 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6638 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6687 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6695 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6717 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6723 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6772 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6780 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6802 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6808 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6857 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6865 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6887 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6893 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6942 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6950 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6972 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6978 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7027 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7035 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7057 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7063 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7112 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7120 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7142 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7148 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7197 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7205 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7227 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7233 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7282 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7290 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7312 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7318 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7367 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7375 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7397 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7403 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7452 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7460 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7482 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7488 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7537 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7545 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7567 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7573 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7622 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7630 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7652 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7658 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7707 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7715 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7737 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7743 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7792 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7800 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7822 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7828 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7877 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7885 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7907 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7913 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7962 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7970 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7992 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7998 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8047 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8055 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8077 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8083 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8132 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8140 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8162 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8168 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8217 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8225 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8247 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8253 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8302 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8310 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8332 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8338 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8387 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8395 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8417 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8423 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8472 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8480 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8502 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8508 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8557 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8565 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8587 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8593 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8642 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8650 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8672 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8678 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8727 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8735 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8757 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8763 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8812 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8820 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8842 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8848 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8897 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8905 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 8927 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8933 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8982 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8990 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9012 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9018 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9067 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9075 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9097 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9103 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9152 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9160 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9182 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9188 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9237 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9245 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9267 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9273 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9322 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9330 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9352 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9358 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9407 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9415 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9437 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9443 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9492 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9500 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9522 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9528 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9577 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9585 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9607 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9613 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9662 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9670 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9692 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9698 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9747 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9755 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9777 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9783 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9832 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9840 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9862 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9868 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9917 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9925 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9947 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9953 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10002 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10010 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10032 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10038 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10087 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10095 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10117 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10123 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10172 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10180 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10202 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10208 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10257 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10265 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10287 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10293 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10342 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10350 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10372 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10378 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10427 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10435 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10457 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10463 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10512 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10520 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10542 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10548 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10597 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10605 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10627 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10633 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10682 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10690 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10712 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10718 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10767 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10775 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10797 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10803 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10852 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10860 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10882 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10888 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10937 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10945 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10967 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10973 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11022 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11030 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11052 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11058 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11107 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11115 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11137 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11143 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11192 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11200 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11222 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11228 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11277 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11285 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11307 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11313 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11362 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11370 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11392 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11398 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11447 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11455 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11477 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11483 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11532 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11540 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11562 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11568 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11617 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11625 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_System_Call(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_System_Call
#undef MY_PREFIX
#define MY_PREFIX System_Call

  /* extraction: 0.17,6./,11./,16./,30.1,31./ #define get-values-from-icache */
#line 11642 "semantics.c"

#define insn cache_entry->crack.SC.insn
  unsigned_word nia;
#line 1630 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics System Call\n"));
#line 11648 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_System_Call, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1630 "../../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL_ISSUE > 0)
      model_serialize(MY_INDEX, cpu_model(processor));
    system_call_interrupt(processor, cia);
  }
#line 11663 "semantics.c"
  return nia;
  /* extraction: 0.17,6./,11./,16./,30.1,31./ #undef get-values-from-icache */
#line 11666 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA0_LK0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK0

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 11686 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11692 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11711 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11717 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA0_LK1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK1

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11737 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11743 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11762 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11768 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA1_LK0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK0

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 11788 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11794 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11813 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11819 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA1_LK1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK1

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11839 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11845 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11864 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11870 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_Condition_Register_Field(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_Condition_Register_Field
#undef MY_PREFIX
#define MY_PREFIX Move_Condition_Register_Field

  /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #define get-values-from-icache */
#define BF cache_entry->crack.XL.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.XL.BF_BITMASK /* in icache - extraction */
#define BFA cache_entry->crack.XL.BFA /* default in icache - extraction */
#line 11890 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1709 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move Condition Register Field\n"));
#line 11896 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_Condition_Register_Field, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1709 "../../../sim/ppc/powerpc.igen"
  {
    MBLIT32(CR, 4*BF, 4*BF+3, EXTRACTED32(CR, 4*BFA, 4*BFA+3));
    PPC_INSN_CR(BF_BITMASK, 1 << BFA);
  }
#line 11910 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef BFA
#line 11916 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Link_Register_LK0(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK0

  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 0 /* default in icache - constant field */
#line 11936 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1561 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 11942 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1561 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (ctr_ok && cond_ok) {
      NIA = IEA(LR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 11983 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 11989 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Link_Register_LK1(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK1

  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 1 /* default in icache - constant field */
#line 12009 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1561 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 12015 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1561 "../../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (ctr_ok && cond_ok) {
      NIA = IEA(LR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 12056 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 12062 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_NOR(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NOR

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12085 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1674 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register NOR\n"));
#line 12091 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_NOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1674 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, !(CR_BA_ || CR_BB_));
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12105 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12114 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Return_From_Interrupt(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Return_From_Interrupt
#undef MY_PREFIX
#define MY_PREFIX Return_From_Interrupt

  /* extraction: 0.19,6./,11./,16./,21.50,31./ #define get-values-from-icache */
#line 12131 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 4861 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Return From Interrupt\n"));
#line 12137 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Return_From_Interrupt, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4861 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor)) {
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    }
    else {
      MSR = (MASKED(SRR1, 0, 32)
             | MASKED(SRR1, 37, 41)
             | MASKED(SRR1, 48, 63));
      NIA = MASKED(SRR0, 0, 61);
      cpu_synchronize_context(processor, cia);
      check_masked_interrupts(processor);
    }
  }
#line 12161 "semantics.c"
  return nia;
  /* extraction: 0.19,6./,11./,16./,21.50,31./ #undef get-values-from-icache */
#line 12164 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_AND_with_Complement(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND_with_Complement

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12187 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1690 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register AND with Complement\n"));
#line 12193 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_AND_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1690 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ && !CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12207 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12216 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Instruction_Synchronize(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Instruction_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Instruction_Synchronize

  /* extraction: 0.19,6./,11./,16./,21.150,31./ #define get-values-from-icache */
#line 12233 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 4774 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Instruction Synchronize\n"));
#line 12239 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Instruction_Synchronize, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4774 "../../../sim/ppc/powerpc.igen"
  {
    cpu_synchronize_context(processor, cia);
    PPC_INSN_INT(0, 0, 0);
  }
#line 12253 "semantics.c"
  return nia;
  /* extraction: 0.19,6./,11./,16./,21.150,31./ #undef get-values-from-icache */
#line 12256 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_XOR(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_XOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_XOR

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12279 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1658 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register XOR\n"));
#line 12285 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_XOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1658 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ != CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12299 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12308 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_NAND(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NAND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NAND

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12331 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1666 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register NAND\n"));
#line 12337 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_NAND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1666 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, !(CR_BA_ && CR_BB_));
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12351 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12360 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_AND(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12383 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1642 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register AND\n"));
#line 12389 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_AND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1642 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ && CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12403 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12412 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_Equivalent(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_Equivalent

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12435 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1682 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register Equivalent\n"));
#line 12441 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_Equivalent, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1682 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ == CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12455 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12464 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_OR_with_Complement(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR_with_Complement

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12487 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register OR with Complement\n"));
#line 12493 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_OR_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1698 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ || !CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12507 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12516 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_OR(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12539 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1650 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register OR\n"));
#line 12545 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_OR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1650 "../../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ || CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12559 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12568 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Count_Register_LK0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK0

  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 0 /* default in icache - constant field */
#line 12588 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 12594 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1596 "../../../sim/ppc/powerpc.igen"
  {
    int cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (cond_ok) {
      NIA = IEA(CTR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 12631 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 12637 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Count_Register_LK1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK1

  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 1 /* default in icache - constant field */
#line 12657 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 12663 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1596 "../../../sim/ppc/powerpc.igen"
  {
    int cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (cond_ok) {
      NIA = IEA(CTR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 12700 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 12706 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0(cpu *processor,
                                                         idecode_cache *cache_entry,
                                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0

  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 12734 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3231 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 12740 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3231 "../../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = (r & m) | (*rA & ~m);
    *rA = result;
    ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                       n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
    		   (unsigned long)result));
    CR0_COMPARE(result, 0, Rc);
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12762 "semantics.c"
  return nia;
  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12776 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1(cpu *processor,
                                                         idecode_cache *cache_entry,
                                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1

  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 12804 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3231 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 12810 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3231 "../../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = (r & m) | (*rA & ~m);
    *rA = result;
    ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                       n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
    		   (unsigned long)result));
    CR0_COMPARE(result, 0, Rc);
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12832 "semantics.c"
  return nia;
  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12846 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0(cpu *processor,
                                                           idecode_cache *cache_entry,
                                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0

  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 12874 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3178 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 12880 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3178 "../../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t s = *rS;
    uint32_t r = ROTL32(s, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
    ITRACE(trace_alu,
           ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
            n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
    	(unsigned long)result, (unsigned long)CR));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12904 "semantics.c"
  return nia;
  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12918 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1(cpu *processor,
                                                           idecode_cache *cache_entry,
                                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1

  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 12946 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3178 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 12952 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3178 "../../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t s = *rS;
    uint32_t r = ROTL32(s, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
    ITRACE(trace_alu,
           ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
            n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
    	(unsigned long)result, (unsigned long)CR));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12976 "semantics.c"
  return nia;
  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12990 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_then_AND_with_Mask_Rc0(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc0

  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.M.RB /* in icache - extraction */
#define rB cache_entry->crack.M.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.M.RB_BITMASK /* in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 13020 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3210 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 13026 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3210 "../../../sim/ppc/powerpc.igen"
  {
    long n = MASKED(*rB, 59, 63);
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
  }
#line 13044 "semantics.c"
  return nia;
  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef MB
#undef ME
#undef Rc
#line 13060 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_then_AND_with_Mask_Rc1(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc1

  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.M.RB /* in icache - extraction */
#define rB cache_entry->crack.M.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.M.RB_BITMASK /* in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 13090 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3210 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 13096 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3210 "../../../sim/ppc/powerpc.igen"
  {
    long n = MASKED(*rB, 59, 63);
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
  }
#line 13114 "semantics.c"
  return nia;
  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef MB
#undef ME
#undef Rc
#line 13130 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Immediate(cpu *processor,
                      idecode_cache *cache_entry,
                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate

  /* extraction: 0.24,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13155 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2974 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR Immediate\n"));
#line 13161 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2974 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | UI;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13176 "semantics.c"
  return nia;
  /* extraction: 0.24,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13187 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Immediate_Shifted(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate_Shifted

  /* extraction: 0.25,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13212 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2983 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR Immediate Shifted\n"));
#line 13218 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2983 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | (UI << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13233 "semantics.c"
  return nia;
  /* extraction: 0.25,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13244 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Immediate(cpu *processor,
                       idecode_cache *cache_entry,
                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate

  /* extraction: 0.26,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13269 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2992 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR Immediate\n"));
#line 13275 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2992 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ UI;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13290 "semantics.c"
  return nia;
  /* extraction: 0.26,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13301 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Immediate_Shifted(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate_Shifted

  /* extraction: 0.27,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13326 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3001 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR Immediate Shifted\n"));
#line 13332 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3001 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ (UI << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13347 "semantics.c"
  return nia;
  /* extraction: 0.27,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13358 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Immediate(cpu *processor,
                       idecode_cache *cache_entry,
                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate

  /* extraction: 0.28,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13383 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2954 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND Immediate\n"));
#line 13389 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2954 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & UI;
    CR0_COMPARE(*rA, 0, 1/*Rc*/);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
  }
#line 13405 "semantics.c"
  return nia;
  /* extraction: 0.28,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13416 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Immediate_Shifted(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate_Shifted

  /* extraction: 0.29,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13441 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2964 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND Immediate Shifted\n"));
#line 13447 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2964 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & (UI << 16);
    CR0_COMPARE(*rA, 0, 1/*Rc*/);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
  }
#line 13463 "semantics.c"
  return nia;
  /* extraction: 0.29,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13474 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare
#undef MY_PREFIX
#define MY_PREFIX Compare

  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.X.L /* default in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 13501 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2810 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare\n"));
#line 13507 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2810 "../../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      signed_word a;
      signed_word b;
      if (L == 0) {
        a = EXTENDED(*rA);
        b = EXTENDED(*rB);
      }
      else {
        a = *rA;
        b = *rB;
      }
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
  }
#line 13536 "semantics.c"
  return nia;
  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 13549 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Trap_Word(cpu *processor,
                   idecode_cache *cache_entry,
                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word
#undef MY_PREFIX
#define MY_PREFIX Trap_Word

  /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #define get-values-from-icache */
#define TO cache_entry->crack.X.TO /* default in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 13574 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2930 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Trap Word\n"));
#line 13580 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Trap_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2930 "../../../sim/ppc/powerpc.igen"
  {
    signed_word a = EXTENDED(*rA);
    signed_word b = EXTENDED(*rB);
    if (TO == 12 && rA == rB) {
      ITRACE(trace_breakpoint, ("breakpoint\n"));
      cpu_halt(processor, cia, was_trap, 0);
    }
    else if ((a < b && TO_0_)
        || (a > b && TO_1_)
        || (a == b && TO_2_)
        || ((unsigned_word)a < (unsigned_word)b && TO_3_)
        || ((unsigned_word)a > (unsigned_word)b && TO_4_)
        )
      program_interrupt(processor, cia,
                        trap_program_interrupt);
  }
#line 13606 "semantics.c"
  return nia;
  /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #undef get-values-from-icache */
#undef TO
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 13617 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE0_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 13646 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 13652 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13671 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13686 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE0_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 13715 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 13721 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13740 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13755 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE0_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 13784 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 13790 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13806 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13821 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE0_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 13850 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 13856 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13872 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13887 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Unsigned_Rc0(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 13915 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2730 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 13921 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2730 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t a = (uint32_t)(*rA);
    uint64_t b = (uint32_t)(*rB);
    uint64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13940 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 13954 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Unsigned_Rc1(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 13982 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2730 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 13988 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2730 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t a = (uint32_t)(*rA);
    uint64_t b = (uint32_t)(*rB);
    uint64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 14007 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14021 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Condition_Register(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Condition_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Condition_Register

  /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#line 14041 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3452 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Condition Register\n"));
#line 14047 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Condition_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3452 "../../../sim/ppc/powerpc.igen"
  {
    *rT = (uint32_t)CR;
    PPC_INSN_MFCR(RT_BITMASK);
  }
#line 14061 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#line 14067 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_And_Reserve_Indexed(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_And_Reserve_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_And_Reserve_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14094 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2422 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word And Reserve Indexed\n"));
#line 14100 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_And_Reserve_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2422 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    RESERVE = 1;
    RESERVE_ADDR = real_addr(EA, 1/*is-read?*/);
    RESERVE_DATA = MEM(unsigned, EA, 4);
    *rT = RESERVE_DATA;
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 14122 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14135 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero_Indexed(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14162 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1898 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero Indexed\n"));
#line 14168 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1898 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(unsigned, EA, 4);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 14187 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14200 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Left_Word_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14228 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3250 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 14234 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Left_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3250 "../../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source << n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu,
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 14259 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14273 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Left_Word_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 14301 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3250 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 14307 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Left_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3250 "../../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source << n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu,
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 14332 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14346 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Count_Leading_Zeros_Word_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14371 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3129 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 14377 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3129 "../../../sim/ppc/powerpc.igen"
  {
    int count = 0;
    uint32_t mask = BIT32(0);
    uint32_t source = *rS;
    while (!(source & mask) && mask != 0) {
      mask >>= 1;
      count++;
    }
    *rA = count;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
  }
#line 14399 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 14410 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Count_Leading_Zeros_Word_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 1 /* default in icache - constant field */
#line 14435 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3129 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 14441 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3129 "../../../sim/ppc/powerpc.igen"
  {
    int count = 0;
    uint32_t mask = BIT32(0);
    uint32_t source = *rS;
    while (!(source & mask) && mask != 0) {
      mask >>= 1;
      count++;
    }
    *rA = count;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
  }
#line 14463 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 14474 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Rc0(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14502 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3010 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND\n"));
#line 14508 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3010 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 14524 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14538 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Rc1(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 14566 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3010 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND\n"));
#line 14572 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3010 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 14588 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14602 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare_Logical(cpu *processor,
                         idecode_cache *cache_entry,
                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical

  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.X.L /* default in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14629 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2852 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare Logical\n"));
#line 14635 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare_Logical, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2852 "../../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      unsigned_word a;
      unsigned_word b;
      if (L == 0) {
        a = MASKED(*rA, 32, 63);
        b = MASKED(*rB, 32, 63);
      }
      else {
        a = *rA;
        b = *rB;
      }
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
  }
#line 14664 "semantics.c"
  return nia;
  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14677 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE0_Rc0(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 14706 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 14712 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 14730 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 14745 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE0_Rc1(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 14774 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 14780 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 14798 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 14813 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Store(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Store

  /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14837 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4811 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Store\n"));
#line 14843 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Store, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4811 "../../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Store\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 14857 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14867 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero_with_Update_Indexed(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14894 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1925 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero with Update Indexed\n"));
#line 14900 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1925 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(unsigned, EA, 4);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 14920 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14933 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_with_Complement_Rc0(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14961 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3070 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 14967 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3070 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 14983 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14997 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_with_Complement_Rc1(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 15025 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3070 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 15031 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3070 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 15047 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15061 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Rc0(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 15089 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2715 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 15095 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2715 "../../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15114 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15128 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Rc1(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 15156 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2715 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 15162 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2715 "../../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15181 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15195 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Machine_State_Register(cpu *processor,
                                          idecode_cache *cache_entry,
                                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Machine_State_Register

  /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#line 15215 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4898 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Machine State Register\n"));
#line 15221 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Machine_State_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4898 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      *rT = MSR;
      check_masked_interrupts(processor);
    }
  }
#line 15240 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#line 15246 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Flush(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Flush
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Flush

  /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 15270 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4819 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Flush\n"));
#line 15276 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Flush, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4819 "../../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Flush\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 15290 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 15300 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero_Indexed(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 15327 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1736 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero Indexed\n"));
#line 15333 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1736 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(unsigned, EA, 1);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 15352 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 15365 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE0_Rc0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 15391 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 15397 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 15414 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 15426 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE0_Rc1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 15452 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 15458 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 15475 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 15487 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero_with_Update_Indexed(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 15514 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1763 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero with Update Indexed\n"));
#line 15520 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1763 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(unsigned, EA, 1);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 15540 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 15553 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NOR_Rc0(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 15581 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3050 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NOR\n"));
#line 15587 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3050 "../../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS | *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 15603 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15617 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NOR_Rc1(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 15645 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3050 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NOR\n"));
#line 15651 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3050 "../../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS | *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 15667 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15681 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE0_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 15710 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 15716 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15734 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15749 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE0_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 15778 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 15784 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15802 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15817 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE0_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 15846 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 15852 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15869 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15884 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE0_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 15913 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 15919 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15936 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15951 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Condition_Register_Fields(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_Fields
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_Fields

  /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #define get-values-from-icache */
#define RS cache_entry->crack.XFX.RS /* in icache - extraction */
#define rS cache_entry->crack.XFX.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.XFX.RS_BITMASK /* in icache - extraction */
#define FXM cache_entry->crack.XFX.FXM /* default in icache - extraction */
#line 15972 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3429 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Condition Register Fields\n"));
#line 15978 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Condition_Register_Fields, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3429 "../../../sim/ppc/powerpc.igen"
  {
    if (FXM == 0xff) {
      CR = *rS;
    }
    else {
      unsigned_word mask = 0;
      unsigned_word f;
      for (f = 0; f < 8; f++) {
        if (FXM & (0x80 >> f))
          mask |= (0xf << 4*(7-f));
      }
      CR = (MASKED(*rS, 32, 63) & mask) | (CR & ~mask);
    }
    PPC_INSN_MTCR(RS_BITMASK, FXM);
  }
#line 16003 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef FXM
#line 16010 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_Machine_State_Register(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Machine_State_Register

  /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#line 16030 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4885 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To Machine State Register\n"));
#line 16036 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_Machine_State_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4885 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      MSR = *rS;
      check_masked_interrupts(processor);
    }
  }
#line 16055 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#line 16061 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_Conditional_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Conditional_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Conditional_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16088 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2450 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word Conditional Indexed\n"));
#line 16094 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_Conditional_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2450 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    if (RESERVE) {
      if (RESERVE_ADDR == real_addr(EA, 0/*is-read?*/)
          && /*HACK*/ RESERVE_DATA == MEM(unsigned, EA, 4)) {
        STORE(EA, 4, *rS);
        CR_SET_XER_SO(0, cr_i_zero);
      }
      else {
        /* ment to randomly to store, we never do! */	
        CR_SET_XER_SO(0, 0);
      }
      RESERVE = 0;
    }
    else {
      CR_SET_XER_SO(0, 0);
    }
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 1/*Rc*/);
  }
#line 16127 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16140 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_Indexed(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16167 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2125 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word Indexed\n"));
#line 16173 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2125 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 16192 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16205 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_with_Update_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_with_Update_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16232 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2152 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word with Update Indexed\n"));
#line 16238 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2152 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 4, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
  }
#line 16258 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16271 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE0_Rc0(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16297 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 16303 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16320 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16332 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE0_Rc1(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16358 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 16364 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16381 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16393 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE0_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16419 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 16425 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16441 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16453 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE0_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16479 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 16485 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16501 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16513 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_Segment_Register(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register

  /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define SR cache_entry->crack.X.SR /* default in icache - extraction */
#line 16534 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4931 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To Segment Register\n"));
#line 16540 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_Segment_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4931 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      SEGREG(SR) = *rS;
  }
#line 16557 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef SR
#line 16564 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte_Indexed(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16591 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2017 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte Indexed\n"));
#line 16597 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2017 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 1, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 16616 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16629 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16655 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 16661 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16679 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16691 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16717 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 16723 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16741 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16753 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16779 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 16785 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16802 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16814 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16840 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 16846 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16863 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16875 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE0_Rc0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16904 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 16910 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 16931 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 16946 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE0_Rc1(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16975 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 16981 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 17002 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 17017 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_Segment_Register_Indirect(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register_Indirect
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register_Indirect

  /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17040 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4942 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To Segment Register Indirect\n"));
#line 17046 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_Segment_Register_Indirect, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4942 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      SEGREG(EXTRACTED32(*rB, 0, 3)) = *rS;
  }
#line 17063 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RB
#undef rB
#undef RB_BITMASK
#line 17072 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Touch_for_Store(cpu *processor,
                                          idecode_cache *cache_entry,
                                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch_for_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch_for_Store

  /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17096 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4795 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Touch for Store\n"));
#line 17102 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Touch_for_Store, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4795 "../../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Touch for Store\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 17116 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17126 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte_with_Update_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_with_Update_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17153 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2044 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte with Update Indexed\n"));
#line 17159 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2044 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 1, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
  }
#line 17179 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17192 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE0_Rc0(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 17221 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 17227 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 17243 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 17258 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE0_Rc1(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 17287 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 17293 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 17309 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 17324 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Touch(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch

  /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17348 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4787 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Touch\n"));
#line 17354 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Touch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4787 "../../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Touch\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 17368 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17378 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17405 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1790 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero Indexed\n"));
#line 17411 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1790 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(unsigned, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 17430 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17443 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Equivalent_Rc0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 17471 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3060 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 17477 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Equivalent, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3060 "../../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS ^ *rB); /* A === B */
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17493 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17507 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Equivalent_Rc1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 17535 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3060 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 17541 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Equivalent, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3060 "../../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS ^ *rB); /* A === B */
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17557 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17571 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_TLB_Invalidate_Entry(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_Entry
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_Entry

  /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #define get-values-from-icache */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17591 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4980 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics TLB Invalidate Entry\n"));
#line 17597 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_TLB_Invalidate_Entry, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4980 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      int nr = 0;
      cpu *proc;
      while (1) {
        proc = psim_cpu(cpu_system(processor), nr);
        if (proc == NULL) break;
        cpu_page_tlb_invalidate_entry(proc, *rB);
        nr++;
      }
    }
  }
#line 17622 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #undef get-values-from-icache */
#undef RB
#undef rB
#undef RB_BITMASK
#line 17628 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero_with_Update_Indexed(cpu *processor,
                                                    idecode_cache *cache_entry,
                                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17655 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1817 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero with Update Indexed\n"));
#line 17661 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1817 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(unsigned, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 17681 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17694 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Rc0(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 17722 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3030 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR\n"));
#line 17728 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3030 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17744 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17758 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Rc1(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 17786 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3030 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR\n"));
#line 17792 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3030 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17808 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17822 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_from_Special_Purpose_Register_SPR256(cpu *processor,
                                                   idecode_cache *cache_entry,
                                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR256

  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache */
#define RT cache_entry->crack.XFX.RT /* in icache - extraction */
#define rT cache_entry->crack.XFX.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XFX.RT_BITMASK /* in icache - extraction */
#define SPR 256 /* default in icache - constant field */
#line 17843 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3388 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 17849 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3388 "../../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      /* HACK - time base registers need to be calculated */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_dec:
          *rT = cpu_get_decrementer(processor);
          break;
    	case spr_tbrl:
      	  if (is_64bit_implementation) *rT = TB;
      	  else                         *rT = EXTRACTED64(TB, 32, 63);
    	break;
    	case spr_tbru:
      	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
    	  else                         *rT = EXTRACTED64(TB, 0, 31);
    	break;
        case spr_tbu:
        case spr_tbl:
          /* NOTE - these SPR's are not readable. Use mftb[ul] */
        default:
          *rT = SPREG(n);
          break;
        }
      }
      else {
        *rT = SPREG(n);
      }
    }
    PPC_INSN_FROM_SPR(RT_BITMASK, n);
  }
#line 17896 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef SPR
#line 17903 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_from_Special_Purpose_Register_SPR(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR

  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache */
#define RT cache_entry->crack.XFX.RT /* in icache - extraction */
#define rT cache_entry->crack.XFX.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XFX.RT_BITMASK /* in icache - extraction */
#define SPR cache_entry->crack.XFX.SPR /* default in icache - extraction */
#line 17924 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3388 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 17930 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3388 "../../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      /* HACK - time base registers need to be calculated */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_dec:
          *rT = cpu_get_decrementer(processor);
          break;
    	case spr_tbrl:
      	  if (is_64bit_implementation) *rT = TB;
      	  else                         *rT = EXTRACTED64(TB, 32, 63);
    	break;
    	case spr_tbru:
      	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
    	  else                         *rT = EXTRACTED64(TB, 0, 31);
    	break;
        case spr_tbu:
        case spr_tbl:
          /* NOTE - these SPR's are not readable. Use mftb[ul] */
        default:
          *rT = SPREG(n);
          break;
        }
      }
      else {
        *rT = SPREG(n);
      }
    }
    PPC_INSN_FROM_SPR(RT_BITMASK, n);
  }
#line 17977 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef SPR
#line 17984 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic_Indexed(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18011 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1844 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic Indexed\n"));
#line 18017 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1844 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(signed, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 18036 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18049 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_TLB_Invalidate_All(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_All
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_All

  /* extraction: 0.31,6./,11./,16./,21.370,31./ #define get-values-from-icache */
#line 18066 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4995 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics TLB Invalidate All\n"));
#line 18072 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_TLB_Invalidate_All, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4995 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      int nr = 0;
      cpu *proc;
      while (1) {
        proc = psim_cpu(cpu_system(processor), nr);
        if (proc == NULL) break;
        cpu_page_tlb_invalidate_all(proc);
        nr++;
      }
    }
  }
#line 18097 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16./,21.370,31./ #undef get-values-from-icache */
#line 18100 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Time_Base(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Time_Base
#undef MY_PREFIX
#define MY_PREFIX Move_From_Time_Base

  /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #define get-values-from-icache */
#define RT cache_entry->crack.XFX.RT /* in icache - extraction */
#define rT cache_entry->crack.XFX.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XFX.RT_BITMASK /* in icache - extraction */
#define tbr cache_entry->crack.XFX.tbr /* default in icache - extraction */
#line 18121 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 4838 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Time Base\n"));
#line 18127 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Time_Base, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4838 "../../../sim/ppc/powerpc.igen"
  {
    int n = (tbr_5_9_ << 5) | tbr_0_4_;
    if (n == 268) {
      if (is_64bit_implementation) *rT = TB;
      else                         *rT = EXTRACTED64(TB, 32, 63);
    }
    else if (n == 269) {
      if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
      else                         *rT = EXTRACTED64(TB, 0, 31);
    }
    else
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
  }
#line 18151 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef tbr
#line 18158 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic_with_Update_Indexed(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18185 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1871 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic with Update Indexed\n"));
#line 18191 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1871 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(signed, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 18211 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18224 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_Indexed(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18251 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2071 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word Indexed\n"));
#line 18257 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2071 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 2, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 18276 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18289 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_with_Complement_Rc0(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 18317 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3080 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 18323 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3080 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18339 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18353 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_with_Complement_Rc1(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 18381 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3080 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 18387 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3080 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18403 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18417 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_with_Update_Indexed(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_with_Update_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18444 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2098 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word with Update Indexed\n"));
#line 18450 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2098 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 2, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
  }
#line 18470 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18483 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Rc0(cpu *processor,
                idecode_cache *cache_entry,
                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 18511 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3020 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR\n"));
#line 18517 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3020 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18533 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18547 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Rc1(cpu *processor,
                idecode_cache *cache_entry,
                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 18575 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3020 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR\n"));
#line 18581 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3020 "../../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18597 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18611 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE0_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 18640 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 18646 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 18671 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 18686 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE0_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 18715 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 18721 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 18746 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 18761 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Special_Purpose_Register_SPR256(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR256

  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache */
#define RS cache_entry->crack.XFX.RS /* in icache - extraction */
#define rS cache_entry->crack.XFX.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.XFX.RS_BITMASK /* in icache - extraction */
#define SPR 256 /* default in icache - constant field */
#line 18782 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3344 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 18788 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3344 "../../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n)
             || spr_is_readonly(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      spreg new_val = (spr_length(n) == 64
    		   ? *rS
    		   : MASKED(*rS, 32, 63));
      /* HACK - time base registers need to be updated immediately */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_tbu:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 32, 63)
                             | INSERTED64(new_val, 0, 31)));
          break;
        case spr_tbl:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 0, 31)
                             | INSERTED64(new_val, 32, 63)));
          break;
        case spr_dec:
          cpu_set_decrementer(processor, new_val);
          break;
        default:
          SPREG(n) = new_val;
          break;
        }
      }
      else {
        SPREG(n) = new_val;
      }
    }
    PPC_INSN_TO_SPR(RS_BITMASK, n);
  }
#line 18838 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef SPR
#line 18845 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Special_Purpose_Register_SPR(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR

  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache */
#define RS cache_entry->crack.XFX.RS /* in icache - extraction */
#define rS cache_entry->crack.XFX.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.XFX.RS_BITMASK /* in icache - extraction */
#define SPR cache_entry->crack.XFX.SPR /* default in icache - extraction */
#line 18866 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3344 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 18872 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3344 "../../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n)
             || spr_is_readonly(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      spreg new_val = (spr_length(n) == 64
    		   ? *rS
    		   : MASKED(*rS, 32, 63));
      /* HACK - time base registers need to be updated immediately */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_tbu:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 32, 63)
                             | INSERTED64(new_val, 0, 31)));
          break;
        case spr_tbl:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 0, 31)
                             | INSERTED64(new_val, 32, 63)));
          break;
        case spr_dec:
          cpu_set_decrementer(processor, new_val);
          break;
        default:
          SPREG(n) = new_val;
          break;
        }
      }
      else {
        SPREG(n) = new_val;
      }
    }
    PPC_INSN_TO_SPR(RS_BITMASK, n);
  }
#line 18922 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef SPR
#line 18929 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Invalidate(cpu *processor,
                                     idecode_cache *cache_entry,
                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Invalidate
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Invalidate

  /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18953 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4916 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Invalidate\n"));
#line 18959 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Invalidate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4916 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      TRACE(trace_tbd,("Data Cache Block Invalidate\n"));
  }
#line 18976 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18986 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NAND_Rc0(cpu *processor,
                  idecode_cache *cache_entry,
                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 19014 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3040 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NAND\n"));
#line 19020 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NAND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3040 "../../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS & *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 19036 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19050 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NAND_Rc1(cpu *processor,
                  idecode_cache *cache_entry,
                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 19078 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3040 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NAND\n"));
#line 19084 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NAND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3040 "../../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS & *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 19100 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19114 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE0_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19143 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 19149 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19175 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19190 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE0_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 19219 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 19225 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19251 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19266 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Condition_Register_from_XER(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_from_XER
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_from_XER

  /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#line 19285 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3444 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Condition Register from XER\n"));
#line 19291 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Condition_Register_from_XER, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3444 "../../../sim/ppc/powerpc.igen"
  error("%s:%d:0x%08lx:%s unimplemented\n",
        itable[MY_INDEX].file, itable[MY_INDEX].line_nr, (long)cia, itable[MY_INDEX].name);
#line 19303 "semantics.c"
  return nia;
  /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#line 19308 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE1_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19337 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 19343 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19362 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19377 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE1_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 19406 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 19412 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19431 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19446 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE1_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19475 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 19481 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19497 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19512 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE1_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 19541 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 19547 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19563 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19578 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_String_Word_Indexed(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 19605 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2328 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load String Word Indexed\n"));
#line 19611 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_String_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2328 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int n;
    int r;
    int i;
    int nr;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    n = EXTRACTED32(XER, 25, 31);
    r = RT - 1;
    i = 32;
    nr = (n + 3) / 4;
    if (((RT + nr >= 32)
         ? ((RA >= RT || RA < (RT + nr) % 32)
            || (RB >= RT || RB < (RT + nr) % 32))
         : ((RA >= RT && RA < RT + nr)
            || (RB >= RT && RB < RT + nr)))
        || (RT == RA || RT == RB))
      program_interrupt(processor, cia,
                      illegal_instruction_program_interrupt);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    while (n > 0) {
      if (i == 32) {
        r = (r + 1) % 32;
        GPR(r) = 0;
      }
      GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 19657 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 19670 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_ByteReverse_Indexed(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_ByteReverse_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_ByteReverse_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 19697 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2215 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word Byte-Reverse Indexed\n"));
#line 19703 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_ByteReverse_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2215 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = SWAP_4(MEM(unsigned, EA, 4));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 19722 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 19735 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single_Indexed(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 19761 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3477 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single Indexed\n"));
#line 19767 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3477 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 19786 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 19798 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Word_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 19826 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3271 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 19832 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3271 "../../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source >> n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, \
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 19857 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19871 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Word_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 19899 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3271 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 19905 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3271 "../../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source >> n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, \
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 19930 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19944 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE1_Rc0(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19973 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 19979 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19997 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20012 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE1_Rc1(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20041 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 20047 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20065 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20080 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_TLB_Synchronize(cpu *processor,
                         idecode_cache *cache_entry,
                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Synchronize
#undef MY_PREFIX
#define MY_PREFIX TLB_Synchronize

  /* extraction: 0.31,6./,11./,16./,21.566,31./ #define get-values-from-icache */
#line 20097 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 5010 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics TLB Synchronize\n"));
#line 20103 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_TLB_Synchronize, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 5010 "../../../sim/ppc/powerpc.igen"
  {
    /* nothing happens here - always in sync */
  }
#line 20116 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16./,21.566,31./ #undef get-values-from-icache */
#line 20119 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single_with_Update_Indexed(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_with_Update_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20145 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3504 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single with Update Indexed\n"));
#line 20151 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3504 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 20171 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 20183 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Segment_Register(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Segment_Register

  /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define SR cache_entry->crack.X.SR /* default in icache - extraction */
#line 20204 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4953 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Segment Register\n"));
#line 20210 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Segment_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4953 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      *rT = SEGREG(SR);
  }
#line 20227 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef SR
#line 20234 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_String_Word_Immediate(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Immediate

  /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define NB cache_entry->crack.X.NB /* default in icache - extraction */
#line 20259 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2296 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load String Word Immediate\n"));
#line 20265 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_String_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2296 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    int n;
    int r;
    int i;
    int nr;
    if (RA_is_0) EA = 0;
    else         EA = *rA;
    if (NB == 0) n = 32;
    else         n = NB;
    r = RT - 1;
    i = 32;
    nr = (n + 3) / 4;
    if ((RT + nr >= 32)
        ? (RA >= RT || RA < (RT + nr) % 32)
        : (RA >= RT && RA < RT + nr))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    while (n > 0) {
      if (i == 32) {
        r = (r + 1) % 32;
        GPR(r) = 0;
      }
      GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 20307 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef NB
#line 20318 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Synchronize(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Synchronize

  /* extraction: 0.31,6./,9.L,11./,16./,21.598,31./ #define get-values-from-icache */
#define L cache_entry->crack.X.L /* default in icache - extraction */
#line 20336 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2500 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Synchronize\n"));
#line 20342 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Synchronize, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2500 "../../../sim/ppc/powerpc.igen"
  {
    /* do nothing */
  }
#line 20355 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,9.L,11./,16./,21.598,31./ #undef get-values-from-icache */
#undef L
#line 20359 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double_Indexed(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.599,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20385 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3531 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double Indexed\n"));
#line 20391 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3531 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *frT = MEM(unsigned, EA, 8);
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 20410 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.599,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 20422 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE1_Rc0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 20448 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 20454 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 20471 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 20483 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE1_Rc1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20509 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 20515 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 20532 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 20544 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double_with_Update_Indexed(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_with_Update_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.631,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20570 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3558 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double with Update Indexed\n"));
#line 20576 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3558 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *frT = MEM(unsigned, EA, 8);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 20596 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.631,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 20608 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE1_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 20637 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 20643 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20661 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20676 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE1_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20705 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 20711 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20729 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20744 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE1_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 20773 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 20779 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20796 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20811 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE1_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20840 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 20846 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20863 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20878 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Segment_Register_Indirect(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Segment_Register_Indirect
#undef MY_PREFIX
#define MY_PREFIX Move_From_Segment_Register_Indirect

  /* extraction: 0.31,6.RT,11./,16.RB,21.659,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20901 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4964 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Segment Register Indirect\n"));
#line 20907 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Segment_Register_Indirect, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4964 "../../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      *rT = SEGREG(EXTRACTED32(*rB, 0, 3));
  }
#line 20924 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,16.RB,21.659,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RB
#undef rB
#undef RB_BITMASK
#line 20933 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_String_Word_Indexed(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_String_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_String_Word_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.661,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20960 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2386 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store String Word Indexed\n"));
#line 20966 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_String_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2386 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int n;
    int r;
    int i;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    n = EXTRACTED32(XER, 25, 31);
    r = RS - 1;
    i = 32;
    while (n > 0) {
      if (i == 32) r = (r + 1) % 32;
      STORE(EA, 1, EXTRACTED(GPR(r), i, i+7));
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 20999 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.661,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21012 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_ByteReversed_Indexed(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_ByteReversed_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_ByteReversed_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.662,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21039 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2241 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word Byte-Reversed Indexed\n"));
#line 21045 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_ByteReversed_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2241 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, SWAP_4(*rS));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 21064 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.662,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21077 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single_Indexed(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.663,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21103 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3590 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single Indexed\n"));
#line 21109 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3590 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, SINGLE(*frS));
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 21128 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.663,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21140 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single_with_Update_Indexed(cpu *processor,
                                                        idecode_cache *cache_entry,
                                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single_with_Update_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.695,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21166 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3617 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single with Update Indexed\n"));
#line 21172 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3617 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 4, SINGLE(*frS));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 21192 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.695,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21204 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE1_Rc0(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21230 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 21236 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21253 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21265 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE1_Rc1(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21291 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 21297 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21314 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21326 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE1_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21352 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 21358 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21374 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21386 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE1_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21412 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 21418 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21434 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21446 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_String_Word_Immedate(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_String_Word_Immedate
#undef MY_PREFIX
#define MY_PREFIX Store_String_Word_Immedate

  /* extraction: 0.31,6.RS,11.RA,16.NB,21.725,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define NB cache_entry->crack.X.NB /* default in icache - extraction */
#line 21471 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2364 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store String Word Immedate\n"));
#line 21477 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_String_Word_Immedate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2364 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    int n;
    int r;
    int i;
    if (RA_is_0) EA = 0;
    else         EA = *rA;
    if (NB == 0) n = 32;
    else         n = NB;
    r = RS - 1;
    i = 32;
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    while (n > 0) {
      if (i == 32) r = (r + 1) % 32;
      STORE(EA, 1, EXTRACTED(GPR(r), i, i+7));
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 21509 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.NB,21.725,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef NB
#line 21520 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double_Indexed(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.727,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21546 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3644 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double Indexed\n"));
#line 21552 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3644 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 8, *frS);
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 21571 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.727,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21583 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE1_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21609 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 21615 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21633 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21645 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE1_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21671 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 21677 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21695 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21707 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE1_Rc0(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21733 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 21739 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21756 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21768 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE1_Rc1(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21794 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 21800 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21817 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21829 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE1_Rc0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21858 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 21864 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 21885 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 21900 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE1_Rc1(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21929 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 21935 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 21956 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 21971 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double_with_Update_Indexed(cpu *processor,
                                                        idecode_cache *cache_entry,
                                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double_with_Update_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.759,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21997 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3683 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double with Update Indexed\n"));
#line 22003 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3683 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 8, *frS);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 22023 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.759,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 22035 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE1_Rc0(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 22064 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 22070 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 22086 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 22101 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE1_Rc1(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 22130 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 22136 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 22152 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 22167 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_ByteReverse_Indexed(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_ByteReverse_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_ByteReverse_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.790,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 22194 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2202 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Byte-Reverse Indexed\n"));
#line 22200 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_ByteReverse_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2202 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = SWAP_2(MEM(unsigned, EA, 2));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 22219 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.790,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 22232 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22260 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3314 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word\n"));
#line 22266 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3314 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t mask;
    int n = MASKED(*rB, 59, 63);
    int32_t source = (int32_t)*rS; /* signed to keep sign bit */
    int S = (MASKED(*rS,32,32) != 0);
    int64_t r = ((uint64_t) source);
    r = ((uint64_t) source) << 32 | (uint32_t) source;
    r = ROTL64(r,64-n);
    if (MASKED(*rB,58,58) == 0)
    	mask = (uint64_t) MASK64(n+32,63);
    else
    	mask = (uint64_t) 0;
    *rA = (signed_word) ((r & mask) | (((int64_t) -1*S) & ~mask)); /* if 64bit will sign extend */
    if (S && (MASKED(r & ~mask,32,63)!=0))
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22298 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 22312 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22340 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3314 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word\n"));
#line 22346 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3314 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t mask;
    int n = MASKED(*rB, 59, 63);
    int32_t source = (int32_t)*rS; /* signed to keep sign bit */
    int S = (MASKED(*rS,32,32) != 0);
    int64_t r = ((uint64_t) source);
    r = ((uint64_t) source) << 32 | (uint32_t) source;
    r = ROTL64(r,64-n);
    if (MASKED(*rB,58,58) == 0)
    	mask = (uint64_t) MASK64(n+32,63);
    else
    	mask = (uint64_t) 0;
    *rA = (signed_word) ((r & mask) | (((int64_t) -1*S) & ~mask)); /* if 64bit will sign extend */
    if (S && (MASKED(r & ~mask,32,63)!=0))
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22378 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 22392 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Immediate_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Immediate_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.X.SH /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22418 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3292 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word Immediate\n"));
#line 22424 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3292 "../../../sim/ppc/powerpc.igen"
  {
    int n = SH;
    signed_word r = ROTL32(*rS, /*64*/32-n);
    signed_word m = MASK(n+32, 63);
    int S = MASKED(*rS, 32, 32);
    signed_word shifted = (r & m) | (S ? ~m : 0);
    *rA = shifted;
    if (S && ((r & ~m) & MASK(32, 63)) != 0)
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22450 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef Rc
#line 22462 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Immediate_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Immediate_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.X.SH /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22488 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3292 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word Immediate\n"));
#line 22494 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3292 "../../../sim/ppc/powerpc.igen"
  {
    int n = SH;
    signed_word r = ROTL32(*rS, /*64*/32-n);
    signed_word m = MASK(n+32, 63);
    int S = MASKED(*rS, 32, 32);
    signed_word shifted = (r & m) | (S ? ~m : 0);
    *rA = shifted;
    if (S && ((r & ~m) & MASK(32, 63)) != 0)
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22520 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef Rc
#line 22532 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Enforce_Inorder_Execution_of_IO(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Enforce_Inorder_Execution_of_IO
#undef MY_PREFIX
#define MY_PREFIX Enforce_Inorder_Execution_of_IO

  /* extraction: 0.31,6./,11./,16./,21.854,31./ #define get-values-from-icache */
#line 22549 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4827 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Enforce In-order Execution of I/O\n"));
#line 22555 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Enforce_Inorder_Execution_of_IO, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4827 "../../../sim/ppc/powerpc.igen"
  {
    /* Since this model has no instruction overlap
       this instruction need do nothing */
  }
#line 22569 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16./,21.854,31./ #undef get-values-from-icache */
#line 22572 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_ByteReversed_Indexed(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_ByteReversed_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_ByteReversed_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.918,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 22599 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2228 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word Byte-Reversed Indexed\n"));
#line 22605 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_ByteReversed_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2228 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 2, SWAP_2(*rS));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 22624 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.918,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 22637 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Half_Word_Rc0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Half_Word
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Half_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22662 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3100 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Half Word\n"));
#line 22668 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Half_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3100 "../../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int16_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22684 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22695 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Half_Word_Rc1(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Half_Word
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Half_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22720 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3100 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Half Word\n"));
#line 22726 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Half_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3100 "../../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int16_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22742 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22753 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Byte_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Byte
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Byte_Rc0

  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22778 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3090 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Byte\n"));
#line 22784 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Byte, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3090 "../../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int8_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22800 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22811 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Byte_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Byte
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Byte_Rc1

  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22836 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3090 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Byte\n"));
#line 22842 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Byte, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3090 "../../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int8_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22858 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22869 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE1_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 22898 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22904 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 22929 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 22944 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE1_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 22973 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22979 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 23004 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 23019 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Instruction_Cache_Block_Invalidate(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Instruction_Cache_Block_Invalidate
#undef MY_PREFIX
#define MY_PREFIX Instruction_Cache_Block_Invalidate

  /* extraction: 0.31,6./,11.RA,16.RB,21.982,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 23043 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4763 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Instruction Cache Block Invalidate\n"));
#line 23049 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Instruction_Cache_Block_Invalidate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4763 "../../../sim/ppc/powerpc.igen"
  {
    /* blindly flush all instruction cache entries */
#if WITH_IDECODE_CACHE_SIZE
    cpu_flush_icache(processor);
#endif
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 23066 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.982,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 23076 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Integer_Word_Indexed(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Integer_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Integer_Word_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.983,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 23102 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3656 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Integer Word Indexed\n"));
#line 23108 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Integer_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3656 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, *frS);
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 23127 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.983,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 23139 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE1_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 23168 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23174 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 23200 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 23215 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE1_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 23244 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23250 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 23276 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 23291 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_set_to_Zero(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_set_to_Zero
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_set_to_Zero

  /* extraction: 0.31,6./,11.RA,16.RB,21.1014,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 23315 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4803 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block set to Zero\n"));
#line 23321 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_set_to_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4803 "../../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block set to Zero\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 23335 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.1014,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 23345 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero

  /* extraction: 0.32,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23370 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1885 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero\n"));
#line 23376 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1885 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(unsigned, EA, 4);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 23395 "semantics.c"
  return nia;
  /* extraction: 0.32,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23406 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero_with_Update(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_with_Update

  /* extraction: 0.33,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23431 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1911 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero with Update\n"));
#line 23437 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1911 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(unsigned, EA, 4);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 23457 "semantics.c"
  return nia;
  /* extraction: 0.33,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23468 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero

  /* extraction: 0.34,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23493 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1722 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero\n"));
#line 23499 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1722 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(unsigned, EA, 1);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 23518 "semantics.c"
  return nia;
  /* extraction: 0.34,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23529 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero_with_Update(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_with_Update

  /* extraction: 0.35,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23554 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1749 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero with Update\n"));
#line 23560 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1749 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(unsigned, EA, 1);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 23580 "semantics.c"
  return nia;
  /* extraction: 0.35,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23591 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word(cpu *processor,
                    idecode_cache *cache_entry,
                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word
#undef MY_PREFIX
#define MY_PREFIX Store_Word

  /* extraction: 0.36,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23616 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2112 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word\n"));
#line 23622 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2112 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 4, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RS_BITMASK, 0);
  }
#line 23641 "semantics.c"
  return nia;
  /* extraction: 0.36,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23652 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_with_Update(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_Word_with_Update

  /* extraction: 0.37,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23677 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2138 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word with Update\n"));
#line 23683 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2138 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 4, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RS_BITMASK, 0);
  }
#line 23703 "semantics.c"
  return nia;
  /* extraction: 0.37,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23714 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte(cpu *processor,
                    idecode_cache *cache_entry,
                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte
#undef MY_PREFIX
#define MY_PREFIX Store_Byte

  /* extraction: 0.38,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23739 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2004 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte\n"));
#line 23745 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2004 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 1, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RS_BITMASK, 0);
  }
#line 23764 "semantics.c"
  return nia;
  /* extraction: 0.38,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23775 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte_with_Update(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_with_Update

  /* extraction: 0.39,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23800 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2030 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte with Update\n"));
#line 23806 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2030 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 1, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RS_BITMASK, 0);
  }
#line 23826 "semantics.c"
  return nia;
  /* extraction: 0.39,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23837 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero

  /* extraction: 0.40,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23862 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1777 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero\n"));
#line 23868 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1777 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(unsigned, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 23887 "semantics.c"
  return nia;
  /* extraction: 0.40,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23898 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero_with_Update(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_with_Update

  /* extraction: 0.41,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23923 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1803 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero with Update\n"));
#line 23929 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1803 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(unsigned, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 23949 "semantics.c"
  return nia;
  /* extraction: 0.41,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23960 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic

  /* extraction: 0.42,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23985 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1831 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic\n"));
#line 23991 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1831 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(signed, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24010 "semantics.c"
  return nia;
  /* extraction: 0.42,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24021 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic_with_Update(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_with_Update

  /* extraction: 0.43,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24046 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1857 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic with Update\n"));
#line 24052 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1857 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(signed, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 24072 "semantics.c"
  return nia;
  /* extraction: 0.43,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24083 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word(cpu *processor,
                         idecode_cache *cache_entry,
                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word

  /* extraction: 0.44,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24108 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2058 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word\n"));
#line 24114 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2058 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 2, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RS_BITMASK, 0);
  }
#line 24133 "semantics.c"
  return nia;
  /* extraction: 0.44,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24144 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_with_Update(cpu *processor,
                                     idecode_cache *cache_entry,
                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_with_Update

  /* extraction: 0.45,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24169 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2084 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word with Update\n"));
#line 24175 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2084 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 2, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RS_BITMASK, 0);
  }
#line 24195 "semantics.c"
  return nia;
  /* extraction: 0.45,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24206 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Multiple_Word(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Multiple_Word
#undef MY_PREFIX
#define MY_PREFIX Load_Multiple_Word

  /* extraction: 0.46,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24231 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2255 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Multiple Word\n"));
#line 24237 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Multiple_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2255 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int r;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    r = RT;
    if (RA >= r)
      program_interrupt(processor, cia,
                      illegal_instruction_program_interrupt);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT || (EA % 4 != 0))
      alignment_interrupt(processor, cia, EA);
    while (r <= 31) {
      GPR(r) = MEM(unsigned, EA, 4);
      r = r + 1;
      EA = EA + 4;
    }
  }
#line 24266 "semantics.c"
  return nia;
  /* extraction: 0.46,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24277 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Multiple_Word(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Multiple_Word
#undef MY_PREFIX
#define MY_PREFIX Store_Multiple_Word

  /* extraction: 0.47,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24302 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2274 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Multiple Word\n"));
#line 24308 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Multiple_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2274 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int r;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT
        || (EA % 4 != 0))
      alignment_interrupt(processor, cia, EA);
    r = RS;
    while (r <= 31) {
      STORE(EA, 4, GPR(r));
      r = r + 1;
      EA = EA + 4;
    }
  }
#line 24335 "semantics.c"
  return nia;
  /* extraction: 0.47,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24346 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single

  /* extraction: 0.48,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24370 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3464 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single\n"));
#line 24376 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3464 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24395 "semantics.c"
  return nia;
  /* extraction: 0.48,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24405 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single_with_Update(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_with_Update

  /* extraction: 0.49,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24429 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3490 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single with Update\n"));
#line 24435 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3490 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24455 "semantics.c"
  return nia;
  /* extraction: 0.49,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24465 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double

  /* extraction: 0.50,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24489 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double\n"));
#line 24495 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3518 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *frT = MEM(unsigned, EA, 8);
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24514 "semantics.c"
  return nia;
  /* extraction: 0.50,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24524 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double_with_Update(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_with_Update

  /* extraction: 0.51,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24548 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3544 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double with Update\n"));
#line 24554 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3544 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *frT = MEM(unsigned, EA, 8);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24574 "semantics.c"
  return nia;
  /* extraction: 0.51,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24584 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single

  /* extraction: 0.52,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24608 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3577 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single\n"));
#line 24614 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3577 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 4, SINGLE(*frS));
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24633 "semantics.c"
  return nia;
  /* extraction: 0.52,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24643 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single_with_Update(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single_with_Update

  /* extraction: 0.53,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24667 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3603 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single with Update\n"));
#line 24673 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3603 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 4, SINGLE(*frS));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24693 "semantics.c"
  return nia;
  /* extraction: 0.53,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24703 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double

  /* extraction: 0.54,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24727 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3631 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double\n"));
#line 24733 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3631 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 8, *frS);
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24752 "semantics.c"
  return nia;
  /* extraction: 0.54,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24762 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double_with_Update(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double_with_Update

  /* extraction: 0.55,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24786 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3669 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double with Update\n"));
#line 24792 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3669 "../../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 8, *frS);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24812 "semantics.c"
  return nia;
  /* extraction: 0.55,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24822 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Single_Rc0(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 24846 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3932 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide Single\n"));
#line 24852 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3932 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     1 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     1 /*single?*/);
    }
    else {
      /*HACK!*/
      float s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 24891 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 24901 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Single_Rc1(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 24925 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3932 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide Single\n"));
#line 24931 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3932 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     1 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     1 /*single?*/);
    }
    else {
      /*HACK!*/
      float s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 24970 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 24980 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Single_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25004 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3821 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract Single\n"));
#line 25010 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3821 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25042 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25052 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Single_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25076 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3821 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract Single\n"));
#line 25082 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3821 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25114 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25124 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Single_Rc0(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25148 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3769 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add Single\n"));
#line 25154 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3769 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25186 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25196 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Single_Rc1(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25220 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3769 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add Single\n"));
#line 25226 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3769 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25258 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25268 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Single_Rc0(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Single_Rc0

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25290 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4726 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root Single\n"));
#line 25296 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4726 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25309 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25317 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Single_Rc1(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Single_Rc1

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25339 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4726 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root Single\n"));
#line 25345 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4726 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25358 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25366 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Estimate_Single_Rc0(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Estimate_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Estimate_Single_Rc0

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25388 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4729 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Estimate Single\n"));
#line 25394 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Estimate_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4729 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25407 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25415 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Estimate_Single_Rc1(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Estimate_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Estimate_Single_Rc1

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25437 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4729 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Estimate Single\n"));
#line 25443 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Estimate_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4729 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25456 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25464 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_Single_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25488 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3873 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply Single\n"));
#line 25494 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3873 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 25526 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25536 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_Single_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25560 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3873 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply Single\n"));
#line 25566 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3873 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 25598 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25608 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_Single_Rc0(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25634 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4106 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract Single\n"));
#line 25640 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4106 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product - *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25693 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25705 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_Single_Rc1(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25731 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4106 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract Single\n"));
#line 25737 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4106 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product - *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25790 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25802 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_Single_Rc0(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25828 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4012 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add Single\n"));
#line 25834 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4012 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product + *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25887 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25899 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_Single_Rc1(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25925 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4012 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add Single\n"));
#line 25931 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4012 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product + *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25984 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25996 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_Single_Rc0(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26022 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4294 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract Single\n"));
#line 26028 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4294 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product - *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26081 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26093 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_Single_Rc1(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 26119 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4294 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract Single\n"));
#line 26125 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4294 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product - *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26178 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26190 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_Single_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26216 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4200 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add Single\n"));
#line 26222 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4200 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product + *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26275 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26287 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_Single_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 26313 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4200 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add Single\n"));
#line 26319 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4200 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product + *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26372 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26384 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Compare_Unordered(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Compare_Unordered
#undef MY_PREFIX
#define MY_PREFIX Floating_Compare_Unordered

  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.0,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.X.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.X.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#line 26407 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4621 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Compare Unordered\n"));
#line 26413 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Compare_Unordered, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4621 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    unsigned c;
    if (is_NaN(*frA, 0) || is_NaN(*frB, 0))
      c = cr_i_summary_overflow; /* 0b0001 - (FRA) ? (FRB) */
    else if (is_less_than(frA, frB))
      c = cr_i_negative; /* 0b1000 - (FRA) < (FRB) */
    else if (is_greater_than(frA, frB))
      c = cr_i_positive; /* 0b0100 - (FRA) > (FRB) */
    else
      c = cr_i_zero; /* 0b0010 - (FRA) = (FRB) */
    FPSCR_SET_FPCC(c);
    CR_SET(BF, c); /* CR[4*BF..4*BF+3] = c */
    if (is_SNaN(*frA, 0) || is_SNaN(*frB, 0))
      FPSCR_OR_VX(fpscr_vxsnan);
    FPSCR_END(0);
    PPC_INSN_FLOAT_CR(0, FRA_BITMASK | FRB_BITMASK, BF_BITMASK);
  }
#line 26441 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.0,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#line 26450 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Round_to_SinglePrecision_Rc0(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Round_to_SinglePrecision
#undef MY_PREFIX
#define MY_PREFIX Floating_Round_to_SinglePrecision_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26472 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4346 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Round to Single-Precision\n"));
#line 26478 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Round_to_SinglePrecision, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4346 "../../../sim/ppc/powerpc.igen"
  {
    int sign;
    int exp;
    uint64_t frac_grx;
    /***/
      /* split off cases for what to do */
      if (EXTRACTED64(*frB, 1, 11) < 897
          && EXTRACTED64(*frB, 1, 63) > 0) {
          if ((FPSCR & fpscr_ue) == 0) GOTO(Disabled_Exponent_Underflow);
          if ((FPSCR & fpscr_ue) != 0) GOTO(Enabled_Exponent_Underflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 1150
          && EXTRACTED64(*frB, 1, 11) < 2047) {
          if ((FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
          if ((FPSCR & fpscr_oe) != 0) GOTO(Enabled_Exponent_Overflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 896
          && EXTRACTED64(*frB, 1, 11) < 1151) GOTO(Normal_Operand);
      if (EXTRACTED64(*frB, 1, 63) == 0) GOTO(Zero_Operand);
      if (EXTRACTED64(*frB, 1, 11) == 2047) {
        if (EXTRACTED64(*frB, 12, 63) == 0) GOTO(Infinity_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 1) GOTO(QNaN_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 0
            && EXTRACTED64(*frB, 13, 63) > 0) GOTO(SNaN_Operand);
      }
    /**/
    LABEL(Disabled_Exponent_Underflow):
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
        /* G|R|X == zero from above */
        while (exp < -126) {
          exp = exp + 1;
          frac_grx = (INSERTED64(EXTRACTED64(frac_grx, 0, 54), 1, 55)
                      | MASKED64(frac_grx, 55, 55));
        }
      FPSCR_SET_UX(EXTRACTED64(frac_grx, 24, 55) > 0);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (EXTRACTED64(frac_grx, 0, 52) == 0) {
        *frT = INSERTED64(sign, 0, 0);
        if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
        if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      }
      if (EXTRACTED64(frac_grx, 0, 52) > 0) {
        if (EXTRACTED64(frac_grx, 0, 0) == 1) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
        if (EXTRACTED64(frac_grx, 0, 0) == 0) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_denormalized_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_denormalized_number);
        }
        /*Normalize_Operand:*/
          while (EXTRACTED64(frac_grx, 0, 0) == 0) {
            exp = exp - 1;
            frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1,  52), 0, 51);
          }
        *frT = (INSERTED64(sign, 0, 0)
                | INSERTED64(exp + 1023, 1, 11)
                | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      }
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Underflow):
      FPSCR_SET_UX(1);
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = (BIT64(0) |
                    INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52));
      }
      /*Normalize_Operand:*/
        while (EXTRACTED64(frac_grx, 0, 0) == 0) {
          exp = exp - 1;
          frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1, 52), 0, 51);
        }
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      exp = exp + 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Disabled_Exponent_Overflow):
      FPSCR_SET_OX(1);
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_to_nearest) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_zero) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_pos_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_neg_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      /* FPSCR[FR] <- undefined */
      FPSCR_SET_FI(1);
      FPSCR_SET_XX(1);
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Overflow):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
    /**/
    LABEL(Enabled_Overflow):
      FPSCR_SET_OX(1);
      exp = exp - 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Zero_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Infinity_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(QNaN_Operand):
      *frT = INSERTED64(EXTRACTED64(*frB, 0, 34), 0, 34);
      FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(SNaN_Operand):
      FPSCR_OR_VX(fpscr_vxsnan);
      if ((FPSCR & fpscr_ve) == 0) {
        *frT = (MASKED64(*frB, 0, 11)
                | BIT64(12)
                | MASKED64(*frB, 13, 34));
        FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      }
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Normal_Operand):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (exp > 127 && (FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
      if (exp > 127 && (FPSCR & fpscr_oe) != 0) GOTO(Enabled_Overflow);
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Done):
      PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 26702 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 26710 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Round_to_SinglePrecision_Rc1(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Round_to_SinglePrecision
#undef MY_PREFIX
#define MY_PREFIX Floating_Round_to_SinglePrecision_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 26732 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4346 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Round to Single-Precision\n"));
#line 26738 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Round_to_SinglePrecision, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4346 "../../../sim/ppc/powerpc.igen"
  {
    int sign;
    int exp;
    uint64_t frac_grx;
    /***/
      /* split off cases for what to do */
      if (EXTRACTED64(*frB, 1, 11) < 897
          && EXTRACTED64(*frB, 1, 63) > 0) {
          if ((FPSCR & fpscr_ue) == 0) GOTO(Disabled_Exponent_Underflow);
          if ((FPSCR & fpscr_ue) != 0) GOTO(Enabled_Exponent_Underflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 1150
          && EXTRACTED64(*frB, 1, 11) < 2047) {
          if ((FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
          if ((FPSCR & fpscr_oe) != 0) GOTO(Enabled_Exponent_Overflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 896
          && EXTRACTED64(*frB, 1, 11) < 1151) GOTO(Normal_Operand);
      if (EXTRACTED64(*frB, 1, 63) == 0) GOTO(Zero_Operand);
      if (EXTRACTED64(*frB, 1, 11) == 2047) {
        if (EXTRACTED64(*frB, 12, 63) == 0) GOTO(Infinity_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 1) GOTO(QNaN_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 0
            && EXTRACTED64(*frB, 13, 63) > 0) GOTO(SNaN_Operand);
      }
    /**/
    LABEL(Disabled_Exponent_Underflow):
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
        /* G|R|X == zero from above */
        while (exp < -126) {
          exp = exp + 1;
          frac_grx = (INSERTED64(EXTRACTED64(frac_grx, 0, 54), 1, 55)
                      | MASKED64(frac_grx, 55, 55));
        }
      FPSCR_SET_UX(EXTRACTED64(frac_grx, 24, 55) > 0);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (EXTRACTED64(frac_grx, 0, 52) == 0) {
        *frT = INSERTED64(sign, 0, 0);
        if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
        if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      }
      if (EXTRACTED64(frac_grx, 0, 52) > 0) {
        if (EXTRACTED64(frac_grx, 0, 0) == 1) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
        if (EXTRACTED64(frac_grx, 0, 0) == 0) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_denormalized_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_denormalized_number);
        }
        /*Normalize_Operand:*/
          while (EXTRACTED64(frac_grx, 0, 0) == 0) {
            exp = exp - 1;
            frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1,  52), 0, 51);
          }
        *frT = (INSERTED64(sign, 0, 0)
                | INSERTED64(exp + 1023, 1, 11)
                | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      }
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Underflow):
      FPSCR_SET_UX(1);
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = (BIT64(0) |
                    INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52));
      }
      /*Normalize_Operand:*/
        while (EXTRACTED64(frac_grx, 0, 0) == 0) {
          exp = exp - 1;
          frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1, 52), 0, 51);
        }
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      exp = exp + 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Disabled_Exponent_Overflow):
      FPSCR_SET_OX(1);
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_to_nearest) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_zero) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_pos_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_neg_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      /* FPSCR[FR] <- undefined */
      FPSCR_SET_FI(1);
      FPSCR_SET_XX(1);
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Overflow):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
    /**/
    LABEL(Enabled_Overflow):
      FPSCR_SET_OX(1);
      exp = exp - 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Zero_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Infinity_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(QNaN_Operand):
      *frT = INSERTED64(EXTRACTED64(*frB, 0, 34), 0, 34);
      FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(SNaN_Operand):
      FPSCR_OR_VX(fpscr_vxsnan);
      if ((FPSCR & fpscr_ve) == 0) {
        *frT = (MASKED64(*frB, 0, 11)
                | BIT64(12)
                | MASKED64(*frB, 13, 34));
        FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      }
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Normal_Operand):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (exp > 127 && (FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
      if (exp > 127 && (FPSCR & fpscr_oe) != 0) GOTO(Enabled_Overflow);
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Done):
      PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 26962 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 26970 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_Rc0(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26992 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4567 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word\n"));
#line 26998 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4567 "../../../sim/ppc/powerpc.igen"
  {
    floating_point_assist_interrupt(processor, cia);
  }
#line 27011 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27019 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_Rc1(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27041 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4567 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word\n"));
#line 27047 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4567 "../../../sim/ppc/powerpc.igen"
  {
    floating_point_assist_interrupt(processor, cia);
  }
#line 27060 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27068 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc0(cpu *processor,
                                                                      idecode_cache *cache_entry,
                                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27090 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4574 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word with round towards Zero\n"));
#line 27096 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4574 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    convert_to_integer(processor, cia,
                       frT, *frB,
                       fpscr_rn_round_towards_zero, 32);
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 27114 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27122 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc1(cpu *processor,
                                                                      idecode_cache *cache_entry,
                                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27144 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4574 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word with round towards Zero\n"));
#line 27150 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4574 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    convert_to_integer(processor, cia,
                       frT, *frB,
                       fpscr_rn_round_towards_zero, 32);
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 27168 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27176 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27200 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3899 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide\n"));
#line 27206 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3899 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     0 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     0 /*single?*/);
    }
    else {
      /*HACK!*/
      double s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27245 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27255 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27279 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3899 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide\n"));
#line 27285 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3899 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     0 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     0 /*single?*/);
    }
    else {
      /*HACK!*/
      double s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27324 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27334 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Rc0(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27358 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3795 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract\n"));
#line 27364 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3795 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27396 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27406 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Rc1(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27430 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3795 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract\n"));
#line 27436 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3795 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27468 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27478 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Rc0(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27502 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3743 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add\n"));
#line 27508 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3743 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27540 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27550 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Rc1(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27574 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3743 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add\n"));
#line 27580 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3743 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27612 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27622 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Rc0(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27644 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4723 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root\n"));
#line 27650 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4723 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 27663 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27671 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Rc1(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27693 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4723 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root\n"));
#line 27699 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4723 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 27712 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27720 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC0_Rc0(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27746 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 27752 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 27774 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27786 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC0_Rc1(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27812 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 27818 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 27840 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27852 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC0_Rc0(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27876 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 27882 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 27914 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27924 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC0_Rc1(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27948 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 27954 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 27986 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27996 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Square_Root_Estimate_Rc0(cpu *processor,
                                                      idecode_cache *cache_entry,
                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Square_Root_Estimate
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Square_Root_Estimate_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28018 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4732 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Square Root Estimate\n"));
#line 28024 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Square_Root_Estimate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4732 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 28037 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 28045 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Square_Root_Estimate_Rc1(cpu *processor,
                                                      idecode_cache *cache_entry,
                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Square_Root_Estimate
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Square_Root_Estimate_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28067 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4732 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Square Root Estimate\n"));
#line 28073 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Square_Root_Estimate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4732 "../../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 28086 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 28094 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC0_Rc0(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28120 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 28126 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28179 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28191 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC0_Rc1(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28217 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 28223 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28276 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28288 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC0_Rc0(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28314 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 28320 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28373 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28385 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC0_Rc1(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28411 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 28417 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28470 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28482 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC0_Rc0(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28508 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 28514 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28567 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28579 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC0_Rc1(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28605 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 28611 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28664 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28676 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC0_Rc0(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28702 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add\n"));
#line 28708 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4153 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product + *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28761 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28773 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC0_Rc1(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28799 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add\n"));
#line 28805 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4153 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product + *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28858 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28870 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Compare_Ordered(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Compare_Ordered
#undef MY_PREFIX
#define MY_PREFIX Floating_Compare_Ordered

  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.32,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.X.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.X.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#line 28893 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Compare Ordered\n"));
#line 28899 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Compare_Ordered, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4643 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    unsigned c;
    if (is_NaN(*frA, 0) || is_NaN(*frB, 0))
      c = cr_i_summary_overflow; /* 0b0001 - (FRA) ? (FRB) */
    else if (is_less_than(frA, frB))
      c = cr_i_negative; /* 0b1000 - (FRA) < (FRB) */
    else if (is_greater_than(frA, frB))
      c = cr_i_positive; /* 0b0100 - (FRA) > (FRB) */
    else
      c = cr_i_zero; /* 0b0010 - (FRA) = (FRB) */
    FPSCR_SET_FPCC(c);
    CR_SET(BF, c); /* CR[4*BF..4*BF+3] = c */
    if (is_SNaN(*frA, 0) || is_SNaN(*frB, 0)) {
      FPSCR_OR_VX(fpscr_vxsnan);
      if ((FPSCR & fpscr_ve) == 0)
        FPSCR_OR_VX(fpscr_vxvc);
    }
    else if (is_QNaN(*frA, 0) || is_QNaN(*frB, 0)) {
      FPSCR_OR_VX(fpscr_vxvc);
    }
    FPSCR_END(0);
    PPC_INSN_FLOAT_CR(0, FRA_BITMASK | FRB_BITMASK, BF_BITMASK);
  }
#line 28933 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.32,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#line 28942 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_FPSCR_Bit_1_Rc0(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_FPSCR_Bit_1
#undef MY_PREFIX
#define MY_PREFIX Move_To_FPSCR_Bit_1_Rc0

  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #define get-values-from-icache */
#define BT cache_entry->crack.X.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.X.BT_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28962 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4706 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To FPSCR Bit 1\n"));
#line 28968 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_FPSCR_Bit_1, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4706 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    uint32_t bit = BIT32(BT);
    if (bit & fpscr_fi)
      bit |= fpscr_xx;
    if ((bit & fpscr_vx_bits))
      bit |= fpscr_fx;
    /* note - omit vx bit */
    if ((bit & (fpscr_ox | fpscr_ux | fpscr_zx | fpscr_xx)))
      bit |= fpscr_fx;
    FPSCR |= bit;
    FPSCR_END(Rc);
  }
#line 28991 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef Rc
#line 28997 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_FPSCR_Bit_1_Rc1(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_FPSCR_Bit_1
#undef MY_PREFIX
#define MY_PREFIX Move_To_FPSCR_Bit_1_Rc1

  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #define get-values-from-icache */
#define BT cache_entry->crack.X.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.X.BT_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29017 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4706 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To FPSCR Bit 1\n"));
#line 29023 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_FPSCR_Bit_1, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4706 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    uint32_t bit = BIT32(BT);
    if (bit & fpscr_fi)
      bit |= fpscr_xx;
    if ((bit & fpscr_vx_bits))
      bit |= fpscr_fx;
    /* note - omit vx bit */
    if ((bit & (fpscr_ox | fpscr_ux | fpscr_zx | fpscr_xx)))
      bit |= fpscr_fx;
    FPSCR |= bit;
    FPSCR_END(Rc);
  }
#line 29046 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef Rc
#line 29052 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negate_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negate
#undef MY_PREFIX
#define MY_PREFIX Floating_Negate_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29074 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3711 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negate\n"));
#line 29080 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3711 "../../../sim/ppc/powerpc.igen"
  {
    *frT = *frB ^ BIT64(0);
    CR1_UPDATE(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 29095 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 29103 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negate_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negate
#undef MY_PREFIX
#define MY_PREFIX Floating_Negate_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29125 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3711 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negate\n"));
#line 29131 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3711 "../../../sim/ppc/powerpc.igen"
  {
    *frT = *frB ^ BIT64(0);
    CR1_UPDATE(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 29146 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 29154 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC1_Rc0(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29180 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 29186 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 29208 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29220 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC1_Rc1(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29246 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 29252 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 29274 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29286 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC1_Rc0(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29310 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 29316 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 29348 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29358 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC1_Rc1(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29382 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 29388 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 29420 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29430 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC1_Rc0(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29456 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 29462 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29515 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29527 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC1_Rc1(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29553 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 29559 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29612 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29624 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC1_Rc0(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29650 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 29656 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29709 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29721 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC1_Rc1(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29747 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 29753 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29806 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29818 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC1_Rc0(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29844 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 29850 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29903 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29915 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC1_Rc1(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29941 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 29947 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 30000 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 30012 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC1_Rc0(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 30038 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add\n"));
#line 30044 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4153 "../../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /