
/*  This file is part of the program psim.

    Copyright (C) 1994-1995, Andrew Cagney <cagney@highland.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.

    --

    This file was generated by the program igen */

#ifndef _IDECODE_H_
#define _IDECODE_H_

/* The idecode_*.h functions shall move to support */
#include "idecode_expression.h"
#include "idecode_fields.h"
#include "idecode_branch.h"


#define WITH_IDECODE_CACHE_SIZE 1024

typedef struct _idecode_cache {
  unsigned_word address;
  void *semantic;
  union {
    struct {
      instruction_word insn;
      unsigned FRA; /* FRA */
      uint64_t * frA; /* FRA */
      uint32_t FRA_BITMASK; /* FRA */
      unsigned FRB; /* FRB */
      uint64_t * frB; /* FRB */
      uint32_t FRB_BITMASK; /* FRB */
      unsigned FRC; /* FRC */
      uint64_t * frC; /* FRC */
      uint32_t FRC_BITMASK; /* FRC */
      unsigned FRT; /* FRT */
      uint64_t * frT; /* FRT */
      uint32_t FRT_BITMASK; /* FRT */
      unsigned Rc;
    } A;
    struct {
      instruction_word insn;
      unsigned AA;
      unsigned_word EXTS_BD_0b00; /* BD */
      unsigned BI; /* BI */
      unsigned BIT32_BI; /* BI */
      unsigned BO;
      unsigned LK;
    } B;
    struct {
      instruction_word insn;
      unsigned BF; /* BF */
      uint32_t BF_BITMASK; /* BF */
      unsigned_word EXTS_D; /* D */
      unsigned FRS; /* FRS */
      uint64_t * frS; /* FRS */
      uint32_t FRS_BITMASK; /* FRS */
      unsigned FRT; /* FRT */
      uint64_t * frT; /* FRT */
      uint32_t FRT_BITMASK; /* FRT */
      unsigned L;
      unsigned RA; /* RA */
      signed_word * rA; /* RA */
      uint32_t RA_BITMASK; /* RA */
      int RA_is_0; /* RA */
      unsigned RS; /* RS */
      signed_word * rS; /* RS */
      uint32_t RS_BITMASK; /* RS */
      unsigned RT; /* RT */
      signed_word * rT; /* RT */
      uint32_t RT_BITMASK; /* RT */
      unsigned_word EXTS_SI; /* SI */
      unsigned TO;
      unsigned UI;
    } D;
    struct {
      instruction_word insn;
      unsigned AA;
      unsigned_word EXTS_LI_0b00; /* LI */
      unsigned LK;
    } I;
    struct {
      instruction_word insn;
      unsigned MB;
      unsigned ME;
      unsigned RA; /* RA */
      signed_word * rA; /* RA */
      uint32_t RA_BITMASK; /* RA */
      int RA_is_0; /* RA */
      unsigned RB; /* RB */
      signed_word * rB; /* RB */
      uint32_t RB_BITMASK; /* RB */
      unsigned RS; /* RS */
      signed_word * rS; /* RS */
      uint32_t RS_BITMASK; /* RS */
      unsigned Rc;
      unsigned SH;
    } M;
    struct {
      instruction_word insn;
    } SC;
    struct {
      instruction_word insn;
      unsigned BF; /* BF */
      uint32_t BF_BITMASK; /* BF */
      unsigned BFA;
      unsigned BT; /* BT */
      uint32_t BT_BITMASK; /* BT */
      unsigned FRA; /* FRA */
      uint64_t * frA; /* FRA */
      uint32_t FRA_BITMASK; /* FRA */
      unsigned FRB; /* FRB */
      uint64_t * frB; /* FRB */
      uint32_t FRB_BITMASK; /* FRB */
      unsigned FRS; /* FRS */
      uint64_t * frS; /* FRS */
      uint32_t FRS_BITMASK; /* FRS */
      unsigned FRT; /* FRT */
      uint64_t * frT; /* FRT */
      uint32_t FRT_BITMASK; /* FRT */
      unsigned L;
      unsigned NB;
      unsigned RA; /* RA */
      signed_word * rA; /* RA */
      uint32_t RA_BITMASK; /* RA */
      int RA_is_0; /* RA */
      unsigned RB; /* RB */
      signed_word * rB; /* RB */
      uint32_t RB_BITMASK; /* RB */
      unsigned RS; /* RS */
      signed_word * rS; /* RS */
      uint32_t RS_BITMASK; /* RS */
      unsigned RT; /* RT */
      signed_word * rT; /* RT */
      uint32_t RT_BITMASK; /* RT */
      unsigned Rc;
      unsigned SH;
      unsigned SR;
      unsigned TO;
      unsigned U;
    } X;
    struct {
      instruction_word insn;
      unsigned FLM;
      unsigned FRB; /* FRB */
      uint64_t * frB; /* FRB */
      uint32_t FRB_BITMASK; /* FRB */
      unsigned Rc;
    } XFL;
    struct {
      instruction_word insn;
      unsigned FXM;
      unsigned RS; /* RS */
      signed_word * rS; /* RS */
      uint32_t RS_BITMASK; /* RS */
      unsigned RT; /* RT */
      signed_word * rT; /* RT */
      uint32_t RT_BITMASK; /* RT */
      unsigned SPR;
      unsigned tbr;
    } XFX;
    struct {
      instruction_word insn;
      unsigned BA; /* BA */
      unsigned BIT32_BA; /* BA */
      uint32_t BA_BITMASK; /* BA */
      unsigned BB; /* BB */
      unsigned BIT32_BB; /* BB */
      uint32_t BB_BITMASK; /* BB */
      unsigned BF; /* BF */
      uint32_t BF_BITMASK; /* BF */
      unsigned BFA;
      unsigned BI; /* BI */
      unsigned BIT32_BI; /* BI */
      unsigned BO;
      unsigned BT; /* BT */
      uint32_t BT_BITMASK; /* BT */
      unsigned LK;
    } XL;
    struct {
      instruction_word insn;
      unsigned OE;
      unsigned RA; /* RA */
      signed_word * rA; /* RA */
      uint32_t RA_BITMASK; /* RA */
      int RA_is_0; /* RA */
      unsigned RB; /* RB */
      signed_word * rB; /* RB */
      uint32_t RB_BITMASK; /* RB */
      unsigned RT; /* RT */
      signed_word * rT; /* RT */
      uint32_t RT_BITMASK; /* RT */
      unsigned Rc;
    } XO;
  } crack;
} idecode_cache;


#define WITH_IDECODE_SMP 5


PSIM_INLINE_IDECODE\
(void) idecode_run
(psim *system,
 event_queue *events,
 cpu *const processors[],
 const int nr_cpus);

PSIM_INLINE_IDECODE\
(void) idecode_run_until_stop
(psim *system,
 volatile int *keep_running,
 event_queue *events,
 cpu *const processors[],
 const int nr_cpus);

#endif /* _IDECODE_H_*/
