
/*  This file is part of the program psim.

    Copyright (C) 1994-1995, Andrew Cagney <cagney@highland.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.

    --

    This file was generated by the program igen */

#ifndef _ICACHE_C_
#define _ICACHE_C_


#include "cpu.h"
#include "idecode.h"
#include "semantics.h"
#include "icache.h"
#ifdef HAVE_COMMON_FPU
#include "sim-inline.h"
#include "sim-fpu.h"
#endif
#include "support.h"


PSIM_INLINE_ICACHE\
(unsigned_word)
icache_illegal
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry)
{
  /* semantic routine */
#line 982 "../../../sim/ppc/powerpc.igen"
  program_interrupt(processor, cia,
                    illegal_instruction_program_interrupt);
  error("Internal function must longjump\n");
  return 0;
#line 53 "icache.c"
}

PSIM_INLINE_ICACHE\
(unsigned_word)
icache_floating_point_unavailable
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry)
{
  /* semantic routine */
#line 990 "../../../sim/ppc/powerpc.igen"
  floating_point_unavailable_interrupt(processor, cia);
  error("Internal function must longjump\n");
  return 0;
#line 69 "icache.c"
}


EXTERN_ICACHE\
(unsigned_word)
icache_instruction_call(cpu *processor,
                        instruction_word instruction,
                        unsigned_word cia,
                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_instruction_call
#undef MY_PREFIX
#define MY_PREFIX instruction_call
#line 1493 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode instruction_call\n"));
#line 86 "icache.c"

  /* validate: 0.0,6./,11./,16./,21./,31.1 */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x1)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.0,6./,11./,16./,21./,31.1 #define get-values-from-icache|put-values-in-icache */
#line 95 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_instruction_call;

    /* semantic routine */
#line 1493 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics instruction_call\n"));
#line 105 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_instruction_call, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1493 "../../../sim/ppc/powerpc.igen"
    {
      if (!os_emul_instruction_call(processor, cia, real_addr(cia, 1)))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
    }
#line 120 "icache.c"
    return nia;
    /* extraction: 0.0,6./,11./,16./,21./,31.1 #undef get-values-from-icache|put-values-in-icache */
#line 123 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Trap_Word_Immediate(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Trap_Word_Immediate
#line 2897 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Trap Word Immediate\n"));
#line 142 "icache.c"

  /* validate: 0.3,6.TO,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0xc000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.3,6.TO,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 2897 "../../../sim/ppc/powerpc.igen"
    unsigned const TO ATTRIBUTE_UNUSED = cache_entry->crack.D.TO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 162 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Trap_Word_Immediate;

    /* semantic routine */
#line 2897 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Trap Word Immediate\n"));
#line 172 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Trap_Word_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2897 "../../../sim/ppc/powerpc.igen"
    {
      signed_word a = EXTENDED(*rA);
      signed_word b = EXTS(SI);
      if ((a < b && TO_0_)
          || (a > b && TO_1_)
          || (a == b && TO_2_)
          || ((unsigned_word)a < (unsigned_word)b && TO_3_)
          || ((unsigned_word)a > (unsigned_word)b && TO_4_)
          )
        program_interrupt(processor, cia,
                          trap_program_interrupt);
    }
#line 194 "icache.c"
    return nia;
    /* extraction: 0.3,6.TO,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 198 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_Low_Immediate(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Immediate
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Immediate
#line 2687 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply Low Immediate\n"));
#line 217 "icache.c"

  /* validate: 0.7,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x1c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.7,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 241 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_Low_Immediate;

    /* semantic routine */
#line 2687 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply Low Immediate\n"));
#line 251 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_Low_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2687 "../../../sim/ppc/powerpc.igen"
    {
      signed_word prod = *rA * EXTS(SI);
      *rT = prod;
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
    }
#line 266 "icache.c"
    return nia;
    /* extraction: 0.7,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 270 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Immediate_Carrying(cpu *processor,
                                        instruction_word instruction,
                                        unsigned_word cia,
                                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Immediate_Carrying
#line 2574 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Immediate Carrying\n"));
#line 289 "icache.c"

  /* validate: 0.8,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x20000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.8,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 313 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Immediate_Carrying;

    /* semantic routine */
#line 2574 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Immediate Carrying\n"));
#line 323 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Immediate_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2574 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(EXTS(SI));
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
    }
#line 341 "icache.c"
    return nia;
    /* extraction: 0.8,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 345 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare_Logical_Immediate(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical_Immediate
#line 2833 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare Logical Immediate\n"));
#line 364 "icache.c"

  /* validate: 0.10,6.BF,9./,10.L,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc400000) != 0x28000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 67 "../../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.D.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2833 "../../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.D.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2833 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 388 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare_Logical_Immediate;

    /* semantic routine */
#line 2833 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare Logical Immediate\n"));
#line 398 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare_Logical_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2833 "../../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        unsigned_word a;
        unsigned_word b = UI;
        if (L == 0)
          a = MASKED(*rA, 32, 63);
        else
          a = *rA;
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
    }
#line 423 "icache.c"
    return nia;
    /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 427 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare_Immediate(cpu *processor,
                         instruction_word instruction,
                         unsigned_word cia,
                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Immediate
#line 2791 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare Immediate\n"));
#line 446 "icache.c"

  /* validate: 0.11,6.BF,9./,10.L,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc400000) != 0x2c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 67 "../../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.D.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2791 "../../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.D.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 470 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare_Immediate;

    /* semantic routine */
#line 2791 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare Immediate\n"));
#line 480 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2791 "../../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        signed_word a;
        signed_word b = EXTS(SI);
        if (L == 0)
          a = EXTENDED(*rA);
        else
          a = *rA;
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
    }
#line 505 "icache.c"
    return nia;
    /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 509 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Carrying(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying
#line 2554 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Carrying\n"));
#line 528 "icache.c"

  /* validate: 0.12,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x30000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.12,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 552 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Carrying;

    /* semantic routine */
#line 2554 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Carrying\n"));
#line 562 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2554 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(EXTS(SI));
      ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
    }
#line 578 "icache.c"
    return nia;
    /* extraction: 0.12,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 582 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Carrying_and_Record(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying_and_Record
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying_and_Record
#line 2564 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Carrying and Record\n"));
#line 601 "icache.c"

  /* validate: 0.13,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x34000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.13,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 625 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Carrying_and_Record;

    /* semantic routine */
#line 2564 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Carrying and Record\n"));
#line 635 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Carrying_and_Record, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2564 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(EXTS(SI));
      ALU_END(*rT, 1/*CA*/, 0/*OE*/, 1/*Rc*/);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 1/*Rc*/);
    }
#line 651 "icache.c"
    return nia;
    /* extraction: 0.13,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 655 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_RA0(cpu *processor,
                         instruction_word instruction,
                         unsigned_word cia,
                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA0
#line 2512 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate\n"));
#line 674 "icache.c"

  /* validate: 0.14,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x38000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = 0; /* in icache - constant field */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 698 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_RA0;

    /* semantic routine */
#line 2512 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 708 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2512 "../../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI);
      else		*rT = *rA + EXTS(SI);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 724 "icache.c"
    return nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 728 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_RA(cpu *processor,
                        instruction_word instruction,
                        unsigned_word cia,
                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA
#line 2512 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate\n"));
#line 747 "icache.c"

  /* validate: 0.14,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x38000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 771 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_RA;

    /* semantic routine */
#line 2512 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 781 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2512 "../../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI);
      else		*rT = *rA + EXTS(SI);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 797 "icache.c"
    return nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 801 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Shifted_RA0(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA0
#line 2522 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Shifted\n"));
#line 820 "icache.c"

  /* validate: 0.15,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x3c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = 0; /* in icache - constant field */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 844 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Shifted_RA0;

    /* semantic routine */
#line 2522 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 854 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2522 "../../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI) << 16;
      else		*rT = *rA + (EXTS(SI) << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 870 "icache.c"
    return nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 874 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Shifted_RA(cpu *processor,
                                instruction_word instruction,
                                unsigned_word cia,
                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA
#line 2522 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Shifted\n"));
#line 893 "icache.c"

  /* validate: 0.15,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x3c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 917 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Shifted_RA;

    /* semantic routine */
#line 2522 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 927 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2522 "../../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI) << 16;
      else		*rT = *rA + (EXTS(SI) << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 943 "icache.c"
    return nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 947 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO0
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 966 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 986 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO0;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 996 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1045 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1049 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO1
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1068 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1088 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO1;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1098 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1147 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1151 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO2
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1170 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1190 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO2;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1200 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1249 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1253 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO3
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1272 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1292 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO3;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1302 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1351 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1355 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO4
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1374 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1394 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO4;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1404 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1453 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1457 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO5
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1476 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1496 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO5;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1506 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1555 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1559 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO6
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1578 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1598 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO6;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1608 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1657 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1661 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO7
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1680 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1700 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO7;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1710 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1759 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1763 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO8
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1782 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1802 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO8;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1812 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1861 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1865 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO9
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1884 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1904 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO9;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1914 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1963 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1967 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO10
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1986 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2006 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO10;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2016 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2065 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2069 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO11
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2088 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2108 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO11;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2118 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2167 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2171 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO12
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2190 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2210 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO12;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2220 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2269 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2273 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO13
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2292 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2312 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO13;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2322 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2371 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2375 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO14
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2394 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2414 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO14;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2424 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2473 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2477 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO15
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2496 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2516 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO15;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2526 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2575 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2579 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO16
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2598 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2618 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO16;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2628 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2677 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2681 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO17
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2700 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2720 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO17;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2730 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2779 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2783 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO18
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2802 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2822 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO18;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2832 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2881 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2885 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO19
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2904 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2924 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO19;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2934 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2983 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2987 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO20
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3006 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3026 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO20;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3036 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3085 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3089 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO21
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3108 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3128 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO21;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3138 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3187 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3191 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO22
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3210 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3230 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO22;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3240 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3289 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3293 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO23
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3312 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3332 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO23;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3342 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3391 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3395 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO24
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3414 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3434 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO24;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3444 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3493 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3497 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO25
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3516 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3536 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO25;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3546 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3595 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3599 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO26
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3618 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3638 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO26;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3648 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3697 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3701 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO27
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3720 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3740 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO27;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3750 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3799 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3803 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO28
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3822 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3842 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO28;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3852 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3901 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3905 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO29
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3924 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3944 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO29;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3954 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4003 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4007 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO30
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4026 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 4046 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO30;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4056 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4105 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4109 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO31
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4128 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 4148 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO31;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4158 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4207 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4211 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO0
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4230 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4250 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO0;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4260 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4309 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4313 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO1
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4332 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4352 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO1;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4362 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4411 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4415 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO2
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4434 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4454 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO2;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4464 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4513 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4517 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO3
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4536 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4556 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO3;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4566 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4615 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4619 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO4
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4638 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4658 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO4;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4668 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4717 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4721 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO5
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4740 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4760 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO5;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4770 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4819 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4823 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO6
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4842 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4862 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO6;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4872 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4921 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4925 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO7
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4944 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4964 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO7;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4974 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5023 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5027 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO8
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5046 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5066 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO8;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5076 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5125 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5129 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO9
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5148 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5168 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO9;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5178 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5227 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5231 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO10
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5250 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5270 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO10;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5280 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5329 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5333 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO11
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5352 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5372 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO11;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5382 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5431 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5435 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO12
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5454 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5474 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO12;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5484 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5533 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5537 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO13
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5556 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5576 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO13;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5586 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5635 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5639 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO14
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5658 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5678 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO14;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5688 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5737 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5741 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO15
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5760 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5780 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO15;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5790 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5839 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5843 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO16
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5862 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5882 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO16;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5892 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5941 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5945 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO17
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5964 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5984 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO17;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5994 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6043 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6047 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO18
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6066 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6086 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO18;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6096 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6145 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6149 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO19
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6168 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6188 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO19;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6198 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6247 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6251 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO20
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6270 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6290 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO20;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6300 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6349 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6353 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO21
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6372 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6392 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO21;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6402 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6451 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6455 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO22
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6474 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6494 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO22;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6504 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6553 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6557 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO23
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6576 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6596 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO23;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6606 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6655 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6659 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO24
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6678 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6698 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO24;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6708 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6757 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6761 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO25
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6780 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6800 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO25;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6810 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6859 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6863 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO26
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6882 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6902 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO26;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6912 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6961 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6965 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO27
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6984 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7004 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO27;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7014 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7063 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7067 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO28
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7086 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7106 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO28;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7116 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7165 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7169 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO29
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7188 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7208 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO29;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7218 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7267 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7271 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO30
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7290 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7310 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO30;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7320 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7369 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7373 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO31
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7392 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7412 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO31;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7422 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7471 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7475 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO0
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7494 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7514 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO0;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7524 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7573 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7577 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO1
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7596 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7616 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO1;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7626 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7675 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7679 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO2
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7698 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7718 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO2;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7728 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7777 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7781 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO3
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7800 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7820 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO3;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7830 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7879 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7883 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO4
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7902 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7922 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO4;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7932 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7981 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7985 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO5
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8004 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8024 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO5;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8034 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8083 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8087 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO6
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8106 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8126 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO6;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8136 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8185 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8189 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO7
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8208 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8228 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO7;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8238 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8287 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8291 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO8
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8310 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8330 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO8;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8340 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8389 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8393 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO9
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8412 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8432 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO9;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8442 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8491 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8495 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO10
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8514 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8534 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO10;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8544 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8593 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8597 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO11
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8616 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8636 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO11;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8646 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8695 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8699 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO12
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8718 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8738 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO12;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8748 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8797 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8801 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO13
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8820 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8840 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO13;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8850 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8899 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8903 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO14
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8922 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8942 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO14;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8952 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9001 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9005 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO15
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9024 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9044 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO15;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9054 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9103 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9107 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO16
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9126 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9146 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO16;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9156 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9205 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9209 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO17
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9228 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9248 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO17;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9258 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9307 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9311 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO18
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9330 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9350 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO18;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9360 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9409 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9413 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO19
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9432 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9452 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO19;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9462 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9511 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9515 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO20
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9534 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9554 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO20;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9564 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9613 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9617 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO21
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9636 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9656 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO21;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9666 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9715 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9719 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO22
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9738 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9758 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO22;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9768 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9817 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9821 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO23
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9840 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9860 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO23;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9870 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9919 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9923 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO24
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9942 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9962 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO24;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9972 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10021 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10025 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO25
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10044 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10064 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO25;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10074 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10123 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10127 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO26
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10146 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10166 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO26;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10176 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10225 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10229 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO27
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10248 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10268 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO27;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10278 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10327 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10331 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO28
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10350 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10370 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO28;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10380 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10429 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10433 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO29
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10452 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10472 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO29;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10482 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10531 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10535 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO30
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10554 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10574 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO30;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10584 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10633 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10637 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO31
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10656 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10676 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO31;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10686 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10735 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10739 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO0
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10758 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 10778 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO0;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10788 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10837 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10841 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO1
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10860 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 10880 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO1;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10890 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10939 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10943 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO2
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10962 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 10982 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO2;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10992 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11041 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11045 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO3
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11064 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11084 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO3;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11094 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11143 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11147 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO4
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11166 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11186 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO4;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11196 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11245 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11249 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO5
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11268 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11288 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO5;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11298 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11347 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11351 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO6
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11370 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11390 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO6;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11400 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11449 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11453 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO7
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11472 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11492 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO7;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11502 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11551 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11555 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO8
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11574 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11594 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO8;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11604 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11653 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11657 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO9
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11676 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11696 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO9;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11706 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11755 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11759 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO10
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11778 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11798 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO10;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11808 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11857 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11861 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO11
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11880 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11900 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO11;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11910 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11959 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11963 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO12
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11982 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12002 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO12;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12012 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12061 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12065 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO13
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12084 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12104 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO13;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12114 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12163 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12167 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO14
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12186 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12206 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO14;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12216 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12265 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12269 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO15
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12288 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12308 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO15;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12318 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12367 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12371 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO16
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12390 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12410 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO16;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12420 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12469 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12473 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO17
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12492 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12512 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO17;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12522 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12571 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12575 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO18
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12594 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12614 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO18;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12624 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12673 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12677 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO19
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12696 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12716 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO19;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12726 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12775 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12779 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO20
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12798 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12818 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO20;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12828 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12877 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12881 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO21
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12900 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12920 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO21;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12930 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12979 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12983 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO22
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13002 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13022 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO22;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13032 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13081 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13085 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO23
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13104 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13124 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO23;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13134 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13183 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13187 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO24
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13206 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13226 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO24;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13236 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13285 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13289 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO25
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13308 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13328 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO25;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13338 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13387 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13391 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO26
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13410 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13430 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO26;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13440 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13489 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13493 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO27
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13512 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13532 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO27;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13542 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13591 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13595 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO28
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13614 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13634 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO28;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13644 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13693 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13697 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO29
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13716 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13736 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO29;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13746 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13795 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13799 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO30
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13818 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13838 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO30;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13848 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13897 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13901 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO31
#line 1518 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13920 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13940 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO31;

    /* semantic routine */
#line 1518 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13950 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13999 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 14003 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_System_Call(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_System_Call
#undef MY_PREFIX
#define MY_PREFIX System_Call
#line 1630 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode System Call\n"));
#line 14022 "icache.c"

  /* validate: 0.17,6./,11./,16./,30.1,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x44000002)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.17,6./,11./,16./,30.1,31./ #define get-values-from-icache|put-values-in-icache */
#line 14031 "icache.c"

#define insn cache_entry->crack.SC.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_System_Call;

    /* semantic routine */
#line 1630 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics System Call\n"));
#line 14041 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_System_Call, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1630 "../../../sim/ppc/powerpc.igen"
    {
      if (CURRENT_MODEL_ISSUE > 0)
        model_serialize(MY_INDEX, cpu_model(processor));
      system_call_interrupt(processor, cia);
    }
#line 14056 "icache.c"
    return nia;
    /* extraction: 0.17,6./,11./,16./,30.1,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14059 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA0_LK0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK0
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14078 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 14093 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA0_LK0;

    /* semantic routine */
#line 1505 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14103 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14122 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14125 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA0_LK1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK1
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14144 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 14159 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA0_LK1;

    /* semantic routine */
#line 1505 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14169 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14188 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14191 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA1_LK0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK0
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14210 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 14225 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA1_LK0;

    /* semantic routine */
#line 1505 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14235 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14254 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14257 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA1_LK1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK1
#line 1505 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14276 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1505 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 14291 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA1_LK1;

    /* semantic routine */
#line 1505 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14301 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14320 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14323 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_Condition_Register_Field(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_Condition_Register_Field
#undef MY_PREFIX
#define MY_PREFIX Move_Condition_Register_Field
#line 1709 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move Condition Register Field\n"));
#line 14342 "icache.c"

  /* validate: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc63ffff) != 0x4c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.XL.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 1709 "../../../sim/ppc/powerpc.igen"
    unsigned const BFA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BFA = EXTRACTED32(instruction, 11, 13); /* default in icache - extraction */
#line 14357 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_Condition_Register_Field;

    /* semantic routine */
#line 1709 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move Condition Register Field\n"));
#line 14367 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_Condition_Register_Field, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1709 "../../../sim/ppc/powerpc.igen"
    {
      MBLIT32(CR, 4*BF, 4*BF+3, EXTRACTED32(CR, 4*BFA, 4*BFA+3));
      PPC_INSN_CR(BF_BITMASK, 1 << BFA);
    }
#line 14381 "icache.c"
    return nia;
    /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14384 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Link_Register_LK0(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK0
#line 1561 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Link Register\n"));
#line 14403 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.16,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000020)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1561 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1561 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 14419 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Link_Register_LK0;

    /* semantic routine */
#line 1561 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 14429 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1561 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (ctr_ok && cond_ok) {
        NIA = IEA(LR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 14470 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 14474 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Link_Register_LK1(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK1
#line 1561 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Link Register\n"));
#line 14493 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.16,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000020)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1561 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1561 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 14509 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Link_Register_LK1;

    /* semantic routine */
#line 1561 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 14519 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1561 "../../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (ctr_ok && cond_ok) {
        NIA = IEA(LR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 14560 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 14564 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_NOR(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NOR
#line 1674 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register NOR\n"));
#line 14583 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.33,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000042)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14606 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_NOR;

    /* semantic routine */
#line 1674 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register NOR\n"));
#line 14616 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_NOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1674 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, !(CR_BA_ || CR_BB_));
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14630 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14635 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Return_From_Interrupt(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Return_From_Interrupt
#undef MY_PREFIX
#define MY_PREFIX Return_From_Interrupt
#line 4861 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Return From Interrupt\n"));
#line 14654 "icache.c"

  /* validate: 0.19,6./,11./,16./,21.50,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x4c000064)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6./,11./,16./,21.50,31./ #define get-values-from-icache|put-values-in-icache */
#line 14663 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Return_From_Interrupt;

    /* semantic routine */
#line 4861 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Return From Interrupt\n"));
#line 14673 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Return_From_Interrupt, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4861 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor)) {
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      }
      else {
        MSR = (MASKED(SRR1, 0, 32)
               | MASKED(SRR1, 37, 41)
               | MASKED(SRR1, 48, 63));
        NIA = MASKED(SRR0, 0, 61);
        cpu_synchronize_context(processor, cia);
        check_masked_interrupts(processor);
      }
    }
#line 14697 "icache.c"
    return nia;
    /* extraction: 0.19,6./,11./,16./,21.50,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14700 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_AND_with_Complement(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND_with_Complement
#line 1690 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register AND with Complement\n"));
#line 14719 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.129,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000102)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14742 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_AND_with_Complement;

    /* semantic routine */
#line 1690 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register AND with Complement\n"));
#line 14752 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_AND_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1690 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ && !CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14766 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14771 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Instruction_Synchronize(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Instruction_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Instruction_Synchronize
#line 4774 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Instruction Synchronize\n"));
#line 14790 "icache.c"

  /* validate: 0.19,6./,11./,16./,21.150,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x4c00012c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6./,11./,16./,21.150,31./ #define get-values-from-icache|put-values-in-icache */
#line 14799 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Instruction_Synchronize;

    /* semantic routine */
#line 4774 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Instruction Synchronize\n"));
#line 14809 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Instruction_Synchronize, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4774 "../../../sim/ppc/powerpc.igen"
    {
      cpu_synchronize_context(processor, cia);
      PPC_INSN_INT(0, 0, 0);
    }
#line 14823 "icache.c"
    return nia;
    /* extraction: 0.19,6./,11./,16./,21.150,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14826 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_XOR(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_XOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_XOR
#line 1658 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register XOR\n"));
#line 14845 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.193,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000182)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14868 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_XOR;

    /* semantic routine */
#line 1658 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register XOR\n"));
#line 14878 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_XOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1658 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ != CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14892 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14897 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_NAND(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NAND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NAND
#line 1666 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register NAND\n"));
#line 14916 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.225,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c0001c2)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14939 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_NAND;

    /* semantic routine */
#line 1666 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register NAND\n"));
#line 14949 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_NAND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1666 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, !(CR_BA_ && CR_BB_));
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14963 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14968 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_AND(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND
#line 1642 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register AND\n"));
#line 14987 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.257,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000202)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15010 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_AND;

    /* semantic routine */
#line 1642 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register AND\n"));
#line 15020 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_AND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1642 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ && CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15034 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15039 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_Equivalent(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_Equivalent
#line 1682 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register Equivalent\n"));
#line 15058 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.289,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000242)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15081 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_Equivalent;

    /* semantic routine */
#line 1682 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register Equivalent\n"));
#line 15091 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_Equivalent, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1682 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ == CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15105 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15110 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_OR_with_Complement(cpu *processor,
                                             instruction_word instruction,
                                             unsigned_word cia,
                                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR_with_Complement
#line 1698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register OR with Complement\n"));
#line 15129 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.417,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000342)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15152 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_OR_with_Complement;

    /* semantic routine */
#line 1698 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register OR with Complement\n"));
#line 15162 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_OR_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1698 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ || !CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15176 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15181 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_OR(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR
#line 1650 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register OR\n"));
#line 15200 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.449,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000382)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15223 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_OR;

    /* semantic routine */
#line 1650 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register OR\n"));
#line 15233 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_OR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1650 "../../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ || CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15247 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15252 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Count_Register_LK0(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK0
#line 1596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Count Register\n"));
#line 15271 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.528,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000420)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1596 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1596 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15287 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Count_Register_LK0;

    /* semantic routine */
#line 1596 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 15297 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1596 "../../../sim/ppc/powerpc.igen"
    {
      int cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (cond_ok) {
        NIA = IEA(CTR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 15334 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 15338 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Count_Register_LK1(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK1
#line 1596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Count Register\n"));
#line 15357 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.528,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000420)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1596 "../../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1596 "../../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15373 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Count_Register_LK1;

    /* semantic routine */
#line 1596 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 15383 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1596 "../../../sim/ppc/powerpc.igen"
    {
      int cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (cond_ok) {
        NIA = IEA(CTR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 15420 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 15424 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0(cpu *processor,
                                                       instruction_word instruction,
                                                       unsigned_word cia,
                                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0
#line 3231 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then Mask Insert\n"));
#line 15443 "icache.c"

  /* validate: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x50000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15473 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0;

    /* semantic routine */
#line 3231 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 15483 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3231 "../../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = (r & m) | (*rA & ~m);
      *rA = result;
      ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                         n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
      		   (unsigned long)result));
      CR0_COMPARE(result, 0, Rc);
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15505 "icache.c"
    return nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15509 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1(cpu *processor,
                                                       instruction_word instruction,
                                                       unsigned_word cia,
                                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1
#line 3231 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then Mask Insert\n"));
#line 15528 "icache.c"

  /* validate: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x50000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3231 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15558 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1;

    /* semantic routine */
#line 3231 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 15568 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3231 "../../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = (r & m) | (*rA & ~m);
      *rA = result;
      ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                         n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
      		   (unsigned long)result));
      CR0_COMPARE(result, 0, Rc);
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15590 "icache.c"
    return nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15594 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0(cpu *processor,
                                                         instruction_word instruction,
                                                         unsigned_word cia,
                                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0
#line 3178 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then AND with Mask\n"));
#line 15613 "icache.c"

  /* validate: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x54000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15643 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0;

    /* semantic routine */
#line 3178 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 15653 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3178 "../../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t s = *rS;
      uint32_t r = ROTL32(s, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
      ITRACE(trace_alu,
             ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
              n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
      	(unsigned long)result, (unsigned long)CR));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15677 "icache.c"
    return nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15681 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1(cpu *processor,
                                                         instruction_word instruction,
                                                         unsigned_word cia,
                                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1
#line 3178 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then AND with Mask\n"));
#line 15700 "icache.c"

  /* validate: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x54000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3178 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15730 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1;

    /* semantic routine */
#line 3178 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 15740 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3178 "../../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t s = *rS;
      uint32_t r = ROTL32(s, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
      ITRACE(trace_alu,
             ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
              n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
      	(unsigned long)result, (unsigned long)CR));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15764 "icache.c"
    return nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15768 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_then_AND_with_Mask_Rc0(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc0
#line 3210 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word then AND with Mask\n"));
#line 15787 "icache.c"

  /* validate: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x5c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.M.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.M.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3210 "../../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3210 "../../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3210 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15821 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_then_AND_with_Mask_Rc0;

    /* semantic routine */
#line 3210 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 15831 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3210 "../../../sim/ppc/powerpc.igen"
    {
      long n = MASKED(*rB, 59, 63);
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
    }
#line 15849 "icache.c"
    return nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15853 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_then_AND_with_Mask_Rc1(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc1
#line 3210 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word then AND with Mask\n"));
#line 15872 "icache.c"

  /* validate: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x5c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.M.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.M.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3210 "../../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3210 "../../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3210 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15906 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_then_AND_with_Mask_Rc1;

    /* semantic routine */
#line 3210 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 15916 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3210 "../../../sim/ppc/powerpc.igen"
    {
      long n = MASKED(*rB, 59, 63);
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
    }
#line 15934 "icache.c"
    return nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15938 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Immediate(cpu *processor,
                    instruction_word instruction,
                    unsigned_word cia,
                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate
#line 2974 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR Immediate\n"));
#line 15957 "icache.c"

  /* validate: 0.24,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x60000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.24,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2974 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 15981 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Immediate;

    /* semantic routine */
#line 2974 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR Immediate\n"));
#line 15991 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2974 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | UI;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16006 "icache.c"
    return nia;
    /* extraction: 0.24,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16010 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Immediate_Shifted(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate_Shifted
#line 2983 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR Immediate Shifted\n"));
#line 16029 "icache.c"

  /* validate: 0.25,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x64000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.25,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2983 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16053 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Immediate_Shifted;

    /* semantic routine */
#line 2983 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR Immediate Shifted\n"));
#line 16063 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2983 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | (UI << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16078 "icache.c"
    return nia;
    /* extraction: 0.25,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16082 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Immediate(cpu *processor,
                     instruction_word instruction,
                     unsigned_word cia,
                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate
#line 2992 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR Immediate\n"));
#line 16101 "icache.c"

  /* validate: 0.26,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x68000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.26,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2992 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16125 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Immediate;

    /* semantic routine */
#line 2992 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR Immediate\n"));
#line 16135 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2992 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ UI;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16150 "icache.c"
    return nia;
    /* extraction: 0.26,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16154 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Immediate_Shifted(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate_Shifted
#line 3001 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR Immediate Shifted\n"));
#line 16173 "icache.c"

  /* validate: 0.27,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x6c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.27,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3001 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16197 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Immediate_Shifted;

    /* semantic routine */
#line 3001 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR Immediate Shifted\n"));
#line 16207 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3001 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ (UI << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16222 "icache.c"
    return nia;
    /* extraction: 0.27,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16226 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Immediate(cpu *processor,
                     instruction_word instruction,
                     unsigned_word cia,
                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate
#line 2954 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND Immediate\n"));
#line 16245 "icache.c"

  /* validate: 0.28,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x70000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.28,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2954 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16269 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Immediate;

    /* semantic routine */
#line 2954 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND Immediate\n"));
#line 16279 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2954 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & UI;
      CR0_COMPARE(*rA, 0, 1/*Rc*/);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
    }
#line 16295 "icache.c"
    return nia;
    /* extraction: 0.28,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16299 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Immediate_Shifted(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate_Shifted
#line 2964 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND Immediate Shifted\n"));
#line 16318 "icache.c"

  /* validate: 0.29,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x74000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.29,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2964 "../../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16342 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Immediate_Shifted;

    /* semantic routine */
#line 2964 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND Immediate Shifted\n"));
#line 16352 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2964 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & (UI << 16);
      CR0_COMPARE(*rA, 0, 1/*Rc*/);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
    }
#line 16368 "icache.c"
    return nia;
    /* extraction: 0.29,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16372 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare
#undef MY_PREFIX
#define MY_PREFIX Compare
#line 2810 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare\n"));
#line 16391 "icache.c"

  /* validate: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc4007ff) != 0x7c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.X.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2810 "../../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.X.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 16419 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare;

    /* semantic routine */
#line 2810 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare\n"));
#line 16429 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2810 "../../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        signed_word a;
        signed_word b;
        if (L == 0) {
          a = EXTENDED(*rA);
          b = EXTENDED(*rB);
        }
        else {
          a = *rA;
          b = *rB;
        }
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
    }
#line 16458 "icache.c"
    return nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16462 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Trap_Word(cpu *processor,
                 instruction_word instruction,
                 unsigned_word cia,
                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word
#undef MY_PREFIX
#define MY_PREFIX Trap_Word
#line 2930 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Trap Word\n"));
#line 16481 "icache.c"

  /* validate: 0.31,6.TO,11.RA,16.RB,21.4,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c000008)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #define get-values-from-icache|put-values-in-icache */
#line 2930 "../../../sim/ppc/powerpc.igen"
    unsigned const TO ATTRIBUTE_UNUSED = cache_entry->crack.X.TO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 16505 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Trap_Word;

    /* semantic routine */
#line 2930 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Trap Word\n"));
#line 16515 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Trap_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2930 "../../../sim/ppc/powerpc.igen"
    {
      signed_word a = EXTENDED(*rA);
      signed_word b = EXTENDED(*rB);
      if (TO == 12 && rA == rB) {
        ITRACE(trace_breakpoint, ("breakpoint\n"));
        cpu_halt(processor, cia, was_trap, 0);
      }
      else if ((a < b && TO_0_)
          || (a > b && TO_1_)
          || (a == b && TO_2_)
          || ((unsigned_word)a < (unsigned_word)b && TO_3_)
          || ((unsigned_word)a > (unsigned_word)b && TO_4_)
          )
        program_interrupt(processor, cia,
                          trap_program_interrupt);
    }
#line 16541 "icache.c"
    return nia;
    /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16545 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE0_Rc0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc0
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 16564 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 16596 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE0_Rc0;

    /* semantic routine */
#line 2596 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 16606 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16625 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16629 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE0_Rc1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc1
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 16648 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 16680 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE0_Rc1;

    /* semantic routine */
#line 2596 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 16690 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16709 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16713 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE0_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc0
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 16732 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 16764 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE0_Rc0;

    /* semantic routine */
#line 2586 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 16774 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16790 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16794 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE0_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc1
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 16813 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 16845 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE0_Rc1;

    /* semantic routine */
#line 2586 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 16855 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16871 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16875 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Unsigned_Rc0(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc0
#line 2730 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word Unsigned\n"));
#line 16894 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000016)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2730 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 16924 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Unsigned_Rc0;

    /* semantic routine */
#line 2730 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 16934 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2730 "../../../sim/ppc/powerpc.igen"
    {
      uint64_t a = (uint32_t)(*rA);
      uint64_t b = (uint32_t)(*rB);
      uint64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16953 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16957 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Unsigned_Rc1(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc1
#line 2730 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word Unsigned\n"));
#line 16976 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000016)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2730 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17006 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Unsigned_Rc1;

    /* semantic routine */
#line 2730 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 17016 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2730 "../../../sim/ppc/powerpc.igen"
    {
      uint64_t a = (uint32_t)(*rA);
      uint64_t b = (uint32_t)(*rB);
      uint64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 17035 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17039 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Condition_Register(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Condition_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Condition_Register
#line 3452 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Condition Register\n"));
#line 17058 "icache.c"

  /* validate: 0.31,6.RT,11./,16./,21.19,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1fffff) != 0x7c000026)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 17073 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Condition_Register;

    /* semantic routine */
#line 3452 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Condition Register\n"));
#line 17083 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Condition_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3452 "../../../sim/ppc/powerpc.igen"
    {
      *rT = (uint32_t)CR;
      PPC_INSN_MFCR(RT_BITMASK);
    }
#line 17097 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #undef get-values-from-icache|put-values-in-icache */
#line 17100 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_And_Reserve_Indexed(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_And_Reserve_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_And_Reserve_Indexed
#line 2422 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word And Reserve Indexed\n"));
#line 17119 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.20,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c000028)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 17147 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_And_Reserve_Indexed;

    /* semantic routine */
#line 2422 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word And Reserve Indexed\n"));
#line 17157 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_And_Reserve_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2422 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      RESERVE = 1;
      RESERVE_ADDR = real_addr(EA, 1/*is-read?*/);
      RESERVE_DATA = MEM(unsigned, EA, 4);
      *rT = RESERVE_DATA;
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 17179 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17183 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_and_Zero_Indexed(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_Indexed
#line 1898 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word and Zero Indexed\n"));
#line 17202 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.23,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00002e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 17230 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_and_Zero_Indexed;

    /* semantic routine */
#line 1898 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word and Zero Indexed\n"));
#line 17240 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_and_Zero_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1898 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(unsigned, EA, 4);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 17259 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17263 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Left_Word_Rc0(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc0
#line 3250 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Left Word\n"));
#line 17282 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000030)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3250 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17312 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Left_Word_Rc0;

    /* semantic routine */
#line 3250 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 17322 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Left_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3250 "../../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source << n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu,
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 17347 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17351 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Left_Word_Rc1(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc1
#line 3250 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Left Word\n"));
#line 17370 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000030)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3250 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17400 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Left_Word_Rc1;

    /* semantic routine */
#line 3250 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 17410 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Left_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3250 "../../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source << n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu,
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 17435 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17439 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Count_Leading_Zeros_Word_Rc0(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc0
#line 3129 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Count Leading Zeros Word\n"));
#line 17458 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16./,21.26,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x7c000034)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3129 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17482 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Count_Leading_Zeros_Word_Rc0;

    /* semantic routine */
#line 3129 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 17492 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3129 "../../../sim/ppc/powerpc.igen"
    {
      int count = 0;
      uint32_t mask = BIT32(0);
      uint32_t source = *rS;
      while (!(source & mask) && mask != 0) {
        mask >>= 1;
        count++;
      }
      *rA = count;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
    }
#line 17514 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17518 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Count_Leading_Zeros_Word_Rc1(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc1
#line 3129 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Count Leading Zeros Word\n"));
#line 17537 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16./,21.26,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x7c000034)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3129 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17561 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Count_Leading_Zeros_Word_Rc1;

    /* semantic routine */
#line 3129 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 17571 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3129 "../../../sim/ppc/powerpc.igen"
    {
      int count = 0;
      uint32_t mask = BIT32(0);
      uint32_t source = *rS;
      while (!(source & mask) && mask != 0) {
        mask >>= 1;
        count++;
      }
      *rA = count;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
    }
#line 17593 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17597 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Rc0(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc0
#line 3010 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND\n"));
#line 17616 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000038)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3010 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17646 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Rc0;

    /* semantic routine */
#line 3010 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND\n"));
#line 17656 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3010 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 17672 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17676 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Rc1(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc1
#line 3010 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND\n"));
#line 17695 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000038)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3010 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17725 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Rc1;

    /* semantic routine */
#line 3010 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND\n"));
#line 17735 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3010 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 17751 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17755 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare_Logical(cpu *processor,
                       instruction_word instruction,
                       unsigned_word cia,
                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical
#line 2852 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare Logical\n"));
#line 17774 "icache.c"

  /* validate: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc4007ff) != 0x7c000040)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.X.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2852 "../../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.X.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 17802 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare_Logical;

    /* semantic routine */
#line 2852 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare Logical\n"));
#line 17812 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare_Logical, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2852 "../../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        unsigned_word a;
        unsigned_word b;
        if (L == 0) {
          a = MASKED(*rA, 32, 63);
          b = MASKED(*rB, 32, 63);
        }
        else {
          a = *rA;
          b = *rB;
        }
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
    }
#line 17841 "icache.c"
    return nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17845 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE0_Rc0(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc0
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 17864 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17896 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE0_Rc0;

    /* semantic routine */
#line 2542 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 17906 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 17924 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17928 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE0_Rc1(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc1
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 17947 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17979 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE0_Rc1;

    /* semantic routine */
#line 2542 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 17989 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 18007 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18011 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Store(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Store
#line 4811 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Store\n"));
#line 18030 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.54,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c00006c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18052 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Store;

    /* semantic routine */
#line 4811 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Store\n"));
#line 18062 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Store, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4811 "../../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Store\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 18076 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18080 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_and_Zero_with_Update_Indexed(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_with_Update_Indexed
#line 1925 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word and Zero with Update Indexed\n"));
#line 18099 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.55,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00006e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18127 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_and_Zero_with_Update_Indexed;

    /* semantic routine */
#line 1925 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word and Zero with Update Indexed\n"));
#line 18137 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_and_Zero_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1925 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(unsigned, EA, 4);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 18157 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18161 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_with_Complement_Rc0(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc0
#line 3070 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND with Complement\n"));
#line 18180 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000078)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3070 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18210 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_with_Complement_Rc0;

    /* semantic routine */
#line 3070 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 18220 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3070 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 18236 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18240 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_with_Complement_Rc1(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc1
#line 3070 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND with Complement\n"));
#line 18259 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000078)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3070 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 18289 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_with_Complement_Rc1;

    /* semantic routine */
#line 3070 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 18299 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3070 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 18315 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18319 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Rc0(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc0
#line 2715 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word\n"));
#line 18338 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000096)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2715 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18368 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Rc0;

    /* semantic routine */
#line 2715 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 18378 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2715 "../../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 18397 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18401 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Rc1(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc1
#line 2715 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word\n"));
#line 18420 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000096)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2715 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 18450 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Rc1;

    /* semantic routine */
#line 2715 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 18460 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2715 "../../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 18479 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18483 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Machine_State_Register(cpu *processor,
                                        instruction_word instruction,
                                        unsigned_word cia,
                                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Machine_State_Register
#line 4898 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Machine State Register\n"));
#line 18502 "icache.c"

  /* validate: 0.31,6.RT,11./,16./,21.83,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1fffff) != 0x7c0000a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 18517 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Machine_State_Register;

    /* semantic routine */
#line 4898 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Machine State Register\n"));
#line 18527 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Machine_State_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4898 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        *rT = MSR;
        check_masked_interrupts(processor);
      }
    }
#line 18546 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #undef get-values-from-icache|put-values-in-icache */
#line 18549 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Flush(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Flush
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Flush
#line 4819 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Flush\n"));
#line 18568 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.86,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c0000ac)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18590 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Flush;

    /* semantic routine */
#line 4819 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Flush\n"));
#line 18600 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Flush, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4819 "../../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Flush\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 18614 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18618 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Byte_and_Zero_Indexed(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_Indexed
#line 1736 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Byte and Zero Indexed\n"));
#line 18637 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.87,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0000ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18665 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Byte_and_Zero_Indexed;

    /* semantic routine */
#line 1736 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Byte and Zero Indexed\n"));
#line 18675 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Byte_and_Zero_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1736 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(unsigned, EA, 1);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 18694 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18698 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Negate_OE0_Rc0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc0
#line 2676 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Negate\n"));
#line 18717 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0000d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2676 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2676 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18743 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Negate_OE0_Rc0;

    /* semantic routine */
#line 2676 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Negate\n"));
#line 18753 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Negate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2676 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(1);
      ALU_END(*rT,0/*CA*/,OE,Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 18770 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18774 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Negate_OE0_Rc1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc1
#line 2676 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Negate\n"));
#line 18793 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0000d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2676 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2676 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 18819 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Negate_OE0_Rc1;

    /* semantic routine */
#line 2676 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Negate\n"));
#line 18829 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Negate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2676 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(1);
      ALU_END(*rT,0/*CA*/,OE,Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 18846 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18850 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Byte_and_Zero_with_Update_Indexed(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_with_Update_Indexed
#line 1763 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Byte and Zero with Update Indexed\n"));
#line 18869 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.119,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0000ee)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18897 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Byte_and_Zero_with_Update_Indexed;

    /* semantic routine */
#line 1763 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Byte and Zero with Update Indexed\n"));
#line 18907 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Byte_and_Zero_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1763 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(unsigned, EA, 1);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 18927 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18931 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NOR_Rc0(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc0
#line 3050 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NOR\n"));
#line 18950 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0000f8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3050 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18980 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NOR_Rc0;

    /* semantic routine */
#line 3050 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NOR\n"));
#line 18990 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3050 "../../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS | *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 19006 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19010 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NOR_Rc1(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc1
#line 3050 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NOR\n"));
#line 19029 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0000f8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3050 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19059 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NOR_Rc1;

    /* semantic routine */
#line 3050 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NOR\n"));
#line 19069 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3050 "../../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS | *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 19085 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19089 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Extended_OE0_Rc0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc0
#line 2620 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Extended\n"));
#line 19108 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000110)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2620 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2620 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 19140 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Extended_OE0_Rc0;

    /* semantic routine */
#line 2620 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 19150 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2620 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19168 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19172 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Extended_OE0_Rc1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc1
#line 2620 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Extended\n"));
#line 19191 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000110)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2620 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2620 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19223 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Extended_OE0_Rc1;

    /* semantic routine */
#line 2620 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 19233 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2620 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19251 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19255 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Extended_OE0_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc0
#line 2609 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Extended\n"));
#line 19274 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000114)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2609 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2609 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 19306 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Extended_OE0_Rc0;

    /* semantic routine */
#line 2609 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 19316 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2609 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19333 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19337 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Extended_OE0_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc1
#line 2609 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Extended\n"));
#line 19356 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000114)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2609 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2609 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19388 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Extended_OE0_Rc1;

    /* semantic routine */
#line 2609 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 19398 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2609 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19415 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19419 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Condition_Register_Fields(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_Fields
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_Fields
#line 3429 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Condition Register Fields\n"));
#line 19438 "icache.c"

  /* validate: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc100fff) != 0x7c000120)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 3429 "../../../sim/ppc/powerpc.igen"
    unsigned const FXM ATTRIBUTE_UNUSED = cache_entry->crack.XFX.FXM = EXTRACTED32(instruction, 12, 19); /* default in icache - extraction */
#line 19455 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Condition_Register_Fields;

    /* semantic routine */
#line 3429 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Condition Register Fields\n"));
#line 19465 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Condition_Register_Fields, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3429 "../../../sim/ppc/powerpc.igen"
    {
      if (FXM == 0xff) {
        CR = *rS;
      }
      else {
        unsigned_word mask = 0;
        unsigned_word f;
        for (f = 0; f < 8; f++) {
          if (FXM & (0x80 >> f))
            mask |= (0xf << 4*(7-f));
        }
        CR = (MASKED(*rS, 32, 63) & mask) | (CR & ~mask);
      }
      PPC_INSN_MTCR(RS_BITMASK, FXM);
    }
#line 19490 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #undef get-values-from-icache|put-values-in-icache */
#line 19493 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_To_Machine_State_Register(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Machine_State_Register
#line 4885 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move To Machine State Register\n"));
#line 19512 "icache.c"

  /* validate: 0.31,6.RS,11./,16./,21.146,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1fffff) != 0x7c000124)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 19527 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_To_Machine_State_Register;

    /* semantic routine */
#line 4885 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move To Machine State Register\n"));
#line 19537 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_To_Machine_State_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4885 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        MSR = *rS;
        check_masked_interrupts(processor);
      }
    }
#line 19556 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #undef get-values-from-icache|put-values-in-icache */
#line 19559 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Word_Conditional_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Conditional_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Conditional_Indexed
#line 2450 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Word Conditional Indexed\n"));
#line 19578 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.150,31.1 */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00012d)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 19606 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Word_Conditional_Indexed;

    /* semantic routine */
#line 2450 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Word Conditional Indexed\n"));
#line 19616 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Word_Conditional_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2450 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      if (RESERVE) {
        if (RESERVE_ADDR == real_addr(EA, 0/*is-read?*/)
            && /*HACK*/ RESERVE_DATA == MEM(unsigned, EA, 4)) {
          STORE(EA, 4, *rS);
          CR_SET_XER_SO(0, cr_i_zero);
        }
        else {
          /* ment to randomly to store, we never do! */	
          CR_SET_XER_SO(0, 0);
        }
        RESERVE = 0;
      }
      else {
        CR_SET_XER_SO(0, 0);
      }
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 1/*Rc*/);
    }
#line 19649 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19653 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Word_Indexed(cpu *processor,
                          instruction_word instruction,
                          unsigned_word cia,
                          idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Indexed
#line 2125 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Word Indexed\n"));
#line 19672 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.151,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00012e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 19700 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Word_Indexed;

    /* semantic routine */
#line 2125 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Word Indexed\n"));
#line 19710 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Word_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2125 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      STORE(EA, 4, *rS);
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
    }
#line 19729 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19733 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Word_with_Update_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_with_Update_Indexed
#line 2152 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Word with Update Indexed\n"));
#line 19752 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.183,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00016e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 19780 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Word_with_Update_Indexed;

    /* semantic routine */
#line 2152 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Word with Update Indexed\n"));
#line 19790 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Word_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2152 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      STORE(EA, 4, *rS);
      *rA = EA;
      PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
    }
#line 19810 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19814 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_from_Zero_Extended_OE0_Rc0(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc0
#line 2665 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract from Zero Extended\n"));
#line 19833 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000190)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2665 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2665 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 19859 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_from_Zero_Extended_OE0_Rc0;

    /* semantic routine */
#line 2665 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 19869 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2665 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 19886 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19890 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_from_Zero_Extended_OE0_Rc1(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc1
#line 2665 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract from Zero Extended\n"));
#line 19909 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000190)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2665 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2665 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19935 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_from_Zero_Extended_OE0_Rc1;

    /* semantic routine */
#line 2665 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 19945 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2665 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 19962 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19966 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Zero_Extended_OE0_Rc0(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc0
#line 2655 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Zero Extended\n"));
#line 19985 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000194)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2655 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2655 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20011 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Zero_Extended_OE0_Rc0;

    /* semantic routine */
#line 2655 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 20021 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2655 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20037 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20041 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Zero_Extended_OE0_Rc1(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc1
#line 2655 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Zero Extended\n"));
#line 20060 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000194)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2655 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2655 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20086 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Zero_Extended_OE0_Rc1;

    /* semantic routine */
#line 2655 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 20096 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2655 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20112 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20116 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_To_Segment_Register(cpu *processor,
                                instruction_word instruction,
                                unsigned_word cia,
                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register
#line 4931 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move To Segment Register\n"));
#line 20135 "icache.c"

  /* validate: 0.31,6.RS,11./,12.SR,16./,21.210,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc10ffff) != 0x7c0001a4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 4931 "../../../sim/ppc/powerpc.igen"
    unsigned const SR ATTRIBUTE_UNUSED = cache_entry->crack.X.SR = EXTRACTED32(instruction, 12, 15); /* default in icache - extraction */
#line 20152 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_To_Segment_Register;

    /* semantic routine */
#line 4931 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move To Segment Register\n"));
#line 20162 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_To_Segment_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4931 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        SEGREG(SR) = *rS;
    }
#line 20179 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #undef get-values-from-icache|put-values-in-icache */
#line 20182 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Byte_Indexed(cpu *processor,
                          instruction_word instruction,
                          unsigned_word cia,
                          idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_Indexed
#line 2017 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Byte Indexed\n"));
#line 20201 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.215,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0001ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20229 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Byte_Indexed;

    /* semantic routine */
#line 2017 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Byte Indexed\n"));
#line 20239 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Byte_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2017 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      STORE(EA, 1, *rS);
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
    }
#line 20258 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20262 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc0
#line 2643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Minus One Extended\n"));
#line 20281 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2643 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2643 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20307 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Minus_One_Extended_OE0_Rc0;

    /* semantic routine */
#line 2643 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 20317 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2643 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20335 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20339 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc1
#line 2643 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Minus One Extended\n"));
#line 20358 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2643 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2643 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20384 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Minus_One_Extended_OE0_Rc1;

    /* semantic routine */
#line 2643 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 20394 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2643 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20412 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20416 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc0
#line 2632 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Minus One Extended\n"));
#line 20435 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2632 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2632 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20461 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Minus_One_Extended_OE0_Rc0;

    /* semantic routine */
#line 2632 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 20471 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2632 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20488 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20492 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc1
#line 2632 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Minus One Extended\n"));
#line 20511 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2632 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2632 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20537 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Minus_One_Extended_OE0_Rc1;

    /* semantic routine */
#line 2632 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 20547 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2632 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20564 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20568 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_Low_Word_OE0_Rc0(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc0
#line 2698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply Low Word\n"));
#line 20587 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0001d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2698 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2698 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20619 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_Low_Word_OE0_Rc0;

    /* semantic routine */
#line 2698 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 20629 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_Low_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2698 "../../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = prod;
      *rT = *rA * *rB;
      if (t != prod && OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 20650 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20654 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_Low_Word_OE0_Rc1(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc1
#line 2698 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply Low Word\n"));
#line 20673 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0001d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2698 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2698 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20705 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_Low_Word_OE0_Rc1;

    /* semantic routine */
#line 2698 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 20715 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_Low_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2698 "../../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = prod;
      *rT = *rA * *rB;
      if (t != prod && OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 20736 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20740 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_To_Segment_Register_Indirect(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register_Indirect
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register_Indirect
#line 4942 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move To Segment Register Indirect\n"));
#line 20759 "icache.c"

  /* validate: 0.31,6.RS,11./,16.RB,21.242,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1f07ff) != 0x7c0001e4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20780 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_To_Segment_Register_Indirect;

    /* semantic routine */
#line 4942 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move To Segment Register Indirect\n"));
#line 20790 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_To_Segment_Register_Indirect, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4942 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        SEGREG(EXTRACTED32(*rB, 0, 3)) = *rS;
    }
#line 20807 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #undef get-values-from-icache|put-values-in-icache */
#line 20810 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Touch_for_Store(cpu *processor,
                                        instruction_word instruction,
                                        unsigned_word cia,
                                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch_for_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch_for_Store
#line 4795 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Touch for Store\n"));
#line 20829 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.246,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c0001ec)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20851 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Touch_for_Store;

    /* semantic routine */
#line 4795 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Touch for Store\n"));
#line 20861 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Touch_for_Store, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4795 "../../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Touch for Store\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 20875 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20879 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Byte_with_Update_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_with_Update_Indexed
#line 2044 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Byte with Update Indexed\n"));
#line 20898 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.247,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0001ee)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20926 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Byte_with_Update_Indexed;

    /* semantic routine */
#line 2044 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Byte with Update Indexed\n"));
#line 20936 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Byte_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2044 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      STORE(EA, 1, *rS);
      *rA = EA;
      PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
    }
#line 20956 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20960 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_OE0_Rc0(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc0
#line 2532 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add\n"));
#line 20979 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000214)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2532 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2532 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 21011 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_OE0_Rc0;

    /* semantic routine */
#line 2532 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add\n"));
#line 21021 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2532 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 21037 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21041 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_OE0_Rc1(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc1
#line 2532 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add\n"));
#line 21060 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000214)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2532 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2532 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 21092 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_OE0_Rc1;

    /* semantic routine */
#line 2532 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add\n"));
#line 21102 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2532 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 21118 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21122 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Touch(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch
#line 4787 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Touch\n"));
#line 21141 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.278,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c00022c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21163 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Touch;

    /* semantic routine */
#line 4787 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Touch\n"));
#line 21173 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Touch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4787 "../../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Touch\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 21187 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21191 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_and_Zero_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_Indexed
#line 1790 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword and Zero Indexed\n"));
#line 21210 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.279,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00022e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21238 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_and_Zero_Indexed;

    /* semantic routine */
#line 1790 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword and Zero Indexed\n"));
#line 21248 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_and_Zero_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1790 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(unsigned, EA, 2);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 21267 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21271 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Equivalent_Rc0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc0
#line 3060 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Equivalent\n"));
#line 21290 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000238)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3060 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 21320 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Equivalent_Rc0;

    /* semantic routine */
#line 3060 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 21330 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Equivalent, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3060 "../../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS ^ *rB); /* A === B */
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21346 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21350 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Equivalent_Rc1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc1
#line 3060 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Equivalent\n"));
#line 21369 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000238)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3060 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 21399 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Equivalent_Rc1;

    /* semantic routine */
#line 3060 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 21409 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Equivalent, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3060 "../../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS ^ *rB); /* A === B */
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21425 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21429 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_TLB_Invalidate_Entry(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_Entry
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_Entry
#line 4980 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode TLB Invalidate Entry\n"));
#line 21448 "icache.c"

  /* validate: 0.31,6./,11./,16.RB,21.306,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffff07ff) != 0x7c000264)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #define get-values-from-icache|put-values-in-icache */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21463 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_TLB_Invalidate_Entry;

    /* semantic routine */
#line 4980 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics TLB Invalidate Entry\n"));
#line 21473 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_TLB_Invalidate_Entry, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4980 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        int nr = 0;
        cpu *proc;
        while (1) {
          proc = psim_cpu(cpu_system(processor), nr);
          if (proc == NULL) break;
          cpu_page_tlb_invalidate_entry(proc, *rB);
          nr++;
        }
      }
    }
#line 21498 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #undef get-values-from-icache|put-values-in-icache */
#line 21501 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_and_Zero_with_Update_Indexed(cpu *processor,
                                                  instruction_word instruction,
                                                  unsigned_word cia,
                                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_with_Update_Indexed
#line 1817 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword and Zero with Update Indexed\n"));
#line 21520 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.311,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00026e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21548 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_and_Zero_with_Update_Indexed;

    /* semantic routine */
#line 1817 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword and Zero with Update Indexed\n"));
#line 21558 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_and_Zero_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1817 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(unsigned, EA, 2);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 21578 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21582 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Rc0(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc0
#line 3030 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR\n"));
#line 21601 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000278)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3030 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 21631 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Rc0;

    /* semantic routine */
#line 3030 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR\n"));
#line 21641 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3030 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21657 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21661 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Rc1(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc1
#line 3030 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR\n"));
#line 21680 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000278)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3030 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 21710 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Rc1;

    /* semantic routine */
#line 3030 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR\n"));
#line 21720 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3030 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21736 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21740 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_from_Special_Purpose_Register_SPR256(cpu *processor,
                                                 instruction_word instruction,
                                                 unsigned_word cia,
                                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR256
#line 3388 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move from Special Purpose Register\n"));
#line 21759 "icache.c"

  /* validate: 0.31,6.RT,11.SPR,21.339,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 3388 "../../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = 256; /* default in icache - constant field */
#line 21776 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_from_Special_Purpose_Register_SPR256;

    /* semantic routine */
#line 3388 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 21786 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3388 "../../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        /* HACK - time base registers need to be calculated */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_dec:
            *rT = cpu_get_decrementer(processor);
            break;
      	case spr_tbrl:
        	  if (is_64bit_implementation) *rT = TB;
        	  else                         *rT = EXTRACTED64(TB, 32, 63);
      	break;
      	case spr_tbru:
        	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
      	  else                         *rT = EXTRACTED64(TB, 0, 31);
      	break;
          case spr_tbu:
          case spr_tbl:
            /* NOTE - these SPR's are not readable. Use mftb[ul] */
          default:
            *rT = SPREG(n);
            break;
          }
        }
        else {
          *rT = SPREG(n);
        }
      }
      PPC_INSN_FROM_SPR(RT_BITMASK, n);
    }
#line 21833 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache|put-values-in-icache */
#line 21836 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_from_Special_Purpose_Register_SPR(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR
#line 3388 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move from Special Purpose Register\n"));
#line 21855 "icache.c"

  /* validate: 0.31,6.RT,11.SPR,21.339,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 3388 "../../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = cache_entry->crack.XFX.SPR = EXTRACTED32(instruction, 11, 20); /* default in icache - extraction */
#line 21872 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_from_Special_Purpose_Register_SPR;

    /* semantic routine */
#line 3388 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 21882 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3388 "../../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        /* HACK - time base registers need to be calculated */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_dec:
            *rT = cpu_get_decrementer(processor);
            break;
      	case spr_tbrl:
        	  if (is_64bit_implementation) *rT = TB;
        	  else                         *rT = EXTRACTED64(TB, 32, 63);
      	break;
      	case spr_tbru:
        	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
      	  else                         *rT = EXTRACTED64(TB, 0, 31);
      	break;
          case spr_tbu:
          case spr_tbl:
            /* NOTE - these SPR's are not readable. Use mftb[ul] */
          default:
            *rT = SPREG(n);
            break;
          }
        }
        else {
          *rT = SPREG(n);
        }
      }
      PPC_INSN_FROM_SPR(RT_BITMASK, n);
    }
#line 21929 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache|put-values-in-icache */
#line 21932 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_Algebraic_Indexed(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_Indexed
#line 1844 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword Algebraic Indexed\n"));
#line 21951 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.343,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21979 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_Algebraic_Indexed;

    /* semantic routine */
#line 1844 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword Algebraic Indexed\n"));
#line 21989 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_Algebraic_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1844 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(signed, EA, 2);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 22008 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22012 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_TLB_Invalidate_All(cpu *processor,
                          instruction_word instruction,
                          unsigned_word cia,
                          idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_All
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_All
#line 4995 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode TLB Invalidate All\n"));
#line 22031 "icache.c"

  /* validate: 0.31,6./,11./,16./,21.370,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x7c0002e4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11./,16./,21.370,31./ #define get-values-from-icache|put-values-in-icache */
#line 22040 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_TLB_Invalidate_All;

    /* semantic routine */
#line 4995 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics TLB Invalidate All\n"));
#line 22050 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_TLB_Invalidate_All, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4995 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        int nr = 0;
        cpu *proc;
        while (1) {
          proc = psim_cpu(cpu_system(processor), nr);
          if (proc == NULL) break;
          cpu_page_tlb_invalidate_all(proc);
          nr++;
        }
      }
    }
#line 22075 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11./,16./,21.370,31./ #undef get-values-from-icache|put-values-in-icache */
#line 22078 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Time_Base(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Time_Base
#undef MY_PREFIX
#define MY_PREFIX Move_From_Time_Base
#line 4838 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Time Base\n"));
#line 22097 "icache.c"

  /* validate: 0.31,6.RT,11.tbr,21.371,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002e6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 4838 "../../../sim/ppc/powerpc.igen"
    unsigned const tbr ATTRIBUTE_UNUSED = cache_entry->crack.XFX.tbr = EXTRACTED32(instruction, 11, 20); /* default in icache - extraction */
#line 22114 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Time_Base;

    /* semantic routine */
#line 4838 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Time Base\n"));
#line 22124 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Time_Base, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4838 "../../../sim/ppc/powerpc.igen"
    {
      int n = (tbr_5_9_ << 5) | tbr_0_4_;
      if (n == 268) {
        if (is_64bit_implementation) *rT = TB;
        else                         *rT = EXTRACTED64(TB, 32, 63);
      }
      else if (n == 269) {
        if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
        else                         *rT = EXTRACTED64(TB, 0, 31);
      }
      else
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
    }
#line 22148 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #undef get-values-from-icache|put-values-in-icache */
#line 22151 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_Algebraic_with_Update_Indexed(cpu *processor,
                                                   instruction_word instruction,
                                                   unsigned_word cia,
                                                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_with_Update_Indexed
#line 1871 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword Algebraic with Update Indexed\n"));
#line 22170 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.375,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002ee)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 22198 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_Algebraic_with_Update_Indexed;

    /* semantic routine */
#line 1871 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword Algebraic with Update Indexed\n"));
#line 22208 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_Algebraic_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1871 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(signed, EA, 2);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 22228 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22232 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Half_Word_Indexed(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_Indexed
#line 2071 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Half Word Indexed\n"));
#line 22251 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.407,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00032e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 22279 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Half_Word_Indexed;

    /* semantic routine */
#line 2071 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Half Word Indexed\n"));
#line 22289 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Half_Word_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2071 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      STORE(EA, 2, *rS);
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
    }
#line 22308 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22312 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_with_Complement_Rc0(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc0
#line 3080 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR with Complement\n"));
#line 22331 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000338)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3080 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 22361 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_with_Complement_Rc0;

    /* semantic routine */
#line 3080 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 22371 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3080 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22387 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22391 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_with_Complement_Rc1(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc1
#line 3080 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR with Complement\n"));
#line 22410 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000338)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3080 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 22440 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_with_Complement_Rc1;

    /* semantic routine */
#line 3080 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 22450 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3080 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22466 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22470 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Half_Word_with_Update_Indexed(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_with_Update_Indexed
#line 2098 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Half Word with Update Indexed\n"));
#line 22489 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.439,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00036e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 22517 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Half_Word_with_Update_Indexed;

    /* semantic routine */
#line 2098 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Half Word with Update Indexed\n"));
#line 22527 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Half_Word_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2098 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      STORE(EA, 2, *rS);
      *rA = EA;
      PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
    }
#line 22547 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22551 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Rc0(cpu *processor,
              instruction_word instruction,
              unsigned_word cia,
              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc0
#line 3020 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR\n"));
#line 22570 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000378)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3020 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 22600 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Rc0;

    /* semantic routine */
#line 3020 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR\n"));
#line 22610 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3020 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22626 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22630 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Rc1(cpu *processor,
              instruction_word instruction,
              unsigned_word cia,
              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc1
#line 3020 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR\n"));
#line 22649 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000378)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3020 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 22679 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Rc1;

    /* semantic routine */
#line 3020 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR\n"));
#line 22689 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3020 "../../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22705 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22709 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_Unsigned_OE0_Rc0(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc0
#line 2767 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word Unsigned\n"));
#line 22728 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000396)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2767 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2767 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 22760 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_Unsigned_OE0_Rc0;

    /* semantic routine */
#line 2767 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22770 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2767 "../../../sim/ppc/powerpc.igen"
    {
      uint64_t dividend = (uint32_t)(*rA);
      uint64_t divisor = (uint32_t)(*rB);
      if (divisor == 0) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        uint64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 22795 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22799 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_Unsigned_OE0_Rc1(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc1
#line 2767 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word Unsigned\n"));
#line 22818 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000396)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2767 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2767 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 22850 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_Unsigned_OE0_Rc1;

    /* semantic routine */
#line 2767 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22860 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2767 "../../../sim/ppc/powerpc.igen"
    {
      uint64_t dividend = (uint32_t)(*rA);
      uint64_t divisor = (uint32_t)(*rB);
      if (divisor == 0) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        uint64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 22885 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22889 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Special_Purpose_Register_SPR256(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR256
#line 3344 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Special Purpose Register\n"));
#line 22908 "icache.c"

  /* validate: 0.31,6.RS,11.SPR,21.467,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0003a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 3344 "../../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = 256; /* default in icache - constant field */
#line 22925 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Special_Purpose_Register_SPR256;

    /* semantic routine */
#line 3344 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 22935 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3344 "../../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n)
               || spr_is_readonly(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        spreg new_val = (spr_length(n) == 64
      		   ? *rS
      		   : MASKED(*rS, 32, 63));
        /* HACK - time base registers need to be updated immediately */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_tbu:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 32, 63)
                               | INSERTED64(new_val, 0, 31)));
            break;
          case spr_tbl:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 0, 31)
                               | INSERTED64(new_val, 32, 63)));
            break;
          case spr_dec:
            cpu_set_decrementer(processor, new_val);
            break;
          default:
            SPREG(n) = new_val;
            break;
          }
        }
        else {
          SPREG(n) = new_val;
        }
      }
      PPC_INSN_TO_SPR(RS_BITMASK, n);
    }
#line 22985 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache|put-values-in-icache */
#line 22988 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Special_Purpose_Register_SPR(cpu *processor,
                                            instruction_word instruction,
                                            unsigned_word cia,
                                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR
#line 3344 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Special Purpose Register\n"));
#line 23007 "icache.c"

  /* validate: 0.31,6.RS,11.SPR,21.467,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0003a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 3344 "../../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = cache_entry->crack.XFX.SPR = EXTRACTED32(instruction, 11, 20); /* default in icache - extraction */
#line 23024 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Special_Purpose_Register_SPR;

    /* semantic routine */
#line 3344 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 23034 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3344 "../../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n)
               || spr_is_readonly(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        spreg new_val = (spr_length(n) == 64
      		   ? *rS
      		   : MASKED(*rS, 32, 63));
        /* HACK - time base registers need to be updated immediately */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_tbu:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 32, 63)
                               | INSERTED64(new_val, 0, 31)));
            break;
          case spr_tbl:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 0, 31)
                               | INSERTED64(new_val, 32, 63)));
            break;
          case spr_dec:
            cpu_set_decrementer(processor, new_val);
            break;
          default:
            SPREG(n) = new_val;
            break;
          }
        }
        else {
          SPREG(n) = new_val;
        }
      }
      PPC_INSN_TO_SPR(RS_BITMASK, n);
    }
#line 23084 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache|put-values-in-icache */
#line 23087 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Invalidate(cpu *processor,
                                   instruction_word instruction,
                                   unsigned_word cia,
                                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Invalidate
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Invalidate
#line 4916 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Invalidate\n"));
#line 23106 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.470,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c0003ac)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 23128 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Invalidate;

    /* semantic routine */
#line 4916 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Invalidate\n"));
#line 23138 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Invalidate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4916 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        TRACE(trace_tbd,("Data Cache Block Invalidate\n"));
    }
#line 23155 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23159 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NAND_Rc0(cpu *processor,
                instruction_word instruction,
                unsigned_word cia,
                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc0
#line 3040 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NAND\n"));
#line 23178 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0003b8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3040 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23208 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NAND_Rc0;

    /* semantic routine */
#line 3040 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NAND\n"));
#line 23218 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NAND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3040 "../../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS & *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 23234 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23238 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NAND_Rc1(cpu *processor,
                instruction_word instruction,
                unsigned_word cia,
                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc1
#line 3040 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NAND\n"));
#line 23257 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0003b8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3040 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23287 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NAND_Rc1;

    /* semantic routine */
#line 3040 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NAND\n"));
#line 23297 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NAND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3040 "../../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS & *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 23313 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23317 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_OE0_Rc0(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc0
#line 2745 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word\n"));
#line 23336 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0003d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2745 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2745 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23368 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_OE0_Rc0;

    /* semantic routine */
#line 2745 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23378 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2745 "../../../sim/ppc/powerpc.igen"
    {
      int64_t dividend = (int32_t)(*rA);
      int64_t divisor = (int32_t)(*rB);
      if (divisor == 0 /* nb 0x8000..0 is sign extended */
          || (dividend == 0x80000000 && divisor == -1)) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        int64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23404 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23408 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_OE0_Rc1(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc1
#line 2745 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word\n"));
#line 23427 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0003d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2745 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2745 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23459 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_OE0_Rc1;

    /* semantic routine */
#line 2745 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23469 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2745 "../../../sim/ppc/powerpc.igen"
    {
      int64_t dividend = (int32_t)(*rA);
      int64_t divisor = (int32_t)(*rB);
      if (divisor == 0 /* nb 0x8000..0 is sign extended */
          || (dividend == 0x80000000 && divisor == -1)) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        int64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23495 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23499 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Condition_Register_from_XER(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_from_XER
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_from_XER
#line 3444 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Condition Register from XER\n"));
#line 23518 "icache.c"

  /* validate: 0.31,6.BF,9./,11./,16./,21.512,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc7fffff) != 0x7c000400)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.X.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 23531 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Condition_Register_from_XER;

    /* semantic routine */
#line 3444 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Condition Register from XER\n"));
#line 23541 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Condition_Register_from_XER, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3444 "../../../sim/ppc/powerpc.igen"
    error("%s:%d:0x%08lx:%s unimplemented\n",
          itable[MY_INDEX].file, itable[MY_INDEX].line_nr, (long)cia, itable[MY_INDEX].name);
#line 23553 "icache.c"
    return nia;
    /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #undef get-values-from-icache|put-values-in-icache */
#line 23556 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE1_Rc0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc0
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 23575 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23607 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE1_Rc0;

    /* semantic routine */
#line 2596 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 23617 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23636 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23640 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE1_Rc1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc1
#line 2596 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 23659 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2596 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23691 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE1_Rc1;

    /* semantic routine */
#line 2596 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 23701 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23720 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23724 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE1_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc0
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 23743 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23775 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE1_Rc0;

    /* semantic routine */
#line 2586 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 23785 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23801 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23805 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE1_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc1
#line 2586 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 23824 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2586 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23856 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE1_Rc1;

    /* semantic routine */
#line 2586 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 23866 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23882 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23886 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_String_Word_Indexed(cpu *processor,
                                instruction_word instruction,
                                unsigned_word cia,
                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Indexed
#line 2328 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load String Word Indexed\n"));
#line 23905 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.533,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00042a)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 23933 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_String_Word_Indexed;

    /* semantic routine */
#line 2328 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load String Word Indexed\n"));
#line 23943 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_String_Word_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2328 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      unsigned_word b;
      int n;
      int r;
      int i;
      int nr;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      n = EXTRACTED32(XER, 25, 31);
      r = RT - 1;
      i = 32;
      nr = (n + 3) / 4;
      if (((RT + nr >= 32)
           ? ((RA >= RT || RA < (RT + nr) % 32)
              || (RB >= RT || RB < (RT + nr) % 32))
           : ((RA >= RT && RA < RT + nr)
              || (RB >= RT && RB < RT + nr)))
          || (RT == RA || RT == RB))
        program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
      if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
        alignment_interrupt(processor, cia, EA);
      while (n > 0) {
        if (i == 32) {
          r = (r + 1) % 32;
          GPR(r) = 0;
        }
        GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
        i = i + 8;
        if (i == 64) i = 32;
        EA = EA + 1;
        n = n - 1;
      }
    }
#line 23989 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23993 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_ByteReverse_Indexed(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_ByteReverse_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_ByteReverse_Indexed
#line 2215 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word Byte-Reverse Indexed\n"));
#line 24012 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.534,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00042c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24040 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_ByteReverse_Indexed;

    /* semantic routine */
#line 2215 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word Byte-Reverse Indexed\n"));
#line 24050 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_ByteReverse_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2215 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = SWAP_4(MEM(unsigned, EA, 4));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24069 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24073 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_FloatingPoint_Single_Indexed(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_Indexed
#line 3477 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Floating-Point Single Indexed\n"));
#line 24092 "icache.c"

  /* validate: 0.31,6.FRT,11.RA,16.RB,21.535,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00042e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP hardware exists */
  if (CURRENT_FLOATING_POINT != HARD_FLOATING_POINT)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP available according to MSR[FP] */
  if (!IS_FP_AVAILABLE(processor))
    return icache_floating_point_unavailable(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #define get-values-from-icache|put-values-in-icache */
#define FRT EXTRACTED32(instruction, 6, 10) /* icache scratch - extraction */
#line 62 "../../../sim/ppc/powerpc.igen"
    uint64_t * const frT ATTRIBUTE_UNUSED = cache_entry->crack.X.frT = (cpu_registers(processor)->fpr + FRT); /* in icache - extraction */
#line 63 "../../../sim/ppc/powerpc.igen"
    uint32_t const FRT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.FRT_BITMASK = (1 << FRT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24127 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_FloatingPoint_Single_Indexed;

    /* semantic routine */
#line 3477 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Floating-Point Single Indexed\n"));
#line 24137 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_FloatingPoint_Single_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3477 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *frT = DOUBLE(MEM(unsigned, EA, 4));
      PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24156 "icache.c"
    return nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #undef get-values-from-icache|put-values-in-icache */
#undef FRT
#undef RA_is_0
#line 24161 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Right_Word_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc0
#line 3271 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Right Word\n"));
#line 24180 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000430)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3271 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 24210 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Right_Word_Rc0;

    /* semantic routine */
#line 3271 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 24220 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Right_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3271 "../../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source >> n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu, \
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 24245 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24249 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Right_Word_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc1
#line 3271 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Right Word\n"));
#line 24268 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000430)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3271 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 24298 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Right_Word_Rc1;

    /* semantic routine */
#line 3271 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 24308 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Right_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3271 "../../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source >> n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu, \
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 24333 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24337 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE1_Rc0(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc0
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 24356 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 24388 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE1_Rc0;

    /* semantic routine */
#line 2542 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 24398 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 24416 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24420 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE1_Rc1(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc1
#line 2542 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 24439 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2542 "../../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 24471 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE1_Rc1;

    /* semantic routine */
#line 2542 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 24481 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 24499 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24503 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_TLB_Synchronize(cpu *processor,
                       instruction_word instruction,
                       unsigned_word cia,
                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Synchronize
#undef MY_PREFIX
#define MY_PREFIX TLB_Synchronize
#line 5010 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode TLB Synchronize\n"));
#line 24522 "icache.c"

  /* validate: 0.31,6./,11./,16./,21.566,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x7c00046c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11./,16./,21.566,31./ #define get-values-from-icache|put-values-in-icache */
#line 24531 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_TLB_Synchronize;

    /* semantic routine */
#line 5010 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics TLB Synchronize\n"));
#line 24541 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_TLB_Synchronize, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 5010 "../../../sim/ppc/powerpc.igen"
    {
      /* nothing happens here - always in sync */
    }
#line 24554 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11./,16./,21.566,31./ #undef get-values-from-icache|put-values-in-icache */
#line 24557 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_FloatingPoint_Single_with_Update_Indexed(cpu *processor,
                                                     instruction_word instruction,
                                                     unsigned_word cia,
                                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_with_Update_Indexed
#line 3504 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Floating-Point Single with Update Indexed\n"));
#line 24576 "icache.c"

  /* validate: 0.31,6.FRT,11.RA,16.RB,21.567,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00046e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP hardware exists */
  if (CURRENT_FLOATING_POINT != HARD_FLOATING_POINT)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP available according to MSR[FP] */
  if (!IS_FP_AVAILABLE(processor))
    return icache_floating_point_unavailable(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #define get-values-from-icache|put-values-in-icache */
#define FRT EXTRACTED32(instruction, 6, 10) /* icache scratch - extraction */
#line 62 "../../../sim/ppc/powerpc.igen"
    uint64_t * const frT ATTRIBUTE_UNUSED = cache_entry->crack.X.frT = (cpu_registers(processor)->fpr + FRT); /* in icache - extraction */
#line 63 "../../../sim/ppc/powerpc.igen"
    uint32_t const FRT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.FRT_BITMASK = (1 << FRT); /* in icache - extraction */
#line 36 "../../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24611 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_FloatingPoint_Single_with_Update_Indexed;

    /* semantic routine */
#line 3504 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Floating-Point Single with Update Indexed\n"));
#line 24621 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_FloatingPoint_Single_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3504 "../../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *frT = DOUBLE(MEM(unsigned, EA, 4));
      *rA = EA;
      PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24641 "icache.c"
    return nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #undef get-values-from-icache|put-values-in-icache */
#undef FRT
#undef RA_is_0
#line 24646 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Segment_Register(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Segment_Register
#line 4953 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Segment Register\n"));
#line 24665 "icache.c"

  /* validate: 0.31,6.RT,11./,12.SR,16./,21.595,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc10ffff) != 0x7c0004a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 4953 "../../../sim/ppc/powerpc.igen"
    unsigned const SR ATTRIBUTE_UNUSED = cache_entry->crack.X.SR = EXTRACTED32(instruction, 12, 15); /* default in icache - extraction */
#line 24682 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Segment_Register;

    /* semantic routine */
#line 4953 "../../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Segment Register\n"));
#line 24692 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Segment_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4953 "../../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        *rT = SEGREG(SR);
    }
#line 24709 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #undef get-values-from-icache|put-values-in-icache */
#line 24712 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_String_Word_Immediate(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Immediate
#line 2296 "../../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load String Word Immediate\n"));
#line 24731 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.NB,21.597,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0004aa)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = ca