
/*  This file is part of the program psim.

    Copyright (C) 1994-1995, Andrew Cagney <cagney@highland.com.au>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see <http://www.gnu.org/licenses/>.

    --

    This file was generated by the program igen */

#ifndef _MODEL_H_
#define _MODEL_H_

#line 90 "../../../sim/ppc/powerpc.igen"
#define PPC_INSN_INT(OUT_MASK, IN_MASK, RC) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) { \
	    if (RC) \
	      ppc_insn_int_cr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK, 1 << 0); \
	    else \
	      ppc_insn_int(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK); \
	  } \
	} while (0)

#define PPC_INSN_INT_CR(OUT_MASK, IN_MASK, CR_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_int_cr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK, CR_MASK); \
	} while (0)

#define PPC_INSN_CR(OUT_MASK, IN_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_cr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK); \
	} while (0)

#define PPC_INSN_FLOAT(OUT_MASK, IN_MASK, RC) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) { \
	    if (RC) \
	      ppc_insn_float(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK); \
	    else \
	      ppc_insn_float_cr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK, 1 << 0); \
	  } \
	} while (0)

#define PPC_INSN_FLOAT_CR(OUT_MASK, IN_MASK, CR_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_float_cr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK, CR_MASK); \
	} while (0)

#define PPC_INSN_INT_FLOAT(OUT_INT_MASK, OUT_FP_MASK, IN_INT_MASK, IN_FP_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_int_float(MY_INDEX, cpu_model(processor), OUT_INT_MASK, OUT_FP_MASK, IN_INT_MASK, IN_FP_MASK); \
	} while (0)

#define PPC_INSN_FROM_SPR(INT_MASK, SPR) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_from_spr(MY_INDEX, cpu_model(processor), INT_MASK, SPR); \
	} while (0)

#define PPC_INSN_TO_SPR(INT_MASK, SPR) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_to_spr(MY_INDEX, cpu_model(processor), INT_MASK, SPR); \
	} while (0)

#define PPC_INSN_MFCR(INT_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_mfcr(MY_INDEX, cpu_model(processor), INT_MASK); \
	} while (0)

#define PPC_INSN_MTCR(INT_MASK, FXM) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_mtcr(MY_INDEX, cpu_model(processor), INT_MASK, FXM); \
	} while (0)
#line 95 "model.h"

#line 42 "../../../sim/ppc/altivec.igen"
#define PPC_INSN_INT_VR(OUT_MASK, IN_MASK, OUT_VMASK, IN_VMASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_int_vr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK, OUT_VMASK, IN_VMASK); \
	} while (0)

#define PPC_INSN_VR(OUT_VMASK, IN_VMASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_vr(MY_INDEX, cpu_model(processor), OUT_VMASK, IN_VMASK); \
	} while (0)

#define PPC_INSN_VR_CR(OUT_VMASK, IN_VMASK, CR_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_vr_cr(MY_INDEX, cpu_model(processor), OUT_VMASK, IN_VMASK, CR_MASK); \
	} while (0)

#define PPC_INSN_VR_VSCR(OUT_VMASK, IN_VMASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_vr_vscr(MY_INDEX, cpu_model(processor), OUT_VMASK, IN_VMASK); \
	} while (0)

#define PPC_INSN_FROM_VSCR(VR_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_from_vscr(MY_INDEX, cpu_model(processor), VR_MASK); \
	} while (0)

#define PPC_INSN_TO_VSCR(VR_MASK) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_to_vscr(MY_INDEX, cpu_model(processor), VR_MASK); \
	} while (0)
#line 133 "model.h"

#line 32 "../../../sim/ppc/e500.igen"
#define PPC_INSN_INT_SPR(OUT_MASK, IN_MASK, SPR) \
	do { \
	  if (CURRENT_MODEL_ISSUE > 0) \
	    ppc_insn_int_spr(MY_INDEX, cpu_model(processor), OUT_MASK, IN_MASK, SPR); \
	} while (0)
#line 141 "model.h"

typedef enum _model_enum {
  MODEL_NONE,
  MODEL_ppc604,
  MODEL_ppc603e,
  MODEL_ppc603,
  MODEL_ppc601,
  nr_models
} model_enum;

#define DEFAULT_MODEL MODEL_ppc604

typedef struct _model_data model_data;
typedef struct _model_time model_time;

extern model_enum current_model;
extern const char *model_name[ (int)nr_models ];
extern const char *const *const model_func_unit_name[ (int)nr_models ];
extern const model_time *const model_time_mapping[ (int)nr_models ];


INLINE_MODEL\
(void) model_serialize
(itable_index index, model_data *model_ptr);


INLINE_MODEL\
(void) model_wait_for_cr
(model_data *model_ptr, unsigned CRBIT);


INLINE_MODEL\
(void) ppc_insn_int
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask);


INLINE_MODEL\
(void) ppc_insn_int_cr
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask, const uint32_t cr_mask);


INLINE_MODEL\
(void) ppc_insn_cr
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask);


INLINE_MODEL\
(void) ppc_insn_float
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask);


INLINE_MODEL\
(void) ppc_insn_float_cr
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask, const uint32_t cr_mask);


INLINE_MODEL\
(void) ppc_insn_int_float
(itable_index index, model_data *model_ptr, const uint32_t out_int_mask, const uint32_t out_fp_mask, const uint32_t in_int_mask, const uint32_t in_fp_mask);


INLINE_MODEL\
(void) ppc_insn_from_spr
(itable_index index, model_data *model_ptr, const uint32_t int_mask, const unsigned nSPR);


INLINE_MODEL\
(void) ppc_insn_to_spr
(itable_index index, model_data *model_ptr, const uint32_t int_mask, const unsigned nSPR);


INLINE_MODEL\
(void) ppc_insn_mfcr
(itable_index index, model_data *model_ptr, uint32_t int_mask);


INLINE_MODEL\
(void) ppc_insn_mtcr
(itable_index index, model_data *model_ptr, uint32_t int_mask, unsigned FXM);


INLINE_MODEL\
(model_data *) model_create
(cpu *processor);


INLINE_MODEL\
(void) model_init
(model_data *model_ptr);


INLINE_MODEL\
(void) model_halt
(model_data *model_ptr);


INLINE_MODEL\
(unsigned_word) model_get_number_of_stalls
(model_data *model_ptr);


INLINE_MODEL\
(unsigned_word) model_get_number_of_cycles
(model_data *model_ptr);


INLINE_MODEL\
(model_print *) model_mon_info
(model_data *model_ptr);


INLINE_MODEL\
(void) model_mon_info_free
(model_data *model_ptr, model_print *ptr);


INLINE_MODEL\
(void) model_branches
(model_data *model_ptr, int failed, int conditional);


INLINE_MODEL\
(void) model_branch_predict
(model_data *model_ptr, int success);


INLINE_MODEL\
(void) ppc_insn_int_vr
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask, const uint32_t out_vmask, const uint32_t in_vmask);


INLINE_MODEL\
(void) ppc_insn_vr
(itable_index index, model_data *model_ptr, const uint32_t out_vmask, const uint32_t in_vmask);


INLINE_MODEL\
(void) ppc_insn_vr_cr
(itable_index index, model_data *model_ptr, const uint32_t out_vmask, const uint32_t in_vmask, const uint32_t cr_mask);


INLINE_MODEL\
(void) ppc_insn_vr_vscr
(itable_index index, model_data *model_ptr, const uint32_t out_vmask, const uint32_t in_vmask);


INLINE_MODEL\
(void) ppc_insn_from_vscr
(itable_index index, model_data *model_ptr, const uint32_t vr_mask);


INLINE_MODEL\
(void) ppc_insn_to_vscr
(itable_index index, model_data *model_ptr, const uint32_t vr_mask);


INLINE_MODEL\
(int8_t) altivec_signed_saturate_8
(int16_t val, int *sat);


INLINE_MODEL\
(int16_t) altivec_signed_saturate_16
(int32_t val, int *sat);


INLINE_MODEL\
(int32_t) altivec_signed_saturate_32
(int64_t val, int *sat);


INLINE_MODEL\
(uint8_t) altivec_unsigned_saturate_8
(int16_t val, int *sat);


INLINE_MODEL\
(uint16_t) altivec_unsigned_saturate_16
(int32_t val, int *sat);


INLINE_MODEL\
(uint32_t) altivec_unsigned_saturate_32
(int64_t val, int *sat);


INLINE_MODEL\
(void) ppc_insn_int_spr
(itable_index index, model_data *model_ptr, const uint32_t out_mask, const uint32_t in_mask, const unsigned nSPR);

INLINE_MODEL\
(void) model_set
(const char *name);

#endif /* _MODEL_H_*/
